/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, dtv, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_dtv_dvbs2_modulator_bc = R"doc(Modulates DVB-S2 frames.

Input: Bit interleaved baseband frames. 
Output: QPSK, 8PSK, 16APSK or 32APSK modulated complex IQ values (XFECFRAME).

Constructor Specific Documentation:

Create a DVB-S2 constellation modulator.

Args:
    framesize : FEC frame size (normal or short).
    rate : FEC code rate.
    constellation : DVB-S2 constellation.
    interpolation : 2X zero stuffing interpolation (on/off).)doc";


static const char* __doc_gr_dtv_dvbs2_modulator_bc_dvbs2_modulator_bc = R"doc()doc";


static const char* __doc_gr_dtv_dvbs2_modulator_bc_make = R"doc(Modulates DVB-S2 frames.

Input: Bit interleaved baseband frames. 
Output: QPSK, 8PSK, 16APSK or 32APSK modulated complex IQ values (XFECFRAME).

Constructor Specific Documentation:

Create a DVB-S2 constellation modulator.

Args:
    framesize : FEC frame size (normal or short).
    rate : FEC code rate.
    constellation : DVB-S2 constellation.
    interpolation : 2X zero stuffing interpolation (on/off).)doc";
