{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GListModel@ is an interface that represents a mutable list of
-- t'GI.GObject.Objects.Object.Object'. Its main intention is as a model for various widgets
-- in user interfaces, such as list views, but it can also be used as a
-- convenient method of returning lists of data, with support for
-- updates.
-- 
-- Each object in the list may also report changes in itself via some
-- mechanism (normally the [Object::notify]("GI.GObject.Objects.Object#g:signal:notify") signal).  Taken
-- together with the [ListModel::itemsChanged]("GI.Gio.Interfaces.ListModel#g:signal:itemsChanged") signal, this provides
-- for a list that can change its membership, and in which the members can
-- change their individual properties.
-- 
-- A good example would be the list of visible wireless network access
-- points, where each access point can report dynamic properties such as
-- signal strength.
-- 
-- It is important to note that the @GListModel@ itself does not report
-- changes to the individual items.  It only reports changes to the list
-- membership.  If you want to observe changes to the objects themselves
-- then you need to connect signals to the objects that you are
-- interested in.
-- 
-- All items in a @GListModel@ are of (or derived from) the same type.
-- 'GI.Gio.Interfaces.ListModel.listModelGetItemType' returns that type.  The type may be an
-- interface, in which case all objects in the list must implement it.
-- 
-- The semantics are close to that of an array:
-- 'GI.Gio.Interfaces.ListModel.listModelGetNItems' returns the number of items in the list
-- and 'GI.Gio.Interfaces.ListModel.listModelGetItem' returns an item at a (0-based) position.
-- In order to allow implementations to calculate the list length lazily,
-- you can also iterate over items: starting from 0, repeatedly call
-- 'GI.Gio.Interfaces.ListModel.listModelGetItem' until it returns @NULL@.
-- 
-- An implementation may create objects lazily, but must take care to
-- return the same object for a given position until all references to
-- it are gone.
-- 
-- On the other side, a consumer is expected only to hold references on
-- objects that are currently ‘user visible’, in order to facilitate the
-- maximum level of laziness in the implementation of the list and to
-- reduce the required number of signal connections at a given time.
-- 
-- This interface is intended only to be used from a single thread.  The
-- thread in which it is appropriate to use it depends on the particular
-- implementation, but typically it will be from the thread that owns
-- the thread-default main context (see
-- 'GI.GLib.Structs.MainContext.mainContextPushThreadDefault') in effect at the time that the
-- model was created.
-- 
-- Over time, it has established itself as good practice for list model
-- implementations to provide properties @item-type@ and @n-items@ to
-- ease working with them. While it is not required, it is recommended
-- that implementations provide these two properties. They should return
-- the values of 'GI.Gio.Interfaces.ListModel.listModelGetItemType' and
-- 'GI.Gio.Interfaces.ListModel.listModelGetNItems' respectively and be defined as such:
-- 
-- 
-- === /c code/
-- >properties[PROP_ITEM_TYPE] =
-- >  g_param_spec_gtype ("item-type", NULL, NULL, G_TYPE_OBJECT,
-- >                      G_PARAM_CONSTRUCT_ONLY | G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS);
-- >properties[PROP_N_ITEMS] =
-- >  g_param_spec_uint ("n-items", NULL, NULL, 0, G_MAXUINT, 0,
-- >                     G_PARAM_READABLE | G_PARAM_STATIC_STRINGS);
-- 

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Interfaces.ListModel
    ( 

-- * Exported types
    ListModel(..)                           ,
    IsListModel                             ,
    toListModel                             ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [itemsChanged]("GI.Gio.Interfaces.ListModel#g:method:itemsChanged"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getItem]("GI.Gio.Interfaces.ListModel#g:method:getItem"), [getItemType]("GI.Gio.Interfaces.ListModel#g:method:getItemType"), [getNItems]("GI.Gio.Interfaces.ListModel#g:method:getNItems"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveListModelMethod                  ,
#endif

-- ** getItem #method:getItem#

#if defined(ENABLE_OVERLOADING)
    ListModelGetItemMethodInfo              ,
#endif
    listModelGetItem                        ,


-- ** getItemType #method:getItemType#

#if defined(ENABLE_OVERLOADING)
    ListModelGetItemTypeMethodInfo          ,
#endif
    listModelGetItemType                    ,


-- ** getNItems #method:getNItems#

#if defined(ENABLE_OVERLOADING)
    ListModelGetNItemsMethodInfo            ,
#endif
    listModelGetNItems                      ,


-- ** itemsChanged #method:itemsChanged#

#if defined(ENABLE_OVERLOADING)
    ListModelItemsChangedMethodInfo         ,
#endif
    listModelItemsChanged                   ,




 -- * Signals


-- ** itemsChanged #signal:itemsChanged#

    ListModelItemsChangedCallback           ,
#if defined(ENABLE_OVERLOADING)
    ListModelItemsChangedSignalInfo         ,
#endif
    afterListModelItemsChanged              ,
    onListModelItemsChanged                 ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object

#else
import qualified GI.GObject.Objects.Object as GObject.Object

#endif

-- interface ListModel 
-- | Memory-managed wrapper type.
newtype ListModel = ListModel (SP.ManagedPtr ListModel)
    deriving (Eq)

instance SP.ManagedPtrNewtype ListModel where
    toManagedPtr (ListModel p) = p

foreign import ccall "g_list_model_get_type"
    c_g_list_model_get_type :: IO B.Types.GType

instance B.Types.TypedObject ListModel where
    glibType = c_g_list_model_get_type

instance B.Types.GObject ListModel

-- | Type class for types which can be safely cast to t'ListModel', for instance with `toListModel`.
class (SP.GObject o, O.IsDescendantOf ListModel o) => IsListModel o
instance (SP.GObject o, O.IsDescendantOf ListModel o) => IsListModel o

instance O.HasParentTypes ListModel
type instance O.ParentTypes ListModel = '[GObject.Object.Object]

-- | Cast to t'ListModel', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toListModel :: (MIO.MonadIO m, IsListModel o) => o -> m ListModel
toListModel = MIO.liftIO . B.ManagedPtr.unsafeCastTo ListModel

-- | Convert t'ListModel' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ListModel) where
    gvalueGType_ = c_g_list_model_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr ListModel)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr ListModel)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject ListModel ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ListModel
type instance O.AttributeList ListModel = ListModelAttributeList
type ListModelAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveListModelMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveListModelMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveListModelMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveListModelMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveListModelMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveListModelMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveListModelMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveListModelMethod "itemsChanged" o = ListModelItemsChangedMethodInfo
    ResolveListModelMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveListModelMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveListModelMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveListModelMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveListModelMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveListModelMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveListModelMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveListModelMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveListModelMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveListModelMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveListModelMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveListModelMethod "getItem" o = ListModelGetItemMethodInfo
    ResolveListModelMethod "getItemType" o = ListModelGetItemTypeMethodInfo
    ResolveListModelMethod "getNItems" o = ListModelGetNItemsMethodInfo
    ResolveListModelMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveListModelMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveListModelMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveListModelMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveListModelMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveListModelMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveListModelMethod t ListModel, O.OverloadedMethod info ListModel p) => OL.IsLabel t (ListModel -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveListModelMethod t ListModel, O.OverloadedMethod info ListModel p, R.HasField t ListModel p) => R.HasField t ListModel p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveListModelMethod t ListModel, O.OverloadedMethodInfo info ListModel) => OL.IsLabel t (O.MethodProxy info ListModel) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- method ListModel::get_item_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "list"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "ListModel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GListModel" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TGType)
-- throws : False
-- Skip return : False

foreign import ccall "g_list_model_get_item_type" g_list_model_get_item_type :: 
    Ptr ListModel ->                        -- list : TInterface (Name {namespace = "Gio", name = "ListModel"})
    IO CGType

-- | Gets the type of the items in /@list@/.
-- 
-- All items returned from @/g_list_model_get_item()/@ are of the type
-- returned by this function, or a subtype, or if the type is an
-- interface, they are an implementation of that interface.
-- 
-- The item type of a t'GI.Gio.Interfaces.ListModel.ListModel' can not change during the life of the
-- model.
-- 
-- /Since: 2.44/
listModelGetItemType ::
    (B.CallStack.HasCallStack, MonadIO m, IsListModel a) =>
    a
    -- ^ /@list@/: a t'GI.Gio.Interfaces.ListModel.ListModel'
    -> m GType
    -- ^ __Returns:__ the t'GType' of the items contained in /@list@/.
listModelGetItemType list = liftIO $ do
    list' <- unsafeManagedPtrCastPtr list
    result <- g_list_model_get_item_type list'
    let result' = GType result
    touchManagedPtr list
    return result'

#if defined(ENABLE_OVERLOADING)
data ListModelGetItemTypeMethodInfo
instance (signature ~ (m GType), MonadIO m, IsListModel a) => O.OverloadedMethod ListModelGetItemTypeMethodInfo a signature where
    overloadedMethod = listModelGetItemType

instance O.OverloadedMethodInfo ListModelGetItemTypeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.ListModel.listModelGetItemType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Interfaces-ListModel.html#v:listModelGetItemType"
        })


#endif

-- method ListModel::get_n_items
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "list"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "ListModel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GListModel" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_list_model_get_n_items" g_list_model_get_n_items :: 
    Ptr ListModel ->                        -- list : TInterface (Name {namespace = "Gio", name = "ListModel"})
    IO Word32

-- | Gets the number of items in /@list@/.
-- 
-- Depending on the model implementation, calling this function may be
-- less efficient than iterating the list with increasing values for
-- /@position@/ until @/g_list_model_get_item()/@ returns 'P.Nothing'.
-- 
-- /Since: 2.44/
listModelGetNItems ::
    (B.CallStack.HasCallStack, MonadIO m, IsListModel a) =>
    a
    -- ^ /@list@/: a t'GI.Gio.Interfaces.ListModel.ListModel'
    -> m Word32
    -- ^ __Returns:__ the number of items in /@list@/.
listModelGetNItems list = liftIO $ do
    list' <- unsafeManagedPtrCastPtr list
    result <- g_list_model_get_n_items list'
    touchManagedPtr list
    return result

#if defined(ENABLE_OVERLOADING)
data ListModelGetNItemsMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsListModel a) => O.OverloadedMethod ListModelGetNItemsMethodInfo a signature where
    overloadedMethod = listModelGetNItems

instance O.OverloadedMethodInfo ListModelGetNItemsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.ListModel.listModelGetNItems",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Interfaces-ListModel.html#v:listModelGetNItems"
        })


#endif

-- method ListModel::get_item
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "list"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "ListModel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GListModel" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "position"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the position of the item to fetch"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GObject" , name = "Object" })
-- throws : False
-- Skip return : False

foreign import ccall "g_list_model_get_object" g_list_model_get_object :: 
    Ptr ListModel ->                        -- list : TInterface (Name {namespace = "Gio", name = "ListModel"})
    Word32 ->                               -- position : TBasicType TUInt
    IO (Ptr GObject.Object.Object)

-- | Get the item at /@position@/.
-- 
-- If /@position@/ is greater than the number of items in /@list@/, 'P.Nothing' is
-- returned.
-- 
-- 'P.Nothing' is never returned for an index that is smaller than the length
-- of the list.
-- 
-- This function is meant to be used by language bindings in place
-- of @/g_list_model_get_item()/@.
-- 
-- See also: 'GI.Gio.Interfaces.ListModel.listModelGetNItems'
-- 
-- /Since: 2.44/
listModelGetItem ::
    (B.CallStack.HasCallStack, MonadIO m, IsListModel a) =>
    a
    -- ^ /@list@/: a t'GI.Gio.Interfaces.ListModel.ListModel'
    -> Word32
    -- ^ /@position@/: the position of the item to fetch
    -> m (Maybe GObject.Object.Object)
    -- ^ __Returns:__ the object at /@position@/.
listModelGetItem list position = liftIO $ do
    list' <- unsafeManagedPtrCastPtr list
    result <- g_list_model_get_object list' position
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject GObject.Object.Object) result'
        return result''
    touchManagedPtr list
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ListModelGetItemMethodInfo
instance (signature ~ (Word32 -> m (Maybe GObject.Object.Object)), MonadIO m, IsListModel a) => O.OverloadedMethod ListModelGetItemMethodInfo a signature where
    overloadedMethod = listModelGetItem

instance O.OverloadedMethodInfo ListModelGetItemMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.ListModel.listModelGetItem",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Interfaces-ListModel.html#v:listModelGetItem"
        })


#endif

-- method ListModel::items_changed
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "list"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "ListModel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GListModel" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "position"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the position at which @list changed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "removed"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of items removed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "added"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of items added"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_list_model_items_changed" g_list_model_items_changed :: 
    Ptr ListModel ->                        -- list : TInterface (Name {namespace = "Gio", name = "ListModel"})
    Word32 ->                               -- position : TBasicType TUInt
    Word32 ->                               -- removed : TBasicType TUInt
    Word32 ->                               -- added : TBasicType TUInt
    IO ()

-- | Emits the [ListModel::itemsChanged]("GI.Gio.Interfaces.ListModel#g:signal:itemsChanged") signal on /@list@/.
-- 
-- This function should only be called by classes implementing
-- t'GI.Gio.Interfaces.ListModel.ListModel'. It has to be called after the internal representation
-- of /@list@/ has been updated, because handlers connected to this signal
-- might query the new state of the list.
-- 
-- Implementations must only make changes to the model (as visible to
-- its consumer) in places that will not cause problems for that
-- consumer.  For models that are driven directly by a write API (such
-- as t'GI.Gio.Objects.ListStore.ListStore'), changes can be reported in response to uses of that
-- API.  For models that represent remote data, changes should only be
-- made from a fresh mainloop dispatch.  It is particularly not
-- permitted to make changes in response to a call to the t'GI.Gio.Interfaces.ListModel.ListModel'
-- consumer API.
-- 
-- Stated another way: in general, it is assumed that code making a
-- series of accesses to the model via the API, without returning to the
-- mainloop, and without calling other code, will continue to view the
-- same contents of the model.
-- 
-- /Since: 2.44/
listModelItemsChanged ::
    (B.CallStack.HasCallStack, MonadIO m, IsListModel a) =>
    a
    -- ^ /@list@/: a t'GI.Gio.Interfaces.ListModel.ListModel'
    -> Word32
    -- ^ /@position@/: the position at which /@list@/ changed
    -> Word32
    -- ^ /@removed@/: the number of items removed
    -> Word32
    -- ^ /@added@/: the number of items added
    -> m ()
listModelItemsChanged list position removed added = liftIO $ do
    list' <- unsafeManagedPtrCastPtr list
    g_list_model_items_changed list' position removed added
    touchManagedPtr list
    return ()

#if defined(ENABLE_OVERLOADING)
data ListModelItemsChangedMethodInfo
instance (signature ~ (Word32 -> Word32 -> Word32 -> m ()), MonadIO m, IsListModel a) => O.OverloadedMethod ListModelItemsChangedMethodInfo a signature where
    overloadedMethod = listModelItemsChanged

instance O.OverloadedMethodInfo ListModelItemsChangedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.ListModel.listModelItemsChanged",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Interfaces-ListModel.html#v:listModelItemsChanged"
        })


#endif

-- signal ListModel::items-changed
-- | This signal is emitted whenever items were added to or removed
-- from /@list@/. At /@position@/, /@removed@/ items were removed and /@added@/
-- items were added in their place.
-- 
-- Note: If @removed != added@, the positions of all later items
-- in the model change.
-- 
-- /Since: 2.44/
type ListModelItemsChangedCallback =
    Word32
    -- ^ /@position@/: the position at which /@list@/ changed
    -> Word32
    -- ^ /@removed@/: the number of items removed
    -> Word32
    -- ^ /@added@/: the number of items added
    -> IO ()

type C_ListModelItemsChangedCallback =
    Ptr ListModel ->                        -- object
    Word32 ->
    Word32 ->
    Word32 ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ListModelItemsChangedCallback`.
foreign import ccall "wrapper"
    mk_ListModelItemsChangedCallback :: C_ListModelItemsChangedCallback -> IO (FunPtr C_ListModelItemsChangedCallback)

wrap_ListModelItemsChangedCallback :: 
    GObject a => (a -> ListModelItemsChangedCallback) ->
    C_ListModelItemsChangedCallback
wrap_ListModelItemsChangedCallback gi'cb gi'selfPtr position removed added _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  position removed added


-- | Connect a signal handler for the [itemsChanged](#signal:itemsChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' listModel #itemsChanged callback
-- @
-- 
-- 
onListModelItemsChanged :: (IsListModel a, MonadIO m) => a -> ((?self :: a) => ListModelItemsChangedCallback) -> m SignalHandlerId
onListModelItemsChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ListModelItemsChangedCallback wrapped
    wrapped'' <- mk_ListModelItemsChangedCallback wrapped'
    connectSignalFunPtr obj "items-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [itemsChanged](#signal:itemsChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' listModel #itemsChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterListModelItemsChanged :: (IsListModel a, MonadIO m) => a -> ((?self :: a) => ListModelItemsChangedCallback) -> m SignalHandlerId
afterListModelItemsChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ListModelItemsChangedCallback wrapped
    wrapped'' <- mk_ListModelItemsChangedCallback wrapped'
    connectSignalFunPtr obj "items-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ListModelItemsChangedSignalInfo
instance SignalInfo ListModelItemsChangedSignalInfo where
    type HaskellCallbackType ListModelItemsChangedSignalInfo = ListModelItemsChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ListModelItemsChangedCallback cb
        cb'' <- mk_ListModelItemsChangedCallback cb'
        connectSignalFunPtr obj "items-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.ListModel::items-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Interfaces-ListModel.html#g:signal:itemsChanged"})

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList ListModel = ListModelSignalList
type ListModelSignalList = ('[ '("itemsChanged", ListModelItemsChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif


