{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GInetAddress@ represents an IPv4 or IPv6 internet address. Use
-- 'GI.Gio.Objects.Resolver.resolverLookupByName' or
-- 'GI.Gio.Objects.Resolver.resolverLookupByNameAsync' to look up the @GInetAddress@ for
-- a hostname. Use 'GI.Gio.Objects.Resolver.resolverLookupByAddress' or
-- 'GI.Gio.Objects.Resolver.resolverLookupByAddressAsync' to look up the hostname for a
-- @GInetAddress@.
-- 
-- To actually connect to a remote host, you will need a
-- t'GI.Gio.Objects.InetSocketAddress.InetSocketAddress' (which includes a @GInetAddress@ as well as a
-- port number).

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.InetAddress
    ( 

-- * Exported types
    InetAddress(..)                         ,
    IsInetAddress                           ,
    toInetAddress                           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [equal]("GI.Gio.Objects.InetAddress#g:method:equal"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [toString]("GI.Gio.Objects.InetAddress#g:method:toString"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getFamily]("GI.Gio.Objects.InetAddress#g:method:getFamily"), [getFlowinfo]("GI.Gio.Objects.InetAddress#g:method:getFlowinfo"), [getIsAny]("GI.Gio.Objects.InetAddress#g:method:getIsAny"), [getIsLinkLocal]("GI.Gio.Objects.InetAddress#g:method:getIsLinkLocal"), [getIsLoopback]("GI.Gio.Objects.InetAddress#g:method:getIsLoopback"), [getIsMcGlobal]("GI.Gio.Objects.InetAddress#g:method:getIsMcGlobal"), [getIsMcLinkLocal]("GI.Gio.Objects.InetAddress#g:method:getIsMcLinkLocal"), [getIsMcNodeLocal]("GI.Gio.Objects.InetAddress#g:method:getIsMcNodeLocal"), [getIsMcOrgLocal]("GI.Gio.Objects.InetAddress#g:method:getIsMcOrgLocal"), [getIsMcSiteLocal]("GI.Gio.Objects.InetAddress#g:method:getIsMcSiteLocal"), [getIsMulticast]("GI.Gio.Objects.InetAddress#g:method:getIsMulticast"), [getIsSiteLocal]("GI.Gio.Objects.InetAddress#g:method:getIsSiteLocal"), [getNativeSize]("GI.Gio.Objects.InetAddress#g:method:getNativeSize"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getScopeId]("GI.Gio.Objects.InetAddress#g:method:getScopeId").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveInetAddressMethod                ,
#endif

-- ** equal #method:equal#

#if defined(ENABLE_OVERLOADING)
    InetAddressEqualMethodInfo              ,
#endif
    inetAddressEqual                        ,


-- ** getFamily #method:getFamily#

#if defined(ENABLE_OVERLOADING)
    InetAddressGetFamilyMethodInfo          ,
#endif
    inetAddressGetFamily                    ,


-- ** getFlowinfo #method:getFlowinfo#

#if defined(ENABLE_OVERLOADING)
    InetAddressGetFlowinfoMethodInfo        ,
#endif
    inetAddressGetFlowinfo                  ,


-- ** getIsAny #method:getIsAny#

#if defined(ENABLE_OVERLOADING)
    InetAddressGetIsAnyMethodInfo           ,
#endif
    inetAddressGetIsAny                     ,


-- ** getIsLinkLocal #method:getIsLinkLocal#

#if defined(ENABLE_OVERLOADING)
    InetAddressGetIsLinkLocalMethodInfo     ,
#endif
    inetAddressGetIsLinkLocal               ,


-- ** getIsLoopback #method:getIsLoopback#

#if defined(ENABLE_OVERLOADING)
    InetAddressGetIsLoopbackMethodInfo      ,
#endif
    inetAddressGetIsLoopback                ,


-- ** getIsMcGlobal #method:getIsMcGlobal#

#if defined(ENABLE_OVERLOADING)
    InetAddressGetIsMcGlobalMethodInfo      ,
#endif
    inetAddressGetIsMcGlobal                ,


-- ** getIsMcLinkLocal #method:getIsMcLinkLocal#

#if defined(ENABLE_OVERLOADING)
    InetAddressGetIsMcLinkLocalMethodInfo   ,
#endif
    inetAddressGetIsMcLinkLocal             ,


-- ** getIsMcNodeLocal #method:getIsMcNodeLocal#

#if defined(ENABLE_OVERLOADING)
    InetAddressGetIsMcNodeLocalMethodInfo   ,
#endif
    inetAddressGetIsMcNodeLocal             ,


-- ** getIsMcOrgLocal #method:getIsMcOrgLocal#

#if defined(ENABLE_OVERLOADING)
    InetAddressGetIsMcOrgLocalMethodInfo    ,
#endif
    inetAddressGetIsMcOrgLocal              ,


-- ** getIsMcSiteLocal #method:getIsMcSiteLocal#

#if defined(ENABLE_OVERLOADING)
    InetAddressGetIsMcSiteLocalMethodInfo   ,
#endif
    inetAddressGetIsMcSiteLocal             ,


-- ** getIsMulticast #method:getIsMulticast#

#if defined(ENABLE_OVERLOADING)
    InetAddressGetIsMulticastMethodInfo     ,
#endif
    inetAddressGetIsMulticast               ,


-- ** getIsSiteLocal #method:getIsSiteLocal#

#if defined(ENABLE_OVERLOADING)
    InetAddressGetIsSiteLocalMethodInfo     ,
#endif
    inetAddressGetIsSiteLocal               ,


-- ** getNativeSize #method:getNativeSize#

#if defined(ENABLE_OVERLOADING)
    InetAddressGetNativeSizeMethodInfo      ,
#endif
    inetAddressGetNativeSize                ,


-- ** getScopeId #method:getScopeId#

#if defined(ENABLE_OVERLOADING)
    InetAddressGetScopeIdMethodInfo         ,
#endif
    inetAddressGetScopeId                   ,


-- ** newAny #method:newAny#

    inetAddressNewAny                       ,


-- ** newFromBytes #method:newFromBytes#

    inetAddressNewFromBytes                 ,


-- ** newFromBytesWithIpv6Info #method:newFromBytesWithIpv6Info#

    inetAddressNewFromBytesWithIpv6Info     ,


-- ** newFromString #method:newFromString#

    inetAddressNewFromString                ,


-- ** newLoopback #method:newLoopback#

    inetAddressNewLoopback                  ,


-- ** toString #method:toString#

#if defined(ENABLE_OVERLOADING)
    InetAddressToStringMethodInfo           ,
#endif
    inetAddressToString                     ,




 -- * Properties


-- ** bytes #attr:bytes#
-- | The raw address data.
-- 
-- /Since: 2.22/

#if defined(ENABLE_OVERLOADING)
    InetAddressBytesPropertyInfo            ,
#endif
    constructInetAddressBytes               ,
    getInetAddressBytes                     ,
#if defined(ENABLE_OVERLOADING)
    inetAddressBytes                        ,
#endif


-- ** family #attr:family#
-- | The address family (IPv4 or IPv6).
-- 
-- /Since: 2.22/

#if defined(ENABLE_OVERLOADING)
    InetAddressFamilyPropertyInfo           ,
#endif
    constructInetAddressFamily              ,
    getInetAddressFamily                    ,
#if defined(ENABLE_OVERLOADING)
    inetAddressFamily                       ,
#endif


-- ** flowinfo #attr:flowinfo#
-- | The flowinfo for an IPv6 address.
-- See 'GI.Gio.Objects.InetAddress.inetAddressGetFlowinfo'.
-- 
-- /Since: 2.86/

#if defined(ENABLE_OVERLOADING)
    InetAddressFlowinfoPropertyInfo         ,
#endif
    constructInetAddressFlowinfo            ,
    getInetAddressFlowinfo                  ,
#if defined(ENABLE_OVERLOADING)
    inetAddressFlowinfo                     ,
#endif


-- ** isAny #attr:isAny#
-- | Whether this is the \"any\" address for its family.
-- See 'GI.Gio.Objects.InetAddress.inetAddressGetIsAny'.
-- 
-- /Since: 2.22/

#if defined(ENABLE_OVERLOADING)
    InetAddressIsAnyPropertyInfo            ,
#endif
    getInetAddressIsAny                     ,
#if defined(ENABLE_OVERLOADING)
    inetAddressIsAny                        ,
#endif


-- ** isLinkLocal #attr:isLinkLocal#
-- | Whether this is a link-local address.
-- See 'GI.Gio.Objects.InetAddress.inetAddressGetIsLinkLocal'.
-- 
-- /Since: 2.22/

#if defined(ENABLE_OVERLOADING)
    InetAddressIsLinkLocalPropertyInfo      ,
#endif
    getInetAddressIsLinkLocal               ,
#if defined(ENABLE_OVERLOADING)
    inetAddressIsLinkLocal                  ,
#endif


-- ** isLoopback #attr:isLoopback#
-- | Whether this is the loopback address for its family.
-- See 'GI.Gio.Objects.InetAddress.inetAddressGetIsLoopback'.
-- 
-- /Since: 2.22/

#if defined(ENABLE_OVERLOADING)
    InetAddressIsLoopbackPropertyInfo       ,
#endif
    getInetAddressIsLoopback                ,
#if defined(ENABLE_OVERLOADING)
    inetAddressIsLoopback                   ,
#endif


-- ** isMcGlobal #attr:isMcGlobal#
-- | Whether this is a global multicast address.
-- See 'GI.Gio.Objects.InetAddress.inetAddressGetIsMcGlobal'.
-- 
-- /Since: 2.22/

#if defined(ENABLE_OVERLOADING)
    InetAddressIsMcGlobalPropertyInfo       ,
#endif
    getInetAddressIsMcGlobal                ,
#if defined(ENABLE_OVERLOADING)
    inetAddressIsMcGlobal                   ,
#endif


-- ** isMcLinkLocal #attr:isMcLinkLocal#
-- | Whether this is a link-local multicast address.
-- See 'GI.Gio.Objects.InetAddress.inetAddressGetIsMcLinkLocal'.
-- 
-- /Since: 2.22/

#if defined(ENABLE_OVERLOADING)
    InetAddressIsMcLinkLocalPropertyInfo    ,
#endif
    getInetAddressIsMcLinkLocal             ,
#if defined(ENABLE_OVERLOADING)
    inetAddressIsMcLinkLocal                ,
#endif


-- ** isMcNodeLocal #attr:isMcNodeLocal#
-- | Whether this is a node-local multicast address.
-- See 'GI.Gio.Objects.InetAddress.inetAddressGetIsMcNodeLocal'.
-- 
-- /Since: 2.22/

#if defined(ENABLE_OVERLOADING)
    InetAddressIsMcNodeLocalPropertyInfo    ,
#endif
    getInetAddressIsMcNodeLocal             ,
#if defined(ENABLE_OVERLOADING)
    inetAddressIsMcNodeLocal                ,
#endif


-- ** isMcOrgLocal #attr:isMcOrgLocal#
-- | Whether this is an organization-local multicast address.
-- See 'GI.Gio.Objects.InetAddress.inetAddressGetIsMcOrgLocal'.
-- 
-- /Since: 2.22/

#if defined(ENABLE_OVERLOADING)
    InetAddressIsMcOrgLocalPropertyInfo     ,
#endif
    getInetAddressIsMcOrgLocal              ,
#if defined(ENABLE_OVERLOADING)
    inetAddressIsMcOrgLocal                 ,
#endif


-- ** isMcSiteLocal #attr:isMcSiteLocal#
-- | Whether this is a site-local multicast address.
-- See 'GI.Gio.Objects.InetAddress.inetAddressGetIsMcSiteLocal'.
-- 
-- /Since: 2.22/

#if defined(ENABLE_OVERLOADING)
    InetAddressIsMcSiteLocalPropertyInfo    ,
#endif
    getInetAddressIsMcSiteLocal             ,
#if defined(ENABLE_OVERLOADING)
    inetAddressIsMcSiteLocal                ,
#endif


-- ** isMulticast #attr:isMulticast#
-- | Whether this is a multicast address.
-- See 'GI.Gio.Objects.InetAddress.inetAddressGetIsMulticast'.
-- 
-- /Since: 2.22/

#if defined(ENABLE_OVERLOADING)
    InetAddressIsMulticastPropertyInfo      ,
#endif
    getInetAddressIsMulticast               ,
#if defined(ENABLE_OVERLOADING)
    inetAddressIsMulticast                  ,
#endif


-- ** isSiteLocal #attr:isSiteLocal#
-- | Whether this is a site-local address.
-- See 'GI.Gio.Objects.InetAddress.inetAddressGetIsLoopback'.
-- 
-- /Since: 2.22/

#if defined(ENABLE_OVERLOADING)
    InetAddressIsSiteLocalPropertyInfo      ,
#endif
    getInetAddressIsSiteLocal               ,
#if defined(ENABLE_OVERLOADING)
    inetAddressIsSiteLocal                  ,
#endif


-- ** scopeId #attr:scopeId#
-- | The scope-id for an IPv6 address.
-- See 'GI.Gio.Objects.InetAddress.inetAddressGetScopeId'.
-- 
-- /Since: 2.86/

#if defined(ENABLE_OVERLOADING)
    InetAddressScopeIdPropertyInfo          ,
#endif
    constructInetAddressScopeId             ,
    getInetAddressScopeId                   ,
#if defined(ENABLE_OVERLOADING)
    inetAddressScopeId                      ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums

#endif

-- | Memory-managed wrapper type.
newtype InetAddress = InetAddress (SP.ManagedPtr InetAddress)
    deriving (Eq)

instance SP.ManagedPtrNewtype InetAddress where
    toManagedPtr (InetAddress p) = p

foreign import ccall "g_inet_address_get_type"
    c_g_inet_address_get_type :: IO B.Types.GType

instance B.Types.TypedObject InetAddress where
    glibType = c_g_inet_address_get_type

instance B.Types.GObject InetAddress

-- | Type class for types which can be safely cast to t'InetAddress', for instance with `toInetAddress`.
class (SP.GObject o, O.IsDescendantOf InetAddress o) => IsInetAddress o
instance (SP.GObject o, O.IsDescendantOf InetAddress o) => IsInetAddress o

instance O.HasParentTypes InetAddress
type instance O.ParentTypes InetAddress = '[GObject.Object.Object]

-- | Cast to t'InetAddress', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toInetAddress :: (MIO.MonadIO m, IsInetAddress o) => o -> m InetAddress
toInetAddress = MIO.liftIO . B.ManagedPtr.unsafeCastTo InetAddress

-- | Convert t'InetAddress' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe InetAddress) where
    gvalueGType_ = c_g_inet_address_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr InetAddress)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr InetAddress)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject InetAddress ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveInetAddressMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveInetAddressMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveInetAddressMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveInetAddressMethod "equal" o = InetAddressEqualMethodInfo
    ResolveInetAddressMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveInetAddressMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveInetAddressMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveInetAddressMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveInetAddressMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveInetAddressMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveInetAddressMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveInetAddressMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveInetAddressMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveInetAddressMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveInetAddressMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveInetAddressMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveInetAddressMethod "toString" o = InetAddressToStringMethodInfo
    ResolveInetAddressMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveInetAddressMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveInetAddressMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveInetAddressMethod "getFamily" o = InetAddressGetFamilyMethodInfo
    ResolveInetAddressMethod "getFlowinfo" o = InetAddressGetFlowinfoMethodInfo
    ResolveInetAddressMethod "getIsAny" o = InetAddressGetIsAnyMethodInfo
    ResolveInetAddressMethod "getIsLinkLocal" o = InetAddressGetIsLinkLocalMethodInfo
    ResolveInetAddressMethod "getIsLoopback" o = InetAddressGetIsLoopbackMethodInfo
    ResolveInetAddressMethod "getIsMcGlobal" o = InetAddressGetIsMcGlobalMethodInfo
    ResolveInetAddressMethod "getIsMcLinkLocal" o = InetAddressGetIsMcLinkLocalMethodInfo
    ResolveInetAddressMethod "getIsMcNodeLocal" o = InetAddressGetIsMcNodeLocalMethodInfo
    ResolveInetAddressMethod "getIsMcOrgLocal" o = InetAddressGetIsMcOrgLocalMethodInfo
    ResolveInetAddressMethod "getIsMcSiteLocal" o = InetAddressGetIsMcSiteLocalMethodInfo
    ResolveInetAddressMethod "getIsMulticast" o = InetAddressGetIsMulticastMethodInfo
    ResolveInetAddressMethod "getIsSiteLocal" o = InetAddressGetIsSiteLocalMethodInfo
    ResolveInetAddressMethod "getNativeSize" o = InetAddressGetNativeSizeMethodInfo
    ResolveInetAddressMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveInetAddressMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveInetAddressMethod "getScopeId" o = InetAddressGetScopeIdMethodInfo
    ResolveInetAddressMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveInetAddressMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveInetAddressMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveInetAddressMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveInetAddressMethod t InetAddress, O.OverloadedMethod info InetAddress p) => OL.IsLabel t (InetAddress -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveInetAddressMethod t InetAddress, O.OverloadedMethod info InetAddress p, R.HasField t InetAddress p) => R.HasField t InetAddress p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveInetAddressMethod t InetAddress, O.OverloadedMethodInfo info InetAddress) => OL.IsLabel t (O.MethodProxy info InetAddress) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "bytes"
   -- Type: TBasicType TPtr
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@bytes@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inetAddress #bytes
-- @
getInetAddressBytes :: (MonadIO m, IsInetAddress o) => o -> m (Ptr ())
getInetAddressBytes obj = MIO.liftIO $ B.Properties.getObjectPropertyPtr obj "bytes"

-- | Construct a t'GValueConstruct' with valid value for the “@bytes@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructInetAddressBytes :: (IsInetAddress o, MIO.MonadIO m) => Ptr () -> m (GValueConstruct o)
constructInetAddressBytes val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyPtr "bytes" val

#if defined(ENABLE_OVERLOADING)
data InetAddressBytesPropertyInfo
instance AttrInfo InetAddressBytesPropertyInfo where
    type AttrAllowedOps InetAddressBytesPropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint InetAddressBytesPropertyInfo = IsInetAddress
    type AttrSetTypeConstraint InetAddressBytesPropertyInfo = (~) (Ptr ())
    type AttrTransferTypeConstraint InetAddressBytesPropertyInfo = (~) (Ptr ())
    type AttrTransferType InetAddressBytesPropertyInfo = Ptr ()
    type AttrGetType InetAddressBytesPropertyInfo = (Ptr ())
    type AttrLabel InetAddressBytesPropertyInfo = "bytes"
    type AttrOrigin InetAddressBytesPropertyInfo = InetAddress
    attrGet = getInetAddressBytes
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructInetAddressBytes
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetAddress.bytes"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-InetAddress.html#g:attr:bytes"
        })
#endif

-- VVV Prop "family"
   -- Type: TInterface (Name {namespace = "Gio", name = "SocketFamily"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@family@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inetAddress #family
-- @
getInetAddressFamily :: (MonadIO m, IsInetAddress o) => o -> m Gio.Enums.SocketFamily
getInetAddressFamily obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "family"

-- | Construct a t'GValueConstruct' with valid value for the “@family@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructInetAddressFamily :: (IsInetAddress o, MIO.MonadIO m) => Gio.Enums.SocketFamily -> m (GValueConstruct o)
constructInetAddressFamily val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "family" val

#if defined(ENABLE_OVERLOADING)
data InetAddressFamilyPropertyInfo
instance AttrInfo InetAddressFamilyPropertyInfo where
    type AttrAllowedOps InetAddressFamilyPropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint InetAddressFamilyPropertyInfo = IsInetAddress
    type AttrSetTypeConstraint InetAddressFamilyPropertyInfo = (~) Gio.Enums.SocketFamily
    type AttrTransferTypeConstraint InetAddressFamilyPropertyInfo = (~) Gio.Enums.SocketFamily
    type AttrTransferType InetAddressFamilyPropertyInfo = Gio.Enums.SocketFamily
    type AttrGetType InetAddressFamilyPropertyInfo = Gio.Enums.SocketFamily
    type AttrLabel InetAddressFamilyPropertyInfo = "family"
    type AttrOrigin InetAddressFamilyPropertyInfo = InetAddress
    attrGet = getInetAddressFamily
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructInetAddressFamily
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetAddress.family"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-InetAddress.html#g:attr:family"
        })
#endif

-- VVV Prop "flowinfo"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@flowinfo@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inetAddress #flowinfo
-- @
getInetAddressFlowinfo :: (MonadIO m, IsInetAddress o) => o -> m Word32
getInetAddressFlowinfo obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "flowinfo"

-- | Construct a t'GValueConstruct' with valid value for the “@flowinfo@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructInetAddressFlowinfo :: (IsInetAddress o, MIO.MonadIO m) => Word32 -> m (GValueConstruct o)
constructInetAddressFlowinfo val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyUInt32 "flowinfo" val

#if defined(ENABLE_OVERLOADING)
data InetAddressFlowinfoPropertyInfo
instance AttrInfo InetAddressFlowinfoPropertyInfo where
    type AttrAllowedOps InetAddressFlowinfoPropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint InetAddressFlowinfoPropertyInfo = IsInetAddress
    type AttrSetTypeConstraint InetAddressFlowinfoPropertyInfo = (~) Word32
    type AttrTransferTypeConstraint InetAddressFlowinfoPropertyInfo = (~) Word32
    type AttrTransferType InetAddressFlowinfoPropertyInfo = Word32
    type AttrGetType InetAddressFlowinfoPropertyInfo = Word32
    type AttrLabel InetAddressFlowinfoPropertyInfo = "flowinfo"
    type AttrOrigin InetAddressFlowinfoPropertyInfo = InetAddress
    attrGet = getInetAddressFlowinfo
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructInetAddressFlowinfo
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetAddress.flowinfo"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-InetAddress.html#g:attr:flowinfo"
        })
#endif

-- VVV Prop "is-any"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@is-any@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inetAddress #isAny
-- @
getInetAddressIsAny :: (MonadIO m, IsInetAddress o) => o -> m Bool
getInetAddressIsAny obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "is-any"

#if defined(ENABLE_OVERLOADING)
data InetAddressIsAnyPropertyInfo
instance AttrInfo InetAddressIsAnyPropertyInfo where
    type AttrAllowedOps InetAddressIsAnyPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint InetAddressIsAnyPropertyInfo = IsInetAddress
    type AttrSetTypeConstraint InetAddressIsAnyPropertyInfo = (~) ()
    type AttrTransferTypeConstraint InetAddressIsAnyPropertyInfo = (~) ()
    type AttrTransferType InetAddressIsAnyPropertyInfo = ()
    type AttrGetType InetAddressIsAnyPropertyInfo = Bool
    type AttrLabel InetAddressIsAnyPropertyInfo = "is-any"
    type AttrOrigin InetAddressIsAnyPropertyInfo = InetAddress
    attrGet = getInetAddressIsAny
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetAddress.isAny"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-InetAddress.html#g:attr:isAny"
        })
#endif

-- VVV Prop "is-link-local"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@is-link-local@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inetAddress #isLinkLocal
-- @
getInetAddressIsLinkLocal :: (MonadIO m, IsInetAddress o) => o -> m Bool
getInetAddressIsLinkLocal obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "is-link-local"

#if defined(ENABLE_OVERLOADING)
data InetAddressIsLinkLocalPropertyInfo
instance AttrInfo InetAddressIsLinkLocalPropertyInfo where
    type AttrAllowedOps InetAddressIsLinkLocalPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint InetAddressIsLinkLocalPropertyInfo = IsInetAddress
    type AttrSetTypeConstraint InetAddressIsLinkLocalPropertyInfo = (~) ()
    type AttrTransferTypeConstraint InetAddressIsLinkLocalPropertyInfo = (~) ()
    type AttrTransferType InetAddressIsLinkLocalPropertyInfo = ()
    type AttrGetType InetAddressIsLinkLocalPropertyInfo = Bool
    type AttrLabel InetAddressIsLinkLocalPropertyInfo = "is-link-local"
    type AttrOrigin InetAddressIsLinkLocalPropertyInfo = InetAddress
    attrGet = getInetAddressIsLinkLocal
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetAddress.isLinkLocal"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-InetAddress.html#g:attr:isLinkLocal"
        })
#endif

-- VVV Prop "is-loopback"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@is-loopback@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inetAddress #isLoopback
-- @
getInetAddressIsLoopback :: (MonadIO m, IsInetAddress o) => o -> m Bool
getInetAddressIsLoopback obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "is-loopback"

#if defined(ENABLE_OVERLOADING)
data InetAddressIsLoopbackPropertyInfo
instance AttrInfo InetAddressIsLoopbackPropertyInfo where
    type AttrAllowedOps InetAddressIsLoopbackPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint InetAddressIsLoopbackPropertyInfo = IsInetAddress
    type AttrSetTypeConstraint InetAddressIsLoopbackPropertyInfo = (~) ()
    type AttrTransferTypeConstraint InetAddressIsLoopbackPropertyInfo = (~) ()
    type AttrTransferType InetAddressIsLoopbackPropertyInfo = ()
    type AttrGetType InetAddressIsLoopbackPropertyInfo = Bool
    type AttrLabel InetAddressIsLoopbackPropertyInfo = "is-loopback"
    type AttrOrigin InetAddressIsLoopbackPropertyInfo = InetAddress
    attrGet = getInetAddressIsLoopback
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetAddress.isLoopback"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-InetAddress.html#g:attr:isLoopback"
        })
#endif

-- VVV Prop "is-mc-global"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@is-mc-global@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inetAddress #isMcGlobal
-- @
getInetAddressIsMcGlobal :: (MonadIO m, IsInetAddress o) => o -> m Bool
getInetAddressIsMcGlobal obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "is-mc-global"

#if defined(ENABLE_OVERLOADING)
data InetAddressIsMcGlobalPropertyInfo
instance AttrInfo InetAddressIsMcGlobalPropertyInfo where
    type AttrAllowedOps InetAddressIsMcGlobalPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint InetAddressIsMcGlobalPropertyInfo = IsInetAddress
    type AttrSetTypeConstraint InetAddressIsMcGlobalPropertyInfo = (~) ()
    type AttrTransferTypeConstraint InetAddressIsMcGlobalPropertyInfo = (~) ()
    type AttrTransferType InetAddressIsMcGlobalPropertyInfo = ()
    type AttrGetType InetAddressIsMcGlobalPropertyInfo = Bool
    type AttrLabel InetAddressIsMcGlobalPropertyInfo = "is-mc-global"
    type AttrOrigin InetAddressIsMcGlobalPropertyInfo = InetAddress
    attrGet = getInetAddressIsMcGlobal
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetAddress.isMcGlobal"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-InetAddress.html#g:attr:isMcGlobal"
        })
#endif

-- VVV Prop "is-mc-link-local"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@is-mc-link-local@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inetAddress #isMcLinkLocal
-- @
getInetAddressIsMcLinkLocal :: (MonadIO m, IsInetAddress o) => o -> m Bool
getInetAddressIsMcLinkLocal obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "is-mc-link-local"

#if defined(ENABLE_OVERLOADING)
data InetAddressIsMcLinkLocalPropertyInfo
instance AttrInfo InetAddressIsMcLinkLocalPropertyInfo where
    type AttrAllowedOps InetAddressIsMcLinkLocalPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint InetAddressIsMcLinkLocalPropertyInfo = IsInetAddress
    type AttrSetTypeConstraint InetAddressIsMcLinkLocalPropertyInfo = (~) ()
    type AttrTransferTypeConstraint InetAddressIsMcLinkLocalPropertyInfo = (~) ()
    type AttrTransferType InetAddressIsMcLinkLocalPropertyInfo = ()
    type AttrGetType InetAddressIsMcLinkLocalPropertyInfo = Bool
    type AttrLabel InetAddressIsMcLinkLocalPropertyInfo = "is-mc-link-local"
    type AttrOrigin InetAddressIsMcLinkLocalPropertyInfo = InetAddress
    attrGet = getInetAddressIsMcLinkLocal
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetAddress.isMcLinkLocal"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-InetAddress.html#g:attr:isMcLinkLocal"
        })
#endif

-- VVV Prop "is-mc-node-local"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@is-mc-node-local@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inetAddress #isMcNodeLocal
-- @
getInetAddressIsMcNodeLocal :: (MonadIO m, IsInetAddress o) => o -> m Bool
getInetAddressIsMcNodeLocal obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "is-mc-node-local"

#if defined(ENABLE_OVERLOADING)
data InetAddressIsMcNodeLocalPropertyInfo
instance AttrInfo InetAddressIsMcNodeLocalPropertyInfo where
    type AttrAllowedOps InetAddressIsMcNodeLocalPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint InetAddressIsMcNodeLocalPropertyInfo = IsInetAddress
    type AttrSetTypeConstraint InetAddressIsMcNodeLocalPropertyInfo = (~) ()
    type AttrTransferTypeConstraint InetAddressIsMcNodeLocalPropertyInfo = (~) ()
    type AttrTransferType InetAddressIsMcNodeLocalPropertyInfo = ()
    type AttrGetType InetAddressIsMcNodeLocalPropertyInfo = Bool
    type AttrLabel InetAddressIsMcNodeLocalPropertyInfo = "is-mc-node-local"
    type AttrOrigin InetAddressIsMcNodeLocalPropertyInfo = InetAddress
    attrGet = getInetAddressIsMcNodeLocal
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetAddress.isMcNodeLocal"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-InetAddress.html#g:attr:isMcNodeLocal"
        })
#endif

-- VVV Prop "is-mc-org-local"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@is-mc-org-local@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inetAddress #isMcOrgLocal
-- @
getInetAddressIsMcOrgLocal :: (MonadIO m, IsInetAddress o) => o -> m Bool
getInetAddressIsMcOrgLocal obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "is-mc-org-local"

#if defined(ENABLE_OVERLOADING)
data InetAddressIsMcOrgLocalPropertyInfo
instance AttrInfo InetAddressIsMcOrgLocalPropertyInfo where
    type AttrAllowedOps InetAddressIsMcOrgLocalPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint InetAddressIsMcOrgLocalPropertyInfo = IsInetAddress
    type AttrSetTypeConstraint InetAddressIsMcOrgLocalPropertyInfo = (~) ()
    type AttrTransferTypeConstraint InetAddressIsMcOrgLocalPropertyInfo = (~) ()
    type AttrTransferType InetAddressIsMcOrgLocalPropertyInfo = ()
    type AttrGetType InetAddressIsMcOrgLocalPropertyInfo = Bool
    type AttrLabel InetAddressIsMcOrgLocalPropertyInfo = "is-mc-org-local"
    type AttrOrigin InetAddressIsMcOrgLocalPropertyInfo = InetAddress
    attrGet = getInetAddressIsMcOrgLocal
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetAddress.isMcOrgLocal"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-InetAddress.html#g:attr:isMcOrgLocal"
        })
#endif

-- VVV Prop "is-mc-site-local"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@is-mc-site-local@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inetAddress #isMcSiteLocal
-- @
getInetAddressIsMcSiteLocal :: (MonadIO m, IsInetAddress o) => o -> m Bool
getInetAddressIsMcSiteLocal obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "is-mc-site-local"

#if defined(ENABLE_OVERLOADING)
data InetAddressIsMcSiteLocalPropertyInfo
instance AttrInfo InetAddressIsMcSiteLocalPropertyInfo where
    type AttrAllowedOps InetAddressIsMcSiteLocalPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint InetAddressIsMcSiteLocalPropertyInfo = IsInetAddress
    type AttrSetTypeConstraint InetAddressIsMcSiteLocalPropertyInfo = (~) ()
    type AttrTransferTypeConstraint InetAddressIsMcSiteLocalPropertyInfo = (~) ()
    type AttrTransferType InetAddressIsMcSiteLocalPropertyInfo = ()
    type AttrGetType InetAddressIsMcSiteLocalPropertyInfo = Bool
    type AttrLabel InetAddressIsMcSiteLocalPropertyInfo = "is-mc-site-local"
    type AttrOrigin InetAddressIsMcSiteLocalPropertyInfo = InetAddress
    attrGet = getInetAddressIsMcSiteLocal
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetAddress.isMcSiteLocal"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-InetAddress.html#g:attr:isMcSiteLocal"
        })
#endif

-- VVV Prop "is-multicast"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@is-multicast@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inetAddress #isMulticast
-- @
getInetAddressIsMulticast :: (MonadIO m, IsInetAddress o) => o -> m Bool
getInetAddressIsMulticast obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "is-multicast"

#if defined(ENABLE_OVERLOADING)
data InetAddressIsMulticastPropertyInfo
instance AttrInfo InetAddressIsMulticastPropertyInfo where
    type AttrAllowedOps InetAddressIsMulticastPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint InetAddressIsMulticastPropertyInfo = IsInetAddress
    type AttrSetTypeConstraint InetAddressIsMulticastPropertyInfo = (~) ()
    type AttrTransferTypeConstraint InetAddressIsMulticastPropertyInfo = (~) ()
    type AttrTransferType InetAddressIsMulticastPropertyInfo = ()
    type AttrGetType InetAddressIsMulticastPropertyInfo = Bool
    type AttrLabel InetAddressIsMulticastPropertyInfo = "is-multicast"
    type AttrOrigin InetAddressIsMulticastPropertyInfo = InetAddress
    attrGet = getInetAddressIsMulticast
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetAddress.isMulticast"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-InetAddress.html#g:attr:isMulticast"
        })
#endif

-- VVV Prop "is-site-local"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@is-site-local@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inetAddress #isSiteLocal
-- @
getInetAddressIsSiteLocal :: (MonadIO m, IsInetAddress o) => o -> m Bool
getInetAddressIsSiteLocal obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "is-site-local"

#if defined(ENABLE_OVERLOADING)
data InetAddressIsSiteLocalPropertyInfo
instance AttrInfo InetAddressIsSiteLocalPropertyInfo where
    type AttrAllowedOps InetAddressIsSiteLocalPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint InetAddressIsSiteLocalPropertyInfo = IsInetAddress
    type AttrSetTypeConstraint InetAddressIsSiteLocalPropertyInfo = (~) ()
    type AttrTransferTypeConstraint InetAddressIsSiteLocalPropertyInfo = (~) ()
    type AttrTransferType InetAddressIsSiteLocalPropertyInfo = ()
    type AttrGetType InetAddressIsSiteLocalPropertyInfo = Bool
    type AttrLabel InetAddressIsSiteLocalPropertyInfo = "is-site-local"
    type AttrOrigin InetAddressIsSiteLocalPropertyInfo = InetAddress
    attrGet = getInetAddressIsSiteLocal
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetAddress.isSiteLocal"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-InetAddress.html#g:attr:isSiteLocal"
        })
#endif

-- VVV Prop "scope-id"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@scope-id@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inetAddress #scopeId
-- @
getInetAddressScopeId :: (MonadIO m, IsInetAddress o) => o -> m Word32
getInetAddressScopeId obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "scope-id"

-- | Construct a t'GValueConstruct' with valid value for the “@scope-id@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructInetAddressScopeId :: (IsInetAddress o, MIO.MonadIO m) => Word32 -> m (GValueConstruct o)
constructInetAddressScopeId val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyUInt32 "scope-id" val

#if defined(ENABLE_OVERLOADING)
data InetAddressScopeIdPropertyInfo
instance AttrInfo InetAddressScopeIdPropertyInfo where
    type AttrAllowedOps InetAddressScopeIdPropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint InetAddressScopeIdPropertyInfo = IsInetAddress
    type AttrSetTypeConstraint InetAddressScopeIdPropertyInfo = (~) Word32
    type AttrTransferTypeConstraint InetAddressScopeIdPropertyInfo = (~) Word32
    type AttrTransferType InetAddressScopeIdPropertyInfo = Word32
    type AttrGetType InetAddressScopeIdPropertyInfo = Word32
    type AttrLabel InetAddressScopeIdPropertyInfo = "scope-id"
    type AttrOrigin InetAddressScopeIdPropertyInfo = InetAddress
    attrGet = getInetAddressScopeId
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructInetAddressScopeId
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetAddress.scopeId"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-InetAddress.html#g:attr:scopeId"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList InetAddress
type instance O.AttributeList InetAddress = InetAddressAttributeList
type InetAddressAttributeList = ('[ '("bytes", InetAddressBytesPropertyInfo), '("family", InetAddressFamilyPropertyInfo), '("flowinfo", InetAddressFlowinfoPropertyInfo), '("isAny", InetAddressIsAnyPropertyInfo), '("isLinkLocal", InetAddressIsLinkLocalPropertyInfo), '("isLoopback", InetAddressIsLoopbackPropertyInfo), '("isMcGlobal", InetAddressIsMcGlobalPropertyInfo), '("isMcLinkLocal", InetAddressIsMcLinkLocalPropertyInfo), '("isMcNodeLocal", InetAddressIsMcNodeLocalPropertyInfo), '("isMcOrgLocal", InetAddressIsMcOrgLocalPropertyInfo), '("isMcSiteLocal", InetAddressIsMcSiteLocalPropertyInfo), '("isMulticast", InetAddressIsMulticastPropertyInfo), '("isSiteLocal", InetAddressIsSiteLocalPropertyInfo), '("scopeId", InetAddressScopeIdPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
inetAddressBytes :: AttrLabelProxy "bytes"
inetAddressBytes = AttrLabelProxy

inetAddressFamily :: AttrLabelProxy "family"
inetAddressFamily = AttrLabelProxy

inetAddressFlowinfo :: AttrLabelProxy "flowinfo"
inetAddressFlowinfo = AttrLabelProxy

inetAddressIsAny :: AttrLabelProxy "isAny"
inetAddressIsAny = AttrLabelProxy

inetAddressIsLinkLocal :: AttrLabelProxy "isLinkLocal"
inetAddressIsLinkLocal = AttrLabelProxy

inetAddressIsLoopback :: AttrLabelProxy "isLoopback"
inetAddressIsLoopback = AttrLabelProxy

inetAddressIsMcGlobal :: AttrLabelProxy "isMcGlobal"
inetAddressIsMcGlobal = AttrLabelProxy

inetAddressIsMcLinkLocal :: AttrLabelProxy "isMcLinkLocal"
inetAddressIsMcLinkLocal = AttrLabelProxy

inetAddressIsMcNodeLocal :: AttrLabelProxy "isMcNodeLocal"
inetAddressIsMcNodeLocal = AttrLabelProxy

inetAddressIsMcOrgLocal :: AttrLabelProxy "isMcOrgLocal"
inetAddressIsMcOrgLocal = AttrLabelProxy

inetAddressIsMcSiteLocal :: AttrLabelProxy "isMcSiteLocal"
inetAddressIsMcSiteLocal = AttrLabelProxy

inetAddressIsMulticast :: AttrLabelProxy "isMulticast"
inetAddressIsMulticast = AttrLabelProxy

inetAddressIsSiteLocal :: AttrLabelProxy "isSiteLocal"
inetAddressIsSiteLocal = AttrLabelProxy

inetAddressScopeId :: AttrLabelProxy "scopeId"
inetAddressScopeId = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList InetAddress = InetAddressSignalList
type InetAddressSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method InetAddress::new_any
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "family"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketFamily" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the address family" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "InetAddress" })
-- throws : False
-- Skip return : False

foreign import ccall "g_inet_address_new_any" g_inet_address_new_any :: 
    CUInt ->                                -- family : TInterface (Name {namespace = "Gio", name = "SocketFamily"})
    IO (Ptr InetAddress)

-- | Creates a t'GI.Gio.Objects.InetAddress.InetAddress' for the \"any\" address (unassigned\/\"don\'t
-- care\") for /@family@/.
-- 
-- /Since: 2.22/
inetAddressNewAny ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gio.Enums.SocketFamily
    -- ^ /@family@/: the address family
    -> m InetAddress
    -- ^ __Returns:__ a new t'GI.Gio.Objects.InetAddress.InetAddress' corresponding to the \"any\" address
    -- for /@family@/.
    --     Free the returned object with 'GI.GObject.Objects.Object.objectUnref'.
inetAddressNewAny family = liftIO $ do
    let family' = (fromIntegral . fromEnum) family
    result <- g_inet_address_new_any family'
    checkUnexpectedReturnNULL "inetAddressNewAny" result
    result' <- (wrapObject InetAddress) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method InetAddress::new_from_bytes
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "bytes"
--           , argType = TCArray False (-1) (-1) (TBasicType TUInt8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "raw address data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "family"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketFamily" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the address family of @bytes"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "InetAddress" })
-- throws : False
-- Skip return : False

foreign import ccall "g_inet_address_new_from_bytes" g_inet_address_new_from_bytes :: 
    Ptr Word8 ->                            -- bytes : TCArray False (-1) (-1) (TBasicType TUInt8)
    CUInt ->                                -- family : TInterface (Name {namespace = "Gio", name = "SocketFamily"})
    IO (Ptr InetAddress)

-- | Creates a new t'GI.Gio.Objects.InetAddress.InetAddress' from the given /@family@/ and /@bytes@/.
-- /@bytes@/ should be 4 bytes for 'GI.Gio.Enums.SocketFamilyIpv4' and 16 bytes for
-- 'GI.Gio.Enums.SocketFamilyIpv6'.
-- 
-- /Since: 2.22/
inetAddressNewFromBytes ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ptr Word8
    -- ^ /@bytes@/: raw address data
    -> Gio.Enums.SocketFamily
    -- ^ /@family@/: the address family of /@bytes@/
    -> m InetAddress
    -- ^ __Returns:__ a new t'GI.Gio.Objects.InetAddress.InetAddress' corresponding to /@family@/ and /@bytes@/.
    --     Free the returned object with 'GI.GObject.Objects.Object.objectUnref'.
inetAddressNewFromBytes bytes family = liftIO $ do
    let family' = (fromIntegral . fromEnum) family
    result <- g_inet_address_new_from_bytes bytes family'
    checkUnexpectedReturnNULL "inetAddressNewFromBytes" result
    result' <- (wrapObject InetAddress) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method InetAddress::new_from_bytes_with_ipv6_info
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "bytes"
--           , argType = TCArray False (-1) (-1) (TBasicType TUInt8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "raw address data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "family"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketFamily" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the address family of @bytes"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flowinfo"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "scope_id"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the scope-id of the address"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "InetAddress" })
-- throws : False
-- Skip return : False

foreign import ccall "g_inet_address_new_from_bytes_with_ipv6_info" g_inet_address_new_from_bytes_with_ipv6_info :: 
    Ptr Word8 ->                            -- bytes : TCArray False (-1) (-1) (TBasicType TUInt8)
    CUInt ->                                -- family : TInterface (Name {namespace = "Gio", name = "SocketFamily"})
    Word32 ->                               -- flowinfo : TBasicType TUInt32
    Word32 ->                               -- scope_id : TBasicType TUInt32
    IO (Ptr InetAddress)

-- | Creates a new t'GI.Gio.Objects.InetAddress.InetAddress' from the given /@family@/, /@bytes@/
-- and /@scopeId@/.
-- 
-- /@bytes@/ must be 4 bytes for 'GI.Gio.Enums.SocketFamilyIpv4' and 16 bytes for
-- 'GI.Gio.Enums.SocketFamilyIpv6'.
-- 
-- /Since: 2.86/
inetAddressNewFromBytesWithIpv6Info ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ptr Word8
    -- ^ /@bytes@/: raw address data
    -> Gio.Enums.SocketFamily
    -- ^ /@family@/: the address family of /@bytes@/
    -> Word32
    -> Word32
    -- ^ /@scopeId@/: the scope-id of the address
    -> m InetAddress
    -- ^ __Returns:__ a new internet address corresponding to
    --   /@family@/, /@bytes@/ and /@scopeId@/
inetAddressNewFromBytesWithIpv6Info bytes family flowinfo scopeId = liftIO $ do
    let family' = (fromIntegral . fromEnum) family
    result <- g_inet_address_new_from_bytes_with_ipv6_info bytes family' flowinfo scopeId
    checkUnexpectedReturnNULL "inetAddressNewFromBytesWithIpv6Info" result
    result' <- (wrapObject InetAddress) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method InetAddress::new_from_string
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "string"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string representation of an IP address"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "InetAddress" })
-- throws : False
-- Skip return : False

foreign import ccall "g_inet_address_new_from_string" g_inet_address_new_from_string :: 
    CString ->                              -- string : TBasicType TUTF8
    IO (Ptr InetAddress)

-- | Parses /@string@/ as an IP address and creates a new t'GI.Gio.Objects.InetAddress.InetAddress'.
-- 
-- If /@address@/ is an IPv6 address, it can also contain a scope ID
-- (separated from the address by a @%@). Note that currently this
-- behavior is platform specific. This may change in a future release.
-- 
-- /Since: 2.22/
inetAddressNewFromString ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@string@/: a string representation of an IP address
    -> m (Maybe InetAddress)
    -- ^ __Returns:__ a new t'GI.Gio.Objects.InetAddress.InetAddress' corresponding
    -- to /@string@/, or 'P.Nothing' if /@string@/ could not be parsed.
    --     Free the returned object with 'GI.GObject.Objects.Object.objectUnref'.
inetAddressNewFromString string = liftIO $ do
    string' <- textToCString string
    result <- g_inet_address_new_from_string string'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject InetAddress) result'
        return result''
    freeMem string'
    return maybeResult

#if defined(ENABLE_OVERLOADING)
#endif

-- method InetAddress::new_loopback
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "family"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketFamily" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the address family" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "InetAddress" })
-- throws : False
-- Skip return : False

foreign import ccall "g_inet_address_new_loopback" g_inet_address_new_loopback :: 
    CUInt ->                                -- family : TInterface (Name {namespace = "Gio", name = "SocketFamily"})
    IO (Ptr InetAddress)

-- | Creates a t'GI.Gio.Objects.InetAddress.InetAddress' for the loopback address for /@family@/.
-- 
-- /Since: 2.22/
inetAddressNewLoopback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gio.Enums.SocketFamily
    -- ^ /@family@/: the address family
    -> m InetAddress
    -- ^ __Returns:__ a new t'GI.Gio.Objects.InetAddress.InetAddress' corresponding to the loopback address
    -- for /@family@/.
    --     Free the returned object with 'GI.GObject.Objects.Object.objectUnref'.
inetAddressNewLoopback family = liftIO $ do
    let family' = (fromIntegral . fromEnum) family
    result <- g_inet_address_new_loopback family'
    checkUnexpectedReturnNULL "inetAddressNewLoopback" result
    result' <- (wrapObject InetAddress) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method InetAddress::equal
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "address"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InetAddress" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GInetAddress." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "other_address"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InetAddress" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Another #GInetAddress."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_inet_address_equal" g_inet_address_equal :: 
    Ptr InetAddress ->                      -- address : TInterface (Name {namespace = "Gio", name = "InetAddress"})
    Ptr InetAddress ->                      -- other_address : TInterface (Name {namespace = "Gio", name = "InetAddress"})
    IO CInt

-- | Checks if two t'GI.Gio.Objects.InetAddress.InetAddress' instances are equal, e.g. the same address.
-- 
-- /Since: 2.30/
inetAddressEqual ::
    (B.CallStack.HasCallStack, MonadIO m, IsInetAddress a, IsInetAddress b) =>
    a
    -- ^ /@address@/: A t'GI.Gio.Objects.InetAddress.InetAddress'.
    -> b
    -- ^ /@otherAddress@/: Another t'GI.Gio.Objects.InetAddress.InetAddress'.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@address@/ and /@otherAddress@/ are equal, 'P.False' otherwise.
inetAddressEqual address otherAddress = liftIO $ do
    address' <- unsafeManagedPtrCastPtr address
    otherAddress' <- unsafeManagedPtrCastPtr otherAddress
    result <- g_inet_address_equal address' otherAddress'
    let result' = (/= 0) result
    touchManagedPtr address
    touchManagedPtr otherAddress
    return result'

#if defined(ENABLE_OVERLOADING)
data InetAddressEqualMethodInfo
instance (signature ~ (b -> m Bool), MonadIO m, IsInetAddress a, IsInetAddress b) => O.OverloadedMethod InetAddressEqualMethodInfo a signature where
    overloadedMethod = inetAddressEqual

instance O.OverloadedMethodInfo InetAddressEqualMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetAddress.inetAddressEqual",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-InetAddress.html#v:inetAddressEqual"
        })


#endif

-- method InetAddress::get_family
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "address"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InetAddress" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GInetAddress" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "SocketFamily" })
-- throws : False
-- Skip return : False

foreign import ccall "g_inet_address_get_family" g_inet_address_get_family :: 
    Ptr InetAddress ->                      -- address : TInterface (Name {namespace = "Gio", name = "InetAddress"})
    IO CUInt

-- | Gets /@address@/\'s family
-- 
-- /Since: 2.22/
inetAddressGetFamily ::
    (B.CallStack.HasCallStack, MonadIO m, IsInetAddress a) =>
    a
    -- ^ /@address@/: a t'GI.Gio.Objects.InetAddress.InetAddress'
    -> m Gio.Enums.SocketFamily
    -- ^ __Returns:__ /@address@/\'s family
inetAddressGetFamily address = liftIO $ do
    address' <- unsafeManagedPtrCastPtr address
    result <- g_inet_address_get_family address'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr address
    return result'

#if defined(ENABLE_OVERLOADING)
data InetAddressGetFamilyMethodInfo
instance (signature ~ (m Gio.Enums.SocketFamily), MonadIO m, IsInetAddress a) => O.OverloadedMethod InetAddressGetFamilyMethodInfo a signature where
    overloadedMethod = inetAddressGetFamily

instance O.OverloadedMethodInfo InetAddressGetFamilyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetAddress.inetAddressGetFamily",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-InetAddress.html#v:inetAddressGetFamily"
        })


#endif

-- method InetAddress::get_flowinfo
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "address"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InetAddress" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GInetAddress" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt32)
-- throws : False
-- Skip return : False

foreign import ccall "g_inet_address_get_flowinfo" g_inet_address_get_flowinfo :: 
    Ptr InetAddress ->                      -- address : TInterface (Name {namespace = "Gio", name = "InetAddress"})
    IO Word32

-- | Gets the value of [InetAddress:flowinfo]("GI.Gio.Objects.InetAddress#g:attr:flowinfo").
-- 
-- /Since: 2.86/
inetAddressGetFlowinfo ::
    (B.CallStack.HasCallStack, MonadIO m, IsInetAddress a) =>
    a
    -- ^ /@address@/: a t'GI.Gio.Objects.InetAddress.InetAddress'
    -> m Word32
    -- ^ __Returns:__ The flowinfo for the address, @0@ if unset or not IPv6 address.
inetAddressGetFlowinfo address = liftIO $ do
    address' <- unsafeManagedPtrCastPtr address
    result <- g_inet_address_get_flowinfo address'
    touchManagedPtr address
    return result

#if defined(ENABLE_OVERLOADING)
data InetAddressGetFlowinfoMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsInetAddress a) => O.OverloadedMethod InetAddressGetFlowinfoMethodInfo a signature where
    overloadedMethod = inetAddressGetFlowinfo

instance O.OverloadedMethodInfo InetAddressGetFlowinfoMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetAddress.inetAddressGetFlowinfo",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-InetAddress.html#v:inetAddressGetFlowinfo"
        })


#endif

-- method InetAddress::get_is_any
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "address"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InetAddress" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GInetAddress" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_inet_address_get_is_any" g_inet_address_get_is_any :: 
    Ptr InetAddress ->                      -- address : TInterface (Name {namespace = "Gio", name = "InetAddress"})
    IO CInt

-- | Tests whether /@address@/ is the \"any\" address for its family.
-- 
-- /Since: 2.22/
inetAddressGetIsAny ::
    (B.CallStack.HasCallStack, MonadIO m, IsInetAddress a) =>
    a
    -- ^ /@address@/: a t'GI.Gio.Objects.InetAddress.InetAddress'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@address@/ is the \"any\" address for its family.
inetAddressGetIsAny address = liftIO $ do
    address' <- unsafeManagedPtrCastPtr address
    result <- g_inet_address_get_is_any address'
    let result' = (/= 0) result
    touchManagedPtr address
    return result'

#if defined(ENABLE_OVERLOADING)
data InetAddressGetIsAnyMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsInetAddress a) => O.OverloadedMethod InetAddressGetIsAnyMethodInfo a signature where
    overloadedMethod = inetAddressGetIsAny

instance O.OverloadedMethodInfo InetAddressGetIsAnyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetAddress.inetAddressGetIsAny",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-InetAddress.html#v:inetAddressGetIsAny"
        })


#endif

-- method InetAddress::get_is_link_local
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "address"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InetAddress" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GInetAddress" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_inet_address_get_is_link_local" g_inet_address_get_is_link_local :: 
    Ptr InetAddress ->                      -- address : TInterface (Name {namespace = "Gio", name = "InetAddress"})
    IO CInt

-- | Tests whether /@address@/ is a link-local address (that is, if it
-- identifies a host on a local network that is not connected to the
-- Internet).
-- 
-- /Since: 2.22/
inetAddressGetIsLinkLocal ::
    (B.CallStack.HasCallStack, MonadIO m, IsInetAddress a) =>
    a
    -- ^ /@address@/: a t'GI.Gio.Objects.InetAddress.InetAddress'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@address@/ is a link-local address.
inetAddressGetIsLinkLocal address = liftIO $ do
    address' <- unsafeManagedPtrCastPtr address
    result <- g_inet_address_get_is_link_local address'
    let result' = (/= 0) result
    touchManagedPtr address
    return result'

#if defined(ENABLE_OVERLOADING)
data InetAddressGetIsLinkLocalMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsInetAddress a) => O.OverloadedMethod InetAddressGetIsLinkLocalMethodInfo a signature where
    overloadedMethod = inetAddressGetIsLinkLocal

instance O.OverloadedMethodInfo InetAddressGetIsLinkLocalMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetAddress.inetAddressGetIsLinkLocal",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-InetAddress.html#v:inetAddressGetIsLinkLocal"
        })


#endif

-- method InetAddress::get_is_loopback
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "address"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InetAddress" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GInetAddress" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_inet_address_get_is_loopback" g_inet_address_get_is_loopback :: 
    Ptr InetAddress ->                      -- address : TInterface (Name {namespace = "Gio", name = "InetAddress"})
    IO CInt

-- | Tests whether /@address@/ is the loopback address for its family.
-- 
-- /Since: 2.22/
inetAddressGetIsLoopback ::
    (B.CallStack.HasCallStack, MonadIO m, IsInetAddress a) =>
    a
    -- ^ /@address@/: a t'GI.Gio.Objects.InetAddress.InetAddress'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@address@/ is the loopback address for its family.
inetAddressGetIsLoopback address = liftIO $ do
    address' <- unsafeManagedPtrCastPtr address
    result <- g_inet_address_get_is_loopback address'
    let result' = (/= 0) result
    touchManagedPtr address
    return result'

#if defined(ENABLE_OVERLOADING)
data InetAddressGetIsLoopbackMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsInetAddress a) => O.OverloadedMethod InetAddressGetIsLoopbackMethodInfo a signature where
    overloadedMethod = inetAddressGetIsLoopback

instance O.OverloadedMethodInfo InetAddressGetIsLoopbackMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetAddress.inetAddressGetIsLoopback",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-InetAddress.html#v:inetAddressGetIsLoopback"
        })


#endif

-- method InetAddress::get_is_mc_global
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "address"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InetAddress" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GInetAddress" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_inet_address_get_is_mc_global" g_inet_address_get_is_mc_global :: 
    Ptr InetAddress ->                      -- address : TInterface (Name {namespace = "Gio", name = "InetAddress"})
    IO CInt

-- | Tests whether /@address@/ is a global multicast address.
-- 
-- /Since: 2.22/
inetAddressGetIsMcGlobal ::
    (B.CallStack.HasCallStack, MonadIO m, IsInetAddress a) =>
    a
    -- ^ /@address@/: a t'GI.Gio.Objects.InetAddress.InetAddress'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@address@/ is a global multicast address.
inetAddressGetIsMcGlobal address = liftIO $ do
    address' <- unsafeManagedPtrCastPtr address
    result <- g_inet_address_get_is_mc_global address'
    let result' = (/= 0) result
    touchManagedPtr address
    return result'

#if defined(ENABLE_OVERLOADING)
data InetAddressGetIsMcGlobalMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsInetAddress a) => O.OverloadedMethod InetAddressGetIsMcGlobalMethodInfo a signature where
    overloadedMethod = inetAddressGetIsMcGlobal

instance O.OverloadedMethodInfo InetAddressGetIsMcGlobalMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetAddress.inetAddressGetIsMcGlobal",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-InetAddress.html#v:inetAddressGetIsMcGlobal"
        })


#endif

-- method InetAddress::get_is_mc_link_local
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "address"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InetAddress" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GInetAddress" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_inet_address_get_is_mc_link_local" g_inet_address_get_is_mc_link_local :: 
    Ptr InetAddress ->                      -- address : TInterface (Name {namespace = "Gio", name = "InetAddress"})
    IO CInt

-- | Tests whether /@address@/ is a link-local multicast address.
-- 
-- /Since: 2.22/
inetAddressGetIsMcLinkLocal ::
    (B.CallStack.HasCallStack, MonadIO m, IsInetAddress a) =>
    a
    -- ^ /@address@/: a t'GI.Gio.Objects.InetAddress.InetAddress'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@address@/ is a link-local multicast address.
inetAddressGetIsMcLinkLocal address = liftIO $ do
    address' <- unsafeManagedPtrCastPtr address
    result <- g_inet_address_get_is_mc_link_local address'
    let result' = (/= 0) result
    touchManagedPtr address
    return result'

#if defined(ENABLE_OVERLOADING)
data InetAddressGetIsMcLinkLocalMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsInetAddress a) => O.OverloadedMethod InetAddressGetIsMcLinkLocalMethodInfo a signature where
    overloadedMethod = inetAddressGetIsMcLinkLocal

instance O.OverloadedMethodInfo InetAddressGetIsMcLinkLocalMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetAddress.inetAddressGetIsMcLinkLocal",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-InetAddress.html#v:inetAddressGetIsMcLinkLocal"
        })


#endif

-- method InetAddress::get_is_mc_node_local
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "address"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InetAddress" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GInetAddress" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_inet_address_get_is_mc_node_local" g_inet_address_get_is_mc_node_local :: 
    Ptr InetAddress ->                      -- address : TInterface (Name {namespace = "Gio", name = "InetAddress"})
    IO CInt

-- | Tests whether /@address@/ is a node-local multicast address.
-- 
-- /Since: 2.22/
inetAddressGetIsMcNodeLocal ::
    (B.CallStack.HasCallStack, MonadIO m, IsInetAddress a) =>
    a
    -- ^ /@address@/: a t'GI.Gio.Objects.InetAddress.InetAddress'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@address@/ is a node-local multicast address.
inetAddressGetIsMcNodeLocal address = liftIO $ do
    address' <- unsafeManagedPtrCastPtr address
    result <- g_inet_address_get_is_mc_node_local address'
    let result' = (/= 0) result
    touchManagedPtr address
    return result'

#if defined(ENABLE_OVERLOADING)
data InetAddressGetIsMcNodeLocalMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsInetAddress a) => O.OverloadedMethod InetAddressGetIsMcNodeLocalMethodInfo a signature where
    overloadedMethod = inetAddressGetIsMcNodeLocal

instance O.OverloadedMethodInfo InetAddressGetIsMcNodeLocalMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetAddress.inetAddressGetIsMcNodeLocal",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-InetAddress.html#v:inetAddressGetIsMcNodeLocal"
        })


#endif

-- method InetAddress::get_is_mc_org_local
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "address"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InetAddress" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GInetAddress" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_inet_address_get_is_mc_org_local" g_inet_address_get_is_mc_org_local :: 
    Ptr InetAddress ->                      -- address : TInterface (Name {namespace = "Gio", name = "InetAddress"})
    IO CInt

-- | Tests whether /@address@/ is an organization-local multicast address.
-- 
-- /Since: 2.22/
inetAddressGetIsMcOrgLocal ::
    (B.CallStack.HasCallStack, MonadIO m, IsInetAddress a) =>
    a
    -- ^ /@address@/: a t'GI.Gio.Objects.InetAddress.InetAddress'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@address@/ is an organization-local multicast address.
inetAddressGetIsMcOrgLocal address = liftIO $ do
    address' <- unsafeManagedPtrCastPtr address
    result <- g_inet_address_get_is_mc_org_local address'
    let result' = (/= 0) result
    touchManagedPtr address
    return result'

#if defined(ENABLE_OVERLOADING)
data InetAddressGetIsMcOrgLocalMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsInetAddress a) => O.OverloadedMethod InetAddressGetIsMcOrgLocalMethodInfo a signature where
    overloadedMethod = inetAddressGetIsMcOrgLocal

instance O.OverloadedMethodInfo InetAddressGetIsMcOrgLocalMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetAddress.inetAddressGetIsMcOrgLocal",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-InetAddress.html#v:inetAddressGetIsMcOrgLocal"
        })


#endif

-- method InetAddress::get_is_mc_site_local
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "address"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InetAddress" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GInetAddress" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_inet_address_get_is_mc_site_local" g_inet_address_get_is_mc_site_local :: 
    Ptr InetAddress ->                      -- address : TInterface (Name {namespace = "Gio", name = "InetAddress"})
    IO CInt

-- | Tests whether /@address@/ is a site-local multicast address.
-- 
-- /Since: 2.22/
inetAddressGetIsMcSiteLocal ::
    (B.CallStack.HasCallStack, MonadIO m, IsInetAddress a) =>
    a
    -- ^ /@address@/: a t'GI.Gio.Objects.InetAddress.InetAddress'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@address@/ is a site-local multicast address.
inetAddressGetIsMcSiteLocal address = liftIO $ do
    address' <- unsafeManagedPtrCastPtr address
    result <- g_inet_address_get_is_mc_site_local address'
    let result' = (/= 0) result
    touchManagedPtr address
    return result'

#if defined(ENABLE_OVERLOADING)
data InetAddressGetIsMcSiteLocalMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsInetAddress a) => O.OverloadedMethod InetAddressGetIsMcSiteLocalMethodInfo a signature where
    overloadedMethod = inetAddressGetIsMcSiteLocal

instance O.OverloadedMethodInfo InetAddressGetIsMcSiteLocalMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetAddress.inetAddressGetIsMcSiteLocal",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-InetAddress.html#v:inetAddressGetIsMcSiteLocal"
        })


#endif

-- method InetAddress::get_is_multicast
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "address"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InetAddress" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GInetAddress" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_inet_address_get_is_multicast" g_inet_address_get_is_multicast :: 
    Ptr InetAddress ->                      -- address : TInterface (Name {namespace = "Gio", name = "InetAddress"})
    IO CInt

-- | Tests whether /@address@/ is a multicast address.
-- 
-- /Since: 2.22/
inetAddressGetIsMulticast ::
    (B.CallStack.HasCallStack, MonadIO m, IsInetAddress a) =>
    a
    -- ^ /@address@/: a t'GI.Gio.Objects.InetAddress.InetAddress'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@address@/ is a multicast address.
inetAddressGetIsMulticast address = liftIO $ do
    address' <- unsafeManagedPtrCastPtr address
    result <- g_inet_address_get_is_multicast address'
    let result' = (/= 0) result
    touchManagedPtr address
    return result'

#if defined(ENABLE_OVERLOADING)
data InetAddressGetIsMulticastMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsInetAddress a) => O.OverloadedMethod InetAddressGetIsMulticastMethodInfo a signature where
    overloadedMethod = inetAddressGetIsMulticast

instance O.OverloadedMethodInfo InetAddressGetIsMulticastMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetAddress.inetAddressGetIsMulticast",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-InetAddress.html#v:inetAddressGetIsMulticast"
        })


#endif

-- method InetAddress::get_is_site_local
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "address"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InetAddress" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GInetAddress" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_inet_address_get_is_site_local" g_inet_address_get_is_site_local :: 
    Ptr InetAddress ->                      -- address : TInterface (Name {namespace = "Gio", name = "InetAddress"})
    IO CInt

-- | Tests whether /@address@/ is a site-local address such as 10.0.0.1
-- (that is, the address identifies a host on a local network that can
-- not be reached directly from the Internet, but which may have
-- outgoing Internet connectivity via a NAT or firewall).
-- 
-- /Since: 2.22/
inetAddressGetIsSiteLocal ::
    (B.CallStack.HasCallStack, MonadIO m, IsInetAddress a) =>
    a
    -- ^ /@address@/: a t'GI.Gio.Objects.InetAddress.InetAddress'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@address@/ is a site-local address.
inetAddressGetIsSiteLocal address = liftIO $ do
    address' <- unsafeManagedPtrCastPtr address
    result <- g_inet_address_get_is_site_local address'
    let result' = (/= 0) result
    touchManagedPtr address
    return result'

#if defined(ENABLE_OVERLOADING)
data InetAddressGetIsSiteLocalMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsInetAddress a) => O.OverloadedMethod InetAddressGetIsSiteLocalMethodInfo a signature where
    overloadedMethod = inetAddressGetIsSiteLocal

instance O.OverloadedMethodInfo InetAddressGetIsSiteLocalMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetAddress.inetAddressGetIsSiteLocal",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-InetAddress.html#v:inetAddressGetIsSiteLocal"
        })


#endif

-- method InetAddress::get_native_size
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "address"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InetAddress" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GInetAddress" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TSize)
-- throws : False
-- Skip return : False

foreign import ccall "g_inet_address_get_native_size" g_inet_address_get_native_size :: 
    Ptr InetAddress ->                      -- address : TInterface (Name {namespace = "Gio", name = "InetAddress"})
    IO FCT.CSize

-- | Gets the size of the native raw binary address for /@address@/. This
-- is the size of the data that you get from @/g_inet_address_to_bytes()/@.
-- 
-- /Since: 2.22/
inetAddressGetNativeSize ::
    (B.CallStack.HasCallStack, MonadIO m, IsInetAddress a) =>
    a
    -- ^ /@address@/: a t'GI.Gio.Objects.InetAddress.InetAddress'
    -> m FCT.CSize
    -- ^ __Returns:__ the number of bytes used for the native version of /@address@/.
inetAddressGetNativeSize address = liftIO $ do
    address' <- unsafeManagedPtrCastPtr address
    result <- g_inet_address_get_native_size address'
    touchManagedPtr address
    return result

#if defined(ENABLE_OVERLOADING)
data InetAddressGetNativeSizeMethodInfo
instance (signature ~ (m FCT.CSize), MonadIO m, IsInetAddress a) => O.OverloadedMethod InetAddressGetNativeSizeMethodInfo a signature where
    overloadedMethod = inetAddressGetNativeSize

instance O.OverloadedMethodInfo InetAddressGetNativeSizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetAddress.inetAddressGetNativeSize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-InetAddress.html#v:inetAddressGetNativeSize"
        })


#endif

-- method InetAddress::get_scope_id
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "address"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InetAddress" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GInetAddress" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt32)
-- throws : False
-- Skip return : False

foreign import ccall "g_inet_address_get_scope_id" g_inet_address_get_scope_id :: 
    Ptr InetAddress ->                      -- address : TInterface (Name {namespace = "Gio", name = "InetAddress"})
    IO Word32

-- | Gets the value of [InetAddress:scopeId]("GI.Gio.Objects.InetAddress#g:attr:scopeId").
-- 
-- /Since: 2.86/
inetAddressGetScopeId ::
    (B.CallStack.HasCallStack, MonadIO m, IsInetAddress a) =>
    a
    -- ^ /@address@/: a t'GI.Gio.Objects.InetAddress.InetAddress'
    -> m Word32
    -- ^ __Returns:__ The scope-id for the address, @0@ if unset or not IPv6 address.
inetAddressGetScopeId address = liftIO $ do
    address' <- unsafeManagedPtrCastPtr address
    result <- g_inet_address_get_scope_id address'
    touchManagedPtr address
    return result

#if defined(ENABLE_OVERLOADING)
data InetAddressGetScopeIdMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsInetAddress a) => O.OverloadedMethod InetAddressGetScopeIdMethodInfo a signature where
    overloadedMethod = inetAddressGetScopeId

instance O.OverloadedMethodInfo InetAddressGetScopeIdMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetAddress.inetAddressGetScopeId",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-InetAddress.html#v:inetAddressGetScopeId"
        })


#endif

-- method InetAddress::to_string
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "address"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InetAddress" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GInetAddress" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_inet_address_to_string" g_inet_address_to_string :: 
    Ptr InetAddress ->                      -- address : TInterface (Name {namespace = "Gio", name = "InetAddress"})
    IO CString

-- | Converts /@address@/ to string form.
-- 
-- /Since: 2.22/
inetAddressToString ::
    (B.CallStack.HasCallStack, MonadIO m, IsInetAddress a) =>
    a
    -- ^ /@address@/: a t'GI.Gio.Objects.InetAddress.InetAddress'
    -> m T.Text
    -- ^ __Returns:__ a representation of /@address@/ as a string, which should be
    -- freed after use.
inetAddressToString address = liftIO $ do
    address' <- unsafeManagedPtrCastPtr address
    result <- g_inet_address_to_string address'
    checkUnexpectedReturnNULL "inetAddressToString" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr address
    return result'

#if defined(ENABLE_OVERLOADING)
data InetAddressToStringMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsInetAddress a) => O.OverloadedMethod InetAddressToStringMethodInfo a signature where
    overloadedMethod = inetAddressToString

instance O.OverloadedMethodInfo InetAddressToStringMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetAddress.inetAddressToString",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-InetAddress.html#v:inetAddressToString"
        })


#endif


