/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.HashSet;
import java.util.Set;
import net.sf.saxon.expr.AndExpression;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.BooleanExpression;
import net.sf.saxon.expr.DifferenceEnumeration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.IntersectionEnumeration;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OrExpression;
import net.sf.saxon.expr.SingletonIntersectExpression;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.UnionEnumeration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.expr.sort.DocumentOrderIterator;
import net.sf.saxon.expr.sort.GlobalOrderComparer;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.PatternSponsor;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

public class VennExpression
extends BinaryExpression {
    public VennExpression(Expression p1, int op, Expression p2) {
        super(p1, op, p2);
    }

    public String getExpressionName() {
        switch (this.operator) {
            case 1: {
                return "union";
            }
            case 23: {
                return "intersect";
            }
            case 24: {
                return "except";
            }
        }
        return "unknown";
    }

    public final ItemType getItemType(TypeHierarchy th) {
        ItemType t1 = this.operand0.getItemType(th);
        ItemType t2 = this.operand1.getItemType(th);
        return Type.getCommonSuperType(t1, t2, th);
    }

    public final int computeCardinality() {
        int c1 = this.operand0.getCardinality();
        int c2 = this.operand1.getCardinality();
        switch (this.operator) {
            case 1: {
                if (Literal.isEmptySequence(this.operand0)) {
                    return c2;
                }
                if (Literal.isEmptySequence(this.operand1)) {
                    return c1;
                }
                return c1 | c2 | 0x4000 | 0x8000;
            }
            case 23: {
                if (Literal.isEmptySequence(this.operand0)) {
                    return 8192;
                }
                if (Literal.isEmptySequence(this.operand1)) {
                    return 8192;
                }
                return c1 & c2 | 0x2000 | 0x4000;
            }
            case 24: {
                if (Literal.isEmptySequence(this.operand0)) {
                    return 8192;
                }
                if (Literal.isEmptySequence(this.operand1)) {
                    return c1;
                }
                return c1 | 0x2000 | 0x4000;
            }
        }
        return 57344;
    }

    public int computeSpecialProperties() {
        int prop0 = this.operand0.getSpecialProperties();
        int prop1 = this.operand1.getSpecialProperties();
        int props = 131072;
        if (this.testContextDocumentNodeSet(prop0, prop1)) {
            props |= 0x10000;
        }
        if (this.testSubTree(prop0, prop1)) {
            props |= 0x100000;
        }
        if (!this.testCreative(prop0, prop1)) {
            props |= 0x400000;
        }
        return props;
    }

    private boolean testContextDocumentNodeSet(int prop0, int prop1) {
        switch (this.operator) {
            case 1: {
                return (prop0 & prop1 & 0x10000) != 0;
            }
            case 23: {
                return ((prop0 | prop1) & 0x10000) != 0;
            }
            case 24: {
                return (prop0 & 0x10000) != 0;
            }
        }
        return false;
    }

    public void gatherComponents(int operator, Set set) {
        if (this.operand0 instanceof VennExpression && ((VennExpression)this.operand0).operator == operator) {
            ((VennExpression)this.operand0).gatherComponents(operator, set);
        } else {
            set.add(this.operand0);
        }
        if (this.operand1 instanceof VennExpression && ((VennExpression)this.operand1).operator == operator) {
            ((VennExpression)this.operand1).gatherComponents(operator, set);
        } else {
            set.add(this.operand1);
        }
    }

    private boolean testSubTree(int prop0, int prop1) {
        switch (this.operator) {
            case 1: {
                return (prop0 & prop1 & 0x100000) != 0;
            }
            case 23: {
                return ((prop0 | prop1) & 0x100000) != 0;
            }
            case 24: {
                return (prop0 & 0x100000) != 0;
            }
        }
        return false;
    }

    private boolean testCreative(int prop0, int prop1) {
        return (prop0 & 0x400000) == 0 || (prop1 & 0x400000) == 0;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.operand0 = visitor.simplify(this.operand0);
        this.operand1 = visitor.simplify(this.operand1);
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        this.operand0 = visitor.typeCheck(this.operand0, contextItemType);
        this.operand1 = visitor.typeCheck(this.operand1, contextItemType);
        if (!(this.operand0 instanceof PatternSponsor)) {
            RoleLocator role0 = new RoleLocator(1, Token.tokens[this.operator], 0);
            this.operand0 = TypeChecker.staticTypeCheck(this.operand0, SequenceType.NODE_SEQUENCE, false, role0, visitor);
        }
        if (!(this.operand1 instanceof PatternSponsor)) {
            RoleLocator role1 = new RoleLocator(1, Token.tokens[this.operator], 1);
            this.operand1 = TypeChecker.staticTypeCheck(this.operand1, SequenceType.NODE_SEQUENCE, false, role1, visitor);
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        Expression e = super.optimize(visitor, contextItemType);
        if (e != this) {
            return e;
        }
        switch (this.operator) {
            case 1: {
                if (Literal.isEmptySequence(this.operand0) && (this.operand1.getSpecialProperties() & 0x20000) != 0) {
                    return this.operand1;
                }
                if (!Literal.isEmptySequence(this.operand1) || (this.operand0.getSpecialProperties() & 0x20000) == 0) break;
                return this.operand0;
            }
            case 23: {
                if (Literal.isEmptySequence(this.operand0)) {
                    return this.operand0;
                }
                if (!Literal.isEmptySequence(this.operand1)) break;
                return this.operand1;
            }
            case 24: {
                if (Literal.isEmptySequence(this.operand0)) {
                    return this.operand0;
                }
                if (!Literal.isEmptySequence(this.operand1) || (this.operand0.getSpecialProperties() & 0x20000) == 0) break;
                return this.operand0;
            }
        }
        if (this.operand0 instanceof AxisExpression && this.operand1 instanceof AxisExpression) {
            AxisExpression a1 = (AxisExpression)this.operand0;
            AxisExpression a2 = (AxisExpression)this.operand1;
            if (a1.getAxis() == a2.getAxis()) {
                AxisExpression ax = new AxisExpression(a1.getAxis(), new CombinedNodeTest(a1.getNodeTest(), this.operator, a2.getNodeTest()));
                ExpressionTool.copyLocationInfo(this, ax);
                return ax;
            }
        }
        if (this.operand0 instanceof SlashExpression && this.operand1 instanceof SlashExpression && this.operator == 1) {
            SlashExpression path1 = (SlashExpression)this.operand0;
            SlashExpression path2 = (SlashExpression)this.operand1;
            if (path1.getFirstStep().equals(path2.getFirstStep())) {
                VennExpression venn = new VennExpression(path1.getRemainingSteps(), this.operator, path2.getRemainingSteps());
                ExpressionTool.copyLocationInfo(this, venn);
                Expression path = ExpressionTool.makePathExpression(path1.getFirstStep(), venn, false);
                ExpressionTool.copyLocationInfo(this, path);
                return visitor.optimize(path, contextItemType);
            }
        }
        if (this.operand0 instanceof FilterExpression && this.operand1 instanceof FilterExpression) {
            FilterExpression exp0 = (FilterExpression)this.operand0;
            FilterExpression exp1 = (FilterExpression)this.operand1;
            TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
            if (!exp0.isPositional(th) && !exp1.isPositional(th) && exp0.getControllingExpression().equals(exp1.getControllingExpression())) {
                BooleanExpression filter;
                switch (this.operator) {
                    case 1: {
                        filter = new OrExpression(exp0.getFilter(), exp1.getFilter());
                        break;
                    }
                    case 23: {
                        filter = new AndExpression(exp0.getFilter(), exp1.getFilter());
                        break;
                    }
                    case 24: {
                        FunctionCall negate2 = SystemFunction.makeSystemFunction("not", new Expression[]{exp1.getFilter()});
                        filter = new AndExpression(exp0.getFilter(), negate2);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown operator " + this.operator));
                    }
                }
                ExpressionTool.copyLocationInfo(this, filter);
                FilterExpression f = new FilterExpression(exp0.getControllingExpression(), filter);
                ExpressionTool.copyLocationInfo(this, f);
                return f.simplify(visitor).typeCheck(visitor, contextItemType).optimize(visitor, contextItemType);
            }
        }
        if (!visitor.isOptimizeForStreaming() && this.operator == 1 && this.operand0 instanceof AxisExpression && this.operand1 instanceof AxisExpression) {
            Block b;
            AxisExpression a0 = (AxisExpression)this.operand0;
            AxisExpression a1 = (AxisExpression)this.operand1;
            if (a0.getAxis() == 2 && a1.getAxis() == 3) {
                b = new Block();
                b.setChildren(new Expression[]{this.operand0, this.operand1});
                return b;
            }
            if (a1.getAxis() == 2 && a0.getAxis() == 3) {
                b = new Block();
                b.setChildren(new Expression[]{this.operand1, this.operand0});
                return b;
            }
        }
        if (this.operator == 23 && !Cardinality.allowsMany(this.operand0.getCardinality())) {
            return new SingletonIntersectExpression(this.operand0, this.operator, ExpressionTool.unsorted(visitor.getConfiguration().obtainOptimizer(), this.operand1, false));
        }
        if (this.operator == 23 && !Cardinality.allowsMany(this.operand1.getCardinality())) {
            return new SingletonIntersectExpression(this.operand1, this.operator, ExpressionTool.unsorted(visitor.getConfiguration().obtainOptimizer(), this.operand0, false));
        }
        return this;
    }

    public Expression copy() {
        return new VennExpression(this.operand0.copy(), this.operator, this.operand1.copy());
    }

    public boolean equals(Object other) {
        if (other instanceof VennExpression) {
            VennExpression b = (VennExpression)other;
            if (this.operator != b.operator) {
                return false;
            }
            if (this.operand0.equals(b.operand0) && this.operand1.equals(b.operand1)) {
                return true;
            }
            if (this.operator == 1 || this.operator == 23) {
                HashSet s0 = new HashSet(10);
                this.gatherComponents(this.operator, s0);
                HashSet s1 = new HashSet(10);
                ((VennExpression)other).gatherComponents(this.operator, s1);
                return ((Object)s0).equals(s1);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.operand0.hashCode() ^ this.operand1.hashCode();
    }

    public SequenceIterator iterate(XPathContext c) throws XPathException {
        DocumentOrderIterator i1 = this.operand0.iterate(c);
        if ((this.operand0.getSpecialProperties() & 0x20000) == 0) {
            i1 = new DocumentOrderIterator(i1, GlobalOrderComparer.getInstance());
        }
        DocumentOrderIterator i2 = this.operand1.iterate(c);
        if ((this.operand1.getSpecialProperties() & 0x20000) == 0) {
            i2 = new DocumentOrderIterator(i2, GlobalOrderComparer.getInstance());
        }
        switch (this.operator) {
            case 1: {
                return new UnionEnumeration(i1, i2, GlobalOrderComparer.getInstance());
            }
            case 23: {
                return new IntersectionEnumeration(i1, i2, GlobalOrderComparer.getInstance());
            }
            case 24: {
                return new DifferenceEnumeration(i1, i2, GlobalOrderComparer.getInstance());
            }
        }
        throw new UnsupportedOperationException("Unknown operator in Venn Expression");
    }

    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        if (this.operator == 1) {
            return this.operand0.effectiveBooleanValue(context) || this.operand1.effectiveBooleanValue(context);
        }
        return super.effectiveBooleanValue(context);
    }
}

