/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.CallableExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.UnparsedText;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public class UnparsedTextAvailable
extends UnparsedText
implements CallableExpression {
    public Item evaluateItem(XPathContext context) throws XPathException {
        StringValue hrefVal = (StringValue)this.argument[0].evaluateItem(context);
        String encoding = this.getNumberOfArguments() == 2 ? this.argument[1].evaluateItem(context).getStringValue() : null;
        return BooleanValue.get(this.evalUnparsedTextAvailable(hrefVal, encoding, context));
    }

    public SequenceIterator call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
        StringValue hrefVal = (StringValue)arguments[0].next();
        String encoding = this.getNumberOfArguments() == 2 ? arguments[1].next().getStringValue() : null;
        return Value.asIterator(BooleanValue.get(this.evalUnparsedTextAvailable(hrefVal, encoding, context)));
    }

    public boolean evalUnparsedTextAvailable(StringValue hrefVal, String encoding, XPathContext context) throws XPathException {
        try {
            if (hrefVal == null) {
                return false;
            }
            String href = hrefVal.getStringValue();
            this.readFile(href, this.expressionBaseURI, encoding, context);
        }
        catch (XPathException err) {
            return false;
        }
        return true;
    }
}

