#! perl -I. -w
use t::Test::abeltje;

use Business::IBAN::Validator;

my $v = Business::IBAN::Validator->new();
isa_ok($v, 'Business::IBAN::Validator');

while (my $line = <DATA>) {
    chomp($line);
    my ($countrycode) = $line =~ m{^ (..) }x;
    my ($iban, $is_sepa) = split /,/, $line;
    lives_ok(
        sub { $v->validate($iban) },
        "Valid: $iban"
    );
    is($v->is_sepa($iban), $is_sepa, "$countrycode: Sepa $is_sepa");
}

abeltje_done_testing();

__DATA__
AD1200012030200359100100,1
AD12 0001 2030 2003 5910 0100,1
AE070331234567890123456,0
AE07 0331 2345 6789 0123 456,0
AL47212110090000000235698741,0
AL47 2121 1009 0000 0002 3569 8741,0
AT611904300234573201,1
AT61 1904 3002 3457 3201,1
AZ21NABZ00000000137010001944,0
AZ21 NABZ 0000 0000 1370 1000 1944,0
BA391290079401028494,0
BA39 1290 0794 0102 8494,0
BE68539007547034,1
BE68 5390 0754 7034,1
BG80BNBG96611020345678,1
BG80 BNBG 9661 1020 3456 78,1
BH67BMAG00001299123456,0
BH67 BMAG 0000 1299 1234 56,0
BI4210000100010000332045181,0
BI42 10000 10001 00003320451 81,0
BR1800360305000010009795493C1,0
BR18 0036 0305 0000 1000 9795 493C 1,0
BY13NBRB3600900000002Z00AB00,0
BY13 NBRB 3600 9000 0000 2Z00 AB00,0
CH9300762011623852957,1
CH93 0076 2011 6238 5295 7,1
CR05015202001026284066,0
CR05 0152 0200 1026 2840 66,0
CY17002001280000001200527600,1
CY17 0020 0128 0000 0012 0052 7600,1
CZ6508000000192000145399,1
CZ65 0800 0000 1920 0014 5399,1
DE89370400440532013000,1
DE89 3704 0044 0532 0130 00,1
DJ2100010000000154000100186,0
DJ21 0001 0000 0001 5400 0100 186,0
DK5000400440116243,1
DK50 0040 0440 1162 43,1
DO28BAGR00000001212453611324,0
DO28 BAGR 0000 0001 2124 5361 1324,0
EE382200221020145685,1
EE38 2200 2210 2014 5685,1
EG380019000500000000263180002,0
EG380019000500000000263180002,0
ES9121000418450200051332,1
ES91 2100 0418 4502 0005 1332,1
FI2112345600000785,1
FI21 1234 5600 0007 85,1
FK88SC123456789012,0
FK88 SC12 3456 7890 12,0
FO6264600001631634,0
FO62 6460 0001 6316 34,0
FR1420041010050500013M02606,1
FR14 2004 1010 0505 0001 3M02 606,1
GB29NWBK60161331926819,1
GB29 NWBK 6016 1331 9268 19,1
GE29NB0000000101904917,0
GE29 NB00 0000 0101 9049 17,0
GI75NWBK000000007099453,1
GI75 NWBK 0000 0000 7099 453,1
GL8964710001000206,0
GL89 6471 0001 0002 06,0
GR1601101250000000012300695,1
GR16 0110 1250 0000 0001 2300 695,1
GT82TRAJ01020000001210029690,0
GT82 TRAJ 0102 0000 0012 1002 9690,0
HR1210010051863000160,1
HR12 1001 0051 8630 0016 0,1
HU42117730161111101800000000,1
HU42 1177 3016 1111 1018 0000 0000,1
IE29AIBK93115212345678,1
IE29 AIBK 9311 5212 3456 78,1
IL620108000000099999999,0
IL62 0108 0000 0009 9999 999,0
IQ98NBIQ850123456789012,0
IQ98 NBIQ 8501 2345 6789 012,0
IS140159260076545510730339,0
IS14 0159 2600 7654 5510 7303 39,0
IT60X0542811101000000123456,1
IT60 X054 2811 1010 0000 0123 456,1
JO94CBJO0010000000000131000302,0
JO94 CBJO 0010 0000 0000 0131 0003 02,0
KW81CBKU0000000000001234560101,0
KW81 CBKU 0000 0000 0000 1234 5601 01,0
KZ86125KZT5004100100,0
KZ86 125K ZT50 0410 0100,0
LB62099900000001001901229114,0
LB62 0999 0000 0001 0019 0122 9114,0
LC55HEMM000100010012001200023015,0
LC55 HEMM 0001 0001 0012 0012 0002 3015,0
LI21088100002324013AA,1
LI21 0881 0000 2324 013A A,1
LT121000011101001000,1
LT12 1000 0111 0100 1000,1
LU280019400644750000,1
LU28 0019 4006 4475 0000,1
LV80BANK0000435195001,1
LV80 BANK 0000 4351 9500 1,1
LY83002048000020100120361,0
LY83 002 048 000020100120361,0
MC5811222000010123456789030,1
MC58 1122 2000 0101 2345 6789 030,1
MD24AG000225100013104168,0
MD24 AG00 0225 1000 1310 4168,0
ME25505000012345678951,0
ME25 5050 0001 2345 6789 51,0
MK07250120000058984,0
MK07 2501 2000 0058 984,0
MN121234123456789123,0
MN12 1234 1234 5678 9123,0
MR1300020001010000123456753,0
MR13 0002 0001 0100 0012 3456 753,0
MT84MALT011000012345MTLCAST001S,1
MT84 MALT 0110 0001 2345 MTLC AST0 01S,1
MU17BOMM0101101030300200000MUR,0
MU17 BOMM 0101 1010 3030 0200 000M UR,0
NI45BAPR00000013000003558124,0
NI45 BAPR 0000 0013 0000 0355 8124,0
NL91ABNA0417164300,1
NL91 ABNA 0417 1643 00,1
NO9386011117947,1
NO93 8601 1117 947,1
PK36SCBL0000001123456702,0
PK36 SCBL 0000 0011 2345 6702,0
PL61109010140000071219812874,1
PL61 1090 1014 0000 0712 1981 2874,1
PS92PALS000000000400123456702,0
PS92 PALS 0000 0000 0400 1234 5670 2,0
PT50000201231234567890154,1
PT50 0002 0123 1234 5678 9015 4,1
QA58DOHB00001234567890ABCDEFG,0
QA58 DOHB 0000 1234 5678 90AB CDEF G,0
RO49AAAA1B31007593840000,1
RO49 AAAA 1B31 0075 9384 0000,1
RS35260005601001611379,0
RS35 2600 0560 1001 6113 79,0
RU0304452522540817810538091310419,0
RU03 0445 2522 5408 1781 0538 0913 1041 9,0
SA0380000000608010167519,0
SA03 8000 0000 6080 1016 7519,0
SC18SSCB11010000000000001497USD,0
SC18 SSCB 1101 0000 0000 0000 1497 USD,0
SD2129010501234001,0
SD21 2901 0501 2340 01,0
SE4550000000058398257466,1
SE45 5000 0000 0583 9825 7466,1
SI56263300012039086,1
SI56 2633 0001 2039 086,1
SK3112000000198742637541,1
SK31 1200 0000 1987 4263 7541,1
SM86U0322509800000000270100,1
SM86 U032 2509 8000 0000 0270 100,1
SO211000001001000100141,0
SO21 1000 0010 0100 0100 141,0
ST32000200010192194210112,0
ST32 0002 0001 0192 1942 1011 2 ,0
SV62CENR00000000000000700025,0
SV 62 CENR 00000000000000700025,0
TL380080012345678910157,0
TL38 0080 0123 4567 8910 157,0
TN5910006035183598478831,0
TN59 1000 6035 1835 9847 8831,0
TR330006100519786457841326,0
TR33 0006 1005 1978 6457 8413 26,0
UA213223130000026007233566001,0
UA21 3223 1300 0002 6007 2335 6600 1,0
VA59001123000012345678,1
VA59 001 1230 0001 2345 678,1
VG96VPVG0000012345678901,0
VG96 VPVG 0000 0123 4567 8901,0
