# This Makefile.PL for  was generated by Dist::Zilla.
# Don't edit it but the dist.ini used to construct it.
BEGIN { require v5.10.1; }
use strict;
use warnings;
use ExtUtils::MakeMaker 6.30;

my %WriteMakefileArgs = (
  'ABSTRACT' => 'Portably access the process table',
  'AUTHOR' => 'Brendan Byrd <BBYRD@CPAN.org>',
  'BUILD_REQUIRES' => {
    'Test::CheckDeps' => '0.002',
    'Test::Most' => '0.01'
  },
  'CONFIGURE_REQUIRES' => {},
  'DISTNAME' => 'P9Y-ProcessTable',
  'EXE_FILES' => [],
  'LICENSE' => 'artistic_2',
  'NAME' => 'P9Y::ProcessTable',
  'PREREQ_PM' => {
    &os_deps,
    'Moo' => '0.009001',
    'Path::Class' => '0.17',
    'namespace::clean' => '0.06',
    'sanity' => '0.91'
  },
  'VERSION' => '0.95',
  'test' => {
    'TESTS' => 't/*.t'
  }
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

use v5.10;    

sub os_deps {
   for (lc $^O) {
      when (/mswin32|cygwin/) {
         return (
            'Win32::Process'       => 0,
            'Win32::Process::Info' => 0,
         );
      }
      when ('freebsd') {
         return ('BSD::Process' => 0);
      }
      when ('darwin') {
         return ('Proc::ProcessTable' => 0.45);
      }
      when ('os2') {
         return ('OS2::Process' => 0);
      }
      when ('vms') {
         return ('VMS::Process' => 0);
      }
      when ('dos') {
         die "Heh, DOS processes... you're funny!";
      }
      default {
         # let's hope they have /proc
         unless ( -d '/proc' ) {
            die lc $^O =~ /bsd|dragonfly/ ? 
               "BSD::Process only works for FreeBSD.  Encourage development for $^O, or write your own and I can include it here." :
               "No idea how to handle $^O processes.  Email me with more information!";
         }
      }
   }
   return ();
}
