/*
 * Copyright (C) 2023, 2024, 2025, 2026, Arnold David Robbins.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * “AS IS” AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// The tables in this file used for different classifications of
// characters were created by running C code calling into GLIBC
// version 2.39.  The Unicode support in that version of GLIBC 
// is for the Unicode 14.0 standard.  With any luck, the tables
// will be updated occasionally to newer standards. :-)

#include <assert.h>
#include <stdio.h>
#include <stdbool.h>
#include <stddef.h>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <wctype.h>
#include <wchar.h>
#include <locale.h>
#ifdef HAVE_PTHREADS
#include <pthread.h>
#endif
#include "charset.h"	// for the charset_t typedef

#define INITIAL_ALLOCATION 10
#define MAX_CODE_POINT 0x10ffff	// max Unicode code point

typedef struct set_item {
	int32_t start, end;
} set_item;
struct _charset {
	bool     no_newlines;       // If \n can't be in the set
	bool     finalized;         // No more changes possible
	bool	 is_utf8;			// True if using a UTF-8 character set
	int		 mb_cur_max;		// Value of MB_CUR_MAX when the charset was created
	size_t   nchars_inuse;      // Number of characters used
	size_t   nchars_allocated;  // Number of characters allocated
	int32_t  *chars;            // Characters added to the set
	size_t   nelems;            // Number of elements (items) in use
	size_t   allocated;         // Number allocated
	size_t	 nelems8bit;		// Number of elements covering 0-255
	set_item *items;            // Array of items
};

static const set_item digit[] = {
	{ 48, 57 },
	{ -1, -1 },	// end markers
};
static const set_item cntrl[] = {
	{ 0, 31 },
	{ 127, 159 },
	{ 8232, 8233 },
	{ -1, -1 },	// end markers
};
static const set_item xdigit[] = {
	{ 48, 57 },
	{ 65, 70 },
	{ 97, 102 },
	{ -1, -1 },	// end markers
};
static const set_item print_additional[] = {
	{ 32, 126 },
	{ 5120, 5788 },
	{ 8192, 8231 },
	{ 8234, 8292 },
	{ 12288, 12351 },
	{ -1, -1 },	// end markers
};
static const set_item blank[] = {
	{ 9, 9 },
	{ 32, 32 },
	{ 5760, 5760 },
	{ 8192, 8198 },
	{ 8200, 8202 },
	{ 8287, 8287 },
	{ 12288, 12288 },
	{ -1, -1 },	// end markers
};
static const set_item graph_additional[] = {
	{ 33, 126 },
	{ 5120, 5759 },
	{ 5761, 5788 },
	{ 8199, 8199 },
	{ 8203, 8231 },
	{ 8234, 8286 },
	{ 8288, 8292 },
	{ 12289, 12351 },
	{ -1, -1 },	// end markers
};
static const set_item space[] = {
	{ 9, 13 },
	{ 32, 32 },
	{ 5760, 5760 },
	{ 8192, 8198 },
	{ 8200, 8202 },
	{ 8232, 8233 },
	{ 8287, 8287 },
	{ 12288, 12288 },
	{ -1, -1 },	// end markers
};
static const set_item punct[] = {
	{ 33, 47 },
	{ 58, 64 },
	{ 91, 96 },
	{ 123, 126 },
	{ 160, 169 },
	{ 171, 180 },
	{ 182, 185 },
	{ 187, 191 },
	{ 215, 215 },
	{ 247, 247 },
	{ 706, 709 },
	{ 722, 735 },
	{ 741, 747 },
	{ 749, 749 },
	{ 751, 836 },
	{ 838, 879 },
	{ 885, 885 },
	{ 894, 894 },
	{ 900, 901 },
	{ 903, 903 },
	{ 1014, 1014 },
	{ 1154, 1161 },
	{ 1370, 1375 },
	{ 1417, 1418 },
	{ 1421, 1423 },
	{ 1425, 1455 },
	{ 1470, 1470 },
	{ 1472, 1472 },
	{ 1475, 1475 },
	{ 1478, 1478 },
	{ 1523, 1524 },
	{ 1536, 1551 },
	{ 1563, 1567 },
	{ 1624, 1624 },
	{ 1642, 1645 },
	{ 1748, 1748 },
	{ 1757, 1760 },
	{ 1769, 1772 },
	{ 1789, 1790 },
	{ 1792, 1805 },
	{ 1807, 1807 },
	{ 1856, 1866 },
	{ 2027, 2035 },
	{ 2038, 2041 },
	{ 2045, 2047 },
	{ 2072, 2073 },
	{ 2093, 2093 },
	{ 2096, 2110 },
	{ 2137, 2139 },
	{ 2142, 2142 },
	{ 2184, 2184 },
	{ 2192, 2193 },
	{ 2200, 2207 },
	{ 2250, 2259 },
	{ 2272, 2274 },
	{ 2282, 2287 },
	{ 2364, 2364 },
	{ 2381, 2381 },
	{ 2385, 2388 },
	{ 2404, 2405 },
	{ 2416, 2416 },
	{ 2492, 2492 },
	{ 2509, 2509 },
	{ 2546, 2555 },
	{ 2557, 2558 },
	{ 2620, 2620 },
	{ 2637, 2637 },
	{ 2678, 2678 },
	{ 2748, 2748 },
	{ 2765, 2765 },
	{ 2800, 2801 },
	{ 2813, 2815 },
	{ 2876, 2876 },
	{ 2893, 2893 },
	{ 2901, 2901 },
	{ 2928, 2928 },
	{ 2930, 2935 },
	{ 3021, 3021 },
	{ 3056, 3066 },
	{ 3076, 3076 },
	{ 3132, 3132 },
	{ 3149, 3149 },
	{ 3191, 3199 },
	{ 3204, 3204 },
	{ 3260, 3260 },
	{ 3277, 3277 },
	{ 3387, 3388 },
	{ 3405, 3405 },
	{ 3407, 3407 },
	{ 3416, 3422 },
	{ 3440, 3449 },
	{ 3530, 3530 },
	{ 3572, 3572 },
	{ 3647, 3647 },
	{ 3655, 3660 },
	{ 3662, 3663 },
	{ 3674, 3675 },
	{ 3770, 3770 },
	{ 3784, 3788 },
	{ 3841, 3871 },
	{ 3882, 3903 },
	{ 3970, 3975 },
	{ 4030, 4044 },
	{ 4046, 4058 },
	{ 4151, 4151 },
	{ 4153, 4154 },
	{ 4170, 4175 },
	{ 4254, 4255 },
	{ 4347, 4347 },
	{ 4957, 4988 },
	{ 5008, 5017 },
	{ 5120, 5120 },
	{ 5741, 5742 },
	{ 5787, 5788 },
	{ 5867, 5869 },
	{ 5908, 5909 },
	{ 5940, 5942 },
	{ 6068, 6069 },
	{ 6089, 6102 },
	{ 6104, 6107 },
	{ 6109, 6109 },
	{ 6128, 6137 },
	{ 6144, 6159 },
	{ 6457, 6459 },
	{ 6464, 6464 },
	{ 6468, 6469 },
	{ 6618, 6618 },
	{ 6622, 6655 },
	{ 6686, 6687 },
	{ 6752, 6752 },
	{ 6773, 6780 },
	{ 6783, 6783 },
	{ 6816, 6822 },
	{ 6824, 6829 },
	{ 6832, 6846 },
	{ 6849, 6859 },
	{ 6964, 6964 },
	{ 6980, 6980 },
	{ 7002, 7038 },
	{ 7082, 7083 },
	{ 7142, 7142 },
	{ 7154, 7155 },
	{ 7164, 7167 },
	{ 7223, 7223 },
	{ 7227, 7231 },
	{ 7294, 7295 },
	{ 7360, 7367 },
	{ 7376, 7400 },
	{ 7405, 7405 },
	{ 7412, 7412 },
	{ 7415, 7417 },
	{ 7616, 7654 },
	{ 7669, 7679 },
	{ 8125, 8125 },
	{ 8127, 8129 },
	{ 8141, 8143 },
	{ 8157, 8159 },
	{ 8173, 8175 },
	{ 8189, 8190 },
	{ 8199, 8199 },
	{ 8203, 8231 },
	{ 8234, 8286 },
	{ 8288, 8292 },
	{ 8294, 8304 },
	{ 8308, 8318 },
	{ 8320, 8334 },
	{ 8352, 8384 },
	{ 8400, 8432 },
	{ 8448, 8449 },
	{ 8451, 8454 },
	{ 8456, 8457 },
	{ 8468, 8468 },
	{ 8470, 8472 },
	{ 8478, 8483 },
	{ 8485, 8485 },
	{ 8487, 8487 },
	{ 8489, 8489 },
	{ 8494, 8494 },
	{ 8506, 8507 },
	{ 8512, 8516 },
	{ 8522, 8525 },
	{ 8527, 8543 },
	{ 8585, 8587 },
	{ 8592, 9254 },
	{ 9280, 9290 },
	{ 9312, 9397 },
	{ 9450, 11123 },
	{ 11126, 11157 },
	{ 11159, 11263 },
	{ 11493, 11498 },
	{ 11503, 11505 },
	{ 11513, 11519 },
	{ 11632, 11632 },
	{ 11647, 11647 },
	{ 11776, 11822 },
	{ 11824, 11869 },
	{ 11904, 11929 },
	{ 11931, 12019 },
	{ 12032, 12245 },
	{ 12272, 12283 },
	{ 12289, 12292 },
	{ 12296, 12320 },
	{ 12330, 12336 },
	{ 12342, 12343 },
	{ 12349, 12351 },
	{ 12441, 12444 },
	{ 12448, 12448 },
	{ 12539, 12539 },
	{ 12688, 12703 },
	{ 12736, 12771 },
	{ 12800, 12830 },
	{ 12832, 13311 },
	{ 19904, 19967 },
	{ 42128, 42182 },
	{ 42238, 42239 },
	{ 42509, 42511 },
	{ 42607, 42611 },
	{ 42620, 42622 },
	{ 42736, 42743 },
	{ 42752, 42774 },
	{ 42784, 42785 },
	{ 42889, 42890 },
	{ 43014, 43014 },
	{ 43048, 43052 },
	{ 43056, 43065 },
	{ 43124, 43127 },
	{ 43204, 43204 },
	{ 43214, 43215 },
	{ 43232, 43249 },
	{ 43256, 43258 },
	{ 43260, 43260 },
	{ 43307, 43311 },
	{ 43347, 43347 },
	{ 43359, 43359 },
	{ 43443, 43443 },
	{ 43456, 43469 },
	{ 43486, 43487 },
	{ 43612, 43615 },
	{ 43639, 43641 },
	{ 43711, 43711 },
	{ 43713, 43713 },
	{ 43742, 43743 },
	{ 43760, 43761 },
	{ 43766, 43766 },
	{ 43867, 43867 },
	{ 43882, 43883 },
	{ 44011, 44013 },
	{ 57344, 63743 },
	{ 64297, 64297 },
	{ 64434, 64450 },
	{ 64830, 64847 },
	{ 64975, 64975 },
	{ 65020, 65049 },
	{ 65056, 65106 },
	{ 65108, 65126 },
	{ 65128, 65131 },
	{ 65279, 65279 },
	{ 65281, 65295 },
	{ 65306, 65312 },
	{ 65339, 65344 },
	{ 65371, 65381 },
	{ 65504, 65510 },
	{ 65512, 65518 },
	{ 65529, 65533 },
	{ 65792, 65794 },
	{ 65799, 65843 },
	{ 65847, 65855 },
	{ 65909, 65934 },
	{ 65936, 65948 },
	{ 65952, 65952 },
	{ 66000, 66045 },
	{ 66272, 66299 },
	{ 66336, 66339 },
	{ 66463, 66463 },
	{ 66512, 66512 },
	{ 66927, 66927 },
	{ 67671, 67679 },
	{ 67703, 67711 },
	{ 67751, 67759 },
	{ 67835, 67839 },
	{ 67862, 67867 },
	{ 67871, 67871 },
	{ 67903, 67903 },
	{ 68028, 68029 },
	{ 68032, 68047 },
	{ 68050, 68095 },
	{ 68152, 68154 },
	{ 68159, 68168 },
	{ 68176, 68184 },
	{ 68221, 68223 },
	{ 68253, 68255 },
	{ 68296, 68296 },
	{ 68325, 68326 },
	{ 68331, 68342 },
	{ 68409, 68415 },
	{ 68440, 68447 },
	{ 68472, 68479 },
	{ 68505, 68508 },
	{ 68521, 68527 },
	{ 68858, 68863 },
	{ 69216, 69246 },
	{ 69293, 69293 },
	{ 69405, 69414 },
	{ 69446, 69465 },
	{ 69506, 69513 },
	{ 69573, 69579 },
	{ 69702, 69709 },
	{ 69714, 69733 },
	{ 69744, 69744 },
	{ 69759, 69761 },
	{ 69817, 69825 },
	{ 69837, 69837 },
	{ 69939, 69940 },
	{ 69952, 69955 },
	{ 70003, 70005 },
	{ 70080, 70080 },
	{ 70085, 70093 },
	{ 70107, 70107 },
	{ 70109, 70111 },
	{ 70113, 70132 },
	{ 70197, 70198 },
	{ 70200, 70205 },
	{ 70313, 70313 },
	{ 70377, 70378 },
	{ 70459, 70460 },
	{ 70477, 70477 },
	{ 70502, 70508 },
	{ 70512, 70516 },
	{ 70722, 70722 },
	{ 70726, 70726 },
	{ 70731, 70735 },
	{ 70746, 70747 },
	{ 70749, 70750 },
	{ 70850, 70851 },
	{ 70854, 70854 },
	{ 71103, 71127 },
	{ 71231, 71231 },
	{ 71233, 71235 },
	{ 71264, 71276 },
	{ 71350, 71351 },
	{ 71353, 71353 },
	{ 71467, 71467 },
	{ 71482, 71487 },
	{ 71737, 71739 },
	{ 71914, 71922 },
	{ 71997, 71998 },
	{ 72003, 72006 },
	{ 72160, 72160 },
	{ 72162, 72162 },
	{ 72243, 72244 },
	{ 72255, 72263 },
	{ 72344, 72348 },
	{ 72350, 72354 },
	{ 72767, 72767 },
	{ 72769, 72773 },
	{ 72794, 72812 },
	{ 72816, 72817 },
	{ 73026, 73026 },
	{ 73028, 73029 },
	{ 73111, 73111 },
	{ 73463, 73464 },
	{ 73664, 73713 },
	{ 73727, 73727 },
	{ 74864, 74868 },
	{ 77809, 77810 },
	{ 78896, 78904 },
	{ 92782, 92783 },
	{ 92912, 92917 },
	{ 92976, 92991 },
	{ 92996, 92997 },
	{ 93019, 93025 },
	{ 93824, 93850 },
	{ 94178, 94178 },
	{ 94180, 94180 },
	{ 113820, 113821 },
	{ 113823, 113827 },
	{ 118528, 118573 },
	{ 118576, 118598 },
	{ 118608, 118723 },
	{ 118784, 119029 },
	{ 119040, 119078 },
	{ 119081, 119274 },
	{ 119296, 119365 },
	{ 119520, 119539 },
	{ 119552, 119638 },
	{ 119648, 119672 },
	{ 120513, 120513 },
	{ 120539, 120539 },
	{ 120571, 120571 },
	{ 120597, 120597 },
	{ 120629, 120629 },
	{ 120655, 120655 },
	{ 120687, 120687 },
	{ 120713, 120713 },
	{ 120745, 120745 },
	{ 120771, 120771 },
	{ 120832, 121483 },
	{ 121499, 121503 },
	{ 121505, 121519 },
	{ 123184, 123190 },
	{ 123215, 123215 },
	{ 123566, 123566 },
	{ 123628, 123631 },
	{ 123647, 123647 },
	{ 125127, 125142 },
	{ 125252, 125254 },
	{ 125256, 125258 },
	{ 125278, 125279 },
	{ 126065, 126132 },
	{ 126209, 126269 },
	{ 126704, 126705 },
	{ 126976, 127019 },
	{ 127024, 127123 },
	{ 127136, 127150 },
	{ 127153, 127167 },
	{ 127169, 127183 },
	{ 127185, 127221 },
	{ 127232, 127279 },
	{ 127306, 127311 },
	{ 127338, 127343 },
	{ 127370, 127405 },
	{ 127462, 127490 },
	{ 127504, 127547 },
	{ 127552, 127560 },
	{ 127568, 127569 },
	{ 127584, 127589 },
	{ 127744, 128727 },
	{ 128733, 128748 },
	{ 128752, 128764 },
	{ 128768, 128883 },
	{ 128896, 128984 },
	{ 128992, 129003 },
	{ 129008, 129008 },
	{ 129024, 129035 },
	{ 129040, 129095 },
	{ 129104, 129113 },
	{ 129120, 129159 },
	{ 129168, 129197 },
	{ 129200, 129201 },
	{ 129280, 129619 },
	{ 129632, 129645 },
	{ 129648, 129652 },
	{ 129656, 129660 },
	{ 129664, 129670 },
	{ 129680, 129708 },
	{ 129712, 129722 },
	{ 129728, 129733 },
	{ 129744, 129753 },
	{ 129760, 129767 },
	{ 129776, 129782 },
	{ 129792, 129938 },
	{ 129940, 129994 },
	{ 917505, 917505 },
	{ 917536, 917631 },
	{ 917760, 917999 },
	{ 983040, 1048573 },
	{ 1048576, 1114109 },
	{ -1, -1 },	// end markers
};
static const set_item upper[] = {
	{ 65, 90 },
	{ 192, 214 },
	{ 216, 222 },
	{ 256, 256 },
	{ 258, 258 },
	{ 260, 260 },
	{ 262, 262 },
	{ 264, 264 },
	{ 266, 266 },
	{ 268, 268 },
	{ 270, 270 },
	{ 272, 272 },
	{ 274, 274 },
	{ 276, 276 },
	{ 278, 278 },
	{ 280, 280 },
	{ 282, 282 },
	{ 284, 284 },
	{ 286, 286 },
	{ 288, 288 },
	{ 290, 290 },
	{ 292, 292 },
	{ 294, 294 },
	{ 296, 296 },
	{ 298, 298 },
	{ 300, 300 },
	{ 302, 302 },
	{ 304, 304 },
	{ 306, 306 },
	{ 308, 308 },
	{ 310, 310 },
	{ 313, 313 },
	{ 315, 315 },
	{ 317, 317 },
	{ 319, 319 },
	{ 321, 321 },
	{ 323, 323 },
	{ 325, 325 },
	{ 327, 327 },
	{ 330, 330 },
	{ 332, 332 },
	{ 334, 334 },
	{ 336, 336 },
	{ 338, 338 },
	{ 340, 340 },
	{ 342, 342 },
	{ 344, 344 },
	{ 346, 346 },
	{ 348, 348 },
	{ 350, 350 },
	{ 352, 352 },
	{ 354, 354 },
	{ 356, 356 },
	{ 358, 358 },
	{ 360, 360 },
	{ 362, 362 },
	{ 364, 364 },
	{ 366, 366 },
	{ 368, 368 },
	{ 370, 370 },
	{ 372, 372 },
	{ 374, 374 },
	{ 376, 377 },
	{ 379, 379 },
	{ 381, 381 },
	{ 385, 386 },
	{ 388, 388 },
	{ 390, 391 },
	{ 393, 395 },
	{ 398, 401 },
	{ 403, 404 },
	{ 406, 408 },
	{ 412, 413 },
	{ 415, 416 },
	{ 418, 418 },
	{ 420, 420 },
	{ 422, 423 },
	{ 425, 425 },
	{ 428, 428 },
	{ 430, 431 },
	{ 433, 435 },
	{ 437, 437 },
	{ 439, 440 },
	{ 444, 444 },
	{ 452, 453 },
	{ 455, 456 },
	{ 458, 459 },
	{ 461, 461 },
	{ 463, 463 },
	{ 465, 465 },
	{ 467, 467 },
	{ 469, 469 },
	{ 471, 471 },
	{ 473, 473 },
	{ 475, 475 },
	{ 478, 478 },
	{ 480, 480 },
	{ 482, 482 },
	{ 484, 484 },
	{ 486, 486 },
	{ 488, 488 },
	{ 490, 490 },
	{ 492, 492 },
	{ 494, 494 },
	{ 497, 498 },
	{ 500, 500 },
	{ 502, 504 },
	{ 506, 506 },
	{ 508, 508 },
	{ 510, 510 },
	{ 512, 512 },
	{ 514, 514 },
	{ 516, 516 },
	{ 518, 518 },
	{ 520, 520 },
	{ 522, 522 },
	{ 524, 524 },
	{ 526, 526 },
	{ 528, 528 },
	{ 530, 530 },
	{ 532, 532 },
	{ 534, 534 },
	{ 536, 536 },
	{ 538, 538 },
	{ 540, 540 },
	{ 542, 542 },
	{ 544, 544 },
	{ 546, 546 },
	{ 548, 548 },
	{ 550, 550 },
	{ 552, 552 },
	{ 554, 554 },
	{ 556, 556 },
	{ 558, 558 },
	{ 560, 560 },
	{ 562, 562 },
	{ 570, 571 },
	{ 573, 574 },
	{ 577, 577 },
	{ 579, 582 },
	{ 584, 584 },
	{ 586, 586 },
	{ 588, 588 },
	{ 590, 590 },
	{ 880, 880 },
	{ 882, 882 },
	{ 886, 886 },
	{ 895, 895 },
	{ 902, 902 },
	{ 904, 906 },
	{ 908, 908 },
	{ 910, 911 },
	{ 913, 929 },
	{ 931, 939 },
	{ 975, 975 },
	{ 978, 980 },
	{ 984, 984 },
	{ 986, 986 },
	{ 988, 988 },
	{ 990, 990 },
	{ 992, 992 },
	{ 994, 994 },
	{ 996, 996 },
	{ 998, 998 },
	{ 1000, 1000 },
	{ 1002, 1002 },
	{ 1004, 1004 },
	{ 1006, 1006 },
	{ 1012, 1012 },
	{ 1015, 1015 },
	{ 1017, 1018 },
	{ 1021, 1071 },
	{ 1120, 1120 },
	{ 1122, 1122 },
	{ 1124, 1124 },
	{ 1126, 1126 },
	{ 1128, 1128 },
	{ 1130, 1130 },
	{ 1132, 1132 },
	{ 1134, 1134 },
	{ 1136, 1136 },
	{ 1138, 1138 },
	{ 1140, 1140 },
	{ 1142, 1142 },
	{ 1144, 1144 },
	{ 1146, 1146 },
	{ 1148, 1148 },
	{ 1150, 1150 },
	{ 1152, 1152 },
	{ 1162, 1162 },
	{ 1164, 1164 },
	{ 1166, 1166 },
	{ 1168, 1168 },
	{ 1170, 1170 },
	{ 1172, 1172 },
	{ 1174, 1174 },
	{ 1176, 1176 },
	{ 1178, 1178 },
	{ 1180, 1180 },
	{ 1182, 1182 },
	{ 1184, 1184 },
	{ 1186, 1186 },
	{ 1188, 1188 },
	{ 1190, 1190 },
	{ 1192, 1192 },
	{ 1194, 1194 },
	{ 1196, 1196 },
	{ 1198, 1198 },
	{ 1200, 1200 },
	{ 1202, 1202 },
	{ 1204, 1204 },
	{ 1206, 1206 },
	{ 1208, 1208 },
	{ 1210, 1210 },
	{ 1212, 1212 },
	{ 1214, 1214 },
	{ 1216, 1217 },
	{ 1219, 1219 },
	{ 1221, 1221 },
	{ 1223, 1223 },
	{ 1225, 1225 },
	{ 1227, 1227 },
	{ 1229, 1229 },
	{ 1232, 1232 },
	{ 1234, 1234 },
	{ 1236, 1236 },
	{ 1238, 1238 },
	{ 1240, 1240 },
	{ 1242, 1242 },
	{ 1244, 1244 },
	{ 1246, 1246 },
	{ 1248, 1248 },
	{ 1250, 1250 },
	{ 1252, 1252 },
	{ 1254, 1254 },
	{ 1256, 1256 },
	{ 1258, 1258 },
	{ 1260, 1260 },
	{ 1262, 1262 },
	{ 1264, 1264 },
	{ 1266, 1266 },
	{ 1268, 1268 },
	{ 1270, 1270 },
	{ 1272, 1272 },
	{ 1274, 1274 },
	{ 1276, 1276 },
	{ 1278, 1278 },
	{ 1280, 1280 },
	{ 1282, 1282 },
	{ 1284, 1284 },
	{ 1286, 1286 },
	{ 1288, 1288 },
	{ 1290, 1290 },
	{ 1292, 1292 },
	{ 1294, 1294 },
	{ 1296, 1296 },
	{ 1298, 1298 },
	{ 1300, 1300 },
	{ 1302, 1302 },
	{ 1304, 1304 },
	{ 1306, 1306 },
	{ 1308, 1308 },
	{ 1310, 1310 },
	{ 1312, 1312 },
	{ 1314, 1314 },
	{ 1316, 1316 },
	{ 1318, 1318 },
	{ 1320, 1320 },
	{ 1322, 1322 },
	{ 1324, 1324 },
	{ 1326, 1326 },
	{ 1329, 1366 },
	{ 4256, 4293 },
	{ 4295, 4295 },
	{ 4301, 4301 },
	{ 5024, 5109 },
	{ 7312, 7354 },
	{ 7357, 7359 },
	{ 7680, 7680 },
	{ 7682, 7682 },
	{ 7684, 7684 },
	{ 7686, 7686 },
	{ 7688, 7688 },
	{ 7690, 7690 },
	{ 7692, 7692 },
	{ 7694, 7694 },
	{ 7696, 7696 },
	{ 7698, 7698 },
	{ 7700, 7700 },
	{ 7702, 7702 },
	{ 7704, 7704 },
	{ 7706, 7706 },
	{ 7708, 7708 },
	{ 7710, 7710 },
	{ 7712, 7712 },
	{ 7714, 7714 },
	{ 7716, 7716 },
	{ 7718, 7718 },
	{ 7720, 7720 },
	{ 7722, 7722 },
	{ 7724, 7724 },
	{ 7726, 7726 },
	{ 7728, 7728 },
	{ 7730, 7730 },
	{ 7732, 7732 },
	{ 7734, 7734 },
	{ 7736, 7736 },
	{ 7738, 7738 },
	{ 7740, 7740 },
	{ 7742, 7742 },
	{ 7744, 7744 },
	{ 7746, 7746 },
	{ 7748, 7748 },
	{ 7750, 7750 },
	{ 7752, 7752 },
	{ 7754, 7754 },
	{ 7756, 7756 },
	{ 7758, 7758 },
	{ 7760, 7760 },
	{ 7762, 7762 },
	{ 7764, 7764 },
	{ 7766, 7766 },
	{ 7768, 7768 },
	{ 7770, 7770 },
	{ 7772, 7772 },
	{ 7774, 7774 },
	{ 7776, 7776 },
	{ 7778, 7778 },
	{ 7780, 7780 },
	{ 7782, 7782 },
	{ 7784, 7784 },
	{ 7786, 7786 },
	{ 7788, 7788 },
	{ 7790, 7790 },
	{ 7792, 7792 },
	{ 7794, 7794 },
	{ 7796, 7796 },
	{ 7798, 7798 },
	{ 7800, 7800 },
	{ 7802, 7802 },
	{ 7804, 7804 },
	{ 7806, 7806 },
	{ 7808, 7808 },
	{ 7810, 7810 },
	{ 7812, 7812 },
	{ 7814, 7814 },
	{ 7816, 7816 },
	{ 7818, 7818 },
	{ 7820, 7820 },
	{ 7822, 7822 },
	{ 7824, 7824 },
	{ 7826, 7826 },
	{ 7828, 7828 },
	{ 7838, 7838 },
	{ 7840, 7840 },
	{ 7842, 7842 },
	{ 7844, 7844 },
	{ 7846, 7846 },
	{ 7848, 7848 },
	{ 7850, 7850 },
	{ 7852, 7852 },
	{ 7854, 7854 },
	{ 7856, 7856 },
	{ 7858, 7858 },
	{ 7860, 7860 },
	{ 7862, 7862 },
	{ 7864, 7864 },
	{ 7866, 7866 },
	{ 7868, 7868 },
	{ 7870, 7870 },
	{ 7872, 7872 },
	{ 7874, 7874 },
	{ 7876, 7876 },
	{ 7878, 7878 },
	{ 7880, 7880 },
	{ 7882, 7882 },
	{ 7884, 7884 },
	{ 7886, 7886 },
	{ 7888, 7888 },
	{ 7890, 7890 },
	{ 7892, 7892 },
	{ 7894, 7894 },
	{ 7896, 7896 },
	{ 7898, 7898 },
	{ 7900, 7900 },
	{ 7902, 7902 },
	{ 7904, 7904 },
	{ 7906, 7906 },
	{ 7908, 7908 },
	{ 7910, 7910 },
	{ 7912, 7912 },
	{ 7914, 7914 },
	{ 7916, 7916 },
	{ 7918, 7918 },
	{ 7920, 7920 },
	{ 7922, 7922 },
	{ 7924, 7924 },
	{ 7926, 7926 },
	{ 7928, 7928 },
	{ 7930, 7930 },
	{ 7932, 7932 },
	{ 7934, 7934 },
	{ 7944, 7951 },
	{ 7960, 7965 },
	{ 7976, 7983 },
	{ 7992, 7999 },
	{ 8008, 8013 },
	{ 8025, 8025 },
	{ 8027, 8027 },
	{ 8029, 8029 },
	{ 8031, 8031 },
	{ 8040, 8047 },
	{ 8072, 8079 },
	{ 8088, 8095 },
	{ 8104, 8111 },
	{ 8120, 8124 },
	{ 8136, 8140 },
	{ 8152, 8155 },
	{ 8168, 8172 },
	{ 8184, 8188 },
	{ 8450, 8450 },
	{ 8455, 8455 },
	{ 8459, 8461 },
	{ 8464, 8466 },
	{ 8469, 8469 },
	{ 8473, 8477 },
	{ 8484, 8484 },
	{ 8486, 8486 },
	{ 8488, 8488 },
	{ 8490, 8493 },
	{ 8496, 8499 },
	{ 8510, 8511 },
	{ 8517, 8517 },
	{ 8544, 8559 },
	{ 8579, 8579 },
	{ 9398, 9423 },
	{ 11264, 11311 },
	{ 11360, 11360 },
	{ 11362, 11364 },
	{ 11367, 11367 },
	{ 11369, 11369 },
	{ 11371, 11371 },
	{ 11373, 11376 },
	{ 11378, 11378 },
	{ 11381, 11381 },
	{ 11390, 11392 },
	{ 11394, 11394 },
	{ 11396, 11396 },
	{ 11398, 11398 },
	{ 11400, 11400 },
	{ 11402, 11402 },
	{ 11404, 11404 },
	{ 11406, 11406 },
	{ 11408, 11408 },
	{ 11410, 11410 },
	{ 11412, 11412 },
	{ 11414, 11414 },
	{ 11416, 11416 },
	{ 11418, 11418 },
	{ 11420, 11420 },
	{ 11422, 11422 },
	{ 11424, 11424 },
	{ 11426, 11426 },
	{ 11428, 11428 },
	{ 11430, 11430 },
	{ 11432, 11432 },
	{ 11434, 11434 },
	{ 11436, 11436 },
	{ 11438, 11438 },
	{ 11440, 11440 },
	{ 11442, 11442 },
	{ 11444, 11444 },
	{ 11446, 11446 },
	{ 11448, 11448 },
	{ 11450, 11450 },
	{ 11452, 11452 },
	{ 11454, 11454 },
	{ 11456, 11456 },
	{ 11458, 11458 },
	{ 11460, 11460 },
	{ 11462, 11462 },
	{ 11464, 11464 },
	{ 11466, 11466 },
	{ 11468, 11468 },
	{ 11470, 11470 },
	{ 11472, 11472 },
	{ 11474, 11474 },
	{ 11476, 11476 },
	{ 11478, 11478 },
	{ 11480, 11480 },
	{ 11482, 11482 },
	{ 11484, 11484 },
	{ 11486, 11486 },
	{ 11488, 11488 },
	{ 11490, 11490 },
	{ 11499, 11499 },
	{ 11501, 11501 },
	{ 11506, 11506 },
	{ 42560, 42560 },
	{ 42562, 42562 },
	{ 42564, 42564 },
	{ 42566, 42566 },
	{ 42568, 42568 },
	{ 42570, 42570 },
	{ 42572, 42572 },
	{ 42574, 42574 },
	{ 42576, 42576 },
	{ 42578, 42578 },
	{ 42580, 42580 },
	{ 42582, 42582 },
	{ 42584, 42584 },
	{ 42586, 42586 },
	{ 42588, 42588 },
	{ 42590, 42590 },
	{ 42592, 42592 },
	{ 42594, 42594 },
	{ 42596, 42596 },
	{ 42598, 42598 },
	{ 42600, 42600 },
	{ 42602, 42602 },
	{ 42604, 42604 },
	{ 42624, 42624 },
	{ 42626, 42626 },
	{ 42628, 42628 },
	{ 42630, 42630 },
	{ 42632, 42632 },
	{ 42634, 42634 },
	{ 42636, 42636 },
	{ 42638, 42638 },
	{ 42640, 42640 },
	{ 42642, 42642 },
	{ 42644, 42644 },
	{ 42646, 42646 },
	{ 42648, 42648 },
	{ 42650, 42650 },
	{ 42786, 42786 },
	{ 42788, 42788 },
	{ 42790, 42790 },
	{ 42792, 42792 },
	{ 42794, 42794 },
	{ 42796, 42796 },
	{ 42798, 42798 },
	{ 42802, 42802 },
	{ 42804, 42804 },
	{ 42806, 42806 },
	{ 42808, 42808 },
	{ 42810, 42810 },
	{ 42812, 42812 },
	{ 42814, 42814 },
	{ 42816, 42816 },
	{ 42818, 42818 },
	{ 42820, 42820 },
	{ 42822, 42822 },
	{ 42824, 42824 },
	{ 42826, 42826 },
	{ 42828, 42828 },
	{ 42830, 42830 },
	{ 42832, 42832 },
	{ 42834, 42834 },
	{ 42836, 42836 },
	{ 42838, 42838 },
	{ 42840, 42840 },
	{ 42842, 42842 },
	{ 42844, 42844 },
	{ 42846, 42846 },
	{ 42848, 42848 },
	{ 42850, 42850 },
	{ 42852, 42852 },
	{ 42854, 42854 },
	{ 42856, 42856 },
	{ 42858, 42858 },
	{ 42860, 42860 },
	{ 42862, 42862 },
	{ 42873, 42873 },
	{ 42875, 42875 },
	{ 42877, 42878 },
	{ 42880, 42880 },
	{ 42882, 42882 },
	{ 42884, 42884 },
	{ 42886, 42886 },
	{ 42891, 42891 },
	{ 42893, 42893 },
	{ 42896, 42896 },
	{ 42898, 42898 },
	{ 42902, 42902 },
	{ 42904, 42904 },
	{ 42906, 42906 },
	{ 42908, 42908 },
	{ 42910, 42910 },
	{ 42912, 42912 },
	{ 42914, 42914 },
	{ 42916, 42916 },
	{ 42918, 42918 },
	{ 42920, 42920 },
	{ 42922, 42926 },
	{ 42928, 42932 },
	{ 42934, 42934 },
	{ 42936, 42936 },
	{ 42938, 42938 },
	{ 42940, 42940 },
	{ 42942, 42942 },
	{ 42944, 42944 },
	{ 42946, 42946 },
	{ 42948, 42951 },
	{ 42953, 42953 },
	{ 42960, 42960 },
	{ 42966, 42966 },
	{ 42968, 42968 },
	{ 42997, 42997 },
	{ 65313, 65338 },
	{ 66560, 66599 },
	{ 66736, 66771 },
	{ 66928, 66938 },
	{ 66940, 66954 },
	{ 66956, 66962 },
	{ 66964, 66965 },
	{ 68736, 68786 },
	{ 71840, 71871 },
	{ 93760, 93791 },
	{ 119808, 119833 },
	{ 119860, 119885 },
	{ 119912, 119937 },
	{ 119964, 119964 },
	{ 119966, 119967 },
	{ 119970, 119970 },
	{ 119973, 119974 },
	{ 119977, 119980 },
	{ 119982, 119989 },
	{ 120016, 120041 },
	{ 120068, 120069 },
	{ 120071, 120074 },
	{ 120077, 120084 },
	{ 120086, 120092 },
	{ 120120, 120121 },
	{ 120123, 120126 },
	{ 120128, 120132 },
	{ 120134, 120134 },
	{ 120138, 120144 },
	{ 120172, 120197 },
	{ 120224, 120249 },
	{ 120276, 120301 },
	{ 120328, 120353 },
	{ 120380, 120405 },
	{ 120432, 120457 },
	{ 120488, 120512 },
	{ 120546, 120570 },
	{ 120604, 120628 },
	{ 120662, 120686 },
	{ 120720, 120744 },
	{ 120778, 120778 },
	{ 125184, 125217 },
	{ 127280, 127305 },
	{ 127312, 127337 },
	{ 127344, 127369 },
	{ -1, -1 },	// end markers
};
static const set_item lower[] = {
	{ 97, 122 },
	{ 170, 170 },
	{ 181, 181 },
	{ 186, 186 },
	{ 223, 246 },
	{ 248, 255 },
	{ 257, 257 },
	{ 259, 259 },
	{ 261, 261 },
	{ 263, 263 },
	{ 265, 265 },
	{ 267, 267 },
	{ 269, 269 },
	{ 271, 271 },
	{ 273, 273 },
	{ 275, 275 },
	{ 277, 277 },
	{ 279, 279 },
	{ 281, 281 },
	{ 283, 283 },
	{ 285, 285 },
	{ 287, 287 },
	{ 289, 289 },
	{ 291, 291 },
	{ 293, 293 },
	{ 295, 295 },
	{ 297, 297 },
	{ 299, 299 },
	{ 301, 301 },
	{ 303, 303 },
	{ 305, 305 },
	{ 307, 307 },
	{ 309, 309 },
	{ 311, 312 },
	{ 314, 314 },
	{ 316, 316 },
	{ 318, 318 },
	{ 320, 320 },
	{ 322, 322 },
	{ 324, 324 },
	{ 326, 326 },
	{ 328, 329 },
	{ 331, 331 },
	{ 333, 333 },
	{ 335, 335 },
	{ 337, 337 },
	{ 339, 339 },
	{ 341, 341 },
	{ 343, 343 },
	{ 345, 345 },
	{ 347, 347 },
	{ 349, 349 },
	{ 351, 351 },
	{ 353, 353 },
	{ 355, 355 },
	{ 357, 357 },
	{ 359, 359 },
	{ 361, 361 },
	{ 363, 363 },
	{ 365, 365 },
	{ 367, 367 },
	{ 369, 369 },
	{ 371, 371 },
	{ 373, 373 },
	{ 375, 375 },
	{ 378, 378 },
	{ 380, 380 },
	{ 382, 384 },
	{ 387, 387 },
	{ 389, 389 },
	{ 392, 392 },
	{ 396, 397 },
	{ 402, 402 },
	{ 405, 405 },
	{ 409, 411 },
	{ 414, 414 },
	{ 417, 417 },
	{ 419, 419 },
	{ 421, 421 },
	{ 424, 424 },
	{ 426, 427 },
	{ 429, 429 },
	{ 432, 432 },
	{ 436, 436 },
	{ 438, 438 },
	{ 441, 442 },
	{ 445, 447 },
	{ 453, 454 },
	{ 456, 457 },
	{ 459, 460 },
	{ 462, 462 },
	{ 464, 464 },
	{ 466, 466 },
	{ 468, 468 },
	{ 470, 470 },
	{ 472, 472 },
	{ 474, 474 },
	{ 476, 477 },
	{ 479, 479 },
	{ 481, 481 },
	{ 483, 483 },
	{ 485, 485 },
	{ 487, 487 },
	{ 489, 489 },
	{ 491, 491 },
	{ 493, 493 },
	{ 495, 496 },
	{ 498, 499 },
	{ 501, 501 },
	{ 505, 505 },
	{ 507, 507 },
	{ 509, 509 },
	{ 511, 511 },
	{ 513, 513 },
	{ 515, 515 },
	{ 517, 517 },
	{ 519, 519 },
	{ 521, 521 },
	{ 523, 523 },
	{ 525, 525 },
	{ 527, 527 },
	{ 529, 529 },
	{ 531, 531 },
	{ 533, 533 },
	{ 535, 535 },
	{ 537, 537 },
	{ 539, 539 },
	{ 541, 541 },
	{ 543, 543 },
	{ 545, 545 },
	{ 547, 547 },
	{ 549, 549 },
	{ 551, 551 },
	{ 553, 553 },
	{ 555, 555 },
	{ 557, 557 },
	{ 559, 559 },
	{ 561, 561 },
	{ 563, 569 },
	{ 572, 572 },
	{ 575, 576 },
	{ 578, 578 },
	{ 583, 583 },
	{ 585, 585 },
	{ 587, 587 },
	{ 589, 589 },
	{ 591, 659 },
	{ 661, 696 },
	{ 704, 705 },
	{ 736, 740 },
	{ 837, 837 },
	{ 881, 881 },
	{ 883, 883 },
	{ 887, 887 },
	{ 890, 893 },
	{ 912, 912 },
	{ 940, 974 },
	{ 976, 977 },
	{ 981, 983 },
	{ 985, 985 },
	{ 987, 987 },
	{ 989, 989 },
	{ 991, 991 },
	{ 993, 993 },
	{ 995, 995 },
	{ 997, 997 },
	{ 999, 999 },
	{ 1001, 1001 },
	{ 1003, 1003 },
	{ 1005, 1005 },
	{ 1007, 1011 },
	{ 1013, 1013 },
	{ 1016, 1016 },
	{ 1019, 1020 },
	{ 1072, 1119 },
	{ 1121, 1121 },
	{ 1123, 1123 },
	{ 1125, 1125 },
	{ 1127, 1127 },
	{ 1129, 1129 },
	{ 1131, 1131 },
	{ 1133, 1133 },
	{ 1135, 1135 },
	{ 1137, 1137 },
	{ 1139, 1139 },
	{ 1141, 1141 },
	{ 1143, 1143 },
	{ 1145, 1145 },
	{ 1147, 1147 },
	{ 1149, 1149 },
	{ 1151, 1151 },
	{ 1153, 1153 },
	{ 1163, 1163 },
	{ 1165, 1165 },
	{ 1167, 1167 },
	{ 1169, 1169 },
	{ 1171, 1171 },
	{ 1173, 1173 },
	{ 1175, 1175 },
	{ 1177, 1177 },
	{ 1179, 1179 },
	{ 1181, 1181 },
	{ 1183, 1183 },
	{ 1185, 1185 },
	{ 1187, 1187 },
	{ 1189, 1189 },
	{ 1191, 1191 },
	{ 1193, 1193 },
	{ 1195, 1195 },
	{ 1197, 1197 },
	{ 1199, 1199 },
	{ 1201, 1201 },
	{ 1203, 1203 },
	{ 1205, 1205 },
	{ 1207, 1207 },
	{ 1209, 1209 },
	{ 1211, 1211 },
	{ 1213, 1213 },
	{ 1215, 1215 },
	{ 1218, 1218 },
	{ 1220, 1220 },
	{ 1222, 1222 },
	{ 1224, 1224 },
	{ 1226, 1226 },
	{ 1228, 1228 },
	{ 1230, 1231 },
	{ 1233, 1233 },
	{ 1235, 1235 },
	{ 1237, 1237 },
	{ 1239, 1239 },
	{ 1241, 1241 },
	{ 1243, 1243 },
	{ 1245, 1245 },
	{ 1247, 1247 },
	{ 1249, 1249 },
	{ 1251, 1251 },
	{ 1253, 1253 },
	{ 1255, 1255 },
	{ 1257, 1257 },
	{ 1259, 1259 },
	{ 1261, 1261 },
	{ 1263, 1263 },
	{ 1265, 1265 },
	{ 1267, 1267 },
	{ 1269, 1269 },
	{ 1271, 1271 },
	{ 1273, 1273 },
	{ 1275, 1275 },
	{ 1277, 1277 },
	{ 1279, 1279 },
	{ 1281, 1281 },
	{ 1283, 1283 },
	{ 1285, 1285 },
	{ 1287, 1287 },
	{ 1289, 1289 },
	{ 1291, 1291 },
	{ 1293, 1293 },
	{ 1295, 1295 },
	{ 1297, 1297 },
	{ 1299, 1299 },
	{ 1301, 1301 },
	{ 1303, 1303 },
	{ 1305, 1305 },
	{ 1307, 1307 },
	{ 1309, 1309 },
	{ 1311, 1311 },
	{ 1313, 1313 },
	{ 1315, 1315 },
	{ 1317, 1317 },
	{ 1319, 1319 },
	{ 1321, 1321 },
	{ 1323, 1323 },
	{ 1325, 1325 },
	{ 1327, 1327 },
	{ 1376, 1416 },
	{ 4304, 4346 },
	{ 4349, 4351 },
	{ 5112, 5117 },
	{ 7296, 7304 },
	{ 7424, 7615 },
	{ 7681, 7681 },
	{ 7683, 7683 },
	{ 7685, 7685 },
	{ 7687, 7687 },
	{ 7689, 7689 },
	{ 7691, 7691 },
	{ 7693, 7693 },
	{ 7695, 7695 },
	{ 7697, 7697 },
	{ 7699, 7699 },
	{ 7701, 7701 },
	{ 7703, 7703 },
	{ 7705, 7705 },
	{ 7707, 7707 },
	{ 7709, 7709 },
	{ 7711, 7711 },
	{ 7713, 7713 },
	{ 7715, 7715 },
	{ 7717, 7717 },
	{ 7719, 7719 },
	{ 7721, 7721 },
	{ 7723, 7723 },
	{ 7725, 7725 },
	{ 7727, 7727 },
	{ 7729, 7729 },
	{ 7731, 7731 },
	{ 7733, 7733 },
	{ 7735, 7735 },
	{ 7737, 7737 },
	{ 7739, 7739 },
	{ 7741, 7741 },
	{ 7743, 7743 },
	{ 7745, 7745 },
	{ 7747, 7747 },
	{ 7749, 7749 },
	{ 7751, 7751 },
	{ 7753, 7753 },
	{ 7755, 7755 },
	{ 7757, 7757 },
	{ 7759, 7759 },
	{ 7761, 7761 },
	{ 7763, 7763 },
	{ 7765, 7765 },
	{ 7767, 7767 },
	{ 7769, 7769 },
	{ 7771, 7771 },
	{ 7773, 7773 },
	{ 7775, 7775 },
	{ 7777, 7777 },
	{ 7779, 7779 },
	{ 7781, 7781 },
	{ 7783, 7783 },
	{ 7785, 7785 },
	{ 7787, 7787 },
	{ 7789, 7789 },
	{ 7791, 7791 },
	{ 7793, 7793 },
	{ 7795, 7795 },
	{ 7797, 7797 },
	{ 7799, 7799 },
	{ 7801, 7801 },
	{ 7803, 7803 },
	{ 7805, 7805 },
	{ 7807, 7807 },
	{ 7809, 7809 },
	{ 7811, 7811 },
	{ 7813, 7813 },
	{ 7815, 7815 },
	{ 7817, 7817 },
	{ 7819, 7819 },
	{ 7821, 7821 },
	{ 7823, 7823 },
	{ 7825, 7825 },
	{ 7827, 7827 },
	{ 7829, 7837 },
	{ 7839, 7839 },
	{ 7841, 7841 },
	{ 7843, 7843 },
	{ 7845, 7845 },
	{ 7847, 7847 },
	{ 7849, 7849 },
	{ 7851, 7851 },
	{ 7853, 7853 },
	{ 7855, 7855 },
	{ 7857, 7857 },
	{ 7859, 7859 },
	{ 7861, 7861 },
	{ 7863, 7863 },
	{ 7865, 7865 },
	{ 7867, 7867 },
	{ 7869, 7869 },
	{ 7871, 7871 },
	{ 7873, 7873 },
	{ 7875, 7875 },
	{ 7877, 7877 },
	{ 7879, 7879 },
	{ 7881, 7881 },
	{ 7883, 7883 },
	{ 7885, 7885 },
	{ 7887, 7887 },
	{ 7889, 7889 },
	{ 7891, 7891 },
	{ 7893, 7893 },
	{ 7895, 7895 },
	{ 7897, 7897 },
	{ 7899, 7899 },
	{ 7901, 7901 },
	{ 7903, 7903 },
	{ 7905, 7905 },
	{ 7907, 7907 },
	{ 7909, 7909 },
	{ 7911, 7911 },
	{ 7913, 7913 },
	{ 7915, 7915 },
	{ 7917, 7917 },
	{ 7919, 7919 },
	{ 7921, 7921 },
	{ 7923, 7923 },
	{ 7925, 7925 },
	{ 7927, 7927 },
	{ 7929, 7929 },
	{ 7931, 7931 },
	{ 7933, 7933 },
	{ 7935, 7943 },
	{ 7952, 7957 },
	{ 7968, 7975 },
	{ 7984, 7991 },
	{ 8000, 8005 },
	{ 8016, 8023 },
	{ 8032, 8039 },
	{ 8048, 8061 },
	{ 8064, 8071 },
	{ 8080, 8087 },
	{ 8096, 8103 },
	{ 8112, 8116 },
	{ 8118, 8119 },
	{ 8126, 8126 },
	{ 8130, 8132 },
	{ 8134, 8135 },
	{ 8144, 8147 },
	{ 8150, 8151 },
	{ 8160, 8167 },
	{ 8178, 8180 },
	{ 8182, 8183 },
	{ 8305, 8305 },
	{ 8319, 8319 },
	{ 8336, 8348 },
	{ 8458, 8458 },
	{ 8462, 8463 },
	{ 8467, 8467 },
	{ 8495, 8495 },
	{ 8500, 8500 },
	{ 8505, 8505 },
	{ 8508, 8509 },
	{ 8518, 8521 },
	{ 8526, 8526 },
	{ 8560, 8575 },
	{ 8580, 8580 },
	{ 9424, 9449 },
	{ 11312, 11359 },
	{ 11361, 11361 },
	{ 11365, 11366 },
	{ 11368, 11368 },
	{ 11370, 11370 },
	{ 11372, 11372 },
	{ 11377, 11377 },
	{ 11379, 11380 },
	{ 11382, 11389 },
	{ 11393, 11393 },
	{ 11395, 11395 },
	{ 11397, 11397 },
	{ 11399, 11399 },
	{ 11401, 11401 },
	{ 11403, 11403 },
	{ 11405, 11405 },
	{ 11407, 11407 },
	{ 11409, 11409 },
	{ 11411, 11411 },
	{ 11413, 11413 },
	{ 11415, 11415 },
	{ 11417, 11417 },
	{ 11419, 11419 },
	{ 11421, 11421 },
	{ 11423, 11423 },
	{ 11425, 11425 },
	{ 11427, 11427 },
	{ 11429, 11429 },
	{ 11431, 11431 },
	{ 11433, 11433 },
	{ 11435, 11435 },
	{ 11437, 11437 },
	{ 11439, 11439 },
	{ 11441, 11441 },
	{ 11443, 11443 },
	{ 11445, 11445 },
	{ 11447, 11447 },
	{ 11449, 11449 },
	{ 11451, 11451 },
	{ 11453, 11453 },
	{ 11455, 11455 },
	{ 11457, 11457 },
	{ 11459, 11459 },
	{ 11461, 11461 },
	{ 11463, 11463 },
	{ 11465, 11465 },
	{ 11467, 11467 },
	{ 11469, 11469 },
	{ 11471, 11471 },
	{ 11473, 11473 },
	{ 11475, 11475 },
	{ 11477, 11477 },
	{ 11479, 11479 },
	{ 11481, 11481 },
	{ 11483, 11483 },
	{ 11485, 11485 },
	{ 11487, 11487 },
	{ 11489, 11489 },
	{ 11491, 11492 },
	{ 11500, 11500 },
	{ 11502, 11502 },
	{ 11507, 11507 },
	{ 11520, 11557 },
	{ 11559, 11559 },
	{ 11565, 11565 },
	{ 42561, 42561 },
	{ 42563, 42563 },
	{ 42565, 42565 },
	{ 42567, 42567 },
	{ 42569, 42569 },
	{ 42571, 42571 },
	{ 42573, 42573 },
	{ 42575, 42575 },
	{ 42577, 42577 },
	{ 42579, 42579 },
	{ 42581, 42581 },
	{ 42583, 42583 },
	{ 42585, 42585 },
	{ 42587, 42587 },
	{ 42589, 42589 },
	{ 42591, 42591 },
	{ 42593, 42593 },
	{ 42595, 42595 },
	{ 42597, 42597 },
	{ 42599, 42599 },
	{ 42601, 42601 },
	{ 42603, 42603 },
	{ 42605, 42605 },
	{ 42625, 42625 },
	{ 42627, 42627 },
	{ 42629, 42629 },
	{ 42631, 42631 },
	{ 42633, 42633 },
	{ 42635, 42635 },
	{ 42637, 42637 },
	{ 42639, 42639 },
	{ 42641, 42641 },
	{ 42643, 42643 },
	{ 42645, 42645 },
	{ 42647, 42647 },
	{ 42649, 42649 },
	{ 42651, 42653 },
	{ 42787, 42787 },
	{ 42789, 42789 },
	{ 42791, 42791 },
	{ 42793, 42793 },
	{ 42795, 42795 },
	{ 42797, 42797 },
	{ 42799, 42801 },
	{ 42803, 42803 },
	{ 42805, 42805 },
	{ 42807, 42807 },
	{ 42809, 42809 },
	{ 42811, 42811 },
	{ 42813, 42813 },
	{ 42815, 42815 },
	{ 42817, 42817 },
	{ 42819, 42819 },
	{ 42821, 42821 },
	{ 42823, 42823 },
	{ 42825, 42825 },
	{ 42827, 42827 },
	{ 42829, 42829 },
	{ 42831, 42831 },
	{ 42833, 42833 },
	{ 42835, 42835 },
	{ 42837, 42837 },
	{ 42839, 42839 },
	{ 42841, 42841 },
	{ 42843, 42843 },
	{ 42845, 42845 },
	{ 42847, 42847 },
	{ 42849, 42849 },
	{ 42851, 42851 },
	{ 42853, 42853 },
	{ 42855, 42855 },
	{ 42857, 42857 },
	{ 42859, 42859 },
	{ 42861, 42861 },
	{ 42863, 42872 },
	{ 42874, 42874 },
	{ 42876, 42876 },
	{ 42879, 42879 },
	{ 42881, 42881 },
	{ 42883, 42883 },
	{ 42885, 42885 },
	{ 42887, 42887 },
	{ 42892, 42892 },
	{ 42894, 42894 },
	{ 42897, 42897 },
	{ 42899, 42901 },
	{ 42903, 42903 },
	{ 42905, 42905 },
	{ 42907, 42907 },
	{ 42909, 42909 },
	{ 42911, 42911 },
	{ 42913, 42913 },
	{ 42915, 42915 },
	{ 42917, 42917 },
	{ 42919, 42919 },
	{ 42921, 42921 },
	{ 42927, 42927 },
	{ 42933, 42933 },
	{ 42935, 42935 },
	{ 42937, 42937 },
	{ 42939, 42939 },
	{ 42941, 42941 },
	{ 42943, 42943 },
	{ 42945, 42945 },
	{ 42947, 42947 },
	{ 42952, 42952 },
	{ 42954, 42954 },
	{ 42961, 42961 },
	{ 42963, 42963 },
	{ 42965, 42965 },
	{ 42967, 42967 },
	{ 42969, 42969 },
	{ 42998, 42998 },
	{ 43000, 43002 },
	{ 43824, 43866 },
	{ 43868, 43880 },
	{ 43888, 43967 },
	{ 64256, 64262 },
	{ 64275, 64279 },
	{ 65345, 65370 },
	{ 66600, 66639 },
	{ 66776, 66811 },
	{ 66967, 66977 },
	{ 66979, 66993 },
	{ 66995, 67001 },
	{ 67003, 67004 },
	{ 67456, 67456 },
	{ 67459, 67461 },
	{ 67463, 67504 },
	{ 67506, 67514 },
	{ 68800, 68850 },
	{ 71872, 71903 },
	{ 93792, 93823 },
	{ 119834, 119859 },
	{ 119886, 119892 },
	{ 119894, 119911 },
	{ 119938, 119963 },
	{ 119990, 119993 },
	{ 119995, 119995 },
	{ 119997, 120003 },
	{ 120005, 120015 },
	{ 120042, 120067 },
	{ 120094, 120119 },
	{ 120146, 120171 },
	{ 120198, 120223 },
	{ 120250, 120275 },
	{ 120302, 120327 },
	{ 120354, 120379 },
	{ 120406, 120431 },
	{ 120458, 120485 },
	{ 120514, 120538 },
	{ 120540, 120545 },
	{ 120572, 120596 },
	{ 120598, 120603 },
	{ 120630, 120654 },
	{ 120656, 120661 },
	{ 120688, 120712 },
	{ 120714, 120719 },
	{ 120746, 120770 },
	{ 120772, 120777 },
	{ 120779, 120779 },
	{ 122624, 122633 },
	{ 122635, 122654 },
	{ 125218, 125251 },
	{ -1, -1 },	// end markers
};
static const set_item print_graph_common[] = {
	{ 160, 887 },
	{ 890, 895 },
	{ 900, 906 },
	{ 908, 908 },
	{ 910, 929 },
	{ 931, 1327 },
	{ 1329, 1366 },
	{ 1369, 1418 },
	{ 1421, 1423 },
	{ 1425, 1479 },
	{ 1488, 1514 },
	{ 1519, 1524 },
	{ 1536, 1805 },
	{ 1807, 1866 },
	{ 1869, 1969 },
	{ 1984, 2042 },
	{ 2045, 2093 },
	{ 2096, 2110 },
	{ 2112, 2139 },
	{ 2142, 2142 },
	{ 2144, 2154 },
	{ 2160, 2190 },
	{ 2192, 2193 },
	{ 2200, 2435 },
	{ 2437, 2444 },
	{ 2447, 2448 },
	{ 2451, 2472 },
	{ 2474, 2480 },
	{ 2482, 2482 },
	{ 2486, 2489 },
	{ 2492, 2500 },
	{ 2503, 2504 },
	{ 2507, 2510 },
	{ 2519, 2519 },
	{ 2524, 2525 },
	{ 2527, 2531 },
	{ 2534, 2558 },
	{ 2561, 2563 },
	{ 2565, 2570 },
	{ 2575, 2576 },
	{ 2579, 2600 },
	{ 2602, 2608 },
	{ 2610, 2611 },
	{ 2613, 2614 },
	{ 2616, 2617 },
	{ 2620, 2620 },
	{ 2622, 2626 },
	{ 2631, 2632 },
	{ 2635, 2637 },
	{ 2641, 2641 },
	{ 2649, 2652 },
	{ 2654, 2654 },
	{ 2662, 2678 },
	{ 2689, 2691 },
	{ 2693, 2701 },
	{ 2703, 2705 },
	{ 2707, 2728 },
	{ 2730, 2736 },
	{ 2738, 2739 },
	{ 2741, 2745 },
	{ 2748, 2757 },
	{ 2759, 2761 },
	{ 2763, 2765 },
	{ 2768, 2768 },
	{ 2784, 2787 },
	{ 2790, 2801 },
	{ 2809, 2815 },
	{ 2817, 2819 },
	{ 2821, 2828 },
	{ 2831, 2832 },
	{ 2835, 2856 },
	{ 2858, 2864 },
	{ 2866, 2867 },
	{ 2869, 2873 },
	{ 2876, 2884 },
	{ 2887, 2888 },
	{ 2891, 2893 },
	{ 2901, 2903 },
	{ 2908, 2909 },
	{ 2911, 2915 },
	{ 2918, 2935 },
	{ 2946, 2947 },
	{ 2949, 2954 },
	{ 2958, 2960 },
	{ 2962, 2965 },
	{ 2969, 2970 },
	{ 2972, 2972 },
	{ 2974, 2975 },
	{ 2979, 2980 },
	{ 2984, 2986 },
	{ 2990, 3001 },
	{ 3006, 3010 },
	{ 3014, 3016 },
	{ 3018, 3021 },
	{ 3024, 3024 },
	{ 3031, 3031 },
	{ 3046, 3066 },
	{ 3072, 3084 },
	{ 3086, 3088 },
	{ 3090, 3112 },
	{ 3114, 3129 },
	{ 3132, 3140 },
	{ 3142, 3144 },
	{ 3146, 3149 },
	{ 3157, 3158 },
	{ 3160, 3162 },
	{ 3165, 3165 },
	{ 3168, 3171 },
	{ 3174, 3183 },
	{ 3191, 3212 },
	{ 3214, 3216 },
	{ 3218, 3240 },
	{ 3242, 3251 },
	{ 3253, 3257 },
	{ 3260, 3268 },
	{ 3270, 3272 },
	{ 3274, 3277 },
	{ 3285, 3286 },
	{ 3293, 3294 },
	{ 3296, 3299 },
	{ 3302, 3311 },
	{ 3313, 3314 },
	{ 3328, 3340 },
	{ 3342, 3344 },
	{ 3346, 3396 },
	{ 3398, 3400 },
	{ 3402, 3407 },
	{ 3412, 3427 },
	{ 3430, 3455 },
	{ 3457, 3459 },
	{ 3461, 3478 },
	{ 3482, 3505 },
	{ 3507, 3515 },
	{ 3517, 3517 },
	{ 3520, 3526 },
	{ 3530, 3530 },
	{ 3535, 3540 },
	{ 3542, 3542 },
	{ 3544, 3551 },
	{ 3558, 3567 },
	{ 3570, 3572 },
	{ 3585, 3642 },
	{ 3647, 3675 },
	{ 3713, 3714 },
	{ 3716, 3716 },
	{ 3718, 3722 },
	{ 3724, 3747 },
	{ 3749, 3749 },
	{ 3751, 3773 },
	{ 3776, 3780 },
	{ 3782, 3782 },
	{ 3784, 3789 },
	{ 3792, 3801 },
	{ 3804, 3807 },
	{ 3840, 3911 },
	{ 3913, 3948 },
	{ 3953, 3991 },
	{ 3993, 4028 },
	{ 4030, 4044 },
	{ 4046, 4058 },
	{ 4096, 4293 },
	{ 4295, 4295 },
	{ 4301, 4301 },
	{ 4304, 4680 },
	{ 4682, 4685 },
	{ 4688, 4694 },
	{ 4696, 4696 },
	{ 4698, 4701 },
	{ 4704, 4744 },
	{ 4746, 4749 },
	{ 4752, 4784 },
	{ 4786, 4789 },
	{ 4792, 4798 },
	{ 4800, 4800 },
	{ 4802, 4805 },
	{ 4808, 4822 },
	{ 4824, 4880 },
	{ 4882, 4885 },
	{ 4888, 4954 },
	{ 4957, 4988 },
	{ 4992, 5017 },
	{ 5024, 5109 },
	{ 5112, 5117 },
	{ 5792, 5880 },
	{ 5888, 5909 },
	{ 5919, 5942 },
	{ 5952, 5971 },
	{ 5984, 5996 },
	{ 5998, 6000 },
	{ 6002, 6003 },
	{ 6016, 6109 },
	{ 6112, 6121 },
	{ 6128, 6137 },
	{ 6144, 6169 },
	{ 6176, 6264 },
	{ 6272, 6314 },
	{ 6320, 6389 },
	{ 6400, 6430 },
	{ 6432, 6443 },
	{ 6448, 6459 },
	{ 6464, 6464 },
	{ 6468, 6509 },
	{ 6512, 6516 },
	{ 6528, 6571 },
	{ 6576, 6601 },
	{ 6608, 6618 },
	{ 6622, 6683 },
	{ 6686, 6750 },
	{ 6752, 6780 },
	{ 6783, 6793 },
	{ 6800, 6809 },
	{ 6816, 6829 },
	{ 6832, 6862 },
	{ 6912, 6988 },
	{ 6992, 7038 },
	{ 7040, 7155 },
	{ 7164, 7223 },
	{ 7227, 7241 },
	{ 7245, 7304 },
	{ 7312, 7354 },
	{ 7357, 7367 },
	{ 7376, 7418 },
	{ 7424, 7957 },
	{ 7960, 7965 },
	{ 7968, 8005 },
	{ 8008, 8013 },
	{ 8016, 8023 },
	{ 8025, 8025 },
	{ 8027, 8027 },
	{ 8029, 8029 },
	{ 8031, 8061 },
	{ 8064, 8116 },
	{ 8118, 8132 },
	{ 8134, 8147 },
	{ 8150, 8155 },
	{ 8157, 8175 },
	{ 8178, 8180 },
	{ 8182, 8190 },
	{ 8294, 8305 },
	{ 8308, 8334 },
	{ 8336, 8348 },
	{ 8352, 8384 },
	{ 8400, 8432 },
	{ 8448, 8587 },
	{ 8592, 9254 },
	{ 9280, 9290 },
	{ 9312, 11123 },
	{ 11126, 11157 },
	{ 11159, 11507 },
	{ 11513, 11557 },
	{ 11559, 11559 },
	{ 11565, 11565 },
	{ 11568, 11623 },
	{ 11631, 11632 },
	{ 11647, 11670 },
	{ 11680, 11686 },
	{ 11688, 11694 },
	{ 11696, 11702 },
	{ 11704, 11710 },
	{ 11712, 11718 },
	{ 11720, 11726 },
	{ 11728, 11734 },
	{ 11736, 11742 },
	{ 11744, 11869 },
	{ 11904, 11929 },
	{ 11931, 12019 },
	{ 12032, 12245 },
	{ 12272, 12283 },
	{ 12353, 12438 },
	{ 12441, 12543 },
	{ 12549, 12591 },
	{ 12593, 12686 },
	{ 12688, 12771 },
	{ 12784, 12830 },
	{ 12832, 42124 },
	{ 42128, 42182 },
	{ 42192, 42539 },
	{ 42560, 42743 },
	{ 42752, 42954 },
	{ 42960, 42961 },
	{ 42963, 42963 },
	{ 42965, 42969 },
	{ 42994, 43052 },
	{ 43056, 43065 },
	{ 43072, 43127 },
	{ 43136, 43205 },
	{ 43214, 43225 },
	{ 43232, 43347 },
	{ 43359, 43388 },
	{ 43392, 43469 },
	{ 43471, 43481 },
	{ 43486, 43518 },
	{ 43520, 43574 },
	{ 43584, 43597 },
	{ 43600, 43609 },
	{ 43612, 43714 },
	{ 43739, 43766 },
	{ 43777, 43782 },
	{ 43785, 43790 },
	{ 43793, 43798 },
	{ 43808, 43814 },
	{ 43816, 43822 },
	{ 43824, 43883 },
	{ 43888, 44013 },
	{ 44016, 44025 },
	{ 44032, 55203 },
	{ 55216, 55238 },
	{ 55243, 55291 },
	{ 57344, 64109 },
	{ 64112, 64217 },
	{ 64256, 64262 },
	{ 64275, 64279 },
	{ 64285, 64310 },
	{ 64312, 64316 },
	{ 64318, 64318 },
	{ 64320, 64321 },
	{ 64323, 64324 },
	{ 64326, 64450 },
	{ 64467, 64911 },
	{ 64914, 64967 },
	{ 64975, 64975 },
	{ 65008, 65049 },
	{ 65056, 65106 },
	{ 65108, 65126 },
	{ 65128, 65131 },
	{ 65136, 65140 },
	{ 65142, 65276 },
	{ 65279, 65279 },
	{ 65281, 65470 },
	{ 65474, 65479 },
	{ 65482, 65487 },
	{ 65490, 65495 },
	{ 65498, 65500 },
	{ 65504, 65510 },
	{ 65512, 65518 },
	{ 65529, 65533 },
	{ 65536, 65547 },
	{ 65549, 65574 },
	{ 65576, 65594 },
	{ 65596, 65597 },
	{ 65599, 65613 },
	{ 65616, 65629 },
	{ 65664, 65786 },
	{ 65792, 65794 },
	{ 65799, 65843 },
	{ 65847, 65934 },
	{ 65936, 65948 },
	{ 65952, 65952 },
	{ 66000, 66045 },
	{ 66176, 66204 },
	{ 66208, 66256 },
	{ 66272, 66299 },
	{ 66304, 66339 },
	{ 66349, 66378 },
	{ 66384, 66426 },
	{ 66432, 66461 },
	{ 66463, 66499 },
	{ 66504, 66517 },
	{ 66560, 66717 },
	{ 66720, 66729 },
	{ 66736, 66771 },
	{ 66776, 66811 },
	{ 66816, 66855 },
	{ 66864, 66915 },
	{ 66927, 66938 },
	{ 66940, 66954 },
	{ 66956, 66962 },
	{ 66964, 66965 },
	{ 66967, 66977 },
	{ 66979, 66993 },
	{ 66995, 67001 },
	{ 67003, 67004 },
	{ 67072, 67382 },
	{ 67392, 67413 },
	{ 67424, 67431 },
	{ 67456, 67461 },
	{ 67463, 67504 },
	{ 67506, 67514 },
	{ 67584, 67589 },
	{ 67592, 67592 },
	{ 67594, 67637 },
	{ 67639, 67640 },
	{ 67644, 67644 },
	{ 67647, 67669 },
	{ 67671, 67742 },
	{ 67751, 67759 },
	{ 67808, 67826 },
	{ 67828, 67829 },
	{ 67835, 67867 },
	{ 67871, 67897 },
	{ 67903, 67903 },
	{ 67968, 68023 },
	{ 68028, 68047 },
	{ 68050, 68099 },
	{ 68101, 68102 },
	{ 68108, 68115 },
	{ 68117, 68119 },
	{ 68121, 68149 },
	{ 68152, 68154 },
	{ 68159, 68168 },
	{ 68176, 68184 },
	{ 68192, 68255 },
	{ 68288, 68326 },
	{ 68331, 68342 },
	{ 68352, 68405 },
	{ 68409, 68437 },
	{ 68440, 68466 },
	{ 68472, 68497 },
	{ 68505, 68508 },
	{ 68521, 68527 },
	{ 68608, 68680 },
	{ 68736, 68786 },
	{ 68800, 68850 },
	{ 68858, 68903 },
	{ 68912, 68921 },
	{ 69216, 69246 },
	{ 69248, 69289 },
	{ 69291, 69293 },
	{ 69296, 69297 },
	{ 69376, 69415 },
	{ 69424, 69465 },
	{ 69488, 69513 },
	{ 69552, 69579 },
	{ 69600, 69622 },
	{ 69632, 69709 },
	{ 69714, 69749 },
	{ 69759, 69826 },
	{ 69837, 69837 },
	{ 69840, 69864 },
	{ 69872, 69881 },
	{ 69888, 69940 },
	{ 69942, 69959 },
	{ 69968, 70006 },
	{ 70016, 70111 },
	{ 70113, 70132 },
	{ 70144, 70161 },
	{ 70163, 70206 },
	{ 70272, 70278 },
	{ 70280, 70280 },
	{ 70282, 70285 },
	{ 70287, 70301 },
	{ 70303, 70313 },
	{ 70320, 70378 },
	{ 70384, 70393 },
	{ 70400, 70403 },
	{ 70405, 70412 },
	{ 70415, 70416 },
	{ 70419, 70440 },
	{ 70442, 70448 },
	{ 70450, 70451 },
	{ 70453, 70457 },
	{ 70459, 70468 },
	{ 70471, 70472 },
	{ 70475, 70477 },
	{ 70480, 70480 },
	{ 70487, 70487 },
	{ 70493, 70499 },
	{ 70502, 70508 },
	{ 70512, 70516 },
	{ 70656, 70747 },
	{ 70749, 70753 },
	{ 70784, 70855 },
	{ 70864, 70873 },
	{ 71040, 71093 },
	{ 71096, 71133 },
	{ 71168, 71236 },
	{ 71248, 71257 },
	{ 71264, 71276 },
	{ 71296, 71353 },
	{ 71360, 71369 },
	{ 71424, 71450 },
	{ 71453, 71467 },
	{ 71472, 71494 },
	{ 71680, 71739 },
	{ 71840, 71922 },
	{ 71935, 71942 },
	{ 71945, 71945 },
	{ 71948, 71955 },
	{ 71957, 71958 },
	{ 71960, 71989 },
	{ 71991, 71992 },
	{ 71995, 72006 },
	{ 72016, 72025 },
	{ 72096, 72103 },
	{ 72106, 72151 },
	{ 72154, 72164 },
	{ 72192, 72263 },
	{ 72272, 72354 },
	{ 72368, 72440 },
	{ 72704, 72712 },
	{ 72714, 72758 },
	{ 72760, 72773 },
	{ 72784, 72812 },
	{ 72816, 72847 },
	{ 72850, 72871 },
	{ 72873, 72886 },
	{ 72960, 72966 },
	{ 72968, 72969 },
	{ 72971, 73014 },
	{ 73018, 73018 },
	{ 73020, 73021 },
	{ 73023, 73031 },
	{ 73040, 73049 },
	{ 73056, 73061 },
	{ 73063, 73064 },
	{ 73066, 73102 },
	{ 73104, 73105 },
	{ 73107, 73112 },
	{ 73120, 73129 },
	{ 73440, 73464 },
	{ 73648, 73648 },
	{ 73664, 73713 },
	{ 73727, 74649 },
	{ 74752, 74862 },
	{ 74864, 74868 },
	{ 74880, 75075 },
	{ 77712, 77810 },
	{ 77824, 78894 },
	{ 78896, 78904 },
	{ 82944, 83526 },
	{ 92160, 92728 },
	{ 92736, 92766 },
	{ 92768, 92777 },
	{ 92782, 92862 },
	{ 92864, 92873 },
	{ 92880, 92909 },
	{ 92912, 92917 },
	{ 92928, 92997 },
	{ 93008, 93017 },
	{ 93019, 93025 },
	{ 93027, 93047 },
	{ 93053, 93071 },
	{ 93760, 93850 },
	{ 93952, 94026 },
	{ 94031, 94087 },
	{ 94095, 94111 },
	{ 94176, 94180 },
	{ 94192, 94193 },
	{ 94208, 100343 },
	{ 100352, 101589 },
	{ 101632, 101640 },
	{ 110576, 110579 },
	{ 110581, 110587 },
	{ 110589, 110590 },
	{ 110592, 110882 },
	{ 110928, 110930 },
	{ 110948, 110951 },
	{ 110960, 111355 },
	{ 113664, 113770 },
	{ 113776, 113788 },
	{ 113792, 113800 },
	{ 113808, 113817 },
	{ 113820, 113827 },
	{ 118528, 118573 },
	{ 118576, 118598 },
	{ 118608, 118723 },
	{ 118784, 119029 },
	{ 119040, 119078 },
	{ 119081, 119274 },
	{ 119296, 119365 },
	{ 119520, 119539 },
	{ 119552, 119638 },
	{ 119648, 119672 },
	{ 119808, 119892 },
	{ 119894, 119964 },
	{ 119966, 119967 },
	{ 119970, 119970 },
	{ 119973, 119974 },
	{ 119977, 119980 },
	{ 119982, 119993 },
	{ 119995, 119995 },
	{ 119997, 120003 },
	{ 120005, 120069 },
	{ 120071, 120074 },
	{ 120077, 120084 },
	{ 120086, 120092 },
	{ 120094, 120121 },
	{ 120123, 120126 },
	{ 120128, 120132 },
	{ 120134, 120134 },
	{ 120138, 120144 },
	{ 120146, 120485 },
	{ 120488, 120779 },
	{ 120782, 121483 },
	{ 121499, 121503 },
	{ 121505, 121519 },
	{ 122624, 122654 },
	{ 122880, 122886 },
	{ 122888, 122904 },
	{ 122907, 122913 },
	{ 122915, 122916 },
	{ 122918, 122922 },
	{ 123136, 123180 },
	{ 123184, 123197 },
	{ 123200, 123209 },
	{ 123214, 123215 },
	{ 123536, 123566 },
	{ 123584, 123641 },
	{ 123647, 123647 },
	{ 124896, 124902 },
	{ 124904, 124907 },
	{ 124909, 124910 },
	{ 124912, 124926 },
	{ 124928, 125124 },
	{ 125127, 125142 },
	{ 125184, 125259 },
	{ 125264, 125273 },
	{ 125278, 125279 },
	{ 126065, 126132 },
	{ 126209, 126269 },
	{ 126464, 126467 },
	{ 126469, 126495 },
	{ 126497, 126498 },
	{ 126500, 126500 },
	{ 126503, 126503 },
	{ 126505, 126514 },
	{ 126516, 126519 },
	{ 126521, 126521 },
	{ 126523, 126523 },
	{ 126530, 126530 },
	{ 126535, 126535 },
	{ 126537, 126537 },
	{ 126539, 126539 },
	{ 126541, 126543 },
	{ 126545, 126546 },
	{ 126548, 126548 },
	{ 126551, 126551 },
	{ 126553, 126553 },
	{ 126555, 126555 },
	{ 126557, 126557 },
	{ 126559, 126559 },
	{ 126561, 126562 },
	{ 126564, 126564 },
	{ 126567, 126570 },
	{ 126572, 126578 },
	{ 126580, 126583 },
	{ 126585, 126588 },
	{ 126590, 126590 },
	{ 126592, 126601 },
	{ 126603, 126619 },
	{ 126625, 126627 },
	{ 126629, 126633 },
	{ 126635, 126651 },
	{ 126704, 126705 },
	{ 126976, 127019 },
	{ 127024, 127123 },
	{ 127136, 127150 },
	{ 127153, 127167 },
	{ 127169, 127183 },
	{ 127185, 127221 },
	{ 127232, 127405 },
	{ 127462, 127490 },
	{ 127504, 127547 },
	{ 127552, 127560 },
	{ 127568, 127569 },
	{ 127584, 127589 },
	{ 127744, 128727 },
	{ 128733, 128748 },
	{ 128752, 128764 },
	{ 128768, 128883 },
	{ 128896, 128984 },
	{ 128992, 129003 },
	{ 129008, 129008 },
	{ 129024, 129035 },
	{ 129040, 129095 },
	{ 129104, 129113 },
	{ 129120, 129159 },
	{ 129168, 129197 },
	{ 129200, 129201 },
	{ 129280, 129619 },
	{ 129632, 129645 },
	{ 129648, 129652 },
	{ 129656, 129660 },
	{ 129664, 129670 },
	{ 129680, 129708 },
	{ 129712, 129722 },
	{ 129728, 129733 },
	{ 129744, 129753 },
	{ 129760, 129767 },
	{ 129776, 129782 },
	{ 129792, 129938 },
	{ 129940, 129994 },
	{ 130032, 130041 },
	{ 131072, 173791 },
	{ 173824, 177976 },
	{ 177984, 178205 },
	{ 178208, 183969 },
	{ 183984, 191456 },
	{ 194560, 195101 },
	{ 196608, 201546 },
	{ 917505, 917505 },
	{ 917536, 917631 },
	{ 917760, 917999 },
	{ 983040, 1048573 },
	{ 1048576, 1114109 },
	{ -1, -1 },	// end markers
};
static const set_item alpha[] = {
	{ 65, 90 },
	{ 97, 122 },
	{ 170, 170 },
	{ 181, 181 },
	{ 186, 186 },
	{ 192, 214 },
	{ 216, 246 },
	{ 248, 705 },
	{ 710, 721 },
	{ 736, 740 },
	{ 748, 748 },
	{ 750, 750 },
	{ 837, 837 },
	{ 880, 884 },
	{ 886, 887 },
	{ 890, 893 },
	{ 895, 895 },
	{ 902, 902 },
	{ 904, 906 },
	{ 908, 908 },
	{ 910, 929 },
	{ 931, 1013 },
	{ 1015, 1153 },
	{ 1162, 1327 },
	{ 1329, 1366 },
	{ 1369, 1369 },
	{ 1376, 1416 },
	{ 1456, 1469 },
	{ 1471, 1471 },
	{ 1473, 1474 },
	{ 1476, 1477 },
	{ 1479, 1479 },
	{ 1488, 1514 },
	{ 1519, 1522 },
	{ 1552, 1562 },
	{ 1568, 1623 },
	{ 1625, 1641 },
	{ 1646, 1747 },
	{ 1749, 1756 },
	{ 1761, 1768 },
	{ 1773, 1788 },
	{ 1791, 1791 },
	{ 1808, 1855 },
	{ 1869, 1969 },
	{ 1984, 2026 },
	{ 2036, 2037 },
	{ 2042, 2042 },
	{ 2048, 2071 },
	{ 2074, 2092 },
	{ 2112, 2136 },
	{ 2144, 2154 },
	{ 2160, 2183 },
	{ 2185, 2190 },
	{ 2208, 2249 },
	{ 2260, 2271 },
	{ 2275, 2281 },
	{ 2288, 2363 },
	{ 2365, 2380 },
	{ 2382, 2384 },
	{ 2389, 2403 },
	{ 2406, 2415 },
	{ 2417, 2435 },
	{ 2437, 2444 },
	{ 2447, 2448 },
	{ 2451, 2472 },
	{ 2474, 2480 },
	{ 2482, 2482 },
	{ 2486, 2489 },
	{ 2493, 2500 },
	{ 2503, 2504 },
	{ 2507, 2508 },
	{ 2510, 2510 },
	{ 2519, 2519 },
	{ 2524, 2525 },
	{ 2527, 2531 },
	{ 2534, 2545 },
	{ 2556, 2556 },
	{ 2561, 2563 },
	{ 2565, 2570 },
	{ 2575, 2576 },
	{ 2579, 2600 },
	{ 2602, 2608 },
	{ 2610, 2611 },
	{ 2613, 2614 },
	{ 2616, 2617 },
	{ 2622, 2626 },
	{ 2631, 2632 },
	{ 2635, 2636 },
	{ 2641, 2641 },
	{ 2649, 2652 },
	{ 2654, 2654 },
	{ 2662, 2677 },
	{ 2689, 2691 },
	{ 2693, 2701 },
	{ 2703, 2705 },
	{ 2707, 2728 },
	{ 2730, 2736 },
	{ 2738, 2739 },
	{ 2741, 2745 },
	{ 2749, 2757 },
	{ 2759, 2761 },
	{ 2763, 2764 },
	{ 2768, 2768 },
	{ 2784, 2787 },
	{ 2790, 2799 },
	{ 2809, 2812 },
	{ 2817, 2819 },
	{ 2821, 2828 },
	{ 2831, 2832 },
	{ 2835, 2856 },
	{ 2858, 2864 },
	{ 2866, 2867 },
	{ 2869, 2873 },
	{ 2877, 2884 },
	{ 2887, 2888 },
	{ 2891, 2892 },
	{ 2902, 2903 },
	{ 2908, 2909 },
	{ 2911, 2915 },
	{ 2918, 2927 },
	{ 2929, 2929 },
	{ 2946, 2947 },
	{ 2949, 2954 },
	{ 2958, 2960 },
	{ 2962, 2965 },
	{ 2969, 2970 },
	{ 2972, 2972 },
	{ 2974, 2975 },
	{ 2979, 2980 },
	{ 2984, 2986 },
	{ 2990, 3001 },
	{ 3006, 3010 },
	{ 3014, 3016 },
	{ 3018, 3020 },
	{ 3024, 3024 },
	{ 3031, 3031 },
	{ 3046, 3055 },
	{ 3072, 3075 },
	{ 3077, 3084 },
	{ 3086, 3088 },
	{ 3090, 3112 },
	{ 3114, 3129 },
	{ 3133, 3140 },
	{ 3142, 3144 },
	{ 3146, 3148 },
	{ 3157, 3158 },
	{ 3160, 3162 },
	{ 3165, 3165 },
	{ 3168, 3171 },
	{ 3174, 3183 },
	{ 3200, 3203 },
	{ 3205, 3212 },
	{ 3214, 3216 },
	{ 3218, 3240 },
	{ 3242, 3251 },
	{ 3253, 3257 },
	{ 3261, 3268 },
	{ 3270, 3272 },
	{ 3274, 3276 },
	{ 3285, 3286 },
	{ 3293, 3294 },
	{ 3296, 3299 },
	{ 3302, 3311 },
	{ 3313, 3314 },
	{ 3328, 3340 },
	{ 3342, 3344 },
	{ 3346, 3386 },
	{ 3389, 3396 },
	{ 3398, 3400 },
	{ 3402, 3404 },
	{ 3406, 3406 },
	{ 3412, 3415 },
	{ 3423, 3427 },
	{ 3430, 3439 },
	{ 3450, 3455 },
	{ 3457, 3459 },
	{ 3461, 3478 },
	{ 3482, 3505 },
	{ 3507, 3515 },
	{ 3517, 3517 },
	{ 3520, 3526 },
	{ 3535, 3540 },
	{ 3542, 3542 },
	{ 3544, 3551 },
	{ 3558, 3567 },
	{ 3570, 3571 },
	{ 3585, 3642 },
	{ 3648, 3654 },
	{ 3661, 3661 },
	{ 3664, 3673 },
	{ 3713, 3714 },
	{ 3716, 3716 },
	{ 3718, 3722 },
	{ 3724, 3747 },
	{ 3749, 3749 },
	{ 3751, 3769 },
	{ 3771, 3773 },
	{ 3776, 3780 },
	{ 3782, 3782 },
	{ 3789, 3789 },
	{ 3792, 3801 },
	{ 3804, 3807 },
	{ 3840, 3840 },
	{ 3872, 3881 },
	{ 3904, 3911 },
	{ 3913, 3948 },
	{ 3953, 3969 },
	{ 3976, 3991 },
	{ 3993, 4028 },
	{ 4096, 4150 },
	{ 4152, 4152 },
	{ 4155, 4169 },
	{ 4176, 4253 },
	{ 4256, 4293 },
	{ 4295, 4295 },
	{ 4301, 4301 },
	{ 4304, 4346 },
	{ 4348, 4680 },
	{ 4682, 4685 },
	{ 4688, 4694 },
	{ 4696, 4696 },
	{ 4698, 4701 },
	{ 4704, 4744 },
	{ 4746, 4749 },
	{ 4752, 4784 },
	{ 4786, 4789 },
	{ 4792, 4798 },
	{ 4800, 4800 },
	{ 4802, 4805 },
	{ 4808, 4822 },
	{ 4824, 4880 },
	{ 4882, 4885 },
	{ 4888, 4954 },
	{ 4992, 5007 },
	{ 5024, 5109 },
	{ 5112, 5117 },
	{ 5121, 5740 },
	{ 5743, 5759 },
	{ 5761, 5786 },
	{ 5792, 5866 },
	{ 5870, 5880 },
	{ 5888, 5907 },
	{ 5919, 5939 },
	{ 5952, 5971 },
	{ 5984, 5996 },
	{ 5998, 6000 },
	{ 6002, 6003 },
	{ 6016, 6067 },
	{ 6070, 6088 },
	{ 6103, 6103 },
	{ 6108, 6108 },
	{ 6112, 6121 },
	{ 6160, 6169 },
	{ 6176, 6264 },
	{ 6272, 6314 },
	{ 6320, 6389 },
	{ 6400, 6430 },
	{ 6432, 6443 },
	{ 6448, 6456 },
	{ 6470, 6509 },
	{ 6512, 6516 },
	{ 6528, 6571 },
	{ 6576, 6601 },
	{ 6608, 6617 },
	{ 6656, 6683 },
	{ 6688, 6750 },
	{ 6753, 6772 },
	{ 6784, 6793 },
	{ 6800, 6809 },
	{ 6823, 6823 },
	{ 6847, 6848 },
	{ 6860, 6862 },
	{ 6912, 6963 },
	{ 6965, 6979 },
	{ 6981, 6988 },
	{ 6992, 7001 },
	{ 7040, 7081 },
	{ 7084, 7141 },
	{ 7143, 7153 },
	{ 7168, 7222 },
	{ 7232, 7241 },
	{ 7245, 7293 },
	{ 7296, 7304 },
	{ 7312, 7354 },
	{ 7357, 7359 },
	{ 7401, 7404 },
	{ 7406, 7411 },
	{ 7413, 7414 },
	{ 7418, 7418 },
	{ 7424, 7615 },
	{ 7655, 7668 },
	{ 7680, 7957 },
	{ 7960, 7965 },
	{ 7968, 8005 },
	{ 8008, 8013 },
	{ 8016, 8023 },
	{ 8025, 8025 },
	{ 8027, 8027 },
	{ 8029, 8029 },
	{ 8031, 8061 },
	{ 8064, 8116 },
	{ 8118, 8124 },
	{ 8126, 8126 },
	{ 8130, 8132 },
	{ 8134, 8140 },
	{ 8144, 8147 },
	{ 8150, 8155 },
	{ 8160, 8172 },
	{ 8178, 8180 },
	{ 8182, 8188 },
	{ 8305, 8305 },
	{ 8319, 8319 },
	{ 8336, 8348 },
	{ 8450, 8450 },
	{ 8455, 8455 },
	{ 8458, 8467 },
	{ 8469, 8469 },
	{ 8473, 8477 },
	{ 8484, 8484 },
	{ 8486, 8486 },
	{ 8488, 8488 },
	{ 8490, 8493 },
	{ 8495, 8505 },
	{ 8508, 8511 },
	{ 8517, 8521 },
	{ 8526, 8526 },
	{ 8544, 8584 },
	{ 9398, 9449 },
	{ 11264, 11492 },
	{ 11499, 11502 },
	{ 11506, 11507 },
	{ 11520, 11557 },
	{ 11559, 11559 },
	{ 11565, 11565 },
	{ 11568, 11623 },
	{ 11631, 11631 },
	{ 11648, 11670 },
	{ 11680, 11686 },
	{ 11688, 11694 },
	{ 11696, 11702 },
	{ 11704, 11710 },
	{ 11712, 11718 },
	{ 11720, 11726 },
	{ 11728, 11734 },
	{ 11736, 11742 },
	{ 11744, 11775 },
	{ 11823, 11823 },
	{ 12293, 12295 },
	{ 12321, 12329 },
	{ 12337, 12341 },
	{ 12344, 12348 },
	{ 12353, 12438 },
	{ 12445, 12447 },
	{ 12449, 12538 },
	{ 12540, 12543 },
	{ 12549, 12591 },
	{ 12593, 12686 },
	{ 12704, 12735 },
	{ 12784, 12799 },
	{ 13312, 19903 },
	{ 19968, 42124 },
	{ 42192, 42237 },
	{ 42240, 42508 },
	{ 42512, 42539 },
	{ 42560, 42606 },
	{ 42612, 42619 },
	{ 42623, 42735 },
	{ 42775, 42783 },
	{ 42786, 42888 },
	{ 42891, 42954 },
	{ 42960, 42961 },
	{ 42963, 42963 },
	{ 42965, 42969 },
	{ 42994, 43013 },
	{ 43015, 43047 },
	{ 43072, 43123 },
	{ 43136, 43203 },
	{ 43205, 43205 },
	{ 43216, 43225 },
	{ 43250, 43255 },
	{ 43259, 43259 },
	{ 43261, 43306 },
	{ 43312, 43346 },
	{ 43360, 43388 },
	{ 43392, 43442 },
	{ 43444, 43455 },
	{ 43471, 43481 },
	{ 43488, 43518 },
	{ 43520, 43574 },
	{ 43584, 43597 },
	{ 43600, 43609 },
	{ 43616, 43638 },
	{ 43642, 43710 },
	{ 43712, 43712 },
	{ 43714, 43714 },
	{ 43739, 43741 },
	{ 43744, 43759 },
	{ 43762, 43765 },
	{ 43777, 43782 },
	{ 43785, 43790 },
	{ 43793, 43798 },
	{ 43808, 43814 },
	{ 43816, 43822 },
	{ 43824, 43866 },
	{ 43868, 43881 },
	{ 43888, 44010 },
	{ 44016, 44025 },
	{ 44032, 55203 },
	{ 55216, 55238 },
	{ 55243, 55291 },
	{ 63744, 64109 },
	{ 64112, 64217 },
	{ 64256, 64262 },
	{ 64275, 64279 },
	{ 64285, 64296 },
	{ 64298, 64310 },
	{ 64312, 64316 },
	{ 64318, 64318 },
	{ 64320, 64321 },
	{ 64323, 64324 },
	{ 64326, 64433 },
	{ 64467, 64829 },
	{ 64848, 64911 },
	{ 64914, 64967 },
	{ 65008, 65019 },
	{ 65136, 65140 },
	{ 65142, 65276 },
	{ 65296, 65305 },
	{ 65313, 65338 },
	{ 65345, 65370 },
	{ 65382, 65470 },
	{ 65474, 65479 },
	{ 65482, 65487 },
	{ 65490, 65495 },
	{ 65498, 65500 },
	{ 65536, 65547 },
	{ 65549, 65574 },
	{ 65576, 65594 },
	{ 65596, 65597 },
	{ 65599, 65613 },
	{ 65616, 65629 },
	{ 65664, 65786 },
	{ 65856, 65908 },
	{ 66176, 66204 },
	{ 66208, 66256 },
	{ 66304, 66335 },
	{ 66349, 66378 },
	{ 66384, 66426 },
	{ 66432, 66461 },
	{ 66464, 66499 },
	{ 66504, 66511 },
	{ 66513, 66517 },
	{ 66560, 66717 },
	{ 66720, 66729 },
	{ 66736, 66771 },
	{ 66776, 66811 },
	{ 66816, 66855 },
	{ 66864, 66915 },
	{ 66928, 66938 },
	{ 66940, 66954 },
	{ 66956, 66962 },
	{ 66964, 66965 },
	{ 66967, 66977 },
	{ 66979, 66993 },
	{ 66995, 67001 },
	{ 67003, 67004 },
	{ 67072, 67382 },
	{ 67392, 67413 },
	{ 67424, 67431 },
	{ 67456, 67461 },
	{ 67463, 67504 },
	{ 67506, 67514 },
	{ 67584, 67589 },
	{ 67592, 67592 },
	{ 67594, 67637 },
	{ 67639, 67640 },
	{ 67644, 67644 },
	{ 67647, 67669 },
	{ 67680, 67702 },
	{ 67712, 67742 },
	{ 67808, 67826 },
	{ 67828, 67829 },
	{ 67840, 67861 },
	{ 67872, 67897 },
	{ 67968, 68023 },
	{ 68030, 68031 },
	{ 68096, 68099 },
	{ 68101, 68102 },
	{ 68108, 68115 },
	{ 68117, 68119 },
	{ 68121, 68149 },
	{ 68192, 68220 },
	{ 68224, 68252 },
	{ 68288, 68295 },
	{ 68297, 68324 },
	{ 68352, 68405 },
	{ 68416, 68437 },
	{ 68448, 68466 },
	{ 68480, 68497 },
	{ 68608, 68680 },
	{ 68736, 68786 },
	{ 68800, 68850 },
	{ 68864, 68903 },
	{ 68912, 68921 },
	{ 69248, 69289 },
	{ 69291, 69292 },
	{ 69296, 69297 },
	{ 69376, 69404 },
	{ 69415, 69415 },
	{ 69424, 69445 },
	{ 69488, 69505 },
	{ 69552, 69572 },
	{ 69600, 69622 },
	{ 69632, 69701 },
	{ 69734, 69743 },
	{ 69745, 69749 },
	{ 69762, 69816 },
	{ 69826, 69826 },
	{ 69840, 69864 },
	{ 69872, 69881 },
	{ 69888, 69938 },
	{ 69942, 69951 },
	{ 69956, 69959 },
	{ 69968, 70002 },
	{ 70006, 70006 },
	{ 70016, 70079 },
	{ 70081, 70084 },
	{ 70094, 70106 },
	{ 70108, 70108 },
	{ 70144, 70161 },
	{ 70163, 70196 },
	{ 70199, 70199 },
	{ 70206, 70206 },
	{ 70272, 70278 },
	{ 70280, 70280 },
	{ 70282, 70285 },
	{ 70287, 70301 },
	{ 70303, 70312 },
	{ 70320, 70376 },
	{ 70384, 70393 },
	{ 70400, 70403 },
	{ 70405, 70412 },
	{ 70415, 70416 },
	{ 70419, 70440 },
	{ 70442, 70448 },
	{ 70450, 70451 },
	{ 70453, 70457 },
	{ 70461, 70468 },
	{ 70471, 70472 },
	{ 70475, 70476 },
	{ 70480, 70480 },
	{ 70487, 70487 },
	{ 70493, 70499 },
	{ 70656, 70721 },
	{ 70723, 70725 },
	{ 70727, 70730 },
	{ 70736, 70745 },
	{ 70751, 70753 },
	{ 70784, 70849 },
	{ 70852, 70853 },
	{ 70855, 70855 },
	{ 70864, 70873 },
	{ 71040, 71093 },
	{ 71096, 71102 },
	{ 71128, 71133 },
	{ 71168, 71230 },
	{ 71232, 71232 },
	{ 71236, 71236 },
	{ 71248, 71257 },
	{ 71296, 71349 },
	{ 71352, 71352 },
	{ 71360, 71369 },
	{ 71424, 71450 },
	{ 71453, 71466 },
	{ 71472, 71481 },
	{ 71488, 71494 },
	{ 71680, 71736 },
	{ 71840, 71913 },
	{ 71935, 71942 },
	{ 71945, 71945 },
	{ 71948, 71955 },
	{ 71957, 71958 },
	{ 71960, 71989 },
	{ 71991, 71992 },
	{ 71995, 71996 },
	{ 71999, 72002 },
	{ 72016, 72025 },
	{ 72096, 72103 },
	{ 72106, 72151 },
	{ 72154, 72159 },
	{ 72161, 72161 },
	{ 72163, 72164 },
	{ 72192, 72242 },
	{ 72245, 72254 },
	{ 72272, 72343 },
	{ 72349, 72349 },
	{ 72368, 72440 },
	{ 72704, 72712 },
	{ 72714, 72758 },
	{ 72760, 72766 },
	{ 72768, 72768 },
	{ 72784, 72793 },
	{ 72818, 72847 },
	{ 72850, 72871 },
	{ 72873, 72886 },
	{ 72960, 72966 },
	{ 72968, 72969 },
	{ 72971, 73014 },
	{ 73018, 73018 },
	{ 73020, 73021 },
	{ 73023, 73025 },
	{ 73027, 73027 },
	{ 73030, 73031 },
	{ 73040, 73049 },
	{ 73056, 73061 },
	{ 73063, 73064 },
	{ 73066, 73102 },
	{ 73104, 73105 },
	{ 73107, 73110 },
	{ 73112, 73112 },
	{ 73120, 73129 },
	{ 73440, 73462 },
	{ 73648, 73648 },
	{ 73728, 74649 },
	{ 74752, 74862 },
	{ 74880, 75075 },
	{ 77712, 77808 },
	{ 77824, 78894 },
	{ 82944, 83526 },
	{ 92160, 92728 },
	{ 92736, 92766 },
	{ 92768, 92777 },
	{ 92784, 92862 },
	{ 92864, 92873 },
	{ 92880, 92909 },
	{ 92928, 92975 },
	{ 92992, 92995 },
	{ 93008, 93017 },
	{ 93027, 93047 },
	{ 93053, 93071 },
	{ 93760, 93823 },
	{ 93952, 94026 },
	{ 94031, 94087 },
	{ 94095, 94111 },
	{ 94176, 94177 },
	{ 94179, 94179 },
	{ 94192, 94193 },
	{ 94208, 100343 },
	{ 100352, 101589 },
	{ 101632, 101640 },
	{ 110576, 110579 },
	{ 110581, 110587 },
	{ 110589, 110590 },
	{ 110592, 110882 },
	{ 110928, 110930 },
	{ 110948, 110951 },
	{ 110960, 111355 },
	{ 113664, 113770 },
	{ 113776, 113788 },
	{ 113792, 113800 },
	{ 113808, 113817 },
	{ 113822, 113822 },
	{ 119808, 119892 },
	{ 119894, 119964 },
	{ 119966, 119967 },
	{ 119970, 119970 },
	{ 119973, 119974 },
	{ 119977, 119980 },
	{ 119982, 119993 },
	{ 119995, 119995 },
	{ 119997, 120003 },
	{ 120005, 120069 },
	{ 120071, 120074 },
	{ 120077, 120084 },
	{ 120086, 120092 },
	{ 120094, 120121 },
	{ 120123, 120126 },
	{ 120128, 120132 },
	{ 120134, 120134 },
	{ 120138, 120144 },
	{ 120146, 120485 },
	{ 120488, 120512 },
	{ 120514, 120538 },
	{ 120540, 120570 },
	{ 120572, 120596 },
	{ 120598, 120628 },
	{ 120630, 120654 },
	{ 120656, 120686 },
	{ 120688, 120712 },
	{ 120714, 120744 },
	{ 120746, 120770 },
	{ 120772, 120779 },
	{ 120782, 120831 },
	{ 122624, 122654 },
	{ 122880, 122886 },
	{ 122888, 122904 },
	{ 122907, 122913 },
	{ 122915, 122916 },
	{ 122918, 122922 },
	{ 123136, 123180 },
	{ 123191, 123197 },
	{ 123200, 123209 },
	{ 123214, 123214 },
	{ 123536, 123565 },
	{ 123584, 123627 },
	{ 123632, 123641 },
	{ 124896, 124902 },
	{ 124904, 124907 },
	{ 124909, 124910 },
	{ 124912, 124926 },
	{ 124928, 125124 },
	{ 125184, 125251 },
	{ 125255, 125255 },
	{ 125259, 125259 },
	{ 125264, 125273 },
	{ 126464, 126467 },
	{ 126469, 126495 },
	{ 126497, 126498 },
	{ 126500, 126500 },
	{ 126503, 126503 },
	{ 126505, 126514 },
	{ 126516, 126519 },
	{ 126521, 126521 },
	{ 126523, 126523 },
	{ 126530, 126530 },
	{ 126535, 126535 },
	{ 126537, 126537 },
	{ 126539, 126539 },
	{ 126541, 126543 },
	{ 126545, 126546 },
	{ 126548, 126548 },
	{ 126551, 126551 },
	{ 126553, 126553 },
	{ 126555, 126555 },
	{ 126557, 126557 },
	{ 126559, 126559 },
	{ 126561, 126562 },
	{ 126564, 126564 },
	{ 126567, 126570 },
	{ 126572, 126578 },
	{ 126580, 126583 },
	{ 126585, 126588 },
	{ 126590, 126590 },
	{ 126592, 126601 },
	{ 126603, 126619 },
	{ 126625, 126627 },
	{ 126629, 126633 },
	{ 126635, 126651 },
	{ 127280, 127305 },
	{ 127312, 127337 },
	{ 127344, 127369 },
	{ 130032, 130041 },
	{ 131072, 173791 },
	{ 173824, 177976 },
	{ 177984, 178205 },
	{ 178208, 183969 },
	{ 183984, 191456 },
	{ 194560, 195101 },
	{ 196608, 201546 },
	{ -1, -1 },	// end markers
};
static struct _class_data {
	const char *name;				// e.g., "alpha"
	int (*charcheckfunc)(int c);	// function pointer, e.g., isalpha
	wctype_t	wctype;				// from wctype("alpha")
	const set_item	*data[2];		// alpha, NULL
} class_data[] = {
	{ "alnum",	isalnum,	0,	{ digit, alpha } },
	{ "alpha",	isalpha,	0,	{ alpha, NULL } },
	{ "blank",	isblank,	0,	{ blank, NULL } },
	{ "cntrl",	iscntrl,	0,	{ cntrl, NULL } },
	{ "digit",	isdigit,	0,	{ digit, NULL } },
	{ "graph",	isgraph,	0,	{ print_graph_common, graph_additional } },
	{ "lower",	islower,	0,	{ lower, NULL } },
	{ "print",	isprint,	0,	{ print_graph_common, print_additional } },
	{ "punct",	ispunct,	0,	{ punct, NULL } },
	{ "space",	isspace,	0,	{ space, NULL } },
	{ "upper",	isupper,	0,	{ upper, NULL } },
	{ "xdigit",	isxdigit,	0,	{ xdigit, NULL } },
	{ NULL, NULL, 0, { NULL, NULL } },
};
static struct _class_cache {
	const char *name;
	charset_t *set;
	struct _class_cache *next;	// linked list
} *class_cache[53];
static const struct equiv {
	int32_t		the_char;
	int			count;
	int32_t		equivs[200];
} equiv_table[] = {
	{ 0x30, 72, { 0x660, 0x6f0, 0x7c0, 0x966, 0x9e6, 0xa66, 0xae6, 0xb66, 0xbe6, 0xc66, 0xc78, 0xce6, 0xd66, 0xde6, 0xe50, 0xed0, 0xf20, 0xf33, 0x1040, 0x1090, 0x17e0, 0x17f0, 0x1810, 0x1946, 0x19d0, 0x1a80, 0x1a90, 0x1b50, 0x1bb0, 0x1c40, 0x1c50, 0x2070, 0x2080, 0x2189, 0x24ea, 0x24ff, 0x3007, 0x3358, 0xa620, 0xa8d0, 0xa900, 0xa9d0, 0xa9f0, 0xaa50, 0xabf0, 0xff10, 0x1018a, 0x104a0, 0x11066, 0x110f0, 0x11136, 0x111d0, 0x112f0, 0x11450, 0x114d0, 0x11650, 0x116c0, 0x11730, 0x118e0, 0x11c50, 0x16a60, 0x16b50, 0x1d7ce, 0x1d7d8, 0x1d7e2, 0x1d7ec, 0x1d7f6, 0x1e950, 0x1f100, 0x1f101, 0x1f10b, 0x1f10c, } },
	{ 0x31, 189, { 0xb9, 0xbc, 0xbd, 0x661, 0x6f1, 0x7c1, 0x967, 0x9e7, 0xa67, 0xae7, 0xb67, 0xbe7, 0xc67, 0xc79, 0xc7c, 0xce7, 0xd67, 0xde7, 0xe51, 0xed1, 0xf21, 0xf2a, 0x1041, 0x1091, 0x1369, 0x17e1, 0x17f1, 0x1811, 0x1947, 0x19d1, 0x19da, 0x1a81, 0x1a91, 0x1b51, 0x1bb1, 0x1c41, 0x1c51, 0x2081, 0x2150, 0x2151, 0x2152, 0x2153, 0x2155, 0x2159, 0x215b, 0x215f, 0x2460, 0x2469, 0x246a, 0x246b, 0x246c, 0x246d, 0x246e, 0x246f, 0x2470, 0x2471, 0x2472, 0x2474, 0x247d, 0x247e, 0x247f, 0x2480, 0x2481, 0x2482, 0x2483, 0x2484, 0x2485, 0x2486, 0x2488, 0x2491, 0x2492, 0x2493, 0x2494, 0x2495, 0x2496, 0x2497, 0x2498, 0x2499, 0x249a, 0x24eb, 0x24ec, 0x24ed, 0x24ee, 0x24ef, 0x24f0, 0x24f1, 0x24f2, 0x24f3, 0x24f5, 0x24fe, 0x2776, 0x277f, 0x2780, 0x2789, 0x278a, 0x2793, 0x3021, 0x3248, 0x32c0, 0x32c9, 0x32ca, 0x32cb, 0x3359, 0x3362, 0x3363, 0x3364, 0x3365, 0x3366, 0x3367, 0x3368, 0x3369, 0x336a, 0x336b, 0x33e0, 0x33e9, 0x33ea, 0x33eb, 0x33ec, 0x33ed, 0x33ee, 0x33ef, 0x33f0, 0x33f1, 0x33f2, 0xa621, 0xa8d1, 0xa901, 0xa9d1, 0xa9f1, 0xaa51, 0xabf1, 0xff11, 0x10107, 0x10142, 0x10158, 0x10159, 0x1015a, 0x102e1, 0x10320, 0x103d1, 0x104a1, 0x10858, 0x10879, 0x108a7, 0x108fb, 0x10916, 0x109c0, 0x10a40, 0x10a7d, 0x10a9d, 0x10aeb, 0x10b58, 0x10b78, 0x10ba9, 0x10cfa, 0x10e60, 0x11052, 0x11067, 0x110f1, 0x11137, 0x111d1, 0x111e1, 0x112f1, 0x11451, 0x114d1, 0x11651, 0x116c1, 0x11731, 0x118e1, 0x11c51, 0x11c5a, 0x12415, 0x1241e, 0x1242c, 0x12434, 0x1244f, 0x12458, 0x16a61, 0x16b51, 0x1d360, 0x1d7cf, 0x1d7d9, 0x1d7e3, 0x1d7ed, 0x1d7f7, 0x1e8c7, 0x1e951, 0x1f102, 0x1f1a4, } },
	{ 0x32, 142, { 0xb2, 0x662, 0x6f2, 0x7c2, 0x968, 0x9e8, 0xa68, 0xae8, 0xb68, 0xbe8, 0xc68, 0xc7a, 0xc7d, 0xce8, 0xd68, 0xde8, 0xe52, 0xed2, 0xf22, 0xf2b, 0x1042, 0x1092, 0x136a, 0x17e2, 0x17f2, 0x1812, 0x1948, 0x19d2, 0x1a82, 0x1a92, 0x1b52, 0x1bb2, 0x1c42, 0x1c52, 0x2082, 0x2154, 0x2156, 0x2461, 0x2473, 0x2475, 0x2487, 0x2489, 0x249b, 0x24f4, 0x24f6, 0x2777, 0x2781, 0x278b, 0x3022, 0x3249, 0x3251, 0x3252, 0x3253, 0x3254, 0x3255, 0x3256, 0x3257, 0x3258, 0x3259, 0x32c1, 0x335a, 0x336c, 0x336d, 0x336e, 0x336f, 0x3370, 0x33e1, 0x33f3, 0x33f4, 0x33f5, 0x33f6, 0x33f7, 0x33f8, 0x33f9, 0x33fa, 0x33fb, 0x33fc, 0xa622, 0xa8d2, 0xa902, 0xa9d2, 0xa9f2, 0xaa52, 0xabf2, 0xff12, 0x10108, 0x1015b, 0x1015c, 0x1015d, 0x1015e, 0x102e2, 0x103d2, 0x104a2, 0x10859, 0x1087a, 0x108a8, 0x1091a, 0x109c1, 0x10a41, 0x10b59, 0x10b79, 0x10baa, 0x10e61, 0x11053, 0x11068, 0x110f2, 0x11138, 0x111d2, 0x111e2, 0x112f2, 0x11452, 0x114d2, 0x11652, 0x116c2, 0x11732, 0x118e2, 0x11c52, 0x11c5b, 0x12400, 0x12416, 0x1241f, 0x12423, 0x1242d, 0x12435, 0x1244a, 0x12450, 0x12456, 0x12459, 0x16a62, 0x16b52, 0x1d361, 0x1d7d0, 0x1d7da, 0x1d7e4, 0x1d7ee, 0x1d7f8, 0x1e8c8, 0x1e952, 0x1f103, 0x1f19c, 0x1f19d, 0x1f1a2, } },
	{ 0x33, 125, { 0xb3, 0xbe, 0x663, 0x6f3, 0x7c3, 0x969, 0x9e9, 0xa69, 0xae9, 0xb69, 0xbe9, 0xc69, 0xc7b, 0xc7e, 0xce9, 0xd69, 0xde9, 0xe53, 0xed3, 0xf23, 0xf2c, 0x1043, 0x1093, 0x136b, 0x17e3, 0x17f3, 0x1813, 0x1949, 0x19d3, 0x1a83, 0x1a93, 0x1b53, 0x1bb3, 0x1c43, 0x1c53, 0x2083, 0x2157, 0x215c, 0x2462, 0x2476, 0x248a, 0x24f7, 0x2778, 0x2782, 0x278c, 0x3023, 0x324a, 0x325a, 0x325b, 0x325c, 0x325d, 0x325e, 0x325f, 0x32b1, 0x32b2, 0x32b3, 0x32b4, 0x32c2, 0x335b, 0x33e2, 0x33fd, 0x33fe, 0xa623, 0xa8d3, 0xa903, 0xa9d3, 0xa9f3, 0xaa53, 0xabf3, 0xff13, 0x10109, 0x102e3, 0x104a3, 0x1085a, 0x1087b, 0x108a9, 0x1091b, 0x109c2, 0x10a42, 0x10b5a, 0x10b7a, 0x10bab, 0x10e62, 0x11054, 0x11069, 0x110f3, 0x11139, 0x111d3, 0x111e3, 0x112f3, 0x11453, 0x114d3, 0x11653, 0x116c3, 0x11733, 0x118e3, 0x11c53, 0x11c5c, 0x12401, 0x12408, 0x12417, 0x12420, 0x12424, 0x12425, 0x1242e, 0x1242f, 0x12436, 0x12437, 0x1243a, 0x1243b, 0x1244b, 0x12451, 0x12457, 0x16a63, 0x16b53, 0x1d362, 0x1d7d1, 0x1d7db, 0x1d7e5, 0x1d7ef, 0x1d7f9, 0x1e8c9, 0x1e953, 0x1f104, 0x1f19b, } },
	{ 0x34, 119, { 0x664, 0x6f4, 0x7c4, 0x96a, 0x9ea, 0xa6a, 0xaea, 0xb6a, 0xbea, 0xc6a, 0xcea, 0xd6a, 0xdea, 0xe54, 0xed4, 0xf24, 0xf2d, 0x1044, 0x1094, 0x136c, 0x17e4, 0x17f4, 0x1814, 0x194a, 0x19d4, 0x1a84, 0x1a94, 0x1b54, 0x1bb4, 0x1c44, 0x1c54, 0x2074, 0x2084, 0x2158, 0x2463, 0x2477, 0x248b, 0x24f8, 0x2779, 0x2783, 0x278d, 0x3024, 0x324b, 0x32b5, 0x32b6, 0x32b7, 0x32b8, 0x32b9, 0x32ba, 0x32bb, 0x32bc, 0x32bd, 0x32be, 0x32c3, 0x335c, 0x33e3, 0xa624, 0xa8d4, 0xa904, 0xa9d4, 0xa9f4, 0xaa54, 0xabf4, 0xff14, 0x1010a, 0x102e4, 0x104a4, 0x1087c, 0x108aa, 0x108ab, 0x109c3, 0x10a43, 0x10b5b, 0x10b7b, 0x10bac, 0x10e63, 0x11055, 0x1106a, 0x110f4, 0x1113a, 0x111d4, 0x111e4, 0x112f4, 0x11454, 0x114d4, 0x11654, 0x116c4, 0x11734, 0x118e4, 0x11c54, 0x11c5d, 0x12402, 0x12409, 0x1240f, 0x12418, 0x12421, 0x12426, 0x12430, 0x12438, 0x1243c, 0x1243d, 0x1243e, 0x1243f, 0x1244c, 0x12452, 0x12453, 0x12469, 0x16a64, 0x16b54, 0x1d363, 0x1d7d2, 0x1d7dc, 0x1d7e6, 0x1d7f0, 0x1d7fa, 0x1e8ca, 0x1e954, 0x1f105, 0x1f19e, } },
	{ 0x35, 111, { 0x665, 0x6f5, 0x7c5, 0x96b, 0x9eb, 0xa6b, 0xaeb, 0xb6b, 0xbeb, 0xc6b, 0xceb, 0xd6b, 0xdeb, 0xe55, 0xed5, 0xf25, 0xf2e, 0x1045, 0x1095, 0x136d, 0x17e5, 0x17f5, 0x1815, 0x194b, 0x19d5, 0x1a85, 0x1a95, 0x1b55, 0x1bb5, 0x1c45, 0x1c55, 0x2075, 0x2085, 0x215a, 0x215d, 0x2464, 0x2478, 0x248c, 0x24f9, 0x277a, 0x2784, 0x278e, 0x3025, 0x324c, 0x32bf, 0x32c4, 0x335d, 0x33e4, 0xa625, 0xa8d5, 0xa905, 0xa9d5, 0xa9f5, 0xaa55, 0xabf5, 0xff15, 0x1010b, 0x10143, 0x10148, 0x1014f, 0x1015f, 0x10173, 0x102e5, 0x10321, 0x104a5, 0x1087d, 0x108ac, 0x108fc, 0x109c4, 0x10aec, 0x10cfb, 0x10e64, 0x11056, 0x1106b, 0x110f5, 0x1113b, 0x111d5, 0x111e5, 0x112f5, 0x11455, 0x114d5, 0x11655, 0x116c5, 0x11735, 0x118e5, 0x11c55, 0x11c5e, 0x12403, 0x1240a, 0x12410, 0x12419, 0x12422, 0x12427, 0x12431, 0x12439, 0x1244d, 0x12454, 0x12455, 0x1246a, 0x16a65, 0x16b55, 0x1d364, 0x1d7d3, 0x1d7dd, 0x1d7e7, 0x1d7f1, 0x1d7fb, 0x1e8cb, 0x1e955, 0x1f106, 0x1f1a0, } },
	{ 0x36, 94, { 0x666, 0x6f6, 0x7c6, 0x96c, 0x9ec, 0xa6c, 0xaec, 0xb6c, 0xbec, 0xc6c, 0xcec, 0xd6c, 0xdec, 0xe56, 0xed6, 0xf26, 0xf2f, 0x1046, 0x1096, 0x136e, 0x17e6, 0x17f6, 0x1816, 0x194c, 0x19d6, 0x1a86, 0x1a96, 0x1b56, 0x1bb6, 0x1c46, 0x1c56, 0x2076, 0x2086, 0x2185, 0x2465, 0x2479, 0x248d, 0x24fa, 0x277b, 0x2785, 0x278f, 0x3026, 0x324d, 0x32c5, 0x335e, 0x33e5, 0xa626, 0xa8d6, 0xa906, 0xa9d6, 0xa9f6, 0xaa56, 0xabf6, 0xff16, 0x1010c, 0x102e6, 0x104a6, 0x109c5, 0x10e65, 0x11057, 0x1106c, 0x110f6, 0x1113c, 0x111d6, 0x111e6, 0x112f6, 0x11456, 0x114d6, 0x11656, 0x116c6, 0x11736, 0x118e6, 0x11c56, 0x11c5f, 0x12404, 0x1240b, 0x12411, 0x1241a, 0x12428, 0x12440, 0x1244e, 0x1246b, 0x16a66, 0x16b56, 0x1d365, 0x1d7d4, 0x1d7de, 0x1d7e8, 0x1d7f2, 0x1d7fc, 0x1e8cc, 0x1e956, 0x1f107, 0x1f1a3, } },
	{ 0x37, 95, { 0x667, 0x6f7, 0x7c7, 0x96d, 0x9ed, 0xa6d, 0xaed, 0xb6d, 0xbed, 0xc6d, 0xced, 0xd6d, 0xded, 0xe57, 0xed7, 0xf27, 0xf30, 0x1047, 0x1097, 0x136f, 0x17e7, 0x17f7, 0x1817, 0x194d, 0x19d7, 0x1a87, 0x1a97, 0x1b57, 0x1bb7, 0x1c47, 0x1c57, 0x2077, 0x2087, 0x215e, 0x2466, 0x247a, 0x248e, 0x24fb, 0x277c, 0x2786, 0x2790, 0x3027, 0x324e, 0x32c6, 0x335f, 0x33e6, 0xa627, 0xa8d7, 0xa907, 0xa9d7, 0xa9f7, 0xaa57, 0xabf7, 0xff17, 0x1010d, 0x102e7, 0x104a7, 0x109c6, 0x10e66, 0x11058, 0x1106d, 0x110f7, 0x1113d, 0x111d7, 0x111e7, 0x112f7, 0x11457, 0x114d7, 0x11657, 0x116c7, 0x11737, 0x118e7, 0x11c57, 0x11c60, 0x12405, 0x1240c, 0x12412, 0x1241b, 0x12429, 0x12441, 0x12442, 0x12443, 0x1246c, 0x16a67, 0x16b57, 0x1d366, 0x1d7d5, 0x1d7df, 0x1d7e9, 0x1d7f3, 0x1d7fd, 0x1e8cd, 0x1e957, 0x1f108, 0x1f1a1, } },
	{ 0x38, 93, { 0x668, 0x6f8, 0x7c8, 0x96e, 0x9ee, 0xa6e, 0xaee, 0xb6e, 0xbee, 0xc6e, 0xcee, 0xd6e, 0xdee, 0xe58, 0xed8, 0xf28, 0xf31, 0x1048, 0x1098, 0x1370, 0x17e8, 0x17f8, 0x1818, 0x194e, 0x19d8, 0x1a88, 0x1a98, 0x1b58, 0x1bb8, 0x1c48, 0x1c58, 0x2078, 0x2088, 0x2467, 0x247b, 0x248f, 0x24fc, 0x277d, 0x2787, 0x2791, 0x3028, 0x324f, 0x32c7, 0x3360, 0x33e7, 0xa628, 0xa8d8, 0xa908, 0xa9d8, 0xa9f8, 0xaa58, 0xabf8, 0xff18, 0x1010e, 0x102e8, 0x104a8, 0x109c7, 0x10e67, 0x11059, 0x1106e, 0x110f8, 0x1113e, 0x111d8, 0x111e8, 0x112f8, 0x11458, 0x114d8, 0x11658, 0x116c8, 0x11738, 0x118e8, 0x11c58, 0x11c61, 0x12406, 0x1240d, 0x12413, 0x1241c, 0x1242a, 0x12444, 0x12445, 0x1246d, 0x16a68, 0x16b58, 0x1d367, 0x1d7d6, 0x1d7e0, 0x1d7ea, 0x1d7f4, 0x1d7fe, 0x1e8ce, 0x1e958, 0x1f109, 0x1f19f, } },
	{ 0x39, 93, { 0x669, 0x6f9, 0x7c9, 0x96f, 0x9ef, 0xa6f, 0xaef, 0xb6f, 0xbef, 0xc6f, 0xcef, 0xd6f, 0xdef, 0xe59, 0xed9, 0xf29, 0xf32, 0x1049, 0x1099, 0x1371, 0x17e9, 0x17f9, 0x1819, 0x194f, 0x19d9, 0x1a89, 0x1a99, 0x1b59, 0x1bb9, 0x1c49, 0x1c59, 0x2079, 0x2089, 0x2468, 0x247c, 0x2490, 0x24fd, 0x277e, 0x2788, 0x2792, 0x3029, 0x32c8, 0x3361, 0x33e8, 0xa629, 0xa8d9, 0xa909, 0xa9d9, 0xa9f9, 0xaa59, 0xabf9, 0xff19, 0x1010f, 0x102e9, 0x104a9, 0x109c8, 0x10e68, 0x1105a, 0x1106f, 0x110f9, 0x1113f, 0x111d9, 0x111e9, 0x112f9, 0x11459, 0x114d9, 0x11659, 0x116c9, 0x11739, 0x118e9, 0x11c59, 0x11c62, 0x12407, 0x1240e, 0x12414, 0x1241d, 0x1242b, 0x12446, 0x12447, 0x12448, 0x12449, 0x1246e, 0x16a69, 0x16b59, 0x1d368, 0x1d7d7, 0x1d7e1, 0x1d7eb, 0x1d7f5, 0x1d7ff, 0x1e8cf, 0x1e959, 0x1f10a, } },
	{ 0x41, 134, { 0x61, 0xaa, 0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0x100, 0x101, 0x102, 0x103, 0x104, 0x105, 0x1cd, 0x1ce, 0x1de, 0x1df, 0x1e0, 0x1e1, 0x1e2, 0x1e3, 0x1fa, 0x1fb, 0x1fc, 0x1fd, 0x200, 0x201, 0x202, 0x203, 0x226, 0x227, 0x363, 0x1d2c, 0x1d2d, 0x1d43, 0x1dd3, 0x1dd4, 0x1dd5, 0x1dd6, 0x1df2, 0x1e00, 0x1e01, 0x1e9a, 0x1ea0, 0x1ea1, 0x1ea2, 0x1ea3, 0x1ea4, 0x1ea5, 0x1ea6, 0x1ea7, 0x1ea8, 0x1ea9, 0x1eaa, 0x1eab, 0x1eac, 0x1ead, 0x1eae, 0x1eaf, 0x1eb0, 0x1eb1, 0x1eb2, 0x1eb3, 0x1eb4, 0x1eb5, 0x1eb6, 0x1eb7, 0x2090, 0x2100, 0x2101, 0x212b, 0x214d, 0x249c, 0x24b6, 0x24d0, 0x3373, 0x33c2, 0x33df, 0xa732, 0xa733, 0xa734, 0xa735, 0xa736, 0xa737, 0xa738, 0xa739, 0xa73a, 0xa73b, 0xa73c, 0xa73d, 0xa79a, 0xa79b, 0xff21, 0xff41, 0x1d400, 0x1d41a, 0x1d434, 0x1d44e, 0x1d468, 0x1d482, 0x1d49c, 0x1d4b6, 0x1d4d0, 0x1d4ea, 0x1d504, 0x1d51e, 0x1d538, 0x1d552, 0x1d56c, 0x1d586, 0x1d5a0, 0x1d5ba, 0x1d5d4, 0x1d5ee, 0x1d608, 0x1d622, 0x1d63c, 0x1d656, 0x1d670, 0x1d68a, 0x1f110, 0x1f130, 0x1f150, 0x1f170, 0x1f18e, } },
	{ 0x42, 47, { 0x62, 0x1d2e, 0x1d47, 0x1de8, 0x1e02, 0x1e03, 0x1e04, 0x1e05, 0x1e06, 0x1e07, 0x212c, 0x249d, 0x24b7, 0x24d1, 0x3374, 0x33c3, 0xff22, 0xff42, 0x1d401, 0x1d41b, 0x1d435, 0x1d44f, 0x1d469, 0x1d483, 0x1d4b7, 0x1d4d1, 0x1d4eb, 0x1d505, 0x1d51f, 0x1d539, 0x1d553, 0x1d56d, 0x1d587, 0x1d5a1, 0x1d5bb, 0x1d5d5, 0x1d5ef, 0x1d609, 0x1d623, 0x1d63d, 0x1d657, 0x1d671, 0x1d68b, 0x1f111, 0x1f131, 0x1f151, 0x1f171, } },
	{ 0x43, 68, { 0x63, 0xc7, 0xe7, 0x106, 0x107, 0x108, 0x109, 0x10a, 0x10b, 0x10c, 0x10d, 0x368, 0x1d9c, 0x1dd7, 0x1e08, 0x1e09, 0x2102, 0x2103, 0x2105, 0x2106, 0x212d, 0x216d, 0x217d, 0x249e, 0x24b8, 0x24d2, 0x3388, 0x339d, 0x33a0, 0x33a4, 0x33c4, 0x33c5, 0x33c6, 0x33c7, 0xff23, 0xff43, 0x1d402, 0x1d41c, 0x1d436, 0x1d450, 0x1d46a, 0x1d484, 0x1d49e, 0x1d4b8, 0x1d4d2, 0x1d4ec, 0x1d520, 0x1d554, 0x1d56e, 0x1d588, 0x1d5a2, 0x1d5bc, 0x1d5d6, 0x1d5f0, 0x1d60a, 0x1d624, 0x1d63e, 0x1d658, 0x1d672, 0x1d68c, 0x1f112, 0x1f12b, 0x1f12d, 0x1f132, 0x1f152, 0x1f172, 0x1f191, 0x1f192, } },
	{ 0x44, 82, { 0x64, 0xd0, 0xf0, 0x10e, 0x10f, 0x110, 0x111, 0x1c4, 0x1c5, 0x1c6, 0x1f1, 0x1f2, 0x1f3, 0x238, 0x2a3, 0x2a4, 0x2a5, 0x369, 0x1d30, 0x1d48, 0x1d9e, 0x1dd8, 0x1dd9, 0x1e0a, 0x1e0b, 0x1e0c, 0x1e0d, 0x1e0e, 0x1e0f, 0x1e10, 0x1e11, 0x1e12, 0x1e13, 0x2145, 0x2146, 0x216e, 0x217e, 0x249f, 0x24b9, 0x24d3, 0x3372, 0x3377, 0x3378, 0x3379, 0x3397, 0x33c8, 0xa779, 0xa77a, 0xff24, 0xff44, 0x1d403, 0x1d41d, 0x1d437, 0x1d451, 0x1d46b, 0x1d485, 0x1d49f, 0x1d4b9, 0x1d4d3, 0x1d4ed, 0x1d507, 0x1d521, 0x1d53b, 0x1d555, 0x1d56f, 0x1d589, 0x1d5a3, 0x1d5bd, 0x1d5d7, 0x1d5f1, 0x1d60b, 0x1d625, 0x1d63f, 0x1d659, 0x1d673, 0x1d68d, 0x1f113, 0x1f133, 0x1f153, 0x1f173, 0x1f190, 0x1f1a5, } },
	{ 0x45, 93, { 0x65, 0xc8, 0xc9, 0xca, 0xcb, 0xe8, 0xe9, 0xea, 0xeb, 0x112, 0x113, 0x114, 0x115, 0x116, 0x117, 0x118, 0x119, 0x11a, 0x11b, 0x204, 0x205, 0x206, 0x207, 0x228, 0x229, 0x364, 0x1d31, 0x1d49, 0x1e14, 0x1e15, 0x1e16, 0x1e17, 0x1e18, 0x1e19, 0x1e1a, 0x1e1b, 0x1e1c, 0x1e1d, 0x1eb8, 0x1eb9, 0x1eba, 0x1ebb, 0x1ebc, 0x1ebd, 0x1ebe, 0x1ebf, 0x1ec0, 0x1ec1, 0x1ec2, 0x1ec3, 0x1ec4, 0x1ec5, 0x1ec6, 0x1ec7, 0x2091, 0x212f, 0x2130, 0x2147, 0x24a0, 0x24ba, 0x24d4, 0x32cd, 0x32ce, 0xff25, 0xff45, 0x1d404, 0x1d41e, 0x1d438, 0x1d452, 0x1d46c, 0x1d486, 0x1d4d4, 0x1d4ee, 0x1d508, 0x1d522, 0x1d53c, 0x1d556, 0x1d570, 0x1d58a, 0x1d5a4, 0x1d5be, 0x1d5d8, 0x1d5f2, 0x1d60c, 0x1d626, 0x1d640, 0x1d65a, 0x1d674, 0x1d68e, 0x1f114, 0x1f134, 0x1f154, 0x1f174, } },
	{ 0x46, 52, { 0x66, 0x2a9, 0x1da0, 0x1deb, 0x1e1e, 0x1e1f, 0x2109, 0x2131, 0x213b, 0x24a1, 0x24bb, 0x24d5, 0x3399, 0xa77b, 0xa77c, 0xfb00, 0xfb01, 0xfb02, 0xfb03, 0xfb04, 0xff26, 0xff46, 0x1d405, 0x1d41f, 0x1d439, 0x1d453, 0x1d46d, 0x1d487, 0x1d4bb, 0x1d4d5, 0x1d4ef, 0x1d509, 0x1d523, 0x1d53d, 0x1d557, 0x1d571, 0x1d58b, 0x1d5a5, 0x1d5bf, 0x1d5d9, 0x1d5f3, 0x1d60d, 0x1d627, 0x1d641, 0x1d65b, 0x1d675, 0x1d68f, 0x1f115, 0x1f135, 0x1f155, 0x1f175, 0x1f193, } },
	{ 0x47, 62, { 0x67, 0x11c, 0x11d, 0x11e, 0x11f, 0x120, 0x121, 0x122, 0x123, 0x1e6, 0x1e7, 0x1f4, 0x1f5, 0x1d33, 0x1d4d, 0x1d79, 0x1dda, 0x1e20, 0x1e21, 0x210a, 0x24a2, 0x24bc, 0x24d6, 0x3387, 0x3393, 0x33ac, 0x33c9, 0x33ff, 0xa77d, 0xa7a0, 0xa7a1, 0xff27, 0xff47, 0x1d406, 0x1d420, 0x1d43a, 0x1d454, 0x1d46e, 0x1d488, 0x1d4a2, 0x1d4d6, 0x1d4f0, 0x1d50a, 0x1d524, 0x1d53e, 0x1d558, 0x1d572, 0x1d58c, 0x1d5a6, 0x1d5c0, 0x1d5da, 0x1d5f4, 0x1d60e, 0x1d628, 0x1d642, 0x1d65c, 0x1d676, 0x1d690, 0x1f116, 0x1f136, 0x1f156, 0x1f176, } },
	{ 0x48, 68, { 0x68, 0x124, 0x125, 0x126, 0x127, 0x21e, 0x21f, 0x2b0, 0x36a, 0x1d34, 0x1e22, 0x1e23, 0x1e24, 0x1e25, 0x1e26, 0x1e27, 0x1e28, 0x1e29, 0x1e2a, 0x1e2b, 0x1e96, 0x2095, 0x210b, 0x210c, 0x210d, 0x210e, 0x210f, 0x24a3, 0x24bd, 0x24d7, 0x32cc, 0x3371, 0x3390, 0x33ca, 0x33cb, 0xa7f8, 0xff28, 0xff48, 0x1d407, 0x1d421, 0x1d43b, 0x1d46f, 0x1d489, 0x1d4bd, 0x1d4d7, 0x1d4f1, 0x1d525, 0x1d559, 0x1d573, 0x1d58d, 0x1d5a7, 0x1d5c1, 0x1d5db, 0x1d5f5, 0x1d60f, 0x1d629, 0x1d643, 0x1d65d, 0x1d677, 0x1d691, 0x1f117, 0x1f137, 0x1f14a, 0x1f157, 0x1f177, 0x1f1a6, 0x1f1a7, 0x1f1a8, } },
	{ 0x49, 89, { 0x69, 0xcc, 0xcd, 0xce, 0xcf, 0xec, 0xed, 0xee, 0xef, 0x128, 0x129, 0x12a, 0x12b, 0x12c, 0x12d, 0x12e, 0x12f, 0x130, 0x132, 0x133, 0x1cf, 0x1d0, 0x208, 0x209, 0x20a, 0x20b, 0x365, 0x1d35, 0x1d62, 0x1e2c, 0x1e2d, 0x1e2e, 0x1e2f, 0x1ec8, 0x1ec9, 0x1eca, 0x1ecb, 0x2071, 0x2110, 0x2111, 0x2139, 0x2148, 0x2160, 0x2161, 0x2162, 0x2163, 0x2168, 0x2170, 0x2171, 0x2172, 0x2173, 0x2178, 0x24a4, 0x24be, 0x24d8, 0x337a, 0x33cc, 0xff29, 0xff49, 0x1d408, 0x1d422, 0x1d43c, 0x1d456, 0x1d470, 0x1d48a, 0x1d4be, 0x1d4d8, 0x1d4f2, 0x1d526, 0x1d540, 0x1d55a, 0x1d574, 0x1d58e, 0x1d5a8, 0x1d5c2, 0x1d5dc, 0x1d5f6, 0x1d610, 0x1d62a, 0x1d644, 0x1d65e, 0x1d678, 0x1d692, 0x1f118, 0x1f138, 0x1f158, 0x1f178, 0x1f18b, 0x1f194, } },
	{ 0x4a, 43, { 0x6a, 0x134, 0x135, 0x1f0, 0x2b2, 0x1d36, 0x2149, 0x24a5, 0x24bf, 0x24d9, 0x2c7c, 0xff2a, 0xff4a, 0x1d409, 0x1d423, 0x1d43d, 0x1d457, 0x1d471, 0x1d48b, 0x1d4a5, 0x1d4bf, 0x1d4d9, 0x1d4f3, 0x1d50d, 0x1d527, 0x1d541, 0x1d55b, 0x1d575, 0x1d58f, 0x1d5a9, 0x1d5c3, 0x1d5dd, 0x1d5f7, 0x1d611, 0x1d62b, 0x1d645, 0x1d65f, 0x1d679, 0x1d693, 0x1f119, 0x1f139, 0x1f159, 0x1f179, } },
	{ 0x4b, 69, { 0x6b, 0x136, 0x137, 0x1e8, 0x1e9, 0x1d37, 0x1d4f, 0x1ddc, 0x1e30, 0x1e31, 0x1e32, 0x1e33, 0x1e34, 0x1e35, 0x2096, 0x212a, 0x24a6, 0x24c0, 0x24da, 0x3384, 0x3385, 0x3389, 0x338f, 0x3391, 0x3398, 0x339e, 0x33a2, 0x33a6, 0x33aa, 0x33b8, 0x33be, 0x33c0, 0x33cd, 0x33ce, 0x33cf, 0xa7a2, 0xa7a3, 0xff2b, 0xff4b, 0x1d40a, 0x1d424, 0x1d43e, 0x1d458, 0x1d472, 0x1d48c, 0x1d4a6, 0x1d4c0, 0x1d4da, 0x1d4f4, 0x1d50e, 0x1d528, 0x1d542, 0x1d55c, 0x1d576, 0x1d590, 0x1d5aa, 0x1d5c4, 0x1d5de, 0x1d5f8, 0x1d612, 0x1d62c, 0x1d646, 0x1d660, 0x1d67a, 0x1d694, 0x1f11a, 0x1f13a, 0x1f15a, 0x1f17a, } },
	{ 0x4c, 74, { 0x6c, 0x139, 0x13a, 0x13b, 0x13c, 0x13d, 0x13e, 0x13f, 0x140, 0x141, 0x142, 0x1c7, 0x1c8, 0x1c9, 0x2aa, 0x2ab, 0x2e1, 0x1d38, 0x1ddd, 0x1e36, 0x1e37, 0x1e38, 0x1e39, 0x1e3a, 0x1e3b, 0x1e3c, 0x1e3d, 0x1efa, 0x1efb, 0x2097, 0x2112, 0x2113, 0x216c, 0x217c, 0x24a7, 0x24c1, 0x24db, 0x32cf, 0x33d0, 0x33d1, 0x33d2, 0x33d3, 0xff2c, 0xff4c, 0x1d40b, 0x1d425, 0x1d43f, 0x1d459, 0x1d473, 0x1d48d, 0x1d4c1, 0x1d4db, 0x1d4f5, 0x1d50f, 0x1d529, 0x1d543, 0x1d55d, 0x1d577, 0x1d591, 0x1d5ab, 0x1d5c5, 0x1d5df, 0x1d5f9, 0x1d613, 0x1d62d, 0x1d647, 0x1d661, 0x1d67b, 0x1d695, 0x1f11b, 0x1f13b, 0x1f15b, 0x1f17b, 0x1f1a9, } },
	{ 0x4d, 73, { 0x6d, 0x36b, 0x1d39, 0x1d50, 0x1e3e, 0x1e3f, 0x1e40, 0x1e41, 0x1e42, 0x1e43, 0x2098, 0x2133, 0x216f, 0x217f, 0x24a8, 0x24c2, 0x24dc, 0x3383, 0x3386, 0x338e, 0x3392, 0x3396, 0x339c, 0x339f, 0x33a1, 0x33a3, 0x33a5, 0x33a7, 0x33a8, 0x33ab, 0x33b3, 0x33b7, 0x33b9, 0x33bd, 0x33bf, 0x33c1, 0x33d4, 0x33d5, 0x33d6, 0xff2d, 0xff4d, 0x1d40c, 0x1d426, 0x1d440, 0x1d45a, 0x1d474, 0x1d48e, 0x1d4c2, 0x1d4dc, 0x1d4f6, 0x1d510, 0x1d52a, 0x1d544, 0x1d55e, 0x1d578, 0x1d592, 0x1d5ac, 0x1d5c6, 0x1d5e0, 0x1d5fa, 0x1d614, 0x1d62e, 0x1d648, 0x1d662, 0x1d67c, 0x1d696, 0x1f11c, 0x1f13c, 0x1f14b, 0x1f15c, 0x1f16a, 0x1f16b, 0x1f17c, } },
	{ 0x4e, 72, { 0x6e, 0xd1, 0xf1, 0x143, 0x144, 0x145, 0x146, 0x147, 0x148, 0x1ca, 0x1cb, 0x1cc, 0x1f8, 0x1f9, 0x1d3a, 0x1de0, 0x1e44, 0x1e45, 0x1e46, 0x1e47, 0x1e48, 0x1e49, 0x1e4a, 0x1e4b, 0x207f, 0x2099, 0x2115, 0x2116, 0x24a9, 0x24c3, 0x24dd, 0x3381, 0x338b, 0x339a, 0x33b1, 0x33b5, 0x33bb, 0xa7a4, 0xa7a5, 0xff2e, 0xff4e, 0x1d40d, 0x1d427, 0x1d441, 0x1d45b, 0x1d475, 0x1d48f, 0x1d4a9, 0x1d4c3, 0x1d4dd, 0x1d4f7, 0x1d511, 0x1d52b, 0x1d55f, 0x1d579, 0x1d593, 0x1d5ad, 0x1d5c7, 0x1d5e1, 0x1d5fb, 0x1d615, 0x1d62f, 0x1d649, 0x1d663, 0x1d67d, 0x1d697, 0x1f11d, 0x1f13d, 0x1f15d, 0x1f17d, 0x1f195, 0x1f196, } },
	{ 0x4f, 124, { 0x6f, 0xba, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd8, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf8, 0x14c, 0x14d, 0x14e, 0x14f, 0x150, 0x151, 0x152, 0x153, 0x1a0, 0x1a1, 0x1d1, 0x1d2, 0x1ea, 0x1eb, 0x1ec, 0x1ed, 0x1fe, 0x1ff, 0x20c, 0x20d, 0x20e, 0x20f, 0x22a, 0x22b, 0x22c, 0x22d, 0x22e, 0x22f, 0x230, 0x231, 0x366, 0x1d3c, 0x1d52, 0x1ded, 0x1df3, 0x1e4c, 0x1e4d, 0x1e4e, 0x1e4f, 0x1e50, 0x1e51, 0x1e52, 0x1e53, 0x1ecc, 0x1ecd, 0x1ece, 0x1ecf, 0x1ed0, 0x1ed1, 0x1ed2, 0x1ed3, 0x1ed4, 0x1ed5, 0x1ed6, 0x1ed7, 0x1ed8, 0x1ed9, 0x1eda, 0x1edb, 0x1edc, 0x1edd, 0x1ede, 0x1edf, 0x1ee0, 0x1ee1, 0x1ee2, 0x1ee3, 0x2092, 0x2134, 0x24aa, 0x24c4, 0x24de, 0x3375, 0xa74e, 0xa74f, 0xa79c, 0xa79d, 0xa7f9, 0xff2f, 0xff4f, 0x1d40e, 0x1d428, 0x1d442, 0x1d45c, 0x1d476, 0x1d490, 0x1d4aa, 0x1d4de, 0x1d4f8, 0x1d512, 0x1d52c, 0x1d546, 0x1d560, 0x1d57a, 0x1d594, 0x1d5ae, 0x1d5c8, 0x1d5e2, 0x1d5fc, 0x1d616, 0x1d630, 0x1d64a, 0x1d664, 0x1d67e, 0x1d698, 0x1f11e, 0x1f13e, 0x1f15e, 0x1f17e, 0x1f197, } },
	{ 0x50, 59, { 0x70, 0x1d3e, 0x1d56, 0x1dee, 0x1e54, 0x1e55, 0x1e56, 0x1e57, 0x209a, 0x2119, 0x24ab, 0x24c5, 0x24df, 0x3250, 0x3376, 0x3380, 0x338a, 0x33a9, 0x33b0, 0x33b4, 0x33ba, 0x33d7, 0x33d8, 0x33d9, 0x33da, 0xff30, 0xff50, 0x1d40f, 0x1d429, 0x1d443, 0x1d45d, 0x1d477, 0x1d491, 0x1d4ab, 0x1d4c5, 0x1d4df, 0x1d4f9, 0x1d513, 0x1d52d, 0x1d561, 0x1d57b, 0x1d595, 0x1d5af, 0x1d5c9, 0x1d5e3, 0x1d5fd, 0x1d617, 0x1d631, 0x1d64b, 0x1d665, 0x1d67f, 0x1d699, 0x1f11f, 0x1f13f, 0x1f14e, 0x1f15f, 0x1f17f, 0x1f18a, 0x1f18c, } },
	{ 0x51, 37, { 0x71, 0x239, 0x211a, 0x24ac, 0x24c6, 0x24e0, 0xff31, 0xff51, 0x1d410, 0x1d42a, 0x1d444, 0x1d45e, 0x1d478, 0x1d492, 0x1d4ac, 0x1d4c6, 0x1d4e0, 0x1d4fa, 0x1d514, 0x1d52e, 0x1d562, 0x1d57c, 0x1d596, 0x1d5b0, 0x1d5ca, 0x1d5e4, 0x1d5fe, 0x1d618, 0x1d632, 0x1d64c, 0x1d666, 0x1d680, 0x1d69a, 0x1f120, 0x1f140, 0x1f160, 0x1f180, } },
	{ 0x52, 68, { 0x72, 0x154, 0x155, 0x156, 0x157, 0x158, 0x159, 0x210, 0x211, 0x212, 0x213, 0x2b3, 0x36c, 0x1d3f, 0x1d63, 0x1dca, 0x1e58, 0x1e59, 0x1e5a, 0x1e5b, 0x1e5c, 0x1e5d, 0x1e5e, 0x1e5f, 0x20a8, 0x211b, 0x211c, 0x211d, 0x24ad, 0x24c7, 0x24e1, 0x33ad, 0x33ae, 0x33af, 0xa782, 0xa783, 0xa7a6, 0xa7a7, 0xff32, 0xff52, 0x1d411, 0x1d42b, 0x1d445, 0x1d45f, 0x1d479, 0x1d493, 0x1d4c7, 0x1d4e1, 0x1d4fb, 0x1d52f, 0x1d563, 0x1d57d, 0x1d597, 0x1d5b1, 0x1d5cb, 0x1d5e5, 0x1d5ff, 0x1d619, 0x1d633, 0x1d64d, 0x1d667, 0x1d681, 0x1d69b, 0x1f121, 0x1f12c, 0x1f141, 0x1f161, 0x1f181, } },
	{ 0x53, 79, { 0x73, 0xdf, 0x15a, 0x15b, 0x15c, 0x15d, 0x15e, 0x15f, 0x160, 0x161, 0x17f, 0x218, 0x219, 0x2e2, 0x1de4, 0x1de5, 0x1e60, 0x1e61, 0x1e62, 0x1e63, 0x1e64, 0x1e65, 0x1e66, 0x1e67, 0x1e68, 0x1e69, 0x1e9b, 0x1e9e, 0x209b, 0x2120, 0x24ae, 0x24c8, 0x24e2, 0x33db, 0x33dc, 0xa784, 0xa785, 0xa7a8, 0xa7a9, 0xfb05, 0xfb06, 0xff33, 0xff53, 0x1d412, 0x1d42c, 0x1d446, 0x1d460, 0x1d47a, 0x1d494, 0x1d4ae, 0x1d4c8, 0x1d4e2, 0x1d4fc, 0x1d516, 0x1d530, 0x1d54a, 0x1d564, 0x1d57e, 0x1d598, 0x1d5b2, 0x1d5cc, 0x1d5e6, 0x1d600, 0x1d61a, 0x1d634, 0x1d64e, 0x1d668, 0x1d682, 0x1d69c, 0x1f122, 0x1f12a, 0x1f142, 0x1f14c, 0x1f14d, 0x1f162, 0x1f182, 0x1f18d, 0x1f198, 0x1f1aa, } },
	{ 0x54, 67, { 0x74, 0x162, 0x163, 0x164, 0x165, 0x1be, 0x21a, 0x21b, 0x2a6, 0x2a7, 0x2a8, 0x36d, 0x1d40, 0x1d57, 0x1d7a, 0x1e6a, 0x1e6b, 0x1e6c, 0x1e6d, 0x1e6e, 0x1e6f, 0x1e70, 0x1e71, 0x1e97, 0x209c, 0x2121, 0x2122, 0x24af, 0x24c9, 0x24e3, 0x3394, 0xa728, 0xa729, 0xa786, 0xa787, 0xff34, 0xff54, 0x1d413, 0x1d42d, 0x1d447, 0x1d461, 0x1d47b, 0x1d495, 0x1d4af, 0x1d4c9, 0x1d4e3, 0x1d4fd, 0x1d517, 0x1d531, 0x1d54b, 0x1d565, 0x1d57f, 0x1d599, 0x1d5b3, 0x1d5cd, 0x1d5e7, 0x1d601, 0x1d61b, 0x1d635, 0x1d64f, 0x1d669, 0x1d683, 0x1d69d, 0x1f123, 0x1f143, 0x1f163, 0x1f183, } },
	{ 0x55, 106, { 0x75, 0xd9, 0xda, 0xdb, 0xdc, 0xf9, 0xfa, 0xfb, 0xfc, 0x168, 0x169, 0x16a, 0x16b, 0x16c, 0x16d, 0x16e, 0x16f, 0x170, 0x171, 0x172, 0x173, 0x1af, 0x1b0, 0x1d3, 0x1d4, 0x1d5, 0x1d6, 0x1d7, 0x1d8, 0x1d9, 0x1da, 0x1db, 0x1dc, 0x214, 0x215, 0x216, 0x217, 0x367, 0x1d41, 0x1d58, 0x1d64, 0x1df0, 0x1df4, 0x1e72, 0x1e73, 0x1e74, 0x1e75, 0x1e76, 0x1e77, 0x1e78, 0x1e79, 0x1e7a, 0x1e7b, 0x1ee4, 0x1ee5, 0x1ee6, 0x1ee7, 0x1ee8, 0x1ee9, 0x1eea, 0x1eeb, 0x1eec, 0x1eed, 0x1eee, 0x1eef, 0x1ef0, 0x1ef1, 0x24b0, 0x24ca, 0x24e4, 0xa79e, 0xa79f, 0xff35, 0xff55, 0x1d414, 0x1d42e, 0x1d448, 0x1d462, 0x1d47c, 0x1d496, 0x1d4b0, 0x1d4ca, 0x1d4e4, 0x1d4fe, 0x1d518, 0x1d532, 0x1d54c, 0x1d566, 0x1d580, 0x1d59a, 0x1d5b4, 0x1d5ce, 0x1d5e8, 0x1d602, 0x1d61c, 0x1d636, 0x1d650, 0x1d66a, 0x1d684, 0x1d69e, 0x1f124, 0x1f144, 0x1f164, 0x1f184, 0x1f199, 0x1f1ab, } },
	{ 0x56, 57, { 0x76, 0x36e, 0x1d5b, 0x1d65, 0x1e7c, 0x1e7d, 0x1e7e, 0x1e7f, 0x2164, 0x2165, 0x2166, 0x2167, 0x2174, 0x2175, 0x2176, 0x2177, 0x24b1, 0x24cb, 0x24e5, 0x2c7d, 0x33de, 0xa760, 0xa761, 0xff36, 0xff56, 0x1d415, 0x1d42f, 0x1d449, 0x1d463, 0x1d47d, 0x1d497, 0x1d4b1, 0x1d4cb, 0x1d4e5, 0x1d4ff, 0x1d519, 0x1d533, 0x1d54d, 0x1d567, 0x1d581, 0x1d59b, 0x1d5b5, 0x1d5cf, 0x1d5e9, 0x1d603, 0x1d61d, 0x1d637, 0x1d651, 0x1d66b, 0x1d685, 0x1d69f, 0x1f125, 0x1f145, 0x1f165, 0x1f185, 0x1f19a, 0x1f1ac, } },
	{ 0x57, 56, { 0x77, 0x174, 0x175, 0x2b7, 0x1d42, 0x1df1, 0x1e80, 0x1e81, 0x1e82, 0x1e83, 0x1e84, 0x1e85, 0x1e86, 0x1e87, 0x1e88, 0x1e89, 0x1e98, 0x24b2, 0x24cc, 0x24e6, 0x33dd, 0xff37, 0xff57, 0x1d416, 0x1d430, 0x1d44a, 0x1d464, 0x1d47e, 0x1d498, 0x1d4b2, 0x1d4cc, 0x1d4e6, 0x1d500, 0x1d51a, 0x1d534, 0x1d54e, 0x1d568, 0x1d582, 0x1d59c, 0x1d5b6, 0x1d5d0, 0x1d5ea, 0x1d604, 0x1d61e, 0x1d638, 0x1d652, 0x1d66c, 0x1d686, 0x1d6a0, 0x1f126, 0x1f12e, 0x1f146, 0x1f14f, 0x1f166, 0x1f186, 0x1f18f, } },
	{ 0x58, 49, { 0x78, 0x2e3, 0x36f, 0x1e8a, 0x1e8b, 0x1e8c, 0x1e8d, 0x2093, 0x2169, 0x216a, 0x216b, 0x2179, 0x217a, 0x217b, 0x24b3, 0x24cd, 0x24e7, 0xff38, 0xff58, 0x1d417, 0x1d431, 0x1d44b, 0x1d465, 0x1d47f, 0x1d499, 0x1d4b3, 0x1d4cd, 0x1d4e7, 0x1d501, 0x1d51b, 0x1d535, 0x1d54f, 0x1d569, 0x1d583, 0x1d59d, 0x1d5b7, 0x1d5d1, 0x1d5eb, 0x1d605, 0x1d61f, 0x1d639, 0x1d653, 0x1d66d, 0x1d687, 0x1d6a1, 0x1f127, 0x1f147, 0x1f167, 0x1f187, } },
	{ 0x59, 56, { 0x79, 0xdd, 0xfd, 0xff, 0x176, 0x177, 0x178, 0x232, 0x233, 0x2b8, 0x1e8e, 0x1e8f, 0x1e99, 0x1ef2, 0x1ef3, 0x1ef4, 0x1ef5, 0x1ef6, 0x1ef7, 0x1ef8, 0x1ef9, 0x24b4, 0x24ce, 0x24e8, 0xff39, 0xff59, 0x1d418, 0x1d432, 0x1d44c, 0x1d466, 0x1d480, 0x1d49a, 0x1d4b4, 0x1d4ce, 0x1d4e8, 0x1d502, 0x1d51c, 0x1d536, 0x1d550, 0x1d56a, 0x1d584, 0x1d59e, 0x1d5b8, 0x1d5d2, 0x1d5ec, 0x1d606, 0x1d620, 0x1d63a, 0x1d654, 0x1d66e, 0x1d688, 0x1d6a2, 0x1f128, 0x1f148, 0x1f168, 0x1f188, } },
	{ 0x5a, 51, { 0x7a, 0x179, 0x17a, 0x17b, 0x17c, 0x17d, 0x17e, 0x18d, 0x1dbb, 0x1de6, 0x1e90, 0x1e91, 0x1e92, 0x1e93, 0x1e94, 0x1e95, 0x2124, 0x2128, 0x24b5, 0x24cf, 0x24e9, 0xff3a, 0xff5a, 0x1d419, 0x1d433, 0x1d44d, 0x1d467, 0x1d481, 0x1d49b, 0x1d4b5, 0x1d4cf, 0x1d4e9, 0x1d503, 0x1d537, 0x1d56b, 0x1d585, 0x1d59f, 0x1d5b9, 0x1d5d3, 0x1d5ed, 0x1d607, 0x1d621, 0x1d63b, 0x1d655, 0x1d66f, 0x1d689, 0x1d6a3, 0x1f129, 0x1f149, 0x1f169, 0x1f189, } },
	{ 0xb5, 20, { 0x39c, 0x3bc, 0x3382, 0x338c, 0x338d, 0x3395, 0x339b, 0x33b2, 0x33b6, 0x33bc, 0x1d6b3, 0x1d6cd, 0x1d6ed, 0x1d707, 0x1d727, 0x1d741, 0x1d761, 0x1d77b, 0x1d79b, 0x1d7b5, } },
	{ 0x14a, 2, { 0x14b, 0x1d51, } },
	{ 0x186, 2, { 0x254, 0x1d53, } },
	{ 0x18e, 2, { 0x1dd, 0x1d32, } },
	{ 0x18f, 4, { 0x259, 0x1d4a, 0x1dea, 0x2094, } },
	{ 0x190, 3, { 0x25b, 0x1d4b, 0x2107, } },
	{ 0x194, 2, { 0x263, 0x2e0, } },
	{ 0x196, 2, { 0x269, 0x1da5, } },
	{ 0x197, 2, { 0x268, 0x1da4, } },
	{ 0x19c, 2, { 0x26f, 0x1d5a, } },
	{ 0x19d, 2, { 0x272, 0x1dae, } },
	{ 0x19f, 2, { 0x275, 0x1db1, } },
	{ 0x1a6, 2, { 0x280, 0x1de2, } },
	{ 0x1a9, 3, { 0x283, 0x1db4, 0x1def, } },
	{ 0x1b1, 2, { 0x28a, 0x1db7, } },
	{ 0x1b2, 2, { 0x28b, 0x1db9, } },
	{ 0x1b7, 4, { 0x1ee, 0x1ef, 0x292, 0x1dbe, } },
	{ 0x222, 2, { 0x223, 0x1d3d, } },
	{ 0x244, 2, { 0x289, 0x1db6, } },
	{ 0x245, 2, { 0x28c, 0x1dba, } },
	{ 0x250, 2, { 0x1d44, 0x2c6f, } },
	{ 0x251, 3, { 0x1d45, 0x1de7, 0x2c6d, } },
	{ 0x252, 2, { 0x1d9b, 0x2c70, } },
	{ 0x25c, 2, { 0x1d9f, 0xa7ab, } },
	{ 0x261, 2, { 0x1da2, 0xa7ac, } },
	{ 0x265, 2, { 0x1da3, 0xa78d, } },
	{ 0x266, 2, { 0x2b1, 0xa7aa, } },
	{ 0x26a, 2, { 0x1da6, 0xa7ae, } },
	{ 0x26b, 2, { 0x2c62, 0xab5e, } },
	{ 0x271, 2, { 0x1dac, 0x2c6e, } },
	{ 0x274, 2, { 0x1db0, 0x1de1, } },
	{ 0x29d, 2, { 0x1da8, 0xa7b2, } },
	{ 0x29f, 2, { 0x1dab, 0x1dde, } },
	{ 0x37a, 46, { 0x38a, 0x390, 0x399, 0x3aa, 0x3af, 0x3b9, 0x3ca, 0x1f30, 0x1f31, 0x1f32, 0x1f33, 0x1f34, 0x1f35, 0x1f36, 0x1f37, 0x1f38, 0x1f39, 0x1f3a, 0x1f3b, 0x1f3c, 0x1f3d, 0x1f3e, 0x1f3f, 0x1f76, 0x1f77, 0x1fbe, 0x1fd0, 0x1fd1, 0x1fd2, 0x1fd3, 0x1fd6, 0x1fd7, 0x1fd8, 0x1fd9, 0x1fda, 0x1fdb, 0x1d6b0, 0x1d6ca, 0x1d6ea, 0x1d704, 0x1d724, 0x1d73e, 0x1d75e, 0x1d778, 0x1d798, 0x1d7b2, } },
	{ 0x386, 59, { 0x391, 0x3ac, 0x3b1, 0x1f00, 0x1f01, 0x1f02, 0x1f03, 0x1f04, 0x1f05, 0x1f06, 0x1f07, 0x1f08, 0x1f09, 0x1f0a, 0x1f0b, 0x1f0c, 0x1f0d, 0x1f0e, 0x1f0f, 0x1f70, 0x1f71, 0x1f80, 0x1f81, 0x1f82, 0x1f83, 0x1f84, 0x1f85, 0x1f86, 0x1f87, 0x1f88, 0x1f89, 0x1f8a, 0x1f8b, 0x1f8c, 0x1f8d, 0x1f8e, 0x1f8f, 0x1fb0, 0x1fb1, 0x1fb2, 0x1fb3, 0x1fb4, 0x1fb6, 0x1fb7, 0x1fb8, 0x1fb9, 0x1fba, 0x1fbb, 0x1fbc, 0x1d6a8, 0x1d6c2, 0x1d6e2, 0x1d6fc, 0x1d71c, 0x1d736, 0x1d756, 0x1d770, 0x1d790, 0x1d7aa, } },
	{ 0x388, 35, { 0x395, 0x3ad, 0x3b5, 0x3f5, 0x1f10, 0x1f11, 0x1f12, 0x1f13, 0x1f14, 0x1f15, 0x1f18, 0x1f19, 0x1f1a, 0x1f1b, 0x1f1c, 0x1f1d, 0x1f72, 0x1f73, 0x1fc8, 0x1fc9, 0x1d6ac, 0x1d6c6, 0x1d6dc, 0x1d6e6, 0x1d700, 0x1d716, 0x1d720, 0x1d73a, 0x1d750, 0x1d75a, 0x1d774, 0x1d78a, 0x1d794, 0x1d7ae, 0x1d7c4, } },
	{ 0x389, 55, { 0x397, 0x3ae, 0x3b7, 0x1f20, 0x1f21, 0x1f22, 0x1f23, 0x1f24, 0x1f25, 0x1f26, 0x1f27, 0x1f28, 0x1f29, 0x1f2a, 0x1f2b, 0x1f2c, 0x1f2d, 0x1f2e, 0x1f2f, 0x1f74, 0x1f75, 0x1f90, 0x1f91, 0x1f92, 0x1f93, 0x1f94, 0x1f95, 0x1f96, 0x1f97, 0x1f98, 0x1f99, 0x1f9a, 0x1f9b, 0x1f9c, 0x1f9d, 0x1f9e, 0x1f9f, 0x1fc2, 0x1fc3, 0x1fc4, 0x1fc6, 0x1fc7, 0x1fca, 0x1fcb, 0x1fcc, 0x1d6ae, 0x1d6c8, 0x1d6e8, 0x1d702, 0x1d722, 0x1d73c, 0x1d75c, 0x1d776, 0x1d796, 0x1d7b0, } },
	{ 0x38c, 29, { 0x39f, 0x3bf, 0x3cc, 0x1f40, 0x1f41, 0x1f42, 0x1f43, 0x1f44, 0x1f45, 0x1f48, 0x1f49, 0x1f4a, 0x1f4b, 0x1f4c, 0x1f4d, 0x1f78, 0x1f79, 0x1ff8, 0x1ff9, 0x1d6b6, 0x1d6d0, 0x1d6f0, 0x1d70a, 0x1d72a, 0x1d744, 0x1d764, 0x1d77e, 0x1d79e, 0x1d7b8, } },
	{ 0x38e, 43, { 0x3a5, 0x3ab, 0x3b0, 0x3c5, 0x3cb, 0x3cd, 0x3d2, 0x3d3, 0x3d4, 0x1f50, 0x1f51, 0x1f52, 0x1f53, 0x1f54, 0x1f55, 0x1f56, 0x1f57, 0x1f59, 0x1f5b, 0x1f5d, 0x1f5f, 0x1f7a, 0x1f7b, 0x1fe0, 0x1fe1, 0x1fe2, 0x1fe3, 0x1fe6, 0x1fe7, 0x1fe8, 0x1fe9, 0x1fea, 0x1feb, 0x1d6bc, 0x1d6d6, 0x1d6f6, 0x1d710, 0x1d730, 0x1d74a, 0x1d76a, 0x1d784, 0x1d7a4, 0x1d7be, } },
	{ 0x38f, 56, { 0x3a9, 0x3c9, 0x3ce, 0x1f60, 0x1f61, 0x1f62, 0x1f63, 0x1f64, 0x1f65, 0x1f66, 0x1f67, 0x1f68, 0x1f69, 0x1f6a, 0x1f6b, 0x1f6c, 0x1f6d, 0x1f6e, 0x1f6f, 0x1f7c, 0x1f7d, 0x1fa0, 0x1fa1, 0x1fa2, 0x1fa3, 0x1fa4, 0x1fa5, 0x1fa6, 0x1fa7, 0x1fa8, 0x1fa9, 0x1faa, 0x1fab, 0x1fac, 0x1fad, 0x1fae, 0x1faf, 0x1ff2, 0x1ff3, 0x1ff4, 0x1ff6, 0x1ff7, 0x1ffa, 0x1ffb, 0x1ffc, 0x2126, 0x1d6c0, 0x1d6da, 0x1d6fa, 0x1d714, 0x1d734, 0x1d74e, 0x1d76e, 0x1d788, 0x1d7a8, 0x1d7c2, } },
	{ 0x392, 14, { 0x3b2, 0x3d0, 0x1d5d, 0x1d66, 0x1d6a9, 0x1d6c3, 0x1d6e3, 0x1d6fd, 0x1d71d, 0x1d737, 0x1d757, 0x1d771, 0x1d791, 0x1d7ab, } },
	{ 0x393, 15, { 0x3b3, 0x1d5e, 0x1d67, 0x213d, 0x213e, 0x1d6aa, 0x1d6c4, 0x1d6e4, 0x1d6fe, 0x1d71e, 0x1d738, 0x1d758, 0x1d772, 0x1d792, 0x1d7ac, } },
	{ 0x394, 12, { 0x3b4, 0x1d5f, 0x1d6ab, 0x1d6c5, 0x1d6e5, 0x1d6ff, 0x1d71f, 0x1d739, 0x1d759, 0x1d773, 0x1d793, 0x1d7ad, } },
	{ 0x396, 11, { 0x3b6, 0x1d6ad, 0x1d6c7, 0x1d6e7, 0x1d701, 0x1d721, 0x1d73b, 0x1d75b, 0x1d775, 0x1d795, 0x1d7af, } },
	{ 0x398, 24, { 0x3b8, 0x3d1, 0x3f4, 0x1dbf, 0x1d6af, 0x1d6b9, 0x1d6c9, 0x1d6dd, 0x1d6e9, 0x1d6f3, 0x1d703, 0x1d717, 0x1d723, 0x1d72d, 0x1d73d, 0x1d751, 0x1d75d, 0x1d767, 0x1d777, 0x1d78b, 0x1d797, 0x1d7a1, 0x1d7b1, 0x1d7c5, } },
	{ 0x39a, 19, { 0x3ba, 0x3cf, 0x3d7, 0x3f0, 0x1d6b1, 0x1d6cb, 0x1d6de, 0x1d6eb, 0x1d705, 0x1d718, 0x1d725, 0x1d73f, 0x1d752, 0x1d75f, 0x1d779, 0x1d78c, 0x1d799, 0x1d7b3, 0x1d7c6, } },
	{ 0x39b, 11, { 0x3bb, 0x1d6b2, 0x1d6cc, 0x1d6ec, 0x1d706, 0x1d726, 0x1d740, 0x1d760, 0x1d77a, 0x1d79a, 0x1d7b4, } },
	{ 0x39d, 11, { 0x3bd, 0x1d6b4, 0x1d6ce, 0x1d6ee, 0x1d708, 0x1d728, 0x1d742, 0x1d762, 0x1d77c, 0x1d79c, 0x1d7b6, } },
	{ 0x39e, 11, { 0x3be, 0x1d6b5, 0x1d6cf, 0x1d6ef, 0x1d709, 0x1d729, 0x1d743, 0x1d763, 0x1d77d, 0x1d79d, 0x1d7b7, } },
	{ 0x3a0, 19, { 0x3c0, 0x3d6, 0x213c, 0x213f, 0x1d6b7, 0x1d6d1, 0x1d6e1, 0x1d6f1, 0x1d70b, 0x1d71b, 0x1d72b, 0x1d745, 0x1d755, 0x1d765, 0x1d77f, 0x1d78f, 0x1d79f, 0x1d7b9, 0x1d7c9, } },
	{ 0x3a1, 21, { 0x3c1, 0x3f1, 0x1d68, 0x1fe4, 0x1fe5, 0x1fec, 0x1d6b8, 0x1d6d2, 0x1d6e0, 0x1d6f2, 0x1d70c, 0x1d71a, 0x1d72c, 0x1d746, 0x1d754, 0x1d766, 0x1d780, 0x1d78e, 0x1d7a0, 0x1d7ba, 0x1d7c8, } },
	{ 0x3a3, 19, { 0x3c2, 0x3c3, 0x3f2, 0x3f9, 0x1d6ba, 0x1d6d3, 0x1d6d4, 0x1d6f4, 0x1d70d, 0x1d70e, 0x1d72e, 0x1d747, 0x1d748, 0x1d768, 0x1d781, 0x1d782, 0x1d7a2, 0x1d7bb, 0x1d7bc, } },
	{ 0x3a4, 11, { 0x3c4, 0x1d6bb, 0x1d6d5, 0x1d6f5, 0x1d70f, 0x1d72f, 0x1d749, 0x1d769, 0x1d783, 0x1d7a3, 0x1d7bd, } },
	{ 0x3a6, 19, { 0x3c6, 0x3d5, 0x1d60, 0x1d69, 0x1d6bd, 0x1d6d7, 0x1d6df, 0x1d6f7, 0x1d711, 0x1d719, 0x1d731, 0x1d74b, 0x1d753, 0x1d76b, 0x1d785, 0x1d78d, 0x1d7a5, 0x1d7bf, 0x1d7c7, } },
	{ 0x3a7, 13, { 0x3c7, 0x1d61, 0x1d6a, 0x1d6be, 0x1d6d8, 0x1d6f8, 0x1d712, 0x1d732, 0x1d74c, 0x1d76c, 0x1d786, 0x1d7a6, 0x1d7c0, } },
	{ 0x3a8, 11, { 0x3c8, 0x1d6bf, 0x1d6d9, 0x1d6f9, 0x1d713, 0x1d733, 0x1d74d, 0x1d76d, 0x1d787, 0x1d7a7, 0x1d7c1, } },
	{ 0x3dc, 3, { 0x3dd, 0x1d7ca, 0x1d7cb, } },
	{ 0x400, 8, { 0x401, 0x415, 0x435, 0x450, 0x451, 0x4d6, 0x4d7, 0x2df7, } },
	{ 0x403, 6, { 0x413, 0x433, 0x453, 0x490, 0x491, 0x2de2, } },
	{ 0x404, 2, { 0x454, 0xa674, } },
	{ 0x406, 4, { 0x407, 0x456, 0x457, 0xa676, } },
	{ 0x40c, 4, { 0x41a, 0x43a, 0x45c, 0x2de6, } },
	{ 0x40d, 8, { 0x418, 0x438, 0x45d, 0x4e2, 0x4e3, 0x4e4, 0x4e5, 0xa675, } },
	{ 0x40e, 10, { 0x423, 0x443, 0x45e, 0x4ee, 0x4ef, 0x4f0, 0x4f1, 0x4f2, 0x4f3, 0xa677, } },
	{ 0x410, 6, { 0x430, 0x4d0, 0x4d1, 0x4d2, 0x4d3, 0x2df6, } },
	{ 0x411, 2, { 0x431, 0x2de0, } },
	{ 0x412, 3, { 0x432, 0x1c80, 0x2de1, } },
	{ 0x414, 3, { 0x434, 0x1c81, 0x2de3, } },
	{ 0x416, 6, { 0x436, 0x4c1, 0x4c2, 0x4dc, 0x4dd, 0x2de4, } },
	{ 0x417, 4, { 0x437, 0x4de, 0x4df, 0x2de5, } },
	{ 0x41b, 2, { 0x43b, 0x2de7, } },
	{ 0x41c, 2, { 0x43c, 0x2de8, } },
	{ 0x41d, 3, { 0x43d, 0x1d78, 0x2de9, } },
	{ 0x41e, 16, { 0x43e, 0x4e6, 0x4e7, 0x1c82, 0x2dea, 0xa668, 0xa669, 0xa66a, 0xa66b, 0xa66c, 0xa66d, 0xa66e, 0xa698, 0xa699, 0xa69a, 0xa69b, } },
	{ 0x41f, 2, { 0x43f, 0x2deb, } },
	{ 0x420, 2, { 0x440, 0x2dec, } },
	{ 0x421, 4, { 0x441, 0x1c83, 0x2ded, 0x2df5, } },
	{ 0x422, 4, { 0x442, 0x1c84, 0x1c85, 0x2dee, } },
	{ 0x424, 2, { 0x444, 0xa69e, } },
	{ 0x425, 2, { 0x445, 0x2def, } },
	{ 0x426, 2, { 0x446, 0x2df0, } },
	{ 0x427, 4, { 0x447, 0x4f4, 0x4f5, 0x2df1, } },
	{ 0x428, 2, { 0x448, 0x2df2, } },
	{ 0x429, 2, { 0x449, 0x2df3, } },
	{ 0x42a, 4, { 0x44a, 0x1c86, 0xa678, 0xa69c, } },
	{ 0x42b, 4, { 0x44b, 0x4f8, 0x4f9, 0xa679, } },
	{ 0x42c, 3, { 0x44c, 0xa67a, 0xa69d, } },
	{ 0x42d, 3, { 0x44d, 0x4ec, 0x4ed, } },
	{ 0x42e, 2, { 0x44e, 0x2dfb, } },
	{ 0x460, 2, { 0x461, 0xa67b, } },
	{ 0x462, 3, { 0x463, 0x1c87, 0x2dfa, } },
	{ 0x464, 2, { 0x465, 0xa69f, } },
	{ 0x466, 2, { 0x467, 0x2dfd, } },
	{ 0x46a, 2, { 0x46b, 0x2dfe, } },
	{ 0x46c, 2, { 0x46d, 0x2dff, } },
	{ 0x472, 2, { 0x473, 0x2df4, } },
	{ 0x474, 3, { 0x475, 0x476, 0x477, } },
	{ 0x4d8, 3, { 0x4d9, 0x4da, 0x4db, } },
	{ 0x4e8, 3, { 0x4e9, 0x4ea, 0x4eb, } },
	{ 0x535, 2, { 0x565, 0x587, } },
	{ 0x544, 5, { 0x574, 0xfb13, 0xfb14, 0xfb15, 0xfb17, } },
	{ 0x54e, 2, { 0x57e, 0xfb16, } },
	{ 0x5d0, 6, { 0x2135, 0xfb21, 0xfb2e, 0xfb2f, 0xfb30, 0xfb4f, } },
	{ 0x5d1, 3, { 0x2136, 0xfb31, 0xfb4c, } },
	{ 0x5d2, 2, { 0x2137, 0xfb32, } },
	{ 0x5d3, 3, { 0x2138, 0xfb22, 0xfb33, } },
	{ 0x5d4, 2, { 0xfb23, 0xfb34, } },
	{ 0x5d5, 4, { 0x5f0, 0x5f1, 0xfb35, 0xfb4b, } },
	{ 0x5d9, 4, { 0x5f2, 0xfb1d, 0xfb1f, 0xfb39, } },
	{ 0x5da, 5, { 0x5db, 0xfb24, 0xfb3a, 0xfb3b, 0xfb4d, } },
	{ 0x5dc, 2, { 0xfb25, 0xfb3c, } },
	{ 0x5dd, 3, { 0x5de, 0xfb26, 0xfb3e, } },
	{ 0x5df, 2, { 0x5e0, 0xfb40, } },
	{ 0x5e3, 4, { 0x5e4, 0xfb43, 0xfb44, 0xfb4e, } },
	{ 0x5e5, 2, { 0x5e6, 0xfb46, } },
	{ 0x5e8, 2, { 0xfb27, 0xfb48, } },
	{ 0x5e9, 5, { 0xfb2a, 0xfb2b, 0xfb2c, 0xfb2d, 0xfb49, } },
	{ 0x5ea, 2, { 0xfb28, 0xfb4a, } },
	{ 0x621, 3, { 0x674, 0x6fd, 0xfe80, } },
	{ 0x622, 2, { 0xfe81, 0xfe82, } },
	{ 0x623, 2, { 0xfe83, 0xfe84, } },
	{ 0x624, 2, { 0xfe85, 0xfe86, } },
	{ 0x625, 2, { 0xfe87, 0xfe88, } },
	{ 0x626, 40, { 0xfbea, 0xfbeb, 0xfbec, 0xfbed, 0xfbee, 0xfbef, 0xfbf0, 0xfbf1, 0xfbf2, 0xfbf3, 0xfbf4, 0xfbf5, 0xfbf6, 0xfbf7, 0xfbf8, 0xfbf9, 0xfbfa, 0xfbfb, 0xfc00, 0xfc01, 0xfc02, 0xfc03, 0xfc04, 0xfc64, 0xfc65, 0xfc66, 0xfc67, 0xfc68, 0xfc69, 0xfc97, 0xfc98, 0xfc99, 0xfc9a, 0xfc9b, 0xfcdf, 0xfce0, 0xfe89, 0xfe8a, 0xfe8b, 0xfe8c, } },
	{ 0x627, 10, { 0x675, 0x8ad, 0xfd3c, 0xfd3d, 0xfdf2, 0xfdf3, 0xfe8d, 0xfe8e, 0x1ee00, 0x1ee80, } },
	{ 0x628, 30, { 0xfc05, 0xfc06, 0xfc07, 0xfc08, 0xfc09, 0xfc0a, 0xfc6a, 0xfc6b, 0xfc6c, 0xfc6d, 0xfc6e, 0xfc6f, 0xfc9c, 0xfc9d, 0xfc9e, 0xfc9f, 0xfca0, 0xfce1, 0xfce2, 0xfd9e, 0xfdc2, 0xfe8f, 0xfe90, 0xfe91, 0xfe92, 0x1ee01, 0x1ee21, 0x1ee61, 0x1ee81, 0x1eea1, } },
	{ 0x629, 2, { 0xfe93, 0xfe94, } },
	{ 0x62a, 42, { 0xfc0b, 0xfc0c, 0xfc0d, 0xfc0e, 0xfc0f, 0xfc10, 0xfc70, 0xfc71, 0xfc72, 0xfc73, 0xfc74, 0xfc75, 0xfca1, 0xfca2, 0xfca3, 0xfca4, 0xfca5, 0xfce3, 0xfce4, 0xfd50, 0xfd51, 0xfd52, 0xfd53, 0xfd54, 0xfd55, 0xfd56, 0xfd57, 0xfd9f, 0xfda0, 0xfda1, 0xfda2, 0xfda3, 0xfda4, 0xfe95, 0xfe96, 0xfe97, 0xfe98, 0x1ee15, 0x1ee35, 0x1ee75, 0x1ee95, 0x1eeb5, } },
	{ 0x62b, 22, { 0xfc11, 0xfc12, 0xfc13, 0xfc14, 0xfc76, 0xfc77, 0xfc78, 0xfc79, 0xfc7a, 0xfc7b, 0xfca6, 0xfce5, 0xfce6, 0xfe99, 0xfe9a, 0xfe9b, 0xfe9c, 0x1ee16, 0x1ee36, 0x1ee76, 0x1ee96, 0x1eeb6, } },
	{ 0x62c, 25, { 0xfc15, 0xfc16, 0xfca7, 0xfca8, 0xfd01, 0xfd02, 0xfd1d, 0xfd1e, 0xfd58, 0xfd59, 0xfda5, 0xfda6, 0xfda7, 0xfdbe, 0xfdfb, 0xfe9d, 0xfe9e, 0xfe9f, 0xfea0, 0x1ee02, 0x1ee22, 0x1ee42, 0x1ee62, 0x1ee82, 0x1eea2, } },
	{ 0x62d, 21, { 0xfc17, 0xfc18, 0xfca9, 0xfcaa, 0xfcff, 0xfd00, 0xfd1b, 0xfd1c, 0xfd5a, 0xfd5b, 0xfdbf, 0xfea1, 0xfea2, 0xfea3, 0xfea4, 0x1ee07, 0x1ee27, 0x1ee47, 0x1ee67, 0x1ee87, 0x1eea7, } },
	{ 0x62e, 19, { 0xfc19, 0xfc1a, 0xfc1b, 0xfcab, 0xfcac, 0xfd03, 0xfd04, 0xfd1f, 0xfd20, 0xfea5, 0xfea6, 0xfea7, 0xfea8, 0x1ee17, 0x1ee37, 0x1ee57, 0x1ee77, 0x1ee97, 0x1eeb7, } },
	{ 0x62f, 5, { 0xfea9, 0xfeaa, 0x1ee03, 0x1ee83, 0x1eea3, } },
	{ 0x630, 6, { 0xfc5b, 0xfeab, 0xfeac, 0x1ee18, 0x1ee98, 0x1eeb8, } },
	{ 0x631, 8, { 0xfc5c, 0xfdf6, 0xfdfc, 0xfead, 0xfeae, 0x1ee13, 0x1ee93, 0x1eeb3, } },
	{ 0x632, 5, { 0xfeaf, 0xfeb0, 0x1ee06, 0x1ee86, 0x1eea6, } },
	{ 0x633, 40, { 0xfc1c, 0xfc1d, 0xfc1e, 0xfc1f, 0xfcad, 0xfcae, 0xfcaf, 0xfcb0, 0xfce7, 0xfce8, 0xfcfb, 0xfcfc, 0xfd0e, 0xfd17, 0xfd18, 0xfd2a, 0xfd31, 0xfd34, 0xfd35, 0xfd36, 0xfd5c, 0xfd5d, 0xfd5e, 0xfd5f, 0xfd60, 0xfd61, 0xfd62, 0xfd63, 0xfda8, 0xfdc6, 0xfeb1, 0xfeb2, 0xfeb3, 0xfeb4, 0x1ee0e, 0x1ee2e, 0x1ee4e, 0x1ee6e, 0x1ee8e, 0x1eeae, } },
	{ 0x634, 42, { 0xfce9, 0xfcea, 0xfcfd, 0xfcfe, 0xfd09, 0xfd0a, 0xfd0b, 0xfd0c, 0xfd0d, 0xfd19, 0xfd1a, 0xfd25, 0xfd26, 0xfd27, 0xfd28, 0xfd29, 0xfd2d, 0xfd2e, 0xfd2f, 0xfd30, 0xfd32, 0xfd37, 0xfd38, 0xfd39, 0xfd67, 0xfd68, 0xfd69, 0xfd6a, 0xfd6b, 0xfd6c, 0xfd6d, 0xfdaa, 0xfeb5, 0xfeb6, 0xfeb7, 0xfeb8, 0x1ee14, 0x1ee34, 0x1ee54, 0x1ee74, 0x1ee94, 0x1eeb4, } },
	{ 0x635, 30, { 0xfc20, 0xfc21, 0xfcb1, 0xfcb2, 0xfcb3, 0xfd05, 0xfd06, 0xfd0f, 0xfd21, 0xfd22, 0xfd2b, 0xfd64, 0xfd65, 0xfd66, 0xfda9, 0xfdc5, 0xfdf0, 0xfdf5, 0xfdf9, 0xfdfa, 0xfeb9, 0xfeba, 0xfebb, 0xfebc, 0x1ee11, 0x1ee31, 0x1ee51, 0x1ee71, 0x1ee91, 0x1eeb1, } },
	{ 0x636, 28, { 0xfc22, 0xfc23, 0xfc24, 0xfc25, 0xfcb4, 0xfcb5, 0xfcb6, 0xfcb7, 0xfd07, 0xfd08, 0xfd10, 0xfd23, 0xfd24, 0xfd2c, 0xfd6e, 0xfd6f, 0xfd70, 0xfdab, 0xfebd, 0xfebe, 0xfebf, 0xfec0, 0x1ee19, 0x1ee39, 0x1ee59, 0x1ee79, 0x1ee99, 0x1eeb9, } },
	{ 0x637, 21, { 0xfc26, 0xfc27, 0xfcb8, 0xfcf5, 0xfcf6, 0xfd11, 0xfd12, 0xfd33, 0xfd3a, 0xfd71, 0xfd72, 0xfd73, 0xfd74, 0xfec1, 0xfec2, 0xfec3, 0xfec4, 0x1ee08, 0x1ee68, 0x1ee88, 0x1eea8, } },
	{ 0x638, 11, { 0xfc28, 0xfcb9, 0xfd3b, 0xfec5, 0xfec6, 0xfec7, 0xfec8, 0x1ee1a, 0x1ee7a, 0x1ee9a, 0x1eeba, } },
	{ 0x639, 25, { 0xfc29, 0xfc2a, 0xfcba, 0xfcbb, 0xfcf7, 0xfcf8, 0xfd13, 0xfd14, 0xfd75, 0xfd76, 0xfd77, 0xfd78, 0xfdb6, 0xfdc4, 0xfdf7, 0xfec9, 0xfeca, 0xfecb, 0xfecc, 0x1ee0f, 0x1ee2f, 0x1ee4f, 0x1ee6f, 0x1ee8f, 0x1eeaf, } },
	{ 0x63a, 21, { 0xfc2b, 0xfc2c, 0xfcbc, 0xfcbd, 0xfcf9, 0xfcfa, 0xfd15, 0xfd16, 0xfd79, 0xfd7a, 0xfd7b, 0xfecd, 0xfece, 0xfecf, 0xfed0, 0x1ee1b, 0x1ee3b, 0x1ee5b, 0x1ee7b, 0x1ee9b, 0x1eebb, } },
	{ 0x641, 24, { 0xfc2d, 0xfc2e, 0xfc2f, 0xfc30, 0xfc31, 0xfc32, 0xfc7c, 0xfc7d, 0xfcbe, 0xfcbf, 0xfcc0, 0xfcc1, 0xfd7c, 0xfd7d, 0xfdc1, 0xfed1, 0xfed2, 0xfed3, 0xfed4, 0x1ee10, 0x1ee30, 0x1ee70, 0x1ee90, 0x1eeb0, } },
	{ 0x642, 23, { 0xfc33, 0xfc34, 0xfc35, 0xfc36, 0xfc7e, 0xfc7f, 0xfcc2, 0xfcc3, 0xfd7e, 0xfd7f, 0xfdb2, 0xfdb4, 0xfdf1, 0xfed5, 0xfed6, 0xfed7, 0xfed8, 0x1ee12, 0x1ee32, 0x1ee52, 0x1ee72, 0x1ee92, 0x1eeb2, } },
	{ 0x643, 30, { 0xfc37, 0xfc38, 0xfc39, 0xfc3a, 0xfc3b, 0xfc3c, 0xfc3d, 0xfc3e, 0xfc80, 0xfc81, 0xfc82, 0xfc83, 0xfc84, 0xfcc4, 0xfcc5, 0xfcc6, 0xfcc7, 0xfcc8, 0xfceb, 0xfcec, 0xfdb7, 0xfdbb, 0xfdc3, 0xfed9, 0xfeda, 0xfedb, 0xfedc, 0x1ee0a, 0x1ee2a, 0x1ee6a, } },
	{ 0x644, 46, { 0xfc3f, 0xfc40, 0xfc41, 0xfc42, 0xfc43, 0xfc44, 0xfc85, 0xfc86, 0xfc87, 0xfcc9, 0xfcca, 0xfccb, 0xfccc, 0xfccd, 0xfced, 0xfd80, 0xfd81, 0xfd82, 0xfd83, 0xfd84, 0xfd85, 0xfd86, 0xfd87, 0xfd88, 0xfdac, 0xfdad, 0xfdb5, 0xfdba, 0xfdbc, 0xfedd, 0xfede, 0xfedf, 0xfee0, 0xfef5, 0xfef6, 0xfef7, 0xfef8, 0xfef9, 0xfefa, 0xfefb, 0xfefc, 0x1ee0b, 0x1ee2b, 0x1ee4b, 0x1ee8b, 0x1eeab, } },
	{ 0x645, 34, { 0x6fe, 0xfc45, 0xfc46, 0xfc47, 0xfc48, 0xfc49, 0xfc4a, 0xfc88, 0xfc89, 0xfcce, 0xfccf, 0xfcd0, 0xfcd1, 0xfd89, 0xfd8a, 0xfd8b, 0xfd8c, 0xfd8d, 0xfd8e, 0xfd8f, 0xfd92, 0xfdb1, 0xfdb9, 0xfdc0, 0xfdf4, 0xfee1, 0xfee2, 0xfee3, 0xfee4, 0x1ee0c, 0x1ee2c, 0x1ee6c, 0x1ee8c, 0x1eeac, } },
	{ 0x646, 40, { 0xfc4b, 0xfc4c, 0xfc4d, 0xfc4e, 0xfc4f, 0xfc50, 0xfc8a, 0xfc8b, 0xfc8c, 0xfc8d, 0xfc8e, 0xfc8f, 0xfcd2, 0xfcd3, 0xfcd4, 0xfcd5, 0xfcd6, 0xfcee, 0xfcef, 0xfd95, 0xfd96, 0xfd97, 0xfd98, 0xfd99, 0xfd9a, 0xfd9b, 0xfdb3, 0xfdb8, 0xfdbd, 0xfdc7, 0xfee5, 0xfee6, 0xfee7, 0xfee8, 0x1ee0d, 0x1ee2d, 0x1ee4d, 0x1ee6d, 0x1ee8d, 0x1eead, } },
	{ 0x647, 16, { 0xfc51, 0xfc52, 0xfc53, 0xfc54, 0xfcd7, 0xfcd8, 0xfcd9, 0xfd93, 0xfd94, 0xfee9, 0xfeea, 0xfeeb, 0xfeec, 0x1ee24, 0x1ee64, 0x1ee84, } },
	{ 0x648, 8, { 0x676, 0x6e5, 0xfdf8, 0xfeed, 0xfeee, 0x1ee05, 0x1ee85, 0x1eea5, } },
	{ 0x649, 6, { 0xfbe8, 0xfbe9, 0xfc5d, 0xfc90, 0xfeef, 0xfef0, } },
	{ 0x64a, 36, { 0x678, 0x6e6, 0xfc55, 0xfc56, 0xfc57, 0xfc58, 0xfc59, 0xfc5a, 0xfc91, 0xfc92, 0xfc93, 0xfc94, 0xfc95, 0xfc96, 0xfcda, 0xfcdb, 0xfcdc, 0xfcdd, 0xfcde, 0xfcf0, 0xfcf1, 0xfd9c, 0xfd9d, 0xfdae, 0xfdaf, 0xfdb0, 0xfef1, 0xfef2, 0xfef3, 0xfef4, 0x1ee09, 0x1ee29, 0x1ee49, 0x1ee69, 0x1ee89, 0x1eea9, } },
	{ 0x66e, 2, { 0x1ee1c, 0x1ee7c, } },
	{ 0x66f, 2, { 0x1ee1f, 0x1ee5f, } },
	{ 0x671, 2, { 0xfb50, 0xfb51, } },
	{ 0x677, 4, { 0x6c7, 0xfbd7, 0xfbd8, 0xfbdd, } },
	{ 0x679, 4, { 0xfb66, 0xfb67, 0xfb68, 0xfb69, } },
	{ 0x67a, 4, { 0xfb5e, 0xfb5f, 0xfb60, 0xfb61, } },
	{ 0x67b, 4, { 0xfb52, 0xfb53, 0xfb54, 0xfb55, } },
	{ 0x67e, 4, { 0xfb56, 0xfb57, 0xfb58, 0xfb59, } },
	{ 0x67f, 4, { 0xfb62, 0xfb63, 0xfb64, 0xfb65, } },
	{ 0x680, 4, { 0xfb5a, 0xfb5b, 0xfb5c, 0xfb5d, } },
	{ 0x683, 4, { 0xfb76, 0xfb77, 0xfb78, 0xfb79, } },
	{ 0x684, 4, { 0xfb72, 0xfb73, 0xfb74, 0xfb75, } },
	{ 0x686, 4, { 0xfb7a, 0xfb7b, 0xfb7c, 0xfb7d, } },
	{ 0x687, 4, { 0xfb7e, 0xfb7f, 0xfb80, 0xfb81, } },
	{ 0x688, 2, { 0xfb88, 0xfb89, } },
	{ 0x68c, 2, { 0xfb84, 0xfb85, } },
	{ 0x68d, 2, { 0xfb82, 0xfb83, } },
	{ 0x68e, 2, { 0xfb86, 0xfb87, } },
	{ 0x691, 2, { 0xfb8c, 0xfb8d, } },
	{ 0x698, 2, { 0xfb8a, 0xfb8b, } },
	{ 0x6a1, 2, { 0x1ee1e, 0x1ee7e, } },
	{ 0x6a4, 4, { 0xfb6a, 0xfb6b, 0xfb6c, 0xfb6d, } },
	{ 0x6a6, 4, { 0xfb6e, 0xfb6f, 0xfb70, 0xfb71, } },
	{ 0x6a9, 4, { 0xfb8e, 0xfb8f, 0xfb90, 0xfb91, } },
	{ 0x6ad, 4, { 0xfbd3, 0xfbd4, 0xfbd5, 0xfbd6, } },
	{ 0x6af, 4, { 0xfb92, 0xfb93, 0xfb94, 0xfb95, } },
	{ 0x6b1, 4, { 0xfb9a, 0xfb9b, 0xfb9c, 0xfb9d, } },
	{ 0x6b3, 4, { 0xfb96, 0xfb97, 0xfb98, 0xfb99, } },
	{ 0x6ba, 4, { 0xfb9e, 0xfb9f, 0x1ee1d, 0x1ee5d, } },
	{ 0x6bb, 4, { 0xfba0, 0xfba1, 0xfba2, 0xfba3, } },
	{ 0x6be, 4, { 0xfbaa, 0xfbab, 0xfbac, 0xfbad, } },
	{ 0x6c0, 3, { 0x6d5, 0xfba4, 0xfba5, } },
	{ 0x6c1, 5, { 0x6c2, 0xfba6, 0xfba7, 0xfba8, 0xfba9, } },
	{ 0x6c5, 2, { 0xfbe0, 0xfbe1, } },
	{ 0x6c6, 2, { 0xfbd9, 0xfbda, } },
	{ 0x6c8, 2, { 0xfbdb, 0xfbdc, } },
	{ 0x6c9, 2, { 0xfbe2, 0xfbe3, } },
	{ 0x6cb, 2, { 0xfbde, 0xfbdf, } },
	{ 0x6cc, 4, { 0xfbfc, 0xfbfd, 0xfbfe, 0xfbff, } },
	{ 0x6d0, 4, { 0xfbe4, 0xfbe5, 0xfbe6, 0xfbe7, } },
	{ 0x6d2, 5, { 0x6d3, 0xfbae, 0xfbaf, 0xfbb0, 0xfbb1, } },
	{ 0x713, 2, { 0x714, 0x72e, } },
	{ 0xd30, 2, { 0xd4e, 0xd7c, } },
	{ 0xeab, 2, { 0xedc, 0xedd, } },
	{ 0x1100, 6, { 0x3131, 0x3200, 0x320e, 0x3260, 0x326e, 0xffa1, } },
	{ 0x1101, 2, { 0x3132, 0xffa2, } },
	{ 0x1102, 6, { 0x3134, 0x3201, 0x320f, 0x3261, 0x326f, 0xffa4, } },
	{ 0x1103, 6, { 0x3137, 0x3202, 0x3210, 0x3262, 0x3270, 0xffa7, } },
	{ 0x1104, 2, { 0x3138, 0xffa8, } },
	{ 0x1105, 6, { 0x3139, 0x3203, 0x3211, 0x3263, 0x3271, 0xffa9, } },
	{ 0x1106, 6, { 0x3141, 0x3204, 0x3212, 0x3264, 0x3272, 0xffb1, } },
	{ 0x1107, 6, { 0x3142, 0x3205, 0x3213, 0x3265, 0x3273, 0xffb2, } },
	{ 0x1108, 2, { 0x3143, 0xffb3, } },
	{ 0x1109, 6, { 0x3145, 0x3206, 0x3214, 0x3266, 0x3274, 0xffb5, } },
	{ 0x110a, 2, { 0x3146, 0xffb6, } },
	{ 0x110b, 9, { 0x3147, 0x3207, 0x3215, 0x321d, 0x321e, 0x3267, 0x3275, 0x327e, 0xffb7, } },
	{ 0x110c, 8, { 0x3148, 0x3208, 0x3216, 0x321c, 0x3268, 0x3276, 0x327d, 0xffb8, } },
	{ 0x110d, 2, { 0x3149, 0xffb9, } },
	{ 0x110e, 7, { 0x314a, 0x3209, 0x3217, 0x3269, 0x3277, 0x327c, 0xffba, } },
	{ 0x110f, 6, { 0x314b, 0x320a, 0x3218, 0x326a, 0x3278, 0xffbb, } },
	{ 0x1110, 6, { 0x314c, 0x320b, 0x3219, 0x326b, 0x3279, 0xffbc, } },
	{ 0x1111, 6, { 0x314d, 0x320c, 0x321a, 0x326c, 0x327a, 0xffbd, } },
	{ 0x1112, 6, { 0x314e, 0x320d, 0x321b, 0x326d, 0x327b, 0xffbe, } },
	{ 0x111a, 2, { 0x3140, 0xffb0, } },
	{ 0x1121, 2, { 0x3144, 0xffb4, } },
	{ 0x1160, 2, { 0x3164, 0xffa0, } },
	{ 0x1161, 2, { 0x314f, 0xffc2, } },
	{ 0x1162, 2, { 0x3150, 0xffc3, } },
	{ 0x1163, 2, { 0x3151, 0xffc4, } },
	{ 0x1164, 2, { 0x3152, 0xffc5, } },
	{ 0x1165, 2, { 0x3153, 0xffc6, } },
	{ 0x1166, 2, { 0x3154, 0xffc7, } },
	{ 0x1167, 2, { 0x3155, 0xffca, } },
	{ 0x1168, 2, { 0x3156, 0xffcb, } },
	{ 0x1169, 2, { 0x3157, 0xffcc, } },
	{ 0x116a, 2, { 0x3158, 0xffcd, } },
	{ 0x116b, 2, { 0x3159, 0xffce, } },
	{ 0x116c, 2, { 0x315a, 0xffcf, } },
	{ 0x116d, 2, { 0x315b, 0xffd2, } },
	{ 0x116e, 2, { 0x315c, 0xffd3, } },
	{ 0x116f, 2, { 0x315d, 0xffd4, } },
	{ 0x1170, 2, { 0x315e, 0xffd5, } },
	{ 0x1171, 2, { 0x315f, 0xffd6, } },
	{ 0x1172, 2, { 0x3160, 0xffd7, } },
	{ 0x1173, 2, { 0x3161, 0xffda, } },
	{ 0x1174, 2, { 0x3162, 0xffdb, } },
	{ 0x1175, 2, { 0x3163, 0xffdc, } },
	{ 0x11aa, 2, { 0x3133, 0xffa3, } },
	{ 0x11ac, 2, { 0x3135, 0xffa5, } },
	{ 0x11ad, 2, { 0x3136, 0xffa6, } },
	{ 0x11b0, 2, { 0x313a, 0xffaa, } },
	{ 0x11b1, 2, { 0x313b, 0xffab, } },
	{ 0x11b2, 2, { 0x313c, 0xffac, } },
	{ 0x11b3, 2, { 0x313d, 0xffad, } },
	{ 0x11b4, 2, { 0x313e, 0xffae, } },
	{ 0x11b5, 2, { 0x313f, 0xffaf, } },
	{ 0x16a2, 2, { 0x16a4, 0x16a5, } },
	{ 0x16a6, 2, { 0x16a7, 0x16f0, } },
	{ 0x16a8, 4, { 0x16a9, 0x16ac, 0x16ad, 0x16ae, } },
	{ 0x16b2, 4, { 0x16b3, 0x16b4, 0x16b5, 0x16b6, } },
	{ 0x16ba, 3, { 0x16bb, 0x16bc, 0x16bd, } },
	{ 0x16be, 2, { 0x16bf, 0x16c0, } },
	{ 0x16c5, 2, { 0x16c6, 0x16ee, } },
	{ 0x16ca, 5, { 0x16cb, 0x16cc, 0x16cd, 0x16ce, 0x16ea, } },
	{ 0x16cf, 2, { 0x16d0, 0x16d1, } },
	{ 0x16d2, 2, { 0x16d3, 0x16d4, } },
	{ 0x16d7, 3, { 0x16d8, 0x16d9, 0x16ef, } },
	{ 0x16e6, 2, { 0x16e7, 0x16e8, } },
	{ 0x199c, 2, { 0x19de, 0x19df, } },
	{ 0x1a26, 2, { 0x1a58, 0x1a59, } },
	{ 0x1a3b, 2, { 0x1a5a, 0x1a5b, } },
	{ 0x1bc2, 2, { 0x1bc3, 0x1bc4, } },
	{ 0x1bcb, 2, { 0x1bcc, 0x1bcd, } },
	{ 0x1bd8, 2, { 0x1bd9, 0x1bda, } },
	{ 0x1c88, 3, { 0x2df9, 0xa64a, 0xa64b, } },
	{ 0x1ce9, 7, { 0x1cea, 0x1ceb, 0x1cec, 0x1cee, 0x1cef, 0x1cf0, 0x1cf1, } },
	{ 0x1de9, 2, { 0xa7b4, 0xa7b5, } },
	{ 0x2c00, 2, { 0x2c30, 0x1e000, } },
	{ 0x2c01, 2, { 0x2c31, 0x1e001, } },
	{ 0x2c02, 2, { 0x2c32, 0x1e002, } },
	{ 0x2c03, 2, { 0x2c33, 0x1e003, } },
	{ 0x2c04, 2, { 0x2c34, 0x1e004, } },
	{ 0x2c05, 2, { 0x2c35, 0x1e005, } },
	{ 0x2c06, 2, { 0x2c36, 0x1e006, } },
	{ 0x2c08, 2, { 0x2c38, 0x1e008, } },
	{ 0x2c09, 2, { 0x2c39, 0x1e009, } },
	{ 0x2c0a, 2, { 0x2c3a, 0x1e00a, } },
	{ 0x2c0b, 2, { 0x2c3b, 0x1e00b, } },
	{ 0x2c0c, 2, { 0x2c3c, 0x1e00c, } },
	{ 0x2c0d, 2, { 0x2c3d, 0x1e00d, } },
	{ 0x2c0e, 2, { 0x2c3e, 0x1e00e, } },
	{ 0x2c0f, 2, { 0x2c3f, 0x1e00f, } },
	{ 0x2c10, 2, { 0x2c40, 0x1e010, } },
	{ 0x2c11, 2, { 0x2c41, 0x1e011, } },
	{ 0x2c12, 2, { 0x2c42, 0x1e012, } },
	{ 0x2c13, 2, { 0x2c43, 0x1e013, } },
	{ 0x2c14, 2, { 0x2c44, 0x1e014, } },
	{ 0x2c15, 2, { 0x2c45, 0x1e015, } },
	{ 0x2c16, 2, { 0x2c46, 0x1e016, } },
	{ 0x2c17, 2, { 0x2c47, 0x1e017, } },
	{ 0x2c18, 2, { 0x2c48, 0x1e018, } },
	{ 0x2c1b, 2, { 0x2c4b, 0x1e01b, } },
	{ 0x2c1c, 2, { 0x2c4c, 0x1e01c, } },
	{ 0x2c1d, 2, { 0x2c4d, 0x1e01d, } },
	{ 0x2c1e, 2, { 0x2c4e, 0x1e01e, } },
	{ 0x2c1f, 2, { 0x2c4f, 0x1e01f, } },
	{ 0x2c20, 2, { 0x2c50, 0x1e020, } },
	{ 0x2c21, 2, { 0x2c51, 0x1e021, } },
	{ 0x2c23, 2, { 0x2c53, 0x1e023, } },
	{ 0x2c24, 2, { 0x2c54, 0x1e024, } },
	{ 0x2c26, 2, { 0x2c56, 0x1e026, } },
	{ 0x2c27, 2, { 0x2c57, 0x1e027, } },
	{ 0x2c28, 2, { 0x2c58, 0x1e028, } },
	{ 0x2c29, 2, { 0x2c59, 0x1e029, } },
	{ 0x2c2a, 2, { 0x2c5a, 0x1e02a, } },
	{ 0x2c94, 2, { 0x2c95, 0x2ce4, } },
	{ 0x2df8, 2, { 0xa648, 0xa649, } },
	{ 0x2dfc, 2, { 0xa656, 0xa657, } },
	{ 0x3006, 8, { 0x3057, 0x3058, 0x30b7, 0x30b8, 0x31f1, 0x32db, 0x3321, 0xff7c, } },
	{ 0x303c, 9, { 0x307e, 0x30de, 0x32ee, 0x3343, 0x3344, 0x3345, 0x3346, 0x3347, 0xff8f, } },
	{ 0x3041, 10, { 0x3042, 0x30a1, 0x30a2, 0x32d0, 0x3300, 0x3301, 0x3302, 0x3303, 0xff67, 0xff71, } },
	{ 0x3043, 8, { 0x3044, 0x30a3, 0x30a4, 0x32d1, 0x3304, 0x3305, 0xff68, 0xff72, } },
	{ 0x3045, 9, { 0x3046, 0x3094, 0x30a5, 0x30a6, 0x30f4, 0x32d2, 0x3306, 0xff69, 0xff73, } },
	{ 0x3047, 8, { 0x3048, 0x30a7, 0x30a8, 0x32d3, 0x3307, 0x3308, 0xff6a, 0xff74, } },
	{ 0x3049, 8, { 0x304a, 0x30a9, 0x30aa, 0x32d4, 0x3309, 0x330a, 0xff6b, 0xff75, } },
	{ 0x304b, 12, { 0x304c, 0x3095, 0x30ab, 0x30ac, 0x30f5, 0x32d5, 0x330b, 0x330c, 0x330d, 0x330e, 0x330f, 0xff76, } },
	{ 0x304d, 13, { 0x304e, 0x30ad, 0x30ae, 0x32d6, 0x3310, 0x3311, 0x3312, 0x3313, 0x3314, 0x3315, 0x3316, 0x3317, 0xff77, } },
	{ 0x304f, 10, { 0x3050, 0x30af, 0x30b0, 0x31f0, 0x32d7, 0x3318, 0x3319, 0x331a, 0x331b, 0xff78, } },
	{ 0x3051, 8, { 0x3052, 0x3096, 0x30b1, 0x30b2, 0x30f6, 0x32d8, 0x331c, 0xff79, } },
	{ 0x3053, 9, { 0x3054, 0x30b3, 0x30b4, 0x30ff, 0x32d9, 0x331d, 0x331e, 0xff7a, 0x1f201, } },
	{ 0x3055, 8, { 0x3056, 0x30b5, 0x30b6, 0x32da, 0x331f, 0x3320, 0xff7b, 0x1f202, } },
	{ 0x3059, 6, { 0x305a, 0x30b9, 0x30ba, 0x31f2, 0x32dc, 0xff7d, } },
	{ 0x305b, 7, { 0x305c, 0x30bb, 0x30bc, 0x32dd, 0x3322, 0x3323, 0xff7e, } },
	{ 0x305d, 5, { 0x305e, 0x30bd, 0x30be, 0x32de, 0xff7f, } },
	{ 0x305f, 6, { 0x3060, 0x30bf, 0x30c0, 0x32df, 0x3324, 0xff80, } },
	{ 0x3061, 5, { 0x3062, 0x30c1, 0x30c2, 0x32e0, 0xff81, } },
	{ 0x3063, 8, { 0x3064, 0x3065, 0x30c3, 0x30c4, 0x30c5, 0x32e1, 0xff6f, 0xff82, } },
	{ 0x3066, 7, { 0x3067, 0x30c6, 0x30c7, 0x32e2, 0x3325, 0xff83, 0x1f213, } },
	{ 0x3068, 8, { 0x3069, 0x30c8, 0x30c9, 0x31f3, 0x32e3, 0x3326, 0x3327, 0xff84, } },
	{ 0x306a, 4, { 0x30ca, 0x32e4, 0x3328, 0xff85, } },
	{ 0x306b, 3, { 0x30cb, 0x32e5, 0xff86, } },
	{ 0x306c, 4, { 0x30cc, 0x31f4, 0x32e6, 0xff87, } },
	{ 0x306d, 3, { 0x30cd, 0x32e7, 0xff88, } },
	{ 0x306e, 4, { 0x30ce, 0x32e8, 0x3329, 0xff89, } },
	{ 0x306f, 12, { 0x3070, 0x3071, 0x30cf, 0x30d0, 0x30d1, 0x31f5, 0x32e9, 0x332a, 0x332b, 0x332c, 0x332d, 0xff8a, } },
	{ 0x3072, 12, { 0x3073, 0x3074, 0x30d2, 0x30d3, 0x30d4, 0x31f6, 0x32ea, 0x332e, 0x332f, 0x3330, 0x3331, 0xff8b, } },
	{ 0x3075, 12, { 0x3076, 0x3077, 0x30d5, 0x30d6, 0x30d7, 0x31f7, 0x32eb, 0x3332, 0x3333, 0x3334, 0x3335, 0xff8c, } },
	{ 0x3078, 15, { 0x3079, 0x307a, 0x30d8, 0x30d9, 0x30da, 0x31f8, 0x32ec, 0x3336, 0x3337, 0x3338, 0x3339, 0x333a, 0x333b, 0x333c, 0xff8d, } },
	{ 0x307b, 15, { 0x307c, 0x307d, 0x30db, 0x30dc, 0x30dd, 0x31f9, 0x32ed, 0x333d, 0x333e, 0x333f, 0x3340, 0x3341, 0x3342, 0xff8e, 0x1f200, } },
	{ 0x307f, 6, { 0x30df, 0x32ef, 0x3348, 0x3349, 0x334a, 0xff90, } },
	{ 0x3080, 4, { 0x30e0, 0x31fa, 0x32f0, 0xff91, } },
	{ 0x3081, 6, { 0x30e1, 0x32f1, 0x334b, 0x334c, 0x334d, 0xff92, } },
	{ 0x3082, 3, { 0x30e2, 0x32f2, 0xff93, } },
	{ 0x3083, 8, { 0x3084, 0x30e3, 0x30e4, 0x32f3, 0x334e, 0x334f, 0xff6c, 0xff94, } },
	{ 0x3085, 7, { 0x3086, 0x30e5, 0x30e6, 0x32f4, 0x3350, 0xff6d, 0xff95, } },
	{ 0x3087, 7, { 0x3088, 0x309f, 0x30e7, 0x30e8, 0x32f5, 0xff6e, 0xff96, } },
	{ 0x3089, 4, { 0x30e9, 0x31fb, 0x32f6, 0xff97, } },
	{ 0x308a, 6, { 0x30ea, 0x31fc, 0x32f7, 0x3351, 0x3352, 0xff98, } },
	{ 0x308b, 6, { 0x30eb, 0x31fd, 0x32f8, 0x3353, 0x3354, 0xff99, } },
	{ 0x308c, 6, { 0x30ec, 0x31fe, 0x32f9, 0x3355, 0x3356, 0xff9a, } },
	{ 0x308d, 4, { 0x30ed, 0x31ff, 0x32fa, 0xff9b, } },
	{ 0x308e, 7, { 0x308f, 0x30ee, 0x30ef, 0x30f7, 0x32fb, 0x3357, 0xff9c, } },
	{ 0x3090, 3, { 0x30f0, 0x30f8, 0x32fc, } },
	{ 0x3091, 3, { 0x30f1, 0x30f9, 0x32fd, } },
	{ 0x3092, 4, { 0x30f2, 0x30fa, 0x32fe, 0xff66, } },
	{ 0x3093, 2, { 0x30f3, 0xff9d, } },
	{ 0x3127, 2, { 0x31aa, 0x31b3, } },
	{ 0x3128, 2, { 0x31a8, 0x31ab, } },
	{ 0xa558, 2, { 0xa610, 0xa618, } },
	{ 0xa5d1, 2, { 0xa61e, 0xa62b, } },
	{ 0xa726, 2, { 0xa727, 0xab5c, } },
	{ 0xa75a, 2, { 0x1de3, 0xa75b, } },
	{ 0xa75b, 2, { 0x1de3, 0xa75a, } },
	{ 0xa76e, 3, { 0x1dd2, 0xa76f, 0xa770, } },
	{ 0xa76f, 3, { 0x1dd2, 0xa76e, 0xa770, } },
	{ 0xa770, 3, { 0x1dd2, 0xa76e, 0xa76f, } },
	{ 0xa8f2, 5, { 0xa8f3, 0xa8f4, 0xa8f5, 0xa8f6, 0xa8f7, } },
	{ 0xfa6c, 93, { 0xfacf, 0xfad0, 0xfad1, 0xfad5, 0xfad6, 0xfad7, 0x2f803, 0x2f80d, 0x2f812, 0x2f816, 0x2f834, 0x2f838, 0x2f859, 0x2f860, 0x2f861, 0x2f86c, 0x2f871, 0x2f87b, 0x2f87d, 0x2f889, 0x2f891, 0x2f892, 0x2f897, 0x2f898, 0x2f8a4, 0x2f8b8, 0x2f8be, 0x2f8ca, 0x2f8dd, 0x2f8e3, 0x2f8ec, 0x2f8f0, 0x2f8f7, 0x2f8f8, 0x2f8f9, 0x2f8fb, 0x2f906, 0x2f90d, 0x2f910, 0x2f911, 0x2f91b, 0x2f91d, 0x2f91f, 0x2f923, 0x2f926, 0x2f927, 0x2f935, 0x2f937, 0x2f939, 0x2f93b, 0x2f93c, 0x2f93d, 0x2f941, 0x2f942, 0x2f943, 0x2f944, 0x2f94d, 0x2f952, 0x2f954, 0x2f955, 0x2f95c, 0x2f95d, 0x2f95e, 0x2f961, 0x2f965, 0x2f96b, 0x2f972, 0x2f973, 0x2f975, 0x2f977, 0x2f97b, 0x2f97c, 0x2f97e, 0x2f980, 0x2f987, 0x2f988, 0x2f989, 0x2f98a, 0x2f997, 0x2f9a4, 0x2f9a5, 0x2f9a6, 0x2f9ab, 0x2f9ad, 0x2f9b0, 0x2f9b1, 0x2f9c5, 0x2f9cb, 0x2f9cc, 0x2f9d3, 0x2f9d8, 0x2f9d9, 0x2f9dd, } },
	{ 0xfad2, 69, { 0xfad3, 0xfad4, 0x2f80c, 0x2f813, 0x2f81f, 0x2f824, 0x2f867, 0x2f868, 0x2f876, 0x2f883, 0x2f888, 0x2f88a, 0x2f896, 0x2f89b, 0x2f8a1, 0x2f8a2, 0x2f8c2, 0x2f8c7, 0x2f8ce, 0x2f8d0, 0x2f8d1, 0x2f8d7, 0x2f8de, 0x2f8e7, 0x2f8ee, 0x2f8f2, 0x2f90a, 0x2f916, 0x2f92a, 0x2f92c, 0x2f92d, 0x2f933, 0x2f93e, 0x2f93f, 0x2f949, 0x2f94b, 0x2f94c, 0x2f951, 0x2f958, 0x2f960, 0x2f964, 0x2f967, 0x2f96d, 0x2f971, 0x2f974, 0x2f981, 0x2f984, 0x2f98e, 0x2f9a7, 0x2f9ae, 0x2f9af, 0x2f9b2, 0x2f9bf, 0x2f9c2, 0x2f9c8, 0x2f9ca, 0x2f9cd, 0x2f9ce, 0x2f9ef, 0x2f9f2, 0x2f9f8, 0x2f9f9, 0x2f9fc, 0x2fa03, 0x2fa08, 0x2fa0d, 0x2fa0e, 0x2fa11, 0x2fa16, } },
	{ 0x10986, 2, { 0x10987, 0x109a6, } },
	{ 0x1098a, 2, { 0x1098b, 0x109a9, } },
	{ 0x1098c, 2, { 0x1098d, 0x109aa, } },
	{ 0x1098e, 2, { 0x1098f, 0x109ab, } },
	{ 0x10993, 3, { 0x10994, 0x109af, 0x109b0, } },
	{ 0x10998, 2, { 0x10999, 0x109b4, } },
	{ 0x1099a, 2, { 0x1099b, 0x109b5, } },
	{ 0x10c80, 3, { 0x10c81, 0x10cc0, 0x10cc1, } },
	{ 0x10c89, 5, { 0x10c8a, 0x10c8b, 0x10cc9, 0x10cca, 0x10ccb, } },
	{ 0x10c90, 3, { 0x10c91, 0x10cd0, 0x10cd1, } },
	{ 0x10c9b, 3, { 0x10c9c, 0x10cdb, 0x10cdc, } },
	{ 0x10c9d, 5, { 0x10c9e, 0x10c9f, 0x10cdd, 0x10cde, 0x10cdf, } },
	{ 0x10ca2, 3, { 0x10ca3, 0x10ce2, 0x10ce3, } },
	{ 0x10caa, 3, { 0x10cab, 0x10cea, 0x10ceb, } },
	{ 0x10cac, 3, { 0x10cad, 0x10cec, 0x10ced, } },
	{ 0x11582, 2, { 0x115d8, 0x115d9, } },
	{ 0x2f81c, 17, { 0x2f88f, 0x2f9e0, 0x2f9e1, 0x2f9e5, 0x2f9ed, 0x2f9f1, 0x2f9f6, 0x2f9f7, 0x2f9fb, 0x2f9fd, 0x2fa01, 0x2fa09, 0x2fa10, 0x2fa12, 0x2fa13, 0x2fa14, 0x2fa1d, } },
};

static const struct ref {
	int32_t		the_char;
	int32_t		key_char;
} ref_table[] = {
	{ 0x61, 0x41 },
	{ 0x62, 0x42 },
	{ 0x63, 0x43 },
	{ 0x64, 0x44 },
	{ 0x65, 0x45 },
	{ 0x66, 0x46 },
	{ 0x67, 0x47 },
	{ 0x68, 0x48 },
	{ 0x69, 0x49 },
	{ 0x6a, 0x4a },
	{ 0x6b, 0x4b },
	{ 0x6c, 0x4c },
	{ 0x6d, 0x4d },
	{ 0x6e, 0x4e },
	{ 0x6f, 0x4f },
	{ 0x70, 0x50 },
	{ 0x71, 0x51 },
	{ 0x72, 0x52 },
	{ 0x73, 0x53 },
	{ 0x74, 0x54 },
	{ 0x75, 0x55 },
	{ 0x76, 0x56 },
	{ 0x77, 0x57 },
	{ 0x78, 0x58 },
	{ 0x79, 0x59 },
	{ 0x7a, 0x5a },
	{ 0xaa, 0x41 },
	{ 0xba, 0x4f },
	{ 0xc0, 0x41 },
	{ 0xc1, 0x41 },
	{ 0xc2, 0x41 },
	{ 0xc3, 0x41 },
	{ 0xc4, 0x41 },
	{ 0xc5, 0x41 },
	{ 0xc6, 0x41 },
	{ 0xc7, 0x43 },
	{ 0xc8, 0x45 },
	{ 0xc9, 0x45 },
	{ 0xca, 0x45 },
	{ 0xcb, 0x45 },
	{ 0xcc, 0x49 },
	{ 0xcd, 0x49 },
	{ 0xce, 0x49 },
	{ 0xcf, 0x49 },
	{ 0xd0, 0x44 },
	{ 0xd1, 0x4e },
	{ 0xd2, 0x4f },
	{ 0xd3, 0x4f },
	{ 0xd4, 0x4f },
	{ 0xd5, 0x4f },
	{ 0xd6, 0x4f },
	{ 0xd8, 0x4f },
	{ 0xd9, 0x55 },
	{ 0xda, 0x55 },
	{ 0xdb, 0x55 },
	{ 0xdc, 0x55 },
	{ 0xdd, 0x59 },
	{ 0xdf, 0x53 },
	{ 0xe0, 0x41 },
	{ 0xe1, 0x41 },
	{ 0xe2, 0x41 },
	{ 0xe3, 0x41 },
	{ 0xe4, 0x41 },
	{ 0xe5, 0x41 },
	{ 0xe6, 0x41 },
	{ 0xe7, 0x43 },
	{ 0xe8, 0x45 },
	{ 0xe9, 0x45 },
	{ 0xea, 0x45 },
	{ 0xeb, 0x45 },
	{ 0xec, 0x49 },
	{ 0xed, 0x49 },
	{ 0xee, 0x49 },
	{ 0xef, 0x49 },
	{ 0xf0, 0x44 },
	{ 0xf1, 0x4e },
	{ 0xf2, 0x4f },
	{ 0xf3, 0x4f },
	{ 0xf4, 0x4f },
	{ 0xf5, 0x4f },
	{ 0xf6, 0x4f },
	{ 0xf8, 0x4f },
	{ 0xf9, 0x55 },
	{ 0xfa, 0x55 },
	{ 0xfb, 0x55 },
	{ 0xfc, 0x55 },
	{ 0xfd, 0x59 },
	{ 0xff, 0x59 },
	{ 0x100, 0x41 },
	{ 0x101, 0x41 },
	{ 0x102, 0x41 },
	{ 0x103, 0x41 },
	{ 0x104, 0x41 },
	{ 0x105, 0x41 },
	{ 0x106, 0x43 },
	{ 0x107, 0x43 },
	{ 0x108, 0x43 },
	{ 0x109, 0x43 },
	{ 0x10a, 0x43 },
	{ 0x10b, 0x43 },
	{ 0x10c, 0x43 },
	{ 0x10d, 0x43 },
	{ 0x10e, 0x44 },
	{ 0x10f, 0x44 },
	{ 0x110, 0x44 },
	{ 0x111, 0x44 },
	{ 0x112, 0x45 },
	{ 0x113, 0x45 },
	{ 0x114, 0x45 },
	{ 0x115, 0x45 },
	{ 0x116, 0x45 },
	{ 0x117, 0x45 },
	{ 0x118, 0x45 },
	{ 0x119, 0x45 },
	{ 0x11a, 0x45 },
	{ 0x11b, 0x45 },
	{ 0x11c, 0x47 },
	{ 0x11d, 0x47 },
	{ 0x11e, 0x47 },
	{ 0x11f, 0x47 },
	{ 0x120, 0x47 },
	{ 0x121, 0x47 },
	{ 0x122, 0x47 },
	{ 0x123, 0x47 },
	{ 0x124, 0x48 },
	{ 0x125, 0x48 },
	{ 0x126, 0x48 },
	{ 0x127, 0x48 },
	{ 0x128, 0x49 },
	{ 0x129, 0x49 },
	{ 0x12a, 0x49 },
	{ 0x12b, 0x49 },
	{ 0x12c, 0x49 },
	{ 0x12d, 0x49 },
	{ 0x12e, 0x49 },
	{ 0x12f, 0x49 },
	{ 0x130, 0x49 },
	{ 0x132, 0x49 },
	{ 0x133, 0x49 },
	{ 0x134, 0x4a },
	{ 0x135, 0x4a },
	{ 0x136, 0x4b },
	{ 0x137, 0x4b },
	{ 0x139, 0x4c },
	{ 0x13a, 0x4c },
	{ 0x13b, 0x4c },
	{ 0x13c, 0x4c },
	{ 0x13d, 0x4c },
	{ 0x13e, 0x4c },
	{ 0x13f, 0x4c },
	{ 0x140, 0x4c },
	{ 0x141, 0x4c },
	{ 0x142, 0x4c },
	{ 0x143, 0x4e },
	{ 0x144, 0x4e },
	{ 0x145, 0x4e },
	{ 0x146, 0x4e },
	{ 0x147, 0x4e },
	{ 0x148, 0x4e },
	{ 0x14b, 0x14a },
	{ 0x14c, 0x4f },
	{ 0x14d, 0x4f },
	{ 0x14e, 0x4f },
	{ 0x14f, 0x4f },
	{ 0x150, 0x4f },
	{ 0x151, 0x4f },
	{ 0x152, 0x4f },
	{ 0x153, 0x4f },
	{ 0x154, 0x52 },
	{ 0x155, 0x52 },
	{ 0x156, 0x52 },
	{ 0x157, 0x52 },
	{ 0x158, 0x52 },
	{ 0x159, 0x52 },
	{ 0x15a, 0x53 },
	{ 0x15b, 0x53 },
	{ 0x15c, 0x53 },
	{ 0x15d, 0x53 },
	{ 0x15e, 0x53 },
	{ 0x15f, 0x53 },
	{ 0x160, 0x53 },
	{ 0x161, 0x53 },
	{ 0x162, 0x54 },
	{ 0x163, 0x54 },
	{ 0x164, 0x54 },
	{ 0x165, 0x54 },
	{ 0x168, 0x55 },
	{ 0x169, 0x55 },
	{ 0x16a, 0x55 },
	{ 0x16b, 0x55 },
	{ 0x16c, 0x55 },
	{ 0x16d, 0x55 },
	{ 0x16e, 0x55 },
	{ 0x16f, 0x55 },
	{ 0x170, 0x55 },
	{ 0x171, 0x55 },
	{ 0x172, 0x55 },
	{ 0x173, 0x55 },
	{ 0x174, 0x57 },
	{ 0x175, 0x57 },
	{ 0x176, 0x59 },
	{ 0x177, 0x59 },
	{ 0x178, 0x59 },
	{ 0x179, 0x5a },
	{ 0x17a, 0x5a },
	{ 0x17b, 0x5a },
	{ 0x17c, 0x5a },
	{ 0x17d, 0x5a },
	{ 0x17e, 0x5a },
	{ 0x17f, 0x53 },
	{ 0x18d, 0x5a },
	{ 0x1a0, 0x4f },
	{ 0x1a1, 0x4f },
	{ 0x1af, 0x55 },
	{ 0x1b0, 0x55 },
	{ 0x1be, 0x54 },
	{ 0x1c4, 0x44 },
	{ 0x1c5, 0x44 },
	{ 0x1c6, 0x44 },
	{ 0x1c7, 0x4c },
	{ 0x1c8, 0x4c },
	{ 0x1c9, 0x4c },
	{ 0x1ca, 0x4e },
	{ 0x1cb, 0x4e },
	{ 0x1cc, 0x4e },
	{ 0x1cd, 0x41 },
	{ 0x1ce, 0x41 },
	{ 0x1cf, 0x49 },
	{ 0x1d0, 0x49 },
	{ 0x1d1, 0x4f },
	{ 0x1d2, 0x4f },
	{ 0x1d3, 0x55 },
	{ 0x1d4, 0x55 },
	{ 0x1d5, 0x55 },
	{ 0x1d6, 0x55 },
	{ 0x1d7, 0x55 },
	{ 0x1d8, 0x55 },
	{ 0x1d9, 0x55 },
	{ 0x1da, 0x55 },
	{ 0x1db, 0x55 },
	{ 0x1dc, 0x55 },
	{ 0x1dd, 0x18e },
	{ 0x1de, 0x41 },
	{ 0x1df, 0x41 },
	{ 0x1e0, 0x41 },
	{ 0x1e1, 0x41 },
	{ 0x1e2, 0x41 },
	{ 0x1e3, 0x41 },
	{ 0x1e6, 0x47 },
	{ 0x1e7, 0x47 },
	{ 0x1e8, 0x4b },
	{ 0x1e9, 0x4b },
	{ 0x1ea, 0x4f },
	{ 0x1eb, 0x4f },
	{ 0x1ec, 0x4f },
	{ 0x1ed, 0x4f },
	{ 0x1ee, 0x1b7 },
	{ 0x1ef, 0x1b7 },
	{ 0x1f0, 0x4a },
	{ 0x1f1, 0x44 },
	{ 0x1f2, 0x44 },
	{ 0x1f3, 0x44 },
	{ 0x1f4, 0x47 },
	{ 0x1f5, 0x47 },
	{ 0x1f8, 0x4e },
	{ 0x1f9, 0x4e },
	{ 0x1fa, 0x41 },
	{ 0x1fb, 0x41 },
	{ 0x1fc, 0x41 },
	{ 0x1fd, 0x41 },
	{ 0x1fe, 0x4f },
	{ 0x1ff, 0x4f },
	{ 0x200, 0x41 },
	{ 0x201, 0x41 },
	{ 0x202, 0x41 },
	{ 0x203, 0x41 },
	{ 0x204, 0x45 },
	{ 0x205, 0x45 },
	{ 0x206, 0x45 },
	{ 0x207, 0x45 },
	{ 0x208, 0x49 },
	{ 0x209, 0x49 },
	{ 0x20a, 0x49 },
	{ 0x20b, 0x49 },
	{ 0x20c, 0x4f },
	{ 0x20d, 0x4f },
	{ 0x20e, 0x4f },
	{ 0x20f, 0x4f },
	{ 0x210, 0x52 },
	{ 0x211, 0x52 },
	{ 0x212, 0x52 },
	{ 0x213, 0x52 },
	{ 0x214, 0x55 },
	{ 0x215, 0x55 },
	{ 0x216, 0x55 },
	{ 0x217, 0x55 },
	{ 0x218, 0x53 },
	{ 0x219, 0x53 },
	{ 0x21a, 0x54 },
	{ 0x21b, 0x54 },
	{ 0x21e, 0x48 },
	{ 0x21f, 0x48 },
	{ 0x223, 0x222 },
	{ 0x226, 0x41 },
	{ 0x227, 0x41 },
	{ 0x228, 0x45 },
	{ 0x229, 0x45 },
	{ 0x22a, 0x4f },
	{ 0x22b, 0x4f },
	{ 0x22c, 0x4f },
	{ 0x22d, 0x4f },
	{ 0x22e, 0x4f },
	{ 0x22f, 0x4f },
	{ 0x230, 0x4f },
	{ 0x231, 0x4f },
	{ 0x232, 0x59 },
	{ 0x233, 0x59 },
	{ 0x238, 0x44 },
	{ 0x239, 0x51 },
	{ 0x254, 0x186 },
	{ 0x259, 0x18f },
	{ 0x25b, 0x190 },
	{ 0x263, 0x194 },
	{ 0x268, 0x197 },
	{ 0x269, 0x196 },
	{ 0x26f, 0x19c },
	{ 0x272, 0x19d },
	{ 0x275, 0x19f },
	{ 0x280, 0x1a6 },
	{ 0x283, 0x1a9 },
	{ 0x289, 0x244 },
	{ 0x28a, 0x1b1 },
	{ 0x28b, 0x1b2 },
	{ 0x28c, 0x245 },
	{ 0x292, 0x1b7 },
	{ 0x2a3, 0x44 },
	{ 0x2a4, 0x44 },
	{ 0x2a5, 0x44 },
	{ 0x2a6, 0x54 },
	{ 0x2a7, 0x54 },
	{ 0x2a8, 0x54 },
	{ 0x2a9, 0x46 },
	{ 0x2aa, 0x4c },
	{ 0x2ab, 0x4c },
	{ 0x2b0, 0x48 },
	{ 0x2b1, 0x266 },
	{ 0x2b2, 0x4a },
	{ 0x2b3, 0x52 },
	{ 0x2b7, 0x57 },
	{ 0x2b8, 0x59 },
	{ 0x2e0, 0x194 },
	{ 0x2e1, 0x4c },
	{ 0x2e2, 0x53 },
	{ 0x2e3, 0x58 },
	{ 0x38a, 0x37a },
	{ 0x390, 0x37a },
	{ 0x391, 0x386 },
	{ 0x395, 0x388 },
	{ 0x397, 0x389 },
	{ 0x399, 0x37a },
	{ 0x39c, 0xb5 },
	{ 0x39f, 0x38c },
	{ 0x3a5, 0x38e },
	{ 0x3a9, 0x38f },
	{ 0x3aa, 0x37a },
	{ 0x3ab, 0x38e },
	{ 0x3ac, 0x386 },
	{ 0x3ad, 0x388 },
	{ 0x3ae, 0x389 },
	{ 0x3af, 0x37a },
	{ 0x3b0, 0x38e },
	{ 0x3b1, 0x386 },
	{ 0x3b2, 0x392 },
	{ 0x3b3, 0x393 },
	{ 0x3b4, 0x394 },
	{ 0x3b5, 0x388 },
	{ 0x3b6, 0x396 },
	{ 0x3b7, 0x389 },
	{ 0x3b8, 0x398 },
	{ 0x3b9, 0x37a },
	{ 0x3ba, 0x39a },
	{ 0x3bb, 0x39b },
	{ 0x3bc, 0xb5 },
	{ 0x3bd, 0x39d },
	{ 0x3be, 0x39e },
	{ 0x3bf, 0x38c },
	{ 0x3c0, 0x3a0 },
	{ 0x3c1, 0x3a1 },
	{ 0x3c2, 0x3a3 },
	{ 0x3c3, 0x3a3 },
	{ 0x3c4, 0x3a4 },
	{ 0x3c5, 0x38e },
	{ 0x3c6, 0x3a6 },
	{ 0x3c7, 0x3a7 },
	{ 0x3c8, 0x3a8 },
	{ 0x3c9, 0x38f },
	{ 0x3ca, 0x37a },
	{ 0x3cb, 0x38e },
	{ 0x3cc, 0x38c },
	{ 0x3cd, 0x38e },
	{ 0x3ce, 0x38f },
	{ 0x3cf, 0x39a },
	{ 0x3d0, 0x392 },
	{ 0x3d1, 0x398 },
	{ 0x3d2, 0x38e },
	{ 0x3d3, 0x38e },
	{ 0x3d4, 0x38e },
	{ 0x3d5, 0x3a6 },
	{ 0x3d6, 0x3a0 },
	{ 0x3d7, 0x39a },
	{ 0x3dd, 0x3dc },
	{ 0x3f0, 0x39a },
	{ 0x3f1, 0x3a1 },
	{ 0x3f2, 0x3a3 },
	{ 0x3f4, 0x398 },
	{ 0x3f5, 0x388 },
	{ 0x3f9, 0x3a3 },
	{ 0x401, 0x400 },
	{ 0x407, 0x406 },
	{ 0x413, 0x403 },
	{ 0x415, 0x400 },
	{ 0x418, 0x40d },
	{ 0x41a, 0x40c },
	{ 0x423, 0x40e },
	{ 0x430, 0x410 },
	{ 0x431, 0x411 },
	{ 0x432, 0x412 },
	{ 0x433, 0x403 },
	{ 0x434, 0x414 },
	{ 0x435, 0x400 },
	{ 0x436, 0x416 },
	{ 0x437, 0x417 },
	{ 0x438, 0x40d },
	{ 0x43a, 0x40c },
	{ 0x43b, 0x41b },
	{ 0x43c, 0x41c },
	{ 0x43d, 0x41d },
	{ 0x43e, 0x41e },
	{ 0x43f, 0x41f },
	{ 0x440, 0x420 },
	{ 0x441, 0x421 },
	{ 0x442, 0x422 },
	{ 0x443, 0x40e },
	{ 0x444, 0x424 },
	{ 0x445, 0x425 },
	{ 0x446, 0x426 },
	{ 0x447, 0x427 },
	{ 0x448, 0x428 },
	{ 0x449, 0x429 },
	{ 0x44a, 0x42a },
	{ 0x44b, 0x42b },
	{ 0x44c, 0x42c },
	{ 0x44d, 0x42d },
	{ 0x44e, 0x42e },
	{ 0x450, 0x400 },
	{ 0x451, 0x400 },
	{ 0x453, 0x403 },
	{ 0x454, 0x404 },
	{ 0x456, 0x406 },
	{ 0x457, 0x406 },
	{ 0x45c, 0x40c },
	{ 0x45d, 0x40d },
	{ 0x45e, 0x40e },
	{ 0x461, 0x460 },
	{ 0x463, 0x462 },
	{ 0x465, 0x464 },
	{ 0x467, 0x466 },
	{ 0x46b, 0x46a },
	{ 0x46d, 0x46c },
	{ 0x473, 0x472 },
	{ 0x475, 0x474 },
	{ 0x476, 0x474 },
	{ 0x477, 0x474 },
	{ 0x490, 0x403 },
	{ 0x491, 0x403 },
	{ 0x4c1, 0x416 },
	{ 0x4c2, 0x416 },
	{ 0x4d0, 0x410 },
	{ 0x4d1, 0x410 },
	{ 0x4d2, 0x410 },
	{ 0x4d3, 0x410 },
	{ 0x4d6, 0x400 },
	{ 0x4d7, 0x400 },
	{ 0x4d9, 0x4d8 },
	{ 0x4da, 0x4d8 },
	{ 0x4db, 0x4d8 },
	{ 0x4dc, 0x416 },
	{ 0x4dd, 0x416 },
	{ 0x4de, 0x417 },
	{ 0x4df, 0x417 },
	{ 0x4e2, 0x40d },
	{ 0x4e3, 0x40d },
	{ 0x4e4, 0x40d },
	{ 0x4e5, 0x40d },
	{ 0x4e6, 0x41e },
	{ 0x4e7, 0x41e },
	{ 0x4e9, 0x4e8 },
	{ 0x4ea, 0x4e8 },
	{ 0x4eb, 0x4e8 },
	{ 0x4ec, 0x42d },
	{ 0x4ed, 0x42d },
	{ 0x4ee, 0x40e },
	{ 0x4ef, 0x40e },
	{ 0x4f0, 0x40e },
	{ 0x4f1, 0x40e },
	{ 0x4f2, 0x40e },
	{ 0x4f3, 0x40e },
	{ 0x4f4, 0x427 },
	{ 0x4f5, 0x427 },
	{ 0x4f8, 0x42b },
	{ 0x4f9, 0x42b },
	{ 0x565, 0x535 },
	{ 0x574, 0x544 },
	{ 0x57e, 0x54e },
	{ 0x587, 0x535 },
	{ 0x5db, 0x5da },
	{ 0x5de, 0x5dd },
	{ 0x5e0, 0x5df },
	{ 0x5e4, 0x5e3 },
	{ 0x5e6, 0x5e5 },
	{ 0x5f0, 0x5d5 },
	{ 0x5f1, 0x5d5 },
	{ 0x5f2, 0x5d9 },
	{ 0x660, 0x30 },
	{ 0x661, 0x31 },
	{ 0x662, 0x32 },
	{ 0x663, 0x33 },
	{ 0x664, 0x34 },
	{ 0x665, 0x35 },
	{ 0x666, 0x36 },
	{ 0x667, 0x37 },
	{ 0x668, 0x38 },
	{ 0x669, 0x39 },
	{ 0x674, 0x621 },
	{ 0x675, 0x627 },
	{ 0x676, 0x648 },
	{ 0x678, 0x64a },
	{ 0x6c2, 0x6c1 },
	{ 0x6c7, 0x677 },
	{ 0x6d3, 0x6d2 },
	{ 0x6d5, 0x6c0 },
	{ 0x6e5, 0x648 },
	{ 0x6e6, 0x64a },
	{ 0x6f0, 0x30 },
	{ 0x6f1, 0x31 },
	{ 0x6f2, 0x32 },
	{ 0x6f3, 0x33 },
	{ 0x6f4, 0x34 },
	{ 0x6f5, 0x35 },
	{ 0x6f6, 0x36 },
	{ 0x6f7, 0x37 },
	{ 0x6f8, 0x38 },
	{ 0x6f9, 0x39 },
	{ 0x714, 0x713 },
	{ 0x72e, 0x713 },
	{ 0x7c0, 0x30 },
	{ 0x7c1, 0x31 },
	{ 0x7c2, 0x32 },
	{ 0x7c3, 0x33 },
	{ 0x7c4, 0x34 },
	{ 0x7c5, 0x35 },
	{ 0x7c6, 0x36 },
	{ 0x7c7, 0x37 },
	{ 0x7c8, 0x38 },
	{ 0x7c9, 0x39 },
	{ 0x8ad, 0x627 },
	{ 0x966, 0x30 },
	{ 0x967, 0x31 },
	{ 0x968, 0x32 },
	{ 0x969, 0x33 },
	{ 0x96a, 0x34 },
	{ 0x96b, 0x35 },
	{ 0x96c, 0x36 },
	{ 0x96d, 0x37 },
	{ 0x96e, 0x38 },
	{ 0x96f, 0x39 },
	{ 0x9e6, 0x30 },
	{ 0x9e7, 0x31 },
	{ 0x9e8, 0x32 },
	{ 0x9e9, 0x33 },
	{ 0x9ea, 0x34 },
	{ 0x9eb, 0x35 },
	{ 0x9ec, 0x36 },
	{ 0x9ed, 0x37 },
	{ 0x9ee, 0x38 },
	{ 0x9ef, 0x39 },
	{ 0xa66, 0x30 },
	{ 0xa67, 0x31 },
	{ 0xa68, 0x32 },
	{ 0xa69, 0x33 },
	{ 0xa6a, 0x34 },
	{ 0xa6b, 0x35 },
	{ 0xa6c, 0x36 },
	{ 0xa6d, 0x37 },
	{ 0xa6e, 0x38 },
	{ 0xa6f, 0x39 },
	{ 0xae6, 0x30 },
	{ 0xae7, 0x31 },
	{ 0xae8, 0x32 },
	{ 0xae9, 0x33 },
	{ 0xaea, 0x34 },
	{ 0xaeb, 0x35 },
	{ 0xaec, 0x36 },
	{ 0xaed, 0x37 },
	{ 0xaee, 0x38 },
	{ 0xaef, 0x39 },
	{ 0xb66, 0x30 },
	{ 0xb67, 0x31 },
	{ 0xb68, 0x32 },
	{ 0xb69, 0x33 },
	{ 0xb6a, 0x34 },
	{ 0xb6b, 0x35 },
	{ 0xb6c, 0x36 },
	{ 0xb6d, 0x37 },
	{ 0xb6e, 0x38 },
	{ 0xb6f, 0x39 },
	{ 0xbe6, 0x30 },
	{ 0xbe7, 0x31 },
	{ 0xbe8, 0x32 },
	{ 0xbe9, 0x33 },
	{ 0xbea, 0x34 },
	{ 0xbeb, 0x35 },
	{ 0xbec, 0x36 },
	{ 0xbed, 0x37 },
	{ 0xbee, 0x38 },
	{ 0xbef, 0x39 },
	{ 0xc66, 0x30 },
	{ 0xc67, 0x31 },
	{ 0xc68, 0x32 },
	{ 0xc69, 0x33 },
	{ 0xc6a, 0x34 },
	{ 0xc6b, 0x35 },
	{ 0xc6c, 0x36 },
	{ 0xc6d, 0x37 },
	{ 0xc6e, 0x38 },
	{ 0xc6f, 0x39 },
	{ 0xce6, 0x30 },
	{ 0xce7, 0x31 },
	{ 0xce8, 0x32 },
	{ 0xce9, 0x33 },
	{ 0xcea, 0x34 },
	{ 0xceb, 0x35 },
	{ 0xcec, 0x36 },
	{ 0xced, 0x37 },
	{ 0xcee, 0x38 },
	{ 0xcef, 0x39 },
	{ 0xd4e, 0xd30 },
	{ 0xd66, 0x30 },
	{ 0xd67, 0x31 },
	{ 0xd68, 0x32 },
	{ 0xd69, 0x33 },
	{ 0xd6a, 0x34 },
	{ 0xd6b, 0x35 },
	{ 0xd6c, 0x36 },
	{ 0xd6d, 0x37 },
	{ 0xd6e, 0x38 },
	{ 0xd6f, 0x39 },
	{ 0xd7c, 0xd30 },
	{ 0xde6, 0x30 },
	{ 0xde7, 0x31 },
	{ 0xde8, 0x32 },
	{ 0xde9, 0x33 },
	{ 0xdea, 0x34 },
	{ 0xdeb, 0x35 },
	{ 0xdec, 0x36 },
	{ 0xded, 0x37 },
	{ 0xdee, 0x38 },
	{ 0xdef, 0x39 },
	{ 0xe50, 0x30 },
	{ 0xe51, 0x31 },
	{ 0xe52, 0x32 },
	{ 0xe53, 0x33 },
	{ 0xe54, 0x34 },
	{ 0xe55, 0x35 },
	{ 0xe56, 0x36 },
	{ 0xe57, 0x37 },
	{ 0xe58, 0x38 },
	{ 0xe59, 0x39 },
	{ 0xed0, 0x30 },
	{ 0xed1, 0x31 },
	{ 0xed2, 0x32 },
	{ 0xed3, 0x33 },
	{ 0xed4, 0x34 },
	{ 0xed5, 0x35 },
	{ 0xed6, 0x36 },
	{ 0xed7, 0x37 },
	{ 0xed8, 0x38 },
	{ 0xed9, 0x39 },
	{ 0xedc, 0xeab },
	{ 0xedd, 0xeab },
	{ 0xf20, 0x30 },
	{ 0xf21, 0x31 },
	{ 0xf22, 0x32 },
	{ 0xf23, 0x33 },
	{ 0xf24, 0x34 },
	{ 0xf25, 0x35 },
	{ 0xf26, 0x36 },
	{ 0xf27, 0x37 },
	{ 0xf28, 0x38 },
	{ 0xf29, 0x39 },
	{ 0x1040, 0x30 },
	{ 0x1041, 0x31 },
	{ 0x1042, 0x32 },
	{ 0x1043, 0x33 },
	{ 0x1044, 0x34 },
	{ 0x1045, 0x35 },
	{ 0x1046, 0x36 },
	{ 0x1047, 0x37 },
	{ 0x1048, 0x38 },
	{ 0x1049, 0x39 },
	{ 0x1090, 0x30 },
	{ 0x1091, 0x31 },
	{ 0x1092, 0x32 },
	{ 0x1093, 0x33 },
	{ 0x1094, 0x34 },
	{ 0x1095, 0x35 },
	{ 0x1096, 0x36 },
	{ 0x1097, 0x37 },
	{ 0x1098, 0x38 },
	{ 0x1099, 0x39 },
	{ 0x16a4, 0x16a2 },
	{ 0x16a5, 0x16a2 },
	{ 0x16a7, 0x16a6 },
	{ 0x16a9, 0x16a8 },
	{ 0x16ac, 0x16a8 },
	{ 0x16ad, 0x16a8 },
	{ 0x16ae, 0x16a8 },
	{ 0x16b3, 0x16b2 },
	{ 0x16b4, 0x16b2 },
	{ 0x16b5, 0x16b2 },
	{ 0x16b6, 0x16b2 },
	{ 0x16bb, 0x16ba },
	{ 0x16bc, 0x16ba },
	{ 0x16bd, 0x16ba },
	{ 0x16bf, 0x16be },
	{ 0x16c0, 0x16be },
	{ 0x16c6, 0x16c5 },
	{ 0x16cb, 0x16ca },
	{ 0x16cc, 0x16ca },
	{ 0x16cd, 0x16ca },
	{ 0x16ce, 0x16ca },
	{ 0x16d0, 0x16cf },
	{ 0x16d1, 0x16cf },
	{ 0x16d3, 0x16d2 },
	{ 0x16d4, 0x16d2 },
	{ 0x16d8, 0x16d7 },
	{ 0x16d9, 0x16d7 },
	{ 0x16e7, 0x16e6 },
	{ 0x16e8, 0x16e6 },
	{ 0x16ea, 0x16ca },
	{ 0x16ee, 0x16c5 },
	{ 0x16ef, 0x16d7 },
	{ 0x16f0, 0x16a6 },
	{ 0x17e0, 0x30 },
	{ 0x17e1, 0x31 },
	{ 0x17e2, 0x32 },
	{ 0x17e3, 0x33 },
	{ 0x17e4, 0x34 },
	{ 0x17e5, 0x35 },
	{ 0x17e6, 0x36 },
	{ 0x17e7, 0x37 },
	{ 0x17e8, 0x38 },
	{ 0x17e9, 0x39 },
	{ 0x1810, 0x30 },
	{ 0x1811, 0x31 },
	{ 0x1812, 0x32 },
	{ 0x1813, 0x33 },
	{ 0x1814, 0x34 },
	{ 0x1815, 0x35 },
	{ 0x1816, 0x36 },
	{ 0x1817, 0x37 },
	{ 0x1818, 0x38 },
	{ 0x1819, 0x39 },
	{ 0x1946, 0x30 },
	{ 0x1947, 0x31 },
	{ 0x1948, 0x32 },
	{ 0x1949, 0x33 },
	{ 0x194a, 0x34 },
	{ 0x194b, 0x35 },
	{ 0x194c, 0x36 },
	{ 0x194d, 0x37 },
	{ 0x194e, 0x38 },
	{ 0x194f, 0x39 },
	{ 0x19d0, 0x30 },
	{ 0x19d1, 0x31 },
	{ 0x19d2, 0x32 },
	{ 0x19d3, 0x33 },
	{ 0x19d4, 0x34 },
	{ 0x19d5, 0x35 },
	{ 0x19d6, 0x36 },
	{ 0x19d7, 0x37 },
	{ 0x19d8, 0x38 },
	{ 0x19d9, 0x39 },
	{ 0x1a58, 0x1a26 },
	{ 0x1a59, 0x1a26 },
	{ 0x1a5a, 0x1a3b },
	{ 0x1a5b, 0x1a3b },
	{ 0x1a80, 0x30 },
	{ 0x1a81, 0x31 },
	{ 0x1a82, 0x32 },
	{ 0x1a83, 0x33 },
	{ 0x1a84, 0x34 },
	{ 0x1a85, 0x35 },
	{ 0x1a86, 0x36 },
	{ 0x1a87, 0x37 },
	{ 0x1a88, 0x38 },
	{ 0x1a89, 0x39 },
	{ 0x1a90, 0x30 },
	{ 0x1a91, 0x31 },
	{ 0x1a92, 0x32 },
	{ 0x1a93, 0x33 },
	{ 0x1a94, 0x34 },
	{ 0x1a95, 0x35 },
	{ 0x1a96, 0x36 },
	{ 0x1a97, 0x37 },
	{ 0x1a98, 0x38 },
	{ 0x1a99, 0x39 },
	{ 0x1b50, 0x30 },
	{ 0x1b51, 0x31 },
	{ 0x1b52, 0x32 },
	{ 0x1b53, 0x33 },
	{ 0x1b54, 0x34 },
	{ 0x1b55, 0x35 },
	{ 0x1b56, 0x36 },
	{ 0x1b57, 0x37 },
	{ 0x1b58, 0x38 },
	{ 0x1b59, 0x39 },
	{ 0x1bb0, 0x30 },
	{ 0x1bb1, 0x31 },
	{ 0x1bb2, 0x32 },
	{ 0x1bb3, 0x33 },
	{ 0x1bb4, 0x34 },
	{ 0x1bb5, 0x35 },
	{ 0x1bb6, 0x36 },
	{ 0x1bb7, 0x37 },
	{ 0x1bb8, 0x38 },
	{ 0x1bb9, 0x39 },
	{ 0x1bc3, 0x1bc2 },
	{ 0x1bc4, 0x1bc2 },
	{ 0x1bcc, 0x1bcb },
	{ 0x1bcd, 0x1bcb },
	{ 0x1bd9, 0x1bd8 },
	{ 0x1bda, 0x1bd8 },
	{ 0x1c40, 0x30 },
	{ 0x1c41, 0x31 },
	{ 0x1c42, 0x32 },
	{ 0x1c43, 0x33 },
	{ 0x1c44, 0x34 },
	{ 0x1c45, 0x35 },
	{ 0x1c46, 0x36 },
	{ 0x1c47, 0x37 },
	{ 0x1c48, 0x38 },
	{ 0x1c49, 0x39 },
	{ 0x1c50, 0x30 },
	{ 0x1c51, 0x31 },
	{ 0x1c52, 0x32 },
	{ 0x1c53, 0x33 },
	{ 0x1c54, 0x34 },
	{ 0x1c55, 0x35 },
	{ 0x1c56, 0x36 },
	{ 0x1c57, 0x37 },
	{ 0x1c58, 0x38 },
	{ 0x1c59, 0x39 },
	{ 0x1c80, 0x412 },
	{ 0x1c81, 0x414 },
	{ 0x1c82, 0x41e },
	{ 0x1c83, 0x421 },
	{ 0x1c84, 0x422 },
	{ 0x1c85, 0x422 },
	{ 0x1c86, 0x42a },
	{ 0x1c87, 0x462 },
	{ 0x1cea, 0x1ce9 },
	{ 0x1ceb, 0x1ce9 },
	{ 0x1cec, 0x1ce9 },
	{ 0x1cee, 0x1ce9 },
	{ 0x1cef, 0x1ce9 },
	{ 0x1cf0, 0x1ce9 },
	{ 0x1cf1, 0x1ce9 },
	{ 0x1d2c, 0x41 },
	{ 0x1d2d, 0x41 },
	{ 0x1d2e, 0x42 },
	{ 0x1d30, 0x44 },
	{ 0x1d31, 0x45 },
	{ 0x1d32, 0x18e },
	{ 0x1d33, 0x47 },
	{ 0x1d34, 0x48 },
	{ 0x1d35, 0x49 },
	{ 0x1d36, 0x4a },
	{ 0x1d37, 0x4b },
	{ 0x1d38, 0x4c },
	{ 0x1d39, 0x4d },
	{ 0x1d3a, 0x4e },
	{ 0x1d3c, 0x4f },
	{ 0x1d3d, 0x222 },
	{ 0x1d3e, 0x50 },
	{ 0x1d3f, 0x52 },
	{ 0x1d40, 0x54 },
	{ 0x1d41, 0x55 },
	{ 0x1d42, 0x57 },
	{ 0x1d43, 0x41 },
	{ 0x1d44, 0x250 },
	{ 0x1d45, 0x251 },
	{ 0x1d47, 0x42 },
	{ 0x1d48, 0x44 },
	{ 0x1d49, 0x45 },
	{ 0x1d4a, 0x18f },
	{ 0x1d4b, 0x190 },
	{ 0x1d4d, 0x47 },
	{ 0x1d4f, 0x4b },
	{ 0x1d50, 0x4d },
	{ 0x1d51, 0x14a },
	{ 0x1d52, 0x4f },
	{ 0x1d53, 0x186 },
	{ 0x1d56, 0x50 },
	{ 0x1d57, 0x54 },
	{ 0x1d58, 0x55 },
	{ 0x1d5a, 0x19c },
	{ 0x1d5b, 0x56 },
	{ 0x1d5d, 0x392 },
	{ 0x1d5e, 0x393 },
	{ 0x1d5f, 0x394 },
	{ 0x1d60, 0x3a6 },
	{ 0x1d61, 0x3a7 },
	{ 0x1d62, 0x49 },
	{ 0x1d63, 0x52 },
	{ 0x1d64, 0x55 },
	{ 0x1d65, 0x56 },
	{ 0x1d66, 0x392 },
	{ 0x1d67, 0x393 },
	{ 0x1d68, 0x3a1 },
	{ 0x1d69, 0x3a6 },
	{ 0x1d6a, 0x3a7 },
	{ 0x1d78, 0x41d },
	{ 0x1d79, 0x47 },
	{ 0x1d7a, 0x54 },
	{ 0x1d9b, 0x252 },
	{ 0x1d9c, 0x43 },
	{ 0x1d9e, 0x44 },
	{ 0x1d9f, 0x25c },
	{ 0x1da0, 0x46 },
	{ 0x1da2, 0x261 },
	{ 0x1da3, 0x265 },
	{ 0x1da4, 0x197 },
	{ 0x1da5, 0x196 },
	{ 0x1da6, 0x26a },
	{ 0x1da8, 0x29d },
	{ 0x1dab, 0x29f },
	{ 0x1dac, 0x271 },
	{ 0x1dae, 0x19d },
	{ 0x1db0, 0x274 },
	{ 0x1db1, 0x19f },
	{ 0x1db4, 0x1a9 },
	{ 0x1db6, 0x244 },
	{ 0x1db7, 0x1b1 },
	{ 0x1db9, 0x1b2 },
	{ 0x1dba, 0x245 },
	{ 0x1dbb, 0x5a },
	{ 0x1dbe, 0x1b7 },
	{ 0x1dbf, 0x398 },
	{ 0x1de7, 0x251 },
	{ 0x1de8, 0x42 },
	{ 0x1dea, 0x18f },
	{ 0x1deb, 0x46 },
	{ 0x1ded, 0x4f },
	{ 0x1dee, 0x50 },
	{ 0x1def, 0x1a9 },
	{ 0x1df0, 0x55 },
	{ 0x1df1, 0x57 },
	{ 0x1df2, 0x41 },
	{ 0x1df3, 0x4f },
	{ 0x1df4, 0x55 },
	{ 0x1e00, 0x41 },
	{ 0x1e01, 0x41 },
	{ 0x1e02, 0x42 },
	{ 0x1e03, 0x42 },
	{ 0x1e04, 0x42 },
	{ 0x1e05, 0x42 },
	{ 0x1e06, 0x42 },
	{ 0x1e07, 0x42 },
	{ 0x1e08, 0x43 },
	{ 0x1e09, 0x43 },
	{ 0x1e0a, 0x44 },
	{ 0x1e0b, 0x44 },
	{ 0x1e0c, 0x44 },
	{ 0x1e0d, 0x44 },
	{ 0x1e0e, 0x44 },
	{ 0x1e0f, 0x44 },
	{ 0x1e10, 0x44 },
	{ 0x1e11, 0x44 },
	{ 0x1e12, 0x44 },
	{ 0x1e13, 0x44 },
	{ 0x1e14, 0x45 },
	{ 0x1e15, 0x45 },
	{ 0x1e16, 0x45 },
	{ 0x1e17, 0x45 },
	{ 0x1e18, 0x45 },
	{ 0x1e19, 0x45 },
	{ 0x1e1a, 0x45 },
	{ 0x1e1b, 0x45 },
	{ 0x1e1c, 0x45 },
	{ 0x1e1d, 0x45 },
	{ 0x1e1e, 0x46 },
	{ 0x1e1f, 0x46 },
	{ 0x1e20, 0x47 },
	{ 0x1e21, 0x47 },
	{ 0x1e22, 0x48 },
	{ 0x1e23, 0x48 },
	{ 0x1e24, 0x48 },
	{ 0x1e25, 0x48 },
	{ 0x1e26, 0x48 },
	{ 0x1e27, 0x48 },
	{ 0x1e28, 0x48 },
	{ 0x1e29, 0x48 },
	{ 0x1e2a, 0x48 },
	{ 0x1e2b, 0x48 },
	{ 0x1e2c, 0x49 },
	{ 0x1e2d, 0x49 },
	{ 0x1e2e, 0x49 },
	{ 0x1e2f, 0x49 },
	{ 0x1e30, 0x4b },
	{ 0x1e31, 0x4b },
	{ 0x1e32, 0x4b },
	{ 0x1e33, 0x4b },
	{ 0x1e34, 0x4b },
	{ 0x1e35, 0x4b },
	{ 0x1e36, 0x4c },
	{ 0x1e37, 0x4c },
	{ 0x1e38, 0x4c },
	{ 0x1e39, 0x4c },
	{ 0x1e3a, 0x4c },
	{ 0x1e3b, 0x4c },
	{ 0x1e3c, 0x4c },
	{ 0x1e3d, 0x4c },
	{ 0x1e3e, 0x4d },
	{ 0x1e3f, 0x4d },
	{ 0x1e40, 0x4d },
	{ 0x1e41, 0x4d },
	{ 0x1e42, 0x4d },
	{ 0x1e43, 0x4d },
	{ 0x1e44, 0x4e },
	{ 0x1e45, 0x4e },
	{ 0x1e46, 0x4e },
	{ 0x1e47, 0x4e },
	{ 0x1e48, 0x4e },
	{ 0x1e49, 0x4e },
	{ 0x1e4a, 0x4e },
	{ 0x1e4b, 0x4e },
	{ 0x1e4c, 0x4f },
	{ 0x1e4d, 0x4f },
	{ 0x1e4e, 0x4f },
	{ 0x1e4f, 0x4f },
	{ 0x1e50, 0x4f },
	{ 0x1e51, 0x4f },
	{ 0x1e52, 0x4f },
	{ 0x1e53, 0x4f },
	{ 0x1e54, 0x50 },
	{ 0x1e55, 0x50 },
	{ 0x1e56, 0x50 },
	{ 0x1e57, 0x50 },
	{ 0x1e58, 0x52 },
	{ 0x1e59, 0x52 },
	{ 0x1e5a, 0x52 },
	{ 0x1e5b, 0x52 },
	{ 0x1e5c, 0x52 },
	{ 0x1e5d, 0x52 },
	{ 0x1e5e, 0x52 },
	{ 0x1e5f, 0x52 },
	{ 0x1e60, 0x53 },
	{ 0x1e61, 0x53 },
	{ 0x1e62, 0x53 },
	{ 0x1e63, 0x53 },
	{ 0x1e64, 0x53 },
	{ 0x1e65, 0x53 },
	{ 0x1e66, 0x53 },
	{ 0x1e67, 0x53 },
	{ 0x1e68, 0x53 },
	{ 0x1e69, 0x53 },
	{ 0x1e6a, 0x54 },
	{ 0x1e6b, 0x54 },
	{ 0x1e6c, 0x54 },
	{ 0x1e6d, 0x54 },
	{ 0x1e6e, 0x54 },
	{ 0x1e6f, 0x54 },
	{ 0x1e70, 0x54 },
	{ 0x1e71, 0x54 },
	{ 0x1e72, 0x55 },
	{ 0x1e73, 0x55 },
	{ 0x1e74, 0x55 },
	{ 0x1e75, 0x55 },
	{ 0x1e76, 0x55 },
	{ 0x1e77, 0x55 },
	{ 0x1e78, 0x55 },
	{ 0x1e79, 0x55 },
	{ 0x1e7a, 0x55 },
	{ 0x1e7b, 0x55 },
	{ 0x1e7c, 0x56 },
	{ 0x1e7d, 0x56 },
	{ 0x1e7e, 0x56 },
	{ 0x1e7f, 0x56 },
	{ 0x1e80, 0x57 },
	{ 0x1e81, 0x57 },
	{ 0x1e82, 0x57 },
	{ 0x1e83, 0x57 },
	{ 0x1e84, 0x57 },
	{ 0x1e85, 0x57 },
	{ 0x1e86, 0x57 },
	{ 0x1e87, 0x57 },
	{ 0x1e88, 0x57 },
	{ 0x1e89, 0x57 },
	{ 0x1e8a, 0x58 },
	{ 0x1e8b, 0x58 },
	{ 0x1e8c, 0x58 },
	{ 0x1e8d, 0x58 },
	{ 0x1e8e, 0x59 },
	{ 0x1e8f, 0x59 },
	{ 0x1e90, 0x5a },
	{ 0x1e91, 0x5a },
	{ 0x1e92, 0x5a },
	{ 0x1e93, 0x5a },
	{ 0x1e94, 0x5a },
	{ 0x1e95, 0x5a },
	{ 0x1e96, 0x48 },
	{ 0x1e97, 0x54 },
	{ 0x1e98, 0x57 },
	{ 0x1e99, 0x59 },
	{ 0x1e9a, 0x41 },
	{ 0x1e9b, 0x53 },
	{ 0x1e9e, 0x53 },
	{ 0x1ea0, 0x41 },
	{ 0x1ea1, 0x41 },
	{ 0x1ea2, 0x41 },
	{ 0x1ea3, 0x41 },
	{ 0x1ea4, 0x41 },
	{ 0x1ea5, 0x41 },
	{ 0x1ea6, 0x41 },
	{ 0x1ea7, 0x41 },
	{ 0x1ea8, 0x41 },
	{ 0x1ea9, 0x41 },
	{ 0x1eaa, 0x41 },
	{ 0x1eab, 0x41 },
	{ 0x1eac, 0x41 },
	{ 0x1ead, 0x41 },
	{ 0x1eae, 0x41 },
	{ 0x1eaf, 0x41 },
	{ 0x1eb0, 0x41 },
	{ 0x1eb1, 0x41 },
	{ 0x1eb2, 0x41 },
	{ 0x1eb3, 0x41 },
	{ 0x1eb4, 0x41 },
	{ 0x1eb5, 0x41 },
	{ 0x1eb6, 0x41 },
	{ 0x1eb7, 0x41 },
	{ 0x1eb8, 0x45 },
	{ 0x1eb9, 0x45 },
	{ 0x1eba, 0x45 },
	{ 0x1ebb, 0x45 },
	{ 0x1ebc, 0x45 },
	{ 0x1ebd, 0x45 },
	{ 0x1ebe, 0x45 },
	{ 0x1ebf, 0x45 },
	{ 0x1ec0, 0x45 },
	{ 0x1ec1, 0x45 },
	{ 0x1ec2, 0x45 },
	{ 0x1ec3, 0x45 },
	{ 0x1ec4, 0x45 },
	{ 0x1ec5, 0x45 },
	{ 0x1ec6, 0x45 },
	{ 0x1ec7, 0x45 },
	{ 0x1ec8, 0x49 },
	{ 0x1ec9, 0x49 },
	{ 0x1eca, 0x49 },
	{ 0x1ecb, 0x49 },
	{ 0x1ecc, 0x4f },
	{ 0x1ecd, 0x4f },
	{ 0x1ece, 0x4f },
	{ 0x1ecf, 0x4f },
	{ 0x1ed0, 0x4f },
	{ 0x1ed1, 0x4f },
	{ 0x1ed2, 0x4f },
	{ 0x1ed3, 0x4f },
	{ 0x1ed4, 0x4f },
	{ 0x1ed5, 0x4f },
	{ 0x1ed6, 0x4f },
	{ 0x1ed7, 0x4f },
	{ 0x1ed8, 0x4f },
	{ 0x1ed9, 0x4f },
	{ 0x1eda, 0x4f },
	{ 0x1edb, 0x4f },
	{ 0x1edc, 0x4f },
	{ 0x1edd, 0x4f },
	{ 0x1ede, 0x4f },
	{ 0x1edf, 0x4f },
	{ 0x1ee0, 0x4f },
	{ 0x1ee1, 0x4f },
	{ 0x1ee2, 0x4f },
	{ 0x1ee3, 0x4f },
	{ 0x1ee4, 0x55 },
	{ 0x1ee5, 0x55 },
	{ 0x1ee6, 0x55 },
	{ 0x1ee7, 0x55 },
	{ 0x1ee8, 0x55 },
	{ 0x1ee9, 0x55 },
	{ 0x1eea, 0x55 },
	{ 0x1eeb, 0x55 },
	{ 0x1eec, 0x55 },
	{ 0x1eed, 0x55 },
	{ 0x1eee, 0x55 },
	{ 0x1eef, 0x55 },
	{ 0x1ef0, 0x55 },
	{ 0x1ef1, 0x55 },
	{ 0x1ef2, 0x59 },
	{ 0x1ef3, 0x59 },
	{ 0x1ef4, 0x59 },
	{ 0x1ef5, 0x59 },
	{ 0x1ef6, 0x59 },
	{ 0x1ef7, 0x59 },
	{ 0x1ef8, 0x59 },
	{ 0x1ef9, 0x59 },
	{ 0x1efa, 0x4c },
	{ 0x1efb, 0x4c },
	{ 0x1f00, 0x386 },
	{ 0x1f01, 0x386 },
	{ 0x1f02, 0x386 },
	{ 0x1f03, 0x386 },
	{ 0x1f04, 0x386 },
	{ 0x1f05, 0x386 },
	{ 0x1f06, 0x386 },
	{ 0x1f07, 0x386 },
	{ 0x1f08, 0x386 },
	{ 0x1f09, 0x386 },
	{ 0x1f0a, 0x386 },
	{ 0x1f0b, 0x386 },
	{ 0x1f0c, 0x386 },
	{ 0x1f0d, 0x386 },
	{ 0x1f0e, 0x386 },
	{ 0x1f0f, 0x386 },
	{ 0x1f10, 0x388 },
	{ 0x1f11, 0x388 },
	{ 0x1f12, 0x388 },
	{ 0x1f13, 0x388 },
	{ 0x1f14, 0x388 },
	{ 0x1f15, 0x388 },
	{ 0x1f18, 0x388 },
	{ 0x1f19, 0x388 },
	{ 0x1f1a, 0x388 },
	{ 0x1f1b, 0x388 },
	{ 0x1f1c, 0x388 },
	{ 0x1f1d, 0x388 },
	{ 0x1f20, 0x389 },
	{ 0x1f21, 0x389 },
	{ 0x1f22, 0x389 },
	{ 0x1f23, 0x389 },
	{ 0x1f24, 0x389 },
	{ 0x1f25, 0x389 },
	{ 0x1f26, 0x389 },
	{ 0x1f27, 0x389 },
	{ 0x1f28, 0x389 },
	{ 0x1f29, 0x389 },
	{ 0x1f2a, 0x389 },
	{ 0x1f2b, 0x389 },
	{ 0x1f2c, 0x389 },
	{ 0x1f2d, 0x389 },
	{ 0x1f2e, 0x389 },
	{ 0x1f2f, 0x389 },
	{ 0x1f30, 0x37a },
	{ 0x1f31, 0x37a },
	{ 0x1f32, 0x37a },
	{ 0x1f33, 0x37a },
	{ 0x1f34, 0x37a },
	{ 0x1f35, 0x37a },
	{ 0x1f36, 0x37a },
	{ 0x1f37, 0x37a },
	{ 0x1f38, 0x37a },
	{ 0x1f39, 0x37a },
	{ 0x1f3a, 0x37a },
	{ 0x1f3b, 0x37a },
	{ 0x1f3c, 0x37a },
	{ 0x1f3d, 0x37a },
	{ 0x1f3e, 0x37a },
	{ 0x1f3f, 0x37a },
	{ 0x1f40, 0x38c },
	{ 0x1f41, 0x38c },
	{ 0x1f42, 0x38c },
	{ 0x1f43, 0x38c },
	{ 0x1f44, 0x38c },
	{ 0x1f45, 0x38c },
	{ 0x1f48, 0x38c },
	{ 0x1f49, 0x38c },
	{ 0x1f4a, 0x38c },
	{ 0x1f4b, 0x38c },
	{ 0x1f4c, 0x38c },
	{ 0x1f4d, 0x38c },
	{ 0x1f50, 0x38e },
	{ 0x1f51, 0x38e },
	{ 0x1f52, 0x38e },
	{ 0x1f53, 0x38e },
	{ 0x1f54, 0x38e },
	{ 0x1f55, 0x38e },
	{ 0x1f56, 0x38e },
	{ 0x1f57, 0x38e },
	{ 0x1f59, 0x38e },
	{ 0x1f5b, 0x38e },
	{ 0x1f5d, 0x38e },
	{ 0x1f5f, 0x38e },
	{ 0x1f60, 0x38f },
	{ 0x1f61, 0x38f },
	{ 0x1f62, 0x38f },
	{ 0x1f63, 0x38f },
	{ 0x1f64, 0x38f },
	{ 0x1f65, 0x38f },
	{ 0x1f66, 0x38f },
	{ 0x1f67, 0x38f },
	{ 0x1f68, 0x38f },
	{ 0x1f69, 0x38f },
	{ 0x1f6a, 0x38f },
	{ 0x1f6b, 0x38f },
	{ 0x1f6c, 0x38f },
	{ 0x1f6d, 0x38f },
	{ 0x1f6e, 0x38f },
	{ 0x1f6f, 0x38f },
	{ 0x1f70, 0x386 },
	{ 0x1f71, 0x386 },
	{ 0x1f72, 0x388 },
	{ 0x1f73, 0x388 },
	{ 0x1f74, 0x389 },
	{ 0x1f75, 0x389 },
	{ 0x1f76, 0x37a },
	{ 0x1f77, 0x37a },
	{ 0x1f78, 0x38c },
	{ 0x1f79, 0x38c },
	{ 0x1f7a, 0x38e },
	{ 0x1f7b, 0x38e },
	{ 0x1f7c, 0x38f },
	{ 0x1f7d, 0x38f },
	{ 0x1f80, 0x386 },
	{ 0x1f81, 0x386 },
	{ 0x1f82, 0x386 },
	{ 0x1f83, 0x386 },
	{ 0x1f84, 0x386 },
	{ 0x1f85, 0x386 },
	{ 0x1f86, 0x386 },
	{ 0x1f87, 0x386 },
	{ 0x1f88, 0x386 },
	{ 0x1f89, 0x386 },
	{ 0x1f8a, 0x386 },
	{ 0x1f8b, 0x386 },
	{ 0x1f8c, 0x386 },
	{ 0x1f8d, 0x386 },
	{ 0x1f8e, 0x386 },
	{ 0x1f8f, 0x386 },
	{ 0x1f90, 0x389 },
	{ 0x1f91, 0x389 },
	{ 0x1f92, 0x389 },
	{ 0x1f93, 0x389 },
	{ 0x1f94, 0x389 },
	{ 0x1f95, 0x389 },
	{ 0x1f96, 0x389 },
	{ 0x1f97, 0x389 },
	{ 0x1f98, 0x389 },
	{ 0x1f99, 0x389 },
	{ 0x1f9a, 0x389 },
	{ 0x1f9b, 0x389 },
	{ 0x1f9c, 0x389 },
	{ 0x1f9d, 0x389 },
	{ 0x1f9e, 0x389 },
	{ 0x1f9f, 0x389 },
	{ 0x1fa0, 0x38f },
	{ 0x1fa1, 0x38f },
	{ 0x1fa2, 0x38f },
	{ 0x1fa3, 0x38f },
	{ 0x1fa4, 0x38f },
	{ 0x1fa5, 0x38f },
	{ 0x1fa6, 0x38f },
	{ 0x1fa7, 0x38f },
	{ 0x1fa8, 0x38f },
	{ 0x1fa9, 0x38f },
	{ 0x1faa, 0x38f },
	{ 0x1fab, 0x38f },
	{ 0x1fac, 0x38f },
	{ 0x1fad, 0x38f },
	{ 0x1fae, 0x38f },
	{ 0x1faf, 0x38f },
	{ 0x1fb0, 0x386 },
	{ 0x1fb1, 0x386 },
	{ 0x1fb2, 0x386 },
	{ 0x1fb3, 0x386 },
	{ 0x1fb4, 0x386 },
	{ 0x1fb6, 0x386 },
	{ 0x1fb7, 0x386 },
	{ 0x1fb8, 0x386 },
	{ 0x1fb9, 0x386 },
	{ 0x1fba, 0x386 },
	{ 0x1fbb, 0x386 },
	{ 0x1fbc, 0x386 },
	{ 0x1fbe, 0x37a },
	{ 0x1fc2, 0x389 },
	{ 0x1fc3, 0x389 },
	{ 0x1fc4, 0x389 },
	{ 0x1fc6, 0x389 },
	{ 0x1fc7, 0x389 },
	{ 0x1fc8, 0x388 },
	{ 0x1fc9, 0x388 },
	{ 0x1fca, 0x389 },
	{ 0x1fcb, 0x389 },
	{ 0x1fcc, 0x389 },
	{ 0x1fd0, 0x37a },
	{ 0x1fd1, 0x37a },
	{ 0x1fd2, 0x37a },
	{ 0x1fd3, 0x37a },
	{ 0x1fd6, 0x37a },
	{ 0x1fd7, 0x37a },
	{ 0x1fd8, 0x37a },
	{ 0x1fd9, 0x37a },
	{ 0x1fda, 0x37a },
	{ 0x1fdb, 0x37a },
	{ 0x1fe0, 0x38e },
	{ 0x1fe1, 0x38e },
	{ 0x1fe2, 0x38e },
	{ 0x1fe3, 0x38e },
	{ 0x1fe4, 0x3a1 },
	{ 0x1fe5, 0x3a1 },
	{ 0x1fe6, 0x38e },
	{ 0x1fe7, 0x38e },
	{ 0x1fe8, 0x38e },
	{ 0x1fe9, 0x38e },
	{ 0x1fea, 0x38e },
	{ 0x1feb, 0x38e },
	{ 0x1fec, 0x3a1 },
	{ 0x1ff2, 0x38f },
	{ 0x1ff3, 0x38f },
	{ 0x1ff4, 0x38f },
	{ 0x1ff6, 0x38f },
	{ 0x1ff7, 0x38f },
	{ 0x1ff8, 0x38c },
	{ 0x1ff9, 0x38c },
	{ 0x1ffa, 0x38f },
	{ 0x1ffb, 0x38f },
	{ 0x1ffc, 0x38f },
	{ 0x2071, 0x49 },
	{ 0x207f, 0x4e },
	{ 0x2090, 0x41 },
	{ 0x2091, 0x45 },
	{ 0x2092, 0x4f },
	{ 0x2093, 0x58 },
	{ 0x2094, 0x18f },
	{ 0x2095, 0x48 },
	{ 0x2096, 0x4b },
	{ 0x2097, 0x4c },
	{ 0x2098, 0x4d },
	{ 0x2099, 0x4e },
	{ 0x209a, 0x50 },
	{ 0x209b, 0x53 },
	{ 0x209c, 0x54 },
	{ 0x2102, 0x43 },
	{ 0x2107, 0x190 },
	{ 0x210a, 0x47 },
	{ 0x210b, 0x48 },
	{ 0x210c, 0x48 },
	{ 0x210d, 0x48 },
	{ 0x210e, 0x48 },
	{ 0x210f, 0x48 },
	{ 0x2110, 0x49 },
	{ 0x2111, 0x49 },
	{ 0x2112, 0x4c },
	{ 0x2113, 0x4c },
	{ 0x2115, 0x4e },
	{ 0x2119, 0x50 },
	{ 0x211a, 0x51 },
	{ 0x211b, 0x52 },
	{ 0x211c, 0x52 },
	{ 0x211d, 0x52 },
	{ 0x2124, 0x5a },
	{ 0x2126, 0x38f },
	{ 0x2128, 0x5a },
	{ 0x212a, 0x4b },
	{ 0x212b, 0x41 },
	{ 0x212c, 0x42 },
	{ 0x212d, 0x43 },
	{ 0x212f, 0x45 },
	{ 0x2130, 0x45 },
	{ 0x2131, 0x46 },
	{ 0x2133, 0x4d },
	{ 0x2134, 0x4f },
	{ 0x2135, 0x5d0 },
	{ 0x2136, 0x5d1 },
	{ 0x2137, 0x5d2 },
	{ 0x2138, 0x5d3 },
	{ 0x2139, 0x49 },
	{ 0x213c, 0x3a0 },
	{ 0x213d, 0x393 },
	{ 0x213e, 0x393 },
	{ 0x213f, 0x3a0 },
	{ 0x2145, 0x44 },
	{ 0x2146, 0x44 },
	{ 0x2147, 0x45 },
	{ 0x2148, 0x49 },
	{ 0x2149, 0x4a },
	{ 0x2160, 0x49 },
	{ 0x2161, 0x49 },
	{ 0x2162, 0x49 },
	{ 0x2163, 0x49 },
	{ 0x2164, 0x56 },
	{ 0x2165, 0x56 },
	{ 0x2166, 0x56 },
	{ 0x2167, 0x56 },
	{ 0x2168, 0x49 },
	{ 0x2169, 0x58 },
	{ 0x216a, 0x58 },
	{ 0x216b, 0x58 },
	{ 0x216c, 0x4c },
	{ 0x216d, 0x43 },
	{ 0x216e, 0x44 },
	{ 0x216f, 0x4d },
	{ 0x2170, 0x49 },
	{ 0x2171, 0x49 },
	{ 0x2172, 0x49 },
	{ 0x2173, 0x49 },
	{ 0x2174, 0x56 },
	{ 0x2175, 0x56 },
	{ 0x2176, 0x56 },
	{ 0x2177, 0x56 },
	{ 0x2178, 0x49 },
	{ 0x2179, 0x58 },
	{ 0x217a, 0x58 },
	{ 0x217b, 0x58 },
	{ 0x217c, 0x4c },
	{ 0x217d, 0x43 },
	{ 0x217e, 0x44 },
	{ 0x217f, 0x4d },
	{ 0x2185, 0x36 },
	{ 0x24b6, 0x41 },
	{ 0x24b7, 0x42 },
	{ 0x24b8, 0x43 },
	{ 0x24b9, 0x44 },
	{ 0x24ba, 0x45 },
	{ 0x24bb, 0x46 },
	{ 0x24bc, 0x47 },
	{ 0x24bd, 0x48 },
	{ 0x24be, 0x49 },
	{ 0x24bf, 0x4a },
	{ 0x24c0, 0x4b },
	{ 0x24c1, 0x4c },
	{ 0x24c2, 0x4d },
	{ 0x24c3, 0x4e },
	{ 0x24c4, 0x4f },
	{ 0x24c5, 0x50 },
	{ 0x24c6, 0x51 },
	{ 0x24c7, 0x52 },
	{ 0x24c8, 0x53 },
	{ 0x24c9, 0x54 },
	{ 0x24ca, 0x55 },
	{ 0x24cb, 0x56 },
	{ 0x24cc, 0x57 },
	{ 0x24cd, 0x58 },
	{ 0x24ce, 0x59 },
	{ 0x24cf, 0x5a },
	{ 0x24d0, 0x41 },
	{ 0x24d1, 0x42 },
	{ 0x24d2, 0x43 },
	{ 0x24d3, 0x44 },
	{ 0x24d4, 0x45 },
	{ 0x24d5, 0x46 },
	{ 0x24d6, 0x47 },
	{ 0x24d7, 0x48 },
	{ 0x24d8, 0x49 },
	{ 0x24d9, 0x4a },
	{ 0x24da, 0x4b },
	{ 0x24db, 0x4c },
	{ 0x24dc, 0x4d },
	{ 0x24dd, 0x4e },
	{ 0x24de, 0x4f },
	{ 0x24df, 0x50 },
	{ 0x24e0, 0x51 },
	{ 0x24e1, 0x52 },
	{ 0x24e2, 0x53 },
	{ 0x24e3, 0x54 },
	{ 0x24e4, 0x55 },
	{ 0x24e5, 0x56 },
	{ 0x24e6, 0x57 },
	{ 0x24e7, 0x58 },
	{ 0x24e8, 0x59 },
	{ 0x24e9, 0x5a },
	{ 0x2c30, 0x2c00 },
	{ 0x2c31, 0x2c01 },
	{ 0x2c32, 0x2c02 },
	{ 0x2c33, 0x2c03 },
	{ 0x2c34, 0x2c04 },
	{ 0x2c35, 0x2c05 },
	{ 0x2c36, 0x2c06 },
	{ 0x2c38, 0x2c08 },
	{ 0x2c39, 0x2c09 },
	{ 0x2c3a, 0x2c0a },
	{ 0x2c3b, 0x2c0b },
	{ 0x2c3c, 0x2c0c },
	{ 0x2c3d, 0x2c0d },
	{ 0x2c3e, 0x2c0e },
	{ 0x2c3f, 0x2c0f },
	{ 0x2c40, 0x2c10 },
	{ 0x2c41, 0x2c11 },
	{ 0x2c42, 0x2c12 },
	{ 0x2c43, 0x2c13 },
	{ 0x2c44, 0x2c14 },
	{ 0x2c45, 0x2c15 },
	{ 0x2c46, 0x2c16 },
	{ 0x2c47, 0x2c17 },
	{ 0x2c48, 0x2c18 },
	{ 0x2c4b, 0x2c1b },
	{ 0x2c4c, 0x2c1c },
	{ 0x2c4d, 0x2c1d },
	{ 0x2c4e, 0x2c1e },
	{ 0x2c4f, 0x2c1f },
	{ 0x2c50, 0x2c20 },
	{ 0x2c51, 0x2c21 },
	{ 0x2c53, 0x2c23 },
	{ 0x2c54, 0x2c24 },
	{ 0x2c56, 0x2c26 },
	{ 0x2c57, 0x2c27 },
	{ 0x2c58, 0x2c28 },
	{ 0x2c59, 0x2c29 },
	{ 0x2c5a, 0x2c2a },
	{ 0x2c62, 0x26b },
	{ 0x2c6d, 0x251 },
	{ 0x2c6e, 0x271 },
	{ 0x2c6f, 0x250 },
	{ 0x2c70, 0x252 },
	{ 0x2c7c, 0x4a },
	{ 0x2c7d, 0x56 },
	{ 0x2c95, 0x2c94 },
	{ 0x2ce4, 0x2c94 },
	{ 0x2de0, 0x411 },
	{ 0x2de1, 0x412 },
	{ 0x2de2, 0x403 },
	{ 0x2de3, 0x414 },
	{ 0x2de4, 0x416 },
	{ 0x2de5, 0x417 },
	{ 0x2de6, 0x40c },
	{ 0x2de7, 0x41b },
	{ 0x2de8, 0x41c },
	{ 0x2de9, 0x41d },
	{ 0x2dea, 0x41e },
	{ 0x2deb, 0x41f },
	{ 0x2dec, 0x420 },
	{ 0x2ded, 0x421 },
	{ 0x2dee, 0x422 },
	{ 0x2def, 0x425 },
	{ 0x2df0, 0x426 },
	{ 0x2df1, 0x427 },
	{ 0x2df2, 0x428 },
	{ 0x2df3, 0x429 },
	{ 0x2df4, 0x472 },
	{ 0x2df5, 0x421 },
	{ 0x2df6, 0x410 },
	{ 0x2df7, 0x400 },
	{ 0x2df9, 0x1c88 },
	{ 0x2dfa, 0x462 },
	{ 0x2dfb, 0x42e },
	{ 0x2dfd, 0x466 },
	{ 0x2dfe, 0x46a },
	{ 0x2dff, 0x46c },
	{ 0x3007, 0x30 },
	{ 0x3021, 0x31 },
	{ 0x3022, 0x32 },
	{ 0x3023, 0x33 },
	{ 0x3024, 0x34 },
	{ 0x3025, 0x35 },
	{ 0x3026, 0x36 },
	{ 0x3027, 0x37 },
	{ 0x3028, 0x38 },
	{ 0x3029, 0x39 },
	{ 0x3042, 0x3041 },
	{ 0x3044, 0x3043 },
	{ 0x3046, 0x3045 },
	{ 0x3048, 0x3047 },
	{ 0x304a, 0x3049 },
	{ 0x304c, 0x304b },
	{ 0x304e, 0x304d },
	{ 0x3050, 0x304f },
	{ 0x3052, 0x3051 },
	{ 0x3054, 0x3053 },
	{ 0x3056, 0x3055 },
	{ 0x3057, 0x3006 },
	{ 0x3058, 0x3006 },
	{ 0x305a, 0x3059 },
	{ 0x305c, 0x305b },
	{ 0x305e, 0x305d },
	{ 0x3060, 0x305f },
	{ 0x3062, 0x3061 },
	{ 0x3064, 0x3063 },
	{ 0x3065, 0x3063 },
	{ 0x3067, 0x3066 },
	{ 0x3069, 0x3068 },
	{ 0x3070, 0x306f },
	{ 0x3071, 0x306f },
	{ 0x3073, 0x3072 },
	{ 0x3074, 0x3072 },
	{ 0x3076, 0x3075 },
	{ 0x3077, 0x3075 },
	{ 0x3079, 0x3078 },
	{ 0x307a, 0x3078 },
	{ 0x307c, 0x307b },
	{ 0x307d, 0x307b },
	{ 0x307e, 0x303c },
	{ 0x3084, 0x3083 },
	{ 0x3086, 0x3085 },
	{ 0x3088, 0x3087 },
	{ 0x308f, 0x308e },
	{ 0x3094, 0x3045 },
	{ 0x3095, 0x304b },
	{ 0x3096, 0x3051 },
	{ 0x309f, 0x3087 },
	{ 0x30a1, 0x3041 },
	{ 0x30a2, 0x3041 },
	{ 0x30a3, 0x3043 },
	{ 0x30a4, 0x3043 },
	{ 0x30a5, 0x3045 },
	{ 0x30a6, 0x3045 },
	{ 0x30a7, 0x3047 },
	{ 0x30a8, 0x3047 },
	{ 0x30a9, 0x3049 },
	{ 0x30aa, 0x3049 },
	{ 0x30ab, 0x304b },
	{ 0x30ac, 0x304b },
	{ 0x30ad, 0x304d },
	{ 0x30ae, 0x304d },
	{ 0x30af, 0x304f },
	{ 0x30b0, 0x304f },
	{ 0x30b1, 0x3051 },
	{ 0x30b2, 0x3051 },
	{ 0x30b3, 0x3053 },
	{ 0x30b4, 0x3053 },
	{ 0x30b5, 0x3055 },
	{ 0x30b6, 0x3055 },
	{ 0x30b7, 0x3006 },
	{ 0x30b8, 0x3006 },
	{ 0x30b9, 0x3059 },
	{ 0x30ba, 0x3059 },
	{ 0x30bb, 0x305b },
	{ 0x30bc, 0x305b },
	{ 0x30bd, 0x305d },
	{ 0x30be, 0x305d },
	{ 0x30bf, 0x305f },
	{ 0x30c0, 0x305f },
	{ 0x30c1, 0x3061 },
	{ 0x30c2, 0x3061 },
	{ 0x30c3, 0x3063 },
	{ 0x30c4, 0x3063 },
	{ 0x30c5, 0x3063 },
	{ 0x30c6, 0x3066 },
	{ 0x30c7, 0x3066 },
	{ 0x30c8, 0x3068 },
	{ 0x30c9, 0x3068 },
	{ 0x30ca, 0x306a },
	{ 0x30cb, 0x306b },
	{ 0x30cc, 0x306c },
	{ 0x30cd, 0x306d },
	{ 0x30ce, 0x306e },
	{ 0x30cf, 0x306f },
	{ 0x30d0, 0x306f },
	{ 0x30d1, 0x306f },
	{ 0x30d2, 0x3072 },
	{ 0x30d3, 0x3072 },
	{ 0x30d4, 0x3072 },
	{ 0x30d5, 0x3075 },
	{ 0x30d6, 0x3075 },
	{ 0x30d7, 0x3075 },
	{ 0x30d8, 0x3078 },
	{ 0x30d9, 0x3078 },
	{ 0x30da, 0x3078 },
	{ 0x30db, 0x307b },
	{ 0x30dc, 0x307b },
	{ 0x30dd, 0x307b },
	{ 0x30de, 0x303c },
	{ 0x30df, 0x307f },
	{ 0x30e0, 0x3080 },
	{ 0x30e1, 0x3081 },
	{ 0x30e2, 0x3082 },
	{ 0x30e3, 0x3083 },
	{ 0x30e4, 0x3083 },
	{ 0x30e5, 0x3085 },
	{ 0x30e6, 0x3085 },
	{ 0x30e7, 0x3087 },
	{ 0x30e8, 0x3087 },
	{ 0x30e9, 0x3089 },
	{ 0x30ea, 0x308a },
	{ 0x30eb, 0x308b },
	{ 0x30ec, 0x308c },
	{ 0x30ed, 0x308d },
	{ 0x30ee, 0x308e },
	{ 0x30ef, 0x308e },
	{ 0x30f0, 0x3090 },
	{ 0x30f1, 0x3091 },
	{ 0x30f2, 0x3092 },
	{ 0x30f3, 0x3093 },
	{ 0x30f4, 0x3045 },
	{ 0x30f5, 0x304b },
	{ 0x30f6, 0x3051 },
	{ 0x30f7, 0x308e },
	{ 0x30f8, 0x3090 },
	{ 0x30f9, 0x3091 },
	{ 0x30fa, 0x3092 },
	{ 0x30ff, 0x3053 },
	{ 0x3131, 0x1100 },
	{ 0x3132, 0x1101 },
	{ 0x3133, 0x11aa },
	{ 0x3134, 0x1102 },
	{ 0x3135, 0x11ac },
	{ 0x3136, 0x11ad },
	{ 0x3137, 0x1103 },
	{ 0x3138, 0x1104 },
	{ 0x3139, 0x1105 },
	{ 0x313a, 0x11b0 },
	{ 0x313b, 0x11b1 },
	{ 0x313c, 0x11b2 },
	{ 0x313d, 0x11b3 },
	{ 0x313e, 0x11b4 },
	{ 0x313f, 0x11b5 },
	{ 0x3140, 0x111a },
	{ 0x3141, 0x1106 },
	{ 0x3142, 0x1107 },
	{ 0x3143, 0x1108 },
	{ 0x3144, 0x1121 },
	{ 0x3145, 0x1109 },
	{ 0x3146, 0x110a },
	{ 0x3147, 0x110b },
	{ 0x3148, 0x110c },
	{ 0x3149, 0x110d },
	{ 0x314a, 0x110e },
	{ 0x314b, 0x110f },
	{ 0x314c, 0x1110 },
	{ 0x314d, 0x1111 },
	{ 0x314e, 0x1112 },
	{ 0x314f, 0x1161 },
	{ 0x3150, 0x1162 },
	{ 0x3151, 0x1163 },
	{ 0x3152, 0x1164 },
	{ 0x3153, 0x1165 },
	{ 0x3154, 0x1166 },
	{ 0x3155, 0x1167 },
	{ 0x3156, 0x1168 },
	{ 0x3157, 0x1169 },
	{ 0x3158, 0x116a },
	{ 0x3159, 0x116b },
	{ 0x315a, 0x116c },
	{ 0x315b, 0x116d },
	{ 0x315c, 0x116e },
	{ 0x315d, 0x116f },
	{ 0x315e, 0x1170 },
	{ 0x315f, 0x1171 },
	{ 0x3160, 0x1172 },
	{ 0x3161, 0x1173 },
	{ 0x3162, 0x1174 },
	{ 0x3163, 0x1175 },
	{ 0x3164, 0x1160 },
	{ 0x31a8, 0x3128 },
	{ 0x31aa, 0x3127 },
	{ 0x31ab, 0x3128 },
	{ 0x31b3, 0x3127 },
	{ 0x31f0, 0x304f },
	{ 0x31f1, 0x3006 },
	{ 0x31f2, 0x3059 },
	{ 0x31f3, 0x3068 },
	{ 0x31f4, 0x306c },
	{ 0x31f5, 0x306f },
	{ 0x31f6, 0x3072 },
	{ 0x31f7, 0x3075 },
	{ 0x31f8, 0x3078 },
	{ 0x31f9, 0x307b },
	{ 0x31fa, 0x3080 },
	{ 0x31fb, 0x3089 },
	{ 0x31fc, 0x308a },
	{ 0x31fd, 0x308b },
	{ 0x31fe, 0x308c },
	{ 0x31ff, 0x308d },
	{ 0xa610, 0xa558 },
	{ 0xa618, 0xa558 },
	{ 0xa61e, 0xa5d1 },
	{ 0xa620, 0x30 },
	{ 0xa621, 0x31 },
	{ 0xa622, 0x32 },
	{ 0xa623, 0x33 },
	{ 0xa624, 0x34 },
	{ 0xa625, 0x35 },
	{ 0xa626, 0x36 },
	{ 0xa627, 0x37 },
	{ 0xa628, 0x38 },
	{ 0xa629, 0x39 },
	{ 0xa62b, 0xa5d1 },
	{ 0xa648, 0x2df8 },
	{ 0xa649, 0x2df8 },
	{ 0xa64a, 0x1c88 },
	{ 0xa64b, 0x1c88 },
	{ 0xa656, 0x2dfc },
	{ 0xa657, 0x2dfc },
	{ 0xa668, 0x41e },
	{ 0xa669, 0x41e },
	{ 0xa66a, 0x41e },
	{ 0xa66b, 0x41e },
	{ 0xa66c, 0x41e },
	{ 0xa66d, 0x41e },
	{ 0xa66e, 0x41e },
	{ 0xa674, 0x404 },
	{ 0xa675, 0x40d },
	{ 0xa676, 0x406 },
	{ 0xa677, 0x40e },
	{ 0xa678, 0x42a },
	{ 0xa679, 0x42b },
	{ 0xa67a, 0x42c },
	{ 0xa67b, 0x460 },
	{ 0xa698, 0x41e },
	{ 0xa699, 0x41e },
	{ 0xa69a, 0x41e },
	{ 0xa69b, 0x41e },
	{ 0xa69c, 0x42a },
	{ 0xa69d, 0x42c },
	{ 0xa69e, 0x424 },
	{ 0xa69f, 0x464 },
	{ 0xa727, 0xa726 },
	{ 0xa728, 0x54 },
	{ 0xa729, 0x54 },
	{ 0xa732, 0x41 },
	{ 0xa733, 0x41 },
	{ 0xa734, 0x41 },
	{ 0xa735, 0x41 },
	{ 0xa736, 0x41 },
	{ 0xa737, 0x41 },
	{ 0xa738, 0x41 },
	{ 0xa739, 0x41 },
	{ 0xa73a, 0x41 },
	{ 0xa73b, 0x41 },
	{ 0xa73c, 0x41 },
	{ 0xa73d, 0x41 },
	{ 0xa74e, 0x4f },
	{ 0xa74f, 0x4f },
	{ 0xa760, 0x56 },
	{ 0xa761, 0x56 },
	{ 0xa779, 0x44 },
	{ 0xa77a, 0x44 },
	{ 0xa77b, 0x46 },
	{ 0xa77c, 0x46 },
	{ 0xa77d, 0x47 },
	{ 0xa782, 0x52 },
	{ 0xa783, 0x52 },
	{ 0xa784, 0x53 },
	{ 0xa785, 0x53 },
	{ 0xa786, 0x54 },
	{ 0xa787, 0x54 },
	{ 0xa78d, 0x265 },
	{ 0xa79a, 0x41 },
	{ 0xa79b, 0x41 },
	{ 0xa79c, 0x4f },
	{ 0xa79d, 0x4f },
	{ 0xa79e, 0x55 },
	{ 0xa79f, 0x55 },
	{ 0xa7a0, 0x47 },
	{ 0xa7a1, 0x47 },
	{ 0xa7a2, 0x4b },
	{ 0xa7a3, 0x4b },
	{ 0xa7a4, 0x4e },
	{ 0xa7a5, 0x4e },
	{ 0xa7a6, 0x52 },
	{ 0xa7a7, 0x52 },
	{ 0xa7a8, 0x53 },
	{ 0xa7a9, 0x53 },
	{ 0xa7aa, 0x266 },
	{ 0xa7ab, 0x25c },
	{ 0xa7ac, 0x261 },
	{ 0xa7ae, 0x26a },
	{ 0xa7b2, 0x29d },
	{ 0xa7b4, 0x1de9 },
	{ 0xa7b5, 0x1de9 },
	{ 0xa7f8, 0x48 },
	{ 0xa7f9, 0x4f },
	{ 0xa8d0, 0x30 },
	{ 0xa8d1, 0x31 },
	{ 0xa8d2, 0x32 },
	{ 0xa8d3, 0x33 },
	{ 0xa8d4, 0x34 },
	{ 0xa8d5, 0x35 },
	{ 0xa8d6, 0x36 },
	{ 0xa8d7, 0x37 },
	{ 0xa8d8, 0x38 },
	{ 0xa8d9, 0x39 },
	{ 0xa8f3, 0xa8f2 },
	{ 0xa8f4, 0xa8f2 },
	{ 0xa8f5, 0xa8f2 },
	{ 0xa8f6, 0xa8f2 },
	{ 0xa8f7, 0xa8f2 },
	{ 0xa900, 0x30 },
	{ 0xa901, 0x31 },
	{ 0xa902, 0x32 },
	{ 0xa903, 0x33 },
	{ 0xa904, 0x34 },
	{ 0xa905, 0x35 },
	{ 0xa906, 0x36 },
	{ 0xa907, 0x37 },
	{ 0xa908, 0x38 },
	{ 0xa909, 0x39 },
	{ 0xa9d0, 0x30 },
	{ 0xa9d1, 0x31 },
	{ 0xa9d2, 0x32 },
	{ 0xa9d3, 0x33 },
	{ 0xa9d4, 0x34 },
	{ 0xa9d5, 0x35 },
	{ 0xa9d6, 0x36 },
	{ 0xa9d7, 0x37 },
	{ 0xa9d8, 0x38 },
	{ 0xa9d9, 0x39 },
	{ 0xa9f0, 0x30 },
	{ 0xa9f1, 0x31 },
	{ 0xa9f2, 0x32 },
	{ 0xa9f3, 0x33 },
	{ 0xa9f4, 0x34 },
	{ 0xa9f5, 0x35 },
	{ 0xa9f6, 0x36 },
	{ 0xa9f7, 0x37 },
	{ 0xa9f8, 0x38 },
	{ 0xa9f9, 0x39 },
	{ 0xaa50, 0x30 },
	{ 0xaa51, 0x31 },
	{ 0xaa52, 0x32 },
	{ 0xaa53, 0x33 },
	{ 0xaa54, 0x34 },
	{ 0xaa55, 0x35 },
	{ 0xaa56, 0x36 },
	{ 0xaa57, 0x37 },
	{ 0xaa58, 0x38 },
	{ 0xaa59, 0x39 },
	{ 0xab5c, 0xa726 },
	{ 0xab5e, 0x26b },
	{ 0xabf0, 0x30 },
	{ 0xabf1, 0x31 },
	{ 0xabf2, 0x32 },
	{ 0xabf3, 0x33 },
	{ 0xabf4, 0x34 },
	{ 0xabf5, 0x35 },
	{ 0xabf6, 0x36 },
	{ 0xabf7, 0x37 },
	{ 0xabf8, 0x38 },
	{ 0xabf9, 0x39 },
	{ 0xfacf, 0xfa6c },
	{ 0xfad0, 0xfa6c },
	{ 0xfad1, 0xfa6c },
	{ 0xfad3, 0xfad2 },
	{ 0xfad4, 0xfad2 },
	{ 0xfad5, 0xfa6c },
	{ 0xfad6, 0xfa6c },
	{ 0xfad7, 0xfa6c },
	{ 0xfb00, 0x46 },
	{ 0xfb01, 0x46 },
	{ 0xfb02, 0x46 },
	{ 0xfb03, 0x46 },
	{ 0xfb04, 0x46 },
	{ 0xfb05, 0x53 },
	{ 0xfb06, 0x53 },
	{ 0xfb13, 0x544 },
	{ 0xfb14, 0x544 },
	{ 0xfb15, 0x544 },
	{ 0xfb16, 0x54e },
	{ 0xfb17, 0x544 },
	{ 0xfb1d, 0x5d9 },
	{ 0xfb1f, 0x5d9 },
	{ 0xfb21, 0x5d0 },
	{ 0xfb22, 0x5d3 },
	{ 0xfb23, 0x5d4 },
	{ 0xfb24, 0x5da },
	{ 0xfb25, 0x5dc },
	{ 0xfb26, 0x5dd },
	{ 0xfb27, 0x5e8 },
	{ 0xfb28, 0x5ea },
	{ 0xfb2a, 0x5e9 },
	{ 0xfb2b, 0x5e9 },
	{ 0xfb2c, 0x5e9 },
	{ 0xfb2d, 0x5e9 },
	{ 0xfb2e, 0x5d0 },
	{ 0xfb2f, 0x5d0 },
	{ 0xfb30, 0x5d0 },
	{ 0xfb31, 0x5d1 },
	{ 0xfb32, 0x5d2 },
	{ 0xfb33, 0x5d3 },
	{ 0xfb34, 0x5d4 },
	{ 0xfb35, 0x5d5 },
	{ 0xfb39, 0x5d9 },
	{ 0xfb3a, 0x5da },
	{ 0xfb3b, 0x5da },
	{ 0xfb3c, 0x5dc },
	{ 0xfb3e, 0x5dd },
	{ 0xfb40, 0x5df },
	{ 0xfb43, 0x5e3 },
	{ 0xfb44, 0x5e3 },
	{ 0xfb46, 0x5e5 },
	{ 0xfb48, 0x5e8 },
	{ 0xfb49, 0x5e9 },
	{ 0xfb4a, 0x5ea },
	{ 0xfb4b, 0x5d5 },
	{ 0xfb4c, 0x5d1 },
	{ 0xfb4d, 0x5da },
	{ 0xfb4e, 0x5e3 },
	{ 0xfb4f, 0x5d0 },
	{ 0xfb50, 0x671 },
	{ 0xfb51, 0x671 },
	{ 0xfb52, 0x67b },
	{ 0xfb53, 0x67b },
	{ 0xfb54, 0x67b },
	{ 0xfb55, 0x67b },
	{ 0xfb56, 0x67e },
	{ 0xfb57, 0x67e },
	{ 0xfb58, 0x67e },
	{ 0xfb59, 0x67e },
	{ 0xfb5a, 0x680 },
	{ 0xfb5b, 0x680 },
	{ 0xfb5c, 0x680 },
	{ 0xfb5d, 0x680 },
	{ 0xfb5e, 0x67a },
	{ 0xfb5f, 0x67a },
	{ 0xfb60, 0x67a },
	{ 0xfb61, 0x67a },
	{ 0xfb62, 0x67f },
	{ 0xfb63, 0x67f },
	{ 0xfb64, 0x67f },
	{ 0xfb65, 0x67f },
	{ 0xfb66, 0x679 },
	{ 0xfb67, 0x679 },
	{ 0xfb68, 0x679 },
	{ 0xfb69, 0x679 },
	{ 0xfb6a, 0x6a4 },
	{ 0xfb6b, 0x6a4 },
	{ 0xfb6c, 0x6a4 },
	{ 0xfb6d, 0x6a4 },
	{ 0xfb6e, 0x6a6 },
	{ 0xfb6f, 0x6a6 },
	{ 0xfb70, 0x6a6 },
	{ 0xfb71, 0x6a6 },
	{ 0xfb72, 0x684 },
	{ 0xfb73, 0x684 },
	{ 0xfb74, 0x684 },
	{ 0xfb75, 0x684 },
	{ 0xfb76, 0x683 },
	{ 0xfb77, 0x683 },
	{ 0xfb78, 0x683 },
	{ 0xfb79, 0x683 },
	{ 0xfb7a, 0x686 },
	{ 0xfb7b, 0x686 },
	{ 0xfb7c, 0x686 },
	{ 0xfb7d, 0x686 },
	{ 0xfb7e, 0x687 },
	{ 0xfb7f, 0x687 },
	{ 0xfb80, 0x687 },
	{ 0xfb81, 0x687 },
	{ 0xfb82, 0x68d },
	{ 0xfb83, 0x68d },
	{ 0xfb84, 0x68c },
	{ 0xfb85, 0x68c },
	{ 0xfb86, 0x68e },
	{ 0xfb87, 0x68e },
	{ 0xfb88, 0x688 },
	{ 0xfb89, 0x688 },
	{ 0xfb8a, 0x698 },
	{ 0xfb8b, 0x698 },
	{ 0xfb8c, 0x691 },
	{ 0xfb8d, 0x691 },
	{ 0xfb8e, 0x6a9 },
	{ 0xfb8f, 0x6a9 },
	{ 0xfb90, 0x6a9 },
	{ 0xfb91, 0x6a9 },
	{ 0xfb92, 0x6af },
	{ 0xfb93, 0x6af },
	{ 0xfb94, 0x6af },
	{ 0xfb95, 0x6af },
	{ 0xfb96, 0x6b3 },
	{ 0xfb97, 0x6b3 },
	{ 0xfb98, 0x6b3 },
	{ 0xfb99, 0x6b3 },
	{ 0xfb9a, 0x6b1 },
	{ 0xfb9b, 0x6b1 },
	{ 0xfb9c, 0x6b1 },
	{ 0xfb9d, 0x6b1 },
	{ 0xfb9e, 0x6ba },
	{ 0xfb9f, 0x6ba },
	{ 0xfba0, 0x6bb },
	{ 0xfba1, 0x6bb },
	{ 0xfba2, 0x6bb },
	{ 0xfba3, 0x6bb },
	{ 0xfba4, 0x6c0 },
	{ 0xfba5, 0x6c0 },
	{ 0xfba6, 0x6c1 },
	{ 0xfba7, 0x6c1 },
	{ 0xfba8, 0x6c1 },
	{ 0xfba9, 0x6c1 },
	{ 0xfbaa, 0x6be },
	{ 0xfbab, 0x6be },
	{ 0xfbac, 0x6be },
	{ 0xfbad, 0x6be },
	{ 0xfbae, 0x6d2 },
	{ 0xfbaf, 0x6d2 },
	{ 0xfbb0, 0x6d2 },
	{ 0xfbb1, 0x6d2 },
	{ 0xfbd3, 0x6ad },
	{ 0xfbd4, 0x6ad },
	{ 0xfbd5, 0x6ad },
	{ 0xfbd6, 0x6ad },
	{ 0xfbd7, 0x677 },
	{ 0xfbd8, 0x677 },
	{ 0xfbd9, 0x6c6 },
	{ 0xfbda, 0x6c6 },
	{ 0xfbdb, 0x6c8 },
	{ 0xfbdc, 0x6c8 },
	{ 0xfbdd, 0x677 },
	{ 0xfbde, 0x6cb },
	{ 0xfbdf, 0x6cb },
	{ 0xfbe0, 0x6c5 },
	{ 0xfbe1, 0x6c5 },
	{ 0xfbe2, 0x6c9 },
	{ 0xfbe3, 0x6c9 },
	{ 0xfbe4, 0x6d0 },
	{ 0xfbe5, 0x6d0 },
	{ 0xfbe6, 0x6d0 },
	{ 0xfbe7, 0x6d0 },
	{ 0xfbe8, 0x649 },
	{ 0xfbe9, 0x649 },
	{ 0xfbea, 0x626 },
	{ 0xfbeb, 0x626 },
	{ 0xfbec, 0x626 },
	{ 0xfbed, 0x626 },
	{ 0xfbee, 0x626 },
	{ 0xfbef, 0x626 },
	{ 0xfbf0, 0x626 },
	{ 0xfbf1, 0x626 },
	{ 0xfbf2, 0x626 },
	{ 0xfbf3, 0x626 },
	{ 0xfbf4, 0x626 },
	{ 0xfbf5, 0x626 },
	{ 0xfbf6, 0x626 },
	{ 0xfbf7, 0x626 },
	{ 0xfbf8, 0x626 },
	{ 0xfbf9, 0x626 },
	{ 0xfbfa, 0x626 },
	{ 0xfbfb, 0x626 },
	{ 0xfbfc, 0x6cc },
	{ 0xfbfd, 0x6cc },
	{ 0xfbfe, 0x6cc },
	{ 0xfbff, 0x6cc },
	{ 0xfc00, 0x626 },
	{ 0xfc01, 0x626 },
	{ 0xfc02, 0x626 },
	{ 0xfc03, 0x626 },
	{ 0xfc04, 0x626 },
	{ 0xfc05, 0x628 },
	{ 0xfc06, 0x628 },
	{ 0xfc07, 0x628 },
	{ 0xfc08, 0x628 },
	{ 0xfc09, 0x628 },
	{ 0xfc0a, 0x628 },
	{ 0xfc0b, 0x62a },
	{ 0xfc0c, 0x62a },
	{ 0xfc0d, 0x62a },
	{ 0xfc0e, 0x62a },
	{ 0xfc0f, 0x62a },
	{ 0xfc10, 0x62a },
	{ 0xfc11, 0x62b },
	{ 0xfc12, 0x62b },
	{ 0xfc13, 0x62b },
	{ 0xfc14, 0x62b },
	{ 0xfc15, 0x62c },
	{ 0xfc16, 0x62c },
	{ 0xfc17, 0x62d },
	{ 0xfc18, 0x62d },
	{ 0xfc19, 0x62e },
	{ 0xfc1a, 0x62e },
	{ 0xfc1b, 0x62e },
	{ 0xfc1c, 0x633 },
	{ 0xfc1d, 0x633 },
	{ 0xfc1e, 0x633 },
	{ 0xfc1f, 0x633 },
	{ 0xfc20, 0x635 },
	{ 0xfc21, 0x635 },
	{ 0xfc22, 0x636 },
	{ 0xfc23, 0x636 },
	{ 0xfc24, 0x636 },
	{ 0xfc25, 0x636 },
	{ 0xfc26, 0x637 },
	{ 0xfc27, 0x637 },
	{ 0xfc28, 0x638 },
	{ 0xfc29, 0x639 },
	{ 0xfc2a, 0x639 },
	{ 0xfc2b, 0x63a },
	{ 0xfc2c, 0x63a },
	{ 0xfc2d, 0x641 },
	{ 0xfc2e, 0x641 },
	{ 0xfc2f, 0x641 },
	{ 0xfc30, 0x641 },
	{ 0xfc31, 0x641 },
	{ 0xfc32, 0x641 },
	{ 0xfc33, 0x642 },
	{ 0xfc34, 0x642 },
	{ 0xfc35, 0x642 },
	{ 0xfc36, 0x642 },
	{ 0xfc37, 0x643 },
	{ 0xfc38, 0x643 },
	{ 0xfc39, 0x643 },
	{ 0xfc3a, 0x643 },
	{ 0xfc3b, 0x643 },
	{ 0xfc3c, 0x643 },
	{ 0xfc3d, 0x643 },
	{ 0xfc3e, 0x643 },
	{ 0xfc3f, 0x644 },
	{ 0xfc40, 0x644 },
	{ 0xfc41, 0x644 },
	{ 0xfc42, 0x644 },
	{ 0xfc43, 0x644 },
	{ 0xfc44, 0x644 },
	{ 0xfc45, 0x645 },
	{ 0xfc46, 0x645 },
	{ 0xfc47, 0x645 },
	{ 0xfc48, 0x645 },
	{ 0xfc49, 0x645 },
	{ 0xfc4a, 0x645 },
	{ 0xfc4b, 0x646 },
	{ 0xfc4c, 0x646 },
	{ 0xfc4d, 0x646 },
	{ 0xfc4e, 0x646 },
	{ 0xfc4f, 0x646 },
	{ 0xfc50, 0x646 },
	{ 0xfc51, 0x647 },
	{ 0xfc52, 0x647 },
	{ 0xfc53, 0x647 },
	{ 0xfc54, 0x647 },
	{ 0xfc55, 0x64a },
	{ 0xfc56, 0x64a },
	{ 0xfc57, 0x64a },
	{ 0xfc58, 0x64a },
	{ 0xfc59, 0x64a },
	{ 0xfc5a, 0x64a },
	{ 0xfc5b, 0x630 },
	{ 0xfc5c, 0x631 },
	{ 0xfc5d, 0x649 },
	{ 0xfc64, 0x626 },
	{ 0xfc65, 0x626 },
	{ 0xfc66, 0x626 },
	{ 0xfc67, 0x626 },
	{ 0xfc68, 0x626 },
	{ 0xfc69, 0x626 },
	{ 0xfc6a, 0x628 },
	{ 0xfc6b, 0x628 },
	{ 0xfc6c, 0x628 },
	{ 0xfc6d, 0x628 },
	{ 0xfc6e, 0x628 },
	{ 0xfc6f, 0x628 },
	{ 0xfc70, 0x62a },
	{ 0xfc71, 0x62a },
	{ 0xfc72, 0x62a },
	{ 0xfc73, 0x62a },
	{ 0xfc74, 0x62a },
	{ 0xfc75, 0x62a },
	{ 0xfc76, 0x62b },
	{ 0xfc77, 0x62b },
	{ 0xfc78, 0x62b },
	{ 0xfc79, 0x62b },
	{ 0xfc7a, 0x62b },
	{ 0xfc7b, 0x62b },
	{ 0xfc7c, 0x641 },
	{ 0xfc7d, 0x641 },
	{ 0xfc7e, 0x642 },
	{ 0xfc7f, 0x642 },
	{ 0xfc80, 0x643 },
	{ 0xfc81, 0x643 },
	{ 0xfc82, 0x643 },
	{ 0xfc83, 0x643 },
	{ 0xfc84, 0x643 },
	{ 0xfc85, 0x644 },
	{ 0xfc86, 0x644 },
	{ 0xfc87, 0x644 },
	{ 0xfc88, 0x645 },
	{ 0xfc89, 0x645 },
	{ 0xfc8a, 0x646 },
	{ 0xfc8b, 0x646 },
	{ 0xfc8c, 0x646 },
	{ 0xfc8d, 0x646 },
	{ 0xfc8e, 0x646 },
	{ 0xfc8f, 0x646 },
	{ 0xfc90, 0x649 },
	{ 0xfc91, 0x64a },
	{ 0xfc92, 0x64a },
	{ 0xfc93, 0x64a },
	{ 0xfc94, 0x64a },
	{ 0xfc95, 0x64a },
	{ 0xfc96, 0x64a },
	{ 0xfc97, 0x626 },
	{ 0xfc98, 0x626 },
	{ 0xfc99, 0x626 },
	{ 0xfc9a, 0x626 },
	{ 0xfc9b, 0x626 },
	{ 0xfc9c, 0x628 },
	{ 0xfc9d, 0x628 },
	{ 0xfc9e, 0x628 },
	{ 0xfc9f, 0x628 },
	{ 0xfca0, 0x628 },
	{ 0xfca1, 0x62a },
	{ 0xfca2, 0x62a },
	{ 0xfca3, 0x62a },
	{ 0xfca4, 0x62a },
	{ 0xfca5, 0x62a },
	{ 0xfca6, 0x62b },
	{ 0xfca7, 0x62c },
	{ 0xfca8, 0x62c },
	{ 0xfca9, 0x62d },
	{ 0xfcaa, 0x62d },
	{ 0xfcab, 0x62e },
	{ 0xfcac, 0x62e },
	{ 0xfcad, 0x633 },
	{ 0xfcae, 0x633 },
	{ 0xfcaf, 0x633 },
	{ 0xfcb0, 0x633 },
	{ 0xfcb1, 0x635 },
	{ 0xfcb2, 0x635 },
	{ 0xfcb3, 0x635 },
	{ 0xfcb4, 0x636 },
	{ 0xfcb5, 0x636 },
	{ 0xfcb6, 0x636 },
	{ 0xfcb7, 0x636 },
	{ 0xfcb8, 0x637 },
	{ 0xfcb9, 0x638 },
	{ 0xfcba, 0x639 },
	{ 0xfcbb, 0x639 },
	{ 0xfcbc, 0x63a },
	{ 0xfcbd, 0x63a },
	{ 0xfcbe, 0x641 },
	{ 0xfcbf, 0x641 },
	{ 0xfcc0, 0x641 },
	{ 0xfcc1, 0x641 },
	{ 0xfcc2, 0x642 },
	{ 0xfcc3, 0x642 },
	{ 0xfcc4, 0x643 },
	{ 0xfcc5, 0x643 },
	{ 0xfcc6, 0x643 },
	{ 0xfcc7, 0x643 },
	{ 0xfcc8, 0x643 },
	{ 0xfcc9, 0x644 },
	{ 0xfcca, 0x644 },
	{ 0xfccb, 0x644 },
	{ 0xfccc, 0x644 },
	{ 0xfccd, 0x644 },
	{ 0xfcce, 0x645 },
	{ 0xfccf, 0x645 },
	{ 0xfcd0, 0x645 },
	{ 0xfcd1, 0x645 },
	{ 0xfcd2, 0x646 },
	{ 0xfcd3, 0x646 },
	{ 0xfcd4, 0x646 },
	{ 0xfcd5, 0x646 },
	{ 0xfcd6, 0x646 },
	{ 0xfcd7, 0x647 },
	{ 0xfcd8, 0x647 },
	{ 0xfcd9, 0x647 },
	{ 0xfcda, 0x64a },
	{ 0xfcdb, 0x64a },
	{ 0xfcdc, 0x64a },
	{ 0xfcdd, 0x64a },
	{ 0xfcde, 0x64a },
	{ 0xfcdf, 0x626 },
	{ 0xfce0, 0x626 },
	{ 0xfce1, 0x628 },
	{ 0xfce2, 0x628 },
	{ 0xfce3, 0x62a },
	{ 0xfce4, 0x62a },
	{ 0xfce5, 0x62b },
	{ 0xfce6, 0x62b },
	{ 0xfce7, 0x633 },
	{ 0xfce8, 0x633 },
	{ 0xfce9, 0x634 },
	{ 0xfcea, 0x634 },
	{ 0xfceb, 0x643 },
	{ 0xfcec, 0x643 },
	{ 0xfced, 0x644 },
	{ 0xfcee, 0x646 },
	{ 0xfcef, 0x646 },
	{ 0xfcf0, 0x64a },
	{ 0xfcf1, 0x64a },
	{ 0xfcf5, 0x637 },
	{ 0xfcf6, 0x637 },
	{ 0xfcf7, 0x639 },
	{ 0xfcf8, 0x639 },
	{ 0xfcf9, 0x63a },
	{ 0xfcfa, 0x63a },
	{ 0xfcfb, 0x633 },
	{ 0xfcfc, 0x633 },
	{ 0xfcfd, 0x634 },
	{ 0xfcfe, 0x634 },
	{ 0xfcff, 0x62d },
	{ 0xfd00, 0x62d },
	{ 0xfd01, 0x62c },
	{ 0xfd02, 0x62c },
	{ 0xfd03, 0x62e },
	{ 0xfd04, 0x62e },
	{ 0xfd05, 0x635 },
	{ 0xfd06, 0x635 },
	{ 0xfd07, 0x636 },
	{ 0xfd08, 0x636 },
	{ 0xfd09, 0x634 },
	{ 0xfd0a, 0x634 },
	{ 0xfd0b, 0x634 },
	{ 0xfd0c, 0x634 },
	{ 0xfd0d, 0x634 },
	{ 0xfd0e, 0x633 },
	{ 0xfd0f, 0x635 },
	{ 0xfd10, 0x636 },
	{ 0xfd11, 0x637 },
	{ 0xfd12, 0x637 },
	{ 0xfd13, 0x639 },
	{ 0xfd14, 0x639 },
	{ 0xfd15, 0x63a },
	{ 0xfd16, 0x63a },
	{ 0xfd17, 0x633 },
	{ 0xfd18, 0x633 },
	{ 0xfd19, 0x634 },
	{ 0xfd1a, 0x634 },
	{ 0xfd1b, 0x62d },
	{ 0xfd1c, 0x62d },
	{ 0xfd1d, 0x62c },
	{ 0xfd1e, 0x62c },
	{ 0xfd1f, 0x62e },
	{ 0xfd20, 0x62e },
	{ 0xfd21, 0x635 },
	{ 0xfd22, 0x635 },
	{ 0xfd23, 0x636 },
	{ 0xfd24, 0x636 },
	{ 0xfd25, 0x634 },
	{ 0xfd26, 0x634 },
	{ 0xfd27, 0x634 },
	{ 0xfd28, 0x634 },
	{ 0xfd29, 0x634 },
	{ 0xfd2a, 0x633 },
	{ 0xfd2b, 0x635 },
	{ 0xfd2c, 0x636 },
	{ 0xfd2d, 0x634 },
	{ 0xfd2e, 0x634 },
	{ 0xfd2f, 0x634 },
	{ 0xfd30, 0x634 },
	{ 0xfd31, 0x633 },
	{ 0xfd32, 0x634 },
	{ 0xfd33, 0x637 },
	{ 0xfd34, 0x633 },
	{ 0xfd35, 0x633 },
	{ 0xfd36, 0x633 },
	{ 0xfd37, 0x634 },
	{ 0xfd38, 0x634 },
	{ 0xfd39, 0x634 },
	{ 0xfd3a, 0x637 },
	{ 0xfd3b, 0x638 },
	{ 0xfd3c, 0x627 },
	{ 0xfd3d, 0x627 },
	{ 0xfd50, 0x62a },
	{ 0xfd51, 0x62a },
	{ 0xfd52, 0x62a },
	{ 0xfd53, 0x62a },
	{ 0xfd54, 0x62a },
	{ 0xfd55, 0x62a },
	{ 0xfd56, 0x62a },
	{ 0xfd57, 0x62a },
	{ 0xfd58, 0x62c },
	{ 0xfd59, 0x62c },
	{ 0xfd5a, 0x62d },
	{ 0xfd5b, 0x62d },
	{ 0xfd5c, 0x633 },
	{ 0xfd5d, 0x633 },
	{ 0xfd5e, 0x633 },
	{ 0xfd5f, 0x633 },
	{ 0xfd60, 0x633 },
	{ 0xfd61, 0x633 },
	{ 0xfd62, 0x633 },
	{ 0xfd63, 0x633 },
	{ 0xfd64, 0x635 },
	{ 0xfd65, 0x635 },
	{ 0xfd66, 0x635 },
	{ 0xfd67, 0x634 },
	{ 0xfd68, 0x634 },
	{ 0xfd69, 0x634 },
	{ 0xfd6a, 0x634 },
	{ 0xfd6b, 0x634 },
	{ 0xfd6c, 0x634 },
	{ 0xfd6d, 0x634 },
	{ 0xfd6e, 0x636 },
	{ 0xfd6f, 0x636 },
	{ 0xfd70, 0x636 },
	{ 0xfd71, 0x637 },
	{ 0xfd72, 0x637 },
	{ 0xfd73, 0x637 },
	{ 0xfd74, 0x637 },
	{ 0xfd75, 0x639 },
	{ 0xfd76, 0x639 },
	{ 0xfd77, 0x639 },
	{ 0xfd78, 0x639 },
	{ 0xfd79, 0x63a },
	{ 0xfd7a, 0x63a },
	{ 0xfd7b, 0x63a },
	{ 0xfd7c, 0x641 },
	{ 0xfd7d, 0x641 },
	{ 0xfd7e, 0x642 },
	{ 0xfd7f, 0x642 },
	{ 0xfd80, 0x644 },
	{ 0xfd81, 0x644 },
	{ 0xfd82, 0x644 },
	{ 0xfd83, 0x644 },
	{ 0xfd84, 0x644 },
	{ 0xfd85, 0x644 },
	{ 0xfd86, 0x644 },
	{ 0xfd87, 0x644 },
	{ 0xfd88, 0x644 },
	{ 0xfd89, 0x645 },
	{ 0xfd8a, 0x645 },
	{ 0xfd8b, 0x645 },
	{ 0xfd8c, 0x645 },
	{ 0xfd8d, 0x645 },
	{ 0xfd8e, 0x645 },
	{ 0xfd8f, 0x645 },
	{ 0xfd92, 0x645 },
	{ 0xfd93, 0x647 },
	{ 0xfd94, 0x647 },
	{ 0xfd95, 0x646 },
	{ 0xfd96, 0x646 },
	{ 0xfd97, 0x646 },
	{ 0xfd98, 0x646 },
	{ 0xfd99, 0x646 },
	{ 0xfd9a, 0x646 },
	{ 0xfd9b, 0x646 },
	{ 0xfd9c, 0x64a },
	{ 0xfd9d, 0x64a },
	{ 0xfd9e, 0x628 },
	{ 0xfd9f, 0x62a },
	{ 0xfda0, 0x62a },
	{ 0xfda1, 0x62a },
	{ 0xfda2, 0x62a },
	{ 0xfda3, 0x62a },
	{ 0xfda4, 0x62a },
	{ 0xfda5, 0x62c },
	{ 0xfda6, 0x62c },
	{ 0xfda7, 0x62c },
	{ 0xfda8, 0x633 },
	{ 0xfda9, 0x635 },
	{ 0xfdaa, 0x634 },
	{ 0xfdab, 0x636 },
	{ 0xfdac, 0x644 },
	{ 0xfdad, 0x644 },
	{ 0xfdae, 0x64a },
	{ 0xfdaf, 0x64a },
	{ 0xfdb0, 0x64a },
	{ 0xfdb1, 0x645 },
	{ 0xfdb2, 0x642 },
	{ 0xfdb3, 0x646 },
	{ 0xfdb4, 0x642 },
	{ 0xfdb5, 0x644 },
	{ 0xfdb6, 0x639 },
	{ 0xfdb7, 0x643 },
	{ 0xfdb8, 0x646 },
	{ 0xfdb9, 0x645 },
	{ 0xfdba, 0x644 },
	{ 0xfdbb, 0x643 },
	{ 0xfdbc, 0x644 },
	{ 0xfdbd, 0x646 },
	{ 0xfdbe, 0x62c },
	{ 0xfdbf, 0x62d },
	{ 0xfdc0, 0x645 },
	{ 0xfdc1, 0x641 },
	{ 0xfdc2, 0x628 },
	{ 0xfdc3, 0x643 },
	{ 0xfdc4, 0x639 },
	{ 0xfdc5, 0x635 },
	{ 0xfdc6, 0x633 },
	{ 0xfdc7, 0x646 },
	{ 0xfdf0, 0x635 },
	{ 0xfdf1, 0x642 },
	{ 0xfdf2, 0x627 },
	{ 0xfdf3, 0x627 },
	{ 0xfdf4, 0x645 },
	{ 0xfdf5, 0x635 },
	{ 0xfdf6, 0x631 },
	{ 0xfdf7, 0x639 },
	{ 0xfdf8, 0x648 },
	{ 0xfdf9, 0x635 },
	{ 0xfdfa, 0x635 },
	{ 0xfdfb, 0x62c },
	{ 0xfe80, 0x621 },
	{ 0xfe81, 0x622 },
	{ 0xfe82, 0x622 },
	{ 0xfe83, 0x623 },
	{ 0xfe84, 0x623 },
	{ 0xfe85, 0x624 },
	{ 0xfe86, 0x624 },
	{ 0xfe87, 0x625 },
	{ 0xfe88, 0x625 },
	{ 0xfe89, 0x626 },
	{ 0xfe8a, 0x626 },
	{ 0xfe8b, 0x626 },
	{ 0xfe8c, 0x626 },
	{ 0xfe8d, 0x627 },
	{ 0xfe8e, 0x627 },
	{ 0xfe8f, 0x628 },
	{ 0xfe90, 0x628 },
	{ 0xfe91, 0x628 },
	{ 0xfe92, 0x628 },
	{ 0xfe93, 0x629 },
	{ 0xfe94, 0x629 },
	{ 0xfe95, 0x62a },
	{ 0xfe96, 0x62a },
	{ 0xfe97, 0x62a },
	{ 0xfe98, 0x62a },
	{ 0xfe99, 0x62b },
	{ 0xfe9a, 0x62b },
	{ 0xfe9b, 0x62b },
	{ 0xfe9c, 0x62b },
	{ 0xfe9d, 0x62c },
	{ 0xfe9e, 0x62c },
	{ 0xfe9f, 0x62c },
	{ 0xfea0, 0x62c },
	{ 0xfea1, 0x62d },
	{ 0xfea2, 0x62d },
	{ 0xfea3, 0x62d },
	{ 0xfea4, 0x62d },
	{ 0xfea5, 0x62e },
	{ 0xfea6, 0x62e },
	{ 0xfea7, 0x62e },
	{ 0xfea8, 0x62e },
	{ 0xfea9, 0x62f },
	{ 0xfeaa, 0x62f },
	{ 0xfeab, 0x630 },
	{ 0xfeac, 0x630 },
	{ 0xfead, 0x631 },
	{ 0xfeae, 0x631 },
	{ 0xfeaf, 0x632 },
	{ 0xfeb0, 0x632 },
	{ 0xfeb1, 0x633 },
	{ 0xfeb2, 0x633 },
	{ 0xfeb3, 0x633 },
	{ 0xfeb4, 0x633 },
	{ 0xfeb5, 0x634 },
	{ 0xfeb6, 0x634 },
	{ 0xfeb7, 0x634 },
	{ 0xfeb8, 0x634 },
	{ 0xfeb9, 0x635 },
	{ 0xfeba, 0x635 },
	{ 0xfebb, 0x635 },
	{ 0xfebc, 0x635 },
	{ 0xfebd, 0x636 },
	{ 0xfebe, 0x636 },
	{ 0xfebf, 0x636 },
	{ 0xfec0, 0x636 },
	{ 0xfec1, 0x637 },
	{ 0xfec2, 0x637 },
	{ 0xfec3, 0x637 },
	{ 0xfec4, 0x637 },
	{ 0xfec5, 0x638 },
	{ 0xfec6, 0x638 },
	{ 0xfec7, 0x638 },
	{ 0xfec8, 0x638 },
	{ 0xfec9, 0x639 },
	{ 0xfeca, 0x639 },
	{ 0xfecb, 0x639 },
	{ 0xfecc, 0x639 },
	{ 0xfecd, 0x63a },
	{ 0xfece, 0x63a },
	{ 0xfecf, 0x63a },
	{ 0xfed0, 0x63a },
	{ 0xfed1, 0x641 },
	{ 0xfed2, 0x641 },
	{ 0xfed3, 0x641 },
	{ 0xfed4, 0x641 },
	{ 0xfed5, 0x642 },
	{ 0xfed6, 0x642 },
	{ 0xfed7, 0x642 },
	{ 0xfed8, 0x642 },
	{ 0xfed9, 0x643 },
	{ 0xfeda, 0x643 },
	{ 0xfedb, 0x643 },
	{ 0xfedc, 0x643 },
	{ 0xfedd, 0x644 },
	{ 0xfede, 0x644 },
	{ 0xfedf, 0x644 },
	{ 0xfee0, 0x644 },
	{ 0xfee1, 0x645 },
	{ 0xfee2, 0x645 },
	{ 0xfee3, 0x645 },
	{ 0xfee4, 0x645 },
	{ 0xfee5, 0x646 },
	{ 0xfee6, 0x646 },
	{ 0xfee7, 0x646 },
	{ 0xfee8, 0x646 },
	{ 0xfee9, 0x647 },
	{ 0xfeea, 0x647 },
	{ 0xfeeb, 0x647 },
	{ 0xfeec, 0x647 },
	{ 0xfeed, 0x648 },
	{ 0xfeee, 0x648 },
	{ 0xfeef, 0x649 },
	{ 0xfef0, 0x649 },
	{ 0xfef1, 0x64a },
	{ 0xfef2, 0x64a },
	{ 0xfef3, 0x64a },
	{ 0xfef4, 0x64a },
	{ 0xfef5, 0x644 },
	{ 0xfef6, 0x644 },
	{ 0xfef7, 0x644 },
	{ 0xfef8, 0x644 },
	{ 0xfef9, 0x644 },
	{ 0xfefa, 0x644 },
	{ 0xfefb, 0x644 },
	{ 0xfefc, 0x644 },
	{ 0xff10, 0x30 },
	{ 0xff11, 0x31 },
	{ 0xff12, 0x32 },
	{ 0xff13, 0x33 },
	{ 0xff14, 0x34 },
	{ 0xff15, 0x35 },
	{ 0xff16, 0x36 },
	{ 0xff17, 0x37 },
	{ 0xff18, 0x38 },
	{ 0xff19, 0x39 },
	{ 0xff21, 0x41 },
	{ 0xff22, 0x42 },
	{ 0xff23, 0x43 },
	{ 0xff24, 0x44 },
	{ 0xff25, 0x45 },
	{ 0xff26, 0x46 },
	{ 0xff27, 0x47 },
	{ 0xff28, 0x48 },
	{ 0xff29, 0x49 },
	{ 0xff2a, 0x4a },
	{ 0xff2b, 0x4b },
	{ 0xff2c, 0x4c },
	{ 0xff2d, 0x4d },
	{ 0xff2e, 0x4e },
	{ 0xff2f, 0x4f },
	{ 0xff30, 0x50 },
	{ 0xff31, 0x51 },
	{ 0xff32, 0x52 },
	{ 0xff33, 0x53 },
	{ 0xff34, 0x54 },
	{ 0xff35, 0x55 },
	{ 0xff36, 0x56 },
	{ 0xff37, 0x57 },
	{ 0xff38, 0x58 },
	{ 0xff39, 0x59 },
	{ 0xff3a, 0x5a },
	{ 0xff41, 0x41 },
	{ 0xff42, 0x42 },
	{ 0xff43, 0x43 },
	{ 0xff44, 0x44 },
	{ 0xff45, 0x45 },
	{ 0xff46, 0x46 },
	{ 0xff47, 0x47 },
	{ 0xff48, 0x48 },
	{ 0xff49, 0x49 },
	{ 0xff4a, 0x4a },
	{ 0xff4b, 0x4b },
	{ 0xff4c, 0x4c },
	{ 0xff4d, 0x4d },
	{ 0xff4e, 0x4e },
	{ 0xff4f, 0x4f },
	{ 0xff50, 0x50 },
	{ 0xff51, 0x51 },
	{ 0xff52, 0x52 },
	{ 0xff53, 0x53 },
	{ 0xff54, 0x54 },
	{ 0xff55, 0x55 },
	{ 0xff56, 0x56 },
	{ 0xff57, 0x57 },
	{ 0xff58, 0x58 },
	{ 0xff59, 0x59 },
	{ 0xff5a, 0x5a },
	{ 0xff66, 0x3092 },
	{ 0xff67, 0x3041 },
	{ 0xff68, 0x3043 },
	{ 0xff69, 0x3045 },
	{ 0xff6a, 0x3047 },
	{ 0xff6b, 0x3049 },
	{ 0xff6c, 0x3083 },
	{ 0xff6d, 0x3085 },
	{ 0xff6e, 0x3087 },
	{ 0xff6f, 0x3063 },
	{ 0xff71, 0x3041 },
	{ 0xff72, 0x3043 },
	{ 0xff73, 0x3045 },
	{ 0xff74, 0x3047 },
	{ 0xff75, 0x3049 },
	{ 0xff76, 0x304b },
	{ 0xff77, 0x304d },
	{ 0xff78, 0x304f },
	{ 0xff79, 0x3051 },
	{ 0xff7a, 0x3053 },
	{ 0xff7b, 0x3055 },
	{ 0xff7c, 0x3006 },
	{ 0xff7d, 0x3059 },
	{ 0xff7e, 0x305b },
	{ 0xff7f, 0x305d },
	{ 0xff80, 0x305f },
	{ 0xff81, 0x3061 },
	{ 0xff82, 0x3063 },
	{ 0xff83, 0x3066 },
	{ 0xff84, 0x3068 },
	{ 0xff85, 0x306a },
	{ 0xff86, 0x306b },
	{ 0xff87, 0x306c },
	{ 0xff88, 0x306d },
	{ 0xff89, 0x306e },
	{ 0xff8a, 0x306f },
	{ 0xff8b, 0x3072 },
	{ 0xff8c, 0x3075 },
	{ 0xff8d, 0x3078 },
	{ 0xff8e, 0x307b },
	{ 0xff8f, 0x303c },
	{ 0xff90, 0x307f },
	{ 0xff91, 0x3080 },
	{ 0xff92, 0x3081 },
	{ 0xff93, 0x3082 },
	{ 0xff94, 0x3083 },
	{ 0xff95, 0x3085 },
	{ 0xff96, 0x3087 },
	{ 0xff97, 0x3089 },
	{ 0xff98, 0x308a },
	{ 0xff99, 0x308b },
	{ 0xff9a, 0x308c },
	{ 0xff9b, 0x308d },
	{ 0xff9c, 0x308e },
	{ 0xff9d, 0x3093 },
	{ 0xffa0, 0x1160 },
	{ 0xffa1, 0x1100 },
	{ 0xffa2, 0x1101 },
	{ 0xffa3, 0x11aa },
	{ 0xffa4, 0x1102 },
	{ 0xffa5, 0x11ac },
	{ 0xffa6, 0x11ad },
	{ 0xffa7, 0x1103 },
	{ 0xffa8, 0x1104 },
	{ 0xffa9, 0x1105 },
	{ 0xffaa, 0x11b0 },
	{ 0xffab, 0x11b1 },
	{ 0xffac, 0x11b2 },
	{ 0xffad, 0x11b3 },
	{ 0xffae, 0x11b4 },
	{ 0xffaf, 0x11b5 },
	{ 0xffb0, 0x111a },
	{ 0xffb1, 0x1106 },
	{ 0xffb2, 0x1107 },
	{ 0xffb3, 0x1108 },
	{ 0xffb4, 0x1121 },
	{ 0xffb5, 0x1109 },
	{ 0xffb6, 0x110a },
	{ 0xffb7, 0x110b },
	{ 0xffb8, 0x110c },
	{ 0xffb9, 0x110d },
	{ 0xffba, 0x110e },
	{ 0xffbb, 0x110f },
	{ 0xffbc, 0x1110 },
	{ 0xffbd, 0x1111 },
	{ 0xffbe, 0x1112 },
	{ 0xffc2, 0x1161 },
	{ 0xffc3, 0x1162 },
	{ 0xffc4, 0x1163 },
	{ 0xffc5, 0x1164 },
	{ 0xffc6, 0x1165 },
	{ 0xffc7, 0x1166 },
	{ 0xffca, 0x1167 },
	{ 0xffcb, 0x1168 },
	{ 0xffcc, 0x1169 },
	{ 0xffcd, 0x116a },
	{ 0xffce, 0x116b },
	{ 0xffcf, 0x116c },
	{ 0xffd2, 0x116d },
	{ 0xffd3, 0x116e },
	{ 0xffd4, 0x116f },
	{ 0xffd5, 0x1170 },
	{ 0xffd6, 0x1171 },
	{ 0xffd7, 0x1172 },
	{ 0xffda, 0x1173 },
	{ 0xffdb, 0x1174 },
	{ 0xffdc, 0x1175 },
	{ 0x10142, 0x31 },
	{ 0x10143, 0x35 },
	{ 0x10148, 0x35 },
	{ 0x1014f, 0x35 },
	{ 0x10158, 0x31 },
	{ 0x10159, 0x31 },
	{ 0x1015a, 0x31 },
	{ 0x1015b, 0x32 },
	{ 0x1015c, 0x32 },
	{ 0x1015d, 0x32 },
	{ 0x1015e, 0x32 },
	{ 0x1015f, 0x35 },
	{ 0x10173, 0x35 },
	{ 0x103d1, 0x31 },
	{ 0x103d2, 0x32 },
	{ 0x104a0, 0x30 },
	{ 0x104a1, 0x31 },
	{ 0x104a2, 0x32 },
	{ 0x104a3, 0x33 },
	{ 0x104a4, 0x34 },
	{ 0x104a5, 0x35 },
	{ 0x104a6, 0x36 },
	{ 0x104a7, 0x37 },
	{ 0x104a8, 0x38 },
	{ 0x104a9, 0x39 },
	{ 0x10987, 0x10986 },
	{ 0x1098b, 0x1098a },
	{ 0x1098d, 0x1098c },
	{ 0x1098f, 0x1098e },
	{ 0x10994, 0x10993 },
	{ 0x10999, 0x10998 },
	{ 0x1099b, 0x1099a },
	{ 0x109a6, 0x10986 },
	{ 0x109a9, 0x1098a },
	{ 0x109aa, 0x1098c },
	{ 0x109ab, 0x1098e },
	{ 0x109af, 0x10993 },
	{ 0x109b0, 0x10993 },
	{ 0x109b4, 0x10998 },
	{ 0x109b5, 0x1099a },
	{ 0x10c81, 0x10c80 },
	{ 0x10c8a, 0x10c89 },
	{ 0x10c8b, 0x10c89 },
	{ 0x10c91, 0x10c90 },
	{ 0x10c9c, 0x10c9b },
	{ 0x10c9e, 0x10c9d },
	{ 0x10c9f, 0x10c9d },
	{ 0x10ca3, 0x10ca2 },
	{ 0x10cab, 0x10caa },
	{ 0x10cad, 0x10cac },
	{ 0x10cc0, 0x10c80 },
	{ 0x10cc1, 0x10c80 },
	{ 0x10cc9, 0x10c89 },
	{ 0x10cca, 0x10c89 },
	{ 0x10ccb, 0x10c89 },
	{ 0x10cd0, 0x10c90 },
	{ 0x10cd1, 0x10c90 },
	{ 0x10cdb, 0x10c9b },
	{ 0x10cdc, 0x10c9b },
	{ 0x10cdd, 0x10c9d },
	{ 0x10cde, 0x10c9d },
	{ 0x10cdf, 0x10c9d },
	{ 0x10ce2, 0x10ca2 },
	{ 0x10ce3, 0x10ca2 },
	{ 0x10cea, 0x10caa },
	{ 0x10ceb, 0x10caa },
	{ 0x10cec, 0x10cac },
	{ 0x10ced, 0x10cac },
	{ 0x11066, 0x30 },
	{ 0x11067, 0x31 },
	{ 0x11068, 0x32 },
	{ 0x11069, 0x33 },
	{ 0x1106a, 0x34 },
	{ 0x1106b, 0x35 },
	{ 0x1106c, 0x36 },
	{ 0x1106d, 0x37 },
	{ 0x1106e, 0x38 },
	{ 0x1106f, 0x39 },
	{ 0x110f0, 0x30 },
	{ 0x110f1, 0x31 },
	{ 0x110f2, 0x32 },
	{ 0x110f3, 0x33 },
	{ 0x110f4, 0x34 },
	{ 0x110f5, 0x35 },
	{ 0x110f6, 0x36 },
	{ 0x110f7, 0x37 },
	{ 0x110f8, 0x38 },
	{ 0x110f9, 0x39 },
	{ 0x11136, 0x30 },
	{ 0x11137, 0x31 },
	{ 0x11138, 0x32 },
	{ 0x11139, 0x33 },
	{ 0x1113a, 0x34 },
	{ 0x1113b, 0x35 },
	{ 0x1113c, 0x36 },
	{ 0x1113d, 0x37 },
	{ 0x1113e, 0x38 },
	{ 0x1113f, 0x39 },
	{ 0x111d0, 0x30 },
	{ 0x111d1, 0x31 },
	{ 0x111d2, 0x32 },
	{ 0x111d3, 0x33 },
	{ 0x111d4, 0x34 },
	{ 0x111d5, 0x35 },
	{ 0x111d6, 0x36 },
	{ 0x111d7, 0x37 },
	{ 0x111d8, 0x38 },
	{ 0x111d9, 0x39 },
	{ 0x112f0, 0x30 },
	{ 0x112f1, 0x31 },
	{ 0x112f2, 0x32 },
	{ 0x112f3, 0x33 },
	{ 0x112f4, 0x34 },
	{ 0x112f5, 0x35 },
	{ 0x112f6, 0x36 },
	{ 0x112f7, 0x37 },
	{ 0x112f8, 0x38 },
	{ 0x112f9, 0x39 },
	{ 0x11450, 0x30 },
	{ 0x11451, 0x31 },
	{ 0x11452, 0x32 },
	{ 0x11453, 0x33 },
	{ 0x11454, 0x34 },
	{ 0x11455, 0x35 },
	{ 0x11456, 0x36 },
	{ 0x11457, 0x37 },
	{ 0x11458, 0x38 },
	{ 0x11459, 0x39 },
	{ 0x114d0, 0x30 },
	{ 0x114d1, 0x31 },
	{ 0x114d2, 0x32 },
	{ 0x114d3, 0x33 },
	{ 0x114d4, 0x34 },
	{ 0x114d5, 0x35 },
	{ 0x114d6, 0x36 },
	{ 0x114d7, 0x37 },
	{ 0x114d8, 0x38 },
	{ 0x114d9, 0x39 },
	{ 0x115d8, 0x11582 },
	{ 0x115d9, 0x11582 },
	{ 0x11650, 0x30 },
	{ 0x11651, 0x31 },
	{ 0x11652, 0x32 },
	{ 0x11653, 0x33 },
	{ 0x11654, 0x34 },
	{ 0x11655, 0x35 },
	{ 0x11656, 0x36 },
	{ 0x11657, 0x37 },
	{ 0x11658, 0x38 },
	{ 0x11659, 0x39 },
	{ 0x116c0, 0x30 },
	{ 0x116c1, 0x31 },
	{ 0x116c2, 0x32 },
	{ 0x116c3, 0x33 },
	{ 0x116c4, 0x34 },
	{ 0x116c5, 0x35 },
	{ 0x116c6, 0x36 },
	{ 0x116c7, 0x37 },
	{ 0x116c8, 0x38 },
	{ 0x116c9, 0x39 },
	{ 0x11730, 0x30 },
	{ 0x11731, 0x31 },
	{ 0x11732, 0x32 },
	{ 0x11733, 0x33 },
	{ 0x11734, 0x34 },
	{ 0x11735, 0x35 },
	{ 0x11736, 0x36 },
	{ 0x11737, 0x37 },
	{ 0x11738, 0x38 },
	{ 0x11739, 0x39 },
	{ 0x118e0, 0x30 },
	{ 0x118e1, 0x31 },
	{ 0x118e2, 0x32 },
	{ 0x118e3, 0x33 },
	{ 0x118e4, 0x34 },
	{ 0x118e5, 0x35 },
	{ 0x118e6, 0x36 },
	{ 0x118e7, 0x37 },
	{ 0x118e8, 0x38 },
	{ 0x118e9, 0x39 },
	{ 0x11c50, 0x30 },
	{ 0x11c51, 0x31 },
	{ 0x11c52, 0x32 },
	{ 0x11c53, 0x33 },
	{ 0x11c54, 0x34 },
	{ 0x11c55, 0x35 },
	{ 0x11c56, 0x36 },
	{ 0x11c57, 0x37 },
	{ 0x11c58, 0x38 },
	{ 0x11c59, 0x39 },
	{ 0x12400, 0x32 },
	{ 0x12401, 0x33 },
	{ 0x12402, 0x34 },
	{ 0x12403, 0x35 },
	{ 0x12404, 0x36 },
	{ 0x12405, 0x37 },
	{ 0x12406, 0x38 },
	{ 0x12407, 0x39 },
	{ 0x12408, 0x33 },
	{ 0x12409, 0x34 },
	{ 0x1240a, 0x35 },
	{ 0x1240b, 0x36 },
	{ 0x1240c, 0x37 },
	{ 0x1240d, 0x38 },
	{ 0x1240e, 0x39 },
	{ 0x1240f, 0x34 },
	{ 0x12410, 0x35 },
	{ 0x12411, 0x36 },
	{ 0x12412, 0x37 },
	{ 0x12413, 0x38 },
	{ 0x12414, 0x39 },
	{ 0x12415, 0x31 },
	{ 0x12416, 0x32 },
	{ 0x12417, 0x33 },
	{ 0x12418, 0x34 },
	{ 0x12419, 0x35 },
	{ 0x1241a, 0x36 },
	{ 0x1241b, 0x37 },
	{ 0x1241c, 0x38 },
	{ 0x1241d, 0x39 },
	{ 0x1241e, 0x31 },
	{ 0x1241f, 0x32 },
	{ 0x12420, 0x33 },
	{ 0x12421, 0x34 },
	{ 0x12422, 0x35 },
	{ 0x12423, 0x32 },
	{ 0x12424, 0x33 },
	{ 0x12425, 0x33 },
	{ 0x12426, 0x34 },
	{ 0x12427, 0x35 },
	{ 0x12428, 0x36 },
	{ 0x12429, 0x37 },
	{ 0x1242a, 0x38 },
	{ 0x1242b, 0x39 },
	{ 0x1242c, 0x31 },
	{ 0x1242d, 0x32 },
	{ 0x1242e, 0x33 },
	{ 0x1242f, 0x33 },
	{ 0x12430, 0x34 },
	{ 0x12431, 0x35 },
	{ 0x12434, 0x31 },
	{ 0x12435, 0x32 },
	{ 0x12436, 0x33 },
	{ 0x12437, 0x33 },
	{ 0x12438, 0x34 },
	{ 0x12439, 0x35 },
	{ 0x1243a, 0x33 },
	{ 0x1243b, 0x33 },
	{ 0x1243c, 0x34 },
	{ 0x1243d, 0x34 },
	{ 0x1243e, 0x34 },
	{ 0x1243f, 0x34 },
	{ 0x12440, 0x36 },
	{ 0x12441, 0x37 },
	{ 0x12442, 0x37 },
	{ 0x12443, 0x37 },
	{ 0x12444, 0x38 },
	{ 0x12445, 0x38 },
	{ 0x12446, 0x39 },
	{ 0x12447, 0x39 },
	{ 0x12448, 0x39 },
	{ 0x12449, 0x39 },
	{ 0x1244a, 0x32 },
	{ 0x1244b, 0x33 },
	{ 0x1244c, 0x34 },
	{ 0x1244d, 0x35 },
	{ 0x1244e, 0x36 },
	{ 0x1244f, 0x31 },
	{ 0x12450, 0x32 },
	{ 0x12451, 0x33 },
	{ 0x12452, 0x34 },
	{ 0x12453, 0x34 },
	{ 0x12454, 0x35 },
	{ 0x12455, 0x35 },
	{ 0x12456, 0x32 },
	{ 0x12457, 0x33 },
	{ 0x12458, 0x31 },
	{ 0x12459, 0x32 },
	{ 0x12469, 0x34 },
	{ 0x1246a, 0x35 },
	{ 0x1246b, 0x36 },
	{ 0x1246c, 0x37 },
	{ 0x1246d, 0x38 },
	{ 0x1246e, 0x39 },
	{ 0x16a60, 0x30 },
	{ 0x16a61, 0x31 },
	{ 0x16a62, 0x32 },
	{ 0x16a63, 0x33 },
	{ 0x16a64, 0x34 },
	{ 0x16a65, 0x35 },
	{ 0x16a66, 0x36 },
	{ 0x16a67, 0x37 },
	{ 0x16a68, 0x38 },
	{ 0x16a69, 0x39 },
	{ 0x16b50, 0x30 },
	{ 0x16b51, 0x31 },
	{ 0x16b52, 0x32 },
	{ 0x16b53, 0x33 },
	{ 0x16b54, 0x34 },
	{ 0x16b55, 0x35 },
	{ 0x16b56, 0x36 },
	{ 0x16b57, 0x37 },
	{ 0x16b58, 0x38 },
	{ 0x16b59, 0x39 },
	{ 0x1d400, 0x41 },
	{ 0x1d401, 0x42 },
	{ 0x1d402, 0x43 },
	{ 0x1d403, 0x44 },
	{ 0x1d404, 0x45 },
	{ 0x1d405, 0x46 },
	{ 0x1d406, 0x47 },
	{ 0x1d407, 0x48 },
	{ 0x1d408, 0x49 },
	{ 0x1d409, 0x4a },
	{ 0x1d40a, 0x4b },
	{ 0x1d40b, 0x4c },
	{ 0x1d40c, 0x4d },
	{ 0x1d40d, 0x4e },
	{ 0x1d40e, 0x4f },
	{ 0x1d40f, 0x50 },
	{ 0x1d410, 0x51 },
	{ 0x1d411, 0x52 },
	{ 0x1d412, 0x53 },
	{ 0x1d413, 0x54 },
	{ 0x1d414, 0x55 },
	{ 0x1d415, 0x56 },
	{ 0x1d416, 0x57 },
	{ 0x1d417, 0x58 },
	{ 0x1d418, 0x59 },
	{ 0x1d419, 0x5a },
	{ 0x1d41a, 0x41 },
	{ 0x1d41b, 0x42 },
	{ 0x1d41c, 0x43 },
	{ 0x1d41d, 0x44 },
	{ 0x1d41e, 0x45 },
	{ 0x1d41f, 0x46 },
	{ 0x1d420, 0x47 },
	{ 0x1d421, 0x48 },
	{ 0x1d422, 0x49 },
	{ 0x1d423, 0x4a },
	{ 0x1d424, 0x4b },
	{ 0x1d425, 0x4c },
	{ 0x1d426, 0x4d },
	{ 0x1d427, 0x4e },
	{ 0x1d428, 0x4f },
	{ 0x1d429, 0x50 },
	{ 0x1d42a, 0x51 },
	{ 0x1d42b, 0x52 },
	{ 0x1d42c, 0x53 },
	{ 0x1d42d, 0x54 },
	{ 0x1d42e, 0x55 },
	{ 0x1d42f, 0x56 },
	{ 0x1d430, 0x57 },
	{ 0x1d431, 0x58 },
	{ 0x1d432, 0x59 },
	{ 0x1d433, 0x5a },
	{ 0x1d434, 0x41 },
	{ 0x1d435, 0x42 },
	{ 0x1d436, 0x43 },
	{ 0x1d437, 0x44 },
	{ 0x1d438, 0x45 },
	{ 0x1d439, 0x46 },
	{ 0x1d43a, 0x47 },
	{ 0x1d43b, 0x48 },
	{ 0x1d43c, 0x49 },
	{ 0x1d43d, 0x4a },
	{ 0x1d43e, 0x4b },
	{ 0x1d43f, 0x4c },
	{ 0x1d440, 0x4d },
	{ 0x1d441, 0x4e },
	{ 0x1d442, 0x4f },
	{ 0x1d443, 0x50 },
	{ 0x1d444, 0x51 },
	{ 0x1d445, 0x52 },
	{ 0x1d446, 0x53 },
	{ 0x1d447, 0x54 },
	{ 0x1d448, 0x55 },
	{ 0x1d449, 0x56 },
	{ 0x1d44a, 0x57 },
	{ 0x1d44b, 0x58 },
	{ 0x1d44c, 0x59 },
	{ 0x1d44d, 0x5a },
	{ 0x1d44e, 0x41 },
	{ 0x1d44f, 0x42 },
	{ 0x1d450, 0x43 },
	{ 0x1d451, 0x44 },
	{ 0x1d452, 0x45 },
	{ 0x1d453, 0x46 },
	{ 0x1d454, 0x47 },
	{ 0x1d456, 0x49 },
	{ 0x1d457, 0x4a },
	{ 0x1d458, 0x4b },
	{ 0x1d459, 0x4c },
	{ 0x1d45a, 0x4d },
	{ 0x1d45b, 0x4e },
	{ 0x1d45c, 0x4f },
	{ 0x1d45d, 0x50 },
	{ 0x1d45e, 0x51 },
	{ 0x1d45f, 0x52 },
	{ 0x1d460, 0x53 },
	{ 0x1d461, 0x54 },
	{ 0x1d462, 0x55 },
	{ 0x1d463, 0x56 },
	{ 0x1d464, 0x57 },
	{ 0x1d465, 0x58 },
	{ 0x1d466, 0x59 },
	{ 0x1d467, 0x5a },
	{ 0x1d468, 0x41 },
	{ 0x1d469, 0x42 },
	{ 0x1d46a, 0x43 },
	{ 0x1d46b, 0x44 },
	{ 0x1d46c, 0x45 },
	{ 0x1d46d, 0x46 },
	{ 0x1d46e, 0x47 },
	{ 0x1d46f, 0x48 },
	{ 0x1d470, 0x49 },
	{ 0x1d471, 0x4a },
	{ 0x1d472, 0x4b },
	{ 0x1d473, 0x4c },
	{ 0x1d474, 0x4d },
	{ 0x1d475, 0x4e },
	{ 0x1d476, 0x4f },
	{ 0x1d477, 0x50 },
	{ 0x1d478, 0x51 },
	{ 0x1d479, 0x52 },
	{ 0x1d47a, 0x53 },
	{ 0x1d47b, 0x54 },
	{ 0x1d47c, 0x55 },
	{ 0x1d47d, 0x56 },
	{ 0x1d47e, 0x57 },
	{ 0x1d47f, 0x58 },
	{ 0x1d480, 0x59 },
	{ 0x1d481, 0x5a },
	{ 0x1d482, 0x41 },
	{ 0x1d483, 0x42 },
	{ 0x1d484, 0x43 },
	{ 0x1d485, 0x44 },
	{ 0x1d486, 0x45 },
	{ 0x1d487, 0x46 },
	{ 0x1d488, 0x47 },
	{ 0x1d489, 0x48 },
	{ 0x1d48a, 0x49 },
	{ 0x1d48b, 0x4a },
	{ 0x1d48c, 0x4b },
	{ 0x1d48d, 0x4c },
	{ 0x1d48e, 0x4d },
	{ 0x1d48f, 0x4e },
	{ 0x1d490, 0x4f },
	{ 0x1d491, 0x50 },
	{ 0x1d492, 0x51 },
	{ 0x1d493, 0x52 },
	{ 0x1d494, 0x53 },
	{ 0x1d495, 0x54 },
	{ 0x1d496, 0x55 },
	{ 0x1d497, 0x56 },
	{ 0x1d498, 0x57 },
	{ 0x1d499, 0x58 },
	{ 0x1d49a, 0x59 },
	{ 0x1d49b, 0x5a },
	{ 0x1d49c, 0x41 },
	{ 0x1d49e, 0x43 },
	{ 0x1d49f, 0x44 },
	{ 0x1d4a2, 0x47 },
	{ 0x1d4a5, 0x4a },
	{ 0x1d4a6, 0x4b },
	{ 0x1d4a9, 0x4e },
	{ 0x1d4aa, 0x4f },
	{ 0x1d4ab, 0x50 },
	{ 0x1d4ac, 0x51 },
	{ 0x1d4ae, 0x53 },
	{ 0x1d4af, 0x54 },
	{ 0x1d4b0, 0x55 },
	{ 0x1d4b1, 0x56 },
	{ 0x1d4b2, 0x57 },
	{ 0x1d4b3, 0x58 },
	{ 0x1d4b4, 0x59 },
	{ 0x1d4b5, 0x5a },
	{ 0x1d4b6, 0x41 },
	{ 0x1d4b7, 0x42 },
	{ 0x1d4b8, 0x43 },
	{ 0x1d4b9, 0x44 },
	{ 0x1d4bb, 0x46 },
	{ 0x1d4bd, 0x48 },
	{ 0x1d4be, 0x49 },
	{ 0x1d4bf, 0x4a },
	{ 0x1d4c0, 0x4b },
	{ 0x1d4c1, 0x4c },
	{ 0x1d4c2, 0x4d },
	{ 0x1d4c3, 0x4e },
	{ 0x1d4c5, 0x50 },
	{ 0x1d4c6, 0x51 },
	{ 0x1d4c7, 0x52 },
	{ 0x1d4c8, 0x53 },
	{ 0x1d4c9, 0x54 },
	{ 0x1d4ca, 0x55 },
	{ 0x1d4cb, 0x56 },
	{ 0x1d4cc, 0x57 },
	{ 0x1d4cd, 0x58 },
	{ 0x1d4ce, 0x59 },
	{ 0x1d4cf, 0x5a },
	{ 0x1d4d0, 0x41 },
	{ 0x1d4d1, 0x42 },
	{ 0x1d4d2, 0x43 },
	{ 0x1d4d3, 0x44 },
	{ 0x1d4d4, 0x45 },
	{ 0x1d4d5, 0x46 },
	{ 0x1d4d6, 0x47 },
	{ 0x1d4d7, 0x48 },
	{ 0x1d4d8, 0x49 },
	{ 0x1d4d9, 0x4a },
	{ 0x1d4da, 0x4b },
	{ 0x1d4db, 0x4c },
	{ 0x1d4dc, 0x4d },
	{ 0x1d4dd, 0x4e },
	{ 0x1d4de, 0x4f },
	{ 0x1d4df, 0x50 },
	{ 0x1d4e0, 0x51 },
	{ 0x1d4e1, 0x52 },
	{ 0x1d4e2, 0x53 },
	{ 0x1d4e3, 0x54 },
	{ 0x1d4e4, 0x55 },
	{ 0x1d4e5, 0x56 },
	{ 0x1d4e6, 0x57 },
	{ 0x1d4e7, 0x58 },
	{ 0x1d4e8, 0x59 },
	{ 0x1d4e9, 0x5a },
	{ 0x1d4ea, 0x41 },
	{ 0x1d4eb, 0x42 },
	{ 0x1d4ec, 0x43 },
	{ 0x1d4ed, 0x44 },
	{ 0x1d4ee, 0x45 },
	{ 0x1d4ef, 0x46 },
	{ 0x1d4f0, 0x47 },
	{ 0x1d4f1, 0x48 },
	{ 0x1d4f2, 0x49 },
	{ 0x1d4f3, 0x4a },
	{ 0x1d4f4, 0x4b },
	{ 0x1d4f5, 0x4c },
	{ 0x1d4f6, 0x4d },
	{ 0x1d4f7, 0x4e },
	{ 0x1d4f8, 0x4f },
	{ 0x1d4f9, 0x50 },
	{ 0x1d4fa, 0x51 },
	{ 0x1d4fb, 0x52 },
	{ 0x1d4fc, 0x53 },
	{ 0x1d4fd, 0x54 },
	{ 0x1d4fe, 0x55 },
	{ 0x1d4ff, 0x56 },
	{ 0x1d500, 0x57 },
	{ 0x1d501, 0x58 },
	{ 0x1d502, 0x59 },
	{ 0x1d503, 0x5a },
	{ 0x1d504, 0x41 },
	{ 0x1d505, 0x42 },
	{ 0x1d507, 0x44 },
	{ 0x1d508, 0x45 },
	{ 0x1d509, 0x46 },
	{ 0x1d50a, 0x47 },
	{ 0x1d50d, 0x4a },
	{ 0x1d50e, 0x4b },
	{ 0x1d50f, 0x4c },
	{ 0x1d510, 0x4d },
	{ 0x1d511, 0x4e },
	{ 0x1d512, 0x4f },
	{ 0x1d513, 0x50 },
	{ 0x1d514, 0x51 },
	{ 0x1d516, 0x53 },
	{ 0x1d517, 0x54 },
	{ 0x1d518, 0x55 },
	{ 0x1d519, 0x56 },
	{ 0x1d51a, 0x57 },
	{ 0x1d51b, 0x58 },
	{ 0x1d51c, 0x59 },
	{ 0x1d51e, 0x41 },
	{ 0x1d51f, 0x42 },
	{ 0x1d520, 0x43 },
	{ 0x1d521, 0x44 },
	{ 0x1d522, 0x45 },
	{ 0x1d523, 0x46 },
	{ 0x1d524, 0x47 },
	{ 0x1d525, 0x48 },
	{ 0x1d526, 0x49 },
	{ 0x1d527, 0x4a },
	{ 0x1d528, 0x4b },
	{ 0x1d529, 0x4c },
	{ 0x1d52a, 0x4d },
	{ 0x1d52b, 0x4e },
	{ 0x1d52c, 0x4f },
	{ 0x1d52d, 0x50 },
	{ 0x1d52e, 0x51 },
	{ 0x1d52f, 0x52 },
	{ 0x1d530, 0x53 },
	{ 0x1d531, 0x54 },
	{ 0x1d532, 0x55 },
	{ 0x1d533, 0x56 },
	{ 0x1d534, 0x57 },
	{ 0x1d535, 0x58 },
	{ 0x1d536, 0x59 },
	{ 0x1d537, 0x5a },
	{ 0x1d538, 0x41 },
	{ 0x1d539, 0x42 },
	{ 0x1d53b, 0x44 },
	{ 0x1d53c, 0x45 },
	{ 0x1d53d, 0x46 },
	{ 0x1d53e, 0x47 },
	{ 0x1d540, 0x49 },
	{ 0x1d541, 0x4a },
	{ 0x1d542, 0x4b },
	{ 0x1d543, 0x4c },
	{ 0x1d544, 0x4d },
	{ 0x1d546, 0x4f },
	{ 0x1d54a, 0x53 },
	{ 0x1d54b, 0x54 },
	{ 0x1d54c, 0x55 },
	{ 0x1d54d, 0x56 },
	{ 0x1d54e, 0x57 },
	{ 0x1d54f, 0x58 },
	{ 0x1d550, 0x59 },
	{ 0x1d552, 0x41 },
	{ 0x1d553, 0x42 },
	{ 0x1d554, 0x43 },
	{ 0x1d555, 0x44 },
	{ 0x1d556, 0x45 },
	{ 0x1d557, 0x46 },
	{ 0x1d558, 0x47 },
	{ 0x1d559, 0x48 },
	{ 0x1d55a, 0x49 },
	{ 0x1d55b, 0x4a },
	{ 0x1d55c, 0x4b },
	{ 0x1d55d, 0x4c },
	{ 0x1d55e, 0x4d },
	{ 0x1d55f, 0x4e },
	{ 0x1d560, 0x4f },
	{ 0x1d561, 0x50 },
	{ 0x1d562, 0x51 },
	{ 0x1d563, 0x52 },
	{ 0x1d564, 0x53 },
	{ 0x1d565, 0x54 },
	{ 0x1d566, 0x55 },
	{ 0x1d567, 0x56 },
	{ 0x1d568, 0x57 },
	{ 0x1d569, 0x58 },
	{ 0x1d56a, 0x59 },
	{ 0x1d56b, 0x5a },
	{ 0x1d56c, 0x41 },
	{ 0x1d56d, 0x42 },
	{ 0x1d56e, 0x43 },
	{ 0x1d56f, 0x44 },
	{ 0x1d570, 0x45 },
	{ 0x1d571, 0x46 },
	{ 0x1d572, 0x47 },
	{ 0x1d573, 0x48 },
	{ 0x1d574, 0x49 },
	{ 0x1d575, 0x4a },
	{ 0x1d576, 0x4b },
	{ 0x1d577, 0x4c },
	{ 0x1d578, 0x4d },
	{ 0x1d579, 0x4e },
	{ 0x1d57a, 0x4f },
	{ 0x1d57b, 0x50 },
	{ 0x1d57c, 0x51 },
	{ 0x1d57d, 0x52 },
	{ 0x1d57e, 0x53 },
	{ 0x1d57f, 0x54 },
	{ 0x1d580, 0x55 },
	{ 0x1d581, 0x56 },
	{ 0x1d582, 0x57 },
	{ 0x1d583, 0x58 },
	{ 0x1d584, 0x59 },
	{ 0x1d585, 0x5a },
	{ 0x1d586, 0x41 },
	{ 0x1d587, 0x42 },
	{ 0x1d588, 0x43 },
	{ 0x1d589, 0x44 },
	{ 0x1d58a, 0x45 },
	{ 0x1d58b, 0x46 },
	{ 0x1d58c, 0x47 },
	{ 0x1d58d, 0x48 },
	{ 0x1d58e, 0x49 },
	{ 0x1d58f, 0x4a },
	{ 0x1d590, 0x4b },
	{ 0x1d591, 0x4c },
	{ 0x1d592, 0x4d },
	{ 0x1d593, 0x4e },
	{ 0x1d594, 0x4f },
	{ 0x1d595, 0x50 },
	{ 0x1d596, 0x51 },
	{ 0x1d597, 0x52 },
	{ 0x1d598, 0x53 },
	{ 0x1d599, 0x54 },
	{ 0x1d59a, 0x55 },
	{ 0x1d59b, 0x56 },
	{ 0x1d59c, 0x57 },
	{ 0x1d59d, 0x58 },
	{ 0x1d59e, 0x59 },
	{ 0x1d59f, 0x5a },
	{ 0x1d5a0, 0x41 },
	{ 0x1d5a1, 0x42 },
	{ 0x1d5a2, 0x43 },
	{ 0x1d5a3, 0x44 },
	{ 0x1d5a4, 0x45 },
	{ 0x1d5a5, 0x46 },
	{ 0x1d5a6, 0x47 },
	{ 0x1d5a7, 0x48 },
	{ 0x1d5a8, 0x49 },
	{ 0x1d5a9, 0x4a },
	{ 0x1d5aa, 0x4b },
	{ 0x1d5ab, 0x4c },
	{ 0x1d5ac, 0x4d },
	{ 0x1d5ad, 0x4e },
	{ 0x1d5ae, 0x4f },
	{ 0x1d5af, 0x50 },
	{ 0x1d5b0, 0x51 },
	{ 0x1d5b1, 0x52 },
	{ 0x1d5b2, 0x53 },
	{ 0x1d5b3, 0x54 },
	{ 0x1d5b4, 0x55 },
	{ 0x1d5b5, 0x56 },
	{ 0x1d5b6, 0x57 },
	{ 0x1d5b7, 0x58 },
	{ 0x1d5b8, 0x59 },
	{ 0x1d5b9, 0x5a },
	{ 0x1d5ba, 0x41 },
	{ 0x1d5bb, 0x42 },
	{ 0x1d5bc, 0x43 },
	{ 0x1d5bd, 0x44 },
	{ 0x1d5be, 0x45 },
	{ 0x1d5bf, 0x46 },
	{ 0x1d5c0, 0x47 },
	{ 0x1d5c1, 0x48 },
	{ 0x1d5c2, 0x49 },
	{ 0x1d5c3, 0x4a },
	{ 0x1d5c4, 0x4b },
	{ 0x1d5c5, 0x4c },
	{ 0x1d5c6, 0x4d },
	{ 0x1d5c7, 0x4e },
	{ 0x1d5c8, 0x4f },
	{ 0x1d5c9, 0x50 },
	{ 0x1d5ca, 0x51 },
	{ 0x1d5cb, 0x52 },
	{ 0x1d5cc, 0x53 },
	{ 0x1d5cd, 0x54 },
	{ 0x1d5ce, 0x55 },
	{ 0x1d5cf, 0x56 },
	{ 0x1d5d0, 0x57 },
	{ 0x1d5d1, 0x58 },
	{ 0x1d5d2, 0x59 },
	{ 0x1d5d3, 0x5a },
	{ 0x1d5d4, 0x41 },
	{ 0x1d5d5, 0x42 },
	{ 0x1d5d6, 0x43 },
	{ 0x1d5d7, 0x44 },
	{ 0x1d5d8, 0x45 },
	{ 0x1d5d9, 0x46 },
	{ 0x1d5da, 0x47 },
	{ 0x1d5db, 0x48 },
	{ 0x1d5dc, 0x49 },
	{ 0x1d5dd, 0x4a },
	{ 0x1d5de, 0x4b },
	{ 0x1d5df, 0x4c },
	{ 0x1d5e0, 0x4d },
	{ 0x1d5e1, 0x4e },
	{ 0x1d5e2, 0x4f },
	{ 0x1d5e3, 0x50 },
	{ 0x1d5e4, 0x51 },
	{ 0x1d5e5, 0x52 },
	{ 0x1d5e6, 0x53 },
	{ 0x1d5e7, 0x54 },
	{ 0x1d5e8, 0x55 },
	{ 0x1d5e9, 0x56 },
	{ 0x1d5ea, 0x57 },
	{ 0x1d5eb, 0x58 },
	{ 0x1d5ec, 0x59 },
	{ 0x1d5ed, 0x5a },
	{ 0x1d5ee, 0x41 },
	{ 0x1d5ef, 0x42 },
	{ 0x1d5f0, 0x43 },
	{ 0x1d5f1, 0x44 },
	{ 0x1d5f2, 0x45 },
	{ 0x1d5f3, 0x46 },
	{ 0x1d5f4, 0x47 },
	{ 0x1d5f5, 0x48 },
	{ 0x1d5f6, 0x49 },
	{ 0x1d5f7, 0x4a },
	{ 0x1d5f8, 0x4b },
	{ 0x1d5f9, 0x4c },
	{ 0x1d5fa, 0x4d },
	{ 0x1d5fb, 0x4e },
	{ 0x1d5fc, 0x4f },
	{ 0x1d5fd, 0x50 },
	{ 0x1d5fe, 0x51 },
	{ 0x1d5ff, 0x52 },
	{ 0x1d600, 0x53 },
	{ 0x1d601, 0x54 },
	{ 0x1d602, 0x55 },
	{ 0x1d603, 0x56 },
	{ 0x1d604, 0x57 },
	{ 0x1d605, 0x58 },
	{ 0x1d606, 0x59 },
	{ 0x1d607, 0x5a },
	{ 0x1d608, 0x41 },
	{ 0x1d609, 0x42 },
	{ 0x1d60a, 0x43 },
	{ 0x1d60b, 0x44 },
	{ 0x1d60c, 0x45 },
	{ 0x1d60d, 0x46 },
	{ 0x1d60e, 0x47 },
	{ 0x1d60f, 0x48 },
	{ 0x1d610, 0x49 },
	{ 0x1d611, 0x4a },
	{ 0x1d612, 0x4b },
	{ 0x1d613, 0x4c },
	{ 0x1d614, 0x4d },
	{ 0x1d615, 0x4e },
	{ 0x1d616, 0x4f },
	{ 0x1d617, 0x50 },
	{ 0x1d618, 0x51 },
	{ 0x1d619, 0x52 },
	{ 0x1d61a, 0x53 },
	{ 0x1d61b, 0x54 },
	{ 0x1d61c, 0x55 },
	{ 0x1d61d, 0x56 },
	{ 0x1d61e, 0x57 },
	{ 0x1d61f, 0x58 },
	{ 0x1d620, 0x59 },
	{ 0x1d621, 0x5a },
	{ 0x1d622, 0x41 },
	{ 0x1d623, 0x42 },
	{ 0x1d624, 0x43 },
	{ 0x1d625, 0x44 },
	{ 0x1d626, 0x45 },
	{ 0x1d627, 0x46 },
	{ 0x1d628, 0x47 },
	{ 0x1d629, 0x48 },
	{ 0x1d62a, 0x49 },
	{ 0x1d62b, 0x4a },
	{ 0x1d62c, 0x4b },
	{ 0x1d62d, 0x4c },
	{ 0x1d62e, 0x4d },
	{ 0x1d62f, 0x4e },
	{ 0x1d630, 0x4f },
	{ 0x1d631, 0x50 },
	{ 0x1d632, 0x51 },
	{ 0x1d633, 0x52 },
	{ 0x1d634, 0x53 },
	{ 0x1d635, 0x54 },
	{ 0x1d636, 0x55 },
	{ 0x1d637, 0x56 },
	{ 0x1d638, 0x57 },
	{ 0x1d639, 0x58 },
	{ 0x1d63a, 0x59 },
	{ 0x1d63b, 0x5a },
	{ 0x1d63c, 0x41 },
	{ 0x1d63d, 0x42 },
	{ 0x1d63e, 0x43 },
	{ 0x1d63f, 0x44 },
	{ 0x1d640, 0x45 },
	{ 0x1d641, 0x46 },
	{ 0x1d642, 0x47 },
	{ 0x1d643, 0x48 },
	{ 0x1d644, 0x49 },
	{ 0x1d645, 0x4a },
	{ 0x1d646, 0x4b },
	{ 0x1d647, 0x4c },
	{ 0x1d648, 0x4d },
	{ 0x1d649, 0x4e },
	{ 0x1d64a, 0x4f },
	{ 0x1d64b, 0x50 },
	{ 0x1d64c, 0x51 },
	{ 0x1d64d, 0x52 },
	{ 0x1d64e, 0x53 },
	{ 0x1d64f, 0x54 },
	{ 0x1d650, 0x55 },
	{ 0x1d651, 0x56 },
	{ 0x1d652, 0x57 },
	{ 0x1d653, 0x58 },
	{ 0x1d654, 0x59 },
	{ 0x1d655, 0x5a },
	{ 0x1d656, 0x41 },
	{ 0x1d657, 0x42 },
	{ 0x1d658, 0x43 },
	{ 0x1d659, 0x44 },
	{ 0x1d65a, 0x45 },
	{ 0x1d65b, 0x46 },
	{ 0x1d65c, 0x47 },
	{ 0x1d65d, 0x48 },
	{ 0x1d65e, 0x49 },
	{ 0x1d65f, 0x4a },
	{ 0x1d660, 0x4b },
	{ 0x1d661, 0x4c },
	{ 0x1d662, 0x4d },
	{ 0x1d663, 0x4e },
	{ 0x1d664, 0x4f },
	{ 0x1d665, 0x50 },
	{ 0x1d666, 0x51 },
	{ 0x1d667, 0x52 },
	{ 0x1d668, 0x53 },
	{ 0x1d669, 0x54 },
	{ 0x1d66a, 0x55 },
	{ 0x1d66b, 0x56 },
	{ 0x1d66c, 0x57 },
	{ 0x1d66d, 0x58 },
	{ 0x1d66e, 0x59 },
	{ 0x1d66f, 0x5a },
	{ 0x1d670, 0x41 },
	{ 0x1d671, 0x42 },
	{ 0x1d672, 0x43 },
	{ 0x1d673, 0x44 },
	{ 0x1d674, 0x45 },
	{ 0x1d675, 0x46 },
	{ 0x1d676, 0x47 },
	{ 0x1d677, 0x48 },
	{ 0x1d678, 0x49 },
	{ 0x1d679, 0x4a },
	{ 0x1d67a, 0x4b },
	{ 0x1d67b, 0x4c },
	{ 0x1d67c, 0x4d },
	{ 0x1d67d, 0x4e },
	{ 0x1d67e, 0x4f },
	{ 0x1d67f, 0x50 },
	{ 0x1d680, 0x51 },
	{ 0x1d681, 0x52 },
	{ 0x1d682, 0x53 },
	{ 0x1d683, 0x54 },
	{ 0x1d684, 0x55 },
	{ 0x1d685, 0x56 },
	{ 0x1d686, 0x57 },
	{ 0x1d687, 0x58 },
	{ 0x1d688, 0x59 },
	{ 0x1d689, 0x5a },
	{ 0x1d68a, 0x41 },
	{ 0x1d68b, 0x42 },
	{ 0x1d68c, 0x43 },
	{ 0x1d68d, 0x44 },
	{ 0x1d68e, 0x45 },
	{ 0x1d68f, 0x46 },
	{ 0x1d690, 0x47 },
	{ 0x1d691, 0x48 },
	{ 0x1d692, 0x49 },
	{ 0x1d693, 0x4a },
	{ 0x1d694, 0x4b },
	{ 0x1d695, 0x4c },
	{ 0x1d696, 0x4d },
	{ 0x1d697, 0x4e },
	{ 0x1d698, 0x4f },
	{ 0x1d699, 0x50 },
	{ 0x1d69a, 0x51 },
	{ 0x1d69b, 0x52 },
	{ 0x1d69c, 0x53 },
	{ 0x1d69d, 0x54 },
	{ 0x1d69e, 0x55 },
	{ 0x1d69f, 0x56 },
	{ 0x1d6a0, 0x57 },
	{ 0x1d6a1, 0x58 },
	{ 0x1d6a2, 0x59 },
	{ 0x1d6a3, 0x5a },
	{ 0x1d6a8, 0x386 },
	{ 0x1d6a9, 0x392 },
	{ 0x1d6aa, 0x393 },
	{ 0x1d6ab, 0x394 },
	{ 0x1d6ac, 0x388 },
	{ 0x1d6ad, 0x396 },
	{ 0x1d6ae, 0x389 },
	{ 0x1d6af, 0x398 },
	{ 0x1d6b0, 0x37a },
	{ 0x1d6b1, 0x39a },
	{ 0x1d6b2, 0x39b },
	{ 0x1d6b3, 0xb5 },
	{ 0x1d6b4, 0x39d },
	{ 0x1d6b5, 0x39e },
	{ 0x1d6b6, 0x38c },
	{ 0x1d6b7, 0x3a0 },
	{ 0x1d6b8, 0x3a1 },
	{ 0x1d6b9, 0x398 },
	{ 0x1d6ba, 0x3a3 },
	{ 0x1d6bb, 0x3a4 },
	{ 0x1d6bc, 0x38e },
	{ 0x1d6bd, 0x3a6 },
	{ 0x1d6be, 0x3a7 },
	{ 0x1d6bf, 0x3a8 },
	{ 0x1d6c0, 0x38f },
	{ 0x1d6c2, 0x386 },
	{ 0x1d6c3, 0x392 },
	{ 0x1d6c4, 0x393 },
	{ 0x1d6c5, 0x394 },
	{ 0x1d6c6, 0x388 },
	{ 0x1d6c7, 0x396 },
	{ 0x1d6c8, 0x389 },
	{ 0x1d6c9, 0x398 },
	{ 0x1d6ca, 0x37a },
	{ 0x1d6cb, 0x39a },
	{ 0x1d6cc, 0x39b },
	{ 0x1d6cd, 0xb5 },
	{ 0x1d6ce, 0x39d },
	{ 0x1d6cf, 0x39e },
	{ 0x1d6d0, 0x38c },
	{ 0x1d6d1, 0x3a0 },
	{ 0x1d6d2, 0x3a1 },
	{ 0x1d6d3, 0x3a3 },
	{ 0x1d6d4, 0x3a3 },
	{ 0x1d6d5, 0x3a4 },
	{ 0x1d6d6, 0x38e },
	{ 0x1d6d7, 0x3a6 },
	{ 0x1d6d8, 0x3a7 },
	{ 0x1d6d9, 0x3a8 },
	{ 0x1d6da, 0x38f },
	{ 0x1d6dc, 0x388 },
	{ 0x1d6dd, 0x398 },
	{ 0x1d6de, 0x39a },
	{ 0x1d6df, 0x3a6 },
	{ 0x1d6e0, 0x3a1 },
	{ 0x1d6e1, 0x3a0 },
	{ 0x1d6e2, 0x386 },
	{ 0x1d6e3, 0x392 },
	{ 0x1d6e4, 0x393 },
	{ 0x1d6e5, 0x394 },
	{ 0x1d6e6, 0x388 },
	{ 0x1d6e7, 0x396 },
	{ 0x1d6e8, 0x389 },
	{ 0x1d6e9, 0x398 },
	{ 0x1d6ea, 0x37a },
	{ 0x1d6eb, 0x39a },
	{ 0x1d6ec, 0x39b },
	{ 0x1d6ed, 0xb5 },
	{ 0x1d6ee, 0x39d },
	{ 0x1d6ef, 0x39e },
	{ 0x1d6f0, 0x38c },
	{ 0x1d6f1, 0x3a0 },
	{ 0x1d6f2, 0x3a1 },
	{ 0x1d6f3, 0x398 },
	{ 0x1d6f4, 0x3a3 },
	{ 0x1d6f5, 0x3a4 },
	{ 0x1d6f6, 0x38e },
	{ 0x1d6f7, 0x3a6 },
	{ 0x1d6f8, 0x3a7 },
	{ 0x1d6f9, 0x3a8 },
	{ 0x1d6fa, 0x38f },
	{ 0x1d6fc, 0x386 },
	{ 0x1d6fd, 0x392 },
	{ 0x1d6fe, 0x393 },
	{ 0x1d6ff, 0x394 },
	{ 0x1d700, 0x388 },
	{ 0x1d701, 0x396 },
	{ 0x1d702, 0x389 },
	{ 0x1d703, 0x398 },
	{ 0x1d704, 0x37a },
	{ 0x1d705, 0x39a },
	{ 0x1d706, 0x39b },
	{ 0x1d707, 0xb5 },
	{ 0x1d708, 0x39d },
	{ 0x1d709, 0x39e },
	{ 0x1d70a, 0x38c },
	{ 0x1d70b, 0x3a0 },
	{ 0x1d70c, 0x3a1 },
	{ 0x1d70d, 0x3a3 },
	{ 0x1d70e, 0x3a3 },
	{ 0x1d70f, 0x3a4 },
	{ 0x1d710, 0x38e },
	{ 0x1d711, 0x3a6 },
	{ 0x1d712, 0x3a7 },
	{ 0x1d713, 0x3a8 },
	{ 0x1d714, 0x38f },
	{ 0x1d716, 0x388 },
	{ 0x1d717, 0x398 },
	{ 0x1d718, 0x39a },
	{ 0x1d719, 0x3a6 },
	{ 0x1d71a, 0x3a1 },
	{ 0x1d71b, 0x3a0 },
	{ 0x1d71c, 0x386 },
	{ 0x1d71d, 0x392 },
	{ 0x1d71e, 0x393 },
	{ 0x1d71f, 0x394 },
	{ 0x1d720, 0x388 },
	{ 0x1d721, 0x396 },
	{ 0x1d722, 0x389 },
	{ 0x1d723, 0x398 },
	{ 0x1d724, 0x37a },
	{ 0x1d725, 0x39a },
	{ 0x1d726, 0x39b },
	{ 0x1d727, 0xb5 },
	{ 0x1d728, 0x39d },
	{ 0x1d729, 0x39e },
	{ 0x1d72a, 0x38c },
	{ 0x1d72b, 0x3a0 },
	{ 0x1d72c, 0x3a1 },
	{ 0x1d72d, 0x398 },
	{ 0x1d72e, 0x3a3 },
	{ 0x1d72f, 0x3a4 },
	{ 0x1d730, 0x38e },
	{ 0x1d731, 0x3a6 },
	{ 0x1d732, 0x3a7 },
	{ 0x1d733, 0x3a8 },
	{ 0x1d734, 0x38f },
	{ 0x1d736, 0x386 },
	{ 0x1d737, 0x392 },
	{ 0x1d738, 0x393 },
	{ 0x1d739, 0x394 },
	{ 0x1d73a, 0x388 },
	{ 0x1d73b, 0x396 },
	{ 0x1d73c, 0x389 },
	{ 0x1d73d, 0x398 },
	{ 0x1d73e, 0x37a },
	{ 0x1d73f, 0x39a },
	{ 0x1d740, 0x39b },
	{ 0x1d741, 0xb5 },
	{ 0x1d742, 0x39d },
	{ 0x1d743, 0x39e },
	{ 0x1d744, 0x38c },
	{ 0x1d745, 0x3a0 },
	{ 0x1d746, 0x3a1 },
	{ 0x1d747, 0x3a3 },
	{ 0x1d748, 0x3a3 },
	{ 0x1d749, 0x3a4 },
	{ 0x1d74a, 0x38e },
	{ 0x1d74b, 0x3a6 },
	{ 0x1d74c, 0x3a7 },
	{ 0x1d74d, 0x3a8 },
	{ 0x1d74e, 0x38f },
	{ 0x1d750, 0x388 },
	{ 0x1d751, 0x398 },
	{ 0x1d752, 0x39a },
	{ 0x1d753, 0x3a6 },
	{ 0x1d754, 0x3a1 },
	{ 0x1d755, 0x3a0 },
	{ 0x1d756, 0x386 },
	{ 0x1d757, 0x392 },
	{ 0x1d758, 0x393 },
	{ 0x1d759, 0x394 },
	{ 0x1d75a, 0x388 },
	{ 0x1d75b, 0x396 },
	{ 0x1d75c, 0x389 },
	{ 0x1d75d, 0x398 },
	{ 0x1d75e, 0x37a },
	{ 0x1d75f, 0x39a },
	{ 0x1d760, 0x39b },
	{ 0x1d761, 0xb5 },
	{ 0x1d762, 0x39d },
	{ 0x1d763, 0x39e },
	{ 0x1d764, 0x38c },
	{ 0x1d765, 0x3a0 },
	{ 0x1d766, 0x3a1 },
	{ 0x1d767, 0x398 },
	{ 0x1d768, 0x3a3 },
	{ 0x1d769, 0x3a4 },
	{ 0x1d76a, 0x38e },
	{ 0x1d76b, 0x3a6 },
	{ 0x1d76c, 0x3a7 },
	{ 0x1d76d, 0x3a8 },
	{ 0x1d76e, 0x38f },
	{ 0x1d770, 0x386 },
	{ 0x1d771, 0x392 },
	{ 0x1d772, 0x393 },
	{ 0x1d773, 0x394 },
	{ 0x1d774, 0x388 },
	{ 0x1d775, 0x396 },
	{ 0x1d776, 0x389 },
	{ 0x1d777, 0x398 },
	{ 0x1d778, 0x37a },
	{ 0x1d779, 0x39a },
	{ 0x1d77a, 0x39b },
	{ 0x1d77b, 0xb5 },
	{ 0x1d77c, 0x39d },
	{ 0x1d77d, 0x39e },
	{ 0x1d77e, 0x38c },
	{ 0x1d77f, 0x3a0 },
	{ 0x1d780, 0x3a1 },
	{ 0x1d781, 0x3a3 },
	{ 0x1d782, 0x3a3 },
	{ 0x1d783, 0x3a4 },
	{ 0x1d784, 0x38e },
	{ 0x1d785, 0x3a6 },
	{ 0x1d786, 0x3a7 },
	{ 0x1d787, 0x3a8 },
	{ 0x1d788, 0x38f },
	{ 0x1d78a, 0x388 },
	{ 0x1d78b, 0x398 },
	{ 0x1d78c, 0x39a },
	{ 0x1d78d, 0x3a6 },
	{ 0x1d78e, 0x3a1 },
	{ 0x1d78f, 0x3a0 },
	{ 0x1d790, 0x386 },
	{ 0x1d791, 0x392 },
	{ 0x1d792, 0x393 },
	{ 0x1d793, 0x394 },
	{ 0x1d794, 0x388 },
	{ 0x1d795, 0x396 },
	{ 0x1d796, 0x389 },
	{ 0x1d797, 0x398 },
	{ 0x1d798, 0x37a },
	{ 0x1d799, 0x39a },
	{ 0x1d79a, 0x39b },
	{ 0x1d79b, 0xb5 },
	{ 0x1d79c, 0x39d },
	{ 0x1d79d, 0x39e },
	{ 0x1d79e, 0x38c },
	{ 0x1d79f, 0x3a0 },
	{ 0x1d7a0, 0x3a1 },
	{ 0x1d7a1, 0x398 },
	{ 0x1d7a2, 0x3a3 },
	{ 0x1d7a3, 0x3a4 },
	{ 0x1d7a4, 0x38e },
	{ 0x1d7a5, 0x3a6 },
	{ 0x1d7a6, 0x3a7 },
	{ 0x1d7a7, 0x3a8 },
	{ 0x1d7a8, 0x38f },
	{ 0x1d7aa, 0x386 },
	{ 0x1d7ab, 0x392 },
	{ 0x1d7ac, 0x393 },
	{ 0x1d7ad, 0x394 },
	{ 0x1d7ae, 0x388 },
	{ 0x1d7af, 0x396 },
	{ 0x1d7b0, 0x389 },
	{ 0x1d7b1, 0x398 },
	{ 0x1d7b2, 0x37a },
	{ 0x1d7b3, 0x39a },
	{ 0x1d7b4, 0x39b },
	{ 0x1d7b5, 0xb5 },
	{ 0x1d7b6, 0x39d },
	{ 0x1d7b7, 0x39e },
	{ 0x1d7b8, 0x38c },
	{ 0x1d7b9, 0x3a0 },
	{ 0x1d7ba, 0x3a1 },
	{ 0x1d7bb, 0x3a3 },
	{ 0x1d7bc, 0x3a3 },
	{ 0x1d7bd, 0x3a4 },
	{ 0x1d7be, 0x38e },
	{ 0x1d7bf, 0x3a6 },
	{ 0x1d7c0, 0x3a7 },
	{ 0x1d7c1, 0x3a8 },
	{ 0x1d7c2, 0x38f },
	{ 0x1d7c4, 0x388 },
	{ 0x1d7c5, 0x398 },
	{ 0x1d7c6, 0x39a },
	{ 0x1d7c7, 0x3a6 },
	{ 0x1d7c8, 0x3a1 },
	{ 0x1d7c9, 0x3a0 },
	{ 0x1d7ca, 0x3dc },
	{ 0x1d7cb, 0x3dc },
	{ 0x1d7ce, 0x30 },
	{ 0x1d7cf, 0x31 },
	{ 0x1d7d0, 0x32 },
	{ 0x1d7d1, 0x33 },
	{ 0x1d7d2, 0x34 },
	{ 0x1d7d3, 0x35 },
	{ 0x1d7d4, 0x36 },
	{ 0x1d7d5, 0x37 },
	{ 0x1d7d6, 0x38 },
	{ 0x1d7d7, 0x39 },
	{ 0x1d7d8, 0x30 },
	{ 0x1d7d9, 0x31 },
	{ 0x1d7da, 0x32 },
	{ 0x1d7db, 0x33 },
	{ 0x1d7dc, 0x34 },
	{ 0x1d7dd, 0x35 },
	{ 0x1d7de, 0x36 },
	{ 0x1d7df, 0x37 },
	{ 0x1d7e0, 0x38 },
	{ 0x1d7e1, 0x39 },
	{ 0x1d7e2, 0x30 },
	{ 0x1d7e3, 0x31 },
	{ 0x1d7e4, 0x32 },
	{ 0x1d7e5, 0x33 },
	{ 0x1d7e6, 0x34 },
	{ 0x1d7e7, 0x35 },
	{ 0x1d7e8, 0x36 },
	{ 0x1d7e9, 0x37 },
	{ 0x1d7ea, 0x38 },
	{ 0x1d7eb, 0x39 },
	{ 0x1d7ec, 0x30 },
	{ 0x1d7ed, 0x31 },
	{ 0x1d7ee, 0x32 },
	{ 0x1d7ef, 0x33 },
	{ 0x1d7f0, 0x34 },
	{ 0x1d7f1, 0x35 },
	{ 0x1d7f2, 0x36 },
	{ 0x1d7f3, 0x37 },
	{ 0x1d7f4, 0x38 },
	{ 0x1d7f5, 0x39 },
	{ 0x1d7f6, 0x30 },
	{ 0x1d7f7, 0x31 },
	{ 0x1d7f8, 0x32 },
	{ 0x1d7f9, 0x33 },
	{ 0x1d7fa, 0x34 },
	{ 0x1d7fb, 0x35 },
	{ 0x1d7fc, 0x36 },
	{ 0x1d7fd, 0x37 },
	{ 0x1d7fe, 0x38 },
	{ 0x1d7ff, 0x39 },
	{ 0x1e000, 0x2c00 },
	{ 0x1e001, 0x2c01 },
	{ 0x1e002, 0x2c02 },
	{ 0x1e003, 0x2c03 },
	{ 0x1e004, 0x2c04 },
	{ 0x1e005, 0x2c05 },
	{ 0x1e006, 0x2c06 },
	{ 0x1e008, 0x2c08 },
	{ 0x1e009, 0x2c09 },
	{ 0x1e00a, 0x2c0a },
	{ 0x1e00b, 0x2c0b },
	{ 0x1e00c, 0x2c0c },
	{ 0x1e00d, 0x2c0d },
	{ 0x1e00e, 0x2c0e },
	{ 0x1e00f, 0x2c0f },
	{ 0x1e010, 0x2c10 },
	{ 0x1e011, 0x2c11 },
	{ 0x1e012, 0x2c12 },
	{ 0x1e013, 0x2c13 },
	{ 0x1e014, 0x2c14 },
	{ 0x1e015, 0x2c15 },
	{ 0x1e016, 0x2c16 },
	{ 0x1e017, 0x2c17 },
	{ 0x1e018, 0x2c18 },
	{ 0x1e01b, 0x2c1b },
	{ 0x1e01c, 0x2c1c },
	{ 0x1e01d, 0x2c1d },
	{ 0x1e01e, 0x2c1e },
	{ 0x1e01f, 0x2c1f },
	{ 0x1e020, 0x2c20 },
	{ 0x1e021, 0x2c21 },
	{ 0x1e023, 0x2c23 },
	{ 0x1e024, 0x2c24 },
	{ 0x1e026, 0x2c26 },
	{ 0x1e027, 0x2c27 },
	{ 0x1e028, 0x2c28 },
	{ 0x1e029, 0x2c29 },
	{ 0x1e02a, 0x2c2a },
	{ 0x1e950, 0x30 },
	{ 0x1e951, 0x31 },
	{ 0x1e952, 0x32 },
	{ 0x1e953, 0x33 },
	{ 0x1e954, 0x34 },
	{ 0x1e955, 0x35 },
	{ 0x1e956, 0x36 },
	{ 0x1e957, 0x37 },
	{ 0x1e958, 0x38 },
	{ 0x1e959, 0x39 },
	{ 0x1ee00, 0x627 },
	{ 0x1ee01, 0x628 },
	{ 0x1ee02, 0x62c },
	{ 0x1ee03, 0x62f },
	{ 0x1ee05, 0x648 },
	{ 0x1ee06, 0x632 },
	{ 0x1ee07, 0x62d },
	{ 0x1ee08, 0x637 },
	{ 0x1ee09, 0x64a },
	{ 0x1ee0a, 0x643 },
	{ 0x1ee0b, 0x644 },
	{ 0x1ee0c, 0x645 },
	{ 0x1ee0d, 0x646 },
	{ 0x1ee0e, 0x633 },
	{ 0x1ee0f, 0x639 },
	{ 0x1ee10, 0x641 },
	{ 0x1ee11, 0x635 },
	{ 0x1ee12, 0x642 },
	{ 0x1ee13, 0x631 },
	{ 0x1ee14, 0x634 },
	{ 0x1ee15, 0x62a },
	{ 0x1ee16, 0x62b },
	{ 0x1ee17, 0x62e },
	{ 0x1ee18, 0x630 },
	{ 0x1ee19, 0x636 },
	{ 0x1ee1a, 0x638 },
	{ 0x1ee1b, 0x63a },
	{ 0x1ee1c, 0x66e },
	{ 0x1ee1d, 0x6ba },
	{ 0x1ee1e, 0x6a1 },
	{ 0x1ee1f, 0x66f },
	{ 0x1ee21, 0x628 },
	{ 0x1ee22, 0x62c },
	{ 0x1ee24, 0x647 },
	{ 0x1ee27, 0x62d },
	{ 0x1ee29, 0x64a },
	{ 0x1ee2a, 0x643 },
	{ 0x1ee2b, 0x644 },
	{ 0x1ee2c, 0x645 },
	{ 0x1ee2d, 0x646 },
	{ 0x1ee2e, 0x633 },
	{ 0x1ee2f, 0x639 },
	{ 0x1ee30, 0x641 },
	{ 0x1ee31, 0x635 },
	{ 0x1ee32, 0x642 },
	{ 0x1ee34, 0x634 },
	{ 0x1ee35, 0x62a },
	{ 0x1ee36, 0x62b },
	{ 0x1ee37, 0x62e },
	{ 0x1ee39, 0x636 },
	{ 0x1ee3b, 0x63a },
	{ 0x1ee42, 0x62c },
	{ 0x1ee47, 0x62d },
	{ 0x1ee49, 0x64a },
	{ 0x1ee4b, 0x644 },
	{ 0x1ee4d, 0x646 },
	{ 0x1ee4e, 0x633 },
	{ 0x1ee4f, 0x639 },
	{ 0x1ee51, 0x635 },
	{ 0x1ee52, 0x642 },
	{ 0x1ee54, 0x634 },
	{ 0x1ee57, 0x62e },
	{ 0x1ee59, 0x636 },
	{ 0x1ee5b, 0x63a },
	{ 0x1ee5d, 0x6ba },
	{ 0x1ee5f, 0x66f },
	{ 0x1ee61, 0x628 },
	{ 0x1ee62, 0x62c },
	{ 0x1ee64, 0x647 },
	{ 0x1ee67, 0x62d },
	{ 0x1ee68, 0x637 },
	{ 0x1ee69, 0x64a },
	{ 0x1ee6a, 0x643 },
	{ 0x1ee6c, 0x645 },
	{ 0x1ee6d, 0x646 },
	{ 0x1ee6e, 0x633 },
	{ 0x1ee6f, 0x639 },
	{ 0x1ee70, 0x641 },
	{ 0x1ee71, 0x635 },
	{ 0x1ee72, 0x642 },
	{ 0x1ee74, 0x634 },
	{ 0x1ee75, 0x62a },
	{ 0x1ee76, 0x62b },
	{ 0x1ee77, 0x62e },
	{ 0x1ee79, 0x636 },
	{ 0x1ee7a, 0x638 },
	{ 0x1ee7b, 0x63a },
	{ 0x1ee7c, 0x66e },
	{ 0x1ee7e, 0x6a1 },
	{ 0x1ee80, 0x627 },
	{ 0x1ee81, 0x628 },
	{ 0x1ee82, 0x62c },
	{ 0x1ee83, 0x62f },
	{ 0x1ee84, 0x647 },
	{ 0x1ee85, 0x648 },
	{ 0x1ee86, 0x632 },
	{ 0x1ee87, 0x62d },
	{ 0x1ee88, 0x637 },
	{ 0x1ee89, 0x64a },
	{ 0x1ee8b, 0x644 },
	{ 0x1ee8c, 0x645 },
	{ 0x1ee8d, 0x646 },
	{ 0x1ee8e, 0x633 },
	{ 0x1ee8f, 0x639 },
	{ 0x1ee90, 0x641 },
	{ 0x1ee91, 0x635 },
	{ 0x1ee92, 0x642 },
	{ 0x1ee93, 0x631 },
	{ 0x1ee94, 0x634 },
	{ 0x1ee95, 0x62a },
	{ 0x1ee96, 0x62b },
	{ 0x1ee97, 0x62e },
	{ 0x1ee98, 0x630 },
	{ 0x1ee99, 0x636 },
	{ 0x1ee9a, 0x638 },
	{ 0x1ee9b, 0x63a },
	{ 0x1eea1, 0x628 },
	{ 0x1eea2, 0x62c },
	{ 0x1eea3, 0x62f },
	{ 0x1eea5, 0x648 },
	{ 0x1eea6, 0x632 },
	{ 0x1eea7, 0x62d },
	{ 0x1eea8, 0x637 },
	{ 0x1eea9, 0x64a },
	{ 0x1eeab, 0x644 },
	{ 0x1eeac, 0x645 },
	{ 0x1eead, 0x646 },
	{ 0x1eeae, 0x633 },
	{ 0x1eeaf, 0x639 },
	{ 0x1eeb0, 0x641 },
	{ 0x1eeb1, 0x635 },
	{ 0x1eeb2, 0x642 },
	{ 0x1eeb3, 0x631 },
	{ 0x1eeb4, 0x634 },
	{ 0x1eeb5, 0x62a },
	{ 0x1eeb6, 0x62b },
	{ 0x1eeb7, 0x62e },
	{ 0x1eeb8, 0x630 },
	{ 0x1eeb9, 0x636 },
	{ 0x1eeba, 0x638 },
	{ 0x1eebb, 0x63a },
	{ 0x1f130, 0x41 },
	{ 0x1f131, 0x42 },
	{ 0x1f132, 0x43 },
	{ 0x1f133, 0x44 },
	{ 0x1f134, 0x45 },
	{ 0x1f135, 0x46 },
	{ 0x1f136, 0x47 },
	{ 0x1f137, 0x48 },
	{ 0x1f138, 0x49 },
	{ 0x1f139, 0x4a },
	{ 0x1f13a, 0x4b },
	{ 0x1f13b, 0x4c },
	{ 0x1f13c, 0x4d },
	{ 0x1f13d, 0x4e },
	{ 0x1f13e, 0x4f },
	{ 0x1f13f, 0x50 },
	{ 0x1f140, 0x51 },
	{ 0x1f141, 0x52 },
	{ 0x1f142, 0x53 },
	{ 0x1f143, 0x54 },
	{ 0x1f144, 0x55 },
	{ 0x1f145, 0x56 },
	{ 0x1f146, 0x57 },
	{ 0x1f147, 0x58 },
	{ 0x1f148, 0x59 },
	{ 0x1f149, 0x5a },
	{ 0x1f150, 0x41 },
	{ 0x1f151, 0x42 },
	{ 0x1f152, 0x43 },
	{ 0x1f153, 0x44 },
	{ 0x1f154, 0x45 },
	{ 0x1f155, 0x46 },
	{ 0x1f156, 0x47 },
	{ 0x1f157, 0x48 },
	{ 0x1f158, 0x49 },
	{ 0x1f159, 0x4a },
	{ 0x1f15a, 0x4b },
	{ 0x1f15b, 0x4c },
	{ 0x1f15c, 0x4d },
	{ 0x1f15d, 0x4e },
	{ 0x1f15e, 0x4f },
	{ 0x1f15f, 0x50 },
	{ 0x1f160, 0x51 },
	{ 0x1f161, 0x52 },
	{ 0x1f162, 0x53 },
	{ 0x1f163, 0x54 },
	{ 0x1f164, 0x55 },
	{ 0x1f165, 0x56 },
	{ 0x1f166, 0x57 },
	{ 0x1f167, 0x58 },
	{ 0x1f168, 0x59 },
	{ 0x1f169, 0x5a },
	{ 0x1f170, 0x41 },
	{ 0x1f171, 0x42 },
	{ 0x1f172, 0x43 },
	{ 0x1f173, 0x44 },
	{ 0x1f174, 0x45 },
	{ 0x1f175, 0x46 },
	{ 0x1f176, 0x47 },
	{ 0x1f177, 0x48 },
	{ 0x1f178, 0x49 },
	{ 0x1f179, 0x4a },
	{ 0x1f17a, 0x4b },
	{ 0x1f17b, 0x4c },
	{ 0x1f17c, 0x4d },
	{ 0x1f17d, 0x4e },
	{ 0x1f17e, 0x4f },
	{ 0x1f17f, 0x50 },
	{ 0x1f180, 0x51 },
	{ 0x1f181, 0x52 },
	{ 0x1f182, 0x53 },
	{ 0x1f183, 0x54 },
	{ 0x1f184, 0x55 },
	{ 0x1f185, 0x56 },
	{ 0x1f186, 0x57 },
	{ 0x1f187, 0x58 },
	{ 0x1f188, 0x59 },
	{ 0x1f189, 0x5a },
	{ 0x2f803, 0xfa6c },
	{ 0x2f80c, 0xfad2 },
	{ 0x2f80d, 0xfa6c },
	{ 0x2f812, 0xfa6c },
	{ 0x2f813, 0xfad2 },
	{ 0x2f816, 0xfa6c },
	{ 0x2f81f, 0xfad2 },
	{ 0x2f824, 0xfad2 },
	{ 0x2f834, 0xfa6c },
	{ 0x2f838, 0xfa6c },
	{ 0x2f859, 0xfa6c },
	{ 0x2f860, 0xfa6c },
	{ 0x2f861, 0xfa6c },
	{ 0x2f867, 0xfad2 },
	{ 0x2f868, 0xfad2 },
	{ 0x2f86c, 0xfa6c },
	{ 0x2f871, 0xfa6c },
	{ 0x2f876, 0xfad2 },
	{ 0x2f87b, 0xfa6c },
	{ 0x2f87d, 0xfa6c },
	{ 0x2f883, 0xfad2 },
	{ 0x2f888, 0xfad2 },
	{ 0x2f889, 0xfa6c },
	{ 0x2f88a, 0xfad2 },
	{ 0x2f88f, 0x2f81c },
	{ 0x2f891, 0xfa6c },
	{ 0x2f892, 0xfa6c },
	{ 0x2f896, 0xfad2 },
	{ 0x2f897, 0xfa6c },
	{ 0x2f898, 0xfa6c },
	{ 0x2f89b, 0xfad2 },
	{ 0x2f8a1, 0xfad2 },
	{ 0x2f8a2, 0xfad2 },
	{ 0x2f8a4, 0xfa6c },
	{ 0x2f8b8, 0xfa6c },
	{ 0x2f8be, 0xfa6c },
	{ 0x2f8c2, 0xfad2 },
	{ 0x2f8c7, 0xfad2 },
	{ 0x2f8ca, 0xfa6c },
	{ 0x2f8ce, 0xfad2 },
	{ 0x2f8d0, 0xfad2 },
	{ 0x2f8d1, 0xfad2 },
	{ 0x2f8d7, 0xfad2 },
	{ 0x2f8dd, 0xfa6c },
	{ 0x2f8de, 0xfad2 },
	{ 0x2f8e3, 0xfa6c },
	{ 0x2f8e7, 0xfad2 },
	{ 0x2f8ec, 0xfa6c },
	{ 0x2f8ee, 0xfad2 },
	{ 0x2f8f0, 0xfa6c },
	{ 0x2f8f2, 0xfad2 },
	{ 0x2f8f7, 0xfa6c },
	{ 0x2f8f8, 0xfa6c },
	{ 0x2f8f9, 0xfa6c },
	{ 0x2f8fb, 0xfa6c },
	{ 0x2f906, 0xfa6c },
	{ 0x2f90a, 0xfad2 },
	{ 0x2f90d, 0xfa6c },
	{ 0x2f910, 0xfa6c },
	{ 0x2f911, 0xfa6c },
	{ 0x2f916, 0xfad2 },
	{ 0x2f91b, 0xfa6c },
	{ 0x2f91d, 0xfa6c },
	{ 0x2f91f, 0xfa6c },
	{ 0x2f923, 0xfa6c },
	{ 0x2f926, 0xfa6c },
	{ 0x2f927, 0xfa6c },
	{ 0x2f92a, 0xfad2 },
	{ 0x2f92c, 0xfad2 },
	{ 0x2f92d, 0xfad2 },
	{ 0x2f933, 0xfad2 },
	{ 0x2f935, 0xfa6c },
	{ 0x2f937, 0xfa6c },
	{ 0x2f939, 0xfa6c },
	{ 0x2f93b, 0xfa6c },
	{ 0x2f93c, 0xfa6c },
	{ 0x2f93d, 0xfa6c },
	{ 0x2f93e, 0xfad2 },
	{ 0x2f93f, 0xfad2 },
	{ 0x2f941, 0xfa6c },
	{ 0x2f942, 0xfa6c },
	{ 0x2f943, 0xfa6c },
	{ 0x2f944, 0xfa6c },
	{ 0x2f949, 0xfad2 },
	{ 0x2f94b, 0xfad2 },
	{ 0x2f94c, 0xfad2 },
	{ 0x2f94d, 0xfa6c },
	{ 0x2f951, 0xfad2 },
	{ 0x2f952, 0xfa6c },
	{ 0x2f954, 0xfa6c },
	{ 0x2f955, 0xfa6c },
	{ 0x2f958, 0xfad2 },
	{ 0x2f95c, 0xfa6c },
	{ 0x2f95d, 0xfa6c },
	{ 0x2f95e, 0xfa6c },
	{ 0x2f960, 0xfad2 },
	{ 0x2f961, 0xfa6c },
	{ 0x2f964, 0xfad2 },
	{ 0x2f965, 0xfa6c },
	{ 0x2f967, 0xfad2 },
	{ 0x2f96b, 0xfa6c },
	{ 0x2f96d, 0xfad2 },
	{ 0x2f971, 0xfad2 },
	{ 0x2f972, 0xfa6c },
	{ 0x2f973, 0xfa6c },
	{ 0x2f974, 0xfad2 },
	{ 0x2f975, 0xfa6c },
	{ 0x2f977, 0xfa6c },
	{ 0x2f97b, 0xfa6c },
	{ 0x2f97c, 0xfa6c },
	{ 0x2f97e, 0xfa6c },
	{ 0x2f980, 0xfa6c },
	{ 0x2f981, 0xfad2 },
	{ 0x2f984, 0xfad2 },
	{ 0x2f987, 0xfa6c },
	{ 0x2f988, 0xfa6c },
	{ 0x2f989, 0xfa6c },
	{ 0x2f98a, 0xfa6c },
	{ 0x2f98e, 0xfad2 },
	{ 0x2f997, 0xfa6c },
	{ 0x2f9a4, 0xfa6c },
	{ 0x2f9a5, 0xfa6c },
	{ 0x2f9a6, 0xfa6c },
	{ 0x2f9a7, 0xfad2 },
	{ 0x2f9ab, 0xfa6c },
	{ 0x2f9ad, 0xfa6c },
	{ 0x2f9ae, 0xfad2 },
	{ 0x2f9af, 0xfad2 },
	{ 0x2f9b0, 0xfa6c },
	{ 0x2f9b1, 0xfa6c },
	{ 0x2f9b2, 0xfad2 },
	{ 0x2f9bf, 0xfad2 },
	{ 0x2f9c2, 0xfad2 },
	{ 0x2f9c5, 0xfa6c },
	{ 0x2f9c8, 0xfad2 },
	{ 0x2f9ca, 0xfad2 },
	{ 0x2f9cb, 0xfa6c },
	{ 0x2f9cc, 0xfa6c },
	{ 0x2f9cd, 0xfad2 },
	{ 0x2f9ce, 0xfad2 },
	{ 0x2f9d3, 0xfa6c },
	{ 0x2f9d8, 0xfa6c },
	{ 0x2f9d9, 0xfa6c },
	{ 0x2f9dd, 0xfa6c },
	{ 0x2f9e0, 0x2f81c },
	{ 0x2f9e1, 0x2f81c },
	{ 0x2f9e5, 0x2f81c },
	{ 0x2f9ed, 0x2f81c },
	{ 0x2f9ef, 0xfad2 },
	{ 0x2f9f1, 0x2f81c },
	{ 0x2f9f2, 0xfad2 },
	{ 0x2f9f6, 0x2f81c },
	{ 0x2f9f7, 0x2f81c },
	{ 0x2f9f8, 0xfad2 },
	{ 0x2f9f9, 0xfad2 },
	{ 0x2f9fb, 0x2f81c },
	{ 0x2f9fc, 0xfad2 },
	{ 0x2f9fd, 0x2f81c },
	{ 0x2fa01, 0x2f81c },
	{ 0x2fa03, 0xfad2 },
	{ 0x2fa08, 0xfad2 },
	{ 0x2fa09, 0x2f81c },
	{ 0x2fa0d, 0xfad2 },
	{ 0x2fa0e, 0xfad2 },
	{ 0x2fa10, 0x2f81c },
	{ 0x2fa11, 0xfad2 },
	{ 0x2fa12, 0x2f81c },
	{ 0x2fa13, 0x2f81c },
	{ 0x2fa14, 0x2f81c },
	{ 0x2fa16, 0xfad2 },
	{ 0x2fa1d, 0x2f81c },
};
/* cmp_equivs --- compare two equivalence table entries */

static int
cmp_equivs(const void *l, const void *r)
{
	const struct equiv *left = (const struct equiv *) l;
	const struct equiv *right = (const struct equiv *) r;

	return left->the_char - right->the_char;
}

/* cmp_refs --- compare two reference table entries */

static int
cmp_refs(const void *l, const void *r)
{
	const struct ref *left = (const struct ref *) l;
	const struct ref *right = (const struct ref *) r;

	return left->the_char - right->the_char;
}
/* find_cclass --- search class data for a known character class */

static int
find_class(const char *cclass)
{
	int i;

	for (i = 0; class_data[i].name != NULL; i++)
		if (strcmp(class_data[i].name, cclass) == 0)
			return i;

	return -1;
}
/* find_class_in_cache --- lookup and/or create locale + class in the table */

static charset_t *
find_class_in_cache(charset_t *set, const char *cclass, int *errcode, bool *is_new)
{
	assert(set != NULL && cclass != NULL && errcode != NULL && is_new != NULL);
	*is_new = true;

	const char *locale = setlocale(LC_CTYPE, NULL);	// query locale
	char *buf = (char *) malloc(strlen(locale) + 1 + strlen(cclass) + 1);
	if (buf == NULL) {
		*errcode = CSET_ESPACE;
		return NULL;
	}

	sprintf(buf, "%s+%s", locale, cclass);

	int index;
	static char letters[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
	char *cp = strchr(letters, buf[0]);

	if (cp == NULL)
		index = 52;
	else
		index = cp - letters;

	struct _class_cache *pcache = class_cache[index];
	if (pcache == NULL) {
		pcache = (struct _class_cache *) malloc(sizeof(struct _class_cache));
		if (pcache == NULL) {
			*errcode = CSET_ESPACE;
			free((void *) buf);
			return NULL;
		}
		pcache->name = buf;
		pcache->next = NULL;
		charset_t *newset = charset_create(errcode, set->mb_cur_max, set->is_utf8);
		if (newset == NULL) {
			// *errcode already set
			free((void *) pcache->name);
			return NULL;
		}
		pcache->set = newset;
		class_cache[index] = pcache;
		// fall through to return
	} else {
		for (; pcache != NULL; pcache = pcache->next) {
			if (strcmp(pcache->name, buf) == 0) {	// found it
				free((void *) buf);
				*is_new = false;
				goto done;
			}
		}
		pcache = (struct _class_cache *) malloc(sizeof(struct _class_cache));
		if (pcache == NULL) {
			*errcode = CSET_ESPACE;
			free((void *) buf);
			return NULL;
		}
		pcache->name = buf;
		pcache->next = NULL;
		charset_t *newset = charset_create(errcode, set->mb_cur_max, set->is_utf8);
		if (newset == NULL) {
			// *errcode already set
			free((void *) pcache->name);
			return NULL;
		}
		pcache->set = newset;
		pcache->next = class_cache[index];	// push onto front of the chain
		class_cache[index] = pcache;
		// fall through to return
	}

done:
	*errcode = CSET_SUCCESS;
	return pcache->set;
}
/* wide_char_range_loop --- loop over all possible characters to match a ctype, and cache it */

static int
wide_char_range_loop(charset_t *set, const char *cclass, wctype_t ctype)
{
#ifdef HAVE_PTHREADS
	static pthread_mutex_t mutex = PTHREAD_MUTEX_INITIALIZER;

	pthread_mutex_lock(& mutex);
#endif

	int errcode = 0;
	bool is_new = false;
	int ret = CSET_SUCCESS;
	charset_t *class_set = find_class_in_cache(set, cclass, & errcode, & is_new);

	if (class_set == NULL) {
		ret = errcode;
		goto done;
	}

	if (is_new) {
		for (int32_t c = 0; c <= MAX_CODE_POINT; c++) {
			if (iswctype(c, ctype)) {
				if ((ret = charset_add_char(class_set, c)) != CSET_SUCCESS)
					goto done;
			}
		}
		ret = charset_finalize(class_set);
		if (ret != CSET_SUCCESS)
			goto done;
	}

	ret = charset_merge(set, class_set);

done:
#ifdef HAVE_PTHREADS
	pthread_mutex_unlock(& mutex);
#endif
	return ret;
}
/* item_compare_for_searching --- compare two set_items */

static int
item_compare_for_searching(const void *k, const void *e)
{
	set_item *thekey = (set_item *) k;
	set_item *elem = (set_item *) e;

	if (elem->start <= thekey->start && thekey->start <= elem->end)
		return 0;	// found it
	else if (thekey->end < elem->start)
		return -1;
	else {
		assert(thekey->start > elem->end);
		return 1;
	}
}
/* int32_t_compare --- compare two int32_t values for qsort */

static int
int32_t_compare(const void *l, const void *r)
{
	int32_t *left = (int32_t *) l;
	int32_t *right = (int32_t *) r;

	return *left - *right;
}
/* item_compare_for_sorting --- compare two set_items */

static int
item_compare_for_sorting(const void *l, const void *r)
{
	set_item *left = (set_item *) l;
	set_item *right = (set_item *) r;

	return left->start - right->start;
}

/* is_found --- return true if the character is found */

static bool
is_found(const charset_t *set, int32_t the_char)
{
	if (set->items == NULL)		// empty set, can't match
		return false;
	if (set->nelems == 1)
	    return (set->items[0].start <= the_char && the_char <= set->items[0].end);
	// binary search to see if we have it
	set_item *found;
	set_item key;
	key.start = key.end = the_char;
	
	size_t nelems = set->nelems;
	if (the_char < 256 && set->nelems8bit < set->nelems)
		nelems = set->nelems8bit;
	
	found = (set_item *) bsearch(& key, set->items, nelems,
					sizeof(set_item), item_compare_for_searching);
	
	return found != NULL;
}
/* utfprefix --- return the correct UTF-8 first byte for the wide character */

static unsigned int
utfprefix(int32_t wc)
{
	if (wc < 0x80)
		return wc;
	if (wc < 0x800)
		return 0xC0 + (wc >> 6);
	if (wc < 0x10000)
		return 0xE0 + (wc >> 12);
	if (wc < 0x100000)
		return 0xF0 + (wc >> 18);
	return 0xF4;
}
/* charset_finalize --- condense all the info into the final data structure */

Static int
charset_finalize(charset_t *set)
{
	assert(set != NULL);
	int result = CSET_SUCCESS;

	if (set->chars != NULL)
		qsort(set->chars, set->nchars_inuse, sizeof(int32_t), int32_t_compare);
	size_t i, j;
	for (i = 0, j = 1; j < set->nchars_inuse; i++, j++) {
		if (set->chars[i] == set->chars[j]) {
			for (size_t k = j + 1; k < set->nchars_inuse; j++, k++) {
				set->chars[j] = set->chars[k];
			}
			set->chars[j] = L'\0';
	
			set->nchars_inuse--;
			j = i;
			i--;	// keep searching from same spot
		}
	}
	if (set->chars != NULL)
		set->chars[set->nchars_inuse] = L'\0';	// not strictly necessary, but doesn't hurt
	size_t range_start = 0;
	for (i = 0, j = 1; j < set->nchars_inuse; i++, j++) {
		if (set->chars[j] == set->chars[i] + 1) {	// ab...
			continue;
		} else if (set->chars[j] > set->chars[i] + 1) {
			// acd...
			// push a and start next range at c
			result = charset_add_range(set, set->chars[range_start], set->chars[i]);
			if (result != CSET_SUCCESS)
				return result;
			range_start = j;
		}
	}
	// Get any final range or character
	if (set->nchars_inuse > 0 && range_start <= set->nchars_inuse - 1) {
		result = charset_add_range(set, set->chars[range_start],
					set->chars[set->nchars_inuse-1]);
		if (result != CSET_SUCCESS)
			return result;
	}
	// sort it
	if (set->items != NULL)
		qsort(set->items, set->nelems,
			sizeof(set_item), item_compare_for_sorting);
	
	// condense it
	set_item *items = set->items;
	for (i = 0, j = 1; j < set->nelems; i++, j++) {
		bool need_shift = false;
		if (items[i].start == items[j].start && items[i].end == items[j].end) {
			need_shift = true;
		} else if (items[i].end + 1 == items[j].start) {
			items[i].end = items[j].end;
			need_shift = true;
		} else if (items[i].start < items[j].start && items[i].end > items[j].end) {
			need_shift = true;
		} else if (   items[i].start <= items[j].start
		           && items[i].end > items[j].start
		           && items[j].end >= items[i].end) {
			items[i].end = items[j].end;
			need_shift = true;
		}
		if (need_shift) {
			for (size_t k = j + 1; k < set->nelems; j++, k++)
				items[j] = items[k];
			
			set->nelems--;
			i--;	// compensate for loop, continue checking at current position
			j = i + 1;
		}
		// otherwise, just continue around the loop
	}
	set->nelems8bit = set->nelems;
	for (size_t i = 0; i < set->nelems; i++) {
		if (set->items[i].start >= 256 && i > 0) {
			set->nelems8bit = i;	// this is a count, not an index
			break;
		}
	}
	set->finalized = true;

	return result;
}
/* charset_create --- make a new charset_t and initialize it */

Static charset_t *
charset_create(int *errcode, int mb_cur_max, bool is_utf8)
{
	if (errcode == NULL)
		return NULL;

	charset_t *set = (charset_t *) malloc(sizeof(charset_t));
	if (set == NULL) {
		*errcode = CSET_ESPACE;
		return NULL;
	}

	memset(set, 0, sizeof(charset_t));
	set->mb_cur_max = mb_cur_max;
	set->is_utf8 = is_utf8;

	*errcode = CSET_SUCCESS;
	return set;
}
/* charset_add_char --- add a single wide character to the set */

Static int
charset_add_char(charset_t *set, int32_t wc)
{
	if (set == NULL)
		return CSET_EBADPTR;
	if (set->finalized)
		return CSET_EFROZEN;

	if (wc < 0)
		return CSET_ERANGE;

	if (set->chars == NULL) {
		set->chars = (int32_t *) malloc(sizeof(int32_t) * INITIAL_ALLOCATION);
		if (set->chars == NULL)
			return CSET_ESPACE;
	
		set->nchars_allocated = INITIAL_ALLOCATION;
		set->nchars_inuse = 0;
	} else if (set->nchars_inuse + 1 >= set->nchars_allocated) {
		int new_amount = set->nchars_allocated * 2;
		int32_t *new_data = (int32_t *) realloc(set->chars, new_amount * sizeof(int32_t));
	
		if (new_data == NULL)
			return CSET_ESPACE;
	
		memset(new_data + set->nchars_allocated, 0, set->nchars_allocated * sizeof(int32_t));
		set->nchars_allocated = new_amount;
		set->chars = new_data;
	}

	set->chars[set->nchars_inuse++] = wc;
	set->chars[set->nchars_inuse] = L'\0';	// make it into a string

	return CSET_SUCCESS;
}
/* charset_add_char_ic --- add a single wide character to the set, and its case alternatives */

#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wunused-function"
Static int
charset_add_char_ic(charset_t *set, int32_t wc)
{
	if (set == NULL)
		return CSET_EBADPTR;
	if (set->finalized)
		return CSET_EFROZEN;

	if (wc < 0)
		return CSET_ERANGE;

	int result1 = charset_add_char(set, wc);

	if (result1 == CSET_SUCCESS) {
		int result2, result3;
		result2 = result3 = CSET_SUCCESS;

		int32_t wcl = set->mb_cur_max == 1 ? tolower(wc) : (int32_t) towlower(wc);
		int32_t wcu = set->mb_cur_max == 1 ? toupper(wc) : (int32_t) towupper(wc);

		if (wc != wcl || wc != wcu) {
			result2 = charset_add_char(set, wcl);
			result3 = charset_add_char(set, wcu);
		}
		if (result3 != CSET_SUCCESS)
			return result3;
		if (result2 != CSET_SUCCESS)
			return result2;
	}

	return result1;
}
#pragma GCC diagnostic pop
/* charset_add_range --- add a range item */

Static int
charset_add_range(charset_t *set, int32_t first, int32_t last)
{
	if (set == NULL)
		return CSET_EBADPTR;
	if (set->finalized)
		return CSET_EFROZEN;

	if (first < 0 || last < 0 || first > last)
		return CSET_ERANGE;

	if (set->items == NULL) {
		set->items = (set_item *) malloc(sizeof(set_item) * INITIAL_ALLOCATION);
		if (set->items == NULL)
			return CSET_ESPACE;
	
		set->allocated = INITIAL_ALLOCATION;
		set->nelems = 0;
	} else if (set->nelems + 1 >= set->allocated) {
		int new_amount = set->allocated * 2;
		set_item *new_data = (set_item *) realloc(set->items, new_amount * sizeof(set_item));
	
		if (new_data == NULL)
			return CSET_ESPACE;
	
		memset(new_data + set->allocated, 0, set->allocated * sizeof(set_item));
		set->allocated = new_amount;
		set->items = new_data;
	}

	set_item new_item;
	new_item.start = first;
	new_item.end = last;
	set->items[set->nelems++] = new_item;

	return CSET_SUCCESS;
}
/* charset_invert --- invert the ranges in set and return a new set */

Static charset_t *
charset_invert(charset_t *set, int *errcode)
{
	int ret = CSET_SUCCESS;
	int low;

	if (errcode == NULL)
		return NULL;

	if (set == NULL) {
		*errcode = CSET_EBADPTR;
		return NULL;
	}

	if (! set->finalized) {
		ret = charset_finalize(set);
		if (ret != CSET_SUCCESS) {
			*errcode = ret;
			return NULL;
		}
	}

	charset_t *newset = charset_create(errcode, set->mb_cur_max, set->is_utf8);
	if (newset == NULL)	// *errcode is already set
		return NULL;

	newset->no_newlines = set->no_newlines;

	if (set->nelems == 0) {	// was empty
		ret = charset_add_range(newset, 0, MAX_CODE_POINT);
		if (ret == CSET_SUCCESS)
			goto done;
		else
			goto fail;
	}

	low = 0;

	for (size_t i = 0; i < set->nelems; i++) {
		if (low < set->items[i].start) {
			if ((ret = charset_add_range(newset, low, set->items[i].start - 1)) != CSET_SUCCESS)
				goto fail;
		}
		low = set->items[i].end + 1;
	}
	if (low <= MAX_CODE_POINT) {
		if ((ret = charset_add_range(newset, low, MAX_CODE_POINT)) != CSET_SUCCESS)
			goto fail;
	}

done:
	*errcode = CSET_SUCCESS;
	return newset;
fail:
	*errcode = ret;
	charset_free(newset);
	return NULL;
}
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wunused-function"
/* charset_set_no_newline --- set the value of the "no newlines" flag */

Static int
charset_set_no_newlines(charset_t *set, bool no_newlines)
{
	if (set == NULL)
		return CSET_EBADPTR;
	if (set->finalized)
		return CSET_EFROZEN;

	set->no_newlines = no_newlines;
	return CSET_SUCCESS;
}
#pragma GCC diagnostic pop
/* charset_add_equiv --- add an equivalence class */

Static int
charset_add_equiv(charset_t *set, int32_t equiv)
{
	if (set == NULL)
		return CSET_EBADPTR;
	if (set->finalized)
		return CSET_EFROZEN;

	if (equiv < 0)
		return CSET_ERANGE;

	int result;

	if (set->mb_cur_max == 1 || ! set->is_utf8) {
		result = charset_add_char(set, equiv);
		return result;
	}

	// search the refs table first
	struct ref key_ref = { equiv, 0 };
	struct ref *ref = (struct ref *) bsearch(& key_ref, ref_table,
						sizeof(ref_table) / sizeof(ref_table[0]),
						sizeof(struct ref), cmp_refs);

	// set up key for the equivs_table
	struct equiv key_equiv;
	// use memset() not an initializer to avoid compiler warnings.
	memset(& key_equiv, 0, sizeof(key_equiv));

	if (ref == NULL)			// was not in reference table
		key_equiv.the_char = equiv;
	else
		key_equiv.the_char = ref->key_char;

	// and search the equivs table
	struct equiv *eq = (struct equiv *) bsearch(& key_equiv, equiv_table,
						sizeof(equiv_table) / sizeof(equiv_table[0]),
						sizeof(struct equiv), cmp_equivs);

	if (eq == NULL) {	// not in the equivs table, add the character
		if ((result = charset_add_char(set, equiv)) != CSET_SUCCESS)
			return result;
	} else {
		// the key character
		if ((result = charset_add_char(set, eq->the_char)) != CSET_SUCCESS)
			return result;

		// and add the equivalent ones
		for (int i = 0; i < eq->count; i++)
			if ((result = charset_add_char(set, eq->equivs[i])) != CSET_SUCCESS)
				return result;
	}

	return CSET_SUCCESS;
}
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wunused-function"
/* charset_add_collate --- add a collating sequence */

Static int
charset_add_collate(charset_t *set, const int32_t *collate)
{
	if (set == NULL)
		return CSET_EBADPTR;
	if (set->finalized)
		return CSET_EFROZEN;

	// only single character collating sequences allowed,
	// at least right now
	if (collate[1] != L'\0')
		return CSET_ECOLLATE;

	return charset_add_char(set, collate[0]);
}
#pragma GCC diagnostic pop
/* charset_add_cclass --- add a character class, like "alnum" */

Static int
charset_add_cclass(charset_t *set, const char *cclass)
{
	if (set == NULL)
		return CSET_EBADPTR;
	if (set->finalized)
		return CSET_EFROZEN;
	if (cclass == NULL)
		return CSET_EBADPTR;

	int index = find_class(cclass);

	if (index == -1) {
		if (set->mb_cur_max == 1)
			return CSET_ECTYPE;
		else {
			// maybe it's locale-specific
			wctype_t ctype = wctype(cclass);	// look it up
			if (ctype == 0)	// it's invalid
				return CSET_ECTYPE;
			
			// this saves the locale + cclass info for possible reuse
			return wide_char_range_loop(set, cclass, ctype);
		}
	}

	// we have a standard cclass
	if (set->mb_cur_max == 1) {
		int (*charcheckfunc)(int c) = class_data[index].charcheckfunc;
		for (int32_t i = 0; i < 256; i++) {
			if (charcheckfunc(i)) {
				int ret = charset_add_char(set, i);
				if (ret != CSET_SUCCESS)
					return ret;
			}
		}
	} else if (set->is_utf8) {
		const set_item *data[2];
		
		data[0] = class_data[index].data[0];
		data[1] = class_data[index].data[1];
		
		for (int i = 0; i < 2; i++) {
			if (data[i] == NULL)
				break;
			for (int j = 0; data[i][j].start != -1; j++) {
				int ret = charset_add_range(set, data[i][j].start, data[i][j].end);
				if (ret != CSET_SUCCESS)
					return ret;
			}
		}
	} else {
		wctype_t ctype = class_data[index].wctype;
		if (ctype == 0) {	// haven't checked it yet
			ctype = wctype(cclass);
		
			if (ctype == 0)	// bad class, should not happen for standard classes
				return CSET_ECTYPE;
		}
		
		// all ok..
		class_data[index].wctype = ctype;	// save for next time
		// this saves the locale + cclass info for possible reuse
		return wide_char_range_loop(set, cclass, ctype);
	}

	return CSET_SUCCESS;
}
/* charset_add_cclass2 --- get class name from unterminated string */

Static int
charset_add_cclass2(charset_t *set, const char *bp, const char *ep)
{
	if (bp == NULL || ep == NULL || bp >= ep)
		return CSET_EBADPTR;

#define ARBITRARY_LIMIT	101		// 100 + '\0'
	char cclass[ARBITRARY_LIMIT];

	if (ep - bp >= ARBITRARY_LIMIT)
		return CSET_ECTYPE;

	int i;
	for (i = 0; bp < ep; i++, bp++)
		cclass[i] = *bp;
	
	cclass[i] = '\0';

	return charset_add_cclass(set, cclass);

#undef ARBITRARY_LIMIT
}
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wunused-function"
/* charset_copy --- create a new charset that is copy of the original */

Static charset_t *
charset_copy(charset_t *set, int *errcode)
{
	if (errcode == NULL)
		return NULL;
	if (set == NULL) {
		*errcode = CSET_EBADPTR;
		return NULL;
	}

	charset_t *newset = charset_create(errcode, set->mb_cur_max, set->is_utf8);
	if (newset == NULL)
		return NULL;

	*newset = *set;
	if (newset->nchars_allocated > 0) {
		newset->chars = (int32_t *) malloc(newset->nchars_allocated * sizeof(int32_t));
		if (newset->chars == NULL) {
			*errcode = CSET_ESPACE;
			free((void *) newset);
			return NULL;
		} else
			memcpy(newset->chars, set->chars, newset->nchars_allocated * sizeof(int32_t));
	}

	if (newset->allocated > 0) {
		newset->items = (set_item *) malloc(newset->allocated * sizeof(set_item));
		if (newset->items == NULL) {
			*errcode = CSET_ESPACE;
			free((void *) newset->chars);
			free((void *) newset);
			return NULL;
		} else
			memcpy(newset->items, set->items, newset->allocated * sizeof(set_item));
	}

	*errcode = CSET_SUCCESS;
	return newset;
}
#pragma GCC diagnostic pop
Static int
charset_merge(charset_t *dest, charset_t *src)
{
	charset_t *set = dest;
	if (set == NULL)
		return CSET_EBADPTR;
	if (src == NULL)
		return CSET_EBADPTR;
	if (set->finalized)
		return CSET_EFROZEN;

	if (src->nelems == 0 && src->nchars_inuse == 0)
		return CSET_SUCCESS;	// nothing to do

	int new_char_count = set->nchars_inuse + src->nchars_inuse + 1;
	
	int32_t *new_chars = NULL;
	if (new_char_count > 0) {
		new_chars = (int32_t *) malloc(new_char_count * sizeof(int32_t));
		if (new_chars == NULL)
			return CSET_ESPACE;
	
		// allocated the space ok, now copy all the stuff in
		if (set->nchars_inuse > 0)
			memcpy(new_chars, set->chars, set->nchars_inuse * sizeof(int32_t));
	
		if (src->chars != NULL)
			memcpy(new_chars + set->nchars_inuse, src->chars, src->nchars_inuse * sizeof(int32_t));
		new_chars[new_char_count-1] = L'\0';
	
		// now update dest
		if (set->chars != NULL)
			free((void *) set->chars);
		set->chars = new_chars;
		set->nchars_inuse = new_char_count - 1;
		set->nchars_allocated = new_char_count;
	}
	int new_item_count = set->nelems + src->nelems;
	// could only be copying characters when merging,
	// so make sure there are items to copy.
	if (new_item_count > 0) {
		set_item *new_items = (set_item *) malloc(new_item_count * sizeof(set_item));
		if (new_items == NULL)
			return CSET_ESPACE;
	
		// allocated the space ok, now copy all the stuff in
		if (set->nelems > 0)
			memcpy(new_items, set->items, set->nelems * sizeof(set_item));
	
		if (src->items != NULL)
			memcpy(new_items + set->nelems, src->items, src->nelems * sizeof(set_item));
	
		// now update dest
		if (set->items != NULL)
			free((void *) set->items);
		set->items = new_items;
		set->nelems = set->allocated = new_item_count;
	}

	return CSET_SUCCESS;
}
/* charset_in_set --- see if a character is in the set */

Static bool
charset_in_set(const charset_t *set, int32_t the_char)
{
	int ret;

	if (set == NULL || the_char < 0)
		return false;

	if (! set->finalized) {
		ret = charset_finalize((charset_t *) set);
		if (ret != CSET_SUCCESS)
			return false;
	}

	if (the_char == L'\n' && set->no_newlines)
		return false;

	bool found = is_found(set, the_char);

	return found;
}
/* charset_free --- free all storage */

Static int
charset_free(const charset_t *set)
{
	if (set == NULL)
		return CSET_EBADPTR;
	// no need to check for finalized

	if (set->items != NULL)
		free((void *) set->items);

	if (set->chars != NULL)
		free((void *) set->chars);

	free((void *) set);

	return CSET_SUCCESS;
}
/* charset_firstbytes --- return the set of prefix bytes for the range */

Static charset_firstbytes_t
charset_firstbytes(charset_t *set, int *errcode)
{
	int ret;
	charset_firstbytes_t result;

	memset(& result, 0, sizeof(result));

	if (errcode == NULL)
		goto done;

	if (set == NULL) {
		*errcode = CSET_EBADPTR;
		goto done;
	}

	if (! set->finalized) {
		ret = charset_finalize(set);

		if (ret != CSET_SUCCESS) {
			*errcode = ret;
			goto done;
		}
	}
#define min(x, y) ((x) < (y) ? (x) : (y))

	if (set->mb_cur_max == 1) {
		for (size_t i = 0; i < set->nelems; i++) {
			if (set->items[i].start > 255)
				break;
			uint32_t low = set->items[i].start;
			uint32_t high = min(set->items[i].end, 255);

			for (uint32_t b = low; b <= high; b++)
				result.bytes[b] = true;
		}
	} else if (set->is_utf8) {
		for (size_t i = 0; i < set->nelems; i++) {
			uint32_t low = utfprefix(set->items[i].start);
			uint32_t high = utfprefix(set->items[i].end);

			for (uint32_t b = low; b <= high; b++)
				result.bytes[b] = true;
		}
	}
#undef min
	*errcode = CSET_SUCCESS;

done:
	return result;
}
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wunused-function"
/* charset_dump --- dump out the data structures */

Static void
charset_dump(const charset_t *set, FILE *fp, bool use_c_format)
{
	static const char *boolval[] = {
		"false",
		"true",
	};

	if (set == NULL || fp == NULL)
		return;

	set_item *items = set->items;
	if (use_c_format) {
		for (size_t i = 0; i < set->nelems; i++) {
			fprintf(fp, "\t{ %d, %d },\n", items[i].start, items[i].end);
		}
	} else {
		fprintf(fp, "no_newlines = %s\n", boolval[!! set->no_newlines]);
		fprintf(fp, "finalized = %s\n", boolval[!! set->finalized]);
		fprintf(fp, "is_utf8 = %s\n", boolval[!! set->is_utf8]);
		fprintf(fp, "mb_cur_max = %d\n", set->mb_cur_max);
		fprintf(fp, "nchars_inuse = %zu\n", set->nchars_inuse);
		fprintf(fp, "nelems = %zu\n", set->nelems);
		fprintf(fp, "nelems8bit = %zu\n", set->nelems8bit);
		
		for (size_t i = 0; i < set->nelems; i++) {
			fprintf(fp, "%3zd. RANGE: start = L'%lc' (%d), end = L'%lc' (%d)\n",
				i, items[i].start, items[i].start, items[i].end, items[i].end);
		}
	}
	fflush(fp);
}
#pragma GCC diagnostic pop
