﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/backup/model/CreateRestoreTestingSelectionResult.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::Backup::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

CreateRestoreTestingSelectionResult::CreateRestoreTestingSelectionResult(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  *this = result;
}

CreateRestoreTestingSelectionResult& CreateRestoreTestingSelectionResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("CreationTime")) {
    m_creationTime = jsonValue.GetDouble("CreationTime");
    m_creationTimeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("RestoreTestingPlanArn")) {
    m_restoreTestingPlanArn = jsonValue.GetString("RestoreTestingPlanArn");
    m_restoreTestingPlanArnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("RestoreTestingPlanName")) {
    m_restoreTestingPlanName = jsonValue.GetString("RestoreTestingPlanName");
    m_restoreTestingPlanNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("RestoreTestingSelectionName")) {
    m_restoreTestingSelectionName = jsonValue.GetString("RestoreTestingSelectionName");
    m_restoreTestingSelectionNameHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
