/* src/bazaar.p/bz-curated-category-info.c
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "src/bazaar.p/bz-curated-category-info.h"



struct _BzCuratedCategoryInfo
{
  GObject parent_instance;

  char *title;
  char *subtitle;
  char *description;
  char *banner;
  char *light_banner;
  char *dark_banner;
  int banner_height;
  GtkContentFit banner_fit;
  GtkAlign banner_text_halign;
  GtkAlign banner_text_valign;
  double banner_text_label_xalign;
  GListModel *appids;
  gboolean enable_bulk_install;
};

G_DEFINE_FINAL_TYPE (BzCuratedCategoryInfo, bz_curated_category_info, G_TYPE_OBJECT);

enum
{
  PROP_0,

  PROP_TITLE,
  PROP_SUBTITLE,
  PROP_DESCRIPTION,
  PROP_BANNER,
  PROP_LIGHT_BANNER,
  PROP_DARK_BANNER,
  PROP_BANNER_HEIGHT,
  PROP_BANNER_FIT,
  PROP_BANNER_TEXT_HALIGN,
  PROP_BANNER_TEXT_VALIGN,
  PROP_BANNER_TEXT_LABEL_XALIGN,
  PROP_APPIDS,
  PROP_ENABLE_BULK_INSTALL,

  LAST_PROP
};
static GParamSpec *props[LAST_PROP] = { 0 };

static void
bz_curated_category_info_dispose (GObject *object)
{
  BzCuratedCategoryInfo *self = BZ_CURATED_CATEGORY_INFO (object);

  g_clear_pointer (&self->title, g_free);
  g_clear_pointer (&self->subtitle, g_free);
  g_clear_pointer (&self->description, g_free);
  g_clear_pointer (&self->banner, g_free);
  g_clear_pointer (&self->light_banner, g_free);
  g_clear_pointer (&self->dark_banner, g_free);
  g_clear_pointer (&self->appids, g_object_unref);

  G_OBJECT_CLASS (bz_curated_category_info_parent_class)->dispose (object);
}

static void
bz_curated_category_info_get_property (GObject    *object,
                       guint       prop_id,
                       GValue     *value,
                       GParamSpec *pspec)
{
  BzCuratedCategoryInfo *self = BZ_CURATED_CATEGORY_INFO (object);

  switch (prop_id)
    {
    case PROP_TITLE:
      g_value_set_string (value, bz_curated_category_info_get_title (self));
      break;
    case PROP_SUBTITLE:
      g_value_set_string (value, bz_curated_category_info_get_subtitle (self));
      break;
    case PROP_DESCRIPTION:
      g_value_set_string (value, bz_curated_category_info_get_description (self));
      break;
    case PROP_BANNER:
      g_value_set_string (value, bz_curated_category_info_get_banner (self));
      break;
    case PROP_LIGHT_BANNER:
      g_value_set_string (value, bz_curated_category_info_get_light_banner (self));
      break;
    case PROP_DARK_BANNER:
      g_value_set_string (value, bz_curated_category_info_get_dark_banner (self));
      break;
    case PROP_BANNER_HEIGHT:
      g_value_set_int (value, bz_curated_category_info_get_banner_height (self));
      break;
    case PROP_BANNER_FIT:
      g_value_set_enum (value, bz_curated_category_info_get_banner_fit (self));
      break;
    case PROP_BANNER_TEXT_HALIGN:
      g_value_set_enum (value, bz_curated_category_info_get_banner_text_halign (self));
      break;
    case PROP_BANNER_TEXT_VALIGN:
      g_value_set_enum (value, bz_curated_category_info_get_banner_text_valign (self));
      break;
    case PROP_BANNER_TEXT_LABEL_XALIGN:
      g_value_set_double (value, bz_curated_category_info_get_banner_text_label_xalign (self));
      break;
    case PROP_APPIDS:
      g_value_set_object (value, bz_curated_category_info_get_appids (self));
      break;
    case PROP_ENABLE_BULK_INSTALL:
      g_value_set_boolean (value, bz_curated_category_info_get_enable_bulk_install (self));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_curated_category_info_set_property (GObject      *object,
                       guint         prop_id,
                       const GValue *value,
                       GParamSpec   *pspec)
{
  BzCuratedCategoryInfo *self = BZ_CURATED_CATEGORY_INFO (object);

  switch (prop_id)
    {
    case PROP_TITLE:
      bz_curated_category_info_set_title (self, g_value_get_string (value));
      break;
    case PROP_SUBTITLE:
      bz_curated_category_info_set_subtitle (self, g_value_get_string (value));
      break;
    case PROP_DESCRIPTION:
      bz_curated_category_info_set_description (self, g_value_get_string (value));
      break;
    case PROP_BANNER:
      bz_curated_category_info_set_banner (self, g_value_get_string (value));
      break;
    case PROP_LIGHT_BANNER:
      bz_curated_category_info_set_light_banner (self, g_value_get_string (value));
      break;
    case PROP_DARK_BANNER:
      bz_curated_category_info_set_dark_banner (self, g_value_get_string (value));
      break;
    case PROP_BANNER_HEIGHT:
      bz_curated_category_info_set_banner_height (self, g_value_get_int (value));
      break;
    case PROP_BANNER_FIT:
      bz_curated_category_info_set_banner_fit (self, g_value_get_enum (value));
      break;
    case PROP_BANNER_TEXT_HALIGN:
      bz_curated_category_info_set_banner_text_halign (self, g_value_get_enum (value));
      break;
    case PROP_BANNER_TEXT_VALIGN:
      bz_curated_category_info_set_banner_text_valign (self, g_value_get_enum (value));
      break;
    case PROP_BANNER_TEXT_LABEL_XALIGN:
      bz_curated_category_info_set_banner_text_label_xalign (self, g_value_get_double (value));
      break;
    case PROP_APPIDS:
      bz_curated_category_info_set_appids (self, g_value_get_object (value));
      break;
    case PROP_ENABLE_BULK_INSTALL:
      bz_curated_category_info_set_enable_bulk_install (self, g_value_get_boolean (value));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_curated_category_info_class_init (BzCuratedCategoryInfoClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);



  object_class->set_property = bz_curated_category_info_set_property;
  object_class->get_property = bz_curated_category_info_get_property;
  object_class->dispose      = bz_curated_category_info_dispose;

  props[PROP_TITLE] =
      g_param_spec_string (
          "title",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_SUBTITLE] =
      g_param_spec_string (
          "subtitle",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_DESCRIPTION] =
      g_param_spec_string (
          "description",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_BANNER] =
      g_param_spec_string (
          "banner",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_LIGHT_BANNER] =
      g_param_spec_string (
          "light-banner",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_DARK_BANNER] =
      g_param_spec_string (
          "dark-banner",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_BANNER_HEIGHT] =
      g_param_spec_int (
          "banner-height",
          NULL, NULL,
          G_MININT, G_MAXINT, 0,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_BANNER_FIT] =
      g_param_spec_enum (
          "banner-fit",
          NULL, NULL,
          GTK_TYPE_CONTENT_FIT, 0,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_BANNER_TEXT_HALIGN] =
      g_param_spec_enum (
          "banner-text-halign",
          NULL, NULL,
          GTK_TYPE_ALIGN, 0,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_BANNER_TEXT_VALIGN] =
      g_param_spec_enum (
          "banner-text-valign",
          NULL, NULL,
          GTK_TYPE_ALIGN, 0,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_BANNER_TEXT_LABEL_XALIGN] =
      g_param_spec_double (
          "banner-text-label-xalign",
          NULL, NULL,
          0.0, G_MAXDOUBLE, 0.0,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_APPIDS] =
      g_param_spec_object (
          "appids",
          NULL, NULL,
          G_TYPE_LIST_MODEL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_ENABLE_BULK_INSTALL] =
      g_param_spec_boolean (
          "enable-bulk-install",
          NULL, NULL, FALSE,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  g_object_class_install_properties (object_class, LAST_PROP, props);
}

static void
bz_curated_category_info_init (BzCuratedCategoryInfo *self)
{
}

BzCuratedCategoryInfo *
bz_curated_category_info_new (void){
  return g_object_new (BZ_TYPE_CURATED_CATEGORY_INFO, NULL);
}

const char *
bz_curated_category_info_get_title (BzCuratedCategoryInfo *self){
  g_return_val_if_fail (BZ_IS_CURATED_CATEGORY_INFO (self), NULL);
  return self->title;
}

const char *
bz_curated_category_info_get_subtitle (BzCuratedCategoryInfo *self){
  g_return_val_if_fail (BZ_IS_CURATED_CATEGORY_INFO (self), NULL);
  return self->subtitle;
}

const char *
bz_curated_category_info_get_description (BzCuratedCategoryInfo *self){
  g_return_val_if_fail (BZ_IS_CURATED_CATEGORY_INFO (self), NULL);
  return self->description;
}

const char *
bz_curated_category_info_get_banner (BzCuratedCategoryInfo *self){
  g_return_val_if_fail (BZ_IS_CURATED_CATEGORY_INFO (self), NULL);
  return self->banner;
}

const char *
bz_curated_category_info_get_light_banner (BzCuratedCategoryInfo *self){
  g_return_val_if_fail (BZ_IS_CURATED_CATEGORY_INFO (self), NULL);
  return self->light_banner;
}

const char *
bz_curated_category_info_get_dark_banner (BzCuratedCategoryInfo *self){
  g_return_val_if_fail (BZ_IS_CURATED_CATEGORY_INFO (self), NULL);
  return self->dark_banner;
}

int
bz_curated_category_info_get_banner_height (BzCuratedCategoryInfo *self){
  g_return_val_if_fail (BZ_IS_CURATED_CATEGORY_INFO (self), 0);
  return self->banner_height;
}

GtkContentFit
bz_curated_category_info_get_banner_fit (BzCuratedCategoryInfo *self){
  g_return_val_if_fail (BZ_IS_CURATED_CATEGORY_INFO (self), 0);
  return self->banner_fit;
}

GtkAlign
bz_curated_category_info_get_banner_text_halign (BzCuratedCategoryInfo *self){
  g_return_val_if_fail (BZ_IS_CURATED_CATEGORY_INFO (self), 0);
  return self->banner_text_halign;
}

GtkAlign
bz_curated_category_info_get_banner_text_valign (BzCuratedCategoryInfo *self){
  g_return_val_if_fail (BZ_IS_CURATED_CATEGORY_INFO (self), 0);
  return self->banner_text_valign;
}

double
bz_curated_category_info_get_banner_text_label_xalign (BzCuratedCategoryInfo *self){
  g_return_val_if_fail (BZ_IS_CURATED_CATEGORY_INFO (self), 0.0);
  return self->banner_text_label_xalign;
}

GListModel *
bz_curated_category_info_get_appids (BzCuratedCategoryInfo *self){
  g_return_val_if_fail (BZ_IS_CURATED_CATEGORY_INFO (self), NULL);
  return self->appids;
}

gboolean
bz_curated_category_info_get_enable_bulk_install (BzCuratedCategoryInfo *self){
  g_return_val_if_fail (BZ_IS_CURATED_CATEGORY_INFO (self), FALSE);
  return self->enable_bulk_install;
}

void
bz_curated_category_info_set_title (BzCuratedCategoryInfo *self,
    const char *title){
  g_return_if_fail (BZ_IS_CURATED_CATEGORY_INFO (self));

  if (title == self->title || (title != NULL && self->title != NULL && g_strcmp0(title, self->title) == 0))
    return;

  g_clear_pointer (&self->title, g_free);
  if (title != NULL)
    self->title = g_strdup (title);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_TITLE]);
}

void
bz_curated_category_info_set_subtitle (BzCuratedCategoryInfo *self,
    const char *subtitle){
  g_return_if_fail (BZ_IS_CURATED_CATEGORY_INFO (self));

  if (subtitle == self->subtitle || (subtitle != NULL && self->subtitle != NULL && g_strcmp0(subtitle, self->subtitle) == 0))
    return;

  g_clear_pointer (&self->subtitle, g_free);
  if (subtitle != NULL)
    self->subtitle = g_strdup (subtitle);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_SUBTITLE]);
}

void
bz_curated_category_info_set_description (BzCuratedCategoryInfo *self,
    const char *description){
  g_return_if_fail (BZ_IS_CURATED_CATEGORY_INFO (self));

  if (description == self->description || (description != NULL && self->description != NULL && g_strcmp0(description, self->description) == 0))
    return;

  g_clear_pointer (&self->description, g_free);
  if (description != NULL)
    self->description = g_strdup (description);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_DESCRIPTION]);
}

void
bz_curated_category_info_set_banner (BzCuratedCategoryInfo *self,
    const char *banner){
  g_return_if_fail (BZ_IS_CURATED_CATEGORY_INFO (self));

  if (banner == self->banner || (banner != NULL && self->banner != NULL && g_strcmp0(banner, self->banner) == 0))
    return;

  g_clear_pointer (&self->banner, g_free);
  if (banner != NULL)
    self->banner = g_strdup (banner);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_BANNER]);
}

void
bz_curated_category_info_set_light_banner (BzCuratedCategoryInfo *self,
    const char *light_banner){
  g_return_if_fail (BZ_IS_CURATED_CATEGORY_INFO (self));

  if (light_banner == self->light_banner || (light_banner != NULL && self->light_banner != NULL && g_strcmp0(light_banner, self->light_banner) == 0))
    return;

  g_clear_pointer (&self->light_banner, g_free);
  if (light_banner != NULL)
    self->light_banner = g_strdup (light_banner);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_LIGHT_BANNER]);
}

void
bz_curated_category_info_set_dark_banner (BzCuratedCategoryInfo *self,
    const char *dark_banner){
  g_return_if_fail (BZ_IS_CURATED_CATEGORY_INFO (self));

  if (dark_banner == self->dark_banner || (dark_banner != NULL && self->dark_banner != NULL && g_strcmp0(dark_banner, self->dark_banner) == 0))
    return;

  g_clear_pointer (&self->dark_banner, g_free);
  if (dark_banner != NULL)
    self->dark_banner = g_strdup (dark_banner);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_DARK_BANNER]);
}

void
bz_curated_category_info_set_banner_height (BzCuratedCategoryInfo *self,
    int banner_height){
  g_return_if_fail (BZ_IS_CURATED_CATEGORY_INFO (self));

  if (banner_height == self->banner_height)
    return;

  self->banner_height = banner_height;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_BANNER_HEIGHT]);
}

void
bz_curated_category_info_set_banner_fit (BzCuratedCategoryInfo *self,
    GtkContentFit banner_fit){
  g_return_if_fail (BZ_IS_CURATED_CATEGORY_INFO (self));

  if (banner_fit == self->banner_fit)
    return;

  self->banner_fit = banner_fit;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_BANNER_FIT]);
}

void
bz_curated_category_info_set_banner_text_halign (BzCuratedCategoryInfo *self,
    GtkAlign banner_text_halign){
  g_return_if_fail (BZ_IS_CURATED_CATEGORY_INFO (self));

  if (banner_text_halign == self->banner_text_halign)
    return;

  self->banner_text_halign = banner_text_halign;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_BANNER_TEXT_HALIGN]);
}

void
bz_curated_category_info_set_banner_text_valign (BzCuratedCategoryInfo *self,
    GtkAlign banner_text_valign){
  g_return_if_fail (BZ_IS_CURATED_CATEGORY_INFO (self));

  if (banner_text_valign == self->banner_text_valign)
    return;

  self->banner_text_valign = banner_text_valign;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_BANNER_TEXT_VALIGN]);
}

void
bz_curated_category_info_set_banner_text_label_xalign (BzCuratedCategoryInfo *self,
    double banner_text_label_xalign){
  g_return_if_fail (BZ_IS_CURATED_CATEGORY_INFO (self));

  if (banner_text_label_xalign == self->banner_text_label_xalign)
    return;

  self->banner_text_label_xalign = banner_text_label_xalign;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_BANNER_TEXT_LABEL_XALIGN]);
}

void
bz_curated_category_info_set_appids (BzCuratedCategoryInfo *self,
    GListModel *appids){
  g_return_if_fail (BZ_IS_CURATED_CATEGORY_INFO (self));

  if (appids == self->appids)
    return;

  g_clear_pointer (&self->appids, g_object_unref);
  if (appids != NULL)
    self->appids = g_object_ref (appids);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_APPIDS]);
}

void
bz_curated_category_info_set_enable_bulk_install (BzCuratedCategoryInfo *self,
    gboolean enable_bulk_install){
  g_return_if_fail (BZ_IS_CURATED_CATEGORY_INFO (self));

  if (!!enable_bulk_install == !!self->enable_bulk_install)
    return;

  self->enable_bulk_install = enable_bulk_install;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_ENABLE_BULK_INSTALL]);
}

/* End of src/bazaar.p/bz-curated-category-info.c */
