/* SPDX-License-Identifier: (LGPL-2.1 OR BSD-2-Clause) */

/* THIS FILE IS AUTOGENERATED BY BPFTOOL! */
#ifndef __VFSSTAT_BPF_SKEL_H__
#define __VFSSTAT_BPF_SKEL_H__

#include <errno.h>
#include <stdlib.h>
#include <bpf/libbpf.h>

#define BPF_SKEL_SUPPORTS_MAP_AUTO_ATTACH 1

struct vfsstat_bpf {
	struct bpf_object_skeleton *skeleton;
	struct bpf_object *obj;
	struct {
		struct bpf_map *bss;
	} maps;
	struct {
		struct bpf_program *kprobe_vfs_read;
		struct bpf_program *kprobe_vfs_write;
		struct bpf_program *kprobe_vfs_fsync;
		struct bpf_program *kprobe_vfs_open;
		struct bpf_program *kprobe_vfs_create;
		struct bpf_program *kprobe_vfs_unlink;
		struct bpf_program *kprobe_vfs_mkdir;
		struct bpf_program *kprobe_vfs_rmdir;
		struct bpf_program *fentry_vfs_read;
		struct bpf_program *fentry_vfs_write;
		struct bpf_program *fentry_vfs_fsync;
		struct bpf_program *fentry_vfs_open;
		struct bpf_program *fentry_vfs_create;
		struct bpf_program *fentry_vfs_unlink;
		struct bpf_program *fentry_vfs_mkdir;
		struct bpf_program *fentry_vfs_rmdir;
	} progs;
	struct {
		struct bpf_link *kprobe_vfs_read;
		struct bpf_link *kprobe_vfs_write;
		struct bpf_link *kprobe_vfs_fsync;
		struct bpf_link *kprobe_vfs_open;
		struct bpf_link *kprobe_vfs_create;
		struct bpf_link *kprobe_vfs_unlink;
		struct bpf_link *kprobe_vfs_mkdir;
		struct bpf_link *kprobe_vfs_rmdir;
		struct bpf_link *fentry_vfs_read;
		struct bpf_link *fentry_vfs_write;
		struct bpf_link *fentry_vfs_fsync;
		struct bpf_link *fentry_vfs_open;
		struct bpf_link *fentry_vfs_create;
		struct bpf_link *fentry_vfs_unlink;
		struct bpf_link *fentry_vfs_mkdir;
		struct bpf_link *fentry_vfs_rmdir;
	} links;
	struct vfsstat_bpf__bss {
		__u64 stats[8];
	} *bss;

#ifdef __cplusplus
	static inline struct vfsstat_bpf *open(const struct bpf_object_open_opts *opts = nullptr);
	static inline struct vfsstat_bpf *open_and_load();
	static inline int load(struct vfsstat_bpf *skel);
	static inline int attach(struct vfsstat_bpf *skel);
	static inline void detach(struct vfsstat_bpf *skel);
	static inline void destroy(struct vfsstat_bpf *skel);
	static inline const void *elf_bytes(size_t *sz);
#endif /* __cplusplus */
};

static void
vfsstat_bpf__destroy(struct vfsstat_bpf *obj)
{
	if (!obj)
		return;
	if (obj->skeleton)
		bpf_object__destroy_skeleton(obj->skeleton);
	free(obj);
}

static inline int
vfsstat_bpf__create_skeleton(struct vfsstat_bpf *obj);

static inline struct vfsstat_bpf *
vfsstat_bpf__open_opts(const struct bpf_object_open_opts *opts)
{
	struct vfsstat_bpf *obj;
	int err;

	obj = (struct vfsstat_bpf *)calloc(1, sizeof(*obj));
	if (!obj) {
		errno = ENOMEM;
		return NULL;
	}

	err = vfsstat_bpf__create_skeleton(obj);
	if (err)
		goto err_out;

	err = bpf_object__open_skeleton(obj->skeleton, opts);
	if (err)
		goto err_out;

	return obj;
err_out:
	vfsstat_bpf__destroy(obj);
	errno = -err;
	return NULL;
}

static inline struct vfsstat_bpf *
vfsstat_bpf__open(void)
{
	return vfsstat_bpf__open_opts(NULL);
}

static inline int
vfsstat_bpf__load(struct vfsstat_bpf *obj)
{
	return bpf_object__load_skeleton(obj->skeleton);
}

static inline struct vfsstat_bpf *
vfsstat_bpf__open_and_load(void)
{
	struct vfsstat_bpf *obj;
	int err;

	obj = vfsstat_bpf__open();
	if (!obj)
		return NULL;
	err = vfsstat_bpf__load(obj);
	if (err) {
		vfsstat_bpf__destroy(obj);
		errno = -err;
		return NULL;
	}
	return obj;
}

static inline int
vfsstat_bpf__attach(struct vfsstat_bpf *obj)
{
	return bpf_object__attach_skeleton(obj->skeleton);
}

static inline void
vfsstat_bpf__detach(struct vfsstat_bpf *obj)
{
	bpf_object__detach_skeleton(obj->skeleton);
}

static inline const void *vfsstat_bpf__elf_bytes(size_t *sz);

static inline int
vfsstat_bpf__create_skeleton(struct vfsstat_bpf *obj)
{
	struct bpf_object_skeleton *s;
	struct bpf_map_skeleton *map __attribute__((unused));
	int err;

	s = (struct bpf_object_skeleton *)calloc(1, sizeof(*s));
	if (!s)	{
		err = -ENOMEM;
		goto err;
	}

	s->sz = sizeof(*s);
	s->name = "vfsstat_bpf";
	s->obj = &obj->obj;

	/* maps */
	s->map_cnt = 1;
	s->map_skel_sz = 24;
	s->maps = (struct bpf_map_skeleton *)calloc(s->map_cnt,
			sizeof(*s->maps) > 24 ? sizeof(*s->maps) : 24);
	if (!s->maps) {
		err = -ENOMEM;
		goto err;
	}

	map = (struct bpf_map_skeleton *)((char *)s->maps + 0 * s->map_skel_sz);
	map->name = "vfsstat_.bss";
	map->map = &obj->maps.bss;
	map->mmaped = (void **)&obj->bss;

	/* programs */
	s->prog_cnt = 16;
	s->prog_skel_sz = sizeof(*s->progs);
	s->progs = (struct bpf_prog_skeleton *)calloc(s->prog_cnt, s->prog_skel_sz);
	if (!s->progs) {
		err = -ENOMEM;
		goto err;
	}

	s->progs[0].name = "kprobe_vfs_read";
	s->progs[0].prog = &obj->progs.kprobe_vfs_read;
	s->progs[0].link = &obj->links.kprobe_vfs_read;

	s->progs[1].name = "kprobe_vfs_write";
	s->progs[1].prog = &obj->progs.kprobe_vfs_write;
	s->progs[1].link = &obj->links.kprobe_vfs_write;

	s->progs[2].name = "kprobe_vfs_fsync";
	s->progs[2].prog = &obj->progs.kprobe_vfs_fsync;
	s->progs[2].link = &obj->links.kprobe_vfs_fsync;

	s->progs[3].name = "kprobe_vfs_open";
	s->progs[3].prog = &obj->progs.kprobe_vfs_open;
	s->progs[3].link = &obj->links.kprobe_vfs_open;

	s->progs[4].name = "kprobe_vfs_create";
	s->progs[4].prog = &obj->progs.kprobe_vfs_create;
	s->progs[4].link = &obj->links.kprobe_vfs_create;

	s->progs[5].name = "kprobe_vfs_unlink";
	s->progs[5].prog = &obj->progs.kprobe_vfs_unlink;
	s->progs[5].link = &obj->links.kprobe_vfs_unlink;

	s->progs[6].name = "kprobe_vfs_mkdir";
	s->progs[6].prog = &obj->progs.kprobe_vfs_mkdir;
	s->progs[6].link = &obj->links.kprobe_vfs_mkdir;

	s->progs[7].name = "kprobe_vfs_rmdir";
	s->progs[7].prog = &obj->progs.kprobe_vfs_rmdir;
	s->progs[7].link = &obj->links.kprobe_vfs_rmdir;

	s->progs[8].name = "fentry_vfs_read";
	s->progs[8].prog = &obj->progs.fentry_vfs_read;
	s->progs[8].link = &obj->links.fentry_vfs_read;

	s->progs[9].name = "fentry_vfs_write";
	s->progs[9].prog = &obj->progs.fentry_vfs_write;
	s->progs[9].link = &obj->links.fentry_vfs_write;

	s->progs[10].name = "fentry_vfs_fsync";
	s->progs[10].prog = &obj->progs.fentry_vfs_fsync;
	s->progs[10].link = &obj->links.fentry_vfs_fsync;

	s->progs[11].name = "fentry_vfs_open";
	s->progs[11].prog = &obj->progs.fentry_vfs_open;
	s->progs[11].link = &obj->links.fentry_vfs_open;

	s->progs[12].name = "fentry_vfs_create";
	s->progs[12].prog = &obj->progs.fentry_vfs_create;
	s->progs[12].link = &obj->links.fentry_vfs_create;

	s->progs[13].name = "fentry_vfs_unlink";
	s->progs[13].prog = &obj->progs.fentry_vfs_unlink;
	s->progs[13].link = &obj->links.fentry_vfs_unlink;

	s->progs[14].name = "fentry_vfs_mkdir";
	s->progs[14].prog = &obj->progs.fentry_vfs_mkdir;
	s->progs[14].link = &obj->links.fentry_vfs_mkdir;

	s->progs[15].name = "fentry_vfs_rmdir";
	s->progs[15].prog = &obj->progs.fentry_vfs_rmdir;
	s->progs[15].link = &obj->links.fentry_vfs_rmdir;

	s->data = vfsstat_bpf__elf_bytes(&s->data_sz);

	obj->skeleton = s;
	return 0;
err:
	bpf_object__destroy_skeleton(s);
	return err;
}

static inline const void *vfsstat_bpf__elf_bytes(size_t *sz)
{
	static const char data[] __attribute__((__aligned__(8))) = "\
\x7f\x45\x4c\x46\x02\x01\x01\0\0\0\0\0\0\0\0\0\x01\0\xf7\0\x01\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x28\x1e\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\x40\0\x2b\0\
\x01\0\xb7\x01\0\0\x01\0\0\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xdb\x12\0\0\0\
\0\0\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\xb7\x01\0\0\x01\0\0\0\x18\x02\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\xdb\x12\x08\0\0\0\0\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\
\0\xb7\x01\0\0\x01\0\0\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xdb\x12\x10\0\0\0\
\0\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\xb7\x01\0\0\x01\0\0\0\x18\x02\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\xdb\x12\x18\0\0\0\0\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\
\xb7\x01\0\0\x01\0\0\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xdb\x12\x20\0\0\0\0\
\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\xb7\x01\0\0\x01\0\0\0\x18\x02\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\xdb\x12\x28\0\0\0\0\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\
\xb7\x01\0\0\x01\0\0\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xdb\x12\x30\0\0\0\0\
\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\xb7\x01\0\0\x01\0\0\0\x18\x02\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\xdb\x12\x38\0\0\0\0\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\
\xb7\x01\0\0\x01\0\0\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xdb\x12\0\0\0\0\0\0\
\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\xb7\x01\0\0\x01\0\0\0\x18\x02\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\xdb\x12\x08\0\0\0\0\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\xb7\
\x01\0\0\x01\0\0\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xdb\x12\x10\0\0\0\0\0\
\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\xb7\x01\0\0\x01\0\0\0\x18\x02\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\xdb\x12\x18\0\0\0\0\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\xb7\
\x01\0\0\x01\0\0\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xdb\x12\x20\0\0\0\0\0\
\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\xb7\x01\0\0\x01\0\0\0\x18\x02\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\xdb\x12\x28\0\0\0\0\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\xb7\
\x01\0\0\x01\0\0\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xdb\x12\x30\0\0\0\0\0\
\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\xb7\x01\0\0\x01\0\0\0\x18\x02\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\xdb\x12\x38\0\0\0\0\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\x47\
\x50\x4c\0\x9f\xeb\x01\0\x18\0\0\0\0\0\0\0\x44\x05\0\0\x44\x05\0\0\xb0\x05\0\0\
\0\0\0\0\0\0\0\x02\x02\0\0\0\x01\0\0\0\x15\0\0\x04\xa8\0\0\0\x09\0\0\0\x03\0\0\
\0\0\0\0\0\x0d\0\0\0\x03\0\0\0\x40\0\0\0\x11\0\0\0\x03\0\0\0\x80\0\0\0\x15\0\0\
\0\x03\0\0\0\xc0\0\0\0\x19\0\0\0\x03\0\0\0\0\x01\0\0\x1c\0\0\0\x03\0\0\0\x40\
\x01\0\0\x1f\0\0\0\x03\0\0\0\x80\x01\0\0\x23\0\0\0\x03\0\0\0\xc0\x01\0\0\x27\0\
\0\0\x03\0\0\0\0\x02\0\0\x2a\0\0\0\x03\0\0\0\x40\x02\0\0\x2d\0\0\0\x03\0\0\0\
\x80\x02\0\0\x30\0\0\0\x03\0\0\0\xc0\x02\0\0\x33\0\0\0\x03\0\0\0\0\x03\0\0\x36\
\0\0\0\x03\0\0\0\x40\x03\0\0\x39\0\0\0\x03\0\0\0\x80\x03\0\0\x3c\0\0\0\x03\0\0\
\0\xc0\x03\0\0\x44\0\0\0\x03\0\0\0\0\x04\0\0\0\0\0\0\x04\0\0\0\x40\x04\0\0\x47\
\0\0\0\x03\0\0\0\x80\x04\0\0\x4d\0\0\0\x03\0\0\0\xc0\x04\0\0\0\0\0\0\x0c\0\0\0\
\0\x05\0\0\x50\0\0\0\0\0\0\x01\x08\0\0\0\x40\0\0\0\0\0\0\0\x03\0\0\x05\x08\0\0\
\0\x5e\0\0\0\x05\0\0\0\0\0\0\0\x61\0\0\0\x08\0\0\0\0\0\0\0\x65\0\0\0\x0b\0\0\0\
\0\0\0\0\x6d\0\0\0\0\0\0\x08\x06\0\0\0\x71\0\0\0\0\0\0\x08\x07\0\0\0\x77\0\0\0\
\0\0\0\x01\x02\0\0\0\x10\0\0\0\x86\0\0\0\0\0\0\x08\x09\0\0\0\x8a\0\0\0\0\0\0\
\x08\x0a\0\0\0\x90\0\0\0\0\0\0\x01\x08\0\0\0\x40\0\0\0\x65\0\0\0\x03\0\0\x84\
\x08\0\0\0\x5e\0\0\0\x08\0\0\0\0\0\0\x10\xa3\0\0\0\x08\0\0\0\x10\0\0\x02\xa6\0\
\0\0\x08\0\0\0\x12\0\0\x01\0\0\0\0\x03\0\0\x05\x08\0\0\0\xaa\0\0\0\x05\0\0\0\0\
\0\0\0\xad\0\0\0\x08\0\0\0\0\0\0\0\xb1\0\0\0\x0d\0\0\0\0\0\0\0\xb1\0\0\0\x0a\0\
\0\x84\x08\0\0\0\xaa\0\0\0\x08\0\0\0\0\0\0\x10\xb9\0\0\0\x08\0\0\0\x10\0\0\x01\
\xbd\0\0\0\x08\0\0\0\x11\0\0\x01\xc5\0\0\0\x08\0\0\0\x12\0\0\x01\xc9\0\0\0\x08\
\0\0\0\x20\0\0\x08\xd0\0\0\0\x08\0\0\0\x30\0\0\x04\xd5\0\0\0\x08\0\0\0\x38\0\0\
\x01\xdd\0\0\0\x08\0\0\0\x39\0\0\x01\xe0\0\0\0\x08\0\0\0\x3a\0\0\x01\xe7\0\0\0\
\x08\0\0\0\x3c\0\0\x04\0\0\0\0\x01\0\0\x0d\x0f\0\0\0\xef\0\0\0\x01\0\0\0\xf3\0\
\0\0\0\0\0\x01\x04\0\0\0\x20\0\0\x01\xf7\0\0\0\x01\0\0\x0c\x0e\0\0\0\0\0\0\0\
\x01\0\0\x0d\x0f\0\0\0\xef\0\0\0\x01\0\0\0\x9c\x01\0\0\x01\0\0\x0c\x11\0\0\0\0\
\0\0\0\x01\0\0\x0d\x0f\0\0\0\xef\0\0\0\x01\0\0\0\xdf\x01\0\0\x01\0\0\x0c\x13\0\
\0\0\0\0\0\0\x01\0\0\x0d\x0f\0\0\0\xef\0\0\0\x01\0\0\0\x22\x02\0\0\x01\0\0\x0c\
\x15\0\0\0\0\0\0\0\x01\0\0\x0d\x0f\0\0\0\xef\0\0\0\x01\0\0\0\x62\x02\0\0\x01\0\
\0\x0c\x17\0\0\0\0\0\0\0\x01\0\0\x0d\x0f\0\0\0\xef\0\0\0\x01\0\0\0\xa8\x02\0\0\
\x01\0\0\x0c\x19\0\0\0\0\0\0\0\x01\0\0\x0d\x0f\0\0\0\xef\0\0\0\x01\0\0\0\xee\
\x02\0\0\x01\0\0\x0c\x1b\0\0\0\0\0\0\0\x01\0\0\x0d\x0f\0\0\0\xef\0\0\0\x01\0\0\
\0\x31\x03\0\0\x01\0\0\x0c\x1d\0\0\0\0\0\0\0\0\0\0\x02\x0a\0\0\0\0\0\0\0\x01\0\
\0\x0d\x0f\0\0\0\xef\0\0\0\x1f\0\0\0\x74\x03\0\0\x01\0\0\x0c\x20\0\0\0\0\0\0\0\
\x01\0\0\x0d\x0f\0\0\0\xef\0\0\0\x1f\0\0\0\xb2\x03\0\0\x01\0\0\x0c\x22\0\0\0\0\
\0\0\0\x01\0\0\x0d\x0f\0\0\0\xef\0\0\0\x1f\0\0\0\xf3\x03\0\0\x01\0\0\x0c\x24\0\
\0\0\0\0\0\0\x01\0\0\x0d\x0f\0\0\0\xef\0\0\0\x1f\0\0\0\x34\x04\0\0\x01\0\0\x0c\
\x26\0\0\0\0\0\0\0\x01\0\0\x0d\x0f\0\0\0\xef\0\0\0\x1f\0\0\0\x72\x04\0\0\x01\0\
\0\x0c\x28\0\0\0\0\0\0\0\x01\0\0\x0d\x0f\0\0\0\xef\0\0\0\x1f\0\0\0\xb6\x04\0\0\
\x01\0\0\x0c\x2a\0\0\0\0\0\0\0\x01\0\0\x0d\x0f\0\0\0\xef\0\0\0\x1f\0\0\0\xfa\
\x04\0\0\x01\0\0\x0c\x2c\0\0\0\0\0\0\0\x01\0\0\x0d\x0f\0\0\0\xef\0\0\0\x1f\0\0\
\0\x3b\x05\0\0\x01\0\0\x0c\x2e\0\0\0\0\0\0\0\0\0\0\x03\0\0\0\0\x09\0\0\0\x31\0\
\0\0\x08\0\0\0\x7c\x05\0\0\0\0\0\x01\x04\0\0\0\x20\0\0\0\x90\x05\0\0\0\0\0\x0e\
\x30\0\0\0\x01\0\0\0\x96\x05\0\0\0\0\0\x01\x01\0\0\0\x08\0\0\x01\0\0\0\0\0\0\0\
\x03\0\0\0\0\x33\0\0\0\x31\0\0\0\x04\0\0\0\x9b\x05\0\0\0\0\0\x0e\x34\0\0\0\x01\
\0\0\0\xa3\x05\0\0\x01\0\0\x0f\0\0\0\0\x32\0\0\0\0\0\0\0\x40\0\0\0\xa8\x05\0\0\
\x01\0\0\x0f\0\0\0\0\x35\0\0\0\0\0\0\0\x04\0\0\0\0\x70\x74\x5f\x72\x65\x67\x73\
\0\x72\x31\x35\0\x72\x31\x34\0\x72\x31\x33\0\x72\x31\x32\0\x62\x70\0\x62\x78\0\
\x72\x31\x31\0\x72\x31\x30\0\x72\x39\0\x72\x38\0\x61\x78\0\x63\x78\0\x64\x78\0\
\x73\x69\0\x64\x69\0\x6f\x72\x69\x67\x5f\x61\x78\0\x69\x70\0\x66\x6c\x61\x67\
\x73\0\x73\x70\0\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\x6c\x6f\x6e\x67\0\x63\x73\
\0\x63\x73\x78\0\x66\x72\x65\x64\x5f\x63\x73\0\x75\x31\x36\0\x5f\x5f\x75\x31\
\x36\0\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\x73\x68\x6f\x72\x74\0\x75\x36\x34\0\
\x5f\x5f\x75\x36\x34\0\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\x6c\x6f\x6e\x67\x20\
\x6c\x6f\x6e\x67\0\x73\x6c\0\x77\x66\x65\0\x73\x73\0\x73\x73\x78\0\x66\x72\x65\
\x64\x5f\x73\x73\0\x73\x74\x69\0\x73\x77\x65\x76\x65\x6e\x74\0\x6e\x6d\x69\0\
\x76\x65\x63\x74\x6f\x72\0\x74\x79\x70\x65\0\x65\x6e\x63\x6c\x61\x76\x65\0\x6c\
\x6d\0\x6e\x65\x73\x74\x65\x64\0\x69\x6e\x73\x6e\x6c\x65\x6e\0\x63\x74\x78\0\
\x69\x6e\x74\0\x6b\x70\x72\x6f\x62\x65\x5f\x76\x66\x73\x5f\x72\x65\x61\x64\0\
\x6b\x70\x72\x6f\x62\x65\x2f\x76\x66\x73\x5f\x72\x65\x61\x64\0\x2f\x62\x75\x69\
\x6c\x64\x2f\x62\x63\x63\x2f\x73\x72\x63\x2f\x62\x63\x63\x2f\x6c\x69\x62\x62\
\x70\x66\x2d\x74\x6f\x6f\x6c\x73\x2f\x76\x66\x73\x73\x74\x61\x74\x2e\x62\x70\
\x66\x2e\x63\0\x69\x6e\x74\x20\x42\x50\x46\x5f\x4b\x50\x52\x4f\x42\x45\x28\x6b\
\x70\x72\x6f\x62\x65\x5f\x76\x66\x73\x5f\x72\x65\x61\x64\x29\0\x09\x5f\x5f\x61\
\x74\x6f\x6d\x69\x63\x5f\x61\x64\x64\x5f\x66\x65\x74\x63\x68\x28\x26\x73\x74\
\x61\x74\x73\x5b\x6b\x65\x79\x5d\x2c\x20\x31\x2c\x20\x5f\x5f\x41\x54\x4f\x4d\
\x49\x43\x5f\x52\x45\x4c\x41\x58\x45\x44\x29\x3b\0\x6b\x70\x72\x6f\x62\x65\x5f\
\x76\x66\x73\x5f\x77\x72\x69\x74\x65\0\x6b\x70\x72\x6f\x62\x65\x2f\x76\x66\x73\
\x5f\x77\x72\x69\x74\x65\0\x69\x6e\x74\x20\x42\x50\x46\x5f\x4b\x50\x52\x4f\x42\
\x45\x28\x6b\x70\x72\x6f\x62\x65\x5f\x76\x66\x73\x5f\x77\x72\x69\x74\x65\x29\0\
\x6b\x70\x72\x6f\x62\x65\x5f\x76\x66\x73\x5f\x66\x73\x79\x6e\x63\0\x6b\x70\x72\
\x6f\x62\x65\x2f\x76\x66\x73\x5f\x66\x73\x79\x6e\x63\0\x69\x6e\x74\x20\x42\x50\
\x46\x5f\x4b\x50\x52\x4f\x42\x45\x28\x6b\x70\x72\x6f\x62\x65\x5f\x76\x66\x73\
\x5f\x66\x73\x79\x6e\x63\x29\0\x6b\x70\x72\x6f\x62\x65\x5f\x76\x66\x73\x5f\x6f\
\x70\x65\x6e\0\x6b\x70\x72\x6f\x62\x65\x2f\x76\x66\x73\x5f\x6f\x70\x65\x6e\0\
\x69\x6e\x74\x20\x42\x50\x46\x5f\x4b\x50\x52\x4f\x42\x45\x28\x6b\x70\x72\x6f\
\x62\x65\x5f\x76\x66\x73\x5f\x6f\x70\x65\x6e\x29\0\x6b\x70\x72\x6f\x62\x65\x5f\
\x76\x66\x73\x5f\x63\x72\x65\x61\x74\x65\0\x6b\x70\x72\x6f\x62\x65\x2f\x76\x66\
\x73\x5f\x63\x72\x65\x61\x74\x65\0\x69\x6e\x74\x20\x42\x50\x46\x5f\x4b\x50\x52\
\x4f\x42\x45\x28\x6b\x70\x72\x6f\x62\x65\x5f\x76\x66\x73\x5f\x63\x72\x65\x61\
\x74\x65\x29\0\x6b\x70\x72\x6f\x62\x65\x5f\x76\x66\x73\x5f\x75\x6e\x6c\x69\x6e\
\x6b\0\x6b\x70\x72\x6f\x62\x65\x2f\x76\x66\x73\x5f\x75\x6e\x6c\x69\x6e\x6b\0\
\x69\x6e\x74\x20\x42\x50\x46\x5f\x4b\x50\x52\x4f\x42\x45\x28\x6b\x70\x72\x6f\
\x62\x65\x5f\x76\x66\x73\x5f\x75\x6e\x6c\x69\x6e\x6b\x29\0\x6b\x70\x72\x6f\x62\
\x65\x5f\x76\x66\x73\x5f\x6d\x6b\x64\x69\x72\0\x6b\x70\x72\x6f\x62\x65\x2f\x76\
\x66\x73\x5f\x6d\x6b\x64\x69\x72\0\x69\x6e\x74\x20\x42\x50\x46\x5f\x4b\x50\x52\
\x4f\x42\x45\x28\x6b\x70\x72\x6f\x62\x65\x5f\x76\x66\x73\x5f\x6d\x6b\x64\x69\
\x72\x29\0\x6b\x70\x72\x6f\x62\x65\x5f\x76\x66\x73\x5f\x72\x6d\x64\x69\x72\0\
\x6b\x70\x72\x6f\x62\x65\x2f\x76\x66\x73\x5f\x72\x6d\x64\x69\x72\0\x69\x6e\x74\
\x20\x42\x50\x46\x5f\x4b\x50\x52\x4f\x42\x45\x28\x6b\x70\x72\x6f\x62\x65\x5f\
\x76\x66\x73\x5f\x72\x6d\x64\x69\x72\x29\0\x66\x65\x6e\x74\x72\x79\x5f\x76\x66\
\x73\x5f\x72\x65\x61\x64\0\x66\x65\x6e\x74\x72\x79\x2f\x76\x66\x73\x5f\x72\x65\
\x61\x64\0\x69\x6e\x74\x20\x42\x50\x46\x5f\x50\x52\x4f\x47\x28\x66\x65\x6e\x74\
\x72\x79\x5f\x76\x66\x73\x5f\x72\x65\x61\x64\x29\0\x66\x65\x6e\x74\x72\x79\x5f\
\x76\x66\x73\x5f\x77\x72\x69\x74\x65\0\x66\x65\x6e\x74\x72\x79\x2f\x76\x66\x73\
\x5f\x77\x72\x69\x74\x65\0\x69\x6e\x74\x20\x42\x50\x46\x5f\x50\x52\x4f\x47\x28\
\x66\x65\x6e\x74\x72\x79\x5f\x76\x66\x73\x5f\x77\x72\x69\x74\x65\x29\0\x66\x65\
\x6e\x74\x72\x79\x5f\x76\x66\x73\x5f\x66\x73\x79\x6e\x63\0\x66\x65\x6e\x74\x72\
\x79\x2f\x76\x66\x73\x5f\x66\x73\x79\x6e\x63\0\x69\x6e\x74\x20\x42\x50\x46\x5f\
\x50\x52\x4f\x47\x28\x66\x65\x6e\x74\x72\x79\x5f\x76\x66\x73\x5f\x66\x73\x79\
\x6e\x63\x29\0\x66\x65\x6e\x74\x72\x79\x5f\x76\x66\x73\x5f\x6f\x70\x65\x6e\0\
\x66\x65\x6e\x74\x72\x79\x2f\x76\x66\x73\x5f\x6f\x70\x65\x6e\0\x69\x6e\x74\x20\
\x42\x50\x46\x5f\x50\x52\x4f\x47\x28\x66\x65\x6e\x74\x72\x79\x5f\x76\x66\x73\
\x5f\x6f\x70\x65\x6e\x29\0\x66\x65\x6e\x74\x72\x79\x5f\x76\x66\x73\x5f\x63\x72\
\x65\x61\x74\x65\0\x66\x65\x6e\x74\x72\x79\x2f\x76\x66\x73\x5f\x63\x72\x65\x61\
\x74\x65\0\x69\x6e\x74\x20\x42\x50\x46\x5f\x50\x52\x4f\x47\x28\x66\x65\x6e\x74\
\x72\x79\x5f\x76\x66\x73\x5f\x63\x72\x65\x61\x74\x65\x29\0\x66\x65\x6e\x74\x72\
\x79\x5f\x76\x66\x73\x5f\x75\x6e\x6c\x69\x6e\x6b\0\x66\x65\x6e\x74\x72\x79\x2f\
\x76\x66\x73\x5f\x75\x6e\x6c\x69\x6e\x6b\0\x69\x6e\x74\x20\x42\x50\x46\x5f\x50\
\x52\x4f\x47\x28\x66\x65\x6e\x74\x72\x79\x5f\x76\x66\x73\x5f\x75\x6e\x6c\x69\
\x6e\x6b\x29\0\x66\x65\x6e\x74\x72\x79\x5f\x76\x66\x73\x5f\x6d\x6b\x64\x69\x72\
\0\x66\x65\x6e\x74\x72\x79\x2f\x76\x66\x73\x5f\x6d\x6b\x64\x69\x72\0\x69\x6e\
\x74\x20\x42\x50\x46\x5f\x50\x52\x4f\x47\x28\x66\x65\x6e\x74\x72\x79\x5f\x76\
\x66\x73\x5f\x6d\x6b\x64\x69\x72\x29\0\x66\x65\x6e\x74\x72\x79\x5f\x76\x66\x73\
\x5f\x72\x6d\x64\x69\x72\0\x66\x65\x6e\x74\x72\x79\x2f\x76\x66\x73\x5f\x72\x6d\
\x64\x69\x72\0\x69\x6e\x74\x20\x42\x50\x46\x5f\x50\x52\x4f\x47\x28\x66\x65\x6e\
\x74\x72\x79\x5f\x76\x66\x73\x5f\x72\x6d\x64\x69\x72\x29\0\x5f\x5f\x41\x52\x52\
\x41\x59\x5f\x53\x49\x5a\x45\x5f\x54\x59\x50\x45\x5f\x5f\0\x73\x74\x61\x74\x73\
\0\x63\x68\x61\x72\0\x4c\x49\x43\x45\x4e\x53\x45\0\x2e\x62\x73\x73\0\x6c\x69\
\x63\x65\x6e\x73\x65\0\x9f\xeb\x01\0\x20\0\0\0\0\0\0\0\x04\x01\0\0\x04\x01\0\0\
\x84\x03\0\0\x88\x04\0\0\0\0\0\0\x08\0\0\0\x07\x01\0\0\x01\0\0\0\0\0\0\0\x10\0\
\0\0\xad\x01\0\0\x01\0\0\0\0\0\0\0\x12\0\0\0\xf0\x01\0\0\x01\0\0\0\0\0\0\0\x14\
\0\0\0\x32\x02\0\0\x01\0\0\0\0\0\0\0\x16\0\0\0\x74\x02\0\0\x01\0\0\0\0\0\0\0\
\x18\0\0\0\xba\x02\0\0\x01\0\0\0\0\0\0\0\x1a\0\0\0\xff\x02\0\0\x01\0\0\0\0\0\0\
\0\x1c\0\0\0\x42\x03\0\0\x01\0\0\0\0\0\0\0\x1e\0\0\0\x84\x03\0\0\x01\0\0\0\0\0\
\0\0\x21\0\0\0\xc3\x03\0\0\x01\0\0\0\0\0\0\0\x23\0\0\0\x04\x04\0\0\x01\0\0\0\0\
\0\0\0\x25\0\0\0\x44\x04\0\0\x01\0\0\0\0\0\0\0\x27\0\0\0\x84\x04\0\0\x01\0\0\0\
\0\0\0\0\x29\0\0\0\xc8\x04\0\0\x01\0\0\0\0\0\0\0\x2b\0\0\0\x0b\x05\0\0\x01\0\0\
\0\0\0\0\0\x2d\0\0\0\x4c\x05\0\0\x01\0\0\0\0\0\0\0\x2f\0\0\0\x10\0\0\0\x07\x01\
\0\0\x03\0\0\0\0\0\0\0\x17\x01\0\0\x45\x01\0\0\0\x4c\0\0\x08\0\0\0\x17\x01\0\0\
\x65\x01\0\0\x02\x38\0\0\x20\0\0\0\x17\x01\0\0\x45\x01\0\0\x05\x4c\0\0\xad\x01\
\0\0\x03\0\0\0\0\0\0\0\x17\x01\0\0\xbe\x01\0\0\0\x64\0\0\x08\0\0\0\x17\x01\0\0\
\x65\x01\0\0\x02\x38\0\0\x20\0\0\0\x17\x01\0\0\xbe\x01\0\0\x05\x64\0\0\xf0\x01\
\0\0\x03\0\0\0\0\0\0\0\x17\x01\0\0\x01\x02\0\0\0\x7c\0\0\x08\0\0\0\x17\x01\0\0\
\x65\x01\0\0\x02\x38\0\0\x20\0\0\0\x17\x01\0\0\x01\x02\0\0\x05\x7c\0\0\x32\x02\
\0\0\x03\0\0\0\0\0\0\0\x17\x01\0\0\x42\x02\0\0\0\x94\0\0\x08\0\0\0\x17\x01\0\0\
\x65\x01\0\0\x02\x38\0\0\x20\0\0\0\x17\x01\0\0\x42\x02\0\0\x05\x94\0\0\x74\x02\
\0\0\x03\0\0\0\0\0\0\0\x17\x01\0\0\x86\x02\0\0\0\xac\0\0\x08\0\0\0\x17\x01\0\0\
\x65\x01\0\0\x02\x38\0\0\x20\0\0\0\x17\x01\0\0\x86\x02\0\0\x05\xac\0\0\xba\x02\
\0\0\x03\0\0\0\0\0\0\0\x17\x01\0\0\xcc\x02\0\0\0\xc4\0\0\x08\0\0\0\x17\x01\0\0\
\x65\x01\0\0\x02\x38\0\0\x20\0\0\0\x17\x01\0\0\xcc\x02\0\0\x05\xc4\0\0\xff\x02\
\0\0\x03\0\0\0\0\0\0\0\x17\x01\0\0\x10\x03\0\0\0\xdc\0\0\x08\0\0\0\x17\x01\0\0\
\x65\x01\0\0\x02\x38\0\0\x20\0\0\0\x17\x01\0\0\x10\x03\0\0\x05\xdc\0\0\x42\x03\
\0\0\x03\0\0\0\0\0\0\0\x17\x01\0\0\x53\x03\0\0\0\xf4\0\0\x08\0\0\0\x17\x01\0\0\
\x65\x01\0\0\x02\x38\0\0\x20\0\0\0\x17\x01\0\0\x53\x03\0\0\x05\xf4\0\0\x84\x03\
\0\0\x03\0\0\0\0\0\0\0\x17\x01\0\0\x94\x03\0\0\0\x0c\x01\0\x08\0\0\0\x17\x01\0\
\0\x65\x01\0\0\x02\x38\0\0\x20\0\0\0\x17\x01\0\0\x94\x03\0\0\x05\x0c\x01\0\xc3\
\x03\0\0\x03\0\0\0\0\0\0\0\x17\x01\0\0\xd4\x03\0\0\0\x24\x01\0\x08\0\0\0\x17\
\x01\0\0\x65\x01\0\0\x02\x38\0\0\x20\0\0\0\x17\x01\0\0\xd4\x03\0\0\x05\x24\x01\
\0\x04\x04\0\0\x03\0\0\0\0\0\0\0\x17\x01\0\0\x15\x04\0\0\0\x3c\x01\0\x08\0\0\0\
\x17\x01\0\0\x65\x01\0\0\x02\x38\0\0\x20\0\0\0\x17\x01\0\0\x15\x04\0\0\x05\x3c\
\x01\0\x44\x04\0\0\x03\0\0\0\0\0\0\0\x17\x01\0\0\x54\x04\0\0\0\x54\x01\0\x08\0\
\0\0\x17\x01\0\0\x65\x01\0\0\x02\x38\0\0\x20\0\0\0\x17\x01\0\0\x54\x04\0\0\x05\
\x54\x01\0\x84\x04\0\0\x03\0\0\0\0\0\0\0\x17\x01\0\0\x96\x04\0\0\0\x6c\x01\0\
\x08\0\0\0\x17\x01\0\0\x65\x01\0\0\x02\x38\0\0\x20\0\0\0\x17\x01\0\0\x96\x04\0\
\0\x05\x6c\x01\0\xc8\x04\0\0\x03\0\0\0\0\0\0\0\x17\x01\0\0\xda\x04\0\0\0\x84\
\x01\0\x08\0\0\0\x17\x01\0\0\x65\x01\0\0\x02\x38\0\0\x20\0\0\0\x17\x01\0\0\xda\
\x04\0\0\x05\x84\x01\0\x0b\x05\0\0\x03\0\0\0\0\0\0\0\x17\x01\0\0\x1c\x05\0\0\0\
\x9c\x01\0\x08\0\0\0\x17\x01\0\0\x65\x01\0\0\x02\x38\0\0\x20\0\0\0\x17\x01\0\0\
\x1c\x05\0\0\x05\x9c\x01\0\x4c\x05\0\0\x03\0\0\0\0\0\0\0\x17\x01\0\0\x5d\x05\0\
\0\0\xb4\x01\0\x08\0\0\0\x17\x01\0\0\x65\x01\0\0\x02\x38\0\0\x20\0\0\0\x17\x01\
\0\0\x5d\x05\0\0\x05\xb4\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\x03\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x05\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x07\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\x03\0\x09\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x0b\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x0d\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\x03\0\x0f\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x11\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x13\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\x03\0\x15\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x17\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x19\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\x03\0\x1b\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x1d\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x1f\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\x03\0\x21\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x11\x02\0\0\x12\0\x03\0\0\
\0\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\x14\0\0\0\x11\0\x23\0\0\0\0\0\0\0\0\0\x40\0\0\
\0\0\0\0\0\x6e\x01\0\0\x12\0\x05\0\0\0\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\x5a\x02\0\
\0\x12\0\x07\0\0\0\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\xc7\0\0\0\x12\0\x09\0\0\0\0\0\
\0\0\0\0\x30\0\0\0\0\0\0\0\xbb\x01\0\0\x12\0\x0b\0\0\0\0\0\0\0\0\0\x30\0\0\0\0\
\0\0\0\x11\x01\0\0\x12\0\x0d\0\0\0\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\x7c\0\0\0\x12\
\0\x0f\0\0\0\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\x30\0\0\0\x12\0\x11\0\0\0\0\0\0\0\0\
\0\x30\0\0\0\0\0\0\0\x01\x02\0\0\x12\0\x13\0\0\0\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\
\x5d\x01\0\0\x12\0\x15\0\0\0\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\x49\x02\0\0\x12\0\
\x17\0\0\0\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\xb7\0\0\0\x12\0\x19\0\0\0\0\0\0\0\0\0\
\x30\0\0\0\0\0\0\0\xa9\x01\0\0\x12\0\x1b\0\0\0\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\
\xff\0\0\0\x12\0\x1d\0\0\0\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\x6b\0\0\0\x12\0\x1f\0\
\0\0\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\x1f\0\0\0\x12\0\x21\0\0\0\0\0\0\0\0\0\x30\0\
\0\0\0\0\0\0\xae\x02\0\0\x11\0\x24\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\x08\0\0\
\0\0\0\0\0\x01\0\0\0\x12\0\0\0\x08\0\0\0\0\0\0\0\x01\0\0\0\x12\0\0\0\x08\0\0\0\
\0\0\0\0\x01\0\0\0\x12\0\0\0\x08\0\0\0\0\0\0\0\x01\0\0\0\x12\0\0\0\x08\0\0\0\0\
\0\0\0\x01\0\0\0\x12\0\0\0\x08\0\0\0\0\0\0\0\x01\0\0\0\x12\0\0\0\x08\0\0\0\0\0\
\0\0\x01\0\0\0\x12\0\0\0\x08\0\0\0\0\0\0\0\x01\0\0\0\x12\0\0\0\x08\0\0\0\0\0\0\
\0\x01\0\0\0\x12\0\0\0\x08\0\0\0\0\0\0\0\x01\0\0\0\x12\0\0\0\x08\0\0\0\0\0\0\0\
\x01\0\0\0\x12\0\0\0\x08\0\0\0\0\0\0\0\x01\0\0\0\x12\0\0\0\x08\0\0\0\0\0\0\0\
\x01\0\0\0\x12\0\0\0\x08\0\0\0\0\0\0\0\x01\0\0\0\x12\0\0\0\x08\0\0\0\0\0\0\0\
\x01\0\0\0\x12\0\0\0\x08\0\0\0\0\0\0\0\x01\0\0\0\x12\0\0\0\x3c\x05\0\0\0\0\0\0\
\x04\0\0\0\x12\0\0\0\x54\x05\0\0\0\0\0\0\x04\0\0\0\x22\0\0\0\x2c\0\0\0\0\0\0\0\
\x04\0\0\0\x01\0\0\0\x3c\0\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x4c\0\0\0\0\0\0\0\
\x04\0\0\0\x03\0\0\0\x5c\0\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x6c\0\0\0\0\0\0\0\
\x04\0\0\0\x05\0\0\0\x7c\0\0\0\0\0\0\0\x04\0\0\0\x06\0\0\0\x8c\0\0\0\0\0\0\0\
\x04\0\0\0\x07\0\0\0\x9c\0\0\0\0\0\0\0\x04\0\0\0\x08\0\0\0\xac\0\0\0\0\0\0\0\
\x04\0\0\0\x09\0\0\0\xbc\0\0\0\0\0\0\0\x04\0\0\0\x0a\0\0\0\xcc\0\0\0\0\0\0\0\
\x04\0\0\0\x0b\0\0\0\xdc\0\0\0\0\0\0\0\x04\0\0\0\x0c\0\0\0\xec\0\0\0\0\0\0\0\
\x04\0\0\0\x0d\0\0\0\xfc\0\0\0\0\0\0\0\x04\0\0\0\x0e\0\0\0\x0c\x01\0\0\0\0\0\0\
\x04\0\0\0\x0f\0\0\0\x1c\x01\0\0\0\0\0\0\x04\0\0\0\x10\0\0\0\x30\x01\0\0\0\0\0\
\0\x04\0\0\0\x01\0\0\0\x40\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x50\x01\0\0\0\0\
\0\0\x04\0\0\0\x01\0\0\0\x68\x01\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x78\x01\0\0\0\
\0\0\0\x04\0\0\0\x02\0\0\0\x88\x01\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xa0\x01\0\0\
\0\0\0\0\x04\0\0\0\x03\0\0\0\xb0\x01\0\0\0\0\0\0\x04\0\0\0\x03\0\0\0\xc0\x01\0\
\0\0\0\0\0\x04\0\0\0\x03\0\0\0\xd8\x01\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\xe8\x01\
\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\xf8\x01\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x10\
\x02\0\0\0\0\0\0\x04\0\0\0\x05\0\0\0\x20\x02\0\0\0\0\0\0\x04\0\0\0\x05\0\0\0\
\x30\x02\0\0\0\0\0\0\x04\0\0\0\x05\0\0\0\x48\x02\0\0\0\0\0\0\x04\0\0\0\x06\0\0\
\0\x58\x02\0\0\0\0\0\0\x04\0\0\0\x06\0\0\0\x68\x02\0\0\0\0\0\0\x04\0\0\0\x06\0\
\0\0\x80\x02\0\0\0\0\0\0\x04\0\0\0\x07\0\0\0\x90\x02\0\0\0\0\0\0\x04\0\0\0\x07\
\0\0\0\xa0\x02\0\0\0\0\0\0\x04\0\0\0\x07\0\0\0\xb8\x02\0\0\0\0\0\0\x04\0\0\0\
\x08\0\0\0\xc8\x02\0\0\0\0\0\0\x04\0\0\0\x08\0\0\0\xd8\x02\0\0\0\0\0\0\x04\0\0\
\0\x08\0\0\0\xf0\x02\0\0\0\0\0\0\x04\0\0\0\x09\0\0\0\0\x03\0\0\0\0\0\0\x04\0\0\
\0\x09\0\0\0\x10\x03\0\0\0\0\0\0\x04\0\0\0\x09\0\0\0\x28\x03\0\0\0\0\0\0\x04\0\
\0\0\x0a\0\0\0\x38\x03\0\0\0\0\0\0\x04\0\0\0\x0a\0\0\0\x48\x03\0\0\0\0\0\0\x04\
\0\0\0\x0a\0\0\0\x60\x03\0\0\0\0\0\0\x04\0\0\0\x0b\0\0\0\x70\x03\0\0\0\0\0\0\
\x04\0\0\0\x0b\0\0\0\x80\x03\0\0\0\0\0\0\x04\0\0\0\x0b\0\0\0\x98\x03\0\0\0\0\0\
\0\x04\0\0\0\x0c\0\0\0\xa8\x03\0\0\0\0\0\0\x04\0\0\0\x0c\0\0\0\xb8\x03\0\0\0\0\
\0\0\x04\0\0\0\x0c\0\0\0\xd0\x03\0\0\0\0\0\0\x04\0\0\0\x0d\0\0\0\xe0\x03\0\0\0\
\0\0\0\x04\0\0\0\x0d\0\0\0\xf0\x03\0\0\0\0\0\0\x04\0\0\0\x0d\0\0\0\x08\x04\0\0\
\0\0\0\0\x04\0\0\0\x0e\0\0\0\x18\x04\0\0\0\0\0\0\x04\0\0\0\x0e\0\0\0\x28\x04\0\
\0\0\0\0\0\x04\0\0\0\x0e\0\0\0\x40\x04\0\0\0\0\0\0\x04\0\0\0\x0f\0\0\0\x50\x04\
\0\0\0\0\0\0\x04\0\0\0\x0f\0\0\0\x60\x04\0\0\0\0\0\0\x04\0\0\0\x0f\0\0\0\x78\
\x04\0\0\0\0\0\0\x04\0\0\0\x10\0\0\0\x88\x04\0\0\0\0\0\0\x04\0\0\0\x10\0\0\0\
\x98\x04\0\0\0\0\0\0\x04\0\0\0\x10\0\0\0\x1a\x1c\x1d\x1e\x1f\x20\x21\x22\x23\
\x24\x25\x26\x27\x28\x29\x2a\x1b\x2b\0\x2e\x74\x65\x78\x74\0\x2e\x72\x65\x6c\
\x2e\x42\x54\x46\x2e\x65\x78\x74\0\x73\x74\x61\x74\x73\0\x2e\x62\x73\x73\0\x66\
\x65\x6e\x74\x72\x79\x5f\x76\x66\x73\x5f\x72\x6d\x64\x69\x72\0\x6b\x70\x72\x6f\
\x62\x65\x5f\x76\x66\x73\x5f\x72\x6d\x64\x69\x72\0\x2e\x72\x65\x6c\x66\x65\x6e\
\x74\x72\x79\x2f\x76\x66\x73\x5f\x72\x6d\x64\x69\x72\0\x2e\x72\x65\x6c\x6b\x70\
\x72\x6f\x62\x65\x2f\x76\x66\x73\x5f\x72\x6d\x64\x69\x72\0\x66\x65\x6e\x74\x72\
\x79\x5f\x76\x66\x73\x5f\x6d\x6b\x64\x69\x72\0\x6b\x70\x72\x6f\x62\x65\x5f\x76\
\x66\x73\x5f\x6d\x6b\x64\x69\x72\0\x2e\x72\x65\x6c\x66\x65\x6e\x74\x72\x79\x2f\
\x76\x66\x73\x5f\x6d\x6b\x64\x69\x72\0\x2e\x72\x65\x6c\x6b\x70\x72\x6f\x62\x65\
\x2f\x76\x66\x73\x5f\x6d\x6b\x64\x69\x72\0\x66\x65\x6e\x74\x72\x79\x5f\x76\x66\
\x73\x5f\x6f\x70\x65\x6e\0\x6b\x70\x72\x6f\x62\x65\x5f\x76\x66\x73\x5f\x6f\x70\
\x65\x6e\0\x2e\x72\x65\x6c\x66\x65\x6e\x74\x72\x79\x2f\x76\x66\x73\x5f\x6f\x70\
\x65\x6e\0\x2e\x72\x65\x6c\x6b\x70\x72\x6f\x62\x65\x2f\x76\x66\x73\x5f\x6f\x70\
\x65\x6e\0\x66\x65\x6e\x74\x72\x79\x5f\x76\x66\x73\x5f\x75\x6e\x6c\x69\x6e\x6b\
\0\x6b\x70\x72\x6f\x62\x65\x5f\x76\x66\x73\x5f\x75\x6e\x6c\x69\x6e\x6b\0\x2e\
\x72\x65\x6c\x66\x65\x6e\x74\x72\x79\x2f\x76\x66\x73\x5f\x75\x6e\x6c\x69\x6e\
\x6b\0\x2e\x72\x65\x6c\x6b\x70\x72\x6f\x62\x65\x2f\x76\x66\x73\x5f\x75\x6e\x6c\
\x69\x6e\x6b\0\x2e\x6c\x6c\x76\x6d\x5f\x61\x64\x64\x72\x73\x69\x67\0\x66\x65\
\x6e\x74\x72\x79\x5f\x76\x66\x73\x5f\x77\x72\x69\x74\x65\0\x6b\x70\x72\x6f\x62\
\x65\x5f\x76\x66\x73\x5f\x77\x72\x69\x74\x65\0\x2e\x72\x65\x6c\x66\x65\x6e\x74\
\x72\x79\x2f\x76\x66\x73\x5f\x77\x72\x69\x74\x65\0\x2e\x72\x65\x6c\x6b\x70\x72\
\x6f\x62\x65\x2f\x76\x66\x73\x5f\x77\x72\x69\x74\x65\0\x66\x65\x6e\x74\x72\x79\
\x5f\x76\x66\x73\x5f\x63\x72\x65\x61\x74\x65\0\x6b\x70\x72\x6f\x62\x65\x5f\x76\
\x66\x73\x5f\x63\x72\x65\x61\x74\x65\0\x2e\x72\x65\x6c\x66\x65\x6e\x74\x72\x79\
\x2f\x76\x66\x73\x5f\x63\x72\x65\x61\x74\x65\0\x2e\x72\x65\x6c\x6b\x70\x72\x6f\
\x62\x65\x2f\x76\x66\x73\x5f\x63\x72\x65\x61\x74\x65\0\x6c\x69\x63\x65\x6e\x73\
\x65\0\x66\x65\x6e\x74\x72\x79\x5f\x76\x66\x73\x5f\x72\x65\x61\x64\0\x6b\x70\
\x72\x6f\x62\x65\x5f\x76\x66\x73\x5f\x72\x65\x61\x64\0\x2e\x72\x65\x6c\x66\x65\
\x6e\x74\x72\x79\x2f\x76\x66\x73\x5f\x72\x65\x61\x64\0\x2e\x72\x65\x6c\x6b\x70\
\x72\x6f\x62\x65\x2f\x76\x66\x73\x5f\x72\x65\x61\x64\0\x66\x65\x6e\x74\x72\x79\
\x5f\x76\x66\x73\x5f\x66\x73\x79\x6e\x63\0\x6b\x70\x72\x6f\x62\x65\x5f\x76\x66\
\x73\x5f\x66\x73\x79\x6e\x63\0\x2e\x72\x65\x6c\x66\x65\x6e\x74\x72\x79\x2f\x76\
\x66\x73\x5f\x66\x73\x79\x6e\x63\0\x2e\x72\x65\x6c\x6b\x70\x72\x6f\x62\x65\x2f\
\x76\x66\x73\x5f\x66\x73\x79\x6e\x63\0\x2e\x73\x74\x72\x74\x61\x62\0\x2e\x73\
\x79\x6d\x74\x61\x62\0\x2e\x72\x65\x6c\x2e\x42\x54\x46\0\x4c\x49\x43\x45\x4e\
\x53\x45\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x95\x02\0\0\x03\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x72\x1b\0\0\0\0\0\0\xb6\x02\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\x01\0\0\0\x06\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x39\x02\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\x40\0\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\x35\x02\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x40\
\x16\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x2a\0\0\0\x03\0\0\0\x08\0\0\0\0\0\0\0\x10\0\
\0\0\0\0\0\0\x98\x01\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x70\0\0\0\
\0\0\0\0\x30\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\x94\x01\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x50\x16\0\0\0\0\0\0\
\x10\0\0\0\0\0\0\0\x2a\0\0\0\x05\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x84\
\x02\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xa0\0\0\0\0\0\0\0\x30\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x80\x02\0\0\x09\0\
\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x60\x16\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\
\x2a\0\0\0\x07\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\xef\0\0\0\x01\0\0\0\
\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xd0\0\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xeb\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\x70\x16\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x2a\0\0\0\x09\0\0\0\
\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\xe7\x01\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\xe3\x01\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\x80\x16\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x2a\0\0\0\x0b\0\0\0\x08\0\0\0\0\0\0\0\
\x10\0\0\0\0\0\0\0\x3d\x01\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x30\
\x01\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\x39\x01\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x90\x16\0\0\0\0\
\0\0\x10\0\0\0\0\0\0\0\x2a\0\0\0\x0d\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\
\xa6\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x60\x01\0\0\0\0\0\0\x30\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xa2\0\0\0\x09\
\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xa0\x16\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\
\x2a\0\0\0\x0f\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x5a\0\0\0\x01\0\0\0\
\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x90\x01\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x56\0\0\0\x09\0\0\0\x40\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\xb0\x16\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x2a\0\0\0\x11\0\0\0\
\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x25\x02\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\xc0\x01\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\x21\x02\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\xc0\x16\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x2a\0\0\0\x13\0\0\0\x08\0\0\0\0\0\0\0\
\x10\0\0\0\0\0\0\0\x83\x01\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xf0\
\x01\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\x7f\x01\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xd0\x16\0\0\0\0\
\0\0\x10\0\0\0\0\0\0\0\x2a\0\0\0\x15\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\
\x6f\x02\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x20\x02\0\0\0\0\0\0\
\x30\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x6b\x02\0\
\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xe0\x16\0\0\0\0\0\0\x10\0\0\0\0\
\0\0\0\x2a\0\0\0\x17\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\xdb\0\0\0\x01\0\
\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x50\x02\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xd7\0\0\0\x09\0\0\0\x40\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\xf0\x16\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x2a\0\0\0\x19\0\
\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\xd1\x01\0\0\x01\0\0\0\x06\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\x80\x02\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xcd\x01\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\x17\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x2a\0\0\0\x1b\0\0\0\x08\0\0\0\0\0\0\
\0\x10\0\0\0\0\0\0\0\x27\x01\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\xb0\x02\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x23\x01\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x10\x17\0\0\
\0\0\0\0\x10\0\0\0\0\0\0\0\x2a\0\0\0\x1d\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\
\0\0\x91\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xe0\x02\0\0\0\0\0\0\
\x30\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x8d\0\0\0\
\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x20\x17\0\0\0\0\0\0\x10\0\0\0\0\0\
\0\0\x2a\0\0\0\x1f\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x45\0\0\0\x01\0\0\
\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x10\x03\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x41\0\0\0\x09\0\0\0\x40\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x30\x17\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x2a\0\0\0\x21\0\0\
\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x1a\0\0\0\x08\0\0\0\x03\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\x40\x03\0\0\0\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\xf9\x01\0\0\x01\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\x40\x03\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\xa9\x02\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x44\x03\0\0\
\0\0\0\0\x0c\x0b\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\xa5\x02\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x40\x17\0\0\0\0\0\0\
\x20\0\0\0\0\0\0\0\x2a\0\0\0\x25\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x0b\
\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x50\x0e\0\0\0\0\0\0\xa8\x04\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x07\0\0\0\x09\0\0\
\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x60\x17\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\x2a\
\0\0\0\x27\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x4f\x01\0\0\x03\x4c\xff\
\x6f\0\0\0\x80\0\0\0\0\0\0\0\0\0\0\0\0\x60\x1b\0\0\0\0\0\0\x12\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x9d\x02\0\0\x02\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\xf8\x12\0\0\0\0\0\0\x48\x03\0\0\0\0\0\0\x01\0\0\0\x11\
\0\0\0\x08\0\0\0\0\0\0\0\x18\0\0\0\0\0\0\0";

	*sz = sizeof(data) - 1;
	return (const void *)data;
}

#ifdef __cplusplus
struct vfsstat_bpf *vfsstat_bpf::open(const struct bpf_object_open_opts *opts) { return vfsstat_bpf__open_opts(opts); }
struct vfsstat_bpf *vfsstat_bpf::open_and_load() { return vfsstat_bpf__open_and_load(); }
int vfsstat_bpf::load(struct vfsstat_bpf *skel) { return vfsstat_bpf__load(skel); }
int vfsstat_bpf::attach(struct vfsstat_bpf *skel) { return vfsstat_bpf__attach(skel); }
void vfsstat_bpf::detach(struct vfsstat_bpf *skel) { vfsstat_bpf__detach(skel); }
void vfsstat_bpf::destroy(struct vfsstat_bpf *skel) { vfsstat_bpf__destroy(skel); }
const void *vfsstat_bpf::elf_bytes(size_t *sz) { return vfsstat_bpf__elf_bytes(sz); }
#endif /* __cplusplus */

__attribute__((unused)) static void
vfsstat_bpf__assert(struct vfsstat_bpf *s __attribute__((unused)))
{
#ifdef __cplusplus
#define _Static_assert static_assert
#endif
	_Static_assert(sizeof(s->bss->stats) == 64, "unexpected size of 'stats'");
#ifdef __cplusplus
#undef _Static_assert
#endif
}

#endif /* __VFSSTAT_BPF_SKEL_H__ */
