/* library.c generated by valac 0.56.18, the Vala compiler
 * generated from library.vala, do not modify */

/* Copyright 2017 Siddhartha Das (bablu.boy@gmail.com)
*
* This file is part of Bookworm and manages the library and
* views associated with the library
*
* Bookworm is free software: you can redistribute it
* and/or modify it under the terms of the GNU General Public License as
* published by the Free Software Foundation, either version 3 of the
* License, or (at your option) any later version.
*
* Bookworm is distributed in the hope that it will be
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
* Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with Bookworm. If not, see http://www.gnu.org/licenses/.
*/

#include <glib-object.h>
#include <gee.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>

#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_TIME_TODAY _ ("Today")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_TIME_YESTERDAY _ ("Yesterday")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_TIME_DAYS _ ("Days")
#define BOOKWORM_APP_CONSTANTS_RESOURCE_PREFIX "/com/github/babluboy/bookworm/"
#define BOOKWORM_APP_CONSTANTS_PLACEHOLDER_COVER_IMAGE_LOCATION BOOKWORM_APP_CONSTANTS_RESOURCE_PREFIX "bookworm-placeholder-cover.svg"
#define BOOKWORM_APP_CONSTANTS_DEFAULT_COVER_IMAGE_LOCATION BOOKWORM_APP_CONSTANTS_RESOURCE_PREFIX "bookworm-default-cover-N.svg"
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_UNKNOWN_TITLE _ ("Unknown Book")
#define BOOKWORM_APP_CONSTANTS_MAX_NUMBER_OF_CHARS_FOR_BOOK_TITLE 18
#define BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS 12
#define BOOKWORM_APP_CONSTANTS_SELECTION_OPTION_IMAGE_LOCATION BOOKWORM_APP_CONSTANTS_RESOURCE_PREFIX "24-bookworm-selection-option.svg"
#define BOOKWORM_APP_CONSTANTS_SELECTION_CHECKED_IMAGE_LOCATION BOOKWORM_APP_CONSTANTS_RESOURCE_PREFIX "24-bookworm-selection-checked.svg"
#define BOOKWORM_APP_CONSTANTS_bookworm_id "com.github.babluboy.bookworm"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BOOKWORM_APP_TYPE_LIBRARY (bookworm_app_library_get_type ())
#define BOOKWORM_APP_LIBRARY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_LIBRARY, BookwormAppLibrary))
#define BOOKWORM_APP_LIBRARY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_LIBRARY, BookwormAppLibraryClass))
#define BOOKWORM_APP_IS_LIBRARY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_LIBRARY))
#define BOOKWORM_APP_IS_LIBRARY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_LIBRARY))
#define BOOKWORM_APP_LIBRARY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_LIBRARY, BookwormAppLibraryClass))

typedef struct _BookwormAppLibrary BookwormAppLibrary;
typedef struct _BookwormAppLibraryClass BookwormAppLibraryClass;
typedef struct _BookwormAppLibraryPrivate BookwormAppLibraryPrivate;

#define BOOKWORM_APP_TYPE_BOOK (bookworm_app_book_get_type ())
#define BOOKWORM_APP_BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_BOOK, BookwormAppBook))
#define BOOKWORM_APP_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_BOOK, BookwormAppBookClass))
#define BOOKWORM_APP_IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_BOOK))
#define BOOKWORM_APP_IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_BOOK))
#define BOOKWORM_APP_BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_BOOK, BookwormAppBookClass))

typedef struct _BookwormAppBook BookwormAppBook;
typedef struct _BookwormAppBookClass BookwormAppBookClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _bookworm_app_book_unref0(var) ((var == NULL) ? NULL : (var = (bookworm_app_book_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block21Data Block21Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _Block22Data Block22Data;
typedef struct _Block23Data Block23Data;
typedef struct _Block24Data Block24Data;
#define __vala_GtkTreeIter_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreeIter_free (var), NULL)))
typedef struct _bookworm_app_library_updateLibraryViewFromDBData bookworm_app_library_updateLibraryViewFromDBData;
typedef struct _bookworm_app_library_addBooksToLibraryData bookworm_app_library_addBooksToLibraryData;
typedef struct _Block25Data Block25Data;
typedef struct _BookwormAppParamSpecLibrary BookwormAppParamSpecLibrary;

struct _BookwormAppLibrary {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BookwormAppLibraryPrivate * priv;
};

struct _BookwormAppLibraryClass {
	GTypeClass parent_class;
	void (*finalize) (BookwormAppLibrary *self);
};

struct _Block21Data {
	int _ref_count_;
	GtkProgressBar* bookProgressBar;
	gdouble progress;
	GtkEventBox* aEventBox;
	GtkPopover* bookPopover;
	BookwormAppBook* aBook;
};

struct _Block22Data {
	int _ref_count_;
	BookwormAppBook* lBook;
};

struct _Block23Data {
	int _ref_count_;
	GeeArrayList* listOfBooksToBeRemoved;
};

struct _Block24Data {
	int _ref_count_;
	Block23Data * _data23_;
	GeeArrayList* listOfItersToBeRemoved;
};

struct _bookworm_app_library_updateLibraryViewFromDBData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GeeArrayList* _book_list;
	GeeArrayList* _tmp0_;
	gint _book_size;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _book_index;
	gint _tmp4_;
	gint _tmp5_;
	BookwormAppBook* book;
	GeeArrayList* _tmp6_;
	gpointer _tmp7_;
	BookwormAppBook* _tmp8_;
	BookwormAppBook* _tmp9_;
};

struct _bookworm_app_library_addBooksToLibraryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gdouble progress;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** pathToSelectedBook_collection;
	gint pathToSelectedBook_collection_length1;
	gint _pathToSelectedBook_collection_size_;
	gint pathToSelectedBook_it;
	gchar* _tmp6_;
	gchar* pathToSelectedBook;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gint _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gboolean _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	GtkProgressBar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	GFile* _tmp25_;
	GFile* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	GtkProgressBar* _tmp31_;
	gchar** _tmp32_;
	gint _tmp32__length1;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gboolean _tmp36_;
	GString* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gboolean _tmp42_;
	GString* _tmp43_;
	const gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	const gchar* _tmp47_;
	gchar* _tmp48_;
	BookwormAppBook* aBookBeingAdded;
	BookwormAppBook* _tmp49_;
	BookwormAppBook* _tmp50_;
	const gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	BookwormAppBook* _tmp54_;
	BookwormAppBook* _tmp55_;
	GString* _tmp56_;
	BookwormAppBook* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	GeeArrayList* _tmp60_;
	BookwormAppBook* _tmp61_;
	GtkProgressBar* _tmp62_;
};

struct _Block25Data {
	int _ref_count_;
	GeeArrayList* listOfItersToBeRemoved;
};

struct _BookwormAppParamSpecLibrary {
	GParamSpec parent_instance;
};

static gpointer bookworm_app_library_parent_class = NULL;
VALA_EXTERN GeeArrayList* bookworm_app_library_listOfBooksInLibraryOnLoad;
GeeArrayList* bookworm_app_library_listOfBooksInLibraryOnLoad = NULL;
VALA_EXTERN GeeHashMap* bookworm_app_bookworm_libraryViewMap;
VALA_EXTERN GdkPixbuf* bookworm_app_bookworm_image_rating_1;
VALA_EXTERN GdkPixbuf* bookworm_app_bookworm_image_rating_2;
VALA_EXTERN GdkPixbuf* bookworm_app_bookworm_image_rating_3;
VALA_EXTERN GdkPixbuf* bookworm_app_bookworm_image_rating_4;
VALA_EXTERN GdkPixbuf* bookworm_app_bookworm_image_rating_5;
VALA_EXTERN GtkListStore* bookworm_app_app_window_library_table_liststore;
VALA_EXTERN GtkTreeIter bookworm_app_app_window_library_table_iter;
VALA_EXTERN GtkTreeModelFilter* bookworm_app_bookworm_libraryTreeModelFilter;
VALA_EXTERN GtkTreeView* bookworm_app_app_window_library_table_treeview;
VALA_EXTERN GtkFlowBox* bookworm_app_app_window_library_grid;
VALA_EXTERN gchar* bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
VALA_EXTERN GdkPixbuf* bookworm_app_bookworm_image_selection_transparent_small;
VALA_EXTERN GdkPixbuf* bookworm_app_bookworm_image_selection_option_small;
VALA_EXTERN GdkPixbuf* bookworm_app_bookworm_image_selection_checked_small;
VALA_EXTERN GtkScrolledWindow* bookworm_app_app_window_library_grid_scroll;
VALA_EXTERN GString* bookworm_app_bookworm_pathsOfBooksInLibraryOnLoadStr;
VALA_EXTERN gchar** bookworm_app_bookworm_pathsOfBooksToBeAdded;
VALA_EXTERN gint bookworm_app_bookworm_pathsOfBooksToBeAdded_length1;
VALA_EXTERN gint bookworm_app_bookworm_noOfBooksAddedFromCommand;
VALA_EXTERN GtkProgressBar* bookworm_app_app_window_bookAdditionBar;
VALA_EXTERN gboolean bookworm_app_bookworm_isPageScrollRequired;
VALA_EXTERN gchar* bookworm_app_bookworm_locationOfEBookCurrentlyRead;
VALA_EXTERN gboolean bookworm_app_bookworm_isBookBeingAddedToLibrary;
VALA_EXTERN gint bookworm_app_bookworm_current_page_counter;
VALA_EXTERN GeeArrayList* bookworm_app_bookworm_paginationlist;

VALA_EXTERN gpointer bookworm_app_library_ref (gpointer instance);
VALA_EXTERN void bookworm_app_library_unref (gpointer instance);
VALA_EXTERN GParamSpec* bookworm_app_param_spec_library (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags);
VALA_EXTERN void bookworm_app_value_set_library (GValue* value,
                                     gpointer v_object);
VALA_EXTERN void bookworm_app_value_take_library (GValue* value,
                                      gpointer v_object);
VALA_EXTERN gpointer bookworm_app_value_get_library (const GValue* value);
VALA_EXTERN GType bookworm_app_library_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppLibrary, bookworm_app_library_unref)
VALA_EXTERN gpointer bookworm_app_book_ref (gpointer instance);
VALA_EXTERN void bookworm_app_book_unref (gpointer instance);
VALA_EXTERN GParamSpec* bookworm_app_param_spec_book (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void bookworm_app_value_set_book (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void bookworm_app_value_take_book (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer bookworm_app_value_get_book (const GValue* value);
VALA_EXTERN GType bookworm_app_book_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppBook, bookworm_app_book_unref)
VALA_EXTERN void bookworm_app_library_updateLibraryView (BookwormAppBook* aBook);
VALA_EXTERN gchar* bookworm_app_book_getBookLocation (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_library_updateLibraryListView (BookwormAppBook* aBook);
VALA_EXTERN void bookworm_app_library_updateLibraryGridView (BookwormAppBook* aBook);
VALA_EXTERN gint bookworm_app_book_getBookRating (BookwormAppBook* self);
VALA_EXTERN gchar* bookworm_app_book_getBookLastModificationDate (BookwormAppBook* self);
VALA_EXTERN gchar* bookworm_app_utils_parseMarkUp (const gchar* inputString);
VALA_EXTERN gchar* bookworm_app_book_getBookTitle (BookwormAppBook* self);
VALA_EXTERN gchar* bookworm_app_book_getBookAuthor (BookwormAppBook* self);
VALA_EXTERN gchar* bookworm_app_book_getBookTags (BookwormAppBook* self);
static Block21Data* block21_data_ref (Block21Data* _data21_);
static void block21_data_unref (void * _userdata_);
VALA_EXTERN gchar* bookworm_app_book_getBookCoverLocation (BookwormAppBook* self);
VALA_EXTERN gchar* bookworm_app_utils_fileOperations (const gchar* operation,
                                          const gchar* path,
                                          const gchar* filename,
                                          const gchar* contents);
VALA_EXTERN void bookworm_app_book_setIsBookCoverImagePresent (BookwormAppBook* self,
                                                   gboolean isABookCoverImagePresent);
VALA_EXTERN void bookworm_app_book_setBookCoverLocation (BookwormAppBook* self,
                                             const gchar* aBookCoverLocation);
VALA_EXTERN gboolean bookworm_app_book_getIsBookCoverImagePresent (BookwormAppBook* self);
VALA_EXTERN gchar* bookworm_app_utils_minimizeStringLength (const gchar* originalString,
                                                gint maxLength);
VALA_EXTERN gchar* bookworm_app_utils_breakString (const gchar* originalString,
                                       gint breakLength,
                                       const gchar* breakString);
VALA_EXTERN void bookworm_app_book_setBookWidget (BookwormAppBook* self,
                                      const gchar* name,
                                      GtkWidget* aWidget);
VALA_EXTERN GtkPopover* bookworm_app_app_dialog_createBookContextMenu (BookwormAppBook* aBook);
static gboolean __lambda31_ (Block21Data* _data21_,
                      GdkEventCrossing* event);
VALA_EXTERN gint bookworm_app_book_getBookPageNumber (BookwormAppBook* self);
VALA_EXTERN gint bookworm_app_book_getBookTotalPages (BookwormAppBook* self);
static gboolean ___lambda31__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                     GdkEventCrossing* event,
                                                     gpointer self);
static gboolean __lambda32_ (Block21Data* _data21_,
                      GdkEventCrossing* event);
static gboolean ___lambda32__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                     GdkEventCrossing* event,
                                                     gpointer self);
static gboolean __lambda33_ (Block21Data* _data21_,
                      GdkEventButton* event);
VALA_EXTERN void bookworm_app_bookworm_readSelectedBook (BookwormAppBook* aBook);
VALA_EXTERN void bookworm_app_library_updateGridViewForSelection (BookwormAppBook* lBook);
static gboolean ___lambda33__gtk_widget_button_press_event (GtkWidget* _sender,
                                                     GdkEventButton* event,
                                                     gpointer self);
VALA_EXTERN void bookworm_app_library_replaceCoverImageOnBook (BookwormAppBook* book);
VALA_EXTERN GtkWidget* bookworm_app_book_getBookWidget (BookwormAppBook* self,
                                            const gchar* name);
VALA_EXTERN void bookworm_app_library_updateListViewForSelection (BookwormAppBook* lBook);
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void block22_data_unref (void * _userdata_);
static gboolean __lambda38_ (Block22Data* _data22_,
                      GtkTreeModel* model,
                      GtkTreePath* path,
                      GtkTreeIter* iter);
VALA_EXTERN void bookworm_app_book_setIsBookSelected (BookwormAppBook* self,
                                          gboolean aIsBookSelected);
VALA_EXTERN void bookworm_app_app_window_controlDeletionButton (gboolean selectionState);
VALA_EXTERN gboolean bookworm_app_book_getIsBookSelected (BookwormAppBook* self);
static gboolean ___lambda38__gtk_tree_model_foreach_func (GtkTreeModel* model,
                                                   GtkTreePath* path,
                                                   GtkTreeIter* iter,
                                                   gpointer self);
VALA_EXTERN void bookworm_app_library_removeSelectedBooksFromLibrary (void);
static Block23Data* block23_data_ref (Block23Data* _data23_);
static void block23_data_unref (void * _userdata_);
VALA_EXTERN gchar* bookworm_app_utils_execute_sync_command (const gchar* cmd);
static Block24Data* block24_data_ref (Block24Data* _data24_);
static void block24_data_unref (void * _userdata_);
static GtkTreeIter* _vala_GtkTreeIter_copy (GtkTreeIter* self);
static void _vala_GtkTreeIter_free (GtkTreeIter* self);
static gboolean ___lambda39_ (Block24Data* _data24_,
                       GtkTreeModel* model,
                       GtkTreePath* path,
                       GtkTreeIter* iter);
static gboolean ____lambda39__gtk_tree_model_foreach_func (GtkTreeModel* model,
                                                    GtkTreePath* path,
                                                    GtkTreeIter* iter,
                                                    gpointer self);
VALA_EXTERN gboolean bookworm_app_db_removeBookFromDB (BookwormAppBook* aBook);
VALA_EXTERN void bookworm_app_bookworm_toggleUIState (void);
static void bookworm_app_library_updateLibraryViewFromDB_data_free (gpointer _data);
VALA_EXTERN void bookworm_app_library_updateLibraryViewFromDB (GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
VALA_EXTERN void bookworm_app_library_updateLibraryViewFromDB_finish (GAsyncResult* _res_);
static gboolean bookworm_app_library_updateLibraryViewFromDB_co (bookworm_app_library_updateLibraryViewFromDBData* _data_);
static gboolean _bookworm_app_library_updateLibraryViewFromDB_co_gsource_func (gpointer self);
static void bookworm_app_library_addBooksToLibrary_data_free (gpointer _data);
VALA_EXTERN void bookworm_app_library_addBooksToLibrary (GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
VALA_EXTERN void bookworm_app_library_addBooksToLibrary_finish (GAsyncResult* _res_);
static gboolean bookworm_app_library_addBooksToLibrary_co (bookworm_app_library_addBooksToLibraryData* _data_);
static gboolean _bookworm_app_library_addBooksToLibrary_co_gsource_func (gpointer self);
VALA_EXTERN BookwormAppBook* bookworm_app_book_new (void);
VALA_EXTERN BookwormAppBook* bookworm_app_book_construct (GType object_type);
VALA_EXTERN void bookworm_app_book_setBookLocation (BookwormAppBook* self,
                                        const gchar* aBookLocation);
VALA_EXTERN void bookworm_app_library_addBookToLibrary (BookwormAppBook* aBook);
VALA_EXTERN gint bookworm_app_db_addBookToDataBase (BookwormAppBook* aBook);
VALA_EXTERN void bookworm_app_book_setBookId (BookwormAppBook* self,
                                  gint aBookId);
VALA_EXTERN void bookworm_app_book_setBookLastModificationDate (BookwormAppBook* self,
                                                    const gchar* aBookLastModificationDate);
VALA_EXTERN void bookworm_app_book_setWasBookOpened (BookwormAppBook* self,
                                         gboolean aWasBookOpened);
VALA_EXTERN BookwormAppBook* bookworm_app_bookworm_genericParser (BookwormAppBook* aBook);
VALA_EXTERN gboolean bookworm_app_book_getIsBookParsed (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_app_window_showInfoBar (BookwormAppBook* aBook,
                                          GtkMessageType aMessageType);
VALA_EXTERN void bookworm_app_library_paginateLibrary (const gchar* library_search_data,
                                           const gchar* mode);
VALA_EXTERN gboolean bookworm_app_book_getWasBookOpened (BookwormAppBook* self);
VALA_EXTERN gboolean bookworm_app_db_updateBookToDataBase (BookwormAppBook* aBook);
VALA_EXTERN GeeArrayList* bookworm_app_db_getBooksFromDB (const gchar* criteria,
                                              const gchar* mode);
static Block25Data* block25_data_ref (Block25Data* _data25_);
static void block25_data_unref (void * _userdata_);
static gboolean ___lambda40_ (Block25Data* _data25_,
                       GtkTreeModel* model,
                       GtkTreePath* path,
                       GtkTreeIter* iter);
static gboolean ____lambda40__gtk_tree_model_foreach_func (GtkTreeModel* model,
                                                    GtkTreePath* path,
                                                    GtkTreeIter* iter,
                                                    gpointer self);
VALA_EXTERN void bookworm_app_app_window_handleLibraryPageButtons (const gchar* mode,
                                                       gboolean isPaginateRequired);
VALA_EXTERN BookwormAppLibrary* bookworm_app_library_new (void);
VALA_EXTERN BookwormAppLibrary* bookworm_app_library_construct (GType object_type);
static void bookworm_app_library_finalize (BookwormAppLibrary * obj);
static GType bookworm_app_library_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

VALA_EXTERN const gchar* BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[8];

static gpointer
_bookworm_app_book_ref0 (gpointer self)
{
#line 29 "../src/library.vala"
	return self ? bookworm_app_book_ref (self) : NULL;
#line 460 "library.c"
}

void
bookworm_app_library_updateLibraryView (BookwormAppBook* aBook)
{
	GeeHashMap* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	BookwormAppBook* _tmp3_;
	BookwormAppBook* _tmp4_;
#line 24 "../src/library.vala"
	g_return_if_fail (aBook != NULL);
#line 25 "../src/library.vala"
	g_info ("library.vala:25: [START] [FUNCTION:updateLibraryView]");
#line 27 "../src/library.vala"
	_tmp0_ = bookworm_app_bookworm_libraryViewMap;
#line 27 "../src/library.vala"
	_tmp1_ = bookworm_app_book_getBookLocation (aBook);
#line 27 "../src/library.vala"
	_tmp2_ = _tmp1_;
#line 27 "../src/library.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, _tmp2_, aBook);
#line 27 "../src/library.vala"
	_g_free0 (_tmp2_);
#line 29 "../src/library.vala"
	_tmp3_ = _bookworm_app_book_ref0 (aBook);
#line 29 "../src/library.vala"
	bookworm_app_library_updateLibraryListView (_tmp3_);
#line 30 "../src/library.vala"
	_tmp4_ = _bookworm_app_book_ref0 (aBook);
#line 30 "../src/library.vala"
	bookworm_app_library_updateLibraryGridView (_tmp4_);
#line 31 "../src/library.vala"
	g_info ("library.vala:31: [END] [FUNCTION:updateLibraryView]");
#line 24 "../src/library.vala"
	_bookworm_app_book_unref0 (aBook);
#line 497 "library.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 43 "../src/library.vala"
	return self ? g_object_ref (self) : NULL;
#line 505 "library.c"
}

static gint64
int64_parse (const gchar* str,
             guint _base)
{
	gint64 result;
#line 778 "glib-2.0.vapi"
	g_return_val_if_fail (str != NULL, 0LL);
#line 779 "glib-2.0.vapi"
	result = g_ascii_strtoll (str, NULL, _base);
#line 779 "glib-2.0.vapi"
	return result;
#line 519 "library.c"
}

void
bookworm_app_library_updateLibraryListView (BookwormAppBook* aBook)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GdkPixbuf* image_rating = NULL;
	gchar* modifiedElapsedTime = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GQuark _tmp12_ = 0U;
#line 41 "../src/library.vala"
	static GQuark _tmp11_label0 = 0;
#line 41 "../src/library.vala"
	static GQuark _tmp11_label1 = 0;
#line 41 "../src/library.vala"
	static GQuark _tmp11_label2 = 0;
#line 41 "../src/library.vala"
	static GQuark _tmp11_label3 = 0;
#line 41 "../src/library.vala"
	static GQuark _tmp11_label4 = 0;
#line 549 "library.c"
	GTimeSpan timespan = 0LL;
	GDateTime* _tmp23_;
	GDateTime* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	GDateTime* _tmp27_;
	GDateTime* _tmp28_;
	GTimeSpan _tmp29_;
	gint64 daysElapsed = 0LL;
	GtkListStore* _tmp42_;
	GtkTreeIter _tmp43_ = {0};
	GtkListStore* _tmp44_;
	GtkTreeIter _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	const gchar* _tmp52_;
	GdkPixbuf* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	GtkListStore* _tmp60_;
	GtkTreeModelFilter* _tmp61_;
	GtkTreeModelSort* aTreeModelSort = NULL;
	GtkTreeModelFilter* _tmp62_;
	GtkTreeModelSort* _tmp63_;
	GtkTreeView* _tmp64_;
	GtkTreeView* _tmp65_;
	GtkTreeViewColumn* _tmp66_;
	GtkTreeView* _tmp67_;
	GtkTreeViewColumn* _tmp68_;
	GtkTreeView* _tmp69_;
	GtkTreeViewColumn* _tmp70_;
	GtkTreeView* _tmp71_;
	GtkTreeViewColumn* _tmp72_;
	GtkTreeView* _tmp73_;
	GtkTreeViewColumn* _tmp74_;
	GtkTreeView* _tmp75_;
	GtkTreeViewColumn* _tmp76_;
	GtkTreeView* _tmp77_;
	GtkTreeViewColumn* _tmp78_;
	GtkTreeView* _tmp79_;
	GtkTreeViewColumn* _tmp80_;
	GtkTreeView* _tmp81_;
	GtkTreeViewColumn* _tmp82_;
	GtkTreeView* _tmp83_;
	GtkTreeViewColumn* _tmp84_;
	gchar* _tmp85_;
	gchar* _tmp86_;
	gchar* _tmp87_;
	gchar* _tmp88_;
#line 34 "../src/library.vala"
	g_return_if_fail (aBook != NULL);
#line 35 "../src/library.vala"
	_tmp0_ = bookworm_app_book_getBookLocation (aBook);
#line 35 "../src/library.vala"
	_tmp1_ = _tmp0_;
#line 35 "../src/library.vala"
	_tmp2_ = g_strconcat ("[START] [FUNCTION:updateLibraryListView] book.location=", _tmp1_, NULL);
#line 35 "../src/library.vala"
	_tmp3_ = _tmp2_;
#line 35 "../src/library.vala"
	g_debug ("library.vala:35: %s", _tmp3_);
#line 35 "../src/library.vala"
	_g_free0 (_tmp3_);
#line 35 "../src/library.vala"
	_g_free0 (_tmp1_);
#line 37 "../src/library.vala"
	_tmp4_ = bookworm_app_book_getBookLocation (aBook);
#line 37 "../src/library.vala"
	_tmp5_ = _tmp4_;
#line 37 "../src/library.vala"
	_tmp6_ = g_strconcat ("Started updating Library List View for book:", _tmp5_, NULL);
#line 37 "../src/library.vala"
	_tmp7_ = _tmp6_;
#line 37 "../src/library.vala"
	g_debug ("library.vala:37: %s", _tmp7_);
#line 37 "../src/library.vala"
	_g_free0 (_tmp7_);
#line 37 "../src/library.vala"
	_g_free0 (_tmp5_);
#line 40 "../src/library.vala"
	_tmp8_ = g_strdup ("");
#line 40 "../src/library.vala"
	modifiedElapsedTime = _tmp8_;
#line 41 "../src/library.vala"
	_tmp9_ = g_strdup_printf ("%i", bookworm_app_book_getBookRating (aBook));
#line 41 "../src/library.vala"
	_tmp10_ = _tmp9_;
#line 41 "../src/library.vala"
	_tmp12_ = (NULL == _tmp10_) ? 0 : g_quark_from_string (_tmp10_);
#line 41 "../src/library.vala"
	g_free (_tmp10_);
#line 41 "../src/library.vala"
	if (_tmp12_ == ((0 != _tmp11_label0) ? _tmp11_label0 : (_tmp11_label0 = g_quark_from_static_string ("1")))) {
#line 41 "../src/library.vala"
		switch (0) {
#line 653 "library.c"
			default:
			{
				GdkPixbuf* _tmp13_;
				GdkPixbuf* _tmp14_;
#line 43 "../src/library.vala"
				_tmp13_ = bookworm_app_bookworm_image_rating_1;
#line 43 "../src/library.vala"
				_tmp14_ = _g_object_ref0 (_tmp13_);
#line 43 "../src/library.vala"
				_g_object_unref0 (image_rating);
#line 43 "../src/library.vala"
				image_rating = _tmp14_;
#line 44 "../src/library.vala"
				break;
#line 668 "library.c"
			}
		}
	} else if (_tmp12_ == ((0 != _tmp11_label1) ? _tmp11_label1 : (_tmp11_label1 = g_quark_from_static_string ("2")))) {
#line 41 "../src/library.vala"
		switch (0) {
#line 674 "library.c"
			default:
			{
				GdkPixbuf* _tmp15_;
				GdkPixbuf* _tmp16_;
#line 46 "../src/library.vala"
				_tmp15_ = bookworm_app_bookworm_image_rating_2;
#line 46 "../src/library.vala"
				_tmp16_ = _g_object_ref0 (_tmp15_);
#line 46 "../src/library.vala"
				_g_object_unref0 (image_rating);
#line 46 "../src/library.vala"
				image_rating = _tmp16_;
#line 47 "../src/library.vala"
				break;
#line 689 "library.c"
			}
		}
	} else if (_tmp12_ == ((0 != _tmp11_label2) ? _tmp11_label2 : (_tmp11_label2 = g_quark_from_static_string ("3")))) {
#line 41 "../src/library.vala"
		switch (0) {
#line 695 "library.c"
			default:
			{
				GdkPixbuf* _tmp17_;
				GdkPixbuf* _tmp18_;
#line 49 "../src/library.vala"
				_tmp17_ = bookworm_app_bookworm_image_rating_3;
#line 49 "../src/library.vala"
				_tmp18_ = _g_object_ref0 (_tmp17_);
#line 49 "../src/library.vala"
				_g_object_unref0 (image_rating);
#line 49 "../src/library.vala"
				image_rating = _tmp18_;
#line 50 "../src/library.vala"
				break;
#line 710 "library.c"
			}
		}
	} else if (_tmp12_ == ((0 != _tmp11_label3) ? _tmp11_label3 : (_tmp11_label3 = g_quark_from_static_string ("4")))) {
#line 41 "../src/library.vala"
		switch (0) {
#line 716 "library.c"
			default:
			{
				GdkPixbuf* _tmp19_;
				GdkPixbuf* _tmp20_;
#line 52 "../src/library.vala"
				_tmp19_ = bookworm_app_bookworm_image_rating_4;
#line 52 "../src/library.vala"
				_tmp20_ = _g_object_ref0 (_tmp19_);
#line 52 "../src/library.vala"
				_g_object_unref0 (image_rating);
#line 52 "../src/library.vala"
				image_rating = _tmp20_;
#line 53 "../src/library.vala"
				break;
#line 731 "library.c"
			}
		}
	} else if (_tmp12_ == ((0 != _tmp11_label4) ? _tmp11_label4 : (_tmp11_label4 = g_quark_from_static_string ("5")))) {
#line 41 "../src/library.vala"
		switch (0) {
#line 737 "library.c"
			default:
			{
				GdkPixbuf* _tmp21_;
				GdkPixbuf* _tmp22_;
#line 55 "../src/library.vala"
				_tmp21_ = bookworm_app_bookworm_image_rating_5;
#line 55 "../src/library.vala"
				_tmp22_ = _g_object_ref0 (_tmp21_);
#line 55 "../src/library.vala"
				_g_object_unref0 (image_rating);
#line 55 "../src/library.vala"
				image_rating = _tmp22_;
#line 56 "../src/library.vala"
				break;
#line 752 "library.c"
			}
		}
	} else {
#line 41 "../src/library.vala"
		switch (0) {
#line 758 "library.c"
			default:
			{
#line 58 "../src/library.vala"
				_g_object_unref0 (image_rating);
#line 58 "../src/library.vala"
				image_rating = NULL;
#line 59 "../src/library.vala"
				break;
#line 767 "library.c"
			}
		}
	}
#line 62 "../src/library.vala"
	_tmp23_ = g_date_time_new_now_local ();
#line 62 "../src/library.vala"
	_tmp24_ = _tmp23_;
#line 62 "../src/library.vala"
	_tmp25_ = bookworm_app_book_getBookLastModificationDate (aBook);
#line 62 "../src/library.vala"
	_tmp26_ = _tmp25_;
#line 62 "../src/library.vala"
	_tmp27_ = g_date_time_new_from_unix_local (int64_parse (_tmp26_, (guint) 0));
#line 62 "../src/library.vala"
	_tmp28_ = _tmp27_;
#line 62 "../src/library.vala"
	_tmp29_ = g_date_time_difference (_tmp24_, _tmp28_);
#line 62 "../src/library.vala"
	_g_date_time_unref0 (_tmp28_);
#line 62 "../src/library.vala"
	_g_free0 (_tmp26_);
#line 62 "../src/library.vala"
	_g_date_time_unref0 (_tmp24_);
#line 62 "../src/library.vala"
	timespan = _tmp29_;
#line 65 "../src/library.vala"
	daysElapsed = (gint64) (timespan / 86400000000LL);
#line 66 "../src/library.vala"
	if (timespan < G_TIME_SPAN_DAY) {
#line 797 "library.c"
		gchar* _tmp30_;
#line 67 "../src/library.vala"
		_tmp30_ = g_strdup (BOOKWORM_APP_CONSTANTS_TEXT_FOR_TIME_TODAY);
#line 67 "../src/library.vala"
		_g_free0 (modifiedElapsedTime);
#line 67 "../src/library.vala"
		modifiedElapsedTime = _tmp30_;
#line 805 "library.c"
	} else {
#line 68 "../src/library.vala"
		if (timespan < (2 * G_TIME_SPAN_DAY)) {
#line 809 "library.c"
			gchar* _tmp31_;
#line 69 "../src/library.vala"
			_tmp31_ = g_strdup (BOOKWORM_APP_CONSTANTS_TEXT_FOR_TIME_YESTERDAY);
#line 69 "../src/library.vala"
			_g_free0 (modifiedElapsedTime);
#line 69 "../src/library.vala"
			modifiedElapsedTime = _tmp31_;
#line 817 "library.c"
		} else {
#line 70 "../src/library.vala"
			if (timespan < (30 * G_TIME_SPAN_DAY)) {
#line 821 "library.c"
				gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
#line 71 "../src/library.vala"
				_tmp32_ = g_strdup_printf ("%" G_GINT64_FORMAT, daysElapsed);
#line 71 "../src/library.vala"
				_tmp33_ = _tmp32_;
#line 71 "../src/library.vala"
				_tmp34_ = g_strconcat (_tmp33_, " ", NULL);
#line 71 "../src/library.vala"
				_tmp35_ = _tmp34_;
#line 71 "../src/library.vala"
				_tmp36_ = g_strconcat (_tmp35_, BOOKWORM_APP_CONSTANTS_TEXT_FOR_TIME_DAYS, NULL);
#line 71 "../src/library.vala"
				_g_free0 (modifiedElapsedTime);
#line 71 "../src/library.vala"
				modifiedElapsedTime = _tmp36_;
#line 71 "../src/library.vala"
				_g_free0 (_tmp35_);
#line 71 "../src/library.vala"
				_g_free0 (_tmp33_);
#line 845 "library.c"
			} else {
				gchar* _tmp37_;
				gchar* _tmp38_;
				GDateTime* _tmp39_;
				GDateTime* _tmp40_;
				gchar* _tmp41_;
#line 73 "../src/library.vala"
				_tmp37_ = bookworm_app_book_getBookLastModificationDate (aBook);
#line 73 "../src/library.vala"
				_tmp38_ = _tmp37_;
#line 73 "../src/library.vala"
				_tmp39_ = g_date_time_new_from_unix_local (int64_parse (_tmp38_, (guint) 0));
#line 73 "../src/library.vala"
				_tmp40_ = _tmp39_;
#line 73 "../src/library.vala"
				_tmp41_ = g_date_time_format (_tmp40_, "%d %m %Y");
#line 73 "../src/library.vala"
				_g_free0 (modifiedElapsedTime);
#line 73 "../src/library.vala"
				modifiedElapsedTime = _tmp41_;
#line 73 "../src/library.vala"
				_g_date_time_unref0 (_tmp40_);
#line 73 "../src/library.vala"
				_g_free0 (_tmp38_);
#line 870 "library.c"
			}
		}
	}
#line 76 "../src/library.vala"
	_tmp42_ = bookworm_app_app_window_library_table_liststore;
#line 76 "../src/library.vala"
	gtk_list_store_append (_tmp42_, &_tmp43_);
#line 76 "../src/library.vala"
	bookworm_app_app_window_library_table_iter = _tmp43_;
#line 77 "../src/library.vala"
	_tmp44_ = bookworm_app_app_window_library_table_liststore;
#line 77 "../src/library.vala"
	_tmp45_ = bookworm_app_app_window_library_table_iter;
#line 77 "../src/library.vala"
	_tmp46_ = bookworm_app_book_getBookTitle (aBook);
#line 77 "../src/library.vala"
	_tmp47_ = _tmp46_;
#line 77 "../src/library.vala"
	_tmp48_ = bookworm_app_utils_parseMarkUp (_tmp47_);
#line 77 "../src/library.vala"
	_tmp49_ = _tmp48_;
#line 77 "../src/library.vala"
	_tmp50_ = bookworm_app_book_getBookAuthor (aBook);
#line 77 "../src/library.vala"
	_tmp51_ = _tmp50_;
#line 77 "../src/library.vala"
	_tmp52_ = modifiedElapsedTime;
#line 77 "../src/library.vala"
	_tmp53_ = image_rating;
#line 77 "../src/library.vala"
	_tmp54_ = bookworm_app_book_getBookTags (aBook);
#line 77 "../src/library.vala"
	_tmp55_ = _tmp54_;
#line 77 "../src/library.vala"
	_tmp56_ = g_strdup_printf ("%i", bookworm_app_book_getBookRating (aBook));
#line 77 "../src/library.vala"
	_tmp57_ = _tmp56_;
#line 77 "../src/library.vala"
	_tmp58_ = bookworm_app_book_getBookLocation (aBook);
#line 77 "../src/library.vala"
	_tmp59_ = _tmp58_;
#line 77 "../src/library.vala"
	gtk_list_store_set (_tmp44_, &_tmp45_, 0, NULL, 1, _tmp49_, 2, _tmp51_, 3, _tmp52_, 4, _tmp53_, 5, _tmp55_, 6, _tmp57_, 7, _tmp59_, -1);
#line 77 "../src/library.vala"
	_g_free0 (_tmp59_);
#line 77 "../src/library.vala"
	_g_free0 (_tmp57_);
#line 77 "../src/library.vala"
	_g_free0 (_tmp55_);
#line 77 "../src/library.vala"
	_g_free0 (_tmp51_);
#line 77 "../src/library.vala"
	_g_free0 (_tmp49_);
#line 77 "../src/library.vala"
	_g_free0 (_tmp47_);
#line 87 "../src/library.vala"
	_tmp60_ = bookworm_app_app_window_library_table_liststore;
#line 87 "../src/library.vala"
	_tmp61_ = (GtkTreeModelFilter*) gtk_tree_model_filter_new ((GtkTreeModel*) _tmp60_, NULL);
#line 87 "../src/library.vala"
	_g_object_unref0 (bookworm_app_bookworm_libraryTreeModelFilter);
#line 87 "../src/library.vala"
	bookworm_app_bookworm_libraryTreeModelFilter = _tmp61_;
#line 89 "../src/library.vala"
	_tmp62_ = bookworm_app_bookworm_libraryTreeModelFilter;
#line 89 "../src/library.vala"
	_tmp63_ = (GtkTreeModelSort*) gtk_tree_model_sort_new_with_model ((GtkTreeModel*) _tmp62_);
#line 89 "../src/library.vala"
	aTreeModelSort = _tmp63_;
#line 90 "../src/library.vala"
	_tmp64_ = bookworm_app_app_window_library_table_treeview;
#line 90 "../src/library.vala"
	gtk_tree_view_set_model (_tmp64_, (GtkTreeModel*) aTreeModelSort);
#line 92 "../src/library.vala"
	_tmp65_ = bookworm_app_app_window_library_table_treeview;
#line 92 "../src/library.vala"
	_tmp66_ = gtk_tree_view_get_column (_tmp65_, 1);
#line 92 "../src/library.vala"
	gtk_tree_view_column_set_sort_column_id (_tmp66_, 1);
#line 93 "../src/library.vala"
	_tmp67_ = bookworm_app_app_window_library_table_treeview;
#line 93 "../src/library.vala"
	_tmp68_ = gtk_tree_view_get_column (_tmp67_, 1);
#line 93 "../src/library.vala"
	gtk_tree_view_column_set_sort_order (_tmp68_, GTK_SORT_DESCENDING);
#line 95 "../src/library.vala"
	_tmp69_ = bookworm_app_app_window_library_table_treeview;
#line 95 "../src/library.vala"
	_tmp70_ = gtk_tree_view_get_column (_tmp69_, 2);
#line 95 "../src/library.vala"
	gtk_tree_view_column_set_sort_column_id (_tmp70_, 2);
#line 96 "../src/library.vala"
	_tmp71_ = bookworm_app_app_window_library_table_treeview;
#line 96 "../src/library.vala"
	_tmp72_ = gtk_tree_view_get_column (_tmp71_, 2);
#line 96 "../src/library.vala"
	gtk_tree_view_column_set_sort_order (_tmp72_, GTK_SORT_DESCENDING);
#line 98 "../src/library.vala"
	_tmp73_ = bookworm_app_app_window_library_table_treeview;
#line 98 "../src/library.vala"
	_tmp74_ = gtk_tree_view_get_column (_tmp73_, 3);
#line 98 "../src/library.vala"
	gtk_tree_view_column_set_sort_column_id (_tmp74_, 3);
#line 99 "../src/library.vala"
	_tmp75_ = bookworm_app_app_window_library_table_treeview;
#line 99 "../src/library.vala"
	_tmp76_ = gtk_tree_view_get_column (_tmp75_, 3);
#line 99 "../src/library.vala"
	gtk_tree_view_column_set_sort_order (_tmp76_, GTK_SORT_DESCENDING);
#line 102 "../src/library.vala"
	_tmp77_ = bookworm_app_app_window_library_table_treeview;
#line 102 "../src/library.vala"
	_tmp78_ = gtk_tree_view_get_column (_tmp77_, 4);
#line 102 "../src/library.vala"
	gtk_tree_view_column_set_sort_column_id (_tmp78_, 6);
#line 103 "../src/library.vala"
	_tmp79_ = bookworm_app_app_window_library_table_treeview;
#line 103 "../src/library.vala"
	_tmp80_ = gtk_tree_view_get_column (_tmp79_, 4);
#line 103 "../src/library.vala"
	gtk_tree_view_column_set_sort_order (_tmp80_, GTK_SORT_DESCENDING);
#line 105 "../src/library.vala"
	_tmp81_ = bookworm_app_app_window_library_table_treeview;
#line 105 "../src/library.vala"
	_tmp82_ = gtk_tree_view_get_column (_tmp81_, 5);
#line 105 "../src/library.vala"
	gtk_tree_view_column_set_sort_column_id (_tmp82_, 5);
#line 106 "../src/library.vala"
	_tmp83_ = bookworm_app_app_window_library_table_treeview;
#line 106 "../src/library.vala"
	_tmp84_ = gtk_tree_view_get_column (_tmp83_, 5);
#line 106 "../src/library.vala"
	gtk_tree_view_column_set_sort_order (_tmp84_, GTK_SORT_DESCENDING);
#line 108 "../src/library.vala"
	_tmp85_ = bookworm_app_book_getBookLocation (aBook);
#line 108 "../src/library.vala"
	_tmp86_ = _tmp85_;
#line 108 "../src/library.vala"
	_tmp87_ = g_strconcat ("[END] [FUNCTION:updateLibraryListView] book.location=", _tmp86_, NULL);
#line 108 "../src/library.vala"
	_tmp88_ = _tmp87_;
#line 108 "../src/library.vala"
	g_debug ("library.vala:108: %s", _tmp88_);
#line 108 "../src/library.vala"
	_g_free0 (_tmp88_);
#line 108 "../src/library.vala"
	_g_free0 (_tmp86_);
#line 34 "../src/library.vala"
	_g_object_unref0 (aTreeModelSort);
#line 34 "../src/library.vala"
	_g_free0 (modifiedElapsedTime);
#line 34 "../src/library.vala"
	_g_object_unref0 (image_rating);
#line 34 "../src/library.vala"
	_bookworm_app_book_unref0 (aBook);
#line 1026 "library.c"
}

static Block21Data*
block21_data_ref (Block21Data* _data21_)
{
#line 111 "../src/library.vala"
	g_atomic_int_inc (&_data21_->_ref_count_);
#line 111 "../src/library.vala"
	return _data21_;
#line 1036 "library.c"
}

static void
block21_data_unref (void * _userdata_)
{
	Block21Data* _data21_;
	_data21_ = (Block21Data*) _userdata_;
#line 111 "../src/library.vala"
	if (g_atomic_int_dec_and_test (&_data21_->_ref_count_)) {
#line 111 "../src/library.vala"
		_g_object_unref0 (_data21_->bookPopover);
#line 111 "../src/library.vala"
		_g_object_unref0 (_data21_->aEventBox);
#line 111 "../src/library.vala"
		_g_object_unref0 (_data21_->bookProgressBar);
#line 111 "../src/library.vala"
		_bookworm_app_book_unref0 (_data21_->aBook);
#line 111 "../src/library.vala"
		g_slice_free (Block21Data, _data21_);
#line 1056 "library.c"
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1589 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 1079 "library.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 1083 "library.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 1089 "library.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 1093 "library.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1097 "library.c"
		gchar* _tmp2_;
#line 1590 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1590 "glib-2.0.vapi"
		result = _tmp2_;
#line 1590 "glib-2.0.vapi"
		return result;
#line 1105 "library.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1593 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1593 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1593 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1593 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1593 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1593 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1593 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1593 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1133 "library.c"
				goto __catch0_g_regex_error;
			}
#line 1593 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1593 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1593 "glib-2.0.vapi"
			return NULL;
#line 1142 "library.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1594 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1594 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1594 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1594 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1156 "library.c"
				goto __catch0_g_regex_error;
			}
#line 1594 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1594 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1594 "glib-2.0.vapi"
			return NULL;
#line 1165 "library.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1594 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1594 "glib-2.0.vapi"
		result = _tmp10_;
#line 1594 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1594 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
		return result;
#line 1179 "library.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1592 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1596 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 1188 "library.c"
	}
	__finally0:
#line 1592 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1592 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1592 "glib-2.0.vapi"
	return NULL;
#line 1197 "library.c"
}

static gboolean
__lambda31_ (Block21Data* _data21_,
             GdkEventCrossing* event)
{
	GtkProgressBar* _tmp0_;
	GtkProgressBar* _tmp1_;
	gboolean result;
#line 269 "../src/library.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 271 "../src/library.vala"
	_data21_->progress = (((gdouble) bookworm_app_book_getBookPageNumber (_data21_->aBook)) + 1) / bookworm_app_book_getBookTotalPages (_data21_->aBook);
#line 272 "../src/library.vala"
	_tmp0_ = _data21_->bookProgressBar;
#line 272 "../src/library.vala"
	gtk_progress_bar_set_fraction (_tmp0_, _data21_->progress);
#line 273 "../src/library.vala"
	_tmp1_ = _data21_->bookProgressBar;
#line 273 "../src/library.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, TRUE);
#line 274 "../src/library.vala"
	result = FALSE;
#line 274 "../src/library.vala"
	return result;
#line 1223 "library.c"
}

static gboolean
___lambda31__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                            GdkEventCrossing* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda31_ (self, event);
#line 269 "../src/library.vala"
	return result;
#line 1235 "library.c"
}

static gboolean
__lambda32_ (Block21Data* _data21_,
             GdkEventCrossing* event)
{
	gboolean result;
#line 278 "../src/library.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 280 "../src/library.vala"
	if (event->detail != GDK_NOTIFY_INFERIOR) {
#line 1247 "library.c"
		GtkProgressBar* _tmp0_;
#line 281 "../src/library.vala"
		_tmp0_ = _data21_->bookProgressBar;
#line 281 "../src/library.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp0_, FALSE);
#line 1253 "library.c"
	}
#line 283 "../src/library.vala"
	result = FALSE;
#line 283 "../src/library.vala"
	return result;
#line 1259 "library.c"
}

static gboolean
___lambda32__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                            GdkEventCrossing* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda32_ (self, event);
#line 278 "../src/library.vala"
	return result;
#line 1271 "library.c"
}

static gboolean
__lambda33_ (Block21Data* _data21_,
             GdkEventButton* event)
{
	guint mouseButtonClicked = 0U;
	guint _tmp0_ = 0U;
	gboolean _tmp1_ = FALSE;
	gboolean result;
#line 287 "../src/library.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 290 "../src/library.vala"
	gdk_event_get_button ((GdkEvent*) event, &_tmp0_);
#line 290 "../src/library.vala"
	mouseButtonClicked = _tmp0_;
#line 292 "../src/library.vala"
	if (gdk_event_get_event_type ((GdkEvent*) event) == GDK_BUTTON_PRESS) {
#line 292 "../src/library.vala"
		_tmp1_ = mouseButtonClicked == ((guint) 3);
#line 1292 "library.c"
	} else {
#line 292 "../src/library.vala"
		_tmp1_ = FALSE;
#line 1296 "library.c"
	}
#line 292 "../src/library.vala"
	if (_tmp1_) {
#line 1300 "library.c"
		GtkPopover* _tmp2_;
		GtkPopover* _tmp3_;
#line 293 "../src/library.vala"
		_tmp2_ = _data21_->bookPopover;
#line 293 "../src/library.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp2_, TRUE);
#line 294 "../src/library.vala"
		_tmp3_ = _data21_->bookPopover;
#line 294 "../src/library.vala"
		gtk_widget_show_all ((GtkWidget*) _tmp3_);
#line 295 "../src/library.vala"
		result = TRUE;
#line 295 "../src/library.vala"
		return result;
#line 1315 "library.c"
	} else {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gboolean _tmp11_ = FALSE;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
#line 298 "../src/library.vala"
		_tmp4_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 298 "../src/library.vala"
		_tmp5_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[0];
#line 298 "../src/library.vala"
		if (g_strcmp0 (_tmp4_, _tmp5_) == 0) {
#line 1328 "library.c"
			GeeHashMap* _tmp6_;
			GtkEventBox* _tmp7_;
			const gchar* _tmp8_;
			gpointer _tmp9_;
			BookwormAppBook* _tmp10_;
#line 299 "../src/library.vala"
			_tmp6_ = bookworm_app_bookworm_libraryViewMap;
#line 299 "../src/library.vala"
			_tmp7_ = _data21_->aEventBox;
#line 299 "../src/library.vala"
			_tmp8_ = gtk_buildable_get_name ((GtkBuildable*) _tmp7_);
#line 299 "../src/library.vala"
			_tmp9_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp6_, _tmp8_);
#line 299 "../src/library.vala"
			_bookworm_app_book_unref0 (_data21_->aBook);
#line 299 "../src/library.vala"
			_data21_->aBook = (BookwormAppBook*) _tmp9_;
#line 300 "../src/library.vala"
			_tmp10_ = _bookworm_app_book_ref0 (_data21_->aBook);
#line 300 "../src/library.vala"
			bookworm_app_bookworm_readSelectedBook (_tmp10_);
#line 1350 "library.c"
		}
#line 302 "../src/library.vala"
		_tmp12_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 302 "../src/library.vala"
		_tmp13_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[2];
#line 302 "../src/library.vala"
		if (g_strcmp0 (_tmp12_, _tmp13_) == 0) {
#line 302 "../src/library.vala"
			_tmp11_ = TRUE;
#line 1360 "library.c"
		} else {
			const gchar* _tmp14_;
			const gchar* _tmp15_;
#line 303 "../src/library.vala"
			_tmp14_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 303 "../src/library.vala"
			_tmp15_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[3];
#line 303 "../src/library.vala"
			_tmp11_ = g_strcmp0 (_tmp14_, _tmp15_) == 0;
#line 1370 "library.c"
		}
#line 302 "../src/library.vala"
		if (_tmp11_) {
#line 1374 "library.c"
			const gchar* _tmp16_;
			gchar* _tmp17_;
			GeeHashMap* _tmp18_;
			GtkEventBox* _tmp19_;
			const gchar* _tmp20_;
			gpointer _tmp21_;
			BookwormAppBook* _tmp22_;
#line 305 "../src/library.vala"
			_tmp16_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[3];
#line 305 "../src/library.vala"
			_tmp17_ = g_strdup (_tmp16_);
#line 305 "../src/library.vala"
			_g_free0 (bookworm_app_bookworm_BOOKWORM_CURRENT_STATE);
#line 305 "../src/library.vala"
			bookworm_app_bookworm_BOOKWORM_CURRENT_STATE = _tmp17_;
#line 306 "../src/library.vala"
			_tmp18_ = bookworm_app_bookworm_libraryViewMap;
#line 306 "../src/library.vala"
			_tmp19_ = _data21_->aEventBox;
#line 306 "../src/library.vala"
			_tmp20_ = gtk_buildable_get_name ((GtkBuildable*) _tmp19_);
#line 306 "../src/library.vala"
			_tmp21_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp18_, _tmp20_);
#line 306 "../src/library.vala"
			_bookworm_app_book_unref0 (_data21_->aBook);
#line 306 "../src/library.vala"
			_data21_->aBook = (BookwormAppBook*) _tmp21_;
#line 307 "../src/library.vala"
			_tmp22_ = _bookworm_app_book_ref0 (_data21_->aBook);
#line 307 "../src/library.vala"
			bookworm_app_library_updateGridViewForSelection (_tmp22_);
#line 1406 "library.c"
		}
#line 309 "../src/library.vala"
		result = TRUE;
#line 309 "../src/library.vala"
		return result;
#line 1412 "library.c"
	}
}

static gboolean
___lambda33__gtk_widget_button_press_event (GtkWidget* _sender,
                                            GdkEventButton* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda33_ (self, event);
#line 287 "../src/library.vala"
	return result;
#line 1425 "library.c"
}

void
bookworm_app_library_updateLibraryGridView (BookwormAppBook* aBook)
{
	Block21Data* _data21_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GtkImage* aCoverImage = NULL;
	GtkImage* _tmp8_;
	GtkLabel* titleTextLabel = NULL;
	GtkLabel* _tmp9_;
	GtkImage* bookSelectionImage = NULL;
	GtkImage* bookSelectedImage = NULL;
	gchar* bookCoverLocation = NULL;
	GdkPixbuf* aBookCover = NULL;
	GtkImage* bookPlaceholderCoverImage = NULL;
	GtkProgressBar* _tmp16_;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gboolean _tmp21_;
	GdkPixbuf* bookSelectionPix = NULL;
	GdkPixbuf* _tmp109_;
	GtkImage* _tmp110_;
	GdkPixbuf* bookSelectedPix = NULL;
	GdkPixbuf* _tmp118_;
	GtkImage* _tmp119_;
	GtkImage* _tmp120_;
	GtkImage* _tmp121_;
	GtkProgressBar* _tmp122_;
	GtkProgressBar* _tmp123_;
	GtkProgressBar* _tmp124_;
	GtkProgressBar* _tmp125_;
	GtkOverlay* aOverlayImage = NULL;
	GtkOverlay* _tmp126_;
	GtkOverlay* _tmp127_;
	GtkImage* _tmp128_;
	GtkOverlay* _tmp129_;
	GtkOverlay* _tmp130_;
	GtkImage* _tmp131_;
	GtkOverlay* _tmp132_;
	GtkImage* _tmp133_;
	GtkOverlay* _tmp134_;
	GtkOverlay* _tmp135_;
	GtkProgressBar* _tmp136_;
	GtkEventBox* _tmp137_;
	GtkEventBox* _tmp138_;
	GtkEventBox* _tmp139_;
	gchar* _tmp140_;
	gchar* _tmp141_;
	GtkEventBox* _tmp142_;
	GtkOverlay* _tmp143_;
	GtkFlowBoxChild* aFlowBoxChild = NULL;
	GtkFlowBoxChild* _tmp144_;
	GtkFlowBoxChild* _tmp145_;
	GtkEventBox* _tmp146_;
	GtkFlowBox* _tmp147_;
	GtkFlowBoxChild* _tmp148_;
	GtkImage* _tmp149_;
	GtkImage* _tmp150_;
	GtkImage* _tmp151_;
	GtkEventBox* _tmp152_;
	GtkOverlay* _tmp153_;
	BookwormAppBook* _tmp154_;
	GtkPopover* _tmp155_;
	GtkEventBox* _tmp156_;
	GtkEventBox* _tmp157_;
	GtkEventBox* _tmp158_;
	gboolean _tmp159_ = FALSE;
	gboolean _tmp160_ = FALSE;
	const gchar* _tmp161_;
	const gchar* _tmp162_;
	gchar* _tmp168_;
	gchar* _tmp169_;
	gchar* _tmp170_;
	gchar* _tmp171_;
	GError* _inner_error0_ = NULL;
#line 111 "../src/library.vala"
	g_return_if_fail (aBook != NULL);
#line 111 "../src/library.vala"
	_data21_ = g_slice_new0 (Block21Data);
#line 111 "../src/library.vala"
	_data21_->_ref_count_ = 1;
#line 111 "../src/library.vala"
	_bookworm_app_book_unref0 (_data21_->aBook);
#line 111 "../src/library.vala"
	_data21_->aBook = aBook;
#line 112 "../src/library.vala"
	_tmp0_ = bookworm_app_book_getBookLocation (_data21_->aBook);
#line 112 "../src/library.vala"
	_tmp1_ = _tmp0_;
#line 112 "../src/library.vala"
	_tmp2_ = g_strconcat ("[START] [FUNCTION:updateLibraryGridView] book.location=", _tmp1_, NULL);
#line 112 "../src/library.vala"
	_tmp3_ = _tmp2_;
#line 112 "../src/library.vala"
	g_debug ("library.vala:112: %s", _tmp3_);
#line 112 "../src/library.vala"
	_g_free0 (_tmp3_);
#line 112 "../src/library.vala"
	_g_free0 (_tmp1_);
#line 114 "../src/library.vala"
	_tmp4_ = bookworm_app_book_getBookLocation (_data21_->aBook);
#line 114 "../src/library.vala"
	_tmp5_ = _tmp4_;
#line 114 "../src/library.vala"
	_tmp6_ = g_strconcat ("Started updating Library Grid View for book:", _tmp5_, NULL);
#line 114 "../src/library.vala"
	_tmp7_ = _tmp6_;
#line 114 "../src/library.vala"
	g_debug ("library.vala:114: %s", _tmp7_);
#line 114 "../src/library.vala"
	_g_free0 (_tmp7_);
#line 114 "../src/library.vala"
	_g_free0 (_tmp5_);
#line 115 "../src/library.vala"
	_tmp8_ = (GtkImage*) gtk_image_new ();
#line 115 "../src/library.vala"
	g_object_ref_sink (_tmp8_);
#line 115 "../src/library.vala"
	aCoverImage = _tmp8_;
#line 116 "../src/library.vala"
	_tmp9_ = (GtkLabel*) gtk_label_new ("");
#line 116 "../src/library.vala"
	g_object_ref_sink (_tmp9_);
#line 116 "../src/library.vala"
	titleTextLabel = _tmp9_;
#line 121 "../src/library.vala"
	bookPlaceholderCoverImage = NULL;
#line 1563 "library.c"
	{
		GdkPixbuf* bookPlaceholderCoverPix = NULL;
		GdkPixbuf* _tmp10_;
		GtkImage* _tmp11_;
#line 123 "../src/library.vala"
		_tmp10_ = gdk_pixbuf_new_from_resource_at_scale (BOOKWORM_APP_CONSTANTS_PLACEHOLDER_COVER_IMAGE_LOCATION, 10, 200, FALSE, &_inner_error0_);
#line 123 "../src/library.vala"
		bookPlaceholderCoverPix = _tmp10_;
#line 123 "../src/library.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1574 "library.c"
			goto __catch0_g_error;
		}
#line 126 "../src/library.vala"
		_tmp11_ = (GtkImage*) gtk_image_new_from_pixbuf (bookPlaceholderCoverPix);
#line 126 "../src/library.vala"
		g_object_ref_sink (_tmp11_);
#line 126 "../src/library.vala"
		_g_object_unref0 (bookPlaceholderCoverImage);
#line 126 "../src/library.vala"
		bookPlaceholderCoverImage = _tmp11_;
#line 122 "../src/library.vala"
		_g_object_unref0 (bookPlaceholderCoverPix);
#line 1587 "library.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
#line 122 "../src/library.vala"
		e = _inner_error0_;
#line 122 "../src/library.vala"
		_inner_error0_ = NULL;
#line 128 "../src/library.vala"
		_tmp12_ = e;
#line 128 "../src/library.vala"
		_tmp13_ = _tmp12_->message;
#line 128 "../src/library.vala"
		_tmp14_ = g_strconcat ("Error loading the placeholder cover image from location[" BOOKWORM_APP_CONSTANTS_PLACEHOLDER_COVER_IMAGE_LOCATION "] : ", _tmp13_, NULL);
#line 128 "../src/library.vala"
		_tmp15_ = _tmp14_;
#line 128 "../src/library.vala"
		g_warning ("library.vala:128: %s", _tmp15_);
#line 128 "../src/library.vala"
		_g_free0 (_tmp15_);
#line 122 "../src/library.vala"
		_g_error_free0 (e);
#line 1615 "library.c"
	}
	__finally0:
#line 122 "../src/library.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 122 "../src/library.vala"
		_g_object_unref0 (bookPlaceholderCoverImage);
#line 122 "../src/library.vala"
		_g_object_unref0 (aBookCover);
#line 122 "../src/library.vala"
		_g_free0 (bookCoverLocation);
#line 122 "../src/library.vala"
		_g_object_unref0 (bookSelectedImage);
#line 122 "../src/library.vala"
		_g_object_unref0 (bookSelectionImage);
#line 122 "../src/library.vala"
		_g_object_unref0 (titleTextLabel);
#line 122 "../src/library.vala"
		_g_object_unref0 (aCoverImage);
#line 122 "../src/library.vala"
		block21_data_unref (_data21_);
#line 122 "../src/library.vala"
		_data21_ = NULL;
#line 122 "../src/library.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 122 "../src/library.vala"
		g_clear_error (&_inner_error0_);
#line 122 "../src/library.vala"
		return;
#line 1644 "library.c"
	}
#line 133 "../src/library.vala"
	_tmp16_ = (GtkProgressBar*) gtk_progress_bar_new ();
#line 133 "../src/library.vala"
	g_object_ref_sink (_tmp16_);
#line 133 "../src/library.vala"
	_data21_->bookProgressBar = _tmp16_;
#line 137 "../src/library.vala"
	_tmp19_ = bookworm_app_book_getBookCoverLocation (_data21_->aBook);
#line 137 "../src/library.vala"
	_tmp20_ = _tmp19_;
#line 137 "../src/library.vala"
	_tmp21_ = _tmp20_ == NULL;
#line 137 "../src/library.vala"
	_g_free0 (_tmp20_);
#line 137 "../src/library.vala"
	if (_tmp21_) {
#line 137 "../src/library.vala"
		_tmp18_ = TRUE;
#line 1664 "library.c"
	} else {
		gchar* _tmp22_;
		gchar* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
#line 138 "../src/library.vala"
		_tmp22_ = bookworm_app_book_getBookCoverLocation (_data21_->aBook);
#line 138 "../src/library.vala"
		_tmp23_ = _tmp22_;
#line 138 "../src/library.vala"
		_tmp24_ = strlen (_tmp23_);
#line 138 "../src/library.vala"
		_tmp25_ = _tmp24_;
#line 138 "../src/library.vala"
		_tmp18_ = _tmp25_ < 1;
#line 138 "../src/library.vala"
		_g_free0 (_tmp23_);
#line 1682 "library.c"
	}
#line 137 "../src/library.vala"
	if (_tmp18_) {
#line 137 "../src/library.vala"
		_tmp17_ = TRUE;
#line 1688 "library.c"
	} else {
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
#line 139 "../src/library.vala"
		_tmp26_ = bookworm_app_book_getBookCoverLocation (_data21_->aBook);
#line 139 "../src/library.vala"
		_tmp27_ = _tmp26_;
#line 139 "../src/library.vala"
		_tmp28_ = bookworm_app_utils_fileOperations ("EXISTS", "", _tmp27_, "");
#line 139 "../src/library.vala"
		_tmp29_ = _tmp28_;
#line 139 "../src/library.vala"
		_tmp17_ = g_strcmp0 ("true", _tmp29_) != 0;
#line 139 "../src/library.vala"
		_g_free0 (_tmp29_);
#line 139 "../src/library.vala"
		_g_free0 (_tmp27_);
#line 1708 "library.c"
	}
#line 136 "../src/library.vala"
	if (_tmp17_) {
#line 1712 "library.c"
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		const gchar* _tmp33_;
#line 141 "../src/library.vala"
		bookworm_app_book_setIsBookCoverImagePresent (_data21_->aBook, FALSE);
#line 143 "../src/library.vala"
		_tmp30_ = g_strdup_printf ("%i", g_random_int_range ((gint32) 1, (gint32) 6));
#line 143 "../src/library.vala"
		_tmp31_ = _tmp30_;
#line 143 "../src/library.vala"
		_tmp32_ = string_replace (BOOKWORM_APP_CONSTANTS_DEFAULT_COVER_IMAGE_LOCATION, "N", _tmp31_);
#line 143 "../src/library.vala"
		_g_free0 (bookCoverLocation);
#line 143 "../src/library.vala"
		bookCoverLocation = _tmp32_;
#line 143 "../src/library.vala"
		_g_free0 (_tmp31_);
#line 145 "../src/library.vala"
		_tmp33_ = bookCoverLocation;
#line 145 "../src/library.vala"
		bookworm_app_book_setBookCoverLocation (_data21_->aBook, _tmp33_);
#line 1735 "library.c"
		{
			GdkPixbuf* _tmp34_ = NULL;
			gchar* _tmp35_;
			gchar* _tmp36_;
			GdkPixbuf* _tmp37_;
			GdkPixbuf* _tmp38_;
			GdkPixbuf* _tmp39_;
			GdkPixbuf* _tmp40_;
			GtkImage* _tmp41_;
#line 147 "../src/library.vala"
			_tmp35_ = bookworm_app_book_getBookCoverLocation (_data21_->aBook);
#line 147 "../src/library.vala"
			_tmp36_ = _tmp35_;
#line 147 "../src/library.vala"
			_tmp37_ = gdk_pixbuf_new_from_resource_at_scale (_tmp36_, 150, 200, FALSE, &_inner_error0_);
#line 147 "../src/library.vala"
			_tmp38_ = _tmp37_;
#line 147 "../src/library.vala"
			_g_free0 (_tmp36_);
#line 147 "../src/library.vala"
			_tmp34_ = _tmp38_;
#line 147 "../src/library.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1759 "library.c"
				goto __catch1_g_error;
			}
#line 147 "../src/library.vala"
			_tmp39_ = _tmp34_;
#line 147 "../src/library.vala"
			_tmp34_ = NULL;
#line 147 "../src/library.vala"
			_g_object_unref0 (aBookCover);
#line 147 "../src/library.vala"
			aBookCover = _tmp39_;
#line 148 "../src/library.vala"
			_tmp40_ = aBookCover;
#line 148 "../src/library.vala"
			_tmp41_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp40_);
#line 148 "../src/library.vala"
			g_object_ref_sink (_tmp41_);
#line 148 "../src/library.vala"
			_g_object_unref0 (aCoverImage);
#line 148 "../src/library.vala"
			aCoverImage = _tmp41_;
#line 146 "../src/library.vala"
			_g_object_unref0 (_tmp34_);
#line 1782 "library.c"
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			GError* _tmp48_;
			const gchar* _tmp49_;
			gchar* _tmp50_;
			gchar* _tmp51_;
#line 146 "../src/library.vala"
			e = _inner_error0_;
#line 146 "../src/library.vala"
			_inner_error0_ = NULL;
#line 150 "../src/library.vala"
			_tmp42_ = bookworm_app_book_getBookCoverLocation (_data21_->aBook);
#line 150 "../src/library.vala"
			_tmp43_ = _tmp42_;
#line 150 "../src/library.vala"
			_tmp44_ = g_strconcat ("Error in loading default cover image at location[", _tmp43_, NULL);
#line 150 "../src/library.vala"
			_tmp45_ = _tmp44_;
#line 150 "../src/library.vala"
			_tmp46_ = g_strconcat (_tmp45_, "] : ", NULL);
#line 150 "../src/library.vala"
			_tmp47_ = _tmp46_;
#line 150 "../src/library.vala"
			_tmp48_ = e;
#line 150 "../src/library.vala"
			_tmp49_ = _tmp48_->message;
#line 150 "../src/library.vala"
			_tmp50_ = g_strconcat (_tmp47_, _tmp49_, NULL);
#line 150 "../src/library.vala"
			_tmp51_ = _tmp50_;
#line 150 "../src/library.vala"
			g_warning ("library.vala:150: %s", _tmp51_);
#line 150 "../src/library.vala"
			_g_free0 (_tmp51_);
#line 150 "../src/library.vala"
			_g_free0 (_tmp47_);
#line 150 "../src/library.vala"
			_g_free0 (_tmp45_);
#line 150 "../src/library.vala"
			_g_free0 (_tmp43_);
#line 146 "../src/library.vala"
			_g_error_free0 (e);
#line 1834 "library.c"
		}
		__finally1:
#line 146 "../src/library.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 146 "../src/library.vala"
			_g_object_unref0 (bookPlaceholderCoverImage);
#line 146 "../src/library.vala"
			_g_object_unref0 (aBookCover);
#line 146 "../src/library.vala"
			_g_free0 (bookCoverLocation);
#line 146 "../src/library.vala"
			_g_object_unref0 (bookSelectedImage);
#line 146 "../src/library.vala"
			_g_object_unref0 (bookSelectionImage);
#line 146 "../src/library.vala"
			_g_object_unref0 (titleTextLabel);
#line 146 "../src/library.vala"
			_g_object_unref0 (aCoverImage);
#line 146 "../src/library.vala"
			block21_data_unref (_data21_);
#line 146 "../src/library.vala"
			_data21_ = NULL;
#line 146 "../src/library.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 146 "../src/library.vala"
			g_clear_error (&_inner_error0_);
#line 146 "../src/library.vala"
			return;
#line 1863 "library.c"
		}
	} else {
		{
			GdkPixbuf* _tmp52_ = NULL;
			gchar* _tmp53_;
			gchar* _tmp54_;
			GdkPixbuf* _tmp55_;
			GdkPixbuf* _tmp56_;
			GdkPixbuf* _tmp57_;
			GdkPixbuf* _tmp58_;
			GtkImage* _tmp59_;
#line 154 "../src/library.vala"
			_tmp53_ = bookworm_app_book_getBookCoverLocation (_data21_->aBook);
#line 154 "../src/library.vala"
			_tmp54_ = _tmp53_;
#line 154 "../src/library.vala"
			_tmp55_ = gdk_pixbuf_new_from_file_at_scale (_tmp54_, 150, 200, FALSE, &_inner_error0_);
#line 154 "../src/library.vala"
			_tmp56_ = _tmp55_;
#line 154 "../src/library.vala"
			_g_free0 (_tmp54_);
#line 154 "../src/library.vala"
			_tmp52_ = _tmp56_;
#line 154 "../src/library.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1889 "library.c"
				goto __catch2_g_error;
			}
#line 154 "../src/library.vala"
			_tmp57_ = _tmp52_;
#line 154 "../src/library.vala"
			_tmp52_ = NULL;
#line 154 "../src/library.vala"
			_g_object_unref0 (aBookCover);
#line 154 "../src/library.vala"
			aBookCover = _tmp57_;
#line 155 "../src/library.vala"
			_tmp58_ = aBookCover;
#line 155 "../src/library.vala"
			_tmp59_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp58_);
#line 155 "../src/library.vala"
			g_object_ref_sink (_tmp59_);
#line 155 "../src/library.vala"
			_g_object_unref0 (aCoverImage);
#line 155 "../src/library.vala"
			aCoverImage = _tmp59_;
#line 153 "../src/library.vala"
			_g_object_unref0 (_tmp52_);
#line 1912 "library.c"
		}
		goto __finally2;
		__catch2_g_error:
		{
			gchar* _tmp60_;
			gchar* _tmp61_;
			gchar* _tmp62_;
			const gchar* _tmp63_;
#line 153 "../src/library.vala"
			g_clear_error (&_inner_error0_);
#line 159 "../src/library.vala"
			_tmp60_ = g_strdup_printf ("%i", g_random_int_range ((gint32) 1, (gint32) 6));
#line 159 "../src/library.vala"
			_tmp61_ = _tmp60_;
#line 159 "../src/library.vala"
			_tmp62_ = string_replace (BOOKWORM_APP_CONSTANTS_DEFAULT_COVER_IMAGE_LOCATION, "N", _tmp61_);
#line 159 "../src/library.vala"
			_g_free0 (bookCoverLocation);
#line 159 "../src/library.vala"
			bookCoverLocation = _tmp62_;
#line 159 "../src/library.vala"
			_g_free0 (_tmp61_);
#line 161 "../src/library.vala"
			_tmp63_ = bookCoverLocation;
#line 161 "../src/library.vala"
			bookworm_app_book_setBookCoverLocation (_data21_->aBook, _tmp63_);
#line 162 "../src/library.vala"
			_g_object_unref0 (aCoverImage);
#line 162 "../src/library.vala"
			aCoverImage = NULL;
#line 1943 "library.c"
			{
				GdkPixbuf* _tmp64_ = NULL;
				gchar* _tmp65_;
				gchar* _tmp66_;
				GdkPixbuf* _tmp67_;
				GdkPixbuf* _tmp68_;
				GdkPixbuf* _tmp69_;
				GdkPixbuf* _tmp70_;
				GtkImage* _tmp71_;
				GtkImage* _tmp72_;
				GtkImage* _tmp73_;
#line 164 "../src/library.vala"
				_tmp65_ = bookworm_app_book_getBookCoverLocation (_data21_->aBook);
#line 164 "../src/library.vala"
				_tmp66_ = _tmp65_;
#line 164 "../src/library.vala"
				_tmp67_ = gdk_pixbuf_new_from_resource_at_scale (_tmp66_, 150, 200, FALSE, &_inner_error0_);
#line 164 "../src/library.vala"
				_tmp68_ = _tmp67_;
#line 164 "../src/library.vala"
				_g_free0 (_tmp66_);
#line 164 "../src/library.vala"
				_tmp64_ = _tmp68_;
#line 164 "../src/library.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1969 "library.c"
					goto __catch3_g_error;
				}
#line 164 "../src/library.vala"
				_tmp69_ = _tmp64_;
#line 164 "../src/library.vala"
				_tmp64_ = NULL;
#line 164 "../src/library.vala"
				_g_object_unref0 (aBookCover);
#line 164 "../src/library.vala"
				aBookCover = _tmp69_;
#line 165 "../src/library.vala"
				_tmp70_ = aBookCover;
#line 165 "../src/library.vala"
				_tmp71_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp70_);
#line 165 "../src/library.vala"
				g_object_ref_sink (_tmp71_);
#line 165 "../src/library.vala"
				_g_object_unref0 (aCoverImage);
#line 165 "../src/library.vala"
				aCoverImage = _tmp71_;
#line 167 "../src/library.vala"
				bookworm_app_book_setIsBookCoverImagePresent (_data21_->aBook, FALSE);
#line 168 "../src/library.vala"
				_tmp72_ = aCoverImage;
#line 168 "../src/library.vala"
				gtk_widget_set_halign ((GtkWidget*) _tmp72_, GTK_ALIGN_CENTER);
#line 169 "../src/library.vala"
				_tmp73_ = aCoverImage;
#line 169 "../src/library.vala"
				gtk_widget_set_valign ((GtkWidget*) _tmp73_, GTK_ALIGN_CENTER);
#line 163 "../src/library.vala"
				_g_object_unref0 (_tmp64_);
#line 2002 "library.c"
			}
			goto __finally3;
			__catch3_g_error:
			{
				GError* e = NULL;
				gchar* _tmp74_;
				gchar* _tmp75_;
				gchar* _tmp76_;
				gchar* _tmp77_;
				gchar* _tmp78_;
				gchar* _tmp79_;
				GError* _tmp80_;
				const gchar* _tmp81_;
				gchar* _tmp82_;
				gchar* _tmp83_;
#line 163 "../src/library.vala"
				e = _inner_error0_;
#line 163 "../src/library.vala"
				_inner_error0_ = NULL;
#line 171 "../src/library.vala"
				_tmp74_ = bookworm_app_book_getBookCoverLocation (_data21_->aBook);
#line 171 "../src/library.vala"
				_tmp75_ = _tmp74_;
#line 171 "../src/library.vala"
				_tmp76_ = g_strconcat ("Error in loading cover image at location[", _tmp75_, NULL);
#line 171 "../src/library.vala"
				_tmp77_ = _tmp76_;
#line 171 "../src/library.vala"
				_tmp78_ = g_strconcat (_tmp77_, "] : ", NULL);
#line 171 "../src/library.vala"
				_tmp79_ = _tmp78_;
#line 171 "../src/library.vala"
				_tmp80_ = e;
#line 171 "../src/library.vala"
				_tmp81_ = _tmp80_->message;
#line 171 "../src/library.vala"
				_tmp82_ = g_strconcat (_tmp79_, _tmp81_, NULL);
#line 171 "../src/library.vala"
				_tmp83_ = _tmp82_;
#line 171 "../src/library.vala"
				g_warning ("library.vala:171: %s", _tmp83_);
#line 171 "../src/library.vala"
				_g_free0 (_tmp83_);
#line 171 "../src/library.vala"
				_g_free0 (_tmp79_);
#line 171 "../src/library.vala"
				_g_free0 (_tmp77_);
#line 171 "../src/library.vala"
				_g_free0 (_tmp75_);
#line 163 "../src/library.vala"
				_g_error_free0 (e);
#line 2054 "library.c"
			}
			__finally3:
#line 163 "../src/library.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 163 "../src/library.vala"
				_g_object_unref0 (bookPlaceholderCoverImage);
#line 163 "../src/library.vala"
				_g_object_unref0 (aBookCover);
#line 163 "../src/library.vala"
				_g_free0 (bookCoverLocation);
#line 163 "../src/library.vala"
				_g_object_unref0 (bookSelectedImage);
#line 163 "../src/library.vala"
				_g_object_unref0 (bookSelectionImage);
#line 163 "../src/library.vala"
				_g_object_unref0 (titleTextLabel);
#line 163 "../src/library.vala"
				_g_object_unref0 (aCoverImage);
#line 163 "../src/library.vala"
				block21_data_unref (_data21_);
#line 163 "../src/library.vala"
				_data21_ = NULL;
#line 163 "../src/library.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 163 "../src/library.vala"
				g_clear_error (&_inner_error0_);
#line 163 "../src/library.vala"
				return;
#line 2083 "library.c"
			}
		}
		__finally2:
#line 153 "../src/library.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 153 "../src/library.vala"
			_g_object_unref0 (bookPlaceholderCoverImage);
#line 153 "../src/library.vala"
			_g_object_unref0 (aBookCover);
#line 153 "../src/library.vala"
			_g_free0 (bookCoverLocation);
#line 153 "../src/library.vala"
			_g_object_unref0 (bookSelectedImage);
#line 153 "../src/library.vala"
			_g_object_unref0 (bookSelectionImage);
#line 153 "../src/library.vala"
			_g_object_unref0 (titleTextLabel);
#line 153 "../src/library.vala"
			_g_object_unref0 (aCoverImage);
#line 153 "../src/library.vala"
			block21_data_unref (_data21_);
#line 153 "../src/library.vala"
			_data21_ = NULL;
#line 153 "../src/library.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 153 "../src/library.vala"
			g_clear_error (&_inner_error0_);
#line 153 "../src/library.vala"
			return;
#line 2113 "library.c"
		}
	}
#line 176 "../src/library.vala"
	if (!bookworm_app_book_getIsBookCoverImagePresent (_data21_->aBook)) {
#line 2118 "library.c"
		gchar* title = NULL;
		gchar* _tmp84_;
		gboolean _tmp85_ = FALSE;
		const gchar* _tmp86_;
		const gchar* _tmp91_;
		gchar* _tmp92_;
		const gchar* _tmp93_;
		gchar* _tmp94_;
		const gchar* _tmp95_;
		gchar* _tmp96_;
		gchar* _tmp97_;
		gchar* _tmp98_;
		gchar* _tmp99_;
		gchar* _tmp100_;
		gchar* _tmp101_;
#line 177 "../src/library.vala"
		_tmp84_ = bookworm_app_book_getBookTitle (_data21_->aBook);
#line 177 "../src/library.vala"
		title = _tmp84_;
#line 178 "../src/library.vala"
		_tmp86_ = title;
#line 178 "../src/library.vala"
		if (_tmp86_ == NULL) {
#line 178 "../src/library.vala"
			_tmp85_ = TRUE;
#line 2144 "library.c"
		} else {
			const gchar* _tmp87_;
			gint _tmp88_;
			gint _tmp89_;
#line 178 "../src/library.vala"
			_tmp87_ = title;
#line 178 "../src/library.vala"
			_tmp88_ = strlen (_tmp87_);
#line 178 "../src/library.vala"
			_tmp89_ = _tmp88_;
#line 178 "../src/library.vala"
			_tmp85_ = _tmp89_ < 1;
#line 2157 "library.c"
		}
#line 178 "../src/library.vala"
		if (_tmp85_) {
#line 2161 "library.c"
			gchar* _tmp90_;
#line 179 "../src/library.vala"
			_tmp90_ = g_strdup (BOOKWORM_APP_CONSTANTS_TEXT_FOR_UNKNOWN_TITLE);
#line 179 "../src/library.vala"
			_g_free0 (title);
#line 179 "../src/library.vala"
			title = _tmp90_;
#line 2169 "library.c"
		}
#line 182 "../src/library.vala"
		_tmp91_ = title;
#line 182 "../src/library.vala"
		_tmp92_ = string_replace (_tmp91_, "&", "and");
#line 182 "../src/library.vala"
		_g_free0 (title);
#line 182 "../src/library.vala"
		title = _tmp92_;
#line 183 "../src/library.vala"
		_tmp93_ = title;
#line 183 "../src/library.vala"
		_tmp94_ = bookworm_app_utils_minimizeStringLength (_tmp93_, 4 * BOOKWORM_APP_CONSTANTS_MAX_NUMBER_OF_CHARS_FOR_BOOK_TITLE);
#line 183 "../src/library.vala"
		_g_free0 (title);
#line 183 "../src/library.vala"
		title = _tmp94_;
#line 184 "../src/library.vala"
		_tmp95_ = title;
#line 184 "../src/library.vala"
		_tmp96_ = bookworm_app_utils_breakString (_tmp95_, BOOKWORM_APP_CONSTANTS_MAX_NUMBER_OF_CHARS_FOR_BOOK_TITLE, "\n");
#line 184 "../src/library.vala"
		_tmp97_ = _tmp96_;
#line 184 "../src/library.vala"
		_tmp98_ = g_strconcat ("<b>", _tmp97_, NULL);
#line 184 "../src/library.vala"
		_tmp99_ = _tmp98_;
#line 184 "../src/library.vala"
		_tmp100_ = g_strconcat (_tmp99_, "</b>", NULL);
#line 184 "../src/library.vala"
		_tmp101_ = _tmp100_;
#line 184 "../src/library.vala"
		gtk_label_set_text (titleTextLabel, _tmp101_);
#line 184 "../src/library.vala"
		_g_free0 (_tmp101_);
#line 184 "../src/library.vala"
		_g_free0 (_tmp99_);
#line 184 "../src/library.vala"
		_g_free0 (_tmp97_);
#line 192 "../src/library.vala"
		gtk_label_set_use_markup (titleTextLabel, TRUE);
#line 193 "../src/library.vala"
		gtk_label_set_line_wrap (titleTextLabel, TRUE);
#line 194 "../src/library.vala"
		gtk_label_set_justify (titleTextLabel, GTK_JUSTIFY_CENTER);
#line 195 "../src/library.vala"
		gtk_widget_set_margin_start ((GtkWidget*) titleTextLabel, BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS);
#line 196 "../src/library.vala"
		gtk_widget_set_margin_end ((GtkWidget*) titleTextLabel, BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS);
#line 176 "../src/library.vala"
		_g_free0 (title);
#line 2221 "library.c"
	} else {
#line 200 "../src/library.vala"
		gtk_label_set_text (titleTextLabel, "");
#line 2225 "library.c"
	}
#line 203 "../src/library.vala"
	bookSelectionPix = NULL;
#line 2229 "library.c"
	{
		GdkPixbuf* _tmp102_ = NULL;
		GdkPixbuf* _tmp103_;
		GdkPixbuf* _tmp104_;
#line 205 "../src/library.vala"
		_tmp103_ = gdk_pixbuf_new_from_resource (BOOKWORM_APP_CONSTANTS_SELECTION_OPTION_IMAGE_LOCATION, &_inner_error0_);
#line 205 "../src/library.vala"
		_tmp102_ = _tmp103_;
#line 205 "../src/library.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2240 "library.c"
			goto __catch4_g_error;
		}
#line 205 "../src/library.vala"
		_tmp104_ = _tmp102_;
#line 205 "../src/library.vala"
		_tmp102_ = NULL;
#line 205 "../src/library.vala"
		_g_object_unref0 (bookSelectionPix);
#line 205 "../src/library.vala"
		bookSelectionPix = _tmp104_;
#line 204 "../src/library.vala"
		_g_object_unref0 (_tmp102_);
#line 2253 "library.c"
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		GError* _tmp105_;
		const gchar* _tmp106_;
		gchar* _tmp107_;
		gchar* _tmp108_;
#line 204 "../src/library.vala"
		e = _inner_error0_;
#line 204 "../src/library.vala"
		_inner_error0_ = NULL;
#line 207 "../src/library.vala"
		_tmp105_ = e;
#line 207 "../src/library.vala"
		_tmp106_ = _tmp105_->message;
#line 207 "../src/library.vala"
		_tmp107_ = g_strconcat ("Error in loading Book selection image from location[" BOOKWORM_APP_CONSTANTS_SELECTION_OPTION_IMAGE_LOCATION "] : ", _tmp106_, NULL);
#line 207 "../src/library.vala"
		_tmp108_ = _tmp107_;
#line 207 "../src/library.vala"
		g_warning ("library.vala:207: %s", _tmp108_);
#line 207 "../src/library.vala"
		_g_free0 (_tmp108_);
#line 204 "../src/library.vala"
		_g_error_free0 (e);
#line 2281 "library.c"
	}
	__finally4:
#line 204 "../src/library.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 204 "../src/library.vala"
		_g_object_unref0 (bookSelectionPix);
#line 204 "../src/library.vala"
		_g_object_unref0 (bookPlaceholderCoverImage);
#line 204 "../src/library.vala"
		_g_object_unref0 (aBookCover);
#line 204 "../src/library.vala"
		_g_free0 (bookCoverLocation);
#line 204 "../src/library.vala"
		_g_object_unref0 (bookSelectedImage);
#line 204 "../src/library.vala"
		_g_object_unref0 (bookSelectionImage);
#line 204 "../src/library.vala"
		_g_object_unref0 (titleTextLabel);
#line 204 "../src/library.vala"
		_g_object_unref0 (aCoverImage);
#line 204 "../src/library.vala"
		block21_data_unref (_data21_);
#line 204 "../src/library.vala"
		_data21_ = NULL;
#line 204 "../src/library.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 204 "../src/library.vala"
		g_clear_error (&_inner_error0_);
#line 204 "../src/library.vala"
		return;
#line 2312 "library.c"
	}
#line 210 "../src/library.vala"
	_tmp109_ = bookSelectionPix;
#line 210 "../src/library.vala"
	_tmp110_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp109_);
#line 210 "../src/library.vala"
	g_object_ref_sink (_tmp110_);
#line 210 "../src/library.vala"
	_g_object_unref0 (bookSelectionImage);
#line 210 "../src/library.vala"
	bookSelectionImage = _tmp110_;
#line 211 "../src/library.vala"
	gtk_widget_set_halign ((GtkWidget*) bookSelectionImage, GTK_ALIGN_CENTER);
#line 212 "../src/library.vala"
	gtk_widget_set_valign ((GtkWidget*) bookSelectionImage, GTK_ALIGN_START);
#line 215 "../src/library.vala"
	bookSelectedPix = NULL;
#line 2330 "library.c"
	{
		GdkPixbuf* _tmp111_ = NULL;
		GdkPixbuf* _tmp112_;
		GdkPixbuf* _tmp113_;
#line 217 "../src/library.vala"
		_tmp112_ = gdk_pixbuf_new_from_resource (BOOKWORM_APP_CONSTANTS_SELECTION_CHECKED_IMAGE_LOCATION, &_inner_error0_);
#line 217 "../src/library.vala"
		_tmp111_ = _tmp112_;
#line 217 "../src/library.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2341 "library.c"
			goto __catch5_g_error;
		}
#line 217 "../src/library.vala"
		_tmp113_ = _tmp111_;
#line 217 "../src/library.vala"
		_tmp111_ = NULL;
#line 217 "../src/library.vala"
		_g_object_unref0 (bookSelectedPix);
#line 217 "../src/library.vala"
		bookSelectedPix = _tmp113_;
#line 216 "../src/library.vala"
		_g_object_unref0 (_tmp111_);
#line 2354 "library.c"
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp114_;
		const gchar* _tmp115_;
		gchar* _tmp116_;
		gchar* _tmp117_;
#line 216 "../src/library.vala"
		e = _inner_error0_;
#line 216 "../src/library.vala"
		_inner_error0_ = NULL;
#line 219 "../src/library.vala"
		_tmp114_ = e;
#line 219 "../src/library.vala"
		_tmp115_ = _tmp114_->message;
#line 219 "../src/library.vala"
		_tmp116_ = g_strconcat ("Error in loading Book Selection Checked image from location[" BOOKWORM_APP_CONSTANTS_SELECTION_CHECKED_IMAGE_LOCATION "] :", _tmp115_, NULL);
#line 219 "../src/library.vala"
		_tmp117_ = _tmp116_;
#line 219 "../src/library.vala"
		g_warning ("library.vala:219: %s", _tmp117_);
#line 219 "../src/library.vala"
		_g_free0 (_tmp117_);
#line 216 "../src/library.vala"
		_g_error_free0 (e);
#line 2382 "library.c"
	}
	__finally5:
#line 216 "../src/library.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 216 "../src/library.vala"
		_g_object_unref0 (bookSelectedPix);
#line 216 "../src/library.vala"
		_g_object_unref0 (bookSelectionPix);
#line 216 "../src/library.vala"
		_g_object_unref0 (bookPlaceholderCoverImage);
#line 216 "../src/library.vala"
		_g_object_unref0 (aBookCover);
#line 216 "../src/library.vala"
		_g_free0 (bookCoverLocation);
#line 216 "../src/library.vala"
		_g_object_unref0 (bookSelectedImage);
#line 216 "../src/library.vala"
		_g_object_unref0 (bookSelectionImage);
#line 216 "../src/library.vala"
		_g_object_unref0 (titleTextLabel);
#line 216 "../src/library.vala"
		_g_object_unref0 (aCoverImage);
#line 216 "../src/library.vala"
		block21_data_unref (_data21_);
#line 216 "../src/library.vala"
		_data21_ = NULL;
#line 216 "../src/library.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 216 "../src/library.vala"
		g_clear_error (&_inner_error0_);
#line 216 "../src/library.vala"
		return;
#line 2415 "library.c"
	}
#line 222 "../src/library.vala"
	_tmp118_ = bookSelectedPix;
#line 222 "../src/library.vala"
	_tmp119_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp118_);
#line 222 "../src/library.vala"
	g_object_ref_sink (_tmp119_);
#line 222 "../src/library.vala"
	_g_object_unref0 (bookSelectedImage);
#line 222 "../src/library.vala"
	bookSelectedImage = _tmp119_;
#line 223 "../src/library.vala"
	_tmp120_ = bookSelectedImage;
#line 223 "../src/library.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp120_, GTK_ALIGN_CENTER);
#line 224 "../src/library.vala"
	_tmp121_ = bookSelectedImage;
#line 224 "../src/library.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp121_, GTK_ALIGN_START);
#line 227 "../src/library.vala"
	_data21_->progress = 0.0;
#line 228 "../src/library.vala"
	_tmp122_ = _data21_->bookProgressBar;
#line 228 "../src/library.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp122_, GTK_ALIGN_CENTER);
#line 229 "../src/library.vala"
	_tmp123_ = _data21_->bookProgressBar;
#line 229 "../src/library.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp123_, GTK_ALIGN_END);
#line 230 "../src/library.vala"
	_tmp124_ = _data21_->bookProgressBar;
#line 230 "../src/library.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp124_, FALSE);
#line 232 "../src/library.vala"
	_tmp125_ = _data21_->bookProgressBar;
#line 232 "../src/library.vala"
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp125_, TRUE);
#line 235 "../src/library.vala"
	_tmp126_ = (GtkOverlay*) gtk_overlay_new ();
#line 235 "../src/library.vala"
	g_object_ref_sink (_tmp126_);
#line 235 "../src/library.vala"
	aOverlayImage = _tmp126_;
#line 236 "../src/library.vala"
	_tmp127_ = aOverlayImage;
#line 236 "../src/library.vala"
	_tmp128_ = bookPlaceholderCoverImage;
#line 236 "../src/library.vala"
	gtk_container_add ((GtkContainer*) _tmp127_, (GtkWidget*) _tmp128_);
#line 237 "../src/library.vala"
	_tmp129_ = aOverlayImage;
#line 237 "../src/library.vala"
	gtk_overlay_add_overlay (_tmp129_, (GtkWidget*) bookSelectionImage);
#line 238 "../src/library.vala"
	_tmp130_ = aOverlayImage;
#line 238 "../src/library.vala"
	_tmp131_ = bookSelectedImage;
#line 238 "../src/library.vala"
	gtk_overlay_add_overlay (_tmp130_, (GtkWidget*) _tmp131_);
#line 239 "../src/library.vala"
	_tmp132_ = aOverlayImage;
#line 239 "../src/library.vala"
	_tmp133_ = aCoverImage;
#line 239 "../src/library.vala"
	gtk_overlay_add_overlay (_tmp132_, (GtkWidget*) _tmp133_);
#line 240 "../src/library.vala"
	_tmp134_ = aOverlayImage;
#line 240 "../src/library.vala"
	gtk_overlay_add_overlay (_tmp134_, (GtkWidget*) titleTextLabel);
#line 241 "../src/library.vala"
	_tmp135_ = aOverlayImage;
#line 241 "../src/library.vala"
	_tmp136_ = _data21_->bookProgressBar;
#line 241 "../src/library.vala"
	gtk_overlay_add_overlay (_tmp135_, (GtkWidget*) _tmp136_);
#line 244 "../src/library.vala"
	_tmp137_ = (GtkEventBox*) gtk_event_box_new ();
#line 244 "../src/library.vala"
	g_object_ref_sink (_tmp137_);
#line 244 "../src/library.vala"
	_data21_->aEventBox = _tmp137_;
#line 245 "../src/library.vala"
	_tmp138_ = _data21_->aEventBox;
#line 245 "../src/library.vala"
	gtk_container_set_border_width ((GtkContainer*) _tmp138_, (guint) (BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS / 2));
#line 246 "../src/library.vala"
	_tmp139_ = _data21_->aEventBox;
#line 246 "../src/library.vala"
	_tmp140_ = bookworm_app_book_getBookLocation (_data21_->aBook);
#line 246 "../src/library.vala"
	_tmp141_ = _tmp140_;
#line 246 "../src/library.vala"
	gtk_buildable_set_name ((GtkBuildable*) _tmp139_, _tmp141_);
#line 246 "../src/library.vala"
	_g_free0 (_tmp141_);
#line 247 "../src/library.vala"
	_tmp142_ = _data21_->aEventBox;
#line 247 "../src/library.vala"
	_tmp143_ = aOverlayImage;
#line 247 "../src/library.vala"
	gtk_container_add ((GtkContainer*) _tmp142_, (GtkWidget*) _tmp143_);
#line 250 "../src/library.vala"
	_tmp144_ = (GtkFlowBoxChild*) gtk_flow_box_child_new ();
#line 250 "../src/library.vala"
	g_object_ref_sink (_tmp144_);
#line 250 "../src/library.vala"
	aFlowBoxChild = _tmp144_;
#line 251 "../src/library.vala"
	_tmp145_ = aFlowBoxChild;
#line 251 "../src/library.vala"
	_tmp146_ = _data21_->aEventBox;
#line 251 "../src/library.vala"
	gtk_container_add ((GtkContainer*) _tmp145_, (GtkWidget*) _tmp146_);
#line 254 "../src/library.vala"
	_tmp147_ = bookworm_app_app_window_library_grid;
#line 254 "../src/library.vala"
	_tmp148_ = aFlowBoxChild;
#line 254 "../src/library.vala"
	gtk_container_add ((GtkContainer*) _tmp147_, (GtkWidget*) _tmp148_);
#line 257 "../src/library.vala"
	_tmp149_ = bookPlaceholderCoverImage;
#line 257 "../src/library.vala"
	bookworm_app_book_setBookWidget (_data21_->aBook, "PLACEHOLDER_COVER_IMAGE", (GtkWidget*) _tmp149_);
#line 258 "../src/library.vala"
	_tmp150_ = aCoverImage;
#line 258 "../src/library.vala"
	bookworm_app_book_setBookWidget (_data21_->aBook, "COVER_IMAGE", (GtkWidget*) _tmp150_);
#line 259 "../src/library.vala"
	bookworm_app_book_setBookWidget (_data21_->aBook, "TITLE_TEXT_LABEL", (GtkWidget*) titleTextLabel);
#line 260 "../src/library.vala"
	_tmp151_ = bookSelectedImage;
#line 260 "../src/library.vala"
	bookworm_app_book_setBookWidget (_data21_->aBook, "SELECTED_BADGE_IMAGE", (GtkWidget*) _tmp151_);
#line 261 "../src/library.vala"
	bookworm_app_book_setBookWidget (_data21_->aBook, "SELECTION_BADGE_IMAGE", (GtkWidget*) bookSelectionImage);
#line 262 "../src/library.vala"
	_tmp152_ = _data21_->aEventBox;
#line 262 "../src/library.vala"
	bookworm_app_book_setBookWidget (_data21_->aBook, "BOOK_EVENTBOX", (GtkWidget*) _tmp152_);
#line 263 "../src/library.vala"
	_tmp153_ = aOverlayImage;
#line 263 "../src/library.vala"
	bookworm_app_book_setBookWidget (_data21_->aBook, "BOOK_OVERLAY_IMAGE", (GtkWidget*) _tmp153_);
#line 266 "../src/library.vala"
	_tmp154_ = _bookworm_app_book_ref0 (_data21_->aBook);
#line 266 "../src/library.vala"
	_tmp155_ = bookworm_app_app_dialog_createBookContextMenu (_tmp154_);
#line 266 "../src/library.vala"
	_data21_->bookPopover = _tmp155_;
#line 269 "../src/library.vala"
	_tmp156_ = _data21_->aEventBox;
#line 269 "../src/library.vala"
	g_signal_connect_data ((GtkWidget*) _tmp156_, "enter-notify-event", (GCallback) ___lambda31__gtk_widget_enter_notify_event, block21_data_ref (_data21_), (GClosureNotify) block21_data_unref, 0);
#line 278 "../src/library.vala"
	_tmp157_ = _data21_->aEventBox;
#line 278 "../src/library.vala"
	g_signal_connect_data ((GtkWidget*) _tmp157_, "leave-notify-event", (GCallback) ___lambda32__gtk_widget_leave_notify_event, block21_data_ref (_data21_), (GClosureNotify) block21_data_unref, 0);
#line 287 "../src/library.vala"
	_tmp158_ = _data21_->aEventBox;
#line 287 "../src/library.vala"
	g_signal_connect_data ((GtkWidget*) _tmp158_, "button-press-event", (GCallback) ___lambda33__gtk_widget_button_press_event, block21_data_ref (_data21_), (GClosureNotify) block21_data_unref, 0);
#line 313 "../src/library.vala"
	_tmp161_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 313 "../src/library.vala"
	_tmp162_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[0];
#line 313 "../src/library.vala"
	if (g_strcmp0 (_tmp161_, _tmp162_) == 0) {
#line 313 "../src/library.vala"
		_tmp160_ = TRUE;
#line 2585 "library.c"
	} else {
		const gchar* _tmp163_;
		const gchar* _tmp164_;
#line 314 "../src/library.vala"
		_tmp163_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 314 "../src/library.vala"
		_tmp164_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[2];
#line 314 "../src/library.vala"
		_tmp160_ = g_strcmp0 (_tmp163_, _tmp164_) == 0;
#line 2595 "library.c"
	}
#line 313 "../src/library.vala"
	if (_tmp160_) {
#line 313 "../src/library.vala"
		_tmp159_ = TRUE;
#line 2601 "library.c"
	} else {
		const gchar* _tmp165_;
		const gchar* _tmp166_;
#line 315 "../src/library.vala"
		_tmp165_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 315 "../src/library.vala"
		_tmp166_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[3];
#line 315 "../src/library.vala"
		_tmp159_ = g_strcmp0 (_tmp165_, _tmp166_) == 0;
#line 2611 "library.c"
	}
#line 313 "../src/library.vala"
	if (_tmp159_) {
#line 2615 "library.c"
		GtkFlowBox* _tmp167_;
#line 317 "../src/library.vala"
		_tmp167_ = bookworm_app_app_window_library_grid;
#line 317 "../src/library.vala"
		gtk_widget_show_all ((GtkWidget*) _tmp167_);
#line 2621 "library.c"
	}
#line 319 "../src/library.vala"
	_tmp168_ = bookworm_app_book_getBookLocation (_data21_->aBook);
#line 319 "../src/library.vala"
	_tmp169_ = _tmp168_;
#line 319 "../src/library.vala"
	_tmp170_ = g_strconcat ("Completed updating Library View for book:", _tmp169_, NULL);
#line 319 "../src/library.vala"
	_tmp171_ = _tmp170_;
#line 319 "../src/library.vala"
	g_debug ("library.vala:319: %s", _tmp171_);
#line 319 "../src/library.vala"
	_g_free0 (_tmp171_);
#line 319 "../src/library.vala"
	_g_free0 (_tmp169_);
#line 111 "../src/library.vala"
	_g_object_unref0 (aFlowBoxChild);
#line 111 "../src/library.vala"
	_g_object_unref0 (aOverlayImage);
#line 111 "../src/library.vala"
	_g_object_unref0 (bookSelectedPix);
#line 111 "../src/library.vala"
	_g_object_unref0 (bookSelectionPix);
#line 111 "../src/library.vala"
	_g_object_unref0 (bookPlaceholderCoverImage);
#line 111 "../src/library.vala"
	_g_object_unref0 (aBookCover);
#line 111 "../src/library.vala"
	_g_free0 (bookCoverLocation);
#line 111 "../src/library.vala"
	_g_object_unref0 (bookSelectedImage);
#line 111 "../src/library.vala"
	_g_object_unref0 (bookSelectionImage);
#line 111 "../src/library.vala"
	_g_object_unref0 (titleTextLabel);
#line 111 "../src/library.vala"
	_g_object_unref0 (aCoverImage);
#line 111 "../src/library.vala"
	block21_data_unref (_data21_);
#line 111 "../src/library.vala"
	_data21_ = NULL;
#line 2663 "library.c"
}

void
bookworm_app_library_replaceCoverImageOnBook (BookwormAppBook* book)
{
	GtkOverlay* oldOverlayImage = NULL;
	GtkWidget* _tmp0_;
	GtkOverlay* lOverlayImage = NULL;
	GtkOverlay* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* _tmp5_;
	GtkWidget* _tmp6_;
	GtkWidget* _tmp7_;
	GtkWidget* _tmp8_;
	GtkWidget* _tmp9_;
	GtkWidget* _tmp10_;
	GtkWidget* _tmp11_;
	GtkEventBox* aEventBox = NULL;
	GtkWidget* _tmp12_;
	GeeHashMap* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
#line 323 "../src/library.vala"
	g_debug ("library.vala:323: [START] [FUNCTION:replaceCoverImageOnBook]");
#line 325 "../src/library.vala"
	_tmp0_ = bookworm_app_book_getBookWidget (book, "BOOK_OVERLAY_IMAGE");
#line 325 "../src/library.vala"
	oldOverlayImage = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_overlay_get_type (), GtkOverlay);
#line 326 "../src/library.vala"
	gtk_widget_destroy ((GtkWidget*) oldOverlayImage);
#line 328 "../src/library.vala"
	_tmp1_ = (GtkOverlay*) gtk_overlay_new ();
#line 328 "../src/library.vala"
	g_object_ref_sink (_tmp1_);
#line 328 "../src/library.vala"
	lOverlayImage = _tmp1_;
#line 329 "../src/library.vala"
	_tmp2_ = bookworm_app_book_getBookWidget (book, "PLACEHOLDER_COVER_IMAGE");
#line 329 "../src/library.vala"
	_tmp3_ = _tmp2_;
#line 329 "../src/library.vala"
	gtk_container_add ((GtkContainer*) lOverlayImage, _tmp3_);
#line 329 "../src/library.vala"
	_g_object_unref0 (_tmp3_);
#line 330 "../src/library.vala"
	_tmp4_ = bookworm_app_book_getBookWidget (book, "SELECTION_BADGE_IMAGE");
#line 330 "../src/library.vala"
	_tmp5_ = _tmp4_;
#line 330 "../src/library.vala"
	gtk_overlay_add_overlay (lOverlayImage, _tmp5_);
#line 330 "../src/library.vala"
	_g_object_unref0 (_tmp5_);
#line 331 "../src/library.vala"
	_tmp6_ = bookworm_app_book_getBookWidget (book, "SELECTED_BADGE_IMAGE");
#line 331 "../src/library.vala"
	_tmp7_ = _tmp6_;
#line 331 "../src/library.vala"
	gtk_overlay_add_overlay (lOverlayImage, _tmp7_);
#line 331 "../src/library.vala"
	_g_object_unref0 (_tmp7_);
#line 332 "../src/library.vala"
	_tmp8_ = bookworm_app_book_getBookWidget (book, "COVER_IMAGE");
#line 332 "../src/library.vala"
	_tmp9_ = _tmp8_;
#line 332 "../src/library.vala"
	gtk_overlay_add_overlay (lOverlayImage, _tmp9_);
#line 332 "../src/library.vala"
	_g_object_unref0 (_tmp9_);
#line 333 "../src/library.vala"
	_tmp10_ = bookworm_app_book_getBookWidget (book, "TITLE_TEXT_LABEL");
#line 333 "../src/library.vala"
	_tmp11_ = _tmp10_;
#line 333 "../src/library.vala"
	gtk_overlay_add_overlay (lOverlayImage, _tmp11_);
#line 333 "../src/library.vala"
	_g_object_unref0 (_tmp11_);
#line 334 "../src/library.vala"
	bookworm_app_book_setBookWidget (book, "BOOK_OVERLAY_IMAGE", (GtkWidget*) lOverlayImage);
#line 336 "../src/library.vala"
	_tmp12_ = bookworm_app_book_getBookWidget (book, "BOOK_EVENTBOX");
#line 336 "../src/library.vala"
	aEventBox = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_event_box_get_type (), GtkEventBox);
#line 337 "../src/library.vala"
	gtk_container_add ((GtkContainer*) aEventBox, (GtkWidget*) lOverlayImage);
#line 338 "../src/library.vala"
	bookworm_app_book_setBookWidget (book, "BOOK_EVENTBOX", (GtkWidget*) aEventBox);
#line 340 "../src/library.vala"
	_tmp13_ = bookworm_app_bookworm_libraryViewMap;
#line 340 "../src/library.vala"
	_tmp14_ = bookworm_app_book_getBookLocation (book);
#line 340 "../src/library.vala"
	_tmp15_ = _tmp14_;
#line 340 "../src/library.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp13_, _tmp15_, book);
#line 340 "../src/library.vala"
	_g_free0 (_tmp15_);
#line 341 "../src/library.vala"
	g_debug ("library.vala:341: [END] [FUNCTION:replaceCoverImageOnBook]");
#line 322 "../src/library.vala"
	_g_object_unref0 (aEventBox);
#line 322 "../src/library.vala"
	_g_object_unref0 (lOverlayImage);
#line 322 "../src/library.vala"
	_g_object_unref0 (oldOverlayImage);
#line 322 "../src/library.vala"
	_bookworm_app_book_unref0 (book);
#line 2772 "library.c"
}

static Block22Data*
block22_data_ref (Block22Data* _data22_)
{
#line 343 "../src/library.vala"
	g_atomic_int_inc (&_data22_->_ref_count_);
#line 343 "../src/library.vala"
	return _data22_;
#line 2782 "library.c"
}

static void
block22_data_unref (void * _userdata_)
{
	Block22Data* _data22_;
	_data22_ = (Block22Data*) _userdata_;
#line 343 "../src/library.vala"
	if (g_atomic_int_dec_and_test (&_data22_->_ref_count_)) {
#line 343 "../src/library.vala"
		_bookworm_app_book_unref0 (_data22_->lBook);
#line 343 "../src/library.vala"
		g_slice_free (Block22Data, _data22_);
#line 2796 "library.c"
	}
}

static gboolean
__lambda38_ (Block22Data* _data22_,
             GtkTreeModel* model,
             GtkTreePath* path,
             GtkTreeIter* iter)
{
	GValue bookLocationAtRow = {0};
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_;
	GValue _tmp2_ = {0};
	BookwormAppBook* aBook = NULL;
	GeeHashMap* _tmp3_;
	GValue _tmp4_;
	gpointer _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gboolean _tmp20_ = FALSE;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	GeeHashMap* _tmp36_;
	BookwormAppBook* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	BookwormAppBook* _tmp40_;
	gboolean result;
#line 346 "../src/library.vala"
	g_return_val_if_fail (model != NULL, FALSE);
#line 346 "../src/library.vala"
	g_return_val_if_fail (path != NULL, FALSE);
#line 346 "../src/library.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 348 "../src/library.vala"
	_tmp0_ = bookworm_app_app_window_library_table_liststore;
#line 348 "../src/library.vala"
	_tmp1_ = *iter;
#line 348 "../src/library.vala"
	gtk_tree_model_get_value ((GtkTreeModel*) _tmp0_, &_tmp1_, 7, &_tmp2_);
#line 348 "../src/library.vala"
	G_IS_VALUE (&bookLocationAtRow) ? (g_value_unset (&bookLocationAtRow), NULL) : NULL;
#line 348 "../src/library.vala"
	bookLocationAtRow = _tmp2_;
#line 349 "../src/library.vala"
	_tmp3_ = bookworm_app_bookworm_libraryViewMap;
#line 349 "../src/library.vala"
	_tmp4_ = bookLocationAtRow;
#line 349 "../src/library.vala"
	_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, g_value_get_string (&_tmp4_));
#line 349 "../src/library.vala"
	aBook = (BookwormAppBook*) _tmp5_;
#line 350 "../src/library.vala"
	_tmp6_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 350 "../src/library.vala"
	_tmp7_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[5];
#line 350 "../src/library.vala"
	if (g_strcmp0 (_tmp6_, _tmp7_) == 0) {
#line 2857 "library.c"
		GtkListStore* _tmp8_;
		GtkTreeIter _tmp9_;
		GdkPixbuf* _tmp10_;
		GValue _tmp11_ = {0};
		BookwormAppBook* _tmp12_;
#line 351 "../src/library.vala"
		_tmp8_ = bookworm_app_app_window_library_table_liststore;
#line 351 "../src/library.vala"
		_tmp9_ = *iter;
#line 351 "../src/library.vala"
		_tmp10_ = bookworm_app_bookworm_image_selection_transparent_small;
#line 351 "../src/library.vala"
		g_value_init (&_tmp11_, gdk_pixbuf_get_type ());
#line 351 "../src/library.vala"
		g_value_set_object (&_tmp11_, _tmp10_);
#line 351 "../src/library.vala"
		gtk_list_store_set_value (_tmp8_, &_tmp9_, 0, &_tmp11_);
#line 351 "../src/library.vala"
		G_IS_VALUE (&_tmp11_) ? (g_value_unset (&_tmp11_), NULL) : NULL;
#line 352 "../src/library.vala"
		_tmp12_ = aBook;
#line 352 "../src/library.vala"
		bookworm_app_book_setIsBookSelected (_tmp12_, FALSE);
#line 353 "../src/library.vala"
		bookworm_app_app_window_controlDeletionButton (FALSE);
#line 2883 "library.c"
	}
#line 355 "../src/library.vala"
	_tmp13_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 355 "../src/library.vala"
	_tmp14_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[6];
#line 355 "../src/library.vala"
	if (g_strcmp0 (_tmp13_, _tmp14_) == 0) {
#line 2891 "library.c"
		GtkListStore* _tmp15_;
		GtkTreeIter _tmp16_;
		GdkPixbuf* _tmp17_;
		GValue _tmp18_ = {0};
		BookwormAppBook* _tmp19_;
#line 356 "../src/library.vala"
		_tmp15_ = bookworm_app_app_window_library_table_liststore;
#line 356 "../src/library.vala"
		_tmp16_ = *iter;
#line 356 "../src/library.vala"
		_tmp17_ = bookworm_app_bookworm_image_selection_option_small;
#line 356 "../src/library.vala"
		g_value_init (&_tmp18_, gdk_pixbuf_get_type ());
#line 356 "../src/library.vala"
		g_value_set_object (&_tmp18_, _tmp17_);
#line 356 "../src/library.vala"
		gtk_list_store_set_value (_tmp15_, &_tmp16_, 0, &_tmp18_);
#line 356 "../src/library.vala"
		G_IS_VALUE (&_tmp18_) ? (g_value_unset (&_tmp18_), NULL) : NULL;
#line 357 "../src/library.vala"
		_tmp19_ = aBook;
#line 357 "../src/library.vala"
		bookworm_app_book_setIsBookSelected (_tmp19_, FALSE);
#line 358 "../src/library.vala"
		bookworm_app_app_window_controlDeletionButton (FALSE);
#line 2917 "library.c"
	}
#line 360 "../src/library.vala"
	_tmp21_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 360 "../src/library.vala"
	_tmp22_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[7];
#line 360 "../src/library.vala"
	if (g_strcmp0 (_tmp21_, _tmp22_) == 0) {
#line 2925 "library.c"
		GValue _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
#line 361 "../src/library.vala"
		_tmp23_ = bookLocationAtRow;
#line 361 "../src/library.vala"
		_tmp24_ = bookworm_app_book_getBookLocation (_data22_->lBook);
#line 361 "../src/library.vala"
		_tmp25_ = _tmp24_;
#line 361 "../src/library.vala"
		_tmp20_ = g_strcmp0 (g_value_get_string (&_tmp23_), _tmp25_) == 0;
#line 361 "../src/library.vala"
		_g_free0 (_tmp25_);
#line 2939 "library.c"
	} else {
#line 360 "../src/library.vala"
		_tmp20_ = FALSE;
#line 2943 "library.c"
	}
#line 360 "../src/library.vala"
	if (_tmp20_) {
#line 363 "../src/library.vala"
		if (!bookworm_app_book_getIsBookSelected (_data22_->lBook)) {
#line 2949 "library.c"
			GtkListStore* _tmp26_;
			GtkTreeIter _tmp27_;
			GdkPixbuf* _tmp28_;
			GValue _tmp29_ = {0};
			BookwormAppBook* _tmp30_;
#line 364 "../src/library.vala"
			_tmp26_ = bookworm_app_app_window_library_table_liststore;
#line 364 "../src/library.vala"
			_tmp27_ = *iter;
#line 364 "../src/library.vala"
			_tmp28_ = bookworm_app_bookworm_image_selection_checked_small;
#line 364 "../src/library.vala"
			g_value_init (&_tmp29_, gdk_pixbuf_get_type ());
#line 364 "../src/library.vala"
			g_value_set_object (&_tmp29_, _tmp28_);
#line 364 "../src/library.vala"
			gtk_list_store_set_value (_tmp26_, &_tmp27_, 0, &_tmp29_);
#line 364 "../src/library.vala"
			G_IS_VALUE (&_tmp29_) ? (g_value_unset (&_tmp29_), NULL) : NULL;
#line 365 "../src/library.vala"
			_tmp30_ = aBook;
#line 365 "../src/library.vala"
			bookworm_app_book_setIsBookSelected (_tmp30_, TRUE);
#line 366 "../src/library.vala"
			bookworm_app_app_window_controlDeletionButton (TRUE);
#line 2975 "library.c"
		} else {
			GtkListStore* _tmp31_;
			GtkTreeIter _tmp32_;
			GdkPixbuf* _tmp33_;
			GValue _tmp34_ = {0};
			BookwormAppBook* _tmp35_;
#line 368 "../src/library.vala"
			_tmp31_ = bookworm_app_app_window_library_table_liststore;
#line 368 "../src/library.vala"
			_tmp32_ = *iter;
#line 368 "../src/library.vala"
			_tmp33_ = bookworm_app_bookworm_image_selection_option_small;
#line 368 "../src/library.vala"
			g_value_init (&_tmp34_, gdk_pixbuf_get_type ());
#line 368 "../src/library.vala"
			g_value_set_object (&_tmp34_, _tmp33_);
#line 368 "../src/library.vala"
			gtk_list_store_set_value (_tmp31_, &_tmp32_, 0, &_tmp34_);
#line 368 "../src/library.vala"
			G_IS_VALUE (&_tmp34_) ? (g_value_unset (&_tmp34_), NULL) : NULL;
#line 369 "../src/library.vala"
			_tmp35_ = aBook;
#line 369 "../src/library.vala"
			bookworm_app_book_setIsBookSelected (_tmp35_, FALSE);
#line 370 "../src/library.vala"
			bookworm_app_app_window_controlDeletionButton (FALSE);
#line 3002 "library.c"
		}
	}
#line 374 "../src/library.vala"
	_tmp36_ = bookworm_app_bookworm_libraryViewMap;
#line 374 "../src/library.vala"
	_tmp37_ = aBook;
#line 374 "../src/library.vala"
	_tmp38_ = bookworm_app_book_getBookLocation (_tmp37_);
#line 374 "../src/library.vala"
	_tmp39_ = _tmp38_;
#line 374 "../src/library.vala"
	_tmp40_ = aBook;
#line 374 "../src/library.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp36_, _tmp39_, _tmp40_);
#line 374 "../src/library.vala"
	_g_free0 (_tmp39_);
#line 375 "../src/library.vala"
	result = FALSE;
#line 375 "../src/library.vala"
	_bookworm_app_book_unref0 (aBook);
#line 375 "../src/library.vala"
	G_IS_VALUE (&bookLocationAtRow) ? (g_value_unset (&bookLocationAtRow), NULL) : NULL;
#line 375 "../src/library.vala"
	return result;
#line 3027 "library.c"
}

static gboolean
___lambda38__gtk_tree_model_foreach_func (GtkTreeModel* model,
                                          GtkTreePath* path,
                                          GtkTreeIter* iter,
                                          gpointer self)
{
	gboolean result;
	result = __lambda38_ (self, model, path, iter);
#line 346 "../src/library.vala"
	return result;
#line 3040 "library.c"
}

void
bookworm_app_library_updateListViewForSelection (BookwormAppBook* lBook)
{
	Block22Data* _data22_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GtkTreeModelForeachFunc print_row = NULL;
	gpointer print_row_target;
	GDestroyNotify print_row_target_destroy_notify;
	GtkListStore* _tmp3_;
#line 343 "../src/library.vala"
	_data22_ = g_slice_new0 (Block22Data);
#line 343 "../src/library.vala"
	_data22_->_ref_count_ = 1;
#line 343 "../src/library.vala"
	_bookworm_app_book_unref0 (_data22_->lBook);
#line 343 "../src/library.vala"
	_data22_->lBook = lBook;
#line 344 "../src/library.vala"
	_tmp0_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 344 "../src/library.vala"
	_tmp1_ = g_strconcat ("[START] [FUNCTION:updateListViewForSelection] Updating List View Selec" \
"tion Badges for mode:", _tmp0_, NULL);
#line 344 "../src/library.vala"
	_tmp2_ = _tmp1_;
#line 344 "../src/library.vala"
	g_debug ("library.vala:344: %s", _tmp2_);
#line 344 "../src/library.vala"
	_g_free0 (_tmp2_);
#line 346 "../src/library.vala"
	print_row = ___lambda38__gtk_tree_model_foreach_func;
#line 346 "../src/library.vala"
	print_row_target = block22_data_ref (_data22_);
#line 346 "../src/library.vala"
	print_row_target_destroy_notify = block22_data_unref;
#line 377 "../src/library.vala"
	_tmp3_ = bookworm_app_app_window_library_table_liststore;
#line 377 "../src/library.vala"
	gtk_tree_model_foreach ((GtkTreeModel*) _tmp3_, print_row, print_row_target);
#line 378 "../src/library.vala"
	g_debug ("library.vala:378: [END] [FUNCTION:updateListViewForSelection]");
#line 343 "../src/library.vala"
	(print_row_target_destroy_notify == NULL) ? NULL : (print_row_target_destroy_notify (print_row_target), NULL);
#line 343 "../src/library.vala"
	print_row = NULL;
#line 343 "../src/library.vala"
	print_row_target = NULL;
#line 343 "../src/library.vala"
	print_row_target_destroy_notify = NULL;
#line 343 "../src/library.vala"
	block22_data_unref (_data22_);
#line 343 "../src/library.vala"
	_data22_ = NULL;
#line 3096 "library.c"
}

void
bookworm_app_library_updateGridViewForSelection (BookwormAppBook* lBook)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp57_;
	const gchar* _tmp58_;
	const gchar* _tmp114_;
	const gchar* _tmp115_;
#line 382 "../src/library.vala"
	g_debug ("library.vala:382: [START] [FUNCTION:updateGridViewForSelection]");
#line 383 "../src/library.vala"
	_tmp0_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 383 "../src/library.vala"
	_tmp1_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[0];
#line 383 "../src/library.vala"
	if (g_strcmp0 (_tmp0_, _tmp1_) == 0) {
#line 3116 "library.c"
		GeeHashMap* temp_libraryViewMap = NULL;
		GeeHashMap* _tmp2_;
#line 384 "../src/library.vala"
		g_debug ("library.vala:384: Updating Library View for Selection Badges BOOKWORM_" \
"UI_STATES[0]");
#line 385 "../src/library.vala"
		_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, BOOKWORM_APP_TYPE_BOOK, (GBoxedCopyFunc) bookworm_app_book_ref, (GDestroyNotify) bookworm_app_book_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 385 "../src/library.vala"
		temp_libraryViewMap = _tmp2_;
#line 3125 "library.c"
		{
			GeeIterator* _book_it = NULL;
			GeeHashMap* _tmp3_;
			GeeCollection* _tmp4_;
			GeeCollection* _tmp5_;
			GeeCollection* _tmp6_;
			GeeIterator* _tmp7_;
			GeeIterator* _tmp8_;
#line 387 "../src/library.vala"
			_tmp3_ = bookworm_app_bookworm_libraryViewMap;
#line 387 "../src/library.vala"
			_tmp4_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp3_);
#line 387 "../src/library.vala"
			_tmp5_ = _tmp4_;
#line 387 "../src/library.vala"
			_tmp6_ = _tmp5_;
#line 387 "../src/library.vala"
			_tmp7_ = gee_iterable_iterator ((GeeIterable*) _tmp6_);
#line 387 "../src/library.vala"
			_tmp8_ = _tmp7_;
#line 387 "../src/library.vala"
			_g_object_unref0 (_tmp6_);
#line 387 "../src/library.vala"
			_book_it = _tmp8_;
#line 387 "../src/library.vala"
			while (TRUE) {
#line 3152 "library.c"
				GeeIterator* _tmp9_;
				BookwormAppBook* book = NULL;
				GeeIterator* _tmp10_;
				gpointer _tmp11_;
				GtkScrolledWindow* _tmp12_;
				GeeHashMap* _tmp37_;
				BookwormAppBook* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				BookwormAppBook* _tmp41_;
#line 387 "../src/library.vala"
				_tmp9_ = _book_it;
#line 387 "../src/library.vala"
				if (!gee_iterator_next (_tmp9_)) {
#line 387 "../src/library.vala"
					break;
#line 3169 "library.c"
				}
#line 387 "../src/library.vala"
				_tmp10_ = _book_it;
#line 387 "../src/library.vala"
				_tmp11_ = gee_iterator_get (_tmp10_);
#line 387 "../src/library.vala"
				book = (BookwormAppBook*) _tmp11_;
#line 388 "../src/library.vala"
				_tmp12_ = bookworm_app_app_window_library_grid_scroll;
#line 388 "../src/library.vala"
				if (gtk_widget_get_visible ((GtkWidget*) _tmp12_)) {
#line 3181 "library.c"
					GtkOverlay* aOverlayImage = NULL;
					BookwormAppBook* _tmp13_;
					GtkWidget* _tmp14_;
					BookwormAppBook* _tmp15_;
					GtkWidget* _tmp16_;
					GtkWidget* _tmp17_;
					BookwormAppBook* _tmp18_;
					GtkWidget* _tmp19_;
					GtkWidget* _tmp20_;
					GtkOverlay* _tmp21_;
					BookwormAppBook* _tmp22_;
					GtkWidget* _tmp23_;
					GtkWidget* _tmp24_;
					GtkOverlay* _tmp25_;
					BookwormAppBook* _tmp26_;
					GtkWidget* _tmp27_;
					GtkWidget* _tmp28_;
					GtkOverlay* _tmp29_;
					BookwormAppBook* _tmp30_;
					GtkWidget* _tmp31_;
					GtkWidget* _tmp32_;
					GtkOverlay* _tmp33_;
					BookwormAppBook* _tmp34_;
					GtkWidget* _tmp35_;
					GtkWidget* _tmp36_;
#line 389 "../src/library.vala"
					_tmp13_ = book;
#line 389 "../src/library.vala"
					_tmp14_ = bookworm_app_book_getBookWidget (_tmp13_, "BOOK_OVERLAY_IMAGE");
#line 389 "../src/library.vala"
					aOverlayImage = G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_overlay_get_type (), GtkOverlay);
#line 391 "../src/library.vala"
					_tmp15_ = book;
#line 391 "../src/library.vala"
					_tmp16_ = bookworm_app_book_getBookWidget (_tmp15_, "SELECTION_BADGE_IMAGE");
#line 391 "../src/library.vala"
					_tmp17_ = _tmp16_;
#line 391 "../src/library.vala"
					gtk_widget_set_halign (_tmp17_, GTK_ALIGN_CENTER);
#line 391 "../src/library.vala"
					_g_object_unref0 (_tmp17_);
#line 392 "../src/library.vala"
					_tmp18_ = book;
#line 392 "../src/library.vala"
					_tmp19_ = bookworm_app_book_getBookWidget (_tmp18_, "SELECTED_BADGE_IMAGE");
#line 392 "../src/library.vala"
					_tmp20_ = _tmp19_;
#line 392 "../src/library.vala"
					gtk_widget_set_halign (_tmp20_, GTK_ALIGN_CENTER);
#line 392 "../src/library.vala"
					_g_object_unref0 (_tmp20_);
#line 394 "../src/library.vala"
					_tmp21_ = aOverlayImage;
#line 394 "../src/library.vala"
					_tmp22_ = book;
#line 394 "../src/library.vala"
					_tmp23_ = bookworm_app_book_getBookWidget (_tmp22_, "SELECTION_BADGE_IMAGE");
#line 394 "../src/library.vala"
					_tmp24_ = _tmp23_;
#line 394 "../src/library.vala"
					gtk_overlay_reorder_overlay (_tmp21_, _tmp24_, 1);
#line 394 "../src/library.vala"
					_g_object_unref0 (_tmp24_);
#line 395 "../src/library.vala"
					_tmp25_ = aOverlayImage;
#line 395 "../src/library.vala"
					_tmp26_ = book;
#line 395 "../src/library.vala"
					_tmp27_ = bookworm_app_book_getBookWidget (_tmp26_, "SELECTED_BADGE_IMAGE");
#line 395 "../src/library.vala"
					_tmp28_ = _tmp27_;
#line 395 "../src/library.vala"
					gtk_overlay_reorder_overlay (_tmp25_, _tmp28_, 2);
#line 395 "../src/library.vala"
					_g_object_unref0 (_tmp28_);
#line 396 "../src/library.vala"
					_tmp29_ = aOverlayImage;
#line 396 "../src/library.vala"
					_tmp30_ = book;
#line 396 "../src/library.vala"
					_tmp31_ = bookworm_app_book_getBookWidget (_tmp30_, "COVER_IMAGE");
#line 396 "../src/library.vala"
					_tmp32_ = _tmp31_;
#line 396 "../src/library.vala"
					gtk_overlay_reorder_overlay (_tmp29_, _tmp32_, 3);
#line 396 "../src/library.vala"
					_g_object_unref0 (_tmp32_);
#line 397 "../src/library.vala"
					_tmp33_ = aOverlayImage;
#line 397 "../src/library.vala"
					_tmp34_ = book;
#line 397 "../src/library.vala"
					_tmp35_ = bookworm_app_book_getBookWidget (_tmp34_, "TITLE_TEXT_LABEL");
#line 397 "../src/library.vala"
					_tmp36_ = _tmp35_;
#line 397 "../src/library.vala"
					gtk_overlay_reorder_overlay (_tmp33_, _tmp36_, 4);
#line 397 "../src/library.vala"
					_g_object_unref0 (_tmp36_);
#line 388 "../src/library.vala"
					_g_object_unref0 (aOverlayImage);
#line 3283 "library.c"
				}
#line 399 "../src/library.vala"
				_tmp37_ = temp_libraryViewMap;
#line 399 "../src/library.vala"
				_tmp38_ = book;
#line 399 "../src/library.vala"
				_tmp39_ = bookworm_app_book_getBookLocation (_tmp38_);
#line 399 "../src/library.vala"
				_tmp40_ = _tmp39_;
#line 399 "../src/library.vala"
				_tmp41_ = book;
#line 399 "../src/library.vala"
				gee_abstract_map_set ((GeeAbstractMap*) _tmp37_, _tmp40_, _tmp41_);
#line 399 "../src/library.vala"
				_g_free0 (_tmp40_);
#line 387 "../src/library.vala"
				_bookworm_app_book_unref0 (book);
#line 3301 "library.c"
			}
#line 387 "../src/library.vala"
			_g_object_unref0 (_book_it);
#line 3305 "library.c"
		}
		{
			GeeIterator* _aBook_it = NULL;
			GeeHashMap* _tmp42_;
			GeeCollection* _tmp43_;
			GeeCollection* _tmp44_;
			GeeCollection* _tmp45_;
			GeeIterator* _tmp46_;
			GeeIterator* _tmp47_;
#line 403 "../src/library.vala"
			_tmp42_ = temp_libraryViewMap;
#line 403 "../src/library.vala"
			_tmp43_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp42_);
#line 403 "../src/library.vala"
			_tmp44_ = _tmp43_;
#line 403 "../src/library.vala"
			_tmp45_ = _tmp44_;
#line 403 "../src/library.vala"
			_tmp46_ = gee_iterable_iterator ((GeeIterable*) _tmp45_);
#line 403 "../src/library.vala"
			_tmp47_ = _tmp46_;
#line 403 "../src/library.vala"
			_g_object_unref0 (_tmp45_);
#line 403 "../src/library.vala"
			_aBook_it = _tmp47_;
#line 403 "../src/library.vala"
			while (TRUE) {
#line 3333 "library.c"
				GeeIterator* _tmp48_;
				BookwormAppBook* aBook = NULL;
				GeeIterator* _tmp49_;
				gpointer _tmp50_;
				BookwormAppBook* _tmp51_;
				GeeHashMap* _tmp52_;
				BookwormAppBook* _tmp53_;
				gchar* _tmp54_;
				gchar* _tmp55_;
				BookwormAppBook* _tmp56_;
#line 403 "../src/library.vala"
				_tmp48_ = _aBook_it;
#line 403 "../src/library.vala"
				if (!gee_iterator_next (_tmp48_)) {
#line 403 "../src/library.vala"
					break;
#line 3350 "library.c"
				}
#line 403 "../src/library.vala"
				_tmp49_ = _aBook_it;
#line 403 "../src/library.vala"
				_tmp50_ = gee_iterator_get (_tmp49_);
#line 403 "../src/library.vala"
				aBook = (BookwormAppBook*) _tmp50_;
#line 404 "../src/library.vala"
				_tmp51_ = aBook;
#line 404 "../src/library.vala"
				bookworm_app_book_setIsBookSelected (_tmp51_, FALSE);
#line 405 "../src/library.vala"
				_tmp52_ = bookworm_app_bookworm_libraryViewMap;
#line 405 "../src/library.vala"
				_tmp53_ = aBook;
#line 405 "../src/library.vala"
				_tmp54_ = bookworm_app_book_getBookLocation (_tmp53_);
#line 405 "../src/library.vala"
				_tmp55_ = _tmp54_;
#line 405 "../src/library.vala"
				_tmp56_ = aBook;
#line 405 "../src/library.vala"
				gee_abstract_map_set ((GeeAbstractMap*) _tmp52_, _tmp55_, _tmp56_);
#line 405 "../src/library.vala"
				_g_free0 (_tmp55_);
#line 403 "../src/library.vala"
				_bookworm_app_book_unref0 (aBook);
#line 3378 "library.c"
			}
#line 403 "../src/library.vala"
			_g_object_unref0 (_aBook_it);
#line 3382 "library.c"
		}
#line 383 "../src/library.vala"
		_g_object_unref0 (temp_libraryViewMap);
#line 3386 "library.c"
	}
#line 408 "../src/library.vala"
	_tmp57_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 408 "../src/library.vala"
	_tmp58_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[2];
#line 408 "../src/library.vala"
	if (g_strcmp0 (_tmp57_, _tmp58_) == 0) {
#line 3394 "library.c"
		GeeHashMap* temp_libraryViewMap = NULL;
		GeeHashMap* _tmp59_;
#line 409 "../src/library.vala"
		g_debug ("library.vala:409: Updating Library View for Selection Badges BOOKWORM_" \
"UI_STATES[2]");
#line 410 "../src/library.vala"
		_tmp59_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, BOOKWORM_APP_TYPE_BOOK, (GBoxedCopyFunc) bookworm_app_book_ref, (GDestroyNotify) bookworm_app_book_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 410 "../src/library.vala"
		temp_libraryViewMap = _tmp59_;
#line 3403 "library.c"
		{
			GeeIterator* _book_it = NULL;
			GeeHashMap* _tmp60_;
			GeeCollection* _tmp61_;
			GeeCollection* _tmp62_;
			GeeCollection* _tmp63_;
			GeeIterator* _tmp64_;
			GeeIterator* _tmp65_;
#line 412 "../src/library.vala"
			_tmp60_ = bookworm_app_bookworm_libraryViewMap;
#line 412 "../src/library.vala"
			_tmp61_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp60_);
#line 412 "../src/library.vala"
			_tmp62_ = _tmp61_;
#line 412 "../src/library.vala"
			_tmp63_ = _tmp62_;
#line 412 "../src/library.vala"
			_tmp64_ = gee_iterable_iterator ((GeeIterable*) _tmp63_);
#line 412 "../src/library.vala"
			_tmp65_ = _tmp64_;
#line 412 "../src/library.vala"
			_g_object_unref0 (_tmp63_);
#line 412 "../src/library.vala"
			_book_it = _tmp65_;
#line 412 "../src/library.vala"
			while (TRUE) {
#line 3430 "library.c"
				GeeIterator* _tmp66_;
				BookwormAppBook* book = NULL;
				GeeIterator* _tmp67_;
				gpointer _tmp68_;
				GtkScrolledWindow* _tmp69_;
				GeeHashMap* _tmp94_;
				BookwormAppBook* _tmp95_;
				gchar* _tmp96_;
				gchar* _tmp97_;
				BookwormAppBook* _tmp98_;
#line 412 "../src/library.vala"
				_tmp66_ = _book_it;
#line 412 "../src/library.vala"
				if (!gee_iterator_next (_tmp66_)) {
#line 412 "../src/library.vala"
					break;
#line 3447 "library.c"
				}
#line 412 "../src/library.vala"
				_tmp67_ = _book_it;
#line 412 "../src/library.vala"
				_tmp68_ = gee_iterator_get (_tmp67_);
#line 412 "../src/library.vala"
				book = (BookwormAppBook*) _tmp68_;
#line 413 "../src/library.vala"
				_tmp69_ = bookworm_app_app_window_library_grid_scroll;
#line 413 "../src/library.vala"
				if (gtk_widget_get_visible ((GtkWidget*) _tmp69_)) {
#line 3459 "library.c"
					GtkOverlay* aOverlayImage = NULL;
					BookwormAppBook* _tmp70_;
					GtkWidget* _tmp71_;
					BookwormAppBook* _tmp72_;
					GtkWidget* _tmp73_;
					GtkWidget* _tmp74_;
					BookwormAppBook* _tmp75_;
					GtkWidget* _tmp76_;
					GtkWidget* _tmp77_;
					GtkOverlay* _tmp78_;
					BookwormAppBook* _tmp79_;
					GtkWidget* _tmp80_;
					GtkWidget* _tmp81_;
					GtkOverlay* _tmp82_;
					BookwormAppBook* _tmp83_;
					GtkWidget* _tmp84_;
					GtkWidget* _tmp85_;
					GtkOverlay* _tmp86_;
					BookwormAppBook* _tmp87_;
					GtkWidget* _tmp88_;
					GtkWidget* _tmp89_;
					GtkOverlay* _tmp90_;
					BookwormAppBook* _tmp91_;
					GtkWidget* _tmp92_;
					GtkWidget* _tmp93_;
#line 414 "../src/library.vala"
					_tmp70_ = book;
#line 414 "../src/library.vala"
					_tmp71_ = bookworm_app_book_getBookWidget (_tmp70_, "BOOK_OVERLAY_IMAGE");
#line 414 "../src/library.vala"
					aOverlayImage = G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, gtk_overlay_get_type (), GtkOverlay);
#line 416 "../src/library.vala"
					_tmp72_ = book;
#line 416 "../src/library.vala"
					_tmp73_ = bookworm_app_book_getBookWidget (_tmp72_, "SELECTION_BADGE_IMAGE");
#line 416 "../src/library.vala"
					_tmp74_ = _tmp73_;
#line 416 "../src/library.vala"
					gtk_widget_set_halign (_tmp74_, GTK_ALIGN_START);
#line 416 "../src/library.vala"
					_g_object_unref0 (_tmp74_);
#line 417 "../src/library.vala"
					_tmp75_ = book;
#line 417 "../src/library.vala"
					_tmp76_ = bookworm_app_book_getBookWidget (_tmp75_, "SELECTED_BADGE_IMAGE");
#line 417 "../src/library.vala"
					_tmp77_ = _tmp76_;
#line 417 "../src/library.vala"
					gtk_widget_set_halign (_tmp77_, GTK_ALIGN_CENTER);
#line 417 "../src/library.vala"
					_g_object_unref0 (_tmp77_);
#line 419 "../src/library.vala"
					_tmp78_ = aOverlayImage;
#line 419 "../src/library.vala"
					_tmp79_ = book;
#line 419 "../src/library.vala"
					_tmp80_ = bookworm_app_book_getBookWidget (_tmp79_, "SELECTED_BADGE_IMAGE");
#line 419 "../src/library.vala"
					_tmp81_ = _tmp80_;
#line 419 "../src/library.vala"
					gtk_overlay_reorder_overlay (_tmp78_, _tmp81_, 1);
#line 419 "../src/library.vala"
					_g_object_unref0 (_tmp81_);
#line 420 "../src/library.vala"
					_tmp82_ = aOverlayImage;
#line 420 "../src/library.vala"
					_tmp83_ = book;
#line 420 "../src/library.vala"
					_tmp84_ = bookworm_app_book_getBookWidget (_tmp83_, "COVER_IMAGE");
#line 420 "../src/library.vala"
					_tmp85_ = _tmp84_;
#line 420 "../src/library.vala"
					gtk_overlay_reorder_overlay (_tmp82_, _tmp85_, 2);
#line 420 "../src/library.vala"
					_g_object_unref0 (_tmp85_);
#line 421 "../src/library.vala"
					_tmp86_ = aOverlayImage;
#line 421 "../src/library.vala"
					_tmp87_ = book;
#line 421 "../src/library.vala"
					_tmp88_ = bookworm_app_book_getBookWidget (_tmp87_, "TITLE_TEXT_LABEL");
#line 421 "../src/library.vala"
					_tmp89_ = _tmp88_;
#line 421 "../src/library.vala"
					gtk_overlay_reorder_overlay (_tmp86_, _tmp89_, 3);
#line 421 "../src/library.vala"
					_g_object_unref0 (_tmp89_);
#line 422 "../src/library.vala"
					_tmp90_ = aOverlayImage;
#line 422 "../src/library.vala"
					_tmp91_ = book;
#line 422 "../src/library.vala"
					_tmp92_ = bookworm_app_book_getBookWidget (_tmp91_, "SELECTION_BADGE_IMAGE");
#line 422 "../src/library.vala"
					_tmp93_ = _tmp92_;
#line 422 "../src/library.vala"
					gtk_overlay_reorder_overlay (_tmp90_, _tmp93_, 4);
#line 422 "../src/library.vala"
					_g_object_unref0 (_tmp93_);
#line 413 "../src/library.vala"
					_g_object_unref0 (aOverlayImage);
#line 3561 "library.c"
				}
#line 424 "../src/library.vala"
				_tmp94_ = temp_libraryViewMap;
#line 424 "../src/library.vala"
				_tmp95_ = book;
#line 424 "../src/library.vala"
				_tmp96_ = bookworm_app_book_getBookLocation (_tmp95_);
#line 424 "../src/library.vala"
				_tmp97_ = _tmp96_;
#line 424 "../src/library.vala"
				_tmp98_ = book;
#line 424 "../src/library.vala"
				gee_abstract_map_set ((GeeAbstractMap*) _tmp94_, _tmp97_, _tmp98_);
#line 424 "../src/library.vala"
				_g_free0 (_tmp97_);
#line 412 "../src/library.vala"
				_bookworm_app_book_unref0 (book);
#line 3579 "library.c"
			}
#line 412 "../src/library.vala"
			_g_object_unref0 (_book_it);
#line 3583 "library.c"
		}
		{
			GeeIterator* _aBook_it = NULL;
			GeeHashMap* _tmp99_;
			GeeCollection* _tmp100_;
			GeeCollection* _tmp101_;
			GeeCollection* _tmp102_;
			GeeIterator* _tmp103_;
			GeeIterator* _tmp104_;
#line 428 "../src/library.vala"
			_tmp99_ = temp_libraryViewMap;
#line 428 "../src/library.vala"
			_tmp100_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp99_);
#line 428 "../src/library.vala"
			_tmp101_ = _tmp100_;
#line 428 "../src/library.vala"
			_tmp102_ = _tmp101_;
#line 428 "../src/library.vala"
			_tmp103_ = gee_iterable_iterator ((GeeIterable*) _tmp102_);
#line 428 "../src/library.vala"
			_tmp104_ = _tmp103_;
#line 428 "../src/library.vala"
			_g_object_unref0 (_tmp102_);
#line 428 "../src/library.vala"
			_aBook_it = _tmp104_;
#line 428 "../src/library.vala"
			while (TRUE) {
#line 3611 "library.c"
				GeeIterator* _tmp105_;
				BookwormAppBook* aBook = NULL;
				GeeIterator* _tmp106_;
				gpointer _tmp107_;
				BookwormAppBook* _tmp108_;
				GeeHashMap* _tmp109_;
				BookwormAppBook* _tmp110_;
				gchar* _tmp111_;
				gchar* _tmp112_;
				BookwormAppBook* _tmp113_;
#line 428 "../src/library.vala"
				_tmp105_ = _aBook_it;
#line 428 "../src/library.vala"
				if (!gee_iterator_next (_tmp105_)) {
#line 428 "../src/library.vala"
					break;
#line 3628 "library.c"
				}
#line 428 "../src/library.vala"
				_tmp106_ = _aBook_it;
#line 428 "../src/library.vala"
				_tmp107_ = gee_iterator_get (_tmp106_);
#line 428 "../src/library.vala"
				aBook = (BookwormAppBook*) _tmp107_;
#line 429 "../src/library.vala"
				_tmp108_ = aBook;
#line 429 "../src/library.vala"
				bookworm_app_book_setIsBookSelected (_tmp108_, FALSE);
#line 430 "../src/library.vala"
				_tmp109_ = bookworm_app_bookworm_libraryViewMap;
#line 430 "../src/library.vala"
				_tmp110_ = aBook;
#line 430 "../src/library.vala"
				_tmp111_ = bookworm_app_book_getBookLocation (_tmp110_);
#line 430 "../src/library.vala"
				_tmp112_ = _tmp111_;
#line 430 "../src/library.vala"
				_tmp113_ = aBook;
#line 430 "../src/library.vala"
				gee_abstract_map_set ((GeeAbstractMap*) _tmp109_, _tmp112_, _tmp113_);
#line 430 "../src/library.vala"
				_g_free0 (_tmp112_);
#line 428 "../src/library.vala"
				_bookworm_app_book_unref0 (aBook);
#line 3656 "library.c"
			}
#line 428 "../src/library.vala"
			_g_object_unref0 (_aBook_it);
#line 3660 "library.c"
		}
#line 408 "../src/library.vala"
		_g_object_unref0 (temp_libraryViewMap);
#line 3664 "library.c"
	}
#line 433 "../src/library.vala"
	_tmp114_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 433 "../src/library.vala"
	_tmp115_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[3];
#line 433 "../src/library.vala"
	if (g_strcmp0 (_tmp114_, _tmp115_) == 0) {
#line 434 "../src/library.vala"
		g_debug ("library.vala:434: Updating Library View for Selection Badges BOOKWORM_" \
"UI_STATES[3]");
#line 435 "../src/library.vala"
		if (lBook != NULL) {
#line 3676 "library.c"
			GtkScrolledWindow* _tmp116_;
			GeeHashMap* _tmp150_;
			gchar* _tmp151_;
			gchar* _tmp152_;
#line 436 "../src/library.vala"
			_tmp116_ = bookworm_app_app_window_library_grid_scroll;
#line 436 "../src/library.vala"
			if (gtk_widget_get_visible ((GtkWidget*) _tmp116_)) {
#line 3685 "library.c"
				GtkOverlay* aOverlayImage = NULL;
				GtkWidget* _tmp117_;
#line 437 "../src/library.vala"
				_tmp117_ = bookworm_app_book_getBookWidget (lBook, "BOOK_OVERLAY_IMAGE");
#line 437 "../src/library.vala"
				aOverlayImage = G_TYPE_CHECK_INSTANCE_CAST (_tmp117_, gtk_overlay_get_type (), GtkOverlay);
#line 438 "../src/library.vala"
				if (!bookworm_app_book_getIsBookSelected (lBook)) {
#line 3694 "library.c"
					GtkWidget* _tmp118_;
					GtkWidget* _tmp119_;
					GtkWidget* _tmp120_;
					GtkWidget* _tmp121_;
					GtkOverlay* _tmp122_;
					GtkWidget* _tmp123_;
					GtkWidget* _tmp124_;
					GtkOverlay* _tmp125_;
					GtkWidget* _tmp126_;
					GtkWidget* _tmp127_;
					GtkOverlay* _tmp128_;
					GtkWidget* _tmp129_;
					GtkWidget* _tmp130_;
					GtkOverlay* _tmp131_;
					GtkWidget* _tmp132_;
					GtkWidget* _tmp133_;
#line 440 "../src/library.vala"
					_tmp118_ = bookworm_app_book_getBookWidget (lBook, "SELECTED_BADGE_IMAGE");
#line 440 "../src/library.vala"
					_tmp119_ = _tmp118_;
#line 440 "../src/library.vala"
					gtk_widget_set_halign (_tmp119_, GTK_ALIGN_START);
#line 440 "../src/library.vala"
					_g_object_unref0 (_tmp119_);
#line 441 "../src/library.vala"
					_tmp120_ = bookworm_app_book_getBookWidget (lBook, "SELECTION_BADGE_IMAGE");
#line 441 "../src/library.vala"
					_tmp121_ = _tmp120_;
#line 441 "../src/library.vala"
					gtk_widget_set_halign (_tmp121_, GTK_ALIGN_CENTER);
#line 441 "../src/library.vala"
					_g_object_unref0 (_tmp121_);
#line 443 "../src/library.vala"
					_tmp122_ = aOverlayImage;
#line 443 "../src/library.vala"
					_tmp123_ = bookworm_app_book_getBookWidget (lBook, "SELECTION_BADGE_IMAGE");
#line 443 "../src/library.vala"
					_tmp124_ = _tmp123_;
#line 443 "../src/library.vala"
					gtk_overlay_reorder_overlay (_tmp122_, _tmp124_, 1);
#line 443 "../src/library.vala"
					_g_object_unref0 (_tmp124_);
#line 444 "../src/library.vala"
					_tmp125_ = aOverlayImage;
#line 444 "../src/library.vala"
					_tmp126_ = bookworm_app_book_getBookWidget (lBook, "COVER_IMAGE");
#line 444 "../src/library.vala"
					_tmp127_ = _tmp126_;
#line 444 "../src/library.vala"
					gtk_overlay_reorder_overlay (_tmp125_, _tmp127_, 2);
#line 444 "../src/library.vala"
					_g_object_unref0 (_tmp127_);
#line 445 "../src/library.vala"
					_tmp128_ = aOverlayImage;
#line 445 "../src/library.vala"
					_tmp129_ = bookworm_app_book_getBookWidget (lBook, "TITLE_TEXT_LABEL");
#line 445 "../src/library.vala"
					_tmp130_ = _tmp129_;
#line 445 "../src/library.vala"
					gtk_overlay_reorder_overlay (_tmp128_, _tmp130_, 3);
#line 445 "../src/library.vala"
					_g_object_unref0 (_tmp130_);
#line 446 "../src/library.vala"
					_tmp131_ = aOverlayImage;
#line 446 "../src/library.vala"
					_tmp132_ = bookworm_app_book_getBookWidget (lBook, "SELECTED_BADGE_IMAGE");
#line 446 "../src/library.vala"
					_tmp133_ = _tmp132_;
#line 446 "../src/library.vala"
					gtk_overlay_reorder_overlay (_tmp131_, _tmp133_, 4);
#line 446 "../src/library.vala"
					_g_object_unref0 (_tmp133_);
#line 447 "../src/library.vala"
					bookworm_app_book_setIsBookSelected (lBook, TRUE);
#line 448 "../src/library.vala"
					bookworm_app_app_window_controlDeletionButton (TRUE);
#line 3771 "library.c"
				} else {
					GtkWidget* _tmp134_;
					GtkWidget* _tmp135_;
					GtkWidget* _tmp136_;
					GtkWidget* _tmp137_;
					GtkOverlay* _tmp138_;
					GtkWidget* _tmp139_;
					GtkWidget* _tmp140_;
					GtkOverlay* _tmp141_;
					GtkWidget* _tmp142_;
					GtkWidget* _tmp143_;
					GtkOverlay* _tmp144_;
					GtkWidget* _tmp145_;
					GtkWidget* _tmp146_;
					GtkOverlay* _tmp147_;
					GtkWidget* _tmp148_;
					GtkWidget* _tmp149_;
#line 452 "../src/library.vala"
					_tmp134_ = bookworm_app_book_getBookWidget (lBook, "SELECTION_BADGE_IMAGE");
#line 452 "../src/library.vala"
					_tmp135_ = _tmp134_;
#line 452 "../src/library.vala"
					gtk_widget_set_halign (_tmp135_, GTK_ALIGN_START);
#line 452 "../src/library.vala"
					_g_object_unref0 (_tmp135_);
#line 453 "../src/library.vala"
					_tmp136_ = bookworm_app_book_getBookWidget (lBook, "SELECTED_BADGE_IMAGE");
#line 453 "../src/library.vala"
					_tmp137_ = _tmp136_;
#line 453 "../src/library.vala"
					gtk_widget_set_halign (_tmp137_, GTK_ALIGN_CENTER);
#line 453 "../src/library.vala"
					_g_object_unref0 (_tmp137_);
#line 454 "../src/library.vala"
					_tmp138_ = aOverlayImage;
#line 454 "../src/library.vala"
					_tmp139_ = bookworm_app_book_getBookWidget (lBook, "SELECTED_BADGE_IMAGE");
#line 454 "../src/library.vala"
					_tmp140_ = _tmp139_;
#line 454 "../src/library.vala"
					gtk_overlay_reorder_overlay (_tmp138_, _tmp140_, 1);
#line 454 "../src/library.vala"
					_g_object_unref0 (_tmp140_);
#line 455 "../src/library.vala"
					_tmp141_ = aOverlayImage;
#line 455 "../src/library.vala"
					_tmp142_ = bookworm_app_book_getBookWidget (lBook, "COVER_IMAGE");
#line 455 "../src/library.vala"
					_tmp143_ = _tmp142_;
#line 455 "../src/library.vala"
					gtk_overlay_reorder_overlay (_tmp141_, _tmp143_, 2);
#line 455 "../src/library.vala"
					_g_object_unref0 (_tmp143_);
#line 456 "../src/library.vala"
					_tmp144_ = aOverlayImage;
#line 456 "../src/library.vala"
					_tmp145_ = bookworm_app_book_getBookWidget (lBook, "TITLE_TEXT_LABEL");
#line 456 "../src/library.vala"
					_tmp146_ = _tmp145_;
#line 456 "../src/library.vala"
					gtk_overlay_reorder_overlay (_tmp144_, _tmp146_, 3);
#line 456 "../src/library.vala"
					_g_object_unref0 (_tmp146_);
#line 457 "../src/library.vala"
					_tmp147_ = aOverlayImage;
#line 457 "../src/library.vala"
					_tmp148_ = bookworm_app_book_getBookWidget (lBook, "SELECTION_BADGE_IMAGE");
#line 457 "../src/library.vala"
					_tmp149_ = _tmp148_;
#line 457 "../src/library.vala"
					gtk_overlay_reorder_overlay (_tmp147_, _tmp149_, 4);
#line 457 "../src/library.vala"
					_g_object_unref0 (_tmp149_);
#line 458 "../src/library.vala"
					bookworm_app_book_setIsBookSelected (lBook, FALSE);
#line 459 "../src/library.vala"
					bookworm_app_app_window_controlDeletionButton (FALSE);
#line 3849 "library.c"
				}
#line 436 "../src/library.vala"
				_g_object_unref0 (aOverlayImage);
#line 3853 "library.c"
			}
#line 463 "../src/library.vala"
			_tmp150_ = bookworm_app_bookworm_libraryViewMap;
#line 463 "../src/library.vala"
			_tmp151_ = bookworm_app_book_getBookLocation (lBook);
#line 463 "../src/library.vala"
			_tmp152_ = _tmp151_;
#line 463 "../src/library.vala"
			gee_abstract_map_set ((GeeAbstractMap*) _tmp150_, _tmp152_, lBook);
#line 463 "../src/library.vala"
			_g_free0 (_tmp152_);
#line 3865 "library.c"
		}
	}
#line 466 "../src/library.vala"
	g_debug ("library.vala:466: [END] [FUNCTION:updateGridViewForSelection]");
#line 381 "../src/library.vala"
	_bookworm_app_book_unref0 (lBook);
#line 3872 "library.c"
}

static Block23Data*
block23_data_ref (Block23Data* _data23_)
{
#line 469 "../src/library.vala"
	g_atomic_int_inc (&_data23_->_ref_count_);
#line 469 "../src/library.vala"
	return _data23_;
#line 3882 "library.c"
}

static void
block23_data_unref (void * _userdata_)
{
	Block23Data* _data23_;
	_data23_ = (Block23Data*) _userdata_;
#line 469 "../src/library.vala"
	if (g_atomic_int_dec_and_test (&_data23_->_ref_count_)) {
#line 469 "../src/library.vala"
		_g_object_unref0 (_data23_->listOfBooksToBeRemoved);
#line 469 "../src/library.vala"
		g_slice_free (Block23Data, _data23_);
#line 3896 "library.c"
	}
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
#line 1184 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1184 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 1185 "glib-2.0.vapi"
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
#line 1185 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1187 "glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1187 "glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 3921 "library.c"
		gchar* _tmp2_;
#line 1188 "glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1188 "glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1188 "glib-2.0.vapi"
		return result;
#line 3929 "library.c"
	} else {
#line 1190 "glib-2.0.vapi"
		result = -1;
#line 1190 "glib-2.0.vapi"
		return result;
#line 3935 "library.c"
	}
}

static Block24Data*
block24_data_ref (Block24Data* _data24_)
{
#line 498 "../src/library.vala"
	g_atomic_int_inc (&_data24_->_ref_count_);
#line 498 "../src/library.vala"
	return _data24_;
#line 3946 "library.c"
}

static void
block24_data_unref (void * _userdata_)
{
	Block24Data* _data24_;
	_data24_ = (Block24Data*) _userdata_;
#line 498 "../src/library.vala"
	if (g_atomic_int_dec_and_test (&_data24_->_ref_count_)) {
#line 498 "../src/library.vala"
		_g_object_unref0 (_data24_->listOfItersToBeRemoved);
#line 498 "../src/library.vala"
		block23_data_unref (_data24_->_data23_);
#line 498 "../src/library.vala"
		_data24_->_data23_ = NULL;
#line 498 "../src/library.vala"
		g_slice_free (Block24Data, _data24_);
#line 3964 "library.c"
	}
}

static GtkTreeIter*
_vala_GtkTreeIter_copy (GtkTreeIter* self)
{
#line 500 "../src/library.vala"
	return g_boxed_copy (gtk_tree_iter_get_type (), self);
#line 3973 "library.c"
}

static void
_vala_GtkTreeIter_free (GtkTreeIter* self)
{
#line 500 "../src/library.vala"
	g_boxed_free (gtk_tree_iter_get_type (), self);
#line 3981 "library.c"
}

static gboolean
___lambda39_ (Block24Data* _data24_,
              GtkTreeModel* model,
              GtkTreePath* path,
              GtkTreeIter* iter)
{
	Block23Data* _data23_;
	GValue bookLocationAtRow = {0};
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_;
	GValue _tmp2_ = {0};
	GeeArrayList* _tmp3_;
	GValue _tmp4_;
	gboolean result;
#line 501 "../src/library.vala"
	_data23_ = _data24_->_data23_;
#line 501 "../src/library.vala"
	g_return_val_if_fail (model != NULL, FALSE);
#line 501 "../src/library.vala"
	g_return_val_if_fail (path != NULL, FALSE);
#line 501 "../src/library.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 503 "../src/library.vala"
	_tmp0_ = bookworm_app_app_window_library_table_liststore;
#line 503 "../src/library.vala"
	_tmp1_ = *iter;
#line 503 "../src/library.vala"
	gtk_tree_model_get_value ((GtkTreeModel*) _tmp0_, &_tmp1_, 7, &_tmp2_);
#line 503 "../src/library.vala"
	G_IS_VALUE (&bookLocationAtRow) ? (g_value_unset (&bookLocationAtRow), NULL) : NULL;
#line 503 "../src/library.vala"
	bookLocationAtRow = _tmp2_;
#line 504 "../src/library.vala"
	_tmp3_ = _data23_->listOfBooksToBeRemoved;
#line 504 "../src/library.vala"
	_tmp4_ = bookLocationAtRow;
#line 504 "../src/library.vala"
	if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp3_, g_value_get_string (&_tmp4_))) {
#line 4022 "library.c"
		GeeArrayList* _tmp5_;
		GtkTreeIter _tmp6_;
#line 505 "../src/library.vala"
		_tmp5_ = _data24_->listOfItersToBeRemoved;
#line 505 "../src/library.vala"
		_tmp6_ = *iter;
#line 505 "../src/library.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, &_tmp6_);
#line 4031 "library.c"
	}
#line 507 "../src/library.vala"
	result = FALSE;
#line 507 "../src/library.vala"
	G_IS_VALUE (&bookLocationAtRow) ? (g_value_unset (&bookLocationAtRow), NULL) : NULL;
#line 507 "../src/library.vala"
	return result;
#line 4039 "library.c"
}

static gboolean
____lambda39__gtk_tree_model_foreach_func (GtkTreeModel* model,
                                           GtkTreePath* path,
                                           GtkTreeIter* iter,
                                           gpointer self)
{
	gboolean result;
	result = ___lambda39_ (self, model, path, iter);
#line 501 "../src/library.vala"
	return result;
#line 4052 "library.c"
}

void
bookworm_app_library_removeSelectedBooksFromLibrary (void)
{
	Block23Data* _data23_;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp45_;
	gint _tmp46_;
	gint _tmp47_;
	gboolean _tmp76_ = FALSE;
	gboolean _tmp77_ = FALSE;
	const gchar* _tmp78_;
	const gchar* _tmp79_;
	gboolean _tmp86_ = FALSE;
	gboolean _tmp87_ = FALSE;
	const gchar* _tmp88_;
	const gchar* _tmp89_;
#line 469 "../src/library.vala"
	_data23_ = g_slice_new0 (Block23Data);
#line 469 "../src/library.vala"
	_data23_->_ref_count_ = 1;
#line 470 "../src/library.vala"
	g_debug ("library.vala:470: [START] [FUNCTION:removeSelectedBooksFromLibrary]");
#line 471 "../src/library.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 471 "../src/library.vala"
	_data23_->listOfBooksToBeRemoved = _tmp0_;
#line 4081 "library.c"
	{
		GeeIterator* _book_it = NULL;
		GeeHashMap* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
#line 473 "../src/library.vala"
		_tmp1_ = bookworm_app_bookworm_libraryViewMap;
#line 473 "../src/library.vala"
		_tmp2_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp1_);
#line 473 "../src/library.vala"
		_tmp3_ = _tmp2_;
#line 473 "../src/library.vala"
		_tmp4_ = _tmp3_;
#line 473 "../src/library.vala"
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
#line 473 "../src/library.vala"
		_tmp6_ = _tmp5_;
#line 473 "../src/library.vala"
		_g_object_unref0 (_tmp4_);
#line 473 "../src/library.vala"
		_book_it = _tmp6_;
#line 473 "../src/library.vala"
		while (TRUE) {
#line 4108 "library.c"
			GeeIterator* _tmp7_;
			BookwormAppBook* book = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			BookwormAppBook* _tmp10_;
#line 473 "../src/library.vala"
			_tmp7_ = _book_it;
#line 473 "../src/library.vala"
			if (!gee_iterator_next (_tmp7_)) {
#line 473 "../src/library.vala"
				break;
#line 4120 "library.c"
			}
#line 473 "../src/library.vala"
			_tmp8_ = _book_it;
#line 473 "../src/library.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 473 "../src/library.vala"
			book = (BookwormAppBook*) _tmp9_;
#line 475 "../src/library.vala"
			_tmp10_ = book;
#line 475 "../src/library.vala"
			if (bookworm_app_book_getIsBookSelected (_tmp10_)) {
#line 4132 "library.c"
				GeeArrayList* _tmp11_;
				BookwormAppBook* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				GtkEventBox* lEventBox = NULL;
				BookwormAppBook* _tmp15_;
				GtkWidget* _tmp16_;
				GtkEventBox* _tmp17_;
				GtkContainer* _tmp18_;
				GtkEventBox* _tmp19_;
				BookwormAppBook* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				gboolean _tmp25_;
				GString* _tmp35_;
				GString* _tmp36_;
				const gchar* _tmp37_;
				BookwormAppBook* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				GeeArrayList* _tmp43_;
				BookwormAppBook* _tmp44_;
#line 477 "../src/library.vala"
				_tmp11_ = _data23_->listOfBooksToBeRemoved;
#line 477 "../src/library.vala"
				_tmp12_ = book;
#line 477 "../src/library.vala"
				_tmp13_ = bookworm_app_book_getBookLocation (_tmp12_);
#line 477 "../src/library.vala"
				_tmp14_ = _tmp13_;
#line 477 "../src/library.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp14_);
#line 477 "../src/library.vala"
				_g_free0 (_tmp14_);
#line 478 "../src/library.vala"
				_tmp15_ = book;
#line 478 "../src/library.vala"
				_tmp16_ = bookworm_app_book_getBookWidget (_tmp15_, "BOOK_EVENTBOX");
#line 478 "../src/library.vala"
				lEventBox = G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_event_box_get_type (), GtkEventBox);
#line 480 "../src/library.vala"
				_tmp17_ = lEventBox;
#line 480 "../src/library.vala"
				_tmp18_ = gtk_widget_get_parent ((GtkWidget*) _tmp17_);
#line 480 "../src/library.vala"
				gtk_widget_destroy ((GtkWidget*) _tmp18_);
#line 482 "../src/library.vala"
				_tmp19_ = lEventBox;
#line 482 "../src/library.vala"
				gtk_widget_destroy ((GtkWidget*) _tmp19_);
#line 484 "../src/library.vala"
				_tmp20_ = book;
#line 484 "../src/library.vala"
				_tmp21_ = bookworm_app_book_getBookCoverLocation (_tmp20_);
#line 484 "../src/library.vala"
				_tmp22_ = _tmp21_;
#line 484 "../src/library.vala"
				_tmp23_ = string_replace (BOOKWORM_APP_CONSTANTS_DEFAULT_COVER_IMAGE_LOCATION, "-cover-N.svg", "");
#line 484 "../src/library.vala"
				_tmp24_ = _tmp23_;
#line 484 "../src/library.vala"
				_tmp25_ = string_index_of (_tmp22_, _tmp24_, 0) == -1;
#line 484 "../src/library.vala"
				_g_free0 (_tmp24_);
#line 484 "../src/library.vala"
				_g_free0 (_tmp22_);
#line 484 "../src/library.vala"
				if (_tmp25_) {
#line 4205 "library.c"
					BookwormAppBook* _tmp26_;
					gchar* _tmp27_;
					gchar* _tmp28_;
					gchar* _tmp29_;
					gchar* _tmp30_;
					gchar* _tmp31_;
					gchar* _tmp32_;
					gchar* _tmp33_;
					gchar* _tmp34_;
#line 487 "../src/library.vala"
					_tmp26_ = book;
#line 487 "../src/library.vala"
					_tmp27_ = bookworm_app_book_getBookCoverLocation (_tmp26_);
#line 487 "../src/library.vala"
					_tmp28_ = _tmp27_;
#line 487 "../src/library.vala"
					_tmp29_ = g_strconcat ("rm \"", _tmp28_, NULL);
#line 487 "../src/library.vala"
					_tmp30_ = _tmp29_;
#line 487 "../src/library.vala"
					_tmp31_ = g_strconcat (_tmp30_, "\"", NULL);
#line 487 "../src/library.vala"
					_tmp32_ = _tmp31_;
#line 487 "../src/library.vala"
					_tmp33_ = bookworm_app_utils_execute_sync_command (_tmp32_);
#line 487 "../src/library.vala"
					_tmp34_ = _tmp33_;
#line 487 "../src/library.vala"
					_g_free0 (_tmp34_);
#line 487 "../src/library.vala"
					_g_free0 (_tmp32_);
#line 487 "../src/library.vala"
					_g_free0 (_tmp30_);
#line 487 "../src/library.vala"
					_g_free0 (_tmp28_);
#line 4241 "library.c"
				}
#line 490 "../src/library.vala"
				_tmp35_ = bookworm_app_bookworm_pathsOfBooksInLibraryOnLoadStr;
#line 490 "../src/library.vala"
				_tmp36_ = bookworm_app_bookworm_pathsOfBooksInLibraryOnLoadStr;
#line 490 "../src/library.vala"
				_tmp37_ = _tmp36_->str;
#line 490 "../src/library.vala"
				_tmp38_ = book;
#line 490 "../src/library.vala"
				_tmp39_ = bookworm_app_book_getBookLocation (_tmp38_);
#line 490 "../src/library.vala"
				_tmp40_ = _tmp39_;
#line 490 "../src/library.vala"
				_tmp41_ = string_replace (_tmp37_, _tmp40_, "");
#line 490 "../src/library.vala"
				_tmp42_ = _tmp41_;
#line 490 "../src/library.vala"
				g_string_assign (_tmp35_, _tmp42_);
#line 490 "../src/library.vala"
				_g_free0 (_tmp42_);
#line 490 "../src/library.vala"
				_g_free0 (_tmp40_);
#line 494 "../src/library.vala"
				_tmp43_ = bookworm_app_library_listOfBooksInLibraryOnLoad;
#line 494 "../src/library.vala"
				_tmp44_ = book;
#line 494 "../src/library.vala"
				gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp43_, _tmp44_);
#line 475 "../src/library.vala"
				_g_object_unref0 (lEventBox);
#line 4273 "library.c"
			}
#line 473 "../src/library.vala"
			_bookworm_app_book_unref0 (book);
#line 4277 "library.c"
		}
#line 473 "../src/library.vala"
		_g_object_unref0 (_book_it);
#line 4281 "library.c"
	}
#line 498 "../src/library.vala"
	_tmp45_ = _data23_->listOfBooksToBeRemoved;
#line 498 "../src/library.vala"
	_tmp46_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp45_);
#line 498 "../src/library.vala"
	_tmp47_ = _tmp46_;
#line 498 "../src/library.vala"
	if (_tmp47_ > 0) {
#line 4291 "library.c"
		Block24Data* _data24_;
		GeeArrayList* _tmp48_;
		GtkTreeModelForeachFunc print_row = NULL;
		gpointer print_row_target;
		GDestroyNotify print_row_target_destroy_notify;
		GtkListStore* _tmp49_;
		GtkTreeModelForeachFunc _tmp50_;
		gpointer _tmp50__target;
#line 498 "../src/library.vala"
		_data24_ = g_slice_new0 (Block24Data);
#line 498 "../src/library.vala"
		_data24_->_ref_count_ = 1;
#line 498 "../src/library.vala"
		_data24_->_data23_ = block23_data_ref (_data23_);
#line 500 "../src/library.vala"
		_tmp48_ = gee_array_list_new (gtk_tree_iter_get_type (), (GBoxedCopyFunc) _vala_GtkTreeIter_copy, (GDestroyNotify) _vala_GtkTreeIter_free, NULL, NULL, NULL);
#line 500 "../src/library.vala"
		_data24_->listOfItersToBeRemoved = _tmp48_;
#line 501 "../src/library.vala"
		print_row = ____lambda39__gtk_tree_model_foreach_func;
#line 501 "../src/library.vala"
		print_row_target = block24_data_ref (_data24_);
#line 501 "../src/library.vala"
		print_row_target_destroy_notify = block24_data_unref;
#line 509 "../src/library.vala"
		_tmp49_ = bookworm_app_app_window_library_table_liststore;
#line 509 "../src/library.vala"
		_tmp50_ = print_row;
#line 509 "../src/library.vala"
		_tmp50__target = print_row_target;
#line 509 "../src/library.vala"
		gtk_tree_model_foreach ((GtkTreeModel*) _tmp49_, _tmp50_, _tmp50__target);
#line 4324 "library.c"
		{
			GeeArrayList* _iterToBeRemoved_list = NULL;
			GeeArrayList* _tmp51_;
			gint _iterToBeRemoved_size = 0;
			GeeArrayList* _tmp52_;
			gint _tmp53_;
			gint _tmp54_;
			gint _iterToBeRemoved_index = 0;
#line 510 "../src/library.vala"
			_tmp51_ = _data24_->listOfItersToBeRemoved;
#line 510 "../src/library.vala"
			_iterToBeRemoved_list = _tmp51_;
#line 510 "../src/library.vala"
			_tmp52_ = _iterToBeRemoved_list;
#line 510 "../src/library.vala"
			_tmp53_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp52_);
#line 510 "../src/library.vala"
			_tmp54_ = _tmp53_;
#line 510 "../src/library.vala"
			_iterToBeRemoved_size = _tmp54_;
#line 510 "../src/library.vala"
			_iterToBeRemoved_index = -1;
#line 510 "../src/library.vala"
			while (TRUE) {
#line 4349 "library.c"
				gint _tmp55_;
				gint _tmp56_;
				GtkTreeIter iterToBeRemoved = {0};
				GeeArrayList* _tmp57_;
				gpointer _tmp58_;
				GtkTreeIter* _tmp59_;
				GtkTreeIter _tmp60_;
				GtkListStore* _tmp61_;
#line 510 "../src/library.vala"
				_iterToBeRemoved_index = _iterToBeRemoved_index + 1;
#line 510 "../src/library.vala"
				_tmp55_ = _iterToBeRemoved_index;
#line 510 "../src/library.vala"
				_tmp56_ = _iterToBeRemoved_size;
#line 510 "../src/library.vala"
				if (!(_tmp55_ < _tmp56_)) {
#line 510 "../src/library.vala"
					break;
#line 4368 "library.c"
				}
#line 510 "../src/library.vala"
				_tmp57_ = _iterToBeRemoved_list;
#line 510 "../src/library.vala"
				_tmp58_ = gee_abstract_list_get ((GeeAbstractList*) _tmp57_, _iterToBeRemoved_index);
#line 510 "../src/library.vala"
				_tmp59_ = (GtkTreeIter*) _tmp58_;
#line 510 "../src/library.vala"
				_tmp60_ = *_tmp59_;
#line 510 "../src/library.vala"
				__vala_GtkTreeIter_free0 (_tmp59_);
#line 510 "../src/library.vala"
				iterToBeRemoved = _tmp60_;
#line 513 "../src/library.vala"
				_tmp61_ = bookworm_app_app_window_library_table_liststore;
#line 513 "../src/library.vala"
				gtk_list_store_remove (_tmp61_, &iterToBeRemoved);
#line 4386 "library.c"
			}
		}
#line 498 "../src/library.vala"
		(print_row_target_destroy_notify == NULL) ? NULL : (print_row_target_destroy_notify (print_row_target), NULL);
#line 498 "../src/library.vala"
		print_row = NULL;
#line 498 "../src/library.vala"
		print_row_target = NULL;
#line 498 "../src/library.vala"
		print_row_target_destroy_notify = NULL;
#line 498 "../src/library.vala"
		block24_data_unref (_data24_);
#line 498 "../src/library.vala"
		_data24_ = NULL;
#line 4401 "library.c"
	}
	{
		GeeArrayList* _bookLocation_list = NULL;
		GeeArrayList* _tmp62_;
		gint _bookLocation_size = 0;
		GeeArrayList* _tmp63_;
		gint _tmp64_;
		gint _tmp65_;
		gint _bookLocation_index = 0;
#line 521 "../src/library.vala"
		_tmp62_ = _data23_->listOfBooksToBeRemoved;
#line 521 "../src/library.vala"
		_bookLocation_list = _tmp62_;
#line 521 "../src/library.vala"
		_tmp63_ = _bookLocation_list;
#line 521 "../src/library.vala"
		_tmp64_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp63_);
#line 521 "../src/library.vala"
		_tmp65_ = _tmp64_;
#line 521 "../src/library.vala"
		_bookLocation_size = _tmp65_;
#line 521 "../src/library.vala"
		_bookLocation_index = -1;
#line 521 "../src/library.vala"
		while (TRUE) {
#line 4427 "library.c"
			gint _tmp66_;
			gint _tmp67_;
			gchar* bookLocation = NULL;
			GeeArrayList* _tmp68_;
			gpointer _tmp69_;
			GeeHashMap* _tmp70_;
			const gchar* _tmp71_;
			gpointer _tmp72_;
			BookwormAppBook* _tmp73_;
			GeeHashMap* _tmp74_;
			const gchar* _tmp75_;
#line 521 "../src/library.vala"
			_bookLocation_index = _bookLocation_index + 1;
#line 521 "../src/library.vala"
			_tmp66_ = _bookLocation_index;
#line 521 "../src/library.vala"
			_tmp67_ = _bookLocation_size;
#line 521 "../src/library.vala"
			if (!(_tmp66_ < _tmp67_)) {
#line 521 "../src/library.vala"
				break;
#line 4449 "library.c"
			}
#line 521 "../src/library.vala"
			_tmp68_ = _bookLocation_list;
#line 521 "../src/library.vala"
			_tmp69_ = gee_abstract_list_get ((GeeAbstractList*) _tmp68_, _bookLocation_index);
#line 521 "../src/library.vala"
			bookLocation = (gchar*) _tmp69_;
#line 522 "../src/library.vala"
			_tmp70_ = bookworm_app_bookworm_libraryViewMap;
#line 522 "../src/library.vala"
			_tmp71_ = bookLocation;
#line 522 "../src/library.vala"
			_tmp72_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp70_, _tmp71_);
#line 522 "../src/library.vala"
			_tmp73_ = (BookwormAppBook*) _tmp72_;
#line 522 "../src/library.vala"
			bookworm_app_db_removeBookFromDB (_tmp73_);
#line 522 "../src/library.vala"
			_bookworm_app_book_unref0 (_tmp73_);
#line 523 "../src/library.vala"
			_tmp74_ = bookworm_app_bookworm_libraryViewMap;
#line 523 "../src/library.vala"
			_tmp75_ = bookLocation;
#line 523 "../src/library.vala"
			gee_abstract_map_unset ((GeeAbstractMap*) _tmp74_, _tmp75_, NULL);
#line 521 "../src/library.vala"
			_g_free0 (bookLocation);
#line 4477 "library.c"
		}
	}
#line 526 "../src/library.vala"
	_tmp78_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 526 "../src/library.vala"
	_tmp79_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[0];
#line 526 "../src/library.vala"
	if (g_strcmp0 (_tmp78_, _tmp79_) == 0) {
#line 526 "../src/library.vala"
		_tmp77_ = TRUE;
#line 4488 "library.c"
	} else {
		const gchar* _tmp80_;
		const gchar* _tmp81_;
#line 527 "../src/library.vala"
		_tmp80_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 527 "../src/library.vala"
		_tmp81_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[2];
#line 527 "../src/library.vala"
		_tmp77_ = g_strcmp0 (_tmp80_, _tmp81_) == 0;
#line 4498 "library.c"
	}
#line 526 "../src/library.vala"
	if (_tmp77_) {
#line 526 "../src/library.vala"
		_tmp76_ = TRUE;
#line 4504 "library.c"
	} else {
		const gchar* _tmp82_;
		const gchar* _tmp83_;
#line 528 "../src/library.vala"
		_tmp82_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 528 "../src/library.vala"
		_tmp83_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[3];
#line 528 "../src/library.vala"
		_tmp76_ = g_strcmp0 (_tmp82_, _tmp83_) == 0;
#line 4514 "library.c"
	}
#line 526 "../src/library.vala"
	if (_tmp76_) {
#line 4518 "library.c"
		const gchar* _tmp84_;
		gchar* _tmp85_;
#line 530 "../src/library.vala"
		_tmp84_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[0];
#line 530 "../src/library.vala"
		_tmp85_ = g_strdup (_tmp84_);
#line 530 "../src/library.vala"
		_g_free0 (bookworm_app_bookworm_BOOKWORM_CURRENT_STATE);
#line 530 "../src/library.vala"
		bookworm_app_bookworm_BOOKWORM_CURRENT_STATE = _tmp85_;
#line 531 "../src/library.vala"
		bookworm_app_library_updateGridViewForSelection (NULL);
#line 4531 "library.c"
	}
#line 534 "../src/library.vala"
	_tmp88_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 534 "../src/library.vala"
	_tmp89_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[5];
#line 534 "../src/library.vala"
	if (g_strcmp0 (_tmp88_, _tmp89_) == 0) {
#line 534 "../src/library.vala"
		_tmp87_ = TRUE;
#line 4541 "library.c"
	} else {
		const gchar* _tmp90_;
		const gchar* _tmp91_;
#line 535 "../src/library.vala"
		_tmp90_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 535 "../src/library.vala"
		_tmp91_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[6];
#line 535 "../src/library.vala"
		_tmp87_ = g_strcmp0 (_tmp90_, _tmp91_) == 0;
#line 4551 "library.c"
	}
#line 534 "../src/library.vala"
	if (_tmp87_) {
#line 534 "../src/library.vala"
		_tmp86_ = TRUE;
#line 4557 "library.c"
	} else {
		const gchar* _tmp92_;
		const gchar* _tmp93_;
#line 536 "../src/library.vala"
		_tmp92_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 536 "../src/library.vala"
		_tmp93_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[7];
#line 536 "../src/library.vala"
		_tmp86_ = g_strcmp0 (_tmp92_, _tmp93_) == 0;
#line 4567 "library.c"
	}
#line 534 "../src/library.vala"
	if (_tmp86_) {
#line 4571 "library.c"
		const gchar* _tmp94_;
		gchar* _tmp95_;
#line 538 "../src/library.vala"
		_tmp94_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[5];
#line 538 "../src/library.vala"
		_tmp95_ = g_strdup (_tmp94_);
#line 538 "../src/library.vala"
		_g_free0 (bookworm_app_bookworm_BOOKWORM_CURRENT_STATE);
#line 538 "../src/library.vala"
		bookworm_app_bookworm_BOOKWORM_CURRENT_STATE = _tmp95_;
#line 539 "../src/library.vala"
		bookworm_app_library_updateListViewForSelection (NULL);
#line 4584 "library.c"
	}
#line 541 "../src/library.vala"
	bookworm_app_bookworm_toggleUIState ();
#line 542 "../src/library.vala"
	g_debug ("library.vala:542: [END] [FUNCTION:removeSelectedBooksFromLibrary]");
#line 469 "../src/library.vala"
	block23_data_unref (_data23_);
#line 469 "../src/library.vala"
	_data23_ = NULL;
#line 4594 "library.c"
}

static void
bookworm_app_library_updateLibraryViewFromDB_data_free (gpointer _data)
{
	bookworm_app_library_updateLibraryViewFromDBData* _data_;
	_data_ = _data;
#line 21 "../src/library.vala"
	g_slice_free (bookworm_app_library_updateLibraryViewFromDBData, _data_);
#line 4604 "library.c"
}

void
bookworm_app_library_updateLibraryViewFromDB (GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	bookworm_app_library_updateLibraryViewFromDBData* _data_;
#line 21 "../src/library.vala"
	_data_ = g_slice_new0 (bookworm_app_library_updateLibraryViewFromDBData);
#line 21 "../src/library.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 21 "../src/library.vala"
	g_task_set_task_data (_data_->_async_result, _data_, bookworm_app_library_updateLibraryViewFromDB_data_free);
#line 21 "../src/library.vala"
	bookworm_app_library_updateLibraryViewFromDB_co (_data_);
#line 4620 "library.c"
}

void
bookworm_app_library_updateLibraryViewFromDB_finish (GAsyncResult* _res_)
{
	bookworm_app_library_updateLibraryViewFromDBData* _data_;
#line 21 "../src/library.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 4629 "library.c"
}

static gboolean
_bookworm_app_library_updateLibraryViewFromDB_co_gsource_func (gpointer self)
{
	gboolean result;
	result = bookworm_app_library_updateLibraryViewFromDB_co (self);
#line 550 "../src/library.vala"
	return result;
#line 4639 "library.c"
}

static gboolean
bookworm_app_library_updateLibraryViewFromDB_co (bookworm_app_library_updateLibraryViewFromDBData* _data_)
{
#line 545 "../src/library.vala"
	switch (_data_->_state_) {
#line 545 "../src/library.vala"
		case 0:
#line 4649 "library.c"
		goto _state_0;
#line 545 "../src/library.vala"
		case 1:
#line 4653 "library.c"
		goto _state_1;
		default:
#line 545 "../src/library.vala"
		g_assert_not_reached ();
#line 4658 "library.c"
	}
	_state_0:
#line 546 "../src/library.vala"
	g_debug ("library.vala:546: [START] [FUNCTION:updateLibraryViewFromDB]");
#line 4663 "library.c"
	{
#line 547 "../src/library.vala"
		_data_->_tmp0_ = bookworm_app_library_listOfBooksInLibraryOnLoad;
#line 547 "../src/library.vala"
		_data_->_book_list = _data_->_tmp0_;
#line 547 "../src/library.vala"
		_data_->_tmp1_ = _data_->_book_list;
#line 547 "../src/library.vala"
		_data_->_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp1_);
#line 547 "../src/library.vala"
		_data_->_tmp3_ = _data_->_tmp2_;
#line 547 "../src/library.vala"
		_data_->_book_size = _data_->_tmp3_;
#line 547 "../src/library.vala"
		_data_->_book_index = -1;
#line 547 "../src/library.vala"
		while (TRUE) {
#line 547 "../src/library.vala"
			_data_->_book_index = _data_->_book_index + 1;
#line 547 "../src/library.vala"
			_data_->_tmp4_ = _data_->_book_index;
#line 547 "../src/library.vala"
			_data_->_tmp5_ = _data_->_book_size;
#line 547 "../src/library.vala"
			if (!(_data_->_tmp4_ < _data_->_tmp5_)) {
#line 547 "../src/library.vala"
				break;
#line 4691 "library.c"
			}
#line 547 "../src/library.vala"
			_data_->_tmp6_ = _data_->_book_list;
#line 547 "../src/library.vala"
			_data_->_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp6_, _data_->_book_index);
#line 547 "../src/library.vala"
			_data_->book = (BookwormAppBook*) _data_->_tmp7_;
#line 549 "../src/library.vala"
			_data_->_tmp8_ = _data_->book;
#line 549 "../src/library.vala"
			_data_->_tmp9_ = _bookworm_app_book_ref0 (_data_->_tmp8_);
#line 549 "../src/library.vala"
			bookworm_app_library_updateLibraryView (_data_->_tmp9_);
#line 550 "../src/library.vala"
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _bookworm_app_library_updateLibraryViewFromDB_co_gsource_func, _data_, NULL);
#line 551 "../src/library.vala"
			_data_->_state_ = 1;
#line 551 "../src/library.vala"
			return FALSE;
#line 4711 "library.c"
			_state_1:
			;
#line 547 "../src/library.vala"
			_bookworm_app_book_unref0 (_data_->book);
#line 4716 "library.c"
		}
	}
#line 553 "../src/library.vala"
	g_debug ("library.vala:553: [END] [FUNCTION:updateLibraryViewFromDB]");
#line 545 "../src/library.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 545 "../src/library.vala"
	if (_data_->_state_ != 0) {
#line 545 "../src/library.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 545 "../src/library.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4729 "library.c"
		}
	}
#line 545 "../src/library.vala"
	g_object_unref (_data_->_async_result);
#line 545 "../src/library.vala"
	return FALSE;
#line 4736 "library.c"
}

static void
bookworm_app_library_addBooksToLibrary_data_free (gpointer _data)
{
	bookworm_app_library_addBooksToLibraryData* _data_;
	_data_ = _data;
#line 21 "../src/library.vala"
	g_slice_free (bookworm_app_library_addBooksToLibraryData, _data_);
#line 4746 "library.c"
}

void
bookworm_app_library_addBooksToLibrary (GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	bookworm_app_library_addBooksToLibraryData* _data_;
#line 21 "../src/library.vala"
	_data_ = g_slice_new0 (bookworm_app_library_addBooksToLibraryData);
#line 21 "../src/library.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 21 "../src/library.vala"
	g_task_set_task_data (_data_->_async_result, _data_, bookworm_app_library_addBooksToLibrary_data_free);
#line 21 "../src/library.vala"
	bookworm_app_library_addBooksToLibrary_co (_data_);
#line 4762 "library.c"
}

void
bookworm_app_library_addBooksToLibrary_finish (GAsyncResult* _res_)
{
	bookworm_app_library_addBooksToLibraryData* _data_;
#line 21 "../src/library.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 4771 "library.c"
}

static gboolean
_bookworm_app_library_addBooksToLibrary_co_gsource_func (gpointer self)
{
	gboolean result;
	result = bookworm_app_library_addBooksToLibrary_co (self);
#line 568 "../src/library.vala"
	return result;
#line 4781 "library.c"
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1413 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1414 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1414 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1415 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1416 "glib-2.0.vapi"
	result = _result_;
#line 1416 "glib-2.0.vapi"
	return result;
#line 4802 "library.c"
}

static gboolean
bookworm_app_library_addBooksToLibrary_co (bookworm_app_library_addBooksToLibraryData* _data_)
{
#line 556 "../src/library.vala"
	switch (_data_->_state_) {
#line 556 "../src/library.vala"
		case 0:
#line 4812 "library.c"
		goto _state_0;
#line 556 "../src/library.vala"
		case 1:
#line 4816 "library.c"
		goto _state_1;
		default:
#line 556 "../src/library.vala"
		g_assert_not_reached ();
#line 4821 "library.c"
	}
	_state_0:
#line 557 "../src/library.vala"
	g_debug ("library.vala:557: [START] [FUNCTION:addBooksToLibrary]");
#line 558 "../src/library.vala"
	_data_->_tmp0_ = bookworm_app_bookworm_pathsOfBooksToBeAdded;
#line 558 "../src/library.vala"
	_data_->_tmp0__length1 = bookworm_app_bookworm_pathsOfBooksToBeAdded_length1;
#line 558 "../src/library.vala"
	_data_->_tmp1_ = g_strdup_printf ("%i", _data_->_tmp0__length1);
#line 558 "../src/library.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 558 "../src/library.vala"
	_data_->_tmp3_ = g_strconcat ("books to be added=", _data_->_tmp2_, NULL);
#line 558 "../src/library.vala"
	_data_->_tmp4_ = _data_->_tmp3_;
#line 558 "../src/library.vala"
	g_debug ("library.vala:558: %s", _data_->_tmp4_);
#line 558 "../src/library.vala"
	_g_free0 (_data_->_tmp4_);
#line 558 "../src/library.vala"
	_g_free0 (_data_->_tmp2_);
#line 559 "../src/library.vala"
	_data_->progress = 0.;
#line 561 "../src/library.vala"
	_data_->_tmp5_ = bookworm_app_bookworm_pathsOfBooksToBeAdded;
#line 561 "../src/library.vala"
	_data_->_tmp5__length1 = bookworm_app_bookworm_pathsOfBooksToBeAdded_length1;
#line 4850 "library.c"
	{
#line 561 "../src/library.vala"
		_data_->pathToSelectedBook_collection_length1 = 0;
#line 561 "../src/library.vala"
		_data_->_pathToSelectedBook_collection_size_ = 0;
#line 561 "../src/library.vala"
		_data_->pathToSelectedBook_collection = _data_->_tmp5_;
#line 561 "../src/library.vala"
		_data_->pathToSelectedBook_collection_length1 = _data_->_tmp5__length1;
#line 561 "../src/library.vala"
		for (_data_->pathToSelectedBook_it = 0; _data_->pathToSelectedBook_it < _data_->pathToSelectedBook_collection_length1; _data_->pathToSelectedBook_it = _data_->pathToSelectedBook_it + 1) {
#line 561 "../src/library.vala"
			_data_->_tmp6_ = g_strdup (_data_->pathToSelectedBook_collection[_data_->pathToSelectedBook_it]);
#line 561 "../src/library.vala"
			_data_->pathToSelectedBook = _data_->_tmp6_;
#line 4866 "library.c"
			{
#line 562 "../src/library.vala"
				_data_->_tmp7_ = _data_->pathToSelectedBook;
#line 562 "../src/library.vala"
				_data_->_tmp8_ = g_strconcat ("Attempting to add book from path:", _data_->_tmp7_, NULL);
#line 562 "../src/library.vala"
				_data_->_tmp9_ = _data_->_tmp8_;
#line 562 "../src/library.vala"
				g_debug ("library.vala:562: %s", _data_->_tmp9_);
#line 562 "../src/library.vala"
				_g_free0 (_data_->_tmp9_);
#line 567 "../src/library.vala"
				_data_->_tmp10_ = bookworm_app_bookworm_pathsOfBooksToBeAdded;
#line 567 "../src/library.vala"
				_data_->_tmp10__length1 = bookworm_app_bookworm_pathsOfBooksToBeAdded_length1;
#line 567 "../src/library.vala"
				if (_data_->_tmp10__length1 > 2) {
#line 568 "../src/library.vala"
					g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _bookworm_app_library_addBooksToLibrary_co_gsource_func, _data_, NULL);
#line 4886 "library.c"
				}
#line 570 "../src/library.vala"
				_data_->_tmp11_ = bookworm_app_bookworm_noOfBooksAddedFromCommand;
#line 570 "../src/library.vala"
				bookworm_app_bookworm_noOfBooksAddedFromCommand = _data_->_tmp11_ + 1;
#line 572 "../src/library.vala"
				_data_->_tmp12_ = _data_->pathToSelectedBook;
#line 572 "../src/library.vala"
				_data_->_tmp13_ = string_strip (_data_->_tmp12_);
#line 572 "../src/library.vala"
				_data_->_tmp14_ = _data_->_tmp13_;
#line 572 "../src/library.vala"
				_data_->_tmp15_ = g_strcmp0 (BOOKWORM_APP_CONSTANTS_bookworm_id, _data_->_tmp14_) != 0;
#line 572 "../src/library.vala"
				_g_free0 (_data_->_tmp14_);
#line 572 "../src/library.vala"
				if (_data_->_tmp15_) {
#line 574 "../src/library.vala"
					_data_->_tmp16_ = bookworm_app_bookworm_pathsOfBooksToBeAdded;
#line 574 "../src/library.vala"
					_data_->_tmp16__length1 = bookworm_app_bookworm_pathsOfBooksToBeAdded_length1;
#line 574 "../src/library.vala"
					_data_->progress = ((gdouble) bookworm_app_bookworm_noOfBooksAddedFromCommand) / ((gdouble) _data_->_tmp16__length1);
#line 576 "../src/library.vala"
					_data_->_tmp17_ = bookworm_app_app_window_bookAdditionBar;
#line 576 "../src/library.vala"
					_data_->_tmp18_ = g_strdup_printf ("%i", (gint) (_data_->progress * 100));
#line 576 "../src/library.vala"
					_data_->_tmp19_ = _data_->_tmp18_;
#line 576 "../src/library.vala"
					_data_->_tmp20_ = g_strconcat (_ ("Adding "), _data_->_tmp19_, NULL);
#line 576 "../src/library.vala"
					_data_->_tmp21_ = _data_->_tmp20_;
#line 576 "../src/library.vala"
					_data_->_tmp22_ = g_strconcat (_data_->_tmp21_, "% : ", NULL);
#line 576 "../src/library.vala"
					_data_->_tmp23_ = _data_->_tmp22_;
#line 576 "../src/library.vala"
					_data_->_tmp24_ = _data_->pathToSelectedBook;
#line 576 "../src/library.vala"
					_data_->_tmp25_ = g_file_new_for_path (_data_->_tmp24_);
#line 576 "../src/library.vala"
					_data_->_tmp26_ = _data_->_tmp25_;
#line 576 "../src/library.vala"
					_data_->_tmp27_ = g_file_get_basename (_data_->_tmp26_);
#line 576 "../src/library.vala"
					_data_->_tmp28_ = _data_->_tmp27_;
#line 576 "../src/library.vala"
					_data_->_tmp29_ = g_strconcat (_data_->_tmp23_, _data_->_tmp28_, NULL);
#line 576 "../src/library.vala"
					_data_->_tmp30_ = _data_->_tmp29_;
#line 576 "../src/library.vala"
					gtk_progress_bar_set_text (_data_->_tmp17_, _data_->_tmp30_);
#line 576 "../src/library.vala"
					_g_free0 (_data_->_tmp30_);
#line 576 "../src/library.vala"
					_g_free0 (_data_->_tmp28_);
#line 576 "../src/library.vala"
					_g_object_unref0 (_data_->_tmp26_);
#line 576 "../src/library.vala"
					_g_free0 (_data_->_tmp23_);
#line 576 "../src/library.vala"
					_g_free0 (_data_->_tmp21_);
#line 576 "../src/library.vala"
					_g_free0 (_data_->_tmp19_);
#line 581 "../src/library.vala"
					_data_->_tmp31_ = bookworm_app_app_window_bookAdditionBar;
#line 581 "../src/library.vala"
					gtk_progress_bar_set_fraction (_data_->_tmp31_, _data_->progress);
#line 4956 "library.c"
				}
#line 587 "../src/library.vala"
				_data_->_tmp32_ = bookworm_app_bookworm_pathsOfBooksToBeAdded;
#line 587 "../src/library.vala"
				_data_->_tmp32__length1 = bookworm_app_bookworm_pathsOfBooksToBeAdded_length1;
#line 587 "../src/library.vala"
				if (_data_->_tmp32__length1 > 2) {
#line 588 "../src/library.vala"
					_data_->_state_ = 1;
#line 588 "../src/library.vala"
					return FALSE;
#line 4968 "library.c"
					_state_1:
					;
				}
#line 591 "../src/library.vala"
				_data_->_tmp33_ = _data_->pathToSelectedBook;
#line 591 "../src/library.vala"
				_data_->_tmp34_ = string_strip (_data_->_tmp33_);
#line 591 "../src/library.vala"
				_data_->_tmp35_ = _data_->_tmp34_;
#line 591 "../src/library.vala"
				_data_->_tmp36_ = g_strcmp0 (BOOKWORM_APP_CONSTANTS_bookworm_id, _data_->_tmp35_) != 0;
#line 591 "../src/library.vala"
				_g_free0 (_data_->_tmp35_);
#line 591 "../src/library.vala"
				if (_data_->_tmp36_) {
#line 593 "../src/library.vala"
					_data_->_tmp37_ = bookworm_app_bookworm_pathsOfBooksInLibraryOnLoadStr;
#line 593 "../src/library.vala"
					_data_->_tmp38_ = _data_->_tmp37_->str;
#line 593 "../src/library.vala"
					_data_->_tmp39_ = _data_->pathToSelectedBook;
#line 593 "../src/library.vala"
					_data_->_tmp40_ = string_strip (_data_->_tmp39_);
#line 593 "../src/library.vala"
					_data_->_tmp41_ = _data_->_tmp40_;
#line 593 "../src/library.vala"
					_data_->_tmp42_ = string_index_of (_data_->_tmp38_, _data_->_tmp41_, 0) != -1;
#line 593 "../src/library.vala"
					_g_free0 (_data_->_tmp41_);
#line 593 "../src/library.vala"
					if (_data_->_tmp42_) {
#line 594 "../src/library.vala"
						_data_->_tmp43_ = bookworm_app_bookworm_pathsOfBooksInLibraryOnLoadStr;
#line 594 "../src/library.vala"
						_data_->_tmp44_ = _data_->_tmp43_->str;
#line 594 "../src/library.vala"
						_data_->_tmp45_ = g_strconcat ("Book already exists in library...", _data_->_tmp44_, NULL);
#line 594 "../src/library.vala"
						_data_->_tmp46_ = _data_->_tmp45_;
#line 594 "../src/library.vala"
						g_debug ("library.vala:594: %s", _data_->_tmp46_);
#line 594 "../src/library.vala"
						_g_free0 (_data_->_tmp46_);
#line 596 "../src/library.vala"
						bookworm_app_bookworm_isPageScrollRequired = TRUE;
#line 598 "../src/library.vala"
						_data_->_tmp47_ = _data_->pathToSelectedBook;
#line 598 "../src/library.vala"
						_data_->_tmp48_ = string_strip (_data_->_tmp47_);
#line 598 "../src/library.vala"
						_g_free0 (bookworm_app_bookworm_locationOfEBookCurrentlyRead);
#line 598 "../src/library.vala"
						bookworm_app_bookworm_locationOfEBookCurrentlyRead = _data_->_tmp48_;
#line 5022 "library.c"
					} else {
#line 601 "../src/library.vala"
						_data_->_tmp49_ = bookworm_app_book_new ();
#line 601 "../src/library.vala"
						_data_->aBookBeingAdded = _data_->_tmp49_;
#line 602 "../src/library.vala"
						_data_->_tmp50_ = _data_->aBookBeingAdded;
#line 602 "../src/library.vala"
						_data_->_tmp51_ = _data_->pathToSelectedBook;
#line 602 "../src/library.vala"
						_data_->_tmp52_ = string_strip (_data_->_tmp51_);
#line 602 "../src/library.vala"
						_data_->_tmp53_ = _data_->_tmp52_;
#line 602 "../src/library.vala"
						bookworm_app_book_setBookLocation (_data_->_tmp50_, _data_->_tmp53_);
#line 602 "../src/library.vala"
						_g_free0 (_data_->_tmp53_);
#line 605 "../src/library.vala"
						_data_->_tmp54_ = _data_->aBookBeingAdded;
#line 605 "../src/library.vala"
						_data_->_tmp55_ = _bookworm_app_book_ref0 (_data_->_tmp54_);
#line 605 "../src/library.vala"
						bookworm_app_library_addBookToLibrary (_data_->_tmp55_);
#line 607 "../src/library.vala"
						_data_->_tmp56_ = bookworm_app_bookworm_pathsOfBooksInLibraryOnLoadStr;
#line 607 "../src/library.vala"
						_data_->_tmp57_ = _data_->aBookBeingAdded;
#line 607 "../src/library.vala"
						_data_->_tmp58_ = bookworm_app_book_getBookLocation (_data_->_tmp57_);
#line 607 "../src/library.vala"
						_data_->_tmp59_ = _data_->_tmp58_;
#line 607 "../src/library.vala"
						g_string_append (_data_->_tmp56_, _data_->_tmp59_);
#line 607 "../src/library.vala"
						_g_free0 (_data_->_tmp59_);
#line 608 "../src/library.vala"
						_data_->_tmp60_ = bookworm_app_library_listOfBooksInLibraryOnLoad;
#line 608 "../src/library.vala"
						_data_->_tmp61_ = _data_->aBookBeingAdded;
#line 608 "../src/library.vala"
						gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp60_, _data_->_tmp61_);
#line 593 "../src/library.vala"
						_bookworm_app_book_unref0 (_data_->aBookBeingAdded);
#line 5066 "library.c"
					}
				}
#line 561 "../src/library.vala"
				_g_free0 (_data_->pathToSelectedBook);
#line 5071 "library.c"
			}
		}
	}
#line 613 "../src/library.vala"
	_data_->_tmp62_ = bookworm_app_app_window_bookAdditionBar;
#line 613 "../src/library.vala"
	gtk_widget_hide ((GtkWidget*) _data_->_tmp62_);
#line 614 "../src/library.vala"
	bookworm_app_bookworm_isBookBeingAddedToLibrary = FALSE;
#line 615 "../src/library.vala"
	bookworm_app_bookworm_noOfBooksAddedFromCommand = 0;
#line 616 "../src/library.vala"
	g_debug ("library.vala:616: [END] [FUNCTION:addBooksToLibrary]");
#line 556 "../src/library.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 556 "../src/library.vala"
	if (_data_->_state_ != 0) {
#line 556 "../src/library.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 556 "../src/library.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 5093 "library.c"
		}
	}
#line 556 "../src/library.vala"
	g_object_unref (_data_->_async_result);
#line 556 "../src/library.vala"
	return FALSE;
#line 5100 "library.c"
}

void
bookworm_app_library_addBookToLibrary (BookwormAppBook* aBook)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* eBookLocation = NULL;
	gchar* _tmp4_;
	GFile* eBookFile = NULL;
	const gchar* _tmp5_;
	GFile* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GFile* _tmp8_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
#line 619 "../src/library.vala"
	g_return_if_fail (aBook != NULL);
#line 620 "../src/library.vala"
	_tmp0_ = bookworm_app_book_getBookLocation (aBook);
#line 620 "../src/library.vala"
	_tmp1_ = _tmp0_;
#line 620 "../src/library.vala"
	_tmp2_ = g_strconcat ("[START] [FUNCTION:addBookToLibrary] book.location=", _tmp1_, NULL);
#line 620 "../src/library.vala"
	_tmp3_ = _tmp2_;
#line 620 "../src/library.vala"
	g_debug ("library.vala:620: %s", _tmp3_);
#line 620 "../src/library.vala"
	_g_free0 (_tmp3_);
#line 620 "../src/library.vala"
	_g_free0 (_tmp1_);
#line 622 "../src/library.vala"
	_tmp4_ = bookworm_app_book_getBookLocation (aBook);
#line 622 "../src/library.vala"
	eBookLocation = _tmp4_;
#line 623 "../src/library.vala"
	_tmp5_ = eBookLocation;
#line 623 "../src/library.vala"
	_tmp6_ = g_file_new_for_path (_tmp5_);
#line 623 "../src/library.vala"
	eBookFile = _tmp6_;
#line 624 "../src/library.vala"
	_tmp8_ = eBookFile;
#line 624 "../src/library.vala"
	if (g_file_query_exists (_tmp8_, NULL)) {
#line 5151 "library.c"
		GFile* _tmp9_;
#line 624 "../src/library.vala"
		_tmp9_ = eBookFile;
#line 624 "../src/library.vala"
		_tmp7_ = g_file_query_file_type (_tmp9_, 0, NULL) != G_FILE_TYPE_DIRECTORY;
#line 5157 "library.c"
	} else {
#line 624 "../src/library.vala"
		_tmp7_ = FALSE;
#line 5161 "library.c"
	}
#line 624 "../src/library.vala"
	if (_tmp7_) {
#line 5165 "library.c"
		gint bookID = 0;
		GDateTime* _tmp10_;
		GDateTime* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		BookwormAppBook* _tmp14_;
		BookwormAppBook* _tmp15_;
#line 626 "../src/library.vala"
		bookID = bookworm_app_db_addBookToDataBase (aBook);
#line 627 "../src/library.vala"
		bookworm_app_book_setBookId (aBook, bookID);
#line 632 "../src/library.vala"
		_tmp10_ = g_date_time_new_now_utc ();
#line 632 "../src/library.vala"
		_tmp11_ = _tmp10_;
#line 632 "../src/library.vala"
		_tmp12_ = g_strdup_printf ("%" G_GINT64_FORMAT, g_date_time_to_unix (_tmp11_));
#line 632 "../src/library.vala"
		_tmp13_ = _tmp12_;
#line 632 "../src/library.vala"
		bookworm_app_book_setBookLastModificationDate (aBook, _tmp13_);
#line 632 "../src/library.vala"
		_g_free0 (_tmp13_);
#line 632 "../src/library.vala"
		_g_date_time_unref0 (_tmp11_);
#line 633 "../src/library.vala"
		bookworm_app_book_setWasBookOpened (aBook, TRUE);
#line 635 "../src/library.vala"
		_tmp14_ = _bookworm_app_book_ref0 (aBook);
#line 635 "../src/library.vala"
		_tmp15_ = bookworm_app_bookworm_genericParser (_tmp14_);
#line 635 "../src/library.vala"
		_bookworm_app_book_unref0 (aBook);
#line 635 "../src/library.vala"
		aBook = _tmp15_;
#line 636 "../src/library.vala"
		if (!bookworm_app_book_getIsBookParsed (aBook)) {
#line 637 "../src/library.vala"
			bookworm_app_db_removeBookFromDB (aBook);
#line 638 "../src/library.vala"
			bookworm_app_app_window_showInfoBar (aBook, GTK_MESSAGE_WARNING);
#line 5207 "library.c"
		} else {
			BookwormAppBook* _tmp16_;
			gboolean _tmp17_ = FALSE;
			gboolean _tmp18_ = FALSE;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			gboolean _tmp27_ = FALSE;
			gboolean _tmp28_ = FALSE;
			const gchar* _tmp29_;
			const gchar* _tmp30_;
			const gchar* _tmp37_;
			gchar* _tmp38_;
			GeeHashMap* _tmp39_;
			gint _tmp40_;
			gint _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
#line 641 "../src/library.vala"
			_tmp16_ = _bookworm_app_book_ref0 (aBook);
#line 641 "../src/library.vala"
			bookworm_app_library_updateLibraryView (_tmp16_);
#line 643 "../src/library.vala"
			_tmp19_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 643 "../src/library.vala"
			_tmp20_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[0];
#line 643 "../src/library.vala"
			if (g_strcmp0 (_tmp19_, _tmp20_) == 0) {
#line 643 "../src/library.vala"
				_tmp18_ = TRUE;
#line 5239 "library.c"
			} else {
				const gchar* _tmp21_;
				const gchar* _tmp22_;
#line 644 "../src/library.vala"
				_tmp21_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 644 "../src/library.vala"
				_tmp22_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[2];
#line 644 "../src/library.vala"
				_tmp18_ = g_strcmp0 (_tmp21_, _tmp22_) == 0;
#line 5249 "library.c"
			}
#line 643 "../src/library.vala"
			if (_tmp18_) {
#line 643 "../src/library.vala"
				_tmp17_ = TRUE;
#line 5255 "library.c"
			} else {
				const gchar* _tmp23_;
				const gchar* _tmp24_;
#line 645 "../src/library.vala"
				_tmp23_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 645 "../src/library.vala"
				_tmp24_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[3];
#line 645 "../src/library.vala"
				_tmp17_ = g_strcmp0 (_tmp23_, _tmp24_) == 0;
#line 5265 "library.c"
			}
#line 643 "../src/library.vala"
			if (_tmp17_) {
#line 5269 "library.c"
				const gchar* _tmp25_;
				gchar* _tmp26_;
#line 647 "../src/library.vala"
				_tmp25_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[0];
#line 647 "../src/library.vala"
				_tmp26_ = g_strdup (_tmp25_);
#line 647 "../src/library.vala"
				_g_free0 (bookworm_app_bookworm_BOOKWORM_CURRENT_STATE);
#line 647 "../src/library.vala"
				bookworm_app_bookworm_BOOKWORM_CURRENT_STATE = _tmp26_;
#line 648 "../src/library.vala"
				bookworm_app_library_updateGridViewForSelection (NULL);
#line 5282 "library.c"
			}
#line 651 "../src/library.vala"
			_tmp29_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 651 "../src/library.vala"
			_tmp30_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[5];
#line 651 "../src/library.vala"
			if (g_strcmp0 (_tmp29_, _tmp30_) == 0) {
#line 651 "../src/library.vala"
				_tmp28_ = TRUE;
#line 5292 "library.c"
			} else {
				const gchar* _tmp31_;
				const gchar* _tmp32_;
#line 652 "../src/library.vala"
				_tmp31_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 652 "../src/library.vala"
				_tmp32_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[6];
#line 652 "../src/library.vala"
				_tmp28_ = g_strcmp0 (_tmp31_, _tmp32_) == 0;
#line 5302 "library.c"
			}
#line 651 "../src/library.vala"
			if (_tmp28_) {
#line 651 "../src/library.vala"
				_tmp27_ = TRUE;
#line 5308 "library.c"
			} else {
				const gchar* _tmp33_;
				const gchar* _tmp34_;
#line 653 "../src/library.vala"
				_tmp33_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 653 "../src/library.vala"
				_tmp34_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[7];
#line 653 "../src/library.vala"
				_tmp27_ = g_strcmp0 (_tmp33_, _tmp34_) == 0;
#line 5318 "library.c"
			}
#line 651 "../src/library.vala"
			if (_tmp27_) {
#line 5322 "library.c"
				const gchar* _tmp35_;
				gchar* _tmp36_;
#line 655 "../src/library.vala"
				_tmp35_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[5];
#line 655 "../src/library.vala"
				_tmp36_ = g_strdup (_tmp35_);
#line 655 "../src/library.vala"
				_g_free0 (bookworm_app_bookworm_BOOKWORM_CURRENT_STATE);
#line 655 "../src/library.vala"
				bookworm_app_bookworm_BOOKWORM_CURRENT_STATE = _tmp36_;
#line 656 "../src/library.vala"
				bookworm_app_library_updateListViewForSelection (NULL);
#line 5335 "library.c"
			}
#line 658 "../src/library.vala"
			bookworm_app_bookworm_toggleUIState ();
#line 660 "../src/library.vala"
			_tmp37_ = eBookLocation;
#line 660 "../src/library.vala"
			_tmp38_ = g_strdup (_tmp37_);
#line 660 "../src/library.vala"
			_g_free0 (bookworm_app_bookworm_locationOfEBookCurrentlyRead);
#line 660 "../src/library.vala"
			bookworm_app_bookworm_locationOfEBookCurrentlyRead = _tmp38_;
#line 661 "../src/library.vala"
			_tmp39_ = bookworm_app_bookworm_libraryViewMap;
#line 661 "../src/library.vala"
			_tmp40_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp39_);
#line 661 "../src/library.vala"
			_tmp41_ = _tmp40_;
#line 661 "../src/library.vala"
			_tmp42_ = g_strdup_printf ("%i", _tmp41_);
#line 661 "../src/library.vala"
			_tmp43_ = _tmp42_;
#line 661 "../src/library.vala"
			_tmp44_ = g_strconcat ("Completed adding book to ebook library. Number of books in library:", _tmp43_, NULL);
#line 661 "../src/library.vala"
			_tmp45_ = _tmp44_;
#line 661 "../src/library.vala"
			g_debug ("library.vala:661: %s", _tmp45_);
#line 661 "../src/library.vala"
			_g_free0 (_tmp45_);
#line 661 "../src/library.vala"
			_g_free0 (_tmp43_);
#line 5367 "library.c"
		}
	} else {
#line 666 "../src/library.vala"
		g_debug ("library.vala:666: No ebook found for adding to library");
#line 5372 "library.c"
	}
#line 668 "../src/library.vala"
	_tmp46_ = bookworm_app_book_getBookLocation (aBook);
#line 668 "../src/library.vala"
	_tmp47_ = _tmp46_;
#line 668 "../src/library.vala"
	_tmp48_ = g_strconcat ("[END] [FUNCTION:addBookToLibrary] book.location=", _tmp47_, NULL);
#line 668 "../src/library.vala"
	_tmp49_ = _tmp48_;
#line 668 "../src/library.vala"
	g_debug ("library.vala:668: %s", _tmp49_);
#line 668 "../src/library.vala"
	_g_free0 (_tmp49_);
#line 668 "../src/library.vala"
	_g_free0 (_tmp47_);
#line 619 "../src/library.vala"
	_g_object_unref0 (eBookFile);
#line 619 "../src/library.vala"
	_g_free0 (eBookLocation);
#line 619 "../src/library.vala"
	_bookworm_app_book_unref0 (aBook);
#line 5394 "library.c"
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
#line 1251 "glib-2.0.vapi"
	if (separator == NULL) {
#line 1252 "glib-2.0.vapi"
		separator = "";
#line 5408 "library.c"
	}
#line 1254 "glib-2.0.vapi"
	if (str_array != NULL) {
#line 5412 "library.c"
		gboolean _tmp1_ = FALSE;
#line 1254 "glib-2.0.vapi"
		if (str_array_length1 > 0) {
#line 1254 "glib-2.0.vapi"
			_tmp1_ = TRUE;
#line 5418 "library.c"
		} else {
			gboolean _tmp2_ = FALSE;
#line 1254 "glib-2.0.vapi"
			if (str_array_length1 == -1) {
#line 5423 "library.c"
				const gchar* _tmp3_;
#line 1254 "glib-2.0.vapi"
				_tmp3_ = str_array[0];
#line 1254 "glib-2.0.vapi"
				_tmp2_ = _tmp3_ != NULL;
#line 5429 "library.c"
			} else {
#line 1254 "glib-2.0.vapi"
				_tmp2_ = FALSE;
#line 5433 "library.c"
			}
#line 1254 "glib-2.0.vapi"
			_tmp1_ = _tmp2_;
#line 5437 "library.c"
		}
#line 1254 "glib-2.0.vapi"
		_tmp0_ = _tmp1_;
#line 5441 "library.c"
	} else {
#line 1254 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 5445 "library.c"
	}
#line 1254 "glib-2.0.vapi"
	if (_tmp0_) {
#line 5449 "library.c"
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
#line 1256 "glib-2.0.vapi"
		len = (gsize) 1;
#line 5464 "library.c"
		{
			gboolean _tmp4_ = FALSE;
#line 1257 "glib-2.0.vapi"
			i = 0;
#line 1257 "glib-2.0.vapi"
			_tmp4_ = TRUE;
#line 1257 "glib-2.0.vapi"
			while (TRUE) {
#line 5473 "library.c"
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
#line 1257 "glib-2.0.vapi"
				if (!_tmp4_) {
#line 5480 "library.c"
					gint _tmp5_;
#line 1257 "glib-2.0.vapi"
					_tmp5_ = i;
#line 1257 "glib-2.0.vapi"
					i = _tmp5_ + 1;
#line 5486 "library.c"
				}
#line 1257 "glib-2.0.vapi"
				_tmp4_ = FALSE;
#line 1257 "glib-2.0.vapi"
				if (str_array_length1 != -1) {
#line 1257 "glib-2.0.vapi"
					_tmp7_ = i < str_array_length1;
#line 5494 "library.c"
				} else {
#line 1257 "glib-2.0.vapi"
					_tmp7_ = FALSE;
#line 5498 "library.c"
				}
#line 1257 "glib-2.0.vapi"
				if (_tmp7_) {
#line 1257 "glib-2.0.vapi"
					_tmp6_ = TRUE;
#line 5504 "library.c"
				} else {
					gboolean _tmp8_ = FALSE;
#line 1257 "glib-2.0.vapi"
					if (str_array_length1 == -1) {
#line 5509 "library.c"
						const gchar* _tmp9_;
#line 1257 "glib-2.0.vapi"
						_tmp9_ = str_array[i];
#line 1257 "glib-2.0.vapi"
						_tmp8_ = _tmp9_ != NULL;
#line 5515 "library.c"
					} else {
#line 1257 "glib-2.0.vapi"
						_tmp8_ = FALSE;
#line 5519 "library.c"
					}
#line 1257 "glib-2.0.vapi"
					_tmp6_ = _tmp8_;
#line 5523 "library.c"
				}
#line 1257 "glib-2.0.vapi"
				if (!_tmp6_) {
#line 1257 "glib-2.0.vapi"
					break;
#line 5529 "library.c"
				}
#line 1258 "glib-2.0.vapi"
				_tmp11_ = str_array[i];
#line 1258 "glib-2.0.vapi"
				if (_tmp11_ != NULL) {
#line 5535 "library.c"
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
#line 1258 "glib-2.0.vapi"
					_tmp12_ = str_array[i];
#line 1258 "glib-2.0.vapi"
					_tmp13_ = strlen ((const gchar*) _tmp12_);
#line 1258 "glib-2.0.vapi"
					_tmp14_ = _tmp13_;
#line 1258 "glib-2.0.vapi"
					_tmp10_ = _tmp14_;
#line 5547 "library.c"
				} else {
#line 1258 "glib-2.0.vapi"
					_tmp10_ = 0;
#line 5551 "library.c"
				}
#line 1258 "glib-2.0.vapi"
				len += (gsize) _tmp10_;
#line 5555 "library.c"
			}
		}
#line 1260 "glib-2.0.vapi"
		if (i == 0) {
#line 5560 "library.c"
			gchar* _tmp15_;
#line 1261 "glib-2.0.vapi"
			_tmp15_ = g_strdup ("");
#line 1261 "glib-2.0.vapi"
			result = _tmp15_;
#line 1261 "glib-2.0.vapi"
			return result;
#line 5568 "library.c"
		}
#line 1263 "glib-2.0.vapi"
		str_array_length1 = i;
#line 1264 "glib-2.0.vapi"
		_tmp16_ = strlen ((const gchar*) separator);
#line 1264 "glib-2.0.vapi"
		_tmp17_ = _tmp16_;
#line 1264 "glib-2.0.vapi"
		len += (gsize) (_tmp17_ * (i - 1));
#line 1266 "glib-2.0.vapi"
		_tmp18_ = g_malloc (len);
#line 1266 "glib-2.0.vapi"
		res = _tmp18_;
#line 1267 "glib-2.0.vapi"
		_tmp20_ = str_array[0];
#line 1267 "glib-2.0.vapi"
		if (_tmp20_ != NULL) {
#line 5586 "library.c"
			const gchar* _tmp21_;
#line 1267 "glib-2.0.vapi"
			_tmp21_ = str_array[0];
#line 1267 "glib-2.0.vapi"
			_tmp19_ = (const gchar*) _tmp21_;
#line 5592 "library.c"
		} else {
#line 1267 "glib-2.0.vapi"
			_tmp19_ = "";
#line 5596 "library.c"
		}
#line 1267 "glib-2.0.vapi"
		_tmp22_ = res;
#line 1267 "glib-2.0.vapi"
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
#line 1267 "glib-2.0.vapi"
		ptr = _tmp23_;
#line 5604 "library.c"
		{
			gboolean _tmp24_ = FALSE;
#line 1268 "glib-2.0.vapi"
			i = 1;
#line 1268 "glib-2.0.vapi"
			_tmp24_ = TRUE;
#line 1268 "glib-2.0.vapi"
			while (TRUE) {
#line 5613 "library.c"
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
#line 1268 "glib-2.0.vapi"
				if (!_tmp24_) {
#line 5622 "library.c"
					gint _tmp25_;
#line 1268 "glib-2.0.vapi"
					_tmp25_ = i;
#line 1268 "glib-2.0.vapi"
					i = _tmp25_ + 1;
#line 5628 "library.c"
				}
#line 1268 "glib-2.0.vapi"
				_tmp24_ = FALSE;
#line 1268 "glib-2.0.vapi"
				if (!(i < str_array_length1)) {
#line 1268 "glib-2.0.vapi"
					break;
#line 5636 "library.c"
				}
#line 1269 "glib-2.0.vapi"
				_tmp26_ = ptr;
#line 1269 "glib-2.0.vapi"
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
#line 1269 "glib-2.0.vapi"
				ptr = _tmp27_;
#line 1270 "glib-2.0.vapi"
				_tmp29_ = str_array[i];
#line 1270 "glib-2.0.vapi"
				if (_tmp29_ != NULL) {
#line 5648 "library.c"
					const gchar* _tmp30_;
#line 1270 "glib-2.0.vapi"
					_tmp30_ = str_array[i];
#line 1270 "glib-2.0.vapi"
					_tmp28_ = (const gchar*) _tmp30_;
#line 5654 "library.c"
				} else {
#line 1270 "glib-2.0.vapi"
					_tmp28_ = "";
#line 5658 "library.c"
				}
#line 1270 "glib-2.0.vapi"
				_tmp31_ = ptr;
#line 1270 "glib-2.0.vapi"
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
#line 1270 "glib-2.0.vapi"
				ptr = _tmp32_;
#line 5666 "library.c"
			}
		}
#line 1273 "glib-2.0.vapi"
		_tmp33_ = res;
#line 1273 "glib-2.0.vapi"
		res = NULL;
#line 1273 "glib-2.0.vapi"
		result = (gchar*) _tmp33_;
#line 1273 "glib-2.0.vapi"
		return result;
#line 5677 "library.c"
	} else {
		gchar* _tmp34_;
#line 1275 "glib-2.0.vapi"
		_tmp34_ = g_strdup ("");
#line 1275 "glib-2.0.vapi"
		result = _tmp34_;
#line 1275 "glib-2.0.vapi"
		return result;
#line 5686 "library.c"
	}
}

static Block25Data*
block25_data_ref (Block25Data* _data25_)
{
#line 694 "../src/library.vala"
	g_atomic_int_inc (&_data25_->_ref_count_);
#line 694 "../src/library.vala"
	return _data25_;
#line 5697 "library.c"
}

static void
block25_data_unref (void * _userdata_)
{
	Block25Data* _data25_;
	_data25_ = (Block25Data*) _userdata_;
#line 694 "../src/library.vala"
	if (g_atomic_int_dec_and_test (&_data25_->_ref_count_)) {
#line 694 "../src/library.vala"
		_g_object_unref0 (_data25_->listOfItersToBeRemoved);
#line 694 "../src/library.vala"
		g_slice_free (Block25Data, _data25_);
#line 5711 "library.c"
	}
}

static gboolean
___lambda40_ (Block25Data* _data25_,
              GtkTreeModel* model,
              GtkTreePath* path,
              GtkTreeIter* iter)
{
	GeeArrayList* _tmp0_;
	GtkTreeIter _tmp1_;
	gboolean result;
#line 702 "../src/library.vala"
	g_return_val_if_fail (model != NULL, FALSE);
#line 702 "../src/library.vala"
	g_return_val_if_fail (path != NULL, FALSE);
#line 702 "../src/library.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 703 "../src/library.vala"
	_tmp0_ = _data25_->listOfItersToBeRemoved;
#line 703 "../src/library.vala"
	_tmp1_ = *iter;
#line 703 "../src/library.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, &_tmp1_);
#line 704 "../src/library.vala"
	result = FALSE;
#line 704 "../src/library.vala"
	return result;
#line 5740 "library.c"
}

static gboolean
____lambda40__gtk_tree_model_foreach_func (GtkTreeModel* model,
                                           GtkTreePath* path,
                                           GtkTreeIter* iter,
                                           gpointer self)
{
	gboolean result;
	result = ___lambda40_ (self, model, path, iter);
#line 702 "../src/library.vala"
	return result;
#line 5753 "library.c"
}

void
bookworm_app_library_paginateLibrary (const gchar* library_search_data,
                                      const gchar* mode)
{
	GeeArrayList* _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
#line 670 "../src/library.vala"
	g_return_if_fail (library_search_data != NULL);
#line 670 "../src/library.vala"
	g_return_if_fail (mode != NULL);
#line 5767 "library.c"
	{
		GeeIterator* _book_it = NULL;
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
#line 672 "../src/library.vala"
		_tmp0_ = bookworm_app_bookworm_libraryViewMap;
#line 672 "../src/library.vala"
		_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
#line 672 "../src/library.vala"
		_tmp2_ = _tmp1_;
#line 672 "../src/library.vala"
		_tmp3_ = _tmp2_;
#line 672 "../src/library.vala"
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
#line 672 "../src/library.vala"
		_tmp5_ = _tmp4_;
#line 672 "../src/library.vala"
		_g_object_unref0 (_tmp3_);
#line 672 "../src/library.vala"
		_book_it = _tmp5_;
#line 672 "../src/library.vala"
		while (TRUE) {
#line 5794 "library.c"
			GeeIterator* _tmp6_;
			BookwormAppBook* book = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			BookwormAppBook* _tmp9_;
#line 672 "../src/library.vala"
			_tmp6_ = _book_it;
#line 672 "../src/library.vala"
			if (!gee_iterator_next (_tmp6_)) {
#line 672 "../src/library.vala"
				break;
#line 5806 "library.c"
			}
#line 672 "../src/library.vala"
			_tmp7_ = _book_it;
#line 672 "../src/library.vala"
			_tmp8_ = gee_iterator_get (_tmp7_);
#line 672 "../src/library.vala"
			book = (BookwormAppBook*) _tmp8_;
#line 673 "../src/library.vala"
			_tmp9_ = book;
#line 673 "../src/library.vala"
			if (bookworm_app_book_getWasBookOpened (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, BOOKWORM_APP_TYPE_BOOK, BookwormAppBook))) {
#line 5818 "library.c"
				BookwormAppBook* _tmp10_;
#line 674 "../src/library.vala"
				_tmp10_ = book;
#line 674 "../src/library.vala"
				bookworm_app_db_updateBookToDataBase (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, BOOKWORM_APP_TYPE_BOOK, BookwormAppBook));
#line 675 "../src/library.vala"
				g_debug ("library.vala:675: Completed saving the book data into DB");
#line 5826 "library.c"
			}
#line 672 "../src/library.vala"
			_bookworm_app_book_unref0 (book);
#line 5830 "library.c"
		}
#line 672 "../src/library.vala"
		_g_object_unref0 (_book_it);
#line 5834 "library.c"
	}
#line 678 "../src/library.vala"
	if (g_strcmp0 (mode, "LIBRARY_SEARCH") == 0) {
#line 5838 "library.c"
		gchar* _tmp11_;
		gchar* _tmp12_;
		GeeArrayList* _tmp13_;
#line 680 "../src/library.vala"
		_tmp11_ = g_strconcat ("Executing library search query with criteria: ", library_search_data, NULL);
#line 680 "../src/library.vala"
		_tmp12_ = _tmp11_;
#line 680 "../src/library.vala"
		g_debug ("library.vala:680: %s", _tmp12_);
#line 680 "../src/library.vala"
		_g_free0 (_tmp12_);
#line 681 "../src/library.vala"
		_tmp13_ = bookworm_app_db_getBooksFromDB (library_search_data, mode);
#line 681 "../src/library.vala"
		_g_object_unref0 (bookworm_app_library_listOfBooksInLibraryOnLoad);
#line 681 "../src/library.vala"
		bookworm_app_library_listOfBooksInLibraryOnLoad = _tmp13_;
#line 5856 "library.c"
	} else {
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		GeeArrayList* _tmp20_;
		gint _tmp21_ = 0;
		gpointer* _tmp22_;
		gchar** _tmp23_;
		gint _tmp23__length1;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		GeeArrayList* _tmp28_;
		gpointer _tmp29_;
		gchar* _tmp30_;
		GeeArrayList* _tmp31_;
#line 684 "../src/library.vala"
		_tmp14_ = g_strdup_printf ("%i", bookworm_app_bookworm_current_page_counter);
#line 684 "../src/library.vala"
		_tmp15_ = _tmp14_;
#line 684 "../src/library.vala"
		_tmp16_ = g_strconcat ("Executing paginated query for books with" " current_page_counter=", _tmp15_, NULL);
#line 684 "../src/library.vala"
		_tmp17_ = _tmp16_;
#line 684 "../src/library.vala"
		_tmp18_ = g_strconcat (_tmp17_, " on paginationlist:", NULL);
#line 684 "../src/library.vala"
		_tmp19_ = _tmp18_;
#line 684 "../src/library.vala"
		_tmp20_ = bookworm_app_bookworm_paginationlist;
#line 684 "../src/library.vala"
		_tmp22_ = gee_collection_to_array ((GeeCollection*) _tmp20_, &_tmp21_);
#line 684 "../src/library.vala"
		_tmp23_ = _tmp22_;
#line 684 "../src/library.vala"
		_tmp23__length1 = _tmp21_;
#line 684 "../src/library.vala"
		_tmp24_ = _vala_g_strjoinv (", ", _tmp23_, (gint) _tmp21_);
#line 684 "../src/library.vala"
		_tmp25_ = _tmp24_;
#line 684 "../src/library.vala"
		_tmp26_ = g_strconcat (_tmp19_, _tmp25_, NULL);
#line 684 "../src/library.vala"
		_tmp27_ = _tmp26_;
#line 684 "../src/library.vala"
		g_debug ("library.vala:684: %s", _tmp27_);
#line 684 "../src/library.vala"
		_g_free0 (_tmp27_);
#line 684 "../src/library.vala"
		_g_free0 (_tmp25_);
#line 684 "../src/library.vala"
		_tmp23_ = (_vala_array_free (_tmp23_, _tmp23__length1, (GDestroyNotify) g_free), NULL);
#line 684 "../src/library.vala"
		_g_free0 (_tmp19_);
#line 684 "../src/library.vala"
		_g_free0 (_tmp17_);
#line 684 "../src/library.vala"
		_g_free0 (_tmp15_);
#line 688 "../src/library.vala"
		_tmp28_ = bookworm_app_bookworm_paginationlist;
#line 688 "../src/library.vala"
		_tmp29_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, bookworm_app_bookworm_current_page_counter);
#line 688 "../src/library.vala"
		_tmp30_ = (gchar*) _tmp29_;
#line 688 "../src/library.vala"
		_tmp31_ = bookworm_app_db_getBooksFromDB (_tmp30_, mode);
#line 688 "../src/library.vala"
		_g_object_unref0 (bookworm_app_library_listOfBooksInLibraryOnLoad);
#line 688 "../src/library.vala"
		bookworm_app_library_listOfBooksInLibraryOnLoad = _tmp31_;
#line 688 "../src/library.vala"
		_g_free0 (_tmp30_);
#line 5933 "library.c"
	}
#line 694 "../src/library.vala"
	_tmp32_ = bookworm_app_library_listOfBooksInLibraryOnLoad;
#line 694 "../src/library.vala"
	_tmp33_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp32_);
#line 694 "../src/library.vala"
	_tmp34_ = _tmp33_;
#line 694 "../src/library.vala"
	if (_tmp34_ != 0) {
#line 5943 "library.c"
		Block25Data* _data25_;
		GList* children_grid = NULL;
		GtkFlowBox* _tmp35_;
		GList* _tmp36_;
		GList* _tmp37_;
		GeeArrayList* _tmp41_;
		GtkTreeModelForeachFunc print_row = NULL;
		gpointer print_row_target;
		GDestroyNotify print_row_target_destroy_notify;
		GtkListStore* _tmp42_;
		GtkTreeModelForeachFunc _tmp43_;
		gpointer _tmp43__target;
		GString* _tmp55_;
#line 694 "../src/library.vala"
		_data25_ = g_slice_new0 (Block25Data);
#line 694 "../src/library.vala"
		_data25_->_ref_count_ = 1;
#line 696 "../src/library.vala"
		_tmp35_ = bookworm_app_app_window_library_grid;
#line 696 "../src/library.vala"
		_tmp36_ = gtk_container_get_children ((GtkContainer*) _tmp35_);
#line 696 "../src/library.vala"
		children_grid = _tmp36_;
#line 697 "../src/library.vala"
		_tmp37_ = children_grid;
#line 5969 "library.c"
		{
			GList* element_collection = NULL;
			GList* element_it = NULL;
#line 697 "../src/library.vala"
			element_collection = _tmp37_;
#line 697 "../src/library.vala"
			for (element_it = element_collection; element_it != NULL; element_it = element_it->next) {
#line 5977 "library.c"
				GtkWidget* _tmp38_;
				GtkWidget* element = NULL;
#line 697 "../src/library.vala"
				_tmp38_ = _g_object_ref0 ((GtkWidget*) element_it->data);
#line 697 "../src/library.vala"
				element = _tmp38_;
#line 5984 "library.c"
				{
					GtkFlowBox* _tmp39_;
					GtkWidget* _tmp40_;
#line 698 "../src/library.vala"
					_tmp39_ = bookworm_app_app_window_library_grid;
#line 698 "../src/library.vala"
					_tmp40_ = element;
#line 698 "../src/library.vala"
					gtk_container_remove ((GtkContainer*) _tmp39_, _tmp40_);
#line 697 "../src/library.vala"
					_g_object_unref0 (element);
#line 5996 "library.c"
				}
			}
		}
#line 701 "../src/library.vala"
		_tmp41_ = gee_array_list_new (gtk_tree_iter_get_type (), (GBoxedCopyFunc) _vala_GtkTreeIter_copy, (GDestroyNotify) _vala_GtkTreeIter_free, NULL, NULL, NULL);
#line 701 "../src/library.vala"
		_data25_->listOfItersToBeRemoved = _tmp41_;
#line 702 "../src/library.vala"
		print_row = ____lambda40__gtk_tree_model_foreach_func;
#line 702 "../src/library.vala"
		print_row_target = block25_data_ref (_data25_);
#line 702 "../src/library.vala"
		print_row_target_destroy_notify = block25_data_unref;
#line 706 "../src/library.vala"
		_tmp42_ = bookworm_app_app_window_library_table_liststore;
#line 706 "../src/library.vala"
		_tmp43_ = print_row;
#line 706 "../src/library.vala"
		_tmp43__target = print_row_target;
#line 706 "../src/library.vala"
		gtk_tree_model_foreach ((GtkTreeModel*) _tmp42_, _tmp43_, _tmp43__target);
#line 6018 "library.c"
		{
			GeeArrayList* _iterToBeRemoved_list = NULL;
			GeeArrayList* _tmp44_;
			gint _iterToBeRemoved_size = 0;
			GeeArrayList* _tmp45_;
			gint _tmp46_;
			gint _tmp47_;
			gint _iterToBeRemoved_index = 0;
#line 707 "../src/library.vala"
			_tmp44_ = _data25_->listOfItersToBeRemoved;
#line 707 "../src/library.vala"
			_iterToBeRemoved_list = _tmp44_;
#line 707 "../src/library.vala"
			_tmp45_ = _iterToBeRemoved_list;
#line 707 "../src/library.vala"
			_tmp46_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp45_);
#line 707 "../src/library.vala"
			_tmp47_ = _tmp46_;
#line 707 "../src/library.vala"
			_iterToBeRemoved_size = _tmp47_;
#line 707 "../src/library.vala"
			_iterToBeRemoved_index = -1;
#line 707 "../src/library.vala"
			while (TRUE) {
#line 6043 "library.c"
				gint _tmp48_;
				gint _tmp49_;
				GtkTreeIter iterToBeRemoved = {0};
				GeeArrayList* _tmp50_;
				gpointer _tmp51_;
				GtkTreeIter* _tmp52_;
				GtkTreeIter _tmp53_;
				GtkListStore* _tmp54_;
#line 707 "../src/library.vala"
				_iterToBeRemoved_index = _iterToBeRemoved_index + 1;
#line 707 "../src/library.vala"
				_tmp48_ = _iterToBeRemoved_index;
#line 707 "../src/library.vala"
				_tmp49_ = _iterToBeRemoved_size;
#line 707 "../src/library.vala"
				if (!(_tmp48_ < _tmp49_)) {
#line 707 "../src/library.vala"
					break;
#line 6062 "library.c"
				}
#line 707 "../src/library.vala"
				_tmp50_ = _iterToBeRemoved_list;
#line 707 "../src/library.vala"
				_tmp51_ = gee_abstract_list_get ((GeeAbstractList*) _tmp50_, _iterToBeRemoved_index);
#line 707 "../src/library.vala"
				_tmp52_ = (GtkTreeIter*) _tmp51_;
#line 707 "../src/library.vala"
				_tmp53_ = *_tmp52_;
#line 707 "../src/library.vala"
				__vala_GtkTreeIter_free0 (_tmp52_);
#line 707 "../src/library.vala"
				iterToBeRemoved = _tmp53_;
#line 710 "../src/library.vala"
				_tmp54_ = bookworm_app_app_window_library_table_liststore;
#line 710 "../src/library.vala"
				gtk_list_store_remove (_tmp54_, &iterToBeRemoved);
#line 6080 "library.c"
			}
		}
#line 716 "../src/library.vala"
		_tmp55_ = bookworm_app_bookworm_pathsOfBooksInLibraryOnLoadStr;
#line 716 "../src/library.vala"
		g_string_erase (_tmp55_, (gssize) 0, (gssize) -1);
#line 718 "../src/library.vala"
		bookworm_app_library_updateLibraryViewFromDB (NULL, NULL);
#line 694 "../src/library.vala"
		(print_row_target_destroy_notify == NULL) ? NULL : (print_row_target_destroy_notify (print_row_target), NULL);
#line 694 "../src/library.vala"
		print_row = NULL;
#line 694 "../src/library.vala"
		print_row_target = NULL;
#line 694 "../src/library.vala"
		print_row_target_destroy_notify = NULL;
#line 694 "../src/library.vala"
		(children_grid == NULL) ? NULL : (children_grid = (g_list_free (children_grid), NULL));
#line 694 "../src/library.vala"
		block25_data_unref (_data25_);
#line 694 "../src/library.vala"
		_data25_ = NULL;
#line 6103 "library.c"
	}
#line 722 "../src/library.vala"
	bookworm_app_app_window_handleLibraryPageButtons ("", FALSE);
#line 6107 "library.c"
}

BookwormAppLibrary*
bookworm_app_library_construct (GType object_type)
{
	BookwormAppLibrary* self = NULL;
#line 21 "../src/library.vala"
	self = (BookwormAppLibrary*) g_type_create_instance (object_type);
#line 21 "../src/library.vala"
	return self;
#line 6118 "library.c"
}

BookwormAppLibrary*
bookworm_app_library_new (void)
{
#line 21 "../src/library.vala"
	return bookworm_app_library_construct (BOOKWORM_APP_TYPE_LIBRARY);
#line 6126 "library.c"
}

static void
bookworm_app_value_library_init (GValue* value)
{
#line 21 "../src/library.vala"
	value->data[0].v_pointer = NULL;
#line 6134 "library.c"
}

static void
bookworm_app_value_library_free_value (GValue* value)
{
#line 21 "../src/library.vala"
	if (value->data[0].v_pointer) {
#line 21 "../src/library.vala"
		bookworm_app_library_unref (value->data[0].v_pointer);
#line 6144 "library.c"
	}
}

static void
bookworm_app_value_library_copy_value (const GValue* src_value,
                                       GValue* dest_value)
{
#line 21 "../src/library.vala"
	if (src_value->data[0].v_pointer) {
#line 21 "../src/library.vala"
		dest_value->data[0].v_pointer = bookworm_app_library_ref (src_value->data[0].v_pointer);
#line 6156 "library.c"
	} else {
#line 21 "../src/library.vala"
		dest_value->data[0].v_pointer = NULL;
#line 6160 "library.c"
	}
}

static gpointer
bookworm_app_value_library_peek_pointer (const GValue* value)
{
#line 21 "../src/library.vala"
	return value->data[0].v_pointer;
#line 6169 "library.c"
}

static gchar*
bookworm_app_value_library_collect_value (GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
#line 21 "../src/library.vala"
	if (collect_values[0].v_pointer) {
#line 6180 "library.c"
		BookwormAppLibrary * object;
		object = collect_values[0].v_pointer;
#line 21 "../src/library.vala"
		if (object->parent_instance.g_class == NULL) {
#line 21 "../src/library.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 6187 "library.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 21 "../src/library.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 6191 "library.c"
		}
#line 21 "../src/library.vala"
		value->data[0].v_pointer = bookworm_app_library_ref (object);
#line 6195 "library.c"
	} else {
#line 21 "../src/library.vala"
		value->data[0].v_pointer = NULL;
#line 6199 "library.c"
	}
#line 21 "../src/library.vala"
	return NULL;
#line 6203 "library.c"
}

static gchar*
bookworm_app_value_library_lcopy_value (const GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	BookwormAppLibrary ** object_p;
	object_p = collect_values[0].v_pointer;
#line 21 "../src/library.vala"
	if (!object_p) {
#line 21 "../src/library.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 6218 "library.c"
	}
#line 21 "../src/library.vala"
	if (!value->data[0].v_pointer) {
#line 21 "../src/library.vala"
		*object_p = NULL;
#line 6224 "library.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 21 "../src/library.vala"
		*object_p = value->data[0].v_pointer;
#line 6228 "library.c"
	} else {
#line 21 "../src/library.vala"
		*object_p = bookworm_app_library_ref (value->data[0].v_pointer);
#line 6232 "library.c"
	}
#line 21 "../src/library.vala"
	return NULL;
#line 6236 "library.c"
}

GParamSpec*
bookworm_app_param_spec_library (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags)
{
	BookwormAppParamSpecLibrary* spec;
#line 21 "../src/library.vala"
	g_return_val_if_fail (g_type_is_a (object_type, BOOKWORM_APP_TYPE_LIBRARY), NULL);
#line 21 "../src/library.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 21 "../src/library.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 21 "../src/library.vala"
	return G_PARAM_SPEC (spec);
#line 6255 "library.c"
}

gpointer
bookworm_app_value_get_library (const GValue* value)
{
#line 21 "../src/library.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_LIBRARY), NULL);
#line 21 "../src/library.vala"
	return value->data[0].v_pointer;
#line 6265 "library.c"
}

void
bookworm_app_value_set_library (GValue* value,
                                gpointer v_object)
{
	BookwormAppLibrary * old;
#line 21 "../src/library.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_LIBRARY));
#line 21 "../src/library.vala"
	old = value->data[0].v_pointer;
#line 21 "../src/library.vala"
	if (v_object) {
#line 21 "../src/library.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOOKWORM_APP_TYPE_LIBRARY));
#line 21 "../src/library.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 21 "../src/library.vala"
		value->data[0].v_pointer = v_object;
#line 21 "../src/library.vala"
		bookworm_app_library_ref (value->data[0].v_pointer);
#line 6287 "library.c"
	} else {
#line 21 "../src/library.vala"
		value->data[0].v_pointer = NULL;
#line 6291 "library.c"
	}
#line 21 "../src/library.vala"
	if (old) {
#line 21 "../src/library.vala"
		bookworm_app_library_unref (old);
#line 6297 "library.c"
	}
}

void
bookworm_app_value_take_library (GValue* value,
                                 gpointer v_object)
{
	BookwormAppLibrary * old;
#line 21 "../src/library.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_LIBRARY));
#line 21 "../src/library.vala"
	old = value->data[0].v_pointer;
#line 21 "../src/library.vala"
	if (v_object) {
#line 21 "../src/library.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOOKWORM_APP_TYPE_LIBRARY));
#line 21 "../src/library.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 21 "../src/library.vala"
		value->data[0].v_pointer = v_object;
#line 6318 "library.c"
	} else {
#line 21 "../src/library.vala"
		value->data[0].v_pointer = NULL;
#line 6322 "library.c"
	}
#line 21 "../src/library.vala"
	if (old) {
#line 21 "../src/library.vala"
		bookworm_app_library_unref (old);
#line 6328 "library.c"
	}
}

static void
bookworm_app_library_class_init (BookwormAppLibraryClass * klass,
                                 gpointer klass_data)
{
	GeeArrayList* _tmp0_;
#line 21 "../src/library.vala"
	bookworm_app_library_parent_class = g_type_class_peek_parent (klass);
#line 21 "../src/library.vala"
	((BookwormAppLibraryClass *) klass)->finalize = bookworm_app_library_finalize;
#line 22 "../src/library.vala"
	_tmp0_ = gee_array_list_new (BOOKWORM_APP_TYPE_BOOK, (GBoxedCopyFunc) bookworm_app_book_ref, (GDestroyNotify) bookworm_app_book_unref, NULL, NULL, NULL);
#line 22 "../src/library.vala"
	bookworm_app_library_listOfBooksInLibraryOnLoad = _tmp0_;
#line 6345 "library.c"
}

static void
bookworm_app_library_instance_init (BookwormAppLibrary * self,
                                    gpointer klass)
{
#line 21 "../src/library.vala"
	self->ref_count = 1;
#line 6354 "library.c"
}

static void
bookworm_app_library_finalize (BookwormAppLibrary * obj)
{
	BookwormAppLibrary * self;
#line 21 "../src/library.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOOKWORM_APP_TYPE_LIBRARY, BookwormAppLibrary);
#line 21 "../src/library.vala"
	g_signal_handlers_destroy (self);
#line 6365 "library.c"
}

static GType
bookworm_app_library_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { bookworm_app_value_library_init, bookworm_app_value_library_free_value, bookworm_app_value_library_copy_value, bookworm_app_value_library_peek_pointer, "p", bookworm_app_value_library_collect_value, "p", bookworm_app_value_library_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BookwormAppLibraryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bookworm_app_library_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BookwormAppLibrary), 0, (GInstanceInitFunc) bookworm_app_library_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType bookworm_app_library_type_id;
	bookworm_app_library_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BookwormAppLibrary", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return bookworm_app_library_type_id;
}

GType
bookworm_app_library_get_type (void)
{
	static volatile gsize bookworm_app_library_type_id__once = 0;
	if (g_once_init_enter (&bookworm_app_library_type_id__once)) {
		GType bookworm_app_library_type_id;
		bookworm_app_library_type_id = bookworm_app_library_get_type_once ();
		g_once_init_leave (&bookworm_app_library_type_id__once, bookworm_app_library_type_id);
	}
	return bookworm_app_library_type_id__once;
}

gpointer
bookworm_app_library_ref (gpointer instance)
{
	BookwormAppLibrary * self;
	self = instance;
#line 21 "../src/library.vala"
	g_atomic_int_inc (&self->ref_count);
#line 21 "../src/library.vala"
	return instance;
#line 6400 "library.c"
}

void
bookworm_app_library_unref (gpointer instance)
{
	BookwormAppLibrary * self;
	self = instance;
#line 21 "../src/library.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 21 "../src/library.vala"
		BOOKWORM_APP_LIBRARY_GET_CLASS (self)->finalize (self);
#line 21 "../src/library.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 6414 "library.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

