// Code generated by generate_multiplexer.go; DO NOT EDIT.

package logging

import (
	"net"
	"time"
)

func NewMultiplexedConnectionTracer(tracers ...*ConnectionTracer) *ConnectionTracer {
	if len(tracers) == 0 {
		return nil
	}
	if len(tracers) == 1 {
		return tracers[0]
	}
	return &ConnectionTracer{
		StartedConnection: func(local net.Addr, remote net.Addr, srcConnID ConnectionID, destConnID ConnectionID) {
			for _, t := range tracers {
				if t.StartedConnection != nil {
					t.StartedConnection(local, remote, srcConnID, destConnID)
				}
			}
		},
		NegotiatedVersion: func(chosen Version, clientVersions []Version, serverVersions []Version) {
			for _, t := range tracers {
				if t.NegotiatedVersion != nil {
					t.NegotiatedVersion(chosen, clientVersions, serverVersions)
				}
			}
		},
		ClosedConnection: func(err error) {
			for _, t := range tracers {
				if t.ClosedConnection != nil {
					t.ClosedConnection(err)
				}
			}
		},
		SentTransportParameters: func(parameters *TransportParameters) {
			for _, t := range tracers {
				if t.SentTransportParameters != nil {
					t.SentTransportParameters(parameters)
				}
			}
		},
		ReceivedTransportParameters: func(parameters *TransportParameters) {
			for _, t := range tracers {
				if t.ReceivedTransportParameters != nil {
					t.ReceivedTransportParameters(parameters)
				}
			}
		},
		RestoredTransportParameters: func(parameters *TransportParameters) {
			for _, t := range tracers {
				if t.RestoredTransportParameters != nil {
					t.RestoredTransportParameters(parameters)
				}
			}
		},
		SentLongHeaderPacket: func(hdr *ExtendedHeader, size ByteCount, ecn ECN, ack *AckFrame, frames []Frame) {
			for _, t := range tracers {
				if t.SentLongHeaderPacket != nil {
					t.SentLongHeaderPacket(hdr, size, ecn, ack, frames)
				}
			}
		},
		SentShortHeaderPacket: func(hdr *ShortHeader, size ByteCount, ecn ECN, ack *AckFrame, frames []Frame) {
			for _, t := range tracers {
				if t.SentShortHeaderPacket != nil {
					t.SentShortHeaderPacket(hdr, size, ecn, ack, frames)
				}
			}
		},
		ReceivedVersionNegotiationPacket: func(dest ArbitraryLenConnectionID, src ArbitraryLenConnectionID, versions []Version) {
			for _, t := range tracers {
				if t.ReceivedVersionNegotiationPacket != nil {
					t.ReceivedVersionNegotiationPacket(dest, src, versions)
				}
			}
		},
		ReceivedRetry: func(hdr *Header) {
			for _, t := range tracers {
				if t.ReceivedRetry != nil {
					t.ReceivedRetry(hdr)
				}
			}
		},
		ReceivedLongHeaderPacket: func(hdr *ExtendedHeader, size ByteCount, ecn ECN, frames []Frame) {
			for _, t := range tracers {
				if t.ReceivedLongHeaderPacket != nil {
					t.ReceivedLongHeaderPacket(hdr, size, ecn, frames)
				}
			}
		},
		ReceivedShortHeaderPacket: func(hdr *ShortHeader, size ByteCount, ecn ECN, frames []Frame) {
			for _, t := range tracers {
				if t.ReceivedShortHeaderPacket != nil {
					t.ReceivedShortHeaderPacket(hdr, size, ecn, frames)
				}
			}
		},
		BufferedPacket: func(packetType PacketType, size ByteCount) {
			for _, t := range tracers {
				if t.BufferedPacket != nil {
					t.BufferedPacket(packetType, size)
				}
			}
		},
		DroppedPacket: func(packetType PacketType, pn PacketNumber, size ByteCount, reason PacketDropReason) {
			for _, t := range tracers {
				if t.DroppedPacket != nil {
					t.DroppedPacket(packetType, pn, size, reason)
				}
			}
		},
		UpdatedMetrics: func(rttStats *RTTStats, cwnd ByteCount, bytesInFlight ByteCount, packetsInFlight int) {
			for _, t := range tracers {
				if t.UpdatedMetrics != nil {
					t.UpdatedMetrics(rttStats, cwnd, bytesInFlight, packetsInFlight)
				}
			}
		},
		AcknowledgedPacket: func(encLevel EncryptionLevel, pn PacketNumber) {
			for _, t := range tracers {
				if t.AcknowledgedPacket != nil {
					t.AcknowledgedPacket(encLevel, pn)
				}
			}
		},
		LostPacket: func(encLevel EncryptionLevel, pn PacketNumber, reason PacketLossReason) {
			for _, t := range tracers {
				if t.LostPacket != nil {
					t.LostPacket(encLevel, pn, reason)
				}
			}
		},
		UpdatedMTU: func(mtu ByteCount, done bool) {
			for _, t := range tracers {
				if t.UpdatedMTU != nil {
					t.UpdatedMTU(mtu, done)
				}
			}
		},
		UpdatedCongestionState: func(state CongestionState) {
			for _, t := range tracers {
				if t.UpdatedCongestionState != nil {
					t.UpdatedCongestionState(state)
				}
			}
		},
		UpdatedPTOCount: func(value uint32) {
			for _, t := range tracers {
				if t.UpdatedPTOCount != nil {
					t.UpdatedPTOCount(value)
				}
			}
		},
		UpdatedKeyFromTLS: func(encLevel EncryptionLevel, p Perspective) {
			for _, t := range tracers {
				if t.UpdatedKeyFromTLS != nil {
					t.UpdatedKeyFromTLS(encLevel, p)
				}
			}
		},
		UpdatedKey: func(keyPhase KeyPhase, remote bool) {
			for _, t := range tracers {
				if t.UpdatedKey != nil {
					t.UpdatedKey(keyPhase, remote)
				}
			}
		},
		DroppedEncryptionLevel: func(encLevel EncryptionLevel) {
			for _, t := range tracers {
				if t.DroppedEncryptionLevel != nil {
					t.DroppedEncryptionLevel(encLevel)
				}
			}
		},
		DroppedKey: func(keyPhase KeyPhase) {
			for _, t := range tracers {
				if t.DroppedKey != nil {
					t.DroppedKey(keyPhase)
				}
			}
		},
		SetLossTimer: func(timerType TimerType, encLevel EncryptionLevel, time time.Time) {
			for _, t := range tracers {
				if t.SetLossTimer != nil {
					t.SetLossTimer(timerType, encLevel, time)
				}
			}
		},
		LossTimerExpired: func(timerType TimerType, encLevel EncryptionLevel) {
			for _, t := range tracers {
				if t.LossTimerExpired != nil {
					t.LossTimerExpired(timerType, encLevel)
				}
			}
		},
		LossTimerCanceled: func() {
			for _, t := range tracers {
				if t.LossTimerCanceled != nil {
					t.LossTimerCanceled()
				}
			}
		},
		ECNStateUpdated: func(state ECNState, trigger ECNStateTrigger) {
			for _, t := range tracers {
				if t.ECNStateUpdated != nil {
					t.ECNStateUpdated(state, trigger)
				}
			}
		},
		ChoseALPN: func(protocol string) {
			for _, t := range tracers {
				if t.ChoseALPN != nil {
					t.ChoseALPN(protocol)
				}
			}
		},
		Close: func() {
			for _, t := range tracers {
				if t.Close != nil {
					t.Close()
				}
			}
		},
		Debug: func(name string, msg string) {
			for _, t := range tracers {
				if t.Debug != nil {
					t.Debug(name, msg)
				}
			}
		},
	}
}
