// Generated from libavcodec/vulkan/ffv1_enc.comp
const char *ff_source_ffv1_enc_comp =
"/*\n"
" * FFv1 codec\n"
" *\n"
" * Copyright (c) 2024 Lynne <dev@lynne.ee>\n"
" *\n"
" * This file is part of FFmpeg.\n"
" *\n"
" * FFmpeg is free software; you can redistribute it and/or\n"
" * modify it under the terms of the GNU Lesser General Public\n"
" * License as published by the Free Software Foundation; either\n"
" * version 2.1 of the License, or (at your option) any later version.\n"
" *\n"
" * FFmpeg is distributed in the hope that it will be useful,\n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n"
" * Lesser General Public License for more details.\n"
" *\n"
" * You should have received a copy of the GNU Lesser General Public\n"
" * License along with FFmpeg; if not, write to the Free Software\n"
" * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA\n"
" */\n"
"\n"
"#ifndef GOLOMB\n"
"#ifdef CACHED_SYMBOL_READER\n"
"shared uint8_t state[CONTEXT_SIZE];\n"
"#define WRITE(c, off, val) put_rac_direct(c, state[off], val)\n"
"#else\n"
"#define WRITE(c, off, val) put_rac(c, uint64_t(slice_state) + (state_off + off), val)\n"
"#endif\n"
"\n"
"/* Note - only handles signed values */\n"
"void put_symbol(inout RangeCoder c, uint state_off, int v)\n"
"{\n"
"    bool is_nil = (v == 0);\n"
"    WRITE(c, 0, is_nil);\n"
"    if (is_nil)\n"
"        return;\n"
"\n"
"    const int a = abs(v);\n"
"    const int e = findMSB(a);\n"
"\n"
"    for (int i = 0; i < e; i++)\n"
"        WRITE(c, 1 + min(i, 9), true);\n"
"    WRITE(c, 1 + min(e, 9), false);\n"
"\n"
"    for (int i = e - 1; i >= 0; i--)\n"
"        WRITE(c, 22 + min(i, 9), bool(bitfieldExtract(a, i, 1)));\n"
"\n"
"    WRITE(c, 22 - 11 + min(e, 10), v < 0);\n"
"}\n"
"\n"
"void encode_line_pcm(inout SliceContext sc, readonly uimage2D img,\n"
"                     ivec2 sp, int y, int p, int comp, int bits)\n"
"{\n"
"    int w = sc.slice_dim.x;\n"
"\n"
"#ifdef CACHED_SYMBOL_READER\n"
"    if (gl_LocalInvocationID.x > 0)\n"
"        return;\n"
"#endif\n"
"\n"
"#ifndef RGB\n"
"    if (p > 0 && p < 3) {\n"
"        w >>= chroma_shift.x;\n"
"        sp >>= chroma_shift;\n"
"    }\n"
"#endif\n"
"\n"
"    for (int x = 0; x < w; x++) {\n"
"        uint v = imageLoad(img, sp + LADDR(ivec2(x, y)))[comp];\n"
"        for (int i = (bits - 1); i >= 0; i--)\n"
"            put_rac_equi(sc.c, bool(bitfieldExtract(v, i, 1)));\n"
"    }\n"
"}\n"
"\n"
"void encode_line(inout SliceContext sc, readonly uimage2D img, uint state_off,\n"
"                 ivec2 sp, int y, int p, int comp, int bits,\n"
"                 uint8_t quant_table_idx, const int run_index)\n"
"{\n"
"    int w = sc.slice_dim.x;\n"
"\n"
"#ifndef RGB\n"
"    if (p > 0 && p < 3) {\n"
"        w >>= chroma_shift.x;\n"
"        sp >>= chroma_shift;\n"
"    }\n"
"#endif\n"
"\n"
"    for (int x = 0; x < w; x++) {\n"
"        ivec2 d = get_pred(img, sp, ivec2(x, y), comp, w,\n"
"                           quant_table_idx, extend_lookup[quant_table_idx] > 0);\n"
"        d[1] = int(imageLoad(img, sp + LADDR(ivec2(x, y)))[comp]) - d[1];\n"
"\n"
"        if (d[0] < 0)\n"
"            d = -d;\n"
"\n"
"        d[1] = fold(d[1], bits);\n"
"\n"
"        uint context_off = state_off + CONTEXT_SIZE*d[0];\n"
"#ifdef CACHED_SYMBOL_READER\n"
"        u8buf sb = u8buf(uint64_t(slice_state) + context_off + gl_LocalInvocationID.x);\n"
"        state[gl_LocalInvocationID.x] = sb.v;\n"
"        barrier();\n"
"        if (gl_LocalInvocationID.x == 0)\n"
"#endif\n"
"\n"
"            put_symbol(sc.c, context_off, d[1]);\n"
"\n"
"#ifdef CACHED_SYMBOL_READER\n"
"        barrier();\n"
"        sb.v = state[gl_LocalInvocationID.x];\n"
"#endif\n"
"    }\n"
"}\n"
"\n"
"#else /* GOLOMB */\n"
"\n"
"void encode_line(inout SliceContext sc, readonly uimage2D img, uint state_off,\n"
"                 ivec2 sp, int y, int p, int comp, int bits,\n"
"                 uint8_t quant_table_idx, inout int run_index)\n"
"{\n"
"    int w = sc.slice_dim.x;\n"
"\n"
"#ifndef RGB\n"
"    if (p > 0 && p < 3) {\n"
"        w >>= chroma_shift.x;\n"
"        sp >>= chroma_shift;\n"
"    }\n"
"#endif\n"
"\n"
"    int run_count = 0;\n"
"    bool run_mode = false;\n"
"\n"
"    for (int x = 0; x < w; x++) {\n"
"        ivec2 d = get_pred(img, sp, ivec2(x, y), comp, w,\n"
"                           quant_table_idx, extend_lookup[quant_table_idx] > 0);\n"
"        d[1] = int(imageLoad(img, sp + LADDR(ivec2(x, y)))[comp]) - d[1];\n"
"\n"
"        if (d[0] < 0)\n"
"            d = -d;\n"
"\n"
"        d[1] = fold(d[1], bits);\n"
"\n"
"        if (d[0] == 0)\n"
"            run_mode = true;\n"
"\n"
"        if (run_mode) {\n"
"            if (d[1] != 0) {\n"
"                /* A very unlikely loop */\n"
"                while (run_count >= 1 << log2_run[run_index]) {\n"
"                    run_count -= 1 << log2_run[run_index];\n"
"                    run_index++;\n"
"                    put_bits(sc.pb, 1, 1);\n"
"                }\n"
"\n"
"                put_bits(sc.pb, 1 + log2_run[run_index], run_count);\n"
"                if (run_index != 0)\n"
"                    run_index--;\n"
"                run_count = 0;\n"
"                run_mode  = false;\n"
"                if (d[1] > 0)\n"
"                    d[1]--;\n"
"            } else {\n"
"                run_count++;\n"
"            }\n"
"        }\n"
"\n"
"        if (!run_mode) {\n"
"            VlcState sb = VlcState(uint64_t(slice_state) + state_off + VLC_STATE_SIZE*d[0]);\n"
"            Symbol sym = get_vlc_symbol(sb, d[1], bits);\n"
"            put_bits(sc.pb, sym.bits, sym.val);\n"
"        }\n"
"    }\n"
"\n"
"    if (run_mode) {\n"
"        while (run_count >= (1 << log2_run[run_index])) {\n"
"            run_count -= 1 << log2_run[run_index];\n"
"            run_index++;\n"
"            put_bits(sc.pb, 1, 1);\n"
"        }\n"
"\n"
"        if (run_count > 0)\n"
"            put_bits(sc.pb, 1, 1);\n"
"    }\n"
"}\n"
"#endif\n"
"\n"
"#ifdef RGB\n"
"ivec4 load_components(ivec2 pos)\n"
"{\n"
"    ivec4 pix = ivec4(imageLoad(src[0], pos));\n"
"    if (planar_rgb != 0) {\n"
"        for (int i = 1; i < (3 + transparency); i++)\n"
"            pix[i] = int(imageLoad(src[i], pos)[0]);\n"
"    }\n"
"\n"
"    return ivec4(pix[fmt_lut[0]], pix[fmt_lut[1]],\n"
"                 pix[fmt_lut[2]], pix[fmt_lut[3]]);\n"
"}\n"
"\n"
"void transform_sample(inout ivec4 pix, ivec2 rct_coef)\n"
"{\n"
"    pix.b -= pix.g;\n"
"    pix.r -= pix.g;\n"
"    pix.g += (pix.r*rct_coef.x + pix.b*rct_coef.y) >> 2;\n"
"    pix.b += rct_offset;\n"
"    pix.r += rct_offset;\n"
"}\n"
"\n"
"void preload_rgb(in SliceContext sc, ivec2 sp, int w, int y, bool apply_rct)\n"
"{\n"
"    for (uint x = gl_LocalInvocationID.x; x < w; x += gl_WorkGroupSize.x) {\n"
"        ivec2 lpos = sp + LADDR(ivec2(x, y));\n"
"        ivec2 pos = sc.slice_pos + ivec2(x, y);\n"
"\n"
"        ivec4 pix = load_components(pos);\n"
"\n"
"        if (expectEXT(apply_rct, true))\n"
"            transform_sample(pix, sc.slice_rct_coef);\n"
"\n"
"        imageStore(tmp, lpos, pix);\n"
"    }\n"
"}\n"
"#endif\n"
"\n"
"void encode_slice(inout SliceContext sc, const uint slice_idx)\n"
"{\n"
"    ivec2 sp = sc.slice_pos;\n"
"\n"
"#ifndef RGB\n"
"    int bits = bits_per_raw_sample;\n"
"#else\n"
"    int bits = 9;\n"
"    if (bits != 8 || sc.slice_coding_mode != 0)\n"
"        bits = bits_per_raw_sample + int(sc.slice_coding_mode != 1);\n"
"\n"
"    sp.y = int(gl_WorkGroupID.y)*RGB_LINECACHE;\n"
"#endif\n"
"\n"
"#ifndef GOLOMB\n"
"    if (sc.slice_coding_mode == 1) {\n"
"#ifndef RGB\n"
"        for (int c = 0; c < components; c++) {\n"
"\n"
"            int h = sc.slice_dim.y;\n"
"            if (c > 0 && c < 3)\n"
"                h >>= chroma_shift.y;\n"
"\n"
"            /* Takes into account dual-plane YUV formats */\n"
"            int p = min(c, planes - 1);\n"
"            int comp = c - p;\n"
"\n"
"            for (int y = 0; y < h; y++)\n"
"                encode_line_pcm(sc, src[p], sp, y, p, comp, bits);\n"
"        }\n"
"#else\n"
"        for (int y = 0; y < sc.slice_dim.y; y++) {\n"
"            preload_rgb(sc, sp, sc.slice_dim.x, y, false);\n"
"\n"
"            encode_line_pcm(sc, tmp, sp, y, 0, 1, bits);\n"
"            encode_line_pcm(sc, tmp, sp, y, 0, 2, bits);\n"
"            encode_line_pcm(sc, tmp, sp, y, 0, 0, bits);\n"
"            if (transparency == 1)\n"
"                encode_line_pcm(sc, tmp, sp, y, 0, 3, bits);\n"
"        }\n"
"#endif\n"
"    } else\n"
"#endif\n"
"    {\n"
"        u8vec4 quant_table_idx = sc.quant_table_idx.xyyz;\n"
"        u32vec4 slice_state_off = (slice_idx*codec_planes + uvec4(0, 1, 1, 2))*plane_state_size;\n"
"\n"
"#ifndef RGB\n"
"        for (int c = 0; c < components; c++) {\n"
"            int run_index = 0;\n"
"\n"
"            int h = sc.slice_dim.y;\n"
"            if (c > 0 && c < 3)\n"
"                h >>= chroma_shift.y;\n"
"\n"
"            int p = min(c, planes - 1);\n"
"            int comp = c - p;\n"
"\n"
"            for (int y = 0; y < h; y++)\n"
"                encode_line(sc, src[p], slice_state_off[c], sp, y, p,\n"
"                            comp, bits, quant_table_idx[c], run_index);\n"
"        }\n"
"#else\n"
"        int run_index = 0;\n"
"        for (int y = 0; y < sc.slice_dim.y; y++) {\n"
"            preload_rgb(sc, sp, sc.slice_dim.x, y, true);\n"
"\n"
"            encode_line(sc, tmp, slice_state_off[0],\n"
"                        sp, y, 0, 1, bits, quant_table_idx[0], run_index);\n"
"            encode_line(sc, tmp, slice_state_off[1],\n"
"                        sp, y, 0, 2, bits, quant_table_idx[1], run_index);\n"
"            encode_line(sc, tmp, slice_state_off[2],\n"
"                        sp, y, 0, 0, bits, quant_table_idx[2], run_index);\n"
"            if (transparency == 1)\n"
"                encode_line(sc, tmp, slice_state_off[3],\n"
"                            sp, y, 0, 3, bits, quant_table_idx[3], run_index);\n"
"        }\n"
"#endif\n"
"    }\n"
"}\n"
"\n"
"void finalize_slice(inout SliceContext sc, const uint slice_idx)\n"
"{\n"
"#ifdef CACHED_SYMBOL_READER\n"
"    if (gl_LocalInvocationID.x > 0)\n"
"        return;\n"
"#endif\n"
"\n"
"#ifdef GOLOMB\n"
"    uint32_t enc_len = sc.hdr_len + flush_put_bits(sc.pb);\n"
"#else\n"
"    uint32_t enc_len = rac_terminate(sc.c);\n"
"#endif\n"
"\n"
"    u8buf bs = u8buf(sc.c.bytestream_start);\n"
"\n"
"    /* Append slice length */\n"
"    u8vec4 enc_len_p = unpack8(enc_len);\n"
"    bs[enc_len + 0].v = enc_len_p.z;\n"
"    bs[enc_len + 1].v = enc_len_p.y;\n"
"    bs[enc_len + 2].v = enc_len_p.x;\n"
"    enc_len += 3;\n"
"\n"
"    /* Calculate and write CRC */\n"
"    if (ec != 0) {\n"
"        bs[enc_len].v = uint8_t(0);\n"
"        enc_len++;\n"
"\n"
"        uint32_t crc = crcref;\n"
"        for (int i = 0; i < enc_len; i++)\n"
"            crc = crc_ieee[(crc & 0xFF) ^ uint32_t(bs[i].v)] ^ (crc >> 8);\n"
"\n"
"        if (crcref != 0x00000000)\n"
"            crc ^= 0x8CD88196;\n"
"\n"
"        u8vec4 crc_p = unpack8(crc);\n"
"        bs[enc_len + 0].v = crc_p.x;\n"
"        bs[enc_len + 1].v = crc_p.y;\n"
"        bs[enc_len + 2].v = crc_p.z;\n"
"        bs[enc_len + 3].v = crc_p.w;\n"
"        enc_len += 4;\n"
"    }\n"
"\n"
"    slice_results[slice_idx*2 + 0] = enc_len;\n"
"    slice_results[slice_idx*2 + 1] = uint64_t(bs) - uint64_t(out_data);\n"
"}\n"
"\n"
"void main(void)\n"
"{\n"
"    const uint slice_idx = gl_WorkGroupID.y*gl_NumWorkGroups.x + gl_WorkGroupID.x;\n"
"    encode_slice(slice_ctx[slice_idx], slice_idx);\n"
"    finalize_slice(slice_ctx[slice_idx], slice_idx);\n"
"}\n"
;
