//
// Automatically generated by ipdlc.
// Edit at your own risk
//

#ifndef LayersMessages_h
#define LayersMessages_h

#include "mozilla/Attributes.h"
#include "IPCMessageStart.h"
#include "mozilla/RefPtr.h"
#include "nsString.h"
#include "nsTArray.h"
#include "nsTHashtable.h"
#include "mozilla/MozPromise.h"
#include "mozilla/OperatorNewExtensions.h"
#include "mozilla/UniquePtr.h"
#include "mozilla/ipc/ByteBuf.h"
#include "mozilla/ipc/FileDescriptor.h"
#include "mozilla/ipc/IPCForwards.h"
#include "mozilla/ipc/Shmem.h"

// Headers for typedefs
#include "ImageContainer.h"
#include "NonCustomCSSPropertyId.h"
#include "Units.h"
#include "mozilla/HalIPCUtils.h"
#include "mozilla/ServoStyleConsts.h"
#include "mozilla/TimeStamp.h"
#include "mozilla/WidgetUtils.h"
#include "mozilla/gfx/2D.h"
#include "mozilla/gfx/Matrix.h"
#include "mozilla/gfx/Point.h"
#include "mozilla/gfx/Types.h"
#include "mozilla/ipc/CrossProcessSemaphore.h"
#include "mozilla/ipc/IPDLStructMember.h"
#include "mozilla/ipc/SideVariant.h"
#include "mozilla/layers/CompositorTypes.h"
#include "mozilla/layers/LayersTypes.h"
#include "mozilla/layers/ScrollableLayerGuid.h"
#include "nsColor.h"
#include "nsCoord.h"
#include "nsPoint.h"
#include "nsRect.h"
#include "mozilla/layers/LayersSurfaces.h"


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct TargetConfig|
//
namespace mozilla {
namespace layers {
class TargetConfig final
{
private:
    typedef ::mozilla::gfx::IntRect IntRect;
    typedef ::mozilla::ScreenRotation ScreenRotation;
    typedef ::mozilla::hal::ScreenOrientation ScreenOrientation;
    typedef ::nsIntRegion nsIntRegion;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    TargetConfig() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT TargetConfig(
            const IntRect& _naturalBounds,
            const ScreenRotation& _rotation,
            const ScreenOrientation& _orientation,
            const nsIntRegion& _clearRegion) :
        naturalBounds_(_naturalBounds),
        rotation_(_rotation),
        orientation_(_orientation),
        clearRegion_(_clearRegion)
    {
    }

    MOZ_IMPLICIT TargetConfig(
            IntRect&& _naturalBounds,
            ScreenRotation&& _rotation,
            ScreenOrientation&& _orientation,
            nsIntRegion&& _clearRegion) :
        naturalBounds_(std::move(_naturalBounds)),
        rotation_(std::move(_rotation)),
        orientation_(std::move(_orientation)),
        clearRegion_(std::move(_clearRegion))
    {
    }

    IntRect&
    naturalBounds()
    {
        return naturalBounds_;
    }
    const IntRect&
    naturalBounds() const
    {
        return naturalBounds_;
    }

    ScreenRotation&
    rotation()
    {
        return rotation_;
    }
    const ScreenRotation&
    rotation() const
    {
        return rotation_;
    }

    ScreenOrientation&
    orientation()
    {
        return orientation_;
    }
    const ScreenOrientation&
    orientation() const
    {
        return orientation_;
    }

    nsIntRegion&
    clearRegion()
    {
        return clearRegion_;
    }
    const nsIntRegion&
    clearRegion() const
    {
        return clearRegion_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<IntRect> naturalBounds_;
    ::mozilla::ipc::IPDLStructMember<ScreenRotation> rotation_;
    ::mozilla::ipc::IPDLStructMember<ScreenOrientation> orientation_;
    ::mozilla::ipc::IPDLStructMember<nsIntRegion> clearRegion_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::TargetConfig>
{
    typedef ::mozilla::layers::TargetConfig paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct OpAttachCompositable|
//
namespace mozilla {
namespace layers {
class OpAttachCompositable final
{
private:
    typedef ::mozilla::layers::LayerHandle LayerHandle;
    typedef ::mozilla::layers::CompositableHandle CompositableHandle;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    OpAttachCompositable() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT OpAttachCompositable(
            const LayerHandle& _layer,
            const CompositableHandle& _compositable) :
        layer_(_layer),
        compositable_(_compositable)
    {
    }

    MOZ_IMPLICIT OpAttachCompositable(
            LayerHandle&& _layer,
            CompositableHandle&& _compositable) :
        layer_(std::move(_layer)),
        compositable_(std::move(_compositable))
    {
    }

    LayerHandle&
    layer()
    {
        return layer_;
    }
    const LayerHandle&
    layer() const
    {
        return layer_;
    }

    CompositableHandle&
    compositable()
    {
        return compositable_;
    }
    const CompositableHandle&
    compositable() const
    {
        return compositable_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<LayerHandle> layer_;
    ::mozilla::ipc::IPDLStructMember<CompositableHandle> compositable_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::OpAttachCompositable>
{
    typedef ::mozilla::layers::OpAttachCompositable paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct OpAttachAsyncCompositable|
//
namespace mozilla {
namespace layers {
class OpAttachAsyncCompositable final
{
private:
    typedef ::mozilla::layers::LayerHandle LayerHandle;
    typedef ::mozilla::layers::CompositableHandle CompositableHandle;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    OpAttachAsyncCompositable() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT OpAttachAsyncCompositable(
            const LayerHandle& _layer,
            const CompositableHandle& _compositable) :
        layer_(_layer),
        compositable_(_compositable)
    {
    }

    MOZ_IMPLICIT OpAttachAsyncCompositable(
            LayerHandle&& _layer,
            CompositableHandle&& _compositable) :
        layer_(std::move(_layer)),
        compositable_(std::move(_compositable))
    {
    }

    LayerHandle&
    layer()
    {
        return layer_;
    }
    const LayerHandle&
    layer() const
    {
        return layer_;
    }

    CompositableHandle&
    compositable()
    {
        return compositable_;
    }
    const CompositableHandle&
    compositable() const
    {
        return compositable_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<LayerHandle> layer_;
    ::mozilla::ipc::IPDLStructMember<CompositableHandle> compositable_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::OpAttachAsyncCompositable>
{
    typedef ::mozilla::layers::OpAttachAsyncCompositable paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct LayerColor|
//
namespace mozilla {
namespace layers {
class LayerColor final
{
private:
    typedef ::mozilla::gfx::DeviceColor DeviceColor;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    LayerColor() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT LayerColor(const DeviceColor& _value) :
        value_(_value)
    {
    }

    MOZ_IMPLICIT LayerColor(DeviceColor&& _value) :
        value_(std::move(_value))
    {
    }

    DeviceColor&
    value()
    {
        return value_;
    }
    const DeviceColor&
    value() const
    {
        return value_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<DeviceColor> value_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::LayerColor>
{
    typedef ::mozilla::layers::LayerColor paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union Animatable|
//
namespace mozilla {
namespace layers {
class Animatable final
{
public:
    enum Type {
        T__None,
        Tnull_t = 1,
        Tfloat,
        Tnscolor,
        TStyleRotate,
        TStyleScale,
        TStyleTranslate,
        TStyleTransform,
        TStyleOffsetPath,
        TLengthPercentage,
        TStyleOffsetRotate,
        TStylePositionOrAuto,
        TStyleOffsetPosition,
        T__Last = TStyleOffsetPosition
    };

private:
    typedef ::mozilla::null_t null_t;
    typedef ::nscolor nscolor;
    typedef ::mozilla::StyleRotate StyleRotate;
    typedef ::mozilla::StyleScale StyleScale;
    typedef ::mozilla::StyleTranslate StyleTranslate;
    typedef ::mozilla::StyleTransform StyleTransform;
    typedef ::mozilla::StyleOffsetPath StyleOffsetPath;
    typedef ::mozilla::LengthPercentage LengthPercentage;
    typedef ::mozilla::StyleOffsetRotate StyleOffsetRotate;
    typedef ::mozilla::StylePositionOrAuto StylePositionOrAuto;
    typedef ::mozilla::StyleOffsetPosition StyleOffsetPosition;
    typedef null_t null_t__tdef;
    typedef float float__tdef;
    typedef nscolor nscolor__tdef;
    typedef StyleRotate StyleRotate__tdef;
    typedef StyleScale StyleScale__tdef;
    typedef StyleTranslate StyleTranslate__tdef;
    typedef StyleTransform StyleTransform__tdef;
    typedef StyleOffsetPath StyleOffsetPath__tdef;
    typedef LengthPercentage LengthPercentage__tdef;
    typedef StyleOffsetRotate StyleOffsetRotate__tdef;
    typedef StylePositionOrAuto StylePositionOrAuto__tdef;
    typedef StyleOffsetPosition StyleOffsetPosition__tdef;

    null_t*
    ptr_null_t()
    {
        return (&(mVnull_t));
    }
    const null_t*
    constptr_null_t() const
    {
        return (&(mVnull_t));
    }
    float*
    ptr_float()
    {
        return (&(mVfloat));
    }
    const float*
    constptr_float() const
    {
        return (&(mVfloat));
    }
    nscolor*
    ptr_nscolor()
    {
        return (&(mVnscolor));
    }
    const nscolor*
    constptr_nscolor() const
    {
        return (&(mVnscolor));
    }
    StyleRotate*
    ptr_StyleRotate()
    {
        return (&(mVStyleRotate));
    }
    const StyleRotate*
    constptr_StyleRotate() const
    {
        return (&(mVStyleRotate));
    }
    StyleScale*
    ptr_StyleScale()
    {
        return (&(mVStyleScale));
    }
    const StyleScale*
    constptr_StyleScale() const
    {
        return (&(mVStyleScale));
    }
    StyleTranslate*
    ptr_StyleTranslate()
    {
        return (&(mVStyleTranslate));
    }
    const StyleTranslate*
    constptr_StyleTranslate() const
    {
        return (&(mVStyleTranslate));
    }
    StyleTransform*
    ptr_StyleTransform()
    {
        return (&(mVStyleTransform));
    }
    const StyleTransform*
    constptr_StyleTransform() const
    {
        return (&(mVStyleTransform));
    }
    StyleOffsetPath*
    ptr_StyleOffsetPath()
    {
        return (&(mVStyleOffsetPath));
    }
    const StyleOffsetPath*
    constptr_StyleOffsetPath() const
    {
        return (&(mVStyleOffsetPath));
    }
    LengthPercentage*
    ptr_LengthPercentage()
    {
        return (&(mVLengthPercentage));
    }
    const LengthPercentage*
    constptr_LengthPercentage() const
    {
        return (&(mVLengthPercentage));
    }
    StyleOffsetRotate*
    ptr_StyleOffsetRotate()
    {
        return (&(mVStyleOffsetRotate));
    }
    const StyleOffsetRotate*
    constptr_StyleOffsetRotate() const
    {
        return (&(mVStyleOffsetRotate));
    }
    StylePositionOrAuto*
    ptr_StylePositionOrAuto()
    {
        return (&(mVStylePositionOrAuto));
    }
    const StylePositionOrAuto*
    constptr_StylePositionOrAuto() const
    {
        return (&(mVStylePositionOrAuto));
    }
    StyleOffsetPosition*
    ptr_StyleOffsetPosition()
    {
        return (&(mVStyleOffsetPosition));
    }
    const StyleOffsetPosition*
    constptr_StyleOffsetPosition() const
    {
        return (&(mVStyleOffsetPosition));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT Animatable() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT Animatable(const null_t& aOther);

    MOZ_IMPLICIT Animatable(null_t&& aOther);

    MOZ_IMPLICIT Animatable(const float& aOther);

    MOZ_IMPLICIT Animatable(float&& aOther);

    MOZ_IMPLICIT Animatable(const nscolor& aOther);

    MOZ_IMPLICIT Animatable(nscolor&& aOther);

    MOZ_IMPLICIT Animatable(const StyleRotate& aOther);

    MOZ_IMPLICIT Animatable(StyleRotate&& aOther);

    MOZ_IMPLICIT Animatable(const StyleScale& aOther);

    MOZ_IMPLICIT Animatable(StyleScale&& aOther);

    MOZ_IMPLICIT Animatable(const StyleTranslate& aOther);

    MOZ_IMPLICIT Animatable(StyleTranslate&& aOther);

    MOZ_IMPLICIT Animatable(const StyleTransform& aOther);

    MOZ_IMPLICIT Animatable(StyleTransform&& aOther);

    MOZ_IMPLICIT Animatable(const StyleOffsetPath& aOther);

    MOZ_IMPLICIT Animatable(StyleOffsetPath&& aOther);

    MOZ_IMPLICIT Animatable(const LengthPercentage& aOther);

    MOZ_IMPLICIT Animatable(LengthPercentage&& aOther);

    MOZ_IMPLICIT Animatable(const StyleOffsetRotate& aOther);

    MOZ_IMPLICIT Animatable(StyleOffsetRotate&& aOther);

    MOZ_IMPLICIT Animatable(const StylePositionOrAuto& aOther);

    MOZ_IMPLICIT Animatable(StylePositionOrAuto&& aOther);

    MOZ_IMPLICIT Animatable(const StyleOffsetPosition& aOther);

    MOZ_IMPLICIT Animatable(StyleOffsetPosition&& aOther);

    MOZ_IMPLICIT Animatable(const Animatable& aOther);

    MOZ_IMPLICIT Animatable(Animatable&& aOther);

    ~Animatable();

    Type
    type() const
    {
        return mType;
    }

    Animatable&
    operator=(const null_t& aRhs);

    Animatable&
    operator=(null_t&& aRhs);

    Animatable&
    operator=(const float& aRhs);

    Animatable&
    operator=(float&& aRhs);

    Animatable&
    operator=(const nscolor& aRhs);

    Animatable&
    operator=(nscolor&& aRhs);

    Animatable&
    operator=(const StyleRotate& aRhs);

    Animatable&
    operator=(StyleRotate&& aRhs);

    Animatable&
    operator=(const StyleScale& aRhs);

    Animatable&
    operator=(StyleScale&& aRhs);

    Animatable&
    operator=(const StyleTranslate& aRhs);

    Animatable&
    operator=(StyleTranslate&& aRhs);

    Animatable&
    operator=(const StyleTransform& aRhs);

    Animatable&
    operator=(StyleTransform&& aRhs);

    Animatable&
    operator=(const StyleOffsetPath& aRhs);

    Animatable&
    operator=(StyleOffsetPath&& aRhs);

    Animatable&
    operator=(const LengthPercentage& aRhs);

    Animatable&
    operator=(LengthPercentage&& aRhs);

    Animatable&
    operator=(const StyleOffsetRotate& aRhs);

    Animatable&
    operator=(StyleOffsetRotate&& aRhs);

    Animatable&
    operator=(const StylePositionOrAuto& aRhs);

    Animatable&
    operator=(StylePositionOrAuto&& aRhs);

    Animatable&
    operator=(const StyleOffsetPosition& aRhs);

    Animatable&
    operator=(StyleOffsetPosition&& aRhs);

    Animatable&
    operator=(const Animatable& aRhs);

    Animatable&
    operator=(Animatable&& aRhs);

    bool
    operator==(const null_t& aRhs) const;

    bool
    operator==(const float& aRhs) const;

    bool
    operator==(const nscolor& aRhs) const;

    bool
    operator==(const StyleRotate& aRhs) const;

    bool
    operator==(const StyleScale& aRhs) const;

    bool
    operator==(const StyleTranslate& aRhs) const;

    bool
    operator==(const StyleTransform& aRhs) const;

    bool
    operator==(const StyleOffsetPath& aRhs) const;

    bool
    operator==(const LengthPercentage& aRhs) const;

    bool
    operator==(const StyleOffsetRotate& aRhs) const;

    bool
    operator==(const StylePositionOrAuto& aRhs) const;

    bool
    operator==(const StyleOffsetPosition& aRhs) const;

    bool
    operator==(const Animatable& aRhs) const;

    null_t&
    get_null_t()
    {
        AssertSanity(Tnull_t);
        return (*(ptr_null_t()));
    }
    const null_t&
    get_null_t() const
    {
        AssertSanity(Tnull_t);
        return (*(constptr_null_t()));
    }
    operator null_t&()
    {
        return get_null_t();
    }
    operator const null_t&() const
    {
        return get_null_t();
    }

    float&
    get_float()
    {
        AssertSanity(Tfloat);
        return (*(ptr_float()));
    }
    const float&
    get_float() const
    {
        AssertSanity(Tfloat);
        return (*(constptr_float()));
    }
    operator float&()
    {
        return get_float();
    }
    operator const float&() const
    {
        return get_float();
    }

    nscolor&
    get_nscolor()
    {
        AssertSanity(Tnscolor);
        return (*(ptr_nscolor()));
    }
    const nscolor&
    get_nscolor() const
    {
        AssertSanity(Tnscolor);
        return (*(constptr_nscolor()));
    }
    operator nscolor&()
    {
        return get_nscolor();
    }
    operator const nscolor&() const
    {
        return get_nscolor();
    }

    StyleRotate&
    get_StyleRotate()
    {
        AssertSanity(TStyleRotate);
        return (*(ptr_StyleRotate()));
    }
    const StyleRotate&
    get_StyleRotate() const
    {
        AssertSanity(TStyleRotate);
        return (*(constptr_StyleRotate()));
    }
    operator StyleRotate&()
    {
        return get_StyleRotate();
    }
    operator const StyleRotate&() const
    {
        return get_StyleRotate();
    }

    StyleScale&
    get_StyleScale()
    {
        AssertSanity(TStyleScale);
        return (*(ptr_StyleScale()));
    }
    const StyleScale&
    get_StyleScale() const
    {
        AssertSanity(TStyleScale);
        return (*(constptr_StyleScale()));
    }
    operator StyleScale&()
    {
        return get_StyleScale();
    }
    operator const StyleScale&() const
    {
        return get_StyleScale();
    }

    StyleTranslate&
    get_StyleTranslate()
    {
        AssertSanity(TStyleTranslate);
        return (*(ptr_StyleTranslate()));
    }
    const StyleTranslate&
    get_StyleTranslate() const
    {
        AssertSanity(TStyleTranslate);
        return (*(constptr_StyleTranslate()));
    }
    operator StyleTranslate&()
    {
        return get_StyleTranslate();
    }
    operator const StyleTranslate&() const
    {
        return get_StyleTranslate();
    }

    StyleTransform&
    get_StyleTransform()
    {
        AssertSanity(TStyleTransform);
        return (*(ptr_StyleTransform()));
    }
    const StyleTransform&
    get_StyleTransform() const
    {
        AssertSanity(TStyleTransform);
        return (*(constptr_StyleTransform()));
    }
    operator StyleTransform&()
    {
        return get_StyleTransform();
    }
    operator const StyleTransform&() const
    {
        return get_StyleTransform();
    }

    StyleOffsetPath&
    get_StyleOffsetPath()
    {
        AssertSanity(TStyleOffsetPath);
        return (*(ptr_StyleOffsetPath()));
    }
    const StyleOffsetPath&
    get_StyleOffsetPath() const
    {
        AssertSanity(TStyleOffsetPath);
        return (*(constptr_StyleOffsetPath()));
    }
    operator StyleOffsetPath&()
    {
        return get_StyleOffsetPath();
    }
    operator const StyleOffsetPath&() const
    {
        return get_StyleOffsetPath();
    }

    LengthPercentage&
    get_LengthPercentage()
    {
        AssertSanity(TLengthPercentage);
        return (*(ptr_LengthPercentage()));
    }
    const LengthPercentage&
    get_LengthPercentage() const
    {
        AssertSanity(TLengthPercentage);
        return (*(constptr_LengthPercentage()));
    }
    operator LengthPercentage&()
    {
        return get_LengthPercentage();
    }
    operator const LengthPercentage&() const
    {
        return get_LengthPercentage();
    }

    StyleOffsetRotate&
    get_StyleOffsetRotate()
    {
        AssertSanity(TStyleOffsetRotate);
        return (*(ptr_StyleOffsetRotate()));
    }
    const StyleOffsetRotate&
    get_StyleOffsetRotate() const
    {
        AssertSanity(TStyleOffsetRotate);
        return (*(constptr_StyleOffsetRotate()));
    }
    operator StyleOffsetRotate&()
    {
        return get_StyleOffsetRotate();
    }
    operator const StyleOffsetRotate&() const
    {
        return get_StyleOffsetRotate();
    }

    StylePositionOrAuto&
    get_StylePositionOrAuto()
    {
        AssertSanity(TStylePositionOrAuto);
        return (*(ptr_StylePositionOrAuto()));
    }
    const StylePositionOrAuto&
    get_StylePositionOrAuto() const
    {
        AssertSanity(TStylePositionOrAuto);
        return (*(constptr_StylePositionOrAuto()));
    }
    operator StylePositionOrAuto&()
    {
        return get_StylePositionOrAuto();
    }
    operator const StylePositionOrAuto&() const
    {
        return get_StylePositionOrAuto();
    }

    StyleOffsetPosition&
    get_StyleOffsetPosition()
    {
        AssertSanity(TStyleOffsetPosition);
        return (*(ptr_StyleOffsetPosition()));
    }
    const StyleOffsetPosition&
    get_StyleOffsetPosition() const
    {
        AssertSanity(TStyleOffsetPosition);
        return (*(constptr_StyleOffsetPosition()));
    }
    operator StyleOffsetPosition&()
    {
        return get_StyleOffsetPosition();
    }
    operator const StyleOffsetPosition&() const
    {
        return get_StyleOffsetPosition();
    }

private:
    union {
        null_t mVnull_t;
        float mVfloat;
        nscolor mVnscolor;
        StyleRotate mVStyleRotate;
        StyleScale mVStyleScale;
        StyleTranslate mVStyleTranslate;
        StyleTransform mVStyleTransform;
        StyleOffsetPath mVStyleOffsetPath;
        LengthPercentage mVLengthPercentage;
        StyleOffsetRotate mVStyleOffsetRotate;
        StylePositionOrAuto mVStylePositionOrAuto;
        StyleOffsetPosition mVStyleOffsetPosition;
    };
    Type mType;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::Animatable>
{
    typedef ::mozilla::layers::Animatable paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct AnimationSegment|
//
namespace mozilla {
namespace layers {
class AnimationSegment final
{
private:
    typedef ::mozilla::layers::Animatable Animatable;
    typedef ::uint8_t uint8_t;
    typedef ::mozilla::StyleComputedTimingFunction StyleComputedTimingFunction;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    AnimationSegment() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT AnimationSegment(
            const Animatable& _startState,
            const Animatable& _endState,
            const float& _startPortion,
            const float& _endPortion,
            const uint8_t& _startComposite,
            const uint8_t& _endComposite,
            const mozilla::Maybe<StyleComputedTimingFunction>& _sampleFn) :
        startState_(_startState),
        endState_(_endState),
        sampleFn_(_sampleFn),
        startPortion_(_startPortion),
        endPortion_(_endPortion),
        startComposite_(_startComposite),
        endComposite_(_endComposite)
    {
    }

    MOZ_IMPLICIT AnimationSegment(
            Animatable&& _startState,
            Animatable&& _endState,
            float&& _startPortion,
            float&& _endPortion,
            uint8_t&& _startComposite,
            uint8_t&& _endComposite,
            mozilla::Maybe<StyleComputedTimingFunction>&& _sampleFn) :
        startState_(std::move(_startState)),
        endState_(std::move(_endState)),
        sampleFn_(std::move(_sampleFn)),
        startPortion_(std::move(_startPortion)),
        endPortion_(std::move(_endPortion)),
        startComposite_(std::move(_startComposite)),
        endComposite_(std::move(_endComposite))
    {
    }

    Animatable&
    startState()
    {
        return startState_;
    }
    const Animatable&
    startState() const
    {
        return startState_;
    }

    Animatable&
    endState()
    {
        return endState_;
    }
    const Animatable&
    endState() const
    {
        return endState_;
    }

    float&
    startPortion()
    {
        return startPortion_;
    }
    const float&
    startPortion() const
    {
        return startPortion_;
    }

    float&
    endPortion()
    {
        return endPortion_;
    }
    const float&
    endPortion() const
    {
        return endPortion_;
    }

    uint8_t&
    startComposite()
    {
        return startComposite_;
    }
    const uint8_t&
    startComposite() const
    {
        return startComposite_;
    }

    uint8_t&
    endComposite()
    {
        return endComposite_;
    }
    const uint8_t&
    endComposite() const
    {
        return endComposite_;
    }

    mozilla::Maybe<StyleComputedTimingFunction>&
    sampleFn()
    {
        return sampleFn_;
    }
    const mozilla::Maybe<StyleComputedTimingFunction>&
    sampleFn() const
    {
        return sampleFn_;
    }

private:
    void
    StaticAssertions() const;
    ::mozilla::ipc::IPDLStructMember<Animatable> startState_;
    ::mozilla::ipc::IPDLStructMember<Animatable> endState_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<StyleComputedTimingFunction>> sampleFn_;
    ::mozilla::ipc::IPDLStructMember<float> startPortion_;
    ::mozilla::ipc::IPDLStructMember<float> endPortion_;
    ::mozilla::ipc::IPDLStructMember<uint8_t> startComposite_;
    ::mozilla::ipc::IPDLStructMember<uint8_t> endComposite_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::AnimationSegment>
{
    typedef ::mozilla::layers::AnimationSegment paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct MotionPathData|
//
namespace mozilla {
namespace layers {
class MotionPathData final
{
private:
    typedef ::mozilla::CSSPoint CSSPoint;
    typedef ::nsRect nsRect;
    typedef ::nsPoint nsPoint;
    typedef ::mozilla::CSSCoord CSSCoord;
    typedef ::nscoord nscoord;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    MotionPathData() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT MotionPathData(
            const CSSPoint& _origin,
            const CSSPoint& _anchorAdjustment,
            const nsRect& _coordBox,
            const nsPoint& _currentPosition,
            const CSSCoord& _rayContainReferenceLength,
            const nsTArray<nscoord>& _coordBoxInsetRadii) :
        origin_(_origin),
        anchorAdjustment_(_anchorAdjustment),
        coordBox_(_coordBox),
        currentPosition_(_currentPosition),
        rayContainReferenceLength_(_rayContainReferenceLength),
        coordBoxInsetRadii_(_coordBoxInsetRadii)
    {
    }

    MOZ_IMPLICIT MotionPathData(
            CSSPoint&& _origin,
            CSSPoint&& _anchorAdjustment,
            nsRect&& _coordBox,
            nsPoint&& _currentPosition,
            CSSCoord&& _rayContainReferenceLength,
            nsTArray<nscoord>&& _coordBoxInsetRadii) :
        origin_(std::move(_origin)),
        anchorAdjustment_(std::move(_anchorAdjustment)),
        coordBox_(std::move(_coordBox)),
        currentPosition_(std::move(_currentPosition)),
        rayContainReferenceLength_(std::move(_rayContainReferenceLength)),
        coordBoxInsetRadii_(std::move(_coordBoxInsetRadii))
    {
    }

    bool
    operator==(const MotionPathData& _o) const;

    bool
    operator!=(const MotionPathData& _o) const;

    CSSPoint&
    origin()
    {
        return origin_;
    }
    const CSSPoint&
    origin() const
    {
        return origin_;
    }

    CSSPoint&
    anchorAdjustment()
    {
        return anchorAdjustment_;
    }
    const CSSPoint&
    anchorAdjustment() const
    {
        return anchorAdjustment_;
    }

    nsRect&
    coordBox()
    {
        return coordBox_;
    }
    const nsRect&
    coordBox() const
    {
        return coordBox_;
    }

    nsPoint&
    currentPosition()
    {
        return currentPosition_;
    }
    const nsPoint&
    currentPosition() const
    {
        return currentPosition_;
    }

    CSSCoord&
    rayContainReferenceLength()
    {
        return rayContainReferenceLength_;
    }
    const CSSCoord&
    rayContainReferenceLength() const
    {
        return rayContainReferenceLength_;
    }

    nsTArray<nscoord>&
    coordBoxInsetRadii()
    {
        return coordBoxInsetRadii_;
    }
    const nsTArray<nscoord>&
    coordBoxInsetRadii() const
    {
        return coordBoxInsetRadii_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<CSSPoint> origin_;
    ::mozilla::ipc::IPDLStructMember<CSSPoint> anchorAdjustment_;
    ::mozilla::ipc::IPDLStructMember<nsRect> coordBox_;
    ::mozilla::ipc::IPDLStructMember<nsPoint> currentPosition_;
    ::mozilla::ipc::IPDLStructMember<CSSCoord> rayContainReferenceLength_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<nscoord>> coordBoxInsetRadii_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::MotionPathData>
{
    typedef ::mozilla::layers::MotionPathData paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct PartialPrerenderData|
//
namespace mozilla {
namespace layers {
class PartialPrerenderData final
{
private:
    typedef ::mozilla::LayoutDeviceRect LayoutDeviceRect;
    typedef ::mozilla::SideBits SideBits;
    typedef ::mozilla::layers::ScrollableLayerGuid::ViewID ViewID;
    typedef ::mozilla::ParentLayerRect ParentLayerRect;
    typedef ::mozilla::gfx::Matrix4x4 Matrix4x4;
    typedef ::mozilla::LayoutDevicePoint LayoutDevicePoint;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    PartialPrerenderData() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT PartialPrerenderData(
            const LayoutDeviceRect& _rect,
            const SideBits& _overflowedSides,
            const ViewID& _scrollId,
            const ParentLayerRect& _clipRect,
            const Matrix4x4& _transformInClip,
            const LayoutDevicePoint& _position) :
        rect_(_rect),
        overflowedSides_(_overflowedSides),
        scrollId_(_scrollId),
        clipRect_(_clipRect),
        transformInClip_(_transformInClip),
        position_(_position)
    {
    }

    MOZ_IMPLICIT PartialPrerenderData(
            LayoutDeviceRect&& _rect,
            SideBits&& _overflowedSides,
            ViewID&& _scrollId,
            ParentLayerRect&& _clipRect,
            Matrix4x4&& _transformInClip,
            LayoutDevicePoint&& _position) :
        rect_(std::move(_rect)),
        overflowedSides_(std::move(_overflowedSides)),
        scrollId_(std::move(_scrollId)),
        clipRect_(std::move(_clipRect)),
        transformInClip_(std::move(_transformInClip)),
        position_(std::move(_position))
    {
    }

    bool
    operator==(const PartialPrerenderData& _o) const;

    bool
    operator!=(const PartialPrerenderData& _o) const;

    LayoutDeviceRect&
    rect()
    {
        return rect_;
    }
    const LayoutDeviceRect&
    rect() const
    {
        return rect_;
    }

    SideBits&
    overflowedSides()
    {
        return overflowedSides_;
    }
    const SideBits&
    overflowedSides() const
    {
        return overflowedSides_;
    }

    ViewID&
    scrollId()
    {
        return scrollId_;
    }
    const ViewID&
    scrollId() const
    {
        return scrollId_;
    }

    ParentLayerRect&
    clipRect()
    {
        return clipRect_;
    }
    const ParentLayerRect&
    clipRect() const
    {
        return clipRect_;
    }

    Matrix4x4&
    transformInClip()
    {
        return transformInClip_;
    }
    const Matrix4x4&
    transformInClip() const
    {
        return transformInClip_;
    }

    LayoutDevicePoint&
    position()
    {
        return position_;
    }
    const LayoutDevicePoint&
    position() const
    {
        return position_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<LayoutDeviceRect> rect_;
    ::mozilla::ipc::IPDLStructMember<SideBits> overflowedSides_;
    ::mozilla::ipc::IPDLStructMember<ViewID> scrollId_;
    ::mozilla::ipc::IPDLStructMember<ParentLayerRect> clipRect_;
    ::mozilla::ipc::IPDLStructMember<Matrix4x4> transformInClip_;
    ::mozilla::ipc::IPDLStructMember<LayoutDevicePoint> position_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::PartialPrerenderData>
{
    typedef ::mozilla::layers::PartialPrerenderData paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct TransformData|
//
namespace mozilla {
namespace layers {
class TransformData final
{
private:
    typedef ::nsPoint nsPoint;
    typedef ::mozilla::gfx::Point3D Point3D;
    typedef ::nsRect nsRect;
    typedef ::int32_t int32_t;
    typedef ::mozilla::layers::MotionPathData MotionPathData;
    typedef ::mozilla::layers::PartialPrerenderData PartialPrerenderData;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    TransformData() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT TransformData(
            const nsPoint& _origin,
            const Point3D& _transformOrigin,
            const nsRect& _bounds,
            const int32_t& _appUnitsPerDevPixel,
            const mozilla::Maybe<MotionPathData>& _motionPathData,
            const mozilla::Maybe<PartialPrerenderData>& _partialPrerenderData) :
        origin_(_origin),
        transformOrigin_(_transformOrigin),
        bounds_(_bounds),
        motionPathData_(_motionPathData),
        partialPrerenderData_(_partialPrerenderData),
        appUnitsPerDevPixel_(_appUnitsPerDevPixel)
    {
    }

    MOZ_IMPLICIT TransformData(
            nsPoint&& _origin,
            Point3D&& _transformOrigin,
            nsRect&& _bounds,
            int32_t&& _appUnitsPerDevPixel,
            mozilla::Maybe<MotionPathData>&& _motionPathData,
            mozilla::Maybe<PartialPrerenderData>&& _partialPrerenderData) :
        origin_(std::move(_origin)),
        transformOrigin_(std::move(_transformOrigin)),
        bounds_(std::move(_bounds)),
        motionPathData_(std::move(_motionPathData)),
        partialPrerenderData_(std::move(_partialPrerenderData)),
        appUnitsPerDevPixel_(std::move(_appUnitsPerDevPixel))
    {
    }

    bool
    operator==(const TransformData& _o) const;

    bool
    operator!=(const TransformData& _o) const;

    nsPoint&
    origin()
    {
        return origin_;
    }
    const nsPoint&
    origin() const
    {
        return origin_;
    }

    Point3D&
    transformOrigin()
    {
        return transformOrigin_;
    }
    const Point3D&
    transformOrigin() const
    {
        return transformOrigin_;
    }

    nsRect&
    bounds()
    {
        return bounds_;
    }
    const nsRect&
    bounds() const
    {
        return bounds_;
    }

    int32_t&
    appUnitsPerDevPixel()
    {
        return appUnitsPerDevPixel_;
    }
    const int32_t&
    appUnitsPerDevPixel() const
    {
        return appUnitsPerDevPixel_;
    }

    mozilla::Maybe<MotionPathData>&
    motionPathData()
    {
        return motionPathData_;
    }
    const mozilla::Maybe<MotionPathData>&
    motionPathData() const
    {
        return motionPathData_;
    }

    mozilla::Maybe<PartialPrerenderData>&
    partialPrerenderData()
    {
        return partialPrerenderData_;
    }
    const mozilla::Maybe<PartialPrerenderData>&
    partialPrerenderData() const
    {
        return partialPrerenderData_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsPoint> origin_;
    ::mozilla::ipc::IPDLStructMember<Point3D> transformOrigin_;
    ::mozilla::ipc::IPDLStructMember<nsRect> bounds_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<MotionPathData>> motionPathData_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<PartialPrerenderData>> partialPrerenderData_;
    ::mozilla::ipc::IPDLStructMember<int32_t> appUnitsPerDevPixel_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::TransformData>
{
    typedef ::mozilla::layers::TransformData paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ScrollTimelineOptions|
//
namespace mozilla {
namespace layers {
class ScrollTimelineOptions final
{
private:
    typedef ::mozilla::layers::ScrollableLayerGuid::ViewID ViewID;
    typedef ::mozilla::layers::ScrollDirection ScrollDirection;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ScrollTimelineOptions() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ScrollTimelineOptions(
            const ViewID& _source,
            const ScrollDirection& _axis) :
        source_(_source),
        axis_(_axis)
    {
    }

    MOZ_IMPLICIT ScrollTimelineOptions(
            ViewID&& _source,
            ScrollDirection&& _axis) :
        source_(std::move(_source)),
        axis_(std::move(_axis))
    {
    }

    ViewID&
    source()
    {
        return source_;
    }
    const ViewID&
    source() const
    {
        return source_;
    }

    ScrollDirection&
    axis()
    {
        return axis_;
    }
    const ScrollDirection&
    axis() const
    {
        return axis_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<ViewID> source_;
    ::mozilla::ipc::IPDLStructMember<ScrollDirection> axis_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::ScrollTimelineOptions>
{
    typedef ::mozilla::layers::ScrollTimelineOptions paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct Animation|
//
namespace mozilla {
namespace layers {
class Animation final
{
private:
    typedef ::mozilla::TimeStamp TimeStamp;
    typedef ::mozilla::TimeDuration TimeDuration;
    typedef ::mozilla::layers::AnimationSegment AnimationSegment;
    typedef ::uint8_t uint8_t;
    typedef ::NonCustomCSSPropertyId NonCustomCSSPropertyId;
    typedef ::mozilla::StyleComputedTimingFunction StyleComputedTimingFunction;
    typedef ::mozilla::layers::Animatable Animatable;
    typedef ::mozilla::layers::TransformData TransformData;
    typedef ::uint64_t uint64_t;
    typedef ::mozilla::layers::ScrollTimelineOptions ScrollTimelineOptions;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    Animation() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT Animation(
            const TimeStamp& _originTime,
            const mozilla::Maybe<TimeDuration>& _startTime,
            const TimeDuration& _delay,
            const TimeDuration& _endDelay,
            const TimeDuration& _holdTime,
            const TimeDuration& _duration,
            const nsTArray<AnimationSegment>& _segments,
            const float& _iterations,
            const float& _iterationStart,
            const uint8_t& _direction,
            const uint8_t& _fillMode,
            const NonCustomCSSPropertyId& _property,
            const float& _playbackRate,
            const float& _previousPlaybackRate,
            const mozilla::Maybe<StyleComputedTimingFunction>& _easingFunction,
            const uint8_t& _iterationComposite,
            const bool& _isNotPlaying,
            const bool& _isNotAnimating,
            const Animatable& _baseStyle,
            const mozilla::Maybe<TransformData>& _transformData,
            const mozilla::Maybe<uint64_t>& _replacedTransitionId,
            const mozilla::Maybe<ScrollTimelineOptions>& _scrollTimelineOptions) :
        originTime_(_originTime),
        startTime_(_startTime),
        delay_(_delay),
        endDelay_(_endDelay),
        holdTime_(_holdTime),
        duration_(_duration),
        segments_(_segments),
        property_(_property),
        easingFunction_(_easingFunction),
        isNotPlaying_(_isNotPlaying),
        isNotAnimating_(_isNotAnimating),
        baseStyle_(_baseStyle),
        transformData_(_transformData),
        replacedTransitionId_(_replacedTransitionId),
        scrollTimelineOptions_(_scrollTimelineOptions),
        iterations_(_iterations),
        iterationStart_(_iterationStart),
        playbackRate_(_playbackRate),
        previousPlaybackRate_(_previousPlaybackRate),
        direction_(_direction),
        fillMode_(_fillMode),
        iterationComposite_(_iterationComposite)
    {
    }

    MOZ_IMPLICIT Animation(
            TimeStamp&& _originTime,
            mozilla::Maybe<TimeDuration>&& _startTime,
            TimeDuration&& _delay,
            TimeDuration&& _endDelay,
            TimeDuration&& _holdTime,
            TimeDuration&& _duration,
            nsTArray<AnimationSegment>&& _segments,
            float&& _iterations,
            float&& _iterationStart,
            uint8_t&& _direction,
            uint8_t&& _fillMode,
            NonCustomCSSPropertyId&& _property,
            float&& _playbackRate,
            float&& _previousPlaybackRate,
            mozilla::Maybe<StyleComputedTimingFunction>&& _easingFunction,
            uint8_t&& _iterationComposite,
            bool&& _isNotPlaying,
            bool&& _isNotAnimating,
            Animatable&& _baseStyle,
            mozilla::Maybe<TransformData>&& _transformData,
            mozilla::Maybe<uint64_t>&& _replacedTransitionId,
            mozilla::Maybe<ScrollTimelineOptions>&& _scrollTimelineOptions) :
        originTime_(std::move(_originTime)),
        startTime_(std::move(_startTime)),
        delay_(std::move(_delay)),
        endDelay_(std::move(_endDelay)),
        holdTime_(std::move(_holdTime)),
        duration_(std::move(_duration)),
        segments_(std::move(_segments)),
        property_(std::move(_property)),
        easingFunction_(std::move(_easingFunction)),
        isNotPlaying_(std::move(_isNotPlaying)),
        isNotAnimating_(std::move(_isNotAnimating)),
        baseStyle_(std::move(_baseStyle)),
        transformData_(std::move(_transformData)),
        replacedTransitionId_(std::move(_replacedTransitionId)),
        scrollTimelineOptions_(std::move(_scrollTimelineOptions)),
        iterations_(std::move(_iterations)),
        iterationStart_(std::move(_iterationStart)),
        playbackRate_(std::move(_playbackRate)),
        previousPlaybackRate_(std::move(_previousPlaybackRate)),
        direction_(std::move(_direction)),
        fillMode_(std::move(_fillMode)),
        iterationComposite_(std::move(_iterationComposite))
    {
    }

    TimeStamp&
    originTime()
    {
        return originTime_;
    }
    const TimeStamp&
    originTime() const
    {
        return originTime_;
    }

    mozilla::Maybe<TimeDuration>&
    startTime()
    {
        return startTime_;
    }
    const mozilla::Maybe<TimeDuration>&
    startTime() const
    {
        return startTime_;
    }

    TimeDuration&
    delay()
    {
        return delay_;
    }
    const TimeDuration&
    delay() const
    {
        return delay_;
    }

    TimeDuration&
    endDelay()
    {
        return endDelay_;
    }
    const TimeDuration&
    endDelay() const
    {
        return endDelay_;
    }

    TimeDuration&
    holdTime()
    {
        return holdTime_;
    }
    const TimeDuration&
    holdTime() const
    {
        return holdTime_;
    }

    TimeDuration&
    duration()
    {
        return duration_;
    }
    const TimeDuration&
    duration() const
    {
        return duration_;
    }

    nsTArray<AnimationSegment>&
    segments()
    {
        return segments_;
    }
    const nsTArray<AnimationSegment>&
    segments() const
    {
        return segments_;
    }

    float&
    iterations()
    {
        return iterations_;
    }
    const float&
    iterations() const
    {
        return iterations_;
    }

    float&
    iterationStart()
    {
        return iterationStart_;
    }
    const float&
    iterationStart() const
    {
        return iterationStart_;
    }

    uint8_t&
    direction()
    {
        return direction_;
    }
    const uint8_t&
    direction() const
    {
        return direction_;
    }

    uint8_t&
    fillMode()
    {
        return fillMode_;
    }
    const uint8_t&
    fillMode() const
    {
        return fillMode_;
    }

    NonCustomCSSPropertyId&
    property()
    {
        return property_;
    }
    const NonCustomCSSPropertyId&
    property() const
    {
        return property_;
    }

    float&
    playbackRate()
    {
        return playbackRate_;
    }
    const float&
    playbackRate() const
    {
        return playbackRate_;
    }

    float&
    previousPlaybackRate()
    {
        return previousPlaybackRate_;
    }
    const float&
    previousPlaybackRate() const
    {
        return previousPlaybackRate_;
    }

    mozilla::Maybe<StyleComputedTimingFunction>&
    easingFunction()
    {
        return easingFunction_;
    }
    const mozilla::Maybe<StyleComputedTimingFunction>&
    easingFunction() const
    {
        return easingFunction_;
    }

    uint8_t&
    iterationComposite()
    {
        return iterationComposite_;
    }
    const uint8_t&
    iterationComposite() const
    {
        return iterationComposite_;
    }

    bool&
    isNotPlaying()
    {
        return isNotPlaying_;
    }
    const bool&
    isNotPlaying() const
    {
        return isNotPlaying_;
    }

    bool&
    isNotAnimating()
    {
        return isNotAnimating_;
    }
    const bool&
    isNotAnimating() const
    {
        return isNotAnimating_;
    }

    Animatable&
    baseStyle()
    {
        return baseStyle_;
    }
    const Animatable&
    baseStyle() const
    {
        return baseStyle_;
    }

    mozilla::Maybe<TransformData>&
    transformData()
    {
        return transformData_;
    }
    const mozilla::Maybe<TransformData>&
    transformData() const
    {
        return transformData_;
    }

    mozilla::Maybe<uint64_t>&
    replacedTransitionId()
    {
        return replacedTransitionId_;
    }
    const mozilla::Maybe<uint64_t>&
    replacedTransitionId() const
    {
        return replacedTransitionId_;
    }

    mozilla::Maybe<ScrollTimelineOptions>&
    scrollTimelineOptions()
    {
        return scrollTimelineOptions_;
    }
    const mozilla::Maybe<ScrollTimelineOptions>&
    scrollTimelineOptions() const
    {
        return scrollTimelineOptions_;
    }

private:
    void
    StaticAssertions() const;
    ::mozilla::ipc::IPDLStructMember<TimeStamp> originTime_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<TimeDuration>> startTime_;
    ::mozilla::ipc::IPDLStructMember<TimeDuration> delay_;
    ::mozilla::ipc::IPDLStructMember<TimeDuration> endDelay_;
    ::mozilla::ipc::IPDLStructMember<TimeDuration> holdTime_;
    ::mozilla::ipc::IPDLStructMember<TimeDuration> duration_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<AnimationSegment>> segments_;
    ::mozilla::ipc::IPDLStructMember<NonCustomCSSPropertyId> property_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<StyleComputedTimingFunction>> easingFunction_;
    ::mozilla::ipc::IPDLStructMember<bool> isNotPlaying_;
    ::mozilla::ipc::IPDLStructMember<bool> isNotAnimating_;
    ::mozilla::ipc::IPDLStructMember<Animatable> baseStyle_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<TransformData>> transformData_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<uint64_t>> replacedTransitionId_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<ScrollTimelineOptions>> scrollTimelineOptions_;
    ::mozilla::ipc::IPDLStructMember<float> iterations_;
    ::mozilla::ipc::IPDLStructMember<float> iterationStart_;
    ::mozilla::ipc::IPDLStructMember<float> playbackRate_;
    ::mozilla::ipc::IPDLStructMember<float> previousPlaybackRate_;
    ::mozilla::ipc::IPDLStructMember<uint8_t> direction_;
    ::mozilla::ipc::IPDLStructMember<uint8_t> fillMode_;
    ::mozilla::ipc::IPDLStructMember<uint8_t> iterationComposite_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::Animation>
{
    typedef ::mozilla::layers::Animation paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct CompositorAnimations|
//
namespace mozilla {
namespace layers {
class CompositorAnimations final
{
private:
    typedef ::mozilla::layers::Animation Animation;
    typedef ::uint64_t uint64_t;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    CompositorAnimations() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT CompositorAnimations(
            const nsTArray<Animation>& _animations,
            const uint64_t& _id) :
        animations_(_animations),
        id_(_id)
    {
    }

    MOZ_IMPLICIT CompositorAnimations(
            nsTArray<Animation>&& _animations,
            uint64_t&& _id) :
        animations_(std::move(_animations)),
        id_(std::move(_id))
    {
    }

    nsTArray<Animation>&
    animations()
    {
        return animations_;
    }
    const nsTArray<Animation>&
    animations() const
    {
        return animations_;
    }

    uint64_t&
    id()
    {
        return id_;
    }
    const uint64_t&
    id() const
    {
        return id_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<Animation>> animations_;
    ::mozilla::ipc::IPDLStructMember<uint64_t> id_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::CompositorAnimations>
{
    typedef ::mozilla::layers::CompositorAnimations paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct UntrustedShmemSection|
//
namespace mozilla {
namespace layers {
class UntrustedShmemSection final
{
private:
    typedef ::mozilla::ipc::Shmem Shmem;
    typedef ::uint32_t uint32_t;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    UntrustedShmemSection() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT UntrustedShmemSection(
            Shmem& _shmem,
            const uint32_t& _offset,
            const uint32_t& _size) :
        shmem_(_shmem),
        offset_(_offset),
        size_(_size)
    {
    }

    MOZ_IMPLICIT UntrustedShmemSection(
            Shmem&& _shmem,
            uint32_t&& _offset,
            uint32_t&& _size) :
        shmem_(std::move(_shmem)),
        offset_(std::move(_offset)),
        size_(std::move(_size))
    {
    }

    Shmem&
    shmem()
    {
        return shmem_;
    }
    Shmem&
    shmem() const
    {
        return const_cast<Shmem&>(shmem_);
    }

    uint32_t&
    offset()
    {
        return offset_;
    }
    const uint32_t&
    offset() const
    {
        return offset_;
    }

    uint32_t&
    size()
    {
        return size_;
    }
    const uint32_t&
    size() const
    {
        return size_;
    }

private:
    void
    StaticAssertions() const;
    ::mozilla::ipc::IPDLStructMember<Shmem> shmem_;
    ::mozilla::ipc::IPDLStructMember<uint32_t> offset_;
    ::mozilla::ipc::IPDLStructMember<uint32_t> size_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::UntrustedShmemSection>
{
    typedef ::mozilla::layers::UntrustedShmemSection paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct CrossProcessSemaphoreDescriptor|
//
namespace mozilla {
namespace layers {
class CrossProcessSemaphoreDescriptor final
{
private:
    typedef ::mozilla::CrossProcessSemaphoreHandle CrossProcessSemaphoreHandle;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    CrossProcessSemaphoreDescriptor() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT CrossProcessSemaphoreDescriptor(CrossProcessSemaphoreHandle&& _sem) :
        sem_(std::move(_sem))
    {
    }

    CrossProcessSemaphoreHandle&
    sem()
    {
        return sem_;
    }
    const CrossProcessSemaphoreHandle&
    sem() const
    {
        return sem_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<CrossProcessSemaphoreHandle> sem_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::CrossProcessSemaphoreDescriptor>
{
    typedef ::mozilla::layers::CrossProcessSemaphoreDescriptor paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            paramType&& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union ReadLockDescriptor|
//
namespace mozilla {
namespace layers {
class ReadLockDescriptor final
{
public:
    enum Type {
        T__None,
        TUntrustedShmemSection = 1,
        TCrossProcessSemaphoreDescriptor,
        Tuintptr_t,
        Tnull_t,
        T__Last = Tnull_t
    };

private:
    typedef ::mozilla::layers::UntrustedShmemSection UntrustedShmemSection;
    typedef ::mozilla::layers::CrossProcessSemaphoreDescriptor CrossProcessSemaphoreDescriptor;
    typedef ::uintptr_t uintptr_t;
    typedef ::mozilla::null_t null_t;
    typedef UntrustedShmemSection UntrustedShmemSection__tdef;
    typedef CrossProcessSemaphoreDescriptor CrossProcessSemaphoreDescriptor__tdef;
    typedef uintptr_t uintptr_t__tdef;
    typedef null_t null_t__tdef;

    UntrustedShmemSection*
    ptr_UntrustedShmemSection()
    {
        return (&(mVUntrustedShmemSection));
    }
    const UntrustedShmemSection*
    constptr_UntrustedShmemSection() const
    {
        return (&(mVUntrustedShmemSection));
    }
    CrossProcessSemaphoreDescriptor*
    ptr_CrossProcessSemaphoreDescriptor()
    {
        return (&(mVCrossProcessSemaphoreDescriptor));
    }
    const CrossProcessSemaphoreDescriptor*
    constptr_CrossProcessSemaphoreDescriptor() const
    {
        return (&(mVCrossProcessSemaphoreDescriptor));
    }
    uintptr_t*
    ptr_uintptr_t()
    {
        return (&(mVuintptr_t));
    }
    const uintptr_t*
    constptr_uintptr_t() const
    {
        return (&(mVuintptr_t));
    }
    null_t*
    ptr_null_t()
    {
        return (&(mVnull_t));
    }
    const null_t*
    constptr_null_t() const
    {
        return (&(mVnull_t));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT ReadLockDescriptor() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT ReadLockDescriptor(const UntrustedShmemSection& aOther);

    MOZ_IMPLICIT ReadLockDescriptor(UntrustedShmemSection&& aOther);

    MOZ_IMPLICIT ReadLockDescriptor(CrossProcessSemaphoreDescriptor&& aOther);

    MOZ_IMPLICIT ReadLockDescriptor(const uintptr_t& aOther);

    MOZ_IMPLICIT ReadLockDescriptor(uintptr_t&& aOther);

    MOZ_IMPLICIT ReadLockDescriptor(const null_t& aOther);

    MOZ_IMPLICIT ReadLockDescriptor(null_t&& aOther);

    MOZ_IMPLICIT ReadLockDescriptor(ReadLockDescriptor&& aOther);

    ~ReadLockDescriptor();

    Type
    type() const
    {
        return mType;
    }

    ReadLockDescriptor&
    operator=(const UntrustedShmemSection& aRhs);

    ReadLockDescriptor&
    operator=(UntrustedShmemSection&& aRhs);

    ReadLockDescriptor&
    operator=(CrossProcessSemaphoreDescriptor&& aRhs);

    ReadLockDescriptor&
    operator=(const uintptr_t& aRhs);

    ReadLockDescriptor&
    operator=(uintptr_t&& aRhs);

    ReadLockDescriptor&
    operator=(const null_t& aRhs);

    ReadLockDescriptor&
    operator=(null_t&& aRhs);

    ReadLockDescriptor&
    operator=(ReadLockDescriptor&& aRhs);

    UntrustedShmemSection&
    get_UntrustedShmemSection()
    {
        AssertSanity(TUntrustedShmemSection);
        return (*(ptr_UntrustedShmemSection()));
    }
    const UntrustedShmemSection&
    get_UntrustedShmemSection() const
    {
        AssertSanity(TUntrustedShmemSection);
        return (*(constptr_UntrustedShmemSection()));
    }
    operator UntrustedShmemSection&()
    {
        return get_UntrustedShmemSection();
    }
    operator const UntrustedShmemSection&() const
    {
        return get_UntrustedShmemSection();
    }

    CrossProcessSemaphoreDescriptor&
    get_CrossProcessSemaphoreDescriptor()
    {
        AssertSanity(TCrossProcessSemaphoreDescriptor);
        return (*(ptr_CrossProcessSemaphoreDescriptor()));
    }
    const CrossProcessSemaphoreDescriptor&
    get_CrossProcessSemaphoreDescriptor() const
    {
        AssertSanity(TCrossProcessSemaphoreDescriptor);
        return (*(constptr_CrossProcessSemaphoreDescriptor()));
    }
    operator CrossProcessSemaphoreDescriptor&()
    {
        return get_CrossProcessSemaphoreDescriptor();
    }
    operator const CrossProcessSemaphoreDescriptor&() const
    {
        return get_CrossProcessSemaphoreDescriptor();
    }

    uintptr_t&
    get_uintptr_t()
    {
        AssertSanity(Tuintptr_t);
        return (*(ptr_uintptr_t()));
    }
    const uintptr_t&
    get_uintptr_t() const
    {
        AssertSanity(Tuintptr_t);
        return (*(constptr_uintptr_t()));
    }
    operator uintptr_t&()
    {
        return get_uintptr_t();
    }
    operator const uintptr_t&() const
    {
        return get_uintptr_t();
    }

    null_t&
    get_null_t()
    {
        AssertSanity(Tnull_t);
        return (*(ptr_null_t()));
    }
    const null_t&
    get_null_t() const
    {
        AssertSanity(Tnull_t);
        return (*(constptr_null_t()));
    }
    operator null_t&()
    {
        return get_null_t();
    }
    operator const null_t&() const
    {
        return get_null_t();
    }

private:
    union {
        UntrustedShmemSection mVUntrustedShmemSection;
        CrossProcessSemaphoreDescriptor mVCrossProcessSemaphoreDescriptor;
        uintptr_t mVuintptr_t;
        null_t mVnull_t;
    };
    Type mType;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::ReadLockDescriptor>
{
    typedef ::mozilla::layers::ReadLockDescriptor paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            paramType&& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC

namespace mozilla {
namespace layers {
class PTextureParent;
} // namespace layers
} // namespace mozilla

namespace mozilla {
namespace layers {
class PTextureChild;
} // namespace layers
} // namespace mozilla


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct OpRemoveTexture|
//
namespace mozilla {
namespace layers {
class OpRemoveTexture final
{
private:
    typedef ::mozilla::layers::PTextureParent PTextureParent;
    typedef ::mozilla::layers::PTextureChild PTextureChild;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    OpRemoveTexture() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT OpRemoveTexture(const mozilla::NotNull<::mozilla::ipc::SideVariant<PTextureParent*, PTextureChild*>>& _texture) :
        texture_(_texture)
    {
    }

    MOZ_IMPLICIT OpRemoveTexture(mozilla::NotNull<::mozilla::ipc::SideVariant<PTextureParent*, PTextureChild*>>&& _texture) :
        texture_(std::move(_texture))
    {
    }

    mozilla::NotNull<::mozilla::ipc::SideVariant<PTextureParent*, PTextureChild*>>&
    texture()
    {
        return texture_;
    }
    const mozilla::NotNull<::mozilla::ipc::SideVariant<PTextureParent*, PTextureChild*>>&
    texture() const
    {
        return texture_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<mozilla::NotNull<::mozilla::ipc::SideVariant<PTextureParent*, PTextureChild*>>> texture_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::OpRemoveTexture>
{
    typedef ::mozilla::layers::OpRemoveTexture paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct OpClearImages|
//
namespace mozilla {
namespace layers {
class OpClearImages final
{
private:
    typedef ::mozilla::layers::ClearImagesType ClearImagesType;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    OpClearImages() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT OpClearImages(const ClearImagesType& _type) :
        type_(_type)
    {
    }

    MOZ_IMPLICIT OpClearImages(ClearImagesType&& _type) :
        type_(std::move(_type))
    {
    }

    ClearImagesType&
    type()
    {
        return type_;
    }
    const ClearImagesType&
    type() const
    {
        return type_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<ClearImagesType> type_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::OpClearImages>
{
    typedef ::mozilla::layers::OpClearImages paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC

namespace mozilla {
namespace layers {
class PTextureParent;
} // namespace layers
} // namespace mozilla

namespace mozilla {
namespace layers {
class PTextureChild;
} // namespace layers
} // namespace mozilla


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct TimedTexture|
//
namespace mozilla {
namespace layers {
class TimedTexture final
{
private:
    typedef ::mozilla::layers::PTextureParent PTextureParent;
    typedef ::mozilla::layers::PTextureChild PTextureChild;
    typedef ::mozilla::TimeStamp TimeStamp;
    typedef ::mozilla::gfx::IntRect IntRect;
    typedef ::uint32_t uint32_t;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    TimedTexture() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT TimedTexture(
            const mozilla::NotNull<::mozilla::ipc::SideVariant<PTextureParent*, PTextureChild*>>& _texture,
            const TimeStamp& _timeStamp,
            const IntRect& _picture,
            const uint32_t& _frameID,
            const uint32_t& _producerID,
            const bool& _readLocked) :
        texture_(_texture),
        timeStamp_(_timeStamp),
        picture_(_picture),
        readLocked_(_readLocked),
        frameID_(_frameID),
        producerID_(_producerID)
    {
    }

    MOZ_IMPLICIT TimedTexture(
            mozilla::NotNull<::mozilla::ipc::SideVariant<PTextureParent*, PTextureChild*>>&& _texture,
            TimeStamp&& _timeStamp,
            IntRect&& _picture,
            uint32_t&& _frameID,
            uint32_t&& _producerID,
            bool&& _readLocked) :
        texture_(std::move(_texture)),
        timeStamp_(std::move(_timeStamp)),
        picture_(std::move(_picture)),
        readLocked_(std::move(_readLocked)),
        frameID_(std::move(_frameID)),
        producerID_(std::move(_producerID))
    {
    }

    mozilla::NotNull<::mozilla::ipc::SideVariant<PTextureParent*, PTextureChild*>>&
    texture()
    {
        return texture_;
    }
    const mozilla::NotNull<::mozilla::ipc::SideVariant<PTextureParent*, PTextureChild*>>&
    texture() const
    {
        return texture_;
    }

    TimeStamp&
    timeStamp()
    {
        return timeStamp_;
    }
    const TimeStamp&
    timeStamp() const
    {
        return timeStamp_;
    }

    IntRect&
    picture()
    {
        return picture_;
    }
    const IntRect&
    picture() const
    {
        return picture_;
    }

    uint32_t&
    frameID()
    {
        return frameID_;
    }
    const uint32_t&
    frameID() const
    {
        return frameID_;
    }

    uint32_t&
    producerID()
    {
        return producerID_;
    }
    const uint32_t&
    producerID() const
    {
        return producerID_;
    }

    bool&
    readLocked()
    {
        return readLocked_;
    }
    const bool&
    readLocked() const
    {
        return readLocked_;
    }

private:
    void
    StaticAssertions() const;
    ::mozilla::ipc::IPDLStructMember<mozilla::NotNull<::mozilla::ipc::SideVariant<PTextureParent*, PTextureChild*>>> texture_;
    ::mozilla::ipc::IPDLStructMember<TimeStamp> timeStamp_;
    ::mozilla::ipc::IPDLStructMember<IntRect> picture_;
    ::mozilla::ipc::IPDLStructMember<bool> readLocked_;
    ::mozilla::ipc::IPDLStructMember<uint32_t> frameID_;
    ::mozilla::ipc::IPDLStructMember<uint32_t> producerID_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::TimedTexture>
{
    typedef ::mozilla::layers::TimedTexture paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct OpUseTexture|
//
namespace mozilla {
namespace layers {
class OpUseTexture final
{
private:
    typedef ::mozilla::layers::TimedTexture TimedTexture;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    OpUseTexture() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT OpUseTexture(const nsTArray<TimedTexture>& _textures) :
        textures_(_textures)
    {
    }

    MOZ_IMPLICIT OpUseTexture(nsTArray<TimedTexture>&& _textures) :
        textures_(std::move(_textures))
    {
    }

    nsTArray<TimedTexture>&
    textures()
    {
        return textures_;
    }
    const nsTArray<TimedTexture>&
    textures() const
    {
        return textures_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<TimedTexture>> textures_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::OpUseTexture>
{
    typedef ::mozilla::layers::OpUseTexture paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct OpUseRemoteTexture|
//
namespace mozilla {
namespace layers {
class OpUseRemoteTexture final
{
private:
    typedef ::mozilla::layers::RemoteTextureId RemoteTextureId;
    typedef ::mozilla::layers::RemoteTextureOwnerId RemoteTextureOwnerId;
    typedef ::mozilla::gfx::IntSize IntSize;
    typedef ::mozilla::layers::TextureFlags TextureFlags;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    OpUseRemoteTexture() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT OpUseRemoteTexture(
            const RemoteTextureId& _textureId,
            const RemoteTextureOwnerId& _ownerId,
            const IntSize& _size,
            const TextureFlags& _textureFlags) :
        textureId_(_textureId),
        ownerId_(_ownerId),
        size_(_size),
        textureFlags_(_textureFlags)
    {
    }

    MOZ_IMPLICIT OpUseRemoteTexture(
            RemoteTextureId&& _textureId,
            RemoteTextureOwnerId&& _ownerId,
            IntSize&& _size,
            TextureFlags&& _textureFlags) :
        textureId_(std::move(_textureId)),
        ownerId_(std::move(_ownerId)),
        size_(std::move(_size)),
        textureFlags_(std::move(_textureFlags))
    {
    }

    RemoteTextureId&
    textureId()
    {
        return textureId_;
    }
    const RemoteTextureId&
    textureId() const
    {
        return textureId_;
    }

    RemoteTextureOwnerId&
    ownerId()
    {
        return ownerId_;
    }
    const RemoteTextureOwnerId&
    ownerId() const
    {
        return ownerId_;
    }

    IntSize&
    size()
    {
        return size_;
    }
    const IntSize&
    size() const
    {
        return size_;
    }

    TextureFlags&
    textureFlags()
    {
        return textureFlags_;
    }
    const TextureFlags&
    textureFlags() const
    {
        return textureFlags_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<RemoteTextureId> textureId_;
    ::mozilla::ipc::IPDLStructMember<RemoteTextureOwnerId> ownerId_;
    ::mozilla::ipc::IPDLStructMember<IntSize> size_;
    ::mozilla::ipc::IPDLStructMember<TextureFlags> textureFlags_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::OpUseRemoteTexture>
{
    typedef ::mozilla::layers::OpUseRemoteTexture paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct OpEnableRemoteTexturePushCallback|
//
namespace mozilla {
namespace layers {
class OpEnableRemoteTexturePushCallback final
{
private:
    typedef ::mozilla::layers::RemoteTextureOwnerId RemoteTextureOwnerId;
    typedef ::mozilla::gfx::IntSize IntSize;
    typedef ::mozilla::layers::TextureFlags TextureFlags;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    OpEnableRemoteTexturePushCallback() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT OpEnableRemoteTexturePushCallback(
            const RemoteTextureOwnerId& _ownerId,
            const IntSize& _size,
            const TextureFlags& _textureFlags) :
        ownerId_(_ownerId),
        size_(_size),
        textureFlags_(_textureFlags)
    {
    }

    MOZ_IMPLICIT OpEnableRemoteTexturePushCallback(
            RemoteTextureOwnerId&& _ownerId,
            IntSize&& _size,
            TextureFlags&& _textureFlags) :
        ownerId_(std::move(_ownerId)),
        size_(std::move(_size)),
        textureFlags_(std::move(_textureFlags))
    {
    }

    RemoteTextureOwnerId&
    ownerId()
    {
        return ownerId_;
    }
    const RemoteTextureOwnerId&
    ownerId() const
    {
        return ownerId_;
    }

    IntSize&
    size()
    {
        return size_;
    }
    const IntSize&
    size() const
    {
        return size_;
    }

    TextureFlags&
    textureFlags()
    {
        return textureFlags_;
    }
    const TextureFlags&
    textureFlags() const
    {
        return textureFlags_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<RemoteTextureOwnerId> ownerId_;
    ::mozilla::ipc::IPDLStructMember<IntSize> size_;
    ::mozilla::ipc::IPDLStructMember<TextureFlags> textureFlags_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::OpEnableRemoteTexturePushCallback>
{
    typedef ::mozilla::layers::OpEnableRemoteTexturePushCallback paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct OpNotifyNotUsed|
//
namespace mozilla {
namespace layers {
class OpNotifyNotUsed final
{
private:
    typedef ::uint64_t uint64_t;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    OpNotifyNotUsed() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT OpNotifyNotUsed(
            const uint64_t& _TextureId,
            const uint64_t& _fwdTransactionId) :
        TextureId_(_TextureId),
        fwdTransactionId_(_fwdTransactionId)
    {
    }

    MOZ_IMPLICIT OpNotifyNotUsed(
            uint64_t&& _TextureId,
            uint64_t&& _fwdTransactionId) :
        TextureId_(std::move(_TextureId)),
        fwdTransactionId_(std::move(_fwdTransactionId))
    {
    }

    uint64_t&
    TextureId()
    {
        return TextureId_;
    }
    const uint64_t&
    TextureId() const
    {
        return TextureId_;
    }

    uint64_t&
    fwdTransactionId()
    {
        return fwdTransactionId_;
    }
    const uint64_t&
    fwdTransactionId() const
    {
        return fwdTransactionId_;
    }

private:
    void
    StaticAssertions() const;
    ::mozilla::ipc::IPDLStructMember<uint64_t> TextureId_;
    ::mozilla::ipc::IPDLStructMember<uint64_t> fwdTransactionId_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::OpNotifyNotUsed>
{
    typedef ::mozilla::layers::OpNotifyNotUsed paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union CompositableOperationDetail|
//
namespace mozilla {
namespace layers {
class CompositableOperationDetail final
{
public:
    enum Type {
        T__None,
        TOpRemoveTexture = 1,
        TOpClearImages,
        TOpUseTexture,
        TOpUseRemoteTexture,
        TOpEnableRemoteTexturePushCallback,
        T__Last = TOpEnableRemoteTexturePushCallback
    };

private:
    typedef ::mozilla::layers::OpRemoveTexture OpRemoveTexture;
    typedef ::mozilla::layers::OpClearImages OpClearImages;
    typedef ::mozilla::layers::OpUseTexture OpUseTexture;
    typedef ::mozilla::layers::OpUseRemoteTexture OpUseRemoteTexture;
    typedef ::mozilla::layers::OpEnableRemoteTexturePushCallback OpEnableRemoteTexturePushCallback;
    typedef OpRemoveTexture OpRemoveTexture__tdef;
    typedef OpClearImages OpClearImages__tdef;
    typedef OpUseTexture OpUseTexture__tdef;
    typedef OpUseRemoteTexture OpUseRemoteTexture__tdef;
    typedef OpEnableRemoteTexturePushCallback OpEnableRemoteTexturePushCallback__tdef;

    OpRemoveTexture*
    ptr_OpRemoveTexture()
    {
        return (&(mVOpRemoveTexture));
    }
    const OpRemoveTexture*
    constptr_OpRemoveTexture() const
    {
        return (&(mVOpRemoveTexture));
    }
    OpClearImages*
    ptr_OpClearImages()
    {
        return (&(mVOpClearImages));
    }
    const OpClearImages*
    constptr_OpClearImages() const
    {
        return (&(mVOpClearImages));
    }
    OpUseTexture*
    ptr_OpUseTexture()
    {
        return (&(mVOpUseTexture));
    }
    const OpUseTexture*
    constptr_OpUseTexture() const
    {
        return (&(mVOpUseTexture));
    }
    OpUseRemoteTexture*
    ptr_OpUseRemoteTexture()
    {
        return (&(mVOpUseRemoteTexture));
    }
    const OpUseRemoteTexture*
    constptr_OpUseRemoteTexture() const
    {
        return (&(mVOpUseRemoteTexture));
    }
    OpEnableRemoteTexturePushCallback*
    ptr_OpEnableRemoteTexturePushCallback()
    {
        return (&(mVOpEnableRemoteTexturePushCallback));
    }
    const OpEnableRemoteTexturePushCallback*
    constptr_OpEnableRemoteTexturePushCallback() const
    {
        return (&(mVOpEnableRemoteTexturePushCallback));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT CompositableOperationDetail() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT CompositableOperationDetail(const OpRemoveTexture& aOther);

    MOZ_IMPLICIT CompositableOperationDetail(OpRemoveTexture&& aOther);

    MOZ_IMPLICIT CompositableOperationDetail(const OpClearImages& aOther);

    MOZ_IMPLICIT CompositableOperationDetail(OpClearImages&& aOther);

    MOZ_IMPLICIT CompositableOperationDetail(const OpUseTexture& aOther);

    MOZ_IMPLICIT CompositableOperationDetail(OpUseTexture&& aOther);

    MOZ_IMPLICIT CompositableOperationDetail(const OpUseRemoteTexture& aOther);

    MOZ_IMPLICIT CompositableOperationDetail(OpUseRemoteTexture&& aOther);

    MOZ_IMPLICIT CompositableOperationDetail(const OpEnableRemoteTexturePushCallback& aOther);

    MOZ_IMPLICIT CompositableOperationDetail(OpEnableRemoteTexturePushCallback&& aOther);

    MOZ_IMPLICIT CompositableOperationDetail(const CompositableOperationDetail& aOther);

    MOZ_IMPLICIT CompositableOperationDetail(CompositableOperationDetail&& aOther);

    ~CompositableOperationDetail();

    Type
    type() const
    {
        return mType;
    }

    CompositableOperationDetail&
    operator=(const OpRemoveTexture& aRhs);

    CompositableOperationDetail&
    operator=(OpRemoveTexture&& aRhs);

    CompositableOperationDetail&
    operator=(const OpClearImages& aRhs);

    CompositableOperationDetail&
    operator=(OpClearImages&& aRhs);

    CompositableOperationDetail&
    operator=(const OpUseTexture& aRhs);

    CompositableOperationDetail&
    operator=(OpUseTexture&& aRhs);

    CompositableOperationDetail&
    operator=(const OpUseRemoteTexture& aRhs);

    CompositableOperationDetail&
    operator=(OpUseRemoteTexture&& aRhs);

    CompositableOperationDetail&
    operator=(const OpEnableRemoteTexturePushCallback& aRhs);

    CompositableOperationDetail&
    operator=(OpEnableRemoteTexturePushCallback&& aRhs);

    CompositableOperationDetail&
    operator=(const CompositableOperationDetail& aRhs);

    CompositableOperationDetail&
    operator=(CompositableOperationDetail&& aRhs);

    OpRemoveTexture&
    get_OpRemoveTexture()
    {
        AssertSanity(TOpRemoveTexture);
        return (*(ptr_OpRemoveTexture()));
    }
    const OpRemoveTexture&
    get_OpRemoveTexture() const
    {
        AssertSanity(TOpRemoveTexture);
        return (*(constptr_OpRemoveTexture()));
    }
    operator OpRemoveTexture&()
    {
        return get_OpRemoveTexture();
    }
    operator const OpRemoveTexture&() const
    {
        return get_OpRemoveTexture();
    }

    OpClearImages&
    get_OpClearImages()
    {
        AssertSanity(TOpClearImages);
        return (*(ptr_OpClearImages()));
    }
    const OpClearImages&
    get_OpClearImages() const
    {
        AssertSanity(TOpClearImages);
        return (*(constptr_OpClearImages()));
    }
    operator OpClearImages&()
    {
        return get_OpClearImages();
    }
    operator const OpClearImages&() const
    {
        return get_OpClearImages();
    }

    OpUseTexture&
    get_OpUseTexture()
    {
        AssertSanity(TOpUseTexture);
        return (*(ptr_OpUseTexture()));
    }
    const OpUseTexture&
    get_OpUseTexture() const
    {
        AssertSanity(TOpUseTexture);
        return (*(constptr_OpUseTexture()));
    }
    operator OpUseTexture&()
    {
        return get_OpUseTexture();
    }
    operator const OpUseTexture&() const
    {
        return get_OpUseTexture();
    }

    OpUseRemoteTexture&
    get_OpUseRemoteTexture()
    {
        AssertSanity(TOpUseRemoteTexture);
        return (*(ptr_OpUseRemoteTexture()));
    }
    const OpUseRemoteTexture&
    get_OpUseRemoteTexture() const
    {
        AssertSanity(TOpUseRemoteTexture);
        return (*(constptr_OpUseRemoteTexture()));
    }
    operator OpUseRemoteTexture&()
    {
        return get_OpUseRemoteTexture();
    }
    operator const OpUseRemoteTexture&() const
    {
        return get_OpUseRemoteTexture();
    }

    OpEnableRemoteTexturePushCallback&
    get_OpEnableRemoteTexturePushCallback()
    {
        AssertSanity(TOpEnableRemoteTexturePushCallback);
        return (*(ptr_OpEnableRemoteTexturePushCallback()));
    }
    const OpEnableRemoteTexturePushCallback&
    get_OpEnableRemoteTexturePushCallback() const
    {
        AssertSanity(TOpEnableRemoteTexturePushCallback);
        return (*(constptr_OpEnableRemoteTexturePushCallback()));
    }
    operator OpEnableRemoteTexturePushCallback&()
    {
        return get_OpEnableRemoteTexturePushCallback();
    }
    operator const OpEnableRemoteTexturePushCallback&() const
    {
        return get_OpEnableRemoteTexturePushCallback();
    }

private:
    union {
        OpRemoveTexture mVOpRemoveTexture;
        OpClearImages mVOpClearImages;
        OpUseTexture mVOpUseTexture;
        OpUseRemoteTexture mVOpUseRemoteTexture;
        OpEnableRemoteTexturePushCallback mVOpEnableRemoteTexturePushCallback;
    };
    Type mType;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::CompositableOperationDetail>
{
    typedef ::mozilla::layers::CompositableOperationDetail paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct CompositableOperation|
//
namespace mozilla {
namespace layers {
class CompositableOperation final
{
private:
    typedef ::mozilla::layers::CompositableHandle CompositableHandle;
    typedef ::mozilla::layers::CompositableOperationDetail CompositableOperationDetail;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    CompositableOperation() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT CompositableOperation(
            const CompositableHandle& _compositable,
            const CompositableOperationDetail& _detail) :
        compositable_(_compositable),
        detail_(_detail)
    {
    }

    MOZ_IMPLICIT CompositableOperation(
            CompositableHandle&& _compositable,
            CompositableOperationDetail&& _detail) :
        compositable_(std::move(_compositable)),
        detail_(std::move(_detail))
    {
    }

    CompositableHandle&
    compositable()
    {
        return compositable_;
    }
    const CompositableHandle&
    compositable() const
    {
        return compositable_;
    }

    CompositableOperationDetail&
    detail()
    {
        return detail_;
    }
    const CompositableOperationDetail&
    detail() const
    {
        return detail_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<CompositableHandle> compositable_;
    ::mozilla::ipc::IPDLStructMember<CompositableOperationDetail> detail_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::CompositableOperation>
{
    typedef ::mozilla::layers::CompositableOperation paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC

namespace mozilla {
namespace layers {
class PTextureParent;
} // namespace layers
} // namespace mozilla

namespace mozilla {
namespace layers {
class PTextureChild;
} // namespace layers
} // namespace mozilla


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union OpDestroy|
//
namespace mozilla {
namespace layers {
class OpDestroy final
{
public:
    enum Type {
        T__None,
        TPTexture = 1,
        TCompositableHandle,
        T__Last = TCompositableHandle
    };

private:
    typedef ::mozilla::layers::PTextureParent PTextureParent;
    typedef ::mozilla::layers::PTextureChild PTextureChild;
    typedef ::mozilla::layers::CompositableHandle CompositableHandle;
    typedef mozilla::NotNull<::mozilla::ipc::SideVariant<PTextureParent*, PTextureChild*>> PTexture__tdef;
    typedef CompositableHandle CompositableHandle__tdef;

    mozilla::NotNull<::mozilla::ipc::SideVariant<PTextureParent*, PTextureChild*>>*
    ptr_PTexture()
    {
        return (&(mVPTexture));
    }
    const mozilla::NotNull<::mozilla::ipc::SideVariant<PTextureParent*, PTextureChild*>>*
    constptr_PTexture() const
    {
        return (&(mVPTexture));
    }
    CompositableHandle*
    ptr_CompositableHandle()
    {
        return (&(mVCompositableHandle));
    }
    const CompositableHandle*
    constptr_CompositableHandle() const
    {
        return (&(mVCompositableHandle));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT OpDestroy() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT OpDestroy(const mozilla::NotNull<::mozilla::ipc::SideVariant<PTextureParent*, PTextureChild*>>& aOther);

    MOZ_IMPLICIT OpDestroy(mozilla::NotNull<::mozilla::ipc::SideVariant<PTextureParent*, PTextureChild*>>&& aOther);

    MOZ_IMPLICIT OpDestroy(const CompositableHandle& aOther);

    MOZ_IMPLICIT OpDestroy(CompositableHandle&& aOther);

    MOZ_IMPLICIT OpDestroy(const OpDestroy& aOther);

    MOZ_IMPLICIT OpDestroy(OpDestroy&& aOther);

    ~OpDestroy();

    Type
    type() const
    {
        return mType;
    }

    OpDestroy&
    operator=(const mozilla::NotNull<::mozilla::ipc::SideVariant<PTextureParent*, PTextureChild*>>& aRhs);

    OpDestroy&
    operator=(mozilla::NotNull<::mozilla::ipc::SideVariant<PTextureParent*, PTextureChild*>>&& aRhs);

    OpDestroy&
    operator=(const CompositableHandle& aRhs);

    OpDestroy&
    operator=(CompositableHandle&& aRhs);

    OpDestroy&
    operator=(const OpDestroy& aRhs);

    OpDestroy&
    operator=(OpDestroy&& aRhs);

    mozilla::NotNull<::mozilla::ipc::SideVariant<PTextureParent*, PTextureChild*>>&
    get_PTexture()
    {
        AssertSanity(TPTexture);
        return (*(ptr_PTexture()));
    }
    const mozilla::NotNull<::mozilla::ipc::SideVariant<PTextureParent*, PTextureChild*>>&
    get_PTexture() const
    {
        AssertSanity(TPTexture);
        return (*(constptr_PTexture()));
    }
    operator mozilla::NotNull<::mozilla::ipc::SideVariant<PTextureParent*, PTextureChild*>>&()
    {
        return get_PTexture();
    }
    operator const mozilla::NotNull<::mozilla::ipc::SideVariant<PTextureParent*, PTextureChild*>>&() const
    {
        return get_PTexture();
    }

    CompositableHandle&
    get_CompositableHandle()
    {
        AssertSanity(TCompositableHandle);
        return (*(ptr_CompositableHandle()));
    }
    const CompositableHandle&
    get_CompositableHandle() const
    {
        AssertSanity(TCompositableHandle);
        return (*(constptr_CompositableHandle()));
    }
    operator CompositableHandle&()
    {
        return get_CompositableHandle();
    }
    operator const CompositableHandle&() const
    {
        return get_CompositableHandle();
    }

private:
    union {
        mozilla::NotNull<::mozilla::ipc::SideVariant<PTextureParent*, PTextureChild*>> mVPTexture;
        CompositableHandle mVCompositableHandle;
    };
    Type mType;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::OpDestroy>
{
    typedef ::mozilla::layers::OpDestroy paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct OpContentBufferSwap|
//
namespace mozilla {
namespace layers {
class OpContentBufferSwap final
{
private:
    typedef ::mozilla::layers::CompositableHandle CompositableHandle;
    typedef ::nsIntRegion nsIntRegion;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    OpContentBufferSwap() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT OpContentBufferSwap(
            const CompositableHandle& _compositable,
            const nsIntRegion& _frontUpdatedRegion) :
        compositable_(_compositable),
        frontUpdatedRegion_(_frontUpdatedRegion)
    {
    }

    MOZ_IMPLICIT OpContentBufferSwap(
            CompositableHandle&& _compositable,
            nsIntRegion&& _frontUpdatedRegion) :
        compositable_(std::move(_compositable)),
        frontUpdatedRegion_(std::move(_frontUpdatedRegion))
    {
    }

    CompositableHandle&
    compositable()
    {
        return compositable_;
    }
    const CompositableHandle&
    compositable() const
    {
        return compositable_;
    }

    nsIntRegion&
    frontUpdatedRegion()
    {
        return frontUpdatedRegion_;
    }
    const nsIntRegion&
    frontUpdatedRegion() const
    {
        return frontUpdatedRegion_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<CompositableHandle> compositable_;
    ::mozilla::ipc::IPDLStructMember<nsIntRegion> frontUpdatedRegion_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::OpContentBufferSwap>
{
    typedef ::mozilla::layers::OpContentBufferSwap paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ImageCompositeNotification|
//
namespace mozilla {
namespace layers {
class ImageCompositeNotification final
{
private:
    typedef ::mozilla::layers::CompositableHandle CompositableHandle;
    typedef ::mozilla::TimeStamp TimeStamp;
    typedef ::uint32_t uint32_t;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ImageCompositeNotification() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ImageCompositeNotification(
            const CompositableHandle& _compositable,
            const TimeStamp& _imageTimeStamp,
            const TimeStamp& _firstCompositeTimeStamp,
            const uint32_t& _frameID,
            const uint32_t& _producerID) :
        compositable_(_compositable),
        imageTimeStamp_(_imageTimeStamp),
        firstCompositeTimeStamp_(_firstCompositeTimeStamp),
        frameID_(_frameID),
        producerID_(_producerID)
    {
    }

    MOZ_IMPLICIT ImageCompositeNotification(
            CompositableHandle&& _compositable,
            TimeStamp&& _imageTimeStamp,
            TimeStamp&& _firstCompositeTimeStamp,
            uint32_t&& _frameID,
            uint32_t&& _producerID) :
        compositable_(std::move(_compositable)),
        imageTimeStamp_(std::move(_imageTimeStamp)),
        firstCompositeTimeStamp_(std::move(_firstCompositeTimeStamp)),
        frameID_(std::move(_frameID)),
        producerID_(std::move(_producerID))
    {
    }

    CompositableHandle&
    compositable()
    {
        return compositable_;
    }
    const CompositableHandle&
    compositable() const
    {
        return compositable_;
    }

    TimeStamp&
    imageTimeStamp()
    {
        return imageTimeStamp_;
    }
    const TimeStamp&
    imageTimeStamp() const
    {
        return imageTimeStamp_;
    }

    TimeStamp&
    firstCompositeTimeStamp()
    {
        return firstCompositeTimeStamp_;
    }
    const TimeStamp&
    firstCompositeTimeStamp() const
    {
        return firstCompositeTimeStamp_;
    }

    uint32_t&
    frameID()
    {
        return frameID_;
    }
    const uint32_t&
    frameID() const
    {
        return frameID_;
    }

    uint32_t&
    producerID()
    {
        return producerID_;
    }
    const uint32_t&
    producerID() const
    {
        return producerID_;
    }

private:
    void
    StaticAssertions() const;
    ::mozilla::ipc::IPDLStructMember<CompositableHandle> compositable_;
    ::mozilla::ipc::IPDLStructMember<TimeStamp> imageTimeStamp_;
    ::mozilla::ipc::IPDLStructMember<TimeStamp> firstCompositeTimeStamp_;
    ::mozilla::ipc::IPDLStructMember<uint32_t> frameID_;
    ::mozilla::ipc::IPDLStructMember<uint32_t> producerID_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::ImageCompositeNotification>
{
    typedef ::mozilla::layers::ImageCompositeNotification paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union AsyncParentMessageData|
//
namespace mozilla {
namespace layers {
class AsyncParentMessageData final
{
public:
    enum Type {
        T__None,
        TOpNotifyNotUsed = 1,
        T__Last = TOpNotifyNotUsed
    };

private:
    typedef ::mozilla::layers::OpNotifyNotUsed OpNotifyNotUsed;
    typedef OpNotifyNotUsed OpNotifyNotUsed__tdef;

    OpNotifyNotUsed*
    ptr_OpNotifyNotUsed()
    {
        return (&(mVOpNotifyNotUsed));
    }
    const OpNotifyNotUsed*
    constptr_OpNotifyNotUsed() const
    {
        return (&(mVOpNotifyNotUsed));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT AsyncParentMessageData() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT AsyncParentMessageData(const OpNotifyNotUsed& aOther);

    MOZ_IMPLICIT AsyncParentMessageData(OpNotifyNotUsed&& aOther);

    MOZ_IMPLICIT AsyncParentMessageData(const AsyncParentMessageData& aOther);

    MOZ_IMPLICIT AsyncParentMessageData(AsyncParentMessageData&& aOther);

    ~AsyncParentMessageData();

    Type
    type() const
    {
        return mType;
    }

    AsyncParentMessageData&
    operator=(const OpNotifyNotUsed& aRhs);

    AsyncParentMessageData&
    operator=(OpNotifyNotUsed&& aRhs);

    AsyncParentMessageData&
    operator=(const AsyncParentMessageData& aRhs);

    AsyncParentMessageData&
    operator=(AsyncParentMessageData&& aRhs);

    OpNotifyNotUsed&
    get_OpNotifyNotUsed()
    {
        AssertSanity(TOpNotifyNotUsed);
        return (*(ptr_OpNotifyNotUsed()));
    }
    const OpNotifyNotUsed&
    get_OpNotifyNotUsed() const
    {
        AssertSanity(TOpNotifyNotUsed);
        return (*(constptr_OpNotifyNotUsed()));
    }
    operator OpNotifyNotUsed&()
    {
        return get_OpNotifyNotUsed();
    }
    operator const OpNotifyNotUsed&() const
    {
        return get_OpNotifyNotUsed();
    }

private:
    union {
        OpNotifyNotUsed mVOpNotifyNotUsed;
    };
    Type mType;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::AsyncParentMessageData>
{
    typedef ::mozilla::layers::AsyncParentMessageData paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union OMTAValue|
//
namespace mozilla {
namespace layers {
class OMTAValue final
{
public:
    enum Type {
        T__None,
        Tnull_t = 1,
        Tnscolor,
        Tfloat,
        TMatrix4x4,
        T__Last = TMatrix4x4
    };

private:
    typedef ::mozilla::null_t null_t;
    typedef ::nscolor nscolor;
    typedef ::mozilla::gfx::Matrix4x4 Matrix4x4;
    typedef null_t null_t__tdef;
    typedef nscolor nscolor__tdef;
    typedef float float__tdef;
    typedef Matrix4x4 Matrix4x4__tdef;

    null_t*
    ptr_null_t()
    {
        return (&(mVnull_t));
    }
    const null_t*
    constptr_null_t() const
    {
        return (&(mVnull_t));
    }
    nscolor*
    ptr_nscolor()
    {
        return (&(mVnscolor));
    }
    const nscolor*
    constptr_nscolor() const
    {
        return (&(mVnscolor));
    }
    float*
    ptr_float()
    {
        return (&(mVfloat));
    }
    const float*
    constptr_float() const
    {
        return (&(mVfloat));
    }
    Matrix4x4*
    ptr_Matrix4x4()
    {
        return (&(mVMatrix4x4));
    }
    const Matrix4x4*
    constptr_Matrix4x4() const
    {
        return (&(mVMatrix4x4));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT OMTAValue() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT OMTAValue(const null_t& aOther);

    MOZ_IMPLICIT OMTAValue(null_t&& aOther);

    MOZ_IMPLICIT OMTAValue(const nscolor& aOther);

    MOZ_IMPLICIT OMTAValue(nscolor&& aOther);

    MOZ_IMPLICIT OMTAValue(const float& aOther);

    MOZ_IMPLICIT OMTAValue(float&& aOther);

    MOZ_IMPLICIT OMTAValue(const Matrix4x4& aOther);

    MOZ_IMPLICIT OMTAValue(Matrix4x4&& aOther);

    MOZ_IMPLICIT OMTAValue(const OMTAValue& aOther);

    MOZ_IMPLICIT OMTAValue(OMTAValue&& aOther);

    ~OMTAValue();

    Type
    type() const
    {
        return mType;
    }

    OMTAValue&
    operator=(const null_t& aRhs);

    OMTAValue&
    operator=(null_t&& aRhs);

    OMTAValue&
    operator=(const nscolor& aRhs);

    OMTAValue&
    operator=(nscolor&& aRhs);

    OMTAValue&
    operator=(const float& aRhs);

    OMTAValue&
    operator=(float&& aRhs);

    OMTAValue&
    operator=(const Matrix4x4& aRhs);

    OMTAValue&
    operator=(Matrix4x4&& aRhs);

    OMTAValue&
    operator=(const OMTAValue& aRhs);

    OMTAValue&
    operator=(OMTAValue&& aRhs);

    null_t&
    get_null_t()
    {
        AssertSanity(Tnull_t);
        return (*(ptr_null_t()));
    }
    const null_t&
    get_null_t() const
    {
        AssertSanity(Tnull_t);
        return (*(constptr_null_t()));
    }
    operator null_t&()
    {
        return get_null_t();
    }
    operator const null_t&() const
    {
        return get_null_t();
    }

    nscolor&
    get_nscolor()
    {
        AssertSanity(Tnscolor);
        return (*(ptr_nscolor()));
    }
    const nscolor&
    get_nscolor() const
    {
        AssertSanity(Tnscolor);
        return (*(constptr_nscolor()));
    }
    operator nscolor&()
    {
        return get_nscolor();
    }
    operator const nscolor&() const
    {
        return get_nscolor();
    }

    float&
    get_float()
    {
        AssertSanity(Tfloat);
        return (*(ptr_float()));
    }
    const float&
    get_float() const
    {
        AssertSanity(Tfloat);
        return (*(constptr_float()));
    }
    operator float&()
    {
        return get_float();
    }
    operator const float&() const
    {
        return get_float();
    }

    Matrix4x4&
    get_Matrix4x4()
    {
        AssertSanity(TMatrix4x4);
        return (*(ptr_Matrix4x4()));
    }
    const Matrix4x4&
    get_Matrix4x4() const
    {
        AssertSanity(TMatrix4x4);
        return (*(constptr_Matrix4x4()));
    }
    operator Matrix4x4&()
    {
        return get_Matrix4x4();
    }
    operator const Matrix4x4&() const
    {
        return get_Matrix4x4();
    }

private:
    union {
        null_t mVnull_t;
        nscolor mVnscolor;
        float mVfloat;
        Matrix4x4 mVMatrix4x4;
    };
    Type mType;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::OMTAValue>
{
    typedef ::mozilla::layers::OMTAValue paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC

#endif // ifndef LayersMessages_h
