// -*- mode: C++ -*-

/* This file is auto-generated by run_glean_parser.py.
   It is only for internal use by types in
   toolkit/components/glean/bindings/private */

#include "mozilla/glean/bindings/HistogramGIFFTMap.h"
#include "mozilla/glean/bindings/GleanJSMetricsLookup.h"
#include "mozilla/glean/bindings/jog/JOG.h"

#define DYNAMIC_METRIC_BIT (26)
#define GLEAN_METRIC_ID(id) ((id) & ((1ULL << 27) - 1))

namespace mozilla::glean {

using Telemetry::HistogramID;

Maybe<HistogramID> HistogramIdForMetric(uint32_t aId) {
  switch(aId) {
    case 3: { // a11y.consumers
      return Some(HistogramID::A11Y_CONSUMERS);
    }
    case 9: { // a11y.tree_update_timing
      return Some(HistogramID::A11Y_TREE_UPDATE_TIMING_MS);
    }
    case 11: { // fullscreen.change
      return Some(HistogramID::FULLSCREEN_CHANGE_MS);
    }
    case 14: { // browser.engagement.total_top_visits
      return Some(HistogramID::FX_TOTAL_TOP_VISITS);
    }
    case 19: { // browser.engagement.tab_unload_to_reload
      return Some(HistogramID::TAB_UNLOAD_TO_RELOAD);
    }
    case 21: { // browser.engagement.loaded_tab_count
      return Some(HistogramID::LOADED_TAB_COUNT);
    }
    case 28: { // browser.engagement.tab_count
      return Some(HistogramID::TAB_COUNT);
    }
    case 40: { // browser.timings.new_window
      return Some(HistogramID::FX_NEW_WINDOW_MS);
    }
    case 41: { // browser.timings.page_load
      return Some(HistogramID::FX_PAGE_LOAD_MS_2);
    }
    case 42: { // browser.timings.page_reload_normal
      return Some(HistogramID::FX_PAGE_RELOAD_NORMAL_MS);
    }
    case 43: { // browser.timings.page_reload_skip_cache
      return Some(HistogramID::FX_PAGE_RELOAD_SKIP_CACHE_MS);
    }
    case 45: { // browser.timings.tab_click
      return Some(HistogramID::FX_TAB_CLICK_MS);
    }
    case 49: { // networking.cache_metadata_first_read_time
      return Some(HistogramID::NETWORK_CACHE_METADATA_FIRST_READ_TIME_MS);
    }
    case 50: { // networking.cache_metadata_second_read_time
      return Some(HistogramID::NETWORK_CACHE_METADATA_SECOND_READ_TIME_MS);
    }
    case 64: { // networking.dns_failed_lookup_time
      return Some(HistogramID::DNS_FAILED_LOOKUP_TIME);
    }
    case 65: { // networking.dns_lookup_time
      return Some(HistogramID::DNS_LOOKUP_TIME);
    }
    case 68: { // networking.dns_renewal_time
      return Some(HistogramID::DNS_RENEWAL_TIME);
    }
    case 69: { // networking.dns_renewal_time_for_ttl
      return Some(HistogramID::DNS_RENEWAL_TIME_FOR_TTL);
    }
    case 70: { // networking.http3_channel_onstart_success
      return Some(HistogramID::HTTP3_CHANNEL_ONSTART_SUCCESS);
    }
    case 71: { // networking.http_1_download_throughput
      return Some(HistogramID::NETWORKING_DOWNLOAD_THROUGHPUT_HTTP_1);
    }
    case 75: { // networking.http_1_upload_throughput
      return Some(HistogramID::HTTP_UPLOAD_THROUGHPUT_MBPS_HTTP_1);
    }
    case 76: { // networking.http_1_upload_throughput_100
      return Some(HistogramID::HTTP_UPLOAD_THROUGHPUT_MBPS_HTTP_1_100);
    }
    case 77: { // networking.http_1_upload_throughput_10_50
      return Some(HistogramID::HTTP_UPLOAD_THROUGHPUT_MBPS_HTTP_1_10_50);
    }
    case 78: { // networking.http_1_upload_throughput_50_100
      return Some(HistogramID::HTTP_UPLOAD_THROUGHPUT_MBPS_HTTP_1_50_100);
    }
    case 79: { // networking.http_2_download_throughput
      return Some(HistogramID::NETWORKING_DOWNLOAD_THROUGHPUT_HTTP_2);
    }
    case 83: { // networking.http_2_upload_throughput
      return Some(HistogramID::HTTP_UPLOAD_THROUGHPUT_MBPS_HTTP_2);
    }
    case 84: { // networking.http_2_upload_throughput_100
      return Some(HistogramID::HTTP_UPLOAD_THROUGHPUT_MBPS_HTTP_2_100);
    }
    case 85: { // networking.http_2_upload_throughput_10_50
      return Some(HistogramID::HTTP_UPLOAD_THROUGHPUT_MBPS_HTTP_2_10_50);
    }
    case 86: { // networking.http_2_upload_throughput_50_100
      return Some(HistogramID::HTTP_UPLOAD_THROUGHPUT_MBPS_HTTP_2_50_100);
    }
    case 88: { // networking.http_3_download_throughput
      return Some(HistogramID::NETWORKING_DOWNLOAD_THROUGHPUT_HTTP_3);
    }
    case 103: { // networking.http_3_upload_throughput
      return Some(HistogramID::HTTP_UPLOAD_THROUGHPUT_MBPS_HTTP_3);
    }
    case 104: { // networking.http_3_upload_throughput_100
      return Some(HistogramID::HTTP_UPLOAD_THROUGHPUT_MBPS_HTTP_3_100);
    }
    case 105: { // networking.http_3_upload_throughput_10_50
      return Some(HistogramID::HTTP_UPLOAD_THROUGHPUT_MBPS_HTTP_3_10_50);
    }
    case 106: { // networking.http_3_upload_throughput_50_100
      return Some(HistogramID::HTTP_UPLOAD_THROUGHPUT_MBPS_HTTP_3_50_100);
    }
    case 114: { // networking.http_channel_disposition_upgrade
      return Some(HistogramID::HTTP_CHANNEL_DISPOSITION_UPGRADE);
    }
    case 121: { // networking.http_onstart_suspend_total_time
      return Some(HistogramID::HTTP_ONSTART_SUSPEND_TOTAL_TIME);
    }
    case 135: { // networking.prclose_tcp_blocking_time_connectivity_change
      return Some(HistogramID::PRCLOSE_TCP_BLOCKING_TIME_CONNECTIVITY_CHANGE);
    }
    case 136: { // networking.prclose_tcp_blocking_time_link_change
      return Some(HistogramID::PRCLOSE_TCP_BLOCKING_TIME_LINK_CHANGE);
    }
    case 137: { // networking.prclose_tcp_blocking_time_normal
      return Some(HistogramID::PRCLOSE_TCP_BLOCKING_TIME_NORMAL);
    }
    case 138: { // networking.prclose_tcp_blocking_time_offline
      return Some(HistogramID::PRCLOSE_TCP_BLOCKING_TIME_OFFLINE);
    }
    case 139: { // networking.prclose_tcp_blocking_time_shutdown
      return Some(HistogramID::PRCLOSE_TCP_BLOCKING_TIME_SHUTDOWN);
    }
    case 140: { // networking.prclose_udp_blocking_time_connectivity_change
      return Some(HistogramID::PRCLOSE_UDP_BLOCKING_TIME_CONNECTIVITY_CHANGE);
    }
    case 141: { // networking.prclose_udp_blocking_time_link_change
      return Some(HistogramID::PRCLOSE_UDP_BLOCKING_TIME_LINK_CHANGE);
    }
    case 142: { // networking.prclose_udp_blocking_time_normal
      return Some(HistogramID::PRCLOSE_UDP_BLOCKING_TIME_NORMAL);
    }
    case 143: { // networking.prclose_udp_blocking_time_offline
      return Some(HistogramID::PRCLOSE_UDP_BLOCKING_TIME_OFFLINE);
    }
    case 144: { // networking.prclose_udp_blocking_time_shutdown
      return Some(HistogramID::PRCLOSE_UDP_BLOCKING_TIME_SHUTDOWN);
    }
    case 145: { // networking.prconnect_blocking_time_connectivity_change
      return Some(HistogramID::PRCONNECT_BLOCKING_TIME_CONNECTIVITY_CHANGE);
    }
    case 146: { // networking.prconnect_blocking_time_link_change
      return Some(HistogramID::PRCONNECT_BLOCKING_TIME_LINK_CHANGE);
    }
    case 147: { // networking.prconnect_blocking_time_normal
      return Some(HistogramID::PRCONNECT_BLOCKING_TIME_NORMAL);
    }
    case 148: { // networking.prconnect_blocking_time_offline
      return Some(HistogramID::PRCONNECT_BLOCKING_TIME_OFFLINE);
    }
    case 149: { // networking.prconnect_blocking_time_shutdown
      return Some(HistogramID::PRCONNECT_BLOCKING_TIME_SHUTDOWN);
    }
    case 150: { // networking.prconnect_fail_blocking_time_connectivity_change
      return Some(HistogramID::PRCONNECT_FAIL_BLOCKING_TIME_CONNECTIVITY_CHANGE);
    }
    case 151: { // networking.prconnect_fail_blocking_time_link_change
      return Some(HistogramID::PRCONNECT_FAIL_BLOCKING_TIME_LINK_CHANGE);
    }
    case 152: { // networking.prconnect_fail_blocking_time_normal
      return Some(HistogramID::PRCONNECT_FAIL_BLOCKING_TIME_NORMAL);
    }
    case 153: { // networking.prconnect_fail_blocking_time_offline
      return Some(HistogramID::PRCONNECT_FAIL_BLOCKING_TIME_OFFLINE);
    }
    case 154: { // networking.prconnect_fail_blocking_time_shutdown
      return Some(HistogramID::PRCONNECT_FAIL_BLOCKING_TIME_SHUTDOWN);
    }
    case 155: { // networking.prconnectcontinue_blocking_time_connectivity_change
      return Some(HistogramID::PRCONNECTCONTINUE_BLOCKING_TIME_CONNECTIVITY_CHANGE);
    }
    case 156: { // networking.prconnectcontinue_blocking_time_link_change
      return Some(HistogramID::PRCONNECTCONTINUE_BLOCKING_TIME_LINK_CHANGE);
    }
    case 157: { // networking.prconnectcontinue_blocking_time_normal
      return Some(HistogramID::PRCONNECTCONTINUE_BLOCKING_TIME_NORMAL);
    }
    case 158: { // networking.prconnectcontinue_blocking_time_offline
      return Some(HistogramID::PRCONNECTCONTINUE_BLOCKING_TIME_OFFLINE);
    }
    case 159: { // networking.prconnectcontinue_blocking_time_shutdown
      return Some(HistogramID::PRCONNECTCONTINUE_BLOCKING_TIME_SHUTDOWN);
    }
    case 164: { // networking.sqlite_cookies_block_main_thread
      return Some(HistogramID::MOZ_SQLITE_COOKIES_BLOCK_MAIN_THREAD_MS_V2);
    }
    case 165: { // networking.sqlite_cookies_time_to_block_main_thread
      return Some(HistogramID::MOZ_SQLITE_COOKIES_TIME_TO_BLOCK_MAIN_THREAD_MS);
    }
    case 231: { // messaging_system.message_request_time
      return Some(HistogramID::MS_MESSAGE_REQUEST_TIME_MS);
    }
    case 255: { // browser.backup.compressed_archive_size
      return Some(HistogramID::BROWSER_BACKUP_COMPRESSED_ARCHIVE_SIZE);
    }
    case 266: { // browser.backup.favicons_time
      return Some(HistogramID::BROWSER_BACKUP_FAVICONS_TIME_MS);
    }
    case 274: { // browser.backup.places_time
      return Some(HistogramID::BROWSER_BACKUP_PLACES_TIME_MS);
    }
    case 293: { // browser.backup.total_backup_size
      return Some(HistogramID::BROWSER_BACKUP_TOTAL_BACKUP_SIZE);
    }
    case 294: { // browser.backup.total_backup_time
      return Some(HistogramID::BROWSER_BACKUP_TOTAL_BACKUP_TIME_MS);
    }
    case 308: { // downloads.user_action_on_blocked_download
      return Some(HistogramID::DOWNLOADS_USER_ACTION_ON_BLOCKED_DOWNLOAD);
    }
    case 313: { // firefoxview.cumulative_searches
      return Some(HistogramID::FIREFOX_VIEW_CUMULATIVE_SEARCHES);
    }
    case 406: { // browser.attribution_errors
      return Some(HistogramID::BROWSER_ATTRIBUTION_ERRORS);
    }
    case 408: { // browser.is_user_default
      return Some(HistogramID::BROWSER_IS_USER_DEFAULT);
    }
    case 409: { // browser.is_user_default_error
      return Some(HistogramID::BROWSER_IS_USER_DEFAULT_ERROR);
    }
    case 410: { // browser.set_default_always_check
      return Some(HistogramID::BROWSER_SET_DEFAULT_ALWAYS_CHECK);
    }
    case 411: { // browser.set_default_dialog_prompt_rawcount
      return Some(HistogramID::BROWSER_SET_DEFAULT_DIALOG_PROMPT_RAWCOUNT);
    }
    case 412: { // browser.set_default_error
      return Some(HistogramID::BROWSER_SET_DEFAULT_ERROR);
    }
    case 413: { // browser.set_default_pdf_handler_user_choice_result
      return Some(HistogramID::BROWSER_SET_DEFAULT_PDF_HANDLER_USER_CHOICE_RESULT);
    }
    case 414: { // browser.set_default_result
      return Some(HistogramID::BROWSER_SET_DEFAULT_RESULT);
    }
    case 415: { // browser.set_default_user_choice_result
      return Some(HistogramID::BROWSER_SET_DEFAULT_USER_CHOICE_RESULT);
    }
    case 450: { // security.https_only_mode_upgrade_time
      return Some(HistogramID::HTTPS_ONLY_MODE_UPGRADE_TIME_MS);
    }
    case 451: { // security.https_only_mode_upgrade_type
      return Some(HistogramID::HTTPS_ONLY_MODE_UPGRADE_TYPE);
    }
    case 453: { // security.referrer_policy_count
      return Some(HistogramID::REFERRER_POLICY_COUNT);
    }
    case 456: { // security.addon_signature_verification_status
      return Some(HistogramID::ADDON_SIGNATURE_VERIFICATION_STATUS);
    }
    case 459: { // security.content_signature_verification_status
      return Some(HistogramID::CONTENT_SIGNATURE_VERIFICATION_STATUS);
    }
    case 460: { // security.ntlm_module_used
      return Some(HistogramID::NTLM_MODULE_USED_2);
    }
    case 469: { // browser.migration.bookmarks_quantity
      return Some(HistogramID::FX_MIGRATION_BOOKMARKS_QUANTITY);
    }
    case 471: { // browser.migration.cards_quantity
      return Some(HistogramID::FX_MIGRATION_CARDS_QUANTITY);
    }
    case 473: { // browser.migration.entry_point_categorical
      return Some(HistogramID::FX_MIGRATION_ENTRY_POINT_CATEGORICAL);
    }
    case 474: { // browser.migration.errors
      return Some(HistogramID::FX_MIGRATION_ERRORS);
    }
    case 475: { // browser.migration.extensions_quantity
      return Some(HistogramID::FX_MIGRATION_EXTENSIONS_QUANTITY);
    }
    case 476: { // browser.migration.history_quantity
      return Some(HistogramID::FX_MIGRATION_HISTORY_QUANTITY);
    }
    case 478: { // browser.migration.logins_quantity
      return Some(HistogramID::FX_MIGRATION_LOGINS_QUANTITY);
    }
    case 488: { // browser.migration.source_browser
      return Some(HistogramID::FX_MIGRATION_SOURCE_BROWSER);
    }
    case 490: { // browser.migration.usage
      return Some(HistogramID::FX_MIGRATION_USAGE);
    }
    case 547: { // newtab.abouthome_cache_construction
      return Some(HistogramID::FX_ABOUTHOME_CACHE_CONSTRUCTION);
    }
    case 660: { // bookmarks_sidebar.cumulative_searches
      return Some(HistogramID::PLACES_BOOKMARKS_SEARCHBAR_CUMULATIVE_SEARCHES);
    }
    case 661: { // bookmarks_toolbar.init
      return Some(HistogramID::FX_BOOKMARKS_TOOLBAR_INIT_MS);
    }
    case 662: { // history_sidebar.cumulative_filter_count
      return Some(HistogramID::PLACES_SEARCHBAR_CUMULATIVE_FILTER_COUNT);
    }
    case 663: { // history_sidebar.cumulative_searches
      return Some(HistogramID::PLACES_SEARCHBAR_CUMULATIVE_SEARCHES);
    }
    case 664: { // history_sidebar.filter_type
      return Some(HistogramID::PLACES_SEARCHBAR_FILTER_TYPE);
    }
    case 665: { // history_sidebar.lastvisited_tree_query_time
      return Some(HistogramID::HISTORY_LASTVISITED_TREE_QUERY_TIME_MS);
    }
    case 666: { // library.cumulative_bookmark_searches
      return Some(HistogramID::PLACES_LIBRARY_CUMULATIVE_BOOKMARK_SEARCHES);
    }
    case 667: { // library.cumulative_history_searches
      return Some(HistogramID::PLACES_LIBRARY_CUMULATIVE_HISTORY_SEARCHES);
    }
    case 668: { // library.history_search_time
      return Some(HistogramID::PLACES_HISTORY_LIBRARY_SEARCH_TIME_MS);
    }
    case 818: { // sap.deprecated_counts
      return Some(HistogramID::SEARCH_COUNTS);
    }
    case 823: { // searchbar.selected_result_method
      return Some(HistogramID::FX_SEARCHBAR_SELECTED_RESULT_METHOD);
    }
    case 848: { // session_restore.all_files_corrupt
      return Some(HistogramID::FX_SESSION_RESTORE_ALL_FILES_CORRUPT);
    }
    case 849: { // session_restore.auto_restore_duration_until_eager_tabs_restored
      return Some(HistogramID::FX_SESSION_RESTORE_AUTO_RESTORE_DURATION_UNTIL_EAGER_TABS_RESTORED_MS);
    }
    case 851: { // session_restore.collect_all_windows_data
      return Some(HistogramID::FX_SESSION_RESTORE_COLLECT_ALL_WINDOWS_DATA_MS);
    }
    case 852: { // session_restore.collect_data
      return Some(HistogramID::FX_SESSION_RESTORE_COLLECT_DATA_MS);
    }
    case 853: { // session_restore.collect_session_history
      return Some(HistogramID::FX_SESSION_RESTORE_COLLECT_SESSION_HISTORY_MS);
    }
    case 854: { // session_restore.corrupt_file
      return Some(HistogramID::FX_SESSION_RESTORE_CORRUPT_FILE);
    }
    case 855: { // session_restore.file_size_bytes
      return Some(HistogramID::FX_SESSION_RESTORE_FILE_SIZE_BYTES);
    }
    case 856: { // session_restore.manual_restore_duration_until_eager_tabs_restored
      return Some(HistogramID::FX_SESSION_RESTORE_MANUAL_RESTORE_DURATION_UNTIL_EAGER_TABS_RESTORED_MS);
    }
    case 857: { // session_restore.number_of_eager_tabs_restored
      return Some(HistogramID::FX_SESSION_RESTORE_NUMBER_OF_EAGER_TABS_RESTORED);
    }
    case 858: { // session_restore.number_of_tabs_restored
      return Some(HistogramID::FX_SESSION_RESTORE_NUMBER_OF_TABS_RESTORED);
    }
    case 859: { // session_restore.number_of_windows_restored
      return Some(HistogramID::FX_SESSION_RESTORE_NUMBER_OF_WINDOWS_RESTORED);
    }
    case 860: { // session_restore.read_file
      return Some(HistogramID::FX_SESSION_RESTORE_READ_FILE_MS);
    }
    case 861: { // session_restore.restore_window
      return Some(HistogramID::FX_SESSION_RESTORE_RESTORE_WINDOW_MS);
    }
    case 863: { // session_restore.shutdown_ok
      return Some(HistogramID::SHUTDOWN_OK);
    }
    case 866: { // session_restore.startup_init_session
      return Some(HistogramID::FX_SESSION_RESTORE_STARTUP_INIT_SESSION_MS);
    }
    case 867: { // session_restore.startup_onload_initial_window
      return Some(HistogramID::FX_SESSION_RESTORE_STARTUP_ONLOAD_INITIAL_WINDOW_MS);
    }
    case 869: { // session_restore.write_file
      return Some(HistogramID::FX_SESSION_RESTORE_WRITE_FILE_MS);
    }
    case 915: { // browser.tabclose.permit_unload_time
      return Some(HistogramID::FX_TAB_CLOSE_PERMIT_UNLOAD_TIME_MS);
    }
    case 916: { // browser.tabclose.time_anim
      return Some(HistogramID::FX_TAB_CLOSE_TIME_ANIM_MS);
    }
    case 917: { // browser.tabclose.time_no_anim
      return Some(HistogramID::FX_TAB_CLOSE_TIME_NO_ANIM_MS);
    }
    case 918: { // browser.tabswitch.spinner_visible
      return Some(HistogramID::FX_TAB_SWITCH_SPINNER_VISIBLE_MS);
    }
    case 919: { // browser.tabswitch.spinner_visible_trigger
      return Some(HistogramID::FX_TAB_SWITCH_SPINNER_VISIBLE_TRIGGER);
    }
    case 920: { // browser.tabswitch.total
      return Some(HistogramID::FX_TAB_SWITCH_TOTAL_E10S_MS);
    }
    case 921: { // browser.tabswitch.update
      return Some(HistogramID::FX_TAB_SWITCH_UPDATE_MS);
    }
    case 982: { // text_recognition.api_performance
      return Some(HistogramID::TEXT_RECOGNITION_API_PERFORMANCE);
    }
    case 983: { // text_recognition.interaction_timing
      return Some(HistogramID::TEXT_RECOGNITION_INTERACTION_TIMING);
    }
    case 984: { // text_recognition.text_length
      return Some(HistogramID::TEXT_RECOGNITION_TEXT_LENGTH);
    }
    case 1006: { // urlbar.autocomplete_first_result_time
      return Some(HistogramID::PLACES_AUTOCOMPLETE_1ST_RESULT_TIME_MS);
    }
    case 1007: { // urlbar.autocomplete_sixth_result_time
      return Some(HistogramID::PLACES_AUTOCOMPLETE_6_FIRST_RESULTS_TIME_MS);
    }
    case 1036: { // browser.content_crash.dump_unavailable
      return Some(HistogramID::FX_CONTENT_CRASH_DUMP_UNAVAILABLE);
    }
    case 1037: { // browser.content_crash.not_submitted
      return Some(HistogramID::FX_CONTENT_CRASH_NOT_SUBMITTED);
    }
    case 1038: { // browser.sanitizer.cache
      return Some(HistogramID::FX_SANITIZE_CACHE);
    }
    case 1039: { // browser.sanitizer.cookies
      return Some(HistogramID::FX_SANITIZE_COOKIES_2);
    }
    case 1040: { // browser.sanitizer.downloads
      return Some(HistogramID::FX_SANITIZE_DOWNLOADS);
    }
    case 1041: { // browser.sanitizer.formdata
      return Some(HistogramID::FX_SANITIZE_FORMDATA);
    }
    case 1042: { // browser.sanitizer.history
      return Some(HistogramID::FX_SANITIZE_HISTORY);
    }
    case 1043: { // browser.sanitizer.openwindows
      return Some(HistogramID::FX_SANITIZE_OPENWINDOWS);
    }
    case 1044: { // browser.sanitizer.sessions
      return Some(HistogramID::FX_SANITIZE_SESSIONS);
    }
    case 1045: { // browser.sanitizer.sitesettings
      return Some(HistogramID::FX_SANITIZE_SITESETTINGS);
    }
    case 1046: { // browser.sanitizer.total
      return Some(HistogramID::FX_SANITIZE_TOTAL);
    }
    case 1067: { // link_icon_sizes_attr.dimension
      return Some(HistogramID::LINK_ICON_SIZES_ATTR_DIMENSION);
    }
    case 1068: { // link_icon_sizes_attr.usage
      return Some(HistogramID::LINK_ICON_SIZES_ATTR_USAGE);
    }
    case 1074: { // performance.interaction.tab_switch_composite
      return Some(HistogramID::FX_TAB_SWITCH_COMPOSITE_E10S_MS);
    }
    case 1075: { // performance.interaction.keypress_present_latency
      return Some(HistogramID::KEYPRESS_PRESENT_LATENCY);
    }
    case 1076: { // performance.interaction.mouseup_click_present_latency
      return Some(HistogramID::MOUSEUP_FOLLOWED_BY_CLICK_PRESENT_LATENCY);
    }
    case 1088: { // devtools.cold_toolbox_open_delay
      return Some(HistogramID::DEVTOOLS_COLD_TOOLBOX_OPEN_DELAY_MS);
    }
    case 1090: { // devtools.toolbox_host
      return Some(HistogramID::DEVTOOLS_TOOLBOX_HOST);
    }
    case 1091: { // devtools.toolbox_page_reload_delay
      return Some(HistogramID::DEVTOOLS_TOOLBOX_PAGE_RELOAD_DELAY_MS);
    }
    case 1092: { // devtools.warm_toolbox_open_delay
      return Some(HistogramID::DEVTOOLS_WARM_TOOLBOX_OPEN_DELAY_MS);
    }
    case 1093: { // devtools.aboutdebugging_opened_count
      return Some(HistogramID::DEVTOOLS_ABOUTDEBUGGING_OPENED_COUNT);
    }
    case 1094: { // devtools.aboutdebugging_time_active
      return Some(HistogramID::DEVTOOLS_ABOUTDEBUGGING_TIME_ACTIVE_SECONDS);
    }
    case 1095: { // devtools.accessibility_picker_time_active
      return Some(HistogramID::DEVTOOLS_ACCESSIBILITY_PICKER_TIME_ACTIVE_SECONDS);
    }
    case 1096: { // devtools.accessibility_service_time_active
      return Some(HistogramID::DEVTOOLS_ACCESSIBILITY_SERVICE_TIME_ACTIVE_SECONDS);
    }
    case 1097: { // devtools.accessibility_time_active
      return Some(HistogramID::DEVTOOLS_ACCESSIBILITY_TIME_ACTIVE_SECONDS);
    }
    case 1098: { // devtools.animationinspector_opened_count
      return Some(HistogramID::DEVTOOLS_ANIMATIONINSPECTOR_OPENED_COUNT);
    }
    case 1099: { // devtools.animationinspector_time_active
      return Some(HistogramID::DEVTOOLS_ANIMATIONINSPECTOR_TIME_ACTIVE_SECONDS);
    }
    case 1100: { // devtools.browserconsole_opened_count
      return Some(HistogramID::DEVTOOLS_BROWSERCONSOLE_OPENED_COUNT);
    }
    case 1101: { // devtools.browserconsole_time_active
      return Some(HistogramID::DEVTOOLS_BROWSERCONSOLE_TIME_ACTIVE_SECONDS);
    }
    case 1102: { // devtools.changesview_time_active
      return Some(HistogramID::DEVTOOLS_CHANGESVIEW_TIME_ACTIVE_SECONDS);
    }
    case 1103: { // devtools.compatibilityview_opened_count
      return Some(HistogramID::DEVTOOLS_COMPATIBILITYVIEW_OPENED_COUNT);
    }
    case 1104: { // devtools.compatibilityview_time_active
      return Some(HistogramID::DEVTOOLS_COMPATIBILITYVIEW_TIME_ACTIVE_SECONDS);
    }
    case 1105: { // devtools.computedview_opened_count
      return Some(HistogramID::DEVTOOLS_COMPUTEDVIEW_OPENED_COUNT);
    }
    case 1106: { // devtools.computedview_time_active
      return Some(HistogramID::DEVTOOLS_COMPUTEDVIEW_TIME_ACTIVE_SECONDS);
    }
    case 1107: { // devtools.custom_opened_count
      return Some(HistogramID::DEVTOOLS_CUSTOM_OPENED_COUNT);
    }
    case 1108: { // devtools.custom_time_active
      return Some(HistogramID::DEVTOOLS_CUSTOM_TIME_ACTIVE_SECONDS);
    }
    case 1109: { // devtools.dom_opened_count
      return Some(HistogramID::DEVTOOLS_DOM_OPENED_COUNT);
    }
    case 1110: { // devtools.dom_time_active
      return Some(HistogramID::DEVTOOLS_DOM_TIME_ACTIVE_SECONDS);
    }
    case 1111: { // devtools.entry_point
      return Some(HistogramID::DEVTOOLS_ENTRY_POINT);
    }
    case 1112: { // devtools.eyedropper_opened_count
      return Some(HistogramID::DEVTOOLS_EYEDROPPER_OPENED_COUNT);
    }
    case 1113: { // devtools.flexbox_highlighter_time_active
      return Some(HistogramID::DEVTOOLS_FLEXBOX_HIGHLIGHTER_TIME_ACTIVE_SECONDS);
    }
    case 1114: { // devtools.fontinspector_opened_count
      return Some(HistogramID::DEVTOOLS_FONTINSPECTOR_OPENED_COUNT);
    }
    case 1115: { // devtools.fontinspector_time_active
      return Some(HistogramID::DEVTOOLS_FONTINSPECTOR_TIME_ACTIVE_SECONDS);
    }
    case 1116: { // devtools.grid_highlighter_time_active
      return Some(HistogramID::DEVTOOLS_GRID_HIGHLIGHTER_TIME_ACTIVE_SECONDS);
    }
    case 1117: { // devtools.inspector_opened_count
      return Some(HistogramID::DEVTOOLS_INSPECTOR_OPENED_COUNT);
    }
    case 1118: { // devtools.inspector_time_active
      return Some(HistogramID::DEVTOOLS_INSPECTOR_TIME_ACTIVE_SECONDS);
    }
    case 1119: { // devtools.jsbrowserdebugger_opened_count
      return Some(HistogramID::DEVTOOLS_JSBROWSERDEBUGGER_OPENED_COUNT);
    }
    case 1120: { // devtools.jsbrowserdebugger_time_active
      return Some(HistogramID::DEVTOOLS_JSBROWSERDEBUGGER_TIME_ACTIVE_SECONDS);
    }
    case 1121: { // devtools.jsdebugger_opened_count
      return Some(HistogramID::DEVTOOLS_JSDEBUGGER_OPENED_COUNT);
    }
    case 1122: { // devtools.jsdebugger_time_active
      return Some(HistogramID::DEVTOOLS_JSDEBUGGER_TIME_ACTIVE_SECONDS);
    }
    case 1123: { // devtools.jsprofiler_opened_count
      return Some(HistogramID::DEVTOOLS_JSPROFILER_OPENED_COUNT);
    }
    case 1124: { // devtools.jsprofiler_time_active
      return Some(HistogramID::DEVTOOLS_JSPROFILER_TIME_ACTIVE_SECONDS);
    }
    case 1125: { // devtools.layoutview_opened_count
      return Some(HistogramID::DEVTOOLS_LAYOUTVIEW_OPENED_COUNT);
    }
    case 1126: { // devtools.layoutview_time_active
      return Some(HistogramID::DEVTOOLS_LAYOUTVIEW_TIME_ACTIVE_SECONDS);
    }
    case 1127: { // devtools.memory_opened_count
      return Some(HistogramID::DEVTOOLS_MEMORY_OPENED_COUNT);
    }
    case 1128: { // devtools.memory_time_active
      return Some(HistogramID::DEVTOOLS_MEMORY_TIME_ACTIVE_SECONDS);
    }
    case 1129: { // devtools.menu_eyedropper_opened_count
      return Some(HistogramID::DEVTOOLS_MENU_EYEDROPPER_OPENED_COUNT);
    }
    case 1130: { // devtools.netmonitor_opened_count
      return Some(HistogramID::DEVTOOLS_NETMONITOR_OPENED_COUNT);
    }
    case 1131: { // devtools.netmonitor_time_active
      return Some(HistogramID::DEVTOOLS_NETMONITOR_TIME_ACTIVE_SECONDS);
    }
    case 1132: { // devtools.options_opened_count
      return Some(HistogramID::DEVTOOLS_OPTIONS_OPENED_COUNT);
    }
    case 1133: { // devtools.options_time_active
      return Some(HistogramID::DEVTOOLS_OPTIONS_TIME_ACTIVE_SECONDS);
    }
    case 1134: { // devtools.picker_eyedropper_opened_count
      return Some(HistogramID::DEVTOOLS_PICKER_EYEDROPPER_OPENED_COUNT);
    }
    case 1135: { // devtools.responsive_opened_count
      return Some(HistogramID::DEVTOOLS_RESPONSIVE_OPENED_COUNT);
    }
    case 1136: { // devtools.responsive_time_active
      return Some(HistogramID::DEVTOOLS_RESPONSIVE_TIME_ACTIVE_SECONDS);
    }
    case 1137: { // devtools.ruleview_opened_count
      return Some(HistogramID::DEVTOOLS_RULEVIEW_OPENED_COUNT);
    }
    case 1138: { // devtools.ruleview_time_active
      return Some(HistogramID::DEVTOOLS_RULEVIEW_TIME_ACTIVE_SECONDS);
    }
    case 1139: { // devtools.storage_opened_count
      return Some(HistogramID::DEVTOOLS_STORAGE_OPENED_COUNT);
    }
    case 1140: { // devtools.storage_time_active
      return Some(HistogramID::DEVTOOLS_STORAGE_TIME_ACTIVE_SECONDS);
    }
    case 1141: { // devtools.styleeditor_opened_count
      return Some(HistogramID::DEVTOOLS_STYLEEDITOR_OPENED_COUNT);
    }
    case 1142: { // devtools.styleeditor_time_active
      return Some(HistogramID::DEVTOOLS_STYLEEDITOR_TIME_ACTIVE_SECONDS);
    }
    case 1143: { // devtools.toolbox_opened_count
      return Some(HistogramID::DEVTOOLS_TOOLBOX_OPENED_COUNT);
    }
    case 1144: { // devtools.toolbox_time_active
      return Some(HistogramID::DEVTOOLS_TOOLBOX_TIME_ACTIVE_SECONDS);
    }
    case 1145: { // devtools.webconsole_opened_count
      return Some(HistogramID::DEVTOOLS_WEBCONSOLE_OPENED_COUNT);
    }
    case 1146: { // devtools.webconsole_time_active
      return Some(HistogramID::DEVTOOLS_WEBCONSOLE_TIME_ACTIVE_SECONDS);
    }
    case 1147: { // devtools.heap_snapshot_edge_count
      return Some(HistogramID::DEVTOOLS_HEAP_SNAPSHOT_EDGE_COUNT);
    }
    case 1148: { // devtools.heap_snapshot_node_count
      return Some(HistogramID::DEVTOOLS_HEAP_SNAPSHOT_NODE_COUNT);
    }
    case 1149: { // devtools.read_heap_snapshot
      return Some(HistogramID::DEVTOOLS_READ_HEAP_SNAPSHOT_MS);
    }
    case 1150: { // devtools.save_heap_snapshot
      return Some(HistogramID::DEVTOOLS_SAVE_HEAP_SNAPSHOT_MS);
    }
    case 1154: { // devtools.inspector.fonteditor_font_type_displayed
      return Some(HistogramID::DEVTOOLS_FONTEDITOR_FONT_TYPE_DISPLAYED);
    }
    case 1155: { // devtools.inspector.new_root_to_reload_delay
      return Some(HistogramID::DEVTOOLS_INSPECTOR_NEW_ROOT_TO_RELOAD_DELAY_MS);
    }
    case 1157: { // devtools.inspector.number_of_css_grids_in_a_page
      return Some(HistogramID::DEVTOOLS_NUMBER_OF_CSS_GRIDS_IN_A_PAGE);
    }
    case 1265: { // bfcache.combo
      return Some(HistogramID::BFCACHE_COMBO);
    }
    case 1266: { // bfcache.page_restored
      return Some(HistogramID::BFCACHE_PAGE_RESTORED);
    }
    case 1267: { // page.load_error
      return Some(HistogramID::PAGE_LOAD_ERROR);
    }
    case 1268: { // performance.page.total_content_page_load
      return Some(HistogramID::TOTAL_CONTENT_PAGE_LOAD_TIME);
    }
    case 1269: { // performance.page.non_blank_paint
      return Some(HistogramID::TIME_TO_NON_BLANK_PAINT_MS);
    }
    case 3705: { // canvas.used_2d
      return Some(HistogramID::CANVAS_2D_USED);
    }
    case 3706: { // canvas.webgl2_success
      return Some(HistogramID::CANVAS_WEBGL2_SUCCESS);
    }
    case 3707: { // canvas.webgl_accl_failure_id
      return Some(HistogramID::CANVAS_WEBGL_ACCL_FAILURE_ID);
    }
    case 3708: { // canvas.webgl_failure_id
      return Some(HistogramID::CANVAS_WEBGL_FAILURE_ID);
    }
    case 3709: { // canvas.webgl_success
      return Some(HistogramID::CANVAS_WEBGL_SUCCESS);
    }
    case 3710: { // canvas.webgl_used
      return Some(HistogramID::CANVAS_WEBGL_USED);
    }
    case 3711: { // webcrypto.alg
      return Some(HistogramID::WEBCRYPTO_ALG);
    }
    case 3712: { // webcrypto.extractable_enc
      return Some(HistogramID::WEBCRYPTO_EXTRACTABLE_ENC);
    }
    case 3713: { // webcrypto.extractable_generate
      return Some(HistogramID::WEBCRYPTO_EXTRACTABLE_GENERATE);
    }
    case 3714: { // webcrypto.extractable_import
      return Some(HistogramID::WEBCRYPTO_EXTRACTABLE_IMPORT);
    }
    case 3715: { // webcrypto.extractable_sig
      return Some(HistogramID::WEBCRYPTO_EXTRACTABLE_SIG);
    }
    case 3716: { // webcrypto.method
      return Some(HistogramID::WEBCRYPTO_METHOD);
    }
    case 3717: { // webcrypto.resolved
      return Some(HistogramID::WEBCRYPTO_RESOLVED);
    }
    case 3742: { // media.audible_play_time_percent
      return Some(HistogramID::AUDIBLE_PLAY_TIME_PERCENT);
    }
    case 3743: { // media.codec_used
      return Some(HistogramID::MEDIA_CODEC_USED);
    }
    case 3746: { // media.media_play_time
      return Some(HistogramID::MEDIA_PLAY_TIME_MS);
    }
    case 3749: { // media.mse_source_buffer_type
      return Some(HistogramID::MSE_SOURCE_BUFFER_TYPE);
    }
    case 3750: { // media.muted_play_time_percent
      return Some(HistogramID::MUTED_PLAY_TIME_PERCENT);
    }
    case 3751: { // media.video_clearkey_play_time
      return Some(HistogramID::VIDEO_CLEARKEY_PLAY_TIME_MS);
    }
    case 3752: { // media.video_dropped_compositor_frames_proportion_exponential
      return Some(HistogramID::VIDEO_DROPPED_COMPOSITOR_FRAMES_PROPORTION_EXPONENTIAL);
    }
    case 3753: { // media.video_dropped_decoded_frames_proportion_exponential
      return Some(HistogramID::VIDEO_DROPPED_DECODED_FRAMES_PROPORTION_EXPONENTIAL);
    }
    case 3754: { // media.video_dropped_frames_proportion
      return Some(HistogramID::VIDEO_DROPPED_FRAMES_PROPORTION);
    }
    case 3755: { // media.video_dropped_frames_proportion_exponential
      return Some(HistogramID::VIDEO_DROPPED_FRAMES_PROPORTION_EXPONENTIAL);
    }
    case 3756: { // media.video_dropped_sink_frames_proportion_exponential
      return Some(HistogramID::VIDEO_DROPPED_SINK_FRAMES_PROPORTION_EXPONENTIAL);
    }
    case 3757: { // media.video_encrypted_play_time
      return Some(HistogramID::VIDEO_ENCRYPTED_PLAY_TIME_MS);
    }
    case 3760: { // media.video_hdr_play_time
      return Some(HistogramID::VIDEO_HDR_PLAY_TIME_MS);
    }
    case 3761: { // media.video_hidden_play_time
      return Some(HistogramID::VIDEO_HIDDEN_PLAY_TIME_MS);
    }
    case 3762: { // media.video_hidden_play_time_percentage
      return Some(HistogramID::VIDEO_HIDDEN_PLAY_TIME_PERCENTAGE);
    }
    case 3763: { // media.video_play_time
      return Some(HistogramID::VIDEO_PLAY_TIME_MS);
    }
    case 3764: { // media.video_visible_play_time
      return Some(HistogramID::VIDEO_VISIBLE_PLAY_TIME_MS);
    }
    case 3765: { // media.video_widevine_play_time
      return Some(HistogramID::VIDEO_WIDEVINE_PLAY_TIME_MS);
    }
    case 3766: { // media.decoder_backend_used
      return Some(HistogramID::MEDIA_DECODER_BACKEND_USED);
    }
    case 3774: { // media.mp4_parse.num_sample_description_entries
      return Some(HistogramID::MEDIA_MP4_PARSE_NUM_SAMPLE_DESCRIPTION_ENTRIES);
    }
    case 3775: { // media.mp4_parse.sample_description_entries_have_multiple_codecs
      return Some(HistogramID::MEDIA_MP4_PARSE_SAMPLE_DESCRIPTION_ENTRIES_HAVE_MULTIPLE_CODECS);
    }
    case 3776: { // media.mp4_parse.sample_description_entries_have_multiple_crypto
      return Some(HistogramID::MEDIA_MP4_PARSE_SAMPLE_DESCRIPTION_ENTRIES_HAVE_MULTIPLE_CRYPTO);
    }
    case 3796: { // webrtc.audio_quality_inbound_bandwidth_kbits
      return Some(HistogramID::WEBRTC_AUDIO_QUALITY_INBOUND_BANDWIDTH_KBITS);
    }
    case 3797: { // webrtc.audio_quality_inbound_jitter
      return Some(HistogramID::WEBRTC_AUDIO_QUALITY_INBOUND_JITTER);
    }
    case 3798: { // webrtc.audio_quality_inbound_packetloss_rate
      return Some(HistogramID::WEBRTC_AUDIO_QUALITY_INBOUND_PACKETLOSS_RATE);
    }
    case 3799: { // webrtc.audio_quality_outbound_jitter
      return Some(HistogramID::WEBRTC_AUDIO_QUALITY_OUTBOUND_JITTER);
    }
    case 3800: { // webrtc.audio_quality_outbound_packetloss_rate
      return Some(HistogramID::WEBRTC_AUDIO_QUALITY_OUTBOUND_PACKETLOSS_RATE);
    }
    case 3801: { // webrtc.audio_quality_outbound_rtt
      return Some(HistogramID::WEBRTC_AUDIO_QUALITY_OUTBOUND_RTT);
    }
    case 3802: { // webrtc.av_call_duration
      return Some(HistogramID::WEBRTC_AV_CALL_DURATION);
    }
    case 3803: { // webrtc.call_count_3
      return Some(HistogramID::WEBRTC_CALL_COUNT_3);
    }
    case 3804: { // webrtc.call_duration
      return Some(HistogramID::WEBRTC_CALL_DURATION);
    }
    case 3805: { // webrtc.call_type
      return Some(HistogramID::WEBRTC_CALL_TYPE);
    }
    case 3806: { // webrtc.datachannel_negotiated
      return Some(HistogramID::WEBRTC_DATACHANNEL_NEGOTIATED);
    }
    case 3807: { // webrtc.get_user_media_type
      return Some(HistogramID::WEBRTC_GET_USER_MEDIA_TYPE);
    }
    case 3808: { // webrtc.gmp_init_success
      return Some(HistogramID::WEBRTC_GMP_INIT_SUCCESS);
    }
    case 3809: { // webrtc.h264_enabled
      return Some(HistogramID::WEBRTC_H264_ENABLED);
    }
    case 3810: { // webrtc.hardware_h264_enabled
      return Some(HistogramID::WEBRTC_HARDWARE_H264_ENABLED);
    }
    case 3811: { // webrtc.has_h264_hardware
      return Some(HistogramID::WEBRTC_HAS_H264_HARDWARE);
    }
    case 3812: { // webrtc.max_audio_receive_track
      return Some(HistogramID::WEBRTC_MAX_AUDIO_RECEIVE_TRACK);
    }
    case 3813: { // webrtc.max_audio_send_track
      return Some(HistogramID::WEBRTC_MAX_AUDIO_SEND_TRACK);
    }
    case 3814: { // webrtc.max_video_receive_track
      return Some(HistogramID::WEBRTC_MAX_VIDEO_RECEIVE_TRACK);
    }
    case 3815: { // webrtc.max_video_send_track
      return Some(HistogramID::WEBRTC_MAX_VIDEO_SEND_TRACK);
    }
    case 3816: { // webrtc.renegotiations
      return Some(HistogramID::WEBRTC_RENEGOTIATIONS);
    }
    case 3817: { // webrtc.software_h264_enabled
      return Some(HistogramID::WEBRTC_SOFTWARE_H264_ENABLED);
    }
    case 3818: { // webrtc.video_decoder_bitrate_avg_per_call_kbps
      return Some(HistogramID::WEBRTC_VIDEO_DECODER_BITRATE_AVG_PER_CALL_KBPS);
    }
    case 3819: { // webrtc.video_decoder_bitrate_std_dev_per_call_kbps
      return Some(HistogramID::WEBRTC_VIDEO_DECODER_BITRATE_STD_DEV_PER_CALL_KBPS);
    }
    case 3820: { // webrtc.video_decoder_discarded_packets_per_call_ppm
      return Some(HistogramID::WEBRTC_VIDEO_DECODER_DISCARDED_PACKETS_PER_CALL_PPM);
    }
    case 3821: { // webrtc.video_decoder_framerate_10x_std_dev_per_call
      return Some(HistogramID::WEBRTC_VIDEO_DECODER_FRAMERATE_10X_STD_DEV_PER_CALL);
    }
    case 3822: { // webrtc.video_decoder_framerate_avg_per_call
      return Some(HistogramID::WEBRTC_VIDEO_DECODER_FRAMERATE_AVG_PER_CALL);
    }
    case 3823: { // webrtc.video_encoder_bitrate_avg_per_call_kbps
      return Some(HistogramID::WEBRTC_VIDEO_ENCODER_BITRATE_AVG_PER_CALL_KBPS);
    }
    case 3824: { // webrtc.video_encoder_bitrate_std_dev_per_call_kbps
      return Some(HistogramID::WEBRTC_VIDEO_ENCODER_BITRATE_STD_DEV_PER_CALL_KBPS);
    }
    case 3825: { // webrtc.video_encoder_framerate_10x_std_dev_per_call
      return Some(HistogramID::WEBRTC_VIDEO_ENCODER_FRAMERATE_10X_STD_DEV_PER_CALL);
    }
    case 3826: { // webrtc.video_encoder_framerate_avg_per_call
      return Some(HistogramID::WEBRTC_VIDEO_ENCODER_FRAMERATE_AVG_PER_CALL);
    }
    case 3827: { // webrtc.video_quality_inbound_bandwidth_kbits
      return Some(HistogramID::WEBRTC_VIDEO_QUALITY_INBOUND_BANDWIDTH_KBITS);
    }
    case 3828: { // webrtc.video_quality_inbound_jitter
      return Some(HistogramID::WEBRTC_VIDEO_QUALITY_INBOUND_JITTER);
    }
    case 3829: { // webrtc.video_quality_inbound_packetloss_rate
      return Some(HistogramID::WEBRTC_VIDEO_QUALITY_INBOUND_PACKETLOSS_RATE);
    }
    case 3830: { // webrtc.video_quality_outbound_jitter
      return Some(HistogramID::WEBRTC_VIDEO_QUALITY_OUTBOUND_JITTER);
    }
    case 3831: { // webrtc.video_quality_outbound_packetloss_rate
      return Some(HistogramID::WEBRTC_VIDEO_QUALITY_OUTBOUND_PACKETLOSS_RATE);
    }
    case 3832: { // webrtc.video_quality_outbound_rtt
      return Some(HistogramID::WEBRTC_VIDEO_QUALITY_OUTBOUND_RTT);
    }
    case 3846: { // dom.blink_filesystem_used
      return Some(HistogramID::BLINK_FILESYSTEM_USED);
    }
    case 3847: { // dom.forget_skippable_during_idle
      return Some(HistogramID::FORGET_SKIPPABLE_DURING_IDLE);
    }
    case 3848: { // dom.forget_skippable_frequency
      return Some(HistogramID::FORGET_SKIPPABLE_FREQUENCY);
    }
    case 3849: { // dom.fullscreen_transition_black
      return Some(HistogramID::FULLSCREEN_TRANSITION_BLACK_MS);
    }
    case 3850: { // dom.gc_in_progress
      return Some(HistogramID::GC_IN_PROGRESS_MS);
    }
    case 3851: { // dom.gc_slice_during_idle
      return Some(HistogramID::GC_SLICE_DURING_IDLE);
    }
    case 3852: { // dom.script_loading_source
      return Some(HistogramID::DOM_SCRIPT_LOADING_SOURCE);
    }
    case 3853: { // dom.slow_script_notice_count
      return Some(HistogramID::SLOW_SCRIPT_NOTICE_COUNT);
    }
    case 3854: { // dom.slow_script_page_count
      return Some(HistogramID::SLOW_SCRIPT_PAGE_COUNT);
    }
    case 3855: { // dom.storage_access_api_ui
      return Some(HistogramID::STORAGE_ACCESS_API_UI);
    }
    case 3856: { // dom.webkit_directory_used
      return Some(HistogramID::WEBKIT_DIRECTORY_USED);
    }
    case 3857: { // dom.xmlhttprequest_async_or_sync
      return Some(HistogramID::XMLHTTPREQUEST_ASYNC_OR_SYNC);
    }
    case 3860: { // dom.contentprocess.launch_is_sync
      return Some(HistogramID::CONTENT_PROCESS_LAUNCH_IS_SYNC);
    }
    case 3861: { // dom.contentprocess.launch_mainthread
      return Some(HistogramID::CONTENT_PROCESS_LAUNCH_MAINTHREAD_MS);
    }
    case 3862: { // dom.contentprocess.launch_total
      return Some(HistogramID::CONTENT_PROCESS_LAUNCH_TOTAL_MS);
    }
    case 3866: { // dom.contentprocess.sync_launch
      return Some(HistogramID::CONTENT_PROCESS_SYNC_LAUNCH_MS);
    }
    case 3873: { // perf.dns_first_byte
      return Some(HistogramID::DNS_PERF_FIRST_BYTE_MS);
    }
    case 3874: { // perf.dns_first_contentful_paint
      return Some(HistogramID::DNS_PERF_FIRST_CONTENTFUL_PAINT_MS);
    }
    case 3875: { // perf.h3p_first_contentful_paint
      return Some(HistogramID::H3P_PERF_FIRST_CONTENTFUL_PAINT_MS);
    }
    case 3876: { // perf.h3p_page_load_time
      return Some(HistogramID::H3P_PERF_PAGE_LOAD_TIME_MS);
    }
    case 3877: { // perf.http3_first_contentful_paint
      return Some(HistogramID::HTTP3_PERF_FIRST_CONTENTFUL_PAINT_MS);
    }
    case 3878: { // perf.http3_page_load_time
      return Some(HistogramID::HTTP3_PERF_PAGE_LOAD_TIME_MS);
    }
    case 3880: { // perf.largest_contentful_paint
      return Some(HistogramID::PERF_LARGEST_CONTENTFUL_PAINT_MS);
    }
    case 3881: { // perf.largest_contentful_paint_from_response_start
      return Some(HistogramID::PERF_LARGEST_CONTENTFUL_PAINT_FROM_RESPONSE_START_MS);
    }
    case 3884: { // performance.pageload.fcp
      return Some(HistogramID::PERF_FIRST_CONTENTFUL_PAINT_MS);
    }
    case 3885: { // performance.pageload.fcp_responsestart
      return Some(HistogramID::PERF_FIRST_CONTENTFUL_PAINT_FROM_RESPONSESTART_MS);
    }
    case 3890: { // performance.pageload.load_time
      return Some(HistogramID::PERF_PAGE_LOAD_TIME_MS);
    }
    case 3891: { // performance.pageload.load_time_responsestart
      return Some(HistogramID::PERF_PAGE_LOAD_TIME_FROM_RESPONSESTART_MS);
    }
    case 3892: { // performance.time.dom_complete
      return Some(HistogramID::TIME_TO_DOM_COMPLETE_MS);
    }
    case 3893: { // performance.time.dom_content_loaded_end
      return Some(HistogramID::TIME_TO_DOM_CONTENT_LOADED_END_MS);
    }
    case 3894: { // performance.time.dom_content_loaded_start
      return Some(HistogramID::TIME_TO_DOM_CONTENT_LOADED_START_MS);
    }
    case 3895: { // performance.time.dom_interactive
      return Some(HistogramID::TIME_TO_DOM_INTERACTIVE_MS);
    }
    case 3896: { // performance.time.load_event_end
      return Some(HistogramID::TIME_TO_LOAD_EVENT_END_MS);
    }
    case 3897: { // performance.time.load_event_start
      return Some(HistogramID::TIME_TO_LOAD_EVENT_START_MS);
    }
    case 3898: { // performance.time.to_dom_loading
      return Some(HistogramID::TIME_TO_DOM_LOADING_MS);
    }
    case 3899: { // performance.time.to_first_contentful_paint
      return Some(HistogramID::TIME_TO_FIRST_CONTENTFUL_PAINT_MS);
    }
    case 3900: { // performance.time.response_start
      return Some(HistogramID::TIME_TO_RESPONSE_START_MS);
    }
    case 3905: { // screenwakelock.held_duration
      return Some(HistogramID::SCREENWAKELOCK_HELD_DURATION_MS);
    }
    case 3906: { // screenwakelock.release_battery_level_discharging
      return Some(HistogramID::SCREENWAKELOCK_RELEASE_BATTERY_LEVEL_DISCHARGING);
    }
    case 3907: { // web_push.api_notify
      return Some(HistogramID::PUSH_API_NOTIFY);
    }
    case 3914: { // dom.quota.first_initialization_attempt
      return Some(HistogramID::QM_FIRST_INITIALIZATION_ATTEMPT);
    }
    case 3915: { // dom.quota.info_load_time
      return Some(HistogramID::QM_QUOTA_INFO_LOAD_TIME_V0);
    }
    case 3916: { // dom.quota.shutdown_time
      return Some(HistogramID::QM_SHUTDOWN_TIME_V0);
    }
    case 3931: { // mixed_content.audio
      return Some(HistogramID::MIXED_CONTENT_AUDIO);
    }
    case 3932: { // mixed_content.hsts
      return Some(HistogramID::MIXED_CONTENT_HSTS);
    }
    case 3933: { // mixed_content.images
      return Some(HistogramID::MIXED_CONTENT_IMAGES);
    }
    case 3934: { // mixed_content.page_load
      return Some(HistogramID::MIXED_CONTENT_PAGE_LOAD);
    }
    case 3935: { // mixed_content.unblock_counter
      return Some(HistogramID::MIXED_CONTENT_UNBLOCK_COUNTER);
    }
    case 3936: { // mixed_content.video
      return Some(HistogramID::MIXED_CONTENT_VIDEO);
    }
    case 3937: { // security.ui.events
      return Some(HistogramID::SECURITY_UI);
    }
    case 3947: { // service_worker.fetch_event_channel_reset
      return Some(HistogramID::SERVICE_WORKER_FETCH_EVENT_CHANNEL_RESET_MS_2);
    }
    case 3948: { // service_worker.fetch_event_dispatch
      return Some(HistogramID::SERVICE_WORKER_FETCH_EVENT_DISPATCH_MS_2);
    }
    case 3949: { // service_worker.fetch_event_finish_synthesized_response
      return Some(HistogramID::SERVICE_WORKER_FETCH_EVENT_FINISH_SYNTHESIZED_RESPONSE_MS_2);
    }
    case 3950: { // service_worker.fetch_interception_duration
      return Some(HistogramID::SERVICE_WORKER_FETCH_INTERCEPTION_DURATION_MS_2);
    }
    case 3951: { // service_worker.isolated_launch_time
      return Some(HistogramID::SERVICE_WORKER_ISOLATED_LAUNCH_TIME);
    }
    case 3952: { // service_worker.launch_time
      return Some(HistogramID::SERVICE_WORKER_LAUNCH_TIME_2);
    }
    case 3953: { // service_worker.registration_loading
      return Some(HistogramID::SERVICE_WORKER_REGISTRATION_LOADING);
    }
    case 3954: { // service_worker.running
      return Some(HistogramID::SERVICE_WORKER_RUNNING);
    }
    case 3955: { // localdomstorage.preload_pending_on_first_access
      return Some(HistogramID::LOCALDOMSTORAGE_PRELOAD_PENDING_ON_FIRST_ACCESS);
    }
    case 3956: { // localdomstorage.shutdown_database
      return Some(HistogramID::LOCALDOMSTORAGE_SHUTDOWN_DATABASE_MS);
    }
    case 3964: { // workers.dedicated_worker_spawn_gets_queued
      return Some(HistogramID::DEDICATED_WORKER_SPAWN_GETS_QUEUED);
    }
    case 3965: { // workers.service_worker_spawn_gets_queued
      return Some(HistogramID::SERVICE_WORKER_SPAWN_GETS_QUEUED);
    }
    case 3966: { // workers.shared_worker_spawn_gets_queued
      return Some(HistogramID::SHARED_WORKER_SPAWN_GETS_QUEUED);
    }
    case 3967: { // workers.sync_worker_operation
      return Some(HistogramID::SYNC_WORKER_OPERATION);
    }
    case 3968: { // htmleditors.overridden_by_beforeinput_listeners
      return Some(HistogramID::HTMLEDITORS_OVERRIDDEN_BY_BEFOREINPUT_LISTENERS);
    }
    case 3969: { // htmleditors.with_beforeinput_listeners
      return Some(HistogramID::HTMLEDITORS_WITH_BEFOREINPUT_LISTENERS);
    }
    case 3970: { // htmleditors.with_mutation_observers_without_beforeinput_listeners
      return Some(HistogramID::HTMLEDITORS_WITH_MUTATION_OBSERVERS_WITHOUT_BEFOREINPUT_LISTENERS);
    }
    case 3971: { // permissions.defective_sql_removed
      return Some(HistogramID::DEFECTIVE_PERMISSIONS_SQL_REMOVED);
    }
    case 3972: { // permissions.sql_corrupted
      return Some(HistogramID::PERMISSIONS_SQL_CORRUPTED);
    }
    case 3973: { // apz_zoom.activity
      return Some(HistogramID::APZ_ZOOM_ACTIVITY);
    }
    case 3974: { // apz_zoom.pinchsource
      return Some(HistogramID::APZ_ZOOM_PINCHSOURCE);
    }
    case 3975: { // fontlist.bad_fallback_font
      return Some(HistogramID::BAD_FALLBACK_FONT);
    }
    case 3976: { // fontlist.bundledfonts_activate
      return Some(HistogramID::FONTLIST_BUNDLEDFONTS_ACTIVATE);
    }
    case 3977: { // fontlist.dwritefont_delayedinit_collect
      return Some(HistogramID::DWRITEFONT_DELAYEDINITFONTLIST_COLLECT);
    }
    case 3978: { // fontlist.dwritefont_delayedinit_count
      return Some(HistogramID::DWRITEFONT_DELAYEDINITFONTLIST_COUNT);
    }
    case 3979: { // fontlist.dwritefont_delayedinit_total
      return Some(HistogramID::DWRITEFONT_DELAYEDINITFONTLIST_TOTAL);
    }
    case 3980: { // fontlist.dwritefont_init_problem
      return Some(HistogramID::DWRITEFONT_INIT_PROBLEM);
    }
    case 3981: { // fontlist.font_cache_hit
      return Some(HistogramID::FONT_CACHE_HIT);
    }
    case 3982: { // fontlist.initfacenamelists
      return Some(HistogramID::FONTLIST_INITFACENAMELISTS);
    }
    case 3983: { // fontlist.initotherfamilynames
      return Some(HistogramID::FONTLIST_INITOTHERFAMILYNAMES);
    }
    case 3984: { // fontlist.initotherfamilynames_no_deferring
      return Some(HistogramID::FONTLIST_INITOTHERFAMILYNAMES_NO_DEFERRING);
    }
    case 3985: { // fontlist.mac_init_total
      return Some(HistogramID::MAC_INITFONTLIST_TOTAL);
    }
    case 3986: { // fontlist.system_font_fallback
      return Some(HistogramID::SYSTEM_FONT_FALLBACK);
    }
    case 3987: { // fontlist.system_font_fallback_first
      return Some(HistogramID::SYSTEM_FONT_FALLBACK_FIRST);
    }
    case 3988: { // gfx.composite_frame_roundtrip_time
      return Some(HistogramID::COMPOSITE_FRAME_ROUNDTRIP_TIME);
    }
    case 3989: { // gfx.composite_swap_time
      return Some(HistogramID::COMPOSITE_SWAP_TIME);
    }
    case 3990: { // gfx.composite_time
      return Some(HistogramID::COMPOSITE_TIME);
    }
    case 3991: { // gfx.content_failed_to_acquire_device
      return Some(HistogramID::GFX_CONTENT_FAILED_TO_ACQUIRE_DEVICE);
    }
    case 3992: { // gfx.crash
      return Some(HistogramID::GFX_CRASH);
    }
    case 3993: { // gfx.device_reset_reason
      return Some(HistogramID::DEVICE_RESET_REASON);
    }
    case 3994: { // gfx.forced_device_reset_reason
      return Some(HistogramID::FORCED_DEVICE_RESET_REASON);
    }
    case 3995: { // gfx.graphics_driver_startup_test
      return Some(HistogramID::GRAPHICS_DRIVER_STARTUP_TEST);
    }
    case 3997: { // gfx.macos_video_low_power
      return Some(HistogramID::GFX_MACOS_VIDEO_LOW_POWER);
    }
    case 3999: { // gfx.sanity_test
      return Some(HistogramID::GRAPHICS_SANITY_TEST);
    }
    case 4000: { // gfx.scroll_present_latency
      return Some(HistogramID::SCROLL_PRESENT_LATENCY);
    }
    case 4019: { // gfx.checkerboard.duration
      return Some(HistogramID::CHECKERBOARD_DURATION);
    }
    case 4020: { // gfx.checkerboard.peak_pixel_count
      return Some(HistogramID::CHECKERBOARD_PEAK);
    }
    case 4021: { // gfx.checkerboard.potential_duration
      return Some(HistogramID::CHECKERBOARD_POTENTIAL_DURATION);
    }
    case 4022: { // gfx.checkerboard.severity
      return Some(HistogramID::CHECKERBOARD_SEVERITY);
    }
    case 4023: { // gfx.content.full_paint_time
      return Some(HistogramID::CONTENT_FULL_PAINT_TIME);
    }
    case 4024: { // gfx.content.large_paint_phase_weight_full
      return Some(HistogramID::CONTENT_LARGE_PAINT_PHASE_WEIGHT_FULL);
    }
    case 4025: { // gfx.content.large_paint_phase_weight_partial
      return Some(HistogramID::CONTENT_LARGE_PAINT_PHASE_WEIGHT_PARTIAL);
    }
    case 4026: { // gfx.content.paint_time
      return Some(HistogramID::CONTENT_PAINT_TIME);
    }
    case 4027: { // gfx.content.small_paint_phase_weight_full
      return Some(HistogramID::CONTENT_SMALL_PAINT_PHASE_WEIGHT_FULL);
    }
    case 4028: { // gfx.content.small_paint_phase_weight_partial
      return Some(HistogramID::CONTENT_SMALL_PAINT_PHASE_WEIGHT_PARTIAL);
    }
    case 4029: { // gfx.content.frame_time.from_paint
      return Some(HistogramID::CONTENT_FRAME_TIME);
    }
    case 4030: { // gfx.content.frame_time.from_vsync
      return Some(HistogramID::CONTENT_FRAME_TIME_VSYNC);
    }
    case 4032: { // gfx.content.frame_time.with_svg
      return Some(HistogramID::CONTENT_FRAME_TIME_WITH_SVG);
    }
    case 4033: { // gfx.content.frame_time.without_resource_upload
      return Some(HistogramID::CONTENT_FRAME_TIME_WITHOUT_RESOURCE_UPLOAD);
    }
    case 4034: { // gfx.content.frame_time.without_upload
      return Some(HistogramID::CONTENT_FRAME_TIME_WITHOUT_UPLOAD);
    }
    case 4038: { // gfx.display.scaling
      return Some(HistogramID::DISPLAY_SCALING);
    }
    case 4046: { // gpu_process.initialization_time
      return Some(HistogramID::GPU_PROCESS_INITIALIZATION_TIME_MS);
    }
    case 4047: { // gpu_process.launch_time
      return Some(HistogramID::GPU_PROCESS_LAUNCH_TIME_MS_2);
    }
    case 4051: { // webfont.compression_woff
      return Some(HistogramID::WEBFONT_COMPRESSION_WOFF);
    }
    case 4052: { // webfont.compression_woff2
      return Some(HistogramID::WEBFONT_COMPRESSION_WOFF2);
    }
    case 4053: { // webfont.download_time
      return Some(HistogramID::WEBFONT_DOWNLOAD_TIME);
    }
    case 4054: { // webfont.fonttype
      return Some(HistogramID::WEBFONT_FONTTYPE);
    }
    case 4055: { // webfont.per_page
      return Some(HistogramID::WEBFONT_PER_PAGE);
    }
    case 4056: { // webfont.size
      return Some(HistogramID::WEBFONT_SIZE);
    }
    case 4057: { // webfont.size_per_page
      return Some(HistogramID::WEBFONT_SIZE_PER_PAGE);
    }
    case 4058: { // webfont.srctype
      return Some(HistogramID::WEBFONT_SRCTYPE);
    }
    case 4093: { // image_decode.chunks
      return Some(HistogramID::IMAGE_DECODE_CHUNKS);
    }
    case 4094: { // image_decode.count
      return Some(HistogramID::IMAGE_DECODE_COUNT);
    }
    case 4095: { // image_decode.on_draw_latency
      return Some(HistogramID::IMAGE_DECODE_ON_DRAW_LATENCY);
    }
    case 4096: { // image_decode.speed_avif
      return Some(HistogramID::IMAGE_DECODE_SPEED_AVIF);
    }
    case 4097: { // image_decode.speed_gif
      return Some(HistogramID::IMAGE_DECODE_SPEED_GIF);
    }
    case 4098: { // image_decode.speed_jpeg
      return Some(HistogramID::IMAGE_DECODE_SPEED_JPEG);
    }
    case 4099: { // image_decode.speed_png
      return Some(HistogramID::IMAGE_DECODE_SPEED_PNG);
    }
    case 4100: { // image_decode.speed_webp
      return Some(HistogramID::IMAGE_DECODE_SPEED_WEBP);
    }
    case 4101: { // image_decode.time
      return Some(HistogramID::IMAGE_DECODE_TIME);
    }
    case 4108: { // ipc.transaction_cancel
      return Some(HistogramID::IPC_TRANSACTION_CANCEL);
    }
    case 4109: { // process.child_launch
      return Some(HistogramID::CHILD_PROCESS_LAUNCH_MS);
    }
    case 4110: { // subprocess.abnormal_abort
      return Some(HistogramID::SUBPROCESS_ABNORMAL_ABORT);
    }
    case 4111: { // subprocess.crashes_with_dump
      return Some(HistogramID::SUBPROCESS_CRASHES_WITH_DUMP);
    }
    case 4112: { // subprocess.kill_hard
      return Some(HistogramID::SUBPROCESS_KILL_HARD);
    }
    case 4113: { // subprocess.launch_failure
      return Some(HistogramID::SUBPROCESS_LAUNCH_FAILURE);
    }
    case 4160: { // script.preloader.requests
      return Some(HistogramID::SCRIPT_PRELOADER_REQUESTS);
    }
    case 4161: { // script.preloader.wait_time
      return Some(HistogramID::SCRIPT_PRELOADER_WAIT_TIME);
    }
    case 4162: { // slow_script_warning.notify_delay
      return Some(HistogramID::SLOW_SCRIPT_NOTIFY_DELAY);
    }
    case 4165: { // layout.input_event_queued_click
      return Some(HistogramID::INPUT_EVENT_QUEUED_CLICK_MS);
    }
    case 4166: { // layout.input_event_queued_keyboard
      return Some(HistogramID::INPUT_EVENT_QUEUED_KEYBOARD_MS);
    }
    case 4167: { // layout.input_event_response
      return Some(HistogramID::INPUT_EVENT_RESPONSE_MS);
    }
    case 4168: { // layout.input_event_response_coalesced
      return Some(HistogramID::INPUT_EVENT_RESPONSE_COALESCED_MS);
    }
    case 4169: { // layout.load_input_event_response
      return Some(HistogramID::LOAD_INPUT_EVENT_RESPONSE_MS);
    }
    case 4170: { // layout.long_reflow_interruptible
      return Some(HistogramID::LONG_REFLOW_INTERRUPTIBLE);
    }
    case 4171: { // layout.paint_rasterize_time
      return Some(HistogramID::PAINT_RASTERIZE_TIME);
    }
    case 4172: { // layout.refresh_driver_chrome_frame_delay
      return Some(HistogramID::FX_REFRESH_DRIVER_CHROME_FRAME_DELAY_MS);
    }
    case 4173: { // layout.refresh_driver_content_frame_delay
      return Some(HistogramID::FX_REFRESH_DRIVER_CONTENT_FRAME_DELAY_MS);
    }
    case 4174: { // layout.refresh_driver_tick
      return Some(HistogramID::REFRESH_DRIVER_TICK);
    }
    case 4175: { // layout.time_to_first_interaction
      return Some(HistogramID::TIME_TO_FIRST_INTERACTION_MS);
    }
    case 4176: { // geckoview.document_site_origins
      return Some(HistogramID::FX_NUMBER_OF_UNIQUE_SITE_ORIGINS_ALL_TABS);
    }
    case 4177: { // geckoview.page_load_progress_time
      return Some(HistogramID::GV_PAGE_LOAD_PROGRESS_MS);
    }
    case 4178: { // geckoview.page_load_time
      return Some(HistogramID::GV_PAGE_LOAD_MS);
    }
    case 4179: { // geckoview.page_reload_time
      return Some(HistogramID::GV_PAGE_RELOAD_MS);
    }
    case 4180: { // geckoview.per_document_site_origins
      return Some(HistogramID::FX_NUMBER_OF_UNIQUE_SITE_ORIGINS_PER_DOCUMENT);
    }
    case 4195: { // network.cache_entry_count
      return Some(HistogramID::NETWORK_CACHE_ENTRY_COUNT);
    }
    case 4196: { // network.cache_entry_count_share
      return Some(HistogramID::NETWORK_CACHE_ENTRY_COUNT_SHARE);
    }
    case 4197: { // network.cache_size
      return Some(HistogramID::NETWORK_CACHE_SIZE);
    }
    case 4198: { // network.cache_size_share
      return Some(HistogramID::NETWORK_CACHE_SIZE_SHARE);
    }
    case 4199: { // network.cache_v2_input_stream_status
      return Some(HistogramID::NETWORK_CACHE_V2_INPUT_STREAM_STATUS);
    }
    case 4200: { // network.cache_v2_output_stream_status
      return Some(HistogramID::NETWORK_CACHE_V2_OUTPUT_STREAM_STATUS);
    }
    case 4201: { // network.disk_cache2_shutdown_clear_private
      return Some(HistogramID::NETWORK_DISK_CACHE2_SHUTDOWN_CLEAR_PRIVATE);
    }
    case 4202: { // network.disk_cache_shutdown_v2
      return Some(HistogramID::NETWORK_DISK_CACHE_SHUTDOWN_V2);
    }
    case 4203: { // network.http_cache_entry_alive_time
      return Some(HistogramID::HTTP_CACHE_ENTRY_ALIVE_TIME);
    }
    case 4204: { // network.http_cache_entry_reload_time
      return Some(HistogramID::HTTP_CACHE_ENTRY_RELOAD_TIME);
    }
    case 4205: { // network.http_cache_entry_reuse_count
      return Some(HistogramID::HTTP_CACHE_ENTRY_REUSE_COUNT);
    }
    case 4206: { // network.backgroundfilesaver_thread_count
      return Some(HistogramID::BACKGROUNDFILESAVER_THREAD_COUNT);
    }
    case 4207: { // network.id
      return Some(HistogramID::NETWORK_ID2);
    }
    case 4208: { // network.id_online
      return Some(HistogramID::NETWORK_ID_ONLINE);
    }
    case 4209: { // network.ipv4_and_ipv6_address_connectivity
      return Some(HistogramID::IPV4_AND_IPV6_ADDRESS_CONNECTIVITY);
    }
    case 4210: { // network.rel_preload_miss_ratio
      return Some(HistogramID::REL_PRELOAD_MISS_RATIO);
    }
    case 4213: { // network.async_open_child_to_transaction_pending_exp
      return Some(HistogramID::NETWORK_ASYNC_OPEN_CHILD_TO_TRANSACTION_PENDING_EXP_MS);
    }
    case 4214: { // network.back_pressure_suspension_cp_type
      return Some(HistogramID::NETWORK_BACK_PRESSURE_SUSPENSION_CP_TYPE);
    }
    case 4215: { // network.back_pressure_suspension_delay_time
      return Some(HistogramID::NETWORK_BACK_PRESSURE_SUSPENSION_DELAY_TIME_MS);
    }
    case 4216: { // network.back_pressure_suspension_rate
      return Some(HistogramID::NETWORK_BACK_PRESSURE_SUSPENSION_RATE_V2);
    }
    case 4220: { // network.cache_hit_time
      return Some(HistogramID::NETWORK_CACHE_V2_HIT_TIME_MS);
    }
    case 4221: { // network.cache_miss_time
      return Some(HistogramID::NETWORK_CACHE_V2_MISS_TIME_MS);
    }
    case 4222: { // network.cache_read_time
      return Some(HistogramID::HTTP_PAGE_CACHE_READ_TIME_V2);
    }
    case 4223: { // network.complete_load
      return Some(HistogramID::HTTP_PAGE_COMPLETE_LOAD_V2);
    }
    case 4224: { // network.complete_load_cached
      return Some(HistogramID::HTTP_PAGE_COMPLETE_LOAD_CACHED_V2);
    }
    case 4225: { // network.complete_load_net
      return Some(HistogramID::HTTP_PAGE_COMPLETE_LOAD_NET_V2);
    }
    case 4227: { // network.dns_end
      return Some(HistogramID::HTTP_PAGE_DNS_LOOKUP_TIME);
    }
    case 4228: { // network.dns_end_to_connect_start_exp
      return Some(HistogramID::NETWORK_DNS_END_TO_CONNECT_START_EXP_MS);
    }
    case 4229: { // network.dns_start
      return Some(HistogramID::HTTP_PAGE_DNS_ISSUE_TIME);
    }
    case 4230: { // network.first_from_cache
      return Some(HistogramID::HTTP_PAGE_OPEN_TO_FIRST_FROM_CACHE_V2);
    }
    case 4231: { // network.first_sent_to_last_received
      return Some(HistogramID::HTTP_PAGE_FIRST_SENT_TO_LAST_RECEIVED);
    }
    case 4232: { // network.font_download_end
      return Some(HistogramID::WEBFONT_DOWNLOAD_TIME_AFTER_START);
    }
    case 4233: { // network.http3_complete_load
      return Some(HistogramID::HTTP3_COMPLETE_LOAD);
    }
    case 4234: { // network.http3_first_sent_to_last_received
      return Some(HistogramID::HTTP3_FIRST_SENT_TO_LAST_RECEIVED);
    }
    case 4235: { // network.http3_open_to_first_received
      return Some(HistogramID::HTTP3_OPEN_TO_FIRST_RECEIVED);
    }
    case 4236: { // network.http3_open_to_first_sent
      return Some(HistogramID::HTTP3_OPEN_TO_FIRST_SENT);
    }
    case 4237: { // network.http3_tls_handshake
      return Some(HistogramID::HTTP3_TLS_HANDSHAKE);
    }
    case 4239: { // network.http_revalidation
      return Some(HistogramID::HTTP_PAGE_REVALIDATION);
    }
    case 4240: { // network.open_to_first_received
      return Some(HistogramID::HTTP_PAGE_OPEN_TO_FIRST_RECEIVED);
    }
    case 4241: { // network.open_to_first_sent
      return Some(HistogramID::HTTP_PAGE_OPEN_TO_FIRST_SENT);
    }
    case 4243: { // network.race_cache_bandwidth_not_race
      return Some(HistogramID::NETWORK_RACE_CACHE_BANDWIDTH_NOT_RACE);
    }
    case 4244: { // network.race_cache_bandwidth_race_cache_win
      return Some(HistogramID::NETWORK_RACE_CACHE_BANDWIDTH_RACE_CACHE_WIN);
    }
    case 4245: { // network.race_cache_bandwidth_race_network_win
      return Some(HistogramID::NETWORK_RACE_CACHE_BANDWIDTH_RACE_NETWORK_WIN);
    }
    case 4246: { // network.race_cache_validation
      return Some(HistogramID::NETWORK_RACE_CACHE_VALIDATION);
    }
    case 4247: { // network.race_cache_with_network_ocec_on_start_diff
      return Some(HistogramID::NETWORK_RACE_CACHE_WITH_NETWORK_OCEC_ON_START_DIFF);
    }
    case 4248: { // network.race_cache_with_network_saved_time
      return Some(HistogramID::NETWORK_RACE_CACHE_WITH_NETWORK_SAVED_TIME);
    }
    case 4249: { // network.response_end_parent_to_content
      return Some(HistogramID::NETWORK_RESPONSE_END_PARENT_TO_CONTENT_MS);
    }
    case 4250: { // network.response_start_parent_to_content_exp
      return Some(HistogramID::NETWORK_RESPONSE_START_PARENT_TO_CONTENT_EXP_MS);
    }
    case 4257: { // network.sub_cache_read_time
      return Some(HistogramID::HTTP_SUB_CACHE_READ_TIME_V2);
    }
    case 4258: { // network.sub_complete_load
      return Some(HistogramID::HTTP_SUB_COMPLETE_LOAD_V2);
    }
    case 4259: { // network.sub_complete_load_cached
      return Some(HistogramID::HTTP_SUB_COMPLETE_LOAD_CACHED_V2);
    }
    case 4260: { // network.sub_complete_load_net
      return Some(HistogramID::HTTP_SUB_COMPLETE_LOAD_NET_V2);
    }
    case 4261: { // network.sub_dns_end
      return Some(HistogramID::HTTP_SUB_DNS_LOOKUP_TIME);
    }
    case 4262: { // network.sub_dns_start
      return Some(HistogramID::HTTP_SUB_DNS_ISSUE_TIME);
    }
    case 4263: { // network.sub_first_from_cache
      return Some(HistogramID::HTTP_SUB_OPEN_TO_FIRST_FROM_CACHE_V2);
    }
    case 4264: { // network.sub_first_sent_to_last_received
      return Some(HistogramID::HTTP_SUB_FIRST_SENT_TO_LAST_RECEIVED);
    }
    case 4265: { // network.sub_http_revalidation
      return Some(HistogramID::HTTP_SUB_REVALIDATION);
    }
    case 4266: { // network.sub_open_to_first_received
      return Some(HistogramID::HTTP_SUB_OPEN_TO_FIRST_RECEIVED);
    }
    case 4267: { // network.sub_open_to_first_sent
      return Some(HistogramID::HTTP_SUB_OPEN_TO_FIRST_SENT);
    }
    case 4268: { // network.sub_tcp_connection
      return Some(HistogramID::HTTP_SUB_TCP_CONNECTION_2);
    }
    case 4269: { // network.sub_tls_handshake
      return Some(HistogramID::HTTP_SUB_TLS_HANDSHAKE);
    }
    case 4270: { // network.sup_http3_tcp_connection
      return Some(HistogramID::SUP_HTTP3_TCP_CONNECTION);
    }
    case 4278: { // network.tcp_connection
      return Some(HistogramID::HTTP_PAGE_TCP_CONNECTION_2);
    }
    case 4280: { // network.tls_early_data_bytes_written
      return Some(HistogramID::TLS_EARLY_DATA_BYTES_WRITTEN);
    }
    case 4282: { // network.tls_handshake
      return Some(HistogramID::HTTP_PAGE_TLS_HANDSHAKE);
    }
    case 4286: { // dns.blocklist_count
      return Some(HistogramID::DNS_BLACKLIST_COUNT);
    }
    case 4287: { // dns.by_type_cleanup_age
      return Some(HistogramID::DNS_BY_TYPE_CLEANUP_AGE);
    }
    case 4288: { // dns.by_type_failed_lookup_time
      return Some(HistogramID::DNS_BY_TYPE_FAILED_LOOKUP_TIME);
    }
    case 4289: { // dns.by_type_premature_eviction
      return Some(HistogramID::DNS_BY_TYPE_PREMATURE_EVICTION);
    }
    case 4290: { // dns.by_type_succeeded_lookup_time
      return Some(HistogramID::DNS_BY_TYPE_SUCCEEDED_LOOKUP_TIME);
    }
    case 4291: { // dns.cleanup_age
      return Some(HistogramID::DNS_CLEANUP_AGE);
    }
    case 4292: { // dns.lookup_algorithm
      return Some(HistogramID::DNS_LOOKUP_ALGORITHM);
    }
    case 4293: { // dns.lookup_disposition
      return Some(HistogramID::DNS_LOOKUP_DISPOSITION3);
    }
    case 4294: { // dns.lookup_method
      return Some(HistogramID::DNS_LOOKUP_METHOD2);
    }
    case 4295: { // dns.native_lookup_time
      return Some(HistogramID::DNS_NATIVE_LOOKUP_TIME);
    }
    case 4296: { // dns.native_queuing
      return Some(HistogramID::DNS_NATIVE_QUEUING);
    }
    case 4297: { // dns.premature_eviction
      return Some(HistogramID::DNS_PREMATURE_EVICTION);
    }
    case 4298: { // dns.trr_attempt_count
      return Some(HistogramID::TRR_ATTEMPT_COUNT);
    }
    case 4299: { // dns.trr_blacklisted
      return Some(HistogramID::DNS_TRR_BLACKLISTED3);
    }
    case 4300: { // dns.trr_disabled
      return Some(HistogramID::DNS_TRR_DISABLED3);
    }
    case 4301: { // dns.trr_first
      return Some(HistogramID::DNS_TRR_FIRST4);
    }
    case 4302: { // dns.trr_http_version
      return Some(HistogramID::DNS_TRR_HTTP_VERSION2);
    }
    case 4303: { // dns.trr_lookup_time
      return Some(HistogramID::DNS_TRR_LOOKUP_TIME3);
    }
    case 4304: { // dns.trr_ns_verfified
      return Some(HistogramID::DNS_TRR_NS_VERFIFIED3);
    }
    case 4305: { // dns.trr_processing_time
      return Some(HistogramID::DNS_TRR_PROCESSING_TIME);
    }
    case 4306: { // dns.trr_relevant_skip_reason_native_failed
      return Some(HistogramID::TRR_RELEVANT_SKIP_REASON_NATIVE_FAILED);
    }
    case 4307: { // dns.trr_relevant_skip_reason_native_success
      return Some(HistogramID::TRR_RELEVANT_SKIP_REASON_NATIVE_SUCCESS);
    }
    case 4308: { // dns.trr_relevant_skip_reason_trr_first
      return Some(HistogramID::TRR_RELEVANT_SKIP_REASON_TRR_FIRST);
    }
    case 4309: { // dns.trr_relevant_skip_reason_trr_first_type_rec
      return Some(HistogramID::TRR_RELEVANT_SKIP_REASON_TRR_FIRST_TYPE_REC);
    }
    case 4310: { // dns.trr_skip_reason_native_failed
      return Some(HistogramID::TRR_SKIP_REASON_NATIVE_FAILED);
    }
    case 4311: { // dns.trr_skip_reason_native_success
      return Some(HistogramID::TRR_SKIP_REASON_NATIVE_SUCCESS);
    }
    case 4312: { // dns.trr_skip_reason_retry_failed
      return Some(HistogramID::TRR_SKIP_REASON_RETRY_FAILED);
    }
    case 4313: { // dns.trr_skip_reason_retry_success
      return Some(HistogramID::TRR_SKIP_REASON_RETRY_SUCCESS);
    }
    case 4314: { // dns.trr_skip_reason_strict_mode
      return Some(HistogramID::TRR_SKIP_REASON_STRICT_MODE);
    }
    case 4315: { // dns.trr_skip_reason_trr_first
      return Some(HistogramID::TRR_SKIP_REASON_TRR_FIRST2);
    }
    case 4316: { // dns.trr_success
      return Some(HistogramID::DNS_TRR_SUCCESS3);
    }
    case 4317: { // network.cookies.sqlite_open_readahead
      return Some(HistogramID::MOZ_SQLITE_COOKIES_OPEN_READAHEAD_MS);
    }
    case 4321: { // predictor.base_confidence
      return Some(HistogramID::PREDICTOR_BASE_CONFIDENCE);
    }
    case 4322: { // predictor.confidence
      return Some(HistogramID::PREDICTOR_CONFIDENCE);
    }
    case 4323: { // predictor.global_degradation
      return Some(HistogramID::PREDICTOR_GLOBAL_DEGRADATION);
    }
    case 4324: { // predictor.learn_attempts
      return Some(HistogramID::PREDICTOR_LEARN_ATTEMPTS);
    }
    case 4325: { // predictor.learn_work_time
      return Some(HistogramID::PREDICTOR_LEARN_WORK_TIME);
    }
    case 4326: { // predictor.predict_time_to_action
      return Some(HistogramID::PREDICTOR_PREDICT_TIME_TO_ACTION);
    }
    case 4327: { // predictor.predict_time_to_inaction
      return Some(HistogramID::PREDICTOR_PREDICT_TIME_TO_INACTION);
    }
    case 4328: { // predictor.predict_work_time
      return Some(HistogramID::PREDICTOR_PREDICT_WORK_TIME);
    }
    case 4329: { // predictor.predictions_calculated
      return Some(HistogramID::PREDICTOR_PREDICTIONS_CALCULATED);
    }
    case 4330: { // predictor.prefetch_decision_reason
      return Some(HistogramID::PREDICTOR_PREFETCH_DECISION_REASON);
    }
    case 4331: { // predictor.prefetch_ignore_reason
      return Some(HistogramID::PREDICTOR_PREFETCH_IGNORE_REASON);
    }
    case 4332: { // predictor.prefetch_time
      return Some(HistogramID::PREDICTOR_PREFETCH_TIME);
    }
    case 4333: { // predictor.prefetch_use_status
      return Some(HistogramID::PREDICTOR_PREFETCH_USE_STATUS);
    }
    case 4334: { // predictor.subresource_degradation
      return Some(HistogramID::PREDICTOR_SUBRESOURCE_DEGRADATION);
    }
    case 4335: { // predictor.total_preconnects
      return Some(HistogramID::PREDICTOR_TOTAL_PRECONNECTS);
    }
    case 4336: { // predictor.total_predictions
      return Some(HistogramID::PREDICTOR_TOTAL_PREDICTIONS);
    }
    case 4337: { // predictor.total_prefetches
      return Some(HistogramID::PREDICTOR_TOTAL_PREFETCHES);
    }
    case 4338: { // predictor.total_preresolves
      return Some(HistogramID::PREDICTOR_TOTAL_PRERESOLVES);
    }
    case 4339: { // predictor.wait_time
      return Some(HistogramID::PREDICTOR_WAIT_TIME);
    }
    case 4340: { // http.altsvc_mapping_changed_target
      return Some(HistogramID::HTTP_ALTSVC_MAPPING_CHANGED_TARGET);
    }
    case 4341: { // http.cache_disposition
      return Some(HistogramID::HTTP_CACHE_DISPOSITION_3);
    }
    case 4342: { // http.cache_lm_inconsistent
      return Some(HistogramID::CACHE_LM_INCONSISTENT);
    }
    case 4343: { // http.channel_disposition
      return Some(HistogramID::HTTP_CHANNEL_DISPOSITION);
    }
    case 4344: { // http.channel_onstart_success
      return Some(HistogramID::HTTP_CHANNEL_ONSTART_SUCCESS);
    }
    case 4345: { // http.channel_page_onstart_success_trr
      return Some(HistogramID::HTTP_CHANNEL_PAGE_ONSTART_SUCCESS_TRR3);
    }
    case 4346: { // http.channel_sub_onstart_success_trr
      return Some(HistogramID::HTTP_CHANNEL_SUB_ONSTART_SUCCESS_TRR3);
    }
    case 4347: { // http.connection_close_reason
      return Some(HistogramID::HTTP_CONNECTION_CLOSE_REASON);
    }
    case 4348: { // http.connection_entry_cache_hit
      return Some(HistogramID::HTTP_CONNECTION_ENTRY_CACHE_HIT_1);
    }
    case 4349: { // http.content_encoding
      return Some(HistogramID::HTTP_CONTENT_ENCODING);
    }
    case 4350: { // http.dns_httpssvc_connection_failed_reason
      return Some(HistogramID::DNS_HTTPSSVC_CONNECTION_FAILED_REASON);
    }
    case 4351: { // http.dns_httpssvc_record_receiving_stage
      return Some(HistogramID::DNS_HTTPSSVC_RECORD_RECEIVING_STAGE);
    }
    case 4352: { // http.dnt_usage
      return Some(HistogramID::DNT_USAGE);
    }
    case 4353: { // http.echconfig_success_rate
      return Some(HistogramID::ECHCONFIG_SUCCESS_RATE);
    }
    case 4354: { // http.http2_fail_before_settings
      return Some(HistogramID::HTTP2_FAIL_BEFORE_SETTINGS);
    }
    case 4355: { // http.kbread_per_conn2
      return Some(HistogramID::HTTP_KBREAD_PER_CONN2);
    }
    case 4356: { // http.pageload_is_ssl
      return Some(HistogramID::HTTP_PAGELOAD_IS_SSL);
    }
    case 4357: { // http.request_per_conn
      return Some(HistogramID::HTTP_REQUEST_PER_CONN);
    }
    case 4358: { // http.request_per_page
      return Some(HistogramID::HTTP_REQUEST_PER_PAGE);
    }
    case 4359: { // http.request_per_page_from_cache
      return Some(HistogramID::HTTP_REQUEST_PER_PAGE_FROM_CACHE);
    }
    case 4360: { // http.response_version
      return Some(HistogramID::HTTP_RESPONSE_VERSION);
    }
    case 4361: { // http.script_block_incorrect_mime
      return Some(HistogramID::SCRIPT_BLOCK_INCORRECT_MIME_3);
    }
    case 4362: { // http.subitem_first_byte_latency_time
      return Some(HistogramID::HTTP_SUBITEM_FIRST_BYTE_LATENCY_TIME);
    }
    case 4363: { // http.subitem_open_latency_time
      return Some(HistogramID::HTTP_SUBITEM_OPEN_LATENCY_TIME);
    }
    case 4364: { // http.tls_early_data_accepted
      return Some(HistogramID::TLS_EARLY_DATA_ACCEPTED);
    }
    case 4365: { // http.tls_early_data_negotiated
      return Some(HistogramID::TLS_EARLY_DATA_NEGOTIATED);
    }
    case 4366: { // http.traffic_analysis
      return Some(HistogramID::HTTP_TRAFFIC_ANALYSIS_3);
    }
    case 4367: { // http.transaction_ech_retry_ech_failed_count
      return Some(HistogramID::TRANSACTION_ECH_RETRY_ECH_FAILED_COUNT);
    }
    case 4368: { // http.transaction_ech_retry_others_count
      return Some(HistogramID::TRANSACTION_ECH_RETRY_OTHERS_COUNT);
    }
    case 4369: { // http.transaction_ech_retry_with_ech_count
      return Some(HistogramID::TRANSACTION_ECH_RETRY_WITH_ECH_COUNT);
    }
    case 4370: { // http.transaction_ech_retry_without_ech_count
      return Some(HistogramID::TRANSACTION_ECH_RETRY_WITHOUT_ECH_COUNT);
    }
    case 4371: { // http.transaction_is_ssl
      return Some(HistogramID::HTTP_TRANSACTION_IS_SSL);
    }
    case 4372: { // http.transaction_restart_reason
      return Some(HistogramID::HTTP_TRANSACTION_RESTART_REASON);
    }
    case 4373: { // http.transaction_use_altsvc
      return Some(HistogramID::HTTP_TRANSACTION_USE_ALTSVC);
    }
    case 4374: { // http.transaction_wait_time_http
      return Some(HistogramID::TRANSACTION_WAIT_TIME_HTTP);
    }
    case 4375: { // http.transaction_wait_time_http2_sup_http3
      return Some(HistogramID::TRANSACTION_WAIT_TIME_HTTP2_SUP_HTTP3);
    }
    case 4376: { // http.transaction_wait_time_http3
      return Some(HistogramID::TRANSACTION_WAIT_TIME_HTTP3);
    }
    case 4377: { // http.transaction_wait_time_spdy
      return Some(HistogramID::TRANSACTION_WAIT_TIME_SPDY);
    }
    case 4378: { // http.upload_bandwidth_mbps
      return Some(HistogramID::HTTP_UPLOAD_BANDWIDTH_MBPS);
    }
    case 4379: { // http3.blocked_by_stream_limit_per_conn
      return Some(HistogramID::HTTP3_BLOCKED_BY_STREAM_LIMIT_PER_CONN);
    }
    case 4380: { // http3.connection_close_code
      return Some(HistogramID::HTTP3_CONNECTION_CLOSE_CODE_3);
    }
    case 4381: { // http3.counts_pto
      return Some(HistogramID::HTTP3_COUNTS_PTO);
    }
    case 4382: { // http3.drop_dgrams
      return Some(HistogramID::HTTP3_DROP_DGRAMS);
    }
    case 4383: { // http3.ech_outcome
      return Some(HistogramID::HTTP3_ECH_OUTCOME);
    }
    case 4384: { // http3.late_ack
      return Some(HistogramID::HTTP3_LATE_ACK);
    }
    case 4385: { // http3.late_ack_ratio
      return Some(HistogramID::HTTP3_LATE_ACK_RATIO);
    }
    case 4386: { // http3.loss_ratio
      return Some(HistogramID::HTTP3_LOSS_RATIO);
    }
    case 4387: { // http3.received_sent_dgrams
      return Some(HistogramID::HTTP3_RECEIVED_SENT_DGRAMS);
    }
    case 4388: { // http3.request_per_conn
      return Some(HistogramID::HTTP3_REQUEST_PER_CONN);
    }
    case 4389: { // http3.saved_dgrams
      return Some(HistogramID::HTTP3_SAVED_DGRAMS);
    }
    case 4390: { // http3.sending_blocked_by_flow_control_per_trans
      return Some(HistogramID::HTTP3_SENDING_BLOCKED_BY_FLOW_CONTROL_PER_TRANS);
    }
    case 4391: { // http3.timer_delayed
      return Some(HistogramID::HTTP3_TIMER_DELAYED);
    }
    case 4392: { // http3.trans_blocked_by_stream_limit_per_conn
      return Some(HistogramID::HTTP3_TRANS_BLOCKED_BY_STREAM_LIMIT_PER_CONN);
    }
    case 4393: { // http3.trans_sending_blocked_by_flow_control_per_conn
      return Some(HistogramID::HTTP3_TRANS_SENDING_BLOCKED_BY_FLOW_CONTROL_PER_CONN);
    }
    case 4396: { // netwerk.http3_time_to_reuse_idle_connection
      return Some(HistogramID::HTTP3_TIME_TO_REUSE_IDLE_CONNECTTION_MS);
    }
    case 4400: { // orb.block_initiator
      return Some(HistogramID::ORB_BLOCK_INITIATOR);
    }
    case 4401: { // orb.block_reason
      return Some(HistogramID::ORB_BLOCK_REASON);
    }
    case 4402: { // orb.did_ever_block_response
      return Some(HistogramID::ORB_DID_EVER_BLOCK_RESPONSE);
    }
    case 4403: { // orb.javascript_validation
      return Some(HistogramID::ORB_JAVASCRIPT_VALIDATION_MS);
    }
    case 4404: { // orb.receive_data_for_validation
      return Some(HistogramID::ORB_RECEIVE_DATA_FOR_VALIDATION_MS);
    }
    case 4405: { // spdy.continued_headers
      return Some(HistogramID::SPDY_CONTINUED_HEADERS);
    }
    case 4406: { // spdy.goaway_local
      return Some(HistogramID::SPDY_GOAWAY_LOCAL);
    }
    case 4407: { // spdy.goaway_peer
      return Some(HistogramID::SPDY_GOAWAY_PEER);
    }
    case 4408: { // spdy.kbread_per_conn
      return Some(HistogramID::SPDY_KBREAD_PER_CONN2);
    }
    case 4409: { // spdy.parallel_streams
      return Some(HistogramID::SPDY_PARALLEL_STREAMS);
    }
    case 4410: { // spdy.request_per_conn
      return Some(HistogramID::SPDY_REQUEST_PER_CONN_3);
    }
    case 4411: { // spdy.server_initiated_streams
      return Some(HistogramID::SPDY_SERVER_INITIATED_STREAMS);
    }
    case 4412: { // spdy.settings_max_streams
      return Some(HistogramID::SPDY_SETTINGS_MAX_STREAMS);
    }
    case 4413: { // websockets.handshake_type
      return Some(HistogramID::WEBSOCKETS_HANDSHAKE_TYPE);
    }
    case 4425: { // cert.chain_key_size_status
      return Some(HistogramID::CERT_CHAIN_KEY_SIZE_STATUS);
    }
    case 4426: { // cert.ev_status
      return Some(HistogramID::CERT_EV_STATUS);
    }
    case 4427: { // cert.validation_http_request_result
      return Some(HistogramID::CERT_VALIDATION_HTTP_REQUEST_RESULT);
    }
    case 4431: { // cert_pinning.moz_results_by_host
      return Some(HistogramID::CERT_PINNING_MOZ_RESULTS_BY_HOST);
    }
    case 4432: { // cert_pinning.moz_test_results_by_host
      return Some(HistogramID::CERT_PINNING_MOZ_TEST_RESULTS_BY_HOST);
    }
    case 4433: { // cert_pinning.results
      return Some(HistogramID::CERT_PINNING_RESULTS);
    }
    case 4434: { // cert_pinning.test_results
      return Some(HistogramID::CERT_PINNING_TEST_RESULTS);
    }
    case 4448: { // ssl.auth_algorithm_full
      return Some(HistogramID::SSL_AUTH_ALGORITHM_FULL);
    }
    case 4449: { // ssl.auth_ecdsa_curve_full
      return Some(HistogramID::SSL_AUTH_ECDSA_CURVE_FULL);
    }
    case 4450: { // ssl.auth_rsa_key_size_full
      return Some(HistogramID::SSL_AUTH_RSA_KEY_SIZE_FULL);
    }
    case 4451: { // ssl.bytes_before_cert_callback
      return Some(HistogramID::SSL_BYTES_BEFORE_CERT_CALLBACK);
    }
    case 4452: { // ssl.cert_error_overrides
      return Some(HistogramID::SSL_CERT_ERROR_OVERRIDES);
    }
    case 4453: { // ssl.cert_verification_errors
      return Some(HistogramID::SSL_CERT_VERIFICATION_ERRORS);
    }
    case 4455: { // ssl.kea_dhe_key_size_full
      return Some(HistogramID::SSL_KEA_DHE_KEY_SIZE_FULL);
    }
    case 4456: { // ssl.kea_ecdhe_curve_full
      return Some(HistogramID::SSL_KEA_ECDHE_CURVE_FULL);
    }
    case 4457: { // ssl.kea_rsa_key_size_full
      return Some(HistogramID::SSL_KEA_RSA_KEY_SIZE_FULL);
    }
    case 4458: { // ssl.key_exchange_algorithm_full
      return Some(HistogramID::SSL_KEY_EXCHANGE_ALGORITHM_FULL);
    }
    case 4459: { // ssl.key_exchange_algorithm_resumed
      return Some(HistogramID::SSL_KEY_EXCHANGE_ALGORITHM_RESUMED);
    }
    case 4460: { // ssl.npn_type
      return Some(HistogramID::SSL_NPN_TYPE);
    }
    case 4461: { // ssl.ocsp_stapling
      return Some(HistogramID::SSL_OCSP_STAPLING);
    }
    case 4462: { // ssl.permanent_cert_error_overrides
      return Some(HistogramID::SSL_PERMANENT_CERT_ERROR_OVERRIDES);
    }
    case 4463: { // ssl.reasons_for_not_false_starting
      return Some(HistogramID::SSL_REASONS_FOR_NOT_FALSE_STARTING);
    }
    case 4464: { // ssl.resumed_session
      return Some(HistogramID::SSL_RESUMED_SESSION);
    }
    case 4466: { // ssl.scts_origin
      return Some(HistogramID::SSL_SCTS_ORIGIN);
    }
    case 4467: { // ssl.scts_per_connection
      return Some(HistogramID::SSL_SCTS_PER_CONNECTION);
    }
    case 4469: { // ssl.time_until_handshake_finished_keyed_by_ka
      return Some(HistogramID::SSL_TIME_UNTIL_HANDSHAKE_FINISHED_KEYED_BY_KA);
    }
    case 4470: { // ssl.time_until_ready
      return Some(HistogramID::SSL_TIME_UNTIL_READY);
    }
    case 4471: { // ssl.time_until_ready_conservative
      return Some(HistogramID::SSL_TIME_UNTIL_READY_CONSERVATIVE);
    }
    case 4472: { // ssl.time_until_ready_ech
      return Some(HistogramID::SSL_TIME_UNTIL_READY_ECH);
    }
    case 4473: { // ssl.time_until_ready_ech_grease
      return Some(HistogramID::SSL_TIME_UNTIL_READY_ECH_GREASE);
    }
    case 4474: { // ssl.time_until_ready_first_try
      return Some(HistogramID::SSL_TIME_UNTIL_READY_FIRST_TRY);
    }
    case 4475: { // ssl.tls10_intolerance_reason_post
      return Some(HistogramID::SSL_TLS10_INTOLERANCE_REASON_POST);
    }
    case 4476: { // ssl.tls10_intolerance_reason_pre
      return Some(HistogramID::SSL_TLS10_INTOLERANCE_REASON_PRE);
    }
    case 4477: { // ssl.tls11_intolerance_reason_post
      return Some(HistogramID::SSL_TLS11_INTOLERANCE_REASON_POST);
    }
    case 4478: { // ssl.tls11_intolerance_reason_pre
      return Some(HistogramID::SSL_TLS11_INTOLERANCE_REASON_PRE);
    }
    case 4479: { // ssl.tls12_intolerance_reason_post
      return Some(HistogramID::SSL_TLS12_INTOLERANCE_REASON_POST);
    }
    case 4480: { // ssl.tls12_intolerance_reason_pre
      return Some(HistogramID::SSL_TLS12_INTOLERANCE_REASON_PRE);
    }
    case 4481: { // ssl.tls13_intolerance_reason_post
      return Some(HistogramID::SSL_TLS13_INTOLERANCE_REASON_POST);
    }
    case 4482: { // ssl.tls13_intolerance_reason_pre
      return Some(HistogramID::SSL_TLS13_INTOLERANCE_REASON_PRE);
    }
    case 4483: { // ssl.version_fallback_inappropriate
      return Some(HistogramID::SSL_VERSION_FALLBACK_INAPPROPRIATE);
    }
    case 4484: { // ssl_handshake.completed
      return Some(HistogramID::SSL_HANDSHAKE_TYPE);
    }
    case 4485: { // ssl_handshake.privacy
      return Some(HistogramID::SSL_HANDSHAKE_PRIVACY);
    }
    case 4486: { // ssl_handshake.result
      return Some(HistogramID::SSL_HANDSHAKE_RESULT);
    }
    case 4487: { // ssl_handshake.result_conservative
      return Some(HistogramID::SSL_HANDSHAKE_RESULT_CONSERVATIVE);
    }
    case 4488: { // ssl_handshake.result_ech
      return Some(HistogramID::SSL_HANDSHAKE_RESULT_ECH);
    }
    case 4489: { // ssl_handshake.result_ech_grease
      return Some(HistogramID::SSL_HANDSHAKE_RESULT_ECH_GREASE);
    }
    case 4490: { // ssl_handshake.result_first_try
      return Some(HistogramID::SSL_HANDSHAKE_RESULT_FIRST_TRY);
    }
    case 4491: { // ssl_handshake.version
      return Some(HistogramID::SSL_HANDSHAKE_VERSION);
    }
    case 4493: { // tls.cipher_suite
      return Some(HistogramID::TLS_CIPHER_SUITE);
    }
    case 4502: { // sandbox.failed_launch_keyed
      return Some(HistogramID::SANDBOX_FAILED_LAUNCH_KEYED);
    }
    case 4503: { // sandbox.rejected_syscalls
      return Some(HistogramID::SANDBOX_REJECTED_SYSCALLS);
    }
    case 4550: { // sync.device_count_desktop
      return Some(HistogramID::WEAVE_DEVICE_COUNT_DESKTOP);
    }
    case 4551: { // sync.device_count_mobile
      return Some(HistogramID::WEAVE_DEVICE_COUNT_MOBILE);
    }
    case 4564: { // startup_cache.requests
      return Some(HistogramID::STARTUP_CACHE_REQUESTS);
    }
    case 4565: { // sqlite_store.open
      return Some(HistogramID::SQLITE_STORE_OPEN);
    }
    case 4566: { // sqlite_store.query
      return Some(HistogramID::SQLITE_STORE_QUERY);
    }
    case 4573: { // contentblocking.canvas_fingerprinting_per_tab
      return Some(HistogramID::CANVAS_FINGERPRINTING_PER_TAB);
    }
    case 4575: { // contentblocking.cookie_behavior
      return Some(HistogramID::COOKIE_BEHAVIOR);
    }
    case 4576: { // contentblocking.cryptominers_blocked_count
      return Some(HistogramID::CRYPTOMINERS_BLOCKED_COUNT);
    }
    case 4578: { // contentblocking.email_tracker_count
      return Some(HistogramID::EMAIL_TRACKER_COUNT);
    }
    case 4579: { // contentblocking.email_tracker_embedded_per_tab
      return Some(HistogramID::EMAIL_TRACKER_EMBEDDED_PER_TAB);
    }
    case 4580: { // contentblocking.fingerprinters_blocked_count
      return Some(HistogramID::FINGERPRINTERS_BLOCKED_COUNT);
    }
    case 4582: { // contentblocking.font_fingerprinting_per_tab
      return Some(HistogramID::FONT_FINGERPRINTING_PER_TAB);
    }
    case 4583: { // contentblocking.query_stripping_count
      return Some(HistogramID::QUERY_STRIPPING_COUNT);
    }
    case 4584: { // contentblocking.query_stripping_count_by_param
      return Some(HistogramID::QUERY_STRIPPING_COUNT_BY_PARAM);
    }
    case 4585: { // contentblocking.query_stripping_param_count
      return Some(HistogramID::QUERY_STRIPPING_PARAM_COUNT);
    }
    case 4586: { // contentblocking.storage_access_granted_count
      return Some(HistogramID::STORAGE_ACCESS_GRANTED_COUNT);
    }
    case 4587: { // contentblocking.storage_access_remaining_days
      return Some(HistogramID::STORAGE_ACCESS_REMAINING_DAYS);
    }
    case 4588: { // contentblocking.strip_on_share_length_decrease
      return Some(HistogramID::STRIP_ON_SHARE_LENGTH_DECREASE);
    }
    case 4589: { // contentblocking.strip_on_share_params_removed
      return Some(HistogramID::STRIP_ON_SHARE_PARAMS_REMOVED);
    }
    case 4593: { // contentblocking.tracking_protection_enabled
      return Some(HistogramID::TRACKING_PROTECTION_ENABLED);
    }
    case 4594: { // contentblocking.tracking_protection_pbm_disabled
      return Some(HistogramID::TRACKING_PROTECTION_PBM_DISABLED);
    }
    case 4595: { // contentblocking.tracking_protection_shield
      return Some(HistogramID::TRACKING_PROTECTION_SHIELD);
    }
    case 4596: { // cookie_purging.duration
      return Some(HistogramID::COOKIE_PURGING_DURATION_MS);
    }
    case 4597: { // cookie_purging.interval_hours
      return Some(HistogramID::COOKIE_PURGING_INTERVAL_HOURS);
    }
    case 4598: { // cookie_purging.origins_purged
      return Some(HistogramID::COOKIE_PURGING_ORIGINS_PURGED);
    }
    case 4599: { // cookie_purging.trackers_user_interaction_remaining_days
      return Some(HistogramID::COOKIE_PURGING_TRACKERS_USER_INTERACTION_REMAINING_DAYS);
    }
    case 4600: { // cookie_purging.trackers_with_user_interaction
      return Some(HistogramID::COOKIE_PURGING_TRACKERS_WITH_USER_INTERACTION);
    }
    case 4706: { // crash.compressed_store_size
      return Some(HistogramID::CRASH_STORE_COMPRESSED_BYTES);
    }
    case 4722: { // crash.submit_attempt
      return Some(HistogramID::PROCESS_CRASH_SUBMIT_ATTEMPT);
    }
    case 4723: { // crash.submit_success
      return Some(HistogramID::PROCESS_CRASH_SUBMIT_SUCCESS);
    }
    case 4754: { // memory.collection_time
      return Some(HistogramID::MEMORY_COLLECTION_TIME);
    }
    case 4755: { // memory.distribution_among_content
      return Some(HistogramID::MEMORY_DISTRIBUTION_AMONG_CONTENT);
    }
    case 4756: { // memory.free_purged_pages
      return Some(HistogramID::MEMORY_FREE_PURGED_PAGES_MS);
    }
    case 4757: { // memory.ghost_windows
      return Some(HistogramID::GHOST_WINDOWS);
    }
    case 4758: { // memory.heap_allocated
      return Some(HistogramID::MEMORY_HEAP_ALLOCATED);
    }
    case 4759: { // memory.heap_overhead_fraction
      return Some(HistogramID::MEMORY_HEAP_OVERHEAD_FRACTION);
    }
    case 4760: { // memory.images_content_used_uncompressed
      return Some(HistogramID::MEMORY_IMAGES_CONTENT_USED_UNCOMPRESSED);
    }
    case 4761: { // memory.js_compartments_system
      return Some(HistogramID::MEMORY_JS_COMPARTMENTS_SYSTEM);
    }
    case 4762: { // memory.js_compartments_user
      return Some(HistogramID::MEMORY_JS_COMPARTMENTS_USER);
    }
    case 4764: { // memory.js_realms_system
      return Some(HistogramID::MEMORY_JS_REALMS_SYSTEM);
    }
    case 4765: { // memory.js_realms_user
      return Some(HistogramID::MEMORY_JS_REALMS_USER);
    }
    case 4766: { // memory.low_memory_events_physical
      return Some(HistogramID::LOW_MEMORY_EVENTS_PHYSICAL);
    }
    case 4767: { // memory.page_faults_hard
      return Some(HistogramID::PAGE_FAULTS_HARD);
    }
    case 4770: { // memory.storage_sqlite
      return Some(HistogramID::MEMORY_STORAGE_SQLITE);
    }
    case 4771: { // memory.total
      return Some(HistogramID::MEMORY_TOTAL);
    }
    case 4773: { // memory.unique_content_startup
      return Some(HistogramID::MEMORY_UNIQUE_CONTENT_STARTUP);
    }
    case 4774: { // memory.vsize
      return Some(HistogramID::MEMORY_VSIZE);
    }
    case 4775: { // memory.vsize_max_contiguous
      return Some(HistogramID::MEMORY_VSIZE_MAX_CONTIGUOUS);
    }
    case 4798: { // extensions.apis.dnr.evaluate_rules_time
      return Some(HistogramID::WEBEXT_DNR_EVALUATE_RULES_MS);
    }
    case 4800: { // extensions.apis.dnr.startup_cache_read_size
      return Some(HistogramID::WEBEXT_DNR_STARTUPCACHE_READ_BYTES);
    }
    case 4801: { // extensions.apis.dnr.startup_cache_read_time
      return Some(HistogramID::WEBEXT_DNR_STARTUPCACHE_READ_MS);
    }
    case 4802: { // extensions.apis.dnr.startup_cache_write_size
      return Some(HistogramID::WEBEXT_DNR_STARTUPCACHE_WRITE_BYTES);
    }
    case 4803: { // extensions.apis.dnr.startup_cache_write_time
      return Some(HistogramID::WEBEXT_DNR_STARTUPCACHE_WRITE_MS);
    }
    case 4804: { // extensions.apis.dnr.validate_rules_time
      return Some(HistogramID::WEBEXT_DNR_VALIDATE_RULES_MS);
    }
    case 4805: { // extensions.counters.browser_action_preload_result
      return Some(HistogramID::WEBEXT_BROWSERACTION_POPUP_PRELOAD_RESULT_COUNT);
    }
    case 4806: { // extensions.counters.browser_action_preload_result_by_addonid
      return Some(HistogramID::WEBEXT_BROWSERACTION_POPUP_PRELOAD_RESULT_COUNT_BY_ADDONID);
    }
    case 4807: { // extensions.counters.event_page_idle_result
      return Some(HistogramID::WEBEXT_EVENTPAGE_IDLE_RESULT_COUNT);
    }
    case 4808: { // extensions.counters.event_page_idle_result_by_addonid
      return Some(HistogramID::WEBEXT_EVENTPAGE_IDLE_RESULT_COUNT_BY_ADDONID);
    }
    case 4810: { // extensions.data.migrate_result_count
      return Some(HistogramID::WEBEXT_STORAGE_LOCAL_IDB_MIGRATE_RESULT_COUNT);
    }
    case 4814: { // extensions.timing.background_page_load
      return Some(HistogramID::WEBEXT_BACKGROUND_PAGE_LOAD_MS);
    }
    case 4815: { // extensions.timing.background_page_load_by_addonid
      return Some(HistogramID::WEBEXT_BACKGROUND_PAGE_LOAD_MS_BY_ADDONID);
    }
    case 4816: { // extensions.timing.browser_action_popup_open
      return Some(HistogramID::WEBEXT_BROWSERACTION_POPUP_OPEN_MS);
    }
    case 4817: { // extensions.timing.browser_action_popup_open_by_addonid
      return Some(HistogramID::WEBEXT_BROWSERACTION_POPUP_OPEN_MS_BY_ADDONID);
    }
    case 4818: { // extensions.timing.content_script_injection
      return Some(HistogramID::WEBEXT_CONTENT_SCRIPT_INJECTION_MS);
    }
    case 4819: { // extensions.timing.content_script_injection_by_addonid
      return Some(HistogramID::WEBEXT_CONTENT_SCRIPT_INJECTION_MS_BY_ADDONID);
    }
    case 4820: { // extensions.timing.event_page_running_time
      return Some(HistogramID::WEBEXT_EVENTPAGE_RUNNING_TIME_MS);
    }
    case 4821: { // extensions.timing.event_page_running_time_by_addonid
      return Some(HistogramID::WEBEXT_EVENTPAGE_RUNNING_TIME_MS_BY_ADDONID);
    }
    case 4822: { // extensions.timing.extension_startup
      return Some(HistogramID::WEBEXT_EXTENSION_STARTUP_MS);
    }
    case 4823: { // extensions.timing.extension_startup_by_addonid
      return Some(HistogramID::WEBEXT_EXTENSION_STARTUP_MS_BY_ADDONID);
    }
    case 4824: { // extensions.timing.page_action_popup_open
      return Some(HistogramID::WEBEXT_PAGEACTION_POPUP_OPEN_MS);
    }
    case 4825: { // extensions.timing.page_action_popup_open_by_addonid
      return Some(HistogramID::WEBEXT_PAGEACTION_POPUP_OPEN_MS_BY_ADDONID);
    }
    case 4826: { // extensions.timing.storage_local_get_idb
      return Some(HistogramID::WEBEXT_STORAGE_LOCAL_IDB_GET_MS);
    }
    case 4827: { // extensions.timing.storage_local_get_idb_by_addonid
      return Some(HistogramID::WEBEXT_STORAGE_LOCAL_IDB_GET_MS_BY_ADDONID);
    }
    case 4828: { // extensions.timing.storage_local_set_idb
      return Some(HistogramID::WEBEXT_STORAGE_LOCAL_IDB_SET_MS);
    }
    case 4829: { // extensions.timing.storage_local_set_idb_by_addonid
      return Some(HistogramID::WEBEXT_STORAGE_LOCAL_IDB_SET_MS_BY_ADDONID);
    }
    case 4927: { // test_only.expired_hist
      return Some(HistogramID::TELEMETRY_TEST_EXPIRED);
    }
    case 4937: { // test_only.mabels_custom_label_lengths
      return Some(HistogramID::TELEMETRY_TEST_KEYED_LINEAR);
    }
    case 4955: { // test_only.what_do_you_remember
      return Some(HistogramID::TELEMETRY_TEST_MIRROR_FOR_LABELED_MEMORY);
    }
    case 4957: { // test_only.what_time_is_it
      return Some(HistogramID::TELEMETRY_TEST_MIRROR_FOR_TIMING);
    }
    case 4958: { // test_only.where_has_the_time_gone
      return Some(HistogramID::TELEMETRY_TEST_MIRROR_FOR_LABELED_TIMING);
    }
    case 4961: { // test_only.ipc.a_counter_for_hgram
      return Some(HistogramID::TELEMETRY_TEST_COUNT);
    }
    case 4962: { // test_only.ipc.a_custom_dist
      return Some(HistogramID::TELEMETRY_TEST_MIRROR_FOR_CUSTOM);
    }
    case 4964: { // test_only.ipc.a_dual_labeled_counter
      return Some(HistogramID::TELEMETRY_TEST_MIRROR_FOR_DUAL_LABELED_COUNTER);
    }
    case 4966: { // test_only.ipc.a_labeled_counter_for_categorical
      return Some(HistogramID::TELEMETRY_TEST_CATEGORICAL_OPTOUT);
    }
    case 4967: { // test_only.ipc.a_labeled_counter_for_hgram
      return Some(HistogramID::TELEMETRY_TEST_BOOLEAN);
    }
    case 4968: { // test_only.ipc.a_labeled_counter_for_keyed_count_hgram
      return Some(HistogramID::TELEMETRY_TEST_KEYED_COUNT);
    }
    case 4969: { // test_only.ipc.a_memory_dist
      return Some(HistogramID::TELEMETRY_TEST_LINEAR);
    }
    case 4974: { // test_only.ipc.a_timing_dist
      return Some(HistogramID::TELEMETRY_TEST_EXPONENTIAL);
    }
    case 4981: { // test_only.ipc.another_dual_labeled_counter
      return Some(HistogramID::TELEMETRY_TEST_ANOTHER_MIRROR_FOR_DUAL_LABELED_COUNTER);
    }
    case 4989: { // media_sniffer.mp4_brand_pattern
      return Some(HistogramID::MEDIA_SNIFFER_MP4_BRAND_PATTERN);
    }
    case 5148: { // pwmgr.import_logins_from_file_categorical
      return Some(HistogramID::PWMGR_IMPORT_LOGINS_FROM_FILE_CATEGORICAL);
    }
    case 5149: { // pwmgr.is_username_only_form
      return Some(HistogramID::PWMGR_IS_USERNAME_ONLY_FORM);
    }
    case 5151: { // pwmgr.login_page_safety
      return Some(HistogramID::PWMGR_LOGIN_PAGE_SAFETY);
    }
    case 5160: { // pwmgr.num_improved_generated_passwords
      return Some(HistogramID::PWMGR_NUM_IMPROVED_GENERATED_PASSWORDS);
    }
    case 5173: { // pwmgr.prompt_remember_action
      return Some(HistogramID::PWMGR_PROMPT_REMEMBER_ACTION);
    }
    case 5175: { // pwmgr.prompt_update_action
      return Some(HistogramID::PWMGR_PROMPT_UPDATE_ACTION);
    }
    case 5191: { // pwmgr.signup_form_detection
      return Some(HistogramID::PWMGR_SIGNUP_FORM_DETECTION_MS);
    }
    case 5257: { // pictureinpicture.background_tab_playing_duration
      return Some(HistogramID::FX_PICTURE_IN_PICTURE_BACKGROUND_TAB_PLAYING_DURATION);
    }
    case 5273: { // pictureinpicture.foreground_tab_playing_duration
      return Some(HistogramID::FX_PICTURE_IN_PICTURE_FOREGROUND_TAB_PLAYING_DURATION);
    }
    case 5285: { // pictureinpicture.window_open_duration
      return Some(HistogramID::FX_PICTURE_IN_PICTURE_WINDOW_OPEN_DURATION);
    }
    case 5292: { // places.annos_pages_count
      return Some(HistogramID::PLACES_ANNOS_PAGES_COUNT);
    }
    case 5293: { // places.backups_bookmarkstree
      return Some(HistogramID::PLACES_BACKUPS_BOOKMARKSTREE_MS);
    }
    case 5294: { // places.backups_daysfromlast
      return Some(HistogramID::PLACES_BACKUPS_DAYSFROMLAST);
    }
    case 5295: { // places.backups_tojson
      return Some(HistogramID::PLACES_BACKUPS_TOJSON_MS);
    }
    case 5296: { // places.bookmarks_count
      return Some(HistogramID::PLACES_BOOKMARKS_COUNT);
    }
    case 5297: { // places.database_favicons_filesize
      return Some(HistogramID::PLACES_DATABASE_FAVICONS_FILESIZE_MB);
    }
    case 5298: { // places.database_filesize
      return Some(HistogramID::PLACES_DATABASE_FILESIZE_MB);
    }
    case 5302: { // places.expiration_steps_to_clean
      return Some(HistogramID::PLACES_EXPIRATION_STEPS_TO_CLEAN2);
    }
    case 5303: { // places.export_tohtml
      return Some(HistogramID::PLACES_EXPORT_TOHTML_MS);
    }
    case 5304: { // places.frecency_recalc_chunk_time
      return Some(HistogramID::PLACES_FRECENCY_RECALC_CHUNK_TIME_MS);
    }
    case 5305: { // places.idle_frecency_decay_time
      return Some(HistogramID::PLACES_IDLE_FRECENCY_DECAY_TIME_MS);
    }
    case 5306: { // places.idle_maintenance_time
      return Some(HistogramID::PLACES_IDLE_MAINTENANCE_TIME_MS);
    }
    case 5307: { // places.keywords_count
      return Some(HistogramID::PLACES_KEYWORDS_COUNT);
    }
    case 5308: { // places.maintenance_daysfromlast
      return Some(HistogramID::PLACES_MAINTENANCE_DAYSFROMLAST);
    }
    case 5309: { // places.most_recent_expired_visit
      return Some(HistogramID::PLACES_MOST_RECENT_EXPIRED_VISIT_DAYS);
    }
    case 5310: { // places.pages_count
      return Some(HistogramID::PLACES_PAGES_COUNT);
    }
    case 5317: { // places.sorted_bookmarks_perc
      return Some(HistogramID::PLACES_SORTED_BOOKMARKS_PERC);
    }
    case 5319: { // places.tagged_bookmarks_perc
      return Some(HistogramID::PLACES_TAGGED_BOOKMARKS_PERC);
    }
    case 5320: { // places.tags_count
      return Some(HistogramID::PLACES_TAGS_COUNT);
    }
    case 5353: { // readermode.download_result
      return Some(HistogramID::READER_MODE_DOWNLOAD_RESULT);
    }
    case 5354: { // readermode.parse_result
      return Some(HistogramID::READER_MODE_PARSE_RESULT);
    }
    case 5404: { // application_reputation.binary_archive
      return Some(HistogramID::APPLICATION_REPUTATION_BINARY_ARCHIVE);
    }
    case 5405: { // application_reputation.binary_type
      return Some(HistogramID::APPLICATION_REPUTATION_BINARY_TYPE);
    }
    case 5406: { // application_reputation.local
      return Some(HistogramID::APPLICATION_REPUTATION_LOCAL);
    }
    case 5407: { // application_reputation.reason
      return Some(HistogramID::APPLICATION_REPUTATION_REASON);
    }
    case 5408: { // application_reputation.remote_lookup_response_time
      return Some(HistogramID::APPLICATION_REPUTATION_REMOTE_LOOKUP_RESPONSE_TIME);
    }
    case 5409: { // application_reputation.remote_lookup_timeout
      return Some(HistogramID::APPLICATION_REPUTATION_REMOTE_LOOKUP_TIMEOUT);
    }
    case 5410: { // application_reputation.server
      return Some(HistogramID::APPLICATION_REPUTATION_SERVER);
    }
    case 5411: { // application_reputation.server_2
      return Some(HistogramID::APPLICATION_REPUTATION_SERVER_2);
    }
    case 5412: { // application_reputation.server_verdict
      return Some(HistogramID::APPLICATION_REPUTATION_SERVER_VERDICT);
    }
    case 5413: { // application_reputation.server_verdict_2
      return Some(HistogramID::APPLICATION_REPUTATION_SERVER_VERDICT_2);
    }
    case 5414: { // application_reputation.should_block
      return Some(HistogramID::APPLICATION_REPUTATION_SHOULD_BLOCK);
    }
    case 5709: { // search.suggestions.latency
      return Some(HistogramID::SEARCH_SUGGESTIONS_LATENCY_MS);
    }
    case 5719: { // telemetry.archive_checking_over_quota
      return Some(HistogramID::TELEMETRY_ARCHIVE_CHECKING_OVER_QUOTA_MS);
    }
    case 5720: { // telemetry.archive_directories_count
      return Some(HistogramID::TELEMETRY_ARCHIVE_DIRECTORIES_COUNT);
    }
    case 5721: { // telemetry.archive_evicted_old_dirs
      return Some(HistogramID::TELEMETRY_ARCHIVE_EVICTED_OLD_DIRS);
    }
    case 5722: { // telemetry.archive_evicted_over_quota
      return Some(HistogramID::TELEMETRY_ARCHIVE_EVICTED_OVER_QUOTA);
    }
    case 5723: { // telemetry.archive_evicting_dirs
      return Some(HistogramID::TELEMETRY_ARCHIVE_EVICTING_DIRS_MS);
    }
    case 5724: { // telemetry.archive_evicting_over_quota
      return Some(HistogramID::TELEMETRY_ARCHIVE_EVICTING_OVER_QUOTA_MS);
    }
    case 5725: { // telemetry.archive_oldest_directory_age
      return Some(HistogramID::TELEMETRY_ARCHIVE_OLDEST_DIRECTORY_AGE);
    }
    case 5726: { // telemetry.archive_scan_ping_count
      return Some(HistogramID::TELEMETRY_ARCHIVE_SCAN_PING_COUNT);
    }
    case 5727: { // telemetry.archive_session_ping_count
      return Some(HistogramID::TELEMETRY_ARCHIVE_SESSION_PING_COUNT);
    }
    case 5728: { // telemetry.archive_size
      return Some(HistogramID::TELEMETRY_ARCHIVE_SIZE_MB);
    }
    case 5729: { // telemetry.compress
      return Some(HistogramID::TELEMETRY_COMPRESS);
    }
    case 5731: { // telemetry.discarded_archived_pings_size
      return Some(HistogramID::TELEMETRY_DISCARDED_ARCHIVED_PINGS_SIZE_MB);
    }
    case 5732: { // telemetry.discarded_pending_pings_size
      return Some(HistogramID::TELEMETRY_DISCARDED_PENDING_PINGS_SIZE_MB);
    }
    case 5733: { // telemetry.discarded_send_pings_size
      return Some(HistogramID::TELEMETRY_DISCARDED_SEND_PINGS_SIZE_MB);
    }
    case 5734: { // telemetry.event_ping_sent
      return Some(HistogramID::TELEMETRY_EVENT_PING_SENT);
    }
    case 5735: { // telemetry.event_recording_error
      return Some(HistogramID::TELEMETRY_EVENT_RECORDING_ERROR);
    }
    case 5736: { // telemetry.event_registration_error
      return Some(HistogramID::TELEMETRY_EVENT_REGISTRATION_ERROR);
    }
    case 5737: { // telemetry.invalid_payload_submitted
      return Some(HistogramID::TELEMETRY_INVALID_PAYLOAD_SUBMITTED);
    }
    case 5738: { // telemetry.invalid_ping_type_submitted
      return Some(HistogramID::TELEMETRY_INVALID_PING_TYPE_SUBMITTED);
    }
    case 5739: { // telemetry.pending_checking_over_quota
      return Some(HistogramID::TELEMETRY_PENDING_CHECKING_OVER_QUOTA_MS);
    }
    case 5740: { // telemetry.pending_evicting_over_quota
      return Some(HistogramID::TELEMETRY_PENDING_EVICTING_OVER_QUOTA_MS);
    }
    case 5741: { // telemetry.pending_load_failure_parse
      return Some(HistogramID::TELEMETRY_PENDING_LOAD_FAILURE_PARSE);
    }
    case 5742: { // telemetry.pending_load_failure_read
      return Some(HistogramID::TELEMETRY_PENDING_LOAD_FAILURE_READ);
    }
    case 5743: { // telemetry.pending_pings_age
      return Some(HistogramID::TELEMETRY_PENDING_PINGS_AGE);
    }
    case 5744: { // telemetry.pending_pings_evicted_over_quota
      return Some(HistogramID::TELEMETRY_PENDING_PINGS_EVICTED_OVER_QUOTA);
    }
    case 5745: { // telemetry.pending_pings_size
      return Some(HistogramID::TELEMETRY_PENDING_PINGS_SIZE_MB);
    }
    case 5746: { // telemetry.ping_evicted_for_server_errors
      return Some(HistogramID::TELEMETRY_PING_EVICTED_FOR_SERVER_ERRORS);
    }
    case 5747: { // telemetry.ping_size_exceeded_archived
      return Some(HistogramID::TELEMETRY_PING_SIZE_EXCEEDED_ARCHIVED);
    }
    case 5748: { // telemetry.ping_size_exceeded_pending
      return Some(HistogramID::TELEMETRY_PING_SIZE_EXCEEDED_PENDING);
    }
    case 5749: { // telemetry.ping_size_exceeded_send
      return Some(HistogramID::TELEMETRY_PING_SIZE_EXCEEDED_SEND);
    }
    case 5750: { // telemetry.ping_submission_waiting_clientid
      return Some(HistogramID::TELEMETRY_PING_SUBMISSION_WAITING_CLIENTID);
    }
    case 5751: { // telemetry.send_failure
      return Some(HistogramID::TELEMETRY_SEND_FAILURE);
    }
    case 5752: { // telemetry.send_failure_type
      return Some(HistogramID::TELEMETRY_SEND_FAILURE_TYPE);
    }
    case 5753: { // telemetry.send_failure_type_per_ping
      return Some(HistogramID::TELEMETRY_SEND_FAILURE_TYPE_PER_PING);
    }
    case 5754: { // telemetry.send_success
      return Some(HistogramID::TELEMETRY_SEND_SUCCESS);
    }
    case 5755: { // telemetry.stringify
      return Some(HistogramID::TELEMETRY_STRINGIFY);
    }
    case 5756: { // telemetry.success
      return Some(HistogramID::TELEMETRY_SUCCESS);
    }
    case 5779: { // thumbnails.capture_canvas_draw_time
      return Some(HistogramID::FX_THUMBNAILS_BG_CAPTURE_CANVAS_DRAW_TIME_MS);
    }
    case 5780: { // thumbnails.capture_done_reason_2
      return Some(HistogramID::FX_THUMBNAILS_BG_CAPTURE_DONE_REASON_2);
    }
    case 5781: { // thumbnails.capture_page_load_time
      return Some(HistogramID::FX_THUMBNAILS_BG_CAPTURE_PAGE_LOAD_TIME_MS);
    }
    case 5782: { // thumbnails.capture_queue_time
      return Some(HistogramID::FX_THUMBNAILS_BG_CAPTURE_QUEUE_TIME_MS);
    }
    case 5783: { // thumbnails.capture_time
      return Some(HistogramID::FX_THUMBNAILS_CAPTURE_TIME_MS);
    }
    case 5784: { // thumbnails.queue_size_on_capture
      return Some(HistogramID::FX_THUMBNAILS_BG_QUEUE_SIZE_ON_CAPTURE);
    }
    case 5785: { // thumbnails.store_time
      return Some(HistogramID::FX_THUMBNAILS_STORE_TIME_MS);
    }
    case 5831: { // urlclassifier.async_classifylocal_time
      return Some(HistogramID::URLCLASSIFIER_ASYNC_CLASSIFYLOCAL_TIME);
    }
    case 5832: { // urlclassifier.cl_check_time
      return Some(HistogramID::URLCLASSIFIER_CL_CHECK_TIME);
    }
    case 5833: { // urlclassifier.cl_keyed_update_time
      return Some(HistogramID::URLCLASSIFIER_CL_KEYED_UPDATE_TIME);
    }
    case 5834: { // urlclassifier.complete_remote_status2
      return Some(HistogramID::URLCLASSIFIER_COMPLETE_REMOTE_STATUS2);
    }
    case 5835: { // urlclassifier.complete_server_response_time
      return Some(HistogramID::URLCLASSIFIER_COMPLETE_SERVER_RESPONSE_TIME);
    }
    case 5836: { // urlclassifier.complete_timeout
      return Some(HistogramID::URLCLASSIFIER_COMPLETE_TIMEOUT2);
    }
    case 5838: { // urlclassifier.completion_error
      return Some(HistogramID::URLCLASSIFIER_COMPLETION_ERROR);
    }
    case 5841: { // urlclassifier.lookup_time_2
      return Some(HistogramID::URLCLASSIFIER_LOOKUP_TIME_2);
    }
    case 5842: { // urlclassifier.shutdown_time
      return Some(HistogramID::URLCLASSIFIER_SHUTDOWN_TIME);
    }
    case 5843: { // urlclassifier.threathit_network_error
      return Some(HistogramID::URLCLASSIFIER_THREATHIT_NETWORK_ERROR);
    }
    case 5844: { // urlclassifier.threathit_remote_status
      return Some(HistogramID::URLCLASSIFIER_THREATHIT_REMOTE_STATUS);
    }
    case 5845: { // urlclassifier.ui_events
      return Some(HistogramID::URLCLASSIFIER_UI_EVENTS);
    }
    case 5846: { // urlclassifier.update_error
      return Some(HistogramID::URLCLASSIFIER_UPDATE_ERROR);
    }
    case 5847: { // urlclassifier.update_remote_network_error
      return Some(HistogramID::URLCLASSIFIER_UPDATE_REMOTE_NETWORK_ERROR);
    }
    case 5848: { // urlclassifier.update_remote_status2
      return Some(HistogramID::URLCLASSIFIER_UPDATE_REMOTE_STATUS2);
    }
    case 5849: { // urlclassifier.update_server_response_time
      return Some(HistogramID::URLCLASSIFIER_UPDATE_SERVER_RESPONSE_TIME);
    }
    case 5850: { // urlclassifier.update_timeout
      return Some(HistogramID::URLCLASSIFIER_UPDATE_TIMEOUT);
    }
    case 5851: { // urlclassifier.vlps_construct_time
      return Some(HistogramID::URLCLASSIFIER_VLPS_CONSTRUCT_TIME);
    }
    case 5852: { // urlclassifier.vlps_fallocate_time
      return Some(HistogramID::URLCLASSIFIER_VLPS_FALLOCATE_TIME);
    }
    case 5853: { // urlclassifier.vlps_fileload_time
      return Some(HistogramID::URLCLASSIFIER_VLPS_FILELOAD_TIME);
    }
    case 5854: { // urlclassifier.vlps_metadata_corrupt
      return Some(HistogramID::URLCLASSIFIER_VLPS_METADATA_CORRUPT);
    }
    case 5881: { // region.fetch_result
      return Some(HistogramID::SEARCH_SERVICE_COUNTRY_FETCH_RESULT);
    }
    case 5882: { // region.fetch_time
      return Some(HistogramID::SEARCH_SERVICE_COUNTRY_FETCH_TIME_MS);
    }
    case 5893: { // newtab_page.blocked_sites_count
      return Some(HistogramID::NEWTAB_PAGE_BLOCKED_SITES_COUNT);
    }
    case 5894: { // newtab_page.pinned_sites_count
      return Some(HistogramID::NEWTAB_PAGE_PINNED_SITES_COUNT);
    }
    case 5895: { // popup_notification.dismissal
      return Some(HistogramID::POPUP_NOTIFICATION_DISMISSAL_MS);
    }
    case 5896: { // popup_notification.main_action
      return Some(HistogramID::POPUP_NOTIFICATION_MAIN_ACTION_MS);
    }
    case 5897: { // popup_notification.stats
      return Some(HistogramID::POPUP_NOTIFICATION_STATS);
    }
    case 6007: { // update.bits_result_complete
      return Some(HistogramID::UPDATE_BITS_RESULT_COMPLETE);
    }
    case 6008: { // update.bits_result_partial
      return Some(HistogramID::UPDATE_BITS_RESULT_PARTIAL);
    }
    case 6009: { // update.can_use_bits_external
      return Some(HistogramID::UPDATE_CAN_USE_BITS_EXTERNAL);
    }
    case 6010: { // update.can_use_bits_notify
      return Some(HistogramID::UPDATE_CAN_USE_BITS_NOTIFY);
    }
    case 6011: { // update.can_use_bits_subsequent
      return Some(HistogramID::UPDATE_CAN_USE_BITS_SUBSEQUENT);
    }
    case 6012: { // update.cannot_stage_external
      return Some(HistogramID::UPDATE_CANNOT_STAGE_EXTERNAL);
    }
    case 6013: { // update.cannot_stage_notify
      return Some(HistogramID::UPDATE_CANNOT_STAGE_NOTIFY);
    }
    case 6014: { // update.cannot_stage_subsequent
      return Some(HistogramID::UPDATE_CANNOT_STAGE_SUBSEQUENT);
    }
    case 6015: { // update.check_code_external
      return Some(HistogramID::UPDATE_CHECK_CODE_EXTERNAL);
    }
    case 6016: { // update.check_code_notify
      return Some(HistogramID::UPDATE_CHECK_CODE_NOTIFY);
    }
    case 6017: { // update.check_code_subsequent
      return Some(HistogramID::UPDATE_CHECK_CODE_SUBSEQUENT);
    }
    case 6018: { // update.check_extended_error_external
      return Some(HistogramID::UPDATE_CHECK_EXTENDED_ERROR_EXTERNAL);
    }
    case 6019: { // update.check_extended_error_notify
      return Some(HistogramID::UPDATE_CHECK_EXTENDED_ERROR_NOTIFY);
    }
    case 6020: { // update.check_extended_error_subsequent
      return Some(HistogramID::UPDATE_CHECK_EXTENDED_ERROR_SUBSEQUENT);
    }
    case 6021: { // update.check_no_update_external
      return Some(HistogramID::UPDATE_CHECK_NO_UPDATE_EXTERNAL);
    }
    case 6022: { // update.check_no_update_notify
      return Some(HistogramID::UPDATE_CHECK_NO_UPDATE_NOTIFY);
    }
    case 6023: { // update.check_no_update_subsequent
      return Some(HistogramID::UPDATE_CHECK_NO_UPDATE_SUBSEQUENT);
    }
    case 6024: { // update.download_code_complete
      return Some(HistogramID::UPDATE_DOWNLOAD_CODE_COMPLETE);
    }
    case 6025: { // update.download_code_partial
      return Some(HistogramID::UPDATE_DOWNLOAD_CODE_PARTIAL);
    }
    case 6026: { // update.download_code_unknown
      return Some(HistogramID::UPDATE_DOWNLOAD_CODE_UNKNOWN);
    }
    case 6027: { // update.invalid_lastupdatetime_external
      return Some(HistogramID::UPDATE_INVALID_LASTUPDATETIME_EXTERNAL);
    }
    case 6028: { // update.invalid_lastupdatetime_notify
      return Some(HistogramID::UPDATE_INVALID_LASTUPDATETIME_NOTIFY);
    }
    case 6029: { // update.invalid_lastupdatetime_subsequent
      return Some(HistogramID::UPDATE_INVALID_LASTUPDATETIME_SUBSEQUENT);
    }
    case 6030: { // update.langpack_overtime
      return Some(HistogramID::UPDATE_LANGPACK_OVERTIME);
    }
    case 6031: { // update.last_notify_interval_days_external
      return Some(HistogramID::UPDATE_LAST_NOTIFY_INTERVAL_DAYS_EXTERNAL);
    }
    case 6032: { // update.last_notify_interval_days_notify
      return Some(HistogramID::UPDATE_LAST_NOTIFY_INTERVAL_DAYS_NOTIFY);
    }
    case 6033: { // update.last_notify_interval_days_subsequent
      return Some(HistogramID::UPDATE_LAST_NOTIFY_INTERVAL_DAYS_SUBSEQUENT);
    }
    case 6034: { // update.not_pref_update_auto_external
      return Some(HistogramID::UPDATE_NOT_PREF_UPDATE_AUTO_EXTERNAL);
    }
    case 6035: { // update.not_pref_update_auto_notify
      return Some(HistogramID::UPDATE_NOT_PREF_UPDATE_AUTO_NOTIFY);
    }
    case 6036: { // update.not_pref_update_auto_subsequent
      return Some(HistogramID::UPDATE_NOT_PREF_UPDATE_AUTO_SUBSEQUENT);
    }
    case 6037: { // update.not_pref_update_service_enabled_external
      return Some(HistogramID::UPDATE_NOT_PREF_UPDATE_SERVICE_ENABLED_EXTERNAL);
    }
    case 6038: { // update.not_pref_update_service_enabled_notify
      return Some(HistogramID::UPDATE_NOT_PREF_UPDATE_SERVICE_ENABLED_NOTIFY);
    }
    case 6039: { // update.not_pref_update_service_enabled_subsequent
      return Some(HistogramID::UPDATE_NOT_PREF_UPDATE_SERVICE_ENABLED_SUBSEQUENT);
    }
    case 6040: { // update.not_pref_update_staging_enabled_external
      return Some(HistogramID::UPDATE_NOT_PREF_UPDATE_STAGING_ENABLED_EXTERNAL);
    }
    case 6041: { // update.not_pref_update_staging_enabled_notify
      return Some(HistogramID::UPDATE_NOT_PREF_UPDATE_STAGING_ENABLED_NOTIFY);
    }
    case 6042: { // update.not_pref_update_staging_enabled_subsequent
      return Some(HistogramID::UPDATE_NOT_PREF_UPDATE_STAGING_ENABLED_SUBSEQUENT);
    }
    case 6043: { // update.notification_badge_shown
      return Some(HistogramID::UPDATE_NOTIFICATION_BADGE_SHOWN);
    }
    case 6044: { // update.notification_dismissed
      return Some(HistogramID::UPDATE_NOTIFICATION_DISMISSED);
    }
    case 6045: { // update.notification_main_action_doorhanger
      return Some(HistogramID::UPDATE_NOTIFICATION_MAIN_ACTION_DOORHANGER);
    }
    case 6046: { // update.notification_main_action_menu
      return Some(HistogramID::UPDATE_NOTIFICATION_MAIN_ACTION_MENU);
    }
    case 6047: { // update.notification_shown
      return Some(HistogramID::UPDATE_NOTIFICATION_SHOWN);
    }
    case 6048: { // update.ping_count_external
      return Some(HistogramID::UPDATE_PING_COUNT_EXTERNAL);
    }
    case 6049: { // update.ping_count_notify
      return Some(HistogramID::UPDATE_PING_COUNT_NOTIFY);
    }
    case 6050: { // update.ping_count_subsequent
      return Some(HistogramID::UPDATE_PING_COUNT_SUBSEQUENT);
    }
    case 6051: { // update.pref_service_errors_external
      return Some(HistogramID::UPDATE_PREF_SERVICE_ERRORS_EXTERNAL);
    }
    case 6052: { // update.pref_service_errors_notify
      return Some(HistogramID::UPDATE_PREF_SERVICE_ERRORS_NOTIFY);
    }
    case 6053: { // update.pref_service_errors_subsequent
      return Some(HistogramID::UPDATE_PREF_SERVICE_ERRORS_SUBSEQUENT);
    }
    case 6054: { // update.pref_update_cancelations_external
      return Some(HistogramID::UPDATE_PREF_UPDATE_CANCELATIONS_EXTERNAL);
    }
    case 6055: { // update.pref_update_cancelations_notify
      return Some(HistogramID::UPDATE_PREF_UPDATE_CANCELATIONS_NOTIFY);
    }
    case 6056: { // update.pref_update_cancelations_subsequent
      return Some(HistogramID::UPDATE_PREF_UPDATE_CANCELATIONS_SUBSEQUENT);
    }
    case 6060: { // update.service_installed_external
      return Some(HistogramID::UPDATE_SERVICE_INSTALLED_EXTERNAL);
    }
    case 6061: { // update.service_installed_notify
      return Some(HistogramID::UPDATE_SERVICE_INSTALLED_NOTIFY);
    }
    case 6062: { // update.service_installed_subsequent
      return Some(HistogramID::UPDATE_SERVICE_INSTALLED_SUBSEQUENT);
    }
    case 6063: { // update.service_manually_uninstalled_external
      return Some(HistogramID::UPDATE_SERVICE_MANUALLY_UNINSTALLED_EXTERNAL);
    }
    case 6064: { // update.service_manually_uninstalled_notify
      return Some(HistogramID::UPDATE_SERVICE_MANUALLY_UNINSTALLED_NOTIFY);
    }
    case 6065: { // update.service_manually_uninstalled_subsequent
      return Some(HistogramID::UPDATE_SERVICE_MANUALLY_UNINSTALLED_SUBSEQUENT);
    }
    case 6066: { // update.state_code_complete_stage
      return Some(HistogramID::UPDATE_STATE_CODE_COMPLETE_STAGE);
    }
    case 6067: { // update.state_code_complete_startup
      return Some(HistogramID::UPDATE_STATE_CODE_COMPLETE_STARTUP);
    }
    case 6068: { // update.state_code_partial_stage
      return Some(HistogramID::UPDATE_STATE_CODE_PARTIAL_STAGE);
    }
    case 6069: { // update.state_code_partial_startup
      return Some(HistogramID::UPDATE_STATE_CODE_PARTIAL_STARTUP);
    }
    case 6070: { // update.state_code_unknown_stage
      return Some(HistogramID::UPDATE_STATE_CODE_UNKNOWN_STAGE);
    }
    case 6071: { // update.state_code_unknown_startup
      return Some(HistogramID::UPDATE_STATE_CODE_UNKNOWN_STARTUP);
    }
    case 6073: { // update.status_error_code_complete_stage
      return Some(HistogramID::UPDATE_STATUS_ERROR_CODE_COMPLETE_STAGE);
    }
    case 6074: { // update.status_error_code_complete_startup
      return Some(HistogramID::UPDATE_STATUS_ERROR_CODE_COMPLETE_STARTUP);
    }
    case 6075: { // update.status_error_code_partial_stage
      return Some(HistogramID::UPDATE_STATUS_ERROR_CODE_PARTIAL_STAGE);
    }
    case 6076: { // update.status_error_code_partial_startup
      return Some(HistogramID::UPDATE_STATUS_ERROR_CODE_PARTIAL_STARTUP);
    }
    case 6077: { // update.status_error_code_unknown_stage
      return Some(HistogramID::UPDATE_STATUS_ERROR_CODE_UNKNOWN_STAGE);
    }
    case 6078: { // update.status_error_code_unknown_startup
      return Some(HistogramID::UPDATE_STATUS_ERROR_CODE_UNKNOWN_STARTUP);
    }
    case 6083: { // update.unable_to_apply_external
      return Some(HistogramID::UPDATE_UNABLE_TO_APPLY_EXTERNAL);
    }
    case 6084: { // update.unable_to_apply_notify
      return Some(HistogramID::UPDATE_UNABLE_TO_APPLY_NOTIFY);
    }
    case 6085: { // update.unable_to_apply_subsequent
      return Some(HistogramID::UPDATE_UNABLE_TO_APPLY_SUBSEQUENT);
    }
    case 6105: { // gecko.safe_mode_usage
      return Some(HistogramID::SAFE_MODE_USAGE);
    }
    case 6112: { // widget.notify_idle
      return Some(HistogramID::IDLE_NOTIFY_IDLE_MS);
    }
    case 6116: { // widget.touch_enabled_device
      return Some(HistogramID::TOUCH_ENABLED_DEVICE);
    }
    case 6128: { // cycle_collector.async_snow_white_freeing
      return Some(HistogramID::CYCLE_COLLECTOR_ASYNC_SNOW_WHITE_FREEING);
    }
    case 6129: { // cycle_collector.collected
      return Some(HistogramID::CYCLE_COLLECTOR_COLLECTED);
    }
    case 6130: { // cycle_collector.deferred_finalize_async
      return Some(HistogramID::DEFERRED_FINALIZE_ASYNC);
    }
    case 6131: { // cycle_collector.finish_igc
      return Some(HistogramID::CYCLE_COLLECTOR_FINISH_IGC);
    }
    case 6132: { // cycle_collector.forget_skippable_max
      return Some(HistogramID::FORGET_SKIPPABLE_MAX);
    }
    case 6133: { // cycle_collector.full
      return Some(HistogramID::CYCLE_COLLECTOR_FULL);
    }
    case 6134: { // cycle_collector.max_pause
      return Some(HistogramID::CYCLE_COLLECTOR_MAX_PAUSE);
    }
    case 6135: { // cycle_collector.need_gc
      return Some(HistogramID::CYCLE_COLLECTOR_NEED_GC);
    }
    case 6136: { // cycle_collector.slice_during_idle
      return Some(HistogramID::CYCLE_COLLECTOR_SLICE_DURING_IDLE);
    }
    case 6137: { // cycle_collector.sync_skippable
      return Some(HistogramID::CYCLE_COLLECTOR_SYNC_SKIPPABLE);
    }
    case 6138: { // cycle_collector.time
      return Some(HistogramID::CYCLE_COLLECTOR);
    }
    case 6139: { // cycle_collector.time_between
      return Some(HistogramID::CYCLE_COLLECTOR_TIME_BETWEEN);
    }
    case 6140: { // cycle_collector.visited_gced
      return Some(HistogramID::CYCLE_COLLECTOR_VISITED_GCED);
    }
    case 6141: { // cycle_collector.visited_ref_counted
      return Some(HistogramID::CYCLE_COLLECTOR_VISITED_REF_COUNTED);
    }
    case 6142: { // cycle_collector.worker_collected
      return Some(HistogramID::CYCLE_COLLECTOR_WORKER_COLLECTED);
    }
    case 6143: { // cycle_collector.worker_need_gc
      return Some(HistogramID::CYCLE_COLLECTOR_WORKER_NEED_GC);
    }
    case 6144: { // cycle_collector.worker_time
      return Some(HistogramID::CYCLE_COLLECTOR_WORKER);
    }
    case 6145: { // cycle_collector.worker_visited_gced
      return Some(HistogramID::CYCLE_COLLECTOR_WORKER_VISITED_GCED);
    }
    case 6146: { // cycle_collector.worker_visited_ref_counted
      return Some(HistogramID::CYCLE_COLLECTOR_WORKER_VISITED_REF_COUNTED);
    }
    case 6147: { // event.longtask
      return Some(HistogramID::EVENT_LONGTASK);
    }
    case 6151: { // memory_phc.slop
      return Some(HistogramID::MEMORY_PHC_SLOP);
    }
    case 6152: { // memory_phc.slots_allocated
      return Some(HistogramID::MEMORY_PHC_SLOTS_ALLOCATED);
    }
    case 6153: { // memory_phc.slots_freed
      return Some(HistogramID::MEMORY_PHC_SLOTS_FREED);
    }
    default: {
      if (MOZ_UNLIKELY(aId & (1 << DYNAMIC_METRIC_BIT))) {
        // Dynamic (runtime-registered) metric. Use its static (compiletime-
        // registered) metric's telemetry_mirror mapping.
        // ...if applicable.

        // Only JS can use dynamic (runtime-registered) metric ids.
        MOZ_ASSERT(NS_IsMainThread());

        auto metricName = JOG::GetMetricName(aId);
        // All of these should have names, but the storage only lasts until
        // XPCOMWillShutdown, so it might return `Nothing()`.
        if (metricName.isSome()) {
          auto maybeMetric = MetricByNameLookup(metricName.ref());
          if (maybeMetric.isSome()) {
            uint32_t staticId = GLEAN_METRIC_ID(maybeMetric.value());
            // Let's ensure we don't infinite loop, huh.
            MOZ_ASSERT(!(staticId & (1 << DYNAMIC_METRIC_BIT)));
            return HistogramIdForMetric(staticId);
          }
        }
      }
      return Nothing();
    }
  }
}

}  // namespace mozilla::glean

#undef GLEAN_METRIC_ID
#undef DYNAMIC_METRIC_BIT
