// -*- mode: Rust -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

use crate::private::Ping;
use once_cell::sync::Lazy;

#[allow(non_upper_case_globals)]
/// This is a ping representing single events triggered by the messaging system
/// and captures some pings from About:Welcome, ASRouter, and other corners.
pub static messaging_system: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "messaging-system",
        false,
        false,
        true,
        true,
        true,
        vec![],
        vec![],
        true,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// Only used for telemetry that is sent from a profile created by restoring a
/// backup. This is in a separate ping specifically to avoid associating the
/// client id of the restored profile with the client ids of the backed up
/// profile and the profile that did the restoring.
pub static post_profile_restore: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "post-profile-restore",
        false,
        false,
        true,
        true,
        true,
        vec![],
        vec![],
        true,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// Only used for telemetry specific to restoring a profile from a backup. This
/// is necessary to ensure that we can unconditionally send it immediately when
/// we complete the restore since, if we don't, that profile may never be
/// launched again and then the telemetry would be lost.
/// Note that this only contains specifically the probes that have this
/// requirement. Any telemetry that is intended to be gathered regularly or
/// telemetry that is intended to be gathered in the new (post-restore) profile
/// will not be in this ping.
pub static profile_restore: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "profile-restore",
        true,
        false,
        true,
        true,
        true,
        vec![],
        vec![],
        true,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// Newtab-related instrumentation.
/// Can be disabled via the `browser.newtabpage.ping.enabled` pref.
pub static newtab: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "newtab",
        true,
        false,
        true,
        true,
        true,
        vec![],
        vec!["component_init".into(), "newtab_session_end".into()],
        true,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// Private Newtab-related instrumentation sent over OHTTP
/// Can be disabled via the `newtabPingEnabled` variable of the `glean` Nimbus
/// feature, or the `browser.newtabpage.ping.enabled` pref.
pub static newtab_content: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "newtab-content",
        false,
        false,
        true,
        false,
        true,
        vec![],
        vec!["component_init".into(), "newtab_session_end".into()],
        true,
        vec!["ohttp".into()],
    )
});

#[allow(non_upper_case_globals)]
/// A ping for submitting the pocket sponsored content's `shim`.
/// Does not contain a `client_id`.
pub static spoc: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "spoc",
        false,
        false,
        true,
        true,
        true,
        vec![],
        vec!["click".into(), "impression".into(), "save".into()],
        true,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// A ping representing a single event happening with or to a TopSite.
/// Distinguishable by its `ping_type`.
/// Does not contain a `client_id`, preferring a `context_id` instead.
pub static top_sites: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "top-sites",
        false,
        false,
        true,
        true,
        true,
        vec![],
        vec![],
        true,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// Instrumentation for the multiple profiles feature in desktop Firefox.
/// This separate ping is used to ensure we send all recorded profiles events
/// before deleting a profile.
pub static profiles: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "profiles",
        true,
        false,
        true,
        true,
        true,
        vec![],
        vec![],
        true,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// A ping representing a "This time, search with" event with a partner search.
/// Does not contain a `client_id`, preferring a `context_id` instead.
/// The `context_id` is used internally for counting unique sers as well as for
/// anti-fraud. It is shared with other Contextual Services. It is not shared
/// externally.
pub static search_with: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "search-with",
        false,
        false,
        true,
        true,
        true,
        vec![],
        vec![],
        true,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// A ping representing a series of SERP loads that have been categorized. Does
/// not contain `client_id`. Is sent after a threshold of SERP loads is reached.
pub static serp_categorization: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "serp-categorization",
        false,
        false,
        true,
        false,
        true,
        vec![],
        vec!["inactivity".into(), "startup".into(), "threshold_reached".into()],
        true,
        vec!["ohttp".into()],
    )
});

#[allow(non_upper_case_globals)]
/// A ping representing an impression, selection, or dismissmal of an AMP
/// suggestion. It contains metrics in the `quick_suggest` category. Its type is
/// defined in the `ping_type` metric. It does not contain a `client_id`,
/// preferring a `context_id` instead. `follows_collection_enabled` is set to
/// false because the ping is conditioned on Suggest and AMP suggestions being
/// enabled. It will be enabled when Suggest and AMP suggestions are enabled and
/// it will be disabled otherwise. When it becomes disabled, a separate
/// `quick-suggest-deletion-request` ping will be submitted.
pub static quick_suggest: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "quick-suggest",
        false,
        false,
        true,
        true,
        false,
        vec![],
        vec![],
        false,
        vec!["ohttp".into()],
    )
});

#[allow(non_upper_case_globals)]
/// This ping is submitted when either AMP suggestions or the entire Suggest
/// feature becomes disabled. Like the `quick-suggest` ping, it will contain a
/// `context_id` metric in the `quick_suggest` category.
pub static quick_suggest_deletion_request: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "quick-suggest-deletion-request",
        false,
        false,
        true,
        true,
        false,
        vec![],
        vec![],
        false,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// This ping is submitted only when urlbar keyword exposures are enabled. See
/// the `keywordExposureResults` urlbar Nimbus variable. When enabled, the ping
/// is submitted at the end of urlbar sessions during which one or more exposure
/// results are matched. (A "session" begins when the user focuses the urlbar
/// and ends with an engagement or abandonment.) Exposure results include all
/// results defined in the `exposureResults` variable. They also include the
/// "rust_exposure" result type if the `quickSuggestDynamicSuggestionTypes`
/// variable is defined with a value that includes any hidden-exposure
/// suggestion types. The ping will contain one `urlbar.keyword_exposure` event
/// for each instance where a result is matched during the session. The ping is
/// not submitted for sessions in private windows.
pub static urlbar_keyword_exposure: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "urlbar-keyword-exposure",
        false,
        false,
        true,
        true,
        true,
        vec![],
        vec![],
        true,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// Instrumentation related to the data-leak-blocker built-in add-on.
pub static data_leak_blocker: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "data-leak-blocker",
        true,
        false,
        true,
        true,
        true,
        vec![],
        vec![],
        true,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// This ping is submitted when a context ID has been rotated. A rotation may
/// occur because a user has disabled a surface that uses the context ID, or
/// because the context ID age has exceeded some threshold.
pub static context_id_deletion_request: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "context-id-deletion-request",
        false,
        true,
        true,
        false,
        false,
        vec![],
        vec![],
        false,
        vec!["ohttp".into()],
    )
});

#[allow(non_upper_case_globals)]
/// **Prototype-only ping not for general use!**
/// Transport for no-code Firefox Desktop frontend instrumentation,
/// should mostly contain no-code events in browser.ui.* categories.
/// Submitted whenever the next flow of events begins (including startup).
pub static prototype_no_code_events: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "prototype-no-code-events",
        true,
        false,
        true,
        true,
        false,
        vec![],
        vec![],
        true,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// Non sensitive instrumentation collected during a page load.
pub static pageload: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "pageload",
        false,
        false,
        true,
        true,
        true,
        vec![],
        vec!["startup".into(), "threshold".into()],
        true,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// Page load instrumentation that includes etld+1.  Sent with ohttp.
pub static pageload_base_domain: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "pageload-base-domain",
        false,
        false,
        true,
        false,
        true,
        vec![],
        vec!["pageload".into()],
        true,
        vec!["ohttp".into()],
    )
});

#[allow(non_upper_case_globals)]
/// Collects counts of uses of web platform features.
/// See [Use Counters Documentation](https://firefox-source-docs.mozilla.org/dom/use-counters.html)
/// for more information.
pub static use_counters: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "use-counters",
        true,
        false,
        true,
        true,
        true,
        vec![],
        vec!["app_shutdown_confirmed".into(), "idle_startup".into()],
        true,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// A ping containing information about unexpected script loads in the parent
/// process. Events in this ping contain Category 3/4 data, so we disassociate
/// it from other telemetry pings.
pub static unexpected_script_load: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "unexpected-script-load",
        false,
        false,
        true,
        false,
        true,
        vec![],
        vec![],
        true,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// A ping representing Local Network Access (LNA) connection attempts and
/// permission prompt interactions. This ping does not include client_id for
/// privacy. Only collected in early Beta and Nightly builds.
pub static local_network_access: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "local-network-access",
        false,
        false,
        true,
        false,
        true,
        vec![],
        vec![],
        true,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// A ping for information about Mozilla Account usage. Sent at the same cadence
/// as the baseline ping.
pub static fx_accounts: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "fx-accounts",
        true,
        false,
        true,
        true,
        true,
        vec![],
        vec!["active".into(), "dirty_startup".into(), "inactive".into()],
        true,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// This is an aggregated format that contains information about each sync that
/// occurred during a timeframe.
/// It is submitted every 12 hours, and on browser shutdown,
/// but only if the syncs property would not be empty.
/// 
/// Each item in the `syncs` property is generated after a sync is completed,
/// for both successful and failed syncs,
/// and contains measurements pertaining to sync performance and error
/// information.
pub static sync: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "sync",
        false,
        false,
        true,
        true,
        true,
        vec![],
        vec!["idchanged".into(), "schedule".into(), "shutdown".into()],
        true,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// A ping representing Bounce Tracking Protection stats.  Note that this
/// ping does not include client_id.  More details are available in Bug 1889444
pub static bounce_tracking_protection: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "bounce-tracking-protection",
        false,
        false,
        true,
        false,
        true,
        vec![],
        vec![],
        true,
        vec!["ohttp".into()],
    )
});

#[allow(non_upper_case_globals)]
/// This ping is used to report when BackgroundHangReporter has detected that
/// the browser was unresponsive.
/// BackgroundHangReporter is only enabled for pre-release channels (currently
/// only on Nightly), and only on specific threads (main, renderer).
/// Whenever a runnable starts being processed on the event loop, BHR starts a
/// 128ms timer. If the runnable finishes quickly enough and execution returns
/// to the event loop before the timer fired, the timer is canceled.
/// When the timer fires, the execution is paused and a profiler stack is
/// captured. These stacks contain native frames (which need to be symbolicated
/// to become readable), label frames, and JavaScript frame, giving detailed
/// information about what was on the stack at the time the timer fired.
/// Once the stack has been recorded, execution resumes, and the total time it
/// took to finish the hanging task and return to the event loop is recorded.
/// If the execution didn't return to the event loop after 8 seconds, we assume
/// we have a 'perma-hang' that we will not be able to recover from, and record
/// the duration as 8 seconds.
/// Stack are sanitized to not reveal any information about remote content.
/// Pings are submitted daily when idle, during clean shutdowns or when 50
/// reports have been accumulated.
pub static hang_report: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "hang-report",
        true,
        false,
        true,
        true,
        true,
        vec![],
        vec![],
        true,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// This ping is generic for background tasks. Each background task can
/// gather its metrics under this ping and submit it when the task finishes.
/// Note that the ping submission must be done manually.
pub static background_tasks: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "background-tasks",
        false,
        false,
        true,
        true,
        true,
        vec![],
        vec![],
        true,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// This ping is used to analyze the occurrence of CAPTCHAs in the wild
/// by users' protection settings.
pub static captcha_detection: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "captcha-detection",
        true,
        false,
        true,
        true,
        true,
        vec![],
        vec![],
        true,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// A ping to report crash information. This information is sent as soon as possible after a crash occurs (whether the crash is a background/content process or the main process). It is expected to be used for crash report analysis and to reduce blind spots in crash reporting.
pub static crash: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "crash",
        true,
        false,
        true,
        true,
        true,
        vec![],
        vec!["crash".into(), "event_found".into()],
        true,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// A telemetry ping that transmits distributed tracing data collected during Firefox browser operation from the gecko-trace component. This ping contains OpenTelemetry-compatible spans, events, and their associated attributes captured by the GeckoTrace instrumentation component.
pub static gecko_trace: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "gecko-trace",
        false,
        false,
        true,
        true,
        true,
        vec![],
        vec!["buffer_full".into(), "idle".into(), "shutdown".into()],
        true,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// Minimal ping to measure DAU.
/// Sent on the baseline schedule.
/// 
/// **NOTE**: This ping is deprecated and replaced by the `usage-reporting` ping.
pub static dau_reporting: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "dau-reporting",
        false,
        true,
        true,
        true,
        true,
        vec![],
        vec!["active".into(), "dirty_startup".into(), "inactive".into()],
        true,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// Minimal ping sent immediately before Glean SDK initialization to measure
/// initial state of FOG storages and other particulars about the FOG setup.
pub static temp_fog_initial_state: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "temp-fog-initial-state",
        true,
        true,
        true,
        true,
        true,
        vec![],
        vec!["startup".into()],
        true,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// This ping is for tests only.
pub static collection_disabled_ping: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "collection-disabled-ping",
        false,
        true,
        true,
        true,
        false,
        vec![],
        vec![],
        false,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// This ping is for tests only.
pub static disabled_ping: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "disabled-ping",
        false,
        true,
        true,
        true,
        false,
        vec![],
        vec![],
        true,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// This ping is for tests only.
pub static one_ping_only: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "one-ping-only",
        false,
        true,
        true,
        true,
        true,
        vec![],
        vec![],
        true,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// This ping is for tests only.
pub static ride_along_ping: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "ride-along-ping",
        false,
        true,
        true,
        true,
        true,
        vec![],
        vec![],
        true,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// This ping is for tests only.
/// Resembles how OHTTP pings are defined.
pub static test_ohttp_ping: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "test-ohttp-ping",
        false,
        true,
        true,
        false,
        true,
        vec![],
        vec![],
        true,
        vec!["ohttp".into()],
    )
});

#[allow(non_upper_case_globals)]
/// This ping is for tests only.
pub static test_ping: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "test-ping",
        false,
        true,
        true,
        true,
        true,
        vec!["ride-along-ping".into()],
        vec![],
        true,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// Reports the user's response to a Firefox Heartbeat survey,
/// after the survey is complete.
/// ("response" includes ignoring or abandoning the survey.)
pub static heartbeat: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "heartbeat",
        true,
        false,
        true,
        true,
        true,
        vec![],
        vec![],
        true,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// Sent by Nimbus during every experiment update cycle.
pub static nimbus_targeting_context: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "nimbus-targeting-context",
        true,
        false,
        true,
        true,
        true,
        vec![],
        vec![],
        true,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// A ping containing the data for a user-initiated report for a broken site.
/// Does not contain a `client_id`. All report data is self-contained.
pub static broken_site_report: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "broken-site-report",
        false,
        false,
        true,
        true,
        true,
        vec![],
        vec![],
        true,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// A ping representing user hardware and software settings.  Note that this
/// ping does not include client_id.  More details are available in Bug 1879151
pub static user_characteristics: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "user-characteristics",
        false,
        false,
        true,
        false,
        true,
        vec![],
        vec![],
        true,
        vec!["ohttp".into()],
    )
});

#[allow(non_upper_case_globals)]
/// This ping is submitted when a user opts out of sending Firefox
/// technical and usage telemetry to Mozilla specifically during
/// preonboarding.  (After preonboarding, opting out of sending
/// technical and usage telemetry triggers a `deletion-request` ping.)
/// Sent in response to user action.
pub static onboarding_opt_out: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "onboarding-opt-out",
        false,
        true,
        true,
        false,
        false,
        vec![],
        vec!["set_upload_enabled".into()],
        false,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// Details about where, when, and how third-party modules were loaded into
/// Firefox processes.
/// Windows only.
pub static third_party_modules: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "third-party-modules",
        true,
        false,
        true,
        true,
        true,
        vec![],
        vec![],
        true,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// This ping is submitted when a user opts out of sending usage
/// frequency of Firefox to Mozilla.
/// Sent in response to user action.
pub static usage_deletion_request: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "usage-deletion-request",
        false,
        true,
        true,
        false,
        false,
        vec![],
        vec!["set_upload_enabled".into()],
        false,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// Minimal ping to measure the usage frequency of Firefox.
/// Sent on the baseline schedule.
pub static usage_reporting: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "usage-reporting",
        false,
        true,
        true,
        false,
        false,
        vec![],
        vec!["active".into(), "dirty_startup".into(), "inactive".into()],
        false,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// Sent during startup if Firefox was launched by the installer.
pub static first_startup: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "first-startup",
        true,
        false,
        true,
        true,
        true,
        vec![],
        vec![],
        true,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// This opt-out ping is sent from the Default Agent, which is a Windows-only Firefox Background Task that is registered during Firefox installation with the Windows scheduled tasks system so that it runs automatically every 24 hours, whether Firefox is running or not.
/// Opting out of telemetry is handled via the pref value being copied to the registry so that the Default Agent can read it without needing to work with profiles. Relevant policies are consulted as well. The agent also has its own pref, `default-agent.enabled`, which if set to false disables all agent functionality, including generating this ping.
/// Each installation of Firefox has its own copy of the agent and its own scheduled task which shares a common `LastPingSentAt` user registry key with other installations. Installations race to send a single ping per 24 hour window per installing user. If multiple operating system-level users are all using one copy of Firefox, only one scheduled task will have been created and only one ping will be sent, even though the users might have different default browser settings. If multiple users have installed Firefox then each installing user will have a scheduled task and ping.
/// Additional information for the Default Agent can be found in the [Default Browser Agent docs](https://firefox-source-docs.mozilla.org/toolkit/mozapps/defaultagent/default-browser-agent/index.html).
pub static default_agent: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "default-agent",
        false,
        false,
        true,
        true,
        true,
        vec![],
        vec!["daily_ping".into()],
        true,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// Instrumentation related to the list of add-ons managed by the AddonManager.
pub static addons: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "addons",
        true,
        false,
        true,
        true,
        true,
        vec![],
        vec!["daily".into(), "startup".into(), "updated".into()],
        true,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// This ping measures the technical health of the background update system.
/// Said system downloads and processes updates when Firefox is not running.  It
/// is expected that this ping will be analyzed by humans to gain confidence in
/// the implementation as the staged rollout of the system proceeds to the
/// release channel, before settling into an automated analysis to detect spikes
/// in background update failure rates.  This ping will also help to
/// characterize the update-related settings of our user population.
/// 
/// Right now the background update system, and therefore this ping, is
/// restricted to Windows.
/// 
/// This ping is submitted only by the background update task.  It should be
/// submitted once per background update task invocation.  The expected schedule
/// is every 7 hours, controlled by the pref `app.update.background.interval`,
/// and subject to scheduling decisions made by the OS.
pub static background_update: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "background-update",
        true,
        false,
        true,
        true,
        true,
        vec![],
        vec!["backgroundupdate_task".into()],
        true,
        vec![],
    )
});

#[allow(non_upper_case_globals)]
/// This ping is sent from Firefox Desktop when a browser update is ready
/// to be applied and after it was correctly applied.
/// 
/// Specific expected behaviours include:
///   - **The ping is generated once every time an update is downloaded, after it was verified:**
///     - *for users who saw the privacy policy*,
///       the ``update`` ping is sent immediately;
///     - *for users who did not see the privacy policy*,
///       the ``update`` ping is saved to disk and sent after the policy is displayed.
///   - **If the download of the update retries or other fallback occurs**:
///     the ``update`` ping will not be generated multiple times,
///     but only one time once the download is complete and verified.
///   - **If automatic updates are disabled**:
///     when the user forces a manual update, no ``update`` ping will be generated.
///   - **If updates fail to apply**:
///     in some cases the client will download the same update blob and generate a new
///     ``update`` ping for the same target version and build id, with a different document id.
///   - **If the build update channel contains the CCK keyword**,
///     the update ping will not report it but rather report a vanilla channel name
///     (e.g. ``mozilla-cck-test-beta`` gets reported as ``beta``).
///   - **If a profile refresh occurs before the update is applied**,
///     the update ping with ``reason = success`` will not be generated.
///   - **If the update is applied on a new profile, different then the one it was downloaded in**,
///     the update ping with ``reason = success`` will not be generated.
///   - **If a newer browser version is installed over an older**,
///     the update ping with ``reason = success`` will not be generated.
pub static update: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "update",
        true,
        false,
        true,
        true,
        true,
        vec![],
        vec!["ready".into(), "success".into()],
        true,
        vec![],
    )
});


/// Instantiate custom pings once to trigger registration.
///
/// # Arguments
///
/// application_id: If present, limit to only registering custom pings
///                 assigned to the identified application.
#[doc(hidden)]
pub fn register_pings(application_id: Option<&str>) {
    match application_id {
        Some("firefox.desktop") => {
            log::info!("Registering pings addons, bounce-tracking-protection, broken-site-report, captcha-detection, collection-disabled-ping, context-id-deletion-request, crash, data-leak-blocker, dau-reporting, disabled-ping, first-startup, fx-accounts, gecko-trace, hang-report, heartbeat, local-network-access, messaging-system, newtab, newtab-content, nimbus-targeting-context, onboarding-opt-out, one-ping-only, pageload, pageload-base-domain, post-profile-restore, profile-restore, profiles, prototype-no-code-events, quick-suggest, quick-suggest-deletion-request, ride-along-ping, search-with, serp-categorization, spoc, sync, temp-fog-initial-state, test-ohttp-ping, test-ping, third-party-modules, top-sites, unexpected-script-load, update, urlbar-keyword-exposure, usage-deletion-request, usage-reporting, use-counters, user-characteristics for firefox.desktop");
            let _ = &*addons;
            let _ = &*bounce_tracking_protection;
            let _ = &*broken_site_report;
            let _ = &*captcha_detection;
            let _ = &*collection_disabled_ping;
            let _ = &*context_id_deletion_request;
            let _ = &*crash;
            let _ = &*data_leak_blocker;
            let _ = &*dau_reporting;
            let _ = &*disabled_ping;
            let _ = &*first_startup;
            let _ = &*fx_accounts;
            let _ = &*gecko_trace;
            let _ = &*hang_report;
            let _ = &*heartbeat;
            let _ = &*local_network_access;
            let _ = &*messaging_system;
            let _ = &*newtab;
            let _ = &*newtab_content;
            let _ = &*nimbus_targeting_context;
            let _ = &*onboarding_opt_out;
            let _ = &*one_ping_only;
            let _ = &*pageload;
            let _ = &*pageload_base_domain;
            let _ = &*post_profile_restore;
            let _ = &*profile_restore;
            let _ = &*profiles;
            let _ = &*prototype_no_code_events;
            let _ = &*quick_suggest;
            let _ = &*quick_suggest_deletion_request;
            let _ = &*ride_along_ping;
            let _ = &*search_with;
            let _ = &*serp_categorization;
            let _ = &*spoc;
            let _ = &*sync;
            let _ = &*temp_fog_initial_state;
            let _ = &*test_ohttp_ping;
            let _ = &*test_ping;
            let _ = &*third_party_modules;
            let _ = &*top_sites;
            let _ = &*unexpected_script_load;
            let _ = &*update;
            let _ = &*urlbar_keyword_exposure;
            let _ = &*usage_deletion_request;
            let _ = &*usage_reporting;
            let _ = &*use_counters;
            let _ = &*user_characteristics;
        },
        Some("firefox.desktop.background.update") => {
            log::info!("Registering pings addons, background-update, bounce-tracking-protection, captcha-detection, collection-disabled-ping, crash, dau-reporting, disabled-ping, gecko-trace, hang-report, local-network-access, one-ping-only, pageload, pageload-base-domain, ride-along-ping, temp-fog-initial-state, test-ohttp-ping, test-ping, update, use-counters, user-characteristics for firefox.desktop.background.update");
            let _ = &*addons;
            let _ = &*background_update;
            let _ = &*bounce_tracking_protection;
            let _ = &*captcha_detection;
            let _ = &*collection_disabled_ping;
            let _ = &*crash;
            let _ = &*dau_reporting;
            let _ = &*disabled_ping;
            let _ = &*gecko_trace;
            let _ = &*hang_report;
            let _ = &*local_network_access;
            let _ = &*one_ping_only;
            let _ = &*pageload;
            let _ = &*pageload_base_domain;
            let _ = &*ride_along_ping;
            let _ = &*temp_fog_initial_state;
            let _ = &*test_ohttp_ping;
            let _ = &*test_ping;
            let _ = &*update;
            let _ = &*use_counters;
            let _ = &*user_characteristics;
        },
        Some("firefox.desktop.background.tasks") => {
            log::info!("Registering pings addons, background-tasks, bounce-tracking-protection, captcha-detection, crash, dau-reporting, default-agent, gecko-trace, hang-report, heartbeat, local-network-access, nimbus-targeting-context, pageload, pageload-base-domain, temp-fog-initial-state, use-counters, user-characteristics for firefox.desktop.background.tasks");
            let _ = &*addons;
            let _ = &*background_tasks;
            let _ = &*bounce_tracking_protection;
            let _ = &*captcha_detection;
            let _ = &*crash;
            let _ = &*dau_reporting;
            let _ = &*default_agent;
            let _ = &*gecko_trace;
            let _ = &*hang_report;
            let _ = &*heartbeat;
            let _ = &*local_network_access;
            let _ = &*nimbus_targeting_context;
            let _ = &*pageload;
            let _ = &*pageload_base_domain;
            let _ = &*temp_fog_initial_state;
            let _ = &*use_counters;
            let _ = &*user_characteristics;
        },
        Some("gecko") => {
            log::info!("Registering pings addons, bounce-tracking-protection, captcha-detection, collection-disabled-ping, dau-reporting, disabled-ping, gecko-trace, hang-report, local-network-access, one-ping-only, pageload, pageload-base-domain, ride-along-ping, temp-fog-initial-state, test-ohttp-ping, test-ping, use-counters, user-characteristics for gecko");
            let _ = &*addons;
            let _ = &*bounce_tracking_protection;
            let _ = &*captcha_detection;
            let _ = &*collection_disabled_ping;
            let _ = &*dau_reporting;
            let _ = &*disabled_ping;
            let _ = &*gecko_trace;
            let _ = &*hang_report;
            let _ = &*local_network_access;
            let _ = &*one_ping_only;
            let _ = &*pageload;
            let _ = &*pageload_base_domain;
            let _ = &*ride_along_ping;
            let _ = &*temp_fog_initial_state;
            let _ = &*test_ohttp_ping;
            let _ = &*test_ping;
            let _ = &*use_counters;
            let _ = &*user_characteristics;
        },
        _ => {
            let _ = &*messaging_system;
            let _ = &*post_profile_restore;
            let _ = &*profile_restore;
            let _ = &*newtab;
            let _ = &*newtab_content;
            let _ = &*spoc;
            let _ = &*top_sites;
            let _ = &*profiles;
            let _ = &*search_with;
            let _ = &*serp_categorization;
            let _ = &*quick_suggest;
            let _ = &*quick_suggest_deletion_request;
            let _ = &*urlbar_keyword_exposure;
            let _ = &*data_leak_blocker;
            let _ = &*context_id_deletion_request;
            let _ = &*prototype_no_code_events;
            let _ = &*pageload;
            let _ = &*pageload_base_domain;
            let _ = &*use_counters;
            let _ = &*unexpected_script_load;
            let _ = &*local_network_access;
            let _ = &*fx_accounts;
            let _ = &*sync;
            let _ = &*bounce_tracking_protection;
            let _ = &*hang_report;
            let _ = &*background_tasks;
            let _ = &*captcha_detection;
            let _ = &*crash;
            let _ = &*gecko_trace;
            let _ = &*dau_reporting;
            let _ = &*temp_fog_initial_state;
            let _ = &*collection_disabled_ping;
            let _ = &*disabled_ping;
            let _ = &*one_ping_only;
            let _ = &*ride_along_ping;
            let _ = &*test_ohttp_ping;
            let _ = &*test_ping;
            let _ = &*heartbeat;
            let _ = &*nimbus_targeting_context;
            let _ = &*broken_site_report;
            let _ = &*user_characteristics;
            let _ = &*onboarding_opt_out;
            let _ = &*third_party_modules;
            let _ = &*usage_deletion_request;
            let _ = &*usage_reporting;
            let _ = &*first_startup;
            let _ = &*default_agent;
            let _ = &*addons;
            let _ = &*background_update;
            let _ = &*update;
        }
    }
    extern "C" {
        fn JOG_MaybeReload();
    }
    unsafe {
      JOG_MaybeReload();
    }
}

/// Map from pings to the pings scheduled along with them.
///
#[doc(hidden)]
pub fn ping_schedule() -> std::collections::HashMap<String, Vec<String>> {
  std::collections::HashMap::from([
      (
        "baseline".into(),
        vec!["fx-accounts".into(), "usage-reporting".into()]
      ),
      (
        "test-ping".into(),
        vec!["ride-along-ping".into()]
      ),
  ])
}

#[cfg(feature = "with_gecko")]
pub(crate) fn submit_ping_by_id(id: u32, reason: Option<&str>) {
    if id & (1 << crate::factory::DYNAMIC_PING_BIT) > 0 {
        let map = crate::factory::__jog_metric_maps::PING_MAP
            .read()
            .expect("Read lock for dynamic ping map was poisoned!");
        if let Some(ping) = map.get(&id) {
            ping.submit(reason);
        } else {
            // TODO: instrument this error.
            log::error!("Cannot submit unknown dynamic ping {} by id.", id);
        }
        return;
    }
    match id {
        1 => messaging_system.submit(reason),
        2 => post_profile_restore.submit(reason),
        3 => profile_restore.submit(reason),
        4 => newtab.submit(reason),
        5 => newtab_content.submit(reason),
        6 => spoc.submit(reason),
        7 => top_sites.submit(reason),
        8 => profiles.submit(reason),
        9 => search_with.submit(reason),
        10 => serp_categorization.submit(reason),
        11 => quick_suggest.submit(reason),
        12 => quick_suggest_deletion_request.submit(reason),
        13 => urlbar_keyword_exposure.submit(reason),
        14 => data_leak_blocker.submit(reason),
        15 => context_id_deletion_request.submit(reason),
        16 => prototype_no_code_events.submit(reason),
        17 => pageload.submit(reason),
        18 => pageload_base_domain.submit(reason),
        19 => use_counters.submit(reason),
        20 => unexpected_script_load.submit(reason),
        21 => local_network_access.submit(reason),
        22 => fx_accounts.submit(reason),
        23 => sync.submit(reason),
        24 => bounce_tracking_protection.submit(reason),
        25 => hang_report.submit(reason),
        26 => background_tasks.submit(reason),
        27 => captcha_detection.submit(reason),
        28 => crash.submit(reason),
        29 => gecko_trace.submit(reason),
        30 => dau_reporting.submit(reason),
        31 => temp_fog_initial_state.submit(reason),
        32 => collection_disabled_ping.submit(reason),
        33 => disabled_ping.submit(reason),
        34 => one_ping_only.submit(reason),
        35 => ride_along_ping.submit(reason),
        36 => test_ohttp_ping.submit(reason),
        37 => test_ping.submit(reason),
        38 => heartbeat.submit(reason),
        39 => nimbus_targeting_context.submit(reason),
        40 => broken_site_report.submit(reason),
        41 => user_characteristics.submit(reason),
        42 => onboarding_opt_out.submit(reason),
        43 => third_party_modules.submit(reason),
        44 => usage_deletion_request.submit(reason),
        45 => usage_reporting.submit(reason),
        46 => first_startup.submit(reason),
        47 => default_agent.submit(reason),
        48 => addons.submit(reason),
        49 => background_update.submit(reason),
        50 => update.submit(reason),
        _ => {
            // TODO: instrument this error.
            log::error!("Cannot submit unknown ping {} by id.", id);
        }
    }
}

#[cfg(feature = "with_gecko")]
pub(crate) fn set_ping_enabled_by_id(id: u32, enabled: bool) {
    if id & (1 << crate::factory::DYNAMIC_PING_BIT) > 0 {
        let map = crate::factory::__jog_metric_maps::PING_MAP
            .read()
            .expect("Read lock for dynamic ping map was poisoned!");
        if let Some(ping) = map.get(&id) {
            ping.set_enabled(enabled);
        } else {
            // TODO: instrument this error.
            log::error!("Cannot set_enabled on unknown dynamic ping {} by id.", id);
        }
        return;
    }
    match id {
        1 => messaging_system.set_enabled(enabled),
        2 => post_profile_restore.set_enabled(enabled),
        3 => profile_restore.set_enabled(enabled),
        4 => newtab.set_enabled(enabled),
        5 => newtab_content.set_enabled(enabled),
        6 => spoc.set_enabled(enabled),
        7 => top_sites.set_enabled(enabled),
        8 => profiles.set_enabled(enabled),
        9 => search_with.set_enabled(enabled),
        10 => serp_categorization.set_enabled(enabled),
        11 => quick_suggest.set_enabled(enabled),
        12 => quick_suggest_deletion_request.set_enabled(enabled),
        13 => urlbar_keyword_exposure.set_enabled(enabled),
        14 => data_leak_blocker.set_enabled(enabled),
        15 => context_id_deletion_request.set_enabled(enabled),
        16 => prototype_no_code_events.set_enabled(enabled),
        17 => pageload.set_enabled(enabled),
        18 => pageload_base_domain.set_enabled(enabled),
        19 => use_counters.set_enabled(enabled),
        20 => unexpected_script_load.set_enabled(enabled),
        21 => local_network_access.set_enabled(enabled),
        22 => fx_accounts.set_enabled(enabled),
        23 => sync.set_enabled(enabled),
        24 => bounce_tracking_protection.set_enabled(enabled),
        25 => hang_report.set_enabled(enabled),
        26 => background_tasks.set_enabled(enabled),
        27 => captcha_detection.set_enabled(enabled),
        28 => crash.set_enabled(enabled),
        29 => gecko_trace.set_enabled(enabled),
        30 => dau_reporting.set_enabled(enabled),
        31 => temp_fog_initial_state.set_enabled(enabled),
        32 => collection_disabled_ping.set_enabled(enabled),
        33 => disabled_ping.set_enabled(enabled),
        34 => one_ping_only.set_enabled(enabled),
        35 => ride_along_ping.set_enabled(enabled),
        36 => test_ohttp_ping.set_enabled(enabled),
        37 => test_ping.set_enabled(enabled),
        38 => heartbeat.set_enabled(enabled),
        39 => nimbus_targeting_context.set_enabled(enabled),
        40 => broken_site_report.set_enabled(enabled),
        41 => user_characteristics.set_enabled(enabled),
        42 => onboarding_opt_out.set_enabled(enabled),
        43 => third_party_modules.set_enabled(enabled),
        44 => usage_deletion_request.set_enabled(enabled),
        45 => usage_reporting.set_enabled(enabled),
        46 => first_startup.set_enabled(enabled),
        47 => default_agent.set_enabled(enabled),
        48 => addons.set_enabled(enabled),
        49 => background_update.set_enabled(enabled),
        50 => update.set_enabled(enabled),
        _ => {
            // TODO: instrument this error.
            log::error!("Cannot set_enabled on unknown ping {} by id.", id);
        }
    }
}

/// Measure the allocation size of all known pings.
#[doc(hidden)]
pub fn fog_ping_alloc_size(ops: &mut malloc_size_of::MallocSizeOfOps) -> usize {
  use malloc_size_of::MallocSizeOf;

  let mut n = 0;
  n += messaging_system.size_of(ops);
  n += post_profile_restore.size_of(ops);
  n += profile_restore.size_of(ops);
  n += newtab.size_of(ops);
  n += newtab_content.size_of(ops);
  n += spoc.size_of(ops);
  n += top_sites.size_of(ops);
  n += profiles.size_of(ops);
  n += search_with.size_of(ops);
  n += serp_categorization.size_of(ops);
  n += quick_suggest.size_of(ops);
  n += quick_suggest_deletion_request.size_of(ops);
  n += urlbar_keyword_exposure.size_of(ops);
  n += data_leak_blocker.size_of(ops);
  n += context_id_deletion_request.size_of(ops);
  n += prototype_no_code_events.size_of(ops);
  n += pageload.size_of(ops);
  n += pageload_base_domain.size_of(ops);
  n += use_counters.size_of(ops);
  n += unexpected_script_load.size_of(ops);
  n += local_network_access.size_of(ops);
  n += fx_accounts.size_of(ops);
  n += sync.size_of(ops);
  n += bounce_tracking_protection.size_of(ops);
  n += hang_report.size_of(ops);
  n += background_tasks.size_of(ops);
  n += captcha_detection.size_of(ops);
  n += crash.size_of(ops);
  n += gecko_trace.size_of(ops);
  n += dau_reporting.size_of(ops);
  n += temp_fog_initial_state.size_of(ops);
  n += collection_disabled_ping.size_of(ops);
  n += disabled_ping.size_of(ops);
  n += one_ping_only.size_of(ops);
  n += ride_along_ping.size_of(ops);
  n += test_ohttp_ping.size_of(ops);
  n += test_ping.size_of(ops);
  n += heartbeat.size_of(ops);
  n += nimbus_targeting_context.size_of(ops);
  n += broken_site_report.size_of(ops);
  n += user_characteristics.size_of(ops);
  n += onboarding_opt_out.size_of(ops);
  n += third_party_modules.size_of(ops);
  n += usage_deletion_request.size_of(ops);
  n += usage_reporting.size_of(ops);
  n += first_startup.size_of(ops);
  n += default_agent.size_of(ops);
  n += addons.size_of(ops);
  n += background_update.size_of(ops);
  n += update.size_of(ops);
  n
}
