/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* Generated with cbindgen:0.29.2 */

/* DO NOT MODIFY THIS MANUALLY! This file was generated using cbindgen. See RunCbindgen.py */
#ifndef mozilla_intl_l10n_FluentBindings_h
#error "Don't include this file directly, instead include FluentBindings.h"
#endif


#include <cstdarg>
#include <cstdint>
#include <cstdlib>
#include <ostream>
#include <new>

namespace mozilla {
namespace intl {
namespace ffi {

enum class FluentNumberStyleRaw {
  Decimal,
  Currency,
  Percent,
};

enum class FluentNumberCurrencyDisplayStyleRaw {
  Symbol,
  Code,
  Name,
};

enum class FluentDateTimeStyle {
  Full,
  Long,
  Medium,
  Short,
  None,
};

enum class FluentDateTimeHourCycle {
  H24,
  H23,
  H12,
  H11,
  None,
};

enum class FluentDateTimeTextComponent {
  Long,
  Short,
  Narrow,
  None,
};

enum class FluentDateTimeNumericComponent {
  Numeric,
  TwoDigit,
  None,
};

enum class FluentDateTimeMonthComponent {
  Numeric,
  TwoDigit,
  Long,
  Short,
  Narrow,
  None,
};

enum class FluentDateTimeTimeZoneNameComponent {
  Long,
  Short,
  None,
};

/// A collection of localization messages for a single locale, which are meant
/// to be used together in a single view, widget or any other UI abstraction.
///
/// # Examples
///
/// ```
/// use fluent_bundle::{FluentBundle, FluentResource, FluentValue, FluentArgs};
/// use unic_langid::langid;
///
/// // 1. Create a FluentResource
///
/// let ftl_string = String::from("intro = Welcome, { $name }.");
/// let resource = FluentResource::try_new(ftl_string)
///     .expect("Could not parse an FTL string.");
///
///
/// // 2. Create a FluentBundle
///
/// let langid_en = langid!("en-US");
/// let mut bundle = FluentBundle::new(vec![langid_en]);
///
///
/// // 3. Add the resource to the bundle
///
/// bundle.add_resource(&resource)
///     .expect("Failed to add FTL resources to the bundle.");
///
///
/// // 4. Retrieve a FluentMessage from the bundle
///
/// let msg = bundle.get_message("intro")
///     .expect("Message doesn't exist.");
///
/// let mut args = FluentArgs::new();
/// args.set("name", "Rustacean");
///
///
/// // 5. Format the value of the message
///
/// let mut errors = vec![];
///
/// let pattern = msg.value()
///     .expect("Message has no value.");
///
/// assert_eq!(
///     bundle.format_pattern(&pattern, Some(&args), &mut errors),
///     // The placeholder is wrapper in Unicode Directionality Marks
///     // to indicate that the placeholder may be of different direction
///     // than surrounding string.
///     "Welcome, \u{2068}Rustacean\u{2069}."
/// );
///
/// ```
///
/// # `FluentBundle` Life Cycle
///
/// ## Create a bundle
///
/// To create a bundle, call [`FluentBundle::new`] with a locale list that represents the best
/// possible fallback chain for a given locale. The simplest case is a one-locale list.
///
/// Fluent uses [`LanguageIdentifier`] which can be created using `langid!` macro.
///
/// ## Add Resources
///
/// Next, call [`add_resource`](FluentBundle::add_resource) one or more times, supplying translations in the FTL syntax.
///
/// Since [`FluentBundle`] is generic over anything that can borrow a [`FluentResource`],
/// one can use [`FluentBundle`] to own its resources, store references to them,
/// or even [`Rc<FluentResource>`](std::rc::Rc) or [`Arc<FluentResource>`](std::sync::Arc).
///
/// The [`FluentBundle`] instance is now ready to be used for localization.
///
/// ## Format
///
/// To format a translation, call [`get_message`](FluentBundle::get_message) to retrieve a [`FluentMessage`],
/// and then call [`format_pattern`](FluentBundle::format_pattern) on the message value or attribute in order to
/// retrieve the translated string.
///
/// The result of [`format_pattern`](FluentBundle::format_pattern) is an
/// [`Cow<str>`](std::borrow::Cow). It is
/// recommended to treat the result as opaque from the perspective of the program and use it only
/// to display localized messages. Do not examine it or alter in any way before displaying.  This
/// is a general good practice as far as all internationalization operations are concerned.
///
/// If errors were encountered during formatting, they will be
/// accumulated in the [`Vec<FluentError>`](FluentError) passed as the third argument.
///
/// While they are not fatal, they usually indicate problems with the translation,
/// and should be logged or reported in a way that allows the developer to notice
/// and fix them.
///
///
/// # Locale Fallback Chain
///
/// [`FluentBundle`] stores messages in a single locale, but keeps a locale fallback chain for the
/// purpose of language negotiation with i18n formatters. For instance, if date and time formatting
/// are not available in the first locale, [`FluentBundle`] will use its `locales` fallback chain
/// to negotiate a sensible fallback for date and time formatting.
///
/// # Concurrency
///
/// As you may have noticed, [`fluent_bundle::FluentBundle`](crate::FluentBundle) is a specialization of [`fluent_bundle::bundle::FluentBundle`](crate::bundle::FluentBundle)
/// which works with an [`IntlLangMemoizer`] over [`RefCell`](std::cell::RefCell).
/// In scenarios where the memoizer must work concurrently, there's an implementation of
/// [`IntlLangMemoizer`][concurrent::IntlLangMemoizer] that uses [`Mutex`](std::sync::Mutex) and there's [`FluentBundle::new_concurrent`] which works with that.
///
/// [concurrent::IntlLangMemoizer]: https://docs.rs/intl-memoizer/latest/intl_memoizer/concurrent/struct.IntlLangMemoizer.html
template<typename R = void, typename M = void>
struct FluentBundle;

/// A resource containing a list of localization messages.
///
/// [`FluentResource`] wraps an [`Abstract Syntax Tree`](../fluent_syntax/ast/index.html) produced by the
/// [`parser`](../fluent_syntax/parser/index.html) and provides an access to a list
/// of its entries.
///
/// A good mental model for a resource is a single FTL file, but in the future
/// there's nothing preventing a resource from being stored in a data base,
/// pre-parsed format or in some other structured form.
///
/// # Example
///
/// ```
/// use fluent_bundle::FluentResource;
///
/// let source = r#"
///
/// hello-world = Hello World!
///
/// "#;
///
/// let resource = FluentResource::try_new(source.to_string())
///     .expect("Errors encountered while parsing a resource.");
///
/// assert_eq!(resource.entries().count(), 1);
/// ```
///
/// # Ownership
///
/// A resource owns the source string and the AST contains references
/// to the slices of the source.
struct FluentResource;

struct RawDateTimeFormatter;

struct RawNumberFormatter;

template<typename T = void>
struct Rc;

using FluentBundleRc = FluentBundle<Rc<FluentResource>>;

struct FluentArgument {
  enum class Tag : uint8_t {
    Double_,
    String,
  };

  struct Double__Body {
    double _0;
  };

  struct String_Body {
    const nsACString *_0;
  };

  Tag tag;
  union {
    Double__Body double_;
    String_Body string;
  };

  static FluentArgument Double_(const double &_0) {
    FluentArgument result;
    ::new (&result.double_._0) (double)(_0);
    result.tag = Tag::Double_;
    return result;
  }

  bool IsDouble_() const {
    return tag == Tag::Double_;
  }

  static FluentArgument String(const nsACString *const &_0) {
    FluentArgument result;
    ::new (&result.string._0) (const nsACString*)(_0);
    result.tag = Tag::String;
    return result;
  }

  bool IsString() const {
    return tag == Tag::String;
  }
};

struct L10nArg {
  const nsACString *id;
  FluentArgument value;
};

struct FluentNumberOptionsRaw {
  FluentNumberStyleRaw style;
  nsCString currency;
  FluentNumberCurrencyDisplayStyleRaw currency_display;
  bool use_grouping;
  uintptr_t minimum_integer_digits;
  uintptr_t minimum_fraction_digits;
  uintptr_t maximum_fraction_digits;
  intptr_t minimum_significant_digits;
  intptr_t maximum_significant_digits;
};

struct FluentDateTimeOptions {
  FluentDateTimeStyle date_style;
  FluentDateTimeStyle time_style;
  FluentDateTimeHourCycle hour_cycle;
  FluentDateTimeTextComponent weekday;
  FluentDateTimeTextComponent era;
  FluentDateTimeNumericComponent year;
  FluentDateTimeMonthComponent month;
  FluentDateTimeNumericComponent day;
  FluentDateTimeNumericComponent hour;
  FluentDateTimeNumericComponent minute;
  FluentDateTimeNumericComponent second;
  FluentDateTimeTimeZoneNameComponent time_zone_name;
};

struct TextElementInfo {
  nsCString id;
  nsCString attr;
  nsCString text;
};

extern "C" {

FluentBundleRc *fluent_bundle_new_single(const nsACString *locale,
                                         bool use_isolating,
                                         const nsACString *pseudo_strategy);

FluentBundleRc *fluent_bundle_new(const nsCString *locales,
                                  uintptr_t locale_count,
                                  bool use_isolating,
                                  const nsACString *pseudo_strategy);

void fluent_bundle_get_locales(const FluentBundleRc *bundle, nsTArray<nsCString> *result);

void fluent_bundle_destroy(FluentBundleRc *bundle);

bool fluent_bundle_has_message(const FluentBundleRc *bundle, const nsACString *id);

bool fluent_bundle_get_message(const FluentBundleRc *bundle,
                               const nsACString *id,
                               bool *has_value,
                               nsTArray<nsCString> *attrs);

bool fluent_bundle_format_pattern(const FluentBundleRc *bundle,
                                  const nsACString *id,
                                  const nsACString *attr,
                                  const nsTArray<L10nArg> *args,
                                  nsACString *ret_val,
                                  nsTArray<nsCString> *ret_errors);

void fluent_bundle_add_resource(FluentBundleRc *bundle,
                                const FluentResource *r,
                                bool allow_overrides,
                                nsTArray<nsCString> *ret_errors);

extern RawNumberFormatter *FluentBuiltInNumberFormatterCreate(const nsCString *locale,
                                                              const FluentNumberOptionsRaw *options);

extern uint8_t *FluentBuiltInNumberFormatterFormat(const RawNumberFormatter *formatter,
                                                   double input,
                                                   uintptr_t *out_count,
                                                   uintptr_t *out_capacity);

extern void FluentBuiltInNumberFormatterDestroy(RawNumberFormatter *formatter);

extern RawDateTimeFormatter *FluentBuiltInDateTimeFormatterCreate(const nsCString *locale,
                                                                  FluentDateTimeOptions options);

extern uint8_t *FluentBuiltInDateTimeFormatterFormat(const RawDateTimeFormatter *formatter,
                                                     double input,
                                                     uint32_t *out_count);

extern void FluentBuiltInDateTimeFormatterDestroy(RawDateTimeFormatter *formatter);

const FluentResource *fluent_resource_new(const nsACString *name, bool *has_errors);

void fluent_resource_addref(const FluentResource *res);

void fluent_resource_release(const FluentResource *res);

void fluent_resource_get_text_elements(const FluentResource *res,
                                       nsTArray<TextElementInfo> *elements);

}  // extern "C"

}  // namespace ffi
}  // namespace intl
}  // namespace mozilla
