/* avatar-cache.c generated by valac 0.56.18, the Vala compiler
 * generated from avatar-cache.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include "folks/folks.h"
#include <gio/gio.h>
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define FOLKS_AVATAR_CACHE__max_n_ongoing_stores ((guint) 10)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef struct _DelegateWrapper DelegateWrapper;
enum  {
	FOLKS_AVATAR_CACHE_0_PROPERTY,
	FOLKS_AVATAR_CACHE_NUM_PROPERTIES
};
static GParamSpec* folks_avatar_cache_properties[FOLKS_AVATAR_CACHE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _FolksAvatarCacheLoadAvatarData FolksAvatarCacheLoadAvatarData;
#define _delegate_wrapper_free0(var) ((var == NULL) ? NULL : (var = (delegate_wrapper_free (var), NULL)))
typedef struct _FolksAvatarCacheStoreAvatarData FolksAvatarCacheStoreAvatarData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FolksAvatarCacheStoreAvatarUnlimitedData FolksAvatarCacheStoreAvatarUnlimitedData;
typedef struct _FolksAvatarCacheRemoveAvatarData FolksAvatarCacheRemoveAvatarData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FolksAvatarCachePrivate {
	GFile* _cache_directory;
	guint _n_ongoing_stores;
	GQueue* _pending_stores;
};

struct _FolksAvatarCacheLoadAvatarData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksAvatarCache* self;
	gchar* id;
	GLoadableIcon* result;
	GFile* avatar_file;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFileIcon* _tmp6_;
};

struct _DelegateWrapper {
	GSourceFunc cb;
	gpointer cb_target;
	GDestroyNotify cb_target_destroy_notify;
};

struct _FolksAvatarCacheStoreAvatarData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksAvatarCache* self;
	gchar* id;
	GLoadableIcon* avatar;
	gchar* result;
	gchar* avatar_uri;
	gchar* _tmp0_;
	DelegateWrapper* wrapper;
	DelegateWrapper* _tmp1_;
	DelegateWrapper* _tmp2_;
	GQueue* _tmp3_;
	DelegateWrapper* _tmp4_;
	guint _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GError* _inner_error1_;
	guint _tmp9_;
	DelegateWrapper* _vala1_wrapper;
	GQueue* _tmp10_;
	gpointer _tmp11_;
	DelegateWrapper* _tmp12_;
	DelegateWrapper* _tmp13_;
	GSourceFunc _tmp14_;
	gpointer _tmp14__target;
	GError* _inner_error0_;
};

struct _FolksAvatarCacheStoreAvatarUnlimitedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksAvatarCache* self;
	gchar* id;
	GLoadableIcon* avatar;
	gchar* result;
	GFile* dest_avatar_file;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GInputStream* src_avatar_stream;
	GInputStream* _tmp4_;
	GOutputStream* dest_avatar_stream;
	GFileOutputStream* _tmp5_;
	GFile* _tmp6_;
	GFileOutputStream* _tmp7_;
	GFileOutputStream* _tmp8_;
	GOutputStream* _tmp9_;
	GInputStream* _tmp10_;
	GOutputStream* _tmp11_;
	GError* e;
	GError* _tmp12_;
	GOutputStream* _tmp13_;
	GOutputStream* _tmp14_;
	GError* _tmp15_;
	GError* _tmp16_;
	GInputStream* _tmp17_;
	gchar* _tmp18_;
	GError* _inner_error0_;
};

struct _FolksAvatarCacheRemoveAvatarData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksAvatarCache* self;
	gchar* id;
	GFile* avatar_file;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GFile* _tmp4_;
	GError* e;
	GError* _tmp5_;
	GError* _tmp6_;
	GError* _tmp7_;
	GError* _inner_error0_;
};

static gint FolksAvatarCache_private_offset;
static gpointer folks_avatar_cache_parent_class = NULL;
static FolksAvatarCache* folks_avatar_cache__instance;
static FolksAvatarCache* folks_avatar_cache__instance = NULL;

VALA_EXTERN void delegate_wrapper_free (DelegateWrapper * self);
static void _delegate_wrapper_free0_ (gpointer var);
static inline void _g_queue_free__delegate_wrapper_free0_ (GQueue* self);
static FolksAvatarCache* folks_avatar_cache_new (void);
static FolksAvatarCache* folks_avatar_cache_construct (GType object_type);
static void folks_avatar_cache_load_avatar_data_free (gpointer _data);
static gboolean folks_avatar_cache_load_avatar_co (FolksAvatarCacheLoadAvatarData* _data_);
static GFile* _folks_avatar_cache_get_avatar_file (FolksAvatarCache* self,
                                            const gchar* id);
static void folks_avatar_cache_store_avatar_data_free (gpointer _data);
static gboolean folks_avatar_cache_store_avatar_co (FolksAvatarCacheStoreAvatarData* _data_);
VALA_EXTERN DelegateWrapper* delegate_wrapper_new (void);
static gboolean _folks_avatar_cache_store_avatar_co_gsource_func (gpointer self);
static void _folks_avatar_cache_store_avatar_unlimited (FolksAvatarCache* self,
                                                 const gchar* id,
                                                 GLoadableIcon* avatar,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
static gchar* _folks_avatar_cache_store_avatar_unlimited_finish (FolksAvatarCache* self,
                                                          GAsyncResult* _res_,
                                                          GError** error);
static void folks_avatar_cache_store_avatar_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static void _folks_avatar_cache_store_avatar_unlimited_data_free (gpointer _data);
static gboolean _folks_avatar_cache_store_avatar_unlimited_co (FolksAvatarCacheStoreAvatarUnlimitedData* _data_);
static void _folks_avatar_cache_store_avatar_unlimited_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_);
static void _folks_avatar_cache_create_cache_directory (FolksAvatarCache* self,
                                                 GError** error);
static void folks_avatar_cache_remove_avatar_data_free (gpointer _data);
static gboolean folks_avatar_cache_remove_avatar_co (FolksAvatarCacheRemoveAvatarData* _data_);
static GObject * folks_avatar_cache_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static void folks_avatar_cache_finalize (GObject * obj);
static GType folks_avatar_cache_get_type_once (void);
static void delegate_wrapper_instance_init (DelegateWrapper * self);

static inline gpointer
folks_avatar_cache_get_instance_private (FolksAvatarCache* self)
{
	return G_STRUCT_MEMBER_P (self, FolksAvatarCache_private_offset);
}

static void
_delegate_wrapper_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (delegate_wrapper_free (var), NULL));
}

static inline void
_g_queue_free__delegate_wrapper_free0_ (GQueue* self)
{
	g_queue_free_full (self, (GDestroyNotify) _delegate_wrapper_free0_);
}

/**
   * Private constructor for an instance of the avatar cache. The singleton
   * instance should be retrieved by calling {@link AvatarCache.dup()} instead.
   *
   * @since 0.6.0
   */
static FolksAvatarCache*
folks_avatar_cache_construct (GType object_type)
{
	FolksAvatarCache * self = NULL;
	self = (FolksAvatarCache*) g_object_new (object_type, NULL);
	return self;
}

static FolksAvatarCache*
folks_avatar_cache_new (void)
{
	return folks_avatar_cache_construct (FOLKS_TYPE_AVATAR_CACHE);
}

/**
   * Create or return the singleton {@link Folks.AvatarCache} class instance.
   * If the instance doesn't exist already, it will be created.
   *
   * This function is thread-safe.
   *
   * @return Singleton {@link Folks.AvatarCache} instance
   * @since 0.6.0
   */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

FolksAvatarCache*
folks_avatar_cache_dup (void)
{
	FolksAvatarCache* _retval = NULL;
	FolksAvatarCache* _tmp0_;
	FolksAvatarCache* _tmp1_;
	FolksAvatarCache* retval = NULL;
	FolksAvatarCache* _tmp2_;
	FolksAvatarCache* result;
	_tmp0_ = folks_avatar_cache__instance;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_retval = _tmp1_;
	_tmp2_ = _retval;
	if (_tmp2_ == NULL) {
		FolksAvatarCache* _tmp3_;
		FolksAvatarCache* _tmp4_;
		_tmp3_ = folks_avatar_cache_new ();
		_g_object_unref0 (retval);
		retval = _tmp3_;
		_tmp4_ = retval;
		folks_avatar_cache__instance = _tmp4_;
	} else {
		FolksAvatarCache* _tmp5_;
		FolksAvatarCache* _tmp6_;
		_tmp5_ = _retval;
		_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, FOLKS_TYPE_AVATAR_CACHE, FolksAvatarCache));
		_g_object_unref0 (retval);
		retval = _tmp6_;
	}
	result = retval;
	_g_object_unref0 (_retval);
	return result;
}

static void
folks_avatar_cache_load_avatar_data_free (gpointer _data)
{
	FolksAvatarCacheLoadAvatarData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksAvatarCacheLoadAvatarData, _data_);
}

void
folks_avatar_cache_load_avatar (FolksAvatarCache* self,
                                const gchar* id,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	FolksAvatarCacheLoadAvatarData* _data_;
	FolksAvatarCache* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	_data_ = g_slice_new0 (FolksAvatarCacheLoadAvatarData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_avatar_cache_load_avatar_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (id);
	_g_free0 (_data_->id);
	_data_->id = _tmp1_;
	folks_avatar_cache_load_avatar_co (_data_);
}

GLoadableIcon*
folks_avatar_cache_load_avatar_finish (FolksAvatarCache* self,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	GLoadableIcon* result;
	FolksAvatarCacheLoadAvatarData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
   * Fetch an avatar from the cache by its globally unique ID.
   *
   * It is up to the caller to ensure that file I/O is rate-limited when loading
   * many avatars in parallel, by limiting calls to
   * {@link GLib.LoadableIcon.load}.
   *
   * @param id the globally unique ID for the avatar
   * @return Avatar from the cache, or ``null`` if it doesn't exist in the cache
   * @throws GLib.Error if checking for existence of the cache file failed
   * @since 0.6.0
   */
static gboolean
folks_avatar_cache_load_avatar_co (FolksAvatarCacheLoadAvatarData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _folks_avatar_cache_get_avatar_file (_data_->self, _data_->id);
	_data_->avatar_file = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->avatar_file;
	_data_->_tmp2_ = g_file_get_uri (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	g_debug ("avatar-cache.vala:124: Loading avatar '%s' from file '%s'.", _data_->id, _data_->_tmp3_);
	_g_free0 (_data_->_tmp3_);
	_data_->_tmp4_ = _data_->avatar_file;
	if (g_file_query_exists (_data_->_tmp4_, NULL) == FALSE) {
		_data_->result = NULL;
		_g_object_unref0 (_data_->avatar_file);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->avatar_file;
	_data_->_tmp6_ = (GFileIcon*) g_file_icon_new (_data_->_tmp5_);
	_data_->result = (GLoadableIcon*) _data_->_tmp6_;
	_g_object_unref0 (_data_->avatar_file);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
folks_avatar_cache_store_avatar_data_free (gpointer _data)
{
	FolksAvatarCacheStoreAvatarData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->avatar);
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksAvatarCacheStoreAvatarData, _data_);
}

void
folks_avatar_cache_store_avatar (FolksAvatarCache* self,
                                 const gchar* id,
                                 GLoadableIcon* avatar,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	FolksAvatarCacheStoreAvatarData* _data_;
	FolksAvatarCache* _tmp0_;
	gchar* _tmp1_;
	GLoadableIcon* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	g_return_if_fail (avatar != NULL);
	_data_ = g_slice_new0 (FolksAvatarCacheStoreAvatarData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_avatar_cache_store_avatar_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (id);
	_g_free0 (_data_->id);
	_data_->id = _tmp1_;
	_tmp2_ = _g_object_ref0 (avatar);
	_g_object_unref0 (_data_->avatar);
	_data_->avatar = _tmp2_;
	folks_avatar_cache_store_avatar_co (_data_);
}

gchar*
folks_avatar_cache_store_avatar_finish (FolksAvatarCache* self,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	gchar* result;
	FolksAvatarCacheStoreAvatarData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
   * Store an avatar in the cache, assigning the given globally unique ID to it,
   * which can later be used to load and remove the avatar from the cache. For
   * example, this ID could be the UID of a persona. The URI of the cached
   * avatar file will be returned.
   *
   * This method may be called multiple times concurrently for the same avatar
   * ID (e.g. an asynchronous call may be made, and a subsequent asynchronous
   * call may begin before the first has finished).
   *
   * Concurrent file I/O may be rate limited within each {@link AvatarCache}
   * instance to avoid file descriptor exhaustion.
   *
   * @param id the globally unique ID for the avatar
   * @param avatar the avatar data to cache
   * @return a URI for the file storing the cached avatar
   * @throws GLib.Error if the avatar data couldn't be loaded, or if creating
   * the avatar directory or cache file failed
   * @since 0.6.0
   */
static gboolean
_folks_avatar_cache_store_avatar_co_gsource_func (gpointer self)
{
	gboolean result;
	result = folks_avatar_cache_store_avatar_co (self);
	return result;
}

static void
folks_avatar_cache_store_avatar_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	FolksAvatarCacheStoreAvatarData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_avatar_cache_store_avatar_co (_data_);
}

static gboolean
folks_avatar_cache_store_avatar_co (FolksAvatarCacheStoreAvatarData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_strdup ("");
	_data_->avatar_uri = _data_->_tmp0_;
	if (_data_->self->priv->_n_ongoing_stores > FOLKS_AVATAR_CACHE__max_n_ongoing_stores) {
		_data_->_tmp1_ = delegate_wrapper_new ();
		_data_->wrapper = _data_->_tmp1_;
		_data_->_tmp2_ = _data_->wrapper;
		(_data_->_tmp2_->cb_target_destroy_notify == NULL) ? NULL : (_data_->_tmp2_->cb_target_destroy_notify (_data_->_tmp2_->cb_target), NULL);
		_data_->_tmp2_->cb = NULL;
		_data_->_tmp2_->cb_target = NULL;
		_data_->_tmp2_->cb_target_destroy_notify = NULL;
		_data_->_tmp2_->cb = _folks_avatar_cache_store_avatar_co_gsource_func;
		_data_->_tmp2_->cb_target = _data_;
		_data_->_tmp2_->cb_target_destroy_notify = NULL;
		_data_->_tmp3_ = _data_->self->priv->_pending_stores;
		_data_->_tmp4_ = _data_->wrapper;
		_data_->wrapper = NULL;
		g_queue_push_tail (_data_->_tmp3_, _data_->_tmp4_);
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		_delegate_wrapper_free0 (_data_->wrapper);
	}
	{
		_data_->_tmp5_ = _data_->self->priv->_n_ongoing_stores;
		_data_->self->priv->_n_ongoing_stores = _data_->_tmp5_ + 1;
		_data_->_state_ = 2;
		_folks_avatar_cache_store_avatar_unlimited (_data_->self, _data_->id, _data_->avatar, folks_avatar_cache_store_avatar_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp7_ = _folks_avatar_cache_store_avatar_unlimited_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp6_ = _data_->_tmp7_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __finally0;
		}
		_data_->_tmp8_ = _data_->_tmp6_;
		_data_->_tmp6_ = NULL;
		_g_free0 (_data_->avatar_uri);
		_data_->avatar_uri = _data_->_tmp8_;
		_g_free0 (_data_->_tmp6_);
	}
	__finally0:
	{
		_data_->_tmp9_ = _data_->self->priv->_n_ongoing_stores;
		_data_->self->priv->_n_ongoing_stores = _data_->_tmp9_ - 1;
		_data_->_tmp10_ = _data_->self->priv->_pending_stores;
		_data_->_tmp11_ = g_queue_pop_head (_data_->_tmp10_);
		_data_->_vala1_wrapper = (DelegateWrapper*) _data_->_tmp11_;
		_data_->_tmp12_ = _data_->_vala1_wrapper;
		if (_data_->_tmp12_ != NULL) {
			_data_->_tmp13_ = _data_->_vala1_wrapper;
			_data_->_tmp14_ = _data_->_tmp13_->cb;
			_data_->_tmp14__target = _data_->_tmp13_->cb_target;
			_data_->_tmp14_ (_data_->_tmp14__target);
		}
		_delegate_wrapper_free0 (_data_->_vala1_wrapper);
	}
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->avatar_uri);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->avatar_uri;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_folks_avatar_cache_store_avatar_unlimited_data_free (gpointer _data)
{
	FolksAvatarCacheStoreAvatarUnlimitedData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->avatar);
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksAvatarCacheStoreAvatarUnlimitedData, _data_);
}

static void
_folks_avatar_cache_store_avatar_unlimited (FolksAvatarCache* self,
                                            const gchar* id,
                                            GLoadableIcon* avatar,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	FolksAvatarCacheStoreAvatarUnlimitedData* _data_;
	FolksAvatarCache* _tmp0_;
	gchar* _tmp1_;
	GLoadableIcon* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	g_return_if_fail (avatar != NULL);
	_data_ = g_slice_new0 (FolksAvatarCacheStoreAvatarUnlimitedData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, _folks_avatar_cache_store_avatar_unlimited_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (id);
	_g_free0 (_data_->id);
	_data_->id = _tmp1_;
	_tmp2_ = _g_object_ref0 (avatar);
	_g_object_unref0 (_data_->avatar);
	_data_->avatar = _tmp2_;
	_folks_avatar_cache_store_avatar_unlimited_co (_data_);
}

static gchar*
_folks_avatar_cache_store_avatar_unlimited_finish (FolksAvatarCache* self,
                                                   GAsyncResult* _res_,
                                                   GError** error)
{
	gchar* result;
	FolksAvatarCacheStoreAvatarUnlimitedData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
_folks_avatar_cache_store_avatar_unlimited_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_)
{
	FolksAvatarCacheStoreAvatarUnlimitedData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_folks_avatar_cache_store_avatar_unlimited_co (_data_);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
_folks_avatar_cache_store_avatar_unlimited_co (FolksAvatarCacheStoreAvatarUnlimitedData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		case 6:
		goto _state_6;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _folks_avatar_cache_get_avatar_file (_data_->self, _data_->id);
	_data_->dest_avatar_file = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->dest_avatar_file;
	_data_->_tmp2_ = g_file_get_uri (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	g_debug ("avatar-cache.vala:195: Storing avatar '%s' in file '%s'.", _data_->id, _data_->_tmp3_);
	_g_free0 (_data_->_tmp3_);
	_data_->_state_ = 1;
	g_loadable_icon_load_async (_data_->avatar, -1, NULL, _folks_avatar_cache_store_avatar_unlimited_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp4_ = g_loadable_icon_load_finish (_data_->avatar, _data_->_res_, NULL, &_data_->_inner_error0_);
	_data_->src_avatar_stream = _data_->_tmp4_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->dest_avatar_file);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	while (TRUE) {
		_data_->dest_avatar_stream = NULL;
		{
			_data_->_tmp6_ = _data_->dest_avatar_file;
			_data_->_state_ = 2;
			g_file_replace_async (_data_->_tmp6_, NULL, FALSE, G_FILE_CREATE_PRIVATE, G_PRIORITY_DEFAULT, NULL, _folks_avatar_cache_store_avatar_unlimited_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp7_ = g_file_replace_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp5_ = _data_->_tmp7_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp8_ = _data_->_tmp5_;
			_data_->_tmp5_ = NULL;
			_g_object_unref0 (_data_->dest_avatar_stream);
			_data_->dest_avatar_stream = (GOutputStream*) _data_->_tmp8_;
			_data_->_tmp9_ = _data_->dest_avatar_stream;
			_data_->_tmp10_ = _data_->src_avatar_stream;
			_data_->_state_ = 3;
			g_output_stream_splice_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp9_, g_output_stream_get_type (), GOutputStream), _data_->_tmp10_, G_OUTPUT_STREAM_SPLICE_NONE, G_PRIORITY_DEFAULT, NULL, _folks_avatar_cache_store_avatar_unlimited_ready, _data_);
			return FALSE;
			_state_3:
			g_output_stream_splice_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp9_, g_output_stream_get_type (), GOutputStream), _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->_tmp5_);
				goto __catch0_g_error;
			}
			_data_->_tmp11_ = _data_->dest_avatar_stream;
			_data_->_state_ = 4;
			g_output_stream_close_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp11_, g_output_stream_get_type (), GOutputStream), G_PRIORITY_DEFAULT, NULL, _folks_avatar_cache_store_avatar_unlimited_ready, _data_);
			return FALSE;
			_state_4:
			g_output_stream_close_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp11_, g_output_stream_get_type (), GOutputStream), _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->_tmp5_);
				goto __catch0_g_error;
			}
			_g_object_unref0 (_data_->_tmp5_);
			_g_object_unref0 (_data_->dest_avatar_stream);
			break;
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp12_ = _data_->e;
			if (g_error_matches (_data_->_tmp12_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
				_folks_avatar_cache_create_cache_directory (_data_->self, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_error_free0 (_data_->e);
					goto __finally0;
				}
				_g_error_free0 (_data_->e);
				_g_object_unref0 (_data_->dest_avatar_stream);
				continue;
			}
			_data_->_tmp13_ = _data_->dest_avatar_stream;
			if (_data_->_tmp13_ != NULL) {
				_data_->_tmp14_ = _data_->dest_avatar_stream;
				_data_->_state_ = 5;
				g_output_stream_close_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp14_, g_output_stream_get_type (), GOutputStream), G_PRIORITY_DEFAULT, NULL, _folks_avatar_cache_store_avatar_unlimited_ready, _data_);
				return FALSE;
				_state_5:
				g_output_stream_close_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp14_, g_output_stream_get_type (), GOutputStream), _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_error_free0 (_data_->e);
					goto __finally0;
				}
			}
			_data_->_tmp15_ = _data_->e;
			_data_->_tmp16_ = _g_error_copy0 (_data_->_tmp15_);
			_data_->_inner_error0_ = _data_->_tmp16_;
			_g_error_free0 (_data_->e);
			goto __finally0;
		}
		__finally0:
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->dest_avatar_stream);
		_g_object_unref0 (_data_->src_avatar_stream);
		_g_object_unref0 (_data_->dest_avatar_file);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp17_ = _data_->src_avatar_stream;
	_data_->_state_ = 6;
	g_input_stream_close_async (_data_->_tmp17_, G_PRIORITY_DEFAULT, NULL, _folks_avatar_cache_store_avatar_unlimited_ready, _data_);
	return FALSE;
	_state_6:
	g_input_stream_close_finish (_data_->_tmp17_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->src_avatar_stream);
		_g_object_unref0 (_data_->dest_avatar_file);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp18_ = folks_avatar_cache_build_uri_for_avatar (_data_->self, _data_->id);
	_data_->result = _data_->_tmp18_;
	_g_object_unref0 (_data_->src_avatar_stream);
	_g_object_unref0 (_data_->dest_avatar_file);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
folks_avatar_cache_remove_avatar_data_free (gpointer _data)
{
	FolksAvatarCacheRemoveAvatarData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksAvatarCacheRemoveAvatarData, _data_);
}

void
folks_avatar_cache_remove_avatar (FolksAvatarCache* self,
                                  const gchar* id,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	FolksAvatarCacheRemoveAvatarData* _data_;
	FolksAvatarCache* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	_data_ = g_slice_new0 (FolksAvatarCacheRemoveAvatarData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_avatar_cache_remove_avatar_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (id);
	_g_free0 (_data_->id);
	_data_->id = _tmp1_;
	folks_avatar_cache_remove_avatar_co (_data_);
}

void
folks_avatar_cache_remove_avatar_finish (FolksAvatarCache* self,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	FolksAvatarCacheRemoveAvatarData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * Remove an avatar from the cache, if it exists in the cache. If the avatar
   * exists in the cache but there is a problem in removing it, a
   * {@link GLib.Error} will be thrown.
   *
   * @param id the globally unique ID for the avatar
   * @throws GLib.Error if deleting the cache file failed
   * @since 0.6.0
   */
static gboolean
folks_avatar_cache_remove_avatar_co (FolksAvatarCacheRemoveAvatarData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _folks_avatar_cache_get_avatar_file (_data_->self, _data_->id);
	_data_->avatar_file = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->avatar_file;
	_data_->_tmp2_ = g_file_get_uri (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	g_debug ("avatar-cache.vala:258: Removing avatar '%s' in file '%s'.", _data_->id, _data_->_tmp3_);
	_g_free0 (_data_->_tmp3_);
	{
		_data_->_tmp4_ = _data_->avatar_file;
		g_file_delete (_data_->_tmp4_, NULL, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp5_ = _data_->e;
		if (!g_error_matches (_data_->_tmp5_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
			_data_->_tmp6_ = _data_->e;
			_data_->_tmp7_ = _g_error_copy0 (_data_->_tmp6_);
			_data_->_inner_error0_ = _data_->_tmp7_;
			_g_error_free0 (_data_->e);
			goto __finally0;
		}
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->avatar_file);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->avatar_file);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
   * Build the URI of an avatar file in the cache from a globally unique ID.
   * This will always succeed, even if the avatar doesn't exist in the cache.
   *
   * @param id the globally unique ID for the avatar
   * @return URI of the avatar file with the given globally unique ID
   * @since 0.6.0
   */
gchar*
folks_avatar_cache_build_uri_for_avatar (FolksAvatarCache* self,
                                         const gchar* id)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = _folks_avatar_cache_get_avatar_file (self, id);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_uri (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static GFile*
_folks_avatar_cache_get_avatar_file (FolksAvatarCache* self,
                                     const gchar* id)
{
	gchar* escaped_uri = NULL;
	gchar* _tmp0_;
	GFile* file = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = g_uri_escape_string (id, "", FALSE);
	escaped_uri = _tmp0_;
	_tmp1_ = self->priv->_cache_directory;
	_tmp2_ = g_file_get_child (_tmp1_, escaped_uri);
	file = _tmp2_;
	_tmp3_ = self->priv->_cache_directory;
	_vala_assert (g_file_has_parent (file, _tmp3_) == TRUE, "file.has_parent (this._cache_directory) == true");
	result = file;
	_g_free0 (escaped_uri);
	return result;
}

static void
_folks_avatar_cache_create_cache_directory (FolksAvatarCache* self,
                                            GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GFile* _tmp0_;
		_tmp0_ = self->priv->_cache_directory;
		g_file_make_directory_with_parents (_tmp0_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		if (!g_error_matches (_tmp1_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
			GError* _tmp2_;
			GError* _tmp3_;
			_tmp2_ = e;
			_tmp3_ = _g_error_copy0 (_tmp2_);
			_inner_error0_ = _tmp3_;
			_g_error_free0 (e);
			goto __finally0;
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static GObject *
folks_avatar_cache_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FolksAvatarCache * self;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	parent_class = G_OBJECT_CLASS (folks_avatar_cache_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_AVATAR_CACHE, FolksAvatarCache);
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_file_new_for_path (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_get_child (_tmp2_, "folks");
	_tmp4_ = _tmp3_;
	_tmp5_ = g_file_get_child (_tmp4_, "avatars");
	_g_object_unref0 (self->priv->_cache_directory);
	self->priv->_cache_directory = _tmp5_;
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	return obj;
}

static void
folks_avatar_cache_class_init (FolksAvatarCacheClass * klass,
                               gpointer klass_data)
{
	folks_avatar_cache_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FolksAvatarCache_private_offset);
	G_OBJECT_CLASS (klass)->constructor = folks_avatar_cache_constructor;
	G_OBJECT_CLASS (klass)->finalize = folks_avatar_cache_finalize;
}

static void
folks_avatar_cache_instance_init (FolksAvatarCache * self,
                                  gpointer klass)
{
	GQueue* _tmp0_;
	self->priv = folks_avatar_cache_get_instance_private (self);
	self->priv->_n_ongoing_stores = (guint) 0;
	_tmp0_ = g_queue_new ();
	self->priv->_pending_stores = _tmp0_;
}

static void
folks_avatar_cache_finalize (GObject * obj)
{
	FolksAvatarCache * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_AVATAR_CACHE, FolksAvatarCache);
	folks_avatar_cache__instance = NULL;
	_g_object_unref0 (self->priv->_cache_directory);
	(self->priv->_pending_stores == NULL) ? NULL : (self->priv->_pending_stores = (_g_queue_free__delegate_wrapper_free0_ (self->priv->_pending_stores), NULL));
	G_OBJECT_CLASS (folks_avatar_cache_parent_class)->finalize (obj);
}

/**
 * A singleton persistent cache for avatars in folks.
 *
 * Avatars may be added to the cache, and referred to by a persistent
 * URI from that point onwards. The avatars will be stored on disk in the user's
 * XDG cache directory.
 *
 * The avatar cache is typically used by backends where retrieving avatars is an
 * expensive operation (for example, they have to be downloaded from the network
 * every time they're used).
 *
 * All avatars from all users of the {@link Folks.AvatarCache} are stored in the
 * same namespace, so callers must ensure that the IDs they use for avatars are
 * globally unique (e.g. by using the corresponding {@link Folks.Persona.uid}).
 *
 * Ongoing store operations ({@link Folks.AvatarCache.store_avatar}) are rate
 * limited to try and prevent file descriptor exhaustion. Load operations
 * ({@link Folks.AvatarCache.load_avatar}) must be rate limited by the client,
 * as the file I/O occurs when calling {@link GLib.LoadableIcon.load} rather
 * than when retrieving the {@link GLib.LoadableIcon} from the cache.
 *
 * @since 0.6.0
 */
static GType
folks_avatar_cache_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksAvatarCacheClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_avatar_cache_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksAvatarCache), 0, (GInstanceInitFunc) folks_avatar_cache_instance_init, NULL };
	GType folks_avatar_cache_type_id;
	folks_avatar_cache_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksAvatarCache", &g_define_type_info, 0);
	FolksAvatarCache_private_offset = g_type_add_instance_private (folks_avatar_cache_type_id, sizeof (FolksAvatarCachePrivate));
	return folks_avatar_cache_type_id;
}

GType
folks_avatar_cache_get_type (void)
{
	static volatile gsize folks_avatar_cache_type_id__once = 0;
	if (g_once_init_enter (&folks_avatar_cache_type_id__once)) {
		GType folks_avatar_cache_type_id;
		folks_avatar_cache_type_id = folks_avatar_cache_get_type_once ();
		g_once_init_leave (&folks_avatar_cache_type_id__once, folks_avatar_cache_type_id);
	}
	return folks_avatar_cache_type_id__once;
}

DelegateWrapper*
delegate_wrapper_new (void)
{
	DelegateWrapper* self;
	self = g_slice_new0 (DelegateWrapper);
	delegate_wrapper_instance_init (self);
	return self;
}

static void
delegate_wrapper_instance_init (DelegateWrapper * self)
{
}

void
delegate_wrapper_free (DelegateWrapper * self)
{
	(self->cb_target_destroy_notify == NULL) ? NULL : (self->cb_target_destroy_notify (self->cb_target), NULL);
	self->cb = NULL;
	self->cb_target = NULL;
	self->cb_target_destroy_notify = NULL;
	g_slice_free (DelegateWrapper, self);
}

