/* command-set.c generated by valac 0.56.18, the Vala compiler
 * generated from command-set.vala, do not modify */

/*
 * Copyright (C) 2012 Jeremy Whiting <jeremy.whiting@collabora.com>
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Jeremy Whiting <jeremy.whiting@collabora.com>
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "folks/folks.h"
#include <gee.h>
#include <stdio.h>
#include <readline/readline.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FOLKS_INSPECT_TYPE_COMMAND (folks_inspect_command_get_type ())
#define FOLKS_INSPECT_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommand))
#define FOLKS_INSPECT_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommandClass))
#define FOLKS_INSPECT_IS_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_COMMAND))
#define FOLKS_INSPECT_IS_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_COMMAND))
#define FOLKS_INSPECT_COMMAND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommandClass))

typedef struct _FolksInspectCommand FolksInspectCommand;
typedef struct _FolksInspectCommandClass FolksInspectCommandClass;
typedef struct _FolksInspectCommandPrivate FolksInspectCommandPrivate;

#define FOLKS_INSPECT_TYPE_CLIENT (folks_inspect_client_get_type ())
#define FOLKS_INSPECT_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClient))
#define FOLKS_INSPECT_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientClass))
#define FOLKS_INSPECT_IS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_CLIENT))
#define FOLKS_INSPECT_IS_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_CLIENT))
#define FOLKS_INSPECT_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientClass))

typedef struct _FolksInspectClient FolksInspectClient;
typedef struct _FolksInspectClientClass FolksInspectClientClass;

#define FOLKS_INSPECT_COMMANDS_TYPE_SET (folks_inspect_commands_set_get_type ())
#define FOLKS_INSPECT_COMMANDS_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_COMMANDS_TYPE_SET, FolksInspectCommandsSet))
#define FOLKS_INSPECT_COMMANDS_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_COMMANDS_TYPE_SET, FolksInspectCommandsSetClass))
#define FOLKS_INSPECT_COMMANDS_IS_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_COMMANDS_TYPE_SET))
#define FOLKS_INSPECT_COMMANDS_IS_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_COMMANDS_TYPE_SET))
#define FOLKS_INSPECT_COMMANDS_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_COMMANDS_TYPE_SET, FolksInspectCommandsSetClass))

typedef struct _FolksInspectCommandsSet FolksInspectCommandsSet;
typedef struct _FolksInspectCommandsSetClass FolksInspectCommandsSetClass;
typedef struct _FolksInspectCommandsSetPrivate FolksInspectCommandsSetPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _folks_inspect_command_unref0(var) ((var == NULL) ? NULL : (var = (folks_inspect_command_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _FolksInspectCommandsSetRunData FolksInspectCommandsSetRunData;

struct _FolksInspectCommand {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FolksInspectCommandPrivate * priv;
	FolksInspectClient* client;
};

struct _FolksInspectCommandClass {
	GTypeClass parent_class;
	void (*finalize) (FolksInspectCommand *self);
	void (*run) (FolksInspectCommand* self, const gchar* command_string, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gint (*run_finish) (FolksInspectCommand* self, GAsyncResult* _res_);
	gchar** (*complete_subcommand) (FolksInspectCommand* self, const gchar* subcommand, gint* result_length1);
	const gchar* (*get_name) (FolksInspectCommand* self);
	const gchar* (*get_description) (FolksInspectCommand* self);
	const gchar* (*get_help) (FolksInspectCommand* self);
};

struct _FolksInspectCommandsSet {
	FolksInspectCommand parent_instance;
	FolksInspectCommandsSetPrivate * priv;
};

struct _FolksInspectCommandsSetClass {
	FolksInspectCommandClass parent_class;
};

struct _FolksInspectCommandsSetRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksInspectCommandsSet* self;
	gchar* command_string;
	gint result;
	gchar** parts;
	gchar** _tmp0_;
	gint parts_length1;
	gint _parts_size_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	const gchar* _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	const gchar* _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gboolean _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	const gchar* _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	const gchar* _tmp18_;
	gchar* id;
	gchar** _tmp19_;
	gint _tmp19__length1;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	FolksIndividual* individual;
	FolksInspectClient* _tmp22_;
	FolksIndividualAggregator* _tmp23_;
	FolksIndividualAggregator* _tmp24_;
	GeeMap* _tmp25_;
	GeeMap* _tmp26_;
	const gchar* _tmp27_;
	gpointer _tmp28_;
	FolksIndividual* _tmp29_;
	const gchar* _tmp30_;
	FolksPersona* persona;
	FolksInspectClient* _tmp31_;
	FolksIndividualAggregator* _tmp32_;
	FolksIndividualAggregator* _tmp33_;
	FolksIndividual* _tmp34_;
	FolksPersona* _tmp35_;
	FolksPersona* _tmp36_;
	FolksIndividual* _tmp37_;
	FolksIndividual* _tmp38_;
	gchar** _tmp39_;
	gint _tmp39__length1;
	const gchar* _tmp40_;
	gchar** _tmp41_;
	gint _tmp41__length1;
	const gchar* _tmp42_;
	gchar** _tmp43_;
	gint _tmp43__length1;
	const gchar* _tmp44_;
	GError* _inner_error0_;
};

static gpointer folks_inspect_commands_set_parent_class = NULL;
static gchar** folks_inspect_commands_set_subcommand_completions;
static gchar** folks_inspect_commands_set_subcommand_completions = NULL;
static guint folks_inspect_commands_set_completion_count;
static guint folks_inspect_commands_set_completion_count = 0U;
static gchar* folks_inspect_commands_set_prefix;
static gchar* folks_inspect_commands_set_prefix = NULL;

VALA_EXTERN gpointer folks_inspect_command_ref (gpointer instance);
VALA_EXTERN void folks_inspect_command_unref (gpointer instance);
VALA_EXTERN GParamSpec* folks_inspect_param_spec_command (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
VALA_EXTERN void folks_inspect_value_set_command (GValue* value,
                                      gpointer v_object);
VALA_EXTERN void folks_inspect_value_take_command (GValue* value,
                                       gpointer v_object);
VALA_EXTERN gpointer folks_inspect_value_get_command (const GValue* value);
VALA_EXTERN GType folks_inspect_command_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FolksInspectCommand, folks_inspect_command_unref)
VALA_EXTERN GType folks_inspect_client_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FolksInspectClient, g_object_unref)
VALA_EXTERN GType folks_inspect_commands_set_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FolksInspectCommandsSet, folks_inspect_command_unref)
VALA_EXTERN void folks_inspect_command_run (FolksInspectCommand* self,
                                const gchar* command_string,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_);
VALA_EXTERN gint folks_inspect_command_run_finish (FolksInspectCommand* self,
                                       GAsyncResult* _res_);
VALA_EXTERN gchar** folks_inspect_command_complete_subcommand (FolksInspectCommand* self,
                                                   const gchar* subcommand,
                                                   gint* result_length1);
VALA_EXTERN const gchar* folks_inspect_command_get_name (FolksInspectCommand* self);
VALA_EXTERN const gchar* folks_inspect_command_get_description (FolksInspectCommand* self);
VALA_EXTERN const gchar* folks_inspect_command_get_help (FolksInspectCommand* self);
VALA_EXTERN FolksInspectCommandsSet* folks_inspect_commands_set_new (FolksInspectClient* client);
VALA_EXTERN FolksInspectCommandsSet* folks_inspect_commands_set_construct (GType object_type,
                                                               FolksInspectClient* client);
VALA_EXTERN FolksInspectCommand* folks_inspect_command_construct (GType object_type,
                                                      FolksInspectClient* client);
static void folks_inspect_commands_set_real_run_data_free (gpointer _data);
static void folks_inspect_commands_set_real_run (FolksInspectCommand* base,
                                          const gchar* command_string,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
static gboolean folks_inspect_commands_set_real_run_co (FolksInspectCommandsSetRunData* _data_);
VALA_EXTERN gboolean folks_inspect_utils_validate_subcommand (const gchar* command,
                                                  const gchar* command_string,
                                                  const gchar* subcommand,
                                                  gchar** valid_subcommands,
                                                  gint valid_subcommands_length1);
VALA_EXTERN void folks_inspect_utils_print_line (const gchar* format,
                                     ...)  G_GNUC_PRINTF(1,2) ;
VALA_EXTERN FolksIndividualAggregator* folks_inspect_client_get_aggregator (FolksInspectClient* self);
static void folks_inspect_commands_set_run_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
VALA_EXTERN gchar* folks_inspect_commands_set_subcommand_name_completion_cb (const gchar* word,
                                                                 gint state);
VALA_EXTERN gchar* folks_inspect_utils_individual_id_completion_cb (const gchar* word,
                                                        gint state);
static gchar* _folks_inspect_utils_individual_id_completion_cb_rl_compentry_func_t (const gchar* str,
                                                                             gint a);
static gchar** _vala_array_dup11 (gchar** self,
                           gssize length);
static gchar** _vala_array_dup12 (gchar** self,
                           gssize length);
static gchar** folks_inspect_commands_set_real_complete_subcommand (FolksInspectCommand* base,
                                                             const gchar* subcommand,
                                                             gint* result_length1);
static gchar* _folks_inspect_commands_set_subcommand_name_completion_cb_rl_compentry_func_t (const gchar* str,
                                                                                      gint a);
static gchar** _vala_array_dup13 (gchar** self,
                           gssize length);
static void folks_inspect_commands_set_finalize (FolksInspectCommand * obj);
static GType folks_inspect_commands_set_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const gchar* FOLKS_INSPECT_COMMANDS_SET__valid_subcommands[1] = {"alias"};

FolksInspectCommandsSet*
folks_inspect_commands_set_construct (GType object_type,
                                      FolksInspectClient* client)
{
	FolksInspectCommandsSet* self = NULL;
	g_return_val_if_fail (client != NULL, NULL);
	self = (FolksInspectCommandsSet*) folks_inspect_command_construct (object_type, client);
	return self;
}

FolksInspectCommandsSet*
folks_inspect_commands_set_new (FolksInspectClient* client)
{
	return folks_inspect_commands_set_construct (FOLKS_INSPECT_COMMANDS_TYPE_SET, client);
}

static void
folks_inspect_commands_set_real_run_data_free (gpointer _data)
{
	FolksInspectCommandsSetRunData* _data_;
	_data_ = _data;
	_g_free0 (_data_->command_string);
	_folks_inspect_command_unref0 (_data_->self);
	g_slice_free (FolksInspectCommandsSetRunData, _data_);
}

static gpointer
_folks_inspect_command_ref0 (gpointer self)
{
	return self ? folks_inspect_command_ref (self) : NULL;
}

static void
folks_inspect_commands_set_real_run (FolksInspectCommand* base,
                                     const gchar* command_string,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	FolksInspectCommandsSet * self;
	FolksInspectCommandsSetRunData* _data_;
	FolksInspectCommandsSet* _tmp0_;
	gchar* _tmp1_;
	self = (FolksInspectCommandsSet*) base;
	_data_ = g_slice_new0 (FolksInspectCommandsSetRunData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_inspect_commands_set_real_run_data_free);
	_tmp0_ = _folks_inspect_command_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (command_string);
	_g_free0 (_data_->command_string);
	_data_->command_string = _tmp1_;
	folks_inspect_commands_set_real_run_co (_data_);
}

static gint
folks_inspect_commands_set_run_finish (FolksInspectCommand* base,
                                       GAsyncResult* _res_)
{
	gint result;
	FolksInspectCommandsSetRunData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
folks_inspect_commands_set_run_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	FolksInspectCommandsSetRunData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_inspect_commands_set_real_run_co (_data_);
}

static gboolean
folks_inspect_commands_set_real_run_co (FolksInspectCommandsSetRunData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_new0 (gchar*, 0 + 1);
	_data_->parts = _data_->_tmp0_;
	_data_->parts_length1 = 0;
	_data_->_parts_size_ = _data_->parts_length1;
	if (_data_->command_string != NULL) {
		_data_->_tmp2_ = _data_->_tmp1_ = g_strsplit (_data_->command_string, " ", 0);
		_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
		_data_->parts = _data_->_tmp2_;
		_data_->parts_length1 = _vala_array_length (_data_->_tmp1_);
		_data_->_parts_size_ = _data_->parts_length1;
	}
	_data_->_tmp3_ = folks_inspect_command_get_name ((FolksInspectCommand*) _data_->self);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = _data_->parts;
	_data_->_tmp5__length1 = _data_->parts_length1;
	_data_->_tmp6_ = _data_->_tmp5_[0];
	if (!folks_inspect_utils_validate_subcommand (_data_->_tmp4_, _data_->command_string, _data_->_tmp6_, FOLKS_INSPECT_COMMANDS_SET__valid_subcommands, (gint) G_N_ELEMENTS (FOLKS_INSPECT_COMMANDS_SET__valid_subcommands))) {
		_data_->result = 1;
		_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = _data_->parts;
	_data_->_tmp7__length1 = _data_->parts_length1;
	_data_->_tmp8_ = _data_->_tmp7_[0];
	if (g_strcmp0 (_data_->_tmp8_, "alias") == 0) {
		_data_->_tmp9_ = _data_->parts;
		_data_->_tmp9__length1 = _data_->parts_length1;
		if (_data_->_tmp9__length1 < 3) {
			folks_inspect_utils_print_line ("%s", "Must pass at least one individual ID and a new alias to an " "'alias' subcommand.");
			_data_->result = 1;
			_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp11_ = _data_->parts;
		_data_->_tmp11__length1 = _data_->parts_length1;
		_data_->_tmp12_ = _data_->_tmp11_[1];
		if (_data_->_tmp12_ == NULL) {
			_data_->_tmp10_ = TRUE;
		} else {
			_data_->_tmp13_ = _data_->parts;
			_data_->_tmp13__length1 = _data_->parts_length1;
			_data_->_tmp14_ = _data_->_tmp13_[1];
			_data_->_tmp15_ = string_strip (_data_->_tmp14_);
			_data_->_tmp16_ = _data_->_tmp15_;
			_data_->_tmp10_ = g_strcmp0 (_data_->_tmp16_, "") == 0;
			_g_free0 (_data_->_tmp16_);
		}
		if (_data_->_tmp10_) {
			_data_->_tmp17_ = _data_->parts;
			_data_->_tmp17__length1 = _data_->parts_length1;
			_data_->_tmp18_ = _data_->_tmp17_[1];
			folks_inspect_utils_print_line ("Unrecognised individual ID '%s'.", _data_->_tmp18_);
			_data_->result = 1;
			_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp19_ = _data_->parts;
		_data_->_tmp19__length1 = _data_->parts_length1;
		_data_->_tmp20_ = _data_->_tmp19_[1];
		_data_->_tmp21_ = string_strip (_data_->_tmp20_);
		_data_->id = _data_->_tmp21_;
		_data_->_tmp22_ = ((FolksInspectCommand*) _data_->self)->client;
		_data_->_tmp23_ = folks_inspect_client_get_aggregator (_data_->_tmp22_);
		_data_->_tmp24_ = _data_->_tmp23_;
		_data_->_tmp25_ = folks_individual_aggregator_get_individuals (_data_->_tmp24_);
		_data_->_tmp26_ = _data_->_tmp25_;
		_data_->_tmp27_ = _data_->id;
		_data_->_tmp28_ = gee_map_get (_data_->_tmp26_, _data_->_tmp27_);
		_data_->individual = (FolksIndividual*) _data_->_tmp28_;
		_data_->_tmp29_ = _data_->individual;
		if (_data_->_tmp29_ == NULL) {
			_data_->_tmp30_ = _data_->id;
			folks_inspect_utils_print_line ("Unrecognized individual ID '%s'.", _data_->_tmp30_);
			_data_->result = 1;
			_g_object_unref0 (_data_->individual);
			_g_free0 (_data_->id);
			_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		{
			_data_->_tmp31_ = ((FolksInspectCommand*) _data_->self)->client;
			_data_->_tmp32_ = folks_inspect_client_get_aggregator (_data_->_tmp31_);
			_data_->_tmp33_ = _data_->_tmp32_;
			_data_->_tmp34_ = _data_->individual;
			_data_->_state_ = 1;
			folks_individual_aggregator_ensure_individual_property_writeable (_data_->_tmp33_, _data_->_tmp34_, "alias", folks_inspect_commands_set_run_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp35_ = folks_individual_aggregator_ensure_individual_property_writeable_finish (_data_->_tmp33_, _data_->_res_, &_data_->_inner_error0_);
			_data_->persona = _data_->_tmp35_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				if (_data_->_inner_error0_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
					goto __catch0_folks_individual_aggregator_error;
				}
				_g_object_unref0 (_data_->individual);
				_g_free0 (_data_->id);
				_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp36_ = _data_->persona;
			_data_->_tmp37_ = folks_persona_get_individual (_data_->_tmp36_);
			_data_->_tmp38_ = _data_->_tmp37_;
			_data_->_tmp39_ = _data_->parts;
			_data_->_tmp39__length1 = _data_->parts_length1;
			_data_->_tmp40_ = _data_->_tmp39_[2];
			folks_alias_details_set_alias ((FolksAliasDetails*) _data_->_tmp38_, _data_->_tmp40_);
			_data_->_tmp41_ = _data_->parts;
			_data_->_tmp41__length1 = _data_->parts_length1;
			_data_->_tmp42_ = _data_->_tmp41_[2];
			folks_inspect_utils_print_line ("Setting of individual's alias to '%s' was successful.", _data_->_tmp42_);
			_g_object_unref0 (_data_->persona);
		}
		goto __finally0;
		__catch0_folks_individual_aggregator_error:
		{
			g_clear_error (&_data_->_inner_error0_);
			_data_->_tmp43_ = _data_->parts;
			_data_->_tmp43__length1 = _data_->parts_length1;
			_data_->_tmp44_ = _data_->_tmp43_[2];
			folks_inspect_utils_print_line ("Setting of individual's alias to '%s' failed.", _data_->_tmp44_);
			_data_->result = 1;
			_g_object_unref0 (_data_->individual);
			_g_free0 (_data_->id);
			_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->individual);
			_g_free0 (_data_->id);
			_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->individual);
		_g_free0 (_data_->id);
	} else {
		g_assert_not_reached ();
	}
	_data_->result = 0;
	_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
_folks_inspect_utils_individual_id_completion_cb_rl_compentry_func_t (const gchar* str,
                                                                      gint a)
{
	gchar* result;
	result = folks_inspect_utils_individual_id_completion_cb (str, a);
	return result;
}

static gchar**
_vala_array_dup11 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gchar**
_vala_array_dup12 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

gchar*
folks_inspect_commands_set_subcommand_name_completion_cb (const gchar* word,
                                                          gint state)
{
	gchar* _tmp37_;
	gchar* result;
	g_return_val_if_fail (word != NULL, NULL);
	if (state == 0) {
		gchar** parts = NULL;
		gchar** _tmp0_;
		gchar** _tmp1_;
		gint parts_length1;
		gint _parts_size_;
		gboolean _tmp2_ = FALSE;
		gchar** _tmp3_;
		gint _tmp3__length1;
		_tmp1_ = _tmp0_ = g_strsplit (word, " ", 0);
		parts = _tmp1_;
		parts_length1 = _vala_array_length (_tmp0_);
		_parts_size_ = parts_length1;
		_tmp3_ = parts;
		_tmp3__length1 = parts_length1;
		if (_tmp3__length1 > 0) {
			gchar** _tmp4_;
			gint _tmp4__length1;
			const gchar* _tmp5_;
			_tmp4_ = parts;
			_tmp4__length1 = parts_length1;
			_tmp5_ = _tmp4_[0];
			_tmp2_ = g_strcmp0 (_tmp5_, "alias") == 0;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			gchar* last_part = NULL;
			gchar** _tmp6_;
			gint _tmp6__length1;
			gchar** _tmp7_;
			gint _tmp7__length1;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			gchar** _tmp10_;
			gint _tmp10__length1;
			const gchar* _tmp11_;
			const gchar* _tmp16_;
			_tmp6_ = parts;
			_tmp6__length1 = parts_length1;
			_tmp7_ = parts;
			_tmp7__length1 = parts_length1;
			_tmp8_ = _tmp6_[_tmp7__length1 - 1];
			_tmp9_ = g_strdup (_tmp8_);
			last_part = _tmp9_;
			_tmp10_ = parts;
			_tmp10__length1 = parts_length1;
			_tmp11_ = _tmp10_[0];
			if (g_strcmp0 (_tmp11_, "alias") == 0) {
				const gchar* _tmp12_;
				gchar** _tmp13_;
				gchar** _tmp14_;
				gchar** _tmp15_;
				gint _tmp15__length1;
				_tmp12_ = last_part;
				_tmp14_ = _tmp13_ = rl_completion_matches (_tmp12_, _folks_inspect_utils_individual_id_completion_cb_rl_compentry_func_t);
				_tmp15_ = (_tmp14_ != NULL) ? _vala_array_dup11 (_tmp14_, _vala_array_length (_tmp13_)) : _tmp14_;
				_tmp15__length1 = _vala_array_length (_tmp13_);
				folks_inspect_commands_set_subcommand_completions = (_vala_array_free (folks_inspect_commands_set_subcommand_completions, _vala_array_length (folks_inspect_commands_set_subcommand_completions), (GDestroyNotify) g_free), NULL);
				folks_inspect_commands_set_subcommand_completions = _tmp15_;
			}
			_tmp16_ = last_part;
			if (g_strcmp0 (_tmp16_, "") == 0) {
				gchar* _tmp17_;
				_tmp17_ = g_strdup (word);
				_g_free0 (folks_inspect_commands_set_prefix);
				folks_inspect_commands_set_prefix = _tmp17_;
			} else {
				const gchar* _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
				gchar* _tmp21_;
				_tmp18_ = last_part;
				_tmp19_ = strlen (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = string_slice (word, (glong) 0, (glong) (-_tmp20_));
				_g_free0 (folks_inspect_commands_set_prefix);
				folks_inspect_commands_set_prefix = _tmp21_;
			}
			_g_free0 (last_part);
		} else {
			gchar** _tmp22_;
			gint _tmp22__length1;
			gchar* _tmp23_;
			_tmp22_ = _vala_array_dup12 (FOLKS_INSPECT_COMMANDS_SET__valid_subcommands, G_N_ELEMENTS (FOLKS_INSPECT_COMMANDS_SET__valid_subcommands));
			_tmp22__length1 = G_N_ELEMENTS (FOLKS_INSPECT_COMMANDS_SET__valid_subcommands);
			folks_inspect_commands_set_subcommand_completions = (_vala_array_free (folks_inspect_commands_set_subcommand_completions, _vala_array_length (folks_inspect_commands_set_subcommand_completions), (GDestroyNotify) g_free), NULL);
			folks_inspect_commands_set_subcommand_completions = _tmp22_;
			_tmp23_ = g_strdup ("");
			_g_free0 (folks_inspect_commands_set_prefix);
			folks_inspect_commands_set_prefix = _tmp23_;
		}
		folks_inspect_commands_set_completion_count = (guint) 0;
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	}
	while (TRUE) {
		gchar** _tmp24_;
		gint _tmp24__length1;
		gchar* completion = NULL;
		gchar** _tmp25_;
		gint _tmp25__length1;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* candidate = NULL;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		guint _tmp31_;
		gboolean _tmp32_ = FALSE;
		gboolean _tmp33_ = FALSE;
		const gchar* _tmp34_;
		_tmp24_ = folks_inspect_commands_set_subcommand_completions;
		_tmp24__length1 = _vala_array_length (folks_inspect_commands_set_subcommand_completions);
		if (!(folks_inspect_commands_set_completion_count < ((guint) _tmp24__length1))) {
			break;
		}
		_tmp25_ = folks_inspect_commands_set_subcommand_completions;
		_tmp25__length1 = _vala_array_length (folks_inspect_commands_set_subcommand_completions);
		_tmp26_ = _tmp25_[folks_inspect_commands_set_completion_count];
		_tmp27_ = g_strdup (_tmp26_);
		completion = _tmp27_;
		_tmp28_ = folks_inspect_commands_set_prefix;
		_tmp29_ = completion;
		_tmp30_ = g_strconcat (_tmp28_, _tmp29_, NULL);
		candidate = _tmp30_;
		_tmp31_ = folks_inspect_commands_set_completion_count;
		folks_inspect_commands_set_completion_count = _tmp31_ + 1;
		_tmp34_ = completion;
		if (_tmp34_ != NULL) {
			const gchar* _tmp35_;
			_tmp35_ = completion;
			_tmp33_ = g_strcmp0 (_tmp35_, "") != 0;
		} else {
			_tmp33_ = FALSE;
		}
		if (_tmp33_) {
			const gchar* _tmp36_;
			_tmp36_ = candidate;
			_tmp32_ = g_str_has_prefix (_tmp36_, word);
		} else {
			_tmp32_ = FALSE;
		}
		if (_tmp32_) {
			result = completion;
			_g_free0 (candidate);
			return result;
		}
		_g_free0 (candidate);
		_g_free0 (completion);
	}
	folks_inspect_commands_set_subcommand_completions = (_vala_array_free (folks_inspect_commands_set_subcommand_completions, _vala_array_length (folks_inspect_commands_set_subcommand_completions), (GDestroyNotify) g_free), NULL);
	folks_inspect_commands_set_subcommand_completions = NULL;
	folks_inspect_commands_set_completion_count = (guint) 0;
	_tmp37_ = g_strdup ("");
	_g_free0 (folks_inspect_commands_set_prefix);
	folks_inspect_commands_set_prefix = _tmp37_;
	result = NULL;
	return result;
}

static gchar*
_folks_inspect_commands_set_subcommand_name_completion_cb_rl_compentry_func_t (const gchar* str,
                                                                               gint a)
{
	gchar* result;
	result = folks_inspect_commands_set_subcommand_name_completion_cb (str, a);
	return result;
}

static gchar**
_vala_array_dup13 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
folks_inspect_commands_set_real_complete_subcommand (FolksInspectCommand* base,
                                                     const gchar* subcommand,
                                                     gint* result_length1)
{
	FolksInspectCommandsSet * self;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** result;
	self = (FolksInspectCommandsSet*) base;
	g_return_val_if_fail (subcommand != NULL, NULL);
	_tmp1_ = _tmp0_ = rl_completion_matches (subcommand, _folks_inspect_commands_set_subcommand_name_completion_cb_rl_compentry_func_t);
	_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup13 (_tmp1_, _vala_array_length (_tmp0_)) : _tmp1_;
	_tmp2__length1 = _vala_array_length (_tmp0_);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp2__length1;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}

static const gchar*
folks_inspect_commands_set_real_get_name (FolksInspectCommand* base)
{
	const gchar* result;
	FolksInspectCommandsSet* self;
	self = (FolksInspectCommandsSet*) base;
	result = "set";
	return result;
}

static const gchar*
folks_inspect_commands_set_real_get_description (FolksInspectCommand* base)
{
	const gchar* result;
	FolksInspectCommandsSet* self;
	self = (FolksInspectCommandsSet*) base;
	result = "Set an individual's properties";
	return result;
}

static const gchar*
folks_inspect_commands_set_real_get_help (FolksInspectCommand* base)
{
	const gchar* result;
	FolksInspectCommandsSet* self;
	self = (FolksInspectCommandsSet*) base;
	result = "set alias [individual UID] [new alias]" "   Set the alias of the given individual.";
	return result;
}

static void
folks_inspect_commands_set_class_init (FolksInspectCommandsSetClass * klass,
                                       gpointer klass_data)
{
	folks_inspect_commands_set_parent_class = g_type_class_peek_parent (klass);
	((FolksInspectCommandClass *) klass)->finalize = folks_inspect_commands_set_finalize;
	((FolksInspectCommandClass *) klass)->run = (void (*) (FolksInspectCommand*, const gchar*, GAsyncReadyCallback, gpointer)) folks_inspect_commands_set_real_run;
	((FolksInspectCommandClass *) klass)->run_finish = (gint (*) (FolksInspectCommand*, GAsyncResult*)) folks_inspect_commands_set_run_finish;
	((FolksInspectCommandClass *) klass)->complete_subcommand = (gchar** (*) (FolksInspectCommand*, const gchar*, gint*)) folks_inspect_commands_set_real_complete_subcommand;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->get_name = (const gchar* (*) (FolksInspectCommand*)) folks_inspect_commands_set_real_get_name;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->get_description = (const gchar* (*) (FolksInspectCommand*)) folks_inspect_commands_set_real_get_description;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->get_help = (const gchar* (*) (FolksInspectCommand*)) folks_inspect_commands_set_real_get_help;
}

static void
folks_inspect_commands_set_instance_init (FolksInspectCommandsSet * self,
                                          gpointer klass)
{
}

static void
folks_inspect_commands_set_finalize (FolksInspectCommand * obj)
{
	FolksInspectCommandsSet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_INSPECT_COMMANDS_TYPE_SET, FolksInspectCommandsSet);
	FOLKS_INSPECT_COMMAND_CLASS (folks_inspect_commands_set_parent_class)->finalize (obj);
}

static GType
folks_inspect_commands_set_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksInspectCommandsSetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_inspect_commands_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksInspectCommandsSet), 0, (GInstanceInitFunc) folks_inspect_commands_set_instance_init, NULL };
	GType folks_inspect_commands_set_type_id;
	folks_inspect_commands_set_type_id = g_type_register_static (FOLKS_INSPECT_TYPE_COMMAND, "FolksInspectCommandsSet", &g_define_type_info, 0);
	return folks_inspect_commands_set_type_id;
}

GType
folks_inspect_commands_set_get_type (void)
{
	static volatile gsize folks_inspect_commands_set_type_id__once = 0;
	if (g_once_init_enter (&folks_inspect_commands_set_type_id__once)) {
		GType folks_inspect_commands_set_type_id;
		folks_inspect_commands_set_type_id = folks_inspect_commands_set_get_type_once ();
		g_once_init_leave (&folks_inspect_commands_set_type_id__once, folks_inspect_commands_set_type_id);
	}
	return folks_inspect_commands_set_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

