/* PreviewColors.c generated by valac 0.56.18, the Vala compiler
 * generated from PreviewColors.vala, do not modify */

/* PreviewColors.vala
 *
 * Copyright (C) 2022-2025 Jerry Casiano
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.
 *
 * If not, see <http://www.gnu.org/licenses/gpl-3.0.txt>.
*/

#include "vala-common.h"
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	FONT_MANAGER_PREVIEW_COLORS_0_PROPERTY,
	FONT_MANAGER_PREVIEW_COLORS_FOREGROUND_COLOR_PROPERTY,
	FONT_MANAGER_PREVIEW_COLORS_BACKGROUND_COLOR_PROPERTY,
	FONT_MANAGER_PREVIEW_COLORS_SETTINGS_PROPERTY,
	FONT_MANAGER_PREVIEW_COLORS_NUM_PROPERTIES
};
static GParamSpec* font_manager_preview_colors_properties[FONT_MANAGER_PREVIEW_COLORS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	FONT_MANAGER_PREVIEW_COLORS_STYLE_UPDATED_SIGNAL,
	FONT_MANAGER_PREVIEW_COLORS_NUM_SIGNALS
};
static guint font_manager_preview_colors_signals[FONT_MANAGER_PREVIEW_COLORS_NUM_SIGNALS] = {0};

struct _FontManagerPreviewColorsPrivate {
	GdkRGBA _foreground_color;
	GdkRGBA _background_color;
	GSettings* _settings;
	GtkColorDialogButton* bg_color_button;
	GtkColorDialogButton* fg_color_button;
	GtkCssProvider* css_provider;
};

static gint FontManagerPreviewColors_private_offset;
static gpointer font_manager_preview_colors_parent_class = NULL;

static void font_manager_preview_colors_flatten_color_button (FontManagerPreviewColors* self,
                                                       GtkColorDialogButton* button);
static void font_manager_preview_colors_update_default_colors_if_needed (FontManagerPreviewColors* self);
static void __lambda4_ (FontManagerPreviewColors* self,
                 const gchar* key);
static void ___lambda4__g_settings_changed (GSettings* _sender,
                                     const gchar* key,
                                     gpointer self);
static void font_manager_preview_colors_real_constructed (GObject* base);
static void __lambda5_ (FontManagerPreviewColors* self);
static void ___lambda5__gtk_widget_map (GtkWidget* _sender,
                                 gpointer self);
static gboolean _gdk_rgba_equal (const GdkRGBA * s1,
                          const GdkRGBA * s2);
static void font_manager_preview_colors_finalize (GObject * obj);
static GType font_manager_preview_colors_get_type_once (void);
static void _vala_font_manager_preview_colors_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_font_manager_preview_colors_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);

static inline gpointer
font_manager_preview_colors_get_instance_private (FontManagerPreviewColors* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerPreviewColors_private_offset);
}

void
font_manager_preview_colors_update_style (FontManagerPreviewColors* self)
{
	GtkCssProvider* _tmp0_;
	GdkRGBA _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GdkRGBA _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GdkRGBA _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GdkRGBA _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->css_provider;
	_tmp1_ = self->priv->_foreground_color;
	_tmp2_ = gdk_rgba_to_string (&_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->_background_color;
	_tmp5_ = gdk_rgba_to_string (&_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = self->priv->_background_color;
	_tmp8_ = gdk_rgba_to_string (&_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = self->priv->_foreground_color;
	_tmp11_ = gdk_rgba_to_string (&_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strconcat (".FontManagerFontPreviewArea {color: ", _tmp3_, ";background-color: ", _tmp6_, ";} .FontManagerFontPreviewArea text selection {color: ", _tmp9_, ";background-color: ", _tmp12_, ";}", NULL);
	_tmp14_ = _tmp13_;
	gtk_css_provider_load_from_string (_tmp0_, _tmp14_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	g_signal_emit (self, font_manager_preview_colors_signals[FONT_MANAGER_PREVIEW_COLORS_STYLE_UPDATED_SIGNAL], 0);
	return;
}

static void
font_manager_preview_colors_flatten_color_button (FontManagerPreviewColors* self,
                                                  GtkColorDialogButton* button)
{
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = gtk_widget_get_first_child ((GtkWidget*) button);
	gtk_widget_remove_css_class (_tmp0_, "color");
	_tmp1_ = gtk_widget_get_first_child ((GtkWidget*) button);
	gtk_widget_add_css_class (_tmp1_, "flat");
	return;
}

static void
font_manager_preview_colors_update_default_colors_if_needed (FontManagerPreviewColors* self)
{
	GSettings* _tmp0_;
	gboolean prefer_dark = FALSE;
	GSettings* _tmp1_;
	GdkRGBA default_light_bg = {0};
	GdkRGBA default_light_fg = {0};
	GdkRGBA default_dark_bg = {0};
	GdkRGBA default_dark_fg = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_settings;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->_settings;
	prefer_dark = g_settings_get_boolean (_tmp1_, "prefer-dark-theme");
	memset (&default_light_bg, 0, sizeof (GdkRGBA));
	memset (&default_light_fg, 0, sizeof (GdkRGBA));
	memset (&default_dark_bg, 0, sizeof (GdkRGBA));
	memset (&default_dark_fg, 0, sizeof (GdkRGBA));
	gdk_rgba_parse (&default_light_bg, "white");
	gdk_rgba_parse (&default_light_fg, "black");
	gdk_rgba_parse (&default_dark_bg, "black");
	gdk_rgba_parse (&default_dark_fg, "white");
	if (prefer_dark) {
		gboolean _tmp2_ = FALSE;
		GdkRGBA _tmp3_;
		GdkRGBA _tmp4_;
		_tmp3_ = self->priv->_foreground_color;
		_tmp4_ = default_light_fg;
		if (gdk_rgba_equal (&_tmp3_, &_tmp4_)) {
			GdkRGBA _tmp5_;
			GdkRGBA _tmp6_;
			_tmp5_ = self->priv->_background_color;
			_tmp6_ = default_light_bg;
			_tmp2_ = gdk_rgba_equal (&_tmp5_, &_tmp6_);
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			GdkRGBA _tmp7_;
			GdkRGBA _tmp8_;
			_tmp7_ = default_dark_fg;
			font_manager_preview_colors_set_foreground_color (self, &_tmp7_);
			_tmp8_ = default_dark_bg;
			font_manager_preview_colors_set_background_color (self, &_tmp8_);
		}
	} else {
		gboolean _tmp9_ = FALSE;
		GdkRGBA _tmp10_;
		GdkRGBA _tmp11_;
		_tmp10_ = self->priv->_foreground_color;
		_tmp11_ = default_dark_fg;
		if (gdk_rgba_equal (&_tmp10_, &_tmp11_)) {
			GdkRGBA _tmp12_;
			GdkRGBA _tmp13_;
			_tmp12_ = self->priv->_background_color;
			_tmp13_ = default_dark_bg;
			_tmp9_ = gdk_rgba_equal (&_tmp12_, &_tmp13_);
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			GdkRGBA _tmp14_;
			GdkRGBA _tmp15_;
			_tmp14_ = default_light_fg;
			font_manager_preview_colors_set_foreground_color (self, &_tmp14_);
			_tmp15_ = default_light_bg;
			font_manager_preview_colors_set_background_color (self, &_tmp15_);
		}
	}
	return;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
__lambda4_ (FontManagerPreviewColors* self,
            const gchar* key)
{
	g_return_if_fail (key != NULL);
	if (string_contains (key, "color")) {
		font_manager_preview_colors_update_style (self);
	}
	if (string_contains (key, "dark")) {
		font_manager_preview_colors_update_default_colors_if_needed (self);
		font_manager_preview_colors_update_style (self);
	}
}

static void
___lambda4__g_settings_changed (GSettings* _sender,
                                const gchar* key,
                                gpointer self)
{
	__lambda4_ ((FontManagerPreviewColors*) self, key);
}

void
font_manager_preview_colors_restore_state (FontManagerPreviewColors* self,
                                           GSettings* settings)
{
	GSettingsBindFlags flags = 0U;
	GtkColorDialogButton* _tmp0_;
	GtkColorDialogButton* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	font_manager_preview_colors_set_settings (self, settings);
	if (settings == NULL) {
		return;
	}
	flags = G_SETTINGS_BIND_DEFAULT;
	_tmp0_ = self->priv->fg_color_button;
	g_settings_bind_with_mapping (settings, "preview-foreground-color", (GObject*) _tmp0_, "rgba", flags, (GSettingsBindGetMapping) font_manager_preview_colors_from_setting, (GSettingsBindSetMapping) font_manager_preview_colors_to_setting, NULL, NULL);
	_tmp1_ = self->priv->bg_color_button;
	g_settings_bind_with_mapping (settings, "preview-background-color", (GObject*) _tmp1_, "rgba", flags, (GSettingsBindGetMapping) font_manager_preview_colors_from_setting, (GSettingsBindSetMapping) font_manager_preview_colors_to_setting, NULL, NULL);
	g_signal_connect_object (settings, "changed", (GCallback) ___lambda4__g_settings_changed, self, 0);
	font_manager_preview_colors_update_default_colors_if_needed (self);
	font_manager_preview_colors_update_style (self);
	return;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda5_ (FontManagerPreviewColors* self)
{
	font_manager_preview_colors_update_default_colors_if_needed (self);
	font_manager_preview_colors_update_style (self);
}

static void
___lambda5__gtk_widget_map (GtkWidget* _sender,
                            gpointer self)
{
	__lambda5_ ((FontManagerPreviewColors*) self);
}

static void
font_manager_preview_colors_real_constructed (GObject* base)
{
	FontManagerPreviewColors * self;
	GtkColorDialogButton* _tmp0_;
	GtkColorDialogButton* _tmp1_;
	GtkCssProvider* _tmp2_;
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp3_;
	GdkDisplay* _tmp4_;
	GtkCssProvider* _tmp5_;
	GBindingFlags flags = 0U;
	GtkColorDialogButton* _tmp6_;
	GtkColorDialogButton* _tmp7_;
	self = (FontManagerPreviewColors*) base;
	_tmp0_ = self->priv->bg_color_button;
	font_manager_preview_colors_flatten_color_button (self, _tmp0_);
	_tmp1_ = self->priv->fg_color_button;
	font_manager_preview_colors_flatten_color_button (self, _tmp1_);
	_tmp2_ = gtk_css_provider_new ();
	_g_object_unref0 (self->priv->css_provider);
	self->priv->css_provider = _tmp2_;
	_tmp3_ = gdk_display_get_default ();
	_tmp4_ = _g_object_ref0 (_tmp3_);
	display = _tmp4_;
	_tmp5_ = self->priv->css_provider;
	gtk_style_context_add_provider_for_display (display, (GtkStyleProvider*) _tmp5_, (guint) GTK_STYLE_PROVIDER_PRIORITY_USER);
	flags = G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE;
	_tmp6_ = self->priv->bg_color_button;
	g_object_bind_property_with_closures ((GObject*) _tmp6_, "rgba", (GObject*) self, "background-color", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp7_ = self->priv->fg_color_button;
	g_object_bind_property_with_closures ((GObject*) _tmp7_, "rgba", (GObject*) self, "foreground-color", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	g_signal_connect_object ((GtkWidget*) self, "map", (GCallback) ___lambda5__gtk_widget_map, self, 0);
	G_OBJECT_CLASS (font_manager_preview_colors_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_box_get_type (), GtkBox));
	_g_object_unref0 (display);
	return;
}

GVariant*
font_manager_preview_colors_to_setting (GValue* val,
                                        const GVariantType* type)
{
	GValue _tmp0_;
	GdkRGBA* _tmp1_;
	GdkRGBA _tmp2_ = {0};
	GdkRGBA _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
	GVariant* result;
	g_return_val_if_fail (val != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp0_ = *val;
	_tmp1_ = g_value_get_boxed (&_tmp0_);
	_tmp3_ = (G_VALUE_HOLDS (&_tmp0_, gdk_rgba_get_type ()) && _tmp1_) ? (*_tmp1_) : (g_warning ("Invalid GValue unboxing (wrong type or NULL)"), _tmp2_);
	_tmp4_ = gdk_rgba_to_string (&_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_variant_new_string (_tmp5_);
	g_variant_ref_sink (_tmp6_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	result = _tmp7_;
	return result;
}

gboolean
font_manager_preview_colors_from_setting (GValue* val,
                                          GVariant* variant)
{
	GdkRGBA rgba = {0};
	gchar* rgba_string = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _result_ = FALSE;
	gboolean result;
	g_return_val_if_fail (val != NULL, FALSE);
	g_return_val_if_fail (variant != NULL, FALSE);
	memset (&rgba, 0, sizeof (GdkRGBA));
	_tmp0_ = g_variant_get_string (variant, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	rgba_string = _tmp1_;
	_result_ = gdk_rgba_parse (&rgba, rgba_string);
	g_value_set_boxed (val, &rgba);
	result = _result_;
	_g_free0 (rgba_string);
	return result;
}

FontManagerPreviewColors*
font_manager_preview_colors_construct (GType object_type)
{
	FontManagerPreviewColors * self = NULL;
	self = (FontManagerPreviewColors*) g_object_new (object_type, NULL);
	return self;
}

FontManagerPreviewColors*
font_manager_preview_colors_new (void)
{
	return font_manager_preview_colors_construct (FONT_MANAGER_TYPE_PREVIEW_COLORS);
}

void
font_manager_preview_colors_get_foreground_color (FontManagerPreviewColors* self,
                                                  GdkRGBA * result)
{
	GdkRGBA _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_foreground_color;
	*result = _tmp0_;
	return;
}

static gboolean
_gdk_rgba_equal (const GdkRGBA * s1,
                 const GdkRGBA * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->red != s2->red) {
		return FALSE;
	}
	if (s1->green != s2->green) {
		return FALSE;
	}
	if (s1->blue != s2->blue) {
		return FALSE;
	}
	if (s1->alpha != s2->alpha) {
		return FALSE;
	}
	return TRUE;
}

void
font_manager_preview_colors_set_foreground_color (FontManagerPreviewColors* self,
                                                  GdkRGBA * value)
{
	GdkRGBA old_value;
	g_return_if_fail (self != NULL);
	font_manager_preview_colors_get_foreground_color (self, &old_value);
	if (_gdk_rgba_equal (value, &old_value) != TRUE) {
		GdkRGBA _tmp0_;
		_tmp0_ = *value;
		self->priv->_foreground_color = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_preview_colors_properties[FONT_MANAGER_PREVIEW_COLORS_FOREGROUND_COLOR_PROPERTY]);
	}
}

void
font_manager_preview_colors_get_background_color (FontManagerPreviewColors* self,
                                                  GdkRGBA * result)
{
	GdkRGBA _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_background_color;
	*result = _tmp0_;
	return;
}

void
font_manager_preview_colors_set_background_color (FontManagerPreviewColors* self,
                                                  GdkRGBA * value)
{
	GdkRGBA old_value;
	g_return_if_fail (self != NULL);
	font_manager_preview_colors_get_background_color (self, &old_value);
	if (_gdk_rgba_equal (value, &old_value) != TRUE) {
		GdkRGBA _tmp0_;
		_tmp0_ = *value;
		self->priv->_background_color = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_preview_colors_properties[FONT_MANAGER_PREVIEW_COLORS_BACKGROUND_COLOR_PROPERTY]);
	}
}

GSettings*
font_manager_preview_colors_get_settings (FontManagerPreviewColors* self)
{
	GSettings* result;
	GSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_settings;
	result = _tmp0_;
	return result;
}

void
font_manager_preview_colors_set_settings (FontManagerPreviewColors* self,
                                          GSettings* value)
{
	GSettings* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_preview_colors_get_settings (self);
	if (old_value != value) {
		GSettings* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_settings);
		self->priv->_settings = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_preview_colors_properties[FONT_MANAGER_PREVIEW_COLORS_SETTINGS_PROPERTY]);
	}
}

static void
font_manager_preview_colors_class_init (FontManagerPreviewColorsClass * klass,
                                        gpointer klass_data)
{
	font_manager_preview_colors_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerPreviewColors_private_offset);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) font_manager_preview_colors_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_preview_colors_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_preview_colors_set_property;
	G_OBJECT_CLASS (klass)->finalize = font_manager_preview_colors_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_PREVIEW_COLORS_FOREGROUND_COLOR_PROPERTY, font_manager_preview_colors_properties[FONT_MANAGER_PREVIEW_COLORS_FOREGROUND_COLOR_PROPERTY] = g_param_spec_boxed ("foreground-color", "foreground-color", "foreground-color", gdk_rgba_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_PREVIEW_COLORS_BACKGROUND_COLOR_PROPERTY, font_manager_preview_colors_properties[FONT_MANAGER_PREVIEW_COLORS_BACKGROUND_COLOR_PROPERTY] = g_param_spec_boxed ("background-color", "background-color", "background-color", gdk_rgba_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_PREVIEW_COLORS_SETTINGS_PROPERTY, font_manager_preview_colors_properties[FONT_MANAGER_PREVIEW_COLORS_SETTINGS_PROPERTY] = g_param_spec_object ("settings", "settings", "settings", g_settings_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/github/FontManager/FontManager/ui/font-manager-preview-colors.ui");
	font_manager_preview_colors_signals[FONT_MANAGER_PREVIEW_COLORS_STYLE_UPDATED_SIGNAL] = g_signal_new ("style-updated", FONT_MANAGER_TYPE_PREVIEW_COLORS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "bg_color_button", FALSE, FontManagerPreviewColors_private_offset + G_STRUCT_OFFSET (FontManagerPreviewColorsPrivate, bg_color_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "fg_color_button", FALSE, FontManagerPreviewColors_private_offset + G_STRUCT_OFFSET (FontManagerPreviewColorsPrivate, fg_color_button));
}

static void
font_manager_preview_colors_instance_init (FontManagerPreviewColors * self,
                                           gpointer klass)
{
	self->priv = font_manager_preview_colors_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
font_manager_preview_colors_finalize (GObject * obj)
{
	FontManagerPreviewColors * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_PREVIEW_COLORS, FontManagerPreviewColors);
	_g_object_unref0 (self->priv->_settings);
	_g_object_unref0 (self->priv->css_provider);
	G_OBJECT_CLASS (font_manager_preview_colors_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_preview_colors_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerPreviewColorsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_preview_colors_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerPreviewColors), 0, (GInstanceInitFunc) font_manager_preview_colors_instance_init, NULL };
	GType font_manager_preview_colors_type_id;
	font_manager_preview_colors_type_id = g_type_register_static (gtk_box_get_type (), "FontManagerPreviewColors", &g_define_type_info, 0);
	FontManagerPreviewColors_private_offset = g_type_add_instance_private (font_manager_preview_colors_type_id, sizeof (FontManagerPreviewColorsPrivate));
	return font_manager_preview_colors_type_id;
}

GType
font_manager_preview_colors_get_type (void)
{
	static volatile gsize font_manager_preview_colors_type_id__once = 0;
	if (g_once_init_enter (&font_manager_preview_colors_type_id__once)) {
		GType font_manager_preview_colors_type_id;
		font_manager_preview_colors_type_id = font_manager_preview_colors_get_type_once ();
		g_once_init_leave (&font_manager_preview_colors_type_id__once, font_manager_preview_colors_type_id);
	}
	return font_manager_preview_colors_type_id__once;
}

static void
_vala_font_manager_preview_colors_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	FontManagerPreviewColors * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_PREVIEW_COLORS, FontManagerPreviewColors);
	switch (property_id) {
		case FONT_MANAGER_PREVIEW_COLORS_FOREGROUND_COLOR_PROPERTY:
		{
			GdkRGBA boxed;
			font_manager_preview_colors_get_foreground_color (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		case FONT_MANAGER_PREVIEW_COLORS_BACKGROUND_COLOR_PROPERTY:
		{
			GdkRGBA boxed;
			font_manager_preview_colors_get_background_color (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		case FONT_MANAGER_PREVIEW_COLORS_SETTINGS_PROPERTY:
		g_value_set_object (value, font_manager_preview_colors_get_settings (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_preview_colors_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	FontManagerPreviewColors * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_PREVIEW_COLORS, FontManagerPreviewColors);
	switch (property_id) {
		case FONT_MANAGER_PREVIEW_COLORS_FOREGROUND_COLOR_PROPERTY:
		font_manager_preview_colors_set_foreground_color (self, g_value_get_boxed (value));
		break;
		case FONT_MANAGER_PREVIEW_COLORS_BACKGROUND_COLOR_PROPERTY:
		font_manager_preview_colors_set_background_color (self, g_value_get_boxed (value));
		break;
		case FONT_MANAGER_PREVIEW_COLORS_SETTINGS_PROPERTY:
		font_manager_preview_colors_set_settings (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

