/* Library.c generated by valac 0.56.18, the Vala compiler
 * generated from Library.vala, do not modify */

/* Library.vala
 *
 * Copyright (C) 2009-2025 Jerry Casiano
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.
 *
 * If not, see <http://www.gnu.org/licenses/gpl-3.0.txt>.
*/

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include "font-manager.h"
#include <glib/gstdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))

#define FONT_MANAGER_LIBRARY_TYPE_INSTALLER (font_manager_library_installer_get_type ())
#define FONT_MANAGER_LIBRARY_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_LIBRARY_TYPE_INSTALLER, FontManagerLibraryInstaller))
#define FONT_MANAGER_LIBRARY_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_LIBRARY_TYPE_INSTALLER, FontManagerLibraryInstallerClass))
#define FONT_MANAGER_LIBRARY_IS_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_LIBRARY_TYPE_INSTALLER))
#define FONT_MANAGER_LIBRARY_IS_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_LIBRARY_TYPE_INSTALLER))
#define FONT_MANAGER_LIBRARY_INSTALLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_LIBRARY_TYPE_INSTALLER, FontManagerLibraryInstallerClass))

typedef struct _FontManagerLibraryInstaller FontManagerLibraryInstaller;
typedef struct _FontManagerLibraryInstallerClass FontManagerLibraryInstallerClass;
typedef struct _FontManagerLibraryInstallerPrivate FontManagerLibraryInstallerPrivate;
enum  {
	FONT_MANAGER_LIBRARY_INSTALLER_0_PROPERTY,
	FONT_MANAGER_LIBRARY_INSTALLER_NUM_PROPERTIES
};
static GParamSpec* font_manager_library_installer_properties[FONT_MANAGER_LIBRARY_INSTALLER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define FONT_MANAGER_LIBRARY_TYPE_SORTER (font_manager_library_sorter_get_type ())
#define FONT_MANAGER_LIBRARY_SORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_LIBRARY_TYPE_SORTER, FontManagerLibrarySorter))
#define FONT_MANAGER_LIBRARY_SORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_LIBRARY_TYPE_SORTER, FontManagerLibrarySorterClass))
#define FONT_MANAGER_LIBRARY_IS_SORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_LIBRARY_TYPE_SORTER))
#define FONT_MANAGER_LIBRARY_IS_SORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_LIBRARY_TYPE_SORTER))
#define FONT_MANAGER_LIBRARY_SORTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_LIBRARY_TYPE_SORTER, FontManagerLibrarySorterClass))

typedef struct _FontManagerLibrarySorter FontManagerLibrarySorter;
typedef struct _FontManagerLibrarySorterClass FontManagerLibrarySorterClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define FONT_MANAGER_TYPE_ARCHIVE_MANAGER (font_manager_archive_manager_get_type ())
#define FONT_MANAGER_ARCHIVE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_ARCHIVE_MANAGER, FontManagerArchiveManager))
#define FONT_MANAGER_ARCHIVE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_ARCHIVE_MANAGER, FontManagerArchiveManagerClass))
#define FONT_MANAGER_IS_ARCHIVE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_ARCHIVE_MANAGER))
#define FONT_MANAGER_IS_ARCHIVE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_ARCHIVE_MANAGER))
#define FONT_MANAGER_ARCHIVE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_ARCHIVE_MANAGER, FontManagerArchiveManagerClass))

typedef struct _FontManagerArchiveManager FontManagerArchiveManager;
typedef struct _FontManagerArchiveManagerClass FontManagerArchiveManagerClass;
enum  {
	FONT_MANAGER_LIBRARY_INSTALLER_PROGRESS_SIGNAL,
	FONT_MANAGER_LIBRARY_INSTALLER_NUM_SIGNALS
};
static guint font_manager_library_installer_signals[FONT_MANAGER_LIBRARY_INSTALLER_NUM_SIGNALS] = {0};
typedef struct _FontManagerLibrarySorterPrivate FontManagerLibrarySorterPrivate;
enum  {
	FONT_MANAGER_LIBRARY_SORTER_0_PROPERTY,
	FONT_MANAGER_LIBRARY_SORTER_FONTS_PROPERTY,
	FONT_MANAGER_LIBRARY_SORTER_ARCHIVES_PROPERTY,
	FONT_MANAGER_LIBRARY_SORTER_TOTAL_PROPERTY,
	FONT_MANAGER_LIBRARY_SORTER_NUM_PROPERTIES
};
static GParamSpec* font_manager_library_sorter_properties[FONT_MANAGER_LIBRARY_SORTER_NUM_PROPERTIES];
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FontManagerLibraryInstaller {
	GObject parent_instance;
	FontManagerLibraryInstallerPrivate * priv;
};

struct _FontManagerLibraryInstallerClass {
	GObjectClass parent_class;
};

struct _FontManagerLibraryInstallerPrivate {
	GFile* tmp_file;
};

struct _FontManagerLibrarySorter {
	GObject parent_instance;
	FontManagerLibrarySorterPrivate * priv;
};

struct _FontManagerLibrarySorterClass {
	GObjectClass parent_class;
};

struct _FontManagerLibrarySorterPrivate {
	FontManagerStringSet* _fonts;
	FontManagerStringSet* _archives;
};

static gint FontManagerLibraryInstaller_private_offset;
static gpointer font_manager_library_installer_parent_class = NULL;
static gint FontManagerLibrarySorter_private_offset;
static gpointer font_manager_library_sorter_parent_class = NULL;

VALA_EXTERN gboolean font_manager_library_is_metrics_file (const gchar* name);
VALA_EXTERN GType font_manager_library_installer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerLibraryInstaller, g_object_unref)
VALA_EXTERN void font_manager_library_installer_process_sync (FontManagerLibraryInstaller* self,
                                                  FontManagerStringSet* filelist);
VALA_EXTERN GType font_manager_library_sorter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerLibrarySorter, g_object_unref)
VALA_EXTERN FontManagerLibrarySorter* font_manager_library_sorter_new (void);
VALA_EXTERN FontManagerLibrarySorter* font_manager_library_sorter_construct (GType object_type);
VALA_EXTERN void font_manager_library_sorter_sort (FontManagerLibrarySorter* self,
                                       FontManagerStringSet* filelist);
static void font_manager_library_installer_process_files (FontManagerLibraryInstaller* self,
                                                   FontManagerStringSet* filelist);
VALA_EXTERN FontManagerStringSet* font_manager_library_sorter_get_fonts (FontManagerLibrarySorter* self);
static void font_manager_library_installer_process_archives (FontManagerLibraryInstaller* self,
                                                      FontManagerStringSet* filelist);
VALA_EXTERN FontManagerStringSet* font_manager_library_sorter_get_archives (FontManagerLibrarySorter* self);
VALA_EXTERN gboolean font_manager_remove_directory (GFile* dir,
                                        gboolean recursive);
static void font_manager_library_installer_install_filelist (GTask* task,
                                                      GObject* source,
                                                      void* data,
                                                      GCancellable* cancellable);
VALA_EXTERN void font_manager_library_installer_process (FontManagerLibraryInstaller* self,
                                             FontManagerStringSet* filelist,
                                             GAsyncReadyCallback callback,
                                             gpointer callback_target);
static void _font_manager_library_installer_install_filelist_gtask_thread_func (GTask* task,
                                                                         GObject* source_object,
                                                                         void* task_data,
                                                                         GCancellable* cancellable);
VALA_EXTERN GType font_manager_archive_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerArchiveManager, g_object_unref)
VALA_EXTERN FontManagerArchiveManager* font_manager_archive_manager_new (void);
VALA_EXTERN FontManagerArchiveManager* font_manager_archive_manager_construct (GType object_type);
VALA_EXTERN gboolean font_manager_archive_manager_extract (FontManagerArchiveManager* self,
                                               GFile* file,
                                               GFile* dest_dir);
VALA_EXTERN FontManagerLibraryInstaller* font_manager_library_installer_new (void);
VALA_EXTERN FontManagerLibraryInstaller* font_manager_library_installer_construct (GType object_type);
static void g_cclosure_user_marshal_VOID__STRING_UINT_UINT (GClosure * closure,
                                                     GValue * return_value,
                                                     guint n_param_values,
                                                     const GValue * param_values,
                                                     gpointer invocation_hint,
                                                     gpointer marshal_data);
static void font_manager_library_installer_finalize (GObject * obj);
static GType font_manager_library_installer_get_type_once (void);
static void font_manager_library_sorter_set_fonts (FontManagerLibrarySorter* self,
                                            FontManagerStringSet* value);
static void font_manager_library_sorter_set_archives (FontManagerLibrarySorter* self,
                                               FontManagerStringSet* value);
static void font_manager_library_sorter_process_files (FontManagerLibrarySorter* self,
                                                FontManagerStringSet* filelist);
static void font_manager_library_sorter_process_directory (FontManagerLibrarySorter* self,
                                                    GFile* dir);
static gboolean _vala_string_array_contains (const gchar* * stack,
                                      gssize stack_length,
                                      const const gchar* needle);
VALA_EXTERN guint font_manager_library_sorter_get_total (FontManagerLibrarySorter* self);
static void font_manager_library_sorter_finalize (GObject * obj);
static GType font_manager_library_sorter_get_type_once (void);
static void _vala_font_manager_library_sorter_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_font_manager_library_sorter_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

const gchar* FONT_MANAGER_LIBRARY_TYPE1_METRICS[3] = {".afm", ".pfa", ".pfm"};
VALA_EXTERN const gchar* FONT_MANAGER_LIBARCHIVE_MIME_TYPES[26];

gboolean
font_manager_library_is_metrics_file (const gchar* name)
{
	gboolean result;
	g_return_val_if_fail (name != NULL, FALSE);
	{
		const gchar** ext_collection = NULL;
		gint ext_collection_length1 = 0;
		gint _ext_collection_size_ = 0;
		gint ext_it = 0;
		ext_collection = FONT_MANAGER_LIBRARY_TYPE1_METRICS;
		ext_collection_length1 = G_N_ELEMENTS (FONT_MANAGER_LIBRARY_TYPE1_METRICS);
		for (ext_it = 0; ext_it < ext_collection_length1; ext_it = ext_it + 1) {
			const gchar* ext = NULL;
			ext = ext_collection[ext_it];
			{
				gchar* _tmp0_;
				gchar* _tmp1_;
				const gchar* _tmp2_;
				gboolean _tmp3_;
				_tmp0_ = g_utf8_strdown (name, (gssize) -1);
				_tmp1_ = _tmp0_;
				_tmp2_ = ext;
				_tmp3_ = g_str_has_suffix (_tmp1_, _tmp2_);
				_g_free0 (_tmp1_);
				if (_tmp3_) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}

static inline gpointer
font_manager_library_installer_get_instance_private (FontManagerLibraryInstaller* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerLibraryInstaller_private_offset);
}

void
font_manager_library_installer_process_sync (FontManagerLibraryInstaller* self,
                                             FontManagerStringSet* filelist)
{
	FontManagerLibrarySorter* sorter = NULL;
	FontManagerLibrarySorter* _tmp0_;
	FontManagerLibrarySorter* _tmp1_;
	FontManagerLibrarySorter* _tmp2_;
	FontManagerStringSet* _tmp3_;
	FontManagerStringSet* _tmp4_;
	FontManagerLibrarySorter* _tmp5_;
	FontManagerStringSet* _tmp6_;
	FontManagerStringSet* _tmp7_;
	GFile* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filelist != NULL);
	_tmp0_ = font_manager_library_sorter_new ();
	sorter = _tmp0_;
	_tmp1_ = sorter;
	font_manager_library_sorter_sort (_tmp1_, filelist);
	_tmp2_ = sorter;
	_tmp3_ = font_manager_library_sorter_get_fonts (_tmp2_);
	_tmp4_ = _tmp3_;
	font_manager_library_installer_process_files (self, _tmp4_);
	_tmp5_ = sorter;
	_tmp6_ = font_manager_library_sorter_get_archives (_tmp5_);
	_tmp7_ = _tmp6_;
	font_manager_library_installer_process_archives (self, _tmp7_);
	_tmp8_ = self->priv->tmp_file;
	if (_tmp8_ != NULL) {
		GFile* _tmp9_;
		_tmp9_ = self->priv->tmp_file;
		font_manager_remove_directory (_tmp9_, TRUE);
	}
	_g_object_unref0 (self->priv->tmp_file);
	self->priv->tmp_file = NULL;
	_g_object_unref0 (sorter);
	return;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
font_manager_library_installer_install_filelist (GTask* task,
                                                 GObject* source,
                                                 void* data,
                                                 GCancellable* cancellable)
{
	FontManagerLibraryInstaller* _self_ = NULL;
	FontManagerLibraryInstaller* _tmp0_;
	FontManagerStringSet* filelist = NULL;
	FontManagerLibraryInstaller* _tmp1_;
	gconstpointer _tmp2_;
	FontManagerStringSet* _tmp3_;
	FontManagerLibrarySorter* sorter = NULL;
	FontManagerLibrarySorter* _tmp4_;
	FontManagerLibrarySorter* _tmp5_;
	FontManagerStringSet* _tmp6_;
	FontManagerLibraryInstaller* _tmp7_;
	FontManagerLibrarySorter* _tmp8_;
	FontManagerStringSet* _tmp9_;
	FontManagerStringSet* _tmp10_;
	FontManagerLibraryInstaller* _tmp11_;
	FontManagerLibrarySorter* _tmp12_;
	FontManagerStringSet* _tmp13_;
	FontManagerStringSet* _tmp14_;
	FontManagerLibraryInstaller* _tmp15_;
	GFile* _tmp16_;
	FontManagerLibraryInstaller* _tmp19_;
	FontManagerLibraryInstaller* _tmp20_;
	g_return_if_fail (task != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (FONT_MANAGER_LIBRARY_IS_INSTALLER (source));
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (source, FONT_MANAGER_LIBRARY_TYPE_INSTALLER, FontManagerLibraryInstaller));
	_self_ = _tmp0_;
	_tmp1_ = _self_;
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "filelist");
	_tmp3_ = _g_object_ref0 ((FontManagerStringSet*) _tmp2_);
	filelist = _tmp3_;
	_tmp4_ = font_manager_library_sorter_new ();
	sorter = _tmp4_;
	_tmp5_ = sorter;
	_tmp6_ = filelist;
	font_manager_library_sorter_sort (_tmp5_, _tmp6_);
	_tmp7_ = _self_;
	_tmp8_ = sorter;
	_tmp9_ = font_manager_library_sorter_get_fonts (_tmp8_);
	_tmp10_ = _tmp9_;
	font_manager_library_installer_process_files (_tmp7_, _tmp10_);
	_tmp11_ = _self_;
	_tmp12_ = sorter;
	_tmp13_ = font_manager_library_sorter_get_archives (_tmp12_);
	_tmp14_ = _tmp13_;
	font_manager_library_installer_process_archives (_tmp11_, _tmp14_);
	_tmp15_ = _self_;
	_tmp16_ = _tmp15_->priv->tmp_file;
	if (_tmp16_ != NULL) {
		FontManagerLibraryInstaller* _tmp17_;
		GFile* _tmp18_;
		_tmp17_ = _self_;
		_tmp18_ = _tmp17_->priv->tmp_file;
		font_manager_remove_directory (_tmp18_, TRUE);
	}
	_tmp19_ = _self_;
	_g_object_unref0 (_tmp19_->priv->tmp_file);
	_tmp19_->priv->tmp_file = NULL;
	_tmp20_ = _self_;
	g_object_set_data_full ((GObject*) _tmp20_, "filelist", NULL, NULL);
	_g_object_unref0 (filelist);
	filelist = NULL;
	_g_object_unref0 (sorter);
	_g_object_unref0 (filelist);
	_g_object_unref0 (_self_);
	return;
}

static void
_font_manager_library_installer_install_filelist_gtask_thread_func (GTask* task,
                                                                    GObject* source_object,
                                                                    void* task_data,
                                                                    GCancellable* cancellable)
{
	font_manager_library_installer_install_filelist (task, source_object, task_data, cancellable);
}

void
font_manager_library_installer_process (FontManagerLibraryInstaller* self,
                                        FontManagerStringSet* filelist,
                                        GAsyncReadyCallback callback,
                                        gpointer callback_target)
{
	FontManagerStringSet* _tmp0_;
	GTask* task = NULL;
	GTask* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filelist != NULL);
	_tmp0_ = _g_object_ref0 (filelist);
	g_object_set_data_full ((GObject*) self, "filelist", _tmp0_, g_object_unref);
	_tmp1_ = g_task_new ((GObject*) self, NULL, callback, callback_target);
	task = _tmp1_;
	g_task_run_in_thread (task, _font_manager_library_installer_install_filelist_gtask_thread_func);
	_g_object_unref0 (task);
	return;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
font_manager_library_installer_process_files (FontManagerLibraryInstaller* self,
                                              FontManagerStringSet* filelist)
{
	guint total = 0U;
	guint _tmp0_;
	guint _tmp1_;
	guint processed = 0U;
	GFile* install_dir = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filelist != NULL);
	g_object_get (filelist, "size", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	total = _tmp1_;
	processed = (guint) 0;
	_tmp2_ = font_manager_get_user_font_directory ();
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_new_for_path (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	install_dir = _tmp5_;
	{
		FontManagerStringSet* _path_list = NULL;
		guint _path_size = 0U;
		FontManagerStringSet* _tmp6_;
		guint _tmp7_;
		guint _tmp8_;
		gint _path_index = 0;
		_path_list = filelist;
		_tmp6_ = _path_list;
		g_object_get (_tmp6_, "size", &_tmp7_, NULL);
		_tmp8_ = _tmp7_;
		_path_size = _tmp8_;
		_path_index = -1;
		while (TRUE) {
			gint _tmp9_;
			guint _tmp10_;
			gchar* path = NULL;
			FontManagerStringSet* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			gboolean _tmp14_ = FALSE;
			const gchar* _tmp15_;
			GFile* file = NULL;
			const gchar* _tmp17_;
			GFile* _tmp18_;
			guint _tmp24_;
			_path_index = _path_index + 1;
			_tmp9_ = _path_index;
			_tmp10_ = _path_size;
			if (!(((guint) _tmp9_) < _tmp10_)) {
				break;
			}
			_tmp11_ = _path_list;
			_tmp12_ = font_manager_string_set_get (_tmp11_, (guint) _path_index);
			_tmp13_ = g_strdup (_tmp12_);
			path = _tmp13_;
			_tmp15_ = path;
			if (string_contains (_tmp15_, "XtraStuf.mac")) {
				_tmp14_ = TRUE;
			} else {
				const gchar* _tmp16_;
				_tmp16_ = path;
				_tmp14_ = string_contains (_tmp16_, "__MACOSX");
			}
			if (_tmp14_) {
				_g_free0 (path);
				continue;
			}
			_tmp17_ = path;
			_tmp18_ = g_file_new_for_path (_tmp17_);
			file = _tmp18_;
			{
				GFile* _tmp19_;
				GFile* _tmp20_;
				_tmp19_ = file;
				_tmp20_ = install_dir;
				font_manager_install_file (_tmp19_, _tmp20_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp21_ = e;
				_tmp22_ = _tmp21_->message;
				_tmp23_ = path;
				g_critical ("Library.vala:92: %s : %s", _tmp22_, _tmp23_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file);
				_g_free0 (path);
				_g_object_unref0 (install_dir);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp24_ = processed;
			processed = _tmp24_ + 1;
			{
				GFileInfo* info = NULL;
				GFile* _tmp25_;
				GFileInfo* _tmp26_;
				GFileInfo* _tmp27_;
				const gchar* _tmp28_;
				_tmp25_ = file;
				_tmp26_ = g_file_query_info (_tmp25_, G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
				info = _tmp26_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				_tmp27_ = info;
				_tmp28_ = g_file_info_get_display_name (_tmp27_);
				g_signal_emit (self, font_manager_library_installer_signals[FONT_MANAGER_LIBRARY_INSTALLER_PROGRESS_SIGNAL], 0, _tmp28_, processed, total);
				_g_object_unref0 (info);
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				GError* _tmp29_;
				const gchar* _tmp30_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp29_ = e;
				_tmp30_ = _tmp29_->message;
				g_warning ("Library.vala:99: %s", _tmp30_);
				_g_error_free0 (e);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file);
				_g_free0 (path);
				_g_object_unref0 (install_dir);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_g_object_unref0 (file);
			_g_free0 (path);
		}
	}
	_g_object_unref0 (install_dir);
	return;
}

static void
font_manager_library_installer_process_archives (FontManagerLibraryInstaller* self,
                                                 FontManagerStringSet* filelist)
{
	gboolean _tmp0_ = FALSE;
	GFile* _tmp3_;
	FontManagerArchiveManager* libarchive = NULL;
	FontManagerArchiveManager* _tmp10_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (filelist == NULL) {
		_tmp0_ = TRUE;
	} else {
		guint _tmp1_;
		guint _tmp2_;
		g_object_get (filelist, "size", &_tmp1_, NULL);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == ((guint) 0);
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = self->priv->tmp_file;
	if (_tmp3_ == NULL) {
		{
			gchar* _tmp4_ = NULL;
			gchar* _tmp5_;
			GFile* _tmp6_;
			GFile* _tmp7_;
			_tmp5_ = g_dir_make_tmp (FONT_MANAGER_TMP_TMPL, &_inner_error0_);
			_tmp4_ = _tmp5_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp6_ = g_file_new_for_path (_tmp4_);
			_g_object_unref0 (self->priv->tmp_file);
			self->priv->tmp_file = _tmp6_;
			_tmp7_ = self->priv->tmp_file;
			_vala_assert (g_file_query_exists (_tmp7_, NULL), "tmp_file.query_exists()");
			_g_free0 (_tmp4_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp8_;
			const gchar* _tmp9_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp8_ = e;
			_tmp9_ = _tmp8_->message;
			g_critical ("Library.vala:118: %s", _tmp9_);
			_g_error_free0 (e);
			return;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp10_ = font_manager_archive_manager_new ();
	libarchive = _tmp10_;
	{
		FontManagerStringSet* _path_list = NULL;
		guint _path_size = 0U;
		FontManagerStringSet* _tmp11_;
		guint _tmp12_;
		guint _tmp13_;
		gint _path_index = 0;
		_path_list = filelist;
		_tmp11_ = _path_list;
		g_object_get (_tmp11_, "size", &_tmp12_, NULL);
		_tmp13_ = _tmp12_;
		_path_size = _tmp13_;
		_path_index = -1;
		while (TRUE) {
			gint _tmp14_;
			guint _tmp15_;
			gchar* path = NULL;
			FontManagerStringSet* _tmp16_;
			const gchar* _tmp17_;
			gchar* _tmp18_;
			GFile* file = NULL;
			const gchar* _tmp19_;
			GFile* _tmp20_;
			gchar* tmp_path = NULL;
			GFile* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			GFile* tmp = NULL;
			const gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			GFile* _tmp30_;
			GFile* _tmp31_;
			GFile* _tmp32_;
			FontManagerArchiveManager* _tmp37_;
			GFile* _tmp38_;
			GFile* _tmp39_;
			FontManagerLibrarySorter* sorter = NULL;
			FontManagerLibrarySorter* _tmp41_;
			FontManagerStringSet* list = NULL;
			FontManagerStringSet* _tmp42_;
			FontManagerStringSet* _tmp43_;
			GFile* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			FontManagerLibrarySorter* _tmp47_;
			FontManagerStringSet* _tmp48_;
			FontManagerLibrarySorter* _tmp49_;
			FontManagerStringSet* _tmp50_;
			FontManagerStringSet* _tmp51_;
			FontManagerLibrarySorter* _tmp52_;
			FontManagerStringSet* _tmp53_;
			FontManagerStringSet* _tmp54_;
			_path_index = _path_index + 1;
			_tmp14_ = _path_index;
			_tmp15_ = _path_size;
			if (!(((guint) _tmp14_) < _tmp15_)) {
				break;
			}
			_tmp16_ = _path_list;
			_tmp17_ = font_manager_string_set_get (_tmp16_, (guint) _path_index);
			_tmp18_ = g_strdup (_tmp17_);
			path = _tmp18_;
			_tmp19_ = path;
			_tmp20_ = g_file_new_for_path (_tmp19_);
			file = _tmp20_;
			_tmp21_ = self->priv->tmp_file;
			_tmp22_ = g_file_get_path (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = g_build_filename (_tmp23_, "archive_XXXXXX", NULL);
			_tmp25_ = _tmp24_;
			_g_free0 (_tmp23_);
			tmp_path = _tmp25_;
			_tmp26_ = tmp_path;
			_tmp27_ = g_strdup (_tmp26_);
			_tmp28_ = mkdtemp (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = g_file_new_for_path (_tmp29_);
			_tmp31_ = _tmp30_;
			_g_free0 (_tmp29_);
			tmp = _tmp31_;
			_tmp32_ = tmp;
			if (!g_file_query_exists (_tmp32_, NULL)) {
				GFile* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				const gchar* _tmp36_;
				_tmp33_ = tmp;
				_tmp34_ = g_file_get_path (_tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = path;
				g_critical ("Library.vala:132: Failed to create temporary directory : %s for %s", _tmp35_, _tmp36_);
				_g_free0 (_tmp35_);
				_g_object_unref0 (tmp);
				_g_free0 (tmp_path);
				_g_object_unref0 (file);
				_g_free0 (path);
				continue;
			}
			_tmp37_ = libarchive;
			_tmp38_ = file;
			_tmp39_ = tmp;
			if (!font_manager_archive_manager_extract (_tmp37_, _tmp38_, _tmp39_)) {
				const gchar* _tmp40_;
				_tmp40_ = path;
				g_critical ("Library.vala:137: Failed to extract archive : %s", _tmp40_);
				_g_object_unref0 (tmp);
				_g_free0 (tmp_path);
				_g_object_unref0 (file);
				_g_free0 (path);
				continue;
			}
			_tmp41_ = font_manager_library_sorter_new ();
			sorter = _tmp41_;
			_tmp42_ = font_manager_string_set_new ();
			list = _tmp42_;
			_tmp43_ = list;
			_tmp44_ = tmp;
			_tmp45_ = g_file_get_path (_tmp44_);
			_tmp46_ = _tmp45_;
			font_manager_string_set_add (_tmp43_, _tmp46_);
			_g_free0 (_tmp46_);
			_tmp47_ = sorter;
			_tmp48_ = list;
			font_manager_library_sorter_sort (_tmp47_, _tmp48_);
			_tmp49_ = sorter;
			_tmp50_ = font_manager_library_sorter_get_fonts (_tmp49_);
			_tmp51_ = _tmp50_;
			font_manager_library_installer_process_files (self, _tmp51_);
			_tmp52_ = sorter;
			_tmp53_ = font_manager_library_sorter_get_archives (_tmp52_);
			_tmp54_ = _tmp53_;
			font_manager_library_installer_process_archives (self, _tmp54_);
			_g_object_unref0 (list);
			_g_object_unref0 (sorter);
			_g_object_unref0 (tmp);
			_g_free0 (tmp_path);
			_g_object_unref0 (file);
			_g_free0 (path);
		}
	}
	_g_object_unref0 (libarchive);
	return;
}

FontManagerLibraryInstaller*
font_manager_library_installer_construct (GType object_type)
{
	FontManagerLibraryInstaller * self = NULL;
	self = (FontManagerLibraryInstaller*) g_object_new (object_type, NULL);
	return self;
}

FontManagerLibraryInstaller*
font_manager_library_installer_new (void)
{
	return font_manager_library_installer_construct (FONT_MANAGER_LIBRARY_TYPE_INSTALLER);
}

static void
g_cclosure_user_marshal_VOID__STRING_UINT_UINT (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_UINT_UINT) (gpointer data1, const char* arg_1, guint arg_2, guint arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_uint (param_values + 2), g_value_get_uint (param_values + 3), data2);
}

static void
font_manager_library_installer_class_init (FontManagerLibraryInstallerClass * klass,
                                           gpointer klass_data)
{
	font_manager_library_installer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerLibraryInstaller_private_offset);
	G_OBJECT_CLASS (klass)->finalize = font_manager_library_installer_finalize;
	font_manager_library_installer_signals[FONT_MANAGER_LIBRARY_INSTALLER_PROGRESS_SIGNAL] = g_signal_new ("progress", FONT_MANAGER_LIBRARY_TYPE_INSTALLER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_UINT_UINT, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_UINT);
}

static void
font_manager_library_installer_instance_init (FontManagerLibraryInstaller * self,
                                              gpointer klass)
{
	self->priv = font_manager_library_installer_get_instance_private (self);
	self->priv->tmp_file = NULL;
}

static void
font_manager_library_installer_finalize (GObject * obj)
{
	FontManagerLibraryInstaller * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_LIBRARY_TYPE_INSTALLER, FontManagerLibraryInstaller);
	_g_object_unref0 (self->priv->tmp_file);
	G_OBJECT_CLASS (font_manager_library_installer_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_library_installer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerLibraryInstallerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_library_installer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerLibraryInstaller), 0, (GInstanceInitFunc) font_manager_library_installer_instance_init, NULL };
	GType font_manager_library_installer_type_id;
	font_manager_library_installer_type_id = g_type_register_static (G_TYPE_OBJECT, "FontManagerLibraryInstaller", &g_define_type_info, 0);
	FontManagerLibraryInstaller_private_offset = g_type_add_instance_private (font_manager_library_installer_type_id, sizeof (FontManagerLibraryInstallerPrivate));
	return font_manager_library_installer_type_id;
}

GType
font_manager_library_installer_get_type (void)
{
	static volatile gsize font_manager_library_installer_type_id__once = 0;
	if (g_once_init_enter (&font_manager_library_installer_type_id__once)) {
		GType font_manager_library_installer_type_id;
		font_manager_library_installer_type_id = font_manager_library_installer_get_type_once ();
		g_once_init_leave (&font_manager_library_installer_type_id__once, font_manager_library_installer_type_id);
	}
	return font_manager_library_installer_type_id__once;
}

static inline gpointer
font_manager_library_sorter_get_instance_private (FontManagerLibrarySorter* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerLibrarySorter_private_offset);
}

void
font_manager_library_sorter_sort (FontManagerLibrarySorter* self,
                                  FontManagerStringSet* filelist)
{
	FontManagerStringSet* _tmp0_;
	FontManagerStringSet* _tmp1_;
	FontManagerStringSet* _tmp2_;
	FontManagerStringSet* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filelist != NULL);
	_tmp0_ = font_manager_string_set_new ();
	_tmp1_ = _tmp0_;
	font_manager_library_sorter_set_fonts (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = font_manager_string_set_new ();
	_tmp3_ = _tmp2_;
	font_manager_library_sorter_set_archives (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	font_manager_library_sorter_process_files (self, filelist);
	return;
}

static void
font_manager_library_sorter_process_directory (FontManagerLibrarySorter* self,
                                               GFile* dir)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dir != NULL);
	{
		FontManagerStringSet* files = NULL;
		FontManagerStringSet* _tmp0_;
		GFileInfo* fileinfo = NULL;
		gchar* attrs = NULL;
		gchar* _tmp1_;
		GFileEnumerator* enumerator = NULL;
		const gchar* _tmp2_;
		GFileEnumerator* _tmp3_;
		FontManagerStringSet* _tmp23_;
		_tmp0_ = font_manager_string_set_new ();
		files = _tmp0_;
		_tmp1_ = g_strdup_printf ("%s,%s,%s", G_FILE_ATTRIBUTE_STANDARD_NAME, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_ATTRIBUTE_STANDARD_TYPE);
		attrs = _tmp1_;
		_tmp2_ = attrs;
		_tmp3_ = g_file_enumerate_children (dir, _tmp2_, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		enumerator = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (attrs);
			_g_object_unref0 (fileinfo);
			_g_object_unref0 (files);
			goto __catch0_g_error;
		}
		while (TRUE) {
			GFileInfo* _tmp4_ = NULL;
			GFileEnumerator* _tmp5_;
			GFileInfo* _tmp6_;
			GFileInfo* _tmp7_;
			GFileInfo* _tmp8_;
			gchar* name = NULL;
			GFileInfo* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* path = NULL;
			const gchar* _tmp12_;
			GFile* _tmp13_;
			GFile* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			GFileInfo* _tmp17_;
			_tmp5_ = enumerator;
			_tmp6_ = g_file_enumerator_next_file (_tmp5_, NULL, &_inner_error0_);
			_tmp4_ = _tmp6_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (enumerator);
				_g_free0 (attrs);
				_g_object_unref0 (fileinfo);
				_g_object_unref0 (files);
				goto __catch0_g_error;
			}
			_tmp7_ = _tmp4_;
			_tmp4_ = NULL;
			_g_object_unref0 (fileinfo);
			fileinfo = _tmp7_;
			_tmp8_ = fileinfo;
			if (!(_tmp8_ != NULL)) {
				_g_object_unref0 (_tmp4_);
				break;
			}
			_tmp9_ = fileinfo;
			_tmp10_ = g_file_info_get_name (_tmp9_);
			_tmp11_ = g_strdup (_tmp10_);
			name = _tmp11_;
			_tmp12_ = name;
			_tmp13_ = g_file_get_child (dir, _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = g_file_get_path (_tmp14_);
			_tmp16_ = _tmp15_;
			_g_object_unref0 (_tmp14_);
			path = _tmp16_;
			_tmp17_ = fileinfo;
			if (g_file_info_get_file_type (_tmp17_) == G_FILE_TYPE_DIRECTORY) {
				const gchar* _tmp18_;
				GFile* _tmp19_;
				GFile* _tmp20_;
				_tmp18_ = name;
				_tmp19_ = g_file_get_child (dir, _tmp18_);
				_tmp20_ = _tmp19_;
				font_manager_library_sorter_process_directory (self, _tmp20_);
				_g_object_unref0 (_tmp20_);
			} else {
				FontManagerStringSet* _tmp21_;
				const gchar* _tmp22_;
				_tmp21_ = files;
				_tmp22_ = path;
				font_manager_string_set_add (_tmp21_, _tmp22_);
			}
			_g_free0 (path);
			_g_free0 (name);
			_g_object_unref0 (_tmp4_);
		}
		_tmp23_ = files;
		font_manager_library_sorter_process_files (self, _tmp23_);
		_g_object_unref0 (enumerator);
		_g_free0 (attrs);
		_g_object_unref0 (fileinfo);
		_g_object_unref0 (files);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp24_;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp24_ = e;
		_tmp25_ = _tmp24_->message;
		_tmp26_ = g_file_get_path (dir);
		_tmp27_ = _tmp26_;
		g_warning ("Library.vala:195: %s :: %s", _tmp25_, _tmp27_);
		_g_free0 (_tmp27_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	return;
}

static gboolean
_vala_string_array_contains (const gchar* * stack,
                             gssize stack_length,
                             const const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
font_manager_library_sorter_process_files (FontManagerLibrarySorter* self,
                                           FontManagerStringSet* filelist)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filelist != NULL);
	{
		FontManagerStringSet* _path_list = NULL;
		guint _path_size = 0U;
		FontManagerStringSet* _tmp0_;
		guint _tmp1_;
		guint _tmp2_;
		gint _path_index = 0;
		_path_list = filelist;
		_tmp0_ = _path_list;
		g_object_get (_tmp0_, "size", &_tmp1_, NULL);
		_tmp2_ = _tmp1_;
		_path_size = _tmp2_;
		_path_index = -1;
		while (TRUE) {
			gint _tmp3_;
			guint _tmp4_;
			gchar* path = NULL;
			FontManagerStringSet* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			GFile* file = NULL;
			const gchar* _tmp8_;
			GFile* _tmp9_;
			gchar* attrs = NULL;
			gchar* _tmp10_;
			_path_index = _path_index + 1;
			_tmp3_ = _path_index;
			_tmp4_ = _path_size;
			if (!(((guint) _tmp3_) < _tmp4_)) {
				break;
			}
			_tmp5_ = _path_list;
			_tmp6_ = font_manager_string_set_get (_tmp5_, (guint) _path_index);
			_tmp7_ = g_strdup (_tmp6_);
			path = _tmp7_;
			_tmp8_ = path;
			_tmp9_ = g_file_new_for_path (_tmp8_);
			file = _tmp9_;
			_tmp10_ = g_strdup_printf ("%s,%s,%s", G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_ATTRIBUTE_STANDARD_NAME);
			attrs = _tmp10_;
			{
				GFileInfo* fileinfo = NULL;
				GFile* _tmp11_;
				const gchar* _tmp12_;
				GFileInfo* _tmp13_;
				gchar* name = NULL;
				GFileInfo* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* content_type = NULL;
				GFileInfo* _tmp17_;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* filepath = NULL;
				GFile* _tmp20_;
				gchar* _tmp21_;
				GFileInfo* _tmp22_;
				_tmp11_ = file;
				_tmp12_ = attrs;
				_tmp13_ = g_file_query_info (_tmp11_, _tmp12_, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
				fileinfo = _tmp13_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp14_ = fileinfo;
				_tmp15_ = g_file_info_get_name (_tmp14_);
				_tmp16_ = g_strdup (_tmp15_);
				name = _tmp16_;
				_tmp17_ = fileinfo;
				_tmp18_ = g_file_info_get_content_type (_tmp17_);
				_tmp19_ = g_strdup (_tmp18_);
				content_type = _tmp19_;
				_tmp20_ = file;
				_tmp21_ = g_file_get_path (_tmp20_);
				filepath = _tmp21_;
				_tmp22_ = fileinfo;
				if (g_file_info_get_file_type (_tmp22_) == G_FILE_TYPE_DIRECTORY) {
					GFile* _tmp23_;
					_tmp23_ = file;
					font_manager_library_sorter_process_directory (self, _tmp23_);
				} else {
					gboolean _tmp24_ = FALSE;
					const gchar* _tmp25_;
					_tmp25_ = content_type;
					if (string_contains (_tmp25_, "font")) {
						const gchar* _tmp26_;
						_tmp26_ = name;
						_tmp24_ = !font_manager_library_is_metrics_file (_tmp26_);
					} else {
						_tmp24_ = FALSE;
					}
					if (_tmp24_) {
						FontManagerStringSet* _tmp27_;
						const gchar* _tmp28_;
						_tmp27_ = self->priv->_fonts;
						_tmp28_ = filepath;
						font_manager_string_set_add (_tmp27_, _tmp28_);
					} else {
						const gchar* _tmp29_;
						_tmp29_ = content_type;
						if (_vala_string_array_contains (FONT_MANAGER_LIBARCHIVE_MIME_TYPES, G_N_ELEMENTS (FONT_MANAGER_LIBARCHIVE_MIME_TYPES), _tmp29_)) {
							FontManagerStringSet* _tmp30_;
							const gchar* _tmp31_;
							_tmp30_ = self->priv->_archives;
							_tmp31_ = filepath;
							font_manager_string_set_add (_tmp30_, _tmp31_);
						} else {
							const gchar* _tmp32_;
							_tmp32_ = name;
							g_message ("Library.vala:221: Ignoring unsupported filetype : %s", _tmp32_);
						}
					}
				}
				_g_free0 (filepath);
				_g_free0 (content_type);
				_g_free0 (name);
				_g_object_unref0 (fileinfo);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp33_;
				const gchar* _tmp34_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp33_ = e;
				_tmp34_ = _tmp33_->message;
				g_critical ("Library.vala:223: Error querying file information : %s", _tmp34_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (attrs);
				_g_object_unref0 (file);
				_g_free0 (path);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_g_free0 (attrs);
			_g_object_unref0 (file);
			_g_free0 (path);
		}
	}
	return;
}

FontManagerLibrarySorter*
font_manager_library_sorter_construct (GType object_type)
{
	FontManagerLibrarySorter * self = NULL;
	self = (FontManagerLibrarySorter*) g_object_new (object_type, NULL);
	return self;
}

FontManagerLibrarySorter*
font_manager_library_sorter_new (void)
{
	return font_manager_library_sorter_construct (FONT_MANAGER_LIBRARY_TYPE_SORTER);
}

FontManagerStringSet*
font_manager_library_sorter_get_fonts (FontManagerLibrarySorter* self)
{
	FontManagerStringSet* result;
	FontManagerStringSet* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_fonts;
	result = _tmp0_;
	return result;
}

static void
font_manager_library_sorter_set_fonts (FontManagerLibrarySorter* self,
                                       FontManagerStringSet* value)
{
	FontManagerStringSet* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_library_sorter_get_fonts (self);
	if (old_value != value) {
		FontManagerStringSet* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_fonts);
		self->priv->_fonts = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_library_sorter_properties[FONT_MANAGER_LIBRARY_SORTER_FONTS_PROPERTY]);
	}
}

FontManagerStringSet*
font_manager_library_sorter_get_archives (FontManagerLibrarySorter* self)
{
	FontManagerStringSet* result;
	FontManagerStringSet* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_archives;
	result = _tmp0_;
	return result;
}

static void
font_manager_library_sorter_set_archives (FontManagerLibrarySorter* self,
                                          FontManagerStringSet* value)
{
	FontManagerStringSet* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_library_sorter_get_archives (self);
	if (old_value != value) {
		FontManagerStringSet* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_archives);
		self->priv->_archives = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_library_sorter_properties[FONT_MANAGER_LIBRARY_SORTER_ARCHIVES_PROPERTY]);
	}
}

guint
font_manager_library_sorter_get_total (FontManagerLibrarySorter* self)
{
	guint result;
	FontManagerStringSet* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	FontManagerStringSet* _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_fonts;
	g_object_get (_tmp0_, "size", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_archives;
	g_object_get (_tmp3_, "size", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	result = _tmp2_ + _tmp5_;
	return result;
}

static void
font_manager_library_sorter_class_init (FontManagerLibrarySorterClass * klass,
                                        gpointer klass_data)
{
	font_manager_library_sorter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerLibrarySorter_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_library_sorter_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_library_sorter_set_property;
	G_OBJECT_CLASS (klass)->finalize = font_manager_library_sorter_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_LIBRARY_SORTER_FONTS_PROPERTY, font_manager_library_sorter_properties[FONT_MANAGER_LIBRARY_SORTER_FONTS_PROPERTY] = g_param_spec_object ("fonts", "fonts", "fonts", font_manager_string_set_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_LIBRARY_SORTER_ARCHIVES_PROPERTY, font_manager_library_sorter_properties[FONT_MANAGER_LIBRARY_SORTER_ARCHIVES_PROPERTY] = g_param_spec_object ("archives", "archives", "archives", font_manager_string_set_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_LIBRARY_SORTER_TOTAL_PROPERTY, font_manager_library_sorter_properties[FONT_MANAGER_LIBRARY_SORTER_TOTAL_PROPERTY] = g_param_spec_uint ("total", "total", "total", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
font_manager_library_sorter_instance_init (FontManagerLibrarySorter * self,
                                           gpointer klass)
{
	self->priv = font_manager_library_sorter_get_instance_private (self);
	self->priv->_fonts = NULL;
	self->priv->_archives = NULL;
}

static void
font_manager_library_sorter_finalize (GObject * obj)
{
	FontManagerLibrarySorter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_LIBRARY_TYPE_SORTER, FontManagerLibrarySorter);
	_g_object_unref0 (self->priv->_fonts);
	_g_object_unref0 (self->priv->_archives);
	G_OBJECT_CLASS (font_manager_library_sorter_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_library_sorter_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerLibrarySorterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_library_sorter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerLibrarySorter), 0, (GInstanceInitFunc) font_manager_library_sorter_instance_init, NULL };
	GType font_manager_library_sorter_type_id;
	font_manager_library_sorter_type_id = g_type_register_static (G_TYPE_OBJECT, "FontManagerLibrarySorter", &g_define_type_info, 0);
	FontManagerLibrarySorter_private_offset = g_type_add_instance_private (font_manager_library_sorter_type_id, sizeof (FontManagerLibrarySorterPrivate));
	return font_manager_library_sorter_type_id;
}

GType
font_manager_library_sorter_get_type (void)
{
	static volatile gsize font_manager_library_sorter_type_id__once = 0;
	if (g_once_init_enter (&font_manager_library_sorter_type_id__once)) {
		GType font_manager_library_sorter_type_id;
		font_manager_library_sorter_type_id = font_manager_library_sorter_get_type_once ();
		g_once_init_leave (&font_manager_library_sorter_type_id__once, font_manager_library_sorter_type_id);
	}
	return font_manager_library_sorter_type_id__once;
}

static void
_vala_font_manager_library_sorter_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	FontManagerLibrarySorter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_LIBRARY_TYPE_SORTER, FontManagerLibrarySorter);
	switch (property_id) {
		case FONT_MANAGER_LIBRARY_SORTER_FONTS_PROPERTY:
		g_value_set_object (value, font_manager_library_sorter_get_fonts (self));
		break;
		case FONT_MANAGER_LIBRARY_SORTER_ARCHIVES_PROPERTY:
		g_value_set_object (value, font_manager_library_sorter_get_archives (self));
		break;
		case FONT_MANAGER_LIBRARY_SORTER_TOTAL_PROPERTY:
		g_value_set_uint (value, font_manager_library_sorter_get_total (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_library_sorter_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	FontManagerLibrarySorter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_LIBRARY_TYPE_SORTER, FontManagerLibrarySorter);
	switch (property_id) {
		case FONT_MANAGER_LIBRARY_SORTER_FONTS_PROPERTY:
		font_manager_library_sorter_set_fonts (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_LIBRARY_SORTER_ARCHIVES_PROPERTY:
		font_manager_library_sorter_set_archives (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

