/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "fprintd-dbus.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_VOID__STRING_BOOLEAN (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_StringBooleanFunc)
       (void *data1,
        const gchar *arg_result,
        gboolean arg_done,
        void *data2);
  _GDbusCodegenMarshalVoid_StringBooleanFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_StringBooleanFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_string (param_values + 1),
            g_marshal_value_peek_boolean (param_values + 2),
            data2);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_username,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface net.reactivated.Fprint.Device
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:FprintDBusDevice
 * @title: FprintDBusDevice
 * @short_description: Generated C code for the net.reactivated.Fprint.Device D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-net-reactivated-Fprint-Device.top_of_page">net.reactivated.Fprint.Device</link> D-Bus interface in C.
 */

enum
{
  FPRINT_DBUS__DEVICE_VERIFY_FINGER_SELECTED,
  FPRINT_DBUS__DEVICE_VERIFY_STATUS,
  FPRINT_DBUS__DEVICE_ENROLL_STATUS,
};

static unsigned FPRINT_DBUS__DEVICE_SIGNALS[3] = { 0 };

/* ---- Introspection data for net.reactivated.Fprint.Device ---- */

static const _ExtendedGDBusArgInfo _fprint_dbus_device_method_info_list_enrolled_fingers_IN_ARG_username =
{
  {
    -1,
    (gchar *) "username",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _fprint_dbus_device_method_info_list_enrolled_fingers_IN_ARG_pointers[] =
{
  &_fprint_dbus_device_method_info_list_enrolled_fingers_IN_ARG_username.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _fprint_dbus_device_method_info_list_enrolled_fingers_OUT_ARG_enrolled_fingers =
{
  {
    -1,
    (gchar *) "enrolled_fingers",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _fprint_dbus_device_method_info_list_enrolled_fingers_OUT_ARG_pointers[] =
{
  &_fprint_dbus_device_method_info_list_enrolled_fingers_OUT_ARG_enrolled_fingers.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _fprint_dbus_device_method_info_list_enrolled_fingers =
{
  {
    -1,
    (gchar *) "ListEnrolledFingers",
    (GDBusArgInfo **) &_fprint_dbus_device_method_info_list_enrolled_fingers_IN_ARG_pointers,
    (GDBusArgInfo **) &_fprint_dbus_device_method_info_list_enrolled_fingers_OUT_ARG_pointers,
    NULL
  },
  "handle-list-enrolled-fingers",
  FALSE
};

static const _ExtendedGDBusArgInfo _fprint_dbus_device_method_info_delete_enrolled_fingers_IN_ARG_username =
{
  {
    -1,
    (gchar *) "username",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _fprint_dbus_device_method_info_delete_enrolled_fingers_IN_ARG_pointers[] =
{
  &_fprint_dbus_device_method_info_delete_enrolled_fingers_IN_ARG_username.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _fprint_dbus_device_method_info_delete_enrolled_fingers =
{
  {
    -1,
    (gchar *) "DeleteEnrolledFingers",
    (GDBusArgInfo **) &_fprint_dbus_device_method_info_delete_enrolled_fingers_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-delete-enrolled-fingers",
  FALSE
};

static const _ExtendedGDBusMethodInfo _fprint_dbus_device_method_info_delete_enrolled_fingers2 =
{
  {
    -1,
    (gchar *) "DeleteEnrolledFingers2",
    NULL,
    NULL,
    NULL
  },
  "handle-delete-enrolled-fingers2",
  FALSE
};

static const _ExtendedGDBusArgInfo _fprint_dbus_device_method_info_delete_enrolled_finger_IN_ARG_finger_name =
{
  {
    -1,
    (gchar *) "finger_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _fprint_dbus_device_method_info_delete_enrolled_finger_IN_ARG_pointers[] =
{
  &_fprint_dbus_device_method_info_delete_enrolled_finger_IN_ARG_finger_name.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _fprint_dbus_device_method_info_delete_enrolled_finger =
{
  {
    -1,
    (gchar *) "DeleteEnrolledFinger",
    (GDBusArgInfo **) &_fprint_dbus_device_method_info_delete_enrolled_finger_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-delete-enrolled-finger",
  FALSE
};

static const _ExtendedGDBusArgInfo _fprint_dbus_device_method_info_claim_IN_ARG_username =
{
  {
    -1,
    (gchar *) "username",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _fprint_dbus_device_method_info_claim_IN_ARG_pointers[] =
{
  &_fprint_dbus_device_method_info_claim_IN_ARG_username.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _fprint_dbus_device_method_info_claim =
{
  {
    -1,
    (gchar *) "Claim",
    (GDBusArgInfo **) &_fprint_dbus_device_method_info_claim_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-claim",
  FALSE
};

static const _ExtendedGDBusMethodInfo _fprint_dbus_device_method_info_release =
{
  {
    -1,
    (gchar *) "Release",
    NULL,
    NULL,
    NULL
  },
  "handle-release",
  FALSE
};

static const _ExtendedGDBusArgInfo _fprint_dbus_device_method_info_verify_start_IN_ARG_finger_name =
{
  {
    -1,
    (gchar *) "finger_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _fprint_dbus_device_method_info_verify_start_IN_ARG_pointers[] =
{
  &_fprint_dbus_device_method_info_verify_start_IN_ARG_finger_name.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _fprint_dbus_device_method_info_verify_start =
{
  {
    -1,
    (gchar *) "VerifyStart",
    (GDBusArgInfo **) &_fprint_dbus_device_method_info_verify_start_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-verify-start",
  FALSE
};

static const _ExtendedGDBusMethodInfo _fprint_dbus_device_method_info_verify_stop =
{
  {
    -1,
    (gchar *) "VerifyStop",
    NULL,
    NULL,
    NULL
  },
  "handle-verify-stop",
  FALSE
};

static const _ExtendedGDBusArgInfo _fprint_dbus_device_method_info_enroll_start_IN_ARG_finger_name =
{
  {
    -1,
    (gchar *) "finger_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _fprint_dbus_device_method_info_enroll_start_IN_ARG_pointers[] =
{
  &_fprint_dbus_device_method_info_enroll_start_IN_ARG_finger_name.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _fprint_dbus_device_method_info_enroll_start =
{
  {
    -1,
    (gchar *) "EnrollStart",
    (GDBusArgInfo **) &_fprint_dbus_device_method_info_enroll_start_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-enroll-start",
  FALSE
};

static const _ExtendedGDBusMethodInfo _fprint_dbus_device_method_info_enroll_stop =
{
  {
    -1,
    (gchar *) "EnrollStop",
    NULL,
    NULL,
    NULL
  },
  "handle-enroll-stop",
  FALSE
};

static const GDBusMethodInfo * const _fprint_dbus_device_method_info_pointers[] =
{
  &_fprint_dbus_device_method_info_list_enrolled_fingers.parent_struct,
  &_fprint_dbus_device_method_info_delete_enrolled_fingers.parent_struct,
  &_fprint_dbus_device_method_info_delete_enrolled_fingers2.parent_struct,
  &_fprint_dbus_device_method_info_delete_enrolled_finger.parent_struct,
  &_fprint_dbus_device_method_info_claim.parent_struct,
  &_fprint_dbus_device_method_info_release.parent_struct,
  &_fprint_dbus_device_method_info_verify_start.parent_struct,
  &_fprint_dbus_device_method_info_verify_stop.parent_struct,
  &_fprint_dbus_device_method_info_enroll_start.parent_struct,
  &_fprint_dbus_device_method_info_enroll_stop.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _fprint_dbus_device_signal_info_verify_finger_selected_ARG_finger_name =
{
  {
    -1,
    (gchar *) "finger_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _fprint_dbus_device_signal_info_verify_finger_selected_ARG_pointers[] =
{
  &_fprint_dbus_device_signal_info_verify_finger_selected_ARG_finger_name.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _fprint_dbus_device_signal_info_verify_finger_selected =
{
  {
    -1,
    (gchar *) "VerifyFingerSelected",
    (GDBusArgInfo **) &_fprint_dbus_device_signal_info_verify_finger_selected_ARG_pointers,
    NULL
  },
  "verify-finger-selected"
};

static const _ExtendedGDBusArgInfo _fprint_dbus_device_signal_info_verify_status_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _fprint_dbus_device_signal_info_verify_status_ARG_done =
{
  {
    -1,
    (gchar *) "done",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _fprint_dbus_device_signal_info_verify_status_ARG_pointers[] =
{
  &_fprint_dbus_device_signal_info_verify_status_ARG_result.parent_struct,
  &_fprint_dbus_device_signal_info_verify_status_ARG_done.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _fprint_dbus_device_signal_info_verify_status =
{
  {
    -1,
    (gchar *) "VerifyStatus",
    (GDBusArgInfo **) &_fprint_dbus_device_signal_info_verify_status_ARG_pointers,
    NULL
  },
  "verify-status"
};

static const _ExtendedGDBusArgInfo _fprint_dbus_device_signal_info_enroll_status_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _fprint_dbus_device_signal_info_enroll_status_ARG_done =
{
  {
    -1,
    (gchar *) "done",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _fprint_dbus_device_signal_info_enroll_status_ARG_pointers[] =
{
  &_fprint_dbus_device_signal_info_enroll_status_ARG_result.parent_struct,
  &_fprint_dbus_device_signal_info_enroll_status_ARG_done.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _fprint_dbus_device_signal_info_enroll_status =
{
  {
    -1,
    (gchar *) "EnrollStatus",
    (GDBusArgInfo **) &_fprint_dbus_device_signal_info_enroll_status_ARG_pointers,
    NULL
  },
  "enroll-status"
};

static const GDBusSignalInfo * const _fprint_dbus_device_signal_info_pointers[] =
{
  &_fprint_dbus_device_signal_info_verify_finger_selected.parent_struct,
  &_fprint_dbus_device_signal_info_verify_status.parent_struct,
  &_fprint_dbus_device_signal_info_enroll_status.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _fprint_dbus_device_property_info_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "name",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _fprint_dbus_device_property_info_num_enroll_stages =
{
  {
    -1,
    (gchar *) "num-enroll-stages",
    (gchar *) "i",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "num-enroll-stages",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _fprint_dbus_device_property_info_scan_type =
{
  {
    -1,
    (gchar *) "scan-type",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "scan-type",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _fprint_dbus_device_property_info_finger_present =
{
  {
    -1,
    (gchar *) "finger-present",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "finger-present",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _fprint_dbus_device_property_info_finger_needed =
{
  {
    -1,
    (gchar *) "finger-needed",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "finger-needed",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _fprint_dbus_device_property_info_pointers[] =
{
  &_fprint_dbus_device_property_info_name.parent_struct,
  &_fprint_dbus_device_property_info_num_enroll_stages.parent_struct,
  &_fprint_dbus_device_property_info_scan_type.parent_struct,
  &_fprint_dbus_device_property_info_finger_present.parent_struct,
  &_fprint_dbus_device_property_info_finger_needed.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _fprint_dbus_device_interface_info =
{
  {
    -1,
    (gchar *) "net.reactivated.Fprint.Device",
    (GDBusMethodInfo **) &_fprint_dbus_device_method_info_pointers,
    (GDBusSignalInfo **) &_fprint_dbus_device_signal_info_pointers,
    (GDBusPropertyInfo **) &_fprint_dbus_device_property_info_pointers,
    NULL
  },
  "device",
};


/**
 * fprint_dbus_device_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-net-reactivated-Fprint-Device.top_of_page">net.reactivated.Fprint.Device</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
fprint_dbus_device_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_fprint_dbus_device_interface_info.parent_struct;
}

/**
 * fprint_dbus_device_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #FprintDBusDevice interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
fprint_dbus_device_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "name");
  g_object_class_override_property (klass, property_id_begin++, "num-enroll-stages");
  g_object_class_override_property (klass, property_id_begin++, "scan-type");
  g_object_class_override_property (klass, property_id_begin++, "finger-present");
  g_object_class_override_property (klass, property_id_begin++, "finger-needed");
  return property_id_begin - 1;
}


inline static void
fprint_dbus_device_signal_marshal_verify_finger_selected (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
fprint_dbus_device_signal_marshal_verify_status (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
fprint_dbus_device_signal_marshal_enroll_status (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
fprint_dbus_device_method_marshal_list_enrolled_fingers (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
fprint_dbus_device_method_marshal_delete_enrolled_fingers (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
fprint_dbus_device_method_marshal_delete_enrolled_fingers2 (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
fprint_dbus_device_method_marshal_delete_enrolled_finger (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
fprint_dbus_device_method_marshal_claim (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
fprint_dbus_device_method_marshal_release (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
fprint_dbus_device_method_marshal_verify_start (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
fprint_dbus_device_method_marshal_verify_stop (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
fprint_dbus_device_method_marshal_enroll_start (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
fprint_dbus_device_method_marshal_enroll_stop (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * FprintDBusDevice:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-net-reactivated-Fprint-Device.top_of_page">net.reactivated.Fprint.Device</link>.
 */

/**
 * FprintDBusDeviceIface:
 * @parent_iface: The parent interface.
 * @handle_claim: Handler for the #FprintDBusDevice::handle-claim signal.
 * @handle_delete_enrolled_finger: Handler for the #FprintDBusDevice::handle-delete-enrolled-finger signal.
 * @handle_delete_enrolled_fingers: Handler for the #FprintDBusDevice::handle-delete-enrolled-fingers signal.
 * @handle_delete_enrolled_fingers2: Handler for the #FprintDBusDevice::handle-delete-enrolled-fingers2 signal.
 * @handle_enroll_start: Handler for the #FprintDBusDevice::handle-enroll-start signal.
 * @handle_enroll_stop: Handler for the #FprintDBusDevice::handle-enroll-stop signal.
 * @handle_list_enrolled_fingers: Handler for the #FprintDBusDevice::handle-list-enrolled-fingers signal.
 * @handle_release: Handler for the #FprintDBusDevice::handle-release signal.
 * @handle_verify_start: Handler for the #FprintDBusDevice::handle-verify-start signal.
 * @handle_verify_stop: Handler for the #FprintDBusDevice::handle-verify-stop signal.
 * @get_finger_needed: Getter for the #FprintDBusDevice:finger-needed property.
 * @get_finger_present: Getter for the #FprintDBusDevice:finger-present property.
 * @get_name: Getter for the #FprintDBusDevice:name property.
 * @get_num_enroll_stages: Getter for the #FprintDBusDevice:num-enroll-stages property.
 * @get_scan_type: Getter for the #FprintDBusDevice:scan-type property.
 * @enroll_status: Handler for the #FprintDBusDevice::enroll-status signal.
 * @verify_finger_selected: Handler for the #FprintDBusDevice::verify-finger-selected signal.
 * @verify_status: Handler for the #FprintDBusDevice::verify-status signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-net-reactivated-Fprint-Device.top_of_page">net.reactivated.Fprint.Device</link>.
 */

typedef FprintDBusDeviceIface FprintDBusDeviceInterface;
G_DEFINE_INTERFACE (FprintDBusDevice, fprint_dbus_device, G_TYPE_OBJECT)

static void
fprint_dbus_device_default_init (FprintDBusDeviceIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * FprintDBusDevice::handle-list-enrolled-fingers:
   * @object: A #FprintDBusDevice.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_username: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-net-reactivated-Fprint-Device.ListEnrolledFingers">ListEnrolledFingers()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call fprint_dbus_device_complete_list_enrolled_fingers() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-list-enrolled-fingers",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (FprintDBusDeviceIface, handle_list_enrolled_fingers),
    g_signal_accumulator_true_handled,
    NULL,
      fprint_dbus_device_method_marshal_list_enrolled_fingers,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * FprintDBusDevice::handle-delete-enrolled-fingers:
   * @object: A #FprintDBusDevice.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_username: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-net-reactivated-Fprint-Device.DeleteEnrolledFingers">DeleteEnrolledFingers()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call fprint_dbus_device_complete_delete_enrolled_fingers() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-delete-enrolled-fingers",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (FprintDBusDeviceIface, handle_delete_enrolled_fingers),
    g_signal_accumulator_true_handled,
    NULL,
      fprint_dbus_device_method_marshal_delete_enrolled_fingers,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * FprintDBusDevice::handle-delete-enrolled-fingers2:
   * @object: A #FprintDBusDevice.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-net-reactivated-Fprint-Device.DeleteEnrolledFingers2">DeleteEnrolledFingers2()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call fprint_dbus_device_complete_delete_enrolled_fingers2() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-delete-enrolled-fingers2",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (FprintDBusDeviceIface, handle_delete_enrolled_fingers2),
    g_signal_accumulator_true_handled,
    NULL,
      fprint_dbus_device_method_marshal_delete_enrolled_fingers2,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * FprintDBusDevice::handle-delete-enrolled-finger:
   * @object: A #FprintDBusDevice.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_finger_name: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-net-reactivated-Fprint-Device.DeleteEnrolledFinger">DeleteEnrolledFinger()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call fprint_dbus_device_complete_delete_enrolled_finger() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-delete-enrolled-finger",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (FprintDBusDeviceIface, handle_delete_enrolled_finger),
    g_signal_accumulator_true_handled,
    NULL,
      fprint_dbus_device_method_marshal_delete_enrolled_finger,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * FprintDBusDevice::handle-claim:
   * @object: A #FprintDBusDevice.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_username: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-net-reactivated-Fprint-Device.Claim">Claim()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call fprint_dbus_device_complete_claim() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-claim",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (FprintDBusDeviceIface, handle_claim),
    g_signal_accumulator_true_handled,
    NULL,
      fprint_dbus_device_method_marshal_claim,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * FprintDBusDevice::handle-release:
   * @object: A #FprintDBusDevice.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-net-reactivated-Fprint-Device.Release">Release()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call fprint_dbus_device_complete_release() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-release",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (FprintDBusDeviceIface, handle_release),
    g_signal_accumulator_true_handled,
    NULL,
      fprint_dbus_device_method_marshal_release,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * FprintDBusDevice::handle-verify-start:
   * @object: A #FprintDBusDevice.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_finger_name: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-net-reactivated-Fprint-Device.VerifyStart">VerifyStart()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call fprint_dbus_device_complete_verify_start() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-verify-start",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (FprintDBusDeviceIface, handle_verify_start),
    g_signal_accumulator_true_handled,
    NULL,
      fprint_dbus_device_method_marshal_verify_start,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * FprintDBusDevice::handle-verify-stop:
   * @object: A #FprintDBusDevice.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-net-reactivated-Fprint-Device.VerifyStop">VerifyStop()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call fprint_dbus_device_complete_verify_stop() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-verify-stop",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (FprintDBusDeviceIface, handle_verify_stop),
    g_signal_accumulator_true_handled,
    NULL,
      fprint_dbus_device_method_marshal_verify_stop,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * FprintDBusDevice::handle-enroll-start:
   * @object: A #FprintDBusDevice.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_finger_name: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-net-reactivated-Fprint-Device.EnrollStart">EnrollStart()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call fprint_dbus_device_complete_enroll_start() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-enroll-start",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (FprintDBusDeviceIface, handle_enroll_start),
    g_signal_accumulator_true_handled,
    NULL,
      fprint_dbus_device_method_marshal_enroll_start,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * FprintDBusDevice::handle-enroll-stop:
   * @object: A #FprintDBusDevice.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-net-reactivated-Fprint-Device.EnrollStop">EnrollStop()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call fprint_dbus_device_complete_enroll_stop() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-enroll-stop",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (FprintDBusDeviceIface, handle_enroll_stop),
    g_signal_accumulator_true_handled,
    NULL,
      fprint_dbus_device_method_marshal_enroll_stop,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * FprintDBusDevice::verify-finger-selected:
   * @object: A #FprintDBusDevice.
   * @arg_finger_name: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-net-reactivated-Fprint-Device.VerifyFingerSelected">"VerifyFingerSelected"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  FPRINT_DBUS__DEVICE_SIGNALS[FPRINT_DBUS__DEVICE_VERIFY_FINGER_SELECTED] =
    g_signal_new ("verify-finger-selected",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (FprintDBusDeviceIface, verify_finger_selected),
      NULL,
      NULL,
      fprint_dbus_device_signal_marshal_verify_finger_selected,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /**
   * FprintDBusDevice::verify-status:
   * @object: A #FprintDBusDevice.
   * @arg_result: Argument.
   * @arg_done: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-net-reactivated-Fprint-Device.VerifyStatus">"VerifyStatus"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  FPRINT_DBUS__DEVICE_SIGNALS[FPRINT_DBUS__DEVICE_VERIFY_STATUS] =
    g_signal_new ("verify-status",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (FprintDBusDeviceIface, verify_status),
      NULL,
      NULL,
      fprint_dbus_device_signal_marshal_verify_status,
      G_TYPE_NONE,
      2, G_TYPE_STRING, G_TYPE_BOOLEAN);

  /**
   * FprintDBusDevice::enroll-status:
   * @object: A #FprintDBusDevice.
   * @arg_result: Argument.
   * @arg_done: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-net-reactivated-Fprint-Device.EnrollStatus">"EnrollStatus"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  FPRINT_DBUS__DEVICE_SIGNALS[FPRINT_DBUS__DEVICE_ENROLL_STATUS] =
    g_signal_new ("enroll-status",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (FprintDBusDeviceIface, enroll_status),
      NULL,
      NULL,
      fprint_dbus_device_signal_marshal_enroll_status,
      G_TYPE_NONE,
      2, G_TYPE_STRING, G_TYPE_BOOLEAN);

  /* GObject properties for D-Bus properties: */
  /**
   * FprintDBusDevice:name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-net-reactivated-Fprint-Device.name">"name"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("name", "name", "name", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * FprintDBusDevice:num-enroll-stages:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-net-reactivated-Fprint-Device.num-enroll-stages">"num-enroll-stages"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int ("num-enroll-stages", "num-enroll-stages", "num-enroll-stages", G_MININT32, G_MAXINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * FprintDBusDevice:scan-type:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-net-reactivated-Fprint-Device.scan-type">"scan-type"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("scan-type", "scan-type", "scan-type", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * FprintDBusDevice:finger-present:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-net-reactivated-Fprint-Device.finger-present">"finger-present"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("finger-present", "finger-present", "finger-present", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * FprintDBusDevice:finger-needed:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-net-reactivated-Fprint-Device.finger-needed">"finger-needed"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("finger-needed", "finger-needed", "finger-needed", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * fprint_dbus_device_get_name: (skip)
 * @object: A #FprintDBusDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-net-reactivated-Fprint-Device.name">"name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use fprint_dbus_device_dup_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
fprint_dbus_device_get_name (FprintDBusDevice *object)
{
  g_return_val_if_fail (FPRINT_DBUS_IS_DEVICE (object), NULL);

  return FPRINT_DBUS_DEVICE_GET_IFACE (object)->get_name (object);
}

/**
 * fprint_dbus_device_dup_name: (skip)
 * @object: A #FprintDBusDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-net-reactivated-Fprint-Device.name">"name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
fprint_dbus_device_dup_name (FprintDBusDevice *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "name", &value, NULL);
  return value;
}

/**
 * fprint_dbus_device_set_name: (skip)
 * @object: A #FprintDBusDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-net-reactivated-Fprint-Device.name">"name"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
fprint_dbus_device_set_name (FprintDBusDevice *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "name", value, NULL);
}

/**
 * fprint_dbus_device_get_num_enroll_stages: (skip)
 * @object: A #FprintDBusDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-net-reactivated-Fprint-Device.num-enroll-stages">"num-enroll-stages"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint 
fprint_dbus_device_get_num_enroll_stages (FprintDBusDevice *object)
{
  g_return_val_if_fail (FPRINT_DBUS_IS_DEVICE (object), 0);

  return FPRINT_DBUS_DEVICE_GET_IFACE (object)->get_num_enroll_stages (object);
}

/**
 * fprint_dbus_device_set_num_enroll_stages: (skip)
 * @object: A #FprintDBusDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-net-reactivated-Fprint-Device.num-enroll-stages">"num-enroll-stages"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
fprint_dbus_device_set_num_enroll_stages (FprintDBusDevice *object, gint value)
{
  g_object_set (G_OBJECT (object), "num-enroll-stages", value, NULL);
}

/**
 * fprint_dbus_device_get_scan_type: (skip)
 * @object: A #FprintDBusDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-net-reactivated-Fprint-Device.scan-type">"scan-type"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use fprint_dbus_device_dup_scan_type() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
fprint_dbus_device_get_scan_type (FprintDBusDevice *object)
{
  g_return_val_if_fail (FPRINT_DBUS_IS_DEVICE (object), NULL);

  return FPRINT_DBUS_DEVICE_GET_IFACE (object)->get_scan_type (object);
}

/**
 * fprint_dbus_device_dup_scan_type: (skip)
 * @object: A #FprintDBusDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-net-reactivated-Fprint-Device.scan-type">"scan-type"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
fprint_dbus_device_dup_scan_type (FprintDBusDevice *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "scan-type", &value, NULL);
  return value;
}

/**
 * fprint_dbus_device_set_scan_type: (skip)
 * @object: A #FprintDBusDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-net-reactivated-Fprint-Device.scan-type">"scan-type"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
fprint_dbus_device_set_scan_type (FprintDBusDevice *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "scan-type", value, NULL);
}

/**
 * fprint_dbus_device_get_finger_present: (skip)
 * @object: A #FprintDBusDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-net-reactivated-Fprint-Device.finger-present">"finger-present"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
fprint_dbus_device_get_finger_present (FprintDBusDevice *object)
{
  g_return_val_if_fail (FPRINT_DBUS_IS_DEVICE (object), FALSE);

  return FPRINT_DBUS_DEVICE_GET_IFACE (object)->get_finger_present (object);
}

/**
 * fprint_dbus_device_set_finger_present: (skip)
 * @object: A #FprintDBusDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-net-reactivated-Fprint-Device.finger-present">"finger-present"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
fprint_dbus_device_set_finger_present (FprintDBusDevice *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "finger-present", value, NULL);
}

/**
 * fprint_dbus_device_get_finger_needed: (skip)
 * @object: A #FprintDBusDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-net-reactivated-Fprint-Device.finger-needed">"finger-needed"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
fprint_dbus_device_get_finger_needed (FprintDBusDevice *object)
{
  g_return_val_if_fail (FPRINT_DBUS_IS_DEVICE (object), FALSE);

  return FPRINT_DBUS_DEVICE_GET_IFACE (object)->get_finger_needed (object);
}

/**
 * fprint_dbus_device_set_finger_needed: (skip)
 * @object: A #FprintDBusDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-net-reactivated-Fprint-Device.finger-needed">"finger-needed"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
fprint_dbus_device_set_finger_needed (FprintDBusDevice *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "finger-needed", value, NULL);
}

/**
 * fprint_dbus_device_emit_verify_finger_selected:
 * @object: A #FprintDBusDevice.
 * @arg_finger_name: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-net-reactivated-Fprint-Device.VerifyFingerSelected">"VerifyFingerSelected"</link> D-Bus signal.
 */
void
fprint_dbus_device_emit_verify_finger_selected (
    FprintDBusDevice *object,
    const gchar *arg_finger_name)
{
  g_signal_emit (object, FPRINT_DBUS__DEVICE_SIGNALS[FPRINT_DBUS__DEVICE_VERIFY_FINGER_SELECTED], 0, arg_finger_name);
}

/**
 * fprint_dbus_device_emit_verify_status:
 * @object: A #FprintDBusDevice.
 * @arg_result: Argument to pass with the signal.
 * @arg_done: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-net-reactivated-Fprint-Device.VerifyStatus">"VerifyStatus"</link> D-Bus signal.
 */
void
fprint_dbus_device_emit_verify_status (
    FprintDBusDevice *object,
    const gchar *arg_result,
    gboolean arg_done)
{
  g_signal_emit (object, FPRINT_DBUS__DEVICE_SIGNALS[FPRINT_DBUS__DEVICE_VERIFY_STATUS], 0, arg_result, arg_done);
}

/**
 * fprint_dbus_device_emit_enroll_status:
 * @object: A #FprintDBusDevice.
 * @arg_result: Argument to pass with the signal.
 * @arg_done: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-net-reactivated-Fprint-Device.EnrollStatus">"EnrollStatus"</link> D-Bus signal.
 */
void
fprint_dbus_device_emit_enroll_status (
    FprintDBusDevice *object,
    const gchar *arg_result,
    gboolean arg_done)
{
  g_signal_emit (object, FPRINT_DBUS__DEVICE_SIGNALS[FPRINT_DBUS__DEVICE_ENROLL_STATUS], 0, arg_result, arg_done);
}

/**
 * fprint_dbus_device_call_list_enrolled_fingers:
 * @proxy: A #FprintDBusDeviceProxy.
 * @arg_username: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-net-reactivated-Fprint-Device.ListEnrolledFingers">ListEnrolledFingers()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call fprint_dbus_device_call_list_enrolled_fingers_finish() to get the result of the operation.
 *
 * See fprint_dbus_device_call_list_enrolled_fingers_sync() for the synchronous, blocking version of this method.
 */
void
fprint_dbus_device_call_list_enrolled_fingers (
    FprintDBusDevice *proxy,
    const gchar *arg_username,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ListEnrolledFingers",
    g_variant_new ("(s)",
                   arg_username),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * fprint_dbus_device_call_list_enrolled_fingers_finish:
 * @proxy: A #FprintDBusDeviceProxy.
 * @out_enrolled_fingers: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to fprint_dbus_device_call_list_enrolled_fingers().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with fprint_dbus_device_call_list_enrolled_fingers().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
fprint_dbus_device_call_list_enrolled_fingers_finish (
    FprintDBusDevice *proxy,
    gchar ***out_enrolled_fingers,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_enrolled_fingers);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * fprint_dbus_device_call_list_enrolled_fingers_sync:
 * @proxy: A #FprintDBusDeviceProxy.
 * @arg_username: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @out_enrolled_fingers: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-net-reactivated-Fprint-Device.ListEnrolledFingers">ListEnrolledFingers()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See fprint_dbus_device_call_list_enrolled_fingers() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
fprint_dbus_device_call_list_enrolled_fingers_sync (
    FprintDBusDevice *proxy,
    const gchar *arg_username,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    gchar ***out_enrolled_fingers,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ListEnrolledFingers",
    g_variant_new ("(s)",
                   arg_username),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_enrolled_fingers);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * fprint_dbus_device_call_delete_enrolled_fingers:
 * @proxy: A #FprintDBusDeviceProxy.
 * @arg_username: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-net-reactivated-Fprint-Device.DeleteEnrolledFingers">DeleteEnrolledFingers()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call fprint_dbus_device_call_delete_enrolled_fingers_finish() to get the result of the operation.
 *
 * See fprint_dbus_device_call_delete_enrolled_fingers_sync() for the synchronous, blocking version of this method.
 */
void
fprint_dbus_device_call_delete_enrolled_fingers (
    FprintDBusDevice *proxy,
    const gchar *arg_username,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "DeleteEnrolledFingers",
    g_variant_new ("(s)",
                   arg_username),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * fprint_dbus_device_call_delete_enrolled_fingers_finish:
 * @proxy: A #FprintDBusDeviceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to fprint_dbus_device_call_delete_enrolled_fingers().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with fprint_dbus_device_call_delete_enrolled_fingers().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
fprint_dbus_device_call_delete_enrolled_fingers_finish (
    FprintDBusDevice *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * fprint_dbus_device_call_delete_enrolled_fingers_sync:
 * @proxy: A #FprintDBusDeviceProxy.
 * @arg_username: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-net-reactivated-Fprint-Device.DeleteEnrolledFingers">DeleteEnrolledFingers()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See fprint_dbus_device_call_delete_enrolled_fingers() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
fprint_dbus_device_call_delete_enrolled_fingers_sync (
    FprintDBusDevice *proxy,
    const gchar *arg_username,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "DeleteEnrolledFingers",
    g_variant_new ("(s)",
                   arg_username),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * fprint_dbus_device_call_delete_enrolled_fingers2:
 * @proxy: A #FprintDBusDeviceProxy.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-net-reactivated-Fprint-Device.DeleteEnrolledFingers2">DeleteEnrolledFingers2()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call fprint_dbus_device_call_delete_enrolled_fingers2_finish() to get the result of the operation.
 *
 * See fprint_dbus_device_call_delete_enrolled_fingers2_sync() for the synchronous, blocking version of this method.
 */
void
fprint_dbus_device_call_delete_enrolled_fingers2 (
    FprintDBusDevice *proxy,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "DeleteEnrolledFingers2",
    g_variant_new ("()"),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * fprint_dbus_device_call_delete_enrolled_fingers2_finish:
 * @proxy: A #FprintDBusDeviceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to fprint_dbus_device_call_delete_enrolled_fingers2().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with fprint_dbus_device_call_delete_enrolled_fingers2().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
fprint_dbus_device_call_delete_enrolled_fingers2_finish (
    FprintDBusDevice *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * fprint_dbus_device_call_delete_enrolled_fingers2_sync:
 * @proxy: A #FprintDBusDeviceProxy.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-net-reactivated-Fprint-Device.DeleteEnrolledFingers2">DeleteEnrolledFingers2()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See fprint_dbus_device_call_delete_enrolled_fingers2() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
fprint_dbus_device_call_delete_enrolled_fingers2_sync (
    FprintDBusDevice *proxy,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "DeleteEnrolledFingers2",
    g_variant_new ("()"),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * fprint_dbus_device_call_delete_enrolled_finger:
 * @proxy: A #FprintDBusDeviceProxy.
 * @arg_finger_name: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-net-reactivated-Fprint-Device.DeleteEnrolledFinger">DeleteEnrolledFinger()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call fprint_dbus_device_call_delete_enrolled_finger_finish() to get the result of the operation.
 *
 * See fprint_dbus_device_call_delete_enrolled_finger_sync() for the synchronous, blocking version of this method.
 */
void
fprint_dbus_device_call_delete_enrolled_finger (
    FprintDBusDevice *proxy,
    const gchar *arg_finger_name,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "DeleteEnrolledFinger",
    g_variant_new ("(s)",
                   arg_finger_name),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * fprint_dbus_device_call_delete_enrolled_finger_finish:
 * @proxy: A #FprintDBusDeviceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to fprint_dbus_device_call_delete_enrolled_finger().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with fprint_dbus_device_call_delete_enrolled_finger().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
fprint_dbus_device_call_delete_enrolled_finger_finish (
    FprintDBusDevice *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * fprint_dbus_device_call_delete_enrolled_finger_sync:
 * @proxy: A #FprintDBusDeviceProxy.
 * @arg_finger_name: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-net-reactivated-Fprint-Device.DeleteEnrolledFinger">DeleteEnrolledFinger()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See fprint_dbus_device_call_delete_enrolled_finger() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
fprint_dbus_device_call_delete_enrolled_finger_sync (
    FprintDBusDevice *proxy,
    const gchar *arg_finger_name,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "DeleteEnrolledFinger",
    g_variant_new ("(s)",
                   arg_finger_name),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * fprint_dbus_device_call_claim:
 * @proxy: A #FprintDBusDeviceProxy.
 * @arg_username: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-net-reactivated-Fprint-Device.Claim">Claim()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call fprint_dbus_device_call_claim_finish() to get the result of the operation.
 *
 * See fprint_dbus_device_call_claim_sync() for the synchronous, blocking version of this method.
 */
void
fprint_dbus_device_call_claim (
    FprintDBusDevice *proxy,
    const gchar *arg_username,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Claim",
    g_variant_new ("(s)",
                   arg_username),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * fprint_dbus_device_call_claim_finish:
 * @proxy: A #FprintDBusDeviceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to fprint_dbus_device_call_claim().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with fprint_dbus_device_call_claim().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
fprint_dbus_device_call_claim_finish (
    FprintDBusDevice *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * fprint_dbus_device_call_claim_sync:
 * @proxy: A #FprintDBusDeviceProxy.
 * @arg_username: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-net-reactivated-Fprint-Device.Claim">Claim()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See fprint_dbus_device_call_claim() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
fprint_dbus_device_call_claim_sync (
    FprintDBusDevice *proxy,
    const gchar *arg_username,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Claim",
    g_variant_new ("(s)",
                   arg_username),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * fprint_dbus_device_call_release:
 * @proxy: A #FprintDBusDeviceProxy.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-net-reactivated-Fprint-Device.Release">Release()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call fprint_dbus_device_call_release_finish() to get the result of the operation.
 *
 * See fprint_dbus_device_call_release_sync() for the synchronous, blocking version of this method.
 */
void
fprint_dbus_device_call_release (
    FprintDBusDevice *proxy,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Release",
    g_variant_new ("()"),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * fprint_dbus_device_call_release_finish:
 * @proxy: A #FprintDBusDeviceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to fprint_dbus_device_call_release().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with fprint_dbus_device_call_release().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
fprint_dbus_device_call_release_finish (
    FprintDBusDevice *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * fprint_dbus_device_call_release_sync:
 * @proxy: A #FprintDBusDeviceProxy.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-net-reactivated-Fprint-Device.Release">Release()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See fprint_dbus_device_call_release() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
fprint_dbus_device_call_release_sync (
    FprintDBusDevice *proxy,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Release",
    g_variant_new ("()"),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * fprint_dbus_device_call_verify_start:
 * @proxy: A #FprintDBusDeviceProxy.
 * @arg_finger_name: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-net-reactivated-Fprint-Device.VerifyStart">VerifyStart()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call fprint_dbus_device_call_verify_start_finish() to get the result of the operation.
 *
 * See fprint_dbus_device_call_verify_start_sync() for the synchronous, blocking version of this method.
 */
void
fprint_dbus_device_call_verify_start (
    FprintDBusDevice *proxy,
    const gchar *arg_finger_name,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "VerifyStart",
    g_variant_new ("(s)",
                   arg_finger_name),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * fprint_dbus_device_call_verify_start_finish:
 * @proxy: A #FprintDBusDeviceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to fprint_dbus_device_call_verify_start().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with fprint_dbus_device_call_verify_start().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
fprint_dbus_device_call_verify_start_finish (
    FprintDBusDevice *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * fprint_dbus_device_call_verify_start_sync:
 * @proxy: A #FprintDBusDeviceProxy.
 * @arg_finger_name: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-net-reactivated-Fprint-Device.VerifyStart">VerifyStart()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See fprint_dbus_device_call_verify_start() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
fprint_dbus_device_call_verify_start_sync (
    FprintDBusDevice *proxy,
    const gchar *arg_finger_name,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "VerifyStart",
    g_variant_new ("(s)",
                   arg_finger_name),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * fprint_dbus_device_call_verify_stop:
 * @proxy: A #FprintDBusDeviceProxy.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-net-reactivated-Fprint-Device.VerifyStop">VerifyStop()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call fprint_dbus_device_call_verify_stop_finish() to get the result of the operation.
 *
 * See fprint_dbus_device_call_verify_stop_sync() for the synchronous, blocking version of this method.
 */
void
fprint_dbus_device_call_verify_stop (
    FprintDBusDevice *proxy,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "VerifyStop",
    g_variant_new ("()"),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * fprint_dbus_device_call_verify_stop_finish:
 * @proxy: A #FprintDBusDeviceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to fprint_dbus_device_call_verify_stop().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with fprint_dbus_device_call_verify_stop().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
fprint_dbus_device_call_verify_stop_finish (
    FprintDBusDevice *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * fprint_dbus_device_call_verify_stop_sync:
 * @proxy: A #FprintDBusDeviceProxy.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-net-reactivated-Fprint-Device.VerifyStop">VerifyStop()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See fprint_dbus_device_call_verify_stop() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
fprint_dbus_device_call_verify_stop_sync (
    FprintDBusDevice *proxy,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "VerifyStop",
    g_variant_new ("()"),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * fprint_dbus_device_call_enroll_start:
 * @proxy: A #FprintDBusDeviceProxy.
 * @arg_finger_name: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-net-reactivated-Fprint-Device.EnrollStart">EnrollStart()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call fprint_dbus_device_call_enroll_start_finish() to get the result of the operation.
 *
 * See fprint_dbus_device_call_enroll_start_sync() for the synchronous, blocking version of this method.
 */
void
fprint_dbus_device_call_enroll_start (
    FprintDBusDevice *proxy,
    const gchar *arg_finger_name,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "EnrollStart",
    g_variant_new ("(s)",
                   arg_finger_name),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * fprint_dbus_device_call_enroll_start_finish:
 * @proxy: A #FprintDBusDeviceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to fprint_dbus_device_call_enroll_start().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with fprint_dbus_device_call_enroll_start().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
fprint_dbus_device_call_enroll_start_finish (
    FprintDBusDevice *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * fprint_dbus_device_call_enroll_start_sync:
 * @proxy: A #FprintDBusDeviceProxy.
 * @arg_finger_name: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-net-reactivated-Fprint-Device.EnrollStart">EnrollStart()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See fprint_dbus_device_call_enroll_start() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
fprint_dbus_device_call_enroll_start_sync (
    FprintDBusDevice *proxy,
    const gchar *arg_finger_name,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "EnrollStart",
    g_variant_new ("(s)",
                   arg_finger_name),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * fprint_dbus_device_call_enroll_stop:
 * @proxy: A #FprintDBusDeviceProxy.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-net-reactivated-Fprint-Device.EnrollStop">EnrollStop()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call fprint_dbus_device_call_enroll_stop_finish() to get the result of the operation.
 *
 * See fprint_dbus_device_call_enroll_stop_sync() for the synchronous, blocking version of this method.
 */
void
fprint_dbus_device_call_enroll_stop (
    FprintDBusDevice *proxy,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "EnrollStop",
    g_variant_new ("()"),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * fprint_dbus_device_call_enroll_stop_finish:
 * @proxy: A #FprintDBusDeviceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to fprint_dbus_device_call_enroll_stop().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with fprint_dbus_device_call_enroll_stop().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
fprint_dbus_device_call_enroll_stop_finish (
    FprintDBusDevice *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * fprint_dbus_device_call_enroll_stop_sync:
 * @proxy: A #FprintDBusDeviceProxy.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-net-reactivated-Fprint-Device.EnrollStop">EnrollStop()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See fprint_dbus_device_call_enroll_stop() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
fprint_dbus_device_call_enroll_stop_sync (
    FprintDBusDevice *proxy,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "EnrollStop",
    g_variant_new ("()"),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * fprint_dbus_device_complete_list_enrolled_fingers:
 * @object: A #FprintDBusDevice.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @enrolled_fingers: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-net-reactivated-Fprint-Device.ListEnrolledFingers">ListEnrolledFingers()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
fprint_dbus_device_complete_list_enrolled_fingers (
    FprintDBusDevice *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *enrolled_fingers)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^as)",
                   enrolled_fingers));
}

/**
 * fprint_dbus_device_complete_delete_enrolled_fingers:
 * @object: A #FprintDBusDevice.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-net-reactivated-Fprint-Device.DeleteEnrolledFingers">DeleteEnrolledFingers()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
fprint_dbus_device_complete_delete_enrolled_fingers (
    FprintDBusDevice *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * fprint_dbus_device_complete_delete_enrolled_fingers2:
 * @object: A #FprintDBusDevice.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-net-reactivated-Fprint-Device.DeleteEnrolledFingers2">DeleteEnrolledFingers2()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
fprint_dbus_device_complete_delete_enrolled_fingers2 (
    FprintDBusDevice *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * fprint_dbus_device_complete_delete_enrolled_finger:
 * @object: A #FprintDBusDevice.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-net-reactivated-Fprint-Device.DeleteEnrolledFinger">DeleteEnrolledFinger()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
fprint_dbus_device_complete_delete_enrolled_finger (
    FprintDBusDevice *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * fprint_dbus_device_complete_claim:
 * @object: A #FprintDBusDevice.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-net-reactivated-Fprint-Device.Claim">Claim()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
fprint_dbus_device_complete_claim (
    FprintDBusDevice *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * fprint_dbus_device_complete_release:
 * @object: A #FprintDBusDevice.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-net-reactivated-Fprint-Device.Release">Release()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
fprint_dbus_device_complete_release (
    FprintDBusDevice *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * fprint_dbus_device_complete_verify_start:
 * @object: A #FprintDBusDevice.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-net-reactivated-Fprint-Device.VerifyStart">VerifyStart()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
fprint_dbus_device_complete_verify_start (
    FprintDBusDevice *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * fprint_dbus_device_complete_verify_stop:
 * @object: A #FprintDBusDevice.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-net-reactivated-Fprint-Device.VerifyStop">VerifyStop()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
fprint_dbus_device_complete_verify_stop (
    FprintDBusDevice *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * fprint_dbus_device_complete_enroll_start:
 * @object: A #FprintDBusDevice.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-net-reactivated-Fprint-Device.EnrollStart">EnrollStart()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
fprint_dbus_device_complete_enroll_start (
    FprintDBusDevice *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * fprint_dbus_device_complete_enroll_stop:
 * @object: A #FprintDBusDevice.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-net-reactivated-Fprint-Device.EnrollStop">EnrollStop()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
fprint_dbus_device_complete_enroll_stop (
    FprintDBusDevice *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * FprintDBusDeviceProxy:
 *
 * The #FprintDBusDeviceProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * FprintDBusDeviceProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #FprintDBusDeviceProxy.
 */

struct _FprintDBusDeviceProxyPrivate
{
  GData *qdata;
};

static void fprint_dbus_device_proxy_iface_init (FprintDBusDeviceIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (FprintDBusDeviceProxy, fprint_dbus_device_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (FprintDBusDeviceProxy)
                         G_IMPLEMENT_INTERFACE (FPRINT_DBUS_TYPE_DEVICE, fprint_dbus_device_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (FprintDBusDeviceProxy, fprint_dbus_device_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (FPRINT_DBUS_TYPE_DEVICE, fprint_dbus_device_proxy_iface_init))

#endif
static void
fprint_dbus_device_proxy_finalize (GObject *object)
{
  FprintDBusDeviceProxy *proxy = FPRINT_DBUS_DEVICE_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (fprint_dbus_device_proxy_parent_class)->finalize (object);
}

static void
fprint_dbus_device_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 5);
  info = (const _ExtendedGDBusPropertyInfo *) _fprint_dbus_device_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
fprint_dbus_device_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface net.reactivated.Fprint.Device: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
fprint_dbus_device_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 5);
  info = (const _ExtendedGDBusPropertyInfo *) _fprint_dbus_device_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "net.reactivated.Fprint.Device", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) fprint_dbus_device_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
fprint_dbus_device_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_fprint_dbus_device_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], FPRINT_DBUS_TYPE_DEVICE);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, FPRINT_DBUS_TYPE_DEVICE);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
fprint_dbus_device_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  FprintDBusDeviceProxy *proxy = FPRINT_DBUS_DEVICE_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_fprint_dbus_device_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_fprint_dbus_device_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
fprint_dbus_device_proxy_get_name (FprintDBusDevice *object)
{
  FprintDBusDeviceProxy *proxy = FPRINT_DBUS_DEVICE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "name");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gint 
fprint_dbus_device_proxy_get_num_enroll_stages (FprintDBusDevice *object)
{
  FprintDBusDeviceProxy *proxy = FPRINT_DBUS_DEVICE_PROXY (object);
  GVariant *variant;
  gint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "num-enroll-stages");
  if (variant != NULL)
    {
      value = g_variant_get_int32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
fprint_dbus_device_proxy_get_scan_type (FprintDBusDevice *object)
{
  FprintDBusDeviceProxy *proxy = FPRINT_DBUS_DEVICE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "scan-type");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
fprint_dbus_device_proxy_get_finger_present (FprintDBusDevice *object)
{
  FprintDBusDeviceProxy *proxy = FPRINT_DBUS_DEVICE_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "finger-present");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
fprint_dbus_device_proxy_get_finger_needed (FprintDBusDevice *object)
{
  FprintDBusDeviceProxy *proxy = FPRINT_DBUS_DEVICE_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "finger-needed");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
fprint_dbus_device_proxy_init (FprintDBusDeviceProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = fprint_dbus_device_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, FPRINT_DBUS_TYPE_DEVICE_PROXY, FprintDBusDeviceProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), fprint_dbus_device_interface_info ());
}

static void
fprint_dbus_device_proxy_class_init (FprintDBusDeviceProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = fprint_dbus_device_proxy_finalize;
  gobject_class->get_property = fprint_dbus_device_proxy_get_property;
  gobject_class->set_property = fprint_dbus_device_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = fprint_dbus_device_proxy_g_signal;
  proxy_class->g_properties_changed = fprint_dbus_device_proxy_g_properties_changed;

  fprint_dbus_device_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (FprintDBusDeviceProxyPrivate));
#endif
}

static void
fprint_dbus_device_proxy_iface_init (FprintDBusDeviceIface *iface)
{
  iface->get_name = fprint_dbus_device_proxy_get_name;
  iface->get_num_enroll_stages = fprint_dbus_device_proxy_get_num_enroll_stages;
  iface->get_scan_type = fprint_dbus_device_proxy_get_scan_type;
  iface->get_finger_present = fprint_dbus_device_proxy_get_finger_present;
  iface->get_finger_needed = fprint_dbus_device_proxy_get_finger_needed;
}

/**
 * fprint_dbus_device_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-net-reactivated-Fprint-Device.top_of_page">net.reactivated.Fprint.Device</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call fprint_dbus_device_proxy_new_finish() to get the result of the operation.
 *
 * See fprint_dbus_device_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
fprint_dbus_device_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (FPRINT_DBUS_TYPE_DEVICE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "net.reactivated.Fprint.Device", NULL);
}

/**
 * fprint_dbus_device_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to fprint_dbus_device_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with fprint_dbus_device_proxy_new().
 *
 * Returns: (transfer full) (type FprintDBusDeviceProxy): The constructed proxy object or %NULL if @error is set.
 */
FprintDBusDevice *
fprint_dbus_device_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return FPRINT_DBUS_DEVICE (ret);
  else
    return NULL;
}

/**
 * fprint_dbus_device_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-net-reactivated-Fprint-Device.top_of_page">net.reactivated.Fprint.Device</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See fprint_dbus_device_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type FprintDBusDeviceProxy): The constructed proxy object or %NULL if @error is set.
 */
FprintDBusDevice *
fprint_dbus_device_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (FPRINT_DBUS_TYPE_DEVICE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "net.reactivated.Fprint.Device", NULL);
  if (ret != NULL)
    return FPRINT_DBUS_DEVICE (ret);
  else
    return NULL;
}


/**
 * fprint_dbus_device_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like fprint_dbus_device_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call fprint_dbus_device_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See fprint_dbus_device_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
fprint_dbus_device_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (FPRINT_DBUS_TYPE_DEVICE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "net.reactivated.Fprint.Device", NULL);
}

/**
 * fprint_dbus_device_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to fprint_dbus_device_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with fprint_dbus_device_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type FprintDBusDeviceProxy): The constructed proxy object or %NULL if @error is set.
 */
FprintDBusDevice *
fprint_dbus_device_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return FPRINT_DBUS_DEVICE (ret);
  else
    return NULL;
}

/**
 * fprint_dbus_device_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like fprint_dbus_device_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See fprint_dbus_device_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type FprintDBusDeviceProxy): The constructed proxy object or %NULL if @error is set.
 */
FprintDBusDevice *
fprint_dbus_device_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (FPRINT_DBUS_TYPE_DEVICE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "net.reactivated.Fprint.Device", NULL);
  if (ret != NULL)
    return FPRINT_DBUS_DEVICE (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * FprintDBusDeviceSkeleton:
 *
 * The #FprintDBusDeviceSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * FprintDBusDeviceSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #FprintDBusDeviceSkeleton.
 */

struct _FprintDBusDeviceSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_fprint_dbus_device_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  FprintDBusDeviceSkeleton *skeleton = FPRINT_DBUS_DEVICE_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], FPRINT_DBUS_TYPE_DEVICE);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, FPRINT_DBUS_TYPE_DEVICE);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_fprint_dbus_device_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  FprintDBusDeviceSkeleton *skeleton = FPRINT_DBUS_DEVICE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_fprint_dbus_device_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_fprint_dbus_device_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  FprintDBusDeviceSkeleton *skeleton = FPRINT_DBUS_DEVICE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_fprint_dbus_device_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _fprint_dbus_device_skeleton_vtable =
{
  _fprint_dbus_device_skeleton_handle_method_call,
  _fprint_dbus_device_skeleton_handle_get_property,
  _fprint_dbus_device_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
fprint_dbus_device_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return fprint_dbus_device_interface_info ();
}

static GDBusInterfaceVTable *
fprint_dbus_device_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_fprint_dbus_device_skeleton_vtable;
}

static GVariant *
fprint_dbus_device_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  FprintDBusDeviceSkeleton *skeleton = FPRINT_DBUS_DEVICE_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_fprint_dbus_device_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _fprint_dbus_device_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _fprint_dbus_device_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _fprint_dbus_device_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "net.reactivated.Fprint.Device", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _fprint_dbus_device_emit_changed (gpointer user_data);

static void
fprint_dbus_device_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  FprintDBusDeviceSkeleton *skeleton = FPRINT_DBUS_DEVICE_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _fprint_dbus_device_emit_changed (skeleton);
}

static void
_fprint_dbus_device_on_signal_verify_finger_selected (
    FprintDBusDevice *object,
    const gchar *arg_finger_name)
{
  FprintDBusDeviceSkeleton *skeleton = FPRINT_DBUS_DEVICE_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_finger_name));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "net.reactivated.Fprint.Device", "VerifyFingerSelected",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_fprint_dbus_device_on_signal_verify_status (
    FprintDBusDevice *object,
    const gchar *arg_result,
    gboolean arg_done)
{
  FprintDBusDeviceSkeleton *skeleton = FPRINT_DBUS_DEVICE_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(sb)",
                   arg_result,
                   arg_done));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "net.reactivated.Fprint.Device", "VerifyStatus",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_fprint_dbus_device_on_signal_enroll_status (
    FprintDBusDevice *object,
    const gchar *arg_result,
    gboolean arg_done)
{
  FprintDBusDeviceSkeleton *skeleton = FPRINT_DBUS_DEVICE_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(sb)",
                   arg_result,
                   arg_done));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "net.reactivated.Fprint.Device", "EnrollStatus",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void fprint_dbus_device_skeleton_iface_init (FprintDBusDeviceIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (FprintDBusDeviceSkeleton, fprint_dbus_device_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (FprintDBusDeviceSkeleton)
                         G_IMPLEMENT_INTERFACE (FPRINT_DBUS_TYPE_DEVICE, fprint_dbus_device_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (FprintDBusDeviceSkeleton, fprint_dbus_device_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (FPRINT_DBUS_TYPE_DEVICE, fprint_dbus_device_skeleton_iface_init))

#endif
static void
fprint_dbus_device_skeleton_finalize (GObject *object)
{
  FprintDBusDeviceSkeleton *skeleton = FPRINT_DBUS_DEVICE_SKELETON (object);
  guint n;
  for (n = 0; n < 5; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (fprint_dbus_device_skeleton_parent_class)->finalize (object);
}

static void
fprint_dbus_device_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  FprintDBusDeviceSkeleton *skeleton = FPRINT_DBUS_DEVICE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 5);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_fprint_dbus_device_emit_changed (gpointer user_data)
{
  FprintDBusDeviceSkeleton *skeleton = FPRINT_DBUS_DEVICE_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "net.reactivated.Fprint.Device",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_fprint_dbus_device_schedule_emit_changed (FprintDBusDeviceSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
fprint_dbus_device_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  FprintDBusDeviceSkeleton *skeleton = FPRINT_DBUS_DEVICE_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _fprint_dbus_device_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _fprint_dbus_device_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
fprint_dbus_device_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  FprintDBusDeviceSkeleton *skeleton = FPRINT_DBUS_DEVICE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 5);
  info = (const _ExtendedGDBusPropertyInfo *) _fprint_dbus_device_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _fprint_dbus_device_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
fprint_dbus_device_skeleton_init (FprintDBusDeviceSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = fprint_dbus_device_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, FPRINT_DBUS_TYPE_DEVICE_SKELETON, FprintDBusDeviceSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 5);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_INT);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_BOOLEAN);
}

static const gchar *
fprint_dbus_device_skeleton_get_name (FprintDBusDevice *object)
{
  FprintDBusDeviceSkeleton *skeleton = FPRINT_DBUS_DEVICE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gint 
fprint_dbus_device_skeleton_get_num_enroll_stages (FprintDBusDevice *object)
{
  FprintDBusDeviceSkeleton *skeleton = FPRINT_DBUS_DEVICE_SKELETON (object);
  gint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_int (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
fprint_dbus_device_skeleton_get_scan_type (FprintDBusDevice *object)
{
  FprintDBusDeviceSkeleton *skeleton = FPRINT_DBUS_DEVICE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
fprint_dbus_device_skeleton_get_finger_present (FprintDBusDevice *object)
{
  FprintDBusDeviceSkeleton *skeleton = FPRINT_DBUS_DEVICE_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
fprint_dbus_device_skeleton_get_finger_needed (FprintDBusDevice *object)
{
  FprintDBusDeviceSkeleton *skeleton = FPRINT_DBUS_DEVICE_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
fprint_dbus_device_skeleton_class_init (FprintDBusDeviceSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = fprint_dbus_device_skeleton_finalize;
  gobject_class->get_property = fprint_dbus_device_skeleton_get_property;
  gobject_class->set_property = fprint_dbus_device_skeleton_set_property;
  gobject_class->notify       = fprint_dbus_device_skeleton_notify;


  fprint_dbus_device_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = fprint_dbus_device_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = fprint_dbus_device_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = fprint_dbus_device_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = fprint_dbus_device_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (FprintDBusDeviceSkeletonPrivate));
#endif
}

static void
fprint_dbus_device_skeleton_iface_init (FprintDBusDeviceIface *iface)
{
  iface->verify_finger_selected = _fprint_dbus_device_on_signal_verify_finger_selected;
  iface->verify_status = _fprint_dbus_device_on_signal_verify_status;
  iface->enroll_status = _fprint_dbus_device_on_signal_enroll_status;
  iface->get_name = fprint_dbus_device_skeleton_get_name;
  iface->get_num_enroll_stages = fprint_dbus_device_skeleton_get_num_enroll_stages;
  iface->get_scan_type = fprint_dbus_device_skeleton_get_scan_type;
  iface->get_finger_present = fprint_dbus_device_skeleton_get_finger_present;
  iface->get_finger_needed = fprint_dbus_device_skeleton_get_finger_needed;
}

/**
 * fprint_dbus_device_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-net-reactivated-Fprint-Device.top_of_page">net.reactivated.Fprint.Device</link>.
 *
 * Returns: (transfer full) (type FprintDBusDeviceSkeleton): The skeleton object.
 */
FprintDBusDevice *
fprint_dbus_device_skeleton_new (void)
{
  return FPRINT_DBUS_DEVICE (g_object_new (FPRINT_DBUS_TYPE_DEVICE_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface net.reactivated.Fprint.Manager
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:FprintDBusManager
 * @title: FprintDBusManager
 * @short_description: Generated C code for the net.reactivated.Fprint.Manager D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-net-reactivated-Fprint-Manager.top_of_page">net.reactivated.Fprint.Manager</link> D-Bus interface in C.
 */

/* ---- Introspection data for net.reactivated.Fprint.Manager ---- */

static const _ExtendedGDBusArgInfo _fprint_dbus_manager_method_info_get_devices_OUT_ARG_devices =
{
  {
    -1,
    (gchar *) "devices",
    (gchar *) "ao",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _fprint_dbus_manager_method_info_get_devices_OUT_ARG_pointers[] =
{
  &_fprint_dbus_manager_method_info_get_devices_OUT_ARG_devices.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _fprint_dbus_manager_method_info_get_devices =
{
  {
    -1,
    (gchar *) "GetDevices",
    NULL,
    (GDBusArgInfo **) &_fprint_dbus_manager_method_info_get_devices_OUT_ARG_pointers,
    NULL
  },
  "handle-get-devices",
  FALSE
};

static const _ExtendedGDBusArgInfo _fprint_dbus_manager_method_info_get_default_device_OUT_ARG_device =
{
  {
    -1,
    (gchar *) "device",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _fprint_dbus_manager_method_info_get_default_device_OUT_ARG_pointers[] =
{
  &_fprint_dbus_manager_method_info_get_default_device_OUT_ARG_device.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _fprint_dbus_manager_method_info_get_default_device =
{
  {
    -1,
    (gchar *) "GetDefaultDevice",
    NULL,
    (GDBusArgInfo **) &_fprint_dbus_manager_method_info_get_default_device_OUT_ARG_pointers,
    NULL
  },
  "handle-get-default-device",
  FALSE
};

static const GDBusMethodInfo * const _fprint_dbus_manager_method_info_pointers[] =
{
  &_fprint_dbus_manager_method_info_get_devices.parent_struct,
  &_fprint_dbus_manager_method_info_get_default_device.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _fprint_dbus_manager_interface_info =
{
  {
    -1,
    (gchar *) "net.reactivated.Fprint.Manager",
    (GDBusMethodInfo **) &_fprint_dbus_manager_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "manager",
};


/**
 * fprint_dbus_manager_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-net-reactivated-Fprint-Manager.top_of_page">net.reactivated.Fprint.Manager</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
fprint_dbus_manager_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_fprint_dbus_manager_interface_info.parent_struct;
}

/**
 * fprint_dbus_manager_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #FprintDBusManager interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
fprint_dbus_manager_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
fprint_dbus_manager_method_marshal_get_devices (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
fprint_dbus_manager_method_marshal_get_default_device (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * FprintDBusManager:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-net-reactivated-Fprint-Manager.top_of_page">net.reactivated.Fprint.Manager</link>.
 */

/**
 * FprintDBusManagerIface:
 * @parent_iface: The parent interface.
 * @handle_get_default_device: Handler for the #FprintDBusManager::handle-get-default-device signal.
 * @handle_get_devices: Handler for the #FprintDBusManager::handle-get-devices signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-net-reactivated-Fprint-Manager.top_of_page">net.reactivated.Fprint.Manager</link>.
 */

typedef FprintDBusManagerIface FprintDBusManagerInterface;
G_DEFINE_INTERFACE (FprintDBusManager, fprint_dbus_manager, G_TYPE_OBJECT)

static void
fprint_dbus_manager_default_init (FprintDBusManagerIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * FprintDBusManager::handle-get-devices:
   * @object: A #FprintDBusManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-net-reactivated-Fprint-Manager.GetDevices">GetDevices()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call fprint_dbus_manager_complete_get_devices() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-devices",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (FprintDBusManagerIface, handle_get_devices),
    g_signal_accumulator_true_handled,
    NULL,
      fprint_dbus_manager_method_marshal_get_devices,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * FprintDBusManager::handle-get-default-device:
   * @object: A #FprintDBusManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-net-reactivated-Fprint-Manager.GetDefaultDevice">GetDefaultDevice()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call fprint_dbus_manager_complete_get_default_device() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-default-device",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (FprintDBusManagerIface, handle_get_default_device),
    g_signal_accumulator_true_handled,
    NULL,
      fprint_dbus_manager_method_marshal_get_default_device,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

}

/**
 * fprint_dbus_manager_call_get_devices:
 * @proxy: A #FprintDBusManagerProxy.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-net-reactivated-Fprint-Manager.GetDevices">GetDevices()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call fprint_dbus_manager_call_get_devices_finish() to get the result of the operation.
 *
 * See fprint_dbus_manager_call_get_devices_sync() for the synchronous, blocking version of this method.
 */
void
fprint_dbus_manager_call_get_devices (
    FprintDBusManager *proxy,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetDevices",
    g_variant_new ("()"),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * fprint_dbus_manager_call_get_devices_finish:
 * @proxy: A #FprintDBusManagerProxy.
 * @out_devices: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to fprint_dbus_manager_call_get_devices().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with fprint_dbus_manager_call_get_devices().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
fprint_dbus_manager_call_get_devices_finish (
    FprintDBusManager *proxy,
    gchar ***out_devices,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao)",
                 out_devices);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * fprint_dbus_manager_call_get_devices_sync:
 * @proxy: A #FprintDBusManagerProxy.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @out_devices: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-net-reactivated-Fprint-Manager.GetDevices">GetDevices()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See fprint_dbus_manager_call_get_devices() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
fprint_dbus_manager_call_get_devices_sync (
    FprintDBusManager *proxy,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    gchar ***out_devices,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetDevices",
    g_variant_new ("()"),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao)",
                 out_devices);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * fprint_dbus_manager_call_get_default_device:
 * @proxy: A #FprintDBusManagerProxy.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-net-reactivated-Fprint-Manager.GetDefaultDevice">GetDefaultDevice()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call fprint_dbus_manager_call_get_default_device_finish() to get the result of the operation.
 *
 * See fprint_dbus_manager_call_get_default_device_sync() for the synchronous, blocking version of this method.
 */
void
fprint_dbus_manager_call_get_default_device (
    FprintDBusManager *proxy,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetDefaultDevice",
    g_variant_new ("()"),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * fprint_dbus_manager_call_get_default_device_finish:
 * @proxy: A #FprintDBusManagerProxy.
 * @out_device: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to fprint_dbus_manager_call_get_default_device().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with fprint_dbus_manager_call_get_default_device().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
fprint_dbus_manager_call_get_default_device_finish (
    FprintDBusManager *proxy,
    gchar **out_device,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_device);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * fprint_dbus_manager_call_get_default_device_sync:
 * @proxy: A #FprintDBusManagerProxy.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @out_device: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-net-reactivated-Fprint-Manager.GetDefaultDevice">GetDefaultDevice()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See fprint_dbus_manager_call_get_default_device() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
fprint_dbus_manager_call_get_default_device_sync (
    FprintDBusManager *proxy,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    gchar **out_device,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetDefaultDevice",
    g_variant_new ("()"),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_device);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * fprint_dbus_manager_complete_get_devices:
 * @object: A #FprintDBusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @devices: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-net-reactivated-Fprint-Manager.GetDevices">GetDevices()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
fprint_dbus_manager_complete_get_devices (
    FprintDBusManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *devices)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^ao)",
                   devices));
}

/**
 * fprint_dbus_manager_complete_get_default_device:
 * @object: A #FprintDBusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @device: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-net-reactivated-Fprint-Manager.GetDefaultDevice">GetDefaultDevice()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
fprint_dbus_manager_complete_get_default_device (
    FprintDBusManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *device)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   device));
}

/* ------------------------------------------------------------------------ */

/**
 * FprintDBusManagerProxy:
 *
 * The #FprintDBusManagerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * FprintDBusManagerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #FprintDBusManagerProxy.
 */

struct _FprintDBusManagerProxyPrivate
{
  GData *qdata;
};

static void fprint_dbus_manager_proxy_iface_init (FprintDBusManagerIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (FprintDBusManagerProxy, fprint_dbus_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (FprintDBusManagerProxy)
                         G_IMPLEMENT_INTERFACE (FPRINT_DBUS_TYPE_MANAGER, fprint_dbus_manager_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (FprintDBusManagerProxy, fprint_dbus_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (FPRINT_DBUS_TYPE_MANAGER, fprint_dbus_manager_proxy_iface_init))

#endif
static void
fprint_dbus_manager_proxy_finalize (GObject *object)
{
  FprintDBusManagerProxy *proxy = FPRINT_DBUS_MANAGER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (fprint_dbus_manager_proxy_parent_class)->finalize (object);
}

static void
fprint_dbus_manager_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
fprint_dbus_manager_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
fprint_dbus_manager_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_fprint_dbus_manager_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], FPRINT_DBUS_TYPE_MANAGER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, FPRINT_DBUS_TYPE_MANAGER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
fprint_dbus_manager_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  FprintDBusManagerProxy *proxy = FPRINT_DBUS_MANAGER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_fprint_dbus_manager_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_fprint_dbus_manager_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
fprint_dbus_manager_proxy_init (FprintDBusManagerProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = fprint_dbus_manager_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, FPRINT_DBUS_TYPE_MANAGER_PROXY, FprintDBusManagerProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), fprint_dbus_manager_interface_info ());
}

static void
fprint_dbus_manager_proxy_class_init (FprintDBusManagerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = fprint_dbus_manager_proxy_finalize;
  gobject_class->get_property = fprint_dbus_manager_proxy_get_property;
  gobject_class->set_property = fprint_dbus_manager_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = fprint_dbus_manager_proxy_g_signal;
  proxy_class->g_properties_changed = fprint_dbus_manager_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (FprintDBusManagerProxyPrivate));
#endif
}

static void
fprint_dbus_manager_proxy_iface_init (FprintDBusManagerIface *iface G_GNUC_UNUSED)
{
}

/**
 * fprint_dbus_manager_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-net-reactivated-Fprint-Manager.top_of_page">net.reactivated.Fprint.Manager</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call fprint_dbus_manager_proxy_new_finish() to get the result of the operation.
 *
 * See fprint_dbus_manager_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
fprint_dbus_manager_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (FPRINT_DBUS_TYPE_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "net.reactivated.Fprint.Manager", NULL);
}

/**
 * fprint_dbus_manager_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to fprint_dbus_manager_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with fprint_dbus_manager_proxy_new().
 *
 * Returns: (transfer full) (type FprintDBusManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
FprintDBusManager *
fprint_dbus_manager_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return FPRINT_DBUS_MANAGER (ret);
  else
    return NULL;
}

/**
 * fprint_dbus_manager_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-net-reactivated-Fprint-Manager.top_of_page">net.reactivated.Fprint.Manager</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See fprint_dbus_manager_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type FprintDBusManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
FprintDBusManager *
fprint_dbus_manager_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (FPRINT_DBUS_TYPE_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "net.reactivated.Fprint.Manager", NULL);
  if (ret != NULL)
    return FPRINT_DBUS_MANAGER (ret);
  else
    return NULL;
}


/**
 * fprint_dbus_manager_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like fprint_dbus_manager_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call fprint_dbus_manager_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See fprint_dbus_manager_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
fprint_dbus_manager_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (FPRINT_DBUS_TYPE_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "net.reactivated.Fprint.Manager", NULL);
}

/**
 * fprint_dbus_manager_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to fprint_dbus_manager_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with fprint_dbus_manager_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type FprintDBusManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
FprintDBusManager *
fprint_dbus_manager_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return FPRINT_DBUS_MANAGER (ret);
  else
    return NULL;
}

/**
 * fprint_dbus_manager_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like fprint_dbus_manager_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See fprint_dbus_manager_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type FprintDBusManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
FprintDBusManager *
fprint_dbus_manager_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (FPRINT_DBUS_TYPE_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "net.reactivated.Fprint.Manager", NULL);
  if (ret != NULL)
    return FPRINT_DBUS_MANAGER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * FprintDBusManagerSkeleton:
 *
 * The #FprintDBusManagerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * FprintDBusManagerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #FprintDBusManagerSkeleton.
 */

struct _FprintDBusManagerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_fprint_dbus_manager_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  FprintDBusManagerSkeleton *skeleton = FPRINT_DBUS_MANAGER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], FPRINT_DBUS_TYPE_MANAGER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, FPRINT_DBUS_TYPE_MANAGER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_fprint_dbus_manager_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  FprintDBusManagerSkeleton *skeleton = FPRINT_DBUS_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_fprint_dbus_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_fprint_dbus_manager_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  FprintDBusManagerSkeleton *skeleton = FPRINT_DBUS_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_fprint_dbus_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _fprint_dbus_manager_skeleton_vtable =
{
  _fprint_dbus_manager_skeleton_handle_method_call,
  _fprint_dbus_manager_skeleton_handle_get_property,
  _fprint_dbus_manager_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
fprint_dbus_manager_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return fprint_dbus_manager_interface_info ();
}

static GDBusInterfaceVTable *
fprint_dbus_manager_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_fprint_dbus_manager_skeleton_vtable;
}

static GVariant *
fprint_dbus_manager_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  FprintDBusManagerSkeleton *skeleton = FPRINT_DBUS_MANAGER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_fprint_dbus_manager_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _fprint_dbus_manager_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _fprint_dbus_manager_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _fprint_dbus_manager_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "net.reactivated.Fprint.Manager", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
fprint_dbus_manager_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void fprint_dbus_manager_skeleton_iface_init (FprintDBusManagerIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (FprintDBusManagerSkeleton, fprint_dbus_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (FprintDBusManagerSkeleton)
                         G_IMPLEMENT_INTERFACE (FPRINT_DBUS_TYPE_MANAGER, fprint_dbus_manager_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (FprintDBusManagerSkeleton, fprint_dbus_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (FPRINT_DBUS_TYPE_MANAGER, fprint_dbus_manager_skeleton_iface_init))

#endif
static void
fprint_dbus_manager_skeleton_finalize (GObject *object)
{
  FprintDBusManagerSkeleton *skeleton = FPRINT_DBUS_MANAGER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (fprint_dbus_manager_skeleton_parent_class)->finalize (object);
}

static void
fprint_dbus_manager_skeleton_init (FprintDBusManagerSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = fprint_dbus_manager_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, FPRINT_DBUS_TYPE_MANAGER_SKELETON, FprintDBusManagerSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
fprint_dbus_manager_skeleton_class_init (FprintDBusManagerSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = fprint_dbus_manager_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = fprint_dbus_manager_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = fprint_dbus_manager_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = fprint_dbus_manager_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = fprint_dbus_manager_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (FprintDBusManagerSkeletonPrivate));
#endif
}

static void
fprint_dbus_manager_skeleton_iface_init (FprintDBusManagerIface *iface G_GNUC_UNUSED)
{
}

/**
 * fprint_dbus_manager_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-net-reactivated-Fprint-Manager.top_of_page">net.reactivated.Fprint.Manager</link>.
 *
 * Returns: (transfer full) (type FprintDBusManagerSkeleton): The skeleton object.
 */
FprintDBusManager *
fprint_dbus_manager_skeleton_new (void)
{
  return FPRINT_DBUS_MANAGER (g_object_new (FPRINT_DBUS_TYPE_MANAGER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for Object, ObjectProxy and ObjectSkeleton
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:FprintDBusObject
 * @title: FprintDBusObject
 * @short_description: Specialized GDBusObject types
 *
 * This section contains the #FprintDBusObject, #FprintDBusObjectProxy, and #FprintDBusObjectSkeleton types which make it easier to work with objects implementing generated types for D-Bus interfaces.
 */

/**
 * FprintDBusObject:
 *
 * The #FprintDBusObject type is a specialized container of interfaces.
 */

/**
 * FprintDBusObjectIface:
 * @parent_iface: The parent interface.
 *
 * Virtual table for the #FprintDBusObject interface.
 */

typedef FprintDBusObjectIface FprintDBusObjectInterface;
G_DEFINE_INTERFACE_WITH_CODE (FprintDBusObject, fprint_dbus_object, G_TYPE_OBJECT, g_type_interface_add_prerequisite (g_define_type_id, G_TYPE_DBUS_OBJECT);)

static void
fprint_dbus_object_default_init (FprintDBusObjectIface *iface)
{
  /**
   * FprintDBusObject:device:
   *
   * The #FprintDBusDevice instance corresponding to the D-Bus interface <link linkend="gdbus-interface-net-reactivated-Fprint-Device.top_of_page">net.reactivated.Fprint.Device</link>, if any.
   *
   * Connect to the #GObject::notify signal to get informed of property changes.
   */
  g_object_interface_install_property (iface, g_param_spec_object ("device", "device", "device", FPRINT_DBUS_TYPE_DEVICE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

  /**
   * FprintDBusObject:manager:
   *
   * The #FprintDBusManager instance corresponding to the D-Bus interface <link linkend="gdbus-interface-net-reactivated-Fprint-Manager.top_of_page">net.reactivated.Fprint.Manager</link>, if any.
   *
   * Connect to the #GObject::notify signal to get informed of property changes.
   */
  g_object_interface_install_property (iface, g_param_spec_object ("manager", "manager", "manager", FPRINT_DBUS_TYPE_MANAGER, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

}

/**
 * fprint_dbus_object_get_device:
 * @object: A #FprintDBusObject.
 *
 * Gets the #FprintDBusDevice instance for the D-Bus interface <link linkend="gdbus-interface-net-reactivated-Fprint-Device.top_of_page">net.reactivated.Fprint.Device</link> on @object, if any.
 *
 * Returns: (transfer full) (nullable): A #FprintDBusDevice that must be freed with g_object_unref() or %NULL if @object does not implement the interface.
 */
FprintDBusDevice *fprint_dbus_object_get_device (FprintDBusObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "net.reactivated.Fprint.Device");
  if (ret == NULL)
    return NULL;
  return FPRINT_DBUS_DEVICE (ret);
}

/**
 * fprint_dbus_object_get_manager:
 * @object: A #FprintDBusObject.
 *
 * Gets the #FprintDBusManager instance for the D-Bus interface <link linkend="gdbus-interface-net-reactivated-Fprint-Manager.top_of_page">net.reactivated.Fprint.Manager</link> on @object, if any.
 *
 * Returns: (transfer full) (nullable): A #FprintDBusManager that must be freed with g_object_unref() or %NULL if @object does not implement the interface.
 */
FprintDBusManager *fprint_dbus_object_get_manager (FprintDBusObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "net.reactivated.Fprint.Manager");
  if (ret == NULL)
    return NULL;
  return FPRINT_DBUS_MANAGER (ret);
}


/**
 * fprint_dbus_object_peek_device: (skip)
 * @object: A #FprintDBusObject.
 *
 * Like fprint_dbus_object_get_device() but doesn't increase the reference count on the returned object.
 *
 * It is not safe to use the returned object if you are on another thread than the one where the #GDBusObjectManagerClient or #GDBusObjectManagerServer for @object is running.
 *
 * Returns: (transfer none) (nullable): A #FprintDBusDevice or %NULL if @object does not implement the interface. Do not free the returned object, it is owned by @object.
 */
FprintDBusDevice *fprint_dbus_object_peek_device (FprintDBusObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "net.reactivated.Fprint.Device");
  if (ret == NULL)
    return NULL;
  g_object_unref (ret);
  return FPRINT_DBUS_DEVICE (ret);
}

/**
 * fprint_dbus_object_peek_manager: (skip)
 * @object: A #FprintDBusObject.
 *
 * Like fprint_dbus_object_get_manager() but doesn't increase the reference count on the returned object.
 *
 * It is not safe to use the returned object if you are on another thread than the one where the #GDBusObjectManagerClient or #GDBusObjectManagerServer for @object is running.
 *
 * Returns: (transfer none) (nullable): A #FprintDBusManager or %NULL if @object does not implement the interface. Do not free the returned object, it is owned by @object.
 */
FprintDBusManager *fprint_dbus_object_peek_manager (FprintDBusObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "net.reactivated.Fprint.Manager");
  if (ret == NULL)
    return NULL;
  g_object_unref (ret);
  return FPRINT_DBUS_MANAGER (ret);
}


static void
fprint_dbus_object_notify (GDBusObject *object, GDBusInterface *interface)
{
  _ExtendedGDBusInterfaceInfo *info = (_ExtendedGDBusInterfaceInfo *) g_dbus_interface_get_info (interface);
  /* info can be NULL if the other end is using a D-Bus interface we don't know
   * anything about, for example old generated code in this process talking to
   * newer generated code in the other process. */
  if (info != NULL)
    g_object_notify (G_OBJECT (object), info->hyphen_name);
}

/**
 * FprintDBusObjectProxy:
 *
 * The #FprintDBusObjectProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * FprintDBusObjectProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #FprintDBusObjectProxy.
 */

static void
fprint_dbus_object_proxy__fprint_dbus_object_iface_init (FprintDBusObjectIface *iface G_GNUC_UNUSED)
{
}

static void
fprint_dbus_object_proxy__g_dbus_object_iface_init (GDBusObjectIface *iface)
{
  iface->interface_added = fprint_dbus_object_notify;
  iface->interface_removed = fprint_dbus_object_notify;
}


G_DEFINE_TYPE_WITH_CODE (FprintDBusObjectProxy, fprint_dbus_object_proxy, G_TYPE_DBUS_OBJECT_PROXY,
                         G_IMPLEMENT_INTERFACE (FPRINT_DBUS_TYPE_OBJECT, fprint_dbus_object_proxy__fprint_dbus_object_iface_init)
                         G_IMPLEMENT_INTERFACE (G_TYPE_DBUS_OBJECT, fprint_dbus_object_proxy__g_dbus_object_iface_init))

static void
fprint_dbus_object_proxy_init (FprintDBusObjectProxy *object G_GNUC_UNUSED)
{
}

static void
fprint_dbus_object_proxy_set_property (GObject      *gobject,
  guint         prop_id,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec)
{
  G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
}

static void
fprint_dbus_object_proxy_get_property (GObject      *gobject,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec)
{
  FprintDBusObjectProxy *object = FPRINT_DBUS_OBJECT_PROXY (gobject);
  GDBusInterface *interface;

  switch (prop_id)
    {
    case 1:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "net.reactivated.Fprint.Device");
      g_value_take_object (value, interface);
      break;

    case 2:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "net.reactivated.Fprint.Manager");
      g_value_take_object (value, interface);
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
      break;
  }
}

static void
fprint_dbus_object_proxy_class_init (FprintDBusObjectProxyClass *klass)
{
  GObjectClass *gobject_class = G_OBJECT_CLASS (klass);

  gobject_class->set_property = fprint_dbus_object_proxy_set_property;
  gobject_class->get_property = fprint_dbus_object_proxy_get_property;

  g_object_class_override_property (gobject_class, 1, "device");
  g_object_class_override_property (gobject_class, 2, "manager");
}

/**
 * fprint_dbus_object_proxy_new:
 * @connection: A #GDBusConnection.
 * @object_path: An object path.
 *
 * Creates a new proxy object.
 *
 * Returns: (transfer full): The proxy object.
 */
FprintDBusObjectProxy *
fprint_dbus_object_proxy_new (GDBusConnection *connection,
  const gchar *object_path)
{
  g_return_val_if_fail (G_IS_DBUS_CONNECTION (connection), NULL);
  g_return_val_if_fail (g_variant_is_object_path (object_path), NULL);
  return FPRINT_DBUS_OBJECT_PROXY (g_object_new (FPRINT_DBUS_TYPE_OBJECT_PROXY, "g-connection", connection, "g-object-path", object_path, NULL));
}

/**
 * FprintDBusObjectSkeleton:
 *
 * The #FprintDBusObjectSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * FprintDBusObjectSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #FprintDBusObjectSkeleton.
 */

static void
fprint_dbus_object_skeleton__fprint_dbus_object_iface_init (FprintDBusObjectIface *iface G_GNUC_UNUSED)
{
}


static void
fprint_dbus_object_skeleton__g_dbus_object_iface_init (GDBusObjectIface *iface)
{
  iface->interface_added = fprint_dbus_object_notify;
  iface->interface_removed = fprint_dbus_object_notify;
}

G_DEFINE_TYPE_WITH_CODE (FprintDBusObjectSkeleton, fprint_dbus_object_skeleton, G_TYPE_DBUS_OBJECT_SKELETON,
                         G_IMPLEMENT_INTERFACE (FPRINT_DBUS_TYPE_OBJECT, fprint_dbus_object_skeleton__fprint_dbus_object_iface_init)
                         G_IMPLEMENT_INTERFACE (G_TYPE_DBUS_OBJECT, fprint_dbus_object_skeleton__g_dbus_object_iface_init))

static void
fprint_dbus_object_skeleton_init (FprintDBusObjectSkeleton *object G_GNUC_UNUSED)
{
}

static void
fprint_dbus_object_skeleton_set_property (GObject      *gobject,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  FprintDBusObjectSkeleton *object = FPRINT_DBUS_OBJECT_SKELETON (gobject);
  GDBusInterfaceSkeleton *interface;

  switch (prop_id)
    {
    case 1:
      interface = g_value_get_object (value);
      if (interface != NULL)
        {
          g_warn_if_fail (FPRINT_DBUS_IS_DEVICE (interface));
          g_dbus_object_skeleton_add_interface (G_DBUS_OBJECT_SKELETON (object), interface);
        }
      else
        {
          g_dbus_object_skeleton_remove_interface_by_name (G_DBUS_OBJECT_SKELETON (object), "net.reactivated.Fprint.Device");
        }
      break;

    case 2:
      interface = g_value_get_object (value);
      if (interface != NULL)
        {
          g_warn_if_fail (FPRINT_DBUS_IS_MANAGER (interface));
          g_dbus_object_skeleton_add_interface (G_DBUS_OBJECT_SKELETON (object), interface);
        }
      else
        {
          g_dbus_object_skeleton_remove_interface_by_name (G_DBUS_OBJECT_SKELETON (object), "net.reactivated.Fprint.Manager");
        }
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
      break;
  }
}

static void
fprint_dbus_object_skeleton_get_property (GObject      *gobject,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec)
{
  FprintDBusObjectSkeleton *object = FPRINT_DBUS_OBJECT_SKELETON (gobject);
  GDBusInterface *interface;

  switch (prop_id)
    {
    case 1:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "net.reactivated.Fprint.Device");
      g_value_take_object (value, interface);
      break;

    case 2:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "net.reactivated.Fprint.Manager");
      g_value_take_object (value, interface);
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
      break;
  }
}

static void
fprint_dbus_object_skeleton_class_init (FprintDBusObjectSkeletonClass *klass)
{
  GObjectClass *gobject_class = G_OBJECT_CLASS (klass);

  gobject_class->set_property = fprint_dbus_object_skeleton_set_property;
  gobject_class->get_property = fprint_dbus_object_skeleton_get_property;

  g_object_class_override_property (gobject_class, 1, "device");
  g_object_class_override_property (gobject_class, 2, "manager");
}

/**
 * fprint_dbus_object_skeleton_new:
 * @object_path: An object path.
 *
 * Creates a new skeleton object.
 *
 * Returns: (transfer full): The skeleton object.
 */
FprintDBusObjectSkeleton *
fprint_dbus_object_skeleton_new (const gchar *object_path)
{
  g_return_val_if_fail (g_variant_is_object_path (object_path), NULL);
  return FPRINT_DBUS_OBJECT_SKELETON (g_object_new (FPRINT_DBUS_TYPE_OBJECT_SKELETON, "g-object-path", object_path, NULL));
}

/**
 * fprint_dbus_object_skeleton_set_device:
 * @object: A #FprintDBusObjectSkeleton.
 * @interface_: (nullable): A #FprintDBusDevice or %NULL to clear the interface.
 *
 * Sets the #FprintDBusDevice instance for the D-Bus interface <link linkend="gdbus-interface-net-reactivated-Fprint-Device.top_of_page">net.reactivated.Fprint.Device</link> on @object.
 */
void fprint_dbus_object_skeleton_set_device (FprintDBusObjectSkeleton *object, FprintDBusDevice *interface_)
{
  g_object_set (G_OBJECT (object), "device", interface_, NULL);
}

/**
 * fprint_dbus_object_skeleton_set_manager:
 * @object: A #FprintDBusObjectSkeleton.
 * @interface_: (nullable): A #FprintDBusManager or %NULL to clear the interface.
 *
 * Sets the #FprintDBusManager instance for the D-Bus interface <link linkend="gdbus-interface-net-reactivated-Fprint-Manager.top_of_page">net.reactivated.Fprint.Manager</link> on @object.
 */
void fprint_dbus_object_skeleton_set_manager (FprintDBusObjectSkeleton *object, FprintDBusManager *interface_)
{
  g_object_set (G_OBJECT (object), "manager", interface_, NULL);
}


/* ------------------------------------------------------------------------
 * Code for ObjectManager client
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:FprintDBusObjectManagerClient
 * @title: FprintDBusObjectManagerClient
 * @short_description: Generated GDBusObjectManagerClient type
 *
 * This section contains a #GDBusObjectManagerClient that uses fprint_dbus_object_manager_client_get_proxy_type() as the #GDBusProxyTypeFunc.
 */

/**
 * FprintDBusObjectManagerClient:
 *
 * The #FprintDBusObjectManagerClient structure contains only private data and should only be accessed using the provided API.
 */

/**
 * FprintDBusObjectManagerClientClass:
 * @parent_class: The parent class.
 *
 * Class structure for #FprintDBusObjectManagerClient.
 */

G_DEFINE_TYPE (FprintDBusObjectManagerClient, fprint_dbus_object_manager_client, G_TYPE_DBUS_OBJECT_MANAGER_CLIENT)

static void
fprint_dbus_object_manager_client_init (FprintDBusObjectManagerClient *manager G_GNUC_UNUSED)
{
}

static void
fprint_dbus_object_manager_client_class_init (FprintDBusObjectManagerClientClass *klass G_GNUC_UNUSED)
{
}

/**
 * fprint_dbus_object_manager_client_get_proxy_type:
 * @manager: A #GDBusObjectManagerClient.
 * @object_path: The object path of the remote object (unused).
 * @interface_name: (nullable): Interface name of the remote object or %NULL to get the object proxy #GType.
 * @user_data: User data (unused).
 *
 * A #GDBusProxyTypeFunc that maps @interface_name to the generated #GDBusObjectProxy derived and #GDBusProxy derived types.
 *
 * Returns: A #GDBusProxy derived #GType if @interface_name is not %NULL, otherwise the #GType for #FprintDBusObjectProxy.
 */
GType
fprint_dbus_object_manager_client_get_proxy_type (GDBusObjectManagerClient *manager G_GNUC_UNUSED, const gchar *object_path G_GNUC_UNUSED, const gchar *interface_name, gpointer user_data G_GNUC_UNUSED)
{
  static gsize once_init_value = 0;
  static GHashTable *lookup_hash;
  GType ret;

  if (interface_name == NULL)
    return FPRINT_DBUS_TYPE_OBJECT_PROXY;
  if (g_once_init_enter (&once_init_value))
    {
      lookup_hash = g_hash_table_new (g_str_hash, g_str_equal);
      g_hash_table_insert (lookup_hash, (gpointer) "net.reactivated.Fprint.Device", (gpointer) (guintptr) (FPRINT_DBUS_TYPE_DEVICE_PROXY));
      g_hash_table_insert (lookup_hash, (gpointer) "net.reactivated.Fprint.Manager", (gpointer) (guintptr) (FPRINT_DBUS_TYPE_MANAGER_PROXY));
      g_once_init_leave (&once_init_value, 1);
    }
  ret = (GType) (guintptr) (g_hash_table_lookup (lookup_hash, interface_name));
  if (ret == (GType) 0)
    ret = G_TYPE_DBUS_PROXY;
  return ret;
}

/**
 * fprint_dbus_object_manager_client_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates #GDBusObjectManagerClient using fprint_dbus_object_manager_client_get_proxy_type() as the #GDBusProxyTypeFunc. See g_dbus_object_manager_client_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call fprint_dbus_object_manager_client_new_finish() to get the result of the operation.
 *
 * See fprint_dbus_object_manager_client_new_sync() for the synchronous, blocking version of this constructor.
 */
void
fprint_dbus_object_manager_client_new (
    GDBusConnection        *connection,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GAsyncReadyCallback     callback,
    gpointer                user_data)
{
  g_async_initable_new_async (FPRINT_DBUS_TYPE_OBJECT_MANAGER_CLIENT, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "flags", flags, "name", name, "connection", connection, "object-path", object_path, "get-proxy-type-func", fprint_dbus_object_manager_client_get_proxy_type, NULL);
}

/**
 * fprint_dbus_object_manager_client_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to fprint_dbus_object_manager_client_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with fprint_dbus_object_manager_client_new().
 *
 * Returns: (transfer full) (type FprintDBusObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
fprint_dbus_object_manager_client_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}

/**
 * fprint_dbus_object_manager_client_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates #GDBusObjectManagerClient using fprint_dbus_object_manager_client_get_proxy_type() as the #GDBusProxyTypeFunc. See g_dbus_object_manager_client_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See fprint_dbus_object_manager_client_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type FprintDBusObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
fprint_dbus_object_manager_client_new_sync (
    GDBusConnection        *connection,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GError                **error)
{
  GInitable *ret;
  ret = g_initable_new (FPRINT_DBUS_TYPE_OBJECT_MANAGER_CLIENT, cancellable, error, "flags", flags, "name", name, "connection", connection, "object-path", object_path, "get-proxy-type-func", fprint_dbus_object_manager_client_get_proxy_type, NULL);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}


/**
 * fprint_dbus_object_manager_client_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like fprint_dbus_object_manager_client_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call fprint_dbus_object_manager_client_new_for_bus_finish() to get the result of the operation.
 *
 * See fprint_dbus_object_manager_client_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
fprint_dbus_object_manager_client_new_for_bus (
    GBusType                bus_type,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GAsyncReadyCallback     callback,
    gpointer                user_data)
{
  g_async_initable_new_async (FPRINT_DBUS_TYPE_OBJECT_MANAGER_CLIENT, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "flags", flags, "name", name, "bus-type", bus_type, "object-path", object_path, "get-proxy-type-func", fprint_dbus_object_manager_client_get_proxy_type, NULL);
}

/**
 * fprint_dbus_object_manager_client_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to fprint_dbus_object_manager_client_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with fprint_dbus_object_manager_client_new_for_bus().
 *
 * Returns: (transfer full) (type FprintDBusObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
fprint_dbus_object_manager_client_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}

/**
 * fprint_dbus_object_manager_client_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like fprint_dbus_object_manager_client_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See fprint_dbus_object_manager_client_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type FprintDBusObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
fprint_dbus_object_manager_client_new_for_bus_sync (
    GBusType                bus_type,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GError                **error)
{
  GInitable *ret;
  ret = g_initable_new (FPRINT_DBUS_TYPE_OBJECT_MANAGER_CLIENT, cancellable, error, "flags", flags, "name", name, "bus-type", bus_type, "object-path", object_path, "get-proxy-type-func", fprint_dbus_object_manager_client_get_proxy_type, NULL);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}


