#include "sysconfig.h"
#include "sysdeps.h"
#include "options.h"
#include "uae/memory.h"
#include "custom.h"
#include "events.h"
#include "newcpu.h"
#include "cpu_prefetch.h"
#include "cputbl.h"
#define CPUFUNC(x) x##_ff
#define SET_CFLG_ALWAYS(x) SET_CFLG(x)
#define SET_NFLG_ALWAYS(x) SET_NFLG(x)
#ifdef NOFLAGS
#include "noflags.h"
#endif

#ifdef CPUEMU_23

#pragma GCC diagnostic ignored "-Wunused-variable"
#if !defined __clang_analyzer__

#if !defined(PART_1) && !defined(PART_2) && !defined(PART_3) && !defined(PART_4) && !defined(PART_5) && !defined(PART_6) && !defined(PART_7) && !defined(PART_8)
#define PART_1 1
#define PART_2 1
#define PART_3 1
#define PART_4 1
#define PART_5 1
#define PART_6 1
#define PART_7 1
#define PART_8 1
#endif

#ifdef PART_1
/* OR.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_0000_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2+2=4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	/* op H:2-,T:0,C:0 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.irc = get_word_ce030_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpci (4);
return;
}

/* OR.B #<data>.B,(An) */
void REGPARAM2 CPUFUNC(op_0010_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* OR.B #<data>.B,(An)+ */
void REGPARAM2 CPUFUNC(op_0018_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:1,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* OR.B #<data>.B,-(An) */
void REGPARAM2 CPUFUNC(op_0020_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* OR.B #<data>.B,(d16,An) */
void REGPARAM2 CPUFUNC(op_0028_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* OR.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0030_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}}return;
}

/* OR.B #<data>.B,(xxx).W */
void REGPARAM2 CPUFUNC(op_0038_23)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* OR.B #<data>.B,(xxx).L */
void REGPARAM2 CPUFUNC(op_0039_23)(uae_u32 opcode)
{
{	/* ea H:3,T:0,C:3 fiea */
	if (regs.ce020memcycles > 3 * cpucycleunit)
		regs.ce020memcycles = 3 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (8);
return;
}

/* ORSR.B #<data>.W */
void REGPARAM2 CPUFUNC(op_003c_23)(uae_u32 opcode)
{
{	MakeSR ();
{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
	src &= 0xFF;
	regs.sr |= src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	regs.irc = get_word_ce030_prefetch (4);
}}	m68k_incpci (4);
return;
}

/* OR.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_0040_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2+2=4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* op H:2-,T:0,C:0 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.irc = get_word_ce030_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpci (4);
return;
}

/* OR.W #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_0050_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* OR.W #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_0058_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:1,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* OR.W #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_0060_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* OR.W #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_0068_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* OR.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0070_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}}return;
}

/* OR.W #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_0078_23)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* OR.W #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_0079_23)(uae_u32 opcode)
{
{	/* ea H:3,T:0,C:3 fiea */
	if (regs.ce020memcycles > 3 * cpucycleunit)
		regs.ce020memcycles = 3 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce030_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (8);
return;
}

/* ORSR.W #<data>.W */
void REGPARAM2 CPUFUNC(op_007c_23)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_230018; }
{	MakeSR ();
{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
	regs.sr |= src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	regs.irc = get_word_ce030_prefetch (4);
}}}	m68k_incpci (4);
l_230018: ;
return;
}

/* OR.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_0080_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4+2=6,T:0,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:2-,T:0,C:0 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.irc = get_word_ce030_prefetch (6);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpci (6);
return;
}

/* OR.L #<data>.L,(An) */
void REGPARAM2 CPUFUNC(op_0090_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:0,C:3 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* OR.L #<data>.L,(An)+ */
void REGPARAM2 CPUFUNC(op_0098_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:1,C:2 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* OR.L #<data>.L,-(An) */
void REGPARAM2 CPUFUNC(op_00a0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* OR.L #<data>.L,(d16,An) */
void REGPARAM2 CPUFUNC(op_00a8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:0,C:2 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (6);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce030_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (8);
return;
}

/* OR.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_00b0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:8,T:2,C:0 fiea */
	if (regs.ce020memcycles > 8 * cpucycleunit)
		regs.ce020memcycles = 8 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (6);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}}return;
}

/* OR.L #<data>.L,(xxx).W */
void REGPARAM2 CPUFUNC(op_00b8_23)(uae_u32 opcode)
{
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (6);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce030_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (8);
return;
}

/* OR.L #<data>.L,(xxx).L */
void REGPARAM2 CPUFUNC(op_00b9_23)(uae_u32 opcode)
{
{	/* ea H:5,T:0,C:3 fiea */
	if (regs.ce020memcycles > 5 * cpucycleunit)
		regs.ce020memcycles = 5 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (6);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce030_prefetch (10);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (10);
return;
}

/* CHK2.B #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_00d0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)x_get_byte (dsta); upper = (uae_s32)(uae_s8)x_get_byte (dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_230027; }
}
	regs.irc = get_word_ce030_prefetch (4);
}}}	m68k_incpci (4);
l_230027: ;
return;
}

#endif
/* CHK2.B #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_00e8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)x_get_byte (dsta); upper = (uae_s32)(uae_s8)x_get_byte (dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_230028; }
}
	regs.irc = get_word_ce030_prefetch (6);
}}}	m68k_incpci (6);
l_230028: ;
return;
}

#endif
/* CHK2.B #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_00f0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)x_get_byte (dsta); upper = (uae_s32)(uae_s8)x_get_byte (dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_230029; }
}
	regs.irc = get_word_ce030_prefetch (0);
}}}}l_230029: ;
return;
}

#endif
/* CHK2.B #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_00f8_23)(uae_u32 opcode)
{
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)x_get_byte (dsta); upper = (uae_s32)(uae_s8)x_get_byte (dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_230030; }
}
	regs.irc = get_word_ce030_prefetch (6);
}}}	m68k_incpci (6);
l_230030: ;
return;
}

#endif
/* CHK2.B #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_00f9_23)(uae_u32 opcode)
{
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (4);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)x_get_byte (dsta); upper = (uae_s32)(uae_s8)x_get_byte (dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_230031; }
}
	regs.irc = get_word_ce030_prefetch (8);
}}}	m68k_incpci (8);
l_230031: ;
return;
}

#endif
/* CHK2.B #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_00fa_23)(uae_u32 opcode)
{
	uae_u32 dstreg = 2;
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_getpci () + 4;
	dsta += (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)x_get_byte (dsta); upper = (uae_s32)(uae_s8)x_get_byte (dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_230032; }
}
	regs.irc = get_word_ce030_prefetch (6);
}}}	m68k_incpci (6);
l_230032: ;
return;
}

#endif
/* CHK2.B #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_00fb_23)(uae_u32 opcode)
{
	uae_u32 dstreg = 3;
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr tmppc;
	uaecptr dsta;
	m68k_incpci (4);
{	tmppc = m68k_getpci ();
	dsta = x_get_disp_ea_ce030 (tmppc, 0);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)x_get_byte (dsta); upper = (uae_s32)(uae_s8)x_get_byte (dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_230033; }
}
	regs.irc = get_word_ce030_prefetch (0);
}}}}l_230033: ;
return;
}

#endif
/* BTST.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_0100_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:4,T:0,C:0 */
	src &= 31;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (2);
}}}	m68k_incpci (2);
return;
}

/* MVPMR.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_0108_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr memp = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	/* OP zero */
	uae_u16 val = ((x_get_byte (memp) & 0xff) << 8) + (x_get_byte (memp + 2) & 0xff);
	regs.irc = get_word_ce030_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}	m68k_incpci (4);
return;
}

/* BTST.B Dn,(An) */
void REGPARAM2 CPUFUNC(op_0110_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	do_cycles_ce020_internal (2);
}}}}	m68k_incpci (2);
return;
}

/* BTST.B Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_0118_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	do_cycles_ce020_internal (2);
}}}}	m68k_incpci (2);
return;
}

/* BTST.B Dn,-(An) */
void REGPARAM2 CPUFUNC(op_0120_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	do_cycles_ce020_internal (2);
}}}}	m68k_incpci (2);
return;
}

/* BTST.B Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_0128_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	do_cycles_ce020_internal (2);
}}}}	m68k_incpci (4);
return;
}

/* BTST.B Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0130_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	do_cycles_ce020_internal (2);
}}}}}return;
}

/* BTST.B Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_0138_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	do_cycles_ce020_internal (2);
}}}}	m68k_incpci (4);
return;
}

/* BTST.B Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_0139_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	do_cycles_ce020_internal (2);
}}}}	m68k_incpci (6);
return;
}

/* BTST.B Dn,(d16,PC) */
void REGPARAM2 CPUFUNC(op_013a_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = 2;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_getpci () + 2;
	dsta += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	do_cycles_ce020_internal (2);
}}}}	m68k_incpci (4);
return;
}

/* BTST.B Dn,(d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_013b_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = 3;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr tmppc;
	uaecptr dsta;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	dsta = x_get_disp_ea_ce030 (tmppc, 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	do_cycles_ce020_internal (2);
}}}}}return;
}

/* BTST.B Dn,#<data>.B */
void REGPARAM2 CPUFUNC(op_013c_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = (uae_u8)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	do_cycles_ce020_internal (2);
}}}	m68k_incpci (4);
return;
}

/* BCHG.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_0140_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:6,T:0,C:0 */
	src &= 31;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (4);
	m68k_dreg (regs, dstreg) = (dst);
}}}	m68k_incpci (2);
return;
}

/* MVPMR.L (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_0148_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr memp = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	/* OP zero */
	uae_u32 val = ((x_get_byte (memp) & 0xff) << 24) + ((x_get_byte (memp + 2) & 0xff) << 16)
              + ((x_get_byte (memp + 4) & 0xff) << 8) + (x_get_byte (memp + 6) & 0xff);
	regs.irc = get_word_ce030_prefetch (4);
	m68k_dreg (regs, dstreg) = (val);
}}	m68k_incpci (4);
return;
}

/* BCHG.B Dn,(An) */
void REGPARAM2 CPUFUNC(op_0150_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (2);
return;
}

/* BCHG.B Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_0158_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (2);
return;
}

/* BCHG.B Dn,-(An) */
void REGPARAM2 CPUFUNC(op_0160_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (2);
return;
}

/* BCHG.B Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_0168_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
}

/* BCHG.B Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0170_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}}return;
}

/* BCHG.B Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_0178_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
}

/* BCHG.B Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_0179_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (6);
return;
}

/* BCLR.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_0180_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:6,T:0,C:0 */
	src &= 31;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (4);
	m68k_dreg (regs, dstreg) = (dst);
}}}	m68k_incpci (2);
return;
}

/* MVPRM.W Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_0188_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	/* OP zero */
	uaecptr memp = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	x_put_byte (memp, src >> 8);
	x_put_byte (memp + 2, src);
	regs.irc = get_word_ce030_prefetch (4);
}}	m68k_incpci (4);
return;
}

/* BCLR.B Dn,(An) */
void REGPARAM2 CPUFUNC(op_0190_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (2);
return;
}

/* BCLR.B Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_0198_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (2);
return;
}

/* BCLR.B Dn,-(An) */
void REGPARAM2 CPUFUNC(op_01a0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (2);
return;
}

/* BCLR.B Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_01a8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
}

/* BCLR.B Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_01b0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}}return;
}

/* BCLR.B Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_01b8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
}

/* BCLR.B Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_01b9_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (6);
return;
}

/* BSET.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_01c0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:6,T:0,C:0 */
	src &= 31;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (4);
	m68k_dreg (regs, dstreg) = (dst);
}}}	m68k_incpci (2);
return;
}

/* MVPRM.L Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_01c8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	/* OP zero */
	uaecptr memp = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	x_put_byte (memp, src >> 24);
	x_put_byte (memp + 2, src >> 16);
	x_put_byte (memp + 4, src >> 8);
	x_put_byte (memp + 6, src);
	regs.irc = get_word_ce030_prefetch (4);
}}	m68k_incpci (4);
return;
}

/* BSET.B Dn,(An) */
void REGPARAM2 CPUFUNC(op_01d0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (2);
return;
}

/* BSET.B Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_01d8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (2);
return;
}

/* BSET.B Dn,-(An) */
void REGPARAM2 CPUFUNC(op_01e0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (2);
return;
}

/* BSET.B Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_01e8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
}

/* BSET.B Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_01f0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}}return;
}

/* BSET.B Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_01f8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
}

/* BSET.B Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_01f9_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (6);
return;
}

/* AND.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_0200_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2+2=4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	/* op H:2-,T:0,C:0 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.irc = get_word_ce030_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpci (4);
return;
}

/* AND.B #<data>.B,(An) */
void REGPARAM2 CPUFUNC(op_0210_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* AND.B #<data>.B,(An)+ */
void REGPARAM2 CPUFUNC(op_0218_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:1,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* AND.B #<data>.B,-(An) */
void REGPARAM2 CPUFUNC(op_0220_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* AND.B #<data>.B,(d16,An) */
void REGPARAM2 CPUFUNC(op_0228_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* AND.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0230_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}}return;
}

/* AND.B #<data>.B,(xxx).W */
void REGPARAM2 CPUFUNC(op_0238_23)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* AND.B #<data>.B,(xxx).L */
void REGPARAM2 CPUFUNC(op_0239_23)(uae_u32 opcode)
{
{	/* ea H:3,T:0,C:3 fiea */
	if (regs.ce020memcycles > 3 * cpucycleunit)
		regs.ce020memcycles = 3 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (8);
return;
}

/* ANDSR.B #<data>.W */
void REGPARAM2 CPUFUNC(op_023c_23)(uae_u32 opcode)
{
{	MakeSR ();
{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
	src |= 0xFF00;
	regs.sr &= src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	regs.irc = get_word_ce030_prefetch (4);
}}	m68k_incpci (4);
return;
}

/* AND.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_0240_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2+2=4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* op H:2-,T:0,C:0 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.irc = get_word_ce030_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpci (4);
return;
}

/* AND.W #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_0250_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* AND.W #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_0258_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:1,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* AND.W #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_0260_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* AND.W #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_0268_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* AND.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0270_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}}return;
}

/* AND.W #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_0278_23)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* AND.W #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_0279_23)(uae_u32 opcode)
{
{	/* ea H:3,T:0,C:3 fiea */
	if (regs.ce020memcycles > 3 * cpucycleunit)
		regs.ce020memcycles = 3 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce030_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (8);
return;
}

/* ANDSR.W #<data>.W */
void REGPARAM2 CPUFUNC(op_027c_23)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_230090; }
{	MakeSR ();
{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
	regs.sr &= src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	regs.irc = get_word_ce030_prefetch (4);
}}}	m68k_incpci (4);
l_230090: ;
return;
}

/* AND.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_0280_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4+2=6,T:0,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:2-,T:0,C:0 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.irc = get_word_ce030_prefetch (6);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpci (6);
return;
}

/* AND.L #<data>.L,(An) */
void REGPARAM2 CPUFUNC(op_0290_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:0,C:3 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* AND.L #<data>.L,(An)+ */
void REGPARAM2 CPUFUNC(op_0298_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:1,C:2 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* AND.L #<data>.L,-(An) */
void REGPARAM2 CPUFUNC(op_02a0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* AND.L #<data>.L,(d16,An) */
void REGPARAM2 CPUFUNC(op_02a8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:0,C:2 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (6);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce030_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (8);
return;
}

/* AND.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_02b0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:8,T:2,C:0 fiea */
	if (regs.ce020memcycles > 8 * cpucycleunit)
		regs.ce020memcycles = 8 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (6);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}}return;
}

/* AND.L #<data>.L,(xxx).W */
void REGPARAM2 CPUFUNC(op_02b8_23)(uae_u32 opcode)
{
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (6);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce030_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (8);
return;
}

/* AND.L #<data>.L,(xxx).L */
void REGPARAM2 CPUFUNC(op_02b9_23)(uae_u32 opcode)
{
{	/* ea H:5,T:0,C:3 fiea */
	if (regs.ce020memcycles > 5 * cpucycleunit)
		regs.ce020memcycles = 5 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (6);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce030_prefetch (10);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (10);
return;
}

/* CHK2.W #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_02d0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)x_get_word (dsta); upper = (uae_s32)(uae_s16)x_get_word (dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_230099; }
}
	regs.irc = get_word_ce030_prefetch (4);
}}}	m68k_incpci (4);
l_230099: ;
return;
}

#endif
/* CHK2.W #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_02e8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)x_get_word (dsta); upper = (uae_s32)(uae_s16)x_get_word (dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_230100; }
}
	regs.irc = get_word_ce030_prefetch (6);
}}}	m68k_incpci (6);
l_230100: ;
return;
}

#endif
/* CHK2.W #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_02f0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)x_get_word (dsta); upper = (uae_s32)(uae_s16)x_get_word (dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_230101; }
}
	regs.irc = get_word_ce030_prefetch (0);
}}}}l_230101: ;
return;
}

#endif
/* CHK2.W #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_02f8_23)(uae_u32 opcode)
{
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)x_get_word (dsta); upper = (uae_s32)(uae_s16)x_get_word (dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_230102; }
}
	regs.irc = get_word_ce030_prefetch (6);
}}}	m68k_incpci (6);
l_230102: ;
return;
}

#endif
/* CHK2.W #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_02f9_23)(uae_u32 opcode)
{
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (4);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)x_get_word (dsta); upper = (uae_s32)(uae_s16)x_get_word (dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_230103; }
}
	regs.irc = get_word_ce030_prefetch (8);
}}}	m68k_incpci (8);
l_230103: ;
return;
}

#endif
/* CHK2.W #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_02fa_23)(uae_u32 opcode)
{
	uae_u32 dstreg = 2;
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_getpci () + 4;
	dsta += (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)x_get_word (dsta); upper = (uae_s32)(uae_s16)x_get_word (dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_230104; }
}
	regs.irc = get_word_ce030_prefetch (6);
}}}	m68k_incpci (6);
l_230104: ;
return;
}

#endif
/* CHK2.W #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_02fb_23)(uae_u32 opcode)
{
	uae_u32 dstreg = 3;
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr tmppc;
	uaecptr dsta;
	m68k_incpci (4);
{	tmppc = m68k_getpci ();
	dsta = x_get_disp_ea_ce030 (tmppc, 0);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)x_get_word (dsta); upper = (uae_s32)(uae_s16)x_get_word (dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_230105; }
}
	regs.irc = get_word_ce030_prefetch (0);
}}}}l_230105: ;
return;
}

#endif
/* SUB.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_0400_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2+2=4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	/* op H:2-,T:0,C:0 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce030_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpci (4);
return;
}

/* SUB.B #<data>.B,(An) */
void REGPARAM2 CPUFUNC(op_0410_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.B #<data>.B,(An)+ */
void REGPARAM2 CPUFUNC(op_0418_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:1,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.B #<data>.B,-(An) */
void REGPARAM2 CPUFUNC(op_0420_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.B #<data>.B,(d16,An) */
void REGPARAM2 CPUFUNC(op_0428_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* SUB.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0430_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}}return;
}

/* SUB.B #<data>.B,(xxx).W */
void REGPARAM2 CPUFUNC(op_0438_23)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* SUB.B #<data>.B,(xxx).L */
void REGPARAM2 CPUFUNC(op_0439_23)(uae_u32 opcode)
{
{	/* ea H:3,T:0,C:3 fiea */
	if (regs.ce020memcycles > 3 * cpucycleunit)
		regs.ce020memcycles = 3 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (8);
return;
}

/* SUB.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_0440_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2+2=4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* op H:2-,T:0,C:0 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce030_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpci (4);
return;
}

/* SUB.W #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_0450_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.W #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_0458_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:1,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.W #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_0460_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.W #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_0468_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* SUB.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0470_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}}return;
}

/* SUB.W #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_0478_23)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* SUB.W #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_0479_23)(uae_u32 opcode)
{
{	/* ea H:3,T:0,C:3 fiea */
	if (regs.ce020memcycles > 3 * cpucycleunit)
		regs.ce020memcycles = 3 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce030_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (8);
return;
}

/* SUB.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_0480_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4+2=6,T:0,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:2-,T:0,C:0 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce030_prefetch (6);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (6);
return;
}

/* SUB.L #<data>.L,(An) */
void REGPARAM2 CPUFUNC(op_0490_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:0,C:3 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* SUB.L #<data>.L,(An)+ */
void REGPARAM2 CPUFUNC(op_0498_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:1,C:2 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* SUB.L #<data>.L,-(An) */
void REGPARAM2 CPUFUNC(op_04a0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* SUB.L #<data>.L,(d16,An) */
void REGPARAM2 CPUFUNC(op_04a8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:0,C:2 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (6);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce030_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (8);
return;
}

/* SUB.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_04b0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:8,T:2,C:0 fiea */
	if (regs.ce020memcycles > 8 * cpucycleunit)
		regs.ce020memcycles = 8 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (6);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}}return;
}

/* SUB.L #<data>.L,(xxx).W */
void REGPARAM2 CPUFUNC(op_04b8_23)(uae_u32 opcode)
{
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (6);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce030_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (8);
return;
}

/* SUB.L #<data>.L,(xxx).L */
void REGPARAM2 CPUFUNC(op_04b9_23)(uae_u32 opcode)
{
{	/* ea H:5,T:0,C:3 fiea */
	if (regs.ce020memcycles > 5 * cpucycleunit)
		regs.ce020memcycles = 5 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (6);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce030_prefetch (10);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (10);
return;
}

/* CHK2.L #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_04d0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = x_get_long (dsta); upper = x_get_long (dsta + 4);
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_230130; }
}
	regs.irc = get_word_ce030_prefetch (4);
}}}	m68k_incpci (4);
l_230130: ;
return;
}

#endif
/* CHK2.L #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_04e8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = x_get_long (dsta); upper = x_get_long (dsta + 4);
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_230131; }
}
	regs.irc = get_word_ce030_prefetch (6);
}}}	m68k_incpci (6);
l_230131: ;
return;
}

#endif
/* CHK2.L #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_04f0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = x_get_long (dsta); upper = x_get_long (dsta + 4);
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_230132; }
}
	regs.irc = get_word_ce030_prefetch (0);
}}}}l_230132: ;
return;
}

#endif
/* CHK2.L #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_04f8_23)(uae_u32 opcode)
{
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = x_get_long (dsta); upper = x_get_long (dsta + 4);
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_230133; }
}
	regs.irc = get_word_ce030_prefetch (6);
}}}	m68k_incpci (6);
l_230133: ;
return;
}

#endif
/* CHK2.L #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_04f9_23)(uae_u32 opcode)
{
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (4);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = x_get_long (dsta); upper = x_get_long (dsta + 4);
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_230134; }
}
	regs.irc = get_word_ce030_prefetch (8);
}}}	m68k_incpci (8);
l_230134: ;
return;
}

#endif
/* CHK2.L #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_04fa_23)(uae_u32 opcode)
{
	uae_u32 dstreg = 2;
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_getpci () + 4;
	dsta += (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = x_get_long (dsta); upper = x_get_long (dsta + 4);
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_230135; }
}
	regs.irc = get_word_ce030_prefetch (6);
}}}	m68k_incpci (6);
l_230135: ;
return;
}

#endif
/* CHK2.L #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_04fb_23)(uae_u32 opcode)
{
	uae_u32 dstreg = 3;
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr tmppc;
	uaecptr dsta;
	m68k_incpci (4);
{	tmppc = m68k_getpci ();
	dsta = x_get_disp_ea_ce030 (tmppc, 0);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = x_get_long (dsta); upper = x_get_long (dsta + 4);
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_230136; }
}
	regs.irc = get_word_ce030_prefetch (0);
}}}}l_230136: ;
return;
}

#endif
/* ADD.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_0600_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2+2=4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	/* op H:2-,T:0,C:0 */
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce030_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpci (4);
return;
}

/* ADD.B #<data>.B,(An) */
void REGPARAM2 CPUFUNC(op_0610_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* ADD.B #<data>.B,(An)+ */
void REGPARAM2 CPUFUNC(op_0618_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:1,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* ADD.B #<data>.B,-(An) */
void REGPARAM2 CPUFUNC(op_0620_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* ADD.B #<data>.B,(d16,An) */
void REGPARAM2 CPUFUNC(op_0628_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* ADD.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0630_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}}return;
}

/* ADD.B #<data>.B,(xxx).W */
void REGPARAM2 CPUFUNC(op_0638_23)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* ADD.B #<data>.B,(xxx).L */
void REGPARAM2 CPUFUNC(op_0639_23)(uae_u32 opcode)
{
{	/* ea H:3,T:0,C:3 fiea */
	if (regs.ce020memcycles > 3 * cpucycleunit)
		regs.ce020memcycles = 3 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (8);
return;
}

/* ADD.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_0640_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2+2=4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* op H:2-,T:0,C:0 */
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce030_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpci (4);
return;
}

/* ADD.W #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_0650_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* ADD.W #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_0658_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:1,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* ADD.W #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_0660_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* ADD.W #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_0668_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* ADD.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0670_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}}return;
}

/* ADD.W #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_0678_23)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* ADD.W #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_0679_23)(uae_u32 opcode)
{
{	/* ea H:3,T:0,C:3 fiea */
	if (regs.ce020memcycles > 3 * cpucycleunit)
		regs.ce020memcycles = 3 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce030_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (8);
return;
}

/* ADD.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_0680_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4+2=6,T:0,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:2-,T:0,C:0 */
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce030_prefetch (6);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (6);
return;
}

/* ADD.L #<data>.L,(An) */
void REGPARAM2 CPUFUNC(op_0690_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:0,C:3 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* ADD.L #<data>.L,(An)+ */
void REGPARAM2 CPUFUNC(op_0698_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:1,C:2 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* ADD.L #<data>.L,-(An) */
void REGPARAM2 CPUFUNC(op_06a0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* ADD.L #<data>.L,(d16,An) */
void REGPARAM2 CPUFUNC(op_06a8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:0,C:2 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (6);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce030_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (8);
return;
}

/* ADD.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_06b0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:8,T:2,C:0 fiea */
	if (regs.ce020memcycles > 8 * cpucycleunit)
		regs.ce020memcycles = 8 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (6);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}}return;
}

/* ADD.L #<data>.L,(xxx).W */
void REGPARAM2 CPUFUNC(op_06b8_23)(uae_u32 opcode)
{
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (6);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce030_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (8);
return;
}

/* ADD.L #<data>.L,(xxx).L */
void REGPARAM2 CPUFUNC(op_06b9_23)(uae_u32 opcode)
{
{	/* ea H:5,T:0,C:3 fiea */
	if (regs.ce020memcycles > 5 * cpucycleunit)
		regs.ce020memcycles = 5 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (6);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce030_prefetch (10);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (10);
return;
}

/* RTM.L Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_06c0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	m68k_incpci (2);
	op_illg (opcode);
}return;
}

#endif
/* RTM.L An */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_06c8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	m68k_incpci (2);
	op_illg (opcode);
}return;
}

#endif
/* CALLM.L (An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_06d0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	m68k_incpci (2);
	op_illg (opcode);
}return;
}

#endif
/* CALLM.L (d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_06e8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	m68k_incpci (2);
	op_illg (opcode);
}return;
}

#endif
/* CALLM.L (d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_06f0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	m68k_incpci (2);
	op_illg (opcode);
}return;
}

#endif
/* CALLM.L (xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_06f8_23)(uae_u32 opcode)
{
{	m68k_incpci (2);
	op_illg (opcode);
}return;
}

#endif
/* CALLM.L (xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_06f9_23)(uae_u32 opcode)
{
{	m68k_incpci (2);
	op_illg (opcode);
}return;
}

#endif
/* CALLM.L (d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_06fa_23)(uae_u32 opcode)
{
{	m68k_incpci (2);
	op_illg (opcode);
}return;
}

#endif
/* CALLM.L (d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_06fb_23)(uae_u32 opcode)
{
{	m68k_incpci (2);
	op_illg (opcode);
}return;
}

#endif
/* BTST.L #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_0800_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:4,T:0,C:0 */
	src &= 31;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	regs.irc = get_word_ce030_prefetch (4);
	do_cycles_ce020_internal (2);
}}}	m68k_incpci (4);
return;
}

/* BTST.B #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_0810_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	do_cycles_ce020_internal (2);
}}}}	m68k_incpci (4);
return;
}

/* BTST.B #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_0818_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:1,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	do_cycles_ce020_internal (2);
}}}}	m68k_incpci (4);
return;
}

/* BTST.B #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_0820_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	do_cycles_ce020_internal (2);
}}}}	m68k_incpci (4);
return;
}

/* BTST.B #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_0828_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	do_cycles_ce020_internal (2);
}}}}	m68k_incpci (6);
return;
}

/* BTST.B #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0830_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	do_cycles_ce020_internal (2);
}}}}}return;
}

/* BTST.B #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_0838_23)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	do_cycles_ce020_internal (2);
}}}}	m68k_incpci (6);
return;
}

/* BTST.B #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_0839_23)(uae_u32 opcode)
{
{	/* ea H:3,T:0,C:3 fiea */
	if (regs.ce020memcycles > 3 * cpucycleunit)
		regs.ce020memcycles = 3 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	do_cycles_ce020_internal (2);
}}}}	m68k_incpci (8);
return;
}

/* BTST.B #<data>.W,(d16,PC) */
void REGPARAM2 CPUFUNC(op_083a_23)(uae_u32 opcode)
{
	uae_u32 dstreg = 2;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_getpci () + 4;
	dsta += (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	do_cycles_ce020_internal (2);
}}}}	m68k_incpci (6);
return;
}

/* BTST.B #<data>.W,(d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_083b_23)(uae_u32 opcode)
{
	uae_u32 dstreg = 3;
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr tmppc;
	uaecptr dsta;
	m68k_incpci (4);
{	tmppc = m68k_getpci ();
	dsta = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	do_cycles_ce020_internal (2);
}}}}}return;
}

/* BCHG.L #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_0840_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:6,T:0,C:0 */
	src &= 31;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	regs.irc = get_word_ce030_prefetch (4);
	do_cycles_ce020_internal (4);
	m68k_dreg (regs, dstreg) = (dst);
}}}	m68k_incpci (4);
return;
}

/* BCHG.B #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_0850_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
}

/* BCHG.B #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_0858_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:1,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
}

/* BCHG.B #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_0860_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
}

/* BCHG.B #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_0868_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (6);
return;
}

/* BCHG.B #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0870_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}}return;
}

/* BCHG.B #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_0878_23)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (6);
return;
}

/* BCHG.B #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_0879_23)(uae_u32 opcode)
{
{	/* ea H:3,T:0,C:3 fiea */
	if (regs.ce020memcycles > 3 * cpucycleunit)
		regs.ce020memcycles = 3 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (8);
return;
}

/* BCLR.L #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_0880_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:6,T:0,C:0 */
	src &= 31;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	regs.irc = get_word_ce030_prefetch (4);
	do_cycles_ce020_internal (4);
	m68k_dreg (regs, dstreg) = (dst);
}}}	m68k_incpci (4);
return;
}

/* BCLR.B #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_0890_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
}

/* BCLR.B #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_0898_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:1,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
}

/* BCLR.B #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_08a0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
}

/* BCLR.B #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_08a8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (6);
return;
}

/* BCLR.B #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_08b0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}}return;
}

/* BCLR.B #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_08b8_23)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (6);
return;
}

/* BCLR.B #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_08b9_23)(uae_u32 opcode)
{
{	/* ea H:3,T:0,C:3 fiea */
	if (regs.ce020memcycles > 3 * cpucycleunit)
		regs.ce020memcycles = 3 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (8);
return;
}

/* BSET.L #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_08c0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:6,T:0,C:0 */
	src &= 31;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	regs.irc = get_word_ce030_prefetch (4);
	do_cycles_ce020_internal (4);
	m68k_dreg (regs, dstreg) = (dst);
}}}	m68k_incpci (4);
return;
}

/* BSET.B #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_08d0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
}

/* BSET.B #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_08d8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:1,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
}

/* BSET.B #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_08e0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
}

/* BSET.B #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_08e8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (6);
return;
}

/* BSET.B #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_08f0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}}return;
}

/* BSET.B #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_08f8_23)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (6);
return;
}

/* BSET.B #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_08f9_23)(uae_u32 opcode)
{
{	/* ea H:3,T:0,C:3 fiea */
	if (regs.ce020memcycles > 3 * cpucycleunit)
		regs.ce020memcycles = 3 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (8);
return;
}

/* EOR.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_0a00_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2+2=4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	/* op H:2-,T:0,C:0 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.irc = get_word_ce030_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpci (4);
return;
}

/* EOR.B #<data>.B,(An) */
void REGPARAM2 CPUFUNC(op_0a10_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* EOR.B #<data>.B,(An)+ */
void REGPARAM2 CPUFUNC(op_0a18_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:1,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* EOR.B #<data>.B,-(An) */
void REGPARAM2 CPUFUNC(op_0a20_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* EOR.B #<data>.B,(d16,An) */
void REGPARAM2 CPUFUNC(op_0a28_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* EOR.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0a30_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}}return;
}

/* EOR.B #<data>.B,(xxx).W */
void REGPARAM2 CPUFUNC(op_0a38_23)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* EOR.B #<data>.B,(xxx).L */
void REGPARAM2 CPUFUNC(op_0a39_23)(uae_u32 opcode)
{
{	/* ea H:3,T:0,C:3 fiea */
	if (regs.ce020memcycles > 3 * cpucycleunit)
		regs.ce020memcycles = 3 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (8);
return;
}

/* EORSR.B #<data>.W */
void REGPARAM2 CPUFUNC(op_0a3c_23)(uae_u32 opcode)
{
{	MakeSR ();
{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
	src &= 0xFF;
	regs.sr ^= src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	regs.irc = get_word_ce030_prefetch (4);
}}	m68k_incpci (4);
return;
}

/* EOR.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_0a40_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2+2=4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* op H:2-,T:0,C:0 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.irc = get_word_ce030_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpci (4);
return;
}

/* EOR.W #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_0a50_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* EOR.W #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_0a58_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:1,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* EOR.W #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_0a60_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* EOR.W #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_0a68_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* EOR.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0a70_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}}return;
}

/* EOR.W #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_0a78_23)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* EOR.W #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_0a79_23)(uae_u32 opcode)
{
{	/* ea H:3,T:0,C:3 fiea */
	if (regs.ce020memcycles > 3 * cpucycleunit)
		regs.ce020memcycles = 3 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce030_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (8);
return;
}

/* EORSR.W #<data>.W */
void REGPARAM2 CPUFUNC(op_0a7c_23)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_230221; }
{	MakeSR ();
{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
	regs.sr ^= src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	regs.irc = get_word_ce030_prefetch (4);
}}}	m68k_incpci (4);
l_230221: ;
return;
}

/* EOR.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_0a80_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4+2=6,T:0,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:2-,T:0,C:0 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.irc = get_word_ce030_prefetch (6);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpci (6);
return;
}

/* EOR.L #<data>.L,(An) */
void REGPARAM2 CPUFUNC(op_0a90_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:0,C:3 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* EOR.L #<data>.L,(An)+ */
void REGPARAM2 CPUFUNC(op_0a98_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:1,C:2 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* EOR.L #<data>.L,-(An) */
void REGPARAM2 CPUFUNC(op_0aa0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* EOR.L #<data>.L,(d16,An) */
void REGPARAM2 CPUFUNC(op_0aa8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:0,C:2 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (6);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce030_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (8);
return;
}

/* EOR.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0ab0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:8,T:2,C:0 fiea */
	if (regs.ce020memcycles > 8 * cpucycleunit)
		regs.ce020memcycles = 8 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (6);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}}return;
}

/* EOR.L #<data>.L,(xxx).W */
void REGPARAM2 CPUFUNC(op_0ab8_23)(uae_u32 opcode)
{
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (6);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce030_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (8);
return;
}

/* EOR.L #<data>.L,(xxx).L */
void REGPARAM2 CPUFUNC(op_0ab9_23)(uae_u32 opcode)
{
{	/* ea H:5,T:0,C:3 fiea */
	if (regs.ce020memcycles > 5 * cpucycleunit)
		regs.ce020memcycles = 5 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (6);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce030_prefetch (10);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (10);
return;
}

/* CAS.B #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0ad0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s8)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(m68k_dreg (regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce030_prefetch (4);
	x_put_byte (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce030_prefetch (4);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
}}}}}}}}	m68k_incpci (4);
return;
}

#endif
/* CAS.B #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0ad8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s8)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(m68k_dreg (regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce030_prefetch (4);
	x_put_byte (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce030_prefetch (4);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
}}}}}}}}	m68k_incpci (4);
return;
}

#endif
/* CAS.B #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0ae0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s8)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(m68k_dreg (regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce030_prefetch (4);
	x_put_byte (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce030_prefetch (4);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
}}}}}}}}	m68k_incpci (4);
return;
}

#endif
/* CAS.B #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0ae8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s8)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(m68k_dreg (regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce030_prefetch (6);
	x_put_byte (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce030_prefetch (6);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
}}}}}}}}	m68k_incpci (6);
return;
}

#endif
#endif

#ifdef PART_2
/* CAS.B #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0af0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
{	uae_s8 dst = x_get_byte (dsta);
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s8)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(m68k_dreg (regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce030_prefetch (0);
	x_put_byte (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce030_prefetch (0);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
}}}}}}}}}return;
}

#endif
/* CAS.B #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0af8_23)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s8)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(m68k_dreg (regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce030_prefetch (6);
	x_put_byte (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce030_prefetch (6);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
}}}}}}}}	m68k_incpci (6);
return;
}

#endif
/* CAS.B #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0af9_23)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s8)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(m68k_dreg (regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce030_prefetch (8);
	x_put_byte (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce030_prefetch (8);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
}}}}}}}}	m68k_incpci (8);
return;
}

#endif
/* CMP.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_0c00_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2+2=4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	/* op H:2-,T:0,C:0 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce030_prefetch (4);
}}}}}}	m68k_incpci (4);
return;
}

/* CMP.B #<data>.B,(An) */
void REGPARAM2 CPUFUNC(op_0c10_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMP.B #<data>.B,(An)+ */
void REGPARAM2 CPUFUNC(op_0c18_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:1,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMP.B #<data>.B,-(An) */
void REGPARAM2 CPUFUNC(op_0c20_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMP.B #<data>.B,(d16,An) */
void REGPARAM2 CPUFUNC(op_0c28_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (6);
return;
}

/* CMP.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0c30_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}return;
}

/* CMP.B #<data>.B,(xxx).W */
void REGPARAM2 CPUFUNC(op_0c38_23)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (6);
return;
}

/* CMP.B #<data>.B,(xxx).L */
void REGPARAM2 CPUFUNC(op_0c39_23)(uae_u32 opcode)
{
{	/* ea H:3,T:0,C:3 fiea */
	if (regs.ce020memcycles > 3 * cpucycleunit)
		regs.ce020memcycles = 3 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (8);
return;
}

/* CMP.B #<data>.B,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0c3a_23)(uae_u32 opcode)
{
	uae_u32 dstreg = 2;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_getpci () + 4;
	dsta += (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (6);
return;
}

#endif
/* CMP.B #<data>.B,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0c3b_23)(uae_u32 opcode)
{
	uae_u32 dstreg = 3;
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr tmppc;
	uaecptr dsta;
	m68k_incpci (4);
{	tmppc = m68k_getpci ();
	dsta = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}return;
}

#endif
/* CMP.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_0c40_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2+2=4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* op H:2-,T:0,C:0 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce030_prefetch (4);
}}}}}}	m68k_incpci (4);
return;
}

/* CMP.W #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_0c50_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMP.W #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_0c58_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:1,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMP.W #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_0c60_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMP.W #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_0c68_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (6);
return;
}

/* CMP.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0c70_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}return;
}

/* CMP.W #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_0c78_23)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (6);
return;
}

/* CMP.W #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_0c79_23)(uae_u32 opcode)
{
{	/* ea H:3,T:0,C:3 fiea */
	if (regs.ce020memcycles > 3 * cpucycleunit)
		regs.ce020memcycles = 3 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce030_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (8);
return;
}

/* CMP.W #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0c7a_23)(uae_u32 opcode)
{
	uae_u32 dstreg = 2;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_getpci () + 4;
	dsta += (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (6);
return;
}

#endif
/* CMP.W #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0c7b_23)(uae_u32 opcode)
{
	uae_u32 dstreg = 3;
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr tmppc;
	uaecptr dsta;
	m68k_incpci (4);
{	tmppc = m68k_getpci ();
	dsta = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}return;
}

#endif
/* CMP.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_0c80_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4+2=6,T:0,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:2-,T:0,C:0 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce030_prefetch (6);
}}}}}}	m68k_incpci (6);
return;
}

/* CMP.L #<data>.L,(An) */
void REGPARAM2 CPUFUNC(op_0c90_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:0,C:3 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (6);
return;
}

/* CMP.L #<data>.L,(An)+ */
void REGPARAM2 CPUFUNC(op_0c98_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:1,C:2 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (6);
return;
}

/* CMP.L #<data>.L,-(An) */
void REGPARAM2 CPUFUNC(op_0ca0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (6);
return;
}

/* CMP.L #<data>.L,(d16,An) */
void REGPARAM2 CPUFUNC(op_0ca8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:0,C:2 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (6);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce030_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (8);
return;
}

/* CMP.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0cb0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:8,T:2,C:0 fiea */
	if (regs.ce020memcycles > 8 * cpucycleunit)
		regs.ce020memcycles = 8 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (6);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}return;
}

/* CMP.L #<data>.L,(xxx).W */
void REGPARAM2 CPUFUNC(op_0cb8_23)(uae_u32 opcode)
{
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (6);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce030_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (8);
return;
}

/* CMP.L #<data>.L,(xxx).L */
void REGPARAM2 CPUFUNC(op_0cb9_23)(uae_u32 opcode)
{
{	/* ea H:5,T:0,C:3 fiea */
	if (regs.ce020memcycles > 5 * cpucycleunit)
		regs.ce020memcycles = 5 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (6);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce030_prefetch (10);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (10);
return;
}

/* CMP.L #<data>.L,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0cba_23)(uae_u32 opcode)
{
	uae_u32 dstreg = 2;
{	/* ea H:4,T:0,C:2 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_getpci () + 6;
	dsta += (uae_s32)(uae_s16)get_word_ce030_prefetch (6);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce030_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (8);
return;
}

#endif
/* CMP.L #<data>.L,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0cbb_23)(uae_u32 opcode)
{
	uae_u32 dstreg = 3;
{	/* ea H:8,T:2,C:0 fiea */
	if (regs.ce020memcycles > 8 * cpucycleunit)
		regs.ce020memcycles = 8 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr tmppc;
	uaecptr dsta;
	m68k_incpci (6);
{	tmppc = m68k_getpci ();
	dsta = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}return;
}

#endif
/* CAS.W #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0cd0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = x_get_word (dsta);
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s16)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(m68k_dreg (regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce030_prefetch (4);
	x_put_word (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce030_prefetch (4);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
}}}}}}}}	m68k_incpci (4);
return;
}

#endif
/* CAS.W #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0cd8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s16)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(m68k_dreg (regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce030_prefetch (4);
	x_put_word (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce030_prefetch (4);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
}}}}}}}}	m68k_incpci (4);
return;
}

#endif
/* CAS.W #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0ce0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s16)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(m68k_dreg (regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce030_prefetch (4);
	x_put_word (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce030_prefetch (4);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
}}}}}}}}	m68k_incpci (4);
return;
}

#endif
/* CAS.W #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0ce8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s16)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(m68k_dreg (regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce030_prefetch (6);
	x_put_word (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce030_prefetch (6);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
}}}}}}}}	m68k_incpci (6);
return;
}

#endif
/* CAS.W #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0cf0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
{	uae_s16 dst = x_get_word (dsta);
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s16)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(m68k_dreg (regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce030_prefetch (0);
	x_put_word (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce030_prefetch (0);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
}}}}}}}}}return;
}

#endif
/* CAS.W #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0cf8_23)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s16)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(m68k_dreg (regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce030_prefetch (6);
	x_put_word (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce030_prefetch (6);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
}}}}}}}}	m68k_incpci (6);
return;
}

#endif
/* CAS.W #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0cf9_23)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s16)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(m68k_dreg (regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce030_prefetch (8);
	x_put_word (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce030_prefetch (8);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
}}}}}}}}	m68k_incpci (8);
return;
}

#endif
/* CAS2.W #<data>.L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0cfc_23)(uae_u32 opcode)
{
{{	uae_s32 extra;
	extra = get_long_ce030_prefetch (2);
	/* OP zero */
	uae_u32 rn1 = regs.regs[(extra >> 28) & 15];
	uae_u32 rn2 = regs.regs[(extra >> 12) & 15];
	uae_u16 dst1 = x_get_word (rn1), dst2 = x_get_word (rn2);
{uae_u32 newv = ((uae_u16)(dst1)) - ((uae_u16)(m68k_dreg (regs, (extra >> 16) & 7)));
{	int flgs = ((uae_s16)(m68k_dreg (regs, (extra >> 16) & 7))) < 0;
	int flgo = ((uae_s16)(dst1)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(m68k_dreg (regs, (extra >> 16) & 7))) > ((uae_u16)(dst1)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
{uae_u32 newv = ((uae_u16)(dst2)) - ((uae_u16)(m68k_dreg (regs, extra & 7)));
{	int flgs = ((uae_s16)(m68k_dreg (regs, extra & 7))) < 0;
	int flgo = ((uae_s16)(dst2)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(m68k_dreg (regs, extra & 7))) > ((uae_u16)(dst2)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
	x_put_word (rn1, m68k_dreg (regs, (extra >> 22) & 7));
	x_put_word (rn2, m68k_dreg (regs, (extra >> 6) & 7));
	}}
}}}}	if (! GET_ZFLG ()) {
	m68k_dreg (regs, (extra >> 0) & 7) = (m68k_dreg (regs, (extra >> 6) & 7) & ~0xffff) | (dst2 & 0xffff);
	m68k_dreg (regs, (extra >> 16) & 7) = (m68k_dreg (regs, (extra >> 22) & 7) & ~0xffff) | (dst1 & 0xffff);
	}
	regs.irc = get_word_ce030_prefetch (6);
}}	m68k_incpci (6);
return;
}

#endif
/* MOVES.B #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0e10_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs.s) { Exception (8); goto l_230275; }
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	/* OP zero */
	x_put_byte (dsta, src);
}}else{{	uaecptr srca;
	srca = m68k_areg (regs, dstreg);
{	uae_s8 src = x_get_byte (srca);
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
	}
}}}	regs.irc = get_word_ce030_prefetch (4);
}}}	m68k_incpci (4);
l_230275: ;
return;
}

#endif
/* MOVES.B #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0e18_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs.s) { Exception (8); goto l_230276; }
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	/* OP zero */
	x_put_byte (dsta, src);
}}else{{	uaecptr srca;
	srca = m68k_areg (regs, dstreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
	}
}}}	regs.irc = get_word_ce030_prefetch (4);
}}}	m68k_incpci (4);
l_230276: ;
return;
}

#endif
/* MOVES.B #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0e20_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs.s) { Exception (8); goto l_230277; }
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	/* OP zero */
	x_put_byte (dsta, src);
}}else{{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, dstreg) = srca;
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
	}
}}}	regs.irc = get_word_ce030_prefetch (4);
}}}	m68k_incpci (4);
l_230277: ;
return;
}

#endif
/* MOVES.B #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0e28_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs.s) { Exception (8); goto l_230278; }
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	/* OP zero */
	x_put_byte (dsta, src);
}}else{{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
	}
}}}	regs.irc = get_word_ce030_prefetch (6);
}}}	m68k_incpci (6);
l_230278: ;
return;
}

#endif
/* MOVES.B #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0e30_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs.s) { Exception (8); goto l_230279; }
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	/* OP zero */
	x_put_byte (dsta, src);
}}}else{{	uaecptr srca;
	m68k_incpci (4);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 1);
{	uae_s8 src = x_get_byte (srca);
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
	}
}}}}	regs.irc = get_word_ce030_prefetch (0);
}}}l_230279: ;
return;
}

#endif
/* MOVES.B #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0e38_23)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_230280; }
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	/* OP zero */
	x_put_byte (dsta, src);
}}else{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
	}
}}}	regs.irc = get_word_ce030_prefetch (6);
}}}	m68k_incpci (6);
l_230280: ;
return;
}

#endif
/* MOVES.B #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0e39_23)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_230281; }
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (4);
	/* OP zero */
	x_put_byte (dsta, src);
}}else{{	uaecptr srca;
	srca = get_long_ce030_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
	}
}}}	regs.irc = get_word_ce030_prefetch (8);
}}}	m68k_incpci (8);
l_230281: ;
return;
}

#endif
/* MOVES.W #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0e50_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs.s) { Exception (8); goto l_230282; }
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	/* OP zero */
	x_put_word (dsta, src);
}}else{{	uaecptr srca;
	srca = m68k_areg (regs, dstreg);
{	uae_s16 src = x_get_word (srca);
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
	}
}}}	regs.irc = get_word_ce030_prefetch (4);
}}}	m68k_incpci (4);
l_230282: ;
return;
}

#endif
/* MOVES.W #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0e58_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs.s) { Exception (8); goto l_230283; }
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 2;
	/* OP zero */
	x_put_word (dsta, src);
}}else{{	uaecptr srca;
	srca = m68k_areg (regs, dstreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, dstreg) += 2;
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
	}
}}}	regs.irc = get_word_ce030_prefetch (4);
}}}	m68k_incpci (4);
l_230283: ;
return;
}

#endif
/* MOVES.W #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0e60_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs.s) { Exception (8); goto l_230284; }
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	/* OP zero */
	x_put_word (dsta, src);
}}else{{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, dstreg) = srca;
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
	}
}}}	regs.irc = get_word_ce030_prefetch (4);
}}}	m68k_incpci (4);
l_230284: ;
return;
}

#endif
/* MOVES.W #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0e68_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs.s) { Exception (8); goto l_230285; }
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	/* OP zero */
	x_put_word (dsta, src);
}}else{{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s16 src = x_get_word (srca);
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
	}
}}}	regs.irc = get_word_ce030_prefetch (6);
}}}	m68k_incpci (6);
l_230285: ;
return;
}

#endif
/* MOVES.W #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0e70_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs.s) { Exception (8); goto l_230286; }
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	/* OP zero */
	x_put_word (dsta, src);
}}}else{{	uaecptr srca;
	m68k_incpci (4);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 1);
{	uae_s16 src = x_get_word (srca);
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
	}
}}}}	regs.irc = get_word_ce030_prefetch (0);
}}}l_230286: ;
return;
}

#endif
/* MOVES.W #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0e78_23)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_230287; }
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	/* OP zero */
	x_put_word (dsta, src);
}}else{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s16 src = x_get_word (srca);
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
	}
}}}	regs.irc = get_word_ce030_prefetch (6);
}}}	m68k_incpci (6);
l_230287: ;
return;
}

#endif
/* MOVES.W #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0e79_23)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_230288; }
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (4);
	/* OP zero */
	x_put_word (dsta, src);
}}else{{	uaecptr srca;
	srca = get_long_ce030_prefetch (4);
{	uae_s16 src = x_get_word (srca);
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
	}
}}}	regs.irc = get_word_ce030_prefetch (8);
}}}	m68k_incpci (8);
l_230288: ;
return;
}

#endif
/* MOVES.L #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0e90_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs.s) { Exception (8); goto l_230289; }
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	/* OP zero */
	x_put_long (dsta, src);
}}else{{	uaecptr srca;
	srca = m68k_areg (regs, dstreg);
{	uae_s32 src = x_get_long (srca);
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (src);
	}
}}}	regs.irc = get_word_ce030_prefetch (4);
}}}	m68k_incpci (4);
l_230289: ;
return;
}

#endif
/* MOVES.L #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0e98_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs.s) { Exception (8); goto l_230290; }
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 4;
	/* OP zero */
	x_put_long (dsta, src);
}}else{{	uaecptr srca;
	srca = m68k_areg (regs, dstreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, dstreg) += 4;
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (src);
	}
}}}	regs.irc = get_word_ce030_prefetch (4);
}}}	m68k_incpci (4);
l_230290: ;
return;
}

#endif
/* MOVES.L #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0ea0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs.s) { Exception (8); goto l_230291; }
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	/* OP zero */
	x_put_long (dsta, src);
}}else{{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, dstreg) = srca;
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (src);
	}
}}}	regs.irc = get_word_ce030_prefetch (4);
}}}	m68k_incpci (4);
l_230291: ;
return;
}

#endif
/* MOVES.L #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0ea8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs.s) { Exception (8); goto l_230292; }
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	/* OP zero */
	x_put_long (dsta, src);
}}else{{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s32 src = x_get_long (srca);
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (src);
	}
}}}	regs.irc = get_word_ce030_prefetch (6);
}}}	m68k_incpci (6);
l_230292: ;
return;
}

#endif
/* MOVES.L #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0eb0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs.s) { Exception (8); goto l_230293; }
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	/* OP zero */
	x_put_long (dsta, src);
}}}else{{	uaecptr srca;
	m68k_incpci (4);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 1);
{	uae_s32 src = x_get_long (srca);
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (src);
	}
}}}}	regs.irc = get_word_ce030_prefetch (0);
}}}l_230293: ;
return;
}

#endif
/* MOVES.L #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0eb8_23)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_230294; }
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	/* OP zero */
	x_put_long (dsta, src);
}}else{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s32 src = x_get_long (srca);
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (src);
	}
}}}	regs.irc = get_word_ce030_prefetch (6);
}}}	m68k_incpci (6);
l_230294: ;
return;
}

#endif
/* MOVES.L #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0eb9_23)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_230295; }
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (4);
	/* OP zero */
	x_put_long (dsta, src);
}}else{{	uaecptr srca;
	srca = get_long_ce030_prefetch (4);
{	uae_s32 src = x_get_long (srca);
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (src);
	}
}}}	regs.irc = get_word_ce030_prefetch (8);
}}}	m68k_incpci (8);
l_230295: ;
return;
}

#endif
/* CAS.L #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0ed0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = x_get_long (dsta);
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s32)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(m68k_dreg (regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce030_prefetch (4);
	x_put_long (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce030_prefetch (4);
		m68k_dreg(regs, rc) = dst;
}}}}}}}}	m68k_incpci (4);
return;
}

#endif
/* CAS.L #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0ed8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s32)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(m68k_dreg (regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce030_prefetch (4);
	x_put_long (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce030_prefetch (4);
		m68k_dreg(regs, rc) = dst;
}}}}}}}}	m68k_incpci (4);
return;
}

#endif
/* CAS.L #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0ee0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s32)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(m68k_dreg (regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce030_prefetch (4);
	x_put_long (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce030_prefetch (4);
		m68k_dreg(regs, rc) = dst;
}}}}}}}}	m68k_incpci (4);
return;
}

#endif
/* CAS.L #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0ee8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s32 dst = x_get_long (dsta);
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s32)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(m68k_dreg (regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce030_prefetch (6);
	x_put_long (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce030_prefetch (6);
		m68k_dreg(regs, rc) = dst;
}}}}}}}}	m68k_incpci (6);
return;
}

#endif
/* CAS.L #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0ef0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
{	uae_s32 dst = x_get_long (dsta);
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s32)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(m68k_dreg (regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce030_prefetch (0);
	x_put_long (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce030_prefetch (0);
		m68k_dreg(regs, rc) = dst;
}}}}}}}}}return;
}

#endif
/* CAS.L #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0ef8_23)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s32 dst = x_get_long (dsta);
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s32)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(m68k_dreg (regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce030_prefetch (6);
	x_put_long (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce030_prefetch (6);
		m68k_dreg(regs, rc) = dst;
}}}}}}}}	m68k_incpci (6);
return;
}

#endif
/* CAS.L #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0ef9_23)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (4);
{	uae_s32 dst = x_get_long (dsta);
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s32)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(m68k_dreg (regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce030_prefetch (8);
	x_put_long (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce030_prefetch (8);
		m68k_dreg(regs, rc) = dst;
}}}}}}}}	m68k_incpci (8);
return;
}

#endif
/* CAS2.L #<data>.L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0efc_23)(uae_u32 opcode)
{
{{	uae_s32 extra;
	extra = get_long_ce030_prefetch (2);
	/* OP zero */
	uae_u32 rn1 = regs.regs[(extra >> 28) & 15];
	uae_u32 rn2 = regs.regs[(extra >> 12) & 15];
	uae_u32 dst1 = x_get_long (rn1), dst2 = x_get_long (rn2);
{uae_u32 newv = ((uae_u32)(dst1)) - ((uae_u32)(m68k_dreg (regs, (extra >> 16) & 7)));
{	int flgs = ((uae_s32)(m68k_dreg (regs, (extra >> 16) & 7))) < 0;
	int flgo = ((uae_s32)(dst1)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(m68k_dreg (regs, (extra >> 16) & 7))) > ((uae_u32)(dst1)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
{uae_u32 newv = ((uae_u32)(dst2)) - ((uae_u32)(m68k_dreg (regs, extra & 7)));
{	int flgs = ((uae_s32)(m68k_dreg (regs, extra & 7))) < 0;
	int flgo = ((uae_s32)(dst2)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(m68k_dreg (regs, extra & 7))) > ((uae_u32)(dst2)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
	x_put_long (rn1, m68k_dreg (regs, (extra >> 22) & 7));
	x_put_long (rn2, m68k_dreg (regs, (extra >> 6) & 7));
	}}
}}}}	if (! GET_ZFLG ()) {
	m68k_dreg (regs, (extra >> 0) & 7) = dst2;
	m68k_dreg (regs, (extra >> 16) & 7) = dst1;
	}
	regs.irc = get_word_ce030_prefetch (6);
}}	m68k_incpci (6);
return;
}

#endif
/* MOVE.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_1000_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	/* op H:2,T:0,C:0 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci (2);
}}}return;
}

/* MOVE.B (An),Dn */
void REGPARAM2 CPUFUNC(op_1010_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
{	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.B (An)+,Dn */
void REGPARAM2 CPUFUNC(op_1018_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.B -(An),Dn */
void REGPARAM2 CPUFUNC(op_1020_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.B (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_1028_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.B (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_1030_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s8 src = x_get_byte (srca);
{	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}}return;
}

/* MOVE.B (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_1038_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.B (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_1039_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.B (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_103a_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.B (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_103b_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s8 src = x_get_byte (srca);
{	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}}return;
}

/* MOVE.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_103c_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:0,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci (4);
}}}return;
}

/* MOVE.B Dn,(An) */
void REGPARAM2 CPUFUNC(op_1080_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
	m68k_incpci (2);
}}}return;
}

/* MOVE.B (An),(An) */
void REGPARAM2 CPUFUNC(op_1090_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.B (An)+,(An) */
void REGPARAM2 CPUFUNC(op_1098_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.B -(An),(An) */
void REGPARAM2 CPUFUNC(op_10a0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.B (d16,An),(An) */
void REGPARAM2 CPUFUNC(op_10a8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.B (d8,An,Xn),(An) */
void REGPARAM2 CPUFUNC(op_10b0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
}}}}}return;
}

/* MOVE.B (xxx).W,(An) */
void REGPARAM2 CPUFUNC(op_10b8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.B (xxx).L,(An) */
void REGPARAM2 CPUFUNC(op_10b9_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.B (d16,PC),(An) */
void REGPARAM2 CPUFUNC(op_10ba_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.B (d8,PC,Xn),(An) */
void REGPARAM2 CPUFUNC(op_10bb_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
}}}}}return;
}

/* MOVE.B #<data>.B,(An) */
void REGPARAM2 CPUFUNC(op_10bc_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:0,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}return;
}

/* MOVE.B Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_10c0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
	m68k_incpci (2);
}}}return;
}

/* MOVE.B (An),(An)+ */
void REGPARAM2 CPUFUNC(op_10d0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.B (An)+,(An)+ */
void REGPARAM2 CPUFUNC(op_10d8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.B -(An),(An)+ */
void REGPARAM2 CPUFUNC(op_10e0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.B (d16,An),(An)+ */
void REGPARAM2 CPUFUNC(op_10e8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.B (d8,An,Xn),(An)+ */
void REGPARAM2 CPUFUNC(op_10f0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
}}}}}return;
}

/* MOVE.B (xxx).W,(An)+ */
void REGPARAM2 CPUFUNC(op_10f8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.B (xxx).L,(An)+ */
void REGPARAM2 CPUFUNC(op_10f9_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.B (d16,PC),(An)+ */
void REGPARAM2 CPUFUNC(op_10fa_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.B (d8,PC,Xn),(An)+ */
void REGPARAM2 CPUFUNC(op_10fb_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
}}}}}return;
}

/* MOVE.B #<data>.B,(An)+ */
void REGPARAM2 CPUFUNC(op_10fc_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:0,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}return;
}

/* MOVE.B Dn,-(An) */
void REGPARAM2 CPUFUNC(op_1100_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	/* op H:0,T:2,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (2);
}}}return;
}

/* MOVE.B (An),-(An) */
void REGPARAM2 CPUFUNC(op_1110_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.B (An)+,-(An) */
void REGPARAM2 CPUFUNC(op_1118_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.B -(An),-(An) */
void REGPARAM2 CPUFUNC(op_1120_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.B (d16,An),-(An) */
void REGPARAM2 CPUFUNC(op_1128_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.B (d8,An,Xn),-(An) */
void REGPARAM2 CPUFUNC(op_1130_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
}}}}}return;
}

/* MOVE.B (xxx).W,-(An) */
void REGPARAM2 CPUFUNC(op_1138_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.B (xxx).L,-(An) */
void REGPARAM2 CPUFUNC(op_1139_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.B (d16,PC),-(An) */
void REGPARAM2 CPUFUNC(op_113a_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.B (d8,PC,Xn),-(An) */
void REGPARAM2 CPUFUNC(op_113b_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
}}}}}return;
}

/* MOVE.B #<data>.B,-(An) */
void REGPARAM2 CPUFUNC(op_113c_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:0,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}return;
}

/* MOVE.B Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_1140_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}return;
}

/* MOVE.B (An),(d16,An) */
void REGPARAM2 CPUFUNC(op_1150_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.B (An)+,(d16,An) */
void REGPARAM2 CPUFUNC(op_1158_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.B -(An),(d16,An) */
void REGPARAM2 CPUFUNC(op_1160_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.B (d16,An),(d16,An) */
void REGPARAM2 CPUFUNC(op_1168_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	regs.irc = get_word_ce030_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.B (d8,An,Xn),(d16,An) */
void REGPARAM2 CPUFUNC(op_1170_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (0);
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (2);
}}}}}return;
}

/* MOVE.B (xxx).W,(d16,An) */
void REGPARAM2 CPUFUNC(op_1178_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	regs.irc = get_word_ce030_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.B (xxx).L,(d16,An) */
void REGPARAM2 CPUFUNC(op_1179_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (6);
	regs.irc = get_word_ce030_prefetch (8);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (8);
}}}}return;
}

/* MOVE.B (d16,PC),(d16,An) */
void REGPARAM2 CPUFUNC(op_117a_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	regs.irc = get_word_ce030_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.B (d8,PC,Xn),(d16,An) */
void REGPARAM2 CPUFUNC(op_117b_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (0);
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (2);
}}}}}return;
}

/* MOVE.B #<data>.B,(d16,An) */
void REGPARAM2 CPUFUNC(op_117c_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:0,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	regs.irc = get_word_ce030_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (6);
}}}return;
}

/* MOVE.B Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_1180_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
}}}}return;
}

/* MOVE.B (An),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_1190_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
}}}}}return;
}

/* MOVE.B (An)+,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_1198_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
}}}}}return;
}

/* MOVE.B -(An),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_11a0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
}}}}}return;
}

/* MOVE.B (d16,An),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_11a8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
}}}}}return;
}

/* MOVE.B (d8,An,Xn),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_11b0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 1);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
}}}}}}return;
}

/* MOVE.B (xxx).W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_11b8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
}}}}}return;
}

/* MOVE.B (xxx).L,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_11b9_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	m68k_incpci (6);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
}}}}}return;
}

/* MOVE.B (d16,PC),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_11ba_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
}}}}}return;
}

/* MOVE.B (d8,PC,Xn),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_11bb_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 1);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
}}}}}}return;
}

/* MOVE.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_11bc_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:0,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
}}}}return;
}

/* MOVE.B Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_11c0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}return;
}

/* MOVE.B (An),(xxx).W */
void REGPARAM2 CPUFUNC(op_11d0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.B (An)+,(xxx).W */
void REGPARAM2 CPUFUNC(op_11d8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.B -(An),(xxx).W */
void REGPARAM2 CPUFUNC(op_11e0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.B (d16,An),(xxx).W */
void REGPARAM2 CPUFUNC(op_11e8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	regs.irc = get_word_ce030_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.B (d8,An,Xn),(xxx).W */
void REGPARAM2 CPUFUNC(op_11f0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (0);
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (2);
}}}}}return;
}

/* MOVE.B (xxx).W,(xxx).W */
void REGPARAM2 CPUFUNC(op_11f8_23)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	regs.irc = get_word_ce030_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.B (xxx).L,(xxx).W */
void REGPARAM2 CPUFUNC(op_11f9_23)(uae_u32 opcode)
{
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (6);
	regs.irc = get_word_ce030_prefetch (8);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (8);
}}}}return;
}

/* MOVE.B (d16,PC),(xxx).W */
void REGPARAM2 CPUFUNC(op_11fa_23)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	regs.irc = get_word_ce030_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.B (d8,PC,Xn),(xxx).W */
void REGPARAM2 CPUFUNC(op_11fb_23)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (0);
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (2);
}}}}}return;
}

/* MOVE.B #<data>.B,(xxx).W */
void REGPARAM2 CPUFUNC(op_11fc_23)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	regs.irc = get_word_ce030_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (6);
}}}return;
}

/* MOVE.B Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_13c0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
	m68k_incpci (6);
}}}return;
}

/* MOVE.B (An),(xxx).L */
void REGPARAM2 CPUFUNC(op_13d0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.B (An)+,(xxx).L */
void REGPARAM2 CPUFUNC(op_13d8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.B -(An),(xxx).L */
void REGPARAM2 CPUFUNC(op_13e0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.B (d16,An),(xxx).L */
void REGPARAM2 CPUFUNC(op_13e8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (4);
	regs.irc = get_word_ce030_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
	m68k_incpci (8);
}}}}return;
}

/* MOVE.B (d8,An,Xn),(xxx).L */
void REGPARAM2 CPUFUNC(op_13f0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (0);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}}}return;
}

/* MOVE.B (xxx).W,(xxx).L */
void REGPARAM2 CPUFUNC(op_13f8_23)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (4);
	regs.irc = get_word_ce030_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
	m68k_incpci (8);
}}}}return;
}

/* MOVE.B (xxx).L,(xxx).L */
void REGPARAM2 CPUFUNC(op_13f9_23)(uae_u32 opcode)
{
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (6);
	regs.irc = get_word_ce030_prefetch (10);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
	m68k_incpci (10);
}}}}return;
}

/* MOVE.B (d16,PC),(xxx).L */
void REGPARAM2 CPUFUNC(op_13fa_23)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (4);
	regs.irc = get_word_ce030_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
	m68k_incpci (8);
}}}}return;
}

/* MOVE.B (d8,PC,Xn),(xxx).L */
void REGPARAM2 CPUFUNC(op_13fb_23)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (0);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}}}return;
}

/* MOVE.B #<data>.B,(xxx).L */
void REGPARAM2 CPUFUNC(op_13fc_23)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (4);
	regs.irc = get_word_ce030_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
	m68k_incpci (8);
}}}return;
}

/* MOVE.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_2000_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	/* op H:2,T:0,C:0 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (2);
}}}return;
}

/* MOVE.L An,Dn */
void REGPARAM2 CPUFUNC(op_2008_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	/* op H:2,T:0,C:0 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (2);
}}}return;
}

/* MOVE.L (An),Dn */
void REGPARAM2 CPUFUNC(op_2010_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
{	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.L (An)+,Dn */
void REGPARAM2 CPUFUNC(op_2018_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.L -(An),Dn */
void REGPARAM2 CPUFUNC(op_2020_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.L (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_2028_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.L (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_2030_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s32 src = x_get_long (srca);
{	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
}}}}}return;
}

/* MOVE.L (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_2038_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.L (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_2039_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.L (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_203a_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.L (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_203b_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s32 src = x_get_long (srca);
{	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
}}}}}return;
}

/* MOVE.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_203c_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (6);
}}}return;
}

/* MOVEA.L Dn,An */
void REGPARAM2 CPUFUNC(op_2040_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	/* op H:2,T:0,C:0 */
	regs.irc = get_word_ce030_prefetch (2);
	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (2);
}}}return;
}

/* MOVEA.L An,An */
void REGPARAM2 CPUFUNC(op_2048_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	/* op H:2,T:0,C:0 */
	regs.irc = get_word_ce030_prefetch (2);
	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (2);
}}}return;
}

/* MOVEA.L (An),An */
void REGPARAM2 CPUFUNC(op_2050_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
{	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (2);
}}}}return;
}

/* MOVEA.L (An)+,An */
void REGPARAM2 CPUFUNC(op_2058_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (2);
}}}}return;
}

/* MOVEA.L -(An),An */
void REGPARAM2 CPUFUNC(op_2060_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (2);
}}}}return;
}

/* MOVEA.L (d16,An),An */
void REGPARAM2 CPUFUNC(op_2068_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (4);
}}}}return;
}

/* MOVEA.L (d8,An,Xn),An */
void REGPARAM2 CPUFUNC(op_2070_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s32 src = x_get_long (srca);
{	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	m68k_areg (regs, dstreg) = (src);
}}}}}return;
}

/* MOVEA.L (xxx).W,An */
void REGPARAM2 CPUFUNC(op_2078_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (4);
}}}}return;
}

/* MOVEA.L (xxx).L,An */
void REGPARAM2 CPUFUNC(op_2079_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (6);
}}}}return;
}

/* MOVEA.L (d16,PC),An */
void REGPARAM2 CPUFUNC(op_207a_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (4);
}}}}return;
}

/* MOVEA.L (d8,PC,Xn),An */
void REGPARAM2 CPUFUNC(op_207b_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s32 src = x_get_long (srca);
{	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	m68k_areg (regs, dstreg) = (src);
}}}}}return;
}

/* MOVEA.L #<data>.L,An */
void REGPARAM2 CPUFUNC(op_207c_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (6);
}}}return;
}

/* MOVE.L Dn,(An) */
void REGPARAM2 CPUFUNC(op_2080_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
	m68k_incpci (2);
}}}return;
}

/* MOVE.L An,(An) */
void REGPARAM2 CPUFUNC(op_2088_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
	m68k_incpci (2);
}}}return;
}

/* MOVE.L (An),(An) */
void REGPARAM2 CPUFUNC(op_2090_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.L (An)+,(An) */
void REGPARAM2 CPUFUNC(op_2098_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.L -(An),(An) */
void REGPARAM2 CPUFUNC(op_20a0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.L (d16,An),(An) */
void REGPARAM2 CPUFUNC(op_20a8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.L (d8,An,Xn),(An) */
void REGPARAM2 CPUFUNC(op_20b0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
}}}}}return;
}

/* MOVE.L (xxx).W,(An) */
void REGPARAM2 CPUFUNC(op_20b8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.L (xxx).L,(An) */
void REGPARAM2 CPUFUNC(op_20b9_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.L (d16,PC),(An) */
void REGPARAM2 CPUFUNC(op_20ba_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.L (d8,PC,Xn),(An) */
void REGPARAM2 CPUFUNC(op_20bb_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
}}}}}return;
}

/* MOVE.L #<data>.L,(An) */
void REGPARAM2 CPUFUNC(op_20bc_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (6);
}}}return;
}

/* MOVE.L Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_20c0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 4;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
	m68k_incpci (2);
}}}return;
}

/* MOVE.L An,(An)+ */
void REGPARAM2 CPUFUNC(op_20c8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 4;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
	m68k_incpci (2);
}}}return;
}

/* MOVE.L (An),(An)+ */
void REGPARAM2 CPUFUNC(op_20d0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 4;
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.L (An)+,(An)+ */
void REGPARAM2 CPUFUNC(op_20d8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 4;
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.L -(An),(An)+ */
void REGPARAM2 CPUFUNC(op_20e0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 4;
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.L (d16,An),(An)+ */
void REGPARAM2 CPUFUNC(op_20e8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 4;
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.L (d8,An,Xn),(An)+ */
void REGPARAM2 CPUFUNC(op_20f0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 4;
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
}}}}}return;
}

/* MOVE.L (xxx).W,(An)+ */
void REGPARAM2 CPUFUNC(op_20f8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 4;
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.L (xxx).L,(An)+ */
void REGPARAM2 CPUFUNC(op_20f9_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 4;
	regs.irc = get_word_ce030_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.L (d16,PC),(An)+ */
void REGPARAM2 CPUFUNC(op_20fa_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 4;
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.L (d8,PC,Xn),(An)+ */
void REGPARAM2 CPUFUNC(op_20fb_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 4;
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
}}}}}return;
}

/* MOVE.L #<data>.L,(An)+ */
void REGPARAM2 CPUFUNC(op_20fc_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 4;
	regs.irc = get_word_ce030_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (6);
}}}return;
}

/* MOVE.L Dn,-(An) */
void REGPARAM2 CPUFUNC(op_2100_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	/* op H:0,T:2,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (2);
}}}return;
}

/* MOVE.L An,-(An) */
void REGPARAM2 CPUFUNC(op_2108_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	/* op H:0,T:2,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (2);
}}}return;
}

/* MOVE.L (An),-(An) */
void REGPARAM2 CPUFUNC(op_2110_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.L (An)+,-(An) */
void REGPARAM2 CPUFUNC(op_2118_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.L -(An),-(An) */
void REGPARAM2 CPUFUNC(op_2120_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.L (d16,An),-(An) */
void REGPARAM2 CPUFUNC(op_2128_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.L (d8,An,Xn),-(An) */
void REGPARAM2 CPUFUNC(op_2130_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
}}}}}return;
}

/* MOVE.L (xxx).W,-(An) */
void REGPARAM2 CPUFUNC(op_2138_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.L (xxx).L,-(An) */
void REGPARAM2 CPUFUNC(op_2139_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.L (d16,PC),-(An) */
void REGPARAM2 CPUFUNC(op_213a_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.L (d8,PC,Xn),-(An) */
void REGPARAM2 CPUFUNC(op_213b_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
}}}}}return;
}

/* MOVE.L #<data>.L,-(An) */
void REGPARAM2 CPUFUNC(op_213c_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (6);
}}}return;
}

/* MOVE.L Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_2140_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}return;
}

/* MOVE.L An,(d16,An) */
void REGPARAM2 CPUFUNC(op_2148_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}return;
}

/* MOVE.L (An),(d16,An) */
void REGPARAM2 CPUFUNC(op_2150_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.L (An)+,(d16,An) */
void REGPARAM2 CPUFUNC(op_2158_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.L -(An),(d16,An) */
void REGPARAM2 CPUFUNC(op_2160_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.L (d16,An),(d16,An) */
void REGPARAM2 CPUFUNC(op_2168_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	regs.irc = get_word_ce030_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.L (d8,An,Xn),(d16,An) */
void REGPARAM2 CPUFUNC(op_2170_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (0);
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (2);
}}}}}return;
}

/* MOVE.L (xxx).W,(d16,An) */
void REGPARAM2 CPUFUNC(op_2178_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	regs.irc = get_word_ce030_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.L (xxx).L,(d16,An) */
void REGPARAM2 CPUFUNC(op_2179_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (6);
	regs.irc = get_word_ce030_prefetch (8);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (8);
}}}}return;
}

/* MOVE.L (d16,PC),(d16,An) */
void REGPARAM2 CPUFUNC(op_217a_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	regs.irc = get_word_ce030_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.L (d8,PC,Xn),(d16,An) */
void REGPARAM2 CPUFUNC(op_217b_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (0);
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (2);
}}}}}return;
}

/* MOVE.L #<data>.L,(d16,An) */
void REGPARAM2 CPUFUNC(op_217c_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (6);
	regs.irc = get_word_ce030_prefetch (8);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (8);
}}}return;
}

/* MOVE.L Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_2180_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
}}}}return;
}

/* MOVE.L An,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_2188_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
}}}}return;
}

/* MOVE.L (An),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_2190_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
}}}}}return;
}

/* MOVE.L (An)+,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_2198_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
}}}}}return;
}

#endif

#ifdef PART_3
/* MOVE.L -(An),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_21a0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
}}}}}return;
}

/* MOVE.L (d16,An),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_21a8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
}}}}}return;
}

/* MOVE.L (d8,An,Xn),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_21b0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 1);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
}}}}}}return;
}

/* MOVE.L (xxx).W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_21b8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
}}}}}return;
}

/* MOVE.L (xxx).L,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_21b9_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	m68k_incpci (6);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
}}}}}return;
}

/* MOVE.L (d16,PC),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_21ba_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
}}}}}return;
}

/* MOVE.L (d8,PC,Xn),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_21bb_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 1);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
}}}}}}return;
}

/* MOVE.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_21bc_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (6);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
}}}}return;
}

/* MOVE.L Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_21c0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}return;
}

/* MOVE.L An,(xxx).W */
void REGPARAM2 CPUFUNC(op_21c8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}return;
}

/* MOVE.L (An),(xxx).W */
void REGPARAM2 CPUFUNC(op_21d0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.L (An)+,(xxx).W */
void REGPARAM2 CPUFUNC(op_21d8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.L -(An),(xxx).W */
void REGPARAM2 CPUFUNC(op_21e0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.L (d16,An),(xxx).W */
void REGPARAM2 CPUFUNC(op_21e8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	regs.irc = get_word_ce030_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.L (d8,An,Xn),(xxx).W */
void REGPARAM2 CPUFUNC(op_21f0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (0);
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (2);
}}}}}return;
}

/* MOVE.L (xxx).W,(xxx).W */
void REGPARAM2 CPUFUNC(op_21f8_23)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	regs.irc = get_word_ce030_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.L (xxx).L,(xxx).W */
void REGPARAM2 CPUFUNC(op_21f9_23)(uae_u32 opcode)
{
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (6);
	regs.irc = get_word_ce030_prefetch (8);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (8);
}}}}return;
}

/* MOVE.L (d16,PC),(xxx).W */
void REGPARAM2 CPUFUNC(op_21fa_23)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	regs.irc = get_word_ce030_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.L (d8,PC,Xn),(xxx).W */
void REGPARAM2 CPUFUNC(op_21fb_23)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (0);
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (2);
}}}}}return;
}

/* MOVE.L #<data>.L,(xxx).W */
void REGPARAM2 CPUFUNC(op_21fc_23)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (6);
	regs.irc = get_word_ce030_prefetch (8);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (8);
}}}return;
}

/* MOVE.L Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_23c0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
	m68k_incpci (6);
}}}return;
}

/* MOVE.L An,(xxx).L */
void REGPARAM2 CPUFUNC(op_23c8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
	m68k_incpci (6);
}}}return;
}

/* MOVE.L (An),(xxx).L */
void REGPARAM2 CPUFUNC(op_23d0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.L (An)+,(xxx).L */
void REGPARAM2 CPUFUNC(op_23d8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.L -(An),(xxx).L */
void REGPARAM2 CPUFUNC(op_23e0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.L (d16,An),(xxx).L */
void REGPARAM2 CPUFUNC(op_23e8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (4);
	regs.irc = get_word_ce030_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
	m68k_incpci (8);
}}}}return;
}

/* MOVE.L (d8,An,Xn),(xxx).L */
void REGPARAM2 CPUFUNC(op_23f0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (0);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}}}return;
}

/* MOVE.L (xxx).W,(xxx).L */
void REGPARAM2 CPUFUNC(op_23f8_23)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (4);
	regs.irc = get_word_ce030_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
	m68k_incpci (8);
}}}}return;
}

/* MOVE.L (xxx).L,(xxx).L */
void REGPARAM2 CPUFUNC(op_23f9_23)(uae_u32 opcode)
{
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (6);
	regs.irc = get_word_ce030_prefetch (10);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
	m68k_incpci (10);
}}}}return;
}

/* MOVE.L (d16,PC),(xxx).L */
void REGPARAM2 CPUFUNC(op_23fa_23)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (4);
	regs.irc = get_word_ce030_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
	m68k_incpci (8);
}}}}return;
}

/* MOVE.L (d8,PC,Xn),(xxx).L */
void REGPARAM2 CPUFUNC(op_23fb_23)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (0);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}}}return;
}

/* MOVE.L #<data>.L,(xxx).L */
void REGPARAM2 CPUFUNC(op_23fc_23)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (6);
	regs.irc = get_word_ce030_prefetch (10);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
	m68k_incpci (10);
}}}return;
}

/* MOVE.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_3000_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	/* op H:2,T:0,C:0 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (2);
}}}return;
}

/* MOVE.W An,Dn */
void REGPARAM2 CPUFUNC(op_3008_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	/* op H:2,T:0,C:0 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (2);
}}}return;
}

/* MOVE.W (An),Dn */
void REGPARAM2 CPUFUNC(op_3010_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
{	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.W (An)+,Dn */
void REGPARAM2 CPUFUNC(op_3018_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.W -(An),Dn */
void REGPARAM2 CPUFUNC(op_3020_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_3028_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.W (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_3030_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
{	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}return;
}

/* MOVE.W (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_3038_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.W (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_3039_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.W (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_303a_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.W (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_303b_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
{	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}return;
}

/* MOVE.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_303c_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:0,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (4);
}}}return;
}

/* MOVEA.W Dn,An */
void REGPARAM2 CPUFUNC(op_3040_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	/* op H:2,T:0,C:0 */
	src = (uae_s32)(uae_s16)src;
	regs.irc = get_word_ce030_prefetch (2);
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (2);
}}}return;
}

/* MOVEA.W An,An */
void REGPARAM2 CPUFUNC(op_3048_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	/* op H:2,T:0,C:0 */
	src = (uae_s32)(uae_s16)src;
	regs.irc = get_word_ce030_prefetch (2);
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (2);
}}}return;
}

/* MOVEA.W (An),An */
void REGPARAM2 CPUFUNC(op_3050_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
{	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (2);
}}}}return;
}

/* MOVEA.W (An)+,An */
void REGPARAM2 CPUFUNC(op_3058_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (2);
}}}}return;
}

/* MOVEA.W -(An),An */
void REGPARAM2 CPUFUNC(op_3060_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (2);
}}}}return;
}

/* MOVEA.W (d16,An),An */
void REGPARAM2 CPUFUNC(op_3068_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (4);
}}}}return;
}

/* MOVEA.W (d8,An,Xn),An */
void REGPARAM2 CPUFUNC(op_3070_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
{	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
}}}}}return;
}

/* MOVEA.W (xxx).W,An */
void REGPARAM2 CPUFUNC(op_3078_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (4);
}}}}return;
}

/* MOVEA.W (xxx).L,An */
void REGPARAM2 CPUFUNC(op_3079_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (6);
}}}}return;
}

/* MOVEA.W (d16,PC),An */
void REGPARAM2 CPUFUNC(op_307a_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (4);
}}}}return;
}

/* MOVEA.W (d8,PC,Xn),An */
void REGPARAM2 CPUFUNC(op_307b_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
{	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
}}}}}return;
}

/* MOVEA.W #<data>.W,An */
void REGPARAM2 CPUFUNC(op_307c_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:0,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (4);
}}}return;
}

/* MOVE.W Dn,(An) */
void REGPARAM2 CPUFUNC(op_3080_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}return;
}

/* MOVE.W An,(An) */
void REGPARAM2 CPUFUNC(op_3088_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}return;
}

/* MOVE.W (An),(An) */
void REGPARAM2 CPUFUNC(op_3090_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.W (An)+,(An) */
void REGPARAM2 CPUFUNC(op_3098_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.W -(An),(An) */
void REGPARAM2 CPUFUNC(op_30a0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.W (d16,An),(An) */
void REGPARAM2 CPUFUNC(op_30a8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.W (d8,An,Xn),(An) */
void REGPARAM2 CPUFUNC(op_30b0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
}}}}}return;
}

/* MOVE.W (xxx).W,(An) */
void REGPARAM2 CPUFUNC(op_30b8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.W (xxx).L,(An) */
void REGPARAM2 CPUFUNC(op_30b9_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.W (d16,PC),(An) */
void REGPARAM2 CPUFUNC(op_30ba_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.W (d8,PC,Xn),(An) */
void REGPARAM2 CPUFUNC(op_30bb_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
}}}}}return;
}

/* MOVE.W #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_30bc_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:0,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}return;
}

/* MOVE.W Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_30c0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 2;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}return;
}

/* MOVE.W An,(An)+ */
void REGPARAM2 CPUFUNC(op_30c8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 2;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}return;
}

/* MOVE.W (An),(An)+ */
void REGPARAM2 CPUFUNC(op_30d0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 2;
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.W (An)+,(An)+ */
void REGPARAM2 CPUFUNC(op_30d8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 2;
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.W -(An),(An)+ */
void REGPARAM2 CPUFUNC(op_30e0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 2;
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.W (d16,An),(An)+ */
void REGPARAM2 CPUFUNC(op_30e8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 2;
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.W (d8,An,Xn),(An)+ */
void REGPARAM2 CPUFUNC(op_30f0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 2;
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
}}}}}return;
}

/* MOVE.W (xxx).W,(An)+ */
void REGPARAM2 CPUFUNC(op_30f8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 2;
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.W (xxx).L,(An)+ */
void REGPARAM2 CPUFUNC(op_30f9_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 2;
	regs.irc = get_word_ce030_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.W (d16,PC),(An)+ */
void REGPARAM2 CPUFUNC(op_30fa_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 2;
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.W (d8,PC,Xn),(An)+ */
void REGPARAM2 CPUFUNC(op_30fb_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 2;
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
}}}}}return;
}

/* MOVE.W #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_30fc_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:0,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 2;
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}return;
}

/* MOVE.W Dn,-(An) */
void REGPARAM2 CPUFUNC(op_3100_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	/* op H:0,T:2,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}return;
}

/* MOVE.W An,-(An) */
void REGPARAM2 CPUFUNC(op_3108_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	/* op H:0,T:2,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}return;
}

/* MOVE.W (An),-(An) */
void REGPARAM2 CPUFUNC(op_3110_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.W (An)+,-(An) */
void REGPARAM2 CPUFUNC(op_3118_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.W -(An),-(An) */
void REGPARAM2 CPUFUNC(op_3120_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.W (d16,An),-(An) */
void REGPARAM2 CPUFUNC(op_3128_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.W (d8,An,Xn),-(An) */
void REGPARAM2 CPUFUNC(op_3130_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
}}}}}return;
}

/* MOVE.W (xxx).W,-(An) */
void REGPARAM2 CPUFUNC(op_3138_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.W (xxx).L,-(An) */
void REGPARAM2 CPUFUNC(op_3139_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.W (d16,PC),-(An) */
void REGPARAM2 CPUFUNC(op_313a_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.W (d8,PC,Xn),-(An) */
void REGPARAM2 CPUFUNC(op_313b_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
}}}}}return;
}

/* MOVE.W #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_313c_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:0,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}return;
}

/* MOVE.W Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_3140_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}return;
}

/* MOVE.W An,(d16,An) */
void REGPARAM2 CPUFUNC(op_3148_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}return;
}

/* MOVE.W (An),(d16,An) */
void REGPARAM2 CPUFUNC(op_3150_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.W (An)+,(d16,An) */
void REGPARAM2 CPUFUNC(op_3158_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.W -(An),(d16,An) */
void REGPARAM2 CPUFUNC(op_3160_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.W (d16,An),(d16,An) */
void REGPARAM2 CPUFUNC(op_3168_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	regs.irc = get_word_ce030_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.W (d8,An,Xn),(d16,An) */
void REGPARAM2 CPUFUNC(op_3170_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (0);
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}}}return;
}

/* MOVE.W (xxx).W,(d16,An) */
void REGPARAM2 CPUFUNC(op_3178_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	regs.irc = get_word_ce030_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.W (xxx).L,(d16,An) */
void REGPARAM2 CPUFUNC(op_3179_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (6);
	regs.irc = get_word_ce030_prefetch (8);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (8);
}}}}return;
}

/* MOVE.W (d16,PC),(d16,An) */
void REGPARAM2 CPUFUNC(op_317a_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	regs.irc = get_word_ce030_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.W (d8,PC,Xn),(d16,An) */
void REGPARAM2 CPUFUNC(op_317b_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (0);
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}}}return;
}

/* MOVE.W #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_317c_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:0,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	regs.irc = get_word_ce030_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (6);
}}}return;
}

/* MOVE.W Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_3180_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
}}}}return;
}

/* MOVE.W An,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_3188_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
}}}}return;
}

/* MOVE.W (An),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_3190_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
}}}}}return;
}

/* MOVE.W (An)+,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_3198_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
}}}}}return;
}

/* MOVE.W -(An),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_31a0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
}}}}}return;
}

/* MOVE.W (d16,An),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_31a8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
}}}}}return;
}

/* MOVE.W (d8,An,Xn),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_31b0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 1);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
}}}}}}return;
}

/* MOVE.W (xxx).W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_31b8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
}}}}}return;
}

/* MOVE.W (xxx).L,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_31b9_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	m68k_incpci (6);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
}}}}}return;
}

/* MOVE.W (d16,PC),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_31ba_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
}}}}}return;
}

/* MOVE.W (d8,PC,Xn),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_31bb_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 1);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
}}}}}}return;
}

/* MOVE.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_31bc_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:0,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
}}}}return;
}

/* MOVE.W Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_31c0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}return;
}

/* MOVE.W An,(xxx).W */
void REGPARAM2 CPUFUNC(op_31c8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}return;
}

/* MOVE.W (An),(xxx).W */
void REGPARAM2 CPUFUNC(op_31d0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.W (An)+,(xxx).W */
void REGPARAM2 CPUFUNC(op_31d8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.W -(An),(xxx).W */
void REGPARAM2 CPUFUNC(op_31e0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.W (d16,An),(xxx).W */
void REGPARAM2 CPUFUNC(op_31e8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	regs.irc = get_word_ce030_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.W (d8,An,Xn),(xxx).W */
void REGPARAM2 CPUFUNC(op_31f0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (0);
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}}}return;
}

/* MOVE.W (xxx).W,(xxx).W */
void REGPARAM2 CPUFUNC(op_31f8_23)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	regs.irc = get_word_ce030_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.W (xxx).L,(xxx).W */
void REGPARAM2 CPUFUNC(op_31f9_23)(uae_u32 opcode)
{
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (6);
	regs.irc = get_word_ce030_prefetch (8);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (8);
}}}}return;
}

/* MOVE.W (d16,PC),(xxx).W */
void REGPARAM2 CPUFUNC(op_31fa_23)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	regs.irc = get_word_ce030_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.W (d8,PC,Xn),(xxx).W */
void REGPARAM2 CPUFUNC(op_31fb_23)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (0);
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}}}return;
}

/* MOVE.W #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_31fc_23)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	regs.irc = get_word_ce030_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (6);
}}}return;
}

/* MOVE.W Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_33c0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
	m68k_incpci (6);
}}}return;
}

/* MOVE.W An,(xxx).L */
void REGPARAM2 CPUFUNC(op_33c8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
	m68k_incpci (6);
}}}return;
}

/* MOVE.W (An),(xxx).L */
void REGPARAM2 CPUFUNC(op_33d0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.W (An)+,(xxx).L */
void REGPARAM2 CPUFUNC(op_33d8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.W -(An),(xxx).L */
void REGPARAM2 CPUFUNC(op_33e0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.W (d16,An),(xxx).L */
void REGPARAM2 CPUFUNC(op_33e8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (4);
	regs.irc = get_word_ce030_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
	m68k_incpci (8);
}}}}return;
}

/* MOVE.W (d8,An,Xn),(xxx).L */
void REGPARAM2 CPUFUNC(op_33f0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (0);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}}}return;
}

/* MOVE.W (xxx).W,(xxx).L */
void REGPARAM2 CPUFUNC(op_33f8_23)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (4);
	regs.irc = get_word_ce030_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
	m68k_incpci (8);
}}}}return;
}

/* MOVE.W (xxx).L,(xxx).L */
void REGPARAM2 CPUFUNC(op_33f9_23)(uae_u32 opcode)
{
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (6);
	regs.irc = get_word_ce030_prefetch (10);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
	m68k_incpci (10);
}}}}return;
}

/* MOVE.W (d16,PC),(xxx).L */
void REGPARAM2 CPUFUNC(op_33fa_23)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (4);
	regs.irc = get_word_ce030_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
	m68k_incpci (8);
}}}}return;
}

/* MOVE.W (d8,PC,Xn),(xxx).L */
void REGPARAM2 CPUFUNC(op_33fb_23)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (0);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}}}return;
}

/* MOVE.W #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_33fc_23)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (4);
	regs.irc = get_word_ce030_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
	m68k_incpci (8);
}}}return;
}

/* NEGX.B Dn */
void REGPARAM2 CPUFUNC(op_4000_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
	/* op H:2,T:0,C:0 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((newv) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* NEGX.B (An) */
void REGPARAM2 CPUFUNC(op_4010_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, newv);
}}}}}	m68k_incpci (2);
return;
}

/* NEGX.B (An)+ */
void REGPARAM2 CPUFUNC(op_4018_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, newv);
}}}}}	m68k_incpci (2);
return;
}

/* NEGX.B -(An) */
void REGPARAM2 CPUFUNC(op_4020_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, newv);
}}}}}	m68k_incpci (2);
return;
}

/* NEGX.B (d16,An) */
void REGPARAM2 CPUFUNC(op_4028_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, newv);
}}}}}	m68k_incpci (4);
return;
}

/* NEGX.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4030_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, newv);
}}}}}}return;
}

/* NEGX.B (xxx).W */
void REGPARAM2 CPUFUNC(op_4038_23)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, newv);
}}}}}	m68k_incpci (4);
return;
}

/* NEGX.B (xxx).L */
void REGPARAM2 CPUFUNC(op_4039_23)(uae_u32 opcode)
{
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, newv);
}}}}}	m68k_incpci (6);
return;
}

/* NEGX.W Dn */
void REGPARAM2 CPUFUNC(op_4040_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	/* op H:2,T:0,C:0 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((newv) & 0xffff);
}}}}	m68k_incpci (2);
return;
}

/* NEGX.W (An) */
void REGPARAM2 CPUFUNC(op_4050_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, newv);
}}}}}	m68k_incpci (2);
return;
}

/* NEGX.W (An)+ */
void REGPARAM2 CPUFUNC(op_4058_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, newv);
}}}}}	m68k_incpci (2);
return;
}

/* NEGX.W -(An) */
void REGPARAM2 CPUFUNC(op_4060_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, newv);
}}}}}	m68k_incpci (2);
return;
}

/* NEGX.W (d16,An) */
void REGPARAM2 CPUFUNC(op_4068_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, newv);
}}}}}	m68k_incpci (4);
return;
}

/* NEGX.W (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4070_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, newv);
}}}}}}return;
}

/* NEGX.W (xxx).W */
void REGPARAM2 CPUFUNC(op_4078_23)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, newv);
}}}}}	m68k_incpci (4);
return;
}

/* NEGX.W (xxx).L */
void REGPARAM2 CPUFUNC(op_4079_23)(uae_u32 opcode)
{
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, newv);
}}}}}	m68k_incpci (6);
return;
}

/* NEGX.L Dn */
void REGPARAM2 CPUFUNC(op_4080_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	/* op H:2,T:0,C:0 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, srcreg) = (newv);
}}}}	m68k_incpci (2);
return;
}

/* NEGX.L (An) */
void REGPARAM2 CPUFUNC(op_4090_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, newv);
}}}}}	m68k_incpci (2);
return;
}

/* NEGX.L (An)+ */
void REGPARAM2 CPUFUNC(op_4098_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, newv);
}}}}}	m68k_incpci (2);
return;
}

/* NEGX.L -(An) */
void REGPARAM2 CPUFUNC(op_40a0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, newv);
}}}}}	m68k_incpci (2);
return;
}

/* NEGX.L (d16,An) */
void REGPARAM2 CPUFUNC(op_40a8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, newv);
}}}}}	m68k_incpci (4);
return;
}

/* NEGX.L (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_40b0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, newv);
}}}}}}return;
}

/* NEGX.L (xxx).W */
void REGPARAM2 CPUFUNC(op_40b8_23)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, newv);
}}}}}	m68k_incpci (4);
return;
}

/* NEGX.L (xxx).L */
void REGPARAM2 CPUFUNC(op_40b9_23)(uae_u32 opcode)
{
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, newv);
}}}}}	m68k_incpci (6);
return;
}

/* MVSR2.W Dn */
void REGPARAM2 CPUFUNC(op_40c0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_230632; }
{{	/* op H:2,T:0,C:2 */
	MakeSR ();
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((regs.sr) & 0xffff);
}}}	m68k_incpci (2);
l_230632: ;
return;
}

/* MVSR2.W (An) */
void REGPARAM2 CPUFUNC(op_40d0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_230633; }
{	/* ea H:2+2=4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	/* op H:2-,T:0,C:2 */
	MakeSR ();
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (2);
	x_put_word (srca, regs.sr);
}}}	m68k_incpci (2);
l_230633: ;
return;
}

/* MVSR2.W (An)+ */
void REGPARAM2 CPUFUNC(op_40d8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_230634; }
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += 2;
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	MakeSR ();
	do_cycles_ce020_internal (2);
	x_put_word (srca, regs.sr);
}}}	m68k_incpci (2);
l_230634: ;
return;
}

/* MVSR2.W -(An) */
void REGPARAM2 CPUFUNC(op_40e0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_230635; }
{	/* ea H:2+2=4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	m68k_areg (regs, srcreg) = srca;
	/* op H:2-,T:0,C:2 */
	MakeSR ();
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (2);
	x_put_word (srca, regs.sr);
}}}	m68k_incpci (2);
l_230635: ;
return;
}

/* MVSR2.W (d16,An) */
void REGPARAM2 CPUFUNC(op_40e8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_230636; }
{	/* ea H:2+2=4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	/* op H:2-,T:0,C:2 */
	MakeSR ();
	regs.irc = get_word_ce030_prefetch (4);
	do_cycles_ce020_internal (2);
	x_put_word (srca, regs.sr);
}}}	m68k_incpci (4);
l_230636: ;
return;
}

/* MVSR2.W (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_40f0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_230637; }
{	/* ea H:4+2=6,T:0,C:0 cea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
	/* op H:2-,T:0,C:2 */
	MakeSR ();
	regs.irc = get_word_ce030_prefetch (0);
	do_cycles_ce020_internal (2);
	x_put_word (srca, regs.sr);
}}}}l_230637: ;
return;
}

/* MVSR2.W (xxx).W */
void REGPARAM2 CPUFUNC(op_40f8_23)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_230638; }
{	/* ea H:2+2=4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	/* op H:2-,T:0,C:2 */
	MakeSR ();
	regs.irc = get_word_ce030_prefetch (4);
	do_cycles_ce020_internal (2);
	x_put_word (srca, regs.sr);
}}}	m68k_incpci (4);
l_230638: ;
return;
}

/* MVSR2.W (xxx).L */
void REGPARAM2 CPUFUNC(op_40f9_23)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_230639; }
{	/* ea H:4+2=6,T:0,C:0 cea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
	/* op H:2-,T:0,C:2 */
	MakeSR ();
	regs.irc = get_word_ce030_prefetch (6);
	do_cycles_ce020_internal (2);
	x_put_word (srca, regs.sr);
}}}	m68k_incpci (6);
l_230639: ;
return;
}

/* CHK.L Dn,Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4100_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	/* OP zero */
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	m68k_incpci (2);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_230640;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_230640;
	}
	regs.irc = get_word_ce030_prefetch (0);
}}}l_230640: ;
return;
}

#endif
/* CHK.L (An),Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4110_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	/* OP zero */
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	m68k_incpci (2);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_230641;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_230641;
	}
	regs.irc = get_word_ce030_prefetch (0);
}}}}l_230641: ;
return;
}

#endif
/* CHK.L (An)+,Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4118_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
	/* OP zero */
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	m68k_incpci (2);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_230642;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_230642;
	}
	regs.irc = get_word_ce030_prefetch (0);
}}}}l_230642: ;
return;
}

#endif
/* CHK.L -(An),Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4120_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
	/* OP zero */
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	m68k_incpci (2);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_230643;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_230643;
	}
	regs.irc = get_word_ce030_prefetch (0);
}}}}l_230643: ;
return;
}

#endif
/* CHK.L (d16,An),Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4128_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
	/* OP zero */
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	m68k_incpci (4);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_230644;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_230644;
	}
	regs.irc = get_word_ce030_prefetch (0);
}}}}l_230644: ;
return;
}

#endif
/* CHK.L (d8,An,Xn),Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4130_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s32 src = x_get_long (srca);
	/* OP zero */
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_230645;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_230645;
	}
	regs.irc = get_word_ce030_prefetch (0);
}}}}}l_230645: ;
return;
}

#endif
/* CHK.L (xxx).W,Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4138_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
	/* OP zero */
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	m68k_incpci (4);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_230646;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_230646;
	}
	regs.irc = get_word_ce030_prefetch (0);
}}}}l_230646: ;
return;
}

#endif
/* CHK.L (xxx).L,Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4139_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
	/* OP zero */
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	m68k_incpci (6);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_230647;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_230647;
	}
	regs.irc = get_word_ce030_prefetch (0);
}}}}l_230647: ;
return;
}

#endif
/* CHK.L (d16,PC),Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_413a_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
	/* OP zero */
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	m68k_incpci (4);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_230648;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_230648;
	}
	regs.irc = get_word_ce030_prefetch (0);
}}}}l_230648: ;
return;
}

#endif
/* CHK.L (d8,PC,Xn),Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_413b_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s32 src = x_get_long (srca);
	/* OP zero */
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_230649;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_230649;
	}
	regs.irc = get_word_ce030_prefetch (0);
}}}}}l_230649: ;
return;
}

#endif
/* CHK.L #<data>.L,Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_413c_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
	/* OP zero */
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	m68k_incpci (6);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_230650;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_230650;
	}
	regs.irc = get_word_ce030_prefetch (0);
}}}l_230650: ;
return;
}

#endif
/* CHK.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_4180_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	/* OP zero */
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	m68k_incpci (2);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_230651;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_230651;
	}
	regs.irc = get_word_ce030_prefetch (0);
}}}l_230651: ;
return;
}

/* CHK.W (An),Dn */
void REGPARAM2 CPUFUNC(op_4190_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	/* OP zero */
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	m68k_incpci (2);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_230652;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_230652;
	}
	regs.irc = get_word_ce030_prefetch (0);
}}}}l_230652: ;
return;
}

/* CHK.W (An)+,Dn */
void REGPARAM2 CPUFUNC(op_4198_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
	/* OP zero */
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	m68k_incpci (2);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_230653;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_230653;
	}
	regs.irc = get_word_ce030_prefetch (0);
}}}}l_230653: ;
return;
}

/* CHK.W -(An),Dn */
void REGPARAM2 CPUFUNC(op_41a0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
	/* OP zero */
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	m68k_incpci (2);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_230654;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_230654;
	}
	regs.irc = get_word_ce030_prefetch (0);
}}}}l_230654: ;
return;
}

/* CHK.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_41a8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	/* OP zero */
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	m68k_incpci (4);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_230655;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_230655;
	}
	regs.irc = get_word_ce030_prefetch (0);
}}}}l_230655: ;
return;
}

/* CHK.W (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_41b0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
	/* OP zero */
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_230656;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_230656;
	}
	regs.irc = get_word_ce030_prefetch (0);
}}}}}l_230656: ;
return;
}

/* CHK.W (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_41b8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	/* OP zero */
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	m68k_incpci (4);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_230657;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_230657;
	}
	regs.irc = get_word_ce030_prefetch (0);
}}}}l_230657: ;
return;
}

/* CHK.W (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_41b9_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	/* OP zero */
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	m68k_incpci (6);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_230658;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_230658;
	}
	regs.irc = get_word_ce030_prefetch (0);
}}}}l_230658: ;
return;
}

/* CHK.W (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_41ba_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	/* OP zero */
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	m68k_incpci (4);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_230659;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_230659;
	}
	regs.irc = get_word_ce030_prefetch (0);
}}}}l_230659: ;
return;
}

/* CHK.W (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_41bb_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
	/* OP zero */
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_230660;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_230660;
	}
	regs.irc = get_word_ce030_prefetch (0);
}}}}}l_230660: ;
return;
}

/* CHK.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_41bc_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	m68k_incpci (4);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_230661;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_230661;
	}
	regs.irc = get_word_ce030_prefetch (0);
}}}l_230661: ;
return;
}

/* LEA.L (An),An */
void REGPARAM2 CPUFUNC(op_41d0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2+2=4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	/* op H:2-,T:0,C:0 */
	regs.irc = get_word_ce030_prefetch (2);
	m68k_areg (regs, dstreg) = (srca);
}}}	m68k_incpci (2);
return;
}

/* LEA.L (d16,An),An */
void REGPARAM2 CPUFUNC(op_41e8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2+2=4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	/* op H:2-,T:0,C:0 */
	regs.irc = get_word_ce030_prefetch (4);
	m68k_areg (regs, dstreg) = (srca);
}}}	m68k_incpci (4);
return;
}

/* LEA.L (d8,An,Xn),An */
void REGPARAM2 CPUFUNC(op_41f0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4+2=6,T:0,C:0 cea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	/* op H:2-,T:0,C:0 */
	regs.irc = get_word_ce030_prefetch (0);
	m68k_areg (regs, dstreg) = (srca);
}}}}return;
}

/* LEA.L (xxx).W,An */
void REGPARAM2 CPUFUNC(op_41f8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2+2=4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	/* op H:2-,T:0,C:0 */
	regs.irc = get_word_ce030_prefetch (4);
	m68k_areg (regs, dstreg) = (srca);
}}}	m68k_incpci (4);
return;
}

/* LEA.L (xxx).L,An */
void REGPARAM2 CPUFUNC(op_41f9_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4+2=6,T:0,C:0 cea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	/* op H:2-,T:0,C:0 */
	regs.irc = get_word_ce030_prefetch (6);
	m68k_areg (regs, dstreg) = (srca);
}}}	m68k_incpci (6);
return;
}

/* LEA.L (d16,PC),An */
void REGPARAM2 CPUFUNC(op_41fa_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2+2=4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	/* op H:2-,T:0,C:0 */
	regs.irc = get_word_ce030_prefetch (4);
	m68k_areg (regs, dstreg) = (srca);
}}}	m68k_incpci (4);
return;
}

/* LEA.L (d8,PC,Xn),An */
void REGPARAM2 CPUFUNC(op_41fb_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4+2=6,T:0,C:0 cea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	/* op H:2-,T:0,C:0 */
	regs.irc = get_word_ce030_prefetch (0);
	m68k_areg (regs, dstreg) = (srca);
}}}}return;
}

/* CLR.B Dn */
void REGPARAM2 CPUFUNC(op_4200_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	/* op H:2,T:0,C:0 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(0)) == 0);
	SET_NFLG (((uae_s8)(0)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((0) & 0xff);
}}	m68k_incpci (2);
return;
}

/* CLR.B (An) */
void REGPARAM2 CPUFUNC(op_4210_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(0)) == 0);
	SET_NFLG (((uae_s8)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, 0);
}}	m68k_incpci (2);
return;
}

/* CLR.B (An)+ */
void REGPARAM2 CPUFUNC(op_4218_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(0)) == 0);
	SET_NFLG (((uae_s8)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, 0);
}}	m68k_incpci (2);
return;
}

/* CLR.B -(An) */
void REGPARAM2 CPUFUNC(op_4220_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(0)) == 0);
	SET_NFLG (((uae_s8)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, 0);
}}	m68k_incpci (2);
return;
}

/* CLR.B (d16,An) */
void REGPARAM2 CPUFUNC(op_4228_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(0)) == 0);
	SET_NFLG (((uae_s8)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, 0);
}}	m68k_incpci (4);
return;
}

/* CLR.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4230_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(0)) == 0);
	SET_NFLG (((uae_s8)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, 0);
}}}return;
}

/* CLR.B (xxx).W */
void REGPARAM2 CPUFUNC(op_4238_23)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(0)) == 0);
	SET_NFLG (((uae_s8)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, 0);
}}	m68k_incpci (4);
return;
}

/* CLR.B (xxx).L */
void REGPARAM2 CPUFUNC(op_4239_23)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(0)) == 0);
	SET_NFLG (((uae_s8)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, 0);
}}	m68k_incpci (6);
return;
}

/* CLR.W Dn */
void REGPARAM2 CPUFUNC(op_4240_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	/* op H:2,T:0,C:0 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(0)) == 0);
	SET_NFLG (((uae_s16)(0)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((0) & 0xffff);
}}	m68k_incpci (2);
return;
}

/* CLR.W (An) */
void REGPARAM2 CPUFUNC(op_4250_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(0)) == 0);
	SET_NFLG (((uae_s16)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, 0);
}}	m68k_incpci (2);
return;
}

/* CLR.W (An)+ */
void REGPARAM2 CPUFUNC(op_4258_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += 2;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(0)) == 0);
	SET_NFLG (((uae_s16)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, 0);
}}	m68k_incpci (2);
return;
}

/* CLR.W -(An) */
void REGPARAM2 CPUFUNC(op_4260_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(0)) == 0);
	SET_NFLG (((uae_s16)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, 0);
}}	m68k_incpci (2);
return;
}

/* CLR.W (d16,An) */
void REGPARAM2 CPUFUNC(op_4268_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(0)) == 0);
	SET_NFLG (((uae_s16)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, 0);
}}	m68k_incpci (4);
return;
}

/* CLR.W (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4270_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(0)) == 0);
	SET_NFLG (((uae_s16)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, 0);
}}}return;
}

/* CLR.W (xxx).W */
void REGPARAM2 CPUFUNC(op_4278_23)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(0)) == 0);
	SET_NFLG (((uae_s16)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, 0);
}}	m68k_incpci (4);
return;
}

/* CLR.W (xxx).L */
void REGPARAM2 CPUFUNC(op_4279_23)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(0)) == 0);
	SET_NFLG (((uae_s16)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, 0);
}}	m68k_incpci (6);
return;
}

/* CLR.L Dn */
void REGPARAM2 CPUFUNC(op_4280_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	/* op H:2,T:0,C:0 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(0)) == 0);
	SET_NFLG (((uae_s32)(0)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, srcreg) = (0);
}}	m68k_incpci (2);
return;
}

/* CLR.L (An) */
void REGPARAM2 CPUFUNC(op_4290_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(0)) == 0);
	SET_NFLG (((uae_s32)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, 0);
}}	m68k_incpci (2);
return;
}

/* CLR.L (An)+ */
void REGPARAM2 CPUFUNC(op_4298_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += 4;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(0)) == 0);
	SET_NFLG (((uae_s32)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, 0);
}}	m68k_incpci (2);
return;
}

/* CLR.L -(An) */
void REGPARAM2 CPUFUNC(op_42a0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(0)) == 0);
	SET_NFLG (((uae_s32)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, 0);
}}	m68k_incpci (2);
return;
}

/* CLR.L (d16,An) */
void REGPARAM2 CPUFUNC(op_42a8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(0)) == 0);
	SET_NFLG (((uae_s32)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, 0);
}}	m68k_incpci (4);
return;
}

/* CLR.L (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_42b0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(0)) == 0);
	SET_NFLG (((uae_s32)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, 0);
}}}return;
}

/* CLR.L (xxx).W */
void REGPARAM2 CPUFUNC(op_42b8_23)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(0)) == 0);
	SET_NFLG (((uae_s32)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, 0);
}}	m68k_incpci (4);
return;
}

/* CLR.L (xxx).L */
void REGPARAM2 CPUFUNC(op_42b9_23)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(0)) == 0);
	SET_NFLG (((uae_s32)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, 0);
}}	m68k_incpci (6);
return;
}

/* MVSR2.B Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_42c0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	/* op H:2,T:0,C:2 */
	MakeSR ();
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((regs.sr & 0xff) & 0xffff);
}}	m68k_incpci (2);
return;
}

#endif
/* MVSR2.B (An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_42d0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2+2=4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	/* op H:2-,T:0,C:2 */
	MakeSR ();
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (2);
	x_put_word (srca, regs.sr & 0xff);
}}	m68k_incpci (2);
return;
}

#endif
/* MVSR2.B (An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_42d8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += 2;
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	MakeSR ();
	do_cycles_ce020_internal (2);
	x_put_word (srca, regs.sr & 0xff);
}}	m68k_incpci (2);
return;
}

#endif
/* MVSR2.B -(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_42e0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2+2=4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	m68k_areg (regs, srcreg) = srca;
	/* op H:2-,T:0,C:2 */
	MakeSR ();
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (2);
	x_put_word (srca, regs.sr & 0xff);
}}	m68k_incpci (2);
return;
}

#endif
/* MVSR2.B (d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_42e8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2+2=4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	/* op H:2-,T:0,C:2 */
	MakeSR ();
	regs.irc = get_word_ce030_prefetch (4);
	do_cycles_ce020_internal (2);
	x_put_word (srca, regs.sr & 0xff);
}}	m68k_incpci (4);
return;
}

#endif
/* MVSR2.B (d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_42f0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4+2=6,T:0,C:0 cea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
	/* op H:2-,T:0,C:2 */
	MakeSR ();
	regs.irc = get_word_ce030_prefetch (0);
	do_cycles_ce020_internal (2);
	x_put_word (srca, regs.sr & 0xff);
}}}return;
}

#endif
/* MVSR2.B (xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_42f8_23)(uae_u32 opcode)
{
{	/* ea H:2+2=4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	/* op H:2-,T:0,C:2 */
	MakeSR ();
	regs.irc = get_word_ce030_prefetch (4);
	do_cycles_ce020_internal (2);
	x_put_word (srca, regs.sr & 0xff);
}}	m68k_incpci (4);
return;
}

#endif
/* MVSR2.B (xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_42f9_23)(uae_u32 opcode)
{
{	/* ea H:4+2=6,T:0,C:0 cea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
	/* op H:2-,T:0,C:2 */
	MakeSR ();
	regs.irc = get_word_ce030_prefetch (6);
	do_cycles_ce020_internal (2);
	x_put_word (srca, regs.sr & 0xff);
}}	m68k_incpci (6);
return;
}

#endif
/* NEG.B Dn */
void REGPARAM2 CPUFUNC(op_4400_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
	/* op H:2,T:0,C:0 */
{{uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((dst) & 0xff);
}}}}}	m68k_incpci (2);
return;
}

#endif

#ifdef PART_4
/* NEG.B (An) */
void REGPARAM2 CPUFUNC(op_4410_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, dst);
}}}}}}	m68k_incpci (2);
return;
}

/* NEG.B (An)+ */
void REGPARAM2 CPUFUNC(op_4418_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, dst);
}}}}}}	m68k_incpci (2);
return;
}

/* NEG.B -(An) */
void REGPARAM2 CPUFUNC(op_4420_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, dst);
}}}}}}	m68k_incpci (2);
return;
}

/* NEG.B (d16,An) */
void REGPARAM2 CPUFUNC(op_4428_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, dst);
}}}}}}	m68k_incpci (4);
return;
}

/* NEG.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4430_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, dst);
}}}}}}}return;
}

/* NEG.B (xxx).W */
void REGPARAM2 CPUFUNC(op_4438_23)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, dst);
}}}}}}	m68k_incpci (4);
return;
}

/* NEG.B (xxx).L */
void REGPARAM2 CPUFUNC(op_4439_23)(uae_u32 opcode)
{
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, dst);
}}}}}}	m68k_incpci (6);
return;
}

/* NEG.W Dn */
void REGPARAM2 CPUFUNC(op_4440_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	/* op H:2,T:0,C:0 */
{{uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((dst) & 0xffff);
}}}}}	m68k_incpci (2);
return;
}

/* NEG.W (An) */
void REGPARAM2 CPUFUNC(op_4450_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, dst);
}}}}}}	m68k_incpci (2);
return;
}

/* NEG.W (An)+ */
void REGPARAM2 CPUFUNC(op_4458_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, dst);
}}}}}}	m68k_incpci (2);
return;
}

/* NEG.W -(An) */
void REGPARAM2 CPUFUNC(op_4460_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, dst);
}}}}}}	m68k_incpci (2);
return;
}

/* NEG.W (d16,An) */
void REGPARAM2 CPUFUNC(op_4468_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, dst);
}}}}}}	m68k_incpci (4);
return;
}

/* NEG.W (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4470_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, dst);
}}}}}}}return;
}

/* NEG.W (xxx).W */
void REGPARAM2 CPUFUNC(op_4478_23)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, dst);
}}}}}}	m68k_incpci (4);
return;
}

/* NEG.W (xxx).L */
void REGPARAM2 CPUFUNC(op_4479_23)(uae_u32 opcode)
{
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, dst);
}}}}}}	m68k_incpci (6);
return;
}

/* NEG.L Dn */
void REGPARAM2 CPUFUNC(op_4480_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	/* op H:2,T:0,C:0 */
{{uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, srcreg) = (dst);
}}}}}	m68k_incpci (2);
return;
}

/* NEG.L (An) */
void REGPARAM2 CPUFUNC(op_4490_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, dst);
}}}}}}	m68k_incpci (2);
return;
}

/* NEG.L (An)+ */
void REGPARAM2 CPUFUNC(op_4498_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, dst);
}}}}}}	m68k_incpci (2);
return;
}

/* NEG.L -(An) */
void REGPARAM2 CPUFUNC(op_44a0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, dst);
}}}}}}	m68k_incpci (2);
return;
}

/* NEG.L (d16,An) */
void REGPARAM2 CPUFUNC(op_44a8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, dst);
}}}}}}	m68k_incpci (4);
return;
}

/* NEG.L (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_44b0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, dst);
}}}}}}}return;
}

/* NEG.L (xxx).W */
void REGPARAM2 CPUFUNC(op_44b8_23)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, dst);
}}}}}}	m68k_incpci (4);
return;
}

/* NEG.L (xxx).L */
void REGPARAM2 CPUFUNC(op_44b9_23)(uae_u32 opcode)
{
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, dst);
}}}}}}	m68k_incpci (6);
return;
}

/* MV2SR.B Dn */
void REGPARAM2 CPUFUNC(op_44c0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	/* op H:4,T:0,C:0 */
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (2);
}}	m68k_incpci (2);
return;
}

/* MV2SR.B (An) */
void REGPARAM2 CPUFUNC(op_44d0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (2);
}}}	m68k_incpci (2);
return;
}

/* MV2SR.B (An)+ */
void REGPARAM2 CPUFUNC(op_44d8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (2);
}}}	m68k_incpci (2);
return;
}

/* MV2SR.B -(An) */
void REGPARAM2 CPUFUNC(op_44e0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (2);
}}}	m68k_incpci (2);
return;
}

/* MV2SR.B (d16,An) */
void REGPARAM2 CPUFUNC(op_44e8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (2);
}}}	m68k_incpci (4);
return;
}

/* MV2SR.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_44f0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (2);
}}}}return;
}

/* MV2SR.B (xxx).W */
void REGPARAM2 CPUFUNC(op_44f8_23)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (2);
}}}	m68k_incpci (4);
return;
}

/* MV2SR.B (xxx).L */
void REGPARAM2 CPUFUNC(op_44f9_23)(uae_u32 opcode)
{
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (2);
}}}	m68k_incpci (6);
return;
}

/* MV2SR.B (d16,PC) */
void REGPARAM2 CPUFUNC(op_44fa_23)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (2);
}}}	m68k_incpci (4);
return;
}

/* MV2SR.B (d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_44fb_23)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (2);
}}}}return;
}

/* MV2SR.B #<data>.B */
void REGPARAM2 CPUFUNC(op_44fc_23)(uae_u32 opcode)
{
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (2);
}}	m68k_incpci (4);
return;
}

/* NOT.B Dn */
void REGPARAM2 CPUFUNC(op_4600_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
	/* op H:2,T:0,C:0 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_NFLG (((uae_s8)(dst)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((dst) & 0xff);
}}}	m68k_incpci (2);
return;
}

/* NOT.B (An) */
void REGPARAM2 CPUFUNC(op_4610_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_NFLG (((uae_s8)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, dst);
}}}}	m68k_incpci (2);
return;
}

/* NOT.B (An)+ */
void REGPARAM2 CPUFUNC(op_4618_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_NFLG (((uae_s8)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, dst);
}}}}	m68k_incpci (2);
return;
}

/* NOT.B -(An) */
void REGPARAM2 CPUFUNC(op_4620_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_NFLG (((uae_s8)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, dst);
}}}}	m68k_incpci (2);
return;
}

/* NOT.B (d16,An) */
void REGPARAM2 CPUFUNC(op_4628_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_NFLG (((uae_s8)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, dst);
}}}}	m68k_incpci (4);
return;
}

/* NOT.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4630_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_NFLG (((uae_s8)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, dst);
}}}}}return;
}

/* NOT.B (xxx).W */
void REGPARAM2 CPUFUNC(op_4638_23)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_NFLG (((uae_s8)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, dst);
}}}}	m68k_incpci (4);
return;
}

/* NOT.B (xxx).L */
void REGPARAM2 CPUFUNC(op_4639_23)(uae_u32 opcode)
{
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_NFLG (((uae_s8)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, dst);
}}}}	m68k_incpci (6);
return;
}

/* NOT.W Dn */
void REGPARAM2 CPUFUNC(op_4640_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	/* op H:2,T:0,C:0 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((dst) & 0xffff);
}}}	m68k_incpci (2);
return;
}

/* NOT.W (An) */
void REGPARAM2 CPUFUNC(op_4650_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, dst);
}}}}	m68k_incpci (2);
return;
}

/* NOT.W (An)+ */
void REGPARAM2 CPUFUNC(op_4658_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, dst);
}}}}	m68k_incpci (2);
return;
}

/* NOT.W -(An) */
void REGPARAM2 CPUFUNC(op_4660_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, dst);
}}}}	m68k_incpci (2);
return;
}

/* NOT.W (d16,An) */
void REGPARAM2 CPUFUNC(op_4668_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, dst);
}}}}	m68k_incpci (4);
return;
}

/* NOT.W (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4670_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, dst);
}}}}}return;
}

/* NOT.W (xxx).W */
void REGPARAM2 CPUFUNC(op_4678_23)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, dst);
}}}}	m68k_incpci (4);
return;
}

/* NOT.W (xxx).L */
void REGPARAM2 CPUFUNC(op_4679_23)(uae_u32 opcode)
{
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, dst);
}}}}	m68k_incpci (6);
return;
}

/* NOT.L Dn */
void REGPARAM2 CPUFUNC(op_4680_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	/* op H:2,T:0,C:0 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, srcreg) = (dst);
}}}	m68k_incpci (2);
return;
}

/* NOT.L (An) */
void REGPARAM2 CPUFUNC(op_4690_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, dst);
}}}}	m68k_incpci (2);
return;
}

/* NOT.L (An)+ */
void REGPARAM2 CPUFUNC(op_4698_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, dst);
}}}}	m68k_incpci (2);
return;
}

/* NOT.L -(An) */
void REGPARAM2 CPUFUNC(op_46a0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, dst);
}}}}	m68k_incpci (2);
return;
}

/* NOT.L (d16,An) */
void REGPARAM2 CPUFUNC(op_46a8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, dst);
}}}}	m68k_incpci (4);
return;
}

/* NOT.L (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_46b0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, dst);
}}}}}return;
}

/* NOT.L (xxx).W */
void REGPARAM2 CPUFUNC(op_46b8_23)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, dst);
}}}}	m68k_incpci (4);
return;
}

/* NOT.L (xxx).L */
void REGPARAM2 CPUFUNC(op_46b9_23)(uae_u32 opcode)
{
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, dst);
}}}}	m68k_incpci (6);
return;
}

/* MV2SR.W Dn */
void REGPARAM2 CPUFUNC(op_46c0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_230760; }
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = m68k_dreg (regs, srcreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:8 */
	regs.sr = src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (6);
}}}	m68k_incpci (2);
l_230760: ;
return;
}

/* MV2SR.W (An) */
void REGPARAM2 CPUFUNC(op_46d0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_230761; }
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:8 */
	regs.sr = src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (6);
}}}}	m68k_incpci (2);
l_230761: ;
return;
}

/* MV2SR.W (An)+ */
void REGPARAM2 CPUFUNC(op_46d8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_230762; }
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:8 */
	regs.sr = src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (6);
}}}}	m68k_incpci (2);
l_230762: ;
return;
}

/* MV2SR.W -(An) */
void REGPARAM2 CPUFUNC(op_46e0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_230763; }
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:8 */
	regs.sr = src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (6);
}}}}	m68k_incpci (2);
l_230763: ;
return;
}

/* MV2SR.W (d16,An) */
void REGPARAM2 CPUFUNC(op_46e8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_230764; }
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:8 */
	regs.sr = src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (6);
}}}}	m68k_incpci (4);
l_230764: ;
return;
}

/* MV2SR.W (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_46f0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_230765; }
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:8 */
	regs.sr = src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (6);
}}}}}l_230765: ;
return;
}

/* MV2SR.W (xxx).W */
void REGPARAM2 CPUFUNC(op_46f8_23)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_230766; }
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:8 */
	regs.sr = src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (6);
}}}}	m68k_incpci (4);
l_230766: ;
return;
}

/* MV2SR.W (xxx).L */
void REGPARAM2 CPUFUNC(op_46f9_23)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_230767; }
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:8 */
	regs.sr = src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (6);
}}}}	m68k_incpci (6);
l_230767: ;
return;
}

/* MV2SR.W (d16,PC) */
void REGPARAM2 CPUFUNC(op_46fa_23)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_230768; }
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:8 */
	regs.sr = src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (6);
}}}}	m68k_incpci (4);
l_230768: ;
return;
}

/* MV2SR.W (d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_46fb_23)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_230769; }
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:8 */
	regs.sr = src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (6);
}}}}}l_230769: ;
return;
}

/* MV2SR.W #<data>.W */
void REGPARAM2 CPUFUNC(op_46fc_23)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_230770; }
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:8 */
	regs.sr = src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (6);
}}}	m68k_incpci (4);
l_230770: ;
return;
}

/* NBCD.B Dn */
void REGPARAM2 CPUFUNC(op_4800_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
	/* op H:0,T:0,C:6 */
{	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	if (newv_lo > 9) { newv_lo -= 6; }
	tmp_newv = newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (cflg);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (4);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((newv) & 0xff);
}}}	m68k_incpci (2);
return;
}

/* LINK.L An,#<data>.L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4808_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* op H:2,T:0,C:4 */
{	uaecptr olda;
	olda = m68k_areg (regs, 7) - 4;
	m68k_areg (regs, 7) = olda;
{	uae_s32 src = m68k_areg (regs, srcreg);
{	uae_s32 offs;
	offs = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	do_cycles_ce020_internal (4);
	x_put_long (olda, src);
	m68k_areg (regs, srcreg) = (m68k_areg (regs, 7));
	m68k_areg (regs, 7) += offs;
}}}}	m68k_incpci (6);
return;
}

#endif
/* NBCD.B (An) */
void REGPARAM2 CPUFUNC(op_4810_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	/* op H:0,T:0,C:6 */
{	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	if (newv_lo > 9) { newv_lo -= 6; }
	tmp_newv = newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (cflg);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (4);
	x_put_byte (srca, newv);
}}}}	m68k_incpci (2);
return;
}

/* NBCD.B (An)+ */
void REGPARAM2 CPUFUNC(op_4818_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	/* op H:0,T:0,C:6 */
{	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	if (newv_lo > 9) { newv_lo -= 6; }
	tmp_newv = newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (cflg);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (4);
	x_put_byte (srca, newv);
}}}}	m68k_incpci (2);
return;
}

/* NBCD.B -(An) */
void REGPARAM2 CPUFUNC(op_4820_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
	/* op H:0,T:0,C:6 */
{	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	if (newv_lo > 9) { newv_lo -= 6; }
	tmp_newv = newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (cflg);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (4);
	x_put_byte (srca, newv);
}}}}	m68k_incpci (2);
return;
}

/* NBCD.B (d16,An) */
void REGPARAM2 CPUFUNC(op_4828_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
	/* op H:0,T:0,C:6 */
{	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	if (newv_lo > 9) { newv_lo -= 6; }
	tmp_newv = newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (cflg);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	regs.irc = get_word_ce030_prefetch (4);
	do_cycles_ce020_internal (4);
	x_put_byte (srca, newv);
}}}}	m68k_incpci (4);
return;
}

/* NBCD.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4830_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s8 src = x_get_byte (srca);
	/* op H:0,T:0,C:6 */
{	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	if (newv_lo > 9) { newv_lo -= 6; }
	tmp_newv = newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (cflg);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	regs.irc = get_word_ce030_prefetch (0);
	do_cycles_ce020_internal (4);
	x_put_byte (srca, newv);
}}}}}return;
}

/* NBCD.B (xxx).W */
void REGPARAM2 CPUFUNC(op_4838_23)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
	/* op H:0,T:0,C:6 */
{	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	if (newv_lo > 9) { newv_lo -= 6; }
	tmp_newv = newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (cflg);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	regs.irc = get_word_ce030_prefetch (4);
	do_cycles_ce020_internal (4);
	x_put_byte (srca, newv);
}}}}	m68k_incpci (4);
return;
}

/* NBCD.B (xxx).L */
void REGPARAM2 CPUFUNC(op_4839_23)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
	/* op H:0,T:0,C:6 */
{	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	if (newv_lo > 9) { newv_lo -= 6; }
	tmp_newv = newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (cflg);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	regs.irc = get_word_ce030_prefetch (6);
	do_cycles_ce020_internal (4);
	x_put_byte (srca, newv);
}}}}	m68k_incpci (6);
return;
}

/* SWAP.W Dn */
void REGPARAM2 CPUFUNC(op_4840_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	/* op H:4,T:0,C:0 */
{	uae_u32 dst = ((src >> 16)&0xFFFF) | ((src&0xFFFF)<<16);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (2);
	m68k_dreg (regs, srcreg) = (dst);
}}}	m68k_incpci (2);
return;
}

/* BKPTQ.L #<data> */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4848_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	m68k_incpci (2);
	op_illg (opcode);
}return;
}

#endif
/* PEA.L (An) */
void REGPARAM2 CPUFUNC(op_4850_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:2,C:2 */
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	m68k_areg (regs, 7) = dsta;
	do_cycles_ce020_internal (2);
	x_put_long (dsta, srca);
}}}	m68k_incpci (2);
return;
}

/* PEA.L (d16,An) */
void REGPARAM2 CPUFUNC(op_4868_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:2,C:2 */
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	m68k_areg (regs, 7) = dsta;
	do_cycles_ce020_internal (2);
	x_put_long (dsta, srca);
}}}	m68k_incpci (4);
return;
}

/* PEA.L (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4870_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:2,C:2 */
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	m68k_areg (regs, 7) = dsta;
	do_cycles_ce020_internal (2);
	x_put_long (dsta, srca);
}}}}return;
}

/* PEA.L (xxx).W */
void REGPARAM2 CPUFUNC(op_4878_23)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:2,C:2 */
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	m68k_areg (regs, 7) = dsta;
	do_cycles_ce020_internal (2);
	x_put_long (dsta, srca);
}}}	m68k_incpci (4);
return;
}

/* PEA.L (xxx).L */
void REGPARAM2 CPUFUNC(op_4879_23)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:2,C:2 */
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	m68k_areg (regs, 7) = dsta;
	do_cycles_ce020_internal (2);
	x_put_long (dsta, srca);
}}}	m68k_incpci (6);
return;
}

/* PEA.L (d16,PC) */
void REGPARAM2 CPUFUNC(op_487a_23)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:2,C:2 */
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	m68k_areg (regs, 7) = dsta;
	do_cycles_ce020_internal (2);
	x_put_long (dsta, srca);
}}}	m68k_incpci (4);
return;
}

/* PEA.L (d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_487b_23)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:2,C:2 */
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	m68k_areg (regs, 7) = dsta;
	do_cycles_ce020_internal (2);
	x_put_long (dsta, srca);
}}}}return;
}

/* EXT.W Dn */
void REGPARAM2 CPUFUNC(op_4880_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	/* op H:4,T:0,C:0 */
{	uae_u16 dst = (uae_s16)(uae_s8)src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((dst) & 0xffff);
}}}	m68k_incpci (2);
return;
}

/* MVMLE.W #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_4890_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce030_prefetch (2);
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg);
	do_cycles_ce020_internal (2);
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { x_put_word (srca, m68k_dreg (regs, movem_index1[dmask])); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { x_put_word (srca, m68k_areg (regs, movem_index1[amask])); srca += 2; amask = movem_next[amask]; }
	regs.irc = get_word_ce030_prefetch (4);
}}}	m68k_incpci (4);
return;
}

/* MVMLE.W #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_48a0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce030_prefetch (2);
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) - 0;
	do_cycles_ce020_internal (2);
{	uae_u16 amask = mask & 0xff, dmask = (mask >> 8) & 0xff;
	int type = get_cpu_model () >= 68020;
	while (amask) {
		srca -= 2;
		if (!type || movem_index2[amask] != dstreg)
			x_put_word (srca, m68k_areg (regs, movem_index2[amask]));
		else
			x_put_word (srca, m68k_areg (regs, movem_index2[amask]) - 2);
		amask = movem_next[amask];
	}
	while (dmask) { srca -= 2; x_put_word (srca, m68k_dreg (regs, movem_index2[dmask])); dmask = movem_next[dmask]; }
	m68k_areg (regs, dstreg) = srca;
	regs.irc = get_word_ce030_prefetch (4);
}}}	m68k_incpci (4);
return;
}

/* MVMLE.W #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_48a8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce030_prefetch (2);
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	do_cycles_ce020_internal (2);
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { x_put_word (srca, m68k_dreg (regs, movem_index1[dmask])); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { x_put_word (srca, m68k_areg (regs, movem_index1[amask])); srca += 2; amask = movem_next[amask]; }
	regs.irc = get_word_ce030_prefetch (6);
}}}	m68k_incpci (6);
return;
}

/* MVMLE.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_48b0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce030_prefetch (2);
{	uaecptr srca;
	m68k_incpci (4);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	do_cycles_ce020_internal (2);
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { x_put_word (srca, m68k_dreg (regs, movem_index1[dmask])); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { x_put_word (srca, m68k_areg (regs, movem_index1[amask])); srca += 2; amask = movem_next[amask]; }
	regs.irc = get_word_ce030_prefetch (0);
}}}}return;
}

/* MVMLE.W #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_48b8_23)(uae_u32 opcode)
{
{	uae_u16 mask = get_word_ce030_prefetch (2);
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	do_cycles_ce020_internal (2);
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { x_put_word (srca, m68k_dreg (regs, movem_index1[dmask])); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { x_put_word (srca, m68k_areg (regs, movem_index1[amask])); srca += 2; amask = movem_next[amask]; }
	regs.irc = get_word_ce030_prefetch (6);
}}}	m68k_incpci (6);
return;
}

/* MVMLE.W #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_48b9_23)(uae_u32 opcode)
{
{	uae_u16 mask = get_word_ce030_prefetch (2);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (4);
	do_cycles_ce020_internal (2);
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { x_put_word (srca, m68k_dreg (regs, movem_index1[dmask])); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { x_put_word (srca, m68k_areg (regs, movem_index1[amask])); srca += 2; amask = movem_next[amask]; }
	regs.irc = get_word_ce030_prefetch (8);
}}}	m68k_incpci (8);
return;
}

/* EXT.L Dn */
void REGPARAM2 CPUFUNC(op_48c0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	/* op H:4,T:0,C:0 */
{	uae_u32 dst = (uae_s32)(uae_s16)src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (2);
	m68k_dreg (regs, srcreg) = (dst);
}}}	m68k_incpci (2);
return;
}

/* MVMLE.L #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_48d0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce030_prefetch (2);
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg);
	do_cycles_ce020_internal (2);
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { x_put_long (srca, m68k_dreg (regs, movem_index1[dmask])); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { x_put_long (srca, m68k_areg (regs, movem_index1[amask])); srca += 4; amask = movem_next[amask]; }
	regs.irc = get_word_ce030_prefetch (4);
}}}	m68k_incpci (4);
return;
}

/* MVMLE.L #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_48e0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce030_prefetch (2);
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) - 0;
	do_cycles_ce020_internal (2);
{	uae_u16 amask = mask & 0xff, dmask = (mask >> 8) & 0xff;
	int type = get_cpu_model () >= 68020;
	while (amask) {
		srca -= 4;
		if (!type || movem_index2[amask] != dstreg)
			x_put_long (srca, m68k_areg (regs, movem_index2[amask]));
		else
			x_put_long (srca, m68k_areg (regs, movem_index2[amask]) - 4);
		amask = movem_next[amask];
	}
	while (dmask) { srca -= 4; x_put_long (srca, m68k_dreg (regs, movem_index2[dmask])); dmask = movem_next[dmask]; }
	m68k_areg (regs, dstreg) = srca;
	regs.irc = get_word_ce030_prefetch (4);
}}}	m68k_incpci (4);
return;
}

/* MVMLE.L #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_48e8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce030_prefetch (2);
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	do_cycles_ce020_internal (2);
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { x_put_long (srca, m68k_dreg (regs, movem_index1[dmask])); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { x_put_long (srca, m68k_areg (regs, movem_index1[amask])); srca += 4; amask = movem_next[amask]; }
	regs.irc = get_word_ce030_prefetch (6);
}}}	m68k_incpci (6);
return;
}

/* MVMLE.L #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_48f0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce030_prefetch (2);
{	uaecptr srca;
	m68k_incpci (4);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	do_cycles_ce020_internal (2);
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { x_put_long (srca, m68k_dreg (regs, movem_index1[dmask])); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { x_put_long (srca, m68k_areg (regs, movem_index1[amask])); srca += 4; amask = movem_next[amask]; }
	regs.irc = get_word_ce030_prefetch (0);
}}}}return;
}

/* MVMLE.L #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_48f8_23)(uae_u32 opcode)
{
{	uae_u16 mask = get_word_ce030_prefetch (2);
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	do_cycles_ce020_internal (2);
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { x_put_long (srca, m68k_dreg (regs, movem_index1[dmask])); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { x_put_long (srca, m68k_areg (regs, movem_index1[amask])); srca += 4; amask = movem_next[amask]; }
	regs.irc = get_word_ce030_prefetch (6);
}}}	m68k_incpci (6);
return;
}

/* MVMLE.L #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_48f9_23)(uae_u32 opcode)
{
{	uae_u16 mask = get_word_ce030_prefetch (2);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (4);
	do_cycles_ce020_internal (2);
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { x_put_long (srca, m68k_dreg (regs, movem_index1[dmask])); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { x_put_long (srca, m68k_areg (regs, movem_index1[amask])); srca += 4; amask = movem_next[amask]; }
	regs.irc = get_word_ce030_prefetch (8);
}}}	m68k_incpci (8);
return;
}

/* EXT.B Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_49c0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	/* op H:4,T:0,C:0 */
{	uae_u32 dst = (uae_s32)(uae_s8)src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (2);
	m68k_dreg (regs, srcreg) = (dst);
}}}	m68k_incpci (2);
return;
}

#endif
/* TST.B Dn */
void REGPARAM2 CPUFUNC(op_4a00_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
}}	m68k_incpci (2);
return;
}

/* TST.B (An) */
void REGPARAM2 CPUFUNC(op_4a10_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}	m68k_incpci (2);
return;
}

/* TST.B (An)+ */
void REGPARAM2 CPUFUNC(op_4a18_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}	m68k_incpci (2);
return;
}

/* TST.B -(An) */
void REGPARAM2 CPUFUNC(op_4a20_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}	m68k_incpci (2);
return;
}

/* TST.B (d16,An) */
void REGPARAM2 CPUFUNC(op_4a28_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}	m68k_incpci (4);
return;
}

/* TST.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4a30_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}}return;
}

/* TST.B (xxx).W */
void REGPARAM2 CPUFUNC(op_4a38_23)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}	m68k_incpci (4);
return;
}

/* TST.B (xxx).L */
void REGPARAM2 CPUFUNC(op_4a39_23)(uae_u32 opcode)
{
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}	m68k_incpci (6);
return;
}

/* TST.B (d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4a3a_23)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}	m68k_incpci (4);
return;
}

#endif
/* TST.B (d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4a3b_23)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}}return;
}

#endif
/* TST.B #<data>.B */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4a3c_23)(uae_u32 opcode)
{
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}	m68k_incpci (4);
return;
}

#endif
/* TST.W Dn */
void REGPARAM2 CPUFUNC(op_4a40_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
}}	m68k_incpci (2);
return;
}

/* TST.W An */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4a48_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}	m68k_incpci (2);
return;
}

#endif
/* TST.W (An) */
void REGPARAM2 CPUFUNC(op_4a50_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}	m68k_incpci (2);
return;
}

/* TST.W (An)+ */
void REGPARAM2 CPUFUNC(op_4a58_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}	m68k_incpci (2);
return;
}

/* TST.W -(An) */
void REGPARAM2 CPUFUNC(op_4a60_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}	m68k_incpci (2);
return;
}

/* TST.W (d16,An) */
void REGPARAM2 CPUFUNC(op_4a68_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}	m68k_incpci (4);
return;
}

/* TST.W (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4a70_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}}return;
}

/* TST.W (xxx).W */
void REGPARAM2 CPUFUNC(op_4a78_23)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}	m68k_incpci (4);
return;
}

/* TST.W (xxx).L */
void REGPARAM2 CPUFUNC(op_4a79_23)(uae_u32 opcode)
{
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}	m68k_incpci (6);
return;
}

/* TST.W (d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4a7a_23)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}	m68k_incpci (4);
return;
}

#endif
/* TST.W (d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4a7b_23)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}}return;
}

#endif
/* TST.W #<data>.W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4a7c_23)(uae_u32 opcode)
{
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}	m68k_incpci (4);
return;
}

#endif
/* TST.L Dn */
void REGPARAM2 CPUFUNC(op_4a80_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
}}	m68k_incpci (2);
return;
}

/* TST.L An */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4a88_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s32 src = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}	m68k_incpci (2);
return;
}

#endif
/* TST.L (An) */
void REGPARAM2 CPUFUNC(op_4a90_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}	m68k_incpci (2);
return;
}

/* TST.L (An)+ */
void REGPARAM2 CPUFUNC(op_4a98_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}	m68k_incpci (2);
return;
}

/* TST.L -(An) */
void REGPARAM2 CPUFUNC(op_4aa0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}	m68k_incpci (2);
return;
}

/* TST.L (d16,An) */
void REGPARAM2 CPUFUNC(op_4aa8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}	m68k_incpci (4);
return;
}

/* TST.L (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4ab0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}}return;
}

/* TST.L (xxx).W */
void REGPARAM2 CPUFUNC(op_4ab8_23)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}	m68k_incpci (4);
return;
}

/* TST.L (xxx).L */
void REGPARAM2 CPUFUNC(op_4ab9_23)(uae_u32 opcode)
{
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}	m68k_incpci (6);
return;
}

/* TST.L (d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4aba_23)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}	m68k_incpci (4);
return;
}

#endif
/* TST.L (d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4abb_23)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}}return;
}

#endif
/* TST.L #<data>.L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4abc_23)(uae_u32 opcode)
{
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}	m68k_incpci (6);
return;
}

#endif
/* TAS.B Dn */
void REGPARAM2 CPUFUNC(op_4ac0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	src |= 0x80;
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((src) & 0xff);
}}	m68k_incpci (2);
return;
}

/* TAS.B (An) */
void REGPARAM2 CPUFUNC(op_4ad0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	src |= 0x80;
	x_put_byte (srca, src);
}}}	m68k_incpci (2);
return;
}

/* TAS.B (An)+ */
void REGPARAM2 CPUFUNC(op_4ad8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	src |= 0x80;
	x_put_byte (srca, src);
}}}	m68k_incpci (2);
return;
}

/* TAS.B -(An) */
void REGPARAM2 CPUFUNC(op_4ae0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	src |= 0x80;
	x_put_byte (srca, src);
}}}	m68k_incpci (2);
return;
}

/* TAS.B (d16,An) */
void REGPARAM2 CPUFUNC(op_4ae8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	src |= 0x80;
	x_put_byte (srca, src);
}}}	m68k_incpci (4);
return;
}

/* TAS.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4af0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	src |= 0x80;
	x_put_byte (srca, src);
}}}}return;
}

/* TAS.B (xxx).W */
void REGPARAM2 CPUFUNC(op_4af8_23)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	src |= 0x80;
	x_put_byte (srca, src);
}}}	m68k_incpci (4);
return;
}

/* TAS.B (xxx).L */
void REGPARAM2 CPUFUNC(op_4af9_23)(uae_u32 opcode)
{
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	src |= 0x80;
	x_put_byte (srca, src);
}}}	m68k_incpci (6);
return;
}

/* MULL.L #<data>.W,Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c00_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* op H:2,T:0,C:28 */
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:28 */
	m68k_incpci (4);
	if (!m68k_mull(opcode, dst, extra)) goto l_230847;
	regs.irc = get_word_ce030_prefetch (0);
	do_cycles_ce020_internal (28);
}}}l_230847: ;
return;
}

#endif
/* MULL.L #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c10_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* op H:2,T:0,C:28 */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = x_get_long (dsta);
	/* op H:2,T:0,C:28 */
	m68k_incpci (4);
	if (!m68k_mull(opcode, dst, extra)) goto l_230848;
	regs.irc = get_word_ce030_prefetch (0);
	do_cycles_ce020_internal (28);
}}}}l_230848: ;
return;
}

#endif
/* MULL.L #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c18_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* op H:2,T:0,C:28 */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
	/* op H:2,T:0,C:28 */
	m68k_incpci (4);
	if (!m68k_mull(opcode, dst, extra)) goto l_230849;
	regs.irc = get_word_ce030_prefetch (0);
	do_cycles_ce020_internal (28);
}}}}l_230849: ;
return;
}

#endif
/* MULL.L #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c20_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* op H:2,T:0,C:28 */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
	/* op H:2,T:0,C:28 */
	m68k_incpci (4);
	if (!m68k_mull(opcode, dst, extra)) goto l_230850;
	regs.irc = get_word_ce030_prefetch (0);
	do_cycles_ce020_internal (28);
}}}}l_230850: ;
return;
}

#endif
/* MULL.L #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c28_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* op H:2,T:0,C:28 */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s32 dst = x_get_long (dsta);
	/* op H:2,T:0,C:28 */
	m68k_incpci (6);
	if (!m68k_mull(opcode, dst, extra)) goto l_230851;
	regs.irc = get_word_ce030_prefetch (0);
	do_cycles_ce020_internal (28);
}}}}l_230851: ;
return;
}

#endif
/* MULL.L #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c30_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* op H:2,T:0,C:28 */
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
{	uae_s32 dst = x_get_long (dsta);
	/* op H:2,T:0,C:28 */
	if (!m68k_mull(opcode, dst, extra)) goto l_230852;
	regs.irc = get_word_ce030_prefetch (0);
	do_cycles_ce020_internal (28);
}}}}}l_230852: ;
return;
}

#endif
/* MULL.L #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c38_23)(uae_u32 opcode)
{
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* op H:2,T:0,C:28 */
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s32 dst = x_get_long (dsta);
	/* op H:2,T:0,C:28 */
	m68k_incpci (6);
	if (!m68k_mull(opcode, dst, extra)) goto l_230853;
	regs.irc = get_word_ce030_prefetch (0);
	do_cycles_ce020_internal (28);
}}}}l_230853: ;
return;
}

#endif
/* MULL.L #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c39_23)(uae_u32 opcode)
{
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* op H:2,T:0,C:28 */
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (4);
{	uae_s32 dst = x_get_long (dsta);
	/* op H:2,T:0,C:28 */
	m68k_incpci (8);
	if (!m68k_mull(opcode, dst, extra)) goto l_230854;
	regs.irc = get_word_ce030_prefetch (0);
	do_cycles_ce020_internal (28);
}}}}l_230854: ;
return;
}

#endif
/* MULL.L #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c3a_23)(uae_u32 opcode)
{
	uae_u32 dstreg = 2;
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* op H:2,T:0,C:28 */
{	uaecptr dsta;
	dsta = m68k_getpci () + 4;
	dsta += (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s32 dst = x_get_long (dsta);
	/* op H:2,T:0,C:28 */
	m68k_incpci (6);
	if (!m68k_mull(opcode, dst, extra)) goto l_230855;
	regs.irc = get_word_ce030_prefetch (0);
	do_cycles_ce020_internal (28);
}}}}l_230855: ;
return;
}

#endif
/* MULL.L #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c3b_23)(uae_u32 opcode)
{
	uae_u32 dstreg = 3;
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* op H:2,T:0,C:28 */
{	uaecptr tmppc;
	uaecptr dsta;
	m68k_incpci (4);
{	tmppc = m68k_getpci ();
	dsta = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s32 dst = x_get_long (dsta);
	/* op H:2,T:0,C:28 */
	if (!m68k_mull(opcode, dst, extra)) goto l_230856;
	regs.irc = get_word_ce030_prefetch (0);
	do_cycles_ce020_internal (28);
}}}}}l_230856: ;
return;
}

#endif
/* MULL.L #<data>.W,#<data>.L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c3c_23)(uae_u32 opcode)
{
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* op H:2,T:0,C:28 */
{	uae_s32 dst;
	dst = get_long_ce030_prefetch (4);
	/* op H:2,T:0,C:28 */
	m68k_incpci (8);
	if (!m68k_mull(opcode, dst, extra)) goto l_230857;
	regs.irc = get_word_ce030_prefetch (0);
	do_cycles_ce020_internal (28);
}}}l_230857: ;
return;
}

#endif
/* DIVL.L #<data>.W,Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c40_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* op H:0,T:0,C:50 */
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:0,T:0,C:50 */
	m68k_incpci (4);
	if (!m68k_divl(opcode, dst, extra)) goto l_230858;
	regs.irc = get_word_ce030_prefetch (0);
	do_cycles_ce020_internal (48);
}}}l_230858: ;
return;
}

#endif
/* DIVL.L #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c50_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* op H:0,T:0,C:50 */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = x_get_long (dsta);
	/* op H:0,T:0,C:50 */
	m68k_incpci (4);
	if (!m68k_divl(opcode, dst, extra)) goto l_230859;
	regs.irc = get_word_ce030_prefetch (0);
	do_cycles_ce020_internal (48);
}}}}l_230859: ;
return;
}

#endif
/* DIVL.L #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c58_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* op H:0,T:0,C:50 */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
	/* op H:0,T:0,C:50 */
	m68k_incpci (4);
	if (!m68k_divl(opcode, dst, extra)) goto l_230860;
	regs.irc = get_word_ce030_prefetch (0);
	do_cycles_ce020_internal (48);
}}}}l_230860: ;
return;
}

#endif
/* DIVL.L #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c60_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* op H:0,T:0,C:50 */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
	/* op H:0,T:0,C:50 */
	m68k_incpci (4);
	if (!m68k_divl(opcode, dst, extra)) goto l_230861;
	regs.irc = get_word_ce030_prefetch (0);
	do_cycles_ce020_internal (48);
}}}}l_230861: ;
return;
}

#endif
/* DIVL.L #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c68_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* op H:0,T:0,C:50 */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s32 dst = x_get_long (dsta);
	/* op H:0,T:0,C:50 */
	m68k_incpci (6);
	if (!m68k_divl(opcode, dst, extra)) goto l_230862;
	regs.irc = get_word_ce030_prefetch (0);
	do_cycles_ce020_internal (48);
}}}}l_230862: ;
return;
}

#endif
/* DIVL.L #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c70_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* op H:0,T:0,C:50 */
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
{	uae_s32 dst = x_get_long (dsta);
	/* op H:0,T:0,C:50 */
	if (!m68k_divl(opcode, dst, extra)) goto l_230863;
	regs.irc = get_word_ce030_prefetch (0);
	do_cycles_ce020_internal (48);
}}}}}l_230863: ;
return;
}

#endif
/* DIVL.L #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c78_23)(uae_u32 opcode)
{
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* op H:0,T:0,C:50 */
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s32 dst = x_get_long (dsta);
	/* op H:0,T:0,C:50 */
	m68k_incpci (6);
	if (!m68k_divl(opcode, dst, extra)) goto l_230864;
	regs.irc = get_word_ce030_prefetch (0);
	do_cycles_ce020_internal (48);
}}}}l_230864: ;
return;
}

#endif
/* DIVL.L #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c79_23)(uae_u32 opcode)
{
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* op H:0,T:0,C:50 */
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (4);
{	uae_s32 dst = x_get_long (dsta);
	/* op H:0,T:0,C:50 */
	m68k_incpci (8);
	if (!m68k_divl(opcode, dst, extra)) goto l_230865;
	regs.irc = get_word_ce030_prefetch (0);
	do_cycles_ce020_internal (48);
}}}}l_230865: ;
return;
}

#endif
/* DIVL.L #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c7a_23)(uae_u32 opcode)
{
	uae_u32 dstreg = 2;
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* op H:0,T:0,C:50 */
{	uaecptr dsta;
	dsta = m68k_getpci () + 4;
	dsta += (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
{	uae_s32 dst = x_get_long (dsta);
	/* op H:0,T:0,C:50 */
	m68k_incpci (6);
	if (!m68k_divl(opcode, dst, extra)) goto l_230866;
	regs.irc = get_word_ce030_prefetch (0);
	do_cycles_ce020_internal (48);
}}}}l_230866: ;
return;
}

#endif
/* DIVL.L #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c7b_23)(uae_u32 opcode)
{
	uae_u32 dstreg = 3;
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* op H:0,T:0,C:50 */
{	uaecptr tmppc;
	uaecptr dsta;
	m68k_incpci (4);
{	tmppc = m68k_getpci ();
	dsta = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s32 dst = x_get_long (dsta);
	/* op H:0,T:0,C:50 */
	if (!m68k_divl(opcode, dst, extra)) goto l_230867;
	regs.irc = get_word_ce030_prefetch (0);
	do_cycles_ce020_internal (48);
}}}}}l_230867: ;
return;
}

#endif
/* DIVL.L #<data>.W,#<data>.L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c7c_23)(uae_u32 opcode)
{
{{	uae_s16 extra = get_word_ce030_prefetch (2);
	/* op H:0,T:0,C:50 */
{	uae_s32 dst;
	dst = get_long_ce030_prefetch (4);
	/* op H:0,T:0,C:50 */
	m68k_incpci (8);
	if (!m68k_divl(opcode, dst, extra)) goto l_230868;
	regs.irc = get_word_ce030_prefetch (0);
	do_cycles_ce020_internal (48);
}}}l_230868: ;
return;
}

#endif
/* MVMEL.W #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_4c90_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce030_prefetch (2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg);
	do_cycles_ce020_internal (6);
{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)x_get_word (srca); srca += 2; dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)x_get_word (srca); srca += 2; amask = movem_next[amask];
	}
	regs.irc = get_word_ce030_prefetch (4);
}}}	m68k_incpci (4);
return;
}

/* MVMEL.W #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_4c98_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce030_prefetch (2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg);
	do_cycles_ce020_internal (6);
{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)x_get_word (srca); srca += 2; dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)x_get_word (srca); srca += 2; amask = movem_next[amask];
	}
	m68k_areg (regs, dstreg) = srca;
	regs.irc = get_word_ce030_prefetch (4);
}}}	m68k_incpci (4);
return;
}

/* MVMEL.W #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_4ca8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce030_prefetch (2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	do_cycles_ce020_internal (6);
{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)x_get_word (srca); srca += 2; dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)x_get_word (srca); srca += 2; amask = movem_next[amask];
	}
	regs.irc = get_word_ce030_prefetch (6);
}}}	m68k_incpci (6);
return;
}

/* MVMEL.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4cb0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce030_prefetch (2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca;
	m68k_incpci (4);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	do_cycles_ce020_internal (6);
{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)x_get_word (srca); srca += 2; dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)x_get_word (srca); srca += 2; amask = movem_next[amask];
	}
	regs.irc = get_word_ce030_prefetch (0);
}}}}return;
}

/* MVMEL.W #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_4cb8_23)(uae_u32 opcode)
{
{	uae_u16 mask = get_word_ce030_prefetch (2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	do_cycles_ce020_internal (6);
{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)x_get_word (srca); srca += 2; dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)x_get_word (srca); srca += 2; amask = movem_next[amask];
	}
	regs.irc = get_word_ce030_prefetch (6);
}}}	m68k_incpci (6);
return;
}

/* MVMEL.W #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_4cb9_23)(uae_u32 opcode)
{
{	uae_u16 mask = get_word_ce030_prefetch (2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca;
	srca = get_long_ce030_prefetch (4);
	do_cycles_ce020_internal (6);
{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)x_get_word (srca); srca += 2; dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)x_get_word (srca); srca += 2; amask = movem_next[amask];
	}
	regs.irc = get_word_ce030_prefetch (8);
}}}	m68k_incpci (8);
return;
}

/* MVMEL.W #<data>.W,(d16,PC) */
void REGPARAM2 CPUFUNC(op_4cba_23)(uae_u32 opcode)
{
	uae_u32 dstreg = 2;
{	uae_u16 mask = get_word_ce030_prefetch (2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca;
	srca = m68k_getpci () + 4;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	do_cycles_ce020_internal (6);
{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)x_get_word (srca); srca += 2; dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)x_get_word (srca); srca += 2; amask = movem_next[amask];
	}
	regs.irc = get_word_ce030_prefetch (6);
}}}	m68k_incpci (6);
return;
}

/* MVMEL.W #<data>.W,(d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_4cbb_23)(uae_u32 opcode)
{
	uae_u32 dstreg = 3;
{	uae_u16 mask = get_word_ce030_prefetch (2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (4);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
	do_cycles_ce020_internal (6);
{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)x_get_word (srca); srca += 2; dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)x_get_word (srca); srca += 2; amask = movem_next[amask];
	}
	regs.irc = get_word_ce030_prefetch (0);
}}}}return;
}

/* MVMEL.L #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_4cd0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce030_prefetch (2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg);
	do_cycles_ce020_internal (6);
{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = x_get_long (srca); srca += 4; dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = x_get_long (srca); srca += 4; amask = movem_next[amask];
	}
	regs.irc = get_word_ce030_prefetch (4);
}}}	m68k_incpci (4);
return;
}

/* MVMEL.L #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_4cd8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce030_prefetch (2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg);
	do_cycles_ce020_internal (6);
{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = x_get_long (srca); srca += 4; dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = x_get_long (srca); srca += 4; amask = movem_next[amask];
	}
	m68k_areg (regs, dstreg) = srca;
	regs.irc = get_word_ce030_prefetch (4);
}}}	m68k_incpci (4);
return;
}

/* MVMEL.L #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_4ce8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce030_prefetch (2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	do_cycles_ce020_internal (6);
{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = x_get_long (srca); srca += 4; dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = x_get_long (srca); srca += 4; amask = movem_next[amask];
	}
	regs.irc = get_word_ce030_prefetch (6);
}}}	m68k_incpci (6);
return;
}

/* MVMEL.L #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4cf0_23)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce030_prefetch (2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca;
	m68k_incpci (4);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	do_cycles_ce020_internal (6);
{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = x_get_long (srca); srca += 4; dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = x_get_long (srca); srca += 4; amask = movem_next[amask];
	}
	regs.irc = get_word_ce030_prefetch (0);
}}}}return;
}

/* MVMEL.L #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_4cf8_23)(uae_u32 opcode)
{
{	uae_u16 mask = get_word_ce030_prefetch (2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	do_cycles_ce020_internal (6);
{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = x_get_long (srca); srca += 4; dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = x_get_long (srca); srca += 4; amask = movem_next[amask];
	}
	regs.irc = get_word_ce030_prefetch (6);
}}}	m68k_incpci (6);
return;
}

/* MVMEL.L #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_4cf9_23)(uae_u32 opcode)
{
{	uae_u16 mask = get_word_ce030_prefetch (2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca;
	srca = get_long_ce030_prefetch (4);
	do_cycles_ce020_internal (6);
{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = x_get_long (srca); srca += 4; dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = x_get_long (srca); srca += 4; amask = movem_next[amask];
	}
	regs.irc = get_word_ce030_prefetch (8);
}}}	m68k_incpci (8);
return;
}

/* MVMEL.L #<data>.W,(d16,PC) */
void REGPARAM2 CPUFUNC(op_4cfa_23)(uae_u32 opcode)
{
	uae_u32 dstreg = 2;
{	uae_u16 mask = get_word_ce030_prefetch (2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca;
	srca = m68k_getpci () + 4;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (4);
	do_cycles_ce020_internal (6);
{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = x_get_long (srca); srca += 4; dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = x_get_long (srca); srca += 4; amask = movem_next[amask];
	}
	regs.irc = get_word_ce030_prefetch (6);
}}}	m68k_incpci (6);
return;
}

/* MVMEL.L #<data>.W,(d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_4cfb_23)(uae_u32 opcode)
{
	uae_u32 dstreg = 3;
{	uae_u16 mask = get_word_ce030_prefetch (2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (4);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
	do_cycles_ce020_internal (6);
{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = x_get_long (srca); srca += 4; dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = x_get_long (srca); srca += 4; amask = movem_next[amask];
	}
	regs.irc = get_word_ce030_prefetch (0);
}}}}return;
}

/* TRAPQ.L #<data> */
void REGPARAM2 CPUFUNC(op_4e40_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 15);
{{	uae_u32 src = srcreg;
	/* OP zero */
	m68k_incpci (2);
	Exception (src + 32);
}}return;
}

/* LINK.W An,#<data>.W */
void REGPARAM2 CPUFUNC(op_4e50_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* op H:0,T:0,C:4 */
{	uaecptr olda;
	olda = m68k_areg (regs, 7) - 4;
	m68k_areg (regs, 7) = olda;
{	uae_s32 src = m68k_areg (regs, srcreg);
{	uae_s16 offs = get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	do_cycles_ce020_internal (2);
	x_put_long (olda, src);
	m68k_areg (regs, srcreg) = (m68k_areg (regs, 7));
	m68k_areg (regs, 7) += offs;
}}}}	m68k_incpci (4);
return;
}

/* UNLK.L An */
void REGPARAM2 CPUFUNC(op_4e58_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_areg (regs, srcreg);
	/* op H:0,T:0,C:5 */
	m68k_areg (regs, 7) = src;
{	uaecptr olda;
	olda = m68k_areg (regs, 7);
{	uae_s32 old = x_get_long (olda);
	m68k_areg (regs, 7) += 4;
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (3);
	m68k_areg (regs, srcreg) = (old);
}}}}	m68k_incpci (2);
return;
}

/* MVR2USP.L An */
void REGPARAM2 CPUFUNC(op_4e60_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_230888; }
{{	uae_s32 src = m68k_areg (regs, srcreg);
	/* op H:4,T:0,C:0 */
	regs.usp = src;
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (2);
}}}	m68k_incpci (2);
l_230888: ;
return;
}

/* MVUSP2R.L An */
void REGPARAM2 CPUFUNC(op_4e68_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_230889; }
{{	/* op H:4,T:0,C:0 */
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (2);
	m68k_areg (regs, srcreg) = (regs.usp);
}}}	m68k_incpci (2);
l_230889: ;
return;
}

/* RESET.L  */
void REGPARAM2 CPUFUNC(op_4e70_23)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_230890; }
{	cpureset ();
	m68k_incpci (2);
	regs.irc = get_word_ce030_prefetch (0);
}}l_230890: ;
return;
}

/* NOP.L  */
void REGPARAM2 CPUFUNC(op_4e71_23)(uae_u32 opcode)
{
{	regs.irc = get_word_ce030_prefetch (2);
}	m68k_incpci (2);
return;
}

/* STOP.L #<data>.W */
void REGPARAM2 CPUFUNC(op_4e72_23)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_230892; }
{{	uae_s16 src = get_word_ce030_prefetch (2);
	/* op H:0,T:0,C:8 */
	regs.sr = src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	m68k_setstopped ();
	m68k_incpci (4);
	do_cycles_ce020_internal (6);
}}}l_230892: ;
return;
}

/* RTE.L  */
void REGPARAM2 CPUFUNC(op_4e73_23)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_230893; }
{	/* op H:1,T:9,C:8 */
	uae_u16 newsr; uae_u32 newpc;
	for (;;) {
		uaecptr a = m68k_areg (regs, 7);
		uae_u16 sr = x_get_word (a);
		uae_u32 pc = x_get_long (a + 2);
		uae_u16 format = x_get_word (a + 2 + 4);
		int frame = format >> 12;
		int offset = 8;
		newsr = sr; newpc = pc;
	do_cycles_ce020_internal (6);
		if (frame == 0x0) { m68k_areg (regs, 7) += offset; break; }
		else if (frame == 0x1) { m68k_areg (regs, 7) += offset; }
		else if (frame == 0x2) { m68k_areg (regs, 7) += offset + 4; break; }
		else if (frame == 0x4) { m68k_areg (regs, 7) += offset + 8; break; }
		else if (frame == 0x8) { m68k_areg (regs, 7) += offset + 50; break; }
		else if (frame == 0x7) { m68k_areg (regs, 7) += offset + 52; break; }
		else if (frame == 0x9) { m68k_areg (regs, 7) += offset + 12; break; }
		else if (frame == 0xa) { m68k_areg (regs, 7) += offset + 24; break; }
		else if (frame == 0xb) { m68k_areg (regs, 7) += offset + 84; break; }
		else { m68k_areg (regs, 7) += offset; Exception (14); goto l_230893; }
		regs.sr = newsr;
	MakeFromSR();
	regs.ipl_pin = intlev ();
}
	regs.sr = newsr;
	do_cycles_ce020_internal (4);
	MakeFromSR();
	regs.ipl_pin = intlev ();
	if (newpc & 1) {
		exception3i (0x4E73, newpc);
		goto l_230893;
	}
	m68k_setpci (newpc);
	ipl_fetch ();
	fill_prefetch_030 ();
}}l_230893: ;
return;
}

/* RTD.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4e74_23)(uae_u32 opcode)
{
{	/* op H:2,T:0,C:8 */
{	uaecptr pca;
	pca = m68k_areg (regs, 7);
{	uae_s32 pc = x_get_long (pca);
	m68k_areg (regs, 7) += 4;
{	uae_s16 offs = get_word_ce030_prefetch (2);
	/* op H:2,T:0,C:8 */
	m68k_areg (regs, 7) += offs;
	if (pc & 1) {
		exception3i (0x4E74, pc);
		goto l_230894;
	}
	m68k_setpci (pc);
	fill_prefetch_030 ();
}}}}l_230894: ;
return;
}

#endif
/* RTS.L  */
void REGPARAM2 CPUFUNC(op_4e75_23)(uae_u32 opcode)
{
{	/* op H:1,T:0,C:8 */
	uaecptr pc = m68k_getpci ();
	m68k_do_rts_ce030 ();
	if (m68k_getpci () & 1) {
		uaecptr faultpc = m68k_getpci ();
	m68k_setpci (pc);
		exception3i (0x4E75, faultpc);
		goto l_230895;
	}
	do_cycles_ce020_internal (3);
	fill_prefetch_030 ();
}l_230895: ;
return;
}

/* TRAPV.L  */
void REGPARAM2 CPUFUNC(op_4e76_23)(uae_u32 opcode)
{
{	m68k_incpci (2);
	if (GET_VFLG ()) {
		Exception (7);
		goto l_230896;
	}
	regs.irc = get_word_ce030_prefetch (0);
}l_230896: ;
return;
}

/* RTR.L  */
void REGPARAM2 CPUFUNC(op_4e77_23)(uae_u32 opcode)
{
{	uaecptr oldpc = m68k_getpci ();
	MakeSR ();
{	uaecptr sra;
	sra = m68k_areg (regs, 7);
{	uae_s16 sr = x_get_word (sra);
	m68k_areg (regs, 7) += 2;
{	uaecptr pca;
	pca = m68k_areg (regs, 7);
{	uae_s32 pc = x_get_long (pca);
	m68k_areg (regs, 7) += 4;
	regs.sr &= 0xFF00; sr &= 0xFF;
	regs.sr |= sr;
	m68k_setpci (pc);
	MakeFromSR();
	regs.ipl_pin = intlev ();
	if (m68k_getpci () & 1) {
		uaecptr faultpc = m68k_getpci ();
	m68k_setpci (oldpc);
		exception3i (0x4E77, faultpc);
		goto l_230897;
	}
	fill_prefetch_030 ();
}}}}}l_230897: ;
return;
}

/* MOVEC2.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4e7a_23)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_230898; }
{{	uae_s16 src = get_word_ce030_prefetch (2);
	/* op H:6,T:0,C:0 */
{	int regno = (src >> 12) & 15;
	uae_u32 *regp = regs.regs + regno;
	if (! m68k_movec2(src & 0xFFF, regp)) goto l_230898;
	regs.irc = get_word_ce030_prefetch (4);
	do_cycles_ce020_internal (4);
}}}}	m68k_incpci (4);
l_230898: ;
return;
}

#endif
/* MOVE2C.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4e7b_23)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_230899; }
{{	uae_s16 src = get_word_ce030_prefetch (2);
	/* op H:6,T:0,C:0 */
{	int regno = (src >> 12) & 15;
	uae_u32 *regp = regs.regs + regno;
	if (! m68k_move2c(src & 0xFFF, regp)) goto l_230899;
	regs.irc = get_word_ce030_prefetch (4);
	do_cycles_ce020_internal (4);
}}}}	m68k_incpci (4);
l_230899: ;
return;
}

#endif
/* JSR.L (An) */
void REGPARAM2 CPUFUNC(op_4e90_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 jea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uaecptr oldpc = m68k_getpci () + 2;
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_230900;
	}
	m68k_setpci (srca);
	m68k_areg (regs, 7) -= 4;
	x_put_long (m68k_areg (regs, 7), oldpc);
	fill_prefetch_030 ();
}}}l_230900: ;
return;
}

/* JSR.L (d16,An) */
void REGPARAM2 CPUFUNC(op_4ea8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 jea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uaecptr oldpc = m68k_getpci () + 4;
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_230901;
	}
	m68k_setpci (srca);
	m68k_areg (regs, 7) -= 4;
	x_put_long (m68k_areg (regs, 7), oldpc);
	fill_prefetch_030 ();
}}}l_230901: ;
return;
}

/* JSR.L (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4eb0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:0 jea */
	regs.ce020memcycles = 0;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uaecptr oldpc = m68k_getpci () + 0;
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_230902;
	}
	m68k_setpci (srca);
	m68k_areg (regs, 7) -= 4;
	x_put_long (m68k_areg (regs, 7), oldpc);
	fill_prefetch_030 ();
}}}}l_230902: ;
return;
}

/* JSR.L (xxx).W */
void REGPARAM2 CPUFUNC(op_4eb8_23)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 jea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uaecptr oldpc = m68k_getpci () + 4;
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_230903;
	}
	m68k_setpci (srca);
	m68k_areg (regs, 7) -= 4;
	x_put_long (m68k_areg (regs, 7), oldpc);
	fill_prefetch_030 ();
}}}l_230903: ;
return;
}

/* JSR.L (xxx).L */
void REGPARAM2 CPUFUNC(op_4eb9_23)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 jea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uaecptr oldpc = m68k_getpci () + 6;
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_230904;
	}
	m68k_setpci (srca);
	m68k_areg (regs, 7) -= 4;
	x_put_long (m68k_areg (regs, 7), oldpc);
	fill_prefetch_030 ();
}}}l_230904: ;
return;
}

/* JSR.L (d16,PC) */
void REGPARAM2 CPUFUNC(op_4eba_23)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 jea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uaecptr oldpc = m68k_getpci () + 4;
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_230905;
	}
	m68k_setpci (srca);
	m68k_areg (regs, 7) -= 4;
	x_put_long (m68k_areg (regs, 7), oldpc);
	fill_prefetch_030 ();
}}}l_230905: ;
return;
}

/* JSR.L (d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_4ebb_23)(uae_u32 opcode)
{
{	/* ea H:0,T:0,C:0 jea */
	regs.ce020memcycles = 0;
{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uaecptr oldpc = m68k_getpci () + 0;
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_230906;
	}
	m68k_setpci (srca);
	m68k_areg (regs, 7) -= 4;
	x_put_long (m68k_areg (regs, 7), oldpc);
	fill_prefetch_030 ();
}}}}l_230906: ;
return;
}

/* JMP.L (An) */
void REGPARAM2 CPUFUNC(op_4ed0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2+4=6,T:0,C:0 jea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	/* op H:4-,T:0,C:0 */
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_230907;
	}
	m68k_setpci (srca);
	fill_prefetch_030 ();
}}l_230907: ;
return;
}

/* JMP.L (d16,An) */
void REGPARAM2 CPUFUNC(op_4ee8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4+4=8,T:0,C:0 jea */
	if (regs.ce020memcycles > 8 * cpucycleunit)
		regs.ce020memcycles = 8 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	/* op H:4-,T:0,C:0 */
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_230908;
	}
	m68k_setpci (srca);
	fill_prefetch_030 ();
}}l_230908: ;
return;
}

/* JMP.L (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4ef0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:0 jea */
	regs.ce020memcycles = 0;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:0 */
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_230909;
	}
	m68k_setpci (srca);
	fill_prefetch_030 ();
}}}l_230909: ;
return;
}

/* JMP.L (xxx).W */
void REGPARAM2 CPUFUNC(op_4ef8_23)(uae_u32 opcode)
{
{	/* ea H:2+4=6,T:0,C:0 jea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	/* op H:4-,T:0,C:0 */
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_230910;
	}
	m68k_setpci (srca);
	fill_prefetch_030 ();
}}l_230910: ;
return;
}

/* JMP.L (xxx).L */
void REGPARAM2 CPUFUNC(op_4ef9_23)(uae_u32 opcode)
{
{	/* ea H:2+4=6,T:0,C:0 jea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
	/* op H:4-,T:0,C:0 */
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_230911;
	}
	m68k_setpci (srca);
	fill_prefetch_030 ();
}}l_230911: ;
return;
}

/* JMP.L (d16,PC) */
void REGPARAM2 CPUFUNC(op_4efa_23)(uae_u32 opcode)
{
{	/* ea H:4+4=8,T:0,C:0 jea */
	if (regs.ce020memcycles > 8 * cpucycleunit)
		regs.ce020memcycles = 8 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	/* op H:4-,T:0,C:0 */
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_230912;
	}
	m68k_setpci (srca);
	fill_prefetch_030 ();
}}l_230912: ;
return;
}

/* JMP.L (d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_4efb_23)(uae_u32 opcode)
{
{	/* ea H:0,T:0,C:0 jea */
	regs.ce020memcycles = 0;
{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:0 */
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_230913;
	}
	m68k_setpci (srca);
	fill_prefetch_030 ();
}}}l_230913: ;
return;
}

/* ADDQ.B #<data>,Dn */
void REGPARAM2 CPUFUNC(op_5000_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_u32 src = srcreg;
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpci (2);
return;
}

/* ADDQ.B #<data>,(An) */
void REGPARAM2 CPUFUNC(op_5010_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* ADDQ.B #<data>,(An)+ */
void REGPARAM2 CPUFUNC(op_5018_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* ADDQ.B #<data>,-(An) */
void REGPARAM2 CPUFUNC(op_5020_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* ADDQ.B #<data>,(d16,An) */
void REGPARAM2 CPUFUNC(op_5028_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* ADDQ.B #<data>,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_5030_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}}return;
}

/* ADDQ.B #<data>,(xxx).W */
void REGPARAM2 CPUFUNC(op_5038_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* ADDQ.B #<data>,(xxx).L */
void REGPARAM2 CPUFUNC(op_5039_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* ADDQ.W #<data>,Dn */
void REGPARAM2 CPUFUNC(op_5040_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_u32 src = srcreg;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpci (2);
return;
}

/* ADDAQ.W #<data>,An */
void REGPARAM2 CPUFUNC(op_5048_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{	uae_u32 newv = dst + src;
	regs.irc = get_word_ce030_prefetch (2);
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return;
}

/* ADDQ.W #<data>,(An) */
void REGPARAM2 CPUFUNC(op_5050_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* ADDQ.W #<data>,(An)+ */
void REGPARAM2 CPUFUNC(op_5058_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* ADDQ.W #<data>,-(An) */
void REGPARAM2 CPUFUNC(op_5060_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* ADDQ.W #<data>,(d16,An) */
void REGPARAM2 CPUFUNC(op_5068_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* ADDQ.W #<data>,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_5070_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}}return;
}

/* ADDQ.W #<data>,(xxx).W */
void REGPARAM2 CPUFUNC(op_5078_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* ADDQ.W #<data>,(xxx).L */
void REGPARAM2 CPUFUNC(op_5079_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* ADDQ.L #<data>,Dn */
void REGPARAM2 CPUFUNC(op_5080_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
return;
}

/* ADDAQ.L #<data>,An */
void REGPARAM2 CPUFUNC(op_5088_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{	uae_u32 newv = dst + src;
	regs.irc = get_word_ce030_prefetch (2);
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return;
}

/* ADDQ.L #<data>,(An) */
void REGPARAM2 CPUFUNC(op_5090_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* ADDQ.L #<data>,(An)+ */
void REGPARAM2 CPUFUNC(op_5098_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* ADDQ.L #<data>,-(An) */
void REGPARAM2 CPUFUNC(op_50a0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

#endif

#ifdef PART_5
/* ADDQ.L #<data>,(d16,An) */
void REGPARAM2 CPUFUNC(op_50a8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* ADDQ.L #<data>,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_50b0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}}return;
}

/* ADDQ.L #<data>,(xxx).W */
void REGPARAM2 CPUFUNC(op_50b8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* ADDQ.L #<data>,(xxx).L */
void REGPARAM2 CPUFUNC(op_50b9_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* Scc.B Dn (T) */
void REGPARAM2 CPUFUNC(op_50c0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	/* op H:0,T:0,C:2 */
{{	int val = cctrue (0) ? 0xff : 0;
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* DBcc.W Dn,#<data>.W (T) */
void REGPARAM2 CPUFUNC(op_50c8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_word_ce030_prefetch (2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (0)) {
	m68k_incpci ((uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_230941;
			}
	fill_prefetch_030 ();
			return;
		}
	} else {
	}
	m68k_setpci (oldpc + 4);
	continue_ce020_prefetch();
}}}l_230941: ;
return;
}

/* Scc.B (An) (T) */
void REGPARAM2 CPUFUNC(op_50d0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (0) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (An)+ (T) */
void REGPARAM2 CPUFUNC(op_50d8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (0) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B -(An) (T) */
void REGPARAM2 CPUFUNC(op_50e0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (0) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (d16,An) (T) */
void REGPARAM2 CPUFUNC(op_50e8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (0) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (d8,An,Xn) (T) */
void REGPARAM2 CPUFUNC(op_50f0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (0) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}}return;
}

/* Scc.B (xxx).W (T) */
void REGPARAM2 CPUFUNC(op_50f8_23)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (0) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (xxx).L (T) */
void REGPARAM2 CPUFUNC(op_50f9_23)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (0) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
}

/* TRAPcc.L #<data>.W (T) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_50fa_23)(uae_u32 opcode)
{
{{	uae_s16 dummy = get_word_ce030_prefetch (2);
	/* OP zero */
	if (cctrue (0)) { Exception (7); goto l_230949; }
	regs.irc = get_word_ce030_prefetch (4);
}}	m68k_incpci (4);
l_230949: ;
return;
}

#endif
/* TRAPcc.L #<data>.L (T) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_50fb_23)(uae_u32 opcode)
{
{{	uae_s32 dummy;
	dummy = get_long_ce030_prefetch (2);
	/* OP zero */
	if (cctrue (0)) { Exception (7); goto l_230950; }
	regs.irc = get_word_ce030_prefetch (6);
}}	m68k_incpci (6);
l_230950: ;
return;
}

#endif
/* TRAPcc.L  (T) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_50fc_23)(uae_u32 opcode)
{
{	if (cctrue (0)) { Exception (7); goto l_230951; }
	regs.irc = get_word_ce030_prefetch (2);
}	m68k_incpci (2);
l_230951: ;
return;
}

#endif
/* SUBQ.B #<data>,Dn */
void REGPARAM2 CPUFUNC(op_5100_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_u32 src = srcreg;
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpci (2);
return;
}

/* SUBQ.B #<data>,(An) */
void REGPARAM2 CPUFUNC(op_5110_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUBQ.B #<data>,(An)+ */
void REGPARAM2 CPUFUNC(op_5118_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUBQ.B #<data>,-(An) */
void REGPARAM2 CPUFUNC(op_5120_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUBQ.B #<data>,(d16,An) */
void REGPARAM2 CPUFUNC(op_5128_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUBQ.B #<data>,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_5130_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}}return;
}

/* SUBQ.B #<data>,(xxx).W */
void REGPARAM2 CPUFUNC(op_5138_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUBQ.B #<data>,(xxx).L */
void REGPARAM2 CPUFUNC(op_5139_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* SUBQ.W #<data>,Dn */
void REGPARAM2 CPUFUNC(op_5140_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_u32 src = srcreg;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpci (2);
return;
}

/* SUBAQ.W #<data>,An */
void REGPARAM2 CPUFUNC(op_5148_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{	uae_u32 newv = dst - src;
	regs.irc = get_word_ce030_prefetch (2);
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return;
}

/* SUBQ.W #<data>,(An) */
void REGPARAM2 CPUFUNC(op_5150_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUBQ.W #<data>,(An)+ */
void REGPARAM2 CPUFUNC(op_5158_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUBQ.W #<data>,-(An) */
void REGPARAM2 CPUFUNC(op_5160_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUBQ.W #<data>,(d16,An) */
void REGPARAM2 CPUFUNC(op_5168_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUBQ.W #<data>,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_5170_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}}return;
}

/* SUBQ.W #<data>,(xxx).W */
void REGPARAM2 CPUFUNC(op_5178_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUBQ.W #<data>,(xxx).L */
void REGPARAM2 CPUFUNC(op_5179_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* SUBQ.L #<data>,Dn */
void REGPARAM2 CPUFUNC(op_5180_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
return;
}

/* SUBAQ.L #<data>,An */
void REGPARAM2 CPUFUNC(op_5188_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{	uae_u32 newv = dst - src;
	regs.irc = get_word_ce030_prefetch (2);
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return;
}

/* SUBQ.L #<data>,(An) */
void REGPARAM2 CPUFUNC(op_5190_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUBQ.L #<data>,(An)+ */
void REGPARAM2 CPUFUNC(op_5198_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUBQ.L #<data>,-(An) */
void REGPARAM2 CPUFUNC(op_51a0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUBQ.L #<data>,(d16,An) */
void REGPARAM2 CPUFUNC(op_51a8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUBQ.L #<data>,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_51b0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}}return;
}

/* SUBQ.L #<data>,(xxx).W */
void REGPARAM2 CPUFUNC(op_51b8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUBQ.L #<data>,(xxx).L */
void REGPARAM2 CPUFUNC(op_51b9_23)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* Scc.B Dn (F) */
void REGPARAM2 CPUFUNC(op_51c0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	/* op H:0,T:0,C:2 */
{{	int val = cctrue (1) ? 0xff : 0;
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* DBcc.W Dn,#<data>.W (F) */
void REGPARAM2 CPUFUNC(op_51c8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_word_ce030_prefetch (2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (1)) {
	m68k_incpci ((uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_230979;
			}
	fill_prefetch_030 ();
			return;
		}
	} else {
	}
	m68k_setpci (oldpc + 4);
	continue_ce020_prefetch();
}}}l_230979: ;
return;
}

/* Scc.B (An) (F) */
void REGPARAM2 CPUFUNC(op_51d0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (1) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (An)+ (F) */
void REGPARAM2 CPUFUNC(op_51d8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (1) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B -(An) (F) */
void REGPARAM2 CPUFUNC(op_51e0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (1) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (d16,An) (F) */
void REGPARAM2 CPUFUNC(op_51e8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (1) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (d8,An,Xn) (F) */
void REGPARAM2 CPUFUNC(op_51f0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (1) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}}return;
}

/* Scc.B (xxx).W (F) */
void REGPARAM2 CPUFUNC(op_51f8_23)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (1) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (xxx).L (F) */
void REGPARAM2 CPUFUNC(op_51f9_23)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (1) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
}

/* TRAPcc.L #<data>.W (F) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_51fa_23)(uae_u32 opcode)
{
{{	uae_s16 dummy = get_word_ce030_prefetch (2);
	/* OP zero */
	if (cctrue (1)) { Exception (7); goto l_230987; }
	regs.irc = get_word_ce030_prefetch (4);
}}	m68k_incpci (4);
l_230987: ;
return;
}

#endif
/* TRAPcc.L #<data>.L (F) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_51fb_23)(uae_u32 opcode)
{
{{	uae_s32 dummy;
	dummy = get_long_ce030_prefetch (2);
	/* OP zero */
	if (cctrue (1)) { Exception (7); goto l_230988; }
	regs.irc = get_word_ce030_prefetch (6);
}}	m68k_incpci (6);
l_230988: ;
return;
}

#endif
/* TRAPcc.L  (F) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_51fc_23)(uae_u32 opcode)
{
{	if (cctrue (1)) { Exception (7); goto l_230989; }
	regs.irc = get_word_ce030_prefetch (2);
}	m68k_incpci (2);
l_230989: ;
return;
}

#endif
/* Scc.B Dn (HI) */
void REGPARAM2 CPUFUNC(op_52c0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	/* op H:0,T:0,C:2 */
{{	int val = cctrue (2) ? 0xff : 0;
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* DBcc.W Dn,#<data>.W (HI) */
void REGPARAM2 CPUFUNC(op_52c8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_word_ce030_prefetch (2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (2)) {
	m68k_incpci ((uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_230991;
			}
	fill_prefetch_030 ();
			return;
		}
	} else {
	}
	m68k_setpci (oldpc + 4);
	continue_ce020_prefetch();
}}}l_230991: ;
return;
}

/* Scc.B (An) (HI) */
void REGPARAM2 CPUFUNC(op_52d0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (2) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (An)+ (HI) */
void REGPARAM2 CPUFUNC(op_52d8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (2) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B -(An) (HI) */
void REGPARAM2 CPUFUNC(op_52e0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (2) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (d16,An) (HI) */
void REGPARAM2 CPUFUNC(op_52e8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (2) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (d8,An,Xn) (HI) */
void REGPARAM2 CPUFUNC(op_52f0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (2) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}}return;
}

/* Scc.B (xxx).W (HI) */
void REGPARAM2 CPUFUNC(op_52f8_23)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (2) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (xxx).L (HI) */
void REGPARAM2 CPUFUNC(op_52f9_23)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (2) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
}

/* TRAPcc.L #<data>.W (HI) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_52fa_23)(uae_u32 opcode)
{
{{	uae_s16 dummy = get_word_ce030_prefetch (2);
	/* OP zero */
	if (cctrue (2)) { Exception (7); goto l_230999; }
	regs.irc = get_word_ce030_prefetch (4);
}}	m68k_incpci (4);
l_230999: ;
return;
}

#endif
/* TRAPcc.L #<data>.L (HI) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_52fb_23)(uae_u32 opcode)
{
{{	uae_s32 dummy;
	dummy = get_long_ce030_prefetch (2);
	/* OP zero */
	if (cctrue (2)) { Exception (7); goto l_231000; }
	regs.irc = get_word_ce030_prefetch (6);
}}	m68k_incpci (6);
l_231000: ;
return;
}

#endif
/* TRAPcc.L  (HI) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_52fc_23)(uae_u32 opcode)
{
{	if (cctrue (2)) { Exception (7); goto l_231001; }
	regs.irc = get_word_ce030_prefetch (2);
}	m68k_incpci (2);
l_231001: ;
return;
}

#endif
/* Scc.B Dn (LS) */
void REGPARAM2 CPUFUNC(op_53c0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	/* op H:0,T:0,C:2 */
{{	int val = cctrue (3) ? 0xff : 0;
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* DBcc.W Dn,#<data>.W (LS) */
void REGPARAM2 CPUFUNC(op_53c8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_word_ce030_prefetch (2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (3)) {
	m68k_incpci ((uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_231003;
			}
	fill_prefetch_030 ();
			return;
		}
	} else {
	}
	m68k_setpci (oldpc + 4);
	continue_ce020_prefetch();
}}}l_231003: ;
return;
}

/* Scc.B (An) (LS) */
void REGPARAM2 CPUFUNC(op_53d0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (3) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (An)+ (LS) */
void REGPARAM2 CPUFUNC(op_53d8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (3) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B -(An) (LS) */
void REGPARAM2 CPUFUNC(op_53e0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (3) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (d16,An) (LS) */
void REGPARAM2 CPUFUNC(op_53e8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (3) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (d8,An,Xn) (LS) */
void REGPARAM2 CPUFUNC(op_53f0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (3) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}}return;
}

/* Scc.B (xxx).W (LS) */
void REGPARAM2 CPUFUNC(op_53f8_23)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (3) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (xxx).L (LS) */
void REGPARAM2 CPUFUNC(op_53f9_23)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (3) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
}

/* TRAPcc.L #<data>.W (LS) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_53fa_23)(uae_u32 opcode)
{
{{	uae_s16 dummy = get_word_ce030_prefetch (2);
	/* OP zero */
	if (cctrue (3)) { Exception (7); goto l_231011; }
	regs.irc = get_word_ce030_prefetch (4);
}}	m68k_incpci (4);
l_231011: ;
return;
}

#endif
/* TRAPcc.L #<data>.L (LS) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_53fb_23)(uae_u32 opcode)
{
{{	uae_s32 dummy;
	dummy = get_long_ce030_prefetch (2);
	/* OP zero */
	if (cctrue (3)) { Exception (7); goto l_231012; }
	regs.irc = get_word_ce030_prefetch (6);
}}	m68k_incpci (6);
l_231012: ;
return;
}

#endif
/* TRAPcc.L  (LS) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_53fc_23)(uae_u32 opcode)
{
{	if (cctrue (3)) { Exception (7); goto l_231013; }
	regs.irc = get_word_ce030_prefetch (2);
}	m68k_incpci (2);
l_231013: ;
return;
}

#endif
/* Scc.B Dn (CC) */
void REGPARAM2 CPUFUNC(op_54c0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	/* op H:0,T:0,C:2 */
{{	int val = cctrue (4) ? 0xff : 0;
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* DBcc.W Dn,#<data>.W (CC) */
void REGPARAM2 CPUFUNC(op_54c8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_word_ce030_prefetch (2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (4)) {
	m68k_incpci ((uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_231015;
			}
	fill_prefetch_030 ();
			return;
		}
	} else {
	}
	m68k_setpci (oldpc + 4);
	continue_ce020_prefetch();
}}}l_231015: ;
return;
}

/* Scc.B (An) (CC) */
void REGPARAM2 CPUFUNC(op_54d0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (4) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (An)+ (CC) */
void REGPARAM2 CPUFUNC(op_54d8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (4) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B -(An) (CC) */
void REGPARAM2 CPUFUNC(op_54e0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (4) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (d16,An) (CC) */
void REGPARAM2 CPUFUNC(op_54e8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (4) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (d8,An,Xn) (CC) */
void REGPARAM2 CPUFUNC(op_54f0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (4) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}}return;
}

/* Scc.B (xxx).W (CC) */
void REGPARAM2 CPUFUNC(op_54f8_23)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (4) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (xxx).L (CC) */
void REGPARAM2 CPUFUNC(op_54f9_23)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (4) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
}

/* TRAPcc.L #<data>.W (CC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_54fa_23)(uae_u32 opcode)
{
{{	uae_s16 dummy = get_word_ce030_prefetch (2);
	/* OP zero */
	if (cctrue (4)) { Exception (7); goto l_231023; }
	regs.irc = get_word_ce030_prefetch (4);
}}	m68k_incpci (4);
l_231023: ;
return;
}

#endif
/* TRAPcc.L #<data>.L (CC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_54fb_23)(uae_u32 opcode)
{
{{	uae_s32 dummy;
	dummy = get_long_ce030_prefetch (2);
	/* OP zero */
	if (cctrue (4)) { Exception (7); goto l_231024; }
	regs.irc = get_word_ce030_prefetch (6);
}}	m68k_incpci (6);
l_231024: ;
return;
}

#endif
/* TRAPcc.L  (CC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_54fc_23)(uae_u32 opcode)
{
{	if (cctrue (4)) { Exception (7); goto l_231025; }
	regs.irc = get_word_ce030_prefetch (2);
}	m68k_incpci (2);
l_231025: ;
return;
}

#endif
/* Scc.B Dn (CS) */
void REGPARAM2 CPUFUNC(op_55c0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	/* op H:0,T:0,C:2 */
{{	int val = cctrue (5) ? 0xff : 0;
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* DBcc.W Dn,#<data>.W (CS) */
void REGPARAM2 CPUFUNC(op_55c8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_word_ce030_prefetch (2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (5)) {
	m68k_incpci ((uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_231027;
			}
	fill_prefetch_030 ();
			return;
		}
	} else {
	}
	m68k_setpci (oldpc + 4);
	continue_ce020_prefetch();
}}}l_231027: ;
return;
}

/* Scc.B (An) (CS) */
void REGPARAM2 CPUFUNC(op_55d0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (5) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (An)+ (CS) */
void REGPARAM2 CPUFUNC(op_55d8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (5) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B -(An) (CS) */
void REGPARAM2 CPUFUNC(op_55e0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (5) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (d16,An) (CS) */
void REGPARAM2 CPUFUNC(op_55e8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (5) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (d8,An,Xn) (CS) */
void REGPARAM2 CPUFUNC(op_55f0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (5) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}}return;
}

/* Scc.B (xxx).W (CS) */
void REGPARAM2 CPUFUNC(op_55f8_23)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (5) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (xxx).L (CS) */
void REGPARAM2 CPUFUNC(op_55f9_23)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (5) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
}

/* TRAPcc.L #<data>.W (CS) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_55fa_23)(uae_u32 opcode)
{
{{	uae_s16 dummy = get_word_ce030_prefetch (2);
	/* OP zero */
	if (cctrue (5)) { Exception (7); goto l_231035; }
	regs.irc = get_word_ce030_prefetch (4);
}}	m68k_incpci (4);
l_231035: ;
return;
}

#endif
/* TRAPcc.L #<data>.L (CS) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_55fb_23)(uae_u32 opcode)
{
{{	uae_s32 dummy;
	dummy = get_long_ce030_prefetch (2);
	/* OP zero */
	if (cctrue (5)) { Exception (7); goto l_231036; }
	regs.irc = get_word_ce030_prefetch (6);
}}	m68k_incpci (6);
l_231036: ;
return;
}

#endif
/* TRAPcc.L  (CS) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_55fc_23)(uae_u32 opcode)
{
{	if (cctrue (5)) { Exception (7); goto l_231037; }
	regs.irc = get_word_ce030_prefetch (2);
}	m68k_incpci (2);
l_231037: ;
return;
}

#endif
/* Scc.B Dn (NE) */
void REGPARAM2 CPUFUNC(op_56c0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	/* op H:0,T:0,C:2 */
{{	int val = cctrue (6) ? 0xff : 0;
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* DBcc.W Dn,#<data>.W (NE) */
void REGPARAM2 CPUFUNC(op_56c8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_word_ce030_prefetch (2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (6)) {
	m68k_incpci ((uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_231039;
			}
	fill_prefetch_030 ();
			return;
		}
	} else {
	}
	m68k_setpci (oldpc + 4);
	continue_ce020_prefetch();
}}}l_231039: ;
return;
}

/* Scc.B (An) (NE) */
void REGPARAM2 CPUFUNC(op_56d0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (6) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (An)+ (NE) */
void REGPARAM2 CPUFUNC(op_56d8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (6) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B -(An) (NE) */
void REGPARAM2 CPUFUNC(op_56e0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (6) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (d16,An) (NE) */
void REGPARAM2 CPUFUNC(op_56e8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (6) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (d8,An,Xn) (NE) */
void REGPARAM2 CPUFUNC(op_56f0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (6) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}}return;
}

/* Scc.B (xxx).W (NE) */
void REGPARAM2 CPUFUNC(op_56f8_23)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (6) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (xxx).L (NE) */
void REGPARAM2 CPUFUNC(op_56f9_23)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (6) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
}

/* TRAPcc.L #<data>.W (NE) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_56fa_23)(uae_u32 opcode)
{
{{	uae_s16 dummy = get_word_ce030_prefetch (2);
	/* OP zero */
	if (cctrue (6)) { Exception (7); goto l_231047; }
	regs.irc = get_word_ce030_prefetch (4);
}}	m68k_incpci (4);
l_231047: ;
return;
}

#endif
/* TRAPcc.L #<data>.L (NE) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_56fb_23)(uae_u32 opcode)
{
{{	uae_s32 dummy;
	dummy = get_long_ce030_prefetch (2);
	/* OP zero */
	if (cctrue (6)) { Exception (7); goto l_231048; }
	regs.irc = get_word_ce030_prefetch (6);
}}	m68k_incpci (6);
l_231048: ;
return;
}

#endif
/* TRAPcc.L  (NE) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_56fc_23)(uae_u32 opcode)
{
{	if (cctrue (6)) { Exception (7); goto l_231049; }
	regs.irc = get_word_ce030_prefetch (2);
}	m68k_incpci (2);
l_231049: ;
return;
}

#endif
/* Scc.B Dn (EQ) */
void REGPARAM2 CPUFUNC(op_57c0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	/* op H:0,T:0,C:2 */
{{	int val = cctrue (7) ? 0xff : 0;
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* DBcc.W Dn,#<data>.W (EQ) */
void REGPARAM2 CPUFUNC(op_57c8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_word_ce030_prefetch (2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (7)) {
	m68k_incpci ((uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_231051;
			}
	fill_prefetch_030 ();
			return;
		}
	} else {
	}
	m68k_setpci (oldpc + 4);
	continue_ce020_prefetch();
}}}l_231051: ;
return;
}

/* Scc.B (An) (EQ) */
void REGPARAM2 CPUFUNC(op_57d0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (7) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (An)+ (EQ) */
void REGPARAM2 CPUFUNC(op_57d8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (7) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B -(An) (EQ) */
void REGPARAM2 CPUFUNC(op_57e0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (7) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (d16,An) (EQ) */
void REGPARAM2 CPUFUNC(op_57e8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (7) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (d8,An,Xn) (EQ) */
void REGPARAM2 CPUFUNC(op_57f0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (7) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}}return;
}

/* Scc.B (xxx).W (EQ) */
void REGPARAM2 CPUFUNC(op_57f8_23)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (7) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (xxx).L (EQ) */
void REGPARAM2 CPUFUNC(op_57f9_23)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (7) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
}

/* TRAPcc.L #<data>.W (EQ) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_57fa_23)(uae_u32 opcode)
{
{{	uae_s16 dummy = get_word_ce030_prefetch (2);
	/* OP zero */
	if (cctrue (7)) { Exception (7); goto l_231059; }
	regs.irc = get_word_ce030_prefetch (4);
}}	m68k_incpci (4);
l_231059: ;
return;
}

#endif
/* TRAPcc.L #<data>.L (EQ) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_57fb_23)(uae_u32 opcode)
{
{{	uae_s32 dummy;
	dummy = get_long_ce030_prefetch (2);
	/* OP zero */
	if (cctrue (7)) { Exception (7); goto l_231060; }
	regs.irc = get_word_ce030_prefetch (6);
}}	m68k_incpci (6);
l_231060: ;
return;
}

#endif
/* TRAPcc.L  (EQ) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_57fc_23)(uae_u32 opcode)
{
{	if (cctrue (7)) { Exception (7); goto l_231061; }
	regs.irc = get_word_ce030_prefetch (2);
}	m68k_incpci (2);
l_231061: ;
return;
}

#endif
/* Scc.B Dn (VC) */
void REGPARAM2 CPUFUNC(op_58c0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	/* op H:0,T:0,C:2 */
{{	int val = cctrue (8) ? 0xff : 0;
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* DBcc.W Dn,#<data>.W (VC) */
void REGPARAM2 CPUFUNC(op_58c8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_word_ce030_prefetch (2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (8)) {
	m68k_incpci ((uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_231063;
			}
	fill_prefetch_030 ();
			return;
		}
	} else {
	}
	m68k_setpci (oldpc + 4);
	continue_ce020_prefetch();
}}}l_231063: ;
return;
}

/* Scc.B (An) (VC) */
void REGPARAM2 CPUFUNC(op_58d0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (8) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (An)+ (VC) */
void REGPARAM2 CPUFUNC(op_58d8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (8) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B -(An) (VC) */
void REGPARAM2 CPUFUNC(op_58e0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (8) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (d16,An) (VC) */
void REGPARAM2 CPUFUNC(op_58e8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (8) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (d8,An,Xn) (VC) */
void REGPARAM2 CPUFUNC(op_58f0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (8) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}}return;
}

/* Scc.B (xxx).W (VC) */
void REGPARAM2 CPUFUNC(op_58f8_23)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (8) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (xxx).L (VC) */
void REGPARAM2 CPUFUNC(op_58f9_23)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (8) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
}

/* TRAPcc.L #<data>.W (VC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_58fa_23)(uae_u32 opcode)
{
{{	uae_s16 dummy = get_word_ce030_prefetch (2);
	/* OP zero */
	if (cctrue (8)) { Exception (7); goto l_231071; }
	regs.irc = get_word_ce030_prefetch (4);
}}	m68k_incpci (4);
l_231071: ;
return;
}

#endif
/* TRAPcc.L #<data>.L (VC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_58fb_23)(uae_u32 opcode)
{
{{	uae_s32 dummy;
	dummy = get_long_ce030_prefetch (2);
	/* OP zero */
	if (cctrue (8)) { Exception (7); goto l_231072; }
	regs.irc = get_word_ce030_prefetch (6);
}}	m68k_incpci (6);
l_231072: ;
return;
}

#endif
/* TRAPcc.L  (VC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_58fc_23)(uae_u32 opcode)
{
{	if (cctrue (8)) { Exception (7); goto l_231073; }
	regs.irc = get_word_ce030_prefetch (2);
}	m68k_incpci (2);
l_231073: ;
return;
}

#endif
/* Scc.B Dn (VS) */
void REGPARAM2 CPUFUNC(op_59c0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	/* op H:0,T:0,C:2 */
{{	int val = cctrue (9) ? 0xff : 0;
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* DBcc.W Dn,#<data>.W (VS) */
void REGPARAM2 CPUFUNC(op_59c8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_word_ce030_prefetch (2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (9)) {
	m68k_incpci ((uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_231075;
			}
	fill_prefetch_030 ();
			return;
		}
	} else {
	}
	m68k_setpci (oldpc + 4);
	continue_ce020_prefetch();
}}}l_231075: ;
return;
}

/* Scc.B (An) (VS) */
void REGPARAM2 CPUFUNC(op_59d0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (9) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (An)+ (VS) */
void REGPARAM2 CPUFUNC(op_59d8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (9) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B -(An) (VS) */
void REGPARAM2 CPUFUNC(op_59e0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (9) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (d16,An) (VS) */
void REGPARAM2 CPUFUNC(op_59e8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (9) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (d8,An,Xn) (VS) */
void REGPARAM2 CPUFUNC(op_59f0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (9) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}}return;
}

/* Scc.B (xxx).W (VS) */
void REGPARAM2 CPUFUNC(op_59f8_23)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (9) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (xxx).L (VS) */
void REGPARAM2 CPUFUNC(op_59f9_23)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (9) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
}

/* TRAPcc.L #<data>.W (VS) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_59fa_23)(uae_u32 opcode)
{
{{	uae_s16 dummy = get_word_ce030_prefetch (2);
	/* OP zero */
	if (cctrue (9)) { Exception (7); goto l_231083; }
	regs.irc = get_word_ce030_prefetch (4);
}}	m68k_incpci (4);
l_231083: ;
return;
}

#endif
/* TRAPcc.L #<data>.L (VS) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_59fb_23)(uae_u32 opcode)
{
{{	uae_s32 dummy;
	dummy = get_long_ce030_prefetch (2);
	/* OP zero */
	if (cctrue (9)) { Exception (7); goto l_231084; }
	regs.irc = get_word_ce030_prefetch (6);
}}	m68k_incpci (6);
l_231084: ;
return;
}

#endif
/* TRAPcc.L  (VS) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_59fc_23)(uae_u32 opcode)
{
{	if (cctrue (9)) { Exception (7); goto l_231085; }
	regs.irc = get_word_ce030_prefetch (2);
}	m68k_incpci (2);
l_231085: ;
return;
}

#endif
/* Scc.B Dn (PL) */
void REGPARAM2 CPUFUNC(op_5ac0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	/* op H:0,T:0,C:2 */
{{	int val = cctrue (10) ? 0xff : 0;
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* DBcc.W Dn,#<data>.W (PL) */
void REGPARAM2 CPUFUNC(op_5ac8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_word_ce030_prefetch (2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (10)) {
	m68k_incpci ((uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_231087;
			}
	fill_prefetch_030 ();
			return;
		}
	} else {
	}
	m68k_setpci (oldpc + 4);
	continue_ce020_prefetch();
}}}l_231087: ;
return;
}

/* Scc.B (An) (PL) */
void REGPARAM2 CPUFUNC(op_5ad0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (10) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (An)+ (PL) */
void REGPARAM2 CPUFUNC(op_5ad8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (10) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B -(An) (PL) */
void REGPARAM2 CPUFUNC(op_5ae0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (10) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (d16,An) (PL) */
void REGPARAM2 CPUFUNC(op_5ae8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (10) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (d8,An,Xn) (PL) */
void REGPARAM2 CPUFUNC(op_5af0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (10) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}}return;
}

/* Scc.B (xxx).W (PL) */
void REGPARAM2 CPUFUNC(op_5af8_23)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (10) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (xxx).L (PL) */
void REGPARAM2 CPUFUNC(op_5af9_23)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (10) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
}

/* TRAPcc.L #<data>.W (PL) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_5afa_23)(uae_u32 opcode)
{
{{	uae_s16 dummy = get_word_ce030_prefetch (2);
	/* OP zero */
	if (cctrue (10)) { Exception (7); goto l_231095; }
	regs.irc = get_word_ce030_prefetch (4);
}}	m68k_incpci (4);
l_231095: ;
return;
}

#endif
/* TRAPcc.L #<data>.L (PL) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_5afb_23)(uae_u32 opcode)
{
{{	uae_s32 dummy;
	dummy = get_long_ce030_prefetch (2);
	/* OP zero */
	if (cctrue (10)) { Exception (7); goto l_231096; }
	regs.irc = get_word_ce030_prefetch (6);
}}	m68k_incpci (6);
l_231096: ;
return;
}

#endif
/* TRAPcc.L  (PL) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_5afc_23)(uae_u32 opcode)
{
{	if (cctrue (10)) { Exception (7); goto l_231097; }
	regs.irc = get_word_ce030_prefetch (2);
}	m68k_incpci (2);
l_231097: ;
return;
}

#endif
/* Scc.B Dn (MI) */
void REGPARAM2 CPUFUNC(op_5bc0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	/* op H:0,T:0,C:2 */
{{	int val = cctrue (11) ? 0xff : 0;
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* DBcc.W Dn,#<data>.W (MI) */
void REGPARAM2 CPUFUNC(op_5bc8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_word_ce030_prefetch (2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (11)) {
	m68k_incpci ((uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_231099;
			}
	fill_prefetch_030 ();
			return;
		}
	} else {
	}
	m68k_setpci (oldpc + 4);
	continue_ce020_prefetch();
}}}l_231099: ;
return;
}

/* Scc.B (An) (MI) */
void REGPARAM2 CPUFUNC(op_5bd0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (11) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (An)+ (MI) */
void REGPARAM2 CPUFUNC(op_5bd8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (11) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B -(An) (MI) */
void REGPARAM2 CPUFUNC(op_5be0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (11) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (d16,An) (MI) */
void REGPARAM2 CPUFUNC(op_5be8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (11) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (d8,An,Xn) (MI) */
void REGPARAM2 CPUFUNC(op_5bf0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (11) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}}return;
}

/* Scc.B (xxx).W (MI) */
void REGPARAM2 CPUFUNC(op_5bf8_23)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (11) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (xxx).L (MI) */
void REGPARAM2 CPUFUNC(op_5bf9_23)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (11) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
}

/* TRAPcc.L #<data>.W (MI) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_5bfa_23)(uae_u32 opcode)
{
{{	uae_s16 dummy = get_word_ce030_prefetch (2);
	/* OP zero */
	if (cctrue (11)) { Exception (7); goto l_231107; }
	regs.irc = get_word_ce030_prefetch (4);
}}	m68k_incpci (4);
l_231107: ;
return;
}

#endif
/* TRAPcc.L #<data>.L (MI) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_5bfb_23)(uae_u32 opcode)
{
{{	uae_s32 dummy;
	dummy = get_long_ce030_prefetch (2);
	/* OP zero */
	if (cctrue (11)) { Exception (7); goto l_231108; }
	regs.irc = get_word_ce030_prefetch (6);
}}	m68k_incpci (6);
l_231108: ;
return;
}

#endif
/* TRAPcc.L  (MI) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_5bfc_23)(uae_u32 opcode)
{
{	if (cctrue (11)) { Exception (7); goto l_231109; }
	regs.irc = get_word_ce030_prefetch (2);
}	m68k_incpci (2);
l_231109: ;
return;
}

#endif
/* Scc.B Dn (GE) */
void REGPARAM2 CPUFUNC(op_5cc0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	/* op H:0,T:0,C:2 */
{{	int val = cctrue (12) ? 0xff : 0;
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* DBcc.W Dn,#<data>.W (GE) */
void REGPARAM2 CPUFUNC(op_5cc8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_word_ce030_prefetch (2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (12)) {
	m68k_incpci ((uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_231111;
			}
	fill_prefetch_030 ();
			return;
		}
	} else {
	}
	m68k_setpci (oldpc + 4);
	continue_ce020_prefetch();
}}}l_231111: ;
return;
}

/* Scc.B (An) (GE) */
void REGPARAM2 CPUFUNC(op_5cd0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (12) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (An)+ (GE) */
void REGPARAM2 CPUFUNC(op_5cd8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (12) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B -(An) (GE) */
void REGPARAM2 CPUFUNC(op_5ce0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (12) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (d16,An) (GE) */
void REGPARAM2 CPUFUNC(op_5ce8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (12) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (d8,An,Xn) (GE) */
void REGPARAM2 CPUFUNC(op_5cf0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (12) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}}return;
}

/* Scc.B (xxx).W (GE) */
void REGPARAM2 CPUFUNC(op_5cf8_23)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (12) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (xxx).L (GE) */
void REGPARAM2 CPUFUNC(op_5cf9_23)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (12) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
}

/* TRAPcc.L #<data>.W (GE) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_5cfa_23)(uae_u32 opcode)
{
{{	uae_s16 dummy = get_word_ce030_prefetch (2);
	/* OP zero */
	if (cctrue (12)) { Exception (7); goto l_231119; }
	regs.irc = get_word_ce030_prefetch (4);
}}	m68k_incpci (4);
l_231119: ;
return;
}

#endif
/* TRAPcc.L #<data>.L (GE) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_5cfb_23)(uae_u32 opcode)
{
{{	uae_s32 dummy;
	dummy = get_long_ce030_prefetch (2);
	/* OP zero */
	if (cctrue (12)) { Exception (7); goto l_231120; }
	regs.irc = get_word_ce030_prefetch (6);
}}	m68k_incpci (6);
l_231120: ;
return;
}

#endif
/* TRAPcc.L  (GE) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_5cfc_23)(uae_u32 opcode)
{
{	if (cctrue (12)) { Exception (7); goto l_231121; }
	regs.irc = get_word_ce030_prefetch (2);
}	m68k_incpci (2);
l_231121: ;
return;
}

#endif
/* Scc.B Dn (LT) */
void REGPARAM2 CPUFUNC(op_5dc0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	/* op H:0,T:0,C:2 */
{{	int val = cctrue (13) ? 0xff : 0;
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* DBcc.W Dn,#<data>.W (LT) */
void REGPARAM2 CPUFUNC(op_5dc8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_word_ce030_prefetch (2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (13)) {
	m68k_incpci ((uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_231123;
			}
	fill_prefetch_030 ();
			return;
		}
	} else {
	}
	m68k_setpci (oldpc + 4);
	continue_ce020_prefetch();
}}}l_231123: ;
return;
}

/* Scc.B (An) (LT) */
void REGPARAM2 CPUFUNC(op_5dd0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (13) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (An)+ (LT) */
void REGPARAM2 CPUFUNC(op_5dd8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (13) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B -(An) (LT) */
void REGPARAM2 CPUFUNC(op_5de0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (13) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (d16,An) (LT) */
void REGPARAM2 CPUFUNC(op_5de8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (13) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (d8,An,Xn) (LT) */
void REGPARAM2 CPUFUNC(op_5df0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (13) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}}return;
}

/* Scc.B (xxx).W (LT) */
void REGPARAM2 CPUFUNC(op_5df8_23)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (13) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (xxx).L (LT) */
void REGPARAM2 CPUFUNC(op_5df9_23)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (13) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
}

/* TRAPcc.L #<data>.W (LT) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_5dfa_23)(uae_u32 opcode)
{
{{	uae_s16 dummy = get_word_ce030_prefetch (2);
	/* OP zero */
	if (cctrue (13)) { Exception (7); goto l_231131; }
	regs.irc = get_word_ce030_prefetch (4);
}}	m68k_incpci (4);
l_231131: ;
return;
}

#endif
/* TRAPcc.L #<data>.L (LT) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_5dfb_23)(uae_u32 opcode)
{
{{	uae_s32 dummy;
	dummy = get_long_ce030_prefetch (2);
	/* OP zero */
	if (cctrue (13)) { Exception (7); goto l_231132; }
	regs.irc = get_word_ce030_prefetch (6);
}}	m68k_incpci (6);
l_231132: ;
return;
}

#endif
/* TRAPcc.L  (LT) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_5dfc_23)(uae_u32 opcode)
{
{	if (cctrue (13)) { Exception (7); goto l_231133; }
	regs.irc = get_word_ce030_prefetch (2);
}	m68k_incpci (2);
l_231133: ;
return;
}

#endif
/* Scc.B Dn (GT) */
void REGPARAM2 CPUFUNC(op_5ec0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	/* op H:0,T:0,C:2 */
{{	int val = cctrue (14) ? 0xff : 0;
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* DBcc.W Dn,#<data>.W (GT) */
void REGPARAM2 CPUFUNC(op_5ec8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_word_ce030_prefetch (2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (14)) {
	m68k_incpci ((uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_231135;
			}
	fill_prefetch_030 ();
			return;
		}
	} else {
	}
	m68k_setpci (oldpc + 4);
	continue_ce020_prefetch();
}}}l_231135: ;
return;
}

/* Scc.B (An) (GT) */
void REGPARAM2 CPUFUNC(op_5ed0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (14) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (An)+ (GT) */
void REGPARAM2 CPUFUNC(op_5ed8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (14) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B -(An) (GT) */
void REGPARAM2 CPUFUNC(op_5ee0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (14) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (d16,An) (GT) */
void REGPARAM2 CPUFUNC(op_5ee8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (14) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (d8,An,Xn) (GT) */
void REGPARAM2 CPUFUNC(op_5ef0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (14) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}}return;
}

/* Scc.B (xxx).W (GT) */
void REGPARAM2 CPUFUNC(op_5ef8_23)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (14) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (xxx).L (GT) */
void REGPARAM2 CPUFUNC(op_5ef9_23)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (14) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
}

/* TRAPcc.L #<data>.W (GT) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_5efa_23)(uae_u32 opcode)
{
{{	uae_s16 dummy = get_word_ce030_prefetch (2);
	/* OP zero */
	if (cctrue (14)) { Exception (7); goto l_231143; }
	regs.irc = get_word_ce030_prefetch (4);
}}	m68k_incpci (4);
l_231143: ;
return;
}

#endif
/* TRAPcc.L #<data>.L (GT) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_5efb_23)(uae_u32 opcode)
{
{{	uae_s32 dummy;
	dummy = get_long_ce030_prefetch (2);
	/* OP zero */
	if (cctrue (14)) { Exception (7); goto l_231144; }
	regs.irc = get_word_ce030_prefetch (6);
}}	m68k_incpci (6);
l_231144: ;
return;
}

#endif
/* TRAPcc.L  (GT) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_5efc_23)(uae_u32 opcode)
{
{	if (cctrue (14)) { Exception (7); goto l_231145; }
	regs.irc = get_word_ce030_prefetch (2);
}	m68k_incpci (2);
l_231145: ;
return;
}

#endif
/* Scc.B Dn (LE) */
void REGPARAM2 CPUFUNC(op_5fc0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	/* op H:0,T:0,C:2 */
{{	int val = cctrue (15) ? 0xff : 0;
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* DBcc.W Dn,#<data>.W (LE) */
void REGPARAM2 CPUFUNC(op_5fc8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_word_ce030_prefetch (2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (15)) {
	m68k_incpci ((uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_231147;
			}
	fill_prefetch_030 ();
			return;
		}
	} else {
	}
	m68k_setpci (oldpc + 4);
	continue_ce020_prefetch();
}}}l_231147: ;
return;
}

/* Scc.B (An) (LE) */
void REGPARAM2 CPUFUNC(op_5fd0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (15) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (An)+ (LE) */
void REGPARAM2 CPUFUNC(op_5fd8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (15) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B -(An) (LE) */
void REGPARAM2 CPUFUNC(op_5fe0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (15) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (d16,An) (LE) */
void REGPARAM2 CPUFUNC(op_5fe8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (15) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (d8,An,Xn) (LE) */
void REGPARAM2 CPUFUNC(op_5ff0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (15) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}}return;
}

/* Scc.B (xxx).W (LE) */
void REGPARAM2 CPUFUNC(op_5ff8_23)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (15) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (xxx).L (LE) */
void REGPARAM2 CPUFUNC(op_5ff9_23)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (15) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
}

/* TRAPcc.L #<data>.W (LE) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_5ffa_23)(uae_u32 opcode)
{
{{	uae_s16 dummy = get_word_ce030_prefetch (2);
	/* OP zero */
	if (cctrue (15)) { Exception (7); goto l_231155; }
	regs.irc = get_word_ce030_prefetch (4);
}}	m68k_incpci (4);
l_231155: ;
return;
}

#endif
/* TRAPcc.L #<data>.L (LE) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_5ffb_23)(uae_u32 opcode)
{
{{	uae_s32 dummy;
	dummy = get_long_ce030_prefetch (2);
	/* OP zero */
	if (cctrue (15)) { Exception (7); goto l_231156; }
	regs.irc = get_word_ce030_prefetch (6);
}}	m68k_incpci (6);
l_231156: ;
return;
}

#endif
/* TRAPcc.L  (LE) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_5ffc_23)(uae_u32 opcode)
{
{	if (cctrue (15)) { Exception (7); goto l_231157; }
	regs.irc = get_word_ce030_prefetch (2);
}	m68k_incpci (2);
l_231157: ;
return;
}

#endif
/* Bcc.W #<data>.W (T) */
void REGPARAM2 CPUFUNC(op_6000_23)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
	if (!cctrue (0)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231158;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (4);
	continue_ce020_prefetch();
}}l_231158: ;
return;
}

/* BccQ.B #<data> (T) */
void REGPARAM2 CPUFUNC(op_6001_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	/* OP zero */
	if (!cctrue (0)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231159;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (2);
	continue_ce020_prefetch();
}}l_231159: ;
return;
}

/* Bcc.L #<data>.L (T) */
void REGPARAM2 CPUFUNC(op_60ff_23)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
	/* OP zero */
	if (!cctrue (0)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231160;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (6);
	continue_ce020_prefetch();
}}l_231160: ;
return;
}

/* BSR.W #<data>.W */
void REGPARAM2 CPUFUNC(op_6100_23)(uae_u32 opcode)
{
{	uae_s32 s;
{	uae_s16 src = get_word_ce030_prefetch (2);
	/* op H:2,T:0,C:4 */
	s = (uae_s32)src + 2;
	if (src & 1) {
		exception3b (opcode, m68k_getpci () + s, 0, 1, m68k_getpci () + s);
		goto l_231161;
	}
	m68k_do_bsr_ce030 (m68k_getpci () + 4, s);
	fill_prefetch_030 ();
}}l_231161: ;
return;
}

/* BSRQ.B #<data> */
void REGPARAM2 CPUFUNC(op_6101_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{	uae_s32 s;
{	uae_u32 src = srcreg;
	/* op H:2,T:0,C:4 */
	s = (uae_s32)src + 2;
	if (src & 1) {
		exception3b (opcode, m68k_getpci () + s, 0, 1, m68k_getpci () + s);
		goto l_231162;
	}
	m68k_do_bsr_ce030 (m68k_getpci () + 2, s);
	fill_prefetch_030 ();
}}l_231162: ;
return;
}

/* BSR.L #<data>.L */
void REGPARAM2 CPUFUNC(op_61ff_23)(uae_u32 opcode)
{
{	uae_s32 s;
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
	/* op H:2,T:0,C:4 */
	s = (uae_s32)src + 2;
	if (src & 1) {
		exception3b (opcode, m68k_getpci () + s, 0, 1, m68k_getpci () + s);
		goto l_231163;
	}
	m68k_do_bsr_ce030 (m68k_getpci () + 6, s);
	fill_prefetch_030 ();
}}l_231163: ;
return;
}

/* Bcc.W #<data>.W (HI) */
void REGPARAM2 CPUFUNC(op_6200_23)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
	if (!cctrue (2)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231164;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (4);
	continue_ce020_prefetch();
}}l_231164: ;
return;
}

/* BccQ.B #<data> (HI) */
void REGPARAM2 CPUFUNC(op_6201_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	/* OP zero */
	if (!cctrue (2)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231165;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (2);
	continue_ce020_prefetch();
}}l_231165: ;
return;
}

/* Bcc.L #<data>.L (HI) */
void REGPARAM2 CPUFUNC(op_62ff_23)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
	/* OP zero */
	if (!cctrue (2)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231166;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (6);
	continue_ce020_prefetch();
}}l_231166: ;
return;
}

/* Bcc.W #<data>.W (LS) */
void REGPARAM2 CPUFUNC(op_6300_23)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
	if (!cctrue (3)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231167;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (4);
	continue_ce020_prefetch();
}}l_231167: ;
return;
}

/* BccQ.B #<data> (LS) */
void REGPARAM2 CPUFUNC(op_6301_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	/* OP zero */
	if (!cctrue (3)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231168;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (2);
	continue_ce020_prefetch();
}}l_231168: ;
return;
}

#endif

#ifdef PART_6
/* Bcc.L #<data>.L (LS) */
void REGPARAM2 CPUFUNC(op_63ff_23)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
	/* OP zero */
	if (!cctrue (3)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231169;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (6);
	continue_ce020_prefetch();
}}l_231169: ;
return;
}

/* Bcc.W #<data>.W (CC) */
void REGPARAM2 CPUFUNC(op_6400_23)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
	if (!cctrue (4)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231170;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (4);
	continue_ce020_prefetch();
}}l_231170: ;
return;
}

/* BccQ.B #<data> (CC) */
void REGPARAM2 CPUFUNC(op_6401_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	/* OP zero */
	if (!cctrue (4)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231171;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (2);
	continue_ce020_prefetch();
}}l_231171: ;
return;
}

/* Bcc.L #<data>.L (CC) */
void REGPARAM2 CPUFUNC(op_64ff_23)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
	/* OP zero */
	if (!cctrue (4)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231172;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (6);
	continue_ce020_prefetch();
}}l_231172: ;
return;
}

/* Bcc.W #<data>.W (CS) */
void REGPARAM2 CPUFUNC(op_6500_23)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
	if (!cctrue (5)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231173;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (4);
	continue_ce020_prefetch();
}}l_231173: ;
return;
}

/* BccQ.B #<data> (CS) */
void REGPARAM2 CPUFUNC(op_6501_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	/* OP zero */
	if (!cctrue (5)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231174;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (2);
	continue_ce020_prefetch();
}}l_231174: ;
return;
}

/* Bcc.L #<data>.L (CS) */
void REGPARAM2 CPUFUNC(op_65ff_23)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
	/* OP zero */
	if (!cctrue (5)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231175;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (6);
	continue_ce020_prefetch();
}}l_231175: ;
return;
}

/* Bcc.W #<data>.W (NE) */
void REGPARAM2 CPUFUNC(op_6600_23)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
	if (!cctrue (6)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231176;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (4);
	continue_ce020_prefetch();
}}l_231176: ;
return;
}

/* BccQ.B #<data> (NE) */
void REGPARAM2 CPUFUNC(op_6601_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	/* OP zero */
	if (!cctrue (6)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231177;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (2);
	continue_ce020_prefetch();
}}l_231177: ;
return;
}

/* Bcc.L #<data>.L (NE) */
void REGPARAM2 CPUFUNC(op_66ff_23)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
	/* OP zero */
	if (!cctrue (6)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231178;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (6);
	continue_ce020_prefetch();
}}l_231178: ;
return;
}

/* Bcc.W #<data>.W (EQ) */
void REGPARAM2 CPUFUNC(op_6700_23)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
	if (!cctrue (7)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231179;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (4);
	continue_ce020_prefetch();
}}l_231179: ;
return;
}

/* BccQ.B #<data> (EQ) */
void REGPARAM2 CPUFUNC(op_6701_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	/* OP zero */
	if (!cctrue (7)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231180;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (2);
	continue_ce020_prefetch();
}}l_231180: ;
return;
}

/* Bcc.L #<data>.L (EQ) */
void REGPARAM2 CPUFUNC(op_67ff_23)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
	/* OP zero */
	if (!cctrue (7)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231181;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (6);
	continue_ce020_prefetch();
}}l_231181: ;
return;
}

/* Bcc.W #<data>.W (VC) */
void REGPARAM2 CPUFUNC(op_6800_23)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
	if (!cctrue (8)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231182;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (4);
	continue_ce020_prefetch();
}}l_231182: ;
return;
}

/* BccQ.B #<data> (VC) */
void REGPARAM2 CPUFUNC(op_6801_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	/* OP zero */
	if (!cctrue (8)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231183;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (2);
	continue_ce020_prefetch();
}}l_231183: ;
return;
}

/* Bcc.L #<data>.L (VC) */
void REGPARAM2 CPUFUNC(op_68ff_23)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
	/* OP zero */
	if (!cctrue (8)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231184;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (6);
	continue_ce020_prefetch();
}}l_231184: ;
return;
}

/* Bcc.W #<data>.W (VS) */
void REGPARAM2 CPUFUNC(op_6900_23)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
	if (!cctrue (9)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231185;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (4);
	continue_ce020_prefetch();
}}l_231185: ;
return;
}

/* BccQ.B #<data> (VS) */
void REGPARAM2 CPUFUNC(op_6901_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	/* OP zero */
	if (!cctrue (9)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231186;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (2);
	continue_ce020_prefetch();
}}l_231186: ;
return;
}

/* Bcc.L #<data>.L (VS) */
void REGPARAM2 CPUFUNC(op_69ff_23)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
	/* OP zero */
	if (!cctrue (9)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231187;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (6);
	continue_ce020_prefetch();
}}l_231187: ;
return;
}

/* Bcc.W #<data>.W (PL) */
void REGPARAM2 CPUFUNC(op_6a00_23)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
	if (!cctrue (10)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231188;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (4);
	continue_ce020_prefetch();
}}l_231188: ;
return;
}

/* BccQ.B #<data> (PL) */
void REGPARAM2 CPUFUNC(op_6a01_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	/* OP zero */
	if (!cctrue (10)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231189;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (2);
	continue_ce020_prefetch();
}}l_231189: ;
return;
}

/* Bcc.L #<data>.L (PL) */
void REGPARAM2 CPUFUNC(op_6aff_23)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
	/* OP zero */
	if (!cctrue (10)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231190;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (6);
	continue_ce020_prefetch();
}}l_231190: ;
return;
}

/* Bcc.W #<data>.W (MI) */
void REGPARAM2 CPUFUNC(op_6b00_23)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
	if (!cctrue (11)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231191;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (4);
	continue_ce020_prefetch();
}}l_231191: ;
return;
}

/* BccQ.B #<data> (MI) */
void REGPARAM2 CPUFUNC(op_6b01_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	/* OP zero */
	if (!cctrue (11)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231192;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (2);
	continue_ce020_prefetch();
}}l_231192: ;
return;
}

/* Bcc.L #<data>.L (MI) */
void REGPARAM2 CPUFUNC(op_6bff_23)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
	/* OP zero */
	if (!cctrue (11)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231193;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (6);
	continue_ce020_prefetch();
}}l_231193: ;
return;
}

/* Bcc.W #<data>.W (GE) */
void REGPARAM2 CPUFUNC(op_6c00_23)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
	if (!cctrue (12)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231194;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (4);
	continue_ce020_prefetch();
}}l_231194: ;
return;
}

/* BccQ.B #<data> (GE) */
void REGPARAM2 CPUFUNC(op_6c01_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	/* OP zero */
	if (!cctrue (12)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231195;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (2);
	continue_ce020_prefetch();
}}l_231195: ;
return;
}

/* Bcc.L #<data>.L (GE) */
void REGPARAM2 CPUFUNC(op_6cff_23)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
	/* OP zero */
	if (!cctrue (12)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231196;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (6);
	continue_ce020_prefetch();
}}l_231196: ;
return;
}

/* Bcc.W #<data>.W (LT) */
void REGPARAM2 CPUFUNC(op_6d00_23)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
	if (!cctrue (13)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231197;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (4);
	continue_ce020_prefetch();
}}l_231197: ;
return;
}

/* BccQ.B #<data> (LT) */
void REGPARAM2 CPUFUNC(op_6d01_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	/* OP zero */
	if (!cctrue (13)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231198;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (2);
	continue_ce020_prefetch();
}}l_231198: ;
return;
}

/* Bcc.L #<data>.L (LT) */
void REGPARAM2 CPUFUNC(op_6dff_23)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
	/* OP zero */
	if (!cctrue (13)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231199;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (6);
	continue_ce020_prefetch();
}}l_231199: ;
return;
}

/* Bcc.W #<data>.W (GT) */
void REGPARAM2 CPUFUNC(op_6e00_23)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
	if (!cctrue (14)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231200;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (4);
	continue_ce020_prefetch();
}}l_231200: ;
return;
}

/* BccQ.B #<data> (GT) */
void REGPARAM2 CPUFUNC(op_6e01_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	/* OP zero */
	if (!cctrue (14)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231201;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (2);
	continue_ce020_prefetch();
}}l_231201: ;
return;
}

/* Bcc.L #<data>.L (GT) */
void REGPARAM2 CPUFUNC(op_6eff_23)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
	/* OP zero */
	if (!cctrue (14)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231202;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (6);
	continue_ce020_prefetch();
}}l_231202: ;
return;
}

/* Bcc.W #<data>.W (LE) */
void REGPARAM2 CPUFUNC(op_6f00_23)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce030_prefetch (2);
	/* OP zero */
	if (!cctrue (15)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231203;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (4);
	continue_ce020_prefetch();
}}l_231203: ;
return;
}

/* BccQ.B #<data> (LE) */
void REGPARAM2 CPUFUNC(op_6f01_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	/* OP zero */
	if (!cctrue (15)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231204;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (2);
	continue_ce020_prefetch();
}}l_231204: ;
return;
}

/* Bcc.L #<data>.L (LE) */
void REGPARAM2 CPUFUNC(op_6fff_23)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
	/* OP zero */
	if (!cctrue (15)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_231205;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_030 ();
	return;
didnt_jump:;
	m68k_incpci (6);
	continue_ce020_prefetch();
}}l_231205: ;
return;
}

/* MOVEQ.L #<data>,Dn */
void REGPARAM2 CPUFUNC(op_7000_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_u32 src = srcreg;
{	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (2);
}}}return;
}

/* OR.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_8000_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpci (2);
return;
}

/* OR.B (An),Dn */
void REGPARAM2 CPUFUNC(op_8010_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* OR.B (An)+,Dn */
void REGPARAM2 CPUFUNC(op_8018_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* OR.B -(An),Dn */
void REGPARAM2 CPUFUNC(op_8020_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* OR.B (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_8028_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (4);
return;
}

/* OR.B (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_8030_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}}return;
}

/* OR.B (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_8038_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (4);
return;
}

/* OR.B (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_8039_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (6);
return;
}

/* OR.B (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_803a_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (4);
return;
}

/* OR.B (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_803b_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}}return;
}

/* OR.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_803c_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpci (4);
return;
}

/* OR.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_8040_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpci (2);
return;
}

/* OR.W (An),Dn */
void REGPARAM2 CPUFUNC(op_8050_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpci (2);
return;
}

/* OR.W (An)+,Dn */
void REGPARAM2 CPUFUNC(op_8058_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpci (2);
return;
}

/* OR.W -(An),Dn */
void REGPARAM2 CPUFUNC(op_8060_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpci (2);
return;
}

/* OR.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_8068_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpci (4);
return;
}

/* OR.W (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_8070_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}return;
}

/* OR.W (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_8078_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpci (4);
return;
}

/* OR.W (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_8079_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpci (6);
return;
}

/* OR.W (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_807a_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpci (4);
return;
}

/* OR.W (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_807b_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}return;
}

/* OR.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_807c_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpci (4);
return;
}

/* OR.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_8080_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpci (2);
return;
}

/* OR.L (An),Dn */
void REGPARAM2 CPUFUNC(op_8090_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpci (2);
return;
}

/* OR.L (An)+,Dn */
void REGPARAM2 CPUFUNC(op_8098_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpci (2);
return;
}

/* OR.L -(An),Dn */
void REGPARAM2 CPUFUNC(op_80a0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpci (2);
return;
}

/* OR.L (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_80a8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpci (4);
return;
}

/* OR.L (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_80b0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
}}}}}return;
}

/* OR.L (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_80b8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpci (4);
return;
}

/* OR.L (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_80b9_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpci (6);
return;
}

/* OR.L (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_80ba_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpci (4);
return;
}

/* OR.L (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_80bb_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
}}}}}return;
}

/* OR.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_80bc_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpci (6);
return;
}

/* DIVU.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_80c0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:52 */
	CLEAR_CZNV ();
	if (src == 0) {
		divbyzero_special (0, dst);
	m68k_incpci (2);
		Exception (5);
		goto l_231240;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpci (2);
	}
	regs.irc = get_word_ce030_prefetch (0);
	do_cycles_ce020_internal (52);
}}}l_231240: ;
return;
}

/* DIVU.W (An),Dn */
void REGPARAM2 CPUFUNC(op_80d0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:54 */
	CLEAR_CZNV ();
	if (src == 0) {
		divbyzero_special (0, dst);
	m68k_incpci (2);
		Exception (5);
		goto l_231241;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpci (2);
	}
	do_cycles_ce020_internal (52);
}}}}l_231241: ;
return;
}

/* DIVU.W (An)+,Dn */
void REGPARAM2 CPUFUNC(op_80d8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:54 */
	CLEAR_CZNV ();
	if (src == 0) {
		divbyzero_special (0, dst);
	m68k_incpci (2);
		Exception (5);
		goto l_231242;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpci (2);
	}
	do_cycles_ce020_internal (52);
}}}}l_231242: ;
return;
}

/* DIVU.W -(An),Dn */
void REGPARAM2 CPUFUNC(op_80e0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:54 */
	CLEAR_CZNV ();
	if (src == 0) {
		divbyzero_special (0, dst);
	m68k_incpci (2);
		Exception (5);
		goto l_231243;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpci (2);
	}
	do_cycles_ce020_internal (52);
}}}}l_231243: ;
return;
}

/* DIVU.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_80e8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:54 */
	CLEAR_CZNV ();
	if (src == 0) {
		divbyzero_special (0, dst);
	m68k_incpci (4);
		Exception (5);
		goto l_231244;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpci (4);
	}
	do_cycles_ce020_internal (52);
}}}}l_231244: ;
return;
}

/* DIVU.W (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_80f0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:54 */
	CLEAR_CZNV ();
	if (src == 0) {
		divbyzero_special (0, dst);
	m68k_incpci (0);
		Exception (5);
		goto l_231245;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	do_cycles_ce020_internal (52);
}}}}}l_231245: ;
return;
}

/* DIVU.W (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_80f8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:54 */
	CLEAR_CZNV ();
	if (src == 0) {
		divbyzero_special (0, dst);
	m68k_incpci (4);
		Exception (5);
		goto l_231246;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpci (4);
	}
	do_cycles_ce020_internal (52);
}}}}l_231246: ;
return;
}

/* DIVU.W (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_80f9_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:54 */
	CLEAR_CZNV ();
	if (src == 0) {
		divbyzero_special (0, dst);
	m68k_incpci (6);
		Exception (5);
		goto l_231247;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpci (6);
	}
	do_cycles_ce020_internal (52);
}}}}l_231247: ;
return;
}

/* DIVU.W (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_80fa_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:54 */
	CLEAR_CZNV ();
	if (src == 0) {
		divbyzero_special (0, dst);
	m68k_incpci (4);
		Exception (5);
		goto l_231248;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpci (4);
	}
	do_cycles_ce020_internal (52);
}}}}l_231248: ;
return;
}

/* DIVU.W (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_80fb_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:54 */
	CLEAR_CZNV ();
	if (src == 0) {
		divbyzero_special (0, dst);
	m68k_incpci (0);
		Exception (5);
		goto l_231249;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	do_cycles_ce020_internal (52);
}}}}}l_231249: ;
return;
}

/* DIVU.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_80fc_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:54 */
	CLEAR_CZNV ();
	if (src == 0) {
		divbyzero_special (0, dst);
	m68k_incpci (4);
		Exception (5);
		goto l_231250;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpci (4);
	}
	do_cycles_ce020_internal (52);
}}}l_231250: ;
return;
}

/* SBCD.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_8100_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
	/* op H:0,T:0,C:4 */
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	/* op H:0,T:0,C:4 */
{	uae_u16 newv_lo = (dst & 0xF) - (src & 0xF) - (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = (dst & 0xF0) - (src & 0xF0);
	uae_u16 newv, tmp_newv;
	int bcd = 0;
	newv = tmp_newv = newv_hi + newv_lo;
	if (newv_lo & 0xF0) { newv -= 6; bcd = 6; };
	if ((((dst & 0xFF) - (src & 0xFF) - (GET_XFLG () ? 1 : 0)) & 0x100) > 0xFF) { newv -= 0x60; }
	SET_CFLG ((((dst & 0xFF) - (src & 0xFF) - bcd - (GET_XFLG () ? 1 : 0)) & 0x300) > 0xFF);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* SBCD.B -(An),-(An) */
void REGPARAM2 CPUFUNC(op_8108_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
	/* op H:2,T:1,C:10 */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	/* op H:2,T:1,C:10 */
{	uae_u16 newv_lo = (dst & 0xF) - (src & 0xF) - (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = (dst & 0xF0) - (src & 0xF0);
	uae_u16 newv, tmp_newv;
	int bcd = 0;
	newv = tmp_newv = newv_hi + newv_lo;
	if (newv_lo & 0xF0) { newv -= 6; bcd = 6; };
	if ((((dst & 0xFF) - (src & 0xFF) - (GET_XFLG () ? 1 : 0)) & 0x100) > 0xFF) { newv -= 0x60; }
	SET_CFLG ((((dst & 0xFF) - (src & 0xFF) - bcd - (GET_XFLG () ? 1 : 0)) & 0x300) > 0xFF);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (11);
	x_put_byte (dsta, newv);
}}}}}}	m68k_incpci (2);
return;
}

/* OR.B Dn,(An) */
void REGPARAM2 CPUFUNC(op_8110_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (2);
return;
}

/* OR.B Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_8118_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (2);
return;
}

/* OR.B Dn,-(An) */
void REGPARAM2 CPUFUNC(op_8120_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (2);
return;
}

/* OR.B Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_8128_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* OR.B Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_8130_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}}return;
}

/* OR.B Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_8138_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* OR.B Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_8139_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* PACK.L Dn,Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_8140_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uae_u16 val = m68k_dreg (regs, srcreg) + get_word_ce030_prefetch (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & 0xffffff00) | ((val >> 4) & 0xf0) | (val & 0xf);
	regs.irc = get_word_ce030_prefetch (4);
}	m68k_incpci (4);
return;
}

#endif
/* PACK.L -(An),-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_8148_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uae_u16 val;
	m68k_areg (regs, srcreg) -= areg_byteinc[srcreg];
	val = (uae_u16)(x_get_byte (m68k_areg (regs, srcreg)) & 0xff);
	m68k_areg (regs, srcreg) -= areg_byteinc[srcreg];
	val = (val | ((uae_u16)(x_get_byte (m68k_areg (regs, srcreg)) & 0xff) << 8)) + get_word_ce030_prefetch (2);
	m68k_areg (regs, dstreg) -= areg_byteinc[dstreg];
	x_put_byte (m68k_areg (regs, dstreg),((val >> 4) & 0xf0) | (val & 0xf));
	regs.irc = get_word_ce030_prefetch (4);
}	m68k_incpci (4);
return;
}

#endif
/* OR.W Dn,(An) */
void REGPARAM2 CPUFUNC(op_8150_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (2);
return;
}

/* OR.W Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_8158_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (2);
return;
}

/* OR.W Dn,-(An) */
void REGPARAM2 CPUFUNC(op_8160_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (2);
return;
}

/* OR.W Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_8168_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* OR.W Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_8170_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}}return;
}

/* OR.W Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_8178_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* OR.W Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_8179_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* UNPK.L Dn,Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_8180_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uae_u16 val = m68k_dreg (regs, srcreg);
	val = (((val << 4) & 0xf00) | (val & 0xf)) + get_word_ce030_prefetch (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & 0xffff0000) | (val & 0xffff);
	regs.irc = get_word_ce030_prefetch (4);
}	m68k_incpci (4);
return;
}

#endif
/* UNPK.L -(An),-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_8188_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uae_u16 val;
	m68k_areg (regs, srcreg) -= areg_byteinc[srcreg];
	val = (uae_u16)(x_get_byte (m68k_areg (regs, srcreg)) & 0xff);
	val = (((val << 4) & 0xf00) | (val & 0xf)) + get_word_ce030_prefetch (2);
	m68k_areg (regs, dstreg) -= 2 * areg_byteinc[dstreg];
	x_put_byte (m68k_areg (regs, dstreg) + areg_byteinc[dstreg], val);
	x_put_byte (m68k_areg (regs, dstreg), val >> 8);
	regs.irc = get_word_ce030_prefetch (4);
}	m68k_incpci (4);
return;
}

#endif
/* OR.L Dn,(An) */
void REGPARAM2 CPUFUNC(op_8190_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (2);
return;
}

/* OR.L Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_8198_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (2);
return;
}

/* OR.L Dn,-(An) */
void REGPARAM2 CPUFUNC(op_81a0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (2);
return;
}

/* OR.L Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_81a8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* OR.L Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_81b0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}}return;
}

/* OR.L Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_81b8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* OR.L Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_81b9_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* DIVS.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_81c0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:52 */
	if (src == 0) {
		divbyzero_special (1, dst);
	m68k_incpci (2);
		Exception (5);
		goto l_231278;
	}
	CLEAR_CZNV ();
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	m68k_incpci (2);
	regs.irc = get_word_ce030_prefetch (0);
	do_cycles_ce020_internal (52);
}}}l_231278: ;
return;
}

/* DIVS.W (An),Dn */
void REGPARAM2 CPUFUNC(op_81d0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:54 */
	if (src == 0) {
		divbyzero_special (1, dst);
	m68k_incpci (2);
		Exception (5);
		goto l_231279;
	}
	CLEAR_CZNV ();
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	m68k_incpci (2);
	do_cycles_ce020_internal (52);
}}}}l_231279: ;
return;
}

/* DIVS.W (An)+,Dn */
void REGPARAM2 CPUFUNC(op_81d8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:54 */
	if (src == 0) {
		divbyzero_special (1, dst);
	m68k_incpci (2);
		Exception (5);
		goto l_231280;
	}
	CLEAR_CZNV ();
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	m68k_incpci (2);
	do_cycles_ce020_internal (52);
}}}}l_231280: ;
return;
}

/* DIVS.W -(An),Dn */
void REGPARAM2 CPUFUNC(op_81e0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:54 */
	if (src == 0) {
		divbyzero_special (1, dst);
	m68k_incpci (2);
		Exception (5);
		goto l_231281;
	}
	CLEAR_CZNV ();
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	m68k_incpci (2);
	do_cycles_ce020_internal (52);
}}}}l_231281: ;
return;
}

/* DIVS.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_81e8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:54 */
	if (src == 0) {
		divbyzero_special (1, dst);
	m68k_incpci (4);
		Exception (5);
		goto l_231282;
	}
	CLEAR_CZNV ();
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	m68k_incpci (4);
	do_cycles_ce020_internal (52);
}}}}l_231282: ;
return;
}

/* DIVS.W (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_81f0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:54 */
	if (src == 0) {
		divbyzero_special (1, dst);
	m68k_incpci (0);
		Exception (5);
		goto l_231283;
	}
	CLEAR_CZNV ();
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	do_cycles_ce020_internal (52);
}}}}}l_231283: ;
return;
}

/* DIVS.W (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_81f8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:54 */
	if (src == 0) {
		divbyzero_special (1, dst);
	m68k_incpci (4);
		Exception (5);
		goto l_231284;
	}
	CLEAR_CZNV ();
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	m68k_incpci (4);
	do_cycles_ce020_internal (52);
}}}}l_231284: ;
return;
}

/* DIVS.W (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_81f9_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:54 */
	if (src == 0) {
		divbyzero_special (1, dst);
	m68k_incpci (6);
		Exception (5);
		goto l_231285;
	}
	CLEAR_CZNV ();
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	m68k_incpci (6);
	do_cycles_ce020_internal (52);
}}}}l_231285: ;
return;
}

/* DIVS.W (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_81fa_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:54 */
	if (src == 0) {
		divbyzero_special (1, dst);
	m68k_incpci (4);
		Exception (5);
		goto l_231286;
	}
	CLEAR_CZNV ();
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	m68k_incpci (4);
	do_cycles_ce020_internal (52);
}}}}l_231286: ;
return;
}

/* DIVS.W (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_81fb_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:54 */
	if (src == 0) {
		divbyzero_special (1, dst);
	m68k_incpci (0);
		Exception (5);
		goto l_231287;
	}
	CLEAR_CZNV ();
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	do_cycles_ce020_internal (52);
}}}}}l_231287: ;
return;
}

/* DIVS.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_81fc_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:54 */
	if (src == 0) {
		divbyzero_special (1, dst);
	m68k_incpci (4);
		Exception (5);
		goto l_231288;
	}
	CLEAR_CZNV ();
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	m68k_incpci (4);
	do_cycles_ce020_internal (52);
}}}l_231288: ;
return;
}

/* SUB.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_9000_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpci (2);
return;
}

/* SUB.B (An),Dn */
void REGPARAM2 CPUFUNC(op_9010_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.B (An)+,Dn */
void REGPARAM2 CPUFUNC(op_9018_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.B -(An),Dn */
void REGPARAM2 CPUFUNC(op_9020_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.B (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_9028_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.B (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_9030_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}}return;
}

/* SUB.B (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_9038_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.B (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_9039_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (6);
return;
}

/* SUB.B (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_903a_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.B (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_903b_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}}return;
}

/* SUB.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_903c_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpci (4);
return;
}

/* SUB.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_9040_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpci (2);
return;
}

/* SUB.W An,Dn */
void REGPARAM2 CPUFUNC(op_9048_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s16 src = m68k_areg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpci (2);
return;
}

/* SUB.W (An),Dn */
void REGPARAM2 CPUFUNC(op_9050_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.W (An)+,Dn */
void REGPARAM2 CPUFUNC(op_9058_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.W -(An),Dn */
void REGPARAM2 CPUFUNC(op_9060_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_9068_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.W (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_9070_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}return;
}

/* SUB.W (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_9078_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.W (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_9079_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}	m68k_incpci (6);
return;
}

/* SUB.W (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_907a_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.W (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_907b_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}return;
}

/* SUB.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_907c_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpci (4);
return;
}

/* SUB.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_9080_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
return;
}

/* SUB.L An,Dn */
void REGPARAM2 CPUFUNC(op_9088_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s32 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
return;
}

/* SUB.L (An),Dn */
void REGPARAM2 CPUFUNC(op_9090_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.L (An)+,Dn */
void REGPARAM2 CPUFUNC(op_9098_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.L -(An),Dn */
void REGPARAM2 CPUFUNC(op_90a0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.L (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_90a8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.L (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_90b0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}return;
}

/* SUB.L (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_90b8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.L (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_90b9_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* SUB.L (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_90ba_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.L (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_90bb_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}return;
}

/* SUB.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_90bc_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (6);
return;
}

/* SUBA.W Dn,An */
void REGPARAM2 CPUFUNC(op_90c0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	/* op H:4,T:0,C:0 */
{	uae_u32 newv = dst - src;
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (2);
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return;
}

/* SUBA.W An,An */
void REGPARAM2 CPUFUNC(op_90c8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s16 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	/* op H:4,T:0,C:0 */
{	uae_u32 newv = dst - src;
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (2);
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return;
}

/* SUBA.W (An),An */
void REGPARAM2 CPUFUNC(op_90d0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uae_u32 newv = dst - src;
	do_cycles_ce020_internal (2);
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpci (2);
return;
}

/* SUBA.W (An)+,An */
void REGPARAM2 CPUFUNC(op_90d8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uae_u32 newv = dst - src;
	do_cycles_ce020_internal (2);
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpci (2);
return;
}

/* SUBA.W -(An),An */
void REGPARAM2 CPUFUNC(op_90e0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uae_u32 newv = dst - src;
	do_cycles_ce020_internal (2);
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpci (2);
return;
}

/* SUBA.W (d16,An),An */
void REGPARAM2 CPUFUNC(op_90e8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uae_u32 newv = dst - src;
	do_cycles_ce020_internal (2);
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpci (4);
return;
}

/* SUBA.W (d8,An,Xn),An */
void REGPARAM2 CPUFUNC(op_90f0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uae_u32 newv = dst - src;
	do_cycles_ce020_internal (2);
	m68k_areg (regs, dstreg) = (newv);
}}}}}}return;
}

/* SUBA.W (xxx).W,An */
void REGPARAM2 CPUFUNC(op_90f8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uae_u32 newv = dst - src;
	do_cycles_ce020_internal (2);
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpci (4);
return;
}

/* SUBA.W (xxx).L,An */
void REGPARAM2 CPUFUNC(op_90f9_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uae_u32 newv = dst - src;
	do_cycles_ce020_internal (2);
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpci (6);
return;
}

/* SUBA.W (d16,PC),An */
void REGPARAM2 CPUFUNC(op_90fa_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uae_u32 newv = dst - src;
	do_cycles_ce020_internal (2);
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpci (4);
return;
}

/* SUBA.W (d8,PC,Xn),An */
void REGPARAM2 CPUFUNC(op_90fb_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uae_u32 newv = dst - src;
	do_cycles_ce020_internal (2);
	m68k_areg (regs, dstreg) = (newv);
}}}}}}return;
}

/* SUBA.W #<data>.W,An */
void REGPARAM2 CPUFUNC(op_90fc_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uae_u32 newv = dst - src;
	do_cycles_ce020_internal (2);
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (4);
return;
}

/* SUBX.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_9100_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
	/* op H:2,T:0,C:0 */
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{	uae_u32 newv = dst - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}	m68k_incpci (2);
return;
}

/* SUBX.B -(An),-(An) */
void REGPARAM2 CPUFUNC(op_9108_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
	/* op H:2,T:1,C:6 */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	/* op H:2,T:1,C:6 */
{	uae_u32 newv = dst - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (7);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.B Dn,(An) */
void REGPARAM2 CPUFUNC(op_9110_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.B Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_9118_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.B Dn,-(An) */
void REGPARAM2 CPUFUNC(op_9120_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.B Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_9128_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.B Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_9130_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}}return;
}

/* SUB.B Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_9138_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.B Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_9139_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* SUBX.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_9140_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	/* op H:2,T:0,C:0 */
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{	uae_u32 newv = dst - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}	m68k_incpci (2);
return;
}

/* SUBX.W -(An),-(An) */
void REGPARAM2 CPUFUNC(op_9148_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
	/* op H:2,T:1,C:6 */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	/* op H:2,T:1,C:6 */
{	uae_u32 newv = dst - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (7);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.W Dn,(An) */
void REGPARAM2 CPUFUNC(op_9150_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.W Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_9158_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.W Dn,-(An) */
void REGPARAM2 CPUFUNC(op_9160_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.W Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_9168_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.W Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_9170_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}}return;
}

/* SUB.W Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_9178_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.W Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_9179_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* SUBX.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_9180_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	/* op H:2,T:0,C:0 */
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{	uae_u32 newv = dst - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}	m68k_incpci (2);
return;
}

/* SUBX.L -(An),-(An) */
void REGPARAM2 CPUFUNC(op_9188_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
	/* op H:2,T:1,C:6 */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
	/* op H:2,T:1,C:6 */
{	uae_u32 newv = dst - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (7);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.L Dn,(An) */
void REGPARAM2 CPUFUNC(op_9190_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.L Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_9198_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.L Dn,-(An) */
void REGPARAM2 CPUFUNC(op_91a0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.L Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_91a8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.L Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_91b0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}}return;
}

/* SUB.L Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_91b8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.L Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_91b9_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* SUBA.L Dn,An */
void REGPARAM2 CPUFUNC(op_91c0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{	uae_u32 newv = dst - src;
	regs.irc = get_word_ce030_prefetch (2);
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return;
}

/* SUBA.L An,An */
void REGPARAM2 CPUFUNC(op_91c8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s32 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{	uae_u32 newv = dst - src;
	regs.irc = get_word_ce030_prefetch (2);
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return;
}

/* SUBA.L (An),An */
void REGPARAM2 CPUFUNC(op_91d0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpci (2);
return;
}

/* SUBA.L (An)+,An */
void REGPARAM2 CPUFUNC(op_91d8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpci (2);
return;
}

/* SUBA.L -(An),An */
void REGPARAM2 CPUFUNC(op_91e0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpci (2);
return;
}

/* SUBA.L (d16,An),An */
void REGPARAM2 CPUFUNC(op_91e8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpci (4);
return;
}

/* SUBA.L (d8,An,Xn),An */
void REGPARAM2 CPUFUNC(op_91f0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}return;
}

/* SUBA.L (xxx).W,An */
void REGPARAM2 CPUFUNC(op_91f8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpci (4);
return;
}

/* SUBA.L (xxx).L,An */
void REGPARAM2 CPUFUNC(op_91f9_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpci (6);
return;
}

/* SUBA.L (d16,PC),An */
void REGPARAM2 CPUFUNC(op_91fa_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpci (4);
return;
}

/* SUBA.L (d8,PC,Xn),An */
void REGPARAM2 CPUFUNC(op_91fb_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}return;
}

/* SUBA.L #<data>.L,An */
void REGPARAM2 CPUFUNC(op_91fc_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (6);
return;
}

/* CMP.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_b000_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce030_prefetch (2);
}}}}}}	m68k_incpci (2);
return;
}

/* CMP.B (An),Dn */
void REGPARAM2 CPUFUNC(op_b010_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (2);
return;
}

/* CMP.B (An)+,Dn */
void REGPARAM2 CPUFUNC(op_b018_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (2);
return;
}

/* CMP.B -(An),Dn */
void REGPARAM2 CPUFUNC(op_b020_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (2);
return;
}

/* CMP.B (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_b028_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMP.B (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_b030_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}return;
}

/* CMP.B (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_b038_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMP.B (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_b039_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (6);
return;
}

/* CMP.B (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_b03a_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMP.B (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_b03b_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}return;
}

/* CMP.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_b03c_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}	m68k_incpci (4);
return;
}

/* CMP.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_b040_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce030_prefetch (2);
}}}}}}	m68k_incpci (2);
return;
}

/* CMP.W An,Dn */
void REGPARAM2 CPUFUNC(op_b048_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s16 src = m68k_areg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce030_prefetch (2);
}}}}}}	m68k_incpci (2);
return;
}

/* CMP.W (An),Dn */
void REGPARAM2 CPUFUNC(op_b050_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (2);
return;
}

/* CMP.W (An)+,Dn */
void REGPARAM2 CPUFUNC(op_b058_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (2);
return;
}

/* CMP.W -(An),Dn */
void REGPARAM2 CPUFUNC(op_b060_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (2);
return;
}

/* CMP.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_b068_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMP.W (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_b070_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}return;
}

/* CMP.W (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_b078_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMP.W (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_b079_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (6);
return;
}

/* CMP.W (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_b07a_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMP.W (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_b07b_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}return;
}

/* CMP.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_b07c_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}	m68k_incpci (4);
return;
}

/* CMP.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_b080_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce030_prefetch (2);
}}}}}}	m68k_incpci (2);
return;
}

/* CMP.L An,Dn */
void REGPARAM2 CPUFUNC(op_b088_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s32 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce030_prefetch (2);
}}}}}}	m68k_incpci (2);
return;
}

/* CMP.L (An),Dn */
void REGPARAM2 CPUFUNC(op_b090_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (2);
return;
}

/* CMP.L (An)+,Dn */
void REGPARAM2 CPUFUNC(op_b098_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (2);
return;
}

/* CMP.L -(An),Dn */
void REGPARAM2 CPUFUNC(op_b0a0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (2);
return;
}

#endif

#ifdef PART_7
/* CMP.L (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_b0a8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMP.L (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_b0b0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}return;
}

/* CMP.L (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_b0b8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMP.L (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_b0b9_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (6);
return;
}

/* CMP.L (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_b0ba_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMP.L (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_b0bb_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}return;
}

/* CMP.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_b0bc_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}	m68k_incpci (6);
return;
}

/* CMPA.W Dn,An */
void REGPARAM2 CPUFUNC(op_b0c0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	/* op H:4,T:0,C:0 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (2);
}}}}}}	m68k_incpci (2);
return;
}

/* CMPA.W An,An */
void REGPARAM2 CPUFUNC(op_b0c8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s16 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	/* op H:4,T:0,C:0 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (2);
}}}}}}	m68k_incpci (2);
return;
}

/* CMPA.W (An),An */
void REGPARAM2 CPUFUNC(op_b0d0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (2);
}}}}}}}	m68k_incpci (2);
return;
}

/* CMPA.W (An)+,An */
void REGPARAM2 CPUFUNC(op_b0d8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (2);
}}}}}}}	m68k_incpci (2);
return;
}

/* CMPA.W -(An),An */
void REGPARAM2 CPUFUNC(op_b0e0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (2);
}}}}}}}	m68k_incpci (2);
return;
}

/* CMPA.W (d16,An),An */
void REGPARAM2 CPUFUNC(op_b0e8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (2);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMPA.W (d8,An,Xn),An */
void REGPARAM2 CPUFUNC(op_b0f0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (2);
}}}}}}}}return;
}

/* CMPA.W (xxx).W,An */
void REGPARAM2 CPUFUNC(op_b0f8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (2);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMPA.W (xxx).L,An */
void REGPARAM2 CPUFUNC(op_b0f9_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (2);
}}}}}}}	m68k_incpci (6);
return;
}

/* CMPA.W (d16,PC),An */
void REGPARAM2 CPUFUNC(op_b0fa_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (2);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMPA.W (d8,PC,Xn),An */
void REGPARAM2 CPUFUNC(op_b0fb_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (2);
}}}}}}}}return;
}

/* CMPA.W #<data>.W,An */
void REGPARAM2 CPUFUNC(op_b0fc_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (2);
}}}}}}	m68k_incpci (4);
return;
}

/* EOR.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_b100_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpci (2);
return;
}

/* CMPM.B (An)+,(An)+ */
void REGPARAM2 CPUFUNC(op_b108_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	/* op H:0,T:0,C:8 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (6);
}}}}}}}}	m68k_incpci (2);
return;
}

/* EOR.B Dn,(An) */
void REGPARAM2 CPUFUNC(op_b110_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (2);
return;
}

/* EOR.B Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_b118_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (2);
return;
}

/* EOR.B Dn,-(An) */
void REGPARAM2 CPUFUNC(op_b120_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (2);
return;
}

/* EOR.B Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_b128_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* EOR.B Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_b130_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}}return;
}

/* EOR.B Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_b138_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* EOR.B Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_b139_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* EOR.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_b140_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpci (2);
return;
}

/* CMPM.W (An)+,(An)+ */
void REGPARAM2 CPUFUNC(op_b148_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
	/* op H:0,T:0,C:8 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (6);
}}}}}}}}	m68k_incpci (2);
return;
}

/* EOR.W Dn,(An) */
void REGPARAM2 CPUFUNC(op_b150_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (2);
return;
}

/* EOR.W Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_b158_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (2);
return;
}

/* EOR.W Dn,-(An) */
void REGPARAM2 CPUFUNC(op_b160_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (2);
return;
}

/* EOR.W Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_b168_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* EOR.W Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_b170_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}}return;
}

/* EOR.W Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_b178_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* EOR.W Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_b179_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* EOR.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_b180_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.irc = get_word_ce030_prefetch (2);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpci (2);
return;
}

/* CMPM.L (An)+,(An)+ */
void REGPARAM2 CPUFUNC(op_b188_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
	/* op H:0,T:0,C:8 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (6);
}}}}}}}}	m68k_incpci (2);
return;
}

/* EOR.L Dn,(An) */
void REGPARAM2 CPUFUNC(op_b190_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (2);
return;
}

/* EOR.L Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_b198_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (2);
return;
}

/* EOR.L Dn,-(An) */
void REGPARAM2 CPUFUNC(op_b1a0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (2);
return;
}

/* EOR.L Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_b1a8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* EOR.L Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_b1b0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce030 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}}return;
}

/* EOR.L Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_b1b8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* EOR.L Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_b1b9_23)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_long_ce030_prefetch (2);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* CMPA.L Dn,An */
void REGPARAM2 CPUFUNC(op_b1c0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	/* op H:4,T:0,C:0 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (2);
}}}}}}	m68k_incpci (2);
return;
}

/* CMPA.L An,An */
void REGPARAM2 CPUFUNC(op_b1c8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s32 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	/* op H:4,T:0,C:0 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (2);
}}}}}}	m68k_incpci (2);
return;
}

/* CMPA.L (An),An */
void REGPARAM2 CPUFUNC(op_b1d0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (2);
}}}}}}}	m68k_incpci (2);
return;
}

/* CMPA.L (An)+,An */
void REGPARAM2 CPUFUNC(op_b1d8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (2);
}}}}}}}	m68k_incpci (2);
return;
}

/* CMPA.L -(An),An */
void REGPARAM2 CPUFUNC(op_b1e0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (2);
}}}}}}}	m68k_incpci (2);
return;
}

/* CMPA.L (d16,An),An */
void REGPARAM2 CPUFUNC(op_b1e8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (2);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMPA.L (d8,An,Xn),An */
void REGPARAM2 CPUFUNC(op_b1f0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (2);
}}}}}}}}return;
}

/* CMPA.L (xxx).W,An */
void REGPARAM2 CPUFUNC(op_b1f8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (2);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMPA.L (xxx).L,An */
void REGPARAM2 CPUFUNC(op_b1f9_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (2);
}}}}}}}	m68k_incpci (6);
return;
}

/* CMPA.L (d16,PC),An */
void REGPARAM2 CPUFUNC(op_b1fa_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (2);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMPA.L (d8,PC,Xn),An */
void REGPARAM2 CPUFUNC(op_b1fb_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (2);
}}}}}}}}return;
}

/* CMPA.L #<data>.L,An */
void REGPARAM2 CPUFUNC(op_b1fc_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (2);
}}}}}}	m68k_incpci (6);
return;
}

/* AND.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_c000_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:0 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpci (2);
return;
}

/* AND.B (An),Dn */
void REGPARAM2 CPUFUNC(op_c010_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* AND.B (An)+,Dn */
void REGPARAM2 CPUFUNC(op_c018_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* AND.B -(An),Dn */
void REGPARAM2 CPUFUNC(op_c020_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* AND.B (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_c028_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (4);
return;
}

/* AND.B (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_c030_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}}return;
}

/* AND.B (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_c038_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (4);
return;
}

/* AND.B (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_c039_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (6);
return;
}

/* AND.B (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_c03a_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (4);
return;
}

/* AND.B (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_c03b_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}}return;
}

/* AND.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_c03c_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s8 src = (uae_u8)get_word_ce030_prefetch (2);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpci (4);
return;
}

/* AND.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_c040_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:0 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpci (2);
return;
}

/* AND.W (An),Dn */
void REGPARAM2 CPUFUNC(op_c050_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpci (2);
return;
}

/* AND.W (An)+,Dn */
void REGPARAM2 CPUFUNC(op_c058_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpci (2);
return;
}

/* AND.W -(An),Dn */
void REGPARAM2 CPUFUNC(op_c060_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpci (2);
return;
}

/* AND.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_c068_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpci (4);
return;
}

/* AND.W (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_c070_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}return;
}

/* AND.W (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_c078_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpci (4);
return;
}

/* AND.W (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_c079_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpci (6);
return;
}

/* AND.W (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_c07a_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpci (4);
return;
}

/* AND.W (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_c07b_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}return;
}

/* AND.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_c07c_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpci (4);
return;
}

/* AND.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_c080_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:0 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpci (2);
return;
}

/* AND.L (An),Dn */
void REGPARAM2 CPUFUNC(op_c090_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpci (2);
return;
}

/* AND.L (An)+,Dn */
void REGPARAM2 CPUFUNC(op_c098_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpci (2);
return;
}

/* AND.L -(An),Dn */
void REGPARAM2 CPUFUNC(op_c0a0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpci (2);
return;
}

/* AND.L (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_c0a8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpci (4);
return;
}

/* AND.L (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_c0b0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (src);
}}}}}return;
}

/* AND.L (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_c0b8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpci (4);
return;
}

/* AND.L (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_c0b9_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpci (6);
return;
}

/* AND.L (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_c0ba_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpci (4);
return;
}

/* AND.L (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_c0bb_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (src);
}}}}}return;
}

/* AND.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_c0bc_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s32 src;
	src = get_long_ce030_prefetch (2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpci (6);
return;
}

/* MULU.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_c0c0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:23 */
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	do_cycles_ce020_internal (23);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpci (2);
}}}}return;
}

/* MULU.W (An),Dn */
void REGPARAM2 CPUFUNC(op_c0d0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:23 */
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	do_cycles_ce020_internal (23);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpci (2);
}}}}}return;
}

/* MULU.W (An)+,Dn */
void REGPARAM2 CPUFUNC(op_c0d8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:23 */
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	do_cycles_ce020_internal (23);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpci (2);
}}}}}return;
}

/* MULU.W -(An),Dn */
void REGPARAM2 CPUFUNC(op_c0e0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:23 */
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	do_cycles_ce020_internal (23);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpci (2);
}}}}}return;
}

/* MULU.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_c0e8_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:23 */
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	do_cycles_ce020_internal (23);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpci (4);
}}}}}return;
}

/* MULU.W (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_c0f0_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce030 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:23 */
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	do_cycles_ce020_internal (23);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}return;
}

/* MULU.W (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_c0f8_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:23 */
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	do_cycles_ce020_internal (23);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpci (4);
}}}}}return;
}

/* MULU.W (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_c0f9_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:23 */
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	do_cycles_ce020_internal (23);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpci (6);
}}}}}return;
}

/* MULU.W (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_c0fa_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:23 */
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	do_cycles_ce020_internal (23);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpci (4);
}}}}}return;
}

/* MULU.W (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_c0fb_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce030 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (0);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:23 */
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	do_cycles_ce020_internal (23);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}return;
}

/* MULU.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_c0fc_23)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = get_word_ce030_prefetch (2);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce030_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:23 */
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	do_cycles_ce020_internal (23);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpci (4);
}}}}return;
}

/* ABCD.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_c100_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
	/* op H:0,T:0,C:4 */
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	/* op H:0,T:0,C:4 */
{	uae_u16 newv_lo = (src & 0xF) + (dst & 0xF) + (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = (src & 0xF0) + (dst & 0xF0);
	uae_u16 newv, tmp_newv;
	int cflg;
	newv = tmp_newv = newv_hi + newv_lo;	if (newv_lo > 9) { newv += 6; }
	cflg = (newv & 0x3F0) > 0x90;
	if (cflg) newv += 0x60;
	SET_CFLG (cflg);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) == 0 && (newv & 0x80) != 0);
	regs.irc = get_word_ce030_prefetch (2);
	do_cycles_ce020_internal (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* ABCD.B -(An),-(An) */
void REGPARAM2 CPUFUNC(op_c108_23)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
	/* op H:2,T:1,C:10 */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	/* op H:2,T:1,C:10 *