/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-intel-cvs-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

/**
 * fu_intel_cvs_device_state_to_string:
 * @val: value, e.g. %FU_INTEL_CVS_DEVICE_STATE_PRIVACY_ON
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 *
 **/
static gchar *
fu_intel_cvs_device_state_to_string(FuIntelCvsDeviceState val)
{
    const gchar *data[7] = {0};
    guint idx = 0;
    if (val == FU_INTEL_CVS_DEVICE_STATE_DEVICE_OFF)
        return g_strdup("device-off");
    if (val & FU_INTEL_CVS_DEVICE_STATE_PRIVACY_ON)
        data[idx++] = "privacy-on";
    if (val & FU_INTEL_CVS_DEVICE_STATE_DEVICE_ON)
        data[idx++] = "device-on";
    if (val & FU_INTEL_CVS_DEVICE_STATE_SENSOR_OWNER)
        data[idx++] = "sensor-owner";
    if (val & FU_INTEL_CVS_DEVICE_STATE_DEVICE_DWNLD_STATE)
        data[idx++] = "device-dwnld-state";
    if (val & FU_INTEL_CVS_DEVICE_STATE_DEVICE_DWNLD_ERROR)
        data[idx++] = "device-dwnld-error";
    if (val & FU_INTEL_CVS_DEVICE_STATE_DEVICE_DWNLD_BUSY)
        data[idx++] = "device-dwnld-busy";
    return g_strjoinv(",", (gchar **)data);
}




/**
 * fu_struct_intel_cvs_dev_capability_to_string:
 * @val: value, e.g. %FU_STRUCT_INTEL_CVS_DEV_CAPABILITY_NOCAMERA_DURING_FWUPDATE
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 *
 **/
static gchar *
fu_struct_intel_cvs_dev_capability_to_string(FuStructIntelCvsDevCapability val)
{
    const gchar *data[6] = {0};
    guint idx = 0;
    if (val == FU_STRUCT_INTEL_CVS_DEV_CAPABILITY_CV_POWER_DOMAIN)
        return g_strdup("cv-power-domain");
    if (val & FU_STRUCT_INTEL_CVS_DEV_CAPABILITY_NOCAMERA_DURING_FWUPDATE)
        data[idx++] = "nocamera-during-fwupdate";
    if (val & FU_STRUCT_INTEL_CVS_DEV_CAPABILITY_FWUPDATE_RESET_REQUIRED)
        data[idx++] = "fwupdate-reset-required";
    if (val & FU_STRUCT_INTEL_CVS_DEV_CAPABILITY_PRIVACY2VISIONDRIVER)
        data[idx++] = "privacy2visiondriver";
    if (val & FU_STRUCT_INTEL_CVS_DEV_CAPABILITY_FW_ANTIROLLBACK)
        data[idx++] = "fw-antirollback";
    if (val & FU_STRUCT_INTEL_CVS_DEV_CAPABILITY_HOST_MIPI_CONFIG_REQUIRED)
        data[idx++] = "host-mipi-config-required";
    return g_strjoinv(",", (gchar **)data);
}
/**
 * fu_struct_intel_cvs_fw_ref: (skip):
 **/
FuStructIntelCvsFw *
fu_struct_intel_cvs_fw_ref(FuStructIntelCvsFw *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_intel_cvs_fw_unref: (skip):
 **/
void
fu_struct_intel_cvs_fw_unref(FuStructIntelCvsFw *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructIntelCvsFw refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_intel_cvs_fw_new_internal: (skip):
 **/
static FuStructIntelCvsFw *
fu_struct_intel_cvs_fw_new_internal(void)
{
    FuStructIntelCvsFw *st = g_new0(FuStructIntelCvsFw, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_intel_cvs_fw_get_major: (skip):
 **/
guint32
fu_struct_intel_cvs_fw_get_major(const FuStructIntelCvsFw *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_intel_cvs_fw_get_minor: (skip):
 **/
guint32
fu_struct_intel_cvs_fw_get_minor(const FuStructIntelCvsFw *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_intel_cvs_fw_get_hotfix: (skip):
 **/
guint32
fu_struct_intel_cvs_fw_get_hotfix(const FuStructIntelCvsFw *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_intel_cvs_fw_get_build: (skip):
 **/
guint32
fu_struct_intel_cvs_fw_get_build(const FuStructIntelCvsFw *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 12, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_intel_cvs_fw_to_string: (skip):
 **/
static gchar *
fu_struct_intel_cvs_fw_to_string(const FuStructIntelCvsFw *st)
{
    g_autoptr(GString) str = g_string_new("FuStructIntelCvsFw:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  major: 0x%x\n",
                           (guint) fu_struct_intel_cvs_fw_get_major(st));
    g_string_append_printf(str, "  minor: 0x%x\n",
                           (guint) fu_struct_intel_cvs_fw_get_minor(st));
    g_string_append_printf(str, "  hotfix: 0x%x\n",
                           (guint) fu_struct_intel_cvs_fw_get_hotfix(st));
    g_string_append_printf(str, "  build: 0x%x\n",
                           (guint) fu_struct_intel_cvs_fw_get_build(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_intel_cvs_fw_validate_internal(FuStructIntelCvsFw *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
/**
 * fu_struct_intel_cvs_id_ref: (skip):
 **/
FuStructIntelCvsId *
fu_struct_intel_cvs_id_ref(FuStructIntelCvsId *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_intel_cvs_id_unref: (skip):
 **/
void
fu_struct_intel_cvs_id_unref(FuStructIntelCvsId *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructIntelCvsId refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_intel_cvs_id_new_internal: (skip):
 **/
static FuStructIntelCvsId *
fu_struct_intel_cvs_id_new_internal(void)
{
    FuStructIntelCvsId *st = g_new0(FuStructIntelCvsId, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_intel_cvs_id_get_vid: (skip):
 **/
guint16
fu_struct_intel_cvs_id_get_vid(const FuStructIntelCvsId *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_intel_cvs_id_get_pid: (skip):
 **/
guint16
fu_struct_intel_cvs_id_get_pid(const FuStructIntelCvsId *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 2, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_intel_cvs_id_to_string: (skip):
 **/
static gchar *
fu_struct_intel_cvs_id_to_string(const FuStructIntelCvsId *st)
{
    g_autoptr(GString) str = g_string_new("FuStructIntelCvsId:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  vid: 0x%x\n",
                           (guint) fu_struct_intel_cvs_id_get_vid(st));
    g_string_append_printf(str, "  pid: 0x%x\n",
                           (guint) fu_struct_intel_cvs_id_get_pid(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_intel_cvs_id_validate_internal(FuStructIntelCvsId *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
/**
 * fu_struct_intel_cvs_firmware_hdr_ref: (skip):
 **/
FuStructIntelCvsFirmwareHdr *
fu_struct_intel_cvs_firmware_hdr_ref(FuStructIntelCvsFirmwareHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_intel_cvs_firmware_hdr_unref: (skip):
 **/
void
fu_struct_intel_cvs_firmware_hdr_unref(FuStructIntelCvsFirmwareHdr *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructIntelCvsFirmwareHdr refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_intel_cvs_firmware_hdr_new_internal: (skip):
 **/
static FuStructIntelCvsFirmwareHdr *
fu_struct_intel_cvs_firmware_hdr_new_internal(void)
{
    FuStructIntelCvsFirmwareHdr *st = g_new0(FuStructIntelCvsFirmwareHdr, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_intel_cvs_firmware_hdr_get_magic_number: (skip):
 **/
static gchar *
fu_struct_intel_cvs_firmware_hdr_get_magic_number(const FuStructIntelCvsFirmwareHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 0, 8, NULL);
}
/**
 * fu_struct_intel_cvs_firmware_hdr_get_fw_version: (skip):
 **/
FuStructIntelCvsFw *
fu_struct_intel_cvs_firmware_hdr_get_fw_version(const FuStructIntelCvsFirmwareHdr *st)
{
    g_autoptr(FuStructIntelCvsFw) st_tmp = fu_struct_intel_cvs_fw_new_internal();
    g_return_val_if_fail(st != NULL, NULL);
    st_tmp->buf = g_byte_array_new();
    g_byte_array_append(st_tmp->buf, st->buf->data + FU_STRUCT_INTEL_CVS_FIRMWARE_HDR_OFFSET_FW_VERSION, 16);
    return g_steal_pointer(&st_tmp);
}
/**
 * fu_struct_intel_cvs_firmware_hdr_get_vid_pid: (skip):
 **/
FuStructIntelCvsId *
fu_struct_intel_cvs_firmware_hdr_get_vid_pid(const FuStructIntelCvsFirmwareHdr *st)
{
    g_autoptr(FuStructIntelCvsId) st_tmp = fu_struct_intel_cvs_id_new_internal();
    g_return_val_if_fail(st != NULL, NULL);
    st_tmp->buf = g_byte_array_new();
    g_byte_array_append(st_tmp->buf, st->buf->data + FU_STRUCT_INTEL_CVS_FIRMWARE_HDR_OFFSET_VID_PID, 4);
    return g_steal_pointer(&st_tmp);
}
/**
 * fu_struct_intel_cvs_firmware_hdr_get_fw_offset: (skip):
 **/
guint32
fu_struct_intel_cvs_firmware_hdr_get_fw_offset(const FuStructIntelCvsFirmwareHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 28, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_intel_cvs_firmware_hdr_get_header_checksum: (skip):
 **/
guint32
fu_struct_intel_cvs_firmware_hdr_get_header_checksum(const FuStructIntelCvsFirmwareHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 252, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_intel_cvs_firmware_hdr_to_string: (skip):
 **/
static gchar *
fu_struct_intel_cvs_firmware_hdr_to_string(const FuStructIntelCvsFirmwareHdr *st)
{
    g_autoptr(GString) str = g_string_new("FuStructIntelCvsFirmwareHdr:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autoptr(FuStructIntelCvsFw) st_tmp = fu_struct_intel_cvs_firmware_hdr_get_fw_version(st);
        g_autofree gchar *tmp = fu_struct_intel_cvs_fw_to_string(st_tmp);
        g_string_append_printf(str, "  fw_version: %s\n", tmp);
    }
    {
        g_autoptr(FuStructIntelCvsId) st_tmp = fu_struct_intel_cvs_firmware_hdr_get_vid_pid(st);
        g_autofree gchar *tmp = fu_struct_intel_cvs_id_to_string(st_tmp);
        g_string_append_printf(str, "  vid_pid: %s\n", tmp);
    }
    g_string_append_printf(str, "  fw_offset: 0x%x\n",
                           (guint) fu_struct_intel_cvs_firmware_hdr_get_fw_offset(st));
    g_string_append_printf(str, "  header_checksum: 0x%x\n",
                           (guint) fu_struct_intel_cvs_firmware_hdr_get_header_checksum(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_intel_cvs_firmware_hdr_validate_internal(FuStructIntelCvsFirmwareHdr *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (strncmp((const gchar *) (st->buf->data + 0), "VISSOCFW", 8) != 0) {
        g_autofree gchar *str = fu_struct_intel_cvs_firmware_hdr_get_magic_number(st);
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructIntelCvsFirmwareHdr.magic_number was not valid, "
                    "expected 'VISSOCFW' and got '%s'",
                    str);
        return FALSE;
    }
    {
        GByteArray buf_tmp = {
            .data = (guint8*) st->buf->data + 0x8,
            .len = 16,
        };
        FuStructIntelCvsFw st_tmp = { .buf = &buf_tmp };
        if (!fu_struct_intel_cvs_fw_validate_internal(&st_tmp, error))
            return FALSE;
    }
    {
        GByteArray buf_tmp = {
            .data = (guint8*) st->buf->data + 0x18,
            .len = 4,
        };
        FuStructIntelCvsId st_tmp = { .buf = &buf_tmp };
        if (!fu_struct_intel_cvs_id_validate_internal(&st_tmp, error))
            return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_intel_cvs_firmware_hdr_validate_stream: (skip):
 **/
gboolean
fu_struct_intel_cvs_firmware_hdr_validate_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructIntelCvsFirmwareHdr) st = fu_struct_intel_cvs_firmware_hdr_new_internal();
    g_return_val_if_fail(G_IS_INPUT_STREAM(stream), FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    st->buf = fu_input_stream_read_byte_array(stream, offset, 256, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructIntelCvsFirmwareHdr failed read of 0x%x: ", (guint) 256);
        return FALSE;
    }
    if (st->buf->len != 256) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructIntelCvsFirmwareHdr requested 0x%x and got 0x%x",
                    (guint) 256,
                    (guint) st->buf->len);
        return FALSE;
    }
    return fu_struct_intel_cvs_firmware_hdr_validate_internal(st, error);
}
static gboolean
fu_struct_intel_cvs_firmware_hdr_parse_internal(FuStructIntelCvsFirmwareHdr *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_intel_cvs_firmware_hdr_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_intel_cvs_firmware_hdr_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_intel_cvs_firmware_hdr_parse_stream: (skip):
 **/
FuStructIntelCvsFirmwareHdr *
fu_struct_intel_cvs_firmware_hdr_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructIntelCvsFirmwareHdr) st = fu_struct_intel_cvs_firmware_hdr_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 256, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructIntelCvsFirmwareHdr failed read of 0x%x: ", (guint) 256);
        return NULL;
    }
    if (st->buf->len != 256) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructIntelCvsFirmwareHdr requested 0x%x and got 0x%x",
                    (guint) 256,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_intel_cvs_firmware_hdr_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_intel_cvs_probe_ref: (skip):
 **/
FuStructIntelCvsProbe *
fu_struct_intel_cvs_probe_ref(FuStructIntelCvsProbe *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_intel_cvs_probe_unref: (skip):
 **/
void
fu_struct_intel_cvs_probe_unref(FuStructIntelCvsProbe *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructIntelCvsProbe refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_intel_cvs_probe_new_internal: (skip):
 **/
static FuStructIntelCvsProbe *
fu_struct_intel_cvs_probe_new_internal(void)
{
    FuStructIntelCvsProbe *st = g_new0(FuStructIntelCvsProbe, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_intel_cvs_probe_get_major: (skip):
 **/
guint32
fu_struct_intel_cvs_probe_get_major(const FuStructIntelCvsProbe *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_intel_cvs_probe_get_minor: (skip):
 **/
guint32
fu_struct_intel_cvs_probe_get_minor(const FuStructIntelCvsProbe *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_intel_cvs_probe_get_hotfix: (skip):
 **/
guint32
fu_struct_intel_cvs_probe_get_hotfix(const FuStructIntelCvsProbe *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_intel_cvs_probe_get_build: (skip):
 **/
guint32
fu_struct_intel_cvs_probe_get_build(const FuStructIntelCvsProbe *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_intel_cvs_probe_get_vid: (skip):
 **/
guint16
fu_struct_intel_cvs_probe_get_vid(const FuStructIntelCvsProbe *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_intel_cvs_probe_get_pid: (skip):
 **/
guint16
fu_struct_intel_cvs_probe_get_pid(const FuStructIntelCvsProbe *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 18, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_intel_cvs_probe_get_opid: (skip):
 **/
guint32
fu_struct_intel_cvs_probe_get_opid(const FuStructIntelCvsProbe *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 20, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_intel_cvs_probe_get_dev_capabilities: (skip):
 **/
FuStructIntelCvsDevCapability
fu_struct_intel_cvs_probe_get_dev_capabilities(const FuStructIntelCvsProbe *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 24, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_intel_cvs_probe_to_string: (skip):
 **/
static gchar *
fu_struct_intel_cvs_probe_to_string(const FuStructIntelCvsProbe *st)
{
    g_autoptr(GString) str = g_string_new("FuStructIntelCvsProbe:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  major: 0x%x\n",
                           (guint) fu_struct_intel_cvs_probe_get_major(st));
    g_string_append_printf(str, "  minor: 0x%x\n",
                           (guint) fu_struct_intel_cvs_probe_get_minor(st));
    g_string_append_printf(str, "  hotfix: 0x%x\n",
                           (guint) fu_struct_intel_cvs_probe_get_hotfix(st));
    g_string_append_printf(str, "  build: 0x%x\n",
                           (guint) fu_struct_intel_cvs_probe_get_build(st));
    g_string_append_printf(str, "  vid: 0x%x\n",
                           (guint) fu_struct_intel_cvs_probe_get_vid(st));
    g_string_append_printf(str, "  pid: 0x%x\n",
                           (guint) fu_struct_intel_cvs_probe_get_pid(st));
    g_string_append_printf(str, "  opid: 0x%x\n",
                           (guint) fu_struct_intel_cvs_probe_get_opid(st));
    {
        g_autofree gchar *tmp = fu_struct_intel_cvs_dev_capability_to_string(fu_struct_intel_cvs_probe_get_dev_capabilities(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  dev_capabilities: 0x%x [%s]\n", (guint) fu_struct_intel_cvs_probe_get_dev_capabilities(st), tmp);
        } else {
            g_string_append_printf(str, "  dev_capabilities: 0x%x\n", (guint) fu_struct_intel_cvs_probe_get_dev_capabilities(st));
        }
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_intel_cvs_probe_validate_internal(FuStructIntelCvsProbe *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_intel_cvs_probe_parse_internal(FuStructIntelCvsProbe *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_intel_cvs_probe_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_intel_cvs_probe_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_intel_cvs_probe_parse: (skip):
 **/
static FuStructIntelCvsProbe *
fu_struct_intel_cvs_probe_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructIntelCvsProbe) st = fu_struct_intel_cvs_probe_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 28, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructIntelCvsProbe: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 28);
    if (!fu_struct_intel_cvs_probe_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_intel_cvs_probe_parse_bytes: (skip):
 **/
FuStructIntelCvsProbe *
fu_struct_intel_cvs_probe_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_intel_cvs_probe_parse(buf, bufsz, offset, error);
}
/**
 * fu_struct_intel_cvs_write_ref: (skip):
 **/
FuStructIntelCvsWrite *
fu_struct_intel_cvs_write_ref(FuStructIntelCvsWrite *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_intel_cvs_write_unref: (skip):
 **/
void
fu_struct_intel_cvs_write_unref(FuStructIntelCvsWrite *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructIntelCvsWrite refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_intel_cvs_write_new_internal: (skip):
 **/
static FuStructIntelCvsWrite *
fu_struct_intel_cvs_write_new_internal(void)
{
    FuStructIntelCvsWrite *st = g_new0(FuStructIntelCvsWrite, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_intel_cvs_write_set_max_download_time: (skip):
 **/
void
fu_struct_intel_cvs_write_set_max_download_time(FuStructIntelCvsWrite *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_intel_cvs_write_set_max_flash_time: (skip):
 **/
void
fu_struct_intel_cvs_write_set_max_flash_time(FuStructIntelCvsWrite *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_intel_cvs_write_set_max_fwupd_retry_count: (skip):
 **/
void
fu_struct_intel_cvs_write_set_max_fwupd_retry_count(FuStructIntelCvsWrite *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_intel_cvs_write_set_fw_bin_fd: (skip):
 **/
void
fu_struct_intel_cvs_write_set_fw_bin_fd(FuStructIntelCvsWrite *st, gint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 12, value, G_BYTE_ORDER);
}
/**
 * fu_struct_intel_cvs_write_new: (skip):
 **/
FuStructIntelCvsWrite *
fu_struct_intel_cvs_write_new(void)
{
    FuStructIntelCvsWrite *st = fu_struct_intel_cvs_write_new_internal();
    st->buf = g_byte_array_sized_new(16);
    fu_byte_array_set_size(st->buf, 16, 0x0);
    return st;
}
/**
 * fu_struct_intel_cvs_status_ref: (skip):
 **/
FuStructIntelCvsStatus *
fu_struct_intel_cvs_status_ref(FuStructIntelCvsStatus *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_intel_cvs_status_unref: (skip):
 **/
void
fu_struct_intel_cvs_status_unref(FuStructIntelCvsStatus *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructIntelCvsStatus refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_intel_cvs_status_new_internal: (skip):
 **/
static FuStructIntelCvsStatus *
fu_struct_intel_cvs_status_new_internal(void)
{
    FuStructIntelCvsStatus *st = g_new0(FuStructIntelCvsStatus, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_intel_cvs_status_get_dev_state: (skip):
 **/
FuIntelCvsDeviceState
fu_struct_intel_cvs_status_get_dev_state(const FuStructIntelCvsStatus *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_intel_cvs_status_get_fw_upd_retries: (skip):
 **/
guint32
fu_struct_intel_cvs_status_get_fw_upd_retries(const FuStructIntelCvsStatus *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 1, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_intel_cvs_status_get_total_packets: (skip):
 **/
guint32
fu_struct_intel_cvs_status_get_total_packets(const FuStructIntelCvsStatus *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 5, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_intel_cvs_status_get_num_packets_sent: (skip):
 **/
guint32
fu_struct_intel_cvs_status_get_num_packets_sent(const FuStructIntelCvsStatus *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 9, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_intel_cvs_status_get_fw_dl_finished: (skip):
 **/
guint8
fu_struct_intel_cvs_status_get_fw_dl_finished(const FuStructIntelCvsStatus *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[13];
}
/**
 * fu_struct_intel_cvs_status_get_fw_dl_status_code: (skip):
 **/
guint32
fu_struct_intel_cvs_status_get_fw_dl_status_code(const FuStructIntelCvsStatus *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 14, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_intel_cvs_status_to_string: (skip):
 **/
static gchar *
fu_struct_intel_cvs_status_to_string(const FuStructIntelCvsStatus *st)
{
    g_autoptr(GString) str = g_string_new("FuStructIntelCvsStatus:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fu_intel_cvs_device_state_to_string(fu_struct_intel_cvs_status_get_dev_state(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  dev_state: 0x%x [%s]\n", (guint) fu_struct_intel_cvs_status_get_dev_state(st), tmp);
        } else {
            g_string_append_printf(str, "  dev_state: 0x%x\n", (guint) fu_struct_intel_cvs_status_get_dev_state(st));
        }
    }
    g_string_append_printf(str, "  fw_upd_retries: 0x%x\n",
                           (guint) fu_struct_intel_cvs_status_get_fw_upd_retries(st));
    g_string_append_printf(str, "  total_packets: 0x%x\n",
                           (guint) fu_struct_intel_cvs_status_get_total_packets(st));
    g_string_append_printf(str, "  num_packets_sent: 0x%x\n",
                           (guint) fu_struct_intel_cvs_status_get_num_packets_sent(st));
    g_string_append_printf(str, "  fw_dl_finished: 0x%x\n",
                           (guint) fu_struct_intel_cvs_status_get_fw_dl_finished(st));
    g_string_append_printf(str, "  fw_dl_status_code: 0x%x\n",
                           (guint) fu_struct_intel_cvs_status_get_fw_dl_status_code(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_intel_cvs_status_validate_internal(FuStructIntelCvsStatus *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_intel_cvs_status_parse_internal(FuStructIntelCvsStatus *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_intel_cvs_status_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_intel_cvs_status_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_intel_cvs_status_parse: (skip):
 **/
static FuStructIntelCvsStatus *
fu_struct_intel_cvs_status_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructIntelCvsStatus) st = fu_struct_intel_cvs_status_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 18, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructIntelCvsStatus: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 18);
    if (!fu_struct_intel_cvs_status_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_intel_cvs_status_parse_bytes: (skip):
 **/
FuStructIntelCvsStatus *
fu_struct_intel_cvs_status_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_intel_cvs_status_parse(buf, bufsz, offset, error);
}
