/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-steelseries-fizz-struct.h"
#include "fu-byte-array.h"
#include "fu-bytes.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

/**
 * fu_steelseries_fizz_connection_to_string:
 * @val: value, e.g. %FU_STEELSERIES_FIZZ_CONNECTION_PAIRING
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
static const gchar *
fu_steelseries_fizz_connection_to_string(FuSteelseriesFizzConnection val)
{
    if (val == FU_STEELSERIES_FIZZ_CONNECTION_UNEXPECTED)
        return "unexpected";
    if (val == FU_STEELSERIES_FIZZ_CONNECTION_PAIRING)
        return "pairing";
    if (val == FU_STEELSERIES_FIZZ_CONNECTION_DISCONNECTED)
        return "disconnected";
    if (val == FU_STEELSERIES_FIZZ_CONNECTION_CONNECTED)
        return "connected";
    return NULL;
}

/**
 * fu_steelseries_fizz_connection_status_to_string:
 * @val: value, e.g. %FU_STEELSERIES_FIZZ_CONNECTION_STATUS_CONNECTED
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_steelseries_fizz_connection_status_to_string(FuSteelseriesFizzConnectionStatus val)
{
    if (val == FU_STEELSERIES_FIZZ_CONNECTION_STATUS_NOT_CONNECTED)
        return "not-connected";
    if (val == FU_STEELSERIES_FIZZ_CONNECTION_STATUS_CONNECTED)
        return "connected";
    return NULL;
}






/**
 * fu_steelseries_fizz_cmd_to_string:
 * @val: value, e.g. %FU_STEELSERIES_FIZZ_CMD_ERASE_FILE
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_steelseries_fizz_cmd_to_string(FuSteelseriesFizzCmd val)
{
    if (val == FU_STEELSERIES_FIZZ_CMD_RESET)
        return "reset";
    if (val == FU_STEELSERIES_FIZZ_CMD_ERASE_FILE)
        return "erase-file";
    if (val == FU_STEELSERIES_FIZZ_CMD_WRITE_ACCESS_FILE)
        return "write-access-file";
    if (val == FU_STEELSERIES_FIZZ_CMD_VERSION2)
        return "version2";
    if (val == FU_STEELSERIES_FIZZ_CMD_SERIAL2)
        return "serial2";
    if (val == FU_STEELSERIES_FIZZ_CMD_READ_ACCESS_FILE)
        return "read-access-file";
    if (val == FU_STEELSERIES_FIZZ_CMD_FILE_CRC32)
        return "file-crc32";
    if (val == FU_STEELSERIES_FIZZ_CMD_VERSION)
        return "version";
    if (val == FU_STEELSERIES_FIZZ_CMD_BATTERY_LEVEL)
        return "battery-level";
    if (val == FU_STEELSERIES_FIZZ_CMD_PAIRED_STATUS)
        return "paired-status";
    if (val == FU_STEELSERIES_FIZZ_CMD_CONNECTION_STATUS2)
        return "connection-status2";
    if (val == FU_STEELSERIES_FIZZ_CMD_CONNECTION_STATUS)
        return "connection-status";
    return NULL;
}
/**
 * fu_struct_steelseries_fizz_hid_get_version_req_ref: (skip):
 **/
FuStructSteelseriesFizzHidGetVersionReq *
fu_struct_steelseries_fizz_hid_get_version_req_ref(FuStructSteelseriesFizzHidGetVersionReq *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_steelseries_fizz_hid_get_version_req_unref: (skip):
 **/
void
fu_struct_steelseries_fizz_hid_get_version_req_unref(FuStructSteelseriesFizzHidGetVersionReq *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSteelseriesFizzHidGetVersionReq refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_steelseries_fizz_hid_get_version_req_new_internal: (skip):
 **/
static FuStructSteelseriesFizzHidGetVersionReq *
fu_struct_steelseries_fizz_hid_get_version_req_new_internal(void)
{
    FuStructSteelseriesFizzHidGetVersionReq *st = g_new0(FuStructSteelseriesFizzHidGetVersionReq, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_steelseries_fizz_hid_get_version_req_set_report_id: (skip):
 **/
static void
fu_struct_steelseries_fizz_hid_get_version_req_set_report_id(FuStructSteelseriesFizzHidGetVersionReq *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_steelseries_fizz_hid_get_version_req_set_command: (skip):
 **/
static void
fu_struct_steelseries_fizz_hid_get_version_req_set_command(FuStructSteelseriesFizzHidGetVersionReq *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_steelseries_fizz_hid_get_version_req_set_mode: (skip):
 **/
static void
fu_struct_steelseries_fizz_hid_get_version_req_set_mode(FuStructSteelseriesFizzHidGetVersionReq *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_steelseries_fizz_hid_get_version_req_new: (skip):
 **/
FuStructSteelseriesFizzHidGetVersionReq *
fu_struct_steelseries_fizz_hid_get_version_req_new(void)
{
    FuStructSteelseriesFizzHidGetVersionReq *st = fu_struct_steelseries_fizz_hid_get_version_req_new_internal();
    st->buf = g_byte_array_sized_new(3);
    fu_byte_array_set_size(st->buf, 3, 0x0);
    fu_struct_steelseries_fizz_hid_get_version_req_set_report_id(st, 0x04);
    fu_struct_steelseries_fizz_hid_get_version_req_set_command(st, 0x90);
    fu_struct_steelseries_fizz_hid_get_version_req_set_mode(st, 0x00);
    return st;
}
/**
 * fu_struct_steelseries_fizz_hid_response_ref: (skip):
 **/
FuStructSteelseriesFizzHidResponse *
fu_struct_steelseries_fizz_hid_response_ref(FuStructSteelseriesFizzHidResponse *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_steelseries_fizz_hid_response_unref: (skip):
 **/
void
fu_struct_steelseries_fizz_hid_response_unref(FuStructSteelseriesFizzHidResponse *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSteelseriesFizzHidResponse refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_steelseries_fizz_hid_response_new_internal: (skip):
 **/
static FuStructSteelseriesFizzHidResponse *
fu_struct_steelseries_fizz_hid_response_new_internal(void)
{
    FuStructSteelseriesFizzHidResponse *st = g_new0(FuStructSteelseriesFizzHidResponse, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_steelseries_fizz_hid_response_get_report_id: (skip):
 **/
guint8
fu_struct_steelseries_fizz_hid_response_get_report_id(const FuStructSteelseriesFizzHidResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}

/* setters */
/**
 * fu_struct_steelseries_fizz_hid_response_to_string: (skip):
 **/
static gchar *
fu_struct_steelseries_fizz_hid_response_to_string(const FuStructSteelseriesFizzHidResponse *st)
{
    g_autoptr(GString) str = g_string_new("FuStructSteelseriesFizzHidResponse:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  report_id: 0x%x\n",
                           (guint) fu_struct_steelseries_fizz_hid_response_get_report_id(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_steelseries_fizz_hid_response_validate_internal(FuStructSteelseriesFizzHidResponse *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_steelseries_fizz_hid_response_parse_internal(FuStructSteelseriesFizzHidResponse *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_steelseries_fizz_hid_response_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_steelseries_fizz_hid_response_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_steelseries_fizz_hid_response_parse: (skip):
 **/
FuStructSteelseriesFizzHidResponse *
fu_struct_steelseries_fizz_hid_response_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructSteelseriesFizzHidResponse) st = fu_struct_steelseries_fizz_hid_response_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 65, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructSteelseriesFizzHidResponse: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 65);
    if (!fu_struct_steelseries_fizz_hid_response_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_steelseries_fizz_write_access_file_req_ref: (skip):
 **/
FuStructSteelseriesFizzWriteAccessFileReq *
fu_struct_steelseries_fizz_write_access_file_req_ref(FuStructSteelseriesFizzWriteAccessFileReq *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_steelseries_fizz_write_access_file_req_unref: (skip):
 **/
void
fu_struct_steelseries_fizz_write_access_file_req_unref(FuStructSteelseriesFizzWriteAccessFileReq *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSteelseriesFizzWriteAccessFileReq refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_steelseries_fizz_write_access_file_req_new_internal: (skip):
 **/
static FuStructSteelseriesFizzWriteAccessFileReq *
fu_struct_steelseries_fizz_write_access_file_req_new_internal(void)
{
    FuStructSteelseriesFizzWriteAccessFileReq *st = g_new0(FuStructSteelseriesFizzWriteAccessFileReq, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_steelseries_fizz_write_access_file_req_set_cmd: (skip):
 **/
void
fu_struct_steelseries_fizz_write_access_file_req_set_cmd(FuStructSteelseriesFizzWriteAccessFileReq *st, FuSteelseriesFizzCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_steelseries_fizz_write_access_file_req_set_filesystem: (skip):
 **/
void
fu_struct_steelseries_fizz_write_access_file_req_set_filesystem(FuStructSteelseriesFizzWriteAccessFileReq *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_steelseries_fizz_write_access_file_req_set_id: (skip):
 **/
void
fu_struct_steelseries_fizz_write_access_file_req_set_id(FuStructSteelseriesFizzWriteAccessFileReq *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_steelseries_fizz_write_access_file_req_set_size: (skip):
 **/
void
fu_struct_steelseries_fizz_write_access_file_req_set_size(FuStructSteelseriesFizzWriteAccessFileReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 3, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_steelseries_fizz_write_access_file_req_set_offset: (skip):
 **/
void
fu_struct_steelseries_fizz_write_access_file_req_set_offset(FuStructSteelseriesFizzWriteAccessFileReq *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 5, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_steelseries_fizz_write_access_file_req_set_data: (skip):
 **/
gboolean
fu_struct_steelseries_fizz_write_access_file_req_set_data(FuStructSteelseriesFizzWriteAccessFileReq *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 9, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_steelseries_fizz_write_access_file_req_new: (skip):
 **/
FuStructSteelseriesFizzWriteAccessFileReq *
fu_struct_steelseries_fizz_write_access_file_req_new(void)
{
    FuStructSteelseriesFizzWriteAccessFileReq *st = fu_struct_steelseries_fizz_write_access_file_req_new_internal();
    st->buf = g_byte_array_sized_new(61);
    fu_byte_array_set_size(st->buf, 61, 0x0);
    fu_struct_steelseries_fizz_write_access_file_req_set_cmd(st, FU_STEELSERIES_FIZZ_CMD_WRITE_ACCESS_FILE);
    return st;
}
/**
 * fu_struct_steelseries_fizz_read_access_file_req_ref: (skip):
 **/
FuStructSteelseriesFizzReadAccessFileReq *
fu_struct_steelseries_fizz_read_access_file_req_ref(FuStructSteelseriesFizzReadAccessFileReq *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_steelseries_fizz_read_access_file_req_unref: (skip):
 **/
void
fu_struct_steelseries_fizz_read_access_file_req_unref(FuStructSteelseriesFizzReadAccessFileReq *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSteelseriesFizzReadAccessFileReq refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_steelseries_fizz_read_access_file_req_new_internal: (skip):
 **/
static FuStructSteelseriesFizzReadAccessFileReq *
fu_struct_steelseries_fizz_read_access_file_req_new_internal(void)
{
    FuStructSteelseriesFizzReadAccessFileReq *st = g_new0(FuStructSteelseriesFizzReadAccessFileReq, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_steelseries_fizz_read_access_file_req_set_cmd: (skip):
 **/
void
fu_struct_steelseries_fizz_read_access_file_req_set_cmd(FuStructSteelseriesFizzReadAccessFileReq *st, FuSteelseriesFizzCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_steelseries_fizz_read_access_file_req_set_filesystem: (skip):
 **/
void
fu_struct_steelseries_fizz_read_access_file_req_set_filesystem(FuStructSteelseriesFizzReadAccessFileReq *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_steelseries_fizz_read_access_file_req_set_id: (skip):
 **/
void
fu_struct_steelseries_fizz_read_access_file_req_set_id(FuStructSteelseriesFizzReadAccessFileReq *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_steelseries_fizz_read_access_file_req_set_size: (skip):
 **/
void
fu_struct_steelseries_fizz_read_access_file_req_set_size(FuStructSteelseriesFizzReadAccessFileReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 3, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_steelseries_fizz_read_access_file_req_set_offset: (skip):
 **/
void
fu_struct_steelseries_fizz_read_access_file_req_set_offset(FuStructSteelseriesFizzReadAccessFileReq *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 5, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_steelseries_fizz_read_access_file_req_new: (skip):
 **/
FuStructSteelseriesFizzReadAccessFileReq *
fu_struct_steelseries_fizz_read_access_file_req_new(void)
{
    FuStructSteelseriesFizzReadAccessFileReq *st = fu_struct_steelseries_fizz_read_access_file_req_new_internal();
    st->buf = g_byte_array_sized_new(9);
    fu_byte_array_set_size(st->buf, 9, 0x0);
    fu_struct_steelseries_fizz_read_access_file_req_set_cmd(st, FU_STEELSERIES_FIZZ_CMD_READ_ACCESS_FILE);
    return st;
}
/**
 * fu_struct_steelseries_fizz_read_access_file_res_ref: (skip):
 **/
FuStructSteelseriesFizzReadAccessFileRes *
fu_struct_steelseries_fizz_read_access_file_res_ref(FuStructSteelseriesFizzReadAccessFileRes *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_steelseries_fizz_read_access_file_res_unref: (skip):
 **/
void
fu_struct_steelseries_fizz_read_access_file_res_unref(FuStructSteelseriesFizzReadAccessFileRes *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSteelseriesFizzReadAccessFileRes refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_steelseries_fizz_read_access_file_res_new_internal: (skip):
 **/
static FuStructSteelseriesFizzReadAccessFileRes *
fu_struct_steelseries_fizz_read_access_file_res_new_internal(void)
{
    FuStructSteelseriesFizzReadAccessFileRes *st = g_new0(FuStructSteelseriesFizzReadAccessFileRes, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_steelseries_fizz_read_access_file_res_get_data: (skip):
 **/
const guint8 *
fu_struct_steelseries_fizz_read_access_file_res_get_data(const FuStructSteelseriesFizzReadAccessFileRes *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 52;
    return st->buf->data + 2;
}

/* setters */
/**
 * fu_struct_steelseries_fizz_read_access_file_res_to_string: (skip):
 **/
static gchar *
fu_struct_steelseries_fizz_read_access_file_res_to_string(const FuStructSteelseriesFizzReadAccessFileRes *st)
{
    g_autoptr(GString) str = g_string_new("FuStructSteelseriesFizzReadAccessFileRes:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_steelseries_fizz_read_access_file_res_get_data(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  data: 0x%s\n", tmp->str);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_steelseries_fizz_read_access_file_res_validate_internal(FuStructSteelseriesFizzReadAccessFileRes *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_steelseries_fizz_read_access_file_res_parse_internal(FuStructSteelseriesFizzReadAccessFileRes *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_steelseries_fizz_read_access_file_res_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_steelseries_fizz_read_access_file_res_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_steelseries_fizz_read_access_file_res_parse: (skip):
 **/
FuStructSteelseriesFizzReadAccessFileRes *
fu_struct_steelseries_fizz_read_access_file_res_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructSteelseriesFizzReadAccessFileRes) st = fu_struct_steelseries_fizz_read_access_file_res_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 54, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructSteelseriesFizzReadAccessFileRes: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 54);
    if (!fu_struct_steelseries_fizz_read_access_file_res_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_steelseries_fizz_erase_file_req_ref: (skip):
 **/
FuStructSteelseriesFizzEraseFileReq *
fu_struct_steelseries_fizz_erase_file_req_ref(FuStructSteelseriesFizzEraseFileReq *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_steelseries_fizz_erase_file_req_unref: (skip):
 **/
void
fu_struct_steelseries_fizz_erase_file_req_unref(FuStructSteelseriesFizzEraseFileReq *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSteelseriesFizzEraseFileReq refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_steelseries_fizz_erase_file_req_new_internal: (skip):
 **/
static FuStructSteelseriesFizzEraseFileReq *
fu_struct_steelseries_fizz_erase_file_req_new_internal(void)
{
    FuStructSteelseriesFizzEraseFileReq *st = g_new0(FuStructSteelseriesFizzEraseFileReq, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_steelseries_fizz_erase_file_req_set_cmd: (skip):
 **/
void
fu_struct_steelseries_fizz_erase_file_req_set_cmd(FuStructSteelseriesFizzEraseFileReq *st, FuSteelseriesFizzCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_steelseries_fizz_erase_file_req_set_filesystem: (skip):
 **/
void
fu_struct_steelseries_fizz_erase_file_req_set_filesystem(FuStructSteelseriesFizzEraseFileReq *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_steelseries_fizz_erase_file_req_set_id: (skip):
 **/
void
fu_struct_steelseries_fizz_erase_file_req_set_id(FuStructSteelseriesFizzEraseFileReq *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_steelseries_fizz_erase_file_req_new: (skip):
 **/
FuStructSteelseriesFizzEraseFileReq *
fu_struct_steelseries_fizz_erase_file_req_new(void)
{
    FuStructSteelseriesFizzEraseFileReq *st = fu_struct_steelseries_fizz_erase_file_req_new_internal();
    st->buf = g_byte_array_sized_new(3);
    fu_byte_array_set_size(st->buf, 3, 0x0);
    fu_struct_steelseries_fizz_erase_file_req_set_cmd(st, FU_STEELSERIES_FIZZ_CMD_ERASE_FILE);
    return st;
}
/**
 * fu_struct_steelseries_fizz_reset_req_ref: (skip):
 **/
FuStructSteelseriesFizzResetReq *
fu_struct_steelseries_fizz_reset_req_ref(FuStructSteelseriesFizzResetReq *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_steelseries_fizz_reset_req_unref: (skip):
 **/
void
fu_struct_steelseries_fizz_reset_req_unref(FuStructSteelseriesFizzResetReq *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSteelseriesFizzResetReq refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_steelseries_fizz_reset_req_new_internal: (skip):
 **/
static FuStructSteelseriesFizzResetReq *
fu_struct_steelseries_fizz_reset_req_new_internal(void)
{
    FuStructSteelseriesFizzResetReq *st = g_new0(FuStructSteelseriesFizzResetReq, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_steelseries_fizz_reset_req_set_cmd: (skip):
 **/
void
fu_struct_steelseries_fizz_reset_req_set_cmd(FuStructSteelseriesFizzResetReq *st, FuSteelseriesFizzCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_steelseries_fizz_reset_req_set_mode: (skip):
 **/
void
fu_struct_steelseries_fizz_reset_req_set_mode(FuStructSteelseriesFizzResetReq *st, FuSteelseriesFizzResetMode value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_steelseries_fizz_reset_req_new: (skip):
 **/
FuStructSteelseriesFizzResetReq *
fu_struct_steelseries_fizz_reset_req_new(void)
{
    FuStructSteelseriesFizzResetReq *st = fu_struct_steelseries_fizz_reset_req_new_internal();
    st->buf = g_byte_array_sized_new(2);
    fu_byte_array_set_size(st->buf, 2, 0x0);
    fu_struct_steelseries_fizz_reset_req_set_cmd(st, FU_STEELSERIES_FIZZ_CMD_RESET);
    return st;
}
/**
 * fu_struct_steelseries_fizz_file_crc32_req_ref: (skip):
 **/
FuStructSteelseriesFizzFileCrc32Req *
fu_struct_steelseries_fizz_file_crc32_req_ref(FuStructSteelseriesFizzFileCrc32Req *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_steelseries_fizz_file_crc32_req_unref: (skip):
 **/
void
fu_struct_steelseries_fizz_file_crc32_req_unref(FuStructSteelseriesFizzFileCrc32Req *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSteelseriesFizzFileCrc32Req refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_steelseries_fizz_file_crc32_req_new_internal: (skip):
 **/
static FuStructSteelseriesFizzFileCrc32Req *
fu_struct_steelseries_fizz_file_crc32_req_new_internal(void)
{
    FuStructSteelseriesFizzFileCrc32Req *st = g_new0(FuStructSteelseriesFizzFileCrc32Req, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_steelseries_fizz_file_crc32_req_set_cmd: (skip):
 **/
void
fu_struct_steelseries_fizz_file_crc32_req_set_cmd(FuStructSteelseriesFizzFileCrc32Req *st, FuSteelseriesFizzCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_steelseries_fizz_file_crc32_req_set_filesystem: (skip):
 **/
void
fu_struct_steelseries_fizz_file_crc32_req_set_filesystem(FuStructSteelseriesFizzFileCrc32Req *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_steelseries_fizz_file_crc32_req_set_id: (skip):
 **/
void
fu_struct_steelseries_fizz_file_crc32_req_set_id(FuStructSteelseriesFizzFileCrc32Req *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_steelseries_fizz_file_crc32_req_new: (skip):
 **/
FuStructSteelseriesFizzFileCrc32Req *
fu_struct_steelseries_fizz_file_crc32_req_new(void)
{
    FuStructSteelseriesFizzFileCrc32Req *st = fu_struct_steelseries_fizz_file_crc32_req_new_internal();
    st->buf = g_byte_array_sized_new(3);
    fu_byte_array_set_size(st->buf, 3, 0x0);
    fu_struct_steelseries_fizz_file_crc32_req_set_cmd(st, FU_STEELSERIES_FIZZ_CMD_FILE_CRC32);
    return st;
}
/**
 * fu_struct_steelseries_fizz_file_crc32_res_ref: (skip):
 **/
FuStructSteelseriesFizzFileCrc32Res *
fu_struct_steelseries_fizz_file_crc32_res_ref(FuStructSteelseriesFizzFileCrc32Res *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_steelseries_fizz_file_crc32_res_unref: (skip):
 **/
void
fu_struct_steelseries_fizz_file_crc32_res_unref(FuStructSteelseriesFizzFileCrc32Res *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSteelseriesFizzFileCrc32Res refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_steelseries_fizz_file_crc32_res_new_internal: (skip):
 **/
static FuStructSteelseriesFizzFileCrc32Res *
fu_struct_steelseries_fizz_file_crc32_res_new_internal(void)
{
    FuStructSteelseriesFizzFileCrc32Res *st = g_new0(FuStructSteelseriesFizzFileCrc32Res, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_steelseries_fizz_file_crc32_res_get_calculated: (skip):
 **/
guint32
fu_struct_steelseries_fizz_file_crc32_res_get_calculated(const FuStructSteelseriesFizzFileCrc32Res *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_steelseries_fizz_file_crc32_res_get_stored: (skip):
 **/
guint32
fu_struct_steelseries_fizz_file_crc32_res_get_stored(const FuStructSteelseriesFizzFileCrc32Res *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 6, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_steelseries_fizz_file_crc32_res_to_string: (skip):
 **/
static gchar *
fu_struct_steelseries_fizz_file_crc32_res_to_string(const FuStructSteelseriesFizzFileCrc32Res *st)
{
    g_autoptr(GString) str = g_string_new("FuStructSteelseriesFizzFileCrc32Res:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  calculated: 0x%x\n",
                           (guint) fu_struct_steelseries_fizz_file_crc32_res_get_calculated(st));
    g_string_append_printf(str, "  stored: 0x%x\n",
                           (guint) fu_struct_steelseries_fizz_file_crc32_res_get_stored(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_steelseries_fizz_file_crc32_res_validate_internal(FuStructSteelseriesFizzFileCrc32Res *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_steelseries_fizz_file_crc32_res_parse_internal(FuStructSteelseriesFizzFileCrc32Res *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_steelseries_fizz_file_crc32_res_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_steelseries_fizz_file_crc32_res_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_steelseries_fizz_file_crc32_res_parse: (skip):
 **/
FuStructSteelseriesFizzFileCrc32Res *
fu_struct_steelseries_fizz_file_crc32_res_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructSteelseriesFizzFileCrc32Res) st = fu_struct_steelseries_fizz_file_crc32_res_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 10, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructSteelseriesFizzFileCrc32Res: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 10);
    if (!fu_struct_steelseries_fizz_file_crc32_res_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_steelseries_fizz_generic_res_ref: (skip):
 **/
FuStructSteelseriesFizzGenericRes *
fu_struct_steelseries_fizz_generic_res_ref(FuStructSteelseriesFizzGenericRes *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_steelseries_fizz_generic_res_unref: (skip):
 **/
void
fu_struct_steelseries_fizz_generic_res_unref(FuStructSteelseriesFizzGenericRes *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSteelseriesFizzGenericRes refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_steelseries_fizz_generic_res_new_internal: (skip):
 **/
static FuStructSteelseriesFizzGenericRes *
fu_struct_steelseries_fizz_generic_res_new_internal(void)
{
    FuStructSteelseriesFizzGenericRes *st = g_new0(FuStructSteelseriesFizzGenericRes, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_steelseries_fizz_generic_res_get_cmd: (skip):
 **/
FuSteelseriesFizzCmd
fu_struct_steelseries_fizz_generic_res_get_cmd(const FuStructSteelseriesFizzGenericRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_steelseries_fizz_generic_res_get_error: (skip):
 **/
guint8
fu_struct_steelseries_fizz_generic_res_get_error(const FuStructSteelseriesFizzGenericRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}

/* setters */
/**
 * fu_struct_steelseries_fizz_generic_res_to_string: (skip):
 **/
static gchar *
fu_struct_steelseries_fizz_generic_res_to_string(const FuStructSteelseriesFizzGenericRes *st)
{
    g_autoptr(GString) str = g_string_new("FuStructSteelseriesFizzGenericRes:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_steelseries_fizz_cmd_to_string(fu_struct_steelseries_fizz_generic_res_get_cmd(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  cmd: 0x%x [%s]\n", (guint) fu_struct_steelseries_fizz_generic_res_get_cmd(st), tmp);
        } else {
            g_string_append_printf(str, "  cmd: 0x%x\n", (guint) fu_struct_steelseries_fizz_generic_res_get_cmd(st));
        }
    }
    g_string_append_printf(str, "  error: 0x%x\n",
                           (guint) fu_struct_steelseries_fizz_generic_res_get_error(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_steelseries_fizz_generic_res_validate_internal(FuStructSteelseriesFizzGenericRes *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_steelseries_fizz_generic_res_parse_internal(FuStructSteelseriesFizzGenericRes *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_steelseries_fizz_generic_res_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_steelseries_fizz_generic_res_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_steelseries_fizz_generic_res_parse: (skip):
 **/
FuStructSteelseriesFizzGenericRes *
fu_struct_steelseries_fizz_generic_res_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructSteelseriesFizzGenericRes) st = fu_struct_steelseries_fizz_generic_res_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 2, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructSteelseriesFizzGenericRes: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 2);
    if (!fu_struct_steelseries_fizz_generic_res_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_steelseries_fizz_version_req_ref: (skip):
 **/
FuStructSteelseriesFizzVersionReq *
fu_struct_steelseries_fizz_version_req_ref(FuStructSteelseriesFizzVersionReq *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_steelseries_fizz_version_req_unref: (skip):
 **/
void
fu_struct_steelseries_fizz_version_req_unref(FuStructSteelseriesFizzVersionReq *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSteelseriesFizzVersionReq refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_steelseries_fizz_version_req_new_internal: (skip):
 **/
static FuStructSteelseriesFizzVersionReq *
fu_struct_steelseries_fizz_version_req_new_internal(void)
{
    FuStructSteelseriesFizzVersionReq *st = g_new0(FuStructSteelseriesFizzVersionReq, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_steelseries_fizz_version_req_set_cmd: (skip):
 **/
void
fu_struct_steelseries_fizz_version_req_set_cmd(FuStructSteelseriesFizzVersionReq *st, FuSteelseriesFizzCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_steelseries_fizz_version_req_set_mode: (skip):
 **/
static void
fu_struct_steelseries_fizz_version_req_set_mode(FuStructSteelseriesFizzVersionReq *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_steelseries_fizz_version_req_new: (skip):
 **/
FuStructSteelseriesFizzVersionReq *
fu_struct_steelseries_fizz_version_req_new(void)
{
    FuStructSteelseriesFizzVersionReq *st = fu_struct_steelseries_fizz_version_req_new_internal();
    st->buf = g_byte_array_sized_new(2);
    fu_byte_array_set_size(st->buf, 2, 0x0);
    fu_struct_steelseries_fizz_version_req_set_cmd(st, FU_STEELSERIES_FIZZ_CMD_VERSION);
    fu_struct_steelseries_fizz_version_req_set_mode(st, 0);
    return st;
}
/**
 * fu_struct_steelseries_paired_status_req_ref: (skip):
 **/
FuStructSteelseriesPairedStatusReq *
fu_struct_steelseries_paired_status_req_ref(FuStructSteelseriesPairedStatusReq *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_steelseries_paired_status_req_unref: (skip):
 **/
void
fu_struct_steelseries_paired_status_req_unref(FuStructSteelseriesPairedStatusReq *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSteelseriesPairedStatusReq refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_steelseries_paired_status_req_new_internal: (skip):
 **/
static FuStructSteelseriesPairedStatusReq *
fu_struct_steelseries_paired_status_req_new_internal(void)
{
    FuStructSteelseriesPairedStatusReq *st = g_new0(FuStructSteelseriesPairedStatusReq, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_steelseries_paired_status_req_set_cmd: (skip):
 **/
static void
fu_struct_steelseries_paired_status_req_set_cmd(FuStructSteelseriesPairedStatusReq *st, FuSteelseriesFizzCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_steelseries_paired_status_req_new: (skip):
 **/
FuStructSteelseriesPairedStatusReq *
fu_struct_steelseries_paired_status_req_new(void)
{
    FuStructSteelseriesPairedStatusReq *st = fu_struct_steelseries_paired_status_req_new_internal();
    st->buf = g_byte_array_sized_new(1);
    fu_byte_array_set_size(st->buf, 1, 0x0);
    fu_struct_steelseries_paired_status_req_set_cmd(st, FU_STEELSERIES_FIZZ_CMD_PAIRED_STATUS);
    return st;
}
/**
 * fu_struct_steelseries_paired_status_res_ref: (skip):
 **/
FuStructSteelseriesPairedStatusRes *
fu_struct_steelseries_paired_status_res_ref(FuStructSteelseriesPairedStatusRes *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_steelseries_paired_status_res_unref: (skip):
 **/
void
fu_struct_steelseries_paired_status_res_unref(FuStructSteelseriesPairedStatusRes *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSteelseriesPairedStatusRes refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_steelseries_paired_status_res_new_internal: (skip):
 **/
static FuStructSteelseriesPairedStatusRes *
fu_struct_steelseries_paired_status_res_new_internal(void)
{
    FuStructSteelseriesPairedStatusRes *st = g_new0(FuStructSteelseriesPairedStatusRes, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_steelseries_paired_status_res_get_status: (skip):
 **/
guint8
fu_struct_steelseries_paired_status_res_get_status(const FuStructSteelseriesPairedStatusRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}

/* setters */
/**
 * fu_struct_steelseries_paired_status_res_to_string: (skip):
 **/
static gchar *
fu_struct_steelseries_paired_status_res_to_string(const FuStructSteelseriesPairedStatusRes *st)
{
    g_autoptr(GString) str = g_string_new("FuStructSteelseriesPairedStatusRes:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  status: 0x%x\n",
                           (guint) fu_struct_steelseries_paired_status_res_get_status(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_steelseries_paired_status_res_validate_internal(FuStructSteelseriesPairedStatusRes *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_steelseries_paired_status_res_parse_internal(FuStructSteelseriesPairedStatusRes *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_steelseries_paired_status_res_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_steelseries_paired_status_res_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_steelseries_paired_status_res_parse: (skip):
 **/
FuStructSteelseriesPairedStatusRes *
fu_struct_steelseries_paired_status_res_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructSteelseriesPairedStatusRes) st = fu_struct_steelseries_paired_status_res_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 1, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructSteelseriesPairedStatusRes: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 1);
    if (!fu_struct_steelseries_paired_status_res_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_steelseries_connection_status_req_ref: (skip):
 **/
FuStructSteelseriesConnectionStatusReq *
fu_struct_steelseries_connection_status_req_ref(FuStructSteelseriesConnectionStatusReq *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_steelseries_connection_status_req_unref: (skip):
 **/
void
fu_struct_steelseries_connection_status_req_unref(FuStructSteelseriesConnectionStatusReq *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSteelseriesConnectionStatusReq refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_steelseries_connection_status_req_new_internal: (skip):
 **/
static FuStructSteelseriesConnectionStatusReq *
fu_struct_steelseries_connection_status_req_new_internal(void)
{
    FuStructSteelseriesConnectionStatusReq *st = g_new0(FuStructSteelseriesConnectionStatusReq, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_steelseries_connection_status_req_set_cmd: (skip):
 **/
static void
fu_struct_steelseries_connection_status_req_set_cmd(FuStructSteelseriesConnectionStatusReq *st, FuSteelseriesFizzCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_steelseries_connection_status_req_new: (skip):
 **/
FuStructSteelseriesConnectionStatusReq *
fu_struct_steelseries_connection_status_req_new(void)
{
    FuStructSteelseriesConnectionStatusReq *st = fu_struct_steelseries_connection_status_req_new_internal();
    st->buf = g_byte_array_sized_new(1);
    fu_byte_array_set_size(st->buf, 1, 0x0);
    fu_struct_steelseries_connection_status_req_set_cmd(st, FU_STEELSERIES_FIZZ_CMD_CONNECTION_STATUS);
    return st;
}
/**
 * fu_struct_steelseries_connection_status_res_ref: (skip):
 **/
FuStructSteelseriesConnectionStatusRes *
fu_struct_steelseries_connection_status_res_ref(FuStructSteelseriesConnectionStatusRes *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_steelseries_connection_status_res_unref: (skip):
 **/
void
fu_struct_steelseries_connection_status_res_unref(FuStructSteelseriesConnectionStatusRes *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSteelseriesConnectionStatusRes refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_steelseries_connection_status_res_new_internal: (skip):
 **/
static FuStructSteelseriesConnectionStatusRes *
fu_struct_steelseries_connection_status_res_new_internal(void)
{
    FuStructSteelseriesConnectionStatusRes *st = g_new0(FuStructSteelseriesConnectionStatusRes, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_steelseries_connection_status_res_get_status: (skip):
 **/
guint8
fu_struct_steelseries_connection_status_res_get_status(const FuStructSteelseriesConnectionStatusRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}

/* setters */
/**
 * fu_struct_steelseries_connection_status_res_to_string: (skip):
 **/
static gchar *
fu_struct_steelseries_connection_status_res_to_string(const FuStructSteelseriesConnectionStatusRes *st)
{
    g_autoptr(GString) str = g_string_new("FuStructSteelseriesConnectionStatusRes:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  status: 0x%x\n",
                           (guint) fu_struct_steelseries_connection_status_res_get_status(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_steelseries_connection_status_res_validate_internal(FuStructSteelseriesConnectionStatusRes *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_steelseries_connection_status_res_parse_internal(FuStructSteelseriesConnectionStatusRes *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_steelseries_connection_status_res_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_steelseries_connection_status_res_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_steelseries_connection_status_res_parse: (skip):
 **/
FuStructSteelseriesConnectionStatusRes *
fu_struct_steelseries_connection_status_res_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructSteelseriesConnectionStatusRes) st = fu_struct_steelseries_connection_status_res_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 2, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructSteelseriesConnectionStatusRes: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 2);
    if (!fu_struct_steelseries_connection_status_res_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_steelseries_battery_level_req_ref: (skip):
 **/
FuStructSteelseriesBatteryLevelReq *
fu_struct_steelseries_battery_level_req_ref(FuStructSteelseriesBatteryLevelReq *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_steelseries_battery_level_req_unref: (skip):
 **/
void
fu_struct_steelseries_battery_level_req_unref(FuStructSteelseriesBatteryLevelReq *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSteelseriesBatteryLevelReq refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_steelseries_battery_level_req_new_internal: (skip):
 **/
static FuStructSteelseriesBatteryLevelReq *
fu_struct_steelseries_battery_level_req_new_internal(void)
{
    FuStructSteelseriesBatteryLevelReq *st = g_new0(FuStructSteelseriesBatteryLevelReq, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_steelseries_battery_level_req_set_cmd: (skip):
 **/
void
fu_struct_steelseries_battery_level_req_set_cmd(FuStructSteelseriesBatteryLevelReq *st, FuSteelseriesFizzCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_steelseries_battery_level_req_new: (skip):
 **/
FuStructSteelseriesBatteryLevelReq *
fu_struct_steelseries_battery_level_req_new(void)
{
    FuStructSteelseriesBatteryLevelReq *st = fu_struct_steelseries_battery_level_req_new_internal();
    st->buf = g_byte_array_sized_new(1);
    fu_byte_array_set_size(st->buf, 1, 0x0);
    fu_struct_steelseries_battery_level_req_set_cmd(st, FU_STEELSERIES_FIZZ_CMD_BATTERY_LEVEL);
    return st;
}
/**
 * fu_struct_steelseries_battery_level_res_ref: (skip):
 **/
FuStructSteelseriesBatteryLevelRes *
fu_struct_steelseries_battery_level_res_ref(FuStructSteelseriesBatteryLevelRes *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_steelseries_battery_level_res_unref: (skip):
 **/
void
fu_struct_steelseries_battery_level_res_unref(FuStructSteelseriesBatteryLevelRes *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSteelseriesBatteryLevelRes refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_steelseries_battery_level_res_new_internal: (skip):
 **/
static FuStructSteelseriesBatteryLevelRes *
fu_struct_steelseries_battery_level_res_new_internal(void)
{
    FuStructSteelseriesBatteryLevelRes *st = g_new0(FuStructSteelseriesBatteryLevelRes, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_steelseries_battery_level_res_get_level: (skip):
 **/
guint8
fu_struct_steelseries_battery_level_res_get_level(const FuStructSteelseriesBatteryLevelRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}

/* setters */
/**
 * fu_struct_steelseries_battery_level_res_to_string: (skip):
 **/
static gchar *
fu_struct_steelseries_battery_level_res_to_string(const FuStructSteelseriesBatteryLevelRes *st)
{
    g_autoptr(GString) str = g_string_new("FuStructSteelseriesBatteryLevelRes:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  level: 0x%x\n",
                           (guint) fu_struct_steelseries_battery_level_res_get_level(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_steelseries_battery_level_res_validate_internal(FuStructSteelseriesBatteryLevelRes *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_steelseries_battery_level_res_parse_internal(FuStructSteelseriesBatteryLevelRes *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_steelseries_battery_level_res_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_steelseries_battery_level_res_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_steelseries_battery_level_res_parse: (skip):
 **/
FuStructSteelseriesBatteryLevelRes *
fu_struct_steelseries_battery_level_res_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructSteelseriesBatteryLevelRes) st = fu_struct_steelseries_battery_level_res_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 2, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructSteelseriesBatteryLevelRes: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 2);
    if (!fu_struct_steelseries_battery_level_res_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_steelseries_fizz_version2_req_ref: (skip):
 **/
FuStructSteelseriesFizzVersion2Req *
fu_struct_steelseries_fizz_version2_req_ref(FuStructSteelseriesFizzVersion2Req *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_steelseries_fizz_version2_req_unref: (skip):
 **/
void
fu_struct_steelseries_fizz_version2_req_unref(FuStructSteelseriesFizzVersion2Req *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSteelseriesFizzVersion2Req refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_steelseries_fizz_version2_req_new_internal: (skip):
 **/
static FuStructSteelseriesFizzVersion2Req *
fu_struct_steelseries_fizz_version2_req_new_internal(void)
{
    FuStructSteelseriesFizzVersion2Req *st = g_new0(FuStructSteelseriesFizzVersion2Req, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_steelseries_fizz_version2_req_set_cmd: (skip):
 **/
static void
fu_struct_steelseries_fizz_version2_req_set_cmd(FuStructSteelseriesFizzVersion2Req *st, FuSteelseriesFizzCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_steelseries_fizz_version2_req_new: (skip):
 **/
FuStructSteelseriesFizzVersion2Req *
fu_struct_steelseries_fizz_version2_req_new(void)
{
    FuStructSteelseriesFizzVersion2Req *st = fu_struct_steelseries_fizz_version2_req_new_internal();
    st->buf = g_byte_array_sized_new(1);
    fu_byte_array_set_size(st->buf, 1, 0x0);
    fu_struct_steelseries_fizz_version2_req_set_cmd(st, FU_STEELSERIES_FIZZ_CMD_VERSION2);
    return st;
}
/**
 * fu_struct_steelseries_version2_res2_ref: (skip):
 **/
FuStructSteelseriesVersion2Res2 *
fu_struct_steelseries_version2_res2_ref(FuStructSteelseriesVersion2Res2 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_steelseries_version2_res2_unref: (skip):
 **/
void
fu_struct_steelseries_version2_res2_unref(FuStructSteelseriesVersion2Res2 *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSteelseriesVersion2Res2 refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_steelseries_version2_res2_new_internal: (skip):
 **/
static FuStructSteelseriesVersion2Res2 *
fu_struct_steelseries_version2_res2_new_internal(void)
{
    FuStructSteelseriesVersion2Res2 *st = g_new0(FuStructSteelseriesVersion2Res2, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_steelseries_version2_res2_get_version1: (skip):
 **/
gchar *
fu_struct_steelseries_version2_res2_get_version1(const FuStructSteelseriesVersion2Res2 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 1, 12, NULL);
}
/**
 * fu_struct_steelseries_version2_res2_get_version2: (skip):
 **/
gchar *
fu_struct_steelseries_version2_res2_get_version2(const FuStructSteelseriesVersion2Res2 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 25, 12, NULL);
}

/* setters */
/**
 * fu_struct_steelseries_version2_res2_to_string: (skip):
 **/
static gchar *
fu_struct_steelseries_version2_res2_to_string(const FuStructSteelseriesVersion2Res2 *st)
{
    g_autoptr(GString) str = g_string_new("FuStructSteelseriesVersion2Res2:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fu_struct_steelseries_version2_res2_get_version1(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  version1: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_steelseries_version2_res2_get_version2(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  version2: %s\n", tmp);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_steelseries_version2_res2_validate_internal(FuStructSteelseriesVersion2Res2 *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_steelseries_version2_res2_parse_internal(FuStructSteelseriesVersion2Res2 *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_steelseries_version2_res2_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_steelseries_version2_res2_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_steelseries_version2_res2_parse: (skip):
 **/
FuStructSteelseriesVersion2Res2 *
fu_struct_steelseries_version2_res2_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructSteelseriesVersion2Res2) st = fu_struct_steelseries_version2_res2_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 37, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructSteelseriesVersion2Res2: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 37);
    if (!fu_struct_steelseries_version2_res2_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_steelseries_version2_res3_ref: (skip):
 **/
FuStructSteelseriesVersion2Res3 *
fu_struct_steelseries_version2_res3_ref(FuStructSteelseriesVersion2Res3 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_steelseries_version2_res3_unref: (skip):
 **/
void
fu_struct_steelseries_version2_res3_unref(FuStructSteelseriesVersion2Res3 *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSteelseriesVersion2Res3 refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_steelseries_version2_res3_new_internal: (skip):
 **/
static FuStructSteelseriesVersion2Res3 *
fu_struct_steelseries_version2_res3_new_internal(void)
{
    FuStructSteelseriesVersion2Res3 *st = g_new0(FuStructSteelseriesVersion2Res3, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_steelseries_version2_res3_get_version1: (skip):
 **/
gchar *
fu_struct_steelseries_version2_res3_get_version1(const FuStructSteelseriesVersion2Res3 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 1, 12, NULL);
}
/**
 * fu_struct_steelseries_version2_res3_get_version2: (skip):
 **/
gchar *
fu_struct_steelseries_version2_res3_get_version2(const FuStructSteelseriesVersion2Res3 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 13, 12, NULL);
}

/* setters */
/**
 * fu_struct_steelseries_version2_res3_to_string: (skip):
 **/
static gchar *
fu_struct_steelseries_version2_res3_to_string(const FuStructSteelseriesVersion2Res3 *st)
{
    g_autoptr(GString) str = g_string_new("FuStructSteelseriesVersion2Res3:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fu_struct_steelseries_version2_res3_get_version1(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  version1: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_steelseries_version2_res3_get_version2(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  version2: %s\n", tmp);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_steelseries_version2_res3_validate_internal(FuStructSteelseriesVersion2Res3 *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_steelseries_version2_res3_parse_internal(FuStructSteelseriesVersion2Res3 *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_steelseries_version2_res3_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_steelseries_version2_res3_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_steelseries_version2_res3_parse: (skip):
 **/
FuStructSteelseriesVersion2Res3 *
fu_struct_steelseries_version2_res3_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructSteelseriesVersion2Res3) st = fu_struct_steelseries_version2_res3_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 25, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructSteelseriesVersion2Res3: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 25);
    if (!fu_struct_steelseries_version2_res3_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_steelseries_battery_level2_req_ref: (skip):
 **/
FuStructSteelseriesBatteryLevel2Req *
fu_struct_steelseries_battery_level2_req_ref(FuStructSteelseriesBatteryLevel2Req *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_steelseries_battery_level2_req_unref: (skip):
 **/
void
fu_struct_steelseries_battery_level2_req_unref(FuStructSteelseriesBatteryLevel2Req *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSteelseriesBatteryLevel2Req refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_steelseries_battery_level2_req_new_internal: (skip):
 **/
static FuStructSteelseriesBatteryLevel2Req *
fu_struct_steelseries_battery_level2_req_new_internal(void)
{
    FuStructSteelseriesBatteryLevel2Req *st = g_new0(FuStructSteelseriesBatteryLevel2Req, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_steelseries_battery_level2_req_set_cmd: (skip):
 **/
static void
fu_struct_steelseries_battery_level2_req_set_cmd(FuStructSteelseriesBatteryLevel2Req *st, FuSteelseriesFizzCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_steelseries_battery_level2_req_new: (skip):
 **/
FuStructSteelseriesBatteryLevel2Req *
fu_struct_steelseries_battery_level2_req_new(void)
{
    FuStructSteelseriesBatteryLevel2Req *st = fu_struct_steelseries_battery_level2_req_new_internal();
    st->buf = g_byte_array_sized_new(1);
    fu_byte_array_set_size(st->buf, 1, 0x0);
    fu_struct_steelseries_battery_level2_req_set_cmd(st, FU_STEELSERIES_FIZZ_CMD_CONNECTION_STATUS2);
    return st;
}
/**
 * fu_struct_steelseries_battery_level2_res_ref: (skip):
 **/
FuStructSteelseriesBatteryLevel2Res *
fu_struct_steelseries_battery_level2_res_ref(FuStructSteelseriesBatteryLevel2Res *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_steelseries_battery_level2_res_unref: (skip):
 **/
void
fu_struct_steelseries_battery_level2_res_unref(FuStructSteelseriesBatteryLevel2Res *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSteelseriesBatteryLevel2Res refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_steelseries_battery_level2_res_new_internal: (skip):
 **/
static FuStructSteelseriesBatteryLevel2Res *
fu_struct_steelseries_battery_level2_res_new_internal(void)
{
    FuStructSteelseriesBatteryLevel2Res *st = g_new0(FuStructSteelseriesBatteryLevel2Res, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_steelseries_battery_level2_res_get_level: (skip):
 **/
guint8
fu_struct_steelseries_battery_level2_res_get_level(const FuStructSteelseriesBatteryLevel2Res *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[3];
}

/* setters */
/**
 * fu_struct_steelseries_battery_level2_res_to_string: (skip):
 **/
static gchar *
fu_struct_steelseries_battery_level2_res_to_string(const FuStructSteelseriesBatteryLevel2Res *st)
{
    g_autoptr(GString) str = g_string_new("FuStructSteelseriesBatteryLevel2Res:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  level: 0x%x\n",
                           (guint) fu_struct_steelseries_battery_level2_res_get_level(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_steelseries_battery_level2_res_validate_internal(FuStructSteelseriesBatteryLevel2Res *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_steelseries_battery_level2_res_parse_internal(FuStructSteelseriesBatteryLevel2Res *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_steelseries_battery_level2_res_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_steelseries_battery_level2_res_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_steelseries_battery_level2_res_parse: (skip):
 **/
FuStructSteelseriesBatteryLevel2Res *
fu_struct_steelseries_battery_level2_res_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructSteelseriesBatteryLevel2Res) st = fu_struct_steelseries_battery_level2_res_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 4, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructSteelseriesBatteryLevel2Res: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 4);
    if (!fu_struct_steelseries_battery_level2_res_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_steelseries_connection_status2_req_ref: (skip):
 **/
FuStructSteelseriesConnectionStatus2Req *
fu_struct_steelseries_connection_status2_req_ref(FuStructSteelseriesConnectionStatus2Req *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_steelseries_connection_status2_req_unref: (skip):
 **/
void
fu_struct_steelseries_connection_status2_req_unref(FuStructSteelseriesConnectionStatus2Req *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSteelseriesConnectionStatus2Req refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_steelseries_connection_status2_req_new_internal: (skip):
 **/
static FuStructSteelseriesConnectionStatus2Req *
fu_struct_steelseries_connection_status2_req_new_internal(void)
{
    FuStructSteelseriesConnectionStatus2Req *st = g_new0(FuStructSteelseriesConnectionStatus2Req, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_steelseries_connection_status2_req_set_cmd: (skip):
 **/
static void
fu_struct_steelseries_connection_status2_req_set_cmd(FuStructSteelseriesConnectionStatus2Req *st, FuSteelseriesFizzCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_steelseries_connection_status2_req_new: (skip):
 **/
FuStructSteelseriesConnectionStatus2Req *
fu_struct_steelseries_connection_status2_req_new(void)
{
    FuStructSteelseriesConnectionStatus2Req *st = fu_struct_steelseries_connection_status2_req_new_internal();
    st->buf = g_byte_array_sized_new(1);
    fu_byte_array_set_size(st->buf, 1, 0x0);
    fu_struct_steelseries_connection_status2_req_set_cmd(st, FU_STEELSERIES_FIZZ_CMD_CONNECTION_STATUS2);
    return st;
}
/**
 * fu_struct_steelseries_connection_status2_res_ref: (skip):
 **/
FuStructSteelseriesConnectionStatus2Res *
fu_struct_steelseries_connection_status2_res_ref(FuStructSteelseriesConnectionStatus2Res *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_steelseries_connection_status2_res_unref: (skip):
 **/
void
fu_struct_steelseries_connection_status2_res_unref(FuStructSteelseriesConnectionStatus2Res *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSteelseriesConnectionStatus2Res refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_steelseries_connection_status2_res_new_internal: (skip):
 **/
static FuStructSteelseriesConnectionStatus2Res *
fu_struct_steelseries_connection_status2_res_new_internal(void)
{
    FuStructSteelseriesConnectionStatus2Res *st = g_new0(FuStructSteelseriesConnectionStatus2Res, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_steelseries_connection_status2_res_get_status: (skip):
 **/
FuSteelseriesFizzConnection
fu_struct_steelseries_connection_status2_res_get_status(const FuStructSteelseriesConnectionStatus2Res *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}

/* setters */
/**
 * fu_struct_steelseries_connection_status2_res_to_string: (skip):
 **/
static gchar *
fu_struct_steelseries_connection_status2_res_to_string(const FuStructSteelseriesConnectionStatus2Res *st)
{
    g_autoptr(GString) str = g_string_new("FuStructSteelseriesConnectionStatus2Res:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_steelseries_fizz_connection_to_string(fu_struct_steelseries_connection_status2_res_get_status(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  status: 0x%x [%s]\n", (guint) fu_struct_steelseries_connection_status2_res_get_status(st), tmp);
        } else {
            g_string_append_printf(str, "  status: 0x%x\n", (guint) fu_struct_steelseries_connection_status2_res_get_status(st));
        }
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_steelseries_connection_status2_res_validate_internal(FuStructSteelseriesConnectionStatus2Res *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_steelseries_connection_status2_res_parse_internal(FuStructSteelseriesConnectionStatus2Res *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_steelseries_connection_status2_res_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_steelseries_connection_status2_res_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_steelseries_connection_status2_res_parse: (skip):
 **/
FuStructSteelseriesConnectionStatus2Res *
fu_struct_steelseries_connection_status2_res_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructSteelseriesConnectionStatus2Res) st = fu_struct_steelseries_connection_status2_res_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 2, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructSteelseriesConnectionStatus2Res: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 2);
    if (!fu_struct_steelseries_connection_status2_res_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_steelseries_serial2_req_ref: (skip):
 **/
FuStructSteelseriesSerial2Req *
fu_struct_steelseries_serial2_req_ref(FuStructSteelseriesSerial2Req *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_steelseries_serial2_req_unref: (skip):
 **/
void
fu_struct_steelseries_serial2_req_unref(FuStructSteelseriesSerial2Req *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSteelseriesSerial2Req refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_steelseries_serial2_req_new_internal: (skip):
 **/
static FuStructSteelseriesSerial2Req *
fu_struct_steelseries_serial2_req_new_internal(void)
{
    FuStructSteelseriesSerial2Req *st = g_new0(FuStructSteelseriesSerial2Req, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_steelseries_serial2_req_set_cmd: (skip):
 **/
static void
fu_struct_steelseries_serial2_req_set_cmd(FuStructSteelseriesSerial2Req *st, FuSteelseriesFizzCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_steelseries_serial2_req_new: (skip):
 **/
FuStructSteelseriesSerial2Req *
fu_struct_steelseries_serial2_req_new(void)
{
    FuStructSteelseriesSerial2Req *st = fu_struct_steelseries_serial2_req_new_internal();
    st->buf = g_byte_array_sized_new(1);
    fu_byte_array_set_size(st->buf, 1, 0x0);
    fu_struct_steelseries_serial2_req_set_cmd(st, FU_STEELSERIES_FIZZ_CMD_SERIAL2);
    return st;
}
/**
 * fu_struct_steelseries_serial2_res2_ref: (skip):
 **/
FuStructSteelseriesSerial2Res2 *
fu_struct_steelseries_serial2_res2_ref(FuStructSteelseriesSerial2Res2 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_steelseries_serial2_res2_unref: (skip):
 **/
void
fu_struct_steelseries_serial2_res2_unref(FuStructSteelseriesSerial2Res2 *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSteelseriesSerial2Res2 refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_steelseries_serial2_res2_new_internal: (skip):
 **/
static FuStructSteelseriesSerial2Res2 *
fu_struct_steelseries_serial2_res2_new_internal(void)
{
    FuStructSteelseriesSerial2Res2 *st = g_new0(FuStructSteelseriesSerial2Res2, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_steelseries_serial2_res2_get_serial: (skip):
 **/
gchar *
fu_struct_steelseries_serial2_res2_get_serial(const FuStructSteelseriesSerial2Res2 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 1, 19, NULL);
}

/* setters */
/**
 * fu_struct_steelseries_serial2_res2_to_string: (skip):
 **/
static gchar *
fu_struct_steelseries_serial2_res2_to_string(const FuStructSteelseriesSerial2Res2 *st)
{
    g_autoptr(GString) str = g_string_new("FuStructSteelseriesSerial2Res2:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fu_struct_steelseries_serial2_res2_get_serial(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  serial: %s\n", tmp);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_steelseries_serial2_res2_validate_internal(FuStructSteelseriesSerial2Res2 *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_steelseries_serial2_res2_parse_internal(FuStructSteelseriesSerial2Res2 *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_steelseries_serial2_res2_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_steelseries_serial2_res2_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_steelseries_serial2_res2_parse: (skip):
 **/
FuStructSteelseriesSerial2Res2 *
fu_struct_steelseries_serial2_res2_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructSteelseriesSerial2Res2) st = fu_struct_steelseries_serial2_res2_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 20, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructSteelseriesSerial2Res2: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 20);
    if (!fu_struct_steelseries_serial2_res2_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_steelseries_serial2_res3_ref: (skip):
 **/
FuStructSteelseriesSerial2Res3 *
fu_struct_steelseries_serial2_res3_ref(FuStructSteelseriesSerial2Res3 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_steelseries_serial2_res3_unref: (skip):
 **/
void
fu_struct_steelseries_serial2_res3_unref(FuStructSteelseriesSerial2Res3 *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSteelseriesSerial2Res3 refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_steelseries_serial2_res3_new_internal: (skip):
 **/
static FuStructSteelseriesSerial2Res3 *
fu_struct_steelseries_serial2_res3_new_internal(void)
{
    FuStructSteelseriesSerial2Res3 *st = g_new0(FuStructSteelseriesSerial2Res3, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_steelseries_serial2_res3_get_serial1: (skip):
 **/
gchar *
fu_struct_steelseries_serial2_res3_get_serial1(const FuStructSteelseriesSerial2Res3 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 1, 19, NULL);
}
/**
 * fu_struct_steelseries_serial2_res3_get_serial2: (skip):
 **/
gchar *
fu_struct_steelseries_serial2_res3_get_serial2(const FuStructSteelseriesSerial2Res3 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 20, 19, NULL);
}

/* setters */
/**
 * fu_struct_steelseries_serial2_res3_to_string: (skip):
 **/
static gchar *
fu_struct_steelseries_serial2_res3_to_string(const FuStructSteelseriesSerial2Res3 *st)
{
    g_autoptr(GString) str = g_string_new("FuStructSteelseriesSerial2Res3:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fu_struct_steelseries_serial2_res3_get_serial1(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  serial1: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_steelseries_serial2_res3_get_serial2(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  serial2: %s\n", tmp);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_steelseries_serial2_res3_validate_internal(FuStructSteelseriesSerial2Res3 *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_steelseries_serial2_res3_parse_internal(FuStructSteelseriesSerial2Res3 *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_steelseries_serial2_res3_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_steelseries_serial2_res3_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_steelseries_serial2_res3_parse: (skip):
 **/
FuStructSteelseriesSerial2Res3 *
fu_struct_steelseries_serial2_res3_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructSteelseriesSerial2Res3) st = fu_struct_steelseries_serial2_res3_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 39, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructSteelseriesSerial2Res3: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 39);
    if (!fu_struct_steelseries_serial2_res3_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
