/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-tpm-struct.h"
#include "fu-byte-array.h"
#include "fu-bytes.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

/**
 * fu_tpm_eventlog_item_kind_to_string:
 * @val: value, e.g. %FU_TPM_EVENTLOG_ITEM_KIND_POST_CODE
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_tpm_eventlog_item_kind_to_string(FuTpmEventlogItemKind val)
{
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_PREBOOT_CERT)
        return "preboot-cert";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_POST_CODE)
        return "post-code";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_NO_ACTION)
        return "no-action";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_SEPARATOR)
        return "separator";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_ACTION)
        return "action";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EVENT_TAG)
        return "event-tag";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_S_CRTM_CONTENTS)
        return "s-crtm-contents";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_S_CRTM_VERSION)
        return "s-crtm-version";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_CPU_MICROCODE)
        return "cpu-microcode";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_PLATFORM_CONFIG_FLAGS)
        return "platform-config-flags";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_TABLE_OF_DEVICES)
        return "table-of-devices";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_COMPACT_HASH)
        return "compact-hash";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_NONHOST_CODE)
        return "nonhost-code";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_NONHOST_CONFIG)
        return "nonhost-config";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_NONHOST_INFO)
        return "nonhost-info";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_OMIT_BOOT_DEVICE_EVENTS)
        return "omit-boot-device-events";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EFI_EVENT_BASE)
        return "efi-event-base";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EFI_VARIABLE_DRIVER_CONFIG)
        return "efi-variable-driver-config";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EFI_VARIABLE_BOOT)
        return "efi-variable-boot";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EFI_BOOT_SERVICES_APPLICATION)
        return "efi-boot-services-application";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EFI_BOOT_SERVICES_DRIVER)
        return "efi-boot-services-driver";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EFI_RUNTIME_SERVICES_DRIVER)
        return "efi-runtime-services-driver";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EFI_GPT_EVENT)
        return "efi-gpt-event";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EFI_ACTION)
        return "efi-action";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EFI_PLATFORM_FIRMWARE_BLOB)
        return "efi-platform-firmware-blob";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EFI_HANDOFF_TABLES)
        return "efi-handoff-tables";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EFI_HCRTM_EVENT)
        return "efi-hcrtm-event";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EFI_VARIABLE_AUTHORITY)
        return "efi-variable-authority";
    return NULL;
}
/**
 * fu_struct_tpm_event_log2_ref: (skip):
 **/
FuStructTpmEventLog2 *
fu_struct_tpm_event_log2_ref(FuStructTpmEventLog2 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_tpm_event_log2_unref: (skip):
 **/
void
fu_struct_tpm_event_log2_unref(FuStructTpmEventLog2 *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructTpmEventLog2 refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_tpm_event_log2_new_internal: (skip):
 **/
static FuStructTpmEventLog2 *
fu_struct_tpm_event_log2_new_internal(void)
{
    FuStructTpmEventLog2 *st = g_new0(FuStructTpmEventLog2, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_tpm_event_log2_get_pcr: (skip):
 **/
guint32
fu_struct_tpm_event_log2_get_pcr(const FuStructTpmEventLog2 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_tpm_event_log2_get_type: (skip):
 **/
FuTpmEventlogItemKind
fu_struct_tpm_event_log2_get_type(const FuStructTpmEventLog2 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_tpm_event_log2_get_digest_count: (skip):
 **/
guint32
fu_struct_tpm_event_log2_get_digest_count(const FuStructTpmEventLog2 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 8, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_tpm_event_log2_to_string: (skip):
 **/
static gchar *
fu_struct_tpm_event_log2_to_string(const FuStructTpmEventLog2 *st)
{
    g_autoptr(GString) str = g_string_new("FuStructTpmEventLog2:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  pcr: 0x%x\n",
                           (guint) fu_struct_tpm_event_log2_get_pcr(st));
    {
        const gchar *tmp = fu_tpm_eventlog_item_kind_to_string(fu_struct_tpm_event_log2_get_type(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  type: 0x%x [%s]\n", (guint) fu_struct_tpm_event_log2_get_type(st), tmp);
        } else {
            g_string_append_printf(str, "  type: 0x%x\n", (guint) fu_struct_tpm_event_log2_get_type(st));
        }
    }
    g_string_append_printf(str, "  digest_count: 0x%x\n",
                           (guint) fu_struct_tpm_event_log2_get_digest_count(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_tpm_event_log2_validate_internal(FuStructTpmEventLog2 *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_tpm_event_log2_parse_internal(FuStructTpmEventLog2 *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_tpm_event_log2_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_tpm_event_log2_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_tpm_event_log2_parse: (skip):
 **/
FuStructTpmEventLog2 *
fu_struct_tpm_event_log2_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructTpmEventLog2) st = fu_struct_tpm_event_log2_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 12, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructTpmEventLog2: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 12);
    if (!fu_struct_tpm_event_log2_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_tpm_efi_startup_locality_event_ref: (skip):
 **/
FuStructTpmEfiStartupLocalityEvent *
fu_struct_tpm_efi_startup_locality_event_ref(FuStructTpmEfiStartupLocalityEvent *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_tpm_efi_startup_locality_event_unref: (skip):
 **/
void
fu_struct_tpm_efi_startup_locality_event_unref(FuStructTpmEfiStartupLocalityEvent *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructTpmEfiStartupLocalityEvent refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_tpm_efi_startup_locality_event_new_internal: (skip):
 **/
static FuStructTpmEfiStartupLocalityEvent *
fu_struct_tpm_efi_startup_locality_event_new_internal(void)
{
    FuStructTpmEfiStartupLocalityEvent *st = g_new0(FuStructTpmEfiStartupLocalityEvent, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_tpm_efi_startup_locality_event_get_signature: (skip):
 **/
static gchar *
fu_struct_tpm_efi_startup_locality_event_get_signature(const FuStructTpmEfiStartupLocalityEvent *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 0, 16, NULL);
}
/**
 * fu_struct_tpm_efi_startup_locality_event_get_locality: (skip):
 **/
guint8
fu_struct_tpm_efi_startup_locality_event_get_locality(const FuStructTpmEfiStartupLocalityEvent *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[16];
}

/* setters */
/**
 * fu_struct_tpm_efi_startup_locality_event_to_string: (skip):
 **/
static gchar *
fu_struct_tpm_efi_startup_locality_event_to_string(const FuStructTpmEfiStartupLocalityEvent *st)
{
    g_autoptr(GString) str = g_string_new("FuStructTpmEfiStartupLocalityEvent:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  locality: 0x%x\n",
                           (guint) fu_struct_tpm_efi_startup_locality_event_get_locality(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_tpm_efi_startup_locality_event_validate_internal(FuStructTpmEfiStartupLocalityEvent *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (strncmp((const gchar *) (st->buf->data + 0), "StartupLocality", 16) != 0) {
        g_autofree gchar *str = fu_struct_tpm_efi_startup_locality_event_get_signature(st);
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructTpmEfiStartupLocalityEvent.signature was not valid, "
                    "expected 'StartupLocality' and got '%s'",
                    str);
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_tpm_efi_startup_locality_event_parse_internal(FuStructTpmEfiStartupLocalityEvent *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_tpm_efi_startup_locality_event_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_tpm_efi_startup_locality_event_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_tpm_efi_startup_locality_event_parse: (skip):
 **/
static FuStructTpmEfiStartupLocalityEvent *
fu_struct_tpm_efi_startup_locality_event_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructTpmEfiStartupLocalityEvent) st = fu_struct_tpm_efi_startup_locality_event_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 17, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructTpmEfiStartupLocalityEvent: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 17);
    if (!fu_struct_tpm_efi_startup_locality_event_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_tpm_efi_startup_locality_event_parse_bytes: (skip):
 **/
FuStructTpmEfiStartupLocalityEvent *
fu_struct_tpm_efi_startup_locality_event_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = fu_bytes_get_data_safe(blob, &bufsz, error);
    if (buf == NULL)
        return NULL;
    return fu_struct_tpm_efi_startup_locality_event_parse(buf, bufsz, offset, error);
}
/**
 * fu_struct_tpm_event_log1_item_ref: (skip):
 **/
FuStructTpmEventLog1Item *
fu_struct_tpm_event_log1_item_ref(FuStructTpmEventLog1Item *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_tpm_event_log1_item_unref: (skip):
 **/
void
fu_struct_tpm_event_log1_item_unref(FuStructTpmEventLog1Item *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructTpmEventLog1Item refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_tpm_event_log1_item_new_internal: (skip):
 **/
static FuStructTpmEventLog1Item *
fu_struct_tpm_event_log1_item_new_internal(void)
{
    FuStructTpmEventLog1Item *st = g_new0(FuStructTpmEventLog1Item, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_tpm_event_log1_item_get_pcr: (skip):
 **/
guint32
fu_struct_tpm_event_log1_item_get_pcr(const FuStructTpmEventLog1Item *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_tpm_event_log1_item_get_event_type: (skip):
 **/
guint32
fu_struct_tpm_event_log1_item_get_event_type(const FuStructTpmEventLog1Item *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_tpm_event_log1_item_get_digest: (skip):
 **/
const guint8 *
fu_struct_tpm_event_log1_item_get_digest(const FuStructTpmEventLog1Item *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 20;
    return st->buf->data + 8;
}
/**
 * fu_struct_tpm_event_log1_item_get_datasz: (skip):
 **/
guint32
fu_struct_tpm_event_log1_item_get_datasz(const FuStructTpmEventLog1Item *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 28, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_tpm_event_log1_item_to_string: (skip):
 **/
static gchar *
fu_struct_tpm_event_log1_item_to_string(const FuStructTpmEventLog1Item *st)
{
    g_autoptr(GString) str = g_string_new("FuStructTpmEventLog1Item:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  pcr: 0x%x\n",
                           (guint) fu_struct_tpm_event_log1_item_get_pcr(st));
    g_string_append_printf(str, "  event_type: 0x%x\n",
                           (guint) fu_struct_tpm_event_log1_item_get_event_type(st));
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_tpm_event_log1_item_get_digest(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  digest: 0x%s\n", tmp->str);
    }
    g_string_append_printf(str, "  datasz: 0x%x\n",
                           (guint) fu_struct_tpm_event_log1_item_get_datasz(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_tpm_event_log1_item_validate_internal(FuStructTpmEventLog1Item *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_tpm_event_log1_item_parse_internal(FuStructTpmEventLog1Item *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_tpm_event_log1_item_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_tpm_event_log1_item_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_tpm_event_log1_item_parse: (skip):
 **/
FuStructTpmEventLog1Item *
fu_struct_tpm_event_log1_item_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructTpmEventLog1Item) st = fu_struct_tpm_event_log1_item_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 32, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructTpmEventLog1Item: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 32);
    if (!fu_struct_tpm_event_log1_item_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
