/* password-dialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from password-dialog.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-client-46.0.h"
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <glib-object.h>
#include "geary-engine.h"
#include <gdk/gdk.h>
#include <gobject/gvaluecollector.h>

#define PASSWORD_DIALOG_PRIMARY_TEXT_MARKUP "<span weight=\"bold\" size=\"larger\">%s</span>"
#define PASSWORD_DIALOG_PRIMARY_TEXT_FIRST_TRY _ ("Geary requires your email password to continue")
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecPasswordDialog ParamSpecPasswordDialog;

struct _PasswordDialogPrivate {
	GtkDialog* dialog;
	GtkEntry* entry_password;
	GtkCheckButton* check_remember_password;
	GtkButton* ok_button;
	gchar* _password;
	gboolean _remember_password;
};

struct _ParamSpecPasswordDialog {
	GParamSpec parent_instance;
};

static gint PasswordDialog_private_offset;
static gpointer password_dialog_parent_class = NULL;

static void password_dialog_set_password (PasswordDialog* self,
                                   const gchar* value);
static void password_dialog_set_remember_password (PasswordDialog* self,
                                            gboolean value);
static void password_dialog_refresh_ok_button_sensitivity (PasswordDialog* self);
static void _password_dialog_refresh_ok_button_sensitivity_gtk_editable_changed (GtkEditable* _sender,
                                                                          gpointer self);
static void password_dialog_finalize (PasswordDialog * obj);
static GType password_dialog_get_type_once (void);

static inline gpointer
password_dialog_get_instance_private (PasswordDialog* self)
{
	return G_STRUCT_MEMBER_P (self, PasswordDialog_private_offset);
}

const gchar*
password_dialog_get_password (PasswordDialog* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (IS_PASSWORD_DIALOG (self), NULL);
	_tmp0_ = self->priv->_password;
	result = _tmp0_;
	return result;
}

static void
password_dialog_set_password (PasswordDialog* self,
                              const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (IS_PASSWORD_DIALOG (self));
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_password);
	self->priv->_password = _tmp0_;
}

gboolean
password_dialog_get_remember_password (PasswordDialog* self)
{
	gboolean result;
	g_return_val_if_fail (IS_PASSWORD_DIALOG (self), FALSE);
	result = self->priv->_remember_password;
	return result;
}

static void
password_dialog_set_remember_password (PasswordDialog* self,
                                       gboolean value)
{
	g_return_if_fail (IS_PASSWORD_DIALOG (self));
	self->priv->_remember_password = value;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_password_dialog_refresh_ok_button_sensitivity_gtk_editable_changed (GtkEditable* _sender,
                                                                     gpointer self)
{
	password_dialog_refresh_ok_button_sensitivity ((PasswordDialog*) self);
}

PasswordDialog*
password_dialog_construct (GType object_type,
                           GtkWindow* parent,
                           GearyAccountInformation* account,
                           GearyServiceInformation* service,
                           GearyCredentials* credentials)
{
	PasswordDialog* self = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp0_;
	GtkBuilder* _tmp1_;
	GObject* _tmp2_;
	GtkDialog* _tmp3_;
	GtkDialog* _tmp4_;
	GtkDialog* _tmp5_;
	GtkDialog* _tmp6_;
	GtkBuilder* _tmp7_;
	GObject* _tmp8_;
	GtkEntry* _tmp9_;
	GtkBuilder* _tmp10_;
	GObject* _tmp11_;
	GtkCheckButton* _tmp12_;
	GtkLabel* label_username = NULL;
	GtkBuilder* _tmp13_;
	GObject* _tmp14_;
	GtkLabel* _tmp15_;
	GtkLabel* label_smtp = NULL;
	GtkBuilder* _tmp16_;
	GObject* _tmp17_;
	GtkLabel* _tmp18_;
	GtkLabel* primary_text_label = NULL;
	GtkBuilder* _tmp19_;
	GObject* _tmp20_;
	GtkLabel* _tmp21_;
	GtkLabel* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GtkCheckButton* _tmp32_;
	gboolean _tmp33_;
	gboolean _tmp34_;
	GearyProtocol _tmp35_;
	GearyProtocol _tmp36_;
	GtkBuilder* _tmp38_;
	GObject* _tmp39_;
	GtkButton* _tmp40_;
	GtkEntry* _tmp41_;
	g_return_val_if_fail ((parent == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (parent, gtk_window_get_type ()), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT_INFORMATION), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (service, GEARY_TYPE_SERVICE_INFORMATION), NULL);
	g_return_val_if_fail ((credentials == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (credentials, GEARY_TYPE_CREDENTIALS), NULL);
	self = (PasswordDialog*) g_type_create_instance (object_type);
	_tmp0_ = gio_util_create_builder ("password-dialog.glade");
	builder = _tmp0_;
	_tmp1_ = builder;
	_tmp2_ = gtk_builder_get_object (_tmp1_, "PasswordDialog");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_dialog_get_type (), GtkDialog));
	_g_object_unref0 (self->priv->dialog);
	self->priv->dialog = _tmp3_;
	_tmp4_ = self->priv->dialog;
	gtk_window_set_transient_for (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_window_get_type (), GtkWindow), parent);
	_tmp5_ = self->priv->dialog;
	gtk_window_set_type_hint (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_window_get_type (), GtkWindow), GDK_WINDOW_TYPE_HINT_DIALOG);
	_tmp6_ = self->priv->dialog;
	gtk_dialog_set_default_response (_tmp6_, (gint) GTK_RESPONSE_OK);
	_tmp7_ = builder;
	_tmp8_ = gtk_builder_get_object (_tmp7_, "entry: password");
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_entry_get_type (), GtkEntry));
	_g_object_unref0 (self->priv->entry_password);
	self->priv->entry_password = _tmp9_;
	_tmp10_ = builder;
	_tmp11_ = gtk_builder_get_object (_tmp10_, "check: remember_password");
	_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_check_button_get_type (), GtkCheckButton));
	_g_object_unref0 (self->priv->check_remember_password);
	self->priv->check_remember_password = _tmp12_;
	_tmp13_ = builder;
	_tmp14_ = gtk_builder_get_object (_tmp13_, "label: username");
	_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_label_get_type (), GtkLabel));
	label_username = _tmp15_;
	_tmp16_ = builder;
	_tmp17_ = gtk_builder_get_object (_tmp16_, "label: smtp");
	_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_label_get_type (), GtkLabel));
	label_smtp = _tmp18_;
	_tmp19_ = builder;
	_tmp20_ = gtk_builder_get_object (_tmp19_, "primary_text_label");
	_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_label_get_type (), GtkLabel));
	primary_text_label = _tmp21_;
	_tmp22_ = primary_text_label;
	_tmp23_ = g_strdup_printf (PASSWORD_DIALOG_PRIMARY_TEXT_MARKUP, PASSWORD_DIALOG_PRIMARY_TEXT_FIRST_TRY);
	_tmp24_ = _tmp23_;
	gtk_label_set_markup (_tmp22_, _tmp24_);
	_g_free0 (_tmp24_);
	if (credentials != NULL) {
		GtkLabel* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		const gchar* _tmp28_ = NULL;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		GtkEntry* _tmp31_;
		_tmp25_ = label_username;
		_tmp26_ = geary_credentials_get_user (credentials);
		_tmp27_ = _tmp26_;
		gtk_label_set_text (_tmp25_, _tmp27_);
		_tmp29_ = geary_credentials_get_token (credentials);
		_tmp30_ = _tmp29_;
		_tmp28_ = _tmp30_;
		if (_tmp28_ == NULL) {
			_tmp28_ = "";
		}
		_tmp31_ = self->priv->entry_password;
		gtk_entry_set_text (_tmp31_, _tmp28_);
	}
	_tmp32_ = self->priv->check_remember_password;
	_tmp33_ = geary_service_information_get_remember_password (service);
	_tmp34_ = _tmp33_;
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, gtk_toggle_button_get_type (), GtkToggleButton), _tmp34_);
	_tmp35_ = geary_service_information_get_protocol (service);
	_tmp36_ = _tmp35_;
	if (_tmp36_ == GEARY_PROTOCOL_SMTP) {
		GtkLabel* _tmp37_;
		_tmp37_ = label_smtp;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_widget_get_type (), GtkWidget));
	}
	_tmp38_ = builder;
	_tmp39_ = gtk_builder_get_object (_tmp38_, "authenticate_button");
	_tmp40_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->ok_button);
	self->priv->ok_button = _tmp40_;
	password_dialog_refresh_ok_button_sensitivity (self);
	_tmp41_ = self->priv->entry_password;
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, gtk_editable_get_type (), GtkEditable), "changed", (GCallback) _password_dialog_refresh_ok_button_sensitivity_gtk_editable_changed, self);
	_g_object_unref0 (primary_text_label);
	_g_object_unref0 (label_smtp);
	_g_object_unref0 (label_username);
	_g_object_unref0 (builder);
	return self;
}

PasswordDialog*
password_dialog_new (GtkWindow* parent,
                     GearyAccountInformation* account,
                     GearyServiceInformation* service,
                     GearyCredentials* credentials)
{
	return password_dialog_construct (TYPE_PASSWORD_DIALOG, parent, account, service, credentials);
}

static void
password_dialog_refresh_ok_button_sensitivity (PasswordDialog* self)
{
	GtkButton* _tmp0_;
	GtkEntry* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (IS_PASSWORD_DIALOG (self));
	_tmp0_ = self->priv->ok_button;
	_tmp1_ = self->priv->entry_password;
	_tmp2_ = gtk_entry_get_text (_tmp1_);
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), !geary_string_is_empty_or_whitespace (_tmp2_));
}

gboolean
password_dialog_run (PasswordDialog* self)
{
	GtkDialog* _tmp0_;
	GtkResponseType response = 0;
	GtkDialog* _tmp1_;
	GtkDialog* _tmp7_;
	gboolean result;
	g_return_val_if_fail (IS_PASSWORD_DIALOG (self), FALSE);
	_tmp0_ = self->priv->dialog;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = self->priv->dialog;
	response = (GtkResponseType) gtk_dialog_run (_tmp1_);
	if (response == GTK_RESPONSE_OK) {
		GtkEntry* _tmp2_;
		const gchar* _tmp3_;
		GtkCheckButton* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp2_ = self->priv->entry_password;
		_tmp3_ = gtk_entry_get_text (_tmp2_);
		password_dialog_set_password (self, _tmp3_);
		_tmp4_ = self->priv->check_remember_password;
		_tmp5_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_toggle_button_get_type (), GtkToggleButton));
		_tmp6_ = _tmp5_;
		password_dialog_set_remember_password (self, _tmp6_);
	}
	_tmp7_ = self->priv->dialog;
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
	result = response == GTK_RESPONSE_OK;
	return result;
}

static void
value_password_dialog_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_password_dialog_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		password_dialog_unref (value->data[0].v_pointer);
	}
}

static void
value_password_dialog_copy_value (const GValue* src_value,
                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = password_dialog_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_password_dialog_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_password_dialog_collect_value (GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PasswordDialog * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = password_dialog_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_password_dialog_lcopy_value (const GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	PasswordDialog ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = password_dialog_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_password_dialog (const gchar* name,
                            const gchar* nick,
                            const gchar* blurb,
                            GType object_type,
                            GParamFlags flags)
{
	ParamSpecPasswordDialog* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PASSWORD_DIALOG), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_password_dialog (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PASSWORD_DIALOG), NULL);
	return value->data[0].v_pointer;
}

void
value_set_password_dialog (GValue* value,
                           gpointer v_object)
{
	PasswordDialog * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PASSWORD_DIALOG));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PASSWORD_DIALOG));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		password_dialog_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		password_dialog_unref (old);
	}
}

void
value_take_password_dialog (GValue* value,
                            gpointer v_object)
{
	PasswordDialog * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PASSWORD_DIALOG));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PASSWORD_DIALOG));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		password_dialog_unref (old);
	}
}

static void
password_dialog_class_init (PasswordDialogClass * klass,
                            gpointer klass_data)
{
	password_dialog_parent_class = g_type_class_peek_parent (klass);
	((PasswordDialogClass *) klass)->finalize = password_dialog_finalize;
	g_type_class_adjust_private_offset (klass, &PasswordDialog_private_offset);
}

static void
password_dialog_instance_init (PasswordDialog * self,
                               gpointer klass)
{
	gchar* _tmp0_;
	self->priv = password_dialog_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_password = _tmp0_;
	self->ref_count = 1;
}

static void
password_dialog_finalize (PasswordDialog * obj)
{
	PasswordDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PASSWORD_DIALOG, PasswordDialog);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->dialog);
	_g_object_unref0 (self->priv->entry_password);
	_g_object_unref0 (self->priv->check_remember_password);
	_g_object_unref0 (self->priv->ok_button);
	_g_free0 (self->priv->_password);
}

/**
 * Displays a dialog for collecting the user's password, without allowing them to change their
 * other data.
 */
static GType
password_dialog_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_password_dialog_init, value_password_dialog_free_value, value_password_dialog_copy_value, value_password_dialog_peek_pointer, "p", value_password_dialog_collect_value, "p", value_password_dialog_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PasswordDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) password_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PasswordDialog), 0, (GInstanceInitFunc) password_dialog_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType password_dialog_type_id;
	password_dialog_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PasswordDialog", &g_define_type_info, &g_define_type_fundamental_info, 0);
	PasswordDialog_private_offset = g_type_add_instance_private (password_dialog_type_id, sizeof (PasswordDialogPrivate));
	return password_dialog_type_id;
}

GType
password_dialog_get_type (void)
{
	static volatile gsize password_dialog_type_id__once = 0;
	if (g_once_init_enter (&password_dialog_type_id__once)) {
		GType password_dialog_type_id;
		password_dialog_type_id = password_dialog_get_type_once ();
		g_once_init_leave (&password_dialog_type_id__once, password_dialog_type_id);
	}
	return password_dialog_type_id__once;
}

gpointer
password_dialog_ref (gpointer instance)
{
	PasswordDialog * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
password_dialog_unref (gpointer instance)
{
	PasswordDialog * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PASSWORD_DIALOG_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

