/* folder-list-inboxes-branch.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from folder-list-inboxes-branch.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/* A special branch that sits before the accounts branches, containing only*/
/* the inboxes for all accounts.*/

#include "geary-client-46.0.h"
#include <gee.h>
#include <glib-object.h>
#include "geary-engine.h"
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	FOLDER_LIST_INBOXES_BRANCH_0_PROPERTY,
	FOLDER_LIST_INBOXES_BRANCH_FOLDER_ENTRIES_PROPERTY,
	FOLDER_LIST_INBOXES_BRANCH_NUM_PROPERTIES
};
static GParamSpec* folder_list_inboxes_branch_properties[FOLDER_LIST_INBOXES_BRANCH_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FolderListInboxesBranchPrivate {
	GeeHashMap* _folder_entries;
};

static gint FolderListInboxesBranch_private_offset;
static gpointer folder_list_inboxes_branch_parent_class = NULL;

static void folder_list_inboxes_branch_set_folder_entries (FolderListInboxesBranch* self,
                                                    GeeHashMap* value);
static gint folder_list_inboxes_branch_inbox_comparator (SidebarEntry* a,
                                                  SidebarEntry* b);
static gint _folder_list_inboxes_branch_inbox_comparator_gcompare_func (gconstpointer a,
                                                                 gconstpointer b);
static void folder_list_inboxes_branch_on_ordinal_changed (FolderListInboxesBranch* self);
static void _folder_list_inboxes_branch_on_ordinal_changed_g_object_notify (GObject* _sender,
                                                                     GParamSpec* pspec,
                                                                     gpointer self);
static void folder_list_inboxes_branch_finalize (GObject * obj);
static GType folder_list_inboxes_branch_get_type_once (void);
static void _vala_folder_list_inboxes_branch_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_folder_list_inboxes_branch_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);

static inline gpointer
folder_list_inboxes_branch_get_instance_private (FolderListInboxesBranch* self)
{
	return G_STRUCT_MEMBER_P (self, FolderListInboxesBranch_private_offset);
}

GeeHashMap*
folder_list_inboxes_branch_get_folder_entries (FolderListInboxesBranch* self)
{
	GeeHashMap* result;
	GeeHashMap* _tmp0_;
	g_return_val_if_fail (FOLDER_LIST_IS_INBOXES_BRANCH (self), NULL);
	_tmp0_ = self->priv->_folder_entries;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
folder_list_inboxes_branch_set_folder_entries (FolderListInboxesBranch* self,
                                               GeeHashMap* value)
{
	GeeHashMap* old_value;
	g_return_if_fail (FOLDER_LIST_IS_INBOXES_BRANCH (self));
	old_value = folder_list_inboxes_branch_get_folder_entries (self);
	if (old_value != value) {
		GeeHashMap* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_folder_entries);
		self->priv->_folder_entries = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, folder_list_inboxes_branch_properties[FOLDER_LIST_INBOXES_BRANCH_FOLDER_ENTRIES_PROPERTY]);
	}
}

static gint
_folder_list_inboxes_branch_inbox_comparator_gcompare_func (gconstpointer a,
                                                            gconstpointer b)
{
	gint result;
	result = folder_list_inboxes_branch_inbox_comparator ((SidebarEntry*) a, (SidebarEntry*) b);
	return result;
}

FolderListInboxesBranch*
folder_list_inboxes_branch_construct (GType object_type)
{
	FolderListInboxesBranch * self = NULL;
	SidebarHeader* _tmp0_;
	SidebarHeader* _tmp1_;
	_tmp0_ = sidebar_header_new (_ ("Inboxes"), TRUE);
	_tmp1_ = _tmp0_;
	self = (FolderListInboxesBranch*) sidebar_branch_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, SIDEBAR_TYPE_ENTRY, SidebarEntry), SIDEBAR_BRANCH_OPTIONS_STARTUP_OPEN_GROUPING, _folder_list_inboxes_branch_inbox_comparator_gcompare_func, NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

FolderListInboxesBranch*
folder_list_inboxes_branch_new (void)
{
	return folder_list_inboxes_branch_construct (FOLDER_LIST_TYPE_INBOXES_BRANCH);
}

static gint
folder_list_inboxes_branch_inbox_comparator (SidebarEntry* a,
                                             SidebarEntry* b)
{
	FolderListInboxFolderEntry* entry_a = NULL;
	FolderListInboxFolderEntry* _tmp0_;
	FolderListInboxFolderEntry* entry_b = NULL;
	FolderListInboxFolderEntry* _tmp1_;
	GearyAccountInformation* _tmp2_;
	GearyAccountInformation* _tmp3_;
	GearyAccountInformation* _tmp4_;
	GearyAccountInformation* _tmp5_;
	gint _tmp6_;
	gint result;
	g_return_val_if_fail (SIDEBAR_IS_ENTRY (a), 0);
	g_return_val_if_fail (SIDEBAR_IS_ENTRY (b), 0);
	_vala_assert (FOLDER_LIST_IS_INBOX_FOLDER_ENTRY (a), "a is InboxFolderEntry");
	_vala_assert (FOLDER_LIST_IS_INBOX_FOLDER_ENTRY (b), "b is InboxFolderEntry");
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (a, FOLDER_LIST_TYPE_INBOX_FOLDER_ENTRY, FolderListInboxFolderEntry));
	entry_a = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (b, FOLDER_LIST_TYPE_INBOX_FOLDER_ENTRY, FolderListInboxFolderEntry));
	entry_b = _tmp1_;
	_tmp2_ = folder_list_inbox_folder_entry_get_account_information (entry_a);
	_tmp3_ = _tmp2_;
	_tmp4_ = folder_list_inbox_folder_entry_get_account_information (entry_b);
	_tmp5_ = _tmp4_;
	_tmp6_ = geary_account_information_compare_ascending (_tmp3_, _tmp5_);
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (_tmp3_);
	result = _tmp6_;
	_g_object_unref0 (entry_b);
	_g_object_unref0 (entry_a);
	return result;
}

FolderListInboxFolderEntry*
folder_list_inboxes_branch_get_entry_for_account (FolderListInboxesBranch* self,
                                                  GearyAccount* account)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	FolderListInboxFolderEntry* result;
	g_return_val_if_fail (FOLDER_LIST_IS_INBOXES_BRANCH (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT), NULL);
	_tmp0_ = self->priv->_folder_entries;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), account);
	result = (FolderListInboxFolderEntry*) _tmp1_;
	return result;
}

static void
_folder_list_inboxes_branch_on_ordinal_changed_g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self)
{
	folder_list_inboxes_branch_on_ordinal_changed ((FolderListInboxesBranch*) self);
}

void
folder_list_inboxes_branch_add_inbox (FolderListInboxesBranch* self,
                                      ApplicationFolderContext* inbox)
{
	FolderListInboxFolderEntry* folder_entry = NULL;
	FolderListInboxFolderEntry* _tmp0_;
	SidebarEntry* _tmp1_;
	SidebarEntry* _tmp2_;
	GeeHashMap* _tmp3_;
	GearyFolder* _tmp4_;
	GearyFolder* _tmp5_;
	GearyAccount* _tmp6_;
	GearyAccount* _tmp7_;
	GearyFolder* _tmp8_;
	GearyFolder* _tmp9_;
	GearyAccount* _tmp10_;
	GearyAccount* _tmp11_;
	GearyAccountInformation* _tmp12_;
	GearyAccountInformation* _tmp13_;
	g_return_if_fail (FOLDER_LIST_IS_INBOXES_BRANCH (self));
	g_return_if_fail (APPLICATION_IS_FOLDER_CONTEXT (inbox));
	_tmp0_ = folder_list_inbox_folder_entry_new (inbox);
	folder_entry = _tmp0_;
	_tmp1_ = sidebar_branch_get_root (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_BRANCH, SidebarBranch));
	_tmp2_ = _tmp1_;
	sidebar_branch_graft (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_BRANCH, SidebarBranch), _tmp2_, G_TYPE_CHECK_INSTANCE_CAST (folder_entry, SIDEBAR_TYPE_ENTRY, SidebarEntry), NULL);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = self->priv->_folder_entries;
	_tmp4_ = application_folder_context_get_folder (inbox);
	_tmp5_ = _tmp4_;
	_tmp6_ = geary_folder_get_account (_tmp5_);
	_tmp7_ = _tmp6_;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp7_, folder_entry);
	_tmp8_ = application_folder_context_get_folder (inbox);
	_tmp9_ = _tmp8_;
	_tmp10_ = geary_folder_get_account (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = geary_account_get_information (_tmp11_);
	_tmp13_ = _tmp12_;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, G_TYPE_OBJECT, GObject), "notify::ordinal", (GCallback) _folder_list_inboxes_branch_on_ordinal_changed_g_object_notify, self, 0);
	_g_object_unref0 (folder_entry);
}

void
folder_list_inboxes_branch_remove_inbox (FolderListInboxesBranch* self,
                                         GearyAccount* account)
{
	SidebarEntry* entry = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	SidebarEntry* _tmp2_;
	GearyAccountInformation* _tmp5_;
	GearyAccountInformation* _tmp6_;
	guint _tmp7_;
	GQuark _tmp8_;
	SidebarEntry* _tmp9_;
	GeeHashMap* _tmp10_;
	g_return_if_fail (FOLDER_LIST_IS_INBOXES_BRANCH (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT));
	_tmp0_ = self->priv->_folder_entries;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), account);
	entry = G_TYPE_CHECK_INSTANCE_CAST ((FolderListInboxFolderEntry*) _tmp1_, SIDEBAR_TYPE_ENTRY, SidebarEntry);
	_tmp2_ = entry;
	if (_tmp2_ == NULL) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (account, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
		_tmp4_ = _tmp3_;
		g_debug ("folder-list-inboxes-branch.vala:46: Could not remove inbox for %s", _tmp4_);
		_g_free0 (_tmp4_);
		_g_object_unref0 (entry);
		return;
	}
	_tmp5_ = geary_account_get_information (account);
	_tmp6_ = _tmp5_;
	g_signal_parse_name ("notify::ordinal", G_TYPE_OBJECT, &_tmp7_, &_tmp8_, TRUE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, G_TYPE_OBJECT, GObject), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, _tmp8_, NULL, (GCallback) _folder_list_inboxes_branch_on_ordinal_changed_g_object_notify, self);
	_tmp9_ = entry;
	sidebar_branch_prune (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_BRANCH, SidebarBranch), _tmp9_);
	_tmp10_ = self->priv->_folder_entries;
	gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), account, NULL);
	_g_object_unref0 (entry);
}

static void
folder_list_inboxes_branch_on_ordinal_changed (FolderListInboxesBranch* self)
{
	g_return_if_fail (FOLDER_LIST_IS_INBOXES_BRANCH (self));
	sidebar_branch_reorder_all (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_BRANCH, SidebarBranch));
}

static void
folder_list_inboxes_branch_class_init (FolderListInboxesBranchClass * klass,
                                       gpointer klass_data)
{
	folder_list_inboxes_branch_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FolderListInboxesBranch_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_folder_list_inboxes_branch_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folder_list_inboxes_branch_set_property;
	G_OBJECT_CLASS (klass)->finalize = folder_list_inboxes_branch_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLDER_LIST_INBOXES_BRANCH_FOLDER_ENTRIES_PROPERTY, folder_list_inboxes_branch_properties[FOLDER_LIST_INBOXES_BRANCH_FOLDER_ENTRIES_PROPERTY] = g_param_spec_object ("folder-entries", "folder-entries", "folder-entries", GEE_TYPE_HASH_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
folder_list_inboxes_branch_instance_init (FolderListInboxesBranch * self,
                                          gpointer klass)
{
	GeeHashMap* _tmp0_;
	self->priv = folder_list_inboxes_branch_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (GEARY_TYPE_ACCOUNT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, FOLDER_LIST_TYPE_INBOX_FOLDER_ENTRY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->_folder_entries = _tmp0_;
}

static void
folder_list_inboxes_branch_finalize (GObject * obj)
{
	FolderListInboxesBranch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLDER_LIST_TYPE_INBOXES_BRANCH, FolderListInboxesBranch);
	_g_object_unref0 (self->priv->_folder_entries);
	G_OBJECT_CLASS (folder_list_inboxes_branch_parent_class)->finalize (obj);
}

static GType
folder_list_inboxes_branch_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolderListInboxesBranchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folder_list_inboxes_branch_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolderListInboxesBranch), 0, (GInstanceInitFunc) folder_list_inboxes_branch_instance_init, NULL };
	GType folder_list_inboxes_branch_type_id;
	folder_list_inboxes_branch_type_id = g_type_register_static (SIDEBAR_TYPE_BRANCH, "FolderListInboxesBranch", &g_define_type_info, 0);
	FolderListInboxesBranch_private_offset = g_type_add_instance_private (folder_list_inboxes_branch_type_id, sizeof (FolderListInboxesBranchPrivate));
	return folder_list_inboxes_branch_type_id;
}

GType
folder_list_inboxes_branch_get_type (void)
{
	static volatile gsize folder_list_inboxes_branch_type_id__once = 0;
	if (g_once_init_enter (&folder_list_inboxes_branch_type_id__once)) {
		GType folder_list_inboxes_branch_type_id;
		folder_list_inboxes_branch_type_id = folder_list_inboxes_branch_get_type_once ();
		g_once_init_leave (&folder_list_inboxes_branch_type_id__once, folder_list_inboxes_branch_type_id);
	}
	return folder_list_inboxes_branch_type_id__once;
}

static void
_vala_folder_list_inboxes_branch_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	FolderListInboxesBranch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLDER_LIST_TYPE_INBOXES_BRANCH, FolderListInboxesBranch);
	switch (property_id) {
		case FOLDER_LIST_INBOXES_BRANCH_FOLDER_ENTRIES_PROPERTY:
		g_value_set_object (value, folder_list_inboxes_branch_get_folder_entries (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_folder_list_inboxes_branch_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	FolderListInboxesBranch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLDER_LIST_TYPE_INBOXES_BRANCH, FolderListInboxesBranch);
	switch (property_id) {
		case FOLDER_LIST_INBOXES_BRANCH_FOLDER_ENTRIES_PROPERTY:
		folder_list_inboxes_branch_set_folder_entries (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

