/* imap-mailbox-information.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from imap-mailbox-information.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GEARY_IMAP_MAILBOX_INFORMATION_0_PROPERTY,
	GEARY_IMAP_MAILBOX_INFORMATION_MAILBOX_PROPERTY,
	GEARY_IMAP_MAILBOX_INFORMATION_DELIM_PROPERTY,
	GEARY_IMAP_MAILBOX_INFORMATION_ATTRS_PROPERTY,
	GEARY_IMAP_MAILBOX_INFORMATION_NUM_PROPERTIES
};
static GParamSpec* geary_imap_mailbox_information_properties[GEARY_IMAP_MAILBOX_INFORMATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GearyImapMailboxInformationPrivate {
	GearyImapMailboxSpecifier* _mailbox;
	gchar* _delim;
	GearyImapMailboxAttributes* _attrs;
};

static gint GearyImapMailboxInformation_private_offset;
static gpointer geary_imap_mailbox_information_parent_class = NULL;

static void geary_imap_mailbox_information_set_mailbox (GearyImapMailboxInformation* self,
                                                 GearyImapMailboxSpecifier* value);
static void geary_imap_mailbox_information_set_delim (GearyImapMailboxInformation* self,
                                               const gchar* value);
static void geary_imap_mailbox_information_set_attrs (GearyImapMailboxInformation* self,
                                               GearyImapMailboxAttributes* value);
static void geary_imap_mailbox_information_finalize (GObject * obj);
static GType geary_imap_mailbox_information_get_type_once (void);
static void _vala_geary_imap_mailbox_information_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec);
static void _vala_geary_imap_mailbox_information_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec);

static inline gpointer
geary_imap_mailbox_information_get_instance_private (GearyImapMailboxInformation* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapMailboxInformation_private_offset);
}

GearyImapMailboxSpecifier*
geary_imap_mailbox_information_get_mailbox (GearyImapMailboxInformation* self)
{
	GearyImapMailboxSpecifier* result;
	GearyImapMailboxSpecifier* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_MAILBOX_INFORMATION (self), NULL);
	_tmp0_ = self->priv->_mailbox;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_imap_mailbox_information_set_mailbox (GearyImapMailboxInformation* self,
                                            GearyImapMailboxSpecifier* value)
{
	GearyImapMailboxSpecifier* old_value;
	g_return_if_fail (GEARY_IMAP_IS_MAILBOX_INFORMATION (self));
	old_value = geary_imap_mailbox_information_get_mailbox (self);
	if (old_value != value) {
		GearyImapMailboxSpecifier* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_mailbox);
		self->priv->_mailbox = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_mailbox_information_properties[GEARY_IMAP_MAILBOX_INFORMATION_MAILBOX_PROPERTY]);
	}
}

const gchar*
geary_imap_mailbox_information_get_delim (GearyImapMailboxInformation* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_MAILBOX_INFORMATION (self), NULL);
	_tmp0_ = self->priv->_delim;
	result = _tmp0_;
	return result;
}

static void
geary_imap_mailbox_information_set_delim (GearyImapMailboxInformation* self,
                                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_IMAP_IS_MAILBOX_INFORMATION (self));
	old_value = geary_imap_mailbox_information_get_delim (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_delim);
		self->priv->_delim = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_mailbox_information_properties[GEARY_IMAP_MAILBOX_INFORMATION_DELIM_PROPERTY]);
	}
}

GearyImapMailboxAttributes*
geary_imap_mailbox_information_get_attrs (GearyImapMailboxInformation* self)
{
	GearyImapMailboxAttributes* result;
	GearyImapMailboxAttributes* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_MAILBOX_INFORMATION (self), NULL);
	_tmp0_ = self->priv->_attrs;
	result = _tmp0_;
	return result;
}

static void
geary_imap_mailbox_information_set_attrs (GearyImapMailboxInformation* self,
                                          GearyImapMailboxAttributes* value)
{
	GearyImapMailboxAttributes* old_value;
	g_return_if_fail (GEARY_IMAP_IS_MAILBOX_INFORMATION (self));
	old_value = geary_imap_mailbox_information_get_attrs (self);
	if (old_value != value) {
		GearyImapMailboxAttributes* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_attrs);
		self->priv->_attrs = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_mailbox_information_properties[GEARY_IMAP_MAILBOX_INFORMATION_ATTRS_PROPERTY]);
	}
}

GearyImapMailboxInformation*
geary_imap_mailbox_information_construct (GType object_type,
                                          GearyImapMailboxSpecifier* mailbox,
                                          const gchar* delim,
                                          GearyImapMailboxAttributes* attrs)
{
	GearyImapMailboxInformation * self = NULL;
	g_return_val_if_fail (GEARY_IMAP_IS_MAILBOX_SPECIFIER (mailbox), NULL);
	g_return_val_if_fail (GEARY_IMAP_IS_MAILBOX_ATTRIBUTES (attrs), NULL);
	self = (GearyImapMailboxInformation*) geary_base_object_construct (object_type);
	geary_imap_mailbox_information_set_mailbox (self, mailbox);
	geary_imap_mailbox_information_set_delim (self, delim);
	geary_imap_mailbox_information_set_attrs (self, attrs);
	return self;
}

GearyImapMailboxInformation*
geary_imap_mailbox_information_new (GearyImapMailboxSpecifier* mailbox,
                                    const gchar* delim,
                                    GearyImapMailboxAttributes* attrs)
{
	return geary_imap_mailbox_information_construct (GEARY_IMAP_TYPE_MAILBOX_INFORMATION, mailbox, delim, attrs);
}

/**
     * Decodes {@link ServerData} into a MailboxInformation representation.
     *
     * If canonical_inbox is true, the {@link MailboxAttributes} are searched for the \Inbox flag.
     * If found, {@link MailboxSpecifier.CANONICAL_INBOX_NAME} is used rather than the one returned
     * by the server.
     *
     * The ServerData must be the response to a LIST or XLIST command.
     *
     * @see ListCommand
     * @see ServerData.get_list
     */
GearyImapMailboxInformation*
geary_imap_mailbox_information_decode (GearyImapServerData* server_data,
                                       gboolean canonical_inbox,
                                       GError** error)
{
	GearyImapStringParameter* cmd = NULL;
	GearyImapStringParameter* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GearyImapStringParameter* _tmp2_;
	GearyImapListParameter* attrs = NULL;
	GearyImapListParameter* _tmp8_;
	GeeCollection* attrlist = NULL;
	GeeArrayList* _tmp9_;
	GearyImapMailboxAttributes* attributes = NULL;
	GeeCollection* _tmp30_;
	GearyImapMailboxAttributes* _tmp31_;
	GearyImapStringParameter* delim = NULL;
	GearyImapStringParameter* _tmp32_;
	GearyImapStringParameter* mailbox = NULL;
	GearyImapStringParameter* _tmp33_;
	GearyImapMailboxSpecifier* _tmp34_ = NULL;
	gboolean _tmp35_ = FALSE;
	GearyImapMailboxSpecifier* specifier = NULL;
	GearyImapMailboxSpecifier* _tmp44_;
	const gchar* _tmp45_ = NULL;
	GearyImapStringParameter* _tmp46_;
	GearyImapMailboxSpecifier* _tmp50_;
	GearyImapMailboxAttributes* _tmp51_;
	GearyImapMailboxInformation* _tmp52_;
	GError* _inner_error0_ = NULL;
	GearyImapMailboxInformation* result;
	g_return_val_if_fail (GEARY_IMAP_IS_SERVER_DATA (server_data), NULL);
	_tmp0_ = geary_imap_list_parameter_get_as_string (G_TYPE_CHECK_INSTANCE_CAST (server_data, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter), 1, &_inner_error0_);
	cmd = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = cmd;
	if (!geary_imap_string_parameter_equals_ci (_tmp2_, GEARY_IMAP_LIST_COMMAND_NAME)) {
		GearyImapStringParameter* _tmp3_;
		_tmp3_ = cmd;
		_tmp1_ = !geary_imap_string_parameter_equals_ci (_tmp3_, GEARY_IMAP_LIST_COMMAND_XLIST_NAME);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar* _tmp4_;
		gchar* _tmp5_;
		GError* _tmp6_;
		GError* _tmp7_;
		_tmp4_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (server_data, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_tmp5_ = _tmp4_;
		_tmp6_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_PARSE_ERROR, "Not LIST or XLIST data: %s", _tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		_inner_error0_ = _tmp7_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (cmd);
			return NULL;
		} else {
			_g_object_unref0 (cmd);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp8_ = geary_imap_list_parameter_get_as_list (G_TYPE_CHECK_INSTANCE_CAST (server_data, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter), 2, &_inner_error0_);
	attrs = _tmp8_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (cmd);
			return NULL;
		} else {
			_g_object_unref0 (cmd);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp9_ = gee_array_list_new (GEARY_IMAP_TYPE_MAILBOX_ATTRIBUTE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	attrlist = G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_COLLECTION, GeeCollection);
	{
		GeeList* _attr_list = NULL;
		GearyImapListParameter* _tmp10_;
		GeeList* _tmp11_;
		gint _attr_size = 0;
		GeeList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _attr_index = 0;
		_tmp10_ = attrs;
		_tmp11_ = geary_imap_list_parameter_get_all (_tmp10_);
		_attr_list = _tmp11_;
		_tmp12_ = _attr_list;
		_tmp13_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp14_ = _tmp13_;
		_attr_size = _tmp14_;
		_attr_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			GearyImapParameter* attr = NULL;
			GeeList* _tmp17_;
			gpointer _tmp18_;
			GearyImapStringParameter* stringp = NULL;
			GearyImapParameter* _tmp19_;
			GearyImapStringParameter* _tmp20_;
			GearyImapStringParameter* _tmp21_;
			GeeCollection* _tmp24_;
			GearyImapStringParameter* _tmp25_;
			const gchar* _tmp26_;
			const gchar* _tmp27_;
			GearyImapMailboxAttribute* _tmp28_;
			GearyImapMailboxAttribute* _tmp29_;
			_attr_index = _attr_index + 1;
			_tmp15_ = _attr_index;
			_tmp16_ = _attr_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _attr_list;
			_tmp18_ = gee_list_get (_tmp17_, _attr_index);
			attr = (GearyImapParameter*) _tmp18_;
			_tmp19_ = attr;
			_tmp20_ = _g_object_ref0 (GEARY_IMAP_IS_STRING_PARAMETER (_tmp19_) ? ((GearyImapStringParameter*) _tmp19_) : NULL);
			stringp = _tmp20_;
			_tmp21_ = stringp;
			if (_tmp21_ == NULL) {
				gchar* _tmp22_;
				gchar* _tmp23_;
				_tmp22_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (server_data, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
				_tmp23_ = _tmp22_;
				g_debug ("imap-mailbox-information.vala:62: Bad list attribute \"%s\": Attribute" \
" not a string value", _tmp23_);
				_g_free0 (_tmp23_);
				_g_object_unref0 (stringp);
				_g_object_unref0 (attr);
				continue;
			}
			_tmp24_ = attrlist;
			_tmp25_ = stringp;
			_tmp26_ = geary_imap_string_parameter_get_ascii (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = geary_imap_mailbox_attribute_new (_tmp27_);
			_tmp29_ = _tmp28_;
			gee_collection_add (_tmp24_, _tmp29_);
			_g_object_unref0 (_tmp29_);
			_g_object_unref0 (stringp);
			_g_object_unref0 (attr);
		}
		_g_object_unref0 (_attr_list);
	}
	_tmp30_ = attrlist;
	_tmp31_ = geary_imap_mailbox_attributes_new (_tmp30_);
	attributes = _tmp31_;
	_tmp32_ = geary_imap_list_parameter_get_as_nullable_string (G_TYPE_CHECK_INSTANCE_CAST (server_data, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter), 3, &_inner_error0_);
	delim = _tmp32_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (attributes);
			_g_object_unref0 (attrlist);
			_g_object_unref0 (attrs);
			_g_object_unref0 (cmd);
			return NULL;
		} else {
			_g_object_unref0 (attributes);
			_g_object_unref0 (attrlist);
			_g_object_unref0 (attrs);
			_g_object_unref0 (cmd);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp33_ = geary_imap_list_parameter_get_as_string (G_TYPE_CHECK_INSTANCE_CAST (server_data, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter), 4, &_inner_error0_);
	mailbox = _tmp33_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (delim);
			_g_object_unref0 (attributes);
			_g_object_unref0 (attrlist);
			_g_object_unref0 (attrs);
			_g_object_unref0 (cmd);
			return NULL;
		} else {
			_g_object_unref0 (delim);
			_g_object_unref0 (attributes);
			_g_object_unref0 (attrlist);
			_g_object_unref0 (attrs);
			_g_object_unref0 (cmd);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (canonical_inbox) {
		GearyImapMailboxAttributes* _tmp36_;
		GearyImapMailboxAttribute* _tmp37_;
		GearyImapMailboxAttribute* _tmp38_;
		_tmp36_ = attributes;
		_tmp37_ = geary_imap_mailbox_attribute_get_XLIST_INBOX ();
		_tmp38_ = _tmp37_;
		_tmp35_ = geary_imap_flags_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, GEARY_IMAP_TYPE_FLAGS, GearyImapFlags), G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, GEARY_IMAP_TYPE_FLAG, GearyImapFlag));
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		GearyImapMailboxSpecifier* _tmp39_;
		GearyImapMailboxSpecifier* _tmp40_;
		GearyImapMailboxSpecifier* _tmp41_;
		_tmp39_ = geary_imap_mailbox_specifier_get_inbox ();
		_tmp40_ = _tmp39_;
		_tmp41_ = _g_object_ref0 (_tmp40_);
		_g_object_unref0 (_tmp34_);
		_tmp34_ = _tmp41_;
	} else {
		GearyImapStringParameter* _tmp42_;
		GearyImapMailboxSpecifier* _tmp43_;
		_tmp42_ = mailbox;
		_tmp43_ = geary_imap_mailbox_specifier_new_from_parameter (_tmp42_);
		_g_object_unref0 (_tmp34_);
		_tmp34_ = _tmp43_;
	}
	_tmp44_ = _g_object_ref0 (_tmp34_);
	specifier = _tmp44_;
	_tmp46_ = delim;
	if (_tmp46_ != NULL) {
		GearyImapStringParameter* _tmp47_;
		const gchar* _tmp48_;
		const gchar* _tmp49_;
		_tmp47_ = delim;
		_tmp48_ = geary_imap_string_parameter_get_nullable_ascii (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp45_ = _tmp49_;
	} else {
		_tmp45_ = NULL;
	}
	_tmp50_ = specifier;
	_tmp51_ = attributes;
	_tmp52_ = geary_imap_mailbox_information_new (_tmp50_, _tmp45_, _tmp51_);
	result = _tmp52_;
	_g_object_unref0 (specifier);
	_g_object_unref0 (_tmp34_);
	_g_object_unref0 (mailbox);
	_g_object_unref0 (delim);
	_g_object_unref0 (attributes);
	_g_object_unref0 (attrlist);
	_g_object_unref0 (attrs);
	_g_object_unref0 (cmd);
	return result;
}

gchar*
geary_imap_mailbox_information_to_string (GearyImapMailboxInformation* self)
{
	GearyImapMailboxSpecifier* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GearyImapMailboxAttributes* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (GEARY_IMAP_IS_MAILBOX_INFORMATION (self), NULL);
	_tmp0_ = self->priv->_mailbox;
	_tmp1_ = geary_imap_mailbox_specifier_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_attrs;
	_tmp4_ = geary_message_data_abstract_message_data_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, GearyMessageDataAbstractMessageData));
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("%s/%s", _tmp2_, _tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
	result = _tmp7_;
	return result;
}

static void
geary_imap_mailbox_information_class_init (GearyImapMailboxInformationClass * klass,
                                           gpointer klass_data)
{
	geary_imap_mailbox_information_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapMailboxInformation_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_imap_mailbox_information_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_imap_mailbox_information_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_mailbox_information_finalize;
	/**
	     * Name of the mailbox.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_MAILBOX_INFORMATION_MAILBOX_PROPERTY, geary_imap_mailbox_information_properties[GEARY_IMAP_MAILBOX_INFORMATION_MAILBOX_PROPERTY] = g_param_spec_object ("mailbox", "mailbox", "mailbox", GEARY_IMAP_TYPE_MAILBOX_SPECIFIER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The (optional) delimiter specified by the server.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_MAILBOX_INFORMATION_DELIM_PROPERTY, geary_imap_mailbox_information_properties[GEARY_IMAP_MAILBOX_INFORMATION_DELIM_PROPERTY] = g_param_spec_string ("delim", "delim", "delim", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Folder attributes returned by the server.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_MAILBOX_INFORMATION_ATTRS_PROPERTY, geary_imap_mailbox_information_properties[GEARY_IMAP_MAILBOX_INFORMATION_ATTRS_PROPERTY] = g_param_spec_object ("attrs", "attrs", "attrs", GEARY_IMAP_TYPE_MAILBOX_ATTRIBUTES, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_imap_mailbox_information_instance_init (GearyImapMailboxInformation * self,
                                              gpointer klass)
{
	self->priv = geary_imap_mailbox_information_get_instance_private (self);
}

static void
geary_imap_mailbox_information_finalize (GObject * obj)
{
	GearyImapMailboxInformation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_TYPE_MAILBOX_INFORMATION, GearyImapMailboxInformation);
	_g_object_unref0 (self->priv->_mailbox);
	_g_free0 (self->priv->_delim);
	_g_object_unref0 (self->priv->_attrs);
	G_OBJECT_CLASS (geary_imap_mailbox_information_parent_class)->finalize (obj);
}

/**
 * The decoded response to a LIST command.
 *
 * This is also the response to an XLIST command.
 *
 * See [[http://tools.ietf.org/html/rfc3501#section-7.2.2]]
 *
 * @see ListCommand
 */
 G_GNUC_NO_INLINE static GType
geary_imap_mailbox_information_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapMailboxInformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_mailbox_information_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapMailboxInformation), 0, (GInstanceInitFunc) geary_imap_mailbox_information_instance_init, NULL };
	GType geary_imap_mailbox_information_type_id;
	geary_imap_mailbox_information_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyImapMailboxInformation", &g_define_type_info, 0);
	GearyImapMailboxInformation_private_offset = g_type_add_instance_private (geary_imap_mailbox_information_type_id, sizeof (GearyImapMailboxInformationPrivate));
	return geary_imap_mailbox_information_type_id;
}

GType
geary_imap_mailbox_information_get_type (void)
{
	static gsize geary_imap_mailbox_information_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_mailbox_information_type_id__once)) {
		GType geary_imap_mailbox_information_type_id;
		geary_imap_mailbox_information_type_id = geary_imap_mailbox_information_get_type_once ();
		g_once_init_leave (&geary_imap_mailbox_information_type_id__once, geary_imap_mailbox_information_type_id);
	}
	return geary_imap_mailbox_information_type_id__once;
}

static void
_vala_geary_imap_mailbox_information_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec)
{
	GearyImapMailboxInformation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_MAILBOX_INFORMATION, GearyImapMailboxInformation);
	switch (property_id) {
		case GEARY_IMAP_MAILBOX_INFORMATION_MAILBOX_PROPERTY:
		g_value_set_object (value, geary_imap_mailbox_information_get_mailbox (self));
		break;
		case GEARY_IMAP_MAILBOX_INFORMATION_DELIM_PROPERTY:
		g_value_set_string (value, geary_imap_mailbox_information_get_delim (self));
		break;
		case GEARY_IMAP_MAILBOX_INFORMATION_ATTRS_PROPERTY:
		g_value_set_object (value, geary_imap_mailbox_information_get_attrs (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_imap_mailbox_information_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec)
{
	GearyImapMailboxInformation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_MAILBOX_INFORMATION, GearyImapMailboxInformation);
	switch (property_id) {
		case GEARY_IMAP_MAILBOX_INFORMATION_MAILBOX_PROPERTY:
		geary_imap_mailbox_information_set_mailbox (self, g_value_get_object (value));
		break;
		case GEARY_IMAP_MAILBOX_INFORMATION_DELIM_PROPERTY:
		geary_imap_mailbox_information_set_delim (self, g_value_get_string (value));
		break;
		case GEARY_IMAP_MAILBOX_INFORMATION_ATTRS_PROPERTY:
		geary_imap_mailbox_information_set_attrs (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

