/* memory-string-buffer.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from memory-string-buffer.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GEARY_MEMORY_STRING_BUFFER_0_PROPERTY,
	GEARY_MEMORY_STRING_BUFFER_SIZE_PROPERTY,
	GEARY_MEMORY_STRING_BUFFER_ALLOCATED_SIZE_PROPERTY,
	GEARY_MEMORY_STRING_BUFFER_NUM_PROPERTIES
};
static GParamSpec* geary_memory_string_buffer_properties[GEARY_MEMORY_STRING_BUFFER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))

struct _GearyMemoryStringBufferPrivate {
	gchar* str;
	gsize length;
	GBytes* bytes;
};

static gint GearyMemoryStringBuffer_private_offset;
static gpointer geary_memory_string_buffer_parent_class = NULL;
static GearyMemoryUnownedStringBufferIface * geary_memory_string_buffer_geary_memory_unowned_string_buffer_parent_iface = NULL;
static GearyMemoryUnownedBytesBufferIface * geary_memory_string_buffer_geary_memory_unowned_bytes_buffer_parent_iface = NULL;

static GBytes* geary_memory_string_buffer_real_get_bytes (GearyMemoryBuffer* base);
static gchar* geary_memory_string_buffer_real_to_string (GearyMemoryBuffer* base);
static gchar* geary_memory_string_buffer_real_get_valid_utf8 (GearyMemoryBuffer* base);
static const gchar* geary_memory_string_buffer_real_to_unowned_string (GearyMemoryUnownedStringBuffer* base);
static guint8* geary_memory_string_buffer_real_to_unowned_uint8_array (GearyMemoryUnownedBytesBuffer* base,
                                                                gint* result_length1);
static void geary_memory_string_buffer_finalize (GObject * obj);
static GType geary_memory_string_buffer_get_type_once (void);
static void _vala_geary_memory_string_buffer_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);

static inline gpointer
geary_memory_string_buffer_get_instance_private (GearyMemoryStringBuffer* self)
{
	return G_STRUCT_MEMBER_P (self, GearyMemoryStringBuffer_private_offset);
}

static gsize
geary_memory_string_buffer_real_get_size (GearyMemoryBuffer* base)
{
	gsize result;
	GearyMemoryStringBuffer* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_MEMORY_TYPE_STRING_BUFFER, GearyMemoryStringBuffer);
	result = self->priv->length;
	return result;
}

static gsize
geary_memory_string_buffer_real_get_allocated_size (GearyMemoryBuffer* base)
{
	gsize result;
	GearyMemoryStringBuffer* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_MEMORY_TYPE_STRING_BUFFER, GearyMemoryStringBuffer);
	result = self->priv->length;
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

GearyMemoryStringBuffer*
geary_memory_string_buffer_construct (GType object_type,
                                      const gchar* str)
{
	GearyMemoryStringBuffer * self = NULL;
	gchar* _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_ = 0;
	guint8* _tmp3_;
	gint _tmp3__length1;
	g_return_val_if_fail (str != NULL, NULL);
	self = (GearyMemoryStringBuffer*) geary_memory_buffer_construct (object_type);
	_tmp0_ = g_strdup (str);
	_g_free0 (self->priv->str);
	self->priv->str = _tmp0_;
	_tmp1_ = string_get_data (str, &_tmp2_);
	_tmp1__length1 = _tmp2_;
	_tmp3_ = _tmp1_;
	_tmp3__length1 = _tmp1__length1;
	self->priv->length = (gsize) _tmp3__length1;
	return self;
}

GearyMemoryStringBuffer*
geary_memory_string_buffer_new (const gchar* str)
{
	return geary_memory_string_buffer_construct (GEARY_MEMORY_TYPE_STRING_BUFFER, str);
}

/**
     * {@inheritDoc}
     */
static gpointer
_g_bytes_ref0 (gpointer self)
{
	return self ? g_bytes_ref (self) : NULL;
}

static GBytes*
geary_memory_string_buffer_real_get_bytes (GearyMemoryBuffer* base)
{
	GearyMemoryStringBuffer * self;
	GBytes* _tmp0_ = NULL;
	GBytes* _tmp1_;
	GBytes* _tmp9_;
	GBytes* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_MEMORY_TYPE_STRING_BUFFER, GearyMemoryStringBuffer);
	_tmp1_ = self->priv->bytes;
	if (_tmp1_ != NULL) {
		GBytes* _tmp2_;
		_tmp2_ = self->priv->bytes;
		_tmp0_ = _tmp2_;
	} else {
		const gchar* _tmp3_;
		guint8* _tmp4_;
		gint _tmp4__length1;
		gint _tmp5_ = 0;
		guint8* _tmp6_;
		gint _tmp6__length1;
		GBytes* _tmp7_;
		GBytes* _tmp8_;
		_tmp3_ = self->priv->str;
		_tmp4_ = string_get_data (_tmp3_, &_tmp5_);
		_tmp4__length1 = _tmp5_;
		_tmp6_ = _tmp4_;
		_tmp6__length1 = _tmp4__length1;
		_tmp7_ = g_bytes_new (_tmp6_, _tmp6__length1);
		_g_bytes_unref0 (self->priv->bytes);
		self->priv->bytes = _tmp7_;
		_tmp8_ = self->priv->bytes;
		_tmp0_ = _tmp8_;
	}
	_tmp9_ = _g_bytes_ref0 (_tmp0_);
	result = _tmp9_;
	return result;
}

/**
     * {@inheritDoc}
     */
static gchar*
geary_memory_string_buffer_real_to_string (GearyMemoryBuffer* base)
{
	GearyMemoryStringBuffer * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_MEMORY_TYPE_STRING_BUFFER, GearyMemoryStringBuffer);
	_tmp0_ = self->priv->str;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
     * {@inheritDoc}
     */
static gchar*
geary_memory_string_buffer_real_get_valid_utf8 (GearyMemoryBuffer* base)
{
	GearyMemoryStringBuffer * self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* _tmp3_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_MEMORY_TYPE_STRING_BUFFER, GearyMemoryStringBuffer);
	_tmp1_ = self->priv->str;
	if (g_utf8_validate (_tmp1_, (gssize) -1, NULL)) {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->str;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = g_strdup (_tmp0_);
	result = _tmp3_;
	return result;
}

/**
     * {@inheritDoc}
     */
static const gchar*
geary_memory_string_buffer_real_to_unowned_string (GearyMemoryUnownedStringBuffer* base)
{
	GearyMemoryStringBuffer * self;
	const gchar* _tmp0_;
	const gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_MEMORY_TYPE_STRING_BUFFER, GearyMemoryStringBuffer);
	_tmp0_ = self->priv->str;
	result = _tmp0_;
	return result;
}

/**
     * {@inheritDoc}
     */
static guint8*
geary_memory_string_buffer_real_to_unowned_uint8_array (GearyMemoryUnownedBytesBuffer* base,
                                                        gint* result_length1)
{
	GearyMemoryStringBuffer * self;
	const gchar* _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_ = 0;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	guint8* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_MEMORY_TYPE_STRING_BUFFER, GearyMemoryStringBuffer);
	_tmp0_ = self->priv->str;
	_tmp1_ = string_get_data (_tmp0_, &_tmp2_);
	_tmp1__length1 = _tmp2_;
	_tmp3_ = _tmp1_;
	_tmp3__length1 = _tmp1__length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}

static void
geary_memory_string_buffer_class_init (GearyMemoryStringBufferClass * klass,
                                       gpointer klass_data)
{
	geary_memory_string_buffer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyMemoryStringBuffer_private_offset);
	((GearyMemoryBufferClass *) klass)->get_bytes = (GBytes* (*) (GearyMemoryBuffer*)) geary_memory_string_buffer_real_get_bytes;
	((GearyMemoryBufferClass *) klass)->to_string = (gchar* (*) (GearyMemoryBuffer*)) geary_memory_string_buffer_real_to_string;
	((GearyMemoryBufferClass *) klass)->get_valid_utf8 = (gchar* (*) (GearyMemoryBuffer*)) geary_memory_string_buffer_real_get_valid_utf8;
	GEARY_MEMORY_BUFFER_CLASS (klass)->get_size = (gsize (*) (GearyMemoryBuffer*)) geary_memory_string_buffer_real_get_size;
	GEARY_MEMORY_BUFFER_CLASS (klass)->get_allocated_size = (gsize (*) (GearyMemoryBuffer*)) geary_memory_string_buffer_real_get_allocated_size;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_memory_string_buffer_get_property;
	G_OBJECT_CLASS (klass)->finalize = geary_memory_string_buffer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_MEMORY_STRING_BUFFER_SIZE_PROPERTY, geary_memory_string_buffer_properties[GEARY_MEMORY_STRING_BUFFER_SIZE_PROPERTY] = g_param_spec_ulong ("size", "size", "size", 0, G_MAXULONG, 0UL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_MEMORY_STRING_BUFFER_ALLOCATED_SIZE_PROPERTY, geary_memory_string_buffer_properties[GEARY_MEMORY_STRING_BUFFER_ALLOCATED_SIZE_PROPERTY] = g_param_spec_ulong ("allocated-size", "allocated-size", "allocated-size", 0, G_MAXULONG, 0UL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_memory_string_buffer_geary_memory_unowned_string_buffer_interface_init (GearyMemoryUnownedStringBufferIface * iface,
                                                                              gpointer iface_data)
{
	geary_memory_string_buffer_geary_memory_unowned_string_buffer_parent_iface = g_type_interface_peek_parent (iface);
	iface->to_unowned_string = (const gchar* (*) (GearyMemoryUnownedStringBuffer*)) geary_memory_string_buffer_real_to_unowned_string;
}

static void
geary_memory_string_buffer_geary_memory_unowned_bytes_buffer_interface_init (GearyMemoryUnownedBytesBufferIface * iface,
                                                                             gpointer iface_data)
{
	geary_memory_string_buffer_geary_memory_unowned_bytes_buffer_parent_iface = g_type_interface_peek_parent (iface);
	iface->to_unowned_uint8_array = (guint8* (*) (GearyMemoryUnownedBytesBuffer*, gint*)) geary_memory_string_buffer_real_to_unowned_uint8_array;
}

static void
geary_memory_string_buffer_instance_init (GearyMemoryStringBuffer * self,
                                          gpointer klass)
{
	self->priv = geary_memory_string_buffer_get_instance_private (self);
	self->priv->bytes = NULL;
}

static void
geary_memory_string_buffer_finalize (GObject * obj)
{
	GearyMemoryStringBuffer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_MEMORY_TYPE_STRING_BUFFER, GearyMemoryStringBuffer);
	_g_free0 (self->priv->str);
	_g_bytes_unref0 (self->priv->bytes);
	G_OBJECT_CLASS (geary_memory_string_buffer_parent_class)->finalize (obj);
}

/**
 * Allows for a common string to be represented as an {@link Memory.Buffer}.
 */
 G_GNUC_NO_INLINE static GType
geary_memory_string_buffer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyMemoryStringBufferClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_memory_string_buffer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyMemoryStringBuffer), 0, (GInstanceInitFunc) geary_memory_string_buffer_instance_init, NULL };
	static const GInterfaceInfo geary_memory_unowned_string_buffer_info = { (GInterfaceInitFunc) geary_memory_string_buffer_geary_memory_unowned_string_buffer_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo geary_memory_unowned_bytes_buffer_info = { (GInterfaceInitFunc) geary_memory_string_buffer_geary_memory_unowned_bytes_buffer_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_memory_string_buffer_type_id;
	geary_memory_string_buffer_type_id = g_type_register_static (GEARY_MEMORY_TYPE_BUFFER, "GearyMemoryStringBuffer", &g_define_type_info, 0);
	g_type_add_interface_static (geary_memory_string_buffer_type_id, GEARY_MEMORY_TYPE_UNOWNED_STRING_BUFFER, &geary_memory_unowned_string_buffer_info);
	g_type_add_interface_static (geary_memory_string_buffer_type_id, GEARY_MEMORY_TYPE_UNOWNED_BYTES_BUFFER, &geary_memory_unowned_bytes_buffer_info);
	GearyMemoryStringBuffer_private_offset = g_type_add_instance_private (geary_memory_string_buffer_type_id, sizeof (GearyMemoryStringBufferPrivate));
	return geary_memory_string_buffer_type_id;
}

GType
geary_memory_string_buffer_get_type (void)
{
	static gsize geary_memory_string_buffer_type_id__once = 0;
	if (g_once_init_enter (&geary_memory_string_buffer_type_id__once)) {
		GType geary_memory_string_buffer_type_id;
		geary_memory_string_buffer_type_id = geary_memory_string_buffer_get_type_once ();
		g_once_init_leave (&geary_memory_string_buffer_type_id__once, geary_memory_string_buffer_type_id);
	}
	return geary_memory_string_buffer_type_id__once;
}

static void
_vala_geary_memory_string_buffer_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	GearyMemoryStringBuffer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_MEMORY_TYPE_STRING_BUFFER, GearyMemoryStringBuffer);
	switch (property_id) {
		case GEARY_MEMORY_STRING_BUFFER_SIZE_PROPERTY:
		g_value_set_ulong (value, geary_memory_buffer_get_size (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer)));
		break;
		case GEARY_MEMORY_STRING_BUFFER_ALLOCATED_SIZE_PROPERTY:
		g_value_set_ulong (value, geary_memory_buffer_get_allocated_size (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

