/* gitg-diff-stat.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-diff-stat.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2013 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include "libgitg.h"
#include <glib.h>
#include <pango/pango.h>
#include <gtk/gtk.h>
#include <cairo-gobject.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GITG_DIFF_STAT_0_PROPERTY,
	GITG_DIFF_STAT_ADDED_PROPERTY,
	GITG_DIFF_STAT_REMOVED_PROPERTY,
	GITG_DIFF_STAT_NUM_PROPERTIES
};
static GParamSpec* gitg_diff_stat_properties[GITG_DIFF_STAT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_param_spec_unref0(var) ((var == NULL) ? NULL : (var = (g_param_spec_unref (var), NULL)))

struct _GitgDiffStatPrivate {
	guint d_added;
	guint d_removed;
	PangoLayout* d_layout;
};

static gint GitgDiffStat_private_offset;
static gpointer gitg_diff_stat_parent_class = NULL;

static void gitg_diff_stat_make_layout (GitgDiffStat* self);
static void gitg_diff_stat_real_style_updated (GtkWidget* base);
static gboolean gitg_diff_stat_real_draw (GtkWidget* base,
                                   cairo_t* context);
static void gitg_diff_stat_real_get_preferred_height (GtkWidget* base,
                                               gint* minimum_height,
                                               gint* natural_height);
static void gitg_diff_stat_real_get_preferred_width (GtkWidget* base,
                                              gint* minimum_width,
                                              gint* natural_width);
static GObject * gitg_diff_stat_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties);
static void gitg_diff_stat_finalize (GObject * obj);
static GType gitg_diff_stat_get_type_once (void);
static void _vala_gitg_diff_stat_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_gitg_diff_stat_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);

static inline gpointer
gitg_diff_stat_get_instance_private (GitgDiffStat* self)
{
	return G_STRUCT_MEMBER_P (self, GitgDiffStat_private_offset);
}

static void
gitg_diff_stat_make_layout (GitgDiffStat* self)
{
	gchar* txt = NULL;
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	gchar* _tmp4_;
	PangoLayout* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gitg_diff_stat_get_added (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gitg_diff_stat_get_removed (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%u", _tmp1_ + _tmp3_);
	txt = _tmp4_;
	_tmp5_ = self->priv->d_layout;
	if (_tmp5_ == NULL) {
		const gchar* _tmp6_;
		PangoLayout* _tmp7_;
		_tmp6_ = txt;
		_tmp7_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp6_);
		_g_object_unref0 (self->priv->d_layout);
		self->priv->d_layout = _tmp7_;
	} else {
		PangoLayout* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		_tmp8_ = self->priv->d_layout;
		_tmp9_ = txt;
		_tmp10_ = txt;
		_tmp11_ = strlen (_tmp10_);
		_tmp12_ = _tmp11_;
		pango_layout_set_text (_tmp8_, _tmp9_, _tmp12_);
	}
	gtk_widget_queue_resize ((GtkWidget*) self);
	_g_free0 (txt);
}

static void
gitg_diff_stat_real_style_updated (GtkWidget* base)
{
	GitgDiffStat * self;
	gboolean dark = FALSE;
	GitgTheme* _tmp0_;
	GitgTheme* _tmp1_;
	gboolean _tmp2_;
	self = (GitgDiffStat*) base;
	GTK_WIDGET_CLASS (gitg_diff_stat_parent_class)->style_updated ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea));
	_g_object_unref0 (self->priv->d_layout);
	self->priv->d_layout = NULL;
	_tmp0_ = gitg_theme_new ();
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	_tmp2_ = gitg_theme_is_theme_dark (_tmp1_);
	_g_object_unref0 (_tmp1_);
	dark = _tmp2_;
	if (dark) {
		GtkStyleContext* _tmp3_;
		_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_add_class (_tmp3_, "dark");
	} else {
		GtkStyleContext* _tmp4_;
		_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_remove_class (_tmp4_, "dark");
	}
	gitg_diff_stat_make_layout (self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
gitg_diff_stat_real_draw (GtkWidget* base,
                          cairo_t* context)
{
	GitgDiffStat * self;
	GtkStyleContext* sctx = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkBorder padding = {0};
	GtkStyleContext* _tmp2_;
	GtkBorder _tmp3_ = {0};
	GtkBorder border = {0};
	GtkStyleContext* _tmp4_;
	GtkBorder _tmp5_ = {0};
	gint h = 0;
	gint w = 0;
	GtkStyleContext* _tmp6_;
	GtkStyleContext* _tmp7_;
	PangoRectangle rect = {0};
	PangoLayout* _tmp8_;
	PangoRectangle _tmp9_ = {0};
	gboolean rtl = FALSE;
	GtkStyleContext* _tmp10_;
	gint x = 0;
	GtkStyleContext* _tmp17_;
	PangoRectangle _tmp18_;
	PangoRectangle _tmp19_;
	PangoLayout* _tmp20_;
	gint hbar = 0;
	GtkStyleContext* _tmp21_;
	gint _tmp22_ = 0;
	gint ybar = 0;
	gint wrest = 0;
	GtkBorder _tmp23_;
	PangoRectangle _tmp24_;
	PangoRectangle _tmp25_;
	GtkBorder _tmp26_;
	GtkBorder _tmp27_;
	GtkBorder _tmp28_;
	gdouble afrac = 0.0;
	guint total = 0U;
	guint _tmp29_;
	guint _tmp30_;
	guint _tmp31_;
	guint _tmp32_;
	gint wbar = 0;
	gboolean _tmp38_ = FALSE;
	guint _tmp39_;
	guint _tmp40_;
	gboolean result;
	self = (GitgDiffStat*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	sctx = _tmp1_;
	_tmp2_ = sctx;
	gtk_style_context_get_padding (_tmp2_, gtk_widget_get_state_flags ((GtkWidget*) self), &_tmp3_);
	padding = _tmp3_;
	_tmp4_ = sctx;
	gtk_style_context_get_border (_tmp4_, gtk_widget_get_state_flags ((GtkWidget*) self), &_tmp5_);
	border = _tmp5_;
	h = gtk_widget_get_allocated_height ((GtkWidget*) self);
	w = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp6_ = sctx;
	gtk_render_background (_tmp6_, context, (gdouble) 0, (gdouble) 0, (gdouble) w, (gdouble) h);
	_tmp7_ = sctx;
	gtk_render_frame (_tmp7_, context, (gdouble) 0, (gdouble) 0, (gdouble) w, (gdouble) h);
	_tmp8_ = self->priv->d_layout;
	pango_layout_get_extents (_tmp8_, NULL, &_tmp9_);
	rect = _tmp9_;
	_tmp10_ = sctx;
	rtl = (gtk_style_context_get_state (_tmp10_) & GTK_STATE_FLAG_DIR_RTL) != 0;
	if (!rtl) {
		GtkBorder _tmp11_;
		GtkBorder _tmp12_;
		PangoRectangle _tmp13_;
		_tmp11_ = padding;
		_tmp12_ = border;
		_tmp13_ = rect;
		x = (_tmp11_.left + _tmp12_.left) + (_tmp13_.x / PANGO_SCALE);
	} else {
		GtkBorder _tmp14_;
		GtkBorder _tmp15_;
		PangoRectangle _tmp16_;
		_tmp14_ = padding;
		_tmp15_ = border;
		_tmp16_ = rect;
		x = ((w - _tmp14_.right) - _tmp15_.right) - (_tmp16_.width / PANGO_SCALE);
	}
	_tmp17_ = sctx;
	_tmp18_ = rect;
	_tmp19_ = rect;
	_tmp20_ = self->priv->d_layout;
	gtk_render_layout (_tmp17_, context, (gdouble) x, (gdouble) (((h - (_tmp18_.height / PANGO_SCALE)) / 2) + (_tmp19_.y / PANGO_SCALE)), _tmp20_);
	_tmp21_ = sctx;
	gtk_style_context_get_style (_tmp21_, "bar-height", &_tmp22_, NULL);
	hbar = _tmp22_;
	ybar = (h - hbar) / 2;
	_tmp23_ = padding;
	_tmp24_ = rect;
	_tmp25_ = rect;
	_tmp26_ = padding;
	_tmp27_ = border;
	_tmp28_ = border;
	wrest = (gint) (((((w - (_tmp23_.left * 2)) - ((_tmp24_.x + _tmp25_.width) / PANGO_SCALE)) - _tmp26_.right) - _tmp27_.left) - _tmp28_.right);
	afrac = (gdouble) 0;
	_tmp29_ = gitg_diff_stat_get_added (self);
	_tmp30_ = _tmp29_;
	_tmp31_ = gitg_diff_stat_get_removed (self);
	_tmp32_ = _tmp31_;
	total = _tmp30_ + _tmp32_;
	if (total != ((guint) 0)) {
		guint _tmp33_;
		guint _tmp34_;
		_tmp33_ = gitg_diff_stat_get_added (self);
		_tmp34_ = _tmp33_;
		afrac = _tmp34_ / ((gdouble) total);
	}
	wbar = (gint) (wrest * afrac);
	if (!rtl) {
		GtkBorder _tmp35_;
		PangoRectangle _tmp36_;
		_tmp35_ = padding;
		_tmp36_ = rect;
		x += _tmp35_.left + (_tmp36_.width / PANGO_SCALE);
	} else {
		GtkBorder _tmp37_;
		_tmp37_ = padding;
		x -= _tmp37_.right + wbar;
	}
	_tmp39_ = gitg_diff_stat_get_added (self);
	_tmp40_ = _tmp39_;
	if (_tmp40_ == ((guint) 0)) {
		guint _tmp41_;
		guint _tmp42_;
		_tmp41_ = gitg_diff_stat_get_removed (self);
		_tmp42_ = _tmp41_;
		_tmp38_ = _tmp42_ == ((guint) 0);
	} else {
		_tmp38_ = FALSE;
	}
	if (_tmp38_) {
		GtkStyleContext* _tmp43_;
		GtkStyleContext* _tmp44_;
		GtkStyleContext* _tmp45_;
		_tmp43_ = sctx;
		gtk_style_context_save (_tmp43_);
		_tmp44_ = sctx;
		gtk_render_background (_tmp44_, context, (gdouble) x, (gdouble) ybar, (gdouble) wrest, (gdouble) hbar);
		_tmp45_ = sctx;
		gtk_style_context_restore (_tmp45_);
	} else {
		gboolean _tmp46_ = FALSE;
		guint _tmp47_;
		guint _tmp48_;
		_tmp47_ = gitg_diff_stat_get_added (self);
		_tmp48_ = _tmp47_;
		if (_tmp48_ == ((guint) 0)) {
			_tmp46_ = TRUE;
		} else {
			guint _tmp49_;
			guint _tmp50_;
			_tmp49_ = gitg_diff_stat_get_removed (self);
			_tmp50_ = _tmp49_;
			_tmp46_ = _tmp50_ == ((guint) 0);
		}
		if (_tmp46_) {
			GtkStyleContext* _tmp51_;
			const gchar* _tmp52_ = NULL;
			guint _tmp53_;
			guint _tmp54_;
			GtkStyleContext* _tmp55_;
			GtkStyleContext* _tmp56_;
			GtkStyleContext* _tmp57_;
			_tmp51_ = sctx;
			gtk_style_context_save (_tmp51_);
			_tmp53_ = gitg_diff_stat_get_added (self);
			_tmp54_ = _tmp53_;
			if (_tmp54_ == ((guint) 0)) {
				_tmp52_ = "removed-only";
			} else {
				_tmp52_ = "added-only";
			}
			_tmp55_ = sctx;
			gtk_style_context_add_class (_tmp55_, _tmp52_);
			_tmp56_ = sctx;
			gtk_render_background (_tmp56_, context, (gdouble) x, (gdouble) ybar, (gdouble) wrest, (gdouble) hbar);
			_tmp57_ = sctx;
			gtk_style_context_restore (_tmp57_);
		} else {
			GtkStyleContext* _tmp58_;
			GtkStyleContext* _tmp59_;
			GtkStyleContext* _tmp60_;
			GtkStyleContext* _tmp61_;
			GtkStyleContext* _tmp62_;
			GtkStyleContext* _tmp63_;
			gint _tmp64_ = 0;
			GtkStyleContext* _tmp65_;
			GtkStyleContext* _tmp66_;
			_tmp58_ = sctx;
			gtk_style_context_save (_tmp58_);
			_tmp59_ = sctx;
			gtk_style_context_add_class (_tmp59_, "added");
			_tmp60_ = sctx;
			gtk_render_background (_tmp60_, context, (gdouble) x, (gdouble) ybar, (gdouble) wbar, (gdouble) hbar);
			_tmp61_ = sctx;
			gtk_style_context_restore (_tmp61_);
			_tmp62_ = sctx;
			gtk_style_context_save (_tmp62_);
			_tmp63_ = sctx;
			gtk_style_context_add_class (_tmp63_, "removed");
			if (rtl) {
				_tmp64_ = wbar - wrest;
			} else {
				_tmp64_ = wbar;
			}
			x += _tmp64_;
			_tmp65_ = sctx;
			gtk_render_background (_tmp65_, context, (gdouble) x, (gdouble) ybar, (gdouble) (wrest - wbar), (gdouble) hbar);
			_tmp66_ = sctx;
			gtk_style_context_restore (_tmp66_);
		}
	}
	result = FALSE;
	_g_object_unref0 (sctx);
	return result;
}

static void
gitg_diff_stat_real_get_preferred_height (GtkWidget* base,
                                          gint* minimum_height,
                                          gint* natural_height)
{
	GitgDiffStat * self;
	gint _vala_minimum_height = 0;
	gint _vala_natural_height = 0;
	GtkStyleContext* sctx = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkBorder padding = {0};
	GtkBorder _tmp2_ = {0};
	GtkBorder border = {0};
	GtkBorder _tmp3_ = {0};
	PangoRectangle rect = {0};
	PangoLayout* _tmp4_;
	PangoRectangle _tmp5_ = {0};
	gint h = 0;
	GtkBorder _tmp6_;
	GtkBorder _tmp7_;
	GtkBorder _tmp8_;
	GtkBorder _tmp9_;
	gint hlbl = 0;
	PangoRectangle _tmp10_;
	PangoRectangle _tmp11_;
	gint bar_height = 0;
	gint _tmp12_ = 0;
	self = (GitgDiffStat*) base;
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	sctx = _tmp1_;
	gtk_style_context_get_padding (sctx, gtk_widget_get_state_flags ((GtkWidget*) self), &_tmp2_);
	padding = _tmp2_;
	gtk_style_context_get_border (sctx, gtk_widget_get_state_flags ((GtkWidget*) self), &_tmp3_);
	border = _tmp3_;
	_tmp4_ = self->priv->d_layout;
	pango_layout_get_extents (_tmp4_, NULL, &_tmp5_);
	rect = _tmp5_;
	_tmp6_ = padding;
	_tmp7_ = padding;
	_tmp8_ = border;
	_tmp9_ = border;
	h = (gint) (((_tmp6_.top + _tmp7_.bottom) + _tmp8_.top) + _tmp9_.bottom);
	_tmp10_ = rect;
	_tmp11_ = rect;
	hlbl = (_tmp10_.height + _tmp11_.y) / PANGO_SCALE;
	gtk_style_context_get_style (sctx, "bar-height", &_tmp12_, NULL);
	bar_height = _tmp12_;
	h += MAX (hlbl, bar_height);
	_vala_minimum_height = h;
	_vala_natural_height = h;
	_g_object_unref0 (sctx);
	if (minimum_height) {
		*minimum_height = _vala_minimum_height;
	}
	if (natural_height) {
		*natural_height = _vala_natural_height;
	}
}

static void
gitg_diff_stat_real_get_preferred_width (GtkWidget* base,
                                         gint* minimum_width,
                                         gint* natural_width)
{
	GitgDiffStat * self;
	gint _vala_minimum_width = 0;
	gint _vala_natural_width = 0;
	GtkStyleContext* sctx = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkBorder padding = {0};
	GtkBorder _tmp2_ = {0};
	GtkBorder border = {0};
	GtkBorder _tmp3_ = {0};
	PangoRectangle rect = {0};
	PangoLayout* _tmp4_;
	PangoRectangle _tmp5_ = {0};
	gint w = 0;
	GtkBorder _tmp6_;
	GtkBorder _tmp7_;
	GtkBorder _tmp8_;
	GtkBorder _tmp9_;
	PangoRectangle _tmp10_;
	PangoRectangle _tmp11_;
	self = (GitgDiffStat*) base;
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	sctx = _tmp1_;
	gtk_style_context_get_padding (sctx, gtk_widget_get_state_flags ((GtkWidget*) self), &_tmp2_);
	padding = _tmp2_;
	gtk_style_context_get_border (sctx, gtk_widget_get_state_flags ((GtkWidget*) self), &_tmp3_);
	border = _tmp3_;
	_tmp4_ = self->priv->d_layout;
	pango_layout_get_extents (_tmp4_, &_tmp5_, NULL);
	rect = _tmp5_;
	_tmp6_ = padding;
	_tmp7_ = padding;
	_tmp8_ = border;
	_tmp9_ = border;
	_tmp10_ = rect;
	_tmp11_ = rect;
	w = (((_tmp6_.left + _tmp7_.right) + _tmp8_.left) + _tmp9_.right) + ((_tmp10_.width + _tmp11_.x) / PANGO_SCALE);
	_vala_minimum_width = w;
	_vala_natural_width = 75;
	_g_object_unref0 (sctx);
	if (minimum_width) {
		*minimum_width = _vala_minimum_width;
	}
	if (natural_width) {
		*natural_width = _vala_natural_width;
	}
}

GitgDiffStat*
gitg_diff_stat_construct (GType object_type)
{
	GitgDiffStat * self = NULL;
	self = (GitgDiffStat*) g_object_new (object_type, NULL);
	return self;
}

GitgDiffStat*
gitg_diff_stat_new (void)
{
	return gitg_diff_stat_construct (GITG_TYPE_DIFF_STAT);
}

guint
gitg_diff_stat_get_added (GitgDiffStat* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->d_added;
	return result;
}

void
gitg_diff_stat_set_added (GitgDiffStat* self,
                          guint value)
{
	g_return_if_fail (self != NULL);
	self->priv->d_added = value;
	gitg_diff_stat_make_layout (self);
	g_object_notify_by_pspec ((GObject *) self, gitg_diff_stat_properties[GITG_DIFF_STAT_ADDED_PROPERTY]);
}

guint
gitg_diff_stat_get_removed (GitgDiffStat* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->d_removed;
	return result;
}

void
gitg_diff_stat_set_removed (GitgDiffStat* self,
                            guint value)
{
	g_return_if_fail (self != NULL);
	self->priv->d_removed = value;
	gitg_diff_stat_make_layout (self);
	g_object_notify_by_pspec ((GObject *) self, gitg_diff_stat_properties[GITG_DIFF_STAT_REMOVED_PROPERTY]);
}

static GObject *
gitg_diff_stat_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GitgDiffStat * self;
	parent_class = G_OBJECT_CLASS (gitg_diff_stat_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_DIFF_STAT, GitgDiffStat);
	gitg_diff_stat_make_layout (self);
	return obj;
}

static void
gitg_diff_stat_class_init (GitgDiffStatClass * klass,
                           gpointer klass_data)
{
	GParamSpecInt* _tmp0_;
	GParamSpecInt* _tmp1_;
	gitg_diff_stat_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgDiffStat_private_offset);
	((GtkWidgetClass *) klass)->style_updated = (void (*) (GtkWidget*)) gitg_diff_stat_real_style_updated;
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) gitg_diff_stat_real_draw;
	((GtkWidgetClass *) klass)->get_preferred_height = (void (*) (GtkWidget*, gint*, gint*)) gitg_diff_stat_real_get_preferred_height;
	((GtkWidgetClass *) klass)->get_preferred_width = (void (*) (GtkWidget*, gint*, gint*)) gitg_diff_stat_real_get_preferred_width;
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_diff_stat_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_diff_stat_set_property;
	G_OBJECT_CLASS (klass)->constructor = gitg_diff_stat_constructor;
	G_OBJECT_CLASS (klass)->finalize = gitg_diff_stat_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_STAT_ADDED_PROPERTY, gitg_diff_stat_properties[GITG_DIFF_STAT_ADDED_PROPERTY] = g_param_spec_uint ("added", "added", "added", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_STAT_REMOVED_PROPERTY, gitg_diff_stat_properties[GITG_DIFF_STAT_REMOVED_PROPERTY] = g_param_spec_uint ("removed", "removed", "removed", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = (GParamSpecInt*) g_param_spec_int ("bar-height", "bar height", "bar height", 0, G_MAXINT, 5, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS);
	_tmp1_ = _tmp0_;
	gtk_widget_class_install_style_property (GTK_WIDGET_CLASS (klass), (GParamSpec*) _tmp1_);
	_g_param_spec_unref0 (_tmp1_);
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "gitg-diffstat");
}

static void
gitg_diff_stat_instance_init (GitgDiffStat * self,
                              gpointer klass)
{
	self->priv = gitg_diff_stat_get_instance_private (self);
}

static void
gitg_diff_stat_finalize (GObject * obj)
{
	GitgDiffStat * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_DIFF_STAT, GitgDiffStat);
	_g_object_unref0 (self->priv->d_layout);
	G_OBJECT_CLASS (gitg_diff_stat_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_diff_stat_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgDiffStatClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_diff_stat_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgDiffStat), 0, (GInstanceInitFunc) gitg_diff_stat_instance_init, NULL };
	GType gitg_diff_stat_type_id;
	gitg_diff_stat_type_id = g_type_register_static (gtk_drawing_area_get_type (), "GitgDiffStat", &g_define_type_info, 0);
	GitgDiffStat_private_offset = g_type_add_instance_private (gitg_diff_stat_type_id, sizeof (GitgDiffStatPrivate));
	return gitg_diff_stat_type_id;
}

GType
gitg_diff_stat_get_type (void)
{
	static gsize gitg_diff_stat_type_id__once = 0;
	if (g_once_init_enter (&gitg_diff_stat_type_id__once)) {
		GType gitg_diff_stat_type_id;
		gitg_diff_stat_type_id = gitg_diff_stat_get_type_once ();
		g_once_init_leave (&gitg_diff_stat_type_id__once, gitg_diff_stat_type_id);
	}
	return gitg_diff_stat_type_id__once;
}

static void
_vala_gitg_diff_stat_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	GitgDiffStat * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_DIFF_STAT, GitgDiffStat);
	switch (property_id) {
		case GITG_DIFF_STAT_ADDED_PROPERTY:
		g_value_set_uint (value, gitg_diff_stat_get_added (self));
		break;
		case GITG_DIFF_STAT_REMOVED_PROPERTY:
		g_value_set_uint (value, gitg_diff_stat_get_removed (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_diff_stat_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	GitgDiffStat * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_DIFF_STAT, GitgDiffStat);
	switch (property_id) {
		case GITG_DIFF_STAT_ADDED_PROPERTY:
		gitg_diff_stat_set_added (self, g_value_get_uint (value));
		break;
		case GITG_DIFF_STAT_REMOVED_PROPERTY:
		gitg_diff_stat_set_removed (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

