/* app-window.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from app-window.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <handy.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include "config.h"
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include "common.h"
#include <atk/atk.h>

#define BOXES_APP_WINDOW_TRANSITION_DURATION ((guint) 400)
#define BOXES_APP_WINDOW_configure_id_timeout ((guint) 100)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BOXES_TYPE_UI (boxes_ui_get_type ())
#define BOXES_UI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_UI, BoxesUI))
#define BOXES_IS_UI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_UI))
#define BOXES_UI_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BOXES_TYPE_UI, BoxesUIIface))

typedef struct _BoxesUI BoxesUI;
typedef struct _BoxesUIIface BoxesUIIface;
typedef enum  {
	BOXES_UI_STATE_NONE,
	BOXES_UI_STATE_COLLECTION,
	BOXES_UI_STATE_CREDS,
	BOXES_UI_STATE_DISPLAY,
	BOXES_UI_STATE_WIZARD,
	BOXES_UI_STATE_PROPERTIES,
	BOXES_UI_STATE_TROUBLESHOOT
} BoxesUIState;

#define BOXES_TYPE_UI_STATE (boxes_ui_state_get_type ())

#define BOXES_TYPE_APP_WINDOW (boxes_app_window_get_type ())
#define BOXES_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_APP_WINDOW, BoxesAppWindow))
#define BOXES_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_APP_WINDOW, BoxesAppWindowClass))
#define BOXES_IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_APP_WINDOW))
#define BOXES_IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_APP_WINDOW))
#define BOXES_APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_APP_WINDOW, BoxesAppWindowClass))

typedef struct _BoxesAppWindow BoxesAppWindow;
typedef struct _BoxesAppWindowClass BoxesAppWindowClass;
typedef struct _BoxesAppWindowPrivate BoxesAppWindowPrivate;

#define BOXES_TYPE_SEARCHBAR (boxes_searchbar_get_type ())
#define BOXES_SEARCHBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_SEARCHBAR, BoxesSearchbar))
#define BOXES_SEARCHBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_SEARCHBAR, BoxesSearchbarClass))
#define BOXES_IS_SEARCHBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_SEARCHBAR))
#define BOXES_IS_SEARCHBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_SEARCHBAR))
#define BOXES_SEARCHBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_SEARCHBAR, BoxesSearchbarClass))

typedef struct _BoxesSearchbar BoxesSearchbar;
typedef struct _BoxesSearchbarClass BoxesSearchbarClass;

#define BOXES_TYPE_TOPBAR (boxes_topbar_get_type ())
#define BOXES_TOPBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_TOPBAR, BoxesTopbar))
#define BOXES_TOPBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_TOPBAR, BoxesTopbarClass))
#define BOXES_IS_TOPBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_TOPBAR))
#define BOXES_IS_TOPBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_TOPBAR))
#define BOXES_TOPBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_TOPBAR, BoxesTopbarClass))

typedef struct _BoxesTopbar BoxesTopbar;
typedef struct _BoxesTopbarClass BoxesTopbarClass;

#define BOXES_TYPE_TOAST_OVERLAY (boxes_toast_overlay_get_type ())
#define BOXES_TOAST_OVERLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_TOAST_OVERLAY, BoxesToastOverlay))
#define BOXES_TOAST_OVERLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_TOAST_OVERLAY, BoxesToastOverlayClass))
#define BOXES_IS_TOAST_OVERLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_TOAST_OVERLAY))
#define BOXES_IS_TOAST_OVERLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_TOAST_OVERLAY))
#define BOXES_TOAST_OVERLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_TOAST_OVERLAY, BoxesToastOverlayClass))

typedef struct _BoxesToastOverlay BoxesToastOverlay;
typedef struct _BoxesToastOverlayClass BoxesToastOverlayClass;

#define BOXES_TYPE_DISPLAY_PAGE (boxes_display_page_get_type ())
#define BOXES_DISPLAY_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_DISPLAY_PAGE, BoxesDisplayPage))
#define BOXES_DISPLAY_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_DISPLAY_PAGE, BoxesDisplayPageClass))
#define BOXES_IS_DISPLAY_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_DISPLAY_PAGE))
#define BOXES_IS_DISPLAY_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_DISPLAY_PAGE))
#define BOXES_DISPLAY_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_DISPLAY_PAGE, BoxesDisplayPageClass))

typedef struct _BoxesDisplayPage BoxesDisplayPage;
typedef struct _BoxesDisplayPageClass BoxesDisplayPageClass;

#define BOXES_TYPE_TROUBLESHOOT_VIEW (boxes_troubleshoot_view_get_type ())
#define BOXES_TROUBLESHOOT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_TROUBLESHOOT_VIEW, BoxesTroubleshootView))
#define BOXES_TROUBLESHOOT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_TROUBLESHOOT_VIEW, BoxesTroubleshootViewClass))
#define BOXES_IS_TROUBLESHOOT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_TROUBLESHOOT_VIEW))
#define BOXES_IS_TROUBLESHOOT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_TROUBLESHOOT_VIEW))
#define BOXES_TROUBLESHOOT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_TROUBLESHOOT_VIEW, BoxesTroubleshootViewClass))

typedef struct _BoxesTroubleshootView BoxesTroubleshootView;
typedef struct _BoxesTroubleshootViewClass BoxesTroubleshootViewClass;

#define BOXES_TYPE_COLLECTION_ITEM (boxes_collection_item_get_type ())
#define BOXES_COLLECTION_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItem))
#define BOXES_COLLECTION_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItemClass))
#define BOXES_IS_COLLECTION_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_COLLECTION_ITEM))
#define BOXES_IS_COLLECTION_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_COLLECTION_ITEM))
#define BOXES_COLLECTION_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItemClass))

typedef struct _BoxesCollectionItem BoxesCollectionItem;
typedef struct _BoxesCollectionItemClass BoxesCollectionItemClass;

#define BOXES_TYPE_ICON_VIEW (boxes_icon_view_get_type ())
#define BOXES_ICON_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_ICON_VIEW, BoxesIconView))
#define BOXES_ICON_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_ICON_VIEW, BoxesIconViewClass))
#define BOXES_IS_ICON_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_ICON_VIEW))
#define BOXES_IS_ICON_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_ICON_VIEW))
#define BOXES_ICON_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_ICON_VIEW, BoxesIconViewClass))

typedef struct _BoxesIconView BoxesIconView;
typedef struct _BoxesIconViewClass BoxesIconViewClass;

#define BOXES_TYPE_LIST_VIEW (boxes_list_view_get_type ())
#define BOXES_LIST_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_LIST_VIEW, BoxesListView))
#define BOXES_LIST_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_LIST_VIEW, BoxesListViewClass))
#define BOXES_IS_LIST_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_LIST_VIEW))
#define BOXES_IS_LIST_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_LIST_VIEW))
#define BOXES_LIST_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_LIST_VIEW, BoxesListViewClass))

typedef struct _BoxesListView BoxesListView;
typedef struct _BoxesListViewClass BoxesListViewClass;
typedef enum  {
	BOXES_APP_WINDOW_VIEW_TYPE_ICON = 1,
	BOXES_APP_WINDOW_VIEW_TYPE_LIST = 2
} BoxesAppWindowViewType;

#define BOXES_APP_WINDOW_TYPE_VIEW_TYPE (boxes_app_window_view_type_get_type ())
enum  {
	BOXES_APP_WINDOW_0_PROPERTY,
	BOXES_APP_WINDOW_PREVIOUS_UI_STATE_PROPERTY,
	BOXES_APP_WINDOW_UI_STATE_PROPERTY,
	BOXES_APP_WINDOW_CURRENT_ITEM_PROPERTY,
	BOXES_APP_WINDOW_FULLSCREENED_PROPERTY,
	BOXES_APP_WINDOW_VIEW_TYPE_PROPERTY,
	BOXES_APP_WINDOW_VIEW_PROPERTY,
	BOXES_APP_WINDOW_FIRST_RUN_PROPERTY,
	BOXES_APP_WINDOW_NUM_PROPERTIES
};
static GParamSpec* boxes_app_window_properties[BOXES_APP_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define BOXES_TYPE_APP (boxes_app_get_type ())
#define BOXES_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_APP, BoxesApp))
#define BOXES_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_APP, BoxesAppClass))
#define BOXES_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_APP))
#define BOXES_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_APP))
#define BOXES_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_APP, BoxesAppClass))

typedef struct _BoxesApp BoxesApp;
typedef struct _BoxesAppClass BoxesAppClass;
typedef void (*BoxesAppCallReadyFunc) (gpointer user_data);

#define BOXES_TYPE_TOAST (boxes_toast_get_type ())
#define BOXES_TOAST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_TOAST, BoxesToast))
#define BOXES_TOAST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_TOAST, BoxesToastClass))
#define BOXES_IS_TOAST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_TOAST))
#define BOXES_IS_TOAST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_TOAST))
#define BOXES_TOAST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_TOAST, BoxesToastClass))

typedef struct _BoxesToast BoxesToast;
typedef struct _BoxesToastClass BoxesToastClass;
typedef struct _BoxesAppPrivate BoxesAppPrivate;

#define BOXES_TYPE_COLLECTION (boxes_collection_get_type ())
#define BOXES_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_COLLECTION, BoxesCollection))
#define BOXES_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_COLLECTION, BoxesCollectionClass))
#define BOXES_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_COLLECTION))
#define BOXES_IS_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_COLLECTION))
#define BOXES_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_COLLECTION, BoxesCollectionClass))

typedef struct _BoxesCollection BoxesCollection;
typedef struct _BoxesCollectionClass BoxesCollectionClass;

#define BOXES_TYPE_SHARED_FOLDERS_MANAGER (boxes_shared_folders_manager_get_type ())
#define BOXES_SHARED_FOLDERS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_SHARED_FOLDERS_MANAGER, BoxesSharedFoldersManager))
#define BOXES_SHARED_FOLDERS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_SHARED_FOLDERS_MANAGER, BoxesSharedFoldersManagerClass))
#define BOXES_IS_SHARED_FOLDERS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_SHARED_FOLDERS_MANAGER))
#define BOXES_IS_SHARED_FOLDERS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_SHARED_FOLDERS_MANAGER))
#define BOXES_SHARED_FOLDERS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_SHARED_FOLDERS_MANAGER, BoxesSharedFoldersManagerClass))

typedef struct _BoxesSharedFoldersManager BoxesSharedFoldersManager;
typedef struct _BoxesSharedFoldersManagerClass BoxesSharedFoldersManagerClass;

#define BOXES_TYPE_MACHINE (boxes_machine_get_type ())
#define BOXES_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_MACHINE, BoxesMachine))
#define BOXES_MACHINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_MACHINE, BoxesMachineClass))
#define BOXES_IS_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_MACHINE))
#define BOXES_IS_MACHINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_MACHINE))
#define BOXES_MACHINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_MACHINE, BoxesMachineClass))

typedef struct _BoxesMachine BoxesMachine;
typedef struct _BoxesMachineClass BoxesMachineClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define BOXES_TYPE_ASSISTANT (boxes_assistant_get_type ())
#define BOXES_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_ASSISTANT, BoxesAssistant))
#define BOXES_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_ASSISTANT, BoxesAssistantClass))
#define BOXES_IS_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_ASSISTANT))
#define BOXES_IS_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_ASSISTANT))
#define BOXES_ASSISTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_ASSISTANT, BoxesAssistantClass))

typedef struct _BoxesAssistant BoxesAssistant;
typedef struct _BoxesAssistantClass BoxesAssistantClass;

#define BOXES_TYPE_WELCOME_TUTORIAL (boxes_welcome_tutorial_get_type ())
#define BOXES_WELCOME_TUTORIAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_WELCOME_TUTORIAL, BoxesWelcomeTutorial))
#define BOXES_WELCOME_TUTORIAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_WELCOME_TUTORIAL, BoxesWelcomeTutorialClass))
#define BOXES_IS_WELCOME_TUTORIAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_WELCOME_TUTORIAL))
#define BOXES_IS_WELCOME_TUTORIAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_WELCOME_TUTORIAL))
#define BOXES_WELCOME_TUTORIAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_WELCOME_TUTORIAL, BoxesWelcomeTutorialClass))

typedef struct _BoxesWelcomeTutorial BoxesWelcomeTutorial;
typedef struct _BoxesWelcomeTutorialClass BoxesWelcomeTutorialClass;

#define BOXES_TYPE_DISPLAY (boxes_display_get_type ())
#define BOXES_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_DISPLAY, BoxesDisplay))
#define BOXES_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_DISPLAY, BoxesDisplayClass))
#define BOXES_IS_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_DISPLAY))
#define BOXES_IS_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_DISPLAY))
#define BOXES_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_DISPLAY, BoxesDisplayClass))

typedef struct _BoxesDisplay BoxesDisplay;
typedef struct _BoxesDisplayClass BoxesDisplayClass;
typedef enum  {
	BOXES_MACHINE_MACHINE_STATE_UNKNOWN,
	BOXES_MACHINE_MACHINE_STATE_STOPPED,
	BOXES_MACHINE_MACHINE_STATE_FORCE_STOPPED,
	BOXES_MACHINE_MACHINE_STATE_RUNNING,
	BOXES_MACHINE_MACHINE_STATE_PAUSED,
	BOXES_MACHINE_MACHINE_STATE_SAVED,
	BOXES_MACHINE_MACHINE_STATE_SLEEPING
} BoxesMachineMachineState;

#define BOXES_MACHINE_TYPE_MACHINE_STATE (boxes_machine_machine_state_get_type ())

struct _BoxesUIIface {
	GTypeInterface parent_iface;
	BoxesUIState (*get_previous_ui_state) (BoxesUI* self);
	void (*set_previous_ui_state) (BoxesUI* self, BoxesUIState value);
	BoxesUIState (*get_ui_state) (BoxesUI* self);
	void (*set_ui_state) (BoxesUI* self, BoxesUIState value);
};

struct _BoxesAppWindow {
	HdyApplicationWindow parent_instance;
	BoxesAppWindowPrivate * priv;
	BoxesSearchbar* searchbar;
	BoxesTopbar* topbar;
	BoxesToastOverlay* toast_overlay;
	BoxesDisplayPage* display_page;
	HdyStatusPage* empty_boxes;
	BoxesTroubleshootView* troubleshoot_view;
	GtkStack* below_bin;
	GSettings* settings;
};

struct _BoxesAppWindowClass {
	HdyApplicationWindowClass parent_class;
};

struct _BoxesAppWindowPrivate {
	BoxesUIState _previous_ui_state;
	BoxesUIState _ui_state;
	BoxesCollectionItem* _current_item;
	GBinding* status_bind;
	gulong got_error_id;
	gulong machine_state_notify_id;
	gulong machine_deleted_notify_id;
	BoxesIconView* icon_view;
	BoxesListView* list_view;
	BoxesAppWindowViewType _view_type;
	guint configure_id;
	GtkWindowGroup* group;
};

struct _BoxesApp {
	GtkApplication parent_instance;
	BoxesAppPrivate * priv;
	BoxesCollection* collection;
	BoxesAsyncLauncher* async_launcher;
	BoxesSharedFoldersManager* shared_folders_manager;
};

struct _BoxesAppClass {
	GtkApplicationClass parent_class;
};

static gint BoxesAppWindow_private_offset;
static gpointer boxes_app_window_parent_class = NULL;
VALA_EXTERN BoxesApp* boxes_app_app;
static BoxesUIIface * boxes_app_window_boxes_ui_parent_iface = NULL;

VALA_EXTERN GType boxes_ui_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType boxes_ui_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesUI, g_object_unref)
VALA_EXTERN GType boxes_app_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesAppWindow, g_object_unref)
VALA_EXTERN GType boxes_searchbar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesSearchbar, g_object_unref)
VALA_EXTERN GType boxes_topbar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesTopbar, g_object_unref)
VALA_EXTERN GType boxes_toast_overlay_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesToastOverlay, g_object_unref)
VALA_EXTERN GType boxes_display_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesDisplayPage, g_object_unref)
VALA_EXTERN GType boxes_troubleshoot_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesTroubleshootView, g_object_unref)
VALA_EXTERN GType boxes_collection_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesCollectionItem, g_object_unref)
VALA_EXTERN GType boxes_icon_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesIconView, g_object_unref)
VALA_EXTERN GType boxes_list_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesListView, g_object_unref)
VALA_EXTERN GType boxes_app_window_view_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN BoxesAppWindow* boxes_app_window_new (GtkApplication* app);
VALA_EXTERN BoxesAppWindow* boxes_app_window_construct (GType object_type,
                                            GtkApplication* app);
VALA_EXTERN GtkCssProvider* boxes_load_css (const gchar* css);
static gint _variant_get1 (GVariant* value);
static gint _variant_get2 (GVariant* value);
static gint _variant_get3 (GVariant* value);
static gint _variant_get4 (GVariant* value);
VALA_EXTERN void boxes_app_window_setup_ui (BoxesAppWindow* self);
VALA_EXTERN void boxes_topbar_setup_ui (BoxesTopbar* self,
                            BoxesAppWindow* window);
VALA_EXTERN void boxes_display_page_setup_ui (BoxesDisplayPage* self,
                                  BoxesAppWindow* window);
VALA_EXTERN void boxes_icon_view_setup_ui (BoxesIconView* self,
                               BoxesAppWindow* window);
VALA_EXTERN void boxes_list_view_setup_ui (BoxesListView* self,
                               BoxesAppWindow* window);
VALA_EXTERN void boxes_searchbar_setup_ui (BoxesSearchbar* self,
                               BoxesAppWindow* window);
VALA_EXTERN void boxes_troubleshoot_view_setup_ui (BoxesTroubleshootView* self,
                                       BoxesAppWindow* window);
VALA_EXTERN GType boxes_app_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesApp, g_object_unref)
VALA_EXTERN void boxes_app_call_when_ready (BoxesApp* self,
                                BoxesAppCallReadyFunc func,
                                gpointer func_target,
                                GDestroyNotify func_target_destroy_notify);
static void boxes_app_window_on_app_ready (BoxesAppWindow* self);
static void _boxes_app_window_on_app_ready_boxes_app_call_ready_func (gpointer self);
VALA_EXTERN GType boxes_toast_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesToast, g_object_unref)
VALA_EXTERN void boxes_app_window_display_toast (BoxesAppWindow* self,
                                     BoxesToast* toast);
VALA_EXTERN void boxes_toast_overlay_display_toast (BoxesToastOverlay* self,
                                        BoxesToast* toast);
VALA_EXTERN void boxes_app_window_dismiss_toast (BoxesAppWindow* self);
VALA_EXTERN void boxes_toast_overlay_dismiss (BoxesToastOverlay* self);
static void boxes_app_window_ui_state_changed (BoxesAppWindow* self);
static void _boxes_app_window_ui_state_changed_g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self);
static void boxes_app_window_on_collection_changed (BoxesAppWindow* self);
VALA_EXTERN GType boxes_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesCollection, g_object_unref)
VALA_EXTERN GType boxes_shared_folders_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesSharedFoldersManager, g_object_unref)
static void _boxes_app_window_on_collection_changed_boxes_collection_item_added (BoxesCollection* _sender,
                                                                          BoxesCollectionItem* item,
                                                                          gpointer self);
static void _boxes_app_window_on_collection_changed_boxes_collection_item_removed (BoxesCollection* _sender,
                                                                            BoxesCollectionItem* item,
                                                                            gpointer self);
VALA_EXTERN guint boxes_collection_get_length (BoxesCollection* self);
VALA_EXTERN void boxes_searchbar_set_enable_key_handler (BoxesSearchbar* self,
                                             gboolean value);
VALA_EXTERN GtkWidget* boxes_app_window_get_view (BoxesAppWindow* self);
static void boxes_app_window_save_window_geometry (BoxesAppWindow* self);
static gboolean boxes_app_window_get_maximized (BoxesAppWindow* self);
static GVariant* _variant_new1 (gint* value,
                         gint value_length1);
static GVariant* _variant_new2 (gint* value,
                         gint value_length1);
VALA_EXTERN void boxes_ui_set_state (BoxesUI* self,
                         BoxesUIState new_state);
VALA_EXTERN BoxesUIState boxes_ui_get_ui_state (BoxesUI* self);
VALA_EXTERN GType boxes_machine_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesMachine, g_object_unref)
VALA_EXTERN BoxesCollectionItem* boxes_app_window_get_current_item (BoxesAppWindow* self);
VALA_EXTERN void boxes_app_window_set_fullscreened (BoxesAppWindow* self,
                                        gboolean value);
VALA_EXTERN void boxes_topbar_set_status (BoxesTopbar* self,
                              const gchar* value);
VALA_EXTERN GCancellable* boxes_machine_get_connecting_cancellable (BoxesMachine* self);
VALA_EXTERN void boxes_machine_schedule_autosave (BoxesMachine* self);
VALA_EXTERN void boxes_machine_unschedule_autosave (BoxesMachine* self);
VALA_EXTERN BoxesAppWindow* boxes_machine_get_window (BoxesMachine* self);
VALA_EXTERN void boxes_app_window_show_vm_assistant (BoxesAppWindow* self,
                                         const gchar* path);
VALA_EXTERN BoxesAssistant* boxes_assistant_new (BoxesAppWindow* app_window,
                                     const gchar* path);
VALA_EXTERN BoxesAssistant* boxes_assistant_construct (GType object_type,
                                           BoxesAppWindow* app_window,
                                           const gchar* path);
VALA_EXTERN GType boxes_assistant_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesAssistant, g_object_unref)
VALA_EXTERN void boxes_app_window_show_welcome_tutorial (BoxesAppWindow* self);
VALA_EXTERN gboolean boxes_app_window_get_first_run (BoxesAppWindow* self);
VALA_EXTERN BoxesWelcomeTutorial* boxes_welcome_tutorial_new (BoxesAppWindow* app_window);
VALA_EXTERN BoxesWelcomeTutorial* boxes_welcome_tutorial_construct (GType object_type,
                                                        BoxesAppWindow* app_window);
VALA_EXTERN GType boxes_welcome_tutorial_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesWelcomeTutorial, g_object_unref)
VALA_EXTERN void boxes_app_window_set_first_run (BoxesAppWindow* self,
                                     gboolean value);
VALA_EXTERN void boxes_app_window_show_send_file (BoxesAppWindow* self);
VALA_EXTERN GType boxes_display_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesDisplay, g_object_unref)
VALA_EXTERN BoxesDisplay* boxes_machine_get_display (BoxesMachine* self);
VALA_EXTERN void boxes_display_transfer_files (BoxesDisplay* self,
                                   GList* uris);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
static inline void _g_slist_free__g_free0_ (GSList* self);
VALA_EXTERN void boxes_app_window_connect_to (BoxesAppWindow* self,
                                  BoxesMachine* machine);
VALA_EXTERN void boxes_app_window_set_current_item (BoxesAppWindow* self,
                                        BoxesCollectionItem* value);
VALA_EXTERN void boxes_machine_set_window (BoxesMachine* self,
                               BoxesAppWindow* value);
VALA_EXTERN const gchar* boxes_collection_item_get_name (BoxesCollectionItem* self);
static void __lambda42_ (BoxesAppWindow* self,
                  const gchar* message);
VALA_EXTERN BoxesToast* boxes_toast_new (const gchar* message);
VALA_EXTERN BoxesToast* boxes_toast_construct (GType object_type,
                                   const gchar* message);
static void ___lambda42__boxes_machine_got_error (BoxesMachine* _sender,
                                           const gchar* message,
                                           gpointer self);
VALA_EXTERN void boxes_app_window_select_item (BoxesAppWindow* self,
                                   BoxesCollectionItem* item);
VALA_EXTERN BoxesAppWindow* boxes_app_get_main_window (BoxesApp* self);
VALA_EXTERN gboolean boxes_app_window_on_key_pressed (BoxesAppWindow* self,
                                          GtkWidget* widget,
                                          GdkEventKey* event);
VALA_EXTERN gboolean boxes_app_window_get_fullscreened (BoxesAppWindow* self);
VALA_EXTERN void boxes_topbar_pop_main_menu (BoxesTopbar* self);
VALA_EXTERN gboolean boxes_app_quit_app (BoxesApp* self);
VALA_EXTERN void boxes_topbar_click_search_button (BoxesTopbar* self);
VALA_EXTERN void boxes_topbar_click_back_button (BoxesTopbar* self);
static gboolean _boxes_app_window_on_key_pressed_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                      GdkEventKey* event,
                                                                      gpointer self);
static gboolean boxes_app_window_on_configure_event (BoxesAppWindow* self);
static gboolean __lambda136_ (BoxesAppWindow* self);
static gboolean ___lambda136__gsource_func (gpointer self);
static gboolean _boxes_app_window_on_configure_event_gtk_widget_configure_event (GtkWidget* _sender,
                                                                          GdkEventConfigure* event,
                                                                          gpointer self);
static gboolean boxes_app_window_on_window_state_event (BoxesAppWindow* self,
                                                 GdkEventWindowState* event);
static gboolean _boxes_app_window_on_window_state_event_gtk_widget_window_state_event (GtkWidget* _sender,
                                                                                GdkEventWindowState* event,
                                                                                gpointer self);
static gboolean boxes_app_window_on_delete_event (BoxesAppWindow* self);
VALA_EXTERN gboolean boxes_app_remove_window (BoxesApp* self,
                                  BoxesAppWindow* window);
static gboolean _boxes_app_window_on_delete_event_gtk_widget_delete_event (GtkWidget* _sender,
                                                                    GdkEventAny* event,
                                                                    gpointer self);
static void boxes_app_window_on_machine_state_notify (BoxesAppWindow* self);
VALA_EXTERN GType boxes_machine_machine_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN BoxesMachineMachineState boxes_machine_get_state (BoxesMachine* self);
static void boxes_app_window_on_machine_deleted_notify (BoxesAppWindow* self);
VALA_EXTERN gboolean boxes_machine_get_deleted (BoxesMachine* self);
static void _boxes_app_window_on_machine_state_notify_g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self);
static void _boxes_app_window_on_machine_deleted_notify_g_object_notify (GObject* _sender,
                                                                  GParamSpec* pspec,
                                                                  gpointer self);
VALA_EXTERN BoxesAppWindowViewType boxes_app_window_get_view_type (BoxesAppWindow* self);
VALA_EXTERN void boxes_app_window_set_view_type (BoxesAppWindow* self,
                                     BoxesAppWindowViewType value);
VALA_EXTERN BoxesUIState boxes_ui_get_previous_ui_state (BoxesUI* self);
VALA_EXTERN void boxes_ui_set_previous_ui_state (BoxesUI* self,
                                     BoxesUIState value);
VALA_EXTERN void boxes_ui_set_ui_state (BoxesUI* self,
                            BoxesUIState value);
static void boxes_app_window_finalize (GObject * obj);
static GType boxes_app_window_get_type_once (void);
static void _vala_boxes_app_window_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_boxes_app_window_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);

static inline gpointer
boxes_app_window_get_instance_private (BoxesAppWindow* self)
{
	return G_STRUCT_MEMBER_P (self, BoxesAppWindow_private_offset);
}

static GType
boxes_app_window_view_type_get_type_once (void)
{
	static const GEnumValue values[] = {{BOXES_APP_WINDOW_VIEW_TYPE_ICON, "BOXES_APP_WINDOW_VIEW_TYPE_ICON", "icon"}, {BOXES_APP_WINDOW_VIEW_TYPE_LIST, "BOXES_APP_WINDOW_VIEW_TYPE_LIST", "list"}, {0, NULL, NULL}};
	GType boxes_app_window_view_type_type_id;
	boxes_app_window_view_type_type_id = g_enum_register_static ("BoxesAppWindowViewType", values);
	return boxes_app_window_view_type_type_id;
}

GType
boxes_app_window_view_type_get_type (void)
{
	static volatile gsize boxes_app_window_view_type_type_id__once = 0;
	if (g_once_init_enter (&boxes_app_window_view_type_type_id__once)) {
		GType boxes_app_window_view_type_type_id;
		boxes_app_window_view_type_type_id = boxes_app_window_view_type_get_type_once ();
		g_once_init_leave (&boxes_app_window_view_type_type_id__once, boxes_app_window_view_type_type_id);
	}
	return boxes_app_window_view_type_type_id__once;
}

static gint
_variant_get1 (GVariant* value)
{
	return g_variant_get_int32 (value);
}

static gint
_variant_get2 (GVariant* value)
{
	return g_variant_get_int32 (value);
}

static gint
_variant_get3 (GVariant* value)
{
	return g_variant_get_int32 (value);
}

static gint
_variant_get4 (GVariant* value)
{
	return g_variant_get_int32 (value);
}

BoxesAppWindow*
boxes_app_window_construct (GType object_type,
                            GtkApplication* app)
{
	BoxesAppWindow * self = NULL;
	GSettings* _tmp0_;
	HdyStyleManager* _tmp1_;
	GtkCssProvider* provider = NULL;
	GtkCssProvider* _tmp2_;
	GdkScreen* _tmp3_;
	GtkCssProvider* _tmp4_;
	GVariant* size = NULL;
	GSettings* _tmp5_;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
	GSettings* _tmp18_;
	GVariant* position = NULL;
	GSettings* _tmp19_;
	GVariant* _tmp20_;
	GVariant* _tmp21_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	g_return_val_if_fail (app != NULL, NULL);
	self = (BoxesAppWindow*) g_object_new (object_type, "application", app, "title", _ ("Boxes"), "show-menubar", FALSE, NULL);
	_tmp0_ = g_settings_new ("org.gnome.boxes");
	_g_object_unref0 (self->settings);
	self->settings = _tmp0_;
	gtk_window_set_default_icon_name (APPLICATION_ID);
	_tmp1_ = hdy_style_manager_get_default ();
	hdy_style_manager_set_color_scheme (_tmp1_, HDY_COLOR_SCHEME_PREFER_DARK);
	_tmp2_ = boxes_load_css ("gtk-style.css");
	provider = _tmp2_;
	_tmp3_ = gdk_screen_get_default ();
	_tmp4_ = provider;
	gtk_style_context_add_provider_for_screen (_tmp3_, (GtkStyleProvider*) _tmp4_, (guint) 600);
	_tmp5_ = self->settings;
	_tmp6_ = g_settings_get_value (_tmp5_, "window-size");
	size = _tmp6_;
	_tmp7_ = size;
	if (g_variant_n_children (_tmp7_) == ((gsize) 2)) {
		gint width = 0;
		GVariant* _tmp8_;
		GVariant* _tmp9_;
		GVariant* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint height = 0;
		GVariant* _tmp13_;
		GVariant* _tmp14_;
		GVariant* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		_tmp8_ = size;
		_tmp9_ = g_variant_get_child_value (_tmp8_, (gsize) 0);
		_tmp10_ = _tmp9_;
		_tmp11_ = _variant_get1 (_tmp10_);
		_tmp12_ = _tmp11_;
		_g_variant_unref0 (_tmp10_);
		width = _tmp12_;
		_tmp13_ = size;
		_tmp14_ = g_variant_get_child_value (_tmp13_, (gsize) 1);
		_tmp15_ = _tmp14_;
		_tmp16_ = _variant_get2 (_tmp15_);
		_tmp17_ = _tmp16_;
		_g_variant_unref0 (_tmp15_);
		height = _tmp17_;
		gtk_window_set_default_size ((GtkWindow*) self, width, height);
	}
	_tmp18_ = self->settings;
	if (g_settings_get_boolean (_tmp18_, "window-maximized")) {
		gtk_window_maximize ((GtkWindow*) self);
	}
	_tmp19_ = self->settings;
	_tmp20_ = g_settings_get_value (_tmp19_, "window-position");
	position = _tmp20_;
	_tmp21_ = position;
	if (g_variant_n_children (_tmp21_) == ((gsize) 2)) {
		gint x = 0;
		GVariant* _tmp22_;
		GVariant* _tmp23_;
		GVariant* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint y = 0;
		GVariant* _tmp27_;
		GVariant* _tmp28_;
		GVariant* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		_tmp22_ = position;
		_tmp23_ = g_variant_get_child_value (_tmp22_, (gsize) 0);
		_tmp24_ = _tmp23_;
		_tmp25_ = _variant_get3 (_tmp24_);
		_tmp26_ = _tmp25_;
		_g_variant_unref0 (_tmp24_);
		x = _tmp26_;
		_tmp27_ = position;
		_tmp28_ = g_variant_get_child_value (_tmp27_, (gsize) 1);
		_tmp29_ = _tmp28_;
		_tmp30_ = _variant_get4 (_tmp29_);
		_tmp31_ = _tmp30_;
		_g_variant_unref0 (_tmp29_);
		y = _tmp31_;
		gtk_window_move ((GtkWindow*) self, x, y);
	}
	_tmp32_ = g_application_get_application_id ((GApplication*) app);
	_tmp33_ = _tmp32_;
	if (g_strcmp0 (_tmp33_, "org.gnome.BoxesDevel") == 0) {
		GtkStyleContext* _tmp34_;
		_tmp34_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_add_class (_tmp34_, "devel");
	}
	_g_variant_unref0 (position);
	_g_variant_unref0 (size);
	_g_object_unref0 (provider);
	return self;
}

BoxesAppWindow*
boxes_app_window_new (GtkApplication* app)
{
	return boxes_app_window_construct (BOXES_TYPE_APP_WINDOW, app);
}

static void
_boxes_app_window_on_app_ready_boxes_app_call_ready_func (gpointer self)
{
	boxes_app_window_on_app_ready ((BoxesAppWindow*) self);
}

void
boxes_app_window_setup_ui (BoxesAppWindow* self)
{
	BoxesTopbar* _tmp0_;
	BoxesDisplayPage* _tmp1_;
	BoxesIconView* _tmp2_;
	BoxesListView* _tmp3_;
	BoxesSearchbar* _tmp4_;
	BoxesTroubleshootView* _tmp5_;
	GtkWindowGroup* _tmp6_;
	GtkWindowGroup* _tmp7_;
	BoxesApp* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->topbar;
	boxes_topbar_setup_ui (_tmp0_, self);
	_tmp1_ = self->display_page;
	boxes_display_page_setup_ui (_tmp1_, self);
	_tmp2_ = self->priv->icon_view;
	boxes_icon_view_setup_ui (_tmp2_, self);
	_tmp3_ = self->priv->list_view;
	boxes_list_view_setup_ui (_tmp3_, self);
	_tmp4_ = self->searchbar;
	boxes_searchbar_setup_ui (_tmp4_, self);
	_tmp5_ = self->troubleshoot_view;
	boxes_troubleshoot_view_setup_ui (_tmp5_, self);
	_tmp6_ = gtk_window_group_new ();
	_g_object_unref0 (self->priv->group);
	self->priv->group = _tmp6_;
	_tmp7_ = self->priv->group;
	gtk_window_group_add_window (_tmp7_, (GtkWindow*) self);
	_tmp8_ = boxes_app_app;
	boxes_app_call_when_ready (_tmp8_, _boxes_app_window_on_app_ready_boxes_app_call_ready_func, g_object_ref (self), g_object_unref);
}

void
boxes_app_window_display_toast (BoxesAppWindow* self,
                                BoxesToast* toast)
{
	BoxesToastOverlay* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (toast != NULL);
	_tmp0_ = self->toast_overlay;
	boxes_toast_overlay_display_toast (_tmp0_, toast);
}

void
boxes_app_window_dismiss_toast (BoxesAppWindow* self)
{
	BoxesToastOverlay* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->toast_overlay;
	boxes_toast_overlay_dismiss (_tmp0_);
}

static void
_boxes_app_window_ui_state_changed_g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self)
{
	boxes_app_window_ui_state_changed ((BoxesAppWindow*) self);
}

static void
_boxes_app_window_on_collection_changed_boxes_collection_item_added (BoxesCollection* _sender,
                                                                     BoxesCollectionItem* item,
                                                                     gpointer self)
{
	boxes_app_window_on_collection_changed ((BoxesAppWindow*) self);
}

static void
_boxes_app_window_on_collection_changed_boxes_collection_item_removed (BoxesCollection* _sender,
                                                                       BoxesCollectionItem* item,
                                                                       gpointer self)
{
	boxes_app_window_on_collection_changed ((BoxesAppWindow*) self);
}

static void
boxes_app_window_on_app_ready (BoxesAppWindow* self)
{
	BoxesApp* _tmp0_;
	BoxesCollection* _tmp1_;
	BoxesApp* _tmp2_;
	BoxesCollection* _tmp3_;
	g_return_if_fail (self != NULL);
	g_signal_connect_object ((GObject*) self, "notify::ui-state", (GCallback) _boxes_app_window_ui_state_changed_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::view-type", (GCallback) _boxes_app_window_ui_state_changed_g_object_notify, self, 0);
	boxes_app_window_on_collection_changed (self);
	_tmp0_ = boxes_app_app;
	_tmp1_ = _tmp0_->collection;
	g_signal_connect_object (_tmp1_, "item-added", (GCallback) _boxes_app_window_on_collection_changed_boxes_collection_item_added, self, 0);
	_tmp2_ = boxes_app_app;
	_tmp3_ = _tmp2_->collection;
	g_signal_connect_object (_tmp3_, "item-removed", (GCallback) _boxes_app_window_on_collection_changed_boxes_collection_item_removed, self, 0);
}

static void
boxes_app_window_on_collection_changed (BoxesAppWindow* self)
{
	gboolean collection_is_empty = FALSE;
	BoxesApp* _tmp0_;
	BoxesCollection* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	BoxesSearchbar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = boxes_app_app;
	_tmp1_ = _tmp0_->collection;
	_tmp2_ = boxes_collection_get_length (_tmp1_);
	_tmp3_ = _tmp2_;
	collection_is_empty = _tmp3_ == ((guint) 0);
	_tmp4_ = self->searchbar;
	boxes_searchbar_set_enable_key_handler (_tmp4_, !collection_is_empty);
	if (collection_is_empty) {
		GtkStack* _tmp5_;
		HdyStatusPage* _tmp6_;
		_tmp5_ = self->below_bin;
		_tmp6_ = self->empty_boxes;
		gtk_stack_set_visible_child (_tmp5_, (GtkWidget*) _tmp6_);
	} else {
		GtkStack* _tmp7_;
		GtkWidget* _tmp8_;
		GtkWidget* _tmp9_;
		_tmp7_ = self->below_bin;
		_tmp8_ = boxes_app_window_get_view (self);
		_tmp9_ = _tmp8_;
		gtk_stack_set_visible_child (_tmp7_, _tmp9_);
	}
}

static GVariant*
_variant_new1 (gint* value,
               gint value_length1)
{
	gint* _tmp7_;
	GVariantBuilder _tmp8_;
	gint _tmp9_;
	_tmp7_ = value;
	g_variant_builder_init (&_tmp8_, G_VARIANT_TYPE ("ai"));
	for (_tmp9_ = 0; _tmp9_ < value_length1; _tmp9_++) {
		g_variant_builder_add_value (&_tmp8_, g_variant_new_int32 (*_tmp7_));
		_tmp7_++;
	}
	return g_variant_ref_sink (g_variant_builder_end (&_tmp8_));
}

static GVariant*
_variant_new2 (gint* value,
               gint value_length1)
{
	gint* _tmp16_;
	GVariantBuilder _tmp17_;
	gint _tmp18_;
	_tmp16_ = value;
	g_variant_builder_init (&_tmp17_, G_VARIANT_TYPE ("ai"));
	for (_tmp18_ = 0; _tmp18_ < value_length1; _tmp18_++) {
		g_variant_builder_add_value (&_tmp17_, g_variant_new_int32 (*_tmp16_));
		_tmp16_++;
	}
	return g_variant_ref_sink (g_variant_builder_end (&_tmp17_));
}

static void
boxes_app_window_save_window_geometry (BoxesAppWindow* self)
{
	gint width = 0;
	gint height = 0;
	gint x = 0;
	gint y = 0;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GSettings* _tmp4_;
	gint* _tmp5_;
	gint* _tmp6_;
	gint _tmp6__length1;
	GVariant* _tmp10_;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	GSettings* _tmp13_;
	gint* _tmp14_;
	gint* _tmp15_;
	gint _tmp15__length1;
	GVariant* _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = boxes_app_window_get_maximized (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	gtk_window_get_size ((GtkWindow*) self, &_tmp2_, &_tmp3_);
	width = _tmp2_;
	height = _tmp3_;
	_tmp4_ = self->settings;
	_tmp5_ = g_new0 (gint, 2);
	_tmp5_[0] = width;
	_tmp5_[1] = height;
	_tmp6_ = _tmp5_;
	_tmp6__length1 = 2;
	_tmp10_ = _variant_new1 (_tmp6_, 2);
	g_settings_set_value (_tmp4_, "window-size", _tmp10_);
	_g_variant_unref0 (_tmp10_);
	_tmp6_ = (g_free (_tmp6_), NULL);
	gtk_window_get_position ((GtkWindow*) self, &_tmp11_, &_tmp12_);
	x = _tmp11_;
	y = _tmp12_;
	_tmp13_ = self->settings;
	_tmp14_ = g_new0 (gint, 2);
	_tmp14_[0] = x;
	_tmp14_[1] = y;
	_tmp15_ = _tmp14_;
	_tmp15__length1 = 2;
	_tmp19_ = _variant_new2 (_tmp15_, 2);
	g_settings_set_value (_tmp13_, "window-position", _tmp19_);
	_g_variant_unref0 (_tmp19_);
	_tmp15_ = (g_free (_tmp15_), NULL);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
boxes_app_window_ui_state_changed (BoxesAppWindow* self)
{
	BoxesTopbar* _tmp0_;
	BoxesUIState _tmp1_;
	BoxesUIState _tmp2_;
	BoxesUIState _tmp3_;
	BoxesUIState _tmp4_;
	BoxesMachine* _tmp6_ = NULL;
	BoxesCollectionItem* _tmp7_;
	BoxesCollectionItem* _tmp8_;
	BoxesMachine* machine = NULL;
	BoxesMachine* _tmp11_;
	BoxesUIState _tmp12_;
	BoxesUIState _tmp13_;
	gboolean _tmp49_ = FALSE;
	BoxesMachine* _tmp50_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->topbar;
	_tmp1_ = boxes_ui_get_ui_state ((BoxesUI*) self);
	_tmp2_ = _tmp1_;
	boxes_ui_set_state ((BoxesUI*) _tmp0_, _tmp2_);
	_tmp3_ = boxes_ui_get_ui_state ((BoxesUI*) self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != BOXES_UI_STATE_COLLECTION) {
		BoxesSearchbar* _tmp5_;
		_tmp5_ = self->searchbar;
		g_object_set ((GtkSearchBar*) _tmp5_, "search-mode-enabled", FALSE, NULL);
	}
	_tmp7_ = boxes_app_window_get_current_item (self);
	_tmp8_ = _tmp7_;
	if (BOXES_IS_MACHINE (_tmp8_)) {
		BoxesCollectionItem* _tmp9_;
		BoxesCollectionItem* _tmp10_;
		_tmp9_ = boxes_app_window_get_current_item (self);
		_tmp10_ = _tmp9_;
		_tmp6_ = BOXES_IS_MACHINE (_tmp10_) ? ((BoxesMachine*) _tmp10_) : NULL;
	} else {
		_tmp6_ = NULL;
	}
	_tmp11_ = _g_object_ref0 (_tmp6_);
	machine = _tmp11_;
	_tmp12_ = boxes_ui_get_ui_state ((BoxesUI*) self);
	_tmp13_ = _tmp12_;
	switch (_tmp13_) {
		case BOXES_UI_STATE_COLLECTION:
		{
			BoxesApp* _tmp14_;
			BoxesCollection* _tmp15_;
			guint _tmp16_;
			guint _tmp17_;
			GBinding* _tmp23_;
			BoxesTopbar* _tmp26_;
			AtkObject* a11y = NULL;
			AtkObject* _tmp27_;
			AtkObject* _tmp28_;
			AtkObject* _tmp29_;
			BoxesMachine* _tmp30_;
			_tmp14_ = boxes_app_app;
			_tmp15_ = _tmp14_->collection;
			_tmp16_ = boxes_collection_get_length (_tmp15_);
			_tmp17_ = _tmp16_;
			if (_tmp17_ != ((guint) 0)) {
				GtkStack* _tmp18_;
				GtkWidget* _tmp19_;
				GtkWidget* _tmp20_;
				_tmp18_ = self->below_bin;
				_tmp19_ = boxes_app_window_get_view (self);
				_tmp20_ = _tmp19_;
				gtk_stack_set_visible_child (_tmp18_, _tmp20_);
			} else {
				GtkStack* _tmp21_;
				HdyStatusPage* _tmp22_;
				_tmp21_ = self->below_bin;
				_tmp22_ = self->empty_boxes;
				gtk_stack_set_visible_child (_tmp21_, (GtkWidget*) _tmp22_);
			}
			boxes_app_window_set_fullscreened (self, FALSE);
			_tmp23_ = self->priv->status_bind;
			if (_tmp23_ != NULL) {
				GBinding* _tmp24_;
				GBinding* _tmp25_;
				_tmp24_ = self->priv->status_bind;
				_tmp25_ = _g_object_ref0 (_tmp24_);
				g_binding_unbind (_tmp25_);
				_g_object_unref0 (self->priv->status_bind);
				self->priv->status_bind = NULL;
			}
			_tmp26_ = self->topbar;
			boxes_topbar_set_status (_tmp26_, _ ("Boxes"));
			_tmp27_ = gtk_widget_get_accessible ((GtkWidget*) self);
			_tmp28_ = _g_object_ref0 (_tmp27_);
			a11y = _tmp28_;
			_tmp29_ = a11y;
			g_object_set (_tmp29_, "accessible-name", _ ("Boxes"), NULL);
			_tmp30_ = machine;
			if (_tmp30_ != NULL) {
				BoxesMachine* _tmp32_;
				GCancellable* _tmp33_;
				GCancellable* _tmp34_;
				BoxesMachine* _tmp35_;
				if (self->priv->got_error_id != ((gulong) 0)) {
					BoxesMachine* _tmp31_;
					_tmp31_ = machine;
					g_signal_handler_disconnect ((GObject*) _tmp31_, self->priv->got_error_id);
					self->priv->got_error_id = (gulong) 0;
				}
				_tmp32_ = machine;
				_tmp33_ = boxes_machine_get_connecting_cancellable (_tmp32_);
				_tmp34_ = _tmp33_;
				g_cancellable_cancel (_tmp34_);
				_tmp35_ = machine;
				boxes_machine_schedule_autosave (_tmp35_);
			}
			_g_object_unref0 (a11y);
			break;
		}
		case BOXES_UI_STATE_CREDS:
		case BOXES_UI_STATE_DISPLAY:
		case BOXES_UI_STATE_WIZARD:
		case BOXES_UI_STATE_PROPERTIES:
		{
			BoxesCollectionItem* _tmp36_;
			BoxesCollectionItem* _tmp37_;
			_tmp36_ = boxes_app_window_get_current_item (self);
			_tmp37_ = _tmp36_;
			if (_tmp37_ != NULL) {
				BoxesMachine* current_machine = NULL;
				BoxesCollectionItem* _tmp38_;
				BoxesCollectionItem* _tmp39_;
				BoxesMachine* _tmp40_;
				BoxesMachine* _tmp41_;
				_tmp38_ = boxes_app_window_get_current_item (self);
				_tmp39_ = _tmp38_;
				_tmp40_ = _g_object_ref0 (BOXES_IS_MACHINE (_tmp39_) ? ((BoxesMachine*) _tmp39_) : NULL);
				current_machine = _tmp40_;
				_tmp41_ = current_machine;
				boxes_machine_unschedule_autosave (_tmp41_);
				_g_object_unref0 (current_machine);
			}
			break;
		}
		case BOXES_UI_STATE_TROUBLESHOOT:
		{
			GtkStack* _tmp42_;
			BoxesTroubleshootView* _tmp43_;
			_tmp42_ = self->below_bin;
			_tmp43_ = self->troubleshoot_view;
			gtk_stack_set_visible_child (_tmp42_, (GtkWidget*) _tmp43_);
			break;
		}
		default:
		{
			BoxesUIState _tmp44_;
			BoxesUIState _tmp45_;
			GEnumValue* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			_tmp44_ = boxes_ui_get_ui_state ((BoxesUI*) self);
			_tmp45_ = _tmp44_;
			_tmp46_ = g_enum_get_value (g_type_class_ref (BOXES_TYPE_UI_STATE), _tmp45_);
			_tmp47_ = g_strdup_printf ("Unhandled UI state %s", (_tmp46_ != NULL) ? _tmp46_->value_name : NULL);
			_tmp48_ = _tmp47_;
			g_warning ("app-window.vala:251: %s", _tmp48_);
			_g_free0 (_tmp48_);
			break;
		}
	}
	_tmp50_ = machine;
	if (_tmp50_ != NULL) {
		BoxesMachine* _tmp51_;
		BoxesAppWindow* _tmp52_;
		BoxesAppWindow* _tmp53_;
		_tmp51_ = machine;
		_tmp52_ = boxes_machine_get_window (_tmp51_);
		_tmp53_ = _tmp52_;
		_tmp49_ = self == _tmp53_;
	} else {
		_tmp49_ = FALSE;
	}
	if (_tmp49_) {
		BoxesCollectionItem* _tmp54_;
		BoxesCollectionItem* _tmp55_;
		BoxesUIState _tmp56_;
		BoxesUIState _tmp57_;
		_tmp54_ = boxes_app_window_get_current_item (self);
		_tmp55_ = _tmp54_;
		_tmp56_ = boxes_ui_get_ui_state ((BoxesUI*) self);
		_tmp57_ = _tmp56_;
		boxes_ui_set_state ((BoxesUI*) _tmp55_, _tmp57_);
	}
	_g_object_unref0 (machine);
}

void
boxes_app_window_show_vm_assistant (BoxesAppWindow* self,
                                    const gchar* path)
{
	BoxesAssistant* _tmp0_;
	BoxesAssistant* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = boxes_assistant_new (self, path);
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	gtk_window_present ((GtkWindow*) _tmp1_);
	_g_object_unref0 (_tmp1_);
}

void
boxes_app_window_show_welcome_tutorial (BoxesAppWindow* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = boxes_app_window_get_first_run (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		BoxesWelcomeTutorial* _tmp2_;
		BoxesWelcomeTutorial* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp2_ = boxes_welcome_tutorial_new (self);
		g_object_ref_sink (_tmp2_);
		_tmp3_ = _tmp2_;
		gtk_dialog_run ((GtkDialog*) _tmp3_);
		_g_object_unref0 (_tmp3_);
		_tmp4_ = boxes_app_window_get_first_run (self);
		_tmp5_ = _tmp4_;
		boxes_app_window_set_first_run (self, !_tmp5_);
	}
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

static inline void
_g_slist_free__g_free0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_free0_);
}

void
boxes_app_window_show_send_file (BoxesAppWindow* self)
{
	GtkFileChooserDialog* dialog = NULL;
	GtkFileChooserDialog* _tmp0_;
	GtkFileChooserDialog* _tmp1_;
	GtkFileChooserDialog* _tmp2_;
	GtkFileChooserDialog* _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_ ("Select files to transfer"), (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_OPEN, _ ("_Cancel"), GTK_RESPONSE_CANCEL, _ ("_Open"), GTK_RESPONSE_ACCEPT, NULL);
	g_object_ref_sink (_tmp0_);
	dialog = _tmp0_;
	_tmp1_ = dialog;
	gtk_file_chooser_set_select_multiple ((GtkFileChooser*) _tmp1_, TRUE);
	_tmp2_ = dialog;
	if (gtk_dialog_run ((GtkDialog*) _tmp2_) == ((gint) GTK_RESPONSE_ACCEPT)) {
		GSList* uris = NULL;
		GtkFileChooserDialog* _tmp3_;
		GSList* _tmp4_;
		GList* uris_param = NULL;
		GSList* _tmp5_;
		BoxesMachine* machine = NULL;
		BoxesCollectionItem* _tmp9_;
		BoxesCollectionItem* _tmp10_;
		BoxesMachine* _tmp11_;
		BoxesMachine* _tmp12_;
		BoxesDisplay* _tmp13_;
		BoxesDisplay* _tmp14_;
		GList* _tmp15_;
		_tmp3_ = dialog;
		_tmp4_ = gtk_file_chooser_get_uris ((GtkFileChooser*) _tmp3_);
		uris = _tmp4_;
		uris_param = NULL;
		_tmp5_ = uris;
		{
			GSList* uri_collection = NULL;
			GSList* uri_it = NULL;
			uri_collection = _tmp5_;
			for (uri_it = uri_collection; uri_it != NULL; uri_it = uri_it->next) {
				gchar* _tmp6_;
				gchar* uri = NULL;
				_tmp6_ = g_strdup ((const gchar*) uri_it->data);
				uri = _tmp6_;
				{
					const gchar* _tmp7_;
					gchar* _tmp8_;
					_tmp7_ = uri;
					_tmp8_ = g_strdup (_tmp7_);
					uris_param = g_list_append (uris_param, _tmp8_);
					_g_free0 (uri);
				}
			}
		}
		_tmp9_ = boxes_app_window_get_current_item (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = _g_object_ref0 (BOXES_IS_MACHINE (_tmp10_) ? ((BoxesMachine*) _tmp10_) : NULL);
		machine = _tmp11_;
		_tmp12_ = machine;
		_tmp13_ = boxes_machine_get_display (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = uris_param;
		boxes_display_transfer_files (_tmp14_, _tmp15_);
		_g_object_unref0 (machine);
		(uris_param == NULL) ? NULL : (uris_param = (_g_list_free__g_free0_ (uris_param), NULL));
		(uris == NULL) ? NULL : (uris = (_g_slist_free__g_free0_ (uris), NULL));
	}
	_tmp16_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp16_);
	_g_object_unref0 (dialog);
}

static void
__lambda42_ (BoxesAppWindow* self,
             const gchar* message)
{
	BoxesToast* _tmp0_;
	BoxesToast* _tmp1_;
	g_return_if_fail (message != NULL);
	_tmp0_ = boxes_toast_new (message);
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	boxes_app_window_display_toast (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
}

static void
___lambda42__boxes_machine_got_error (BoxesMachine* _sender,
                                      const gchar* message,
                                      gpointer self)
{
	__lambda42_ ((BoxesAppWindow*) self, message);
}

void
boxes_app_window_connect_to (BoxesAppWindow* self,
                             BoxesMachine* machine)
{
	AtkObject* a11y = NULL;
	AtkObject* _tmp0_;
	AtkObject* _tmp1_;
	AtkObject* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	BoxesTopbar* _tmp5_;
	GBinding* _tmp6_;
	GBinding* _tmp7_;
	gulong _tmp8_;
	BoxesUIState _tmp9_;
	BoxesUIState _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (machine != NULL);
	boxes_app_window_set_current_item (self, (BoxesCollectionItem*) machine);
	boxes_machine_set_window (machine, self);
	boxes_machine_unschedule_autosave (machine);
	_tmp0_ = gtk_widget_get_accessible ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	a11y = _tmp1_;
	_tmp2_ = a11y;
	_tmp3_ = boxes_collection_item_get_name ((BoxesCollectionItem*) machine);
	_tmp4_ = _tmp3_;
	g_object_set (_tmp2_, "accessible-name", _tmp4_, NULL);
	_tmp5_ = self->topbar;
	_tmp6_ = g_object_bind_property_with_closures ((GObject*) machine, "status", (GObject*) _tmp5_, "status", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (self->priv->status_bind);
	self->priv->status_bind = _tmp7_;
	_tmp8_ = g_signal_connect_object (machine, "got-error", (GCallback) ___lambda42__boxes_machine_got_error, self, 0);
	self->priv->got_error_id = _tmp8_;
	_tmp9_ = boxes_ui_get_ui_state ((BoxesUI*) self);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != BOXES_UI_STATE_CREDS) {
		boxes_ui_set_state ((BoxesUI*) self, BOXES_UI_STATE_CREDS);
	}
	_g_object_unref0 (a11y);
}

void
boxes_app_window_select_item (BoxesAppWindow* self,
                              BoxesCollectionItem* item)
{
	BoxesUIState _tmp0_;
	BoxesUIState _tmp1_;
	BoxesMachine* machine = NULL;
	BoxesMachine* _tmp2_;
	BoxesMachine* _tmp3_;
	BoxesAppWindow* _tmp4_;
	BoxesAppWindow* _tmp5_;
	BoxesApp* _tmp6_;
	BoxesAppWindow* _tmp7_;
	BoxesAppWindow* _tmp8_;
	BoxesCollectionItem* _tmp12_;
	BoxesCollectionItem* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = boxes_ui_get_ui_state ((BoxesUI*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != BOXES_UI_STATE_COLLECTION) {
		return;
	}
	g_return_if_fail (BOXES_IS_MACHINE (item));
	_tmp2_ = _g_object_ref0 (BOXES_IS_MACHINE (item) ? ((BoxesMachine*) item) : NULL);
	machine = _tmp2_;
	_tmp3_ = machine;
	_tmp4_ = boxes_machine_get_window (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = boxes_app_app;
	_tmp7_ = boxes_app_get_main_window (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp5_ != _tmp8_) {
		BoxesMachine* _tmp9_;
		BoxesAppWindow* _tmp10_;
		BoxesAppWindow* _tmp11_;
		_tmp9_ = machine;
		_tmp10_ = boxes_machine_get_window (_tmp9_);
		_tmp11_ = _tmp10_;
		gtk_window_present ((GtkWindow*) _tmp11_);
		_g_object_unref0 (machine);
		return;
	}
	boxes_app_window_set_current_item (self, item);
	_tmp12_ = boxes_app_window_get_current_item (self);
	_tmp13_ = _tmp12_;
	if (BOXES_IS_MACHINE (_tmp13_)) {
		BoxesMachine* _tmp14_;
		_tmp14_ = machine;
		boxes_app_window_connect_to (self, _tmp14_);
	} else {
		g_warning ("app-window.vala:333: unknown item, fix your code");
	}
	_g_object_unref0 (machine);
}

gboolean
boxes_app_window_on_key_pressed (BoxesAppWindow* self,
                                 GtkWidget* widget,
                                 GdkEventKey* event)
{
	GdkModifierType default_modifiers = 0U;
	GtkTextDirection direction = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	default_modifiers = gtk_accelerator_get_default_mod_mask ();
	direction = gtk_widget_get_direction ((GtkWidget*) self);
	if (event->keyval == GDK_KEY_F11) {
		gboolean _tmp0_;
		gboolean _tmp1_;
		_tmp0_ = boxes_app_window_get_fullscreened (self);
		_tmp1_ = _tmp0_;
		boxes_app_window_set_fullscreened (self, !_tmp1_);
		result = TRUE;
		return result;
	} else {
		if (event->keyval == GDK_KEY_F1) {
			BoxesApp* _tmp2_;
			_tmp2_ = boxes_app_app;
			g_action_group_activate_action ((GActionGroup*) _tmp2_, "help", NULL);
			result = TRUE;
			return result;
		} else {
			if (event->keyval == GDK_KEY_F10) {
				BoxesTopbar* _tmp3_;
				_tmp3_ = self->topbar;
				boxes_topbar_pop_main_menu (_tmp3_);
				result = TRUE;
				return result;
			} else {
				gboolean _tmp4_ = FALSE;
				if (event->keyval == GDK_KEY_q) {
					_tmp4_ = (event->state & default_modifiers) == GDK_CONTROL_MASK;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					BoxesUIState _tmp5_;
					BoxesUIState _tmp6_;
					BoxesApp* _tmp7_;
					_tmp5_ = boxes_ui_get_ui_state ((BoxesUI*) self);
					_tmp6_ = _tmp5_;
					if (_tmp6_ == BOXES_UI_STATE_DISPLAY) {
						result = FALSE;
						return result;
					}
					_tmp7_ = boxes_app_app;
					boxes_app_quit_app (_tmp7_);
					result = TRUE;
					return result;
				} else {
					gboolean _tmp8_ = FALSE;
					if (event->keyval == GDK_KEY_n) {
						_tmp8_ = (event->state & default_modifiers) == GDK_CONTROL_MASK;
					} else {
						_tmp8_ = FALSE;
					}
					if (_tmp8_) {
						boxes_app_window_show_vm_assistant (self, NULL);
						result = TRUE;
						return result;
					} else {
						gboolean _tmp9_ = FALSE;
						if (event->keyval == GDK_KEY_f) {
							_tmp9_ = (event->state & default_modifiers) == GDK_CONTROL_MASK;
						} else {
							_tmp9_ = FALSE;
						}
						if (_tmp9_) {
							BoxesTopbar* _tmp10_;
							_tmp10_ = self->topbar;
							boxes_topbar_click_search_button (_tmp10_);
							result = TRUE;
							return result;
						} else {
							gboolean _tmp11_ = FALSE;
							gboolean _tmp12_ = FALSE;
							gboolean _tmp13_ = FALSE;
							if (direction == GTK_TEXT_DIR_LTR) {
								_tmp13_ = event->keyval == GDK_KEY_Left;
							} else {
								_tmp13_ = FALSE;
							}
							if (_tmp13_) {
								_tmp12_ = TRUE;
							} else {
								gboolean _tmp14_ = FALSE;
								if (direction == GTK_TEXT_DIR_RTL) {
									_tmp14_ = event->keyval == GDK_KEY_Right;
								} else {
									_tmp14_ = FALSE;
								}
								_tmp12_ = _tmp14_;
							}
							if (_tmp12_) {
								_tmp11_ = (event->state & default_modifiers) == GDK_MOD1_MASK;
							} else {
								_tmp11_ = FALSE;
							}
							if (_tmp11_) {
								BoxesTopbar* _tmp15_;
								_tmp15_ = self->topbar;
								boxes_topbar_click_back_button (_tmp15_);
								result = TRUE;
								return result;
							}
						}
					}
				}
			}
		}
	}
	result = FALSE;
	return result;
}

static gboolean
_boxes_app_window_on_key_pressed_gtk_widget_key_press_event (GtkWidget* _sender,
                                                             GdkEventKey* event,
                                                             gpointer self)
{
	gboolean result;
	result = boxes_app_window_on_key_pressed ((BoxesAppWindow*) self, _sender, event);
	return result;
}

static gboolean
__lambda136_ (BoxesAppWindow* self)
{
	gboolean result;
	self->priv->configure_id = (guint) 0;
	boxes_app_window_save_window_geometry (self);
	result = FALSE;
	return result;
}

static gboolean
___lambda136__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda136_ ((BoxesAppWindow*) self);
	return result;
}

static gboolean
boxes_app_window_on_configure_event (BoxesAppWindow* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = boxes_app_window_get_fullscreened (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	if (self->priv->configure_id != ((guint) 0)) {
		g_source_remove (self->priv->configure_id);
	}
	self->priv->configure_id = g_timeout_add_full (G_PRIORITY_DEFAULT, BOXES_APP_WINDOW_configure_id_timeout, ___lambda136__gsource_func, g_object_ref (self), g_object_unref);
	result = FALSE;
	return result;
}

static gboolean
_boxes_app_window_on_configure_event_gtk_widget_configure_event (GtkWidget* _sender,
                                                                 GdkEventConfigure* event,
                                                                 gpointer self)
{
	gboolean result;
	result = boxes_app_window_on_configure_event ((BoxesAppWindow*) self);
	return result;
}

static gboolean
boxes_app_window_on_window_state_event (BoxesAppWindow* self,
                                        GdkEventWindowState* event)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	GSettings* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if ((event->changed_mask & GDK_WINDOW_STATE_FULLSCREEN) == GDK_WINDOW_STATE_FULLSCREEN) {
		g_object_notify ((GObject*) self, "fullscreened");
	}
	_tmp0_ = boxes_app_window_get_fullscreened (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->settings;
	_tmp3_ = boxes_app_window_get_maximized (self);
	_tmp4_ = _tmp3_;
	g_settings_set_boolean (_tmp2_, "window-maximized", _tmp4_);
	result = FALSE;
	return result;
}

static gboolean
_boxes_app_window_on_window_state_event_gtk_widget_window_state_event (GtkWidget* _sender,
                                                                       GdkEventWindowState* event,
                                                                       gpointer self)
{
	gboolean result;
	result = boxes_app_window_on_window_state_event ((BoxesAppWindow*) self, event);
	return result;
}

static gboolean
boxes_app_window_on_delete_event (BoxesAppWindow* self)
{
	gboolean _tmp0_ = FALSE;
	BoxesCollectionItem* _tmp1_;
	BoxesCollectionItem* _tmp2_;
	BoxesCollectionItem* _tmp5_;
	BoxesCollectionItem* _tmp6_;
	BoxesApp* _tmp14_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = boxes_app_window_get_current_item (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		BoxesCollectionItem* _tmp3_;
		BoxesCollectionItem* _tmp4_;
		_tmp3_ = boxes_app_window_get_current_item (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = BOXES_IS_MACHINE (_tmp4_);
	}
	g_return_val_if_fail (_tmp0_, FALSE);
	_tmp5_ = boxes_app_window_get_current_item (self);
	_tmp6_ = _tmp5_;
	if (_tmp6_ != NULL) {
		BoxesMachine* machine = NULL;
		BoxesCollectionItem* _tmp7_;
		BoxesCollectionItem* _tmp8_;
		BoxesMachine* _tmp9_;
		BoxesMachine* _tmp10_;
		BoxesMachine* _tmp11_;
		BoxesMachine* _tmp12_;
		BoxesMachine* _tmp13_;
		_tmp7_ = boxes_app_window_get_current_item (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = _g_object_ref0 (BOXES_IS_MACHINE (_tmp8_) ? ((BoxesMachine*) _tmp8_) : NULL);
		machine = _tmp9_;
		_tmp10_ = machine;
		boxes_machine_set_window (_tmp10_, NULL);
		_tmp11_ = machine;
		boxes_machine_schedule_autosave (_tmp11_);
		_tmp12_ = machine;
		g_signal_handler_disconnect ((GObject*) _tmp12_, self->priv->machine_state_notify_id);
		self->priv->machine_state_notify_id = (gulong) 0;
		_tmp13_ = machine;
		g_signal_handler_disconnect ((GObject*) _tmp13_, self->priv->machine_deleted_notify_id);
		self->priv->machine_deleted_notify_id = (gulong) 0;
		_g_object_unref0 (machine);
	}
	_tmp14_ = boxes_app_app;
	result = boxes_app_remove_window (_tmp14_, self);
	return result;
}

static gboolean
_boxes_app_window_on_delete_event_gtk_widget_delete_event (GtkWidget* _sender,
                                                           GdkEventAny* event,
                                                           gpointer self)
{
	gboolean result;
	result = boxes_app_window_on_delete_event ((BoxesAppWindow*) self);
	return result;
}

static void
boxes_app_window_on_machine_state_notify (BoxesAppWindow* self)
{
	BoxesMachine* current_machine = NULL;
	BoxesCollectionItem* _tmp0_;
	BoxesCollectionItem* _tmp1_;
	BoxesMachine* _tmp2_;
	gboolean _tmp3_ = FALSE;
	BoxesApp* _tmp4_;
	BoxesAppWindow* _tmp5_;
	BoxesAppWindow* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = boxes_app_window_get_current_item (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (BOXES_IS_MACHINE (_tmp1_) ? ((BoxesMachine*) _tmp1_) : NULL);
	current_machine = _tmp2_;
	_tmp4_ = boxes_app_app;
	_tmp5_ = boxes_app_get_main_window (_tmp4_);
	_tmp6_ = _tmp5_;
	if (self != _tmp6_) {
		BoxesMachine* _tmp7_;
		BoxesMachineMachineState _tmp8_;
		BoxesMachineMachineState _tmp9_;
		_tmp7_ = current_machine;
		_tmp8_ = boxes_machine_get_state (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp3_ = _tmp9_ != BOXES_MACHINE_MACHINE_STATE_RUNNING;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		boxes_app_window_on_delete_event (self);
	}
	_g_object_unref0 (current_machine);
}

static void
boxes_app_window_on_machine_deleted_notify (BoxesAppWindow* self)
{
	BoxesMachine* current_machine = NULL;
	BoxesCollectionItem* _tmp0_;
	BoxesCollectionItem* _tmp1_;
	BoxesMachine* _tmp2_;
	gboolean _tmp3_ = FALSE;
	BoxesApp* _tmp4_;
	BoxesAppWindow* _tmp5_;
	BoxesAppWindow* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = boxes_app_window_get_current_item (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (BOXES_IS_MACHINE (_tmp1_) ? ((BoxesMachine*) _tmp1_) : NULL);
	current_machine = _tmp2_;
	_tmp4_ = boxes_app_app;
	_tmp5_ = boxes_app_get_main_window (_tmp4_);
	_tmp6_ = _tmp5_;
	if (self != _tmp6_) {
		BoxesMachine* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp7_ = current_machine;
		_tmp8_ = boxes_machine_get_deleted (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp3_ = _tmp9_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		boxes_app_window_on_delete_event (self);
	}
	_g_object_unref0 (current_machine);
}

static BoxesUIState
boxes_app_window_real_get_previous_ui_state (BoxesUI* base)
{
	BoxesUIState result;
	BoxesAppWindow* self;
	self = (BoxesAppWindow*) base;
	result = self->priv->_previous_ui_state;
	return result;
}

static void
boxes_app_window_real_set_previous_ui_state (BoxesUI* base,
                                             BoxesUIState value)
{
	BoxesAppWindow* self;
	BoxesUIState old_value;
	self = (BoxesAppWindow*) base;
	old_value = boxes_app_window_real_get_previous_ui_state (base);
	if (old_value != value) {
		self->priv->_previous_ui_state = value;
		g_object_notify_by_pspec ((GObject *) self, boxes_app_window_properties[BOXES_APP_WINDOW_PREVIOUS_UI_STATE_PROPERTY]);
	}
}

static BoxesUIState
boxes_app_window_real_get_ui_state (BoxesUI* base)
{
	BoxesUIState result;
	BoxesAppWindow* self;
	self = (BoxesAppWindow*) base;
	result = self->priv->_ui_state;
	return result;
}

static void
boxes_app_window_real_set_ui_state (BoxesUI* base,
                                    BoxesUIState value)
{
	BoxesAppWindow* self;
	BoxesUIState old_value;
	self = (BoxesAppWindow*) base;
	old_value = boxes_app_window_real_get_ui_state (base);
	if (old_value != value) {
		self->priv->_ui_state = value;
		g_object_notify_by_pspec ((GObject *) self, boxes_app_window_properties[BOXES_APP_WINDOW_UI_STATE_PROPERTY]);
	}
}

BoxesCollectionItem*
boxes_app_window_get_current_item (BoxesAppWindow* self)
{
	BoxesCollectionItem* result;
	BoxesCollectionItem* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_item;
	result = _tmp0_;
	return result;
}

static void
_boxes_app_window_on_machine_state_notify_g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self)
{
	boxes_app_window_on_machine_state_notify ((BoxesAppWindow*) self);
}

static void
_boxes_app_window_on_machine_deleted_notify_g_object_notify (GObject* _sender,
                                                             GParamSpec* pspec,
                                                             gpointer self)
{
	boxes_app_window_on_machine_deleted_notify ((BoxesAppWindow*) self);
}

void
boxes_app_window_set_current_item (BoxesAppWindow* self,
                                   BoxesCollectionItem* value)
{
	BoxesCollectionItem* _tmp0_;
	BoxesCollectionItem* _tmp3_;
	BoxesCollectionItem* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_current_item;
	if (_tmp0_ != NULL) {
		BoxesCollectionItem* _tmp1_;
		BoxesCollectionItem* _tmp2_;
		_tmp1_ = self->priv->_current_item;
		g_signal_handler_disconnect ((GObject*) _tmp1_, self->priv->machine_state_notify_id);
		_tmp2_ = self->priv->_current_item;
		g_signal_handler_disconnect ((GObject*) _tmp2_, self->priv->machine_deleted_notify_id);
		self->priv->machine_state_notify_id = (gulong) 0;
		self->priv->machine_deleted_notify_id = (gulong) 0;
	}
	_tmp3_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_current_item);
	self->priv->_current_item = _tmp3_;
	_tmp4_ = self->priv->_current_item;
	if (_tmp4_ != NULL) {
		BoxesMachine* machine = NULL;
		BoxesCollectionItem* _tmp5_;
		BoxesMachine* _tmp6_;
		BoxesMachine* _tmp7_;
		gulong _tmp8_;
		BoxesMachine* _tmp9_;
		gulong _tmp10_;
		_tmp5_ = self->priv->_current_item;
		_tmp6_ = _g_object_ref0 (BOXES_IS_MACHINE (_tmp5_) ? ((BoxesMachine*) _tmp5_) : NULL);
		machine = _tmp6_;
		_tmp7_ = machine;
		_tmp8_ = g_signal_connect_object ((GObject*) _tmp7_, "notify::state", (GCallback) _boxes_app_window_on_machine_state_notify_g_object_notify, self, 0);
		self->priv->machine_state_notify_id = _tmp8_;
		_tmp9_ = machine;
		_tmp10_ = g_signal_connect_object ((GObject*) _tmp9_, "notify::deleted", (GCallback) _boxes_app_window_on_machine_deleted_notify_g_object_notify, self, 0);
		self->priv->machine_deleted_notify_id = _tmp10_;
		_g_object_unref0 (machine);
	}
	g_object_notify_by_pspec ((GObject *) self, boxes_app_window_properties[BOXES_APP_WINDOW_CURRENT_ITEM_PROPERTY]);
}

gboolean
boxes_app_window_get_fullscreened (BoxesAppWindow* self)
{
	gboolean result;
	GdkWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	result = (gdk_window_get_state (_tmp0_) & GDK_WINDOW_STATE_FULLSCREEN) == GDK_WINDOW_STATE_FULLSCREEN;
	return result;
}

void
boxes_app_window_set_fullscreened (BoxesAppWindow* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	if (value) {
		gtk_window_fullscreen ((GtkWindow*) self);
	} else {
		gtk_window_unfullscreen ((GtkWindow*) self);
	}
}

static gboolean
boxes_app_window_get_maximized (BoxesAppWindow* self)
{
	gboolean result;
	GdkWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	result = (gdk_window_get_state (_tmp0_) & GDK_WINDOW_STATE_MAXIMIZED) == GDK_WINDOW_STATE_MAXIMIZED;
	return result;
}

BoxesAppWindowViewType
boxes_app_window_get_view_type (BoxesAppWindow* self)
{
	BoxesAppWindowViewType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_view_type;
	return result;
}

void
boxes_app_window_set_view_type (BoxesAppWindow* self,
                                BoxesAppWindowViewType value)
{
	BoxesAppWindowViewType old_value;
	g_return_if_fail (self != NULL);
	old_value = boxes_app_window_get_view_type (self);
	if (old_value != value) {
		self->priv->_view_type = value;
		g_object_notify_by_pspec ((GObject *) self, boxes_app_window_properties[BOXES_APP_WINDOW_VIEW_TYPE_PROPERTY]);
	}
}

GtkWidget*
boxes_app_window_get_view (BoxesAppWindow* self)
{
	GtkWidget* result;
	BoxesAppWindowViewType _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_view_type;
	switch (_tmp0_) {
		default:
		case BOXES_APP_WINDOW_VIEW_TYPE_ICON:
		{
			BoxesIconView* _tmp1_;
			_tmp1_ = self->priv->icon_view;
			result = (GtkWidget*) _tmp1_;
			return result;
		}
		case BOXES_APP_WINDOW_VIEW_TYPE_LIST:
		{
			BoxesListView* _tmp2_;
			_tmp2_ = self->priv->list_view;
			result = (GtkWidget*) _tmp2_;
			return result;
		}
	}
}

gboolean
boxes_app_window_get_first_run (BoxesAppWindow* self)
{
	gboolean result;
	GSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->settings;
	result = g_settings_get_boolean (_tmp0_, "first-run");
	return result;
}

void
boxes_app_window_set_first_run (BoxesAppWindow* self,
                                gboolean value)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->settings;
	g_settings_set_boolean (_tmp0_, "first-run", value);
	g_object_notify_by_pspec ((GObject *) self, boxes_app_window_properties[BOXES_APP_WINDOW_FIRST_RUN_PROPERTY]);
}

static void
boxes_app_window_class_init (BoxesAppWindowClass * klass,
                             gpointer klass_data)
{
	boxes_app_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BoxesAppWindow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_boxes_app_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_boxes_app_window_set_property;
	G_OBJECT_CLASS (klass)->finalize = boxes_app_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_APP_WINDOW_PREVIOUS_UI_STATE_PROPERTY, boxes_app_window_properties[BOXES_APP_WINDOW_PREVIOUS_UI_STATE_PROPERTY] = g_param_spec_enum ("previous-ui-state", "previous-ui-state", "previous-ui-state", BOXES_TYPE_UI_STATE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_APP_WINDOW_UI_STATE_PROPERTY, boxes_app_window_properties[BOXES_APP_WINDOW_UI_STATE_PROPERTY] = g_param_spec_enum ("ui-state", "ui-state", "ui-state", BOXES_TYPE_UI_STATE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_APP_WINDOW_CURRENT_ITEM_PROPERTY, boxes_app_window_properties[BOXES_APP_WINDOW_CURRENT_ITEM_PROPERTY] = g_param_spec_object ("current-item", "current-item", "current-item", BOXES_TYPE_COLLECTION_ITEM, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_APP_WINDOW_FULLSCREENED_PROPERTY, boxes_app_window_properties[BOXES_APP_WINDOW_FULLSCREENED_PROPERTY] = g_param_spec_boolean ("fullscreened", "fullscreened", "fullscreened", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_APP_WINDOW_VIEW_TYPE_PROPERTY, boxes_app_window_properties[BOXES_APP_WINDOW_VIEW_TYPE_PROPERTY] = g_param_spec_enum ("view-type", "view-type", "view-type", BOXES_APP_WINDOW_TYPE_VIEW_TYPE, BOXES_APP_WINDOW_VIEW_TYPE_ICON, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_APP_WINDOW_VIEW_PROPERTY, boxes_app_window_properties[BOXES_APP_WINDOW_VIEW_PROPERTY] = g_param_spec_object ("view", "view", "view", gtk_widget_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_APP_WINDOW_FIRST_RUN_PROPERTY, boxes_app_window_properties[BOXES_APP_WINDOW_FIRST_RUN_PROPERTY] = g_param_spec_boolean ("first-run", "first-run", "first-run", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Boxes/ui/app-window.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "searchbar", FALSE, G_STRUCT_OFFSET (BoxesAppWindow, searchbar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "topbar", FALSE, G_STRUCT_OFFSET (BoxesAppWindow, topbar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "toast_overlay", FALSE, G_STRUCT_OFFSET (BoxesAppWindow, toast_overlay));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "display_page", FALSE, G_STRUCT_OFFSET (BoxesAppWindow, display_page));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "empty_boxes", FALSE, G_STRUCT_OFFSET (BoxesAppWindow, empty_boxes));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "troubleshoot_view", FALSE, G_STRUCT_OFFSET (BoxesAppWindow, troubleshoot_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "below_bin", FALSE, G_STRUCT_OFFSET (BoxesAppWindow, below_bin));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "icon_view", FALSE, BoxesAppWindow_private_offset + G_STRUCT_OFFSET (BoxesAppWindowPrivate, icon_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "list_view", FALSE, BoxesAppWindow_private_offset + G_STRUCT_OFFSET (BoxesAppWindowPrivate, list_view));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_key_pressed", G_CALLBACK(_boxes_app_window_on_key_pressed_gtk_widget_key_press_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_configure_event", G_CALLBACK(_boxes_app_window_on_configure_event_gtk_widget_configure_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_window_state_event", G_CALLBACK(_boxes_app_window_on_window_state_event_gtk_widget_window_state_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_delete_event", G_CALLBACK(_boxes_app_window_on_delete_event_gtk_widget_delete_event));
}

static void
boxes_app_window_boxes_ui_interface_init (BoxesUIIface * iface,
                                          gpointer iface_data)
{
	boxes_app_window_boxes_ui_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_previous_ui_state = boxes_app_window_real_get_previous_ui_state;
	iface->set_previous_ui_state = boxes_app_window_real_set_previous_ui_state;
	iface->get_ui_state = boxes_app_window_real_get_ui_state;
	iface->set_ui_state = boxes_app_window_real_set_ui_state;
}

static void
boxes_app_window_instance_init (BoxesAppWindow * self,
                                gpointer klass)
{
	self->priv = boxes_app_window_get_instance_private (self);
	self->priv->_view_type = BOXES_APP_WINDOW_VIEW_TYPE_ICON;
	g_type_ensure (BOXES_TYPE_SEARCHBAR);
	g_type_ensure (BOXES_TYPE_TOPBAR);
	g_type_ensure (BOXES_TYPE_TOAST_OVERLAY);
	g_type_ensure (BOXES_TYPE_DISPLAY_PAGE);
	g_type_ensure (BOXES_TYPE_TROUBLESHOOT_VIEW);
	g_type_ensure (BOXES_TYPE_ICON_VIEW);
	g_type_ensure (BOXES_TYPE_LIST_VIEW);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
boxes_app_window_finalize (GObject * obj)
{
	BoxesAppWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_APP_WINDOW, BoxesAppWindow);
	_g_object_unref0 (self->priv->_current_item);
	_g_object_unref0 (self->priv->status_bind);
	_g_object_unref0 (self->settings);
	_g_object_unref0 (self->priv->group);
	G_OBJECT_CLASS (boxes_app_window_parent_class)->finalize (obj);
}

static GType
boxes_app_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BoxesAppWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_app_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesAppWindow), 0, (GInstanceInitFunc) boxes_app_window_instance_init, NULL };
	static const GInterfaceInfo boxes_ui_info = { (GInterfaceInitFunc) boxes_app_window_boxes_ui_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType boxes_app_window_type_id;
	boxes_app_window_type_id = g_type_register_static (hdy_application_window_get_type (), "BoxesAppWindow", &g_define_type_info, 0);
	g_type_add_interface_static (boxes_app_window_type_id, BOXES_TYPE_UI, &boxes_ui_info);
	BoxesAppWindow_private_offset = g_type_add_instance_private (boxes_app_window_type_id, sizeof (BoxesAppWindowPrivate));
	return boxes_app_window_type_id;
}

GType
boxes_app_window_get_type (void)
{
	static volatile gsize boxes_app_window_type_id__once = 0;
	if (g_once_init_enter (&boxes_app_window_type_id__once)) {
		GType boxes_app_window_type_id;
		boxes_app_window_type_id = boxes_app_window_get_type_once ();
		g_once_init_leave (&boxes_app_window_type_id__once, boxes_app_window_type_id);
	}
	return boxes_app_window_type_id__once;
}

static void
_vala_boxes_app_window_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	BoxesAppWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_APP_WINDOW, BoxesAppWindow);
	switch (property_id) {
		case BOXES_APP_WINDOW_PREVIOUS_UI_STATE_PROPERTY:
		g_value_set_enum (value, boxes_ui_get_previous_ui_state ((BoxesUI*) self));
		break;
		case BOXES_APP_WINDOW_UI_STATE_PROPERTY:
		g_value_set_enum (value, boxes_ui_get_ui_state ((BoxesUI*) self));
		break;
		case BOXES_APP_WINDOW_CURRENT_ITEM_PROPERTY:
		g_value_set_object (value, boxes_app_window_get_current_item (self));
		break;
		case BOXES_APP_WINDOW_FULLSCREENED_PROPERTY:
		g_value_set_boolean (value, boxes_app_window_get_fullscreened (self));
		break;
		case BOXES_APP_WINDOW_VIEW_TYPE_PROPERTY:
		g_value_set_enum (value, boxes_app_window_get_view_type (self));
		break;
		case BOXES_APP_WINDOW_VIEW_PROPERTY:
		g_value_set_object (value, boxes_app_window_get_view (self));
		break;
		case BOXES_APP_WINDOW_FIRST_RUN_PROPERTY:
		g_value_set_boolean (value, boxes_app_window_get_first_run (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_boxes_app_window_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	BoxesAppWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_APP_WINDOW, BoxesAppWindow);
	switch (property_id) {
		case BOXES_APP_WINDOW_PREVIOUS_UI_STATE_PROPERTY:
		boxes_ui_set_previous_ui_state ((BoxesUI*) self, g_value_get_enum (value));
		break;
		case BOXES_APP_WINDOW_UI_STATE_PROPERTY:
		boxes_ui_set_ui_state ((BoxesUI*) self, g_value_get_enum (value));
		break;
		case BOXES_APP_WINDOW_CURRENT_ITEM_PROPERTY:
		boxes_app_window_set_current_item (self, g_value_get_object (value));
		break;
		case BOXES_APP_WINDOW_FULLSCREENED_PROPERTY:
		boxes_app_window_set_fullscreened (self, g_value_get_boolean (value));
		break;
		case BOXES_APP_WINDOW_VIEW_TYPE_PROPERTY:
		boxes_app_window_set_view_type (self, g_value_get_enum (value));
		break;
		case BOXES_APP_WINDOW_FIRST_RUN_PROPERTY:
		boxes_app_window_set_first_run (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

