/* Generated by wayland-scanner 1.24.0 */

#ifndef GODOT_EMBEDDING_COMPOSITOR_CLIENT_PROTOCOL_H
#define GODOT_EMBEDDING_COMPOSITOR_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "../dynwrappers/wayland-client-core-so_wrap.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_godot_embedding_compositor The godot_embedding_compositor protocol
 * @section page_ifaces_godot_embedding_compositor Interfaces
 * - @subpage page_iface_godot_embedding_compositor - Main control interface for embedding compositor
 * - @subpage page_iface_godot_embedded_client - A client connected to the embedded compositor.
 * @section page_copyright_godot_embedding_compositor Copyright
 * <pre>
 *
 * Copyright (c) 2014-present Godot Engine contributors (see AUTHORS.md).
 * Copyright (c) 2007-2014 Juan Linietsky, Ariel Manzur.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 * </pre>
 */
struct godot_embedded_client;
struct godot_embedding_compositor;
struct xdg_toplevel;

#ifndef GODOT_EMBEDDING_COMPOSITOR_INTERFACE
#define GODOT_EMBEDDING_COMPOSITOR_INTERFACE
/**
 * @page page_iface_godot_embedding_compositor godot_embedding_compositor
 * @section page_iface_godot_embedding_compositor_desc Description
 * @section page_iface_godot_embedding_compositor_api API
 * See @ref iface_godot_embedding_compositor.
 */
/**
 * @defgroup iface_godot_embedding_compositor The godot_embedding_compositor interface
 */
extern const struct wl_interface godot_embedding_compositor_interface;
#endif
#ifndef GODOT_EMBEDDED_CLIENT_INTERFACE
#define GODOT_EMBEDDED_CLIENT_INTERFACE
/**
 * @page page_iface_godot_embedded_client godot_embedded_client
 * @section page_iface_godot_embedded_client_desc Description
 *
 * Clients have only a single embedded window at a time, subject to change.
 * @section page_iface_godot_embedded_client_api API
 * See @ref iface_godot_embedded_client.
 */
/**
 * @defgroup iface_godot_embedded_client The godot_embedded_client interface
 *
 * Clients have only a single embedded window at a time, subject to change.
 */
extern const struct wl_interface godot_embedded_client_interface;
#endif

/**
 * @ingroup iface_godot_embedding_compositor
 * @struct godot_embedding_compositor_listener
 */
struct godot_embedding_compositor_listener {
	/**
	 * A new client connected to the compositor
	 *
	 * 
	 */
	void (*client)(void *data,
		       struct godot_embedding_compositor *godot_embedding_compositor,
		       struct godot_embedded_client *client,
		       int32_t pid);
};

/**
 * @ingroup iface_godot_embedding_compositor
 */
static inline int
godot_embedding_compositor_add_listener(struct godot_embedding_compositor *godot_embedding_compositor,
					const struct godot_embedding_compositor_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) godot_embedding_compositor,
				     (void (**)(void)) listener, data);
}

/**
 * @ingroup iface_godot_embedding_compositor
 */
#define GODOT_EMBEDDING_COMPOSITOR_CLIENT_SINCE_VERSION 1


/** @ingroup iface_godot_embedding_compositor */
static inline void
godot_embedding_compositor_set_user_data(struct godot_embedding_compositor *godot_embedding_compositor, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) godot_embedding_compositor, user_data);
}

/** @ingroup iface_godot_embedding_compositor */
static inline void *
godot_embedding_compositor_get_user_data(struct godot_embedding_compositor *godot_embedding_compositor)
{
	return wl_proxy_get_user_data((struct wl_proxy *) godot_embedding_compositor);
}

static inline uint32_t
godot_embedding_compositor_get_version(struct godot_embedding_compositor *godot_embedding_compositor)
{
	return wl_proxy_get_version((struct wl_proxy *) godot_embedding_compositor);
}

/** @ingroup iface_godot_embedding_compositor */
static inline void
godot_embedding_compositor_destroy(struct godot_embedding_compositor *godot_embedding_compositor)
{
	wl_proxy_destroy((struct wl_proxy *) godot_embedding_compositor);
}

/**
 * @ingroup iface_godot_embedded_client
 * @struct godot_embedded_client_listener
 */
struct godot_embedded_client_listener {
	/**
	 * The client got disconnected from the compositor
	 *
	 * This instance is no longer valid. The compositor shall ignore
	 * any further request except destroy and stop emitting events for
	 * this object. After this event, the client can safely destroy
	 * this object.
	 */
	void (*disconnected)(void *data,
			     struct godot_embedded_client *godot_embedded_client);
	/**
	 */
	void (*window_embedded)(void *data,
				struct godot_embedded_client *godot_embedded_client);
	/**
	 */
	void (*window_focus_in)(void *data,
				struct godot_embedded_client *godot_embedded_client);
	/**
	 */
	void (*window_focus_out)(void *data,
				 struct godot_embedded_client *godot_embedded_client);
};

/**
 * @ingroup iface_godot_embedded_client
 */
static inline int
godot_embedded_client_add_listener(struct godot_embedded_client *godot_embedded_client,
				   const struct godot_embedded_client_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) godot_embedded_client,
				     (void (**)(void)) listener, data);
}

#define GODOT_EMBEDDED_CLIENT_DESTROY 0
#define GODOT_EMBEDDED_CLIENT_SET_EMBEDDED_WINDOW_RECT 1
#define GODOT_EMBEDDED_CLIENT_SET_EMBEDDED_WINDOW_PARENT 2
#define GODOT_EMBEDDED_CLIENT_FOCUS_WINDOW 3
#define GODOT_EMBEDDED_CLIENT_EMBEDDED_WINDOW_REQUEST_CLOSE 4

/**
 * @ingroup iface_godot_embedded_client
 */
#define GODOT_EMBEDDED_CLIENT_DISCONNECTED_SINCE_VERSION 1
/**
 * @ingroup iface_godot_embedded_client
 */
#define GODOT_EMBEDDED_CLIENT_WINDOW_EMBEDDED_SINCE_VERSION 1
/**
 * @ingroup iface_godot_embedded_client
 */
#define GODOT_EMBEDDED_CLIENT_WINDOW_FOCUS_IN_SINCE_VERSION 1
/**
 * @ingroup iface_godot_embedded_client
 */
#define GODOT_EMBEDDED_CLIENT_WINDOW_FOCUS_OUT_SINCE_VERSION 1

/**
 * @ingroup iface_godot_embedded_client
 */
#define GODOT_EMBEDDED_CLIENT_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_godot_embedded_client
 */
#define GODOT_EMBEDDED_CLIENT_SET_EMBEDDED_WINDOW_RECT_SINCE_VERSION 1
/**
 * @ingroup iface_godot_embedded_client
 */
#define GODOT_EMBEDDED_CLIENT_SET_EMBEDDED_WINDOW_PARENT_SINCE_VERSION 1
/**
 * @ingroup iface_godot_embedded_client
 */
#define GODOT_EMBEDDED_CLIENT_FOCUS_WINDOW_SINCE_VERSION 1
/**
 * @ingroup iface_godot_embedded_client
 */
#define GODOT_EMBEDDED_CLIENT_EMBEDDED_WINDOW_REQUEST_CLOSE_SINCE_VERSION 1

/** @ingroup iface_godot_embedded_client */
static inline void
godot_embedded_client_set_user_data(struct godot_embedded_client *godot_embedded_client, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) godot_embedded_client, user_data);
}

/** @ingroup iface_godot_embedded_client */
static inline void *
godot_embedded_client_get_user_data(struct godot_embedded_client *godot_embedded_client)
{
	return wl_proxy_get_user_data((struct wl_proxy *) godot_embedded_client);
}

static inline uint32_t
godot_embedded_client_get_version(struct godot_embedded_client *godot_embedded_client)
{
	return wl_proxy_get_version((struct wl_proxy *) godot_embedded_client);
}

/**
 * @ingroup iface_godot_embedded_client
 */
static inline void
godot_embedded_client_destroy(struct godot_embedded_client *godot_embedded_client)
{
	wl_proxy_marshal_flags((struct wl_proxy *) godot_embedded_client,
			 GODOT_EMBEDDED_CLIENT_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) godot_embedded_client), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_godot_embedded_client
 */
static inline void
godot_embedded_client_set_embedded_window_rect(struct godot_embedded_client *godot_embedded_client, int32_t x, int32_t y, int32_t width, int32_t height)
{
	wl_proxy_marshal_flags((struct wl_proxy *) godot_embedded_client,
			 GODOT_EMBEDDED_CLIENT_SET_EMBEDDED_WINDOW_RECT, NULL, wl_proxy_get_version((struct wl_proxy *) godot_embedded_client), 0, x, y, width, height);
}

/**
 * @ingroup iface_godot_embedded_client
 */
static inline void
godot_embedded_client_set_embedded_window_parent(struct godot_embedded_client *godot_embedded_client, struct xdg_toplevel *parent)
{
	wl_proxy_marshal_flags((struct wl_proxy *) godot_embedded_client,
			 GODOT_EMBEDDED_CLIENT_SET_EMBEDDED_WINDOW_PARENT, NULL, wl_proxy_get_version((struct wl_proxy *) godot_embedded_client), 0, parent);
}

/**
 * @ingroup iface_godot_embedded_client
 */
static inline void
godot_embedded_client_focus_window(struct godot_embedded_client *godot_embedded_client)
{
	wl_proxy_marshal_flags((struct wl_proxy *) godot_embedded_client,
			 GODOT_EMBEDDED_CLIENT_FOCUS_WINDOW, NULL, wl_proxy_get_version((struct wl_proxy *) godot_embedded_client), 0);
}

/**
 * @ingroup iface_godot_embedded_client
 */
static inline void
godot_embedded_client_embedded_window_request_close(struct godot_embedded_client *godot_embedded_client)
{
	wl_proxy_marshal_flags((struct wl_proxy *) godot_embedded_client,
			 GODOT_EMBEDDED_CLIENT_EMBEDDED_WINDOW_REQUEST_CLOSE, NULL, wl_proxy_get_version((struct wl_proxy *) godot_embedded_client), 0);
}

#ifdef  __cplusplus
}
#endif

#endif
