//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by validation-gen. DO NOT EDIT.

package v1

import (
	context "context"
	fmt "fmt"

	storagev1 "k8s.io/api/storage/v1"
	equality "k8s.io/apimachinery/pkg/api/equality"
	operation "k8s.io/apimachinery/pkg/api/operation"
	safe "k8s.io/apimachinery/pkg/api/safe"
	validate "k8s.io/apimachinery/pkg/api/validate"
	runtime "k8s.io/apimachinery/pkg/runtime"
	field "k8s.io/apimachinery/pkg/util/validation/field"
)

func init() { localSchemeBuilder.Register(RegisterValidations) }

// RegisterValidations adds validation functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterValidations(scheme *runtime.Scheme) error {
	// type StorageClass
	scheme.AddValidationFunc((*storagev1.StorageClass)(nil), func(ctx context.Context, op operation.Operation, obj, oldObj interface{}) field.ErrorList {
		switch op.Request.SubresourcePath() {
		case "/":
			return Validate_StorageClass(ctx, op, nil /* fldPath */, obj.(*storagev1.StorageClass), safe.Cast[*storagev1.StorageClass](oldObj))
		}
		return field.ErrorList{field.InternalError(nil, fmt.Errorf("no validation found for %T, subresource: %v", obj, op.Request.SubresourcePath()))}
	})
	// type StorageClassList
	scheme.AddValidationFunc((*storagev1.StorageClassList)(nil), func(ctx context.Context, op operation.Operation, obj, oldObj interface{}) field.ErrorList {
		switch op.Request.SubresourcePath() {
		case "/":
			return Validate_StorageClassList(ctx, op, nil /* fldPath */, obj.(*storagev1.StorageClassList), safe.Cast[*storagev1.StorageClassList](oldObj))
		}
		return field.ErrorList{field.InternalError(nil, fmt.Errorf("no validation found for %T, subresource: %v", obj, op.Request.SubresourcePath()))}
	})
	return nil
}

// Validate_StorageClass validates an instance of StorageClass according
// to declarative validation rules in the API schema.
func Validate_StorageClass(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *storagev1.StorageClass) (errs field.ErrorList) {
	// field storagev1.StorageClass.TypeMeta has no validation
	// field storagev1.StorageClass.ObjectMeta has no validation

	// field storagev1.StorageClass.Provisioner
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *string, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.RequiredValue(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				errs = append(errs, e...)
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			return
		}(fldPath.Child("provisioner"), &obj.Provisioner, safe.Field(oldObj, func(oldObj *storagev1.StorageClass) *string { return &oldObj.Provisioner }), oldObj != nil)...)

	// field storagev1.StorageClass.Parameters has no validation
	// field storagev1.StorageClass.ReclaimPolicy has no validation
	// field storagev1.StorageClass.MountOptions has no validation
	// field storagev1.StorageClass.AllowVolumeExpansion has no validation
	// field storagev1.StorageClass.VolumeBindingMode has no validation
	// field storagev1.StorageClass.AllowedTopologies has no validation
	return errs
}

// Validate_StorageClassList validates an instance of StorageClassList according
// to declarative validation rules in the API schema.
func Validate_StorageClassList(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *storagev1.StorageClassList) (errs field.ErrorList) {
	// field storagev1.StorageClassList.TypeMeta has no validation
	// field storagev1.StorageClassList.ListMeta has no validation

	// field storagev1.StorageClassList.Items
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []storagev1.StorageClass, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// iterate the list and call the type's validation function
			errs = append(errs, validate.EachSliceVal(ctx, op, fldPath, obj, oldObj, nil, nil, Validate_StorageClass)...)
			return
		}(fldPath.Child("items"), obj.Items, safe.Field(oldObj, func(oldObj *storagev1.StorageClassList) []storagev1.StorageClass { return oldObj.Items }), oldObj != nil)...)

	return errs
}
