// Copyright (C) 2018 The Android Open Source Project
// Copyright (C) 2018 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Autogenerated module goldfish_vk_reserved_marshaling_guest
//
// (impl) generated by genvk.py
//
// Please do not modify directly;
// re-run mesa3d/src/gfxstream/codegen/generate-gfxstream-vulkan.sh,
// or directly from Python by defining:
// VULKAN_REGISTRY_XML_DIR : Directory containing vk.xml
// VULKAN_REGISTRY_SCRIPTS_DIR : Directory containing genvk.py
// CEREAL_OUTPUT_DIR: Where to put the generated sources.
//
// python3 $VULKAN_REGISTRY_SCRIPTS_DIR/genvk.py -registry $VULKAN_REGISTRY_XML_DIR/vk.xml cereal -o $CEREAL_OUTPUT_DIR
//

#include "goldfish_vk_reserved_marshaling_guest.h"
#include "goldfish_vk_extension_structs_guest.h"
#include "goldfish_vk_private_defs.h"

#include <cstring>

#include "Resources.h"

namespace gfxstream {
namespace vk {

void reservedmarshal_extension_struct(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const void* structExtension,
    uint8_t** ptr);

void reservedunmarshal_extension_struct(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    void* structExtension_out,
    uint8_t** ptr);

#ifdef VK_BASE_VERSION_1_0
void reservedmarshal_VkExtent2D(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExtent2D* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (uint32_t*)&forMarshaling->width, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->height, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkExtent3D(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExtent3D* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (uint32_t*)&forMarshaling->width, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->height, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->depth, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkOffset2D(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkOffset2D* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (int32_t*)&forMarshaling->x, sizeof(int32_t));
    *ptr += sizeof(int32_t);
    memcpy(*ptr, (int32_t*)&forMarshaling->y, sizeof(int32_t));
    *ptr += sizeof(int32_t);
}

void reservedmarshal_VkOffset3D(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkOffset3D* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (int32_t*)&forMarshaling->x, sizeof(int32_t));
    *ptr += sizeof(int32_t);
    memcpy(*ptr, (int32_t*)&forMarshaling->y, sizeof(int32_t));
    *ptr += sizeof(int32_t);
    memcpy(*ptr, (int32_t*)&forMarshaling->z, sizeof(int32_t));
    *ptr += sizeof(int32_t);
}

void reservedmarshal_VkRect2D(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRect2D* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    reservedmarshal_VkOffset2D(vkStream, rootType, (VkOffset2D*)(&forMarshaling->offset), ptr);
    reservedmarshal_VkExtent2D(vkStream, rootType, (VkExtent2D*)(&forMarshaling->extent), ptr);
}

void reservedmarshal_VkBaseInStructure(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBaseInStructure* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
}

void reservedmarshal_VkBaseOutStructure(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBaseOutStructure* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
}

void reservedmarshal_VkBufferMemoryBarrier(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferMemoryBarrier* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkAccessFlags*)&forMarshaling->srcAccessMask, sizeof(VkAccessFlags));
    *ptr += sizeof(VkAccessFlags);
    memcpy(*ptr, (VkAccessFlags*)&forMarshaling->dstAccessMask, sizeof(VkAccessFlags));
    *ptr += sizeof(VkAccessFlags);
    memcpy(*ptr, (uint32_t*)&forMarshaling->srcQueueFamilyIndex, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->dstQueueFamilyIndex, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkBuffer((*&forMarshaling->buffer));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->offset, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->size, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
}

void reservedmarshal_VkImageSubresourceRange(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageSubresourceRange* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkImageAspectFlags*)&forMarshaling->aspectMask, sizeof(VkImageAspectFlags));
    *ptr += sizeof(VkImageAspectFlags);
    memcpy(*ptr, (uint32_t*)&forMarshaling->baseMipLevel, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->levelCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->baseArrayLayer, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->layerCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkImageMemoryBarrier(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageMemoryBarrier* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkAccessFlags*)&forMarshaling->srcAccessMask, sizeof(VkAccessFlags));
    *ptr += sizeof(VkAccessFlags);
    memcpy(*ptr, (VkAccessFlags*)&forMarshaling->dstAccessMask, sizeof(VkAccessFlags));
    *ptr += sizeof(VkAccessFlags);
    memcpy(*ptr, (VkImageLayout*)&forMarshaling->oldLayout, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    memcpy(*ptr, (VkImageLayout*)&forMarshaling->newLayout, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    memcpy(*ptr, (uint32_t*)&forMarshaling->srcQueueFamilyIndex, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->dstQueueFamilyIndex, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkImage((*&forMarshaling->image));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    reservedmarshal_VkImageSubresourceRange(vkStream, rootType, (VkImageSubresourceRange*)(&forMarshaling->subresourceRange), ptr);
}

void reservedmarshal_VkMemoryBarrier(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryBarrier* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkAccessFlags*)&forMarshaling->srcAccessMask, sizeof(VkAccessFlags));
    *ptr += sizeof(VkAccessFlags);
    memcpy(*ptr, (VkAccessFlags*)&forMarshaling->dstAccessMask, sizeof(VkAccessFlags));
    *ptr += sizeof(VkAccessFlags);
}

void reservedmarshal_VkAllocationCallbacks(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkAllocationCallbacks* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pUserData;
    memcpy((*ptr), &cgen_var_0, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pUserData)
    {
        memcpy(*ptr, (void*)forMarshaling->pUserData, sizeof(uint8_t));
        *ptr += sizeof(uint8_t);
    }
    uint64_t cgen_var_1 = (uint64_t)forMarshaling->pfnAllocation;
    memcpy((*ptr), &cgen_var_1, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    uint64_t cgen_var_2 = (uint64_t)forMarshaling->pfnReallocation;
    memcpy((*ptr), &cgen_var_2, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    uint64_t cgen_var_3 = (uint64_t)forMarshaling->pfnFree;
    memcpy((*ptr), &cgen_var_3, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    uint64_t cgen_var_4 = (uint64_t)forMarshaling->pfnInternalAllocation;
    memcpy((*ptr), &cgen_var_4, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    uint64_t cgen_var_5 = (uint64_t)forMarshaling->pfnInternalFree;
    memcpy((*ptr), &cgen_var_5, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
}

void reservedmarshal_VkApplicationInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkApplicationInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    if (vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_NULL_OPTIONAL_STRINGS_BIT)
    {
        // WARNING PTR CHECK
        uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pApplicationName;
        memcpy((*ptr), &cgen_var_0, 8);
        gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
        *ptr += 8;
        if (forMarshaling->pApplicationName)
        {
            {
                uint32_t l = forMarshaling->pApplicationName ? strlen(forMarshaling->pApplicationName): 0;
                memcpy(*ptr, (uint32_t*)&l, sizeof(uint32_t));
                gfxstream::aemu::Stream::toBe32((uint8_t*)*ptr);
                *ptr += sizeof(uint32_t);
                memcpy(*ptr, (char*)forMarshaling->pApplicationName, l);
                *ptr += l;
            }
        }
    }
    else
    {
        {
            uint32_t l = forMarshaling->pApplicationName ? strlen(forMarshaling->pApplicationName): 0;
            memcpy(*ptr, (uint32_t*)&l, sizeof(uint32_t));
            gfxstream::aemu::Stream::toBe32((uint8_t*)*ptr);
            *ptr += sizeof(uint32_t);
            memcpy(*ptr, (char*)forMarshaling->pApplicationName, l);
            *ptr += l;
        }
    }
    memcpy(*ptr, (uint32_t*)&forMarshaling->applicationVersion, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    if (vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_NULL_OPTIONAL_STRINGS_BIT)
    {
        // WARNING PTR CHECK
        uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pEngineName;
        memcpy((*ptr), &cgen_var_0, 8);
        gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
        *ptr += 8;
        if (forMarshaling->pEngineName)
        {
            {
                uint32_t l = forMarshaling->pEngineName ? strlen(forMarshaling->pEngineName): 0;
                memcpy(*ptr, (uint32_t*)&l, sizeof(uint32_t));
                gfxstream::aemu::Stream::toBe32((uint8_t*)*ptr);
                *ptr += sizeof(uint32_t);
                memcpy(*ptr, (char*)forMarshaling->pEngineName, l);
                *ptr += l;
            }
        }
    }
    else
    {
        {
            uint32_t l = forMarshaling->pEngineName ? strlen(forMarshaling->pEngineName): 0;
            memcpy(*ptr, (uint32_t*)&l, sizeof(uint32_t));
            gfxstream::aemu::Stream::toBe32((uint8_t*)*ptr);
            *ptr += sizeof(uint32_t);
            memcpy(*ptr, (char*)forMarshaling->pEngineName, l);
            *ptr += l;
        }
    }
    memcpy(*ptr, (uint32_t*)&forMarshaling->engineVersion, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->apiVersion, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkFormatProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkFormatProperties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkFormatFeatureFlags*)&forMarshaling->linearTilingFeatures, sizeof(VkFormatFeatureFlags));
    *ptr += sizeof(VkFormatFeatureFlags);
    memcpy(*ptr, (VkFormatFeatureFlags*)&forMarshaling->optimalTilingFeatures, sizeof(VkFormatFeatureFlags));
    *ptr += sizeof(VkFormatFeatureFlags);
    memcpy(*ptr, (VkFormatFeatureFlags*)&forMarshaling->bufferFeatures, sizeof(VkFormatFeatureFlags));
    *ptr += sizeof(VkFormatFeatureFlags);
}

void reservedmarshal_VkImageFormatProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageFormatProperties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    reservedmarshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forMarshaling->maxExtent), ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxMipLevels, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxArrayLayers, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkSampleCountFlags*)&forMarshaling->sampleCounts, sizeof(VkSampleCountFlags));
    *ptr += sizeof(VkSampleCountFlags);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->maxResourceSize, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
}

void reservedmarshal_VkInstanceCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkInstanceCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkInstanceCreateFlags*)&forMarshaling->flags, sizeof(VkInstanceCreateFlags));
    *ptr += sizeof(VkInstanceCreateFlags);
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pApplicationInfo;
    memcpy((*ptr), &cgen_var_0, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pApplicationInfo)
    {
        reservedmarshal_VkApplicationInfo(vkStream, rootType, (const VkApplicationInfo*)(forMarshaling->pApplicationInfo), ptr);
    }
    memcpy(*ptr, (uint32_t*)&forMarshaling->enabledLayerCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    {
        uint32_t c = 0;
        if (forMarshaling)
        {
            c = forMarshaling->enabledLayerCount;
        }
        memcpy(*ptr, (uint32_t*)&c, sizeof(uint32_t));
        gfxstream::aemu::Stream::toBe32((uint8_t*)*ptr);
        *ptr += sizeof(uint32_t);
        for (uint32_t i = 0; i < c; ++i)
        {
            uint32_t l = forMarshaling->ppEnabledLayerNames ? strlen(forMarshaling->ppEnabledLayerNames[i]): 0;
            memcpy(*ptr, (uint32_t*)&l, sizeof(uint32_t));
            gfxstream::aemu::Stream::toBe32((uint8_t*)*ptr);
            *ptr += sizeof(uint32_t);
            if (l)
            {
                memcpy(*ptr, (char*)(forMarshaling->ppEnabledLayerNames[i]), l);
                *ptr += l;
            }
        }
    }
    memcpy(*ptr, (uint32_t*)&forMarshaling->enabledExtensionCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    {
        uint32_t c = 0;
        if (forMarshaling)
        {
            c = forMarshaling->enabledExtensionCount;
        }
        memcpy(*ptr, (uint32_t*)&c, sizeof(uint32_t));
        gfxstream::aemu::Stream::toBe32((uint8_t*)*ptr);
        *ptr += sizeof(uint32_t);
        for (uint32_t i = 0; i < c; ++i)
        {
            uint32_t l = forMarshaling->ppEnabledExtensionNames ? strlen(forMarshaling->ppEnabledExtensionNames[i]): 0;
            memcpy(*ptr, (uint32_t*)&l, sizeof(uint32_t));
            gfxstream::aemu::Stream::toBe32((uint8_t*)*ptr);
            *ptr += sizeof(uint32_t);
            if (l)
            {
                memcpy(*ptr, (char*)(forMarshaling->ppEnabledExtensionNames[i]), l);
                *ptr += l;
            }
        }
    }
}

void reservedmarshal_VkMemoryHeap(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryHeap* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->size, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy(*ptr, (VkMemoryHeapFlags*)&forMarshaling->flags, sizeof(VkMemoryHeapFlags));
    *ptr += sizeof(VkMemoryHeapFlags);
}

void reservedmarshal_VkMemoryType(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryType* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkMemoryPropertyFlags*)&forMarshaling->propertyFlags, sizeof(VkMemoryPropertyFlags));
    *ptr += sizeof(VkMemoryPropertyFlags);
    memcpy(*ptr, (uint32_t*)&forMarshaling->heapIndex, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkPhysicalDeviceFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceFeatures* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkBool32*)&forMarshaling->robustBufferAccess, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->fullDrawIndexUint32, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->imageCubeArray, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->independentBlend, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->geometryShader, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->tessellationShader, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->sampleRateShading, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->dualSrcBlend, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->logicOp, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->multiDrawIndirect, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->drawIndirectFirstInstance, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->depthClamp, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->depthBiasClamp, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->fillModeNonSolid, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->depthBounds, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->wideLines, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->largePoints, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->alphaToOne, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->multiViewport, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->samplerAnisotropy, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->textureCompressionETC2, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->textureCompressionASTC_LDR, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->textureCompressionBC, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->occlusionQueryPrecise, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->pipelineStatisticsQuery, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->vertexPipelineStoresAndAtomics, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->fragmentStoresAndAtomics, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderTessellationAndGeometryPointSize, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderImageGatherExtended, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderStorageImageExtendedFormats, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderStorageImageMultisample, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderStorageImageReadWithoutFormat, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderStorageImageWriteWithoutFormat, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderUniformBufferArrayDynamicIndexing, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderSampledImageArrayDynamicIndexing, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderStorageBufferArrayDynamicIndexing, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderStorageImageArrayDynamicIndexing, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderClipDistance, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderCullDistance, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderFloat64, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderInt64, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderInt16, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderResourceResidency, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderResourceMinLod, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->sparseBinding, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->sparseResidencyBuffer, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->sparseResidencyImage2D, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->sparseResidencyImage3D, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->sparseResidency2Samples, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->sparseResidency4Samples, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->sparseResidency8Samples, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->sparseResidency16Samples, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->sparseResidencyAliased, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->variableMultisampleRate, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->inheritedQueries, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDeviceLimits(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceLimits* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxImageDimension1D, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxImageDimension2D, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxImageDimension3D, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxImageDimensionCube, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxImageArrayLayers, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxTexelBufferElements, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxUniformBufferRange, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxStorageBufferRange, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxPushConstantsSize, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxMemoryAllocationCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxSamplerAllocationCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->bufferImageGranularity, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->sparseAddressSpaceSize, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxBoundDescriptorSets, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxPerStageDescriptorSamplers, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxPerStageDescriptorUniformBuffers, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxPerStageDescriptorStorageBuffers, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxPerStageDescriptorSampledImages, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxPerStageDescriptorStorageImages, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxPerStageDescriptorInputAttachments, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxPerStageResources, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxDescriptorSetSamplers, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxDescriptorSetUniformBuffers, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxDescriptorSetUniformBuffersDynamic, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxDescriptorSetStorageBuffers, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxDescriptorSetStorageBuffersDynamic, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxDescriptorSetSampledImages, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxDescriptorSetStorageImages, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxDescriptorSetInputAttachments, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxVertexInputAttributes, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxVertexInputBindings, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxVertexInputAttributeOffset, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxVertexInputBindingStride, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxVertexOutputComponents, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxTessellationGenerationLevel, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxTessellationPatchSize, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxTessellationControlPerVertexInputComponents, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxTessellationControlPerVertexOutputComponents, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxTessellationControlPerPatchOutputComponents, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxTessellationControlTotalOutputComponents, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxTessellationEvaluationInputComponents, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxTessellationEvaluationOutputComponents, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxGeometryShaderInvocations, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxGeometryInputComponents, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxGeometryOutputComponents, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxGeometryOutputVertices, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxGeometryTotalOutputComponents, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxFragmentInputComponents, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxFragmentOutputAttachments, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxFragmentDualSrcAttachments, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxFragmentCombinedOutputResources, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxComputeSharedMemorySize, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)forMarshaling->maxComputeWorkGroupCount, 3 * sizeof(uint32_t));
    *ptr += 3 * sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxComputeWorkGroupInvocations, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)forMarshaling->maxComputeWorkGroupSize, 3 * sizeof(uint32_t));
    *ptr += 3 * sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->subPixelPrecisionBits, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->subTexelPrecisionBits, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->mipmapPrecisionBits, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxDrawIndexedIndexValue, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxDrawIndirectCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (float*)&forMarshaling->maxSamplerLodBias, sizeof(float));
    *ptr += sizeof(float);
    memcpy(*ptr, (float*)&forMarshaling->maxSamplerAnisotropy, sizeof(float));
    *ptr += sizeof(float);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxViewports, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)forMarshaling->maxViewportDimensions, 2 * sizeof(uint32_t));
    *ptr += 2 * sizeof(uint32_t);
    memcpy(*ptr, (float*)forMarshaling->viewportBoundsRange, 2 * sizeof(float));
    *ptr += 2 * sizeof(float);
    memcpy(*ptr, (uint32_t*)&forMarshaling->viewportSubPixelBits, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    uint64_t cgen_var_0 = (uint64_t)forMarshaling->minMemoryMapAlignment;
    memcpy((*ptr), &cgen_var_0, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->minTexelBufferOffsetAlignment, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->minUniformBufferOffsetAlignment, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->minStorageBufferOffsetAlignment, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy(*ptr, (int32_t*)&forMarshaling->minTexelOffset, sizeof(int32_t));
    *ptr += sizeof(int32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxTexelOffset, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (int32_t*)&forMarshaling->minTexelGatherOffset, sizeof(int32_t));
    *ptr += sizeof(int32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxTexelGatherOffset, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (float*)&forMarshaling->minInterpolationOffset, sizeof(float));
    *ptr += sizeof(float);
    memcpy(*ptr, (float*)&forMarshaling->maxInterpolationOffset, sizeof(float));
    *ptr += sizeof(float);
    memcpy(*ptr, (uint32_t*)&forMarshaling->subPixelInterpolationOffsetBits, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxFramebufferWidth, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxFramebufferHeight, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxFramebufferLayers, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkSampleCountFlags*)&forMarshaling->framebufferColorSampleCounts, sizeof(VkSampleCountFlags));
    *ptr += sizeof(VkSampleCountFlags);
    memcpy(*ptr, (VkSampleCountFlags*)&forMarshaling->framebufferDepthSampleCounts, sizeof(VkSampleCountFlags));
    *ptr += sizeof(VkSampleCountFlags);
    memcpy(*ptr, (VkSampleCountFlags*)&forMarshaling->framebufferStencilSampleCounts, sizeof(VkSampleCountFlags));
    *ptr += sizeof(VkSampleCountFlags);
    memcpy(*ptr, (VkSampleCountFlags*)&forMarshaling->framebufferNoAttachmentsSampleCounts, sizeof(VkSampleCountFlags));
    *ptr += sizeof(VkSampleCountFlags);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxColorAttachments, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkSampleCountFlags*)&forMarshaling->sampledImageColorSampleCounts, sizeof(VkSampleCountFlags));
    *ptr += sizeof(VkSampleCountFlags);
    memcpy(*ptr, (VkSampleCountFlags*)&forMarshaling->sampledImageIntegerSampleCounts, sizeof(VkSampleCountFlags));
    *ptr += sizeof(VkSampleCountFlags);
    memcpy(*ptr, (VkSampleCountFlags*)&forMarshaling->sampledImageDepthSampleCounts, sizeof(VkSampleCountFlags));
    *ptr += sizeof(VkSampleCountFlags);
    memcpy(*ptr, (VkSampleCountFlags*)&forMarshaling->sampledImageStencilSampleCounts, sizeof(VkSampleCountFlags));
    *ptr += sizeof(VkSampleCountFlags);
    memcpy(*ptr, (VkSampleCountFlags*)&forMarshaling->storageImageSampleCounts, sizeof(VkSampleCountFlags));
    *ptr += sizeof(VkSampleCountFlags);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxSampleMaskWords, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkBool32*)&forMarshaling->timestampComputeAndGraphics, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (float*)&forMarshaling->timestampPeriod, sizeof(float));
    *ptr += sizeof(float);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxClipDistances, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxCullDistances, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxCombinedClipAndCullDistances, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->discreteQueuePriorities, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (float*)forMarshaling->pointSizeRange, 2 * sizeof(float));
    *ptr += 2 * sizeof(float);
    memcpy(*ptr, (float*)forMarshaling->lineWidthRange, 2 * sizeof(float));
    *ptr += 2 * sizeof(float);
    memcpy(*ptr, (float*)&forMarshaling->pointSizeGranularity, sizeof(float));
    *ptr += sizeof(float);
    memcpy(*ptr, (float*)&forMarshaling->lineWidthGranularity, sizeof(float));
    *ptr += sizeof(float);
    memcpy(*ptr, (VkBool32*)&forMarshaling->strictLines, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->standardSampleLocations, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->optimalBufferCopyOffsetAlignment, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->optimalBufferCopyRowPitchAlignment, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->nonCoherentAtomSize, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
}

void reservedmarshal_VkPhysicalDeviceMemoryProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMemoryProperties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (uint32_t*)&forMarshaling->memoryTypeCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)VK_MAX_MEMORY_TYPES; ++i)
    {
        reservedmarshal_VkMemoryType(vkStream, rootType, (VkMemoryType*)(forMarshaling->memoryTypes + i), ptr);
    }
    memcpy(*ptr, (uint32_t*)&forMarshaling->memoryHeapCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)VK_MAX_MEMORY_HEAPS; ++i)
    {
        reservedmarshal_VkMemoryHeap(vkStream, rootType, (VkMemoryHeap*)(forMarshaling->memoryHeaps + i), ptr);
    }
}

void reservedmarshal_VkPhysicalDeviceSparseProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceSparseProperties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkBool32*)&forMarshaling->residencyStandard2DBlockShape, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->residencyStandard2DMultisampleBlockShape, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->residencyStandard3DBlockShape, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->residencyAlignedMipSize, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->residencyNonResidentStrict, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDeviceProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceProperties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (uint32_t*)&forMarshaling->apiVersion, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->driverVersion, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->vendorID, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->deviceID, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkPhysicalDeviceType*)&forMarshaling->deviceType, sizeof(VkPhysicalDeviceType));
    *ptr += sizeof(VkPhysicalDeviceType);
    memcpy(*ptr, (char*)forMarshaling->deviceName, VK_MAX_PHYSICAL_DEVICE_NAME_SIZE * sizeof(char));
    *ptr += VK_MAX_PHYSICAL_DEVICE_NAME_SIZE * sizeof(char);
    memcpy(*ptr, (uint8_t*)forMarshaling->pipelineCacheUUID, VK_UUID_SIZE * sizeof(uint8_t));
    *ptr += VK_UUID_SIZE * sizeof(uint8_t);
    reservedmarshal_VkPhysicalDeviceLimits(vkStream, rootType, (VkPhysicalDeviceLimits*)(&forMarshaling->limits), ptr);
    reservedmarshal_VkPhysicalDeviceSparseProperties(vkStream, rootType, (VkPhysicalDeviceSparseProperties*)(&forMarshaling->sparseProperties), ptr);
}

void reservedmarshal_VkQueueFamilyProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkQueueFamilyProperties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkQueueFlags*)&forMarshaling->queueFlags, sizeof(VkQueueFlags));
    *ptr += sizeof(VkQueueFlags);
    memcpy(*ptr, (uint32_t*)&forMarshaling->queueCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->timestampValidBits, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    reservedmarshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forMarshaling->minImageTransferGranularity), ptr);
}

void reservedmarshal_VkDeviceQueueCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceQueueCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkDeviceQueueCreateFlags*)&forMarshaling->flags, sizeof(VkDeviceQueueCreateFlags));
    *ptr += sizeof(VkDeviceQueueCreateFlags);
    memcpy(*ptr, (uint32_t*)&forMarshaling->queueFamilyIndex, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->queueCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    if (forMarshaling->queueCount > 0)
    {
        memcpy(*ptr, (const float*)forMarshaling->pQueuePriorities, forMarshaling->queueCount * sizeof(const float));
        *ptr += forMarshaling->queueCount * sizeof(const float);
    }
}

void reservedmarshal_VkDeviceCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkDeviceCreateFlags*)&forMarshaling->flags, sizeof(VkDeviceCreateFlags));
    *ptr += sizeof(VkDeviceCreateFlags);
    memcpy(*ptr, (uint32_t*)&forMarshaling->queueCreateInfoCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->queueCreateInfoCount; ++i)
    {
        reservedmarshal_VkDeviceQueueCreateInfo(vkStream, rootType, (const VkDeviceQueueCreateInfo*)(forMarshaling->pQueueCreateInfos + i), ptr);
    }
    memcpy(*ptr, (uint32_t*)&forMarshaling->enabledLayerCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    {
        uint32_t c = 0;
        if (forMarshaling)
        {
            c = forMarshaling->enabledLayerCount;
        }
        memcpy(*ptr, (uint32_t*)&c, sizeof(uint32_t));
        gfxstream::aemu::Stream::toBe32((uint8_t*)*ptr);
        *ptr += sizeof(uint32_t);
        for (uint32_t i = 0; i < c; ++i)
        {
            uint32_t l = forMarshaling->ppEnabledLayerNames ? strlen(forMarshaling->ppEnabledLayerNames[i]): 0;
            memcpy(*ptr, (uint32_t*)&l, sizeof(uint32_t));
            gfxstream::aemu::Stream::toBe32((uint8_t*)*ptr);
            *ptr += sizeof(uint32_t);
            if (l)
            {
                memcpy(*ptr, (char*)(forMarshaling->ppEnabledLayerNames[i]), l);
                *ptr += l;
            }
        }
    }
    memcpy(*ptr, (uint32_t*)&forMarshaling->enabledExtensionCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    {
        uint32_t c = 0;
        if (forMarshaling)
        {
            c = forMarshaling->enabledExtensionCount;
        }
        memcpy(*ptr, (uint32_t*)&c, sizeof(uint32_t));
        gfxstream::aemu::Stream::toBe32((uint8_t*)*ptr);
        *ptr += sizeof(uint32_t);
        for (uint32_t i = 0; i < c; ++i)
        {
            uint32_t l = forMarshaling->ppEnabledExtensionNames ? strlen(forMarshaling->ppEnabledExtensionNames[i]): 0;
            memcpy(*ptr, (uint32_t*)&l, sizeof(uint32_t));
            gfxstream::aemu::Stream::toBe32((uint8_t*)*ptr);
            *ptr += sizeof(uint32_t);
            if (l)
            {
                memcpy(*ptr, (char*)(forMarshaling->ppEnabledExtensionNames[i]), l);
                *ptr += l;
            }
        }
    }
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pEnabledFeatures;
    memcpy((*ptr), &cgen_var_0, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pEnabledFeatures)
    {
        reservedmarshal_VkPhysicalDeviceFeatures(vkStream, rootType, (const VkPhysicalDeviceFeatures*)(forMarshaling->pEnabledFeatures), ptr);
    }
}

void reservedmarshal_VkExtensionProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExtensionProperties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (char*)forMarshaling->extensionName, VK_MAX_EXTENSION_NAME_SIZE * sizeof(char));
    *ptr += VK_MAX_EXTENSION_NAME_SIZE * sizeof(char);
    memcpy(*ptr, (uint32_t*)&forMarshaling->specVersion, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkLayerProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkLayerProperties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (char*)forMarshaling->layerName, VK_MAX_EXTENSION_NAME_SIZE * sizeof(char));
    *ptr += VK_MAX_EXTENSION_NAME_SIZE * sizeof(char);
    memcpy(*ptr, (uint32_t*)&forMarshaling->specVersion, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->implementationVersion, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (char*)forMarshaling->description, VK_MAX_DESCRIPTION_SIZE * sizeof(char));
    *ptr += VK_MAX_DESCRIPTION_SIZE * sizeof(char);
}

void reservedmarshal_VkSubmitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubmitInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->waitSemaphoreCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    if (forMarshaling->waitSemaphoreCount)
    {
        uint8_t* cgen_var_0_ptr = (uint8_t*)(*ptr);
        if (forMarshaling)
        {
            for (uint32_t k = 0; k < forMarshaling->waitSemaphoreCount; ++k)
            {
                uint64_t tmpval = get_host_u64_VkSemaphore(forMarshaling->pWaitSemaphores[k]);
                memcpy(cgen_var_0_ptr + k * 8, &tmpval, sizeof(uint64_t));
            }
        }
        *ptr += 8 * forMarshaling->waitSemaphoreCount;
    }
    if (forMarshaling->waitSemaphoreCount > 0)
    {
        memcpy(*ptr, (const VkPipelineStageFlags*)forMarshaling->pWaitDstStageMask, forMarshaling->waitSemaphoreCount * sizeof(const VkPipelineStageFlags));
        *ptr += forMarshaling->waitSemaphoreCount * sizeof(const VkPipelineStageFlags);
    }
    memcpy(*ptr, (uint32_t*)&forMarshaling->commandBufferCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    if (forMarshaling->commandBufferCount)
    {
        uint8_t* cgen_var_1_ptr = (uint8_t*)(*ptr);
        if (forMarshaling)
        {
            for (uint32_t k = 0; k < forMarshaling->commandBufferCount; ++k)
            {
                uint64_t tmpval = get_host_u64_VkCommandBuffer(forMarshaling->pCommandBuffers[k]);
                memcpy(cgen_var_1_ptr + k * 8, &tmpval, sizeof(uint64_t));
            }
        }
        *ptr += 8 * forMarshaling->commandBufferCount;
    }
    memcpy(*ptr, (uint32_t*)&forMarshaling->signalSemaphoreCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    if (forMarshaling->signalSemaphoreCount)
    {
        uint8_t* cgen_var_2_ptr = (uint8_t*)(*ptr);
        if (forMarshaling)
        {
            for (uint32_t k = 0; k < forMarshaling->signalSemaphoreCount; ++k)
            {
                uint64_t tmpval = get_host_u64_VkSemaphore(forMarshaling->pSignalSemaphores[k]);
                memcpy(cgen_var_2_ptr + k * 8, &tmpval, sizeof(uint64_t));
            }
        }
        *ptr += 8 * forMarshaling->signalSemaphoreCount;
    }
}

void reservedmarshal_VkMappedMemoryRange(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMappedMemoryRange* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkDeviceMemory((*&forMarshaling->memory));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->offset, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->size, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
}

void reservedmarshal_VkMemoryAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryAllocateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->allocationSize, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy(*ptr, (uint32_t*)&forMarshaling->memoryTypeIndex, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkMemoryRequirements(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryRequirements* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->size, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->alignment, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy(*ptr, (uint32_t*)&forMarshaling->memoryTypeBits, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkSparseMemoryBind(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSparseMemoryBind* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->resourceOffset, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->size, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkDeviceMemory((*&forMarshaling->memory));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->memoryOffset, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy(*ptr, (VkSparseMemoryBindFlags*)&forMarshaling->flags, sizeof(VkSparseMemoryBindFlags));
    *ptr += sizeof(VkSparseMemoryBindFlags);
}

void reservedmarshal_VkSparseBufferMemoryBindInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSparseBufferMemoryBindInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkBuffer((*&forMarshaling->buffer));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (uint32_t*)&forMarshaling->bindCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->bindCount; ++i)
    {
        reservedmarshal_VkSparseMemoryBind(vkStream, rootType, (const VkSparseMemoryBind*)(forMarshaling->pBinds + i), ptr);
    }
}

void reservedmarshal_VkSparseImageOpaqueMemoryBindInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSparseImageOpaqueMemoryBindInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkImage((*&forMarshaling->image));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (uint32_t*)&forMarshaling->bindCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->bindCount; ++i)
    {
        reservedmarshal_VkSparseMemoryBind(vkStream, rootType, (const VkSparseMemoryBind*)(forMarshaling->pBinds + i), ptr);
    }
}

void reservedmarshal_VkImageSubresource(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageSubresource* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkImageAspectFlags*)&forMarshaling->aspectMask, sizeof(VkImageAspectFlags));
    *ptr += sizeof(VkImageAspectFlags);
    memcpy(*ptr, (uint32_t*)&forMarshaling->mipLevel, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->arrayLayer, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkSparseImageMemoryBind(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSparseImageMemoryBind* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    reservedmarshal_VkImageSubresource(vkStream, rootType, (VkImageSubresource*)(&forMarshaling->subresource), ptr);
    reservedmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forMarshaling->offset), ptr);
    reservedmarshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forMarshaling->extent), ptr);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkDeviceMemory((*&forMarshaling->memory));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->memoryOffset, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy(*ptr, (VkSparseMemoryBindFlags*)&forMarshaling->flags, sizeof(VkSparseMemoryBindFlags));
    *ptr += sizeof(VkSparseMemoryBindFlags);
}

void reservedmarshal_VkSparseImageMemoryBindInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSparseImageMemoryBindInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkImage((*&forMarshaling->image));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (uint32_t*)&forMarshaling->bindCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->bindCount; ++i)
    {
        reservedmarshal_VkSparseImageMemoryBind(vkStream, rootType, (const VkSparseImageMemoryBind*)(forMarshaling->pBinds + i), ptr);
    }
}

void reservedmarshal_VkBindSparseInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBindSparseInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->waitSemaphoreCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    if (forMarshaling->waitSemaphoreCount)
    {
        uint8_t* cgen_var_0_ptr = (uint8_t*)(*ptr);
        if (forMarshaling)
        {
            for (uint32_t k = 0; k < forMarshaling->waitSemaphoreCount; ++k)
            {
                uint64_t tmpval = get_host_u64_VkSemaphore(forMarshaling->pWaitSemaphores[k]);
                memcpy(cgen_var_0_ptr + k * 8, &tmpval, sizeof(uint64_t));
            }
        }
        *ptr += 8 * forMarshaling->waitSemaphoreCount;
    }
    memcpy(*ptr, (uint32_t*)&forMarshaling->bufferBindCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->bufferBindCount; ++i)
    {
        reservedmarshal_VkSparseBufferMemoryBindInfo(vkStream, rootType, (const VkSparseBufferMemoryBindInfo*)(forMarshaling->pBufferBinds + i), ptr);
    }
    memcpy(*ptr, (uint32_t*)&forMarshaling->imageOpaqueBindCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->imageOpaqueBindCount; ++i)
    {
        reservedmarshal_VkSparseImageOpaqueMemoryBindInfo(vkStream, rootType, (const VkSparseImageOpaqueMemoryBindInfo*)(forMarshaling->pImageOpaqueBinds + i), ptr);
    }
    memcpy(*ptr, (uint32_t*)&forMarshaling->imageBindCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->imageBindCount; ++i)
    {
        reservedmarshal_VkSparseImageMemoryBindInfo(vkStream, rootType, (const VkSparseImageMemoryBindInfo*)(forMarshaling->pImageBinds + i), ptr);
    }
    memcpy(*ptr, (uint32_t*)&forMarshaling->signalSemaphoreCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    if (forMarshaling->signalSemaphoreCount)
    {
        uint8_t* cgen_var_1_ptr = (uint8_t*)(*ptr);
        if (forMarshaling)
        {
            for (uint32_t k = 0; k < forMarshaling->signalSemaphoreCount; ++k)
            {
                uint64_t tmpval = get_host_u64_VkSemaphore(forMarshaling->pSignalSemaphores[k]);
                memcpy(cgen_var_1_ptr + k * 8, &tmpval, sizeof(uint64_t));
            }
        }
        *ptr += 8 * forMarshaling->signalSemaphoreCount;
    }
}

void reservedmarshal_VkSparseImageFormatProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSparseImageFormatProperties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkImageAspectFlags*)&forMarshaling->aspectMask, sizeof(VkImageAspectFlags));
    *ptr += sizeof(VkImageAspectFlags);
    reservedmarshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forMarshaling->imageGranularity), ptr);
    memcpy(*ptr, (VkSparseImageFormatFlags*)&forMarshaling->flags, sizeof(VkSparseImageFormatFlags));
    *ptr += sizeof(VkSparseImageFormatFlags);
}

void reservedmarshal_VkSparseImageMemoryRequirements(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSparseImageMemoryRequirements* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    reservedmarshal_VkSparseImageFormatProperties(vkStream, rootType, (VkSparseImageFormatProperties*)(&forMarshaling->formatProperties), ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->imageMipTailFirstLod, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->imageMipTailSize, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->imageMipTailOffset, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->imageMipTailStride, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
}

void reservedmarshal_VkFenceCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkFenceCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkFenceCreateFlags*)&forMarshaling->flags, sizeof(VkFenceCreateFlags));
    *ptr += sizeof(VkFenceCreateFlags);
}

void reservedmarshal_VkSemaphoreCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSemaphoreCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkSemaphoreCreateFlags*)&forMarshaling->flags, sizeof(VkSemaphoreCreateFlags));
    *ptr += sizeof(VkSemaphoreCreateFlags);
}

void reservedmarshal_VkQueryPoolCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkQueryPoolCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkQueryPoolCreateFlags*)&forMarshaling->flags, sizeof(VkQueryPoolCreateFlags));
    *ptr += sizeof(VkQueryPoolCreateFlags);
    memcpy(*ptr, (VkQueryType*)&forMarshaling->queryType, sizeof(VkQueryType));
    *ptr += sizeof(VkQueryType);
    memcpy(*ptr, (uint32_t*)&forMarshaling->queryCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkQueryPipelineStatisticFlags*)&forMarshaling->pipelineStatistics, sizeof(VkQueryPipelineStatisticFlags));
    *ptr += sizeof(VkQueryPipelineStatisticFlags);
}

void reservedmarshal_VkBufferCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBufferCreateFlags*)&forMarshaling->flags, sizeof(VkBufferCreateFlags));
    *ptr += sizeof(VkBufferCreateFlags);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->size, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy(*ptr, (VkBufferUsageFlags*)&forMarshaling->usage, sizeof(VkBufferUsageFlags));
    *ptr += sizeof(VkBufferUsageFlags);
    memcpy(*ptr, (VkSharingMode*)&forMarshaling->sharingMode, sizeof(VkSharingMode));
    *ptr += sizeof(VkSharingMode);
    memcpy(*ptr, (uint32_t*)&forMarshaling->queueFamilyIndexCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pQueueFamilyIndices;
    memcpy((*ptr), &cgen_var_0, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pQueueFamilyIndices)
    {
        if (forMarshaling->queueFamilyIndexCount > 0)
        {
            memcpy(*ptr, (const uint32_t*)forMarshaling->pQueueFamilyIndices, forMarshaling->queueFamilyIndexCount * sizeof(const uint32_t));
            *ptr += forMarshaling->queueFamilyIndexCount * sizeof(const uint32_t);
        }
    }
}

void reservedmarshal_VkImageCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkImageCreateFlags*)&forMarshaling->flags, sizeof(VkImageCreateFlags));
    *ptr += sizeof(VkImageCreateFlags);
    memcpy(*ptr, (VkImageType*)&forMarshaling->imageType, sizeof(VkImageType));
    *ptr += sizeof(VkImageType);
    memcpy(*ptr, (VkFormat*)&forMarshaling->format, sizeof(VkFormat));
    *ptr += sizeof(VkFormat);
    reservedmarshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forMarshaling->extent), ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->mipLevels, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->arrayLayers, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkSampleCountFlagBits*)&forMarshaling->samples, sizeof(VkSampleCountFlagBits));
    *ptr += sizeof(VkSampleCountFlagBits);
    memcpy(*ptr, (VkImageTiling*)&forMarshaling->tiling, sizeof(VkImageTiling));
    *ptr += sizeof(VkImageTiling);
    memcpy(*ptr, (VkImageUsageFlags*)&forMarshaling->usage, sizeof(VkImageUsageFlags));
    *ptr += sizeof(VkImageUsageFlags);
    memcpy(*ptr, (VkSharingMode*)&forMarshaling->sharingMode, sizeof(VkSharingMode));
    *ptr += sizeof(VkSharingMode);
    memcpy(*ptr, (uint32_t*)&forMarshaling->queueFamilyIndexCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pQueueFamilyIndices;
    memcpy((*ptr), &cgen_var_0, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pQueueFamilyIndices)
    {
        if (forMarshaling->queueFamilyIndexCount > 0)
        {
            memcpy(*ptr, (const uint32_t*)forMarshaling->pQueueFamilyIndices, forMarshaling->queueFamilyIndexCount * sizeof(const uint32_t));
            *ptr += forMarshaling->queueFamilyIndexCount * sizeof(const uint32_t);
        }
    }
    memcpy(*ptr, (VkImageLayout*)&forMarshaling->initialLayout, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
}

void reservedmarshal_VkSubresourceLayout(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubresourceLayout* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->offset, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->size, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->rowPitch, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->arrayPitch, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->depthPitch, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
}

void reservedmarshal_VkComponentMapping(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkComponentMapping* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkComponentSwizzle*)&forMarshaling->r, sizeof(VkComponentSwizzle));
    *ptr += sizeof(VkComponentSwizzle);
    memcpy(*ptr, (VkComponentSwizzle*)&forMarshaling->g, sizeof(VkComponentSwizzle));
    *ptr += sizeof(VkComponentSwizzle);
    memcpy(*ptr, (VkComponentSwizzle*)&forMarshaling->b, sizeof(VkComponentSwizzle));
    *ptr += sizeof(VkComponentSwizzle);
    memcpy(*ptr, (VkComponentSwizzle*)&forMarshaling->a, sizeof(VkComponentSwizzle));
    *ptr += sizeof(VkComponentSwizzle);
}

void reservedmarshal_VkImageViewCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageViewCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkImageViewCreateFlags*)&forMarshaling->flags, sizeof(VkImageViewCreateFlags));
    *ptr += sizeof(VkImageViewCreateFlags);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkImage((*&forMarshaling->image));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (VkImageViewType*)&forMarshaling->viewType, sizeof(VkImageViewType));
    *ptr += sizeof(VkImageViewType);
    memcpy(*ptr, (VkFormat*)&forMarshaling->format, sizeof(VkFormat));
    *ptr += sizeof(VkFormat);
    reservedmarshal_VkComponentMapping(vkStream, rootType, (VkComponentMapping*)(&forMarshaling->components), ptr);
    reservedmarshal_VkImageSubresourceRange(vkStream, rootType, (VkImageSubresourceRange*)(&forMarshaling->subresourceRange), ptr);
}

void reservedmarshal_VkCommandPoolCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCommandPoolCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkCommandPoolCreateFlags*)&forMarshaling->flags, sizeof(VkCommandPoolCreateFlags));
    *ptr += sizeof(VkCommandPoolCreateFlags);
    memcpy(*ptr, (uint32_t*)&forMarshaling->queueFamilyIndex, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkCommandBufferAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCommandBufferAllocateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkCommandPool((*&forMarshaling->commandPool));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (VkCommandBufferLevel*)&forMarshaling->level, sizeof(VkCommandBufferLevel));
    *ptr += sizeof(VkCommandBufferLevel);
    memcpy(*ptr, (uint32_t*)&forMarshaling->commandBufferCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkCommandBufferInheritanceInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCommandBufferInheritanceInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkRenderPass((*&forMarshaling->renderPass));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (uint32_t*)&forMarshaling->subpass, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    uint64_t cgen_var_1;
    *&cgen_var_1 = get_host_u64_VkFramebuffer((*&forMarshaling->framebuffer));
    memcpy(*ptr, (uint64_t*)&cgen_var_1, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (VkBool32*)&forMarshaling->occlusionQueryEnable, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkQueryControlFlags*)&forMarshaling->queryFlags, sizeof(VkQueryControlFlags));
    *ptr += sizeof(VkQueryControlFlags);
    memcpy(*ptr, (VkQueryPipelineStatisticFlags*)&forMarshaling->pipelineStatistics, sizeof(VkQueryPipelineStatisticFlags));
    *ptr += sizeof(VkQueryPipelineStatisticFlags);
}

void reservedmarshal_VkCommandBufferBeginInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCommandBufferBeginInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkCommandBufferUsageFlags*)&forMarshaling->flags, sizeof(VkCommandBufferUsageFlags));
    *ptr += sizeof(VkCommandBufferUsageFlags);
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pInheritanceInfo;
    memcpy((*ptr), &cgen_var_0, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pInheritanceInfo)
    {
        reservedmarshal_VkCommandBufferInheritanceInfo(vkStream, rootType, (const VkCommandBufferInheritanceInfo*)(forMarshaling->pInheritanceInfo), ptr);
    }
}

void reservedmarshal_VkBufferCopy(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferCopy* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->srcOffset, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->dstOffset, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->size, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
}

void reservedmarshal_VkImageSubresourceLayers(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageSubresourceLayers* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkImageAspectFlags*)&forMarshaling->aspectMask, sizeof(VkImageAspectFlags));
    *ptr += sizeof(VkImageAspectFlags);
    memcpy(*ptr, (uint32_t*)&forMarshaling->mipLevel, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->baseArrayLayer, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->layerCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkBufferImageCopy(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferImageCopy* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->bufferOffset, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy(*ptr, (uint32_t*)&forMarshaling->bufferRowLength, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->bufferImageHeight, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    reservedmarshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forMarshaling->imageSubresource), ptr);
    reservedmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forMarshaling->imageOffset), ptr);
    reservedmarshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forMarshaling->imageExtent), ptr);
}

void reservedmarshal_VkImageCopy(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageCopy* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    reservedmarshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forMarshaling->srcSubresource), ptr);
    reservedmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forMarshaling->srcOffset), ptr);
    reservedmarshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forMarshaling->dstSubresource), ptr);
    reservedmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forMarshaling->dstOffset), ptr);
    reservedmarshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forMarshaling->extent), ptr);
}

#endif
#ifdef VK_COMPUTE_VERSION_1_0
void reservedmarshal_VkDispatchIndirectCommand(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDispatchIndirectCommand* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (uint32_t*)&forMarshaling->x, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->y, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->z, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkPipelineCacheHeaderVersionOne(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineCacheHeaderVersionOne* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (uint32_t*)&forMarshaling->headerSize, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkPipelineCacheHeaderVersion*)&forMarshaling->headerVersion, sizeof(VkPipelineCacheHeaderVersion));
    *ptr += sizeof(VkPipelineCacheHeaderVersion);
    memcpy(*ptr, (uint32_t*)&forMarshaling->vendorID, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->deviceID, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint8_t*)forMarshaling->pipelineCacheUUID, VK_UUID_SIZE * sizeof(uint8_t));
    *ptr += VK_UUID_SIZE * sizeof(uint8_t);
}

void reservedmarshal_VkEventCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkEventCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkEventCreateFlags*)&forMarshaling->flags, sizeof(VkEventCreateFlags));
    *ptr += sizeof(VkEventCreateFlags);
}

void reservedmarshal_VkBufferViewCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferViewCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBufferViewCreateFlags*)&forMarshaling->flags, sizeof(VkBufferViewCreateFlags));
    *ptr += sizeof(VkBufferViewCreateFlags);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkBuffer((*&forMarshaling->buffer));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (VkFormat*)&forMarshaling->format, sizeof(VkFormat));
    *ptr += sizeof(VkFormat);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->offset, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->range, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
}

void reservedmarshal_VkShaderModuleCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkShaderModuleCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkShaderModuleCreateFlags*)&forMarshaling->flags, sizeof(VkShaderModuleCreateFlags));
    *ptr += sizeof(VkShaderModuleCreateFlags);
    uint64_t cgen_var_0 = (uint64_t)forMarshaling->codeSize;
    memcpy((*ptr), &cgen_var_0, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if ((forMarshaling->codeSize / 4) > 0)
    {
        memcpy(*ptr, (const uint32_t*)forMarshaling->pCode, (forMarshaling->codeSize / 4) * sizeof(const uint32_t));
        *ptr += (forMarshaling->codeSize / 4) * sizeof(const uint32_t);
    }
}

void reservedmarshal_VkPipelineCacheCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineCacheCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkPipelineCacheCreateFlags*)&forMarshaling->flags, sizeof(VkPipelineCacheCreateFlags));
    *ptr += sizeof(VkPipelineCacheCreateFlags);
    uint64_t cgen_var_0 = (uint64_t)forMarshaling->initialDataSize;
    memcpy((*ptr), &cgen_var_0, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->initialDataSize > 0)
    {
        memcpy(*ptr, (const void*)forMarshaling->pInitialData, forMarshaling->initialDataSize * sizeof(const uint8_t));
        *ptr += forMarshaling->initialDataSize * sizeof(const uint8_t);
    }
}

void reservedmarshal_VkSpecializationMapEntry(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSpecializationMapEntry* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (uint32_t*)&forMarshaling->constantID, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->offset, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    uint64_t cgen_var_0 = (uint64_t)forMarshaling->size;
    memcpy((*ptr), &cgen_var_0, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
}

void reservedmarshal_VkSpecializationInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSpecializationInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (uint32_t*)&forMarshaling->mapEntryCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->mapEntryCount; ++i)
    {
        reservedmarshal_VkSpecializationMapEntry(vkStream, rootType, (const VkSpecializationMapEntry*)(forMarshaling->pMapEntries + i), ptr);
    }
    uint64_t cgen_var_0 = (uint64_t)forMarshaling->dataSize;
    memcpy((*ptr), &cgen_var_0, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->dataSize > 0)
    {
        memcpy(*ptr, (const void*)forMarshaling->pData, forMarshaling->dataSize * sizeof(const uint8_t));
        *ptr += forMarshaling->dataSize * sizeof(const uint8_t);
    }
}

void reservedmarshal_VkPipelineShaderStageCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineShaderStageCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkPipelineShaderStageCreateFlags*)&forMarshaling->flags, sizeof(VkPipelineShaderStageCreateFlags));
    *ptr += sizeof(VkPipelineShaderStageCreateFlags);
    memcpy(*ptr, (VkShaderStageFlagBits*)&forMarshaling->stage, sizeof(VkShaderStageFlagBits));
    *ptr += sizeof(VkShaderStageFlagBits);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkShaderModule((*&forMarshaling->module));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    {
        uint32_t l = forMarshaling->pName ? strlen(forMarshaling->pName): 0;
        memcpy(*ptr, (uint32_t*)&l, sizeof(uint32_t));
        gfxstream::aemu::Stream::toBe32((uint8_t*)*ptr);
        *ptr += sizeof(uint32_t);
        memcpy(*ptr, (char*)forMarshaling->pName, l);
        *ptr += l;
    }
    // WARNING PTR CHECK
    uint64_t cgen_var_1 = (uint64_t)(uintptr_t)forMarshaling->pSpecializationInfo;
    memcpy((*ptr), &cgen_var_1, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pSpecializationInfo)
    {
        reservedmarshal_VkSpecializationInfo(vkStream, rootType, (const VkSpecializationInfo*)(forMarshaling->pSpecializationInfo), ptr);
    }
}

void reservedmarshal_VkComputePipelineCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkComputePipelineCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkPipelineCreateFlags*)&forMarshaling->flags, sizeof(VkPipelineCreateFlags));
    *ptr += sizeof(VkPipelineCreateFlags);
    reservedmarshal_VkPipelineShaderStageCreateInfo(vkStream, rootType, (VkPipelineShaderStageCreateInfo*)(&forMarshaling->stage), ptr);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkPipelineLayout((*&forMarshaling->layout));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    uint64_t cgen_var_1;
    *&cgen_var_1 = get_host_u64_VkPipeline((*&forMarshaling->basePipelineHandle));
    memcpy(*ptr, (uint64_t*)&cgen_var_1, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (int32_t*)&forMarshaling->basePipelineIndex, sizeof(int32_t));
    *ptr += sizeof(int32_t);
}

void reservedmarshal_VkPushConstantRange(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPushConstantRange* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkShaderStageFlags*)&forMarshaling->stageFlags, sizeof(VkShaderStageFlags));
    *ptr += sizeof(VkShaderStageFlags);
    memcpy(*ptr, (uint32_t*)&forMarshaling->offset, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->size, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkPipelineLayoutCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineLayoutCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkPipelineLayoutCreateFlags*)&forMarshaling->flags, sizeof(VkPipelineLayoutCreateFlags));
    *ptr += sizeof(VkPipelineLayoutCreateFlags);
    memcpy(*ptr, (uint32_t*)&forMarshaling->setLayoutCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    if (forMarshaling->setLayoutCount)
    {
        uint8_t* cgen_var_0_ptr = (uint8_t*)(*ptr);
        if (forMarshaling)
        {
            for (uint32_t k = 0; k < forMarshaling->setLayoutCount; ++k)
            {
                uint64_t tmpval = get_host_u64_VkDescriptorSetLayout(forMarshaling->pSetLayouts[k]);
                memcpy(cgen_var_0_ptr + k * 8, &tmpval, sizeof(uint64_t));
            }
        }
        *ptr += 8 * forMarshaling->setLayoutCount;
    }
    memcpy(*ptr, (uint32_t*)&forMarshaling->pushConstantRangeCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->pushConstantRangeCount; ++i)
    {
        reservedmarshal_VkPushConstantRange(vkStream, rootType, (const VkPushConstantRange*)(forMarshaling->pPushConstantRanges + i), ptr);
    }
}

void reservedmarshal_VkSamplerCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSamplerCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkSamplerCreateFlags*)&forMarshaling->flags, sizeof(VkSamplerCreateFlags));
    *ptr += sizeof(VkSamplerCreateFlags);
    memcpy(*ptr, (VkFilter*)&forMarshaling->magFilter, sizeof(VkFilter));
    *ptr += sizeof(VkFilter);
    memcpy(*ptr, (VkFilter*)&forMarshaling->minFilter, sizeof(VkFilter));
    *ptr += sizeof(VkFilter);
    memcpy(*ptr, (VkSamplerMipmapMode*)&forMarshaling->mipmapMode, sizeof(VkSamplerMipmapMode));
    *ptr += sizeof(VkSamplerMipmapMode);
    memcpy(*ptr, (VkSamplerAddressMode*)&forMarshaling->addressModeU, sizeof(VkSamplerAddressMode));
    *ptr += sizeof(VkSamplerAddressMode);
    memcpy(*ptr, (VkSamplerAddressMode*)&forMarshaling->addressModeV, sizeof(VkSamplerAddressMode));
    *ptr += sizeof(VkSamplerAddressMode);
    memcpy(*ptr, (VkSamplerAddressMode*)&forMarshaling->addressModeW, sizeof(VkSamplerAddressMode));
    *ptr += sizeof(VkSamplerAddressMode);
    memcpy(*ptr, (float*)&forMarshaling->mipLodBias, sizeof(float));
    *ptr += sizeof(float);
    memcpy(*ptr, (VkBool32*)&forMarshaling->anisotropyEnable, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (float*)&forMarshaling->maxAnisotropy, sizeof(float));
    *ptr += sizeof(float);
    memcpy(*ptr, (VkBool32*)&forMarshaling->compareEnable, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkCompareOp*)&forMarshaling->compareOp, sizeof(VkCompareOp));
    *ptr += sizeof(VkCompareOp);
    memcpy(*ptr, (float*)&forMarshaling->minLod, sizeof(float));
    *ptr += sizeof(float);
    memcpy(*ptr, (float*)&forMarshaling->maxLod, sizeof(float));
    *ptr += sizeof(float);
    memcpy(*ptr, (VkBorderColor*)&forMarshaling->borderColor, sizeof(VkBorderColor));
    *ptr += sizeof(VkBorderColor);
    memcpy(*ptr, (VkBool32*)&forMarshaling->unnormalizedCoordinates, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkCopyDescriptorSet(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCopyDescriptorSet* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkDescriptorSet((*&forMarshaling->srcSet));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (uint32_t*)&forMarshaling->srcBinding, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->srcArrayElement, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    uint64_t cgen_var_1;
    *&cgen_var_1 = get_host_u64_VkDescriptorSet((*&forMarshaling->dstSet));
    memcpy(*ptr, (uint64_t*)&cgen_var_1, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (uint32_t*)&forMarshaling->dstBinding, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->dstArrayElement, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->descriptorCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkDescriptorBufferInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorBufferInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkBuffer((*&forMarshaling->buffer));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->offset, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->range, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
}

void reservedmarshal_VkDescriptorImageInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorImageInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkSampler((*&forMarshaling->sampler));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    uint64_t cgen_var_1;
    *&cgen_var_1 = get_host_u64_VkImageView((*&forMarshaling->imageView));
    memcpy(*ptr, (uint64_t*)&cgen_var_1, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (VkImageLayout*)&forMarshaling->imageLayout, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
}

void reservedmarshal_VkDescriptorPoolSize(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorPoolSize* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkDescriptorType*)&forMarshaling->type, sizeof(VkDescriptorType));
    *ptr += sizeof(VkDescriptorType);
    memcpy(*ptr, (uint32_t*)&forMarshaling->descriptorCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkDescriptorPoolCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorPoolCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkDescriptorPoolCreateFlags*)&forMarshaling->flags, sizeof(VkDescriptorPoolCreateFlags));
    *ptr += sizeof(VkDescriptorPoolCreateFlags);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxSets, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->poolSizeCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->poolSizeCount; ++i)
    {
        reservedmarshal_VkDescriptorPoolSize(vkStream, rootType, (const VkDescriptorPoolSize*)(forMarshaling->pPoolSizes + i), ptr);
    }
}

void reservedmarshal_VkDescriptorSetAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorSetAllocateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkDescriptorPool((*&forMarshaling->descriptorPool));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (uint32_t*)&forMarshaling->descriptorSetCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    if (forMarshaling->descriptorSetCount)
    {
        uint8_t* cgen_var_1_ptr = (uint8_t*)(*ptr);
        if (forMarshaling)
        {
            for (uint32_t k = 0; k < forMarshaling->descriptorSetCount; ++k)
            {
                uint64_t tmpval = get_host_u64_VkDescriptorSetLayout(forMarshaling->pSetLayouts[k]);
                memcpy(cgen_var_1_ptr + k * 8, &tmpval, sizeof(uint64_t));
            }
        }
        *ptr += 8 * forMarshaling->descriptorSetCount;
    }
}

void reservedmarshal_VkDescriptorSetLayoutBinding(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorSetLayoutBinding* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (uint32_t*)&forMarshaling->binding, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkDescriptorType*)&forMarshaling->descriptorType, sizeof(VkDescriptorType));
    *ptr += sizeof(VkDescriptorType);
    memcpy(*ptr, (uint32_t*)&forMarshaling->descriptorCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkShaderStageFlags*)&forMarshaling->stageFlags, sizeof(VkShaderStageFlags));
    *ptr += sizeof(VkShaderStageFlags);
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pImmutableSamplers;
    memcpy((*ptr), &cgen_var_0, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pImmutableSamplers)
    {
        if (forMarshaling->descriptorCount)
        {
            uint8_t* cgen_var_0_0_ptr = (uint8_t*)(*ptr);
            if (forMarshaling)
            {
                for (uint32_t k = 0; k < forMarshaling->descriptorCount; ++k)
                {
                    uint64_t tmpval = get_host_u64_VkSampler(forMarshaling->pImmutableSamplers[k]);
                    memcpy(cgen_var_0_0_ptr + k * 8, &tmpval, sizeof(uint64_t));
                }
            }
            *ptr += 8 * forMarshaling->descriptorCount;
        }
    }
}

void reservedmarshal_VkDescriptorSetLayoutCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorSetLayoutCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkDescriptorSetLayoutCreateFlags*)&forMarshaling->flags, sizeof(VkDescriptorSetLayoutCreateFlags));
    *ptr += sizeof(VkDescriptorSetLayoutCreateFlags);
    memcpy(*ptr, (uint32_t*)&forMarshaling->bindingCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->bindingCount; ++i)
    {
        reservedmarshal_VkDescriptorSetLayoutBinding(vkStream, rootType, (const VkDescriptorSetLayoutBinding*)(forMarshaling->pBindings + i), ptr);
    }
}

void reservedmarshal_VkWriteDescriptorSet(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkWriteDescriptorSet* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkDescriptorSet((*&forMarshaling->dstSet));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (uint32_t*)&forMarshaling->dstBinding, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->dstArrayElement, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->descriptorCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkDescriptorType*)&forMarshaling->descriptorType, sizeof(VkDescriptorType));
    *ptr += sizeof(VkDescriptorType);
    // WARNING PTR CHECK
    uint64_t cgen_var_1 = (uint64_t)(uintptr_t)forMarshaling->pImageInfo;
    memcpy((*ptr), &cgen_var_1, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pImageInfo)
    {
        if ((!(vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT) || ((VK_DESCRIPTOR_TYPE_SAMPLER == forMarshaling->descriptorType) || (VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER == forMarshaling->descriptorType) || (VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE == forMarshaling->descriptorType) || (VK_DESCRIPTOR_TYPE_STORAGE_IMAGE == forMarshaling->descriptorType) || (VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT == forMarshaling->descriptorType))))
        {
            for (uint32_t i = 0; i < (uint32_t)forMarshaling->descriptorCount; ++i)
            {
                reservedmarshal_VkDescriptorImageInfo(vkStream, rootType, (const VkDescriptorImageInfo*)(forMarshaling->pImageInfo + i), ptr);
            }
        }
    }
    // WARNING PTR CHECK
    uint64_t cgen_var_2 = (uint64_t)(uintptr_t)forMarshaling->pBufferInfo;
    memcpy((*ptr), &cgen_var_2, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pBufferInfo)
    {
        if ((!(vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT) || ((VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER == forMarshaling->descriptorType) || (VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC == forMarshaling->descriptorType) || (VK_DESCRIPTOR_TYPE_STORAGE_BUFFER == forMarshaling->descriptorType) || (VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC == forMarshaling->descriptorType))))
        {
            for (uint32_t i = 0; i < (uint32_t)forMarshaling->descriptorCount; ++i)
            {
                reservedmarshal_VkDescriptorBufferInfo(vkStream, rootType, (const VkDescriptorBufferInfo*)(forMarshaling->pBufferInfo + i), ptr);
            }
        }
    }
    // WARNING PTR CHECK
    uint64_t cgen_var_3 = (uint64_t)(uintptr_t)forMarshaling->pTexelBufferView;
    memcpy((*ptr), &cgen_var_3, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pTexelBufferView)
    {
        if ((!(vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT) || ((VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER == forMarshaling->descriptorType) || (VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER == forMarshaling->descriptorType))))
        {
            if (forMarshaling->descriptorCount)
            {
                uint8_t* cgen_var_3_0_ptr = (uint8_t*)(*ptr);
                if (forMarshaling)
                {
                    for (uint32_t k = 0; k < forMarshaling->descriptorCount; ++k)
                    {
                        uint64_t tmpval = get_host_u64_VkBufferView(forMarshaling->pTexelBufferView[k]);
                        memcpy(cgen_var_3_0_ptr + k * 8, &tmpval, sizeof(uint64_t));
                    }
                }
                *ptr += 8 * forMarshaling->descriptorCount;
            }
        }
    }
}

void reservedmarshal_VkClearColorValue(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkClearColorValue* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (float*)forMarshaling->float32, 4 * sizeof(float));
    *ptr += 4 * sizeof(float);
}

#endif
#ifdef VK_GRAPHICS_VERSION_1_0
void reservedmarshal_VkDrawIndexedIndirectCommand(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDrawIndexedIndirectCommand* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (uint32_t*)&forMarshaling->indexCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->instanceCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->firstIndex, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (int32_t*)&forMarshaling->vertexOffset, sizeof(int32_t));
    *ptr += sizeof(int32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->firstInstance, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkDrawIndirectCommand(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDrawIndirectCommand* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (uint32_t*)&forMarshaling->vertexCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->instanceCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->firstVertex, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->firstInstance, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkVertexInputBindingDescription(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkVertexInputBindingDescription* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (uint32_t*)&forMarshaling->binding, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->stride, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkVertexInputRate*)&forMarshaling->inputRate, sizeof(VkVertexInputRate));
    *ptr += sizeof(VkVertexInputRate);
}

void reservedmarshal_VkVertexInputAttributeDescription(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkVertexInputAttributeDescription* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (uint32_t*)&forMarshaling->location, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->binding, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkFormat*)&forMarshaling->format, sizeof(VkFormat));
    *ptr += sizeof(VkFormat);
    memcpy(*ptr, (uint32_t*)&forMarshaling->offset, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkPipelineVertexInputStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineVertexInputStateCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkPipelineVertexInputStateCreateFlags*)&forMarshaling->flags, sizeof(VkPipelineVertexInputStateCreateFlags));
    *ptr += sizeof(VkPipelineVertexInputStateCreateFlags);
    memcpy(*ptr, (uint32_t*)&forMarshaling->vertexBindingDescriptionCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->vertexBindingDescriptionCount; ++i)
    {
        reservedmarshal_VkVertexInputBindingDescription(vkStream, rootType, (const VkVertexInputBindingDescription*)(forMarshaling->pVertexBindingDescriptions + i), ptr);
    }
    memcpy(*ptr, (uint32_t*)&forMarshaling->vertexAttributeDescriptionCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->vertexAttributeDescriptionCount; ++i)
    {
        reservedmarshal_VkVertexInputAttributeDescription(vkStream, rootType, (const VkVertexInputAttributeDescription*)(forMarshaling->pVertexAttributeDescriptions + i), ptr);
    }
}

void reservedmarshal_VkPipelineInputAssemblyStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineInputAssemblyStateCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkPipelineInputAssemblyStateCreateFlags*)&forMarshaling->flags, sizeof(VkPipelineInputAssemblyStateCreateFlags));
    *ptr += sizeof(VkPipelineInputAssemblyStateCreateFlags);
    memcpy(*ptr, (VkPrimitiveTopology*)&forMarshaling->topology, sizeof(VkPrimitiveTopology));
    *ptr += sizeof(VkPrimitiveTopology);
    memcpy(*ptr, (VkBool32*)&forMarshaling->primitiveRestartEnable, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPipelineTessellationStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineTessellationStateCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkPipelineTessellationStateCreateFlags*)&forMarshaling->flags, sizeof(VkPipelineTessellationStateCreateFlags));
    *ptr += sizeof(VkPipelineTessellationStateCreateFlags);
    memcpy(*ptr, (uint32_t*)&forMarshaling->patchControlPoints, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkViewport(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkViewport* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (float*)&forMarshaling->x, sizeof(float));
    *ptr += sizeof(float);
    memcpy(*ptr, (float*)&forMarshaling->y, sizeof(float));
    *ptr += sizeof(float);
    memcpy(*ptr, (float*)&forMarshaling->width, sizeof(float));
    *ptr += sizeof(float);
    memcpy(*ptr, (float*)&forMarshaling->height, sizeof(float));
    *ptr += sizeof(float);
    memcpy(*ptr, (float*)&forMarshaling->minDepth, sizeof(float));
    *ptr += sizeof(float);
    memcpy(*ptr, (float*)&forMarshaling->maxDepth, sizeof(float));
    *ptr += sizeof(float);
}

void reservedmarshal_VkPipelineViewportStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineViewportStateCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkPipelineViewportStateCreateFlags*)&forMarshaling->flags, sizeof(VkPipelineViewportStateCreateFlags));
    *ptr += sizeof(VkPipelineViewportStateCreateFlags);
    memcpy(*ptr, (uint32_t*)&forMarshaling->viewportCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pViewports;
    memcpy((*ptr), &cgen_var_0, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pViewports)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->viewportCount; ++i)
        {
            reservedmarshal_VkViewport(vkStream, rootType, (const VkViewport*)(forMarshaling->pViewports + i), ptr);
        }
    }
    memcpy(*ptr, (uint32_t*)&forMarshaling->scissorCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    // WARNING PTR CHECK
    uint64_t cgen_var_1 = (uint64_t)(uintptr_t)forMarshaling->pScissors;
    memcpy((*ptr), &cgen_var_1, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pScissors)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->scissorCount; ++i)
        {
            reservedmarshal_VkRect2D(vkStream, rootType, (const VkRect2D*)(forMarshaling->pScissors + i), ptr);
        }
    }
}

void reservedmarshal_VkPipelineRasterizationStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineRasterizationStateCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkPipelineRasterizationStateCreateFlags*)&forMarshaling->flags, sizeof(VkPipelineRasterizationStateCreateFlags));
    *ptr += sizeof(VkPipelineRasterizationStateCreateFlags);
    memcpy(*ptr, (VkBool32*)&forMarshaling->depthClampEnable, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->rasterizerDiscardEnable, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkPolygonMode*)&forMarshaling->polygonMode, sizeof(VkPolygonMode));
    *ptr += sizeof(VkPolygonMode);
    memcpy(*ptr, (VkCullModeFlags*)&forMarshaling->cullMode, sizeof(VkCullModeFlags));
    *ptr += sizeof(VkCullModeFlags);
    memcpy(*ptr, (VkFrontFace*)&forMarshaling->frontFace, sizeof(VkFrontFace));
    *ptr += sizeof(VkFrontFace);
    memcpy(*ptr, (VkBool32*)&forMarshaling->depthBiasEnable, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (float*)&forMarshaling->depthBiasConstantFactor, sizeof(float));
    *ptr += sizeof(float);
    memcpy(*ptr, (float*)&forMarshaling->depthBiasClamp, sizeof(float));
    *ptr += sizeof(float);
    memcpy(*ptr, (float*)&forMarshaling->depthBiasSlopeFactor, sizeof(float));
    *ptr += sizeof(float);
    memcpy(*ptr, (float*)&forMarshaling->lineWidth, sizeof(float));
    *ptr += sizeof(float);
}

void reservedmarshal_VkPipelineMultisampleStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineMultisampleStateCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkPipelineMultisampleStateCreateFlags*)&forMarshaling->flags, sizeof(VkPipelineMultisampleStateCreateFlags));
    *ptr += sizeof(VkPipelineMultisampleStateCreateFlags);
    memcpy(*ptr, (VkSampleCountFlagBits*)&forMarshaling->rasterizationSamples, sizeof(VkSampleCountFlagBits));
    *ptr += sizeof(VkSampleCountFlagBits);
    memcpy(*ptr, (VkBool32*)&forMarshaling->sampleShadingEnable, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (float*)&forMarshaling->minSampleShading, sizeof(float));
    *ptr += sizeof(float);
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pSampleMask;
    memcpy((*ptr), &cgen_var_0, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pSampleMask)
    {
        if ((((forMarshaling->rasterizationSamples) + 31) / 32) > 0)
        {
            memcpy(*ptr, (const VkSampleMask*)forMarshaling->pSampleMask, (((forMarshaling->rasterizationSamples) + 31) / 32) * sizeof(const VkSampleMask));
            *ptr += (((forMarshaling->rasterizationSamples) + 31) / 32) * sizeof(const VkSampleMask);
        }
    }
    memcpy(*ptr, (VkBool32*)&forMarshaling->alphaToCoverageEnable, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->alphaToOneEnable, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkStencilOpState(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkStencilOpState* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStencilOp*)&forMarshaling->failOp, sizeof(VkStencilOp));
    *ptr += sizeof(VkStencilOp);
    memcpy(*ptr, (VkStencilOp*)&forMarshaling->passOp, sizeof(VkStencilOp));
    *ptr += sizeof(VkStencilOp);
    memcpy(*ptr, (VkStencilOp*)&forMarshaling->depthFailOp, sizeof(VkStencilOp));
    *ptr += sizeof(VkStencilOp);
    memcpy(*ptr, (VkCompareOp*)&forMarshaling->compareOp, sizeof(VkCompareOp));
    *ptr += sizeof(VkCompareOp);
    memcpy(*ptr, (uint32_t*)&forMarshaling->compareMask, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->writeMask, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->reference, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkPipelineDepthStencilStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineDepthStencilStateCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkPipelineDepthStencilStateCreateFlags*)&forMarshaling->flags, sizeof(VkPipelineDepthStencilStateCreateFlags));
    *ptr += sizeof(VkPipelineDepthStencilStateCreateFlags);
    memcpy(*ptr, (VkBool32*)&forMarshaling->depthTestEnable, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->depthWriteEnable, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkCompareOp*)&forMarshaling->depthCompareOp, sizeof(VkCompareOp));
    *ptr += sizeof(VkCompareOp);
    memcpy(*ptr, (VkBool32*)&forMarshaling->depthBoundsTestEnable, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->stencilTestEnable, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    reservedmarshal_VkStencilOpState(vkStream, rootType, (VkStencilOpState*)(&forMarshaling->front), ptr);
    reservedmarshal_VkStencilOpState(vkStream, rootType, (VkStencilOpState*)(&forMarshaling->back), ptr);
    memcpy(*ptr, (float*)&forMarshaling->minDepthBounds, sizeof(float));
    *ptr += sizeof(float);
    memcpy(*ptr, (float*)&forMarshaling->maxDepthBounds, sizeof(float));
    *ptr += sizeof(float);
}

void reservedmarshal_VkPipelineColorBlendAttachmentState(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineColorBlendAttachmentState* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkBool32*)&forMarshaling->blendEnable, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBlendFactor*)&forMarshaling->srcColorBlendFactor, sizeof(VkBlendFactor));
    *ptr += sizeof(VkBlendFactor);
    memcpy(*ptr, (VkBlendFactor*)&forMarshaling->dstColorBlendFactor, sizeof(VkBlendFactor));
    *ptr += sizeof(VkBlendFactor);
    memcpy(*ptr, (VkBlendOp*)&forMarshaling->colorBlendOp, sizeof(VkBlendOp));
    *ptr += sizeof(VkBlendOp);
    memcpy(*ptr, (VkBlendFactor*)&forMarshaling->srcAlphaBlendFactor, sizeof(VkBlendFactor));
    *ptr += sizeof(VkBlendFactor);
    memcpy(*ptr, (VkBlendFactor*)&forMarshaling->dstAlphaBlendFactor, sizeof(VkBlendFactor));
    *ptr += sizeof(VkBlendFactor);
    memcpy(*ptr, (VkBlendOp*)&forMarshaling->alphaBlendOp, sizeof(VkBlendOp));
    *ptr += sizeof(VkBlendOp);
    memcpy(*ptr, (VkColorComponentFlags*)&forMarshaling->colorWriteMask, sizeof(VkColorComponentFlags));
    *ptr += sizeof(VkColorComponentFlags);
}

void reservedmarshal_VkPipelineColorBlendStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineColorBlendStateCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkPipelineColorBlendStateCreateFlags*)&forMarshaling->flags, sizeof(VkPipelineColorBlendStateCreateFlags));
    *ptr += sizeof(VkPipelineColorBlendStateCreateFlags);
    memcpy(*ptr, (VkBool32*)&forMarshaling->logicOpEnable, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkLogicOp*)&forMarshaling->logicOp, sizeof(VkLogicOp));
    *ptr += sizeof(VkLogicOp);
    memcpy(*ptr, (uint32_t*)&forMarshaling->attachmentCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->attachmentCount; ++i)
    {
        reservedmarshal_VkPipelineColorBlendAttachmentState(vkStream, rootType, (const VkPipelineColorBlendAttachmentState*)(forMarshaling->pAttachments + i), ptr);
    }
    memcpy(*ptr, (float*)forMarshaling->blendConstants, 4 * sizeof(float));
    *ptr += 4 * sizeof(float);
}

void reservedmarshal_VkPipelineDynamicStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineDynamicStateCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkPipelineDynamicStateCreateFlags*)&forMarshaling->flags, sizeof(VkPipelineDynamicStateCreateFlags));
    *ptr += sizeof(VkPipelineDynamicStateCreateFlags);
    memcpy(*ptr, (uint32_t*)&forMarshaling->dynamicStateCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    if (forMarshaling->dynamicStateCount > 0)
    {
        memcpy(*ptr, (const VkDynamicState*)forMarshaling->pDynamicStates, forMarshaling->dynamicStateCount * sizeof(const VkDynamicState));
        *ptr += forMarshaling->dynamicStateCount * sizeof(const VkDynamicState);
    }
}

void reservedmarshal_VkGraphicsPipelineCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkGraphicsPipelineCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    uint32_t hasRasterization = 1;
    if (vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT)
    {
        hasRasterization = ((((0 == forMarshaling->pRasterizationState)) ? (0) : (!((*(forMarshaling->pRasterizationState)).rasterizerDiscardEnable))) || (((0 == forMarshaling->pDynamicState)) ? (0) : (arrayany((*(forMarshaling->pDynamicState)).pDynamicStates, 0, (*(forMarshaling->pDynamicState)).dynamicStateCount, [](VkDynamicState s) { return (s == VK_DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE); }))));
        uint32_t cgen_var_0 = (uint32_t)hasRasterization;
        memcpy((*ptr), &cgen_var_0, 4);
        gfxstream::aemu::Stream::toBe32((uint8_t*)(*ptr));
        *ptr += 4;
    }
    uint32_t hasTessellation = 1;
    if (vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT)
    {
        hasTessellation = arrayany(forMarshaling->pStages, 0, forMarshaling->stageCount, [](VkPipelineShaderStageCreateInfo s) { return ((s.stage == VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT) || (s.stage == VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT)); });
        uint32_t cgen_var_0 = (uint32_t)hasTessellation;
        memcpy((*ptr), &cgen_var_0, 4);
        gfxstream::aemu::Stream::toBe32((uint8_t*)(*ptr));
        *ptr += 4;
    }
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkPipelineCreateFlags*)&forMarshaling->flags, sizeof(VkPipelineCreateFlags));
    *ptr += sizeof(VkPipelineCreateFlags);
    memcpy(*ptr, (uint32_t*)&forMarshaling->stageCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->stageCount; ++i)
    {
        reservedmarshal_VkPipelineShaderStageCreateInfo(vkStream, rootType, (const VkPipelineShaderStageCreateInfo*)(forMarshaling->pStages + i), ptr);
    }
    // WARNING PTR CHECK
    if (vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT)
    {
        uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pVertexInputState;
        memcpy((*ptr), &cgen_var_0, 8);
        gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
        *ptr += 8;
    }
    if ((!(vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT) || forMarshaling->pVertexInputState))
    {
        reservedmarshal_VkPipelineVertexInputStateCreateInfo(vkStream, rootType, (const VkPipelineVertexInputStateCreateInfo*)(forMarshaling->pVertexInputState), ptr);
    }
    // WARNING PTR CHECK
    if (vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT)
    {
        uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pInputAssemblyState;
        memcpy((*ptr), &cgen_var_0, 8);
        gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
        *ptr += 8;
    }
    if ((!(vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT) || forMarshaling->pInputAssemblyState))
    {
        reservedmarshal_VkPipelineInputAssemblyStateCreateInfo(vkStream, rootType, (const VkPipelineInputAssemblyStateCreateInfo*)(forMarshaling->pInputAssemblyState), ptr);
    }
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pTessellationState;
    memcpy((*ptr), &cgen_var_0, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pTessellationState)
    {
        if (hasTessellation)
        {
            reservedmarshal_VkPipelineTessellationStateCreateInfo(vkStream, rootType, (const VkPipelineTessellationStateCreateInfo*)(forMarshaling->pTessellationState), ptr);
        }
    }
    // WARNING PTR CHECK
    uint64_t cgen_var_1 = (uint64_t)(uintptr_t)forMarshaling->pViewportState;
    memcpy((*ptr), &cgen_var_1, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pViewportState)
    {
        if (hasRasterization)
        {
            reservedmarshal_VkPipelineViewportStateCreateInfo(vkStream, rootType, (const VkPipelineViewportStateCreateInfo*)(forMarshaling->pViewportState), ptr);
        }
    }
    // WARNING PTR CHECK
    if (vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT)
    {
        uint64_t cgen_var_1_0 = (uint64_t)(uintptr_t)forMarshaling->pRasterizationState;
        memcpy((*ptr), &cgen_var_1_0, 8);
        gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
        *ptr += 8;
    }
    if ((!(vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT) || forMarshaling->pRasterizationState))
    {
        reservedmarshal_VkPipelineRasterizationStateCreateInfo(vkStream, rootType, (const VkPipelineRasterizationStateCreateInfo*)(forMarshaling->pRasterizationState), ptr);
    }
    // WARNING PTR CHECK
    uint64_t cgen_var_2 = (uint64_t)(uintptr_t)forMarshaling->pMultisampleState;
    memcpy((*ptr), &cgen_var_2, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pMultisampleState)
    {
        if (hasRasterization)
        {
            reservedmarshal_VkPipelineMultisampleStateCreateInfo(vkStream, rootType, (const VkPipelineMultisampleStateCreateInfo*)(forMarshaling->pMultisampleState), ptr);
        }
    }
    // WARNING PTR CHECK
    uint64_t cgen_var_3 = (uint64_t)(uintptr_t)forMarshaling->pDepthStencilState;
    memcpy((*ptr), &cgen_var_3, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pDepthStencilState)
    {
        if (hasRasterization)
        {
            reservedmarshal_VkPipelineDepthStencilStateCreateInfo(vkStream, rootType, (const VkPipelineDepthStencilStateCreateInfo*)(forMarshaling->pDepthStencilState), ptr);
        }
    }
    // WARNING PTR CHECK
    uint64_t cgen_var_4 = (uint64_t)(uintptr_t)forMarshaling->pColorBlendState;
    memcpy((*ptr), &cgen_var_4, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pColorBlendState)
    {
        if (hasRasterization)
        {
            reservedmarshal_VkPipelineColorBlendStateCreateInfo(vkStream, rootType, (const VkPipelineColorBlendStateCreateInfo*)(forMarshaling->pColorBlendState), ptr);
        }
    }
    // WARNING PTR CHECK
    uint64_t cgen_var_5 = (uint64_t)(uintptr_t)forMarshaling->pDynamicState;
    memcpy((*ptr), &cgen_var_5, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pDynamicState)
    {
        reservedmarshal_VkPipelineDynamicStateCreateInfo(vkStream, rootType, (const VkPipelineDynamicStateCreateInfo*)(forMarshaling->pDynamicState), ptr);
    }
    uint64_t cgen_var_6;
    *&cgen_var_6 = get_host_u64_VkPipelineLayout((*&forMarshaling->layout));
    memcpy(*ptr, (uint64_t*)&cgen_var_6, 1 * 8);
    *ptr += 1 * 8;
    uint64_t cgen_var_7;
    *&cgen_var_7 = get_host_u64_VkRenderPass((*&forMarshaling->renderPass));
    memcpy(*ptr, (uint64_t*)&cgen_var_7, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (uint32_t*)&forMarshaling->subpass, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    uint64_t cgen_var_8;
    *&cgen_var_8 = get_host_u64_VkPipeline((*&forMarshaling->basePipelineHandle));
    memcpy(*ptr, (uint64_t*)&cgen_var_8, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (int32_t*)&forMarshaling->basePipelineIndex, sizeof(int32_t));
    *ptr += sizeof(int32_t);
}

void reservedmarshal_VkAttachmentDescription(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkAttachmentDescription* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkAttachmentDescriptionFlags*)&forMarshaling->flags, sizeof(VkAttachmentDescriptionFlags));
    *ptr += sizeof(VkAttachmentDescriptionFlags);
    memcpy(*ptr, (VkFormat*)&forMarshaling->format, sizeof(VkFormat));
    *ptr += sizeof(VkFormat);
    memcpy(*ptr, (VkSampleCountFlagBits*)&forMarshaling->samples, sizeof(VkSampleCountFlagBits));
    *ptr += sizeof(VkSampleCountFlagBits);
    memcpy(*ptr, (VkAttachmentLoadOp*)&forMarshaling->loadOp, sizeof(VkAttachmentLoadOp));
    *ptr += sizeof(VkAttachmentLoadOp);
    memcpy(*ptr, (VkAttachmentStoreOp*)&forMarshaling->storeOp, sizeof(VkAttachmentStoreOp));
    *ptr += sizeof(VkAttachmentStoreOp);
    memcpy(*ptr, (VkAttachmentLoadOp*)&forMarshaling->stencilLoadOp, sizeof(VkAttachmentLoadOp));
    *ptr += sizeof(VkAttachmentLoadOp);
    memcpy(*ptr, (VkAttachmentStoreOp*)&forMarshaling->stencilStoreOp, sizeof(VkAttachmentStoreOp));
    *ptr += sizeof(VkAttachmentStoreOp);
    memcpy(*ptr, (VkImageLayout*)&forMarshaling->initialLayout, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    memcpy(*ptr, (VkImageLayout*)&forMarshaling->finalLayout, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
}

void reservedmarshal_VkAttachmentReference(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkAttachmentReference* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (uint32_t*)&forMarshaling->attachment, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkImageLayout*)&forMarshaling->layout, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
}

void reservedmarshal_VkFramebufferCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkFramebufferCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkFramebufferCreateFlags*)&forMarshaling->flags, sizeof(VkFramebufferCreateFlags));
    *ptr += sizeof(VkFramebufferCreateFlags);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkRenderPass((*&forMarshaling->renderPass));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (uint32_t*)&forMarshaling->attachmentCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    if ((!(vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT) || (((forMarshaling->flags & VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT) == 0))))
    {
        if (forMarshaling->attachmentCount)
        {
            uint8_t* cgen_var_0_0_ptr = (uint8_t*)(*ptr);
            if (forMarshaling)
            {
                for (uint32_t k = 0; k < forMarshaling->attachmentCount; ++k)
                {
                    uint64_t tmpval = get_host_u64_VkImageView(forMarshaling->pAttachments[k]);
                    memcpy(cgen_var_0_0_ptr + k * 8, &tmpval, sizeof(uint64_t));
                }
            }
            *ptr += 8 * forMarshaling->attachmentCount;
        }
    }
    memcpy(*ptr, (uint32_t*)&forMarshaling->width, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->height, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->layers, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkSubpassDescription(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubpassDescription* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkSubpassDescriptionFlags*)&forMarshaling->flags, sizeof(VkSubpassDescriptionFlags));
    *ptr += sizeof(VkSubpassDescriptionFlags);
    memcpy(*ptr, (VkPipelineBindPoint*)&forMarshaling->pipelineBindPoint, sizeof(VkPipelineBindPoint));
    *ptr += sizeof(VkPipelineBindPoint);
    memcpy(*ptr, (uint32_t*)&forMarshaling->inputAttachmentCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->inputAttachmentCount; ++i)
    {
        reservedmarshal_VkAttachmentReference(vkStream, rootType, (const VkAttachmentReference*)(forMarshaling->pInputAttachments + i), ptr);
    }
    memcpy(*ptr, (uint32_t*)&forMarshaling->colorAttachmentCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->colorAttachmentCount; ++i)
    {
        reservedmarshal_VkAttachmentReference(vkStream, rootType, (const VkAttachmentReference*)(forMarshaling->pColorAttachments + i), ptr);
    }
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pResolveAttachments;
    memcpy((*ptr), &cgen_var_0, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pResolveAttachments)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->colorAttachmentCount; ++i)
        {
            reservedmarshal_VkAttachmentReference(vkStream, rootType, (const VkAttachmentReference*)(forMarshaling->pResolveAttachments + i), ptr);
        }
    }
    // WARNING PTR CHECK
    uint64_t cgen_var_1 = (uint64_t)(uintptr_t)forMarshaling->pDepthStencilAttachment;
    memcpy((*ptr), &cgen_var_1, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pDepthStencilAttachment)
    {
        reservedmarshal_VkAttachmentReference(vkStream, rootType, (const VkAttachmentReference*)(forMarshaling->pDepthStencilAttachment), ptr);
    }
    memcpy(*ptr, (uint32_t*)&forMarshaling->preserveAttachmentCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    if (forMarshaling->preserveAttachmentCount > 0)
    {
        memcpy(*ptr, (const uint32_t*)forMarshaling->pPreserveAttachments, forMarshaling->preserveAttachmentCount * sizeof(const uint32_t));
        *ptr += forMarshaling->preserveAttachmentCount * sizeof(const uint32_t);
    }
}

void reservedmarshal_VkSubpassDependency(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubpassDependency* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (uint32_t*)&forMarshaling->srcSubpass, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->dstSubpass, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkPipelineStageFlags*)&forMarshaling->srcStageMask, sizeof(VkPipelineStageFlags));
    *ptr += sizeof(VkPipelineStageFlags);
    memcpy(*ptr, (VkPipelineStageFlags*)&forMarshaling->dstStageMask, sizeof(VkPipelineStageFlags));
    *ptr += sizeof(VkPipelineStageFlags);
    memcpy(*ptr, (VkAccessFlags*)&forMarshaling->srcAccessMask, sizeof(VkAccessFlags));
    *ptr += sizeof(VkAccessFlags);
    memcpy(*ptr, (VkAccessFlags*)&forMarshaling->dstAccessMask, sizeof(VkAccessFlags));
    *ptr += sizeof(VkAccessFlags);
    memcpy(*ptr, (VkDependencyFlags*)&forMarshaling->dependencyFlags, sizeof(VkDependencyFlags));
    *ptr += sizeof(VkDependencyFlags);
}

void reservedmarshal_VkRenderPassCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderPassCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkRenderPassCreateFlags*)&forMarshaling->flags, sizeof(VkRenderPassCreateFlags));
    *ptr += sizeof(VkRenderPassCreateFlags);
    memcpy(*ptr, (uint32_t*)&forMarshaling->attachmentCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->attachmentCount; ++i)
    {
        reservedmarshal_VkAttachmentDescription(vkStream, rootType, (const VkAttachmentDescription*)(forMarshaling->pAttachments + i), ptr);
    }
    memcpy(*ptr, (uint32_t*)&forMarshaling->subpassCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->subpassCount; ++i)
    {
        reservedmarshal_VkSubpassDescription(vkStream, rootType, (const VkSubpassDescription*)(forMarshaling->pSubpasses + i), ptr);
    }
    memcpy(*ptr, (uint32_t*)&forMarshaling->dependencyCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->dependencyCount; ++i)
    {
        reservedmarshal_VkSubpassDependency(vkStream, rootType, (const VkSubpassDependency*)(forMarshaling->pDependencies + i), ptr);
    }
}

void reservedmarshal_VkClearDepthStencilValue(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkClearDepthStencilValue* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (float*)&forMarshaling->depth, sizeof(float));
    *ptr += sizeof(float);
    memcpy(*ptr, (uint32_t*)&forMarshaling->stencil, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkClearValue(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkClearValue* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    reservedmarshal_VkClearColorValue(vkStream, rootType, (VkClearColorValue*)(&forMarshaling->color), ptr);
}

void reservedmarshal_VkClearAttachment(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkClearAttachment* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkImageAspectFlags*)&forMarshaling->aspectMask, sizeof(VkImageAspectFlags));
    *ptr += sizeof(VkImageAspectFlags);
    memcpy(*ptr, (uint32_t*)&forMarshaling->colorAttachment, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    reservedmarshal_VkClearValue(vkStream, rootType, (VkClearValue*)(&forMarshaling->clearValue), ptr);
}

void reservedmarshal_VkClearRect(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkClearRect* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    reservedmarshal_VkRect2D(vkStream, rootType, (VkRect2D*)(&forMarshaling->rect), ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->baseArrayLayer, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->layerCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkImageBlit(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageBlit* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    reservedmarshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forMarshaling->srcSubresource), ptr);
    for (uint32_t i = 0; i < (uint32_t)2; ++i)
    {
        reservedmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(forMarshaling->srcOffsets + i), ptr);
    }
    reservedmarshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forMarshaling->dstSubresource), ptr);
    for (uint32_t i = 0; i < (uint32_t)2; ++i)
    {
        reservedmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(forMarshaling->dstOffsets + i), ptr);
    }
}

void reservedmarshal_VkImageResolve(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageResolve* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    reservedmarshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forMarshaling->srcSubresource), ptr);
    reservedmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forMarshaling->srcOffset), ptr);
    reservedmarshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forMarshaling->dstSubresource), ptr);
    reservedmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forMarshaling->dstOffset), ptr);
    reservedmarshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forMarshaling->extent), ptr);
}

void reservedmarshal_VkRenderPassBeginInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderPassBeginInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkRenderPass((*&forMarshaling->renderPass));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    uint64_t cgen_var_1;
    *&cgen_var_1 = get_host_u64_VkFramebuffer((*&forMarshaling->framebuffer));
    memcpy(*ptr, (uint64_t*)&cgen_var_1, 1 * 8);
    *ptr += 1 * 8;
    reservedmarshal_VkRect2D(vkStream, rootType, (VkRect2D*)(&forMarshaling->renderArea), ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->clearValueCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    // WARNING PTR CHECK
    uint64_t cgen_var_2 = (uint64_t)(uintptr_t)forMarshaling->pClearValues;
    memcpy((*ptr), &cgen_var_2, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pClearValues)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->clearValueCount; ++i)
        {
            reservedmarshal_VkClearValue(vkStream, rootType, (const VkClearValue*)(forMarshaling->pClearValues + i), ptr);
        }
    }
}

#endif
#ifdef VK_BASE_VERSION_1_1
void reservedmarshal_VkBindBufferMemoryInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBindBufferMemoryInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkBuffer((*&forMarshaling->buffer));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    uint64_t cgen_var_1;
    *&cgen_var_1 = get_host_u64_VkDeviceMemory((*&forMarshaling->memory));
    memcpy(*ptr, (uint64_t*)&cgen_var_1, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->memoryOffset, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
}

void reservedmarshal_VkBindImageMemoryInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBindImageMemoryInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkImage((*&forMarshaling->image));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    uint64_t cgen_var_1;
    *&cgen_var_1 = get_host_u64_VkDeviceMemory((*&forMarshaling->memory));
    memcpy(*ptr, (uint64_t*)&cgen_var_1, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->memoryOffset, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
}

void reservedmarshal_VkMemoryDedicatedRequirements(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryDedicatedRequirements* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->prefersDedicatedAllocation, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->requiresDedicatedAllocation, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkMemoryDedicatedAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryDedicatedAllocateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkImage((*&forMarshaling->image));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    uint64_t cgen_var_1;
    *&cgen_var_1 = get_host_u64_VkBuffer((*&forMarshaling->buffer));
    memcpy(*ptr, (uint64_t*)&cgen_var_1, 1 * 8);
    *ptr += 1 * 8;
}

void reservedmarshal_VkMemoryAllocateFlagsInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryAllocateFlagsInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkMemoryAllocateFlags*)&forMarshaling->flags, sizeof(VkMemoryAllocateFlags));
    *ptr += sizeof(VkMemoryAllocateFlags);
    memcpy(*ptr, (uint32_t*)&forMarshaling->deviceMask, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkDeviceGroupCommandBufferBeginInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceGroupCommandBufferBeginInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->deviceMask, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkDeviceGroupSubmitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceGroupSubmitInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->waitSemaphoreCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    if (forMarshaling->waitSemaphoreCount > 0)
    {
        memcpy(*ptr, (const uint32_t*)forMarshaling->pWaitSemaphoreDeviceIndices, forMarshaling->waitSemaphoreCount * sizeof(const uint32_t));
        *ptr += forMarshaling->waitSemaphoreCount * sizeof(const uint32_t);
    }
    memcpy(*ptr, (uint32_t*)&forMarshaling->commandBufferCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    if (forMarshaling->commandBufferCount > 0)
    {
        memcpy(*ptr, (const uint32_t*)forMarshaling->pCommandBufferDeviceMasks, forMarshaling->commandBufferCount * sizeof(const uint32_t));
        *ptr += forMarshaling->commandBufferCount * sizeof(const uint32_t);
    }
    memcpy(*ptr, (uint32_t*)&forMarshaling->signalSemaphoreCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    if (forMarshaling->signalSemaphoreCount > 0)
    {
        memcpy(*ptr, (const uint32_t*)forMarshaling->pSignalSemaphoreDeviceIndices, forMarshaling->signalSemaphoreCount * sizeof(const uint32_t));
        *ptr += forMarshaling->signalSemaphoreCount * sizeof(const uint32_t);
    }
}

void reservedmarshal_VkDeviceGroupBindSparseInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceGroupBindSparseInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->resourceDeviceIndex, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->memoryDeviceIndex, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkBindBufferMemoryDeviceGroupInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBindBufferMemoryDeviceGroupInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->deviceIndexCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    if (forMarshaling->deviceIndexCount > 0)
    {
        memcpy(*ptr, (const uint32_t*)forMarshaling->pDeviceIndices, forMarshaling->deviceIndexCount * sizeof(const uint32_t));
        *ptr += forMarshaling->deviceIndexCount * sizeof(const uint32_t);
    }
}

void reservedmarshal_VkBindImageMemoryDeviceGroupInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBindImageMemoryDeviceGroupInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->deviceIndexCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    if (forMarshaling->deviceIndexCount > 0)
    {
        memcpy(*ptr, (const uint32_t*)forMarshaling->pDeviceIndices, forMarshaling->deviceIndexCount * sizeof(const uint32_t));
        *ptr += forMarshaling->deviceIndexCount * sizeof(const uint32_t);
    }
    memcpy(*ptr, (uint32_t*)&forMarshaling->splitInstanceBindRegionCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->splitInstanceBindRegionCount; ++i)
    {
        reservedmarshal_VkRect2D(vkStream, rootType, (const VkRect2D*)(forMarshaling->pSplitInstanceBindRegions + i), ptr);
    }
}

void reservedmarshal_VkPhysicalDeviceGroupProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceGroupProperties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->physicalDeviceCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkPhysicalDevice*)forMarshaling->physicalDevices, VK_MAX_DEVICE_GROUP_SIZE * sizeof(VkPhysicalDevice));
    *ptr += VK_MAX_DEVICE_GROUP_SIZE * sizeof(VkPhysicalDevice);
    memcpy(*ptr, (VkBool32*)&forMarshaling->subsetAllocation, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkDeviceGroupDeviceCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceGroupDeviceCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->physicalDeviceCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    if (forMarshaling->physicalDeviceCount)
    {
        uint8_t* cgen_var_0_ptr = (uint8_t*)(*ptr);
        if (forMarshaling)
        {
            for (uint32_t k = 0; k < forMarshaling->physicalDeviceCount; ++k)
            {
                uint64_t tmpval = get_host_u64_VkPhysicalDevice(forMarshaling->pPhysicalDevices[k]);
                memcpy(cgen_var_0_ptr + k * 8, &tmpval, sizeof(uint64_t));
            }
        }
        *ptr += 8 * forMarshaling->physicalDeviceCount;
    }
}

void reservedmarshal_VkBufferMemoryRequirementsInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferMemoryRequirementsInfo2* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkBuffer((*&forMarshaling->buffer));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
}

void reservedmarshal_VkImageMemoryRequirementsInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageMemoryRequirementsInfo2* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkImage((*&forMarshaling->image));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
}

void reservedmarshal_VkImageSparseMemoryRequirementsInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageSparseMemoryRequirementsInfo2* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkImage((*&forMarshaling->image));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
}

void reservedmarshal_VkMemoryRequirements2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryRequirements2* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    reservedmarshal_VkMemoryRequirements(vkStream, rootType, (VkMemoryRequirements*)(&forMarshaling->memoryRequirements), ptr);
}

void reservedmarshal_VkSparseImageMemoryRequirements2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSparseImageMemoryRequirements2* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    reservedmarshal_VkSparseImageMemoryRequirements(vkStream, rootType, (VkSparseImageMemoryRequirements*)(&forMarshaling->memoryRequirements), ptr);
}

void reservedmarshal_VkPhysicalDeviceFeatures2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceFeatures2* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    reservedmarshal_VkPhysicalDeviceFeatures(vkStream, rootType, (VkPhysicalDeviceFeatures*)(&forMarshaling->features), ptr);
}

void reservedmarshal_VkPhysicalDeviceProperties2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceProperties2* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    reservedmarshal_VkPhysicalDeviceProperties(vkStream, rootType, (VkPhysicalDeviceProperties*)(&forMarshaling->properties), ptr);
}

void reservedmarshal_VkFormatProperties2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkFormatProperties2* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    reservedmarshal_VkFormatProperties(vkStream, rootType, (VkFormatProperties*)(&forMarshaling->formatProperties), ptr);
}

void reservedmarshal_VkImageFormatProperties2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageFormatProperties2* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    reservedmarshal_VkImageFormatProperties(vkStream, rootType, (VkImageFormatProperties*)(&forMarshaling->imageFormatProperties), ptr);
}

void reservedmarshal_VkPhysicalDeviceImageFormatInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceImageFormatInfo2* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkFormat*)&forMarshaling->format, sizeof(VkFormat));
    *ptr += sizeof(VkFormat);
    memcpy(*ptr, (VkImageType*)&forMarshaling->type, sizeof(VkImageType));
    *ptr += sizeof(VkImageType);
    memcpy(*ptr, (VkImageTiling*)&forMarshaling->tiling, sizeof(VkImageTiling));
    *ptr += sizeof(VkImageTiling);
    memcpy(*ptr, (VkImageUsageFlags*)&forMarshaling->usage, sizeof(VkImageUsageFlags));
    *ptr += sizeof(VkImageUsageFlags);
    memcpy(*ptr, (VkImageCreateFlags*)&forMarshaling->flags, sizeof(VkImageCreateFlags));
    *ptr += sizeof(VkImageCreateFlags);
}

void reservedmarshal_VkQueueFamilyProperties2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkQueueFamilyProperties2* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    reservedmarshal_VkQueueFamilyProperties(vkStream, rootType, (VkQueueFamilyProperties*)(&forMarshaling->queueFamilyProperties), ptr);
}

void reservedmarshal_VkPhysicalDeviceMemoryProperties2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMemoryProperties2* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    reservedmarshal_VkPhysicalDeviceMemoryProperties(vkStream, rootType, (VkPhysicalDeviceMemoryProperties*)(&forMarshaling->memoryProperties), ptr);
}

void reservedmarshal_VkSparseImageFormatProperties2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSparseImageFormatProperties2* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    reservedmarshal_VkSparseImageFormatProperties(vkStream, rootType, (VkSparseImageFormatProperties*)(&forMarshaling->properties), ptr);
}

void reservedmarshal_VkPhysicalDeviceSparseImageFormatInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceSparseImageFormatInfo2* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkFormat*)&forMarshaling->format, sizeof(VkFormat));
    *ptr += sizeof(VkFormat);
    memcpy(*ptr, (VkImageType*)&forMarshaling->type, sizeof(VkImageType));
    *ptr += sizeof(VkImageType);
    memcpy(*ptr, (VkSampleCountFlagBits*)&forMarshaling->samples, sizeof(VkSampleCountFlagBits));
    *ptr += sizeof(VkSampleCountFlagBits);
    memcpy(*ptr, (VkImageUsageFlags*)&forMarshaling->usage, sizeof(VkImageUsageFlags));
    *ptr += sizeof(VkImageUsageFlags);
    memcpy(*ptr, (VkImageTiling*)&forMarshaling->tiling, sizeof(VkImageTiling));
    *ptr += sizeof(VkImageTiling);
}

void reservedmarshal_VkImageViewUsageCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageViewUsageCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkImageUsageFlags*)&forMarshaling->usage, sizeof(VkImageUsageFlags));
    *ptr += sizeof(VkImageUsageFlags);
}

void reservedmarshal_VkPhysicalDeviceProtectedMemoryFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceProtectedMemoryFeatures* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->protectedMemory, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDeviceProtectedMemoryProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceProtectedMemoryProperties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->protectedNoFault, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkDeviceQueueInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceQueueInfo2* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkDeviceQueueCreateFlags*)&forMarshaling->flags, sizeof(VkDeviceQueueCreateFlags));
    *ptr += sizeof(VkDeviceQueueCreateFlags);
    memcpy(*ptr, (uint32_t*)&forMarshaling->queueFamilyIndex, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->queueIndex, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkProtectedSubmitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkProtectedSubmitInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->protectedSubmit, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkBindImagePlaneMemoryInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBindImagePlaneMemoryInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkImageAspectFlagBits*)&forMarshaling->planeAspect, sizeof(VkImageAspectFlagBits));
    *ptr += sizeof(VkImageAspectFlagBits);
}

void reservedmarshal_VkImagePlaneMemoryRequirementsInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImagePlaneMemoryRequirementsInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkImageAspectFlagBits*)&forMarshaling->planeAspect, sizeof(VkImageAspectFlagBits));
    *ptr += sizeof(VkImageAspectFlagBits);
}

void reservedmarshal_VkExternalMemoryProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExternalMemoryProperties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkExternalMemoryFeatureFlags*)&forMarshaling->externalMemoryFeatures, sizeof(VkExternalMemoryFeatureFlags));
    *ptr += sizeof(VkExternalMemoryFeatureFlags);
    memcpy(*ptr, (VkExternalMemoryHandleTypeFlags*)&forMarshaling->exportFromImportedHandleTypes, sizeof(VkExternalMemoryHandleTypeFlags));
    *ptr += sizeof(VkExternalMemoryHandleTypeFlags);
    memcpy(*ptr, (VkExternalMemoryHandleTypeFlags*)&forMarshaling->compatibleHandleTypes, sizeof(VkExternalMemoryHandleTypeFlags));
    *ptr += sizeof(VkExternalMemoryHandleTypeFlags);
}

void reservedmarshal_VkPhysicalDeviceExternalImageFormatInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceExternalImageFormatInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkExternalMemoryHandleTypeFlagBits*)&forMarshaling->handleType, sizeof(VkExternalMemoryHandleTypeFlagBits));
    *ptr += sizeof(VkExternalMemoryHandleTypeFlagBits);
}

void reservedmarshal_VkExternalImageFormatProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExternalImageFormatProperties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    reservedmarshal_VkExternalMemoryProperties(vkStream, rootType, (VkExternalMemoryProperties*)(&forMarshaling->externalMemoryProperties), ptr);
}

void reservedmarshal_VkPhysicalDeviceExternalBufferInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceExternalBufferInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBufferCreateFlags*)&forMarshaling->flags, sizeof(VkBufferCreateFlags));
    *ptr += sizeof(VkBufferCreateFlags);
    memcpy(*ptr, (VkBufferUsageFlags*)&forMarshaling->usage, sizeof(VkBufferUsageFlags));
    *ptr += sizeof(VkBufferUsageFlags);
    memcpy(*ptr, (VkExternalMemoryHandleTypeFlagBits*)&forMarshaling->handleType, sizeof(VkExternalMemoryHandleTypeFlagBits));
    *ptr += sizeof(VkExternalMemoryHandleTypeFlagBits);
}

void reservedmarshal_VkExternalBufferProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExternalBufferProperties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    reservedmarshal_VkExternalMemoryProperties(vkStream, rootType, (VkExternalMemoryProperties*)(&forMarshaling->externalMemoryProperties), ptr);
}

void reservedmarshal_VkPhysicalDeviceIDProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceIDProperties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint8_t*)forMarshaling->deviceUUID, VK_UUID_SIZE * sizeof(uint8_t));
    *ptr += VK_UUID_SIZE * sizeof(uint8_t);
    memcpy(*ptr, (uint8_t*)forMarshaling->driverUUID, VK_UUID_SIZE * sizeof(uint8_t));
    *ptr += VK_UUID_SIZE * sizeof(uint8_t);
    memcpy(*ptr, (uint8_t*)forMarshaling->deviceLUID, VK_LUID_SIZE * sizeof(uint8_t));
    *ptr += VK_LUID_SIZE * sizeof(uint8_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->deviceNodeMask, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkBool32*)&forMarshaling->deviceLUIDValid, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkExternalMemoryImageCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExternalMemoryImageCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkExternalMemoryHandleTypeFlags*)&forMarshaling->handleTypes, sizeof(VkExternalMemoryHandleTypeFlags));
    *ptr += sizeof(VkExternalMemoryHandleTypeFlags);
}

void reservedmarshal_VkExternalMemoryBufferCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExternalMemoryBufferCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkExternalMemoryHandleTypeFlags*)&forMarshaling->handleTypes, sizeof(VkExternalMemoryHandleTypeFlags));
    *ptr += sizeof(VkExternalMemoryHandleTypeFlags);
}

void reservedmarshal_VkExportMemoryAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExportMemoryAllocateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkExternalMemoryHandleTypeFlags*)&forMarshaling->handleTypes, sizeof(VkExternalMemoryHandleTypeFlags));
    *ptr += sizeof(VkExternalMemoryHandleTypeFlags);
}

void reservedmarshal_VkPhysicalDeviceExternalFenceInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceExternalFenceInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkExternalFenceHandleTypeFlagBits*)&forMarshaling->handleType, sizeof(VkExternalFenceHandleTypeFlagBits));
    *ptr += sizeof(VkExternalFenceHandleTypeFlagBits);
}

void reservedmarshal_VkExternalFenceProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExternalFenceProperties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkExternalFenceHandleTypeFlags*)&forMarshaling->exportFromImportedHandleTypes, sizeof(VkExternalFenceHandleTypeFlags));
    *ptr += sizeof(VkExternalFenceHandleTypeFlags);
    memcpy(*ptr, (VkExternalFenceHandleTypeFlags*)&forMarshaling->compatibleHandleTypes, sizeof(VkExternalFenceHandleTypeFlags));
    *ptr += sizeof(VkExternalFenceHandleTypeFlags);
    memcpy(*ptr, (VkExternalFenceFeatureFlags*)&forMarshaling->externalFenceFeatures, sizeof(VkExternalFenceFeatureFlags));
    *ptr += sizeof(VkExternalFenceFeatureFlags);
}

void reservedmarshal_VkExportFenceCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExportFenceCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkExternalFenceHandleTypeFlags*)&forMarshaling->handleTypes, sizeof(VkExternalFenceHandleTypeFlags));
    *ptr += sizeof(VkExternalFenceHandleTypeFlags);
}

void reservedmarshal_VkExportSemaphoreCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExportSemaphoreCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkExternalSemaphoreHandleTypeFlags*)&forMarshaling->handleTypes, sizeof(VkExternalSemaphoreHandleTypeFlags));
    *ptr += sizeof(VkExternalSemaphoreHandleTypeFlags);
}

void reservedmarshal_VkPhysicalDeviceExternalSemaphoreInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceExternalSemaphoreInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkExternalSemaphoreHandleTypeFlagBits*)&forMarshaling->handleType, sizeof(VkExternalSemaphoreHandleTypeFlagBits));
    *ptr += sizeof(VkExternalSemaphoreHandleTypeFlagBits);
}

void reservedmarshal_VkExternalSemaphoreProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExternalSemaphoreProperties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkExternalSemaphoreHandleTypeFlags*)&forMarshaling->exportFromImportedHandleTypes, sizeof(VkExternalSemaphoreHandleTypeFlags));
    *ptr += sizeof(VkExternalSemaphoreHandleTypeFlags);
    memcpy(*ptr, (VkExternalSemaphoreHandleTypeFlags*)&forMarshaling->compatibleHandleTypes, sizeof(VkExternalSemaphoreHandleTypeFlags));
    *ptr += sizeof(VkExternalSemaphoreHandleTypeFlags);
    memcpy(*ptr, (VkExternalSemaphoreFeatureFlags*)&forMarshaling->externalSemaphoreFeatures, sizeof(VkExternalSemaphoreFeatureFlags));
    *ptr += sizeof(VkExternalSemaphoreFeatureFlags);
}

#endif
#ifdef VK_COMPUTE_VERSION_1_1
void reservedmarshal_VkPhysicalDeviceSubgroupProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceSubgroupProperties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->subgroupSize, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkShaderStageFlags*)&forMarshaling->supportedStages, sizeof(VkShaderStageFlags));
    *ptr += sizeof(VkShaderStageFlags);
    memcpy(*ptr, (VkSubgroupFeatureFlags*)&forMarshaling->supportedOperations, sizeof(VkSubgroupFeatureFlags));
    *ptr += sizeof(VkSubgroupFeatureFlags);
    memcpy(*ptr, (VkBool32*)&forMarshaling->quadOperationsInAllStages, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDevice16BitStorageFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevice16BitStorageFeatures* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->storageBuffer16BitAccess, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->uniformAndStorageBuffer16BitAccess, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->storagePushConstant16, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->storageInputOutput16, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDeviceVariablePointersFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVariablePointersFeatures* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->variablePointersStorageBuffer, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->variablePointers, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkDescriptorUpdateTemplateEntry(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorUpdateTemplateEntry* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (uint32_t*)&forMarshaling->dstBinding, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->dstArrayElement, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->descriptorCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkDescriptorType*)&forMarshaling->descriptorType, sizeof(VkDescriptorType));
    *ptr += sizeof(VkDescriptorType);
    uint64_t cgen_var_0 = (uint64_t)forMarshaling->offset;
    memcpy((*ptr), &cgen_var_0, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    uint64_t cgen_var_1 = (uint64_t)forMarshaling->stride;
    memcpy((*ptr), &cgen_var_1, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
}

void reservedmarshal_VkDescriptorUpdateTemplateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorUpdateTemplateCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkDescriptorUpdateTemplateCreateFlags*)&forMarshaling->flags, sizeof(VkDescriptorUpdateTemplateCreateFlags));
    *ptr += sizeof(VkDescriptorUpdateTemplateCreateFlags);
    memcpy(*ptr, (uint32_t*)&forMarshaling->descriptorUpdateEntryCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->descriptorUpdateEntryCount; ++i)
    {
        reservedmarshal_VkDescriptorUpdateTemplateEntry(vkStream, rootType, (const VkDescriptorUpdateTemplateEntry*)(forMarshaling->pDescriptorUpdateEntries + i), ptr);
    }
    memcpy(*ptr, (VkDescriptorUpdateTemplateType*)&forMarshaling->templateType, sizeof(VkDescriptorUpdateTemplateType));
    *ptr += sizeof(VkDescriptorUpdateTemplateType);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkDescriptorSetLayout((*&forMarshaling->descriptorSetLayout));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (VkPipelineBindPoint*)&forMarshaling->pipelineBindPoint, sizeof(VkPipelineBindPoint));
    *ptr += sizeof(VkPipelineBindPoint);
    uint64_t cgen_var_1;
    *&cgen_var_1 = get_host_u64_VkPipelineLayout((*&forMarshaling->pipelineLayout));
    memcpy(*ptr, (uint64_t*)&cgen_var_1, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (uint32_t*)&forMarshaling->set, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkPhysicalDeviceMaintenance3Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance3Properties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxPerSetDescriptors, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->maxMemoryAllocationSize, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
}

void reservedmarshal_VkDescriptorSetLayoutSupport(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorSetLayoutSupport* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->supported, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkSamplerYcbcrConversionCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSamplerYcbcrConversionCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkFormat*)&forMarshaling->format, sizeof(VkFormat));
    *ptr += sizeof(VkFormat);
    memcpy(*ptr, (VkSamplerYcbcrModelConversion*)&forMarshaling->ycbcrModel, sizeof(VkSamplerYcbcrModelConversion));
    *ptr += sizeof(VkSamplerYcbcrModelConversion);
    memcpy(*ptr, (VkSamplerYcbcrRange*)&forMarshaling->ycbcrRange, sizeof(VkSamplerYcbcrRange));
    *ptr += sizeof(VkSamplerYcbcrRange);
    reservedmarshal_VkComponentMapping(vkStream, rootType, (VkComponentMapping*)(&forMarshaling->components), ptr);
    memcpy(*ptr, (VkChromaLocation*)&forMarshaling->xChromaOffset, sizeof(VkChromaLocation));
    *ptr += sizeof(VkChromaLocation);
    memcpy(*ptr, (VkChromaLocation*)&forMarshaling->yChromaOffset, sizeof(VkChromaLocation));
    *ptr += sizeof(VkChromaLocation);
    memcpy(*ptr, (VkFilter*)&forMarshaling->chromaFilter, sizeof(VkFilter));
    *ptr += sizeof(VkFilter);
    memcpy(*ptr, (VkBool32*)&forMarshaling->forceExplicitReconstruction, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkSamplerYcbcrConversionInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSamplerYcbcrConversionInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkSamplerYcbcrConversion((*&forMarshaling->conversion));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
}

void reservedmarshal_VkPhysicalDeviceSamplerYcbcrConversionFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceSamplerYcbcrConversionFeatures* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->samplerYcbcrConversion, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkSamplerYcbcrConversionImageFormatProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSamplerYcbcrConversionImageFormatProperties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->combinedImageSamplerDescriptorCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

#endif
#ifdef VK_GRAPHICS_VERSION_1_1
void reservedmarshal_VkDeviceGroupRenderPassBeginInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceGroupRenderPassBeginInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->deviceMask, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->deviceRenderAreaCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->deviceRenderAreaCount; ++i)
    {
        reservedmarshal_VkRect2D(vkStream, rootType, (const VkRect2D*)(forMarshaling->pDeviceRenderAreas + i), ptr);
    }
}

void reservedmarshal_VkPhysicalDevicePointClippingProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevicePointClippingProperties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkPointClippingBehavior*)&forMarshaling->pointClippingBehavior, sizeof(VkPointClippingBehavior));
    *ptr += sizeof(VkPointClippingBehavior);
}

void reservedmarshal_VkInputAttachmentAspectReference(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkInputAttachmentAspectReference* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (uint32_t*)&forMarshaling->subpass, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->inputAttachmentIndex, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkImageAspectFlags*)&forMarshaling->aspectMask, sizeof(VkImageAspectFlags));
    *ptr += sizeof(VkImageAspectFlags);
}

void reservedmarshal_VkRenderPassInputAttachmentAspectCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderPassInputAttachmentAspectCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->aspectReferenceCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->aspectReferenceCount; ++i)
    {
        reservedmarshal_VkInputAttachmentAspectReference(vkStream, rootType, (const VkInputAttachmentAspectReference*)(forMarshaling->pAspectReferences + i), ptr);
    }
}

void reservedmarshal_VkPipelineTessellationDomainOriginStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineTessellationDomainOriginStateCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkTessellationDomainOrigin*)&forMarshaling->domainOrigin, sizeof(VkTessellationDomainOrigin));
    *ptr += sizeof(VkTessellationDomainOrigin);
}

void reservedmarshal_VkRenderPassMultiviewCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderPassMultiviewCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->subpassCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    if (forMarshaling->subpassCount > 0)
    {
        memcpy(*ptr, (const uint32_t*)forMarshaling->pViewMasks, forMarshaling->subpassCount * sizeof(const uint32_t));
        *ptr += forMarshaling->subpassCount * sizeof(const uint32_t);
    }
    memcpy(*ptr, (uint32_t*)&forMarshaling->dependencyCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    if (forMarshaling->dependencyCount > 0)
    {
        memcpy(*ptr, (const int32_t*)forMarshaling->pViewOffsets, forMarshaling->dependencyCount * sizeof(const int32_t));
        *ptr += forMarshaling->dependencyCount * sizeof(const int32_t);
    }
    memcpy(*ptr, (uint32_t*)&forMarshaling->correlationMaskCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    if (forMarshaling->correlationMaskCount > 0)
    {
        memcpy(*ptr, (const uint32_t*)forMarshaling->pCorrelationMasks, forMarshaling->correlationMaskCount * sizeof(const uint32_t));
        *ptr += forMarshaling->correlationMaskCount * sizeof(const uint32_t);
    }
}

void reservedmarshal_VkPhysicalDeviceMultiviewFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMultiviewFeatures* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->multiview, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->multiviewGeometryShader, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->multiviewTessellationShader, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDeviceMultiviewProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMultiviewProperties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxMultiviewViewCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxMultiviewInstanceIndex, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkPhysicalDeviceShaderDrawParametersFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderDrawParametersFeatures* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderDrawParameters, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

#endif
#ifdef VK_BASE_VERSION_1_2
void reservedmarshal_VkPhysicalDeviceVulkan11Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan11Features* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->storageBuffer16BitAccess, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->uniformAndStorageBuffer16BitAccess, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->storagePushConstant16, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->storageInputOutput16, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->multiview, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->multiviewGeometryShader, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->multiviewTessellationShader, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->variablePointersStorageBuffer, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->variablePointers, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->protectedMemory, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->samplerYcbcrConversion, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderDrawParameters, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDeviceVulkan11Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan11Properties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint8_t*)forMarshaling->deviceUUID, VK_UUID_SIZE * sizeof(uint8_t));
    *ptr += VK_UUID_SIZE * sizeof(uint8_t);
    memcpy(*ptr, (uint8_t*)forMarshaling->driverUUID, VK_UUID_SIZE * sizeof(uint8_t));
    *ptr += VK_UUID_SIZE * sizeof(uint8_t);
    memcpy(*ptr, (uint8_t*)forMarshaling->deviceLUID, VK_LUID_SIZE * sizeof(uint8_t));
    *ptr += VK_LUID_SIZE * sizeof(uint8_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->deviceNodeMask, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkBool32*)&forMarshaling->deviceLUIDValid, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (uint32_t*)&forMarshaling->subgroupSize, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkShaderStageFlags*)&forMarshaling->subgroupSupportedStages, sizeof(VkShaderStageFlags));
    *ptr += sizeof(VkShaderStageFlags);
    memcpy(*ptr, (VkSubgroupFeatureFlags*)&forMarshaling->subgroupSupportedOperations, sizeof(VkSubgroupFeatureFlags));
    *ptr += sizeof(VkSubgroupFeatureFlags);
    memcpy(*ptr, (VkBool32*)&forMarshaling->subgroupQuadOperationsInAllStages, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkPointClippingBehavior*)&forMarshaling->pointClippingBehavior, sizeof(VkPointClippingBehavior));
    *ptr += sizeof(VkPointClippingBehavior);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxMultiviewViewCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxMultiviewInstanceIndex, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkBool32*)&forMarshaling->protectedNoFault, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxPerSetDescriptors, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->maxMemoryAllocationSize, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
}

void reservedmarshal_VkPhysicalDeviceVulkan12Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan12Features* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->samplerMirrorClampToEdge, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->drawIndirectCount, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->storageBuffer8BitAccess, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->uniformAndStorageBuffer8BitAccess, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->storagePushConstant8, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderBufferInt64Atomics, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderSharedInt64Atomics, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderFloat16, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderInt8, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->descriptorIndexing, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderInputAttachmentArrayDynamicIndexing, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderUniformTexelBufferArrayDynamicIndexing, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderStorageTexelBufferArrayDynamicIndexing, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderUniformBufferArrayNonUniformIndexing, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderSampledImageArrayNonUniformIndexing, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderStorageBufferArrayNonUniformIndexing, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderStorageImageArrayNonUniformIndexing, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderInputAttachmentArrayNonUniformIndexing, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderUniformTexelBufferArrayNonUniformIndexing, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderStorageTexelBufferArrayNonUniformIndexing, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->descriptorBindingUniformBufferUpdateAfterBind, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->descriptorBindingSampledImageUpdateAfterBind, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->descriptorBindingStorageImageUpdateAfterBind, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->descriptorBindingStorageBufferUpdateAfterBind, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->descriptorBindingUniformTexelBufferUpdateAfterBind, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->descriptorBindingStorageTexelBufferUpdateAfterBind, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->descriptorBindingUpdateUnusedWhilePending, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->descriptorBindingPartiallyBound, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->descriptorBindingVariableDescriptorCount, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->runtimeDescriptorArray, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->samplerFilterMinmax, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->scalarBlockLayout, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->imagelessFramebuffer, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->uniformBufferStandardLayout, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderSubgroupExtendedTypes, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->separateDepthStencilLayouts, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->hostQueryReset, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->timelineSemaphore, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->bufferDeviceAddress, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->bufferDeviceAddressCaptureReplay, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->bufferDeviceAddressMultiDevice, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->vulkanMemoryModel, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->vulkanMemoryModelDeviceScope, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->vulkanMemoryModelAvailabilityVisibilityChains, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderOutputViewportIndex, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderOutputLayer, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->subgroupBroadcastDynamicId, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkConformanceVersion(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkConformanceVersion* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (uint8_t*)&forMarshaling->major, sizeof(uint8_t));
    *ptr += sizeof(uint8_t);
    memcpy(*ptr, (uint8_t*)&forMarshaling->minor, sizeof(uint8_t));
    *ptr += sizeof(uint8_t);
    memcpy(*ptr, (uint8_t*)&forMarshaling->subminor, sizeof(uint8_t));
    *ptr += sizeof(uint8_t);
    memcpy(*ptr, (uint8_t*)&forMarshaling->patch, sizeof(uint8_t));
    *ptr += sizeof(uint8_t);
}

void reservedmarshal_VkPhysicalDeviceVulkan12Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan12Properties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkDriverId*)&forMarshaling->driverID, sizeof(VkDriverId));
    *ptr += sizeof(VkDriverId);
    memcpy(*ptr, (char*)forMarshaling->driverName, VK_MAX_DRIVER_NAME_SIZE * sizeof(char));
    *ptr += VK_MAX_DRIVER_NAME_SIZE * sizeof(char);
    memcpy(*ptr, (char*)forMarshaling->driverInfo, VK_MAX_DRIVER_INFO_SIZE * sizeof(char));
    *ptr += VK_MAX_DRIVER_INFO_SIZE * sizeof(char);
    reservedmarshal_VkConformanceVersion(vkStream, rootType, (VkConformanceVersion*)(&forMarshaling->conformanceVersion), ptr);
    memcpy(*ptr, (VkShaderFloatControlsIndependence*)&forMarshaling->denormBehaviorIndependence, sizeof(VkShaderFloatControlsIndependence));
    *ptr += sizeof(VkShaderFloatControlsIndependence);
    memcpy(*ptr, (VkShaderFloatControlsIndependence*)&forMarshaling->roundingModeIndependence, sizeof(VkShaderFloatControlsIndependence));
    *ptr += sizeof(VkShaderFloatControlsIndependence);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderSignedZeroInfNanPreserveFloat16, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderSignedZeroInfNanPreserveFloat32, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderSignedZeroInfNanPreserveFloat64, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderDenormPreserveFloat16, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderDenormPreserveFloat32, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderDenormPreserveFloat64, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderDenormFlushToZeroFloat16, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderDenormFlushToZeroFloat32, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderDenormFlushToZeroFloat64, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderRoundingModeRTEFloat16, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderRoundingModeRTEFloat32, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderRoundingModeRTEFloat64, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderRoundingModeRTZFloat16, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderRoundingModeRTZFloat32, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderRoundingModeRTZFloat64, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxUpdateAfterBindDescriptorsInAllPools, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderUniformBufferArrayNonUniformIndexingNative, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderSampledImageArrayNonUniformIndexingNative, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderStorageBufferArrayNonUniformIndexingNative, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderStorageImageArrayNonUniformIndexingNative, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderInputAttachmentArrayNonUniformIndexingNative, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->robustBufferAccessUpdateAfterBind, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->quadDivergentImplicitLod, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxPerStageDescriptorUpdateAfterBindSamplers, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxPerStageDescriptorUpdateAfterBindUniformBuffers, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxPerStageDescriptorUpdateAfterBindStorageBuffers, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxPerStageDescriptorUpdateAfterBindSampledImages, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxPerStageDescriptorUpdateAfterBindStorageImages, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxPerStageDescriptorUpdateAfterBindInputAttachments, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxPerStageUpdateAfterBindResources, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxDescriptorSetUpdateAfterBindSamplers, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxDescriptorSetUpdateAfterBindUniformBuffers, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxDescriptorSetUpdateAfterBindStorageBuffers, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxDescriptorSetUpdateAfterBindSampledImages, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxDescriptorSetUpdateAfterBindStorageImages, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxDescriptorSetUpdateAfterBindInputAttachments, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkResolveModeFlags*)&forMarshaling->supportedDepthResolveModes, sizeof(VkResolveModeFlags));
    *ptr += sizeof(VkResolveModeFlags);
    memcpy(*ptr, (VkResolveModeFlags*)&forMarshaling->supportedStencilResolveModes, sizeof(VkResolveModeFlags));
    *ptr += sizeof(VkResolveModeFlags);
    memcpy(*ptr, (VkBool32*)&forMarshaling->independentResolveNone, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->independentResolve, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->filterMinmaxSingleComponentFormats, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->filterMinmaxImageComponentMapping, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (uint64_t*)&forMarshaling->maxTimelineSemaphoreValueDifference, sizeof(uint64_t));
    *ptr += sizeof(uint64_t);
    memcpy(*ptr, (VkSampleCountFlags*)&forMarshaling->framebufferIntegerColorSampleCounts, sizeof(VkSampleCountFlags));
    *ptr += sizeof(VkSampleCountFlags);
}

void reservedmarshal_VkImageFormatListCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageFormatListCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->viewFormatCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    if (forMarshaling->viewFormatCount > 0)
    {
        memcpy(*ptr, (const VkFormat*)forMarshaling->pViewFormats, forMarshaling->viewFormatCount * sizeof(const VkFormat));
        *ptr += forMarshaling->viewFormatCount * sizeof(const VkFormat);
    }
}

void reservedmarshal_VkPhysicalDeviceDriverProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceDriverProperties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkDriverId*)&forMarshaling->driverID, sizeof(VkDriverId));
    *ptr += sizeof(VkDriverId);
    memcpy(*ptr, (char*)forMarshaling->driverName, VK_MAX_DRIVER_NAME_SIZE * sizeof(char));
    *ptr += VK_MAX_DRIVER_NAME_SIZE * sizeof(char);
    memcpy(*ptr, (char*)forMarshaling->driverInfo, VK_MAX_DRIVER_INFO_SIZE * sizeof(char));
    *ptr += VK_MAX_DRIVER_INFO_SIZE * sizeof(char);
    reservedmarshal_VkConformanceVersion(vkStream, rootType, (VkConformanceVersion*)(&forMarshaling->conformanceVersion), ptr);
}

void reservedmarshal_VkPhysicalDeviceVulkanMemoryModelFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkanMemoryModelFeatures* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->vulkanMemoryModel, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->vulkanMemoryModelDeviceScope, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->vulkanMemoryModelAvailabilityVisibilityChains, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDeviceHostQueryResetFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceHostQueryResetFeatures* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->hostQueryReset, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDeviceTimelineSemaphoreFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceTimelineSemaphoreFeatures* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->timelineSemaphore, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDeviceTimelineSemaphoreProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceTimelineSemaphoreProperties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint64_t*)&forMarshaling->maxTimelineSemaphoreValueDifference, sizeof(uint64_t));
    *ptr += sizeof(uint64_t);
}

void reservedmarshal_VkSemaphoreTypeCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSemaphoreTypeCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkSemaphoreType*)&forMarshaling->semaphoreType, sizeof(VkSemaphoreType));
    *ptr += sizeof(VkSemaphoreType);
    memcpy(*ptr, (uint64_t*)&forMarshaling->initialValue, sizeof(uint64_t));
    *ptr += sizeof(uint64_t);
}

void reservedmarshal_VkTimelineSemaphoreSubmitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkTimelineSemaphoreSubmitInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->waitSemaphoreValueCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pWaitSemaphoreValues;
    memcpy((*ptr), &cgen_var_0, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pWaitSemaphoreValues)
    {
        if (forMarshaling->waitSemaphoreValueCount > 0)
        {
            memcpy(*ptr, (const uint64_t*)forMarshaling->pWaitSemaphoreValues, forMarshaling->waitSemaphoreValueCount * sizeof(const uint64_t));
            *ptr += forMarshaling->waitSemaphoreValueCount * sizeof(const uint64_t);
        }
    }
    memcpy(*ptr, (uint32_t*)&forMarshaling->signalSemaphoreValueCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    // WARNING PTR CHECK
    uint64_t cgen_var_1 = (uint64_t)(uintptr_t)forMarshaling->pSignalSemaphoreValues;
    memcpy((*ptr), &cgen_var_1, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pSignalSemaphoreValues)
    {
        if (forMarshaling->signalSemaphoreValueCount > 0)
        {
            memcpy(*ptr, (const uint64_t*)forMarshaling->pSignalSemaphoreValues, forMarshaling->signalSemaphoreValueCount * sizeof(const uint64_t));
            *ptr += forMarshaling->signalSemaphoreValueCount * sizeof(const uint64_t);
        }
    }
}

void reservedmarshal_VkSemaphoreWaitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSemaphoreWaitInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkSemaphoreWaitFlags*)&forMarshaling->flags, sizeof(VkSemaphoreWaitFlags));
    *ptr += sizeof(VkSemaphoreWaitFlags);
    memcpy(*ptr, (uint32_t*)&forMarshaling->semaphoreCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    if (forMarshaling->semaphoreCount)
    {
        uint8_t* cgen_var_0_ptr = (uint8_t*)(*ptr);
        if (forMarshaling)
        {
            for (uint32_t k = 0; k < forMarshaling->semaphoreCount; ++k)
            {
                uint64_t tmpval = get_host_u64_VkSemaphore(forMarshaling->pSemaphores[k]);
                memcpy(cgen_var_0_ptr + k * 8, &tmpval, sizeof(uint64_t));
            }
        }
        *ptr += 8 * forMarshaling->semaphoreCount;
    }
    if (forMarshaling->semaphoreCount > 0)
    {
        memcpy(*ptr, (const uint64_t*)forMarshaling->pValues, forMarshaling->semaphoreCount * sizeof(const uint64_t));
        *ptr += forMarshaling->semaphoreCount * sizeof(const uint64_t);
    }
}

void reservedmarshal_VkSemaphoreSignalInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSemaphoreSignalInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkSemaphore((*&forMarshaling->semaphore));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (uint64_t*)&forMarshaling->value, sizeof(uint64_t));
    *ptr += sizeof(uint64_t);
}

void reservedmarshal_VkPhysicalDeviceBufferDeviceAddressFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceBufferDeviceAddressFeatures* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->bufferDeviceAddress, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->bufferDeviceAddressCaptureReplay, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->bufferDeviceAddressMultiDevice, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkBufferDeviceAddressInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferDeviceAddressInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkBuffer((*&forMarshaling->buffer));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
}

void reservedmarshal_VkBufferOpaqueCaptureAddressCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferOpaqueCaptureAddressCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint64_t*)&forMarshaling->opaqueCaptureAddress, sizeof(uint64_t));
    *ptr += sizeof(uint64_t);
}

void reservedmarshal_VkMemoryOpaqueCaptureAddressAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryOpaqueCaptureAddressAllocateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint64_t*)&forMarshaling->opaqueCaptureAddress, sizeof(uint64_t));
    *ptr += sizeof(uint64_t);
}

void reservedmarshal_VkDeviceMemoryOpaqueCaptureAddressInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceMemoryOpaqueCaptureAddressInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkDeviceMemory((*&forMarshaling->memory));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
}

#endif
#ifdef VK_COMPUTE_VERSION_1_2
void reservedmarshal_VkPhysicalDevice8BitStorageFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevice8BitStorageFeatures* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->storageBuffer8BitAccess, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->uniformAndStorageBuffer8BitAccess, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->storagePushConstant8, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDeviceShaderAtomicInt64Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderAtomicInt64Features* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderBufferInt64Atomics, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderSharedInt64Atomics, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDeviceShaderFloat16Int8Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderFloat16Int8Features* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderFloat16, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderInt8, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDeviceFloatControlsProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceFloatControlsProperties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkShaderFloatControlsIndependence*)&forMarshaling->denormBehaviorIndependence, sizeof(VkShaderFloatControlsIndependence));
    *ptr += sizeof(VkShaderFloatControlsIndependence);
    memcpy(*ptr, (VkShaderFloatControlsIndependence*)&forMarshaling->roundingModeIndependence, sizeof(VkShaderFloatControlsIndependence));
    *ptr += sizeof(VkShaderFloatControlsIndependence);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderSignedZeroInfNanPreserveFloat16, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderSignedZeroInfNanPreserveFloat32, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderSignedZeroInfNanPreserveFloat64, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderDenormPreserveFloat16, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderDenormPreserveFloat32, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderDenormPreserveFloat64, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderDenormFlushToZeroFloat16, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderDenormFlushToZeroFloat32, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderDenormFlushToZeroFloat64, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderRoundingModeRTEFloat16, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderRoundingModeRTEFloat32, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderRoundingModeRTEFloat64, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderRoundingModeRTZFloat16, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderRoundingModeRTZFloat32, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderRoundingModeRTZFloat64, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkDescriptorSetLayoutBindingFlagsCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorSetLayoutBindingFlagsCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->bindingCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pBindingFlags;
    memcpy((*ptr), &cgen_var_0, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pBindingFlags)
    {
        if (forMarshaling->bindingCount > 0)
        {
            memcpy(*ptr, (const VkDescriptorBindingFlags*)forMarshaling->pBindingFlags, forMarshaling->bindingCount * sizeof(const VkDescriptorBindingFlags));
            *ptr += forMarshaling->bindingCount * sizeof(const VkDescriptorBindingFlags);
        }
    }
}

void reservedmarshal_VkPhysicalDeviceDescriptorIndexingFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceDescriptorIndexingFeatures* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderInputAttachmentArrayDynamicIndexing, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderUniformTexelBufferArrayDynamicIndexing, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderStorageTexelBufferArrayDynamicIndexing, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderUniformBufferArrayNonUniformIndexing, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderSampledImageArrayNonUniformIndexing, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderStorageBufferArrayNonUniformIndexing, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderStorageImageArrayNonUniformIndexing, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderInputAttachmentArrayNonUniformIndexing, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderUniformTexelBufferArrayNonUniformIndexing, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderStorageTexelBufferArrayNonUniformIndexing, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->descriptorBindingUniformBufferUpdateAfterBind, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->descriptorBindingSampledImageUpdateAfterBind, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->descriptorBindingStorageImageUpdateAfterBind, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->descriptorBindingStorageBufferUpdateAfterBind, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->descriptorBindingUniformTexelBufferUpdateAfterBind, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->descriptorBindingStorageTexelBufferUpdateAfterBind, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->descriptorBindingUpdateUnusedWhilePending, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->descriptorBindingPartiallyBound, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->descriptorBindingVariableDescriptorCount, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->runtimeDescriptorArray, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDeviceDescriptorIndexingProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceDescriptorIndexingProperties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxUpdateAfterBindDescriptorsInAllPools, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderUniformBufferArrayNonUniformIndexingNative, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderSampledImageArrayNonUniformIndexingNative, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderStorageBufferArrayNonUniformIndexingNative, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderStorageImageArrayNonUniformIndexingNative, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderInputAttachmentArrayNonUniformIndexingNative, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->robustBufferAccessUpdateAfterBind, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->quadDivergentImplicitLod, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxPerStageDescriptorUpdateAfterBindSamplers, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxPerStageDescriptorUpdateAfterBindUniformBuffers, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxPerStageDescriptorUpdateAfterBindStorageBuffers, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxPerStageDescriptorUpdateAfterBindSampledImages, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxPerStageDescriptorUpdateAfterBindStorageImages, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxPerStageDescriptorUpdateAfterBindInputAttachments, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxPerStageUpdateAfterBindResources, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxDescriptorSetUpdateAfterBindSamplers, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxDescriptorSetUpdateAfterBindUniformBuffers, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxDescriptorSetUpdateAfterBindStorageBuffers, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxDescriptorSetUpdateAfterBindSampledImages, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxDescriptorSetUpdateAfterBindStorageImages, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxDescriptorSetUpdateAfterBindInputAttachments, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkDescriptorSetVariableDescriptorCountAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorSetVariableDescriptorCountAllocateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->descriptorSetCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    if (forMarshaling->descriptorSetCount > 0)
    {
        memcpy(*ptr, (const uint32_t*)forMarshaling->pDescriptorCounts, forMarshaling->descriptorSetCount * sizeof(const uint32_t));
        *ptr += forMarshaling->descriptorSetCount * sizeof(const uint32_t);
    }
}

void reservedmarshal_VkDescriptorSetVariableDescriptorCountLayoutSupport(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorSetVariableDescriptorCountLayoutSupport* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxVariableDescriptorCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkPhysicalDeviceScalarBlockLayoutFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceScalarBlockLayoutFeatures* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->scalarBlockLayout, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkSamplerReductionModeCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSamplerReductionModeCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkSamplerReductionMode*)&forMarshaling->reductionMode, sizeof(VkSamplerReductionMode));
    *ptr += sizeof(VkSamplerReductionMode);
}

void reservedmarshal_VkPhysicalDeviceSamplerFilterMinmaxProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceSamplerFilterMinmaxProperties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->filterMinmaxSingleComponentFormats, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->filterMinmaxImageComponentMapping, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceUniformBufferStandardLayoutFeatures* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->uniformBufferStandardLayout, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderSubgroupExtendedTypes, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

#endif
#ifdef VK_GRAPHICS_VERSION_1_2
void reservedmarshal_VkAttachmentDescription2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkAttachmentDescription2* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkAttachmentDescriptionFlags*)&forMarshaling->flags, sizeof(VkAttachmentDescriptionFlags));
    *ptr += sizeof(VkAttachmentDescriptionFlags);
    memcpy(*ptr, (VkFormat*)&forMarshaling->format, sizeof(VkFormat));
    *ptr += sizeof(VkFormat);
    memcpy(*ptr, (VkSampleCountFlagBits*)&forMarshaling->samples, sizeof(VkSampleCountFlagBits));
    *ptr += sizeof(VkSampleCountFlagBits);
    memcpy(*ptr, (VkAttachmentLoadOp*)&forMarshaling->loadOp, sizeof(VkAttachmentLoadOp));
    *ptr += sizeof(VkAttachmentLoadOp);
    memcpy(*ptr, (VkAttachmentStoreOp*)&forMarshaling->storeOp, sizeof(VkAttachmentStoreOp));
    *ptr += sizeof(VkAttachmentStoreOp);
    memcpy(*ptr, (VkAttachmentLoadOp*)&forMarshaling->stencilLoadOp, sizeof(VkAttachmentLoadOp));
    *ptr += sizeof(VkAttachmentLoadOp);
    memcpy(*ptr, (VkAttachmentStoreOp*)&forMarshaling->stencilStoreOp, sizeof(VkAttachmentStoreOp));
    *ptr += sizeof(VkAttachmentStoreOp);
    memcpy(*ptr, (VkImageLayout*)&forMarshaling->initialLayout, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    memcpy(*ptr, (VkImageLayout*)&forMarshaling->finalLayout, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
}

void reservedmarshal_VkAttachmentReference2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkAttachmentReference2* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->attachment, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkImageLayout*)&forMarshaling->layout, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    memcpy(*ptr, (VkImageAspectFlags*)&forMarshaling->aspectMask, sizeof(VkImageAspectFlags));
    *ptr += sizeof(VkImageAspectFlags);
}

void reservedmarshal_VkSubpassDescription2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubpassDescription2* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkSubpassDescriptionFlags*)&forMarshaling->flags, sizeof(VkSubpassDescriptionFlags));
    *ptr += sizeof(VkSubpassDescriptionFlags);
    memcpy(*ptr, (VkPipelineBindPoint*)&forMarshaling->pipelineBindPoint, sizeof(VkPipelineBindPoint));
    *ptr += sizeof(VkPipelineBindPoint);
    memcpy(*ptr, (uint32_t*)&forMarshaling->viewMask, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->inputAttachmentCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->inputAttachmentCount; ++i)
    {
        reservedmarshal_VkAttachmentReference2(vkStream, rootType, (const VkAttachmentReference2*)(forMarshaling->pInputAttachments + i), ptr);
    }
    memcpy(*ptr, (uint32_t*)&forMarshaling->colorAttachmentCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->colorAttachmentCount; ++i)
    {
        reservedmarshal_VkAttachmentReference2(vkStream, rootType, (const VkAttachmentReference2*)(forMarshaling->pColorAttachments + i), ptr);
    }
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pResolveAttachments;
    memcpy((*ptr), &cgen_var_0, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pResolveAttachments)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->colorAttachmentCount; ++i)
        {
            reservedmarshal_VkAttachmentReference2(vkStream, rootType, (const VkAttachmentReference2*)(forMarshaling->pResolveAttachments + i), ptr);
        }
    }
    // WARNING PTR CHECK
    uint64_t cgen_var_1 = (uint64_t)(uintptr_t)forMarshaling->pDepthStencilAttachment;
    memcpy((*ptr), &cgen_var_1, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pDepthStencilAttachment)
    {
        reservedmarshal_VkAttachmentReference2(vkStream, rootType, (const VkAttachmentReference2*)(forMarshaling->pDepthStencilAttachment), ptr);
    }
    memcpy(*ptr, (uint32_t*)&forMarshaling->preserveAttachmentCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    if (forMarshaling->preserveAttachmentCount > 0)
    {
        memcpy(*ptr, (const uint32_t*)forMarshaling->pPreserveAttachments, forMarshaling->preserveAttachmentCount * sizeof(const uint32_t));
        *ptr += forMarshaling->preserveAttachmentCount * sizeof(const uint32_t);
    }
}

void reservedmarshal_VkSubpassDependency2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubpassDependency2* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->srcSubpass, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->dstSubpass, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkPipelineStageFlags*)&forMarshaling->srcStageMask, sizeof(VkPipelineStageFlags));
    *ptr += sizeof(VkPipelineStageFlags);
    memcpy(*ptr, (VkPipelineStageFlags*)&forMarshaling->dstStageMask, sizeof(VkPipelineStageFlags));
    *ptr += sizeof(VkPipelineStageFlags);
    memcpy(*ptr, (VkAccessFlags*)&forMarshaling->srcAccessMask, sizeof(VkAccessFlags));
    *ptr += sizeof(VkAccessFlags);
    memcpy(*ptr, (VkAccessFlags*)&forMarshaling->dstAccessMask, sizeof(VkAccessFlags));
    *ptr += sizeof(VkAccessFlags);
    memcpy(*ptr, (VkDependencyFlags*)&forMarshaling->dependencyFlags, sizeof(VkDependencyFlags));
    *ptr += sizeof(VkDependencyFlags);
    memcpy(*ptr, (int32_t*)&forMarshaling->viewOffset, sizeof(int32_t));
    *ptr += sizeof(int32_t);
}

void reservedmarshal_VkRenderPassCreateInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderPassCreateInfo2* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkRenderPassCreateFlags*)&forMarshaling->flags, sizeof(VkRenderPassCreateFlags));
    *ptr += sizeof(VkRenderPassCreateFlags);
    memcpy(*ptr, (uint32_t*)&forMarshaling->attachmentCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->attachmentCount; ++i)
    {
        reservedmarshal_VkAttachmentDescription2(vkStream, rootType, (const VkAttachmentDescription2*)(forMarshaling->pAttachments + i), ptr);
    }
    memcpy(*ptr, (uint32_t*)&forMarshaling->subpassCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->subpassCount; ++i)
    {
        reservedmarshal_VkSubpassDescription2(vkStream, rootType, (const VkSubpassDescription2*)(forMarshaling->pSubpasses + i), ptr);
    }
    memcpy(*ptr, (uint32_t*)&forMarshaling->dependencyCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->dependencyCount; ++i)
    {
        reservedmarshal_VkSubpassDependency2(vkStream, rootType, (const VkSubpassDependency2*)(forMarshaling->pDependencies + i), ptr);
    }
    memcpy(*ptr, (uint32_t*)&forMarshaling->correlatedViewMaskCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    if (forMarshaling->correlatedViewMaskCount > 0)
    {
        memcpy(*ptr, (const uint32_t*)forMarshaling->pCorrelatedViewMasks, forMarshaling->correlatedViewMaskCount * sizeof(const uint32_t));
        *ptr += forMarshaling->correlatedViewMaskCount * sizeof(const uint32_t);
    }
}

void reservedmarshal_VkSubpassBeginInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubpassBeginInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkSubpassContents*)&forMarshaling->contents, sizeof(VkSubpassContents));
    *ptr += sizeof(VkSubpassContents);
}

void reservedmarshal_VkSubpassEndInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubpassEndInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
}

void reservedmarshal_VkSubpassDescriptionDepthStencilResolve(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubpassDescriptionDepthStencilResolve* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkResolveModeFlagBits*)&forMarshaling->depthResolveMode, sizeof(VkResolveModeFlagBits));
    *ptr += sizeof(VkResolveModeFlagBits);
    memcpy(*ptr, (VkResolveModeFlagBits*)&forMarshaling->stencilResolveMode, sizeof(VkResolveModeFlagBits));
    *ptr += sizeof(VkResolveModeFlagBits);
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pDepthStencilResolveAttachment;
    memcpy((*ptr), &cgen_var_0, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pDepthStencilResolveAttachment)
    {
        reservedmarshal_VkAttachmentReference2(vkStream, rootType, (const VkAttachmentReference2*)(forMarshaling->pDepthStencilResolveAttachment), ptr);
    }
}

void reservedmarshal_VkPhysicalDeviceDepthStencilResolveProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceDepthStencilResolveProperties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkResolveModeFlags*)&forMarshaling->supportedDepthResolveModes, sizeof(VkResolveModeFlags));
    *ptr += sizeof(VkResolveModeFlags);
    memcpy(*ptr, (VkResolveModeFlags*)&forMarshaling->supportedStencilResolveModes, sizeof(VkResolveModeFlags));
    *ptr += sizeof(VkResolveModeFlags);
    memcpy(*ptr, (VkBool32*)&forMarshaling->independentResolveNone, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->independentResolve, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkImageStencilUsageCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageStencilUsageCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkImageUsageFlags*)&forMarshaling->stencilUsage, sizeof(VkImageUsageFlags));
    *ptr += sizeof(VkImageUsageFlags);
}

void reservedmarshal_VkPhysicalDeviceImagelessFramebufferFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceImagelessFramebufferFeatures* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->imagelessFramebuffer, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkFramebufferAttachmentImageInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkFramebufferAttachmentImageInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkImageCreateFlags*)&forMarshaling->flags, sizeof(VkImageCreateFlags));
    *ptr += sizeof(VkImageCreateFlags);
    memcpy(*ptr, (VkImageUsageFlags*)&forMarshaling->usage, sizeof(VkImageUsageFlags));
    *ptr += sizeof(VkImageUsageFlags);
    memcpy(*ptr, (uint32_t*)&forMarshaling->width, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->height, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->layerCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->viewFormatCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    if (forMarshaling->viewFormatCount > 0)
    {
        memcpy(*ptr, (const VkFormat*)forMarshaling->pViewFormats, forMarshaling->viewFormatCount * sizeof(const VkFormat));
        *ptr += forMarshaling->viewFormatCount * sizeof(const VkFormat);
    }
}

void reservedmarshal_VkFramebufferAttachmentsCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkFramebufferAttachmentsCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->attachmentImageInfoCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->attachmentImageInfoCount; ++i)
    {
        reservedmarshal_VkFramebufferAttachmentImageInfo(vkStream, rootType, (const VkFramebufferAttachmentImageInfo*)(forMarshaling->pAttachmentImageInfos + i), ptr);
    }
}

void reservedmarshal_VkRenderPassAttachmentBeginInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderPassAttachmentBeginInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->attachmentCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    if (forMarshaling->attachmentCount)
    {
        uint8_t* cgen_var_0_ptr = (uint8_t*)(*ptr);
        if (forMarshaling)
        {
            for (uint32_t k = 0; k < forMarshaling->attachmentCount; ++k)
            {
                uint64_t tmpval = get_host_u64_VkImageView(forMarshaling->pAttachments[k]);
                memcpy(cgen_var_0_ptr + k * 8, &tmpval, sizeof(uint64_t));
            }
        }
        *ptr += 8 * forMarshaling->attachmentCount;
    }
}

void reservedmarshal_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->separateDepthStencilLayouts, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkAttachmentReferenceStencilLayout(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkAttachmentReferenceStencilLayout* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkImageLayout*)&forMarshaling->stencilLayout, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
}

void reservedmarshal_VkAttachmentDescriptionStencilLayout(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkAttachmentDescriptionStencilLayout* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkImageLayout*)&forMarshaling->stencilInitialLayout, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    memcpy(*ptr, (VkImageLayout*)&forMarshaling->stencilFinalLayout, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
}

#endif
#ifdef VK_BASE_VERSION_1_3
void reservedmarshal_VkPhysicalDeviceVulkan13Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan13Features* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->robustImageAccess, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->inlineUniformBlock, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->descriptorBindingInlineUniformBlockUpdateAfterBind, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->pipelineCreationCacheControl, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->privateData, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderDemoteToHelperInvocation, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderTerminateInvocation, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->subgroupSizeControl, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->computeFullSubgroups, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->synchronization2, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->textureCompressionASTC_HDR, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderZeroInitializeWorkgroupMemory, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->dynamicRendering, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderIntegerDotProduct, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->maintenance4, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDeviceVulkan13Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan13Properties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->minSubgroupSize, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxSubgroupSize, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxComputeWorkgroupSubgroups, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkShaderStageFlags*)&forMarshaling->requiredSubgroupSizeStages, sizeof(VkShaderStageFlags));
    *ptr += sizeof(VkShaderStageFlags);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxInlineUniformBlockSize, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxPerStageDescriptorInlineUniformBlocks, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxDescriptorSetInlineUniformBlocks, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxDescriptorSetUpdateAfterBindInlineUniformBlocks, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxInlineUniformTotalSize, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProduct8BitUnsignedAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProduct8BitSignedAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProduct8BitMixedSignednessAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProduct4x8BitPackedUnsignedAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProduct4x8BitPackedSignedAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProduct4x8BitPackedMixedSignednessAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProduct16BitUnsignedAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProduct16BitSignedAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProduct16BitMixedSignednessAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProduct32BitUnsignedAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProduct32BitSignedAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProduct32BitMixedSignednessAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProduct64BitUnsignedAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProduct64BitSignedAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProduct64BitMixedSignednessAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating8BitUnsignedAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating8BitSignedAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating16BitUnsignedAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating16BitSignedAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating32BitUnsignedAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating32BitSignedAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating64BitUnsignedAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating64BitSignedAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->storageTexelBufferOffsetAlignmentBytes, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy(*ptr, (VkBool32*)&forMarshaling->storageTexelBufferOffsetSingleTexelAlignment, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->uniformTexelBufferOffsetAlignmentBytes, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy(*ptr, (VkBool32*)&forMarshaling->uniformTexelBufferOffsetSingleTexelAlignment, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->maxBufferSize, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
}

void reservedmarshal_VkPhysicalDeviceToolProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceToolProperties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (char*)forMarshaling->name, VK_MAX_EXTENSION_NAME_SIZE * sizeof(char));
    *ptr += VK_MAX_EXTENSION_NAME_SIZE * sizeof(char);
    memcpy(*ptr, (char*)forMarshaling->version, VK_MAX_EXTENSION_NAME_SIZE * sizeof(char));
    *ptr += VK_MAX_EXTENSION_NAME_SIZE * sizeof(char);
    memcpy(*ptr, (VkToolPurposeFlags*)&forMarshaling->purposes, sizeof(VkToolPurposeFlags));
    *ptr += sizeof(VkToolPurposeFlags);
    memcpy(*ptr, (char*)forMarshaling->description, VK_MAX_DESCRIPTION_SIZE * sizeof(char));
    *ptr += VK_MAX_DESCRIPTION_SIZE * sizeof(char);
    memcpy(*ptr, (char*)forMarshaling->layer, VK_MAX_EXTENSION_NAME_SIZE * sizeof(char));
    *ptr += VK_MAX_EXTENSION_NAME_SIZE * sizeof(char);
}

void reservedmarshal_VkPhysicalDevicePrivateDataFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevicePrivateDataFeatures* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->privateData, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkDevicePrivateDataCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDevicePrivateDataCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->privateDataSlotRequestCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkPrivateDataSlotCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPrivateDataSlotCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkPrivateDataSlotCreateFlags*)&forMarshaling->flags, sizeof(VkPrivateDataSlotCreateFlags));
    *ptr += sizeof(VkPrivateDataSlotCreateFlags);
}

void reservedmarshal_VkMemoryBarrier2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryBarrier2* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkPipelineStageFlags2*)&forMarshaling->srcStageMask, sizeof(VkPipelineStageFlags2));
    *ptr += sizeof(VkPipelineStageFlags2);
    memcpy(*ptr, (VkAccessFlags2*)&forMarshaling->srcAccessMask, sizeof(VkAccessFlags2));
    *ptr += sizeof(VkAccessFlags2);
    memcpy(*ptr, (VkPipelineStageFlags2*)&forMarshaling->dstStageMask, sizeof(VkPipelineStageFlags2));
    *ptr += sizeof(VkPipelineStageFlags2);
    memcpy(*ptr, (VkAccessFlags2*)&forMarshaling->dstAccessMask, sizeof(VkAccessFlags2));
    *ptr += sizeof(VkAccessFlags2);
}

void reservedmarshal_VkBufferMemoryBarrier2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferMemoryBarrier2* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkPipelineStageFlags2*)&forMarshaling->srcStageMask, sizeof(VkPipelineStageFlags2));
    *ptr += sizeof(VkPipelineStageFlags2);
    memcpy(*ptr, (VkAccessFlags2*)&forMarshaling->srcAccessMask, sizeof(VkAccessFlags2));
    *ptr += sizeof(VkAccessFlags2);
    memcpy(*ptr, (VkPipelineStageFlags2*)&forMarshaling->dstStageMask, sizeof(VkPipelineStageFlags2));
    *ptr += sizeof(VkPipelineStageFlags2);
    memcpy(*ptr, (VkAccessFlags2*)&forMarshaling->dstAccessMask, sizeof(VkAccessFlags2));
    *ptr += sizeof(VkAccessFlags2);
    memcpy(*ptr, (uint32_t*)&forMarshaling->srcQueueFamilyIndex, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->dstQueueFamilyIndex, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkBuffer((*&forMarshaling->buffer));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->offset, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->size, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
}

void reservedmarshal_VkImageMemoryBarrier2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageMemoryBarrier2* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkPipelineStageFlags2*)&forMarshaling->srcStageMask, sizeof(VkPipelineStageFlags2));
    *ptr += sizeof(VkPipelineStageFlags2);
    memcpy(*ptr, (VkAccessFlags2*)&forMarshaling->srcAccessMask, sizeof(VkAccessFlags2));
    *ptr += sizeof(VkAccessFlags2);
    memcpy(*ptr, (VkPipelineStageFlags2*)&forMarshaling->dstStageMask, sizeof(VkPipelineStageFlags2));
    *ptr += sizeof(VkPipelineStageFlags2);
    memcpy(*ptr, (VkAccessFlags2*)&forMarshaling->dstAccessMask, sizeof(VkAccessFlags2));
    *ptr += sizeof(VkAccessFlags2);
    memcpy(*ptr, (VkImageLayout*)&forMarshaling->oldLayout, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    memcpy(*ptr, (VkImageLayout*)&forMarshaling->newLayout, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    memcpy(*ptr, (uint32_t*)&forMarshaling->srcQueueFamilyIndex, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->dstQueueFamilyIndex, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkImage((*&forMarshaling->image));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    reservedmarshal_VkImageSubresourceRange(vkStream, rootType, (VkImageSubresourceRange*)(&forMarshaling->subresourceRange), ptr);
}

void reservedmarshal_VkDependencyInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDependencyInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkDependencyFlags*)&forMarshaling->dependencyFlags, sizeof(VkDependencyFlags));
    *ptr += sizeof(VkDependencyFlags);
    memcpy(*ptr, (uint32_t*)&forMarshaling->memoryBarrierCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->memoryBarrierCount; ++i)
    {
        reservedmarshal_VkMemoryBarrier2(vkStream, rootType, (const VkMemoryBarrier2*)(forMarshaling->pMemoryBarriers + i), ptr);
    }
    memcpy(*ptr, (uint32_t*)&forMarshaling->bufferMemoryBarrierCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->bufferMemoryBarrierCount; ++i)
    {
        reservedmarshal_VkBufferMemoryBarrier2(vkStream, rootType, (const VkBufferMemoryBarrier2*)(forMarshaling->pBufferMemoryBarriers + i), ptr);
    }
    memcpy(*ptr, (uint32_t*)&forMarshaling->imageMemoryBarrierCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->imageMemoryBarrierCount; ++i)
    {
        reservedmarshal_VkImageMemoryBarrier2(vkStream, rootType, (const VkImageMemoryBarrier2*)(forMarshaling->pImageMemoryBarriers + i), ptr);
    }
}

void reservedmarshal_VkSemaphoreSubmitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSemaphoreSubmitInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkSemaphore((*&forMarshaling->semaphore));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (uint64_t*)&forMarshaling->value, sizeof(uint64_t));
    *ptr += sizeof(uint64_t);
    memcpy(*ptr, (VkPipelineStageFlags2*)&forMarshaling->stageMask, sizeof(VkPipelineStageFlags2));
    *ptr += sizeof(VkPipelineStageFlags2);
    memcpy(*ptr, (uint32_t*)&forMarshaling->deviceIndex, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkCommandBufferSubmitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCommandBufferSubmitInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkCommandBuffer((*&forMarshaling->commandBuffer));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (uint32_t*)&forMarshaling->deviceMask, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkSubmitInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubmitInfo2* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkSubmitFlags*)&forMarshaling->flags, sizeof(VkSubmitFlags));
    *ptr += sizeof(VkSubmitFlags);
    memcpy(*ptr, (uint32_t*)&forMarshaling->waitSemaphoreInfoCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->waitSemaphoreInfoCount; ++i)
    {
        reservedmarshal_VkSemaphoreSubmitInfo(vkStream, rootType, (const VkSemaphoreSubmitInfo*)(forMarshaling->pWaitSemaphoreInfos + i), ptr);
    }
    memcpy(*ptr, (uint32_t*)&forMarshaling->commandBufferInfoCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->commandBufferInfoCount; ++i)
    {
        reservedmarshal_VkCommandBufferSubmitInfo(vkStream, rootType, (const VkCommandBufferSubmitInfo*)(forMarshaling->pCommandBufferInfos + i), ptr);
    }
    memcpy(*ptr, (uint32_t*)&forMarshaling->signalSemaphoreInfoCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->signalSemaphoreInfoCount; ++i)
    {
        reservedmarshal_VkSemaphoreSubmitInfo(vkStream, rootType, (const VkSemaphoreSubmitInfo*)(forMarshaling->pSignalSemaphoreInfos + i), ptr);
    }
}

void reservedmarshal_VkPhysicalDeviceSynchronization2Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceSynchronization2Features* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->synchronization2, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkBufferCopy2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferCopy2* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->srcOffset, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->dstOffset, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->size, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
}

void reservedmarshal_VkCopyBufferInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCopyBufferInfo2* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkBuffer((*&forMarshaling->srcBuffer));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    uint64_t cgen_var_1;
    *&cgen_var_1 = get_host_u64_VkBuffer((*&forMarshaling->dstBuffer));
    memcpy(*ptr, (uint64_t*)&cgen_var_1, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (uint32_t*)&forMarshaling->regionCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->regionCount; ++i)
    {
        reservedmarshal_VkBufferCopy2(vkStream, rootType, (const VkBufferCopy2*)(forMarshaling->pRegions + i), ptr);
    }
}

void reservedmarshal_VkImageCopy2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageCopy2* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    reservedmarshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forMarshaling->srcSubresource), ptr);
    reservedmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forMarshaling->srcOffset), ptr);
    reservedmarshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forMarshaling->dstSubresource), ptr);
    reservedmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forMarshaling->dstOffset), ptr);
    reservedmarshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forMarshaling->extent), ptr);
}

void reservedmarshal_VkCopyImageInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCopyImageInfo2* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkImage((*&forMarshaling->srcImage));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (VkImageLayout*)&forMarshaling->srcImageLayout, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    uint64_t cgen_var_1;
    *&cgen_var_1 = get_host_u64_VkImage((*&forMarshaling->dstImage));
    memcpy(*ptr, (uint64_t*)&cgen_var_1, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (VkImageLayout*)&forMarshaling->dstImageLayout, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    memcpy(*ptr, (uint32_t*)&forMarshaling->regionCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->regionCount; ++i)
    {
        reservedmarshal_VkImageCopy2(vkStream, rootType, (const VkImageCopy2*)(forMarshaling->pRegions + i), ptr);
    }
}

void reservedmarshal_VkBufferImageCopy2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferImageCopy2* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->bufferOffset, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy(*ptr, (uint32_t*)&forMarshaling->bufferRowLength, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->bufferImageHeight, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    reservedmarshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forMarshaling->imageSubresource), ptr);
    reservedmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forMarshaling->imageOffset), ptr);
    reservedmarshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forMarshaling->imageExtent), ptr);
}

void reservedmarshal_VkCopyBufferToImageInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCopyBufferToImageInfo2* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkBuffer((*&forMarshaling->srcBuffer));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    uint64_t cgen_var_1;
    *&cgen_var_1 = get_host_u64_VkImage((*&forMarshaling->dstImage));
    memcpy(*ptr, (uint64_t*)&cgen_var_1, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (VkImageLayout*)&forMarshaling->dstImageLayout, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    memcpy(*ptr, (uint32_t*)&forMarshaling->regionCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->regionCount; ++i)
    {
        reservedmarshal_VkBufferImageCopy2(vkStream, rootType, (const VkBufferImageCopy2*)(forMarshaling->pRegions + i), ptr);
    }
}

void reservedmarshal_VkCopyImageToBufferInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCopyImageToBufferInfo2* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkImage((*&forMarshaling->srcImage));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (VkImageLayout*)&forMarshaling->srcImageLayout, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    uint64_t cgen_var_1;
    *&cgen_var_1 = get_host_u64_VkBuffer((*&forMarshaling->dstBuffer));
    memcpy(*ptr, (uint64_t*)&cgen_var_1, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (uint32_t*)&forMarshaling->regionCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->regionCount; ++i)
    {
        reservedmarshal_VkBufferImageCopy2(vkStream, rootType, (const VkBufferImageCopy2*)(forMarshaling->pRegions + i), ptr);
    }
}

void reservedmarshal_VkPhysicalDeviceTextureCompressionASTCHDRFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceTextureCompressionASTCHDRFeatures* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->textureCompressionASTC_HDR, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkFormatProperties3(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkFormatProperties3* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkFormatFeatureFlags2*)&forMarshaling->linearTilingFeatures, sizeof(VkFormatFeatureFlags2));
    *ptr += sizeof(VkFormatFeatureFlags2);
    memcpy(*ptr, (VkFormatFeatureFlags2*)&forMarshaling->optimalTilingFeatures, sizeof(VkFormatFeatureFlags2));
    *ptr += sizeof(VkFormatFeatureFlags2);
    memcpy(*ptr, (VkFormatFeatureFlags2*)&forMarshaling->bufferFeatures, sizeof(VkFormatFeatureFlags2));
    *ptr += sizeof(VkFormatFeatureFlags2);
}

void reservedmarshal_VkPhysicalDeviceMaintenance4Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance4Features* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->maintenance4, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDeviceMaintenance4Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance4Properties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->maxBufferSize, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
}

void reservedmarshal_VkDeviceBufferMemoryRequirements(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceBufferMemoryRequirements* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    reservedmarshal_VkBufferCreateInfo(vkStream, rootType, (const VkBufferCreateInfo*)(forMarshaling->pCreateInfo), ptr);
}

void reservedmarshal_VkDeviceImageMemoryRequirements(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceImageMemoryRequirements* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    reservedmarshal_VkImageCreateInfo(vkStream, rootType, (const VkImageCreateInfo*)(forMarshaling->pCreateInfo), ptr);
    memcpy(*ptr, (VkImageAspectFlagBits*)&forMarshaling->planeAspect, sizeof(VkImageAspectFlagBits));
    *ptr += sizeof(VkImageAspectFlagBits);
}

#endif
#ifdef VK_COMPUTE_VERSION_1_3
void reservedmarshal_VkPipelineCreationFeedback(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineCreationFeedback* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkPipelineCreationFeedbackFlags*)&forMarshaling->flags, sizeof(VkPipelineCreationFeedbackFlags));
    *ptr += sizeof(VkPipelineCreationFeedbackFlags);
    memcpy(*ptr, (uint64_t*)&forMarshaling->duration, sizeof(uint64_t));
    *ptr += sizeof(uint64_t);
}

void reservedmarshal_VkPipelineCreationFeedbackCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineCreationFeedbackCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    reservedmarshal_VkPipelineCreationFeedback(vkStream, rootType, (VkPipelineCreationFeedback*)(forMarshaling->pPipelineCreationFeedback), ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->pipelineStageCreationFeedbackCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->pipelineStageCreationFeedbackCount; ++i)
    {
        reservedmarshal_VkPipelineCreationFeedback(vkStream, rootType, (VkPipelineCreationFeedback*)(forMarshaling->pPipelineStageCreationFeedbacks + i), ptr);
    }
}

void reservedmarshal_VkPhysicalDeviceShaderTerminateInvocationFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderTerminateInvocationFeatures* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderTerminateInvocation, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderDemoteToHelperInvocation, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDevicePipelineCreationCacheControlFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevicePipelineCreationCacheControlFeatures* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->pipelineCreationCacheControl, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderZeroInitializeWorkgroupMemory, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDeviceImageRobustnessFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceImageRobustnessFeatures* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->robustImageAccess, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDeviceSubgroupSizeControlFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceSubgroupSizeControlFeatures* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->subgroupSizeControl, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->computeFullSubgroups, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDeviceSubgroupSizeControlProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceSubgroupSizeControlProperties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->minSubgroupSize, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxSubgroupSize, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxComputeWorkgroupSubgroups, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkShaderStageFlags*)&forMarshaling->requiredSubgroupSizeStages, sizeof(VkShaderStageFlags));
    *ptr += sizeof(VkShaderStageFlags);
}

void reservedmarshal_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineShaderStageRequiredSubgroupSizeCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->requiredSubgroupSize, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkPhysicalDeviceInlineUniformBlockFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceInlineUniformBlockFeatures* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->inlineUniformBlock, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->descriptorBindingInlineUniformBlockUpdateAfterBind, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDeviceInlineUniformBlockProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceInlineUniformBlockProperties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxInlineUniformBlockSize, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxPerStageDescriptorInlineUniformBlocks, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxDescriptorSetInlineUniformBlocks, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxDescriptorSetUpdateAfterBindInlineUniformBlocks, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkWriteDescriptorSetInlineUniformBlock(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkWriteDescriptorSetInlineUniformBlock* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->dataSize, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    if (forMarshaling->dataSize > 0)
    {
        memcpy(*ptr, (const void*)forMarshaling->pData, forMarshaling->dataSize * sizeof(const uint8_t));
        *ptr += forMarshaling->dataSize * sizeof(const uint8_t);
    }
}

void reservedmarshal_VkDescriptorPoolInlineUniformBlockCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorPoolInlineUniformBlockCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxInlineUniformBlockBindings, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkPhysicalDeviceShaderIntegerDotProductFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderIntegerDotProductFeatures* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderIntegerDotProduct, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDeviceShaderIntegerDotProductProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderIntegerDotProductProperties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProduct8BitUnsignedAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProduct8BitSignedAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProduct8BitMixedSignednessAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProduct4x8BitPackedUnsignedAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProduct4x8BitPackedSignedAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProduct4x8BitPackedMixedSignednessAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProduct16BitUnsignedAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProduct16BitSignedAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProduct16BitMixedSignednessAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProduct32BitUnsignedAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProduct32BitSignedAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProduct32BitMixedSignednessAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProduct64BitUnsignedAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProduct64BitSignedAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProduct64BitMixedSignednessAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating8BitUnsignedAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating8BitSignedAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating16BitUnsignedAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating16BitSignedAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating32BitUnsignedAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating32BitSignedAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating64BitUnsignedAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating64BitSignedAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDeviceTexelBufferAlignmentProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceTexelBufferAlignmentProperties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->storageTexelBufferOffsetAlignmentBytes, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy(*ptr, (VkBool32*)&forMarshaling->storageTexelBufferOffsetSingleTexelAlignment, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->uniformTexelBufferOffsetAlignmentBytes, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy(*ptr, (VkBool32*)&forMarshaling->uniformTexelBufferOffsetSingleTexelAlignment, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

#endif
#ifdef VK_GRAPHICS_VERSION_1_3
void reservedmarshal_VkImageBlit2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageBlit2* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    reservedmarshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forMarshaling->srcSubresource), ptr);
    for (uint32_t i = 0; i < (uint32_t)2; ++i)
    {
        reservedmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(forMarshaling->srcOffsets + i), ptr);
    }
    reservedmarshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forMarshaling->dstSubresource), ptr);
    for (uint32_t i = 0; i < (uint32_t)2; ++i)
    {
        reservedmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(forMarshaling->dstOffsets + i), ptr);
    }
}

void reservedmarshal_VkBlitImageInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBlitImageInfo2* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkImage((*&forMarshaling->srcImage));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (VkImageLayout*)&forMarshaling->srcImageLayout, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    uint64_t cgen_var_1;
    *&cgen_var_1 = get_host_u64_VkImage((*&forMarshaling->dstImage));
    memcpy(*ptr, (uint64_t*)&cgen_var_1, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (VkImageLayout*)&forMarshaling->dstImageLayout, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    memcpy(*ptr, (uint32_t*)&forMarshaling->regionCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->regionCount; ++i)
    {
        reservedmarshal_VkImageBlit2(vkStream, rootType, (const VkImageBlit2*)(forMarshaling->pRegions + i), ptr);
    }
    memcpy(*ptr, (VkFilter*)&forMarshaling->filter, sizeof(VkFilter));
    *ptr += sizeof(VkFilter);
}

void reservedmarshal_VkImageResolve2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageResolve2* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    reservedmarshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forMarshaling->srcSubresource), ptr);
    reservedmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forMarshaling->srcOffset), ptr);
    reservedmarshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forMarshaling->dstSubresource), ptr);
    reservedmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forMarshaling->dstOffset), ptr);
    reservedmarshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forMarshaling->extent), ptr);
}

void reservedmarshal_VkResolveImageInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkResolveImageInfo2* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkImage((*&forMarshaling->srcImage));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (VkImageLayout*)&forMarshaling->srcImageLayout, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    uint64_t cgen_var_1;
    *&cgen_var_1 = get_host_u64_VkImage((*&forMarshaling->dstImage));
    memcpy(*ptr, (uint64_t*)&cgen_var_1, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (VkImageLayout*)&forMarshaling->dstImageLayout, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    memcpy(*ptr, (uint32_t*)&forMarshaling->regionCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->regionCount; ++i)
    {
        reservedmarshal_VkImageResolve2(vkStream, rootType, (const VkImageResolve2*)(forMarshaling->pRegions + i), ptr);
    }
}

void reservedmarshal_VkRenderingAttachmentInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderingAttachmentInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkImageView((*&forMarshaling->imageView));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (VkImageLayout*)&forMarshaling->imageLayout, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    memcpy(*ptr, (VkResolveModeFlagBits*)&forMarshaling->resolveMode, sizeof(VkResolveModeFlagBits));
    *ptr += sizeof(VkResolveModeFlagBits);
    uint64_t cgen_var_1;
    *&cgen_var_1 = get_host_u64_VkImageView((*&forMarshaling->resolveImageView));
    memcpy(*ptr, (uint64_t*)&cgen_var_1, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (VkImageLayout*)&forMarshaling->resolveImageLayout, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    memcpy(*ptr, (VkAttachmentLoadOp*)&forMarshaling->loadOp, sizeof(VkAttachmentLoadOp));
    *ptr += sizeof(VkAttachmentLoadOp);
    memcpy(*ptr, (VkAttachmentStoreOp*)&forMarshaling->storeOp, sizeof(VkAttachmentStoreOp));
    *ptr += sizeof(VkAttachmentStoreOp);
    reservedmarshal_VkClearValue(vkStream, rootType, (VkClearValue*)(&forMarshaling->clearValue), ptr);
}

void reservedmarshal_VkRenderingInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderingInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkRenderingFlags*)&forMarshaling->flags, sizeof(VkRenderingFlags));
    *ptr += sizeof(VkRenderingFlags);
    reservedmarshal_VkRect2D(vkStream, rootType, (VkRect2D*)(&forMarshaling->renderArea), ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->layerCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->viewMask, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->colorAttachmentCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->colorAttachmentCount; ++i)
    {
        reservedmarshal_VkRenderingAttachmentInfo(vkStream, rootType, (const VkRenderingAttachmentInfo*)(forMarshaling->pColorAttachments + i), ptr);
    }
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pDepthAttachment;
    memcpy((*ptr), &cgen_var_0, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pDepthAttachment)
    {
        reservedmarshal_VkRenderingAttachmentInfo(vkStream, rootType, (const VkRenderingAttachmentInfo*)(forMarshaling->pDepthAttachment), ptr);
    }
    // WARNING PTR CHECK
    uint64_t cgen_var_1 = (uint64_t)(uintptr_t)forMarshaling->pStencilAttachment;
    memcpy((*ptr), &cgen_var_1, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pStencilAttachment)
    {
        reservedmarshal_VkRenderingAttachmentInfo(vkStream, rootType, (const VkRenderingAttachmentInfo*)(forMarshaling->pStencilAttachment), ptr);
    }
}

void reservedmarshal_VkPipelineRenderingCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineRenderingCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->viewMask, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->colorAttachmentCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pColorAttachmentFormats;
    memcpy((*ptr), &cgen_var_0, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pColorAttachmentFormats)
    {
        if (forMarshaling->colorAttachmentCount > 0)
        {
            memcpy(*ptr, (const VkFormat*)forMarshaling->pColorAttachmentFormats, forMarshaling->colorAttachmentCount * sizeof(const VkFormat));
            *ptr += forMarshaling->colorAttachmentCount * sizeof(const VkFormat);
        }
    }
    memcpy(*ptr, (VkFormat*)&forMarshaling->depthAttachmentFormat, sizeof(VkFormat));
    *ptr += sizeof(VkFormat);
    memcpy(*ptr, (VkFormat*)&forMarshaling->stencilAttachmentFormat, sizeof(VkFormat));
    *ptr += sizeof(VkFormat);
}

void reservedmarshal_VkPhysicalDeviceDynamicRenderingFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceDynamicRenderingFeatures* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->dynamicRendering, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkCommandBufferInheritanceRenderingInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCommandBufferInheritanceRenderingInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkRenderingFlags*)&forMarshaling->flags, sizeof(VkRenderingFlags));
    *ptr += sizeof(VkRenderingFlags);
    memcpy(*ptr, (uint32_t*)&forMarshaling->viewMask, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->colorAttachmentCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    if (forMarshaling->colorAttachmentCount > 0)
    {
        memcpy(*ptr, (const VkFormat*)forMarshaling->pColorAttachmentFormats, forMarshaling->colorAttachmentCount * sizeof(const VkFormat));
        *ptr += forMarshaling->colorAttachmentCount * sizeof(const VkFormat);
    }
    memcpy(*ptr, (VkFormat*)&forMarshaling->depthAttachmentFormat, sizeof(VkFormat));
    *ptr += sizeof(VkFormat);
    memcpy(*ptr, (VkFormat*)&forMarshaling->stencilAttachmentFormat, sizeof(VkFormat));
    *ptr += sizeof(VkFormat);
    memcpy(*ptr, (VkSampleCountFlagBits*)&forMarshaling->rasterizationSamples, sizeof(VkSampleCountFlagBits));
    *ptr += sizeof(VkSampleCountFlagBits);
}

#endif
#ifdef VK_BASE_VERSION_1_4
void reservedmarshal_VkPhysicalDeviceVulkan14Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan14Features* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->globalPriorityQuery, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderSubgroupRotate, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderSubgroupRotateClustered, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderFloatControls2, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderExpectAssume, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->rectangularLines, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->bresenhamLines, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->smoothLines, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->stippledRectangularLines, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->stippledBresenhamLines, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->stippledSmoothLines, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->vertexAttributeInstanceRateDivisor, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->vertexAttributeInstanceRateZeroDivisor, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->indexTypeUint8, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->dynamicRenderingLocalRead, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->maintenance5, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->maintenance6, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->pipelineProtectedAccess, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->pipelineRobustness, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->hostImageCopy, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->pushDescriptor, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDeviceVulkan14Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan14Properties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->lineSubPixelPrecisionBits, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxVertexAttribDivisor, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkBool32*)&forMarshaling->supportsNonZeroFirstInstance, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxPushDescriptors, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkBool32*)&forMarshaling->dynamicRenderingLocalReadDepthStencilAttachments, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->dynamicRenderingLocalReadMultisampledAttachments, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->earlyFragmentMultisampleCoverageAfterSampleCounting, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->earlyFragmentSampleMaskTestBeforeSampleCounting, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->depthStencilSwizzleOneSupport, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->polygonModePointSize, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->nonStrictSinglePixelWideLinesUseParallelogram, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->nonStrictWideLinesUseParallelogram, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->blockTexelViewCompatibleMultipleLayers, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxCombinedImageSamplerDescriptorCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkBool32*)&forMarshaling->fragmentShadingRateClampCombinerInputs, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkPipelineRobustnessBufferBehavior*)&forMarshaling->defaultRobustnessStorageBuffers, sizeof(VkPipelineRobustnessBufferBehavior));
    *ptr += sizeof(VkPipelineRobustnessBufferBehavior);
    memcpy(*ptr, (VkPipelineRobustnessBufferBehavior*)&forMarshaling->defaultRobustnessUniformBuffers, sizeof(VkPipelineRobustnessBufferBehavior));
    *ptr += sizeof(VkPipelineRobustnessBufferBehavior);
    memcpy(*ptr, (VkPipelineRobustnessBufferBehavior*)&forMarshaling->defaultRobustnessVertexInputs, sizeof(VkPipelineRobustnessBufferBehavior));
    *ptr += sizeof(VkPipelineRobustnessBufferBehavior);
    memcpy(*ptr, (VkPipelineRobustnessImageBehavior*)&forMarshaling->defaultRobustnessImages, sizeof(VkPipelineRobustnessImageBehavior));
    *ptr += sizeof(VkPipelineRobustnessImageBehavior);
    memcpy(*ptr, (uint32_t*)&forMarshaling->copySrcLayoutCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pCopySrcLayouts;
    memcpy((*ptr), &cgen_var_0, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pCopySrcLayouts)
    {
        if (forMarshaling->copySrcLayoutCount > 0)
        {
            memcpy(*ptr, (VkImageLayout*)forMarshaling->pCopySrcLayouts, forMarshaling->copySrcLayoutCount * sizeof(VkImageLayout));
            *ptr += forMarshaling->copySrcLayoutCount * sizeof(VkImageLayout);
        }
    }
    memcpy(*ptr, (uint32_t*)&forMarshaling->copyDstLayoutCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    // WARNING PTR CHECK
    uint64_t cgen_var_1 = (uint64_t)(uintptr_t)forMarshaling->pCopyDstLayouts;
    memcpy((*ptr), &cgen_var_1, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pCopyDstLayouts)
    {
        if (forMarshaling->copyDstLayoutCount > 0)
        {
            memcpy(*ptr, (VkImageLayout*)forMarshaling->pCopyDstLayouts, forMarshaling->copyDstLayoutCount * sizeof(VkImageLayout));
            *ptr += forMarshaling->copyDstLayoutCount * sizeof(VkImageLayout);
        }
    }
    memcpy(*ptr, (uint8_t*)forMarshaling->optimalTilingLayoutUUID, VK_UUID_SIZE * sizeof(uint8_t));
    *ptr += VK_UUID_SIZE * sizeof(uint8_t);
    memcpy(*ptr, (VkBool32*)&forMarshaling->identicalMemoryTypeRequirements, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkDeviceQueueGlobalPriorityCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceQueueGlobalPriorityCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkQueueGlobalPriority*)&forMarshaling->globalPriority, sizeof(VkQueueGlobalPriority));
    *ptr += sizeof(VkQueueGlobalPriority);
}

void reservedmarshal_VkPhysicalDeviceGlobalPriorityQueryFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceGlobalPriorityQueryFeatures* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->globalPriorityQuery, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkQueueFamilyGlobalPriorityProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkQueueFamilyGlobalPriorityProperties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->priorityCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkQueueGlobalPriority*)forMarshaling->priorities, VK_MAX_GLOBAL_PRIORITY_SIZE * sizeof(VkQueueGlobalPriority));
    *ptr += VK_MAX_GLOBAL_PRIORITY_SIZE * sizeof(VkQueueGlobalPriority);
}

void reservedmarshal_VkPhysicalDeviceIndexTypeUint8Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceIndexTypeUint8Features* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->indexTypeUint8, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkMemoryMapInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryMapInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkMemoryMapFlags*)&forMarshaling->flags, sizeof(VkMemoryMapFlags));
    *ptr += sizeof(VkMemoryMapFlags);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkDeviceMemory((*&forMarshaling->memory));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->offset, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->size, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
}

void reservedmarshal_VkMemoryUnmapInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryUnmapInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkMemoryUnmapFlags*)&forMarshaling->flags, sizeof(VkMemoryUnmapFlags));
    *ptr += sizeof(VkMemoryUnmapFlags);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkDeviceMemory((*&forMarshaling->memory));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
}

void reservedmarshal_VkPhysicalDeviceMaintenance5Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance5Features* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->maintenance5, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDeviceMaintenance5Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance5Properties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->earlyFragmentMultisampleCoverageAfterSampleCounting, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->earlyFragmentSampleMaskTestBeforeSampleCounting, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->depthStencilSwizzleOneSupport, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->polygonModePointSize, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->nonStrictSinglePixelWideLinesUseParallelogram, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->nonStrictWideLinesUseParallelogram, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkImageSubresource2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageSubresource2* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    reservedmarshal_VkImageSubresource(vkStream, rootType, (VkImageSubresource*)(&forMarshaling->imageSubresource), ptr);
}

void reservedmarshal_VkDeviceImageSubresourceInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceImageSubresourceInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    reservedmarshal_VkImageCreateInfo(vkStream, rootType, (const VkImageCreateInfo*)(forMarshaling->pCreateInfo), ptr);
    reservedmarshal_VkImageSubresource2(vkStream, rootType, (const VkImageSubresource2*)(forMarshaling->pSubresource), ptr);
}

void reservedmarshal_VkSubresourceLayout2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubresourceLayout2* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    reservedmarshal_VkSubresourceLayout(vkStream, rootType, (VkSubresourceLayout*)(&forMarshaling->subresourceLayout), ptr);
}

void reservedmarshal_VkBufferUsageFlags2CreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferUsageFlags2CreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBufferUsageFlags2*)&forMarshaling->usage, sizeof(VkBufferUsageFlags2));
    *ptr += sizeof(VkBufferUsageFlags2);
}

void reservedmarshal_VkPhysicalDeviceMaintenance6Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance6Features* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->maintenance6, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDeviceMaintenance6Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance6Properties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->blockTexelViewCompatibleMultipleLayers, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxCombinedImageSamplerDescriptorCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkBool32*)&forMarshaling->fragmentShadingRateClampCombinerInputs, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkBindMemoryStatus(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBindMemoryStatus* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkResult*)forMarshaling->pResult, sizeof(VkResult));
    *ptr += sizeof(VkResult);
}

void reservedmarshal_VkPhysicalDeviceHostImageCopyFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceHostImageCopyFeatures* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->hostImageCopy, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDeviceHostImageCopyProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceHostImageCopyProperties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->copySrcLayoutCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pCopySrcLayouts;
    memcpy((*ptr), &cgen_var_0, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pCopySrcLayouts)
    {
        if (forMarshaling->copySrcLayoutCount > 0)
        {
            memcpy(*ptr, (VkImageLayout*)forMarshaling->pCopySrcLayouts, forMarshaling->copySrcLayoutCount * sizeof(VkImageLayout));
            *ptr += forMarshaling->copySrcLayoutCount * sizeof(VkImageLayout);
        }
    }
    memcpy(*ptr, (uint32_t*)&forMarshaling->copyDstLayoutCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    // WARNING PTR CHECK
    uint64_t cgen_var_1 = (uint64_t)(uintptr_t)forMarshaling->pCopyDstLayouts;
    memcpy((*ptr), &cgen_var_1, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pCopyDstLayouts)
    {
        if (forMarshaling->copyDstLayoutCount > 0)
        {
            memcpy(*ptr, (VkImageLayout*)forMarshaling->pCopyDstLayouts, forMarshaling->copyDstLayoutCount * sizeof(VkImageLayout));
            *ptr += forMarshaling->copyDstLayoutCount * sizeof(VkImageLayout);
        }
    }
    memcpy(*ptr, (uint8_t*)forMarshaling->optimalTilingLayoutUUID, VK_UUID_SIZE * sizeof(uint8_t));
    *ptr += VK_UUID_SIZE * sizeof(uint8_t);
    memcpy(*ptr, (VkBool32*)&forMarshaling->identicalMemoryTypeRequirements, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkMemoryToImageCopy(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryToImageCopy* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (const void*)forMarshaling->pHostPointer, sizeof(const uint8_t));
    *ptr += sizeof(const uint8_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->memoryRowLength, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->memoryImageHeight, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    reservedmarshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forMarshaling->imageSubresource), ptr);
    reservedmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forMarshaling->imageOffset), ptr);
    reservedmarshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forMarshaling->imageExtent), ptr);
}

void reservedmarshal_VkImageToMemoryCopy(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageToMemoryCopy* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (void*)forMarshaling->pHostPointer, sizeof(uint8_t));
    *ptr += sizeof(uint8_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->memoryRowLength, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->memoryImageHeight, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    reservedmarshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forMarshaling->imageSubresource), ptr);
    reservedmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forMarshaling->imageOffset), ptr);
    reservedmarshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forMarshaling->imageExtent), ptr);
}

void reservedmarshal_VkCopyMemoryToImageInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCopyMemoryToImageInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkHostImageCopyFlags*)&forMarshaling->flags, sizeof(VkHostImageCopyFlags));
    *ptr += sizeof(VkHostImageCopyFlags);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkImage((*&forMarshaling->dstImage));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (VkImageLayout*)&forMarshaling->dstImageLayout, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    memcpy(*ptr, (uint32_t*)&forMarshaling->regionCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->regionCount; ++i)
    {
        reservedmarshal_VkMemoryToImageCopy(vkStream, rootType, (const VkMemoryToImageCopy*)(forMarshaling->pRegions + i), ptr);
    }
}

void reservedmarshal_VkCopyImageToMemoryInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCopyImageToMemoryInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkHostImageCopyFlags*)&forMarshaling->flags, sizeof(VkHostImageCopyFlags));
    *ptr += sizeof(VkHostImageCopyFlags);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkImage((*&forMarshaling->srcImage));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (VkImageLayout*)&forMarshaling->srcImageLayout, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    memcpy(*ptr, (uint32_t*)&forMarshaling->regionCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->regionCount; ++i)
    {
        reservedmarshal_VkImageToMemoryCopy(vkStream, rootType, (const VkImageToMemoryCopy*)(forMarshaling->pRegions + i), ptr);
    }
}

void reservedmarshal_VkCopyImageToImageInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCopyImageToImageInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkHostImageCopyFlags*)&forMarshaling->flags, sizeof(VkHostImageCopyFlags));
    *ptr += sizeof(VkHostImageCopyFlags);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkImage((*&forMarshaling->srcImage));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (VkImageLayout*)&forMarshaling->srcImageLayout, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    uint64_t cgen_var_1;
    *&cgen_var_1 = get_host_u64_VkImage((*&forMarshaling->dstImage));
    memcpy(*ptr, (uint64_t*)&cgen_var_1, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (VkImageLayout*)&forMarshaling->dstImageLayout, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    memcpy(*ptr, (uint32_t*)&forMarshaling->regionCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->regionCount; ++i)
    {
        reservedmarshal_VkImageCopy2(vkStream, rootType, (const VkImageCopy2*)(forMarshaling->pRegions + i), ptr);
    }
}

void reservedmarshal_VkHostImageLayoutTransitionInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkHostImageLayoutTransitionInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkImage((*&forMarshaling->image));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (VkImageLayout*)&forMarshaling->oldLayout, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    memcpy(*ptr, (VkImageLayout*)&forMarshaling->newLayout, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    reservedmarshal_VkImageSubresourceRange(vkStream, rootType, (VkImageSubresourceRange*)(&forMarshaling->subresourceRange), ptr);
}

void reservedmarshal_VkSubresourceHostMemcpySize(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubresourceHostMemcpySize* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->size, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
}

void reservedmarshal_VkHostImageCopyDevicePerformanceQuery(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkHostImageCopyDevicePerformanceQuery* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->optimalDeviceAccess, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->identicalMemoryLayout, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

#endif
#ifdef VK_COMPUTE_VERSION_1_4
void reservedmarshal_VkPhysicalDeviceShaderSubgroupRotateFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderSubgroupRotateFeatures* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderSubgroupRotate, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderSubgroupRotateClustered, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDeviceShaderFloatControls2Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderFloatControls2Features* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderFloatControls2, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDeviceShaderExpectAssumeFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderExpectAssumeFeatures* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->shaderExpectAssume, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPipelineCreateFlags2CreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineCreateFlags2CreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkPipelineCreateFlags2*)&forMarshaling->flags, sizeof(VkPipelineCreateFlags2));
    *ptr += sizeof(VkPipelineCreateFlags2);
}

void reservedmarshal_VkPhysicalDevicePushDescriptorProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevicePushDescriptorProperties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxPushDescriptors, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkBindDescriptorSetsInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBindDescriptorSetsInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkShaderStageFlags*)&forMarshaling->stageFlags, sizeof(VkShaderStageFlags));
    *ptr += sizeof(VkShaderStageFlags);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkPipelineLayout((*&forMarshaling->layout));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (uint32_t*)&forMarshaling->firstSet, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->descriptorSetCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    if (forMarshaling->descriptorSetCount)
    {
        uint8_t* cgen_var_1_ptr = (uint8_t*)(*ptr);
        if (forMarshaling)
        {
            for (uint32_t k = 0; k < forMarshaling->descriptorSetCount; ++k)
            {
                uint64_t tmpval = get_host_u64_VkDescriptorSet(forMarshaling->pDescriptorSets[k]);
                memcpy(cgen_var_1_ptr + k * 8, &tmpval, sizeof(uint64_t));
            }
        }
        *ptr += 8 * forMarshaling->descriptorSetCount;
    }
    memcpy(*ptr, (uint32_t*)&forMarshaling->dynamicOffsetCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    // WARNING PTR CHECK
    uint64_t cgen_var_2 = (uint64_t)(uintptr_t)forMarshaling->pDynamicOffsets;
    memcpy((*ptr), &cgen_var_2, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pDynamicOffsets)
    {
        if (forMarshaling->dynamicOffsetCount > 0)
        {
            memcpy(*ptr, (const uint32_t*)forMarshaling->pDynamicOffsets, forMarshaling->dynamicOffsetCount * sizeof(const uint32_t));
            *ptr += forMarshaling->dynamicOffsetCount * sizeof(const uint32_t);
        }
    }
}

void reservedmarshal_VkPushConstantsInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPushConstantsInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkPipelineLayout((*&forMarshaling->layout));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (VkShaderStageFlags*)&forMarshaling->stageFlags, sizeof(VkShaderStageFlags));
    *ptr += sizeof(VkShaderStageFlags);
    memcpy(*ptr, (uint32_t*)&forMarshaling->offset, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->size, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    if (forMarshaling->size > 0)
    {
        memcpy(*ptr, (const void*)forMarshaling->pValues, forMarshaling->size * sizeof(const uint8_t));
        *ptr += forMarshaling->size * sizeof(const uint8_t);
    }
}

void reservedmarshal_VkPushDescriptorSetInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPushDescriptorSetInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkShaderStageFlags*)&forMarshaling->stageFlags, sizeof(VkShaderStageFlags));
    *ptr += sizeof(VkShaderStageFlags);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkPipelineLayout((*&forMarshaling->layout));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (uint32_t*)&forMarshaling->set, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->descriptorWriteCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->descriptorWriteCount; ++i)
    {
        reservedmarshal_VkWriteDescriptorSet(vkStream, rootType, (const VkWriteDescriptorSet*)(forMarshaling->pDescriptorWrites + i), ptr);
    }
}

void reservedmarshal_VkPushDescriptorSetWithTemplateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPushDescriptorSetWithTemplateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkDescriptorUpdateTemplate((*&forMarshaling->descriptorUpdateTemplate));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    uint64_t cgen_var_1;
    *&cgen_var_1 = get_host_u64_VkPipelineLayout((*&forMarshaling->layout));
    memcpy(*ptr, (uint64_t*)&cgen_var_1, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (uint32_t*)&forMarshaling->set, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (const void*)forMarshaling->pData, sizeof(const uint8_t));
    *ptr += sizeof(const uint8_t);
}

void reservedmarshal_VkPhysicalDevicePipelineProtectedAccessFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevicePipelineProtectedAccessFeatures* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->pipelineProtectedAccess, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDevicePipelineRobustnessFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevicePipelineRobustnessFeatures* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->pipelineRobustness, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDevicePipelineRobustnessProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevicePipelineRobustnessProperties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkPipelineRobustnessBufferBehavior*)&forMarshaling->defaultRobustnessStorageBuffers, sizeof(VkPipelineRobustnessBufferBehavior));
    *ptr += sizeof(VkPipelineRobustnessBufferBehavior);
    memcpy(*ptr, (VkPipelineRobustnessBufferBehavior*)&forMarshaling->defaultRobustnessUniformBuffers, sizeof(VkPipelineRobustnessBufferBehavior));
    *ptr += sizeof(VkPipelineRobustnessBufferBehavior);
    memcpy(*ptr, (VkPipelineRobustnessBufferBehavior*)&forMarshaling->defaultRobustnessVertexInputs, sizeof(VkPipelineRobustnessBufferBehavior));
    *ptr += sizeof(VkPipelineRobustnessBufferBehavior);
    memcpy(*ptr, (VkPipelineRobustnessImageBehavior*)&forMarshaling->defaultRobustnessImages, sizeof(VkPipelineRobustnessImageBehavior));
    *ptr += sizeof(VkPipelineRobustnessImageBehavior);
}

void reservedmarshal_VkPipelineRobustnessCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineRobustnessCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkPipelineRobustnessBufferBehavior*)&forMarshaling->storageBuffers, sizeof(VkPipelineRobustnessBufferBehavior));
    *ptr += sizeof(VkPipelineRobustnessBufferBehavior);
    memcpy(*ptr, (VkPipelineRobustnessBufferBehavior*)&forMarshaling->uniformBuffers, sizeof(VkPipelineRobustnessBufferBehavior));
    *ptr += sizeof(VkPipelineRobustnessBufferBehavior);
    memcpy(*ptr, (VkPipelineRobustnessBufferBehavior*)&forMarshaling->vertexInputs, sizeof(VkPipelineRobustnessBufferBehavior));
    *ptr += sizeof(VkPipelineRobustnessBufferBehavior);
    memcpy(*ptr, (VkPipelineRobustnessImageBehavior*)&forMarshaling->images, sizeof(VkPipelineRobustnessImageBehavior));
    *ptr += sizeof(VkPipelineRobustnessImageBehavior);
}

#endif
#ifdef VK_GRAPHICS_VERSION_1_4
void reservedmarshal_VkPhysicalDeviceLineRasterizationFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceLineRasterizationFeatures* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->rectangularLines, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->bresenhamLines, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->smoothLines, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->stippledRectangularLines, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->stippledBresenhamLines, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->stippledSmoothLines, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDeviceLineRasterizationProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceLineRasterizationProperties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->lineSubPixelPrecisionBits, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkPipelineRasterizationLineStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineRasterizationLineStateCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkLineRasterizationMode*)&forMarshaling->lineRasterizationMode, sizeof(VkLineRasterizationMode));
    *ptr += sizeof(VkLineRasterizationMode);
    memcpy(*ptr, (VkBool32*)&forMarshaling->stippledLineEnable, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (uint32_t*)&forMarshaling->lineStippleFactor, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint16_t*)&forMarshaling->lineStipplePattern, sizeof(uint16_t));
    *ptr += sizeof(uint16_t);
}

void reservedmarshal_VkPhysicalDeviceVertexAttributeDivisorProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVertexAttributeDivisorProperties* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxVertexAttribDivisor, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkBool32*)&forMarshaling->supportsNonZeroFirstInstance, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkVertexInputBindingDivisorDescription(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkVertexInputBindingDivisorDescription* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (uint32_t*)&forMarshaling->binding, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->divisor, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkPipelineVertexInputDivisorStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineVertexInputDivisorStateCreateInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->vertexBindingDivisorCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->vertexBindingDivisorCount; ++i)
    {
        reservedmarshal_VkVertexInputBindingDivisorDescription(vkStream, rootType, (const VkVertexInputBindingDivisorDescription*)(forMarshaling->pVertexBindingDivisors + i), ptr);
    }
}

void reservedmarshal_VkPhysicalDeviceVertexAttributeDivisorFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVertexAttributeDivisorFeatures* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->vertexAttributeInstanceRateDivisor, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->vertexAttributeInstanceRateZeroDivisor, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkRenderingAreaInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderingAreaInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->viewMask, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->colorAttachmentCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pColorAttachmentFormats;
    memcpy((*ptr), &cgen_var_0, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pColorAttachmentFormats)
    {
        if (forMarshaling->colorAttachmentCount > 0)
        {
            memcpy(*ptr, (const VkFormat*)forMarshaling->pColorAttachmentFormats, forMarshaling->colorAttachmentCount * sizeof(const VkFormat));
            *ptr += forMarshaling->colorAttachmentCount * sizeof(const VkFormat);
        }
    }
    memcpy(*ptr, (VkFormat*)&forMarshaling->depthAttachmentFormat, sizeof(VkFormat));
    *ptr += sizeof(VkFormat);
    memcpy(*ptr, (VkFormat*)&forMarshaling->stencilAttachmentFormat, sizeof(VkFormat));
    *ptr += sizeof(VkFormat);
}

void reservedmarshal_VkPhysicalDeviceDynamicRenderingLocalReadFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceDynamicRenderingLocalReadFeatures* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->dynamicRenderingLocalRead, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkRenderingAttachmentLocationInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderingAttachmentLocationInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->colorAttachmentCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pColorAttachmentLocations;
    memcpy((*ptr), &cgen_var_0, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pColorAttachmentLocations)
    {
        if (forMarshaling->colorAttachmentCount > 0)
        {
            memcpy(*ptr, (const uint32_t*)forMarshaling->pColorAttachmentLocations, forMarshaling->colorAttachmentCount * sizeof(const uint32_t));
            *ptr += forMarshaling->colorAttachmentCount * sizeof(const uint32_t);
        }
    }
}

void reservedmarshal_VkRenderingInputAttachmentIndexInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderingInputAttachmentIndexInfo* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->colorAttachmentCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pColorAttachmentInputIndices;
    memcpy((*ptr), &cgen_var_0, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pColorAttachmentInputIndices)
    {
        if (forMarshaling->colorAttachmentCount > 0)
        {
            memcpy(*ptr, (const uint32_t*)forMarshaling->pColorAttachmentInputIndices, forMarshaling->colorAttachmentCount * sizeof(const uint32_t));
            *ptr += forMarshaling->colorAttachmentCount * sizeof(const uint32_t);
        }
    }
    // WARNING PTR CHECK
    uint64_t cgen_var_1 = (uint64_t)(uintptr_t)forMarshaling->pDepthInputAttachmentIndex;
    memcpy((*ptr), &cgen_var_1, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pDepthInputAttachmentIndex)
    {
        memcpy(*ptr, (const uint32_t*)forMarshaling->pDepthInputAttachmentIndex, sizeof(const uint32_t));
        *ptr += sizeof(const uint32_t);
    }
    // WARNING PTR CHECK
    uint64_t cgen_var_2 = (uint64_t)(uintptr_t)forMarshaling->pStencilInputAttachmentIndex;
    memcpy((*ptr), &cgen_var_2, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pStencilInputAttachmentIndex)
    {
        memcpy(*ptr, (const uint32_t*)forMarshaling->pStencilInputAttachmentIndex, sizeof(const uint32_t));
        *ptr += sizeof(const uint32_t);
    }
}

#endif
#ifdef VK_KHR_external_semaphore_fd
void reservedmarshal_VkImportSemaphoreFdInfoKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImportSemaphoreFdInfoKHR* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkSemaphore((*&forMarshaling->semaphore));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (VkSemaphoreImportFlags*)&forMarshaling->flags, sizeof(VkSemaphoreImportFlags));
    *ptr += sizeof(VkSemaphoreImportFlags);
    memcpy(*ptr, (VkExternalSemaphoreHandleTypeFlagBits*)&forMarshaling->handleType, sizeof(VkExternalSemaphoreHandleTypeFlagBits));
    *ptr += sizeof(VkExternalSemaphoreHandleTypeFlagBits);
    memcpy(*ptr, (int*)&forMarshaling->fd, sizeof(int));
    *ptr += sizeof(int);
}

void reservedmarshal_VkSemaphoreGetFdInfoKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSemaphoreGetFdInfoKHR* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkSemaphore((*&forMarshaling->semaphore));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (VkExternalSemaphoreHandleTypeFlagBits*)&forMarshaling->handleType, sizeof(VkExternalSemaphoreHandleTypeFlagBits));
    *ptr += sizeof(VkExternalSemaphoreHandleTypeFlagBits);
}

#endif
#ifdef VK_KHR_incremental_present
void reservedmarshal_VkRectLayerKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRectLayerKHR* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    reservedmarshal_VkOffset2D(vkStream, rootType, (VkOffset2D*)(&forMarshaling->offset), ptr);
    reservedmarshal_VkExtent2D(vkStream, rootType, (VkExtent2D*)(&forMarshaling->extent), ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->layer, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkPresentRegionKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPresentRegionKHR* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (uint32_t*)&forMarshaling->rectangleCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pRectangles;
    memcpy((*ptr), &cgen_var_0, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pRectangles)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->rectangleCount; ++i)
        {
            reservedmarshal_VkRectLayerKHR(vkStream, rootType, (const VkRectLayerKHR*)(forMarshaling->pRectangles + i), ptr);
        }
    }
}

void reservedmarshal_VkPresentRegionsKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPresentRegionsKHR* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->swapchainCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pRegions;
    memcpy((*ptr), &cgen_var_0, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pRegions)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->swapchainCount; ++i)
        {
            reservedmarshal_VkPresentRegionKHR(vkStream, rootType, (const VkPresentRegionKHR*)(forMarshaling->pRegions + i), ptr);
        }
    }
}

#endif
#ifdef VK_KHR_external_fence_fd
void reservedmarshal_VkImportFenceFdInfoKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImportFenceFdInfoKHR* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkFence((*&forMarshaling->fence));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (VkFenceImportFlags*)&forMarshaling->flags, sizeof(VkFenceImportFlags));
    *ptr += sizeof(VkFenceImportFlags);
    memcpy(*ptr, (VkExternalFenceHandleTypeFlagBits*)&forMarshaling->handleType, sizeof(VkExternalFenceHandleTypeFlagBits));
    *ptr += sizeof(VkExternalFenceHandleTypeFlagBits);
    memcpy(*ptr, (int*)&forMarshaling->fd, sizeof(int));
    *ptr += sizeof(int);
}

void reservedmarshal_VkFenceGetFdInfoKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkFenceGetFdInfoKHR* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkFence((*&forMarshaling->fence));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (VkExternalFenceHandleTypeFlagBits*)&forMarshaling->handleType, sizeof(VkExternalFenceHandleTypeFlagBits));
    *ptr += sizeof(VkExternalFenceHandleTypeFlagBits);
}

#endif
#ifdef VK_KHR_pipeline_executable_properties
void reservedmarshal_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->pipelineExecutableInfo, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPipelineInfoKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineInfoKHR* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkPipeline((*&forMarshaling->pipeline));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
}

void reservedmarshal_VkPipelineExecutablePropertiesKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineExecutablePropertiesKHR* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkShaderStageFlags*)&forMarshaling->stages, sizeof(VkShaderStageFlags));
    *ptr += sizeof(VkShaderStageFlags);
    memcpy(*ptr, (char*)forMarshaling->name, VK_MAX_DESCRIPTION_SIZE * sizeof(char));
    *ptr += VK_MAX_DESCRIPTION_SIZE * sizeof(char);
    memcpy(*ptr, (char*)forMarshaling->description, VK_MAX_DESCRIPTION_SIZE * sizeof(char));
    *ptr += VK_MAX_DESCRIPTION_SIZE * sizeof(char);
    memcpy(*ptr, (uint32_t*)&forMarshaling->subgroupSize, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkPipelineExecutableInfoKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineExecutableInfoKHR* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkPipeline((*&forMarshaling->pipeline));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (uint32_t*)&forMarshaling->executableIndex, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkPipelineExecutableStatisticValueKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineExecutableStatisticValueKHR* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkBool32*)&forMarshaling->b32, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPipelineExecutableStatisticKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineExecutableStatisticKHR* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (char*)forMarshaling->name, VK_MAX_DESCRIPTION_SIZE * sizeof(char));
    *ptr += VK_MAX_DESCRIPTION_SIZE * sizeof(char);
    memcpy(*ptr, (char*)forMarshaling->description, VK_MAX_DESCRIPTION_SIZE * sizeof(char));
    *ptr += VK_MAX_DESCRIPTION_SIZE * sizeof(char);
    memcpy(*ptr, (VkPipelineExecutableStatisticFormatKHR*)&forMarshaling->format, sizeof(VkPipelineExecutableStatisticFormatKHR));
    *ptr += sizeof(VkPipelineExecutableStatisticFormatKHR);
    reservedmarshal_VkPipelineExecutableStatisticValueKHR(vkStream, rootType, (VkPipelineExecutableStatisticValueKHR*)(&forMarshaling->value), ptr);
}

void reservedmarshal_VkPipelineExecutableInternalRepresentationKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineExecutableInternalRepresentationKHR* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (char*)forMarshaling->name, VK_MAX_DESCRIPTION_SIZE * sizeof(char));
    *ptr += VK_MAX_DESCRIPTION_SIZE * sizeof(char);
    memcpy(*ptr, (char*)forMarshaling->description, VK_MAX_DESCRIPTION_SIZE * sizeof(char));
    *ptr += VK_MAX_DESCRIPTION_SIZE * sizeof(char);
    memcpy(*ptr, (VkBool32*)&forMarshaling->isText, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    uint64_t cgen_var_0 = (uint64_t)forMarshaling->dataSize;
    memcpy((*ptr), &cgen_var_0, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    // WARNING PTR CHECK
    uint64_t cgen_var_1 = (uint64_t)(uintptr_t)forMarshaling->pData;
    memcpy((*ptr), &cgen_var_1, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pData)
    {
        if (forMarshaling->dataSize > 0)
        {
            memcpy(*ptr, (void*)forMarshaling->pData, forMarshaling->dataSize * sizeof(uint8_t));
            *ptr += forMarshaling->dataSize * sizeof(uint8_t);
        }
    }
}

#endif
#ifdef VK_ANDROID_native_buffer
void reservedmarshal_VkNativeBufferUsage2ANDROID(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkNativeBufferUsage2ANDROID* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (uint64_t*)&forMarshaling->consumer, sizeof(uint64_t));
    *ptr += sizeof(uint64_t);
    memcpy(*ptr, (uint64_t*)&forMarshaling->producer, sizeof(uint64_t));
    *ptr += sizeof(uint64_t);
}

void reservedmarshal_VkNativeBufferANDROID(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkNativeBufferANDROID* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->handle;
    memcpy((*ptr), &cgen_var_0, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->handle)
    {
        memcpy(*ptr, (const uint32_t*)forMarshaling->handle, sizeof(const uint32_t));
        *ptr += sizeof(const uint32_t);
    }
    memcpy(*ptr, (int*)&forMarshaling->stride, sizeof(int));
    *ptr += sizeof(int);
    memcpy(*ptr, (int*)&forMarshaling->format, sizeof(int));
    *ptr += sizeof(int);
    memcpy(*ptr, (int*)&forMarshaling->usage, sizeof(int));
    *ptr += sizeof(int);
    reservedmarshal_VkNativeBufferUsage2ANDROID(vkStream, rootType, (VkNativeBufferUsage2ANDROID*)(&forMarshaling->usage2), ptr);
}

void reservedmarshal_VkSwapchainImageCreateInfoANDROID(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSwapchainImageCreateInfoANDROID* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkSwapchainImageUsageFlagsANDROID*)&forMarshaling->usage, sizeof(VkSwapchainImageUsageFlagsANDROID));
    *ptr += sizeof(VkSwapchainImageUsageFlagsANDROID);
}

void reservedmarshal_VkPhysicalDevicePresentationPropertiesANDROID(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevicePresentationPropertiesANDROID* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->sharedImage, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

#endif
#ifdef VK_EXT_transform_feedback
void reservedmarshal_VkPhysicalDeviceTransformFeedbackFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceTransformFeedbackFeaturesEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->transformFeedback, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->geometryStreams, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDeviceTransformFeedbackPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceTransformFeedbackPropertiesEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxTransformFeedbackStreams, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxTransformFeedbackBuffers, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->maxTransformFeedbackBufferSize, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxTransformFeedbackStreamDataSize, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxTransformFeedbackBufferDataSize, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxTransformFeedbackBufferDataStride, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkBool32*)&forMarshaling->transformFeedbackQueries, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->transformFeedbackStreamsLinesTriangles, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->transformFeedbackRasterizationStreamSelect, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->transformFeedbackDraw, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPipelineRasterizationStateStreamCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineRasterizationStateStreamCreateInfoEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkPipelineRasterizationStateStreamCreateFlagsEXT*)&forMarshaling->flags, sizeof(VkPipelineRasterizationStateStreamCreateFlagsEXT));
    *ptr += sizeof(VkPipelineRasterizationStateStreamCreateFlagsEXT);
    memcpy(*ptr, (uint32_t*)&forMarshaling->rasterizationStream, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

#endif
#ifdef VK_EXT_depth_clip_enable
void reservedmarshal_VkPhysicalDeviceDepthClipEnableFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceDepthClipEnableFeaturesEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->depthClipEnable, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPipelineRasterizationDepthClipStateCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineRasterizationDepthClipStateCreateInfoEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkPipelineRasterizationDepthClipStateCreateFlagsEXT*)&forMarshaling->flags, sizeof(VkPipelineRasterizationDepthClipStateCreateFlagsEXT));
    *ptr += sizeof(VkPipelineRasterizationDepthClipStateCreateFlagsEXT);
    memcpy(*ptr, (VkBool32*)&forMarshaling->depthClipEnable, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

#endif
#ifdef VK_EXT_blend_operation_advanced
void reservedmarshal_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->advancedBlendCoherentOperations, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->advancedBlendMaxColorAttachments, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkBool32*)&forMarshaling->advancedBlendIndependentBlend, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->advancedBlendNonPremultipliedSrcColor, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->advancedBlendNonPremultipliedDstColor, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->advancedBlendCorrelatedOverlap, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->advancedBlendAllOperations, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPipelineColorBlendAdvancedStateCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineColorBlendAdvancedStateCreateInfoEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->srcPremultiplied, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->dstPremultiplied, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBlendOverlapEXT*)&forMarshaling->blendOverlap, sizeof(VkBlendOverlapEXT));
    *ptr += sizeof(VkBlendOverlapEXT);
}

#endif
#ifdef VK_EXT_image_drm_format_modifier
void reservedmarshal_VkDrmFormatModifierPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDrmFormatModifierPropertiesEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (uint64_t*)&forMarshaling->drmFormatModifier, sizeof(uint64_t));
    *ptr += sizeof(uint64_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->drmFormatModifierPlaneCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkFormatFeatureFlags*)&forMarshaling->drmFormatModifierTilingFeatures, sizeof(VkFormatFeatureFlags));
    *ptr += sizeof(VkFormatFeatureFlags);
}

void reservedmarshal_VkDrmFormatModifierPropertiesListEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDrmFormatModifierPropertiesListEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->drmFormatModifierCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pDrmFormatModifierProperties;
    memcpy((*ptr), &cgen_var_0, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pDrmFormatModifierProperties)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->drmFormatModifierCount; ++i)
        {
            reservedmarshal_VkDrmFormatModifierPropertiesEXT(vkStream, rootType, (VkDrmFormatModifierPropertiesEXT*)(forMarshaling->pDrmFormatModifierProperties + i), ptr);
        }
    }
}

void reservedmarshal_VkPhysicalDeviceImageDrmFormatModifierInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceImageDrmFormatModifierInfoEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint64_t*)&forMarshaling->drmFormatModifier, sizeof(uint64_t));
    *ptr += sizeof(uint64_t);
    memcpy(*ptr, (VkSharingMode*)&forMarshaling->sharingMode, sizeof(VkSharingMode));
    *ptr += sizeof(VkSharingMode);
    memcpy(*ptr, (uint32_t*)&forMarshaling->queueFamilyIndexCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pQueueFamilyIndices;
    memcpy((*ptr), &cgen_var_0, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pQueueFamilyIndices)
    {
        if (forMarshaling->queueFamilyIndexCount > 0)
        {
            memcpy(*ptr, (const uint32_t*)forMarshaling->pQueueFamilyIndices, forMarshaling->queueFamilyIndexCount * sizeof(const uint32_t));
            *ptr += forMarshaling->queueFamilyIndexCount * sizeof(const uint32_t);
        }
    }
}

void reservedmarshal_VkImageDrmFormatModifierListCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageDrmFormatModifierListCreateInfoEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->drmFormatModifierCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    if (forMarshaling->drmFormatModifierCount > 0)
    {
        memcpy(*ptr, (const uint64_t*)forMarshaling->pDrmFormatModifiers, forMarshaling->drmFormatModifierCount * sizeof(const uint64_t));
        *ptr += forMarshaling->drmFormatModifierCount * sizeof(const uint64_t);
    }
}

void reservedmarshal_VkImageDrmFormatModifierExplicitCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageDrmFormatModifierExplicitCreateInfoEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint64_t*)&forMarshaling->drmFormatModifier, sizeof(uint64_t));
    *ptr += sizeof(uint64_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->drmFormatModifierPlaneCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)forMarshaling->drmFormatModifierPlaneCount; ++i)
    {
        reservedmarshal_VkSubresourceLayout(vkStream, rootType, (const VkSubresourceLayout*)(forMarshaling->pPlaneLayouts + i), ptr);
    }
}

void reservedmarshal_VkImageDrmFormatModifierPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageDrmFormatModifierPropertiesEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint64_t*)&forMarshaling->drmFormatModifier, sizeof(uint64_t));
    *ptr += sizeof(uint64_t);
}

void reservedmarshal_VkDrmFormatModifierProperties2EXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDrmFormatModifierProperties2EXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (uint64_t*)&forMarshaling->drmFormatModifier, sizeof(uint64_t));
    *ptr += sizeof(uint64_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->drmFormatModifierPlaneCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (VkFormatFeatureFlags2*)&forMarshaling->drmFormatModifierTilingFeatures, sizeof(VkFormatFeatureFlags2));
    *ptr += sizeof(VkFormatFeatureFlags2);
}

void reservedmarshal_VkDrmFormatModifierPropertiesList2EXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDrmFormatModifierPropertiesList2EXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->drmFormatModifierCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pDrmFormatModifierProperties;
    memcpy((*ptr), &cgen_var_0, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pDrmFormatModifierProperties)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->drmFormatModifierCount; ++i)
        {
            reservedmarshal_VkDrmFormatModifierProperties2EXT(vkStream, rootType, (VkDrmFormatModifierProperties2EXT*)(forMarshaling->pDrmFormatModifierProperties + i), ptr);
        }
    }
}

#endif
#ifdef VK_EXT_vertex_attribute_divisor
void reservedmarshal_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxVertexAttribDivisor, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

#endif
#ifdef VK_EXT_fragment_density_map
void reservedmarshal_VkPhysicalDeviceFragmentDensityMapFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceFragmentDensityMapFeaturesEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->fragmentDensityMap, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->fragmentDensityMapDynamic, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->fragmentDensityMapNonSubsampledImages, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDeviceFragmentDensityMapPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceFragmentDensityMapPropertiesEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    reservedmarshal_VkExtent2D(vkStream, rootType, (VkExtent2D*)(&forMarshaling->minFragmentDensityTexelSize), ptr);
    reservedmarshal_VkExtent2D(vkStream, rootType, (VkExtent2D*)(&forMarshaling->maxFragmentDensityTexelSize), ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->fragmentDensityInvocations, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkRenderPassFragmentDensityMapCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderPassFragmentDensityMapCreateInfoEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    reservedmarshal_VkAttachmentReference(vkStream, rootType, (VkAttachmentReference*)(&forMarshaling->fragmentDensityMapAttachment), ptr);
}

void reservedmarshal_VkRenderingFragmentDensityMapAttachmentInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderingFragmentDensityMapAttachmentInfoEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    uint64_t cgen_var_0;
    *&cgen_var_0 = get_host_u64_VkImageView((*&forMarshaling->imageView));
    memcpy(*ptr, (uint64_t*)&cgen_var_0, 1 * 8);
    *ptr += 1 * 8;
    memcpy(*ptr, (VkImageLayout*)&forMarshaling->imageLayout, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
}

#endif
#ifdef VK_EXT_memory_budget
void reservedmarshal_VkPhysicalDeviceMemoryBudgetPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMemoryBudgetPropertiesEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkDeviceSize*)forMarshaling->heapBudget, VK_MAX_MEMORY_HEAPS * sizeof(VkDeviceSize));
    *ptr += VK_MAX_MEMORY_HEAPS * sizeof(VkDeviceSize);
    memcpy(*ptr, (VkDeviceSize*)forMarshaling->heapUsage, VK_MAX_MEMORY_HEAPS * sizeof(VkDeviceSize));
    *ptr += VK_MAX_MEMORY_HEAPS * sizeof(VkDeviceSize);
}

#endif
#ifdef VK_EXT_provoking_vertex
void reservedmarshal_VkPhysicalDeviceProvokingVertexFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceProvokingVertexFeaturesEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->provokingVertexLast, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->transformFeedbackPreservesProvokingVertex, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDeviceProvokingVertexPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceProvokingVertexPropertiesEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->provokingVertexModePerPipeline, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->transformFeedbackPreservesTriangleFanProvokingVertex, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPipelineRasterizationProvokingVertexStateCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineRasterizationProvokingVertexStateCreateInfoEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkProvokingVertexModeEXT*)&forMarshaling->provokingVertexMode, sizeof(VkProvokingVertexModeEXT));
    *ptr += sizeof(VkProvokingVertexModeEXT);
}

#endif
#ifdef VK_EXT_extended_dynamic_state
void reservedmarshal_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->extendedDynamicState, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

#endif
#ifdef VK_EXT_texel_buffer_alignment
void reservedmarshal_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->texelBufferAlignment, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

#endif
#ifdef VK_EXT_device_memory_report
void reservedmarshal_VkPhysicalDeviceDeviceMemoryReportFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceDeviceMemoryReportFeaturesEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->deviceMemoryReport, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkDeviceMemoryReportCallbackDataEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceMemoryReportCallbackDataEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkDeviceMemoryReportFlagsEXT*)&forMarshaling->flags, sizeof(VkDeviceMemoryReportFlagsEXT));
    *ptr += sizeof(VkDeviceMemoryReportFlagsEXT);
    memcpy(*ptr, (VkDeviceMemoryReportEventTypeEXT*)&forMarshaling->type, sizeof(VkDeviceMemoryReportEventTypeEXT));
    *ptr += sizeof(VkDeviceMemoryReportEventTypeEXT);
    memcpy(*ptr, (uint64_t*)&forMarshaling->memoryObjectId, sizeof(uint64_t));
    *ptr += sizeof(uint64_t);
    memcpy(*ptr, (VkDeviceSize*)&forMarshaling->size, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy(*ptr, (VkObjectType*)&forMarshaling->objectType, sizeof(VkObjectType));
    *ptr += sizeof(VkObjectType);
    memcpy(*ptr, (uint64_t*)&forMarshaling->objectHandle, sizeof(uint64_t));
    *ptr += sizeof(uint64_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->heapIndex, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkDeviceDeviceMemoryReportCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceDeviceMemoryReportCreateInfoEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkDeviceMemoryReportFlagsEXT*)&forMarshaling->flags, sizeof(VkDeviceMemoryReportFlagsEXT));
    *ptr += sizeof(VkDeviceMemoryReportFlagsEXT);
    uint64_t cgen_var_0 = (uint64_t)forMarshaling->pfnUserCallback;
    memcpy((*ptr), &cgen_var_0, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    memcpy(*ptr, (void*)forMarshaling->pUserData, sizeof(uint8_t));
    *ptr += sizeof(uint8_t);
}

#endif
#ifdef VK_EXT_custom_border_color
void reservedmarshal_VkSamplerCustomBorderColorCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSamplerCustomBorderColorCreateInfoEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    reservedmarshal_VkClearColorValue(vkStream, rootType, (VkClearColorValue*)(&forMarshaling->customBorderColor), ptr);
    memcpy(*ptr, (VkFormat*)&forMarshaling->format, sizeof(VkFormat));
    *ptr += sizeof(VkFormat);
}

void reservedmarshal_VkPhysicalDeviceCustomBorderColorPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceCustomBorderColorPropertiesEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->maxCustomBorderColorSamplers, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkPhysicalDeviceCustomBorderColorFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceCustomBorderColorFeaturesEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->customBorderColors, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->customBorderColorWithoutFormat, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

#endif
#ifdef VK_EXT_graphics_pipeline_library
void reservedmarshal_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->graphicsPipelineLibrary, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->graphicsPipelineLibraryFastLinking, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->graphicsPipelineLibraryIndependentInterpolationDecoration, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkGraphicsPipelineLibraryCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkGraphicsPipelineLibraryCreateInfoEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkGraphicsPipelineLibraryFlagsEXT*)&forMarshaling->flags, sizeof(VkGraphicsPipelineLibraryFlagsEXT));
    *ptr += sizeof(VkGraphicsPipelineLibraryFlagsEXT);
}

#endif
#ifdef VK_EXT_ycbcr_2plane_444_formats
void reservedmarshal_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->ycbcr2plane444Formats, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

#endif
#ifdef VK_EXT_image_compression_control
void reservedmarshal_VkPhysicalDeviceImageCompressionControlFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceImageCompressionControlFeaturesEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->imageCompressionControl, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkImageCompressionControlEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageCompressionControlEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkImageCompressionFlagsEXT*)&forMarshaling->flags, sizeof(VkImageCompressionFlagsEXT));
    *ptr += sizeof(VkImageCompressionFlagsEXT);
    memcpy(*ptr, (uint32_t*)&forMarshaling->compressionControlPlaneCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pFixedRateFlags;
    memcpy((*ptr), &cgen_var_0, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pFixedRateFlags)
    {
        if (forMarshaling->compressionControlPlaneCount > 0)
        {
            memcpy(*ptr, (VkImageCompressionFixedRateFlagsEXT*)forMarshaling->pFixedRateFlags, forMarshaling->compressionControlPlaneCount * sizeof(VkImageCompressionFixedRateFlagsEXT));
            *ptr += forMarshaling->compressionControlPlaneCount * sizeof(VkImageCompressionFixedRateFlagsEXT);
        }
    }
}

void reservedmarshal_VkImageCompressionPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageCompressionPropertiesEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkImageCompressionFlagsEXT*)&forMarshaling->imageCompressionFlags, sizeof(VkImageCompressionFlagsEXT));
    *ptr += sizeof(VkImageCompressionFlagsEXT);
    memcpy(*ptr, (VkImageCompressionFixedRateFlagsEXT*)&forMarshaling->imageCompressionFixedRateFlags, sizeof(VkImageCompressionFixedRateFlagsEXT));
    *ptr += sizeof(VkImageCompressionFixedRateFlagsEXT);
}

#endif
#ifdef VK_EXT_4444_formats
void reservedmarshal_VkPhysicalDevice4444FormatsFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevice4444FormatsFeaturesEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->formatA4R4G4B4, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->formatA4B4G4R4, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

#endif
#ifdef VK_EXT_primitive_topology_list_restart
void reservedmarshal_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->primitiveTopologyListRestart, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->primitiveTopologyPatchListRestart, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

#endif
#ifdef VK_EXT_frame_boundary
void reservedmarshal_VkPhysicalDeviceFrameBoundaryFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceFrameBoundaryFeaturesEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->frameBoundary, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkFrameBoundaryEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkFrameBoundaryEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkFrameBoundaryFlagsEXT*)&forMarshaling->flags, sizeof(VkFrameBoundaryFlagsEXT));
    *ptr += sizeof(VkFrameBoundaryFlagsEXT);
    memcpy(*ptr, (uint64_t*)&forMarshaling->frameID, sizeof(uint64_t));
    *ptr += sizeof(uint64_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->imageCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pImages;
    memcpy((*ptr), &cgen_var_0, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pImages)
    {
        if (forMarshaling->imageCount)
        {
            uint8_t* cgen_var_0_0_ptr = (uint8_t*)(*ptr);
            if (forMarshaling)
            {
                for (uint32_t k = 0; k < forMarshaling->imageCount; ++k)
                {
                    uint64_t tmpval = get_host_u64_VkImage(forMarshaling->pImages[k]);
                    memcpy(cgen_var_0_0_ptr + k * 8, &tmpval, sizeof(uint64_t));
                }
            }
            *ptr += 8 * forMarshaling->imageCount;
        }
    }
    memcpy(*ptr, (uint32_t*)&forMarshaling->bufferCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    // WARNING PTR CHECK
    uint64_t cgen_var_1 = (uint64_t)(uintptr_t)forMarshaling->pBuffers;
    memcpy((*ptr), &cgen_var_1, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pBuffers)
    {
        if (forMarshaling->bufferCount)
        {
            uint8_t* cgen_var_1_0_ptr = (uint8_t*)(*ptr);
            if (forMarshaling)
            {
                for (uint32_t k = 0; k < forMarshaling->bufferCount; ++k)
                {
                    uint64_t tmpval = get_host_u64_VkBuffer(forMarshaling->pBuffers[k]);
                    memcpy(cgen_var_1_0_ptr + k * 8, &tmpval, sizeof(uint64_t));
                }
            }
            *ptr += 8 * forMarshaling->bufferCount;
        }
    }
    memcpy(*ptr, (uint64_t*)&forMarshaling->tagName, sizeof(uint64_t));
    *ptr += sizeof(uint64_t);
    uint64_t cgen_var_2 = (uint64_t)forMarshaling->tagSize;
    memcpy((*ptr), &cgen_var_2, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    // WARNING PTR CHECK
    uint64_t cgen_var_3 = (uint64_t)(uintptr_t)forMarshaling->pTag;
    memcpy((*ptr), &cgen_var_3, 8);
    gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
    *ptr += 8;
    if (forMarshaling->pTag)
    {
        if (forMarshaling->tagSize > 0)
        {
            memcpy(*ptr, (const void*)forMarshaling->pTag, forMarshaling->tagSize * sizeof(const uint8_t));
            *ptr += forMarshaling->tagSize * sizeof(const uint8_t);
        }
    }
}

#endif
#ifdef VK_EXT_extended_dynamic_state2
void reservedmarshal_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->extendedDynamicState2, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->extendedDynamicState2LogicOp, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(*ptr, (VkBool32*)&forMarshaling->extendedDynamicState2PatchControlPoints, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

#endif
#ifdef VK_EXT_color_write_enable
void reservedmarshal_VkPhysicalDeviceColorWriteEnableFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceColorWriteEnableFeaturesEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->colorWriteEnable, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedmarshal_VkPipelineColorWriteCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineColorWriteCreateInfoEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->attachmentCount, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    if (forMarshaling->attachmentCount > 0)
    {
        memcpy(*ptr, (const VkBool32*)forMarshaling->pColorWriteEnables, forMarshaling->attachmentCount * sizeof(const VkBool32));
        *ptr += forMarshaling->attachmentCount * sizeof(const VkBool32);
    }
}

#endif
#ifdef VK_GOOGLE_gfxstream
void reservedmarshal_VkImportColorBufferGOOGLE(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImportColorBufferGOOGLE* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->colorBuffer, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkImportBufferGOOGLE(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImportBufferGOOGLE* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->buffer, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedmarshal_VkCreateBlobGOOGLE(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCreateBlobGOOGLE* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint32_t*)&forMarshaling->blobMem, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint32_t*)&forMarshaling->blobFlags, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy(*ptr, (uint64_t*)&forMarshaling->blobId, sizeof(uint64_t));
    *ptr += sizeof(uint64_t);
}

void reservedmarshal_VkDebugMetadataGuestProcessNameGOOGLE(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDebugMetadataGuestProcessNameGOOGLE* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    if (vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_NULL_OPTIONAL_STRINGS_BIT)
    {
        // WARNING PTR CHECK
        uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pName;
        memcpy((*ptr), &cgen_var_0, 8);
        gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
        *ptr += 8;
        if (forMarshaling->pName)
        {
            {
                uint32_t l = forMarshaling->pName ? strlen(forMarshaling->pName): 0;
                memcpy(*ptr, (uint32_t*)&l, sizeof(uint32_t));
                gfxstream::aemu::Stream::toBe32((uint8_t*)*ptr);
                *ptr += sizeof(uint32_t);
                memcpy(*ptr, (char*)forMarshaling->pName, l);
                *ptr += l;
            }
        }
    }
    else
    {
        {
            uint32_t l = forMarshaling->pName ? strlen(forMarshaling->pName): 0;
            memcpy(*ptr, (uint32_t*)&l, sizeof(uint32_t));
            gfxstream::aemu::Stream::toBe32((uint8_t*)*ptr);
            *ptr += sizeof(uint32_t);
            memcpy(*ptr, (char*)forMarshaling->pName, l);
            *ptr += l;
        }
    }
}

void reservedmarshal_VkDebugMetadataGuestProcessIdGOOGLE(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDebugMetadataGuestProcessIdGOOGLE* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint64_t*)&forMarshaling->id, sizeof(uint64_t));
    *ptr += sizeof(uint64_t);
}

void reservedmarshal_VkDebugMetadataGuestThreadNameGOOGLE(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDebugMetadataGuestThreadNameGOOGLE* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    if (vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_NULL_OPTIONAL_STRINGS_BIT)
    {
        // WARNING PTR CHECK
        uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pName;
        memcpy((*ptr), &cgen_var_0, 8);
        gfxstream::aemu::Stream::toBe64((uint8_t*)(*ptr));
        *ptr += 8;
        if (forMarshaling->pName)
        {
            {
                uint32_t l = forMarshaling->pName ? strlen(forMarshaling->pName): 0;
                memcpy(*ptr, (uint32_t*)&l, sizeof(uint32_t));
                gfxstream::aemu::Stream::toBe32((uint8_t*)*ptr);
                *ptr += sizeof(uint32_t);
                memcpy(*ptr, (char*)forMarshaling->pName, l);
                *ptr += l;
            }
        }
    }
    else
    {
        {
            uint32_t l = forMarshaling->pName ? strlen(forMarshaling->pName): 0;
            memcpy(*ptr, (uint32_t*)&l, sizeof(uint32_t));
            gfxstream::aemu::Stream::toBe32((uint8_t*)*ptr);
            *ptr += sizeof(uint32_t);
            memcpy(*ptr, (char*)forMarshaling->pName, l);
            *ptr += l;
        }
    }
}

void reservedmarshal_VkDebugMetadataGuestThreadIdGOOGLE(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDebugMetadataGuestThreadIdGOOGLE* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (uint64_t*)&forMarshaling->id, sizeof(uint64_t));
    *ptr += sizeof(uint64_t);
}

void reservedmarshal_VkDebugMetadataGOOGLE(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDebugMetadataGOOGLE* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
}

#endif
#ifdef VK_EXT_image_compression_control_swapchain
void reservedmarshal_VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT* forMarshaling,
    uint8_t** ptr)
{
    (void)vkStream;
    (void)rootType;
    memcpy(*ptr, (VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    reservedmarshal_extension_struct(vkStream, rootType, forMarshaling->pNext, ptr);
    memcpy(*ptr, (VkBool32*)&forMarshaling->imageCompressionControlSwapchain, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

#endif
void reservedmarshal_extension_struct(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const void* structExtension,
    uint8_t** ptr)
{
    VkInstanceCreateInfo* structAccess = (VkInstanceCreateInfo*)(structExtension);
    uint32_t currExtSize = goldfish_vk_extension_struct_size_with_stream_features(vkStream->getFeatureBits(), rootType, structExtension);
    if (!currExtSize && structExtension)
    {
        // unknown struct extension; skip and call on its pNext field
        reservedmarshal_extension_struct(vkStream, rootType, (void*)structAccess->pNext, ptr);
        return;
    }
    else
    {
        // known or null extension struct
        memcpy(*ptr, &currExtSize, sizeof(uint32_t));;
        gfxstream::aemu::Stream::toBe32((uint8_t*)*ptr); *ptr += sizeof(uint32_t);
        if (!currExtSize)
        {
            // exit if this was a null extension struct (size == 0 in this branch)
            return;
        }
    }
    memcpy(*ptr, structExtension, sizeof(VkStructureType)); *ptr += sizeof(VkStructureType);
    if (!structExtension)
    {
        return;
    }
    uint32_t structType = (uint32_t)goldfish_vk_struct_type(structExtension);
    switch(structType)
    {
#ifdef VK_COMPUTE_VERSION_1_0
        case VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO:
        {
            reservedmarshal_VkShaderModuleCreateInfo(vkStream, rootType, reinterpret_cast<const VkShaderModuleCreateInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO:
        {
            reservedmarshal_VkPipelineLayoutCreateInfo(vkStream, rootType, reinterpret_cast<const VkPipelineLayoutCreateInfo*>(structExtension), ptr);
            break;
        }
#endif
#ifdef VK_BASE_VERSION_1_1
        case VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS:
        {
            reservedmarshal_VkMemoryDedicatedRequirements(vkStream, rootType, reinterpret_cast<const VkMemoryDedicatedRequirements*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO:
        {
            reservedmarshal_VkMemoryDedicatedAllocateInfo(vkStream, rootType, reinterpret_cast<const VkMemoryDedicatedAllocateInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO:
        {
            reservedmarshal_VkMemoryAllocateFlagsInfo(vkStream, rootType, reinterpret_cast<const VkMemoryAllocateFlagsInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO:
        {
            reservedmarshal_VkDeviceGroupCommandBufferBeginInfo(vkStream, rootType, reinterpret_cast<const VkDeviceGroupCommandBufferBeginInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO:
        {
            reservedmarshal_VkDeviceGroupSubmitInfo(vkStream, rootType, reinterpret_cast<const VkDeviceGroupSubmitInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO:
        {
            reservedmarshal_VkDeviceGroupBindSparseInfo(vkStream, rootType, reinterpret_cast<const VkDeviceGroupBindSparseInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO:
        {
            reservedmarshal_VkBindBufferMemoryDeviceGroupInfo(vkStream, rootType, reinterpret_cast<const VkBindBufferMemoryDeviceGroupInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO:
        {
            reservedmarshal_VkBindImageMemoryDeviceGroupInfo(vkStream, rootType, reinterpret_cast<const VkBindImageMemoryDeviceGroupInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO:
        {
            reservedmarshal_VkDeviceGroupDeviceCreateInfo(vkStream, rootType, reinterpret_cast<const VkDeviceGroupDeviceCreateInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2:
        {
            reservedmarshal_VkPhysicalDeviceFeatures2(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceFeatures2*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO:
        {
            reservedmarshal_VkImageViewUsageCreateInfo(vkStream, rootType, reinterpret_cast<const VkImageViewUsageCreateInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceProtectedMemoryFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceProtectedMemoryFeatures*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES:
        {
            reservedmarshal_VkPhysicalDeviceProtectedMemoryProperties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceProtectedMemoryProperties*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO:
        {
            reservedmarshal_VkProtectedSubmitInfo(vkStream, rootType, reinterpret_cast<const VkProtectedSubmitInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO:
        {
            reservedmarshal_VkBindImagePlaneMemoryInfo(vkStream, rootType, reinterpret_cast<const VkBindImagePlaneMemoryInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO:
        {
            reservedmarshal_VkImagePlaneMemoryRequirementsInfo(vkStream, rootType, reinterpret_cast<const VkImagePlaneMemoryRequirementsInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO:
        {
            reservedmarshal_VkPhysicalDeviceExternalImageFormatInfo(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceExternalImageFormatInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES:
        {
            reservedmarshal_VkExternalImageFormatProperties(vkStream, rootType, reinterpret_cast<const VkExternalImageFormatProperties*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES:
        {
            reservedmarshal_VkPhysicalDeviceIDProperties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceIDProperties*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO:
        {
            reservedmarshal_VkExternalMemoryImageCreateInfo(vkStream, rootType, reinterpret_cast<const VkExternalMemoryImageCreateInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO:
        {
            reservedmarshal_VkExternalMemoryBufferCreateInfo(vkStream, rootType, reinterpret_cast<const VkExternalMemoryBufferCreateInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO:
        {
            reservedmarshal_VkExportMemoryAllocateInfo(vkStream, rootType, reinterpret_cast<const VkExportMemoryAllocateInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO:
        {
            reservedmarshal_VkExportFenceCreateInfo(vkStream, rootType, reinterpret_cast<const VkExportFenceCreateInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO:
        {
            reservedmarshal_VkExportSemaphoreCreateInfo(vkStream, rootType, reinterpret_cast<const VkExportSemaphoreCreateInfo*>(structExtension), ptr);
            break;
        }
#endif
#ifdef VK_COMPUTE_VERSION_1_1
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES:
        {
            reservedmarshal_VkPhysicalDeviceSubgroupProperties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceSubgroupProperties*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
        {
            reservedmarshal_VkPhysicalDevice16BitStorageFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDevice16BitStorageFeatures*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceVariablePointersFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceVariablePointersFeatures*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES:
        {
            reservedmarshal_VkPhysicalDeviceMaintenance3Properties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceMaintenance3Properties*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO:
        {
            reservedmarshal_VkSamplerYcbcrConversionInfo(vkStream, rootType, reinterpret_cast<const VkSamplerYcbcrConversionInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceSamplerYcbcrConversionFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceSamplerYcbcrConversionFeatures*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES:
        {
            reservedmarshal_VkSamplerYcbcrConversionImageFormatProperties(vkStream, rootType, reinterpret_cast<const VkSamplerYcbcrConversionImageFormatProperties*>(structExtension), ptr);
            break;
        }
#endif
#ifdef VK_GRAPHICS_VERSION_1_1
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO:
        {
            reservedmarshal_VkDeviceGroupRenderPassBeginInfo(vkStream, rootType, reinterpret_cast<const VkDeviceGroupRenderPassBeginInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES:
        {
            reservedmarshal_VkPhysicalDevicePointClippingProperties(vkStream, rootType, reinterpret_cast<const VkPhysicalDevicePointClippingProperties*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO:
        {
            reservedmarshal_VkRenderPassInputAttachmentAspectCreateInfo(vkStream, rootType, reinterpret_cast<const VkRenderPassInputAttachmentAspectCreateInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO:
        {
            reservedmarshal_VkPipelineTessellationDomainOriginStateCreateInfo(vkStream, rootType, reinterpret_cast<const VkPipelineTessellationDomainOriginStateCreateInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO:
        {
            reservedmarshal_VkRenderPassMultiviewCreateInfo(vkStream, rootType, reinterpret_cast<const VkRenderPassMultiviewCreateInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceMultiviewFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceMultiviewFeatures*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES:
        {
            reservedmarshal_VkPhysicalDeviceMultiviewProperties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceMultiviewProperties*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceShaderDrawParametersFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceShaderDrawParametersFeatures*>(structExtension), ptr);
            break;
        }
#endif
#ifdef VK_BASE_VERSION_1_2
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceVulkan11Features(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceVulkan11Features*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES:
        {
            reservedmarshal_VkPhysicalDeviceVulkan11Properties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceVulkan11Properties*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceVulkan12Features(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceVulkan12Features*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES:
        {
            reservedmarshal_VkPhysicalDeviceVulkan12Properties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceVulkan12Properties*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO:
        {
            reservedmarshal_VkImageFormatListCreateInfo(vkStream, rootType, reinterpret_cast<const VkImageFormatListCreateInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES:
        {
            reservedmarshal_VkPhysicalDeviceDriverProperties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceDriverProperties*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceVulkanMemoryModelFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceVulkanMemoryModelFeatures*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceHostQueryResetFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceHostQueryResetFeatures*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceTimelineSemaphoreFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceTimelineSemaphoreFeatures*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES:
        {
            reservedmarshal_VkPhysicalDeviceTimelineSemaphoreProperties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceTimelineSemaphoreProperties*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO:
        {
            reservedmarshal_VkSemaphoreTypeCreateInfo(vkStream, rootType, reinterpret_cast<const VkSemaphoreTypeCreateInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO:
        {
            reservedmarshal_VkTimelineSemaphoreSubmitInfo(vkStream, rootType, reinterpret_cast<const VkTimelineSemaphoreSubmitInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceBufferDeviceAddressFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceBufferDeviceAddressFeatures*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO:
        {
            reservedmarshal_VkBufferOpaqueCaptureAddressCreateInfo(vkStream, rootType, reinterpret_cast<const VkBufferOpaqueCaptureAddressCreateInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO:
        {
            reservedmarshal_VkMemoryOpaqueCaptureAddressAllocateInfo(vkStream, rootType, reinterpret_cast<const VkMemoryOpaqueCaptureAddressAllocateInfo*>(structExtension), ptr);
            break;
        }
#endif
#ifdef VK_COMPUTE_VERSION_1_2
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
        {
            reservedmarshal_VkPhysicalDevice8BitStorageFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDevice8BitStorageFeatures*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceShaderAtomicInt64Features(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceShaderAtomicInt64Features*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceShaderFloat16Int8Features(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceShaderFloat16Int8Features*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES:
        {
            reservedmarshal_VkPhysicalDeviceFloatControlsProperties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceFloatControlsProperties*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO:
        {
            reservedmarshal_VkDescriptorSetLayoutBindingFlagsCreateInfo(vkStream, rootType, reinterpret_cast<const VkDescriptorSetLayoutBindingFlagsCreateInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceDescriptorIndexingFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceDescriptorIndexingFeatures*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES:
        {
            reservedmarshal_VkPhysicalDeviceDescriptorIndexingProperties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceDescriptorIndexingProperties*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO:
        {
            reservedmarshal_VkDescriptorSetVariableDescriptorCountAllocateInfo(vkStream, rootType, reinterpret_cast<const VkDescriptorSetVariableDescriptorCountAllocateInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT:
        {
            reservedmarshal_VkDescriptorSetVariableDescriptorCountLayoutSupport(vkStream, rootType, reinterpret_cast<const VkDescriptorSetVariableDescriptorCountLayoutSupport*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceScalarBlockLayoutFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceScalarBlockLayoutFeatures*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO:
        {
            reservedmarshal_VkSamplerReductionModeCreateInfo(vkStream, rootType, reinterpret_cast<const VkSamplerReductionModeCreateInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES:
        {
            reservedmarshal_VkPhysicalDeviceSamplerFilterMinmaxProperties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceSamplerFilterMinmaxProperties*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceUniformBufferStandardLayoutFeatures*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures*>(structExtension), ptr);
            break;
        }
#endif
#ifdef VK_GRAPHICS_VERSION_1_2
        case VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE:
        {
            reservedmarshal_VkSubpassDescriptionDepthStencilResolve(vkStream, rootType, reinterpret_cast<const VkSubpassDescriptionDepthStencilResolve*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES:
        {
            reservedmarshal_VkPhysicalDeviceDepthStencilResolveProperties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceDepthStencilResolveProperties*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO:
        {
            reservedmarshal_VkImageStencilUsageCreateInfo(vkStream, rootType, reinterpret_cast<const VkImageStencilUsageCreateInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceImagelessFramebufferFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceImagelessFramebufferFeatures*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO:
        {
            reservedmarshal_VkFramebufferAttachmentsCreateInfo(vkStream, rootType, reinterpret_cast<const VkFramebufferAttachmentsCreateInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO:
        {
            reservedmarshal_VkRenderPassAttachmentBeginInfo(vkStream, rootType, reinterpret_cast<const VkRenderPassAttachmentBeginInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT:
        {
            reservedmarshal_VkAttachmentReferenceStencilLayout(vkStream, rootType, reinterpret_cast<const VkAttachmentReferenceStencilLayout*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT:
        {
            reservedmarshal_VkAttachmentDescriptionStencilLayout(vkStream, rootType, reinterpret_cast<const VkAttachmentDescriptionStencilLayout*>(structExtension), ptr);
            break;
        }
#endif
#ifdef VK_BASE_VERSION_1_3
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceVulkan13Features(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceVulkan13Features*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES:
        {
            reservedmarshal_VkPhysicalDeviceVulkan13Properties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceVulkan13Properties*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES:
        {
            reservedmarshal_VkPhysicalDevicePrivateDataFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDevicePrivateDataFeatures*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO:
        {
            reservedmarshal_VkDevicePrivateDataCreateInfo(vkStream, rootType, reinterpret_cast<const VkDevicePrivateDataCreateInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_BARRIER_2:
        {
            reservedmarshal_VkMemoryBarrier2(vkStream, rootType, reinterpret_cast<const VkMemoryBarrier2*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceSynchronization2Features(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceSynchronization2Features*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceTextureCompressionASTCHDRFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceTextureCompressionASTCHDRFeatures*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3:
        {
            reservedmarshal_VkFormatProperties3(vkStream, rootType, reinterpret_cast<const VkFormatProperties3*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceMaintenance4Features(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceMaintenance4Features*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES:
        {
            reservedmarshal_VkPhysicalDeviceMaintenance4Properties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceMaintenance4Properties*>(structExtension), ptr);
            break;
        }
#endif
#ifdef VK_COMPUTE_VERSION_1_3
        case VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO:
        {
            reservedmarshal_VkPipelineCreationFeedbackCreateInfo(vkStream, rootType, reinterpret_cast<const VkPipelineCreationFeedbackCreateInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceShaderTerminateInvocationFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceShaderTerminateInvocationFeatures*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES:
        {
            reservedmarshal_VkPhysicalDevicePipelineCreationCacheControlFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDevicePipelineCreationCacheControlFeatures*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceImageRobustnessFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceImageRobustnessFeatures*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceSubgroupSizeControlFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceSubgroupSizeControlFeatures*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES:
        {
            reservedmarshal_VkPhysicalDeviceSubgroupSizeControlProperties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceSubgroupSizeControlProperties*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO:
        {
            reservedmarshal_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo(vkStream, rootType, reinterpret_cast<const VkPipelineShaderStageRequiredSubgroupSizeCreateInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceInlineUniformBlockFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceInlineUniformBlockFeatures*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES:
        {
            reservedmarshal_VkPhysicalDeviceInlineUniformBlockProperties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceInlineUniformBlockProperties*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK:
        {
            reservedmarshal_VkWriteDescriptorSetInlineUniformBlock(vkStream, rootType, reinterpret_cast<const VkWriteDescriptorSetInlineUniformBlock*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO:
        {
            reservedmarshal_VkDescriptorPoolInlineUniformBlockCreateInfo(vkStream, rootType, reinterpret_cast<const VkDescriptorPoolInlineUniformBlockCreateInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceShaderIntegerDotProductFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceShaderIntegerDotProductFeatures*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES:
        {
            reservedmarshal_VkPhysicalDeviceShaderIntegerDotProductProperties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceShaderIntegerDotProductProperties*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES:
        {
            reservedmarshal_VkPhysicalDeviceTexelBufferAlignmentProperties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceTexelBufferAlignmentProperties*>(structExtension), ptr);
            break;
        }
#endif
#ifdef VK_GRAPHICS_VERSION_1_3
        case VK_STRUCTURE_TYPE_PIPELINE_RENDERING_CREATE_INFO:
        {
            reservedmarshal_VkPipelineRenderingCreateInfo(vkStream, rootType, reinterpret_cast<const VkPipelineRenderingCreateInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceDynamicRenderingFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceDynamicRenderingFeatures*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO:
        {
            reservedmarshal_VkCommandBufferInheritanceRenderingInfo(vkStream, rootType, reinterpret_cast<const VkCommandBufferInheritanceRenderingInfo*>(structExtension), ptr);
            break;
        }
#endif
#ifdef VK_BASE_VERSION_1_4
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceVulkan14Features(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceVulkan14Features*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_PROPERTIES:
        {
            reservedmarshal_VkPhysicalDeviceVulkan14Properties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceVulkan14Properties*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO:
        {
            reservedmarshal_VkDeviceQueueGlobalPriorityCreateInfo(vkStream, rootType, reinterpret_cast<const VkDeviceQueueGlobalPriorityCreateInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceGlobalPriorityQueryFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceGlobalPriorityQueryFeatures*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_QUEUE_FAMILY_GLOBAL_PRIORITY_PROPERTIES:
        {
            reservedmarshal_VkQueueFamilyGlobalPriorityProperties(vkStream, rootType, reinterpret_cast<const VkQueueFamilyGlobalPriorityProperties*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceIndexTypeUint8Features(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceIndexTypeUint8Features*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceMaintenance5Features(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceMaintenance5Features*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_PROPERTIES:
        {
            reservedmarshal_VkPhysicalDeviceMaintenance5Properties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceMaintenance5Properties*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_BUFFER_USAGE_FLAGS_2_CREATE_INFO:
        {
            reservedmarshal_VkBufferUsageFlags2CreateInfo(vkStream, rootType, reinterpret_cast<const VkBufferUsageFlags2CreateInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceMaintenance6Features(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceMaintenance6Features*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_PROPERTIES:
        {
            reservedmarshal_VkPhysicalDeviceMaintenance6Properties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceMaintenance6Properties*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_BIND_MEMORY_STATUS:
        {
            reservedmarshal_VkBindMemoryStatus(vkStream, rootType, reinterpret_cast<const VkBindMemoryStatus*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceHostImageCopyFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceHostImageCopyFeatures*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_PROPERTIES:
        {
            reservedmarshal_VkPhysicalDeviceHostImageCopyProperties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceHostImageCopyProperties*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_SUBRESOURCE_HOST_MEMCPY_SIZE:
        {
            reservedmarshal_VkSubresourceHostMemcpySize(vkStream, rootType, reinterpret_cast<const VkSubresourceHostMemcpySize*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_HOST_IMAGE_COPY_DEVICE_PERFORMANCE_QUERY:
        {
            reservedmarshal_VkHostImageCopyDevicePerformanceQuery(vkStream, rootType, reinterpret_cast<const VkHostImageCopyDevicePerformanceQuery*>(structExtension), ptr);
            break;
        }
#endif
#ifdef VK_COMPUTE_VERSION_1_4
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_ROTATE_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceShaderSubgroupRotateFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceShaderSubgroupRotateFeatures*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT_CONTROLS_2_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceShaderFloatControls2Features(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceShaderFloatControls2Features*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EXPECT_ASSUME_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceShaderExpectAssumeFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceShaderExpectAssumeFeatures*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_CREATE_FLAGS_2_CREATE_INFO:
        {
            reservedmarshal_VkPipelineCreateFlags2CreateInfo(vkStream, rootType, reinterpret_cast<const VkPipelineCreateFlags2CreateInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES:
        {
            reservedmarshal_VkPhysicalDevicePushDescriptorProperties(vkStream, rootType, reinterpret_cast<const VkPhysicalDevicePushDescriptorProperties*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROTECTED_ACCESS_FEATURES:
        {
            reservedmarshal_VkPhysicalDevicePipelineProtectedAccessFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDevicePipelineProtectedAccessFeatures*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_FEATURES:
        {
            reservedmarshal_VkPhysicalDevicePipelineRobustnessFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDevicePipelineRobustnessFeatures*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_PROPERTIES:
        {
            reservedmarshal_VkPhysicalDevicePipelineRobustnessProperties(vkStream, rootType, reinterpret_cast<const VkPhysicalDevicePipelineRobustnessProperties*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_ROBUSTNESS_CREATE_INFO:
        {
            reservedmarshal_VkPipelineRobustnessCreateInfo(vkStream, rootType, reinterpret_cast<const VkPipelineRobustnessCreateInfo*>(structExtension), ptr);
            break;
        }
#endif
#ifdef VK_GRAPHICS_VERSION_1_4
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceLineRasterizationFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceLineRasterizationFeatures*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES:
        {
            reservedmarshal_VkPhysicalDeviceLineRasterizationProperties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceLineRasterizationProperties*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_LINE_STATE_CREATE_INFO:
        {
            reservedmarshal_VkPipelineRasterizationLineStateCreateInfo(vkStream, rootType, reinterpret_cast<const VkPipelineRasterizationLineStateCreateInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES:
        {
            reservedmarshal_VkPhysicalDeviceVertexAttributeDivisorProperties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceVertexAttributeDivisorProperties*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_DIVISOR_STATE_CREATE_INFO:
        {
            reservedmarshal_VkPipelineVertexInputDivisorStateCreateInfo(vkStream, rootType, reinterpret_cast<const VkPipelineVertexInputDivisorStateCreateInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceVertexAttributeDivisorFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceVertexAttributeDivisorFeatures*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_LOCAL_READ_FEATURES:
        {
            reservedmarshal_VkPhysicalDeviceDynamicRenderingLocalReadFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceDynamicRenderingLocalReadFeatures*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_LOCATION_INFO:
        {
            reservedmarshal_VkRenderingAttachmentLocationInfo(vkStream, rootType, reinterpret_cast<const VkRenderingAttachmentLocationInfo*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_RENDERING_INPUT_ATTACHMENT_INDEX_INFO:
        {
            reservedmarshal_VkRenderingInputAttachmentIndexInfo(vkStream, rootType, reinterpret_cast<const VkRenderingInputAttachmentIndexInfo*>(structExtension), ptr);
            break;
        }
#endif
#ifdef VK_KHR_incremental_present
        case VK_STRUCTURE_TYPE_PRESENT_REGIONS_KHR:
        {
            reservedmarshal_VkPresentRegionsKHR(vkStream, rootType, reinterpret_cast<const VkPresentRegionsKHR*>(structExtension), ptr);
            break;
        }
#endif
#ifdef VK_KHR_pipeline_executable_properties
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_EXECUTABLE_PROPERTIES_FEATURES_KHR:
        {
            reservedmarshal_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR(vkStream, rootType, reinterpret_cast<const VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR*>(structExtension), ptr);
            break;
        }
#endif
#ifdef VK_ANDROID_native_buffer
        case VK_STRUCTURE_TYPE_NATIVE_BUFFER_ANDROID:
        {
            reservedmarshal_VkNativeBufferANDROID(vkStream, rootType, reinterpret_cast<const VkNativeBufferANDROID*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_SWAPCHAIN_IMAGE_CREATE_INFO_ANDROID:
        {
            reservedmarshal_VkSwapchainImageCreateInfoANDROID(vkStream, rootType, reinterpret_cast<const VkSwapchainImageCreateInfoANDROID*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENTATION_PROPERTIES_ANDROID:
        {
            reservedmarshal_VkPhysicalDevicePresentationPropertiesANDROID(vkStream, rootType, reinterpret_cast<const VkPhysicalDevicePresentationPropertiesANDROID*>(structExtension), ptr);
            break;
        }
#endif
#ifdef VK_EXT_transform_feedback
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
        {
            reservedmarshal_VkPhysicalDeviceTransformFeedbackFeaturesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceTransformFeedbackFeaturesEXT*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT:
        {
            reservedmarshal_VkPhysicalDeviceTransformFeedbackPropertiesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceTransformFeedbackPropertiesEXT*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT:
        {
            reservedmarshal_VkPipelineRasterizationStateStreamCreateInfoEXT(vkStream, rootType, reinterpret_cast<const VkPipelineRasterizationStateStreamCreateInfoEXT*>(structExtension), ptr);
            break;
        }
#endif
#ifdef VK_EXT_depth_clip_enable
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT:
        {
            reservedmarshal_VkPhysicalDeviceDepthClipEnableFeaturesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceDepthClipEnableFeaturesEXT*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_DEPTH_CLIP_STATE_CREATE_INFO_EXT:
        {
            reservedmarshal_VkPipelineRasterizationDepthClipStateCreateInfoEXT(vkStream, rootType, reinterpret_cast<const VkPipelineRasterizationDepthClipStateCreateInfoEXT*>(structExtension), ptr);
            break;
        }
#endif
#ifdef VK_EXT_blend_operation_advanced
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT:
        {
            reservedmarshal_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_PROPERTIES_EXT:
        {
            reservedmarshal_VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_ADVANCED_STATE_CREATE_INFO_EXT:
        {
            reservedmarshal_VkPipelineColorBlendAdvancedStateCreateInfoEXT(vkStream, rootType, reinterpret_cast<const VkPipelineColorBlendAdvancedStateCreateInfoEXT*>(structExtension), ptr);
            break;
        }
#endif
#ifdef VK_EXT_image_drm_format_modifier
        case VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT:
        {
            reservedmarshal_VkDrmFormatModifierPropertiesListEXT(vkStream, rootType, reinterpret_cast<const VkDrmFormatModifierPropertiesListEXT*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT:
        {
            reservedmarshal_VkPhysicalDeviceImageDrmFormatModifierInfoEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceImageDrmFormatModifierInfoEXT*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT:
        {
            reservedmarshal_VkImageDrmFormatModifierListCreateInfoEXT(vkStream, rootType, reinterpret_cast<const VkImageDrmFormatModifierListCreateInfoEXT*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT:
        {
            reservedmarshal_VkImageDrmFormatModifierExplicitCreateInfoEXT(vkStream, rootType, reinterpret_cast<const VkImageDrmFormatModifierExplicitCreateInfoEXT*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT:
        {
            reservedmarshal_VkDrmFormatModifierPropertiesList2EXT(vkStream, rootType, reinterpret_cast<const VkDrmFormatModifierPropertiesList2EXT*>(structExtension), ptr);
            break;
        }
#endif
#ifdef VK_EXT_vertex_attribute_divisor
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT:
        {
            reservedmarshal_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT*>(structExtension), ptr);
            break;
        }
#endif
#ifdef VK_EXT_fragment_density_map
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_FEATURES_EXT:
        {
            switch(rootType)
            {
                case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2:
                {
                    reservedmarshal_VkPhysicalDeviceFragmentDensityMapFeaturesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceFragmentDensityMapFeaturesEXT*>(structExtension), ptr);
                    break;
                }
                case VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO:
                {
                    reservedmarshal_VkPhysicalDeviceFragmentDensityMapFeaturesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceFragmentDensityMapFeaturesEXT*>(structExtension), ptr);
                    break;
                }
                case VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO:
                {
                    reservedmarshal_VkImportColorBufferGOOGLE(vkStream, rootType, reinterpret_cast<const VkImportColorBufferGOOGLE*>(structExtension), ptr);
                    break;
                }
                default:
                {
                    reservedmarshal_VkPhysicalDeviceFragmentDensityMapFeaturesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceFragmentDensityMapFeaturesEXT*>(structExtension), ptr);
                    break;
                }
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_PROPERTIES_EXT:
        {
            switch(rootType)
            {
                case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2:
                {
                    reservedmarshal_VkPhysicalDeviceFragmentDensityMapPropertiesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceFragmentDensityMapPropertiesEXT*>(structExtension), ptr);
                    break;
                }
                case VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO:
                {
                    reservedmarshal_VkCreateBlobGOOGLE(vkStream, rootType, reinterpret_cast<const VkCreateBlobGOOGLE*>(structExtension), ptr);
                    break;
                }
                default:
                {
                    reservedmarshal_VkPhysicalDeviceFragmentDensityMapPropertiesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceFragmentDensityMapPropertiesEXT*>(structExtension), ptr);
                    break;
                }
            }
            break;
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_FRAGMENT_DENSITY_MAP_CREATE_INFO_EXT:
        {
            switch(rootType)
            {
                case VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO:
                {
                    reservedmarshal_VkRenderPassFragmentDensityMapCreateInfoEXT(vkStream, rootType, reinterpret_cast<const VkRenderPassFragmentDensityMapCreateInfoEXT*>(structExtension), ptr);
                    break;
                }
                case VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2:
                {
                    reservedmarshal_VkRenderPassFragmentDensityMapCreateInfoEXT(vkStream, rootType, reinterpret_cast<const VkRenderPassFragmentDensityMapCreateInfoEXT*>(structExtension), ptr);
                    break;
                }
                case VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO:
                {
                    reservedmarshal_VkImportBufferGOOGLE(vkStream, rootType, reinterpret_cast<const VkImportBufferGOOGLE*>(structExtension), ptr);
                    break;
                }
                default:
                {
                    reservedmarshal_VkRenderPassFragmentDensityMapCreateInfoEXT(vkStream, rootType, reinterpret_cast<const VkRenderPassFragmentDensityMapCreateInfoEXT*>(structExtension), ptr);
                    break;
                }
            }
            break;
        }
        case VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_INFO_EXT:
        {
            reservedmarshal_VkRenderingFragmentDensityMapAttachmentInfoEXT(vkStream, rootType, reinterpret_cast<const VkRenderingFragmentDensityMapAttachmentInfoEXT*>(structExtension), ptr);
            break;
        }
#endif
#ifdef VK_EXT_memory_budget
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT:
        {
            reservedmarshal_VkPhysicalDeviceMemoryBudgetPropertiesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceMemoryBudgetPropertiesEXT*>(structExtension), ptr);
            break;
        }
#endif
#ifdef VK_EXT_provoking_vertex
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT:
        {
            reservedmarshal_VkPhysicalDeviceProvokingVertexFeaturesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceProvokingVertexFeaturesEXT*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT:
        {
            reservedmarshal_VkPhysicalDeviceProvokingVertexPropertiesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceProvokingVertexPropertiesEXT*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_PROVOKING_VERTEX_STATE_CREATE_INFO_EXT:
        {
            reservedmarshal_VkPipelineRasterizationProvokingVertexStateCreateInfoEXT(vkStream, rootType, reinterpret_cast<const VkPipelineRasterizationProvokingVertexStateCreateInfoEXT*>(structExtension), ptr);
            break;
        }
#endif
#ifdef VK_EXT_extended_dynamic_state
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT:
        {
            reservedmarshal_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT*>(structExtension), ptr);
            break;
        }
#endif
#ifdef VK_EXT_texel_buffer_alignment
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT:
        {
            reservedmarshal_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT*>(structExtension), ptr);
            break;
        }
#endif
#ifdef VK_EXT_device_memory_report
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_MEMORY_REPORT_FEATURES_EXT:
        {
            reservedmarshal_VkPhysicalDeviceDeviceMemoryReportFeaturesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceDeviceMemoryReportFeaturesEXT*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_DEVICE_MEMORY_REPORT_CREATE_INFO_EXT:
        {
            reservedmarshal_VkDeviceDeviceMemoryReportCreateInfoEXT(vkStream, rootType, reinterpret_cast<const VkDeviceDeviceMemoryReportCreateInfoEXT*>(structExtension), ptr);
            break;
        }
#endif
#ifdef VK_EXT_custom_border_color
        case VK_STRUCTURE_TYPE_SAMPLER_CUSTOM_BORDER_COLOR_CREATE_INFO_EXT:
        {
            reservedmarshal_VkSamplerCustomBorderColorCreateInfoEXT(vkStream, rootType, reinterpret_cast<const VkSamplerCustomBorderColorCreateInfoEXT*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT:
        {
            reservedmarshal_VkPhysicalDeviceCustomBorderColorPropertiesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceCustomBorderColorPropertiesEXT*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT:
        {
            reservedmarshal_VkPhysicalDeviceCustomBorderColorFeaturesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceCustomBorderColorFeaturesEXT*>(structExtension), ptr);
            break;
        }
#endif
#ifdef VK_EXT_graphics_pipeline_library
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT:
        {
            reservedmarshal_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_PROPERTIES_EXT:
        {
            reservedmarshal_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_LIBRARY_CREATE_INFO_EXT:
        {
            reservedmarshal_VkGraphicsPipelineLibraryCreateInfoEXT(vkStream, rootType, reinterpret_cast<const VkGraphicsPipelineLibraryCreateInfoEXT*>(structExtension), ptr);
            break;
        }
#endif
#ifdef VK_EXT_ycbcr_2plane_444_formats
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT:
        {
            reservedmarshal_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT*>(structExtension), ptr);
            break;
        }
#endif
#ifdef VK_EXT_image_compression_control
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_FEATURES_EXT:
        {
            reservedmarshal_VkPhysicalDeviceImageCompressionControlFeaturesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceImageCompressionControlFeaturesEXT*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_CONTROL_EXT:
        {
            reservedmarshal_VkImageCompressionControlEXT(vkStream, rootType, reinterpret_cast<const VkImageCompressionControlEXT*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_PROPERTIES_EXT:
        {
            reservedmarshal_VkImageCompressionPropertiesEXT(vkStream, rootType, reinterpret_cast<const VkImageCompressionPropertiesEXT*>(structExtension), ptr);
            break;
        }
#endif
#ifdef VK_EXT_4444_formats
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT:
        {
            reservedmarshal_VkPhysicalDevice4444FormatsFeaturesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDevice4444FormatsFeaturesEXT*>(structExtension), ptr);
            break;
        }
#endif
#ifdef VK_EXT_primitive_topology_list_restart
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT:
        {
            reservedmarshal_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT*>(structExtension), ptr);
            break;
        }
#endif
#ifdef VK_EXT_frame_boundary
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAME_BOUNDARY_FEATURES_EXT:
        {
            reservedmarshal_VkPhysicalDeviceFrameBoundaryFeaturesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceFrameBoundaryFeaturesEXT*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_FRAME_BOUNDARY_EXT:
        {
            reservedmarshal_VkFrameBoundaryEXT(vkStream, rootType, reinterpret_cast<const VkFrameBoundaryEXT*>(structExtension), ptr);
            break;
        }
#endif
#ifdef VK_EXT_extended_dynamic_state2
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT:
        {
            reservedmarshal_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT*>(structExtension), ptr);
            break;
        }
#endif
#ifdef VK_EXT_color_write_enable
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT:
        {
            reservedmarshal_VkPhysicalDeviceColorWriteEnableFeaturesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceColorWriteEnableFeaturesEXT*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_COLOR_WRITE_CREATE_INFO_EXT:
        {
            reservedmarshal_VkPipelineColorWriteCreateInfoEXT(vkStream, rootType, reinterpret_cast<const VkPipelineColorWriteCreateInfoEXT*>(structExtension), ptr);
            break;
        }
#endif
#ifdef VK_GOOGLE_gfxstream
        case VK_STRUCTURE_TYPE_IMPORT_COLOR_BUFFER_GOOGLE:
        {
            reservedmarshal_VkImportColorBufferGOOGLE(vkStream, rootType, reinterpret_cast<const VkImportColorBufferGOOGLE*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_IMPORT_BUFFER_GOOGLE:
        {
            reservedmarshal_VkImportBufferGOOGLE(vkStream, rootType, reinterpret_cast<const VkImportBufferGOOGLE*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_CREATE_BLOB_GOOGLE:
        {
            reservedmarshal_VkCreateBlobGOOGLE(vkStream, rootType, reinterpret_cast<const VkCreateBlobGOOGLE*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_DEBUG_METADATA_GUEST_PROCESS_NAME_GOOGLE:
        {
            reservedmarshal_VkDebugMetadataGuestProcessNameGOOGLE(vkStream, rootType, reinterpret_cast<const VkDebugMetadataGuestProcessNameGOOGLE*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_DEBUG_METADATA_GUEST_PROCESS_ID_GOOGLE:
        {
            reservedmarshal_VkDebugMetadataGuestProcessIdGOOGLE(vkStream, rootType, reinterpret_cast<const VkDebugMetadataGuestProcessIdGOOGLE*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_DEBUG_METADATA_GUEST_THREAD_NAME_GOOGLE:
        {
            reservedmarshal_VkDebugMetadataGuestThreadNameGOOGLE(vkStream, rootType, reinterpret_cast<const VkDebugMetadataGuestThreadNameGOOGLE*>(structExtension), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_DEBUG_METADATA_GUEST_THREAD_ID_GOOGLE:
        {
            reservedmarshal_VkDebugMetadataGuestThreadIdGOOGLE(vkStream, rootType, reinterpret_cast<const VkDebugMetadataGuestThreadIdGOOGLE*>(structExtension), ptr);
            break;
        }
#endif
#ifdef VK_EXT_image_compression_control_swapchain
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_SWAPCHAIN_FEATURES_EXT:
        {
            reservedmarshal_VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT*>(structExtension), ptr);
            break;
        }
#endif
        default:
        {
            // fatal; the switch is only taken if the extension struct is known
            abort();
        }
    }
}


}  // namespace vk
}  // namespace gfxstream
