/*
 * Copyright Collabora Ltd
 * SPDX-License-Identifier: MIT
 *
 * Autogenerated file, do not edit
 */

#include <stdint.h>

#pragma once
#include "util/macros.h"

struct panlib_copy_ts_query_result_args {
   uint64_t pool_addr;
   uint64_t available_addr;
   uint32_t query_stride;
   uint32_t first_query;
   uint32_t query_count;
   uint8_t _pad5[4];
   uint64_t dst_addr;
   uint64_t dst_stride;
   uint32_t query_type;
   uint32_t flags;
   uint32_t report_count;
} PACKED;

static_assert(offsetof(struct panlib_copy_ts_query_result_args, pool_addr) == 0, "");
static_assert(offsetof(struct panlib_copy_ts_query_result_args, available_addr) == 8, "");
static_assert(offsetof(struct panlib_copy_ts_query_result_args, query_stride) == 16, "");
static_assert(offsetof(struct panlib_copy_ts_query_result_args, first_query) == 20, "");
static_assert(offsetof(struct panlib_copy_ts_query_result_args, query_count) == 24, "");
static_assert(offsetof(struct panlib_copy_ts_query_result_args, dst_addr) == 32, "");
static_assert(offsetof(struct panlib_copy_ts_query_result_args, dst_stride) == 40, "");
static_assert(offsetof(struct panlib_copy_ts_query_result_args, query_type) == 48, "");
static_assert(offsetof(struct panlib_copy_ts_query_result_args, flags) == 52, "");
static_assert(offsetof(struct panlib_copy_ts_query_result_args, report_count) == 56, "");
static_assert(sizeof(struct panlib_copy_ts_query_result_args) == 60, "");

struct panlib_update_prims_generated_query_restart_args {
   uint64_t prims_generated;
   uint64_t index_buffer;
   uint32_t index_buffer_size_el;
   uint32_t cmd_stride;
   uint64_t cmd;
   uint32_t view_count;
} PACKED;

static_assert(offsetof(struct panlib_update_prims_generated_query_restart_args, prims_generated) == 0, "");
static_assert(offsetof(struct panlib_update_prims_generated_query_restart_args, index_buffer) == 8, "");
static_assert(offsetof(struct panlib_update_prims_generated_query_restart_args, index_buffer_size_el) == 16, "");
static_assert(offsetof(struct panlib_update_prims_generated_query_restart_args, cmd_stride) == 20, "");
static_assert(offsetof(struct panlib_update_prims_generated_query_restart_args, cmd) == 24, "");
static_assert(offsetof(struct panlib_update_prims_generated_query_restart_args, view_count) == 32, "");
static_assert(sizeof(struct panlib_update_prims_generated_query_restart_args) == 36, "");

struct panlib_update_prims_generated_query_indirect_args {
   uint64_t prims_generated;
   uint64_t draw_count_buffer;
   uint32_t max_draw_count;
   uint32_t cmd_stride;
   uint64_t cmd;
   uint32_t view_count;
} PACKED;

static_assert(offsetof(struct panlib_update_prims_generated_query_indirect_args, prims_generated) == 0, "");
static_assert(offsetof(struct panlib_update_prims_generated_query_indirect_args, draw_count_buffer) == 8, "");
static_assert(offsetof(struct panlib_update_prims_generated_query_indirect_args, max_draw_count) == 16, "");
static_assert(offsetof(struct panlib_update_prims_generated_query_indirect_args, cmd_stride) == 20, "");
static_assert(offsetof(struct panlib_update_prims_generated_query_indirect_args, cmd) == 24, "");
static_assert(offsetof(struct panlib_update_prims_generated_query_indirect_args, view_count) == 32, "");
static_assert(sizeof(struct panlib_update_prims_generated_query_indirect_args) == 36, "");

enum libpan_shaders_program {
    PANLIB_COPY_TS_QUERY_RESULT = 0,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_RESTART_0 = 1,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_RESTART_1 = 2,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_RESTART_2 = 3,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_RESTART_3 = 4,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_RESTART_4 = 5,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_RESTART_5 = 6,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_RESTART_6 = 7,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_RESTART_7 = 8,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_RESTART_8 = 9,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_RESTART_9 = 10,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_RESTART_10 = 11,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_RESTART_11 = 12,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_RESTART_12 = 13,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_RESTART_13 = 14,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_RESTART_14 = 15,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_RESTART_15 = 16,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_RESTART_16 = 17,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_RESTART_17 = 18,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_RESTART_18 = 19,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_RESTART_19 = 20,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_RESTART_20 = 21,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_RESTART_21 = 22,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_RESTART_22 = 23,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_RESTART_23 = 24,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_RESTART_24 = 25,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_RESTART_25 = 26,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_RESTART_26 = 27,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_RESTART_27 = 28,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_RESTART_28 = 29,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_RESTART_29 = 30,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_RESTART_30 = 31,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_RESTART_31 = 32,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_RESTART_32 = 33,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_INDIRECT_0 = 34,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_INDIRECT_1 = 35,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_INDIRECT_2 = 36,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_INDIRECT_3 = 37,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_INDIRECT_4 = 38,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_INDIRECT_5 = 39,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_INDIRECT_6 = 40,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_INDIRECT_7 = 41,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_INDIRECT_8 = 42,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_INDIRECT_9 = 43,
    PANLIB_UPDATE_PRIMS_GENERATED_QUERY_INDIRECT_10 = 44,
    LIBPAN_SHADERS_NUM_PROGRAMS,
};

static inline unsigned
PANLIB_UPDATE_PRIMS_GENERATED_QUERY_RESTART(unsigned compact_prim__11, unsigned index_bytes_log2__3)
{
   assert(compact_prim__11 < 11);
   assert(index_bytes_log2__3 < 3);

   unsigned idx = index_bytes_log2__3;
   idx = (idx * 11) + compact_prim__11;

   assert(idx < 33);
   return PANLIB_UPDATE_PRIMS_GENERATED_QUERY_RESTART_0 + idx;
}

static inline unsigned
PANLIB_UPDATE_PRIMS_GENERATED_QUERY_INDIRECT(unsigned compact_prim__11)
{
   assert(compact_prim__11 < 11);

   unsigned idx = compact_prim__11;

   assert(idx < 11);
   return PANLIB_UPDATE_PRIMS_GENERATED_QUERY_INDIRECT_0 + idx;
}


#define panlib_copy_ts_query_result_struct(_context, _grid, _barrier, _data) do { \
   struct panlib_copy_ts_query_result_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, PANLIB_COPY_TS_QUERY_RESULT, &_args, sizeof(_args)); \
} while(0);

#define panlib_copy_ts_query_result(_context, _grid, _barrier, pool_addr, available_addr, query_stride, first_query, query_count, dst_addr, dst_stride, query_type, flags, report_count) do { \
   struct panlib_copy_ts_query_result_args _args = {pool_addr, available_addr, query_stride, first_query, query_count, {0}, dst_addr, dst_stride, query_type, flags, report_count};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, PANLIB_COPY_TS_QUERY_RESULT, &_args, sizeof(_args)); \
} while(0);

#define panlib_update_prims_generated_query_restart_struct(_context, _grid, _barrier, _data, compact_prim__11, index_bytes_log2__3) do { \
   struct panlib_update_prims_generated_query_restart_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, PANLIB_UPDATE_PRIMS_GENERATED_QUERY_RESTART(compact_prim__11, index_bytes_log2__3), &_args, sizeof(_args)); \
} while(0);

#define panlib_update_prims_generated_query_restart(_context, _grid, _barrier, prims_generated, index_buffer, index_buffer_size_el, cmd_stride, cmd, view_count, compact_prim__11, index_bytes_log2__3) do { \
   struct panlib_update_prims_generated_query_restart_args _args = {prims_generated, index_buffer, index_buffer_size_el, cmd_stride, cmd, view_count};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, PANLIB_UPDATE_PRIMS_GENERATED_QUERY_RESTART(compact_prim__11, index_bytes_log2__3), &_args, sizeof(_args)); \
} while(0);

#define panlib_update_prims_generated_query_indirect_struct(_context, _grid, _barrier, _data, compact_prim__11) do { \
   struct panlib_update_prims_generated_query_indirect_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, PANLIB_UPDATE_PRIMS_GENERATED_QUERY_INDIRECT(compact_prim__11), &_args, sizeof(_args)); \
} while(0);

#define panlib_update_prims_generated_query_indirect(_context, _grid, _barrier, prims_generated, draw_count_buffer, max_draw_count, cmd_stride, cmd, view_count, compact_prim__11) do { \
   struct panlib_update_prims_generated_query_indirect_args _args = {prims_generated, draw_count_buffer, max_draw_count, cmd_stride, cmd, view_count};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, PANLIB_UPDATE_PRIMS_GENERATED_QUERY_INDIRECT(compact_prim__11), &_args, sizeof(_args)); \
} while(0);


extern const uint32_t *libpan_shaders_default_v12[LIBPAN_SHADERS_NUM_PROGRAMS];
