/* dialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from dialog.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright © 2014 Nikhar Agrawal
 *
 * This file is part of libgnome-games-support.
 *
 * libgnome-games-support is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * libgnome-games-support is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with libgnome-games-support.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include "libgnome-games-support.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GAMES_SCORES_TYPE_DIALOG (games_scores_dialog_get_type ())
#define GAMES_SCORES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_SCORES_TYPE_DIALOG, GamesScoresDialog))
#define GAMES_SCORES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_SCORES_TYPE_DIALOG, GamesScoresDialogClass))
#define GAMES_SCORES_IS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_SCORES_TYPE_DIALOG))
#define GAMES_SCORES_IS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_SCORES_TYPE_DIALOG))
#define GAMES_SCORES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_SCORES_TYPE_DIALOG, GamesScoresDialogClass))

typedef struct _GamesScoresDialog GamesScoresDialog;
typedef struct _GamesScoresDialogClass GamesScoresDialogClass;
typedef struct _GamesScoresDialogPrivate GamesScoresDialogPrivate;
enum  {
	GAMES_SCORES_DIALOG_0_PROPERTY,
	GAMES_SCORES_DIALOG_NUM_PROPERTIES
};
static GParamSpec* games_scores_dialog_properties[GAMES_SCORES_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;

struct _GamesScoresDialog {
	GtkDialog parent_instance;
	GamesScoresDialogPrivate * priv;
};

struct _GamesScoresDialogClass {
	GtkDialogClass parent_class;
};

struct _GamesScoresDialogPrivate {
	GamesScoresContext* context;
	GamesScoresCategory* active_category;
	gint rows_to_display;
	GtkComboBoxText* combo;
	GtkLabel* category_label;
	GtkHeaderBar* headerbar;
	GtkGrid* grid;
	GamesScoresStyle scores_style;
	GamesScoresScore* new_high_score;
	GamesScoresCategory* scores_active_category;
};

struct _Block4Data {
	int _ref_count_;
	GamesScoresDialog* self;
	GamesScoresScore* score;
};

struct _Block5Data {
	int _ref_count_;
	Block4Data * _data4_;
	GtkEntry* entry;
};

static gint GamesScoresDialog_private_offset;
static gpointer games_scores_dialog_parent_class = NULL;

VALA_EXTERN GType games_scores_dialog_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesScoresDialog* games_scores_dialog_new (GamesScoresContext* context,
                                            const gchar* category_type,
                                            GamesScoresStyle style,
                                            GamesScoresScore* new_high_score,
                                            GamesScoresCategory* current_cat,
                                            GtkWindow* window,
                                            const gchar* icon_name);
VALA_EXTERN GamesScoresDialog* games_scores_dialog_construct (GType object_type,
                                                  GamesScoresContext* context,
                                                  const gchar* category_type,
                                                  GamesScoresStyle style,
                                                  GamesScoresScore* new_high_score,
                                                  GamesScoresCategory* current_cat,
                                                  GtkWindow* window,
                                                  const gchar* icon_name);
VALA_EXTERN GList* games_scores_context_get_categories (GamesScoresContext* self);
static void games_scores_dialog_load_scores (GamesScoresDialog* self);
static void _games_scores_dialog_load_scores_gtk_combo_box_changed (GtkComboBox* _sender,
                                                             gpointer self);
static void games_scores_dialog_fill_grid_with_labels (GamesScoresDialog* self);
static void games_scores_dialog_load_categories (GamesScoresDialog* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void __lambda10_ (GamesScoresDialog* self,
                  GamesScoresCategory* x);
static void ___lambda10__gfunc (gconstpointer data,
                         gpointer self);
static void games_scores_dialog_display_single_score (GamesScoresDialog* self,
                                               GamesScoresScore* score,
                                               gint row_count,
                                               guint no_scores);
static void games_scores_dialog_make_remaining_labels_empty (GamesScoresDialog* self,
                                                      gint row_count);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void ___lambda9_ (Block5Data* _data5_);
VALA_EXTERN void games_scores_context_update_score_name (GamesScoresContext* self,
                                             GamesScoresScore* old_score,
                                             GamesScoresCategory* category,
                                             const gchar* new_name);
static void ____lambda9__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void games_scores_dialog_finalize (GObject * obj);
static GType games_scores_dialog_get_type_once (void);

static inline gpointer
games_scores_dialog_get_instance_private (GamesScoresDialog* self)
{
	return G_STRUCT_MEMBER_P (self, GamesScoresDialog_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_games_scores_dialog_load_scores_gtk_combo_box_changed (GtkComboBox* _sender,
                                                        gpointer self)
{
	games_scores_dialog_load_scores ((GamesScoresDialog*) self);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

GamesScoresDialog*
games_scores_dialog_construct (GType object_type,
                               GamesScoresContext* context,
                               const gchar* category_type,
                               GamesScoresStyle style,
                               GamesScoresScore* new_high_score,
                               GamesScoresCategory* current_cat,
                               GtkWindow* window,
                               const gchar* icon_name)
{
	GamesScoresDialog * self = NULL;
	GamesScoresContext* _tmp0_;
	GamesScoresScore* _tmp1_;
	GamesScoresCategory* _tmp2_;
	GtkHeaderBar* _tmp3_;
	GtkHeaderBar* _tmp4_;
	GtkHeaderBar* _tmp5_;
	GtkBox* vbox = NULL;
	GtkBox* _tmp10_;
	GtkBox* _tmp11_;
	GtkBox* _tmp12_;
	gboolean _tmp13_ = FALSE;
	GtkBox* _tmp41_;
	GtkBox* catbar = NULL;
	GtkBox* _tmp42_;
	GtkBox* _tmp43_;
	GtkBox* _tmp44_;
	GtkBox* _tmp45_;
	GtkBox* _tmp46_;
	GtkBox* _tmp47_;
	GtkBox* _tmp48_;
	GtkSeparator* hdiv = NULL;
	GtkSeparator* _tmp49_;
	GtkBox* _tmp50_;
	GtkSeparator* _tmp51_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp52_;
	GtkLabel* _tmp53_;
	GtkLabel* _tmp54_;
	GtkBox* _tmp55_;
	GtkLabel* _tmp56_;
	GList* categories = NULL;
	GList* _tmp57_;
	gboolean _tmp58_ = FALSE;
	GtkGrid* _tmp78_;
	GtkBox* _tmp79_;
	GtkGrid* _tmp80_;
	GtkGrid* _tmp81_;
	GtkGrid* _tmp82_;
	GtkGrid* _tmp83_;
	GtkGrid* _tmp84_;
	GtkGrid* _tmp85_;
	GtkGrid* _tmp86_;
	gchar* string_rank = NULL;
	gchar* _tmp87_;
	GtkLabel* label_column_1 = NULL;
	const gchar* _tmp88_;
	gchar* _tmp89_;
	gchar* _tmp90_;
	gchar* _tmp91_;
	gchar* _tmp92_;
	GtkLabel* _tmp93_;
	GtkLabel* _tmp94_;
	GtkLabel* _tmp95_;
	GtkGrid* _tmp96_;
	GtkLabel* _tmp97_;
	gchar* score_or_time = NULL;
	gchar* _tmp98_;
	gboolean _tmp99_ = FALSE;
	GtkLabel* label_column_2 = NULL;
	const gchar* _tmp102_;
	gchar* _tmp103_;
	gchar* _tmp104_;
	gchar* _tmp105_;
	gchar* _tmp106_;
	GtkLabel* _tmp107_;
	GtkLabel* _tmp108_;
	GtkLabel* _tmp109_;
	GtkGrid* _tmp110_;
	GtkLabel* _tmp111_;
	gchar* string_player = NULL;
	gchar* _tmp112_;
	GtkLabel* label_column_3 = NULL;
	const gchar* _tmp113_;
	gchar* _tmp114_;
	gchar* _tmp115_;
	gchar* _tmp116_;
	gchar* _tmp117_;
	GtkLabel* _tmp118_;
	GtkLabel* _tmp119_;
	GtkLabel* _tmp120_;
	GtkGrid* _tmp121_;
	GtkLabel* _tmp122_;
	GtkGrid* _tmp123_;
	GtkBox* _tmp126_;
	g_return_val_if_fail (context != NULL, NULL);
	g_return_val_if_fail (category_type != NULL, NULL);
	g_return_val_if_fail (window != NULL, NULL);
	g_return_val_if_fail (icon_name != NULL, NULL);
	self = (GamesScoresDialog*) g_object_new (object_type, "use-header-bar", 1, NULL);
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
	_tmp0_ = _g_object_ref0 (context);
	_g_object_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	gtk_window_set_transient_for ((GtkWindow*) self, window);
	_tmp1_ = _g_object_ref0 (new_high_score);
	_g_object_unref0 (self->priv->new_high_score);
	self->priv->new_high_score = _tmp1_;
	self->priv->scores_style = style;
	_tmp2_ = _g_object_ref0 (current_cat);
	_g_object_unref0 (self->priv->scores_active_category);
	self->priv->scores_active_category = _tmp2_;
	_tmp3_ = gtk_dialog_get_header_bar ((GtkDialog*) self);
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_header_bar_get_type (), GtkHeaderBar));
	_g_object_unref0 (self->priv->headerbar);
	self->priv->headerbar = _tmp4_;
	_tmp5_ = self->priv->headerbar;
	gtk_header_bar_set_show_close_button (_tmp5_, new_high_score == NULL);
	if (new_high_score != NULL) {
		GtkHeaderBar* _tmp6_;
		_tmp6_ = self->priv->headerbar;
		gtk_header_bar_set_title (_tmp6_, _ ("Congratulations!"));
	} else {
		gboolean _tmp7_ = FALSE;
		if (self->priv->scores_style == GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER) {
			_tmp7_ = TRUE;
		} else {
			_tmp7_ = self->priv->scores_style == GAMES_SCORES_STYLE_POINTS_LESS_IS_BETTER;
		}
		if (_tmp7_) {
			GtkHeaderBar* _tmp8_;
			_tmp8_ = self->priv->headerbar;
			gtk_header_bar_set_title (_tmp8_, _ ("High Scores"));
		} else {
			GtkHeaderBar* _tmp9_;
			_tmp9_ = self->priv->headerbar;
			gtk_header_bar_set_title (_tmp9_, _ ("Best Times"));
		}
	}
	_tmp10_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp11_ = _g_object_ref0 (_tmp10_);
	vbox = _tmp11_;
	_tmp12_ = vbox;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp12_, GTK_ORIENTATION_VERTICAL);
	if (!games_scores_context_has_scores (context)) {
		_tmp13_ = new_high_score == NULL;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		GtkBox* _tmp14_;
		GtkBox* _tmp15_;
		GtkBox* _tmp16_;
		GtkBox* _tmp17_;
		GtkBox* _tmp18_;
		GtkStyleContext* _tmp19_;
		GtkImage* image = NULL;
		GtkImage* _tmp20_;
		GtkImage* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		GtkImage* _tmp24_;
		GtkImage* _tmp25_;
		GtkBox* _tmp26_;
		GtkImage* _tmp27_;
		GtkLabel* title_label = NULL;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		GtkLabel* _tmp32_;
		GtkLabel* _tmp33_;
		GtkLabel* _tmp34_;
		GtkBox* _tmp35_;
		GtkLabel* _tmp36_;
		GtkLabel* description_label = NULL;
		GtkLabel* _tmp37_;
		GtkBox* _tmp38_;
		GtkLabel* _tmp39_;
		GtkBox* _tmp40_;
		_tmp14_ = vbox;
		gtk_box_set_spacing (_tmp14_, 4);
		_tmp15_ = vbox;
		gtk_widget_set_hexpand ((GtkWidget*) _tmp15_, TRUE);
		_tmp16_ = vbox;
		gtk_widget_set_vexpand ((GtkWidget*) _tmp16_, TRUE);
		_tmp17_ = vbox;
		gtk_widget_set_valign ((GtkWidget*) _tmp17_, GTK_ALIGN_CENTER);
		_tmp18_ = vbox;
		_tmp19_ = gtk_widget_get_style_context ((GtkWidget*) _tmp18_);
		gtk_style_context_add_class (_tmp19_, "dim-label");
		_tmp20_ = (GtkImage*) gtk_image_new ();
		g_object_ref_sink (_tmp20_);
		image = _tmp20_;
		_tmp21_ = image;
		_tmp22_ = g_strconcat (icon_name, "-symbolic", NULL);
		_tmp23_ = _tmp22_;
		g_object_set (_tmp21_, "icon-name", _tmp23_, NULL);
		_g_free0 (_tmp23_);
		_tmp24_ = image;
		gtk_image_set_pixel_size (_tmp24_, 64);
		_tmp25_ = image;
		gtk_widget_set_opacity ((GtkWidget*) _tmp25_, 0.2);
		_tmp26_ = vbox;
		_tmp27_ = image;
		gtk_container_add ((GtkContainer*) _tmp26_, (GtkWidget*) _tmp27_);
		_tmp28_ = g_strconcat ("<b><span size=\"large\">", _ ("No scores yet"), NULL);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_strconcat (_tmp29_, "</span></b>", NULL);
		_tmp31_ = _tmp30_;
		_tmp32_ = (GtkLabel*) gtk_label_new (_tmp31_);
		g_object_ref_sink (_tmp32_);
		_tmp33_ = _tmp32_;
		_g_free0 (_tmp31_);
		_g_free0 (_tmp29_);
		title_label = _tmp33_;
		_tmp34_ = title_label;
		gtk_label_set_use_markup (_tmp34_, TRUE);
		_tmp35_ = vbox;
		_tmp36_ = title_label;
		gtk_container_add ((GtkContainer*) _tmp35_, (GtkWidget*) _tmp36_);
		_tmp37_ = (GtkLabel*) gtk_label_new (_ ("Play some games and your scores will show up here."));
		g_object_ref_sink (_tmp37_);
		description_label = _tmp37_;
		_tmp38_ = vbox;
		_tmp39_ = description_label;
		gtk_container_add ((GtkContainer*) _tmp38_, (GtkWidget*) _tmp39_);
		_tmp40_ = vbox;
		gtk_widget_show_all ((GtkWidget*) _tmp40_);
		g_object_set ((GtkWidget*) self, "width-request", 450, NULL);
		g_object_set ((GtkWidget*) self, "height-request", 500, NULL);
		_g_object_unref0 (description_label);
		_g_object_unref0 (title_label);
		_g_object_unref0 (image);
		_g_object_unref0 (vbox);
		return self;
	}
	_tmp41_ = vbox;
	gtk_box_set_spacing (_tmp41_, 20);
	_tmp42_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	g_object_ref_sink (_tmp42_);
	catbar = _tmp42_;
	_tmp43_ = catbar;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp43_, 20);
	_tmp44_ = catbar;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp44_, 20);
	_tmp45_ = catbar;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp45_, 20);
	_tmp46_ = catbar;
	gtk_widget_set_halign ((GtkWidget*) _tmp46_, GTK_ALIGN_CENTER);
	_tmp47_ = vbox;
	_tmp48_ = catbar;
	gtk_container_add ((GtkContainer*) _tmp47_, (GtkWidget*) _tmp48_);
	_tmp49_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp49_);
	hdiv = _tmp49_;
	_tmp50_ = vbox;
	_tmp51_ = hdiv;
	gtk_container_add ((GtkContainer*) _tmp50_, (GtkWidget*) _tmp51_);
	_tmp52_ = (GtkLabel*) gtk_label_new (category_type);
	g_object_ref_sink (_tmp52_);
	label = _tmp52_;
	_tmp53_ = label;
	gtk_label_set_use_markup (_tmp53_, TRUE);
	_tmp54_ = label;
	gtk_widget_set_halign ((GtkWidget*) _tmp54_, GTK_ALIGN_CENTER);
	_tmp55_ = catbar;
	_tmp56_ = label;
	gtk_container_add ((GtkContainer*) _tmp55_, (GtkWidget*) _tmp56_);
	_tmp57_ = games_scores_context_get_categories (context);
	categories = _tmp57_;
	if (new_high_score != NULL) {
		_tmp58_ = TRUE;
	} else {
		GList* _tmp59_;
		_tmp59_ = categories;
		_tmp58_ = g_list_length (_tmp59_) == ((guint) 1);
	}
	if (_tmp58_) {
		GamesScoresCategory* _tmp64_;
		const gchar* _tmp65_;
		const gchar* _tmp66_;
		GtkLabel* _tmp67_;
		GtkLabel* _tmp68_;
		GtkLabel* _tmp69_;
		GtkLabel* _tmp70_;
		GtkBox* _tmp71_;
		GtkLabel* _tmp72_;
		if (new_high_score == NULL) {
			GList* _tmp60_;
			GList* _tmp61_;
			gconstpointer _tmp62_;
			GamesScoresCategory* _tmp63_;
			_tmp60_ = categories;
			_tmp61_ = g_list_first (_tmp60_);
			_tmp62_ = ((GList*) _tmp61_)->data;
			_tmp63_ = _g_object_ref0 ((GamesScoresCategory*) _tmp62_);
			_g_object_unref0 (self->priv->scores_active_category);
			self->priv->scores_active_category = _tmp63_;
		}
		_tmp64_ = self->priv->scores_active_category;
		_tmp65_ = games_scores_category_get_name (_tmp64_);
		_tmp66_ = _tmp65_;
		_tmp67_ = (GtkLabel*) gtk_label_new (_tmp66_);
		g_object_ref_sink (_tmp67_);
		_g_object_unref0 (self->priv->category_label);
		self->priv->category_label = _tmp67_;
		_tmp68_ = self->priv->category_label;
		gtk_label_set_use_markup (_tmp68_, TRUE);
		_tmp69_ = self->priv->category_label;
		gtk_widget_set_halign ((GtkWidget*) _tmp69_, GTK_ALIGN_CENTER);
		_tmp70_ = self->priv->category_label;
		gtk_widget_set_valign ((GtkWidget*) _tmp70_, GTK_ALIGN_CENTER);
		_tmp71_ = catbar;
		_tmp72_ = self->priv->category_label;
		gtk_container_add ((GtkContainer*) _tmp71_, (GtkWidget*) _tmp72_);
	} else {
		GtkComboBoxText* _tmp73_;
		GtkComboBoxText* _tmp74_;
		GtkBox* _tmp75_;
		GtkComboBoxText* _tmp76_;
		GtkComboBoxText* _tmp77_;
		_tmp73_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
		g_object_ref_sink (_tmp73_);
		_g_object_unref0 (self->priv->combo);
		self->priv->combo = _tmp73_;
		_tmp74_ = self->priv->combo;
		gtk_widget_set_focus_on_click ((GtkWidget*) _tmp74_, FALSE);
		_tmp75_ = catbar;
		_tmp76_ = self->priv->combo;
		gtk_container_add ((GtkContainer*) _tmp75_, (GtkWidget*) _tmp76_);
		_tmp77_ = self->priv->combo;
		g_signal_connect_object ((GtkComboBox*) _tmp77_, "changed", (GCallback) _games_scores_dialog_load_scores_gtk_combo_box_changed, self, 0);
	}
	_tmp78_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp78_);
	_g_object_unref0 (self->priv->grid);
	self->priv->grid = _tmp78_;
	_tmp79_ = vbox;
	_tmp80_ = self->priv->grid;
	gtk_container_add ((GtkContainer*) _tmp79_, (GtkWidget*) _tmp80_);
	_tmp81_ = self->priv->grid;
	gtk_grid_set_row_homogeneous (_tmp81_, TRUE);
	_tmp82_ = self->priv->grid;
	gtk_grid_set_column_spacing (_tmp82_, 40);
	_tmp83_ = self->priv->grid;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp83_, 30);
	_tmp84_ = self->priv->grid;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp84_, 30);
	_tmp85_ = self->priv->grid;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp85_, 20);
	_tmp86_ = self->priv->grid;
	gtk_widget_set_halign ((GtkWidget*) _tmp86_, GTK_ALIGN_CENTER);
	_tmp87_ = g_strdup (_ ("Rank"));
	string_rank = _tmp87_;
	_tmp88_ = string_rank;
	_tmp89_ = g_strconcat ("<span weight='bold'>", _tmp88_, NULL);
	_tmp90_ = _tmp89_;
	_tmp91_ = g_strconcat (_tmp90_, "</span>", NULL);
	_tmp92_ = _tmp91_;
	_tmp93_ = (GtkLabel*) gtk_label_new (_tmp92_);
	g_object_ref_sink (_tmp93_);
	_tmp94_ = _tmp93_;
	_g_free0 (_tmp92_);
	_g_free0 (_tmp90_);
	label_column_1 = _tmp94_;
	_tmp95_ = label_column_1;
	gtk_label_set_use_markup (_tmp95_, TRUE);
	_tmp96_ = self->priv->grid;
	_tmp97_ = label_column_1;
	gtk_grid_attach (_tmp96_, (GtkWidget*) _tmp97_, 0, 0, 1, 1);
	_tmp98_ = g_strdup ("");
	score_or_time = _tmp98_;
	if (self->priv->scores_style == GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER) {
		_tmp99_ = TRUE;
	} else {
		_tmp99_ = self->priv->scores_style == GAMES_SCORES_STYLE_POINTS_LESS_IS_BETTER;
	}
	if (_tmp99_) {
		gchar* _tmp100_;
		_tmp100_ = g_strdup (_ ("Score"));
		_g_free0 (score_or_time);
		score_or_time = _tmp100_;
	} else {
		gchar* _tmp101_;
		_tmp101_ = g_strdup (_ ("Time"));
		_g_free0 (score_or_time);
		score_or_time = _tmp101_;
	}
	_tmp102_ = score_or_time;
	_tmp103_ = g_strconcat ("<span weight='bold'>", _tmp102_, NULL);
	_tmp104_ = _tmp103_;
	_tmp105_ = g_strconcat (_tmp104_, "</span>", NULL);
	_tmp106_ = _tmp105_;
	_tmp107_ = (GtkLabel*) gtk_label_new (_tmp106_);
	g_object_ref_sink (_tmp107_);
	_tmp108_ = _tmp107_;
	_g_free0 (_tmp106_);
	_g_free0 (_tmp104_);
	label_column_2 = _tmp108_;
	_tmp109_ = label_column_2;
	gtk_label_set_use_markup (_tmp109_, TRUE);
	_tmp110_ = self->priv->grid;
	_tmp111_ = label_column_2;
	gtk_grid_attach (_tmp110_, (GtkWidget*) _tmp111_, 1, 0, 1, 1);
	_tmp112_ = g_strdup (_ ("Player"));
	string_player = _tmp112_;
	_tmp113_ = string_player;
	_tmp114_ = g_strconcat ("<span weight='bold'>", _tmp113_, NULL);
	_tmp115_ = _tmp114_;
	_tmp116_ = g_strconcat (_tmp115_, "</span>", NULL);
	_tmp117_ = _tmp116_;
	_tmp118_ = (GtkLabel*) gtk_label_new (_tmp117_);
	g_object_ref_sink (_tmp118_);
	_tmp119_ = _tmp118_;
	_g_free0 (_tmp117_);
	_g_free0 (_tmp115_);
	label_column_3 = _tmp119_;
	_tmp120_ = label_column_3;
	gtk_label_set_use_markup (_tmp120_, TRUE);
	_tmp121_ = self->priv->grid;
	_tmp122_ = label_column_3;
	gtk_grid_attach (_tmp121_, (GtkWidget*) _tmp122_, 2, 0, 1, 1);
	_tmp123_ = self->priv->grid;
	gtk_grid_set_baseline_row (_tmp123_, 0);
	games_scores_dialog_fill_grid_with_labels (self);
	if (new_high_score != NULL) {
		GtkWidget* _tmp124_;
		GtkStyleContext* _tmp125_;
		_tmp124_ = gtk_dialog_add_button ((GtkDialog*) self, _ ("_Done"), (gint) GTK_RESPONSE_OK);
		_tmp125_ = gtk_widget_get_style_context (_tmp124_);
		gtk_style_context_add_class (_tmp125_, "suggested-action");
	}
	games_scores_dialog_load_categories (self);
	_tmp126_ = vbox;
	gtk_widget_show_all ((GtkWidget*) _tmp126_);
	_g_object_unref0 (label_column_3);
	_g_free0 (string_player);
	_g_object_unref0 (label_column_2);
	_g_free0 (score_or_time);
	_g_object_unref0 (label_column_1);
	_g_free0 (string_rank);
	(categories == NULL) ? NULL : (categories = (_g_list_free__g_object_unref0_ (categories), NULL));
	_g_object_unref0 (label);
	_g_object_unref0 (hdiv);
	_g_object_unref0 (catbar);
	_g_object_unref0 (vbox);
	return self;
}

GamesScoresDialog*
games_scores_dialog_new (GamesScoresContext* context,
                         const gchar* category_type,
                         GamesScoresStyle style,
                         GamesScoresScore* new_high_score,
                         GamesScoresCategory* current_cat,
                         GtkWindow* window,
                         const gchar* icon_name)
{
	return games_scores_dialog_construct (GAMES_SCORES_TYPE_DIALOG, context, category_type, style, new_high_score, current_cat, window, icon_name);
}

static void
games_scores_dialog_fill_grid_with_labels (GamesScoresDialog* self)
{
	g_return_if_fail (self != NULL);
	{
		gint row = 0;
		row = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GtkStack* stack = NULL;
				GtkStack* _tmp10_;
				GtkStack* _tmp11_;
				GtkStack* _tmp12_;
				GtkStack* _tmp13_;
				GtkStack* _tmp14_;
				GtkLabel* label = NULL;
				GtkLabel* _tmp15_;
				GtkLabel* _tmp16_;
				GtkLabel* _tmp17_;
				GtkLabel* _tmp18_;
				GtkStack* _tmp19_;
				GtkLabel* _tmp20_;
				GtkEntry* entry = NULL;
				GtkEntry* _tmp21_;
				GtkEntry* _tmp22_;
				GtkEntry* _tmp23_;
				GtkEntry* _tmp24_;
				GtkEntry* _tmp25_;
				GtkStack* _tmp26_;
				GtkEntry* _tmp27_;
				GtkStack* _tmp28_;
				GtkGrid* _tmp29_;
				GtkStack* _tmp30_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = row;
					row = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(row <= self->priv->rows_to_display)) {
					break;
				}
				{
					gint column = 0;
					column = 0;
					{
						gboolean _tmp2_ = FALSE;
						_tmp2_ = TRUE;
						while (TRUE) {
							GtkLabel* label = NULL;
							GtkLabel* _tmp4_;
							GtkLabel* _tmp5_;
							GtkLabel* _tmp6_;
							GtkLabel* _tmp7_;
							GtkGrid* _tmp8_;
							GtkLabel* _tmp9_;
							if (!_tmp2_) {
								gint _tmp3_;
								_tmp3_ = column;
								column = _tmp3_ + 1;
							}
							_tmp2_ = FALSE;
							if (!(column <= 1)) {
								break;
							}
							_tmp4_ = (GtkLabel*) gtk_label_new ("");
							g_object_ref_sink (_tmp4_);
							label = _tmp4_;
							_tmp5_ = label;
							gtk_widget_set_visible ((GtkWidget*) _tmp5_, TRUE);
							_tmp6_ = label;
							gtk_widget_set_halign ((GtkWidget*) _tmp6_, GTK_ALIGN_CENTER);
							_tmp7_ = label;
							gtk_widget_set_valign ((GtkWidget*) _tmp7_, GTK_ALIGN_CENTER);
							_tmp8_ = self->priv->grid;
							_tmp9_ = label;
							gtk_grid_attach (_tmp8_, (GtkWidget*) _tmp9_, column, row, 1, 1);
							_g_object_unref0 (label);
						}
					}
				}
				_tmp10_ = (GtkStack*) gtk_stack_new ();
				g_object_ref_sink (_tmp10_);
				stack = _tmp10_;
				_tmp11_ = stack;
				gtk_widget_set_visible ((GtkWidget*) _tmp11_, TRUE);
				_tmp12_ = stack;
				gtk_stack_set_homogeneous (_tmp12_, FALSE);
				_tmp13_ = stack;
				gtk_stack_set_vhomogeneous (_tmp13_, TRUE);
				_tmp14_ = stack;
				gtk_stack_set_transition_type (_tmp14_, GTK_STACK_TRANSITION_TYPE_NONE);
				_tmp15_ = (GtkLabel*) gtk_label_new ("");
				g_object_ref_sink (_tmp15_);
				label = _tmp15_;
				_tmp16_ = label;
				gtk_widget_set_visible ((GtkWidget*) _tmp16_, TRUE);
				_tmp17_ = label;
				gtk_label_set_justify (_tmp17_, GTK_JUSTIFY_CENTER);
				_tmp18_ = label;
				gtk_widget_set_valign ((GtkWidget*) _tmp18_, GTK_ALIGN_CENTER);
				_tmp19_ = stack;
				_tmp20_ = label;
				gtk_stack_add_named (_tmp19_, (GtkWidget*) _tmp20_, "label");
				_tmp21_ = (GtkEntry*) gtk_entry_new ();
				g_object_ref_sink (_tmp21_);
				entry = _tmp21_;
				_tmp22_ = entry;
				gtk_widget_set_visible ((GtkWidget*) _tmp22_, TRUE);
				_tmp23_ = entry;
				gtk_widget_set_size_request ((GtkWidget*) _tmp23_, 20, 20);
				_tmp24_ = entry;
				gtk_widget_set_hexpand ((GtkWidget*) _tmp24_, FALSE);
				_tmp25_ = entry;
				gtk_widget_set_vexpand ((GtkWidget*) _tmp25_, FALSE);
				_tmp26_ = stack;
				_tmp27_ = entry;
				gtk_stack_add_named (_tmp26_, (GtkWidget*) _tmp27_, "entry");
				_tmp28_ = stack;
				gtk_stack_set_visible_child_name (_tmp28_, "label");
				_tmp29_ = self->priv->grid;
				_tmp30_ = stack;
				gtk_grid_attach (_tmp29_, (GtkWidget*) _tmp30_, 2, row, 1, 1);
				_g_object_unref0 (entry);
				_g_object_unref0 (label);
				_g_object_unref0 (stack);
			}
		}
	}
}

static void
__lambda10_ (GamesScoresDialog* self,
             GamesScoresCategory* x)
{
	GtkComboBoxText* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	_tmp0_ = self->priv->combo;
	_tmp1_ = games_scores_category_get_key (x);
	_tmp2_ = _tmp1_;
	_tmp3_ = games_scores_category_get_name (x);
	_tmp4_ = _tmp3_;
	gtk_combo_box_text_append (_tmp0_, _tmp2_, _tmp4_);
}

static void
___lambda10__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda10_ ((GamesScoresDialog*) self, (GamesScoresCategory*) data);
}

static void
games_scores_dialog_load_categories (GamesScoresDialog* self)
{
	gboolean _tmp0_ = FALSE;
	GamesScoresScore* _tmp1_;
	GtkComboBoxText* _tmp3_;
	GList* categories = NULL;
	GamesScoresContext* _tmp4_;
	GList* _tmp5_;
	GList* _tmp6_;
	GamesScoresCategory* _tmp7_;
	GamesScoresCategory* _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->new_high_score;
	if (_tmp1_ != NULL) {
		_tmp0_ = TRUE;
	} else {
		GtkComboBoxText* _tmp2_;
		_tmp2_ = self->priv->combo;
		_tmp0_ = _tmp2_ == NULL;
	}
	if (_tmp0_) {
		games_scores_dialog_load_scores (self);
	}
	_tmp3_ = self->priv->combo;
	if (_tmp3_ == NULL) {
		return;
	}
	_tmp4_ = self->priv->context;
	_tmp5_ = games_scores_context_get_categories (_tmp4_);
	categories = _tmp5_;
	_tmp6_ = categories;
	g_list_foreach (_tmp6_, ___lambda10__gfunc, self);
	_tmp7_ = self->priv->scores_active_category;
	if (_tmp7_ == NULL) {
		GtkComboBoxText* _tmp8_;
		GList* _tmp9_;
		gconstpointer _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp8_ = self->priv->combo;
		_tmp9_ = categories;
		_tmp10_ = g_list_nth_data (_tmp9_, (guint) 0);
		_tmp11_ = games_scores_category_get_key ((GamesScoresCategory*) _tmp10_);
		_tmp12_ = _tmp11_;
		gtk_combo_box_set_active_id ((GtkComboBox*) _tmp8_, _tmp12_);
	} else {
		GtkComboBoxText* _tmp13_;
		GamesScoresCategory* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp13_ = self->priv->combo;
		_tmp14_ = self->priv->scores_active_category;
		_tmp15_ = games_scores_category_get_key (_tmp14_);
		_tmp16_ = _tmp15_;
		gtk_combo_box_set_active_id ((GtkComboBox*) _tmp13_, _tmp16_);
	}
	_tmp17_ = self->priv->active_category;
	if (_tmp17_ == NULL) {
		GList* _tmp18_;
		gconstpointer _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		GList* _tmp22_;
		gconstpointer _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		GamesScoresCategory* _tmp26_;
		_tmp18_ = categories;
		_tmp19_ = g_list_nth_data (_tmp18_, (guint) 0);
		_tmp20_ = games_scores_category_get_key ((GamesScoresCategory*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = categories;
		_tmp23_ = g_list_nth_data (_tmp22_, (guint) 0);
		_tmp24_ = games_scores_category_get_name ((GamesScoresCategory*) _tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = games_scores_category_new (_tmp21_, _tmp25_);
		_g_object_unref0 (self->priv->active_category);
		self->priv->active_category = _tmp26_;
	} else {
		GamesScoresCategory* _tmp27_;
		GList* _tmp28_;
		gconstpointer _tmp29_;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		GamesScoresCategory* _tmp32_;
		GList* _tmp33_;
		gconstpointer _tmp34_;
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		_tmp27_ = self->priv->active_category;
		_tmp28_ = categories;
		_tmp29_ = g_list_nth_data (_tmp28_, (guint) 0);
		_tmp30_ = games_scores_category_get_key ((GamesScoresCategory*) _tmp29_);
		_tmp31_ = _tmp30_;
		games_scores_category_set_key (_tmp27_, _tmp31_);
		_tmp32_ = self->priv->active_category;
		_tmp33_ = categories;
		_tmp34_ = g_list_nth_data (_tmp33_, (guint) 0);
		_tmp35_ = games_scores_category_get_name ((GamesScoresCategory*) _tmp34_);
		_tmp36_ = _tmp35_;
		games_scores_category_set_name (_tmp32_, _tmp36_);
	}
	(categories == NULL) ? NULL : (categories = (_g_list_free__g_object_unref0_ (categories), NULL));
}

static void
games_scores_dialog_load_scores (GamesScoresDialog* self)
{
	gboolean _tmp0_ = FALSE;
	GamesScoresScore* _tmp1_;
	GeeList* best_n_scores = NULL;
	GamesScoresContext* _tmp16_;
	GamesScoresCategory* _tmp17_;
	GeeList* _tmp18_;
	gint row_count = 0;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->new_high_score;
	if (_tmp1_ != NULL) {
		_tmp0_ = TRUE;
	} else {
		GtkComboBoxText* _tmp2_;
		_tmp2_ = self->priv->combo;
		_tmp0_ = _tmp2_ == NULL;
	}
	if (_tmp0_) {
		GamesScoresCategory* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		GamesScoresCategory* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		GamesScoresCategory* _tmp9_;
		_tmp3_ = self->priv->scores_active_category;
		_tmp4_ = games_scores_category_get_key (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->scores_active_category;
		_tmp7_ = games_scores_category_get_name (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = games_scores_category_new (_tmp5_, _tmp8_);
		_g_object_unref0 (self->priv->active_category);
		self->priv->active_category = _tmp9_;
	} else {
		GtkComboBoxText* _tmp10_;
		const gchar* _tmp11_;
		GtkComboBoxText* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		GamesScoresCategory* _tmp15_;
		_tmp10_ = self->priv->combo;
		_tmp11_ = gtk_combo_box_get_active_id ((GtkComboBox*) _tmp10_);
		_tmp12_ = self->priv->combo;
		_tmp13_ = gtk_combo_box_text_get_active_text (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = games_scores_category_new (_tmp11_, _tmp14_);
		_g_object_unref0 (self->priv->active_category);
		self->priv->active_category = _tmp15_;
		_g_free0 (_tmp14_);
	}
	_tmp16_ = self->priv->context;
	_tmp17_ = self->priv->active_category;
	_tmp18_ = games_scores_context_get_high_scores (_tmp16_, _tmp17_, self->priv->rows_to_display);
	best_n_scores = _tmp18_;
	row_count = 1;
	{
		GeeList* _score_list = NULL;
		GeeList* _tmp19_;
		gint _score_size = 0;
		GeeList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint _score_index = 0;
		_tmp19_ = best_n_scores;
		_score_list = _tmp19_;
		_tmp20_ = _score_list;
		_tmp21_ = gee_collection_get_size ((GeeCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_score_size = _tmp22_;
		_score_index = -1;
		while (TRUE) {
			gint _tmp23_;
			gint _tmp24_;
			GamesScoresScore* score = NULL;
			GeeList* _tmp25_;
			gpointer _tmp26_;
			GamesScoresScore* _tmp27_;
			GeeList* _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			gint _tmp31_;
			_score_index = _score_index + 1;
			_tmp23_ = _score_index;
			_tmp24_ = _score_size;
			if (!(_tmp23_ < _tmp24_)) {
				break;
			}
			_tmp25_ = _score_list;
			_tmp26_ = gee_list_get (_tmp25_, _score_index);
			score = (GamesScoresScore*) _tmp26_;
			_tmp27_ = score;
			_tmp28_ = best_n_scores;
			_tmp29_ = gee_collection_get_size ((GeeCollection*) _tmp28_);
			_tmp30_ = _tmp29_;
			games_scores_dialog_display_single_score (self, _tmp27_, row_count, (guint) _tmp30_);
			_tmp31_ = row_count;
			row_count = _tmp31_ + 1;
			_g_object_unref0 (score);
		}
	}
	if (row_count < (self->priv->rows_to_display + 1)) {
		games_scores_dialog_make_remaining_labels_empty (self, row_count);
	}
	_g_object_unref0 (best_n_scores);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		GamesScoresDialog* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->score);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		GamesScoresDialog* self;
		self = _data5_->_data4_->self;
		_g_object_unref0 (_data5_->entry);
		block4_data_unref (_data5_->_data4_);
		_data5_->_data4_ = NULL;
		g_slice_free (Block5Data, _data5_);
	}
}

static void
___lambda9_ (Block5Data* _data5_)
{
	Block4Data* _data4_;
	GamesScoresDialog* self;
	GamesScoresContext* _tmp0_;
	GamesScoresCategory* _tmp1_;
	GtkEntry* _tmp2_;
	const gchar* _tmp3_;
	GtkEntry* _tmp4_;
	const gchar* _tmp5_;
	_data4_ = _data5_->_data4_;
	self = _data4_->self;
	_tmp0_ = self->priv->context;
	_tmp1_ = self->priv->active_category;
	_tmp2_ = _data5_->entry;
	_tmp3_ = gtk_entry_get_text (_tmp2_);
	games_scores_context_update_score_name (_tmp0_, _data4_->score, _tmp1_, _tmp3_);
	_tmp4_ = _data5_->entry;
	_tmp5_ = gtk_entry_get_text (_tmp4_);
	games_scores_score_set_user (_data4_->score, _tmp5_);
}

static void
____lambda9__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	___lambda9_ (self);
}

static void
games_scores_dialog_display_single_score (GamesScoresDialog* self,
                                          GamesScoresScore* score,
                                          gint row_count,
                                          guint no_scores)
{
	Block4Data* _data4_;
	GamesScoresScore* _tmp0_;
	GtkLabel* rank_label = NULL;
	GtkGrid* _tmp1_;
	GtkWidget* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GtkLabel* score_label = NULL;
	GtkGrid* _tmp7_;
	GtkWidget* _tmp8_;
	GtkLabel* _tmp9_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp27_ = FALSE;
	GamesScoresScore* _tmp28_;
	GtkStack* name_stack = NULL;
	GtkGrid* _tmp44_;
	GtkWidget* _tmp45_;
	GtkStack* _tmp46_;
	GtkWidget* widget = NULL;
	GtkStack* _tmp47_;
	GtkWidget* _tmp48_;
	GtkWidget* _tmp49_;
	GtkStack* _tmp50_;
	const gchar* _tmp51_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (score != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (score);
	_g_object_unref0 (_data4_->score);
	_data4_->score = _tmp0_;
	_tmp1_ = self->priv->grid;
	_tmp2_ = gtk_grid_get_child_at (_tmp1_, 0, row_count);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_label_get_type (), GtkLabel));
	rank_label = _tmp3_;
	_tmp4_ = rank_label;
	_tmp5_ = g_strdup_printf ("%i", row_count);
	_tmp6_ = _tmp5_;
	gtk_label_set_text (_tmp4_, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = self->priv->grid;
	_tmp8_ = gtk_grid_get_child_at (_tmp7_, 1, row_count);
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_label_get_type (), GtkLabel));
	score_label = _tmp9_;
	if (self->priv->scores_style == GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER) {
		_tmp10_ = TRUE;
	} else {
		_tmp10_ = self->priv->scores_style == GAMES_SCORES_STYLE_POINTS_LESS_IS_BETTER;
	}
	if (_tmp10_) {
		GtkLabel* _tmp11_;
		glong _tmp12_;
		glong _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp11_ = score_label;
		_tmp12_ = games_scores_score_get_score (_data4_->score);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strdup_printf ("%li", _tmp13_);
		_tmp15_ = _tmp14_;
		gtk_label_set_text (_tmp11_, _tmp15_);
		_g_free0 (_tmp15_);
	} else {
		glong minutes = 0L;
		glong _tmp16_;
		glong _tmp17_;
		glong seconds = 0L;
		glong _tmp18_;
		glong _tmp19_;
		GtkLabel* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		_tmp16_ = games_scores_score_get_score (_data4_->score);
		_tmp17_ = _tmp16_;
		minutes = _tmp17_ / 60;
		_tmp18_ = games_scores_score_get_score (_data4_->score);
		_tmp19_ = _tmp18_;
		seconds = _tmp19_ % 60;
		_tmp20_ = score_label;
		_tmp21_ = g_strdup_printf (ngettext ("%ld minute", "%ld minutes", (gulong) minutes), minutes);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strdup_printf (ngettext ("%ld second", "%ld seconds", (gulong) seconds), seconds);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_strdup_printf ("%s %s", _tmp22_, _tmp24_);
		_tmp26_ = _tmp25_;
		gtk_label_set_text (_tmp20_, _tmp26_);
		_g_free0 (_tmp26_);
		_g_free0 (_tmp24_);
		_g_free0 (_tmp22_);
	}
	_tmp28_ = self->priv->new_high_score;
	if (_tmp28_ != NULL) {
		GamesScoresScore* _tmp29_;
		_tmp29_ = self->priv->new_high_score;
		_tmp27_ = games_scores_score_equals (_data4_->score, _tmp29_);
	} else {
		_tmp27_ = FALSE;
	}
	if (_tmp27_) {
		Block5Data* _data5_;
		gboolean _tmp30_ = FALSE;
		GtkStack* temp_stack = NULL;
		GtkGrid* _tmp33_;
		GtkWidget* _tmp34_;
		GtkStack* _tmp35_;
		GtkStack* _tmp36_;
		GtkStack* _tmp37_;
		GtkWidget* _tmp38_;
		GtkEntry* _tmp39_;
		GtkEntry* _tmp40_;
		const gchar* _tmp41_;
		const gchar* _tmp42_;
		GtkEntry* _tmp43_;
		_data5_ = g_slice_new0 (Block5Data);
		_data5_->_ref_count_ = 1;
		_data5_->_data4_ = block4_data_ref (_data4_);
		if (no_scores > ((guint) 1)) {
			_tmp30_ = row_count == 1;
		} else {
			_tmp30_ = FALSE;
		}
		if (_tmp30_) {
			GtkHeaderBar* _tmp31_;
			_tmp31_ = self->priv->headerbar;
			gtk_header_bar_set_subtitle (_tmp31_, _ ("Your score is the best!"));
		} else {
			GtkHeaderBar* _tmp32_;
			_tmp32_ = self->priv->headerbar;
			gtk_header_bar_set_subtitle (_tmp32_, _ ("Your score has made the top ten."));
		}
		_tmp33_ = self->priv->grid;
		_tmp34_ = gtk_grid_get_child_at (_tmp33_, 2, row_count);
		_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_stack_get_type (), GtkStack));
		temp_stack = _tmp35_;
		_tmp36_ = temp_stack;
		gtk_stack_set_visible_child_name (_tmp36_, "entry");
		_tmp37_ = temp_stack;
		_tmp38_ = gtk_stack_get_visible_child (_tmp37_);
		_tmp39_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, gtk_entry_get_type (), GtkEntry));
		_data5_->entry = _tmp39_;
		_tmp40_ = _data5_->entry;
		_tmp41_ = games_scores_score_get_user (_data4_->score);
		_tmp42_ = _tmp41_;
		gtk_entry_set_text (_tmp40_, _tmp42_);
		_tmp43_ = _data5_->entry;
		g_signal_connect_data ((GObject*) _tmp43_, "notify::text", (GCallback) ____lambda9__g_object_notify, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
		_g_object_unref0 (temp_stack);
		block5_data_unref (_data5_);
		_data5_ = NULL;
	}
	_tmp44_ = self->priv->grid;
	_tmp45_ = gtk_grid_get_child_at (_tmp44_, 2, row_count);
	_tmp46_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, gtk_stack_get_type (), GtkStack));
	name_stack = _tmp46_;
	_tmp47_ = name_stack;
	_tmp48_ = gtk_stack_get_visible_child (_tmp47_);
	_tmp49_ = _g_object_ref0 (_tmp48_);
	widget = _tmp49_;
	_tmp50_ = name_stack;
	_tmp51_ = gtk_stack_get_visible_child_name (_tmp50_);
	if (g_strcmp0 (_tmp51_, "label") == 0) {
		GtkLabel* user_label = NULL;
		GtkWidget* _tmp52_;
		GtkLabel* _tmp53_;
		GtkLabel* _tmp54_;
		const gchar* _tmp55_;
		const gchar* _tmp56_;
		_tmp52_ = widget;
		_tmp53_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, gtk_label_get_type (), GtkLabel));
		user_label = _tmp53_;
		_tmp54_ = user_label;
		_tmp55_ = games_scores_score_get_user (_data4_->score);
		_tmp56_ = _tmp55_;
		gtk_label_set_text (_tmp54_, _tmp56_);
		_g_object_unref0 (user_label);
	} else {
		GtkEntry* entry = NULL;
		GtkWidget* _tmp57_;
		GtkEntry* _tmp58_;
		GtkEntry* _tmp59_;
		const gchar* _tmp60_;
		const gchar* _tmp61_;
		_tmp57_ = widget;
		_tmp58_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, gtk_entry_get_type (), GtkEntry));
		entry = _tmp58_;
		_tmp59_ = entry;
		_tmp60_ = games_scores_score_get_user (_data4_->score);
		_tmp61_ = _tmp60_;
		gtk_entry_set_text (_tmp59_, _tmp61_);
		_g_object_unref0 (entry);
	}
	_g_object_unref0 (widget);
	_g_object_unref0 (name_stack);
	_g_object_unref0 (score_label);
	_g_object_unref0 (rank_label);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static void
games_scores_dialog_make_remaining_labels_empty (GamesScoresDialog* self,
                                                 gint row_count)
{
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = row_count;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GtkStack* stack = NULL;
				GtkGrid* _tmp8_;
				GtkWidget* _tmp9_;
				GtkStack* _tmp10_;
				GtkLabel* label = NULL;
				GtkStack* _tmp11_;
				GtkWidget* _tmp12_;
				GtkLabel* _tmp13_;
				GtkLabel* _tmp14_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i <= self->priv->rows_to_display)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp2_ = FALSE;
						_tmp2_ = TRUE;
						while (TRUE) {
							GtkLabel* label = NULL;
							GtkGrid* _tmp4_;
							GtkWidget* _tmp5_;
							GtkLabel* _tmp6_;
							GtkLabel* _tmp7_;
							if (!_tmp2_) {
								gint _tmp3_;
								_tmp3_ = j;
								j = _tmp3_ + 1;
							}
							_tmp2_ = FALSE;
							if (!(j <= 1)) {
								break;
							}
							_tmp4_ = self->priv->grid;
							_tmp5_ = gtk_grid_get_child_at (_tmp4_, j, i);
							_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_label_get_type (), GtkLabel));
							label = _tmp6_;
							_tmp7_ = label;
							gtk_label_set_text (_tmp7_, "");
							_g_object_unref0 (label);
						}
					}
				}
				_tmp8_ = self->priv->grid;
				_tmp9_ = gtk_grid_get_child_at (_tmp8_, 2, i);
				_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_stack_get_type (), GtkStack));
				stack = _tmp10_;
				_tmp11_ = stack;
				_tmp12_ = gtk_stack_get_visible_child (_tmp11_);
				_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_label_get_type (), GtkLabel));
				label = _tmp13_;
				_tmp14_ = label;
				gtk_label_set_text (_tmp14_, "");
				_g_object_unref0 (label);
				_g_object_unref0 (stack);
			}
		}
	}
}

static void
games_scores_dialog_class_init (GamesScoresDialogClass * klass,
                                gpointer klass_data)
{
	games_scores_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesScoresDialog_private_offset);
	G_OBJECT_CLASS (klass)->finalize = games_scores_dialog_finalize;
}

static void
games_scores_dialog_instance_init (GamesScoresDialog * self,
                                   gpointer klass)
{
	self->priv = games_scores_dialog_get_instance_private (self);
	self->priv->active_category = NULL;
	self->priv->rows_to_display = 10;
	self->priv->combo = NULL;
	self->priv->category_label = NULL;
	self->priv->headerbar = NULL;
}

static void
games_scores_dialog_finalize (GObject * obj)
{
	GamesScoresDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_SCORES_TYPE_DIALOG, GamesScoresDialog);
	_g_object_unref0 (self->priv->context);
	_g_object_unref0 (self->priv->active_category);
	_g_object_unref0 (self->priv->combo);
	_g_object_unref0 (self->priv->category_label);
	_g_object_unref0 (self->priv->headerbar);
	_g_object_unref0 (self->priv->grid);
	_g_object_unref0 (self->priv->new_high_score);
	_g_object_unref0 (self->priv->scores_active_category);
	G_OBJECT_CLASS (games_scores_dialog_parent_class)->finalize (obj);
}

static GType
games_scores_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesScoresDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_scores_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesScoresDialog), 0, (GInstanceInitFunc) games_scores_dialog_instance_init, NULL };
	GType games_scores_dialog_type_id;
	games_scores_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "GamesScoresDialog", &g_define_type_info, 0);
	GamesScoresDialog_private_offset = g_type_add_instance_private (games_scores_dialog_type_id, sizeof (GamesScoresDialogPrivate));
	return games_scores_dialog_type_id;
}

GType
games_scores_dialog_get_type (void)
{
	static volatile gsize games_scores_dialog_type_id__once = 0;
	if (g_once_init_enter (&games_scores_dialog_type_id__once)) {
		GType games_scores_dialog_type_id;
		games_scores_dialog_type_id = games_scores_dialog_get_type_once ();
		g_once_init_leave (&games_scores_dialog_type_id__once, games_scores_dialog_type_id);
	}
	return games_scores_dialog_type_id__once;
}

