/*
 * Copyright (C) 2016 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */


/* Instructions, enums and structures for XE2.
 *
 * This file has been generated, do not hand edit.
 */

#ifndef GFX20_XE2_PACK_H
#define GFX20_XE2_PACK_H

#ifndef __OPENCL_VERSION__
#include <stdio.h>
#include "util/bitpack_helpers.h"
#include "genX_helpers.h"
#else
#include "genX_cl_helpers.h"
#endif


enum GFX20_3D_Color_Buffer_Blend_Factor {
   BLENDFACTOR_ONE                      =      1,
   BLENDFACTOR_SRC_COLOR                =      2,
   BLENDFACTOR_SRC_ALPHA                =      3,
   BLENDFACTOR_DST_ALPHA                =      4,
   BLENDFACTOR_DST_COLOR                =      5,
   BLENDFACTOR_SRC_ALPHA_SATURATE       =      6,
   BLENDFACTOR_CONST_COLOR              =      7,
   BLENDFACTOR_CONST_ALPHA              =      8,
   BLENDFACTOR_SRC1_COLOR               =      9,
   BLENDFACTOR_SRC1_ALPHA               =     10,
   BLENDFACTOR_ZERO                     =     17,
   BLENDFACTOR_INV_SRC_COLOR            =     18,
   BLENDFACTOR_INV_SRC_ALPHA            =     19,
   BLENDFACTOR_INV_DST_ALPHA            =     20,
   BLENDFACTOR_INV_DST_COLOR            =     21,
   BLENDFACTOR_INV_CONST_COLOR          =     23,
   BLENDFACTOR_INV_CONST_ALPHA          =     24,
   BLENDFACTOR_INV_SRC1_COLOR           =     25,
   BLENDFACTOR_INV_SRC1_ALPHA           =     26,
};

enum GFX20_3D_Color_Buffer_Blend_Function {
   BLENDFUNCTION_ADD                    =      0,
   BLENDFUNCTION_SUBTRACT               =      1,
   BLENDFUNCTION_REVERSE_SUBTRACT       =      2,
   BLENDFUNCTION_MIN                    =      3,
   BLENDFUNCTION_MAX                    =      4,
};

enum GFX20_3D_Compare_Function {
   COMPAREFUNCTION_ALWAYS               =      0,
   COMPAREFUNCTION_NEVER                =      1,
   COMPAREFUNCTION_LESS                 =      2,
   COMPAREFUNCTION_EQUAL                =      3,
   COMPAREFUNCTION_LEQUAL               =      4,
   COMPAREFUNCTION_GREATER              =      5,
   COMPAREFUNCTION_NOTEQUAL             =      6,
   COMPAREFUNCTION_GEQUAL               =      7,
};

enum GFX20_3D_Logic_Op_Function {
   LOGICOP_CLEAR                        =      0,
   LOGICOP_NOR                          =      1,
   LOGICOP_AND_INVERTED                 =      2,
   LOGICOP_COPY_INVERTED                =      3,
   LOGICOP_AND_REVERSE                  =      4,
   LOGICOP_INVERT                       =      5,
   LOGICOP_XOR                          =      6,
   LOGICOP_NAND                         =      7,
   LOGICOP_AND                          =      8,
   LOGICOP_EQUIV                        =      9,
   LOGICOP_NOOP                         =     10,
   LOGICOP_OR_INVERTED                  =     11,
   LOGICOP_COPY                         =     12,
   LOGICOP_OR_REVERSE                   =     13,
   LOGICOP_OR                           =     14,
   LOGICOP_SET                          =     15,
};

enum GFX20_3D_Prim_Topo_Type {
   _3DPRIM_POINTLIST                    =      1,
   _3DPRIM_LINELIST                     =      2,
   _3DPRIM_LINESTRIP                    =      3,
   _3DPRIM_TRILIST                      =      4,
   _3DPRIM_TRISTRIP                     =      5,
   _3DPRIM_TRIFAN                       =      6,
   _3DPRIM_QUADLIST                     =      7,
   _3DPRIM_QUADSTRIP                    =      8,
   _3DPRIM_LINELIST_ADJ                 =      9,
   _3DPRIM_LINESTRIP_ADJ                =     10,
   _3DPRIM_TRILIST_ADJ                  =     11,
   _3DPRIM_TRISTRIP_ADJ                 =     12,
   _3DPRIM_TRISTRIP_REVERSE             =     13,
   _3DPRIM_POLYGON                      =     14,
   _3DPRIM_RECTLIST                     =     15,
   _3DPRIM_LINELOOP                     =     16,
   _3DPRIM_POINTLIST_BF                 =     17,
   _3DPRIM_LINESTRIP_CONT               =     18,
   _3DPRIM_LINESTRIP_BF                 =     19,
   _3DPRIM_LINESTRIP_CONT_BF            =     20,
   _3DPRIM_TRIFAN_NOSTIPPLE             =     22,
   _3DPRIM_PATCHLIST_1                  =     32,
   _3DPRIM_PATCHLIST_2                  =     33,
   _3DPRIM_PATCHLIST_3                  =     34,
   _3DPRIM_PATCHLIST_4                  =     35,
   _3DPRIM_PATCHLIST_5                  =     36,
   _3DPRIM_PATCHLIST_6                  =     37,
   _3DPRIM_PATCHLIST_7                  =     38,
   _3DPRIM_PATCHLIST_8                  =     39,
   _3DPRIM_PATCHLIST_9                  =     40,
   _3DPRIM_PATCHLIST_10                 =     41,
   _3DPRIM_PATCHLIST_11                 =     42,
   _3DPRIM_PATCHLIST_12                 =     43,
   _3DPRIM_PATCHLIST_13                 =     44,
   _3DPRIM_PATCHLIST_14                 =     45,
   _3DPRIM_PATCHLIST_15                 =     46,
   _3DPRIM_PATCHLIST_16                 =     47,
   _3DPRIM_PATCHLIST_17                 =     48,
   _3DPRIM_PATCHLIST_18                 =     49,
   _3DPRIM_PATCHLIST_19                 =     50,
   _3DPRIM_PATCHLIST_20                 =     51,
   _3DPRIM_PATCHLIST_21                 =     52,
   _3DPRIM_PATCHLIST_22                 =     53,
   _3DPRIM_PATCHLIST_23                 =     54,
   _3DPRIM_PATCHLIST_24                 =     55,
   _3DPRIM_PATCHLIST_25                 =     56,
   _3DPRIM_PATCHLIST_26                 =     57,
   _3DPRIM_PATCHLIST_27                 =     58,
   _3DPRIM_PATCHLIST_28                 =     59,
   _3DPRIM_PATCHLIST_29                 =     60,
   _3DPRIM_PATCHLIST_30                 =     61,
   _3DPRIM_PATCHLIST_31                 =     62,
   _3DPRIM_PATCHLIST_32                 =     63,
};

enum GFX20_3D_Stencil_Operation {
   STENCILOP_KEEP                       =      0,
   STENCILOP_ZERO                       =      1,
   STENCILOP_REPLACE                    =      2,
   STENCILOP_INCRSAT                    =      3,
   STENCILOP_DECRSAT                    =      4,
   STENCILOP_INCR                       =      5,
   STENCILOP_DECR                       =      6,
   STENCILOP_INVERT                     =      7,
};

enum GFX20_3D_Vertex_Component_Control {
   VFCOMP_NOSTORE                       =      0,
   VFCOMP_STORE_SRC                     =      1,
   VFCOMP_STORE_0                       =      2,
   VFCOMP_STORE_1_FP                    =      3,
   VFCOMP_STORE_1_INT                   =      4,
   VFCOMP_STORE_PID                     =      7,
};

enum GFX20_Atomic_OPCODE {
   MI_ATOMIC_OP_AND                     =      1,
   MI_ATOMIC_OP_OR                      =      2,
   MI_ATOMIC_OP_XOR                     =      3,
   MI_ATOMIC_OP_MOVE                    =      4,
   MI_ATOMIC_OP_INC                     =      5,
   MI_ATOMIC_OP_DEC                     =      6,
   MI_ATOMIC_OP_ADD                     =      7,
   MI_ATOMIC_OP_SUB                     =      8,
   MI_ATOMIC_OP_RSUB                    =      9,
   MI_ATOMIC_OP_IMAX                    =     10,
   MI_ATOMIC_OP_IMIN                    =     11,
   MI_ATOMIC_OP_UMAX                    =     12,
   MI_ATOMIC_OP_UMIN                    =     13,
   MI_ATOMIC_OP_CMP_WR                  =     14,
   MI_ATOMIC_OP_PREDEC                  =     15,
   MI_ATOMIC_OP_AND8B                   =     33,
   MI_ATOMIC_OP_OR8B                    =     34,
   MI_ATOMIC_OP_XOR8B                   =     35,
   MI_ATOMIC_OP_MOVE8B                  =     36,
   MI_ATOMIC_OP_INC8B                   =     37,
   MI_ATOMIC_OP_DEC8B                   =     38,
   MI_ATOMIC_OP_ADD8B                   =     39,
   MI_ATOMIC_OP_SUB8B                   =     40,
   MI_ATOMIC_OP_RSUB8B                  =     41,
   MI_ATOMIC_OP_IMAX8B                  =     42,
   MI_ATOMIC_OP_IMIN8B                  =     43,
   MI_ATOMIC_OP_UMAX8B                  =     44,
   MI_ATOMIC_OP_UMIN8B                  =     45,
   MI_ATOMIC_OP_CMP_WR8B                =     46,
   MI_ATOMIC_OP_PREDEC8B                =     47,
   MI_ATOMIC_OP_CMP_WR16B               =     78,
};

enum GFX20_Attribute_Component_Format {
   ACF_DISABLED                         =      0,
   ACF_XY                               =      1,
   ACF_XYZ                              =      2,
   ACF_XYZW                             =      3,
};

enum GFX20_FRAME_BITRATE_UNITS {
   FRAME_BR__32BYTE_UNITS               =      0,
   FRAME_BR__4KBYTE_UNITS               =      1,
};

enum GFX20_L1_CACHE_CONTROL {
   L1CC_WBP                             =      0,
   L1CC_UC                              =      1,
   L1CC_WB                              =      2,
   L1CC_WT                              =      3,
   L1CC_WS                              =      4,
};

enum GFX20_PREF_SLM_ALLOCATION_SIZE {
   SLM_ENCODES_0K                       =      0,
   SLM_ENCODES_16K                      =      1,
   SLM_ENCODES_32K                      =      2,
   SLM_ENCODES_64K                      =      3,
   SLM_ENCODES_96K                      =      4,
   SLM_ENCODES_128K                     =      5,
   SLM_ENCODES_160K                     =      6,
   SLM_ENCODES_192K                     =      7,
   SLM_ENCODES_224K                     =      8,
   SLM_ENCODES_256K                     =      9,
   SLM_ENCODES_384K                     =     10,
};

enum GFX20_RESOURCE_BARRIER_STAGE {
   RESOURCE_BARRIER_STAGE_NONE          =      0,
   RESOURCE_BARRIER_STAGE_TOP           =      1,
   RESOURCE_BARRIER_STAGE_COLOR         =      2,
   RESOURCE_BARRIER_STAGE_GPGPU         =      4,
   RESOURCE_BARRIER_STAGE_COLORANDCOMPUTE =      6,
   RESOURCE_BARRIER_STAGE_GEOM          =     16,
   RESOURCE_BARRIER_STAGE_GEOMETRYANDCOMPUTE =     20,
   RESOURCE_BARRIER_STAGE_RASTER        =     32,
   RESOURCE_BARRIER_STAGE_DEPTH         =     64,
   RESOURCE_BARRIER_STAGE_PIXEL         =    128,
};

enum GFX20_RESOURCE_BARRIER_TYPE {
   RESOURCE_BARRIER_TYPE_IMMEDIATE      =      0,
   RESOURCE_BARRIER_TYPE_SIGNAL         =      1,
   RESOURCE_BARRIER_TYPE_WAIT           =      2,
   RESOURCE_BARRIER_TYPE_UAV            =      3,
};

enum GFX20_STATE_SURFACE_TYPE {
   SURFTYPE_1D                          =      0,
   SURFTYPE_2D                          =      1,
   SURFTYPE_3D                          =      2,
   SURFTYPE_CUBE                        =      3,
   SURFTYPE_BUFFER                      =      4,
   SURFTYPE_RES5                        =      5,
   SURFTYPE_SCRATCH                     =      6,
   SURFTYPE_NULL                        =      7,
};

enum GFX20_ShaderChannelSelect {
   SCS_ZERO                             =      0,
   SCS_ONE                              =      1,
   SCS_RED                              =      4,
   SCS_GREEN                            =      5,
   SCS_BLUE                             =      6,
   SCS_ALPHA                            =      7,
};

enum GFX20_TextureCoordinateMode {
   TCM_WRAP                             =      0,
   TCM_MIRROR                           =      1,
   TCM_CLAMP                            =      2,
   TCM_CUBE                             =      3,
   TCM_CLAMP_BORDER                     =      4,
   TCM_MIRROR_ONCE                      =      5,
   TCM_HALF_BORDER                      =      6,
   TCM_MIRROR_101                       =      7,
};

enum GFX20_UNIFIED_COMPRESSION_FORMAT {
   CMF_R8                               =      0,
   CMF_R8_G8                            =      1,
   CMF_R8_G8_B8_A8                      =      2,
   CMF_R10_G10_B10_A2                   =      3,
   CMF_R11_G11_B10                      =      4,
   CMF_R16                              =      5,
   CMF_R16_G16                          =      6,
   CMF_R16_G16_B16_A16                  =      7,
   CMF_R32                              =      8,
   CMF_R32_G32                          =      9,
   CMF_R32_G32_B32_A32                  =     10,
   CMF_Y16_U16_Y16_V16                  =     11,
   CMF_ML8                              =     15,
};

enum GFX20_WRAP_SHORTEST_ENABLE {
   WSE_X                                =      1,
   WSE_Y                                =      2,
   WSE_XY                               =      3,
   WSE_Z                                =      4,
   WSE_XZ                               =      5,
   WSE_YZ                               =      6,
   WSE_XYZ                              =      7,
   WSE_W                                =      8,
   WSE_XW                               =      9,
   WSE_YW                               =     10,
   WSE_XYW                              =     11,
   WSE_ZW                               =     12,
   WSE_XZW                              =     13,
   WSE_YZW                              =     14,
   WSE_XYZW                             =     15,
};

#define GFX20_3DSTATE_CONSTANT_ALL_DATA_length      2
struct GFX20_3DSTATE_CONSTANT_ALL_DATA {
   uint32_t                             ConstantBufferReadLength;
   __gen_address_type                   PointerToConstantBuffer;
};

static inline __attribute__((always_inline)) void
GFX20_3DSTATE_CONSTANT_ALL_DATA_pack(__attribute__((unused)) __gen_user_data *data,
                                     __attribute__((unused)) void * restrict dst,
                                     __attribute__((unused)) const struct GFX20_3DSTATE_CONSTANT_ALL_DATA * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   const uint64_t v0 =
      util_bitpack_uint(values->ConstantBufferReadLength, 0, 4);
   const uint64_t v0_address =
      __gen_address(data, &dw[0], values->PointerToConstantBuffer, v0, 5, 63);
   dw[0] = v0_address;
   dw[1] = (v0_address >> 32) | (v0 >> 32);
}

#define GFX20_3DSTATE_CONSTANT_BODY_length     10
struct GFX20_3DSTATE_CONSTANT_BODY {
   uint32_t                             ReadLength[4];
   __gen_address_type                   Buffer[4];
};

static inline __attribute__((always_inline)) void
GFX20_3DSTATE_CONSTANT_BODY_pack(__attribute__((unused)) __gen_user_data *data,
                                 __attribute__((unused)) void * restrict dst,
                                 __attribute__((unused)) const struct GFX20_3DSTATE_CONSTANT_BODY * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->ReadLength[0], 0, 15) |
      util_bitpack_uint(values->ReadLength[1], 16, 31);

   dw[1] =
      util_bitpack_uint(values->ReadLength[2], 0, 15) |
      util_bitpack_uint(values->ReadLength[3], 16, 31);

   const uint64_t v2_address =
      __gen_address(data, &dw[2], values->Buffer[0], 0, 5, 63);
   dw[2] = v2_address;
   dw[3] = v2_address >> 32;

   const uint64_t v4_address =
      __gen_address(data, &dw[4], values->Buffer[1], 0, 5, 63);
   dw[4] = v4_address;
   dw[5] = v4_address >> 32;

   const uint64_t v6_address =
      __gen_address(data, &dw[6], values->Buffer[2], 0, 5, 63);
   dw[6] = v6_address;
   dw[7] = v6_address >> 32;

   const uint64_t v8_address =
      __gen_address(data, &dw[8], values->Buffer[3], 0, 5, 63);
   dw[8] = v8_address;
   dw[9] = v8_address >> 32;
}

#define GFX20_3DSTATE_SO_BUFFER_INDEX_BODY_length      7
struct GFX20_3DSTATE_SO_BUFFER_INDEX_BODY {
   bool                                 StreamOutputBufferOffsetAddressEnable;
   bool                                 StreamOffsetWriteEnable;
   uint32_t                             MOCS;
   bool                                 SOBufferEnable;
   __gen_address_type                   SurfaceBaseAddress;
   uint32_t                             SurfaceSize;
   __gen_address_type                   StreamOutputBufferOffsetAddress;
   uint32_t                             StreamOffset;
};

static inline __attribute__((always_inline)) void
GFX20_3DSTATE_SO_BUFFER_INDEX_BODY_pack(__attribute__((unused)) __gen_user_data *data,
                                        __attribute__((unused)) void * restrict dst,
                                        __attribute__((unused)) const struct GFX20_3DSTATE_SO_BUFFER_INDEX_BODY * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->StreamOutputBufferOffsetAddressEnable, 20, 20) |
      util_bitpack_uint(values->StreamOffsetWriteEnable, 21, 21) |
      util_bitpack_uint_nonzero(values->MOCS, 22, 28) |
      util_bitpack_uint(values->SOBufferEnable, 31, 31);

   const uint64_t v1_address =
      __gen_address(data, &dw[1], values->SurfaceBaseAddress, 0, 2, 47);
   dw[1] = v1_address;
   dw[2] = v1_address >> 32;

   dw[3] =
      util_bitpack_uint(values->SurfaceSize, 0, 29);

   const uint64_t v4_address =
      __gen_address(data, &dw[4], values->StreamOutputBufferOffsetAddress, 0, 2, 47);
   dw[4] = v4_address;
   dw[5] = v4_address >> 32;

   dw[6] =
      util_bitpack_uint(values->StreamOffset, 0, 31);
}

#define GFX20_BINDING_TABLE_EDIT_ENTRY_length      1
struct GFX20_BINDING_TABLE_EDIT_ENTRY {
   uint64_t                             SurfaceStatePointer;
   uint32_t                             BindingTableIndex;
};

static inline __attribute__((always_inline)) void
GFX20_BINDING_TABLE_EDIT_ENTRY_pack(__attribute__((unused)) __gen_user_data *data,
                                    __attribute__((unused)) void * restrict dst,
                                    __attribute__((unused)) const struct GFX20_BINDING_TABLE_EDIT_ENTRY * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      __gen_offset(values->SurfaceStatePointer, 0, 15) |
      util_bitpack_uint(values->BindingTableIndex, 16, 23);
}

#define GFX20_BINDING_TABLE_STATE_length       1
struct GFX20_BINDING_TABLE_STATE {
   uint64_t                             SurfaceStatePointer;
};

static inline __attribute__((always_inline)) void
GFX20_BINDING_TABLE_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                               __attribute__((unused)) void * restrict dst,
                               __attribute__((unused)) const struct GFX20_BINDING_TABLE_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      __gen_offset(values->SurfaceStatePointer, 6, 31);
}

#define GFX20_BLEND_STATE_ENTRY_length         2
struct GFX20_BLEND_STATE_ENTRY {
   bool                                 WriteDisableBlue;
   bool                                 WriteDisableGreen;
   bool                                 WriteDisableRed;
   bool                                 WriteDisableAlpha;
   enum GFX20_3D_Color_Buffer_Blend_Function AlphaBlendFunction;
   enum GFX20_3D_Color_Buffer_Blend_Factor DestinationAlphaBlendFactor;
   enum GFX20_3D_Color_Buffer_Blend_Factor SourceAlphaBlendFactor;
   enum GFX20_3D_Color_Buffer_Blend_Function ColorBlendFunction;
   enum GFX20_3D_Color_Buffer_Blend_Factor DestinationBlendFactor;
   enum GFX20_3D_Color_Buffer_Blend_Factor SourceBlendFactor;
   bool                                 ColorBufferBlendEnable;
   bool                                 PostBlendColorClampEnable;
   bool                                 PreBlendColorClampEnable;
   uint32_t                             ColorClampRange;
#define COLORCLAMP_UNORM                         0
#define COLORCLAMP_SNORM                         1
#define COLORCLAMP_RTFORMAT                      2
   bool                                 PreBlendSourceOnlyClampEnable;
   enum GFX20_3D_Logic_Op_Function      LogicOpFunction;
   bool                                 LogicOpEnable;
};

static inline __attribute__((always_inline)) void
GFX20_BLEND_STATE_ENTRY_pack(__attribute__((unused)) __gen_user_data *data,
                             __attribute__((unused)) void * restrict dst,
                             __attribute__((unused)) const struct GFX20_BLEND_STATE_ENTRY * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->WriteDisableBlue, 0, 0) |
      util_bitpack_uint(values->WriteDisableGreen, 1, 1) |
      util_bitpack_uint(values->WriteDisableRed, 2, 2) |
      util_bitpack_uint(values->WriteDisableAlpha, 3, 3) |
      util_bitpack_uint(values->AlphaBlendFunction, 5, 7) |
      util_bitpack_uint(values->DestinationAlphaBlendFactor, 8, 12) |
      util_bitpack_uint(values->SourceAlphaBlendFactor, 13, 17) |
      util_bitpack_uint(values->ColorBlendFunction, 18, 20) |
      util_bitpack_uint(values->DestinationBlendFactor, 21, 25) |
      util_bitpack_uint(values->SourceBlendFactor, 26, 30) |
      util_bitpack_uint(values->ColorBufferBlendEnable, 31, 31);

   dw[1] =
      util_bitpack_uint(values->PostBlendColorClampEnable, 0, 0) |
      util_bitpack_uint(values->PreBlendColorClampEnable, 1, 1) |
      util_bitpack_uint(values->ColorClampRange, 2, 3) |
      util_bitpack_uint(values->PreBlendSourceOnlyClampEnable, 4, 4) |
      util_bitpack_uint(values->LogicOpFunction, 27, 30) |
      util_bitpack_uint(values->LogicOpEnable, 31, 31);
}

#define GFX20_BLEND_STATE_length               1
struct GFX20_BLEND_STATE {
   uint32_t                             YDitherOffset;
   uint32_t                             XDitherOffset;
   bool                                 ColorDitherEnable;
   enum GFX20_3D_Compare_Function       AlphaTestFunction;
   bool                                 AlphaTestEnable;
   bool                                 AlphaToCoverageDitherEnable;
   bool                                 AlphaToOneEnable;
   bool                                 IndependentAlphaBlendEnable;
   bool                                 AlphaToCoverageEnable;
   /* variable length fields follow */
};

static inline __attribute__((always_inline)) void
GFX20_BLEND_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                       __attribute__((unused)) void * restrict dst,
                       __attribute__((unused)) const struct GFX20_BLEND_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->YDitherOffset, 19, 20) |
      util_bitpack_uint(values->XDitherOffset, 21, 22) |
      util_bitpack_uint(values->ColorDitherEnable, 23, 23) |
      util_bitpack_uint(values->AlphaTestFunction, 24, 26) |
      util_bitpack_uint(values->AlphaTestEnable, 27, 27) |
      util_bitpack_uint(values->AlphaToCoverageDitherEnable, 28, 28) |
      util_bitpack_uint(values->AlphaToOneEnable, 29, 29) |
      util_bitpack_uint(values->IndependentAlphaBlendEnable, 30, 30) |
      util_bitpack_uint(values->AlphaToCoverageEnable, 31, 31);
}

#define GFX20_CC_VIEWPORT_length               2
struct GFX20_CC_VIEWPORT {
   float                                MinimumDepth;
   float                                MaximumDepth;
};

static inline __attribute__((always_inline)) void
GFX20_CC_VIEWPORT_pack(__attribute__((unused)) __gen_user_data *data,
                       __attribute__((unused)) void * restrict dst,
                       __attribute__((unused)) const struct GFX20_CC_VIEWPORT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_float(values->MinimumDepth);

   dw[1] =
      util_bitpack_float(values->MaximumDepth);
}

#define GFX20_CHROMA_FILTER_COEFFICIENTS_ARRAY_length      2
struct GFX20_CHROMA_FILTER_COEFFICIENTS_ARRAY {
   float                                Table1XFilterCoefficientn2;
   float                                Table1YFilterCoefficientn2;
   float                                Table1XFilterCoefficientn3;
   float                                Table1YFilterCoefficientn3;
   float                                Table1XFilterCoefficientn4;
   float                                Table1YFilterCoefficientn4;
   float                                Table1XFilterCoefficientn5;
   float                                Table1YFilterCoefficientn5;
};

static inline __attribute__((always_inline)) void
GFX20_CHROMA_FILTER_COEFFICIENTS_ARRAY_pack(__attribute__((unused)) __gen_user_data *data,
                                            __attribute__((unused)) void * restrict dst,
                                            __attribute__((unused)) const struct GFX20_CHROMA_FILTER_COEFFICIENTS_ARRAY * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_sfixed(values->Table1XFilterCoefficientn2, 0, 7, 6) |
      util_bitpack_sfixed(values->Table1YFilterCoefficientn2, 8, 15, 6) |
      util_bitpack_sfixed(values->Table1XFilterCoefficientn3, 16, 23, 6) |
      util_bitpack_sfixed(values->Table1YFilterCoefficientn3, 24, 31, 6);

   dw[1] =
      util_bitpack_sfixed(values->Table1XFilterCoefficientn4, 0, 7, 6) |
      util_bitpack_sfixed(values->Table1YFilterCoefficientn4, 8, 15, 6) |
      util_bitpack_sfixed(values->Table1XFilterCoefficientn5, 16, 23, 6) |
      util_bitpack_sfixed(values->Table1YFilterCoefficientn5, 24, 31, 6);
}

#define GFX20_COLOR_CALC_STATE_length          6
struct GFX20_COLOR_CALC_STATE {
   uint32_t                             AlphaTestFormat;
#define ALPHATEST_UNORM8                         0
#define ALPHATEST_FLOAT32                        1
   bool                                 RoundDisableFunctionDisable;
   uint32_t                             AlphaReferenceValueAsUNORM8;
   float                                AlphaReferenceValueAsFLOAT32;
   float                                BlendConstantColorRed;
   float                                BlendConstantColorGreen;
   float                                BlendConstantColorBlue;
   float                                BlendConstantColorAlpha;
};

static inline __attribute__((always_inline)) void
GFX20_COLOR_CALC_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                            __attribute__((unused)) void * restrict dst,
                            __attribute__((unused)) const struct GFX20_COLOR_CALC_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->AlphaTestFormat, 0, 0) |
      util_bitpack_uint(values->RoundDisableFunctionDisable, 15, 15);

   dw[1] =
      util_bitpack_uint(values->AlphaReferenceValueAsUNORM8, 0, 31) |
      util_bitpack_float(values->AlphaReferenceValueAsFLOAT32);

   dw[2] =
      util_bitpack_float(values->BlendConstantColorRed);

   dw[3] =
      util_bitpack_float(values->BlendConstantColorGreen);

   dw[4] =
      util_bitpack_float(values->BlendConstantColorBlue);

   dw[5] =
      util_bitpack_float(values->BlendConstantColorAlpha);
}

#define GFX20_INTERFACE_DESCRIPTOR_DATA_length      8
struct GFX20_INTERFACE_DESCRIPTOR_DATA {
   uint64_t                             KernelStartPointer;
   bool                                 SoftwareExceptionEnable;
   bool                                 IllegalOpcodeExceptionEnable;
   uint32_t                             FloatingPointMode;
#define IEEE754                                  0
#define Alternate                                1
   bool                                 SingleProgramFlow;
   uint32_t                             DenormMode;
#define Ftz                                      0
#define SetByKernel                              1
   bool                                 ThreadPreemption;
   uint32_t                             SamplerCount;
#define Nosamplersused                           0
#define Between1and4samplersused                 1
#define Between5and8samplersused                 2
#define Between9and12samplersused                3
#define Between13and16samplersused               4
   uint64_t                             SamplerStatePointer;
   uint32_t                             BindingTableEntryCount;
   uint64_t                             BindingTablePointer;
   uint32_t                             NumberofThreadsinGPGPUThreadGroup;
   bool                                 Threadgroupforwardprogressguarantee;
   uint32_t                             SharedLocalMemorySize;
#define Encodes0K                                0
#define Encodes1K                                1
#define Encodes2K                                2
#define Encodes4K                                3
#define Encodes8K                                4
#define Encodes16K                               5
#define Encodes32K                               6
#define Encodes64K                               7
#define Encodes96K                               10
#define Encodes128K                              11
#define Encodes192K                              12
#define Encodes256K                              13
#define Encodes384K                              14
   uint32_t                             RoundingMode;
#define RTNE                                     0
#define RU                                       1
#define RD                                       2
#define RTZ                                      3
   uint32_t                             ThreadGroupDispatchSize;
#define TGsize8                                  0
#define TGsize4                                  1
#define TGsize2                                  2
#define TGsize1                                  3
   uint32_t                             NumberOfBarriers;
#define BARRIER_SIZE_NONE                        0
#define BARRIER_SIZE_B1                          1
#define BARRIER_SIZE_B2                          2
#define BARRIER_SIZE_B4                          3
#define BARRIER_SIZE_B8                          4
#define BARRIER_SIZE_B16                         5
#define BARRIER_SIZE_B24                         6
#define BARRIER_SIZE_B32                         7
   uint32_t                             BTDMode;
   enum GFX20_PREF_SLM_ALLOCATION_SIZE  PreferredSLMAllocationSize;
};

static inline __attribute__((always_inline)) void
GFX20_INTERFACE_DESCRIPTOR_DATA_pack(__attribute__((unused)) __gen_user_data *data,
                                     __attribute__((unused)) void * restrict dst,
                                     __attribute__((unused)) const struct GFX20_INTERFACE_DESCRIPTOR_DATA * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      __gen_offset(values->KernelStartPointer, 6, 31);

   dw[1] = 0;

   dw[2] =
      util_bitpack_uint(values->SoftwareExceptionEnable, 7, 7) |
      util_bitpack_uint(values->IllegalOpcodeExceptionEnable, 13, 13) |
      util_bitpack_uint(values->FloatingPointMode, 16, 16) |
      util_bitpack_uint(values->SingleProgramFlow, 18, 18) |
      util_bitpack_uint(values->DenormMode, 19, 19) |
      util_bitpack_uint(values->ThreadPreemption, 20, 20);

   dw[3] =
      util_bitpack_uint(values->SamplerCount, 2, 4) |
      __gen_offset(values->SamplerStatePointer, 5, 31);

   dw[4] =
      util_bitpack_uint(values->BindingTableEntryCount, 0, 4) |
      __gen_offset(values->BindingTablePointer, 5, 20);

   dw[5] =
      util_bitpack_uint(values->NumberofThreadsinGPGPUThreadGroup, 0, 9) |
      util_bitpack_uint(values->Threadgroupforwardprogressguarantee, 13, 13) |
      util_bitpack_uint(values->SharedLocalMemorySize, 16, 20) |
      util_bitpack_uint(values->RoundingMode, 22, 23) |
      util_bitpack_uint(values->ThreadGroupDispatchSize, 26, 27) |
      util_bitpack_uint(values->NumberOfBarriers, 28, 30) |
      util_bitpack_uint(values->BTDMode, 31, 31);

   dw[6] = 0;

   dw[7] =
      util_bitpack_uint(values->PreferredSLMAllocationSize, 0, 3);
}

#define GFX20_POSTSYNC_DATA_length             5
struct GFX20_POSTSYNC_DATA {
   uint32_t                             Operation;
#define NoWrite                                  0
#define WriteImmediateData                       1
#define WriteTimestamp                           3
   bool                                 HDCPipelineFlush;
   uint32_t                             MOCS;
   bool                                 SystemMemoryFenceRequest;
   bool                                 DataportSubsliceCacheFlush;
   __gen_address_type                   DestinationAddress;
   uint64_t                             ImmediateData;
};

static inline __attribute__((always_inline)) void
GFX20_POSTSYNC_DATA_pack(__attribute__((unused)) __gen_user_data *data,
                         __attribute__((unused)) void * restrict dst,
                         __attribute__((unused)) const struct GFX20_POSTSYNC_DATA * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->Operation, 0, 1) |
      util_bitpack_uint(values->HDCPipelineFlush, 2, 2) |
      util_bitpack_uint_nonzero(values->MOCS, 4, 10) |
      util_bitpack_uint(values->SystemMemoryFenceRequest, 11, 11) |
      util_bitpack_uint(values->DataportSubsliceCacheFlush, 12, 12);

   const uint64_t v1_address =
      __gen_address(data, &dw[1], values->DestinationAddress, 0, 0, 63);
   dw[1] = v1_address;
   dw[2] = v1_address >> 32;

   const uint64_t v3 =
      util_bitpack_uint(values->ImmediateData, 0, 63);
   dw[3] = v3;
   dw[4] = v3 >> 32;
}

#define GFX20_COMPUTE_WALKER_BODY_length      39
struct GFX20_COMPUTE_WALKER_BODY {
   uint32_t                             IndirectDataLength;
   bool                                 L3prefetchdisable;
   uint32_t                             PartitionDispatchParameter;
   uint32_t                             PartitionType;
#define PartitionX                               1
#define PartitionY                               2
#define PartitionZ                               3
   uint64_t                             IndirectDataStartAddress;
   uint32_t                             ComputeDispatchAllwalkerEnable;
#define Disabled                                 0
#define Enabled                                  1
   uint32_t                             DispatchWalkOrder;
#define LinearWalk                               0
#define Yorderwalk                               1
   uint32_t                             MessageSIMD;
#define SIMT16                                   1
#define SIMT32                                   2
   uint32_t                             TileLayout;
#define Linear                                   0
#define TileY32bpe                               1
#define TileY64bpe                               2
#define TileY128bpe                              3
   uint32_t                             WalkOrder;
#define Walk012                                  0
#define Walk021                                  1
#define Walk102                                  2
#define Walk120                                  3
#define Walk201                                  4
#define Walk210                                  5
   bool                                 EmitInlineParameter;
   uint32_t                             EmitLocal;
#define EmitNone                                 0
#define EmitX                                    1
#define EmitXY                                   3
#define EmitXYZ                                  7
   bool                                 GenerateLocalID;
   uint32_t                             SIMDSize;
#define SIMT16                                   1
#define SIMT32                                   2
   uint32_t                             ExecutionMask;
   uint32_t                             LocalXMaximum;
   uint32_t                             LocalYMaximum;
   uint32_t                             LocalZMaximum;
   uint32_t                             ThreadGroupIDXDimension;
   uint32_t                             ThreadGroupIDYDimension;
   uint32_t                             ThreadGroupIDZDimension;
   uint32_t                             ThreadGroupIDStartingX;
   uint32_t                             ThreadGroupIDStartingY;
   uint32_t                             ThreadGroupIDStartingZ;
   uint32_t                             PartitionID;
   uint32_t                             PartitionSize;
   uint32_t                             PreemptX;
   uint32_t                             PreemptY;
   uint32_t                             PreemptZ;
   uint32_t                             WalkerID;
   uint32_t                             OverdispatchTGcount;
   struct GFX20_INTERFACE_DESCRIPTOR_DATA InterfaceDescriptor;
   struct GFX20_POSTSYNC_DATA           PostSync;
   uint32_t                             InlineData[8];
};

static inline __attribute__((always_inline)) void
GFX20_COMPUTE_WALKER_BODY_pack(__attribute__((unused)) __gen_user_data *data,
                               __attribute__((unused)) void * restrict dst,
                               __attribute__((unused)) const struct GFX20_COMPUTE_WALKER_BODY * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] = 0;

   dw[1] =
      util_bitpack_uint(values->IndirectDataLength, 0, 16) |
      util_bitpack_uint(values->L3prefetchdisable, 17, 17) |
      util_bitpack_uint(values->PartitionDispatchParameter, 18, 29) |
      util_bitpack_uint(values->PartitionType, 30, 31);

   dw[2] =
      __gen_offset(values->IndirectDataStartAddress, 6, 31);

   dw[3] =
      util_bitpack_uint(values->ComputeDispatchAllwalkerEnable, 0, 0) |
      util_bitpack_uint(values->DispatchWalkOrder, 5, 6) |
      util_bitpack_uint(values->MessageSIMD, 17, 18) |
      util_bitpack_uint(values->TileLayout, 19, 21) |
      util_bitpack_uint(values->WalkOrder, 22, 24) |
      util_bitpack_uint(values->EmitInlineParameter, 25, 25) |
      util_bitpack_uint(values->EmitLocal, 26, 28) |
      util_bitpack_uint(values->GenerateLocalID, 29, 29) |
      util_bitpack_uint(values->SIMDSize, 30, 31);

   dw[4] =
      util_bitpack_uint(values->ExecutionMask, 0, 31);

   dw[5] =
      util_bitpack_uint(values->LocalXMaximum, 0, 9) |
      util_bitpack_uint(values->LocalYMaximum, 10, 19) |
      util_bitpack_uint(values->LocalZMaximum, 20, 29);

   dw[6] =
      util_bitpack_uint(values->ThreadGroupIDXDimension, 0, 31);

   dw[7] =
      util_bitpack_uint(values->ThreadGroupIDYDimension, 0, 31);

   dw[8] =
      util_bitpack_uint(values->ThreadGroupIDZDimension, 0, 31);

   dw[9] =
      util_bitpack_uint(values->ThreadGroupIDStartingX, 0, 31);

   dw[10] =
      util_bitpack_uint(values->ThreadGroupIDStartingY, 0, 31);

   dw[11] =
      util_bitpack_uint(values->ThreadGroupIDStartingZ, 0, 31);

   dw[12] =
      util_bitpack_uint(values->PartitionID, 0, 31);

   dw[13] =
      util_bitpack_uint(values->PartitionSize, 0, 31);

   dw[14] =
      util_bitpack_uint(values->PreemptX, 0, 31);

   dw[15] =
      util_bitpack_uint(values->PreemptY, 0, 31);

   dw[16] =
      util_bitpack_uint(values->PreemptZ, 0, 31);

   dw[17] =
      util_bitpack_uint(values->WalkerID, 0, 3) |
      util_bitpack_uint(values->OverdispatchTGcount, 8, 23);

   GFX20_INTERFACE_DESCRIPTOR_DATA_pack(data, &dw[18], &values->InterfaceDescriptor);

   GFX20_POSTSYNC_DATA_pack(data, &dw[26], &values->PostSync);

   dw[31] =
      util_bitpack_uint(values->InlineData[0], 0, 31);

   dw[32] =
      util_bitpack_uint(values->InlineData[1], 0, 31);

   dw[33] =
      util_bitpack_uint(values->InlineData[2], 0, 31);

   dw[34] =
      util_bitpack_uint(values->InlineData[3], 0, 31);

   dw[35] =
      util_bitpack_uint(values->InlineData[4], 0, 31);

   dw[36] =
      util_bitpack_uint(values->InlineData[5], 0, 31);

   dw[37] =
      util_bitpack_uint(values->InlineData[6], 0, 31);

   dw[38] =
      util_bitpack_uint(values->InlineData[7], 0, 31);
}

#define GFX20_CPS_STATE_length                 8
struct GFX20_CPS_STATE {
   float                                MinCPSizeX;
   bool                                 StatisticsEnable;
   uint32_t                             CoarsePixelShadingMode;
#define CPS_MODE_NONE                            0
#define CPS_MODE_CONSTANT                        1
#define CPS_MODE_RADIAL                          2
   uint32_t                             ScaleAxis;
#define Xaxis                                    0
#define Yaxis                                    1
   float                                MinCPSizeY;
   uint32_t                             Combiner1OpcodeforCPsize;
#define PASSTHROUGH                              0
#define OVERRIDE                                 1
#define HIGH_QUALITY                             2
#define LOW_QUALITY                              3
#define RELATIVE                                 4
   uint32_t                             Combiner0OpcodeforCPsize;
#define PASSTHROUGH                              0
#define OVERRIDE                                 1
#define HIGH_QUALITY                             2
#define LOW_QUALITY                              3
#define RELATIVE                                 4
   float                                MaxCPSizeX;
   float                                MaxCPSizeY;
   int32_t                              Y_Focal;
   int32_t                              X_Focal;
   uint32_t                             My;
   uint32_t                             Mx;
   uint32_t                             Rmin;
   uint32_t                             Aspect;
};

static inline __attribute__((always_inline)) void
GFX20_CPS_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                     __attribute__((unused)) void * restrict dst,
                     __attribute__((unused)) const struct GFX20_CPS_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_sfixed(values->MinCPSizeX, 0, 10, 7) |
      util_bitpack_uint(values->StatisticsEnable, 11, 11) |
      util_bitpack_uint(values->CoarsePixelShadingMode, 12, 13) |
      util_bitpack_uint(values->ScaleAxis, 14, 14) |
      util_bitpack_sfixed(values->MinCPSizeY, 15, 25, 7) |
      util_bitpack_uint(values->Combiner1OpcodeforCPsize, 26, 28) |
      util_bitpack_uint(values->Combiner0OpcodeforCPsize, 29, 31);

   dw[1] =
      util_bitpack_sfixed(values->MaxCPSizeX, 0, 10, 7) |
      util_bitpack_sfixed(values->MaxCPSizeY, 16, 26, 7);

   dw[2] =
      util_bitpack_sint(values->Y_Focal, 0, 15);

   dw[3] =
      util_bitpack_sint(values->X_Focal, 0, 15);

   dw[4] =
      util_bitpack_uint(values->My, 0, 31);

   dw[5] =
      util_bitpack_uint(values->Mx, 0, 31);

   dw[6] =
      util_bitpack_uint(values->Rmin, 0, 31);

   dw[7] =
      util_bitpack_uint(values->Aspect, 0, 31);
}

#define GFX20_FILTER_COEFFICIENT_length        1
struct GFX20_FILTER_COEFFICIENT {
   float                                FilterCoefficient;
};

static inline __attribute__((always_inline)) void
GFX20_FILTER_COEFFICIENT_pack(__attribute__((unused)) __gen_user_data *data,
                              __attribute__((unused)) void * restrict dst,
                              __attribute__((unused)) const struct GFX20_FILTER_COEFFICIENT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_sfixed(values->FilterCoefficient, 0, 7, 6);
}

#define GFX20_FRAMEDELTAQP_length              2
struct GFX20_FRAMEDELTAQP {
   int32_t                              FrameDeltaQP[8];
};

static inline __attribute__((always_inline)) void
GFX20_FRAMEDELTAQP_pack(__attribute__((unused)) __gen_user_data *data,
                        __attribute__((unused)) void * restrict dst,
                        __attribute__((unused)) const struct GFX20_FRAMEDELTAQP * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_sint(values->FrameDeltaQP[0], 0, 7) |
      util_bitpack_sint(values->FrameDeltaQP[1], 8, 15) |
      util_bitpack_sint(values->FrameDeltaQP[2], 16, 23) |
      util_bitpack_sint(values->FrameDeltaQP[3], 24, 31);

   dw[1] =
      util_bitpack_sint(values->FrameDeltaQP[4], 0, 7) |
      util_bitpack_sint(values->FrameDeltaQP[5], 8, 15) |
      util_bitpack_sint(values->FrameDeltaQP[6], 16, 23) |
      util_bitpack_sint(values->FrameDeltaQP[7], 24, 31);
}

#define GFX20_FRAMEDELTAQPRANGE_length         2
struct GFX20_FRAMEDELTAQPRANGE {
   uint32_t                             FrameDeltaQPRange[8];
};

static inline __attribute__((always_inline)) void
GFX20_FRAMEDELTAQPRANGE_pack(__attribute__((unused)) __gen_user_data *data,
                             __attribute__((unused)) void * restrict dst,
                             __attribute__((unused)) const struct GFX20_FRAMEDELTAQPRANGE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->FrameDeltaQPRange[0], 0, 7) |
      util_bitpack_uint(values->FrameDeltaQPRange[1], 8, 15) |
      util_bitpack_uint(values->FrameDeltaQPRange[2], 16, 23) |
      util_bitpack_uint(values->FrameDeltaQPRange[3], 24, 31);

   dw[1] =
      util_bitpack_uint(values->FrameDeltaQPRange[4], 0, 7) |
      util_bitpack_uint(values->FrameDeltaQPRange[5], 8, 15) |
      util_bitpack_uint(values->FrameDeltaQPRange[6], 16, 23) |
      util_bitpack_uint(values->FrameDeltaQPRange[7], 24, 31);
}

#define GFX20_GATHER_CONSTANT_ENTRY_length      1
struct GFX20_GATHER_CONSTANT_ENTRY {
   uint32_t                             BindingTableIndexOffset;
   uint32_t                             ChannelMask;
   uint64_t                             ConstantBufferOffset;
};

static inline __attribute__((always_inline)) void
GFX20_GATHER_CONSTANT_ENTRY_pack(__attribute__((unused)) __gen_user_data *data,
                                 __attribute__((unused)) void * restrict dst,
                                 __attribute__((unused)) const struct GFX20_GATHER_CONSTANT_ENTRY * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->BindingTableIndexOffset, 0, 3) |
      util_bitpack_uint(values->ChannelMask, 4, 7) |
      __gen_offset(values->ConstantBufferOffset, 8, 15);
}

#define GFX20_HEVC_ARBITRATION_PRIORITY_length      1
struct GFX20_HEVC_ARBITRATION_PRIORITY {
   uint32_t                             Priority;
#define Highestpriority                          0
#define Secondhighestpriority                    1
#define Thirdhighestpriority                     2
#define Lowestpriority                           3
};

static inline __attribute__((always_inline)) void
GFX20_HEVC_ARBITRATION_PRIORITY_pack(__attribute__((unused)) __gen_user_data *data,
                                     __attribute__((unused)) void * restrict dst,
                                     __attribute__((unused)) const struct GFX20_HEVC_ARBITRATION_PRIORITY * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->Priority, 0, 1);
}

#define GFX20_MEMORYADDRESSATTRIBUTES_length      1
struct GFX20_MEMORYADDRESSATTRIBUTES {
   uint32_t                             MOCS;
   struct GFX20_HEVC_ARBITRATION_PRIORITY ArbitrationPriorityControl;
   bool                                 MemoryCompressionEnable;
   uint32_t                             MemoryCompressionMode;
   uint32_t                             RowStoreScratchBufferCacheSelect;
#define LLC                                      0
#define InternalMediaStorage                     1
   uint32_t                             TiledResourceMode;
#define TRMODE_NONE                              0
#define TRMODE_TILES                             1
#define TRMODE_TILEX                             2
#define TRMODE_TILEF                             3
};

static inline __attribute__((always_inline)) void
GFX20_MEMORYADDRESSATTRIBUTES_pack(__attribute__((unused)) __gen_user_data *data,
                                   __attribute__((unused)) void * restrict dst,
                                   __attribute__((unused)) const struct GFX20_MEMORYADDRESSATTRIBUTES * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   uint32_t v0_0;
   GFX20_HEVC_ARBITRATION_PRIORITY_pack(data, &v0_0, &values->ArbitrationPriorityControl);

   dw[0] =
      util_bitpack_uint_nonzero(values->MOCS, 0, 6) |
      util_bitpack_uint(v0_0, 7, 8) |
      util_bitpack_uint(values->MemoryCompressionEnable, 9, 9) |
      util_bitpack_uint(values->MemoryCompressionMode, 10, 10) |
      util_bitpack_uint(values->RowStoreScratchBufferCacheSelect, 12, 12) |
      util_bitpack_uint(values->TiledResourceMode, 13, 14);
}

#define GFX20_HCP_PAK_INSERT_OBJECT_INDIRECT_PAYLOAD_length      4
struct GFX20_HCP_PAK_INSERT_OBJECT_INDIRECT_PAYLOAD {
   uint32_t                             IndirectPayloadDataSizeinbits;
   __gen_address_type                   IndirectPayloadBaseAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES IndirectPayloadBaseAddress2;
};

static inline __attribute__((always_inline)) void
GFX20_HCP_PAK_INSERT_OBJECT_INDIRECT_PAYLOAD_pack(__attribute__((unused)) __gen_user_data *data,
                                                  __attribute__((unused)) void * restrict dst,
                                                  __attribute__((unused)) const struct GFX20_HCP_PAK_INSERT_OBJECT_INDIRECT_PAYLOAD * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->IndirectPayloadDataSizeinbits, 0, 31);

   const uint64_t v1_address =
      __gen_address(data, &dw[1], values->IndirectPayloadBaseAddress, 0, 0, 63);
   dw[1] = v1_address;
   dw[2] = v1_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[3], &values->IndirectPayloadBaseAddress2);
}

#define GFX20_HCP_REF_LIST_ENTRY_length        1
struct GFX20_HCP_REF_LIST_ENTRY {
   uint32_t                             ReferencePicturetbValue;
   uint32_t                             ListEntry;
   uint32_t                             ChromaWeightedPrediction;
#define Default                                  0
#define Explicit                                 1
   uint32_t                             LumaWeightedPrediction;
#define Default                                  0
#define Explicit                                 1
   bool                                 LongTermReference;
   bool                                 FieldPic;
   bool                                 TopField;
};

static inline __attribute__((always_inline)) void
GFX20_HCP_REF_LIST_ENTRY_pack(__attribute__((unused)) __gen_user_data *data,
                              __attribute__((unused)) void * restrict dst,
                              __attribute__((unused)) const struct GFX20_HCP_REF_LIST_ENTRY * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->ReferencePicturetbValue, 0, 7) |
      util_bitpack_uint(values->ListEntry, 8, 10) |
      util_bitpack_uint(values->ChromaWeightedPrediction, 11, 11) |
      util_bitpack_uint(values->LumaWeightedPrediction, 12, 12) |
      util_bitpack_uint(values->LongTermReference, 13, 13) |
      util_bitpack_uint(values->FieldPic, 14, 14) |
      util_bitpack_uint(values->TopField, 15, 15);
}

#define GFX20_HCP_TILE_POSITION_IN_CTB_length      1
struct GFX20_HCP_TILE_POSITION_IN_CTB {
   uint32_t                             CtbPos0i;
   uint32_t                             CtbPos1i;
   uint32_t                             CtbPos2i;
   uint32_t                             CtbPos3i;
};

static inline __attribute__((always_inline)) void
GFX20_HCP_TILE_POSITION_IN_CTB_pack(__attribute__((unused)) __gen_user_data *data,
                                    __attribute__((unused)) void * restrict dst,
                                    __attribute__((unused)) const struct GFX20_HCP_TILE_POSITION_IN_CTB * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->CtbPos0i, 0, 7) |
      util_bitpack_uint(values->CtbPos1i, 8, 15) |
      util_bitpack_uint(values->CtbPos2i, 16, 23) |
      util_bitpack_uint(values->CtbPos3i, 24, 31);
}

#define GFX20_HCP_TILE_POSITION_IN_CTB_MSB_length      2
struct GFX20_HCP_TILE_POSITION_IN_CTB_MSB {
   uint32_t                             CtbRowPositionofTileColumn[22];
};

static inline __attribute__((always_inline)) void
GFX20_HCP_TILE_POSITION_IN_CTB_MSB_pack(__attribute__((unused)) __gen_user_data *data,
                                        __attribute__((unused)) void * restrict dst,
                                        __attribute__((unused)) const struct GFX20_HCP_TILE_POSITION_IN_CTB_MSB * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->CtbRowPositionofTileColumn[0], 0, 1) |
      util_bitpack_uint(values->CtbRowPositionofTileColumn[1], 2, 3) |
      util_bitpack_uint(values->CtbRowPositionofTileColumn[2], 4, 5) |
      util_bitpack_uint(values->CtbRowPositionofTileColumn[3], 6, 7) |
      util_bitpack_uint(values->CtbRowPositionofTileColumn[4], 8, 9) |
      util_bitpack_uint(values->CtbRowPositionofTileColumn[5], 10, 11) |
      util_bitpack_uint(values->CtbRowPositionofTileColumn[6], 12, 13) |
      util_bitpack_uint(values->CtbRowPositionofTileColumn[7], 14, 15) |
      util_bitpack_uint(values->CtbRowPositionofTileColumn[8], 16, 17) |
      util_bitpack_uint(values->CtbRowPositionofTileColumn[9], 18, 19) |
      util_bitpack_uint(values->CtbRowPositionofTileColumn[10], 20, 21) |
      util_bitpack_uint(values->CtbRowPositionofTileColumn[11], 22, 23) |
      util_bitpack_uint(values->CtbRowPositionofTileColumn[12], 24, 25) |
      util_bitpack_uint(values->CtbRowPositionofTileColumn[13], 26, 27) |
      util_bitpack_uint(values->CtbRowPositionofTileColumn[14], 28, 29) |
      util_bitpack_uint(values->CtbRowPositionofTileColumn[15], 30, 31);

   dw[1] =
      util_bitpack_uint(values->CtbRowPositionofTileColumn[16], 0, 1) |
      util_bitpack_uint(values->CtbRowPositionofTileColumn[17], 2, 3) |
      util_bitpack_uint(values->CtbRowPositionofTileColumn[18], 4, 5) |
      util_bitpack_uint(values->CtbRowPositionofTileColumn[19], 6, 7) |
      util_bitpack_uint(values->CtbRowPositionofTileColumn[20], 8, 9) |
      util_bitpack_uint(values->CtbRowPositionofTileColumn[21], 10, 11);
}

#define GFX20_HCP_WEIGHTOFFSET_CHROMA_ENTRY_length      1
struct GFX20_HCP_WEIGHTOFFSET_CHROMA_ENTRY {
   uint32_t                             DeltaChromaWeightLX0;
   uint32_t                             ChromaOffsetLX0;
   uint32_t                             DeltaChromaWeightLX1;
   uint32_t                             ChromaOffsetLX1;
};

static inline __attribute__((always_inline)) void
GFX20_HCP_WEIGHTOFFSET_CHROMA_ENTRY_pack(__attribute__((unused)) __gen_user_data *data,
                                         __attribute__((unused)) void * restrict dst,
                                         __attribute__((unused)) const struct GFX20_HCP_WEIGHTOFFSET_CHROMA_ENTRY * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DeltaChromaWeightLX0, 0, 7) |
      util_bitpack_uint(values->ChromaOffsetLX0, 8, 15) |
      util_bitpack_uint(values->DeltaChromaWeightLX1, 16, 23) |
      util_bitpack_uint(values->ChromaOffsetLX1, 24, 31);
}

#define GFX20_HCP_WEIGHTOFFSET_CHROMA_EXT_ENTRY_length      1
struct GFX20_HCP_WEIGHTOFFSET_CHROMA_EXT_ENTRY {
   uint32_t                             ChromaOffsetLX0MSBytei;
   uint32_t                             ChromaOffsetLX0MSBytei1;
   uint32_t                             ChromaOffsetLX1MSBytei;
   uint32_t                             ChromaOffsetLX1MSBytei1;
};

static inline __attribute__((always_inline)) void
GFX20_HCP_WEIGHTOFFSET_CHROMA_EXT_ENTRY_pack(__attribute__((unused)) __gen_user_data *data,
                                             __attribute__((unused)) void * restrict dst,
                                             __attribute__((unused)) const struct GFX20_HCP_WEIGHTOFFSET_CHROMA_EXT_ENTRY * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->ChromaOffsetLX0MSBytei, 0, 7) |
      util_bitpack_uint(values->ChromaOffsetLX0MSBytei1, 8, 15) |
      util_bitpack_uint(values->ChromaOffsetLX1MSBytei, 16, 23) |
      util_bitpack_uint(values->ChromaOffsetLX1MSBytei1, 24, 31);
}

#define GFX20_HCP_WEIGHTOFFSET_LUMA_ENTRY_length      1
struct GFX20_HCP_WEIGHTOFFSET_LUMA_ENTRY {
   uint32_t                             DeltaLumaWeightLX;
   uint32_t                             LumaOffsetLX;
   uint32_t                             LumaOffsetLXMSByte;
};

static inline __attribute__((always_inline)) void
GFX20_HCP_WEIGHTOFFSET_LUMA_ENTRY_pack(__attribute__((unused)) __gen_user_data *data,
                                       __attribute__((unused)) void * restrict dst,
                                       __attribute__((unused)) const struct GFX20_HCP_WEIGHTOFFSET_LUMA_ENTRY * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DeltaLumaWeightLX, 0, 7) |
      util_bitpack_uint(values->LumaOffsetLX, 8, 15) |
      util_bitpack_uint(values->LumaOffsetLXMSByte, 24, 31);
}

#define GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_length      1
struct GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS {
   uint32_t                             LambdaValue0;
   uint32_t                             LambdaValue1;
};

static inline __attribute__((always_inline)) void
GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(__attribute__((unused)) __gen_user_data *data,
                                       __attribute__((unused)) void * restrict dst,
                                       __attribute__((unused)) const struct GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->LambdaValue0, 0, 15) |
      util_bitpack_uint(values->LambdaValue1, 16, 31);
}

#define GFX20_HUC_VIRTUAL_ADDR_REGION_length      3
struct GFX20_HUC_VIRTUAL_ADDR_REGION {
   __gen_address_type                   Address;
   struct GFX20_MEMORYADDRESSATTRIBUTES MemoryAddressAttributes;
};

static inline __attribute__((always_inline)) void
GFX20_HUC_VIRTUAL_ADDR_REGION_pack(__attribute__((unused)) __gen_user_data *data,
                                   __attribute__((unused)) void * restrict dst,
                                   __attribute__((unused)) const struct GFX20_HUC_VIRTUAL_ADDR_REGION * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   const uint64_t v0_address =
      __gen_address(data, &dw[0], values->Address, 0, 0, 63);
   dw[0] = v0_address;
   dw[1] = v0_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[2], &values->MemoryAddressAttributes);
}

#define GFX20_IMAGE_STATE_COST_length          2
struct GFX20_IMAGE_STATE_COST {
   uint32_t                             MV0Cost;
   uint32_t                             MV1Cost;
   uint32_t                             MV2Cost;
   uint32_t                             MV3Cost;
   uint32_t                             MV4Cost;
   uint32_t                             MV5Cost;
   uint32_t                             MV6Cost;
   uint32_t                             MV7Cost;
};

static inline __attribute__((always_inline)) void
GFX20_IMAGE_STATE_COST_pack(__attribute__((unused)) __gen_user_data *data,
                            __attribute__((unused)) void * restrict dst,
                            __attribute__((unused)) const struct GFX20_IMAGE_STATE_COST * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->MV0Cost, 0, 7) |
      util_bitpack_uint(values->MV1Cost, 8, 15) |
      util_bitpack_uint(values->MV2Cost, 16, 23) |
      util_bitpack_uint(values->MV3Cost, 24, 31);

   dw[1] =
      util_bitpack_uint(values->MV4Cost, 0, 7) |
      util_bitpack_uint(values->MV5Cost, 8, 15) |
      util_bitpack_uint(values->MV6Cost, 16, 23) |
      util_bitpack_uint(values->MV7Cost, 24, 31);
}

#define GFX20_INLINE_DATA_DESCRIPTION_FOR_MFD_AVC_BSD_OBJECT_length      3
struct GFX20_INLINE_DATA_DESCRIPTION_FOR_MFD_AVC_BSD_OBJECT {
   bool                                 MBErrorConcealmentPSliceWeightPredictionDisable;
   bool                                 MBErrorConcealmentPSliceMotionVectorsOverrideDisable;
   bool                                 MBErrorConcealmentBSpatialWeightPredictionDisable;
   bool                                 MBErrorConcealmentBSpatialMotionVectorsOverrideDisable;
   uint32_t                             MBErrorConcealmentBSpatialPredictionMode;
   bool                                 MBHeaderErrorHandling;
   bool                                 EntropyErrorHandling;
   bool                                 MPRErrorHandling;
   bool                                 BSDPrematureCompleteErrorHandling;
   uint32_t                             ConcealmentPictureID;
   bool                                 MBErrorConcealmentBTemporalWeightPredictionDisable;
   bool                                 MBErrorConcealmentBTemporalMotionVectorsOverrideEnable;
   uint32_t                             MBErrorConcealmentBTemporalPredictionMode;
   bool                                 IntraPredMode4x48x8LumaErrorControl;
   bool                                 InitCurrentMBNumber;
   uint32_t                             ConcealmentMethod;
   uint32_t                             FirstMBBitOffset;
   bool                                 LastSlice;
   bool                                 EmulationPreventionBytePresent;
   bool                                 FixPrevMBSkipped;
   uint32_t                             FirstMBByteOffsetofSliceDataorSliceHeader;
   bool                                 IntraPredictionErrorControl;
   bool                                 Intra8x84x4PredictionErrorConcealmentControl;
   uint32_t                             BSliceTemporalInterConcealmentMode;
   uint32_t                             BSliceSpatialInterConcealmentMode;
   uint32_t                             BSliceInterDirectTypeConcealmentMode;
   uint32_t                             BSliceConcealmentMode;
#define IntraConcealment                         1
#define InterConcealment                         0
   uint32_t                             PSliceInterConcealmentMode;
   uint32_t                             PSliceConcealmentMode;
#define IntraConcealment                         1
#define InterConcealment                         0
   uint32_t                             ConcealmentReferencePictureFieldBit;
   uint32_t                             ISliceConcealmentMode;
#define IntraConcealment                         1
#define InterConcealment                         0
};

static inline __attribute__((always_inline)) void
GFX20_INLINE_DATA_DESCRIPTION_FOR_MFD_AVC_BSD_OBJECT_pack(__attribute__((unused)) __gen_user_data *data,
                                                          __attribute__((unused)) void * restrict dst,
                                                          __attribute__((unused)) const struct GFX20_INLINE_DATA_DESCRIPTION_FOR_MFD_AVC_BSD_OBJECT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->MBErrorConcealmentPSliceWeightPredictionDisable, 0, 0) |
      util_bitpack_uint(values->MBErrorConcealmentPSliceMotionVectorsOverrideDisable, 1, 1) |
      util_bitpack_uint(values->MBErrorConcealmentBSpatialWeightPredictionDisable, 3, 3) |
      util_bitpack_uint(values->MBErrorConcealmentBSpatialMotionVectorsOverrideDisable, 4, 4) |
      util_bitpack_uint(values->MBErrorConcealmentBSpatialPredictionMode, 6, 7) |
      util_bitpack_uint(values->MBHeaderErrorHandling, 8, 8) |
      util_bitpack_uint(values->EntropyErrorHandling, 10, 10) |
      util_bitpack_uint(values->MPRErrorHandling, 12, 12) |
      util_bitpack_uint(values->BSDPrematureCompleteErrorHandling, 14, 14) |
      util_bitpack_uint(values->ConcealmentPictureID, 16, 21) |
      util_bitpack_uint(values->MBErrorConcealmentBTemporalWeightPredictionDisable, 24, 24) |
      util_bitpack_uint(values->MBErrorConcealmentBTemporalMotionVectorsOverrideEnable, 25, 25) |
      util_bitpack_uint(values->MBErrorConcealmentBTemporalPredictionMode, 27, 28) |
      util_bitpack_uint(values->IntraPredMode4x48x8LumaErrorControl, 29, 29) |
      util_bitpack_uint(values->InitCurrentMBNumber, 30, 30) |
      util_bitpack_uint(values->ConcealmentMethod, 31, 31);

   dw[1] =
      util_bitpack_uint(values->FirstMBBitOffset, 0, 2) |
      util_bitpack_uint(values->LastSlice, 3, 3) |
      util_bitpack_uint(values->EmulationPreventionBytePresent, 4, 4) |
      util_bitpack_uint(values->FixPrevMBSkipped, 7, 7) |
      util_bitpack_uint(values->FirstMBByteOffsetofSliceDataorSliceHeader, 16, 31);

   dw[2] =
      util_bitpack_uint(values->IntraPredictionErrorControl, 0, 0) |
      util_bitpack_uint(values->Intra8x84x4PredictionErrorConcealmentControl, 1, 1) |
      util_bitpack_uint(values->BSliceTemporalInterConcealmentMode, 4, 6) |
      util_bitpack_uint(values->BSliceSpatialInterConcealmentMode, 8, 10) |
      util_bitpack_uint(values->BSliceInterDirectTypeConcealmentMode, 12, 13) |
      util_bitpack_uint(values->BSliceConcealmentMode, 15, 15) |
      util_bitpack_uint(values->PSliceInterConcealmentMode, 16, 18) |
      util_bitpack_uint(values->PSliceConcealmentMode, 23, 23) |
      util_bitpack_uint(values->ConcealmentReferencePictureFieldBit, 24, 29) |
      util_bitpack_uint(values->ISliceConcealmentMode, 31, 31);
}

#define GFX20_LUMA_FILTER_COEFFICIENTS_ARRAY_length      4
struct GFX20_LUMA_FILTER_COEFFICIENTS_ARRAY {
   float                                Table0XFilterCoefficientn0;
   float                                Table0YFilterCoefficientn0;
   float                                Table0XFilterCoefficientn1;
   float                                Table0YFilterCoefficientn1;
   float                                Table0XFilterCoefficientn2;
   float                                Table0YFilterCoefficientn2;
   float                                Table0XFilterCoefficientn3;
   float                                Table0YFilterCoefficientn3;
   float                                Table0XFilterCoefficientn4;
   float                                Table0YFilterCoefficientn4;
   float                                Table0XFilterCoefficientn5;
   float                                Table0YFilterCoefficientn5;
   float                                Table0XFilterCoefficientn6;
   float                                Table0YFilterCoefficientn6;
   float                                Table0XFilterCoefficientn7;
   float                                Table0YFilterCoefficientn7;
};

static inline __attribute__((always_inline)) void
GFX20_LUMA_FILTER_COEFFICIENTS_ARRAY_pack(__attribute__((unused)) __gen_user_data *data,
                                          __attribute__((unused)) void * restrict dst,
                                          __attribute__((unused)) const struct GFX20_LUMA_FILTER_COEFFICIENTS_ARRAY * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_sfixed(values->Table0XFilterCoefficientn0, 0, 7, 6) |
      util_bitpack_sfixed(values->Table0YFilterCoefficientn0, 8, 15, 6) |
      util_bitpack_sfixed(values->Table0XFilterCoefficientn1, 16, 23, 6) |
      util_bitpack_sfixed(values->Table0YFilterCoefficientn1, 24, 31, 6);

   dw[1] =
      util_bitpack_sfixed(values->Table0XFilterCoefficientn2, 0, 7, 6) |
      util_bitpack_sfixed(values->Table0YFilterCoefficientn2, 8, 15, 6) |
      util_bitpack_sfixed(values->Table0XFilterCoefficientn3, 16, 23, 6) |
      util_bitpack_sfixed(values->Table0YFilterCoefficientn3, 24, 31, 6);

   dw[2] =
      util_bitpack_sfixed(values->Table0XFilterCoefficientn4, 0, 7, 6) |
      util_bitpack_sfixed(values->Table0YFilterCoefficientn4, 8, 15, 6) |
      util_bitpack_sfixed(values->Table0XFilterCoefficientn5, 16, 23, 6) |
      util_bitpack_sfixed(values->Table0YFilterCoefficientn5, 24, 31, 6);

   dw[3] =
      util_bitpack_sfixed(values->Table0XFilterCoefficientn6, 0, 7, 6) |
      util_bitpack_sfixed(values->Table0YFilterCoefficientn6, 8, 15, 6) |
      util_bitpack_sfixed(values->Table0XFilterCoefficientn7, 16, 23, 6) |
      util_bitpack_sfixed(values->Table0YFilterCoefficientn7, 24, 31, 6);
}

#define GFX20_MFD_MPEG2_BSD_OBJECT_INLINE_DATA_DESCRIPTION_length      2
struct GFX20_MFD_MPEG2_BSD_OBJECT_INLINE_DATA_DESCRIPTION {
   uint32_t                             FirstMBBitOffset;
   bool                                 LastMB;
   bool                                 LastPicSlice;
   uint32_t                             SliceConcealmentType;
   uint32_t                             SliceConcealmentOverride;
   uint32_t                             MBCount;
   uint32_t                             SliceVerticalPosition;
   uint32_t                             SliceHorizontalPosition;
   uint32_t                             NextSliceHorizontalPosition;
   uint32_t                             NextSliceVerticalPosition;
   uint32_t                             QuantizerScaleCode;
};

static inline __attribute__((always_inline)) void
GFX20_MFD_MPEG2_BSD_OBJECT_INLINE_DATA_DESCRIPTION_pack(__attribute__((unused)) __gen_user_data *data,
                                                        __attribute__((unused)) void * restrict dst,
                                                        __attribute__((unused)) const struct GFX20_MFD_MPEG2_BSD_OBJECT_INLINE_DATA_DESCRIPTION * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->FirstMBBitOffset, 0, 2) |
      util_bitpack_uint(values->LastMB, 3, 3) |
      util_bitpack_uint(values->LastPicSlice, 5, 5) |
      util_bitpack_uint(values->SliceConcealmentType, 6, 6) |
      util_bitpack_uint(values->SliceConcealmentOverride, 7, 7) |
      util_bitpack_uint(values->MBCount, 8, 15) |
      util_bitpack_uint(values->SliceVerticalPosition, 16, 23) |
      util_bitpack_uint(values->SliceHorizontalPosition, 24, 31);

   dw[1] =
      util_bitpack_uint(values->NextSliceHorizontalPosition, 0, 7) |
      util_bitpack_uint(values->NextSliceVerticalPosition, 8, 16) |
      util_bitpack_uint(values->QuantizerScaleCode, 24, 28);
}

#define GFX20_MI_MATH_ALU_INSTRUCTION_length      1
struct GFX20_MI_MATH_ALU_INSTRUCTION {
   uint32_t                             Operand2;
#define MI_ALU_REG0                              0
#define MI_ALU_REG1                              1
#define MI_ALU_REG2                              2
#define MI_ALU_REG3                              3
#define MI_ALU_REG4                              4
#define MI_ALU_REG5                              5
#define MI_ALU_REG6                              6
#define MI_ALU_REG7                              7
#define MI_ALU_REG8                              8
#define MI_ALU_REG9                              9
#define MI_ALU_REG10                             10
#define MI_ALU_REG11                             11
#define MI_ALU_REG12                             12
#define MI_ALU_REG13                             13
#define MI_ALU_REG14                             14
#define MI_ALU_REG15                             15
#define MI_ALU_SRCA                              32
#define MI_ALU_SRCB                              33
#define MI_ALU_ACCU                              49
#define MI_ALU_ZF                                50
#define MI_ALU_CF                                51
   uint32_t                             Operand1;
#define MI_ALU_REG0                              0
#define MI_ALU_REG1                              1
#define MI_ALU_REG2                              2
#define MI_ALU_REG3                              3
#define MI_ALU_REG4                              4
#define MI_ALU_REG5                              5
#define MI_ALU_REG6                              6
#define MI_ALU_REG7                              7
#define MI_ALU_REG8                              8
#define MI_ALU_REG9                              9
#define MI_ALU_REG10                             10
#define MI_ALU_REG11                             11
#define MI_ALU_REG12                             12
#define MI_ALU_REG13                             13
#define MI_ALU_REG14                             14
#define MI_ALU_REG15                             15
#define MI_ALU_SRCA                              32
#define MI_ALU_SRCB                              33
#define MI_ALU_ACCU                              49
#define MI_ALU_ZF                                50
#define MI_ALU_CF                                51
   uint32_t                             ALUOpcode;
#define MI_ALU_NOOP                              0
#define MI_ALU_FENCE_RD                          1
#define MI_ALU_FENCE_WR                          2
#define MI_ALU_LOAD                              128
#define MI_ALU_LOADINV                           1152
#define MI_ALU_LOAD0                             129
#define MI_ALU_LOAD1                             1153
#define MI_ALU_LOADIND                           130
#define MI_ALU_ADD                               256
#define MI_ALU_SUB                               257
#define MI_ALU_AND                               258
#define MI_ALU_OR                                259
#define MI_ALU_XOR                               260
#define MI_ALU_SHL                               261
#define MI_ALU_SHR                               262
#define MI_ALU_SAR                               263
#define MI_ALU_STORE                             384
#define MI_ALU_STOREINV                          1408
#define MI_ALU_STOREIND                          385
};

static inline __attribute__((always_inline)) void
GFX20_MI_MATH_ALU_INSTRUCTION_pack(__attribute__((unused)) __gen_user_data *data,
                                   __attribute__((unused)) void * restrict dst,
                                   __attribute__((unused)) const struct GFX20_MI_MATH_ALU_INSTRUCTION * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->Operand2, 0, 9) |
      util_bitpack_uint(values->Operand1, 10, 19) |
      util_bitpack_uint(values->ALUOpcode, 20, 31);
}

#define GFX20_PALETTE_ENTRY_length             1
struct GFX20_PALETTE_ENTRY {
   uint32_t                             Blue;
   uint32_t                             Green;
   uint32_t                             Red;
   uint32_t                             Alpha;
};

static inline __attribute__((always_inline)) void
GFX20_PALETTE_ENTRY_pack(__attribute__((unused)) __gen_user_data *data,
                         __attribute__((unused)) void * restrict dst,
                         __attribute__((unused)) const struct GFX20_PALETTE_ENTRY * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->Blue, 0, 7) |
      util_bitpack_uint(values->Green, 8, 15) |
      util_bitpack_uint(values->Red, 16, 23) |
      util_bitpack_uint(values->Alpha, 24, 31);
}

#define GFX20_RENDER_SURFACE_STATE_length     16
struct GFX20_RENDER_SURFACE_STATE {
   bool                                 CubeFaceEnablePositiveZ;
   bool                                 CubeFaceEnableNegativeZ;
   bool                                 CubeFaceEnablePositiveY;
   bool                                 CubeFaceEnableNegativeY;
   bool                                 CubeFaceEnablePositiveX;
   bool                                 CubeFaceEnableNegativeX;
   uint32_t                             MediaBoundaryPixelMode;
#define NORMAL_MODE                              0
#define PROGRESSIVE_FRAME                        2
#define INTERLACED_FRAME                         3
   uint32_t                             RenderCacheReadWriteMode;
#define WriteOnlyCache                           0
#define ReadWriteCache                           1
   bool                                 EnableSamplerRoutetoLSC;
   uint32_t                             VerticalLineStrideOffset;
   uint32_t                             VerticalLineStride;
   uint32_t                             TileMode;
#define LINEAR                                   0
#define TILE64                                   1
#define XMAJOR                                   2
#define TILE4                                    3
   uint32_t                             SurfaceHorizontalAlignment;
#define HALIGN_16                                0
#define HALIGN_32                                1
#define HALIGN_64                                2
#define HALIGN_128                               3
   uint32_t                             SurfaceVerticalAlignment;
#define VALIGN_4                                 1
#define VALIGN_8                                 2
#define VALIGN_16                                3
   uint32_t                             SurfaceFormat;
   bool                                 SurfaceArray;
   enum GFX20_STATE_SURFACE_TYPE        SurfaceType;
   uint32_t                             SurfaceQPitch;
   bool                                 SampleTapDiscardDisable;
   bool                                 CornerTexelMode;
   uint32_t                             BaseMipLevel;
   uint32_t                             MOCS;
   uint32_t                             Width;
   uint32_t                             Height;
   bool                                 DepthStencilResource;
   uint32_t                             SurfacePitch;
   uint32_t                             Depth;
   uint32_t                             MultisamplePositionPaletteIndex;
   uint32_t                             NumberofMultisamples;
#define MULTISAMPLECOUNT_1                       0
#define MULTISAMPLECOUNT_2                       1
#define MULTISAMPLECOUNT_4                       2
#define MULTISAMPLECOUNT_8                       3
#define MULTISAMPLECOUNT_16                      4
   uint32_t                             MultisampledSurfaceStorageFormat;
#define MSFMT_MSS                                0
#define MSFMT_DEPTH_STENCIL                      1
   uint32_t                             RenderTargetViewExtent;
   uint32_t                             MinimumArrayElement;
   uint32_t                             RenderTargetAndSampleUnormRotation;
#define _0DEG                                    0
#define _90DEG                                   1
#define _180DEG                                  2
#define _270DEG                                  3
   uint32_t                             MIPCountLOD;
   uint32_t                             SurfaceMinLOD;
   uint32_t                             MipTailStartLOD;
   enum GFX20_L1_CACHE_CONTROL          L1CacheControl;
   bool                                 EWADisableForCube;
   uint32_t                             YOffset;
   uint32_t                             XOffset;
   uint32_t                             AuxiliarySurfaceMode;
#define AUX_NONE                                 0
#define AUX_APPEND                               1
#define AUX_MCS                                  2
   uint32_t                             YOffsetforUorUVPlane;
   uint32_t                             AuxiliarySurfacePitch;
   bool                                 YUVInterpolationEnable;
   uint32_t                             XOffsetforUorUVPlane;
   uint32_t                             AuxiliarySurfaceQPitch;
   float                                ResourceMinLOD;
   enum GFX20_ShaderChannelSelect       ShaderChannelSelectAlpha;
   enum GFX20_ShaderChannelSelect       ShaderChannelSelectBlue;
   enum GFX20_ShaderChannelSelect       ShaderChannelSelectGreen;
   enum GFX20_ShaderChannelSelect       ShaderChannelSelectRed;
   __gen_address_type                   SurfaceBaseAddress;
   uint32_t                             MipRegionWidthInLog2;
   __gen_address_type                   AppendCounterAddress;
   uint32_t                             MipRegionHeightInLog2;
   bool                                 ProceduralTexture;
   __gen_address_type                   AuxiliarySurfaceBaseAddress;
   uint32_t                             YOffsetforVPlane;
   uint32_t                             XOffsetforVPlane;
   enum GFX20_UNIFIED_COMPRESSION_FORMAT CompressionFormat;
   uint32_t                             MipRegionDepthInLog2;
   bool                                 Disallowlowqualityfiltering;
};

static inline __attribute__((always_inline)) void
GFX20_RENDER_SURFACE_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                                __attribute__((unused)) void * restrict dst,
                                __attribute__((unused)) const struct GFX20_RENDER_SURFACE_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->CubeFaceEnablePositiveZ, 0, 0) |
      util_bitpack_uint(values->CubeFaceEnableNegativeZ, 1, 1) |
      util_bitpack_uint(values->CubeFaceEnablePositiveY, 2, 2) |
      util_bitpack_uint(values->CubeFaceEnableNegativeY, 3, 3) |
      util_bitpack_uint(values->CubeFaceEnablePositiveX, 4, 4) |
      util_bitpack_uint(values->CubeFaceEnableNegativeX, 5, 5) |
      util_bitpack_uint(values->MediaBoundaryPixelMode, 6, 7) |
      util_bitpack_uint(values->RenderCacheReadWriteMode, 8, 8) |
      util_bitpack_uint(values->EnableSamplerRoutetoLSC, 9, 9) |
      util_bitpack_uint(values->VerticalLineStrideOffset, 10, 10) |
      util_bitpack_uint(values->VerticalLineStride, 11, 11) |
      util_bitpack_uint(values->TileMode, 12, 13) |
      util_bitpack_uint(values->SurfaceHorizontalAlignment, 14, 15) |
      util_bitpack_uint(values->SurfaceVerticalAlignment, 16, 17) |
      util_bitpack_uint(values->SurfaceFormat, 18, 26) |
      util_bitpack_uint(values->SurfaceArray, 28, 28) |
      util_bitpack_uint(values->SurfaceType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->SurfaceQPitch, 0, 14) |
      util_bitpack_uint(values->SampleTapDiscardDisable, 15, 15) |
      util_bitpack_uint(values->CornerTexelMode, 18, 18) |
      util_bitpack_uint(values->BaseMipLevel, 19, 23) |
      util_bitpack_uint_nonzero(values->MOCS, 24, 30);

   dw[2] =
      util_bitpack_uint(values->Width, 0, 13) |
      util_bitpack_uint(values->Height, 16, 29) |
      util_bitpack_uint(values->DepthStencilResource, 31, 31);

   dw[3] =
      util_bitpack_uint(values->SurfacePitch, 0, 17) |
      util_bitpack_uint(values->Depth, 21, 31);

   dw[4] =
      util_bitpack_uint(values->MultisamplePositionPaletteIndex, 0, 2) |
      util_bitpack_uint(values->NumberofMultisamples, 3, 5) |
      util_bitpack_uint(values->MultisampledSurfaceStorageFormat, 6, 6) |
      util_bitpack_uint(values->RenderTargetViewExtent, 7, 17) |
      util_bitpack_uint(values->MinimumArrayElement, 18, 28) |
      util_bitpack_uint(values->RenderTargetAndSampleUnormRotation, 29, 30);

   dw[5] =
      util_bitpack_uint(values->MIPCountLOD, 0, 3) |
      util_bitpack_uint(values->SurfaceMinLOD, 4, 7) |
      util_bitpack_uint(values->MipTailStartLOD, 8, 11) |
      util_bitpack_uint(values->L1CacheControl, 16, 18) |
      util_bitpack_uint(values->EWADisableForCube, 20, 20) |
      util_bitpack_uint(values->YOffset, 21, 23) |
      util_bitpack_uint(values->XOffset, 25, 31);

   dw[6] =
      util_bitpack_uint(values->AuxiliarySurfaceMode, 0, 2) |
      util_bitpack_uint(values->YOffsetforUorUVPlane, 0, 13) |
      util_bitpack_uint(values->AuxiliarySurfacePitch, 3, 12) |
      util_bitpack_uint(values->YUVInterpolationEnable, 15, 15) |
      util_bitpack_uint(values->XOffsetforUorUVPlane, 16, 29) |
      util_bitpack_uint(values->AuxiliarySurfaceQPitch, 16, 30);

   dw[7] =
      util_bitpack_ufixed(values->ResourceMinLOD, 0, 11, 8) |
      util_bitpack_uint(values->ShaderChannelSelectAlpha, 16, 18) |
      util_bitpack_uint(values->ShaderChannelSelectBlue, 19, 21) |
      util_bitpack_uint(values->ShaderChannelSelectGreen, 22, 24) |
      util_bitpack_uint(values->ShaderChannelSelectRed, 25, 27);

   const uint64_t v8_address =
      __gen_address(data, &dw[8], values->SurfaceBaseAddress, 0, 0, 63);
   dw[8] = v8_address;
   dw[9] = v8_address >> 32;

   const uint64_t v10 =
      util_bitpack_uint(values->MipRegionWidthInLog2, 0, 3) |
      util_bitpack_uint(values->MipRegionHeightInLog2, 4, 7) |
      util_bitpack_uint(values->ProceduralTexture, 11, 11) |
      util_bitpack_uint(values->YOffsetforVPlane, 32, 45) |
      util_bitpack_uint(values->XOffsetforVPlane, 48, 61);
   const uint64_t v10_address =
      __gen_address(data, &dw[10], values->AuxiliarySurfaceBaseAddress, v10, 12, 63);
   dw[10] = v10_address;
   dw[11] = (v10_address >> 32) | (v10 >> 32);

   dw[12] =
      util_bitpack_uint(values->CompressionFormat, 0, 3) |
      util_bitpack_uint(values->MipRegionDepthInLog2, 4, 7);

   dw[13] =
      util_bitpack_uint(values->Disallowlowqualityfiltering, 31, 31);

   dw[14] = 0;

   dw[15] = 0;
}

#define GFX20_RESOURCE_BARRIER_BODY_length      4
struct GFX20_RESOURCE_BARRIER_BODY {
   enum GFX20_RESOURCE_BARRIER_STAGE    WaitStage;
   enum GFX20_RESOURCE_BARRIER_STAGE    SignalStage;
   enum GFX20_RESOURCE_BARRIER_TYPE     BarrierType;
   bool                                 L1DataportCacheInvalidate;
   bool                                 DepthCache;
   bool                                 ColorCache;
   bool                                 L1DataportUAVFlush;
   bool                                 TextureRO;
   bool                                 StateRO;
   bool                                 VFRO;
   bool                                 AMFS;
   bool                                 ConstantCache;
   __gen_address_type                   BarrierIDAddress;
};

static inline __attribute__((always_inline)) void
GFX20_RESOURCE_BARRIER_BODY_pack(__attribute__((unused)) __gen_user_data *data,
                                 __attribute__((unused)) void * restrict dst,
                                 __attribute__((unused)) const struct GFX20_RESOURCE_BARRIER_BODY * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->WaitStage, 0, 11) |
      util_bitpack_uint(values->SignalStage, 12, 23) |
      util_bitpack_uint(values->BarrierType, 30, 31);

   dw[1] =
      util_bitpack_uint(values->L1DataportCacheInvalidate, 21, 21) |
      util_bitpack_uint(values->DepthCache, 22, 22) |
      util_bitpack_uint(values->ColorCache, 23, 23) |
      util_bitpack_uint(values->L1DataportUAVFlush, 24, 24) |
      util_bitpack_uint(values->TextureRO, 25, 25) |
      util_bitpack_uint(values->StateRO, 26, 26) |
      util_bitpack_uint(values->VFRO, 27, 27) |
      util_bitpack_uint(values->AMFS, 28, 28) |
      util_bitpack_uint(values->ConstantCache, 29, 29);

   const uint64_t v2_address =
      __gen_address(data, &dw[2], values->BarrierIDAddress, 0, 3, 63);
   dw[2] = v2_address;
   dw[3] = v2_address >> 32;
}

#define GFX20_ROUNDINGPRECISIONTABLE_3_BITS_length      1
struct GFX20_ROUNDINGPRECISIONTABLE_3_BITS {
   uint32_t                             RoundingPrecision;
#define _116                                     0
#define _216                                     1
#define _316                                     2
#define _416                                     3
#define _516                                     4
#define _616                                     5
#define _716                                     6
#define _816                                     7
};

static inline __attribute__((always_inline)) void
GFX20_ROUNDINGPRECISIONTABLE_3_BITS_pack(__attribute__((unused)) __gen_user_data *data,
                                         __attribute__((unused)) void * restrict dst,
                                         __attribute__((unused)) const struct GFX20_ROUNDINGPRECISIONTABLE_3_BITS * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->RoundingPrecision, 0, 2);
}

#define GFX20_SAMPLER_BORDER_COLOR_STATE_length      4
struct GFX20_SAMPLER_BORDER_COLOR_STATE {
   float                                BorderColorFloatRed;
   uint32_t                             BorderColor32bitRed;
   float                                BorderColorFloatGreen;
   uint32_t                             BorderColor32bitGreen;
   float                                BorderColorFloatBlue;
   uint32_t                             BorderColor32bitBlue;
   float                                BorderColorFloatAlpha;
   uint32_t                             BorderColor32bitAlpha;
};

static inline __attribute__((always_inline)) void
GFX20_SAMPLER_BORDER_COLOR_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                                      __attribute__((unused)) void * restrict dst,
                                      __attribute__((unused)) const struct GFX20_SAMPLER_BORDER_COLOR_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_float(values->BorderColorFloatRed) |
      util_bitpack_uint(values->BorderColor32bitRed, 0, 31);

   dw[1] =
      util_bitpack_float(values->BorderColorFloatGreen) |
      util_bitpack_uint(values->BorderColor32bitGreen, 0, 31);

   dw[2] =
      util_bitpack_float(values->BorderColorFloatBlue) |
      util_bitpack_uint(values->BorderColor32bitBlue, 0, 31);

   dw[3] =
      util_bitpack_float(values->BorderColorFloatAlpha) |
      util_bitpack_uint(values->BorderColor32bitAlpha, 0, 31);
}

#define GFX20_SAMPLER_INDIRECT_STATE_BORDER_COLOR_length      4
struct GFX20_SAMPLER_INDIRECT_STATE_BORDER_COLOR {
   int32_t                              BorderColorRedAsS31;
   uint32_t                             BorderColorRedAsU32;
   float                                BorderColorRedAsFloat;
   uint32_t                             BorderColorRedAsU8;
   uint32_t                             BorderColorGreenAsU8;
   uint32_t                             BorderColorBlueAsU8;
   uint32_t                             BorderColorAlphaAsU8;
   int32_t                              BorderColorGreenAsS31;
   uint32_t                             BorderColorGreenAsU32;
   float                                BorderColorGreenAsFloat;
   int32_t                              BorderColorBlueAsS31;
   uint32_t                             BorderColorBlueAsU32;
   float                                BorderColorBlueAsFloat;
   int32_t                              BorderColorAlphaAsS31;
   uint32_t                             BorderColorAlphaAsU32;
   float                                BorderColorAlphaAsFloat;
};

static inline __attribute__((always_inline)) void
GFX20_SAMPLER_INDIRECT_STATE_BORDER_COLOR_pack(__attribute__((unused)) __gen_user_data *data,
                                               __attribute__((unused)) void * restrict dst,
                                               __attribute__((unused)) const struct GFX20_SAMPLER_INDIRECT_STATE_BORDER_COLOR * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_sint(values->BorderColorRedAsS31, 0, 31) |
      util_bitpack_uint(values->BorderColorRedAsU32, 0, 31) |
      util_bitpack_float(values->BorderColorRedAsFloat) |
      util_bitpack_uint(values->BorderColorRedAsU8, 0, 7) |
      util_bitpack_uint(values->BorderColorGreenAsU8, 8, 15) |
      util_bitpack_uint(values->BorderColorBlueAsU8, 16, 23) |
      util_bitpack_uint(values->BorderColorAlphaAsU8, 24, 31);

   dw[1] =
      util_bitpack_sint(values->BorderColorGreenAsS31, 0, 31) |
      util_bitpack_uint(values->BorderColorGreenAsU32, 0, 31) |
      util_bitpack_float(values->BorderColorGreenAsFloat);

   dw[2] =
      util_bitpack_sint(values->BorderColorBlueAsS31, 0, 31) |
      util_bitpack_uint(values->BorderColorBlueAsU32, 0, 31) |
      util_bitpack_float(values->BorderColorBlueAsFloat);

   dw[3] =
      util_bitpack_sint(values->BorderColorAlphaAsS31, 0, 31) |
      util_bitpack_uint(values->BorderColorAlphaAsU32, 0, 31) |
      util_bitpack_float(values->BorderColorAlphaAsFloat);
}

#define GFX20_SAMPLER_STATE_length             4
struct GFX20_SAMPLER_STATE {
   uint32_t                             AnisotropicAlgorithm;
#define LEGACY                                   0
#define EWAApproximation                         1
   float                                TextureLODBias;
   uint32_t                             MinModeFilter;
#define MAPFILTER_NEAREST                        0
#define MAPFILTER_LINEAR                         1
#define MAPFILTER_ANISOTROPIC                    2
#define MAPFILTER_MONO                           6
   uint32_t                             MagModeFilter;
#define MAPFILTER_NEAREST                        0
#define MAPFILTER_LINEAR                         1
#define MAPFILTER_ANISOTROPIC                    2
#define MAPFILTER_MONO                           6
   uint32_t                             MipModeFilter;
#define MIPFILTER_NONE                           0
#define MIPFILTER_NEAREST                        1
#define MIPFILTER_LINEAR                         3
   uint32_t                             CoarseLODQualityMode;
   uint32_t                             LODPreClampMode;
#define CLAMP_MODE_NONE                          0
#define CLAMP_MODE_OGL                           2
   uint32_t                             TextureBorderColorMode;
#define DX10OGL                                  0
#define DX9                                      1
   bool                                 CPSLODCompensationEnable;
   bool                                 SamplerDisable;
   uint32_t                             CubeSurfaceControlMode;
#define PROGRAMMED                               0
#define OVERRIDE                                 1
   uint32_t                             ShadowFunction;
#define PREFILTEROP_ALWAYS                       0
#define PREFILTEROP_NEVER                        1
#define PREFILTEROP_LESS                         2
#define PREFILTEROP_EQUAL                        3
#define PREFILTEROP_LEQUAL                       4
#define PREFILTEROP_GREATER                      5
#define PREFILTEROP_NOTEQUAL                     6
#define PREFILTEROP_GEQUAL                       7
   uint32_t                             ChromaKeyMode;
#define KEYFILTER_KILL_ON_ANY_MATCH              0
#define KEYFILTER_REPLACE_BLACK                  1
   uint32_t                             ChromaKeyIndex;
   bool                                 ChromaKeyEnable;
   float                                MaxLOD;
   float                                MinLOD;
   uint32_t                             LODClampMagnificationMode;
#define MIPNONE                                  0
#define MIPFILTER                                1
   uint32_t                             SRGBDECODE;
#define DECODE_EXT                               0
#define SKIP_DECODE_EXT                          1
   uint32_t                             ReturnFilterWeightforNullTexels;
   uint32_t                             ReturnFilterWeightforBorderTexels;
   bool                                 Forcegather4Behavior;
   uint64_t                             BorderColorPointer;
   enum GFX20_TextureCoordinateMode     TCZAddressControlMode;
   enum GFX20_TextureCoordinateMode     TCYAddressControlMode;
   enum GFX20_TextureCoordinateMode     TCXAddressControlMode;
   bool                                 ReductionTypeEnable;
   bool                                 NonnormalizedCoordinateEnable;
   uint32_t                             TrilinearFilterQuality;
#define FULL                                     0
#define HIGH                                     1
#define MED                                      2
#define LOW                                      3
   bool                                 RAddressMinFilterRoundingEnable;
   bool                                 RAddressMagFilterRoundingEnable;
   bool                                 VAddressMinFilterRoundingEnable;
   bool                                 VAddressMagFilterRoundingEnable;
   bool                                 UAddressMinFilterRoundingEnable;
   bool                                 UAddressMagFilterRoundingEnable;
   uint32_t                             MaximumAnisotropy;
#define RATIO21                                  0
#define RATIO41                                  1
#define RATIO61                                  2
#define RATIO81                                  3
#define RATIO101                                 4
#define RATIO121                                 5
#define RATIO141                                 6
#define RATIO161                                 7
   uint32_t                             ReductionType;
#define STD_FILTER                               0
#define COMPARISON                               1
#define MINIMUM                                  2
#define MAXIMUM                                  3
   bool                                 AllowLowQualityLODCalculation;
   bool                                 LowQualityFilter;
};

static inline __attribute__((always_inline)) void
GFX20_SAMPLER_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                         __attribute__((unused)) void * restrict dst,
                         __attribute__((unused)) const struct GFX20_SAMPLER_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->AnisotropicAlgorithm, 0, 0) |
      util_bitpack_sfixed(values->TextureLODBias, 1, 13, 8) |
      util_bitpack_uint(values->MinModeFilter, 14, 16) |
      util_bitpack_uint(values->MagModeFilter, 17, 19) |
      util_bitpack_uint(values->MipModeFilter, 20, 21) |
      util_bitpack_uint(values->CoarseLODQualityMode, 22, 26) |
      util_bitpack_uint(values->LODPreClampMode, 27, 28) |
      util_bitpack_uint(values->TextureBorderColorMode, 29, 29) |
      util_bitpack_uint(values->CPSLODCompensationEnable, 30, 30) |
      util_bitpack_uint(values->SamplerDisable, 31, 31);

   dw[1] =
      util_bitpack_uint(values->CubeSurfaceControlMode, 0, 0) |
      util_bitpack_uint(values->ShadowFunction, 1, 3) |
      util_bitpack_uint(values->ChromaKeyMode, 4, 4) |
      util_bitpack_uint(values->ChromaKeyIndex, 5, 6) |
      util_bitpack_uint(values->ChromaKeyEnable, 7, 7) |
      util_bitpack_ufixed(values->MaxLOD, 8, 19, 8) |
      util_bitpack_ufixed(values->MinLOD, 20, 31, 8);

   dw[2] =
      util_bitpack_uint(values->LODClampMagnificationMode, 0, 0) |
      util_bitpack_uint(values->SRGBDECODE, 1, 1) |
      util_bitpack_uint(values->ReturnFilterWeightforNullTexels, 2, 2) |
      util_bitpack_uint(values->ReturnFilterWeightforBorderTexels, 3, 3) |
      util_bitpack_uint(values->Forcegather4Behavior, 5, 5) |
      __gen_offset(values->BorderColorPointer, 6, 31);

   dw[3] =
      util_bitpack_uint(values->TCZAddressControlMode, 0, 2) |
      util_bitpack_uint(values->TCYAddressControlMode, 3, 5) |
      util_bitpack_uint(values->TCXAddressControlMode, 6, 8) |
      util_bitpack_uint(values->ReductionTypeEnable, 9, 9) |
      util_bitpack_uint(values->NonnormalizedCoordinateEnable, 10, 10) |
      util_bitpack_uint(values->TrilinearFilterQuality, 11, 12) |
      util_bitpack_uint(values->RAddressMinFilterRoundingEnable, 13, 13) |
      util_bitpack_uint(values->RAddressMagFilterRoundingEnable, 14, 14) |
      util_bitpack_uint(values->VAddressMinFilterRoundingEnable, 15, 15) |
      util_bitpack_uint(values->VAddressMagFilterRoundingEnable, 16, 16) |
      util_bitpack_uint(values->UAddressMinFilterRoundingEnable, 17, 17) |
      util_bitpack_uint(values->UAddressMagFilterRoundingEnable, 18, 18) |
      util_bitpack_uint(values->MaximumAnisotropy, 19, 21) |
      util_bitpack_uint(values->ReductionType, 22, 23) |
      util_bitpack_uint(values->AllowLowQualityLODCalculation, 24, 24) |
      util_bitpack_uint(values->LowQualityFilter, 26, 26);
}

#define GFX20_SAMPLER_STATE_8X8_AVS_COEFFICIENTS_length      8
struct GFX20_SAMPLER_STATE_8X8_AVS_COEFFICIENTS {
   float                                Table0FilterCoefficient[4];
   float                                Table1FilterCoefficient0[4];
   float                                Table1FilterCoefficient1[4];
};

static inline __attribute__((always_inline)) void
GFX20_SAMPLER_STATE_8X8_AVS_COEFFICIENTS_pack(__attribute__((unused)) __gen_user_data *data,
                                              __attribute__((unused)) void * restrict dst,
                                              __attribute__((unused)) const struct GFX20_SAMPLER_STATE_8X8_AVS_COEFFICIENTS * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_sfixed(values->Table0FilterCoefficient[0], 0, 7, 6) |
      util_bitpack_sfixed(values->Table0FilterCoefficient[1], 8, 15, 6) |
      util_bitpack_sfixed(values->Table0FilterCoefficient[2], 16, 23, 6) |
      util_bitpack_sfixed(values->Table0FilterCoefficient[3], 24, 31, 6) |
      util_bitpack_sfixed(values->Table1FilterCoefficient0[0], 0, 7, 6) |
      util_bitpack_sfixed(values->Table1FilterCoefficient1[0], 8, 15, 6);

   dw[1] =
      util_bitpack_sfixed(values->Table1FilterCoefficient0[1], 0, 7, 6) |
      util_bitpack_sfixed(values->Table1FilterCoefficient1[1], 8, 15, 6);

   dw[2] =
      util_bitpack_sfixed(values->Table1FilterCoefficient0[2], 0, 7, 6) |
      util_bitpack_sfixed(values->Table1FilterCoefficient1[2], 8, 15, 6);

   dw[3] =
      util_bitpack_sfixed(values->Table1FilterCoefficient0[3], 0, 7, 6) |
      util_bitpack_sfixed(values->Table1FilterCoefficient1[3], 8, 15, 6);

   dw[4] = 0;

   dw[5] = 0;

   dw[6] = 0;

   dw[7] = 0;
}

#define GFX20_SCISSOR_RECT_length              2
struct GFX20_SCISSOR_RECT {
   uint32_t                             ScissorRectangleXMin;
   uint32_t                             ScissorRectangleYMin;
   uint32_t                             ScissorRectangleXMax;
   uint32_t                             ScissorRectangleYMax;
};

static inline __attribute__((always_inline)) void
GFX20_SCISSOR_RECT_pack(__attribute__((unused)) __gen_user_data *data,
                        __attribute__((unused)) void * restrict dst,
                        __attribute__((unused)) const struct GFX20_SCISSOR_RECT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->ScissorRectangleXMin, 0, 15) |
      util_bitpack_uint(values->ScissorRectangleYMin, 16, 31);

   dw[1] =
      util_bitpack_uint(values->ScissorRectangleXMax, 0, 15) |
      util_bitpack_uint(values->ScissorRectangleYMax, 16, 31);
}

#define GFX20_SFC_AVS_CHROMA_COEFF_TABLE_BODY_length     64
struct GFX20_SFC_AVS_CHROMA_COEFF_TABLE_BODY {
   float                                Table1XFilterCoefficientn2;
   float                                Table1YFilterCoefficientn2;
   float                                Table1XFilterCoefficientn3;
   float                                Table1YFilterCoefficientn3;
   float                                Table1XFilterCoefficientn4;
   float                                Table1YFilterCoefficientn4;
   float                                Table1XFilterCoefficientn5;
   float                                Table1YFilterCoefficientn5;
   struct GFX20_CHROMA_FILTER_COEFFICIENTS_ARRAY FilterCoefficients[31];
};

static inline __attribute__((always_inline)) void
GFX20_SFC_AVS_CHROMA_COEFF_TABLE_BODY_pack(__attribute__((unused)) __gen_user_data *data,
                                           __attribute__((unused)) void * restrict dst,
                                           __attribute__((unused)) const struct GFX20_SFC_AVS_CHROMA_COEFF_TABLE_BODY * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_sfixed(values->Table1XFilterCoefficientn2, 0, 7, 6) |
      util_bitpack_sfixed(values->Table1YFilterCoefficientn2, 8, 15, 6) |
      util_bitpack_sfixed(values->Table1XFilterCoefficientn3, 16, 23, 6) |
      util_bitpack_sfixed(values->Table1YFilterCoefficientn3, 24, 31, 6);

   dw[1] =
      util_bitpack_sfixed(values->Table1XFilterCoefficientn4, 0, 7, 6) |
      util_bitpack_sfixed(values->Table1YFilterCoefficientn4, 8, 15, 6) |
      util_bitpack_sfixed(values->Table1XFilterCoefficientn5, 16, 23, 6) |
      util_bitpack_sfixed(values->Table1YFilterCoefficientn5, 24, 31, 6);

   GFX20_CHROMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[2], &values->FilterCoefficients[0]);

   GFX20_CHROMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[4], &values->FilterCoefficients[1]);

   GFX20_CHROMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[6], &values->FilterCoefficients[2]);

   GFX20_CHROMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[8], &values->FilterCoefficients[3]);

   GFX20_CHROMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[10], &values->FilterCoefficients[4]);

   GFX20_CHROMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[12], &values->FilterCoefficients[5]);

   GFX20_CHROMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[14], &values->FilterCoefficients[6]);

   GFX20_CHROMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[16], &values->FilterCoefficients[7]);

   GFX20_CHROMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[18], &values->FilterCoefficients[8]);

   GFX20_CHROMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[20], &values->FilterCoefficients[9]);

   GFX20_CHROMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[22], &values->FilterCoefficients[10]);

   GFX20_CHROMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[24], &values->FilterCoefficients[11]);

   GFX20_CHROMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[26], &values->FilterCoefficients[12]);

   GFX20_CHROMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[28], &values->FilterCoefficients[13]);

   GFX20_CHROMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[30], &values->FilterCoefficients[14]);

   GFX20_CHROMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[32], &values->FilterCoefficients[15]);

   GFX20_CHROMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[34], &values->FilterCoefficients[16]);

   GFX20_CHROMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[36], &values->FilterCoefficients[17]);

   GFX20_CHROMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[38], &values->FilterCoefficients[18]);

   GFX20_CHROMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[40], &values->FilterCoefficients[19]);

   GFX20_CHROMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[42], &values->FilterCoefficients[20]);

   GFX20_CHROMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[44], &values->FilterCoefficients[21]);

   GFX20_CHROMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[46], &values->FilterCoefficients[22]);

   GFX20_CHROMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[48], &values->FilterCoefficients[23]);

   GFX20_CHROMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[50], &values->FilterCoefficients[24]);

   GFX20_CHROMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[52], &values->FilterCoefficients[25]);

   GFX20_CHROMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[54], &values->FilterCoefficients[26]);

   GFX20_CHROMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[56], &values->FilterCoefficients[27]);

   GFX20_CHROMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[58], &values->FilterCoefficients[28]);

   GFX20_CHROMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[60], &values->FilterCoefficients[29]);

   GFX20_CHROMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[62], &values->FilterCoefficients[30]);
}

#define GFX20_SFC_AVS_LUMA_COEFF_TABLE_BODY_length    128
struct GFX20_SFC_AVS_LUMA_COEFF_TABLE_BODY {
   float                                Table0XFilterCoefficientn0;
   float                                Table0YFilterCoefficientn0;
   float                                Table0XFilterCoefficientn1;
   float                                Table0YFilterCoefficientn1;
   float                                Table0XFilterCoefficientn2;
   float                                Table0YFilterCoefficientn2;
   float                                Table0XFilterCoefficientn3;
   float                                Table0YFilterCoefficientn3;
   float                                Table0XFilterCoefficientn4;
   float                                Table0YFilterCoefficientn4;
   float                                Table0XFilterCoefficientn5;
   float                                Table0YFilterCoefficientn5;
   float                                Table0XFilterCoefficientn6;
   float                                Table0YFilterCoefficientn6;
   float                                Table0XFilterCoefficientn7;
   float                                Table0YFilterCoefficientn7;
   struct GFX20_LUMA_FILTER_COEFFICIENTS_ARRAY FilterCoefficients[31];
};

static inline __attribute__((always_inline)) void
GFX20_SFC_AVS_LUMA_COEFF_TABLE_BODY_pack(__attribute__((unused)) __gen_user_data *data,
                                         __attribute__((unused)) void * restrict dst,
                                         __attribute__((unused)) const struct GFX20_SFC_AVS_LUMA_COEFF_TABLE_BODY * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_sfixed(values->Table0XFilterCoefficientn0, 0, 7, 6) |
      util_bitpack_sfixed(values->Table0YFilterCoefficientn0, 8, 15, 6) |
      util_bitpack_sfixed(values->Table0XFilterCoefficientn1, 16, 23, 6) |
      util_bitpack_sfixed(values->Table0YFilterCoefficientn1, 24, 31, 6);

   dw[1] =
      util_bitpack_sfixed(values->Table0XFilterCoefficientn2, 0, 7, 6) |
      util_bitpack_sfixed(values->Table0YFilterCoefficientn2, 8, 15, 6) |
      util_bitpack_sfixed(values->Table0XFilterCoefficientn3, 16, 23, 6) |
      util_bitpack_sfixed(values->Table0YFilterCoefficientn3, 24, 31, 6);

   dw[2] =
      util_bitpack_sfixed(values->Table0XFilterCoefficientn4, 0, 7, 6) |
      util_bitpack_sfixed(values->Table0YFilterCoefficientn4, 8, 15, 6) |
      util_bitpack_sfixed(values->Table0XFilterCoefficientn5, 16, 23, 6) |
      util_bitpack_sfixed(values->Table0YFilterCoefficientn5, 24, 31, 6);

   dw[3] =
      util_bitpack_sfixed(values->Table0XFilterCoefficientn6, 0, 7, 6) |
      util_bitpack_sfixed(values->Table0YFilterCoefficientn6, 8, 15, 6) |
      util_bitpack_sfixed(values->Table0XFilterCoefficientn7, 16, 23, 6) |
      util_bitpack_sfixed(values->Table0YFilterCoefficientn7, 24, 31, 6);

   GFX20_LUMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[4], &values->FilterCoefficients[0]);

   GFX20_LUMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[8], &values->FilterCoefficients[1]);

   GFX20_LUMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[12], &values->FilterCoefficients[2]);

   GFX20_LUMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[16], &values->FilterCoefficients[3]);

   GFX20_LUMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[20], &values->FilterCoefficients[4]);

   GFX20_LUMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[24], &values->FilterCoefficients[5]);

   GFX20_LUMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[28], &values->FilterCoefficients[6]);

   GFX20_LUMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[32], &values->FilterCoefficients[7]);

   GFX20_LUMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[36], &values->FilterCoefficients[8]);

   GFX20_LUMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[40], &values->FilterCoefficients[9]);

   GFX20_LUMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[44], &values->FilterCoefficients[10]);

   GFX20_LUMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[48], &values->FilterCoefficients[11]);

   GFX20_LUMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[52], &values->FilterCoefficients[12]);

   GFX20_LUMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[56], &values->FilterCoefficients[13]);

   GFX20_LUMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[60], &values->FilterCoefficients[14]);

   GFX20_LUMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[64], &values->FilterCoefficients[15]);

   GFX20_LUMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[68], &values->FilterCoefficients[16]);

   GFX20_LUMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[72], &values->FilterCoefficients[17]);

   GFX20_LUMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[76], &values->FilterCoefficients[18]);

   GFX20_LUMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[80], &values->FilterCoefficients[19]);

   GFX20_LUMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[84], &values->FilterCoefficients[20]);

   GFX20_LUMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[88], &values->FilterCoefficients[21]);

   GFX20_LUMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[92], &values->FilterCoefficients[22]);

   GFX20_LUMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[96], &values->FilterCoefficients[23]);

   GFX20_LUMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[100], &values->FilterCoefficients[24]);

   GFX20_LUMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[104], &values->FilterCoefficients[25]);

   GFX20_LUMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[108], &values->FilterCoefficients[26]);

   GFX20_LUMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[112], &values->FilterCoefficients[27]);

   GFX20_LUMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[116], &values->FilterCoefficients[28]);

   GFX20_LUMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[120], &values->FilterCoefficients[29]);

   GFX20_LUMA_FILTER_COEFFICIENTS_ARRAY_pack(data, &dw[124], &values->FilterCoefficients[30]);
}

#define GFX20_SFC_AVS_STATE_BODY_length        3
struct GFX20_SFC_AVS_STATE_BODY {
   uint32_t                             TransitionAreawith8Pixels;
   uint32_t                             TransitionAreawith4Pixels;
   uint32_t                             SharpnessLevel;
   uint32_t                             MaxDerivative8Pixels;
   uint32_t                             MaxDerivative4Pixels;
   uint32_t                             InputVerticalSiting;
#define _18                                      1
#define _28                                      2
#define _38                                      3
#define _48                                      4
#define _58                                      5
#define _68                                      6
#define _78                                      7
#define _88                                      8
};

static inline __attribute__((always_inline)) void
GFX20_SFC_AVS_STATE_BODY_pack(__attribute__((unused)) __gen_user_data *data,
                              __attribute__((unused)) void * restrict dst,
                              __attribute__((unused)) const struct GFX20_SFC_AVS_STATE_BODY * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->TransitionAreawith8Pixels, 0, 2) |
      util_bitpack_uint(values->TransitionAreawith4Pixels, 4, 6) |
      util_bitpack_uint(values->SharpnessLevel, 24, 31);

   dw[1] =
      util_bitpack_uint(values->MaxDerivative8Pixels, 0, 7) |
      util_bitpack_uint(values->MaxDerivative4Pixels, 16, 23);

   dw[2] =
      util_bitpack_uint(values->InputVerticalSiting, 0, 3);
}

#define GFX20_SFC_IEF_STATE_BODY_length       23
struct GFX20_SFC_IEF_STATE_BODY {
   uint32_t                             GainFactor;
   uint32_t                             WeakEdgeThreshold;
   uint32_t                             StrongEdgeThreshold;
   float                                R3xCoefficient;
   float                                R3cCoefficient;
   uint32_t                             GlobalNoiseEstimation;
   uint32_t                             NonEdgeWeight;
   uint32_t                             RegularWeight;
   uint32_t                             StrongEdgeWeight;
   float                                R5xCoefficient;
   float                                R5cxCoefficient;
   float                                R5cCoefficient;
   float                                STDSinalpha;
   float                                STDCosalpha;
   uint32_t                             Sat_Max;
   uint32_t                             Hue_Max;
   float                                S3U;
   uint32_t                             DiamondMargin;
   bool                                 VY_STD_Enable;
   uint32_t                             U_Mid;
   uint32_t                             V_Mid;
   int32_t                              Diamond_dv;
   uint32_t                             Diamond_Th;
   float                                Diamond_alpha;
   uint32_t                             HS_margin;
   int32_t                              Diamond_du;
   uint32_t                             SkinDetailFactor;
#define DetailRevealed                           0
#define NotDetailRevealed                        1
   uint32_t                             Y_point_1;
   uint32_t                             Y_point_2;
   uint32_t                             Y_point_3;
   uint32_t                             Y_point_4;
   float                                INV_Margin_VYL;
   float                                INV_Margin_VYU;
   uint32_t                             P0L;
   uint32_t                             P1L;
   uint32_t                             P2L;
   uint32_t                             P3L;
   uint32_t                             B0L;
   uint32_t                             B1L;
   uint32_t                             B2L;
   uint32_t                             B3L;
   float                                S0L;
   float                                Y_Slope_2;
   float                                S1L;
   float                                S2L;
   float                                S3L;
   uint32_t                             P0U;
   uint32_t                             P1U;
   float                                Y_Slope1;
   uint32_t                             P2U;
   uint32_t                             P3U;
   uint32_t                             B0U;
   uint32_t                             B1U;
   uint32_t                             B2U;
   uint32_t                             B3U;
   float                                S0U;
   float                                S1U;
   float                                S2U;
   bool                                 TransformEnable;
   bool                                 YUVChannelSwap;
   float                                C0;
   float                                C1;
   float                                C2;
   float                                C3;
   float                                C4;
   float                                C5;
   float                                C6;
   float                                C7;
   float                                C8;
   float                                OffsetIn1;
   float                                OffsetOut1;
   float                                OffsetIn2;
   float                                OffsetOut2;
   float                                OffsetIn3;
   float                                OffsetOut3;
};

static inline __attribute__((always_inline)) void
GFX20_SFC_IEF_STATE_BODY_pack(__attribute__((unused)) __gen_user_data *data,
                              __attribute__((unused)) void * restrict dst,
                              __attribute__((unused)) const struct GFX20_SFC_IEF_STATE_BODY * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->GainFactor, 0, 5) |
      util_bitpack_uint(values->WeakEdgeThreshold, 6, 11) |
      util_bitpack_uint(values->StrongEdgeThreshold, 12, 17) |
      util_bitpack_ufixed(values->R3xCoefficient, 18, 22, 5) |
      util_bitpack_ufixed(values->R3cCoefficient, 23, 27, 5);

   dw[1] =
      util_bitpack_uint(values->GlobalNoiseEstimation, 0, 7) |
      util_bitpack_uint(values->NonEdgeWeight, 8, 10) |
      util_bitpack_uint(values->RegularWeight, 11, 13) |
      util_bitpack_uint(values->StrongEdgeWeight, 14, 16) |
      util_bitpack_ufixed(values->R5xCoefficient, 17, 21, 5) |
      util_bitpack_ufixed(values->R5cxCoefficient, 22, 26, 5) |
      util_bitpack_ufixed(values->R5cCoefficient, 27, 31, 5);

   dw[2] =
      util_bitpack_sfixed(values->STDSinalpha, 0, 7, 7) |
      util_bitpack_sfixed(values->STDCosalpha, 8, 15, 7) |
      util_bitpack_uint(values->Sat_Max, 16, 21) |
      util_bitpack_uint(values->Hue_Max, 22, 27);

   dw[3] =
      util_bitpack_sfixed(values->S3U, 0, 10, 8) |
      util_bitpack_uint(values->DiamondMargin, 12, 14) |
      util_bitpack_uint(values->VY_STD_Enable, 15, 15) |
      util_bitpack_uint(values->U_Mid, 16, 23) |
      util_bitpack_uint(values->V_Mid, 24, 31);

   dw[4] =
      util_bitpack_sint(values->Diamond_dv, 0, 6) |
      util_bitpack_uint(values->Diamond_Th, 7, 12) |
      util_bitpack_ufixed(values->Diamond_alpha, 13, 20, 6) |
      util_bitpack_uint(values->HS_margin, 21, 23) |
      util_bitpack_sint(values->Diamond_du, 24, 30) |
      util_bitpack_uint(values->SkinDetailFactor, 31, 31);

   dw[5] =
      util_bitpack_uint(values->Y_point_1, 0, 7) |
      util_bitpack_uint(values->Y_point_2, 8, 15) |
      util_bitpack_uint(values->Y_point_3, 16, 23) |
      util_bitpack_uint(values->Y_point_4, 24, 31);

   dw[6] =
      util_bitpack_ufixed(values->INV_Margin_VYL, 0, 15, 16);

   dw[7] =
      util_bitpack_ufixed(values->INV_Margin_VYU, 0, 15, 16) |
      util_bitpack_uint(values->P0L, 16, 23) |
      util_bitpack_uint(values->P1L, 24, 31);

   dw[8] =
      util_bitpack_uint(values->P2L, 0, 7) |
      util_bitpack_uint(values->P3L, 8, 15) |
      util_bitpack_uint(values->B0L, 16, 23) |
      util_bitpack_uint(values->B1L, 24, 31);

   dw[9] =
      util_bitpack_uint(values->B2L, 0, 7) |
      util_bitpack_uint(values->B3L, 8, 15) |
      util_bitpack_sfixed(values->S0L, 16, 26, 8) |
      util_bitpack_ufixed(values->Y_Slope_2, 27, 31, 3);

   dw[10] =
      util_bitpack_sfixed(values->S1L, 0, 10, 8) |
      util_bitpack_sfixed(values->S2L, 11, 21, 8);

   dw[11] =
      util_bitpack_sfixed(values->S3L, 0, 10, 8) |
      util_bitpack_uint(values->P0U, 11, 18) |
      util_bitpack_uint(values->P1U, 19, 26) |
      util_bitpack_ufixed(values->Y_Slope1, 27, 31, 3);

   dw[12] =
      util_bitpack_uint(values->P2U, 0, 7) |
      util_bitpack_uint(values->P3U, 8, 15) |
      util_bitpack_uint(values->B0U, 16, 23) |
      util_bitpack_uint(values->B1U, 24, 31);

   dw[13] =
      util_bitpack_uint(values->B2U, 0, 7) |
      util_bitpack_uint(values->B3U, 8, 15) |
      util_bitpack_sfixed(values->S0U, 16, 26, 8);

   dw[14] =
      util_bitpack_sfixed(values->S1U, 0, 10, 8) |
      util_bitpack_sfixed(values->S2U, 11, 21, 8);

   dw[15] =
      util_bitpack_uint(values->TransformEnable, 0, 0) |
      util_bitpack_uint(values->YUVChannelSwap, 1, 1) |
      util_bitpack_sfixed(values->C0, 3, 15, 10) |
      util_bitpack_sfixed(values->C1, 16, 28, 10);

   dw[16] =
      util_bitpack_sfixed(values->C2, 0, 12, 10) |
      util_bitpack_sfixed(values->C3, 13, 25, 10);

   dw[17] =
      util_bitpack_sfixed(values->C4, 0, 12, 10) |
      util_bitpack_sfixed(values->C5, 13, 25, 10);

   dw[18] =
      util_bitpack_sfixed(values->C6, 0, 12, 10) |
      util_bitpack_sfixed(values->C7, 13, 25, 10);

   dw[19] =
      util_bitpack_sfixed(values->C8, 0, 12, 10);

   dw[20] =
      util_bitpack_sfixed(values->OffsetIn1, 0, 10, 8) |
      util_bitpack_sfixed(values->OffsetOut1, 11, 21, 8);

   dw[21] =
      util_bitpack_sfixed(values->OffsetIn2, 0, 10, 8) |
      util_bitpack_sfixed(values->OffsetOut2, 11, 21, 8);

   dw[22] =
      util_bitpack_sfixed(values->OffsetIn3, 0, 10, 8) |
      util_bitpack_sfixed(values->OffsetOut3, 11, 21, 8);
}

#define GFX20_SFC_LOCK_BODY_length             1
struct GFX20_SFC_LOCK_BODY {
   uint32_t                             VESFCPipeSelect;
   bool                                 PreScaledOutputSurfaceOutputEnable;
};

static inline __attribute__((always_inline)) void
GFX20_SFC_LOCK_BODY_pack(__attribute__((unused)) __gen_user_data *data,
                         __attribute__((unused)) void * restrict dst,
                         __attribute__((unused)) const struct GFX20_SFC_LOCK_BODY * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->VESFCPipeSelect, 0, 0) |
      util_bitpack_uint(values->PreScaledOutputSurfaceOutputEnable, 1, 1);
}

#define GFX20_SF_CLIP_VIEWPORT_length         16
struct GFX20_SF_CLIP_VIEWPORT {
   float                                ViewportMatrixElementm00;
   float                                ViewportMatrixElementm11;
   float                                ViewportMatrixElementm22;
   float                                ViewportMatrixElementm30;
   float                                ViewportMatrixElementm31;
   float                                ViewportMatrixElementm32;
   float                                XMinClipGuardband;
   float                                XMaxClipGuardband;
   float                                YMinClipGuardband;
   float                                YMaxClipGuardband;
   float                                XMinViewPort;
   float                                XMaxViewPort;
   float                                YMinViewPort;
   float                                YMaxViewPort;
};

static inline __attribute__((always_inline)) void
GFX20_SF_CLIP_VIEWPORT_pack(__attribute__((unused)) __gen_user_data *data,
                            __attribute__((unused)) void * restrict dst,
                            __attribute__((unused)) const struct GFX20_SF_CLIP_VIEWPORT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_float(values->ViewportMatrixElementm00);

   dw[1] =
      util_bitpack_float(values->ViewportMatrixElementm11);

   dw[2] =
      util_bitpack_float(values->ViewportMatrixElementm22);

   dw[3] =
      util_bitpack_float(values->ViewportMatrixElementm30);

   dw[4] =
      util_bitpack_float(values->ViewportMatrixElementm31);

   dw[5] =
      util_bitpack_float(values->ViewportMatrixElementm32);

   dw[6] = 0;

   dw[7] = 0;

   dw[8] =
      util_bitpack_float(values->XMinClipGuardband);

   dw[9] =
      util_bitpack_float(values->XMaxClipGuardband);

   dw[10] =
      util_bitpack_float(values->YMinClipGuardband);

   dw[11] =
      util_bitpack_float(values->YMaxClipGuardband);

   dw[12] =
      util_bitpack_float(values->XMinViewPort);

   dw[13] =
      util_bitpack_float(values->XMaxViewPort);

   dw[14] =
      util_bitpack_float(values->YMinViewPort);

   dw[15] =
      util_bitpack_float(values->YMaxViewPort);
}

#define GFX20_SF_OUTPUT_ATTRIBUTE_DETAIL_length      1
struct GFX20_SF_OUTPUT_ATTRIBUTE_DETAIL {
   uint32_t                             SourceAttribute;
   uint32_t                             SwizzleSelect;
#define INPUTATTR                                0
#define INPUTATTR_FACING                         1
#define INPUTATTR_W                              2
#define INPUTATTR_FACING_W                       3
   uint32_t                             ConstantSource;
#define CONST_0000                               0
#define CONST_0001_FLOAT                         1
#define CONST_1111_FLOAT                         2
#define PRIM_ID                                  3
   uint32_t                             SwizzleControlMode;
   bool                                 ComponentOverrideX;
   bool                                 ComponentOverrideY;
   bool                                 ComponentOverrideZ;
   bool                                 ComponentOverrideW;
};

static inline __attribute__((always_inline)) void
GFX20_SF_OUTPUT_ATTRIBUTE_DETAIL_pack(__attribute__((unused)) __gen_user_data *data,
                                      __attribute__((unused)) void * restrict dst,
                                      __attribute__((unused)) const struct GFX20_SF_OUTPUT_ATTRIBUTE_DETAIL * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->SourceAttribute, 0, 4) |
      util_bitpack_uint(values->SwizzleSelect, 6, 7) |
      util_bitpack_uint(values->ConstantSource, 9, 10) |
      util_bitpack_uint(values->SwizzleControlMode, 11, 11) |
      util_bitpack_uint(values->ComponentOverrideX, 12, 12) |
      util_bitpack_uint(values->ComponentOverrideY, 13, 13) |
      util_bitpack_uint(values->ComponentOverrideZ, 14, 14) |
      util_bitpack_uint(values->ComponentOverrideW, 15, 15);
}

#define GFX20_SLICE_HASH_TABLE_length        224
struct GFX20_SLICE_HASH_TABLE {
   uint32_t                             Entry[7][16][16];
};

static inline __attribute__((always_inline)) void
GFX20_SLICE_HASH_TABLE_pack(__attribute__((unused)) __gen_user_data *data,
                            __attribute__((unused)) void * restrict dst,
                            __attribute__((unused)) const struct GFX20_SLICE_HASH_TABLE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->Entry[0][0][0], 0, 3) |
      util_bitpack_uint(values->Entry[0][0][1], 4, 7) |
      util_bitpack_uint(values->Entry[0][0][2], 8, 11) |
      util_bitpack_uint(values->Entry[0][0][3], 12, 15) |
      util_bitpack_uint(values->Entry[0][0][4], 16, 19) |
      util_bitpack_uint(values->Entry[0][0][5], 20, 23) |
      util_bitpack_uint(values->Entry[0][0][6], 24, 27) |
      util_bitpack_uint(values->Entry[0][0][7], 28, 31);

   dw[1] =
      util_bitpack_uint(values->Entry[0][0][8], 0, 3) |
      util_bitpack_uint(values->Entry[0][0][9], 4, 7) |
      util_bitpack_uint(values->Entry[0][0][10], 8, 11) |
      util_bitpack_uint(values->Entry[0][0][11], 12, 15) |
      util_bitpack_uint(values->Entry[0][0][12], 16, 19) |
      util_bitpack_uint(values->Entry[0][0][13], 20, 23) |
      util_bitpack_uint(values->Entry[0][0][14], 24, 27) |
      util_bitpack_uint(values->Entry[0][0][15], 28, 31);

   dw[2] =
      util_bitpack_uint(values->Entry[0][1][0], 0, 3) |
      util_bitpack_uint(values->Entry[0][1][1], 4, 7) |
      util_bitpack_uint(values->Entry[0][1][2], 8, 11) |
      util_bitpack_uint(values->Entry[0][1][3], 12, 15) |
      util_bitpack_uint(values->Entry[0][1][4], 16, 19) |
      util_bitpack_uint(values->Entry[0][1][5], 20, 23) |
      util_bitpack_uint(values->Entry[0][1][6], 24, 27) |
      util_bitpack_uint(values->Entry[0][1][7], 28, 31);

   dw[3] =
      util_bitpack_uint(values->Entry[0][1][8], 0, 3) |
      util_bitpack_uint(values->Entry[0][1][9], 4, 7) |
      util_bitpack_uint(values->Entry[0][1][10], 8, 11) |
      util_bitpack_uint(values->Entry[0][1][11], 12, 15) |
      util_bitpack_uint(values->Entry[0][1][12], 16, 19) |
      util_bitpack_uint(values->Entry[0][1][13], 20, 23) |
      util_bitpack_uint(values->Entry[0][1][14], 24, 27) |
      util_bitpack_uint(values->Entry[0][1][15], 28, 31);

   dw[4] =
      util_bitpack_uint(values->Entry[0][2][0], 0, 3) |
      util_bitpack_uint(values->Entry[0][2][1], 4, 7) |
      util_bitpack_uint(values->Entry[0][2][2], 8, 11) |
      util_bitpack_uint(values->Entry[0][2][3], 12, 15) |
      util_bitpack_uint(values->Entry[0][2][4], 16, 19) |
      util_bitpack_uint(values->Entry[0][2][5], 20, 23) |
      util_bitpack_uint(values->Entry[0][2][6], 24, 27) |
      util_bitpack_uint(values->Entry[0][2][7], 28, 31);

   dw[5] =
      util_bitpack_uint(values->Entry[0][2][8], 0, 3) |
      util_bitpack_uint(values->Entry[0][2][9], 4, 7) |
      util_bitpack_uint(values->Entry[0][2][10], 8, 11) |
      util_bitpack_uint(values->Entry[0][2][11], 12, 15) |
      util_bitpack_uint(values->Entry[0][2][12], 16, 19) |
      util_bitpack_uint(values->Entry[0][2][13], 20, 23) |
      util_bitpack_uint(values->Entry[0][2][14], 24, 27) |
      util_bitpack_uint(values->Entry[0][2][15], 28, 31);

   dw[6] =
      util_bitpack_uint(values->Entry[0][3][0], 0, 3) |
      util_bitpack_uint(values->Entry[0][3][1], 4, 7) |
      util_bitpack_uint(values->Entry[0][3][2], 8, 11) |
      util_bitpack_uint(values->Entry[0][3][3], 12, 15) |
      util_bitpack_uint(values->Entry[0][3][4], 16, 19) |
      util_bitpack_uint(values->Entry[0][3][5], 20, 23) |
      util_bitpack_uint(values->Entry[0][3][6], 24, 27) |
      util_bitpack_uint(values->Entry[0][3][7], 28, 31);

   dw[7] =
      util_bitpack_uint(values->Entry[0][3][8], 0, 3) |
      util_bitpack_uint(values->Entry[0][3][9], 4, 7) |
      util_bitpack_uint(values->Entry[0][3][10], 8, 11) |
      util_bitpack_uint(values->Entry[0][3][11], 12, 15) |
      util_bitpack_uint(values->Entry[0][3][12], 16, 19) |
      util_bitpack_uint(values->Entry[0][3][13], 20, 23) |
      util_bitpack_uint(values->Entry[0][3][14], 24, 27) |
      util_bitpack_uint(values->Entry[0][3][15], 28, 31);

   dw[8] =
      util_bitpack_uint(values->Entry[0][4][0], 0, 3) |
      util_bitpack_uint(values->Entry[0][4][1], 4, 7) |
      util_bitpack_uint(values->Entry[0][4][2], 8, 11) |
      util_bitpack_uint(values->Entry[0][4][3], 12, 15) |
      util_bitpack_uint(values->Entry[0][4][4], 16, 19) |
      util_bitpack_uint(values->Entry[0][4][5], 20, 23) |
      util_bitpack_uint(values->Entry[0][4][6], 24, 27) |
      util_bitpack_uint(values->Entry[0][4][7], 28, 31);

   dw[9] =
      util_bitpack_uint(values->Entry[0][4][8], 0, 3) |
      util_bitpack_uint(values->Entry[0][4][9], 4, 7) |
      util_bitpack_uint(values->Entry[0][4][10], 8, 11) |
      util_bitpack_uint(values->Entry[0][4][11], 12, 15) |
      util_bitpack_uint(values->Entry[0][4][12], 16, 19) |
      util_bitpack_uint(values->Entry[0][4][13], 20, 23) |
      util_bitpack_uint(values->Entry[0][4][14], 24, 27) |
      util_bitpack_uint(values->Entry[0][4][15], 28, 31);

   dw[10] =
      util_bitpack_uint(values->Entry[0][5][0], 0, 3) |
      util_bitpack_uint(values->Entry[0][5][1], 4, 7) |
      util_bitpack_uint(values->Entry[0][5][2], 8, 11) |
      util_bitpack_uint(values->Entry[0][5][3], 12, 15) |
      util_bitpack_uint(values->Entry[0][5][4], 16, 19) |
      util_bitpack_uint(values->Entry[0][5][5], 20, 23) |
      util_bitpack_uint(values->Entry[0][5][6], 24, 27) |
      util_bitpack_uint(values->Entry[0][5][7], 28, 31);

   dw[11] =
      util_bitpack_uint(values->Entry[0][5][8], 0, 3) |
      util_bitpack_uint(values->Entry[0][5][9], 4, 7) |
      util_bitpack_uint(values->Entry[0][5][10], 8, 11) |
      util_bitpack_uint(values->Entry[0][5][11], 12, 15) |
      util_bitpack_uint(values->Entry[0][5][12], 16, 19) |
      util_bitpack_uint(values->Entry[0][5][13], 20, 23) |
      util_bitpack_uint(values->Entry[0][5][14], 24, 27) |
      util_bitpack_uint(values->Entry[0][5][15], 28, 31);

   dw[12] =
      util_bitpack_uint(values->Entry[0][6][0], 0, 3) |
      util_bitpack_uint(values->Entry[0][6][1], 4, 7) |
      util_bitpack_uint(values->Entry[0][6][2], 8, 11) |
      util_bitpack_uint(values->Entry[0][6][3], 12, 15) |
      util_bitpack_uint(values->Entry[0][6][4], 16, 19) |
      util_bitpack_uint(values->Entry[0][6][5], 20, 23) |
      util_bitpack_uint(values->Entry[0][6][6], 24, 27) |
      util_bitpack_uint(values->Entry[0][6][7], 28, 31);

   dw[13] =
      util_bitpack_uint(values->Entry[0][6][8], 0, 3) |
      util_bitpack_uint(values->Entry[0][6][9], 4, 7) |
      util_bitpack_uint(values->Entry[0][6][10], 8, 11) |
      util_bitpack_uint(values->Entry[0][6][11], 12, 15) |
      util_bitpack_uint(values->Entry[0][6][12], 16, 19) |
      util_bitpack_uint(values->Entry[0][6][13], 20, 23) |
      util_bitpack_uint(values->Entry[0][6][14], 24, 27) |
      util_bitpack_uint(values->Entry[0][6][15], 28, 31);

   dw[14] =
      util_bitpack_uint(values->Entry[0][7][0], 0, 3) |
      util_bitpack_uint(values->Entry[0][7][1], 4, 7) |
      util_bitpack_uint(values->Entry[0][7][2], 8, 11) |
      util_bitpack_uint(values->Entry[0][7][3], 12, 15) |
      util_bitpack_uint(values->Entry[0][7][4], 16, 19) |
      util_bitpack_uint(values->Entry[0][7][5], 20, 23) |
      util_bitpack_uint(values->Entry[0][7][6], 24, 27) |
      util_bitpack_uint(values->Entry[0][7][7], 28, 31);

   dw[15] =
      util_bitpack_uint(values->Entry[0][7][8], 0, 3) |
      util_bitpack_uint(values->Entry[0][7][9], 4, 7) |
      util_bitpack_uint(values->Entry[0][7][10], 8, 11) |
      util_bitpack_uint(values->Entry[0][7][11], 12, 15) |
      util_bitpack_uint(values->Entry[0][7][12], 16, 19) |
      util_bitpack_uint(values->Entry[0][7][13], 20, 23) |
      util_bitpack_uint(values->Entry[0][7][14], 24, 27) |
      util_bitpack_uint(values->Entry[0][7][15], 28, 31);

   dw[16] =
      util_bitpack_uint(values->Entry[0][8][0], 0, 3) |
      util_bitpack_uint(values->Entry[0][8][1], 4, 7) |
      util_bitpack_uint(values->Entry[0][8][2], 8, 11) |
      util_bitpack_uint(values->Entry[0][8][3], 12, 15) |
      util_bitpack_uint(values->Entry[0][8][4], 16, 19) |
      util_bitpack_uint(values->Entry[0][8][5], 20, 23) |
      util_bitpack_uint(values->Entry[0][8][6], 24, 27) |
      util_bitpack_uint(values->Entry[0][8][7], 28, 31);

   dw[17] =
      util_bitpack_uint(values->Entry[0][8][8], 0, 3) |
      util_bitpack_uint(values->Entry[0][8][9], 4, 7) |
      util_bitpack_uint(values->Entry[0][8][10], 8, 11) |
      util_bitpack_uint(values->Entry[0][8][11], 12, 15) |
      util_bitpack_uint(values->Entry[0][8][12], 16, 19) |
      util_bitpack_uint(values->Entry[0][8][13], 20, 23) |
      util_bitpack_uint(values->Entry[0][8][14], 24, 27) |
      util_bitpack_uint(values->Entry[0][8][15], 28, 31);

   dw[18] =
      util_bitpack_uint(values->Entry[0][9][0], 0, 3) |
      util_bitpack_uint(values->Entry[0][9][1], 4, 7) |
      util_bitpack_uint(values->Entry[0][9][2], 8, 11) |
      util_bitpack_uint(values->Entry[0][9][3], 12, 15) |
      util_bitpack_uint(values->Entry[0][9][4], 16, 19) |
      util_bitpack_uint(values->Entry[0][9][5], 20, 23) |
      util_bitpack_uint(values->Entry[0][9][6], 24, 27) |
      util_bitpack_uint(values->Entry[0][9][7], 28, 31);

   dw[19] =
      util_bitpack_uint(values->Entry[0][9][8], 0, 3) |
      util_bitpack_uint(values->Entry[0][9][9], 4, 7) |
      util_bitpack_uint(values->Entry[0][9][10], 8, 11) |
      util_bitpack_uint(values->Entry[0][9][11], 12, 15) |
      util_bitpack_uint(values->Entry[0][9][12], 16, 19) |
      util_bitpack_uint(values->Entry[0][9][13], 20, 23) |
      util_bitpack_uint(values->Entry[0][9][14], 24, 27) |
      util_bitpack_uint(values->Entry[0][9][15], 28, 31);

   dw[20] =
      util_bitpack_uint(values->Entry[0][10][0], 0, 3) |
      util_bitpack_uint(values->Entry[0][10][1], 4, 7) |
      util_bitpack_uint(values->Entry[0][10][2], 8, 11) |
      util_bitpack_uint(values->Entry[0][10][3], 12, 15) |
      util_bitpack_uint(values->Entry[0][10][4], 16, 19) |
      util_bitpack_uint(values->Entry[0][10][5], 20, 23) |
      util_bitpack_uint(values->Entry[0][10][6], 24, 27) |
      util_bitpack_uint(values->Entry[0][10][7], 28, 31);

   dw[21] =
      util_bitpack_uint(values->Entry[0][10][8], 0, 3) |
      util_bitpack_uint(values->Entry[0][10][9], 4, 7) |
      util_bitpack_uint(values->Entry[0][10][10], 8, 11) |
      util_bitpack_uint(values->Entry[0][10][11], 12, 15) |
      util_bitpack_uint(values->Entry[0][10][12], 16, 19) |
      util_bitpack_uint(values->Entry[0][10][13], 20, 23) |
      util_bitpack_uint(values->Entry[0][10][14], 24, 27) |
      util_bitpack_uint(values->Entry[0][10][15], 28, 31);

   dw[22] =
      util_bitpack_uint(values->Entry[0][11][0], 0, 3) |
      util_bitpack_uint(values->Entry[0][11][1], 4, 7) |
      util_bitpack_uint(values->Entry[0][11][2], 8, 11) |
      util_bitpack_uint(values->Entry[0][11][3], 12, 15) |
      util_bitpack_uint(values->Entry[0][11][4], 16, 19) |
      util_bitpack_uint(values->Entry[0][11][5], 20, 23) |
      util_bitpack_uint(values->Entry[0][11][6], 24, 27) |
      util_bitpack_uint(values->Entry[0][11][7], 28, 31);

   dw[23] =
      util_bitpack_uint(values->Entry[0][11][8], 0, 3) |
      util_bitpack_uint(values->Entry[0][11][9], 4, 7) |
      util_bitpack_uint(values->Entry[0][11][10], 8, 11) |
      util_bitpack_uint(values->Entry[0][11][11], 12, 15) |
      util_bitpack_uint(values->Entry[0][11][12], 16, 19) |
      util_bitpack_uint(values->Entry[0][11][13], 20, 23) |
      util_bitpack_uint(values->Entry[0][11][14], 24, 27) |
      util_bitpack_uint(values->Entry[0][11][15], 28, 31);

   dw[24] =
      util_bitpack_uint(values->Entry[0][12][0], 0, 3) |
      util_bitpack_uint(values->Entry[0][12][1], 4, 7) |
      util_bitpack_uint(values->Entry[0][12][2], 8, 11) |
      util_bitpack_uint(values->Entry[0][12][3], 12, 15) |
      util_bitpack_uint(values->Entry[0][12][4], 16, 19) |
      util_bitpack_uint(values->Entry[0][12][5], 20, 23) |
      util_bitpack_uint(values->Entry[0][12][6], 24, 27) |
      util_bitpack_uint(values->Entry[0][12][7], 28, 31);

   dw[25] =
      util_bitpack_uint(values->Entry[0][12][8], 0, 3) |
      util_bitpack_uint(values->Entry[0][12][9], 4, 7) |
      util_bitpack_uint(values->Entry[0][12][10], 8, 11) |
      util_bitpack_uint(values->Entry[0][12][11], 12, 15) |
      util_bitpack_uint(values->Entry[0][12][12], 16, 19) |
      util_bitpack_uint(values->Entry[0][12][13], 20, 23) |
      util_bitpack_uint(values->Entry[0][12][14], 24, 27) |
      util_bitpack_uint(values->Entry[0][12][15], 28, 31);

   dw[26] =
      util_bitpack_uint(values->Entry[0][13][0], 0, 3) |
      util_bitpack_uint(values->Entry[0][13][1], 4, 7) |
      util_bitpack_uint(values->Entry[0][13][2], 8, 11) |
      util_bitpack_uint(values->Entry[0][13][3], 12, 15) |
      util_bitpack_uint(values->Entry[0][13][4], 16, 19) |
      util_bitpack_uint(values->Entry[0][13][5], 20, 23) |
      util_bitpack_uint(values->Entry[0][13][6], 24, 27) |
      util_bitpack_uint(values->Entry[0][13][7], 28, 31);

   dw[27] =
      util_bitpack_uint(values->Entry[0][13][8], 0, 3) |
      util_bitpack_uint(values->Entry[0][13][9], 4, 7) |
      util_bitpack_uint(values->Entry[0][13][10], 8, 11) |
      util_bitpack_uint(values->Entry[0][13][11], 12, 15) |
      util_bitpack_uint(values->Entry[0][13][12], 16, 19) |
      util_bitpack_uint(values->Entry[0][13][13], 20, 23) |
      util_bitpack_uint(values->Entry[0][13][14], 24, 27) |
      util_bitpack_uint(values->Entry[0][13][15], 28, 31);

   dw[28] =
      util_bitpack_uint(values->Entry[0][14][0], 0, 3) |
      util_bitpack_uint(values->Entry[0][14][1], 4, 7) |
      util_bitpack_uint(values->Entry[0][14][2], 8, 11) |
      util_bitpack_uint(values->Entry[0][14][3], 12, 15) |
      util_bitpack_uint(values->Entry[0][14][4], 16, 19) |
      util_bitpack_uint(values->Entry[0][14][5], 20, 23) |
      util_bitpack_uint(values->Entry[0][14][6], 24, 27) |
      util_bitpack_uint(values->Entry[0][14][7], 28, 31);

   dw[29] =
      util_bitpack_uint(values->Entry[0][14][8], 0, 3) |
      util_bitpack_uint(values->Entry[0][14][9], 4, 7) |
      util_bitpack_uint(values->Entry[0][14][10], 8, 11) |
      util_bitpack_uint(values->Entry[0][14][11], 12, 15) |
      util_bitpack_uint(values->Entry[0][14][12], 16, 19) |
      util_bitpack_uint(values->Entry[0][14][13], 20, 23) |
      util_bitpack_uint(values->Entry[0][14][14], 24, 27) |
      util_bitpack_uint(values->Entry[0][14][15], 28, 31);

   dw[30] =
      util_bitpack_uint(values->Entry[0][15][0], 0, 3) |
      util_bitpack_uint(values->Entry[0][15][1], 4, 7) |
      util_bitpack_uint(values->Entry[0][15][2], 8, 11) |
      util_bitpack_uint(values->Entry[0][15][3], 12, 15) |
      util_bitpack_uint(values->Entry[0][15][4], 16, 19) |
      util_bitpack_uint(values->Entry[0][15][5], 20, 23) |
      util_bitpack_uint(values->Entry[0][15][6], 24, 27) |
      util_bitpack_uint(values->Entry[0][15][7], 28, 31);

   dw[31] =
      util_bitpack_uint(values->Entry[0][15][8], 0, 3) |
      util_bitpack_uint(values->Entry[0][15][9], 4, 7) |
      util_bitpack_uint(values->Entry[0][15][10], 8, 11) |
      util_bitpack_uint(values->Entry[0][15][11], 12, 15) |
      util_bitpack_uint(values->Entry[0][15][12], 16, 19) |
      util_bitpack_uint(values->Entry[0][15][13], 20, 23) |
      util_bitpack_uint(values->Entry[0][15][14], 24, 27) |
      util_bitpack_uint(values->Entry[0][15][15], 28, 31);

   dw[32] =
      util_bitpack_uint(values->Entry[1][0][0], 0, 3) |
      util_bitpack_uint(values->Entry[1][0][1], 4, 7) |
      util_bitpack_uint(values->Entry[1][0][2], 8, 11) |
      util_bitpack_uint(values->Entry[1][0][3], 12, 15) |
      util_bitpack_uint(values->Entry[1][0][4], 16, 19) |
      util_bitpack_uint(values->Entry[1][0][5], 20, 23) |
      util_bitpack_uint(values->Entry[1][0][6], 24, 27) |
      util_bitpack_uint(values->Entry[1][0][7], 28, 31);

   dw[33] =
      util_bitpack_uint(values->Entry[1][0][8], 0, 3) |
      util_bitpack_uint(values->Entry[1][0][9], 4, 7) |
      util_bitpack_uint(values->Entry[1][0][10], 8, 11) |
      util_bitpack_uint(values->Entry[1][0][11], 12, 15) |
      util_bitpack_uint(values->Entry[1][0][12], 16, 19) |
      util_bitpack_uint(values->Entry[1][0][13], 20, 23) |
      util_bitpack_uint(values->Entry[1][0][14], 24, 27) |
      util_bitpack_uint(values->Entry[1][0][15], 28, 31);

   dw[34] =
      util_bitpack_uint(values->Entry[1][1][0], 0, 3) |
      util_bitpack_uint(values->Entry[1][1][1], 4, 7) |
      util_bitpack_uint(values->Entry[1][1][2], 8, 11) |
      util_bitpack_uint(values->Entry[1][1][3], 12, 15) |
      util_bitpack_uint(values->Entry[1][1][4], 16, 19) |
      util_bitpack_uint(values->Entry[1][1][5], 20, 23) |
      util_bitpack_uint(values->Entry[1][1][6], 24, 27) |
      util_bitpack_uint(values->Entry[1][1][7], 28, 31);

   dw[35] =
      util_bitpack_uint(values->Entry[1][1][8], 0, 3) |
      util_bitpack_uint(values->Entry[1][1][9], 4, 7) |
      util_bitpack_uint(values->Entry[1][1][10], 8, 11) |
      util_bitpack_uint(values->Entry[1][1][11], 12, 15) |
      util_bitpack_uint(values->Entry[1][1][12], 16, 19) |
      util_bitpack_uint(values->Entry[1][1][13], 20, 23) |
      util_bitpack_uint(values->Entry[1][1][14], 24, 27) |
      util_bitpack_uint(values->Entry[1][1][15], 28, 31);

   dw[36] =
      util_bitpack_uint(values->Entry[1][2][0], 0, 3) |
      util_bitpack_uint(values->Entry[1][2][1], 4, 7) |
      util_bitpack_uint(values->Entry[1][2][2], 8, 11) |
      util_bitpack_uint(values->Entry[1][2][3], 12, 15) |
      util_bitpack_uint(values->Entry[1][2][4], 16, 19) |
      util_bitpack_uint(values->Entry[1][2][5], 20, 23) |
      util_bitpack_uint(values->Entry[1][2][6], 24, 27) |
      util_bitpack_uint(values->Entry[1][2][7], 28, 31);

   dw[37] =
      util_bitpack_uint(values->Entry[1][2][8], 0, 3) |
      util_bitpack_uint(values->Entry[1][2][9], 4, 7) |
      util_bitpack_uint(values->Entry[1][2][10], 8, 11) |
      util_bitpack_uint(values->Entry[1][2][11], 12, 15) |
      util_bitpack_uint(values->Entry[1][2][12], 16, 19) |
      util_bitpack_uint(values->Entry[1][2][13], 20, 23) |
      util_bitpack_uint(values->Entry[1][2][14], 24, 27) |
      util_bitpack_uint(values->Entry[1][2][15], 28, 31);

   dw[38] =
      util_bitpack_uint(values->Entry[1][3][0], 0, 3) |
      util_bitpack_uint(values->Entry[1][3][1], 4, 7) |
      util_bitpack_uint(values->Entry[1][3][2], 8, 11) |
      util_bitpack_uint(values->Entry[1][3][3], 12, 15) |
      util_bitpack_uint(values->Entry[1][3][4], 16, 19) |
      util_bitpack_uint(values->Entry[1][3][5], 20, 23) |
      util_bitpack_uint(values->Entry[1][3][6], 24, 27) |
      util_bitpack_uint(values->Entry[1][3][7], 28, 31);

   dw[39] =
      util_bitpack_uint(values->Entry[1][3][8], 0, 3) |
      util_bitpack_uint(values->Entry[1][3][9], 4, 7) |
      util_bitpack_uint(values->Entry[1][3][10], 8, 11) |
      util_bitpack_uint(values->Entry[1][3][11], 12, 15) |
      util_bitpack_uint(values->Entry[1][3][12], 16, 19) |
      util_bitpack_uint(values->Entry[1][3][13], 20, 23) |
      util_bitpack_uint(values->Entry[1][3][14], 24, 27) |
      util_bitpack_uint(values->Entry[1][3][15], 28, 31);

   dw[40] =
      util_bitpack_uint(values->Entry[1][4][0], 0, 3) |
      util_bitpack_uint(values->Entry[1][4][1], 4, 7) |
      util_bitpack_uint(values->Entry[1][4][2], 8, 11) |
      util_bitpack_uint(values->Entry[1][4][3], 12, 15) |
      util_bitpack_uint(values->Entry[1][4][4], 16, 19) |
      util_bitpack_uint(values->Entry[1][4][5], 20, 23) |
      util_bitpack_uint(values->Entry[1][4][6], 24, 27) |
      util_bitpack_uint(values->Entry[1][4][7], 28, 31);

   dw[41] =
      util_bitpack_uint(values->Entry[1][4][8], 0, 3) |
      util_bitpack_uint(values->Entry[1][4][9], 4, 7) |
      util_bitpack_uint(values->Entry[1][4][10], 8, 11) |
      util_bitpack_uint(values->Entry[1][4][11], 12, 15) |
      util_bitpack_uint(values->Entry[1][4][12], 16, 19) |
      util_bitpack_uint(values->Entry[1][4][13], 20, 23) |
      util_bitpack_uint(values->Entry[1][4][14], 24, 27) |
      util_bitpack_uint(values->Entry[1][4][15], 28, 31);

   dw[42] =
      util_bitpack_uint(values->Entry[1][5][0], 0, 3) |
      util_bitpack_uint(values->Entry[1][5][1], 4, 7) |
      util_bitpack_uint(values->Entry[1][5][2], 8, 11) |
      util_bitpack_uint(values->Entry[1][5][3], 12, 15) |
      util_bitpack_uint(values->Entry[1][5][4], 16, 19) |
      util_bitpack_uint(values->Entry[1][5][5], 20, 23) |
      util_bitpack_uint(values->Entry[1][5][6], 24, 27) |
      util_bitpack_uint(values->Entry[1][5][7], 28, 31);

   dw[43] =
      util_bitpack_uint(values->Entry[1][5][8], 0, 3) |
      util_bitpack_uint(values->Entry[1][5][9], 4, 7) |
      util_bitpack_uint(values->Entry[1][5][10], 8, 11) |
      util_bitpack_uint(values->Entry[1][5][11], 12, 15) |
      util_bitpack_uint(values->Entry[1][5][12], 16, 19) |
      util_bitpack_uint(values->Entry[1][5][13], 20, 23) |
      util_bitpack_uint(values->Entry[1][5][14], 24, 27) |
      util_bitpack_uint(values->Entry[1][5][15], 28, 31);

   dw[44] =
      util_bitpack_uint(values->Entry[1][6][0], 0, 3) |
      util_bitpack_uint(values->Entry[1][6][1], 4, 7) |
      util_bitpack_uint(values->Entry[1][6][2], 8, 11) |
      util_bitpack_uint(values->Entry[1][6][3], 12, 15) |
      util_bitpack_uint(values->Entry[1][6][4], 16, 19) |
      util_bitpack_uint(values->Entry[1][6][5], 20, 23) |
      util_bitpack_uint(values->Entry[1][6][6], 24, 27) |
      util_bitpack_uint(values->Entry[1][6][7], 28, 31);

   dw[45] =
      util_bitpack_uint(values->Entry[1][6][8], 0, 3) |
      util_bitpack_uint(values->Entry[1][6][9], 4, 7) |
      util_bitpack_uint(values->Entry[1][6][10], 8, 11) |
      util_bitpack_uint(values->Entry[1][6][11], 12, 15) |
      util_bitpack_uint(values->Entry[1][6][12], 16, 19) |
      util_bitpack_uint(values->Entry[1][6][13], 20, 23) |
      util_bitpack_uint(values->Entry[1][6][14], 24, 27) |
      util_bitpack_uint(values->Entry[1][6][15], 28, 31);

   dw[46] =
      util_bitpack_uint(values->Entry[1][7][0], 0, 3) |
      util_bitpack_uint(values->Entry[1][7][1], 4, 7) |
      util_bitpack_uint(values->Entry[1][7][2], 8, 11) |
      util_bitpack_uint(values->Entry[1][7][3], 12, 15) |
      util_bitpack_uint(values->Entry[1][7][4], 16, 19) |
      util_bitpack_uint(values->Entry[1][7][5], 20, 23) |
      util_bitpack_uint(values->Entry[1][7][6], 24, 27) |
      util_bitpack_uint(values->Entry[1][7][7], 28, 31);

   dw[47] =
      util_bitpack_uint(values->Entry[1][7][8], 0, 3) |
      util_bitpack_uint(values->Entry[1][7][9], 4, 7) |
      util_bitpack_uint(values->Entry[1][7][10], 8, 11) |
      util_bitpack_uint(values->Entry[1][7][11], 12, 15) |
      util_bitpack_uint(values->Entry[1][7][12], 16, 19) |
      util_bitpack_uint(values->Entry[1][7][13], 20, 23) |
      util_bitpack_uint(values->Entry[1][7][14], 24, 27) |
      util_bitpack_uint(values->Entry[1][7][15], 28, 31);

   dw[48] =
      util_bitpack_uint(values->Entry[1][8][0], 0, 3) |
      util_bitpack_uint(values->Entry[1][8][1], 4, 7) |
      util_bitpack_uint(values->Entry[1][8][2], 8, 11) |
      util_bitpack_uint(values->Entry[1][8][3], 12, 15) |
      util_bitpack_uint(values->Entry[1][8][4], 16, 19) |
      util_bitpack_uint(values->Entry[1][8][5], 20, 23) |
      util_bitpack_uint(values->Entry[1][8][6], 24, 27) |
      util_bitpack_uint(values->Entry[1][8][7], 28, 31);

   dw[49] =
      util_bitpack_uint(values->Entry[1][8][8], 0, 3) |
      util_bitpack_uint(values->Entry[1][8][9], 4, 7) |
      util_bitpack_uint(values->Entry[1][8][10], 8, 11) |
      util_bitpack_uint(values->Entry[1][8][11], 12, 15) |
      util_bitpack_uint(values->Entry[1][8][12], 16, 19) |
      util_bitpack_uint(values->Entry[1][8][13], 20, 23) |
      util_bitpack_uint(values->Entry[1][8][14], 24, 27) |
      util_bitpack_uint(values->Entry[1][8][15], 28, 31);

   dw[50] =
      util_bitpack_uint(values->Entry[1][9][0], 0, 3) |
      util_bitpack_uint(values->Entry[1][9][1], 4, 7) |
      util_bitpack_uint(values->Entry[1][9][2], 8, 11) |
      util_bitpack_uint(values->Entry[1][9][3], 12, 15) |
      util_bitpack_uint(values->Entry[1][9][4], 16, 19) |
      util_bitpack_uint(values->Entry[1][9][5], 20, 23) |
      util_bitpack_uint(values->Entry[1][9][6], 24, 27) |
      util_bitpack_uint(values->Entry[1][9][7], 28, 31);

   dw[51] =
      util_bitpack_uint(values->Entry[1][9][8], 0, 3) |
      util_bitpack_uint(values->Entry[1][9][9], 4, 7) |
      util_bitpack_uint(values->Entry[1][9][10], 8, 11) |
      util_bitpack_uint(values->Entry[1][9][11], 12, 15) |
      util_bitpack_uint(values->Entry[1][9][12], 16, 19) |
      util_bitpack_uint(values->Entry[1][9][13], 20, 23) |
      util_bitpack_uint(values->Entry[1][9][14], 24, 27) |
      util_bitpack_uint(values->Entry[1][9][15], 28, 31);

   dw[52] =
      util_bitpack_uint(values->Entry[1][10][0], 0, 3) |
      util_bitpack_uint(values->Entry[1][10][1], 4, 7) |
      util_bitpack_uint(values->Entry[1][10][2], 8, 11) |
      util_bitpack_uint(values->Entry[1][10][3], 12, 15) |
      util_bitpack_uint(values->Entry[1][10][4], 16, 19) |
      util_bitpack_uint(values->Entry[1][10][5], 20, 23) |
      util_bitpack_uint(values->Entry[1][10][6], 24, 27) |
      util_bitpack_uint(values->Entry[1][10][7], 28, 31);

   dw[53] =
      util_bitpack_uint(values->Entry[1][10][8], 0, 3) |
      util_bitpack_uint(values->Entry[1][10][9], 4, 7) |
      util_bitpack_uint(values->Entry[1][10][10], 8, 11) |
      util_bitpack_uint(values->Entry[1][10][11], 12, 15) |
      util_bitpack_uint(values->Entry[1][10][12], 16, 19) |
      util_bitpack_uint(values->Entry[1][10][13], 20, 23) |
      util_bitpack_uint(values->Entry[1][10][14], 24, 27) |
      util_bitpack_uint(values->Entry[1][10][15], 28, 31);

   dw[54] =
      util_bitpack_uint(values->Entry[1][11][0], 0, 3) |
      util_bitpack_uint(values->Entry[1][11][1], 4, 7) |
      util_bitpack_uint(values->Entry[1][11][2], 8, 11) |
      util_bitpack_uint(values->Entry[1][11][3], 12, 15) |
      util_bitpack_uint(values->Entry[1][11][4], 16, 19) |
      util_bitpack_uint(values->Entry[1][11][5], 20, 23) |
      util_bitpack_uint(values->Entry[1][11][6], 24, 27) |
      util_bitpack_uint(values->Entry[1][11][7], 28, 31);

   dw[55] =
      util_bitpack_uint(values->Entry[1][11][8], 0, 3) |
      util_bitpack_uint(values->Entry[1][11][9], 4, 7) |
      util_bitpack_uint(values->Entry[1][11][10], 8, 11) |
      util_bitpack_uint(values->Entry[1][11][11], 12, 15) |
      util_bitpack_uint(values->Entry[1][11][12], 16, 19) |
      util_bitpack_uint(values->Entry[1][11][13], 20, 23) |
      util_bitpack_uint(values->Entry[1][11][14], 24, 27) |
      util_bitpack_uint(values->Entry[1][11][15], 28, 31);

   dw[56] =
      util_bitpack_uint(values->Entry[1][12][0], 0, 3) |
      util_bitpack_uint(values->Entry[1][12][1], 4, 7) |
      util_bitpack_uint(values->Entry[1][12][2], 8, 11) |
      util_bitpack_uint(values->Entry[1][12][3], 12, 15) |
      util_bitpack_uint(values->Entry[1][12][4], 16, 19) |
      util_bitpack_uint(values->Entry[1][12][5], 20, 23) |
      util_bitpack_uint(values->Entry[1][12][6], 24, 27) |
      util_bitpack_uint(values->Entry[1][12][7], 28, 31);

   dw[57] =
      util_bitpack_uint(values->Entry[1][12][8], 0, 3) |
      util_bitpack_uint(values->Entry[1][12][9], 4, 7) |
      util_bitpack_uint(values->Entry[1][12][10], 8, 11) |
      util_bitpack_uint(values->Entry[1][12][11], 12, 15) |
      util_bitpack_uint(values->Entry[1][12][12], 16, 19) |
      util_bitpack_uint(values->Entry[1][12][13], 20, 23) |
      util_bitpack_uint(values->Entry[1][12][14], 24, 27) |
      util_bitpack_uint(values->Entry[1][12][15], 28, 31);

   dw[58] =
      util_bitpack_uint(values->Entry[1][13][0], 0, 3) |
      util_bitpack_uint(values->Entry[1][13][1], 4, 7) |
      util_bitpack_uint(values->Entry[1][13][2], 8, 11) |
      util_bitpack_uint(values->Entry[1][13][3], 12, 15) |
      util_bitpack_uint(values->Entry[1][13][4], 16, 19) |
      util_bitpack_uint(values->Entry[1][13][5], 20, 23) |
      util_bitpack_uint(values->Entry[1][13][6], 24, 27) |
      util_bitpack_uint(values->Entry[1][13][7], 28, 31);

   dw[59] =
      util_bitpack_uint(values->Entry[1][13][8], 0, 3) |
      util_bitpack_uint(values->Entry[1][13][9], 4, 7) |
      util_bitpack_uint(values->Entry[1][13][10], 8, 11) |
      util_bitpack_uint(values->Entry[1][13][11], 12, 15) |
      util_bitpack_uint(values->Entry[1][13][12], 16, 19) |
      util_bitpack_uint(values->Entry[1][13][13], 20, 23) |
      util_bitpack_uint(values->Entry[1][13][14], 24, 27) |
      util_bitpack_uint(values->Entry[1][13][15], 28, 31);

   dw[60] =
      util_bitpack_uint(values->Entry[1][14][0], 0, 3) |
      util_bitpack_uint(values->Entry[1][14][1], 4, 7) |
      util_bitpack_uint(values->Entry[1][14][2], 8, 11) |
      util_bitpack_uint(values->Entry[1][14][3], 12, 15) |
      util_bitpack_uint(values->Entry[1][14][4], 16, 19) |
      util_bitpack_uint(values->Entry[1][14][5], 20, 23) |
      util_bitpack_uint(values->Entry[1][14][6], 24, 27) |
      util_bitpack_uint(values->Entry[1][14][7], 28, 31);

   dw[61] =
      util_bitpack_uint(values->Entry[1][14][8], 0, 3) |
      util_bitpack_uint(values->Entry[1][14][9], 4, 7) |
      util_bitpack_uint(values->Entry[1][14][10], 8, 11) |
      util_bitpack_uint(values->Entry[1][14][11], 12, 15) |
      util_bitpack_uint(values->Entry[1][14][12], 16, 19) |
      util_bitpack_uint(values->Entry[1][14][13], 20, 23) |
      util_bitpack_uint(values->Entry[1][14][14], 24, 27) |
      util_bitpack_uint(values->Entry[1][14][15], 28, 31);

   dw[62] =
      util_bitpack_uint(values->Entry[1][15][0], 0, 3) |
      util_bitpack_uint(values->Entry[1][15][1], 4, 7) |
      util_bitpack_uint(values->Entry[1][15][2], 8, 11) |
      util_bitpack_uint(values->Entry[1][15][3], 12, 15) |
      util_bitpack_uint(values->Entry[1][15][4], 16, 19) |
      util_bitpack_uint(values->Entry[1][15][5], 20, 23) |
      util_bitpack_uint(values->Entry[1][15][6], 24, 27) |
      util_bitpack_uint(values->Entry[1][15][7], 28, 31);

   dw[63] =
      util_bitpack_uint(values->Entry[1][15][8], 0, 3) |
      util_bitpack_uint(values->Entry[1][15][9], 4, 7) |
      util_bitpack_uint(values->Entry[1][15][10], 8, 11) |
      util_bitpack_uint(values->Entry[1][15][11], 12, 15) |
      util_bitpack_uint(values->Entry[1][15][12], 16, 19) |
      util_bitpack_uint(values->Entry[1][15][13], 20, 23) |
      util_bitpack_uint(values->Entry[1][15][14], 24, 27) |
      util_bitpack_uint(values->Entry[1][15][15], 28, 31);

   dw[64] =
      util_bitpack_uint(values->Entry[2][0][0], 0, 3) |
      util_bitpack_uint(values->Entry[2][0][1], 4, 7) |
      util_bitpack_uint(values->Entry[2][0][2], 8, 11) |
      util_bitpack_uint(values->Entry[2][0][3], 12, 15) |
      util_bitpack_uint(values->Entry[2][0][4], 16, 19) |
      util_bitpack_uint(values->Entry[2][0][5], 20, 23) |
      util_bitpack_uint(values->Entry[2][0][6], 24, 27) |
      util_bitpack_uint(values->Entry[2][0][7], 28, 31);

   dw[65] =
      util_bitpack_uint(values->Entry[2][0][8], 0, 3) |
      util_bitpack_uint(values->Entry[2][0][9], 4, 7) |
      util_bitpack_uint(values->Entry[2][0][10], 8, 11) |
      util_bitpack_uint(values->Entry[2][0][11], 12, 15) |
      util_bitpack_uint(values->Entry[2][0][12], 16, 19) |
      util_bitpack_uint(values->Entry[2][0][13], 20, 23) |
      util_bitpack_uint(values->Entry[2][0][14], 24, 27) |
      util_bitpack_uint(values->Entry[2][0][15], 28, 31);

   dw[66] =
      util_bitpack_uint(values->Entry[2][1][0], 0, 3) |
      util_bitpack_uint(values->Entry[2][1][1], 4, 7) |
      util_bitpack_uint(values->Entry[2][1][2], 8, 11) |
      util_bitpack_uint(values->Entry[2][1][3], 12, 15) |
      util_bitpack_uint(values->Entry[2][1][4], 16, 19) |
      util_bitpack_uint(values->Entry[2][1][5], 20, 23) |
      util_bitpack_uint(values->Entry[2][1][6], 24, 27) |
      util_bitpack_uint(values->Entry[2][1][7], 28, 31);

   dw[67] =
      util_bitpack_uint(values->Entry[2][1][8], 0, 3) |
      util_bitpack_uint(values->Entry[2][1][9], 4, 7) |
      util_bitpack_uint(values->Entry[2][1][10], 8, 11) |
      util_bitpack_uint(values->Entry[2][1][11], 12, 15) |
      util_bitpack_uint(values->Entry[2][1][12], 16, 19) |
      util_bitpack_uint(values->Entry[2][1][13], 20, 23) |
      util_bitpack_uint(values->Entry[2][1][14], 24, 27) |
      util_bitpack_uint(values->Entry[2][1][15], 28, 31);

   dw[68] =
      util_bitpack_uint(values->Entry[2][2][0], 0, 3) |
      util_bitpack_uint(values->Entry[2][2][1], 4, 7) |
      util_bitpack_uint(values->Entry[2][2][2], 8, 11) |
      util_bitpack_uint(values->Entry[2][2][3], 12, 15) |
      util_bitpack_uint(values->Entry[2][2][4], 16, 19) |
      util_bitpack_uint(values->Entry[2][2][5], 20, 23) |
      util_bitpack_uint(values->Entry[2][2][6], 24, 27) |
      util_bitpack_uint(values->Entry[2][2][7], 28, 31);

   dw[69] =
      util_bitpack_uint(values->Entry[2][2][8], 0, 3) |
      util_bitpack_uint(values->Entry[2][2][9], 4, 7) |
      util_bitpack_uint(values->Entry[2][2][10], 8, 11) |
      util_bitpack_uint(values->Entry[2][2][11], 12, 15) |
      util_bitpack_uint(values->Entry[2][2][12], 16, 19) |
      util_bitpack_uint(values->Entry[2][2][13], 20, 23) |
      util_bitpack_uint(values->Entry[2][2][14], 24, 27) |
      util_bitpack_uint(values->Entry[2][2][15], 28, 31);

   dw[70] =
      util_bitpack_uint(values->Entry[2][3][0], 0, 3) |
      util_bitpack_uint(values->Entry[2][3][1], 4, 7) |
      util_bitpack_uint(values->Entry[2][3][2], 8, 11) |
      util_bitpack_uint(values->Entry[2][3][3], 12, 15) |
      util_bitpack_uint(values->Entry[2][3][4], 16, 19) |
      util_bitpack_uint(values->Entry[2][3][5], 20, 23) |
      util_bitpack_uint(values->Entry[2][3][6], 24, 27) |
      util_bitpack_uint(values->Entry[2][3][7], 28, 31);

   dw[71] =
      util_bitpack_uint(values->Entry[2][3][8], 0, 3) |
      util_bitpack_uint(values->Entry[2][3][9], 4, 7) |
      util_bitpack_uint(values->Entry[2][3][10], 8, 11) |
      util_bitpack_uint(values->Entry[2][3][11], 12, 15) |
      util_bitpack_uint(values->Entry[2][3][12], 16, 19) |
      util_bitpack_uint(values->Entry[2][3][13], 20, 23) |
      util_bitpack_uint(values->Entry[2][3][14], 24, 27) |
      util_bitpack_uint(values->Entry[2][3][15], 28, 31);

   dw[72] =
      util_bitpack_uint(values->Entry[2][4][0], 0, 3) |
      util_bitpack_uint(values->Entry[2][4][1], 4, 7) |
      util_bitpack_uint(values->Entry[2][4][2], 8, 11) |
      util_bitpack_uint(values->Entry[2][4][3], 12, 15) |
      util_bitpack_uint(values->Entry[2][4][4], 16, 19) |
      util_bitpack_uint(values->Entry[2][4][5], 20, 23) |
      util_bitpack_uint(values->Entry[2][4][6], 24, 27) |
      util_bitpack_uint(values->Entry[2][4][7], 28, 31);

   dw[73] =
      util_bitpack_uint(values->Entry[2][4][8], 0, 3) |
      util_bitpack_uint(values->Entry[2][4][9], 4, 7) |
      util_bitpack_uint(values->Entry[2][4][10], 8, 11) |
      util_bitpack_uint(values->Entry[2][4][11], 12, 15) |
      util_bitpack_uint(values->Entry[2][4][12], 16, 19) |
      util_bitpack_uint(values->Entry[2][4][13], 20, 23) |
      util_bitpack_uint(values->Entry[2][4][14], 24, 27) |
      util_bitpack_uint(values->Entry[2][4][15], 28, 31);

   dw[74] =
      util_bitpack_uint(values->Entry[2][5][0], 0, 3) |
      util_bitpack_uint(values->Entry[2][5][1], 4, 7) |
      util_bitpack_uint(values->Entry[2][5][2], 8, 11) |
      util_bitpack_uint(values->Entry[2][5][3], 12, 15) |
      util_bitpack_uint(values->Entry[2][5][4], 16, 19) |
      util_bitpack_uint(values->Entry[2][5][5], 20, 23) |
      util_bitpack_uint(values->Entry[2][5][6], 24, 27) |
      util_bitpack_uint(values->Entry[2][5][7], 28, 31);

   dw[75] =
      util_bitpack_uint(values->Entry[2][5][8], 0, 3) |
      util_bitpack_uint(values->Entry[2][5][9], 4, 7) |
      util_bitpack_uint(values->Entry[2][5][10], 8, 11) |
      util_bitpack_uint(values->Entry[2][5][11], 12, 15) |
      util_bitpack_uint(values->Entry[2][5][12], 16, 19) |
      util_bitpack_uint(values->Entry[2][5][13], 20, 23) |
      util_bitpack_uint(values->Entry[2][5][14], 24, 27) |
      util_bitpack_uint(values->Entry[2][5][15], 28, 31);

   dw[76] =
      util_bitpack_uint(values->Entry[2][6][0], 0, 3) |
      util_bitpack_uint(values->Entry[2][6][1], 4, 7) |
      util_bitpack_uint(values->Entry[2][6][2], 8, 11) |
      util_bitpack_uint(values->Entry[2][6][3], 12, 15) |
      util_bitpack_uint(values->Entry[2][6][4], 16, 19) |
      util_bitpack_uint(values->Entry[2][6][5], 20, 23) |
      util_bitpack_uint(values->Entry[2][6][6], 24, 27) |
      util_bitpack_uint(values->Entry[2][6][7], 28, 31);

   dw[77] =
      util_bitpack_uint(values->Entry[2][6][8], 0, 3) |
      util_bitpack_uint(values->Entry[2][6][9], 4, 7) |
      util_bitpack_uint(values->Entry[2][6][10], 8, 11) |
      util_bitpack_uint(values->Entry[2][6][11], 12, 15) |
      util_bitpack_uint(values->Entry[2][6][12], 16, 19) |
      util_bitpack_uint(values->Entry[2][6][13], 20, 23) |
      util_bitpack_uint(values->Entry[2][6][14], 24, 27) |
      util_bitpack_uint(values->Entry[2][6][15], 28, 31);

   dw[78] =
      util_bitpack_uint(values->Entry[2][7][0], 0, 3) |
      util_bitpack_uint(values->Entry[2][7][1], 4, 7) |
      util_bitpack_uint(values->Entry[2][7][2], 8, 11) |
      util_bitpack_uint(values->Entry[2][7][3], 12, 15) |
      util_bitpack_uint(values->Entry[2][7][4], 16, 19) |
      util_bitpack_uint(values->Entry[2][7][5], 20, 23) |
      util_bitpack_uint(values->Entry[2][7][6], 24, 27) |
      util_bitpack_uint(values->Entry[2][7][7], 28, 31);

   dw[79] =
      util_bitpack_uint(values->Entry[2][7][8], 0, 3) |
      util_bitpack_uint(values->Entry[2][7][9], 4, 7) |
      util_bitpack_uint(values->Entry[2][7][10], 8, 11) |
      util_bitpack_uint(values->Entry[2][7][11], 12, 15) |
      util_bitpack_uint(values->Entry[2][7][12], 16, 19) |
      util_bitpack_uint(values->Entry[2][7][13], 20, 23) |
      util_bitpack_uint(values->Entry[2][7][14], 24, 27) |
      util_bitpack_uint(values->Entry[2][7][15], 28, 31);

   dw[80] =
      util_bitpack_uint(values->Entry[2][8][0], 0, 3) |
      util_bitpack_uint(values->Entry[2][8][1], 4, 7) |
      util_bitpack_uint(values->Entry[2][8][2], 8, 11) |
      util_bitpack_uint(values->Entry[2][8][3], 12, 15) |
      util_bitpack_uint(values->Entry[2][8][4], 16, 19) |
      util_bitpack_uint(values->Entry[2][8][5], 20, 23) |
      util_bitpack_uint(values->Entry[2][8][6], 24, 27) |
      util_bitpack_uint(values->Entry[2][8][7], 28, 31);

   dw[81] =
      util_bitpack_uint(values->Entry[2][8][8], 0, 3) |
      util_bitpack_uint(values->Entry[2][8][9], 4, 7) |
      util_bitpack_uint(values->Entry[2][8][10], 8, 11) |
      util_bitpack_uint(values->Entry[2][8][11], 12, 15) |
      util_bitpack_uint(values->Entry[2][8][12], 16, 19) |
      util_bitpack_uint(values->Entry[2][8][13], 20, 23) |
      util_bitpack_uint(values->Entry[2][8][14], 24, 27) |
      util_bitpack_uint(values->Entry[2][8][15], 28, 31);

   dw[82] =
      util_bitpack_uint(values->Entry[2][9][0], 0, 3) |
      util_bitpack_uint(values->Entry[2][9][1], 4, 7) |
      util_bitpack_uint(values->Entry[2][9][2], 8, 11) |
      util_bitpack_uint(values->Entry[2][9][3], 12, 15) |
      util_bitpack_uint(values->Entry[2][9][4], 16, 19) |
      util_bitpack_uint(values->Entry[2][9][5], 20, 23) |
      util_bitpack_uint(values->Entry[2][9][6], 24, 27) |
      util_bitpack_uint(values->Entry[2][9][7], 28, 31);

   dw[83] =
      util_bitpack_uint(values->Entry[2][9][8], 0, 3) |
      util_bitpack_uint(values->Entry[2][9][9], 4, 7) |
      util_bitpack_uint(values->Entry[2][9][10], 8, 11) |
      util_bitpack_uint(values->Entry[2][9][11], 12, 15) |
      util_bitpack_uint(values->Entry[2][9][12], 16, 19) |
      util_bitpack_uint(values->Entry[2][9][13], 20, 23) |
      util_bitpack_uint(values->Entry[2][9][14], 24, 27) |
      util_bitpack_uint(values->Entry[2][9][15], 28, 31);

   dw[84] =
      util_bitpack_uint(values->Entry[2][10][0], 0, 3) |
      util_bitpack_uint(values->Entry[2][10][1], 4, 7) |
      util_bitpack_uint(values->Entry[2][10][2], 8, 11) |
      util_bitpack_uint(values->Entry[2][10][3], 12, 15) |
      util_bitpack_uint(values->Entry[2][10][4], 16, 19) |
      util_bitpack_uint(values->Entry[2][10][5], 20, 23) |
      util_bitpack_uint(values->Entry[2][10][6], 24, 27) |
      util_bitpack_uint(values->Entry[2][10][7], 28, 31);

   dw[85] =
      util_bitpack_uint(values->Entry[2][10][8], 0, 3) |
      util_bitpack_uint(values->Entry[2][10][9], 4, 7) |
      util_bitpack_uint(values->Entry[2][10][10], 8, 11) |
      util_bitpack_uint(values->Entry[2][10][11], 12, 15) |
      util_bitpack_uint(values->Entry[2][10][12], 16, 19) |
      util_bitpack_uint(values->Entry[2][10][13], 20, 23) |
      util_bitpack_uint(values->Entry[2][10][14], 24, 27) |
      util_bitpack_uint(values->Entry[2][10][15], 28, 31);

   dw[86] =
      util_bitpack_uint(values->Entry[2][11][0], 0, 3) |
      util_bitpack_uint(values->Entry[2][11][1], 4, 7) |
      util_bitpack_uint(values->Entry[2][11][2], 8, 11) |
      util_bitpack_uint(values->Entry[2][11][3], 12, 15) |
      util_bitpack_uint(values->Entry[2][11][4], 16, 19) |
      util_bitpack_uint(values->Entry[2][11][5], 20, 23) |
      util_bitpack_uint(values->Entry[2][11][6], 24, 27) |
      util_bitpack_uint(values->Entry[2][11][7], 28, 31);

   dw[87] =
      util_bitpack_uint(values->Entry[2][11][8], 0, 3) |
      util_bitpack_uint(values->Entry[2][11][9], 4, 7) |
      util_bitpack_uint(values->Entry[2][11][10], 8, 11) |
      util_bitpack_uint(values->Entry[2][11][11], 12, 15) |
      util_bitpack_uint(values->Entry[2][11][12], 16, 19) |
      util_bitpack_uint(values->Entry[2][11][13], 20, 23) |
      util_bitpack_uint(values->Entry[2][11][14], 24, 27) |
      util_bitpack_uint(values->Entry[2][11][15], 28, 31);

   dw[88] =
      util_bitpack_uint(values->Entry[2][12][0], 0, 3) |
      util_bitpack_uint(values->Entry[2][12][1], 4, 7) |
      util_bitpack_uint(values->Entry[2][12][2], 8, 11) |
      util_bitpack_uint(values->Entry[2][12][3], 12, 15) |
      util_bitpack_uint(values->Entry[2][12][4], 16, 19) |
      util_bitpack_uint(values->Entry[2][12][5], 20, 23) |
      util_bitpack_uint(values->Entry[2][12][6], 24, 27) |
      util_bitpack_uint(values->Entry[2][12][7], 28, 31);

   dw[89] =
      util_bitpack_uint(values->Entry[2][12][8], 0, 3) |
      util_bitpack_uint(values->Entry[2][12][9], 4, 7) |
      util_bitpack_uint(values->Entry[2][12][10], 8, 11) |
      util_bitpack_uint(values->Entry[2][12][11], 12, 15) |
      util_bitpack_uint(values->Entry[2][12][12], 16, 19) |
      util_bitpack_uint(values->Entry[2][12][13], 20, 23) |
      util_bitpack_uint(values->Entry[2][12][14], 24, 27) |
      util_bitpack_uint(values->Entry[2][12][15], 28, 31);

   dw[90] =
      util_bitpack_uint(values->Entry[2][13][0], 0, 3) |
      util_bitpack_uint(values->Entry[2][13][1], 4, 7) |
      util_bitpack_uint(values->Entry[2][13][2], 8, 11) |
      util_bitpack_uint(values->Entry[2][13][3], 12, 15) |
      util_bitpack_uint(values->Entry[2][13][4], 16, 19) |
      util_bitpack_uint(values->Entry[2][13][5], 20, 23) |
      util_bitpack_uint(values->Entry[2][13][6], 24, 27) |
      util_bitpack_uint(values->Entry[2][13][7], 28, 31);

   dw[91] =
      util_bitpack_uint(values->Entry[2][13][8], 0, 3) |
      util_bitpack_uint(values->Entry[2][13][9], 4, 7) |
      util_bitpack_uint(values->Entry[2][13][10], 8, 11) |
      util_bitpack_uint(values->Entry[2][13][11], 12, 15) |
      util_bitpack_uint(values->Entry[2][13][12], 16, 19) |
      util_bitpack_uint(values->Entry[2][13][13], 20, 23) |
      util_bitpack_uint(values->Entry[2][13][14], 24, 27) |
      util_bitpack_uint(values->Entry[2][13][15], 28, 31);

   dw[92] =
      util_bitpack_uint(values->Entry[2][14][0], 0, 3) |
      util_bitpack_uint(values->Entry[2][14][1], 4, 7) |
      util_bitpack_uint(values->Entry[2][14][2], 8, 11) |
      util_bitpack_uint(values->Entry[2][14][3], 12, 15) |
      util_bitpack_uint(values->Entry[2][14][4], 16, 19) |
      util_bitpack_uint(values->Entry[2][14][5], 20, 23) |
      util_bitpack_uint(values->Entry[2][14][6], 24, 27) |
      util_bitpack_uint(values->Entry[2][14][7], 28, 31);

   dw[93] =
      util_bitpack_uint(values->Entry[2][14][8], 0, 3) |
      util_bitpack_uint(values->Entry[2][14][9], 4, 7) |
      util_bitpack_uint(values->Entry[2][14][10], 8, 11) |
      util_bitpack_uint(values->Entry[2][14][11], 12, 15) |
      util_bitpack_uint(values->Entry[2][14][12], 16, 19) |
      util_bitpack_uint(values->Entry[2][14][13], 20, 23) |
      util_bitpack_uint(values->Entry[2][14][14], 24, 27) |
      util_bitpack_uint(values->Entry[2][14][15], 28, 31);

   dw[94] =
      util_bitpack_uint(values->Entry[2][15][0], 0, 3) |
      util_bitpack_uint(values->Entry[2][15][1], 4, 7) |
      util_bitpack_uint(values->Entry[2][15][2], 8, 11) |
      util_bitpack_uint(values->Entry[2][15][3], 12, 15) |
      util_bitpack_uint(values->Entry[2][15][4], 16, 19) |
      util_bitpack_uint(values->Entry[2][15][5], 20, 23) |
      util_bitpack_uint(values->Entry[2][15][6], 24, 27) |
      util_bitpack_uint(values->Entry[2][15][7], 28, 31);

   dw[95] =
      util_bitpack_uint(values->Entry[2][15][8], 0, 3) |
      util_bitpack_uint(values->Entry[2][15][9], 4, 7) |
      util_bitpack_uint(values->Entry[2][15][10], 8, 11) |
      util_bitpack_uint(values->Entry[2][15][11], 12, 15) |
      util_bitpack_uint(values->Entry[2][15][12], 16, 19) |
      util_bitpack_uint(values->Entry[2][15][13], 20, 23) |
      util_bitpack_uint(values->Entry[2][15][14], 24, 27) |
      util_bitpack_uint(values->Entry[2][15][15], 28, 31);

   dw[96] =
      util_bitpack_uint(values->Entry[3][0][0], 0, 3) |
      util_bitpack_uint(values->Entry[3][0][1], 4, 7) |
      util_bitpack_uint(values->Entry[3][0][2], 8, 11) |
      util_bitpack_uint(values->Entry[3][0][3], 12, 15) |
      util_bitpack_uint(values->Entry[3][0][4], 16, 19) |
      util_bitpack_uint(values->Entry[3][0][5], 20, 23) |
      util_bitpack_uint(values->Entry[3][0][6], 24, 27) |
      util_bitpack_uint(values->Entry[3][0][7], 28, 31);

   dw[97] =
      util_bitpack_uint(values->Entry[3][0][8], 0, 3) |
      util_bitpack_uint(values->Entry[3][0][9], 4, 7) |
      util_bitpack_uint(values->Entry[3][0][10], 8, 11) |
      util_bitpack_uint(values->Entry[3][0][11], 12, 15) |
      util_bitpack_uint(values->Entry[3][0][12], 16, 19) |
      util_bitpack_uint(values->Entry[3][0][13], 20, 23) |
      util_bitpack_uint(values->Entry[3][0][14], 24, 27) |
      util_bitpack_uint(values->Entry[3][0][15], 28, 31);

   dw[98] =
      util_bitpack_uint(values->Entry[3][1][0], 0, 3) |
      util_bitpack_uint(values->Entry[3][1][1], 4, 7) |
      util_bitpack_uint(values->Entry[3][1][2], 8, 11) |
      util_bitpack_uint(values->Entry[3][1][3], 12, 15) |
      util_bitpack_uint(values->Entry[3][1][4], 16, 19) |
      util_bitpack_uint(values->Entry[3][1][5], 20, 23) |
      util_bitpack_uint(values->Entry[3][1][6], 24, 27) |
      util_bitpack_uint(values->Entry[3][1][7], 28, 31);

   dw[99] =
      util_bitpack_uint(values->Entry[3][1][8], 0, 3) |
      util_bitpack_uint(values->Entry[3][1][9], 4, 7) |
      util_bitpack_uint(values->Entry[3][1][10], 8, 11) |
      util_bitpack_uint(values->Entry[3][1][11], 12, 15) |
      util_bitpack_uint(values->Entry[3][1][12], 16, 19) |
      util_bitpack_uint(values->Entry[3][1][13], 20, 23) |
      util_bitpack_uint(values->Entry[3][1][14], 24, 27) |
      util_bitpack_uint(values->Entry[3][1][15], 28, 31);

   dw[100] =
      util_bitpack_uint(values->Entry[3][2][0], 0, 3) |
      util_bitpack_uint(values->Entry[3][2][1], 4, 7) |
      util_bitpack_uint(values->Entry[3][2][2], 8, 11) |
      util_bitpack_uint(values->Entry[3][2][3], 12, 15) |
      util_bitpack_uint(values->Entry[3][2][4], 16, 19) |
      util_bitpack_uint(values->Entry[3][2][5], 20, 23) |
      util_bitpack_uint(values->Entry[3][2][6], 24, 27) |
      util_bitpack_uint(values->Entry[3][2][7], 28, 31);

   dw[101] =
      util_bitpack_uint(values->Entry[3][2][8], 0, 3) |
      util_bitpack_uint(values->Entry[3][2][9], 4, 7) |
      util_bitpack_uint(values->Entry[3][2][10], 8, 11) |
      util_bitpack_uint(values->Entry[3][2][11], 12, 15) |
      util_bitpack_uint(values->Entry[3][2][12], 16, 19) |
      util_bitpack_uint(values->Entry[3][2][13], 20, 23) |
      util_bitpack_uint(values->Entry[3][2][14], 24, 27) |
      util_bitpack_uint(values->Entry[3][2][15], 28, 31);

   dw[102] =
      util_bitpack_uint(values->Entry[3][3][0], 0, 3) |
      util_bitpack_uint(values->Entry[3][3][1], 4, 7) |
      util_bitpack_uint(values->Entry[3][3][2], 8, 11) |
      util_bitpack_uint(values->Entry[3][3][3], 12, 15) |
      util_bitpack_uint(values->Entry[3][3][4], 16, 19) |
      util_bitpack_uint(values->Entry[3][3][5], 20, 23) |
      util_bitpack_uint(values->Entry[3][3][6], 24, 27) |
      util_bitpack_uint(values->Entry[3][3][7], 28, 31);

   dw[103] =
      util_bitpack_uint(values->Entry[3][3][8], 0, 3) |
      util_bitpack_uint(values->Entry[3][3][9], 4, 7) |
      util_bitpack_uint(values->Entry[3][3][10], 8, 11) |
      util_bitpack_uint(values->Entry[3][3][11], 12, 15) |
      util_bitpack_uint(values->Entry[3][3][12], 16, 19) |
      util_bitpack_uint(values->Entry[3][3][13], 20, 23) |
      util_bitpack_uint(values->Entry[3][3][14], 24, 27) |
      util_bitpack_uint(values->Entry[3][3][15], 28, 31);

   dw[104] =
      util_bitpack_uint(values->Entry[3][4][0], 0, 3) |
      util_bitpack_uint(values->Entry[3][4][1], 4, 7) |
      util_bitpack_uint(values->Entry[3][4][2], 8, 11) |
      util_bitpack_uint(values->Entry[3][4][3], 12, 15) |
      util_bitpack_uint(values->Entry[3][4][4], 16, 19) |
      util_bitpack_uint(values->Entry[3][4][5], 20, 23) |
      util_bitpack_uint(values->Entry[3][4][6], 24, 27) |
      util_bitpack_uint(values->Entry[3][4][7], 28, 31);

   dw[105] =
      util_bitpack_uint(values->Entry[3][4][8], 0, 3) |
      util_bitpack_uint(values->Entry[3][4][9], 4, 7) |
      util_bitpack_uint(values->Entry[3][4][10], 8, 11) |
      util_bitpack_uint(values->Entry[3][4][11], 12, 15) |
      util_bitpack_uint(values->Entry[3][4][12], 16, 19) |
      util_bitpack_uint(values->Entry[3][4][13], 20, 23) |
      util_bitpack_uint(values->Entry[3][4][14], 24, 27) |
      util_bitpack_uint(values->Entry[3][4][15], 28, 31);

   dw[106] =
      util_bitpack_uint(values->Entry[3][5][0], 0, 3) |
      util_bitpack_uint(values->Entry[3][5][1], 4, 7) |
      util_bitpack_uint(values->Entry[3][5][2], 8, 11) |
      util_bitpack_uint(values->Entry[3][5][3], 12, 15) |
      util_bitpack_uint(values->Entry[3][5][4], 16, 19) |
      util_bitpack_uint(values->Entry[3][5][5], 20, 23) |
      util_bitpack_uint(values->Entry[3][5][6], 24, 27) |
      util_bitpack_uint(values->Entry[3][5][7], 28, 31);

   dw[107] =
      util_bitpack_uint(values->Entry[3][5][8], 0, 3) |
      util_bitpack_uint(values->Entry[3][5][9], 4, 7) |
      util_bitpack_uint(values->Entry[3][5][10], 8, 11) |
      util_bitpack_uint(values->Entry[3][5][11], 12, 15) |
      util_bitpack_uint(values->Entry[3][5][12], 16, 19) |
      util_bitpack_uint(values->Entry[3][5][13], 20, 23) |
      util_bitpack_uint(values->Entry[3][5][14], 24, 27) |
      util_bitpack_uint(values->Entry[3][5][15], 28, 31);

   dw[108] =
      util_bitpack_uint(values->Entry[3][6][0], 0, 3) |
      util_bitpack_uint(values->Entry[3][6][1], 4, 7) |
      util_bitpack_uint(values->Entry[3][6][2], 8, 11) |
      util_bitpack_uint(values->Entry[3][6][3], 12, 15) |
      util_bitpack_uint(values->Entry[3][6][4], 16, 19) |
      util_bitpack_uint(values->Entry[3][6][5], 20, 23) |
      util_bitpack_uint(values->Entry[3][6][6], 24, 27) |
      util_bitpack_uint(values->Entry[3][6][7], 28, 31);

   dw[109] =
      util_bitpack_uint(values->Entry[3][6][8], 0, 3) |
      util_bitpack_uint(values->Entry[3][6][9], 4, 7) |
      util_bitpack_uint(values->Entry[3][6][10], 8, 11) |
      util_bitpack_uint(values->Entry[3][6][11], 12, 15) |
      util_bitpack_uint(values->Entry[3][6][12], 16, 19) |
      util_bitpack_uint(values->Entry[3][6][13], 20, 23) |
      util_bitpack_uint(values->Entry[3][6][14], 24, 27) |
      util_bitpack_uint(values->Entry[3][6][15], 28, 31);

   dw[110] =
      util_bitpack_uint(values->Entry[3][7][0], 0, 3) |
      util_bitpack_uint(values->Entry[3][7][1], 4, 7) |
      util_bitpack_uint(values->Entry[3][7][2], 8, 11) |
      util_bitpack_uint(values->Entry[3][7][3], 12, 15) |
      util_bitpack_uint(values->Entry[3][7][4], 16, 19) |
      util_bitpack_uint(values->Entry[3][7][5], 20, 23) |
      util_bitpack_uint(values->Entry[3][7][6], 24, 27) |
      util_bitpack_uint(values->Entry[3][7][7], 28, 31);

   dw[111] =
      util_bitpack_uint(values->Entry[3][7][8], 0, 3) |
      util_bitpack_uint(values->Entry[3][7][9], 4, 7) |
      util_bitpack_uint(values->Entry[3][7][10], 8, 11) |
      util_bitpack_uint(values->Entry[3][7][11], 12, 15) |
      util_bitpack_uint(values->Entry[3][7][12], 16, 19) |
      util_bitpack_uint(values->Entry[3][7][13], 20, 23) |
      util_bitpack_uint(values->Entry[3][7][14], 24, 27) |
      util_bitpack_uint(values->Entry[3][7][15], 28, 31);

   dw[112] =
      util_bitpack_uint(values->Entry[3][8][0], 0, 3) |
      util_bitpack_uint(values->Entry[3][8][1], 4, 7) |
      util_bitpack_uint(values->Entry[3][8][2], 8, 11) |
      util_bitpack_uint(values->Entry[3][8][3], 12, 15) |
      util_bitpack_uint(values->Entry[3][8][4], 16, 19) |
      util_bitpack_uint(values->Entry[3][8][5], 20, 23) |
      util_bitpack_uint(values->Entry[3][8][6], 24, 27) |
      util_bitpack_uint(values->Entry[3][8][7], 28, 31);

   dw[113] =
      util_bitpack_uint(values->Entry[3][8][8], 0, 3) |
      util_bitpack_uint(values->Entry[3][8][9], 4, 7) |
      util_bitpack_uint(values->Entry[3][8][10], 8, 11) |
      util_bitpack_uint(values->Entry[3][8][11], 12, 15) |
      util_bitpack_uint(values->Entry[3][8][12], 16, 19) |
      util_bitpack_uint(values->Entry[3][8][13], 20, 23) |
      util_bitpack_uint(values->Entry[3][8][14], 24, 27) |
      util_bitpack_uint(values->Entry[3][8][15], 28, 31);

   dw[114] =
      util_bitpack_uint(values->Entry[3][9][0], 0, 3) |
      util_bitpack_uint(values->Entry[3][9][1], 4, 7) |
      util_bitpack_uint(values->Entry[3][9][2], 8, 11) |
      util_bitpack_uint(values->Entry[3][9][3], 12, 15) |
      util_bitpack_uint(values->Entry[3][9][4], 16, 19) |
      util_bitpack_uint(values->Entry[3][9][5], 20, 23) |
      util_bitpack_uint(values->Entry[3][9][6], 24, 27) |
      util_bitpack_uint(values->Entry[3][9][7], 28, 31);

   dw[115] =
      util_bitpack_uint(values->Entry[3][9][8], 0, 3) |
      util_bitpack_uint(values->Entry[3][9][9], 4, 7) |
      util_bitpack_uint(values->Entry[3][9][10], 8, 11) |
      util_bitpack_uint(values->Entry[3][9][11], 12, 15) |
      util_bitpack_uint(values->Entry[3][9][12], 16, 19) |
      util_bitpack_uint(values->Entry[3][9][13], 20, 23) |
      util_bitpack_uint(values->Entry[3][9][14], 24, 27) |
      util_bitpack_uint(values->Entry[3][9][15], 28, 31);

   dw[116] =
      util_bitpack_uint(values->Entry[3][10][0], 0, 3) |
      util_bitpack_uint(values->Entry[3][10][1], 4, 7) |
      util_bitpack_uint(values->Entry[3][10][2], 8, 11) |
      util_bitpack_uint(values->Entry[3][10][3], 12, 15) |
      util_bitpack_uint(values->Entry[3][10][4], 16, 19) |
      util_bitpack_uint(values->Entry[3][10][5], 20, 23) |
      util_bitpack_uint(values->Entry[3][10][6], 24, 27) |
      util_bitpack_uint(values->Entry[3][10][7], 28, 31);

   dw[117] =
      util_bitpack_uint(values->Entry[3][10][8], 0, 3) |
      util_bitpack_uint(values->Entry[3][10][9], 4, 7) |
      util_bitpack_uint(values->Entry[3][10][10], 8, 11) |
      util_bitpack_uint(values->Entry[3][10][11], 12, 15) |
      util_bitpack_uint(values->Entry[3][10][12], 16, 19) |
      util_bitpack_uint(values->Entry[3][10][13], 20, 23) |
      util_bitpack_uint(values->Entry[3][10][14], 24, 27) |
      util_bitpack_uint(values->Entry[3][10][15], 28, 31);

   dw[118] =
      util_bitpack_uint(values->Entry[3][11][0], 0, 3) |
      util_bitpack_uint(values->Entry[3][11][1], 4, 7) |
      util_bitpack_uint(values->Entry[3][11][2], 8, 11) |
      util_bitpack_uint(values->Entry[3][11][3], 12, 15) |
      util_bitpack_uint(values->Entry[3][11][4], 16, 19) |
      util_bitpack_uint(values->Entry[3][11][5], 20, 23) |
      util_bitpack_uint(values->Entry[3][11][6], 24, 27) |
      util_bitpack_uint(values->Entry[3][11][7], 28, 31);

   dw[119] =
      util_bitpack_uint(values->Entry[3][11][8], 0, 3) |
      util_bitpack_uint(values->Entry[3][11][9], 4, 7) |
      util_bitpack_uint(values->Entry[3][11][10], 8, 11) |
      util_bitpack_uint(values->Entry[3][11][11], 12, 15) |
      util_bitpack_uint(values->Entry[3][11][12], 16, 19) |
      util_bitpack_uint(values->Entry[3][11][13], 20, 23) |
      util_bitpack_uint(values->Entry[3][11][14], 24, 27) |
      util_bitpack_uint(values->Entry[3][11][15], 28, 31);

   dw[120] =
      util_bitpack_uint(values->Entry[3][12][0], 0, 3) |
      util_bitpack_uint(values->Entry[3][12][1], 4, 7) |
      util_bitpack_uint(values->Entry[3][12][2], 8, 11) |
      util_bitpack_uint(values->Entry[3][12][3], 12, 15) |
      util_bitpack_uint(values->Entry[3][12][4], 16, 19) |
      util_bitpack_uint(values->Entry[3][12][5], 20, 23) |
      util_bitpack_uint(values->Entry[3][12][6], 24, 27) |
      util_bitpack_uint(values->Entry[3][12][7], 28, 31);

   dw[121] =
      util_bitpack_uint(values->Entry[3][12][8], 0, 3) |
      util_bitpack_uint(values->Entry[3][12][9], 4, 7) |
      util_bitpack_uint(values->Entry[3][12][10], 8, 11) |
      util_bitpack_uint(values->Entry[3][12][11], 12, 15) |
      util_bitpack_uint(values->Entry[3][12][12], 16, 19) |
      util_bitpack_uint(values->Entry[3][12][13], 20, 23) |
      util_bitpack_uint(values->Entry[3][12][14], 24, 27) |
      util_bitpack_uint(values->Entry[3][12][15], 28, 31);

   dw[122] =
      util_bitpack_uint(values->Entry[3][13][0], 0, 3) |
      util_bitpack_uint(values->Entry[3][13][1], 4, 7) |
      util_bitpack_uint(values->Entry[3][13][2], 8, 11) |
      util_bitpack_uint(values->Entry[3][13][3], 12, 15) |
      util_bitpack_uint(values->Entry[3][13][4], 16, 19) |
      util_bitpack_uint(values->Entry[3][13][5], 20, 23) |
      util_bitpack_uint(values->Entry[3][13][6], 24, 27) |
      util_bitpack_uint(values->Entry[3][13][7], 28, 31);

   dw[123] =
      util_bitpack_uint(values->Entry[3][13][8], 0, 3) |
      util_bitpack_uint(values->Entry[3][13][9], 4, 7) |
      util_bitpack_uint(values->Entry[3][13][10], 8, 11) |
      util_bitpack_uint(values->Entry[3][13][11], 12, 15) |
      util_bitpack_uint(values->Entry[3][13][12], 16, 19) |
      util_bitpack_uint(values->Entry[3][13][13], 20, 23) |
      util_bitpack_uint(values->Entry[3][13][14], 24, 27) |
      util_bitpack_uint(values->Entry[3][13][15], 28, 31);

   dw[124] =
      util_bitpack_uint(values->Entry[3][14][0], 0, 3) |
      util_bitpack_uint(values->Entry[3][14][1], 4, 7) |
      util_bitpack_uint(values->Entry[3][14][2], 8, 11) |
      util_bitpack_uint(values->Entry[3][14][3], 12, 15) |
      util_bitpack_uint(values->Entry[3][14][4], 16, 19) |
      util_bitpack_uint(values->Entry[3][14][5], 20, 23) |
      util_bitpack_uint(values->Entry[3][14][6], 24, 27) |
      util_bitpack_uint(values->Entry[3][14][7], 28, 31);

   dw[125] =
      util_bitpack_uint(values->Entry[3][14][8], 0, 3) |
      util_bitpack_uint(values->Entry[3][14][9], 4, 7) |
      util_bitpack_uint(values->Entry[3][14][10], 8, 11) |
      util_bitpack_uint(values->Entry[3][14][11], 12, 15) |
      util_bitpack_uint(values->Entry[3][14][12], 16, 19) |
      util_bitpack_uint(values->Entry[3][14][13], 20, 23) |
      util_bitpack_uint(values->Entry[3][14][14], 24, 27) |
      util_bitpack_uint(values->Entry[3][14][15], 28, 31);

   dw[126] =
      util_bitpack_uint(values->Entry[3][15][0], 0, 3) |
      util_bitpack_uint(values->Entry[3][15][1], 4, 7) |
      util_bitpack_uint(values->Entry[3][15][2], 8, 11) |
      util_bitpack_uint(values->Entry[3][15][3], 12, 15) |
      util_bitpack_uint(values->Entry[3][15][4], 16, 19) |
      util_bitpack_uint(values->Entry[3][15][5], 20, 23) |
      util_bitpack_uint(values->Entry[3][15][6], 24, 27) |
      util_bitpack_uint(values->Entry[3][15][7], 28, 31);

   dw[127] =
      util_bitpack_uint(values->Entry[3][15][8], 0, 3) |
      util_bitpack_uint(values->Entry[3][15][9], 4, 7) |
      util_bitpack_uint(values->Entry[3][15][10], 8, 11) |
      util_bitpack_uint(values->Entry[3][15][11], 12, 15) |
      util_bitpack_uint(values->Entry[3][15][12], 16, 19) |
      util_bitpack_uint(values->Entry[3][15][13], 20, 23) |
      util_bitpack_uint(values->Entry[3][15][14], 24, 27) |
      util_bitpack_uint(values->Entry[3][15][15], 28, 31);

   dw[128] =
      util_bitpack_uint(values->Entry[4][0][0], 0, 3) |
      util_bitpack_uint(values->Entry[4][0][1], 4, 7) |
      util_bitpack_uint(values->Entry[4][0][2], 8, 11) |
      util_bitpack_uint(values->Entry[4][0][3], 12, 15) |
      util_bitpack_uint(values->Entry[4][0][4], 16, 19) |
      util_bitpack_uint(values->Entry[4][0][5], 20, 23) |
      util_bitpack_uint(values->Entry[4][0][6], 24, 27) |
      util_bitpack_uint(values->Entry[4][0][7], 28, 31);

   dw[129] =
      util_bitpack_uint(values->Entry[4][0][8], 0, 3) |
      util_bitpack_uint(values->Entry[4][0][9], 4, 7) |
      util_bitpack_uint(values->Entry[4][0][10], 8, 11) |
      util_bitpack_uint(values->Entry[4][0][11], 12, 15) |
      util_bitpack_uint(values->Entry[4][0][12], 16, 19) |
      util_bitpack_uint(values->Entry[4][0][13], 20, 23) |
      util_bitpack_uint(values->Entry[4][0][14], 24, 27) |
      util_bitpack_uint(values->Entry[4][0][15], 28, 31);

   dw[130] =
      util_bitpack_uint(values->Entry[4][1][0], 0, 3) |
      util_bitpack_uint(values->Entry[4][1][1], 4, 7) |
      util_bitpack_uint(values->Entry[4][1][2], 8, 11) |
      util_bitpack_uint(values->Entry[4][1][3], 12, 15) |
      util_bitpack_uint(values->Entry[4][1][4], 16, 19) |
      util_bitpack_uint(values->Entry[4][1][5], 20, 23) |
      util_bitpack_uint(values->Entry[4][1][6], 24, 27) |
      util_bitpack_uint(values->Entry[4][1][7], 28, 31);

   dw[131] =
      util_bitpack_uint(values->Entry[4][1][8], 0, 3) |
      util_bitpack_uint(values->Entry[4][1][9], 4, 7) |
      util_bitpack_uint(values->Entry[4][1][10], 8, 11) |
      util_bitpack_uint(values->Entry[4][1][11], 12, 15) |
      util_bitpack_uint(values->Entry[4][1][12], 16, 19) |
      util_bitpack_uint(values->Entry[4][1][13], 20, 23) |
      util_bitpack_uint(values->Entry[4][1][14], 24, 27) |
      util_bitpack_uint(values->Entry[4][1][15], 28, 31);

   dw[132] =
      util_bitpack_uint(values->Entry[4][2][0], 0, 3) |
      util_bitpack_uint(values->Entry[4][2][1], 4, 7) |
      util_bitpack_uint(values->Entry[4][2][2], 8, 11) |
      util_bitpack_uint(values->Entry[4][2][3], 12, 15) |
      util_bitpack_uint(values->Entry[4][2][4], 16, 19) |
      util_bitpack_uint(values->Entry[4][2][5], 20, 23) |
      util_bitpack_uint(values->Entry[4][2][6], 24, 27) |
      util_bitpack_uint(values->Entry[4][2][7], 28, 31);

   dw[133] =
      util_bitpack_uint(values->Entry[4][2][8], 0, 3) |
      util_bitpack_uint(values->Entry[4][2][9], 4, 7) |
      util_bitpack_uint(values->Entry[4][2][10], 8, 11) |
      util_bitpack_uint(values->Entry[4][2][11], 12, 15) |
      util_bitpack_uint(values->Entry[4][2][12], 16, 19) |
      util_bitpack_uint(values->Entry[4][2][13], 20, 23) |
      util_bitpack_uint(values->Entry[4][2][14], 24, 27) |
      util_bitpack_uint(values->Entry[4][2][15], 28, 31);

   dw[134] =
      util_bitpack_uint(values->Entry[4][3][0], 0, 3) |
      util_bitpack_uint(values->Entry[4][3][1], 4, 7) |
      util_bitpack_uint(values->Entry[4][3][2], 8, 11) |
      util_bitpack_uint(values->Entry[4][3][3], 12, 15) |
      util_bitpack_uint(values->Entry[4][3][4], 16, 19) |
      util_bitpack_uint(values->Entry[4][3][5], 20, 23) |
      util_bitpack_uint(values->Entry[4][3][6], 24, 27) |
      util_bitpack_uint(values->Entry[4][3][7], 28, 31);

   dw[135] =
      util_bitpack_uint(values->Entry[4][3][8], 0, 3) |
      util_bitpack_uint(values->Entry[4][3][9], 4, 7) |
      util_bitpack_uint(values->Entry[4][3][10], 8, 11) |
      util_bitpack_uint(values->Entry[4][3][11], 12, 15) |
      util_bitpack_uint(values->Entry[4][3][12], 16, 19) |
      util_bitpack_uint(values->Entry[4][3][13], 20, 23) |
      util_bitpack_uint(values->Entry[4][3][14], 24, 27) |
      util_bitpack_uint(values->Entry[4][3][15], 28, 31);

   dw[136] =
      util_bitpack_uint(values->Entry[4][4][0], 0, 3) |
      util_bitpack_uint(values->Entry[4][4][1], 4, 7) |
      util_bitpack_uint(values->Entry[4][4][2], 8, 11) |
      util_bitpack_uint(values->Entry[4][4][3], 12, 15) |
      util_bitpack_uint(values->Entry[4][4][4], 16, 19) |
      util_bitpack_uint(values->Entry[4][4][5], 20, 23) |
      util_bitpack_uint(values->Entry[4][4][6], 24, 27) |
      util_bitpack_uint(values->Entry[4][4][7], 28, 31);

   dw[137] =
      util_bitpack_uint(values->Entry[4][4][8], 0, 3) |
      util_bitpack_uint(values->Entry[4][4][9], 4, 7) |
      util_bitpack_uint(values->Entry[4][4][10], 8, 11) |
      util_bitpack_uint(values->Entry[4][4][11], 12, 15) |
      util_bitpack_uint(values->Entry[4][4][12], 16, 19) |
      util_bitpack_uint(values->Entry[4][4][13], 20, 23) |
      util_bitpack_uint(values->Entry[4][4][14], 24, 27) |
      util_bitpack_uint(values->Entry[4][4][15], 28, 31);

   dw[138] =
      util_bitpack_uint(values->Entry[4][5][0], 0, 3) |
      util_bitpack_uint(values->Entry[4][5][1], 4, 7) |
      util_bitpack_uint(values->Entry[4][5][2], 8, 11) |
      util_bitpack_uint(values->Entry[4][5][3], 12, 15) |
      util_bitpack_uint(values->Entry[4][5][4], 16, 19) |
      util_bitpack_uint(values->Entry[4][5][5], 20, 23) |
      util_bitpack_uint(values->Entry[4][5][6], 24, 27) |
      util_bitpack_uint(values->Entry[4][5][7], 28, 31);

   dw[139] =
      util_bitpack_uint(values->Entry[4][5][8], 0, 3) |
      util_bitpack_uint(values->Entry[4][5][9], 4, 7) |
      util_bitpack_uint(values->Entry[4][5][10], 8, 11) |
      util_bitpack_uint(values->Entry[4][5][11], 12, 15) |
      util_bitpack_uint(values->Entry[4][5][12], 16, 19) |
      util_bitpack_uint(values->Entry[4][5][13], 20, 23) |
      util_bitpack_uint(values->Entry[4][5][14], 24, 27) |
      util_bitpack_uint(values->Entry[4][5][15], 28, 31);

   dw[140] =
      util_bitpack_uint(values->Entry[4][6][0], 0, 3) |
      util_bitpack_uint(values->Entry[4][6][1], 4, 7) |
      util_bitpack_uint(values->Entry[4][6][2], 8, 11) |
      util_bitpack_uint(values->Entry[4][6][3], 12, 15) |
      util_bitpack_uint(values->Entry[4][6][4], 16, 19) |
      util_bitpack_uint(values->Entry[4][6][5], 20, 23) |
      util_bitpack_uint(values->Entry[4][6][6], 24, 27) |
      util_bitpack_uint(values->Entry[4][6][7], 28, 31);

   dw[141] =
      util_bitpack_uint(values->Entry[4][6][8], 0, 3) |
      util_bitpack_uint(values->Entry[4][6][9], 4, 7) |
      util_bitpack_uint(values->Entry[4][6][10], 8, 11) |
      util_bitpack_uint(values->Entry[4][6][11], 12, 15) |
      util_bitpack_uint(values->Entry[4][6][12], 16, 19) |
      util_bitpack_uint(values->Entry[4][6][13], 20, 23) |
      util_bitpack_uint(values->Entry[4][6][14], 24, 27) |
      util_bitpack_uint(values->Entry[4][6][15], 28, 31);

   dw[142] =
      util_bitpack_uint(values->Entry[4][7][0], 0, 3) |
      util_bitpack_uint(values->Entry[4][7][1], 4, 7) |
      util_bitpack_uint(values->Entry[4][7][2], 8, 11) |
      util_bitpack_uint(values->Entry[4][7][3], 12, 15) |
      util_bitpack_uint(values->Entry[4][7][4], 16, 19) |
      util_bitpack_uint(values->Entry[4][7][5], 20, 23) |
      util_bitpack_uint(values->Entry[4][7][6], 24, 27) |
      util_bitpack_uint(values->Entry[4][7][7], 28, 31);

   dw[143] =
      util_bitpack_uint(values->Entry[4][7][8], 0, 3) |
      util_bitpack_uint(values->Entry[4][7][9], 4, 7) |
      util_bitpack_uint(values->Entry[4][7][10], 8, 11) |
      util_bitpack_uint(values->Entry[4][7][11], 12, 15) |
      util_bitpack_uint(values->Entry[4][7][12], 16, 19) |
      util_bitpack_uint(values->Entry[4][7][13], 20, 23) |
      util_bitpack_uint(values->Entry[4][7][14], 24, 27) |
      util_bitpack_uint(values->Entry[4][7][15], 28, 31);

   dw[144] =
      util_bitpack_uint(values->Entry[4][8][0], 0, 3) |
      util_bitpack_uint(values->Entry[4][8][1], 4, 7) |
      util_bitpack_uint(values->Entry[4][8][2], 8, 11) |
      util_bitpack_uint(values->Entry[4][8][3], 12, 15) |
      util_bitpack_uint(values->Entry[4][8][4], 16, 19) |
      util_bitpack_uint(values->Entry[4][8][5], 20, 23) |
      util_bitpack_uint(values->Entry[4][8][6], 24, 27) |
      util_bitpack_uint(values->Entry[4][8][7], 28, 31);

   dw[145] =
      util_bitpack_uint(values->Entry[4][8][8], 0, 3) |
      util_bitpack_uint(values->Entry[4][8][9], 4, 7) |
      util_bitpack_uint(values->Entry[4][8][10], 8, 11) |
      util_bitpack_uint(values->Entry[4][8][11], 12, 15) |
      util_bitpack_uint(values->Entry[4][8][12], 16, 19) |
      util_bitpack_uint(values->Entry[4][8][13], 20, 23) |
      util_bitpack_uint(values->Entry[4][8][14], 24, 27) |
      util_bitpack_uint(values->Entry[4][8][15], 28, 31);

   dw[146] =
      util_bitpack_uint(values->Entry[4][9][0], 0, 3) |
      util_bitpack_uint(values->Entry[4][9][1], 4, 7) |
      util_bitpack_uint(values->Entry[4][9][2], 8, 11) |
      util_bitpack_uint(values->Entry[4][9][3], 12, 15) |
      util_bitpack_uint(values->Entry[4][9][4], 16, 19) |
      util_bitpack_uint(values->Entry[4][9][5], 20, 23) |
      util_bitpack_uint(values->Entry[4][9][6], 24, 27) |
      util_bitpack_uint(values->Entry[4][9][7], 28, 31);

   dw[147] =
      util_bitpack_uint(values->Entry[4][9][8], 0, 3) |
      util_bitpack_uint(values->Entry[4][9][9], 4, 7) |
      util_bitpack_uint(values->Entry[4][9][10], 8, 11) |
      util_bitpack_uint(values->Entry[4][9][11], 12, 15) |
      util_bitpack_uint(values->Entry[4][9][12], 16, 19) |
      util_bitpack_uint(values->Entry[4][9][13], 20, 23) |
      util_bitpack_uint(values->Entry[4][9][14], 24, 27) |
      util_bitpack_uint(values->Entry[4][9][15], 28, 31);

   dw[148] =
      util_bitpack_uint(values->Entry[4][10][0], 0, 3) |
      util_bitpack_uint(values->Entry[4][10][1], 4, 7) |
      util_bitpack_uint(values->Entry[4][10][2], 8, 11) |
      util_bitpack_uint(values->Entry[4][10][3], 12, 15) |
      util_bitpack_uint(values->Entry[4][10][4], 16, 19) |
      util_bitpack_uint(values->Entry[4][10][5], 20, 23) |
      util_bitpack_uint(values->Entry[4][10][6], 24, 27) |
      util_bitpack_uint(values->Entry[4][10][7], 28, 31);

   dw[149] =
      util_bitpack_uint(values->Entry[4][10][8], 0, 3) |
      util_bitpack_uint(values->Entry[4][10][9], 4, 7) |
      util_bitpack_uint(values->Entry[4][10][10], 8, 11) |
      util_bitpack_uint(values->Entry[4][10][11], 12, 15) |
      util_bitpack_uint(values->Entry[4][10][12], 16, 19) |
      util_bitpack_uint(values->Entry[4][10][13], 20, 23) |
      util_bitpack_uint(values->Entry[4][10][14], 24, 27) |
      util_bitpack_uint(values->Entry[4][10][15], 28, 31);

   dw[150] =
      util_bitpack_uint(values->Entry[4][11][0], 0, 3) |
      util_bitpack_uint(values->Entry[4][11][1], 4, 7) |
      util_bitpack_uint(values->Entry[4][11][2], 8, 11) |
      util_bitpack_uint(values->Entry[4][11][3], 12, 15) |
      util_bitpack_uint(values->Entry[4][11][4], 16, 19) |
      util_bitpack_uint(values->Entry[4][11][5], 20, 23) |
      util_bitpack_uint(values->Entry[4][11][6], 24, 27) |
      util_bitpack_uint(values->Entry[4][11][7], 28, 31);

   dw[151] =
      util_bitpack_uint(values->Entry[4][11][8], 0, 3) |
      util_bitpack_uint(values->Entry[4][11][9], 4, 7) |
      util_bitpack_uint(values->Entry[4][11][10], 8, 11) |
      util_bitpack_uint(values->Entry[4][11][11], 12, 15) |
      util_bitpack_uint(values->Entry[4][11][12], 16, 19) |
      util_bitpack_uint(values->Entry[4][11][13], 20, 23) |
      util_bitpack_uint(values->Entry[4][11][14], 24, 27) |
      util_bitpack_uint(values->Entry[4][11][15], 28, 31);

   dw[152] =
      util_bitpack_uint(values->Entry[4][12][0], 0, 3) |
      util_bitpack_uint(values->Entry[4][12][1], 4, 7) |
      util_bitpack_uint(values->Entry[4][12][2], 8, 11) |
      util_bitpack_uint(values->Entry[4][12][3], 12, 15) |
      util_bitpack_uint(values->Entry[4][12][4], 16, 19) |
      util_bitpack_uint(values->Entry[4][12][5], 20, 23) |
      util_bitpack_uint(values->Entry[4][12][6], 24, 27) |
      util_bitpack_uint(values->Entry[4][12][7], 28, 31);

   dw[153] =
      util_bitpack_uint(values->Entry[4][12][8], 0, 3) |
      util_bitpack_uint(values->Entry[4][12][9], 4, 7) |
      util_bitpack_uint(values->Entry[4][12][10], 8, 11) |
      util_bitpack_uint(values->Entry[4][12][11], 12, 15) |
      util_bitpack_uint(values->Entry[4][12][12], 16, 19) |
      util_bitpack_uint(values->Entry[4][12][13], 20, 23) |
      util_bitpack_uint(values->Entry[4][12][14], 24, 27) |
      util_bitpack_uint(values->Entry[4][12][15], 28, 31);

   dw[154] =
      util_bitpack_uint(values->Entry[4][13][0], 0, 3) |
      util_bitpack_uint(values->Entry[4][13][1], 4, 7) |
      util_bitpack_uint(values->Entry[4][13][2], 8, 11) |
      util_bitpack_uint(values->Entry[4][13][3], 12, 15) |
      util_bitpack_uint(values->Entry[4][13][4], 16, 19) |
      util_bitpack_uint(values->Entry[4][13][5], 20, 23) |
      util_bitpack_uint(values->Entry[4][13][6], 24, 27) |
      util_bitpack_uint(values->Entry[4][13][7], 28, 31);

   dw[155] =
      util_bitpack_uint(values->Entry[4][13][8], 0, 3) |
      util_bitpack_uint(values->Entry[4][13][9], 4, 7) |
      util_bitpack_uint(values->Entry[4][13][10], 8, 11) |
      util_bitpack_uint(values->Entry[4][13][11], 12, 15) |
      util_bitpack_uint(values->Entry[4][13][12], 16, 19) |
      util_bitpack_uint(values->Entry[4][13][13], 20, 23) |
      util_bitpack_uint(values->Entry[4][13][14], 24, 27) |
      util_bitpack_uint(values->Entry[4][13][15], 28, 31);

   dw[156] =
      util_bitpack_uint(values->Entry[4][14][0], 0, 3) |
      util_bitpack_uint(values->Entry[4][14][1], 4, 7) |
      util_bitpack_uint(values->Entry[4][14][2], 8, 11) |
      util_bitpack_uint(values->Entry[4][14][3], 12, 15) |
      util_bitpack_uint(values->Entry[4][14][4], 16, 19) |
      util_bitpack_uint(values->Entry[4][14][5], 20, 23) |
      util_bitpack_uint(values->Entry[4][14][6], 24, 27) |
      util_bitpack_uint(values->Entry[4][14][7], 28, 31);

   dw[157] =
      util_bitpack_uint(values->Entry[4][14][8], 0, 3) |
      util_bitpack_uint(values->Entry[4][14][9], 4, 7) |
      util_bitpack_uint(values->Entry[4][14][10], 8, 11) |
      util_bitpack_uint(values->Entry[4][14][11], 12, 15) |
      util_bitpack_uint(values->Entry[4][14][12], 16, 19) |
      util_bitpack_uint(values->Entry[4][14][13], 20, 23) |
      util_bitpack_uint(values->Entry[4][14][14], 24, 27) |
      util_bitpack_uint(values->Entry[4][14][15], 28, 31);

   dw[158] =
      util_bitpack_uint(values->Entry[4][15][0], 0, 3) |
      util_bitpack_uint(values->Entry[4][15][1], 4, 7) |
      util_bitpack_uint(values->Entry[4][15][2], 8, 11) |
      util_bitpack_uint(values->Entry[4][15][3], 12, 15) |
      util_bitpack_uint(values->Entry[4][15][4], 16, 19) |
      util_bitpack_uint(values->Entry[4][15][5], 20, 23) |
      util_bitpack_uint(values->Entry[4][15][6], 24, 27) |
      util_bitpack_uint(values->Entry[4][15][7], 28, 31);

   dw[159] =
      util_bitpack_uint(values->Entry[4][15][8], 0, 3) |
      util_bitpack_uint(values->Entry[4][15][9], 4, 7) |
      util_bitpack_uint(values->Entry[4][15][10], 8, 11) |
      util_bitpack_uint(values->Entry[4][15][11], 12, 15) |
      util_bitpack_uint(values->Entry[4][15][12], 16, 19) |
      util_bitpack_uint(values->Entry[4][15][13], 20, 23) |
      util_bitpack_uint(values->Entry[4][15][14], 24, 27) |
      util_bitpack_uint(values->Entry[4][15][15], 28, 31);

   dw[160] =
      util_bitpack_uint(values->Entry[5][0][0], 0, 3) |
      util_bitpack_uint(values->Entry[5][0][1], 4, 7) |
      util_bitpack_uint(values->Entry[5][0][2], 8, 11) |
      util_bitpack_uint(values->Entry[5][0][3], 12, 15) |
      util_bitpack_uint(values->Entry[5][0][4], 16, 19) |
      util_bitpack_uint(values->Entry[5][0][5], 20, 23) |
      util_bitpack_uint(values->Entry[5][0][6], 24, 27) |
      util_bitpack_uint(values->Entry[5][0][7], 28, 31);

   dw[161] =
      util_bitpack_uint(values->Entry[5][0][8], 0, 3) |
      util_bitpack_uint(values->Entry[5][0][9], 4, 7) |
      util_bitpack_uint(values->Entry[5][0][10], 8, 11) |
      util_bitpack_uint(values->Entry[5][0][11], 12, 15) |
      util_bitpack_uint(values->Entry[5][0][12], 16, 19) |
      util_bitpack_uint(values->Entry[5][0][13], 20, 23) |
      util_bitpack_uint(values->Entry[5][0][14], 24, 27) |
      util_bitpack_uint(values->Entry[5][0][15], 28, 31);

   dw[162] =
      util_bitpack_uint(values->Entry[5][1][0], 0, 3) |
      util_bitpack_uint(values->Entry[5][1][1], 4, 7) |
      util_bitpack_uint(values->Entry[5][1][2], 8, 11) |
      util_bitpack_uint(values->Entry[5][1][3], 12, 15) |
      util_bitpack_uint(values->Entry[5][1][4], 16, 19) |
      util_bitpack_uint(values->Entry[5][1][5], 20, 23) |
      util_bitpack_uint(values->Entry[5][1][6], 24, 27) |
      util_bitpack_uint(values->Entry[5][1][7], 28, 31);

   dw[163] =
      util_bitpack_uint(values->Entry[5][1][8], 0, 3) |
      util_bitpack_uint(values->Entry[5][1][9], 4, 7) |
      util_bitpack_uint(values->Entry[5][1][10], 8, 11) |
      util_bitpack_uint(values->Entry[5][1][11], 12, 15) |
      util_bitpack_uint(values->Entry[5][1][12], 16, 19) |
      util_bitpack_uint(values->Entry[5][1][13], 20, 23) |
      util_bitpack_uint(values->Entry[5][1][14], 24, 27) |
      util_bitpack_uint(values->Entry[5][1][15], 28, 31);

   dw[164] =
      util_bitpack_uint(values->Entry[5][2][0], 0, 3) |
      util_bitpack_uint(values->Entry[5][2][1], 4, 7) |
      util_bitpack_uint(values->Entry[5][2][2], 8, 11) |
      util_bitpack_uint(values->Entry[5][2][3], 12, 15) |
      util_bitpack_uint(values->Entry[5][2][4], 16, 19) |
      util_bitpack_uint(values->Entry[5][2][5], 20, 23) |
      util_bitpack_uint(values->Entry[5][2][6], 24, 27) |
      util_bitpack_uint(values->Entry[5][2][7], 28, 31);

   dw[165] =
      util_bitpack_uint(values->Entry[5][2][8], 0, 3) |
      util_bitpack_uint(values->Entry[5][2][9], 4, 7) |
      util_bitpack_uint(values->Entry[5][2][10], 8, 11) |
      util_bitpack_uint(values->Entry[5][2][11], 12, 15) |
      util_bitpack_uint(values->Entry[5][2][12], 16, 19) |
      util_bitpack_uint(values->Entry[5][2][13], 20, 23) |
      util_bitpack_uint(values->Entry[5][2][14], 24, 27) |
      util_bitpack_uint(values->Entry[5][2][15], 28, 31);

   dw[166] =
      util_bitpack_uint(values->Entry[5][3][0], 0, 3) |
      util_bitpack_uint(values->Entry[5][3][1], 4, 7) |
      util_bitpack_uint(values->Entry[5][3][2], 8, 11) |
      util_bitpack_uint(values->Entry[5][3][3], 12, 15) |
      util_bitpack_uint(values->Entry[5][3][4], 16, 19) |
      util_bitpack_uint(values->Entry[5][3][5], 20, 23) |
      util_bitpack_uint(values->Entry[5][3][6], 24, 27) |
      util_bitpack_uint(values->Entry[5][3][7], 28, 31);

   dw[167] =
      util_bitpack_uint(values->Entry[5][3][8], 0, 3) |
      util_bitpack_uint(values->Entry[5][3][9], 4, 7) |
      util_bitpack_uint(values->Entry[5][3][10], 8, 11) |
      util_bitpack_uint(values->Entry[5][3][11], 12, 15) |
      util_bitpack_uint(values->Entry[5][3][12], 16, 19) |
      util_bitpack_uint(values->Entry[5][3][13], 20, 23) |
      util_bitpack_uint(values->Entry[5][3][14], 24, 27) |
      util_bitpack_uint(values->Entry[5][3][15], 28, 31);

   dw[168] =
      util_bitpack_uint(values->Entry[5][4][0], 0, 3) |
      util_bitpack_uint(values->Entry[5][4][1], 4, 7) |
      util_bitpack_uint(values->Entry[5][4][2], 8, 11) |
      util_bitpack_uint(values->Entry[5][4][3], 12, 15) |
      util_bitpack_uint(values->Entry[5][4][4], 16, 19) |
      util_bitpack_uint(values->Entry[5][4][5], 20, 23) |
      util_bitpack_uint(values->Entry[5][4][6], 24, 27) |
      util_bitpack_uint(values->Entry[5][4][7], 28, 31);

   dw[169] =
      util_bitpack_uint(values->Entry[5][4][8], 0, 3) |
      util_bitpack_uint(values->Entry[5][4][9], 4, 7) |
      util_bitpack_uint(values->Entry[5][4][10], 8, 11) |
      util_bitpack_uint(values->Entry[5][4][11], 12, 15) |
      util_bitpack_uint(values->Entry[5][4][12], 16, 19) |
      util_bitpack_uint(values->Entry[5][4][13], 20, 23) |
      util_bitpack_uint(values->Entry[5][4][14], 24, 27) |
      util_bitpack_uint(values->Entry[5][4][15], 28, 31);

   dw[170] =
      util_bitpack_uint(values->Entry[5][5][0], 0, 3) |
      util_bitpack_uint(values->Entry[5][5][1], 4, 7) |
      util_bitpack_uint(values->Entry[5][5][2], 8, 11) |
      util_bitpack_uint(values->Entry[5][5][3], 12, 15) |
      util_bitpack_uint(values->Entry[5][5][4], 16, 19) |
      util_bitpack_uint(values->Entry[5][5][5], 20, 23) |
      util_bitpack_uint(values->Entry[5][5][6], 24, 27) |
      util_bitpack_uint(values->Entry[5][5][7], 28, 31);

   dw[171] =
      util_bitpack_uint(values->Entry[5][5][8], 0, 3) |
      util_bitpack_uint(values->Entry[5][5][9], 4, 7) |
      util_bitpack_uint(values->Entry[5][5][10], 8, 11) |
      util_bitpack_uint(values->Entry[5][5][11], 12, 15) |
      util_bitpack_uint(values->Entry[5][5][12], 16, 19) |
      util_bitpack_uint(values->Entry[5][5][13], 20, 23) |
      util_bitpack_uint(values->Entry[5][5][14], 24, 27) |
      util_bitpack_uint(values->Entry[5][5][15], 28, 31);

   dw[172] =
      util_bitpack_uint(values->Entry[5][6][0], 0, 3) |
      util_bitpack_uint(values->Entry[5][6][1], 4, 7) |
      util_bitpack_uint(values->Entry[5][6][2], 8, 11) |
      util_bitpack_uint(values->Entry[5][6][3], 12, 15) |
      util_bitpack_uint(values->Entry[5][6][4], 16, 19) |
      util_bitpack_uint(values->Entry[5][6][5], 20, 23) |
      util_bitpack_uint(values->Entry[5][6][6], 24, 27) |
      util_bitpack_uint(values->Entry[5][6][7], 28, 31);

   dw[173] =
      util_bitpack_uint(values->Entry[5][6][8], 0, 3) |
      util_bitpack_uint(values->Entry[5][6][9], 4, 7) |
      util_bitpack_uint(values->Entry[5][6][10], 8, 11) |
      util_bitpack_uint(values->Entry[5][6][11], 12, 15) |
      util_bitpack_uint(values->Entry[5][6][12], 16, 19) |
      util_bitpack_uint(values->Entry[5][6][13], 20, 23) |
      util_bitpack_uint(values->Entry[5][6][14], 24, 27) |
      util_bitpack_uint(values->Entry[5][6][15], 28, 31);

   dw[174] =
      util_bitpack_uint(values->Entry[5][7][0], 0, 3) |
      util_bitpack_uint(values->Entry[5][7][1], 4, 7) |
      util_bitpack_uint(values->Entry[5][7][2], 8, 11) |
      util_bitpack_uint(values->Entry[5][7][3], 12, 15) |
      util_bitpack_uint(values->Entry[5][7][4], 16, 19) |
      util_bitpack_uint(values->Entry[5][7][5], 20, 23) |
      util_bitpack_uint(values->Entry[5][7][6], 24, 27) |
      util_bitpack_uint(values->Entry[5][7][7], 28, 31);

   dw[175] =
      util_bitpack_uint(values->Entry[5][7][8], 0, 3) |
      util_bitpack_uint(values->Entry[5][7][9], 4, 7) |
      util_bitpack_uint(values->Entry[5][7][10], 8, 11) |
      util_bitpack_uint(values->Entry[5][7][11], 12, 15) |
      util_bitpack_uint(values->Entry[5][7][12], 16, 19) |
      util_bitpack_uint(values->Entry[5][7][13], 20, 23) |
      util_bitpack_uint(values->Entry[5][7][14], 24, 27) |
      util_bitpack_uint(values->Entry[5][7][15], 28, 31);

   dw[176] =
      util_bitpack_uint(values->Entry[5][8][0], 0, 3) |
      util_bitpack_uint(values->Entry[5][8][1], 4, 7) |
      util_bitpack_uint(values->Entry[5][8][2], 8, 11) |
      util_bitpack_uint(values->Entry[5][8][3], 12, 15) |
      util_bitpack_uint(values->Entry[5][8][4], 16, 19) |
      util_bitpack_uint(values->Entry[5][8][5], 20, 23) |
      util_bitpack_uint(values->Entry[5][8][6], 24, 27) |
      util_bitpack_uint(values->Entry[5][8][7], 28, 31);

   dw[177] =
      util_bitpack_uint(values->Entry[5][8][8], 0, 3) |
      util_bitpack_uint(values->Entry[5][8][9], 4, 7) |
      util_bitpack_uint(values->Entry[5][8][10], 8, 11) |
      util_bitpack_uint(values->Entry[5][8][11], 12, 15) |
      util_bitpack_uint(values->Entry[5][8][12], 16, 19) |
      util_bitpack_uint(values->Entry[5][8][13], 20, 23) |
      util_bitpack_uint(values->Entry[5][8][14], 24, 27) |
      util_bitpack_uint(values->Entry[5][8][15], 28, 31);

   dw[178] =
      util_bitpack_uint(values->Entry[5][9][0], 0, 3) |
      util_bitpack_uint(values->Entry[5][9][1], 4, 7) |
      util_bitpack_uint(values->Entry[5][9][2], 8, 11) |
      util_bitpack_uint(values->Entry[5][9][3], 12, 15) |
      util_bitpack_uint(values->Entry[5][9][4], 16, 19) |
      util_bitpack_uint(values->Entry[5][9][5], 20, 23) |
      util_bitpack_uint(values->Entry[5][9][6], 24, 27) |
      util_bitpack_uint(values->Entry[5][9][7], 28, 31);

   dw[179] =
      util_bitpack_uint(values->Entry[5][9][8], 0, 3) |
      util_bitpack_uint(values->Entry[5][9][9], 4, 7) |
      util_bitpack_uint(values->Entry[5][9][10], 8, 11) |
      util_bitpack_uint(values->Entry[5][9][11], 12, 15) |
      util_bitpack_uint(values->Entry[5][9][12], 16, 19) |
      util_bitpack_uint(values->Entry[5][9][13], 20, 23) |
      util_bitpack_uint(values->Entry[5][9][14], 24, 27) |
      util_bitpack_uint(values->Entry[5][9][15], 28, 31);

   dw[180] =
      util_bitpack_uint(values->Entry[5][10][0], 0, 3) |
      util_bitpack_uint(values->Entry[5][10][1], 4, 7) |
      util_bitpack_uint(values->Entry[5][10][2], 8, 11) |
      util_bitpack_uint(values->Entry[5][10][3], 12, 15) |
      util_bitpack_uint(values->Entry[5][10][4], 16, 19) |
      util_bitpack_uint(values->Entry[5][10][5], 20, 23) |
      util_bitpack_uint(values->Entry[5][10][6], 24, 27) |
      util_bitpack_uint(values->Entry[5][10][7], 28, 31);

   dw[181] =
      util_bitpack_uint(values->Entry[5][10][8], 0, 3) |
      util_bitpack_uint(values->Entry[5][10][9], 4, 7) |
      util_bitpack_uint(values->Entry[5][10][10], 8, 11) |
      util_bitpack_uint(values->Entry[5][10][11], 12, 15) |
      util_bitpack_uint(values->Entry[5][10][12], 16, 19) |
      util_bitpack_uint(values->Entry[5][10][13], 20, 23) |
      util_bitpack_uint(values->Entry[5][10][14], 24, 27) |
      util_bitpack_uint(values->Entry[5][10][15], 28, 31);

   dw[182] =
      util_bitpack_uint(values->Entry[5][11][0], 0, 3) |
      util_bitpack_uint(values->Entry[5][11][1], 4, 7) |
      util_bitpack_uint(values->Entry[5][11][2], 8, 11) |
      util_bitpack_uint(values->Entry[5][11][3], 12, 15) |
      util_bitpack_uint(values->Entry[5][11][4], 16, 19) |
      util_bitpack_uint(values->Entry[5][11][5], 20, 23) |
      util_bitpack_uint(values->Entry[5][11][6], 24, 27) |
      util_bitpack_uint(values->Entry[5][11][7], 28, 31);

   dw[183] =
      util_bitpack_uint(values->Entry[5][11][8], 0, 3) |
      util_bitpack_uint(values->Entry[5][11][9], 4, 7) |
      util_bitpack_uint(values->Entry[5][11][10], 8, 11) |
      util_bitpack_uint(values->Entry[5][11][11], 12, 15) |
      util_bitpack_uint(values->Entry[5][11][12], 16, 19) |
      util_bitpack_uint(values->Entry[5][11][13], 20, 23) |
      util_bitpack_uint(values->Entry[5][11][14], 24, 27) |
      util_bitpack_uint(values->Entry[5][11][15], 28, 31);

   dw[184] =
      util_bitpack_uint(values->Entry[5][12][0], 0, 3) |
      util_bitpack_uint(values->Entry[5][12][1], 4, 7) |
      util_bitpack_uint(values->Entry[5][12][2], 8, 11) |
      util_bitpack_uint(values->Entry[5][12][3], 12, 15) |
      util_bitpack_uint(values->Entry[5][12][4], 16, 19) |
      util_bitpack_uint(values->Entry[5][12][5], 20, 23) |
      util_bitpack_uint(values->Entry[5][12][6], 24, 27) |
      util_bitpack_uint(values->Entry[5][12][7], 28, 31);

   dw[185] =
      util_bitpack_uint(values->Entry[5][12][8], 0, 3) |
      util_bitpack_uint(values->Entry[5][12][9], 4, 7) |
      util_bitpack_uint(values->Entry[5][12][10], 8, 11) |
      util_bitpack_uint(values->Entry[5][12][11], 12, 15) |
      util_bitpack_uint(values->Entry[5][12][12], 16, 19) |
      util_bitpack_uint(values->Entry[5][12][13], 20, 23) |
      util_bitpack_uint(values->Entry[5][12][14], 24, 27) |
      util_bitpack_uint(values->Entry[5][12][15], 28, 31);

   dw[186] =
      util_bitpack_uint(values->Entry[5][13][0], 0, 3) |
      util_bitpack_uint(values->Entry[5][13][1], 4, 7) |
      util_bitpack_uint(values->Entry[5][13][2], 8, 11) |
      util_bitpack_uint(values->Entry[5][13][3], 12, 15) |
      util_bitpack_uint(values->Entry[5][13][4], 16, 19) |
      util_bitpack_uint(values->Entry[5][13][5], 20, 23) |
      util_bitpack_uint(values->Entry[5][13][6], 24, 27) |
      util_bitpack_uint(values->Entry[5][13][7], 28, 31);

   dw[187] =
      util_bitpack_uint(values->Entry[5][13][8], 0, 3) |
      util_bitpack_uint(values->Entry[5][13][9], 4, 7) |
      util_bitpack_uint(values->Entry[5][13][10], 8, 11) |
      util_bitpack_uint(values->Entry[5][13][11], 12, 15) |
      util_bitpack_uint(values->Entry[5][13][12], 16, 19) |
      util_bitpack_uint(values->Entry[5][13][13], 20, 23) |
      util_bitpack_uint(values->Entry[5][13][14], 24, 27) |
      util_bitpack_uint(values->Entry[5][13][15], 28, 31);

   dw[188] =
      util_bitpack_uint(values->Entry[5][14][0], 0, 3) |
      util_bitpack_uint(values->Entry[5][14][1], 4, 7) |
      util_bitpack_uint(values->Entry[5][14][2], 8, 11) |
      util_bitpack_uint(values->Entry[5][14][3], 12, 15) |
      util_bitpack_uint(values->Entry[5][14][4], 16, 19) |
      util_bitpack_uint(values->Entry[5][14][5], 20, 23) |
      util_bitpack_uint(values->Entry[5][14][6], 24, 27) |
      util_bitpack_uint(values->Entry[5][14][7], 28, 31);

   dw[189] =
      util_bitpack_uint(values->Entry[5][14][8], 0, 3) |
      util_bitpack_uint(values->Entry[5][14][9], 4, 7) |
      util_bitpack_uint(values->Entry[5][14][10], 8, 11) |
      util_bitpack_uint(values->Entry[5][14][11], 12, 15) |
      util_bitpack_uint(values->Entry[5][14][12], 16, 19) |
      util_bitpack_uint(values->Entry[5][14][13], 20, 23) |
      util_bitpack_uint(values->Entry[5][14][14], 24, 27) |
      util_bitpack_uint(values->Entry[5][14][15], 28, 31);

   dw[190] =
      util_bitpack_uint(values->Entry[5][15][0], 0, 3) |
      util_bitpack_uint(values->Entry[5][15][1], 4, 7) |
      util_bitpack_uint(values->Entry[5][15][2], 8, 11) |
      util_bitpack_uint(values->Entry[5][15][3], 12, 15) |
      util_bitpack_uint(values->Entry[5][15][4], 16, 19) |
      util_bitpack_uint(values->Entry[5][15][5], 20, 23) |
      util_bitpack_uint(values->Entry[5][15][6], 24, 27) |
      util_bitpack_uint(values->Entry[5][15][7], 28, 31);

   dw[191] =
      util_bitpack_uint(values->Entry[5][15][8], 0, 3) |
      util_bitpack_uint(values->Entry[5][15][9], 4, 7) |
      util_bitpack_uint(values->Entry[5][15][10], 8, 11) |
      util_bitpack_uint(values->Entry[5][15][11], 12, 15) |
      util_bitpack_uint(values->Entry[5][15][12], 16, 19) |
      util_bitpack_uint(values->Entry[5][15][13], 20, 23) |
      util_bitpack_uint(values->Entry[5][15][14], 24, 27) |
      util_bitpack_uint(values->Entry[5][15][15], 28, 31);

   dw[192] =
      util_bitpack_uint(values->Entry[6][0][0], 0, 3) |
      util_bitpack_uint(values->Entry[6][0][1], 4, 7) |
      util_bitpack_uint(values->Entry[6][0][2], 8, 11) |
      util_bitpack_uint(values->Entry[6][0][3], 12, 15) |
      util_bitpack_uint(values->Entry[6][0][4], 16, 19) |
      util_bitpack_uint(values->Entry[6][0][5], 20, 23) |
      util_bitpack_uint(values->Entry[6][0][6], 24, 27) |
      util_bitpack_uint(values->Entry[6][0][7], 28, 31);

   dw[193] =
      util_bitpack_uint(values->Entry[6][0][8], 0, 3) |
      util_bitpack_uint(values->Entry[6][0][9], 4, 7) |
      util_bitpack_uint(values->Entry[6][0][10], 8, 11) |
      util_bitpack_uint(values->Entry[6][0][11], 12, 15) |
      util_bitpack_uint(values->Entry[6][0][12], 16, 19) |
      util_bitpack_uint(values->Entry[6][0][13], 20, 23) |
      util_bitpack_uint(values->Entry[6][0][14], 24, 27) |
      util_bitpack_uint(values->Entry[6][0][15], 28, 31);

   dw[194] =
      util_bitpack_uint(values->Entry[6][1][0], 0, 3) |
      util_bitpack_uint(values->Entry[6][1][1], 4, 7) |
      util_bitpack_uint(values->Entry[6][1][2], 8, 11) |
      util_bitpack_uint(values->Entry[6][1][3], 12, 15) |
      util_bitpack_uint(values->Entry[6][1][4], 16, 19) |
      util_bitpack_uint(values->Entry[6][1][5], 20, 23) |
      util_bitpack_uint(values->Entry[6][1][6], 24, 27) |
      util_bitpack_uint(values->Entry[6][1][7], 28, 31);

   dw[195] =
      util_bitpack_uint(values->Entry[6][1][8], 0, 3) |
      util_bitpack_uint(values->Entry[6][1][9], 4, 7) |
      util_bitpack_uint(values->Entry[6][1][10], 8, 11) |
      util_bitpack_uint(values->Entry[6][1][11], 12, 15) |
      util_bitpack_uint(values->Entry[6][1][12], 16, 19) |
      util_bitpack_uint(values->Entry[6][1][13], 20, 23) |
      util_bitpack_uint(values->Entry[6][1][14], 24, 27) |
      util_bitpack_uint(values->Entry[6][1][15], 28, 31);

   dw[196] =
      util_bitpack_uint(values->Entry[6][2][0], 0, 3) |
      util_bitpack_uint(values->Entry[6][2][1], 4, 7) |
      util_bitpack_uint(values->Entry[6][2][2], 8, 11) |
      util_bitpack_uint(values->Entry[6][2][3], 12, 15) |
      util_bitpack_uint(values->Entry[6][2][4], 16, 19) |
      util_bitpack_uint(values->Entry[6][2][5], 20, 23) |
      util_bitpack_uint(values->Entry[6][2][6], 24, 27) |
      util_bitpack_uint(values->Entry[6][2][7], 28, 31);

   dw[197] =
      util_bitpack_uint(values->Entry[6][2][8], 0, 3) |
      util_bitpack_uint(values->Entry[6][2][9], 4, 7) |
      util_bitpack_uint(values->Entry[6][2][10], 8, 11) |
      util_bitpack_uint(values->Entry[6][2][11], 12, 15) |
      util_bitpack_uint(values->Entry[6][2][12], 16, 19) |
      util_bitpack_uint(values->Entry[6][2][13], 20, 23) |
      util_bitpack_uint(values->Entry[6][2][14], 24, 27) |
      util_bitpack_uint(values->Entry[6][2][15], 28, 31);

   dw[198] =
      util_bitpack_uint(values->Entry[6][3][0], 0, 3) |
      util_bitpack_uint(values->Entry[6][3][1], 4, 7) |
      util_bitpack_uint(values->Entry[6][3][2], 8, 11) |
      util_bitpack_uint(values->Entry[6][3][3], 12, 15) |
      util_bitpack_uint(values->Entry[6][3][4], 16, 19) |
      util_bitpack_uint(values->Entry[6][3][5], 20, 23) |
      util_bitpack_uint(values->Entry[6][3][6], 24, 27) |
      util_bitpack_uint(values->Entry[6][3][7], 28, 31);

   dw[199] =
      util_bitpack_uint(values->Entry[6][3][8], 0, 3) |
      util_bitpack_uint(values->Entry[6][3][9], 4, 7) |
      util_bitpack_uint(values->Entry[6][3][10], 8, 11) |
      util_bitpack_uint(values->Entry[6][3][11], 12, 15) |
      util_bitpack_uint(values->Entry[6][3][12], 16, 19) |
      util_bitpack_uint(values->Entry[6][3][13], 20, 23) |
      util_bitpack_uint(values->Entry[6][3][14], 24, 27) |
      util_bitpack_uint(values->Entry[6][3][15], 28, 31);

   dw[200] =
      util_bitpack_uint(values->Entry[6][4][0], 0, 3) |
      util_bitpack_uint(values->Entry[6][4][1], 4, 7) |
      util_bitpack_uint(values->Entry[6][4][2], 8, 11) |
      util_bitpack_uint(values->Entry[6][4][3], 12, 15) |
      util_bitpack_uint(values->Entry[6][4][4], 16, 19) |
      util_bitpack_uint(values->Entry[6][4][5], 20, 23) |
      util_bitpack_uint(values->Entry[6][4][6], 24, 27) |
      util_bitpack_uint(values->Entry[6][4][7], 28, 31);

   dw[201] =
      util_bitpack_uint(values->Entry[6][4][8], 0, 3) |
      util_bitpack_uint(values->Entry[6][4][9], 4, 7) |
      util_bitpack_uint(values->Entry[6][4][10], 8, 11) |
      util_bitpack_uint(values->Entry[6][4][11], 12, 15) |
      util_bitpack_uint(values->Entry[6][4][12], 16, 19) |
      util_bitpack_uint(values->Entry[6][4][13], 20, 23) |
      util_bitpack_uint(values->Entry[6][4][14], 24, 27) |
      util_bitpack_uint(values->Entry[6][4][15], 28, 31);

   dw[202] =
      util_bitpack_uint(values->Entry[6][5][0], 0, 3) |
      util_bitpack_uint(values->Entry[6][5][1], 4, 7) |
      util_bitpack_uint(values->Entry[6][5][2], 8, 11) |
      util_bitpack_uint(values->Entry[6][5][3], 12, 15) |
      util_bitpack_uint(values->Entry[6][5][4], 16, 19) |
      util_bitpack_uint(values->Entry[6][5][5], 20, 23) |
      util_bitpack_uint(values->Entry[6][5][6], 24, 27) |
      util_bitpack_uint(values->Entry[6][5][7], 28, 31);

   dw[203] =
      util_bitpack_uint(values->Entry[6][5][8], 0, 3) |
      util_bitpack_uint(values->Entry[6][5][9], 4, 7) |
      util_bitpack_uint(values->Entry[6][5][10], 8, 11) |
      util_bitpack_uint(values->Entry[6][5][11], 12, 15) |
      util_bitpack_uint(values->Entry[6][5][12], 16, 19) |
      util_bitpack_uint(values->Entry[6][5][13], 20, 23) |
      util_bitpack_uint(values->Entry[6][5][14], 24, 27) |
      util_bitpack_uint(values->Entry[6][5][15], 28, 31);

   dw[204] =
      util_bitpack_uint(values->Entry[6][6][0], 0, 3) |
      util_bitpack_uint(values->Entry[6][6][1], 4, 7) |
      util_bitpack_uint(values->Entry[6][6][2], 8, 11) |
      util_bitpack_uint(values->Entry[6][6][3], 12, 15) |
      util_bitpack_uint(values->Entry[6][6][4], 16, 19) |
      util_bitpack_uint(values->Entry[6][6][5], 20, 23) |
      util_bitpack_uint(values->Entry[6][6][6], 24, 27) |
      util_bitpack_uint(values->Entry[6][6][7], 28, 31);

   dw[205] =
      util_bitpack_uint(values->Entry[6][6][8], 0, 3) |
      util_bitpack_uint(values->Entry[6][6][9], 4, 7) |
      util_bitpack_uint(values->Entry[6][6][10], 8, 11) |
      util_bitpack_uint(values->Entry[6][6][11], 12, 15) |
      util_bitpack_uint(values->Entry[6][6][12], 16, 19) |
      util_bitpack_uint(values->Entry[6][6][13], 20, 23) |
      util_bitpack_uint(values->Entry[6][6][14], 24, 27) |
      util_bitpack_uint(values->Entry[6][6][15], 28, 31);

   dw[206] =
      util_bitpack_uint(values->Entry[6][7][0], 0, 3) |
      util_bitpack_uint(values->Entry[6][7][1], 4, 7) |
      util_bitpack_uint(values->Entry[6][7][2], 8, 11) |
      util_bitpack_uint(values->Entry[6][7][3], 12, 15) |
      util_bitpack_uint(values->Entry[6][7][4], 16, 19) |
      util_bitpack_uint(values->Entry[6][7][5], 20, 23) |
      util_bitpack_uint(values->Entry[6][7][6], 24, 27) |
      util_bitpack_uint(values->Entry[6][7][7], 28, 31);

   dw[207] =
      util_bitpack_uint(values->Entry[6][7][8], 0, 3) |
      util_bitpack_uint(values->Entry[6][7][9], 4, 7) |
      util_bitpack_uint(values->Entry[6][7][10], 8, 11) |
      util_bitpack_uint(values->Entry[6][7][11], 12, 15) |
      util_bitpack_uint(values->Entry[6][7][12], 16, 19) |
      util_bitpack_uint(values->Entry[6][7][13], 20, 23) |
      util_bitpack_uint(values->Entry[6][7][14], 24, 27) |
      util_bitpack_uint(values->Entry[6][7][15], 28, 31);

   dw[208] =
      util_bitpack_uint(values->Entry[6][8][0], 0, 3) |
      util_bitpack_uint(values->Entry[6][8][1], 4, 7) |
      util_bitpack_uint(values->Entry[6][8][2], 8, 11) |
      util_bitpack_uint(values->Entry[6][8][3], 12, 15) |
      util_bitpack_uint(values->Entry[6][8][4], 16, 19) |
      util_bitpack_uint(values->Entry[6][8][5], 20, 23) |
      util_bitpack_uint(values->Entry[6][8][6], 24, 27) |
      util_bitpack_uint(values->Entry[6][8][7], 28, 31);

   dw[209] =
      util_bitpack_uint(values->Entry[6][8][8], 0, 3) |
      util_bitpack_uint(values->Entry[6][8][9], 4, 7) |
      util_bitpack_uint(values->Entry[6][8][10], 8, 11) |
      util_bitpack_uint(values->Entry[6][8][11], 12, 15) |
      util_bitpack_uint(values->Entry[6][8][12], 16, 19) |
      util_bitpack_uint(values->Entry[6][8][13], 20, 23) |
      util_bitpack_uint(values->Entry[6][8][14], 24, 27) |
      util_bitpack_uint(values->Entry[6][8][15], 28, 31);

   dw[210] =
      util_bitpack_uint(values->Entry[6][9][0], 0, 3) |
      util_bitpack_uint(values->Entry[6][9][1], 4, 7) |
      util_bitpack_uint(values->Entry[6][9][2], 8, 11) |
      util_bitpack_uint(values->Entry[6][9][3], 12, 15) |
      util_bitpack_uint(values->Entry[6][9][4], 16, 19) |
      util_bitpack_uint(values->Entry[6][9][5], 20, 23) |
      util_bitpack_uint(values->Entry[6][9][6], 24, 27) |
      util_bitpack_uint(values->Entry[6][9][7], 28, 31);

   dw[211] =
      util_bitpack_uint(values->Entry[6][9][8], 0, 3) |
      util_bitpack_uint(values->Entry[6][9][9], 4, 7) |
      util_bitpack_uint(values->Entry[6][9][10], 8, 11) |
      util_bitpack_uint(values->Entry[6][9][11], 12, 15) |
      util_bitpack_uint(values->Entry[6][9][12], 16, 19) |
      util_bitpack_uint(values->Entry[6][9][13], 20, 23) |
      util_bitpack_uint(values->Entry[6][9][14], 24, 27) |
      util_bitpack_uint(values->Entry[6][9][15], 28, 31);

   dw[212] =
      util_bitpack_uint(values->Entry[6][10][0], 0, 3) |
      util_bitpack_uint(values->Entry[6][10][1], 4, 7) |
      util_bitpack_uint(values->Entry[6][10][2], 8, 11) |
      util_bitpack_uint(values->Entry[6][10][3], 12, 15) |
      util_bitpack_uint(values->Entry[6][10][4], 16, 19) |
      util_bitpack_uint(values->Entry[6][10][5], 20, 23) |
      util_bitpack_uint(values->Entry[6][10][6], 24, 27) |
      util_bitpack_uint(values->Entry[6][10][7], 28, 31);

   dw[213] =
      util_bitpack_uint(values->Entry[6][10][8], 0, 3) |
      util_bitpack_uint(values->Entry[6][10][9], 4, 7) |
      util_bitpack_uint(values->Entry[6][10][10], 8, 11) |
      util_bitpack_uint(values->Entry[6][10][11], 12, 15) |
      util_bitpack_uint(values->Entry[6][10][12], 16, 19) |
      util_bitpack_uint(values->Entry[6][10][13], 20, 23) |
      util_bitpack_uint(values->Entry[6][10][14], 24, 27) |
      util_bitpack_uint(values->Entry[6][10][15], 28, 31);

   dw[214] =
      util_bitpack_uint(values->Entry[6][11][0], 0, 3) |
      util_bitpack_uint(values->Entry[6][11][1], 4, 7) |
      util_bitpack_uint(values->Entry[6][11][2], 8, 11) |
      util_bitpack_uint(values->Entry[6][11][3], 12, 15) |
      util_bitpack_uint(values->Entry[6][11][4], 16, 19) |
      util_bitpack_uint(values->Entry[6][11][5], 20, 23) |
      util_bitpack_uint(values->Entry[6][11][6], 24, 27) |
      util_bitpack_uint(values->Entry[6][11][7], 28, 31);

   dw[215] =
      util_bitpack_uint(values->Entry[6][11][8], 0, 3) |
      util_bitpack_uint(values->Entry[6][11][9], 4, 7) |
      util_bitpack_uint(values->Entry[6][11][10], 8, 11) |
      util_bitpack_uint(values->Entry[6][11][11], 12, 15) |
      util_bitpack_uint(values->Entry[6][11][12], 16, 19) |
      util_bitpack_uint(values->Entry[6][11][13], 20, 23) |
      util_bitpack_uint(values->Entry[6][11][14], 24, 27) |
      util_bitpack_uint(values->Entry[6][11][15], 28, 31);

   dw[216] =
      util_bitpack_uint(values->Entry[6][12][0], 0, 3) |
      util_bitpack_uint(values->Entry[6][12][1], 4, 7) |
      util_bitpack_uint(values->Entry[6][12][2], 8, 11) |
      util_bitpack_uint(values->Entry[6][12][3], 12, 15) |
      util_bitpack_uint(values->Entry[6][12][4], 16, 19) |
      util_bitpack_uint(values->Entry[6][12][5], 20, 23) |
      util_bitpack_uint(values->Entry[6][12][6], 24, 27) |
      util_bitpack_uint(values->Entry[6][12][7], 28, 31);

   dw[217] =
      util_bitpack_uint(values->Entry[6][12][8], 0, 3) |
      util_bitpack_uint(values->Entry[6][12][9], 4, 7) |
      util_bitpack_uint(values->Entry[6][12][10], 8, 11) |
      util_bitpack_uint(values->Entry[6][12][11], 12, 15) |
      util_bitpack_uint(values->Entry[6][12][12], 16, 19) |
      util_bitpack_uint(values->Entry[6][12][13], 20, 23) |
      util_bitpack_uint(values->Entry[6][12][14], 24, 27) |
      util_bitpack_uint(values->Entry[6][12][15], 28, 31);

   dw[218] =
      util_bitpack_uint(values->Entry[6][13][0], 0, 3) |
      util_bitpack_uint(values->Entry[6][13][1], 4, 7) |
      util_bitpack_uint(values->Entry[6][13][2], 8, 11) |
      util_bitpack_uint(values->Entry[6][13][3], 12, 15) |
      util_bitpack_uint(values->Entry[6][13][4], 16, 19) |
      util_bitpack_uint(values->Entry[6][13][5], 20, 23) |
      util_bitpack_uint(values->Entry[6][13][6], 24, 27) |
      util_bitpack_uint(values->Entry[6][13][7], 28, 31);

   dw[219] =
      util_bitpack_uint(values->Entry[6][13][8], 0, 3) |
      util_bitpack_uint(values->Entry[6][13][9], 4, 7) |
      util_bitpack_uint(values->Entry[6][13][10], 8, 11) |
      util_bitpack_uint(values->Entry[6][13][11], 12, 15) |
      util_bitpack_uint(values->Entry[6][13][12], 16, 19) |
      util_bitpack_uint(values->Entry[6][13][13], 20, 23) |
      util_bitpack_uint(values->Entry[6][13][14], 24, 27) |
      util_bitpack_uint(values->Entry[6][13][15], 28, 31);

   dw[220] =
      util_bitpack_uint(values->Entry[6][14][0], 0, 3) |
      util_bitpack_uint(values->Entry[6][14][1], 4, 7) |
      util_bitpack_uint(values->Entry[6][14][2], 8, 11) |
      util_bitpack_uint(values->Entry[6][14][3], 12, 15) |
      util_bitpack_uint(values->Entry[6][14][4], 16, 19) |
      util_bitpack_uint(values->Entry[6][14][5], 20, 23) |
      util_bitpack_uint(values->Entry[6][14][6], 24, 27) |
      util_bitpack_uint(values->Entry[6][14][7], 28, 31);

   dw[221] =
      util_bitpack_uint(values->Entry[6][14][8], 0, 3) |
      util_bitpack_uint(values->Entry[6][14][9], 4, 7) |
      util_bitpack_uint(values->Entry[6][14][10], 8, 11) |
      util_bitpack_uint(values->Entry[6][14][11], 12, 15) |
      util_bitpack_uint(values->Entry[6][14][12], 16, 19) |
      util_bitpack_uint(values->Entry[6][14][13], 20, 23) |
      util_bitpack_uint(values->Entry[6][14][14], 24, 27) |
      util_bitpack_uint(values->Entry[6][14][15], 28, 31);

   dw[222] =
      util_bitpack_uint(values->Entry[6][15][0], 0, 3) |
      util_bitpack_uint(values->Entry[6][15][1], 4, 7) |
      util_bitpack_uint(values->Entry[6][15][2], 8, 11) |
      util_bitpack_uint(values->Entry[6][15][3], 12, 15) |
      util_bitpack_uint(values->Entry[6][15][4], 16, 19) |
      util_bitpack_uint(values->Entry[6][15][5], 20, 23) |
      util_bitpack_uint(values->Entry[6][15][6], 24, 27) |
      util_bitpack_uint(values->Entry[6][15][7], 28, 31);

   dw[223] =
      util_bitpack_uint(values->Entry[6][15][8], 0, 3) |
      util_bitpack_uint(values->Entry[6][15][9], 4, 7) |
      util_bitpack_uint(values->Entry[6][15][10], 8, 11) |
      util_bitpack_uint(values->Entry[6][15][11], 12, 15) |
      util_bitpack_uint(values->Entry[6][15][12], 16, 19) |
      util_bitpack_uint(values->Entry[6][15][13], 20, 23) |
      util_bitpack_uint(values->Entry[6][15][14], 24, 27) |
      util_bitpack_uint(values->Entry[6][15][15], 28, 31);
}

#define GFX20_SO_DECL_length                   1
struct GFX20_SO_DECL {
   uint32_t                             ComponentMask;
   uint32_t                             RegisterIndex;
   bool                                 HoleFlag;
   uint32_t                             OutputBufferSlot;
};

static inline __attribute__((always_inline)) void
GFX20_SO_DECL_pack(__attribute__((unused)) __gen_user_data *data,
                   __attribute__((unused)) void * restrict dst,
                   __attribute__((unused)) const struct GFX20_SO_DECL * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->ComponentMask, 0, 3) |
      util_bitpack_uint(values->RegisterIndex, 4, 9) |
      util_bitpack_uint(values->HoleFlag, 11, 11) |
      util_bitpack_uint(values->OutputBufferSlot, 12, 13);
}

#define GFX20_SO_DECL_ENTRY_length             2
struct GFX20_SO_DECL_ENTRY {
   struct GFX20_SO_DECL                 Stream0Decl;
   struct GFX20_SO_DECL                 Stream1Decl;
   struct GFX20_SO_DECL                 Stream2Decl;
   struct GFX20_SO_DECL                 Stream3Decl;
};

static inline __attribute__((always_inline)) void
GFX20_SO_DECL_ENTRY_pack(__attribute__((unused)) __gen_user_data *data,
                         __attribute__((unused)) void * restrict dst,
                         __attribute__((unused)) const struct GFX20_SO_DECL_ENTRY * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   uint32_t v0_0;
   GFX20_SO_DECL_pack(data, &v0_0, &values->Stream0Decl);

   uint32_t v0_1;
   GFX20_SO_DECL_pack(data, &v0_1, &values->Stream1Decl);

   dw[0] =
      util_bitpack_uint(v0_0, 0, 15) |
      util_bitpack_uint(v0_1, 16, 31);

   uint32_t v1_0;
   GFX20_SO_DECL_pack(data, &v1_0, &values->Stream2Decl);

   uint32_t v1_1;
   GFX20_SO_DECL_pack(data, &v1_1, &values->Stream3Decl);

   dw[1] =
      util_bitpack_uint(v1_0, 0, 15) |
      util_bitpack_uint(v1_1, 16, 31);
}

#define GFX20_VDENC_SURFACE_CONTROL_BITS_length      1
struct GFX20_VDENC_SURFACE_CONTROL_BITS {
   uint32_t                             MOCS;
   uint32_t                             ArbitrationPriorityControl;
#define Highestpriority                          0
#define Secondhighestpriority                    1
#define Thirdhighestpriority                     2
#define Lowestpriority                           3
   bool                                 MemoryCompressionEnable;
   uint32_t                             MemoryCompressionMode;
   uint32_t                             CacheSelect;
};

static inline __attribute__((always_inline)) void
GFX20_VDENC_SURFACE_CONTROL_BITS_pack(__attribute__((unused)) __gen_user_data *data,
                                      __attribute__((unused)) void * restrict dst,
                                      __attribute__((unused)) const struct GFX20_VDENC_SURFACE_CONTROL_BITS * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint_nonzero(values->MOCS, 0, 6) |
      util_bitpack_uint(values->ArbitrationPriorityControl, 7, 8) |
      util_bitpack_uint(values->MemoryCompressionEnable, 9, 9) |
      util_bitpack_uint(values->MemoryCompressionMode, 10, 10) |
      util_bitpack_uint(values->CacheSelect, 12, 12);
}

#define GFX20_VDENC_PICTURE_length             3
struct GFX20_VDENC_PICTURE {
   __gen_address_type                   Address;
   struct GFX20_VDENC_SURFACE_CONTROL_BITS PictureFields;
};

static inline __attribute__((always_inline)) void
GFX20_VDENC_PICTURE_pack(__attribute__((unused)) __gen_user_data *data,
                         __attribute__((unused)) void * restrict dst,
                         __attribute__((unused)) const struct GFX20_VDENC_PICTURE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   const uint64_t v0_address =
      __gen_address(data, &dw[0], values->Address, 0, 0, 63);
   dw[0] = v0_address;
   dw[1] = v0_address >> 32;

   GFX20_VDENC_SURFACE_CONTROL_BITS_pack(data, &dw[2], &values->PictureFields);
}

#define GFX20_VDENC_SURFACE_STATE_FIELDS_length      4
struct GFX20_VDENC_SURFACE_STATE_FIELDS {
   float                                CrVCbUPixelOffsetVDirection;
   bool                                 SurfaceFormatByteSwizzle;
   uint32_t                             Colorspaceselection;
   uint32_t                             Width;
   uint32_t                             Height;
   uint32_t                             TileWalk;
#define TW_XMAJOR                                0
#define TW_YMAJOR                                1
   uint32_t                             TiledSurface;
   bool                                 HalfPitchforChroma;
   uint32_t                             SurfacePitch;
   uint32_t                             ChromaDownsampleFilterControl;
   uint32_t                             SurfaceFormat;
#define VDENC_YUV422                             0
#define VDENC_RGBA4444                           1
#define VDENC_YUV444                             2
#define VDENC_Y8_UNORM                           3
#define VDENC_PLANAR_420_8                       4
   uint32_t                             YOffsetforUCb;
   uint32_t                             XOffsetforUCb;
   uint32_t                             YOffsetforVCr;
   uint32_t                             XOffsetforVCr;
};

static inline __attribute__((always_inline)) void
GFX20_VDENC_SURFACE_STATE_FIELDS_pack(__attribute__((unused)) __gen_user_data *data,
                                      __attribute__((unused)) void * restrict dst,
                                      __attribute__((unused)) const struct GFX20_VDENC_SURFACE_STATE_FIELDS * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_ufixed(values->CrVCbUPixelOffsetVDirection, 0, 1, 2) |
      util_bitpack_uint(values->SurfaceFormatByteSwizzle, 2, 2) |
      util_bitpack_uint(values->Colorspaceselection, 3, 3) |
      util_bitpack_uint(values->Width, 4, 17) |
      util_bitpack_uint(values->Height, 18, 31);

   dw[1] =
      util_bitpack_uint(values->TileWalk, 0, 0) |
      util_bitpack_uint(values->TiledSurface, 1, 1) |
      util_bitpack_uint(values->HalfPitchforChroma, 2, 2) |
      util_bitpack_uint(values->SurfacePitch, 3, 19) |
      util_bitpack_uint(values->ChromaDownsampleFilterControl, 20, 22) |
      util_bitpack_uint(values->SurfaceFormat, 27, 31);

   dw[2] =
      util_bitpack_uint(values->YOffsetforUCb, 0, 14) |
      util_bitpack_uint(values->XOffsetforUCb, 16, 30);

   dw[3] =
      util_bitpack_uint(values->YOffsetforVCr, 0, 15) |
      util_bitpack_uint(values->XOffsetforVCr, 16, 28);
}

#define GFX20_VD_CONTROL_STATE_BODY_length      2
struct GFX20_VD_CONTROL_STATE_BODY {
   bool                                 PipelineInitialization;
   bool                                 ScalableModePipeLock;
   bool                                 ScalableModePipeUnlock;
   bool                                 MemoryImplicitFlush;
};

static inline __attribute__((always_inline)) void
GFX20_VD_CONTROL_STATE_BODY_pack(__attribute__((unused)) __gen_user_data *data,
                                 __attribute__((unused)) void * restrict dst,
                                 __attribute__((unused)) const struct GFX20_VD_CONTROL_STATE_BODY * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->PipelineInitialization, 0, 0);

   dw[1] =
      util_bitpack_uint(values->ScalableModePipeLock, 0, 0) |
      util_bitpack_uint(values->ScalableModePipeUnlock, 1, 1) |
      util_bitpack_uint(values->MemoryImplicitFlush, 2, 2);
}

#define GFX20_VERTEX_BUFFER_STATE_length       4
struct GFX20_VERTEX_BUFFER_STATE {
   uint32_t                             BufferPitch;
   bool                                 NullVertexBuffer;
   bool                                 AddressModifyEnable;
   uint32_t                             MOCS;
   bool                                 L3BypassDisable;
   uint32_t                             VertexBufferIndex;
   __gen_address_type                   BufferStartingAddress;
   uint32_t                             BufferSize;
};

static inline __attribute__((always_inline)) void
GFX20_VERTEX_BUFFER_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                               __attribute__((unused)) void * restrict dst,
                               __attribute__((unused)) const struct GFX20_VERTEX_BUFFER_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->BufferPitch, 0, 11) |
      util_bitpack_uint(values->NullVertexBuffer, 13, 13) |
      util_bitpack_uint(values->AddressModifyEnable, 14, 14) |
      util_bitpack_uint_nonzero(values->MOCS, 16, 22) |
      util_bitpack_uint(values->L3BypassDisable, 25, 25) |
      util_bitpack_uint(values->VertexBufferIndex, 26, 31);

   const uint64_t v1_address =
      __gen_address(data, &dw[1], values->BufferStartingAddress, 0, 0, 63);
   dw[1] = v1_address;
   dw[2] = v1_address >> 32;

   dw[3] =
      util_bitpack_uint(values->BufferSize, 0, 31);
}

#define GFX20_VERTEX_ELEMENT_STATE_length      2
struct GFX20_VERTEX_ELEMENT_STATE {
   uint32_t                             SourceElementOffset;
   bool                                 EdgeFlagEnable;
   uint32_t                             SourceElementFormat;
   bool                                 Valid;
   uint32_t                             VertexBufferIndex;
   enum GFX20_3D_Vertex_Component_Control Component3Control;
   enum GFX20_3D_Vertex_Component_Control Component2Control;
   enum GFX20_3D_Vertex_Component_Control Component1Control;
   enum GFX20_3D_Vertex_Component_Control Component0Control;
};

static inline __attribute__((always_inline)) void
GFX20_VERTEX_ELEMENT_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                                __attribute__((unused)) void * restrict dst,
                                __attribute__((unused)) const struct GFX20_VERTEX_ELEMENT_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->SourceElementOffset, 0, 11) |
      util_bitpack_uint(values->EdgeFlagEnable, 15, 15) |
      util_bitpack_uint(values->SourceElementFormat, 16, 24) |
      util_bitpack_uint(values->Valid, 25, 25) |
      util_bitpack_uint(values->VertexBufferIndex, 26, 31);

   dw[1] =
      util_bitpack_uint(values->Component3Control, 16, 18) |
      util_bitpack_uint(values->Component2Control, 20, 22) |
      util_bitpack_uint(values->Component1Control, 24, 26) |
      util_bitpack_uint(values->Component0Control, 28, 30);
}

#define GFX20_AVP_BSD_OBJECT_length            3
#define GFX20_AVP_BSD_OBJECT_length_bias       2
#define GFX20_AVP_BSD_OBJECT_header             \
   .DWordLength                         =      1,  \
   .SubOpcode                           =     32,  \
   .MediaCommandOpcode                  =      3,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_AVP_BSD_OBJECT {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcode;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             TileIndirectBSDDataLength;
   uint32_t                             TileIndirectDataStartAddress;
};

static inline __attribute__((always_inline)) void
GFX20_AVP_BSD_OBJECT_pack(__attribute__((unused)) __gen_user_data *data,
                          __attribute__((unused)) void * restrict dst,
                          __attribute__((unused)) const struct GFX20_AVP_BSD_OBJECT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcode, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->TileIndirectBSDDataLength, 0, 31);

   dw[2] =
      util_bitpack_uint(values->TileIndirectDataStartAddress, 0, 31);
}

#define GFX20_AVP_FILM_GRAIN_STATE_length     45
#define GFX20_AVP_FILM_GRAIN_STATE_length_bias      2
#define GFX20_AVP_FILM_GRAIN_STATE_header       \
   .DWordLength                         =     43,  \
   .SubOpcode                           =     52,  \
   .MediaCommandOpcode                  =      3,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_AVP_FILM_GRAIN_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcode;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             GrainRandomSeed;
   bool                                 MCIdentityFlag;
   bool                                 ClipToRestrictedRangeFlag;
   uint32_t                             NumberofLumaPoints;
   uint32_t                             NumberofChromaCbPoints;
   uint32_t                             NumberofChromaCrPoints;
   uint32_t                             GrainScalingMinus8;
   uint32_t                             ARCoeffLag;
   uint32_t                             ARCoeffShiftMinus6;
   uint32_t                             GrainScaleShift;
   bool                                 GrainNoiseOverlapFlag;
   bool                                 ChromaScalingFromLumaFlag;
   uint32_t                             PointLumaValue[14];
   uint32_t                             PointLumaScaling[14];
   uint32_t                             PointCBValue[10];
   uint32_t                             PointCBScaling[10];
   uint32_t                             PointCRValue[10];
   uint32_t                             PointCRScaling[10];
   uint32_t                             ARCoeffLumaPlus128[24];
   uint32_t                             ARCoeffChromaCBPlus128[25];
   uint32_t                             ARCoeffChromaCRPlus128[25];
   uint32_t                             CBMult;
   uint32_t                             CBLumaMult;
   uint32_t                             CBOffset;
   uint32_t                             CRMult;
   uint32_t                             CRLumaMult;
   uint32_t                             CROffset;
};

static inline __attribute__((always_inline)) void
GFX20_AVP_FILM_GRAIN_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                                __attribute__((unused)) void * restrict dst,
                                __attribute__((unused)) const struct GFX20_AVP_FILM_GRAIN_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcode, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->GrainRandomSeed, 0, 15) |
      util_bitpack_uint(values->MCIdentityFlag, 16, 16) |
      util_bitpack_uint(values->ClipToRestrictedRangeFlag, 17, 17) |
      util_bitpack_uint(values->NumberofLumaPoints, 20, 23) |
      util_bitpack_uint(values->NumberofChromaCbPoints, 24, 27) |
      util_bitpack_uint(values->NumberofChromaCrPoints, 28, 31);

   dw[2] =
      util_bitpack_uint(values->GrainScalingMinus8, 0, 1) |
      util_bitpack_uint(values->ARCoeffLag, 2, 3) |
      util_bitpack_uint(values->ARCoeffShiftMinus6, 4, 5) |
      util_bitpack_uint(values->GrainScaleShift, 6, 7) |
      util_bitpack_uint(values->GrainNoiseOverlapFlag, 8, 8) |
      util_bitpack_uint(values->ChromaScalingFromLumaFlag, 31, 31);

   dw[3] =
      util_bitpack_uint(values->PointLumaValue[0], 0, 7) |
      util_bitpack_uint(values->PointLumaValue[1], 8, 15) |
      util_bitpack_uint(values->PointLumaValue[2], 16, 23) |
      util_bitpack_uint(values->PointLumaValue[3], 24, 31);

   dw[4] =
      util_bitpack_uint(values->PointLumaValue[4], 0, 7) |
      util_bitpack_uint(values->PointLumaValue[5], 8, 15) |
      util_bitpack_uint(values->PointLumaValue[6], 16, 23) |
      util_bitpack_uint(values->PointLumaValue[7], 24, 31);

   dw[5] =
      util_bitpack_uint(values->PointLumaValue[8], 0, 7) |
      util_bitpack_uint(values->PointLumaValue[9], 8, 15) |
      util_bitpack_uint(values->PointLumaValue[10], 16, 23) |
      util_bitpack_uint(values->PointLumaValue[11], 24, 31);

   dw[6] =
      util_bitpack_uint(values->PointLumaValue[12], 0, 7) |
      util_bitpack_uint(values->PointLumaValue[13], 8, 15);

   dw[7] =
      util_bitpack_uint(values->PointLumaScaling[0], 0, 7) |
      util_bitpack_uint(values->PointLumaScaling[1], 8, 15) |
      util_bitpack_uint(values->PointLumaScaling[2], 16, 23) |
      util_bitpack_uint(values->PointLumaScaling[3], 24, 31);

   dw[8] =
      util_bitpack_uint(values->PointLumaScaling[4], 0, 7) |
      util_bitpack_uint(values->PointLumaScaling[5], 8, 15) |
      util_bitpack_uint(values->PointLumaScaling[6], 16, 23) |
      util_bitpack_uint(values->PointLumaScaling[7], 24, 31);

   dw[9] =
      util_bitpack_uint(values->PointLumaScaling[8], 0, 7) |
      util_bitpack_uint(values->PointLumaScaling[9], 8, 15) |
      util_bitpack_uint(values->PointLumaScaling[10], 16, 23) |
      util_bitpack_uint(values->PointLumaScaling[11], 24, 31);

   dw[10] =
      util_bitpack_uint(values->PointLumaScaling[12], 0, 7) |
      util_bitpack_uint(values->PointLumaScaling[13], 8, 15);

   dw[11] =
      util_bitpack_uint(values->PointCBValue[0], 0, 7) |
      util_bitpack_uint(values->PointCBValue[1], 8, 15) |
      util_bitpack_uint(values->PointCBValue[2], 16, 23) |
      util_bitpack_uint(values->PointCBValue[3], 24, 31);

   dw[12] =
      util_bitpack_uint(values->PointCBValue[4], 0, 7) |
      util_bitpack_uint(values->PointCBValue[5], 8, 15) |
      util_bitpack_uint(values->PointCBValue[6], 16, 23) |
      util_bitpack_uint(values->PointCBValue[7], 24, 31);

   dw[13] =
      util_bitpack_uint(values->PointCBValue[8], 0, 7) |
      util_bitpack_uint(values->PointCBValue[9], 8, 15);

   dw[14] =
      util_bitpack_uint(values->PointCBScaling[0], 0, 7) |
      util_bitpack_uint(values->PointCBScaling[1], 8, 15) |
      util_bitpack_uint(values->PointCBScaling[2], 16, 23) |
      util_bitpack_uint(values->PointCBScaling[3], 24, 31);

   dw[15] =
      util_bitpack_uint(values->PointCBScaling[4], 0, 7) |
      util_bitpack_uint(values->PointCBScaling[5], 8, 15) |
      util_bitpack_uint(values->PointCBScaling[6], 16, 23) |
      util_bitpack_uint(values->PointCBScaling[7], 24, 31);

   dw[16] =
      util_bitpack_uint(values->PointCBScaling[8], 0, 7) |
      util_bitpack_uint(values->PointCBScaling[9], 8, 15);

   dw[17] =
      util_bitpack_uint(values->PointCRValue[0], 0, 7) |
      util_bitpack_uint(values->PointCRValue[1], 8, 15) |
      util_bitpack_uint(values->PointCRValue[2], 16, 23) |
      util_bitpack_uint(values->PointCRValue[3], 24, 31);

   dw[18] =
      util_bitpack_uint(values->PointCRValue[4], 0, 7) |
      util_bitpack_uint(values->PointCRValue[5], 8, 15) |
      util_bitpack_uint(values->PointCRValue[6], 16, 23) |
      util_bitpack_uint(values->PointCRValue[7], 24, 31);

   dw[19] =
      util_bitpack_uint(values->PointCRValue[8], 0, 7) |
      util_bitpack_uint(values->PointCRValue[9], 8, 15);

   dw[20] =
      util_bitpack_uint(values->PointCRScaling[0], 0, 7) |
      util_bitpack_uint(values->PointCRScaling[1], 8, 15) |
      util_bitpack_uint(values->PointCRScaling[2], 16, 23) |
      util_bitpack_uint(values->PointCRScaling[3], 24, 31);

   dw[21] =
      util_bitpack_uint(values->PointCRScaling[4], 0, 7) |
      util_bitpack_uint(values->PointCRScaling[5], 8, 15) |
      util_bitpack_uint(values->PointCRScaling[6], 16, 23) |
      util_bitpack_uint(values->PointCRScaling[7], 24, 31);

   dw[22] =
      util_bitpack_uint(values->PointCRScaling[8], 0, 7) |
      util_bitpack_uint(values->PointCRScaling[9], 8, 15);

   dw[23] =
      util_bitpack_uint(values->ARCoeffLumaPlus128[0], 0, 7) |
      util_bitpack_uint(values->ARCoeffLumaPlus128[1], 8, 15) |
      util_bitpack_uint(values->ARCoeffLumaPlus128[2], 16, 23) |
      util_bitpack_uint(values->ARCoeffLumaPlus128[3], 24, 31);

   dw[24] =
      util_bitpack_uint(values->ARCoeffLumaPlus128[4], 0, 7) |
      util_bitpack_uint(values->ARCoeffLumaPlus128[5], 8, 15) |
      util_bitpack_uint(values->ARCoeffLumaPlus128[6], 16, 23) |
      util_bitpack_uint(values->ARCoeffLumaPlus128[7], 24, 31);

   dw[25] =
      util_bitpack_uint(values->ARCoeffLumaPlus128[8], 0, 7) |
      util_bitpack_uint(values->ARCoeffLumaPlus128[9], 8, 15) |
      util_bitpack_uint(values->ARCoeffLumaPlus128[10], 16, 23) |
      util_bitpack_uint(values->ARCoeffLumaPlus128[11], 24, 31);

   dw[26] =
      util_bitpack_uint(values->ARCoeffLumaPlus128[12], 0, 7) |
      util_bitpack_uint(values->ARCoeffLumaPlus128[13], 8, 15) |
      util_bitpack_uint(values->ARCoeffLumaPlus128[14], 16, 23) |
      util_bitpack_uint(values->ARCoeffLumaPlus128[15], 24, 31);

   dw[27] =
      util_bitpack_uint(values->ARCoeffLumaPlus128[16], 0, 7) |
      util_bitpack_uint(values->ARCoeffLumaPlus128[17], 8, 15) |
      util_bitpack_uint(values->ARCoeffLumaPlus128[18], 16, 23) |
      util_bitpack_uint(values->ARCoeffLumaPlus128[19], 24, 31);

   dw[28] =
      util_bitpack_uint(values->ARCoeffLumaPlus128[20], 0, 7) |
      util_bitpack_uint(values->ARCoeffLumaPlus128[21], 8, 15) |
      util_bitpack_uint(values->ARCoeffLumaPlus128[22], 16, 23) |
      util_bitpack_uint(values->ARCoeffLumaPlus128[23], 24, 31);

   dw[29] =
      util_bitpack_uint(values->ARCoeffChromaCBPlus128[0], 0, 7) |
      util_bitpack_uint(values->ARCoeffChromaCBPlus128[1], 8, 15) |
      util_bitpack_uint(values->ARCoeffChromaCBPlus128[2], 16, 23) |
      util_bitpack_uint(values->ARCoeffChromaCBPlus128[3], 24, 31);

   dw[30] =
      util_bitpack_uint(values->ARCoeffChromaCBPlus128[4], 0, 7) |
      util_bitpack_uint(values->ARCoeffChromaCBPlus128[5], 8, 15) |
      util_bitpack_uint(values->ARCoeffChromaCBPlus128[6], 16, 23) |
      util_bitpack_uint(values->ARCoeffChromaCBPlus128[7], 24, 31);

   dw[31] =
      util_bitpack_uint(values->ARCoeffChromaCBPlus128[8], 0, 7) |
      util_bitpack_uint(values->ARCoeffChromaCBPlus128[9], 8, 15) |
      util_bitpack_uint(values->ARCoeffChromaCBPlus128[10], 16, 23) |
      util_bitpack_uint(values->ARCoeffChromaCBPlus128[11], 24, 31);

   dw[32] =
      util_bitpack_uint(values->ARCoeffChromaCBPlus128[12], 0, 7) |
      util_bitpack_uint(values->ARCoeffChromaCBPlus128[13], 8, 15) |
      util_bitpack_uint(values->ARCoeffChromaCBPlus128[14], 16, 23) |
      util_bitpack_uint(values->ARCoeffChromaCBPlus128[15], 24, 31);

   dw[33] =
      util_bitpack_uint(values->ARCoeffChromaCBPlus128[16], 0, 7) |
      util_bitpack_uint(values->ARCoeffChromaCBPlus128[17], 8, 15) |
      util_bitpack_uint(values->ARCoeffChromaCBPlus128[18], 16, 23) |
      util_bitpack_uint(values->ARCoeffChromaCBPlus128[19], 24, 31);

   dw[34] =
      util_bitpack_uint(values->ARCoeffChromaCBPlus128[20], 0, 7) |
      util_bitpack_uint(values->ARCoeffChromaCBPlus128[21], 8, 15) |
      util_bitpack_uint(values->ARCoeffChromaCBPlus128[22], 16, 23) |
      util_bitpack_uint(values->ARCoeffChromaCBPlus128[23], 24, 31);

   dw[35] =
      util_bitpack_uint(values->ARCoeffChromaCBPlus128[24], 0, 7);

   dw[36] =
      util_bitpack_uint(values->ARCoeffChromaCRPlus128[0], 0, 7) |
      util_bitpack_uint(values->ARCoeffChromaCRPlus128[1], 8, 15) |
      util_bitpack_uint(values->ARCoeffChromaCRPlus128[2], 16, 23) |
      util_bitpack_uint(values->ARCoeffChromaCRPlus128[3], 24, 31);

   dw[37] =
      util_bitpack_uint(values->ARCoeffChromaCRPlus128[4], 0, 7) |
      util_bitpack_uint(values->ARCoeffChromaCRPlus128[5], 8, 15) |
      util_bitpack_uint(values->ARCoeffChromaCRPlus128[6], 16, 23) |
      util_bitpack_uint(values->ARCoeffChromaCRPlus128[7], 24, 31);

   dw[38] =
      util_bitpack_uint(values->ARCoeffChromaCRPlus128[8], 0, 7) |
      util_bitpack_uint(values->ARCoeffChromaCRPlus128[9], 8, 15) |
      util_bitpack_uint(values->ARCoeffChromaCRPlus128[10], 16, 23) |
      util_bitpack_uint(values->ARCoeffChromaCRPlus128[11], 24, 31);

   dw[39] =
      util_bitpack_uint(values->ARCoeffChromaCRPlus128[12], 0, 7) |
      util_bitpack_uint(values->ARCoeffChromaCRPlus128[13], 8, 15) |
      util_bitpack_uint(values->ARCoeffChromaCRPlus128[14], 16, 23) |
      util_bitpack_uint(values->ARCoeffChromaCRPlus128[15], 24, 31);

   dw[40] =
      util_bitpack_uint(values->ARCoeffChromaCRPlus128[16], 0, 7) |
      util_bitpack_uint(values->ARCoeffChromaCRPlus128[17], 8, 15) |
      util_bitpack_uint(values->ARCoeffChromaCRPlus128[18], 16, 23) |
      util_bitpack_uint(values->ARCoeffChromaCRPlus128[19], 24, 31);

   dw[41] =
      util_bitpack_uint(values->ARCoeffChromaCRPlus128[20], 0, 7) |
      util_bitpack_uint(values->ARCoeffChromaCRPlus128[21], 8, 15) |
      util_bitpack_uint(values->ARCoeffChromaCRPlus128[22], 16, 23) |
      util_bitpack_uint(values->ARCoeffChromaCRPlus128[23], 24, 31);

   dw[42] =
      util_bitpack_uint(values->ARCoeffChromaCRPlus128[24], 0, 7);

   dw[43] =
      util_bitpack_uint(values->CBMult, 0, 7) |
      util_bitpack_uint(values->CBLumaMult, 8, 15) |
      util_bitpack_uint(values->CBOffset, 16, 24);

   dw[44] =
      util_bitpack_uint(values->CRMult, 0, 7) |
      util_bitpack_uint(values->CRLumaMult, 8, 15) |
      util_bitpack_uint(values->CROffset, 16, 24);
}

#define GFX20_AVP_IND_OBJ_BASE_ADDR_STATE_length      6
#define GFX20_AVP_IND_OBJ_BASE_ADDR_STATE_length_bias      2
#define GFX20_AVP_IND_OBJ_BASE_ADDR_STATE_header\
   .DWordLength                         =      4,  \
   .SubOpcode                           =      3,  \
   .MediaCommandOpcode                  =      3,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_AVP_IND_OBJ_BASE_ADDR_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcode;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   __gen_address_type                   AVPIndirectBitstreamObjectBaseAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES AVPIndirectBitstreamObjectAddressAttributes;
   __gen_address_type                   AVPIndirectCUObjectBaseAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES AVPIndirectCUObjectMemoryAddressAttributes;
};

static inline __attribute__((always_inline)) void
GFX20_AVP_IND_OBJ_BASE_ADDR_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                                       __attribute__((unused)) void * restrict dst,
                                       __attribute__((unused)) const struct GFX20_AVP_IND_OBJ_BASE_ADDR_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcode, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   const uint64_t v1_address =
      __gen_address(data, &dw[1], values->AVPIndirectBitstreamObjectBaseAddress, 0, 0, 63);
   dw[1] = v1_address;
   dw[2] = v1_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[3], &values->AVPIndirectBitstreamObjectAddressAttributes);

   dw[4] = 0;

   dw[5] = 0;
}

#define GFX20_AVP_INLOOP_FILTER_STATE_length     15
#define GFX20_AVP_INLOOP_FILTER_STATE_length_bias      2
#define GFX20_AVP_INLOOP_FILTER_STATE_header    \
   .DWordLength                         =     13,  \
   .SubOpcode                           =     51,  \
   .MediaCommandOpcode                  =      3,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_AVP_INLOOP_FILTER_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcode;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             LumaYDeblockerFilterLevelVertical;
   uint32_t                             LumaYDeblockerFilterLevelHorizontal;
   uint32_t                             ChromaUDeblockerFilterLevel;
   uint32_t                             ChromaVDeblockerFilterLevel;
   uint32_t                             DeblockerFilterSharpnessLevel;
   bool                                 DeblockerFilterModeRefDeltaEnableFlag;
   uint32_t                             DeblockerDeltaLFResolution;
   bool                                 DeblockerFilterDeltaLFMultiFlag;
   bool                                 DeblockerFilterDeltaLFPresentFlag;
   int32_t                              DeblockerFilterRefDeltas0;
   int32_t                              DeblockerFilterRefDeltas1;
   int32_t                              DeblockerFilterRefDeltas2;
   int32_t                              DeblockerFilterRefDeltas3;
   int32_t                              DeblockerFilterRefDeltas4;
   int32_t                              DeblockerFilterRefDeltas5;
   int32_t                              DeblockerFilterRefDeltas6;
   int32_t                              DeblockerFilterRefDeltas7;
   int32_t                              DeblockerFilterModeDeltas0;
   int32_t                              DeblockerFilterModeDeltas1;
   uint32_t                             CDEFYStrength0;
   uint32_t                             CDEFYStrength1;
   uint32_t                             CDEFYStrength2;
   uint32_t                             CDEFYStrength3;
   uint32_t                             CDEFBits;
   uint32_t                             CDEFFilterDmpaingFactorMinus3;
   uint32_t                             CDEFYStrength4;
   uint32_t                             CDEFYStrength5;
   uint32_t                             CDEFYStrength6;
   uint32_t                             CDEFYStrength7;
   uint32_t                             CDEFUVStrength0;
   uint32_t                             CDEFUVStrength1;
   uint32_t                             CDEFUVStrength2;
   uint32_t                             CDEFUVStrength3;
   uint32_t                             CDEFUVStrength4;
   uint32_t                             CDEFUVStrength5;
   uint32_t                             CDEFUVStrength6;
   uint32_t                             CDEFUVStrength7;
   uint32_t                             SuperResUpscaledFrameWidthMinus1;
   uint32_t                             SuperResDenom;
   uint32_t                             FrameLoopRestorationFilterLumaY;
   uint32_t                             FrameLoopRestorationFilterChromaU;
   uint32_t                             FrameLoopRestorationFilterChromaV;
   uint32_t                             LoopRestorationUnitSizeLumaY;
   bool                                 UseSameLoopRestorationUnitSizeChromasUVFlag;
   uint32_t                             LumaPlanex_step_qn;
   uint32_t                             LumaPlanex0_qn;
   uint32_t                             ChromaPlanex_step_qn;
   uint32_t                             ChromaPlanex0_qn;
};

static inline __attribute__((always_inline)) void
GFX20_AVP_INLOOP_FILTER_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                                   __attribute__((unused)) void * restrict dst,
                                   __attribute__((unused)) const struct GFX20_AVP_INLOOP_FILTER_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcode, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->LumaYDeblockerFilterLevelVertical, 0, 5) |
      util_bitpack_uint(values->LumaYDeblockerFilterLevelHorizontal, 6, 11) |
      util_bitpack_uint(values->ChromaUDeblockerFilterLevel, 12, 17) |
      util_bitpack_uint(values->ChromaVDeblockerFilterLevel, 18, 23) |
      util_bitpack_uint(values->DeblockerFilterSharpnessLevel, 24, 26) |
      util_bitpack_uint(values->DeblockerFilterModeRefDeltaEnableFlag, 27, 27) |
      util_bitpack_uint(values->DeblockerDeltaLFResolution, 28, 29) |
      util_bitpack_uint(values->DeblockerFilterDeltaLFMultiFlag, 30, 30) |
      util_bitpack_uint(values->DeblockerFilterDeltaLFPresentFlag, 31, 31);

   dw[2] =
      util_bitpack_sint(values->DeblockerFilterRefDeltas0, 0, 6) |
      util_bitpack_sint(values->DeblockerFilterRefDeltas1, 8, 14) |
      util_bitpack_sint(values->DeblockerFilterRefDeltas2, 16, 22) |
      util_bitpack_sint(values->DeblockerFilterRefDeltas3, 24, 30);

   dw[3] =
      util_bitpack_sint(values->DeblockerFilterRefDeltas4, 0, 6) |
      util_bitpack_sint(values->DeblockerFilterRefDeltas5, 8, 14) |
      util_bitpack_sint(values->DeblockerFilterRefDeltas6, 16, 22) |
      util_bitpack_sint(values->DeblockerFilterRefDeltas7, 24, 30);

   dw[4] =
      util_bitpack_sint(values->DeblockerFilterModeDeltas0, 0, 6) |
      util_bitpack_sint(values->DeblockerFilterModeDeltas1, 8, 14);

   dw[5] =
      util_bitpack_uint(values->CDEFYStrength0, 0, 5) |
      util_bitpack_uint(values->CDEFYStrength1, 6, 11) |
      util_bitpack_uint(values->CDEFYStrength2, 12, 17) |
      util_bitpack_uint(values->CDEFYStrength3, 18, 23) |
      util_bitpack_uint(values->CDEFBits, 28, 29) |
      util_bitpack_uint(values->CDEFFilterDmpaingFactorMinus3, 30, 31);

   dw[6] =
      util_bitpack_uint(values->CDEFYStrength4, 0, 5) |
      util_bitpack_uint(values->CDEFYStrength5, 6, 11) |
      util_bitpack_uint(values->CDEFYStrength6, 12, 17) |
      util_bitpack_uint(values->CDEFYStrength7, 18, 23);

   dw[7] =
      util_bitpack_uint(values->CDEFUVStrength0, 0, 5) |
      util_bitpack_uint(values->CDEFUVStrength1, 6, 11) |
      util_bitpack_uint(values->CDEFUVStrength2, 12, 17) |
      util_bitpack_uint(values->CDEFUVStrength3, 18, 23);

   dw[8] =
      util_bitpack_uint(values->CDEFUVStrength4, 0, 5) |
      util_bitpack_uint(values->CDEFUVStrength5, 6, 11) |
      util_bitpack_uint(values->CDEFUVStrength6, 12, 17) |
      util_bitpack_uint(values->CDEFUVStrength7, 18, 23);

   dw[9] =
      util_bitpack_uint(values->SuperResUpscaledFrameWidthMinus1, 0, 15) |
      util_bitpack_uint(values->SuperResDenom, 16, 20);

   dw[10] =
      util_bitpack_uint(values->FrameLoopRestorationFilterLumaY, 0, 1) |
      util_bitpack_uint(values->FrameLoopRestorationFilterChromaU, 2, 3) |
      util_bitpack_uint(values->FrameLoopRestorationFilterChromaV, 4, 5) |
      util_bitpack_uint(values->LoopRestorationUnitSizeLumaY, 8, 9) |
      util_bitpack_uint(values->UseSameLoopRestorationUnitSizeChromasUVFlag, 10, 10);

   dw[11] =
      util_bitpack_uint(values->LumaPlanex_step_qn, 0, 15);

   dw[12] =
      util_bitpack_uint(values->LumaPlanex0_qn, 0, 31);

   dw[13] =
      util_bitpack_uint(values->ChromaPlanex_step_qn, 0, 15);

   dw[14] =
      util_bitpack_uint(values->ChromaPlanex0_qn, 0, 31);
}

#define GFX20_AVP_INTER_PRED_STATE_length     15
#define GFX20_AVP_INTER_PRED_STATE_length_bias      2
#define GFX20_AVP_INTER_PRED_STATE_header       \
   .DWordLength                         =     13,  \
   .SubOpcode                           =     18,  \
   .MediaCommandOpcode                  =      3,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_AVP_INTER_PRED_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcode;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             SavedOrderHints0[7];
   uint32_t                             ActiveReferenceBitmask;
   uint32_t                             SavedOrderHints1[7];
   uint32_t                             SavedOrderHints2[7];
   uint32_t                             SavedOrderHints3[7];
   uint32_t                             SavedOrderHints4[7];
   uint32_t                             SavedOrderHints5[7];
   uint32_t                             SavedOrderHints6[7];
   uint32_t                             SavedOrderHints7[7];
};

static inline __attribute__((always_inline)) void
GFX20_AVP_INTER_PRED_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                                __attribute__((unused)) void * restrict dst,
                                __attribute__((unused)) const struct GFX20_AVP_INTER_PRED_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcode, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->SavedOrderHints0[0], 0, 7) |
      util_bitpack_uint(values->SavedOrderHints0[1], 8, 15) |
      util_bitpack_uint(values->SavedOrderHints0[2], 16, 23) |
      util_bitpack_uint(values->SavedOrderHints0[3], 24, 31);

   dw[2] =
      util_bitpack_uint(values->SavedOrderHints0[4], 0, 7) |
      util_bitpack_uint(values->SavedOrderHints0[5], 8, 15) |
      util_bitpack_uint(values->SavedOrderHints0[6], 16, 23) |
      util_bitpack_uint(values->ActiveReferenceBitmask, 24, 31);

   dw[3] =
      util_bitpack_uint(values->SavedOrderHints1[0], 0, 7) |
      util_bitpack_uint(values->SavedOrderHints1[1], 8, 15) |
      util_bitpack_uint(values->SavedOrderHints1[2], 16, 23) |
      util_bitpack_uint(values->SavedOrderHints1[3], 24, 31);

   dw[4] =
      util_bitpack_uint(values->SavedOrderHints1[4], 0, 7) |
      util_bitpack_uint(values->SavedOrderHints1[5], 8, 15) |
      util_bitpack_uint(values->SavedOrderHints1[6], 16, 23);

   dw[5] =
      util_bitpack_uint(values->SavedOrderHints2[0], 0, 7) |
      util_bitpack_uint(values->SavedOrderHints2[1], 8, 15) |
      util_bitpack_uint(values->SavedOrderHints2[2], 16, 23) |
      util_bitpack_uint(values->SavedOrderHints2[3], 24, 31);

   dw[6] =
      util_bitpack_uint(values->SavedOrderHints2[4], 0, 7) |
      util_bitpack_uint(values->SavedOrderHints2[5], 8, 15) |
      util_bitpack_uint(values->SavedOrderHints2[6], 16, 23);

   dw[7] =
      util_bitpack_uint(values->SavedOrderHints3[0], 0, 7) |
      util_bitpack_uint(values->SavedOrderHints3[1], 8, 15) |
      util_bitpack_uint(values->SavedOrderHints3[2], 16, 23) |
      util_bitpack_uint(values->SavedOrderHints3[3], 24, 31);

   dw[8] =
      util_bitpack_uint(values->SavedOrderHints3[4], 0, 7) |
      util_bitpack_uint(values->SavedOrderHints3[5], 8, 15) |
      util_bitpack_uint(values->SavedOrderHints3[6], 16, 23);

   dw[9] =
      util_bitpack_uint(values->SavedOrderHints4[0], 0, 7) |
      util_bitpack_uint(values->SavedOrderHints4[1], 8, 15) |
      util_bitpack_uint(values->SavedOrderHints4[2], 16, 23) |
      util_bitpack_uint(values->SavedOrderHints4[3], 24, 31);

   dw[10] =
      util_bitpack_uint(values->SavedOrderHints4[4], 0, 7) |
      util_bitpack_uint(values->SavedOrderHints4[5], 8, 15) |
      util_bitpack_uint(values->SavedOrderHints4[6], 16, 23);

   dw[11] =
      util_bitpack_uint(values->SavedOrderHints5[0], 0, 7) |
      util_bitpack_uint(values->SavedOrderHints5[1], 8, 15) |
      util_bitpack_uint(values->SavedOrderHints5[2], 16, 23) |
      util_bitpack_uint(values->SavedOrderHints5[3], 24, 31);

   dw[12] =
      util_bitpack_uint(values->SavedOrderHints5[4], 0, 7) |
      util_bitpack_uint(values->SavedOrderHints5[5], 8, 15) |
      util_bitpack_uint(values->SavedOrderHints5[6], 16, 23);

   dw[13] =
      util_bitpack_uint(values->SavedOrderHints6[0], 0, 7) |
      util_bitpack_uint(values->SavedOrderHints6[1], 8, 15) |
      util_bitpack_uint(values->SavedOrderHints6[2], 16, 23) |
      util_bitpack_uint(values->SavedOrderHints6[3], 24, 31);

   dw[14] =
      util_bitpack_uint(values->SavedOrderHints6[4], 0, 7) |
      util_bitpack_uint(values->SavedOrderHints6[5], 8, 15) |
      util_bitpack_uint(values->SavedOrderHints6[6], 16, 23);
}

#define GFX20_AVP_PIC_STATE_length            76
#define GFX20_AVP_PIC_STATE_length_bias        2
#define GFX20_AVP_PIC_STATE_header              \
   .DWordLength                         =     74,  \
   .SubOpcode                           =     48,  \
   .MediaCommandOpcode                  =      3,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_AVP_PIC_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcode;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             FrameWidth;
   uint32_t                             FrameHeight;
   uint32_t                             SequenceChromaSubSamplingFormat;
#define SS_Monochrome                            0
#define SS_420                                   1
#define SS_422                                   2
#define SS_444                                   3
   uint32_t                             SequencePixelBitDepthIdc;
#define SeqPix_8bit                              0
#define SeqPix_10bit                             1
#define SeqPix_12bit                             2
   uint32_t                             SequenceSuperblockSizeUsed;
#define _64x64                                   0
#define _128x128                                 1
   bool                                 SequenceEnableOrderHintFlag;
   uint32_t                             SequenceOrderHintBitsMinus1;
   bool                                 SequenceEnableFilterIntraFlag;
   bool                                 SequenceEnableIntraEdgeFilterFlag;
   bool                                 SequenceEnableDualFilterFlag;
   bool                                 SequenceEnableInterIntraCompoundFlag;
   bool                                 SequenceEnableMaskedCompoundFlag;
   bool                                 SequenceEnableJointCompoundFlag;
   bool                                 AllowScreenContentToolsFlag;
   bool                                 ForceIntegerMVFlag;
   bool                                 AllowWarpedMotionFlag;
   bool                                 UseCDEFFilterFlag;
   bool                                 UseSuperResFlag;
   bool                                 FrameLevelLoopRestorationFilterEnable;
   bool                                 ApplyFilmGrainFlag;
   bool                                 LargeScaleTileEnableFlag;
   bool                                 PostCDEFFilteredReconPixelsWriteoutEn;
   uint32_t                             FrameType;
   bool                                 IntraOnlyFlag;
   bool                                 ErrorResilientModeFlag;
   bool                                 AllowIntraBCFlag;
   uint32_t                             PrimaryReferenceFrameIdx;
   bool                                 SegmentationEnableFlag;
   bool                                 SegmentationUpdateMapFlag;
   bool                                 SegmentationTemporalUpdateFlag;
   bool                                 PreSkipSegmentIDFlag;
   uint32_t                             LastActiveSegmentSegmentID;
   bool                                 DeltaQPresentFlag;
   uint32_t                             DeltaQRes;
   bool                                 FrameCodedLosslessMode;
   bool                                 SegmentMapisZeroFlag;
   bool                                 SegmentIDBufferStreamInEnableFlag;
   bool                                 SegmentIDBufferStreamOutEnableFlag;
   uint32_t                             BaseQindex;
   int32_t                              YdcdeltaQ;
   int32_t                              UdcdeltaQ;
   int32_t                              UacdeltaQ;
   int32_t                              VdcdeltaQ;
   int32_t                              VacdeltaQ;
   bool                                 AllowHighPrecisionMV;
   bool                                 FrameLevelReferenceModeSelect;
   uint32_t                             McompFilterType;
#define EightTap                                 0
#define EightTapSmooth                           1
#define EightTapSharp                            2
#define Bilinear                                 3
#define Switchable                               4
   bool                                 MotionModeSwitchableFlag;
   bool                                 UseReferenceFrameMVSetFlag;
   uint32_t                             ReferenceFrameSignBias;
   uint32_t                             CurrentFrameOrderHint;
   bool                                 ReducedTxSetUsed;
   uint32_t                             FrameTransformMode;
   bool                                 SkipModePresentFlag;
   uint32_t                             SkipModeFrame0;
   uint32_t                             SkipModeFrame1;
   uint32_t                             ReferenceFrameSide;
   uint32_t                             GlobalMotionType1;
   uint32_t                             GlobalMotionType2;
   uint32_t                             GlobalMotionType3;
   uint32_t                             GlobalMotionType4;
   uint32_t                             GlobalMotionType5;
   uint32_t                             GlobalMotionType6;
   uint32_t                             GlobalMotionType7;
   uint32_t                             FrameLevelGlobalMotionInvalidFlags;
   uint32_t                             WarpParameters[42];
   uint32_t                             ReferenceFrameIdx0;
   uint32_t                             ReferenceFrameIdx1;
   uint32_t                             ReferenceFrameIdx2;
   uint32_t                             ReferenceFrameIdx3;
   uint32_t                             ReferenceFrameIdx4;
   uint32_t                             ReferenceFrameIdx5;
   uint32_t                             ReferenceFrameIdx6;
   uint32_t                             ReferenceFrameIdx7;
   uint32_t                             IntraFrameWidthinPixelMinus1;
   uint32_t                             IntraFrameHeightinPixelMinus1;
   uint32_t                             LastFrameWidthinPixelMinus1;
   uint32_t                             LastFrameHeightinPixelMinus1;
   uint32_t                             Last2FrameWidthinPixelMinus1;
   uint32_t                             Last2FrameHeightinPixelMinus1;
   uint32_t                             Last3FrameWidthinPixelMinus1;
   uint32_t                             Last3FrameHeightinPixelMinus1;
   uint32_t                             GoldenFrameWidthinPixelMinus1;
   uint32_t                             GoldenFrameHeightinPixelMinus1;
   uint32_t                             BWDREFFrameWidthinPixelMinus1;
   uint32_t                             BWDREFFrameHeightinPixelMinus1;
   uint32_t                             ALTREF2FrameWidthinPixelMinus1;
   uint32_t                             ALTREF2FrameHeightinPixelMinus1;
   uint32_t                             ALTREFFrameWidthinPixelMinus1;
   uint32_t                             ALTREFFrameHeightinPixelMinus1;
   uint32_t                             VerticalScaleFactorForIntra;
   uint32_t                             HorizontalScaleFactorForIntra;
   uint32_t                             VerticalScaleFactorForLast;
   uint32_t                             HorizontalScaleFactorForLast;
   uint32_t                             VerticalScaleFactorForLast2;
   uint32_t                             HorizontalScaleFactorForLast2;
   uint32_t                             VerticalScaleFactorForLast3;
   uint32_t                             HorizontalScaleFactorForLast3;
   uint32_t                             VerticalScaleFactorForGolden;
   uint32_t                             HorizontalScaleFactorForGolden;
   uint32_t                             VerticalScaleFactorForBWDREF;
   uint32_t                             HorizontalScaleFactorForBWDREF;
   uint32_t                             VerticalScaleFactorForALTREF2;
   uint32_t                             HorizontalScaleFactorForALTREF2;
   uint32_t                             VerticalScaleFactorForALTREF;
   uint32_t                             HorizontalScaleFactorForALTREF;
   uint32_t                             ReferenceFrameOrderHint[8];
   bool                                 NonFirstPassFlag;
   bool                                 VdencPakOnlyPass;
   bool                                 FrameSzOverStatusEnFrameBitRateMaxReportMask;
   bool                                 FrameSzUnderStatusEnFrameBitRateMinReportMask;
   uint32_t                             FrameBitRateMax;
   enum GFX20_FRAME_BITRATE_UNITS       FrameBitrateMaxUnit;
   uint32_t                             FrameBitRateMin;
   enum GFX20_FRAME_BITRATE_UNITS       FrameBitrateMinUnit;
   uint64_t                             FrameDeltaQindexMax;
   uint32_t                             FrameDeltaQindexMin;
   uint64_t                             FrameDeltaLFMax;
   uint32_t                             FrameDeltaLFMin;
   uint64_t                             FrameDeltaQindexLFMaxRange;
   uint32_t                             FrameDeltaQindexLFMinRange;
   uint32_t                             MinFrameSize;
   uint32_t                             MinFrameSizeUnits;
#define _4KByteUnits                             0
#define _16KByteUnits                            1
#define CompatibilityMode                        2
#define _6ByteUnits                              3
   bool                                 VDAQMenable;
   uint32_t                             Class0SSEThreshold0;
   uint32_t                             Class0SSEThreshold1;
   uint32_t                             SSEThresholdsForClass[8];
   uint32_t                             rdmult;
};

static inline __attribute__((always_inline)) void
GFX20_AVP_PIC_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                         __attribute__((unused)) void * restrict dst,
                         __attribute__((unused)) const struct GFX20_AVP_PIC_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcode, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->FrameWidth, 0, 13) |
      util_bitpack_uint(values->FrameHeight, 16, 29);

   dw[2] =
      util_bitpack_uint(values->SequenceChromaSubSamplingFormat, 0, 1) |
      util_bitpack_uint(values->SequencePixelBitDepthIdc, 3, 4) |
      util_bitpack_uint(values->SequenceSuperblockSizeUsed, 7, 8) |
      util_bitpack_uint(values->SequenceEnableOrderHintFlag, 9, 9) |
      util_bitpack_uint(values->SequenceOrderHintBitsMinus1, 10, 12) |
      util_bitpack_uint(values->SequenceEnableFilterIntraFlag, 16, 16) |
      util_bitpack_uint(values->SequenceEnableIntraEdgeFilterFlag, 17, 17) |
      util_bitpack_uint(values->SequenceEnableDualFilterFlag, 18, 18) |
      util_bitpack_uint(values->SequenceEnableInterIntraCompoundFlag, 19, 19) |
      util_bitpack_uint(values->SequenceEnableMaskedCompoundFlag, 20, 20) |
      util_bitpack_uint(values->SequenceEnableJointCompoundFlag, 21, 21);

   dw[3] =
      util_bitpack_uint(values->AllowScreenContentToolsFlag, 0, 0) |
      util_bitpack_uint(values->ForceIntegerMVFlag, 1, 1) |
      util_bitpack_uint(values->AllowWarpedMotionFlag, 2, 2) |
      util_bitpack_uint(values->UseCDEFFilterFlag, 4, 4) |
      util_bitpack_uint(values->UseSuperResFlag, 5, 5) |
      util_bitpack_uint(values->FrameLevelLoopRestorationFilterEnable, 6, 6) |
      util_bitpack_uint(values->ApplyFilmGrainFlag, 7, 7) |
      util_bitpack_uint(values->LargeScaleTileEnableFlag, 8, 8) |
      util_bitpack_uint(values->PostCDEFFilteredReconPixelsWriteoutEn, 14, 14) |
      util_bitpack_uint(values->FrameType, 16, 17) |
      util_bitpack_uint(values->IntraOnlyFlag, 19, 19) |
      util_bitpack_uint(values->ErrorResilientModeFlag, 22, 22) |
      util_bitpack_uint(values->AllowIntraBCFlag, 23, 23) |
      util_bitpack_uint(values->PrimaryReferenceFrameIdx, 28, 30);

   dw[4] =
      util_bitpack_uint(values->SegmentationEnableFlag, 0, 0) |
      util_bitpack_uint(values->SegmentationUpdateMapFlag, 1, 1) |
      util_bitpack_uint(values->SegmentationTemporalUpdateFlag, 2, 2) |
      util_bitpack_uint(values->PreSkipSegmentIDFlag, 3, 3) |
      util_bitpack_uint(values->LastActiveSegmentSegmentID, 4, 6) |
      util_bitpack_uint(values->DeltaQPresentFlag, 7, 7) |
      util_bitpack_uint(values->DeltaQRes, 8, 9) |
      util_bitpack_uint(values->FrameCodedLosslessMode, 10, 10) |
      util_bitpack_uint(values->SegmentMapisZeroFlag, 11, 11) |
      util_bitpack_uint(values->SegmentIDBufferStreamInEnableFlag, 12, 12) |
      util_bitpack_uint(values->SegmentIDBufferStreamOutEnableFlag, 13, 13) |
      util_bitpack_uint(values->BaseQindex, 16, 23) |
      util_bitpack_sint(values->YdcdeltaQ, 24, 30);

   dw[5] =
      util_bitpack_sint(values->UdcdeltaQ, 0, 6) |
      util_bitpack_sint(values->UacdeltaQ, 8, 14) |
      util_bitpack_sint(values->VdcdeltaQ, 16, 22) |
      util_bitpack_sint(values->VacdeltaQ, 24, 30);

   dw[6] =
      util_bitpack_uint(values->AllowHighPrecisionMV, 0, 0) |
      util_bitpack_uint(values->FrameLevelReferenceModeSelect, 1, 1) |
      util_bitpack_uint(values->McompFilterType, 2, 4) |
      util_bitpack_uint(values->MotionModeSwitchableFlag, 6, 6) |
      util_bitpack_uint(values->UseReferenceFrameMVSetFlag, 7, 7) |
      util_bitpack_uint(values->ReferenceFrameSignBias, 8, 15) |
      util_bitpack_uint(values->CurrentFrameOrderHint, 16, 23);

   dw[7] =
      util_bitpack_uint(values->ReducedTxSetUsed, 0, 0) |
      util_bitpack_uint(values->FrameTransformMode, 1, 2) |
      util_bitpack_uint(values->SkipModePresentFlag, 4, 4) |
      util_bitpack_uint(values->SkipModeFrame0, 5, 7) |
      util_bitpack_uint(values->SkipModeFrame1, 9, 11) |
      util_bitpack_uint(values->ReferenceFrameSide, 24, 31);

   dw[8] =
      util_bitpack_uint(values->GlobalMotionType1, 3, 4) |
      util_bitpack_uint(values->GlobalMotionType2, 6, 7) |
      util_bitpack_uint(values->GlobalMotionType3, 9, 10) |
      util_bitpack_uint(values->GlobalMotionType4, 12, 13) |
      util_bitpack_uint(values->GlobalMotionType5, 15, 16) |
      util_bitpack_uint(values->GlobalMotionType6, 18, 19) |
      util_bitpack_uint(values->GlobalMotionType7, 21, 22) |
      util_bitpack_uint(values->FrameLevelGlobalMotionInvalidFlags, 24, 31);

   dw[9] =
      util_bitpack_uint(values->WarpParameters[0], 0, 15) |
      util_bitpack_uint(values->WarpParameters[1], 16, 31);

   dw[10] =
      util_bitpack_uint(values->WarpParameters[2], 0, 15) |
      util_bitpack_uint(values->WarpParameters[3], 16, 31);

   dw[11] =
      util_bitpack_uint(values->WarpParameters[4], 0, 15) |
      util_bitpack_uint(values->WarpParameters[5], 16, 31);

   dw[12] =
      util_bitpack_uint(values->WarpParameters[6], 0, 15) |
      util_bitpack_uint(values->WarpParameters[7], 16, 31);

   dw[13] =
      util_bitpack_uint(values->WarpParameters[8], 0, 15) |
      util_bitpack_uint(values->WarpParameters[9], 16, 31);

   dw[14] =
      util_bitpack_uint(values->WarpParameters[10], 0, 15) |
      util_bitpack_uint(values->WarpParameters[11], 16, 31);

   dw[15] =
      util_bitpack_uint(values->WarpParameters[12], 0, 15) |
      util_bitpack_uint(values->WarpParameters[13], 16, 31);

   dw[16] =
      util_bitpack_uint(values->WarpParameters[14], 0, 15) |
      util_bitpack_uint(values->WarpParameters[15], 16, 31);

   dw[17] =
      util_bitpack_uint(values->WarpParameters[16], 0, 15) |
      util_bitpack_uint(values->WarpParameters[17], 16, 31);

   dw[18] =
      util_bitpack_uint(values->WarpParameters[18], 0, 15) |
      util_bitpack_uint(values->WarpParameters[19], 16, 31);

   dw[19] =
      util_bitpack_uint(values->WarpParameters[20], 0, 15) |
      util_bitpack_uint(values->WarpParameters[21], 16, 31);

   dw[20] =
      util_bitpack_uint(values->WarpParameters[22], 0, 15) |
      util_bitpack_uint(values->WarpParameters[23], 16, 31);

   dw[21] =
      util_bitpack_uint(values->WarpParameters[24], 0, 15) |
      util_bitpack_uint(values->WarpParameters[25], 16, 31);

   dw[22] =
      util_bitpack_uint(values->WarpParameters[26], 0, 15) |
      util_bitpack_uint(values->WarpParameters[27], 16, 31);

   dw[23] =
      util_bitpack_uint(values->WarpParameters[28], 0, 15) |
      util_bitpack_uint(values->WarpParameters[29], 16, 31);

   dw[24] =
      util_bitpack_uint(values->WarpParameters[30], 0, 15) |
      util_bitpack_uint(values->WarpParameters[31], 16, 31);

   dw[25] =
      util_bitpack_uint(values->WarpParameters[32], 0, 15) |
      util_bitpack_uint(values->WarpParameters[33], 16, 31);

   dw[26] =
      util_bitpack_uint(values->WarpParameters[34], 0, 15) |
      util_bitpack_uint(values->WarpParameters[35], 16, 31);

   dw[27] =
      util_bitpack_uint(values->WarpParameters[36], 0, 15) |
      util_bitpack_uint(values->WarpParameters[37], 16, 31);

   dw[28] =
      util_bitpack_uint(values->WarpParameters[38], 0, 15) |
      util_bitpack_uint(values->WarpParameters[39], 16, 31);

   dw[29] =
      util_bitpack_uint(values->WarpParameters[40], 0, 15) |
      util_bitpack_uint(values->WarpParameters[41], 16, 31);

   dw[30] =
      util_bitpack_uint(values->ReferenceFrameIdx0, 0, 2) |
      util_bitpack_uint(values->ReferenceFrameIdx1, 4, 6) |
      util_bitpack_uint(values->ReferenceFrameIdx2, 8, 10) |
      util_bitpack_uint(values->ReferenceFrameIdx3, 12, 14) |
      util_bitpack_uint(values->ReferenceFrameIdx4, 16, 18) |
      util_bitpack_uint(values->ReferenceFrameIdx5, 20, 22) |
      util_bitpack_uint(values->ReferenceFrameIdx6, 24, 26) |
      util_bitpack_uint(values->ReferenceFrameIdx7, 28, 30);

   dw[31] =
      util_bitpack_uint(values->IntraFrameWidthinPixelMinus1, 0, 15) |
      util_bitpack_uint(values->IntraFrameHeightinPixelMinus1, 16, 31);

   dw[32] =
      util_bitpack_uint(values->LastFrameWidthinPixelMinus1, 0, 15) |
      util_bitpack_uint(values->LastFrameHeightinPixelMinus1, 16, 31);

   dw[33] =
      util_bitpack_uint(values->Last2FrameWidthinPixelMinus1, 0, 15) |
      util_bitpack_uint(values->Last2FrameHeightinPixelMinus1, 16, 31);

   dw[34] =
      util_bitpack_uint(values->Last3FrameWidthinPixelMinus1, 0, 15) |
      util_bitpack_uint(values->Last3FrameHeightinPixelMinus1, 16, 31);

   dw[35] =
      util_bitpack_uint(values->GoldenFrameWidthinPixelMinus1, 0, 15) |
      util_bitpack_uint(values->GoldenFrameHeightinPixelMinus1, 16, 31);

   dw[36] =
      util_bitpack_uint(values->BWDREFFrameWidthinPixelMinus1, 0, 15) |
      util_bitpack_uint(values->BWDREFFrameHeightinPixelMinus1, 16, 31);

   dw[37] =
      util_bitpack_uint(values->ALTREF2FrameWidthinPixelMinus1, 0, 15) |
      util_bitpack_uint(values->ALTREF2FrameHeightinPixelMinus1, 16, 31);

   dw[38] =
      util_bitpack_uint(values->ALTREFFrameWidthinPixelMinus1, 0, 15) |
      util_bitpack_uint(values->ALTREFFrameHeightinPixelMinus1, 16, 31);

   dw[39] =
      util_bitpack_uint(values->VerticalScaleFactorForIntra, 0, 15) |
      util_bitpack_uint(values->HorizontalScaleFactorForIntra, 16, 31);

   dw[40] =
      util_bitpack_uint(values->VerticalScaleFactorForLast, 0, 15) |
      util_bitpack_uint(values->HorizontalScaleFactorForLast, 16, 31);

   dw[41] =
      util_bitpack_uint(values->VerticalScaleFactorForLast2, 0, 15) |
      util_bitpack_uint(values->HorizontalScaleFactorForLast2, 16, 31);

   dw[42] =
      util_bitpack_uint(values->VerticalScaleFactorForLast3, 0, 15) |
      util_bitpack_uint(values->HorizontalScaleFactorForLast3, 16, 31);

   dw[43] =
      util_bitpack_uint(values->VerticalScaleFactorForGolden, 0, 15) |
      util_bitpack_uint(values->HorizontalScaleFactorForGolden, 16, 31);

   dw[44] =
      util_bitpack_uint(values->VerticalScaleFactorForBWDREF, 0, 15) |
      util_bitpack_uint(values->HorizontalScaleFactorForBWDREF, 16, 31);

   dw[45] =
      util_bitpack_uint(values->VerticalScaleFactorForALTREF2, 0, 15) |
      util_bitpack_uint(values->HorizontalScaleFactorForALTREF2, 16, 31);

   dw[46] =
      util_bitpack_uint(values->VerticalScaleFactorForALTREF, 0, 15) |
      util_bitpack_uint(values->HorizontalScaleFactorForALTREF, 16, 31);

   dw[47] =
      util_bitpack_uint(values->ReferenceFrameOrderHint[0], 0, 7) |
      util_bitpack_uint(values->ReferenceFrameOrderHint[1], 8, 15) |
      util_bitpack_uint(values->ReferenceFrameOrderHint[2], 16, 23) |
      util_bitpack_uint(values->ReferenceFrameOrderHint[3], 24, 31);

   dw[48] =
      util_bitpack_uint(values->ReferenceFrameOrderHint[4], 0, 7) |
      util_bitpack_uint(values->ReferenceFrameOrderHint[5], 8, 15) |
      util_bitpack_uint(values->ReferenceFrameOrderHint[6], 16, 23) |
      util_bitpack_uint(values->ReferenceFrameOrderHint[7], 24, 31);

   dw[49] = 0;

   dw[50] = 0;

   dw[51] =
      util_bitpack_uint(values->NonFirstPassFlag, 16, 16) |
      util_bitpack_uint(values->VdencPakOnlyPass, 17, 17) |
      util_bitpack_uint(values->FrameSzOverStatusEnFrameBitRateMaxReportMask, 25, 25) |
      util_bitpack_uint(values->FrameSzUnderStatusEnFrameBitRateMinReportMask, 26, 26);

   dw[52] =
      util_bitpack_uint(values->FrameBitRateMax, 0, 13) |
      util_bitpack_uint(values->FrameBitrateMaxUnit, 31, 31);

   dw[53] =
      util_bitpack_uint(values->FrameBitRateMin, 0, 13) |
      util_bitpack_uint(values->FrameBitrateMinUnit, 31, 31);

   const uint64_t v54 =
      util_bitpack_uint(values->FrameDeltaQindexMax, 0, 63);
   dw[54] = v54;
   dw[55] = v54 >> 32;

   dw[56] =
      util_bitpack_uint(values->FrameDeltaQindexMin, 0, 31);

   const uint64_t v57 =
      util_bitpack_uint(values->FrameDeltaLFMax, 0, 63);
   dw[57] = v57;
   dw[58] = v57 >> 32;

   dw[59] =
      util_bitpack_uint(values->FrameDeltaLFMin, 0, 31);

   const uint64_t v60 =
      util_bitpack_uint(values->FrameDeltaQindexLFMaxRange, 0, 63);
   dw[60] = v60;
   dw[61] = v60 >> 32;

   dw[62] =
      util_bitpack_uint(values->FrameDeltaQindexLFMinRange, 0, 31);

   dw[63] =
      util_bitpack_uint(values->MinFrameSize, 0, 15) |
      util_bitpack_uint(values->MinFrameSizeUnits, 30, 31);

   dw[64] =
      util_bitpack_uint(values->VDAQMenable, 0, 0);

   dw[65] =
      util_bitpack_uint(values->Class0SSEThreshold0, 0, 15) |
      util_bitpack_uint(values->Class0SSEThreshold1, 16, 31);

   dw[66] =
      util_bitpack_uint(values->SSEThresholdsForClass[0], 0, 7) |
      util_bitpack_uint(values->SSEThresholdsForClass[1], 8, 15) |
      util_bitpack_uint(values->SSEThresholdsForClass[2], 16, 23) |
      util_bitpack_uint(values->SSEThresholdsForClass[3], 24, 31);

   dw[67] =
      util_bitpack_uint(values->SSEThresholdsForClass[4], 0, 7) |
      util_bitpack_uint(values->SSEThresholdsForClass[5], 8, 15) |
      util_bitpack_uint(values->SSEThresholdsForClass[6], 16, 23) |
      util_bitpack_uint(values->SSEThresholdsForClass[7], 24, 31);

   dw[68] = 0;

   dw[69] = 0;

   dw[70] = 0;

   dw[71] = 0;

   dw[72] = 0;

   dw[73] = 0;

   dw[74] =
      util_bitpack_uint(values->rdmult, 0, 31);

   dw[75] = 0;
}

#define GFX20_AVP_PIPE_BUF_ADDR_STATE_length    215
#define GFX20_AVP_PIPE_BUF_ADDR_STATE_length_bias      2
#define GFX20_AVP_PIPE_BUF_ADDR_STATE_header    \
   .DWordLength                         =    213,  \
   .SubOpcode                           =      2,  \
   .MediaCommandOpcode                  =      3,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_AVP_PIPE_BUF_ADDR_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcode;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   __gen_address_type                   ReferencePictureAddress[8];
   struct GFX20_MEMORYADDRESSATTRIBUTES ReferencePictureAttributes;
   __gen_address_type                   DecodedOutputFrameBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES DecodedOutputFrameBufferAddressAttributes;
   __gen_address_type                   FilmGrainInjectedOutputFrameBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES FilmGrainInjectedOutputFrameBufferAddressAttributes;
   __gen_address_type                   IntraBCDecodedOutputFrameBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES IntraBCDecodedOutputFrameBufferAddressAttributes;
   __gen_address_type                   CDFTablesInitializationBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES CDFTablesInitializationBufferAddressAttributes;
   __gen_address_type                   CDFTablesBackwardAdaptationBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES CDFTablesBackwardAdaptationBufferAddressAttributes;
   __gen_address_type                   AV1SegmentIDReadBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES AV1SegmentIDReadBufferAddressAttributes;
   __gen_address_type                   AV1SegmentIDWriteBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES AV1SegmentIDWriteBufferAddressAttributes;
   __gen_address_type                   CollocatedMVTemporalBufferAddress[8];
   struct GFX20_MEMORYADDRESSATTRIBUTES CollocatedMVTemporalBufferAttributes;
   __gen_address_type                   CurrentFrameMVWriteBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES CurrentFrameMVWriteBufferAddressAttributes;
   __gen_address_type                   FilmGrainSampleTemplateAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES FilmGrainSampleTemplateAddressAttributes;
   __gen_address_type                   BitstreamLineRowstoreBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES BitstreamLineRowstoreBufferAddressAttributes;
   __gen_address_type                   BitstreamTileLineRowstoreBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES BitstreamTileLineRowstoreBufferAddressAttributes;
   __gen_address_type                   IntraPredictionLineRowstoreBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES IntraPredictionLineRowstoreBufferAddressAttributes;
   __gen_address_type                   IntraPredictionTileLineRowstoreBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES IntraPredictionTileLineRowstoreBufferAddressAttributes;
   __gen_address_type                   SpatialMotionVectorLineBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES SpatialMotionVectorLineBufferAddressAttributes;
   __gen_address_type                   SpatialMotionVectorTileLineBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES SpatialMotionVectorTileLineBufferAddressAttributes;
   __gen_address_type                   LoopRestorationMetaTileColumnBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES LoopRestorationMetaTileColumnBufferAddressAttributes;
   __gen_address_type                   LoopRestorationFilterTileLineYBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES LoopRestorationFilterTileLineYBufferAddressAttributes;
   __gen_address_type                   LoopRestorationFilterTileLineUBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES LoopRestorationFilterTileLineUBufferAddressAttributes;
   __gen_address_type                   LoopRestorationFilterTileLineVBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES LoopRestorationFilterTileLineVBufferAddressAttributes;
   __gen_address_type                   DeblockerFilterLineYBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES DeblockerFilterLineYBufferAddressAttributes;
   __gen_address_type                   DeblockerFilterLineUBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES DeblockerFilterLineUBufferAddressAttributes;
   __gen_address_type                   DeblockerFilterLineVBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES DeblockerFilterLineVBufferAddressAttributes;
   __gen_address_type                   DeblockerFilterTileLineYBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES DeblockerFilterTileLineYBufferAddressAttributes;
   __gen_address_type                   DeblockerFilterTileLineUBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES DeblockerFilterTileLineUBufferAddressAttributes;
   __gen_address_type                   DeblockerFilterTileLineVBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES DeblockerFilterTileLineVBufferAddressAttributes;
   __gen_address_type                   DeblockerFilterTileColumnYBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES DeblockerFilterTileColumnYBufferAddressAttributes;
   __gen_address_type                   DeblockerFilterTileColumnUBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES DeblockerFilterTileColumnUBufferAddressAttributes;
   __gen_address_type                   DeblockerFilterTileColumnVBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES DeblockerFilterTileColumnVBufferAddressAttributes;
   __gen_address_type                   CDEFFilterLineBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES CDEFFilterLineBufferAddressAttributes;
   __gen_address_type                   CDEFFilterTileLineBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES CDEFFilterTileLineBufferAddressAttributes;
   __gen_address_type                   CDEFFilterTileColumnBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES CDEFFilterTileColumnBufferAddressAttributes;
   __gen_address_type                   CDEFFilterMetaTileLineBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES CDEFFilterMetaTileLineBufferAddressAttributes;
   __gen_address_type                   CDEFFilterMetaTileColumnBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES CDEFFilterMetaTileColumnBufferAddressAttributes;
   __gen_address_type                   CDEFFilterTopLeftCornerBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES CDEFFilterTopLeftCornerBufferAddressAttributes;
   __gen_address_type                   SuperResTileColumnYBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES SuperResTileColumnYBufferAddressAttributes;
   __gen_address_type                   SuperResTileColumnUBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES SuperResTileColumnUBufferAddressAttributes;
   __gen_address_type                   SuperResTileColumnVBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES SuperResTileColumnVBufferAddressAttributes;
   __gen_address_type                   LoopRestorationFilterTileColumnYBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES LoopRestorationFilterTileColumnYBufferAddressAttributes;
   __gen_address_type                   LoopRestorationFilterTileColumnUBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES LoopRestorationFilterTileColumnUBufferAddressAttributes;
   __gen_address_type                   LoopRestorationFilterTileColumnVBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES LoopRestorationFilterTileColumnVBufferAddressAttributes;
   __gen_address_type                   LoopRestorationFilterTileColumnAlignmentReadWriteBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES LoopRestorationFilterTileColumnAlignmentReadWriteBufferAddressAttributes;
   __gen_address_type                   FilmGrainTileColumnDataReadWriteBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES FilmGrainTileColumnDataReadWriteBufferAddressAttributes;
   __gen_address_type                   DecodedFrameStatusErrorBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES DecodedFrameStatusErrorBufferAddressAttributes;
   __gen_address_type                   DecodedBlockDataStreamoutBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES DecodedBlockDataStreamoutBufferAddressAttributes;
   __gen_address_type                   OriginalUncompressedPictureSourceBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES OriginalUncompressedPictureSourceBufferAddressAttributes;
   __gen_address_type                   DownscaledUncompressedPictureSourceBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES DownscaledUncompressedPictureSourceBufferAddressAttributes;
   __gen_address_type                   TileSizeStreamoutBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES TileSizeStreamoutBufferAddressAttributes;
   __gen_address_type                   TileStatisticsStreamoutBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES TileStatisticsStreamoutBufferAddressAttributes;
   __gen_address_type                   CUStreamoutBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES CUStreamoutBufferAddressAttributes;
   __gen_address_type                   SSELineReadWriteBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES SSELineReadWriteBufferAddressAttributes;
   __gen_address_type                   SSETileLineReadWriteBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES SSETileLineReadWriteBufferAddressAttributes;
   __gen_address_type                   PostCDEFPixelsBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES PostCDEFPixelsBufferAddressAttributes;
};

static inline __attribute__((always_inline)) void
GFX20_AVP_PIPE_BUF_ADDR_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                                   __attribute__((unused)) void * restrict dst,
                                   __attribute__((unused)) const struct GFX20_AVP_PIPE_BUF_ADDR_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcode, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   const uint64_t v1_address =
      __gen_address(data, &dw[1], values->ReferencePictureAddress[0], 0, 0, 63);
   dw[1] = v1_address;
   dw[2] = v1_address >> 32;

   const uint64_t v3_address =
      __gen_address(data, &dw[3], values->ReferencePictureAddress[1], 0, 0, 63);
   dw[3] = v3_address;
   dw[4] = v3_address >> 32;

   const uint64_t v5_address =
      __gen_address(data, &dw[5], values->ReferencePictureAddress[2], 0, 0, 63);
   dw[5] = v5_address;
   dw[6] = v5_address >> 32;

   const uint64_t v7_address =
      __gen_address(data, &dw[7], values->ReferencePictureAddress[3], 0, 0, 63);
   dw[7] = v7_address;
   dw[8] = v7_address >> 32;

   const uint64_t v9_address =
      __gen_address(data, &dw[9], values->ReferencePictureAddress[4], 0, 0, 63);
   dw[9] = v9_address;
   dw[10] = v9_address >> 32;

   const uint64_t v11_address =
      __gen_address(data, &dw[11], values->ReferencePictureAddress[5], 0, 0, 63);
   dw[11] = v11_address;
   dw[12] = v11_address >> 32;

   const uint64_t v13_address =
      __gen_address(data, &dw[13], values->ReferencePictureAddress[6], 0, 0, 63);
   dw[13] = v13_address;
   dw[14] = v13_address >> 32;

   const uint64_t v15_address =
      __gen_address(data, &dw[15], values->ReferencePictureAddress[7], 0, 0, 63);
   dw[15] = v15_address;
   dw[16] = v15_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[17], &values->ReferencePictureAttributes);

   const uint64_t v18_address =
      __gen_address(data, &dw[18], values->DecodedOutputFrameBufferAddress, 0, 0, 63);
   dw[18] = v18_address;
   dw[19] = v18_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[20], &values->DecodedOutputFrameBufferAddressAttributes);

   const uint64_t v21_address =
      __gen_address(data, &dw[21], values->FilmGrainInjectedOutputFrameBufferAddress, 0, 0, 63);
   dw[21] = v21_address;
   dw[22] = v21_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[23], &values->FilmGrainInjectedOutputFrameBufferAddressAttributes);

   const uint64_t v24_address =
      __gen_address(data, &dw[24], values->IntraBCDecodedOutputFrameBufferAddress, 0, 0, 63);
   dw[24] = v24_address;
   dw[25] = v24_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[26], &values->IntraBCDecodedOutputFrameBufferAddressAttributes);

   const uint64_t v27_address =
      __gen_address(data, &dw[27], values->CDFTablesInitializationBufferAddress, 0, 0, 63);
   dw[27] = v27_address;
   dw[28] = v27_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[29], &values->CDFTablesInitializationBufferAddressAttributes);

   const uint64_t v30_address =
      __gen_address(data, &dw[30], values->CDFTablesBackwardAdaptationBufferAddress, 0, 0, 63);
   dw[30] = v30_address;
   dw[31] = v30_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[32], &values->CDFTablesBackwardAdaptationBufferAddressAttributes);

   const uint64_t v33_address =
      __gen_address(data, &dw[33], values->AV1SegmentIDReadBufferAddress, 0, 0, 63);
   dw[33] = v33_address;
   dw[34] = v33_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[35], &values->AV1SegmentIDReadBufferAddressAttributes);

   const uint64_t v36_address =
      __gen_address(data, &dw[36], values->AV1SegmentIDWriteBufferAddress, 0, 0, 63);
   dw[36] = v36_address;
   dw[37] = v36_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[38], &values->AV1SegmentIDWriteBufferAddressAttributes);

   const uint64_t v39_address =
      __gen_address(data, &dw[39], values->CollocatedMVTemporalBufferAddress[0], 0, 0, 63);
   dw[39] = v39_address;
   dw[40] = v39_address >> 32;

   const uint64_t v41_address =
      __gen_address(data, &dw[41], values->CollocatedMVTemporalBufferAddress[1], 0, 0, 63);
   dw[41] = v41_address;
   dw[42] = v41_address >> 32;

   const uint64_t v43_address =
      __gen_address(data, &dw[43], values->CollocatedMVTemporalBufferAddress[2], 0, 0, 63);
   dw[43] = v43_address;
   dw[44] = v43_address >> 32;

   const uint64_t v45_address =
      __gen_address(data, &dw[45], values->CollocatedMVTemporalBufferAddress[3], 0, 0, 63);
   dw[45] = v45_address;
   dw[46] = v45_address >> 32;

   const uint64_t v47_address =
      __gen_address(data, &dw[47], values->CollocatedMVTemporalBufferAddress[4], 0, 0, 63);
   dw[47] = v47_address;
   dw[48] = v47_address >> 32;

   const uint64_t v49_address =
      __gen_address(data, &dw[49], values->CollocatedMVTemporalBufferAddress[5], 0, 0, 63);
   dw[49] = v49_address;
   dw[50] = v49_address >> 32;

   const uint64_t v51_address =
      __gen_address(data, &dw[51], values->CollocatedMVTemporalBufferAddress[6], 0, 0, 63);
   dw[51] = v51_address;
   dw[52] = v51_address >> 32;

   const uint64_t v53_address =
      __gen_address(data, &dw[53], values->CollocatedMVTemporalBufferAddress[7], 0, 0, 63);
   dw[53] = v53_address;
   dw[54] = v53_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[55], &values->CollocatedMVTemporalBufferAttributes);

   const uint64_t v56_address =
      __gen_address(data, &dw[56], values->CurrentFrameMVWriteBufferAddress, 0, 0, 63);
   dw[56] = v56_address;
   dw[57] = v56_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[58], &values->CurrentFrameMVWriteBufferAddressAttributes);

   const uint64_t v59_address =
      __gen_address(data, &dw[59], values->FilmGrainSampleTemplateAddress, 0, 0, 63);
   dw[59] = v59_address;
   dw[60] = v59_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[61], &values->FilmGrainSampleTemplateAddressAttributes);

   const uint64_t v62_address =
      __gen_address(data, &dw[62], values->BitstreamLineRowstoreBufferAddress, 0, 0, 63);
   dw[62] = v62_address;
   dw[63] = v62_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[64], &values->BitstreamLineRowstoreBufferAddressAttributes);

   const uint64_t v65_address =
      __gen_address(data, &dw[65], values->BitstreamTileLineRowstoreBufferAddress, 0, 0, 63);
   dw[65] = v65_address;
   dw[66] = v65_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[67], &values->BitstreamTileLineRowstoreBufferAddressAttributes);

   const uint64_t v68_address =
      __gen_address(data, &dw[68], values->IntraPredictionLineRowstoreBufferAddress, 0, 0, 63);
   dw[68] = v68_address;
   dw[69] = v68_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[70], &values->IntraPredictionLineRowstoreBufferAddressAttributes);

   const uint64_t v71_address =
      __gen_address(data, &dw[71], values->IntraPredictionTileLineRowstoreBufferAddress, 0, 0, 63);
   dw[71] = v71_address;
   dw[72] = v71_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[73], &values->IntraPredictionTileLineRowstoreBufferAddressAttributes);

   const uint64_t v74_address =
      __gen_address(data, &dw[74], values->SpatialMotionVectorLineBufferAddress, 0, 0, 63);
   dw[74] = v74_address;
   dw[75] = v74_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[76], &values->SpatialMotionVectorLineBufferAddressAttributes);

   const uint64_t v77_address =
      __gen_address(data, &dw[77], values->SpatialMotionVectorTileLineBufferAddress, 0, 0, 63);
   dw[77] = v77_address;
   dw[78] = v77_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[79], &values->SpatialMotionVectorTileLineBufferAddressAttributes);

   const uint64_t v80_address =
      __gen_address(data, &dw[80], values->LoopRestorationMetaTileColumnBufferAddress, 0, 0, 63);
   dw[80] = v80_address;
   dw[81] = v80_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[82], &values->LoopRestorationMetaTileColumnBufferAddressAttributes);

   const uint64_t v83_address =
      __gen_address(data, &dw[83], values->LoopRestorationFilterTileLineYBufferAddress, 0, 0, 63);
   dw[83] = v83_address;
   dw[84] = v83_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[85], &values->LoopRestorationFilterTileLineYBufferAddressAttributes);

   const uint64_t v86_address =
      __gen_address(data, &dw[86], values->LoopRestorationFilterTileLineUBufferAddress, 0, 0, 63);
   dw[86] = v86_address;
   dw[87] = v86_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[88], &values->LoopRestorationFilterTileLineUBufferAddressAttributes);

   const uint64_t v89_address =
      __gen_address(data, &dw[89], values->LoopRestorationFilterTileLineVBufferAddress, 0, 0, 63);
   dw[89] = v89_address;
   dw[90] = v89_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[91], &values->LoopRestorationFilterTileLineVBufferAddressAttributes);

   const uint64_t v92_address =
      __gen_address(data, &dw[92], values->DeblockerFilterLineYBufferAddress, 0, 0, 63);
   dw[92] = v92_address;
   dw[93] = v92_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[94], &values->DeblockerFilterLineYBufferAddressAttributes);

   const uint64_t v95_address =
      __gen_address(data, &dw[95], values->DeblockerFilterLineUBufferAddress, 0, 0, 63);
   dw[95] = v95_address;
   dw[96] = v95_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[97], &values->DeblockerFilterLineUBufferAddressAttributes);

   const uint64_t v98_address =
      __gen_address(data, &dw[98], values->DeblockerFilterLineVBufferAddress, 0, 0, 63);
   dw[98] = v98_address;
   dw[99] = v98_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[100], &values->DeblockerFilterLineVBufferAddressAttributes);

   const uint64_t v101_address =
      __gen_address(data, &dw[101], values->DeblockerFilterTileLineYBufferAddress, 0, 0, 63);
   dw[101] = v101_address;
   dw[102] = v101_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[103], &values->DeblockerFilterTileLineYBufferAddressAttributes);

   const uint64_t v104_address =
      __gen_address(data, &dw[104], values->DeblockerFilterTileLineUBufferAddress, 0, 0, 63);
   dw[104] = v104_address;
   dw[105] = v104_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[106], &values->DeblockerFilterTileLineUBufferAddressAttributes);

   const uint64_t v107_address =
      __gen_address(data, &dw[107], values->DeblockerFilterTileLineVBufferAddress, 0, 0, 63);
   dw[107] = v107_address;
   dw[108] = v107_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[109], &values->DeblockerFilterTileLineVBufferAddressAttributes);

   const uint64_t v110_address =
      __gen_address(data, &dw[110], values->DeblockerFilterTileColumnYBufferAddress, 0, 0, 63);
   dw[110] = v110_address;
   dw[111] = v110_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[112], &values->DeblockerFilterTileColumnYBufferAddressAttributes);

   const uint64_t v113_address =
      __gen_address(data, &dw[113], values->DeblockerFilterTileColumnUBufferAddress, 0, 0, 63);
   dw[113] = v113_address;
   dw[114] = v113_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[115], &values->DeblockerFilterTileColumnUBufferAddressAttributes);

   const uint64_t v116_address =
      __gen_address(data, &dw[116], values->DeblockerFilterTileColumnVBufferAddress, 0, 0, 63);
   dw[116] = v116_address;
   dw[117] = v116_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[118], &values->DeblockerFilterTileColumnVBufferAddressAttributes);

   const uint64_t v119_address =
      __gen_address(data, &dw[119], values->CDEFFilterLineBufferAddress, 0, 0, 63);
   dw[119] = v119_address;
   dw[120] = v119_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[121], &values->CDEFFilterLineBufferAddressAttributes);

   dw[122] = 0;

   dw[123] = 0;

   dw[124] = 0;

   dw[125] = 0;

   dw[126] = 0;

   dw[127] = 0;

   const uint64_t v128_address =
      __gen_address(data, &dw[128], values->CDEFFilterTileLineBufferAddress, 0, 0, 63);
   dw[128] = v128_address;
   dw[129] = v128_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[130], &values->CDEFFilterTileLineBufferAddressAttributes);

   dw[131] = 0;

   dw[132] = 0;

   dw[133] = 0;

   dw[134] = 0;

   dw[135] = 0;

   dw[136] = 0;

   const uint64_t v137_address =
      __gen_address(data, &dw[137], values->CDEFFilterTileColumnBufferAddress, 0, 0, 63);
   dw[137] = v137_address;
   dw[138] = v137_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[139], &values->CDEFFilterTileColumnBufferAddressAttributes);

   const uint64_t v140_address =
      __gen_address(data, &dw[140], values->CDEFFilterMetaTileLineBufferAddress, 0, 0, 63);
   dw[140] = v140_address;
   dw[141] = v140_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[142], &values->CDEFFilterMetaTileLineBufferAddressAttributes);

   const uint64_t v143_address =
      __gen_address(data, &dw[143], values->CDEFFilterMetaTileColumnBufferAddress, 0, 0, 63);
   dw[143] = v143_address;
   dw[144] = v143_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[145], &values->CDEFFilterMetaTileColumnBufferAddressAttributes);

   const uint64_t v146_address =
      __gen_address(data, &dw[146], values->CDEFFilterTopLeftCornerBufferAddress, 0, 0, 63);
   dw[146] = v146_address;
   dw[147] = v146_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[148], &values->CDEFFilterTopLeftCornerBufferAddressAttributes);

   const uint64_t v149_address =
      __gen_address(data, &dw[149], values->SuperResTileColumnYBufferAddress, 0, 0, 63);
   dw[149] = v149_address;
   dw[150] = v149_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[151], &values->SuperResTileColumnYBufferAddressAttributes);

   const uint64_t v152_address =
      __gen_address(data, &dw[152], values->SuperResTileColumnUBufferAddress, 0, 0, 63);
   dw[152] = v152_address;
   dw[153] = v152_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[154], &values->SuperResTileColumnUBufferAddressAttributes);

   const uint64_t v155_address =
      __gen_address(data, &dw[155], values->SuperResTileColumnVBufferAddress, 0, 0, 63);
   dw[155] = v155_address;
   dw[156] = v155_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[157], &values->SuperResTileColumnVBufferAddressAttributes);

   const uint64_t v158_address =
      __gen_address(data, &dw[158], values->LoopRestorationFilterTileColumnYBufferAddress, 0, 0, 63);
   dw[158] = v158_address;
   dw[159] = v158_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[160], &values->LoopRestorationFilterTileColumnYBufferAddressAttributes);

   const uint64_t v161_address =
      __gen_address(data, &dw[161], values->LoopRestorationFilterTileColumnUBufferAddress, 0, 0, 63);
   dw[161] = v161_address;
   dw[162] = v161_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[163], &values->LoopRestorationFilterTileColumnUBufferAddressAttributes);

   const uint64_t v164_address =
      __gen_address(data, &dw[164], values->LoopRestorationFilterTileColumnVBufferAddress, 0, 0, 63);
   dw[164] = v164_address;
   dw[165] = v164_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[166], &values->LoopRestorationFilterTileColumnVBufferAddressAttributes);

   dw[167] = 0;

   dw[168] = 0;

   dw[169] = 0;

   const uint64_t v170_address =
      __gen_address(data, &dw[170], values->LoopRestorationFilterTileColumnAlignmentReadWriteBufferAddress, 0, 0, 63);
   dw[170] = v170_address;
   dw[171] = v170_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[172], &values->LoopRestorationFilterTileColumnAlignmentReadWriteBufferAddressAttributes);

   const uint64_t v173_address =
      __gen_address(data, &dw[173], values->FilmGrainTileColumnDataReadWriteBufferAddress, 0, 0, 63);
   dw[173] = v173_address;
   dw[174] = v173_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[175], &values->FilmGrainTileColumnDataReadWriteBufferAddressAttributes);

   const uint64_t v176_address =
      __gen_address(data, &dw[176], values->DecodedFrameStatusErrorBufferAddress, 0, 0, 63);
   dw[176] = v176_address;
   dw[177] = v176_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[178], &values->DecodedFrameStatusErrorBufferAddressAttributes);

   const uint64_t v179_address =
      __gen_address(data, &dw[179], values->DecodedBlockDataStreamoutBufferAddress, 0, 0, 63);
   dw[179] = v179_address;
   dw[180] = v179_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[181], &values->DecodedBlockDataStreamoutBufferAddressAttributes);

   dw[182] = 0;

   dw[183] = 0;

   dw[184] = 0;

   dw[185] = 0;

   dw[186] = 0;

   dw[187] = 0;

   const uint64_t v188_address =
      __gen_address(data, &dw[188], values->OriginalUncompressedPictureSourceBufferAddress, 0, 0, 63);
   dw[188] = v188_address;
   dw[189] = v188_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[190], &values->OriginalUncompressedPictureSourceBufferAddressAttributes);

   const uint64_t v191_address =
      __gen_address(data, &dw[191], values->DownscaledUncompressedPictureSourceBufferAddress, 0, 0, 63);
   dw[191] = v191_address;
   dw[192] = v191_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[193], &values->DownscaledUncompressedPictureSourceBufferAddressAttributes);

   const uint64_t v194_address =
      __gen_address(data, &dw[194], values->TileSizeStreamoutBufferAddress, 0, 0, 63);
   dw[194] = v194_address;
   dw[195] = v194_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[196], &values->TileSizeStreamoutBufferAddressAttributes);

   const uint64_t v197_address =
      __gen_address(data, &dw[197], values->TileStatisticsStreamoutBufferAddress, 0, 0, 63);
   dw[197] = v197_address;
   dw[198] = v197_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[199], &values->TileStatisticsStreamoutBufferAddressAttributes);

   const uint64_t v200_address =
      __gen_address(data, &dw[200], values->CUStreamoutBufferAddress, 0, 0, 63);
   dw[200] = v200_address;
   dw[201] = v200_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[202], &values->CUStreamoutBufferAddressAttributes);

   const uint64_t v203_address =
      __gen_address(data, &dw[203], values->SSELineReadWriteBufferAddress, 0, 0, 63);
   dw[203] = v203_address;
   dw[204] = v203_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[205], &values->SSELineReadWriteBufferAddressAttributes);

   const uint64_t v206_address =
      __gen_address(data, &dw[206], values->SSETileLineReadWriteBufferAddress, 0, 0, 63);
   dw[206] = v206_address;
   dw[207] = v206_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[208], &values->SSETileLineReadWriteBufferAddressAttributes);

   const uint64_t v209_address =
      __gen_address(data, &dw[209], values->PostCDEFPixelsBufferAddress, 0, 0, 63);
   dw[209] = v209_address;
   dw[210] = v209_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[211], &values->PostCDEFPixelsBufferAddressAttributes);

   dw[212] = 0;

   dw[213] = 0;

   dw[214] = 0;
}

#define GFX20_AVP_PIPE_MODE_SELECT_length      7
#define GFX20_AVP_PIPE_MODE_SELECT_length_bias      2
#define GFX20_AVP_PIPE_MODE_SELECT_header       \
   .DWordLength                         =      5,  \
   .SubOpcode                           =      0,  \
   .MediaCommandOpcode                  =      3,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3,  \
   .CodecStandardSelect                 =      2

struct GFX20_AVP_PIPE_MODE_SELECT {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcode;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   bool                                 CodecSelect;
#define Decode                                   0
#define Encode                                   1
   bool                                 PicStatusErrorReportEnable;
   bool                                 FrameReconstructionDisable;
   uint32_t                             CodecStandardSelect;
   bool                                 VDENCMode;
   bool                                 TileStatisticsStreamoutEnable;
   uint32_t                             MultiEngineMode;
#define SingleEngineMode                         0
#define LeftEngineMode                           1
#define RightEngineMode                          2
#define MiddleEngineMode                         3
   uint32_t                             PipeWorkingMode;
#define LegacySinglePipe                         0
#define EncodeMode                               2
#define DecodeScalableMode                       3
   bool                                 TileBasedEngine;
   bool                                 MotionCompMemoryTrackerCounterEnable;
   uint32_t                             PicStatusErrorReportID;
   bool                                 AlcChickenbitRestrictSingleTileGroupInAFrame;
   uint32_t                             PhaseIndicator;
#define FirstPhase                               0
#define MiddlePhase                              1
#define LastPhase                                2
   uint32_t                             DownscaledSourcePixelPrefetchLength;
   bool                                 DownscaledSourcePixelPrefetchEnable;
   uint32_t                             OriginalSourcePixelPrefetchLength;
   bool                                 OriginalSourcePixelPrefetchEnable;
};

static inline __attribute__((always_inline)) void
GFX20_AVP_PIPE_MODE_SELECT_pack(__attribute__((unused)) __gen_user_data *data,
                                __attribute__((unused)) void * restrict dst,
                                __attribute__((unused)) const struct GFX20_AVP_PIPE_MODE_SELECT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcode, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->CodecSelect, 0, 0) |
      util_bitpack_uint(values->PicStatusErrorReportEnable, 3, 3) |
      util_bitpack_uint(values->FrameReconstructionDisable, 4, 4) |
      util_bitpack_uint(values->CodecStandardSelect, 5, 7) |
      util_bitpack_uint(values->VDENCMode, 10, 10) |
      util_bitpack_uint(values->TileStatisticsStreamoutEnable, 12, 12) |
      util_bitpack_uint(values->MultiEngineMode, 13, 14) |
      util_bitpack_uint(values->PipeWorkingMode, 15, 16) |
      util_bitpack_uint(values->TileBasedEngine, 17, 17) |
      util_bitpack_uint(values->MotionCompMemoryTrackerCounterEnable, 23, 23);

   dw[2] = 0;

   dw[3] =
      util_bitpack_uint(values->PicStatusErrorReportID, 0, 31);

   dw[4] =
      util_bitpack_uint(values->AlcChickenbitRestrictSingleTileGroupInAFrame, 4, 4);

   dw[5] =
      util_bitpack_uint(values->PhaseIndicator, 0, 1);

   dw[6] =
      util_bitpack_uint(values->DownscaledSourcePixelPrefetchLength, 2, 4) |
      util_bitpack_uint(values->DownscaledSourcePixelPrefetchEnable, 5, 5) |
      util_bitpack_uint(values->OriginalSourcePixelPrefetchLength, 7, 9) |
      util_bitpack_uint(values->OriginalSourcePixelPrefetchEnable, 10, 10);
}

#define GFX20_AVP_SEGMENT_STATE_length         4
#define GFX20_AVP_SEGMENT_STATE_length_bias      2
#define GFX20_AVP_SEGMENT_STATE_header          \
   .DWordLength                         =      2,  \
   .SubOpcode                           =     50,  \
   .MediaCommandOpcode                  =      3,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_AVP_SEGMENT_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcode;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             SegmentID;
   uint32_t                             SegmentFeatureMask;
   int32_t                              SegmentDeltaQindex;
   bool                                 SegmentBlockSkipFlag;
   bool                                 SegmentBlockGlobalMVFlag;
   bool                                 SegmentLosslessFlag;
   uint32_t                             SegmentLumaYQMLevel;
   uint32_t                             SegmentChromaUQMLevel;
   uint32_t                             SegmentChromaVQMLevel;
   uint32_t                             SegmentDeltaLoopFilterLevelLumaVertical;
   uint32_t                             SegmentDeltaLoopFilterLevelLumaHorizontal;
   uint32_t                             SegmentDeltaLoopFilterLevelChromaU;
   uint32_t                             SegmentDeltaLoopFilterLevelChromaV;
   uint32_t                             SegmentReferenceFrame;
};

static inline __attribute__((always_inline)) void
GFX20_AVP_SEGMENT_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                             __attribute__((unused)) void * restrict dst,
                             __attribute__((unused)) const struct GFX20_AVP_SEGMENT_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcode, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->SegmentID, 0, 2);

   dw[2] =
      util_bitpack_uint(values->SegmentFeatureMask, 0, 7) |
      util_bitpack_sint(values->SegmentDeltaQindex, 8, 16) |
      util_bitpack_uint(values->SegmentBlockSkipFlag, 17, 17) |
      util_bitpack_uint(values->SegmentBlockGlobalMVFlag, 18, 18) |
      util_bitpack_uint(values->SegmentLosslessFlag, 19, 19) |
      util_bitpack_uint(values->SegmentLumaYQMLevel, 20, 23) |
      util_bitpack_uint(values->SegmentChromaUQMLevel, 24, 27) |
      util_bitpack_uint(values->SegmentChromaVQMLevel, 28, 31);

   dw[3] =
      util_bitpack_uint(values->SegmentDeltaLoopFilterLevelLumaVertical, 0, 6) |
      util_bitpack_uint(values->SegmentDeltaLoopFilterLevelLumaHorizontal, 7, 13) |
      util_bitpack_uint(values->SegmentDeltaLoopFilterLevelChromaU, 14, 20) |
      util_bitpack_uint(values->SegmentDeltaLoopFilterLevelChromaV, 21, 27) |
      util_bitpack_uint(values->SegmentReferenceFrame, 28, 30);
}

#define GFX20_AVP_SURFACE_STATE_length         5
#define GFX20_AVP_SURFACE_STATE_length_bias      2
#define GFX20_AVP_SURFACE_STATE_header          \
   .DWordLength                         =      3,  \
   .SubOpcode                           =      1,  \
   .MediaCommandOpcode                  =      3,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_AVP_SURFACE_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcode;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             SurfacePitchMinus1;
   uint32_t                             SurfaceID;
   uint32_t                             YOffsetforUCb;
   uint32_t                             SurfaceFormat;
#define AVP_PLANAR_420_8                         4
#define AVP_P010                                 13
   uint32_t                             DefaultAlphaValue;
   uint32_t                             YOffsetforVCr;
   bool                                 MemoryCompressionEnableforIntraFrame;
   bool                                 MemoryCompressionEnableforLastFrame;
   bool                                 MemoryCompressionEnableforLast2Frame;
   bool                                 MemoryCompressionEnableforLast3Frame;
   bool                                 MemoryCompressionEnableforGoldenFrame;
   bool                                 MemoryCompressionEnableforBwdRefFrame;
   bool                                 MemoryCompressionEnableforAltRef2Frame;
   bool                                 MemoryCompressionEnableforAltRefFrame;
   bool                                 CompressionTypeforIntraFrame;
   bool                                 CompressionTypeforLastFrame;
   bool                                 CompressionTypeforLast2Frame;
   bool                                 CompressionTypeforLast3Frame;
   bool                                 CompressionTypeforGoldenFrame;
   bool                                 CompressionTypeforBwdRefFrame;
   bool                                 CompressionTypeforAltRef2Frame;
   bool                                 CompressionTypeforAltRefFrame;
};

static inline __attribute__((always_inline)) void
GFX20_AVP_SURFACE_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                             __attribute__((unused)) void * restrict dst,
                             __attribute__((unused)) const struct GFX20_AVP_SURFACE_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcode, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->SurfacePitchMinus1, 0, 15) |
      util_bitpack_uint(values->SurfaceID, 28, 31);

   dw[2] =
      util_bitpack_uint(values->YOffsetforUCb, 0, 14) |
      util_bitpack_uint(values->SurfaceFormat, 27, 31);

   dw[3] =
      util_bitpack_uint(values->DefaultAlphaValue, 0, 15) |
      util_bitpack_uint(values->YOffsetforVCr, 16, 31);

   dw[4] =
      util_bitpack_uint(values->MemoryCompressionEnableforIntraFrame, 0, 0) |
      util_bitpack_uint(values->MemoryCompressionEnableforLastFrame, 1, 1) |
      util_bitpack_uint(values->MemoryCompressionEnableforLast2Frame, 2, 2) |
      util_bitpack_uint(values->MemoryCompressionEnableforLast3Frame, 3, 3) |
      util_bitpack_uint(values->MemoryCompressionEnableforGoldenFrame, 4, 4) |
      util_bitpack_uint(values->MemoryCompressionEnableforBwdRefFrame, 5, 5) |
      util_bitpack_uint(values->MemoryCompressionEnableforAltRef2Frame, 6, 6) |
      util_bitpack_uint(values->MemoryCompressionEnableforAltRefFrame, 7, 7) |
      util_bitpack_uint(values->CompressionTypeforIntraFrame, 8, 8) |
      util_bitpack_uint(values->CompressionTypeforLastFrame, 9, 9) |
      util_bitpack_uint(values->CompressionTypeforLast2Frame, 10, 10) |
      util_bitpack_uint(values->CompressionTypeforLast3Frame, 11, 11) |
      util_bitpack_uint(values->CompressionTypeforGoldenFrame, 12, 12) |
      util_bitpack_uint(values->CompressionTypeforBwdRefFrame, 13, 13) |
      util_bitpack_uint(values->CompressionTypeforAltRef2Frame, 14, 14) |
      util_bitpack_uint(values->CompressionTypeforAltRefFrame, 15, 15);
}

#define GFX20_AVP_TILE_CODING_length           7
#define GFX20_AVP_TILE_CODING_length_bias      2
#define GFX20_AVP_TILE_CODING_header            \
   .DWordLength                         =      5,  \
   .SubOpcode                           =     21,  \
   .MediaCommandOpcode                  =      3,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_AVP_TILE_CODING {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcode;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             FrameTileID;
   uint32_t                             TGTileNum;
   uint32_t                             TileGroupID;
   uint32_t                             TileColumnPositioninSBUnit;
   uint32_t                             TileRowPositioninSBUnit;
   uint32_t                             TileWidthinSBMinus1;
   uint32_t                             TileHeightinSBMinus1;
   bool                                 FirstPhaseonScalabilityMode;
   bool                                 LastPhaseonScalabilityMode;
   bool                                 AVPCRCEnable;
   bool                                 FirstTileinaFrame;
   bool                                 IsLastTileofColumnFlag;
   bool                                 IsLastTileofRowFlag;
   bool                                 IsStartTileofTileGroupFlag;
   bool                                 IsEndTileofTileGroupFlag;
   bool                                 IsLastTileofFrameFlag;
   bool                                 DisableCDFUpdateFlag;
   bool                                 DisableFrameContextUpdateFlag;
   uint32_t                             NumberofActiveBEPipes;
   uint32_t                             NumofTileColumnsinFrameMinus1;
   uint32_t                             NumofTileRowsinFrameMinus1;
   uint32_t                             OutputDecodedTileColumnPositioninSBUnit;
   uint32_t                             OutputDecodedTileRowPositioninSBUnit;
};

static inline __attribute__((always_inline)) void
GFX20_AVP_TILE_CODING_pack(__attribute__((unused)) __gen_user_data *data,
                           __attribute__((unused)) void * restrict dst,
                           __attribute__((unused)) const struct GFX20_AVP_TILE_CODING * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcode, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->FrameTileID, 0, 11) |
      util_bitpack_uint(values->TGTileNum, 12, 23) |
      util_bitpack_uint(values->TileGroupID, 24, 31);

   dw[2] =
      util_bitpack_uint(values->TileColumnPositioninSBUnit, 0, 9) |
      util_bitpack_uint(values->TileRowPositioninSBUnit, 16, 25);

   dw[3] =
      util_bitpack_uint(values->TileWidthinSBMinus1, 0, 5) |
      util_bitpack_uint(values->TileHeightinSBMinus1, 16, 25);

   dw[4] =
      util_bitpack_uint(values->FirstPhaseonScalabilityMode, 0, 0) |
      util_bitpack_uint(values->LastPhaseonScalabilityMode, 1, 1) |
      util_bitpack_uint(values->AVPCRCEnable, 2, 2) |
      util_bitpack_uint(values->FirstTileinaFrame, 23, 23) |
      util_bitpack_uint(values->IsLastTileofColumnFlag, 25, 25) |
      util_bitpack_uint(values->IsLastTileofRowFlag, 26, 26) |
      util_bitpack_uint(values->IsStartTileofTileGroupFlag, 27, 27) |
      util_bitpack_uint(values->IsEndTileofTileGroupFlag, 28, 28) |
      util_bitpack_uint(values->IsLastTileofFrameFlag, 29, 29) |
      util_bitpack_uint(values->DisableCDFUpdateFlag, 30, 30) |
      util_bitpack_uint(values->DisableFrameContextUpdateFlag, 31, 31);

   dw[5] =
      util_bitpack_uint(values->NumberofActiveBEPipes, 0, 7) |
      util_bitpack_uint(values->NumofTileColumnsinFrameMinus1, 12, 21) |
      util_bitpack_uint(values->NumofTileRowsinFrameMinus1, 22, 31);

   dw[6] =
      util_bitpack_uint(values->OutputDecodedTileColumnPositioninSBUnit, 0, 9) |
      util_bitpack_uint(values->OutputDecodedTileRowPositioninSBUnit, 16, 25);
}

#define GFX20_AVP_VD_CONTROL_STATE_length      3
#define GFX20_AVP_VD_CONTROL_STATE_length_bias      2
#define GFX20_AVP_VD_CONTROL_STATE_header       \
   .DWordLength                         =      1,  \
   .SubOpcode                           =     10,  \
   .MediaCommandOpcode                  =      3,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_AVP_VD_CONTROL_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcode;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   struct GFX20_VD_CONTROL_STATE_BODY   VDControlState;
};

static inline __attribute__((always_inline)) void
GFX20_AVP_VD_CONTROL_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                                __attribute__((unused)) void * restrict dst,
                                __attribute__((unused)) const struct GFX20_AVP_VD_CONTROL_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcode, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   GFX20_VD_CONTROL_STATE_BODY_pack(data, &dw[1], &values->VDControlState);
}

#define GFX20_HCP_BSD_OBJECT_length            3
#define GFX20_HCP_BSD_OBJECT_length_bias       2
#define GFX20_HCP_BSD_OBJECT_header             \
   .DWordLength                         =      1,  \
   .SubOpcode                           =     32,  \
   .MediaCommandOpcode                  =      7,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_HCP_BSD_OBJECT {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcode;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             IndirectBSDDataLength;
   uint64_t                             IndirectBSDDataStartAddress;
};

static inline __attribute__((always_inline)) void
GFX20_HCP_BSD_OBJECT_pack(__attribute__((unused)) __gen_user_data *data,
                          __attribute__((unused)) void * restrict dst,
                          __attribute__((unused)) const struct GFX20_HCP_BSD_OBJECT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcode, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->IndirectBSDDataLength, 0, 31);

   dw[2] =
      __gen_offset(values->IndirectBSDDataStartAddress, 0, 28);
}

#define GFX20_HCP_FQM_STATE_length            34
#define GFX20_HCP_FQM_STATE_length_bias        2
#define GFX20_HCP_FQM_STATE_header              \
   .DWordLength                         =     32,  \
   .SubOpcode                           =      5,  \
   .MediaCommandOpcode                  =      7,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_HCP_FQM_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcode;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             IntraInter;
#define Intra                                    0
#define Inter                                    1
   uint32_t                             SizeID;
#define SZ_4x4                                   0
#define SZ_8x8                                   1
#define SZ_16x16                                 2
#define SZ_32x32                                 3
   uint32_t                             ColorComponent;
#define Luma                                     0
#define ChromaCb                                 1
#define ChromaCr                                 2
   uint32_t                             FQMDCValue;
   uint32_t                             QuantizerMatrix8x8[128];
};

static inline __attribute__((always_inline)) void
GFX20_HCP_FQM_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                         __attribute__((unused)) void * restrict dst,
                         __attribute__((unused)) const struct GFX20_HCP_FQM_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcode, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->IntraInter, 0, 0) |
      util_bitpack_uint(values->SizeID, 1, 2) |
      util_bitpack_uint(values->ColorComponent, 3, 4) |
      util_bitpack_uint(values->FQMDCValue, 16, 31);

   dw[2] =
      util_bitpack_uint(values->QuantizerMatrix8x8[0], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[1], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[2], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[3], 24, 31);

   dw[3] =
      util_bitpack_uint(values->QuantizerMatrix8x8[4], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[5], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[6], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[7], 24, 31);

   dw[4] =
      util_bitpack_uint(values->QuantizerMatrix8x8[8], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[9], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[10], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[11], 24, 31);

   dw[5] =
      util_bitpack_uint(values->QuantizerMatrix8x8[12], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[13], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[14], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[15], 24, 31);

   dw[6] =
      util_bitpack_uint(values->QuantizerMatrix8x8[16], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[17], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[18], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[19], 24, 31);

   dw[7] =
      util_bitpack_uint(values->QuantizerMatrix8x8[20], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[21], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[22], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[23], 24, 31);

   dw[8] =
      util_bitpack_uint(values->QuantizerMatrix8x8[24], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[25], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[26], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[27], 24, 31);

   dw[9] =
      util_bitpack_uint(values->QuantizerMatrix8x8[28], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[29], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[30], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[31], 24, 31);

   dw[10] =
      util_bitpack_uint(values->QuantizerMatrix8x8[32], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[33], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[34], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[35], 24, 31);

   dw[11] =
      util_bitpack_uint(values->QuantizerMatrix8x8[36], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[37], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[38], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[39], 24, 31);

   dw[12] =
      util_bitpack_uint(values->QuantizerMatrix8x8[40], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[41], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[42], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[43], 24, 31);

   dw[13] =
      util_bitpack_uint(values->QuantizerMatrix8x8[44], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[45], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[46], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[47], 24, 31);

   dw[14] =
      util_bitpack_uint(values->QuantizerMatrix8x8[48], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[49], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[50], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[51], 24, 31);

   dw[15] =
      util_bitpack_uint(values->QuantizerMatrix8x8[52], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[53], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[54], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[55], 24, 31);

   dw[16] =
      util_bitpack_uint(values->QuantizerMatrix8x8[56], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[57], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[58], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[59], 24, 31);

   dw[17] =
      util_bitpack_uint(values->QuantizerMatrix8x8[60], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[61], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[62], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[63], 24, 31);

   dw[18] =
      util_bitpack_uint(values->QuantizerMatrix8x8[64], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[65], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[66], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[67], 24, 31);

   dw[19] =
      util_bitpack_uint(values->QuantizerMatrix8x8[68], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[69], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[70], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[71], 24, 31);

   dw[20] =
      util_bitpack_uint(values->QuantizerMatrix8x8[72], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[73], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[74], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[75], 24, 31);

   dw[21] =
      util_bitpack_uint(values->QuantizerMatrix8x8[76], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[77], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[78], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[79], 24, 31);

   dw[22] =
      util_bitpack_uint(values->QuantizerMatrix8x8[80], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[81], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[82], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[83], 24, 31);

   dw[23] =
      util_bitpack_uint(values->QuantizerMatrix8x8[84], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[85], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[86], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[87], 24, 31);

   dw[24] =
      util_bitpack_uint(values->QuantizerMatrix8x8[88], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[89], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[90], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[91], 24, 31);

   dw[25] =
      util_bitpack_uint(values->QuantizerMatrix8x8[92], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[93], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[94], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[95], 24, 31);

   dw[26] =
      util_bitpack_uint(values->QuantizerMatrix8x8[96], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[97], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[98], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[99], 24, 31);

   dw[27] =
      util_bitpack_uint(values->QuantizerMatrix8x8[100], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[101], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[102], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[103], 24, 31);

   dw[28] =
      util_bitpack_uint(values->QuantizerMatrix8x8[104], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[105], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[106], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[107], 24, 31);

   dw[29] =
      util_bitpack_uint(values->QuantizerMatrix8x8[108], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[109], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[110], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[111], 24, 31);

   dw[30] =
      util_bitpack_uint(values->QuantizerMatrix8x8[112], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[113], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[114], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[115], 24, 31);

   dw[31] =
      util_bitpack_uint(values->QuantizerMatrix8x8[116], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[117], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[118], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[119], 24, 31);

   dw[32] =
      util_bitpack_uint(values->QuantizerMatrix8x8[120], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[121], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[122], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[123], 24, 31);

   dw[33] =
      util_bitpack_uint(values->QuantizerMatrix8x8[124], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[125], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[126], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[127], 24, 31);
}

#define GFX20_HCP_IND_OBJ_BASE_ADDR_STATE_length     29
#define GFX20_HCP_IND_OBJ_BASE_ADDR_STATE_length_bias      2
#define GFX20_HCP_IND_OBJ_BASE_ADDR_STATE_header\
   .DWordLength                         =     27,  \
   .SubOpcode                           =      3,  \
   .MediaCommandOpcode                  =      7,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_HCP_IND_OBJ_BASE_ADDR_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcode;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   __gen_address_type                   HCPIndirectBitstreamObjectBaseAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES HCPIndirectBitstreamObjectMemoryAddressAttributes;
   __gen_address_type                   HCPIndirectBitstreamObjectAccessUpperBound;
   __gen_address_type                   HCPIndirectCUObjectBaseAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES HCPIndirectCUObjectMemoryAddressAttributes;
   __gen_address_type                   HCPPAKBSEObjectBaseAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES HCPPAKBSEObjectMemoryAddressAttributes;
   __gen_address_type                   HCPPAKBSEObjectAccessUpperBound;
   __gen_address_type                   HCPVP9PAKCompressedHeaderSyntaxStreamInBaseAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES HCPVP9PAKCompressedHeaderSyntaxStreamInMemoryAddressAttributes;
   __gen_address_type                   HCPVP9PAKProbabilityCounterStreamOutBaseAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES HCPVP9PAKProbabilityCounterStreamOutMemoryAddressAttributes;
   __gen_address_type                   HCPVP9PAKProbabilityDeltasStreamInBaseAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES HCPVP9PAKProbabilityDeltasStreamInMemoryAddressAttributes;
   __gen_address_type                   HCPVP9PAKTileRecordStreamOutBaseAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES HCPVP9PAKTileRecordStreamOutMemoryAddressAttributes;
   __gen_address_type                   HCPVP9PAKCULevelStatisticStreamOutBaseAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES HCPVP9PAKCULevelStatisticStreamOutMemoryAddressAttributes;
};

static inline __attribute__((always_inline)) void
GFX20_HCP_IND_OBJ_BASE_ADDR_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                                       __attribute__((unused)) void * restrict dst,
                                       __attribute__((unused)) const struct GFX20_HCP_IND_OBJ_BASE_ADDR_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcode, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   const uint64_t v1_address =
      __gen_address(data, &dw[1], values->HCPIndirectBitstreamObjectBaseAddress, 0, 0, 63);
   dw[1] = v1_address;
   dw[2] = v1_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[3], &values->HCPIndirectBitstreamObjectMemoryAddressAttributes);

   const uint64_t v4_address =
      __gen_address(data, &dw[4], values->HCPIndirectBitstreamObjectAccessUpperBound, 0, 0, 63);
   dw[4] = v4_address;
   dw[5] = v4_address >> 32;

   const uint64_t v6_address =
      __gen_address(data, &dw[6], values->HCPIndirectCUObjectBaseAddress, 0, 0, 63);
   dw[6] = v6_address;
   dw[7] = v6_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[8], &values->HCPIndirectCUObjectMemoryAddressAttributes);

   const uint64_t v9_address =
      __gen_address(data, &dw[9], values->HCPPAKBSEObjectBaseAddress, 0, 0, 63);
   dw[9] = v9_address;
   dw[10] = v9_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[11], &values->HCPPAKBSEObjectMemoryAddressAttributes);

   const uint64_t v12_address =
      __gen_address(data, &dw[12], values->HCPPAKBSEObjectAccessUpperBound, 0, 0, 63);
   dw[12] = v12_address;
   dw[13] = v12_address >> 32;

   const uint64_t v14_address =
      __gen_address(data, &dw[14], values->HCPVP9PAKCompressedHeaderSyntaxStreamInBaseAddress, 0, 0, 63);
   dw[14] = v14_address;
   dw[15] = v14_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[16], &values->HCPVP9PAKCompressedHeaderSyntaxStreamInMemoryAddressAttributes);

   const uint64_t v17_address =
      __gen_address(data, &dw[17], values->HCPVP9PAKProbabilityCounterStreamOutBaseAddress, 0, 0, 63);
   dw[17] = v17_address;
   dw[18] = v17_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[19], &values->HCPVP9PAKProbabilityCounterStreamOutMemoryAddressAttributes);

   const uint64_t v20_address =
      __gen_address(data, &dw[20], values->HCPVP9PAKProbabilityDeltasStreamInBaseAddress, 0, 0, 63);
   dw[20] = v20_address;
   dw[21] = v20_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[22], &values->HCPVP9PAKProbabilityDeltasStreamInMemoryAddressAttributes);

   const uint64_t v23_address =
      __gen_address(data, &dw[23], values->HCPVP9PAKTileRecordStreamOutBaseAddress, 0, 0, 63);
   dw[23] = v23_address;
   dw[24] = v23_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[25], &values->HCPVP9PAKTileRecordStreamOutMemoryAddressAttributes);

   const uint64_t v26_address =
      __gen_address(data, &dw[26], values->HCPVP9PAKCULevelStatisticStreamOutBaseAddress, 0, 0, 63);
   dw[26] = v26_address;
   dw[27] = v26_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[28], &values->HCPVP9PAKCULevelStatisticStreamOutMemoryAddressAttributes);
}

#define GFX20_HCP_PAK_INSERT_OBJECT_length_bias      2
#define GFX20_HCP_PAK_INSERT_OBJECT_header      \
   .DWordLength                         =      0,  \
   .SubOpcode                           =     34,  \
   .MediaCommandOpcode                  =      7,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_HCP_PAK_INSERT_OBJECT {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcode;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   bool                                 EndofSlice;
   bool                                 LastHeader;
   bool                                 EmulationByteBitsInsertEnable;
   uint32_t                             SkipEmulationByteCount;
   uint32_t                             DataBitsInLastDW;
   bool                                 SliceHeaderIndicator;
   uint32_t                             HeaderLengthExcludedFromSize;
#define ACCUMULATE                               0
#define NO_ACCUMULATION                          1
   uint32_t                             DataByteOffset;
   bool                                 IndirectPayloadEnable;
   /* variable length fields follow */
};

static inline __attribute__((always_inline)) void
GFX20_HCP_PAK_INSERT_OBJECT_pack(__attribute__((unused)) __gen_user_data *data,
                                 __attribute__((unused)) void * restrict dst,
                                 __attribute__((unused)) const struct GFX20_HCP_PAK_INSERT_OBJECT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcode, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->EndofSlice, 1, 1) |
      util_bitpack_uint(values->LastHeader, 2, 2) |
      util_bitpack_uint(values->EmulationByteBitsInsertEnable, 3, 3) |
      util_bitpack_uint(values->SkipEmulationByteCount, 4, 7) |
      util_bitpack_uint(values->DataBitsInLastDW, 8, 13) |
      util_bitpack_uint(values->SliceHeaderIndicator, 14, 14) |
      util_bitpack_uint(values->HeaderLengthExcludedFromSize, 15, 15) |
      util_bitpack_uint(values->DataByteOffset, 16, 17) |
      util_bitpack_uint(values->IndirectPayloadEnable, 31, 31);
}

#define GFX20_HCP_PAK_OBJECT_length            2
#define GFX20_HCP_PAK_OBJECT_length_bias       2
#define GFX20_HCP_PAK_OBJECT_header             \
   .SubOpcode                           =     33,  \
   .MediaCommandOpcode                  =      7,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_HCP_PAK_OBJECT {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcode;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             SplitLevel2Part0;
   uint32_t                             SplitLevel2Part1;
   uint32_t                             SplitLevel2Part2;
   uint32_t                             SplitLevel2Part3;
   uint32_t                             SplitLevel1;
   uint32_t                             SplitLevel0;
   uint32_t                             CUCount;
   bool                                 LastLCUofTile;
   bool                                 LastLCUofSlice;
   uint32_t                             CurrentLCUXAddress;
   uint32_t                             CurrentLCUYAddress;
   uint32_t                             EstimatedLCUSize;
   uint32_t                             SSEClassID32x32_0;
   uint32_t                             SSEClassID32x32_1;
   uint32_t                             SSEClassID32x32_2;
   uint32_t                             SSEClassID32x32_3;
   bool                                 LCUForceZeroCoeff;
};

static inline __attribute__((always_inline)) void
GFX20_HCP_PAK_OBJECT_pack(__attribute__((unused)) __gen_user_data *data,
                          __attribute__((unused)) void * restrict dst,
                          __attribute__((unused)) const struct GFX20_HCP_PAK_OBJECT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcode, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->SplitLevel2Part0, 0, 3) |
      util_bitpack_uint(values->SplitLevel2Part1, 4, 7) |
      util_bitpack_uint(values->SplitLevel2Part2, 8, 11) |
      util_bitpack_uint(values->SplitLevel2Part3, 12, 15) |
      util_bitpack_uint(values->SplitLevel1, 16, 19) |
      util_bitpack_uint(values->SplitLevel0, 20, 20) |
      util_bitpack_uint(values->CUCount, 24, 29) |
      util_bitpack_uint(values->LastLCUofTile, 30, 30) |
      util_bitpack_uint(values->LastLCUofSlice, 31, 31);
}

#define GFX20_HCP_PIC_STATE_length            41
#define GFX20_HCP_PIC_STATE_length_bias        2
#define GFX20_HCP_PIC_STATE_header              \
   .DWordLength                         =     39,  \
   .SubOpcode                           =     16,  \
   .MediaCommandOpcode                  =      7,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_HCP_PIC_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcode;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             FrameWidthInMinimumCodingBlockSize;
   bool                                 PAKTransformSkipEnable;
   uint32_t                             FrameHeightInMinimumCodingBlockSize;
   uint32_t                             MinCUSize;
#define LCU_64x64                                3
#define LCU_32x32                                2
#define LCU_16x16                                1
#define LCU_8x8                                  0
   uint32_t                             LCUSize;
#define LCU_64x64                                3
#define LCU_32x32                                2
#define LCU_16x16                                1
#define LCU_Illegalreserved                      0
   uint32_t                             MinTUSize;
#define TU_32x32                                 3
#define TU_16x16                                 2
#define TU_8x8                                   1
#define TU_4x4                                   0
   uint32_t                             MaxTUSize;
#define TU_32x32                                 3
#define TU_16x16                                 2
#define TU_8x8                                   1
#define TU_4x4                                   0
   uint32_t                             MinPCMSize;
#define PCM_32x32                                2
#define PCM_16x16                                1
#define PCM_8x8                                  0
   uint32_t                             MaxPCMSize;
#define PCM_32x32                                2
#define PCM_16x16                                1
#define PCM_8x8                                  0
   uint32_t                             Log2SAOOffsetScaleLuma;
   uint32_t                             Log2SAOOffsetScaleChroma;
   uint32_t                             ChromaQPOffsetListLength;
   uint32_t                             DiffCUChromaQPOffsetDepth;
   bool                                 ChromaQPOffsetListEnable;
   uint32_t                             ChromaSubsampling;
#define _420                                     1
#define _422                                     2
#define _444                                     3
   bool                                 CollocatedPictureIsISlice;
   bool                                 CurrentPictureIsISlice;
   bool                                 CABACZeroWordInsertionTestEnable;
   bool                                 HighPrecisionOffsetsEnable;
   uint32_t                             Log2MaxTransformSkipSize;
   bool                                 CrossComponentPredictionEnable;
   bool                                 CABACBypassAlignmentEnable;
   bool                                 PersistentRiceAdaptationEnable;
   bool                                 IntraSmoothingDisable;
   bool                                 ExplicitRDPCMEnable;
   bool                                 ImplicitRDPCMEnable;
   bool                                 TransformSkipContextEnable;
   bool                                 TransformSkipRotationEnable;
   bool                                 SPSRangeExtensionEnable;
   bool                                 SampleAdaptiveOffsetEnable;
   bool                                 PCMEnable;
   bool                                 CUQPDeltaEnable;
   uint32_t                             MaxDQPDepth;
   bool                                 PCMLoopFilterDisable;
   bool                                 ConstrainedIntraPrediction;
   uint32_t                             Log2ParallelMergeLevel;
   bool                                 SignDataHiding;
   bool                                 LoopFilterEnable;
   bool                                 EntropyCodingSyncEnable;
   bool                                 TilingEnable;
   bool                                 WeightedBiPredicationEnable;
   bool                                 WeightedPredicationEnable;
   bool                                 FieldPic;
   bool                                 TopField;
   bool                                 TransformSkipEnable;
   bool                                 AMPEnable;
   bool                                 TransquantBypassEnable;
   bool                                 StrongIntraSmoothingEnable;
   uint32_t                             CUPacketStructure;
#define VME                                      0
#define ExtEnc                                   1
   int32_t                              PictureCbQPOffset;
   int32_t                              PictureCrQPOffset;
   uint32_t                             IntraMaxTransformHierarchyDepth;
   uint32_t                             InterMaxTransformHierarchyDepth;
   uint32_t                             ChromaPCMSampleBitDepth;
   uint32_t                             LumaPCMSampleBitDepth;
   uint32_t                             ChromaBitDepth;
#define _8bit                                    0
#define _9bit                                    1
#define _10bit                                   2
#define _11bit                                   3
#define _12bit                                   4
   uint32_t                             LumaBitDepth;
#define _8bit                                    0
#define _9bit                                    1
#define _10bit                                   2
#define _11bit                                   3
#define _12bit                                   4
   uint32_t                             LCUMaxBitSizeAllowed;
   bool                                 NonFirstPass;
   bool                                 LCUMaxSizeReport;
   bool                                 FrameBitrateMaxReport;
   bool                                 FrameBitrateMinReport;
   bool                                 LoadBitstreamPointerPerSlice;
   uint32_t                             FrameBitrateMax;
   uint32_t                             FrameBitrateMaxUnit;
   uint32_t                             FrameBitrateMin;
   uint32_t                             FrameBitrateMinUnit;
   uint32_t                             FrameBitrateMinDelta;
   uint32_t                             FrameBitrateMaxDelta;
   struct GFX20_FRAMEDELTAQP            FrameDeltaQPMax;
   struct GFX20_FRAMEDELTAQP            FrameDeltaQPMin;
   struct GFX20_FRAMEDELTAQPRANGE       FrameDeltaQPMaxRange;
   struct GFX20_FRAMEDELTAQPRANGE       FrameDeltaQPMinRange;
   uint32_t                             MinimumFrameSize;
   uint32_t                             MinimumFrameSizeUnits;
#define HCP_MFSU_4Kb                             0
#define HCP_MFSU_16Kb                            1
#define HCP_MFSU_Compatibilitymode               2
#define HCP_MFSU_16bytes                         3
   uint32_t                             FractionalQPInput;
   uint32_t                             FractionalQPOffset;
   bool                                 RhoDomainRateControlEnable;
   bool                                 FractionalQPAdjustmentEnable;
   uint32_t                             RhoDomainFrameLevelQP;
   bool                                 PAKDynamicSliceModeEnable;
   bool                                 NoOutputofPriorPics;
   bool                                 FirstSliceSegmentInPic;
   uint32_t                             NalUnitType;
   uint32_t                             Slice_pic_parameter_set_id;
   bool                                 SSEEnable;
   bool                                 RDOQEnable;
   uint32_t                             NumberofLCUsInNormalSliceSizeConformanceMode;
   bool                                 IntraTUCountBasedRDOQDisable;
   uint32_t                             SliceSizeThreshold;
   uint32_t                             TargetSliceSize;
   uint32_t                             Class0_SSE_Threshold0;
   uint32_t                             Class0_SSE_Threshold1;
   uint64_t                             SSEThresholdsforClass18;
   int32_t                              CbQPOffsetList0;
   int32_t                              CbQPOffsetList1;
   int32_t                              CbQPOffsetList2;
   int32_t                              CbQPOffsetList3;
   int32_t                              CbQPOffsetList4;
   int32_t                              CbQPOffsetList5;
   int32_t                              CrQPOffsetList0;
   int32_t                              CrQPOffsetList1;
   int32_t                              CrQPOffsetList2;
   int32_t                              CrQPOffsetList3;
   int32_t                              CrQPOffsetList4;
   int32_t                              CrQPOffsetList5;
   uint32_t                             RDOQIntraTUThreshold;
};

static inline __attribute__((always_inline)) void
GFX20_HCP_PIC_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                         __attribute__((unused)) void * restrict dst,
                         __attribute__((unused)) const struct GFX20_HCP_PIC_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcode, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->FrameWidthInMinimumCodingBlockSize, 0, 10) |
      util_bitpack_uint(values->PAKTransformSkipEnable, 15, 15) |
      util_bitpack_uint(values->FrameHeightInMinimumCodingBlockSize, 16, 26);

   dw[2] =
      util_bitpack_uint(values->MinCUSize, 0, 1) |
      util_bitpack_uint(values->LCUSize, 2, 3) |
      util_bitpack_uint(values->MinTUSize, 4, 5) |
      util_bitpack_uint(values->MaxTUSize, 6, 7) |
      util_bitpack_uint(values->MinPCMSize, 8, 9) |
      util_bitpack_uint(values->MaxPCMSize, 10, 11) |
      util_bitpack_uint(values->Log2SAOOffsetScaleLuma, 12, 14) |
      util_bitpack_uint(values->Log2SAOOffsetScaleChroma, 16, 18) |
      util_bitpack_uint(values->ChromaQPOffsetListLength, 20, 22) |
      util_bitpack_uint(values->DiffCUChromaQPOffsetDepth, 24, 27) |
      util_bitpack_uint(values->ChromaQPOffsetListEnable, 28, 28) |
      util_bitpack_uint(values->ChromaSubsampling, 29, 31);

   dw[3] =
      util_bitpack_uint(values->CollocatedPictureIsISlice, 0, 0) |
      util_bitpack_uint(values->CurrentPictureIsISlice, 1, 1) |
      util_bitpack_uint(values->CABACZeroWordInsertionTestEnable, 2, 2) |
      util_bitpack_uint(values->HighPrecisionOffsetsEnable, 19, 19) |
      util_bitpack_uint(values->Log2MaxTransformSkipSize, 20, 22) |
      util_bitpack_uint(values->CrossComponentPredictionEnable, 23, 23) |
      util_bitpack_uint(values->CABACBypassAlignmentEnable, 24, 24) |
      util_bitpack_uint(values->PersistentRiceAdaptationEnable, 25, 25) |
      util_bitpack_uint(values->IntraSmoothingDisable, 26, 26) |
      util_bitpack_uint(values->ExplicitRDPCMEnable, 27, 27) |
      util_bitpack_uint(values->ImplicitRDPCMEnable, 28, 28) |
      util_bitpack_uint(values->TransformSkipContextEnable, 29, 29) |
      util_bitpack_uint(values->TransformSkipRotationEnable, 30, 30) |
      util_bitpack_uint(values->SPSRangeExtensionEnable, 31, 31);

   dw[4] =
      util_bitpack_uint(values->SampleAdaptiveOffsetEnable, 3, 3) |
      util_bitpack_uint(values->PCMEnable, 4, 4) |
      util_bitpack_uint(values->CUQPDeltaEnable, 5, 5) |
      util_bitpack_uint(values->MaxDQPDepth, 6, 7) |
      util_bitpack_uint(values->PCMLoopFilterDisable, 8, 8) |
      util_bitpack_uint(values->ConstrainedIntraPrediction, 9, 9) |
      util_bitpack_uint(values->Log2ParallelMergeLevel, 10, 12) |
      util_bitpack_uint(values->SignDataHiding, 13, 13) |
      util_bitpack_uint(values->LoopFilterEnable, 15, 15) |
      util_bitpack_uint(values->EntropyCodingSyncEnable, 16, 16) |
      util_bitpack_uint(values->TilingEnable, 17, 17) |
      util_bitpack_uint(values->WeightedBiPredicationEnable, 18, 18) |
      util_bitpack_uint(values->WeightedPredicationEnable, 19, 19) |
      util_bitpack_uint(values->FieldPic, 20, 20) |
      util_bitpack_uint(values->TopField, 21, 21) |
      util_bitpack_uint(values->TransformSkipEnable, 22, 22) |
      util_bitpack_uint(values->AMPEnable, 23, 23) |
      util_bitpack_uint(values->TransquantBypassEnable, 25, 25) |
      util_bitpack_uint(values->StrongIntraSmoothingEnable, 26, 26) |
      util_bitpack_uint(values->CUPacketStructure, 27, 27);

   dw[5] =
      util_bitpack_sint(values->PictureCbQPOffset, 0, 4) |
      util_bitpack_sint(values->PictureCrQPOffset, 5, 9) |
      util_bitpack_uint(values->IntraMaxTransformHierarchyDepth, 10, 12) |
      util_bitpack_uint(values->InterMaxTransformHierarchyDepth, 13, 15) |
      util_bitpack_uint(values->ChromaPCMSampleBitDepth, 16, 19) |
      util_bitpack_uint(values->LumaPCMSampleBitDepth, 20, 23) |
      util_bitpack_uint(values->ChromaBitDepth, 24, 26) |
      util_bitpack_uint(values->LumaBitDepth, 27, 29);

   dw[6] =
      util_bitpack_uint(values->LCUMaxBitSizeAllowed, 0, 15) |
      util_bitpack_uint(values->NonFirstPass, 16, 16) |
      util_bitpack_uint(values->LCUMaxSizeReport, 24, 24) |
      util_bitpack_uint(values->FrameBitrateMaxReport, 25, 25) |
      util_bitpack_uint(values->FrameBitrateMinReport, 26, 26) |
      util_bitpack_uint(values->LoadBitstreamPointerPerSlice, 29, 29);

   dw[7] =
      util_bitpack_uint(values->FrameBitrateMax, 0, 13) |
      util_bitpack_uint(values->FrameBitrateMaxUnit, 31, 31);

   dw[8] =
      util_bitpack_uint(values->FrameBitrateMin, 0, 13) |
      util_bitpack_uint(values->FrameBitrateMinUnit, 31, 31);

   dw[9] =
      util_bitpack_uint(values->FrameBitrateMinDelta, 0, 14) |
      util_bitpack_uint(values->FrameBitrateMaxDelta, 16, 30);

   GFX20_FRAMEDELTAQP_pack(data, &dw[10], &values->FrameDeltaQPMax);

   GFX20_FRAMEDELTAQP_pack(data, &dw[12], &values->FrameDeltaQPMin);

   GFX20_FRAMEDELTAQPRANGE_pack(data, &dw[14], &values->FrameDeltaQPMaxRange);

   GFX20_FRAMEDELTAQPRANGE_pack(data, &dw[16], &values->FrameDeltaQPMinRange);

   dw[18] =
      util_bitpack_uint(values->MinimumFrameSize, 0, 15) |
      util_bitpack_uint(values->MinimumFrameSizeUnits, 30, 31);

   dw[19] =
      util_bitpack_uint(values->FractionalQPInput, 0, 2) |
      util_bitpack_uint(values->FractionalQPOffset, 3, 5) |
      util_bitpack_uint(values->RhoDomainRateControlEnable, 6, 6) |
      util_bitpack_uint(values->FractionalQPAdjustmentEnable, 7, 7) |
      util_bitpack_uint(values->RhoDomainFrameLevelQP, 8, 13) |
      util_bitpack_uint(values->PAKDynamicSliceModeEnable, 14, 14) |
      util_bitpack_uint(values->NoOutputofPriorPics, 15, 15) |
      util_bitpack_uint(values->FirstSliceSegmentInPic, 16, 16) |
      util_bitpack_uint(values->NalUnitType, 17, 17) |
      util_bitpack_uint(values->Slice_pic_parameter_set_id, 18, 23) |
      util_bitpack_uint(values->SSEEnable, 24, 24) |
      util_bitpack_uint(values->RDOQEnable, 25, 25) |
      util_bitpack_uint(values->NumberofLCUsInNormalSliceSizeConformanceMode, 26, 27);

   dw[20] =
      util_bitpack_uint(values->IntraTUCountBasedRDOQDisable, 6, 6);

   dw[21] =
      util_bitpack_uint(values->SliceSizeThreshold, 0, 31);

   dw[22] =
      util_bitpack_uint(values->TargetSliceSize, 0, 31);

   dw[23] =
      util_bitpack_uint(values->Class0_SSE_Threshold0, 0, 15) |
      util_bitpack_uint(values->Class0_SSE_Threshold1, 16, 31);

   const uint64_t v24 =
      util_bitpack_uint(values->SSEThresholdsforClass18, 0, 255);
   dw[24] = v24;
   dw[25] = v24 >> 32;

   dw[32] =
      util_bitpack_sint(values->CbQPOffsetList0, 0, 4) |
      util_bitpack_sint(values->CbQPOffsetList1, 5, 9) |
      util_bitpack_sint(values->CbQPOffsetList2, 10, 14) |
      util_bitpack_sint(values->CbQPOffsetList3, 15, 19) |
      util_bitpack_sint(values->CbQPOffsetList4, 20, 24) |
      util_bitpack_sint(values->CbQPOffsetList5, 25, 29);

   dw[33] =
      util_bitpack_sint(values->CrQPOffsetList0, 0, 4) |
      util_bitpack_sint(values->CrQPOffsetList1, 5, 9) |
      util_bitpack_sint(values->CrQPOffsetList2, 10, 14) |
      util_bitpack_sint(values->CrQPOffsetList3, 15, 19) |
      util_bitpack_sint(values->CrQPOffsetList4, 20, 24) |
      util_bitpack_sint(values->CrQPOffsetList5, 25, 29);

   dw[34] = 0;

   dw[35] = 0;

   dw[36] = 0;

   dw[37] =
      util_bitpack_uint(values->RDOQIntraTUThreshold, 0, 15);

   dw[38] = 0;

   dw[39] = 0;

   dw[40] = 0;
}

#define GFX20_HCP_PIPE_BUF_ADDR_STATE_length    121
#define GFX20_HCP_PIPE_BUF_ADDR_STATE_length_bias      2
#define GFX20_HCP_PIPE_BUF_ADDR_STATE_header    \
   .DWordLength                         =    119,  \
   .SubOpcode                           =      2,  \
   .MediaCommandOpcode                  =      7,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_HCP_PIPE_BUF_ADDR_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcode;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   __gen_address_type                   DecodedPictureAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES DecodedPictureMemoryAddressAttributes;
   __gen_address_type                   DeblockingFilterLineBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES DeblockingFilterLineBufferMemoryAddressAttributes;
   __gen_address_type                   DeblockingFilterTileLineBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES DeblockingFilterTileLineBufferMemoryAddressAttributes;
   __gen_address_type                   DeblockingFilterTileColumnBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES DeblockingFilterTileColumnBufferMemoryAddressAttributes;
   __gen_address_type                   MetadataLineBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES MetadataLineBufferMemoryAddressAttributes;
   __gen_address_type                   MetadataTileLineBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES MetadataTileLineBufferMemoryAddressAttributes;
   __gen_address_type                   MetadataTileColumnBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES MetadataTileColumnBufferMemoryAddressAttributes;
   __gen_address_type                   SAOLineBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES SAOLineBufferMemoryAddressAttributes;
   __gen_address_type                   SAOTileLineBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES SAOTileLineBufferMemoryAddressAttributes;
   __gen_address_type                   SAOTileColumnBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES SAOTileColumnBufferMemoryAddressAttributes;
   __gen_address_type                   CurrentMVTemporalBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES CurrentMVTemporalBufferMemoryAddressAttributes;
   __gen_address_type                   ReferencePictureAddress[8];
   struct GFX20_MEMORYADDRESSATTRIBUTES ReferencePictureMemoryAddressAttributes;
   __gen_address_type                   OriginalUncompressedPictureSourceAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES OriginalUncompressedPictureSourceMemoryAddressAttributes;
   __gen_address_type                   StreamOutDataDestinationAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES StreamOutDataDestinationMemoryAddressAttributes;
   __gen_address_type                   DecodedPictureStatusBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES DecodedPictureStatusBufferMemoryAddressAttributes;
   __gen_address_type                   LCUILDBStreamOutBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES LCUILDBStreamOutBufferMemoryAddressAttributes;
   __gen_address_type                   CollocatedMVTemporalBufferAddress[8];
   struct GFX20_MEMORYADDRESSATTRIBUTES CollocatedMVTemporalBufferMemoryAddressAttributes;
   __gen_address_type                   VP9ProbabilityBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES VP9ProbabilityBufferMemoryAddressAttributes;
   __gen_address_type                   VP9SegmentIDBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES VP9SegmentIDBufferMemoryAddressAttributes;
   __gen_address_type                   VP9HVDLineRowStoreBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES VP9HVDLineRowStoreBufferMemoryAddressAttributes;
   __gen_address_type                   VP9HVDTileRowStoreBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES VP9HVDTileRowStoreBufferMemoryAddressAttributes;
   __gen_address_type                   SAOStreamOutDataDestinationBufferBaseAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES SAOStreamOutDataDestinationBufferMemoryAddressAttributes;
   __gen_address_type                   FrameStatisticsStreamOutDataDestinationBufferBaseAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES FrameStatisticsStreamOutDataDestinationBufferMemoryAddressAttributes;
   __gen_address_type                   SSESourcePixelRowStoreBufferBaseAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES SSESourcePixelRowStoreBufferMemoryAddressAttributesReadWrite;
   __gen_address_type                   HCPScalabilitySliceStateBufferBaseAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES HCPScalabilitySliceStateBufferMemoryAddressAttributes;
   __gen_address_type                   HCPScalabilityCABACDecodedSyntaxElementsBufferBaseAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES HCPScalabilityCABACDecodedSyntaxElementsBufferMemoryAddressAttributes;
   __gen_address_type                   MVUpperRightColumnStoreBufferBaseAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES MVUpperRightColumnStoreBufferMemoryAddressAttributes;
   __gen_address_type                   IntraPredictionUpperRightColumnStoreBufferBaseAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES IntraPredictionUpperRightColumnStoreBufferMemoryAddressAttributes;
   __gen_address_type                   IntraPredictionLeftReconColumnStoreBufferBaseAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES IntraPredictionLeftReconColumnStoreBufferMemoryAddressAttributes;
   __gen_address_type                   HCPScalabilityCABACDecodedSyntaxElementsBufferMaxAddress;
};

static inline __attribute__((always_inline)) void
GFX20_HCP_PIPE_BUF_ADDR_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                                   __attribute__((unused)) void * restrict dst,
                                   __attribute__((unused)) const struct GFX20_HCP_PIPE_BUF_ADDR_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcode, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   const uint64_t v1_address =
      __gen_address(data, &dw[1], values->DecodedPictureAddress, 0, 0, 63);
   dw[1] = v1_address;
   dw[2] = v1_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[3], &values->DecodedPictureMemoryAddressAttributes);

   const uint64_t v4_address =
      __gen_address(data, &dw[4], values->DeblockingFilterLineBufferAddress, 0, 0, 63);
   dw[4] = v4_address;
   dw[5] = v4_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[6], &values->DeblockingFilterLineBufferMemoryAddressAttributes);

   const uint64_t v7_address =
      __gen_address(data, &dw[7], values->DeblockingFilterTileLineBufferAddress, 0, 0, 63);
   dw[7] = v7_address;
   dw[8] = v7_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[9], &values->DeblockingFilterTileLineBufferMemoryAddressAttributes);

   const uint64_t v10_address =
      __gen_address(data, &dw[10], values->DeblockingFilterTileColumnBufferAddress, 0, 0, 63);
   dw[10] = v10_address;
   dw[11] = v10_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[12], &values->DeblockingFilterTileColumnBufferMemoryAddressAttributes);

   const uint64_t v13_address =
      __gen_address(data, &dw[13], values->MetadataLineBufferAddress, 0, 0, 63);
   dw[13] = v13_address;
   dw[14] = v13_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[15], &values->MetadataLineBufferMemoryAddressAttributes);

   const uint64_t v16_address =
      __gen_address(data, &dw[16], values->MetadataTileLineBufferAddress, 0, 0, 63);
   dw[16] = v16_address;
   dw[17] = v16_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[18], &values->MetadataTileLineBufferMemoryAddressAttributes);

   const uint64_t v19_address =
      __gen_address(data, &dw[19], values->MetadataTileColumnBufferAddress, 0, 0, 63);
   dw[19] = v19_address;
   dw[20] = v19_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[21], &values->MetadataTileColumnBufferMemoryAddressAttributes);

   const uint64_t v22_address =
      __gen_address(data, &dw[22], values->SAOLineBufferAddress, 0, 0, 63);
   dw[22] = v22_address;
   dw[23] = v22_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[24], &values->SAOLineBufferMemoryAddressAttributes);

   const uint64_t v25_address =
      __gen_address(data, &dw[25], values->SAOTileLineBufferAddress, 0, 0, 63);
   dw[25] = v25_address;
   dw[26] = v25_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[27], &values->SAOTileLineBufferMemoryAddressAttributes);

   const uint64_t v28_address =
      __gen_address(data, &dw[28], values->SAOTileColumnBufferAddress, 0, 0, 63);
   dw[28] = v28_address;
   dw[29] = v28_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[30], &values->SAOTileColumnBufferMemoryAddressAttributes);

   const uint64_t v31_address =
      __gen_address(data, &dw[31], values->CurrentMVTemporalBufferAddress, 0, 0, 63);
   dw[31] = v31_address;
   dw[32] = v31_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[33], &values->CurrentMVTemporalBufferMemoryAddressAttributes);

   dw[34] = 0;

   dw[35] = 0;

   dw[36] = 0;

   const uint64_t v37_address =
      __gen_address(data, &dw[37], values->ReferencePictureAddress[0], 0, 0, 63);
   dw[37] = v37_address;
   dw[38] = v37_address >> 32;

   const uint64_t v39_address =
      __gen_address(data, &dw[39], values->ReferencePictureAddress[1], 0, 0, 63);
   dw[39] = v39_address;
   dw[40] = v39_address >> 32;

   const uint64_t v41_address =
      __gen_address(data, &dw[41], values->ReferencePictureAddress[2], 0, 0, 63);
   dw[41] = v41_address;
   dw[42] = v41_address >> 32;

   const uint64_t v43_address =
      __gen_address(data, &dw[43], values->ReferencePictureAddress[3], 0, 0, 63);
   dw[43] = v43_address;
   dw[44] = v43_address >> 32;

   const uint64_t v45_address =
      __gen_address(data, &dw[45], values->ReferencePictureAddress[4], 0, 0, 63);
   dw[45] = v45_address;
   dw[46] = v45_address >> 32;

   const uint64_t v47_address =
      __gen_address(data, &dw[47], values->ReferencePictureAddress[5], 0, 0, 63);
   dw[47] = v47_address;
   dw[48] = v47_address >> 32;

   const uint64_t v49_address =
      __gen_address(data, &dw[49], values->ReferencePictureAddress[6], 0, 0, 63);
   dw[49] = v49_address;
   dw[50] = v49_address >> 32;

   const uint64_t v51_address =
      __gen_address(data, &dw[51], values->ReferencePictureAddress[7], 0, 0, 63);
   dw[51] = v51_address;
   dw[52] = v51_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[53], &values->ReferencePictureMemoryAddressAttributes);

   const uint64_t v54_address =
      __gen_address(data, &dw[54], values->OriginalUncompressedPictureSourceAddress, 0, 0, 63);
   dw[54] = v54_address;
   dw[55] = v54_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[56], &values->OriginalUncompressedPictureSourceMemoryAddressAttributes);

   const uint64_t v57_address =
      __gen_address(data, &dw[57], values->StreamOutDataDestinationAddress, 0, 0, 63);
   dw[57] = v57_address;
   dw[58] = v57_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[59], &values->StreamOutDataDestinationMemoryAddressAttributes);

   const uint64_t v60_address =
      __gen_address(data, &dw[60], values->DecodedPictureStatusBufferAddress, 0, 0, 63);
   dw[60] = v60_address;
   dw[61] = v60_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[62], &values->DecodedPictureStatusBufferMemoryAddressAttributes);

   const uint64_t v63_address =
      __gen_address(data, &dw[63], values->LCUILDBStreamOutBufferAddress, 0, 0, 63);
   dw[63] = v63_address;
   dw[64] = v63_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[65], &values->LCUILDBStreamOutBufferMemoryAddressAttributes);

   const uint64_t v66_address =
      __gen_address(data, &dw[66], values->CollocatedMVTemporalBufferAddress[0], 0, 0, 63);
   dw[66] = v66_address;
   dw[67] = v66_address >> 32;

   const uint64_t v68_address =
      __gen_address(data, &dw[68], values->CollocatedMVTemporalBufferAddress[1], 0, 0, 63);
   dw[68] = v68_address;
   dw[69] = v68_address >> 32;

   const uint64_t v70_address =
      __gen_address(data, &dw[70], values->CollocatedMVTemporalBufferAddress[2], 0, 0, 63);
   dw[70] = v70_address;
   dw[71] = v70_address >> 32;

   const uint64_t v72_address =
      __gen_address(data, &dw[72], values->CollocatedMVTemporalBufferAddress[3], 0, 0, 63);
   dw[72] = v72_address;
   dw[73] = v72_address >> 32;

   const uint64_t v74_address =
      __gen_address(data, &dw[74], values->CollocatedMVTemporalBufferAddress[4], 0, 0, 63);
   dw[74] = v74_address;
   dw[75] = v74_address >> 32;

   const uint64_t v76_address =
      __gen_address(data, &dw[76], values->CollocatedMVTemporalBufferAddress[5], 0, 0, 63);
   dw[76] = v76_address;
   dw[77] = v76_address >> 32;

   const uint64_t v78_address =
      __gen_address(data, &dw[78], values->CollocatedMVTemporalBufferAddress[6], 0, 0, 63);
   dw[78] = v78_address;
   dw[79] = v78_address >> 32;

   const uint64_t v80_address =
      __gen_address(data, &dw[80], values->CollocatedMVTemporalBufferAddress[7], 0, 0, 63);
   dw[80] = v80_address;
   dw[81] = v80_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[82], &values->CollocatedMVTemporalBufferMemoryAddressAttributes);

   const uint64_t v83_address =
      __gen_address(data, &dw[83], values->VP9ProbabilityBufferAddress, 0, 0, 63);
   dw[83] = v83_address;
   dw[84] = v83_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[85], &values->VP9ProbabilityBufferMemoryAddressAttributes);

   const uint64_t v86_address =
      __gen_address(data, &dw[86], values->VP9SegmentIDBufferAddress, 0, 0, 63);
   dw[86] = v86_address;
   dw[87] = v86_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[88], &values->VP9SegmentIDBufferMemoryAddressAttributes);

   const uint64_t v89_address =
      __gen_address(data, &dw[89], values->VP9HVDLineRowStoreBufferAddress, 0, 0, 63);
   dw[89] = v89_address;
   dw[90] = v89_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[91], &values->VP9HVDLineRowStoreBufferMemoryAddressAttributes);

   const uint64_t v92_address =
      __gen_address(data, &dw[92], values->VP9HVDTileRowStoreBufferAddress, 0, 0, 63);
   dw[92] = v92_address;
   dw[93] = v92_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[94], &values->VP9HVDTileRowStoreBufferMemoryAddressAttributes);

   const uint64_t v95_address =
      __gen_address(data, &dw[95], values->SAOStreamOutDataDestinationBufferBaseAddress, 0, 0, 63);
   dw[95] = v95_address;
   dw[96] = v95_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[97], &values->SAOStreamOutDataDestinationBufferMemoryAddressAttributes);

   const uint64_t v98_address =
      __gen_address(data, &dw[98], values->FrameStatisticsStreamOutDataDestinationBufferBaseAddress, 0, 0, 63);
   dw[98] = v98_address;
   dw[99] = v98_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[100], &values->FrameStatisticsStreamOutDataDestinationBufferMemoryAddressAttributes);

   const uint64_t v101_address =
      __gen_address(data, &dw[101], values->SSESourcePixelRowStoreBufferBaseAddress, 0, 0, 63);
   dw[101] = v101_address;
   dw[102] = v101_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[103], &values->SSESourcePixelRowStoreBufferMemoryAddressAttributesReadWrite);

   const uint64_t v104_address =
      __gen_address(data, &dw[104], values->HCPScalabilitySliceStateBufferBaseAddress, 0, 0, 63);
   dw[104] = v104_address;
   dw[105] = v104_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[106], &values->HCPScalabilitySliceStateBufferMemoryAddressAttributes);

   const uint64_t v107_address =
      __gen_address(data, &dw[107], values->HCPScalabilityCABACDecodedSyntaxElementsBufferBaseAddress, 0, 0, 63);
   dw[107] = v107_address;
   dw[108] = v107_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[109], &values->HCPScalabilityCABACDecodedSyntaxElementsBufferMemoryAddressAttributes);

   const uint64_t v110_address =
      __gen_address(data, &dw[110], values->MVUpperRightColumnStoreBufferBaseAddress, 0, 0, 63);
   dw[110] = v110_address;
   dw[111] = v110_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[112], &values->MVUpperRightColumnStoreBufferMemoryAddressAttributes);

   const uint64_t v113_address =
      __gen_address(data, &dw[113], values->IntraPredictionUpperRightColumnStoreBufferBaseAddress, 0, 0, 63);
   dw[113] = v113_address;
   dw[114] = v113_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[115], &values->IntraPredictionUpperRightColumnStoreBufferMemoryAddressAttributes);

   const uint64_t v116_address =
      __gen_address(data, &dw[116], values->IntraPredictionLeftReconColumnStoreBufferBaseAddress, 0, 0, 63);
   dw[116] = v116_address;
   dw[117] = v116_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[118], &values->IntraPredictionLeftReconColumnStoreBufferMemoryAddressAttributes);

   const uint64_t v119_address =
      __gen_address(data, &dw[119], values->HCPScalabilityCABACDecodedSyntaxElementsBufferMaxAddress, 0, 0, 63);
   dw[119] = v119_address;
   dw[120] = v119_address >> 32;
}

#define GFX20_HCP_PIPE_MODE_SELECT_length      7
#define GFX20_HCP_PIPE_MODE_SELECT_length_bias      2
#define GFX20_HCP_PIPE_MODE_SELECT_header       \
   .DWordLength                         =      5,  \
   .SubOpcode                           =      0,  \
   .MediaCommandOpcode                  =      7,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_HCP_PIPE_MODE_SELECT {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcode;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             CodecSelect;
#define Decode                                   0
#define Encode                                   1
   bool                                 DeblockerStreamOutEnable;
   bool                                 PAKPipelineStreamOutEnable;
   bool                                 PicStatusErrorReportEnable;
   uint32_t                             CodecStandardSelect;
#define HEVC                                     0
#define VP9                                      1
   bool                                 AdvancedRateControlEnable;
   uint32_t                             VDEncMode;
#define VM_MBEncMode                             0
#define VM_VDEncMode                             1
   bool                                 RDOQEnable;
   bool                                 PAKFrameLevelStreamOutEnable;
   uint32_t                             MultiEngineMode;
   uint32_t                             PipeWorkingMode;
#define LegacyDecoderEncoderMode                 0
#define CABACFEOnlyDecodeMode                    1
#define DecoderBEOnlyorEncoderMode               2
   uint32_t                             MediaSoftResetCounter;
   uint32_t                             PicStatusErrorReportID;
};

static inline __attribute__((always_inline)) void
GFX20_HCP_PIPE_MODE_SELECT_pack(__attribute__((unused)) __gen_user_data *data,
                                __attribute__((unused)) void * restrict dst,
                                __attribute__((unused)) const struct GFX20_HCP_PIPE_MODE_SELECT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcode, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->CodecSelect, 0, 0) |
      util_bitpack_uint(values->DeblockerStreamOutEnable, 1, 1) |
      util_bitpack_uint(values->PAKPipelineStreamOutEnable, 2, 2) |
      util_bitpack_uint(values->PicStatusErrorReportEnable, 3, 3) |
      util_bitpack_uint(values->CodecStandardSelect, 5, 7) |
      util_bitpack_uint(values->AdvancedRateControlEnable, 9, 9) |
      util_bitpack_uint(values->VDEncMode, 10, 10) |
      util_bitpack_uint(values->RDOQEnable, 11, 11) |
      util_bitpack_uint(values->PAKFrameLevelStreamOutEnable, 12, 12) |
      util_bitpack_uint(values->MultiEngineMode, 13, 14) |
      util_bitpack_uint(values->PipeWorkingMode, 15, 16);

   dw[2] =
      util_bitpack_uint(values->MediaSoftResetCounter, 0, 31);

   dw[3] =
      util_bitpack_uint(values->PicStatusErrorReportID, 0, 31);

   dw[4] = 0;

   dw[5] = 0;

   dw[6] = 0;
}

#define GFX20_HCP_QM_STATE_length             18
#define GFX20_HCP_QM_STATE_length_bias         2
#define GFX20_HCP_QM_STATE_header               \
   .DWordLength                         =     16,  \
   .SubOpcode                           =      4,  \
   .MediaCommandOpcode                  =      7,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_HCP_QM_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcode;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             PredictionType;
#define Intra                                    0
#define Inter                                    1
   uint32_t                             SizeID;
#define _4x4                                     0
#define _8x8                                     1
#define _16x16                                   2
#define _32x32                                   3
   uint32_t                             ColorComponent;
#define Luma                                     0
#define ChromaCb                                 1
#define ChromaCr                                 2
   uint32_t                             DCCoefficient;
   uint32_t                             QuantizerMatrix8x8[64];
};

static inline __attribute__((always_inline)) void
GFX20_HCP_QM_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                        __attribute__((unused)) void * restrict dst,
                        __attribute__((unused)) const struct GFX20_HCP_QM_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcode, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->PredictionType, 0, 0) |
      util_bitpack_uint(values->SizeID, 1, 2) |
      util_bitpack_uint(values->ColorComponent, 3, 4) |
      util_bitpack_uint(values->DCCoefficient, 5, 12);

   dw[2] =
      util_bitpack_uint(values->QuantizerMatrix8x8[0], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[1], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[2], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[3], 24, 31);

   dw[3] =
      util_bitpack_uint(values->QuantizerMatrix8x8[4], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[5], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[6], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[7], 24, 31);

   dw[4] =
      util_bitpack_uint(values->QuantizerMatrix8x8[8], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[9], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[10], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[11], 24, 31);

   dw[5] =
      util_bitpack_uint(values->QuantizerMatrix8x8[12], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[13], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[14], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[15], 24, 31);

   dw[6] =
      util_bitpack_uint(values->QuantizerMatrix8x8[16], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[17], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[18], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[19], 24, 31);

   dw[7] =
      util_bitpack_uint(values->QuantizerMatrix8x8[20], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[21], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[22], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[23], 24, 31);

   dw[8] =
      util_bitpack_uint(values->QuantizerMatrix8x8[24], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[25], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[26], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[27], 24, 31);

   dw[9] =
      util_bitpack_uint(values->QuantizerMatrix8x8[28], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[29], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[30], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[31], 24, 31);

   dw[10] =
      util_bitpack_uint(values->QuantizerMatrix8x8[32], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[33], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[34], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[35], 24, 31);

   dw[11] =
      util_bitpack_uint(values->QuantizerMatrix8x8[36], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[37], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[38], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[39], 24, 31);

   dw[12] =
      util_bitpack_uint(values->QuantizerMatrix8x8[40], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[41], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[42], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[43], 24, 31);

   dw[13] =
      util_bitpack_uint(values->QuantizerMatrix8x8[44], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[45], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[46], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[47], 24, 31);

   dw[14] =
      util_bitpack_uint(values->QuantizerMatrix8x8[48], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[49], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[50], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[51], 24, 31);

   dw[15] =
      util_bitpack_uint(values->QuantizerMatrix8x8[52], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[53], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[54], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[55], 24, 31);

   dw[16] =
      util_bitpack_uint(values->QuantizerMatrix8x8[56], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[57], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[58], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[59], 24, 31);

   dw[17] =
      util_bitpack_uint(values->QuantizerMatrix8x8[60], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[61], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[62], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[63], 24, 31);
}

#define GFX20_HCP_RDOQ_STATE_length            9
#define GFX20_HCP_RDOQ_STATE_length_bias       2
#define GFX20_HCP_RDOQ_STATE_header             \
   .SubOpcode                           =     21,  \
   .MediaCommandOpcode                  =      7,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_HCP_RDOQ_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcode;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   bool                                 IntraRDOQ;
   bool                                 InterRDOQ;
   uint32_t                             LambdaIntraLuma[26];
   uint32_t                             LambdaIntraChroma[26];
   uint32_t                             LambdaInterLuma[26];
   uint32_t                             LambdaInterChroma[26];
};

static inline __attribute__((always_inline)) void
GFX20_HCP_RDOQ_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                          __attribute__((unused)) void * restrict dst,
                          __attribute__((unused)) const struct GFX20_HCP_RDOQ_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcode, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->IntraRDOQ, 0, 0) |
      util_bitpack_uint(values->InterRDOQ, 1, 1);

   dw[2] =
      util_bitpack_uint(values->LambdaIntraLuma[0], 0, 15) |
      util_bitpack_uint(values->LambdaIntraLuma[1], 16, 31);

   dw[3] =
      util_bitpack_uint(values->LambdaIntraLuma[2], 0, 15) |
      util_bitpack_uint(values->LambdaIntraLuma[3], 16, 31);

   dw[4] =
      util_bitpack_uint(values->LambdaIntraLuma[4], 0, 15) |
      util_bitpack_uint(values->LambdaIntraLuma[5], 16, 31);

   dw[5] =
      util_bitpack_uint(values->LambdaIntraLuma[6], 0, 15) |
      util_bitpack_uint(values->LambdaIntraLuma[7], 16, 31);

   dw[6] =
      util_bitpack_uint(values->LambdaIntraLuma[8], 0, 15) |
      util_bitpack_uint(values->LambdaIntraLuma[9], 16, 31);

   dw[7] =
      util_bitpack_uint(values->LambdaIntraLuma[10], 0, 15) |
      util_bitpack_uint(values->LambdaIntraLuma[11], 16, 31);

   dw[8] =
      util_bitpack_uint(values->LambdaIntraLuma[12], 0, 15) |
      util_bitpack_uint(values->LambdaIntraLuma[13], 16, 31);
}

#define GFX20_HCP_REF_IDX_STATE_length        18
#define GFX20_HCP_REF_IDX_STATE_length_bias      2
#define GFX20_HCP_REF_IDX_STATE_header          \
   .DWordLength                         =     16,  \
   .SubOpcode                           =     18,  \
   .MediaCommandOpcode                  =      7,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_HCP_REF_IDX_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcode;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             ReferencePictureListSelect;
   uint32_t                             NumberofReferenceIndexesActive;
   struct GFX20_HCP_REF_LIST_ENTRY      ReferenceListEntry[16];
};

static inline __attribute__((always_inline)) void
GFX20_HCP_REF_IDX_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                             __attribute__((unused)) void * restrict dst,
                             __attribute__((unused)) const struct GFX20_HCP_REF_IDX_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcode, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->ReferencePictureListSelect, 0, 0) |
      util_bitpack_uint(values->NumberofReferenceIndexesActive, 1, 4);

   GFX20_HCP_REF_LIST_ENTRY_pack(data, &dw[2], &values->ReferenceListEntry[0]);

   GFX20_HCP_REF_LIST_ENTRY_pack(data, &dw[3], &values->ReferenceListEntry[1]);

   GFX20_HCP_REF_LIST_ENTRY_pack(data, &dw[4], &values->ReferenceListEntry[2]);

   GFX20_HCP_REF_LIST_ENTRY_pack(data, &dw[5], &values->ReferenceListEntry[3]);

   GFX20_HCP_REF_LIST_ENTRY_pack(data, &dw[6], &values->ReferenceListEntry[4]);

   GFX20_HCP_REF_LIST_ENTRY_pack(data, &dw[7], &values->ReferenceListEntry[5]);

   GFX20_HCP_REF_LIST_ENTRY_pack(data, &dw[8], &values->ReferenceListEntry[6]);

   GFX20_HCP_REF_LIST_ENTRY_pack(data, &dw[9], &values->ReferenceListEntry[7]);

   GFX20_HCP_REF_LIST_ENTRY_pack(data, &dw[10], &values->ReferenceListEntry[8]);

   GFX20_HCP_REF_LIST_ENTRY_pack(data, &dw[11], &values->ReferenceListEntry[9]);

   GFX20_HCP_REF_LIST_ENTRY_pack(data, &dw[12], &values->ReferenceListEntry[10]);

   GFX20_HCP_REF_LIST_ENTRY_pack(data, &dw[13], &values->ReferenceListEntry[11]);

   GFX20_HCP_REF_LIST_ENTRY_pack(data, &dw[14], &values->ReferenceListEntry[12]);

   GFX20_HCP_REF_LIST_ENTRY_pack(data, &dw[15], &values->ReferenceListEntry[13]);

   GFX20_HCP_REF_LIST_ENTRY_pack(data, &dw[16], &values->ReferenceListEntry[14]);

   GFX20_HCP_REF_LIST_ENTRY_pack(data, &dw[17], &values->ReferenceListEntry[15]);
}

#define GFX20_HCP_SLICE_STATE_length          13
#define GFX20_HCP_SLICE_STATE_length_bias      2
#define GFX20_HCP_SLICE_STATE_header            \
   .DWordLength                         =     11,  \
   .SubOpcode                           =     20,  \
   .MediaCommandOpcode                  =      7,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_HCP_SLICE_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcode;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             SliceHorizontalPosition;
   uint32_t                             SliceVerticalPosition;
   uint32_t                             NextSliceHorizontalPosition;
   uint32_t                             NextSliceVerticalPosition;
   uint32_t                             SliceType;
#define HCP_ST_BSlice                            0
#define HCP_ST_PSlice                            1
#define HCP_ST_ISlice                            2
   bool                                 LastSlice;
   uint32_t                             SliceQPSign;
   bool                                 DependentSlice;
   bool                                 SliceTemporalMVPEnable;
   uint32_t                             SliceQP;
   int32_t                              SliceCbQPOffset;
#define _12                                      20
#define _11                                      21
#define _10                                      22
#define _9                                       23
#define _8                                       24
#define _7                                       25
#define _6                                       26
#define _5                                       27
#define _4                                       28
#define _3                                       29
#define _2                                       30
#define _1                                       31
   int32_t                              SliceCrQPOffset;
#define _12                                      20
#define _11                                      21
#define _10                                      22
#define _9                                       23
#define _8                                       24
#define _7                                       25
#define _6                                       26
#define _5                                       27
#define _4                                       28
#define _3                                       29
#define _2                                       30
#define _1                                       31
   bool                                 IntraRefFetchDisable;
   bool                                 CUChromaQPOffsetEnable;
   uint32_t                             LastSliceofTile;
   bool                                 SliceHeaderDisableDeblockingFilter;
   int32_t                              SliceTCOffsetDiv2;
   int32_t                              SliceBetaOffsetDiv2;
   bool                                 SliceLoopFilterEnable;
   bool                                 SliceSAOChroma;
   bool                                 SliceSAOLuma;
   bool                                 MVDL1Zero;
   bool                                 LowDelay;
   bool                                 CollocatedFromL0;
   uint32_t                             Log2WeightDenominatorChroma;
   uint32_t                             Log2WeightDenominatorLuma;
   bool                                 CABACInit;
   uint32_t                             MaxMergeIndex;
   uint32_t                             CollocatedMVTemporalBufferIndex;
   uint32_t                             SliceHeaderLength;
   uint32_t                             RoundIntra;
#define _132                                     0
#define _232                                     1
#define _332                                     2
#define _432                                     3
#define _532                                     4
#define _632                                     5
#define _732                                     6
#define _832                                     7
#define _932                                     8
#define _1032                                    9
#define _1132                                    10
#define _1232                                    11
#define _1332                                    12
#define _1432                                    13
#define _1532                                    14
#define _1632                                    15
   uint32_t                             RoundInter;
#define _132                                     0
#define _232                                     1
#define _332                                     2
#define _432                                     3
#define _532                                     4
#define _632                                     5
#define _732                                     6
#define _832                                     7
#define _932                                     8
#define _1032                                    9
#define _1132                                    10
#define _1232                                    11
#define _1332                                    12
#define _1432                                    13
#define _1532                                    14
#define _1632                                    15
   bool                                 CABACZeroWordInsertionEnable;
   bool                                 EmulationByteSliceInsertEnable;
   bool                                 TailInsertionPresent;
   bool                                 SliceDataInsertionPresent;
   bool                                 HeaderInsertionPresent;
   uint64_t                             IndirectPAKBSEDataStartOffset;
   uint32_t                             TransformSkipLambda;
   bool                                 ForceSAOParametersToZero;
   uint32_t                             TransformSkipNumberofZeroCoeffsFactor0;
   uint32_t                             TransformSkipNumberofNonZeroCoeffsFactor0;
   uint32_t                             TransformSkipNumberofZeroCoeffsFactor1;
   uint32_t                             TransformSkipNumberofNonZeroCoeffsFactor1;
   uint32_t                             OriginalSliceStartCtbX;
   uint32_t                             OriginalSliceStartCtbY;
   uint32_t                             SliceActCrQPoffset;
   uint32_t                             SliceActCbQPoffset;
   uint32_t                             SliceActYQPoffset;
   uint32_t                             UseIntegerMVflag;
};

static inline __attribute__((always_inline)) void
GFX20_HCP_SLICE_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                           __attribute__((unused)) void * restrict dst,
                           __attribute__((unused)) const struct GFX20_HCP_SLICE_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcode, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->SliceHorizontalPosition, 0, 9) |
      util_bitpack_uint(values->SliceVerticalPosition, 16, 25);

   dw[2] =
      util_bitpack_uint(values->NextSliceHorizontalPosition, 0, 9) |
      util_bitpack_uint(values->NextSliceVerticalPosition, 16, 26);

   dw[3] =
      util_bitpack_uint(values->SliceType, 0, 1) |
      util_bitpack_uint(values->LastSlice, 2, 2) |
      util_bitpack_uint(values->SliceQPSign, 3, 3) |
      util_bitpack_uint(values->DependentSlice, 4, 4) |
      util_bitpack_uint(values->SliceTemporalMVPEnable, 5, 5) |
      util_bitpack_uint(values->SliceQP, 6, 11) |
      util_bitpack_sint(values->SliceCbQPOffset, 12, 16) |
      util_bitpack_sint(values->SliceCrQPOffset, 17, 21) |
      util_bitpack_uint(values->IntraRefFetchDisable, 22, 22) |
      util_bitpack_uint(values->CUChromaQPOffsetEnable, 23, 23) |
      util_bitpack_uint(values->LastSliceofTile, 24, 24);

   dw[4] =
      util_bitpack_uint(values->SliceHeaderDisableDeblockingFilter, 0, 0) |
      util_bitpack_sint(values->SliceTCOffsetDiv2, 1, 4) |
      util_bitpack_sint(values->SliceBetaOffsetDiv2, 5, 8) |
      util_bitpack_uint(values->SliceLoopFilterEnable, 10, 10) |
      util_bitpack_uint(values->SliceSAOChroma, 11, 11) |
      util_bitpack_uint(values->SliceSAOLuma, 12, 12) |
      util_bitpack_uint(values->MVDL1Zero, 13, 13) |
      util_bitpack_uint(values->LowDelay, 14, 14) |
      util_bitpack_uint(values->CollocatedFromL0, 15, 15) |
      util_bitpack_uint(values->Log2WeightDenominatorChroma, 16, 18) |
      util_bitpack_uint(values->Log2WeightDenominatorLuma, 19, 21) |
      util_bitpack_uint(values->CABACInit, 22, 22) |
      util_bitpack_uint(values->MaxMergeIndex, 23, 25) |
      util_bitpack_uint(values->CollocatedMVTemporalBufferIndex, 26, 28);

   dw[5] =
      util_bitpack_uint(values->SliceHeaderLength, 0, 15);

   dw[6] =
      util_bitpack_uint(values->RoundIntra, 20, 23) |
      util_bitpack_uint(values->RoundInter, 26, 29);

   dw[7] =
      util_bitpack_uint(values->CABACZeroWordInsertionEnable, 1, 1) |
      util_bitpack_uint(values->EmulationByteSliceInsertEnable, 2, 2) |
      util_bitpack_uint(values->TailInsertionPresent, 8, 8) |
      util_bitpack_uint(values->SliceDataInsertionPresent, 9, 9) |
      util_bitpack_uint(values->HeaderInsertionPresent, 10, 10);

   dw[8] =
      __gen_offset(values->IndirectPAKBSEDataStartOffset, 6, 28);

   dw[9] =
      util_bitpack_uint(values->TransformSkipLambda, 0, 15) |
      util_bitpack_uint(values->ForceSAOParametersToZero, 31, 31);

   dw[10] =
      util_bitpack_uint(values->TransformSkipNumberofZeroCoeffsFactor0, 0, 7) |
      util_bitpack_uint(values->TransformSkipNumberofNonZeroCoeffsFactor0, 8, 15) |
      util_bitpack_uint(values->TransformSkipNumberofZeroCoeffsFactor1, 16, 23) |
      util_bitpack_uint(values->TransformSkipNumberofNonZeroCoeffsFactor1, 24, 31);

   dw[11] =
      util_bitpack_uint(values->OriginalSliceStartCtbX, 0, 9) |
      util_bitpack_uint(values->OriginalSliceStartCtbY, 16, 25);

   dw[12] =
      util_bitpack_uint(values->SliceActCrQPoffset, 0, 5) |
      util_bitpack_uint(values->SliceActCbQPoffset, 6, 11) |
      util_bitpack_uint(values->SliceActYQPoffset, 12, 17) |
      util_bitpack_uint(values->UseIntegerMVflag, 31, 31);
}

#define GFX20_HCP_SURFACE_STATE_length         5
#define GFX20_HCP_SURFACE_STATE_length_bias      2
#define GFX20_HCP_SURFACE_STATE_header          \
   .DWordLength                         =      3,  \
   .SubOpcode                           =      1,  \
   .MediaCommandOpcode                  =      7,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_HCP_SURFACE_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcode;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             SurfacePitch;
   uint32_t                             SurfaceID;
#define HCP_CurrentDecodedPicture                0
#define HCP_SourceInputPicture                   1
#define HCP_PrevReferencePicture                 2
#define HCP_GoldenReferencePicture               3
#define HCP_AltRefReferencePicture               4
#define HCP_ReferencePicture                     5
   uint32_t                             YOffsetforUCb;
   uint32_t                             SurfaceFormat;
#define YUY2                                     0
#define RGB_8                                    1
#define AYUV4444                                 2
#define P010Variant                              3
#define PLANAR_420_8                             4
#define YCRCB_SwapY                              5
#define YCRCB_SwapUV                             6
#define YCRCB_SwapUVY                            7
#define Y216Y210                                 8
#define RGB_10                                   9
#define Y410                                     10
#define NV21Planar_420_8                         11
#define Y416                                     12
#define P010                                     13
#define P016                                     14
#define Y216Variant                              17
#define Y416Variant                              18
#define YUY2Variant                              19
#define AYUV4444Variant                          20
   uint32_t                             DefaultAlphaValue;
   uint32_t                             YOffsetforVCr;
};

static inline __attribute__((always_inline)) void
GFX20_HCP_SURFACE_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                             __attribute__((unused)) void * restrict dst,
                             __attribute__((unused)) const struct GFX20_HCP_SURFACE_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcode, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->SurfacePitch, 0, 16) |
      util_bitpack_uint(values->SurfaceID, 28, 31);

   dw[2] =
      util_bitpack_uint(values->YOffsetforUCb, 0, 14) |
      util_bitpack_uint(values->SurfaceFormat, 27, 31);

   dw[3] =
      util_bitpack_uint(values->DefaultAlphaValue, 0, 15) |
      util_bitpack_uint(values->YOffsetforVCr, 16, 31);

   dw[4] = 0;
}

#define GFX20_HCP_TILE_CODING_length          14
#define GFX20_HCP_TILE_CODING_length_bias      1
#define GFX20_HCP_TILE_CODING_header            \
   .DWordLength                         =     13,  \
   .SubOpcode                           =     21,  \
   .MediaCommandOpcode                  =      7,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_HCP_TILE_CODING {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcode;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             TileColumnPosition;
   uint32_t                             TileRowPosition;
   bool                                 LastTileofColumn;
   uint32_t                             TileHeightInMinimumCodingBlockSize;
   uint32_t                             TileWidthInMinimumCodingBlockSize;
   uint32_t                             SAOParameterOffset;
   uint32_t                             BitstreamByteOffset;
   uint32_t                             PAKFrameStatisticsOffset;
   uint32_t                             CULevelStreamOutOffset;
   uint32_t                             SliceSizeStreamOutOffset;
   uint32_t                             CURecordOffset;
   uint32_t                             SSERowStoreOffset;
   uint32_t                             SAORowStoreOffset;
   uint32_t                             TileSizeStreamOutOffset;
   uint32_t                             VP9ProbabilityCounterStreamOutOffset;
   __gen_address_type                   HCPScalabilitySynchronizeBufferBaseAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES HCPScalabilitySynchronizeBufferAttributes;
};

static inline __attribute__((always_inline)) void
GFX20_HCP_TILE_CODING_pack(__attribute__((unused)) __gen_user_data *data,
                           __attribute__((unused)) void * restrict dst,
                           __attribute__((unused)) const struct GFX20_HCP_TILE_CODING * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcode, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] = 0;

   dw[2] =
      util_bitpack_uint(values->TileColumnPosition, 0, 9) |
      util_bitpack_uint(values->TileRowPosition, 16, 25) |
      util_bitpack_uint(values->LastTileofColumn, 31, 31);

   dw[3] =
      util_bitpack_uint(values->TileHeightInMinimumCodingBlockSize, 0, 10) |
      util_bitpack_uint(values->TileWidthInMinimumCodingBlockSize, 16, 26);

   dw[4] =
      util_bitpack_uint(values->SAOParameterOffset, 0, 31) |
      util_bitpack_uint(values->BitstreamByteOffset, 6, 31);

   dw[5] =
      util_bitpack_uint(values->PAKFrameStatisticsOffset, 6, 31);

   dw[6] =
      util_bitpack_uint(values->CULevelStreamOutOffset, 6, 31);

   dw[7] =
      util_bitpack_uint(values->SliceSizeStreamOutOffset, 6, 31);

   dw[8] =
      util_bitpack_uint(values->CURecordOffset, 6, 31);

   dw[9] =
      util_bitpack_uint(values->SSERowStoreOffset, 6, 31);

   dw[10] =
      util_bitpack_uint(values->SAORowStoreOffset, 6, 31);

   dw[11] =
      util_bitpack_uint(values->TileSizeStreamOutOffset, 6, 31);

   dw[12] =
      util_bitpack_uint(values->VP9ProbabilityCounterStreamOutOffset, 6, 31);

   const uint64_t v13_address =
      __gen_address(data, &dw[13], values->HCPScalabilitySynchronizeBufferBaseAddress, 0, 0, 63);
   dw[13] = v13_address;
   dw[14] = v13_address >> 32;
}

#define GFX20_HCP_TILE_STATE_length           17
#define GFX20_HCP_TILE_STATE_length_bias       2
#define GFX20_HCP_TILE_STATE_header             \
   .DWordLength                         =     15,  \
   .MediaInstructionCommand             =     17,  \
   .MediaCommandOpcode                  =      7,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_HCP_TILE_STATE {
   uint32_t                             DWordLength;
   uint32_t                             MediaInstructionCommand;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             NumberofTileRows;
   uint32_t                             NumberofTileColumns;
   struct GFX20_HCP_TILE_POSITION_IN_CTB ColumnPosition[5];
   struct GFX20_HCP_TILE_POSITION_IN_CTB Rowposition[6];
   struct GFX20_HCP_TILE_POSITION_IN_CTB_MSB CtbColumnPositionMSB;
   struct GFX20_HCP_TILE_POSITION_IN_CTB_MSB CtbRowPositionMSB;
};

static inline __attribute__((always_inline)) void
GFX20_HCP_TILE_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                          __attribute__((unused)) void * restrict dst,
                          __attribute__((unused)) const struct GFX20_HCP_TILE_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->MediaInstructionCommand, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->NumberofTileRows, 0, 4) |
      util_bitpack_uint(values->NumberofTileColumns, 5, 9);

   GFX20_HCP_TILE_POSITION_IN_CTB_pack(data, &dw[2], &values->ColumnPosition[0]);

   GFX20_HCP_TILE_POSITION_IN_CTB_pack(data, &dw[3], &values->ColumnPosition[1]);

   GFX20_HCP_TILE_POSITION_IN_CTB_pack(data, &dw[4], &values->ColumnPosition[2]);

   GFX20_HCP_TILE_POSITION_IN_CTB_pack(data, &dw[5], &values->ColumnPosition[3]);

   GFX20_HCP_TILE_POSITION_IN_CTB_pack(data, &dw[6], &values->ColumnPosition[4]);

   GFX20_HCP_TILE_POSITION_IN_CTB_pack(data, &dw[7], &values->Rowposition[0]);

   GFX20_HCP_TILE_POSITION_IN_CTB_pack(data, &dw[8], &values->Rowposition[1]);

   GFX20_HCP_TILE_POSITION_IN_CTB_pack(data, &dw[9], &values->Rowposition[2]);

   GFX20_HCP_TILE_POSITION_IN_CTB_pack(data, &dw[10], &values->Rowposition[3]);

   GFX20_HCP_TILE_POSITION_IN_CTB_pack(data, &dw[11], &values->Rowposition[4]);

   GFX20_HCP_TILE_POSITION_IN_CTB_pack(data, &dw[12], &values->Rowposition[5]);

   GFX20_HCP_TILE_POSITION_IN_CTB_MSB_pack(data, &dw[13], &values->CtbColumnPositionMSB);

   GFX20_HCP_TILE_POSITION_IN_CTB_MSB_pack(data, &dw[15], &values->CtbRowPositionMSB);
}

#define GFX20_HCP_VP9_PAK_OBJECT_length        2
#define GFX20_HCP_VP9_PAK_OBJECT_length_bias      2
#define GFX20_HCP_VP9_PAK_OBJECT_header         \
   .SubOpcode                           =     53,  \
   .MediaCommandOpcode                  =      7,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_HCP_VP9_PAK_OBJECT {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcode;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             Split_coding_unit_flagx0y0;
   uint32_t                             CUCount;
   bool                                 LastSBofTile;
   uint32_t                             CurrentSBXAddress;
   uint32_t                             CurrentSBYAddress;
   uint32_t                             SSEClassID32x32_0;
   uint32_t                             SSEClassID32x32_1;
   uint32_t                             SSEClassID32x32_2;
   uint32_t                             SSEClassID32x32_3;
   bool                                 LCUForceZeroCoeff;
};

static inline __attribute__((always_inline)) void
GFX20_HCP_VP9_PAK_OBJECT_pack(__attribute__((unused)) __gen_user_data *data,
                              __attribute__((unused)) void * restrict dst,
                              __attribute__((unused)) const struct GFX20_HCP_VP9_PAK_OBJECT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcode, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->Split_coding_unit_flagx0y0, 0, 20) |
      util_bitpack_uint(values->CUCount, 24, 29) |
      util_bitpack_uint(values->LastSBofTile, 31, 31);
}

#define GFX20_HCP_VP9_PIC_STATE_length        42
#define GFX20_HCP_VP9_PIC_STATE_length_bias      2
#define GFX20_HCP_VP9_PIC_STATE_header          \
   .DWordLength                         =     40,  \
   .SubOpcode                           =     48,  \
   .MediaCommandOpcode                  =      7,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_HCP_VP9_PIC_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcode;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             FrameWidth;
   uint32_t                             FrameHeight;
   uint32_t                             FrameType;
#define VP9_KeyFrame                             0
#define VP9_InterFrame                           1
   bool                                 AdaptProbabilities;
   bool                                 IntraOnly;
   bool                                 AllowHiPrecisionMV;
   uint32_t                             MotionCompensationFilterType;
#define Eighttap                                 0
#define EighttapSmooth                           1
#define EighttapSharp                            2
#define Bilinear                                 3
#define Switchable                               4
   uint32_t                             ReferenceFrameSignBias;
   bool                                 UsePrevinFindMVReferences;
   uint32_t                             HybridPredictionMode;
   uint32_t                             SelectableTXMode;
   uint32_t                             LastFrameType;
#define VP9_KeyFrame                             0
#define VP9_NonKeyFrame                          1
   bool                                 RefreshFrameContextEnable;
   bool                                 ErrorResilientModeEnable;
   bool                                 FrameParallelDecodingModeEnable;
   uint32_t                             FilterLevel;
   uint32_t                             SharpnessLevel;
   bool                                 SegmentationEnable;
   bool                                 SegmentationUpdateMap;
   bool                                 SegmentationTemporalUpdate;
   bool                                 LosslessMode;
   bool                                 SegmentIDStreamOutEnable;
   bool                                 SegmentIDStreamInEnable;
   uint32_t                             Log2TileColumn;
#define _1TileColumn                             0
#define _2TileColumn                             1
#define _4TileColumn                             2
#define _8TileColumn                             3
#define _16TileColumn                            4
#define _32TileColumn                            5
#define _64TileColumn                            6
   uint32_t                             Log2TileRow;
#define _1TileRow                                0
#define _2TileRow                                1
#define _4TileRow                                2
   bool                                 SSEEnable;
   uint32_t                             ChromaSamplingFormat;
#define Format_420                               0
#define Format_422                               1
#define Format_444                               2
   uint32_t                             BitDepth;
#define _8bit                                    0
#define _10bit                                   2
#define _12bit                                   4
   uint32_t                             ProfileLevel;
#define Profile_0                                0
#define Profile_1                                1
#define Profile_2                                2
#define Profile_3                                3
   uint32_t                             VerticalScaleFactorforLAST;
   uint32_t                             HorizontalScaleFactorforLAST;
   uint32_t                             VerticalScaleFactorforGOLDEN;
   uint32_t                             HorizontalScaleFactorforGOLDEN;
   uint32_t                             VerticalScaleFactorforALTREF;
   uint32_t                             HorizontalScaleFactorforALTREF;
   uint32_t                             LastFrameWidth;
   uint32_t                             LastFrameHeight;
   uint32_t                             GoldenFrameWidth;
   uint32_t                             GoldenFrameHeight;
   uint32_t                             AltrefFrameWidth;
   uint32_t                             AltrefFrameHeight;
   uint32_t                             UncompressedHeaderLength;
   uint32_t                             FirstPartitionSize;
   bool                                 MotionCompScalingEnable;
   uint32_t                             CompressedHeaderBINcount;
   uint32_t                             LumaACQIndexDelta;
   bool                                 TailInsertionEnable;
   bool                                 HeaderInsertionEnable;
   int32_t                              ChromaACQIndexDelta;
   int32_t                              ChromaDCQIndexDelta;
   int32_t                              LumaDCQIndexDelta;
   int32_t                              LFRefDelta0;
   int32_t                              LFRefDelta1;
   int32_t                              LFRefDelta2;
   int32_t                              LFRefDelta3;
   int32_t                              LFModeDelta0;
   int32_t                              LFModeDelta1;
   uint32_t                             BitOffsetforLFRefDelta;
   uint32_t                             BitOffsetforLFModeDelta;
   uint32_t                             BitOffsetforQIndex;
   uint32_t                             BitOffsetforLFLevel;
   bool                                 NonFirstPass;
   bool                                 VDENCPAK_ONLYPASS;
   bool                                 FrameBitrateMaxReport;
   bool                                 FrameBitrateMinReport;
   uint32_t                             FrameBitrateMax;
   bool                                 FrameBitrateMaxUnit;
   uint32_t                             FrameBitrateMin;
   bool                                 FrameBitrateMinUnit;
   uint64_t                             FrameDeltaQIndexMax;
   uint32_t                             FrameDeltaQIndexMin;
   uint64_t                             FrameDeltaLFMax;
   uint32_t                             FrameDeltaLFMin;
   uint64_t                             FrameDeltaQIndexLFMaxRange;
   uint32_t                             FrameDeltaQIndexLFMinRange;
   uint32_t                             MinimumFrameSize;
   uint32_t                             MinimumFrameSizeUnits;
#define VP9_MFSU_4Kb                             0
#define VP9_MFSU_16Kb                            1
#define VP9_MFSU_Comaptibilitymode               2
#define VP9_MFSU_16bytes                         3
   uint32_t                             BitOffsetforFirstPartitionSize;
   uint32_t                             Class0_SSE_Threshold0;
   uint32_t                             Class0_SSE_Threshold1;
   uint32_t                             SSEThresholdForClass18[8];
};

static inline __attribute__((always_inline)) void
GFX20_HCP_VP9_PIC_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                             __attribute__((unused)) void * restrict dst,
                             __attribute__((unused)) const struct GFX20_HCP_VP9_PIC_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcode, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->FrameWidth, 0, 13) |
      util_bitpack_uint(values->FrameHeight, 16, 29);

   dw[2] =
      util_bitpack_uint(values->FrameType, 0, 0) |
      util_bitpack_uint(values->AdaptProbabilities, 1, 1) |
      util_bitpack_uint(values->IntraOnly, 2, 2) |
      util_bitpack_uint(values->AllowHiPrecisionMV, 3, 3) |
      util_bitpack_uint(values->MotionCompensationFilterType, 4, 6) |
      util_bitpack_uint(values->ReferenceFrameSignBias, 7, 9) |
      util_bitpack_uint(values->UsePrevinFindMVReferences, 10, 10) |
      util_bitpack_uint(values->HybridPredictionMode, 11, 11) |
      util_bitpack_uint(values->SelectableTXMode, 12, 12) |
      util_bitpack_uint(values->LastFrameType, 13, 13) |
      util_bitpack_uint(values->RefreshFrameContextEnable, 14, 14) |
      util_bitpack_uint(values->ErrorResilientModeEnable, 15, 15) |
      util_bitpack_uint(values->FrameParallelDecodingModeEnable, 16, 16) |
      util_bitpack_uint(values->FilterLevel, 17, 22) |
      util_bitpack_uint(values->SharpnessLevel, 23, 25) |
      util_bitpack_uint(values->SegmentationEnable, 26, 26) |
      util_bitpack_uint(values->SegmentationUpdateMap, 27, 27) |
      util_bitpack_uint(values->SegmentationTemporalUpdate, 28, 28) |
      util_bitpack_uint(values->LosslessMode, 29, 29) |
      util_bitpack_uint(values->SegmentIDStreamOutEnable, 30, 30) |
      util_bitpack_uint(values->SegmentIDStreamInEnable, 31, 31);

   dw[3] =
      util_bitpack_uint(values->Log2TileColumn, 0, 3) |
      util_bitpack_uint(values->Log2TileRow, 8, 9) |
      util_bitpack_uint(values->SSEEnable, 21, 21) |
      util_bitpack_uint(values->ChromaSamplingFormat, 22, 23) |
      util_bitpack_uint(values->BitDepth, 24, 27) |
      util_bitpack_uint(values->ProfileLevel, 28, 31);

   dw[4] =
      util_bitpack_uint(values->VerticalScaleFactorforLAST, 0, 15) |
      util_bitpack_uint(values->HorizontalScaleFactorforLAST, 16, 31);

   dw[5] =
      util_bitpack_uint(values->VerticalScaleFactorforGOLDEN, 0, 15) |
      util_bitpack_uint(values->HorizontalScaleFactorforGOLDEN, 16, 31);

   dw[6] =
      util_bitpack_uint(values->VerticalScaleFactorforALTREF, 0, 15) |
      util_bitpack_uint(values->HorizontalScaleFactorforALTREF, 16, 31);

   dw[7] =
      util_bitpack_uint(values->LastFrameWidth, 0, 13) |
      util_bitpack_uint(values->LastFrameHeight, 16, 29);

   dw[8] =
      util_bitpack_uint(values->GoldenFrameWidth, 0, 13) |
      util_bitpack_uint(values->GoldenFrameHeight, 16, 29);

   dw[9] =
      util_bitpack_uint(values->AltrefFrameWidth, 0, 13) |
      util_bitpack_uint(values->AltrefFrameHeight, 16, 29);

   dw[10] =
      util_bitpack_uint(values->UncompressedHeaderLength, 0, 7) |
      util_bitpack_uint(values->FirstPartitionSize, 16, 31);

   dw[11] =
      util_bitpack_uint(values->MotionCompScalingEnable, 1, 1);

   dw[12] = 0;

   dw[13] =
      util_bitpack_uint(values->CompressedHeaderBINcount, 0, 15) |
      util_bitpack_uint(values->LumaACQIndexDelta, 16, 23) |
      util_bitpack_uint(values->TailInsertionEnable, 24, 24) |
      util_bitpack_uint(values->HeaderInsertionEnable, 25, 25);

   dw[14] =
      util_bitpack_sint(values->ChromaACQIndexDelta, 0, 4) |
      util_bitpack_sint(values->ChromaDCQIndexDelta, 8, 12) |
      util_bitpack_sint(values->LumaDCQIndexDelta, 16, 20);

   dw[15] =
      util_bitpack_sint(values->LFRefDelta0, 0, 6) |
      util_bitpack_sint(values->LFRefDelta1, 8, 14) |
      util_bitpack_sint(values->LFRefDelta2, 16, 22) |
      util_bitpack_sint(values->LFRefDelta3, 24, 30);

   dw[16] =
      util_bitpack_sint(values->LFModeDelta0, 0, 6) |
      util_bitpack_sint(values->LFModeDelta1, 8, 14);

   dw[17] =
      util_bitpack_uint(values->BitOffsetforLFRefDelta, 0, 15) |
      util_bitpack_uint(values->BitOffsetforLFModeDelta, 16, 31);

   dw[18] =
      util_bitpack_uint(values->BitOffsetforQIndex, 0, 15) |
      util_bitpack_uint(values->BitOffsetforLFLevel, 16, 31);

   dw[19] =
      util_bitpack_uint(values->NonFirstPass, 16, 16) |
      util_bitpack_uint(values->VDENCPAK_ONLYPASS, 17, 17) |
      util_bitpack_uint(values->FrameBitrateMaxReport, 25, 25) |
      util_bitpack_uint(values->FrameBitrateMinReport, 26, 26);

   dw[20] =
      util_bitpack_uint(values->FrameBitrateMax, 0, 13) |
      util_bitpack_uint(values->FrameBitrateMaxUnit, 31, 31);

   dw[21] =
      util_bitpack_uint(values->FrameBitrateMin, 0, 13) |
      util_bitpack_uint(values->FrameBitrateMinUnit, 31, 31);

   const uint64_t v22 =
      util_bitpack_uint(values->FrameDeltaQIndexMax, 0, 63);
   dw[22] = v22;
   dw[23] = v22 >> 32;

   dw[24] =
      util_bitpack_uint(values->FrameDeltaQIndexMin, 0, 31);

   const uint64_t v25 =
      util_bitpack_uint(values->FrameDeltaLFMax, 0, 63);
   dw[25] = v25;
   dw[26] = v25 >> 32;

   dw[27] =
      util_bitpack_uint(values->FrameDeltaLFMin, 0, 31);

   const uint64_t v28 =
      util_bitpack_uint(values->FrameDeltaQIndexLFMaxRange, 0, 63);
   dw[28] = v28;
   dw[29] = v28 >> 32;

   dw[30] =
      util_bitpack_uint(values->FrameDeltaQIndexLFMinRange, 0, 31);

   dw[31] =
      util_bitpack_uint(values->MinimumFrameSize, 0, 15) |
      util_bitpack_uint(values->MinimumFrameSizeUnits, 30, 31);

   dw[32] =
      util_bitpack_uint(values->BitOffsetforFirstPartitionSize, 0, 15);

   dw[33] =
      util_bitpack_uint(values->Class0_SSE_Threshold0, 0, 15) |
      util_bitpack_uint(values->Class0_SSE_Threshold1, 16, 31);

   dw[34] =
      util_bitpack_uint(values->SSEThresholdForClass18[0], 0, 31);

   dw[35] =
      util_bitpack_uint(values->SSEThresholdForClass18[1], 0, 31);

   dw[36] =
      util_bitpack_uint(values->SSEThresholdForClass18[2], 0, 31);

   dw[37] =
      util_bitpack_uint(values->SSEThresholdForClass18[3], 0, 31);

   dw[38] =
      util_bitpack_uint(values->SSEThresholdForClass18[4], 0, 31);

   dw[39] =
      util_bitpack_uint(values->SSEThresholdForClass18[5], 0, 31);

   dw[40] =
      util_bitpack_uint(values->SSEThresholdForClass18[6], 0, 31);

   dw[41] =
      util_bitpack_uint(values->SSEThresholdForClass18[7], 0, 31);
}

#define GFX20_HCP_VP9_SEGMENT_STATE_length      8
#define GFX20_HCP_VP9_SEGMENT_STATE_length_bias      2
#define GFX20_HCP_VP9_SEGMENT_STATE_header      \
   .DWordLength                         =      6,  \
   .SubOpcode                           =     50,  \
   .MediaCommandOpcode                  =      7,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_HCP_VP9_SEGMENT_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcode;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             SegmentID;
   bool                                 SegmentSkipped;
   uint32_t                             SegmentReference;
   bool                                 SegmentReferenceEnable;
   uint32_t                             FilterLevelRef0Mode0;
   uint32_t                             FilterLevelRef0Mode1;
   uint32_t                             FilterLevelRef1Mode0;
   uint32_t                             FilterLevelRef1Mode1;
   uint32_t                             FilterLevelRef2Mode0;
   uint32_t                             FilterLevelRef2Mode1;
   uint32_t                             FilterLevelRef3Mode0;
   uint32_t                             FilterLevelRef3Mode1;
   uint32_t                             LumaDCQuantScale;
   uint32_t                             LumaACQuantScale;
   uint32_t                             ChromaDCQuantScale;
   uint32_t                             ChromaACQuantScale;
   int32_t                              SegmentQIndexDelta;
   int32_t                              SegmentLFLevelDelta;
};

static inline __attribute__((always_inline)) void
GFX20_HCP_VP9_SEGMENT_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                                 __attribute__((unused)) void * restrict dst,
                                 __attribute__((unused)) const struct GFX20_HCP_VP9_SEGMENT_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcode, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->SegmentID, 0, 2);

   dw[2] =
      util_bitpack_uint(values->SegmentSkipped, 0, 0) |
      util_bitpack_uint(values->SegmentReference, 1, 2) |
      util_bitpack_uint(values->SegmentReferenceEnable, 3, 3);

   dw[3] =
      util_bitpack_uint(values->FilterLevelRef0Mode0, 0, 5) |
      util_bitpack_uint(values->FilterLevelRef0Mode1, 8, 13) |
      util_bitpack_uint(values->FilterLevelRef1Mode0, 16, 21) |
      util_bitpack_uint(values->FilterLevelRef1Mode1, 24, 29);

   dw[4] =
      util_bitpack_uint(values->FilterLevelRef2Mode0, 0, 5) |
      util_bitpack_uint(values->FilterLevelRef2Mode1, 8, 13) |
      util_bitpack_uint(values->FilterLevelRef3Mode0, 16, 21) |
      util_bitpack_uint(values->FilterLevelRef3Mode1, 24, 29);

   dw[5] =
      util_bitpack_uint(values->LumaDCQuantScale, 0, 14) |
      util_bitpack_uint(values->LumaACQuantScale, 16, 30);

   dw[6] =
      util_bitpack_uint(values->ChromaDCQuantScale, 0, 14) |
      util_bitpack_uint(values->ChromaACQuantScale, 16, 30);

   dw[7] =
      util_bitpack_sint(values->SegmentQIndexDelta, 0, 8) |
      util_bitpack_sint(values->SegmentLFLevelDelta, 16, 22);
}

#define GFX20_HCP_WEIGHTOFFSET_STATE_length     42
#define GFX20_HCP_WEIGHTOFFSET_STATE_length_bias      2
#define GFX20_HCP_WEIGHTOFFSET_STATE_header     \
   .DWordLength                         =     40,  \
   .SubOpcode                           =     19,  \
   .MediaCommandOpcode                  =      7,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_HCP_WEIGHTOFFSET_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcode;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             ReferencePictureListSelect;
   struct GFX20_HCP_WEIGHTOFFSET_LUMA_ENTRY LumaOffsets[16];
   struct GFX20_HCP_WEIGHTOFFSET_CHROMA_ENTRY ChromaOffsets[16];
   struct GFX20_HCP_WEIGHTOFFSET_CHROMA_EXT_ENTRY ChromaOffsetsExt[8];
};

static inline __attribute__((always_inline)) void
GFX20_HCP_WEIGHTOFFSET_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                                  __attribute__((unused)) void * restrict dst,
                                  __attribute__((unused)) const struct GFX20_HCP_WEIGHTOFFSET_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcode, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->ReferencePictureListSelect, 0, 0);

   GFX20_HCP_WEIGHTOFFSET_LUMA_ENTRY_pack(data, &dw[2], &values->LumaOffsets[0]);

   GFX20_HCP_WEIGHTOFFSET_LUMA_ENTRY_pack(data, &dw[3], &values->LumaOffsets[1]);

   GFX20_HCP_WEIGHTOFFSET_LUMA_ENTRY_pack(data, &dw[4], &values->LumaOffsets[2]);

   GFX20_HCP_WEIGHTOFFSET_LUMA_ENTRY_pack(data, &dw[5], &values->LumaOffsets[3]);

   GFX20_HCP_WEIGHTOFFSET_LUMA_ENTRY_pack(data, &dw[6], &values->LumaOffsets[4]);

   GFX20_HCP_WEIGHTOFFSET_LUMA_ENTRY_pack(data, &dw[7], &values->LumaOffsets[5]);

   GFX20_HCP_WEIGHTOFFSET_LUMA_ENTRY_pack(data, &dw[8], &values->LumaOffsets[6]);

   GFX20_HCP_WEIGHTOFFSET_LUMA_ENTRY_pack(data, &dw[9], &values->LumaOffsets[7]);

   GFX20_HCP_WEIGHTOFFSET_LUMA_ENTRY_pack(data, &dw[10], &values->LumaOffsets[8]);

   GFX20_HCP_WEIGHTOFFSET_LUMA_ENTRY_pack(data, &dw[11], &values->LumaOffsets[9]);

   GFX20_HCP_WEIGHTOFFSET_LUMA_ENTRY_pack(data, &dw[12], &values->LumaOffsets[10]);

   GFX20_HCP_WEIGHTOFFSET_LUMA_ENTRY_pack(data, &dw[13], &values->LumaOffsets[11]);

   GFX20_HCP_WEIGHTOFFSET_LUMA_ENTRY_pack(data, &dw[14], &values->LumaOffsets[12]);

   GFX20_HCP_WEIGHTOFFSET_LUMA_ENTRY_pack(data, &dw[15], &values->LumaOffsets[13]);

   GFX20_HCP_WEIGHTOFFSET_LUMA_ENTRY_pack(data, &dw[16], &values->LumaOffsets[14]);

   GFX20_HCP_WEIGHTOFFSET_LUMA_ENTRY_pack(data, &dw[17], &values->LumaOffsets[15]);

   GFX20_HCP_WEIGHTOFFSET_CHROMA_ENTRY_pack(data, &dw[18], &values->ChromaOffsets[0]);

   GFX20_HCP_WEIGHTOFFSET_CHROMA_ENTRY_pack(data, &dw[19], &values->ChromaOffsets[1]);

   GFX20_HCP_WEIGHTOFFSET_CHROMA_ENTRY_pack(data, &dw[20], &values->ChromaOffsets[2]);

   GFX20_HCP_WEIGHTOFFSET_CHROMA_ENTRY_pack(data, &dw[21], &values->ChromaOffsets[3]);

   GFX20_HCP_WEIGHTOFFSET_CHROMA_ENTRY_pack(data, &dw[22], &values->ChromaOffsets[4]);

   GFX20_HCP_WEIGHTOFFSET_CHROMA_ENTRY_pack(data, &dw[23], &values->ChromaOffsets[5]);

   GFX20_HCP_WEIGHTOFFSET_CHROMA_ENTRY_pack(data, &dw[24], &values->ChromaOffsets[6]);

   GFX20_HCP_WEIGHTOFFSET_CHROMA_ENTRY_pack(data, &dw[25], &values->ChromaOffsets[7]);

   GFX20_HCP_WEIGHTOFFSET_CHROMA_ENTRY_pack(data, &dw[26], &values->ChromaOffsets[8]);

   GFX20_HCP_WEIGHTOFFSET_CHROMA_ENTRY_pack(data, &dw[27], &values->ChromaOffsets[9]);

   GFX20_HCP_WEIGHTOFFSET_CHROMA_ENTRY_pack(data, &dw[28], &values->ChromaOffsets[10]);

   GFX20_HCP_WEIGHTOFFSET_CHROMA_ENTRY_pack(data, &dw[29], &values->ChromaOffsets[11]);

   GFX20_HCP_WEIGHTOFFSET_CHROMA_ENTRY_pack(data, &dw[30], &values->ChromaOffsets[12]);

   GFX20_HCP_WEIGHTOFFSET_CHROMA_ENTRY_pack(data, &dw[31], &values->ChromaOffsets[13]);

   GFX20_HCP_WEIGHTOFFSET_CHROMA_ENTRY_pack(data, &dw[32], &values->ChromaOffsets[14]);

   GFX20_HCP_WEIGHTOFFSET_CHROMA_ENTRY_pack(data, &dw[33], &values->ChromaOffsets[15]);

   GFX20_HCP_WEIGHTOFFSET_CHROMA_EXT_ENTRY_pack(data, &dw[34], &values->ChromaOffsetsExt[0]);

   GFX20_HCP_WEIGHTOFFSET_CHROMA_EXT_ENTRY_pack(data, &dw[35], &values->ChromaOffsetsExt[1]);

   GFX20_HCP_WEIGHTOFFSET_CHROMA_EXT_ENTRY_pack(data, &dw[36], &values->ChromaOffsetsExt[2]);

   GFX20_HCP_WEIGHTOFFSET_CHROMA_EXT_ENTRY_pack(data, &dw[37], &values->ChromaOffsetsExt[3]);

   GFX20_HCP_WEIGHTOFFSET_CHROMA_EXT_ENTRY_pack(data, &dw[38], &values->ChromaOffsetsExt[4]);

   GFX20_HCP_WEIGHTOFFSET_CHROMA_EXT_ENTRY_pack(data, &dw[39], &values->ChromaOffsetsExt[5]);

   GFX20_HCP_WEIGHTOFFSET_CHROMA_EXT_ENTRY_pack(data, &dw[40], &values->ChromaOffsetsExt[6]);

   GFX20_HCP_WEIGHTOFFSET_CHROMA_EXT_ENTRY_pack(data, &dw[41], &values->ChromaOffsetsExt[7]);
}

#define GFX20_HEVC_VP9_RDOQ_STATE_length      62
#define GFX20_HEVC_VP9_RDOQ_STATE_length_bias      2
#define GFX20_HEVC_VP9_RDOQ_STATE_header        \
   .DWordLength                         =     60,  \
   .SubOpcodeB                          =      8,  \
   .SubOpcodeA                          =      0,  \
   .MediaCommandOpcode                  =      7,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_HEVC_VP9_RDOQ_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   bool                                 HTQPerformanceFix1Disable;
   bool                                 HTQPerformanceFix0Disable;
   struct GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS IntraLumaLambda[32];
   struct GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS IntraChromaLambda[32];
   struct GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS InterLumaLambda[32];
   struct GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS InterChromaLambda[32];
};

static inline __attribute__((always_inline)) void
GFX20_HEVC_VP9_RDOQ_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                               __attribute__((unused)) void * restrict dst,
                               __attribute__((unused)) const struct GFX20_HEVC_VP9_RDOQ_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->HTQPerformanceFix1Disable, 30, 30) |
      util_bitpack_uint(values->HTQPerformanceFix0Disable, 31, 31);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[2], &values->IntraLumaLambda[0]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[3], &values->IntraLumaLambda[1]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[4], &values->IntraLumaLambda[2]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[5], &values->IntraLumaLambda[3]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[6], &values->IntraLumaLambda[4]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[7], &values->IntraLumaLambda[5]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[8], &values->IntraLumaLambda[6]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[9], &values->IntraLumaLambda[7]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[10], &values->IntraLumaLambda[8]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[11], &values->IntraLumaLambda[9]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[12], &values->IntraLumaLambda[10]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[13], &values->IntraLumaLambda[11]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[14], &values->IntraLumaLambda[12]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[15], &values->IntraLumaLambda[13]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[16], &values->IntraLumaLambda[14]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[17], &values->IntraLumaLambda[15]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[18], &values->IntraLumaLambda[16]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[19], &values->IntraLumaLambda[17]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[20], &values->IntraLumaLambda[18]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[21], &values->IntraLumaLambda[19]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[22], &values->IntraLumaLambda[20]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[23], &values->IntraLumaLambda[21]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[24], &values->IntraLumaLambda[22]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[25], &values->IntraLumaLambda[23]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[26], &values->IntraLumaLambda[24]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[27], &values->IntraLumaLambda[25]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[28], &values->IntraLumaLambda[26]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[29], &values->IntraLumaLambda[27]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[30], &values->IntraLumaLambda[28]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[31], &values->IntraLumaLambda[29]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[32], &values->IntraLumaLambda[30]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[33], &values->IntraLumaLambda[31]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[34], &values->IntraChromaLambda[0]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[35], &values->IntraChromaLambda[1]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[36], &values->IntraChromaLambda[2]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[37], &values->IntraChromaLambda[3]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[38], &values->IntraChromaLambda[4]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[39], &values->IntraChromaLambda[5]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[40], &values->IntraChromaLambda[6]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[41], &values->IntraChromaLambda[7]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[42], &values->IntraChromaLambda[8]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[43], &values->IntraChromaLambda[9]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[44], &values->IntraChromaLambda[10]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[45], &values->IntraChromaLambda[11]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[46], &values->IntraChromaLambda[12]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[47], &values->IntraChromaLambda[13]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[48], &values->IntraChromaLambda[14]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[49], &values->IntraChromaLambda[15]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[50], &values->IntraChromaLambda[16]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[51], &values->IntraChromaLambda[17]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[52], &values->IntraChromaLambda[18]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[53], &values->IntraChromaLambda[19]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[54], &values->IntraChromaLambda[20]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[55], &values->IntraChromaLambda[21]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[56], &values->IntraChromaLambda[22]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[57], &values->IntraChromaLambda[23]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[58], &values->IntraChromaLambda[24]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[59], &values->IntraChromaLambda[25]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[60], &values->IntraChromaLambda[26]);

   GFX20_HEVC_VP9_RDOQ_LAMBDA_FIELDS_pack(data, &dw[61], &values->IntraChromaLambda[27]);
}

#define GFX20_HUC_CFG_STATE_length             2
#define GFX20_HUC_CFG_STATE_length_bias        2
#define GFX20_HUC_CFG_STATE_header              \
   .SubOpcode                           =      3,  \
   .MediaCommandOpcode                  =     11,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_HUC_CFG_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcode;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             P24C;
#define Normaloperation                          0
#define Forcereset                               1
};

static inline __attribute__((always_inline)) void
GFX20_HUC_CFG_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                         __attribute__((unused)) void * restrict dst,
                         __attribute__((unused)) const struct GFX20_HUC_CFG_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcode, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->P24C, 0, 0);
}

#define GFX20_HUC_DMEM_STATE_length            6
#define GFX20_HUC_DMEM_STATE_length_bias       2
#define GFX20_HUC_DMEM_STATE_header             \
   .SubOpcode                           =      2,  \
   .MediaCommandOpcode                  =     11,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_HUC_DMEM_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcode;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   __gen_address_type                   HUCDataSourceAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES HUCDataSourceMemoryAddressAttributes;
   __gen_address_type                   HUCDataDestinationAddress;
   uint32_t                             HUCDataLength;
};

static inline __attribute__((always_inline)) void
GFX20_HUC_DMEM_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                          __attribute__((unused)) void * restrict dst,
                          __attribute__((unused)) const struct GFX20_HUC_DMEM_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcode, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   const uint64_t v1_address =
      __gen_address(data, &dw[1], values->HUCDataSourceAddress, 0, 0, 63);
   dw[1] = v1_address;
   dw[2] = v1_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[3], &values->HUCDataSourceMemoryAddressAttributes);

   dw[4] = __gen_address(data, &dw[4], values->HUCDataDestinationAddress, 0, 6, 16);

   dw[5] =
      util_bitpack_uint(values->HUCDataLength, 6, 16);
}

#define GFX20_HUC_IMEM_STATE_length            5
#define GFX20_HUC_IMEM_STATE_length_bias       2
#define GFX20_HUC_IMEM_STATE_header             \
   .SubOpcode                           =      1,  \
   .MediaCommandOpcode                  =     11,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_HUC_IMEM_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcode;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             HUCFirmwareDescriptor;
};

static inline __attribute__((always_inline)) void
GFX20_HUC_IMEM_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                          __attribute__((unused)) void * restrict dst,
                          __attribute__((unused)) const struct GFX20_HUC_IMEM_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcode, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] = 0;

   dw[2] = 0;

   dw[3] = 0;

   dw[4] =
      util_bitpack_uint(values->HUCFirmwareDescriptor, 0, 7);
}

#define GFX20_HUC_IND_OBJ_BASE_ADDR_STATE_length     11
#define GFX20_HUC_IND_OBJ_BASE_ADDR_STATE_length_bias      2
#define GFX20_HUC_IND_OBJ_BASE_ADDR_STATE_header\
   .SubOpcode                           =      5,  \
   .MediaCommandOpcode                  =     11,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_HUC_IND_OBJ_BASE_ADDR_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcode;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   __gen_address_type                   HUCIndirectStreamInObjectAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES HUCIndirectStreamInObjectMemoryAddressAttributes;
   __gen_address_type                   HUCIndirectStreamInObjectAccessUpperBound;
   __gen_address_type                   HUCIndirectStreamOutObjectAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES HUCIndirectStreamOutObjectMemoryAddressAttributes;
   __gen_address_type                   HUCIndirectStreamOutObjectAccessUpperBound;
};

static inline __attribute__((always_inline)) void
GFX20_HUC_IND_OBJ_BASE_ADDR_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                                       __attribute__((unused)) void * restrict dst,
                                       __attribute__((unused)) const struct GFX20_HUC_IND_OBJ_BASE_ADDR_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcode, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   const uint64_t v1_address =
      __gen_address(data, &dw[1], values->HUCIndirectStreamInObjectAddress, 0, 0, 63);
   dw[1] = v1_address;
   dw[2] = v1_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[3], &values->HUCIndirectStreamInObjectMemoryAddressAttributes);

   const uint64_t v4_address =
      __gen_address(data, &dw[4], values->HUCIndirectStreamInObjectAccessUpperBound, 0, 0, 63);
   dw[4] = v4_address;
   dw[5] = v4_address >> 32;

   const uint64_t v6_address =
      __gen_address(data, &dw[6], values->HUCIndirectStreamOutObjectAddress, 0, 0, 63);
   dw[6] = v6_address;
   dw[7] = v6_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[8], &values->HUCIndirectStreamOutObjectMemoryAddressAttributes);

   const uint64_t v9_address =
      __gen_address(data, &dw[9], values->HUCIndirectStreamOutObjectAccessUpperBound, 0, 0, 63);
   dw[9] = v9_address;
   dw[10] = v9_address >> 32;
}

#define GFX20_HUC_PIPE_MODE_SELECT_length      3
#define GFX20_HUC_PIPE_MODE_SELECT_length_bias      2
#define GFX20_HUC_PIPE_MODE_SELECT_header       \
   .SubOpcode                           =      0,  \
   .MediaCommandOpcode                  =     11,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_HUC_PIPE_MODE_SELECT {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcode;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   bool                                 IndirectStreamOutEnable;
   uint32_t                             MediaSoftResetCounter;
};

static inline __attribute__((always_inline)) void
GFX20_HUC_PIPE_MODE_SELECT_pack(__attribute__((unused)) __gen_user_data *data,
                                __attribute__((unused)) void * restrict dst,
                                __attribute__((unused)) const struct GFX20_HUC_PIPE_MODE_SELECT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcode, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->IndirectStreamOutEnable, 4, 4);

   dw[2] =
      util_bitpack_uint(values->MediaSoftResetCounter, 0, 31);
}

#define GFX20_HUC_START_length                 2
#define GFX20_HUC_START_length_bias            2
#define GFX20_HUC_START_header                  \
   .SubOpcode                           =     33,  \
   .MediaCommandOpcode                  =     11,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_HUC_START {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcode;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   bool                                 LastStreamObject;
};

static inline __attribute__((always_inline)) void
GFX20_HUC_START_pack(__attribute__((unused)) __gen_user_data *data,
                     __attribute__((unused)) void * restrict dst,
                     __attribute__((unused)) const struct GFX20_HUC_START * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcode, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->LastStreamObject, 0, 0);
}

#define GFX20_HUC_STREAM_OBJECT_length         5
#define GFX20_HUC_STREAM_OBJECT_length_bias      2
#define GFX20_HUC_STREAM_OBJECT_header          \
   .SubOpcode                           =     32,  \
   .MediaCommandOpcode                  =     11,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_HUC_STREAM_OBJECT {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcode;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             IndirectStreamInDataLength;
   __gen_address_type                   IndirectStreamInAddress;
   bool                                 HuCProcessing;
   __gen_address_type                   IndirectStreamOutAddress;
   uint32_t                             StartCodeByte0;
   uint32_t                             StartCodeByte1;
   uint32_t                             StartCodeByte2;
   bool                                 StartCodeSearchEngine;
   bool                                 EmulationPreventionByteRemoval;
   bool                                 StreamOut;
   uint32_t                             DRMLengthMode;
#define StartCodeMode                            0
#define LengthMode                               1
   bool                                 HUCBitstreamEnable;
};

static inline __attribute__((always_inline)) void
GFX20_HUC_STREAM_OBJECT_pack(__attribute__((unused)) __gen_user_data *data,
                             __attribute__((unused)) void * restrict dst,
                             __attribute__((unused)) const struct GFX20_HUC_STREAM_OBJECT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcode, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->IndirectStreamInDataLength, 0, 31);

   const uint32_t v2 =
      util_bitpack_uint(values->HuCProcessing, 31, 31);
   dw[2] = __gen_address(data, &dw[2], values->IndirectStreamInAddress, v2, 0, 28);

   dw[3] = __gen_address(data, &dw[3], values->IndirectStreamOutAddress, 0, 0, 28);

   dw[4] =
      util_bitpack_uint(values->StartCodeByte0, 0, 7) |
      util_bitpack_uint(values->StartCodeByte1, 8, 15) |
      util_bitpack_uint(values->StartCodeByte2, 16, 23) |
      util_bitpack_uint(values->StartCodeSearchEngine, 24, 24) |
      util_bitpack_uint(values->EmulationPreventionByteRemoval, 25, 25) |
      util_bitpack_uint(values->StreamOut, 26, 26) |
      util_bitpack_uint(values->DRMLengthMode, 27, 28) |
      util_bitpack_uint(values->HUCBitstreamEnable, 29, 29);
}

#define GFX20_HUC_VIRTUAL_ADDR_STATE_length     49
#define GFX20_HUC_VIRTUAL_ADDR_STATE_length_bias      2
#define GFX20_HUC_VIRTUAL_ADDR_STATE_header     \
   .SubOpcode                           =      4,  \
   .MediaCommandOpcode                  =     11,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_HUC_VIRTUAL_ADDR_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcode;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   struct GFX20_HUC_VIRTUAL_ADDR_REGION HUCVirtualAddressRegion[16];
};

static inline __attribute__((always_inline)) void
GFX20_HUC_VIRTUAL_ADDR_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                                  __attribute__((unused)) void * restrict dst,
                                  __attribute__((unused)) const struct GFX20_HUC_VIRTUAL_ADDR_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcode, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   GFX20_HUC_VIRTUAL_ADDR_REGION_pack(data, &dw[1], &values->HUCVirtualAddressRegion[0]);

   GFX20_HUC_VIRTUAL_ADDR_REGION_pack(data, &dw[4], &values->HUCVirtualAddressRegion[1]);

   GFX20_HUC_VIRTUAL_ADDR_REGION_pack(data, &dw[7], &values->HUCVirtualAddressRegion[2]);

   GFX20_HUC_VIRTUAL_ADDR_REGION_pack(data, &dw[10], &values->HUCVirtualAddressRegion[3]);

   GFX20_HUC_VIRTUAL_ADDR_REGION_pack(data, &dw[13], &values->HUCVirtualAddressRegion[4]);

   GFX20_HUC_VIRTUAL_ADDR_REGION_pack(data, &dw[16], &values->HUCVirtualAddressRegion[5]);

   GFX20_HUC_VIRTUAL_ADDR_REGION_pack(data, &dw[19], &values->HUCVirtualAddressRegion[6]);

   GFX20_HUC_VIRTUAL_ADDR_REGION_pack(data, &dw[22], &values->HUCVirtualAddressRegion[7]);

   GFX20_HUC_VIRTUAL_ADDR_REGION_pack(data, &dw[25], &values->HUCVirtualAddressRegion[8]);

   GFX20_HUC_VIRTUAL_ADDR_REGION_pack(data, &dw[28], &values->HUCVirtualAddressRegion[9]);

   GFX20_HUC_VIRTUAL_ADDR_REGION_pack(data, &dw[31], &values->HUCVirtualAddressRegion[10]);

   GFX20_HUC_VIRTUAL_ADDR_REGION_pack(data, &dw[34], &values->HUCVirtualAddressRegion[11]);

   GFX20_HUC_VIRTUAL_ADDR_REGION_pack(data, &dw[37], &values->HUCVirtualAddressRegion[12]);

   GFX20_HUC_VIRTUAL_ADDR_REGION_pack(data, &dw[40], &values->HUCVirtualAddressRegion[13]);

   GFX20_HUC_VIRTUAL_ADDR_REGION_pack(data, &dw[43], &values->HUCVirtualAddressRegion[14]);

   GFX20_HUC_VIRTUAL_ADDR_REGION_pack(data, &dw[46], &values->HUCVirtualAddressRegion[15]);
}

#define GFX20_MFC_AVC_PAK_OBJECT_length       12
#define GFX20_MFC_AVC_PAK_OBJECT_length_bias      2
#define GFX20_MFC_AVC_PAK_OBJECT_header         \
   .DWordLength                         =     10,  \
   .SubOpcodeB                          =      9,  \
   .SubOpcodeA                          =      2,  \
   .MediaCommandOpcode                  =      1,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFC_AVC_PAK_OBJECT {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             IndirectPAKMVDataLength;
   uint64_t                             IndirectPAKMVDataStartAddressOffset;
   uint32_t                             InlineData[8];
   uint32_t                             VDEncModeInlineData[12];
};

static inline __attribute__((always_inline)) void
GFX20_MFC_AVC_PAK_OBJECT_pack(__attribute__((unused)) __gen_user_data *data,
                              __attribute__((unused)) void * restrict dst,
                              __attribute__((unused)) const struct GFX20_MFC_AVC_PAK_OBJECT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpcode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->IndirectPAKMVDataLength, 0, 9);

   dw[2] =
      __gen_offset(values->IndirectPAKMVDataStartAddressOffset, 0, 28);

   dw[3] =
      util_bitpack_uint(values->InlineData[0], 0, 31);

   dw[4] =
      util_bitpack_uint(values->InlineData[1], 0, 31);

   dw[5] =
      util_bitpack_uint(values->InlineData[2], 0, 31);

   dw[6] =
      util_bitpack_uint(values->InlineData[3], 0, 31);

   dw[7] =
      util_bitpack_uint(values->InlineData[4], 0, 31);

   dw[8] =
      util_bitpack_uint(values->InlineData[5], 0, 31);

   dw[9] =
      util_bitpack_uint(values->InlineData[6], 0, 31);

   dw[10] =
      util_bitpack_uint(values->InlineData[7], 0, 31);

   dw[11] = 0;
}

#define GFX20_MFC_JPEG_HUFF_TABLE_STATE_length    176
#define GFX20_MFC_JPEG_HUFF_TABLE_STATE_length_bias      2
#define GFX20_MFC_JPEG_HUFF_TABLE_STATE_header  \
   .DWordLength                         =    174,  \
   .SubOpcodeB                          =      3,  \
   .SubOpcodeA                          =      2,  \
   .MediaCommandOpcode                  =      7,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFC_JPEG_HUFF_TABLE_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             HuffTableID;
   uint64_t                             DC_TABLE;
   uint64_t                             AC_TABLE;
};

static inline __attribute__((always_inline)) void
GFX20_MFC_JPEG_HUFF_TABLE_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                                     __attribute__((unused)) void * restrict dst,
                                     __attribute__((unused)) const struct GFX20_MFC_JPEG_HUFF_TABLE_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpcode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->HuffTableID, 0, 0);

   const uint64_t v2 =
      util_bitpack_uint(values->DC_TABLE, 0, 383);
   dw[2] = v2;
   dw[3] = v2 >> 32;

   const uint64_t v14 =
      util_bitpack_uint(values->AC_TABLE, 0, 5183);
   dw[14] = v14;
   dw[15] = v14 >> 32;
}

#define GFX20_MFC_JPEG_SCAN_OBJECT_length      3
#define GFX20_MFC_JPEG_SCAN_OBJECT_length_bias      2
#define GFX20_MFC_JPEG_SCAN_OBJECT_header       \
   .DWordLength                         =      1,  \
   .SubOpcodeB                          =      9,  \
   .SubOpcodeA                          =      2,  \
   .MediaCommandOpcode                  =      7,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFC_JPEG_SCAN_OBJECT {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             MCUCount;
   uint32_t                             RestartInterval;
   bool                                 LastScan;
   bool                                 HeadPresent;
   uint32_t                             HuffmanDCTable;
   uint32_t                             HuffmanACTable;
};

static inline __attribute__((always_inline)) void
GFX20_MFC_JPEG_SCAN_OBJECT_pack(__attribute__((unused)) __gen_user_data *data,
                                __attribute__((unused)) void * restrict dst,
                                __attribute__((unused)) const struct GFX20_MFC_JPEG_SCAN_OBJECT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpcode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->MCUCount, 0, 25);

   dw[2] =
      util_bitpack_uint(values->RestartInterval, 0, 15) |
      util_bitpack_uint(values->LastScan, 16, 16) |
      util_bitpack_uint(values->HeadPresent, 17, 17) |
      util_bitpack_uint(values->HuffmanDCTable, 18, 20) |
      util_bitpack_uint(values->HuffmanACTable, 22, 24);
}

#define GFX20_MFC_MPEG2_PAK_OBJECT_length      9
#define GFX20_MFC_MPEG2_PAK_OBJECT_length_bias      2
#define GFX20_MFC_MPEG2_PAK_OBJECT_header       \
   .DWordLength                         =      7,  \
   .SubOpcodeB                          =      9,  \
   .SubOpcodeA                          =      2,  \
   .MediaCommandOpcode                  =      3,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFC_MPEG2_PAK_OBJECT {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             InlineData[8];
};

static inline __attribute__((always_inline)) void
GFX20_MFC_MPEG2_PAK_OBJECT_pack(__attribute__((unused)) __gen_user_data *data,
                                __attribute__((unused)) void * restrict dst,
                                __attribute__((unused)) const struct GFX20_MFC_MPEG2_PAK_OBJECT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpcode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->InlineData[0], 0, 31);

   dw[2] =
      util_bitpack_uint(values->InlineData[1], 0, 31);

   dw[3] =
      util_bitpack_uint(values->InlineData[2], 0, 31);

   dw[4] =
      util_bitpack_uint(values->InlineData[3], 0, 31);

   dw[5] =
      util_bitpack_uint(values->InlineData[4], 0, 31);

   dw[6] =
      util_bitpack_uint(values->InlineData[5], 0, 31);

   dw[7] =
      util_bitpack_uint(values->InlineData[6], 0, 31);

   dw[8] =
      util_bitpack_uint(values->InlineData[7], 0, 31);
}

#define GFX20_MFC_MPEG2_SLICEGROUP_STATE_length      8
#define GFX20_MFC_MPEG2_SLICEGROUP_STATE_length_bias      2
#define GFX20_MFC_MPEG2_SLICEGROUP_STATE_header \
   .DWordLength                         =      6,  \
   .SubOpcodeB                          =      3,  \
   .SubOpcodeA                          =      2,  \
   .MediaCommandOpcode                  =      3,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFC_MPEG2_SLICEGROUP_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             StreamID;
   uint32_t                             SliceID;
   bool                                 IntraSliceFlag;
   bool                                 IntraSlice;
   bool                                 FirstSliceHeaderDisable;
   bool                                 TailInsertionPresent;
   bool                                 SliceDataInsertionPresent;
   bool                                 HeaderInsertionPresent;
   bool                                 CompressedBitStreamOutputDisable;
   bool                                 LastSlice;
   bool                                 MBTypeSkipConversionDisable;
   uint32_t                             RateControlPanicType;
#define QPPanic                                  0
#define CBPPanic                                 1
   bool                                 RateControlPanicEnable;
   uint32_t                             RateControlStableTolerance;
   uint32_t                             RateControlTriggleMode;
#define AlwaysRateControl                        0
#define GentleRateControl                        1
#define LooseRateControl                         2
   bool                                 ResetRateControlCounter;
   bool                                 RateControlCounterEnable;
   uint32_t                             FirstMBXCount;
   uint32_t                             FirstMBYCount;
   uint32_t                             NextSliceGroupMBXCount;
   uint32_t                             NextSliceGroupMBYCount;
   uint32_t                             SliceGroupQP;
   bool                                 SliceGroupSkip;
   uint64_t                             IndirectPAKBSEDataStartAddress;
   uint32_t                             GrowInit;
   uint32_t                             GrowResistance;
   uint32_t                             ShrinkInit;
   uint32_t                             ShrinkResistance;
   uint32_t                             QPMaxPositiveModifierMagnitude;
   uint32_t                             QPMaxNegativeModifierMagnitude;
   uint32_t                             Correct1;
   uint32_t                             Correct2;
   uint32_t                             Correct3;
   uint32_t                             Correct4;
   uint32_t                             Correct5;
   uint32_t                             Correct6;
   uint32_t                             CV0;
   uint32_t                             CV1;
   uint32_t                             CV2;
   uint32_t                             CV3;
   uint32_t                             CV4;
   uint32_t                             CV5;
   uint32_t                             CV6;
   uint32_t                             CV7;
};

static inline __attribute__((always_inline)) void
GFX20_MFC_MPEG2_SLICEGROUP_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                                      __attribute__((unused)) void * restrict dst,
                                      __attribute__((unused)) const struct GFX20_MFC_MPEG2_SLICEGROUP_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpcode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->StreamID, 0, 1) |
      util_bitpack_uint(values->SliceID, 4, 7) |
      util_bitpack_uint(values->IntraSliceFlag, 12, 12) |
      util_bitpack_uint(values->IntraSlice, 13, 13) |
      util_bitpack_uint(values->FirstSliceHeaderDisable, 14, 14) |
      util_bitpack_uint(values->TailInsertionPresent, 15, 15) |
      util_bitpack_uint(values->SliceDataInsertionPresent, 16, 16) |
      util_bitpack_uint(values->HeaderInsertionPresent, 17, 17) |
      util_bitpack_uint(values->CompressedBitStreamOutputDisable, 18, 18) |
      util_bitpack_uint(values->LastSlice, 19, 19) |
      util_bitpack_uint(values->MBTypeSkipConversionDisable, 20, 20) |
      util_bitpack_uint(values->RateControlPanicType, 22, 22) |
      util_bitpack_uint(values->RateControlPanicEnable, 23, 23) |
      util_bitpack_uint(values->RateControlStableTolerance, 24, 27) |
      util_bitpack_uint(values->RateControlTriggleMode, 28, 29) |
      util_bitpack_uint(values->ResetRateControlCounter, 30, 30) |
      util_bitpack_uint(values->RateControlCounterEnable, 31, 31);

   dw[2] =
      util_bitpack_uint(values->FirstMBXCount, 0, 7) |
      util_bitpack_uint(values->FirstMBYCount, 8, 15) |
      util_bitpack_uint(values->NextSliceGroupMBXCount, 16, 23) |
      util_bitpack_uint(values->NextSliceGroupMBYCount, 24, 31);

   dw[3] =
      util_bitpack_uint(values->SliceGroupQP, 0, 5) |
      util_bitpack_uint(values->SliceGroupSkip, 8, 8);

   dw[4] =
      __gen_offset(values->IndirectPAKBSEDataStartAddress, 0, 28);

   dw[5] =
      util_bitpack_uint(values->GrowInit, 0, 3) |
      util_bitpack_uint(values->GrowResistance, 4, 7) |
      util_bitpack_uint(values->ShrinkInit, 8, 11) |
      util_bitpack_uint(values->ShrinkResistance, 12, 15) |
      util_bitpack_uint(values->QPMaxPositiveModifierMagnitude, 16, 23) |
      util_bitpack_uint(values->QPMaxNegativeModifierMagnitude, 24, 31);

   dw[6] =
      util_bitpack_uint(values->Correct1, 0, 3) |
      util_bitpack_uint(values->Correct2, 4, 7) |
      util_bitpack_uint(values->Correct3, 8, 11) |
      util_bitpack_uint(values->Correct4, 12, 15) |
      util_bitpack_uint(values->Correct5, 16, 19) |
      util_bitpack_uint(values->Correct6, 20, 23);

   dw[7] =
      util_bitpack_uint(values->CV0, 0, 3) |
      util_bitpack_uint(values->CV1, 4, 7) |
      util_bitpack_uint(values->CV2, 8, 11) |
      util_bitpack_uint(values->CV3, 12, 15) |
      util_bitpack_uint(values->CV4, 16, 19) |
      util_bitpack_uint(values->CV5, 20, 23) |
      util_bitpack_uint(values->CV6, 24, 27) |
      util_bitpack_uint(values->CV7, 28, 31);
}

#define GFX20_MFD_AVC_BSD_OBJECT_length        7
#define GFX20_MFD_AVC_BSD_OBJECT_length_bias      2
#define GFX20_MFD_AVC_BSD_OBJECT_header         \
   .DWordLength                         =      5,  \
   .SubOpcodeB                          =      8,  \
   .SubOpcodeA                          =      1,  \
   .MediaCommandOpcode                  =      1,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFD_AVC_BSD_OBJECT {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             IndirectBSDDataLength;
   uint64_t                             IndirectBSDDataStartAddress;
   struct GFX20_INLINE_DATA_DESCRIPTION_FOR_MFD_AVC_BSD_OBJECT InlineData;
};

static inline __attribute__((always_inline)) void
GFX20_MFD_AVC_BSD_OBJECT_pack(__attribute__((unused)) __gen_user_data *data,
                              __attribute__((unused)) void * restrict dst,
                              __attribute__((unused)) const struct GFX20_MFD_AVC_BSD_OBJECT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpcode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->IndirectBSDDataLength, 0, 31);

   dw[2] =
      __gen_offset(values->IndirectBSDDataStartAddress, 0, 28);

   GFX20_INLINE_DATA_DESCRIPTION_FOR_MFD_AVC_BSD_OBJECT_pack(data, &dw[3], &values->InlineData);

   dw[6] = 0;
}

#define GFX20_MFD_AVC_DPB_STATE_length        27
#define GFX20_MFD_AVC_DPB_STATE_length_bias      2
#define GFX20_MFD_AVC_DPB_STATE_header          \
   .DWordLength                         =     25,  \
   .SubOpcodeB                          =      6,  \
   .SubOpcodeA                          =      1,  \
   .MediaCommandOpcode                  =      1,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFD_AVC_DPB_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             NonExistingFrame[16];
#define INVALID                                  1
#define VALID                                    0
   uint32_t                             LongTermFrame[16];
   uint32_t                             UsedforReference[16];
#define NOT_REFERENCE                            0
#define TOP_FIELD                                1
#define BOTTOM_FIELD                             2
#define FRAME                                    3
   uint32_t                             LTSTFrameNumberList[16];
   uint32_t                             ViewID[16];
   uint32_t                             L0ViewOrder[16];
   uint32_t                             L1ViewOrder[16];
};

static inline __attribute__((always_inline)) void
GFX20_MFD_AVC_DPB_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                             __attribute__((unused)) void * restrict dst,
                             __attribute__((unused)) const struct GFX20_MFD_AVC_DPB_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpcode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->NonExistingFrame[0], 0, 0) |
      util_bitpack_uint(values->NonExistingFrame[1], 1, 1) |
      util_bitpack_uint(values->NonExistingFrame[2], 2, 2) |
      util_bitpack_uint(values->NonExistingFrame[3], 3, 3) |
      util_bitpack_uint(values->NonExistingFrame[4], 4, 4) |
      util_bitpack_uint(values->NonExistingFrame[5], 5, 5) |
      util_bitpack_uint(values->NonExistingFrame[6], 6, 6) |
      util_bitpack_uint(values->NonExistingFrame[7], 7, 7) |
      util_bitpack_uint(values->NonExistingFrame[8], 8, 8) |
      util_bitpack_uint(values->NonExistingFrame[9], 9, 9) |
      util_bitpack_uint(values->NonExistingFrame[10], 10, 10) |
      util_bitpack_uint(values->NonExistingFrame[11], 11, 11) |
      util_bitpack_uint(values->NonExistingFrame[12], 12, 12) |
      util_bitpack_uint(values->NonExistingFrame[13], 13, 13) |
      util_bitpack_uint(values->NonExistingFrame[14], 14, 14) |
      util_bitpack_uint(values->NonExistingFrame[15], 15, 15) |
      util_bitpack_uint(values->LongTermFrame[0], 16, 16) |
      util_bitpack_uint(values->LongTermFrame[1], 17, 17) |
      util_bitpack_uint(values->LongTermFrame[2], 18, 18) |
      util_bitpack_uint(values->LongTermFrame[3], 19, 19) |
      util_bitpack_uint(values->LongTermFrame[4], 20, 20) |
      util_bitpack_uint(values->LongTermFrame[5], 21, 21) |
      util_bitpack_uint(values->LongTermFrame[6], 22, 22) |
      util_bitpack_uint(values->LongTermFrame[7], 23, 23) |
      util_bitpack_uint(values->LongTermFrame[8], 24, 24) |
      util_bitpack_uint(values->LongTermFrame[9], 25, 25) |
      util_bitpack_uint(values->LongTermFrame[10], 26, 26) |
      util_bitpack_uint(values->LongTermFrame[11], 27, 27) |
      util_bitpack_uint(values->LongTermFrame[12], 28, 28) |
      util_bitpack_uint(values->LongTermFrame[13], 29, 29) |
      util_bitpack_uint(values->LongTermFrame[14], 30, 30) |
      util_bitpack_uint(values->LongTermFrame[15], 31, 31);

   dw[2] =
      util_bitpack_uint(values->UsedforReference[0], 0, 1) |
      util_bitpack_uint(values->UsedforReference[1], 2, 3) |
      util_bitpack_uint(values->UsedforReference[2], 4, 5) |
      util_bitpack_uint(values->UsedforReference[3], 6, 7) |
      util_bitpack_uint(values->UsedforReference[4], 8, 9) |
      util_bitpack_uint(values->UsedforReference[5], 10, 11) |
      util_bitpack_uint(values->UsedforReference[6], 12, 13) |
      util_bitpack_uint(values->UsedforReference[7], 14, 15) |
      util_bitpack_uint(values->UsedforReference[8], 16, 17) |
      util_bitpack_uint(values->UsedforReference[9], 18, 19) |
      util_bitpack_uint(values->UsedforReference[10], 20, 21) |
      util_bitpack_uint(values->UsedforReference[11], 22, 23) |
      util_bitpack_uint(values->UsedforReference[12], 24, 25) |
      util_bitpack_uint(values->UsedforReference[13], 26, 27) |
      util_bitpack_uint(values->UsedforReference[14], 28, 29) |
      util_bitpack_uint(values->UsedforReference[15], 30, 31);

   dw[3] =
      util_bitpack_uint(values->LTSTFrameNumberList[0], 0, 15) |
      util_bitpack_uint(values->LTSTFrameNumberList[1], 16, 31);

   dw[4] =
      util_bitpack_uint(values->LTSTFrameNumberList[2], 0, 15) |
      util_bitpack_uint(values->LTSTFrameNumberList[3], 16, 31);

   dw[5] =
      util_bitpack_uint(values->LTSTFrameNumberList[4], 0, 15) |
      util_bitpack_uint(values->LTSTFrameNumberList[5], 16, 31);

   dw[6] =
      util_bitpack_uint(values->LTSTFrameNumberList[6], 0, 15) |
      util_bitpack_uint(values->LTSTFrameNumberList[7], 16, 31);

   dw[7] =
      util_bitpack_uint(values->LTSTFrameNumberList[8], 0, 15) |
      util_bitpack_uint(values->LTSTFrameNumberList[9], 16, 31);

   dw[8] =
      util_bitpack_uint(values->LTSTFrameNumberList[10], 0, 15) |
      util_bitpack_uint(values->LTSTFrameNumberList[11], 16, 31);

   dw[9] =
      util_bitpack_uint(values->LTSTFrameNumberList[12], 0, 15) |
      util_bitpack_uint(values->LTSTFrameNumberList[13], 16, 31);

   dw[10] =
      util_bitpack_uint(values->LTSTFrameNumberList[14], 0, 15) |
      util_bitpack_uint(values->LTSTFrameNumberList[15], 16, 31);

   dw[11] =
      util_bitpack_uint(values->ViewID[0], 0, 15) |
      util_bitpack_uint(values->ViewID[1], 16, 31);

   dw[12] =
      util_bitpack_uint(values->ViewID[2], 0, 15) |
      util_bitpack_uint(values->ViewID[3], 16, 31);

   dw[13] =
      util_bitpack_uint(values->ViewID[4], 0, 15) |
      util_bitpack_uint(values->ViewID[5], 16, 31);

   dw[14] =
      util_bitpack_uint(values->ViewID[6], 0, 15) |
      util_bitpack_uint(values->ViewID[7], 16, 31);

   dw[15] =
      util_bitpack_uint(values->ViewID[8], 0, 15) |
      util_bitpack_uint(values->ViewID[9], 16, 31);

   dw[16] =
      util_bitpack_uint(values->ViewID[10], 0, 15) |
      util_bitpack_uint(values->ViewID[11], 16, 31);

   dw[17] =
      util_bitpack_uint(values->ViewID[12], 0, 15) |
      util_bitpack_uint(values->ViewID[13], 16, 31);

   dw[18] =
      util_bitpack_uint(values->ViewID[14], 0, 15) |
      util_bitpack_uint(values->ViewID[15], 16, 31);

   dw[19] =
      util_bitpack_uint(values->L0ViewOrder[0], 0, 7) |
      util_bitpack_uint(values->L0ViewOrder[1], 8, 15) |
      util_bitpack_uint(values->L0ViewOrder[2], 16, 23) |
      util_bitpack_uint(values->L0ViewOrder[3], 24, 31);

   dw[20] =
      util_bitpack_uint(values->L0ViewOrder[4], 0, 7) |
      util_bitpack_uint(values->L0ViewOrder[5], 8, 15) |
      util_bitpack_uint(values->L0ViewOrder[6], 16, 23) |
      util_bitpack_uint(values->L0ViewOrder[7], 24, 31);

   dw[21] =
      util_bitpack_uint(values->L0ViewOrder[8], 0, 7) |
      util_bitpack_uint(values->L0ViewOrder[9], 8, 15) |
      util_bitpack_uint(values->L0ViewOrder[10], 16, 23) |
      util_bitpack_uint(values->L0ViewOrder[11], 24, 31);

   dw[22] =
      util_bitpack_uint(values->L0ViewOrder[12], 0, 7) |
      util_bitpack_uint(values->L0ViewOrder[13], 8, 15) |
      util_bitpack_uint(values->L0ViewOrder[14], 16, 23) |
      util_bitpack_uint(values->L0ViewOrder[15], 24, 31);

   dw[23] =
      util_bitpack_uint(values->L1ViewOrder[0], 0, 7) |
      util_bitpack_uint(values->L1ViewOrder[1], 8, 15) |
      util_bitpack_uint(values->L1ViewOrder[2], 16, 23) |
      util_bitpack_uint(values->L1ViewOrder[3], 24, 31);

   dw[24] =
      util_bitpack_uint(values->L1ViewOrder[4], 0, 7) |
      util_bitpack_uint(values->L1ViewOrder[5], 8, 15) |
      util_bitpack_uint(values->L1ViewOrder[6], 16, 23) |
      util_bitpack_uint(values->L1ViewOrder[7], 24, 31);

   dw[25] =
      util_bitpack_uint(values->L1ViewOrder[8], 0, 7) |
      util_bitpack_uint(values->L1ViewOrder[9], 8, 15) |
      util_bitpack_uint(values->L1ViewOrder[10], 16, 23) |
      util_bitpack_uint(values->L1ViewOrder[11], 24, 31);

   dw[26] =
      util_bitpack_uint(values->L1ViewOrder[12], 0, 7) |
      util_bitpack_uint(values->L1ViewOrder[13], 8, 15) |
      util_bitpack_uint(values->L1ViewOrder[14], 16, 23) |
      util_bitpack_uint(values->L1ViewOrder[15], 24, 31);
}

#define GFX20_MFD_AVC_PICID_STATE_length      10
#define GFX20_MFD_AVC_PICID_STATE_length_bias      2
#define GFX20_MFD_AVC_PICID_STATE_header        \
   .DWordLength                         =      8,  \
   .SubOpcodeB                          =      5,  \
   .SubOpcodeA                          =      1,  \
   .MediaCommandOpcode                  =      1,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFD_AVC_PICID_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             PictureIDRemappingDisable;
#define Use16bitsPictureID                       0
#define Use4bitsFrameStoreID                     1
   uint32_t                             PictureID[16];
};

static inline __attribute__((always_inline)) void
GFX20_MFD_AVC_PICID_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                               __attribute__((unused)) void * restrict dst,
                               __attribute__((unused)) const struct GFX20_MFD_AVC_PICID_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpcode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->PictureIDRemappingDisable, 0, 0);

   dw[2] =
      util_bitpack_uint(values->PictureID[0], 0, 15) |
      util_bitpack_uint(values->PictureID[1], 16, 31);

   dw[3] =
      util_bitpack_uint(values->PictureID[2], 0, 15) |
      util_bitpack_uint(values->PictureID[3], 16, 31);

   dw[4] =
      util_bitpack_uint(values->PictureID[4], 0, 15) |
      util_bitpack_uint(values->PictureID[5], 16, 31);

   dw[5] =
      util_bitpack_uint(values->PictureID[6], 0, 15) |
      util_bitpack_uint(values->PictureID[7], 16, 31);

   dw[6] =
      util_bitpack_uint(values->PictureID[8], 0, 15) |
      util_bitpack_uint(values->PictureID[9], 16, 31);

   dw[7] =
      util_bitpack_uint(values->PictureID[10], 0, 15) |
      util_bitpack_uint(values->PictureID[11], 16, 31);

   dw[8] =
      util_bitpack_uint(values->PictureID[12], 0, 15) |
      util_bitpack_uint(values->PictureID[13], 16, 31);

   dw[9] =
      util_bitpack_uint(values->PictureID[14], 0, 15) |
      util_bitpack_uint(values->PictureID[15], 16, 31);
}

#define GFX20_MFD_AVC_SLICEADDR_length         4
#define GFX20_MFD_AVC_SLICEADDR_length_bias      2
#define GFX20_MFD_AVC_SLICEADDR_header          \
   .DWordLength                         =      2,  \
   .SubOpcodeB                          =      7,  \
   .SubOpcodeA                          =      1,  \
   .MediaCommandOpcode                  =      1,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFD_AVC_SLICEADDR {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             IndirectBSDDataLength;
   uint64_t                             IndirectBSDDataStartAddress;
   uint32_t                             DriverProvidedNALTypeValue;
   uint32_t                             AVCNALTypeFirstByteOverride;
#define UseBitstreamDecodedNALType               0
#define UseDriverProgrammedNALType               1
};

static inline __attribute__((always_inline)) void
GFX20_MFD_AVC_SLICEADDR_pack(__attribute__((unused)) __gen_user_data *data,
                             __attribute__((unused)) void * restrict dst,
                             __attribute__((unused)) const struct GFX20_MFD_AVC_SLICEADDR * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpcode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->IndirectBSDDataLength, 0, 31);

   dw[2] =
      __gen_offset(values->IndirectBSDDataStartAddress, 0, 28);

   dw[3] =
      util_bitpack_uint(values->DriverProvidedNALTypeValue, 0, 7) |
      util_bitpack_uint(values->AVCNALTypeFirstByteOverride, 8, 8);
}

#define GFX20_MFD_IT_OBJECT_length_bias        2
#define GFX20_MFD_IT_OBJECT_header              \
   .DWordLength                         =      6,  \
   .SubOpcodeB                          =      9,  \
   .SubOpcodeA                          =      1,  \
   .MediaCommandOpcode                  =      0,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFD_IT_OBJECT {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             IndirectITMVDataLength;
   uint64_t                             IndirectITMVDataStartAddressOffset;
   uint32_t                             IndirectITCOEFFDataLength;
   uint64_t                             IndirectITCOEFFDataStartAddressOffset;
   uint32_t                             IndirectITDBLKControlDataLength;
   uint64_t                             IndirectITDBLKControlDataStartAddressOffset;
   /* variable length fields follow */
};

static inline __attribute__((always_inline)) void
GFX20_MFD_IT_OBJECT_pack(__attribute__((unused)) __gen_user_data *data,
                         __attribute__((unused)) void * restrict dst,
                         __attribute__((unused)) const struct GFX20_MFD_IT_OBJECT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpcode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->IndirectITMVDataLength, 0, 9);

   dw[2] =
      __gen_offset(values->IndirectITMVDataStartAddressOffset, 0, 28);

   dw[3] =
      util_bitpack_uint(values->IndirectITCOEFFDataLength, 0, 11);

   dw[4] =
      __gen_offset(values->IndirectITCOEFFDataStartAddressOffset, 0, 28);

   dw[5] =
      util_bitpack_uint(values->IndirectITDBLKControlDataLength, 0, 5);

   dw[6] =
      __gen_offset(values->IndirectITDBLKControlDataStartAddressOffset, 0, 28);
}

#define GFX20_MFD_JPEG_BSD_OBJECT_length       6
#define GFX20_MFD_JPEG_BSD_OBJECT_length_bias      2
#define GFX20_MFD_JPEG_BSD_OBJECT_header        \
   .DWordLength                         =      4,  \
   .SubOpcodeB                          =      8,  \
   .SubOpcodeA                          =      1,  \
   .MediaCommandOpcode                  =      7,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFD_JPEG_BSD_OBJECT {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             IndirectDataLength;
   uint64_t                             IndirectDataStartAddress;
   uint32_t                             ScanVerticalPosition;
   uint32_t                             ScanHorizontalPosition;
   uint32_t                             MCUCount;
   uint32_t                             ScanComponents;
   bool                                 Interleaved;
   uint32_t                             RestartInterval;
};

static inline __attribute__((always_inline)) void
GFX20_MFD_JPEG_BSD_OBJECT_pack(__attribute__((unused)) __gen_user_data *data,
                               __attribute__((unused)) void * restrict dst,
                               __attribute__((unused)) const struct GFX20_MFD_JPEG_BSD_OBJECT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpcode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->IndirectDataLength, 0, 31);

   dw[2] =
      __gen_offset(values->IndirectDataStartAddress, 0, 28);

   dw[3] =
      util_bitpack_uint(values->ScanVerticalPosition, 0, 12) |
      util_bitpack_uint(values->ScanHorizontalPosition, 16, 28);

   dw[4] =
      util_bitpack_uint(values->MCUCount, 0, 25) |
      util_bitpack_uint(values->ScanComponents, 27, 29) |
      util_bitpack_uint(values->Interleaved, 30, 30);

   dw[5] =
      util_bitpack_uint(values->RestartInterval, 0, 15);
}

#define GFX20_MFD_MPEG2_BSD_OBJECT_length      5
#define GFX20_MFD_MPEG2_BSD_OBJECT_length_bias      2
#define GFX20_MFD_MPEG2_BSD_OBJECT_header       \
   .DWordLength                         =      3,  \
   .SubOpcodeB                          =      8,  \
   .SubOpcodeA                          =      1,  \
   .MediaCommandOpcode                  =      3,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFD_MPEG2_BSD_OBJECT {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             IndirectBSDDataLength;
   uint64_t                             IndirectBSDDataStartAddress;
   struct GFX20_MFD_MPEG2_BSD_OBJECT_INLINE_DATA_DESCRIPTION InlineData;
};

static inline __attribute__((always_inline)) void
GFX20_MFD_MPEG2_BSD_OBJECT_pack(__attribute__((unused)) __gen_user_data *data,
                                __attribute__((unused)) void * restrict dst,
                                __attribute__((unused)) const struct GFX20_MFD_MPEG2_BSD_OBJECT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpcode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->IndirectBSDDataLength, 0, 31);

   dw[2] =
      __gen_offset(values->IndirectBSDDataStartAddress, 0, 28);

   GFX20_MFD_MPEG2_BSD_OBJECT_INLINE_DATA_DESCRIPTION_pack(data, &dw[3], &values->InlineData);
}

#define GFX20_MFD_VC1_BSD_OBJECT_length        5
#define GFX20_MFD_VC1_BSD_OBJECT_length_bias      2
#define GFX20_MFD_VC1_BSD_OBJECT_header         \
   .DWordLength                         =      3,  \
   .SubOpcodeB                          =      8,  \
   .SubOpcodeA                          =      1,  \
   .MediaCommandOpcode                  =      2,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFD_VC1_BSD_OBJECT {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             IndirectBSDDataLength;
   uint64_t                             IndirectBSDDataStartAddress;
   uint32_t                             NextSliceVerticalPosition;
   uint32_t                             SliceStartVerticalPosition;
   uint32_t                             FirstMBBitOffset;
   uint32_t                             EmulationPreventionBytePresent;
   uint32_t                             FirstMBByteOffsetofSliceDataorSliceHeader;
};

static inline __attribute__((always_inline)) void
GFX20_MFD_VC1_BSD_OBJECT_pack(__attribute__((unused)) __gen_user_data *data,
                              __attribute__((unused)) void * restrict dst,
                              __attribute__((unused)) const struct GFX20_MFD_VC1_BSD_OBJECT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpcode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->IndirectBSDDataLength, 0, 23);

   dw[2] =
      __gen_offset(values->IndirectBSDDataStartAddress, 0, 28);

   dw[3] =
      util_bitpack_uint(values->NextSliceVerticalPosition, 0, 8) |
      util_bitpack_uint(values->SliceStartVerticalPosition, 16, 23);

   dw[4] =
      util_bitpack_uint(values->FirstMBBitOffset, 0, 2) |
      util_bitpack_uint(values->EmulationPreventionBytePresent, 4, 4) |
      util_bitpack_uint(values->FirstMBByteOffsetofSliceDataorSliceHeader, 16, 31);
}

#define GFX20_MFD_VC1_LONG_PIC_STATE_length      6
#define GFX20_MFD_VC1_LONG_PIC_STATE_length_bias      2
#define GFX20_MFD_VC1_LONG_PIC_STATE_header     \
   .DWordLength                         =      4,  \
   .SubOpcodeB                          =      1,  \
   .SubOpcodeA                          =      1,  \
   .MediaCommandOpcode                  =      2,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFD_VC1_LONG_PIC_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             PictureWidthInMBs;
   uint32_t                             PictureHeightInMBs;
   uint32_t                             VC1Profile;
#define SimpleMainProfile                        0
#define AdvancedProfile                          1
   bool                                 SecondField;
   bool                                 OverlapSmoothingEnable;
   bool                                 LoopFilterEnable;
   bool                                 RangeReductionEnable;
   uint32_t                             RangeReductionScale;
   uint32_t                             MVMode;
   bool                                 SyncMarker;
   bool                                 InterpolationRounderControl;
   bool                                 ImplicitQuantizer;
   bool                                 DMVSurfaceValid;
   uint32_t                             BitplaneBufferPitch;
   uint32_t                             BScaleFactor;
   uint32_t                             PQValue;
   uint32_t                             AlternativePQValue;
   uint32_t                             FrameCodingMode;
#define ProgressiveFramePicture                  0
#define InterlacedFramePicture                   1
#define FieldPicturewithTopFieldFirst            2
#define FieldPicturewithBottomFieldFirst         3
   uint32_t                             PictureType;
   uint32_t                             CONDOVER;
   bool                                 PQUniform;
   bool                                 HalfQP;
   uint32_t                             AlternativePQConfiguration;
   uint32_t                             AlternativePQEdgeMask;
   uint32_t                             ExtendedMVRange;
   uint32_t                             ExtendedDMVRange;
   uint32_t                             ForwardReferenceDistance;
   uint32_t                             BackwardReferenceDistance;
   uint32_t                             NumberofReferences;
#define Onefieldreferenced                       0
#define Twofieldsreferenced                      1
   uint32_t                             ReferenceFieldPicturePolarity;
#define TopevenField                             0
#define BottomoddField                           1
   uint32_t                             FastUVMotionCompensation;
#define NoRounding                               0
#define QuarterPeloffsetstoHalfFullpelpositions  1
   uint32_t                             FourMVSwitch;
#define Only1MV                                  0
#define _12or4MVs                                1
   uint32_t                             UnifiedMVMode;
#define _1MVhalfpelbilinear                      3
#define _1MV                                     1
#define _1MVhalfpel                              2
#define MixedMV                                  0
   uint32_t                             CodedBlockPatternTable;
   uint32_t                             IntraTransformDCTable;
   uint32_t                             PicturelevelTransformChromaACCodingSetIndex;
   uint32_t                             PicturelevelTransformLumaACCodingSetIndex;
   uint32_t                             MBModeTable;
   bool                                 MBTransformType;
   uint32_t                             PicturelevelTransformType;
#define _8x8Transform                            0
#define _8x4Transform                            1
#define _4x8Transform                            2
#define _4x4Transform                            3
   uint32_t                             _2MVBlockPatternTable;
   uint32_t                             _4MVBlockPatternTable;
   uint32_t                             MVTable;
   bool                                 FIELDTXRaw;
   bool                                 ACPREDRaw;
   bool                                 OVERFLAGSRaw;
   bool                                 DIRECTMBRaw;
   bool                                 SKIPMBRaw;
   bool                                 MVTYPEMBRaw;
   bool                                 FORWARDMBRaw;
   bool                                 BitplaneBufferPresent;
};

static inline __attribute__((always_inline)) void
GFX20_MFD_VC1_LONG_PIC_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                                  __attribute__((unused)) void * restrict dst,
                                  __attribute__((unused)) const struct GFX20_MFD_VC1_LONG_PIC_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpcode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->PictureWidthInMBs, 0, 7) |
      util_bitpack_uint(values->PictureHeightInMBs, 16, 23);

   dw[2] =
      util_bitpack_uint(values->VC1Profile, 0, 0) |
      util_bitpack_uint(values->SecondField, 3, 3) |
      util_bitpack_uint(values->OverlapSmoothingEnable, 4, 4) |
      util_bitpack_uint(values->LoopFilterEnable, 5, 5) |
      util_bitpack_uint(values->RangeReductionEnable, 6, 6) |
      util_bitpack_uint(values->RangeReductionScale, 7, 7) |
      util_bitpack_uint(values->MVMode, 8, 11) |
      util_bitpack_uint(values->SyncMarker, 12, 12) |
      util_bitpack_uint(values->InterpolationRounderControl, 13, 13) |
      util_bitpack_uint(values->ImplicitQuantizer, 14, 14) |
      util_bitpack_uint(values->DMVSurfaceValid, 15, 15) |
      util_bitpack_uint(values->BitplaneBufferPitch, 24, 31);

   dw[3] =
      util_bitpack_uint(values->BScaleFactor, 0, 7) |
      util_bitpack_uint(values->PQValue, 8, 12) |
      util_bitpack_uint(values->AlternativePQValue, 16, 20) |
      util_bitpack_uint(values->FrameCodingMode, 24, 25) |
      util_bitpack_uint(values->PictureType, 26, 28) |
      util_bitpack_uint(values->CONDOVER, 29, 30);

   dw[4] =
      util_bitpack_uint(values->PQUniform, 0, 0) |
      util_bitpack_uint(values->HalfQP, 1, 1) |
      util_bitpack_uint(values->AlternativePQConfiguration, 2, 3) |
      util_bitpack_uint(values->AlternativePQEdgeMask, 4, 7) |
      util_bitpack_uint(values->ExtendedMVRange, 8, 9) |
      util_bitpack_uint(values->ExtendedDMVRange, 10, 11) |
      util_bitpack_uint(values->ForwardReferenceDistance, 16, 19) |
      util_bitpack_uint(values->BackwardReferenceDistance, 20, 23) |
      util_bitpack_uint(values->NumberofReferences, 24, 24) |
      util_bitpack_uint(values->ReferenceFieldPicturePolarity, 25, 25) |
      util_bitpack_uint(values->FastUVMotionCompensation, 26, 26) |
      util_bitpack_uint(values->FourMVSwitch, 27, 27) |
      util_bitpack_uint(values->UnifiedMVMode, 28, 29);

   dw[5] =
      util_bitpack_uint(values->CodedBlockPatternTable, 0, 2) |
      util_bitpack_uint(values->IntraTransformDCTable, 3, 3) |
      util_bitpack_uint(values->PicturelevelTransformChromaACCodingSetIndex, 4, 5) |
      util_bitpack_uint(values->PicturelevelTransformLumaACCodingSetIndex, 6, 7) |
      util_bitpack_uint(values->MBModeTable, 8, 10) |
      util_bitpack_uint(values->MBTransformType, 11, 11) |
      util_bitpack_uint(values->PicturelevelTransformType, 12, 13) |
      util_bitpack_uint(values->_2MVBlockPatternTable, 16, 17) |
      util_bitpack_uint(values->_4MVBlockPatternTable, 18, 19) |
      util_bitpack_uint(values->MVTable, 20, 22) |
      util_bitpack_uint(values->FIELDTXRaw, 24, 24) |
      util_bitpack_uint(values->ACPREDRaw, 25, 25) |
      util_bitpack_uint(values->OVERFLAGSRaw, 26, 26) |
      util_bitpack_uint(values->DIRECTMBRaw, 27, 27) |
      util_bitpack_uint(values->SKIPMBRaw, 28, 28) |
      util_bitpack_uint(values->MVTYPEMBRaw, 29, 29) |
      util_bitpack_uint(values->FORWARDMBRaw, 30, 30) |
      util_bitpack_uint(values->BitplaneBufferPresent, 31, 31);
}

#define GFX20_MFD_VC1_SHORT_PIC_STATE_length      5
#define GFX20_MFD_VC1_SHORT_PIC_STATE_length_bias      2
#define GFX20_MFD_VC1_SHORT_PIC_STATE_header    \
   .DWordLength                         =      3,  \
   .SubOpcodeB                          =      0,  \
   .SubOpcodeA                          =      1,  \
   .MediaCommandOpcode                  =      2,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFD_VC1_SHORT_PIC_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             PictureWidth;
   uint32_t                             PictureHeight;
   uint32_t                             PictureStructure;
   bool                                 SecondField;
   bool                                 IntraPicture;
   bool                                 BackwardPredictionPresent;
   uint32_t                             VC1Profile;
#define SimpleMainProfile                        0
#define AdvancedProfile                          1
   bool                                 DMVSurfaceValid;
   uint32_t                             MVMode;
   bool                                 InterpolationRounderControl;
   uint32_t                             BitplaneBufferPitch;
   bool                                 variablesizedtransformcoding;
   uint32_t                             DQUANT;
   bool                                 EXTENDED_MVPresent;
   uint32_t                             FastUVMotionCompensation;
#define NoRounding                               0
#define QuarterPeloffsetstoHalfFullpelpositions  1
   bool                                 LoopFilterEnable;
   bool                                 REFDIST_FLAG;
   bool                                 PANSCANPresent;
   uint32_t                             MAXBFRAMES;
   bool                                 RANGEREDPresent;
   bool                                 SYNCMARKERPresent;
   bool                                 MULTIRESPresent;
   uint32_t                             QUANTIZER;
   uint32_t                             PPicRefDistance;
   uint32_t                             ProgressivePicType;
   uint32_t                             RangeReductionEnable;
   uint32_t                             RangeReductionScale;
   bool                                 OverlapSmoothingEnable;
   bool                                 EXTENDED_DMVPresent;
   bool                                 PSF;
   bool                                 REFPIC;
   bool                                 FINTERFLAG;
   bool                                 TFCNTRFLAG;
   bool                                 INTERLACE;
   bool                                 PULLDOWN;
   bool                                 POSTPROC;
   bool                                 _4MVAllowed;
   uint32_t                             BFractionEnumeration;
};

static inline __attribute__((always_inline)) void
GFX20_MFD_VC1_SHORT_PIC_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                                   __attribute__((unused)) void * restrict dst,
                                   __attribute__((unused)) const struct GFX20_MFD_VC1_SHORT_PIC_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpcode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->PictureWidth, 0, 7) |
      util_bitpack_uint(values->PictureHeight, 16, 23);

   dw[2] =
      util_bitpack_uint(values->PictureStructure, 0, 1) |
      util_bitpack_uint(values->SecondField, 3, 3) |
      util_bitpack_uint(values->IntraPicture, 4, 4) |
      util_bitpack_uint(values->BackwardPredictionPresent, 5, 5) |
      util_bitpack_uint(values->VC1Profile, 11, 11) |
      util_bitpack_uint(values->DMVSurfaceValid, 15, 15) |
      util_bitpack_uint(values->MVMode, 16, 19) |
      util_bitpack_uint(values->InterpolationRounderControl, 23, 23) |
      util_bitpack_uint(values->BitplaneBufferPitch, 24, 31);

   dw[3] =
      util_bitpack_uint(values->variablesizedtransformcoding, 0, 0) |
      util_bitpack_uint(values->DQUANT, 1, 2) |
      util_bitpack_uint(values->EXTENDED_MVPresent, 3, 3) |
      util_bitpack_uint(values->FastUVMotionCompensation, 4, 4) |
      util_bitpack_uint(values->LoopFilterEnable, 5, 5) |
      util_bitpack_uint(values->REFDIST_FLAG, 6, 6) |
      util_bitpack_uint(values->PANSCANPresent, 7, 7) |
      util_bitpack_uint(values->MAXBFRAMES, 8, 10) |
      util_bitpack_uint(values->RANGEREDPresent, 11, 11) |
      util_bitpack_uint(values->SYNCMARKERPresent, 12, 12) |
      util_bitpack_uint(values->MULTIRESPresent, 13, 13) |
      util_bitpack_uint(values->QUANTIZER, 14, 15) |
      util_bitpack_uint(values->PPicRefDistance, 16, 20) |
      util_bitpack_uint(values->ProgressivePicType, 22, 23) |
      util_bitpack_uint(values->RangeReductionEnable, 28, 28) |
      util_bitpack_uint(values->RangeReductionScale, 29, 29) |
      util_bitpack_uint(values->OverlapSmoothingEnable, 30, 30);

   dw[4] =
      util_bitpack_uint(values->EXTENDED_DMVPresent, 0, 0) |
      util_bitpack_uint(values->PSF, 1, 1) |
      util_bitpack_uint(values->REFPIC, 2, 2) |
      util_bitpack_uint(values->FINTERFLAG, 3, 3) |
      util_bitpack_uint(values->TFCNTRFLAG, 4, 4) |
      util_bitpack_uint(values->INTERLACE, 5, 5) |
      util_bitpack_uint(values->PULLDOWN, 6, 6) |
      util_bitpack_uint(values->POSTPROC, 7, 7) |
      util_bitpack_uint(values->_4MVAllowed, 8, 8) |
      util_bitpack_uint(values->BFractionEnumeration, 24, 28);
}

#define GFX20_MFD_VP8_BSD_OBJECT_length       22
#define GFX20_MFD_VP8_BSD_OBJECT_length_bias      2
#define GFX20_MFD_VP8_BSD_OBJECT_header         \
   .DWordLength                         =     20,  \
   .SubOpcodeB                          =      8,  \
   .SubOpcodeA                          =      1,  \
   .MediaCommandOpCode                  =      4,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFD_VP8_BSD_OBJECT {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpCode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             Partition0FirstMBBitOffsetfromFrameHeader;
   uint32_t                             CodedNumofCoeffTokenPartitions;
   uint32_t                             Partition0CPBACEntropyRange;
   uint32_t                             Partition0CPBACEntropyCount;
   uint32_t                             Partition0CPBACEntropyValue;
   uint32_t                             IndirectPartition0DataLength;
   uint32_t                             IndirectPartition0DataStartOffset;
   uint32_t                             IndirectPartition1DataLength;
   uint32_t                             IndirectPartition1DataStartOffset;
   uint32_t                             IndirectPartition2DataLength;
   uint32_t                             IndirectPartition2DataStartOffset;
   uint32_t                             IndirectPartition3DataLength;
   uint32_t                             IndirectPartition3DataStartOffset;
   uint32_t                             IndirectPartition4DataLength;
   uint32_t                             IndirectPartition4DataStartOffset;
   uint32_t                             IndirectPartition5DataLength;
   uint32_t                             IndirectPartition5DataStartOffset;
   uint32_t                             IndirectPartition6DataLength;
   uint32_t                             IndirectPartition6DataStartOffset;
   uint32_t                             IndirectPartition7DataLength;
   uint32_t                             IndirectPartition7DataStartOffset;
   uint32_t                             IndirectPartition8DataLength;
   uint32_t                             IndirectPartition8DataStartOffset;
   uint32_t                             MBHeaderErrorHandling;
   uint32_t                             EntropyErrorHandling;
   uint32_t                             MPRErrorMVoutofrangeHandling;
   uint32_t                             BSDPrematureCompleteErrorHandling;
   uint32_t                             ConcealmentPictureID;
   uint32_t                             ConcealmentMethod;
#define Intra16x16Prediction                     0
#define InterPCopy                               1
};

static inline __attribute__((always_inline)) void
GFX20_MFD_VP8_BSD_OBJECT_pack(__attribute__((unused)) __gen_user_data *data,
                              __attribute__((unused)) void * restrict dst,
                              __attribute__((unused)) const struct GFX20_MFD_VP8_BSD_OBJECT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpCode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->Partition0FirstMBBitOffsetfromFrameHeader, 0, 2) |
      util_bitpack_uint(values->CodedNumofCoeffTokenPartitions, 4, 5) |
      util_bitpack_uint(values->Partition0CPBACEntropyRange, 8, 15) |
      util_bitpack_uint(values->Partition0CPBACEntropyCount, 16, 20);

   dw[2] =
      util_bitpack_uint(values->Partition0CPBACEntropyValue, 24, 31);

   dw[3] =
      util_bitpack_uint(values->IndirectPartition0DataLength, 0, 23);

   dw[4] =
      util_bitpack_uint(values->IndirectPartition0DataStartOffset, 0, 31);

   dw[5] =
      util_bitpack_uint(values->IndirectPartition1DataLength, 0, 23);

   dw[6] =
      util_bitpack_uint(values->IndirectPartition1DataStartOffset, 0, 31);

   dw[7] =
      util_bitpack_uint(values->IndirectPartition2DataLength, 0, 23);

   dw[8] =
      util_bitpack_uint(values->IndirectPartition2DataStartOffset, 0, 31);

   dw[9] =
      util_bitpack_uint(values->IndirectPartition3DataLength, 0, 23);

   dw[10] =
      util_bitpack_uint(values->IndirectPartition3DataStartOffset, 0, 31);

   dw[11] =
      util_bitpack_uint(values->IndirectPartition4DataLength, 0, 23);

   dw[12] =
      util_bitpack_uint(values->IndirectPartition4DataStartOffset, 0, 31);

   dw[13] =
      util_bitpack_uint(values->IndirectPartition5DataLength, 0, 23);

   dw[14] =
      util_bitpack_uint(values->IndirectPartition5DataStartOffset, 0, 31);

   dw[15] =
      util_bitpack_uint(values->IndirectPartition6DataLength, 0, 23);

   dw[16] =
      util_bitpack_uint(values->IndirectPartition6DataStartOffset, 0, 31);

   dw[17] =
      util_bitpack_uint(values->IndirectPartition7DataLength, 0, 23);

   dw[18] =
      util_bitpack_uint(values->IndirectPartition7DataStartOffset, 0, 31);

   dw[19] =
      util_bitpack_uint(values->IndirectPartition8DataLength, 0, 23);

   dw[20] =
      util_bitpack_uint(values->IndirectPartition8DataStartOffset, 0, 31);

   dw[21] =
      util_bitpack_uint(values->MBHeaderErrorHandling, 8, 8) |
      util_bitpack_uint(values->EntropyErrorHandling, 10, 10) |
      util_bitpack_uint(values->MPRErrorMVoutofrangeHandling, 12, 12) |
      util_bitpack_uint(values->BSDPrematureCompleteErrorHandling, 14, 14) |
      util_bitpack_uint(values->ConcealmentPictureID, 16, 17) |
      util_bitpack_uint(values->ConcealmentMethod, 31, 31);
}

#define GFX20_MFX_AVC_DIRECTMODE_STATE_length     71
#define GFX20_MFX_AVC_DIRECTMODE_STATE_length_bias      2
#define GFX20_MFX_AVC_DIRECTMODE_STATE_header   \
   .DWordLength                         =     69,  \
   .SubOpcodeB                          =      2,  \
   .SubOpcodeA                          =      0,  \
   .MediaCommandOpcode                  =      1,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFX_AVC_DIRECTMODE_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   __gen_address_type                   DirectMVBufferAddress[16];
   struct GFX20_MEMORYADDRESSATTRIBUTES DirectMVBufferAttributes;
   __gen_address_type                   DirectMVBufferWriteAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES DirectMVBufferWriteAttributes;
   uint32_t                             POCList[34];
};

static inline __attribute__((always_inline)) void
GFX20_MFX_AVC_DIRECTMODE_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                                    __attribute__((unused)) void * restrict dst,
                                    __attribute__((unused)) const struct GFX20_MFX_AVC_DIRECTMODE_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpcode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   const uint64_t v1_address =
      __gen_address(data, &dw[1], values->DirectMVBufferAddress[0], 0, 0, 63);
   dw[1] = v1_address;
   dw[2] = v1_address >> 32;

   const uint64_t v3_address =
      __gen_address(data, &dw[3], values->DirectMVBufferAddress[1], 0, 0, 63);
   dw[3] = v3_address;
   dw[4] = v3_address >> 32;

   const uint64_t v5_address =
      __gen_address(data, &dw[5], values->DirectMVBufferAddress[2], 0, 0, 63);
   dw[5] = v5_address;
   dw[6] = v5_address >> 32;

   const uint64_t v7_address =
      __gen_address(data, &dw[7], values->DirectMVBufferAddress[3], 0, 0, 63);
   dw[7] = v7_address;
   dw[8] = v7_address >> 32;

   const uint64_t v9_address =
      __gen_address(data, &dw[9], values->DirectMVBufferAddress[4], 0, 0, 63);
   dw[9] = v9_address;
   dw[10] = v9_address >> 32;

   const uint64_t v11_address =
      __gen_address(data, &dw[11], values->DirectMVBufferAddress[5], 0, 0, 63);
   dw[11] = v11_address;
   dw[12] = v11_address >> 32;

   const uint64_t v13_address =
      __gen_address(data, &dw[13], values->DirectMVBufferAddress[6], 0, 0, 63);
   dw[13] = v13_address;
   dw[14] = v13_address >> 32;

   const uint64_t v15_address =
      __gen_address(data, &dw[15], values->DirectMVBufferAddress[7], 0, 0, 63);
   dw[15] = v15_address;
   dw[16] = v15_address >> 32;

   const uint64_t v17_address =
      __gen_address(data, &dw[17], values->DirectMVBufferAddress[8], 0, 0, 63);
   dw[17] = v17_address;
   dw[18] = v17_address >> 32;

   const uint64_t v19_address =
      __gen_address(data, &dw[19], values->DirectMVBufferAddress[9], 0, 0, 63);
   dw[19] = v19_address;
   dw[20] = v19_address >> 32;

   const uint64_t v21_address =
      __gen_address(data, &dw[21], values->DirectMVBufferAddress[10], 0, 0, 63);
   dw[21] = v21_address;
   dw[22] = v21_address >> 32;

   const uint64_t v23_address =
      __gen_address(data, &dw[23], values->DirectMVBufferAddress[11], 0, 0, 63);
   dw[23] = v23_address;
   dw[24] = v23_address >> 32;

   const uint64_t v25_address =
      __gen_address(data, &dw[25], values->DirectMVBufferAddress[12], 0, 0, 63);
   dw[25] = v25_address;
   dw[26] = v25_address >> 32;

   const uint64_t v27_address =
      __gen_address(data, &dw[27], values->DirectMVBufferAddress[13], 0, 0, 63);
   dw[27] = v27_address;
   dw[28] = v27_address >> 32;

   const uint64_t v29_address =
      __gen_address(data, &dw[29], values->DirectMVBufferAddress[14], 0, 0, 63);
   dw[29] = v29_address;
   dw[30] = v29_address >> 32;

   const uint64_t v31_address =
      __gen_address(data, &dw[31], values->DirectMVBufferAddress[15], 0, 0, 63);
   dw[31] = v31_address;
   dw[32] = v31_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[33], &values->DirectMVBufferAttributes);

   const uint64_t v34_address =
      __gen_address(data, &dw[34], values->DirectMVBufferWriteAddress, 0, 0, 63);
   dw[34] = v34_address;
   dw[35] = v34_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[36], &values->DirectMVBufferWriteAttributes);

   dw[37] =
      util_bitpack_uint(values->POCList[0], 0, 31);

   dw[38] =
      util_bitpack_uint(values->POCList[1], 0, 31);

   dw[39] =
      util_bitpack_uint(values->POCList[2], 0, 31);

   dw[40] =
      util_bitpack_uint(values->POCList[3], 0, 31);

   dw[41] =
      util_bitpack_uint(values->POCList[4], 0, 31);

   dw[42] =
      util_bitpack_uint(values->POCList[5], 0, 31);

   dw[43] =
      util_bitpack_uint(values->POCList[6], 0, 31);

   dw[44] =
      util_bitpack_uint(values->POCList[7], 0, 31);

   dw[45] =
      util_bitpack_uint(values->POCList[8], 0, 31);

   dw[46] =
      util_bitpack_uint(values->POCList[9], 0, 31);

   dw[47] =
      util_bitpack_uint(values->POCList[10], 0, 31);

   dw[48] =
      util_bitpack_uint(values->POCList[11], 0, 31);

   dw[49] =
      util_bitpack_uint(values->POCList[12], 0, 31);

   dw[50] =
      util_bitpack_uint(values->POCList[13], 0, 31);

   dw[51] =
      util_bitpack_uint(values->POCList[14], 0, 31);

   dw[52] =
      util_bitpack_uint(values->POCList[15], 0, 31);

   dw[53] =
      util_bitpack_uint(values->POCList[16], 0, 31);

   dw[54] =
      util_bitpack_uint(values->POCList[17], 0, 31);

   dw[55] =
      util_bitpack_uint(values->POCList[18], 0, 31);

   dw[56] =
      util_bitpack_uint(values->POCList[19], 0, 31);

   dw[57] =
      util_bitpack_uint(values->POCList[20], 0, 31);

   dw[58] =
      util_bitpack_uint(values->POCList[21], 0, 31);

   dw[59] =
      util_bitpack_uint(values->POCList[22], 0, 31);

   dw[60] =
      util_bitpack_uint(values->POCList[23], 0, 31);

   dw[61] =
      util_bitpack_uint(values->POCList[24], 0, 31);

   dw[62] =
      util_bitpack_uint(values->POCList[25], 0, 31);

   dw[63] =
      util_bitpack_uint(values->POCList[26], 0, 31);

   dw[64] =
      util_bitpack_uint(values->POCList[27], 0, 31);

   dw[65] =
      util_bitpack_uint(values->POCList[28], 0, 31);

   dw[66] =
      util_bitpack_uint(values->POCList[29], 0, 31);

   dw[67] =
      util_bitpack_uint(values->POCList[30], 0, 31);

   dw[68] =
      util_bitpack_uint(values->POCList[31], 0, 31);

   dw[69] =
      util_bitpack_uint(values->POCList[32], 0, 31);

   dw[70] =
      util_bitpack_uint(values->POCList[33], 0, 31);
}

#define GFX20_MFX_AVC_IMG_STATE_length        21
#define GFX20_MFX_AVC_IMG_STATE_length_bias      2
#define GFX20_MFX_AVC_IMG_STATE_header          \
   .DWordLength                         =     19,  \
   .SubOpcodeB                          =      0,  \
   .SubOpcodeA                          =      0,  \
   .MediaCommandOpcode                  =      1,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFX_AVC_IMG_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             FrameSize;
   uint32_t                             FrameWidth;
   uint32_t                             FrameHeight;
   uint32_t                             ImageStructure;
#define FramePicture                             0
#define TopFieldPicture                          1
#define BottomFieldPicture                       3
#define Invalidnotallowed                        2
   uint32_t                             WeightedBiPredictionIDC;
#define DEFAULT                                  0
#define EXPLICIT                                 1
#define IMPLICIT                                 2
   bool                                 WeightedPredictionEnable;
   bool                                 RhoDomainRateControlEnable;
   int32_t                              FirstChromaQPOffset;
   int32_t                              SecondChromaQPOffset;
   bool                                 FieldPicture;
   bool                                 MBAFFMode;
   bool                                 FrameMBOnly;
   bool                                 _8x8IDCTTransformMode;
   bool                                 Direct8x8Inference;
   bool                                 ConstrainedIntraPrediction;
   bool                                 NonReferencePicture;
   bool                                 EntropyCodingSyncEnable;
   uint32_t                             MBMVFormat;
#define IGNORE                                   0
#define FOLLOW                                   1
   uint32_t                             ChromaFormatIDC;
#define Monochromepicture                        0
#define _420picture                              1
#define _422picturenotsupported                  2
#define _444picturenotsupported                  3
   bool                                 MVUnpackedEnable;
   bool                                 LoadBitstreamPointerPerSlice;
   bool                                 MBStatusRead;
   uint32_t                             MinimumFrameSize;
   bool                                 IntraMBMaxBitControl;
   bool                                 InterMBMaxBitControl;
   bool                                 FrameBitrateMaxReport;
   bool                                 FrameBitrateMinReport;
   bool                                 ForceIPCMControl;
   bool                                 MBLevelRateControl;
   uint32_t                             MinimumFrameSizeUnits;
#define AVC_MFSU_Compatibilitymode               0
#define AVC_MFSU_16bytes                         1
#define AVC_MFSU_4Kb                             2
#define AVC_MFSU_16Kb                            3
   uint32_t                             NonFirstPass;
   bool                                 TrellisQuantizationChromaDisable;
   uint32_t                             TrellisQuantizationRounding;
   bool                                 TrellisQuantizationEnable;
   uint32_t                             IntraMBConformanceMaxSize;
   uint32_t                             InterMBConformanceMaxSize;
   int32_t                              SliceDeltaQPMax0;
   int32_t                              SliceDeltaQPMax1;
   uint32_t                             SliceDeltaQPMax2;
   int32_t                              SliceDeltaQPMax3;
   int32_t                              SliceDeltaQPMin0;
   int32_t                              SliceDeltaQPMin1;
   int32_t                              SliceDeltaQPMin2;
   int32_t                              SliceDeltaQPMin3;
   uint32_t                             FrameBitrateMin;
   uint32_t                             FrameBitrateMinUnitMode;
#define Compatibilitymode                        0
#define Newmode                                  1
   uint32_t                             FrameBitrateMinUnit;
   uint32_t                             FrameBitrateMax;
   uint32_t                             FrameBitrateMaxUnitMode;
#define Compatibilitymode                        0
#define Newmode                                  1
   uint32_t                             FrameBitrateMaxUnit;
   uint32_t                             FrameBitrateMinDelta;
   uint32_t                             FrameBitrateMaxDelta;
   bool                                 SliceStatsStreamOutEnable;
   int32_t                              InitialQPValue;
   uint32_t                             NumberofActiveReferencePicturesfromL0;
   uint32_t                             NumberofActiveReferencePicturesfromL1;
   uint32_t                             NumberofReferenceFrames;
   bool                                 CurrentPictureHasPerformedMMCO5;
   bool                                 PicOrderPresent;
   bool                                 DeltaPicOrderAlwaysZero;
   uint32_t                             PicOrderCountType;
   uint32_t                             SliceGroupMapType;
   bool                                 RedundantPicCountPresent;
   uint32_t                             NumberofSliceGroups;
   bool                                 DeblockingFilterControlPresent;
   uint32_t                             Log2MaxFrameNumber;
   uint32_t                             Log2MaxPicOrderCountLSB;
   uint32_t                             SliceGroupChangeRate;
   uint32_t                             CurrentPictureFrameNumber;
   uint32_t                             CurrentFrameViewID;
   uint32_t                             MaxViewIDXL0;
   uint32_t                             MaxViewIDXL1;
   bool                                 InterViewOrderDisable;
   uint32_t                             FractionalQPInput;
   uint32_t                             FractionalQPOffset;
   bool                                 ExtendedRhoDomainStatisticsEnable;
   uint32_t                             RhoDomainAverageMBQP;
   uint32_t                             ThresholdSize;
   uint32_t                             TargetSliceSize;
};

static inline __attribute__((always_inline)) void
GFX20_MFX_AVC_IMG_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                             __attribute__((unused)) void * restrict dst,
                             __attribute__((unused)) const struct GFX20_MFX_AVC_IMG_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpcode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->FrameSize, 0, 15);

   dw[2] =
      util_bitpack_uint(values->FrameWidth, 0, 7) |
      util_bitpack_uint(values->FrameHeight, 16, 23);

   dw[3] =
      util_bitpack_uint(values->ImageStructure, 8, 9) |
      util_bitpack_uint(values->WeightedBiPredictionIDC, 10, 11) |
      util_bitpack_uint(values->WeightedPredictionEnable, 12, 12) |
      util_bitpack_uint(values->RhoDomainRateControlEnable, 13, 13) |
      util_bitpack_sint(values->FirstChromaQPOffset, 16, 20) |
      util_bitpack_sint(values->SecondChromaQPOffset, 24, 28);

   dw[4] =
      util_bitpack_uint(values->FieldPicture, 0, 0) |
      util_bitpack_uint(values->MBAFFMode, 1, 1) |
      util_bitpack_uint(values->FrameMBOnly, 2, 2) |
      util_bitpack_uint(values->_8x8IDCTTransformMode, 3, 3) |
      util_bitpack_uint(values->Direct8x8Inference, 4, 4) |
      util_bitpack_uint(values->ConstrainedIntraPrediction, 5, 5) |
      util_bitpack_uint(values->NonReferencePicture, 6, 6) |
      util_bitpack_uint(values->EntropyCodingSyncEnable, 7, 7) |
      util_bitpack_uint(values->MBMVFormat, 8, 8) |
      util_bitpack_uint(values->ChromaFormatIDC, 10, 11) |
      util_bitpack_uint(values->MVUnpackedEnable, 12, 12) |
      util_bitpack_uint(values->LoadBitstreamPointerPerSlice, 14, 14) |
      util_bitpack_uint(values->MBStatusRead, 15, 15) |
      util_bitpack_uint(values->MinimumFrameSize, 16, 31);

   dw[5] =
      util_bitpack_uint(values->IntraMBMaxBitControl, 0, 0) |
      util_bitpack_uint(values->InterMBMaxBitControl, 1, 1) |
      util_bitpack_uint(values->FrameBitrateMaxReport, 2, 2) |
      util_bitpack_uint(values->FrameBitrateMinReport, 3, 3) |
      util_bitpack_uint(values->ForceIPCMControl, 7, 7) |
      util_bitpack_uint(values->MBLevelRateControl, 9, 9) |
      util_bitpack_uint(values->MinimumFrameSizeUnits, 10, 11) |
      util_bitpack_uint(values->NonFirstPass, 16, 16) |
      util_bitpack_uint(values->TrellisQuantizationChromaDisable, 27, 27) |
      util_bitpack_uint(values->TrellisQuantizationRounding, 28, 30) |
      util_bitpack_uint(values->TrellisQuantizationEnable, 31, 31);

   dw[6] =
      util_bitpack_uint(values->IntraMBConformanceMaxSize, 0, 11) |
      util_bitpack_uint(values->InterMBConformanceMaxSize, 16, 27);

   dw[7] = 0;

   dw[8] =
      util_bitpack_sint(values->SliceDeltaQPMax0, 0, 7) |
      util_bitpack_sint(values->SliceDeltaQPMax1, 8, 15) |
      util_bitpack_uint(values->SliceDeltaQPMax2, 16, 23) |
      util_bitpack_sint(values->SliceDeltaQPMax3, 24, 31);

   dw[9] =
      util_bitpack_sint(values->SliceDeltaQPMin0, 0, 7) |
      util_bitpack_sint(values->SliceDeltaQPMin1, 8, 15) |
      util_bitpack_sint(values->SliceDeltaQPMin2, 16, 23) |
      util_bitpack_sint(values->SliceDeltaQPMin3, 24, 31);

   dw[10] =
      util_bitpack_uint(values->FrameBitrateMin, 0, 13) |
      util_bitpack_uint(values->FrameBitrateMinUnitMode, 14, 14) |
      util_bitpack_uint(values->FrameBitrateMinUnit, 15, 15) |
      util_bitpack_uint(values->FrameBitrateMax, 16, 29) |
      util_bitpack_uint(values->FrameBitrateMaxUnitMode, 30, 30) |
      util_bitpack_uint(values->FrameBitrateMaxUnit, 31, 31);

   dw[11] =
      util_bitpack_uint(values->FrameBitrateMinDelta, 0, 14) |
      util_bitpack_uint(values->FrameBitrateMaxDelta, 16, 30) |
      util_bitpack_uint(values->SliceStatsStreamOutEnable, 31, 31);

   dw[12] = 0;

   dw[13] =
      util_bitpack_sint(values->InitialQPValue, 0, 7) |
      util_bitpack_uint(values->NumberofActiveReferencePicturesfromL0, 8, 13) |
      util_bitpack_uint(values->NumberofActiveReferencePicturesfromL1, 16, 21) |
      util_bitpack_uint(values->NumberofReferenceFrames, 24, 28) |
      util_bitpack_uint(values->CurrentPictureHasPerformedMMCO5, 29, 29);

   dw[14] =
      util_bitpack_uint(values->PicOrderPresent, 0, 0) |
      util_bitpack_uint(values->DeltaPicOrderAlwaysZero, 1, 1) |
      util_bitpack_uint(values->PicOrderCountType, 2, 3) |
      util_bitpack_uint(values->SliceGroupMapType, 8, 10) |
      util_bitpack_uint(values->RedundantPicCountPresent, 11, 11) |
      util_bitpack_uint(values->NumberofSliceGroups, 12, 14) |
      util_bitpack_uint(values->DeblockingFilterControlPresent, 15, 15) |
      util_bitpack_uint(values->Log2MaxFrameNumber, 16, 23) |
      util_bitpack_uint(values->Log2MaxPicOrderCountLSB, 24, 31);

   dw[15] =
      util_bitpack_uint(values->SliceGroupChangeRate, 0, 15) |
      util_bitpack_uint(values->CurrentPictureFrameNumber, 16, 31);

   dw[16] =
      util_bitpack_uint(values->CurrentFrameViewID, 0, 9) |
      util_bitpack_uint(values->MaxViewIDXL0, 12, 15) |
      util_bitpack_uint(values->MaxViewIDXL1, 18, 21) |
      util_bitpack_uint(values->InterViewOrderDisable, 31, 31);

   dw[17] =
      util_bitpack_uint(values->FractionalQPInput, 0, 2) |
      util_bitpack_uint(values->FractionalQPOffset, 3, 5) |
      util_bitpack_uint(values->ExtendedRhoDomainStatisticsEnable, 8, 8) |
      util_bitpack_uint(values->RhoDomainAverageMBQP, 16, 21);

   dw[18] = 0;

   dw[19] =
      util_bitpack_uint(values->ThresholdSize, 0, 31);

   dw[20] =
      util_bitpack_uint(values->TargetSliceSize, 0, 31);
}

#define GFX20_MFX_AVC_REF_IDX_STATE_length     10
#define GFX20_MFX_AVC_REF_IDX_STATE_length_bias      2
#define GFX20_MFX_AVC_REF_IDX_STATE_header      \
   .DWordLength                         =      8,  \
   .SubOpcodeB                          =      4,  \
   .SubOpcodeA                          =      0,  \
   .MediaCommandOpcode                  =      1,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFX_AVC_REF_IDX_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             ReferencePictureListSelect;
   uint32_t                             ReferenceListEntry[32];
};

static inline __attribute__((always_inline)) void
GFX20_MFX_AVC_REF_IDX_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                                 __attribute__((unused)) void * restrict dst,
                                 __attribute__((unused)) const struct GFX20_MFX_AVC_REF_IDX_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpcode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->ReferencePictureListSelect, 0, 0);

   dw[2] =
      util_bitpack_uint(values->ReferenceListEntry[0], 0, 7) |
      util_bitpack_uint(values->ReferenceListEntry[1], 8, 15) |
      util_bitpack_uint(values->ReferenceListEntry[2], 16, 23) |
      util_bitpack_uint(values->ReferenceListEntry[3], 24, 31);

   dw[3] =
      util_bitpack_uint(values->ReferenceListEntry[4], 0, 7) |
      util_bitpack_uint(values->ReferenceListEntry[5], 8, 15) |
      util_bitpack_uint(values->ReferenceListEntry[6], 16, 23) |
      util_bitpack_uint(values->ReferenceListEntry[7], 24, 31);

   dw[4] =
      util_bitpack_uint(values->ReferenceListEntry[8], 0, 7) |
      util_bitpack_uint(values->ReferenceListEntry[9], 8, 15) |
      util_bitpack_uint(values->ReferenceListEntry[10], 16, 23) |
      util_bitpack_uint(values->ReferenceListEntry[11], 24, 31);

   dw[5] =
      util_bitpack_uint(values->ReferenceListEntry[12], 0, 7) |
      util_bitpack_uint(values->ReferenceListEntry[13], 8, 15) |
      util_bitpack_uint(values->ReferenceListEntry[14], 16, 23) |
      util_bitpack_uint(values->ReferenceListEntry[15], 24, 31);

   dw[6] =
      util_bitpack_uint(values->ReferenceListEntry[16], 0, 7) |
      util_bitpack_uint(values->ReferenceListEntry[17], 8, 15) |
      util_bitpack_uint(values->ReferenceListEntry[18], 16, 23) |
      util_bitpack_uint(values->ReferenceListEntry[19], 24, 31);

   dw[7] =
      util_bitpack_uint(values->ReferenceListEntry[20], 0, 7) |
      util_bitpack_uint(values->ReferenceListEntry[21], 8, 15) |
      util_bitpack_uint(values->ReferenceListEntry[22], 16, 23) |
      util_bitpack_uint(values->ReferenceListEntry[23], 24, 31);

   dw[8] =
      util_bitpack_uint(values->ReferenceListEntry[24], 0, 7) |
      util_bitpack_uint(values->ReferenceListEntry[25], 8, 15) |
      util_bitpack_uint(values->ReferenceListEntry[26], 16, 23) |
      util_bitpack_uint(values->ReferenceListEntry[27], 24, 31);

   dw[9] =
      util_bitpack_uint(values->ReferenceListEntry[28], 0, 7) |
      util_bitpack_uint(values->ReferenceListEntry[29], 8, 15) |
      util_bitpack_uint(values->ReferenceListEntry[30], 16, 23) |
      util_bitpack_uint(values->ReferenceListEntry[31], 24, 31);
}

#define GFX20_MFX_AVC_SLICE_STATE_length      10
#define GFX20_MFX_AVC_SLICE_STATE_length_bias      2
#define GFX20_MFX_AVC_SLICE_STATE_header        \
   .DWordLength                         =      8,  \
   .SubOpcodeB                          =      3,  \
   .SubOpcodeA                          =      0,  \
   .MediaCommandOpcode                  =      1,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFX_AVC_SLICE_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             SliceType;
#define AVC_ST_PSlice                            0
#define AVC_ST_BSlice                            1
#define AVC_ST_ISlice                            2
   uint32_t                             Log2WeightDenominatorLuma;
   uint32_t                             Log2WeightDenominatorChroma;
   uint32_t                             NumberofReferencePicturesinInterpredictionList0;
   uint32_t                             NumberofReferencePicturesinInterpredictionList1;
   int32_t                              SliceAlphaC0OffsetDiv2;
   int32_t                              SliceBetaOffsetDiv2;
   uint32_t                             SliceQuantizationParameter;
   uint32_t                             CABACInitIDC;
   uint32_t                             DisableDeblockingFilterIndicator;
   uint32_t                             DirectPredictionType;
#define Temporal                                 0
#define Spatial                                  1
   uint32_t                             WeightedPredictionIndicator;
   uint32_t                             SliceStartMBNumber;
   uint32_t                             SliceHorizontalPosition;
   uint32_t                             SliceVerticalPosition;
   uint32_t                             NextSliceHorizontalPosition;
   uint32_t                             NextSliceVerticalPosition;
   uint32_t                             StreamID;
   uint32_t                             SliceID;
   bool                                 CABACZeroWordInsertionEnable;
   bool                                 EmulationByteSliceInsertEnable;
   bool                                 TailInsertionPresent;
   bool                                 SliceDataInsertionPresent;
   bool                                 HeaderInsertionPresent;
   bool                                 LastSliceGroup;
   bool                                 MBTypeSkipConversionDisable;
   bool                                 MBTypeDirectConversionDisable;
   uint32_t                             RateControlPanicType;
#define QPPanic                                  0
#define CBPPanic                                 1
   bool                                 RateControlPanicEnable;
   uint32_t                             RateControlStableTolerance;
   uint32_t                             RateControlTriggleMode;
#define AlwaysRateControl                        0
#define GentleRateControl                        1
#define LooseRateControl                         2
   bool                                 ResetRateControlCounter;
   uint32_t                             RateControlCounterEnable;
   uint64_t                             IndirectPAKBSEDataStartAddress;
   uint32_t                             GrowInit;
   uint32_t                             GrowResistance;
   uint32_t                             ShrinkInit;
   uint32_t                             ShrinkResistance;
   uint32_t                             QPMaxPositiveModifierMagnitude;
   uint32_t                             QPMaxNegativeModifierMagnitude;
   uint32_t                             Correct1;
   uint32_t                             Correct2;
   uint32_t                             Correct3;
   uint32_t                             Correct4;
   uint32_t                             Correct5;
   uint32_t                             Correct6;
   uint32_t                             RoundIntra;
#define _116                                     0
#define _216                                     1
#define _316                                     2
#define _416                                     3
#define _516                                     4
#define _616                                     5
#define _716                                     6
#define _816                                     7
   bool                                 RoundIntraEnable;
   uint32_t                             RoundInter;
#define _116                                     0
#define _216                                     1
#define _316                                     2
#define _416                                     3
#define _516                                     4
#define _616                                     5
#define _716                                     6
#define _816                                     7
   bool                                 RoundInterEnable;
   uint32_t                             CV0;
   uint32_t                             CV1;
   uint32_t                             CV2;
   uint32_t                             CV3;
   uint32_t                             CV4;
   uint32_t                             CV5;
   uint32_t                             CV6;
   uint32_t                             CV7;
};

static inline __attribute__((always_inline)) void
GFX20_MFX_AVC_SLICE_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                               __attribute__((unused)) void * restrict dst,
                               __attribute__((unused)) const struct GFX20_MFX_AVC_SLICE_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpcode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->SliceType, 0, 3);

   dw[2] =
      util_bitpack_uint(values->Log2WeightDenominatorLuma, 0, 2) |
      util_bitpack_uint(values->Log2WeightDenominatorChroma, 8, 10) |
      util_bitpack_uint(values->NumberofReferencePicturesinInterpredictionList0, 16, 21) |
      util_bitpack_uint(values->NumberofReferencePicturesinInterpredictionList1, 24, 29);

   dw[3] =
      util_bitpack_sint(values->SliceAlphaC0OffsetDiv2, 0, 3) |
      util_bitpack_sint(values->SliceBetaOffsetDiv2, 8, 11) |
      util_bitpack_uint(values->SliceQuantizationParameter, 16, 21) |
      util_bitpack_uint(values->CABACInitIDC, 24, 25) |
      util_bitpack_uint(values->DisableDeblockingFilterIndicator, 27, 28) |
      util_bitpack_uint(values->DirectPredictionType, 29, 29) |
      util_bitpack_uint(values->WeightedPredictionIndicator, 30, 31);

   dw[4] =
      util_bitpack_uint(values->SliceStartMBNumber, 0, 14) |
      util_bitpack_uint(values->SliceHorizontalPosition, 16, 23) |
      util_bitpack_uint(values->SliceVerticalPosition, 24, 31);

   dw[5] =
      util_bitpack_uint(values->NextSliceHorizontalPosition, 0, 7) |
      util_bitpack_uint(values->NextSliceVerticalPosition, 16, 23);

   dw[6] =
      util_bitpack_uint(values->StreamID, 0, 1) |
      util_bitpack_uint(values->SliceID, 4, 7) |
      util_bitpack_uint(values->CABACZeroWordInsertionEnable, 12, 12) |
      util_bitpack_uint(values->EmulationByteSliceInsertEnable, 13, 13) |
      util_bitpack_uint(values->TailInsertionPresent, 15, 15) |
      util_bitpack_uint(values->SliceDataInsertionPresent, 16, 16) |
      util_bitpack_uint(values->HeaderInsertionPresent, 17, 17) |
      util_bitpack_uint(values->LastSliceGroup, 19, 19) |
      util_bitpack_uint(values->MBTypeSkipConversionDisable, 20, 20) |
      util_bitpack_uint(values->MBTypeDirectConversionDisable, 21, 21) |
      util_bitpack_uint(values->RateControlPanicType, 22, 22) |
      util_bitpack_uint(values->RateControlPanicEnable, 23, 23) |
      util_bitpack_uint(values->RateControlStableTolerance, 24, 27) |
      util_bitpack_uint(values->RateControlTriggleMode, 28, 29) |
      util_bitpack_uint(values->ResetRateControlCounter, 30, 30) |
      util_bitpack_uint(values->RateControlCounterEnable, 31, 31);

   dw[7] =
      __gen_offset(values->IndirectPAKBSEDataStartAddress, 0, 28);

   dw[8] =
      util_bitpack_uint(values->GrowInit, 0, 3) |
      util_bitpack_uint(values->GrowResistance, 4, 7) |
      util_bitpack_uint(values->ShrinkInit, 8, 11) |
      util_bitpack_uint(values->ShrinkResistance, 12, 15) |
      util_bitpack_uint(values->QPMaxPositiveModifierMagnitude, 16, 23) |
      util_bitpack_uint(values->QPMaxNegativeModifierMagnitude, 24, 31);

   dw[9] =
      util_bitpack_uint(values->Correct1, 0, 3) |
      util_bitpack_uint(values->Correct2, 4, 7) |
      util_bitpack_uint(values->Correct3, 8, 11) |
      util_bitpack_uint(values->Correct4, 12, 15) |
      util_bitpack_uint(values->Correct5, 16, 19) |
      util_bitpack_uint(values->Correct6, 20, 23) |
      util_bitpack_uint(values->RoundIntra, 24, 26) |
      util_bitpack_uint(values->RoundIntraEnable, 27, 27) |
      util_bitpack_uint(values->RoundInter, 28, 30) |
      util_bitpack_uint(values->RoundInterEnable, 31, 31);
}

#define GFX20_MFX_AVC_WEIGHTOFFSET_STATE_length     98
#define GFX20_MFX_AVC_WEIGHTOFFSET_STATE_length_bias      2
#define GFX20_MFX_AVC_WEIGHTOFFSET_STATE_header \
   .DWordLength                         =     96,  \
   .SubOpcodeB                          =      5,  \
   .SubOpcodeA                          =      0,  \
   .MediaCommandOpcode                  =      1,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFX_AVC_WEIGHTOFFSET_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             WeightandOffsetSelect;
#define L0table                                  0
#define L1table                                  1
   uint32_t                             WeightOffset[96];
};

static inline __attribute__((always_inline)) void
GFX20_MFX_AVC_WEIGHTOFFSET_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                                      __attribute__((unused)) void * restrict dst,
                                      __attribute__((unused)) const struct GFX20_MFX_AVC_WEIGHTOFFSET_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpcode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->WeightandOffsetSelect, 0, 0);

   dw[2] =
      util_bitpack_uint(values->WeightOffset[0], 0, 31);

   dw[3] =
      util_bitpack_uint(values->WeightOffset[1], 0, 31);

   dw[4] =
      util_bitpack_uint(values->WeightOffset[2], 0, 31);

   dw[5] =
      util_bitpack_uint(values->WeightOffset[3], 0, 31);

   dw[6] =
      util_bitpack_uint(values->WeightOffset[4], 0, 31);

   dw[7] =
      util_bitpack_uint(values->WeightOffset[5], 0, 31);

   dw[8] =
      util_bitpack_uint(values->WeightOffset[6], 0, 31);

   dw[9] =
      util_bitpack_uint(values->WeightOffset[7], 0, 31);

   dw[10] =
      util_bitpack_uint(values->WeightOffset[8], 0, 31);

   dw[11] =
      util_bitpack_uint(values->WeightOffset[9], 0, 31);

   dw[12] =
      util_bitpack_uint(values->WeightOffset[10], 0, 31);

   dw[13] =
      util_bitpack_uint(values->WeightOffset[11], 0, 31);

   dw[14] =
      util_bitpack_uint(values->WeightOffset[12], 0, 31);

   dw[15] =
      util_bitpack_uint(values->WeightOffset[13], 0, 31);

   dw[16] =
      util_bitpack_uint(values->WeightOffset[14], 0, 31);

   dw[17] =
      util_bitpack_uint(values->WeightOffset[15], 0, 31);

   dw[18] =
      util_bitpack_uint(values->WeightOffset[16], 0, 31);

   dw[19] =
      util_bitpack_uint(values->WeightOffset[17], 0, 31);

   dw[20] =
      util_bitpack_uint(values->WeightOffset[18], 0, 31);

   dw[21] =
      util_bitpack_uint(values->WeightOffset[19], 0, 31);

   dw[22] =
      util_bitpack_uint(values->WeightOffset[20], 0, 31);

   dw[23] =
      util_bitpack_uint(values->WeightOffset[21], 0, 31);

   dw[24] =
      util_bitpack_uint(values->WeightOffset[22], 0, 31);

   dw[25] =
      util_bitpack_uint(values->WeightOffset[23], 0, 31);

   dw[26] =
      util_bitpack_uint(values->WeightOffset[24], 0, 31);

   dw[27] =
      util_bitpack_uint(values->WeightOffset[25], 0, 31);

   dw[28] =
      util_bitpack_uint(values->WeightOffset[26], 0, 31);

   dw[29] =
      util_bitpack_uint(values->WeightOffset[27], 0, 31);

   dw[30] =
      util_bitpack_uint(values->WeightOffset[28], 0, 31);

   dw[31] =
      util_bitpack_uint(values->WeightOffset[29], 0, 31);

   dw[32] =
      util_bitpack_uint(values->WeightOffset[30], 0, 31);

   dw[33] =
      util_bitpack_uint(values->WeightOffset[31], 0, 31);

   dw[34] =
      util_bitpack_uint(values->WeightOffset[32], 0, 31);

   dw[35] =
      util_bitpack_uint(values->WeightOffset[33], 0, 31);

   dw[36] =
      util_bitpack_uint(values->WeightOffset[34], 0, 31);

   dw[37] =
      util_bitpack_uint(values->WeightOffset[35], 0, 31);

   dw[38] =
      util_bitpack_uint(values->WeightOffset[36], 0, 31);

   dw[39] =
      util_bitpack_uint(values->WeightOffset[37], 0, 31);

   dw[40] =
      util_bitpack_uint(values->WeightOffset[38], 0, 31);

   dw[41] =
      util_bitpack_uint(values->WeightOffset[39], 0, 31);

   dw[42] =
      util_bitpack_uint(values->WeightOffset[40], 0, 31);

   dw[43] =
      util_bitpack_uint(values->WeightOffset[41], 0, 31);

   dw[44] =
      util_bitpack_uint(values->WeightOffset[42], 0, 31);

   dw[45] =
      util_bitpack_uint(values->WeightOffset[43], 0, 31);

   dw[46] =
      util_bitpack_uint(values->WeightOffset[44], 0, 31);

   dw[47] =
      util_bitpack_uint(values->WeightOffset[45], 0, 31);

   dw[48] =
      util_bitpack_uint(values->WeightOffset[46], 0, 31);

   dw[49] =
      util_bitpack_uint(values->WeightOffset[47], 0, 31);

   dw[50] =
      util_bitpack_uint(values->WeightOffset[48], 0, 31);

   dw[51] =
      util_bitpack_uint(values->WeightOffset[49], 0, 31);

   dw[52] =
      util_bitpack_uint(values->WeightOffset[50], 0, 31);

   dw[53] =
      util_bitpack_uint(values->WeightOffset[51], 0, 31);

   dw[54] =
      util_bitpack_uint(values->WeightOffset[52], 0, 31);

   dw[55] =
      util_bitpack_uint(values->WeightOffset[53], 0, 31);

   dw[56] =
      util_bitpack_uint(values->WeightOffset[54], 0, 31);

   dw[57] =
      util_bitpack_uint(values->WeightOffset[55], 0, 31);

   dw[58] =
      util_bitpack_uint(values->WeightOffset[56], 0, 31);

   dw[59] =
      util_bitpack_uint(values->WeightOffset[57], 0, 31);

   dw[60] =
      util_bitpack_uint(values->WeightOffset[58], 0, 31);

   dw[61] =
      util_bitpack_uint(values->WeightOffset[59], 0, 31);

   dw[62] =
      util_bitpack_uint(values->WeightOffset[60], 0, 31);

   dw[63] =
      util_bitpack_uint(values->WeightOffset[61], 0, 31);

   dw[64] =
      util_bitpack_uint(values->WeightOffset[62], 0, 31);

   dw[65] =
      util_bitpack_uint(values->WeightOffset[63], 0, 31);

   dw[66] =
      util_bitpack_uint(values->WeightOffset[64], 0, 31);

   dw[67] =
      util_bitpack_uint(values->WeightOffset[65], 0, 31);

   dw[68] =
      util_bitpack_uint(values->WeightOffset[66], 0, 31);

   dw[69] =
      util_bitpack_uint(values->WeightOffset[67], 0, 31);

   dw[70] =
      util_bitpack_uint(values->WeightOffset[68], 0, 31);

   dw[71] =
      util_bitpack_uint(values->WeightOffset[69], 0, 31);

   dw[72] =
      util_bitpack_uint(values->WeightOffset[70], 0, 31);

   dw[73] =
      util_bitpack_uint(values->WeightOffset[71], 0, 31);

   dw[74] =
      util_bitpack_uint(values->WeightOffset[72], 0, 31);

   dw[75] =
      util_bitpack_uint(values->WeightOffset[73], 0, 31);

   dw[76] =
      util_bitpack_uint(values->WeightOffset[74], 0, 31);

   dw[77] =
      util_bitpack_uint(values->WeightOffset[75], 0, 31);

   dw[78] =
      util_bitpack_uint(values->WeightOffset[76], 0, 31);

   dw[79] =
      util_bitpack_uint(values->WeightOffset[77], 0, 31);

   dw[80] =
      util_bitpack_uint(values->WeightOffset[78], 0, 31);

   dw[81] =
      util_bitpack_uint(values->WeightOffset[79], 0, 31);

   dw[82] =
      util_bitpack_uint(values->WeightOffset[80], 0, 31);

   dw[83] =
      util_bitpack_uint(values->WeightOffset[81], 0, 31);

   dw[84] =
      util_bitpack_uint(values->WeightOffset[82], 0, 31);

   dw[85] =
      util_bitpack_uint(values->WeightOffset[83], 0, 31);

   dw[86] =
      util_bitpack_uint(values->WeightOffset[84], 0, 31);

   dw[87] =
      util_bitpack_uint(values->WeightOffset[85], 0, 31);

   dw[88] =
      util_bitpack_uint(values->WeightOffset[86], 0, 31);

   dw[89] =
      util_bitpack_uint(values->WeightOffset[87], 0, 31);

   dw[90] =
      util_bitpack_uint(values->WeightOffset[88], 0, 31);

   dw[91] =
      util_bitpack_uint(values->WeightOffset[89], 0, 31);

   dw[92] =
      util_bitpack_uint(values->WeightOffset[90], 0, 31);

   dw[93] =
      util_bitpack_uint(values->WeightOffset[91], 0, 31);

   dw[94] =
      util_bitpack_uint(values->WeightOffset[92], 0, 31);

   dw[95] =
      util_bitpack_uint(values->WeightOffset[93], 0, 31);

   dw[96] =
      util_bitpack_uint(values->WeightOffset[94], 0, 31);

   dw[97] =
      util_bitpack_uint(values->WeightOffset[95], 0, 31);
}

#define GFX20_MFX_BSP_BUF_BASE_ADDR_STATE_length     10
#define GFX20_MFX_BSP_BUF_BASE_ADDR_STATE_length_bias      2
#define GFX20_MFX_BSP_BUF_BASE_ADDR_STATE_header\
   .DWordLength                         =      8,  \
   .SubOpcodeB                          =      4,  \
   .SubOpcodeA                          =      0,  \
   .MediaCommandOpcode                  =      0,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFX_BSP_BUF_BASE_ADDR_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   __gen_address_type                   BSDMPCRowStoreScratchBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES BSDMPCRowStoreScratchBufferAttributes;
   __gen_address_type                   MPRRowStoreScratchBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES MPRRowStoreScratchBufferAttributes;
   __gen_address_type                   BitplaneReadBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES BitplaneReadBufferAttributes;
};

static inline __attribute__((always_inline)) void
GFX20_MFX_BSP_BUF_BASE_ADDR_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                                       __attribute__((unused)) void * restrict dst,
                                       __attribute__((unused)) const struct GFX20_MFX_BSP_BUF_BASE_ADDR_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpcode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   const uint64_t v1_address =
      __gen_address(data, &dw[1], values->BSDMPCRowStoreScratchBufferAddress, 0, 6, 47);
   dw[1] = v1_address;
   dw[2] = v1_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[3], &values->BSDMPCRowStoreScratchBufferAttributes);

   const uint64_t v4_address =
      __gen_address(data, &dw[4], values->MPRRowStoreScratchBufferAddress, 0, 6, 47);
   dw[4] = v4_address;
   dw[5] = v4_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[6], &values->MPRRowStoreScratchBufferAttributes);

   const uint64_t v7_address =
      __gen_address(data, &dw[7], values->BitplaneReadBufferAddress, 0, 6, 47);
   dw[7] = v7_address;
   dw[8] = v7_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[9], &values->BitplaneReadBufferAttributes);
}

#define GFX20_MFX_DBK_OBJECT_length           13
#define GFX20_MFX_DBK_OBJECT_length_bias       2
#define GFX20_MFX_DBK_OBJECT_header             \
   .DWordLength                         =     11,  \
   .SubOpcodeB                          =      9,  \
   .SubOpcodeA                          =      0,  \
   .MediaCommandOpcode                  =      0,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFX_DBK_OBJECT {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   __gen_address_type                   PreDeblockingSourceAddress;
   uint32_t                             PreDeblockingSourceMOCS;
   uint32_t                             PreDeblockingSourceArbitrationPriorityControl;
#define Highestpriority                          0
#define Secondhighestpriority                    1
#define Thirdhighestpriority                     2
#define Lowestpriority                           3
   bool                                 PreDeblockingSourceMemoryCompressionEnable;
   uint32_t                             PreDeblockingSourceMemoryCompressionMode;
   uint32_t                             PreDeblockingSourceTiledResourceMode;
#define TRMODE_NONE                              0
#define TRMODE_TILEYF                            1
#define TRMODE_TILEYS                            2
   __gen_address_type                   DeblockingControlAddress;
   uint32_t                             DeblockingControlMOCS;
   uint32_t                             DeblockingControlArbitrationPriorityControl;
#define Highestpriority                          0
#define Secondhighestpriority                    1
#define Thirdhighestpriority                     2
#define Lowestpriority                           3
   bool                                 DeblockingControlMemoryCompressionEnable;
   uint32_t                             DeblockingControlMemoryCompressionMode;
   uint32_t                             DeblockingControlTiledResourceMode;
#define TRMODE_NONE                              0
#define TRMODE_TILEYF                            1
#define TRMODE_TILEYS                            2
   __gen_address_type                   DeblockingDestinationAddressHigh;
   uint32_t                             DeblockingDestinationMOCS;
   uint32_t                             DeblockingDestinationArbitrationPriorityControl;
#define Highestpriority                          0
#define Secondhighestpriority                    1
#define Thirdhighestpriority                     2
#define Lowestpriority                           3
   bool                                 DeblockingDestinationMemoryCompressionEnable;
   uint32_t                             DeblockingDestinationMemoryCompressionMode;
   uint32_t                             DeblockingDestinationTiledResourceMode;
#define TRMODE_NONE                              0
#define TRMODE_TILEYF                            1
#define TRMODE_TILEYS                            2
   __gen_address_type                   DeblockRowStoreAddress;
   uint32_t                             CoeffProbabilityStreamInMOCS;
   uint32_t                             DeblockRowStoreArbitrationPriorityControl;
#define Highestpriority                          0
#define Secondhighestpriority                    1
#define Thirdhighestpriority                     2
#define Lowestpriority                           3
   bool                                 DeblockRowStoreMemoryCompressionEnable;
   uint32_t                             DeblockRowStoreMemoryCompressionMode;
   uint32_t                             DeblockRowStoreTiledResourceMode;
#define TRMODE_NONE                              0
#define TRMODE_TILEYF                            1
#define TRMODE_TILEYS                            2
};

static inline __attribute__((always_inline)) void
GFX20_MFX_DBK_OBJECT_pack(__attribute__((unused)) __gen_user_data *data,
                          __attribute__((unused)) void * restrict dst,
                          __attribute__((unused)) const struct GFX20_MFX_DBK_OBJECT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpcode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   const uint64_t v1_address =
      __gen_address(data, &dw[1], values->PreDeblockingSourceAddress, 0, 6, 47);
   dw[1] = v1_address;
   dw[2] = v1_address >> 32;

   dw[3] =
      util_bitpack_uint_nonzero(values->PreDeblockingSourceMOCS, 0, 6) |
      util_bitpack_uint(values->PreDeblockingSourceArbitrationPriorityControl, 7, 8) |
      util_bitpack_uint(values->PreDeblockingSourceMemoryCompressionEnable, 9, 9) |
      util_bitpack_uint(values->PreDeblockingSourceMemoryCompressionMode, 10, 10) |
      util_bitpack_uint(values->PreDeblockingSourceTiledResourceMode, 13, 14);

   const uint64_t v4_address =
      __gen_address(data, &dw[4], values->DeblockingControlAddress, 0, 6, 47);
   dw[4] = v4_address;
   dw[5] = v4_address >> 32;

   dw[6] =
      util_bitpack_uint_nonzero(values->DeblockingControlMOCS, 0, 6) |
      util_bitpack_uint(values->DeblockingControlArbitrationPriorityControl, 7, 8) |
      util_bitpack_uint(values->DeblockingControlMemoryCompressionEnable, 9, 9) |
      util_bitpack_uint(values->DeblockingControlMemoryCompressionMode, 10, 10) |
      util_bitpack_uint(values->DeblockingControlTiledResourceMode, 13, 14);

   const uint64_t v7_address =
      __gen_address(data, &dw[7], values->DeblockingDestinationAddressHigh, 0, 6, 47);
   dw[7] = v7_address;
   dw[8] = v7_address >> 32;

   dw[9] =
      util_bitpack_uint_nonzero(values->DeblockingDestinationMOCS, 0, 6) |
      util_bitpack_uint(values->DeblockingDestinationArbitrationPriorityControl, 7, 8) |
      util_bitpack_uint(values->DeblockingDestinationMemoryCompressionEnable, 9, 9) |
      util_bitpack_uint(values->DeblockingDestinationMemoryCompressionMode, 10, 10) |
      util_bitpack_uint(values->DeblockingDestinationTiledResourceMode, 13, 14);

   const uint64_t v10_address =
      __gen_address(data, &dw[10], values->DeblockRowStoreAddress, 0, 6, 47);
   dw[10] = v10_address;
   dw[11] = v10_address >> 32;

   dw[12] =
      util_bitpack_uint_nonzero(values->CoeffProbabilityStreamInMOCS, 0, 6) |
      util_bitpack_uint(values->DeblockRowStoreArbitrationPriorityControl, 7, 8) |
      util_bitpack_uint(values->DeblockRowStoreMemoryCompressionEnable, 9, 9) |
      util_bitpack_uint(values->DeblockRowStoreMemoryCompressionMode, 10, 10) |
      util_bitpack_uint(values->DeblockRowStoreTiledResourceMode, 13, 14);
}

#define GFX20_MFX_FQM_STATE_length            34
#define GFX20_MFX_FQM_STATE_length_bias        2
#define GFX20_MFX_FQM_STATE_header              \
   .DWordLength                         =     32,  \
   .SubOpcodeB                          =      8,  \
   .SubOpcodeA                          =      0,  \
   .MediaCommandOpcode                  =      0,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFX_FQM_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             AVC;
#define AVC_4x4_Intra_MATRIX                     0
#define AVC_4x4_Inter_MATRIX                     1
#define AVC_8x8_Intra_MATRIX                     2
#define AVC_8x8_Inter_MATRIX                     3
   uint32_t                             MPEG2;
#define MPEG_INTRA_QUANTIZER_MATRIX              0
#define MPEG_NON_INTRA_QUANTIZER_MATRIX          1
   uint32_t                             JPEG;
#define JPEG_Luma_Y_QUANTIZER_MATRIXorR          0
#define JPEG_Chroma_Cb_QUANTIZER_MATRIXorG       1
#define JPEG_Chroma_Cr_QUANTIZER_MATRIXorB       2
   uint32_t                             QuantizerMatrix8x8[64];
};

static inline __attribute__((always_inline)) void
GFX20_MFX_FQM_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                         __attribute__((unused)) void * restrict dst,
                         __attribute__((unused)) const struct GFX20_MFX_FQM_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpcode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->AVC, 0, 1) |
      util_bitpack_uint(values->MPEG2, 0, 1) |
      util_bitpack_uint(values->JPEG, 0, 1);

   dw[2] =
      util_bitpack_uint(values->QuantizerMatrix8x8[0], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[1], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[2], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[3], 24, 31);

   dw[3] =
      util_bitpack_uint(values->QuantizerMatrix8x8[4], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[5], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[6], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[7], 24, 31);

   dw[4] =
      util_bitpack_uint(values->QuantizerMatrix8x8[8], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[9], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[10], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[11], 24, 31);

   dw[5] =
      util_bitpack_uint(values->QuantizerMatrix8x8[12], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[13], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[14], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[15], 24, 31);

   dw[6] =
      util_bitpack_uint(values->QuantizerMatrix8x8[16], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[17], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[18], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[19], 24, 31);

   dw[7] =
      util_bitpack_uint(values->QuantizerMatrix8x8[20], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[21], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[22], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[23], 24, 31);

   dw[8] =
      util_bitpack_uint(values->QuantizerMatrix8x8[24], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[25], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[26], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[27], 24, 31);

   dw[9] =
      util_bitpack_uint(values->QuantizerMatrix8x8[28], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[29], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[30], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[31], 24, 31);

   dw[10] =
      util_bitpack_uint(values->QuantizerMatrix8x8[32], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[33], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[34], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[35], 24, 31);

   dw[11] =
      util_bitpack_uint(values->QuantizerMatrix8x8[36], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[37], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[38], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[39], 24, 31);

   dw[12] =
      util_bitpack_uint(values->QuantizerMatrix8x8[40], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[41], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[42], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[43], 24, 31);

   dw[13] =
      util_bitpack_uint(values->QuantizerMatrix8x8[44], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[45], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[46], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[47], 24, 31);

   dw[14] =
      util_bitpack_uint(values->QuantizerMatrix8x8[48], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[49], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[50], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[51], 24, 31);

   dw[15] =
      util_bitpack_uint(values->QuantizerMatrix8x8[52], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[53], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[54], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[55], 24, 31);

   dw[16] =
      util_bitpack_uint(values->QuantizerMatrix8x8[56], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[57], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[58], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[59], 24, 31);

   dw[17] =
      util_bitpack_uint(values->QuantizerMatrix8x8[60], 0, 7) |
      util_bitpack_uint(values->QuantizerMatrix8x8[61], 8, 15) |
      util_bitpack_uint(values->QuantizerMatrix8x8[62], 16, 23) |
      util_bitpack_uint(values->QuantizerMatrix8x8[63], 24, 31);

   dw[18] = 0;

   dw[19] = 0;

   dw[20] = 0;

   dw[21] = 0;

   dw[22] = 0;

   dw[23] = 0;

   dw[24] = 0;

   dw[25] = 0;

   dw[26] = 0;

   dw[27] = 0;

   dw[28] = 0;

   dw[29] = 0;

   dw[30] = 0;

   dw[31] = 0;

   dw[32] = 0;

   dw[33] = 0;
}

#define GFX20_MFX_IND_OBJ_BASE_ADDR_STATE_length     26
#define GFX20_MFX_IND_OBJ_BASE_ADDR_STATE_length_bias      2
#define GFX20_MFX_IND_OBJ_BASE_ADDR_STATE_header\
   .DWordLength                         =     24,  \
   .SubOpcodeB                          =      3,  \
   .SubOpcodeA                          =      0,  \
   .MediaCommandOpcode                  =      0,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFX_IND_OBJ_BASE_ADDR_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   __gen_address_type                   MFXIndirectBitstreamObjectAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES MFXIndirectBitstreamObjectAttributes;
   __gen_address_type                   MFXIndirectBitstreamObjectUpperBound;
   __gen_address_type                   MFXIndirectMVObjectAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES MFXIndirectMVObjectAttributes;
   __gen_address_type                   MFXIndirectMVObjectUpperBound;
   __gen_address_type                   MFDIndirectITCOEFFObjectAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES MFDIndirectITCOEFFObjectAttributes;
   __gen_address_type                   MFDIndirectITCOEFFObjectUpperBound;
   __gen_address_type                   MFDIndirectITDBLKObjectAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES MFDIndirectITDBLKObjectAttributes;
   __gen_address_type                   MFDIndirectITDBLKObjectUpperBound;
   __gen_address_type                   MFCIndirectPAKBSEObjectAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES MFCIndirectPAKBSEObjectAttributes;
   __gen_address_type                   MFCIndirectPAKBSEObjectUpperBound;
};

static inline __attribute__((always_inline)) void
GFX20_MFX_IND_OBJ_BASE_ADDR_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                                       __attribute__((unused)) void * restrict dst,
                                       __attribute__((unused)) const struct GFX20_MFX_IND_OBJ_BASE_ADDR_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpcode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   const uint64_t v1_address =
      __gen_address(data, &dw[1], values->MFXIndirectBitstreamObjectAddress, 0, 0, 63);
   dw[1] = v1_address;
   dw[2] = v1_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[3], &values->MFXIndirectBitstreamObjectAttributes);

   const uint64_t v4_address =
      __gen_address(data, &dw[4], values->MFXIndirectBitstreamObjectUpperBound, 0, 0, 63);
   dw[4] = v4_address;
   dw[5] = v4_address >> 32;

   const uint64_t v6_address =
      __gen_address(data, &dw[6], values->MFXIndirectMVObjectAddress, 0, 0, 63);
   dw[6] = v6_address;
   dw[7] = v6_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[8], &values->MFXIndirectMVObjectAttributes);

   const uint64_t v9_address =
      __gen_address(data, &dw[9], values->MFXIndirectMVObjectUpperBound, 0, 0, 63);
   dw[9] = v9_address;
   dw[10] = v9_address >> 32;

   const uint64_t v11_address =
      __gen_address(data, &dw[11], values->MFDIndirectITCOEFFObjectAddress, 0, 0, 63);
   dw[11] = v11_address;
   dw[12] = v11_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[13], &values->MFDIndirectITCOEFFObjectAttributes);

   const uint64_t v14_address =
      __gen_address(data, &dw[14], values->MFDIndirectITCOEFFObjectUpperBound, 0, 0, 63);
   dw[14] = v14_address;
   dw[15] = v14_address >> 32;

   const uint64_t v16_address =
      __gen_address(data, &dw[16], values->MFDIndirectITDBLKObjectAddress, 0, 0, 63);
   dw[16] = v16_address;
   dw[17] = v16_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[18], &values->MFDIndirectITDBLKObjectAttributes);

   const uint64_t v19_address =
      __gen_address(data, &dw[19], values->MFDIndirectITDBLKObjectUpperBound, 0, 0, 63);
   dw[19] = v19_address;
   dw[20] = v19_address >> 32;

   const uint64_t v21_address =
      __gen_address(data, &dw[21], values->MFCIndirectPAKBSEObjectAddress, 0, 0, 63);
   dw[21] = v21_address;
   dw[22] = v21_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[23], &values->MFCIndirectPAKBSEObjectAttributes);

   const uint64_t v24_address =
      __gen_address(data, &dw[24], values->MFCIndirectPAKBSEObjectUpperBound, 0, 0, 63);
   dw[24] = v24_address;
   dw[25] = v24_address >> 32;
}

#define GFX20_MFX_JPEG_HUFF_TABLE_STATE_length    831
#define GFX20_MFX_JPEG_HUFF_TABLE_STATE_length_bias      2
#define GFX20_MFX_JPEG_HUFF_TABLE_STATE_header  \
   .DWordLength                         =    829,  \
   .SubOpcodeB                          =      2,  \
   .SubOpcodeA                          =      0,  \
   .MediaCommandOpcode                  =      7,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFX_JPEG_HUFF_TABLE_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             HuffmanTableID;
   uint32_t                             DC_BITS[12];
   uint32_t                             DC_HUFFVAL[12];
   uint32_t                             AC_BITS[16];
   uint32_t                             AC_HUFFVAL[160];
   uint32_t                             AC_HUFFVAL2[2];
};

static inline __attribute__((always_inline)) void
GFX20_MFX_JPEG_HUFF_TABLE_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                                     __attribute__((unused)) void * restrict dst,
                                     __attribute__((unused)) const struct GFX20_MFX_JPEG_HUFF_TABLE_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpcode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->HuffmanTableID, 0, 0);

   dw[2] =
      util_bitpack_uint(values->DC_BITS[0], 0, 7) |
      util_bitpack_uint(values->DC_BITS[1], 8, 15) |
      util_bitpack_uint(values->DC_BITS[2], 16, 23) |
      util_bitpack_uint(values->DC_BITS[3], 24, 31);

   dw[3] =
      util_bitpack_uint(values->DC_BITS[4], 0, 7) |
      util_bitpack_uint(values->DC_BITS[5], 8, 15) |
      util_bitpack_uint(values->DC_BITS[6], 16, 23) |
      util_bitpack_uint(values->DC_BITS[7], 24, 31);

   dw[4] =
      util_bitpack_uint(values->DC_BITS[8], 0, 7) |
      util_bitpack_uint(values->DC_BITS[9], 8, 15) |
      util_bitpack_uint(values->DC_BITS[10], 16, 23) |
      util_bitpack_uint(values->DC_BITS[11], 24, 31);

   dw[5] =
      util_bitpack_uint(values->DC_HUFFVAL[0], 0, 7) |
      util_bitpack_uint(values->DC_HUFFVAL[1], 8, 15) |
      util_bitpack_uint(values->DC_HUFFVAL[2], 16, 23) |
      util_bitpack_uint(values->DC_HUFFVAL[3], 24, 31);

   dw[6] =
      util_bitpack_uint(values->DC_HUFFVAL[4], 0, 7) |
      util_bitpack_uint(values->DC_HUFFVAL[5], 8, 15) |
      util_bitpack_uint(values->DC_HUFFVAL[6], 16, 23) |
      util_bitpack_uint(values->DC_HUFFVAL[7], 24, 31);

   dw[7] =
      util_bitpack_uint(values->DC_HUFFVAL[8], 0, 7) |
      util_bitpack_uint(values->DC_HUFFVAL[9], 8, 15) |
      util_bitpack_uint(values->DC_HUFFVAL[10], 16, 23) |
      util_bitpack_uint(values->DC_HUFFVAL[11], 24, 31);

   const uint64_t v8 =
      util_bitpack_uint(values->AC_BITS[0], 0, 15) |
      util_bitpack_uint(values->AC_BITS[1], 8, 23) |
      util_bitpack_uint(values->AC_BITS[2], 16, 31) |
      util_bitpack_uint(values->AC_BITS[3], 24, 39) |
      util_bitpack_uint(values->AC_BITS[4], 32, 47) |
      util_bitpack_uint(values->AC_BITS[5], 40, 55) |
      util_bitpack_uint(values->AC_BITS[6], 48, 63) |
      util_bitpack_uint(values->AC_BITS[7], 56, 71) |
      util_bitpack_uint(values->AC_BITS[8], 64, 79) |
      util_bitpack_uint(values->AC_BITS[9], 72, 87) |
      util_bitpack_uint(values->AC_BITS[10], 80, 95) |
      util_bitpack_uint(values->AC_BITS[11], 88, 103) |
      util_bitpack_uint(values->AC_BITS[12], 96, 111) |
      util_bitpack_uint(values->AC_BITS[13], 104, 119) |
      util_bitpack_uint(values->AC_BITS[14], 112, 127) |
      util_bitpack_uint(values->AC_BITS[15], 120, 135) |
      util_bitpack_uint(values->AC_HUFFVAL[0], 128, 135) |
      util_bitpack_uint(values->AC_HUFFVAL[1], 136, 143) |
      util_bitpack_uint(values->AC_HUFFVAL[2], 144, 151) |
      util_bitpack_uint(values->AC_HUFFVAL[3], 152, 159);
   dw[8] = v8;
   dw[9] = v8 >> 32;

   dw[13] =
      util_bitpack_uint(values->AC_HUFFVAL[4], 0, 7) |
      util_bitpack_uint(values->AC_HUFFVAL[5], 8, 15) |
      util_bitpack_uint(values->AC_HUFFVAL[6], 16, 23) |
      util_bitpack_uint(values->AC_HUFFVAL[7], 24, 31);

   dw[14] =
      util_bitpack_uint(values->AC_HUFFVAL[8], 0, 7) |
      util_bitpack_uint(values->AC_HUFFVAL[9], 8, 15) |
      util_bitpack_uint(values->AC_HUFFVAL[10], 16, 23) |
      util_bitpack_uint(values->AC_HUFFVAL[11], 24, 31);

   dw[15] =
      util_bitpack_uint(values->AC_HUFFVAL[12], 0, 7) |
      util_bitpack_uint(values->AC_HUFFVAL[13], 8, 15) |
      util_bitpack_uint(values->AC_HUFFVAL[14], 16, 23) |
      util_bitpack_uint(values->AC_HUFFVAL[15], 24, 31);

   dw[16] =
      util_bitpack_uint(values->AC_HUFFVAL[16], 0, 7) |
      util_bitpack_uint(values->AC_HUFFVAL[17], 8, 15) |
      util_bitpack_uint(values->AC_HUFFVAL[18], 16, 23) |
      util_bitpack_uint(values->AC_HUFFVAL[19], 24, 31);

   dw[17] =
      util_bitpack_uint(values->AC_HUFFVAL[20], 0, 7) |
      util_bitpack_uint(values->AC_HUFFVAL[21], 8, 15) |
      util_bitpack_uint(values->AC_HUFFVAL[22], 16, 23) |
      util_bitpack_uint(values->AC_HUFFVAL[23], 24, 31);

   dw[18] =
      util_bitpack_uint(values->AC_HUFFVAL[24], 0, 7) |
      util_bitpack_uint(values->AC_HUFFVAL[25], 8, 15) |
      util_bitpack_uint(values->AC_HUFFVAL[26], 16, 23) |
      util_bitpack_uint(values->AC_HUFFVAL[27], 24, 31);

   dw[19] =
      util_bitpack_uint(values->AC_HUFFVAL[28], 0, 7) |
      util_bitpack_uint(values->AC_HUFFVAL[29], 8, 15) |
      util_bitpack_uint(values->AC_HUFFVAL[30], 16, 23) |
      util_bitpack_uint(values->AC_HUFFVAL[31], 24, 31);

   dw[20] =
      util_bitpack_uint(values->AC_HUFFVAL[32], 0, 7) |
      util_bitpack_uint(values->AC_HUFFVAL[33], 8, 15) |
      util_bitpack_uint(values->AC_HUFFVAL[34], 16, 23) |
      util_bitpack_uint(values->AC_HUFFVAL[35], 24, 31);

   dw[21] =
      util_bitpack_uint(values->AC_HUFFVAL[36], 0, 7) |
      util_bitpack_uint(values->AC_HUFFVAL[37], 8, 15) |
      util_bitpack_uint(values->AC_HUFFVAL[38], 16, 23) |
      util_bitpack_uint(values->AC_HUFFVAL[39], 24, 31);

   dw[22] =
      util_bitpack_uint(values->AC_HUFFVAL[40], 0, 7) |
      util_bitpack_uint(values->AC_HUFFVAL[41], 8, 15) |
      util_bitpack_uint(values->AC_HUFFVAL[42], 16, 23) |
      util_bitpack_uint(values->AC_HUFFVAL[43], 24, 31);

   dw[23] =
      util_bitpack_uint(values->AC_HUFFVAL[44], 0, 7) |
      util_bitpack_uint(values->AC_HUFFVAL[45], 8, 15) |
      util_bitpack_uint(values->AC_HUFFVAL[46], 16, 23) |
      util_bitpack_uint(values->AC_HUFFVAL[47], 24, 31);

   dw[24] =
      util_bitpack_uint(values->AC_HUFFVAL[48], 0, 7) |
      util_bitpack_uint(values->AC_HUFFVAL[49], 8, 15) |
      util_bitpack_uint(values->AC_HUFFVAL[50], 16, 23) |
      util_bitpack_uint(values->AC_HUFFVAL[51], 24, 31);

   dw[25] =
      util_bitpack_uint(values->AC_HUFFVAL[52], 0, 7) |
      util_bitpack_uint(values->AC_HUFFVAL[53], 8, 15) |
      util_bitpack_uint(values->AC_HUFFVAL[54], 16, 23) |
      util_bitpack_uint(values->AC_HUFFVAL[55], 24, 31);

   dw[26] =
      util_bitpack_uint(values->AC_HUFFVAL[56], 0, 7) |
      util_bitpack_uint(values->AC_HUFFVAL[57], 8, 15) |
      util_bitpack_uint(values->AC_HUFFVAL[58], 16, 23) |
      util_bitpack_uint(values->AC_HUFFVAL[59], 24, 31);

   dw[27] =
      util_bitpack_uint(values->AC_HUFFVAL[60], 0, 7) |
      util_bitpack_uint(values->AC_HUFFVAL[61], 8, 15) |
      util_bitpack_uint(values->AC_HUFFVAL[62], 16, 23) |
      util_bitpack_uint(values->AC_HUFFVAL[63], 24, 31);

   dw[28] =
      util_bitpack_uint(values->AC_HUFFVAL[64], 0, 7) |
      util_bitpack_uint(values->AC_HUFFVAL[65], 8, 15) |
      util_bitpack_uint(values->AC_HUFFVAL[66], 16, 23) |
      util_bitpack_uint(values->AC_HUFFVAL[67], 24, 31);

   dw[29] =
      util_bitpack_uint(values->AC_HUFFVAL[68], 0, 7) |
      util_bitpack_uint(values->AC_HUFFVAL[69], 8, 15) |
      util_bitpack_uint(values->AC_HUFFVAL[70], 16, 23) |
      util_bitpack_uint(values->AC_HUFFVAL[71], 24, 31);

   dw[30] =
      util_bitpack_uint(values->AC_HUFFVAL[72], 0, 7) |
      util_bitpack_uint(values->AC_HUFFVAL[73], 8, 15) |
      util_bitpack_uint(values->AC_HUFFVAL[74], 16, 23) |
      util_bitpack_uint(values->AC_HUFFVAL[75], 24, 31);

   dw[31] =
      util_bitpack_uint(values->AC_HUFFVAL[76], 0, 7) |
      util_bitpack_uint(values->AC_HUFFVAL[77], 8, 15) |
      util_bitpack_uint(values->AC_HUFFVAL[78], 16, 23) |
      util_bitpack_uint(values->AC_HUFFVAL[79], 24, 31);

   dw[32] =
      util_bitpack_uint(values->AC_HUFFVAL[80], 0, 7) |
      util_bitpack_uint(values->AC_HUFFVAL[81], 8, 15) |
      util_bitpack_uint(values->AC_HUFFVAL[82], 16, 23) |
      util_bitpack_uint(values->AC_HUFFVAL[83], 24, 31);

   dw[33] =
      util_bitpack_uint(values->AC_HUFFVAL[84], 0, 7) |
      util_bitpack_uint(values->AC_HUFFVAL[85], 8, 15) |
      util_bitpack_uint(values->AC_HUFFVAL[86], 16, 23) |
      util_bitpack_uint(values->AC_HUFFVAL[87], 24, 31);

   dw[34] =
      util_bitpack_uint(values->AC_HUFFVAL[88], 0, 7) |
      util_bitpack_uint(values->AC_HUFFVAL[89], 8, 15) |
      util_bitpack_uint(values->AC_HUFFVAL[90], 16, 23) |
      util_bitpack_uint(values->AC_HUFFVAL[91], 24, 31);

   dw[35] =
      util_bitpack_uint(values->AC_HUFFVAL[92], 0, 7) |
      util_bitpack_uint(values->AC_HUFFVAL[93], 8, 15) |
      util_bitpack_uint(values->AC_HUFFVAL[94], 16, 23) |
      util_bitpack_uint(values->AC_HUFFVAL[95], 24, 31);

   dw[36] =
      util_bitpack_uint(values->AC_HUFFVAL[96], 0, 7) |
      util_bitpack_uint(values->AC_HUFFVAL[97], 8, 15) |
      util_bitpack_uint(values->AC_HUFFVAL[98], 16, 23) |
      util_bitpack_uint(values->AC_HUFFVAL[99], 24, 31);

   dw[37] =
      util_bitpack_uint(values->AC_HUFFVAL[100], 0, 7) |
      util_bitpack_uint(values->AC_HUFFVAL[101], 8, 15) |
      util_bitpack_uint(values->AC_HUFFVAL[102], 16, 23) |
      util_bitpack_uint(values->AC_HUFFVAL[103], 24, 31);

   dw[38] =
      util_bitpack_uint(values->AC_HUFFVAL[104], 0, 7) |
      util_bitpack_uint(values->AC_HUFFVAL[105], 8, 15) |
      util_bitpack_uint(values->AC_HUFFVAL[106], 16, 23) |
      util_bitpack_uint(values->AC_HUFFVAL[107], 24, 31);

   dw[39] =
      util_bitpack_uint(values->AC_HUFFVAL[108], 0, 7) |
      util_bitpack_uint(values->AC_HUFFVAL[109], 8, 15) |
      util_bitpack_uint(values->AC_HUFFVAL[110], 16, 23) |
      util_bitpack_uint(values->AC_HUFFVAL[111], 24, 31);

   dw[40] =
      util_bitpack_uint(values->AC_HUFFVAL[112], 0, 7) |
      util_bitpack_uint(values->AC_HUFFVAL[113], 8, 15) |
      util_bitpack_uint(values->AC_HUFFVAL[114], 16, 23) |
      util_bitpack_uint(values->AC_HUFFVAL[115], 24, 31);

   dw[41] =
      util_bitpack_uint(values->AC_HUFFVAL[116], 0, 7) |
      util_bitpack_uint(values->AC_HUFFVAL[117], 8, 15) |
      util_bitpack_uint(values->AC_HUFFVAL[118], 16, 23) |
      util_bitpack_uint(values->AC_HUFFVAL[119], 24, 31);

   dw[42] =
      util_bitpack_uint(values->AC_HUFFVAL[120], 0, 7) |
      util_bitpack_uint(values->AC_HUFFVAL[121], 8, 15) |
      util_bitpack_uint(values->AC_HUFFVAL[122], 16, 23) |
      util_bitpack_uint(values->AC_HUFFVAL[123], 24, 31);

   dw[43] =
      util_bitpack_uint(values->AC_HUFFVAL[124], 0, 7) |
      util_bitpack_uint(values->AC_HUFFVAL[125], 8, 15) |
      util_bitpack_uint(values->AC_HUFFVAL[126], 16, 23) |
      util_bitpack_uint(values->AC_HUFFVAL[127], 24, 31);

   dw[44] =
      util_bitpack_uint(values->AC_HUFFVAL[128], 0, 7) |
      util_bitpack_uint(values->AC_HUFFVAL[129], 8, 15) |
      util_bitpack_uint(values->AC_HUFFVAL[130], 16, 23) |
      util_bitpack_uint(values->AC_HUFFVAL[131], 24, 31);

   dw[45] =
      util_bitpack_uint(values->AC_HUFFVAL[132], 0, 7) |
      util_bitpack_uint(values->AC_HUFFVAL[133], 8, 15) |
      util_bitpack_uint(values->AC_HUFFVAL[134], 16, 23) |
      util_bitpack_uint(values->AC_HUFFVAL[135], 24, 31);

   dw[46] =
      util_bitpack_uint(values->AC_HUFFVAL[136], 0, 7) |
      util_bitpack_uint(values->AC_HUFFVAL[137], 8, 15) |
      util_bitpack_uint(values->AC_HUFFVAL[138], 16, 23) |
      util_bitpack_uint(values->AC_HUFFVAL[139], 24, 31);

   dw[47] =
      util_bitpack_uint(values->AC_HUFFVAL[140], 0, 7) |
      util_bitpack_uint(values->AC_HUFFVAL[141], 8, 15) |
      util_bitpack_uint(values->AC_HUFFVAL[142], 16, 23) |
      util_bitpack_uint(values->AC_HUFFVAL[143], 24, 31);

   dw[48] =
      util_bitpack_uint(values->AC_HUFFVAL[144], 0, 7) |
      util_bitpack_uint(values->AC_HUFFVAL[145], 8, 15) |
      util_bitpack_uint(values->AC_HUFFVAL[146], 16, 23) |
      util_bitpack_uint(values->AC_HUFFVAL[147], 24, 31);

   dw[49] =
      util_bitpack_uint(values->AC_HUFFVAL[148], 0, 7) |
      util_bitpack_uint(values->AC_HUFFVAL[149], 8, 15) |
      util_bitpack_uint(values->AC_HUFFVAL[150], 16, 23) |
      util_bitpack_uint(values->AC_HUFFVAL[151], 24, 31);

   dw[50] =
      util_bitpack_uint(values->AC_HUFFVAL[152], 0, 7) |
      util_bitpack_uint(values->AC_HUFFVAL[153], 8, 15) |
      util_bitpack_uint(values->AC_HUFFVAL[154], 16, 23) |
      util_bitpack_uint(values->AC_HUFFVAL[155], 24, 31);

   dw[51] =
      util_bitpack_uint(values->AC_HUFFVAL[156], 0, 7) |
      util_bitpack_uint(values->AC_HUFFVAL[157], 8, 15) |
      util_bitpack_uint(values->AC_HUFFVAL[158], 16, 23) |
      util_bitpack_uint(values->AC_HUFFVAL[159], 24, 31);

   dw[52] =
      util_bitpack_uint(values->AC_HUFFVAL2[0], 0, 7) |
      util_bitpack_uint(values->AC_HUFFVAL2[1], 8, 15);

   dw[53] = 0;

   dw[54] = 0;

   dw[55] = 0;

   dw[56] = 0;

   dw[57] = 0;

   dw[58] = 0;

   dw[59] = 0;

   dw[60] = 0;

   dw[61] = 0;

   dw[62] = 0;

   dw[63] = 0;

   dw[64] = 0;

   dw[65] = 0;

   dw[66] = 0;

   dw[67] = 0;

   dw[68] = 0;

   dw[69] = 0;

   dw[70] = 0;

   dw[71] = 0;

   dw[72] = 0;

   dw[73] = 0;

   dw[74] = 0;

   dw[75] = 0;

   dw[76] = 0;

   dw[77] = 0;

   dw[78] = 0;

   dw[79] = 0;

   dw[80] = 0;

   dw[81] = 0;

   dw[82] = 0;

   dw[83] = 0;

   dw[84] = 0;

   dw[85] = 0;

   dw[86] = 0;

   dw[87] = 0;

   dw[88] = 0;

   dw[89] = 0;

   dw[90] = 0;

   dw[91] = 0;

   dw[92] = 0;

   dw[93] = 0;

   dw[94] = 0;

   dw[95] = 0;

   dw[96] = 0;

   dw[97] = 0;

   dw[98] = 0;

   dw[99] = 0;

   dw[100] = 0;

   dw[101] = 0;

   dw[102] = 0;

   dw[103] = 0;

   dw[104] = 0;

   dw[105] = 0;

   dw[106] = 0;

   dw[107] = 0;

   dw[108] = 0;

   dw[109] = 0;

   dw[110] = 0;

   dw[111] = 0;

   dw[112] = 0;

   dw[113] = 0;

   dw[114] = 0;

   dw[115] = 0;

   dw[116] = 0;

   dw[117] = 0;

   dw[118] = 0;

   dw[119] = 0;

   dw[120] = 0;

   dw[121] = 0;

   dw[122] = 0;

   dw[123] = 0;

   dw[124] = 0;

   dw[125] = 0;

   dw[126] = 0;

   dw[127] = 0;

   dw[128] = 0;

   dw[129] = 0;

   dw[130] = 0;

   dw[131] = 0;

   dw[132] = 0;

   dw[133] = 0;

   dw[134] = 0;

   dw[135] = 0;

   dw[136] = 0;

   dw[137] = 0;

   dw[138] = 0;

   dw[139] = 0;

   dw[140] = 0;

   dw[141] = 0;

   dw[142] = 0;

   dw[143] = 0;

   dw[144] = 0;

   dw[145] = 0;

   dw[146] = 0;

   dw[147] = 0;

   dw[148] = 0;

   dw[149] = 0;

   dw[150] = 0;

   dw[151] = 0;

   dw[152] = 0;

   dw[153] = 0;

   dw[154] = 0;

   dw[155] = 0;

   dw[156] = 0;

   dw[157] = 0;

   dw[158] = 0;

   dw[159] = 0;

   dw[160] = 0;

   dw[161] = 0;

   dw[162] = 0;

   dw[163] = 0;

   dw[164] = 0;

   dw[165] = 0;

   dw[166] = 0;

   dw[167] = 0;

   dw[168] = 0;

   dw[169] = 0;

   dw[170] = 0;

   dw[171] = 0;

   dw[172] = 0;

   dw[173] = 0;

   dw[174] = 0;

   dw[175] = 0;

   dw[176] = 0;

   dw[177] = 0;

   dw[178] = 0;

   dw[179] = 0;

   dw[180] = 0;

   dw[181] = 0;

   dw[182] = 0;

   dw[183] = 0;

   dw[184] = 0;

   dw[185] = 0;

   dw[186] = 0;

   dw[187] = 0;

   dw[188] = 0;

   dw[189] = 0;

   dw[190] = 0;

   dw[191] = 0;

   dw[192] = 0;

   dw[193] = 0;

   dw[194] = 0;

   dw[195] = 0;

   dw[196] = 0;

   dw[197] = 0;

   dw[198] = 0;

   dw[199] = 0;

   dw[200] = 0;

   dw[201] = 0;

   dw[202] = 0;

   dw[203] = 0;

   dw[204] = 0;

   dw[205] = 0;

   dw[206] = 0;

   dw[207] = 0;

   dw[208] = 0;

   dw[209] = 0;

   dw[210] = 0;

   dw[211] = 0;

   dw[212] = 0;

   dw[213] = 0;

   dw[214] = 0;

   dw[215] = 0;

   dw[216] = 0;

   dw[217] = 0;

   dw[218] = 0;

   dw[219] = 0;

   dw[220] = 0;

   dw[221] = 0;

   dw[222] = 0;

   dw[223] = 0;

   dw[224] = 0;

   dw[225] = 0;

   dw[226] = 0;

   dw[227] = 0;

   dw[228] = 0;

   dw[229] = 0;

   dw[230] = 0;

   dw[231] = 0;

   dw[232] = 0;

   dw[233] = 0;

   dw[234] = 0;

   dw[235] = 0;

   dw[236] = 0;

   dw[237] = 0;

   dw[238] = 0;

   dw[239] = 0;

   dw[240] = 0;

   dw[241] = 0;

   dw[242] = 0;

   dw[243] = 0;

   dw[244] = 0;

   dw[245] = 0;

   dw[246] = 0;

   dw[247] = 0;

   dw[248] = 0;

   dw[249] = 0;

   dw[250] = 0;

   dw[251] = 0;

   dw[252] = 0;

   dw[253] = 0;

   dw[254] = 0;

   dw[255] = 0;

   dw[256] = 0;

   dw[257] = 0;

   dw[258] = 0;

   dw[259] = 0;

   dw[260] = 0;

   dw[261] = 0;

   dw[262] = 0;

   dw[263] = 0;

   dw[264] = 0;

   dw[265] = 0;

   dw[266] = 0;

   dw[267] = 0;

   dw[268] = 0;

   dw[269] = 0;

   dw[270] = 0;

   dw[271] = 0;

   dw[272] = 0;

   dw[273] = 0;

   dw[274] = 0;

   dw[275] = 0;

   dw[276] = 0;

   dw[277] = 0;

   dw[278] = 0;

   dw[279] = 0;

   dw[280] = 0;

   dw[281] = 0;

   dw[282] = 0;

   dw[283] = 0;

   dw[284] = 0;

   dw[285] = 0;

   dw[286] = 0;

   dw[287] = 0;

   dw[288] = 0;

   dw[289] = 0;

   dw[290] = 0;

   dw[291] = 0;

   dw[292] = 0;

   dw[293] = 0;

   dw[294] = 0;

   dw[295] = 0;

   dw[296] = 0;

   dw[297] = 0;

   dw[298] = 0;

   dw[299] = 0;

   dw[300] = 0;

   dw[301] = 0;

   dw[302] = 0;

   dw[303] = 0;

   dw[304] = 0;

   dw[305] = 0;

   dw[306] = 0;

   dw[307] = 0;

   dw[308] = 0;

   dw[309] = 0;

   dw[310] = 0;

   dw[311] = 0;

   dw[312] = 0;

   dw[313] = 0;

   dw[314] = 0;

   dw[315] = 0;

   dw[316] = 0;

   dw[317] = 0;

   dw[318] = 0;

   dw[319] = 0;

   dw[320] = 0;

   dw[321] = 0;

   dw[322] = 0;

   dw[323] = 0;

   dw[324] = 0;

   dw[325] = 0;

   dw[326] = 0;

   dw[327] = 0;

   dw[328] = 0;

   dw[329] = 0;

   dw[330] = 0;

   dw[331] = 0;

   dw[332] = 0;

   dw[333] = 0;

   dw[334] = 0;

   dw[335] = 0;

   dw[336] = 0;

   dw[337] = 0;

   dw[338] = 0;

   dw[339] = 0;

   dw[340] = 0;

   dw[341] = 0;

   dw[342] = 0;

   dw[343] = 0;

   dw[344] = 0;

   dw[345] = 0;

   dw[346] = 0;

   dw[347] = 0;

   dw[348] = 0;

   dw[349] = 0;

   dw[350] = 0;

   dw[351] = 0;

   dw[352] = 0;

   dw[353] = 0;

   dw[354] = 0;

   dw[355] = 0;

   dw[356] = 0;

   dw[357] = 0;

   dw[358] = 0;

   dw[359] = 0;

   dw[360] = 0;

   dw[361] = 0;

   dw[362] = 0;

   dw[363] = 0;

   dw[364] = 0;

   dw[365] = 0;

   dw[366] = 0;

   dw[367] = 0;

   dw[368] = 0;

   dw[369] = 0;

   dw[370] = 0;

   dw[371] = 0;

   dw[372] = 0;

   dw[373] = 0;

   dw[374] = 0;

   dw[375] = 0;

   dw[376] = 0;

   dw[377] = 0;

   dw[378] = 0;

   dw[379] = 0;

   dw[380] = 0;

   dw[381] = 0;

   dw[382] = 0;

   dw[383] = 0;

   dw[384] = 0;

   dw[385] = 0;

   dw[386] = 0;

   dw[387] = 0;

   dw[388] = 0;

   dw[389] = 0;

   dw[390] = 0;

   dw[391] = 0;

   dw[392] = 0;

   dw[393] = 0;

   dw[394] = 0;

   dw[395] = 0;

   dw[396] = 0;

   dw[397] = 0;

   dw[398] = 0;

   dw[399] = 0;

   dw[400] = 0;

   dw[401] = 0;

   dw[402] = 0;

   dw[403] = 0;

   dw[404] = 0;

   dw[405] = 0;

   dw[406] = 0;

   dw[407] = 0;

   dw[408] = 0;

   dw[409] = 0;

   dw[410] = 0;

   dw[411] = 0;

   dw[412] = 0;

   dw[413] = 0;

   dw[414] = 0;

   dw[415] = 0;

   dw[416] = 0;

   dw[417] = 0;

   dw[418] = 0;

   dw[419] = 0;

   dw[420] = 0;

   dw[421] = 0;

   dw[422] = 0;

   dw[423] = 0;

   dw[424] = 0;

   dw[425] = 0;

   dw[426] = 0;

   dw[427] = 0;

   dw[428] = 0;

   dw[429] = 0;

   dw[430] = 0;

   dw[431] = 0;

   dw[432] = 0;

   dw[433] = 0;

   dw[434] = 0;

   dw[435] = 0;

   dw[436] = 0;

   dw[437] = 0;

   dw[438] = 0;

   dw[439] = 0;

   dw[440] = 0;

   dw[441] = 0;

   dw[442] = 0;

   dw[443] = 0;

   dw[444] = 0;

   dw[445] = 0;

   dw[446] = 0;

   dw[447] = 0;

   dw[448] = 0;

   dw[449] = 0;

   dw[450] = 0;

   dw[451] = 0;

   dw[452] = 0;

   dw[453] = 0;

   dw[454] = 0;

   dw[455] = 0;

   dw[456] = 0;

   dw[457] = 0;

   dw[458] = 0;

   dw[459] = 0;

   dw[460] = 0;

   dw[461] = 0;

   dw[462] = 0;

   dw[463] = 0;

   dw[464] = 0;

   dw[465] = 0;

   dw[466] = 0;

   dw[467] = 0;

   dw[468] = 0;

   dw[469] = 0;

   dw[470] = 0;

   dw[471] = 0;

   dw[472] = 0;

   dw[473] = 0;

   dw[474] = 0;

   dw[475] = 0;

   dw[476] = 0;

   dw[477] = 0;

   dw[478] = 0;

   dw[479] = 0;

   dw[480] = 0;

   dw[481] = 0;

   dw[482] = 0;

   dw[483] = 0;

   dw[484] = 0;

   dw[485] = 0;

   dw[486] = 0;

   dw[487] = 0;

   dw[488] = 0;

   dw[489] = 0;

   dw[490] = 0;

   dw[491] = 0;

   dw[492] = 0;

   dw[493] = 0;

   dw[494] = 0;

   dw[495] = 0;

   dw[496] = 0;

   dw[497] = 0;

   dw[498] = 0;

   dw[499] = 0;

   dw[500] = 0;

   dw[501] = 0;

   dw[502] = 0;

   dw[503] = 0;

   dw[504] = 0;

   dw[505] = 0;

   dw[506] = 0;

   dw[507] = 0;

   dw[508] = 0;

   dw[509] = 0;

   dw[510] = 0;

   dw[511] = 0;

   dw[512] = 0;

   dw[513] = 0;

   dw[514] = 0;

   dw[515] = 0;

   dw[516] = 0;

   dw[517] = 0;

   dw[518] = 0;

   dw[519] = 0;

   dw[520] = 0;

   dw[521] = 0;

   dw[522] = 0;

   dw[523] = 0;

   dw[524] = 0;

   dw[525] = 0;

   dw[526] = 0;

   dw[527] = 0;

   dw[528] = 0;

   dw[529] = 0;

   dw[530] = 0;

   dw[531] = 0;

   dw[532] = 0;

   dw[533] = 0;

   dw[534] = 0;

   dw[535] = 0;

   dw[536] = 0;

   dw[537] = 0;

   dw[538] = 0;

   dw[539] = 0;

   dw[540] = 0;

   dw[541] = 0;

   dw[542] = 0;

   dw[543] = 0;

   dw[544] = 0;

   dw[545] = 0;

   dw[546] = 0;

   dw[547] = 0;

   dw[548] = 0;

   dw[549] = 0;

   dw[550] = 0;

   dw[551] = 0;

   dw[552] = 0;

   dw[553] = 0;

   dw[554] = 0;

   dw[555] = 0;

   dw[556] = 0;

   dw[557] = 0;

   dw[558] = 0;

   dw[559] = 0;

   dw[560] = 0;

   dw[561] = 0;

   dw[562] = 0;

   dw[563] = 0;

   dw[564] = 0;

   dw[565] = 0;

   dw[566] = 0;

   dw[567] = 0;

   dw[568] = 0;

   dw[569] = 0;

   dw[570] = 0;

   dw[571] = 0;

   dw[572] = 0;

   dw[573] = 0;

   dw[574] = 0;

   dw[575] = 0;

   dw[576] = 0;

   dw[577] = 0;

   dw[578] = 0;

   dw[579] = 0;

   dw[580] = 0;

   dw[581] = 0;

   dw[582] = 0;

   dw[583] = 0;

   dw[584] = 0;

   dw[585] = 0;

   dw[586] = 0;

   dw[587] = 0;

   dw[588] = 0;

   dw[589] = 0;

   dw[590] = 0;

   dw[591] = 0;

   dw[592] = 0;

   dw[593] = 0;

   dw[594] = 0;

   dw[595] = 0;

   dw[596] = 0;

   dw[597] = 0;

   dw[598] = 0;

   dw[599] = 0;

   dw[600] = 0;

   dw[601] = 0;

   dw[602] = 0;

   dw[603] = 0;

   dw[604] = 0;

   dw[605] = 0;

   dw[606] = 0;

   dw[607] = 0;

   dw[608] = 0;

   dw[609] = 0;

   dw[610] = 0;

   dw[611] = 0;

   dw[612] = 0;

   dw[613] = 0;

   dw[614] = 0;

   dw[615] = 0;

   dw[616] = 0;

   dw[617] = 0;

   dw[618] = 0;

   dw[619] = 0;

   dw[620] = 0;

   dw[621] = 0;

   dw[622] = 0;

   dw[623] = 0;

   dw[624] = 0;

   dw[625] = 0;

   dw[626] = 0;

   dw[627] = 0;

   dw[628] = 0;

   dw[629] = 0;

   dw[630] = 0;

   dw[631] = 0;

   dw[632] = 0;

   dw[633] = 0;

   dw[634] = 0;

   dw[635] = 0;

   dw[636] = 0;

   dw[637] = 0;

   dw[638] = 0;

   dw[639] = 0;

   dw[640] = 0;

   dw[641] = 0;

   dw[642] = 0;

   dw[643] = 0;

   dw[644] = 0;

   dw[645] = 0;

   dw[646] = 0;

   dw[647] = 0;

   dw[648] = 0;

   dw[649] = 0;

   dw[650] = 0;

   dw[651] = 0;

   dw[652] = 0;

   dw[653] = 0;

   dw[654] = 0;

   dw[655] = 0;

   dw[656] = 0;

   dw[657] = 0;

   dw[658] = 0;

   dw[659] = 0;

   dw[660] = 0;

   dw[661] = 0;

   dw[662] = 0;

   dw[663] = 0;

   dw[664] = 0;

   dw[665] = 0;

   dw[666] = 0;

   dw[667] = 0;

   dw[668] = 0;

   dw[669] = 0;

   dw[670] = 0;

   dw[671] = 0;

   dw[672] = 0;

   dw[673] = 0;

   dw[674] = 0;

   dw[675] = 0;

   dw[676] = 0;

   dw[677] = 0;

   dw[678] = 0;

   dw[679] = 0;

   dw[680] = 0;

   dw[681] = 0;

   dw[682] = 0;

   dw[683] = 0;

   dw[684] = 0;

   dw[685] = 0;

   dw[686] = 0;

   dw[687] = 0;

   dw[688] = 0;

   dw[689] = 0;

   dw[690] = 0;

   dw[691] = 0;

   dw[692] = 0;

   dw[693] = 0;

   dw[694] = 0;

   dw[695] = 0;

   dw[696] = 0;

   dw[697] = 0;

   dw[698] = 0;

   dw[699] = 0;

   dw[700] = 0;

   dw[701] = 0;

   dw[702] = 0;

   dw[703] = 0;

   dw[704] = 0;

   dw[705] = 0;

   dw[706] = 0;

   dw[707] = 0;

   dw[708] = 0;

   dw[709] = 0;

   dw[710] = 0;

   dw[711] = 0;

   dw[712] = 0;

   dw[713] = 0;

   dw[714] = 0;

   dw[715] = 0;

   dw[716] = 0;

   dw[717] = 0;

   dw[718] = 0;

   dw[719] = 0;

   dw[720] = 0;

   dw[721] = 0;

   dw[722] = 0;

   dw[723] = 0;

   dw[724] = 0;

   dw[725] = 0;

   dw[726] = 0;

   dw[727] = 0;

   dw[728] = 0;

   dw[729] = 0;

   dw[730] = 0;

   dw[731] = 0;

   dw[732] = 0;

   dw[733] = 0;

   dw[734] = 0;

   dw[735] = 0;

   dw[736] = 0;

   dw[737] = 0;

   dw[738] = 0;

   dw[739] = 0;

   dw[740] = 0;

   dw[741] = 0;

   dw[742] = 0;

   dw[743] = 0;

   dw[744] = 0;

   dw[745] = 0;

   dw[746] = 0;

   dw[747] = 0;

   dw[748] = 0;

   dw[749] = 0;

   dw[750] = 0;

   dw[751] = 0;

   dw[752] = 0;

   dw[753] = 0;

   dw[754] = 0;

   dw[755] = 0;

   dw[756] = 0;

   dw[757] = 0;

   dw[758] = 0;

   dw[759] = 0;

   dw[760] = 0;

   dw[761] = 0;

   dw[762] = 0;

   dw[763] = 0;

   dw[764] = 0;

   dw[765] = 0;

   dw[766] = 0;

   dw[767] = 0;

   dw[768] = 0;

   dw[769] = 0;

   dw[770] = 0;

   dw[771] = 0;

   dw[772] = 0;

   dw[773] = 0;

   dw[774] = 0;

   dw[775] = 0;

   dw[776] = 0;

   dw[777] = 0;

   dw[778] = 0;

   dw[779] = 0;

   dw[780] = 0;

   dw[781] = 0;

   dw[782] = 0;

   dw[783] = 0;

   dw[784] = 0;

   dw[785] = 0;

   dw[786] = 0;

   dw[787] = 0;

   dw[788] = 0;

   dw[789] = 0;

   dw[790] = 0;

   dw[791] = 0;

   dw[792] = 0;

   dw[793] = 0;

   dw[794] = 0;

   dw[795] = 0;

   dw[796] = 0;

   dw[797] = 0;

   dw[798] = 0;

   dw[799] = 0;

   dw[800] = 0;

   dw[801] = 0;

   dw[802] = 0;

   dw[803] = 0;

   dw[804] = 0;

   dw[805] = 0;

   dw[806] = 0;

   dw[807] = 0;

   dw[808] = 0;

   dw[809] = 0;

   dw[810] = 0;

   dw[811] = 0;

   dw[812] = 0;

   dw[813] = 0;

   dw[814] = 0;

   dw[815] = 0;

   dw[816] = 0;

   dw[817] = 0;

   dw[818] = 0;

   dw[819] = 0;

   dw[820] = 0;

   dw[821] = 0;

   dw[822] = 0;

   dw[823] = 0;

   dw[824] = 0;

   dw[825] = 0;

   dw[826] = 0;

   dw[827] = 0;

   dw[828] = 0;

   dw[829] = 0;

   dw[830] = 0;
}

#define GFX20_MFX_JPEG_PIC_STATE_length        3
#define GFX20_MFX_JPEG_PIC_STATE_length_bias      2
#define GFX20_MFX_JPEG_PIC_STATE_header         \
   .DWordLength                         =      1,  \
   .SubOpcodeB                          =      0,  \
   .SubOpcodeA                          =      0,  \
   .MediaCommandOpcode                  =      7,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFX_JPEG_PIC_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             InputFormatYUV;
   uint32_t                             OutputMCUStructure;
#define MCU_YUV400                               0
#define MCU_YUV420                               1
#define MCU_YUV422H_2Y                           2
#define MCU_RGB                                  3
   uint32_t                             Rotation;
   uint32_t                             OutputFormatYUV;
   uint32_t                             InputSurfaceFormatYUV;
#define IS_NV12                                  1
#define IS_UYVY                                  2
#define IS_YUY2                                  3
#define IS_Y8                                    4
#define IS_RGB                                   5
   uint32_t                             AverageDownSampling;
   bool                                 VerticalDownSamplingEnable;
   bool                                 HorizontalDownSamplingEnable;
   bool                                 VerticalUpSamplingEnable;
   uint32_t                             PixelsInVerticalLastMCU;
   uint32_t                             PixelsInHorizontalLastMCU;
   uint32_t                             FrameWidthInBlocks;
   uint32_t                             RoundingQuant;
   uint32_t                             FrameHeightInBlocks;
   uint32_t                             OutputPixelNormalize;
};

static inline __attribute__((always_inline)) void
GFX20_MFX_JPEG_PIC_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                              __attribute__((unused)) void * restrict dst,
                              __attribute__((unused)) const struct GFX20_MFX_JPEG_PIC_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpcode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->InputFormatYUV, 0, 2) |
      util_bitpack_uint(values->OutputMCUStructure, 0, 2) |
      util_bitpack_uint(values->Rotation, 4, 5) |
      util_bitpack_uint(values->OutputFormatYUV, 8, 11) |
      util_bitpack_uint(values->InputSurfaceFormatYUV, 8, 11) |
      util_bitpack_uint(values->AverageDownSampling, 16, 16) |
      util_bitpack_uint(values->VerticalDownSamplingEnable, 17, 17) |
      util_bitpack_uint(values->HorizontalDownSamplingEnable, 18, 18) |
      util_bitpack_uint(values->VerticalUpSamplingEnable, 20, 20) |
      util_bitpack_uint(values->PixelsInVerticalLastMCU, 21, 25) |
      util_bitpack_uint(values->PixelsInHorizontalLastMCU, 26, 30);

   dw[2] =
      util_bitpack_uint(values->FrameWidthInBlocks, 0, 12) |
      util_bitpack_uint(values->RoundingQuant, 13, 15) |
      util_bitpack_uint(values->FrameHeightInBlocks, 16, 28) |
      util_bitpack_uint(values->OutputPixelNormalize, 29, 29);
}

#define GFX20_MFX_MPEG2_PIC_STATE_length       2
#define GFX20_MFX_MPEG2_PIC_STATE_length_bias      2
#define GFX20_MFX_MPEG2_PIC_STATE_header        \
   .DWordLength                         =      0,  \
   .SubOpcodeB                          =      0,  \
   .SubOpcodeA                          =      0,  \
   .MediaCommandOpcode                  =      3,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFX_MPEG2_PIC_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             ScanOrder;
#define MPEG_ZIGZAG_SCAN                         0
#define MPEG_ALTERNATE_VERTICAL_SCAN             1
   uint32_t                             IntraVLCFormat;
   uint32_t                             QuantizerScaleType;
#define MPEG_QSCALE_LINEAR                       0
#define MPEG_QSCALE_NONLINEAR                    1
   bool                                 ConcealmentMV;
   uint32_t                             FramePredictionFrameDCT;
   bool                                 TopFieldFirst;
   uint32_t                             PictureStructure;
#define MPEG_TOP_FIELD                           1
#define MPEG_BOTTOM_FIELD                        2
#define MPEG_FRAME                               3
   uint32_t                             IntraDCPrecision;
   uint32_t                             F_code00;
   uint32_t                             F_code01;
   uint32_t                             F_code10;
   uint32_t                             F_code11;
   bool                                 DisableMismatch;
   bool                                 MismatchControlDisable;
   uint32_t                             PictureCodingType;
#define MPEG_I_PICTURE                           1
#define MPEG_P_PICTURE                           2
#define MPEG_B_PICTURE                           3
   bool                                 LoadBitstreamPointerPerSlice;
   uint32_t                             PBSlicePredictedMVOverride;
#define Predicted                                0
#define ZERO                                     1
   uint32_t                             PBSlicePredictedBidirectionMVTypeOverride;
#define MPEG2_MVTO_BID                           0
#define MPEG2_MVTO_RESERVED                      1
#define MPEG2_MVTO_FWD                           2
#define MPEG2_MVTO_BWD                           3
   uint32_t                             PBSliceConcealmentMode;
#define MPEG2_CM_INTER                           0
#define MPEG2_CM_LEFT                            1
#define MPEG2_CM_ZERO                            2
#define MPEG2_CM_INTRA                           3
   uint32_t                             ISliceConcealmentMode;
#define MPEG2_CM_IntraConcealment                0
#define MPEG2_CM_InterConcealment                1
   uint32_t                             FrameWidthInMBs;
   uint32_t                             FrameHeightInMBs;
   bool                                 SliceConcealmentDisable;
   uint32_t                             RoundIntraDC;
   uint32_t                             RoundInterDC;
   uint32_t                             RoundIntraAC;
   uint32_t                             RoundInterAC;
   uint32_t                             MinimumFrameSize;
   uint32_t                             IntraMBMaxBitControl;
   uint32_t                             InterMBMaxBitControl;
   uint32_t                             FrameBitrateMaxReport;
   uint32_t                             FrameBitrateMinReport;
   uint32_t                             MBRateControlMask;
   uint32_t                             MinimumFrameSizeUnits;
#define MPEG2_MFSU_Compatibilitymode             0
#define MPEG2_MFSU_16bytes                       1
#define MPEG2_MFSU_4Kb                           2
#define MPEG2_MFSU_16Kb                          3
   uint32_t                             InterMBForceCBPtoZeroControl;
   uint32_t                             FrameSizeControl;
   uint32_t                             IntraMBConformanceMaxSize;
   uint32_t                             InterMBConformanceMaxSize;
   int32_t                              SliceDeltaQPMax0;
   int32_t                              SliceDeltaQPMax1;
   int32_t                              SliceDeltaQPMax2;
   int32_t                              SliceDeltaQPMax3;
   int32_t                              SliceDeltaQPMin0;
   int32_t                              SliceDeltaQPMin1;
   int32_t                              SliceDeltaQPMin2;
   int32_t                              SliceDeltaQPMin3;
   uint32_t                             FrameBitrateMin;
   uint32_t                             FrameBitrateMinUnitMode;
#define Compatibilitymode                        0
#define Newmode                                  1
   uint32_t                             FrameBitrateMinUnit;
   uint32_t                             FrameBitrateMax;
   uint32_t                             FrameBitrateMaxUnitMode;
#define Compatibilitymode                        0
#define Newmode                                  1
   uint32_t                             FrameBitrateMaxUnit;
   uint32_t                             FrameBitrateMinDelta;
   uint32_t                             FrameBitrateMaxDelta;
};

static inline __attribute__((always_inline)) void
GFX20_MFX_MPEG2_PIC_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                               __attribute__((unused)) void * restrict dst,
                               __attribute__((unused)) const struct GFX20_MFX_MPEG2_PIC_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpcode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->ScanOrder, 6, 6) |
      util_bitpack_uint(values->IntraVLCFormat, 7, 7) |
      util_bitpack_uint(values->QuantizerScaleType, 8, 8) |
      util_bitpack_uint(values->ConcealmentMV, 9, 9) |
      util_bitpack_uint(values->FramePredictionFrameDCT, 10, 10) |
      util_bitpack_uint(values->TopFieldFirst, 11, 11) |
      util_bitpack_uint(values->PictureStructure, 12, 13) |
      util_bitpack_uint(values->IntraDCPrecision, 14, 15) |
      util_bitpack_uint(values->F_code00, 16, 19) |
      util_bitpack_uint(values->F_code01, 20, 23) |
      util_bitpack_uint(values->F_code10, 24, 27) |
      util_bitpack_uint(values->F_code11, 28, 31);
}

#define GFX20_MFX_PAK_INSERT_OBJECT_length_bias      2
#define GFX20_MFX_PAK_INSERT_OBJECT_header      \
   .DWordLength                         =      0,  \
   .SubOpcodeB                          =      8,  \
   .SubOpcodeA                          =      2,  \
   .MediaCommandOpcode                  =      0,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFX_PAK_INSERT_OBJECT {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   bool                                 BitstreamStartReset;
   bool                                 EndofSlice;
   bool                                 LastHeader;
   bool                                 EmulationByteBitsInsertEnable;
   uint32_t                             SkipEmulationByteCount;
   uint32_t                             DataBitsInLastDW;
   uint32_t                             SliceHeaderIndicator;
#define SLICE_HEADER                             1
#define LEGACY                                   0
   uint32_t                             HeaderLengthExcludedFromSize;
#define NO_ACCUMULATION                          1
#define ACCUMULATE                               0
   uint32_t                             DataByteOffset;
   /* variable length fields follow */
};

static inline __attribute__((always_inline)) void
GFX20_MFX_PAK_INSERT_OBJECT_pack(__attribute__((unused)) __gen_user_data *data,
                                 __attribute__((unused)) void * restrict dst,
                                 __attribute__((unused)) const struct GFX20_MFX_PAK_INSERT_OBJECT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpcode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->BitstreamStartReset, 0, 0) |
      util_bitpack_uint(values->EndofSlice, 1, 1) |
      util_bitpack_uint(values->LastHeader, 2, 2) |
      util_bitpack_uint(values->EmulationByteBitsInsertEnable, 3, 3) |
      util_bitpack_uint(values->SkipEmulationByteCount, 4, 7) |
      util_bitpack_uint(values->DataBitsInLastDW, 8, 13) |
      util_bitpack_uint(values->SliceHeaderIndicator, 14, 14) |
      util_bitpack_uint(values->HeaderLengthExcludedFromSize, 15, 15) |
      util_bitpack_uint(values->DataByteOffset, 16, 17);
}

#define GFX20_MFX_PIPE_BUF_ADDR_STATE_length     65
#define GFX20_MFX_PIPE_BUF_ADDR_STATE_length_bias      2
#define GFX20_MFX_PIPE_BUF_ADDR_STATE_header    \
   .DWordLength                         =     63,  \
   .SubOpcodeB                          =      2,  \
   .SubOpcodeA                          =      0,  \
   .MediaCommandOpcode                  =      0,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFX_PIPE_BUF_ADDR_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   __gen_address_type                   PreDeblockingDestinationAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES PreDeblockingDestinationAttributes;
   __gen_address_type                   PostDeblockingDestinationAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES PostDeblockingDestinationAttributes;
   __gen_address_type                   OriginalUncompressedPictureSourceAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES OriginalUncompressedPictureSourceAttributes;
   __gen_address_type                   StreamOutDataDestinationAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES StreamOutDataDestinationAttributes;
   __gen_address_type                   IntraRowStoreScratchBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES IntraRowStoreScratchBufferAttributes;
   __gen_address_type                   DeblockingFilterRowStoreScratchAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES DeblockingFilterRowStoreScratchAttributes;
   __gen_address_type                   ReferencePictureAddress[16];
   struct GFX20_MEMORYADDRESSATTRIBUTES ReferencePictureAttributes;
   __gen_address_type                   MBStatusBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES MBStatusBufferAttributes;
   __gen_address_type                   MBILDBStreamOutBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES MBILDBStreamOutBufferAttributes;
   __gen_address_type                   SecondMBILDBStreamOutBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES SecondMBILDBStreamOutBufferAttributes;
   uint32_t                             ReferencePictureMemoryCompressionMode[16];
   bool                                 ReferencePictureMemoryCompressionEnable[16];
   __gen_address_type                   ScaledReferenceSurfaceAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES ScaledReferenceSurfaceAttributes;
};

static inline __attribute__((always_inline)) void
GFX20_MFX_PIPE_BUF_ADDR_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                                   __attribute__((unused)) void * restrict dst,
                                   __attribute__((unused)) const struct GFX20_MFX_PIPE_BUF_ADDR_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpcode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   const uint64_t v1_address =
      __gen_address(data, &dw[1], values->PreDeblockingDestinationAddress, 0, 6, 47);
   dw[1] = v1_address;
   dw[2] = v1_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[3], &values->PreDeblockingDestinationAttributes);

   const uint64_t v4_address =
      __gen_address(data, &dw[4], values->PostDeblockingDestinationAddress, 0, 6, 47);
   dw[4] = v4_address;
   dw[5] = v4_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[6], &values->PostDeblockingDestinationAttributes);

   const uint64_t v7_address =
      __gen_address(data, &dw[7], values->OriginalUncompressedPictureSourceAddress, 0, 6, 47);
   dw[7] = v7_address;
   dw[8] = v7_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[9], &values->OriginalUncompressedPictureSourceAttributes);

   const uint64_t v10_address =
      __gen_address(data, &dw[10], values->StreamOutDataDestinationAddress, 0, 6, 47);
   dw[10] = v10_address;
   dw[11] = v10_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[12], &values->StreamOutDataDestinationAttributes);

   const uint64_t v13_address =
      __gen_address(data, &dw[13], values->IntraRowStoreScratchBufferAddress, 0, 6, 47);
   dw[13] = v13_address;
   dw[14] = v13_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[15], &values->IntraRowStoreScratchBufferAttributes);

   const uint64_t v16_address =
      __gen_address(data, &dw[16], values->DeblockingFilterRowStoreScratchAddress, 0, 6, 47);
   dw[16] = v16_address;
   dw[17] = v16_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[18], &values->DeblockingFilterRowStoreScratchAttributes);

   const uint64_t v19_address =
      __gen_address(data, &dw[19], values->ReferencePictureAddress[0], 0, 0, 63);
   dw[19] = v19_address;
   dw[20] = v19_address >> 32;

   const uint64_t v21_address =
      __gen_address(data, &dw[21], values->ReferencePictureAddress[1], 0, 0, 63);
   dw[21] = v21_address;
   dw[22] = v21_address >> 32;

   const uint64_t v23_address =
      __gen_address(data, &dw[23], values->ReferencePictureAddress[2], 0, 0, 63);
   dw[23] = v23_address;
   dw[24] = v23_address >> 32;

   const uint64_t v25_address =
      __gen_address(data, &dw[25], values->ReferencePictureAddress[3], 0, 0, 63);
   dw[25] = v25_address;
   dw[26] = v25_address >> 32;

   const uint64_t v27_address =
      __gen_address(data, &dw[27], values->ReferencePictureAddress[4], 0, 0, 63);
   dw[27] = v27_address;
   dw[28] = v27_address >> 32;

   const uint64_t v29_address =
      __gen_address(data, &dw[29], values->ReferencePictureAddress[5], 0, 0, 63);
   dw[29] = v29_address;
   dw[30] = v29_address >> 32;

   const uint64_t v31_address =
      __gen_address(data, &dw[31], values->ReferencePictureAddress[6], 0, 0, 63);
   dw[31] = v31_address;
   dw[32] = v31_address >> 32;

   const uint64_t v33_address =
      __gen_address(data, &dw[33], values->ReferencePictureAddress[7], 0, 0, 63);
   dw[33] = v33_address;
   dw[34] = v33_address >> 32;

   const uint64_t v35_address =
      __gen_address(data, &dw[35], values->ReferencePictureAddress[8], 0, 0, 63);
   dw[35] = v35_address;
   dw[36] = v35_address >> 32;

   const uint64_t v37_address =
      __gen_address(data, &dw[37], values->ReferencePictureAddress[9], 0, 0, 63);
   dw[37] = v37_address;
   dw[38] = v37_address >> 32;

   const uint64_t v39_address =
      __gen_address(data, &dw[39], values->ReferencePictureAddress[10], 0, 0, 63);
   dw[39] = v39_address;
   dw[40] = v39_address >> 32;

   const uint64_t v41_address =
      __gen_address(data, &dw[41], values->ReferencePictureAddress[11], 0, 0, 63);
   dw[41] = v41_address;
   dw[42] = v41_address >> 32;

   const uint64_t v43_address =
      __gen_address(data, &dw[43], values->ReferencePictureAddress[12], 0, 0, 63);
   dw[43] = v43_address;
   dw[44] = v43_address >> 32;

   const uint64_t v45_address =
      __gen_address(data, &dw[45], values->ReferencePictureAddress[13], 0, 0, 63);
   dw[45] = v45_address;
   dw[46] = v45_address >> 32;

   const uint64_t v47_address =
      __gen_address(data, &dw[47], values->ReferencePictureAddress[14], 0, 0, 63);
   dw[47] = v47_address;
   dw[48] = v47_address >> 32;

   const uint64_t v49_address =
      __gen_address(data, &dw[49], values->ReferencePictureAddress[15], 0, 0, 63);
   dw[49] = v49_address;
   dw[50] = v49_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[51], &values->ReferencePictureAttributes);

   const uint64_t v52_address =
      __gen_address(data, &dw[52], values->MBStatusBufferAddress, 0, 6, 47);
   dw[52] = v52_address;
   dw[53] = v52_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[54], &values->MBStatusBufferAttributes);

   const uint64_t v55_address =
      __gen_address(data, &dw[55], values->MBILDBStreamOutBufferAddress, 0, 6, 47);
   dw[55] = v55_address;
   dw[56] = v55_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[57], &values->MBILDBStreamOutBufferAttributes);

   const uint64_t v58_address =
      __gen_address(data, &dw[58], values->SecondMBILDBStreamOutBufferAddress, 0, 6, 47);
   dw[58] = v58_address;
   dw[59] = v58_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[60], &values->SecondMBILDBStreamOutBufferAttributes);

   dw[61] =
      util_bitpack_uint(values->ReferencePictureMemoryCompressionMode[0], 1, 1) |
      util_bitpack_uint(values->ReferencePictureMemoryCompressionEnable[0], 0, 0) |
      util_bitpack_uint(values->ReferencePictureMemoryCompressionMode[1], 3, 3) |
      util_bitpack_uint(values->ReferencePictureMemoryCompressionEnable[1], 2, 2) |
      util_bitpack_uint(values->ReferencePictureMemoryCompressionMode[2], 5, 5) |
      util_bitpack_uint(values->ReferencePictureMemoryCompressionEnable[2], 4, 4) |
      util_bitpack_uint(values->ReferencePictureMemoryCompressionMode[3], 7, 7) |
      util_bitpack_uint(values->ReferencePictureMemoryCompressionEnable[3], 6, 6) |
      util_bitpack_uint(values->ReferencePictureMemoryCompressionMode[4], 9, 9) |
      util_bitpack_uint(values->ReferencePictureMemoryCompressionEnable[4], 8, 8) |
      util_bitpack_uint(values->ReferencePictureMemoryCompressionMode[5], 11, 11) |
      util_bitpack_uint(values->ReferencePictureMemoryCompressionEnable[5], 10, 10) |
      util_bitpack_uint(values->ReferencePictureMemoryCompressionMode[6], 13, 13) |
      util_bitpack_uint(values->ReferencePictureMemoryCompressionEnable[6], 12, 12) |
      util_bitpack_uint(values->ReferencePictureMemoryCompressionMode[7], 15, 15) |
      util_bitpack_uint(values->ReferencePictureMemoryCompressionEnable[7], 14, 14) |
      util_bitpack_uint(values->ReferencePictureMemoryCompressionMode[8], 17, 17) |
      util_bitpack_uint(values->ReferencePictureMemoryCompressionEnable[8], 16, 16) |
      util_bitpack_uint(values->ReferencePictureMemoryCompressionMode[9], 19, 19) |
      util_bitpack_uint(values->ReferencePictureMemoryCompressionEnable[9], 18, 18) |
      util_bitpack_uint(values->ReferencePictureMemoryCompressionMode[10], 21, 21) |
      util_bitpack_uint(values->ReferencePictureMemoryCompressionEnable[10], 20, 20) |
      util_bitpack_uint(values->ReferencePictureMemoryCompressionMode[11], 23, 23) |
      util_bitpack_uint(values->ReferencePictureMemoryCompressionEnable[11], 22, 22) |
      util_bitpack_uint(values->ReferencePictureMemoryCompressionMode[12], 25, 25) |
      util_bitpack_uint(values->ReferencePictureMemoryCompressionEnable[12], 24, 24) |
      util_bitpack_uint(values->ReferencePictureMemoryCompressionMode[13], 27, 27) |
      util_bitpack_uint(values->ReferencePictureMemoryCompressionEnable[13], 26, 26) |
      util_bitpack_uint(values->ReferencePictureMemoryCompressionMode[14], 29, 29) |
      util_bitpack_uint(values->ReferencePictureMemoryCompressionEnable[14], 28, 28) |
      util_bitpack_uint(values->ReferencePictureMemoryCompressionMode[15], 31, 31) |
      util_bitpack_uint(values->ReferencePictureMemoryCompressionEnable[15], 30, 30);

   const uint64_t v62_address =
      __gen_address(data, &dw[62], values->ScaledReferenceSurfaceAddress, 0, 6, 47);
   dw[62] = v62_address;
   dw[63] = v62_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[64], &values->ScaledReferenceSurfaceAttributes);
}

#define GFX20_MFX_PIPE_MODE_SELECT_length      5
#define GFX20_MFX_PIPE_MODE_SELECT_length_bias      2
#define GFX20_MFX_PIPE_MODE_SELECT_header       \
   .DWordLength                         =      3,  \
   .SubOpcodeB                          =      0,  \
   .SubOpcodeA                          =      0,  \
   .MediaCommandOpcode                  =      0,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFX_PIPE_MODE_SELECT {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             StandardSelect;
#define SS_MPEG2                                 0
#define SS_VC1                                   1
#define SS_AVC                                   2
#define SS_JPEG                                  3
#define SS_VP8                                   5
#define SS_UVLD                                  15
   uint32_t                             CodecSelect;
#define Decode                                   0
#define Encode                                   1
   bool                                 StitchMode;
   bool                                 FrameStatisticsStreamOutEnable;
   bool                                 ScaledSurfaceEnable;
   bool                                 PreDeblockingOutputEnable;
   bool                                 PostDeblockingOutputEnable;
   bool                                 StreamOutEnable;
   bool                                 PicErrorStatusReportEnable;
   bool                                 DeblockerStreamOutEnable;
   uint32_t                             VDEncMode;
#define VM_MBEncMode                             0
#define VM_VDEncMode                             1
   bool                                 StandaloneVDEncModeEnable;
   uint32_t                             DecoderModeSelect;
#define VLDMode                                  0
#define ITMode                                   1
#define DeblockerMode                            2
#define InterlayerMode                           3
   uint32_t                             DecoderShortFormatMode;
#define ShortFormatDriverInterface               0
#define LongFormatDriverInterface                1
   bool                                 ExtendedStreamOutEnable;
   uint32_t                             AESControl;
   uint32_t                             PicStatusErrorReportID;
};

static inline __attribute__((always_inline)) void
GFX20_MFX_PIPE_MODE_SELECT_pack(__attribute__((unused)) __gen_user_data *data,
                                __attribute__((unused)) void * restrict dst,
                                __attribute__((unused)) const struct GFX20_MFX_PIPE_MODE_SELECT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpcode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->StandardSelect, 0, 3) |
      util_bitpack_uint(values->CodecSelect, 4, 4) |
      util_bitpack_uint(values->StitchMode, 5, 5) |
      util_bitpack_uint(values->FrameStatisticsStreamOutEnable, 6, 6) |
      util_bitpack_uint(values->ScaledSurfaceEnable, 7, 7) |
      util_bitpack_uint(values->PreDeblockingOutputEnable, 8, 8) |
      util_bitpack_uint(values->PostDeblockingOutputEnable, 9, 9) |
      util_bitpack_uint(values->StreamOutEnable, 10, 10) |
      util_bitpack_uint(values->PicErrorStatusReportEnable, 11, 11) |
      util_bitpack_uint(values->DeblockerStreamOutEnable, 12, 12) |
      util_bitpack_uint(values->VDEncMode, 13, 13) |
      util_bitpack_uint(values->StandaloneVDEncModeEnable, 14, 14) |
      util_bitpack_uint(values->DecoderModeSelect, 15, 16) |
      util_bitpack_uint(values->DecoderShortFormatMode, 17, 17) |
      util_bitpack_uint(values->ExtendedStreamOutEnable, 18, 18) |
      util_bitpack_uint(values->AESControl, 24, 31);

   dw[2] = 0;

   dw[3] =
      util_bitpack_uint(values->PicStatusErrorReportID, 0, 31);

   dw[4] = 0;
}

#define GFX20_MFX_QM_STATE_length             18
#define GFX20_MFX_QM_STATE_length_bias         2
#define GFX20_MFX_QM_STATE_header               \
   .DWordLength                         =     16,  \
   .SubOpcodeB                          =      7,  \
   .SubOpcodeA                          =      0,  \
   .MediaCommandOpcode                  =      0,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFX_QM_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             AVC;
#define AVC_4x4_Intra_MATRIX                     0
#define AVC_4x4_Inter_MATRIX                     1
#define AVC_8x8_Intra_MATRIX                     2
#define AVC_8x8_Inter_MATRIX                     3
   uint32_t                             MPEG2;
#define MPEG_INTRA_QUANTIZER_MATRIX              0
#define MPEG_NON_INTRA_QUANTIZER_MATRIX          1
   uint32_t                             JPEG;
#define JPEG_Luma_Y_QUANTIZER_MATRIXorR          0
#define JPEG_Chroma_Cb_QUANTIZER_MATRIXorG       1
#define JPEG_Chroma_Cr_QUANTIZER_MATRIXorB       2
   uint32_t                             ForwardQuantizerMatrix[64];
};

static inline __attribute__((always_inline)) void
GFX20_MFX_QM_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                        __attribute__((unused)) void * restrict dst,
                        __attribute__((unused)) const struct GFX20_MFX_QM_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpcode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->AVC, 0, 1) |
      util_bitpack_uint(values->MPEG2, 0, 1) |
      util_bitpack_uint(values->JPEG, 0, 1);

   dw[2] =
      util_bitpack_uint(values->ForwardQuantizerMatrix[0], 0, 7) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[1], 8, 15) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[2], 16, 23) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[3], 24, 31);

   dw[3] =
      util_bitpack_uint(values->ForwardQuantizerMatrix[4], 0, 7) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[5], 8, 15) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[6], 16, 23) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[7], 24, 31);

   dw[4] =
      util_bitpack_uint(values->ForwardQuantizerMatrix[8], 0, 7) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[9], 8, 15) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[10], 16, 23) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[11], 24, 31);

   dw[5] =
      util_bitpack_uint(values->ForwardQuantizerMatrix[12], 0, 7) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[13], 8, 15) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[14], 16, 23) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[15], 24, 31);

   dw[6] =
      util_bitpack_uint(values->ForwardQuantizerMatrix[16], 0, 7) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[17], 8, 15) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[18], 16, 23) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[19], 24, 31);

   dw[7] =
      util_bitpack_uint(values->ForwardQuantizerMatrix[20], 0, 7) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[21], 8, 15) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[22], 16, 23) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[23], 24, 31);

   dw[8] =
      util_bitpack_uint(values->ForwardQuantizerMatrix[24], 0, 7) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[25], 8, 15) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[26], 16, 23) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[27], 24, 31);

   dw[9] =
      util_bitpack_uint(values->ForwardQuantizerMatrix[28], 0, 7) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[29], 8, 15) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[30], 16, 23) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[31], 24, 31);

   dw[10] =
      util_bitpack_uint(values->ForwardQuantizerMatrix[32], 0, 7) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[33], 8, 15) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[34], 16, 23) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[35], 24, 31);

   dw[11] =
      util_bitpack_uint(values->ForwardQuantizerMatrix[36], 0, 7) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[37], 8, 15) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[38], 16, 23) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[39], 24, 31);

   dw[12] =
      util_bitpack_uint(values->ForwardQuantizerMatrix[40], 0, 7) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[41], 8, 15) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[42], 16, 23) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[43], 24, 31);

   dw[13] =
      util_bitpack_uint(values->ForwardQuantizerMatrix[44], 0, 7) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[45], 8, 15) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[46], 16, 23) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[47], 24, 31);

   dw[14] =
      util_bitpack_uint(values->ForwardQuantizerMatrix[48], 0, 7) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[49], 8, 15) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[50], 16, 23) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[51], 24, 31);

   dw[15] =
      util_bitpack_uint(values->ForwardQuantizerMatrix[52], 0, 7) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[53], 8, 15) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[54], 16, 23) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[55], 24, 31);

   dw[16] =
      util_bitpack_uint(values->ForwardQuantizerMatrix[56], 0, 7) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[57], 8, 15) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[58], 16, 23) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[59], 24, 31);

   dw[17] =
      util_bitpack_uint(values->ForwardQuantizerMatrix[60], 0, 7) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[61], 8, 15) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[62], 16, 23) |
      util_bitpack_uint(values->ForwardQuantizerMatrix[63], 24, 31);
}

#define GFX20_MFX_STATE_POINTER_length         2
#define GFX20_MFX_STATE_POINTER_length_bias      2
#define GFX20_MFX_STATE_POINTER_header          \
   .DWordLength                         =      0,  \
   .SubOpcodeB                          =      6,  \
   .SubOpcodeA                          =      0,  \
   .MediaCommandOpcode                  =      0,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFX_STATE_POINTER {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             StatePointerIndex;
   uint32_t                             StatePointer;
};

static inline __attribute__((always_inline)) void
GFX20_MFX_STATE_POINTER_pack(__attribute__((unused)) __gen_user_data *data,
                             __attribute__((unused)) void * restrict dst,
                             __attribute__((unused)) const struct GFX20_MFX_STATE_POINTER * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpcode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->StatePointerIndex, 0, 1) |
      util_bitpack_uint(values->StatePointer, 5, 31);
}

#define GFX20_MFX_STITCH_OBJECT_length_bias      2
#define GFX20_MFX_STITCH_OBJECT_header          \
   .DWordLength                         =      0,  \
   .SubOpcodeB                          =     10,  \
   .SubOpcodeA                          =      2,  \
   .MediaCommandOpcode                  =      0,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFX_STITCH_OBJECT {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   bool                                 EndofSlice;
   bool                                 LastHeader;
   uint32_t                             SourceDataEndingBitInclusion;
   uint32_t                             SourceDataStartingByteOffset;
   uint32_t                             IndirectDataLength;
   uint64_t                             IndirectDataStartAddress;
   /* variable length fields follow */
};

static inline __attribute__((always_inline)) void
GFX20_MFX_STITCH_OBJECT_pack(__attribute__((unused)) __gen_user_data *data,
                             __attribute__((unused)) void * restrict dst,
                             __attribute__((unused)) const struct GFX20_MFX_STITCH_OBJECT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpcode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->EndofSlice, 1, 1) |
      util_bitpack_uint(values->LastHeader, 2, 2) |
      util_bitpack_uint(values->SourceDataEndingBitInclusion, 8, 13) |
      util_bitpack_uint(values->SourceDataStartingByteOffset, 16, 17);

   dw[2] =
      util_bitpack_uint(values->IndirectDataLength, 0, 18);

   dw[3] =
      __gen_offset(values->IndirectDataStartAddress, 0, 31);
}

#define GFX20_MFX_SURFACE_STATE_length         6
#define GFX20_MFX_SURFACE_STATE_length_bias      2
#define GFX20_MFX_SURFACE_STATE_header          \
   .DWordLength                         =      4,  \
   .SubOpcodeB                          =      1,  \
   .SubOpcodeA                          =      0,  \
   .MediaCommandOpcode                  =      0,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFX_SURFACE_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             SurfaceID;
#define MFX_ReferencePicture                     0
#define MFX_SourceInputPicture                   4
#define MFX_ReconstructedScaledReferencePicture  5
   float                                CrVCbUPixelOffsetVDirection;
   uint32_t                             Width;
   uint32_t                             Height;
   uint32_t                             TileWalk;
#define TW_XMAJOR                                0
#define TW_YMAJOR                                1
   bool                                 TiledSurface;
   bool                                 HalfPitchforChroma;
   uint32_t                             SurfacePitch;
   bool                                 InterleaveChroma;
   uint32_t                             SurfaceFormat;
#define MFX_YCRCB_NORMAL                         0
#define MFX_YCRCB_SWAPUVY                        1
#define MFX_YCRCB_SWAPUV                         2
#define MFX_YCRCB_SWAPY                          3
#define MFX_PLANAR_420_8                         4
#define MFX_PLANAR_411_8                         5
#define MFX_PLANAR_422_8                         6
#define MFX_STMM_DN_STATISTICS                   7
#define MFX_R10G10B10A2_UNORM                    8
#define MFX_R8G8B8A8_UNORM                       9
#define MFX_R8B8_UNORMCrCb                       10
#define MFX_R8_UNORMCrCb                         11
#define MFX_Y8_UNORM                             12
   uint32_t                             YOffsetforUCb;
   uint32_t                             XOffsetforUCb;
   uint32_t                             YOffsetforVCr;
   uint32_t                             XOffsetforVCr;
};

static inline __attribute__((always_inline)) void
GFX20_MFX_SURFACE_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                             __attribute__((unused)) void * restrict dst,
                             __attribute__((unused)) const struct GFX20_MFX_SURFACE_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpcode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->SurfaceID, 0, 3);

   dw[2] =
      util_bitpack_ufixed(values->CrVCbUPixelOffsetVDirection, 0, 1, 2) |
      util_bitpack_uint(values->Width, 4, 17) |
      util_bitpack_uint(values->Height, 18, 31);

   dw[3] =
      util_bitpack_uint(values->TileWalk, 0, 0) |
      util_bitpack_uint(values->TiledSurface, 1, 1) |
      util_bitpack_uint(values->HalfPitchforChroma, 2, 2) |
      util_bitpack_uint(values->SurfacePitch, 3, 19) |
      util_bitpack_uint(values->InterleaveChroma, 27, 27) |
      util_bitpack_uint(values->SurfaceFormat, 28, 31);

   dw[4] =
      util_bitpack_uint(values->YOffsetforUCb, 0, 14) |
      util_bitpack_uint(values->XOffsetforUCb, 16, 30);

   dw[5] =
      util_bitpack_uint(values->YOffsetforVCr, 0, 15) |
      util_bitpack_uint(values->XOffsetforVCr, 16, 28);
}

#define GFX20_MFX_VC1_DIRECTMODE_STATE_length      7
#define GFX20_MFX_VC1_DIRECTMODE_STATE_length_bias      2
#define GFX20_MFX_VC1_DIRECTMODE_STATE_header   \
   .DWordLength                         =      5,  \
   .SubOpcodeB                          =      2,  \
   .SubOpcodeA                          =      0,  \
   .MediaCommandOpcode                  =      2,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFX_VC1_DIRECTMODE_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   __gen_address_type                   DirectMVWriteBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES DirectMVWriteBufferAttributes;
   __gen_address_type                   DirectMVReadBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES DirectMVReadBufferAttributes;
};

static inline __attribute__((always_inline)) void
GFX20_MFX_VC1_DIRECTMODE_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                                    __attribute__((unused)) void * restrict dst,
                                    __attribute__((unused)) const struct GFX20_MFX_VC1_DIRECTMODE_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpcode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   const uint64_t v1_address =
      __gen_address(data, &dw[1], values->DirectMVWriteBufferAddress, 0, 0, 63);
   dw[1] = v1_address;
   dw[2] = v1_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[3], &values->DirectMVWriteBufferAttributes);

   const uint64_t v4_address =
      __gen_address(data, &dw[4], values->DirectMVReadBufferAddress, 0, 0, 63);
   dw[4] = v4_address;
   dw[5] = v4_address >> 32;

   GFX20_MEMORYADDRESSATTRIBUTES_pack(data, &dw[6], &values->DirectMVReadBufferAttributes);
}

#define GFX20_MFX_VC1_PRED_PIPE_STATE_length      6
#define GFX20_MFX_VC1_PRED_PIPE_STATE_length_bias      2
#define GFX20_MFX_VC1_PRED_PIPE_STATE_header    \
   .DWordLength                         =      4,  \
   .SubOpcodeB                          =      1,  \
   .SubOpcodeA                          =      0,  \
   .MediaCommandOpcode                  =      2,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFX_VC1_PRED_PIPE_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             ReferenceFrameBoundaryReplicationMode;
   uint32_t                             Vin_intensitycomp_Single_BWDen;
   uint32_t                             Vin_intensitycomp_Single_FWDen;
   uint32_t                             Vin_intensitycomp_Double_BWDen;
   uint32_t                             Vin_intensitycomp_Double_FWDen;
   uint32_t                             LumScale1singleFWD;
   uint32_t                             LumScale2singleFWD;
   uint32_t                             LumShift1singleFWD;
   uint32_t                             LumShift2singleFWD;
   uint32_t                             LumScale1doubleFWD;
   uint32_t                             LumScale2doubleFWD;
   uint32_t                             LumShift1doubleFWD;
   uint32_t                             LumShift2doubleFWD;
   uint32_t                             LumScale1singleBWD;
   uint32_t                             LumScale2singleBWD;
   uint32_t                             LumShift1singleBWD;
   uint32_t                             LumShift2singleBWD;
   uint32_t                             LumScale1doubleBWD;
   uint32_t                             LumScale2doubleBWD;
   uint32_t                             LumShift1doubleBWD;
   uint32_t                             LumShift2doubleBWD;
};

static inline __attribute__((always_inline)) void
GFX20_MFX_VC1_PRED_PIPE_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                                   __attribute__((unused)) void * restrict dst,
                                   __attribute__((unused)) const struct GFX20_MFX_VC1_PRED_PIPE_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpcode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->ReferenceFrameBoundaryReplicationMode, 4, 7) |
      util_bitpack_uint(values->Vin_intensitycomp_Single_BWDen, 8, 9) |
      util_bitpack_uint(values->Vin_intensitycomp_Single_FWDen, 10, 11) |
      util_bitpack_uint(values->Vin_intensitycomp_Double_BWDen, 12, 13) |
      util_bitpack_uint(values->Vin_intensitycomp_Double_FWDen, 14, 15);

   dw[2] =
      util_bitpack_uint(values->LumScale1singleFWD, 0, 5) |
      util_bitpack_uint(values->LumScale2singleFWD, 8, 13) |
      util_bitpack_uint(values->LumShift1singleFWD, 16, 21) |
      util_bitpack_uint(values->LumShift2singleFWD, 24, 29);

   dw[3] =
      util_bitpack_uint(values->LumScale1doubleFWD, 0, 5) |
      util_bitpack_uint(values->LumScale2doubleFWD, 8, 13) |
      util_bitpack_uint(values->LumShift1doubleFWD, 16, 21) |
      util_bitpack_uint(values->LumShift2doubleFWD, 24, 29);

   dw[4] =
      util_bitpack_uint(values->LumScale1singleBWD, 0, 5) |
      util_bitpack_uint(values->LumScale2singleBWD, 8, 13) |
      util_bitpack_uint(values->LumShift1singleBWD, 16, 21) |
      util_bitpack_uint(values->LumShift2singleBWD, 24, 29);

   dw[5] =
      util_bitpack_uint(values->LumScale1doubleBWD, 0, 5) |
      util_bitpack_uint(values->LumScale2doubleBWD, 8, 13) |
      util_bitpack_uint(values->LumShift1doubleBWD, 16, 21) |
      util_bitpack_uint(values->LumShift2doubleBWD, 24, 29);
}

#define GFX20_MFX_VP8_BSP_BUF_BASE_ADDR_STATE_length      2
#define GFX20_MFX_VP8_BSP_BUF_BASE_ADDR_STATE_length_bias      2
#define GFX20_MFX_VP8_BSP_BUF_BASE_ADDR_STATE_header\
   .DWordLength                         =      0,  \
   .SubOpcodeB                          =      3,  \
   .SubOpcodeA                          =      2,  \
   .MediaCommandOpcode                  =      4,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFX_VP8_BSP_BUF_BASE_ADDR_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   __gen_address_type                   FrameHeaderAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES FrameHeaderAttributes;
   __gen_address_type                   IntermediateBufferAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES IntermediateBufferAttributes;
   uint64_t                             IntermediateBufferPartitionOffset;
   uint32_t                             IntermediateBufferMaxSize;
   __gen_address_type                   FinalFrameAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES FinalFrameAttributes;
   uint32_t                             FinalFrameByteOffset;
   __gen_address_type                   StreamOutAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES StreamOutAttributes;
   __gen_address_type                   CoeffProbsStreamInSurfaceAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES CoeffProbsStreamInSurfaceAttributes;
   __gen_address_type                   TokenStatisticsSurfaceAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES TokenStatisticsSurfaceAttributes;
   __gen_address_type                   MPCRowStoreSurfaceAddress;
   struct GFX20_MEMORYADDRESSATTRIBUTES MPCRowStoreSurfaceAttributes;
};

static inline __attribute__((always_inline)) void
GFX20_MFX_VP8_BSP_BUF_BASE_ADDR_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                                           __attribute__((unused)) void * restrict dst,
                                           __attribute__((unused)) const struct GFX20_MFX_VP8_BSP_BUF_BASE_ADDR_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpcode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   const uint64_t v1_address =
      __gen_address(data, &dw[1], values->FrameHeaderAddress, 0, 0, 63);
   dw[1] = v1_address;
   dw[2] = v1_address >> 32;
}

#define GFX20_MFX_VP8_ENCODER_CFG_length       2
#define GFX20_MFX_VP8_ENCODER_CFG_length_bias      2
#define GFX20_MFX_VP8_ENCODER_CFG_header        \
   .DWordLength                         =      0,  \
   .SubOpcodeB                          =      1,  \
   .SubOpcodeA                          =      2,  \
   .MediaCommandOpcode                  =      4,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFX_VP8_ENCODER_CFG {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   bool                                 PerformanceCounterEnable;
   bool                                 FinalBitstreamOutputDisable;
   bool                                 TokenStatisticsOutputEnable;
   bool                                 BitstreamStatisticsOutputEnable;
   bool                                 UpdateSegmentFeatureDataFlag;
   bool                                 SkipFinalBitstreamwhenOverUnderflow;
   bool                                 RateControlInitialPass;
   bool                                 PerSegmentDeltaQindexLoopFilterDisable;
   bool                                 FinerBRCEnable;
   bool                                 CompressedBitstreamOutputDisable;
   bool                                 VBSPUnitPowerClockGatingDisable;
   bool                                 MaxFrameBitcountRateControlEnable;
   bool                                 MinFrameBitCountRateControlEnable;
   bool                                 MaxInterMBBitCountCheckEnable;
   bool                                 MaxIntraMBBitCountCheckEnable;
   bool                                 IntermediateBitBufferOverrunEnable;
   bool                                 FinalBitstreamBufferOverrunEnable;
   bool                                 QIndexClampHighforUnderflow;
   bool                                 QIndexClampHighforOverflow;
   uint32_t                             MaxInterMBBitCount;
   uint32_t                             MaxIntraMBBitCountLimit;
   uint32_t                             FrameBitrateMax;
   uint32_t                             FrameBitrateMaxUnit;
   uint32_t                             FrameBitrateMaxUnitMode;
#define Compatibilitymode                        0
#define Newmode                                  1
   uint32_t                             FrameBitrateMin;
   uint32_t                             FrameBitrateMinUnit;
   uint32_t                             FrameBitrateMinUnitMode;
#define Compatibilitymode                        0
#define Newmode                                  1
   uint32_t                             FrameDeltaQIndexMax0;
   uint32_t                             FrameDeltaQIndexMax1;
   uint32_t                             FrameDeltaQIndexMax2;
   uint32_t                             FrameDeltaQIndexMax3;
   uint32_t                             FrameDeltaQIndexMin0;
   uint32_t                             FrameDeltaQIndexMin1;
   uint32_t                             FrameDeltaQIndexMin2;
   uint32_t                             FrameDeltaQIndexMin3;
   uint32_t                             PerSegmentFrameDeltaQIndexMax1;
   uint32_t                             PerSegmentFrameDeltaQIndexMin1;
   uint32_t                             PerSegmentFrameDeltaQIndexMax2;
   uint32_t                             PerSegmentFrameDeltaQIndexMin2;
   uint32_t                             PerSegmentFrameDeltaQIndexMax3;
   uint32_t                             PerSegmentFrameDeltaQIndexMin3;
   uint32_t                             FrameDeltaLoopFilterMax0;
   uint32_t                             FrameDeltaLoopFilterMax1;
   uint32_t                             FrameDeltaLoopFilterMax2;
   uint32_t                             FrameDeltaLoopFilterMax3;
   uint32_t                             FrameDeltaLoopFilterMin0;
   uint32_t                             FrameDeltaLoopFilterMin1;
   uint32_t                             FrameDeltaLoopFilterMin2;
   uint32_t                             FrameDeltaLoopFilterMin3;
   uint32_t                             PerSegmentFrameDeltaLoopFilterMax1;
   uint32_t                             PerSegmentFrameDeltaLoopFilterMin1;
   uint32_t                             PerSegmentFrameDeltaLoopFilterMax2;
   uint32_t                             PerSegmentFrameDeltaLoopFilterMin2;
   uint32_t                             PerSegmentFrameDeltaLoopFilterMax3;
   uint32_t                             PerSegmentFrameDeltaLoopFilterMin3;
   uint32_t                             FrameBitrateMaxDelta;
   uint32_t                             FrameBitrateMinDelta;
   uint32_t                             MinimumFrameSize;
   uint32_t                             MinimumFrameSizeUnit;
#define Compatibilitymode                        0
#define Newmode                                  1
   uint32_t                             BitstreamFormatVersion;
   uint32_t                             ShowFrame;
   uint32_t                             Horizontal_Size_Code;
   uint32_t                             Vertical_Size_Code;
   uint32_t                             FrameHeaderBitCount;
   uint32_t                             FrameHeaderBinBufferQIndexUpdatePointer;
   uint32_t                             FrameHeaderBinBufferLoopFilterUpdatePointer;
   uint32_t                             FrameHeaderBinBufferTokenUpdatePointer;
   uint32_t                             FrameHeaderBinBufferMVUpdatePointer;
   uint32_t                             CV0;
   uint32_t                             CV1;
   uint32_t                             CV2;
   uint32_t                             CV3;
   uint32_t                             CV4;
   uint32_t                             CV5;
   uint32_t                             CV6;
   uint32_t                             CV7;
};

static inline __attribute__((always_inline)) void
GFX20_MFX_VP8_ENCODER_CFG_pack(__attribute__((unused)) __gen_user_data *data,
                               __attribute__((unused)) void * restrict dst,
                               __attribute__((unused)) const struct GFX20_MFX_VP8_ENCODER_CFG * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpcode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->PerformanceCounterEnable, 0, 0) |
      util_bitpack_uint(values->FinalBitstreamOutputDisable, 1, 1) |
      util_bitpack_uint(values->TokenStatisticsOutputEnable, 2, 2) |
      util_bitpack_uint(values->BitstreamStatisticsOutputEnable, 3, 3) |
      util_bitpack_uint(values->UpdateSegmentFeatureDataFlag, 4, 4) |
      util_bitpack_uint(values->SkipFinalBitstreamwhenOverUnderflow, 5, 5) |
      util_bitpack_uint(values->RateControlInitialPass, 6, 6) |
      util_bitpack_uint(values->PerSegmentDeltaQindexLoopFilterDisable, 7, 7) |
      util_bitpack_uint(values->FinerBRCEnable, 8, 8) |
      util_bitpack_uint(values->CompressedBitstreamOutputDisable, 9, 9) |
      util_bitpack_uint(values->VBSPUnitPowerClockGatingDisable, 10, 10);
}

#define GFX20_MFX_VP8_PAK_OBJECT_length        7
#define GFX20_MFX_VP8_PAK_OBJECT_length_bias      2
#define GFX20_MFX_VP8_PAK_OBJECT_header         \
   .DWordLength                         =      5,  \
   .SubOpcodeB                          =      9,  \
   .SubOpcodeA                          =      2,  \
   .MediaCommandOpcode                  =      4,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFX_VP8_PAK_OBJECT {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             IndirectPAKMVDataLength;
   bool                                 EnableInlineMVdata;
   uint64_t                             IndirectPAKMVDataStartAddressOffset;
   uint64_t                             InlineData;
};

static inline __attribute__((always_inline)) void
GFX20_MFX_VP8_PAK_OBJECT_pack(__attribute__((unused)) __gen_user_data *data,
                              __attribute__((unused)) void * restrict dst,
                              __attribute__((unused)) const struct GFX20_MFX_VP8_PAK_OBJECT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpcode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->IndirectPAKMVDataLength, 0, 9) |
      util_bitpack_uint(values->EnableInlineMVdata, 29, 29);

   dw[2] =
      __gen_offset(values->IndirectPAKMVDataStartAddressOffset, 0, 28);

   const uint64_t v3 =
      util_bitpack_uint(values->InlineData, 0, 127);
   dw[3] = v3;
   dw[4] = v3 >> 32;
}

#define GFX20_MFX_VP8_PIC_STATE_length         2
#define GFX20_MFX_VP8_PIC_STATE_length_bias      2
#define GFX20_MFX_VP8_PIC_STATE_header          \
   .DWordLength                         =      0,  \
   .SubOpcodeB                          =      0,  \
   .SubOpcodeA                          =      0,  \
   .MediaCommandOpCode                  =      4,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_MFX_VP8_PIC_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpCode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             FrameWidth;
   uint32_t                             FrameHeight;
   uint32_t                             MCFilterSelect;
   uint32_t                             ChromaFullPixelMCFilterMode;
   uint32_t                             DBLKFilterType;
   bool                                 KeyFrame;
   bool                                 SegmentationIDStreamOutEnable;
   bool                                 SegmentationIDStreamInEnable;
   bool                                 SegmentEnable;
   bool                                 UpdateMBSegmentMap;
   bool                                 MBNoCoeffSkip;
   bool                                 ModeReferenceLoopFilterDeltaEnable;
   bool                                 GoldenRefPictureMVSignBias;
   bool                                 AlternateRefPicMVSignBias;
   uint32_t                             DeblockSharpnessLevel;
   uint32_t                             Log2NumofPartition;
#define _1Tokenpartition                         0
#define _2Tokenpartition                         1
#define _4Tokenpartition                         2
#define _8Tokenpartition                         3
   uint32_t                             DBLKFilterLevelforSegment0;
   uint32_t                             DBLKFilterLevelforSegment1;
   uint32_t                             DBLKFilterLevelforSegment2;
   uint32_t                             DBLKFilterLevelforSegment3;
   uint32_t                             Segment0QIndex;
   uint32_t                             Segment1QIndex;
   uint32_t                             Segment2QIndex;
   uint32_t                             Segment3QIndex;
   uint32_t                             Y2DCQIndexDelta;
   uint32_t                             Y2ACQIndexDeltaSign;
   uint32_t                             Y2ACQIndexDelta;
   uint32_t                             Y2ACQIndexSign;
   uint32_t                             UVDCQIndexDelta;
   uint32_t                             UVDCQIndexDeltaSign;
   uint32_t                             UVACQIndexDelta;
   uint32_t                             UVACQIndexDeltaSign;
   uint32_t                             Y1DCQIndexDelta;
   uint32_t                             Y1DCQIndexDeltaSign;
   uint32_t                             ClampQIndexLow;
   uint32_t                             ClampQIndexHigh;
   uint32_t                             QuantizerValue1UVDC;
   uint32_t                             QuantizerValue1UVAC;
   uint32_t                             QuantizerValue1Y2DC;
   uint32_t                             QuantizerValue1Y2AC;
   uint32_t                             QuantizerValue2Y1DC;
   uint32_t                             QuantizerValue2Y1AC;
   uint32_t                             QuantizerValue2UVDC;
   uint32_t                             QuantizerValue2UVAC;
   uint32_t                             QuantizerValue2Y2DC;
   uint32_t                             QuantizerValue2Y2AC;
   uint32_t                             QuantizerValue3Y1DC;
   uint32_t                             QuantizerValue3Y1AC;
   uint32_t                             QuantizerValue3UVDC;
   uint32_t                             QuantizerValue3UVAC;
   uint32_t                             QuantizerValue3Y2DC;
   uint32_t                             QuantizerValue3Y2AC;
   uint64_t                             CoeffProbabilityStreamInAddress;
   uint32_t                             CoeffProbabilityStreamInMOCSEncoderOnly;
   uint32_t                             CoeffProbabilityStreamInArbitrationPriorityControl;
#define Highestpriority                          0
#define Secondhighestpriority                    1
#define Thirdhighestpriority                     2
#define Lowestpriority                           3
   bool                                 CoeffProbabilityStreamInMemoryCompressionEnable;
   uint32_t                             CoeffProbabilityStreamInMemoryCompressionMode;
   uint32_t                             CoeffProbabilityStreamInTiledResourceMode;
#define TRMODE_NONE                              0
#define TRMODE_TILEYF                            1
#define TRMODE_TILEYS                            2
   uint32_t                             MBSegmentIDTreeProbs0;
   uint32_t                             MBSegmentIDTreeProbs1;
   uint32_t                             MBSegmentIDTreeProbs2;
   uint32_t                             InterPredFromGRefRefProb;
   uint32_t                             InterPredFromLastRefProb;
   uint32_t                             IntraMBProb;
   uint32_t                             MBNoCoeffSkipFalseProb;
   uint32_t                             YModeProb0;
   uint32_t                             YModeProb1;
   uint32_t                             YModeProb2;
   uint32_t                             YModeProb3;
   uint32_t                             UVModeProb0;
   uint32_t                             UVModeProb1;
   uint32_t                             UVModeProb2;
   uint32_t                             MVUpdateProbs00;
   uint32_t                             MVUpdateProbs01;
   uint32_t                             MVUpdateProbs02;
   uint32_t                             MVUpdateProbs03;
   uint32_t                             MVUpdateProbs04;
   uint32_t                             MVUpdateProbs05;
   uint32_t                             MVUpdateProbs06;
   uint32_t                             MVUpdateProbs07;
   uint32_t                             MVUpdateProbs08;
   uint32_t                             MVUpdateProbs09;
   uint32_t                             MVUpdateProbs010;
   uint32_t                             MVUpdateProbs011;
   uint32_t                             MVUpdateProbs012;
   uint32_t                             MVUpdateProbs013;
   uint32_t                             MVUpdateProbs014;
   uint32_t                             MVUpdateProbs015;
   uint32_t                             MVUpdateProbs016;
   uint32_t                             MVUpdateProbs017;
   uint32_t                             MVUpdateProbs018;
   uint32_t                             MVUpdateProbs10;
   uint32_t                             MVUpdateProbs11;
   uint32_t                             MVUpdateProbs12;
   uint32_t                             MVUpdateProbs13;
   uint32_t                             MVUpdateProbs14;
   uint32_t                             MVUpdateProbs15;
   uint32_t                             MVUpdateProbs16;
   uint32_t                             MVUpdateProbs17;
   uint32_t                             MVUpdateProbs18;
   uint32_t                             MVUpdateProbs19;
   uint32_t                             MVUpdateProbs110;
   uint32_t                             MVUpdateProbs111;
   uint32_t                             MVUpdateProbs112;
   uint32_t                             MVUpdateProbs113;
   uint32_t                             MVUpdateProbs114;
   uint32_t                             MVUpdateProbs115;
   uint32_t                             MVUpdateProbs116;
   uint32_t                             MVUpdateProbs117;
   uint32_t                             MVUpdateProbs118;
   int32_t                              RefLFDelta0;
   int32_t                              RefLFDelta1;
   int32_t                              RefLFDelta2;
   int32_t                              RefLFDelta3;
   int32_t                              ModeLFDelta0;
   int32_t                              ModeLFDelta1;
   int32_t                              ModeLFDelta2;
   int32_t                              ModeLFDelta3;
   uint64_t                             SegmentationIDStreamAddress;
   uint32_t                             CoeffProbabilityStreamInMOCS;
   uint32_t                             SegmentationIDStreamArbitrationPriorityControl;
#define Highestpriority                          0
#define Secondhighestpriority                    1
#define Thirdhighestpriority                     2
#define Lowestpriority                           3
   bool                                 SegmentationIDStreamMemoryCompressionEnable;
   uint32_t                             SegmentationIDStreamMemoryCompressionMode;
   uint32_t                             SegmentationIDStreamTiledResourceMode;
#define TRMODE_NONE                              0
#define TRMODE_TILEYF                            1
#define TRMODE_TILEYS                            2
};

static inline __attribute__((always_inline)) void
GFX20_MFX_VP8_PIC_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                             __attribute__((unused)) void * restrict dst,
                             __attribute__((unused)) const struct GFX20_MFX_VP8_PIC_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 23) |
      util_bitpack_uint(values->MediaCommandOpCode, 24, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->FrameWidth, 0, 7) |
      util_bitpack_uint(values->FrameHeight, 16, 23);
}

#define GFX20_MFX_WAIT_length                  1
#define GFX20_MFX_WAIT_length_bias             1
#define GFX20_MFX_WAIT_header                   \
   .DWordLength                         =      0,  \
   .SubOpcode                           =      0,  \
   .CommandSubtype                      =      1,  \
   .CommandType                         =      3

struct GFX20_MFX_WAIT {
   uint32_t                             DWordLength;
   uint32_t                             MFXSyncControlFlag;
   uint32_t                             SubOpcode;
   uint32_t                             CommandSubtype;
   uint32_t                             CommandType;
};

static inline __attribute__((always_inline)) void
GFX20_MFX_WAIT_pack(__attribute__((unused)) __gen_user_data *data,
                    __attribute__((unused)) void * restrict dst,
                    __attribute__((unused)) const struct GFX20_MFX_WAIT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 5) |
      util_bitpack_uint(values->MFXSyncControlFlag, 8, 8) |
      util_bitpack_uint(values->SubOpcode, 16, 26) |
      util_bitpack_uint(values->CommandSubtype, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);
}

#define GFX20_MI_ARB_CHECK_length              1
#define GFX20_MI_ARB_CHECK_length_bias         1
#define GFX20_MI_ARB_CHECK_header               \
   .MICommandOpcode                     =      5,  \
   .CommandType                         =      0

struct GFX20_MI_ARB_CHECK {
   bool                                 PreParserDisable;
   bool                                 PreParserDisableMask;
   uint32_t                             MICommandOpcode;
   uint32_t                             CommandType;
};

static inline __attribute__((always_inline)) void
GFX20_MI_ARB_CHECK_pack(__attribute__((unused)) __gen_user_data *data,
                        __attribute__((unused)) void * restrict dst,
                        __attribute__((unused)) const struct GFX20_MI_ARB_CHECK * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->PreParserDisable, 0, 0) |
      util_bitpack_uint(values->PreParserDisableMask, 8, 8) |
      util_bitpack_uint(values->MICommandOpcode, 23, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);
}

#define GFX20_MI_ARB_ON_OFF_length             1
#define GFX20_MI_ARB_ON_OFF_length_bias        1
#define GFX20_MI_ARB_ON_OFF_header              \
   .ArbitrationEnable                   =      1,  \
   .MICommandOpcode                     =      8,  \
   .CommandType                         =      0

struct GFX20_MI_ARB_ON_OFF {
   bool                                 ArbitrationEnable;
   bool                                 AllowLiteRestore;
   uint32_t                             MICommandOpcode;
   uint32_t                             CommandType;
};

static inline __attribute__((always_inline)) void
GFX20_MI_ARB_ON_OFF_pack(__attribute__((unused)) __gen_user_data *data,
                         __attribute__((unused)) void * restrict dst,
                         __attribute__((unused)) const struct GFX20_MI_ARB_ON_OFF * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->ArbitrationEnable, 0, 0) |
      util_bitpack_uint(values->AllowLiteRestore, 1, 1) |
      util_bitpack_uint(values->MICommandOpcode, 23, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);
}

#define GFX20_MI_ATOMIC_length                 3
#define GFX20_MI_ATOMIC_length_bias            2
#define GFX20_MI_ATOMIC_header                  \
   .DWordLength                         =      1,  \
   .MICommandOpcode                     =     47,  \
   .CommandType                         =      0

struct GFX20_MI_ATOMIC {
   uint32_t                             DWordLength;
   enum GFX20_Atomic_OPCODE             ATOMICOPCODE;
   bool                                 ReturnDataControl;
   bool                                 CSSTALL;
   bool                                 InlineData;
   uint32_t                             DataSize;
#define MI_ATOMIC_DWORD                          0
#define MI_ATOMIC_QWORD                          1
#define MI_ATOMIC_OCTWORD                        2
#define MI_ATOMIC_RESERVED                       3
   bool                                 PostSyncOperation;
   uint32_t                             MemoryType;
#define PerProcessGraphicsAddress                0
#define GlobalGraphicsAddress                    1
   uint32_t                             MICommandOpcode;
   uint32_t                             CommandType;
   __gen_address_type                   MemoryAddress;
   uint32_t                             Operand1DataDword0;
   uint32_t                             Operand2DataDword0;
   uint32_t                             Operand1DataDword1;
   uint32_t                             Operand2DataDword1;
   uint32_t                             Operand1DataDword2;
   uint32_t                             Operand2DataDword2;
   uint32_t                             Operand1DataDword3;
   uint32_t                             Operand2DataDword3;
};

static inline __attribute__((always_inline)) void
GFX20_MI_ATOMIC_pack(__attribute__((unused)) __gen_user_data *data,
                     __attribute__((unused)) void * restrict dst,
                     __attribute__((unused)) const struct GFX20_MI_ATOMIC * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 7) |
      util_bitpack_uint(values->ATOMICOPCODE, 8, 15) |
      util_bitpack_uint(values->ReturnDataControl, 16, 16) |
      util_bitpack_uint(values->CSSTALL, 17, 17) |
      util_bitpack_uint(values->InlineData, 18, 18) |
      util_bitpack_uint(values->DataSize, 19, 20) |
      util_bitpack_uint(values->PostSyncOperation, 21, 21) |
      util_bitpack_uint(values->MemoryType, 22, 22) |
      util_bitpack_uint(values->MICommandOpcode, 23, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   const uint64_t v1_address =
      __gen_address(data, &dw[1], values->MemoryAddress, 0, 2, 47);
   dw[1] = v1_address;
   dw[2] = v1_address >> 32;
}

#define GFX20_MI_BATCH_BUFFER_END_length       1
#define GFX20_MI_BATCH_BUFFER_END_length_bias      1
#define GFX20_MI_BATCH_BUFFER_END_header        \
   .MICommandOpcode                     =     10,  \
   .CommandType                         =      0

struct GFX20_MI_BATCH_BUFFER_END {
   bool                                 EndContext;
   uint32_t                             MICommandOpcode;
   uint32_t                             CommandType;
};

static inline __attribute__((always_inline)) void
GFX20_MI_BATCH_BUFFER_END_pack(__attribute__((unused)) __gen_user_data *data,
                               __attribute__((unused)) void * restrict dst,
                               __attribute__((unused)) const struct GFX20_MI_BATCH_BUFFER_END * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->EndContext, 0, 0) |
      util_bitpack_uint(values->MICommandOpcode, 23, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);
}

#define GFX20_MI_BATCH_BUFFER_START_length      3
#define GFX20_MI_BATCH_BUFFER_START_length_bias      2
#define GFX20_MI_BATCH_BUFFER_START_header      \
   .DWordLength                         =      1,  \
   .MICommandOpcode                     =     49,  \
   .CommandType                         =      0

struct GFX20_MI_BATCH_BUFFER_START {
   uint32_t                             DWordLength;
   uint32_t                             AddressSpaceIndicator;
#define ASI_GGTT                                 0
#define ASI_PPGTT                                1
   bool                                 ResourceStreamerEnable;
   bool                                 PredicationEnable;
   uint32_t                             SecondLevelBatchBuffer;
#define Firstlevelbatch                          0
#define Secondlevelbatch                         1
   uint32_t                             MICommandOpcode;
   uint32_t                             CommandType;
   __gen_address_type                   BatchBufferStartAddress;
};

static inline __attribute__((always_inline)) void
GFX20_MI_BATCH_BUFFER_START_pack(__attribute__((unused)) __gen_user_data *data,
                                 __attribute__((unused)) void * restrict dst,
                                 __attribute__((unused)) const struct GFX20_MI_BATCH_BUFFER_START * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 7) |
      util_bitpack_uint(values->AddressSpaceIndicator, 8, 8) |
      util_bitpack_uint(values->ResourceStreamerEnable, 10, 10) |
      util_bitpack_uint(values->PredicationEnable, 15, 15) |
      util_bitpack_uint(values->SecondLevelBatchBuffer, 22, 22) |
      util_bitpack_uint(values->MICommandOpcode, 23, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   const uint64_t v1_address =
      __gen_address(data, &dw[1], values->BatchBufferStartAddress, 0, 2, 63);
   dw[1] = v1_address;
   dw[2] = v1_address >> 32;
}

#define GFX20_MI_CONDITIONAL_BATCH_BUFFER_END_length      4
#define GFX20_MI_CONDITIONAL_BATCH_BUFFER_END_length_bias      2
#define GFX20_MI_CONDITIONAL_BATCH_BUFFER_END_header\
   .DWordLength                         =      2,  \
   .CompareSemaphore                    =      0,  \
   .MICommandOpcode                     =     54,  \
   .CommandType                         =      0

struct GFX20_MI_CONDITIONAL_BATCH_BUFFER_END {
   uint32_t                             DWordLength;
   uint32_t                             CompareMaskMode;
#define CompareMaskModeDisabled                  0
#define CompareMaskModeEnabled                   1
   uint32_t                             CompareSemaphore;
   bool                                 UseGlobalGTT;
   uint32_t                             MICommandOpcode;
   uint32_t                             CommandType;
   uint32_t                             CompareDataDword;
   __gen_address_type                   CompareAddress;
};

static inline __attribute__((always_inline)) void
GFX20_MI_CONDITIONAL_BATCH_BUFFER_END_pack(__attribute__((unused)) __gen_user_data *data,
                                           __attribute__((unused)) void * restrict dst,
                                           __attribute__((unused)) const struct GFX20_MI_CONDITIONAL_BATCH_BUFFER_END * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 7) |
      util_bitpack_uint(values->CompareMaskMode, 19, 19) |
      util_bitpack_uint(values->CompareSemaphore, 21, 21) |
      util_bitpack_uint(values->UseGlobalGTT, 22, 22) |
      util_bitpack_uint(values->MICommandOpcode, 23, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->CompareDataDword, 0, 31);

   const uint64_t v2_address =
      __gen_address(data, &dw[2], values->CompareAddress, 0, 3, 63);
   dw[2] = v2_address;
   dw[3] = v2_address >> 32;
}

#define GFX20_MI_COPY_MEM_MEM_length           5
#define GFX20_MI_COPY_MEM_MEM_length_bias      2
#define GFX20_MI_COPY_MEM_MEM_header            \
   .DWordLength                         =      3,  \
   .MICommandOpcode                     =     46,  \
   .CommandType                         =      0

struct GFX20_MI_COPY_MEM_MEM {
   uint32_t                             DWordLength;
   bool                                 UseGlobalGTTDestination;
   bool                                 UseGlobalGTTSource;
   uint32_t                             MICommandOpcode;
   uint32_t                             CommandType;
   __gen_address_type                   DestinationMemoryAddress;
   __gen_address_type                   SourceMemoryAddress;
};

static inline __attribute__((always_inline)) void
GFX20_MI_COPY_MEM_MEM_pack(__attribute__((unused)) __gen_user_data *data,
                           __attribute__((unused)) void * restrict dst,
                           __attribute__((unused)) const struct GFX20_MI_COPY_MEM_MEM * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 7) |
      util_bitpack_uint(values->UseGlobalGTTDestination, 21, 21) |
      util_bitpack_uint(values->UseGlobalGTTSource, 22, 22) |
      util_bitpack_uint(values->MICommandOpcode, 23, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   const uint64_t v1_address =
      __gen_address(data, &dw[1], values->DestinationMemoryAddress, 0, 2, 63);
   dw[1] = v1_address;
   dw[2] = v1_address >> 32;

   const uint64_t v3_address =
      __gen_address(data, &dw[3], values->SourceMemoryAddress, 0, 2, 63);
   dw[3] = v3_address;
   dw[4] = v3_address >> 32;
}

#define GFX20_MI_FLUSH_DW_length               5
#define GFX20_MI_FLUSH_DW_length_bias          2
#define GFX20_MI_FLUSH_DW_header                \
   .DWordLength                         =      3,  \
   .MICommandOpcode                     =     38,  \
   .CommandType                         =      0

struct GFX20_MI_FLUSH_DW {
   uint32_t                             DWordLength;
   bool                                 VideoPipelineCacheInvalidate;
   bool                                 NotifyEnable;
   bool                                 FlushLLC;
   uint32_t                             PostSyncOperation;
#define NoWrite                                  0
#define WriteImmediateData                       1
#define WriteTimestamp                           3
   bool                                 FlushCCS;
   bool                                 TLBInvalidate;
   uint32_t                             StoreDataIndex;
   uint32_t                             MICommandOpcode;
   uint32_t                             CommandType;
   uint32_t                             DestinationAddressType;
#define DAT_PPGTT                                0
#define DAT_GGTT                                 1
   __gen_address_type                   Address;
   uint64_t                             ImmediateData;
};

static inline __attribute__((always_inline)) void
GFX20_MI_FLUSH_DW_pack(__attribute__((unused)) __gen_user_data *data,
                       __attribute__((unused)) void * restrict dst,
                       __attribute__((unused)) const struct GFX20_MI_FLUSH_DW * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 5) |
      util_bitpack_uint(values->VideoPipelineCacheInvalidate, 7, 7) |
      util_bitpack_uint(values->NotifyEnable, 8, 8) |
      util_bitpack_uint(values->FlushLLC, 9, 9) |
      util_bitpack_uint(values->PostSyncOperation, 14, 15) |
      util_bitpack_uint(values->FlushCCS, 16, 16) |
      util_bitpack_uint(values->TLBInvalidate, 18, 18) |
      util_bitpack_uint(values->StoreDataIndex, 21, 21) |
      util_bitpack_uint(values->MICommandOpcode, 23, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   const uint64_t v1 =
      util_bitpack_uint(values->DestinationAddressType, 2, 2);
   const uint64_t v1_address =
      __gen_address(data, &dw[1], values->Address, v1, 3, 47);
   dw[1] = v1_address;
   dw[2] = (v1_address >> 32) | (v1 >> 32);

   const uint64_t v3 =
      util_bitpack_uint(values->ImmediateData, 0, 63);
   dw[3] = v3;
   dw[4] = v3 >> 32;
}

#define GFX20_MI_FORCE_WAKEUP_length           2
#define GFX20_MI_FORCE_WAKEUP_length_bias      2
#define GFX20_MI_FORCE_WAKEUP_header            \
   .DWordLength                         =      0,  \
   .MICommandOpcode                     =     29,  \
   .CommandType                         =      0

struct GFX20_MI_FORCE_WAKEUP {
   uint32_t                             DWordLength;
   uint32_t                             MICommandOpcode;
   uint32_t                             CommandType;
   uint32_t                             ForceMediaSlice0Awake;
   uint32_t                             ForceRenderAwake;
   uint32_t                             ForceMediaSlice1Awake;
   uint32_t                             ForceMediaSlice2Awake;
   uint32_t                             ForceMediaSlice3Awake;
   bool                                 HEVCPowerWellControl;
   bool                                 MFXPowerWellControl;
   uint32_t                             MaskBits;
};

static inline __attribute__((always_inline)) void
GFX20_MI_FORCE_WAKEUP_pack(__attribute__((unused)) __gen_user_data *data,
                           __attribute__((unused)) void * restrict dst,
                           __attribute__((unused)) const struct GFX20_MI_FORCE_WAKEUP * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 7) |
      util_bitpack_uint(values->MICommandOpcode, 23, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->ForceMediaSlice0Awake, 0, 0) |
      util_bitpack_uint(values->ForceRenderAwake, 1, 1) |
      util_bitpack_uint(values->ForceMediaSlice1Awake, 2, 2) |
      util_bitpack_uint(values->ForceMediaSlice2Awake, 3, 3) |
      util_bitpack_uint(values->ForceMediaSlice3Awake, 4, 4) |
      util_bitpack_uint(values->HEVCPowerWellControl, 8, 8) |
      util_bitpack_uint(values->MFXPowerWellControl, 9, 9) |
      util_bitpack_uint(values->MaskBits, 16, 31);
}

#define GFX20_MI_LOAD_REGISTER_IMM_length      3
#define GFX20_MI_LOAD_REGISTER_IMM_length_bias      2
#define GFX20_MI_LOAD_REGISTER_IMM_header       \
   .DWordLength                         =      1,  \
   .MICommandOpcode                     =     34,  \
   .CommandType                         =      0

struct GFX20_MI_LOAD_REGISTER_IMM {
   uint32_t                             DWordLength;
   uint32_t                             ByteWriteDisables;
   uint32_t                             AddCSMMIOStartOffset;
   uint32_t                             MICommandOpcode;
   uint32_t                             CommandType;
   uint64_t                             RegisterOffset;
   uint32_t                             DataDWord;
   /* variable length fields follow */
};

static inline __attribute__((always_inline)) void
GFX20_MI_LOAD_REGISTER_IMM_pack(__attribute__((unused)) __gen_user_data *data,
                                __attribute__((unused)) void * restrict dst,
                                __attribute__((unused)) const struct GFX20_MI_LOAD_REGISTER_IMM * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 7) |
      util_bitpack_uint(values->ByteWriteDisables, 8, 11) |
      util_bitpack_uint(values->AddCSMMIOStartOffset, 19, 19) |
      util_bitpack_uint(values->MICommandOpcode, 23, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      __gen_offset(values->RegisterOffset, 2, 22);

   dw[2] =
      util_bitpack_uint(values->DataDWord, 0, 31);
}

#define GFX20_MI_LOAD_REGISTER_MEM_length      4
#define GFX20_MI_LOAD_REGISTER_MEM_length_bias      2
#define GFX20_MI_LOAD_REGISTER_MEM_header       \
   .DWordLength                         =      2,  \
   .MICommandOpcode                     =     41,  \
   .CommandType                         =      0

struct GFX20_MI_LOAD_REGISTER_MEM {
   uint32_t                             DWordLength;
   uint32_t                             AddCSMMIOStartOffset;
   uint32_t                             AddLoopVariable;
   bool                                 AsyncModeEnable;
   bool                                 UseGlobalGTT;
   uint32_t                             MICommandOpcode;
   uint32_t                             CommandType;
   uint64_t                             RegisterAddress;
   __gen_address_type                   MemoryAddress;
};

static inline __attribute__((always_inline)) void
GFX20_MI_LOAD_REGISTER_MEM_pack(__attribute__((unused)) __gen_user_data *data,
                                __attribute__((unused)) void * restrict dst,
                                __attribute__((unused)) const struct GFX20_MI_LOAD_REGISTER_MEM * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 7) |
      util_bitpack_uint(values->AddCSMMIOStartOffset, 19, 19) |
      util_bitpack_uint(values->AddLoopVariable, 20, 20) |
      util_bitpack_uint(values->AsyncModeEnable, 21, 21) |
      util_bitpack_uint(values->UseGlobalGTT, 22, 22) |
      util_bitpack_uint(values->MICommandOpcode, 23, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      __gen_offset(values->RegisterAddress, 2, 22);

   const uint64_t v2_address =
      __gen_address(data, &dw[2], values->MemoryAddress, 0, 2, 63);
   dw[2] = v2_address;
   dw[3] = v2_address >> 32;
}

#define GFX20_MI_LOAD_REGISTER_REG_length      3
#define GFX20_MI_LOAD_REGISTER_REG_length_bias      2
#define GFX20_MI_LOAD_REGISTER_REG_header       \
   .DWordLength                         =      1,  \
   .MICommandOpcode                     =     42,  \
   .CommandType                         =      0

struct GFX20_MI_LOAD_REGISTER_REG {
   uint32_t                             DWordLength;
   uint32_t                             AddCSMMIOStartOffsetSource;
   uint32_t                             AddCSMMIOStartOffsetDestination;
   uint32_t                             MICommandOpcode;
   uint32_t                             CommandType;
   uint64_t                             SourceRegisterAddress;
   uint64_t                             DestinationRegisterAddress;
};

static inline __attribute__((always_inline)) void
GFX20_MI_LOAD_REGISTER_REG_pack(__attribute__((unused)) __gen_user_data *data,
                                __attribute__((unused)) void * restrict dst,
                                __attribute__((unused)) const struct GFX20_MI_LOAD_REGISTER_REG * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 7) |
      util_bitpack_uint(values->AddCSMMIOStartOffsetSource, 18, 18) |
      util_bitpack_uint(values->AddCSMMIOStartOffsetDestination, 19, 19) |
      util_bitpack_uint(values->MICommandOpcode, 23, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      __gen_offset(values->SourceRegisterAddress, 2, 22);

   dw[2] =
      __gen_offset(values->DestinationRegisterAddress, 2, 22);
}

#define GFX20_MI_MATH_length_bias              2
#define GFX20_MI_MATH_header                    \
   .DWordLength                         =      0,  \
   .MICommandOpcode                     =     26,  \
   .CommandType                         =      0

struct GFX20_MI_MATH {
   uint32_t                             DWordLength;
   uint32_t                             MOCS;
   bool                                 PredicationEnable;
   uint32_t                             MICommandOpcode;
   uint32_t                             CommandType;
   /* variable length fields follow */
};

static inline __attribute__((always_inline)) void
GFX20_MI_MATH_pack(__attribute__((unused)) __gen_user_data *data,
                   __attribute__((unused)) void * restrict dst,
                   __attribute__((unused)) const struct GFX20_MI_MATH * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 7) |
      util_bitpack_uint_nonzero(values->MOCS, 8, 14) |
      util_bitpack_uint(values->PredicationEnable, 15, 15) |
      util_bitpack_uint(values->MICommandOpcode, 23, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);
}

#define GFX20_MI_MEM_FENCE_length              1
#define GFX20_MI_MEM_FENCE_length_bias         1
#define GFX20_MI_MEM_FENCE_header               \
   .MICommandSubOpcode                  =      0,  \
   .MICommandOpcode                     =      9,  \
   .CommandType                         =      0

struct GFX20_MI_MEM_FENCE {
   uint32_t                             FenceType;
#define FENCE_TYPE_RELEASE                       0
#define FENCE_TYPE_ACQUIRE                       1
#define FENCE_TYPE_MI_WRITE                      3
   uint32_t                             MICommandSubOpcode;
   uint32_t                             MICommandOpcode;
   uint32_t                             CommandType;
};

static inline __attribute__((always_inline)) void
GFX20_MI_MEM_FENCE_pack(__attribute__((unused)) __gen_user_data *data,
                        __attribute__((unused)) void * restrict dst,
                        __attribute__((unused)) const struct GFX20_MI_MEM_FENCE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->FenceType, 0, 1) |
      util_bitpack_uint(values->MICommandSubOpcode, 17, 22) |
      util_bitpack_uint(values->MICommandOpcode, 23, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);
}

#define GFX20_MI_NOOP_length                   1
#define GFX20_MI_NOOP_length_bias              1
#define GFX20_MI_NOOP_header                    \
   .MICommandOpcode                     =      0,  \
   .CommandType                         =      0

struct GFX20_MI_NOOP {
   uint32_t                             IdentificationNumber;
   bool                                 IdentificationNumberRegisterWriteEnable;
   uint32_t                             MICommandOpcode;
   uint32_t                             CommandType;
};

static inline __attribute__((always_inline)) void
GFX20_MI_NOOP_pack(__attribute__((unused)) __gen_user_data *data,
                   __attribute__((unused)) void * restrict dst,
                   __attribute__((unused)) const struct GFX20_MI_NOOP * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->IdentificationNumber, 0, 21) |
      util_bitpack_uint(values->IdentificationNumberRegisterWriteEnable, 22, 22) |
      util_bitpack_uint(values->MICommandOpcode, 23, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);
}

#define GFX20_MI_PREDICATE_length              1
#define GFX20_MI_PREDICATE_length_bias         1
#define GFX20_MI_PREDICATE_header               \
   .MICommandOpcode                     =     12,  \
   .CommandType                         =      0

struct GFX20_MI_PREDICATE {
   uint32_t                             CompareOperation;
#define COMPARE_TRUE                             0
#define COMPARE_FALSE                            1
#define COMPARE_SRCS_EQUAL                       2
#define COMPARE_DELTAS_EQUAL                     3
   uint32_t                             CombineOperation;
#define COMBINE_SET                              0
#define COMBINE_AND                              1
#define COMBINE_OR                               2
#define COMBINE_XOR                              3
   uint32_t                             LoadOperation;
#define LOAD_KEEP                                0
#define LOAD_LOAD                                2
#define LOAD_LOADINV                             3
   uint32_t                             MICommandOpcode;
   uint32_t                             CommandType;
};

static inline __attribute__((always_inline)) void
GFX20_MI_PREDICATE_pack(__attribute__((unused)) __gen_user_data *data,
                        __attribute__((unused)) void * restrict dst,
                        __attribute__((unused)) const struct GFX20_MI_PREDICATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->CompareOperation, 0, 1) |
      util_bitpack_uint(values->CombineOperation, 3, 4) |
      util_bitpack_uint(values->LoadOperation, 6, 7) |
      util_bitpack_uint(values->MICommandOpcode, 23, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);
}

#define GFX20_MI_REPORT_HEAD_length            1
#define GFX20_MI_REPORT_HEAD_length_bias       1
#define GFX20_MI_REPORT_HEAD_header             \
   .MICommandOpcode                     =      7,  \
   .CommandType                         =      0

struct GFX20_MI_REPORT_HEAD {
   uint32_t                             MICommandOpcode;
   uint32_t                             CommandType;
};

static inline __attribute__((always_inline)) void
GFX20_MI_REPORT_HEAD_pack(__attribute__((unused)) __gen_user_data *data,
                          __attribute__((unused)) void * restrict dst,
                          __attribute__((unused)) const struct GFX20_MI_REPORT_HEAD * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->MICommandOpcode, 23, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);
}

#define GFX20_MI_SEMAPHORE_SIGNAL_length       2
#define GFX20_MI_SEMAPHORE_SIGNAL_length_bias      2
#define GFX20_MI_SEMAPHORE_SIGNAL_header        \
   .DWordLength                         =      0,  \
   .MICommandOpcode                     =     27,  \
   .CommandType                         =      0

struct GFX20_MI_SEMAPHORE_SIGNAL {
   uint32_t                             DWordLength;
   uint32_t                             TargetEngineSelect;
#define RCS                                      0
#define VCS0                                     1
#define BCS                                      2
#define VECS                                     3
#define VCS1                                     4
#define VCS2                                     6
#define VCS3                                     7
#define VCS4                                     8
#define VCS5                                     9
#define VCS6                                     10
#define VCS7                                     11
#define VECS1                                    12
#define VECS2                                    13
#define VECS3                                    14
   bool                                 PostSyncOperation;
   uint32_t                             MICommandOpcode;
   uint32_t                             CommandType;
   uint32_t                             TargetContextID;
};

static inline __attribute__((always_inline)) void
GFX20_MI_SEMAPHORE_SIGNAL_pack(__attribute__((unused)) __gen_user_data *data,
                               __attribute__((unused)) void * restrict dst,
                               __attribute__((unused)) const struct GFX20_MI_SEMAPHORE_SIGNAL * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 7) |
      util_bitpack_uint(values->TargetEngineSelect, 15, 18) |
      util_bitpack_uint(values->PostSyncOperation, 21, 21) |
      util_bitpack_uint(values->MICommandOpcode, 23, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->TargetContextID, 0, 31);
}

#define GFX20_MI_SEMAPHORE_WAIT_length         5
#define GFX20_MI_SEMAPHORE_WAIT_length_bias      2
#define GFX20_MI_SEMAPHORE_WAIT_header          \
   .DWordLength                         =      3,  \
   .MICommandOpcode                     =     28,  \
   .CommandType                         =      0

struct GFX20_MI_SEMAPHORE_WAIT {
   uint32_t                             DWordLength;
   uint32_t                             CompareOperation;
#define COMPARE_SAD_GREATER_THAN_SDD             0
#define COMPARE_SAD_GREATER_THAN_OR_EQUAL_SDD    1
#define COMPARE_SAD_LESS_THAN_SDD                2
#define COMPARE_SAD_LESS_THAN_OR_EQUAL_SDD       3
#define COMPARE_SAD_EQUAL_SDD                    4
#define COMPARE_SAD_NOT_EQUAL_SDD                5
   uint32_t                             WaitMode;
#define PollingMode                              1
#define SignalMode                               0
   bool                                 RegisterPollMode;
   bool                                 IndirectSemaphoreDataDword;
   bool                                 WorkloadPartitionIDOffsetEnable;
   uint32_t                             MemoryType;
#define PerProcessGraphicsAddress                0
#define GlobalGraphicsAddress                    1
   uint32_t                             MICommandOpcode;
   uint32_t                             CommandType;
   uint32_t                             SemaphoreDataDword;
   __gen_address_type                   SemaphoreAddress;
   uint32_t                             WaitTokenNumber;
};

static inline __attribute__((always_inline)) void
GFX20_MI_SEMAPHORE_WAIT_pack(__attribute__((unused)) __gen_user_data *data,
                             __attribute__((unused)) void * restrict dst,
                             __attribute__((unused)) const struct GFX20_MI_SEMAPHORE_WAIT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 7) |
      util_bitpack_uint(values->CompareOperation, 12, 14) |
      util_bitpack_uint(values->WaitMode, 15, 15) |
      util_bitpack_uint(values->RegisterPollMode, 16, 16) |
      util_bitpack_uint(values->IndirectSemaphoreDataDword, 17, 17) |
      util_bitpack_uint(values->WorkloadPartitionIDOffsetEnable, 18, 18) |
      util_bitpack_uint(values->MemoryType, 22, 22) |
      util_bitpack_uint(values->MICommandOpcode, 23, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->SemaphoreDataDword, 0, 31);

   const uint64_t v2_address =
      __gen_address(data, &dw[2], values->SemaphoreAddress, 0, 2, 63);
   dw[2] = v2_address;
   dw[3] = v2_address >> 32;

   dw[4] =
      util_bitpack_uint(values->WaitTokenNumber, 2, 9);
}

#define GFX20_MI_SET_APPID_length              1
#define GFX20_MI_SET_APPID_length_bias         1
#define GFX20_MI_SET_APPID_header               \
   .MICommandOpcode                     =     14,  \
   .CommandType                         =      0

struct GFX20_MI_SET_APPID {
   uint32_t                             ProtectedMemoryApplicationID;
   uint32_t                             ProtectedMemoryApplicationIDType;
#define DISPLAY_APP                              0
#define TRANSCODE_APP                            1
   uint32_t                             MICommandOpcode;
   uint32_t                             CommandType;
};

static inline __attribute__((always_inline)) void
GFX20_MI_SET_APPID_pack(__attribute__((unused)) __gen_user_data *data,
                        __attribute__((unused)) void * restrict dst,
                        __attribute__((unused)) const struct GFX20_MI_SET_APPID * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->ProtectedMemoryApplicationID, 0, 6) |
      util_bitpack_uint(values->ProtectedMemoryApplicationIDType, 7, 7) |
      util_bitpack_uint(values->MICommandOpcode, 23, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);
}

#define GFX20_MI_SET_PREDICATE_length          1
#define GFX20_MI_SET_PREDICATE_length_bias      1
#define GFX20_MI_SET_PREDICATE_header           \
   .MICommandOpcode                     =      1,  \
   .CommandType                         =      0

struct GFX20_MI_SET_PREDICATE {
   uint32_t                             PredicateEnable;
#define NOOPNever                                0
#define NOOPOnResult2Clear                       1
#define NOOPOnResult2Set                         2
#define NOOPOnResultClear                        3
#define NOOPOnResultSet                          4
#define NOOPAlways                               15
   uint32_t                             MICommandOpcode;
   uint32_t                             CommandType;
};

static inline __attribute__((always_inline)) void
GFX20_MI_SET_PREDICATE_pack(__attribute__((unused)) __gen_user_data *data,
                            __attribute__((unused)) void * restrict dst,
                            __attribute__((unused)) const struct GFX20_MI_SET_PREDICATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->PredicateEnable, 0, 3) |
      util_bitpack_uint(values->MICommandOpcode, 23, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);
}

#define GFX20_MI_STORE_DATA_IMM_length         4
#define GFX20_MI_STORE_DATA_IMM_length_bias      2
#define GFX20_MI_STORE_DATA_IMM_header          \
   .DWordLength                         =      2,  \
   .MICommandOpcode                     =     32,  \
   .CommandType                         =      0

struct GFX20_MI_STORE_DATA_IMM {
   uint32_t                             DWordLength;
   bool                                 ForceWriteCompletionCheck;
   uint32_t                             StoreQword;
   bool                                 UseGlobalGTT;
   uint32_t                             MICommandOpcode;
   uint32_t                             CommandType;
   uint32_t                             CoreModeEnable;
   __gen_address_type                   Address;
   uint64_t                             ImmediateData;
};

static inline __attribute__((always_inline)) void
GFX20_MI_STORE_DATA_IMM_pack(__attribute__((unused)) __gen_user_data *data,
                             __attribute__((unused)) void * restrict dst,
                             __attribute__((unused)) const struct GFX20_MI_STORE_DATA_IMM * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 9) |
      util_bitpack_uint(values->ForceWriteCompletionCheck, 10, 10) |
      util_bitpack_uint(values->StoreQword, 21, 21) |
      util_bitpack_uint(values->UseGlobalGTT, 22, 22) |
      util_bitpack_uint(values->MICommandOpcode, 23, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   const uint64_t v1 =
      util_bitpack_uint(values->CoreModeEnable, 0, 0);
   const uint64_t v1_address =
      __gen_address(data, &dw[1], values->Address, v1, 2, 47);
   dw[1] = v1_address;
   dw[2] = (v1_address >> 32) | (v1 >> 32);

   const uint64_t v3 =
      util_bitpack_uint(values->ImmediateData, 0, 63);
   dw[3] = v3;
   dw[4] = v3 >> 32;
}

#define GFX20_MI_STORE_DATA_INDEX_length       3
#define GFX20_MI_STORE_DATA_INDEX_length_bias      2
#define GFX20_MI_STORE_DATA_INDEX_header        \
   .DWordLength                         =      1,  \
   .MICommandOpcode                     =     33,  \
   .CommandType                         =      0

struct GFX20_MI_STORE_DATA_INDEX {
   uint32_t                             DWordLength;
   uint32_t                             UsePerProcessHardwareStatusPage;
   uint32_t                             MICommandOpcode;
   uint32_t                             CommandType;
   uint32_t                             Offset;
   uint32_t                             DataDWord0;
   uint32_t                             DataDWord1;
};

static inline __attribute__((always_inline)) void
GFX20_MI_STORE_DATA_INDEX_pack(__attribute__((unused)) __gen_user_data *data,
                               __attribute__((unused)) void * restrict dst,
                               __attribute__((unused)) const struct GFX20_MI_STORE_DATA_INDEX * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 7) |
      util_bitpack_uint(values->UsePerProcessHardwareStatusPage, 21, 21) |
      util_bitpack_uint(values->MICommandOpcode, 23, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->Offset, 2, 11);

   dw[2] =
      util_bitpack_uint(values->DataDWord0, 0, 31);
}

#define GFX20_MI_STORE_REGISTER_MEM_length      4
#define GFX20_MI_STORE_REGISTER_MEM_length_bias      2
#define GFX20_MI_STORE_REGISTER_MEM_header      \
   .DWordLength                         =      2,  \
   .MICommandOpcode                     =     36,  \
   .CommandType                         =      0

struct GFX20_MI_STORE_REGISTER_MEM {
   uint32_t                             DWordLength;
   uint32_t                             AddCSMMIOStartOffset;
   bool                                 PredicateEnable;
   bool                                 UseGlobalGTT;
   uint32_t                             MICommandOpcode;
   uint32_t                             CommandType;
   uint64_t                             RegisterAddress;
   __gen_address_type                   MemoryAddress;
};

static inline __attribute__((always_inline)) void
GFX20_MI_STORE_REGISTER_MEM_pack(__attribute__((unused)) __gen_user_data *data,
                                 __attribute__((unused)) void * restrict dst,
                                 __attribute__((unused)) const struct GFX20_MI_STORE_REGISTER_MEM * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 7) |
      util_bitpack_uint(values->AddCSMMIOStartOffset, 19, 19) |
      util_bitpack_uint(values->PredicateEnable, 21, 21) |
      util_bitpack_uint(values->UseGlobalGTT, 22, 22) |
      util_bitpack_uint(values->MICommandOpcode, 23, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      __gen_offset(values->RegisterAddress, 2, 22);

   const uint64_t v2_address =
      __gen_address(data, &dw[2], values->MemoryAddress, 0, 2, 63);
   dw[2] = v2_address;
   dw[3] = v2_address >> 32;
}

#define GFX20_MI_SUSPEND_FLUSH_length          1
#define GFX20_MI_SUSPEND_FLUSH_length_bias      1
#define GFX20_MI_SUSPEND_FLUSH_header           \
   .MICommandOpcode                     =     11,  \
   .CommandType                         =      0

struct GFX20_MI_SUSPEND_FLUSH {
   bool                                 SuspendFlush;
   uint32_t                             MICommandOpcode;
   uint32_t                             CommandType;
};

static inline __attribute__((always_inline)) void
GFX20_MI_SUSPEND_FLUSH_pack(__attribute__((unused)) __gen_user_data *data,
                            __attribute__((unused)) void * restrict dst,
                            __attribute__((unused)) const struct GFX20_MI_SUSPEND_FLUSH * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->SuspendFlush, 0, 0) |
      util_bitpack_uint(values->MICommandOpcode, 23, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);
}

#define GFX20_MI_USER_INTERRUPT_length         1
#define GFX20_MI_USER_INTERRUPT_length_bias      1
#define GFX20_MI_USER_INTERRUPT_header          \
   .MICommandOpcode                     =      2,  \
   .CommandType                         =      0

struct GFX20_MI_USER_INTERRUPT {
   uint32_t                             MICommandOpcode;
   uint32_t                             CommandType;
};

static inline __attribute__((always_inline)) void
GFX20_MI_USER_INTERRUPT_pack(__attribute__((unused)) __gen_user_data *data,
                             __attribute__((unused)) void * restrict dst,
                             __attribute__((unused)) const struct GFX20_MI_USER_INTERRUPT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->MICommandOpcode, 23, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);
}

#define GFX20_SFC_AVS_CHROMA_COEFF_TABLE_length     65
#define GFX20_SFC_AVS_CHROMA_COEFF_TABLE_length_bias      2
#define GFX20_SFC_AVS_CHROMA_COEFF_TABLE_header \
   .DWordLength                         =     63,  \
   .SubOpcodeB                          =      6,  \
   .SubOpcodeA                          =      0,  \
   .MediaCommandOpcode                  =     10,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_SFC_AVS_CHROMA_COEFF_TABLE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   struct GFX20_SFC_AVS_CHROMA_COEFF_TABLE_BODY AVSCHROMACoefficientTableBody;
};

static inline __attribute__((always_inline)) void
GFX20_SFC_AVS_CHROMA_COEFF_TABLE_pack(__attribute__((unused)) __gen_user_data *data,
                                      __attribute__((unused)) void * restrict dst,
                                      __attribute__((unused)) const struct GFX20_SFC_AVS_CHROMA_COEFF_TABLE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   GFX20_SFC_AVS_CHROMA_COEFF_TABLE_BODY_pack(data, &dw[1], &values->AVSCHROMACoefficientTableBody);
}

#define GFX20_SFC_AVS_LUMA_COEFF_TABLE_length    129
#define GFX20_SFC_AVS_LUMA_COEFF_TABLE_length_bias      2
#define GFX20_SFC_AVS_LUMA_COEFF_TABLE_header   \
   .DWordLength                         =    127,  \
   .SubOpcodeB                          =      5,  \
   .SubOpcodeA                          =      0,  \
   .MediaCommandOpcode                  =     10,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_SFC_AVS_LUMA_COEFF_TABLE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   struct GFX20_SFC_AVS_LUMA_COEFF_TABLE_BODY AVSLUMACoefficientTableBody;
};

static inline __attribute__((always_inline)) void
GFX20_SFC_AVS_LUMA_COEFF_TABLE_pack(__attribute__((unused)) __gen_user_data *data,
                                    __attribute__((unused)) void * restrict dst,
                                    __attribute__((unused)) const struct GFX20_SFC_AVS_LUMA_COEFF_TABLE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   GFX20_SFC_AVS_LUMA_COEFF_TABLE_BODY_pack(data, &dw[1], &values->AVSLUMACoefficientTableBody);
}

#define GFX20_SFC_AVS_STATE_length             4
#define GFX20_SFC_AVS_STATE_length_bias        2
#define GFX20_SFC_AVS_STATE_header              \
   .DWordLength                         =      2,  \
   .SubOpcodeB                          =      2,  \
   .SubOpcodeA                          =      0,  \
   .MediaCommandOpcode                  =     10,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_SFC_AVS_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   struct GFX20_SFC_AVS_STATE_BODY      AVSStateBody;
};

static inline __attribute__((always_inline)) void
GFX20_SFC_AVS_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                         __attribute__((unused)) void * restrict dst,
                         __attribute__((unused)) const struct GFX20_SFC_AVS_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   GFX20_SFC_AVS_STATE_BODY_pack(data, &dw[1], &values->AVSStateBody);
}

#define GFX20_SFC_FRAME_START_length           2
#define GFX20_SFC_FRAME_START_length_bias      2
#define GFX20_SFC_FRAME_START_header            \
   .DWordLength                         =      0,  \
   .SubOpcodeB                          =      4,  \
   .SubOpcodeA                          =      0,  \
   .MediaCommandOpcode                  =     10,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_SFC_FRAME_START {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             FrameStartBody;
};

static inline __attribute__((always_inline)) void
GFX20_SFC_FRAME_START_pack(__attribute__((unused)) __gen_user_data *data,
                           __attribute__((unused)) void * restrict dst,
                           __attribute__((unused)) const struct GFX20_SFC_FRAME_START * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->FrameStartBody, 0, 31);
}

#define GFX20_SFC_IEF_STATE_length            24
#define GFX20_SFC_IEF_STATE_length_bias        2
#define GFX20_SFC_IEF_STATE_header              \
   .DWordLength                         =     22,  \
   .SubOpcodeB                          =      3,  \
   .SubOpcodeA                          =      0,  \
   .MediaCommandOpcode                  =     10,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_SFC_IEF_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   struct GFX20_SFC_IEF_STATE_BODY      SFCIEFStateBody;
};

static inline __attribute__((always_inline)) void
GFX20_SFC_IEF_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                         __attribute__((unused)) void * restrict dst,
                         __attribute__((unused)) const struct GFX20_SFC_IEF_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   GFX20_SFC_IEF_STATE_BODY_pack(data, &dw[1], &values->SFCIEFStateBody);
}

#define GFX20_SFC_LOCK_length                  2
#define GFX20_SFC_LOCK_length_bias             2
#define GFX20_SFC_LOCK_header                   \
   .DWordLength                         =      0,  \
   .SubOpcodeB                          =      0,  \
   .SubOpcodeA                          =      0,  \
   .MediaCommandOpcode                  =     10,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_SFC_LOCK {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   struct GFX20_SFC_LOCK_BODY           SFCLockBody;
};

static inline __attribute__((always_inline)) void
GFX20_SFC_LOCK_pack(__attribute__((unused)) __gen_user_data *data,
                    __attribute__((unused)) void * restrict dst,
                    __attribute__((unused)) const struct GFX20_SFC_LOCK * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   GFX20_SFC_LOCK_BODY_pack(data, &dw[1], &values->SFCLockBody);
}

#define GFX20_SFC_STATE_length                32
#define GFX20_SFC_STATE_length_bias            2
#define GFX20_SFC_STATE_header                  \
   .DWordLength                         =     30,  \
   .SubOpcodeB                          =      1,  \
   .SubOpcodeA                          =      0,  \
   .MediaCommandOpcode                  =     10,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_SFC_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             SFCPipeMode;
   uint32_t                             SFCInputChromaSubSampling;
#define _400                                     0
#define _420                                     1
#define _422Horizontal                           2
#define _444ProgressiveInterleaved               4
   uint32_t                             VDVEInputOrderingMode;
   uint32_t                             InputFrameResolutionWidth;
   uint32_t                             InputFrameResolutionHeight;
   uint32_t                             OutputSurfaceFormatType;
   bool                                 RGBAChannelSwapEnable;
   uint32_t                             OutputChromaDownsamplingCositingpositionVerticalDirection;
#define _08LeftFullPixel                         0
#define _18                                      1
#define _1428                                    2
#define _38                                      3
#define _1248                                    4
#define _58                                      5
#define _3468                                    6
#define _78                                      7
#define _88                                      8
   uint32_t                             OutputChromaDownsamplingCositingpositionHorizontalDirection;
#define _08LeftFullPixel                         0
#define _18                                      1
#define _1428                                    2
#define _38                                      3
#define _1248                                    4
#define _58                                      5
#define _3468                                    6
#define _78                                      7
#define _88                                      8
   bool                                 IEFEnable;
   bool                                 SkinToneTunedIEF_Enable;
   bool                                 IEF4SmoothEnable;
   uint32_t                             AVSFilterMode;
#define _5x5PolyphasefilterBilinear              0
#define _8x8polyphasefilterBilinear              1
#define Bilinearfilteronly                       2
   bool                                 AdaptiveFilterforallChannels;
   bool                                 AVSScalingEnable;
   bool                                 BypassYAdaptiveFiltering;
   bool                                 BypassXAdaptiveFiltering;
   bool                                 RGBAdaptive;
   bool                                 ChromaUpsamplingEnable;
   uint32_t                             MirrorType;
#define HorizontalFlip                           0
#define VerticalFlip                             1
   bool                                 MirrorMode;
   uint32_t                             RotationMode;
#define _0                                       0
#define _90CW                                    1
#define _180CW                                   2
#define _270CW                                   3
   bool                                 ColorFillEnable;
   bool                                 CSCEnable;
   uint32_t                             BitDepth;
#define SFC_10bit                                0
#define SFC_16bit                                1
   uint32_t                             SourceRegionWidth;
   uint32_t                             SourceRegionHeight;
   uint32_t                             SourceRegionHorizontalOffset;
   uint32_t                             SourceRegionVerticalOffset;
   uint32_t                             OutputFrameWidth;
   uint32_t                             OutputFrameHeight;
   uint32_t                             ScaledRegionSizeWidth;
   uint32_t                             ScaledRegionSizeHeight;
   int32_t                              ScaledRegionHorizontalOffset;
   int32_t                              ScaledRegionVerticalOffset;
   uint32_t                             GrayBarPixelUG;
   uint32_t                             GrayBarPixelYR;
   uint32_t                             GrayBarPixelA;
   uint32_t                             GrayBarPixelVB;
   uint32_t                             UVDefaultvalueforUchannel;
   uint32_t                             UVDefaultvalueforVchannel;
   uint32_t                             AlphaDefaultValue;
   float                                ScalingFactorHeight;
   float                                ScalingFactorWidth;
   uint64_t                             OutputFrameAddress;
   uint32_t                             OutputFrameMOCS;
   struct GFX20_HEVC_ARBITRATION_PRIORITY OutputFrameArbitrationPriorityControl;
   bool                                 OutputFrameMemoryCompressionEnable;
   uint32_t                             OutputFrameMemoryCompressionMode;
   bool                                 OutputFrameCacheSelect;
   uint32_t                             OutputFrameTiledMode;
#define TRMODE_NONE                              0
#define TRMODE_TILEYF                            1
#define TRMODE_TILEYS                            2
   uint64_t                             AVSLineBufferAddress;
   uint32_t                             AVSLineBufferMOCS;
   struct GFX20_HEVC_ARBITRATION_PRIORITY AVSLineBufferArbitrationPriorityControl;
   bool                                 AVSLineBufferMemoryCompressionEnable;
   uint32_t                             AVSLineBufferMemoryCompressionMode;
#define HorizontalCompressionMode                0
   uint32_t                             AVSLineBufferCacheSelect;
#define LLC                                      0
   uint32_t                             AVSLineBufferTiledMode;
#define TRMODE_NONE                              0
#define TRMODE_TILEYF                            1
#define TRMODE_TILEYS                            2
   uint64_t                             IEFLineBufferAddress;
   uint32_t                             IEFLineBufferMOCS;
   struct GFX20_HEVC_ARBITRATION_PRIORITY IEFLineBufferArbitrationPriorityControl;
   bool                                 IEFLineBufferMemoryCompressionEnable;
   uint32_t                             IEFLineBufferMemoryCompressionMode;
   uint32_t                             IEFLineBufferCacheSelect;
   uint32_t                             IEFLineBufferTiledMode;
#define TRMODE_NONE                              0
#define TRMODE_TILEYF                            1
#define TRMODE_TILEYS                            2
   uint32_t                             OutputSurfaceTileWalk;
#define TW_XMAJOR                                0
#define TW_YMAJOR                                1
   bool                                 OutputSurfaceTiled;
   bool                                 OutputSurfaceHalfPitchforChroma;
   uint32_t                             OutputSurfacePitch;
   bool                                 OutputSurfaceInterleaveChromaEnable;
   uint32_t                             OutputSurfaceFormat;
   uint32_t                             OutputSurfaceYOffsetforU;
   uint32_t                             OutputSurfaceXOffsetforU;
   uint32_t                             OutputSurfaceYOffsetforV;
   uint32_t                             OutputSurfaceXOffsetforV;
};

static inline __attribute__((always_inline)) void
GFX20_SFC_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                     __attribute__((unused)) void * restrict dst,
                     __attribute__((unused)) const struct GFX20_SFC_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->SFCPipeMode, 0, 3) |
      util_bitpack_uint(values->SFCInputChromaSubSampling, 4, 7) |
      util_bitpack_uint(values->VDVEInputOrderingMode, 8, 10);

   dw[2] =
      util_bitpack_uint(values->InputFrameResolutionWidth, 0, 11) |
      util_bitpack_uint(values->InputFrameResolutionHeight, 16, 27);

   dw[3] =
      util_bitpack_uint(values->OutputSurfaceFormatType, 0, 3) |
      util_bitpack_uint(values->RGBAChannelSwapEnable, 5, 5) |
      util_bitpack_uint(values->OutputChromaDownsamplingCositingpositionVerticalDirection, 8, 11) |
      util_bitpack_uint(values->OutputChromaDownsamplingCositingpositionHorizontalDirection, 12, 15);

   dw[4] =
      util_bitpack_uint(values->IEFEnable, 0, 0) |
      util_bitpack_uint(values->SkinToneTunedIEF_Enable, 1, 1) |
      util_bitpack_uint(values->IEF4SmoothEnable, 2, 2) |
      util_bitpack_uint(values->AVSFilterMode, 4, 5) |
      util_bitpack_uint(values->AdaptiveFilterforallChannels, 6, 6) |
      util_bitpack_uint(values->AVSScalingEnable, 7, 7) |
      util_bitpack_uint(values->BypassYAdaptiveFiltering, 8, 8) |
      util_bitpack_uint(values->BypassXAdaptiveFiltering, 9, 9) |
      util_bitpack_uint(values->RGBAdaptive, 10, 10) |
      util_bitpack_uint(values->ChromaUpsamplingEnable, 12, 12) |
      util_bitpack_uint(values->MirrorType, 13, 13) |
      util_bitpack_uint(values->MirrorMode, 14, 14) |
      util_bitpack_uint(values->RotationMode, 16, 17) |
      util_bitpack_uint(values->ColorFillEnable, 18, 18) |
      util_bitpack_uint(values->CSCEnable, 19, 19) |
      util_bitpack_uint(values->BitDepth, 20, 21);

   dw[5] =
      util_bitpack_uint(values->SourceRegionWidth, 0, 11) |
      util_bitpack_uint(values->SourceRegionHeight, 16, 27);

   dw[6] =
      util_bitpack_uint(values->SourceRegionHorizontalOffset, 0, 11) |
      util_bitpack_uint(values->SourceRegionVerticalOffset, 16, 27);

   dw[7] =
      util_bitpack_uint(values->OutputFrameWidth, 0, 11) |
      util_bitpack_uint(values->OutputFrameHeight, 16, 27);

   dw[8] =
      util_bitpack_uint(values->ScaledRegionSizeWidth, 0, 11) |
      util_bitpack_uint(values->ScaledRegionSizeHeight, 16, 27);

   dw[9] =
      util_bitpack_sint(values->ScaledRegionHorizontalOffset, 0, 12) |
      util_bitpack_sint(values->ScaledRegionVerticalOffset, 16, 28);

   dw[10] =
      util_bitpack_uint(values->GrayBarPixelUG, 0, 9) |
      util_bitpack_uint(values->GrayBarPixelYR, 16, 25);

   dw[11] =
      util_bitpack_uint(values->GrayBarPixelA, 0, 9) |
      util_bitpack_uint(values->GrayBarPixelVB, 16, 25);

   dw[12] =
      util_bitpack_uint(values->UVDefaultvalueforUchannel, 0, 9) |
      util_bitpack_uint(values->UVDefaultvalueforVchannel, 16, 25);

   dw[13] =
      util_bitpack_uint(values->AlphaDefaultValue, 0, 9);

   dw[14] =
      util_bitpack_ufixed(values->ScalingFactorHeight, 0, 20, 17);

   dw[15] =
      util_bitpack_ufixed(values->ScalingFactorWidth, 0, 20, 17);

   dw[16] = 0;

   const uint64_t v17 =
      util_bitpack_uint(values->OutputFrameAddress, 12, 47);
   dw[17] = v17;
   dw[18] = v17 >> 32;

   uint32_t v19_0;
   GFX20_HEVC_ARBITRATION_PRIORITY_pack(data, &v19_0, &values->OutputFrameArbitrationPriorityControl);

   dw[19] =
      util_bitpack_uint_nonzero(values->OutputFrameMOCS, 0, 6) |
      util_bitpack_uint(v19_0, 7, 8) |
      util_bitpack_uint(values->OutputFrameMemoryCompressionEnable, 9, 9) |
      util_bitpack_uint(values->OutputFrameMemoryCompressionMode, 10, 10) |
      util_bitpack_uint(values->OutputFrameCacheSelect, 12, 12) |
      util_bitpack_uint(values->OutputFrameTiledMode, 13, 14);

   const uint64_t v20 =
      util_bitpack_uint(values->AVSLineBufferAddress, 12, 47);
   dw[20] = v20;
   dw[21] = v20 >> 32;

   uint32_t v22_0;
   GFX20_HEVC_ARBITRATION_PRIORITY_pack(data, &v22_0, &values->AVSLineBufferArbitrationPriorityControl);

   dw[22] =
      util_bitpack_uint_nonzero(values->AVSLineBufferMOCS, 0, 6) |
      util_bitpack_uint(v22_0, 7, 8) |
      util_bitpack_uint(values->AVSLineBufferMemoryCompressionEnable, 9, 9) |
      util_bitpack_uint(values->AVSLineBufferMemoryCompressionMode, 10, 10) |
      util_bitpack_uint(values->AVSLineBufferCacheSelect, 12, 12) |
      util_bitpack_uint(values->AVSLineBufferTiledMode, 13, 14);

   const uint64_t v23 =
      util_bitpack_uint(values->IEFLineBufferAddress, 12, 47);
   dw[23] = v23;
   dw[24] = v23 >> 32;

   uint32_t v25_0;
   GFX20_HEVC_ARBITRATION_PRIORITY_pack(data, &v25_0, &values->IEFLineBufferArbitrationPriorityControl);

   dw[25] =
      util_bitpack_uint_nonzero(values->IEFLineBufferMOCS, 0, 6) |
      util_bitpack_uint(v25_0, 7, 8) |
      util_bitpack_uint(values->IEFLineBufferMemoryCompressionEnable, 9, 9) |
      util_bitpack_uint(values->IEFLineBufferMemoryCompressionMode, 10, 10) |
      util_bitpack_uint(values->IEFLineBufferCacheSelect, 12, 12) |
      util_bitpack_uint(values->IEFLineBufferTiledMode, 13, 14);

   dw[26] = 0;

   dw[27] = 0;

   dw[28] = 0;

   dw[29] =
      util_bitpack_uint(values->OutputSurfaceTileWalk, 0, 0) |
      util_bitpack_uint(values->OutputSurfaceTiled, 1, 1) |
      util_bitpack_uint(values->OutputSurfaceHalfPitchforChroma, 2, 2) |
      util_bitpack_uint(values->OutputSurfacePitch, 3, 19) |
      util_bitpack_uint(values->OutputSurfaceInterleaveChromaEnable, 27, 27) |
      util_bitpack_uint(values->OutputSurfaceFormat, 28, 31);

   dw[30] =
      util_bitpack_uint(values->OutputSurfaceYOffsetforU, 0, 13) |
      util_bitpack_uint(values->OutputSurfaceXOffsetforU, 16, 29);

   dw[31] =
      util_bitpack_uint(values->OutputSurfaceYOffsetforV, 0, 13) |
      util_bitpack_uint(values->OutputSurfaceXOffsetforV, 16, 29);
}

#define GFX20_STATE_SYSTEM_MEM_FENCE_ADDRESS_length      3
#define GFX20_STATE_SYSTEM_MEM_FENCE_ADDRESS_length_bias      2
#define GFX20_STATE_SYSTEM_MEM_FENCE_ADDRESS_header\
   .DWordLength                         =      1,  \
   .ContextRestoreInvalid               =      0,  \
   ._3DCommandSubOpcode                 =      9,  \
   ._3DCommandOpcode                    =      1,  \
   .CommandSubType                      =      0,  \
   .CommandType                         =      3

struct GFX20_STATE_SYSTEM_MEM_FENCE_ADDRESS {
   uint32_t                             DWordLength;
   bool                                 ContextRestoreInvalid;
   uint32_t                             _3DCommandSubOpcode;
   uint32_t                             _3DCommandOpcode;
   uint32_t                             CommandSubType;
   uint32_t                             CommandType;
   __gen_address_type                   SystemMemoryFenceAddress;
};

static inline __attribute__((always_inline)) void
GFX20_STATE_SYSTEM_MEM_FENCE_ADDRESS_pack(__attribute__((unused)) __gen_user_data *data,
                                          __attribute__((unused)) void * restrict dst,
                                          __attribute__((unused)) const struct GFX20_STATE_SYSTEM_MEM_FENCE_ADDRESS * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 7) |
      util_bitpack_uint(values->ContextRestoreInvalid, 15, 15) |
      util_bitpack_uint(values->_3DCommandSubOpcode, 16, 23) |
      util_bitpack_uint(values->_3DCommandOpcode, 24, 26) |
      util_bitpack_uint(values->CommandSubType, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   const uint64_t v1_address =
      __gen_address(data, &dw[1], values->SystemMemoryFenceAddress, 0, 12, 63);
   dw[1] = v1_address;
   dw[2] = v1_address >> 32;
}

#define GFX20_VDENC_CMD1_length               31
#define GFX20_VDENC_CMD1_length_bias           2
#define GFX20_VDENC_CMD1_header                 \
   .DWordLength                         =     29,  \
   .SubOpcodeB                          =     10,  \
   .SubOpcodeA                          =      0,  \
   .MediaCommandOpCode                  =      1,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_VDENC_CMD1 {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpCode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             Values[30];
};

static inline __attribute__((always_inline)) void
GFX20_VDENC_CMD1_pack(__attribute__((unused)) __gen_user_data *data,
                      __attribute__((unused)) void * restrict dst,
                      __attribute__((unused)) const struct GFX20_VDENC_CMD1 * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 22) |
      util_bitpack_uint(values->MediaCommandOpCode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->Values[0], 0, 31);

   dw[2] =
      util_bitpack_uint(values->Values[1], 0, 31);

   dw[3] =
      util_bitpack_uint(values->Values[2], 0, 31);

   dw[4] =
      util_bitpack_uint(values->Values[3], 0, 31);

   dw[5] =
      util_bitpack_uint(values->Values[4], 0, 31);

   dw[6] =
      util_bitpack_uint(values->Values[5], 0, 31);

   dw[7] =
      util_bitpack_uint(values->Values[6], 0, 31);

   dw[8] =
      util_bitpack_uint(values->Values[7], 0, 31);

   dw[9] =
      util_bitpack_uint(values->Values[8], 0, 31);

   dw[10] =
      util_bitpack_uint(values->Values[9], 0, 31);

   dw[11] =
      util_bitpack_uint(values->Values[10], 0, 31);

   dw[12] =
      util_bitpack_uint(values->Values[11], 0, 31);

   dw[13] =
      util_bitpack_uint(values->Values[12], 0, 31);

   dw[14] =
      util_bitpack_uint(values->Values[13], 0, 31);

   dw[15] =
      util_bitpack_uint(values->Values[14], 0, 31);

   dw[16] =
      util_bitpack_uint(values->Values[15], 0, 31);

   dw[17] =
      util_bitpack_uint(values->Values[16], 0, 31);

   dw[18] =
      util_bitpack_uint(values->Values[17], 0, 31);

   dw[19] =
      util_bitpack_uint(values->Values[18], 0, 31);

   dw[20] =
      util_bitpack_uint(values->Values[19], 0, 31);

   dw[21] =
      util_bitpack_uint(values->Values[20], 0, 31);

   dw[22] =
      util_bitpack_uint(values->Values[21], 0, 31);

   dw[23] =
      util_bitpack_uint(values->Values[22], 0, 31);

   dw[24] =
      util_bitpack_uint(values->Values[23], 0, 31);

   dw[25] =
      util_bitpack_uint(values->Values[24], 0, 31);

   dw[26] =
      util_bitpack_uint(values->Values[25], 0, 31);

   dw[27] =
      util_bitpack_uint(values->Values[26], 0, 31);

   dw[28] =
      util_bitpack_uint(values->Values[27], 0, 31);

   dw[29] =
      util_bitpack_uint(values->Values[28], 0, 31);

   dw[30] =
      util_bitpack_uint(values->Values[29], 0, 31);
}

#define GFX20_VDENC_CMD2_length               51
#define GFX20_VDENC_CMD2_length_bias           2
#define GFX20_VDENC_CMD2_header                 \
   .DWordLength                         =     49,  \
   .SubOpcodeB                          =      9,  \
   .SubOpcodeA                          =      0,  \
   .MediaCommandOpCode                  =      1,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_VDENC_CMD2 {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpCode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             FrameWidthInPixelsMinusOne;
   uint32_t                             Values1;
   uint32_t                             FrameHeightInPixelsMinusOne;
   uint32_t                             Values2;
   uint32_t                             PictureType;
   bool                                 TemporalMVPEnableFlag;
   uint32_t                             LongTermReferenceFlagsL0;
   uint32_t                             LongTermReferenceFlagsL1;
   bool                                 TransformSkip;
   int32_t                              POCNumberForRefid0InL0;
   uint32_t                             Values3;
   int32_t                              POCNumberForRefid0InL1;
   int32_t                              POCNumberForRefid1InL0;
   int32_t                              POCNumberForRefid1InL1;
   int32_t                              POCNumberForRefid2InL0;
   uint32_t                             Values4;
   int32_t                              POCNumberForRefid2InL1;
   uint32_t                             Values5;
   bool                                 StreamInROIEnable;
   uint32_t                             SubPelMode;
   uint32_t                             NumRefIdxL0MinusOne;
   uint32_t                             NumRefIdxL1MinusOne;
   uint32_t                             Values6;
   uint32_t                             Values7;
   bool                                 SegmentationEnable;
   bool                                 SegmentationMapTemporalPredictionEnable;
   bool                                 TilingEnable;
   bool                                 VDEncStreamInEnable;
   bool                                 PAKOnlyMultiPassEnable;
   uint32_t                             Values8;
   uint32_t                             Values9;
   uint32_t                             Values10;
   uint32_t                             Values11;
   uint32_t                             Values12;
   uint32_t                             Values13;
   uint32_t                             RoiQPAdjustmentForZone1Stage3;
   uint32_t                             RoiQPAdjustmentForZone2Stage3;
   uint32_t                             RoiQPAdjustmentForZone3Stage3;
   uint32_t                             Values14;
   uint32_t                             Values15;
   uint32_t                             MinQp;
   uint32_t                             Values16;
   uint32_t                             MaxQp;
   uint32_t                             Values17;
   bool                                 TemporalMVEnableForIntegerSearch;
   uint32_t                             Values18;
   uint32_t                             Values19;
   uint32_t                             Values20;
   uint32_t                             IntraRefreshPos;
   uint32_t                             Values21;
   uint32_t                             IntraRefreshMBSizeMinusOne;
   uint32_t                             IntraRefreshMode;
   uint32_t                             QPAdjustmentForRollingI;
   uint32_t                             Values22;
   uint32_t                             Values23;
   uint32_t                             QPForSeg0;
   uint32_t                             Values24;
   uint32_t                             QPForSeg1;
   uint32_t                             QPForSeg2;
   uint32_t                             QPForSeg3;
   uint32_t                             QPForSeg4;
   uint32_t                             Values25;
   uint32_t                             QPForSeg5;
   uint32_t                             QPForSeg6;
   uint32_t                             QPForSeg7;
   uint32_t                             RdQpLambda;
   uint32_t                             Values26;
   uint32_t                             SadQpLambda;
   bool                                 VP9DynamicSliceEnable;
   uint32_t                             QpPrimeYDc;
   uint32_t                             Values27;
   uint32_t                             QpPrimeYAc;
   uint32_t                             Values28;
   uint32_t                             Values29;
   uint32_t                             Values30;
   uint32_t                             Values31;
   uint32_t                             Values32;
   uint32_t                             Values33;
   uint32_t                             Values34;
   uint32_t                             Values35;
   uint32_t                             IntraRefreshBoundaryRef0;
   uint32_t                             IntraRefreshBoundaryRef1;
   uint32_t                             IntraRefreshBoundaryRef2;
   bool                                 TileReplayEnable;
   uint32_t                             Values39;
   uint32_t                             Values40;
   uint32_t                             Values41;
   uint32_t                             Values42;
   uint32_t                             Values43;
   uint32_t                             Values44;
   uint32_t                             Values45;
   uint32_t                             Values46;
   uint32_t                             Values47;
   uint32_t                             Values48;
   uint32_t                             Values49;
   uint32_t                             Values50;
};

static inline __attribute__((always_inline)) void
GFX20_VDENC_CMD2_pack(__attribute__((unused)) __gen_user_data *data,
                      __attribute__((unused)) void * restrict dst,
                      __attribute__((unused)) const struct GFX20_VDENC_CMD2 * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 22) |
      util_bitpack_uint(values->MediaCommandOpCode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->FrameWidthInPixelsMinusOne, 0, 15) |
      util_bitpack_uint(values->Values1, 0, 31) |
      util_bitpack_uint(values->FrameHeightInPixelsMinusOne, 16, 31);

   dw[2] =
      util_bitpack_uint(values->Values2, 0, 31) |
      util_bitpack_uint(values->PictureType, 20, 21) |
      util_bitpack_uint(values->TemporalMVPEnableFlag, 22, 22) |
      util_bitpack_uint(values->LongTermReferenceFlagsL0, 24, 26) |
      util_bitpack_uint(values->LongTermReferenceFlagsL1, 27, 27) |
      util_bitpack_uint(values->TransformSkip, 30, 30);

   dw[3] =
      util_bitpack_sint(values->POCNumberForRefid0InL0, 0, 7) |
      util_bitpack_uint(values->Values3, 0, 31) |
      util_bitpack_sint(values->POCNumberForRefid0InL1, 8, 15) |
      util_bitpack_sint(values->POCNumberForRefid1InL0, 16, 23) |
      util_bitpack_sint(values->POCNumberForRefid1InL1, 24, 31);

   dw[4] =
      util_bitpack_sint(values->POCNumberForRefid2InL0, 0, 7) |
      util_bitpack_uint(values->Values4, 0, 31) |
      util_bitpack_sint(values->POCNumberForRefid2InL1, 8, 15);

   dw[5] =
      util_bitpack_uint(values->Values5, 0, 31) |
      util_bitpack_uint(values->StreamInROIEnable, 8, 8) |
      util_bitpack_uint(values->SubPelMode, 10, 11) |
      util_bitpack_uint(values->NumRefIdxL0MinusOne, 24, 27) |
      util_bitpack_uint(values->NumRefIdxL1MinusOne, 28, 31);

   dw[6] =
      util_bitpack_uint(values->Values6, 0, 31);

   dw[7] =
      util_bitpack_uint(values->Values7, 0, 31) |
      util_bitpack_uint(values->SegmentationEnable, 4, 4) |
      util_bitpack_uint(values->SegmentationMapTemporalPredictionEnable, 5, 5) |
      util_bitpack_uint(values->TilingEnable, 7, 7) |
      util_bitpack_uint(values->VDEncStreamInEnable, 9, 9) |
      util_bitpack_uint(values->PAKOnlyMultiPassEnable, 16, 16);

   dw[8] =
      util_bitpack_uint(values->Values8, 0, 31);

   dw[9] =
      util_bitpack_uint(values->Values9, 0, 31);

   dw[10] =
      util_bitpack_uint(values->Values10, 0, 31);

   dw[11] =
      util_bitpack_uint(values->Values11, 0, 31);

   dw[12] =
      util_bitpack_uint(values->Values12, 0, 31);

   dw[13] =
      util_bitpack_uint(values->Values13, 0, 31) |
      util_bitpack_uint(values->RoiQPAdjustmentForZone1Stage3, 4, 7) |
      util_bitpack_uint(values->RoiQPAdjustmentForZone2Stage3, 8, 11) |
      util_bitpack_uint(values->RoiQPAdjustmentForZone3Stage3, 12, 15);

   dw[14] =
      util_bitpack_uint(values->Values14, 0, 31);

   dw[15] =
      util_bitpack_uint(values->Values15, 0, 31);

   dw[16] =
      util_bitpack_uint(values->MinQp, 0, 7) |
      util_bitpack_uint(values->Values16, 0, 31) |
      util_bitpack_uint(values->MaxQp, 8, 15);

   dw[17] =
      util_bitpack_uint(values->Values17, 0, 31) |
      util_bitpack_uint(values->TemporalMVEnableForIntegerSearch, 20, 20);

   dw[18] =
      util_bitpack_uint(values->Values18, 0, 31);

   dw[19] =
      util_bitpack_uint(values->Values19, 0, 31);

   dw[20] =
      util_bitpack_uint(values->Values20, 0, 31);

   dw[21] =
      util_bitpack_uint(values->IntraRefreshPos, 0, 8) |
      util_bitpack_uint(values->Values21, 0, 31) |
      util_bitpack_uint(values->IntraRefreshMBSizeMinusOne, 16, 23) |
      util_bitpack_uint(values->IntraRefreshMode, 24, 24) |
      util_bitpack_uint(values->QPAdjustmentForRollingI, 28, 31);

   dw[22] =
      util_bitpack_uint(values->Values22, 0, 31);

   dw[23] =
      util_bitpack_uint(values->Values23, 0, 31);

   dw[24] =
      util_bitpack_uint(values->QPForSeg0, 0, 7) |
      util_bitpack_uint(values->Values24, 0, 31) |
      util_bitpack_uint(values->QPForSeg1, 8, 15) |
      util_bitpack_uint(values->QPForSeg2, 16, 23) |
      util_bitpack_uint(values->QPForSeg3, 24, 31);

   dw[25] =
      util_bitpack_uint(values->QPForSeg4, 0, 7) |
      util_bitpack_uint(values->Values25, 0, 31) |
      util_bitpack_uint(values->QPForSeg5, 8, 15) |
      util_bitpack_uint(values->QPForSeg6, 16, 23) |
      util_bitpack_uint(values->QPForSeg7, 24, 31);

   dw[26] =
      util_bitpack_uint(values->RdQpLambda, 0, 15) |
      util_bitpack_uint(values->Values26, 0, 31) |
      util_bitpack_uint(values->SadQpLambda, 16, 24) |
      util_bitpack_uint(values->VP9DynamicSliceEnable, 25, 25);

   dw[27] =
      util_bitpack_uint(values->QpPrimeYDc, 0, 7) |
      util_bitpack_uint(values->Values27, 0, 31) |
      util_bitpack_uint(values->QpPrimeYAc, 8, 15);

   dw[28] =
      util_bitpack_uint(values->Values28, 0, 31);

   dw[29] =
      util_bitpack_uint(values->Values29, 0, 31);

   dw[30] =
      util_bitpack_uint(values->Values30, 0, 31);

   dw[31] =
      util_bitpack_uint(values->Values31, 0, 31);

   dw[32] =
      util_bitpack_uint(values->Values32, 0, 31);

   dw[33] =
      util_bitpack_uint(values->Values33, 0, 31);

   dw[34] =
      util_bitpack_uint(values->Values34, 0, 31);

   dw[35] =
      util_bitpack_uint(values->Values35, 0, 31);

   dw[36] =
      util_bitpack_uint(values->IntraRefreshBoundaryRef0, 0, 8) |
      util_bitpack_uint(values->IntraRefreshBoundaryRef1, 10, 18) |
      util_bitpack_uint(values->IntraRefreshBoundaryRef2, 20, 28);

   dw[37] =
      util_bitpack_uint(values->TileReplayEnable, 27, 27);

   dw[38] =
      util_bitpack_uint(values->Values39, 0, 31);

   dw[39] =
      util_bitpack_uint(values->Values40, 0, 31);

   dw[40] =
      util_bitpack_uint(values->Values41, 0, 31);

   dw[41] =
      util_bitpack_uint(values->Values42, 0, 31);

   dw[42] =
      util_bitpack_uint(values->Values43, 0, 31);

   dw[43] =
      util_bitpack_uint(values->Values44, 0, 31);

   dw[44] =
      util_bitpack_uint(values->Values45, 0, 31);

   dw[45] =
      util_bitpack_uint(values->Values46, 0, 31);

   dw[46] =
      util_bitpack_uint(values->Values47, 0, 31);

   dw[47] =
      util_bitpack_uint(values->Values48, 0, 31);

   dw[48] =
      util_bitpack_uint(values->Values49, 0, 31);

   dw[49] =
      util_bitpack_uint(values->Values50, 0, 31);

   dw[50] = 0;
}

#define GFX20_VDENC_CONST_QPT_STATE_length     61
#define GFX20_VDENC_CONST_QPT_STATE_length_bias      2
#define GFX20_VDENC_CONST_QPT_STATE_header      \
   .DWordLength                         =     59,  \
   .SubOpcodeB                          =      6,  \
   .SubOpcodeA                          =      0,  \
   .MediaCommandOpcode                  =      1,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_VDENC_CONST_QPT_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             QPLambdaArrayIndex[42];
   uint32_t                             SkipThresholdArrayIndex[27];
   uint32_t                             SICForwardTransformCoeffThresholdMatrix0ArrayIndex[27];
   uint32_t                             SICForwardTransformCoeffThresholdMatrix135ArrayIndex[27];
   uint32_t                             SICForwardTransformCoeffThresholdMatrix2ArrayIndex[27];
   uint32_t                             SICForwardTransformCoeffThresholdMatrix46ArrayIndex[27];
};

static inline __attribute__((always_inline)) void
GFX20_VDENC_CONST_QPT_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                                 __attribute__((unused)) void * restrict dst,
                                 __attribute__((unused)) const struct GFX20_VDENC_CONST_QPT_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->QPLambdaArrayIndex[0], 0, 7) |
      util_bitpack_uint(values->QPLambdaArrayIndex[1], 8, 15) |
      util_bitpack_uint(values->QPLambdaArrayIndex[2], 16, 23) |
      util_bitpack_uint(values->QPLambdaArrayIndex[3], 24, 31);

   dw[2] =
      util_bitpack_uint(values->QPLambdaArrayIndex[4], 0, 7) |
      util_bitpack_uint(values->QPLambdaArrayIndex[5], 8, 15) |
      util_bitpack_uint(values->QPLambdaArrayIndex[6], 16, 23) |
      util_bitpack_uint(values->QPLambdaArrayIndex[7], 24, 31);

   dw[3] =
      util_bitpack_uint(values->QPLambdaArrayIndex[8], 0, 7) |
      util_bitpack_uint(values->QPLambdaArrayIndex[9], 8, 15) |
      util_bitpack_uint(values->QPLambdaArrayIndex[10], 16, 23) |
      util_bitpack_uint(values->QPLambdaArrayIndex[11], 24, 31);

   dw[4] =
      util_bitpack_uint(values->QPLambdaArrayIndex[12], 0, 7) |
      util_bitpack_uint(values->QPLambdaArrayIndex[13], 8, 15) |
      util_bitpack_uint(values->QPLambdaArrayIndex[14], 16, 23) |
      util_bitpack_uint(values->QPLambdaArrayIndex[15], 24, 31);

   dw[5] =
      util_bitpack_uint(values->QPLambdaArrayIndex[16], 0, 7) |
      util_bitpack_uint(values->QPLambdaArrayIndex[17], 8, 15) |
      util_bitpack_uint(values->QPLambdaArrayIndex[18], 16, 23) |
      util_bitpack_uint(values->QPLambdaArrayIndex[19], 24, 31);

   dw[6] =
      util_bitpack_uint(values->QPLambdaArrayIndex[20], 0, 7) |
      util_bitpack_uint(values->QPLambdaArrayIndex[21], 8, 15) |
      util_bitpack_uint(values->QPLambdaArrayIndex[22], 16, 23) |
      util_bitpack_uint(values->QPLambdaArrayIndex[23], 24, 31);

   dw[7] =
      util_bitpack_uint(values->QPLambdaArrayIndex[24], 0, 7) |
      util_bitpack_uint(values->QPLambdaArrayIndex[25], 8, 15) |
      util_bitpack_uint(values->QPLambdaArrayIndex[26], 16, 23) |
      util_bitpack_uint(values->QPLambdaArrayIndex[27], 24, 31);

   dw[8] =
      util_bitpack_uint(values->QPLambdaArrayIndex[28], 0, 7) |
      util_bitpack_uint(values->QPLambdaArrayIndex[29], 8, 15) |
      util_bitpack_uint(values->QPLambdaArrayIndex[30], 16, 23) |
      util_bitpack_uint(values->QPLambdaArrayIndex[31], 24, 31);

   dw[9] =
      util_bitpack_uint(values->QPLambdaArrayIndex[32], 0, 7) |
      util_bitpack_uint(values->QPLambdaArrayIndex[33], 8, 15) |
      util_bitpack_uint(values->QPLambdaArrayIndex[34], 16, 23) |
      util_bitpack_uint(values->QPLambdaArrayIndex[35], 24, 31);

   dw[10] =
      util_bitpack_uint(values->QPLambdaArrayIndex[36], 0, 7) |
      util_bitpack_uint(values->QPLambdaArrayIndex[37], 8, 15) |
      util_bitpack_uint(values->QPLambdaArrayIndex[38], 16, 23) |
      util_bitpack_uint(values->QPLambdaArrayIndex[39], 24, 31);

   dw[11] =
      util_bitpack_uint(values->QPLambdaArrayIndex[40], 0, 7) |
      util_bitpack_uint(values->QPLambdaArrayIndex[41], 8, 15);

   dw[12] =
      util_bitpack_uint(values->SkipThresholdArrayIndex[0], 0, 15) |
      util_bitpack_uint(values->SkipThresholdArrayIndex[1], 16, 31);

   dw[13] =
      util_bitpack_uint(values->SkipThresholdArrayIndex[2], 0, 15) |
      util_bitpack_uint(values->SkipThresholdArrayIndex[3], 16, 31);

   dw[14] =
      util_bitpack_uint(values->SkipThresholdArrayIndex[4], 0, 15) |
      util_bitpack_uint(values->SkipThresholdArrayIndex[5], 16, 31);

   dw[15] =
      util_bitpack_uint(values->SkipThresholdArrayIndex[6], 0, 15) |
      util_bitpack_uint(values->SkipThresholdArrayIndex[7], 16, 31);

   dw[16] =
      util_bitpack_uint(values->SkipThresholdArrayIndex[8], 0, 15) |
      util_bitpack_uint(values->SkipThresholdArrayIndex[9], 16, 31);

   dw[17] =
      util_bitpack_uint(values->SkipThresholdArrayIndex[10], 0, 15) |
      util_bitpack_uint(values->SkipThresholdArrayIndex[11], 16, 31);

   dw[18] =
      util_bitpack_uint(values->SkipThresholdArrayIndex[12], 0, 15) |
      util_bitpack_uint(values->SkipThresholdArrayIndex[13], 16, 31);

   dw[19] =
      util_bitpack_uint(values->SkipThresholdArrayIndex[14], 0, 15) |
      util_bitpack_uint(values->SkipThresholdArrayIndex[15], 16, 31);

   dw[20] =
      util_bitpack_uint(values->SkipThresholdArrayIndex[16], 0, 15) |
      util_bitpack_uint(values->SkipThresholdArrayIndex[17], 16, 31);

   dw[21] =
      util_bitpack_uint(values->SkipThresholdArrayIndex[18], 0, 15) |
      util_bitpack_uint(values->SkipThresholdArrayIndex[19], 16, 31);

   dw[22] =
      util_bitpack_uint(values->SkipThresholdArrayIndex[20], 0, 15) |
      util_bitpack_uint(values->SkipThresholdArrayIndex[21], 16, 31);

   dw[23] =
      util_bitpack_uint(values->SkipThresholdArrayIndex[22], 0, 15) |
      util_bitpack_uint(values->SkipThresholdArrayIndex[23], 16, 31);

   dw[24] =
      util_bitpack_uint(values->SkipThresholdArrayIndex[24], 0, 15) |
      util_bitpack_uint(values->SkipThresholdArrayIndex[25], 16, 31);

   dw[25] =
      util_bitpack_uint(values->SkipThresholdArrayIndex[26], 0, 15);

   dw[26] =
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix0ArrayIndex[0], 0, 15) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix0ArrayIndex[1], 16, 31);

   dw[27] =
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix0ArrayIndex[2], 0, 15) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix0ArrayIndex[3], 16, 31);

   dw[28] =
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix0ArrayIndex[4], 0, 15) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix0ArrayIndex[5], 16, 31);

   dw[29] =
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix0ArrayIndex[6], 0, 15) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix0ArrayIndex[7], 16, 31);

   dw[30] =
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix0ArrayIndex[8], 0, 15) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix0ArrayIndex[9], 16, 31);

   dw[31] =
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix0ArrayIndex[10], 0, 15) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix0ArrayIndex[11], 16, 31);

   dw[32] =
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix0ArrayIndex[12], 0, 15) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix0ArrayIndex[13], 16, 31);

   dw[33] =
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix0ArrayIndex[14], 0, 15) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix0ArrayIndex[15], 16, 31);

   dw[34] =
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix0ArrayIndex[16], 0, 15) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix0ArrayIndex[17], 16, 31);

   dw[35] =
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix0ArrayIndex[18], 0, 15) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix0ArrayIndex[19], 16, 31);

   dw[36] =
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix0ArrayIndex[20], 0, 15) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix0ArrayIndex[21], 16, 31);

   dw[37] =
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix0ArrayIndex[22], 0, 15) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix0ArrayIndex[23], 16, 31);

   dw[38] =
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix0ArrayIndex[24], 0, 15) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix0ArrayIndex[25], 16, 31);

   dw[39] =
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix0ArrayIndex[26], 0, 15);

   dw[40] =
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix135ArrayIndex[0], 0, 7) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix135ArrayIndex[1], 8, 15) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix135ArrayIndex[2], 16, 23) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix135ArrayIndex[3], 24, 31);

   dw[41] =
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix135ArrayIndex[4], 0, 7) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix135ArrayIndex[5], 8, 15) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix135ArrayIndex[6], 16, 23) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix135ArrayIndex[7], 24, 31);

   dw[42] =
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix135ArrayIndex[8], 0, 7) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix135ArrayIndex[9], 8, 15) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix135ArrayIndex[10], 16, 23) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix135ArrayIndex[11], 24, 31);

   dw[43] =
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix135ArrayIndex[12], 0, 7) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix135ArrayIndex[13], 8, 15) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix135ArrayIndex[14], 16, 23) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix135ArrayIndex[15], 24, 31);

   dw[44] =
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix135ArrayIndex[16], 0, 7) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix135ArrayIndex[17], 8, 15) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix135ArrayIndex[18], 16, 23) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix135ArrayIndex[19], 24, 31);

   dw[45] =
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix135ArrayIndex[20], 0, 7) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix135ArrayIndex[21], 8, 15) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix135ArrayIndex[22], 16, 23) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix135ArrayIndex[23], 24, 31);

   dw[46] =
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix135ArrayIndex[24], 0, 7) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix135ArrayIndex[25], 8, 15) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix135ArrayIndex[26], 16, 23);

   dw[47] =
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix2ArrayIndex[0], 0, 7) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix2ArrayIndex[1], 8, 15) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix2ArrayIndex[2], 16, 23) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix2ArrayIndex[3], 24, 31);

   dw[48] =
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix2ArrayIndex[4], 0, 7) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix2ArrayIndex[5], 8, 15) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix2ArrayIndex[6], 16, 23) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix2ArrayIndex[7], 24, 31);

   dw[49] =
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix2ArrayIndex[8], 0, 7) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix2ArrayIndex[9], 8, 15) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix2ArrayIndex[10], 16, 23) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix2ArrayIndex[11], 24, 31);

   dw[50] =
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix2ArrayIndex[12], 0, 7) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix2ArrayIndex[13], 8, 15) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix2ArrayIndex[14], 16, 23) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix2ArrayIndex[15], 24, 31);

   dw[51] =
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix2ArrayIndex[16], 0, 7) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix2ArrayIndex[17], 8, 15) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix2ArrayIndex[18], 16, 23) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix2ArrayIndex[19], 24, 31);

   dw[52] =
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix2ArrayIndex[20], 0, 7) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix2ArrayIndex[21], 8, 15) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix2ArrayIndex[22], 16, 23) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix2ArrayIndex[23], 24, 31);

   dw[53] =
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix2ArrayIndex[24], 0, 7) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix2ArrayIndex[25], 8, 15) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix2ArrayIndex[26], 16, 23);

   dw[54] =
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix46ArrayIndex[0], 0, 7) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix46ArrayIndex[1], 8, 15) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix46ArrayIndex[2], 16, 23) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix46ArrayIndex[3], 24, 31);

   dw[55] =
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix46ArrayIndex[4], 0, 7) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix46ArrayIndex[5], 8, 15) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix46ArrayIndex[6], 16, 23) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix46ArrayIndex[7], 24, 31);

   dw[56] =
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix46ArrayIndex[8], 0, 7) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix46ArrayIndex[9], 8, 15) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix46ArrayIndex[10], 16, 23) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix46ArrayIndex[11], 24, 31);

   dw[57] =
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix46ArrayIndex[12], 0, 7) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix46ArrayIndex[13], 8, 15) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix46ArrayIndex[14], 16, 23) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix46ArrayIndex[15], 24, 31);

   dw[58] =
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix46ArrayIndex[16], 0, 7) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix46ArrayIndex[17], 8, 15) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix46ArrayIndex[18], 16, 23) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix46ArrayIndex[19], 24, 31);

   dw[59] =
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix46ArrayIndex[20], 0, 7) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix46ArrayIndex[21], 8, 15) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix46ArrayIndex[22], 16, 23) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix46ArrayIndex[23], 24, 31);

   dw[60] =
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix46ArrayIndex[24], 0, 7) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix46ArrayIndex[25], 8, 15) |
      util_bitpack_uint(values->SICForwardTransformCoeffThresholdMatrix46ArrayIndex[26], 16, 23);
}

#define GFX20_VDENC_CONTROL_STATE_length       2
#define GFX20_VDENC_CONTROL_STATE_length_bias      2
#define GFX20_VDENC_CONTROL_STATE_header        \
   .DWordLength                         =      0,  \
   .SubOpcode                           =     11,  \
   .MediaCommandOpCode                  =      1,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_VDENC_CONTROL_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcode;
   uint32_t                             MediaCommandOpCode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   bool                                 VdencInitialization;
};

static inline __attribute__((always_inline)) void
GFX20_VDENC_CONTROL_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                               __attribute__((unused)) void * restrict dst,
                               __attribute__((unused)) const struct GFX20_VDENC_CONTROL_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcode, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpCode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->VdencInitialization, 1, 1);
}

#define GFX20_VDENC_DS_REF_SURFACE_STATE_length     10
#define GFX20_VDENC_DS_REF_SURFACE_STATE_length_bias      2
#define GFX20_VDENC_DS_REF_SURFACE_STATE_header \
   .DWordLength                         =      8,  \
   .SubOpcodeB                          =      3,  \
   .SubOpcodeA                          =      0,  \
   .MediaCommandOpcode                  =      1,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_VDENC_DS_REF_SURFACE_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   struct GFX20_VDENC_SURFACE_STATE_FIELDS _8XSurfaceState;
   struct GFX20_VDENC_SURFACE_STATE_FIELDS _4XSurfaceState;
};

static inline __attribute__((always_inline)) void
GFX20_VDENC_DS_REF_SURFACE_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                                      __attribute__((unused)) void * restrict dst,
                                      __attribute__((unused)) const struct GFX20_VDENC_DS_REF_SURFACE_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] = 0;

   GFX20_VDENC_SURFACE_STATE_FIELDS_pack(data, &dw[2], &values->_8XSurfaceState);

   GFX20_VDENC_SURFACE_STATE_FIELDS_pack(data, &dw[6], &values->_4XSurfaceState);
}

#define GFX20_VDENC_IMG_STATE_length          35
#define GFX20_VDENC_IMG_STATE_length_bias      2
#define GFX20_VDENC_IMG_STATE_header            \
   .DWordLength                         =     33,  \
   .SubOpcodeB                          =      5,  \
   .SubOpcodeA                          =      0,  \
   .MediaCommandOpcode                  =      1,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_VDENC_IMG_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   bool                                 BidirectionalMixDisable;
   uint32_t                             VDENCPerfMode;
#define Speed                                    1
   bool                                 TimeBudgetOverflowCheck;
   bool                                 VDEncExtendedPAK_OBJ_CMDEnable;
   bool                                 Transform8x8;
   uint32_t                             VDEncL1CachePriority;
   uint32_t                             LambdaValueforTrellis;
   uint32_t                             BidirectionalWeight;
   bool                                 UnidirectionalMixDisable;
   uint32_t                             PictureWidth;
   uint32_t                             SubPelMode;
   bool                                 ForwardTransformSkipCheckEnable;
   bool                                 BmeDisableForFbrMessage;
   bool                                 BlockBasedSkipEnable;
   uint32_t                             InterSADMeasureAdjustment;
#define ISMA_None                                0
#define ISMA_HaarTransformAdjusted               2
   uint32_t                             IntraSADMeasureAdjustment;
#define ISMA_None                                0
#define ISMA_HaarTransformAdjusted               2
   uint32_t                             SubMBSubPartitionMask;
   uint32_t                             BlockBasedSkipType;
   uint32_t                             PictureHeight;
   bool                                 CREPrefetchEnable;
   bool                                 HMERef1Disable;
   uint32_t                             MBSliceThresholdValue;
   bool                                 ConstrainedIntraPrediction;
   uint32_t                             PictureType;
#define PI_I                                     0
#define PI_P                                     1
   uint32_t                             SliceMBHeight;
   int32_t                              HME0XOffset;
   int32_t                              HME0YOffset;
   int32_t                              HME1XOffset;
   int32_t                              HME1YOffset;
   uint32_t                             LumaIntraPartitionMask;
   uint32_t                             NonSkipZeroMVCostAdded;
   uint32_t                             NonSkipMBModeCostAdded;
   uint32_t                             MVCostScalingFactor;
#define Qpel                                     0
#define Hpel                                     1
#define Pel                                      2
#define _2pel                                    3
   bool                                 BiLinearFilterEnable;
   uint32_t                             RefIDCostModeSelect;
   uint32_t                             Mode0Cost;
   uint32_t                             Mode1Cost;
   uint32_t                             Mode2Cost;
   uint32_t                             Mode3Cost;
   uint32_t                             Mode4Cost;
   uint32_t                             Mode5Cost;
   uint32_t                             Mode6Cost;
   uint32_t                             Mode7Cost;
   uint32_t                             Mode8Cost;
   uint32_t                             Mode9Cost;
   uint32_t                             RefIDCost;
   uint32_t                             ChromaIntraModeCost;
   struct GFX20_IMAGE_STATE_COST        MVCost;
   int32_t                              QpPrimeY;
   uint32_t                             TargetSizeInWord;
   uint32_t                             AVCIntra4x4ModeMask;
   uint32_t                             AVCIntra8x8ModeMask;
   uint32_t                             AVCIntra16x16ModeMask;
   uint32_t                             AVCIntraChromaModeMask;
   uint32_t                             IntraComputeType;
   uint32_t                             PenaltyforIntra16x16NonDCPrediction;
   uint32_t                             PenaltyforIntra8x8NonDCPrediction;
   uint32_t                             PenaltyforIntra4x4NonDCPrediction;
   uint32_t                             IntraRefreshMBPosition;
   uint32_t                             IntraRefreshMBSize;
   bool                                 IntraRefreshEnableRollingIEnable;
   uint32_t                             IntraRefreshMode;
#define RowBased                                 0
#define ColumnBased                              1
   int32_t                              QPAdjustmentforRollingI;
   uint32_t                             PanicModeMBThreshold;
   uint32_t                             SmallMbSizeInWord;
   uint32_t                             LargeMbSizeInWord;
   int32_t                              L0NumberofReferences;
   int32_t                              L1NumberofReferences;
   uint32_t                             MacroblockBudget;
   uint32_t                             InitialTime;
   uint32_t                             HMERefWindowsCombiningThreshold;
   uint32_t                             MaxHorizontalMVRange;
   uint32_t                             MaxVerticalMVRange;
   struct GFX20_IMAGE_STATE_COST        HMEMVCost;
   int32_t                              ROIQPAdjustmentforZone0;
   int32_t                              ROIQPAdjustmentforZone1;
   int32_t                              ROIQPAdjustmentforZone2;
   int32_t                              ROIQPAdjustmentforZone3;
   int32_t                              QPAdjustmentforShapeBestIntra4x4Winner;
   int32_t                              QPAdjustmentforShapeBestIntra8x8Winner;
   int32_t                              QPAdjustmentforShapeBestIntra16x16Winner;
   int32_t                              BestDistortionQPAdjustmentforZone0;
   int32_t                              BestDistortionQPAdjustmentforZone1;
   int32_t                              BestDistortionQPAdjustmentforZone2;
   int32_t                              BestDistortionQPAdjustmentforZone3;
   uint32_t                             SadHaarThreshold0;
   uint32_t                             SadHaarThreshold1;
   uint32_t                             SadHaarThreshold2;
   uint32_t                             MaxQP;
   uint32_t                             MinQP;
   uint32_t                             MaxDeltaQP;
   bool                                 ROIEnable;
   bool                                 FwdPredictor0MVEnable;
   bool                                 BwdPredictor1MVEnable;
   bool                                 MBLevelQPEnable;
   bool                                 TargetSizeinWordsMBMaxSizeinWordsMBEnable;
   bool                                 PPMVDisable;
   bool                                 CoefficientClampEnable;
   bool                                 LongTermReferenceFrameBwdRef0Indicator;
   bool                                 LongTermReferenceFrameFwdRef2Indicator;
   bool                                 LongTermReferenceFrameFwdRef1Indicator;
   bool                                 LongTermReferenceFrameFwdRef0Indicator;
   uint32_t                             MidpointSadHaar;
};

static inline __attribute__((always_inline)) void
GFX20_VDENC_IMG_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                           __attribute__((unused)) void * restrict dst,
                           __attribute__((unused)) const struct GFX20_VDENC_IMG_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->BidirectionalMixDisable, 2, 2) |
      util_bitpack_uint(values->VDENCPerfMode, 3, 3) |
      util_bitpack_uint(values->TimeBudgetOverflowCheck, 4, 4) |
      util_bitpack_uint(values->VDEncExtendedPAK_OBJ_CMDEnable, 6, 6) |
      util_bitpack_uint(values->Transform8x8, 7, 7) |
      util_bitpack_uint(values->VDEncL1CachePriority, 8, 9) |
      util_bitpack_uint(values->LambdaValueforTrellis, 16, 31);

   dw[2] =
      util_bitpack_uint(values->BidirectionalWeight, 16, 21) |
      util_bitpack_uint(values->UnidirectionalMixDisable, 28, 28);

   dw[3] =
      util_bitpack_uint(values->PictureWidth, 16, 31);

   dw[4] =
      util_bitpack_uint(values->SubPelMode, 12, 13) |
      util_bitpack_uint(values->ForwardTransformSkipCheckEnable, 17, 17) |
      util_bitpack_uint(values->BmeDisableForFbrMessage, 18, 18) |
      util_bitpack_uint(values->BlockBasedSkipEnable, 19, 19) |
      util_bitpack_uint(values->InterSADMeasureAdjustment, 20, 21) |
      util_bitpack_uint(values->IntraSADMeasureAdjustment, 22, 23) |
      util_bitpack_uint(values->SubMBSubPartitionMask, 24, 30) |
      util_bitpack_uint(values->BlockBasedSkipType, 31, 31);

   dw[5] =
      util_bitpack_uint(values->PictureHeight, 0, 15) |
      util_bitpack_uint(values->CREPrefetchEnable, 16, 16) |
      util_bitpack_uint(values->HMERef1Disable, 17, 17) |
      util_bitpack_uint(values->MBSliceThresholdValue, 18, 21) |
      util_bitpack_uint(values->ConstrainedIntraPrediction, 26, 26) |
      util_bitpack_uint(values->PictureType, 29, 30);

   dw[6] =
      util_bitpack_uint(values->SliceMBHeight, 0, 15);

   dw[7] =
      util_bitpack_sint(values->HME0XOffset, 0, 7) |
      util_bitpack_sint(values->HME0YOffset, 8, 15) |
      util_bitpack_sint(values->HME1XOffset, 16, 23) |
      util_bitpack_sint(values->HME1YOffset, 24, 31);

   dw[8] =
      util_bitpack_uint(values->LumaIntraPartitionMask, 0, 4) |
      util_bitpack_uint(values->NonSkipZeroMVCostAdded, 5, 5) |
      util_bitpack_uint(values->NonSkipMBModeCostAdded, 6, 6) |
      util_bitpack_uint(values->MVCostScalingFactor, 16, 17) |
      util_bitpack_uint(values->BiLinearFilterEnable, 18, 18) |
      util_bitpack_uint(values->RefIDCostModeSelect, 22, 22);

   dw[9] =
      util_bitpack_uint(values->Mode0Cost, 0, 7) |
      util_bitpack_uint(values->Mode1Cost, 8, 15) |
      util_bitpack_uint(values->Mode2Cost, 16, 23) |
      util_bitpack_uint(values->Mode3Cost, 24, 31);

   dw[10] =
      util_bitpack_uint(values->Mode4Cost, 0, 7) |
      util_bitpack_uint(values->Mode5Cost, 8, 15) |
      util_bitpack_uint(values->Mode6Cost, 16, 23) |
      util_bitpack_uint(values->Mode7Cost, 24, 31);

   dw[11] =
      util_bitpack_uint(values->Mode8Cost, 0, 7) |
      util_bitpack_uint(values->Mode9Cost, 8, 15) |
      util_bitpack_uint(values->RefIDCost, 16, 23) |
      util_bitpack_uint(values->ChromaIntraModeCost, 24, 31);

   GFX20_IMAGE_STATE_COST_pack(data, &dw[12], &values->MVCost);

   dw[14] =
      util_bitpack_sint(values->QpPrimeY, 0, 7) |
      util_bitpack_uint(values->TargetSizeInWord, 24, 31);

   dw[15] = 0;

   dw[16] = 0;

   dw[17] =
      util_bitpack_uint(values->AVCIntra4x4ModeMask, 0, 8) |
      util_bitpack_uint(values->AVCIntra8x8ModeMask, 16, 24);

   dw[18] =
      util_bitpack_uint(values->AVCIntra16x16ModeMask, 0, 3) |
      util_bitpack_uint(values->AVCIntraChromaModeMask, 4, 7) |
      util_bitpack_uint(values->IntraComputeType, 8, 9);

   dw[19] = 0;

   dw[20] =
      util_bitpack_uint(values->PenaltyforIntra16x16NonDCPrediction, 0, 7) |
      util_bitpack_uint(values->PenaltyforIntra8x8NonDCPrediction, 8, 15) |
      util_bitpack_uint(values->PenaltyforIntra4x4NonDCPrediction, 16, 23);

   dw[21] =
      util_bitpack_uint(values->IntraRefreshMBPosition, 0, 7) |
      util_bitpack_uint(values->IntraRefreshMBSize, 8, 15) |
      util_bitpack_uint(values->IntraRefreshEnableRollingIEnable, 16, 16) |
      util_bitpack_uint(values->IntraRefreshMode, 17, 17) |
      util_bitpack_sint(values->QPAdjustmentforRollingI, 24, 31);

   dw[22] =
      util_bitpack_uint(values->PanicModeMBThreshold, 0, 15) |
      util_bitpack_uint(values->SmallMbSizeInWord, 16, 23) |
      util_bitpack_uint(values->LargeMbSizeInWord, 24, 31);

   dw[23] =
      util_bitpack_sint(values->L0NumberofReferences, 0, 7) |
      util_bitpack_sint(values->L1NumberofReferences, 16, 23);

   dw[24] =
      util_bitpack_uint(values->MacroblockBudget, 0, 15) |
      util_bitpack_uint(values->InitialTime, 16, 31);

   dw[25] = 0;

   dw[26] =
      util_bitpack_uint(values->HMERefWindowsCombiningThreshold, 8, 15);

   dw[27] =
      util_bitpack_uint(values->MaxHorizontalMVRange, 0, 15) |
      util_bitpack_uint(values->MaxVerticalMVRange, 16, 31);

   GFX20_IMAGE_STATE_COST_pack(data, &dw[28], &values->HMEMVCost);

   dw[30] =
      util_bitpack_sint(values->ROIQPAdjustmentforZone0, 0, 3) |
      util_bitpack_sint(values->ROIQPAdjustmentforZone1, 4, 7) |
      util_bitpack_sint(values->ROIQPAdjustmentforZone2, 8, 11) |
      util_bitpack_sint(values->ROIQPAdjustmentforZone3, 12, 15) |
      util_bitpack_sint(values->QPAdjustmentforShapeBestIntra4x4Winner, 16, 19) |
      util_bitpack_sint(values->QPAdjustmentforShapeBestIntra8x8Winner, 20, 23) |
      util_bitpack_sint(values->QPAdjustmentforShapeBestIntra16x16Winner, 24, 27);

   dw[31] =
      util_bitpack_sint(values->BestDistortionQPAdjustmentforZone0, 0, 3) |
      util_bitpack_sint(values->BestDistortionQPAdjustmentforZone1, 4, 7) |
      util_bitpack_sint(values->BestDistortionQPAdjustmentforZone2, 8, 11) |
      util_bitpack_sint(values->BestDistortionQPAdjustmentforZone3, 12, 15) |
      util_bitpack_uint(values->SadHaarThreshold0, 16, 31);

   dw[32] =
      util_bitpack_uint(values->SadHaarThreshold1, 0, 15) |
      util_bitpack_uint(values->SadHaarThreshold2, 16, 31);

   dw[33] =
      util_bitpack_uint(values->MaxQP, 0, 7) |
      util_bitpack_uint(values->MinQP, 8, 15) |
      util_bitpack_uint(values->MaxDeltaQP, 24, 27);

   dw[34] =
      util_bitpack_uint(values->ROIEnable, 0, 0) |
      util_bitpack_uint(values->FwdPredictor0MVEnable, 1, 1) |
      util_bitpack_uint(values->BwdPredictor1MVEnable, 2, 2) |
      util_bitpack_uint(values->MBLevelQPEnable, 3, 3) |
      util_bitpack_uint(values->TargetSizeinWordsMBMaxSizeinWordsMBEnable, 4, 4) |
      util_bitpack_uint(values->PPMVDisable, 8, 8) |
      util_bitpack_uint(values->CoefficientClampEnable, 9, 9) |
      util_bitpack_uint(values->LongTermReferenceFrameBwdRef0Indicator, 10, 10) |
      util_bitpack_uint(values->LongTermReferenceFrameFwdRef2Indicator, 11, 11) |
      util_bitpack_uint(values->LongTermReferenceFrameFwdRef1Indicator, 12, 12) |
      util_bitpack_uint(values->LongTermReferenceFrameFwdRef0Indicator, 13, 13) |
      util_bitpack_uint(values->MidpointSadHaar, 16, 31);
}

#define GFX20_VDENC_PIPE_BUF_ADDR_STATE_length     71
#define GFX20_VDENC_PIPE_BUF_ADDR_STATE_length_bias      2
#define GFX20_VDENC_PIPE_BUF_ADDR_STATE_header  \
   .DWordLength                         =     69,  \
   .SubOpcodeB                          =      4,  \
   .SubOpcodeA                          =      0,  \
   .MediaCommandOpcode                  =      1,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_VDENC_PIPE_BUF_ADDR_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   struct GFX20_VDENC_PICTURE           DSFWDREF0;
   struct GFX20_VDENC_PICTURE           DSFWDREF1;
   struct GFX20_VDENC_PICTURE           OriginalUncompressedPicture;
   struct GFX20_VDENC_PICTURE           StreamInDataPicture;
   struct GFX20_VDENC_PICTURE           RowStoreScratchBuffer;
   struct GFX20_VDENC_PICTURE           ColocatedMVReadBuffer;
   struct GFX20_VDENC_PICTURE           FWDREF0;
   struct GFX20_VDENC_PICTURE           FWDREF1;
   struct GFX20_VDENC_PICTURE           FWDREF2;
   struct GFX20_VDENC_PICTURE           BWDREF0;
   struct GFX20_VDENC_PICTURE           VDEncStatisticsStreamOut;
   struct GFX20_VDENC_PICTURE           DSFWDREF04X;
   struct GFX20_VDENC_PICTURE           DSFWDREF14X;
   struct GFX20_VDENC_PICTURE           VDEncCURecordStreamOutBuffer;
   struct GFX20_VDENC_PICTURE           VDEncLCUPAK_OBJ_CMDBuffer;
   struct GFX20_VDENC_PICTURE           ScaledReferenceSurface8X;
   struct GFX20_VDENC_PICTURE           ScaledReferenceSurface4X;
   struct GFX20_VDENC_PICTURE           VP9SegmentationMapStreamInBuffer;
   struct GFX20_VDENC_PICTURE           VP9SegmentationMapStreamOutBuffer;
   uint64_t                             WeightsHistogramStreamOutOffset;
   struct GFX20_VDENC_PICTURE           VDEncTileRowStoreBuffer;
   struct GFX20_VDENC_PICTURE           VDEncCumulativeCUCountStreamOutSurface;
   struct GFX20_VDENC_PICTURE           VDEncPaletteModeStreamOutSurface;
};

static inline __attribute__((always_inline)) void
GFX20_VDENC_PIPE_BUF_ADDR_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                                     __attribute__((unused)) void * restrict dst,
                                     __attribute__((unused)) const struct GFX20_VDENC_PIPE_BUF_ADDR_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   GFX20_VDENC_PICTURE_pack(data, &dw[1], &values->DSFWDREF0);

   GFX20_VDENC_PICTURE_pack(data, &dw[4], &values->DSFWDREF1);

   dw[7] = 0;

   dw[8] = 0;

   dw[9] = 0;

   GFX20_VDENC_PICTURE_pack(data, &dw[10], &values->OriginalUncompressedPicture);

   GFX20_VDENC_PICTURE_pack(data, &dw[13], &values->StreamInDataPicture);

   GFX20_VDENC_PICTURE_pack(data, &dw[16], &values->RowStoreScratchBuffer);

   GFX20_VDENC_PICTURE_pack(data, &dw[19], &values->ColocatedMVReadBuffer);

   GFX20_VDENC_PICTURE_pack(data, &dw[22], &values->FWDREF0);

   GFX20_VDENC_PICTURE_pack(data, &dw[25], &values->FWDREF1);

   GFX20_VDENC_PICTURE_pack(data, &dw[28], &values->FWDREF2);

   GFX20_VDENC_PICTURE_pack(data, &dw[31], &values->BWDREF0);

   GFX20_VDENC_PICTURE_pack(data, &dw[34], &values->VDEncStatisticsStreamOut);

   GFX20_VDENC_PICTURE_pack(data, &dw[37], &values->DSFWDREF04X);

   GFX20_VDENC_PICTURE_pack(data, &dw[40], &values->DSFWDREF14X);

   dw[43] = 0;

   dw[44] = 0;

   dw[45] = 0;

   GFX20_VDENC_PICTURE_pack(data, &dw[46], &values->VDEncCURecordStreamOutBuffer);

   GFX20_VDENC_PICTURE_pack(data, &dw[49], &values->VDEncLCUPAK_OBJ_CMDBuffer);

   GFX20_VDENC_PICTURE_pack(data, &dw[52], &values->ScaledReferenceSurface8X);

   GFX20_VDENC_PICTURE_pack(data, &dw[55], &values->ScaledReferenceSurface4X);

   GFX20_VDENC_PICTURE_pack(data, &dw[58], &values->VP9SegmentationMapStreamInBuffer);

   GFX20_VDENC_PICTURE_pack(data, &dw[61], &values->VP9SegmentationMapStreamOutBuffer);

   const uint64_t v62 =
      util_bitpack_uint(values->WeightsHistogramStreamOutOffset, 0, 95);
   dw[62] = v62;
   dw[63] = v62 >> 32;

   GFX20_VDENC_PICTURE_pack(data, &dw[65], &values->VDEncTileRowStoreBuffer);

   GFX20_VDENC_PICTURE_pack(data, &dw[68], &values->VDEncCumulativeCUCountStreamOutSurface);
}

#define GFX20_VDENC_PIPE_MODE_SELECT_length      6
#define GFX20_VDENC_PIPE_MODE_SELECT_length_bias      2
#define GFX20_VDENC_PIPE_MODE_SELECT_header     \
   .DWordLength                         =      4,  \
   .SubOpcodeB                          =      0,  \
   .SubOpcodeA                          =      0,  \
   .MediaCommandOpcode                  =      1,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3,  \
   .PrimaryChannelSelectionForRGBEncoding =      1,  \
   .FirstSecondaryChannelSelectionForRGBEncoding =      2,  \
   .HMERegionPrefetchEnable             =      1,  \
   .TopPrefetchEnableMode               =      1,  \
   .LeftPrefetchAtWrapAround            =      1,  \
   .HzShift32Minus1                     =      3,  \
   .NumberofVerticalRequests            =     11,  \
   .NumberofHorizontalRequests          =      2,  \
   .SourceLumaPackedDataTLBPrefetchEnable =      1,  \
   .SourceChromaTLBPrefetchEnable       =      1,  \
   .HzShift32Minus1Src                  =      3,  \
   .PrefetchOffsetforSource             =      4

struct GFX20_VDENC_PIPE_MODE_SELECT {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             StandardSelect;
#define SS_HEVC                                  0
#define SS_VP9                                   1
#define SS_AVC                                   2
   bool                                 ScalabilityMode;
   bool                                 FrameStatisticsStreamOutEnable;
   bool                                 VDEncPAK_OBJ_CMDStreamOutEnable;
   bool                                 TLBPrefetchEnable;
   bool                                 PAKThresholdCheckEnable;
   bool                                 VDEncStreamInEnable;
   bool                                 DownScaled8xWriteDisable;
   bool                                 DownScaled4xWriteDisable;
   uint32_t                             BitDepth;
#define _8bit                                    0
#define _10bit                                   2
   uint32_t                             PAKChromaSubSamplingType;
#define _420                                     1
#define _444                                     3
   bool                                 OutputRangeControlAfterColorSpaceConversion;
   bool                                 IsRandomAccess;
   bool                                 RGBEncodingEnable;
   uint32_t                             PrimaryChannelSelectionForRGBEncoding;
   uint32_t                             FirstSecondaryChannelSelectionForRGBEncoding;
   bool                                 TileReplayEnable;
   uint32_t                             StreamingBufferConfig;
   bool                                 DisableSpeedModeFetchOptimization;
   bool                                 HMERegionPrefetchEnable;
   uint32_t                             TopPrefetchEnableMode;
   bool                                 LeftPrefetchAtWrapAround;
   uint32_t                             VerticalShift32Minus1;
   uint32_t                             HzShift32Minus1;
   uint32_t                             NumberofVerticalRequests;
   uint32_t                             NumberofHorizontalRequests;
   uint32_t                             PrefetchOffsetforReference;
   bool                                 SourceLumaPackedDataTLBPrefetchEnable;
   bool                                 SourceChromaTLBPrefetchEnable;
   uint32_t                             VerticalShift32Minus1Src;
   uint32_t                             HzShift32Minus1Src;
   uint32_t                             NumberofVerticalRequestsforSource;
   uint32_t                             NumberofHorizontalRequestforSource;
   uint32_t                             PrefetchOffsetforSource;
};

static inline __attribute__((always_inline)) void
GFX20_VDENC_PIPE_MODE_SELECT_pack(__attribute__((unused)) __gen_user_data *data,
                                  __attribute__((unused)) void * restrict dst,
                                  __attribute__((unused)) const struct GFX20_VDENC_PIPE_MODE_SELECT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->StandardSelect, 0, 3) |
      util_bitpack_uint(values->ScalabilityMode, 4, 4) |
      util_bitpack_uint(values->FrameStatisticsStreamOutEnable, 5, 5) |
      util_bitpack_uint(values->VDEncPAK_OBJ_CMDStreamOutEnable, 6, 6) |
      util_bitpack_uint(values->TLBPrefetchEnable, 7, 7) |
      util_bitpack_uint(values->PAKThresholdCheckEnable, 8, 8) |
      util_bitpack_uint(values->VDEncStreamInEnable, 9, 9) |
      util_bitpack_uint(values->DownScaled8xWriteDisable, 10, 10) |
      util_bitpack_uint(values->DownScaled4xWriteDisable, 11, 11) |
      util_bitpack_uint(values->BitDepth, 12, 14) |
      util_bitpack_uint(values->PAKChromaSubSamplingType, 15, 16) |
      util_bitpack_uint(values->OutputRangeControlAfterColorSpaceConversion, 17, 17) |
      util_bitpack_uint(values->IsRandomAccess, 18, 18) |
      util_bitpack_uint(values->RGBEncodingEnable, 20, 20) |
      util_bitpack_uint(values->PrimaryChannelSelectionForRGBEncoding, 21, 22) |
      util_bitpack_uint(values->FirstSecondaryChannelSelectionForRGBEncoding, 23, 24) |
      util_bitpack_uint(values->TileReplayEnable, 25, 25) |
      util_bitpack_uint(values->StreamingBufferConfig, 26, 27) |
      util_bitpack_uint(values->DisableSpeedModeFetchOptimization, 31, 31);

   dw[2] =
      util_bitpack_uint(values->HMERegionPrefetchEnable, 0, 0) |
      util_bitpack_uint(values->TopPrefetchEnableMode, 1, 2) |
      util_bitpack_uint(values->LeftPrefetchAtWrapAround, 3, 3) |
      util_bitpack_uint(values->VerticalShift32Minus1, 4, 7) |
      util_bitpack_uint(values->HzShift32Minus1, 8, 11) |
      util_bitpack_uint(values->NumberofVerticalRequests, 16, 19) |
      util_bitpack_uint(values->NumberofHorizontalRequests, 20, 23) |
      util_bitpack_uint(values->PrefetchOffsetforReference, 24, 27);

   dw[3] =
      util_bitpack_uint(values->SourceLumaPackedDataTLBPrefetchEnable, 0, 0) |
      util_bitpack_uint(values->SourceChromaTLBPrefetchEnable, 1, 1) |
      util_bitpack_uint(values->VerticalShift32Minus1Src, 4, 7) |
      util_bitpack_uint(values->HzShift32Minus1Src, 8, 11) |
      util_bitpack_uint(values->NumberofVerticalRequestsforSource, 16, 19) |
      util_bitpack_uint(values->NumberofHorizontalRequestforSource, 20, 23) |
      util_bitpack_uint(values->PrefetchOffsetforSource, 24, 27);

   dw[4] = 0;

   dw[5] = 0;
}

#define GFX20_VDENC_REF_SURFACE_STATE_length      6
#define GFX20_VDENC_REF_SURFACE_STATE_length_bias      2
#define GFX20_VDENC_REF_SURFACE_STATE_header    \
   .DWordLength                         =      4,  \
   .SubOpcodeB                          =      2,  \
   .SubOpcodeA                          =      0,  \
   .MediaCommandOpcode                  =      1,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_VDENC_REF_SURFACE_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   struct GFX20_VDENC_SURFACE_STATE_FIELDS SurfaceState;
};

static inline __attribute__((always_inline)) void
GFX20_VDENC_REF_SURFACE_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                                   __attribute__((unused)) void * restrict dst,
                                   __attribute__((unused)) const struct GFX20_VDENC_REF_SURFACE_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] = 0;

   GFX20_VDENC_SURFACE_STATE_FIELDS_pack(data, &dw[2], &values->SurfaceState);
}

#define GFX20_VDENC_SRC_SURFACE_STATE_length      6
#define GFX20_VDENC_SRC_SURFACE_STATE_length_bias      2
#define GFX20_VDENC_SRC_SURFACE_STATE_header    \
   .DWordLength                         =      4,  \
   .SubOpcodeB                          =      1,  \
   .SubOpcodeA                          =      0,  \
   .MediaCommandOpcode                  =      1,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_VDENC_SRC_SURFACE_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   struct GFX20_VDENC_SURFACE_STATE_FIELDS SurfaceState;
};

static inline __attribute__((always_inline)) void
GFX20_VDENC_SRC_SURFACE_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                                   __attribute__((unused)) void * restrict dst,
                                   __attribute__((unused)) const struct GFX20_VDENC_SRC_SURFACE_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] = 0;

   GFX20_VDENC_SURFACE_STATE_FIELDS_pack(data, &dw[2], &values->SurfaceState);
}

#define GFX20_VDENC_WALKER_STATE_length       27
#define GFX20_VDENC_WALKER_STATE_length_bias      2
#define GFX20_VDENC_WALKER_STATE_header         \
   .DWordLength                         =     25,  \
   .SubOpcodeB                          =      7,  \
   .SubOpcodeA                          =      0,  \
   .MediaCommandOpcode                  =      1,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_VDENC_WALKER_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   uint32_t                             MBLCUStartYPosition;
   uint32_t                             MBLCUStartXPosition;
   bool                                 FirstSuperSlice;
   uint32_t                             NextSliceMBStartYPosition;
   uint32_t                             NextSliceMBLCUStartXPosition;
   uint32_t                             Log2WeightDenominatorLuma;
   uint32_t                             HEVCVP9Log2WeightDenominatorLuma;
   uint32_t                             NumberofParallelEngines;
   uint32_t                             TileNumber;
   uint32_t                             TileStartCTBY;
   uint32_t                             TileStartCTBX;
   uint32_t                             TileWidth;
   uint32_t                             TileHeight;
   bool                                 TileStreamInOffsetEnable;
   uint32_t                             TileStreamInOffset;
   bool                                 TileRowStoreOffsetEnable;
   uint32_t                             TileRowStoreOffset;
   bool                                 TileStreamOutOffsetEnable;
   uint32_t                             TileStreamOutOffset;
   bool                                 TileLCUStreamOutOffsetEnable;
   uint32_t                             TileLCUStreamOutOffset;
   bool                                 PaletteModeEnable;
   uint32_t                             IBCControl;
   uint32_t                             AdaptiveChannelThreshold;
};

static inline __attribute__((always_inline)) void
GFX20_VDENC_WALKER_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                              __attribute__((unused)) void * restrict dst,
                              __attribute__((unused)) const struct GFX20_VDENC_WALKER_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->MBLCUStartYPosition, 0, 8) |
      util_bitpack_uint(values->MBLCUStartXPosition, 16, 24) |
      util_bitpack_uint(values->FirstSuperSlice, 28, 28);

   dw[2] =
      util_bitpack_uint(values->NextSliceMBStartYPosition, 0, 9) |
      util_bitpack_uint(values->NextSliceMBLCUStartXPosition, 16, 25);

   dw[3] =
      util_bitpack_uint(values->Log2WeightDenominatorLuma, 0, 2) |
      util_bitpack_uint(values->HEVCVP9Log2WeightDenominatorLuma, 4, 6) |
      util_bitpack_uint(values->NumberofParallelEngines, 9, 10) |
      util_bitpack_uint(values->TileNumber, 24, 31);

   dw[4] =
      util_bitpack_uint(values->TileStartCTBY, 0, 15) |
      util_bitpack_uint(values->TileStartCTBX, 16, 31);

   dw[5] =
      util_bitpack_uint(values->TileWidth, 0, 15) |
      util_bitpack_uint(values->TileHeight, 16, 31);

   dw[6] =
      util_bitpack_uint(values->TileStreamInOffsetEnable, 0, 0) |
      util_bitpack_uint(values->TileStreamInOffset, 6, 31);

   dw[7] =
      util_bitpack_uint(values->TileRowStoreOffsetEnable, 0, 0) |
      util_bitpack_uint(values->TileRowStoreOffset, 6, 31);

   dw[8] =
      util_bitpack_uint(values->TileStreamOutOffsetEnable, 0, 0) |
      util_bitpack_uint(values->TileStreamOutOffset, 6, 31);

   dw[9] =
      util_bitpack_uint(values->TileLCUStreamOutOffsetEnable, 0, 0) |
      util_bitpack_uint(values->TileLCUStreamOutOffset, 6, 31);

   dw[10] = 0;

   dw[11] = 0;

   dw[12] =
      util_bitpack_uint(values->PaletteModeEnable, 26, 26) |
      util_bitpack_uint(values->IBCControl, 27, 28);

   dw[13] = 0;

   dw[14] = 0;

   dw[15] = 0;

   dw[16] =
      util_bitpack_uint(values->AdaptiveChannelThreshold, 24, 27);

   dw[17] = 0;

   dw[18] = 0;

   dw[19] = 0;

   dw[20] = 0;

   dw[21] = 0;

   dw[22] = 0;

   dw[23] = 0;

   dw[24] = 0;

   dw[25] = 0;

   dw[26] = 0;
}

#define GFX20_VDENC_WEIGHTSOFFSETS_STATE_length      3
#define GFX20_VDENC_WEIGHTSOFFSETS_STATE_length_bias      2
#define GFX20_VDENC_WEIGHTSOFFSETS_STATE_header \
   .DWordLength                         =      1,  \
   .SubOpcodeB                          =      8,  \
   .SubOpcodeA                          =      0,  \
   .MediaCommandOpCode                  =      1,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_VDENC_WEIGHTSOFFSETS_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpCode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   int32_t                              WeightsForwardReference0;
   int32_t                              OffsetForwardReference0;
   int32_t                              WeightsForwardReference1;
   int32_t                              OffsetForwardReference1;
   int32_t                              WeightsForwardReference2;
   int32_t                              OffsetForwardReference2;
   int32_t                              HEVCVP9WeightsBackwardReference0;
   int32_t                              HEVCVP9OffsetBackwardReference0;
};

static inline __attribute__((always_inline)) void
GFX20_VDENC_WEIGHTSOFFSETS_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                                      __attribute__((unused)) void * restrict dst,
                                      __attribute__((unused)) const struct GFX20_VDENC_WEIGHTSOFFSETS_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 22) |
      util_bitpack_uint(values->MediaCommandOpCode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_sint(values->WeightsForwardReference0, 0, 7) |
      util_bitpack_sint(values->OffsetForwardReference0, 8, 15) |
      util_bitpack_sint(values->WeightsForwardReference1, 16, 23) |
      util_bitpack_sint(values->OffsetForwardReference1, 24, 31);

   dw[2] =
      util_bitpack_sint(values->WeightsForwardReference2, 0, 7) |
      util_bitpack_sint(values->OffsetForwardReference2, 8, 15) |
      util_bitpack_sint(values->HEVCVP9WeightsBackwardReference0, 16, 23) |
      util_bitpack_sint(values->HEVCVP9OffsetBackwardReference0, 24, 31);
}

#define GFX20_VD_CONTROL_STATE_length          3
#define GFX20_VD_CONTROL_STATE_length_bias      2
#define GFX20_VD_CONTROL_STATE_header           \
   .DWordLength                         =      1,  \
   .SubOpcode                           =     10,  \
   .MediaCommandOpCode                  =      7,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_VD_CONTROL_STATE {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcode;
   uint32_t                             MediaCommandOpCode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   bool                                 PipelineInitialization;
   bool                                 ScalableModePipeLock;
   bool                                 ScalableModePipeUnlock;
   bool                                 MemoryImplicitFlush;
};

static inline __attribute__((always_inline)) void
GFX20_VD_CONTROL_STATE_pack(__attribute__((unused)) __gen_user_data *data,
                            __attribute__((unused)) void * restrict dst,
                            __attribute__((unused)) const struct GFX20_VD_CONTROL_STATE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcode, 16, 22) |
      util_bitpack_uint(values->MediaCommandOpCode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->PipelineInitialization, 0, 0);

   dw[2] =
      util_bitpack_uint(values->ScalableModePipeLock, 0, 0) |
      util_bitpack_uint(values->ScalableModePipeUnlock, 1, 1) |
      util_bitpack_uint(values->MemoryImplicitFlush, 2, 2);
}

#define GFX20_VD_PIPELINE_FLUSH_length         2
#define GFX20_VD_PIPELINE_FLUSH_length_bias      2
#define GFX20_VD_PIPELINE_FLUSH_header          \
   .DWordLength                         =      0,  \
   .SubOpcodeB                          =      0,  \
   .SubOpcodeA                          =      0,  \
   .MediaCommandOpcode                  =     15,  \
   .Pipeline                            =      2,  \
   .CommandType                         =      3

struct GFX20_VD_PIPELINE_FLUSH {
   uint32_t                             DWordLength;
   uint32_t                             SubOpcodeB;
   uint32_t                             SubOpcodeA;
   uint32_t                             MediaCommandOpcode;
   uint32_t                             Pipeline;
   uint32_t                             CommandType;
   bool                                 HEVCPipelineDone;
   bool                                 VDENCPipelineDone;
   bool                                 MFXPipelineDone;
   bool                                 VDCommandMessageParserDone;
   bool                                 AVPPipelineDone;
   bool                                 HEVCPipelineCommandFlush;
   bool                                 VDENCPipelineCommandFlush;
   bool                                 MFXPipelineCommandFlush;
   bool                                 AVPPipelineCommandFlush;
};

static inline __attribute__((always_inline)) void
GFX20_VD_PIPELINE_FLUSH_pack(__attribute__((unused)) __gen_user_data *data,
                             __attribute__((unused)) void * restrict dst,
                             __attribute__((unused)) const struct GFX20_VD_PIPELINE_FLUSH * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->DWordLength, 0, 11) |
      util_bitpack_uint(values->SubOpcodeB, 16, 20) |
      util_bitpack_uint(values->SubOpcodeA, 21, 22) |
      util_bitpack_uint(values->MediaCommandOpcode, 23, 26) |
      util_bitpack_uint(values->Pipeline, 27, 28) |
      util_bitpack_uint(values->CommandType, 29, 31);

   dw[1] =
      util_bitpack_uint(values->HEVCPipelineDone, 0, 0) |
      util_bitpack_uint(values->VDENCPipelineDone, 1, 1) |
      util_bitpack_uint(values->MFXPipelineDone, 3, 3) |
      util_bitpack_uint(values->VDCommandMessageParserDone, 4, 4) |
      util_bitpack_uint(values->AVPPipelineDone, 5, 5) |
      util_bitpack_uint(values->HEVCPipelineCommandFlush, 16, 16) |
      util_bitpack_uint(values->VDENCPipelineCommandFlush, 17, 17) |
      util_bitpack_uint(values->MFXPipelineCommandFlush, 19, 19) |
      util_bitpack_uint(values->AVPPipelineCommandFlush, 20, 20);
}

#define GFX20_BCS_AUX_TABLE_BASE_ADDR_num 0x4240
#define GFX20_BCS_AUX_TABLE_BASE_ADDR_length      2
struct GFX20_BCS_AUX_TABLE_BASE_ADDR {
   uint64_t                             Address;
};

static inline __attribute__((always_inline)) void
GFX20_BCS_AUX_TABLE_BASE_ADDR_pack(__attribute__((unused)) __gen_user_data *data,
                                   __attribute__((unused)) void * restrict dst,
                                   __attribute__((unused)) const struct GFX20_BCS_AUX_TABLE_BASE_ADDR * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   const uint64_t v0 =
      util_bitpack_uint(values->Address, 0, 63);
   dw[0] = v0;
   dw[1] = v0 >> 32;
}

#define GFX20_BCS_CCS_AUX_INV_num         0x4248
#define GFX20_BCS_CCS_AUX_INV_length           1
struct GFX20_BCS_CCS_AUX_INV {
   bool                                 AuxInv;
};

static inline __attribute__((always_inline)) void
GFX20_BCS_CCS_AUX_INV_pack(__attribute__((unused)) __gen_user_data *data,
                           __attribute__((unused)) void * restrict dst,
                           __attribute__((unused)) const struct GFX20_BCS_CCS_AUX_INV * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->AuxInv, 0, 0);
}

#define GFX20_BCS_INSTDONE_num            0x2206c
#define GFX20_BCS_INSTDONE_length              1
struct GFX20_BCS_INSTDONE {
   bool                                 RingEnable;
   bool                                 BlitterIDLE;
   bool                                 GABIDLE;
   bool                                 BCSDone;
};

static inline __attribute__((always_inline)) void
GFX20_BCS_INSTDONE_pack(__attribute__((unused)) __gen_user_data *data,
                        __attribute__((unused)) void * restrict dst,
                        __attribute__((unused)) const struct GFX20_BCS_INSTDONE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->RingEnable, 0, 0) |
      util_bitpack_uint(values->BlitterIDLE, 1, 1) |
      util_bitpack_uint(values->GABIDLE, 2, 2) |
      util_bitpack_uint(values->BCSDone, 3, 3);
}

#define GFX20_BLT_TRTT_CR_num             0x4480
#define GFX20_BLT_TRTT_CR_length               1
struct GFX20_BLT_TRTT_CR {
   bool                                 TRTTEnable;
};

static inline __attribute__((always_inline)) void
GFX20_BLT_TRTT_CR_pack(__attribute__((unused)) __gen_user_data *data,
                       __attribute__((unused)) void * restrict dst,
                       __attribute__((unused)) const struct GFX20_BLT_TRTT_CR * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->TRTTEnable, 0, 0);
}

#define GFX20_BLT_TRTT_INVAL_num          0x4494
#define GFX20_BLT_TRTT_INVAL_length            1
struct GFX20_BLT_TRTT_INVAL {
   uint32_t                             InvalidTileDetectionValue;
};

static inline __attribute__((always_inline)) void
GFX20_BLT_TRTT_INVAL_pack(__attribute__((unused)) __gen_user_data *data,
                          __attribute__((unused)) void * restrict dst,
                          __attribute__((unused)) const struct GFX20_BLT_TRTT_INVAL * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->InvalidTileDetectionValue, 0, 31);
}

#define GFX20_BLT_TRTT_L3_BASE_HIGH_num   0x448c
#define GFX20_BLT_TRTT_L3_BASE_HIGH_length      1
struct GFX20_BLT_TRTT_L3_BASE_HIGH {
   uint32_t                             TRVAL3PointerUpperAddress;
};

static inline __attribute__((always_inline)) void
GFX20_BLT_TRTT_L3_BASE_HIGH_pack(__attribute__((unused)) __gen_user_data *data,
                                 __attribute__((unused)) void * restrict dst,
                                 __attribute__((unused)) const struct GFX20_BLT_TRTT_L3_BASE_HIGH * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->TRVAL3PointerUpperAddress, 0, 15);
}

#define GFX20_BLT_TRTT_L3_BASE_LOW_num    0x4488
#define GFX20_BLT_TRTT_L3_BASE_LOW_length      1
struct GFX20_BLT_TRTT_L3_BASE_LOW {
   uint32_t                             TRVAL3PointerLowerAddress;
};

static inline __attribute__((always_inline)) void
GFX20_BLT_TRTT_L3_BASE_LOW_pack(__attribute__((unused)) __gen_user_data *data,
                                __attribute__((unused)) void * restrict dst,
                                __attribute__((unused)) const struct GFX20_BLT_TRTT_L3_BASE_LOW * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->TRVAL3PointerLowerAddress, 12, 31);
}

#define GFX20_BLT_TRTT_NULL_num           0x4490
#define GFX20_BLT_TRTT_NULL_length             1
struct GFX20_BLT_TRTT_NULL {
   uint32_t                             NullTileDetectionValue;
};

static inline __attribute__((always_inline)) void
GFX20_BLT_TRTT_NULL_pack(__attribute__((unused)) __gen_user_data *data,
                         __attribute__((unused)) void * restrict dst,
                         __attribute__((unused)) const struct GFX20_BLT_TRTT_NULL * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->NullTileDetectionValue, 0, 31);
}

#define GFX20_BLT_TRTT_VA_RANGE_num       0x4484
#define GFX20_BLT_TRTT_VA_RANGE_length         1
struct GFX20_BLT_TRTT_VA_RANGE {
   uint32_t                             TRVABase;
};

static inline __attribute__((always_inline)) void
GFX20_BLT_TRTT_VA_RANGE_pack(__attribute__((unused)) __gen_user_data *data,
                             __attribute__((unused)) void * restrict dst,
                             __attribute__((unused)) const struct GFX20_BLT_TRTT_VA_RANGE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->TRVABase, 0, 12);
}

#define GFX20_CACHE_MODE_0_num            0x7000
#define GFX20_CACHE_MODE_0_length              1
struct GFX20_CACHE_MODE_0 {
   bool                                 HierarchicalZRAWStallOptimizationDisable;
   bool                                 HierarchicalZDisable;
   bool                                 LateZAllocDisable;
   bool                                 MsaaFastClearEnabled;
   bool                                 DepthRelatedCachePipelinedFlushDisable;
   bool                                 SamplerL2TLBPrefetchEnable;
   uint32_t                             RCZPMANotPromotedAllocationstalloptimizationDisableduetochangeindepthparameters;
   bool                                 DisableRepackingforCompression;
   bool                                 HierarchicalZRAWStallOptimizationDisableMask;
   bool                                 HierarchicalZDisableMask;
   bool                                 LateZAllocDisableMask;
   bool                                 MsaaFastClearEnabledMask;
   bool                                 DepthRelatedCachePipelinedFlushDisableMask;
   bool                                 SamplerL2TLBPrefetchEnableMask;
   bool                                 RCZPMANotPromotedAllocationstalloptimizationDisableduetochangeindepthparametersMask;
   bool                                 DisableRepackingforCompressionMask;
};

static inline __attribute__((always_inline)) void
GFX20_CACHE_MODE_0_pack(__attribute__((unused)) __gen_user_data *data,
                        __attribute__((unused)) void * restrict dst,
                        __attribute__((unused)) const struct GFX20_CACHE_MODE_0 * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->HierarchicalZRAWStallOptimizationDisable, 2, 2) |
      util_bitpack_uint(values->HierarchicalZDisable, 3, 3) |
      util_bitpack_uint(values->LateZAllocDisable, 4, 4) |
      util_bitpack_uint(values->MsaaFastClearEnabled, 5, 5) |
      util_bitpack_uint(values->DepthRelatedCachePipelinedFlushDisable, 8, 8) |
      util_bitpack_uint(values->SamplerL2TLBPrefetchEnable, 9, 9) |
      util_bitpack_uint(values->RCZPMANotPromotedAllocationstalloptimizationDisableduetochangeindepthparameters, 10, 10) |
      util_bitpack_uint(values->DisableRepackingforCompression, 15, 15) |
      util_bitpack_uint(values->HierarchicalZRAWStallOptimizationDisableMask, 18, 18) |
      util_bitpack_uint(values->HierarchicalZDisableMask, 19, 19) |
      util_bitpack_uint(values->LateZAllocDisableMask, 20, 20) |
      util_bitpack_uint(values->MsaaFastClearEnabledMask, 21, 21) |
      util_bitpack_uint(values->DepthRelatedCachePipelinedFlushDisableMask, 24, 24) |
      util_bitpack_uint(values->SamplerL2TLBPrefetchEnableMask, 25, 25) |
      util_bitpack_uint(values->RCZPMANotPromotedAllocationstalloptimizationDisableduetochangeindepthparametersMask, 26, 26) |
      util_bitpack_uint(values->DisableRepackingforCompressionMask, 31, 31);
}

#define GFX20_CACHE_MODE_1_num            0x7004
#define GFX20_CACHE_MODE_1_length              1
struct GFX20_CACHE_MODE_1 {
   bool                                 PartialResolveDisableInVC;
   bool                                 RCZPMAPromoted2NotPromotedAllocationstalloptimizationDisable;
   bool                                 MCSCacheDisable;
   bool                                 MSCRAWHazardAvoidanceBit;
   uint32_t                             NPEarlyZFailsDisable;
   bool                                 BlendOptimizationFixDisable;
   bool                                 ColorCompressionDisable;
   bool                                 PartialResolveDisableInVCMask;
   bool                                 RCZPMAPromoted2NotPromotedAllocationstalloptimizationDisableMask;
   bool                                 MCSCacheDisableMask;
   bool                                 MSCRAWHazardAvoidanceBitMask;
   bool                                 NPEarlyZFailsDisableMask;
   bool                                 BlendOptimizationFixDisableMask;
   bool                                 ColorCompressionDisableMask;
};

static inline __attribute__((always_inline)) void
GFX20_CACHE_MODE_1_pack(__attribute__((unused)) __gen_user_data *data,
                        __attribute__((unused)) void * restrict dst,
                        __attribute__((unused)) const struct GFX20_CACHE_MODE_1 * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->PartialResolveDisableInVC, 1, 1) |
      util_bitpack_uint(values->RCZPMAPromoted2NotPromotedAllocationstalloptimizationDisable, 3, 3) |
      util_bitpack_uint(values->MCSCacheDisable, 5, 5) |
      util_bitpack_uint(values->MSCRAWHazardAvoidanceBit, 9, 9) |
      util_bitpack_uint(values->NPEarlyZFailsDisable, 13, 13) |
      util_bitpack_uint(values->BlendOptimizationFixDisable, 14, 14) |
      util_bitpack_uint(values->ColorCompressionDisable, 15, 15) |
      util_bitpack_uint(values->PartialResolveDisableInVCMask, 17, 17) |
      util_bitpack_uint(values->RCZPMAPromoted2NotPromotedAllocationstalloptimizationDisableMask, 19, 19) |
      util_bitpack_uint(values->MCSCacheDisableMask, 21, 21) |
      util_bitpack_uint(values->MSCRAWHazardAvoidanceBitMask, 25, 25) |
      util_bitpack_uint(values->NPEarlyZFailsDisableMask, 29, 29) |
      util_bitpack_uint(values->BlendOptimizationFixDisableMask, 30, 30) |
      util_bitpack_uint(values->ColorCompressionDisableMask, 31, 31);
}

#define GFX20_CCS_INSTDONE_num            0x1206c
#define GFX20_CCS_INSTDONE_length              1
struct GFX20_CCS_INSTDONE {
   bool                                 RingEnable;
   bool                                 VFEDone;
   bool                                 TSGDone;
   bool                                 CSDone;
};

static inline __attribute__((always_inline)) void
GFX20_CCS_INSTDONE_pack(__attribute__((unused)) __gen_user_data *data,
                        __attribute__((unused)) void * restrict dst,
                        __attribute__((unused)) const struct GFX20_CCS_INSTDONE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->RingEnable, 0, 0) |
      util_bitpack_uint(values->VFEDone, 16, 16) |
      util_bitpack_uint(values->TSGDone, 17, 17) |
      util_bitpack_uint(values->CSDone, 21, 21);
}

#define GFX20_CHICKEN_RASTER_1_num        0x6204
#define GFX20_CHICKEN_RASTER_1_length          1
struct GFX20_CHICKEN_RASTER_1 {
   bool                                 AALineQualityFix;
   bool                                 AALineQualityFixMask;
};

static inline __attribute__((always_inline)) void
GFX20_CHICKEN_RASTER_1_pack(__attribute__((unused)) __gen_user_data *data,
                            __attribute__((unused)) void * restrict dst,
                            __attribute__((unused)) const struct GFX20_CHICKEN_RASTER_1 * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->AALineQualityFix, 5, 5) |
      util_bitpack_uint(values->AALineQualityFixMask, 21, 21);
}

#define GFX20_CHICKEN_RASTER_2_num        0x6208
#define GFX20_CHICKEN_RASTER_2_length          1
struct GFX20_CHICKEN_RASTER_2 {
   bool                                 TBIMRBatchSizeOverride;
   bool                                 TBIMROpenBatchEnable;
   bool                                 TBIMRFastClip;
   bool                                 TBIMRBatchSizeOverrideMask;
   bool                                 TBIMROpenBatchEnableMask;
   bool                                 TBIMRFastClipMask;
};

static inline __attribute__((always_inline)) void
GFX20_CHICKEN_RASTER_2_pack(__attribute__((unused)) __gen_user_data *data,
                            __attribute__((unused)) void * restrict dst,
                            __attribute__((unused)) const struct GFX20_CHICKEN_RASTER_2 * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->TBIMRBatchSizeOverride, 1, 1) |
      util_bitpack_uint(values->TBIMROpenBatchEnable, 4, 4) |
      util_bitpack_uint(values->TBIMRFastClip, 5, 5) |
      util_bitpack_uint(values->TBIMRBatchSizeOverrideMask, 17, 17) |
      util_bitpack_uint(values->TBIMROpenBatchEnableMask, 20, 20) |
      util_bitpack_uint(values->TBIMRFastClipMask, 21, 21);
}

#define GFX20_CL_INVOCATION_COUNT_num     0x2338
#define GFX20_CL_INVOCATION_COUNT_length       2
struct GFX20_CL_INVOCATION_COUNT {
   uint64_t                             CLInvocationCountReport;
};

static inline __attribute__((always_inline)) void
GFX20_CL_INVOCATION_COUNT_pack(__attribute__((unused)) __gen_user_data *data,
                               __attribute__((unused)) void * restrict dst,
                               __attribute__((unused)) const struct GFX20_CL_INVOCATION_COUNT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   const uint64_t v0 =
      util_bitpack_uint(values->CLInvocationCountReport, 0, 63);
   dw[0] = v0;
   dw[1] = v0 >> 32;
}

#define GFX20_CL_PRIMITIVES_COUNT_num     0x2340
#define GFX20_CL_PRIMITIVES_COUNT_length       2
struct GFX20_CL_PRIMITIVES_COUNT {
   uint64_t                             CLPrimitivesCountReport;
};

static inline __attribute__((always_inline)) void
GFX20_CL_PRIMITIVES_COUNT_pack(__attribute__((unused)) __gen_user_data *data,
                               __attribute__((unused)) void * restrict dst,
                               __attribute__((unused)) const struct GFX20_CL_PRIMITIVES_COUNT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   const uint64_t v0 =
      util_bitpack_uint(values->CLPrimitivesCountReport, 0, 63);
   dw[0] = v0;
   dw[1] = v0 >> 32;
}

#define GFX20_COMMON_SLICE_CHICKEN1_num   0x7010
#define GFX20_COMMON_SLICE_CHICKEN1_length      1
struct GFX20_COMMON_SLICE_CHICKEN1 {
   bool                                 HIZPlaneOptimizationdisablebit;
   bool                                 HIZPlaneOptimizationdisablebitMask;
};

static inline __attribute__((always_inline)) void
GFX20_COMMON_SLICE_CHICKEN1_pack(__attribute__((unused)) __gen_user_data *data,
                                 __attribute__((unused)) void * restrict dst,
                                 __attribute__((unused)) const struct GFX20_COMMON_SLICE_CHICKEN1 * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->HIZPlaneOptimizationdisablebit, 9, 9) |
      util_bitpack_uint(values->HIZPlaneOptimizationdisablebitMask, 25, 25);
}

#define GFX20_COMMON_SLICE_CHICKEN3_num   0x7304
#define GFX20_COMMON_SLICE_CHICKEN3_length      1
struct GFX20_COMMON_SLICE_CHICKEN3 {
   uint32_t                             PSThreadPanicDispatch;
   uint32_t                             PSThreadPanicDispatchMask;
};

static inline __attribute__((always_inline)) void
GFX20_COMMON_SLICE_CHICKEN3_pack(__attribute__((unused)) __gen_user_data *data,
                                 __attribute__((unused)) void * restrict dst,
                                 __attribute__((unused)) const struct GFX20_COMMON_SLICE_CHICKEN3 * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->PSThreadPanicDispatch, 6, 7) |
      util_bitpack_uint(values->PSThreadPanicDispatchMask, 22, 23);
}

#define GFX20_COMMON_SLICE_CHICKEN4_num   0x7300
#define GFX20_COMMON_SLICE_CHICKEN4_length      1
struct GFX20_COMMON_SLICE_CHICKEN4 {
   bool                                 EnableHardwareFilteringinWM;
   bool                                 EnableHardwareFilteringinWMMask;
};

static inline __attribute__((always_inline)) void
GFX20_COMMON_SLICE_CHICKEN4_pack(__attribute__((unused)) __gen_user_data *data,
                                 __attribute__((unused)) void * restrict dst,
                                 __attribute__((unused)) const struct GFX20_COMMON_SLICE_CHICKEN4 * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->EnableHardwareFilteringinWM, 5, 5) |
      util_bitpack_uint(values->EnableHardwareFilteringinWMMask, 21, 21);
}

#define GFX20_COMPCS0_AUX_TABLE_BASE_ADDR_num 0x42c0
#define GFX20_COMPCS0_AUX_TABLE_BASE_ADDR_length      2
struct GFX20_COMPCS0_AUX_TABLE_BASE_ADDR {
   uint64_t                             Address;
};

static inline __attribute__((always_inline)) void
GFX20_COMPCS0_AUX_TABLE_BASE_ADDR_pack(__attribute__((unused)) __gen_user_data *data,
                                       __attribute__((unused)) void * restrict dst,
                                       __attribute__((unused)) const struct GFX20_COMPCS0_AUX_TABLE_BASE_ADDR * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   const uint64_t v0 =
      util_bitpack_uint(values->Address, 0, 63);
   dw[0] = v0;
   dw[1] = v0 >> 32;
}

#define GFX20_COMPCS0_CCS_AUX_INV_num     0x42c8
#define GFX20_COMPCS0_CCS_AUX_INV_length       1
struct GFX20_COMPCS0_CCS_AUX_INV {
   bool                                 AuxInv;
};

static inline __attribute__((always_inline)) void
GFX20_COMPCS0_CCS_AUX_INV_pack(__attribute__((unused)) __gen_user_data *data,
                               __attribute__((unused)) void * restrict dst,
                               __attribute__((unused)) const struct GFX20_COMPCS0_CCS_AUX_INV * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->AuxInv, 0, 0);
}

#define GFX20_COMP_CTX0_TRTT_CR_num       0x4580
#define GFX20_COMP_CTX0_TRTT_CR_length         1
struct GFX20_COMP_CTX0_TRTT_CR {
   bool                                 TRTTEnable;
};

static inline __attribute__((always_inline)) void
GFX20_COMP_CTX0_TRTT_CR_pack(__attribute__((unused)) __gen_user_data *data,
                             __attribute__((unused)) void * restrict dst,
                             __attribute__((unused)) const struct GFX20_COMP_CTX0_TRTT_CR * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->TRTTEnable, 0, 0);
}

#define GFX20_COMP_CTX0_TRTT_INVAL_num    0x4594
#define GFX20_COMP_CTX0_TRTT_INVAL_length      1
struct GFX20_COMP_CTX0_TRTT_INVAL {
   uint32_t                             InvalidTileDetectionValue;
};

static inline __attribute__((always_inline)) void
GFX20_COMP_CTX0_TRTT_INVAL_pack(__attribute__((unused)) __gen_user_data *data,
                                __attribute__((unused)) void * restrict dst,
                                __attribute__((unused)) const struct GFX20_COMP_CTX0_TRTT_INVAL * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->InvalidTileDetectionValue, 0, 31);
}

#define GFX20_COMP_CTX0_TRTT_L3_BASE_HIGH_num 0x458c
#define GFX20_COMP_CTX0_TRTT_L3_BASE_HIGH_length      1
struct GFX20_COMP_CTX0_TRTT_L3_BASE_HIGH {
   uint32_t                             TRVAL3PointerUpperAddress;
};

static inline __attribute__((always_inline)) void
GFX20_COMP_CTX0_TRTT_L3_BASE_HIGH_pack(__attribute__((unused)) __gen_user_data *data,
                                       __attribute__((unused)) void * restrict dst,
                                       __attribute__((unused)) const struct GFX20_COMP_CTX0_TRTT_L3_BASE_HIGH * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->TRVAL3PointerUpperAddress, 0, 15);
}

#define GFX20_COMP_CTX0_TRTT_L3_BASE_LOW_num 0x4588
#define GFX20_COMP_CTX0_TRTT_L3_BASE_LOW_length      1
struct GFX20_COMP_CTX0_TRTT_L3_BASE_LOW {
   uint32_t                             TRVAL3PointerLowerAddress;
};

static inline __attribute__((always_inline)) void
GFX20_COMP_CTX0_TRTT_L3_BASE_LOW_pack(__attribute__((unused)) __gen_user_data *data,
                                      __attribute__((unused)) void * restrict dst,
                                      __attribute__((unused)) const struct GFX20_COMP_CTX0_TRTT_L3_BASE_LOW * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->TRVAL3PointerLowerAddress, 12, 31);
}

#define GFX20_COMP_CTX0_TRTT_NULL_num     0x4590
#define GFX20_COMP_CTX0_TRTT_NULL_length       1
struct GFX20_COMP_CTX0_TRTT_NULL {
   uint32_t                             NullTileDetectionValue;
};

static inline __attribute__((always_inline)) void
GFX20_COMP_CTX0_TRTT_NULL_pack(__attribute__((unused)) __gen_user_data *data,
                               __attribute__((unused)) void * restrict dst,
                               __attribute__((unused)) const struct GFX20_COMP_CTX0_TRTT_NULL * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->NullTileDetectionValue, 0, 31);
}

#define GFX20_COMP_CTX0_TRTT_VA_RANGE_num 0x4584
#define GFX20_COMP_CTX0_TRTT_VA_RANGE_length      1
struct GFX20_COMP_CTX0_TRTT_VA_RANGE {
   uint32_t                             TRVABase;
};

static inline __attribute__((always_inline)) void
GFX20_COMP_CTX0_TRTT_VA_RANGE_pack(__attribute__((unused)) __gen_user_data *data,
                                   __attribute__((unused)) void * restrict dst,
                                   __attribute__((unused)) const struct GFX20_COMP_CTX0_TRTT_VA_RANGE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->TRVABase, 0, 12);
}

#define GFX20_CS_CHICKEN1_num             0x2580
#define GFX20_CS_CHICKEN1_length               1
struct GFX20_CS_CHICKEN1 {
   uint32_t                             MediaAndGPGPUPreemptionControl;
#define MidthreadPreemption                      0
#define ThreadGroupPreemption                    1
#define CommandLevelPreemption                   2
   bool                                 DisablePreemptionandHighPriorityPausingdueto3DPRIMITIVECommand;
   uint32_t                             MediaAndGPGPUPreemptionControlMask;
   bool                                 DisablePreemptionandHighPriorityPausingdueto3DPRIMITIVECommandMask;
};

static inline __attribute__((always_inline)) void
GFX20_CS_CHICKEN1_pack(__attribute__((unused)) __gen_user_data *data,
                       __attribute__((unused)) void * restrict dst,
                       __attribute__((unused)) const struct GFX20_CS_CHICKEN1 * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->MediaAndGPGPUPreemptionControl, 1, 2) |
      util_bitpack_uint(values->DisablePreemptionandHighPriorityPausingdueto3DPRIMITIVECommand, 10, 10) |
      util_bitpack_uint(values->MediaAndGPGPUPreemptionControlMask, 17, 18) |
      util_bitpack_uint(values->DisablePreemptionandHighPriorityPausingdueto3DPRIMITIVECommandMask, 26, 26);
}

#define GFX20_CS_DEBUG_MODE2_num          0x20d8
#define GFX20_CS_DEBUG_MODE2_length            1
struct GFX20_CS_DEBUG_MODE2 {
   bool                                 _3DRenderingInstructionDisable;
   bool                                 MediaInstructionDisable;
   bool                                 CONSTANT_BUFFERAddressOffsetDisable;
   bool                                 _3DRenderingInstructionDisableMask;
   bool                                 MediaInstructionDisableMask;
   bool                                 CONSTANT_BUFFERAddressOffsetDisableMask;
};

static inline __attribute__((always_inline)) void
GFX20_CS_DEBUG_MODE2_pack(__attribute__((unused)) __gen_user_data *data,
                          __attribute__((unused)) void * restrict dst,
                          __attribute__((unused)) const struct GFX20_CS_DEBUG_MODE2 * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->_3DRenderingInstructionDisable, 0, 0) |
      util_bitpack_uint(values->MediaInstructionDisable, 1, 1) |
      util_bitpack_uint(values->CONSTANT_BUFFERAddressOffsetDisable, 4, 4) |
      util_bitpack_uint(values->_3DRenderingInstructionDisableMask, 16, 16) |
      util_bitpack_uint(values->MediaInstructionDisableMask, 17, 17) |
      util_bitpack_uint(values->CONSTANT_BUFFERAddressOffsetDisableMask, 20, 20);
}

#define GFX20_CS_INVOCATION_COUNT_num     0x2290
#define GFX20_CS_INVOCATION_COUNT_length       2
struct GFX20_CS_INVOCATION_COUNT {
   uint64_t                             CSInvocationCountReport;
};

static inline __attribute__((always_inline)) void
GFX20_CS_INVOCATION_COUNT_pack(__attribute__((unused)) __gen_user_data *data,
                               __attribute__((unused)) void * restrict dst,
                               __attribute__((unused)) const struct GFX20_CS_INVOCATION_COUNT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   const uint64_t v0 =
      util_bitpack_uint(values->CSInvocationCountReport, 0, 63);
   dw[0] = v0;
   dw[1] = v0 >> 32;
}

#define GFX20_DS_INVOCATION_COUNT_num     0x2308
#define GFX20_DS_INVOCATION_COUNT_length       2
struct GFX20_DS_INVOCATION_COUNT {
   uint64_t                             DSInvocationCountReport;
};

static inline __attribute__((always_inline)) void
GFX20_DS_INVOCATION_COUNT_pack(__attribute__((unused)) __gen_user_data *data,
                               __attribute__((unused)) void * restrict dst,
                               __attribute__((unused)) const struct GFX20_DS_INVOCATION_COUNT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   const uint64_t v0 =
      util_bitpack_uint(values->DSInvocationCountReport, 0, 63);
   dw[0] = v0;
   dw[1] = v0 >> 32;
}

#define GFX20_FF_MODE_num                 0x6210
#define GFX20_FF_MODE_length                   1
struct GFX20_FF_MODE {
   bool                                 MeshShaderAutostripDisable;
   bool                                 MeshShaderPartialAutostripDisable;
   bool                                 TEAutostripDisable;
};

static inline __attribute__((always_inline)) void
GFX20_FF_MODE_pack(__attribute__((unused)) __gen_user_data *data,
                   __attribute__((unused)) void * restrict dst,
                   __attribute__((unused)) const struct GFX20_FF_MODE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->MeshShaderAutostripDisable, 15, 15) |
      util_bitpack_uint(values->MeshShaderPartialAutostripDisable, 16, 16) |
      util_bitpack_uint(values->TEAutostripDisable, 31, 31);
}

#define GFX20_FF_MODE2_num                0x6604
#define GFX20_FF_MODE2_length                  1
struct GFX20_FF_MODE2 {
   uint32_t                             VSTimerValue;
   uint32_t                             HSTimerValue;
   uint32_t                             TDSTimerValue;
   uint32_t                             GSTimerValue;
};

static inline __attribute__((always_inline)) void
GFX20_FF_MODE2_pack(__attribute__((unused)) __gen_user_data *data,
                    __attribute__((unused)) void * restrict dst,
                    __attribute__((unused)) const struct GFX20_FF_MODE2 * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->VSTimerValue, 0, 7) |
      util_bitpack_uint(values->HSTimerValue, 8, 15) |
      util_bitpack_uint(values->TDSTimerValue, 16, 23) |
      util_bitpack_uint(values->GSTimerValue, 24, 31);
}

#define GFX20_GAM_DONE_num                0xcf68
#define GFX20_GAM_DONE_length                  1
struct GFX20_GAM_DONE {
   bool                                 GFXTLB0Done;
   bool                                 GFXTLB1Done;
   bool                                 COMPTLB0Done;
   bool                                 COMPTLB1Done;
   bool                                 GUCTLBDone;
   bool                                 KCRTLBDone;
   bool                                 OACTLBDone;
   bool                                 VDBOX0TLBDone;
   bool                                 VDBOX2TLBDone;
   bool                                 VEBOX0TLBDone;
   bool                                 CMINGRESSDone;
   bool                                 DataINGRESSDone;
   bool                                 REQSTRMDone;
   bool                                 STLBDone;
   bool                                 BLTTLBDone;
   bool                                 TLBHitARBCOMPDone;
   bool                                 TLBHitARBMISCDone;
   bool                                 TLBHitARBSTGDone;
   bool                                 TLBHitGFXSTGDone;
   bool                                 TLBMissARBGFXDone;
   bool                                 TLBMissARBCOMPDone;
   bool                                 TLBMissARBMISCDone;
   bool                                 TLBMissARBSTGDone;
   bool                                 TRTLBDone;
   bool                                 WKRSDone;
   bool                                 CCSDone;
   bool                                 CTRLCOMMDone;
   bool                                 FLWCTRLDone;
   bool                                 DRTNDone;
   bool                                 VEBOX1TBLDone;
   bool                                 XBLDone;
};

static inline __attribute__((always_inline)) void
GFX20_GAM_DONE_pack(__attribute__((unused)) __gen_user_data *data,
                    __attribute__((unused)) void * restrict dst,
                    __attribute__((unused)) const struct GFX20_GAM_DONE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->GFXTLB0Done, 0, 0) |
      util_bitpack_uint(values->GFXTLB1Done, 1, 1) |
      util_bitpack_uint(values->COMPTLB0Done, 2, 2) |
      util_bitpack_uint(values->COMPTLB1Done, 3, 3) |
      util_bitpack_uint(values->GUCTLBDone, 4, 4) |
      util_bitpack_uint(values->KCRTLBDone, 5, 5) |
      util_bitpack_uint(values->OACTLBDone, 6, 6) |
      util_bitpack_uint(values->VDBOX0TLBDone, 7, 7) |
      util_bitpack_uint(values->VDBOX2TLBDone, 8, 8) |
      util_bitpack_uint(values->VEBOX0TLBDone, 9, 9) |
      util_bitpack_uint(values->CMINGRESSDone, 10, 10) |
      util_bitpack_uint(values->DataINGRESSDone, 11, 11) |
      util_bitpack_uint(values->REQSTRMDone, 12, 12) |
      util_bitpack_uint(values->STLBDone, 13, 13) |
      util_bitpack_uint(values->BLTTLBDone, 14, 14) |
      util_bitpack_uint(values->TLBHitARBCOMPDone, 15, 15) |
      util_bitpack_uint(values->TLBHitARBMISCDone, 16, 16) |
      util_bitpack_uint(values->TLBHitARBSTGDone, 17, 17) |
      util_bitpack_uint(values->TLBHitGFXSTGDone, 18, 18) |
      util_bitpack_uint(values->TLBMissARBGFXDone, 19, 19) |
      util_bitpack_uint(values->TLBMissARBCOMPDone, 20, 20) |
      util_bitpack_uint(values->TLBMissARBMISCDone, 21, 21) |
      util_bitpack_uint(values->TLBMissARBSTGDone, 22, 22) |
      util_bitpack_uint(values->TRTLBDone, 23, 23) |
      util_bitpack_uint(values->WKRSDone, 24, 24) |
      util_bitpack_uint(values->CCSDone, 25, 25) |
      util_bitpack_uint(values->CTRLCOMMDone, 26, 26) |
      util_bitpack_uint(values->FLWCTRLDone, 27, 27) |
      util_bitpack_uint(values->DRTNDone, 28, 28) |
      util_bitpack_uint(values->VEBOX1TBLDone, 29, 29) |
      util_bitpack_uint(values->XBLDone, 30, 30);
}

#define GFX20_GFX_AUX_TABLE_BASE_ADDR_num 0x4200
#define GFX20_GFX_AUX_TABLE_BASE_ADDR_length      2
struct GFX20_GFX_AUX_TABLE_BASE_ADDR {
   uint64_t                             Address;
};

static inline __attribute__((always_inline)) void
GFX20_GFX_AUX_TABLE_BASE_ADDR_pack(__attribute__((unused)) __gen_user_data *data,
                                   __attribute__((unused)) void * restrict dst,
                                   __attribute__((unused)) const struct GFX20_GFX_AUX_TABLE_BASE_ADDR * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   const uint64_t v0 =
      util_bitpack_uint(values->Address, 0, 63);
   dw[0] = v0;
   dw[1] = v0 >> 32;
}

#define GFX20_GFX_CCS_AUX_INV_num         0x4208
#define GFX20_GFX_CCS_AUX_INV_length           1
struct GFX20_GFX_CCS_AUX_INV {
   bool                                 AuxInv;
};

static inline __attribute__((always_inline)) void
GFX20_GFX_CCS_AUX_INV_pack(__attribute__((unused)) __gen_user_data *data,
                           __attribute__((unused)) void * restrict dst,
                           __attribute__((unused)) const struct GFX20_GFX_CCS_AUX_INV * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->AuxInv, 0, 0);
}

#define GFX20_GFX_TRTT_CR_num             0x4400
#define GFX20_GFX_TRTT_CR_length               1
struct GFX20_GFX_TRTT_CR {
   bool                                 TRTTEnable;
};

static inline __attribute__((always_inline)) void
GFX20_GFX_TRTT_CR_pack(__attribute__((unused)) __gen_user_data *data,
                       __attribute__((unused)) void * restrict dst,
                       __attribute__((unused)) const struct GFX20_GFX_TRTT_CR * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->TRTTEnable, 0, 0);
}

#define GFX20_GFX_TRTT_INVAL_num          0x4414
#define GFX20_GFX_TRTT_INVAL_length            1
struct GFX20_GFX_TRTT_INVAL {
   uint32_t                             InvalidTileDetectionValue;
};

static inline __attribute__((always_inline)) void
GFX20_GFX_TRTT_INVAL_pack(__attribute__((unused)) __gen_user_data *data,
                          __attribute__((unused)) void * restrict dst,
                          __attribute__((unused)) const struct GFX20_GFX_TRTT_INVAL * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->InvalidTileDetectionValue, 0, 31);
}

#define GFX20_GFX_TRTT_L3_BASE_HIGH_num   0x440c
#define GFX20_GFX_TRTT_L3_BASE_HIGH_length      1
struct GFX20_GFX_TRTT_L3_BASE_HIGH {
   uint32_t                             TRVAL3PointerUpperAddress;
};

static inline __attribute__((always_inline)) void
GFX20_GFX_TRTT_L3_BASE_HIGH_pack(__attribute__((unused)) __gen_user_data *data,
                                 __attribute__((unused)) void * restrict dst,
                                 __attribute__((unused)) const struct GFX20_GFX_TRTT_L3_BASE_HIGH * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->TRVAL3PointerUpperAddress, 0, 15);
}

#define GFX20_GFX_TRTT_L3_BASE_LOW_num    0x4408
#define GFX20_GFX_TRTT_L3_BASE_LOW_length      1
struct GFX20_GFX_TRTT_L3_BASE_LOW {
   uint32_t                             TRVAL3PointerLowerAddress;
};

static inline __attribute__((always_inline)) void
GFX20_GFX_TRTT_L3_BASE_LOW_pack(__attribute__((unused)) __gen_user_data *data,
                                __attribute__((unused)) void * restrict dst,
                                __attribute__((unused)) const struct GFX20_GFX_TRTT_L3_BASE_LOW * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->TRVAL3PointerLowerAddress, 12, 31);
}

#define GFX20_GFX_TRTT_NULL_num           0x4410
#define GFX20_GFX_TRTT_NULL_length             1
struct GFX20_GFX_TRTT_NULL {
   uint32_t                             NullTileDetectionValue;
};

static inline __attribute__((always_inline)) void
GFX20_GFX_TRTT_NULL_pack(__attribute__((unused)) __gen_user_data *data,
                         __attribute__((unused)) void * restrict dst,
                         __attribute__((unused)) const struct GFX20_GFX_TRTT_NULL * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->NullTileDetectionValue, 0, 31);
}

#define GFX20_GFX_TRTT_VA_RANGE_num       0x4404
#define GFX20_GFX_TRTT_VA_RANGE_length         1
struct GFX20_GFX_TRTT_VA_RANGE {
   uint32_t                             TRVABase;
};

static inline __attribute__((always_inline)) void
GFX20_GFX_TRTT_VA_RANGE_pack(__attribute__((unused)) __gen_user_data *data,
                             __attribute__((unused)) void * restrict dst,
                             __attribute__((unused)) const struct GFX20_GFX_TRTT_VA_RANGE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->TRVABase, 0, 12);
}

#define GFX20_GS_INVOCATION_COUNT_num     0x2328
#define GFX20_GS_INVOCATION_COUNT_length       2
struct GFX20_GS_INVOCATION_COUNT {
   uint64_t                             GSInvocationCountReport;
};

static inline __attribute__((always_inline)) void
GFX20_GS_INVOCATION_COUNT_pack(__attribute__((unused)) __gen_user_data *data,
                               __attribute__((unused)) void * restrict dst,
                               __attribute__((unused)) const struct GFX20_GS_INVOCATION_COUNT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   const uint64_t v0 =
      util_bitpack_uint(values->GSInvocationCountReport, 0, 63);
   dw[0] = v0;
   dw[1] = v0 >> 32;
}

#define GFX20_GS_PRIMITIVES_COUNT_num     0x2330
#define GFX20_GS_PRIMITIVES_COUNT_length       2
struct GFX20_GS_PRIMITIVES_COUNT {
   uint64_t                             GSPrimitivesCountReport;
};

static inline __attribute__((always_inline)) void
GFX20_GS_PRIMITIVES_COUNT_pack(__attribute__((unused)) __gen_user_data *data,
                               __attribute__((unused)) void * restrict dst,
                               __attribute__((unused)) const struct GFX20_GS_PRIMITIVES_COUNT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   const uint64_t v0 =
      util_bitpack_uint(values->GSPrimitivesCountReport, 0, 63);
   dw[0] = v0;
   dw[1] = v0 >> 32;
}

#define GFX20_HALF_SLICE_CHICKEN7_num     0xe194
#define GFX20_HALF_SLICE_CHICKEN7_length       1
struct GFX20_HALF_SLICE_CHICKEN7 {
   bool                                 EnabledTexelOffsetPrecisionFix;
   bool                                 EnabledTexelOffsetPrecisionFixMask;
};

static inline __attribute__((always_inline)) void
GFX20_HALF_SLICE_CHICKEN7_pack(__attribute__((unused)) __gen_user_data *data,
                               __attribute__((unused)) void * restrict dst,
                               __attribute__((unused)) const struct GFX20_HALF_SLICE_CHICKEN7 * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->EnabledTexelOffsetPrecisionFix, 1, 1) |
      util_bitpack_uint(values->EnabledTexelOffsetPrecisionFixMask, 17, 17);
}

#define GFX20_HIZ_CHICKEN_num             0x7018
#define GFX20_HIZ_CHICKEN_length               1
struct GFX20_HIZ_CHICKEN {
   bool                                 HZDepthTestLEGEOptimizationDisable;
   bool                                 HZDepthTestLEGEOptimizationDisableMask;
};

static inline __attribute__((always_inline)) void
GFX20_HIZ_CHICKEN_pack(__attribute__((unused)) __gen_user_data *data,
                       __attribute__((unused)) void * restrict dst,
                       __attribute__((unused)) const struct GFX20_HIZ_CHICKEN * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->HZDepthTestLEGEOptimizationDisable, 13, 13) |
      util_bitpack_uint(values->HZDepthTestLEGEOptimizationDisableMask, 29, 29);
}

#define GFX20_HS_INVOCATION_COUNT_num     0x2300
#define GFX20_HS_INVOCATION_COUNT_length       2
struct GFX20_HS_INVOCATION_COUNT {
   uint64_t                             HSInvocationCountReport;
};

static inline __attribute__((always_inline)) void
GFX20_HS_INVOCATION_COUNT_pack(__attribute__((unused)) __gen_user_data *data,
                               __attribute__((unused)) void * restrict dst,
                               __attribute__((unused)) const struct GFX20_HS_INVOCATION_COUNT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   const uint64_t v0 =
      util_bitpack_uint(values->HSInvocationCountReport, 0, 63);
   dw[0] = v0;
   dw[1] = v0 >> 32;
}

#define GFX20_IA_PRIMITIVES_COUNT_num     0x2318
#define GFX20_IA_PRIMITIVES_COUNT_length       2
struct GFX20_IA_PRIMITIVES_COUNT {
   uint64_t                             IAPrimitivesCountReport;
};

static inline __attribute__((always_inline)) void
GFX20_IA_PRIMITIVES_COUNT_pack(__attribute__((unused)) __gen_user_data *data,
                               __attribute__((unused)) void * restrict dst,
                               __attribute__((unused)) const struct GFX20_IA_PRIMITIVES_COUNT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   const uint64_t v0 =
      util_bitpack_uint(values->IAPrimitivesCountReport, 0, 63);
   dw[0] = v0;
   dw[1] = v0 >> 32;
}

#define GFX20_IA_VERTICES_COUNT_num       0x2310
#define GFX20_IA_VERTICES_COUNT_length         2
struct GFX20_IA_VERTICES_COUNT {
   uint64_t                             IAVerticesCountReport;
};

static inline __attribute__((always_inline)) void
GFX20_IA_VERTICES_COUNT_pack(__attribute__((unused)) __gen_user_data *data,
                             __attribute__((unused)) void * restrict dst,
                             __attribute__((unused)) const struct GFX20_IA_VERTICES_COUNT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   const uint64_t v0 =
      util_bitpack_uint(values->IAVerticesCountReport, 0, 63);
   dw[0] = v0;
   dw[1] = v0 >> 32;
}

#define GFX20_INSTDONE_1_num              0x206c
#define GFX20_INSTDONE_1_length                1
struct GFX20_INSTDONE_1 {
   bool                                 PRB0RingEnable;
   bool                                 VFGDone;
   bool                                 VSDone;
   bool                                 HSDone;
   bool                                 TEDone;
   bool                                 DSDone;
   bool                                 GSDone;
   bool                                 SOLDone;
   bool                                 CLDone;
   bool                                 SFDone;
   bool                                 TDG1Done;
   bool                                 TDG0Done;
   bool                                 URBMDone;
   bool                                 SVGDone;
   bool                                 GAFSDone;
   bool                                 VFEDone;
   bool                                 TSG0Done;
   bool                                 GAFMDone;
   bool                                 GAMDone;
   bool                                 RSDone;
   bool                                 CSDone;
   bool                                 SDEDone;
   bool                                 RCCFBCCSDone;
   bool                                 TSG1Done;
};

static inline __attribute__((always_inline)) void
GFX20_INSTDONE_1_pack(__attribute__((unused)) __gen_user_data *data,
                      __attribute__((unused)) void * restrict dst,
                      __attribute__((unused)) const struct GFX20_INSTDONE_1 * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->PRB0RingEnable, 0, 0) |
      util_bitpack_uint(values->VFGDone, 1, 1) |
      util_bitpack_uint(values->VSDone, 2, 2) |
      util_bitpack_uint(values->HSDone, 3, 3) |
      util_bitpack_uint(values->TEDone, 4, 4) |
      util_bitpack_uint(values->DSDone, 5, 5) |
      util_bitpack_uint(values->GSDone, 6, 6) |
      util_bitpack_uint(values->SOLDone, 7, 7) |
      util_bitpack_uint(values->CLDone, 8, 8) |
      util_bitpack_uint(values->SFDone, 9, 9) |
      util_bitpack_uint(values->TDG1Done, 11, 11) |
      util_bitpack_uint(values->TDG0Done, 12, 12) |
      util_bitpack_uint(values->URBMDone, 13, 13) |
      util_bitpack_uint(values->SVGDone, 14, 14) |
      util_bitpack_uint(values->GAFSDone, 15, 15) |
      util_bitpack_uint(values->VFEDone, 16, 16) |
      util_bitpack_uint(values->TSG0Done, 17, 17) |
      util_bitpack_uint(values->GAFMDone, 18, 18) |
      util_bitpack_uint(values->GAMDone, 19, 19) |
      util_bitpack_uint(values->RSDone, 20, 20) |
      util_bitpack_uint(values->CSDone, 21, 21) |
      util_bitpack_uint(values->SDEDone, 22, 22) |
      util_bitpack_uint(values->RCCFBCCSDone, 23, 23) |
      util_bitpack_uint(values->TSG1Done, 24, 24);
}

#define GFX20_INSTDONE_GEOM_num           0x666c
#define GFX20_INSTDONE_GEOM_length             1
struct GFX20_INSTDONE_GEOM {
   bool                                 VFLDone;
   bool                                 VSDone;
   bool                                 HSDone;
   bool                                 TEDone;
   bool                                 DSDone;
   bool                                 GSDone;
   bool                                 SOLDone;
   bool                                 CLDone;
   bool                                 SFDone;
   bool                                 TDG1Done;
   bool                                 URBMDone;
   bool                                 SVGDone;
   bool                                 TSG0Done;
   bool                                 SDEDone;
};

static inline __attribute__((always_inline)) void
GFX20_INSTDONE_GEOM_pack(__attribute__((unused)) __gen_user_data *data,
                         __attribute__((unused)) void * restrict dst,
                         __attribute__((unused)) const struct GFX20_INSTDONE_GEOM * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->VFLDone, 1, 1) |
      util_bitpack_uint(values->VSDone, 2, 2) |
      util_bitpack_uint(values->HSDone, 3, 3) |
      util_bitpack_uint(values->TEDone, 4, 4) |
      util_bitpack_uint(values->DSDone, 5, 5) |
      util_bitpack_uint(values->GSDone, 6, 6) |
      util_bitpack_uint(values->SOLDone, 7, 7) |
      util_bitpack_uint(values->CLDone, 8, 8) |
      util_bitpack_uint(values->SFDone, 9, 9) |
      util_bitpack_uint(values->TDG1Done, 11, 11) |
      util_bitpack_uint(values->URBMDone, 13, 13) |
      util_bitpack_uint(values->SVGDone, 14, 14) |
      util_bitpack_uint(values->TSG0Done, 17, 17) |
      util_bitpack_uint(values->SDEDone, 22, 22);
}

#define GFX20_L3SQCREG5_num               0xb158
#define GFX20_L3SQCREG5_length                 1
struct GFX20_L3SQCREG5 {
   uint32_t                             L3CachePartialWriteMergeTimerInitialValue;
   uint32_t                             CompressiblePartialWriteMergeEnable;
   uint32_t                             CoherentPartialWriteMergeEnable;
   uint32_t                             CrossTilePartialWriteMergeEnable;
};

static inline __attribute__((always_inline)) void
GFX20_L3SQCREG5_pack(__attribute__((unused)) __gen_user_data *data,
                     __attribute__((unused)) void * restrict dst,
                     __attribute__((unused)) const struct GFX20_L3SQCREG5 * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->L3CachePartialWriteMergeTimerInitialValue, 0, 9) |
      util_bitpack_uint(values->CompressiblePartialWriteMergeEnable, 21, 21) |
      util_bitpack_uint(values->CoherentPartialWriteMergeEnable, 22, 22) |
      util_bitpack_uint(values->CrossTilePartialWriteMergeEnable, 23, 23);
}

#define GFX20_MESH_INVOCATION_COUNT_num   0x26e0
#define GFX20_MESH_INVOCATION_COUNT_length      2
struct GFX20_MESH_INVOCATION_COUNT {
   uint64_t                             MESHInvocationCounter;
};

static inline __attribute__((always_inline)) void
GFX20_MESH_INVOCATION_COUNT_pack(__attribute__((unused)) __gen_user_data *data,
                                 __attribute__((unused)) void * restrict dst,
                                 __attribute__((unused)) const struct GFX20_MESH_INVOCATION_COUNT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   const uint64_t v0 =
      util_bitpack_uint(values->MESHInvocationCounter, 0, 63);
   dw[0] = v0;
   dw[1] = v0 >> 32;
}

#define GFX20_MESH_PRIMITIVE_COUNT_num    0x26d8
#define GFX20_MESH_PRIMITIVE_COUNT_length      2
struct GFX20_MESH_PRIMITIVE_COUNT {
   uint64_t                             MESHPrimitiveCounter;
};

static inline __attribute__((always_inline)) void
GFX20_MESH_PRIMITIVE_COUNT_pack(__attribute__((unused)) __gen_user_data *data,
                                __attribute__((unused)) void * restrict dst,
                                __attribute__((unused)) const struct GFX20_MESH_PRIMITIVE_COUNT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   const uint64_t v0 =
      util_bitpack_uint(values->MESHPrimitiveCounter, 0, 63);
   dw[0] = v0;
   dw[1] = v0 >> 32;
}

#define GFX20_PS_INVOCATION_COUNT_num     0x2348
#define GFX20_PS_INVOCATION_COUNT_length       2
struct GFX20_PS_INVOCATION_COUNT {
   uint64_t                             PSInvocationCountReport;
};

static inline __attribute__((always_inline)) void
GFX20_PS_INVOCATION_COUNT_pack(__attribute__((unused)) __gen_user_data *data,
                               __attribute__((unused)) void * restrict dst,
                               __attribute__((unused)) const struct GFX20_PS_INVOCATION_COUNT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   const uint64_t v0 =
      util_bitpack_uint(values->PSInvocationCountReport, 0, 63);
   dw[0] = v0;
   dw[1] = v0 >> 32;
}

#define GFX20_ROW_INSTDONE_num            0xe164
#define GFX20_ROW_INSTDONE_length              1
struct GFX20_ROW_INSTDONE {
   bool                                 BCDone;
   bool                                 PSDDone;
   bool                                 TDPDone;
   bool                                 DAPRDone;
   bool                                 CPSSDone;
   bool                                 RTDONERENDER;
   bool                                 TDLDone;
   bool                                 EU00doneSS1;
   bool                                 EU01doneSS1;
   bool                                 EU02doneSS1;
   bool                                 EU03doneSS1;
   bool                                 MA0doneSS1;
   bool                                 ICDone;
   bool                                 BTDDONERENDER;
   bool                                 RTDONECOMPUTE;
   bool                                 MA0DoneSS0;
   bool                                 EU00DoneSS0;
   bool                                 EU01DoneSS0;
   bool                                 EU02DoneSS0;
   bool                                 EU03DoneSS0;
   bool                                 BTDDONECOMPUTE;
   bool                                 EU10DoneSS0;
   bool                                 EU11DoneSS0;
   bool                                 EU12DoneSS0;
   bool                                 EU13DoneSS0;
   bool                                 TSLDone;
   bool                                 EU10DoneSS1;
   bool                                 EU11DoneSS1;
   bool                                 EU12DoneSS1;
   bool                                 EU13DoneSS1;
};

static inline __attribute__((always_inline)) void
GFX20_ROW_INSTDONE_pack(__attribute__((unused)) __gen_user_data *data,
                        __attribute__((unused)) void * restrict dst,
                        __attribute__((unused)) const struct GFX20_ROW_INSTDONE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->BCDone, 0, 0) |
      util_bitpack_uint(values->PSDDone, 1, 1) |
      util_bitpack_uint(values->TDPDone, 2, 2) |
      util_bitpack_uint(values->DAPRDone, 3, 3) |
      util_bitpack_uint(values->CPSSDone, 4, 4) |
      util_bitpack_uint(values->RTDONERENDER, 5, 5) |
      util_bitpack_uint(values->TDLDone, 6, 6) |
      util_bitpack_uint(values->EU00doneSS1, 7, 7) |
      util_bitpack_uint(values->EU01doneSS1, 8, 8) |
      util_bitpack_uint(values->EU02doneSS1, 9, 9) |
      util_bitpack_uint(values->EU03doneSS1, 10, 10) |
      util_bitpack_uint(values->MA0doneSS1, 11, 11) |
      util_bitpack_uint(values->ICDone, 12, 12) |
      util_bitpack_uint(values->BTDDONERENDER, 13, 13) |
      util_bitpack_uint(values->RTDONECOMPUTE, 14, 14) |
      util_bitpack_uint(values->MA0DoneSS0, 15, 15) |
      util_bitpack_uint(values->EU00DoneSS0, 16, 16) |
      util_bitpack_uint(values->EU01DoneSS0, 17, 17) |
      util_bitpack_uint(values->EU02DoneSS0, 18, 18) |
      util_bitpack_uint(values->EU03DoneSS0, 19, 19) |
      util_bitpack_uint(values->BTDDONECOMPUTE, 20, 20) |
      util_bitpack_uint(values->EU10DoneSS0, 21, 21) |
      util_bitpack_uint(values->EU11DoneSS0, 22, 22) |
      util_bitpack_uint(values->EU12DoneSS0, 23, 23) |
      util_bitpack_uint(values->EU13DoneSS0, 24, 24) |
      util_bitpack_uint(values->TSLDone, 26, 26) |
      util_bitpack_uint(values->EU10DoneSS1, 27, 27) |
      util_bitpack_uint(values->EU11DoneSS1, 28, 28) |
      util_bitpack_uint(values->EU12DoneSS1, 29, 29) |
      util_bitpack_uint(values->EU13DoneSS1, 30, 30);
}

#define GFX20_RPSTAT0_num                 0xa01c
#define GFX20_RPSTAT0_length                   1
struct GFX20_RPSTAT0 {
   uint32_t                             PreviousGTFrequency;
   uint32_t                             CurrentGTFrequency;
};

static inline __attribute__((always_inline)) void
GFX20_RPSTAT0_pack(__attribute__((unused)) __gen_user_data *data,
                   __attribute__((unused)) void * restrict dst,
                   __attribute__((unused)) const struct GFX20_RPSTAT0 * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->PreviousGTFrequency, 0, 8) |
      util_bitpack_uint(values->CurrentGTFrequency, 23, 31);
}

#define GFX20_SAMPLER_INSTDONE_num        0xe160
#define GFX20_SAMPLER_INSTDONE_length          1
struct GFX20_SAMPLER_INSTDONE {
   bool                                 SIDone;
   bool                                 SVSMADAPTERDone;
   bool                                 SVSMARBDone;
   bool                                 SVSMDone;
   bool                                 PLDone;
   bool                                 DGDone;
   bool                                 SSLADone;
   bool                                 STARBDone;
   bool                                 STDone;
   bool                                 FTDone;
   bool                                 MTDone;
   bool                                 DMDone;
   bool                                 BDMDone;
   bool                                 SCDone;
   bool                                 FLDone;
   bool                                 SODone;
   bool                                 LSCL1BANK0Idle;
   bool                                 LSCL1BANK1Idle;
   bool                                 LSCL1BANK2Idle;
   bool                                 LSCL1BANK3Idle;
   bool                                 LSCSEQ0Idle;
   bool                                 LSCSEQ1Idle;
   bool                                 LSCSEQ2Idle;
   bool                                 LSCSEQ3Idle;
   bool                                 LSCSEQINTFIdle;
   bool                                 LSCL3INTFIdle;
   bool                                 VMEMSOARB0Done;
   bool                                 VMEMSOARB1Done;
   bool                                 VMEML3REQARB0Done;
   bool                                 VMEML3REQARB1Done;
};

static inline __attribute__((always_inline)) void
GFX20_SAMPLER_INSTDONE_pack(__attribute__((unused)) __gen_user_data *data,
                            __attribute__((unused)) void * restrict dst,
                            __attribute__((unused)) const struct GFX20_SAMPLER_INSTDONE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->SIDone, 0, 0) |
      util_bitpack_uint(values->SVSMADAPTERDone, 1, 1) |
      util_bitpack_uint(values->SVSMARBDone, 2, 2) |
      util_bitpack_uint(values->SVSMDone, 3, 3) |
      util_bitpack_uint(values->PLDone, 4, 4) |
      util_bitpack_uint(values->DGDone, 5, 5) |
      util_bitpack_uint(values->SSLADone, 6, 6) |
      util_bitpack_uint(values->STARBDone, 7, 7) |
      util_bitpack_uint(values->STDone, 8, 8) |
      util_bitpack_uint(values->FTDone, 9, 9) |
      util_bitpack_uint(values->MTDone, 11, 11) |
      util_bitpack_uint(values->DMDone, 12, 12) |
      util_bitpack_uint(values->BDMDone, 13, 13) |
      util_bitpack_uint(values->SCDone, 14, 14) |
      util_bitpack_uint(values->FLDone, 15, 15) |
      util_bitpack_uint(values->SODone, 16, 16) |
      util_bitpack_uint(values->LSCL1BANK0Idle, 18, 18) |
      util_bitpack_uint(values->LSCL1BANK1Idle, 19, 19) |
      util_bitpack_uint(values->LSCL1BANK2Idle, 20, 20) |
      util_bitpack_uint(values->LSCL1BANK3Idle, 21, 21) |
      util_bitpack_uint(values->LSCSEQ0Idle, 22, 22) |
      util_bitpack_uint(values->LSCSEQ1Idle, 23, 23) |
      util_bitpack_uint(values->LSCSEQ2Idle, 24, 24) |
      util_bitpack_uint(values->LSCSEQ3Idle, 25, 25) |
      util_bitpack_uint(values->LSCSEQINTFIdle, 26, 26) |
      util_bitpack_uint(values->LSCL3INTFIdle, 27, 27) |
      util_bitpack_uint(values->VMEMSOARB0Done, 28, 28) |
      util_bitpack_uint(values->VMEMSOARB1Done, 29, 29) |
      util_bitpack_uint(values->VMEML3REQARB0Done, 30, 30) |
      util_bitpack_uint(values->VMEML3REQARB1Done, 31, 31);
}

#define GFX20_SC_INSTDONE_num             0x7100
#define GFX20_SC_INSTDONE_length               1
struct GFX20_SC_INSTDONE {
   bool                                 SVLDone;
   bool                                 WMFEDone;
   bool                                 WMBEDone;
   bool                                 HIZDone;
   bool                                 IZFEDone;
   bool                                 SBEDone;
   bool                                 RCCDone;
   bool                                 RCPBEDone;
   bool                                 RCPFEDone;
   bool                                 DAPBDone;
   bool                                 DAPRBEDone;
   bool                                 SARBDone;
   bool                                 DC0Done;
   bool                                 DC1Done;
   bool                                 DC2Done;
   bool                                 DC3Done;
   bool                                 GW0Done;
   bool                                 GW1Done;
   bool                                 GW2Done;
   bool                                 GW3Done;
   bool                                 TDCDone;
   bool                                 SFBEDone;
   bool                                 PSSDone;
   bool                                 AMFSDone;
};

static inline __attribute__((always_inline)) void
GFX20_SC_INSTDONE_pack(__attribute__((unused)) __gen_user_data *data,
                       __attribute__((unused)) void * restrict dst,
                       __attribute__((unused)) const struct GFX20_SC_INSTDONE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->SVLDone, 0, 0) |
      util_bitpack_uint(values->WMFEDone, 1, 1) |
      util_bitpack_uint(values->WMBEDone, 2, 2) |
      util_bitpack_uint(values->HIZDone, 3, 3) |
      util_bitpack_uint(values->IZFEDone, 5, 5) |
      util_bitpack_uint(values->SBEDone, 6, 6) |
      util_bitpack_uint(values->RCCDone, 9, 9) |
      util_bitpack_uint(values->RCPBEDone, 10, 10) |
      util_bitpack_uint(values->RCPFEDone, 11, 11) |
      util_bitpack_uint(values->DAPBDone, 12, 12) |
      util_bitpack_uint(values->DAPRBEDone, 13, 13) |
      util_bitpack_uint(values->SARBDone, 15, 15) |
      util_bitpack_uint(values->DC0Done, 16, 16) |
      util_bitpack_uint(values->DC1Done, 17, 17) |
      util_bitpack_uint(values->DC2Done, 18, 18) |
      util_bitpack_uint(values->DC3Done, 19, 19) |
      util_bitpack_uint(values->GW0Done, 20, 20) |
      util_bitpack_uint(values->GW1Done, 21, 21) |
      util_bitpack_uint(values->GW2Done, 22, 22) |
      util_bitpack_uint(values->GW3Done, 23, 23) |
      util_bitpack_uint(values->TDCDone, 24, 24) |
      util_bitpack_uint(values->SFBEDone, 25, 25) |
      util_bitpack_uint(values->PSSDone, 26, 26) |
      util_bitpack_uint(values->AMFSDone, 27, 27);
}

#define GFX20_SC_INSTDONE_EXTRA_num       0x7104
#define GFX20_SC_INSTDONE_EXTRA_length         1
struct GFX20_SC_INSTDONE_EXTRA {
   bool                                 RCC1Done;
   bool                                 RCPBE1Done;
   bool                                 RCPFE1Done;
   bool                                 DAPB1Done;
   bool                                 DAPRBE1Done;
   bool                                 DC4Done;
   bool                                 DC5Done;
   bool                                 DC6Done;
   bool                                 DC7Done;
   bool                                 GW4Done;
   bool                                 GW5Done;
   bool                                 GW6Done;
   bool                                 GW7Done;
   bool                                 TDC1Done;
   bool                                 PSSDone;
};

static inline __attribute__((always_inline)) void
GFX20_SC_INSTDONE_EXTRA_pack(__attribute__((unused)) __gen_user_data *data,
                             __attribute__((unused)) void * restrict dst,
                             __attribute__((unused)) const struct GFX20_SC_INSTDONE_EXTRA * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->RCC1Done, 9, 9) |
      util_bitpack_uint(values->RCPBE1Done, 10, 10) |
      util_bitpack_uint(values->RCPFE1Done, 11, 11) |
      util_bitpack_uint(values->DAPB1Done, 12, 12) |
      util_bitpack_uint(values->DAPRBE1Done, 13, 13) |
      util_bitpack_uint(values->DC4Done, 16, 16) |
      util_bitpack_uint(values->DC5Done, 17, 17) |
      util_bitpack_uint(values->DC6Done, 18, 18) |
      util_bitpack_uint(values->DC7Done, 19, 19) |
      util_bitpack_uint(values->GW4Done, 20, 20) |
      util_bitpack_uint(values->GW5Done, 21, 21) |
      util_bitpack_uint(values->GW6Done, 22, 22) |
      util_bitpack_uint(values->GW7Done, 23, 23) |
      util_bitpack_uint(values->TDC1Done, 24, 24) |
      util_bitpack_uint(values->PSSDone, 26, 26);
}

#define GFX20_SC_INSTDONE_EXTRA2_num      0x7108
#define GFX20_SC_INSTDONE_EXTRA2_length        1
struct GFX20_SC_INSTDONE_EXTRA2 {
   bool                                 RCC2Done;
   bool                                 RCPBE2Done;
   bool                                 RCPFE2Done;
   bool                                 DAPB2Done;
   bool                                 DAPRBE2Done;
};

static inline __attribute__((always_inline)) void
GFX20_SC_INSTDONE_EXTRA2_pack(__attribute__((unused)) __gen_user_data *data,
                              __attribute__((unused)) void * restrict dst,
                              __attribute__((unused)) const struct GFX20_SC_INSTDONE_EXTRA2 * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->RCC2Done, 9, 9) |
      util_bitpack_uint(values->RCPBE2Done, 10, 10) |
      util_bitpack_uint(values->RCPFE2Done, 11, 11) |
      util_bitpack_uint(values->DAPB2Done, 12, 12) |
      util_bitpack_uint(values->DAPRBE2Done, 13, 13);
}

#define GFX20_SLICE_COMMON_ECO_CHICKEN1_num 0x731c
#define GFX20_SLICE_COMMON_ECO_CHICKEN1_length      1
struct GFX20_SLICE_COMMON_ECO_CHICKEN1 {
   bool                                 StateCacheRedirectToCSSectionEnable;
   bool                                 StateCacheRedirectToCSSectionEnableMask;
};

static inline __attribute__((always_inline)) void
GFX20_SLICE_COMMON_ECO_CHICKEN1_pack(__attribute__((unused)) __gen_user_data *data,
                                     __attribute__((unused)) void * restrict dst,
                                     __attribute__((unused)) const struct GFX20_SLICE_COMMON_ECO_CHICKEN1 * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->StateCacheRedirectToCSSectionEnable, 11, 11) |
      util_bitpack_uint(values->StateCacheRedirectToCSSectionEnableMask, 27, 27);
}

#define GFX20_SO_NUM_PRIMS_WRITTEN0_num   0x5200
#define GFX20_SO_NUM_PRIMS_WRITTEN0_length      2
struct GFX20_SO_NUM_PRIMS_WRITTEN0 {
   uint64_t                             NumPrimsWrittenCount;
};

static inline __attribute__((always_inline)) void
GFX20_SO_NUM_PRIMS_WRITTEN0_pack(__attribute__((unused)) __gen_user_data *data,
                                 __attribute__((unused)) void * restrict dst,
                                 __attribute__((unused)) const struct GFX20_SO_NUM_PRIMS_WRITTEN0 * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   const uint64_t v0 =
      util_bitpack_uint(values->NumPrimsWrittenCount, 0, 63);
   dw[0] = v0;
   dw[1] = v0 >> 32;
}

#define GFX20_SO_NUM_PRIMS_WRITTEN1_num   0x5208
#define GFX20_SO_NUM_PRIMS_WRITTEN1_length      2
struct GFX20_SO_NUM_PRIMS_WRITTEN1 {
   uint64_t                             NumPrimsWrittenCount;
};

static inline __attribute__((always_inline)) void
GFX20_SO_NUM_PRIMS_WRITTEN1_pack(__attribute__((unused)) __gen_user_data *data,
                                 __attribute__((unused)) void * restrict dst,
                                 __attribute__((unused)) const struct GFX20_SO_NUM_PRIMS_WRITTEN1 * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   const uint64_t v0 =
      util_bitpack_uint(values->NumPrimsWrittenCount, 0, 63);
   dw[0] = v0;
   dw[1] = v0 >> 32;
}

#define GFX20_SO_NUM_PRIMS_WRITTEN2_num   0x5210
#define GFX20_SO_NUM_PRIMS_WRITTEN2_length      2
struct GFX20_SO_NUM_PRIMS_WRITTEN2 {
   uint64_t                             NumPrimsWrittenCount;
};

static inline __attribute__((always_inline)) void
GFX20_SO_NUM_PRIMS_WRITTEN2_pack(__attribute__((unused)) __gen_user_data *data,
                                 __attribute__((unused)) void * restrict dst,
                                 __attribute__((unused)) const struct GFX20_SO_NUM_PRIMS_WRITTEN2 * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   const uint64_t v0 =
      util_bitpack_uint(values->NumPrimsWrittenCount, 0, 63);
   dw[0] = v0;
   dw[1] = v0 >> 32;
}

#define GFX20_SO_NUM_PRIMS_WRITTEN3_num   0x5218
#define GFX20_SO_NUM_PRIMS_WRITTEN3_length      2
struct GFX20_SO_NUM_PRIMS_WRITTEN3 {
   uint64_t                             NumPrimsWrittenCount;
};

static inline __attribute__((always_inline)) void
GFX20_SO_NUM_PRIMS_WRITTEN3_pack(__attribute__((unused)) __gen_user_data *data,
                                 __attribute__((unused)) void * restrict dst,
                                 __attribute__((unused)) const struct GFX20_SO_NUM_PRIMS_WRITTEN3 * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   const uint64_t v0 =
      util_bitpack_uint(values->NumPrimsWrittenCount, 0, 63);
   dw[0] = v0;
   dw[1] = v0 >> 32;
}

#define GFX20_SO_PRIM_STORAGE_NEEDED0_num 0x5240
#define GFX20_SO_PRIM_STORAGE_NEEDED0_length      2
struct GFX20_SO_PRIM_STORAGE_NEEDED0 {
   uint64_t                             PrimStorageNeededCount;
};

static inline __attribute__((always_inline)) void
GFX20_SO_PRIM_STORAGE_NEEDED0_pack(__attribute__((unused)) __gen_user_data *data,
                                   __attribute__((unused)) void * restrict dst,
                                   __attribute__((unused)) const struct GFX20_SO_PRIM_STORAGE_NEEDED0 * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   const uint64_t v0 =
      util_bitpack_uint(values->PrimStorageNeededCount, 0, 63);
   dw[0] = v0;
   dw[1] = v0 >> 32;
}

#define GFX20_SO_PRIM_STORAGE_NEEDED1_num 0x5248
#define GFX20_SO_PRIM_STORAGE_NEEDED1_length      2
struct GFX20_SO_PRIM_STORAGE_NEEDED1 {
   uint64_t                             PrimStorageNeededCount;
};

static inline __attribute__((always_inline)) void
GFX20_SO_PRIM_STORAGE_NEEDED1_pack(__attribute__((unused)) __gen_user_data *data,
                                   __attribute__((unused)) void * restrict dst,
                                   __attribute__((unused)) const struct GFX20_SO_PRIM_STORAGE_NEEDED1 * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   const uint64_t v0 =
      util_bitpack_uint(values->PrimStorageNeededCount, 0, 63);
   dw[0] = v0;
   dw[1] = v0 >> 32;
}

#define GFX20_SO_PRIM_STORAGE_NEEDED2_num 0x5250
#define GFX20_SO_PRIM_STORAGE_NEEDED2_length      2
struct GFX20_SO_PRIM_STORAGE_NEEDED2 {
   uint64_t                             PrimStorageNeededCount;
};

static inline __attribute__((always_inline)) void
GFX20_SO_PRIM_STORAGE_NEEDED2_pack(__attribute__((unused)) __gen_user_data *data,
                                   __attribute__((unused)) void * restrict dst,
                                   __attribute__((unused)) const struct GFX20_SO_PRIM_STORAGE_NEEDED2 * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   const uint64_t v0 =
      util_bitpack_uint(values->PrimStorageNeededCount, 0, 63);
   dw[0] = v0;
   dw[1] = v0 >> 32;
}

#define GFX20_SO_PRIM_STORAGE_NEEDED3_num 0x5258
#define GFX20_SO_PRIM_STORAGE_NEEDED3_length      2
struct GFX20_SO_PRIM_STORAGE_NEEDED3 {
   uint64_t                             PrimStorageNeededCount;
};

static inline __attribute__((always_inline)) void
GFX20_SO_PRIM_STORAGE_NEEDED3_pack(__attribute__((unused)) __gen_user_data *data,
                                   __attribute__((unused)) void * restrict dst,
                                   __attribute__((unused)) const struct GFX20_SO_PRIM_STORAGE_NEEDED3 * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   const uint64_t v0 =
      util_bitpack_uint(values->PrimStorageNeededCount, 0, 63);
   dw[0] = v0;
   dw[1] = v0 >> 32;
}

#define GFX20_SO_WRITE_OFFSET0_num        0x5280
#define GFX20_SO_WRITE_OFFSET0_length          1
struct GFX20_SO_WRITE_OFFSET0 {
   uint64_t                             WriteOffset;
};

static inline __attribute__((always_inline)) void
GFX20_SO_WRITE_OFFSET0_pack(__attribute__((unused)) __gen_user_data *data,
                            __attribute__((unused)) void * restrict dst,
                            __attribute__((unused)) const struct GFX20_SO_WRITE_OFFSET0 * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      __gen_offset(values->WriteOffset, 2, 31);
}

#define GFX20_SO_WRITE_OFFSET1_num        0x5284
#define GFX20_SO_WRITE_OFFSET1_length          1
struct GFX20_SO_WRITE_OFFSET1 {
   uint64_t                             WriteOffset;
};

static inline __attribute__((always_inline)) void
GFX20_SO_WRITE_OFFSET1_pack(__attribute__((unused)) __gen_user_data *data,
                            __attribute__((unused)) void * restrict dst,
                            __attribute__((unused)) const struct GFX20_SO_WRITE_OFFSET1 * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      __gen_offset(values->WriteOffset, 2, 31);
}

#define GFX20_SO_WRITE_OFFSET2_num        0x5288
#define GFX20_SO_WRITE_OFFSET2_length          1
struct GFX20_SO_WRITE_OFFSET2 {
   uint64_t                             WriteOffset;
};

static inline __attribute__((always_inline)) void
GFX20_SO_WRITE_OFFSET2_pack(__attribute__((unused)) __gen_user_data *data,
                            __attribute__((unused)) void * restrict dst,
                            __attribute__((unused)) const struct GFX20_SO_WRITE_OFFSET2 * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      __gen_offset(values->WriteOffset, 2, 31);
}

#define GFX20_SO_WRITE_OFFSET3_num        0x528c
#define GFX20_SO_WRITE_OFFSET3_length          1
struct GFX20_SO_WRITE_OFFSET3 {
   uint64_t                             WriteOffset;
};

static inline __attribute__((always_inline)) void
GFX20_SO_WRITE_OFFSET3_pack(__attribute__((unused)) __gen_user_data *data,
                            __attribute__((unused)) void * restrict dst,
                            __attribute__((unused)) const struct GFX20_SO_WRITE_OFFSET3 * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      __gen_offset(values->WriteOffset, 2, 31);
}

#define GFX20_TASK_INVOCATION_COUNT_num   0x26e8
#define GFX20_TASK_INVOCATION_COUNT_length      2
struct GFX20_TASK_INVOCATION_COUNT {
   uint64_t                             TASKInvocationCounter;
};

static inline __attribute__((always_inline)) void
GFX20_TASK_INVOCATION_COUNT_pack(__attribute__((unused)) __gen_user_data *data,
                                 __attribute__((unused)) void * restrict dst,
                                 __attribute__((unused)) const struct GFX20_TASK_INVOCATION_COUNT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   const uint64_t v0 =
      util_bitpack_uint(values->TASKInvocationCounter, 0, 63);
   dw[0] = v0;
   dw[1] = v0 >> 32;
}

#define GFX20_VCS_INSTDONE_num            0x1206c
#define GFX20_VCS_INSTDONE_length              1
struct GFX20_VCS_INSTDONE {
   bool                                 RingEnable;
   bool                                 USBDone;
   bool                                 QRCDone;
   bool                                 SECDone;
   bool                                 MPCDone;
   bool                                 VFTDone;
   bool                                 BSPDone;
   bool                                 VLFDone;
   bool                                 VOPDone;
   bool                                 VMCDone;
   bool                                 VIPDone;
   bool                                 VITDone;
   bool                                 VDSDone;
   bool                                 VMXDone;
   bool                                 VCPDone;
   bool                                 VCDDone;
   bool                                 VADDone;
   bool                                 VMDDone;
   bool                                 VISDone;
   bool                                 VACDone;
   bool                                 VAMDone;
   bool                                 JPGDone;
   bool                                 VBPDone;
   bool                                 VHRDone;
   bool                                 VCIDone;
   bool                                 VINDone;
   bool                                 VPRDone;
   bool                                 VTQDone;
   bool                                 Reserved;
   bool                                 VCSDone;
   bool                                 GACDone;
};

static inline __attribute__((always_inline)) void
GFX20_VCS_INSTDONE_pack(__attribute__((unused)) __gen_user_data *data,
                        __attribute__((unused)) void * restrict dst,
                        __attribute__((unused)) const struct GFX20_VCS_INSTDONE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->RingEnable, 0, 0) |
      util_bitpack_uint(values->USBDone, 1, 1) |
      util_bitpack_uint(values->QRCDone, 2, 2) |
      util_bitpack_uint(values->SECDone, 3, 3) |
      util_bitpack_uint(values->MPCDone, 4, 4) |
      util_bitpack_uint(values->VFTDone, 5, 5) |
      util_bitpack_uint(values->BSPDone, 6, 6) |
      util_bitpack_uint(values->VLFDone, 7, 7) |
      util_bitpack_uint(values->VOPDone, 8, 8) |
      util_bitpack_uint(values->VMCDone, 9, 9) |
      util_bitpack_uint(values->VIPDone, 10, 10) |
      util_bitpack_uint(values->VITDone, 11, 11) |
      util_bitpack_uint(values->VDSDone, 12, 12) |
      util_bitpack_uint(values->VMXDone, 13, 13) |
      util_bitpack_uint(values->VCPDone, 14, 14) |
      util_bitpack_uint(values->VCDDone, 15, 15) |
      util_bitpack_uint(values->VADDone, 16, 16) |
      util_bitpack_uint(values->VMDDone, 17, 17) |
      util_bitpack_uint(values->VISDone, 18, 18) |
      util_bitpack_uint(values->VACDone, 19, 19) |
      util_bitpack_uint(values->VAMDone, 20, 20) |
      util_bitpack_uint(values->JPGDone, 21, 21) |
      util_bitpack_uint(values->VBPDone, 22, 22) |
      util_bitpack_uint(values->VHRDone, 23, 23) |
      util_bitpack_uint(values->VCIDone, 24, 24) |
      util_bitpack_uint(values->VINDone, 26, 26) |
      util_bitpack_uint(values->VPRDone, 27, 27) |
      util_bitpack_uint(values->VTQDone, 28, 28) |
      util_bitpack_uint(values->Reserved, 29, 29) |
      util_bitpack_uint(values->VCSDone, 30, 30) |
      util_bitpack_uint(values->GACDone, 31, 31);
}

#define GFX20_VD0_AUX_TABLE_BASE_ADDR_num 0x4210
#define GFX20_VD0_AUX_TABLE_BASE_ADDR_length      2
struct GFX20_VD0_AUX_TABLE_BASE_ADDR {
   uint64_t                             Address;
};

static inline __attribute__((always_inline)) void
GFX20_VD0_AUX_TABLE_BASE_ADDR_pack(__attribute__((unused)) __gen_user_data *data,
                                   __attribute__((unused)) void * restrict dst,
                                   __attribute__((unused)) const struct GFX20_VD0_AUX_TABLE_BASE_ADDR * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   const uint64_t v0 =
      util_bitpack_uint(values->Address, 0, 63);
   dw[0] = v0;
   dw[1] = v0 >> 32;
}

#define GFX20_VD0_CCS_AUX_INV_num         0x4218
#define GFX20_VD0_CCS_AUX_INV_length           1
struct GFX20_VD0_CCS_AUX_INV {
   bool                                 AuxInv;
};

static inline __attribute__((always_inline)) void
GFX20_VD0_CCS_AUX_INV_pack(__attribute__((unused)) __gen_user_data *data,
                           __attribute__((unused)) void * restrict dst,
                           __attribute__((unused)) const struct GFX20_VD0_CCS_AUX_INV * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->AuxInv, 0, 0);
}

#define GFX20_VFL_SCRATCH_PAD_num         0x62a8
#define GFX20_VFL_SCRATCH_PAD_length           1
struct GFX20_VFL_SCRATCH_PAD {
   uint32_t                             AutostripDisable;
   uint32_t                             PartialAutostripDisable;
   bool                                 AutostripDisableMask;
   bool                                 PartialAutostripDisableMask;
};

static inline __attribute__((always_inline)) void
GFX20_VFL_SCRATCH_PAD_pack(__attribute__((unused)) __gen_user_data *data,
                           __attribute__((unused)) void * restrict dst,
                           __attribute__((unused)) const struct GFX20_VFL_SCRATCH_PAD * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->AutostripDisable, 6, 6) |
      util_bitpack_uint(values->PartialAutostripDisable, 9, 9) |
      util_bitpack_uint(values->AutostripDisableMask, 22, 22) |
      util_bitpack_uint(values->PartialAutostripDisableMask, 25, 25);
}

#define GFX20_VS_INVOCATION_COUNT_num     0x2320
#define GFX20_VS_INVOCATION_COUNT_length       2
struct GFX20_VS_INVOCATION_COUNT {
   uint64_t                             VSInvocationCountReport;
};

static inline __attribute__((always_inline)) void
GFX20_VS_INVOCATION_COUNT_pack(__attribute__((unused)) __gen_user_data *data,
                               __attribute__((unused)) void * restrict dst,
                               __attribute__((unused)) const struct GFX20_VS_INVOCATION_COUNT * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   const uint64_t v0 =
      util_bitpack_uint(values->VSInvocationCountReport, 0, 63);
   dw[0] = v0;
   dw[1] = v0 >> 32;
}

#endif /* GFX20_XE2_PACK_H */
