/* Connection.c generated by valac 0.56.18, the Vala compiler
 * generated from Connection.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <cairo-gobject.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <libxml/tree.h>
#include <pango/pango.h>
#include <glib/gi18n-lib.h>
#include <granite.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	CONN_MODE_NONE = 0,
	CONN_MODE_LINKING,
	CONN_MODE_CONNECTING,
	CONN_MODE_SELECTED,
	CONN_MODE_ADJUSTING,
	CONN_MODE_EDITABLE,
	CONN_MODE_DROPPABLE
} ConnMode;

#define TYPE_CONN_MODE (conn_mode_get_type ())

#define TYPE_CONNECTION (connection_get_type ())
#define CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONNECTION, Connection))
#define CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONNECTION, ConnectionClass))
#define IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONNECTION))
#define IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONNECTION))
#define CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONNECTION, ConnectionClass))

typedef struct _Connection Connection;
typedef struct _ConnectionClass ConnectionClass;
typedef struct _ConnectionPrivate ConnectionPrivate;

#define TYPE_THEME (theme_get_type ())
#define THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME, Theme))
#define THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME, ThemeClass))
#define IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME))
#define IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME))
#define THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME, ThemeClass))

typedef struct _Theme Theme;
typedef struct _ThemeClass ThemeClass;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_NODE (node_get_type ())
#define NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE, Node))
#define NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE, NodeClass))
#define IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE))
#define IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE))
#define NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE, NodeClass))

typedef struct _Node Node;
typedef struct _NodeClass NodeClass;

#define TYPE_STYLE (style_get_type ())
#define STYLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STYLE, Style))
#define STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STYLE, StyleClass))
#define IS_STYLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STYLE))
#define IS_STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STYLE))
#define STYLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STYLE, StyleClass))

typedef struct _Style Style;
typedef struct _StyleClass StyleClass;

#define TYPE_BEZIER (bezier_get_type ())
#define BEZIER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BEZIER, Bezier))
#define BEZIER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BEZIER, BezierClass))
#define IS_BEZIER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BEZIER))
#define IS_BEZIER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BEZIER))
#define BEZIER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BEZIER, BezierClass))

typedef struct _Bezier Bezier;
typedef struct _BezierClass BezierClass;

#define TYPE_CANVAS_TEXT (canvas_text_get_type ())
#define CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANVAS_TEXT, CanvasText))
#define CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANVAS_TEXT, CanvasTextClass))
#define IS_CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANVAS_TEXT))
#define IS_CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANVAS_TEXT))
#define CANVAS_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANVAS_TEXT, CanvasTextClass))

typedef struct _CanvasText CanvasText;
typedef struct _CanvasTextClass CanvasTextClass;
enum  {
	CONNECTION_0_PROPERTY,
	CONNECTION_TITLE_PROPERTY,
	CONNECTION_NOTE_PROPERTY,
	CONNECTION_MODE_PROPERTY,
	CONNECTION_FROM_NODE_PROPERTY,
	CONNECTION_TO_NODE_PROPERTY,
	CONNECTION_STYLE_PROPERTY,
	CONNECTION_ALPHA_PROPERTY,
	CONNECTION_COLOR_PROPERTY,
	CONNECTION_STICKER_PROPERTY,
	CONNECTION_EXTENT_X1_PROPERTY,
	CONNECTION_EXTENT_Y1_PROPERTY,
	CONNECTION_EXTENT_X2_PROPERTY,
	CONNECTION_EXTENT_Y2_PROPERTY,
	CONNECTION_NUM_PROPERTIES
};
static GParamSpec* connection_properties[CONNECTION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _style_unref0(var) ((var == NULL) ? NULL : (var = (style_unref (var), NULL)))
#define _bezier_unref0(var) ((var == NULL) ? NULL : (var = (bezier_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GdkRGBA_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkRGBA_free (var), NULL)))

#define TYPE_STYLES (styles_get_type ())
#define STYLES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STYLES, Styles))
#define STYLES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STYLES, StylesClass))
#define IS_STYLES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STYLES))
#define IS_STYLES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STYLES))
#define STYLES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STYLES, StylesClass))

typedef struct _Styles Styles;
typedef struct _StylesClass StylesClass;

#define TYPE_FORMATTED_TEXT (formatted_text_get_type ())
#define FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FORMATTED_TEXT, FormattedText))
#define FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FORMATTED_TEXT, FormattedTextClass))
#define IS_FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FORMATTED_TEXT))
#define IS_FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FORMATTED_TEXT))
#define FORMATTED_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FORMATTED_TEXT, FormattedTextClass))

typedef struct _FormattedText FormattedText;
typedef struct _FormattedTextClass FormattedTextClass;

#define TYPE_SELECTION (selection_get_type ())
#define SELECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SELECTION, Selection))
#define SELECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SELECTION, SelectionClass))
#define IS_SELECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SELECTION))
#define IS_SELECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SELECTION))
#define SELECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SELECTION, SelectionClass))

typedef struct _Selection Selection;
typedef struct _SelectionClass SelectionClass;
#define _selection_unref0(var) ((var == NULL) ? NULL : (var = (selection_unref (var), NULL)))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
typedef enum  {
	SEARCH_OPTIONS_NODES,
	SEARCH_OPTIONS_CONNECTIONS,
	SEARCH_OPTIONS_CALLOUTS,
	SEARCH_OPTIONS_GROUPS,
	SEARCH_OPTIONS_TITLES,
	SEARCH_OPTIONS_NOTES,
	SEARCH_OPTIONS_FOLDED,
	SEARCH_OPTIONS_UNFOLDED,
	SEARCH_OPTIONS_TASKS,
	SEARCH_OPTIONS_NONTASKS,
	SEARCH_OPTIONS_NUM
} SearchOptions;

#define TYPE_SEARCH_OPTIONS (search_options_get_type ())
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

struct _Connection {
	GObject parent_instance;
	ConnectionPrivate * priv;
};

struct _ConnectionClass {
	GObjectClass parent_class;
	void (*draw) (Connection* self, cairo_t* ctx, Theme* theme, gboolean exporting);
};

struct _ConnectionPrivate {
	gint RADIUS;
	DrawArea* _da;
	ConnMode _mode;
	Node* _from_node;
	Node* _to_node;
	gdouble _posx;
	gdouble _posy;
	Style* _style;
	Bezier* _curve;
	CanvasText* _title;
	gchar* _note;
	gdouble _max_width;
	GdkRGBA* _color;
	gchar* _sticker;
	GdkPixbuf* _sticker_buf;
	gdouble _alpha;
	gdouble _extent_x1;
	gdouble _extent_y1;
	gdouble _extent_x2;
	gdouble _extent_y2;
};

static gint Connection_private_offset;
static gpointer connection_parent_class = NULL;
VALA_EXTERN Styles* style_inspector_styles;

VALA_EXTERN GType conn_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType connection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Connection, g_object_unref)
VALA_EXTERN GType theme_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Theme, g_object_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN GType node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Node, g_object_unref)
VALA_EXTERN gpointer style_ref (gpointer instance);
VALA_EXTERN void style_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_style (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags);
VALA_EXTERN void value_set_style (GValue* value,
                      gpointer v_object);
VALA_EXTERN void value_take_style (GValue* value,
                       gpointer v_object);
VALA_EXTERN gpointer value_get_style (const GValue* value);
VALA_EXTERN GType style_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Style, style_unref)
VALA_EXTERN gpointer bezier_ref (gpointer instance);
VALA_EXTERN void bezier_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_bezier (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_bezier (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_bezier (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_bezier (const GValue* value);
VALA_EXTERN GType bezier_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Bezier, bezier_unref)
VALA_EXTERN GType canvas_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CanvasText, g_object_unref)
VALA_EXTERN void connection_draw (Connection* self,
                      cairo_t* ctx,
                      Theme* theme,
                      gboolean exporting);
VALA_EXTERN Style* style_new (void);
VALA_EXTERN Style* style_construct (GType object_type);
static void _vala_GdkRGBA_free (GdkRGBA* self);
VALA_EXTERN Connection* connection_new (DrawArea* da,
                            Node* from_node);
VALA_EXTERN Connection* connection_construct (GType object_type,
                                  DrawArea* da,
                                  Node* from_node);
VALA_EXTERN void node_node_bbox (Node* self,
                     gdouble* x,
                     gdouble* y,
                     gdouble* w,
                     gdouble* h);
VALA_EXTERN void connection_connect_node (Connection* self,
                              Node* node);
static void connection_position_title (Connection* self);
VALA_EXTERN Bezier* bezier_new_with_endpoints (DrawArea* da,
                                   gdouble x0,
                                   gdouble y0,
                                   gdouble x1,
                                   gdouble y1);
VALA_EXTERN Bezier* bezier_construct_with_endpoints (GType object_type,
                                         DrawArea* da,
                                         gdouble x0,
                                         gdouble y0,
                                         gdouble x1,
                                         gdouble y1);
VALA_EXTERN gpointer styles_ref (gpointer instance);
VALA_EXTERN void styles_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_styles (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_styles (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_styles (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_styles (const GValue* value);
VALA_EXTERN GType styles_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Styles, styles_unref)
VALA_EXTERN Style* styles_get_global_style (Styles* self);
VALA_EXTERN void connection_set_style (Connection* self,
                           Style* value);
VALA_EXTERN Connection* connection_new_from_connection (DrawArea* da,
                                            Connection* conn);
VALA_EXTERN Connection* connection_construct_from_connection (GType object_type,
                                                  DrawArea* da,
                                                  Connection* conn);
VALA_EXTERN Bezier* bezier_new (DrawArea* da);
VALA_EXTERN Bezier* bezier_construct (GType object_type,
                          DrawArea* da);
VALA_EXTERN void connection_copy (Connection* self,
                      DrawArea* da,
                      Connection* conn);
VALA_EXTERN Connection* connection_new_from_xml (DrawArea* da,
                                     xmlNode* n,
                                     GArray* nodes);
VALA_EXTERN Connection* connection_construct_from_xml (GType object_type,
                                           DrawArea* da,
                                           xmlNode* n,
                                           GArray* nodes);
static void connection_load (Connection* self,
                      DrawArea* da,
                      xmlNode* node,
                      GArray* nodes);
VALA_EXTERN void bezier_copy (Bezier* self,
                  Bezier* b);
VALA_EXTERN CanvasText* connection_get_title (Connection* self);
static void _connection_position_title_canvas_text_resized (CanvasText* _sender,
                                                     gpointer self);
VALA_EXTERN CanvasText* canvas_text_new (DrawArea* da);
VALA_EXTERN CanvasText* canvas_text_construct (GType object_type,
                                   DrawArea* da);
VALA_EXTERN void canvas_text_copy (CanvasText* self,
                       CanvasText* ct);
VALA_EXTERN ConnMode connection_get_mode (Connection* self);
VALA_EXTERN void connection_set_mode (Connection* self,
                          ConnMode value);
VALA_EXTERN Style* connection_get_style (Connection* self);
VALA_EXTERN GdkRGBA* connection_get_color (Connection* self);
VALA_EXTERN void connection_set_color (Connection* self,
                           GdkRGBA* value);
static gint connection_sticker_width (Connection* self,
                               gboolean add_padding);
VALA_EXTERN gint* style_get_connection_padding (Style* self);
static gint* _int_dup (gint* self);
static gint connection_sticker_height (Connection* self);
static gint connection_title_width (Connection* self,
                             gboolean add_padding);
VALA_EXTERN gdouble canvas_text_get_width (CanvasText* self);
static gint connection_title_height (Connection* self);
VALA_EXTERN gdouble canvas_text_get_height (CanvasText* self);
static gint connection_note_width (Connection* self,
                            gboolean add_padding);
VALA_EXTERN const gchar* connection_get_note (Connection* self);
static gint connection_note_height (Connection* self);
static gint connection_get_width (Connection* self);
static gint connection_get_height (Connection* self);
VALA_EXTERN void connection_bbox (Connection* self,
                      gdouble* x,
                      gdouble* y,
                      gdouble* w,
                      gdouble* h);
VALA_EXTERN void connection_edit_title_begin (Connection* self,
                                  DrawArea* da);
VALA_EXTERN CanvasText* canvas_text_new_with_text (DrawArea* da,
                                       const gchar* txt);
VALA_EXTERN CanvasText* canvas_text_construct_with_text (GType object_type,
                                             DrawArea* da,
                                             const gchar* txt);
VALA_EXTERN void canvas_text_set_font (CanvasText* self,
                           const gchar* family,
                           gint* size,
                           gdouble zoom_factor);
VALA_EXTERN PangoFontDescription* style_get_connection_font (Style* self);
VALA_EXTERN void connection_edit_title_end (Connection* self);
VALA_EXTERN gpointer formatted_text_ref (gpointer instance);
VALA_EXTERN void formatted_text_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_formatted_text (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_formatted_text (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_formatted_text (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_formatted_text (const GValue* value);
VALA_EXTERN GType formatted_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedText, formatted_text_unref)
VALA_EXTERN FormattedText* canvas_text_get_text (CanvasText* self);
VALA_EXTERN const gchar* formatted_text_get_text (FormattedText* self);
VALA_EXTERN void connection_change_title (Connection* self,
                              DrawArea* da,
                              const gchar* title,
                              gboolean allow_empty);
VALA_EXTERN void formatted_text_set_text (FormattedText* self,
                              const gchar* str);
VALA_EXTERN void bezier_get_drag_point (Bezier* self,
                            gdouble* x,
                            gdouble* y);
VALA_EXTERN void canvas_text_set_posx (CanvasText* self,
                           gdouble value);
VALA_EXTERN void canvas_text_set_posy (CanvasText* self,
                           gdouble value);
static void connection_set_drag_handle (Connection* self,
                                 gdouble dragx,
                                 gdouble dragy);
VALA_EXTERN void bezier_update_control_from_drag_handle (Bezier* self,
                                             gdouble x,
                                             gdouble y);
static void connection_end_moved (Connection* self,
                           Node* node,
                           gdouble diffx,
                           gdouble diffy);
static void _connection_end_moved_node_moved (Node* _sender,
                                       gdouble diffx,
                                       gdouble diffy,
                                       gpointer self);
static void connection_end_resized (Connection* self,
                             Node* node,
                             gdouble diffw,
                             gdouble diffh);
static void _connection_end_resized_node_resized (Node* _sender,
                                           gdouble diffw,
                                           gdouble diffh,
                                           gpointer self);
VALA_EXTERN void connection_disconnect_node (Connection* self,
                                 Node* node);
VALA_EXTERN Connection* node_get_last_selected_connection (Node* self);
VALA_EXTERN void node_set_last_selected_connection (Node* self,
                                        Connection* value);
VALA_EXTERN void connection_connect_to (Connection* self,
                            Node* node);
VALA_EXTERN void bezier_set_point (Bezier* self,
                       gint pindex,
                       gdouble x,
                       gdouble y);
VALA_EXTERN void bezier_get_point (Bezier* self,
                       gint pindex,
                       gdouble* x,
                       gdouble* y);
static void connection_set_connect_point (Connection* self,
                                   Node* node);
VALA_EXTERN void connection_disconnect_from_node (Connection* self,
                                      gboolean from);
VALA_EXTERN void bezier_get_from_point (Bezier* self,
                            gdouble* x,
                            gdouble* y);
VALA_EXTERN void bezier_get_to_point (Bezier* self,
                          gdouble* x,
                          gdouble* y);
VALA_EXTERN void connection_draw_to (Connection* self,
                         gdouble x,
                         gdouble y);
static gboolean connection_common_parent_moved (Connection* self,
                                         Node* node);
static void _g_object_unref0_ (gpointer var);
static void _vala_Node_free_function_content_of (gpointer data);
VALA_EXTERN gpointer selection_ref (gpointer instance);
VALA_EXTERN void selection_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_selection (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void value_set_selection (GValue* value,
                          gpointer v_object);
VALA_EXTERN void value_take_selection (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer value_get_selection (const GValue* value);
VALA_EXTERN GType selection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Selection, selection_unref)
VALA_EXTERN Selection* draw_area_get_selections (DrawArea* self);
VALA_EXTERN void selection_get_parents (Selection* self,
                            GArray** parents);
VALA_EXTERN gboolean node_is_descendant_of (Node* self,
                                Node* node);
VALA_EXTERN gboolean connection_attached_to_node (Connection* self,
                                      Node* node);
VALA_EXTERN Style* node_get_style (Node* self);
VALA_EXTERN gint* style_get_node_borderwidth (Style* self);
VALA_EXTERN gint* style_get_connection_line_width (Style* self);
VALA_EXTERN gint* style_get_node_margin (Style* self);
VALA_EXTERN void bezier_set_connect_point (Bezier* self,
                               gboolean from,
                               gdouble top,
                               gdouble bottom,
                               gdouble left,
                               gdouble right);
VALA_EXTERN gboolean connection_on_curve (Connection* self,
                              gdouble x,
                              gdouble y);
VALA_EXTERN gboolean bezier_within_range (Bezier* self,
                              gdouble x,
                              gdouble y);
static gboolean connection_within_handle (Connection* self,
                                   gdouble hx,
                                   gdouble hy,
                                   gdouble x,
                                   gdouble y);
VALA_EXTERN gboolean connection_within_drag_handle (Connection* self,
                                        gdouble x,
                                        gdouble y);
static void connection_title_bbox (Connection* self,
                            gdouble* x,
                            gdouble* y,
                            gdouble* w,
                            gdouble* h);
VALA_EXTERN gboolean connection_within_from_handle (Connection* self,
                                        gdouble x,
                                        gdouble y);
static gboolean connection_within_endpoint_handle (Connection* self,
                                            gboolean from,
                                            gdouble x,
                                            gdouble y);
VALA_EXTERN gboolean connection_within_to_handle (Connection* self,
                                      gdouble x,
                                      gdouble y);
VALA_EXTERN gboolean connection_within_title_box (Connection* self,
                                      gdouble x,
                                      gdouble y);
VALA_EXTERN gboolean utils_is_within_bounds (gdouble x,
                                 gdouble y,
                                 gdouble bx,
                                 gdouble by,
                                 gdouble bw,
                                 gdouble bh);
VALA_EXTERN gboolean connection_within_title (Connection* self,
                                  gdouble x,
                                  gdouble y);
VALA_EXTERN gboolean canvas_text_is_within (CanvasText* self,
                                gdouble x,
                                gdouble y);
VALA_EXTERN gboolean connection_within_note (Connection* self,
                                 gdouble x,
                                 gdouble y);
static void connection_note_bbox (Connection* self,
                           gdouble* x,
                           gdouble* y,
                           gdouble* w,
                           gdouble* h);
VALA_EXTERN gboolean connection_within_sticker (Connection* self,
                                    gdouble x,
                                    gdouble y);
static void connection_sticker_bbox (Connection* self,
                              gdouble* x,
                              gdouble* y,
                              gdouble* w,
                              gdouble* h);
VALA_EXTERN void connection_move_drag_handle (Connection* self,
                                  gdouble x,
                                  gdouble y);
VALA_EXTERN Node* draw_area_get_node (DrawArea* self,
                          GArray* nodes,
                          gint id);
VALA_EXTERN gdouble draw_area_get_origin_x (DrawArea* self);
VALA_EXTERN gdouble draw_area_get_origin_y (DrawArea* self);
VALA_EXTERN void connection_set_note (Connection* self,
                          const gchar* value);
VALA_EXTERN Theme* draw_area_get_theme (DrawArea* self);
VALA_EXTERN GdkRGBA* theme_get_color (Theme* self,
                          const gchar* name);
VALA_EXTERN void connection_set_sticker (Connection* self,
                             const gchar* value);
VALA_EXTERN void style_load_connection (Style* self,
                            xmlNode* node);
VALA_EXTERN void connection_save (Connection* self,
                      xmlNode* parent);
VALA_EXTERN gint node_id (Node* self);
VALA_EXTERN gchar* utils_color_from_rgba (GdkRGBA* rgba);
VALA_EXTERN void style_save_connection (Style* self,
                            xmlNode* parent);
VALA_EXTERN void connection_get_match_items (Connection* self,
                                 const gchar* tabname,
                                 const gchar* pattern,
                                 gboolean* search_opts,
                                 gint search_opts_length1,
                                 GtkListStore** matches);
VALA_EXTERN gchar* utils_rootname (const gchar* filename);
VALA_EXTERN GType search_options_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* utils_match_string (const gchar* pattern,
                           const gchar* value);
static void connection_real_draw (Connection* self,
                           cairo_t* ctx,
                           Theme* theme,
                           gboolean exporting);
VALA_EXTERN gboolean node_is_root (Node* self);
VALA_EXTERN Node* node_folded_ancestor (Node* self);
static GdkRGBA* _vala_GdkRGBA_copy (GdkRGBA* self);
VALA_EXTERN void style_draw_connection (Style* self,
                            cairo_t* ctx);
VALA_EXTERN void utils_set_context_color_with_alpha (cairo_t* ctx,
                                         GdkRGBA* color,
                                         gdouble alpha);
VALA_EXTERN gdouble connection_get_alpha (Connection* self);
static void connection_set_extent_x1 (Connection* self,
                               gdouble value);
static void connection_set_extent_y1 (Connection* self,
                               gdouble value);
static void connection_set_extent_x2 (Connection* self,
                               gdouble value);
static void connection_set_extent_y2 (Connection* self,
                               gdouble value);
VALA_EXTERN const gchar* style_get_connection_arrow (Style* self);
VALA_EXTERN void connection_draw_arrow (cairo_t* ctx,
                            gint line_width,
                            gdouble tipx,
                            gdouble tipy,
                            gdouble tailx,
                            gdouble taily,
                            gdouble arrowLength);
static void connection_draw_title (Connection* self,
                            cairo_t* ctx,
                            Theme* theme,
                            gboolean exporting);
VALA_EXTERN void utils_color_from_string (const gchar* value,
                              GdkRGBA* result);
static void connection_draw_sticker (Connection* self,
                              cairo_t* ctx,
                              Theme* theme);
VALA_EXTERN gdouble connection_get_extent_x1 (Connection* self);
VALA_EXTERN gdouble connection_get_extent_y1 (Connection* self);
VALA_EXTERN gdouble connection_get_extent_x2 (Connection* self);
VALA_EXTERN gdouble connection_get_extent_y2 (Connection* self);
VALA_EXTERN void canvas_text_draw (CanvasText* self,
                       cairo_t* ctx,
                       Theme* theme,
                       GdkRGBA* fg,
                       gdouble alpha,
                       gboolean copy_layout);
static void connection_draw_note (Connection* self,
                           cairo_t* ctx,
                           GdkRGBA* color);
VALA_EXTERN cairo_surface_t* connection_make_arrow_icon (const gchar* type);
VALA_EXTERN void canvas_text_set_edit (CanvasText* self,
                           gboolean value);
VALA_EXTERN void canvas_text_set_cursor_all (CanvasText* self,
                                 gboolean motion);
VALA_EXTERN void canvas_text_clear_selection (CanvasText* self,
                                  const gchar* msg);
VALA_EXTERN Node* connection_get_from_node (Connection* self);
VALA_EXTERN void connection_set_from_node (Connection* self,
                               Node* value);
VALA_EXTERN Node* connection_get_to_node (Connection* self);
VALA_EXTERN void connection_set_to_node (Connection* self,
                             Node* value);
VALA_EXTERN gboolean style_copy (Style* self,
                     Style* s);
VALA_EXTERN gint* style_get_connection_title_width (Style* self);
VALA_EXTERN void canvas_text_set_max_width (CanvasText* self,
                                gdouble value);
VALA_EXTERN void connection_set_alpha (Connection* self,
                           gdouble value);
VALA_EXTERN void node_set_alpha_only (Node* self,
                          gdouble value);
VALA_EXTERN const gchar* connection_get_sticker (Connection* self);
VALA_EXTERN GdkPixbuf* sticker_set_make_pixbuf (const gchar* resource,
                                    gint width);
static void connection_finalize (GObject * obj);
static GType connection_get_type_once (void);
static void _vala_connection_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec);
static void _vala_connection_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec);

static GType
conn_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{CONN_MODE_NONE, "CONN_MODE_NONE", "none"}, {CONN_MODE_LINKING, "CONN_MODE_LINKING", "linking"}, {CONN_MODE_CONNECTING, "CONN_MODE_CONNECTING", "connecting"}, {CONN_MODE_SELECTED, "CONN_MODE_SELECTED", "selected"}, {CONN_MODE_ADJUSTING, "CONN_MODE_ADJUSTING", "adjusting"}, {CONN_MODE_EDITABLE, "CONN_MODE_EDITABLE", "editable"}, {CONN_MODE_DROPPABLE, "CONN_MODE_DROPPABLE", "droppable"}, {0, NULL, NULL}};
	GType conn_mode_type_id;
	conn_mode_type_id = g_enum_register_static ("ConnMode", values);
	return conn_mode_type_id;
}

GType
conn_mode_get_type (void)
{
	static volatile gsize conn_mode_type_id__once = 0;
	if (g_once_init_enter (&conn_mode_type_id__once)) {
		GType conn_mode_type_id;
		conn_mode_type_id = conn_mode_get_type_once ();
		g_once_init_leave (&conn_mode_type_id__once, conn_mode_type_id);
	}
	return conn_mode_type_id__once;
}

static inline gpointer
connection_get_instance_private (Connection* self)
{
	return G_STRUCT_MEMBER_P (self, Connection_private_offset);
}

static void
_vala_GdkRGBA_free (GdkRGBA* self)
{
	g_boxed_free (gdk_rgba_get_type (), self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

Connection*
connection_construct (GType object_type,
                      DrawArea* da,
                      Node* from_node)
{
	Connection * self = NULL;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble w = 0.0;
	gdouble h = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	DrawArea* _tmp4_;
	Node* _tmp5_;
	Node* _tmp6_;
	Bezier* _tmp7_;
	Styles* _tmp8_;
	Style* _tmp9_;
	Style* _tmp10_;
	g_return_val_if_fail (da != NULL, NULL);
	g_return_val_if_fail (from_node != NULL, NULL);
	self = (Connection*) g_object_new (object_type, NULL);
	node_node_bbox (from_node, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	x = _tmp0_;
	y = _tmp1_;
	w = _tmp2_;
	h = _tmp3_;
	_tmp4_ = _g_object_ref0 (da);
	_g_object_unref0 (self->priv->_da);
	self->priv->_da = _tmp4_;
	self->priv->_posx = x + (w / 2);
	self->priv->_posy = y + (h / 2);
	_tmp5_ = _g_object_ref0 (from_node);
	_g_object_unref0 (self->priv->_from_node);
	self->priv->_from_node = _tmp5_;
	_tmp6_ = self->priv->_from_node;
	connection_connect_node (self, _tmp6_);
	connection_position_title (self);
	_tmp7_ = bezier_new_with_endpoints (da, self->priv->_posx, self->priv->_posy, self->priv->_posx, self->priv->_posy);
	_bezier_unref0 (self->priv->_curve);
	self->priv->_curve = _tmp7_;
	_tmp8_ = style_inspector_styles;
	_tmp9_ = styles_get_global_style (_tmp8_);
	_tmp10_ = _tmp9_;
	connection_set_style (self, _tmp10_);
	_style_unref0 (_tmp10_);
	return self;
}

Connection*
connection_new (DrawArea* da,
                Node* from_node)
{
	return connection_construct (TYPE_CONNECTION, da, from_node);
}

Connection*
connection_construct_from_connection (GType object_type,
                                      DrawArea* da,
                                      Connection* conn)
{
	Connection * self = NULL;
	DrawArea* _tmp0_;
	Bezier* _tmp1_;
	g_return_val_if_fail (da != NULL, NULL);
	g_return_val_if_fail (conn != NULL, NULL);
	self = (Connection*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (da);
	_g_object_unref0 (self->priv->_da);
	self->priv->_da = _tmp0_;
	_tmp1_ = bezier_new (da);
	_bezier_unref0 (self->priv->_curve);
	self->priv->_curve = _tmp1_;
	connection_copy (self, da, conn);
	return self;
}

Connection*
connection_new_from_connection (DrawArea* da,
                                Connection* conn)
{
	return connection_construct_from_connection (TYPE_CONNECTION, da, conn);
}

Connection*
connection_construct_from_xml (GType object_type,
                               DrawArea* da,
                               xmlNode* n,
                               GArray* nodes)
{
	Connection * self = NULL;
	DrawArea* _tmp0_;
	Styles* _tmp1_;
	Style* _tmp2_;
	Style* _tmp3_;
	g_return_val_if_fail (da != NULL, NULL);
	g_return_val_if_fail (nodes != NULL, NULL);
	self = (Connection*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (da);
	_g_object_unref0 (self->priv->_da);
	self->priv->_da = _tmp0_;
	_tmp1_ = style_inspector_styles;
	_tmp2_ = styles_get_global_style (_tmp1_);
	_tmp3_ = _tmp2_;
	connection_set_style (self, _tmp3_);
	_style_unref0 (_tmp3_);
	connection_load (self, da, n, nodes);
	return self;
}

Connection*
connection_new_from_xml (DrawArea* da,
                         xmlNode* n,
                         GArray* nodes)
{
	return connection_construct_from_xml (TYPE_CONNECTION, da, n, nodes);
}

static void
_connection_position_title_canvas_text_resized (CanvasText* _sender,
                                                gpointer self)
{
	connection_position_title ((Connection*) self);
}

void
connection_copy (Connection* self,
                 DrawArea* da,
                 Connection* conn)
{
	Node* _tmp0_;
	Node* _tmp1_;
	Node* _tmp2_;
	Node* _tmp3_;
	Bezier* _tmp4_;
	Bezier* _tmp5_;
	CanvasText* _tmp6_;
	CanvasText* _tmp7_;
	ConnMode _tmp18_;
	ConnMode _tmp19_;
	Style* _tmp20_;
	Style* _tmp21_;
	GdkRGBA* _tmp22_;
	GdkRGBA* _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (da != NULL);
	g_return_if_fail (conn != NULL);
	_tmp0_ = conn->priv->_from_node;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_from_node);
	self->priv->_from_node = _tmp1_;
	_tmp2_ = conn->priv->_to_node;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->_to_node);
	self->priv->_to_node = _tmp3_;
	connection_position_title (self);
	_tmp4_ = self->priv->_curve;
	_tmp5_ = conn->priv->_curve;
	bezier_copy (_tmp4_, _tmp5_);
	_tmp6_ = connection_get_title (conn);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == NULL) {
		CanvasText* _tmp8_;
		_tmp8_ = self->priv->_title;
		if (_tmp8_ != NULL) {
			CanvasText* _tmp9_;
			guint _tmp10_;
			_tmp9_ = self->priv->_title;
			g_signal_parse_name ("resized", TYPE_CANVAS_TEXT, &_tmp10_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (_tmp9_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) _connection_position_title_canvas_text_resized, self);
		}
		_g_object_unref0 (self->priv->_title);
		self->priv->_title = NULL;
	} else {
		CanvasText* _tmp11_;
		CanvasText* _tmp12_;
		CanvasText* _tmp15_;
		CanvasText* _tmp16_;
		CanvasText* _tmp17_;
		_tmp11_ = connection_get_title (self);
		_tmp12_ = _tmp11_;
		if (_tmp12_ == NULL) {
			CanvasText* _tmp13_;
			CanvasText* _tmp14_;
			_tmp13_ = canvas_text_new (da);
			_g_object_unref0 (self->priv->_title);
			self->priv->_title = _tmp13_;
			_tmp14_ = self->priv->_title;
			g_signal_connect_object (_tmp14_, "resized", (GCallback) _connection_position_title_canvas_text_resized, self, 0);
		}
		_tmp15_ = self->priv->_title;
		_tmp16_ = connection_get_title (conn);
		_tmp17_ = _tmp16_;
		canvas_text_copy (_tmp15_, _tmp17_);
	}
	_tmp18_ = connection_get_mode (conn);
	_tmp19_ = _tmp18_;
	connection_set_mode (self, _tmp19_);
	_tmp20_ = connection_get_style (conn);
	_tmp21_ = _tmp20_;
	connection_set_style (self, _tmp21_);
	_tmp22_ = connection_get_color (conn);
	_tmp23_ = _tmp22_;
	connection_set_color (self, _tmp23_);
}

static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}

static gpointer
__int_dup0 (gpointer self)
{
	return self ? _int_dup (self) : NULL;
}

static gint
connection_sticker_width (Connection* self,
                          gboolean add_padding)
{
	gint* _tmp0_ = NULL;
	gint* padding = NULL;
	gint* _tmp12_;
	gint _tmp13_ = 0;
	GdkPixbuf* _tmp14_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	if (add_padding) {
		gint* _tmp1_ = NULL;
		Style* _tmp2_;
		Style* _tmp3_;
		gint* _tmp4_;
		gint* _tmp5_;
		gint* _tmp6_;
		gint* _tmp9_;
		_tmp2_ = connection_get_style (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = style_get_connection_padding (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = __int_dup0 (_tmp5_);
		_tmp1_ = _tmp6_;
		if (_tmp1_ == NULL) {
			gint _tmp7_;
			gint* _tmp8_;
			_tmp7_ = 0;
			_tmp8_ = __int_dup0 (&_tmp7_);
			_g_free0 (_tmp1_);
			_tmp1_ = _tmp8_;
		}
		_tmp9_ = _tmp1_;
		_tmp1_ = NULL;
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp9_;
		_g_free0 (_tmp1_);
	} else {
		gint _tmp10_;
		gint* _tmp11_;
		_tmp10_ = 0;
		_tmp11_ = __int_dup0 (&_tmp10_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp11_;
	}
	_tmp12_ = __int_dup0 (_tmp0_);
	padding = _tmp12_;
	_tmp14_ = self->priv->_sticker_buf;
	if (_tmp14_ != NULL) {
		GdkPixbuf* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint* _tmp18_;
		_tmp15_ = self->priv->_sticker_buf;
		_tmp16_ = gdk_pixbuf_get_width (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = padding;
		_tmp13_ = _tmp17_ + (*_tmp18_);
	} else {
		_tmp13_ = 0;
	}
	result = _tmp13_;
	_g_free0 (padding);
	_g_free0 (_tmp0_);
	return result;
}

static gint
connection_sticker_height (Connection* self)
{
	gint _tmp0_ = 0;
	GdkPixbuf* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->_sticker_buf;
	if (_tmp1_ != NULL) {
		GdkPixbuf* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->_sticker_buf;
		_tmp3_ = gdk_pixbuf_get_height (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = 0;
	}
	result = _tmp0_;
	return result;
}

static gint
connection_title_width (Connection* self,
                        gboolean add_padding)
{
	gint* _tmp0_ = NULL;
	gint* padding = NULL;
	gint* _tmp12_;
	gint _tmp13_ = 0;
	CanvasText* _tmp14_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	if (add_padding) {
		gint* _tmp1_ = NULL;
		Style* _tmp2_;
		Style* _tmp3_;
		gint* _tmp4_;
		gint* _tmp5_;
		gint* _tmp6_;
		gint* _tmp9_;
		_tmp2_ = connection_get_style (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = style_get_connection_padding (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = __int_dup0 (_tmp5_);
		_tmp1_ = _tmp6_;
		if (_tmp1_ == NULL) {
			gint _tmp7_;
			gint* _tmp8_;
			_tmp7_ = 0;
			_tmp8_ = __int_dup0 (&_tmp7_);
			_g_free0 (_tmp1_);
			_tmp1_ = _tmp8_;
		}
		_tmp9_ = _tmp1_;
		_tmp1_ = NULL;
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp9_;
		_g_free0 (_tmp1_);
	} else {
		gint _tmp10_;
		gint* _tmp11_;
		_tmp10_ = 0;
		_tmp11_ = __int_dup0 (&_tmp10_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp11_;
	}
	_tmp12_ = __int_dup0 (_tmp0_);
	padding = _tmp12_;
	_tmp14_ = self->priv->_title;
	if (_tmp14_ != NULL) {
		CanvasText* _tmp15_;
		gdouble _tmp16_;
		gdouble _tmp17_;
		gint* _tmp18_;
		_tmp15_ = self->priv->_title;
		_tmp16_ = canvas_text_get_width (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = padding;
		_tmp13_ = ((gint) _tmp17_) + (*_tmp18_);
	} else {
		_tmp13_ = 0;
	}
	result = _tmp13_;
	_g_free0 (padding);
	_g_free0 (_tmp0_);
	return result;
}

static gint
connection_title_height (Connection* self)
{
	gint _tmp0_ = 0;
	CanvasText* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->_title;
	if (_tmp1_ != NULL) {
		CanvasText* _tmp2_;
		gdouble _tmp3_;
		gdouble _tmp4_;
		_tmp2_ = self->priv->_title;
		_tmp3_ = canvas_text_get_height (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = (gint) _tmp4_;
	} else {
		_tmp0_ = 0;
	}
	result = _tmp0_;
	return result;
}

static gint
connection_note_width (Connection* self,
                       gboolean add_padding)
{
	gint* _tmp0_ = NULL;
	gint* padding = NULL;
	gint* _tmp12_;
	gint _tmp13_ = 0;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	if (add_padding) {
		gint* _tmp1_ = NULL;
		Style* _tmp2_;
		Style* _tmp3_;
		gint* _tmp4_;
		gint* _tmp5_;
		gint* _tmp6_;
		gint* _tmp9_;
		_tmp2_ = connection_get_style (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = style_get_connection_padding (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = __int_dup0 (_tmp5_);
		_tmp1_ = _tmp6_;
		if (_tmp1_ == NULL) {
			gint _tmp7_;
			gint* _tmp8_;
			_tmp7_ = 0;
			_tmp8_ = __int_dup0 (&_tmp7_);
			_g_free0 (_tmp1_);
			_tmp1_ = _tmp8_;
		}
		_tmp9_ = _tmp1_;
		_tmp1_ = NULL;
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp9_;
		_g_free0 (_tmp1_);
	} else {
		gint _tmp10_;
		gint* _tmp11_;
		_tmp10_ = 0;
		_tmp11_ = __int_dup0 (&_tmp10_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp11_;
	}
	_tmp12_ = __int_dup0 (_tmp0_);
	padding = _tmp12_;
	_tmp14_ = connection_get_note (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = strlen (_tmp15_);
	_tmp17_ = _tmp16_;
	if (_tmp17_ > 0) {
		gint* _tmp18_;
		_tmp18_ = padding;
		_tmp13_ = 11 + (*_tmp18_);
	} else {
		_tmp13_ = 0;
	}
	result = _tmp13_;
	_g_free0 (padding);
	_g_free0 (_tmp0_);
	return result;
}

static gint
connection_note_height (Connection* self)
{
	gint _tmp0_ = 0;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = connection_get_note (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ > 0) {
		_tmp0_ = 11;
	} else {
		_tmp0_ = 0;
	}
	result = _tmp0_;
	return result;
}

static gint
connection_get_width (Connection* self)
{
	gint sw = 0;
	gint tw = 0;
	gint nw = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	sw = connection_sticker_width (self, FALSE);
	tw = connection_title_width (self, sw > 0);
	nw = connection_note_width (self, (sw + tw) > 0);
	result = (sw + tw) + nw;
	return result;
}

static gint
connection_get_height (Connection* self)
{
	gint sh = 0;
	gint th = 0;
	gint nh = 0;
	gboolean _tmp0_ = FALSE;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	sh = connection_sticker_height (self);
	th = connection_title_height (self);
	nh = connection_note_height (self);
	if (sh <= th) {
		_tmp0_ = nh <= th;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = th;
		return result;
	} else {
		gboolean _tmp1_ = FALSE;
		if (th <= sh) {
			_tmp1_ = nh <= sh;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			result = sh;
			return result;
		} else {
			result = nh;
			return result;
		}
	}
}

void
connection_bbox (Connection* self,
                 gdouble* x,
                 gdouble* y,
                 gdouble* w,
                 gdouble* h)
{
	gdouble _vala_x = 0.0;
	gdouble _vala_y = 0.0;
	gdouble _vala_w = 0.0;
	gdouble _vala_h = 0.0;
	gdouble fx = 0.0;
	gdouble fy = 0.0;
	gdouble fw = 0.0;
	gdouble fh = 0.0;
	gdouble tx = 0.0;
	gdouble ty = 0.0;
	gdouble tw = 0.0;
	gdouble th = 0.0;
	gboolean _tmp0_ = FALSE;
	Node* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_from_node;
	if (_tmp1_ != NULL) {
		Node* _tmp2_;
		_tmp2_ = self->priv->_to_node;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Node* _tmp3_;
		gdouble _tmp4_ = 0.0;
		gdouble _tmp5_ = 0.0;
		gdouble _tmp6_ = 0.0;
		gdouble _tmp7_ = 0.0;
		Node* _tmp8_;
		gdouble _tmp9_ = 0.0;
		gdouble _tmp10_ = 0.0;
		gdouble _tmp11_ = 0.0;
		gdouble _tmp12_ = 0.0;
		gdouble _tmp13_ = 0.0;
		gdouble _tmp14_ = 0.0;
		gdouble _tmp15_ = 0.0;
		gdouble _tmp16_ = 0.0;
		_tmp3_ = self->priv->_from_node;
		node_node_bbox (_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_, &_tmp7_);
		fx = _tmp4_;
		fy = _tmp5_;
		fw = _tmp6_;
		fh = _tmp7_;
		_tmp8_ = self->priv->_to_node;
		node_node_bbox (_tmp8_, &_tmp9_, &_tmp10_, &_tmp11_, &_tmp12_);
		tx = _tmp9_;
		ty = _tmp10_;
		tw = _tmp11_;
		th = _tmp12_;
		if (fx < tx) {
			_tmp13_ = fx;
		} else {
			_tmp13_ = tx;
		}
		_vala_x = _tmp13_;
		if (fy < ty) {
			_tmp14_ = fy;
		} else {
			_tmp14_ = ty;
		}
		_vala_y = _tmp14_;
		if ((fx + fw) > (tx + tw)) {
			_tmp15_ = (fx + fw) - _vala_x;
		} else {
			_tmp15_ = (tx + tw) - _vala_x;
		}
		_vala_w = _tmp15_;
		if ((fy + fh) > (ty + th)) {
			_tmp16_ = (fy + fh) - _vala_y;
		} else {
			_tmp16_ = (ty + th) - _vala_y;
		}
		_vala_h = _tmp16_;
	} else {
		Node* _tmp17_;
		_tmp17_ = self->priv->_from_node;
		if (_tmp17_ != NULL) {
			Node* _tmp18_;
			gdouble _tmp19_ = 0.0;
			gdouble _tmp20_ = 0.0;
			gdouble _tmp21_ = 0.0;
			gdouble _tmp22_ = 0.0;
			_tmp18_ = self->priv->_from_node;
			node_node_bbox (_tmp18_, &_tmp19_, &_tmp20_, &_tmp21_, &_tmp22_);
			_vala_x = _tmp19_;
			_vala_y = _tmp20_;
			_vala_w = _tmp21_;
			_vala_h = _tmp22_;
		} else {
			Node* _tmp23_;
			_tmp23_ = self->priv->_to_node;
			if (_tmp23_ != NULL) {
				Node* _tmp24_;
				gdouble _tmp25_ = 0.0;
				gdouble _tmp26_ = 0.0;
				gdouble _tmp27_ = 0.0;
				gdouble _tmp28_ = 0.0;
				_tmp24_ = self->priv->_to_node;
				node_node_bbox (_tmp24_, &_tmp25_, &_tmp26_, &_tmp27_, &_tmp28_);
				_vala_x = _tmp25_;
				_vala_y = _tmp26_;
				_vala_w = _tmp27_;
				_vala_h = _tmp28_;
			} else {
				_vala_x = (gdouble) 0;
				_vala_y = (gdouble) 0;
				_vala_w = (gdouble) 0;
				_vala_h = (gdouble) 0;
			}
		}
	}
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
	if (w) {
		*w = _vala_w;
	}
	if (h) {
		*h = _vala_h;
	}
}

void
connection_edit_title_begin (Connection* self,
                             DrawArea* da)
{
	CanvasText* _tmp0_;
	CanvasText* _tmp1_;
	CanvasText* _tmp2_;
	CanvasText* _tmp3_;
	Style* _tmp4_;
	Style* _tmp5_;
	PangoFontDescription* _tmp6_;
	PangoFontDescription* _tmp7_;
	const gchar* _tmp8_;
	Style* _tmp9_;
	Style* _tmp10_;
	PangoFontDescription* _tmp11_;
	PangoFontDescription* _tmp12_;
	gint _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (da != NULL);
	_tmp0_ = self->priv->_title;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = canvas_text_new_with_text (da, "");
	_g_object_unref0 (self->priv->_title);
	self->priv->_title = _tmp1_;
	_tmp2_ = self->priv->_title;
	g_signal_connect_object (_tmp2_, "resized", (GCallback) _connection_position_title_canvas_text_resized, self, 0);
	_tmp3_ = self->priv->_title;
	_tmp4_ = connection_get_style (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = style_get_connection_font (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = pango_font_description_get_family (_tmp7_);
	_tmp9_ = connection_get_style (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = style_get_connection_font (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = pango_font_description_get_size (_tmp12_) / PANGO_SCALE;
	canvas_text_set_font (_tmp3_, _tmp8_, &_tmp13_, 1.0);
	connection_position_title (self);
}

void
connection_edit_title_end (Connection* self)
{
	gboolean _tmp0_ = FALSE;
	CanvasText* _tmp1_;
	CanvasText* _tmp7_;
	guint _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_title;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		CanvasText* _tmp2_;
		FormattedText* _tmp3_;
		FormattedText* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp2_ = self->priv->_title;
		_tmp3_ = canvas_text_get_text (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = formatted_text_get_text (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = g_strcmp0 (_tmp6_, "") != 0;
	}
	if (_tmp0_) {
		return;
	}
	_tmp7_ = self->priv->_title;
	g_signal_parse_name ("resized", TYPE_CANVAS_TEXT, &_tmp8_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _connection_position_title_canvas_text_resized, self);
	_g_object_unref0 (self->priv->_title);
	self->priv->_title = NULL;
}

void
connection_change_title (Connection* self,
                         DrawArea* da,
                         const gchar* title,
                         gboolean allow_empty)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (da != NULL);
	g_return_if_fail (title != NULL);
	if (g_strcmp0 (title, "") == 0) {
		_tmp0_ = !allow_empty;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		CanvasText* _tmp1_;
		_tmp1_ = self->priv->_title;
		if (_tmp1_ != NULL) {
			CanvasText* _tmp2_;
			guint _tmp3_;
			_tmp2_ = self->priv->_title;
			g_signal_parse_name ("resized", TYPE_CANVAS_TEXT, &_tmp3_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _connection_position_title_canvas_text_resized, self);
		}
		_g_object_unref0 (self->priv->_title);
		self->priv->_title = NULL;
	} else {
		CanvasText* _tmp4_;
		_tmp4_ = self->priv->_title;
		if (_tmp4_ == NULL) {
			CanvasText* _tmp5_;
			CanvasText* _tmp6_;
			CanvasText* _tmp7_;
			Style* _tmp8_;
			Style* _tmp9_;
			PangoFontDescription* _tmp10_;
			PangoFontDescription* _tmp11_;
			const gchar* _tmp12_;
			Style* _tmp13_;
			Style* _tmp14_;
			PangoFontDescription* _tmp15_;
			PangoFontDescription* _tmp16_;
			gint _tmp17_;
			_tmp5_ = canvas_text_new_with_text (da, title);
			_g_object_unref0 (self->priv->_title);
			self->priv->_title = _tmp5_;
			_tmp6_ = self->priv->_title;
			g_signal_connect_object (_tmp6_, "resized", (GCallback) _connection_position_title_canvas_text_resized, self, 0);
			_tmp7_ = self->priv->_title;
			_tmp8_ = connection_get_style (self);
			_tmp9_ = _tmp8_;
			_tmp10_ = style_get_connection_font (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = pango_font_description_get_family (_tmp11_);
			_tmp13_ = connection_get_style (self);
			_tmp14_ = _tmp13_;
			_tmp15_ = style_get_connection_font (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = pango_font_description_get_size (_tmp16_) / PANGO_SCALE;
			canvas_text_set_font (_tmp7_, _tmp12_, &_tmp17_, 1.0);
			connection_position_title (self);
		} else {
			CanvasText* _tmp18_;
			FormattedText* _tmp19_;
			FormattedText* _tmp20_;
			_tmp18_ = self->priv->_title;
			_tmp19_ = canvas_text_get_text (_tmp18_);
			_tmp20_ = _tmp19_;
			formatted_text_set_text (_tmp20_, title);
		}
	}
}

static void
connection_position_title (Connection* self)
{
	CanvasText* _tmp0_;
	CanvasText* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = connection_get_title (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		gint width = 0;
		gint swidth = 0;
		gint theight = 0;
		gdouble dragx = 0.0;
		gdouble dragy = 0.0;
		Bezier* _tmp2_;
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
		CanvasText* _tmp5_;
		CanvasText* _tmp6_;
		width = connection_get_width (self);
		swidth = connection_sticker_width (self, TRUE);
		theight = connection_title_height (self);
		_tmp2_ = self->priv->_curve;
		bezier_get_drag_point (_tmp2_, &_tmp3_, &_tmp4_);
		dragx = _tmp3_;
		dragy = _tmp4_;
		_tmp5_ = self->priv->_title;
		canvas_text_set_posx (_tmp5_, dragx - ((width / 2) - swidth));
		_tmp6_ = self->priv->_title;
		canvas_text_set_posy (_tmp6_, dragy - (theight / 2));
	}
}

static void
connection_set_drag_handle (Connection* self,
                            gdouble dragx,
                            gdouble dragy)
{
	Bezier* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_curve;
	bezier_update_control_from_drag_handle (_tmp0_, dragx, dragy);
	connection_position_title (self);
}

static void
_connection_end_moved_node_moved (Node* _sender,
                                  gdouble diffx,
                                  gdouble diffy,
                                  gpointer self)
{
	connection_end_moved ((Connection*) self, _sender, diffx, diffy);
}

static void
_connection_end_resized_node_resized (Node* _sender,
                                      gdouble diffw,
                                      gdouble diffh,
                                      gpointer self)
{
	connection_end_resized ((Connection*) self, _sender, diffw, diffh);
}

void
connection_connect_node (Connection* self,
                         Node* node)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_signal_connect_object (node, "moved", (GCallback) _connection_end_moved_node_moved, self, 0);
	g_signal_connect_object (node, "resized", (GCallback) _connection_end_resized_node_resized, self, 0);
}

void
connection_disconnect_node (Connection* self,
                            Node* node)
{
	guint _tmp0_;
	guint _tmp1_;
	Connection* _tmp2_;
	Connection* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_signal_parse_name ("moved", TYPE_NODE, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (node, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _connection_end_moved_node_moved, self);
	g_signal_parse_name ("resized", TYPE_NODE, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (node, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _connection_end_resized_node_resized, self);
	_tmp2_ = node_get_last_selected_connection (node);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == self) {
		node_set_last_selected_connection (node, NULL);
	}
}

void
connection_connect_to (Connection* self,
                       Node* node)
{
	gdouble fx = 0.0;
	gdouble fy = 0.0;
	gdouble tx = 0.0;
	gdouble ty = 0.0;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble w = 0.0;
	gdouble h = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	Node* _tmp4_;
	gint _tmp7_ = 0;
	Node* _tmp8_;
	Bezier* _tmp9_;
	Bezier* _tmp10_;
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_ = 0.0;
	Bezier* _tmp13_;
	gdouble _tmp14_ = 0.0;
	gdouble _tmp15_ = 0.0;
	gdouble dragx = 0.0;
	gdouble dragy = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	node_node_bbox (node, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	x = _tmp0_;
	y = _tmp1_;
	w = _tmp2_;
	h = _tmp3_;
	_tmp4_ = self->priv->_from_node;
	if (_tmp4_ == NULL) {
		Node* _tmp5_;
		_tmp5_ = _g_object_ref0 (node);
		_g_object_unref0 (self->priv->_from_node);
		self->priv->_from_node = _tmp5_;
	} else {
		Node* _tmp6_;
		_tmp6_ = _g_object_ref0 (node);
		_g_object_unref0 (self->priv->_to_node);
		self->priv->_to_node = _tmp6_;
	}
	connection_connect_node (self, node);
	_tmp8_ = self->priv->_from_node;
	if (_tmp8_ == node) {
		_tmp7_ = 0;
	} else {
		_tmp7_ = 2;
	}
	_tmp9_ = self->priv->_curve;
	bezier_set_point (_tmp9_, _tmp7_, x + (w / 2), y + (h / 2));
	_tmp10_ = self->priv->_curve;
	bezier_get_point (_tmp10_, 0, &_tmp11_, &_tmp12_);
	fx = _tmp11_;
	fy = _tmp12_;
	_tmp13_ = self->priv->_curve;
	bezier_get_point (_tmp13_, 2, &_tmp14_, &_tmp15_);
	tx = _tmp14_;
	ty = _tmp15_;
	dragx = (fx + tx) / 2;
	dragy = (fy + ty) / 2;
	connection_set_drag_handle (self, dragx, dragy);
	connection_set_connect_point (self, node);
}

void
connection_disconnect_from_node (Connection* self,
                                 gboolean from)
{
	g_return_if_fail (self != NULL);
	if (from) {
		Bezier* _tmp0_;
		gdouble _tmp1_ = 0.0;
		gdouble _tmp2_ = 0.0;
		Node* _tmp3_;
		_tmp0_ = self->priv->_curve;
		bezier_get_from_point (_tmp0_, &_tmp1_, &_tmp2_);
		self->priv->_posx = _tmp1_;
		self->priv->_posy = _tmp2_;
		_tmp3_ = self->priv->_from_node;
		connection_disconnect_node (self, _tmp3_);
		_g_object_unref0 (self->priv->_from_node);
		self->priv->_from_node = NULL;
	} else {
		Bezier* _tmp4_;
		gdouble _tmp5_ = 0.0;
		gdouble _tmp6_ = 0.0;
		Node* _tmp7_;
		_tmp4_ = self->priv->_curve;
		bezier_get_to_point (_tmp4_, &_tmp5_, &_tmp6_);
		self->priv->_posx = _tmp5_;
		self->priv->_posy = _tmp6_;
		_tmp7_ = self->priv->_to_node;
		connection_disconnect_node (self, _tmp7_);
		_g_object_unref0 (self->priv->_to_node);
		self->priv->_to_node = NULL;
	}
	connection_set_mode (self, CONN_MODE_CONNECTING);
}

void
connection_draw_to (Connection* self,
                    gdouble x,
                    gdouble y)
{
	gdouble nx = 0.0;
	gdouble ny = 0.0;
	Node* _tmp0_ = NULL;
	Node* _tmp1_;
	Node* node = NULL;
	Node* _tmp4_;
	gint _tmp5_ = 0;
	Node* _tmp6_;
	Node* _tmp7_;
	Bezier* _tmp8_;
	gdouble _tmp9_ = 0.0;
	gdouble _tmp10_ = 0.0;
	gdouble dragx = 0.0;
	gdouble dragy = 0.0;
	Node* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_from_node;
	if (_tmp1_ != NULL) {
		Node* _tmp2_;
		_tmp2_ = self->priv->_from_node;
		_tmp0_ = _tmp2_;
	} else {
		Node* _tmp3_;
		_tmp3_ = self->priv->_to_node;
		_tmp0_ = _tmp3_;
	}
	_tmp4_ = _g_object_ref0 (_tmp0_);
	node = _tmp4_;
	self->priv->_posx = x;
	self->priv->_posy = y;
	_tmp6_ = node;
	_tmp7_ = self->priv->_from_node;
	if (_tmp6_ == _tmp7_) {
		_tmp5_ = 0;
	} else {
		_tmp5_ = 2;
	}
	_tmp8_ = self->priv->_curve;
	bezier_get_point (_tmp8_, _tmp5_, &_tmp9_, &_tmp10_);
	nx = _tmp9_;
	ny = _tmp10_;
	dragx = (nx + x) / 2;
	dragy = (ny + y) / 2;
	connection_set_drag_handle (self, dragx, dragy);
	_tmp11_ = node;
	connection_set_connect_point (self, _tmp11_);
	_g_object_unref0 (node);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_vala_Node_free_function_content_of (gpointer data)
{
	Node* self;
	self = *((Node**) data);
	_g_object_unref0_ (self);
}

static gboolean
connection_common_parent_moved (Connection* self,
                                Node* node)
{
	GArray* parents = NULL;
	GArray* _tmp0_;
	DrawArea* _tmp1_;
	Selection* _tmp2_;
	Selection* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp0_ = g_array_new (TRUE, TRUE, sizeof (Node*));
	g_array_set_clear_func (_tmp0_, (GDestroyNotify) _vala_Node_free_function_content_of);
	parents = _tmp0_;
	_tmp1_ = self->priv->_da;
	_tmp2_ = draw_area_get_selections (_tmp1_);
	_tmp3_ = _tmp2_;
	selection_get_parents (_tmp3_, &parents);
	_selection_unref0 (_tmp3_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				GArray* _tmp6_;
				GArray* _tmp7_;
				Node* _tmp8_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = parents;
				if (!(((guint) i) < _tmp6_->len)) {
					break;
				}
				_tmp7_ = parents;
				_tmp8_ = g_array_index (_tmp7_, Node*, (guint) i);
				if (node_is_descendant_of (node, _tmp8_)) {
					result = TRUE;
					_g_array_unref0 (parents);
					return result;
				}
			}
		}
	}
	result = FALSE;
	_g_array_unref0 (parents);
	return result;
}

static void
connection_end_moved (Connection* self,
                      Node* node,
                      gdouble diffx,
                      gdouble diffy)
{
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble w = 0.0;
	gdouble h = 0.0;
	gdouble dragx = 0.0;
	gdouble dragy = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gboolean from = FALSE;
	Node* _tmp4_;
	gint _tmp5_ = 0;
	Bezier* _tmp6_;
	Node* _tmp7_ = NULL;
	Node* _tmp17_;
	Node* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	node_node_bbox (node, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	x = _tmp0_;
	y = _tmp1_;
	w = _tmp2_;
	h = _tmp3_;
	_tmp4_ = self->priv->_from_node;
	from = _tmp4_ == node;
	if (from) {
		_tmp5_ = 0;
	} else {
		_tmp5_ = 2;
	}
	_tmp6_ = self->priv->_curve;
	bezier_set_point (_tmp6_, _tmp5_, x + (w / 2), y + (h / 2));
	if (from) {
		Node* _tmp8_;
		_tmp8_ = self->priv->_to_node;
		_tmp7_ = _tmp8_;
	} else {
		Node* _tmp9_;
		_tmp9_ = self->priv->_from_node;
		_tmp7_ = _tmp9_;
	}
	if (connection_common_parent_moved (self, _tmp7_)) {
		if (!from) {
			Bezier* _tmp10_;
			gdouble _tmp11_ = 0.0;
			gdouble _tmp12_ = 0.0;
			Bezier* _tmp13_;
			_tmp10_ = self->priv->_curve;
			bezier_get_point (_tmp10_, 1, &_tmp11_, &_tmp12_);
			dragx = _tmp11_;
			dragy = _tmp12_;
			_tmp13_ = self->priv->_curve;
			bezier_set_point (_tmp13_, 1, dragx + diffx, dragy + diffy);
			connection_position_title (self);
		}
	} else {
		Bezier* _tmp14_;
		gdouble _tmp15_ = 0.0;
		gdouble _tmp16_ = 0.0;
		_tmp14_ = self->priv->_curve;
		bezier_get_drag_point (_tmp14_, &_tmp15_, &_tmp16_);
		dragx = _tmp15_;
		dragy = _tmp16_;
		connection_set_drag_handle (self, dragx + (diffx / 2), dragy + (diffy / 2));
	}
	_tmp17_ = self->priv->_from_node;
	connection_set_connect_point (self, _tmp17_);
	_tmp18_ = self->priv->_to_node;
	if (_tmp18_ != NULL) {
		Node* _tmp19_;
		_tmp19_ = self->priv->_to_node;
		connection_set_connect_point (self, _tmp19_);
	}
}

static void
connection_end_resized (Connection* self,
                        Node* node,
                        gdouble diffw,
                        gdouble diffh)
{
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble w = 0.0;
	gdouble h = 0.0;
	gdouble dragx = 0.0;
	gdouble dragy = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gint _tmp4_ = 0;
	Node* _tmp5_;
	Bezier* _tmp6_;
	Bezier* _tmp7_;
	gdouble _tmp8_ = 0.0;
	gdouble _tmp9_ = 0.0;
	Node* _tmp10_;
	Node* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	node_node_bbox (node, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	x = _tmp0_;
	y = _tmp1_;
	w = _tmp2_;
	h = _tmp3_;
	_tmp5_ = self->priv->_from_node;
	if (_tmp5_ == node) {
		_tmp4_ = 0;
	} else {
		_tmp4_ = 2;
	}
	_tmp6_ = self->priv->_curve;
	bezier_set_point (_tmp6_, _tmp4_, x + (w / 2), y + (h / 2));
	_tmp7_ = self->priv->_curve;
	bezier_get_drag_point (_tmp7_, &_tmp8_, &_tmp9_);
	dragx = _tmp8_;
	dragy = _tmp9_;
	dragx += diffw / 2;
	dragy += diffh / 2;
	connection_set_drag_handle (self, dragx, dragy);
	_tmp10_ = self->priv->_from_node;
	connection_set_connect_point (self, _tmp10_);
	_tmp11_ = self->priv->_to_node;
	connection_set_connect_point (self, _tmp11_);
}

gboolean
connection_attached_to_node (Connection* self,
                             Node* node)
{
	gboolean _tmp0_ = FALSE;
	Node* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp1_ = self->priv->_from_node;
	if (_tmp1_ == node) {
		_tmp0_ = TRUE;
	} else {
		Node* _tmp2_;
		_tmp2_ = self->priv->_to_node;
		_tmp0_ = _tmp2_ == node;
	}
	result = _tmp0_;
	return result;
}

static void
connection_set_connect_point (Connection* self,
                              Node* node)
{
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble w = 0.0;
	gdouble h = 0.0;
	gdouble bw = 0.0;
	Style* _tmp0_;
	Style* _tmp1_;
	gint* _tmp2_;
	gint* _tmp3_;
	gdouble extra = 0.0;
	Style* _tmp4_;
	Style* _tmp5_;
	gint* _tmp6_;
	gint* _tmp7_;
	gdouble margin = 0.0;
	Style* _tmp8_;
	Style* _tmp9_;
	gint* _tmp10_;
	gint* _tmp11_;
	gdouble _tmp12_ = 0.0;
	gdouble _tmp13_ = 0.0;
	gdouble _tmp14_ = 0.0;
	gdouble _tmp15_ = 0.0;
	Bezier* _tmp16_;
	Node* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node_get_style (node);
	_tmp1_ = _tmp0_;
	_tmp2_ = style_get_node_borderwidth (_tmp1_);
	_tmp3_ = _tmp2_;
	bw = *_tmp3_;
	_tmp4_ = connection_get_style (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = style_get_connection_line_width (_tmp5_);
	_tmp7_ = _tmp6_;
	extra = bw + ((*_tmp7_) / 2);
	_tmp8_ = node_get_style (node);
	_tmp9_ = _tmp8_;
	_tmp10_ = style_get_node_margin (_tmp9_);
	_tmp11_ = _tmp10_;
	margin = *_tmp11_;
	node_node_bbox (node, &_tmp12_, &_tmp13_, &_tmp14_, &_tmp15_);
	x = _tmp12_;
	y = _tmp13_;
	w = _tmp14_;
	h = _tmp15_;
	x += margin;
	y += margin;
	w -= margin * 2;
	h -= margin * 2;
	_tmp16_ = self->priv->_curve;
	_tmp17_ = self->priv->_from_node;
	bezier_set_connect_point (_tmp16_, node == _tmp17_, y - extra, (y + h) + extra, x - extra, (x + w) + extra);
}

gboolean
connection_on_curve (Connection* self,
                     gdouble x,
                     gdouble y)
{
	Bezier* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_curve;
	result = bezier_within_range (_tmp0_, x, y);
	return result;
}

static gboolean
connection_within_handle (Connection* self,
                          gdouble hx,
                          gdouble hy,
                          gdouble x,
                          gdouble y)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if ((hx - self->priv->RADIUS) <= x) {
		_tmp2_ = x <= (hx + self->priv->RADIUS);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = (hy - self->priv->RADIUS) <= y;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = y <= (hy + self->priv->RADIUS);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
connection_within_drag_handle (Connection* self,
                               gdouble x,
                               gdouble y)
{
	ConnMode _tmp0_;
	ConnMode _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = connection_get_mode (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == CONN_MODE_SELECTED) {
		gdouble dragx = 0.0;
		gdouble dragy = 0.0;
		Bezier* _tmp2_;
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		const gchar* _tmp7_;
		_tmp2_ = self->priv->_curve;
		bezier_get_drag_point (_tmp2_, &_tmp3_, &_tmp4_);
		dragx = _tmp3_;
		dragy = _tmp4_;
		_tmp7_ = self->priv->_sticker;
		if (_tmp7_ == NULL) {
			CanvasText* _tmp8_;
			CanvasText* _tmp9_;
			_tmp8_ = connection_get_title (self);
			_tmp9_ = _tmp8_;
			_tmp6_ = _tmp9_ == NULL;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			_tmp10_ = connection_get_note (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = strlen (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp5_ = _tmp13_ == 0;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			result = connection_within_handle (self, dragx, dragy, x, y);
			return result;
		} else {
			gdouble tx = 0.0;
			gdouble ty = 0.0;
			gdouble tw = 0.0;
			gdouble th = 0.0;
			gdouble _tmp14_ = 0.0;
			gdouble _tmp15_ = 0.0;
			gdouble _tmp16_ = 0.0;
			gdouble _tmp17_ = 0.0;
			Style* _tmp18_;
			gint* _tmp19_;
			gint* _tmp20_;
			connection_title_bbox (self, &_tmp14_, &_tmp15_, &_tmp16_, &_tmp17_);
			tx = _tmp14_;
			ty = _tmp15_;
			tw = _tmp16_;
			th = _tmp17_;
			_tmp18_ = self->priv->_style;
			_tmp19_ = style_get_connection_padding (_tmp18_);
			_tmp20_ = _tmp19_;
			result = connection_within_handle (self, dragx, (dragy + (th / 2)) + (*_tmp20_), x, y);
			return result;
		}
	}
	result = FALSE;
	return result;
}

gboolean
connection_within_from_handle (Connection* self,
                               gdouble x,
                               gdouble y)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = connection_within_endpoint_handle (self, TRUE, x, y);
	return result;
}

gboolean
connection_within_to_handle (Connection* self,
                             gdouble x,
                             gdouble y)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = connection_within_endpoint_handle (self, FALSE, x, y);
	return result;
}

static gboolean
connection_within_endpoint_handle (Connection* self,
                                   gboolean from,
                                   gdouble x,
                                   gdouble y)
{
	ConnMode _tmp0_;
	ConnMode _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = connection_get_mode (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == CONN_MODE_SELECTED) {
		gdouble px = 0.0;
		gdouble py = 0.0;
		if (from) {
			Bezier* _tmp2_;
			gdouble _tmp3_ = 0.0;
			gdouble _tmp4_ = 0.0;
			_tmp2_ = self->priv->_curve;
			bezier_get_from_point (_tmp2_, &_tmp3_, &_tmp4_);
			px = _tmp3_;
			py = _tmp4_;
		} else {
			Bezier* _tmp5_;
			gdouble _tmp6_ = 0.0;
			gdouble _tmp7_ = 0.0;
			_tmp5_ = self->priv->_curve;
			bezier_get_to_point (_tmp5_, &_tmp6_, &_tmp7_);
			px = _tmp6_;
			py = _tmp7_;
		}
		result = connection_within_handle (self, px, py, x, y);
		return result;
	}
	result = FALSE;
	return result;
}

gboolean
connection_within_title_box (Connection* self,
                             gdouble x,
                             gdouble y)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GdkPixbuf* _tmp2_;
	gdouble bx = 0.0;
	gdouble by = 0.0;
	gdouble bw = 0.0;
	gdouble bh = 0.0;
	gdouble _tmp8_ = 0.0;
	gdouble _tmp9_ = 0.0;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp2_ = self->priv->_sticker_buf;
	if (_tmp2_ == NULL) {
		CanvasText* _tmp3_;
		_tmp3_ = self->priv->_title;
		_tmp1_ = _tmp3_ == NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp4_ = connection_get_note (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = strlen (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp0_ = _tmp7_ == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	connection_title_bbox (self, &_tmp8_, &_tmp9_, &_tmp10_, &_tmp11_);
	bx = _tmp8_;
	by = _tmp9_;
	bw = _tmp10_;
	bh = _tmp11_;
	result = utils_is_within_bounds (x, y, bx, by, bw, bh);
	return result;
}

gboolean
connection_within_title (Connection* self,
                         gdouble x,
                         gdouble y)
{
	gboolean _tmp0_ = FALSE;
	CanvasText* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_title;
	if (_tmp1_ != NULL) {
		CanvasText* _tmp2_;
		_tmp2_ = self->priv->_title;
		_tmp0_ = canvas_text_is_within (_tmp2_, x, y);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
connection_within_note (Connection* self,
                        gdouble x,
                        gdouble y)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gdouble nx = 0.0;
	gdouble ny = 0.0;
	gdouble nw = 0.0;
	gdouble nh = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = connection_get_note (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		result = FALSE;
		return result;
	}
	connection_note_bbox (self, &_tmp4_, &_tmp5_, &_tmp6_, &_tmp7_);
	nx = _tmp4_;
	ny = _tmp5_;
	nw = _tmp6_;
	nh = _tmp7_;
	result = utils_is_within_bounds (x, y, nx, ny, nw, nh);
	return result;
}

gboolean
connection_within_sticker (Connection* self,
                           gdouble x,
                           gdouble y)
{
	GdkPixbuf* _tmp0_;
	gdouble sx = 0.0;
	gdouble sy = 0.0;
	gdouble sw = 0.0;
	gdouble sh = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_sticker_buf;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	connection_sticker_bbox (self, &_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_);
	sx = _tmp1_;
	sy = _tmp2_;
	sw = _tmp3_;
	sh = _tmp4_;
	result = utils_is_within_bounds (x, y, sw, sy, sw, sh);
	return result;
}

static void
connection_title_bbox (Connection* self,
                       gdouble* x,
                       gdouble* y,
                       gdouble* w,
                       gdouble* h)
{
	gdouble _vala_x = 0.0;
	gdouble _vala_y = 0.0;
	gdouble _vala_w = 0.0;
	gdouble _vala_h = 0.0;
	gint* _tmp0_ = NULL;
	Style* _tmp1_;
	Style* _tmp2_;
	gint* _tmp3_;
	gint* _tmp4_;
	gint* _tmp5_;
	gint* padding = NULL;
	gint* _tmp8_;
	gint width = 0;
	gint height = 0;
	gdouble dragx = 0.0;
	gdouble dragy = 0.0;
	Bezier* _tmp9_;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	g_return_if_fail (self != NULL);
	_tmp1_ = connection_get_style (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = style_get_connection_padding (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = __int_dup0 (_tmp4_);
	_tmp0_ = _tmp5_;
	if (_tmp0_ == NULL) {
		gint _tmp6_;
		gint* _tmp7_;
		_tmp6_ = 0;
		_tmp7_ = __int_dup0 (&_tmp6_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp7_;
	}
	_tmp8_ = _tmp0_;
	_tmp0_ = NULL;
	padding = _tmp8_;
	width = connection_get_width (self);
	height = connection_get_height (self);
	_tmp9_ = self->priv->_curve;
	bezier_get_drag_point (_tmp9_, &_tmp10_, &_tmp11_);
	dragx = _tmp10_;
	dragy = _tmp11_;
	_vala_x = dragx - ((width / 2) + (*padding));
	_vala_y = dragy - ((height / 2) + (*padding));
	_vala_w = (gdouble) (width + ((*padding) * 2));
	_vala_h = (gdouble) (height + ((*padding) * 2));
	_g_free0 (padding);
	_g_free0 (_tmp0_);
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
	if (w) {
		*w = _vala_w;
	}
	if (h) {
		*h = _vala_h;
	}
}

static void
connection_note_bbox (Connection* self,
                      gdouble* x,
                      gdouble* y,
                      gdouble* w,
                      gdouble* h)
{
	gdouble _vala_x = 0.0;
	gdouble _vala_y = 0.0;
	gdouble _vala_w = 0.0;
	gdouble _vala_h = 0.0;
	gint width = 0;
	gint nwidth = 0;
	gint nheight = 0;
	gdouble dragx = 0.0;
	gdouble dragy = 0.0;
	Bezier* _tmp0_;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	g_return_if_fail (self != NULL);
	width = connection_get_width (self);
	nwidth = connection_note_width (self, FALSE);
	nheight = connection_note_height (self);
	_tmp0_ = self->priv->_curve;
	bezier_get_drag_point (_tmp0_, &_tmp1_, &_tmp2_);
	dragx = _tmp1_;
	dragy = _tmp2_;
	_vala_x = (dragx + (width / 2)) - nwidth;
	_vala_y = dragy - (nheight / 2);
	_vala_w = (gdouble) nwidth;
	_vala_h = (gdouble) nheight;
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
	if (w) {
		*w = _vala_w;
	}
	if (h) {
		*h = _vala_h;
	}
}

static void
connection_sticker_bbox (Connection* self,
                         gdouble* x,
                         gdouble* y,
                         gdouble* w,
                         gdouble* h)
{
	gdouble _vala_x = 0.0;
	gdouble _vala_y = 0.0;
	gdouble _vala_w = 0.0;
	gdouble _vala_h = 0.0;
	gint width = 0;
	gint swidth = 0;
	gint sheight = 0;
	gdouble dragx = 0.0;
	gdouble dragy = 0.0;
	Bezier* _tmp0_;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	g_return_if_fail (self != NULL);
	width = connection_get_width (self);
	swidth = connection_sticker_width (self, FALSE);
	sheight = connection_sticker_height (self);
	_tmp0_ = self->priv->_curve;
	bezier_get_drag_point (_tmp0_, &_tmp1_, &_tmp2_);
	dragx = _tmp1_;
	dragy = _tmp2_;
	_vala_x = dragx - (width / 2);
	_vala_y = dragy - (sheight / 2);
	_vala_w = (gdouble) swidth;
	_vala_h = (gdouble) sheight;
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
	if (w) {
		*w = _vala_w;
	}
	if (h) {
		*h = _vala_h;
	}
}

void
connection_move_drag_handle (Connection* self,
                             gdouble x,
                             gdouble y)
{
	CanvasText* _tmp0_;
	CanvasText* _tmp1_;
	Node* _tmp6_;
	Node* _tmp7_;
	g_return_if_fail (self != NULL);
	connection_set_mode (self, CONN_MODE_ADJUSTING);
	_tmp0_ = connection_get_title (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		gdouble tx = 0.0;
		gdouble ty = 0.0;
		gdouble tw = 0.0;
		gdouble th = 0.0;
		gdouble _tmp2_ = 0.0;
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
		gdouble _tmp5_ = 0.0;
		connection_title_bbox (self, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_);
		tx = _tmp2_;
		ty = _tmp3_;
		tw = _tmp4_;
		th = _tmp5_;
		y = y - (th / 2);
	}
	connection_set_drag_handle (self, x, y);
	_tmp6_ = self->priv->_from_node;
	connection_set_connect_point (self, _tmp6_);
	_tmp7_ = self->priv->_to_node;
	connection_set_connect_point (self, _tmp7_);
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

static void
connection_load (Connection* self,
                 DrawArea* da,
                 xmlNode* node,
                 GArray* nodes)
{
	gdouble dragx = 0.0;
	gdouble dragy = 0.0;
	gchar* f = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* t = NULL;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* x = NULL;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* y = NULL;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* n = NULL;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* c = NULL;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	gchar* sk = NULL;
	gchar* _tmp32_;
	const gchar* _tmp33_;
	gdouble fx = 0.0;
	gdouble fy = 0.0;
	gdouble fw = 0.0;
	gdouble fh = 0.0;
	gdouble tx = 0.0;
	gdouble ty = 0.0;
	gdouble tw = 0.0;
	gdouble th = 0.0;
	Node* _tmp35_;
	gdouble _tmp36_ = 0.0;
	gdouble _tmp37_ = 0.0;
	gdouble _tmp38_ = 0.0;
	gdouble _tmp39_ = 0.0;
	Node* _tmp40_;
	gdouble _tmp41_ = 0.0;
	gdouble _tmp42_ = 0.0;
	gdouble _tmp43_ = 0.0;
	gdouble _tmp44_ = 0.0;
	DrawArea* _tmp45_;
	Bezier* _tmp46_;
	Bezier* _tmp47_;
	Node* _tmp48_;
	Node* _tmp49_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (da != NULL);
	g_return_if_fail (nodes != NULL);
	dragx = (gdouble) 0;
	dragy = (gdouble) 0;
	_tmp0_ = (gchar*) xmlGetProp (node, (xmlChar*) "from_id");
	f = _tmp0_;
	_tmp1_ = f;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		Node* _tmp3_;
		Node* _tmp4_;
		_tmp2_ = f;
		_tmp3_ = draw_area_get_node (da, nodes, atoi (_tmp2_));
		_g_object_unref0 (self->priv->_from_node);
		self->priv->_from_node = _tmp3_;
		_tmp4_ = self->priv->_from_node;
		connection_connect_node (self, _tmp4_);
	}
	_tmp5_ = (gchar*) xmlGetProp (node, (xmlChar*) "to_id");
	t = _tmp5_;
	_tmp6_ = t;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		Node* _tmp8_;
		Node* _tmp9_;
		_tmp7_ = t;
		_tmp8_ = draw_area_get_node (da, nodes, atoi (_tmp7_));
		_g_object_unref0 (self->priv->_to_node);
		self->priv->_to_node = _tmp8_;
		_tmp9_ = self->priv->_to_node;
		connection_connect_node (self, _tmp9_);
	}
	_tmp10_ = (gchar*) xmlGetProp (node, (xmlChar*) "drag_x");
	x = _tmp10_;
	_tmp11_ = x;
	if (_tmp11_ != NULL) {
		const gchar* _tmp12_;
		DrawArea* _tmp13_;
		gdouble _tmp14_;
		gdouble _tmp15_;
		_tmp12_ = x;
		_tmp13_ = self->priv->_da;
		_tmp14_ = draw_area_get_origin_x (_tmp13_);
		_tmp15_ = _tmp14_;
		dragx = double_parse (_tmp12_) + _tmp15_;
	}
	_tmp16_ = (gchar*) xmlGetProp (node, (xmlChar*) "drag_y");
	y = _tmp16_;
	_tmp17_ = y;
	if (_tmp17_ != NULL) {
		const gchar* _tmp18_;
		DrawArea* _tmp19_;
		gdouble _tmp20_;
		gdouble _tmp21_;
		_tmp18_ = y;
		_tmp19_ = self->priv->_da;
		_tmp20_ = draw_area_get_origin_y (_tmp19_);
		_tmp21_ = _tmp20_;
		dragy = double_parse (_tmp18_) + _tmp21_;
	}
	_tmp22_ = (gchar*) xmlGetProp (node, (xmlChar*) "note");
	n = _tmp22_;
	_tmp23_ = n;
	if (_tmp23_ != NULL) {
		const gchar* _tmp24_;
		_tmp24_ = n;
		connection_set_note (self, _tmp24_);
	}
	_tmp25_ = (gchar*) xmlGetProp (node, (xmlChar*) "color");
	c = _tmp25_;
	_tmp26_ = c;
	if (_tmp26_ != NULL) {
		Theme* _tmp27_;
		Theme* _tmp28_;
		GdkRGBA* _tmp29_;
		GdkRGBA* _tmp30_;
		const gchar* _tmp31_;
		_tmp27_ = draw_area_get_theme (da);
		_tmp28_ = _tmp27_;
		_tmp29_ = theme_get_color (_tmp28_, "connection_background");
		__vala_GdkRGBA_free0 (self->priv->_color);
		self->priv->_color = _tmp29_;
		_g_object_unref0 (_tmp28_);
		_tmp30_ = self->priv->_color;
		_tmp31_ = c;
		gdk_rgba_parse (_tmp30_, _tmp31_);
	}
	_tmp32_ = (gchar*) xmlGetProp (node, (xmlChar*) "sticker");
	sk = _tmp32_;
	_tmp33_ = sk;
	if (_tmp33_ != NULL) {
		const gchar* _tmp34_;
		_tmp34_ = sk;
		connection_set_sticker (self, _tmp34_);
	}
	_tmp35_ = self->priv->_from_node;
	node_node_bbox (_tmp35_, &_tmp36_, &_tmp37_, &_tmp38_, &_tmp39_);
	fx = _tmp36_;
	fy = _tmp37_;
	fw = _tmp38_;
	fh = _tmp39_;
	_tmp40_ = self->priv->_to_node;
	node_node_bbox (_tmp40_, &_tmp41_, &_tmp42_, &_tmp43_, &_tmp44_);
	tx = _tmp41_;
	ty = _tmp42_;
	tw = _tmp43_;
	th = _tmp44_;
	_tmp45_ = self->priv->_da;
	_tmp46_ = bezier_new_with_endpoints (_tmp45_, fx + (fw / 2), fy + (fh / 2), tx + (tw / 2), ty + (th / 2));
	_bezier_unref0 (self->priv->_curve);
	self->priv->_curve = _tmp46_;
	_tmp47_ = self->priv->_curve;
	bezier_update_control_from_drag_handle (_tmp47_, dragx, dragy);
	_tmp48_ = self->priv->_from_node;
	connection_set_connect_point (self, _tmp48_);
	_tmp49_ = self->priv->_to_node;
	connection_set_connect_point (self, _tmp49_);
	{
		xmlNode* it = NULL;
		xmlNode* _tmp50_;
		_tmp50_ = node->children;
		it = _tmp50_;
		{
			gboolean _tmp51_ = FALSE;
			_tmp51_ = TRUE;
			while (TRUE) {
				xmlNode* _tmp54_;
				xmlNode* _tmp55_;
				if (!_tmp51_) {
					xmlNode* _tmp52_;
					xmlNode* _tmp53_;
					_tmp52_ = it;
					_tmp53_ = _tmp52_->next;
					it = _tmp53_;
				}
				_tmp51_ = FALSE;
				_tmp54_ = it;
				if (!(_tmp54_ != NULL)) {
					break;
				}
				_tmp55_ = it;
				if (_tmp55_->type == XML_ELEMENT_NODE) {
					xmlNode* _tmp56_;
					const gchar* _tmp57_;
					const gchar* _tmp58_;
					GQuark _tmp60_ = 0U;
					static GQuark _tmp59_label0 = 0;
					static GQuark _tmp59_label1 = 0;
					static GQuark _tmp59_label2 = 0;
					_tmp56_ = it;
					_tmp57_ = _tmp56_->name;
					_tmp58_ = _tmp57_;
					_tmp60_ = (NULL == _tmp58_) ? 0 : g_quark_from_string (_tmp58_);
					if (_tmp60_ == ((0 != _tmp59_label0) ? _tmp59_label0 : (_tmp59_label0 = g_quark_from_static_string ("style")))) {
						switch (0) {
							default:
							{
								Style* _tmp61_;
								Style* _tmp62_;
								xmlNode* _tmp63_;
								_tmp61_ = connection_get_style (self);
								_tmp62_ = _tmp61_;
								_tmp63_ = it;
								style_load_connection (_tmp62_, _tmp63_);
								break;
							}
						}
					} else if (_tmp60_ == ((0 != _tmp59_label1) ? _tmp59_label1 : (_tmp59_label1 = g_quark_from_static_string ("title")))) {
						switch (0) {
							default:
							{
								gboolean _tmp64_ = FALSE;
								xmlNode* _tmp65_;
								xmlNode* _tmp66_;
								_tmp65_ = it;
								_tmp66_ = _tmp65_->children;
								if (_tmp66_ != NULL) {
									xmlNode* _tmp67_;
									xmlNode* _tmp68_;
									_tmp67_ = it;
									_tmp68_ = _tmp67_->children;
									_tmp64_ = _tmp68_->type == XML_TEXT_NODE;
								} else {
									_tmp64_ = FALSE;
								}
								if (_tmp64_) {
									xmlNode* _tmp69_;
									xmlNode* _tmp70_;
									gchar* _tmp71_;
									gchar* _tmp72_;
									_tmp69_ = it;
									_tmp70_ = _tmp69_->children;
									_tmp71_ = (gchar*) xmlNodeGetContent (_tmp70_);
									_tmp72_ = _tmp71_;
									connection_change_title (self, da, _tmp72_, FALSE);
									_g_free0 (_tmp72_);
								}
								break;
							}
						}
					} else if (_tmp60_ == ((0 != _tmp59_label2) ? _tmp59_label2 : (_tmp59_label2 = g_quark_from_static_string ("note")))) {
						switch (0) {
							default:
							{
								gboolean _tmp73_ = FALSE;
								xmlNode* _tmp74_;
								xmlNode* _tmp75_;
								_tmp74_ = it;
								_tmp75_ = _tmp74_->children;
								if (_tmp75_ != NULL) {
									xmlNode* _tmp76_;
									xmlNode* _tmp77_;
									_tmp76_ = it;
									_tmp77_ = _tmp76_->children;
									_tmp73_ = _tmp77_->type == XML_TEXT_NODE;
								} else {
									_tmp73_ = FALSE;
								}
								if (_tmp73_) {
									xmlNode* _tmp78_;
									xmlNode* _tmp79_;
									gchar* _tmp80_;
									gchar* _tmp81_;
									_tmp78_ = it;
									_tmp79_ = _tmp78_->children;
									_tmp80_ = (gchar*) xmlNodeGetContent (_tmp79_);
									_tmp81_ = _tmp80_;
									connection_set_note (self, _tmp81_);
									_g_free0 (_tmp81_);
								}
								break;
							}
						}
					}
				}
			}
		}
	}
	_g_free0 (sk);
	_g_free0 (c);
	_g_free0 (n);
	_g_free0 (y);
	_g_free0 (x);
	_g_free0 (t);
	_g_free0 (f);
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

void
connection_save (Connection* self,
                 xmlNode* parent)
{
	gdouble dragx = 0.0;
	gdouble dragy = 0.0;
	Bezier* _tmp0_;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	DrawArea* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	DrawArea* _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	xmlNode* n = NULL;
	xmlNode* _tmp9_;
	xmlNode* _tmp10_;
	Node* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	xmlNode* _tmp14_;
	Node* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	xmlNode* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	xmlNode* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GdkRGBA* _tmp24_;
	const gchar* _tmp30_;
	Style* _tmp33_;
	Style* _tmp34_;
	xmlNode* _tmp35_;
	const gchar* _tmp36_ = NULL;
	CanvasText* _tmp37_;
	CanvasText* _tmp38_;
	xmlNode* _tmp45_;
	xmlNode* _tmp46_;
	const gchar* _tmp47_;
	const gchar* _tmp48_;
	xmlNode* _tmp49_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_curve;
	bezier_get_drag_point (_tmp0_, &_tmp1_, &_tmp2_);
	dragx = _tmp1_;
	dragy = _tmp2_;
	_tmp3_ = self->priv->_da;
	_tmp4_ = draw_area_get_origin_x (_tmp3_);
	_tmp5_ = _tmp4_;
	dragx -= _tmp5_;
	_tmp6_ = self->priv->_da;
	_tmp7_ = draw_area_get_origin_y (_tmp6_);
	_tmp8_ = _tmp7_;
	dragy -= _tmp8_;
	_tmp9_ = xmlNewNode (NULL, (xmlChar*) "connection");
	n = _tmp9_;
	_tmp10_ = n;
	_tmp11_ = self->priv->_from_node;
	_tmp12_ = g_strdup_printf ("%i", node_id (_tmp11_));
	_tmp13_ = _tmp12_;
	xmlSetProp (_tmp10_, (xmlChar*) "from_id", (xmlChar*) _tmp13_);
	_g_free0 (_tmp13_);
	_tmp14_ = n;
	_tmp15_ = self->priv->_to_node;
	_tmp16_ = g_strdup_printf ("%i", node_id (_tmp15_));
	_tmp17_ = _tmp16_;
	xmlSetProp (_tmp14_, (xmlChar*) "to_id", (xmlChar*) _tmp17_);
	_g_free0 (_tmp17_);
	_tmp18_ = n;
	_tmp19_ = double_to_string (dragx);
	_tmp20_ = _tmp19_;
	xmlSetProp (_tmp18_, (xmlChar*) "drag_x", (xmlChar*) _tmp20_);
	_g_free0 (_tmp20_);
	_tmp21_ = n;
	_tmp22_ = double_to_string (dragy);
	_tmp23_ = _tmp22_;
	xmlSetProp (_tmp21_, (xmlChar*) "drag_y", (xmlChar*) _tmp23_);
	_g_free0 (_tmp23_);
	_tmp24_ = self->priv->_color;
	if (_tmp24_ != NULL) {
		xmlNode* _tmp25_;
		GdkRGBA* _tmp26_;
		GdkRGBA _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		_tmp25_ = n;
		_tmp26_ = self->priv->_color;
		_tmp27_ = *_tmp26_;
		_tmp28_ = utils_color_from_rgba (&_tmp27_);
		_tmp29_ = _tmp28_;
		xmlSetProp (_tmp25_, (xmlChar*) "color", (xmlChar*) _tmp29_);
		_g_free0 (_tmp29_);
	}
	_tmp30_ = self->priv->_sticker;
	if (_tmp30_ != NULL) {
		xmlNode* _tmp31_;
		const gchar* _tmp32_;
		_tmp31_ = n;
		_tmp32_ = self->priv->_sticker;
		xmlSetProp (_tmp31_, (xmlChar*) "sticker", (xmlChar*) _tmp32_);
	}
	_tmp33_ = connection_get_style (self);
	_tmp34_ = _tmp33_;
	_tmp35_ = n;
	style_save_connection (_tmp34_, _tmp35_);
	_tmp37_ = connection_get_title (self);
	_tmp38_ = _tmp37_;
	if (_tmp38_ != NULL) {
		CanvasText* _tmp39_;
		CanvasText* _tmp40_;
		FormattedText* _tmp41_;
		FormattedText* _tmp42_;
		const gchar* _tmp43_;
		const gchar* _tmp44_;
		_tmp39_ = connection_get_title (self);
		_tmp40_ = _tmp39_;
		_tmp41_ = canvas_text_get_text (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = formatted_text_get_text (_tmp42_);
		_tmp44_ = _tmp43_;
		_tmp36_ = _tmp44_;
	} else {
		_tmp36_ = "";
	}
	_tmp45_ = n;
	xmlNewTextChild (_tmp45_, NULL, (xmlChar*) "title", (xmlChar*) _tmp36_);
	_tmp46_ = n;
	_tmp47_ = connection_get_note (self);
	_tmp48_ = _tmp47_;
	xmlNewTextChild (_tmp46_, NULL, (xmlChar*) "note", (xmlChar*) _tmp48_);
	_tmp49_ = n;
	xmlAddChild (parent, _tmp49_);
}

void
connection_get_match_items (Connection* self,
                            const gchar* tabname,
                            const gchar* pattern,
                            gboolean* search_opts,
                            gint search_opts_length1,
                            GtkListStore** matches)
{
	gchar* tab = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tabname != NULL);
	g_return_if_fail (pattern != NULL);
	g_return_if_fail (*matches != NULL);
	_tmp0_ = utils_rootname (tabname);
	tab = _tmp0_;
	_tmp2_ = search_opts[SEARCH_OPTIONS_TITLES];
	if (_tmp2_) {
		CanvasText* _tmp3_;
		CanvasText* _tmp4_;
		_tmp3_ = connection_get_title (self);
		_tmp4_ = _tmp3_;
		_tmp1_ = _tmp4_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar* str = NULL;
		CanvasText* _tmp5_;
		CanvasText* _tmp6_;
		FormattedText* _tmp7_;
		FormattedText* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		_tmp5_ = connection_get_title (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = canvas_text_get_text (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = formatted_text_get_text (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = utils_match_string (pattern, _tmp10_);
		str = _tmp11_;
		_tmp12_ = str;
		_tmp13_ = strlen (_tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp14_ > 0) {
			GtkTreeIter it = {0};
			GtkTreeIter _tmp15_ = {0};
			GtkTreeIter _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			gtk_list_store_append (*matches, &_tmp15_);
			it = _tmp15_;
			_tmp16_ = it;
			_tmp17_ = g_strdup_printf ("<b><i>%s:</i></b>", _ ("Connection Title"));
			_tmp18_ = _tmp17_;
			_tmp19_ = str;
			_tmp20_ = tab;
			gtk_list_store_set (*matches, &_tmp16_, 0, _tmp18_, 1, _tmp19_, 2, NULL, 3, self, 4, NULL, 5, NULL, 6, tabname, 7, _tmp20_, -1, -1);
			_g_free0 (_tmp18_);
		}
		_g_free0 (str);
	}
	_tmp21_ = search_opts[SEARCH_OPTIONS_NOTES];
	if (_tmp21_) {
		gchar* str = NULL;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		const gchar* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		_tmp22_ = connection_get_note (self);
		_tmp23_ = _tmp22_;
		_tmp24_ = utils_match_string (pattern, _tmp23_);
		str = _tmp24_;
		_tmp25_ = str;
		_tmp26_ = strlen (_tmp25_);
		_tmp27_ = _tmp26_;
		if (_tmp27_ > 0) {
			GtkTreeIter it = {0};
			GtkTreeIter _tmp28_ = {0};
			GtkTreeIter _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			const gchar* _tmp32_;
			const gchar* _tmp33_;
			gtk_list_store_append (*matches, &_tmp28_);
			it = _tmp28_;
			_tmp29_ = it;
			_tmp30_ = g_strdup_printf ("<b><i>%s:</i></b>", _ ("Connection Note"));
			_tmp31_ = _tmp30_;
			_tmp32_ = str;
			_tmp33_ = tab;
			gtk_list_store_set (*matches, &_tmp29_, 0, _tmp31_, 1, _tmp32_, 2, NULL, 3, self, 4, NULL, 5, NULL, 6, tabname, 7, _tmp33_, -1, -1);
			_g_free0 (_tmp31_);
		}
		_g_free0 (str);
	}
	_g_free0 (tab);
}

static GdkRGBA*
_vala_GdkRGBA_copy (GdkRGBA* self)
{
	return g_boxed_copy (gdk_rgba_get_type (), self);
}

static gpointer
__vala_GdkRGBA_copy0 (gpointer self)
{
	return self ? _vala_GdkRGBA_copy (self) : NULL;
}

static void
connection_real_draw (Connection* self,
                      cairo_t* ctx,
                      Theme* theme,
                      gboolean exporting)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	Node* _tmp3_;
	gdouble start_x = 0.0;
	gdouble start_y = 0.0;
	gdouble end_x = 0.0;
	gdouble end_y = 0.0;
	GdkRGBA* _tmp15_ = NULL;
	GdkRGBA* _tmp16_;
	GdkRGBA ccolor = {0};
	GdkRGBA* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	ConnMode _tmp22_;
	ConnMode _tmp23_;
	GdkRGBA bg = {0};
	Node* _tmp26_;
	Node* _tmp30_;
	gdouble cx = 0.0;
	gdouble cy = 0.0;
	Bezier* _tmp34_;
	gdouble _tmp35_ = 0.0;
	gdouble _tmp36_ = 0.0;
	Style* _tmp37_;
	Style* _tmp38_;
	GdkRGBA _tmp39_;
	gdouble _tmp40_;
	gdouble _tmp41_;
	gdouble x1 = 0.0;
	gdouble y1 = 0.0;
	gdouble x2 = 0.0;
	gdouble y2 = 0.0;
	gdouble _tmp42_ = 0.0;
	gdouble _tmp43_ = 0.0;
	gdouble _tmp44_ = 0.0;
	gdouble _tmp45_ = 0.0;
	gdouble* _tmp46_;
	gdouble* _tmp47_;
	gint _tmp47__length1;
	gboolean _tmp48_ = FALSE;
	ConnMode _tmp49_;
	ConnMode _tmp50_;
	gboolean _tmp77_ = FALSE;
	ConnMode _tmp78_;
	ConnMode _tmp79_;
	gboolean _tmp100_ = FALSE;
	gboolean _tmp101_ = FALSE;
	const gchar* _tmp102_;
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (theme != NULL);
	_tmp3_ = self->priv->_from_node;
	if (_tmp3_ != NULL) {
		Node* _tmp4_;
		_tmp4_ = self->priv->_from_node;
		_tmp2_ = !node_is_root (_tmp4_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		Node* _tmp5_;
		Node* _tmp6_;
		Node* _tmp7_;
		_tmp5_ = self->priv->_from_node;
		_tmp6_ = node_folded_ancestor (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = _tmp7_ != NULL;
		_g_object_unref0 (_tmp7_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		Node* _tmp10_;
		_tmp10_ = self->priv->_to_node;
		if (_tmp10_ != NULL) {
			Node* _tmp11_;
			_tmp11_ = self->priv->_to_node;
			_tmp9_ = !node_is_root (_tmp11_);
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			Node* _tmp12_;
			Node* _tmp13_;
			Node* _tmp14_;
			_tmp12_ = self->priv->_to_node;
			_tmp13_ = node_folded_ancestor (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp8_ = _tmp14_ != NULL;
			_g_object_unref0 (_tmp14_);
		} else {
			_tmp8_ = FALSE;
		}
		_tmp0_ = _tmp8_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp16_ = self->priv->_color;
	if (_tmp16_ != NULL) {
		GdkRGBA* _tmp17_;
		GdkRGBA* _tmp18_;
		_tmp17_ = self->priv->_color;
		_tmp18_ = __vala_GdkRGBA_copy0 (_tmp17_);
		__vala_GdkRGBA_free0 (_tmp15_);
		_tmp15_ = _tmp18_;
	} else {
		GdkRGBA* _tmp19_;
		_tmp19_ = theme_get_color (theme, "connection_background");
		__vala_GdkRGBA_free0 (_tmp15_);
		_tmp15_ = _tmp19_;
	}
	ccolor = *_tmp15_;
	_tmp22_ = connection_get_mode (self);
	_tmp23_ = _tmp22_;
	if (_tmp23_ == CONN_MODE_NONE) {
		_tmp21_ = TRUE;
	} else {
		_tmp21_ = exporting;
	}
	if (_tmp21_) {
		GdkRGBA* _tmp24_;
		_tmp24_ = theme_get_color (theme, "background");
		__vala_GdkRGBA_free0 (_tmp20_);
		_tmp20_ = _tmp24_;
	} else {
		GdkRGBA* _tmp25_;
		_tmp25_ = theme_get_color (theme, "nodesel_background");
		__vala_GdkRGBA_free0 (_tmp20_);
		_tmp20_ = _tmp25_;
	}
	bg = *_tmp20_;
	_tmp26_ = self->priv->_from_node;
	if (_tmp26_ == NULL) {
		start_x = self->priv->_posx;
		start_y = self->priv->_posy;
	} else {
		Bezier* _tmp27_;
		gdouble _tmp28_ = 0.0;
		gdouble _tmp29_ = 0.0;
		_tmp27_ = self->priv->_curve;
		bezier_get_from_point (_tmp27_, &_tmp28_, &_tmp29_);
		start_x = _tmp28_;
		start_y = _tmp29_;
	}
	_tmp30_ = self->priv->_to_node;
	if (_tmp30_ == NULL) {
		end_x = self->priv->_posx;
		end_y = self->priv->_posy;
	} else {
		Bezier* _tmp31_;
		gdouble _tmp32_ = 0.0;
		gdouble _tmp33_ = 0.0;
		_tmp31_ = self->priv->_curve;
		bezier_get_to_point (_tmp31_, &_tmp32_, &_tmp33_);
		end_x = _tmp32_;
		end_y = _tmp33_;
	}
	_tmp34_ = self->priv->_curve;
	bezier_get_point (_tmp34_, 1, &_tmp35_, &_tmp36_);
	cx = _tmp35_;
	cy = _tmp36_;
	cairo_save (ctx);
	_tmp37_ = connection_get_style (self);
	_tmp38_ = _tmp37_;
	style_draw_connection (_tmp38_, ctx);
	_tmp39_ = ccolor;
	_tmp40_ = connection_get_alpha (self);
	_tmp41_ = _tmp40_;
	utils_set_context_color_with_alpha (ctx, &_tmp39_, _tmp41_);
	cairo_move_to (ctx, start_x, start_y);
	cairo_curve_to (ctx, ((2.0 / 3.0) * cx) + ((1.0 / 3.0) * start_x), ((2.0 / 3.0) * cy) + ((1.0 / 3.0) * start_y), ((2.0 / 3.0) * cx) + ((1.0 / 3.0) * end_x), ((2.0 / 3.0) * cy) + ((1.0 / 3.0) * end_y), end_x, end_y);
	cairo_stroke_extents (ctx, &_tmp42_, &_tmp43_, &_tmp44_, &_tmp45_);
	x1 = _tmp42_;
	y1 = _tmp43_;
	x2 = _tmp44_;
	y2 = _tmp45_;
	connection_set_extent_x1 (self, x1);
	connection_set_extent_y1 (self, y1);
	connection_set_extent_x2 (self, x2);
	connection_set_extent_y2 (self, y2);
	cairo_stroke (ctx);
	_tmp46_ = g_new0 (gdouble, 0);
	_tmp47_ = _tmp46_;
	_tmp47__length1 = 0;
	cairo_set_dash (ctx, _tmp47_, (gint) 0, (gdouble) 0);
	_tmp47_ = (g_free (_tmp47_), NULL);
	_tmp49_ = connection_get_mode (self);
	_tmp50_ = _tmp49_;
	if (_tmp50_ != CONN_MODE_SELECTED) {
		_tmp48_ = TRUE;
	} else {
		_tmp48_ = exporting;
	}
	if (_tmp48_) {
		gboolean _tmp51_ = FALSE;
		Style* _tmp52_;
		Style* _tmp53_;
		const gchar* _tmp54_;
		const gchar* _tmp55_;
		gboolean _tmp64_ = FALSE;
		Style* _tmp65_;
		Style* _tmp66_;
		const gchar* _tmp67_;
		const gchar* _tmp68_;
		_tmp52_ = connection_get_style (self);
		_tmp53_ = _tmp52_;
		_tmp54_ = style_get_connection_arrow (_tmp53_);
		_tmp55_ = _tmp54_;
		if (g_strcmp0 (_tmp55_, "fromto") == 0) {
			_tmp51_ = TRUE;
		} else {
			Style* _tmp56_;
			Style* _tmp57_;
			const gchar* _tmp58_;
			const gchar* _tmp59_;
			_tmp56_ = connection_get_style (self);
			_tmp57_ = _tmp56_;
			_tmp58_ = style_get_connection_arrow (_tmp57_);
			_tmp59_ = _tmp58_;
			_tmp51_ = g_strcmp0 (_tmp59_, "both") == 0;
		}
		if (_tmp51_) {
			Style* _tmp60_;
			Style* _tmp61_;
			gint* _tmp62_;
			gint* _tmp63_;
			_tmp60_ = connection_get_style (self);
			_tmp61_ = _tmp60_;
			_tmp62_ = style_get_connection_line_width (_tmp61_);
			_tmp63_ = _tmp62_;
			connection_draw_arrow (ctx, *_tmp63_, end_x, end_y, cx, cy, (gdouble) 0);
		}
		_tmp65_ = connection_get_style (self);
		_tmp66_ = _tmp65_;
		_tmp67_ = style_get_connection_arrow (_tmp66_);
		_tmp68_ = _tmp67_;
		if (g_strcmp0 (_tmp68_, "tofrom") == 0) {
			_tmp64_ = TRUE;
		} else {
			Style* _tmp69_;
			Style* _tmp70_;
			const gchar* _tmp71_;
			const gchar* _tmp72_;
			_tmp69_ = connection_get_style (self);
			_tmp70_ = _tmp69_;
			_tmp71_ = style_get_connection_arrow (_tmp70_);
			_tmp72_ = _tmp71_;
			_tmp64_ = g_strcmp0 (_tmp72_, "both") == 0;
		}
		if (_tmp64_) {
			Style* _tmp73_;
			Style* _tmp74_;
			gint* _tmp75_;
			gint* _tmp76_;
			_tmp73_ = connection_get_style (self);
			_tmp74_ = _tmp73_;
			_tmp75_ = style_get_connection_line_width (_tmp74_);
			_tmp76_ = _tmp75_;
			connection_draw_arrow (ctx, *_tmp76_, start_x, start_y, cx, cy, (gdouble) 0);
		}
	}
	_tmp78_ = connection_get_mode (self);
	_tmp79_ = _tmp78_;
	if (_tmp79_ == CONN_MODE_SELECTED) {
		_tmp77_ = !exporting;
	} else {
		_tmp77_ = FALSE;
	}
	if (_tmp77_) {
		GdkRGBA _tmp80_;
		GdkRGBA _tmp81_;
		GdkRGBA _tmp82_;
		gdouble _tmp83_;
		gdouble _tmp84_;
		GdkRGBA _tmp85_;
		GdkRGBA _tmp86_;
		GdkRGBA _tmp87_;
		gdouble _tmp88_;
		gdouble _tmp89_;
		GdkRGBA _tmp90_;
		GdkRGBA _tmp91_;
		GdkRGBA _tmp92_;
		gdouble _tmp93_;
		gdouble _tmp94_;
		GdkRGBA _tmp95_;
		GdkRGBA _tmp96_;
		GdkRGBA _tmp97_;
		gdouble _tmp98_;
		gdouble _tmp99_;
		_tmp80_ = bg;
		_tmp81_ = bg;
		_tmp82_ = bg;
		_tmp83_ = connection_get_alpha (self);
		_tmp84_ = _tmp83_;
		cairo_set_source_rgba (ctx, _tmp80_.red, _tmp81_.green, _tmp82_.blue, _tmp84_);
		cairo_arc (ctx, start_x, start_y, (gdouble) self->priv->RADIUS, (gdouble) 0, 2 * G_PI);
		cairo_fill_preserve (ctx);
		_tmp85_ = ccolor;
		_tmp86_ = ccolor;
		_tmp87_ = ccolor;
		_tmp88_ = connection_get_alpha (self);
		_tmp89_ = _tmp88_;
		cairo_set_source_rgba (ctx, _tmp85_.red, _tmp86_.green, _tmp87_.blue, _tmp89_);
		cairo_stroke (ctx);
		_tmp90_ = bg;
		_tmp91_ = bg;
		_tmp92_ = bg;
		_tmp93_ = connection_get_alpha (self);
		_tmp94_ = _tmp93_;
		cairo_set_source_rgba (ctx, _tmp90_.red, _tmp91_.green, _tmp92_.blue, _tmp94_);
		cairo_arc (ctx, end_x, end_y, (gdouble) self->priv->RADIUS, (gdouble) 0, 2 * G_PI);
		cairo_fill_preserve (ctx);
		_tmp95_ = ccolor;
		_tmp96_ = ccolor;
		_tmp97_ = ccolor;
		_tmp98_ = connection_get_alpha (self);
		_tmp99_ = _tmp98_;
		cairo_set_source_rgba (ctx, _tmp95_.red, _tmp96_.green, _tmp97_.blue, _tmp99_);
		cairo_stroke (ctx);
	}
	_tmp102_ = self->priv->_sticker;
	if (_tmp102_ != NULL) {
		_tmp101_ = TRUE;
	} else {
		CanvasText* _tmp103_;
		CanvasText* _tmp104_;
		_tmp103_ = connection_get_title (self);
		_tmp104_ = _tmp103_;
		_tmp101_ = _tmp104_ != NULL;
	}
	if (_tmp101_) {
		_tmp100_ = TRUE;
	} else {
		const gchar* _tmp105_;
		const gchar* _tmp106_;
		gint _tmp107_;
		gint _tmp108_;
		_tmp105_ = connection_get_note (self);
		_tmp106_ = _tmp105_;
		_tmp107_ = strlen (_tmp106_);
		_tmp108_ = _tmp107_;
		_tmp100_ = _tmp108_ > 0;
	}
	if (_tmp100_) {
		connection_draw_title (self, ctx, theme, exporting);
	} else {
		gboolean _tmp109_ = FALSE;
		ConnMode _tmp110_;
		ConnMode _tmp111_;
		_tmp110_ = connection_get_mode (self);
		_tmp111_ = _tmp110_;
		if (_tmp111_ != CONN_MODE_NONE) {
			_tmp109_ = !exporting;
		} else {
			_tmp109_ = FALSE;
		}
		if (_tmp109_) {
			gdouble dragx = 0.0;
			gdouble dragy = 0.0;
			Bezier* _tmp112_;
			gdouble _tmp113_ = 0.0;
			gdouble _tmp114_ = 0.0;
			GdkRGBA _tmp115_ = {0};
			gdouble _tmp116_;
			gdouble _tmp117_;
			ConnMode _tmp118_;
			ConnMode _tmp119_;
			_tmp112_ = self->priv->_curve;
			bezier_get_drag_point (_tmp112_, &_tmp113_, &_tmp114_);
			dragx = _tmp113_;
			dragy = _tmp114_;
			cairo_set_line_width (ctx, (gdouble) 1);
			utils_color_from_string ("yellow", &_tmp115_);
			_tmp116_ = connection_get_alpha (self);
			_tmp117_ = _tmp116_;
			utils_set_context_color_with_alpha (ctx, &_tmp115_, _tmp117_);
			cairo_arc (ctx, dragx, dragy, (gdouble) self->priv->RADIUS, (gdouble) 0, 2 * G_PI);
			cairo_fill_preserve (ctx);
			_tmp118_ = connection_get_mode (self);
			_tmp119_ = _tmp118_;
			if (_tmp119_ == CONN_MODE_DROPPABLE) {
				GdkRGBA* _tmp120_;
				GdkRGBA* _tmp121_;
				gdouble _tmp122_;
				gdouble _tmp123_;
				GdkRGBA _tmp124_;
				_tmp120_ = theme_get_color (theme, "attachable");
				_tmp121_ = _tmp120_;
				_tmp122_ = connection_get_alpha (self);
				_tmp123_ = _tmp122_;
				_tmp124_ = *_tmp121_;
				utils_set_context_color_with_alpha (ctx, &_tmp124_, _tmp123_);
				__vala_GdkRGBA_free0 (_tmp121_);
				cairo_set_line_width (ctx, (gdouble) 4);
			} else {
				GdkRGBA _tmp125_;
				GdkRGBA _tmp126_;
				GdkRGBA _tmp127_;
				gdouble _tmp128_;
				gdouble _tmp129_;
				_tmp125_ = ccolor;
				_tmp126_ = ccolor;
				_tmp127_ = ccolor;
				_tmp128_ = connection_get_alpha (self);
				_tmp129_ = _tmp128_;
				cairo_set_source_rgba (ctx, _tmp125_.red, _tmp126_.green, _tmp127_.blue, _tmp129_);
			}
			cairo_stroke (ctx);
		}
	}
	cairo_restore (ctx);
	__vala_GdkRGBA_free0 (_tmp20_);
	__vala_GdkRGBA_free0 (_tmp15_);
}

void
connection_draw (Connection* self,
                 cairo_t* ctx,
                 Theme* theme,
                 gboolean exporting)
{
	ConnectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = CONNECTION_GET_CLASS (self);
	if (_klass_->draw) {
		_klass_->draw (self, ctx, theme, exporting);
	}
}

static void
connection_draw_sticker (Connection* self,
                         cairo_t* ctx,
                         Theme* theme)
{
	GdkPixbuf* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (theme != NULL);
	_tmp0_ = self->priv->_sticker_buf;
	if (_tmp0_ != NULL) {
		gdouble x = 0.0;
		gdouble y = 0.0;
		gdouble w = 0.0;
		gdouble h = 0.0;
		gdouble _tmp1_ = 0.0;
		gdouble _tmp2_ = 0.0;
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
		GdkPixbuf* _tmp5_;
		gdouble _tmp6_;
		gdouble _tmp7_;
		connection_sticker_bbox (self, &_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_);
		x = _tmp1_;
		y = _tmp2_;
		w = _tmp3_;
		h = _tmp4_;
		_tmp5_ = self->priv->_sticker_buf;
		gdk_cairo_set_source_pixbuf (ctx, _tmp5_, x, y);
		_tmp6_ = connection_get_alpha (self);
		_tmp7_ = _tmp6_;
		cairo_paint_with_alpha (ctx, _tmp7_);
	}
}

static void
connection_draw_title (Connection* self,
                       cairo_t* ctx,
                       Theme* theme,
                       gboolean exporting)
{
	GdkRGBA* _tmp0_ = NULL;
	GdkRGBA* _tmp1_;
	GdkRGBA* ccolor = NULL;
	GdkRGBA* _tmp5_;
	GdkRGBA* _tmp6_ = NULL;
	GdkRGBA* _tmp7_;
	GdkRGBA* fg = NULL;
	GdkRGBA* _tmp9_;
	gint* _tmp10_ = NULL;
	Style* _tmp11_;
	gint* _tmp12_;
	gint* _tmp13_;
	gint* _tmp14_;
	gint* padding = NULL;
	gint* _tmp17_;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble w = 0.0;
	gdouble h = 0.0;
	gdouble _tmp18_ = 0.0;
	gdouble _tmp19_ = 0.0;
	gdouble _tmp20_ = 0.0;
	gdouble _tmp21_ = 0.0;
	gint* _tmp22_;
	gint* _tmp23_;
	gint* _tmp24_;
	gint* _tmp25_;
	gdouble _tmp26_ = 0.0;
	gdouble _tmp27_;
	gdouble _tmp29_ = 0.0;
	gdouble _tmp30_;
	gdouble _tmp32_ = 0.0;
	gdouble _tmp33_;
	gdouble _tmp35_ = 0.0;
	gdouble _tmp36_;
	GdkRGBA* _tmp38_;
	GdkRGBA* _tmp39_;
	GdkRGBA* _tmp40_;
	gdouble _tmp41_;
	gdouble _tmp42_;
	gint* _tmp43_;
	gboolean _tmp44_ = FALSE;
	ConnMode _tmp45_;
	ConnMode _tmp46_;
	CanvasText* _tmp53_;
	GdkRGBA* _tmp59_;
	GdkRGBA _tmp60_;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	ConnMode _tmp63_;
	ConnMode _tmp64_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (theme != NULL);
	_tmp1_ = self->priv->_color;
	if (_tmp1_ != NULL) {
		GdkRGBA* _tmp2_;
		GdkRGBA* _tmp3_;
		_tmp2_ = self->priv->_color;
		_tmp3_ = __vala_GdkRGBA_copy0 (_tmp2_);
		__vala_GdkRGBA_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		GdkRGBA* _tmp4_;
		_tmp4_ = theme_get_color (theme, "connection_background");
		__vala_GdkRGBA_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = __vala_GdkRGBA_copy0 (_tmp0_);
	ccolor = _tmp5_;
	_tmp7_ = theme_get_color (theme, "connection_foreground");
	_tmp6_ = _tmp7_;
	if (_tmp6_ == NULL) {
		GdkRGBA* _tmp8_;
		_tmp8_ = theme_get_color (theme, "background");
		__vala_GdkRGBA_free0 (_tmp6_);
		_tmp6_ = _tmp8_;
	}
	_tmp9_ = _tmp6_;
	_tmp6_ = NULL;
	fg = _tmp9_;
	_tmp11_ = self->priv->_style;
	_tmp12_ = style_get_connection_padding (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = __int_dup0 (_tmp13_);
	_tmp10_ = _tmp14_;
	if (_tmp10_ == NULL) {
		gint _tmp15_;
		gint* _tmp16_;
		_tmp15_ = 0;
		_tmp16_ = __int_dup0 (&_tmp15_);
		_g_free0 (_tmp10_);
		_tmp10_ = _tmp16_;
	}
	_tmp17_ = _tmp10_;
	_tmp10_ = NULL;
	padding = _tmp17_;
	connection_title_bbox (self, &_tmp18_, &_tmp19_, &_tmp20_, &_tmp21_);
	x = _tmp18_;
	y = _tmp19_;
	w = _tmp20_;
	h = _tmp21_;
	_tmp22_ = padding;
	x -= *_tmp22_;
	_tmp23_ = padding;
	y -= *_tmp23_;
	_tmp24_ = padding;
	w += (gdouble) ((*_tmp24_) * 2);
	_tmp25_ = padding;
	h += (gdouble) ((*_tmp25_) * 2);
	_tmp27_ = self->priv->_extent_x1;
	if (x < _tmp27_) {
		_tmp26_ = x;
	} else {
		gdouble _tmp28_;
		_tmp28_ = self->priv->_extent_x1;
		_tmp26_ = _tmp28_;
	}
	connection_set_extent_x1 (self, _tmp26_);
	_tmp30_ = self->priv->_extent_y1;
	if (y < _tmp30_) {
		_tmp29_ = y;
	} else {
		gdouble _tmp31_;
		_tmp31_ = self->priv->_extent_y1;
		_tmp29_ = _tmp31_;
	}
	connection_set_extent_y1 (self, _tmp29_);
	_tmp33_ = self->priv->_extent_x2;
	if ((x + w) > _tmp33_) {
		_tmp32_ = x + w;
	} else {
		gdouble _tmp34_;
		_tmp34_ = self->priv->_extent_x2;
		_tmp32_ = _tmp34_;
	}
	connection_set_extent_x2 (self, _tmp32_);
	_tmp36_ = self->priv->_extent_y2;
	if ((y + h) > _tmp36_) {
		_tmp35_ = y + h;
	} else {
		gdouble _tmp37_;
		_tmp37_ = self->priv->_extent_y2;
		_tmp35_ = _tmp37_;
	}
	connection_set_extent_y2 (self, _tmp35_);
	_tmp38_ = ccolor;
	_tmp39_ = ccolor;
	_tmp40_ = ccolor;
	_tmp41_ = connection_get_alpha (self);
	_tmp42_ = _tmp41_;
	cairo_set_source_rgba (ctx, (*_tmp38_).red, (*_tmp39_).green, (*_tmp40_).blue, _tmp42_);
	_tmp43_ = padding;
	granite_drawing_utilities_cairo_rounded_rectangle (ctx, x, y, w, h, (gdouble) ((*_tmp43_) * 2));
	cairo_fill (ctx);
	_tmp45_ = connection_get_mode (self);
	_tmp46_ = _tmp45_;
	if (_tmp46_ == CONN_MODE_DROPPABLE) {
		_tmp44_ = !exporting;
	} else {
		_tmp44_ = FALSE;
	}
	if (_tmp44_) {
		GdkRGBA* _tmp47_;
		GdkRGBA* _tmp48_;
		gdouble _tmp49_;
		gdouble _tmp50_;
		GdkRGBA _tmp51_;
		gint* _tmp52_;
		_tmp47_ = theme_get_color (theme, "attachable");
		_tmp48_ = _tmp47_;
		_tmp49_ = connection_get_alpha (self);
		_tmp50_ = _tmp49_;
		_tmp51_ = *_tmp48_;
		utils_set_context_color_with_alpha (ctx, &_tmp51_, _tmp50_);
		__vala_GdkRGBA_free0 (_tmp48_);
		cairo_set_line_width (ctx, (gdouble) 4);
		_tmp52_ = padding;
		granite_drawing_utilities_cairo_rounded_rectangle (ctx, x, y, w, h, (gdouble) ((*_tmp52_) * 2));
		cairo_stroke (ctx);
	}
	connection_draw_sticker (self, ctx, theme);
	_tmp53_ = self->priv->_title;
	if (_tmp53_ != NULL) {
		CanvasText* _tmp54_;
		GdkRGBA* _tmp55_;
		gdouble _tmp56_;
		gdouble _tmp57_;
		GdkRGBA _tmp58_;
		_tmp54_ = self->priv->_title;
		_tmp55_ = fg;
		_tmp56_ = connection_get_alpha (self);
		_tmp57_ = _tmp56_;
		_tmp58_ = *_tmp55_;
		canvas_text_draw (_tmp54_, ctx, theme, &_tmp58_, _tmp57_, exporting);
	}
	_tmp59_ = fg;
	_tmp60_ = *_tmp59_;
	connection_draw_note (self, ctx, &_tmp60_);
	_tmp63_ = connection_get_mode (self);
	_tmp64_ = _tmp63_;
	if (_tmp64_ == CONN_MODE_SELECTED) {
		_tmp62_ = TRUE;
	} else {
		ConnMode _tmp65_;
		ConnMode _tmp66_;
		_tmp65_ = connection_get_mode (self);
		_tmp66_ = _tmp65_;
		_tmp62_ = _tmp66_ == CONN_MODE_ADJUSTING;
	}
	if (_tmp62_) {
		_tmp61_ = !exporting;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		gdouble dragx = 0.0;
		gdouble dragy = 0.0;
		Bezier* _tmp67_;
		gdouble _tmp68_ = 0.0;
		gdouble _tmp69_ = 0.0;
		GdkRGBA _tmp70_ = {0};
		gdouble _tmp71_;
		gdouble _tmp72_;
		gint* _tmp73_;
		GdkRGBA* _tmp74_;
		GdkRGBA* _tmp75_;
		GdkRGBA* _tmp76_;
		gdouble _tmp77_;
		gdouble _tmp78_;
		_tmp67_ = self->priv->_curve;
		bezier_get_drag_point (_tmp67_, &_tmp68_, &_tmp69_);
		dragx = _tmp68_;
		dragy = _tmp69_;
		utils_color_from_string ("yellow", &_tmp70_);
		_tmp71_ = connection_get_alpha (self);
		_tmp72_ = _tmp71_;
		utils_set_context_color_with_alpha (ctx, &_tmp70_, _tmp72_);
		cairo_set_line_width (ctx, (gdouble) 1);
		_tmp73_ = padding;
		cairo_arc (ctx, dragx, (dragy + (h / 2)) + (*_tmp73_), (gdouble) self->priv->RADIUS, (gdouble) 0, 2 * G_PI);
		cairo_fill_preserve (ctx);
		_tmp74_ = ccolor;
		_tmp75_ = ccolor;
		_tmp76_ = ccolor;
		_tmp77_ = connection_get_alpha (self);
		_tmp78_ = _tmp77_;
		cairo_set_source_rgba (ctx, (*_tmp74_).red, (*_tmp75_).green, (*_tmp76_).blue, _tmp78_);
		cairo_stroke (ctx);
	}
	_g_free0 (padding);
	_g_free0 (_tmp10_);
	__vala_GdkRGBA_free0 (fg);
	__vala_GdkRGBA_free0 (_tmp6_);
	__vala_GdkRGBA_free0 (ccolor);
	__vala_GdkRGBA_free0 (_tmp0_);
}

static void
connection_draw_note (Connection* self,
                      cairo_t* ctx,
                      GdkRGBA* color)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (color != NULL);
	_tmp0_ = connection_get_note (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		gdouble x = 0.0;
		gdouble y = 0.0;
		gdouble w = 0.0;
		gdouble h = 0.0;
		gdouble _tmp4_ = 0.0;
		gdouble _tmp5_ = 0.0;
		gdouble _tmp6_ = 0.0;
		gdouble _tmp7_ = 0.0;
		GdkRGBA _tmp8_;
		gdouble _tmp9_;
		gdouble _tmp10_;
		connection_note_bbox (self, &_tmp4_, &_tmp5_, &_tmp6_, &_tmp7_);
		x = _tmp4_;
		y = _tmp5_;
		w = _tmp6_;
		h = _tmp7_;
		_tmp8_ = *color;
		_tmp9_ = connection_get_alpha (self);
		_tmp10_ = _tmp9_;
		utils_set_context_color_with_alpha (ctx, &_tmp8_, _tmp10_);
		cairo_new_path (ctx);
		cairo_set_line_width (ctx, (gdouble) 1);
		cairo_move_to (ctx, x + 2, y);
		cairo_line_to (ctx, x + 10, y);
		cairo_stroke (ctx);
		cairo_move_to (ctx, x, y + 3);
		cairo_line_to (ctx, x + 10, y + 3);
		cairo_stroke (ctx);
		cairo_move_to (ctx, x, y + 6);
		cairo_line_to (ctx, x + 10, y + 6);
		cairo_stroke (ctx);
		cairo_move_to (ctx, x, y + 9);
		cairo_line_to (ctx, x + 10, y + 9);
		cairo_stroke (ctx);
	}
}

void
connection_draw_arrow (cairo_t* ctx,
                       gint line_width,
                       gdouble tipx,
                       gdouble tipy,
                       gdouble tailx,
                       gdouble taily,
                       gdouble arrowLength)
{
	gdouble extlen[8] = {0};
	gdouble _tmp0_[8] = {0};
	gdouble dx = 0.0;
	gdouble dy = 0.0;
	gdouble theta = 0.0;
	gdouble rad = 0.0;
	gdouble x1 = 0.0;
	gdouble y1 = 0.0;
	gdouble phi2 = 0.0;
	gdouble x2 = 0.0;
	gdouble y2 = 0.0;
	g_return_if_fail (ctx != NULL);
	_tmp0_[0] = (gdouble) 12;
	_tmp0_[1] = (gdouble) 13;
	_tmp0_[2] = (gdouble) 14;
	_tmp0_[3] = (gdouble) 15;
	_tmp0_[4] = (gdouble) 16;
	_tmp0_[5] = (gdouble) 17;
	_tmp0_[6] = (gdouble) 18;
	_tmp0_[7] = (gdouble) 18;
	memcpy (extlen, _tmp0_, 8 * sizeof (gdouble));
	if (arrowLength == ((gdouble) 0)) {
		gdouble _tmp1_;
		_tmp1_ = extlen[line_width - 1];
		arrowLength = _tmp1_;
	}
	dx = tipx - tailx;
	dy = tipy - taily;
	theta = atan2 (dy, dx);
	rad = 35 * (G_PI / 180);
	x1 = tipx - (arrowLength * cos (theta + rad));
	y1 = tipy - (arrowLength * sin (theta + rad));
	phi2 = -35 * (G_PI / 180);
	x2 = tipx - (arrowLength * cos (theta + phi2));
	y2 = tipy - (arrowLength * sin (theta + phi2));
	cairo_set_line_width (ctx, (gdouble) 1);
	cairo_move_to (ctx, tipx, tipy);
	cairo_line_to (ctx, x1, y1);
	cairo_line_to (ctx, x2, y2);
	cairo_close_path (ctx);
	cairo_fill (ctx);
}

cairo_surface_t*
connection_make_arrow_icon (const gchar* type)
{
	cairo_surface_t* surface = NULL;
	cairo_surface_t* _tmp0_;
	cairo_t* ctx = NULL;
	cairo_surface_t* _tmp1_;
	cairo_t* _tmp2_;
	cairo_t* _tmp3_;
	cairo_t* _tmp4_;
	cairo_t* _tmp5_;
	cairo_t* _tmp6_;
	cairo_t* _tmp7_;
	cairo_t* _tmp8_;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp11_ = FALSE;
	cairo_surface_t* result;
	g_return_val_if_fail (type != NULL, NULL);
	_tmp0_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, 100, 20);
	surface = _tmp0_;
	_tmp1_ = surface;
	_tmp2_ = cairo_create (_tmp1_);
	ctx = _tmp2_;
	_tmp3_ = ctx;
	cairo_set_source_rgba (_tmp3_, 0.5, 0.5, 0.5, (gdouble) 1);
	_tmp4_ = ctx;
	cairo_set_line_width (_tmp4_, (gdouble) 4);
	_tmp5_ = ctx;
	cairo_set_line_cap (_tmp5_, CAIRO_LINE_CAP_ROUND);
	_tmp6_ = ctx;
	cairo_move_to (_tmp6_, (gdouble) 15, (gdouble) 10);
	_tmp7_ = ctx;
	cairo_line_to (_tmp7_, (gdouble) 85, (gdouble) 10);
	_tmp8_ = ctx;
	cairo_stroke (_tmp8_);
	if (g_strcmp0 (type, "fromto") == 0) {
		_tmp9_ = TRUE;
	} else {
		_tmp9_ = g_strcmp0 (type, "both") == 0;
	}
	if (_tmp9_) {
		cairo_t* _tmp10_;
		_tmp10_ = ctx;
		connection_draw_arrow (_tmp10_, 4, (gdouble) 90, (gdouble) 10, (gdouble) 10, (gdouble) 10, (gdouble) 0);
	}
	if (g_strcmp0 (type, "tofrom") == 0) {
		_tmp11_ = TRUE;
	} else {
		_tmp11_ = g_strcmp0 (type, "both") == 0;
	}
	if (_tmp11_) {
		cairo_t* _tmp12_;
		_tmp12_ = ctx;
		connection_draw_arrow (_tmp12_, 4, (gdouble) 10, (gdouble) 10, (gdouble) 90, (gdouble) 10, (gdouble) 0);
	}
	result = surface;
	_cairo_destroy0 (ctx);
	return result;
}

CanvasText*
connection_get_title (Connection* self)
{
	CanvasText* result;
	CanvasText* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}

const gchar*
connection_get_note (Connection* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_note;
	result = _tmp0_;
	return result;
}

void
connection_set_note (Connection* self,
                     const gchar* value)
{
	gboolean was_empty = FALSE;
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_note;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	was_empty = _tmp2_ == 0;
	_tmp3_ = g_strdup (value);
	_g_free0 (self->priv->_note);
	self->priv->_note = _tmp3_;
	_tmp4_ = self->priv->_note;
	_tmp5_ = strlen (_tmp4_);
	_tmp6_ = _tmp5_;
	if (was_empty != (_tmp6_ == 0)) {
		connection_position_title (self);
	}
	g_object_notify_by_pspec ((GObject *) self, connection_properties[CONNECTION_NOTE_PROPERTY]);
}

ConnMode
connection_get_mode (Connection* self)
{
	ConnMode result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_mode;
	return result;
}

void
connection_set_mode (Connection* self,
                     ConnMode value)
{
	g_return_if_fail (self != NULL);
	if (self->priv->_mode != value) {
		self->priv->_mode = value;
		if (self->priv->_mode == CONN_MODE_EDITABLE) {
			CanvasText* _tmp0_;
			_tmp0_ = self->priv->_title;
			if (_tmp0_ != NULL) {
				CanvasText* _tmp1_;
				CanvasText* _tmp2_;
				_tmp1_ = self->priv->_title;
				canvas_text_set_edit (_tmp1_, TRUE);
				_tmp2_ = self->priv->_title;
				canvas_text_set_cursor_all (_tmp2_, FALSE);
			}
		} else {
			CanvasText* _tmp3_;
			_tmp3_ = self->priv->_title;
			if (_tmp3_ != NULL) {
				CanvasText* _tmp4_;
				CanvasText* _tmp5_;
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				CanvasText* _tmp8_;
				FormattedText* _tmp9_;
				FormattedText* _tmp10_;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				_tmp4_ = self->priv->_title;
				canvas_text_set_edit (_tmp4_, FALSE);
				_tmp5_ = self->priv->_title;
				canvas_text_clear_selection (_tmp5_, NULL);
				_tmp8_ = self->priv->_title;
				_tmp9_ = canvas_text_get_text (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = formatted_text_get_text (_tmp10_);
				_tmp12_ = _tmp11_;
				if (g_strcmp0 (_tmp12_, "") == 0) {
					const gchar* _tmp13_;
					_tmp13_ = self->priv->_sticker;
					_tmp7_ = _tmp13_ == NULL;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					const gchar* _tmp14_;
					_tmp14_ = self->priv->_note;
					_tmp6_ = g_strcmp0 (_tmp14_, "") == 0;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					_g_object_unref0 (self->priv->_title);
					self->priv->_title = NULL;
				}
			}
		}
	}
	g_object_notify_by_pspec ((GObject *) self, connection_properties[CONNECTION_MODE_PROPERTY]);
}

Node*
connection_get_from_node (Connection* self)
{
	Node* result;
	Node* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_from_node;
	result = _tmp0_;
	return result;
}

void
connection_set_from_node (Connection* self,
                          Node* value)
{
	Node* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_from_node);
	self->priv->_from_node = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, connection_properties[CONNECTION_FROM_NODE_PROPERTY]);
}

Node*
connection_get_to_node (Connection* self)
{
	Node* result;
	Node* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_to_node;
	result = _tmp0_;
	return result;
}

void
connection_set_to_node (Connection* self,
                        Node* value)
{
	Node* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_to_node);
	self->priv->_to_node = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, connection_properties[CONNECTION_TO_NODE_PROPERTY]);
}

Style*
connection_get_style (Connection* self)
{
	Style* result;
	Style* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_style;
	result = _tmp0_;
	return result;
}

void
connection_set_style (Connection* self,
                      Style* value)
{
	gboolean _tmp0_ = FALSE;
	Style* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_style;
	if (style_copy (_tmp1_, value)) {
		CanvasText* _tmp2_;
		_tmp2_ = self->priv->_title;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		CanvasText* _tmp3_;
		Style* _tmp4_;
		PangoFontDescription* _tmp5_;
		PangoFontDescription* _tmp6_;
		const gchar* _tmp7_;
		Style* _tmp8_;
		PangoFontDescription* _tmp9_;
		PangoFontDescription* _tmp10_;
		gint _tmp11_;
		CanvasText* _tmp12_;
		Style* _tmp13_;
		gint* _tmp14_;
		gint* _tmp15_;
		_tmp3_ = self->priv->_title;
		_tmp4_ = self->priv->_style;
		_tmp5_ = style_get_connection_font (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = pango_font_description_get_family (_tmp6_);
		_tmp8_ = self->priv->_style;
		_tmp9_ = style_get_connection_font (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = pango_font_description_get_size (_tmp10_) / PANGO_SCALE;
		canvas_text_set_font (_tmp3_, _tmp7_, &_tmp11_, 1.0);
		_tmp12_ = self->priv->_title;
		_tmp13_ = self->priv->_style;
		_tmp14_ = style_get_connection_title_width (_tmp13_);
		_tmp15_ = _tmp14_;
		canvas_text_set_max_width (_tmp12_, *_tmp15_);
		connection_position_title (self);
	}
	g_object_notify_by_pspec ((GObject *) self, connection_properties[CONNECTION_STYLE_PROPERTY]);
}

gdouble
connection_get_alpha (Connection* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_alpha;
	return result;
}

void
connection_set_alpha (Connection* self,
                      gdouble value)
{
	g_return_if_fail (self != NULL);
	if (self->priv->_alpha != value) {
		Node* _tmp0_;
		Node* _tmp2_;
		self->priv->_alpha = value;
		_tmp0_ = self->priv->_from_node;
		if (_tmp0_ != NULL) {
			Node* _tmp1_;
			_tmp1_ = self->priv->_from_node;
			node_set_alpha_only (_tmp1_, value);
		}
		_tmp2_ = self->priv->_to_node;
		if (_tmp2_ != NULL) {
			Node* _tmp3_;
			_tmp3_ = self->priv->_to_node;
			node_set_alpha_only (_tmp3_, value);
		}
	}
	g_object_notify_by_pspec ((GObject *) self, connection_properties[CONNECTION_ALPHA_PROPERTY]);
}

GdkRGBA*
connection_get_color (Connection* self)
{
	GdkRGBA* result;
	GdkRGBA* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_color;
	result = _tmp0_;
	return result;
}

void
connection_set_color (Connection* self,
                      GdkRGBA* value)
{
	GdkRGBA* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __vala_GdkRGBA_copy0 (value);
	__vala_GdkRGBA_free0 (self->priv->_color);
	self->priv->_color = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, connection_properties[CONNECTION_COLOR_PROPERTY]);
}

const gchar*
connection_get_sticker (Connection* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sticker;
	result = _tmp0_;
	return result;
}

void
connection_set_sticker (Connection* self,
                        const gchar* value)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_sticker;
	if (g_strcmp0 (_tmp0_, value) != 0) {
		gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = g_strdup (value);
		_g_free0 (self->priv->_sticker);
		self->priv->_sticker = _tmp1_;
		_tmp2_ = self->priv->_sticker;
		if (_tmp2_ != NULL) {
			const gchar* _tmp3_;
			GdkPixbuf* _tmp4_;
			_tmp3_ = self->priv->_sticker;
			_tmp4_ = sticker_set_make_pixbuf (_tmp3_, -1);
			_g_object_unref0 (self->priv->_sticker_buf);
			self->priv->_sticker_buf = _tmp4_;
		} else {
			_g_object_unref0 (self->priv->_sticker_buf);
			self->priv->_sticker_buf = NULL;
		}
		connection_position_title (self);
	}
	g_object_notify_by_pspec ((GObject *) self, connection_properties[CONNECTION_STICKER_PROPERTY]);
}

gdouble
connection_get_extent_x1 (Connection* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_extent_x1;
	return result;
}

static void
connection_set_extent_x1 (Connection* self,
                          gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = connection_get_extent_x1 (self);
	if (old_value != value) {
		self->priv->_extent_x1 = value;
		g_object_notify_by_pspec ((GObject *) self, connection_properties[CONNECTION_EXTENT_X1_PROPERTY]);
	}
}

gdouble
connection_get_extent_y1 (Connection* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_extent_y1;
	return result;
}

static void
connection_set_extent_y1 (Connection* self,
                          gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = connection_get_extent_y1 (self);
	if (old_value != value) {
		self->priv->_extent_y1 = value;
		g_object_notify_by_pspec ((GObject *) self, connection_properties[CONNECTION_EXTENT_Y1_PROPERTY]);
	}
}

gdouble
connection_get_extent_x2 (Connection* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_extent_x2;
	return result;
}

static void
connection_set_extent_x2 (Connection* self,
                          gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = connection_get_extent_x2 (self);
	if (old_value != value) {
		self->priv->_extent_x2 = value;
		g_object_notify_by_pspec ((GObject *) self, connection_properties[CONNECTION_EXTENT_X2_PROPERTY]);
	}
}

gdouble
connection_get_extent_y2 (Connection* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_extent_y2;
	return result;
}

static void
connection_set_extent_y2 (Connection* self,
                          gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = connection_get_extent_y2 (self);
	if (old_value != value) {
		self->priv->_extent_y2 = value;
		g_object_notify_by_pspec ((GObject *) self, connection_properties[CONNECTION_EXTENT_Y2_PROPERTY]);
	}
}

static void
connection_class_init (ConnectionClass * klass,
                       gpointer klass_data)
{
	connection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Connection_private_offset);
	((ConnectionClass *) klass)->draw = (void (*) (Connection*, cairo_t*, Theme*, gboolean)) connection_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_connection_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_connection_set_property;
	G_OBJECT_CLASS (klass)->finalize = connection_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTION_TITLE_PROPERTY, connection_properties[CONNECTION_TITLE_PROPERTY] = g_param_spec_object ("title", "title", "title", TYPE_CANVAS_TEXT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTION_NOTE_PROPERTY, connection_properties[CONNECTION_NOTE_PROPERTY] = g_param_spec_string ("note", "note", "note", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTION_MODE_PROPERTY, connection_properties[CONNECTION_MODE_PROPERTY] = g_param_spec_enum ("mode", "mode", "mode", TYPE_CONN_MODE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTION_FROM_NODE_PROPERTY, connection_properties[CONNECTION_FROM_NODE_PROPERTY] = g_param_spec_object ("from-node", "from-node", "from-node", TYPE_NODE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTION_TO_NODE_PROPERTY, connection_properties[CONNECTION_TO_NODE_PROPERTY] = g_param_spec_object ("to-node", "to-node", "to-node", TYPE_NODE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTION_STYLE_PROPERTY, connection_properties[CONNECTION_STYLE_PROPERTY] = param_spec_style ("style", "style", "style", TYPE_STYLE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTION_ALPHA_PROPERTY, connection_properties[CONNECTION_ALPHA_PROPERTY] = g_param_spec_double ("alpha", "alpha", "alpha", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTION_COLOR_PROPERTY, connection_properties[CONNECTION_COLOR_PROPERTY] = g_param_spec_boxed ("color", "color", "color", gdk_rgba_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTION_STICKER_PROPERTY, connection_properties[CONNECTION_STICKER_PROPERTY] = g_param_spec_string ("sticker", "sticker", "sticker", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTION_EXTENT_X1_PROPERTY, connection_properties[CONNECTION_EXTENT_X1_PROPERTY] = g_param_spec_double ("extent-x1", "extent-x1", "extent-x1", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTION_EXTENT_Y1_PROPERTY, connection_properties[CONNECTION_EXTENT_Y1_PROPERTY] = g_param_spec_double ("extent-y1", "extent-y1", "extent-y1", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTION_EXTENT_X2_PROPERTY, connection_properties[CONNECTION_EXTENT_X2_PROPERTY] = g_param_spec_double ("extent-x2", "extent-x2", "extent-x2", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTION_EXTENT_Y2_PROPERTY, connection_properties[CONNECTION_EXTENT_Y2_PROPERTY] = g_param_spec_double ("extent-y2", "extent-y2", "extent-y2", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
connection_instance_init (Connection * self,
                          gpointer klass)
{
	Style* _tmp0_;
	gchar* _tmp1_;
	self->priv = connection_get_instance_private (self);
	self->priv->RADIUS = 6;
	self->priv->_mode = CONN_MODE_NONE;
	self->priv->_from_node = NULL;
	self->priv->_to_node = NULL;
	_tmp0_ = style_new ();
	self->priv->_style = _tmp0_;
	self->priv->_title = NULL;
	_tmp1_ = g_strdup ("");
	self->priv->_note = _tmp1_;
	self->priv->_max_width = (gdouble) 100;
	self->priv->_sticker = NULL;
	self->priv->_sticker_buf = NULL;
	self->priv->_alpha = 1.0;
	self->priv->_extent_x1 = 0.0;
	self->priv->_extent_y1 = 0.0;
	self->priv->_extent_x2 = 0.0;
	self->priv->_extent_y2 = 0.0;
}

static void
connection_finalize (GObject * obj)
{
	Connection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CONNECTION, Connection);
	_g_object_unref0 (self->priv->_da);
	_g_object_unref0 (self->priv->_from_node);
	_g_object_unref0 (self->priv->_to_node);
	_style_unref0 (self->priv->_style);
	_bezier_unref0 (self->priv->_curve);
	_g_object_unref0 (self->priv->_title);
	_g_free0 (self->priv->_note);
	__vala_GdkRGBA_free0 (self->priv->_color);
	_g_free0 (self->priv->_sticker);
	_g_object_unref0 (self->priv->_sticker_buf);
	G_OBJECT_CLASS (connection_parent_class)->finalize (obj);
}

static GType
connection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ConnectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) connection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Connection), 0, (GInstanceInitFunc) connection_instance_init, NULL };
	GType connection_type_id;
	connection_type_id = g_type_register_static (G_TYPE_OBJECT, "Connection", &g_define_type_info, 0);
	Connection_private_offset = g_type_add_instance_private (connection_type_id, sizeof (ConnectionPrivate));
	return connection_type_id;
}

GType
connection_get_type (void)
{
	static volatile gsize connection_type_id__once = 0;
	if (g_once_init_enter (&connection_type_id__once)) {
		GType connection_type_id;
		connection_type_id = connection_get_type_once ();
		g_once_init_leave (&connection_type_id__once, connection_type_id);
	}
	return connection_type_id__once;
}

static void
_vala_connection_get_property (GObject * object,
                               guint property_id,
                               GValue * value,
                               GParamSpec * pspec)
{
	Connection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CONNECTION, Connection);
	switch (property_id) {
		case CONNECTION_TITLE_PROPERTY:
		g_value_set_object (value, connection_get_title (self));
		break;
		case CONNECTION_NOTE_PROPERTY:
		g_value_set_string (value, connection_get_note (self));
		break;
		case CONNECTION_MODE_PROPERTY:
		g_value_set_enum (value, connection_get_mode (self));
		break;
		case CONNECTION_FROM_NODE_PROPERTY:
		g_value_set_object (value, connection_get_from_node (self));
		break;
		case CONNECTION_TO_NODE_PROPERTY:
		g_value_set_object (value, connection_get_to_node (self));
		break;
		case CONNECTION_STYLE_PROPERTY:
		value_set_style (value, connection_get_style (self));
		break;
		case CONNECTION_ALPHA_PROPERTY:
		g_value_set_double (value, connection_get_alpha (self));
		break;
		case CONNECTION_COLOR_PROPERTY:
		{
			GdkRGBA* boxed;
			boxed = connection_get_color (self);
			g_value_set_boxed (value, boxed);
		}
		break;
		case CONNECTION_STICKER_PROPERTY:
		g_value_set_string (value, connection_get_sticker (self));
		break;
		case CONNECTION_EXTENT_X1_PROPERTY:
		g_value_set_double (value, connection_get_extent_x1 (self));
		break;
		case CONNECTION_EXTENT_Y1_PROPERTY:
		g_value_set_double (value, connection_get_extent_y1 (self));
		break;
		case CONNECTION_EXTENT_X2_PROPERTY:
		g_value_set_double (value, connection_get_extent_x2 (self));
		break;
		case CONNECTION_EXTENT_Y2_PROPERTY:
		g_value_set_double (value, connection_get_extent_y2 (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_connection_set_property (GObject * object,
                               guint property_id,
                               const GValue * value,
                               GParamSpec * pspec)
{
	Connection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CONNECTION, Connection);
	switch (property_id) {
		case CONNECTION_NOTE_PROPERTY:
		connection_set_note (self, g_value_get_string (value));
		break;
		case CONNECTION_MODE_PROPERTY:
		connection_set_mode (self, g_value_get_enum (value));
		break;
		case CONNECTION_FROM_NODE_PROPERTY:
		connection_set_from_node (self, g_value_get_object (value));
		break;
		case CONNECTION_TO_NODE_PROPERTY:
		connection_set_to_node (self, g_value_get_object (value));
		break;
		case CONNECTION_STYLE_PROPERTY:
		connection_set_style (self, value_get_style (value));
		break;
		case CONNECTION_ALPHA_PROPERTY:
		connection_set_alpha (self, g_value_get_double (value));
		break;
		case CONNECTION_COLOR_PROPERTY:
		connection_set_color (self, g_value_get_boxed (value));
		break;
		case CONNECTION_STICKER_PROPERTY:
		connection_set_sticker (self, g_value_get_string (value));
		break;
		case CONNECTION_EXTENT_X1_PROPERTY:
		connection_set_extent_x1 (self, g_value_get_double (value));
		break;
		case CONNECTION_EXTENT_Y1_PROPERTY:
		connection_set_extent_y1 (self, g_value_get_double (value));
		break;
		case CONNECTION_EXTENT_X2_PROPERTY:
		connection_set_extent_x2 (self, g_value_get_double (value));
		break;
		case CONNECTION_EXTENT_Y2_PROPERTY:
		connection_set_extent_y2 (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

