/* HtmlToMarkdown.c generated by valac 0.56.18, the Vala compiler
 * generated from HtmlToMarkdown.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_HTML_TO_MARKDOWN (html_to_markdown_get_type ())
#define HTML_TO_MARKDOWN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HTML_TO_MARKDOWN, HtmlToMarkdown))
#define HTML_TO_MARKDOWN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HTML_TO_MARKDOWN, HtmlToMarkdownClass))
#define IS_HTML_TO_MARKDOWN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HTML_TO_MARKDOWN))
#define IS_HTML_TO_MARKDOWN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HTML_TO_MARKDOWN))
#define HTML_TO_MARKDOWN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HTML_TO_MARKDOWN, HtmlToMarkdownClass))

typedef struct _HtmlToMarkdown HtmlToMarkdown;
typedef struct _HtmlToMarkdownClass HtmlToMarkdownClass;
typedef struct _HtmlToMarkdownPrivate HtmlToMarkdownPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _xmlFreeDoc0(var) ((var == NULL) ? NULL : (var = (xmlFreeDoc (var), NULL)))
typedef struct _ParamSpecHtmlToMarkdown ParamSpecHtmlToMarkdown;

struct _HtmlToMarkdown {
	GTypeInstance parent_instance;
	volatile int ref_count;
	HtmlToMarkdownPrivate * priv;
};

struct _HtmlToMarkdownClass {
	GTypeClass parent_class;
	void (*finalize) (HtmlToMarkdown *self);
};

struct _ParamSpecHtmlToMarkdown {
	GParamSpec parent_instance;
};

static gpointer html_to_markdown_parent_class = NULL;
VALA_EXTERN gint html_to_markdown_list_depth;
gint html_to_markdown_list_depth = -1;
VALA_EXTERN gboolean html_to_markdown_extensions;
gboolean html_to_markdown_extensions = TRUE;

VALA_EXTERN gpointer html_to_markdown_ref (gpointer instance);
VALA_EXTERN void html_to_markdown_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_html_to_markdown (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void value_set_html_to_markdown (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void value_take_html_to_markdown (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer value_get_html_to_markdown (const GValue* value);
VALA_EXTERN GType html_to_markdown_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (HtmlToMarkdown, html_to_markdown_unref)
VALA_EXTERN void html_to_markdown_reset (gboolean ext);
VALA_EXTERN gchar* html_to_markdown_parse_file (const gchar* fname);
VALA_EXTERN gchar* html_to_markdown_parse_xml (xmlNode* n);
VALA_EXTERN gchar* html_to_markdown_parse_item (xmlNode* n);
VALA_EXTERN gchar* html_to_markdown_parse_list (xmlNode* n,
                                    gboolean unordered,
                                    gint depth);
VALA_EXTERN gchar* html_to_markdown_parse_link (xmlNode* n);
VALA_EXTERN gchar* html_to_markdown_parse_image (xmlNode* n);
VALA_EXTERN gchar* html_to_markdown_parse_table (xmlNode* n);
VALA_EXTERN gchar* html_to_markdown_parse_node (xmlNode* n);
VALA_EXTERN gchar* html_to_markdown_parse_table_row (xmlNode* n,
                                         gint* cols);
VALA_EXTERN HtmlToMarkdown* html_to_markdown_new (void);
VALA_EXTERN HtmlToMarkdown* html_to_markdown_construct (GType object_type);
static void html_to_markdown_finalize (HtmlToMarkdown * obj);
static GType html_to_markdown_get_type_once (void);

void
html_to_markdown_reset (gboolean ext)
{
	html_to_markdown_list_depth = -1;
	html_to_markdown_extensions = ext;
}

gchar*
html_to_markdown_parse_file (const gchar* fname)
{
	xmlDoc* doc = NULL;
	xmlDoc* _tmp0_;
	gchar* text = NULL;
	gchar* _tmp1_;
	xmlDoc* _tmp2_;
	gchar* result;
	g_return_val_if_fail (fname != NULL, NULL);
	_tmp0_ = xmlReadFile (fname, NULL, (gint) XML_PARSE_HUGE);
	doc = _tmp0_;
	_tmp1_ = g_strdup ("");
	text = _tmp1_;
	_tmp2_ = doc;
	if (_tmp2_ != NULL) {
		xmlDoc* _tmp3_;
		xmlNode* _tmp4_;
		gchar* _tmp5_;
		xmlDoc* _tmp6_;
		_tmp3_ = doc;
		_tmp4_ = xmlDocGetRootElement (_tmp3_);
		_tmp5_ = html_to_markdown_parse_xml (_tmp4_);
		_g_free0 (text);
		text = _tmp5_;
		_tmp6_ = doc;
		_xmlFreeDoc0 (_tmp6_);
	}
	result = text;
	return result;
}

gchar*
html_to_markdown_parse_xml (xmlNode* n)
{
	gchar* _tmp13_;
	gchar* result;
	{
		xmlNode* it = NULL;
		xmlNode* _tmp0_;
		_tmp0_ = n->children;
		it = _tmp0_;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				xmlNode* _tmp4_;
				gboolean _tmp5_ = FALSE;
				xmlNode* _tmp6_;
				if (!_tmp1_) {
					xmlNode* _tmp2_;
					xmlNode* _tmp3_;
					_tmp2_ = it;
					_tmp3_ = _tmp2_->next;
					it = _tmp3_;
				}
				_tmp1_ = FALSE;
				_tmp4_ = it;
				if (!(_tmp4_ != NULL)) {
					break;
				}
				_tmp6_ = it;
				if (_tmp6_->type == XML_ELEMENT_NODE) {
					xmlNode* _tmp7_;
					const gchar* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					_tmp7_ = it;
					_tmp8_ = _tmp7_->name;
					_tmp9_ = g_utf8_strdown (_tmp8_, (gssize) -1);
					_tmp10_ = _tmp9_;
					_tmp5_ = g_strcmp0 (_tmp10_, "body") == 0;
					_g_free0 (_tmp10_);
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					xmlNode* _tmp11_;
					gchar* _tmp12_;
					_tmp11_ = it;
					_tmp12_ = html_to_markdown_parse_item (_tmp11_);
					result = _tmp12_;
					return result;
				}
			}
		}
	}
	_tmp13_ = g_strdup ("");
	result = _tmp13_;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

gchar*
html_to_markdown_parse_item (xmlNode* n)
{
	gchar* text = NULL;
	gchar* _tmp0_;
	const gchar* _tmp190_;
	gchar* _tmp191_;
	gchar* result;
	_tmp0_ = g_strdup ("");
	text = _tmp0_;
	{
		xmlNode* it = NULL;
		xmlNode* _tmp1_;
		_tmp1_ = n->children;
		it = _tmp1_;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				xmlNode* _tmp5_;
				xmlNode* _tmp6_;
				if (!_tmp2_) {
					xmlNode* _tmp3_;
					xmlNode* _tmp4_;
					_tmp3_ = it;
					_tmp4_ = _tmp3_->next;
					it = _tmp4_;
				}
				_tmp2_ = FALSE;
				_tmp5_ = it;
				if (!(_tmp5_ != NULL)) {
					break;
				}
				_tmp6_ = it;
				switch (_tmp6_->type) {
					case XML_ELEMENT_NODE:
					{
						xmlNode* _tmp7_;
						const gchar* _tmp8_;
						gchar* _tmp9_;
						gchar* _tmp10_;
						GQuark _tmp12_ = 0U;
						static GQuark _tmp11_label0 = 0;
						static GQuark _tmp11_label1 = 0;
						static GQuark _tmp11_label2 = 0;
						static GQuark _tmp11_label3 = 0;
						static GQuark _tmp11_label4 = 0;
						static GQuark _tmp11_label5 = 0;
						static GQuark _tmp11_label6 = 0;
						static GQuark _tmp11_label7 = 0;
						static GQuark _tmp11_label8 = 0;
						static GQuark _tmp11_label9 = 0;
						static GQuark _tmp11_label10 = 0;
						static GQuark _tmp11_label11 = 0;
						static GQuark _tmp11_label12 = 0;
						static GQuark _tmp11_label13 = 0;
						static GQuark _tmp11_label14 = 0;
						static GQuark _tmp11_label15 = 0;
						static GQuark _tmp11_label16 = 0;
						static GQuark _tmp11_label17 = 0;
						static GQuark _tmp11_label18 = 0;
						static GQuark _tmp11_label19 = 0;
						static GQuark _tmp11_label20 = 0;
						static GQuark _tmp11_label21 = 0;
						_tmp7_ = it;
						_tmp8_ = _tmp7_->name;
						_tmp9_ = g_utf8_strdown (_tmp8_, (gssize) -1);
						_tmp10_ = _tmp9_;
						_tmp12_ = (NULL == _tmp10_) ? 0 : g_quark_from_string (_tmp10_);
						g_free (_tmp10_);
						if (_tmp12_ == ((0 != _tmp11_label0) ? _tmp11_label0 : (_tmp11_label0 = g_quark_from_static_string ("p")))) {
							switch (0) {
								default:
								{
									const gchar* _tmp13_;
									xmlNode* _tmp14_;
									gchar* _tmp15_;
									gchar* _tmp16_;
									gchar* _tmp17_;
									gchar* _tmp18_;
									gchar* _tmp19_;
									_tmp13_ = text;
									_tmp14_ = it;
									_tmp15_ = html_to_markdown_parse_item (_tmp14_);
									_tmp16_ = _tmp15_;
									_tmp17_ = g_strconcat ("\n\n", _tmp16_, NULL);
									_tmp18_ = _tmp17_;
									_tmp19_ = g_strconcat (_tmp13_, _tmp18_, NULL);
									_g_free0 (text);
									text = _tmp19_;
									_g_free0 (_tmp18_);
									_g_free0 (_tmp16_);
									break;
								}
							}
						} else if (_tmp12_ == ((0 != _tmp11_label1) ? _tmp11_label1 : (_tmp11_label1 = g_quark_from_static_string ("blockquote")))) {
							switch (0) {
								default:
								{
									const gchar* _tmp20_;
									xmlNode* _tmp21_;
									gchar* _tmp22_;
									gchar* _tmp23_;
									gchar* _tmp24_;
									gchar* _tmp25_;
									gchar* _tmp26_;
									_tmp20_ = text;
									_tmp21_ = it;
									_tmp22_ = html_to_markdown_parse_item (_tmp21_);
									_tmp23_ = _tmp22_;
									_tmp24_ = g_strconcat ("\n\n> ", _tmp23_, NULL);
									_tmp25_ = _tmp24_;
									_tmp26_ = g_strconcat (_tmp20_, _tmp25_, NULL);
									_g_free0 (text);
									text = _tmp26_;
									_g_free0 (_tmp25_);
									_g_free0 (_tmp23_);
									break;
								}
							}
						} else if (_tmp12_ == ((0 != _tmp11_label2) ? _tmp11_label2 : (_tmp11_label2 = g_quark_from_static_string ("div")))) {
							switch (0) {
								default:
								{
									const gchar* _tmp27_;
									xmlNode* _tmp28_;
									gchar* _tmp29_;
									gchar* _tmp30_;
									gchar* _tmp31_;
									gchar* _tmp32_;
									gchar* _tmp33_;
									_tmp27_ = text;
									_tmp28_ = it;
									_tmp29_ = html_to_markdown_parse_item (_tmp28_);
									_tmp30_ = _tmp29_;
									_tmp31_ = g_strconcat ("\n\n", _tmp30_, NULL);
									_tmp32_ = _tmp31_;
									_tmp33_ = g_strconcat (_tmp27_, _tmp32_, NULL);
									_g_free0 (text);
									text = _tmp33_;
									_g_free0 (_tmp32_);
									_g_free0 (_tmp30_);
									break;
								}
							}
						} else if (_tmp12_ == ((0 != _tmp11_label3) ? _tmp11_label3 : (_tmp11_label3 = g_quark_from_static_string ("span")))) {
							switch (0) {
								default:
								{
									const gchar* _tmp34_;
									xmlNode* _tmp35_;
									gchar* _tmp36_;
									gchar* _tmp37_;
									gchar* _tmp38_;
									_tmp34_ = text;
									_tmp35_ = it;
									_tmp36_ = html_to_markdown_parse_item (_tmp35_);
									_tmp37_ = _tmp36_;
									_tmp38_ = g_strconcat (_tmp34_, _tmp37_, NULL);
									_g_free0 (text);
									text = _tmp38_;
									_g_free0 (_tmp37_);
									break;
								}
							}
						} else if ((_tmp12_ == ((0 != _tmp11_label4) ? _tmp11_label4 : (_tmp11_label4 = g_quark_from_static_string ("strong")))) || (_tmp12_ == ((0 != _tmp11_label5) ? _tmp11_label5 : (_tmp11_label5 = g_quark_from_static_string ("b"))))) {
							switch (0) {
								default:
								{
									const gchar* _tmp39_;
									xmlNode* _tmp40_;
									gchar* _tmp41_;
									gchar* _tmp42_;
									gchar* _tmp43_;
									gchar* _tmp44_;
									gchar* _tmp45_;
									gchar* _tmp46_;
									gchar* _tmp47_;
									_tmp39_ = text;
									_tmp40_ = it;
									_tmp41_ = html_to_markdown_parse_item (_tmp40_);
									_tmp42_ = _tmp41_;
									_tmp43_ = g_strconcat ("**", _tmp42_, NULL);
									_tmp44_ = _tmp43_;
									_tmp45_ = g_strconcat (_tmp44_, "**", NULL);
									_tmp46_ = _tmp45_;
									_tmp47_ = g_strconcat (_tmp39_, _tmp46_, NULL);
									_g_free0 (text);
									text = _tmp47_;
									_g_free0 (_tmp46_);
									_g_free0 (_tmp44_);
									_g_free0 (_tmp42_);
									break;
								}
							}
						} else if ((_tmp12_ == ((0 != _tmp11_label6) ? _tmp11_label6 : (_tmp11_label6 = g_quark_from_static_string ("em")))) || (_tmp12_ == ((0 != _tmp11_label7) ? _tmp11_label7 : (_tmp11_label7 = g_quark_from_static_string ("i"))))) {
							switch (0) {
								default:
								{
									const gchar* _tmp48_;
									xmlNode* _tmp49_;
									gchar* _tmp50_;
									gchar* _tmp51_;
									gchar* _tmp52_;
									gchar* _tmp53_;
									gchar* _tmp54_;
									gchar* _tmp55_;
									gchar* _tmp56_;
									_tmp48_ = text;
									_tmp49_ = it;
									_tmp50_ = html_to_markdown_parse_item (_tmp49_);
									_tmp51_ = _tmp50_;
									_tmp52_ = g_strconcat ("_", _tmp51_, NULL);
									_tmp53_ = _tmp52_;
									_tmp54_ = g_strconcat (_tmp53_, "_", NULL);
									_tmp55_ = _tmp54_;
									_tmp56_ = g_strconcat (_tmp48_, _tmp55_, NULL);
									_g_free0 (text);
									text = _tmp56_;
									_g_free0 (_tmp55_);
									_g_free0 (_tmp53_);
									_g_free0 (_tmp51_);
									break;
								}
							}
						} else if (_tmp12_ == ((0 != _tmp11_label8) ? _tmp11_label8 : (_tmp11_label8 = g_quark_from_static_string ("ul")))) {
							switch (0) {
								default:
								{
									const gchar* _tmp57_;
									xmlNode* _tmp58_;
									gchar* _tmp59_;
									gchar* _tmp60_;
									gchar* _tmp61_;
									_tmp57_ = text;
									_tmp58_ = it;
									_tmp59_ = html_to_markdown_parse_list (_tmp58_, TRUE, 0);
									_tmp60_ = _tmp59_;
									_tmp61_ = g_strconcat (_tmp57_, _tmp60_, NULL);
									_g_free0 (text);
									text = _tmp61_;
									_g_free0 (_tmp60_);
									break;
								}
							}
						} else if (_tmp12_ == ((0 != _tmp11_label9) ? _tmp11_label9 : (_tmp11_label9 = g_quark_from_static_string ("ol")))) {
							switch (0) {
								default:
								{
									const gchar* _tmp62_;
									xmlNode* _tmp63_;
									gchar* _tmp64_;
									gchar* _tmp65_;
									gchar* _tmp66_;
									_tmp62_ = text;
									_tmp63_ = it;
									_tmp64_ = html_to_markdown_parse_list (_tmp63_, FALSE, 0);
									_tmp65_ = _tmp64_;
									_tmp66_ = g_strconcat (_tmp62_, _tmp65_, NULL);
									_g_free0 (text);
									text = _tmp66_;
									_g_free0 (_tmp65_);
									break;
								}
							}
						} else if (_tmp12_ == ((0 != _tmp11_label10) ? _tmp11_label10 : (_tmp11_label10 = g_quark_from_static_string ("h1")))) {
							switch (0) {
								default:
								{
									const gchar* _tmp67_;
									xmlNode* _tmp68_;
									gchar* _tmp69_;
									gchar* _tmp70_;
									gchar* _tmp71_;
									gchar* _tmp72_;
									gchar* _tmp73_;
									_tmp67_ = text;
									_tmp68_ = it;
									_tmp69_ = html_to_markdown_parse_item (_tmp68_);
									_tmp70_ = _tmp69_;
									_tmp71_ = g_strconcat ("\n\n# ", _tmp70_, NULL);
									_tmp72_ = _tmp71_;
									_tmp73_ = g_strconcat (_tmp67_, _tmp72_, NULL);
									_g_free0 (text);
									text = _tmp73_;
									_g_free0 (_tmp72_);
									_g_free0 (_tmp70_);
									break;
								}
							}
						} else if (_tmp12_ == ((0 != _tmp11_label11) ? _tmp11_label11 : (_tmp11_label11 = g_quark_from_static_string ("h2")))) {
							switch (0) {
								default:
								{
									const gchar* _tmp74_;
									xmlNode* _tmp75_;
									gchar* _tmp76_;
									gchar* _tmp77_;
									gchar* _tmp78_;
									gchar* _tmp79_;
									gchar* _tmp80_;
									_tmp74_ = text;
									_tmp75_ = it;
									_tmp76_ = html_to_markdown_parse_item (_tmp75_);
									_tmp77_ = _tmp76_;
									_tmp78_ = g_strconcat ("\n\n## ", _tmp77_, NULL);
									_tmp79_ = _tmp78_;
									_tmp80_ = g_strconcat (_tmp74_, _tmp79_, NULL);
									_g_free0 (text);
									text = _tmp80_;
									_g_free0 (_tmp79_);
									_g_free0 (_tmp77_);
									break;
								}
							}
						} else if (_tmp12_ == ((0 != _tmp11_label12) ? _tmp11_label12 : (_tmp11_label12 = g_quark_from_static_string ("h3")))) {
							switch (0) {
								default:
								{
									const gchar* _tmp81_;
									xmlNode* _tmp82_;
									gchar* _tmp83_;
									gchar* _tmp84_;
									gchar* _tmp85_;
									gchar* _tmp86_;
									gchar* _tmp87_;
									_tmp81_ = text;
									_tmp82_ = it;
									_tmp83_ = html_to_markdown_parse_item (_tmp82_);
									_tmp84_ = _tmp83_;
									_tmp85_ = g_strconcat ("\n\n### ", _tmp84_, NULL);
									_tmp86_ = _tmp85_;
									_tmp87_ = g_strconcat (_tmp81_, _tmp86_, NULL);
									_g_free0 (text);
									text = _tmp87_;
									_g_free0 (_tmp86_);
									_g_free0 (_tmp84_);
									break;
								}
							}
						} else if (_tmp12_ == ((0 != _tmp11_label13) ? _tmp11_label13 : (_tmp11_label13 = g_quark_from_static_string ("h4")))) {
							switch (0) {
								default:
								{
									const gchar* _tmp88_;
									xmlNode* _tmp89_;
									gchar* _tmp90_;
									gchar* _tmp91_;
									gchar* _tmp92_;
									gchar* _tmp93_;
									gchar* _tmp94_;
									_tmp88_ = text;
									_tmp89_ = it;
									_tmp90_ = html_to_markdown_parse_item (_tmp89_);
									_tmp91_ = _tmp90_;
									_tmp92_ = g_strconcat ("\n\n#### ", _tmp91_, NULL);
									_tmp93_ = _tmp92_;
									_tmp94_ = g_strconcat (_tmp88_, _tmp93_, NULL);
									_g_free0 (text);
									text = _tmp94_;
									_g_free0 (_tmp93_);
									_g_free0 (_tmp91_);
									break;
								}
							}
						} else if (_tmp12_ == ((0 != _tmp11_label14) ? _tmp11_label14 : (_tmp11_label14 = g_quark_from_static_string ("h5")))) {
							switch (0) {
								default:
								{
									const gchar* _tmp95_;
									xmlNode* _tmp96_;
									gchar* _tmp97_;
									gchar* _tmp98_;
									gchar* _tmp99_;
									gchar* _tmp100_;
									gchar* _tmp101_;
									_tmp95_ = text;
									_tmp96_ = it;
									_tmp97_ = html_to_markdown_parse_item (_tmp96_);
									_tmp98_ = _tmp97_;
									_tmp99_ = g_strconcat ("\n\n##### ", _tmp98_, NULL);
									_tmp100_ = _tmp99_;
									_tmp101_ = g_strconcat (_tmp95_, _tmp100_, NULL);
									_g_free0 (text);
									text = _tmp101_;
									_g_free0 (_tmp100_);
									_g_free0 (_tmp98_);
									break;
								}
							}
						} else if (_tmp12_ == ((0 != _tmp11_label15) ? _tmp11_label15 : (_tmp11_label15 = g_quark_from_static_string ("h6")))) {
							switch (0) {
								default:
								{
									const gchar* _tmp102_;
									xmlNode* _tmp103_;
									gchar* _tmp104_;
									gchar* _tmp105_;
									gchar* _tmp106_;
									gchar* _tmp107_;
									gchar* _tmp108_;
									_tmp102_ = text;
									_tmp103_ = it;
									_tmp104_ = html_to_markdown_parse_item (_tmp103_);
									_tmp105_ = _tmp104_;
									_tmp106_ = g_strconcat ("\n\n###### ", _tmp105_, NULL);
									_tmp107_ = _tmp106_;
									_tmp108_ = g_strconcat (_tmp102_, _tmp107_, NULL);
									_g_free0 (text);
									text = _tmp108_;
									_g_free0 (_tmp107_);
									_g_free0 (_tmp105_);
									break;
								}
							}
						} else if (_tmp12_ == ((0 != _tmp11_label16) ? _tmp11_label16 : (_tmp11_label16 = g_quark_from_static_string ("hr")))) {
							switch (0) {
								default:
								{
									const gchar* _tmp109_;
									gchar* _tmp110_;
									_tmp109_ = text;
									_tmp110_ = g_strconcat (_tmp109_, "\n\n---\n\n", NULL);
									_g_free0 (text);
									text = _tmp110_;
									break;
								}
							}
						} else if (_tmp12_ == ((0 != _tmp11_label17) ? _tmp11_label17 : (_tmp11_label17 = g_quark_from_static_string ("br")))) {
							switch (0) {
								default:
								{
									const gchar* _tmp111_;
									gchar* _tmp112_;
									_tmp111_ = text;
									_tmp112_ = g_strconcat (_tmp111_, "\n", NULL);
									_g_free0 (text);
									text = _tmp112_;
									break;
								}
							}
						} else if (_tmp12_ == ((0 != _tmp11_label18) ? _tmp11_label18 : (_tmp11_label18 = g_quark_from_static_string ("a")))) {
							switch (0) {
								default:
								{
									const gchar* _tmp113_;
									xmlNode* _tmp114_;
									gchar* _tmp115_;
									gchar* _tmp116_;
									gchar* _tmp117_;
									_tmp113_ = text;
									_tmp114_ = it;
									_tmp115_ = html_to_markdown_parse_link (_tmp114_);
									_tmp116_ = _tmp115_;
									_tmp117_ = g_strconcat (_tmp113_, _tmp116_, NULL);
									_g_free0 (text);
									text = _tmp117_;
									_g_free0 (_tmp116_);
									break;
								}
							}
						} else if (_tmp12_ == ((0 != _tmp11_label19) ? _tmp11_label19 : (_tmp11_label19 = g_quark_from_static_string ("code")))) {
							switch (0) {
								default:
								{
									const gchar* _tmp118_;
									xmlNode* _tmp119_;
									gchar* _tmp120_;
									gchar* _tmp121_;
									gchar* _tmp122_;
									gchar* _tmp123_;
									gchar* _tmp124_;
									gchar* _tmp125_;
									gchar* _tmp126_;
									_tmp118_ = text;
									_tmp119_ = it;
									_tmp120_ = html_to_markdown_parse_item (_tmp119_);
									_tmp121_ = _tmp120_;
									_tmp122_ = g_strconcat ("`", _tmp121_, NULL);
									_tmp123_ = _tmp122_;
									_tmp124_ = g_strconcat (_tmp123_, "`", NULL);
									_tmp125_ = _tmp124_;
									_tmp126_ = g_strconcat (_tmp118_, _tmp125_, NULL);
									_g_free0 (text);
									text = _tmp126_;
									_g_free0 (_tmp125_);
									_g_free0 (_tmp123_);
									_g_free0 (_tmp121_);
									break;
								}
							}
						} else if (_tmp12_ == ((0 != _tmp11_label20) ? _tmp11_label20 : (_tmp11_label20 = g_quark_from_static_string ("img")))) {
							switch (0) {
								default:
								{
									const gchar* _tmp127_;
									xmlNode* _tmp128_;
									gchar* _tmp129_;
									gchar* _tmp130_;
									gchar* _tmp131_;
									_tmp127_ = text;
									_tmp128_ = it;
									_tmp129_ = html_to_markdown_parse_image (_tmp128_);
									_tmp130_ = _tmp129_;
									_tmp131_ = g_strconcat (_tmp127_, _tmp130_, NULL);
									_g_free0 (text);
									text = _tmp131_;
									_g_free0 (_tmp130_);
									break;
								}
							}
						} else if (_tmp12_ == ((0 != _tmp11_label21) ? _tmp11_label21 : (_tmp11_label21 = g_quark_from_static_string ("pre")))) {
							switch (0) {
								default:
								{
									const gchar* _tmp132_;
									xmlNode* _tmp133_;
									gchar* _tmp134_;
									gchar* _tmp135_;
									gchar* _tmp136_;
									gchar* _tmp137_;
									gchar* _tmp138_;
									gchar* _tmp139_;
									gchar* _tmp140_;
									_tmp132_ = text;
									_tmp133_ = it;
									_tmp134_ = html_to_markdown_parse_item (_tmp133_);
									_tmp135_ = _tmp134_;
									_tmp136_ = g_strconcat ("\n\n```\n", _tmp135_, NULL);
									_tmp137_ = _tmp136_;
									_tmp138_ = g_strconcat (_tmp137_, "\n```", NULL);
									_tmp139_ = _tmp138_;
									_tmp140_ = g_strconcat (_tmp132_, _tmp139_, NULL);
									_g_free0 (text);
									text = _tmp140_;
									_g_free0 (_tmp139_);
									_g_free0 (_tmp137_);
									_g_free0 (_tmp135_);
									break;
								}
							}
						} else {
							switch (0) {
								default:
								{
									if (html_to_markdown_extensions) {
										xmlNode* _tmp141_;
										const gchar* _tmp142_;
										gchar* _tmp143_;
										gchar* _tmp144_;
										GQuark _tmp146_ = 0U;
										static GQuark _tmp145_label0 = 0;
										static GQuark _tmp145_label1 = 0;
										_tmp141_ = it;
										_tmp142_ = _tmp141_->name;
										_tmp143_ = g_utf8_strdown (_tmp142_, (gssize) -1);
										_tmp144_ = _tmp143_;
										_tmp146_ = (NULL == _tmp144_) ? 0 : g_quark_from_string (_tmp144_);
										g_free (_tmp144_);
										if (_tmp146_ == ((0 != _tmp145_label0) ? _tmp145_label0 : (_tmp145_label0 = g_quark_from_static_string ("del")))) {
											switch (0) {
												default:
												{
													const gchar* _tmp147_;
													xmlNode* _tmp148_;
													gchar* _tmp149_;
													gchar* _tmp150_;
													gchar* _tmp151_;
													gchar* _tmp152_;
													gchar* _tmp153_;
													gchar* _tmp154_;
													gchar* _tmp155_;
													_tmp147_ = text;
													_tmp148_ = it;
													_tmp149_ = html_to_markdown_parse_item (_tmp148_);
													_tmp150_ = _tmp149_;
													_tmp151_ = g_strconcat ("~~", _tmp150_, NULL);
													_tmp152_ = _tmp151_;
													_tmp153_ = g_strconcat (_tmp152_, "~~", NULL);
													_tmp154_ = _tmp153_;
													_tmp155_ = g_strconcat (_tmp147_, _tmp154_, NULL);
													_g_free0 (text);
													text = _tmp155_;
													_g_free0 (_tmp154_);
													_g_free0 (_tmp152_);
													_g_free0 (_tmp150_);
													break;
												}
											}
										} else if (_tmp146_ == ((0 != _tmp145_label1) ? _tmp145_label1 : (_tmp145_label1 = g_quark_from_static_string ("table")))) {
											switch (0) {
												default:
												{
													const gchar* _tmp156_;
													xmlNode* _tmp157_;
													gchar* _tmp158_;
													gchar* _tmp159_;
													gchar* _tmp160_;
													gchar* _tmp161_;
													gchar* _tmp162_;
													_tmp156_ = text;
													_tmp157_ = it;
													_tmp158_ = html_to_markdown_parse_table (_tmp157_);
													_tmp159_ = _tmp158_;
													_tmp160_ = g_strconcat ("\n\n", _tmp159_, NULL);
													_tmp161_ = _tmp160_;
													_tmp162_ = g_strconcat (_tmp156_, _tmp161_, NULL);
													_g_free0 (text);
													text = _tmp162_;
													_g_free0 (_tmp161_);
													_g_free0 (_tmp159_);
													break;
												}
											}
										} else {
											switch (0) {
												default:
												{
													const gchar* _tmp163_;
													xmlNode* _tmp164_;
													gchar* _tmp165_;
													gchar* _tmp166_;
													gchar* _tmp167_;
													_tmp163_ = text;
													_tmp164_ = it;
													_tmp165_ = html_to_markdown_parse_node (_tmp164_);
													_tmp166_ = _tmp165_;
													_tmp167_ = g_strconcat (_tmp163_, _tmp166_, NULL);
													_g_free0 (text);
													text = _tmp167_;
													_g_free0 (_tmp166_);
													break;
												}
											}
										}
									} else {
										const gchar* _tmp168_;
										xmlNode* _tmp169_;
										gchar* _tmp170_;
										gchar* _tmp171_;
										gchar* _tmp172_;
										_tmp168_ = text;
										_tmp169_ = it;
										_tmp170_ = html_to_markdown_parse_node (_tmp169_);
										_tmp171_ = _tmp170_;
										_tmp172_ = g_strconcat (_tmp168_, _tmp171_, NULL);
										_g_free0 (text);
										text = _tmp172_;
										_g_free0 (_tmp171_);
									}
									break;
								}
							}
						}
						break;
					}
					case XML_TEXT_NODE:
					{
						xmlNode* _tmp173_;
						const gchar* _tmp174_;
						gchar* _tmp175_;
						gchar* _tmp176_;
						gboolean _tmp177_;
						_tmp173_ = it;
						_tmp174_ = _tmp173_->content;
						_tmp175_ = string_strip (_tmp174_);
						_tmp176_ = _tmp175_;
						_tmp177_ = g_strcmp0 (_tmp176_, "") != 0;
						_g_free0 (_tmp176_);
						if (_tmp177_) {
							const gchar* _tmp178_;
							xmlNode* _tmp179_;
							const gchar* _tmp180_;
							gchar* _tmp181_;
							_tmp178_ = text;
							_tmp179_ = it;
							_tmp180_ = _tmp179_->content;
							_tmp181_ = g_strconcat (_tmp178_, _tmp180_, NULL);
							_g_free0 (text);
							text = _tmp181_;
						}
						break;
					}
					case XML_CDATA_SECTION_NODE:
					{
						const gchar* _tmp182_;
						xmlNode* _tmp183_;
						const gchar* _tmp184_;
						gchar* _tmp185_;
						gchar* _tmp186_;
						gchar* _tmp187_;
						gchar* _tmp188_;
						gchar* _tmp189_;
						_tmp182_ = text;
						_tmp183_ = it;
						_tmp184_ = _tmp183_->content;
						_tmp185_ = g_strconcat ("\n\n```\n", _tmp184_, NULL);
						_tmp186_ = _tmp185_;
						_tmp187_ = g_strconcat (_tmp186_, "\n```", NULL);
						_tmp188_ = _tmp187_;
						_tmp189_ = g_strconcat (_tmp182_, _tmp188_, NULL);
						_g_free0 (text);
						text = _tmp189_;
						_g_free0 (_tmp188_);
						_g_free0 (_tmp186_);
						break;
					}
					default:
					break;
				}
			}
		}
	}
	_tmp190_ = text;
	_tmp191_ = string_strip (_tmp190_);
	result = _tmp191_;
	_g_free0 (text);
	return result;
}

gchar*
html_to_markdown_parse_list (xmlNode* n,
                             gboolean unordered,
                             gint depth)
{
	gchar* text = NULL;
	gchar* _tmp0_;
	gint index = 0;
	gint _tmp1_;
	gint _tmp44_;
	gchar* result;
	_tmp0_ = g_strdup ("");
	text = _tmp0_;
	index = 1;
	_tmp1_ = html_to_markdown_list_depth;
	html_to_markdown_list_depth = _tmp1_ + 1;
	{
		xmlNode* it = NULL;
		xmlNode* _tmp2_;
		_tmp2_ = n->children;
		it = _tmp2_;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				xmlNode* _tmp6_;
				gboolean _tmp7_ = FALSE;
				xmlNode* _tmp8_;
				if (!_tmp3_) {
					xmlNode* _tmp4_;
					xmlNode* _tmp5_;
					_tmp4_ = it;
					_tmp5_ = _tmp4_->next;
					it = _tmp5_;
				}
				_tmp3_ = FALSE;
				_tmp6_ = it;
				if (!(_tmp6_ != NULL)) {
					break;
				}
				_tmp8_ = it;
				if (_tmp8_->type == XML_ELEMENT_NODE) {
					xmlNode* _tmp9_;
					const gchar* _tmp10_;
					gchar* _tmp11_;
					gchar* _tmp12_;
					_tmp9_ = it;
					_tmp10_ = _tmp9_->name;
					_tmp11_ = g_utf8_strdown (_tmp10_, (gssize) -1);
					_tmp12_ = _tmp11_;
					_tmp7_ = g_strcmp0 (_tmp12_, "li") == 0;
					_g_free0 (_tmp12_);
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					gint _tmp43_;
					if (unordered) {
						const gchar* _tmp13_;
						gchar* _tmp14_;
						gchar* _tmp15_;
						gchar* _tmp16_;
						gchar* _tmp17_;
						gchar* _tmp18_;
						gchar* _tmp19_;
						xmlNode* _tmp20_;
						gchar* _tmp21_;
						gchar* _tmp22_;
						gchar* _tmp23_;
						gchar* _tmp24_;
						gchar* _tmp25_;
						_tmp13_ = text;
						_tmp14_ = g_strnfill ((gsize) (html_to_markdown_list_depth * 4), ' ');
						_tmp15_ = _tmp14_;
						_tmp16_ = g_strconcat ("\n", _tmp15_, NULL);
						_tmp17_ = _tmp16_;
						_tmp18_ = g_strconcat (_tmp17_, "- ", NULL);
						_tmp19_ = _tmp18_;
						_tmp20_ = it;
						_tmp21_ = html_to_markdown_parse_item (_tmp20_);
						_tmp22_ = _tmp21_;
						_tmp23_ = g_strconcat (_tmp19_, _tmp22_, NULL);
						_tmp24_ = _tmp23_;
						_tmp25_ = g_strconcat (_tmp13_, _tmp24_, NULL);
						_g_free0 (text);
						text = _tmp25_;
						_g_free0 (_tmp24_);
						_g_free0 (_tmp22_);
						_g_free0 (_tmp19_);
						_g_free0 (_tmp17_);
						_g_free0 (_tmp15_);
					} else {
						const gchar* _tmp26_;
						gchar* _tmp27_;
						gchar* _tmp28_;
						gchar* _tmp29_;
						gchar* _tmp30_;
						gchar* _tmp31_;
						gchar* _tmp32_;
						gchar* _tmp33_;
						gchar* _tmp34_;
						gchar* _tmp35_;
						gchar* _tmp36_;
						xmlNode* _tmp37_;
						gchar* _tmp38_;
						gchar* _tmp39_;
						gchar* _tmp40_;
						gchar* _tmp41_;
						gchar* _tmp42_;
						_tmp26_ = text;
						_tmp27_ = g_strnfill ((gsize) (html_to_markdown_list_depth * 4), ' ');
						_tmp28_ = _tmp27_;
						_tmp29_ = g_strconcat ("\n", _tmp28_, NULL);
						_tmp30_ = _tmp29_;
						_tmp31_ = g_strdup_printf ("%i", index);
						_tmp32_ = _tmp31_;
						_tmp33_ = g_strconcat (_tmp30_, _tmp32_, NULL);
						_tmp34_ = _tmp33_;
						_tmp35_ = g_strconcat (_tmp34_, ". ", NULL);
						_tmp36_ = _tmp35_;
						_tmp37_ = it;
						_tmp38_ = html_to_markdown_parse_item (_tmp37_);
						_tmp39_ = _tmp38_;
						_tmp40_ = g_strconcat (_tmp36_, _tmp39_, NULL);
						_tmp41_ = _tmp40_;
						_tmp42_ = g_strconcat (_tmp26_, _tmp41_, NULL);
						_g_free0 (text);
						text = _tmp42_;
						_g_free0 (_tmp41_);
						_g_free0 (_tmp39_);
						_g_free0 (_tmp36_);
						_g_free0 (_tmp34_);
						_g_free0 (_tmp32_);
						_g_free0 (_tmp30_);
						_g_free0 (_tmp28_);
					}
					_tmp43_ = index;
					index = _tmp43_ + 1;
				}
			}
		}
	}
	_tmp44_ = html_to_markdown_list_depth;
	html_to_markdown_list_depth = _tmp44_ - 1;
	result = text;
	return result;
}

gchar*
html_to_markdown_parse_link (xmlNode* n)
{
	gchar* item = NULL;
	gchar* _tmp0_;
	gchar* h = NULL;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gchar* result;
	_tmp0_ = html_to_markdown_parse_item (n);
	item = _tmp0_;
	_tmp1_ = (gchar*) xmlGetProp (n, (xmlChar*) "href");
	h = _tmp1_;
	_tmp3_ = h;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = h;
		_tmp5_ = item;
		_tmp2_ = g_strcmp0 (_tmp4_, _tmp5_) != 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp6_ = item;
		_tmp7_ = g_strconcat ("[", _tmp6_, NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat (_tmp8_, "](", NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = h;
		_tmp12_ = g_strconcat (_tmp10_, _tmp11_, NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat (_tmp13_, ")", NULL);
		_tmp15_ = _tmp14_;
		_g_free0 (_tmp13_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
		result = _tmp15_;
		_g_free0 (h);
		_g_free0 (item);
		return result;
	}
	result = item;
	_g_free0 (h);
	return result;
}

gchar*
html_to_markdown_parse_image (xmlNode* n)
{
	gchar* text = NULL;
	gchar* _tmp0_;
	gchar* s = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* result;
	_tmp0_ = g_strdup ("");
	text = _tmp0_;
	_tmp1_ = (gchar*) xmlGetProp (n, (xmlChar*) "src");
	s = _tmp1_;
	_tmp2_ = s;
	if (_tmp2_ != NULL) {
		gchar* a = NULL;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = (gchar*) xmlGetProp (n, (xmlChar*) "alt");
		a = _tmp3_;
		_tmp4_ = a;
		if (_tmp4_ != NULL) {
			const gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp5_ = a;
			_tmp6_ = g_strconcat ("![", _tmp5_, NULL);
			_tmp7_ = _tmp6_;
			_tmp8_ = g_strconcat (_tmp7_, "](", NULL);
			_tmp9_ = _tmp8_;
			_tmp10_ = s;
			_tmp11_ = g_strconcat (_tmp9_, _tmp10_, NULL);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strconcat (_tmp12_, ")", NULL);
			_g_free0 (text);
			text = _tmp13_;
			_g_free0 (_tmp12_);
			_g_free0 (_tmp9_);
			_g_free0 (_tmp7_);
		} else {
			const gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp14_ = s;
			_tmp15_ = g_strconcat ("![](", _tmp14_, NULL);
			_tmp16_ = _tmp15_;
			_tmp17_ = g_strconcat (_tmp16_, ")", NULL);
			_g_free0 (text);
			text = _tmp17_;
			_g_free0 (_tmp16_);
		}
		_g_free0 (a);
	}
	result = text;
	_g_free0 (s);
	return result;
}

gchar*
html_to_markdown_parse_table (xmlNode* n)
{
	gchar* text = NULL;
	gchar* _tmp0_;
	gint row = 0;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* result;
	_tmp0_ = g_strdup ("");
	text = _tmp0_;
	row = 0;
	{
		xmlNode* it = NULL;
		xmlNode* _tmp1_;
		_tmp1_ = n->children;
		it = _tmp1_;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				xmlNode* _tmp5_;
				gboolean _tmp6_ = FALSE;
				xmlNode* _tmp7_;
				if (!_tmp2_) {
					xmlNode* _tmp3_;
					xmlNode* _tmp4_;
					_tmp3_ = it;
					_tmp4_ = _tmp3_->next;
					it = _tmp4_;
				}
				_tmp2_ = FALSE;
				_tmp5_ = it;
				if (!(_tmp5_ != NULL)) {
					break;
				}
				_tmp7_ = it;
				if (_tmp7_->type == XML_ELEMENT_NODE) {
					xmlNode* _tmp8_;
					const gchar* _tmp9_;
					gchar* _tmp10_;
					gchar* _tmp11_;
					_tmp8_ = it;
					_tmp9_ = _tmp8_->name;
					_tmp10_ = g_utf8_strdown (_tmp9_, (gssize) -1);
					_tmp11_ = _tmp10_;
					_tmp6_ = g_strcmp0 (_tmp11_, "tr") == 0;
					_g_free0 (_tmp11_);
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					gint cols = 0;
					const gchar* _tmp12_;
					xmlNode* _tmp13_;
					gint _tmp14_ = 0;
					gchar* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					gchar* _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					gboolean _tmp22_ = FALSE;
					gint _tmp31_;
					_tmp12_ = text;
					_tmp13_ = it;
					_tmp15_ = html_to_markdown_parse_table_row (_tmp13_, &_tmp14_);
					cols = _tmp14_;
					_tmp16_ = _tmp15_;
					_tmp17_ = g_strconcat ("|", _tmp16_, NULL);
					_tmp18_ = _tmp17_;
					_tmp19_ = g_strconcat (_tmp18_, "\n", NULL);
					_tmp20_ = _tmp19_;
					_tmp21_ = g_strconcat (_tmp12_, _tmp20_, NULL);
					_g_free0 (text);
					text = _tmp21_;
					_g_free0 (_tmp20_);
					_g_free0 (_tmp18_);
					_g_free0 (_tmp16_);
					if (row == 0) {
						_tmp22_ = cols > 0;
					} else {
						_tmp22_ = FALSE;
					}
					if (_tmp22_) {
						const gchar* _tmp23_;
						gchar* _tmp24_;
						const gchar* _tmp29_;
						gchar* _tmp30_;
						_tmp23_ = text;
						_tmp24_ = g_strconcat (_tmp23_, "|", NULL);
						_g_free0 (text);
						text = _tmp24_;
						{
							gint col = 0;
							col = 0;
							{
								gboolean _tmp25_ = FALSE;
								_tmp25_ = TRUE;
								while (TRUE) {
									const gchar* _tmp27_;
									gchar* _tmp28_;
									if (!_tmp25_) {
										gint _tmp26_;
										_tmp26_ = col;
										col = _tmp26_ + 1;
									}
									_tmp25_ = FALSE;
									if (!(col < cols)) {
										break;
									}
									_tmp27_ = text;
									_tmp28_ = g_strconcat (_tmp27_, " - |", NULL);
									_g_free0 (text);
									text = _tmp28_;
								}
							}
						}
						_tmp29_ = text;
						_tmp30_ = g_strconcat (_tmp29_, "\n", NULL);
						_g_free0 (text);
						text = _tmp30_;
					}
					_tmp31_ = row;
					row = _tmp31_ + 1;
				}
			}
		}
	}
	_tmp32_ = text;
	_tmp33_ = string_strip (_tmp32_);
	result = _tmp33_;
	_g_free0 (text);
	return result;
}

gchar*
html_to_markdown_parse_table_row (xmlNode* n,
                                  gint* cols)
{
	gint _vala_cols = 0;
	gchar* text = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup ("");
	text = _tmp0_;
	_vala_cols = 0;
	{
		xmlNode* it = NULL;
		xmlNode* _tmp1_;
		_tmp1_ = n->children;
		it = _tmp1_;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				xmlNode* _tmp5_;
				xmlNode* _tmp6_;
				if (!_tmp2_) {
					xmlNode* _tmp3_;
					xmlNode* _tmp4_;
					_tmp3_ = it;
					_tmp4_ = _tmp3_->next;
					it = _tmp4_;
				}
				_tmp2_ = FALSE;
				_tmp5_ = it;
				if (!(_tmp5_ != NULL)) {
					break;
				}
				_tmp6_ = it;
				if (_tmp6_->type == XML_ELEMENT_NODE) {
					xmlNode* _tmp7_;
					const gchar* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					GQuark _tmp12_ = 0U;
					static GQuark _tmp11_label0 = 0;
					static GQuark _tmp11_label1 = 0;
					_tmp7_ = it;
					_tmp8_ = _tmp7_->name;
					_tmp9_ = g_utf8_strdown (_tmp8_, (gssize) -1);
					_tmp10_ = _tmp9_;
					_tmp12_ = (NULL == _tmp10_) ? 0 : g_quark_from_string (_tmp10_);
					g_free (_tmp10_);
					if ((_tmp12_ == ((0 != _tmp11_label0) ? _tmp11_label0 : (_tmp11_label0 = g_quark_from_static_string ("th")))) || (_tmp12_ == ((0 != _tmp11_label1) ? _tmp11_label1 : (_tmp11_label1 = g_quark_from_static_string ("td"))))) {
						switch (0) {
							default:
							{
								const gchar* _tmp13_;
								xmlNode* _tmp14_;
								gchar* _tmp15_;
								gchar* _tmp16_;
								gchar* _tmp17_;
								gchar* _tmp18_;
								gchar* _tmp19_;
								gchar* _tmp20_;
								gchar* _tmp21_;
								gint _tmp22_;
								_tmp13_ = text;
								_tmp14_ = it;
								_tmp15_ = html_to_markdown_parse_item (_tmp14_);
								_tmp16_ = _tmp15_;
								_tmp17_ = g_strconcat (" ", _tmp16_, NULL);
								_tmp18_ = _tmp17_;
								_tmp19_ = g_strconcat (_tmp18_, " |", NULL);
								_tmp20_ = _tmp19_;
								_tmp21_ = g_strconcat (_tmp13_, _tmp20_, NULL);
								_g_free0 (text);
								text = _tmp21_;
								_g_free0 (_tmp20_);
								_g_free0 (_tmp18_);
								_g_free0 (_tmp16_);
								_tmp22_ = _vala_cols;
								_vala_cols = _tmp22_ + 1;
								break;
							}
						}
					}
				}
			}
		}
	}
	result = text;
	if (cols) {
		*cols = _vala_cols;
	}
	return result;
}

gchar*
html_to_markdown_parse_node (xmlNode* n)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* result;
	_tmp0_ = n->name;
	_tmp1_ = g_strconcat ("<", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, ">", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = html_to_markdown_parse_item (n);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat (_tmp4_, _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (_tmp8_, "</", NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = n->name;
	_tmp12_ = g_strconcat (_tmp10_, _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp13_, ">", NULL);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	result = _tmp15_;
	return result;
}

HtmlToMarkdown*
html_to_markdown_construct (GType object_type)
{
	HtmlToMarkdown* self = NULL;
	self = (HtmlToMarkdown*) g_type_create_instance (object_type);
	return self;
}

HtmlToMarkdown*
html_to_markdown_new (void)
{
	return html_to_markdown_construct (TYPE_HTML_TO_MARKDOWN);
}

static void
value_html_to_markdown_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_html_to_markdown_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		html_to_markdown_unref (value->data[0].v_pointer);
	}
}

static void
value_html_to_markdown_copy_value (const GValue* src_value,
                                   GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = html_to_markdown_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_html_to_markdown_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_html_to_markdown_collect_value (GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		HtmlToMarkdown * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = html_to_markdown_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_html_to_markdown_lcopy_value (const GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	HtmlToMarkdown ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = html_to_markdown_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_html_to_markdown (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags)
{
	ParamSpecHtmlToMarkdown* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_HTML_TO_MARKDOWN), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_html_to_markdown (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HTML_TO_MARKDOWN), NULL);
	return value->data[0].v_pointer;
}

void
value_set_html_to_markdown (GValue* value,
                            gpointer v_object)
{
	HtmlToMarkdown * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HTML_TO_MARKDOWN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HTML_TO_MARKDOWN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		html_to_markdown_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		html_to_markdown_unref (old);
	}
}

void
value_take_html_to_markdown (GValue* value,
                             gpointer v_object)
{
	HtmlToMarkdown * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HTML_TO_MARKDOWN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HTML_TO_MARKDOWN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		html_to_markdown_unref (old);
	}
}

static void
html_to_markdown_class_init (HtmlToMarkdownClass * klass,
                             gpointer klass_data)
{
	html_to_markdown_parent_class = g_type_class_peek_parent (klass);
	((HtmlToMarkdownClass *) klass)->finalize = html_to_markdown_finalize;
}

static void
html_to_markdown_instance_init (HtmlToMarkdown * self,
                                gpointer klass)
{
	self->ref_count = 1;
}

static void
html_to_markdown_finalize (HtmlToMarkdown * obj)
{
	HtmlToMarkdown * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HTML_TO_MARKDOWN, HtmlToMarkdown);
	g_signal_handlers_destroy (self);
}

static GType
html_to_markdown_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_html_to_markdown_init, value_html_to_markdown_free_value, value_html_to_markdown_copy_value, value_html_to_markdown_peek_pointer, "p", value_html_to_markdown_collect_value, "p", value_html_to_markdown_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (HtmlToMarkdownClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) html_to_markdown_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HtmlToMarkdown), 0, (GInstanceInitFunc) html_to_markdown_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType html_to_markdown_type_id;
	html_to_markdown_type_id = g_type_register_fundamental (g_type_fundamental_next (), "HtmlToMarkdown", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return html_to_markdown_type_id;
}

GType
html_to_markdown_get_type (void)
{
	static volatile gsize html_to_markdown_type_id__once = 0;
	if (g_once_init_enter (&html_to_markdown_type_id__once)) {
		GType html_to_markdown_type_id;
		html_to_markdown_type_id = html_to_markdown_get_type_once ();
		g_once_init_leave (&html_to_markdown_type_id__once, html_to_markdown_type_id);
	}
	return html_to_markdown_type_id__once;
}

gpointer
html_to_markdown_ref (gpointer instance)
{
	HtmlToMarkdown * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
html_to_markdown_unref (gpointer instance)
{
	HtmlToMarkdown * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		HTML_TO_MARKDOWN_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

