/* fuzzy-search-indexer.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from fuzzy-search-indexer.vala, do not modify */

/*
* SPDX-License-Identifier: GPL-3.0-or-later
* SPDX-FileCopyrightText: 2023 elementary, Inc. <https://elementary.io>
*
* Authored by: Colin Kiama <colinkiama@gmail.com>
*/

#include <glib.h>
#include "fuzzy-search.h"
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include "codecore.h"

#define SECONDS_IN_MICROSECONDS ((glong) 1000000)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	INITIAL_INDEX_REQUEST_0_PROPERTY,
	INITIAL_INDEX_REQUEST_MESSAGE_TYPE_PROPERTY,
	INITIAL_INDEX_REQUEST_PROJECT_PATH_PROPERTY,
	INITIAL_INDEX_REQUEST_NUM_PROPERTIES
};
static GParamSpec* initial_index_request_properties[INITIAL_INDEX_REQUEST_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	PROJECT_UPDATE_0_PROPERTY,
	PROJECT_UPDATE_MESSAGE_TYPE_PROPERTY,
	PROJECT_UPDATE_UPDATE_TYPE_PROPERTY,
	PROJECT_UPDATE_SOURCE_PATH_PROPERTY,
	PROJECT_UPDATE_DESTINATION_PATH_PROPERTY,
	PROJECT_UPDATE_PROJECT_PATH_PROPERTY,
	PROJECT_UPDATE_NUM_PROPERTIES
};
static GParamSpec* project_update_properties[PROJECT_UPDATE_NUM_PROPERTIES];
enum  {
	SCRATCH_SERVICES_FUZZY_SEARCH_INDEXER_0_PROPERTY,
	SCRATCH_SERVICES_FUZZY_SEARCH_INDEXER_PROJECT_PATHS_PROPERTY,
	SCRATCH_SERVICES_FUZZY_SEARCH_INDEXER_NUM_PROPERTIES
};
static GParamSpec* scratch_services_fuzzy_search_indexer_properties[SCRATCH_SERVICES_FUZZY_SEARCH_INDEXER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
typedef struct _ScratchServicesFuzzySearchIndexerStartAsyncData ScratchServicesFuzzySearchIndexerStartAsyncData;
typedef struct _ScratchServicesFuzzySearchIndexerProcessNextMessageAsyncData ScratchServicesFuzzySearchIndexerProcessNextMessageAsyncData;
typedef struct _Block5Data Block5Data;
typedef struct _ScratchServicesFuzzySearchIndexerProcessProjectUpdateAsyncData ScratchServicesFuzzySearchIndexerProcessProjectUpdateAsyncData;
#define _scratch_services_search_project_unref0(var) ((var == NULL) ? NULL : (var = (scratch_services_search_project_unref (var), NULL)))
typedef struct _Block6Data Block6Data;
typedef struct _ScratchServicesFuzzySearchIndexerAddDirectoryAsyncData ScratchServicesFuzzySearchIndexerAddDirectoryAsyncData;
typedef struct _Block7Data Block7Data;
typedef struct _ScratchServicesFuzzySearchIndexerAddProjectAsyncData ScratchServicesFuzzySearchIndexerAddProjectAsyncData;
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;
typedef struct _ScratchServicesFuzzySearchIndexerProcessInitialIndexingRequestsAsyncData ScratchServicesFuzzySearchIndexerProcessInitialIndexingRequestsAsyncData;

struct _InitialIndexRequestPrivate {
	IndexerMessageType _message_type;
	gchar* _project_path;
};

struct _ProjectUpdatePrivate {
	IndexerMessageType _message_type;
	ProjectUpdateType _update_type;
	gchar* _source_path;
	gchar* _destination_path;
	gchar* _project_path;
};

struct _ScratchServicesFuzzySearchIndexerPrivate {
	GeeHashMap* _project_paths;
	GeeArrayList* initial_indexing_queue;
	GSettings* folder_settings;
	GCancellable* cancellable;
	GeeConcurrentList* processing_queue;
	IndexerStatus status;
};

struct _Block3Data {
	int _ref_count_;
	ScratchServicesFuzzySearchIndexer* self;
	gpointer _async_data_;
};

struct _Block4Data {
	int _ref_count_;
	Block3Data * _data3_;
	IndexerMessage* first_item;
};

struct _ScratchServicesFuzzySearchIndexerStartAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ScratchServicesFuzzySearchIndexer* self;
	Block3Data* _data3_;
	gchar** initial_projects;
	GSettings* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint initial_projects_length1;
	gint _initial_projects_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** path_collection;
	gint path_collection_length1;
	gint _path_collection_size_;
	gint path_it;
	const gchar* path;
	GeeArrayList* _tmp5_;
	const gchar* _tmp6_;
	InitialIndexRequest* _tmp7_;
	InitialIndexRequest* _tmp8_;
	GThread* _tmp9_;
	GThread* _tmp10_;
};

struct _ScratchServicesFuzzySearchIndexerProcessNextMessageAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ScratchServicesFuzzySearchIndexer* self;
	IndexerMessage* message;
	IndexerMessageType _tmp0_;
	IndexerMessageType _tmp1_;
};

struct _Block5Data {
	int _ref_count_;
	ScratchServicesFuzzySearchIndexer* self;
	ProjectUpdate* message;
	gpointer _async_data_;
};

struct _ScratchServicesFuzzySearchIndexerProcessProjectUpdateAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ScratchServicesFuzzySearchIndexer* self;
	ProjectUpdate* message;
	Block5Data* _data5_;
	ProjectUpdateType _tmp0_;
	ProjectUpdateType _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
};

struct _Block6Data {
	int _ref_count_;
	ScratchServicesFuzzySearchIndexer* self;
	ScratchServicesSearchProject* project_search;
	ProjectUpdate* message;
	gpointer _async_data_;
};

struct _ScratchServicesFuzzySearchIndexerAddDirectoryAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ScratchServicesFuzzySearchIndexer* self;
	ProjectUpdate* message;
	Block6Data* _data6_;
	gchar* path;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* project_key;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	GeeHashMap* _tmp6_;
	const gchar* _tmp7_;
	gpointer _tmp8_;
	ScratchServicesSearchProject* _tmp9_;
	const gchar* _tmp10_;
	GCancellable* _tmp11_;
};

struct _Block7Data {
	int _ref_count_;
	ScratchServicesFuzzySearchIndexer* self;
	ScratchServicesSearchProject* project_search;
	ProjectUpdate* message;
	gpointer _async_data_;
};

struct _ScratchServicesFuzzySearchIndexerAddProjectAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ScratchServicesFuzzySearchIndexer* self;
	ProjectUpdate* message;
	Block7Data* _data7_;
	gchar* path;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	ScratchServicesMonitoredRepository* monitor;
	ScratchServicesMonitoredRepository* _tmp3_;
	ScratchServicesSearchProject* _tmp4_;
	GeeHashMap* _tmp5_;
	GCancellable* _tmp6_;
};

struct _Block8Data {
	int _ref_count_;
	ScratchServicesFuzzySearchIndexer* self;
	GeeArrayList* request_queue;
	gpointer _async_data_;
};

struct _Block9Data {
	int _ref_count_;
	Block8Data * _data8_;
	InitialIndexRequest* request;
	ScratchServicesSearchProject* project_search;
};

struct _ScratchServicesFuzzySearchIndexerProcessInitialIndexingRequestsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ScratchServicesFuzzySearchIndexer* self;
	GeeArrayList* request_queue;
	GeeHashMap* project_paths;
	Block8Data* _data8_;
	gint i;
	gboolean _tmp0_;
	Block9Data* _data9_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gpointer _tmp4_;
	ScratchServicesMonitoredRepository* monitor;
	InitialIndexRequest* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	ScratchServicesMonitoredRepository* _tmp8_;
	InitialIndexRequest* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	ScratchServicesMonitoredRepository* _tmp12_;
	ScratchServicesSearchProject* _tmp13_;
	InitialIndexRequest* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	ScratchServicesSearchProject* _tmp17_;
	ScratchServicesSearchProject* _tmp18_;
	InitialIndexRequest* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	GCancellable* _tmp22_;
};

static GType indexer_message_type_id = 0;
static gint InitialIndexRequest_private_offset;
static gpointer initial_index_request_parent_class = NULL;
static IndexerMessageIface * initial_index_request_indexer_message_parent_iface = NULL;
static GType initial_index_request_type_id = 0;
static gint ProjectUpdate_private_offset;
static gpointer project_update_parent_class = NULL;
static IndexerMessageIface * project_update_indexer_message_parent_iface = NULL;
static GType project_update_type_id = 0;
static gint ScratchServicesFuzzySearchIndexer_private_offset;
static gpointer scratch_services_fuzzy_search_indexer_parent_class = NULL;
static GType scratch_services_fuzzy_search_indexer_type_id = 0;

static void initial_index_request_finalize (GObject * obj);
static void _vala_initial_index_request_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_initial_index_request_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static void project_update_finalize (GObject * obj);
static void _vala_project_update_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_project_update_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);
static void scratch_services_fuzzy_search_indexer_set_project_paths (ScratchServicesFuzzySearchIndexer* self,
                                                              GeeHashMap* value);
static void scratch_services_fuzzy_search_indexer_handle_opened_projects_change (ScratchServicesFuzzySearchIndexer* self);
static void _scratch_services_fuzzy_search_indexer_handle_opened_projects_change_g_settings_changed (GSettings* _sender,
                                                                                              const gchar* key,
                                                                                              gpointer self);
static void scratch_services_fuzzy_search_indexer_start_async_data_free (gpointer _data);
static gboolean scratch_services_fuzzy_search_indexer_start_async_co (ScratchServicesFuzzySearchIndexerStartAsyncData* _data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda8_ (Block3Data* _data3_);
static void scratch_services_fuzzy_search_indexer_process_initial_indexing_requests_async (ScratchServicesFuzzySearchIndexer* self,
                                                                                    GeeArrayList* request_queue,
                                                                                    GeeHashMap* project_paths,
                                                                                    GAsyncReadyCallback _callback_,
                                                                                    gpointer _user_data_);
static void scratch_services_fuzzy_search_indexer_process_initial_indexing_requests_finish (ScratchServicesFuzzySearchIndexer* self,
                                                                                     GAsyncResult* _res_);
static void _____lambda10_ (ScratchServicesFuzzySearchIndexer* self,
                     GObject* obj,
                     GAsyncResult* res);
static void ______lambda10__gasync_ready_callback (GObject* source_object,
                                            GAsyncResult* res,
                                            gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void scratch_services_fuzzy_search_indexer_process_next_message_async (ScratchServicesFuzzySearchIndexer* self,
                                                                       IndexerMessage* message,
                                                                       GAsyncReadyCallback _callback_,
                                                                       gpointer _user_data_);
static void scratch_services_fuzzy_search_indexer_process_next_message_finish (ScratchServicesFuzzySearchIndexer* self,
                                                                        GAsyncResult* _res_);
static void _____lambda16_ (Block4Data* _data4_,
                     GObject* obj,
                     GAsyncResult* res);
static void ______lambda16__gasync_ready_callback (GObject* source_object,
                                            GAsyncResult* res,
                                            gpointer self);
static gboolean _scratch_services_fuzzy_search_indexer_start_async_co_gsource_func (gpointer self);
static gpointer ___lambda8__gthread_func (gpointer self);
static void scratch_services_fuzzy_search_indexer_process_next_message_async_data_free (gpointer _data);
static gboolean scratch_services_fuzzy_search_indexer_process_next_message_async_co (ScratchServicesFuzzySearchIndexerProcessNextMessageAsyncData* _data_);
static void scratch_services_fuzzy_search_indexer_process_project_update_async (ScratchServicesFuzzySearchIndexer* self,
                                                                         ProjectUpdate* message,
                                                                         GAsyncReadyCallback _callback_,
                                                                         gpointer _user_data_);
static void scratch_services_fuzzy_search_indexer_process_project_update_finish (ScratchServicesFuzzySearchIndexer* self,
                                                                          GAsyncResult* _res_);
static void ___lambda15_ (ScratchServicesFuzzySearchIndexer* self,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda15__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void scratch_services_fuzzy_search_indexer_process_project_update_async_data_free (gpointer _data);
static gboolean scratch_services_fuzzy_search_indexer_process_project_update_async_co (ScratchServicesFuzzySearchIndexerProcessProjectUpdateAsyncData* _data_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void scratch_services_fuzzy_search_indexer_add_project_async (ScratchServicesFuzzySearchIndexer* self,
                                                              ProjectUpdate* message,
                                                              GAsyncReadyCallback _callback_,
                                                              gpointer _user_data_);
static void scratch_services_fuzzy_search_indexer_add_project_finish (ScratchServicesFuzzySearchIndexer* self,
                                                               GAsyncResult* _res_);
static void ___lambda12_ (Block5Data* _data5_,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda12__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void scratch_services_fuzzy_search_indexer_remove_project (ScratchServicesFuzzySearchIndexer* self,
                                                           ProjectUpdate* message);
static void scratch_services_fuzzy_search_indexer_add_file (ScratchServicesFuzzySearchIndexer* self,
                                                     ProjectUpdate* message);
static void scratch_services_fuzzy_search_indexer_add_directory_async (ScratchServicesFuzzySearchIndexer* self,
                                                                ProjectUpdate* message,
                                                                GAsyncReadyCallback _callback_,
                                                                gpointer _user_data_);
static void scratch_services_fuzzy_search_indexer_add_directory_finish (ScratchServicesFuzzySearchIndexer* self,
                                                                 GAsyncResult* _res_);
static void ___lambda14_ (Block5Data* _data5_,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda14__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void scratch_services_fuzzy_search_indexer_remove_file (ScratchServicesFuzzySearchIndexer* self,
                                                        ProjectUpdate* message);
static gchar* scratch_services_fuzzy_search_indexer_get_project_path_of_file (ScratchServicesFuzzySearchIndexer* self,
                                                                       const gchar* file_path);
static void scratch_services_fuzzy_search_indexer_add_directory_async_data_free (gpointer _data);
static gboolean scratch_services_fuzzy_search_indexer_add_directory_async_co (ScratchServicesFuzzySearchIndexerAddDirectoryAsyncData* _data_);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda13_ (Block6Data* _data6_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda13__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void scratch_services_fuzzy_search_indexer_add_project_async_data_free (gpointer _data);
static gboolean scratch_services_fuzzy_search_indexer_add_project_async_co (ScratchServicesFuzzySearchIndexerAddProjectAsyncData* _data_);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda11_ (Block7Data* _data7_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda11__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static void scratch_services_fuzzy_search_indexer_process_initial_indexing_requests_async_data_free (gpointer _data);
static gboolean scratch_services_fuzzy_search_indexer_process_initial_indexing_requests_async_co (ScratchServicesFuzzySearchIndexerProcessInitialIndexingRequestsAsyncData* _data_);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void _____lambda9_ (Block9Data* _data9_,
                    GObject* obj,
                    GAsyncResult* res);
static void ______lambda9__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static void scratch_services_fuzzy_search_indexer_finalize (GObject * obj);
static void _vala_scratch_services_fuzzy_search_indexer_get_property (GObject * object,
                                                               guint property_id,
                                                               GValue * value,
                                                               GParamSpec * pspec);
static void _vala_scratch_services_fuzzy_search_indexer_set_property (GObject * object,
                                                               guint property_id,
                                                               const GValue * value,
                                                               GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

 G_GNUC_NO_INLINE static GType
indexer_message_type_get_type_once (void)
{
	static const GEnumValue values[] = {{INDEXER_MESSAGE_TYPE_INITIAL, "INDEXER_MESSAGE_TYPE_INITIAL", "initial"}, {INDEXER_MESSAGE_TYPE_PROJECT_UPDATE, "INDEXER_MESSAGE_TYPE_PROJECT_UPDATE", "project-update"}, {0, NULL, NULL}};
	GType indexer_message_type_type_id;
	indexer_message_type_type_id = g_enum_register_static ("IndexerMessageType", values);
	return indexer_message_type_type_id;
}

GType
indexer_message_type_get_type (void)
{
	static gsize indexer_message_type_type_id__once = 0;
	if (g_once_init_enter (&indexer_message_type_type_id__once)) {
		GType indexer_message_type_type_id;
		indexer_message_type_type_id = indexer_message_type_get_type_once ();
		g_once_init_leave (&indexer_message_type_type_id__once, indexer_message_type_type_id);
	}
	return indexer_message_type_type_id__once;
}

 G_GNUC_NO_INLINE static GType
indexer_status_get_type_once (void)
{
	static const GEnumValue values[] = {{INDEXER_STATUS_INITIALISING, "INDEXER_STATUS_INITIALISING", "initialising"}, {INDEXER_STATUS_INITIAL_PROCESSING, "INDEXER_STATUS_INITIAL_PROCESSING", "initial-processing"}, {INDEXER_STATUS_IDLE, "INDEXER_STATUS_IDLE", "idle"}, {INDEXER_STATUS_PROCESSING, "INDEXER_STATUS_PROCESSING", "processing"}, {0, NULL, NULL}};
	GType indexer_status_type_id;
	indexer_status_type_id = g_enum_register_static ("IndexerStatus", values);
	return indexer_status_type_id;
}

GType
indexer_status_get_type (void)
{
	static gsize indexer_status_type_id__once = 0;
	if (g_once_init_enter (&indexer_status_type_id__once)) {
		GType indexer_status_type_id;
		indexer_status_type_id = indexer_status_get_type_once ();
		g_once_init_leave (&indexer_status_type_id__once, indexer_status_type_id);
	}
	return indexer_status_type_id__once;
}

 G_GNUC_NO_INLINE static GType
project_update_type_get_type_once (void)
{
	static const GEnumValue values[] = {{PROJECT_UPDATE_TYPE_ADDED, "PROJECT_UPDATE_TYPE_ADDED", "added"}, {PROJECT_UPDATE_TYPE_REMOVED, "PROJECT_UPDATE_TYPE_REMOVED", "removed"}, {PROJECT_UPDATE_TYPE_FILE_CREATED, "PROJECT_UPDATE_TYPE_FILE_CREATED", "file-created"}, {PROJECT_UPDATE_TYPE_DIRECTORY_CREATED, "PROJECT_UPDATE_TYPE_DIRECTORY_CREATED", "directory-created"}, {PROJECT_UPDATE_TYPE_FILE_DELETED, "PROJECT_UPDATE_TYPE_FILE_DELETED", "file-deleted"}, {0, NULL, NULL}};
	GType project_update_type_type_id;
	project_update_type_type_id = g_enum_register_static ("ProjectUpdateType", values);
	return project_update_type_type_id;
}

GType
project_update_type_get_type (void)
{
	static gsize project_update_type_type_id__once = 0;
	if (g_once_init_enter (&project_update_type_type_id__once)) {
		GType project_update_type_type_id;
		project_update_type_type_id = project_update_type_get_type_once ();
		g_once_init_leave (&project_update_type_type_id__once, project_update_type_type_id);
	}
	return project_update_type_type_id__once;
}

IndexerMessageType
indexer_message_get_message_type (IndexerMessage* self)
{
	IndexerMessageIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = INDEXER_MESSAGE_GET_INTERFACE (self);
	if (_iface_->get_message_type) {
		return _iface_->get_message_type (self);
	}
	return 0;
}

void
indexer_message_set_message_type (IndexerMessage* self,
                                  IndexerMessageType value)
{
	IndexerMessageIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = INDEXER_MESSAGE_GET_INTERFACE (self);
	if (_iface_->set_message_type) {
		_iface_->set_message_type (self, value);
	}
}

static void
indexer_message_default_init (IndexerMessageIface * iface,
                              gpointer iface_data)
{
	g_object_interface_install_property (iface, g_param_spec_enum ("message-type", "message-type", "message-type", TYPE_INDEXER_MESSAGE_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

GType
indexer_message_get_type (void)
{
	return indexer_message_type_id;
}

GType
indexer_message_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (IndexerMessageIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) indexer_message_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	indexer_message_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "IndexerMessage", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (indexer_message_type_id, G_TYPE_OBJECT);
	return indexer_message_type_id;
}

static inline gpointer
initial_index_request_get_instance_private (InitialIndexRequest* self)
{
	return G_STRUCT_MEMBER_P (self, InitialIndexRequest_private_offset);
}

InitialIndexRequest*
initial_index_request_construct (GType object_type,
                                 const gchar* project_path)
{
	InitialIndexRequest * self = NULL;
	g_return_val_if_fail (project_path != NULL, NULL);
	self = (InitialIndexRequest*) g_object_new (object_type, "message-type", INDEXER_MESSAGE_TYPE_INITIAL, "project-path", project_path, NULL);
	return self;
}

InitialIndexRequest*
initial_index_request_new (const gchar* project_path)
{
	return initial_index_request_construct (TYPE_INITIAL_INDEX_REQUEST, project_path);
}

static IndexerMessageType
initial_index_request_real_get_message_type (IndexerMessage* base)
{
	IndexerMessageType result;
	InitialIndexRequest* self;
	self = (InitialIndexRequest*) base;
	result = self->priv->_message_type;
	return result;
}

static void
initial_index_request_real_set_message_type (IndexerMessage* base,
                                             IndexerMessageType value)
{
	InitialIndexRequest* self;
	IndexerMessageType old_value;
	self = (InitialIndexRequest*) base;
	old_value = initial_index_request_real_get_message_type (base);
	if (old_value != value) {
		self->priv->_message_type = value;
		g_object_notify_by_pspec ((GObject *) self, initial_index_request_properties[INITIAL_INDEX_REQUEST_MESSAGE_TYPE_PROPERTY]);
	}
}

const gchar*
initial_index_request_get_project_path (InitialIndexRequest* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_project_path;
	result = _tmp0_;
	return result;
}

static void
initial_index_request_set_project_path (InitialIndexRequest* self,
                                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = initial_index_request_get_project_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_project_path);
		self->priv->_project_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, initial_index_request_properties[INITIAL_INDEX_REQUEST_PROJECT_PATH_PROPERTY]);
	}
}

static void
initial_index_request_class_init (InitialIndexRequestClass * klass,
                                  gpointer klass_data)
{
	initial_index_request_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &InitialIndexRequest_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_initial_index_request_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_initial_index_request_set_property;
	G_OBJECT_CLASS (klass)->finalize = initial_index_request_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), INITIAL_INDEX_REQUEST_MESSAGE_TYPE_PROPERTY, initial_index_request_properties[INITIAL_INDEX_REQUEST_MESSAGE_TYPE_PROPERTY] = g_param_spec_enum ("message-type", "message-type", "message-type", TYPE_INDEXER_MESSAGE_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), INITIAL_INDEX_REQUEST_PROJECT_PATH_PROPERTY, initial_index_request_properties[INITIAL_INDEX_REQUEST_PROJECT_PATH_PROPERTY] = g_param_spec_string ("project-path", "project-path", "project-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
initial_index_request_indexer_message_interface_init (IndexerMessageIface * iface,
                                                      gpointer iface_data)
{
	initial_index_request_indexer_message_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_message_type = initial_index_request_real_get_message_type;
	iface->set_message_type = initial_index_request_real_set_message_type;
}

static void
initial_index_request_instance_init (InitialIndexRequest * self,
                                     gpointer klass)
{
	self->priv = initial_index_request_get_instance_private (self);
}

static void
initial_index_request_finalize (GObject * obj)
{
	InitialIndexRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_INITIAL_INDEX_REQUEST, InitialIndexRequest);
	_g_free0 (self->priv->_project_path);
	G_OBJECT_CLASS (initial_index_request_parent_class)->finalize (obj);
}

GType
initial_index_request_get_type (void)
{
	return initial_index_request_type_id;
}

GType
initial_index_request_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (InitialIndexRequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) initial_index_request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (InitialIndexRequest), 0, (GInstanceInitFunc) initial_index_request_instance_init, NULL };
	static const GInterfaceInfo indexer_message_info = { (GInterfaceInitFunc) initial_index_request_indexer_message_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	initial_index_request_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "InitialIndexRequest", &g_define_type_info, 0);
	g_type_module_add_interface (module, initial_index_request_type_id, TYPE_INDEXER_MESSAGE, &indexer_message_info);
	InitialIndexRequest_private_offset = sizeof (InitialIndexRequestPrivate);
	return initial_index_request_type_id;
}

static void
_vala_initial_index_request_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	InitialIndexRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_INITIAL_INDEX_REQUEST, InitialIndexRequest);
	switch (property_id) {
		case INITIAL_INDEX_REQUEST_MESSAGE_TYPE_PROPERTY:
		g_value_set_enum (value, indexer_message_get_message_type ((IndexerMessage*) self));
		break;
		case INITIAL_INDEX_REQUEST_PROJECT_PATH_PROPERTY:
		g_value_set_string (value, initial_index_request_get_project_path (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_initial_index_request_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	InitialIndexRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_INITIAL_INDEX_REQUEST, InitialIndexRequest);
	switch (property_id) {
		case INITIAL_INDEX_REQUEST_MESSAGE_TYPE_PROPERTY:
		indexer_message_set_message_type ((IndexerMessage*) self, g_value_get_enum (value));
		break;
		case INITIAL_INDEX_REQUEST_PROJECT_PATH_PROPERTY:
		initial_index_request_set_project_path (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
project_update_get_instance_private (ProjectUpdate* self)
{
	return G_STRUCT_MEMBER_P (self, ProjectUpdate_private_offset);
}

ProjectUpdate*
project_update_construct (GType object_type,
                          ProjectUpdateType update_type,
                          const gchar* source_path,
                          const gchar* destination_path)
{
	ProjectUpdate * self = NULL;
	g_return_val_if_fail (source_path != NULL, NULL);
	self = (ProjectUpdate*) g_object_new (object_type, "message-type", INDEXER_MESSAGE_TYPE_PROJECT_UPDATE, "update-type", update_type, "source-path", source_path, "destination-path", destination_path, NULL);
	return self;
}

ProjectUpdate*
project_update_new (ProjectUpdateType update_type,
                    const gchar* source_path,
                    const gchar* destination_path)
{
	return project_update_construct (TYPE_PROJECT_UPDATE, update_type, source_path, destination_path);
}

static IndexerMessageType
project_update_real_get_message_type (IndexerMessage* base)
{
	IndexerMessageType result;
	ProjectUpdate* self;
	self = (ProjectUpdate*) base;
	result = self->priv->_message_type;
	return result;
}

static void
project_update_real_set_message_type (IndexerMessage* base,
                                      IndexerMessageType value)
{
	ProjectUpdate* self;
	IndexerMessageType old_value;
	self = (ProjectUpdate*) base;
	old_value = project_update_real_get_message_type (base);
	if (old_value != value) {
		self->priv->_message_type = value;
		g_object_notify_by_pspec ((GObject *) self, project_update_properties[PROJECT_UPDATE_MESSAGE_TYPE_PROPERTY]);
	}
}

ProjectUpdateType
project_update_get_update_type (ProjectUpdate* self)
{
	ProjectUpdateType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_update_type;
	return result;
}

static void
project_update_set_update_type (ProjectUpdate* self,
                                ProjectUpdateType value)
{
	ProjectUpdateType old_value;
	g_return_if_fail (self != NULL);
	old_value = project_update_get_update_type (self);
	if (old_value != value) {
		self->priv->_update_type = value;
		g_object_notify_by_pspec ((GObject *) self, project_update_properties[PROJECT_UPDATE_UPDATE_TYPE_PROPERTY]);
	}
}

const gchar*
project_update_get_source_path (ProjectUpdate* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_path;
	result = _tmp0_;
	return result;
}

static void
project_update_set_source_path (ProjectUpdate* self,
                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = project_update_get_source_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_source_path);
		self->priv->_source_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, project_update_properties[PROJECT_UPDATE_SOURCE_PATH_PROPERTY]);
	}
}

const gchar*
project_update_get_destination_path (ProjectUpdate* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_destination_path;
	result = _tmp0_;
	return result;
}

static void
project_update_set_destination_path (ProjectUpdate* self,
                                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = project_update_get_destination_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_destination_path);
		self->priv->_destination_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, project_update_properties[PROJECT_UPDATE_DESTINATION_PATH_PROPERTY]);
	}
}

const gchar*
project_update_get_project_path (ProjectUpdate* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_project_path;
	result = _tmp0_;
	return result;
}

static void
project_update_set_project_path (ProjectUpdate* self,
                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = project_update_get_project_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_project_path);
		self->priv->_project_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, project_update_properties[PROJECT_UPDATE_PROJECT_PATH_PROPERTY]);
	}
}

static void
project_update_class_init (ProjectUpdateClass * klass,
                           gpointer klass_data)
{
	project_update_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ProjectUpdate_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_project_update_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_project_update_set_property;
	G_OBJECT_CLASS (klass)->finalize = project_update_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PROJECT_UPDATE_MESSAGE_TYPE_PROPERTY, project_update_properties[PROJECT_UPDATE_MESSAGE_TYPE_PROPERTY] = g_param_spec_enum ("message-type", "message-type", "message-type", TYPE_INDEXER_MESSAGE_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PROJECT_UPDATE_UPDATE_TYPE_PROPERTY, project_update_properties[PROJECT_UPDATE_UPDATE_TYPE_PROPERTY] = g_param_spec_enum ("update-type", "update-type", "update-type", TYPE_PROJECT_UPDATE_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PROJECT_UPDATE_SOURCE_PATH_PROPERTY, project_update_properties[PROJECT_UPDATE_SOURCE_PATH_PROPERTY] = g_param_spec_string ("source-path", "source-path", "source-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PROJECT_UPDATE_DESTINATION_PATH_PROPERTY, project_update_properties[PROJECT_UPDATE_DESTINATION_PATH_PROPERTY] = g_param_spec_string ("destination-path", "destination-path", "destination-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PROJECT_UPDATE_PROJECT_PATH_PROPERTY, project_update_properties[PROJECT_UPDATE_PROJECT_PATH_PROPERTY] = g_param_spec_string ("project-path", "project-path", "project-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
project_update_indexer_message_interface_init (IndexerMessageIface * iface,
                                               gpointer iface_data)
{
	project_update_indexer_message_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_message_type = project_update_real_get_message_type;
	iface->set_message_type = project_update_real_set_message_type;
}

static void
project_update_instance_init (ProjectUpdate * self,
                              gpointer klass)
{
	self->priv = project_update_get_instance_private (self);
}

static void
project_update_finalize (GObject * obj)
{
	ProjectUpdate * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROJECT_UPDATE, ProjectUpdate);
	_g_free0 (self->priv->_source_path);
	_g_free0 (self->priv->_destination_path);
	_g_free0 (self->priv->_project_path);
	G_OBJECT_CLASS (project_update_parent_class)->finalize (obj);
}

GType
project_update_get_type (void)
{
	return project_update_type_id;
}

GType
project_update_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (ProjectUpdateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) project_update_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ProjectUpdate), 0, (GInstanceInitFunc) project_update_instance_init, NULL };
	static const GInterfaceInfo indexer_message_info = { (GInterfaceInitFunc) project_update_indexer_message_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	project_update_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "ProjectUpdate", &g_define_type_info, 0);
	g_type_module_add_interface (module, project_update_type_id, TYPE_INDEXER_MESSAGE, &indexer_message_info);
	ProjectUpdate_private_offset = sizeof (ProjectUpdatePrivate);
	return project_update_type_id;
}

static void
_vala_project_update_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	ProjectUpdate * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PROJECT_UPDATE, ProjectUpdate);
	switch (property_id) {
		case PROJECT_UPDATE_MESSAGE_TYPE_PROPERTY:
		g_value_set_enum (value, indexer_message_get_message_type ((IndexerMessage*) self));
		break;
		case PROJECT_UPDATE_UPDATE_TYPE_PROPERTY:
		g_value_set_enum (value, project_update_get_update_type (self));
		break;
		case PROJECT_UPDATE_SOURCE_PATH_PROPERTY:
		g_value_set_string (value, project_update_get_source_path (self));
		break;
		case PROJECT_UPDATE_DESTINATION_PATH_PROPERTY:
		g_value_set_string (value, project_update_get_destination_path (self));
		break;
		case PROJECT_UPDATE_PROJECT_PATH_PROPERTY:
		g_value_set_string (value, project_update_get_project_path (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_project_update_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	ProjectUpdate * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PROJECT_UPDATE, ProjectUpdate);
	switch (property_id) {
		case PROJECT_UPDATE_MESSAGE_TYPE_PROPERTY:
		indexer_message_set_message_type ((IndexerMessage*) self, g_value_get_enum (value));
		break;
		case PROJECT_UPDATE_UPDATE_TYPE_PROPERTY:
		project_update_set_update_type (self, g_value_get_enum (value));
		break;
		case PROJECT_UPDATE_SOURCE_PATH_PROPERTY:
		project_update_set_source_path (self, g_value_get_string (value));
		break;
		case PROJECT_UPDATE_DESTINATION_PATH_PROPERTY:
		project_update_set_destination_path (self, g_value_get_string (value));
		break;
		case PROJECT_UPDATE_PROJECT_PATH_PROPERTY:
		project_update_set_project_path (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
scratch_services_fuzzy_search_indexer_get_instance_private (ScratchServicesFuzzySearchIndexer* self)
{
	return G_STRUCT_MEMBER_P (self, ScratchServicesFuzzySearchIndexer_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_scratch_services_fuzzy_search_indexer_handle_opened_projects_change_g_settings_changed (GSettings* _sender,
                                                                                         const gchar* key,
                                                                                         gpointer self)
{
	scratch_services_fuzzy_search_indexer_handle_opened_projects_change ((ScratchServicesFuzzySearchIndexer*) self);
}

ScratchServicesFuzzySearchIndexer*
scratch_services_fuzzy_search_indexer_construct (GType object_type,
                                                 GCancellable* cancellable)
{
	ScratchServicesFuzzySearchIndexer * self = NULL;
	GCancellable* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeConcurrentList* _tmp2_;
	GeeHashMap* _tmp3_;
	GeeHashMap* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	g_return_val_if_fail (cancellable != NULL, NULL);
	self = (ScratchServicesFuzzySearchIndexer*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp0_;
	self->priv->status = INDEXER_STATUS_INITIALISING;
	_tmp1_ = gee_array_list_new (TYPE_INITIAL_INDEX_REQUEST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->initial_indexing_queue);
	self->priv->initial_indexing_queue = _tmp1_;
	_tmp2_ = gee_concurrent_list_new (TYPE_INDEXER_MESSAGE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->processing_queue);
	self->priv->processing_queue = _tmp2_;
	_tmp3_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, SCRATCH_SERVICES_TYPE_SEARCH_PROJECT, (GBoxedCopyFunc) scratch_services_search_project_ref, (GDestroyNotify) scratch_services_search_project_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_tmp4_ = _tmp3_;
	scratch_services_fuzzy_search_indexer_set_project_paths (self, _tmp4_);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = g_settings_new ("io.elementary.code.folder-manager");
	_g_object_unref0 (self->priv->folder_settings);
	self->priv->folder_settings = _tmp5_;
	_tmp6_ = self->priv->folder_settings;
	g_signal_connect_object (_tmp6_, "changed::opened-folders", (GCallback) _scratch_services_fuzzy_search_indexer_handle_opened_projects_change_g_settings_changed, self, 0);
	return self;
}

ScratchServicesFuzzySearchIndexer*
scratch_services_fuzzy_search_indexer_new (GCancellable* cancellable)
{
	return scratch_services_fuzzy_search_indexer_construct (SCRATCH_SERVICES_TYPE_FUZZY_SEARCH_INDEXER, cancellable);
}

void
scratch_services_fuzzy_search_indexer_handle_folder_item_change (ScratchServicesFuzzySearchIndexer* self,
                                                                 GFile* source,
                                                                 GFile* dest,
                                                                 GFileMonitorEvent event)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	switch (event) {
		case G_FILE_MONITOR_EVENT_CREATED:
		{
			gchar* path = NULL;
			gchar* _tmp0_;
			gboolean is_directory = FALSE;
			const gchar* _tmp1_;
			ProjectUpdateType _tmp2_ = 0;
			ProjectUpdate* project_update = NULL;
			const gchar* _tmp3_;
			ProjectUpdate* _tmp4_;
			GeeConcurrentList* _tmp5_;
			ProjectUpdate* _tmp6_;
			_tmp0_ = g_file_get_path (source);
			path = _tmp0_;
			_tmp1_ = path;
			is_directory = g_file_test (_tmp1_, G_FILE_TEST_IS_DIR);
			if (is_directory) {
				_tmp2_ = PROJECT_UPDATE_TYPE_DIRECTORY_CREATED;
			} else {
				_tmp2_ = PROJECT_UPDATE_TYPE_FILE_CREATED;
			}
			_tmp3_ = path;
			_tmp4_ = project_update_new (_tmp2_, _tmp3_, NULL);
			project_update = _tmp4_;
			_tmp5_ = self->priv->processing_queue;
			_tmp6_ = project_update;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, (IndexerMessage*) _tmp6_);
			_g_object_unref0 (project_update);
			_g_free0 (path);
			break;
		}
		case G_FILE_MONITOR_EVENT_DELETED:
		{
			gchar* path = NULL;
			gchar* _tmp7_;
			ProjectUpdate* project_update = NULL;
			const gchar* _tmp8_;
			ProjectUpdate* _tmp9_;
			GeeConcurrentList* _tmp10_;
			ProjectUpdate* _tmp11_;
			_tmp7_ = g_file_get_path (source);
			path = _tmp7_;
			_tmp8_ = path;
			_tmp9_ = project_update_new (PROJECT_UPDATE_TYPE_FILE_DELETED, _tmp8_, NULL);
			project_update = _tmp9_;
			_tmp10_ = self->priv->processing_queue;
			_tmp11_ = project_update;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, (IndexerMessage*) _tmp11_);
			_g_object_unref0 (project_update);
			_g_free0 (path);
			break;
		}
		default:
		{
			break;
		}
	}
}

static void
scratch_services_fuzzy_search_indexer_start_async_data_free (gpointer _data)
{
	ScratchServicesFuzzySearchIndexerStartAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ScratchServicesFuzzySearchIndexerStartAsyncData, _data_);
}

void
scratch_services_fuzzy_search_indexer_start_async (ScratchServicesFuzzySearchIndexer* self,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_)
{
	ScratchServicesFuzzySearchIndexerStartAsyncData* _data_;
	ScratchServicesFuzzySearchIndexer* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (ScratchServicesFuzzySearchIndexerStartAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, scratch_services_fuzzy_search_indexer_start_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	scratch_services_fuzzy_search_indexer_start_async_co (_data_);
}

void
scratch_services_fuzzy_search_indexer_start_finish (ScratchServicesFuzzySearchIndexer* self,
                                                    GAsyncResult* _res_)
{
	ScratchServicesFuzzySearchIndexerStartAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		ScratchServicesFuzzySearchIndexer* self;
		self = _data3_->self;
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
_____lambda10_ (ScratchServicesFuzzySearchIndexer* self,
                GObject* obj,
                GAsyncResult* res)
{
	g_return_if_fail (res != NULL);
	scratch_services_fuzzy_search_indexer_process_initial_indexing_requests_finish (self, res);
	self->priv->status = INDEXER_STATUS_IDLE;
}

static void
______lambda10__gasync_ready_callback (GObject* source_object,
                                       GAsyncResult* res,
                                       gpointer self)
{
	_____lambda10_ ((ScratchServicesFuzzySearchIndexer*) self, source_object, res);
	g_object_unref (self);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		ScratchServicesFuzzySearchIndexer* self;
		self = _data4_->_data3_->self;
		_g_object_unref0 (_data4_->first_item);
		block3_data_unref (_data4_->_data3_);
		_data4_->_data3_ = NULL;
		g_slice_free (Block4Data, _data4_);
	}
}

static void
_____lambda16_ (Block4Data* _data4_,
                GObject* obj,
                GAsyncResult* res)
{
	Block3Data* _data3_;
	ScratchServicesFuzzySearchIndexer* self;
	GeeConcurrentList* _tmp0_;
	IndexerMessage* _tmp1_;
	_data3_ = _data4_->_data3_;
	self = _data3_->self;
	g_return_if_fail (res != NULL);
	scratch_services_fuzzy_search_indexer_process_next_message_finish (self, res);
	_tmp0_ = self->priv->processing_queue;
	_tmp1_ = _data4_->first_item;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, _tmp1_);
	self->priv->status = INDEXER_STATUS_IDLE;
	g_debug ("fuzzy-search-indexer.vala:146: Find Project Files: Indexer is now idle" \
"!");
}

static void
______lambda16__gasync_ready_callback (GObject* source_object,
                                       GAsyncResult* res,
                                       gpointer self)
{
	_____lambda16_ (self, source_object, res);
	block4_data_unref (self);
}

static gboolean
_scratch_services_fuzzy_search_indexer_start_async_co_gsource_func (gpointer self)
{
	gboolean result;
	result = scratch_services_fuzzy_search_indexer_start_async_co (self);
	return result;
}

static void
__lambda8_ (Block3Data* _data3_)
{
	ScratchServicesFuzzySearchIndexer* self;
	GSettings* _tmp15_;
	guint _tmp16_;
	GQuark _tmp17_;
	self = _data3_->self;
	while (TRUE) {
		GCancellable* _tmp0_;
		_tmp0_ = self->priv->cancellable;
		if (!(g_cancellable_is_cancelled (_tmp0_) == FALSE)) {
			break;
		}
		switch (self->priv->status) {
			case INDEXER_STATUS_INITIALISING:
			{
				GeeArrayList* _tmp1_;
				gint _tmp2_;
				gint _tmp3_;
				GeeArrayList* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				_tmp1_ = self->priv->initial_indexing_queue;
				_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
				_tmp3_ = _tmp2_;
				if (_tmp3_ < 1) {
					self->priv->status = INDEXER_STATUS_IDLE;
					g_debug ("fuzzy-search-indexer.vala:120: Find Project Files: Indexer is now idle" \
"!\n");
					break;
				}
				_tmp4_ = self->priv->initial_indexing_queue;
				_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
				_tmp6_ = _tmp5_;
				if (_tmp6_ > 0) {
					GeeArrayList* _tmp7_;
					GeeHashMap* _tmp8_;
					_tmp7_ = self->priv->initial_indexing_queue;
					_tmp8_ = self->priv->_project_paths;
					scratch_services_fuzzy_search_indexer_process_initial_indexing_requests_async (self, _tmp7_, _tmp8_, ______lambda10__gasync_ready_callback, g_object_ref (self));
					self->priv->status = INDEXER_STATUS_INITIAL_PROCESSING;
					g_debug ("fuzzy-search-indexer.vala:134: Find Project Files: Indexer is now doin" \
"g initial processing!");
				}
				break;
			}
			case INDEXER_STATUS_IDLE:
			{
				GeeConcurrentList* _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				_tmp9_ = self->priv->processing_queue;
				_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
				_tmp11_ = _tmp10_;
				if (_tmp11_ > 0) {
					Block4Data* _data4_;
					GeeConcurrentList* _tmp12_;
					gpointer _tmp13_;
					IndexerMessage* _tmp14_;
					_data4_ = g_slice_new0 (Block4Data);
					_data4_->_ref_count_ = 1;
					_data4_->_data3_ = block3_data_ref (_data3_);
					_tmp12_ = self->priv->processing_queue;
					_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, 0);
					_data4_->first_item = (IndexerMessage*) _tmp13_;
					_tmp14_ = _data4_->first_item;
					scratch_services_fuzzy_search_indexer_process_next_message_async (self, _tmp14_, ______lambda16__gasync_ready_callback, block4_data_ref (_data4_));
					self->priv->status = INDEXER_STATUS_PROCESSING;
					g_debug ("fuzzy-search-indexer.vala:150: Find Project Files: Indexer now process" \
"ing!");
					block4_data_unref (_data4_);
					_data4_ = NULL;
				}
				break;
			}
			case INDEXER_STATUS_INITIAL_PROCESSING:
			case INDEXER_STATUS_PROCESSING:
			{
				break;
			}
			default:
			{
				break;
			}
		}
		g_usleep ((gulong) (1 * SECONDS_IN_MICROSECONDS));
	}
	_tmp15_ = self->priv->folder_settings;
	g_signal_parse_name ("changed::opened-folders", g_settings_get_type (), &_tmp16_, &_tmp17_, TRUE);
	g_signal_handlers_disconnect_matched (_tmp15_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp16_, _tmp17_, NULL, (GCallback) _scratch_services_fuzzy_search_indexer_handle_opened_projects_change_g_settings_changed, self);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _scratch_services_fuzzy_search_indexer_start_async_co_gsource_func, _data3_->_async_data_, NULL);
}

static gpointer
___lambda8__gthread_func (gpointer self)
{
	gpointer result;
	__lambda8_ (self);
	result = NULL;
	block3_data_unref (self);
	return result;
}

static gboolean
scratch_services_fuzzy_search_indexer_start_async_co (ScratchServicesFuzzySearchIndexerStartAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data3_ = g_slice_new0 (Block3Data);
	_data_->_data3_->_ref_count_ = 1;
	_data_->_data3_->self = g_object_ref (_data_->self);
	_data_->_data3_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->folder_settings;
	_data_->_tmp2_ = _data_->_tmp1_ = g_settings_get_strv (_data_->_tmp0_, "opened-folders");
	_data_->initial_projects = _data_->_tmp2_;
	_data_->initial_projects_length1 = _vala_array_length (_data_->_tmp1_);
	_data_->_initial_projects_size_ = _data_->initial_projects_length1;
	_data_->_tmp3_ = _data_->initial_projects;
	_data_->_tmp3__length1 = _data_->initial_projects_length1;
	if (_data_->_tmp3_ != NULL) {
		_data_->_tmp4_ = _data_->initial_projects;
		_data_->_tmp4__length1 = _data_->initial_projects_length1;
		{
			_data_->path_collection_length1 = 0;
			_data_->_path_collection_size_ = 0;
			_data_->path_collection = _data_->_tmp4_;
			_data_->path_collection_length1 = _data_->_tmp4__length1;
			for (_data_->path_it = 0; _data_->path_it < _data_->path_collection_length1; _data_->path_it = _data_->path_it + 1) {
				_data_->path = _data_->path_collection[_data_->path_it];
				{
					_data_->_tmp5_ = _data_->self->priv->initial_indexing_queue;
					_data_->_tmp6_ = _data_->path;
					_data_->_tmp7_ = initial_index_request_new (_data_->_tmp6_);
					_data_->_tmp8_ = _data_->_tmp7_;
					gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp5_, _data_->_tmp8_);
					_g_object_unref0 (_data_->_tmp8_);
				}
			}
		}
	}
	_data_->_tmp9_ = g_thread_new (NULL, ___lambda8__gthread_func, block3_data_ref (_data_->_data3_));
	_data_->_tmp10_ = _data_->_tmp9_;
	_g_thread_unref0 (_data_->_tmp10_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->initial_projects = (_vala_array_free (_data_->initial_projects, _data_->initial_projects_length1, (GDestroyNotify) g_free), NULL);
	block3_data_unref (_data_->_data3_);
	_data_->_data3_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
scratch_services_fuzzy_search_indexer_process_next_message_async_data_free (gpointer _data)
{
	ScratchServicesFuzzySearchIndexerProcessNextMessageAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->message);
	_g_object_unref0 (_data_->self);
	g_slice_free (ScratchServicesFuzzySearchIndexerProcessNextMessageAsyncData, _data_);
}

static void
scratch_services_fuzzy_search_indexer_process_next_message_async (ScratchServicesFuzzySearchIndexer* self,
                                                                  IndexerMessage* message,
                                                                  GAsyncReadyCallback _callback_,
                                                                  gpointer _user_data_)
{
	ScratchServicesFuzzySearchIndexerProcessNextMessageAsyncData* _data_;
	ScratchServicesFuzzySearchIndexer* _tmp0_;
	IndexerMessage* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_data_ = g_slice_new0 (ScratchServicesFuzzySearchIndexerProcessNextMessageAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, scratch_services_fuzzy_search_indexer_process_next_message_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (message);
	_g_object_unref0 (_data_->message);
	_data_->message = _tmp1_;
	scratch_services_fuzzy_search_indexer_process_next_message_async_co (_data_);
}

static void
scratch_services_fuzzy_search_indexer_process_next_message_finish (ScratchServicesFuzzySearchIndexer* self,
                                                                   GAsyncResult* _res_)
{
	ScratchServicesFuzzySearchIndexerProcessNextMessageAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
___lambda15_ (ScratchServicesFuzzySearchIndexer* self,
              GObject* obj,
              GAsyncResult* res)
{
	g_return_if_fail (res != NULL);
	scratch_services_fuzzy_search_indexer_process_project_update_finish (self, res);
}

static void
____lambda15__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda15_ ((ScratchServicesFuzzySearchIndexer*) self, source_object, res);
	g_object_unref (self);
}

static gboolean
scratch_services_fuzzy_search_indexer_process_next_message_async_co (ScratchServicesFuzzySearchIndexerProcessNextMessageAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = indexer_message_get_message_type (_data_->message);
	_data_->_tmp1_ = _data_->_tmp0_;
	switch (_data_->_tmp1_) {
		case INDEXER_MESSAGE_TYPE_PROJECT_UPDATE:
		{
			scratch_services_fuzzy_search_indexer_process_project_update_async (_data_->self, G_TYPE_CHECK_INSTANCE_CAST (_data_->message, TYPE_PROJECT_UPDATE, ProjectUpdate), ____lambda15__gasync_ready_callback, g_object_ref (_data_->self));
			break;
		}
		default:
		{
			break;
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
scratch_services_fuzzy_search_indexer_process_project_update_async_data_free (gpointer _data)
{
	ScratchServicesFuzzySearchIndexerProcessProjectUpdateAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ScratchServicesFuzzySearchIndexerProcessProjectUpdateAsyncData, _data_);
}

static void
scratch_services_fuzzy_search_indexer_process_project_update_async (ScratchServicesFuzzySearchIndexer* self,
                                                                    ProjectUpdate* message,
                                                                    GAsyncReadyCallback _callback_,
                                                                    gpointer _user_data_)
{
	ScratchServicesFuzzySearchIndexerProcessProjectUpdateAsyncData* _data_;
	ScratchServicesFuzzySearchIndexer* _tmp0_;
	ProjectUpdate* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_data_ = g_slice_new0 (ScratchServicesFuzzySearchIndexerProcessProjectUpdateAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, scratch_services_fuzzy_search_indexer_process_project_update_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (message);
	_g_object_unref0 (_data_->message);
	_data_->message = _tmp1_;
	scratch_services_fuzzy_search_indexer_process_project_update_async_co (_data_);
}

static void
scratch_services_fuzzy_search_indexer_process_project_update_finish (ScratchServicesFuzzySearchIndexer* self,
                                                                     GAsyncResult* _res_)
{
	ScratchServicesFuzzySearchIndexerProcessProjectUpdateAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		ScratchServicesFuzzySearchIndexer* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->message);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
___lambda12_ (Block5Data* _data5_,
              GObject* obj,
              GAsyncResult* res)
{
	ScratchServicesFuzzySearchIndexer* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	self = _data5_->self;
	g_return_if_fail (res != NULL);
	scratch_services_fuzzy_search_indexer_add_project_finish (self, res);
	_tmp0_ = project_update_get_source_path (_data5_->message);
	_tmp1_ = _tmp0_;
	g_debug ("fuzzy-search-indexer.vala:188: Find Project Files: Added project: %s", _tmp1_);
}

static void
____lambda12__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda12_ (self, source_object, res);
	block5_data_unref (self);
}

static void
___lambda14_ (Block5Data* _data5_,
              GObject* obj,
              GAsyncResult* res)
{
	ScratchServicesFuzzySearchIndexer* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	self = _data5_->self;
	g_return_if_fail (res != NULL);
	scratch_services_fuzzy_search_indexer_add_directory_finish (self, res);
	_tmp0_ = project_update_get_source_path (_data5_->message);
	_tmp1_ = _tmp0_;
	g_debug ("fuzzy-search-indexer.vala:204: Find Project Files: Added directory: %s", _tmp1_);
}

static void
____lambda14__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda14_ (self, source_object, res);
	block5_data_unref (self);
}

static gboolean
scratch_services_fuzzy_search_indexer_process_project_update_async_co (ScratchServicesFuzzySearchIndexerProcessProjectUpdateAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data5_ = g_slice_new0 (Block5Data);
	_data_->_data5_->_ref_count_ = 1;
	_data_->_data5_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data5_->message);
	_data_->_data5_->message = _data_->message;
	_data_->_data5_->_async_data_ = _data_;
	_data_->_tmp0_ = project_update_get_update_type (_data_->_data5_->message);
	_data_->_tmp1_ = _data_->_tmp0_;
	switch (_data_->_tmp1_) {
		case PROJECT_UPDATE_TYPE_ADDED:
		{
			scratch_services_fuzzy_search_indexer_add_project_async (_data_->self, _data_->_data5_->message, ____lambda12__gasync_ready_callback, block5_data_ref (_data_->_data5_));
			break;
		}
		case PROJECT_UPDATE_TYPE_REMOVED:
		{
			scratch_services_fuzzy_search_indexer_remove_project (_data_->self, _data_->_data5_->message);
			_data_->_tmp2_ = project_update_get_source_path (_data_->_data5_->message);
			_data_->_tmp3_ = _data_->_tmp2_;
			g_debug ("fuzzy-search-indexer.vala:194: Find Project Files: Removed project: %s", _data_->_tmp3_);
			break;
		}
		case PROJECT_UPDATE_TYPE_FILE_CREATED:
		{
			scratch_services_fuzzy_search_indexer_add_file (_data_->self, _data_->_data5_->message);
			_data_->_tmp4_ = project_update_get_source_path (_data_->_data5_->message);
			_data_->_tmp5_ = _data_->_tmp4_;
			g_debug ("fuzzy-search-indexer.vala:198: Find Project Files: Added file: %s", _data_->_tmp5_);
			break;
		}
		case PROJECT_UPDATE_TYPE_DIRECTORY_CREATED:
		{
			scratch_services_fuzzy_search_indexer_add_directory_async (_data_->self, _data_->_data5_->message, ____lambda14__gasync_ready_callback, block5_data_ref (_data_->_data5_));
			break;
		}
		case PROJECT_UPDATE_TYPE_FILE_DELETED:
		{
			scratch_services_fuzzy_search_indexer_remove_file (_data_->self, _data_->_data5_->message);
			_data_->_tmp6_ = project_update_get_source_path (_data_->_data5_->message);
			_data_->_tmp7_ = _data_->_tmp6_;
			g_debug ("fuzzy-search-indexer.vala:210: Find Project Files: Deleted directory: " \
"%s", _data_->_tmp7_);
			break;
		}
		default:
		break;
	}
	block5_data_unref (_data_->_data5_);
	_data_->_data5_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
scratch_services_fuzzy_search_indexer_remove_file (ScratchServicesFuzzySearchIndexer* self,
                                                   ProjectUpdate* message)
{
	gchar* path = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* project_key = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	ScratchServicesSearchProject* project_search = NULL;
	GeeHashMap* _tmp6_;
	const gchar* _tmp7_;
	gpointer _tmp8_;
	ScratchServicesSearchProject* _tmp9_;
	const gchar* _tmp10_;
	GCancellable* _tmp11_;
	GeeConcurrentList* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = project_update_get_source_path (message);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	path = _tmp2_;
	_tmp3_ = path;
	_tmp4_ = scratch_services_fuzzy_search_indexer_get_project_path_of_file (self, _tmp3_);
	project_key = _tmp4_;
	_tmp5_ = project_key;
	if (_tmp5_ == NULL) {
		_g_free0 (project_key);
		_g_free0 (path);
		return;
	}
	_tmp6_ = self->priv->_project_paths;
	_tmp7_ = project_key;
	_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp6_, _tmp7_);
	project_search = (ScratchServicesSearchProject*) _tmp8_;
	_tmp9_ = project_search;
	_tmp10_ = path;
	_tmp11_ = self->priv->cancellable;
	scratch_services_search_project_remove_file (_tmp9_, _tmp10_, _tmp11_);
	_tmp12_ = self->priv->processing_queue;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp12_, (IndexerMessage*) message);
	_scratch_services_search_project_unref0 (project_search);
	_g_free0 (project_key);
	_g_free0 (path);
}

static void
scratch_services_fuzzy_search_indexer_add_file (ScratchServicesFuzzySearchIndexer* self,
                                                ProjectUpdate* message)
{
	gchar* path = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* project_key = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	ScratchServicesSearchProject* project_search = NULL;
	GeeHashMap* _tmp6_;
	const gchar* _tmp7_;
	gpointer _tmp8_;
	ScratchServicesSearchProject* _tmp9_;
	const gchar* _tmp10_;
	GCancellable* _tmp11_;
	GeeConcurrentList* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = project_update_get_source_path (message);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	path = _tmp2_;
	_tmp3_ = path;
	_tmp4_ = scratch_services_fuzzy_search_indexer_get_project_path_of_file (self, _tmp3_);
	project_key = _tmp4_;
	_tmp5_ = project_key;
	if (_tmp5_ == NULL) {
		_g_free0 (project_key);
		_g_free0 (path);
		return;
	}
	_tmp6_ = self->priv->_project_paths;
	_tmp7_ = project_key;
	_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp6_, _tmp7_);
	project_search = (ScratchServicesSearchProject*) _tmp8_;
	_tmp9_ = project_search;
	_tmp10_ = path;
	_tmp11_ = self->priv->cancellable;
	scratch_services_search_project_add_file (_tmp9_, _tmp10_, _tmp11_);
	_tmp12_ = self->priv->processing_queue;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp12_, (IndexerMessage*) message);
	_scratch_services_search_project_unref0 (project_search);
	_g_free0 (project_key);
	_g_free0 (path);
}

static void
scratch_services_fuzzy_search_indexer_add_directory_async_data_free (gpointer _data)
{
	ScratchServicesFuzzySearchIndexerAddDirectoryAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ScratchServicesFuzzySearchIndexerAddDirectoryAsyncData, _data_);
}

static void
scratch_services_fuzzy_search_indexer_add_directory_async (ScratchServicesFuzzySearchIndexer* self,
                                                           ProjectUpdate* message,
                                                           GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_)
{
	ScratchServicesFuzzySearchIndexerAddDirectoryAsyncData* _data_;
	ScratchServicesFuzzySearchIndexer* _tmp0_;
	ProjectUpdate* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_data_ = g_slice_new0 (ScratchServicesFuzzySearchIndexerAddDirectoryAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, scratch_services_fuzzy_search_indexer_add_directory_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (message);
	_g_object_unref0 (_data_->message);
	_data_->message = _tmp1_;
	scratch_services_fuzzy_search_indexer_add_directory_async_co (_data_);
}

static void
scratch_services_fuzzy_search_indexer_add_directory_finish (ScratchServicesFuzzySearchIndexer* self,
                                                            GAsyncResult* _res_)
{
	ScratchServicesFuzzySearchIndexerAddDirectoryAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		ScratchServicesFuzzySearchIndexer* self;
		self = _data6_->self;
		_scratch_services_search_project_unref0 (_data6_->project_search);
		_g_object_unref0 (_data6_->message);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
__lambda13_ (Block6Data* _data6_,
             GObject* obj,
             GAsyncResult* res)
{
	ScratchServicesFuzzySearchIndexer* self;
	ScratchServicesSearchProject* _tmp0_;
	GeeConcurrentList* _tmp1_;
	self = _data6_->self;
	g_return_if_fail (res != NULL);
	_tmp0_ = _data6_->project_search;
	scratch_services_search_project_add_directory_finish (_tmp0_, res);
	_tmp1_ = self->priv->processing_queue;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp1_, (IndexerMessage*) _data6_->message);
}

static void
___lambda13__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda13_ (self, source_object, res);
	block6_data_unref (self);
}

static gboolean
scratch_services_fuzzy_search_indexer_add_directory_async_co (ScratchServicesFuzzySearchIndexerAddDirectoryAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data6_ = g_slice_new0 (Block6Data);
	_data_->_data6_->_ref_count_ = 1;
	_data_->_data6_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data6_->message);
	_data_->_data6_->message = _data_->message;
	_data_->_data6_->_async_data_ = _data_;
	_data_->_tmp0_ = project_update_get_source_path (_data_->_data6_->message);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = g_strdup (_data_->_tmp1_);
	_data_->path = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->path;
	_data_->_tmp4_ = scratch_services_fuzzy_search_indexer_get_project_path_of_file (_data_->self, _data_->_tmp3_);
	_data_->project_key = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->project_key;
	if (_data_->_tmp5_ == NULL) {
		_g_free0 (_data_->project_key);
		_g_free0 (_data_->path);
		block6_data_unref (_data_->_data6_);
		_data_->_data6_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->self->priv->_project_paths;
	_data_->_tmp7_ = _data_->project_key;
	_data_->_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp6_, _data_->_tmp7_);
	_data_->_data6_->project_search = (ScratchServicesSearchProject*) _data_->_tmp8_;
	_data_->_tmp9_ = _data_->_data6_->project_search;
	_data_->_tmp10_ = _data_->path;
	_data_->_tmp11_ = _data_->self->priv->cancellable;
	scratch_services_search_project_add_directory_async (_data_->_tmp9_, _data_->_tmp10_, _data_->_tmp11_, ___lambda13__gasync_ready_callback, block6_data_ref (_data_->_data6_));
	_g_free0 (_data_->project_key);
	_g_free0 (_data_->path);
	block6_data_unref (_data_->_data6_);
	_data_->_data6_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
scratch_services_fuzzy_search_indexer_add_project_async_data_free (gpointer _data)
{
	ScratchServicesFuzzySearchIndexerAddProjectAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ScratchServicesFuzzySearchIndexerAddProjectAsyncData, _data_);
}

static void
scratch_services_fuzzy_search_indexer_add_project_async (ScratchServicesFuzzySearchIndexer* self,
                                                         ProjectUpdate* message,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_)
{
	ScratchServicesFuzzySearchIndexerAddProjectAsyncData* _data_;
	ScratchServicesFuzzySearchIndexer* _tmp0_;
	ProjectUpdate* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_data_ = g_slice_new0 (ScratchServicesFuzzySearchIndexerAddProjectAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, scratch_services_fuzzy_search_indexer_add_project_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (message);
	_g_object_unref0 (_data_->message);
	_data_->message = _tmp1_;
	scratch_services_fuzzy_search_indexer_add_project_async_co (_data_);
}

static void
scratch_services_fuzzy_search_indexer_add_project_finish (ScratchServicesFuzzySearchIndexer* self,
                                                          GAsyncResult* _res_)
{
	ScratchServicesFuzzySearchIndexerAddProjectAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		ScratchServicesFuzzySearchIndexer* self;
		self = _data7_->self;
		_scratch_services_search_project_unref0 (_data7_->project_search);
		_g_object_unref0 (_data7_->message);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static void
__lambda11_ (Block7Data* _data7_,
             GObject* obj,
             GAsyncResult* res)
{
	ScratchServicesFuzzySearchIndexer* self;
	GeeConcurrentList* _tmp0_;
	self = _data7_->self;
	g_return_if_fail (res != NULL);
	scratch_services_search_project_parse_finish (_data7_->project_search, res);
	_tmp0_ = self->priv->processing_queue;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, (IndexerMessage*) _data7_->message);
}

static void
___lambda11__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda11_ (self, source_object, res);
	block7_data_unref (self);
}

static gboolean
scratch_services_fuzzy_search_indexer_add_project_async_co (ScratchServicesFuzzySearchIndexerAddProjectAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data7_ = g_slice_new0 (Block7Data);
	_data_->_data7_->_ref_count_ = 1;
	_data_->_data7_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data7_->message);
	_data_->_data7_->message = _data_->message;
	_data_->_data7_->_async_data_ = _data_;
	_data_->_tmp0_ = project_update_get_source_path (_data_->_data7_->message);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = g_strdup (_data_->_tmp1_);
	_data_->path = _data_->_tmp2_;
	_data_->_tmp3_ = scratch_services_git_manager_get_monitored_repository (_data_->path);
	_data_->monitor = _data_->_tmp3_;
	_data_->_tmp4_ = scratch_services_search_project_new (_data_->path, _data_->monitor);
	_data_->_data7_->project_search = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->self->priv->_project_paths;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp5_, _data_->path, _data_->_data7_->project_search);
	_data_->_tmp6_ = _data_->self->priv->cancellable;
	scratch_services_search_project_parse_async (_data_->_data7_->project_search, _data_->path, _data_->_tmp6_, ___lambda11__gasync_ready_callback, block7_data_ref (_data_->_data7_));
	_g_object_unref0 (_data_->monitor);
	_g_free0 (_data_->path);
	block7_data_unref (_data_->_data7_);
	_data_->_data7_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
scratch_services_fuzzy_search_indexer_remove_project (ScratchServicesFuzzySearchIndexer* self,
                                                      ProjectUpdate* message)
{
	gchar* path = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GeeHashMap* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = project_update_get_source_path (message);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	path = _tmp2_;
	_tmp3_ = self->priv->_project_paths;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp3_, path, NULL);
	_g_free0 (path);
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
scratch_services_fuzzy_search_indexer_handle_opened_projects_change (ScratchServicesFuzzySearchIndexer* self)
{
	gchar** opened_projects_array = NULL;
	GSettings* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint opened_projects_array_length1;
	gint _opened_projects_array_size_;
	GeeArrayList* opened_projects = NULL;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	GeeArrayList* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->folder_settings;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, "opened-folders");
	opened_projects_array = _tmp2_;
	opened_projects_array_length1 = _vala_array_length (_tmp1_);
	_opened_projects_array_size_ = opened_projects_array_length1;
	_tmp3_ = opened_projects_array;
	_tmp3__length1 = opened_projects_array_length1;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup1 (_tmp3_, _tmp3__length1) : _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	_tmp5_ = gee_array_list_new_wrap (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp4_, _tmp4__length1, NULL, NULL, NULL);
	opened_projects = _tmp5_;
	{
		GeeArrayList* _project_list = NULL;
		GeeArrayList* _tmp6_;
		gint _project_size = 0;
		GeeArrayList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _project_index = 0;
		_tmp6_ = opened_projects;
		_project_list = _tmp6_;
		_tmp7_ = _project_list;
		_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_project_size = _tmp9_;
		_project_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			gchar* project = NULL;
			GeeArrayList* _tmp12_;
			gpointer _tmp13_;
			GeeHashMap* _tmp14_;
			GeeSet* _tmp15_;
			GeeSet* _tmp16_;
			GeeSet* _tmp17_;
			const gchar* _tmp18_;
			gboolean _tmp19_;
			_project_index = _project_index + 1;
			_tmp10_ = _project_index;
			_tmp11_ = _project_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _project_list;
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _project_index);
			project = (gchar*) _tmp13_;
			_tmp14_ = self->priv->_project_paths;
			_tmp15_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = _tmp16_;
			_tmp18_ = project;
			_tmp19_ = gee_collection_contains ((GeeCollection*) _tmp17_, _tmp18_) == FALSE;
			_g_object_unref0 (_tmp17_);
			if (_tmp19_) {
				GeeConcurrentList* _tmp20_;
				const gchar* _tmp21_;
				ProjectUpdate* _tmp22_;
				ProjectUpdate* _tmp23_;
				_tmp20_ = self->priv->processing_queue;
				_tmp21_ = project;
				_tmp22_ = project_update_new (PROJECT_UPDATE_TYPE_ADDED, _tmp21_, NULL);
				_tmp23_ = _tmp22_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, (IndexerMessage*) _tmp23_);
				_g_object_unref0 (_tmp23_);
			}
			_g_free0 (project);
		}
	}
	{
		GeeIterator* _project_it = NULL;
		GeeHashMap* _tmp24_;
		GeeSet* _tmp25_;
		GeeSet* _tmp26_;
		GeeSet* _tmp27_;
		GeeIterator* _tmp28_;
		GeeIterator* _tmp29_;
		_tmp24_ = self->priv->_project_paths;
		_tmp25_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = _tmp26_;
		_tmp28_ = gee_iterable_iterator ((GeeIterable*) _tmp27_);
		_tmp29_ = _tmp28_;
		_g_object_unref0 (_tmp27_);
		_project_it = _tmp29_;
		while (TRUE) {
			GeeIterator* _tmp30_;
			gchar* project = NULL;
			GeeIterator* _tmp31_;
			gpointer _tmp32_;
			GeeArrayList* _tmp33_;
			const gchar* _tmp34_;
			_tmp30_ = _project_it;
			if (!gee_iterator_next (_tmp30_)) {
				break;
			}
			_tmp31_ = _project_it;
			_tmp32_ = gee_iterator_get (_tmp31_);
			project = (gchar*) _tmp32_;
			_tmp33_ = opened_projects;
			_tmp34_ = project;
			if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp33_, _tmp34_) == FALSE) {
				GeeConcurrentList* _tmp35_;
				const gchar* _tmp36_;
				ProjectUpdate* _tmp37_;
				ProjectUpdate* _tmp38_;
				_tmp35_ = self->priv->processing_queue;
				_tmp36_ = project;
				_tmp37_ = project_update_new (PROJECT_UPDATE_TYPE_REMOVED, _tmp36_, NULL);
				_tmp38_ = _tmp37_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp35_, (IndexerMessage*) _tmp38_);
				_g_object_unref0 (_tmp38_);
			}
			_g_free0 (project);
		}
		_g_object_unref0 (_project_it);
	}
	_g_object_unref0 (opened_projects);
	opened_projects_array = (_vala_array_free (opened_projects_array, opened_projects_array_length1, (GDestroyNotify) g_free), NULL);
}

static void
scratch_services_fuzzy_search_indexer_process_initial_indexing_requests_async_data_free (gpointer _data)
{
	ScratchServicesFuzzySearchIndexerProcessInitialIndexingRequestsAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->project_paths);
	_g_object_unref0 (_data_->self);
	g_slice_free (ScratchServicesFuzzySearchIndexerProcessInitialIndexingRequestsAsyncData, _data_);
}

static void
scratch_services_fuzzy_search_indexer_process_initial_indexing_requests_async (ScratchServicesFuzzySearchIndexer* self,
                                                                               GeeArrayList* request_queue,
                                                                               GeeHashMap* project_paths,
                                                                               GAsyncReadyCallback _callback_,
                                                                               gpointer _user_data_)
{
	ScratchServicesFuzzySearchIndexerProcessInitialIndexingRequestsAsyncData* _data_;
	ScratchServicesFuzzySearchIndexer* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeHashMap* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (request_queue != NULL);
	g_return_if_fail (project_paths != NULL);
	_data_ = g_slice_new0 (ScratchServicesFuzzySearchIndexerProcessInitialIndexingRequestsAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, scratch_services_fuzzy_search_indexer_process_initial_indexing_requests_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (request_queue);
	_g_object_unref0 (_data_->request_queue);
	_data_->request_queue = _tmp1_;
	_tmp2_ = _g_object_ref0 (project_paths);
	_g_object_unref0 (_data_->project_paths);
	_data_->project_paths = _tmp2_;
	scratch_services_fuzzy_search_indexer_process_initial_indexing_requests_async_co (_data_);
}

static void
scratch_services_fuzzy_search_indexer_process_initial_indexing_requests_finish (ScratchServicesFuzzySearchIndexer* self,
                                                                                GAsyncResult* _res_)
{
	ScratchServicesFuzzySearchIndexerProcessInitialIndexingRequestsAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		ScratchServicesFuzzySearchIndexer* self;
		self = _data8_->self;
		_g_object_unref0 (_data8_->request_queue);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		ScratchServicesFuzzySearchIndexer* self;
		self = _data9_->_data8_->self;
		_scratch_services_search_project_unref0 (_data9_->project_search);
		_g_object_unref0 (_data9_->request);
		block8_data_unref (_data9_->_data8_);
		_data9_->_data8_ = NULL;
		g_slice_free (Block9Data, _data9_);
	}
}

static void
_____lambda9_ (Block9Data* _data9_,
               GObject* obj,
               GAsyncResult* res)
{
	Block8Data* _data8_;
	ScratchServicesFuzzySearchIndexer* self;
	ScratchServicesSearchProject* _tmp0_;
	InitialIndexRequest* _tmp1_;
	_data8_ = _data9_->_data8_;
	self = _data8_->self;
	g_return_if_fail (res != NULL);
	_tmp0_ = _data9_->project_search;
	scratch_services_search_project_parse_finish (_tmp0_, res);
	_tmp1_ = _data9_->request;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _data8_->request_queue, _tmp1_);
}

static void
______lambda9__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	_____lambda9_ (self, source_object, res);
	block9_data_unref (self);
}

static gboolean
scratch_services_fuzzy_search_indexer_process_initial_indexing_requests_async_co (ScratchServicesFuzzySearchIndexerProcessInitialIndexingRequestsAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data8_ = g_slice_new0 (Block8Data);
	_data_->_data8_->_ref_count_ = 1;
	_data_->_data8_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data8_->request_queue);
	_data_->_data8_->request_queue = _data_->request_queue;
	_data_->_data8_->_async_data_ = _data_;
	{
		_data_->i = 0;
		{
			_data_->_tmp0_ = TRUE;
			while (TRUE) {
				_data_->_data9_ = g_slice_new0 (Block9Data);
				_data_->_data9_->_ref_count_ = 1;
				_data_->_data9_->_data8_ = block8_data_ref (_data_->_data8_);
				if (!_data_->_tmp0_) {
					_data_->_tmp1_ = _data_->i;
					_data_->i = _data_->_tmp1_ + 1;
				}
				_data_->_tmp0_ = FALSE;
				_data_->_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_data8_->request_queue);
				_data_->_tmp3_ = _data_->_tmp2_;
				if (!(_data_->i < _data_->_tmp3_)) {
					block9_data_unref (_data_->_data9_);
					_data_->_data9_ = NULL;
					break;
				}
				_data_->_tmp4_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_data8_->request_queue, _data_->i);
				_data_->_data9_->request = (InitialIndexRequest*) _data_->_tmp4_;
				_data_->_tmp5_ = _data_->_data9_->request;
				_data_->_tmp6_ = initial_index_request_get_project_path (_data_->_tmp5_);
				_data_->_tmp7_ = _data_->_tmp6_;
				_data_->_tmp8_ = scratch_services_git_manager_get_monitored_repository (_data_->_tmp7_);
				_data_->monitor = _data_->_tmp8_;
				_data_->_tmp9_ = _data_->_data9_->request;
				_data_->_tmp10_ = initial_index_request_get_project_path (_data_->_tmp9_);
				_data_->_tmp11_ = _data_->_tmp10_;
				_data_->_tmp12_ = _data_->monitor;
				_data_->_tmp13_ = scratch_services_search_project_new (_data_->_tmp11_, _data_->_tmp12_);
				_data_->_data9_->project_search = _data_->_tmp13_;
				_data_->_tmp14_ = _data_->_data9_->request;
				_data_->_tmp15_ = initial_index_request_get_project_path (_data_->_tmp14_);
				_data_->_tmp16_ = _data_->_tmp15_;
				_data_->_tmp17_ = _data_->_data9_->project_search;
				gee_abstract_map_set ((GeeAbstractMap*) _data_->project_paths, _data_->_tmp16_, _data_->_tmp17_);
				_data_->_tmp18_ = _data_->_data9_->project_search;
				_data_->_tmp19_ = _data_->_data9_->request;
				_data_->_tmp20_ = initial_index_request_get_project_path (_data_->_tmp19_);
				_data_->_tmp21_ = _data_->_tmp20_;
				_data_->_tmp22_ = _data_->self->priv->cancellable;
				scratch_services_search_project_parse_async (_data_->_tmp18_, _data_->_tmp21_, _data_->_tmp22_, ______lambda9__gasync_ready_callback, block9_data_ref (_data_->_data9_));
				_g_object_unref0 (_data_->monitor);
				block9_data_unref (_data_->_data9_);
				_data_->_data9_ = NULL;
			}
		}
	}
	block8_data_unref (_data_->_data8_);
	_data_->_data8_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
scratch_services_fuzzy_search_indexer_get_project_path_of_file (ScratchServicesFuzzySearchIndexer* self,
                                                                const gchar* file_path)
{
	GeeIterator* iter = NULL;
	GeeHashMap* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	GeeIterator* _tmp4_;
	GeeIterator* _tmp5_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file_path != NULL, NULL);
	_tmp0_ = self->priv->_project_paths;
	_tmp1_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	iter = _tmp5_;
	while (TRUE) {
		GeeIterator* _tmp6_;
		gchar* project_path = NULL;
		GeeIterator* _tmp7_;
		gpointer _tmp8_;
		const gchar* _tmp9_;
		_tmp6_ = iter;
		if (!gee_iterator_next (_tmp6_)) {
			break;
		}
		_tmp7_ = iter;
		_tmp8_ = gee_iterator_get (_tmp7_);
		project_path = (gchar*) _tmp8_;
		_tmp9_ = project_path;
		if (g_str_has_prefix (file_path, _tmp9_)) {
			result = project_path;
			_g_object_unref0 (iter);
			return result;
		}
		_g_free0 (project_path);
	}
	result = NULL;
	_g_object_unref0 (iter);
	return result;
}

GeeHashMap*
scratch_services_fuzzy_search_indexer_get_project_paths (ScratchServicesFuzzySearchIndexer* self)
{
	GeeHashMap* result;
	GeeHashMap* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_project_paths;
	result = _tmp0_;
	return result;
}

static void
scratch_services_fuzzy_search_indexer_set_project_paths (ScratchServicesFuzzySearchIndexer* self,
                                                         GeeHashMap* value)
{
	GeeHashMap* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_services_fuzzy_search_indexer_get_project_paths (self);
	if (old_value != value) {
		GeeHashMap* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_project_paths);
		self->priv->_project_paths = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_services_fuzzy_search_indexer_properties[SCRATCH_SERVICES_FUZZY_SEARCH_INDEXER_PROJECT_PATHS_PROPERTY]);
	}
}

static void
scratch_services_fuzzy_search_indexer_class_init (ScratchServicesFuzzySearchIndexerClass * klass,
                                                  gpointer klass_data)
{
	scratch_services_fuzzy_search_indexer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScratchServicesFuzzySearchIndexer_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_scratch_services_fuzzy_search_indexer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_scratch_services_fuzzy_search_indexer_set_property;
	G_OBJECT_CLASS (klass)->finalize = scratch_services_fuzzy_search_indexer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_SERVICES_FUZZY_SEARCH_INDEXER_PROJECT_PATHS_PROPERTY, scratch_services_fuzzy_search_indexer_properties[SCRATCH_SERVICES_FUZZY_SEARCH_INDEXER_PROJECT_PATHS_PROPERTY] = g_param_spec_object ("project-paths", "project-paths", "project-paths", GEE_TYPE_HASH_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
scratch_services_fuzzy_search_indexer_instance_init (ScratchServicesFuzzySearchIndexer * self,
                                                     gpointer klass)
{
	self->priv = scratch_services_fuzzy_search_indexer_get_instance_private (self);
}

static void
scratch_services_fuzzy_search_indexer_finalize (GObject * obj)
{
	ScratchServicesFuzzySearchIndexer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_SERVICES_TYPE_FUZZY_SEARCH_INDEXER, ScratchServicesFuzzySearchIndexer);
	_g_object_unref0 (self->priv->_project_paths);
	_g_object_unref0 (self->priv->initial_indexing_queue);
	_g_object_unref0 (self->priv->folder_settings);
	_g_object_unref0 (self->priv->cancellable);
	_g_object_unref0 (self->priv->processing_queue);
	G_OBJECT_CLASS (scratch_services_fuzzy_search_indexer_parent_class)->finalize (obj);
}

GType
scratch_services_fuzzy_search_indexer_get_type (void)
{
	return scratch_services_fuzzy_search_indexer_type_id;
}

GType
scratch_services_fuzzy_search_indexer_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchServicesFuzzySearchIndexerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_services_fuzzy_search_indexer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchServicesFuzzySearchIndexer), 0, (GInstanceInitFunc) scratch_services_fuzzy_search_indexer_instance_init, NULL };
	scratch_services_fuzzy_search_indexer_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "ScratchServicesFuzzySearchIndexer", &g_define_type_info, 0);
	ScratchServicesFuzzySearchIndexer_private_offset = sizeof (ScratchServicesFuzzySearchIndexerPrivate);
	return scratch_services_fuzzy_search_indexer_type_id;
}

static void
_vala_scratch_services_fuzzy_search_indexer_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec)
{
	ScratchServicesFuzzySearchIndexer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_SERVICES_TYPE_FUZZY_SEARCH_INDEXER, ScratchServicesFuzzySearchIndexer);
	switch (property_id) {
		case SCRATCH_SERVICES_FUZZY_SEARCH_INDEXER_PROJECT_PATHS_PROPERTY:
		g_value_set_object (value, scratch_services_fuzzy_search_indexer_get_project_paths (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_scratch_services_fuzzy_search_indexer_set_property (GObject * object,
                                                          guint property_id,
                                                          const GValue * value,
                                                          GParamSpec * pspec)
{
	ScratchServicesFuzzySearchIndexer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_SERVICES_TYPE_FUZZY_SEARCH_INDEXER, ScratchServicesFuzzySearchIndexer);
	switch (property_id) {
		case SCRATCH_SERVICES_FUZZY_SEARCH_INDEXER_PROJECT_PATHS_PROPERTY:
		scratch_services_fuzzy_search_indexer_set_project_paths (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

