// ----------------------------------------------------------------------------
//
//  Copyright (C) 2024 Fons Adriaensen <fons@linuxaudio.org>
//    
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// ----------------------------------------------------------------------------


#ifndef __JFWCAPT_H
#define __JFWCAPT_H


#include <stdint.h>
#include <zita-jclient.h>
#include "audiofile.h"


class Jfwcapt : public Jclient
{
public:

    Jfwcapt (const char *client_name, const char *server_name, int nchan);
    virtual ~Jfwcapt (void);

    enum {  MAXCHAN = 100 };

    int create_file (const char *fname, int fchan, const char *ftype);
    int close_file (void);

private:

    int  init ();
    void fini ();
    int  jack_process (int nframes);
    void jack_freewheel (int state);

    int         _nchan;
    int         _fchan;
    float      *_fbuff;
    Audiofile   _afile;
};


#endif
