/*
qsynth - A fluidsynth Qt GUI Interface.

   Copyright (C) 2003-2025, rncbc aka Rui Nuno Capela. All rights reserved.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 
*/

/********************************************************************************
** Form generated from reading UI file 'qsynthMainForm.ui'
**
** Created by: Qt User Interface Compiler version 6.10.2
**
** WARNING! All changes made in this file will be lost when recompiling UI file!
********************************************************************************/

#ifndef UI_QSYNTHMAINFORM_H
#define UI_QSYNTHMAINFORM_H

#include <QtCore/QVariant>
#include <QtGui/QIcon>
#include <QtWidgets/QApplication>
#include <QtWidgets/QCheckBox>
#include <QtWidgets/QComboBox>
#include <QtWidgets/QGridLayout>
#include <QtWidgets/QGroupBox>
#include <QtWidgets/QHBoxLayout>
#include <QtWidgets/QLabel>
#include <QtWidgets/QPushButton>
#include <QtWidgets/QSpacerItem>
#include <QtWidgets/QSpinBox>
#include <QtWidgets/QTabBar>
#include <QtWidgets/QToolButton>
#include <QtWidgets/QVBoxLayout>
#include <QtWidgets/QWidget>
#include "qsynthKnob.h"
#include "qsynthMeter.h"
#include "qsynthTabBar.h"

QT_BEGIN_NAMESPACE

class Ui_qsynthMainForm
{
public:
    QGridLayout *gridLayout;
    QGroupBox *GainGroupBox;
    QVBoxLayout *vboxLayout;
    QLabel *GainTextLabel;
    qsynthKnob *GainDial;
    QSpinBox *GainSpinBox;
    QPushButton *RestartPushButton;
    QGroupBox *ReverbGroupBox;
    QGridLayout *gridLayout1;
    QCheckBox *ReverbActiveCheckBox;
    QSpinBox *ReverbLevelSpinBox;
    qsynthKnob *ReverbLevelDial;
    QLabel *ReverbLevelTextLabel;
    QSpinBox *ReverbWidthSpinBox;
    QLabel *ReverbWidthTextLabel;
    qsynthKnob *ReverbWidthDial;
    QSpinBox *ReverbDampSpinBox;
    QLabel *ReverbDampTextLabel;
    qsynthKnob *ReverbDampDial;
    QSpinBox *ReverbRoomSpinBox;
    QLabel *ReverbRoomTextLabel;
    qsynthKnob *ReverbRoomDial;
    QGroupBox *ChorusGroupBox;
    QGridLayout *gridLayout2;
    QComboBox *ChorusTypeComboBox;
    QLabel *ChorusTypeTextLabel;
    QCheckBox *ChorusActiveCheckBox;
    qsynthKnob *ChorusNrDial;
    QLabel *ChorusNrTextLabel;
    QSpinBox *ChorusNrSpinBox;
    qsynthKnob *ChorusLevelDial;
    QLabel *ChorusLevelTextLabel;
    QSpinBox *ChorusLevelSpinBox;
    qsynthKnob *ChorusSpeedDial;
    QLabel *ChorusSpeedTextLabel;
    QSpinBox *ChorusSpeedSpinBox;
    qsynthKnob *ChorusDepthDial;
    QLabel *ChorusDepthTextLabel;
    QSpinBox *ChorusDepthSpinBox;
    QGroupBox *OutputGroupBox;
    QVBoxLayout *vboxLayout1;
    qsynthMeter *OutputMeter;
    QVBoxLayout *vboxLayout2;
    QPushButton *QuitPushButton;
    QPushButton *OptionsPushButton;
    QPushButton *MessagesPushButton;
    QPushButton *AboutPushButton;
    QSpacerItem *spacerItem;
    QPushButton *SystemResetPushButton;
    QPushButton *ProgramResetPushButton;
    QPushButton *SetupPushButton;
    QPushButton *ChannelsPushButton;
    QHBoxLayout *hboxLayout;
    QToolButton *NewEngineToolButton;
    qsynthTabBar *TabBar;
    QSpacerItem *spacerItem1;
    QToolButton *DeleteEngineToolButton;

    void setupUi(QWidget *qsynthMainForm)
    {
        if (qsynthMainForm->objectName().isEmpty())
            qsynthMainForm->setObjectName("qsynthMainForm");
        qsynthMainForm->resize(749, 192);
        const QIcon icon = QIcon(QString::fromUtf8(":/images/qsynth.svg"));
        qsynthMainForm->setWindowIcon(icon);
        gridLayout = new QGridLayout(qsynthMainForm);
        gridLayout->setSpacing(4);
        gridLayout->setContentsMargins(4, 4, 4, 4);
        gridLayout->setObjectName("gridLayout");
        GainGroupBox = new QGroupBox(qsynthMainForm);
        GainGroupBox->setObjectName("GainGroupBox");
        QFont font;
        font.setBold(true);
        GainGroupBox->setFont(font);
        vboxLayout = new QVBoxLayout(GainGroupBox);
        vboxLayout->setSpacing(4);
        vboxLayout->setContentsMargins(4, 4, 4, 4);
        vboxLayout->setObjectName("vboxLayout");
        GainTextLabel = new QLabel(GainGroupBox);
        GainTextLabel->setObjectName("GainTextLabel");
        QFont font1;
        font1.setBold(false);
        GainTextLabel->setFont(font1);
        GainTextLabel->setAlignment(Qt::AlignCenter);
        GainTextLabel->setWordWrap(false);

        vboxLayout->addWidget(GainTextLabel);

        GainDial = new qsynthKnob(GainGroupBox);
        GainDial->setObjectName("GainDial");
        GainDial->setFont(font1);
        GainDial->setMaximum(1000);
        GainDial->setOrientation(Qt::Horizontal);
        GainDial->setNotchTarget(20.000000000000000);
        GainDial->setNotchesVisible(true);

        vboxLayout->addWidget(GainDial);

        GainSpinBox = new QSpinBox(GainGroupBox);
        GainSpinBox->setObjectName("GainSpinBox");
        GainSpinBox->setFont(font1);
        GainSpinBox->setAlignment(Qt::AlignHCenter);
        GainSpinBox->setMaximum(1000);

        vboxLayout->addWidget(GainSpinBox);


        gridLayout->addWidget(GainGroupBox, 0, 0, 3, 1);

        RestartPushButton = new QPushButton(qsynthMainForm);
        RestartPushButton->setObjectName("RestartPushButton");
        const QIcon icon1 = QIcon(QString::fromUtf8(":/images/restart1.png"));
        RestartPushButton->setIcon(icon1);

        gridLayout->addWidget(RestartPushButton, 0, 1, 1, 1);

        ReverbGroupBox = new QGroupBox(qsynthMainForm);
        ReverbGroupBox->setObjectName("ReverbGroupBox");
        ReverbGroupBox->setFont(font);
        gridLayout1 = new QGridLayout(ReverbGroupBox);
        gridLayout1->setSpacing(4);
        gridLayout1->setContentsMargins(4, 4, 4, 4);
        gridLayout1->setObjectName("gridLayout1");
        ReverbActiveCheckBox = new QCheckBox(ReverbGroupBox);
        ReverbActiveCheckBox->setObjectName("ReverbActiveCheckBox");
        ReverbActiveCheckBox->setMinimumSize(QSize(0, 20));
        ReverbActiveCheckBox->setFont(font1);

        gridLayout1->addWidget(ReverbActiveCheckBox, 3, 0, 1, 4);

        ReverbLevelSpinBox = new QSpinBox(ReverbGroupBox);
        ReverbLevelSpinBox->setObjectName("ReverbLevelSpinBox");
        ReverbLevelSpinBox->setFont(font1);
        ReverbLevelSpinBox->setAlignment(Qt::AlignHCenter);
        ReverbLevelSpinBox->setMaximum(100);

        gridLayout1->addWidget(ReverbLevelSpinBox, 2, 3, 1, 1);

        ReverbLevelDial = new qsynthKnob(ReverbGroupBox);
        ReverbLevelDial->setObjectName("ReverbLevelDial");
        ReverbLevelDial->setFont(font1);
        ReverbLevelDial->setMaximum(100);
        ReverbLevelDial->setOrientation(Qt::Horizontal);
        ReverbLevelDial->setNotchTarget(10.000000000000000);
        ReverbLevelDial->setNotchesVisible(true);

        gridLayout1->addWidget(ReverbLevelDial, 1, 3, 1, 1);

        ReverbLevelTextLabel = new QLabel(ReverbGroupBox);
        ReverbLevelTextLabel->setObjectName("ReverbLevelTextLabel");
        ReverbLevelTextLabel->setFont(font1);
        ReverbLevelTextLabel->setAlignment(Qt::AlignCenter);
        ReverbLevelTextLabel->setWordWrap(false);

        gridLayout1->addWidget(ReverbLevelTextLabel, 0, 3, 1, 1);

        ReverbWidthSpinBox = new QSpinBox(ReverbGroupBox);
        ReverbWidthSpinBox->setObjectName("ReverbWidthSpinBox");
        ReverbWidthSpinBox->setFont(font1);
        ReverbWidthSpinBox->setAlignment(Qt::AlignHCenter);
        ReverbWidthSpinBox->setMaximum(100);

        gridLayout1->addWidget(ReverbWidthSpinBox, 2, 2, 1, 1);

        ReverbWidthTextLabel = new QLabel(ReverbGroupBox);
        ReverbWidthTextLabel->setObjectName("ReverbWidthTextLabel");
        ReverbWidthTextLabel->setFont(font1);
        ReverbWidthTextLabel->setAlignment(Qt::AlignCenter);
        ReverbWidthTextLabel->setWordWrap(false);

        gridLayout1->addWidget(ReverbWidthTextLabel, 0, 2, 1, 1);

        ReverbWidthDial = new qsynthKnob(ReverbGroupBox);
        ReverbWidthDial->setObjectName("ReverbWidthDial");
        ReverbWidthDial->setFont(font1);
        ReverbWidthDial->setMaximum(100);
        ReverbWidthDial->setOrientation(Qt::Horizontal);
        ReverbWidthDial->setNotchTarget(10.000000000000000);
        ReverbWidthDial->setNotchesVisible(true);

        gridLayout1->addWidget(ReverbWidthDial, 1, 2, 1, 1);

        ReverbDampSpinBox = new QSpinBox(ReverbGroupBox);
        ReverbDampSpinBox->setObjectName("ReverbDampSpinBox");
        ReverbDampSpinBox->setFont(font1);
        ReverbDampSpinBox->setAlignment(Qt::AlignHCenter);
        ReverbDampSpinBox->setMaximum(100);

        gridLayout1->addWidget(ReverbDampSpinBox, 2, 1, 1, 1);

        ReverbDampTextLabel = new QLabel(ReverbGroupBox);
        ReverbDampTextLabel->setObjectName("ReverbDampTextLabel");
        ReverbDampTextLabel->setFont(font1);
        ReverbDampTextLabel->setAlignment(Qt::AlignCenter);
        ReverbDampTextLabel->setWordWrap(false);

        gridLayout1->addWidget(ReverbDampTextLabel, 0, 1, 1, 1);

        ReverbDampDial = new qsynthKnob(ReverbGroupBox);
        ReverbDampDial->setObjectName("ReverbDampDial");
        ReverbDampDial->setFont(font1);
        ReverbDampDial->setMaximum(100);
        ReverbDampDial->setOrientation(Qt::Horizontal);
        ReverbDampDial->setNotchTarget(10.000000000000000);
        ReverbDampDial->setNotchesVisible(true);

        gridLayout1->addWidget(ReverbDampDial, 1, 1, 1, 1);

        ReverbRoomSpinBox = new QSpinBox(ReverbGroupBox);
        ReverbRoomSpinBox->setObjectName("ReverbRoomSpinBox");
        ReverbRoomSpinBox->setFont(font1);
        ReverbRoomSpinBox->setAlignment(Qt::AlignHCenter);
        ReverbRoomSpinBox->setMaximum(120);

        gridLayout1->addWidget(ReverbRoomSpinBox, 2, 0, 1, 1);

        ReverbRoomTextLabel = new QLabel(ReverbGroupBox);
        ReverbRoomTextLabel->setObjectName("ReverbRoomTextLabel");
        ReverbRoomTextLabel->setFont(font1);
        ReverbRoomTextLabel->setAlignment(Qt::AlignCenter);
        ReverbRoomTextLabel->setWordWrap(false);

        gridLayout1->addWidget(ReverbRoomTextLabel, 0, 0, 1, 1);

        ReverbRoomDial = new qsynthKnob(ReverbGroupBox);
        ReverbRoomDial->setObjectName("ReverbRoomDial");
        ReverbRoomDial->setFont(font1);
        ReverbRoomDial->setMaximum(120);
        ReverbRoomDial->setOrientation(Qt::Horizontal);
        ReverbRoomDial->setNotchTarget(10.000000000000000);
        ReverbRoomDial->setNotchesVisible(true);

        gridLayout1->addWidget(ReverbRoomDial, 1, 0, 1, 1);


        gridLayout->addWidget(ReverbGroupBox, 0, 2, 4, 1);

        ChorusGroupBox = new QGroupBox(qsynthMainForm);
        ChorusGroupBox->setObjectName("ChorusGroupBox");
        ChorusGroupBox->setFont(font);
        gridLayout2 = new QGridLayout(ChorusGroupBox);
        gridLayout2->setSpacing(4);
        gridLayout2->setContentsMargins(4, 4, 4, 4);
        gridLayout2->setObjectName("gridLayout2");
        ChorusTypeComboBox = new QComboBox(ChorusGroupBox);
        ChorusTypeComboBox->addItem(QString());
        ChorusTypeComboBox->addItem(QString());
        ChorusTypeComboBox->setObjectName("ChorusTypeComboBox");
        ChorusTypeComboBox->setMinimumSize(QSize(0, 20));
        ChorusTypeComboBox->setFont(font1);

        gridLayout2->addWidget(ChorusTypeComboBox, 3, 2, 1, 2);

        ChorusTypeTextLabel = new QLabel(ChorusGroupBox);
        ChorusTypeTextLabel->setObjectName("ChorusTypeTextLabel");
        ChorusTypeTextLabel->setMinimumSize(QSize(0, 20));
        ChorusTypeTextLabel->setFont(font1);
        ChorusTypeTextLabel->setAlignment(Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter);
        ChorusTypeTextLabel->setWordWrap(false);

        gridLayout2->addWidget(ChorusTypeTextLabel, 3, 1, 1, 1);

        ChorusActiveCheckBox = new QCheckBox(ChorusGroupBox);
        ChorusActiveCheckBox->setObjectName("ChorusActiveCheckBox");
        ChorusActiveCheckBox->setMinimumSize(QSize(0, 20));
        ChorusActiveCheckBox->setFont(font1);

        gridLayout2->addWidget(ChorusActiveCheckBox, 3, 0, 1, 1);

        ChorusNrDial = new qsynthKnob(ChorusGroupBox);
        ChorusNrDial->setObjectName("ChorusNrDial");
        ChorusNrDial->setFont(font1);
        ChorusNrDial->setMaximum(99);
        ChorusNrDial->setOrientation(Qt::Horizontal);
        ChorusNrDial->setNotchTarget(10.000000000000000);
        ChorusNrDial->setNotchesVisible(true);

        gridLayout2->addWidget(ChorusNrDial, 1, 0, 1, 1);

        ChorusNrTextLabel = new QLabel(ChorusGroupBox);
        ChorusNrTextLabel->setObjectName("ChorusNrTextLabel");
        ChorusNrTextLabel->setFont(font1);
        ChorusNrTextLabel->setAlignment(Qt::AlignCenter);
        ChorusNrTextLabel->setWordWrap(false);

        gridLayout2->addWidget(ChorusNrTextLabel, 0, 0, 1, 1);

        ChorusNrSpinBox = new QSpinBox(ChorusGroupBox);
        ChorusNrSpinBox->setObjectName("ChorusNrSpinBox");
        ChorusNrSpinBox->setFont(font1);
        ChorusNrSpinBox->setAlignment(Qt::AlignHCenter);
        ChorusNrSpinBox->setMaximum(99);

        gridLayout2->addWidget(ChorusNrSpinBox, 2, 0, 1, 1);

        ChorusLevelDial = new qsynthKnob(ChorusGroupBox);
        ChorusLevelDial->setObjectName("ChorusLevelDial");
        ChorusLevelDial->setFont(font1);
        ChorusLevelDial->setMaximum(100);
        ChorusLevelDial->setOrientation(Qt::Horizontal);
        ChorusLevelDial->setNotchTarget(10.000000000000000);
        ChorusLevelDial->setNotchesVisible(true);

        gridLayout2->addWidget(ChorusLevelDial, 1, 1, 1, 1);

        ChorusLevelTextLabel = new QLabel(ChorusGroupBox);
        ChorusLevelTextLabel->setObjectName("ChorusLevelTextLabel");
        ChorusLevelTextLabel->setFont(font1);
        ChorusLevelTextLabel->setAlignment(Qt::AlignCenter);
        ChorusLevelTextLabel->setWordWrap(false);

        gridLayout2->addWidget(ChorusLevelTextLabel, 0, 1, 1, 1);

        ChorusLevelSpinBox = new QSpinBox(ChorusGroupBox);
        ChorusLevelSpinBox->setObjectName("ChorusLevelSpinBox");
        ChorusLevelSpinBox->setFont(font1);
        ChorusLevelSpinBox->setAlignment(Qt::AlignHCenter);
        ChorusLevelSpinBox->setMaximum(100);

        gridLayout2->addWidget(ChorusLevelSpinBox, 2, 1, 1, 1);

        ChorusSpeedDial = new qsynthKnob(ChorusGroupBox);
        ChorusSpeedDial->setObjectName("ChorusSpeedDial");
        ChorusSpeedDial->setFont(font1);
        ChorusSpeedDial->setMinimum(30);
        ChorusSpeedDial->setMaximum(500);
        ChorusSpeedDial->setOrientation(Qt::Horizontal);
        ChorusSpeedDial->setNotchTarget(10.000000000000000);
        ChorusSpeedDial->setNotchesVisible(true);

        gridLayout2->addWidget(ChorusSpeedDial, 1, 2, 1, 1);

        ChorusSpeedTextLabel = new QLabel(ChorusGroupBox);
        ChorusSpeedTextLabel->setObjectName("ChorusSpeedTextLabel");
        ChorusSpeedTextLabel->setFont(font1);
        ChorusSpeedTextLabel->setAlignment(Qt::AlignCenter);
        ChorusSpeedTextLabel->setWordWrap(false);

        gridLayout2->addWidget(ChorusSpeedTextLabel, 0, 2, 1, 1);

        ChorusSpeedSpinBox = new QSpinBox(ChorusGroupBox);
        ChorusSpeedSpinBox->setObjectName("ChorusSpeedSpinBox");
        ChorusSpeedSpinBox->setFont(font1);
        ChorusSpeedSpinBox->setAlignment(Qt::AlignHCenter);
        ChorusSpeedSpinBox->setMinimum(30);
        ChorusSpeedSpinBox->setMaximum(500);

        gridLayout2->addWidget(ChorusSpeedSpinBox, 2, 2, 1, 1);

        ChorusDepthDial = new qsynthKnob(ChorusGroupBox);
        ChorusDepthDial->setObjectName("ChorusDepthDial");
        ChorusDepthDial->setFont(font1);
        ChorusDepthDial->setMaximum(210);
        ChorusDepthDial->setOrientation(Qt::Horizontal);
        ChorusDepthDial->setNotchTarget(10.000000000000000);
        ChorusDepthDial->setNotchesVisible(true);

        gridLayout2->addWidget(ChorusDepthDial, 1, 3, 1, 1);

        ChorusDepthTextLabel = new QLabel(ChorusGroupBox);
        ChorusDepthTextLabel->setObjectName("ChorusDepthTextLabel");
        ChorusDepthTextLabel->setFont(font1);
        ChorusDepthTextLabel->setAlignment(Qt::AlignCenter);
        ChorusDepthTextLabel->setWordWrap(false);

        gridLayout2->addWidget(ChorusDepthTextLabel, 0, 3, 1, 1);

        ChorusDepthSpinBox = new QSpinBox(ChorusGroupBox);
        ChorusDepthSpinBox->setObjectName("ChorusDepthSpinBox");
        ChorusDepthSpinBox->setFont(font1);
        ChorusDepthSpinBox->setAlignment(Qt::AlignHCenter);
        ChorusDepthSpinBox->setMaximum(210);

        gridLayout2->addWidget(ChorusDepthSpinBox, 2, 3, 1, 1);


        gridLayout->addWidget(ChorusGroupBox, 0, 3, 4, 1);

        OutputGroupBox = new QGroupBox(qsynthMainForm);
        OutputGroupBox->setObjectName("OutputGroupBox");
        vboxLayout1 = new QVBoxLayout(OutputGroupBox);
        vboxLayout1->setSpacing(4);
        vboxLayout1->setContentsMargins(4, 4, 4, 4);
        vboxLayout1->setObjectName("vboxLayout1");
        OutputMeter = new qsynthMeter(OutputGroupBox);
        OutputMeter->setObjectName("OutputMeter");

        vboxLayout1->addWidget(OutputMeter);


        gridLayout->addWidget(OutputGroupBox, 0, 4, 4, 1);

        vboxLayout2 = new QVBoxLayout();
        vboxLayout2->setSpacing(8);
        vboxLayout2->setContentsMargins(4, 4, 4, 4);
        vboxLayout2->setObjectName("vboxLayout2");
        QuitPushButton = new QPushButton(qsynthMainForm);
        QuitPushButton->setObjectName("QuitPushButton");
        const QIcon icon2 = QIcon(QString::fromUtf8(":/images/quit1.png"));
        QuitPushButton->setIcon(icon2);
        QuitPushButton->setAutoDefault(false);

        vboxLayout2->addWidget(QuitPushButton);

        OptionsPushButton = new QPushButton(qsynthMainForm);
        OptionsPushButton->setObjectName("OptionsPushButton");
        const QIcon icon3 = QIcon(QString::fromUtf8(":/images/options1.png"));
        OptionsPushButton->setIcon(icon3);
        OptionsPushButton->setAutoDefault(false);

        vboxLayout2->addWidget(OptionsPushButton);

        MessagesPushButton = new QPushButton(qsynthMainForm);
        MessagesPushButton->setObjectName("MessagesPushButton");
        const QIcon icon4 = QIcon(QString::fromUtf8(":/images/messages1.png"));
        MessagesPushButton->setIcon(icon4);
        MessagesPushButton->setCheckable(true);
        MessagesPushButton->setAutoDefault(false);

        vboxLayout2->addWidget(MessagesPushButton);

        AboutPushButton = new QPushButton(qsynthMainForm);
        AboutPushButton->setObjectName("AboutPushButton");
        const QIcon icon5 = QIcon(QString::fromUtf8(":/images/about1.png"));
        AboutPushButton->setIcon(icon5);
        AboutPushButton->setAutoDefault(false);

        vboxLayout2->addWidget(AboutPushButton);

        spacerItem = new QSpacerItem(8, 8, QSizePolicy::Policy::Minimum, QSizePolicy::Policy::Expanding);

        vboxLayout2->addItem(spacerItem);


        gridLayout->addLayout(vboxLayout2, 0, 5, 5, 1);

        SystemResetPushButton = new QPushButton(qsynthMainForm);
        SystemResetPushButton->setObjectName("SystemResetPushButton");
        const QIcon icon6 = QIcon(QString::fromUtf8(":/images/panic1.png"));
        SystemResetPushButton->setIcon(icon6);

        gridLayout->addWidget(SystemResetPushButton, 1, 1, 1, 1);

        ProgramResetPushButton = new QPushButton(qsynthMainForm);
        ProgramResetPushButton->setObjectName("ProgramResetPushButton");
        const QIcon icon7 = QIcon(QString::fromUtf8(":/images/reset1.png"));
        ProgramResetPushButton->setIcon(icon7);

        gridLayout->addWidget(ProgramResetPushButton, 2, 1, 1, 1);

        SetupPushButton = new QPushButton(qsynthMainForm);
        SetupPushButton->setObjectName("SetupPushButton");
        const QIcon icon8 = QIcon(QString::fromUtf8(":/images/setup1.png"));
        SetupPushButton->setIcon(icon8);
        SetupPushButton->setAutoDefault(false);

        gridLayout->addWidget(SetupPushButton, 3, 0, 1, 1);

        ChannelsPushButton = new QPushButton(qsynthMainForm);
        ChannelsPushButton->setObjectName("ChannelsPushButton");
        const QIcon icon9 = QIcon(QString::fromUtf8(":/images/channels1.png"));
        ChannelsPushButton->setIcon(icon9);
        ChannelsPushButton->setCheckable(true);
        ChannelsPushButton->setAutoDefault(false);

        gridLayout->addWidget(ChannelsPushButton, 3, 1, 1, 1);

        hboxLayout = new QHBoxLayout();
        hboxLayout->setSpacing(4);
        hboxLayout->setContentsMargins(0, 0, 0, 0);
        hboxLayout->setObjectName("hboxLayout");
        NewEngineToolButton = new QToolButton(qsynthMainForm);
        NewEngineToolButton->setObjectName("NewEngineToolButton");
        NewEngineToolButton->setMinimumSize(QSize(22, 22));
        NewEngineToolButton->setMaximumSize(QSize(24, 24));
        NewEngineToolButton->setFocusPolicy(Qt::NoFocus);
        const QIcon icon10 = QIcon(QString::fromUtf8(":/images/add1.png"));
        NewEngineToolButton->setIcon(icon10);

        hboxLayout->addWidget(NewEngineToolButton);

        TabBar = new qsynthTabBar(qsynthMainForm);
        TabBar->setObjectName("TabBar");
        TabBar->setFocusPolicy(Qt::StrongFocus);

        hboxLayout->addWidget(TabBar);

        spacerItem1 = new QSpacerItem(8, 8, QSizePolicy::Policy::Expanding, QSizePolicy::Policy::Minimum);

        hboxLayout->addItem(spacerItem1);

        DeleteEngineToolButton = new QToolButton(qsynthMainForm);
        DeleteEngineToolButton->setObjectName("DeleteEngineToolButton");
        DeleteEngineToolButton->setMinimumSize(QSize(22, 22));
        DeleteEngineToolButton->setMaximumSize(QSize(24, 24));
        DeleteEngineToolButton->setFocusPolicy(Qt::NoFocus);
        const QIcon icon11 = QIcon(QString::fromUtf8(":/images/remove1.png"));
        DeleteEngineToolButton->setIcon(icon11);

        hboxLayout->addWidget(DeleteEngineToolButton);


        gridLayout->addLayout(hboxLayout, 4, 0, 1, 5);

#if QT_CONFIG(shortcut)
        GainTextLabel->setBuddy(GainSpinBox);
        ReverbLevelTextLabel->setBuddy(ReverbLevelSpinBox);
        ReverbWidthTextLabel->setBuddy(ReverbWidthSpinBox);
        ReverbDampTextLabel->setBuddy(ReverbDampSpinBox);
        ReverbRoomTextLabel->setBuddy(ReverbRoomSpinBox);
        ChorusTypeTextLabel->setBuddy(ChorusTypeComboBox);
        ChorusNrTextLabel->setBuddy(ChorusNrSpinBox);
        ChorusLevelTextLabel->setBuddy(ChorusLevelSpinBox);
        ChorusSpeedTextLabel->setBuddy(ChorusSpeedSpinBox);
        ChorusDepthTextLabel->setBuddy(ChorusDepthSpinBox);
#endif // QT_CONFIG(shortcut)
        QWidget::setTabOrder(SetupPushButton, GainDial);
        QWidget::setTabOrder(GainDial, GainSpinBox);
        QWidget::setTabOrder(GainSpinBox, RestartPushButton);
        QWidget::setTabOrder(RestartPushButton, SystemResetPushButton);
        QWidget::setTabOrder(SystemResetPushButton, ProgramResetPushButton);
        QWidget::setTabOrder(ProgramResetPushButton, ChannelsPushButton);
        QWidget::setTabOrder(ChannelsPushButton, ReverbRoomDial);
        QWidget::setTabOrder(ReverbRoomDial, ReverbRoomSpinBox);
        QWidget::setTabOrder(ReverbRoomSpinBox, ReverbDampDial);
        QWidget::setTabOrder(ReverbDampDial, ReverbDampSpinBox);
        QWidget::setTabOrder(ReverbDampSpinBox, ReverbWidthDial);
        QWidget::setTabOrder(ReverbWidthDial, ReverbWidthSpinBox);
        QWidget::setTabOrder(ReverbWidthSpinBox, ReverbLevelDial);
        QWidget::setTabOrder(ReverbLevelDial, ReverbLevelSpinBox);
        QWidget::setTabOrder(ReverbLevelSpinBox, ReverbActiveCheckBox);
        QWidget::setTabOrder(ReverbActiveCheckBox, ChorusNrDial);
        QWidget::setTabOrder(ChorusNrDial, ChorusNrSpinBox);
        QWidget::setTabOrder(ChorusNrSpinBox, ChorusLevelDial);
        QWidget::setTabOrder(ChorusLevelDial, ChorusLevelSpinBox);
        QWidget::setTabOrder(ChorusLevelSpinBox, ChorusSpeedDial);
        QWidget::setTabOrder(ChorusSpeedDial, ChorusSpeedSpinBox);
        QWidget::setTabOrder(ChorusSpeedSpinBox, ChorusDepthDial);
        QWidget::setTabOrder(ChorusDepthDial, ChorusDepthSpinBox);
        QWidget::setTabOrder(ChorusDepthSpinBox, ChorusActiveCheckBox);
        QWidget::setTabOrder(ChorusActiveCheckBox, ChorusTypeComboBox);
        QWidget::setTabOrder(ChorusTypeComboBox, QuitPushButton);
        QWidget::setTabOrder(QuitPushButton, OptionsPushButton);
        QWidget::setTabOrder(OptionsPushButton, MessagesPushButton);
        QWidget::setTabOrder(MessagesPushButton, AboutPushButton);

        retranslateUi(qsynthMainForm);

        QMetaObject::connectSlotsByName(qsynthMainForm);
    } // setupUi

    void retranslateUi(QWidget *qsynthMainForm)
    {
        GainGroupBox->setTitle(QCoreApplication::translate("qsynthMainForm", "Master", nullptr));
        GainTextLabel->setText(QCoreApplication::translate("qsynthMainForm", "&Gain", nullptr));
#if QT_CONFIG(tooltip)
        GainDial->setToolTip(QCoreApplication::translate("qsynthMainForm", "Master Gain", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(tooltip)
        GainSpinBox->setToolTip(QCoreApplication::translate("qsynthMainForm", "Master Gain", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(tooltip)
        RestartPushButton->setToolTip(QCoreApplication::translate("qsynthMainForm", "Complete engine restart", nullptr));
#endif // QT_CONFIG(tooltip)
        RestartPushButton->setText(QCoreApplication::translate("qsynthMainForm", "Re&start", nullptr));
        ReverbGroupBox->setTitle(QCoreApplication::translate("qsynthMainForm", "Reverb", nullptr));
#if QT_CONFIG(tooltip)
        ReverbActiveCheckBox->setToolTip(QCoreApplication::translate("qsynthMainForm", "Reverb effect activation", nullptr));
#endif // QT_CONFIG(tooltip)
        ReverbActiveCheckBox->setText(QCoreApplication::translate("qsynthMainForm", "Ac&tive", nullptr));
#if QT_CONFIG(tooltip)
        ReverbLevelSpinBox->setToolTip(QCoreApplication::translate("qsynthMainForm", "Reverb Level", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(tooltip)
        ReverbLevelDial->setToolTip(QCoreApplication::translate("qsynthMainForm", "Reverb Level", nullptr));
#endif // QT_CONFIG(tooltip)
        ReverbLevelTextLabel->setText(QCoreApplication::translate("qsynthMainForm", "&Level", nullptr));
#if QT_CONFIG(tooltip)
        ReverbWidthSpinBox->setToolTip(QCoreApplication::translate("qsynthMainForm", "Reverb Width", nullptr));
#endif // QT_CONFIG(tooltip)
        ReverbWidthTextLabel->setText(QCoreApplication::translate("qsynthMainForm", "&Width", nullptr));
#if QT_CONFIG(tooltip)
        ReverbWidthDial->setToolTip(QCoreApplication::translate("qsynthMainForm", "Reverb Width", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(tooltip)
        ReverbDampSpinBox->setToolTip(QCoreApplication::translate("qsynthMainForm", "Reverb Damp Factor", nullptr));
#endif // QT_CONFIG(tooltip)
        ReverbDampTextLabel->setText(QCoreApplication::translate("qsynthMainForm", "D&amp", nullptr));
#if QT_CONFIG(tooltip)
        ReverbDampDial->setToolTip(QCoreApplication::translate("qsynthMainForm", "Reverb Damp Factor", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(tooltip)
        ReverbRoomSpinBox->setToolTip(QCoreApplication::translate("qsynthMainForm", "Reverb Room Size", nullptr));
#endif // QT_CONFIG(tooltip)
        ReverbRoomTextLabel->setText(QCoreApplication::translate("qsynthMainForm", "R&oom", nullptr));
#if QT_CONFIG(tooltip)
        ReverbRoomDial->setToolTip(QCoreApplication::translate("qsynthMainForm", "Reverb Room Size", nullptr));
#endif // QT_CONFIG(tooltip)
        ChorusGroupBox->setTitle(QCoreApplication::translate("qsynthMainForm", "Chorus", nullptr));
        ChorusTypeComboBox->setItemText(0, QCoreApplication::translate("qsynthMainForm", "Sine", nullptr));
        ChorusTypeComboBox->setItemText(1, QCoreApplication::translate("qsynthMainForm", "Triangle", nullptr));

#if QT_CONFIG(tooltip)
        ChorusTypeComboBox->setToolTip(QCoreApplication::translate("qsynthMainForm", "Chorus Modulation Type", nullptr));
#endif // QT_CONFIG(tooltip)
        ChorusTypeTextLabel->setText(QCoreApplication::translate("qsynthMainForm", "T&ype:", nullptr));
#if QT_CONFIG(tooltip)
        ChorusActiveCheckBox->setToolTip(QCoreApplication::translate("qsynthMainForm", "Chorus effect activation", nullptr));
#endif // QT_CONFIG(tooltip)
        ChorusActiveCheckBox->setText(QCoreApplication::translate("qsynthMainForm", "Act&ive", nullptr));
#if QT_CONFIG(tooltip)
        ChorusNrDial->setToolTip(QCoreApplication::translate("qsynthMainForm", "Number of Chorus Stages", nullptr));
#endif // QT_CONFIG(tooltip)
        ChorusNrTextLabel->setText(QCoreApplication::translate("qsynthMainForm", "&N", nullptr));
#if QT_CONFIG(tooltip)
        ChorusNrSpinBox->setToolTip(QCoreApplication::translate("qsynthMainForm", "Number of Chorus Stages", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(tooltip)
        ChorusLevelDial->setToolTip(QCoreApplication::translate("qsynthMainForm", "Chorus Level", nullptr));
#endif // QT_CONFIG(tooltip)
        ChorusLevelTextLabel->setText(QCoreApplication::translate("qsynthMainForm", "Le&vel", nullptr));
#if QT_CONFIG(tooltip)
        ChorusLevelSpinBox->setToolTip(QCoreApplication::translate("qsynthMainForm", "Chorus Level", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(tooltip)
        ChorusSpeedDial->setToolTip(QCoreApplication::translate("qsynthMainForm", "Chorus Speed (Hz)", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(tooltip)
        ChorusSpeedTextLabel->setToolTip(QCoreApplication::translate("qsynthMainForm", "Chorus Speed Hz", nullptr));
#endif // QT_CONFIG(tooltip)
        ChorusSpeedTextLabel->setText(QCoreApplication::translate("qsynthMainForm", "Spee&d", nullptr));
#if QT_CONFIG(tooltip)
        ChorusSpeedSpinBox->setToolTip(QCoreApplication::translate("qsynthMainForm", "Chorus Speed (Hz)", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(tooltip)
        ChorusDepthDial->setToolTip(QCoreApplication::translate("qsynthMainForm", "Chorus Depth (ms)", nullptr));
#endif // QT_CONFIG(tooltip)
        ChorusDepthTextLabel->setText(QCoreApplication::translate("qsynthMainForm", "Dept&h", nullptr));
#if QT_CONFIG(tooltip)
        ChorusDepthSpinBox->setToolTip(QCoreApplication::translate("qsynthMainForm", "Chorus Depth (ms)", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(tooltip)
        OutputMeter->setToolTip(QCoreApplication::translate("qsynthMainForm", "Output peak level", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(tooltip)
        QuitPushButton->setToolTip(QCoreApplication::translate("qsynthMainForm", "Quit this application", nullptr));
#endif // QT_CONFIG(tooltip)
        QuitPushButton->setText(QCoreApplication::translate("qsynthMainForm", "&Quit", nullptr));
#if QT_CONFIG(tooltip)
        OptionsPushButton->setToolTip(QCoreApplication::translate("qsynthMainForm", "Show general options dialog", nullptr));
#endif // QT_CONFIG(tooltip)
        OptionsPushButton->setText(QCoreApplication::translate("qsynthMainForm", "&Options...", nullptr));
#if QT_CONFIG(tooltip)
        MessagesPushButton->setToolTip(QCoreApplication::translate("qsynthMainForm", "Show/hide the messages log window", nullptr));
#endif // QT_CONFIG(tooltip)
        MessagesPushButton->setText(QCoreApplication::translate("qsynthMainForm", "&Messages", nullptr));
#if QT_CONFIG(tooltip)
        AboutPushButton->setToolTip(QCoreApplication::translate("qsynthMainForm", "Show information about this application", nullptr));
#endif // QT_CONFIG(tooltip)
        AboutPushButton->setText(QCoreApplication::translate("qsynthMainForm", "A&bout...", nullptr));
#if QT_CONFIG(tooltip)
        SystemResetPushButton->setToolTip(QCoreApplication::translate("qsynthMainForm", "System reset", nullptr));
#endif // QT_CONFIG(tooltip)
        SystemResetPushButton->setText(QCoreApplication::translate("qsynthMainForm", "&Panic", nullptr));
#if QT_CONFIG(tooltip)
        ProgramResetPushButton->setToolTip(QCoreApplication::translate("qsynthMainForm", "Program reset (all channels)", nullptr));
#endif // QT_CONFIG(tooltip)
        ProgramResetPushButton->setText(QCoreApplication::translate("qsynthMainForm", "&Reset", nullptr));
#if QT_CONFIG(tooltip)
        SetupPushButton->setToolTip(QCoreApplication::translate("qsynthMainForm", "Show instance settings and configuration dialog", nullptr));
#endif // QT_CONFIG(tooltip)
        SetupPushButton->setText(QCoreApplication::translate("qsynthMainForm", "Set&up...", nullptr));
#if QT_CONFIG(tooltip)
        ChannelsPushButton->setToolTip(QCoreApplication::translate("qsynthMainForm", "Show/hide the channels view window", nullptr));
#endif // QT_CONFIG(tooltip)
        ChannelsPushButton->setText(QCoreApplication::translate("qsynthMainForm", "&Channels", nullptr));
#if QT_CONFIG(tooltip)
        NewEngineToolButton->setToolTip(QCoreApplication::translate("qsynthMainForm", "Add a new engine", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(tooltip)
        TabBar->setToolTip(QCoreApplication::translate("qsynthMainForm", "Engine selector (right-click for menu)", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(tooltip)
        DeleteEngineToolButton->setToolTip(QCoreApplication::translate("qsynthMainForm", "Delete current engine", nullptr));
#endif // QT_CONFIG(tooltip)
        (void)qsynthMainForm;
    } // retranslateUi

};

namespace Ui {
    class qsynthMainForm: public Ui_qsynthMainForm {};
} // namespace Ui

QT_END_NAMESPACE

#endif // UI_QSYNTHMAINFORM_H
