// Copyright 2026 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "extensions/common/api/generated_schemas.h"

#include <algorithm>
#include <iterator>
#include <string_view>

#include "base/containers/fixed_flat_map.h"

namespace {
constexpr char kAlarms[] = R"R({"namespace":"alarms","types":[{"id":"alarms.Alarm","properties":{"name":{"name":"name","type":"string"},"scheduledTime":{"name":"scheduledTime","type":"number"},"periodInMinutes":{"optional":true,"name":"periodInMinutes","type":"number"}},"type":"object"},{"id":"alarms.AlarmCreateInfo","properties":{"when":{"optional":true,"name":"when","type":"number"},"delayInMinutes":{"optional":true,"name":"delayInMinutes","type":"number"},"periodInMinutes":{"optional":true,"name":"periodInMinutes","type":"number"}},"type":"object"}],"functions":[{"parameters":[{"name":"name","optional":true,"type":"string"},{"name":"alarmInfo","$ref":"alarms.AlarmCreateInfo"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"create","type":"function"},{"parameters":[{"name":"name","optional":true,"type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"alarm","optional":true,"$ref":"alarms.Alarm"}]},"name":"get","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"alarms","type":"array","items":{"$ref":"alarms.Alarm"}}]},"name":"getAll","type":"function"},{"parameters":[{"name":"name","optional":true,"type":"string"}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"wasCleared","type":"boolean"}]},"name":"clear","type":"function"},{"parameters":[],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"wasCleared","type":"boolean"}]},"name":"clearAll","type":"function"}],"properties":{},"events":[{"parameters":[{"name":"alarm","$ref":"alarms.Alarm"}],"name":"onAlarm","type":"function"}],"platforms":null,"deprecated":null})R";
constexpr char kDeclarativeNetRequest[] = R"R({"namespace":"declarativeNetRequest","types":[{"id":"declarativeNetRequest.ResourceType","type":"string","enum":[{"name":"main_frame"},{"name":"sub_frame"},{"name":"stylesheet"},{"name":"script"},{"name":"image"},{"name":"font"},{"name":"object"},{"name":"xmlhttprequest"},{"name":"ping"},{"name":"csp_report"},{"name":"media"},{"name":"websocket"},{"name":"webtransport"},{"name":"webbundle"},{"name":"other"}]},{"id":"declarativeNetRequest.RequestMethod","type":"string","enum":[{"name":"connect"},{"name":"delete"},{"name":"get"},{"name":"head"},{"name":"options"},{"name":"patch"},{"name":"post"},{"name":"put"},{"name":"other"}]},{"id":"declarativeNetRequest.DomainType","type":"string","enum":[{"name":"firstParty"},{"name":"thirdParty"}]},{"id":"declarativeNetRequest.HeaderOperation","type":"string","enum":[{"name":"append"},{"name":"set"},{"name":"remove"}]},{"id":"declarativeNetRequest.RuleActionType","type":"string","enum":[{"name":"block"},{"name":"redirect"},{"name":"allow"},{"name":"upgradeScheme"},{"name":"modifyHeaders"},{"name":"allowAllRequests"}]},{"id":"declarativeNetRequest.UnsupportedRegexReason","type":"string","enum":[{"name":"syntaxError"},{"name":"memoryLimitExceeded"}]},{"id":"declarativeNetRequest.Ruleset","properties":{"id":{"name":"id","type":"string"},"path":{"name":"path","type":"string"},"enabled":{"name":"enabled","type":"boolean"}},"type":"object"},{"id":"declarativeNetRequest.QueryKeyValue","properties":{"key":{"name":"key","type":"string"},"value":{"name":"value","type":"string"},"replaceOnly":{"optional":true,"name":"replaceOnly","type":"boolean"}},"type":"object"},{"id":"declarativeNetRequest.QueryTransform","properties":{"removeParams":{"optional":true,"name":"removeParams","type":"array","items":{"type":"string"}},"addOrReplaceParams":{"optional":true,"name":"addOrReplaceParams","type":"array","items":{"$ref":"declarativeNetRequest.QueryKeyValue"}}},"type":"object"},{"id":"declarativeNetRequest.URLTransform","properties":{"scheme":{"optional":true,"name":"scheme","type":"string"},"host":{"optional":true,"name":"host","type":"string"},"port":{"optional":true,"name":"port","type":"string"},"path":{"optional":true,"name":"path","type":"string"},"query":{"optional":true,"name":"query","type":"string"},"queryTransform":{"optional":true,"name":"queryTransform","$ref":"declarativeNetRequest.QueryTransform"},"fragment":{"optional":true,"name":"fragment","type":"string"},"username":{"optional":true,"name":"username","type":"string"},"password":{"optional":true,"name":"password","type":"string"}},"type":"object"},{"id":"declarativeNetRequest.Redirect","properties":{"extensionPath":{"optional":true,"name":"extensionPath","type":"string"},"transform":{"optional":true,"name":"transform","$ref":"declarativeNetRequest.URLTransform"},"url":{"optional":true,"name":"url","type":"string"},"regexSubstitution":{"optional":true,"name":"regexSubstitution","type":"string"}},"type":"object"},{"id":"declarativeNetRequest.HeaderInfo","properties":{"header":{"name":"header","type":"string"},"values":{"optional":true,"name":"values","type":"array","items":{"type":"string"}},"excludedValues":{"optional":true,"name":"excludedValues","type":"array","items":{"type":"string"}}},"type":"object"},{"id":"declarativeNetRequest.RuleCondition","properties":{"urlFilter":{"optional":true,"name":"urlFilter","type":"string"},"regexFilter":{"optional":true,"name":"regexFilter","type":"string"},"isUrlFilterCaseSensitive":{"optional":true,"name":"isUrlFilterCaseSensitive","type":"boolean"},"initiatorDomains":{"optional":true,"name":"initiatorDomains","type":"array","items":{"type":"string"}},"excludedInitiatorDomains":{"optional":true,"name":"excludedInitiatorDomains","type":"array","items":{"type":"string"}},"requestDomains":{"optional":true,"name":"requestDomains","type":"array","items":{"type":"string"}},"excludedRequestDomains":{"optional":true,"name":"excludedRequestDomains","type":"array","items":{"type":"string"}},"domains":{"deprecated":"Use $(ref:initiatorDomains) instead","optional":true,"name":"domains","type":"array","items":{"type":"string"}},"excludedDomains":{"deprecated":"Use $(ref:excludedInitiatorDomains) instead","optional":true,"name":"excludedDomains","type":"array","items":{"type":"string"}},"resourceTypes":{"optional":true,"name":"resourceTypes","type":"array","items":{"$ref":"declarativeNetRequest.ResourceType"}},"excludedResourceTypes":{"optional":true,"name":"excludedResourceTypes","type":"array","items":{"$ref":"declarativeNetRequest.ResourceType"}},"requestMethods":{"optional":true,"name":"requestMethods","type":"array","items":{"$ref":"declarativeNetRequest.RequestMethod"}},"excludedRequestMethods":{"optional":true,"name":"excludedRequestMethods","type":"array","items":{"$ref":"declarativeNetRequest.RequestMethod"}},"domainType":{"optional":true,"name":"domainType","$ref":"declarativeNetRequest.DomainType"},"tabIds":{"optional":true,"name":"tabIds","type":"array","items":{"type":"integer"}},"excludedTabIds":{"optional":true,"name":"excludedTabIds","type":"array","items":{"type":"integer"}},"responseHeaders":{"optional":true,"name":"responseHeaders","type":"array","items":{"$ref":"declarativeNetRequest.HeaderInfo"}},"excludedResponseHeaders":{"optional":true,"name":"excludedResponseHeaders","type":"array","items":{"$ref":"declarativeNetRequest.HeaderInfo"}}},"type":"object"},{"id":"declarativeNetRequest.HeaderRegexOptions","properties":{"matchAll":{"optional":true,"name":"matchAll","type":"boolean"}},"type":"object"},{"id":"declarativeNetRequest.ModifyHeaderInfo","properties":{"header":{"name":"header","type":"string"},"operation":{"name":"operation","$ref":"declarativeNetRequest.HeaderOperation"},"value":{"optional":true,"name":"value","type":"string"},"regexFilter":{"optional":true,"name":"regexFilter","type":"string"},"regexSubstitution":{"optional":true,"name":"regexSubstitution","type":"string"},"regexOptions":{"optional":true,"name":"regexOptions","$ref":"declarativeNetRequest.HeaderRegexOptions"}},"type":"object"},{"id":"declarativeNetRequest.RuleAction","properties":{"type":{"name":"type","$ref":"declarativeNetRequest.RuleActionType"},"redirect":{"optional":true,"name":"redirect","$ref":"declarativeNetRequest.Redirect"},"requestHeaders":{"optional":true,"name":"requestHeaders","type":"array","items":{"$ref":"declarativeNetRequest.ModifyHeaderInfo"}},"responseHeaders":{"optional":true,"name":"responseHeaders","type":"array","items":{"$ref":"declarativeNetRequest.ModifyHeaderInfo"}}},"type":"object"},{"id":"declarativeNetRequest.Rule","properties":{"id":{"name":"id","type":"integer"},"priority":{"optional":true,"name":"priority","type":"integer"},"condition":{"name":"condition","$ref":"declarativeNetRequest.RuleCondition"},"action":{"name":"action","$ref":"declarativeNetRequest.RuleAction"}},"type":"object"},{"id":"declarativeNetRequest.MatchedRule","properties":{"ruleId":{"name":"ruleId","type":"integer"},"rulesetId":{"name":"rulesetId","type":"string"}},"type":"object"},{"id":"declarativeNetRequest.GetRulesFilter","properties":{"ruleIds":{"optional":true,"name":"ruleIds","type":"array","items":{"type":"integer"}}},"type":"object"},{"id":"declarativeNetRequest.MatchedRuleInfo","properties":{"rule":{"name":"rule","$ref":"declarativeNetRequest.MatchedRule"},"timeStamp":{"name":"timeStamp","type":"number"},"tabId":{"name":"tabId","type":"integer"}},"type":"object"},{"id":"declarativeNetRequest.MatchedRulesFilter","properties":{"tabId":{"optional":true,"name":"tabId","type":"integer"},"minTimeStamp":{"optional":true,"name":"minTimeStamp","type":"number"}},"type":"object"},{"id":"declarativeNetRequest.RulesMatchedDetails","properties":{"rulesMatchedInfo":{"name":"rulesMatchedInfo","type":"array","items":{"$ref":"declarativeNetRequest.MatchedRuleInfo"}}},"type":"object"},{"id":"declarativeNetRequest.RequestDetails","properties":{"requestId":{"name":"requestId","type":"string"},"url":{"name":"url","type":"string"},"initiator":{"optional":true,"name":"initiator","type":"string"},"method":{"name":"method","type":"string"},"frameId":{"name":"frameId","type":"integer"},"documentId":{"optional":true,"name":"documentId","type":"str)R" R"R(ing"},"frameType":{"optional":true,"name":"frameType","$ref":"extensionTypes.FrameType"},"documentLifecycle":{"optional":true,"name":"documentLifecycle","$ref":"extensionTypes.DocumentLifecycle"},"parentFrameId":{"name":"parentFrameId","type":"integer"},"parentDocumentId":{"optional":true,"name":"parentDocumentId","type":"string"},"tabId":{"name":"tabId","type":"integer"},"type":{"name":"type","$ref":"declarativeNetRequest.ResourceType"}},"type":"object"},{"id":"declarativeNetRequest.TestMatchRequestDetails","properties":{"url":{"name":"url","type":"string"},"initiator":{"optional":true,"name":"initiator","type":"string"},"method":{"optional":true,"name":"method","$ref":"declarativeNetRequest.RequestMethod"},"type":{"name":"type","$ref":"declarativeNetRequest.ResourceType"},"tabId":{"optional":true,"name":"tabId","type":"integer"},"responseHeaders":{"optional":true,"name":"responseHeaders","type":"object","additionalProperties":{"type":"any"}}},"type":"object"},{"id":"declarativeNetRequest.MatchedRuleInfoDebug","properties":{"rule":{"name":"rule","$ref":"declarativeNetRequest.MatchedRule"},"request":{"name":"request","$ref":"declarativeNetRequest.RequestDetails"}},"type":"object"},{"id":"declarativeNetRequest.DNRInfo","properties":{"rule_resources":{"name":"rule_resources","type":"array","items":{"$ref":"declarativeNetRequest.Ruleset"}}},"type":"object"},{"id":"declarativeNetRequest.RegexOptions","properties":{"regex":{"name":"regex","type":"string"},"isCaseSensitive":{"optional":true,"name":"isCaseSensitive","type":"boolean"},"requireCapturing":{"optional":true,"name":"requireCapturing","type":"boolean"}},"type":"object"},{"id":"declarativeNetRequest.IsRegexSupportedResult","properties":{"isSupported":{"name":"isSupported","type":"boolean"},"reason":{"optional":true,"name":"reason","$ref":"declarativeNetRequest.UnsupportedRegexReason"}},"type":"object"},{"id":"declarativeNetRequest.TestMatchOutcomeResult","properties":{"matchedRules":{"name":"matchedRules","type":"array","items":{"$ref":"declarativeNetRequest.MatchedRule"}}},"type":"object"},{"id":"declarativeNetRequest.UpdateRuleOptions","properties":{"removeRuleIds":{"optional":true,"name":"removeRuleIds","type":"array","items":{"type":"integer"}},"addRules":{"optional":true,"name":"addRules","type":"array","items":{"$ref":"declarativeNetRequest.Rule"}}},"type":"object"},{"id":"declarativeNetRequest.UpdateRulesetOptions","properties":{"disableRulesetIds":{"optional":true,"name":"disableRulesetIds","type":"array","items":{"type":"string"}},"enableRulesetIds":{"optional":true,"name":"enableRulesetIds","type":"array","items":{"type":"string"}}},"type":"object"},{"id":"declarativeNetRequest.UpdateStaticRulesOptions","properties":{"rulesetId":{"name":"rulesetId","type":"string"},"disableRuleIds":{"optional":true,"name":"disableRuleIds","type":"array","items":{"type":"integer"}},"enableRuleIds":{"optional":true,"name":"enableRuleIds","type":"array","items":{"type":"integer"}}},"type":"object"},{"id":"declarativeNetRequest.GetDisabledRuleIdsOptions","properties":{"rulesetId":{"name":"rulesetId","type":"string"}},"type":"object"},{"id":"declarativeNetRequest.TabActionCountUpdate","properties":{"tabId":{"name":"tabId","type":"integer"},"increment":{"name":"increment","type":"integer"}},"type":"object"},{"id":"declarativeNetRequest.ExtensionActionOptions","properties":{"displayActionCountAsBadgeText":{"optional":true,"name":"displayActionCountAsBadgeText","type":"boolean"},"tabUpdate":{"optional":true,"name":"tabUpdate","$ref":"declarativeNetRequest.TabActionCountUpdate"}},"type":"object"}],"functions":[{"parameters":[{"name":"options","$ref":"declarativeNetRequest.UpdateRuleOptions"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"updateDynamicRules","type":"function"},{"parameters":[{"name":"filter","optional":true,"$ref":"declarativeNetRequest.GetRulesFilter"}],"returns_async":{"name":"callback","parameters":[{"name":"rules","type":"array","items":{"$ref":"declarativeNetRequest.Rule"}}]},"name":"getDynamicRules","type":"function"},{"parameters":[{"name":"options","$ref":"declarativeNetRequest.UpdateRuleOptions"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"updateSessionRules","type":"function"},{"parameters":[{"name":"filter","optional":true,"$ref":"declarativeNetRequest.GetRulesFilter"}],"returns_async":{"name":"callback","parameters":[{"name":"rules","type":"array","items":{"$ref":"declarativeNetRequest.Rule"}}]},"name":"getSessionRules","type":"function"},{"parameters":[{"name":"options","$ref":"declarativeNetRequest.UpdateRulesetOptions"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"updateEnabledRulesets","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"rulesetIds","type":"array","items":{"type":"string"}}]},"name":"getEnabledRulesets","type":"function"},{"parameters":[{"name":"options","$ref":"declarativeNetRequest.UpdateStaticRulesOptions"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"updateStaticRules","type":"function"},{"parameters":[{"name":"options","$ref":"declarativeNetRequest.GetDisabledRuleIdsOptions"}],"returns_async":{"name":"callback","parameters":[{"name":"disabledRuleIds","type":"array","items":{"type":"integer"}}]},"name":"getDisabledRuleIds","type":"function"},{"parameters":[{"name":"filter","optional":true,"$ref":"declarativeNetRequest.MatchedRulesFilter"}],"returns_async":{"name":"callback","parameters":[{"name":"details","$ref":"declarativeNetRequest.RulesMatchedDetails"}]},"name":"getMatchedRules","type":"function"},{"parameters":[{"name":"options","$ref":"declarativeNetRequest.ExtensionActionOptions"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"setExtensionActionOptions","type":"function"},{"parameters":[{"name":"regexOptions","$ref":"declarativeNetRequest.RegexOptions"}],"returns_async":{"name":"callback","parameters":[{"name":"result","$ref":"declarativeNetRequest.IsRegexSupportedResult"}]},"name":"isRegexSupported","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"count","type":"integer"}]},"name":"getAvailableStaticRuleCount","type":"function"},{"parameters":[{"name":"request","$ref":"declarativeNetRequest.TestMatchRequestDetails"}],"returns_async":{"name":"callback","parameters":[{"name":"result","$ref":"declarativeNetRequest.TestMatchOutcomeResult"}]},"name":"testMatchOutcome","type":"function"}],"properties":{"GUARANTEED_MINIMUM_STATIC_RULES":{"type":"integer","value":30000},"MAX_NUMBER_OF_DYNAMIC_AND_SESSION_RULES":{"deprecated":"There is no longer a combined limit. See $(ref:MAX_NUMBER_OF_DYNAMIC_RULES) and $(ref:MAX_NUMBER_OF_SESSION_RULES).","type":"integer","value":5000},"MAX_NUMBER_OF_DYNAMIC_RULES":{"type":"integer","value":30000},"MAX_NUMBER_OF_UNSAFE_DYNAMIC_RULES":{"type":"integer","value":5000},"MAX_NUMBER_OF_SESSION_RULES":{"type":"integer","value":5000},"MAX_NUMBER_OF_UNSAFE_SESSION_RULES":{"type":"integer","value":5000},"GETMATCHEDRULES_QUOTA_INTERVAL":{"type":"integer","value":10},"MAX_GETMATCHEDRULES_CALLS_PER_INTERVAL":{"type":"integer","value":20},"MAX_NUMBER_OF_REGEX_RULES":{"type":"integer","value":1000},"MAX_NUMBER_OF_STATIC_RULESETS":{"type":"integer","value":100},"MAX_NUMBER_OF_ENABLED_STATIC_RULESETS":{"type":"integer","value":50},"DYNAMIC_RULESET_ID":{"type":"string","value":"_dynamic"},"SESSION_RULESET_ID":{"type":"string","value":"_session"}},"events":[{"parameters":[{"name":"info","$ref":"declarativeNetRequest.MatchedRuleInfoDebug"}],"name":"onRuleMatchedDebug","type":"function"}],"platforms":null,"deprecated":null})R";
constexpr char kExtensionTypes[] = R"R({"namespace":"extensionTypes","types":[{"id":"extensionTypes.ImageFormat","type":"string","enum":["jpeg","png"]},{"id":"extensionTypes.ImageDetails","type":"object","properties":{"format":{"$ref":"extensionTypes.ImageFormat","optional":true},"quality":{"type":"integer","optional":true,"minimum":0,"maximum":100}}},{"id":"extensionTypes.RunAt","type":"string","enum":[{"name":"document_start"},{"name":"document_end"},{"name":"document_idle"}]},{"id":"extensionTypes.CSSOrigin","type":"string","enum":["author","user"]},{"id":"extensionTypes.InjectDetails","type":"object","properties":{"code":{"type":"string","optional":true},"file":{"type":"string","optional":true},"allFrames":{"type":"boolean","optional":true},"frameId":{"type":"integer","optional":true,"minimum":0},"matchAboutBlank":{"type":"boolean","optional":true},"runAt":{"$ref":"extensionTypes.RunAt","optional":true},"cssOrigin":{"$ref":"extensionTypes.CSSOrigin","optional":true}}},{"id":"extensionTypes.DeleteInjectionDetails","type":"object","properties":{"code":{"type":"string","optional":true},"file":{"type":"string","optional":true},"allFrames":{"type":"boolean","optional":true},"frameId":{"type":"integer","optional":true,"minimum":0},"matchAboutBlank":{"type":"boolean","optional":true},"cssOrigin":{"$ref":"extensionTypes.CSSOrigin","optional":true}}},{"id":"extensionTypes.FrameType","type":"string","enum":["outermost_frame","fenced_frame","sub_frame"]},{"id":"extensionTypes.DocumentLifecycle","type":"string","enum":["prerender","active","cached","pending_deletion"]},{"id":"extensionTypes.ExecutionWorld","type":"string","enum":["ISOLATED","MAIN","USER_SCRIPT"]}]})R";
constexpr char kI18n[] = R"R({"namespace":"i18n","types":[{"id":"i18n.LanguageCode","type":"string"}],"functions":[{"name":"getAcceptLanguages","type":"function","parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"languages","type":"array","items":{"$ref":"i18n.LanguageCode"}}]}},{"name":"getMessage","type":"function","parameters":[{"type":"string","name":"messageName"},{"type":"any","name":"substitutions","optional":true},{"type":"object","name":"options","optional":true,"properties":{"escapeLt":{"type":"boolean","optional":true}}}],"returns":{"type":"string"}},{"name":"getUILanguage","type":"function","parameters":[],"returns":{"type":"string"}},{"name":"detectLanguage","type":"function","parameters":[{"type":"string","name":"text","minimum":0}],"returns_async":{"name":"callback","parameters":[{"type":"object","name":"result","properties":{"isReliable":{"type":"boolean"},"languages":{"type":"array","items":{"type":"object","properties":{"language":{"$ref":"i18n.LanguageCode"},"percentage":{"type":"integer"}}}}}}]}}],"events":[]})R";
constexpr char kIdle[] = R"R({"namespace":"idle","types":[{"id":"idle.IdleState","type":"string","enum":["active","idle","locked"]}],"functions":[{"name":"queryState","type":"function","parameters":[{"name":"detectionIntervalInSeconds","type":"integer","minimum":15}],"returns_async":{"name":"callback","parameters":[{"name":"newState","$ref":"idle.IdleState"}]}},{"name":"setDetectionInterval","type":"function","parameters":[{"name":"intervalInSeconds","type":"integer","minimum":15}]},{"name":"getAutoLockDelay","type":"function","parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"delay","type":"integer"}]}}],"events":[{"name":"onStateChanged","type":"function","parameters":[{"name":"newState","$ref":"idle.IdleState"}]}]})R";
constexpr char kOffscreen[] = R"R({"namespace":"offscreen","types":[{"id":"offscreen.Reason","type":"string","enum":[{"name":"TESTING"},{"name":"AUDIO_PLAYBACK"},{"name":"IFRAME_SCRIPTING"},{"name":"DOM_SCRAPING"},{"name":"BLOBS"},{"name":"DOM_PARSER"},{"name":"USER_MEDIA"},{"name":"DISPLAY_MEDIA"},{"name":"WEB_RTC"},{"name":"CLIPBOARD"},{"name":"LOCAL_STORAGE"},{"name":"WORKERS"},{"name":"BATTERY_STATUS"},{"name":"MATCH_MEDIA"},{"name":"GEOLOCATION"}]},{"id":"offscreen.CreateParameters","properties":{"reasons":{"name":"reasons","type":"array","items":{"$ref":"offscreen.Reason"}},"url":{"name":"url","type":"string"},"justification":{"name":"justification","type":"string"}},"type":"object"}],"functions":[{"parameters":[{"name":"parameters","$ref":"offscreen.CreateParameters"}],"returns_async":{"name":"callback","parameters":[]},"name":"createDocument","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[]},"name":"closeDocument","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"boolean"}]},"name":"hasDocument","type":"function"}],"properties":{},"events":[],"platforms":null,"deprecated":null})R";
constexpr char kPower[] = R"R({"namespace":"power","types":[{"id":"power.Level","type":"string","enum":[{"name":"system"},{"name":"display"}]}],"functions":[{"parameters":[{"name":"level","$ref":"power.Level"}],"name":"requestKeepAwake","type":"function"},{"parameters":[],"name":"releaseKeepAwake","type":"function"},{"platforms":["chromeos"],"parameters":[],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"reportActivity","type":"function"}],"properties":{},"events":[],"platforms":null,"deprecated":null})R";
constexpr char kRuntime[] = R"R({"namespace":"runtime","types":[{"id":"runtime.Port","type":"object","properties":{"name":{"type":"string"},"disconnect":{"type":"function"},"postMessage":{"type":"function","parameters":[{"name":"message","type":"any"}]},"sender":{"$ref":"runtime.MessageSender","optional":true}},"events":[{"name":"onDisconnect","parameters":[{"name":"port","$ref":"runtime.Port"}]},{"name":"onMessage","parameters":[{"name":"message","type":"any"},{"name":"port","$ref":"runtime.Port"}]}],"additionalProperties":{"type":"any"}},{"id":"runtime.MessageSender","type":"object","properties":{"tab":{"$ref":"tabs.Tab","optional":true,"extension_types":["extension","legacy_packaged_app"]},"frameId":{"type":"integer","optional":true,"extension_types":["extension","legacy_packaged_app"]},"guestProcessId":{"type":"integer","optional":true,"extension_types":["extension"]},"guestRenderFrameRoutingId":{"type":"integer","optional":true,"extension_types":["extension"]},"id":{"type":"string","optional":true},"url":{"type":"string","optional":true},"nativeApplication":{"type":"string","optional":true},"tlsChannelId":{"type":"string","optional":true},"origin":{"type":"string","optional":true},"documentId":{"type":"string","optional":true},"documentLifecycle":{"type":"string","optional":true}}},{"id":"runtime.PlatformOs","type":"string","enum":[{"name":"mac"},{"name":"win"},{"name":"android"},{"name":"cros"},{"name":"linux"},{"name":"openbsd"},{"name":"fuchsia"}]},{"id":"runtime.PlatformArch","type":"string","enum":[{"name":"arm"},{"name":"arm64"},{"name":"x86-32"},{"name":"x86-64"},{"name":"mips"},{"name":"mips64"}]},{"id":"runtime.PlatformNaclArch","type":"string","enum":[{"name":"arm"},{"name":"x86-32"},{"name":"x86-64"},{"name":"mips"},{"name":"mips64"}]},{"id":"runtime.PlatformInfo","type":"object","properties":{"os":{"$ref":"runtime.PlatformOs"},"arch":{"$ref":"runtime.PlatformArch"},"nacl_arch":{"$ref":"runtime.PlatformNaclArch"}}},{"id":"runtime.RequestUpdateCheckStatus","type":"string","enum":[{"name":"throttled"},{"name":"no_update"},{"name":"update_available"}]},{"id":"runtime.OnInstalledReason","type":"string","enum":[{"name":"install"},{"name":"update"},{"name":"chrome_update"},{"name":"shared_module_update"}]},{"id":"runtime.OnRestartRequiredReason","type":"string","enum":[{"name":"app_update"},{"name":"os_update"},{"name":"periodic"}]},{"id":"runtime.ContextType","type":"string","enum":[{"name":"TAB"},{"name":"POPUP"},{"name":"BACKGROUND"},{"name":"OFFSCREEN_DOCUMENT"},{"name":"SIDE_PANEL"},{"name":"DEVELOPER_TOOLS"}]},{"id":"runtime.ExtensionContext","type":"object","properties":{"contextType":{"$ref":"runtime.ContextType"},"contextId":{"type":"string"},"tabId":{"type":"integer"},"windowId":{"type":"integer"},"documentId":{"type":"string","optional":true},"frameId":{"type":"integer"},"documentUrl":{"type":"string","optional":true},"documentOrigin":{"type":"string","optional":true},"incognito":{"type":"boolean"}}},{"id":"runtime.ContextFilter","type":"object","properties":{"contextTypes":{"type":"array","items":{"$ref":"runtime.ContextType"},"optional":true},"contextIds":{"type":"array","items":{"type":"string"},"optional":true},"tabIds":{"type":"array","items":{"type":"integer"},"optional":true},"windowIds":{"type":"array","items":{"type":"integer"},"optional":true},"documentIds":{"type":"array","items":{"type":"string"},"optional":true},"frameIds":{"type":"array","items":{"type":"integer"},"optional":true},"documentUrls":{"type":"array","items":{"type":"string"},"optional":true},"documentOrigins":{"type":"array","items":{"type":"string"},"optional":true},"incognito":{"type":"boolean","optional":true}}}],"properties":{"lastError":{"type":"object","optional":true,"properties":{"message":{"optional":true,"type":"string"}}},"id":{"type":"string"}},"functions":[{"name":"getBackgroundPage","type":"function","parameters":[],"deprecated":"Background pages do not exist in MV3 extensions.","returns_async":{"name":"callback","parameters":[{"name":"backgroundPage","optional":true,"type":"object","isInstanceOf":"Window","additionalProperties":{"type":"any"}}]}},{"name":"openOptionsPage","type":"function","parameters":[],"returns_async":{"name":"callback","parameters":[],"optional":true}},{"name":"getManifest","type":"function","parameters":[],"returns":{"type":"object","properties":{},"additionalProperties":{"type":"any"}}},{"name":"getURL","type":"function","parameters":[{"type":"string","name":"path"}],"returns":{"type":"string"}},{"name":"setUninstallURL","type":"function","parameters":[{"type":"string","name":"url","maxLength":1023}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"reload","type":"function","parameters":[]},{"name":"requestUpdateCheck","type":"function","parameters":[],"returns_async":{"name":"callback","parameters":[{"type":"object","name":"result","properties":{"status":{"$ref":"runtime.RequestUpdateCheckStatus"},"version":{"type":"string","optional":true}}}]}},{"name":"restart","type":"function","parameters":[]},{"name":"restartAfterDelay","type":"function","parameters":[{"type":"integer","name":"seconds"}],"returns_async":{"name":"callback","parameters":[],"optional":true}},{"name":"connect","type":"function","parameters":[{"type":"string","name":"extensionId","optional":true},{"type":"object","name":"connectInfo","properties":{"name":{"type":"string","optional":true},"includeTlsChannelId":{"type":"boolean","optional":true}},"optional":true}],"returns":{"$ref":"runtime.Port"}},{"name":"connectNative","type":"function","parameters":[{"type":"string","name":"application"}],"returns":{"$ref":"runtime.Port"}},{"name":"sendMessage","type":"function","parameters":[{"type":"string","name":"extensionId","optional":true},{"type":"any","name":"message"},{"type":"object","name":"options","properties":{"includeTlsChannelId":{"type":"boolean","optional":true}},"optional":true}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"response","type":"any"}]}},{"name":"sendNativeMessage","type":"function","parameters":[{"name":"application","type":"string"},{"name":"message","type":"object","additionalProperties":{"type":"any"}}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"response","type":"any","additionalProperties":{"type":"any"}}]}},{"name":"getPlatformInfo","type":"function","parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"platformInfo","$ref":"runtime.PlatformInfo"}]}},{"name":"getPackageDirectoryEntry","type":"function","parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"directoryEntry","type":"object","additionalProperties":{"type":"any"},"isInstanceOf":"DirectoryEntry"}]}},{"name":"getContexts","type":"function","parameters":[{"$ref":"runtime.ContextFilter","name":"filter"}],"returns_async":{"name":"callback","parameters":[{"name":"contexts","type":"array","items":{"$ref":"runtime.ExtensionContext"}}]}}],"events":[{"name":"onStartup","type":"function"},{"name":"onInstalled","type":"function","parameters":[{"type":"object","name":"details","properties":{"reason":{"$ref":"runtime.OnInstalledReason"},"previousVersion":{"type":"string","optional":true},"id":{"type":"string","optional":true}}}]},{"name":"onSuspend","type":"function"},{"name":"onSuspendCanceled","type":"function"},{"name":"onUpdateAvailable","type":"function","parameters":[{"type":"object","name":"details","properties":{"version":{"type":"string"}},"additionalProperties":{"type":"any"}}]},{"name":"onBrowserUpdateAvailable","type":"function","deprecated":"Please use $(ref:runtime.onRestartRequired).","parameters":[]},{"name":"onConnect","type":"function","options":{"unmanaged":true},"parameters":[{"$ref":"runtime.Port","name":"port"}]},{"name":"onConnectExternal","type":"function","parameters":[{"$ref":"runtime.Port","name":"port"}]},{"name":"onUserScriptConnect","type":"function","options":{"unmanaged":true},"parameters":[{"$ref":"runtime.Port","name":"port"}]},{"name":"onConnectNative","type":"function","parameters":[{"$ref":"runtime.Port","name":"port"}]},{"name":"onMessage","type":"function","options":{"unmanaged":true},"parameters":[{"name":"message","type":"any","o)R" R"R(ptional":true},{"name":"sender","$ref":"runtime.MessageSender"},{"name":"sendResponse","type":"function"}],"returns":{"type":"boolean","optional":true}},{"name":"onMessageExternal","type":"function","options":{"unmanaged":true},"parameters":[{"name":"message","type":"any","optional":true},{"name":"sender","$ref":"runtime.MessageSender"},{"name":"sendResponse","type":"function"}],"returns":{"type":"boolean","optional":true}},{"name":"onUserScriptMessage","type":"function","options":{"unmanaged":true},"parameters":[{"name":"message","type":"any","optional":true},{"name":"sender","$ref":"runtime.MessageSender"},{"name":"sendResponse","type":"function"}],"returns":{"type":"boolean","optional":true}},{"name":"onRestartRequired","type":"function","parameters":[{"$ref":"runtime.OnRestartRequiredReason","name":"reason"}]}]})R";
constexpr char kStorage[] = R"R({"namespace":"storage","unprivileged":true,"types":[{"id":"storage.AccessLevel","type":"string","enum":[{"name":"TRUSTED_CONTEXTS"},{"name":"TRUSTED_AND_UNTRUSTED_CONTEXTS"}]},{"id":"storage.StorageChange","type":"object","properties":{"oldValue":{"type":"any","optional":true},"newValue":{"type":"any","optional":true}}},{"id":"storage.StorageArea","type":"object","js_module":"StorageArea","functions":[{"name":"get","type":"function","parameters":[{"name":"keys","choices":[{"type":"string"},{"type":"array","items":{"type":"string"}},{"type":"object","additionalProperties":{"type":"any","preserveNull":true},"preserveNull":true}],"optional":true}],"returns_async":{"name":"callback","parameters":[{"name":"items","type":"object","additionalProperties":{"type":"any"}}]}},{"name":"getKeys","type":"function","parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"keys","type":"array","items":{"type":"string"}}]}},{"name":"getBytesInUse","type":"function","parameters":[{"name":"keys","choices":[{"type":"string"},{"type":"array","items":{"type":"string"}}],"optional":true}],"returns_async":{"name":"callback","parameters":[{"name":"bytesInUse","type":"number"}]}},{"name":"set","type":"function","parameters":[{"name":"items","type":"object","additionalProperties":{"type":"any","preserveNull":true},"preserveNull":true}],"returns_async":{"name":"callback","parameters":[],"optional":true}},{"name":"remove","type":"function","parameters":[{"name":"keys","choices":[{"type":"string"},{"type":"array","items":{"type":"string"}}]}],"returns_async":{"name":"callback","parameters":[],"optional":true}},{"name":"clear","type":"function","parameters":[],"returns_async":{"name":"callback","parameters":[],"optional":true}},{"name":"setAccessLevel","type":"function","parameters":[{"type":"object","name":"accessOptions","properties":{"accessLevel":{"$ref":"storage.AccessLevel"}}}],"returns_async":{"name":"callback","parameters":[],"optional":true}}],"events":[{"name":"onChanged","parameters":[{"name":"changes","type":"object","additionalProperties":{"$ref":"storage.StorageChange"}}]}]}],"events":[{"name":"onChanged","type":"function","parameters":[{"name":"changes","type":"object","additionalProperties":{"$ref":"storage.StorageChange"}},{"name":"areaName","type":"string"}]}],"properties":{"sync":{"$ref":"storage.StorageArea","value":["sync"],"properties":{"QUOTA_BYTES":{"value":102400,"type":"integer"},"QUOTA_BYTES_PER_ITEM":{"value":8192,"type":"integer"},"MAX_ITEMS":{"value":512,"type":"integer"},"MAX_WRITE_OPERATIONS_PER_HOUR":{"value":1800,"type":"integer"},"MAX_WRITE_OPERATIONS_PER_MINUTE":{"value":120,"type":"integer"},"MAX_SUSTAINED_WRITE_OPERATIONS_PER_MINUTE":{"value":1000000,"deprecated":"The storage.sync API no longer has a sustained write operation quota.","type":"integer"}}},"local":{"$ref":"storage.StorageArea","value":["local"],"properties":{"QUOTA_BYTES":{"value":10485760,"type":"integer"}}},"managed":{"$ref":"storage.StorageArea","value":["managed"]},"session":{"$ref":"storage.StorageArea","value":["session"],"properties":{"QUOTA_BYTES":{"value":10485760,"type":"integer"}}}}})R";
constexpr char kSystemCpu[] = R"R({"namespace":"system.cpu","types":[{"id":"system.cpu.CpuTime","properties":{"user":{"name":"user","type":"number"},"kernel":{"name":"kernel","type":"number"},"idle":{"name":"idle","type":"number"},"total":{"name":"total","type":"number"}},"type":"object"},{"id":"system.cpu.ProcessorInfo","properties":{"usage":{"name":"usage","$ref":"system.cpu.CpuTime"}},"type":"object"},{"id":"system.cpu.CpuInfo","properties":{"numOfProcessors":{"name":"numOfProcessors","type":"integer"},"archName":{"name":"archName","type":"string"},"modelName":{"name":"modelName","type":"string"},"features":{"name":"features","type":"array","items":{"type":"string"}},"processors":{"name":"processors","type":"array","items":{"$ref":"system.cpu.ProcessorInfo"}},"temperatures":{"name":"temperatures","type":"array","items":{"type":"number"}}},"type":"object"}],"functions":[{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"info","$ref":"system.cpu.CpuInfo"}]},"name":"getInfo","type":"function"}],"properties":{},"events":[],"platforms":null,"deprecated":null})R";
constexpr char kSystemMemory[] = R"R({"namespace":"system.memory","types":[{"id":"system.memory.MemoryInfo","properties":{"capacity":{"name":"capacity","type":"number"},"availableCapacity":{"name":"availableCapacity","type":"number"}},"type":"object"}],"functions":[{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"info","$ref":"system.memory.MemoryInfo"}]},"name":"getInfo","type":"function"}],"properties":{},"events":[],"platforms":null,"deprecated":null})R";
constexpr char kTest[] = R"R({"namespace":"test","functions":[{"name":"getConfig","type":"function","parameters":[],"returns_async":{"name":"callback","parameters":[{"type":"object","name":"testConfig","properties":{"customArg":{"type":"string","optional":true},"ftpServer":{"type":"object","optional":true,"properties":{"port":{"type":"integer","minimum":1024,"maximum":65535}}},"testServer":{"type":"object","optional":true,"properties":{"port":{"type":"integer","minimum":1024,"maximum":65535}}},"testDataDirectory":{"type":"string","optional":true},"testWebSocketPort":{"type":"integer","optional":true,"minimum":0,"maximum":65535},"testWebTransportPort":{"type":"integer","optional":true,"minimum":0,"maximum":65535},"loginStatus":{"type":"object","optional":true,"properties":{"isLoggedIn":{"type":"boolean","optional":true},"isScreenLocked":{"type":"boolean","optional":true}}}}}]}},{"name":"notifyFail","type":"function","parameters":[{"type":"string","name":"message"}]},{"name":"notifyPass","type":"function","parameters":[{"type":"string","name":"message","optional":true}]},{"name":"log","type":"function","parameters":[{"type":"string","name":"message"}]},{"name":"openFileUrl","type":"function","parameters":[{"type":"string","name":"url"}]},{"name":"sendMessage","type":"function","parameters":[{"type":"string","name":"message"}],"returns_async":{"name":"callback","optional":true,"parameters":[{"type":"string","name":"response"}]}},{"name":"sendScriptResult","type":"function","parameters":[{"type":"any","name":"result"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"callbackAdded","type":"function","parameters":[]},{"name":"fail","type":"function","parameters":[{"type":"any","name":"message","optional":true}]},{"name":"succeed","type":"function","parameters":[{"type":"any","name":"message","optional":true}]},{"name":"getModuleSystem","type":"function","parameters":[{"type":"any","name":"context"}],"returns":{"type":"any","optional":true}},{"name":"assertTrue","type":"function","parameters":[{"name":"test","choices":[{"type":"string"},{"type":"boolean"}]},{"type":"string","name":"message","optional":true}]},{"name":"assertFalse","type":"function","parameters":[{"name":"test","choices":[{"type":"string"},{"type":"boolean"}]},{"type":"string","name":"message","optional":true}]},{"name":"checkDeepEq","type":"function","parameters":[{"type":"any","name":"expected","optional":true},{"type":"any","name":"actual","optional":true}]},{"name":"assertEq","type":"function","parameters":[{"type":"any","name":"expected","optional":true},{"type":"any","name":"actual","optional":true},{"type":"string","name":"message","optional":true}]},{"name":"assertNe","type":"function","parameters":[{"type":"any","name":"expected","optional":true},{"type":"any","name":"actual","optional":true},{"type":"string","name":"message","optional":true}]},{"name":"assertNoLastError","type":"function","parameters":[]},{"name":"assertLastError","type":"function","parameters":[{"type":"string","name":"expectedError"}]},{"name":"assertThrows","type":"function","parameters":[{"type":"function","name":"fn"},{"type":"object","name":"self","additionalProperties":{"type":"any"},"optional":true},{"type":"array","items":{"type":"any"},"name":"args"},{"choices":[{"type":"string"},{"type":"object","isInstanceOf":"RegExp"}],"name":"message","optional":true}]},{"name":"assertPromiseRejects","type":"function","parameters":[{"type":"object","name":"promise","isInstanceOf":"Promise"},{"choices":[{"type":"string"},{"type":"object","isInstanceOf":"RegExp"}],"name":"expectedMessage"}],"returns":{"type":"object","isInstanceOf":"Promise"}},{"name":"callback","type":"function","parameters":[{"type":"function","name":"func","optional":true},{"type":"string","name":"expectedError","optional":true}]},{"name":"listenOnce","type":"function","parameters":[{"type":"any","name":"event"},{"type":"function","name":"func"}]},{"name":"listenForever","type":"function","parameters":[{"type":"any","name":"event"},{"type":"function","name":"func"}]},{"name":"callbackPass","type":"function","parameters":[{"type":"function","name":"func","optional":true}]},{"name":"callbackFail","type":"function","parameters":[{"type":"string","name":"expectedError"},{"type":"function","name":"func","optional":true}]},{"name":"runTests","type":"function","parameters":[{"type":"array","name":"tests","items":{"type":"function"}}]},{"name":"getApiFeatures","type":"function","parameters":[]},{"name":"getApiDefinitions","type":"function","parameters":[{"type":"array","name":"apiNames","optional":true,"items":{"type":"string"}}]},{"name":"isProcessingUserGesture","type":"function","parameters":[]},{"name":"runWithUserGesture","type":"function","parameters":[{"type":"function","name":"functionToRun","parameters":[]}]},{"name":"waitForRoundTrip","type":"function","parameters":[{"type":"string","name":"message"}],"returns_async":{"name":"callback","parameters":[{"type":"string","name":"message"}]}},{"name":"loadScript","type":"function","parameters":[{"type":"string","name":"scriptUrl"}],"returns":{"type":"object","isInstanceOf":"Promise"}},{"name":"setExceptionHandler","type":"function","parameters":[{"type":"function","name":"handler","parameters":[{"type":"string","name":"message"},{"type":"any","name":"exception"}]}]}],"events":[{"name":"onMessage","type":"function","parameters":[{"type":"object","name":"info","properties":{"data":{"type":"string"},"lastMessage":{"type":"boolean"}}}]}]})R";
constexpr char kWebRequest[] = R"R({"namespace":"webRequest","properties":{"MAX_HANDLER_BEHAVIOR_CHANGED_CALLS_PER_10_MINUTES":{"value":20,"type":"integer"}},"types":[{"id":"webRequest.ResourceType","type":"string","enum":[{"name":"main_frame"},{"name":"sub_frame"},{"name":"stylesheet"},{"name":"script"},{"name":"image"},{"name":"font"},{"name":"object"},{"name":"xmlhttprequest"},{"name":"ping"},{"name":"csp_report"},{"name":"media"},{"name":"websocket"},{"name":"webbundle"},{"name":"other"}]},{"id":"webRequest.OnBeforeRequestOptions","type":"string","enum":[{"name":"blocking"},{"name":"requestBody"},{"name":"extraHeaders"}]},{"id":"webRequest.OnBeforeSendHeadersOptions","type":"string","enum":[{"name":"requestHeaders"},{"name":"blocking"},{"name":"extraHeaders"}]},{"id":"webRequest.OnSendHeadersOptions","type":"string","enum":[{"name":"requestHeaders"},{"name":"extraHeaders"}]},{"id":"webRequest.OnHeadersReceivedOptions","type":"string","enum":[{"name":"blocking"},{"name":"responseHeaders"},{"name":"extraHeaders"}]},{"id":"webRequest.OnAuthRequiredOptions","type":"string","enum":[{"name":"responseHeaders"},{"name":"blocking"},{"name":"asyncBlocking"},{"name":"extraHeaders"}]},{"id":"webRequest.OnResponseStartedOptions","type":"string","enum":[{"name":"responseHeaders"},{"name":"extraHeaders"}]},{"id":"webRequest.OnBeforeRedirectOptions","type":"string","enum":[{"name":"responseHeaders"},{"name":"extraHeaders"}]},{"id":"webRequest.OnCompletedOptions","type":"string","enum":[{"name":"responseHeaders"},{"name":"extraHeaders"}]},{"id":"webRequest.OnErrorOccurredOptions","type":"string","enum":[{"name":"extraHeaders"}]},{"id":"webRequest.RequestFilter","type":"object","properties":{"urls":{"type":"array","items":{"type":"string"}},"types":{"type":"array","optional":true,"items":{"$ref":"webRequest.ResourceType"}},"tabId":{"type":"integer","optional":true},"windowId":{"type":"integer","optional":true}}},{"id":"webRequest.HttpHeaders","type":"array","items":{"type":"object","properties":{"name":{"type":"string"},"value":{"type":"string","optional":true},"binaryValue":{"type":"array","optional":true,"items":{"type":"integer"}}}}},{"id":"webRequest.BlockingResponse","type":"object","properties":{"cancel":{"type":"boolean","optional":true},"redirectUrl":{"type":"string","optional":true},"requestHeaders":{"$ref":"webRequest.HttpHeaders","optional":true},"responseHeaders":{"$ref":"webRequest.HttpHeaders","optional":true},"authCredentials":{"type":"object","optional":true,"properties":{"username":{"type":"string"},"password":{"type":"string"}}}}},{"id":"webRequest.UploadData","type":"object","properties":{"bytes":{"type":"any","optional":true},"file":{"type":"string","optional":true}}},{"id":"webRequest.FormDataItem","choices":[{"type":"binary"},{"type":"string"}]},{"id":"webRequest.IgnoredActionType","decription":"Denotes the extension proposed action which was ignored.","type":"string","enum":["redirect","request_headers","response_headers","auth_credentials"]}],"functions":[{"name":"handlerBehaviorChanged","type":"function","parameters":[],"returns_async":{"name":"callback","optional":true,"parameters":[]}}],"events":[{"name":"onBeforeRequest","type":"function","parameters":[{"type":"object","name":"details","properties":{"requestId":{"type":"string"},"url":{"type":"string"},"method":{"type":"string"},"frameId":{"type":"integer"},"parentFrameId":{"type":"integer"},"documentId":{"type":"string","optional":true},"parentDocumentId":{"type":"string","optional":true},"documentLifecycle":{"$ref":"extensionTypes.DocumentLifecycle","optional":true},"frameType":{"$ref":"extensionTypes.FrameType","optional":true},"requestBody":{"type":"object","optional":true,"properties":{"error":{"type":"string","optional":true},"formData":{"type":"object","optional":true,"properties":{},"additionalProperties":{"type":"array","items":{"$ref":"webRequest.FormDataItem"}}},"raw":{"type":"array","optional":true,"items":{"$ref":"webRequest.UploadData"}}}},"tabId":{"type":"integer"},"type":{"$ref":"webRequest.ResourceType"},"initiator":{"type":"string","optional":true},"timeStamp":{"type":"number"}}}],"extraParameters":[{"$ref":"webRequest.RequestFilter","name":"filter"},{"type":"array","optional":true,"name":"extraInfoSpec","items":{"$ref":"webRequest.OnBeforeRequestOptions"}}],"returns":{"$ref":"webRequest.BlockingResponse","optional":true}},{"name":"onBeforeSendHeaders","type":"function","parameters":[{"type":"object","name":"details","properties":{"requestId":{"type":"string"},"url":{"type":"string"},"method":{"type":"string"},"frameId":{"type":"integer"},"parentFrameId":{"type":"integer"},"documentId":{"type":"string"},"parentDocumentId":{"type":"string","optional":true},"documentLifecycle":{"$ref":"extensionTypes.DocumentLifecycle"},"frameType":{"$ref":"extensionTypes.FrameType"},"tabId":{"type":"integer"},"initiator":{"type":"string","optional":true},"type":{"$ref":"webRequest.ResourceType"},"timeStamp":{"type":"number"},"requestHeaders":{"$ref":"webRequest.HttpHeaders","optional":true}}}],"extraParameters":[{"$ref":"webRequest.RequestFilter","name":"filter"},{"type":"array","optional":true,"name":"extraInfoSpec","items":{"$ref":"webRequest.OnBeforeSendHeadersOptions"}}],"returns":{"$ref":"webRequest.BlockingResponse","optional":true}},{"name":"onSendHeaders","type":"function","parameters":[{"type":"object","name":"details","properties":{"requestId":{"type":"string"},"url":{"type":"string"},"method":{"type":"string"},"frameId":{"type":"integer"},"parentFrameId":{"type":"integer"},"documentId":{"type":"string"},"parentDocumentId":{"type":"string","optional":true},"documentLifecycle":{"$ref":"extensionTypes.DocumentLifecycle"},"frameType":{"$ref":"extensionTypes.FrameType"},"tabId":{"type":"integer"},"type":{"$ref":"webRequest.ResourceType"},"initiator":{"type":"string","optional":true},"timeStamp":{"type":"number"},"requestHeaders":{"$ref":"webRequest.HttpHeaders","optional":true}}}],"extraParameters":[{"$ref":"webRequest.RequestFilter","name":"filter"},{"type":"array","optional":true,"name":"extraInfoSpec","items":{"$ref":"webRequest.OnSendHeadersOptions"}}]},{"name":"onHeadersReceived","type":"function","parameters":[{"type":"object","name":"details","properties":{"requestId":{"type":"string"},"url":{"type":"string"},"method":{"type":"string"},"frameId":{"type":"integer"},"parentFrameId":{"type":"integer"},"documentId":{"type":"string"},"parentDocumentId":{"type":"string","optional":true},"documentLifecycle":{"$ref":"extensionTypes.DocumentLifecycle"},"frameType":{"$ref":"extensionTypes.FrameType"},"tabId":{"type":"integer"},"type":{"$ref":"webRequest.ResourceType"},"initiator":{"type":"string","optional":true},"timeStamp":{"type":"number"},"statusLine":{"type":"string"},"responseHeaders":{"$ref":"webRequest.HttpHeaders","optional":true},"statusCode":{"type":"integer"}}}],"extraParameters":[{"$ref":"webRequest.RequestFilter","name":"filter"},{"type":"array","optional":true,"name":"extraInfoSpec","items":{"$ref":"webRequest.OnHeadersReceivedOptions"}}],"returns":{"$ref":"webRequest.BlockingResponse","optional":true}},{"name":"onAuthRequired","type":"function","parameters":[{"type":"object","name":"details","properties":{"requestId":{"type":"string"},"url":{"type":"string"},"method":{"type":"string"},"frameId":{"type":"integer"},"parentFrameId":{"type":"integer"},"documentId":{"type":"string"},"parentDocumentId":{"type":"string","optional":true},"documentLifecycle":{"$ref":"extensionTypes.DocumentLifecycle"},"frameType":{"$ref":"extensionTypes.FrameType"},"tabId":{"type":"integer"},"type":{"$ref":"webRequest.ResourceType"},"initiator":{"type":"string","optional":true},"timeStamp":{"type":"number"},"scheme":{"type":"string"},"realm":{"type":"string","optional":true},"challenger":{"type":"object","properties":{"host":{"type":"string"},"port":{"type":"integer"}}},"isProxy":{"type":"boolean"},"responseHeaders":{"$ref":"webRequest.HttpHeaders","optional":true},"statusLine":{"type":"string"},"statusCode":{"type":"integer"}}},{"type":"function","optional":true,"name":"asyncCallback","parameters":[{"name":"response","$ref":"webRequest.BlockingResponse"}]}],"extraParameters":[{"$ref":"webRequest.RequestFilter","n)R" R"R(ame":"filter"},{"type":"array","optional":true,"name":"extraInfoSpec","items":{"$ref":"webRequest.OnAuthRequiredOptions"}}],"returns":{"$ref":"webRequest.BlockingResponse","optional":true}},{"name":"onResponseStarted","type":"function","parameters":[{"type":"object","name":"details","properties":{"requestId":{"type":"string"},"url":{"type":"string"},"method":{"type":"string"},"frameId":{"type":"integer"},"parentFrameId":{"type":"integer"},"documentId":{"type":"string"},"parentDocumentId":{"type":"string","optional":true},"documentLifecycle":{"$ref":"extensionTypes.DocumentLifecycle"},"frameType":{"$ref":"extensionTypes.FrameType"},"tabId":{"type":"integer"},"type":{"$ref":"webRequest.ResourceType"},"initiator":{"type":"string","optional":true},"timeStamp":{"type":"number"},"ip":{"type":"string","optional":true},"fromCache":{"type":"boolean"},"statusCode":{"type":"integer"},"responseHeaders":{"$ref":"webRequest.HttpHeaders","optional":true},"statusLine":{"type":"string"}}}],"extraParameters":[{"$ref":"webRequest.RequestFilter","name":"filter"},{"type":"array","optional":true,"name":"extraInfoSpec","items":{"$ref":"webRequest.OnResponseStartedOptions"}}]},{"name":"onBeforeRedirect","type":"function","parameters":[{"type":"object","name":"details","properties":{"requestId":{"type":"string"},"url":{"type":"string"},"method":{"type":"string"},"frameId":{"type":"integer"},"parentFrameId":{"type":"integer"},"documentId":{"type":"string"},"parentDocumentId":{"type":"string","optional":true},"documentLifecycle":{"$ref":"extensionTypes.DocumentLifecycle"},"frameType":{"$ref":"extensionTypes.FrameType"},"tabId":{"type":"integer"},"type":{"$ref":"webRequest.ResourceType"},"initiator":{"type":"string","optional":true},"timeStamp":{"type":"number"},"ip":{"type":"string","optional":true},"fromCache":{"type":"boolean"},"statusCode":{"type":"integer"},"redirectUrl":{"type":"string"},"responseHeaders":{"$ref":"webRequest.HttpHeaders","optional":true},"statusLine":{"type":"string"}}}],"extraParameters":[{"$ref":"webRequest.RequestFilter","name":"filter"},{"type":"array","optional":true,"name":"extraInfoSpec","items":{"$ref":"webRequest.OnBeforeRedirectOptions"}}]},{"name":"onCompleted","type":"function","parameters":[{"type":"object","name":"details","properties":{"requestId":{"type":"string"},"url":{"type":"string"},"method":{"type":"string"},"frameId":{"type":"integer"},"parentFrameId":{"type":"integer"},"documentId":{"type":"string"},"parentDocumentId":{"type":"string","optional":true},"documentLifecycle":{"$ref":"extensionTypes.DocumentLifecycle"},"frameType":{"$ref":"extensionTypes.FrameType"},"tabId":{"type":"integer"},"type":{"$ref":"webRequest.ResourceType"},"initiator":{"type":"string","optional":true},"timeStamp":{"type":"number"},"ip":{"type":"string","optional":true},"fromCache":{"type":"boolean"},"statusCode":{"type":"integer"},"responseHeaders":{"$ref":"webRequest.HttpHeaders","optional":true},"statusLine":{"type":"string"}}}],"extraParameters":[{"$ref":"webRequest.RequestFilter","name":"filter"},{"type":"array","optional":true,"name":"extraInfoSpec","items":{"$ref":"webRequest.OnCompletedOptions"}}]},{"name":"onErrorOccurred","type":"function","parameters":[{"type":"object","name":"details","properties":{"requestId":{"type":"string"},"url":{"type":"string"},"method":{"type":"string"},"frameId":{"type":"integer"},"parentFrameId":{"type":"integer"},"documentId":{"type":"string"},"parentDocumentId":{"type":"string","optional":true},"documentLifecycle":{"$ref":"extensionTypes.DocumentLifecycle"},"frameType":{"$ref":"extensionTypes.FrameType"},"tabId":{"type":"integer"},"type":{"$ref":"webRequest.ResourceType"},"initiator":{"type":"string","optional":true},"timeStamp":{"type":"number"},"ip":{"type":"string","optional":true},"fromCache":{"type":"boolean"},"error":{"type":"string"}}}],"extraParameters":[{"$ref":"webRequest.RequestFilter","name":"filter"},{"type":"array","optional":true,"name":"extraInfoSpec","items":{"$ref":"webRequest.OnErrorOccurredOptions"}}]},{"name":"onActionIgnored","type":"function","parameters":[{"type":"object","name":"details","properties":{"requestId":{"type":"string"},"action":{"$ref":"webRequest.IgnoredActionType"}}}]}]})R";
constexpr char kAppCurrentWindowInternal[] = R"R({"namespace":"app.currentWindowInternal","types":[{"id":"app.currentWindowInternal.Bounds","properties":{"left":{"optional":true,"name":"left","type":"integer"},"top":{"optional":true,"name":"top","type":"integer"},"width":{"optional":true,"name":"width","type":"integer"},"height":{"optional":true,"name":"height","type":"integer"}},"type":"object"},{"id":"app.currentWindowInternal.SizeConstraints","properties":{"minWidth":{"optional":true,"name":"minWidth","type":"integer"},"minHeight":{"optional":true,"name":"minHeight","type":"integer"},"maxWidth":{"optional":true,"name":"maxWidth","type":"integer"},"maxHeight":{"optional":true,"name":"maxHeight","type":"integer"}},"type":"object"},{"id":"app.currentWindowInternal.RegionRect","properties":{"left":{"name":"left","type":"integer"},"top":{"name":"top","type":"integer"},"width":{"name":"width","type":"integer"},"height":{"name":"height","type":"integer"}},"type":"object"},{"id":"app.currentWindowInternal.Region","properties":{"rects":{"optional":true,"name":"rects","type":"array","items":{"$ref":"app.currentWindowInternal.RegionRect"}}},"type":"object"}],"functions":[{"parameters":[],"name":"focus","type":"function"},{"parameters":[],"name":"fullscreen","type":"function"},{"parameters":[],"name":"minimize","type":"function"},{"parameters":[],"name":"maximize","type":"function"},{"parameters":[],"name":"restore","type":"function"},{"parameters":[],"name":"drawAttention","type":"function"},{"parameters":[],"name":"clearAttention","type":"function"},{"parameters":[{"name":"focused","optional":true,"type":"boolean"}],"name":"show","type":"function"},{"parameters":[],"name":"hide","type":"function"},{"parameters":[{"name":"boundsType","type":"string"},{"name":"bounds","$ref":"app.currentWindowInternal.Bounds"}],"name":"setBounds","type":"function"},{"parameters":[{"name":"boundsType","type":"string"},{"name":"constraints","$ref":"app.currentWindowInternal.SizeConstraints"}],"name":"setSizeConstraints","type":"function"},{"parameters":[{"name":"icon_url","type":"string"}],"name":"setIcon","type":"function"},{"parameters":[{"name":"region","$ref":"app.currentWindowInternal.Region"}],"name":"setShape","type":"function"},{"parameters":[{"name":"always_on_top","type":"boolean"}],"name":"setAlwaysOnTop","type":"function"},{"parameters":[{"name":"always_visible","type":"boolean"}],"name":"setVisibleOnAllWorkspaces","type":"function"},{"parameters":[{"name":"activate_on_pointer","type":"boolean"}],"name":"setActivateOnPointer","type":"function"}],"properties":{},"events":[{"parameters":[],"name":"onClosed","type":"function"},{"parameters":[],"name":"onBoundsChanged","type":"function"},{"parameters":[],"name":"onFullscreened","type":"function"},{"parameters":[],"name":"onMinimized","type":"function"},{"parameters":[],"name":"onMaximized","type":"function"},{"parameters":[],"name":"onRestored","type":"function"},{"parameters":[],"name":"onAlphaEnabledChanged","type":"function"}],"platforms":null,"deprecated":null})R";
constexpr char kAppRuntime[] = R"R({"namespace":"app.runtime","types":[{"id":"app.runtime.LaunchItem","properties":{"entry":{"name":"entry","type":"object","additionalProperties":{"type":"any"},"isInstanceOf":"Entry"},"type":{"optional":true,"name":"type","type":"string"}},"type":"object"},{"id":"app.runtime.LaunchSource","type":"string","enum":[{"name":"untracked"},{"name":"app_launcher"},{"name":"new_tab_page"},{"name":"reload"},{"name":"restart"},{"name":"load_and_launch"},{"name":"command_line"},{"name":"file_handler"},{"name":"url_handler"},{"name":"system_tray"},{"name":"about_page"},{"name":"keyboard"},{"name":"extensions_page"},{"name":"management_api"},{"name":"ephemeral_app"},{"name":"background"},{"name":"kiosk"},{"name":"chrome_internal"},{"name":"test"},{"name":"installed_notification"},{"name":"context_menu"},{"name":"arc"},{"name":"intent_url"},{"name":"app_home_page"},{"name":"focus_mode"},{"name":"sparky"}]},{"id":"app.runtime.ActionType","type":"string","enum":[{"name":"new_note"}]},{"id":"app.runtime.ActionData","properties":{"actionType":{"name":"actionType","$ref":"app.runtime.ActionType"}},"type":"object"},{"id":"app.runtime.LaunchData","properties":{"id":{"optional":true,"name":"id","type":"string"},"items":{"optional":true,"name":"items","type":"array","items":{"$ref":"app.runtime.LaunchItem"}},"url":{"optional":true,"name":"url","type":"string"},"referrerUrl":{"optional":true,"name":"referrerUrl","type":"string"},"isDemoSession":{"optional":true,"name":"isDemoSession","type":"boolean"},"isKioskSession":{"optional":true,"name":"isKioskSession","type":"boolean"},"isPublicSession":{"optional":true,"name":"isPublicSession","type":"boolean"},"source":{"optional":true,"name":"source","$ref":"app.runtime.LaunchSource"},"actionData":{"optional":true,"name":"actionData","$ref":"app.runtime.ActionData"}},"type":"object"},{"id":"app.runtime.EmbedRequest","properties":{"embedderId":{"name":"embedderId","type":"string"},"data":{"optional":true,"name":"data","type":"any"},"allow":{"parameters":[{"name":"url","type":"string"}],"name":"allow","type":"function"},"deny":{"parameters":[],"name":"deny","type":"function"}},"type":"object"}],"functions":[],"properties":{},"events":[{"parameters":[{"name":"request","$ref":"app.runtime.EmbedRequest"}],"name":"onEmbedRequested","type":"function"},{"parameters":[{"name":"launchData","optional":true,"$ref":"app.runtime.LaunchData"}],"name":"onLaunched","type":"function"},{"parameters":[],"name":"onRestarted","type":"function"}],"platforms":null,"deprecated":null})R";
constexpr char kAppViewGuestInternal[] = R"R({"namespace":"appViewGuestInternal","functions":[{"name":"attachFrame","type":"function","parameters":[{"type":"string","name":"url"},{"type":"integer","name":"guestInstanceId"}],"returns_async":{"name":"callback","optional":true,"parameters":[{"type":"integer","name":"instanceId"}]}},{"name":"denyRequest","type":"function","parameters":[{"type":"integer","name":"guestInstanceId"}]}]})R";
constexpr char kAppWindow[] = R"R({"namespace":"app.window","types":[{"id":"app.window.ContentBounds","properties":{"left":{"optional":true,"name":"left","type":"integer"},"top":{"optional":true,"name":"top","type":"integer"},"width":{"optional":true,"name":"width","type":"integer"},"height":{"optional":true,"name":"height","type":"integer"}},"type":"object"},{"id":"app.window.BoundsSpecification","properties":{"left":{"optional":true,"name":"left","type":"integer"},"top":{"optional":true,"name":"top","type":"integer"},"width":{"optional":true,"name":"width","type":"integer"},"height":{"optional":true,"name":"height","type":"integer"},"minWidth":{"optional":true,"name":"minWidth","type":"integer"},"minHeight":{"optional":true,"name":"minHeight","type":"integer"},"maxWidth":{"optional":true,"name":"maxWidth","type":"integer"},"maxHeight":{"optional":true,"name":"maxHeight","type":"integer"}},"type":"object"},{"id":"app.window.Bounds","properties":{"left":{"name":"left","type":"integer"},"top":{"name":"top","type":"integer"},"width":{"name":"width","type":"integer"},"height":{"name":"height","type":"integer"},"minWidth":{"optional":true,"name":"minWidth","type":"integer"},"minHeight":{"optional":true,"name":"minHeight","type":"integer"},"maxWidth":{"optional":true,"name":"maxWidth","type":"integer"},"maxHeight":{"optional":true,"name":"maxHeight","type":"integer"},"setPosition":{"parameters":[{"name":"left","type":"integer"},{"name":"top","type":"integer"}],"name":"setPosition","type":"function"},"setSize":{"parameters":[{"name":"width","type":"integer"},{"name":"height","type":"integer"}],"name":"setSize","type":"function"},"setMinimumSize":{"parameters":[{"name":"minWidth","type":"integer"},{"name":"minHeight","type":"integer"}],"name":"setMinimumSize","type":"function"},"setMaximumSize":{"parameters":[{"name":"maxWidth","type":"integer"},{"name":"maxHeight","type":"integer"}],"name":"setMaximumSize","type":"function"}},"type":"object"},{"id":"app.window.FrameOptions","properties":{"type":{"optional":true,"name":"type","type":"string"},"color":{"optional":true,"name":"color","type":"string"},"activeColor":{"optional":true,"name":"activeColor","type":"string"},"inactiveColor":{"optional":true,"name":"inactiveColor","type":"string"}},"type":"object"},{"id":"app.window.State","type":"string","enum":[{"name":"normal"},{"name":"fullscreen"},{"name":"maximized"},{"name":"minimized"}]},{"id":"app.window.WindowType","type":"string","enum":[{"name":"shell"},{"name":"panel"}]},{"id":"app.window.CreateWindowOptions","properties":{"id":{"optional":true,"name":"id","type":"string"},"innerBounds":{"optional":true,"name":"innerBounds","$ref":"app.window.BoundsSpecification"},"outerBounds":{"optional":true,"name":"outerBounds","$ref":"app.window.BoundsSpecification"},"defaultWidth":{"deprecated":"Use $(ref:BoundsSpecification).","optional":true,"name":"defaultWidth","type":"integer"},"defaultHeight":{"deprecated":"Use $(ref:BoundsSpecification).","optional":true,"name":"defaultHeight","type":"integer"},"defaultLeft":{"deprecated":"Use $(ref:BoundsSpecification).","optional":true,"name":"defaultLeft","type":"integer"},"defaultTop":{"deprecated":"Use $(ref:BoundsSpecification).","optional":true,"name":"defaultTop","type":"integer"},"width":{"deprecated":"Use $(ref:BoundsSpecification).","optional":true,"name":"width","type":"integer"},"height":{"deprecated":"Use $(ref:BoundsSpecification).","optional":true,"name":"height","type":"integer"},"left":{"deprecated":"Use $(ref:BoundsSpecification).","optional":true,"name":"left","type":"integer"},"top":{"deprecated":"Use $(ref:BoundsSpecification).","optional":true,"name":"top","type":"integer"},"minWidth":{"deprecated":"Use innerBounds or outerBounds.","optional":true,"name":"minWidth","type":"integer"},"minHeight":{"deprecated":"Use innerBounds or outerBounds.","optional":true,"name":"minHeight","type":"integer"},"maxWidth":{"deprecated":"Use innerBounds or outerBounds.","optional":true,"name":"maxWidth","type":"integer"},"maxHeight":{"deprecated":"Use innerBounds or outerBounds.","optional":true,"name":"maxHeight","type":"integer"},"type":{"deprecated":"All app windows use the 'shell' window type","optional":true,"name":"type","$ref":"app.window.WindowType"},"ime":{"optional":true,"name":"ime","type":"boolean"},"showInShelf":{"optional":true,"name":"showInShelf","type":"boolean"},"icon":{"optional":true,"name":"icon","type":"string"},"frame":{"optional":true,"name":"frame","choices":[{"type":"string"},{"$ref":"app.window.FrameOptions"}]},"bounds":{"deprecated":"Use innerBounds or outerBounds.","optional":true,"name":"bounds","$ref":"app.window.ContentBounds"},"alphaEnabled":{"optional":true,"name":"alphaEnabled","type":"boolean"},"state":{"optional":true,"name":"state","$ref":"app.window.State"},"hidden":{"optional":true,"name":"hidden","type":"boolean"},"resizable":{"optional":true,"name":"resizable","type":"boolean"},"singleton":{"deprecated":"Multiple windows with the same id is no longer supported.","optional":true,"name":"singleton","type":"boolean"},"alwaysOnTop":{"optional":true,"name":"alwaysOnTop","type":"boolean"},"focused":{"optional":true,"name":"focused","type":"boolean"},"visibleOnAllWorkspaces":{"optional":true,"name":"visibleOnAllWorkspaces","type":"boolean"}},"type":"object"},{"id":"app.window.AppWindow","properties":{"focus":{"parameters":[],"name":"focus","type":"function"},"fullscreen":{"parameters":[],"name":"fullscreen","type":"function"},"isFullscreen":{"parameters":[],"returns":{"name":"isFullscreen","type":"boolean"},"name":"isFullscreen","type":"function"},"minimize":{"parameters":[],"name":"minimize","type":"function"},"isMinimized":{"parameters":[],"returns":{"name":"isMinimized","type":"boolean"},"name":"isMinimized","type":"function"},"maximize":{"parameters":[],"name":"maximize","type":"function"},"isMaximized":{"parameters":[],"returns":{"name":"isMaximized","type":"boolean"},"name":"isMaximized","type":"function"},"restore":{"parameters":[],"name":"restore","type":"function"},"moveTo":{"deprecated":"Use outerBounds.","parameters":[{"name":"left","type":"integer"},{"name":"top","type":"integer"}],"name":"moveTo","type":"function"},"resizeTo":{"deprecated":"Use outerBounds.","parameters":[{"name":"width","type":"integer"},{"name":"height","type":"integer"}],"name":"resizeTo","type":"function"},"drawAttention":{"parameters":[],"name":"drawAttention","type":"function"},"clearAttention":{"parameters":[],"name":"clearAttention","type":"function"},"close":{"parameters":[],"name":"close","type":"function"},"show":{"parameters":[{"name":"focused","optional":true,"type":"boolean"}],"name":"show","type":"function"},"hide":{"parameters":[],"name":"hide","type":"function"},"getBounds":{"deprecated":"Use innerBounds or outerBounds.","parameters":[],"returns":{"name":"getBounds","$ref":"app.window.ContentBounds","optional":true},"name":"getBounds","type":"function"},"setBounds":{"deprecated":"Use innerBounds or outerBounds.","parameters":[{"name":"bounds","$ref":"app.window.ContentBounds"}],"name":"setBounds","type":"function"},"setIcon":{"parameters":[{"name":"iconUrl","type":"string"}],"name":"setIcon","type":"function"},"isAlwaysOnTop":{"parameters":[],"returns":{"name":"isAlwaysOnTop","type":"boolean"},"name":"isAlwaysOnTop","type":"function"},"hasFrameColor":{"name":"hasFrameColor","type":"boolean"},"activeFrameColor":{"name":"activeFrameColor","type":"integer"},"inactiveFrameColor":{"name":"inactiveFrameColor","type":"integer"},"setAlwaysOnTop":{"parameters":[{"name":"alwaysOnTop","type":"boolean"}],"name":"setAlwaysOnTop","type":"function"},"alphaEnabled":{"parameters":[],"returns":{"name":"alphaEnabled","type":"boolean"},"name":"alphaEnabled","type":"function"},"setVisibleOnAllWorkspaces":{"parameters":[{"name":"alwaysVisible","type":"boolean"}],"name":"setVisibleOnAllWorkspaces","type":"function"},"contentWindow":{"name":"contentWindow","type":"object","additionalProperties":{"type":"any"},"isInstanceOf":"Window"},"id":{"name":"id","type":"string"},"innerBounds":{"name":"innerBounds","$ref":"app.window.Bounds"},"outerBounds":{"name":"outerBounds","$ref":"app.window.Bounds"}},"type":"object"}],"functions":[{"parame)R" R"R(ters":[{"name":"url","type":"string"},{"name":"options","optional":true,"$ref":"app.window.CreateWindowOptions"}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"createdWindow","type":"object","additionalProperties":{"type":"any"},"isInstanceOf":"AppWindow"}]},"name":"create","type":"function"},{"parameters":[],"returns":{"name":"current","$ref":"app.window.AppWindow","optional":true},"name":"current","type":"function"},{"parameters":[{"name":"state","type":"object","additionalProperties":{"type":"any"}}],"name":"initializeAppWindow","type":"function"},{"parameters":[],"returns":{"name":"getAll","type":"array","items":{"$ref":"app.window.AppWindow"}},"name":"getAll","type":"function"},{"parameters":[{"name":"id","type":"string"}],"returns":{"name":"get","$ref":"app.window.AppWindow","optional":true},"name":"get","type":"function"},{"parameters":[],"returns":{"name":"canSetVisibleOnAllWorkspaces","type":"boolean"},"name":"canSetVisibleOnAllWorkspaces","type":"function"}],"properties":{},"events":[{"parameters":[],"name":"onBoundsChanged","type":"function"},{"parameters":[],"name":"onClosed","type":"function"},{"parameters":[],"name":"onFullscreened","type":"function"},{"parameters":[],"name":"onMaximized","type":"function"},{"parameters":[],"name":"onMinimized","type":"function"},{"parameters":[],"name":"onRestored","type":"function"},{"parameters":[],"name":"onAlphaEnabledChanged","type":"function"}],"platforms":null,"deprecated":null})R";
constexpr char kAudio[] = R"R({"namespace":"audio","types":[{"id":"audio.StreamType","type":"string","enum":[{"name":"INPUT"},{"name":"OUTPUT"}]},{"id":"audio.DeviceType","type":"string","enum":[{"name":"HEADPHONE"},{"name":"MIC"},{"name":"USB"},{"name":"BLUETOOTH"},{"name":"HDMI"},{"name":"INTERNAL_SPEAKER"},{"name":"INTERNAL_MIC"},{"name":"FRONT_MIC"},{"name":"REAR_MIC"},{"name":"KEYBOARD_MIC"},{"name":"HOTWORD"},{"name":"LINEOUT"},{"name":"POST_MIX_LOOPBACK"},{"name":"POST_DSP_LOOPBACK"},{"name":"ALSA_LOOPBACK"},{"name":"OTHER"}]},{"id":"audio.AudioDeviceInfo","properties":{"id":{"name":"id","type":"string"},"streamType":{"name":"streamType","$ref":"audio.StreamType"},"deviceType":{"name":"deviceType","$ref":"audio.DeviceType"},"displayName":{"name":"displayName","type":"string"},"deviceName":{"name":"deviceName","type":"string"},"isActive":{"name":"isActive","type":"boolean"},"level":{"name":"level","type":"integer"},"stableDeviceId":{"optional":true,"name":"stableDeviceId","type":"string"}},"type":"object"},{"id":"audio.DeviceFilter","properties":{"streamTypes":{"optional":true,"name":"streamTypes","type":"array","items":{"$ref":"audio.StreamType"}},"isActive":{"optional":true,"name":"isActive","type":"boolean"}},"type":"object"},{"id":"audio.DeviceProperties","properties":{"level":{"optional":true,"name":"level","type":"integer"}},"type":"object"},{"id":"audio.DeviceIdLists","properties":{"input":{"optional":true,"name":"input","type":"array","items":{"type":"string"}},"output":{"optional":true,"name":"output","type":"array","items":{"type":"string"}}},"type":"object"},{"id":"audio.MuteChangedEvent","properties":{"streamType":{"name":"streamType","$ref":"audio.StreamType"},"isMuted":{"name":"isMuted","type":"boolean"}},"type":"object"},{"id":"audio.LevelChangedEvent","properties":{"deviceId":{"name":"deviceId","type":"string"},"level":{"name":"level","type":"integer"}},"type":"object"}],"functions":[{"parameters":[{"name":"filter","optional":true,"$ref":"audio.DeviceFilter"}],"returns_async":{"name":"callback","parameters":[{"name":"devices","type":"array","items":{"$ref":"audio.AudioDeviceInfo"}}]},"name":"getDevices","type":"function"},{"parameters":[{"name":"ids","$ref":"audio.DeviceIdLists"}],"returns_async":{"name":"callback","parameters":[]},"name":"setActiveDevices","type":"function"},{"parameters":[{"name":"id","type":"string"},{"name":"properties","$ref":"audio.DeviceProperties"}],"returns_async":{"name":"callback","parameters":[]},"name":"setProperties","type":"function"},{"parameters":[{"name":"streamType","$ref":"audio.StreamType"}],"returns_async":{"name":"callback","parameters":[{"name":"value","type":"boolean"}]},"name":"getMute","type":"function"},{"parameters":[{"name":"streamType","$ref":"audio.StreamType"},{"name":"isMuted","type":"boolean"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"setMute","type":"function"}],"properties":{},"events":[{"parameters":[{"name":"event","$ref":"audio.LevelChangedEvent"}],"name":"onLevelChanged","type":"function"},{"parameters":[{"name":"event","$ref":"audio.MuteChangedEvent"}],"name":"onMuteChanged","type":"function"},{"parameters":[{"name":"devices","type":"array","items":{"$ref":"audio.AudioDeviceInfo"}}],"name":"onDeviceListChanged","type":"function"}],"platforms":null,"deprecated":null})R";
constexpr char kAutomation[] = R"R({"namespace":"automation","types":[{"id":"automation.EventType","type":"string","enum":[{"name":"accessKeyChanged"},{"name":"activeDescendantChanged"},{"name":"alert"},{"name":"ariaAttributeChangedDeprecated"},{"name":"ariaCurrentChanged"},{"name":"ariaNotificationsPosted"},{"name":"atomicChanged"},{"name":"autoCompleteChanged"},{"name":"autocorrectionOccured"},{"name":"autofillAvailabilityChanged"},{"name":"blur"},{"name":"busyChanged"},{"name":"caretBoundsChanged"},{"name":"checkedStateChanged"},{"name":"checkedStateDescriptionChanged"},{"name":"childrenChanged"},{"name":"clicked"},{"name":"collapsed"},{"name":"controlsChanged"},{"name":"detailsChanged"},{"name":"describedByChanged"},{"name":"descriptionChanged"},{"name":"documentSelectionChanged"},{"name":"documentTitleChanged"},{"name":"dropeffectChanged"},{"name":"editableTextChanged"},{"name":"enabledChanged"},{"name":"endOfTest"},{"name":"expanded"},{"name":"expandedChanged"},{"name":"flowFromChanged"},{"name":"flowToChanged"},{"name":"focus"},{"name":"focusAfterMenuClose"},{"name":"focusChanged"},{"name":"focusContext"},{"name":"grabbedChanged"},{"name":"haspopupChanged"},{"name":"hide"},{"name":"hierarchicalLevelChanged"},{"name":"hitTestResult"},{"name":"hover"},{"name":"ignoredChanged"},{"name":"imageAnnotationChanged"},{"name":"imageFrameUpdated"},{"name":"invalidStatusChanged"},{"name":"keyShortcutsChanged"},{"name":"labeledByChanged"},{"name":"languageChanged"},{"name":"layoutComplete"},{"name":"layoutInvalidated"},{"name":"liveRegionChanged"},{"name":"liveRegionCreated"},{"name":"liveRegionNodeChanged"},{"name":"liveRelevantChanged"},{"name":"liveStatusChanged"},{"name":"loadComplete"},{"name":"loadStart"},{"name":"locationChanged"},{"name":"mediaStartedPlaying"},{"name":"mediaStoppedPlaying"},{"name":"menuEnd"},{"name":"menuItemSelected"},{"name":"menuListValueChangedDeprecated"},{"name":"menuPopupEnd"},{"name":"menuPopupStart"},{"name":"menuStart"},{"name":"mouseCanceled"},{"name":"mouseDragged"},{"name":"mouseMoved"},{"name":"mousePressed"},{"name":"mouseReleased"},{"name":"multilineStateChanged"},{"name":"multiselectableStateChanged"},{"name":"nameChanged"},{"name":"objectAttributeChanged"},{"name":"orientationChanged"},{"name":"parentChanged"},{"name":"placeholderChanged"},{"name":"positionInSetChanged"},{"name":"rangeValueChanged"},{"name":"rangeValueMaxChanged"},{"name":"rangeValueMinChanged"},{"name":"rangeValueStepChanged"},{"name":"readonlyChanged"},{"name":"relatedNodeChanged"},{"name":"requiredStateChanged"},{"name":"roleChanged"},{"name":"rowCollapsed"},{"name":"rowCountChanged"},{"name":"rowExpanded"},{"name":"scrollHorizontalPositionChanged"},{"name":"scrollPositionChanged"},{"name":"scrollVerticalPositionChanged"},{"name":"scrolledToAnchor"},{"name":"selectedChanged"},{"name":"selectedChildrenChanged"},{"name":"selectedValueChanged"},{"name":"selection"},{"name":"selectionAdd"},{"name":"selectionRemove"},{"name":"setSizeChanged"},{"name":"show"},{"name":"sortChanged"},{"name":"stateChanged"},{"name":"subtreeCreated"},{"name":"textAttributeChanged"},{"name":"textSelectionChanged"},{"name":"textChanged"},{"name":"tooltipClosed"},{"name":"tooltipOpened"},{"name":"treeChanged"},{"name":"valueInTextFieldChanged"},{"name":"valueChanged"},{"name":"windowActivated"},{"name":"windowDeactivated"},{"name":"windowVisibilityChanged"}]},{"id":"automation.RoleType","type":"string","enum":[{"name":"abbr"},{"name":"alert"},{"name":"alertDialog"},{"name":"application"},{"name":"article"},{"name":"audio"},{"name":"banner"},{"name":"blockquote"},{"name":"button"},{"name":"canvas"},{"name":"caption"},{"name":"caret"},{"name":"cell"},{"name":"checkBox"},{"name":"client"},{"name":"code"},{"name":"colorWell"},{"name":"column"},{"name":"columnHeader"},{"name":"comboBoxGrouping"},{"name":"comboBoxMenuButton"},{"name":"comboBoxSelect"},{"name":"comment"},{"name":"complementary"},{"name":"contentDeletion"},{"name":"contentInsertion"},{"name":"contentInfo"},{"name":"date"},{"name":"dateTime"},{"name":"definition"},{"name":"descriptionList"},{"name":"descriptionListDetailDeprecated"},{"name":"descriptionListTermDeprecated"},{"name":"desktop"},{"name":"details"},{"name":"dialog"},{"name":"directoryDeprecated"},{"name":"disclosureTriangle"},{"name":"disclosureTriangleGrouped"},{"name":"docAbstract"},{"name":"docAcknowledgments"},{"name":"docAfterword"},{"name":"docAppendix"},{"name":"docBackLink"},{"name":"docBiblioEntry"},{"name":"docBibliography"},{"name":"docBiblioRef"},{"name":"docChapter"},{"name":"docColophon"},{"name":"docConclusion"},{"name":"docCover"},{"name":"docCredit"},{"name":"docCredits"},{"name":"docDedication"},{"name":"docEndnote"},{"name":"docEndnotes"},{"name":"docEpigraph"},{"name":"docEpilogue"},{"name":"docErrata"},{"name":"docExample"},{"name":"docFootnote"},{"name":"docForeword"},{"name":"docGlossary"},{"name":"docGlossRef"},{"name":"docIndex"},{"name":"docIntroduction"},{"name":"docNoteRef"},{"name":"docNotice"},{"name":"docPageBreak"},{"name":"docPageFooter"},{"name":"docPageHeader"},{"name":"docPageList"},{"name":"docPart"},{"name":"docPreface"},{"name":"docPrologue"},{"name":"docPullquote"},{"name":"docQna"},{"name":"docSubtitle"},{"name":"docTip"},{"name":"docToc"},{"name":"document"},{"name":"embeddedObject"},{"name":"emphasis"},{"name":"feed"},{"name":"figcaption"},{"name":"figure"},{"name":"footer"},{"name":"form"},{"name":"genericContainer"},{"name":"graphicsDocument"},{"name":"graphicsObject"},{"name":"graphicsSymbol"},{"name":"grid"},{"name":"gridCell"},{"name":"group"},{"name":"header"},{"name":"heading"},{"name":"iframe"},{"name":"iframePresentational"},{"name":"image"},{"name":"imeCandidate"},{"name":"inlineTextBox"},{"name":"inputTime"},{"name":"keyboard"},{"name":"labelText"},{"name":"layoutTable"},{"name":"layoutTableCell"},{"name":"layoutTableRow"},{"name":"legend"},{"name":"lineBreak"},{"name":"link"},{"name":"list"},{"name":"listBox"},{"name":"listBoxOption"},{"name":"listGrid"},{"name":"listItem"},{"name":"listMarker"},{"name":"log"},{"name":"main"},{"name":"mark"},{"name":"marquee"},{"name":"math"},{"name":"mathMLFraction"},{"name":"mathMLIdentifier"},{"name":"mathMLMath"},{"name":"mathMLMultiscripts"},{"name":"mathMLNoneScript"},{"name":"mathMLNumber"},{"name":"mathMLOperator"},{"name":"mathMLOver"},{"name":"mathMLPrescriptDelimiter"},{"name":"mathMLRoot"},{"name":"mathMLRow"},{"name":"mathMLSquareRoot"},{"name":"mathMLStringLiteral"},{"name":"mathMLSub"},{"name":"mathMLSubSup"},{"name":"mathMLSup"},{"name":"mathMLTable"},{"name":"mathMLTableCell"},{"name":"mathMLTableRow"},{"name":"mathMLText"},{"name":"mathMLUnder"},{"name":"mathMLUnderOver"},{"name":"menu"},{"name":"menuBar"},{"name":"menuItem"},{"name":"menuItemCheckBox"},{"name":"menuItemRadio"},{"name":"menuListOption"},{"name":"menuListPopup"},{"name":"meter"},{"name":"navigation"},{"name":"note"},{"name":"pane"},{"name":"paragraph"},{"name":"pdfActionableHighlight"},{"name":"pdfRoot"},{"name":"pluginObject"},{"name":"popUpButton"},{"name":"portalDeprecated"},{"name":"preDeprecated"},{"name":"progressIndicator"},{"name":"radioButton"},{"name":"radioGroup"},{"name":"region"},{"name":"rootWebArea"},{"name":"row"},{"name":"rowGroup"},{"name":"rowHeader"},{"name":"ruby"},{"name":"rubyAnnotation"},{"name":"scrollBar"},{"name":"scrollView"},{"name":"search"},{"name":"searchBox"},{"name":"section"},{"name":"sectionFooter"},{"name":"sectionHeader"},{"name":"sectionWithoutName"},{"name":"slider"},{"name":"spinButton"},{"name":"splitter"},{"name":"staticText"},{"name":"status"},{"name":"strong"},{"name":"subscript"},{"name":"suggestion"},{"name":"superscript"},{"name":"svgRoot"},{"name":"switch"},{"name":"tab"},{"name":"tabList"},{"name":"tabPanel"},{"name":"table"},{"name":"tableHeaderContainer"},{"name":"term"},{"name":"textField"},{"name":"textFieldWithComboBox"},{"name":"time"},{"name":"timer"},{"name":"titleBar"},{"name":"toggleButton"},{"name":"toolbar"},{"name":"tooltip"},{"name":"tree"},{"name":"treeGrid"},{"name":"treeItem"},{"name":"unknown"},{"name":"video"},{"name":"webView"},{"name":"window"}]},{"id":"automation.StateType","type":"string","enum":[{"name":"autofillAvailable"},{"nam)R" R"R(e":"collapsed"},{"name":"default"},{"name":"editable"},{"name":"expanded"},{"name":"focusable"},{"name":"focused"},{"name":"horizontal"},{"name":"hovered"},{"name":"ignored"},{"name":"invisible"},{"name":"linked"},{"name":"multiline"},{"name":"multiselectable"},{"name":"offscreen"},{"name":"protected"},{"name":"required"},{"name":"richlyEditable"},{"name":"vertical"},{"name":"visited"},{"name":"hasActions"},{"name":"hasInterestTarget"}]},{"id":"automation.ActionType","type":"string","enum":[{"name":"annotatePageImages"},{"name":"blur"},{"name":"clearAccessibilityFocus"},{"name":"collapse"},{"name":"customAction"},{"name":"decrement"},{"name":"doDefault"},{"name":"expand"},{"name":"focus"},{"name":"getImageData"},{"name":"getTextLocation"},{"name":"hideTooltip"},{"name":"hitTest"},{"name":"increment"},{"name":"internalInvalidateTree"},{"name":"loadInlineTextBoxes"},{"name":"longClick"},{"name":"replaceSelectedText"},{"name":"resumeMedia"},{"name":"scrollBackward"},{"name":"scrollDown"},{"name":"scrollForward"},{"name":"scrollLeft"},{"name":"scrollRight"},{"name":"scrollUp"},{"name":"scrollToMakeVisible"},{"name":"scrollToPoint"},{"name":"scrollToPositionAtRowColumn"},{"name":"setAccessibilityFocus"},{"name":"setScrollOffset"},{"name":"setSelection"},{"name":"setSequentialFocusNavigationStartingPoint"},{"name":"setValue"},{"name":"showContextMenu"},{"name":"signalEndOfTest"},{"name":"showTooltip"},{"name":"stitchChildTree"},{"name":"startDuckingMedia"},{"name":"stopDuckingMedia"},{"name":"suspendMedia"}]},{"id":"automation.TreeChangeType","type":"string","enum":[{"name":"nodeCreated"},{"name":"subtreeCreated"},{"name":"nodeChanged"},{"name":"textChanged"},{"name":"nodeRemoved"},{"name":"subtreeUpdateEnd"}]},{"id":"automation.NameFromType","type":"string","enum":[{"name":"attribute"},{"name":"attributeExplicitlyEmpty"},{"name":"caption"},{"name":"contents"},{"name":"cssAltText"},{"name":"interestTarget"},{"name":"placeholder"},{"name":"popoverTarget"},{"name":"prohibited"},{"name":"prohibitedAndRedundant"},{"name":"relatedElement"},{"name":"title"},{"name":"value"}]},{"id":"automation.DescriptionFromType","type":"string","enum":[{"name":"ariaDescription"},{"name":"attributeExplicitlyEmpty"},{"name":"buttonLabel"},{"name":"interestTarget"},{"name":"popoverTarget"},{"name":"prohibitedNameRepair"},{"name":"relatedElement"},{"name":"rubyAnnotation"},{"name":"summary"},{"name":"svgDescElement"},{"name":"tableCaption"},{"name":"title"}]},{"id":"automation.Restriction","type":"string","enum":[{"name":"disabled"},{"name":"readOnly"}]},{"id":"automation.HasPopup","type":"string","enum":[{"name":"false"},{"name":"true"},{"name":"menu"},{"name":"listbox"},{"name":"tree"},{"name":"grid"},{"name":"dialog"}]},{"id":"automation.AriaCurrentState","type":"string","enum":[{"name":"false"},{"name":"true"},{"name":"page"},{"name":"step"},{"name":"location"},{"name":"date"},{"name":"time"}]},{"id":"automation.InvalidState","type":"string","enum":[{"name":"false"},{"name":"true"}]},{"id":"automation.DefaultActionVerb","type":"string","enum":[{"name":"activate"},{"name":"check"},{"name":"click"},{"name":"clickAncestor"},{"name":"jump"},{"name":"open"},{"name":"press"},{"name":"select"},{"name":"uncheck"}]},{"id":"automation.MarkerType","type":"string","enum":[{"name":"spelling"},{"name":"grammar"},{"name":"textMatch"},{"name":"activeSuggestion"},{"name":"suggestion"},{"name":"highlight"}]},{"id":"automation.IntentCommandType","type":"string","enum":[{"name":"clearSelection"},{"name":"delete"},{"name":"dictate"},{"name":"extendSelection"},{"name":"format"},{"name":"history"},{"name":"insert"},{"name":"marker"},{"name":"moveSelection"},{"name":"setSelection"}]},{"id":"automation.IntentInputEventType","type":"string","enum":[{"name":"insertText"},{"name":"insertLineBreak"},{"name":"insertParagraph"},{"name":"insertOrderedList"},{"name":"insertUnorderedList"},{"name":"insertHorizontalRule"},{"name":"insertFromPaste"},{"name":"insertFromDrop"},{"name":"insertFromYank"},{"name":"insertTranspose"},{"name":"insertReplacementText"},{"name":"insertCompositionText"},{"name":"insertLink"},{"name":"deleteWordBackward"},{"name":"deleteWordForward"},{"name":"deleteSoftLineBackward"},{"name":"deleteSoftLineForward"},{"name":"deleteHardLineBackward"},{"name":"deleteHardLineForward"},{"name":"deleteContentBackward"},{"name":"deleteContentForward"},{"name":"deleteByCut"},{"name":"deleteByDrag"},{"name":"historyUndo"},{"name":"historyRedo"},{"name":"formatBold"},{"name":"formatItalic"},{"name":"formatUnderline"},{"name":"formatStrikeThrough"},{"name":"formatSuperscript"},{"name":"formatSubscript"},{"name":"formatJustifyCenter"},{"name":"formatJustifyFull"},{"name":"formatJustifyRight"},{"name":"formatJustifyLeft"},{"name":"formatIndent"},{"name":"formatOutdent"},{"name":"formatRemove"},{"name":"formatSetBlockTextDirection"}]},{"id":"automation.IntentTextBoundaryType","type":"string","enum":[{"name":"character"},{"name":"formatEnd"},{"name":"formatStart"},{"name":"formatStartOrEnd"},{"name":"lineEnd"},{"name":"lineStart"},{"name":"lineStartOrEnd"},{"name":"object"},{"name":"pageEnd"},{"name":"pageStart"},{"name":"pageStartOrEnd"},{"name":"paragraphEnd"},{"name":"paragraphStart"},{"name":"paragraphStartSkippingEmptyParagraphs"},{"name":"paragraphStartOrEnd"},{"name":"sentenceEnd"},{"name":"sentenceStart"},{"name":"sentenceStartOrEnd"},{"name":"webPage"},{"name":"wordEnd"},{"name":"wordStart"},{"name":"wordStartOrEnd"}]},{"id":"automation.IntentMoveDirectionType","type":"string","enum":[{"name":"backward"},{"name":"forward"}]},{"id":"automation.SortDirectionType","type":"string","enum":[{"name":"unsorted"},{"name":"ascending"},{"name":"descending"},{"name":"other"}]},{"id":"automation.PositionType","type":"string","enum":[{"name":"null"},{"name":"text"},{"name":"tree"}]},{"id":"automation.Rect","properties":{"left":{"name":"left","type":"integer"},"top":{"name":"top","type":"integer"},"width":{"name":"width","type":"integer"},"height":{"name":"height","type":"integer"}},"type":"object"},{"id":"automation.FindParams","properties":{"role":{"optional":true,"name":"role","$ref":"automation.RoleType"},"state":{"optional":true,"name":"state","type":"object","additionalProperties":{"type":"any"}},"attributes":{"optional":true,"name":"attributes","type":"object","additionalProperties":{"type":"any"}}},"type":"object"},{"id":"automation.SetDocumentSelectionParams","properties":{"anchorObject":{"name":"anchorObject","type":"object","additionalProperties":{"type":"any"},"isInstanceOf":"AutomationNode"},"anchorOffset":{"name":"anchorOffset","type":"integer"},"focusObject":{"name":"focusObject","type":"object","additionalProperties":{"type":"any"},"isInstanceOf":"AutomationNode"},"focusOffset":{"name":"focusOffset","type":"integer"}},"type":"object"},{"id":"automation.AutomationIntent","properties":{"command":{"name":"command","$ref":"automation.IntentCommandType"},"textBoundary":{"name":"textBoundary","$ref":"automation.IntentTextBoundaryType"},"moveDirection":{"name":"moveDirection","$ref":"automation.IntentMoveDirectionType"}},"type":"object"},{"id":"automation.AutomationEvent","properties":{"target":{"name":"target","$ref":"automation.AutomationNode"},"type":{"name":"type","$ref":"automation.EventType"},"eventFrom":{"name":"eventFrom","type":"string"},"mouseX":{"name":"mouseX","type":"integer"},"mouseY":{"name":"mouseY","type":"integer"},"intents":{"name":"intents","type":"array","items":{"$ref":"automation.AutomationIntent"}},"stopPropagation":{"parameters":[],"name":"stopPropagation","type":"function"}},"type":"object"},{"id":"automation.TreeChange","properties":{"target":{"name":"target","$ref":"automation.AutomationNode"},"type":{"name":"type","$ref":"automation.TreeChangeType"}},"type":"object"},{"id":"automation.TreeChangeObserverFilter","type":"string","enum":[{"name":"noTreeChanges"},{"name":"liveRegionTreeChanges"},{"name":"textMarkerChanges"},{"name":"allTreeChanges"}]},{"id":"automation.CustomAction","properties":{"id":{"name":"id","type":"integer"},"description":{"name":"description","type":"string"}},"type":"object"},{"id":"automation.Marker","properties":{"startOffset":{"name":"s)R" R"R(tartOffset","type":"integer"},"endOffset":{"name":"endOffset","type":"integer"},"flags":{"name":"flags","type":"object","additionalProperties":{"type":"any"}}},"type":"object"},{"id":"automation.AutomationPosition","properties":{"node":{"optional":true,"name":"node","$ref":"automation.AutomationNode"},"childIndex":{"name":"childIndex","type":"integer"},"textOffset":{"name":"textOffset","type":"integer"},"affinity":{"name":"affinity","type":"string"},"isNullPosition":{"parameters":[],"returns":{"name":"isNullPosition","type":"boolean"},"name":"isNullPosition","type":"function"},"isTreePosition":{"parameters":[],"returns":{"name":"isTreePosition","type":"boolean"},"name":"isTreePosition","type":"function"},"isTextPosition":{"parameters":[],"returns":{"name":"isTextPosition","type":"boolean"},"name":"isTextPosition","type":"function"},"isLeafTextPosition":{"parameters":[],"returns":{"name":"isLeafTextPosition","type":"boolean"},"name":"isLeafTextPosition","type":"function"},"atStartOfAnchor":{"parameters":[],"returns":{"name":"atStartOfAnchor","type":"boolean"},"name":"atStartOfAnchor","type":"function"},"atEndOfAnchor":{"parameters":[],"returns":{"name":"atEndOfAnchor","type":"boolean"},"name":"atEndOfAnchor","type":"function"},"atStartOfWord":{"parameters":[],"returns":{"name":"atStartOfWord","type":"boolean"},"name":"atStartOfWord","type":"function"},"atEndOfWord":{"parameters":[],"returns":{"name":"atEndOfWord","type":"boolean"},"name":"atEndOfWord","type":"function"},"atStartOfLine":{"parameters":[],"returns":{"name":"atStartOfLine","type":"boolean"},"name":"atStartOfLine","type":"function"},"atEndOfLine":{"parameters":[],"returns":{"name":"atEndOfLine","type":"boolean"},"name":"atEndOfLine","type":"function"},"atStartOfParagraph":{"parameters":[],"returns":{"name":"atStartOfParagraph","type":"boolean"},"name":"atStartOfParagraph","type":"function"},"atEndOfParagraph":{"parameters":[],"returns":{"name":"atEndOfParagraph","type":"boolean"},"name":"atEndOfParagraph","type":"function"},"atStartOfPage":{"parameters":[],"returns":{"name":"atStartOfPage","type":"boolean"},"name":"atStartOfPage","type":"function"},"atEndOfPage":{"parameters":[],"returns":{"name":"atEndOfPage","type":"boolean"},"name":"atEndOfPage","type":"function"},"atStartOfFormat":{"parameters":[],"returns":{"name":"atStartOfFormat","type":"boolean"},"name":"atStartOfFormat","type":"function"},"atEndOfFormat":{"parameters":[],"returns":{"name":"atEndOfFormat","type":"boolean"},"name":"atEndOfFormat","type":"function"},"atStartOfDocument":{"parameters":[],"returns":{"name":"atStartOfDocument","type":"boolean"},"name":"atStartOfDocument","type":"function"},"atEndOfDocument":{"parameters":[],"returns":{"name":"atEndOfDocument","type":"boolean"},"name":"atEndOfDocument","type":"function"},"asTreePosition":{"parameters":[],"name":"asTreePosition","type":"function"},"asTextPosition":{"parameters":[],"name":"asTextPosition","type":"function"},"asLeafTextPosition":{"parameters":[],"name":"asLeafTextPosition","type":"function"},"moveToPositionAtStartOfAnchor":{"parameters":[],"name":"moveToPositionAtStartOfAnchor","type":"function"},"moveToPositionAtEndOfAnchor":{"parameters":[],"name":"moveToPositionAtEndOfAnchor","type":"function"},"moveToPositionAtStartOfDocument":{"parameters":[],"name":"moveToPositionAtStartOfDocument","type":"function"},"moveToPositionAtEndOfDocument":{"parameters":[],"name":"moveToPositionAtEndOfDocument","type":"function"},"moveToParentPosition":{"parameters":[],"name":"moveToParentPosition","type":"function"},"moveToNextLeafTreePosition":{"parameters":[],"name":"moveToNextLeafTreePosition","type":"function"},"moveToPreviousLeafTreePosition":{"parameters":[],"name":"moveToPreviousLeafTreePosition","type":"function"},"moveToNextLeafTextPosition":{"parameters":[],"name":"moveToNextLeafTextPosition","type":"function"},"moveToPreviousLeafTextPosition":{"parameters":[],"name":"moveToPreviousLeafTextPosition","type":"function"},"moveToNextCharacterPosition":{"parameters":[],"name":"moveToNextCharacterPosition","type":"function"},"moveToPreviousCharacterPosition":{"parameters":[],"name":"moveToPreviousCharacterPosition","type":"function"},"moveToNextWordStartPosition":{"parameters":[],"name":"moveToNextWordStartPosition","type":"function"},"moveToPreviousWordStartPosition":{"parameters":[],"name":"moveToPreviousWordStartPosition","type":"function"},"moveToNextWordEndPosition":{"parameters":[],"name":"moveToNextWordEndPosition","type":"function"},"moveToPreviousWordEndPosition":{"parameters":[],"name":"moveToPreviousWordEndPosition","type":"function"},"moveToNextLineStartPosition":{"parameters":[],"name":"moveToNextLineStartPosition","type":"function"},"moveToPreviousLineStartPosition":{"parameters":[],"name":"moveToPreviousLineStartPosition","type":"function"},"moveToNextLineEndPosition":{"parameters":[],"name":"moveToNextLineEndPosition","type":"function"},"moveToPreviousLineEndPosition":{"parameters":[],"name":"moveToPreviousLineEndPosition","type":"function"},"moveToNextFormatStartPosition":{"parameters":[],"name":"moveToNextFormatStartPosition","type":"function"},"moveToPreviousFormatStartPosition":{"parameters":[],"name":"moveToPreviousFormatStartPosition","type":"function"},"moveToNextFormatEndPosition":{"parameters":[],"name":"moveToNextFormatEndPosition","type":"function"},"moveToPreviousFormatEndPosition":{"parameters":[],"name":"moveToPreviousFormatEndPosition","type":"function"},"moveToNextParagraphStartPosition":{"parameters":[],"name":"moveToNextParagraphStartPosition","type":"function"},"moveToPreviousParagraphStartPosition":{"parameters":[],"name":"moveToPreviousParagraphStartPosition","type":"function"},"moveToNextParagraphEndPosition":{"parameters":[],"name":"moveToNextParagraphEndPosition","type":"function"},"moveToPreviousParagraphEndPosition":{"parameters":[],"name":"moveToPreviousParagraphEndPosition","type":"function"},"moveToNextPageStartPosition":{"parameters":[],"name":"moveToNextPageStartPosition","type":"function"},"moveToPreviousPageStartPosition":{"parameters":[],"name":"moveToPreviousPageStartPosition","type":"function"},"moveToNextPageEndPosition":{"parameters":[],"name":"moveToNextPageEndPosition","type":"function"},"moveToPreviousPageEndPosition":{"parameters":[],"name":"moveToPreviousPageEndPosition","type":"function"},"moveToNextAnchorPosition":{"parameters":[],"name":"moveToNextAnchorPosition","type":"function"},"moveToPreviousAnchorPosition":{"parameters":[],"name":"moveToPreviousAnchorPosition","type":"function"},"maxTextOffset":{"parameters":[],"returns":{"name":"maxTextOffset","type":"integer"},"name":"maxTextOffset","type":"function"},"isInLineBreak":{"parameters":[],"returns":{"name":"isInLineBreak","type":"boolean"},"name":"isInLineBreak","type":"function"},"isInTextObject":{"parameters":[],"returns":{"name":"isInTextObject","type":"boolean"},"name":"isInTextObject","type":"function"},"isInWhiteSpace":{"parameters":[],"returns":{"name":"isInWhiteSpace","type":"boolean"},"name":"isInWhiteSpace","type":"function"},"isValid":{"parameters":[],"returns":{"name":"isValid","type":"boolean"},"name":"isValid","type":"function"},"getText":{"parameters":[],"returns":{"name":"getText","type":"string"},"name":"getText","type":"function"}},"type":"object"},{"id":"automation.AutomationNode","properties":{"root":{"optional":true,"name":"root","$ref":"automation.AutomationNode"},"isRootNode":{"name":"isRootNode","type":"boolean"},"role":{"optional":true,"name":"role","$ref":"automation.RoleType"},"state":{"optional":true,"name":"state","type":"object","additionalProperties":{"type":"any"}},"location":{"name":"location","$ref":"automation.Rect"},"boundsForRange":{"parameters":[{"name":"startIndex","type":"integer"},{"name":"endIndex","type":"integer"},{"name":"callback","parameters":[{"name":"bounds","$ref":"automation.Rect"}],"type":"function"}],"name":"boundsForRange","type":"function"},"unclippedBoundsForRange":{"parameters":[{"name":"startIndex","type":"integer"},{"name":"endIndex","type":"integer"},{"name":"callback","parameters":[{"name":"bounds","$ref":"automation.Rect"}],"type":"function"}],"name":"unclippedBoundsForRange","type":)R" R"R("function"},"unclippedLocation":{"optional":true,"name":"unclippedLocation","$ref":"automation.Rect"},"description":{"optional":true,"name":"description","type":"string"},"checkedStateDescription":{"optional":true,"name":"checkedStateDescription","type":"string"},"placeholder":{"optional":true,"name":"placeholder","type":"string"},"roleDescription":{"optional":true,"name":"roleDescription","type":"string"},"name":{"optional":true,"name":"name","type":"string"},"doDefaultLabel":{"optional":true,"name":"doDefaultLabel","type":"string"},"longClickLabel":{"optional":true,"name":"longClickLabel","type":"string"},"tooltip":{"optional":true,"name":"tooltip","type":"string"},"nameFrom":{"optional":true,"name":"nameFrom","$ref":"automation.NameFromType"},"imageAnnotation":{"optional":true,"name":"imageAnnotation","type":"string"},"value":{"optional":true,"name":"value","type":"string"},"htmlId":{"optional":true,"name":"htmlId","type":"string"},"htmlTag":{"optional":true,"name":"htmlTag","type":"string"},"hierarchicalLevel":{"optional":true,"name":"hierarchicalLevel","type":"integer"},"caretBounds":{"optional":true,"name":"caretBounds","$ref":"automation.Rect"},"wordStarts":{"optional":true,"name":"wordStarts","type":"array","items":{"type":"integer"}},"wordEnds":{"optional":true,"name":"wordEnds","type":"array","items":{"type":"integer"}},"sentenceStarts":{"optional":true,"name":"sentenceStarts","type":"array","items":{"type":"integer"}},"sentenceEnds":{"optional":true,"name":"sentenceEnds","type":"array","items":{"type":"integer"}},"nonInlineTextWordStarts":{"optional":true,"name":"nonInlineTextWordStarts","type":"array","items":{"type":"integer"}},"nonInlineTextWordEnds":{"optional":true,"name":"nonInlineTextWordEnds","type":"array","items":{"type":"integer"}},"controls":{"optional":true,"name":"controls","type":"array","items":{"$ref":"automation.AutomationNode"}},"describedBy":{"optional":true,"name":"describedBy","type":"array","items":{"$ref":"automation.AutomationNode"}},"flowTo":{"optional":true,"name":"flowTo","type":"array","items":{"$ref":"automation.AutomationNode"}},"labelledBy":{"optional":true,"name":"labelledBy","type":"array","items":{"$ref":"automation.AutomationNode"}},"activeDescendant":{"optional":true,"name":"activeDescendant","$ref":"automation.AutomationNode"},"activeDescendantFor":{"optional":true,"name":"activeDescendantFor","type":"array","items":{"$ref":"automation.AutomationNode"}},"inPageLinkTarget":{"optional":true,"name":"inPageLinkTarget","$ref":"automation.AutomationNode"},"details":{"optional":true,"name":"details","type":"array","items":{"$ref":"automation.AutomationNode"}},"errorMessages":{"optional":true,"name":"errorMessages","type":"array","items":{"$ref":"automation.AutomationNode"}},"detailsFor":{"optional":true,"name":"detailsFor","type":"array","items":{"$ref":"automation.AutomationNode"}},"errorMessageFor":{"optional":true,"name":"errorMessageFor","type":"array","items":{"$ref":"automation.AutomationNode"}},"controlledBy":{"optional":true,"name":"controlledBy","type":"array","items":{"$ref":"automation.AutomationNode"}},"descriptionFor":{"optional":true,"name":"descriptionFor","type":"array","items":{"$ref":"automation.AutomationNode"}},"flowFrom":{"optional":true,"name":"flowFrom","type":"array","items":{"$ref":"automation.AutomationNode"}},"labelFor":{"optional":true,"name":"labelFor","type":"array","items":{"$ref":"automation.AutomationNode"}},"tableCellColumnHeaders":{"optional":true,"name":"tableCellColumnHeaders","type":"array","items":{"$ref":"automation.AutomationNode"}},"tableCellRowHeaders":{"optional":true,"name":"tableCellRowHeaders","type":"array","items":{"$ref":"automation.AutomationNode"}},"standardActions":{"optional":true,"name":"standardActions","type":"array","items":{"$ref":"automation.ActionType"}},"customActions":{"optional":true,"name":"customActions","type":"array","items":{"$ref":"automation.CustomAction"}},"defaultActionVerb":{"optional":true,"name":"defaultActionVerb","$ref":"automation.DefaultActionVerb"},"url":{"optional":true,"name":"url","type":"string"},"docUrl":{"optional":true,"name":"docUrl","type":"string"},"docTitle":{"optional":true,"name":"docTitle","type":"string"},"docLoaded":{"optional":true,"name":"docLoaded","type":"boolean"},"docLoadingProgress":{"optional":true,"name":"docLoadingProgress","type":"number"},"scrollX":{"optional":true,"name":"scrollX","type":"integer"},"scrollXMin":{"optional":true,"name":"scrollXMin","type":"integer"},"scrollXMax":{"optional":true,"name":"scrollXMax","type":"integer"},"scrollY":{"optional":true,"name":"scrollY","type":"integer"},"scrollYMin":{"optional":true,"name":"scrollYMin","type":"integer"},"scrollYMax":{"optional":true,"name":"scrollYMax","type":"integer"},"scrollable":{"optional":true,"name":"scrollable","type":"boolean"},"textSelStart":{"optional":true,"name":"textSelStart","type":"integer"},"textSelEnd":{"optional":true,"name":"textSelEnd","type":"integer"},"markers":{"optional":true,"name":"markers","type":"array","items":{"$ref":"automation.Marker"}},"isSelectionBackward":{"optional":true,"name":"isSelectionBackward","type":"boolean"},"anchorObject":{"optional":true,"name":"anchorObject","$ref":"automation.AutomationNode"},"anchorOffset":{"optional":true,"name":"anchorOffset","type":"integer"},"anchorAffinity":{"optional":true,"name":"anchorAffinity","type":"string"},"focusObject":{"optional":true,"name":"focusObject","$ref":"automation.AutomationNode"},"focusOffset":{"optional":true,"name":"focusOffset","type":"integer"},"focusAffinity":{"optional":true,"name":"focusAffinity","type":"string"},"selectionStartObject":{"optional":true,"name":"selectionStartObject","$ref":"automation.AutomationNode"},"selectionStartOffset":{"optional":true,"name":"selectionStartOffset","type":"integer"},"selectionStartAffinity":{"optional":true,"name":"selectionStartAffinity","type":"string"},"selectionEndObject":{"optional":true,"name":"selectionEndObject","$ref":"automation.AutomationNode"},"selectionEndOffset":{"optional":true,"name":"selectionEndOffset","type":"integer"},"selectionEndAffinity":{"optional":true,"name":"selectionEndAffinity","type":"string"},"notUserSelectableStyle":{"optional":true,"name":"notUserSelectableStyle","type":"boolean"},"valueForRange":{"optional":true,"name":"valueForRange","type":"number"},"minValueForRange":{"optional":true,"name":"minValueForRange","type":"number"},"maxValueForRange":{"optional":true,"name":"maxValueForRange","type":"number"},"posInSet":{"optional":true,"name":"posInSet","type":"integer"},"setSize":{"optional":true,"name":"setSize","type":"integer"},"tableRowCount":{"optional":true,"name":"tableRowCount","type":"integer"},"ariaRowCount":{"optional":true,"name":"ariaRowCount","type":"integer"},"tableColumnCount":{"optional":true,"name":"tableColumnCount","type":"integer"},"ariaColumnCount":{"optional":true,"name":"ariaColumnCount","type":"integer"},"tableCellColumnIndex":{"optional":true,"name":"tableCellColumnIndex","type":"integer"},"tableCellAriaColumnIndex":{"optional":true,"name":"tableCellAriaColumnIndex","type":"integer"},"tableCellColumnSpan":{"optional":true,"name":"tableCellColumnSpan","type":"integer"},"tableCellRowIndex":{"optional":true,"name":"tableCellRowIndex","type":"integer"},"tableCellAriaRowIndex":{"optional":true,"name":"tableCellAriaRowIndex","type":"integer"},"tableCellRowSpan":{"optional":true,"name":"tableCellRowSpan","type":"integer"},"tableColumnHeader":{"optional":true,"name":"tableColumnHeader","$ref":"automation.AutomationNode"},"tableRowHeader":{"optional":true,"name":"tableRowHeader","$ref":"automation.AutomationNode"},"tableColumnIndex":{"optional":true,"name":"tableColumnIndex","type":"integer"},"tableRowIndex":{"optional":true,"name":"tableRowIndex","type":"integer"},"liveStatus":{"optional":true,"name":"liveStatus","type":"string"},"liveRelevant":{"optional":true,"name":"liveRelevant","type":"string"},"liveAtomic":{"optional":true,"name":"liveAtomic","type":"boolean"},"busy":{"optional":true,"name":"busy","type":"boolean"},"containerLiveStatus":{"optional":true,"name":"containerLiveStatus","type":"string"},"containerLiveRelevant":{"optional":true,)R" R"R("name":"containerLiveRelevant","type":"string"},"containerLiveAtomic":{"optional":true,"name":"containerLiveAtomic","type":"boolean"},"containerLiveBusy":{"optional":true,"name":"containerLiveBusy","type":"boolean"},"isButton":{"name":"isButton","type":"boolean"},"isCheckBox":{"name":"isCheckBox","type":"boolean"},"isComboBox":{"name":"isComboBox","type":"boolean"},"isImage":{"name":"isImage","type":"boolean"},"hasHiddenOffscreenNodes":{"name":"hasHiddenOffscreenNodes","type":"boolean"},"autoComplete":{"optional":true,"name":"autoComplete","type":"string"},"className":{"optional":true,"name":"className","type":"string"},"modal":{"optional":true,"name":"modal","type":"boolean"},"inputType":{"optional":true,"name":"inputType","type":"string"},"accessKey":{"optional":true,"name":"accessKey","type":"string"},"ariaInvalidValue":{"optional":true,"name":"ariaInvalidValue","type":"string"},"display":{"optional":true,"name":"display","type":"string"},"imageDataUrl":{"optional":true,"name":"imageDataUrl","type":"string"},"language":{"optional":true,"name":"language","type":"string"},"detectedLanguage":{"optional":true,"name":"detectedLanguage","type":"string"},"hasPopup":{"optional":true,"name":"hasPopup","$ref":"automation.HasPopup"},"restriction":{"optional":true,"name":"restriction","type":"string"},"checked":{"optional":true,"name":"checked","type":"string"},"innerHtml":{"optional":true,"name":"innerHtml","type":"string"},"color":{"optional":true,"name":"color","type":"integer"},"backgroundColor":{"optional":true,"name":"backgroundColor","type":"integer"},"colorValue":{"optional":true,"name":"colorValue","type":"integer"},"subscript":{"name":"subscript","type":"boolean"},"superscript":{"name":"superscript","type":"boolean"},"bold":{"name":"bold","type":"boolean"},"italic":{"name":"italic","type":"boolean"},"underline":{"name":"underline","type":"boolean"},"lineThrough":{"name":"lineThrough","type":"boolean"},"selected":{"optional":true,"name":"selected","type":"boolean"},"fontSize":{"optional":true,"name":"fontSize","type":"integer"},"fontFamily":{"name":"fontFamily","type":"string"},"nonAtomicTextFieldRoot":{"name":"nonAtomicTextFieldRoot","type":"boolean"},"ariaCurrentState":{"optional":true,"name":"ariaCurrentState","$ref":"automation.AriaCurrentState"},"invalidState":{"optional":true,"name":"invalidState","$ref":"automation.InvalidState"},"appId":{"optional":true,"name":"appId","type":"string"},"children":{"name":"children","type":"array","items":{"$ref":"automation.AutomationNode"}},"parent":{"optional":true,"name":"parent","$ref":"automation.AutomationNode"},"firstChild":{"optional":true,"name":"firstChild","$ref":"automation.AutomationNode"},"lastChild":{"optional":true,"name":"lastChild","$ref":"automation.AutomationNode"},"previousSibling":{"optional":true,"name":"previousSibling","$ref":"automation.AutomationNode"},"nextSibling":{"optional":true,"name":"nextSibling","$ref":"automation.AutomationNode"},"previousOnLine":{"optional":true,"name":"previousOnLine","$ref":"automation.AutomationNode"},"nextOnLine":{"optional":true,"name":"nextOnLine","$ref":"automation.AutomationNode"},"previousFocus":{"optional":true,"name":"previousFocus","$ref":"automation.AutomationNode"},"nextFocus":{"optional":true,"name":"nextFocus","$ref":"automation.AutomationNode"},"previousWindowFocus":{"optional":true,"name":"previousWindowFocus","$ref":"automation.AutomationNode"},"nextWindowFocus":{"optional":true,"name":"nextWindowFocus","$ref":"automation.AutomationNode"},"indexInParent":{"optional":true,"name":"indexInParent","type":"integer"},"sortDirection":{"name":"sortDirection","$ref":"automation.SortDirectionType"},"clickable":{"name":"clickable","type":"boolean"},"doDefault":{"parameters":[],"name":"doDefault","type":"function"},"focus":{"parameters":[],"name":"focus","type":"function"},"getImageData":{"parameters":[{"name":"maxWidth","type":"integer"},{"name":"maxHeight","type":"integer"}],"name":"getImageData","type":"function"},"hitTest":{"parameters":[{"name":"x","type":"integer"},{"name":"y","type":"integer"},{"name":"eventToFire","$ref":"automation.EventType"}],"name":"hitTest","type":"function"},"hitTestWithReply":{"parameters":[{"name":"x","type":"integer"},{"name":"y","type":"integer"},{"name":"callback","parameters":[{"name":"node","$ref":"automation.AutomationNode"}],"type":"function"}],"name":"hitTestWithReply","type":"function"},"makeVisible":{"parameters":[],"name":"makeVisible","type":"function"},"performCustomAction":{"parameters":[{"name":"customActionId","type":"integer"}],"name":"performCustomAction","type":"function"},"performStandardAction":{"parameters":[{"name":"actionType","$ref":"automation.ActionType"}],"name":"performStandardAction","type":"function"},"replaceSelectedText":{"parameters":[{"name":"value","type":"string"}],"name":"replaceSelectedText","type":"function"},"setAccessibilityFocus":{"parameters":[],"name":"setAccessibilityFocus","type":"function"},"setSelection":{"parameters":[{"name":"startIndex","type":"integer"},{"name":"endIndex","type":"integer"}],"name":"setSelection","type":"function"},"setSequentialFocusNavigationStartingPoint":{"parameters":[],"name":"setSequentialFocusNavigationStartingPoint","type":"function"},"setValue":{"parameters":[{"name":"value","type":"string"}],"name":"setValue","type":"function"},"showContextMenu":{"parameters":[],"name":"showContextMenu","type":"function"},"resumeMedia":{"parameters":[],"name":"resumeMedia","type":"function"},"startDuckingMedia":{"parameters":[],"name":"startDuckingMedia","type":"function"},"stopDuckingMedia":{"parameters":[],"name":"stopDuckingMedia","type":"function"},"suspendMedia":{"parameters":[],"name":"suspendMedia","type":"function"},"longClick":{"parameters":[],"name":"longClick","type":"function"},"scrollBackward":{"parameters":[{"name":"callback","optional":true,"parameters":[{"name":"result","type":"boolean"}],"type":"function"}],"name":"scrollBackward","type":"function"},"scrollForward":{"parameters":[{"name":"callback","optional":true,"parameters":[{"name":"result","type":"boolean"}],"type":"function"}],"name":"scrollForward","type":"function"},"scrollUp":{"parameters":[{"name":"callback","optional":true,"parameters":[{"name":"result","type":"boolean"}],"type":"function"}],"name":"scrollUp","type":"function"},"scrollDown":{"parameters":[{"name":"callback","optional":true,"parameters":[{"name":"result","type":"boolean"}],"type":"function"}],"name":"scrollDown","type":"function"},"scrollLeft":{"parameters":[{"name":"callback","optional":true,"parameters":[{"name":"result","type":"boolean"}],"type":"function"}],"name":"scrollLeft","type":"function"},"scrollRight":{"parameters":[{"name":"callback","optional":true,"parameters":[{"name":"result","type":"boolean"}],"type":"function"}],"name":"scrollRight","type":"function"},"scrollToPoint":{"parameters":[{"name":"x","type":"integer"},{"name":"y","type":"integer"}],"name":"scrollToPoint","type":"function"},"setScrollOffset":{"parameters":[{"name":"x","type":"integer"},{"name":"y","type":"integer"}],"name":"setScrollOffset","type":"function"},"addEventListener":{"parameters":[{"name":"eventType","$ref":"automation.EventType"},{"name":"listener","parameters":[{"name":"event","$ref":"automation.AutomationEvent"}],"type":"function"},{"name":"capture","type":"boolean"}],"name":"addEventListener","type":"function"},"removeEventListener":{"parameters":[{"name":"eventType","$ref":"automation.EventType"},{"name":"listener","parameters":[{"name":"event","$ref":"automation.AutomationEvent"}],"type":"function"},{"name":"capture","type":"boolean"}],"name":"removeEventListener","type":"function"},"find":{"parameters":[{"name":"params","$ref":"automation.FindParams"}],"returns":{"name":"find","$ref":"automation.AutomationNode","optional":true},"name":"find","type":"function"},"findAll":{"parameters":[{"name":"params","$ref":"automation.FindParams"}],"returns":{"name":"findAll","type":"array","items":{"$ref":"automation.AutomationNode"}},"name":"findAll","type":"function"},"matches":{"parameters":[{"name":"params","$ref":"automation.FindParams"}],"returns":{"name":"matches","type":"boolean"},"name":"matches","type":"fun)R" R"R(ction"},"getNextTextMatch":{"parameters":[{"name":"searchStr","type":"string"},{"name":"backward","type":"boolean"}],"returns":{"name":"getNextTextMatch","$ref":"automation.AutomationNode","optional":true},"name":"getNextTextMatch","type":"function"},"createPosition":{"parameters":[{"name":"type","$ref":"automation.PositionType"},{"name":"offset","type":"integer"},{"name":"isUpstream","optional":true,"type":"boolean"}],"returns":{"name":"createPosition","$ref":"automation.AutomationPosition","optional":true},"name":"createPosition","type":"function"}},"type":"object"}],"functions":[{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"rootNode","$ref":"automation.AutomationNode"}]},"name":"getDesktop","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"focusedNode","$ref":"automation.AutomationNode"}]},"name":"getFocus","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"focusedNode","$ref":"automation.AutomationNode"}]},"name":"getAccessibilityFocus","type":"function"},{"parameters":[{"name":"filter","$ref":"automation.TreeChangeObserverFilter"},{"name":"observer","parameters":[{"name":"treeChange","$ref":"automation.TreeChange"}],"type":"function"}],"name":"addTreeChangeObserver","type":"function"},{"parameters":[{"name":"observer","parameters":[{"name":"treeChange","$ref":"automation.TreeChange"}],"type":"function"}],"name":"removeTreeChangeObserver","type":"function"},{"parameters":[{"name":"params","$ref":"automation.SetDocumentSelectionParams"}],"name":"setDocumentSelection","type":"function"}],"properties":{},"events":[],"platforms":null,"deprecated":null})R";
constexpr char kAutomationInternal[] = R"R({"namespace":"automationInternal","types":[{"id":"automationInternal.AXEventParams","properties":{"treeID":{"name":"treeID","type":"string"},"targetID":{"name":"targetID","type":"integer"},"eventType":{"name":"eventType","type":"string"},"eventFrom":{"name":"eventFrom","type":"string"},"mouseX":{"name":"mouseX","type":"number"},"mouseY":{"name":"mouseY","type":"number"},"actionRequestID":{"name":"actionRequestID","type":"integer"}},"type":"object"},{"id":"automationInternal.AXTextLocationParams","properties":{"treeID":{"name":"treeID","type":"string"},"nodeID":{"name":"nodeID","type":"integer"},"result":{"name":"result","type":"boolean"},"left":{"name":"left","type":"integer"},"top":{"name":"top","type":"integer"},"width":{"name":"width","type":"integer"},"height":{"name":"height","type":"integer"},"requestID":{"name":"requestID","type":"integer"}},"type":"object"},{"id":"automationInternal.PerformActionRequiredParams","properties":{"treeID":{"name":"treeID","type":"string"},"automationNodeID":{"name":"automationNodeID","type":"integer"},"actionType":{"name":"actionType","type":"string"},"requestID":{"optional":true,"name":"requestID","type":"integer"}},"type":"object"},{"id":"automationInternal.PerformCustomActionParams","properties":{"customActionID":{"name":"customActionID","type":"integer"}},"type":"object"},{"id":"automationInternal.SetSelectionParams","properties":{"focusNodeID":{"name":"focusNodeID","type":"integer"},"anchorOffset":{"name":"anchorOffset","type":"integer"},"focusOffset":{"name":"focusOffset","type":"integer"}},"type":"object"},{"id":"automationInternal.ReplaceSelectedTextParams","properties":{"value":{"name":"value","type":"string"}},"type":"object"},{"id":"automationInternal.SetValueParams","properties":{"value":{"name":"value","type":"string"}},"type":"object"},{"id":"automationInternal.ScrollToPointParams","properties":{"x":{"name":"x","type":"integer"},"y":{"name":"y","type":"integer"}},"type":"object"},{"id":"automationInternal.ScrollToPositionAtRowColumnParams","properties":{"row":{"name":"row","type":"integer"},"column":{"name":"column","type":"integer"}},"type":"object"},{"id":"automationInternal.SetScrollOffsetParams","properties":{"x":{"name":"x","type":"integer"},"y":{"name":"y","type":"integer"}},"type":"object"},{"id":"automationInternal.GetImageDataParams","properties":{"maxWidth":{"name":"maxWidth","type":"integer"},"maxHeight":{"name":"maxHeight","type":"integer"}},"type":"object"},{"id":"automationInternal.HitTestParams","properties":{"x":{"name":"x","type":"integer"},"y":{"name":"y","type":"integer"},"eventToFire":{"name":"eventToFire","type":"string"}},"type":"object"},{"id":"automationInternal.GetTextLocationDataParams","properties":{"startIndex":{"name":"startIndex","type":"integer"},"endIndex":{"name":"endIndex","type":"integer"}},"type":"object"}],"functions":[{"parameters":[{"name":"tree_id","type":"string"}],"name":"enableTree","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"tree_id","type":"string"}]},"name":"enableDesktop","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[]},"name":"disableDesktop","type":"function"},{"parameters":[{"name":"args","$ref":"automationInternal.PerformActionRequiredParams"},{"name":"opt_args","type":"object","additionalProperties":{"type":"any"}}],"name":"performAction","type":"function"}],"properties":{},"events":[{"parameters":[{"name":"update","$ref":"automationInternal.AXEventParams"}],"name":"onAccessibilityEvent","type":"function"},{"parameters":[{"name":"treeID","type":"string"}],"name":"onAccessibilityTreeDestroyed","type":"function"},{"parameters":[{"name":"params","$ref":"automationInternal.AXTextLocationParams"}],"name":"onGetTextLocationResult","type":"function"},{"parameters":[{"name":"observerID","type":"integer"},{"name":"treeID","type":"string"},{"name":"nodeID","type":"integer"},{"name":"changeType","type":"string"}],"name":"onTreeChange","type":"function"},{"parameters":[{"name":"treeID","type":"string"}],"name":"onChildTreeID","type":"function"},{"parameters":[{"name":"treeID","type":"string"},{"name":"nodeIDs","type":"array","items":{"type":"integer"}}],"name":"onNodesRemoved","type":"function"},{"parameters":[{"name":"treeID","type":"string"}],"name":"onAccessibilityTreeSerializationError","type":"function"},{"parameters":[{"name":"treeID","type":"string"},{"name":"requestID","type":"integer"},{"name":"result","type":"boolean"}],"name":"onActionResult","type":"function"},{"parameters":[],"name":"onAllAutomationEventListenersRemoved","type":"function"}],"platforms":null,"deprecated":null})R";
constexpr char kCecPrivate[] = R"R({"namespace":"cecPrivate","types":[{"id":"cecPrivate.DisplayCecPowerState","type":"string","enum":[{"name":"error"},{"name":"adapterNotConfigured"},{"name":"noDevice"},{"name":"on"},{"name":"standby"},{"name":"transitioningToOn"},{"name":"transitioningToStandby"},{"name":"unknown"}]}],"functions":[{"parameters":[],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"sendStandBy","type":"function"},{"parameters":[],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"sendWakeUp","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"powerStates","type":"array","items":{"$ref":"cecPrivate.DisplayCecPowerState"}}]},"name":"queryDisplayCecPowerState","type":"function"}],"properties":{},"events":[],"platforms":["chromeos"],"deprecated":null})R";
constexpr char kClipboard[] = R"R({"namespace":"clipboard","types":[{"id":"clipboard.ImageType","type":"string","enum":[{"name":"png"},{"name":"jpeg"}]},{"id":"clipboard.DataItemType","type":"string","enum":[{"name":"textPlain"},{"name":"textHtml"}]},{"id":"clipboard.AdditionalDataItem","properties":{"type":{"name":"type","$ref":"clipboard.DataItemType"},"data":{"name":"data","type":"string"}},"type":"object"}],"functions":[{"parameters":[{"name":"imageData","type":"binary","isInstanceOf":"ArrayBuffer"},{"name":"type","$ref":"clipboard.ImageType"},{"name":"additionalItems","optional":true,"type":"array","items":{"$ref":"clipboard.AdditionalDataItem"}}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"setImageData","type":"function"}],"properties":{},"events":[{"parameters":[],"name":"onClipboardDataChanged","type":"function"}],"platforms":["chromeos"],"deprecated":null})R";
constexpr char kDns[] = R"R({"namespace":"dns","types":[{"id":"dns.ResolveCallbackResolveInfo","properties":{"resultCode":{"name":"resultCode","type":"integer"},"address":{"optional":true,"name":"address","type":"string"}},"type":"object"}],"functions":[{"parameters":[{"name":"hostname","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"resolveInfo","$ref":"dns.ResolveCallbackResolveInfo"}]},"name":"resolve","type":"function"}],"properties":{},"events":[],"platforms":null,"deprecated":null})R";
constexpr char kEvents[] = R"R({"namespace":"events","types":[{"id":"events.Rule","type":"object","properties":{"id":{"type":"string","optional":true},"tags":{"type":"array","items":{"type":"string"},"optional":true},"conditions":{"type":"array","items":{"type":"any"}},"actions":{"type":"array","items":{"type":"any"}},"priority":{"type":"integer","optional":true}}},{"id":"events.Event","type":"object","additionalProperties":{"type":"any"},"functions":[{"name":"addListener","type":"function","parameters":[{"name":"callback","type":"function"}]},{"name":"removeListener","type":"function","parameters":[{"name":"callback","type":"function"}]},{"name":"hasListener","type":"function","parameters":[{"name":"callback","type":"function"}],"returns":{"type":"boolean"}},{"name":"hasListeners","type":"function","parameters":[],"returns":{"type":"boolean"}},{"name":"addRules","type":"function","parameters":[{"nodoc":"true","name":"eventName","type":"string"},{"name":"webViewInstanceId","type":"integer"},{"name":"rules","type":"array","items":{"$ref":"events.Rule"}}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"rules","type":"array","items":{"$ref":"events.Rule"}}],"does_not_support_promises":"Related custom hooks do not handle promises crbug.com/1520656"}},{"name":"getRules","type":"function","parameters":[{"nodoc":"true","name":"eventName","type":"string"},{"name":"webViewInstanceId","type":"integer"},{"name":"ruleIdentifiers","optional":true,"type":"array","items":{"type":"string"}}],"returns_async":{"name":"callback","parameters":[{"name":"rules","type":"array","items":{"$ref":"events.Rule"}}],"does_not_support_promises":"Related custom hooks do not handle promises crbug.com/1520656"}},{"name":"removeRules","type":"function","parameters":[{"nodoc":"true","name":"eventName","type":"string"},{"name":"webViewInstanceId","type":"integer"},{"name":"ruleIdentifiers","optional":true,"type":"array","items":{"type":"string"}}],"returns_async":{"name":"callback","optional":true,"parameters":[],"does_not_support_promises":"Related custom hooks do not handle promises crbug.com/1520656"}}]},{"id":"events.UrlFilter","type":"object","properties":{"hostContains":{"type":"string","optional":true},"hostEquals":{"type":"string","optional":true},"hostPrefix":{"type":"string","optional":true},"hostSuffix":{"type":"string","optional":true},"pathContains":{"type":"string","optional":true},"pathEquals":{"type":"string","optional":true},"pathPrefix":{"type":"string","optional":true},"pathSuffix":{"type":"string","optional":true},"queryContains":{"type":"string","optional":true},"queryEquals":{"type":"string","optional":true},"queryPrefix":{"type":"string","optional":true},"querySuffix":{"type":"string","optional":true},"urlContains":{"type":"string","optional":true},"urlEquals":{"type":"string","optional":true},"urlMatches":{"type":"string","optional":true},"originAndPathMatches":{"type":"string","optional":true},"urlPrefix":{"type":"string","optional":true},"urlSuffix":{"type":"string","optional":true},"schemes":{"type":"array","optional":true,"items":{"type":"string"}},"ports":{"type":"array","optional":true,"items":{"choices":[{"type":"integer"},{"type":"array","items":{"type":"integer"}}]}},"cidrBlocks":{"type":"array","items":{"type":"string"},"optional":true}}}]})R";
constexpr char kExtensionOptionsInternal[] = R"R({"namespace":"extensionOptionsInternal","types":[{"id":"extensionOptionsInternal.SizeChangedOptions","properties":{"oldWidth":{"name":"oldWidth","type":"integer"},"oldHeight":{"name":"oldHeight","type":"integer"},"newWidth":{"name":"newWidth","type":"integer"},"newHeight":{"name":"newHeight","type":"integer"}},"type":"object"},{"id":"extensionOptionsInternal.PreferredSizeChangedOptions","properties":{"width":{"name":"width","type":"number"},"height":{"name":"height","type":"number"}},"type":"object"}],"functions":[],"properties":{},"events":[{"parameters":[],"name":"onClose","type":"function"},{"parameters":[],"name":"onLoad","type":"function"},{"parameters":[{"name":"options","$ref":"extensionOptionsInternal.PreferredSizeChangedOptions"}],"name":"onPreferredSizeChanged","type":"function"}],"platforms":null,"deprecated":null})R";
constexpr char kFileHandlers[] = R"R({"namespace":"fileHandlers","types":[{"id":"fileHandlers.Icon","properties":{"src":{"name":"src","type":"string"},"sizes":{"optional":true,"name":"sizes","type":"string"},"type":{"optional":true,"name":"type","type":"string"}},"type":"object"},{"id":"fileHandlers.FileHandler","properties":{"accept":{"name":"accept","type":"object","additionalProperties":{"type":"any"}},"action":{"name":"action","type":"string"},"name":{"name":"name","type":"string"},"icons":{"optional":true,"name":"icons","type":"array","items":{"$ref":"fileHandlers.Icon"}},"launch_type":{"optional":true,"name":"launch_type","type":"string"}},"type":"object"}],"functions":[],"properties":{},"events":[],"platforms":null,"deprecated":null})R";
constexpr char kFileSystem[] = R"R({"namespace":"fileSystem","types":[{"id":"fileSystem.AcceptOption","properties":{"description":{"optional":true,"name":"description","type":"string"},"mimeTypes":{"optional":true,"name":"mimeTypes","type":"array","items":{"type":"string"}},"extensions":{"optional":true,"name":"extensions","type":"array","items":{"type":"string"}}},"type":"object"},{"id":"fileSystem.ChooseEntryType","type":"string","enum":[{"name":"openFile"},{"name":"openWritableFile"},{"name":"saveFile"},{"name":"openDirectory"}]},{"id":"fileSystem.ChooseEntryOptions","properties":{"type":{"optional":true,"name":"type","$ref":"fileSystem.ChooseEntryType"},"suggestedName":{"optional":true,"name":"suggestedName","type":"string"},"accepts":{"optional":true,"name":"accepts","type":"array","items":{"$ref":"fileSystem.AcceptOption"}},"acceptsAllTypes":{"optional":true,"name":"acceptsAllTypes","type":"boolean"},"acceptsMultiple":{"optional":true,"name":"acceptsMultiple","type":"boolean"}},"type":"object"},{"id":"fileSystem.RequestFileSystemOptions","properties":{"volumeId":{"name":"volumeId","type":"string"},"writable":{"optional":true,"name":"writable","type":"boolean"}},"type":"object"},{"id":"fileSystem.Volume","properties":{"volumeId":{"name":"volumeId","type":"string"},"writable":{"name":"writable","type":"boolean"}},"type":"object"},{"id":"fileSystem.VolumeListChangedEvent","properties":{"volumes":{"name":"volumes","type":"array","items":{"$ref":"fileSystem.Volume"}}},"type":"object"}],"functions":[{"parameters":[{"name":"entry","type":"object","additionalProperties":{"type":"any"},"isInstanceOf":"Entry"}],"returns_async":{"name":"callback","parameters":[{"name":"displayPath","type":"string"}]},"name":"getDisplayPath","type":"function"},{"parameters":[{"name":"entry","type":"object","additionalProperties":{"type":"any"},"isInstanceOf":"Entry"}],"returns_async":{"name":"callback","parameters":[{"name":"entry","type":"object","additionalProperties":{"type":"any"},"isInstanceOf":"Entry"}],"does_not_support_promises":"Custom hook sets lastError crbug.com/1504349"},"name":"getWritableEntry","type":"function"},{"parameters":[{"name":"entry","type":"object","additionalProperties":{"type":"any"},"isInstanceOf":"Entry"}],"returns_async":{"name":"callback","parameters":[{"name":"isWritable","type":"boolean"}]},"name":"isWritableEntry","type":"function"},{"parameters":[{"name":"options","optional":true,"$ref":"fileSystem.ChooseEntryOptions"}],"returns_async":{"name":"callback","parameters":[{"name":"entry","optional":true,"type":"object","additionalProperties":{"type":"any"},"isInstanceOf":"Entry"},{"name":"fileEntries","optional":true,"type":"array","items":{"type":"object","additionalProperties":{"type":"any"},"isInstanceOf":"FileEntry"}}],"does_not_support_promises":"Multi-parameter callback crbug.com/1313625,\n                             Custom hook sets lastError crbug.com/1504349"},"name":"chooseEntry","type":"function"},{"parameters":[{"name":"id","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"entry","type":"object","additionalProperties":{"type":"any"},"isInstanceOf":"Entry"}],"does_not_support_promises":"Custom hook sets lastError crbug.com/1504349"},"name":"restoreEntry","type":"function"},{"parameters":[{"name":"id","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"isRestorable","type":"boolean"}]},"name":"isRestorable","type":"function"},{"parameters":[{"name":"entry","type":"object","additionalProperties":{"type":"any"},"isInstanceOf":"Entry"}],"returns":{"name":"retainEntry","type":"string"},"name":"retainEntry","type":"function"},{"parameters":[{"name":"options","$ref":"fileSystem.RequestFileSystemOptions"}],"returns_async":{"name":"callback","parameters":[{"name":"fileSystem","optional":true,"type":"object","additionalProperties":{"type":"any"},"isInstanceOf":"FileSystem"}]},"name":"requestFileSystem","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"volumes","optional":true,"type":"array","items":{"$ref":"fileSystem.Volume"}}]},"name":"getVolumeList","type":"function"}],"properties":{},"events":[{"parameters":[{"name":"event","$ref":"fileSystem.VolumeListChangedEvent"}],"name":"onVolumeListChanged","type":"function"}],"platforms":null,"deprecated":null})R";
constexpr char kGuestViewInternal[] = R"R({"namespace":"guestViewInternal","types":[{"id":"guestViewInternal.Size","type":"object","properties":{"width":{"type":"integer"},"height":{"type":"integer"}}},{"id":"guestViewInternal.SizeParams","type":"object","properties":{"enableAutoSize":{"type":"boolean","optional":true},"min":{"$ref":"guestViewInternal.Size","optional":true},"max":{"$ref":"guestViewInternal.Size","optional":true},"normal":{"$ref":"guestViewInternal.Size","optional":true}}}],"functions":[{"name":"createGuest","type":"function","parameters":[{"type":"string","name":"viewType"},{"type":"string","name":"ownerFrameToken"},{"type":"object","name":"createParams","additionalProperties":{"type":"any"}}],"returns_async":{"name":"callback","parameters":[{"type":"integer","name":"instanceId"}]}},{"name":"destroyUnattachedGuest","type":"function","parameters":[{"type":"integer","name":"instanceId"}]},{"name":"setSize","type":"function","parameters":[{"type":"integer","name":"instanceId"},{"$ref":"guestViewInternal.SizeParams","name":"params"}],"returns_async":{"name":"callback","parameters":[],"optional":true}}]})R";
constexpr char kManagement[] = R"R({"namespace":"management","types":[{"id":"management.IconInfo","type":"object","properties":{"size":{"type":"integer"},"url":{"type":"string"}}},{"id":"management.LaunchType","type":"string","enum":["OPEN_AS_REGULAR_TAB","OPEN_AS_PINNED_TAB","OPEN_AS_WINDOW","OPEN_FULL_SCREEN"]},{"id":"management.ExtensionDisabledReason","type":"string","enum":["unknown","permissions_increase"]},{"id":"management.ExtensionType","type":"string","enum":["extension","hosted_app","packaged_app","legacy_packaged_app","theme","login_screen_extension"]},{"id":"management.ExtensionInstallType","type":"string","enum":["admin","development","normal","sideload","other"]},{"id":"management.ExtensionInfo","type":"object","properties":{"id":{"type":"string"},"name":{"type":"string"},"shortName":{"type":"string"},"description":{"type":"string"},"version":{"type":"string"},"versionName":{"type":"string","optional":true},"mayDisable":{"type":"boolean"},"mayEnable":{"type":"boolean","optional":true},"enabled":{"type":"boolean"},"disabledReason":{"$ref":"management.ExtensionDisabledReason","optional":true},"isApp":{"type":"boolean","deprecated":"Please use $(ref:management.ExtensionInfo.type)."},"type":{"$ref":"management.ExtensionType"},"appLaunchUrl":{"type":"string","optional":true},"homepageUrl":{"type":"string","optional":true},"updateUrl":{"type":"string","optional":true},"offlineEnabled":{"type":"boolean"},"optionsUrl":{"type":"string"},"icons":{"type":"array","optional":true,"items":{"$ref":"management.IconInfo"}},"permissions":{"type":"array","items":{"type":"string"}},"hostPermissions":{"type":"array","items":{"type":"string"}},"installType":{"$ref":"management.ExtensionInstallType"},"launchType":{"$ref":"management.LaunchType","optional":true},"availableLaunchTypes":{"type":"array","optional":true,"items":{"$ref":"management.LaunchType"}}}},{"id":"management.UninstallOptions","type":"object","properties":{"showConfirmDialog":{"type":"boolean","optional":true}}}],"functions":[{"name":"getAll","parameters":[],"returns_async":{"name":"callback","optional":true,"parameters":[{"type":"array","name":"result","items":{"$ref":"management.ExtensionInfo"}}]}},{"name":"get","parameters":[{"name":"id","type":"string"}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"result","$ref":"management.ExtensionInfo"}]}},{"name":"getSelf","parameters":[],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"result","$ref":"management.ExtensionInfo"}]}},{"name":"getPermissionWarningsById","parameters":[{"name":"id","type":"string"}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"permissionWarnings","type":"array","items":{"type":"string"}}]}},{"name":"getPermissionWarningsByManifest","parameters":[{"name":"manifestStr","type":"string"}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"permissionWarnings","type":"array","items":{"type":"string"}}]}},{"name":"setEnabled","parameters":[{"name":"id","type":"string"},{"name":"enabled","type":"boolean"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"uninstall","parameters":[{"name":"id","type":"string"},{"name":"options","$ref":"management.UninstallOptions","optional":true}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"uninstallSelf","parameters":[{"name":"options","$ref":"management.UninstallOptions","optional":true}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"launchApp","parameters":[{"name":"id","type":"string"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"createAppShortcut","parameters":[{"name":"id","type":"string"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"setLaunchType","parameters":[{"name":"id","type":"string"},{"name":"launchType","$ref":"management.LaunchType"}],"returns_async":{"name":"callback","type":"function","optional":true,"parameters":[]}},{"name":"generateAppForLink","parameters":[{"name":"url","type":"string"},{"name":"title","type":"string"}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"result","$ref":"management.ExtensionInfo"}]}},{"name":"installReplacementWebApp","parameters":[],"returns_async":{"name":"callback","optional":true,"parameters":[]}}],"events":[{"name":"onInstalled","type":"function","parameters":[{"name":"info","$ref":"management.ExtensionInfo"}]},{"name":"onUninstalled","type":"function","parameters":[{"name":"id","type":"string"}]},{"name":"onEnabled","type":"function","parameters":[{"name":"info","$ref":"management.ExtensionInfo"}]},{"name":"onDisabled","type":"function","parameters":[{"name":"info","$ref":"management.ExtensionInfo"}]}]})R";
constexpr char kHid[] = R"R({"namespace":"hid","types":[{"id":"hid.HidCollectionInfo","properties":{"usagePage":{"name":"usagePage","type":"integer"},"usage":{"name":"usage","type":"integer"},"reportIds":{"name":"reportIds","type":"array","items":{"type":"integer"}}},"type":"object"},{"id":"hid.HidDeviceInfo","properties":{"deviceId":{"name":"deviceId","type":"integer"},"vendorId":{"name":"vendorId","type":"integer"},"productId":{"name":"productId","type":"integer"},"productName":{"name":"productName","type":"string"},"serialNumber":{"name":"serialNumber","type":"string"},"collections":{"name":"collections","type":"array","items":{"$ref":"hid.HidCollectionInfo"}},"maxInputReportSize":{"name":"maxInputReportSize","type":"integer"},"maxOutputReportSize":{"name":"maxOutputReportSize","type":"integer"},"maxFeatureReportSize":{"name":"maxFeatureReportSize","type":"integer"},"reportDescriptor":{"name":"reportDescriptor","type":"binary","isInstanceOf":"ArrayBuffer"}},"type":"object"},{"id":"hid.HidConnectInfo","properties":{"connectionId":{"name":"connectionId","type":"integer"}},"type":"object"},{"id":"hid.DeviceFilter","properties":{"vendorId":{"optional":true,"name":"vendorId","type":"integer"},"productId":{"optional":true,"name":"productId","type":"integer"},"usagePage":{"optional":true,"name":"usagePage","type":"integer"},"usage":{"optional":true,"name":"usage","type":"integer"}},"type":"object"},{"id":"hid.GetDevicesOptions","properties":{"vendorId":{"deprecated":"Equivalent to setting $(ref:DeviceFilter.vendorId).","optional":true,"name":"vendorId","type":"integer"},"productId":{"deprecated":"Equivalent to setting $(ref:DeviceFilter.productId).","optional":true,"name":"productId","type":"integer"},"filters":{"optional":true,"name":"filters","type":"array","items":{"$ref":"hid.DeviceFilter"}}},"type":"object"}],"functions":[{"parameters":[{"name":"options","$ref":"hid.GetDevicesOptions"}],"returns_async":{"name":"callback","parameters":[{"name":"devices","type":"array","items":{"$ref":"hid.HidDeviceInfo"}}]},"name":"getDevices","type":"function"},{"parameters":[{"name":"deviceId","type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"connection","$ref":"hid.HidConnectInfo"}]},"name":"connect","type":"function"},{"parameters":[{"name":"connectionId","type":"integer"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"disconnect","type":"function"},{"parameters":[{"name":"connectionId","type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"reportId","type":"integer"},{"name":"data","type":"binary","isInstanceOf":"ArrayBuffer"}],"does_not_support_promises":"Multi-parameter callback crbug.com/1313625"},"name":"receive","type":"function"},{"parameters":[{"name":"connectionId","type":"integer"},{"name":"reportId","type":"integer"},{"name":"data","type":"binary","isInstanceOf":"ArrayBuffer"}],"returns_async":{"name":"callback","parameters":[]},"name":"send","type":"function"},{"parameters":[{"name":"connectionId","type":"integer"},{"name":"reportId","type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"data","type":"binary","isInstanceOf":"ArrayBuffer"}]},"name":"receiveFeatureReport","type":"function"},{"parameters":[{"name":"connectionId","type":"integer"},{"name":"reportId","type":"integer"},{"name":"data","type":"binary","isInstanceOf":"ArrayBuffer"}],"returns_async":{"name":"callback","parameters":[]},"name":"sendFeatureReport","type":"function"}],"properties":{},"events":[{"parameters":[{"name":"device","$ref":"hid.HidDeviceInfo"}],"name":"onDeviceAdded","type":"function"},{"parameters":[{"name":"deviceId","type":"integer"}],"name":"onDeviceRemoved","type":"function"}],"platforms":null,"deprecated":null})R";
constexpr char kIconVariants[] = R"R({"namespace":"iconVariants","types":[{"id":"iconVariants.ColorScheme","type":"string","enum":[{"name":"dark"},{"name":"light"}]},{"id":"iconVariants.IconVariant","properties":{"any":{"optional":true,"name":"any","type":"string"},"color_schemes":{"optional":true,"name":"color_schemes","type":"array","items":{"$ref":"iconVariants.ColorScheme"}}},"type":"object"}],"functions":[],"properties":{},"events":[],"platforms":null,"deprecated":null})R";
constexpr char kMetricsPrivate[] = R"R({"namespace":"metricsPrivate","types":[{"id":"metricsPrivate.MetricTypeType","type":"string","enum":["histogram-log","histogram-linear"]},{"id":"metricsPrivate.MetricType","type":"object","properties":{"metricName":{"type":"string"},"type":{"$ref":"metricsPrivate.MetricTypeType"},"min":{"type":"integer"},"max":{"type":"integer"},"buckets":{"type":"integer"}}},{"id":"metricsPrivate.HistogramBucket","type":"object","properties":{"min":{"type":"integer"},"max":{"type":"integer"},"count":{"type":"integer"}}},{"id":"metricsPrivate.Histogram","type":"object","properties":{"sum":{"type":"number"},"buckets":{"type":"array","items":{"$ref":"metricsPrivate.HistogramBucket"}}}}],"functions":[{"name":"getHistogram","type":"function","parameters":[{"name":"name","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"histogram","$ref":"metricsPrivate.Histogram"}]}},{"name":"getIsCrashReportingEnabled","type":"function","parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"is_enabled","type":"boolean"}]}},{"name":"getFieldTrial","type":"function","parameters":[{"name":"name","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"group","type":"string"}]}},{"name":"getVariationParams","type":"function","parameters":[{"name":"name","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"params","optional":true,"type":"object","additionalProperties":{"type":"string"}}]}},{"name":"recordUserAction","type":"function","parameters":[{"name":"name","type":"string"}]},{"name":"recordPercentage","type":"function","parameters":[{"name":"metricName","type":"string"},{"name":"value","type":"integer"}]},{"name":"recordCount","type":"function","parameters":[{"name":"metricName","type":"string"},{"name":"value","type":"integer"}]},{"name":"recordSmallCount","type":"function","parameters":[{"name":"metricName","type":"string"},{"name":"value","type":"integer"}]},{"name":"recordMediumCount","type":"function","parameters":[{"name":"metricName","type":"string"},{"name":"value","type":"integer"}]},{"name":"recordTime","type":"function","parameters":[{"name":"metricName","type":"string"},{"name":"value","type":"integer"}]},{"name":"recordMediumTime","type":"function","parameters":[{"name":"metricName","type":"string"},{"name":"value","type":"integer"}]},{"name":"recordLongTime","type":"function","parameters":[{"name":"metricName","type":"string"},{"name":"value","type":"integer"}]},{"name":"recordSparseValueWithHashMetricName","type":"function","parameters":[{"name":"metricName","type":"string"},{"name":"value","type":"string"}]},{"name":"recordSparseValueWithPersistentHash","type":"function","parameters":[{"name":"metricName","type":"string"},{"name":"value","type":"string"}]},{"name":"recordSparseValue","type":"function","parameters":[{"name":"metricName","type":"string"},{"name":"value","type":"integer"}]},{"name":"recordValue","type":"function","parameters":[{"name":"metric","$ref":"metricsPrivate.MetricType"},{"name":"value","type":"integer"}]},{"name":"recordBoolean","type":"function","parameters":[{"name":"metricName","type":"string"},{"name":"value","type":"boolean"}]},{"name":"recordEnumerationValue","type":"function","parameters":[{"name":"metricName","type":"string"},{"name":"value","type":"integer"},{"name":"enumSize","type":"integer"}]}],"events":[]})R";
constexpr char kMimeHandlerPrivate[] = R"R({"namespace":"mimeHandlerPrivate","types":[{"id":"mimeHandlerPrivate.StreamInfo","properties":{"mimeType":{"name":"mimeType","type":"string"},"originalUrl":{"name":"originalUrl","type":"string"},"streamUrl":{"name":"streamUrl","type":"string"},"tabId":{"name":"tabId","type":"integer"},"responseHeaders":{"name":"responseHeaders","type":"object","additionalProperties":{"type":"any"}},"embedded":{"name":"embedded","type":"boolean"}},"type":"object"},{"id":"mimeHandlerPrivate.PdfPluginAttributes","properties":{"backgroundColor":{"name":"backgroundColor","type":"number"},"allowJavascript":{"name":"allowJavascript","type":"boolean"}},"type":"object"}],"functions":[{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"streamInfo","$ref":"mimeHandlerPrivate.StreamInfo"}],"does_not_support_promises":"Custom hook sets lastError crbug.com/1504349"},"name":"getStreamInfo","type":"function"},{"parameters":[{"name":"pdfPluginAttributes","$ref":"mimeHandlerPrivate.PdfPluginAttributes"}],"name":"setPdfPluginAttributes","type":"function"},{"parameters":[{"name":"showDialog","type":"boolean"}],"returns_async":{"name":"callback","optional":true,"parameters":[],"does_not_support_promises":"Custom hook sets lastError crbug.com/1504349"},"name":"setShowBeforeUnloadDialog","type":"function"}],"properties":{},"events":[{"parameters":[{"name":"streamUrl","type":"string"}],"name":"onSave","type":"function"}],"platforms":null,"deprecated":null})R";
constexpr char kMimeHandlerViewGuestInternal[] = R"R({"namespace":"mimeHandlerViewGuestInternal"})R";
constexpr char kMojoPrivate[] = R"R({"namespace":"mojoPrivate","types":[],"functions":[{"parameters":[{"name":"name","type":"string"}],"returns":{"name":"requireAsync","type":"any"},"name":"requireAsync","type":"function"}],"properties":{},"events":[],"platforms":null,"deprecated":null})R";
constexpr char kNetworkingPrivate[] = R"R({"namespace":"networkingPrivate","types":[{"id":"networkingPrivate.ActivationStateType","type":"string","enum":[{"name":"Activated"},{"name":"Activating"},{"name":"NotActivated"},{"name":"PartiallyActivated"}]},{"id":"networkingPrivate.CaptivePortalStatus","type":"string","enum":[{"name":"Unknown"},{"name":"Offline"},{"name":"Online"},{"name":"Portal"},{"name":"ProxyAuthRequired"}]},{"id":"networkingPrivate.ConnectionStateType","type":"string","enum":[{"name":"Connected"},{"name":"Connecting"},{"name":"NotConnected"}]},{"id":"networkingPrivate.DeviceStateType","type":"string","enum":[{"name":"Uninitialized"},{"name":"Disabled"},{"name":"Enabling"},{"name":"Enabled"},{"name":"Prohibited"}]},{"id":"networkingPrivate.IPConfigType","type":"string","enum":[{"name":"DHCP"},{"name":"Static"}]},{"id":"networkingPrivate.NetworkType","type":"string","enum":[{"name":"All"},{"name":"Cellular"},{"name":"Ethernet"},{"name":"Tether"},{"name":"VPN"},{"name":"Wireless"},{"name":"WiFi"}]},{"id":"networkingPrivate.ProxySettingsType","type":"string","enum":[{"name":"Direct"},{"name":"Manual"},{"name":"PAC"},{"name":"WPAD"}]},{"id":"networkingPrivate.ApnType","type":"string","enum":[{"name":"Default"},{"name":"Attach"},{"name":"Tether"}]},{"id":"networkingPrivate.ApnSource","type":"string","enum":[{"name":"Modem"},{"name":"Modb"},{"name":"Ui"},{"name":"Admin"}]},{"id":"networkingPrivate.ManagedBoolean","properties":{"Active":{"optional":true,"name":"Active","type":"boolean"},"Effective":{"optional":true,"name":"Effective","type":"string"},"UserPolicy":{"optional":true,"name":"UserPolicy","type":"boolean"},"DevicePolicy":{"optional":true,"name":"DevicePolicy","type":"boolean"},"UserSetting":{"optional":true,"name":"UserSetting","type":"boolean"},"SharedSetting":{"optional":true,"name":"SharedSetting","type":"boolean"},"UserEditable":{"optional":true,"name":"UserEditable","type":"boolean"},"DeviceEditable":{"optional":true,"name":"DeviceEditable","type":"boolean"}},"type":"object"},{"id":"networkingPrivate.ManagedLong","properties":{"Active":{"optional":true,"name":"Active","type":"integer"},"Effective":{"optional":true,"name":"Effective","type":"string"},"UserPolicy":{"optional":true,"name":"UserPolicy","type":"integer"},"DevicePolicy":{"optional":true,"name":"DevicePolicy","type":"integer"},"UserSetting":{"optional":true,"name":"UserSetting","type":"integer"},"SharedSetting":{"optional":true,"name":"SharedSetting","type":"integer"},"UserEditable":{"optional":true,"name":"UserEditable","type":"boolean"},"DeviceEditable":{"optional":true,"name":"DeviceEditable","type":"boolean"}},"type":"object"},{"id":"networkingPrivate.ManagedDOMString","properties":{"Active":{"optional":true,"name":"Active","type":"string"},"Effective":{"optional":true,"name":"Effective","type":"string"},"UserPolicy":{"optional":true,"name":"UserPolicy","type":"string"},"DevicePolicy":{"optional":true,"name":"DevicePolicy","type":"string"},"UserSetting":{"optional":true,"name":"UserSetting","type":"string"},"SharedSetting":{"optional":true,"name":"SharedSetting","type":"string"},"UserEditable":{"optional":true,"name":"UserEditable","type":"boolean"},"DeviceEditable":{"optional":true,"name":"DeviceEditable","type":"boolean"}},"type":"object"},{"id":"networkingPrivate.ManagedDOMStringList","properties":{"Active":{"optional":true,"name":"Active","type":"array","items":{"type":"string"}},"Effective":{"optional":true,"name":"Effective","type":"string"},"UserPolicy":{"optional":true,"name":"UserPolicy","type":"array","items":{"type":"string"}},"DevicePolicy":{"optional":true,"name":"DevicePolicy","type":"array","items":{"type":"string"}},"UserSetting":{"optional":true,"name":"UserSetting","type":"array","items":{"type":"string"}},"SharedSetting":{"optional":true,"name":"SharedSetting","type":"array","items":{"type":"string"}},"UserEditable":{"optional":true,"name":"UserEditable","type":"boolean"},"DeviceEditable":{"optional":true,"name":"DeviceEditable","type":"boolean"}},"type":"object"},{"id":"networkingPrivate.ManagedIPConfigType","properties":{"Active":{"optional":true,"name":"Active","$ref":"networkingPrivate.IPConfigType"},"Effective":{"optional":true,"name":"Effective","type":"string"},"UserPolicy":{"optional":true,"name":"UserPolicy","$ref":"networkingPrivate.IPConfigType"},"DevicePolicy":{"optional":true,"name":"DevicePolicy","$ref":"networkingPrivate.IPConfigType"},"UserSetting":{"optional":true,"name":"UserSetting","$ref":"networkingPrivate.IPConfigType"},"SharedSetting":{"optional":true,"name":"SharedSetting","$ref":"networkingPrivate.IPConfigType"},"UserEditable":{"optional":true,"name":"UserEditable","type":"boolean"},"DeviceEditable":{"optional":true,"name":"DeviceEditable","type":"boolean"}},"type":"object"},{"id":"networkingPrivate.ManagedProxySettingsType","properties":{"Active":{"optional":true,"name":"Active","$ref":"networkingPrivate.ProxySettingsType"},"Effective":{"optional":true,"name":"Effective","type":"string"},"UserPolicy":{"optional":true,"name":"UserPolicy","$ref":"networkingPrivate.ProxySettingsType"},"DevicePolicy":{"optional":true,"name":"DevicePolicy","$ref":"networkingPrivate.ProxySettingsType"},"UserSetting":{"optional":true,"name":"UserSetting","$ref":"networkingPrivate.ProxySettingsType"},"SharedSetting":{"optional":true,"name":"SharedSetting","$ref":"networkingPrivate.ProxySettingsType"},"UserEditable":{"optional":true,"name":"UserEditable","type":"boolean"},"DeviceEditable":{"optional":true,"name":"DeviceEditable","type":"boolean"}},"type":"object"},{"id":"networkingPrivate.APNProperties","properties":{"AccessPointName":{"name":"AccessPointName","type":"string"},"Authentication":{"optional":true,"name":"Authentication","type":"string"},"Language":{"optional":true,"name":"Language","type":"string"},"LocalizedName":{"optional":true,"name":"LocalizedName","type":"string"},"Name":{"optional":true,"name":"Name","type":"string"},"Password":{"optional":true,"name":"Password","type":"string"},"Username":{"optional":true,"name":"Username","type":"string"},"ApnTypes":{"optional":true,"name":"ApnTypes","type":"array","items":{"$ref":"networkingPrivate.ApnType"}},"Source":{"optional":true,"name":"Source","$ref":"networkingPrivate.ApnSource"}},"type":"object"},{"id":"networkingPrivate.ManagedAPNProperties","properties":{"AccessPointName":{"name":"AccessPointName","$ref":"networkingPrivate.ManagedDOMString"},"Authentication":{"optional":true,"name":"Authentication","$ref":"networkingPrivate.ManagedDOMString"},"Language":{"optional":true,"name":"Language","$ref":"networkingPrivate.ManagedDOMString"},"LocalizedName":{"optional":true,"name":"LocalizedName","$ref":"networkingPrivate.ManagedDOMString"},"Name":{"optional":true,"name":"Name","$ref":"networkingPrivate.ManagedDOMString"},"Password":{"optional":true,"name":"Password","$ref":"networkingPrivate.ManagedDOMString"},"Username":{"optional":true,"name":"Username","$ref":"networkingPrivate.ManagedDOMString"}},"type":"object"},{"id":"networkingPrivate.ManagedAPNList","properties":{"Active":{"optional":true,"name":"Active","type":"array","items":{"$ref":"networkingPrivate.APNProperties"}},"Effective":{"optional":true,"name":"Effective","type":"string"},"UserPolicy":{"optional":true,"name":"UserPolicy","type":"array","items":{"$ref":"networkingPrivate.APNProperties"}},"DevicePolicy":{"optional":true,"name":"DevicePolicy","type":"array","items":{"$ref":"networkingPrivate.APNProperties"}},"UserSetting":{"optional":true,"name":"UserSetting","type":"array","items":{"$ref":"networkingPrivate.APNProperties"}},"SharedSetting":{"optional":true,"name":"SharedSetting","type":"array","items":{"$ref":"networkingPrivate.APNProperties"}},"UserEditable":{"optional":true,"name":"UserEditable","type":"boolean"},"DeviceEditable":{"optional":true,"name":"DeviceEditable","type":"boolean"}},"type":"object"},{"id":"networkingPrivate.CellularProviderProperties","properties":{"Name":{"name":"Name","type":"string"},"Code":{"name":"Code","type":"string"},"Country":{"optional":true,"name":"Country","type":"string"}},"type":"object"},{"id":"networkingPrivate.CellularSimState","properties":{"requirePin":{"name":"requirePin","type":"boolean"},"currentPi)R" R"R(n":{"name":"currentPin","type":"string"},"newPin":{"optional":true,"name":"newPin","type":"string"}},"type":"object"},{"id":"networkingPrivate.IssuerSubjectPattern","properties":{"CommonName":{"optional":true,"name":"CommonName","type":"string"},"Locality":{"optional":true,"name":"Locality","type":"string"},"Organization":{"optional":true,"name":"Organization","type":"string"},"OrganizationalUnit":{"optional":true,"name":"OrganizationalUnit","type":"string"}},"type":"object"},{"id":"networkingPrivate.ManagedIssuerSubjectPattern","properties":{"CommonName":{"optional":true,"name":"CommonName","$ref":"networkingPrivate.ManagedDOMString"},"Locality":{"optional":true,"name":"Locality","$ref":"networkingPrivate.ManagedDOMString"},"Organization":{"optional":true,"name":"Organization","$ref":"networkingPrivate.ManagedDOMString"},"OrganizationalUnit":{"optional":true,"name":"OrganizationalUnit","$ref":"networkingPrivate.ManagedDOMString"}},"type":"object"},{"id":"networkingPrivate.CertificatePattern","properties":{"EnrollmentURI":{"optional":true,"name":"EnrollmentURI","type":"array","items":{"type":"string"}},"Issuer":{"optional":true,"name":"Issuer","$ref":"networkingPrivate.IssuerSubjectPattern"},"IssuerCAPEMs":{"optional":true,"name":"IssuerCAPEMs","type":"array","items":{"type":"string"}},"IssuerCARef":{"optional":true,"name":"IssuerCARef","type":"array","items":{"type":"string"}},"Subject":{"optional":true,"name":"Subject","$ref":"networkingPrivate.IssuerSubjectPattern"}},"type":"object"},{"id":"networkingPrivate.ManagedCertificatePattern","properties":{"EnrollmentURI":{"optional":true,"name":"EnrollmentURI","$ref":"networkingPrivate.ManagedDOMStringList"},"Issuer":{"optional":true,"name":"Issuer","$ref":"networkingPrivate.ManagedIssuerSubjectPattern"},"IssuerCARef":{"optional":true,"name":"IssuerCARef","$ref":"networkingPrivate.ManagedDOMStringList"},"Subject":{"optional":true,"name":"Subject","$ref":"networkingPrivate.ManagedIssuerSubjectPattern"}},"type":"object"},{"id":"networkingPrivate.EAPProperties","properties":{"AnonymousIdentity":{"optional":true,"name":"AnonymousIdentity","type":"string"},"ClientCertPattern":{"optional":true,"name":"ClientCertPattern","$ref":"networkingPrivate.CertificatePattern"},"ClientCertPKCS11Id":{"optional":true,"name":"ClientCertPKCS11Id","type":"string"},"ClientCertProvisioningProfileId":{"optional":true,"name":"ClientCertProvisioningProfileId","type":"string"},"ClientCertRef":{"optional":true,"name":"ClientCertRef","type":"string"},"ClientCertType":{"optional":true,"name":"ClientCertType","type":"string"},"Identity":{"optional":true,"name":"Identity","type":"string"},"Inner":{"optional":true,"name":"Inner","type":"string"},"Outer":{"optional":true,"name":"Outer","type":"string"},"Password":{"optional":true,"name":"Password","type":"string"},"SaveCredentials":{"optional":true,"name":"SaveCredentials","type":"boolean"},"ServerCAPEMs":{"optional":true,"name":"ServerCAPEMs","type":"array","items":{"type":"string"}},"ServerCARefs":{"optional":true,"name":"ServerCARefs","type":"array","items":{"type":"string"}},"SubjectMatch":{"optional":true,"name":"SubjectMatch","type":"string"},"TLSVersionMax":{"optional":true,"name":"TLSVersionMax","type":"string"},"UseProactiveKeyCaching":{"optional":true,"name":"UseProactiveKeyCaching","type":"boolean"},"UseSystemCAs":{"optional":true,"name":"UseSystemCAs","type":"boolean"}},"type":"object"},{"id":"networkingPrivate.ManagedEAPProperties","properties":{"AnonymousIdentity":{"optional":true,"name":"AnonymousIdentity","$ref":"networkingPrivate.ManagedDOMString"},"ClientCertPattern":{"optional":true,"name":"ClientCertPattern","$ref":"networkingPrivate.ManagedCertificatePattern"},"ClientCertPKCS11Id":{"optional":true,"name":"ClientCertPKCS11Id","$ref":"networkingPrivate.ManagedDOMString"},"ClientCertProvisioningProfileId":{"optional":true,"name":"ClientCertProvisioningProfileId","$ref":"networkingPrivate.ManagedDOMString"},"ClientCertRef":{"optional":true,"name":"ClientCertRef","$ref":"networkingPrivate.ManagedDOMString"},"ClientCertType":{"optional":true,"name":"ClientCertType","$ref":"networkingPrivate.ManagedDOMString"},"Identity":{"optional":true,"name":"Identity","$ref":"networkingPrivate.ManagedDOMString"},"Inner":{"optional":true,"name":"Inner","$ref":"networkingPrivate.ManagedDOMString"},"Outer":{"optional":true,"name":"Outer","$ref":"networkingPrivate.ManagedDOMString"},"Password":{"optional":true,"name":"Password","$ref":"networkingPrivate.ManagedDOMString"},"SaveCredentials":{"optional":true,"name":"SaveCredentials","$ref":"networkingPrivate.ManagedBoolean"},"ServerCAPEMs":{"optional":true,"name":"ServerCAPEMs","$ref":"networkingPrivate.ManagedDOMStringList"},"ServerCARefs":{"optional":true,"name":"ServerCARefs","$ref":"networkingPrivate.ManagedDOMStringList"},"SubjectMatch":{"optional":true,"name":"SubjectMatch","$ref":"networkingPrivate.ManagedDOMString"},"TLSVersionMax":{"optional":true,"name":"TLSVersionMax","$ref":"networkingPrivate.ManagedDOMString"},"UseProactiveKeyCaching":{"optional":true,"name":"UseProactiveKeyCaching","$ref":"networkingPrivate.ManagedBoolean"},"UseSystemCAs":{"optional":true,"name":"UseSystemCAs","$ref":"networkingPrivate.ManagedBoolean"}},"type":"object"},{"id":"networkingPrivate.FoundNetworkProperties","properties":{"Status":{"name":"Status","type":"string"},"NetworkId":{"name":"NetworkId","type":"string"},"Technology":{"name":"Technology","type":"string"},"ShortName":{"optional":true,"name":"ShortName","type":"string"},"LongName":{"optional":true,"name":"LongName","type":"string"}},"type":"object"},{"id":"networkingPrivate.IPConfigProperties","properties":{"Gateway":{"optional":true,"name":"Gateway","type":"string"},"IPAddress":{"optional":true,"name":"IPAddress","type":"string"},"ExcludedRoutes":{"optional":true,"name":"ExcludedRoutes","type":"array","items":{"type":"string"}},"IncludedRoutes":{"optional":true,"name":"IncludedRoutes","type":"array","items":{"type":"string"}},"NameServers":{"optional":true,"name":"NameServers","type":"array","items":{"type":"string"}},"SearchDomains":{"optional":true,"name":"SearchDomains","type":"array","items":{"type":"string"}},"RoutingPrefix":{"optional":true,"name":"RoutingPrefix","type":"integer"},"Type":{"optional":true,"name":"Type","type":"string"},"WebProxyAutoDiscoveryUrl":{"optional":true,"name":"WebProxyAutoDiscoveryUrl","type":"string"}},"type":"object"},{"id":"networkingPrivate.ManagedIPConfigProperties","properties":{"Gateway":{"optional":true,"name":"Gateway","$ref":"networkingPrivate.ManagedDOMString"},"IPAddress":{"optional":true,"name":"IPAddress","$ref":"networkingPrivate.ManagedDOMString"},"NameServers":{"optional":true,"name":"NameServers","$ref":"networkingPrivate.ManagedDOMStringList"},"RoutingPrefix":{"optional":true,"name":"RoutingPrefix","$ref":"networkingPrivate.ManagedLong"},"Type":{"optional":true,"name":"Type","$ref":"networkingPrivate.ManagedDOMString"},"WebProxyAutoDiscoveryUrl":{"optional":true,"name":"WebProxyAutoDiscoveryUrl","$ref":"networkingPrivate.ManagedDOMString"}},"type":"object"},{"id":"networkingPrivate.XAUTHProperties","properties":{"Password":{"optional":true,"name":"Password","type":"string"},"SaveCredentials":{"optional":true,"name":"SaveCredentials","type":"boolean"},"Username":{"optional":true,"name":"Username","type":"string"}},"type":"object"},{"id":"networkingPrivate.ManagedXAUTHProperties","properties":{"Password":{"optional":true,"name":"Password","$ref":"networkingPrivate.ManagedDOMString"},"SaveCredentials":{"optional":true,"name":"SaveCredentials","$ref":"networkingPrivate.ManagedBoolean"},"Username":{"optional":true,"name":"Username","$ref":"networkingPrivate.ManagedDOMString"}},"type":"object"},{"id":"networkingPrivate.IPSecProperties","properties":{"AuthenticationType":{"name":"AuthenticationType","type":"string"},"ClientCertPattern":{"optional":true,"name":"ClientCertPattern","$ref":"networkingPrivate.CertificatePattern"},"ClientCertPKCS11Id":{"optional":true,"name":"ClientCertPKCS11Id","type":"string"},"ClientCertProvisioningProfileId":{"optional":true,"name":"ClientCertProvisioningProfileId","type":"string"},"ClientCertRef":{"optional")R" R"R(:true,"name":"ClientCertRef","type":"string"},"ClientCertType":{"optional":true,"name":"ClientCertType","type":"string"},"EAP":{"optional":true,"name":"EAP","$ref":"networkingPrivate.EAPProperties"},"Group":{"optional":true,"name":"Group","type":"string"},"IKEVersion":{"optional":true,"name":"IKEVersion","type":"integer"},"LocalIdentity":{"optional":true,"name":"LocalIdentity","type":"string"},"PSK":{"optional":true,"name":"PSK","type":"string"},"RemoteIdentity":{"optional":true,"name":"RemoteIdentity","type":"string"},"SaveCredentials":{"optional":true,"name":"SaveCredentials","type":"boolean"},"ServerCAPEMs":{"optional":true,"name":"ServerCAPEMs","type":"array","items":{"type":"string"}},"ServerCARefs":{"optional":true,"name":"ServerCARefs","type":"array","items":{"type":"string"}},"XAUTH":{"optional":true,"name":"XAUTH","$ref":"networkingPrivate.XAUTHProperties"}},"type":"object"},{"id":"networkingPrivate.ManagedIPSecProperties","properties":{"AuthenticationType":{"name":"AuthenticationType","$ref":"networkingPrivate.ManagedDOMString"},"ClientCertPattern":{"optional":true,"name":"ClientCertPattern","$ref":"networkingPrivate.ManagedCertificatePattern"},"ClientCertPKCS11Id":{"optional":true,"name":"ClientCertPKCS11Id","$ref":"networkingPrivate.ManagedDOMString"},"ClientCertProvisioningProfileId":{"optional":true,"name":"ClientCertProvisioningProfileId","$ref":"networkingPrivate.ManagedDOMString"},"ClientCertRef":{"optional":true,"name":"ClientCertRef","$ref":"networkingPrivate.ManagedDOMString"},"ClientCertType":{"optional":true,"name":"ClientCertType","$ref":"networkingPrivate.ManagedDOMString"},"EAP":{"optional":true,"name":"EAP","$ref":"networkingPrivate.ManagedEAPProperties"},"Group":{"optional":true,"name":"Group","$ref":"networkingPrivate.ManagedDOMString"},"IKEVersion":{"optional":true,"name":"IKEVersion","$ref":"networkingPrivate.ManagedLong"},"PSK":{"optional":true,"name":"PSK","$ref":"networkingPrivate.ManagedDOMString"},"SaveCredentials":{"optional":true,"name":"SaveCredentials","$ref":"networkingPrivate.ManagedBoolean"},"ServerCAPEMs":{"optional":true,"name":"ServerCAPEMs","$ref":"networkingPrivate.ManagedDOMStringList"},"ServerCARefs":{"optional":true,"name":"ServerCARefs","$ref":"networkingPrivate.ManagedDOMStringList"},"XAUTH":{"optional":true,"name":"XAUTH","$ref":"networkingPrivate.ManagedXAUTHProperties"}},"type":"object"},{"id":"networkingPrivate.L2TPProperties","properties":{"LcpEchoDisabled":{"optional":true,"name":"LcpEchoDisabled","type":"boolean"},"Password":{"optional":true,"name":"Password","type":"string"},"SaveCredentials":{"optional":true,"name":"SaveCredentials","type":"boolean"},"Username":{"optional":true,"name":"Username","type":"string"}},"type":"object"},{"id":"networkingPrivate.ManagedL2TPProperties","properties":{"LcpEchoDisabled":{"optional":true,"name":"LcpEchoDisabled","$ref":"networkingPrivate.ManagedBoolean"},"Password":{"optional":true,"name":"Password","$ref":"networkingPrivate.ManagedDOMString"},"SaveCredentials":{"optional":true,"name":"SaveCredentials","$ref":"networkingPrivate.ManagedBoolean"},"Username":{"optional":true,"name":"Username","$ref":"networkingPrivate.ManagedDOMString"}},"type":"object"},{"id":"networkingPrivate.PaymentPortal","properties":{"Method":{"name":"Method","type":"string"},"PostData":{"optional":true,"name":"PostData","type":"string"},"Url":{"optional":true,"name":"Url","type":"string"}},"type":"object"},{"id":"networkingPrivate.ProxyLocation","properties":{"Host":{"name":"Host","type":"string"},"Port":{"name":"Port","type":"integer"}},"type":"object"},{"id":"networkingPrivate.ManagedProxyLocation","properties":{"Host":{"name":"Host","$ref":"networkingPrivate.ManagedDOMString"},"Port":{"name":"Port","$ref":"networkingPrivate.ManagedLong"}},"type":"object"},{"id":"networkingPrivate.ManualProxySettings","properties":{"HTTPProxy":{"optional":true,"name":"HTTPProxy","$ref":"networkingPrivate.ProxyLocation"},"SecureHTTPProxy":{"optional":true,"name":"SecureHTTPProxy","$ref":"networkingPrivate.ProxyLocation"},"FTPProxy":{"optional":true,"name":"FTPProxy","$ref":"networkingPrivate.ProxyLocation"},"SOCKS":{"optional":true,"name":"SOCKS","$ref":"networkingPrivate.ProxyLocation"}},"type":"object"},{"id":"networkingPrivate.ManagedManualProxySettings","properties":{"HTTPProxy":{"optional":true,"name":"HTTPProxy","$ref":"networkingPrivate.ManagedProxyLocation"},"SecureHTTPProxy":{"optional":true,"name":"SecureHTTPProxy","$ref":"networkingPrivate.ManagedProxyLocation"},"FTPProxy":{"optional":true,"name":"FTPProxy","$ref":"networkingPrivate.ManagedProxyLocation"},"SOCKS":{"optional":true,"name":"SOCKS","$ref":"networkingPrivate.ManagedProxyLocation"}},"type":"object"},{"id":"networkingPrivate.ProxySettings","properties":{"Type":{"name":"Type","$ref":"networkingPrivate.ProxySettingsType"},"Manual":{"optional":true,"name":"Manual","$ref":"networkingPrivate.ManualProxySettings"},"ExcludeDomains":{"optional":true,"name":"ExcludeDomains","type":"array","items":{"type":"string"}},"PAC":{"optional":true,"name":"PAC","type":"string"}},"type":"object"},{"id":"networkingPrivate.ManagedProxySettings","properties":{"Type":{"name":"Type","$ref":"networkingPrivate.ManagedProxySettingsType"},"Manual":{"optional":true,"name":"Manual","$ref":"networkingPrivate.ManagedManualProxySettings"},"ExcludeDomains":{"optional":true,"name":"ExcludeDomains","$ref":"networkingPrivate.ManagedDOMStringList"},"PAC":{"optional":true,"name":"PAC","$ref":"networkingPrivate.ManagedDOMString"}},"type":"object"},{"id":"networkingPrivate.VerifyX509","properties":{"Name":{"optional":true,"name":"Name","type":"string"},"Type":{"optional":true,"name":"Type","type":"string"}},"type":"object"},{"id":"networkingPrivate.ManagedVerifyX509","properties":{"Name":{"optional":true,"name":"Name","$ref":"networkingPrivate.ManagedDOMString"},"Type":{"optional":true,"name":"Type","$ref":"networkingPrivate.ManagedDOMString"}},"type":"object"},{"id":"networkingPrivate.OpenVPNProperties","properties":{"Auth":{"optional":true,"name":"Auth","type":"string"},"AuthRetry":{"optional":true,"name":"AuthRetry","type":"string"},"AuthNoCache":{"optional":true,"name":"AuthNoCache","type":"boolean"},"Cipher":{"optional":true,"name":"Cipher","type":"string"},"ClientCertPKCS11Id":{"optional":true,"name":"ClientCertPKCS11Id","type":"string"},"ClientCertPattern":{"optional":true,"name":"ClientCertPattern","$ref":"networkingPrivate.CertificatePattern"},"ClientCertProvisioningProfileId":{"optional":true,"name":"ClientCertProvisioningProfileId","type":"string"},"ClientCertRef":{"optional":true,"name":"ClientCertRef","type":"string"},"ClientCertType":{"optional":true,"name":"ClientCertType","type":"string"},"CompLZO":{"optional":true,"name":"CompLZO","type":"string"},"CompNoAdapt":{"optional":true,"name":"CompNoAdapt","type":"boolean"},"ExtraHosts":{"optional":true,"name":"ExtraHosts","type":"array","items":{"type":"string"}},"IgnoreDefaultRoute":{"optional":true,"name":"IgnoreDefaultRoute","type":"boolean"},"KeyDirection":{"optional":true,"name":"KeyDirection","type":"string"},"NsCertType":{"optional":true,"name":"NsCertType","type":"string"},"OTP":{"optional":true,"name":"OTP","type":"string"},"Password":{"optional":true,"name":"Password","type":"string"},"Port":{"optional":true,"name":"Port","type":"integer"},"Proto":{"optional":true,"name":"Proto","type":"string"},"PushPeerInfo":{"optional":true,"name":"PushPeerInfo","type":"boolean"},"RemoteCertEKU":{"optional":true,"name":"RemoteCertEKU","type":"string"},"RemoteCertKU":{"optional":true,"name":"RemoteCertKU","type":"array","items":{"type":"string"}},"RemoteCertTLS":{"optional":true,"name":"RemoteCertTLS","type":"string"},"RenegSec":{"optional":true,"name":"RenegSec","type":"integer"},"SaveCredentials":{"optional":true,"name":"SaveCredentials","type":"boolean"},"ServerCAPEMs":{"optional":true,"name":"ServerCAPEMs","type":"array","items":{"type":"string"}},"ServerCARefs":{"optional":true,"name":"ServerCARefs","type":"array","items":{"type":"string"}},"ServerCertRef":{"optional":true,"name":"ServerCertRef","type":"string"},"ServerPollTimeout":{"optional":true,"name":"ServerPollTimeout","type":"integer"},"S)R" R"R(haper":{"optional":true,"name":"Shaper","type":"integer"},"StaticChallenge":{"optional":true,"name":"StaticChallenge","type":"string"},"TLSAuthContents":{"optional":true,"name":"TLSAuthContents","type":"string"},"TLSRemote":{"optional":true,"name":"TLSRemote","type":"string"},"TLSVersionMin":{"optional":true,"name":"TLSVersionMin","type":"string"},"UserAuthenticationType":{"optional":true,"name":"UserAuthenticationType","type":"string"},"Username":{"optional":true,"name":"Username","type":"string"},"Verb":{"optional":true,"name":"Verb","type":"string"},"VerifyHash":{"optional":true,"name":"VerifyHash","type":"string"},"VerifyX509":{"optional":true,"name":"VerifyX509","$ref":"networkingPrivate.VerifyX509"}},"type":"object"},{"id":"networkingPrivate.ManagedOpenVPNProperties","properties":{"Auth":{"optional":true,"name":"Auth","$ref":"networkingPrivate.ManagedDOMString"},"AuthRetry":{"optional":true,"name":"AuthRetry","$ref":"networkingPrivate.ManagedDOMString"},"AuthNoCache":{"optional":true,"name":"AuthNoCache","$ref":"networkingPrivate.ManagedBoolean"},"Cipher":{"optional":true,"name":"Cipher","$ref":"networkingPrivate.ManagedDOMString"},"ClientCertPKCS11Id":{"optional":true,"name":"ClientCertPKCS11Id","$ref":"networkingPrivate.ManagedDOMString"},"ClientCertPattern":{"optional":true,"name":"ClientCertPattern","$ref":"networkingPrivate.ManagedCertificatePattern"},"ClientCertProvisioningProfileId":{"optional":true,"name":"ClientCertProvisioningProfileId","$ref":"networkingPrivate.ManagedDOMString"},"ClientCertRef":{"optional":true,"name":"ClientCertRef","$ref":"networkingPrivate.ManagedDOMString"},"ClientCertType":{"optional":true,"name":"ClientCertType","$ref":"networkingPrivate.ManagedDOMString"},"CompLZO":{"optional":true,"name":"CompLZO","$ref":"networkingPrivate.ManagedDOMString"},"CompNoAdapt":{"optional":true,"name":"CompNoAdapt","$ref":"networkingPrivate.ManagedBoolean"},"ExtraHosts":{"optional":true,"name":"ExtraHosts","$ref":"networkingPrivate.ManagedDOMStringList"},"IgnoreDefaultRoute":{"optional":true,"name":"IgnoreDefaultRoute","$ref":"networkingPrivate.ManagedBoolean"},"KeyDirection":{"optional":true,"name":"KeyDirection","$ref":"networkingPrivate.ManagedDOMString"},"NsCertType":{"optional":true,"name":"NsCertType","$ref":"networkingPrivate.ManagedDOMString"},"OTP":{"optional":true,"name":"OTP","$ref":"networkingPrivate.ManagedDOMString"},"Password":{"optional":true,"name":"Password","$ref":"networkingPrivate.ManagedDOMString"},"Port":{"optional":true,"name":"Port","$ref":"networkingPrivate.ManagedLong"},"Proto":{"optional":true,"name":"Proto","$ref":"networkingPrivate.ManagedDOMString"},"PushPeerInfo":{"optional":true,"name":"PushPeerInfo","$ref":"networkingPrivate.ManagedBoolean"},"RemoteCertEKU":{"optional":true,"name":"RemoteCertEKU","$ref":"networkingPrivate.ManagedDOMString"},"RemoteCertKU":{"optional":true,"name":"RemoteCertKU","$ref":"networkingPrivate.ManagedDOMStringList"},"RemoteCertTLS":{"optional":true,"name":"RemoteCertTLS","$ref":"networkingPrivate.ManagedDOMString"},"RenegSec":{"optional":true,"name":"RenegSec","$ref":"networkingPrivate.ManagedLong"},"SaveCredentials":{"optional":true,"name":"SaveCredentials","$ref":"networkingPrivate.ManagedBoolean"},"ServerCAPEMs":{"optional":true,"name":"ServerCAPEMs","$ref":"networkingPrivate.ManagedDOMStringList"},"ServerCARefs":{"optional":true,"name":"ServerCARefs","$ref":"networkingPrivate.ManagedDOMStringList"},"ServerCertRef":{"optional":true,"name":"ServerCertRef","$ref":"networkingPrivate.ManagedDOMString"},"ServerPollTimeout":{"optional":true,"name":"ServerPollTimeout","$ref":"networkingPrivate.ManagedLong"},"Shaper":{"optional":true,"name":"Shaper","$ref":"networkingPrivate.ManagedLong"},"StaticChallenge":{"optional":true,"name":"StaticChallenge","$ref":"networkingPrivate.ManagedDOMString"},"TLSAuthContents":{"optional":true,"name":"TLSAuthContents","$ref":"networkingPrivate.ManagedDOMString"},"TLSRemote":{"optional":true,"name":"TLSRemote","$ref":"networkingPrivate.ManagedDOMString"},"TLSVersionMin":{"optional":true,"name":"TLSVersionMin","$ref":"networkingPrivate.ManagedDOMString"},"UserAuthenticationType":{"optional":true,"name":"UserAuthenticationType","$ref":"networkingPrivate.ManagedDOMString"},"Username":{"optional":true,"name":"Username","$ref":"networkingPrivate.ManagedDOMString"},"Verb":{"optional":true,"name":"Verb","$ref":"networkingPrivate.ManagedDOMString"},"VerifyHash":{"optional":true,"name":"VerifyHash","$ref":"networkingPrivate.ManagedDOMString"},"VerifyX509":{"optional":true,"name":"VerifyX509","$ref":"networkingPrivate.ManagedVerifyX509"}},"type":"object"},{"id":"networkingPrivate.SIMLockStatus","properties":{"LockType":{"name":"LockType","type":"string"},"LockEnabled":{"name":"LockEnabled","type":"boolean"},"RetriesLeft":{"optional":true,"name":"RetriesLeft","type":"integer"}},"type":"object"},{"id":"networkingPrivate.ThirdPartyVPNProperties","properties":{"ExtensionID":{"name":"ExtensionID","type":"string"},"ProviderName":{"optional":true,"name":"ProviderName","type":"string"}},"type":"object"},{"id":"networkingPrivate.ManagedThirdPartyVPNProperties","properties":{"ExtensionID":{"name":"ExtensionID","$ref":"networkingPrivate.ManagedDOMString"},"ProviderName":{"optional":true,"name":"ProviderName","type":"string"}},"type":"object"},{"id":"networkingPrivate.CellularProperties","properties":{"AutoConnect":{"optional":true,"name":"AutoConnect","type":"boolean"},"APN":{"optional":true,"name":"APN","$ref":"networkingPrivate.APNProperties"},"APNList":{"optional":true,"name":"APNList","type":"array","items":{"$ref":"networkingPrivate.APNProperties"}},"ActivationType":{"optional":true,"name":"ActivationType","type":"string"},"ActivationState":{"optional":true,"name":"ActivationState","$ref":"networkingPrivate.ActivationStateType"},"AllowRoaming":{"optional":true,"name":"AllowRoaming","type":"boolean"},"ESN":{"optional":true,"name":"ESN","type":"string"},"Family":{"optional":true,"name":"Family","type":"string"},"FirmwareRevision":{"optional":true,"name":"FirmwareRevision","type":"string"},"FoundNetworks":{"optional":true,"name":"FoundNetworks","type":"array","items":{"$ref":"networkingPrivate.FoundNetworkProperties"}},"HardwareRevision":{"optional":true,"name":"HardwareRevision","type":"string"},"HomeProvider":{"optional":true,"name":"HomeProvider","$ref":"networkingPrivate.CellularProviderProperties"},"ICCID":{"optional":true,"name":"ICCID","type":"string"},"IMEI":{"optional":true,"name":"IMEI","type":"string"},"LastGoodAPN":{"optional":true,"name":"LastGoodAPN","$ref":"networkingPrivate.APNProperties"},"Manufacturer":{"optional":true,"name":"Manufacturer","type":"string"},"MDN":{"optional":true,"name":"MDN","type":"string"},"MEID":{"optional":true,"name":"MEID","type":"string"},"MIN":{"optional":true,"name":"MIN","type":"string"},"ModelID":{"optional":true,"name":"ModelID","type":"string"},"NetworkTechnology":{"optional":true,"name":"NetworkTechnology","type":"string"},"PaymentPortal":{"optional":true,"name":"PaymentPortal","$ref":"networkingPrivate.PaymentPortal"},"RoamingState":{"optional":true,"name":"RoamingState","type":"string"},"Scanning":{"optional":true,"name":"Scanning","type":"boolean"},"ServingOperator":{"optional":true,"name":"ServingOperator","$ref":"networkingPrivate.CellularProviderProperties"},"SIMLockStatus":{"optional":true,"name":"SIMLockStatus","$ref":"networkingPrivate.SIMLockStatus"},"SIMPresent":{"optional":true,"name":"SIMPresent","type":"boolean"},"SignalStrength":{"optional":true,"name":"SignalStrength","type":"integer"},"SupportNetworkScan":{"optional":true,"name":"SupportNetworkScan","type":"boolean"}},"type":"object"},{"id":"networkingPrivate.ManagedCellularProperties","properties":{"AutoConnect":{"optional":true,"name":"AutoConnect","$ref":"networkingPrivate.ManagedBoolean"},"APN":{"optional":true,"name":"APN","$ref":"networkingPrivate.ManagedAPNProperties"},"APNList":{"optional":true,"name":"APNList","$ref":"networkingPrivate.ManagedAPNList"},"ActivationType":{"optional":true,"name":"ActivationType","type":"string"},"ActivationState":{"optional":true,"name":"ActivationState","$ref":"networkingPrivate.ActivationState)R" R"R(Type"},"AllowRoaming":{"optional":true,"name":"AllowRoaming","type":"boolean"},"ESN":{"optional":true,"name":"ESN","type":"string"},"Family":{"optional":true,"name":"Family","type":"string"},"FirmwareRevision":{"optional":true,"name":"FirmwareRevision","type":"string"},"FoundNetworks":{"optional":true,"name":"FoundNetworks","type":"array","items":{"$ref":"networkingPrivate.FoundNetworkProperties"}},"HardwareRevision":{"optional":true,"name":"HardwareRevision","type":"string"},"HomeProvider":{"optional":true,"name":"HomeProvider","$ref":"networkingPrivate.CellularProviderProperties"},"ICCID":{"optional":true,"name":"ICCID","type":"string"},"IMEI":{"optional":true,"name":"IMEI","type":"string"},"LastGoodAPN":{"optional":true,"name":"LastGoodAPN","$ref":"networkingPrivate.APNProperties"},"Manufacturer":{"optional":true,"name":"Manufacturer","type":"string"},"MDN":{"optional":true,"name":"MDN","type":"string"},"MEID":{"optional":true,"name":"MEID","type":"string"},"MIN":{"optional":true,"name":"MIN","type":"string"},"ModelID":{"optional":true,"name":"ModelID","type":"string"},"NetworkTechnology":{"optional":true,"name":"NetworkTechnology","type":"string"},"PaymentPortal":{"optional":true,"name":"PaymentPortal","$ref":"networkingPrivate.PaymentPortal"},"RoamingState":{"optional":true,"name":"RoamingState","type":"string"},"Scanning":{"optional":true,"name":"Scanning","type":"boolean"},"ServingOperator":{"optional":true,"name":"ServingOperator","$ref":"networkingPrivate.CellularProviderProperties"},"SIMLockStatus":{"optional":true,"name":"SIMLockStatus","$ref":"networkingPrivate.SIMLockStatus"},"SIMPresent":{"optional":true,"name":"SIMPresent","type":"boolean"},"SignalStrength":{"optional":true,"name":"SignalStrength","type":"integer"},"SupportNetworkScan":{"optional":true,"name":"SupportNetworkScan","type":"boolean"}},"type":"object"},{"id":"networkingPrivate.CellularStateProperties","properties":{"ActivationState":{"optional":true,"name":"ActivationState","$ref":"networkingPrivate.ActivationStateType"},"EID":{"optional":true,"name":"EID","type":"string"},"ICCID":{"optional":true,"name":"ICCID","type":"string"},"NetworkTechnology":{"optional":true,"name":"NetworkTechnology","type":"string"},"RoamingState":{"optional":true,"name":"RoamingState","type":"string"},"Scanning":{"optional":true,"name":"Scanning","type":"boolean"},"SIMPresent":{"optional":true,"name":"SIMPresent","type":"boolean"},"SignalStrength":{"optional":true,"name":"SignalStrength","type":"integer"}},"type":"object"},{"id":"networkingPrivate.EAPStateProperties","properties":{"Outer":{"optional":true,"name":"Outer","type":"string"}},"type":"object"},{"id":"networkingPrivate.EthernetProperties","properties":{"AutoConnect":{"optional":true,"name":"AutoConnect","type":"boolean"},"Authentication":{"optional":true,"name":"Authentication","type":"string"},"EAP":{"optional":true,"name":"EAP","$ref":"networkingPrivate.EAPProperties"}},"type":"object"},{"id":"networkingPrivate.ManagedEthernetProperties","properties":{"AutoConnect":{"optional":true,"name":"AutoConnect","$ref":"networkingPrivate.ManagedBoolean"},"Authentication":{"optional":true,"name":"Authentication","$ref":"networkingPrivate.ManagedDOMString"},"EAP":{"optional":true,"name":"EAP","$ref":"networkingPrivate.ManagedEAPProperties"}},"type":"object"},{"id":"networkingPrivate.EthernetStateProperties","properties":{"Authentication":{"name":"Authentication","type":"string"}},"type":"object"},{"id":"networkingPrivate.TetherProperties","properties":{"BatteryPercentage":{"optional":true,"name":"BatteryPercentage","type":"integer"},"Carrier":{"optional":true,"name":"Carrier","type":"string"},"HasConnectedToHost":{"name":"HasConnectedToHost","type":"boolean"},"SignalStrength":{"optional":true,"name":"SignalStrength","type":"integer"}},"type":"object"},{"id":"networkingPrivate.VPNProperties","properties":{"AutoConnect":{"optional":true,"name":"AutoConnect","type":"boolean"},"Host":{"optional":true,"name":"Host","type":"string"},"IPsec":{"optional":true,"name":"IPsec","$ref":"networkingPrivate.IPSecProperties"},"L2TP":{"optional":true,"name":"L2TP","$ref":"networkingPrivate.L2TPProperties"},"OpenVPN":{"optional":true,"name":"OpenVPN","$ref":"networkingPrivate.OpenVPNProperties"},"ThirdPartyVPN":{"optional":true,"name":"ThirdPartyVPN","$ref":"networkingPrivate.ThirdPartyVPNProperties"},"Type":{"optional":true,"name":"Type","type":"string"}},"type":"object"},{"id":"networkingPrivate.ManagedVPNProperties","properties":{"AutoConnect":{"optional":true,"name":"AutoConnect","$ref":"networkingPrivate.ManagedBoolean"},"Host":{"optional":true,"name":"Host","$ref":"networkingPrivate.ManagedDOMString"},"IPsec":{"optional":true,"name":"IPsec","$ref":"networkingPrivate.ManagedIPSecProperties"},"L2TP":{"optional":true,"name":"L2TP","$ref":"networkingPrivate.ManagedL2TPProperties"},"OpenVPN":{"optional":true,"name":"OpenVPN","$ref":"networkingPrivate.ManagedOpenVPNProperties"},"ThirdPartyVPN":{"optional":true,"name":"ThirdPartyVPN","$ref":"networkingPrivate.ManagedThirdPartyVPNProperties"},"Type":{"optional":true,"name":"Type","$ref":"networkingPrivate.ManagedDOMString"}},"type":"object"},{"id":"networkingPrivate.VPNStateProperties","properties":{"Type":{"name":"Type","type":"string"},"IPsec":{"optional":true,"name":"IPsec","$ref":"networkingPrivate.IPSecProperties"},"ThirdPartyVPN":{"optional":true,"name":"ThirdPartyVPN","$ref":"networkingPrivate.ThirdPartyVPNProperties"}},"type":"object"},{"id":"networkingPrivate.WiFiProperties","properties":{"AllowGatewayARPPolling":{"optional":true,"name":"AllowGatewayARPPolling","type":"boolean"},"AutoConnect":{"optional":true,"name":"AutoConnect","type":"boolean"},"BSSID":{"optional":true,"name":"BSSID","type":"string"},"EAP":{"optional":true,"name":"EAP","$ref":"networkingPrivate.EAPProperties"},"Frequency":{"optional":true,"name":"Frequency","type":"integer"},"FrequencyList":{"optional":true,"name":"FrequencyList","type":"array","items":{"type":"integer"}},"HexSSID":{"optional":true,"name":"HexSSID","type":"string"},"HiddenSSID":{"optional":true,"name":"HiddenSSID","type":"boolean"},"Passphrase":{"optional":true,"name":"Passphrase","type":"string"},"SSID":{"optional":true,"name":"SSID","type":"string"},"Security":{"optional":true,"name":"Security","type":"string"},"SignalStrength":{"optional":true,"name":"SignalStrength","type":"integer"}},"type":"object"},{"id":"networkingPrivate.ManagedWiFiProperties","properties":{"AllowGatewayARPPolling":{"optional":true,"name":"AllowGatewayARPPolling","$ref":"networkingPrivate.ManagedBoolean"},"AutoConnect":{"optional":true,"name":"AutoConnect","$ref":"networkingPrivate.ManagedBoolean"},"BSSID":{"optional":true,"name":"BSSID","type":"string"},"EAP":{"optional":true,"name":"EAP","$ref":"networkingPrivate.ManagedEAPProperties"},"Frequency":{"optional":true,"name":"Frequency","type":"integer"},"FrequencyList":{"optional":true,"name":"FrequencyList","type":"array","items":{"type":"integer"}},"HexSSID":{"optional":true,"name":"HexSSID","$ref":"networkingPrivate.ManagedDOMString"},"HiddenSSID":{"optional":true,"name":"HiddenSSID","$ref":"networkingPrivate.ManagedBoolean"},"Passphrase":{"optional":true,"name":"Passphrase","$ref":"networkingPrivate.ManagedDOMString"},"SSID":{"optional":true,"name":"SSID","$ref":"networkingPrivate.ManagedDOMString"},"Security":{"name":"Security","$ref":"networkingPrivate.ManagedDOMString"},"SignalStrength":{"optional":true,"name":"SignalStrength","type":"integer"}},"type":"object"},{"id":"networkingPrivate.WiFiStateProperties","properties":{"BSSID":{"optional":true,"name":"BSSID","type":"string"},"EAP":{"optional":true,"name":"EAP","$ref":"networkingPrivate.EAPStateProperties"},"Frequency":{"optional":true,"name":"Frequency","type":"integer"},"HexSSID":{"optional":true,"name":"HexSSID","type":"string"},"Security":{"name":"Security","type":"string"},"SignalStrength":{"optional":true,"name":"SignalStrength","type":"integer"},"SSID":{"optional":true,"name":"SSID","type":"string"}},"type":"object"},{"id":"networkingPrivate.NetworkConfigProperties","properties":{"Cellular":{"optional":true,"name":"Cellular","$ref":"networkingPrivate.CellularProperties)R" R"R("},"Ethernet":{"optional":true,"name":"Ethernet","$ref":"networkingPrivate.EthernetProperties"},"GUID":{"optional":true,"name":"GUID","type":"string"},"IPAddressConfigType":{"optional":true,"name":"IPAddressConfigType","$ref":"networkingPrivate.IPConfigType"},"Name":{"optional":true,"name":"Name","type":"string"},"NameServersConfigType":{"optional":true,"name":"NameServersConfigType","$ref":"networkingPrivate.IPConfigType"},"Priority":{"optional":true,"name":"Priority","type":"integer"},"ProxySettings":{"optional":true,"name":"ProxySettings","$ref":"networkingPrivate.ProxySettings"},"StaticIPConfig":{"optional":true,"name":"StaticIPConfig","$ref":"networkingPrivate.IPConfigProperties"},"Type":{"optional":true,"name":"Type","$ref":"networkingPrivate.NetworkType"},"VPN":{"optional":true,"name":"VPN","$ref":"networkingPrivate.VPNProperties"},"WiFi":{"optional":true,"name":"WiFi","$ref":"networkingPrivate.WiFiProperties"}},"type":"object"},{"id":"networkingPrivate.NetworkProperties","properties":{"Cellular":{"optional":true,"name":"Cellular","$ref":"networkingPrivate.CellularProperties"},"Connectable":{"optional":true,"name":"Connectable","type":"boolean"},"ConnectionState":{"optional":true,"name":"ConnectionState","$ref":"networkingPrivate.ConnectionStateType"},"ErrorState":{"optional":true,"name":"ErrorState","type":"string"},"Ethernet":{"optional":true,"name":"Ethernet","$ref":"networkingPrivate.EthernetProperties"},"GUID":{"name":"GUID","type":"string"},"IPAddressConfigType":{"optional":true,"name":"IPAddressConfigType","$ref":"networkingPrivate.IPConfigType"},"IPConfigs":{"optional":true,"name":"IPConfigs","type":"array","items":{"$ref":"networkingPrivate.IPConfigProperties"}},"MacAddress":{"optional":true,"name":"MacAddress","type":"string"},"Metered":{"optional":true,"name":"Metered","type":"boolean"},"Name":{"optional":true,"name":"Name","type":"string"},"NameServersConfigType":{"optional":true,"name":"NameServersConfigType","$ref":"networkingPrivate.IPConfigType"},"Priority":{"optional":true,"name":"Priority","type":"integer"},"ProxySettings":{"optional":true,"name":"ProxySettings","$ref":"networkingPrivate.ProxySettings"},"RestrictedConnectivity":{"optional":true,"name":"RestrictedConnectivity","type":"boolean"},"StaticIPConfig":{"optional":true,"name":"StaticIPConfig","$ref":"networkingPrivate.IPConfigProperties"},"SavedIPConfig":{"optional":true,"name":"SavedIPConfig","$ref":"networkingPrivate.IPConfigProperties"},"Source":{"optional":true,"name":"Source","type":"string"},"Tether":{"optional":true,"name":"Tether","$ref":"networkingPrivate.TetherProperties"},"TrafficCounterResetTime":{"optional":true,"name":"TrafficCounterResetTime","type":"number"},"Type":{"name":"Type","$ref":"networkingPrivate.NetworkType"},"VPN":{"optional":true,"name":"VPN","$ref":"networkingPrivate.VPNProperties"},"WiFi":{"optional":true,"name":"WiFi","$ref":"networkingPrivate.WiFiProperties"}},"type":"object"},{"id":"networkingPrivate.ManagedProperties","properties":{"Cellular":{"optional":true,"name":"Cellular","$ref":"networkingPrivate.ManagedCellularProperties"},"Connectable":{"optional":true,"name":"Connectable","type":"boolean"},"ConnectionState":{"optional":true,"name":"ConnectionState","$ref":"networkingPrivate.ConnectionStateType"},"ErrorState":{"optional":true,"name":"ErrorState","type":"string"},"Ethernet":{"optional":true,"name":"Ethernet","$ref":"networkingPrivate.ManagedEthernetProperties"},"GUID":{"name":"GUID","type":"string"},"IPAddressConfigType":{"optional":true,"name":"IPAddressConfigType","$ref":"networkingPrivate.ManagedIPConfigType"},"IPConfigs":{"optional":true,"name":"IPConfigs","type":"array","items":{"$ref":"networkingPrivate.IPConfigProperties"}},"MacAddress":{"optional":true,"name":"MacAddress","type":"string"},"Metered":{"optional":true,"name":"Metered","$ref":"networkingPrivate.ManagedBoolean"},"Name":{"optional":true,"name":"Name","$ref":"networkingPrivate.ManagedDOMString"},"NameServersConfigType":{"optional":true,"name":"NameServersConfigType","$ref":"networkingPrivate.ManagedIPConfigType"},"Priority":{"optional":true,"name":"Priority","$ref":"networkingPrivate.ManagedLong"},"ProxySettings":{"optional":true,"name":"ProxySettings","$ref":"networkingPrivate.ManagedProxySettings"},"RestrictedConnectivity":{"optional":true,"name":"RestrictedConnectivity","type":"boolean"},"StaticIPConfig":{"optional":true,"name":"StaticIPConfig","$ref":"networkingPrivate.ManagedIPConfigProperties"},"SavedIPConfig":{"optional":true,"name":"SavedIPConfig","$ref":"networkingPrivate.IPConfigProperties"},"Source":{"optional":true,"name":"Source","type":"string"},"Tether":{"optional":true,"name":"Tether","$ref":"networkingPrivate.TetherProperties"},"TrafficCounterResetTime":{"optional":true,"name":"TrafficCounterResetTime","type":"number"},"Type":{"name":"Type","$ref":"networkingPrivate.NetworkType"},"VPN":{"optional":true,"name":"VPN","$ref":"networkingPrivate.ManagedVPNProperties"},"WiFi":{"optional":true,"name":"WiFi","$ref":"networkingPrivate.ManagedWiFiProperties"}},"type":"object"},{"id":"networkingPrivate.NetworkStateProperties","properties":{"Cellular":{"optional":true,"name":"Cellular","$ref":"networkingPrivate.CellularStateProperties"},"Connectable":{"optional":true,"name":"Connectable","type":"boolean"},"ConnectionState":{"optional":true,"name":"ConnectionState","$ref":"networkingPrivate.ConnectionStateType"},"Ethernet":{"optional":true,"name":"Ethernet","$ref":"networkingPrivate.EthernetStateProperties"},"ErrorState":{"optional":true,"name":"ErrorState","type":"string"},"GUID":{"name":"GUID","type":"string"},"Name":{"optional":true,"name":"Name","type":"string"},"Priority":{"optional":true,"name":"Priority","type":"integer"},"Source":{"optional":true,"name":"Source","type":"string"},"Tether":{"optional":true,"name":"Tether","$ref":"networkingPrivate.TetherProperties"},"Type":{"name":"Type","$ref":"networkingPrivate.NetworkType"},"VPN":{"optional":true,"name":"VPN","$ref":"networkingPrivate.VPNStateProperties"},"WiFi":{"optional":true,"name":"WiFi","$ref":"networkingPrivate.WiFiStateProperties"}},"type":"object"},{"id":"networkingPrivate.DeviceStateProperties","properties":{"Scanning":{"optional":true,"name":"Scanning","type":"boolean"},"SIMLockStatus":{"optional":true,"name":"SIMLockStatus","$ref":"networkingPrivate.SIMLockStatus"},"SIMPresent":{"optional":true,"name":"SIMPresent","type":"boolean"},"State":{"name":"State","$ref":"networkingPrivate.DeviceStateType"},"Type":{"name":"Type","$ref":"networkingPrivate.NetworkType"},"ManagedNetworkAvailable":{"optional":true,"name":"ManagedNetworkAvailable","type":"boolean"}},"type":"object"},{"id":"networkingPrivate.NetworkFilter","properties":{"networkType":{"name":"networkType","$ref":"networkingPrivate.NetworkType"},"visible":{"optional":true,"name":"visible","type":"boolean"},"configured":{"optional":true,"name":"configured","type":"boolean"},"limit":{"optional":true,"name":"limit","type":"integer"}},"type":"object"},{"id":"networkingPrivate.GlobalPolicy","properties":{"AllowOnlyPolicyNetworksToAutoconnect":{"optional":true,"name":"AllowOnlyPolicyNetworksToAutoconnect","type":"boolean"},"AllowOnlyPolicyNetworksToConnect":{"optional":true,"name":"AllowOnlyPolicyNetworksToConnect","type":"boolean"},"AllowOnlyPolicyNetworksToConnectIfAvailable":{"optional":true,"name":"AllowOnlyPolicyNetworksToConnectIfAvailable","type":"boolean"},"BlockedHexSSIDs":{"optional":true,"name":"BlockedHexSSIDs","type":"array","items":{"type":"string"}}},"type":"object"},{"id":"networkingPrivate.Certificate","properties":{"hash":{"name":"hash","type":"string"},"issuedBy":{"name":"issuedBy","type":"string"},"issuedTo":{"name":"issuedTo","type":"string"},"pem":{"optional":true,"name":"pem","type":"string"},"PKCS11Id":{"optional":true,"name":"PKCS11Id","type":"string"},"hardwareBacked":{"name":"hardwareBacked","type":"boolean"},"deviceWide":{"name":"deviceWide","type":"boolean"}},"type":"object"},{"id":"networkingPrivate.CertificateLists","properties":{"serverCaCertificates":{"name":"serverCaCertificates","type":"array","items":{"$ref":"networkingPrivate.Certificate"}},"userCertificates":{"name":"userCertificates","typ)R" R"R(e":"array","items":{"$ref":"networkingPrivate.Certificate"}}},"type":"object"}],"functions":[{"parameters":[{"name":"networkGuid","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"result","$ref":"networkingPrivate.NetworkProperties"}]},"name":"getProperties","type":"function"},{"parameters":[{"name":"networkGuid","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"result","$ref":"networkingPrivate.ManagedProperties"}]},"name":"getManagedProperties","type":"function"},{"parameters":[{"name":"networkGuid","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"result","$ref":"networkingPrivate.NetworkStateProperties"}]},"name":"getState","type":"function"},{"parameters":[{"name":"networkGuid","type":"string"},{"name":"properties","$ref":"networkingPrivate.NetworkConfigProperties"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"setProperties","type":"function"},{"parameters":[{"name":"shared","type":"boolean"},{"name":"properties","$ref":"networkingPrivate.NetworkConfigProperties"}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"result","type":"string"}]},"name":"createNetwork","type":"function"},{"parameters":[{"name":"networkGuid","type":"string"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"forgetNetwork","type":"function"},{"parameters":[{"name":"filter","$ref":"networkingPrivate.NetworkFilter"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"array","items":{"$ref":"networkingPrivate.NetworkStateProperties"}}]},"name":"getNetworks","type":"function"},{"deprecated":"Use getNetworks.","parameters":[{"name":"networkType","$ref":"networkingPrivate.NetworkType"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"array","items":{"$ref":"networkingPrivate.NetworkStateProperties"}}]},"name":"getVisibleNetworks","type":"function"},{"deprecated":"Use getDeviceStates.","parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"array","items":{"$ref":"networkingPrivate.NetworkType"}}]},"name":"getEnabledNetworkTypes","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"array","items":{"$ref":"networkingPrivate.DeviceStateProperties"}}]},"name":"getDeviceStates","type":"function"},{"parameters":[{"name":"networkType","$ref":"networkingPrivate.NetworkType"}],"name":"enableNetworkType","type":"function"},{"parameters":[{"name":"networkType","$ref":"networkingPrivate.NetworkType"}],"name":"disableNetworkType","type":"function"},{"parameters":[{"name":"networkType","optional":true,"$ref":"networkingPrivate.NetworkType"}],"name":"requestNetworkScan","type":"function"},{"parameters":[{"name":"networkGuid","type":"string"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"startConnect","type":"function"},{"parameters":[{"name":"networkGuid","type":"string"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"startDisconnect","type":"function"},{"parameters":[{"name":"networkGuid","type":"string"},{"name":"carrier","optional":true,"type":"string"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"startActivate","type":"function"},{"parameters":[{"name":"networkGuid","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"result","$ref":"networkingPrivate.CaptivePortalStatus"}]},"name":"getCaptivePortalStatus","type":"function"},{"parameters":[{"name":"networkGuid","type":"string"},{"name":"pin","type":"string"},{"name":"puk","optional":true,"type":"string"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"unlockCellularSim","type":"function"},{"parameters":[{"name":"networkGuid","type":"string"},{"name":"simState","$ref":"networkingPrivate.CellularSimState"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"setCellularSimState","type":"function"},{"parameters":[{"name":"networkGuid","type":"string"},{"name":"networkId","type":"string"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"selectCellularMobileNetwork","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"result","$ref":"networkingPrivate.GlobalPolicy"}]},"name":"getGlobalPolicy","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"result","$ref":"networkingPrivate.CertificateLists"}]},"name":"getCertificateLists","type":"function"}],"properties":{},"events":[{"parameters":[{"name":"changes","type":"array","items":{"type":"string"}}],"name":"onNetworksChanged","type":"function"},{"parameters":[{"name":"changes","type":"array","items":{"type":"string"}}],"name":"onNetworkListChanged","type":"function"},{"parameters":[],"name":"onDeviceStateListChanged","type":"function"},{"parameters":[{"name":"networkGuid","type":"string"},{"name":"status","$ref":"networkingPrivate.CaptivePortalStatus"}],"name":"onPortalDetectionCompleted","type":"function"},{"parameters":[],"name":"onCertificateListsChanged","type":"function"}],"platforms":null,"deprecated":null})R";
constexpr char kPrinterProvider[] = R"R({"namespace":"printerProvider","types":[{"id":"printerProvider.PrintError","type":"string","enum":[{"name":"OK"},{"name":"FAILED"},{"name":"INVALID_TICKET"},{"name":"INVALID_DATA"}]},{"id":"printerProvider.PrinterInfo","properties":{"id":{"name":"id","type":"string"},"name":{"name":"name","type":"string"},"description":{"optional":true,"name":"description","type":"string"}},"type":"object"},{"id":"printerProvider.PrintJob","properties":{"printerId":{"name":"printerId","type":"string"},"title":{"name":"title","type":"string"},"ticket":{"name":"ticket","type":"object","additionalProperties":{"type":"any"}},"contentType":{"name":"contentType","type":"string"},"document":{"name":"document","type":"object","additionalProperties":{"type":"any"},"isInstanceOf":"Blob"}},"type":"object"}],"functions":[],"properties":{},"events":[{"parameters":[{"name":"resultCallback","parameters":[{"name":"printerInfo","type":"array","items":{"$ref":"printerProvider.PrinterInfo"}}],"type":"function"}],"name":"onGetPrintersRequested","type":"function"},{"parameters":[{"name":"device","$ref":"usb.Device"},{"name":"resultCallback","parameters":[{"name":"printerInfo","optional":true,"$ref":"printerProvider.PrinterInfo"}],"type":"function"}],"name":"onGetUsbPrinterInfoRequested","type":"function"},{"parameters":[{"name":"printerId","type":"string"},{"name":"resultCallback","parameters":[{"name":"capabilities","type":"object","additionalProperties":{"type":"any"}}],"type":"function"}],"name":"onGetCapabilityRequested","type":"function"},{"parameters":[{"name":"printJob","$ref":"printerProvider.PrintJob"},{"name":"resultCallback","parameters":[{"name":"result","$ref":"printerProvider.PrintError"}],"type":"function"}],"name":"onPrintRequested","type":"function"}],"platforms":null,"deprecated":null})R";
constexpr char kPrinterProviderInternal[] = R"R({"namespace":"printerProviderInternal","types":[{"id":"printerProviderInternal.PrintError","type":"string","enum":[{"name":"OK"},{"name":"FAILED"},{"name":"INVALID_TICKET"},{"name":"INVALID_DATA"}]}],"functions":[{"parameters":[{"name":"requestId","type":"integer"},{"name":"printers","optional":true,"type":"array","items":{"$ref":"printerProvider.PrinterInfo"}}],"name":"reportPrinters","type":"function"},{"parameters":[{"name":"requestId","type":"integer"},{"name":"printerInfo","optional":true,"$ref":"printerProvider.PrinterInfo"}],"name":"reportUsbPrinterInfo","type":"function"},{"parameters":[{"name":"request_id","type":"integer"},{"name":"capability","optional":true,"type":"object","additionalProperties":{"type":"any"}}],"name":"reportPrinterCapability","type":"function"},{"parameters":[{"name":"request_id","type":"integer"},{"name":"error","optional":true,"$ref":"printerProviderInternal.PrintError"}],"name":"reportPrintResult","type":"function"},{"parameters":[{"name":"requestId","type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"blob","type":"object","additionalProperties":{"type":"any"},"isInstanceOf":"Blob"}]},"name":"getPrintData","type":"function"}],"properties":{},"events":[],"platforms":null,"deprecated":null})R";
constexpr char kSerial[] = R"R({"namespace":"serial","types":[{"id":"serial.DeviceInfo","properties":{"path":{"name":"path","type":"string"},"vendorId":{"optional":true,"name":"vendorId","type":"integer"},"productId":{"optional":true,"name":"productId","type":"integer"},"displayName":{"optional":true,"name":"displayName","type":"string"}},"type":"object"},{"id":"serial.DataBits","type":"string","enum":[{"name":"seven"},{"name":"eight"}]},{"id":"serial.ParityBit","type":"string","enum":[{"name":"no"},{"name":"odd"},{"name":"even"}]},{"id":"serial.StopBits","type":"string","enum":[{"name":"one"},{"name":"two"}]},{"id":"serial.ConnectionOptions","properties":{"persistent":{"optional":true,"name":"persistent","type":"boolean"},"name":{"optional":true,"name":"name","type":"string"},"bufferSize":{"optional":true,"name":"bufferSize","type":"integer"},"bitrate":{"optional":true,"name":"bitrate","type":"integer"},"dataBits":{"optional":true,"name":"dataBits","$ref":"serial.DataBits"},"parityBit":{"optional":true,"name":"parityBit","$ref":"serial.ParityBit"},"stopBits":{"optional":true,"name":"stopBits","$ref":"serial.StopBits"},"ctsFlowControl":{"optional":true,"name":"ctsFlowControl","type":"boolean"},"receiveTimeout":{"optional":true,"name":"receiveTimeout","type":"integer"},"sendTimeout":{"optional":true,"name":"sendTimeout","type":"integer"}},"type":"object"},{"id":"serial.ConnectionInfo","properties":{"connectionId":{"name":"connectionId","type":"integer"},"paused":{"name":"paused","type":"boolean"},"persistent":{"name":"persistent","type":"boolean"},"name":{"name":"name","type":"string"},"bufferSize":{"name":"bufferSize","type":"integer"},"receiveTimeout":{"name":"receiveTimeout","type":"integer"},"sendTimeout":{"name":"sendTimeout","type":"integer"},"bitrate":{"optional":true,"name":"bitrate","type":"integer"},"dataBits":{"optional":true,"name":"dataBits","$ref":"serial.DataBits"},"parityBit":{"optional":true,"name":"parityBit","$ref":"serial.ParityBit"},"stopBits":{"optional":true,"name":"stopBits","$ref":"serial.StopBits"},"ctsFlowControl":{"optional":true,"name":"ctsFlowControl","type":"boolean"}},"type":"object"},{"id":"serial.SendError","type":"string","enum":[{"name":"disconnected"},{"name":"pending"},{"name":"timeout"},{"name":"system_error"}]},{"id":"serial.SendInfo","properties":{"bytesSent":{"name":"bytesSent","type":"integer"},"error":{"optional":true,"name":"error","$ref":"serial.SendError"}},"type":"object"},{"id":"serial.HostControlSignals","properties":{"dtr":{"optional":true,"name":"dtr","type":"boolean"},"rts":{"optional":true,"name":"rts","type":"boolean"}},"type":"object"},{"id":"serial.DeviceControlSignals","properties":{"dcd":{"name":"dcd","type":"boolean"},"cts":{"name":"cts","type":"boolean"},"ri":{"name":"ri","type":"boolean"},"dsr":{"name":"dsr","type":"boolean"}},"type":"object"},{"id":"serial.ReceiveInfo","properties":{"connectionId":{"name":"connectionId","type":"integer"},"data":{"name":"data","type":"binary","isInstanceOf":"ArrayBuffer"}},"type":"object"},{"id":"serial.ReceiveError","type":"string","enum":[{"name":"disconnected"},{"name":"timeout"},{"name":"device_lost"},{"name":"break"},{"name":"frame_error"},{"name":"overrun"},{"name":"buffer_overflow"},{"name":"parity_error"},{"name":"system_error"}]},{"id":"serial.ReceiveErrorInfo","properties":{"connectionId":{"name":"connectionId","type":"integer"},"error":{"name":"error","$ref":"serial.ReceiveError"}},"type":"object"}],"functions":[{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"ports","type":"array","items":{"$ref":"serial.DeviceInfo"}}]},"name":"getDevices","type":"function"},{"parameters":[{"name":"path","type":"string"},{"name":"options","optional":true,"$ref":"serial.ConnectionOptions"}],"returns_async":{"name":"callback","parameters":[{"name":"connectionInfo","$ref":"serial.ConnectionInfo"}]},"name":"connect","type":"function"},{"parameters":[{"name":"connectionId","type":"integer"},{"name":"options","$ref":"serial.ConnectionOptions"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"boolean"}]},"name":"update","type":"function"},{"parameters":[{"name":"connectionId","type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"boolean"}]},"name":"disconnect","type":"function"},{"parameters":[{"name":"connectionId","type":"integer"},{"name":"paused","type":"boolean"}],"returns_async":{"name":"callback","parameters":[]},"name":"setPaused","type":"function"},{"parameters":[{"name":"connectionId","type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"connectionInfo","$ref":"serial.ConnectionInfo"}]},"name":"getInfo","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"connectionInfos","type":"array","items":{"$ref":"serial.ConnectionInfo"}}]},"name":"getConnections","type":"function"},{"parameters":[{"name":"connectionId","type":"integer"},{"name":"data","type":"binary","isInstanceOf":"ArrayBuffer"}],"returns_async":{"name":"callback","parameters":[{"name":"sendInfo","$ref":"serial.SendInfo"}]},"name":"send","type":"function"},{"parameters":[{"name":"connectionId","type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"boolean"}]},"name":"flush","type":"function"},{"parameters":[{"name":"connectionId","type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"signals","$ref":"serial.DeviceControlSignals"}]},"name":"getControlSignals","type":"function"},{"parameters":[{"name":"connectionId","type":"integer"},{"name":"signals","$ref":"serial.HostControlSignals"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"boolean"}]},"name":"setControlSignals","type":"function"},{"parameters":[{"name":"connectionId","type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"boolean"}]},"name":"setBreak","type":"function"},{"parameters":[{"name":"connectionId","type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"boolean"}]},"name":"clearBreak","type":"function"}],"properties":{},"events":[{"parameters":[{"name":"info","$ref":"serial.ReceiveInfo"}],"name":"onReceive","type":"function"},{"parameters":[{"name":"info","$ref":"serial.ReceiveErrorInfo"}],"name":"onReceiveError","type":"function"}],"platforms":null,"deprecated":null})R";
constexpr char kSocket[] = R"R({"namespace":"socket","types":[{"id":"socket.SocketType","type":"string","enum":[{"name":"tcp"},{"name":"udp"}]},{"id":"socket.CreateOptions","properties":{},"type":"object"},{"id":"socket.CreateInfo","properties":{"socketId":{"name":"socketId","type":"integer"}},"type":"object"},{"id":"socket.AcceptInfo","properties":{"resultCode":{"name":"resultCode","type":"integer"},"socketId":{"optional":true,"name":"socketId","type":"integer"}},"type":"object"},{"id":"socket.ReadInfo","properties":{"resultCode":{"name":"resultCode","type":"integer"},"data":{"name":"data","type":"binary","isInstanceOf":"ArrayBuffer"}},"type":"object"},{"id":"socket.WriteInfo","properties":{"bytesWritten":{"name":"bytesWritten","type":"integer"}},"type":"object"},{"id":"socket.RecvFromInfo","properties":{"resultCode":{"name":"resultCode","type":"integer"},"data":{"name":"data","type":"binary","isInstanceOf":"ArrayBuffer"},"address":{"name":"address","type":"string"},"port":{"name":"port","type":"integer"}},"type":"object"},{"id":"socket.SocketInfo","properties":{"socketType":{"name":"socketType","$ref":"socket.SocketType"},"connected":{"name":"connected","type":"boolean"},"peerAddress":{"optional":true,"name":"peerAddress","type":"string"},"peerPort":{"optional":true,"name":"peerPort","type":"integer"},"localAddress":{"optional":true,"name":"localAddress","type":"string"},"localPort":{"optional":true,"name":"localPort","type":"integer"}},"type":"object"},{"id":"socket.NetworkInterface","properties":{"name":{"name":"name","type":"string"},"address":{"name":"address","type":"string"},"prefixLength":{"name":"prefixLength","type":"integer"}},"type":"object"},{"id":"socket.TLSVersionConstraints","properties":{"min":{"optional":true,"name":"min","type":"string"},"max":{"optional":true,"name":"max","type":"string"}},"type":"object"},{"id":"socket.SecureOptions","properties":{"tlsVersion":{"optional":true,"name":"tlsVersion","$ref":"socket.TLSVersionConstraints"}},"type":"object"}],"functions":[{"parameters":[{"name":"type","$ref":"socket.SocketType"},{"name":"options","optional":true,"$ref":"socket.CreateOptions"}],"returns_async":{"name":"callback","parameters":[{"name":"createInfo","$ref":"socket.CreateInfo"}]},"name":"create","type":"function"},{"parameters":[{"name":"socketId","type":"integer"}],"name":"destroy","type":"function"},{"parameters":[{"name":"socketId","type":"integer"},{"name":"hostname","type":"string"},{"name":"port","type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"integer"}],"does_not_support_promises":"Sets error along with callback arguments crbug.com/1504372"},"name":"connect","type":"function"},{"parameters":[{"name":"socketId","type":"integer"},{"name":"address","type":"string"},{"name":"port","type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"integer"}],"does_not_support_promises":"Sets error along with callback arguments crbug.com/1504372"},"name":"bind","type":"function"},{"parameters":[{"name":"socketId","type":"integer"}],"name":"disconnect","type":"function"},{"parameters":[{"name":"socketId","type":"integer"},{"name":"bufferSize","optional":true,"type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"readInfo","$ref":"socket.ReadInfo"}],"does_not_support_promises":"Sets error along with callback arguments crbug.com/1504372"},"name":"read","type":"function"},{"parameters":[{"name":"socketId","type":"integer"},{"name":"data","type":"binary","isInstanceOf":"ArrayBuffer"}],"returns_async":{"name":"callback","parameters":[{"name":"writeInfo","$ref":"socket.WriteInfo"}],"does_not_support_promises":"Sets error along with callback arguments crbug.com/1504372"},"name":"write","type":"function"},{"parameters":[{"name":"socketId","type":"integer"},{"name":"bufferSize","optional":true,"type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"recvFromInfo","$ref":"socket.RecvFromInfo"}],"does_not_support_promises":"Sets error along with callback arguments crbug.com/1504372"},"name":"recvFrom","type":"function"},{"parameters":[{"name":"socketId","type":"integer"},{"name":"data","type":"binary","isInstanceOf":"ArrayBuffer"},{"name":"address","type":"string"},{"name":"port","type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"writeInfo","$ref":"socket.WriteInfo"}],"does_not_support_promises":"Sets error along with callback arguments crbug.com/1504372"},"name":"sendTo","type":"function"},{"parameters":[{"name":"socketId","type":"integer"},{"name":"address","type":"string"},{"name":"port","type":"integer"},{"name":"backlog","optional":true,"type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"integer"}],"does_not_support_promises":"Sets error along with callback arguments crbug.com/1504372"},"name":"listen","type":"function"},{"parameters":[{"name":"socketId","type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"acceptInfo","$ref":"socket.AcceptInfo"}],"does_not_support_promises":"Sets error along with callback arguments crbug.com/1504372"},"name":"accept","type":"function"},{"parameters":[{"name":"socketId","type":"integer"},{"name":"enable","type":"boolean"},{"name":"delay","optional":true,"type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"boolean"}],"does_not_support_promises":"Sets error along with callback arguments crbug.com/1504372"},"name":"setKeepAlive","type":"function"},{"parameters":[{"name":"socketId","type":"integer"},{"name":"noDelay","type":"boolean"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"boolean"}],"does_not_support_promises":"Sets error along with callback arguments crbug.com/1504372"},"name":"setNoDelay","type":"function"},{"parameters":[{"name":"socketId","type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"result","$ref":"socket.SocketInfo"}]},"name":"getInfo","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"array","items":{"$ref":"socket.NetworkInterface"}}]},"name":"getNetworkList","type":"function"},{"parameters":[{"name":"socketId","type":"integer"},{"name":"address","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"integer"}],"does_not_support_promises":"Sets error along with callback arguments crbug.com/1504372"},"name":"joinGroup","type":"function"},{"parameters":[{"name":"socketId","type":"integer"},{"name":"address","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"integer"}],"does_not_support_promises":"Sets error along with callback arguments crbug.com/1504372"},"name":"leaveGroup","type":"function"},{"parameters":[{"name":"socketId","type":"integer"},{"name":"ttl","type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"integer"}],"does_not_support_promises":"Sets error along with callback arguments crbug.com/1504372"},"name":"setMulticastTimeToLive","type":"function"},{"parameters":[{"name":"socketId","type":"integer"},{"name":"enabled","type":"boolean"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"integer"}],"does_not_support_promises":"Sets error along with callback arguments crbug.com/1504372"},"name":"setMulticastLoopbackMode","type":"function"},{"parameters":[{"name":"socketId","type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"groups","type":"array","items":{"type":"string"}}],"does_not_support_promises":"Sets error along with callback arguments crbug.com/1504372"},"name":"getJoinedGroups","type":"function"},{"parameters":[{"name":"socketId","type":"integer"},{"name":"options","optional":true,"$ref":"socket.SecureOptions"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"integer"}],"does_not_support_promises":"Sets error along with callback arguments crbug.com/1504372"},"name":"secure","type":"function"}],"properties":{},"events":[],"platforms":null,"deprecated":null})R";
constexpr char kSocketsTcp[] = R"R({"namespace":"sockets.tcp","types":[{"id":"sockets.tcp.SocketProperties","properties":{"persistent":{"optional":true,"name":"persistent","type":"boolean"},"name":{"optional":true,"name":"name","type":"string"},"bufferSize":{"optional":true,"name":"bufferSize","type":"integer"}},"type":"object"},{"id":"sockets.tcp.CreateInfo","properties":{"socketId":{"name":"socketId","type":"integer"}},"type":"object"},{"id":"sockets.tcp.DnsQueryType","type":"string","enum":[{"name":"any"},{"name":"ipv4"},{"name":"ipv6"}]},{"id":"sockets.tcp.SendInfo","properties":{"resultCode":{"name":"resultCode","type":"integer"},"bytesSent":{"optional":true,"name":"bytesSent","type":"integer"}},"type":"object"},{"id":"sockets.tcp.TLSVersionConstraints","properties":{"min":{"optional":true,"name":"min","type":"string"},"max":{"optional":true,"name":"max","type":"string"}},"type":"object"},{"id":"sockets.tcp.SecureOptions","properties":{"tlsVersion":{"optional":true,"name":"tlsVersion","$ref":"sockets.tcp.TLSVersionConstraints"}},"type":"object"},{"id":"sockets.tcp.SocketInfo","properties":{"socketId":{"name":"socketId","type":"integer"},"persistent":{"name":"persistent","type":"boolean"},"name":{"optional":true,"name":"name","type":"string"},"bufferSize":{"optional":true,"name":"bufferSize","type":"integer"},"paused":{"name":"paused","type":"boolean"},"connected":{"name":"connected","type":"boolean"},"localAddress":{"optional":true,"name":"localAddress","type":"string"},"localPort":{"optional":true,"name":"localPort","type":"integer"},"peerAddress":{"optional":true,"name":"peerAddress","type":"string"},"peerPort":{"optional":true,"name":"peerPort","type":"integer"}},"type":"object"},{"id":"sockets.tcp.ReceiveInfo","properties":{"socketId":{"name":"socketId","type":"integer"},"data":{"name":"data","type":"binary","isInstanceOf":"ArrayBuffer"}},"type":"object"},{"id":"sockets.tcp.ReceiveErrorInfo","properties":{"socketId":{"name":"socketId","type":"integer"},"resultCode":{"name":"resultCode","type":"integer"}},"type":"object"}],"functions":[{"parameters":[{"name":"properties","optional":true,"$ref":"sockets.tcp.SocketProperties"}],"returns_async":{"name":"callback","parameters":[{"name":"createInfo","$ref":"sockets.tcp.CreateInfo"}]},"name":"create","type":"function"},{"parameters":[{"name":"socketId","type":"integer"},{"name":"properties","$ref":"sockets.tcp.SocketProperties"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"update","type":"function"},{"parameters":[{"name":"socketId","type":"integer"},{"name":"paused","type":"boolean"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"setPaused","type":"function"},{"parameters":[{"name":"socketId","type":"integer"},{"name":"enable","type":"boolean"},{"name":"delay","optional":true,"type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"integer"}],"does_not_support_promises":"Sets error along with callback arguments crbug.com/1504372"},"name":"setKeepAlive","type":"function"},{"parameters":[{"name":"socketId","type":"integer"},{"name":"noDelay","type":"boolean"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"integer"}],"does_not_support_promises":"Sets error along with callback arguments crbug.com/1504372"},"name":"setNoDelay","type":"function"},{"parameters":[{"name":"socketId","type":"integer"},{"name":"peerAddress","type":"string"},{"name":"peerPort","type":"integer"},{"name":"dnsQueryType","optional":true,"$ref":"sockets.tcp.DnsQueryType"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"integer"}],"does_not_support_promises":"Sets error along with callback arguments crbug.com/1504372"},"name":"connect","type":"function"},{"parameters":[{"name":"socketId","type":"integer"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"disconnect","type":"function"},{"parameters":[{"name":"socketId","type":"integer"},{"name":"options","optional":true,"$ref":"sockets.tcp.SecureOptions"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"integer"}],"does_not_support_promises":"Sets error along with callback arguments crbug.com/1504372"},"name":"secure","type":"function"},{"parameters":[{"name":"socketId","type":"integer"},{"name":"data","type":"binary","isInstanceOf":"ArrayBuffer"}],"returns_async":{"name":"callback","parameters":[{"name":"sendInfo","$ref":"sockets.tcp.SendInfo"}],"does_not_support_promises":"Sets error along with callback arguments crbug.com/1504372"},"name":"send","type":"function"},{"parameters":[{"name":"socketId","type":"integer"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"close","type":"function"},{"parameters":[{"name":"socketId","type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"socketInfo","$ref":"sockets.tcp.SocketInfo"}]},"name":"getInfo","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"socketInfos","type":"array","items":{"$ref":"sockets.tcp.SocketInfo"}}]},"name":"getSockets","type":"function"}],"properties":{},"events":[{"parameters":[{"name":"info","$ref":"sockets.tcp.ReceiveInfo"}],"name":"onReceive","type":"function"},{"parameters":[{"name":"info","$ref":"sockets.tcp.ReceiveErrorInfo"}],"name":"onReceiveError","type":"function"}],"platforms":null,"deprecated":null})R";
constexpr char kSocketsTcpServer[] = R"R({"namespace":"sockets.tcpServer","types":[{"id":"sockets.tcpServer.SocketProperties","properties":{"persistent":{"optional":true,"name":"persistent","type":"boolean"},"name":{"optional":true,"name":"name","type":"string"}},"type":"object"},{"id":"sockets.tcpServer.CreateInfo","properties":{"socketId":{"name":"socketId","type":"integer"}},"type":"object"},{"id":"sockets.tcpServer.SocketInfo","properties":{"socketId":{"name":"socketId","type":"integer"},"persistent":{"name":"persistent","type":"boolean"},"name":{"optional":true,"name":"name","type":"string"},"paused":{"name":"paused","type":"boolean"},"localAddress":{"optional":true,"name":"localAddress","type":"string"},"localPort":{"optional":true,"name":"localPort","type":"integer"}},"type":"object"},{"id":"sockets.tcpServer.AcceptInfo","properties":{"socketId":{"name":"socketId","type":"integer"},"clientSocketId":{"name":"clientSocketId","type":"integer"}},"type":"object"},{"id":"sockets.tcpServer.AcceptErrorInfo","properties":{"socketId":{"name":"socketId","type":"integer"},"resultCode":{"name":"resultCode","type":"integer"}},"type":"object"}],"functions":[{"parameters":[{"name":"properties","optional":true,"$ref":"sockets.tcpServer.SocketProperties"}],"returns_async":{"name":"callback","parameters":[{"name":"createInfo","$ref":"sockets.tcpServer.CreateInfo"}]},"name":"create","type":"function"},{"parameters":[{"name":"socketId","type":"integer"},{"name":"properties","$ref":"sockets.tcpServer.SocketProperties"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"update","type":"function"},{"parameters":[{"name":"socketId","type":"integer"},{"name":"paused","type":"boolean"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"setPaused","type":"function"},{"parameters":[{"name":"socketId","type":"integer"},{"name":"address","type":"string"},{"name":"port","type":"integer"},{"name":"backlog","optional":true,"type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"integer"}],"does_not_support_promises":"Sets error along with callback arguments crbug.com/1504372"},"name":"listen","type":"function"},{"parameters":[{"name":"socketId","type":"integer"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"disconnect","type":"function"},{"parameters":[{"name":"socketId","type":"integer"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"close","type":"function"},{"parameters":[{"name":"socketId","type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"socketInfo","$ref":"sockets.tcpServer.SocketInfo"}]},"name":"getInfo","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"socketInfos","type":"array","items":{"$ref":"sockets.tcpServer.SocketInfo"}}]},"name":"getSockets","type":"function"}],"properties":{},"events":[{"parameters":[{"name":"info","$ref":"sockets.tcpServer.AcceptInfo"}],"name":"onAccept","type":"function"},{"parameters":[{"name":"info","$ref":"sockets.tcpServer.AcceptErrorInfo"}],"name":"onAcceptError","type":"function"}],"platforms":null,"deprecated":null})R";
constexpr char kSocketsUdp[] = R"R({"namespace":"sockets.udp","types":[{"id":"sockets.udp.SocketProperties","properties":{"persistent":{"optional":true,"name":"persistent","type":"boolean"},"name":{"optional":true,"name":"name","type":"string"},"bufferSize":{"optional":true,"name":"bufferSize","type":"integer"}},"type":"object"},{"id":"sockets.udp.CreateInfo","properties":{"socketId":{"name":"socketId","type":"integer"}},"type":"object"},{"id":"sockets.udp.DnsQueryType","type":"string","enum":[{"name":"any"},{"name":"ipv4"},{"name":"ipv6"}]},{"id":"sockets.udp.SendInfo","properties":{"resultCode":{"name":"resultCode","type":"integer"},"bytesSent":{"optional":true,"name":"bytesSent","type":"integer"}},"type":"object"},{"id":"sockets.udp.SocketInfo","properties":{"socketId":{"name":"socketId","type":"integer"},"persistent":{"name":"persistent","type":"boolean"},"name":{"optional":true,"name":"name","type":"string"},"bufferSize":{"optional":true,"name":"bufferSize","type":"integer"},"paused":{"name":"paused","type":"boolean"},"localAddress":{"optional":true,"name":"localAddress","type":"string"},"localPort":{"optional":true,"name":"localPort","type":"integer"}},"type":"object"},{"id":"sockets.udp.ReceiveInfo","properties":{"socketId":{"name":"socketId","type":"integer"},"data":{"name":"data","type":"binary","isInstanceOf":"ArrayBuffer"},"remoteAddress":{"name":"remoteAddress","type":"string"},"remotePort":{"name":"remotePort","type":"integer"}},"type":"object"},{"id":"sockets.udp.ReceiveErrorInfo","properties":{"socketId":{"name":"socketId","type":"integer"},"resultCode":{"name":"resultCode","type":"integer"}},"type":"object"}],"functions":[{"parameters":[{"name":"properties","optional":true,"$ref":"sockets.udp.SocketProperties"}],"returns_async":{"name":"callback","parameters":[{"name":"createInfo","$ref":"sockets.udp.CreateInfo"}]},"name":"create","type":"function"},{"parameters":[{"name":"socketId","type":"integer"},{"name":"properties","$ref":"sockets.udp.SocketProperties"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"update","type":"function"},{"parameters":[{"name":"socketId","type":"integer"},{"name":"paused","type":"boolean"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"setPaused","type":"function"},{"parameters":[{"name":"socketId","type":"integer"},{"name":"address","type":"string"},{"name":"port","type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"integer"}],"does_not_support_promises":"Sets error along with callback arguments crbug.com/1504372"},"name":"bind","type":"function"},{"parameters":[{"name":"socketId","type":"integer"},{"name":"data","type":"binary","isInstanceOf":"ArrayBuffer"},{"name":"address","type":"string"},{"name":"port","type":"integer"},{"name":"dnsQueryType","optional":true,"$ref":"sockets.udp.DnsQueryType"}],"returns_async":{"name":"callback","parameters":[{"name":"sendInfo","$ref":"sockets.udp.SendInfo"}],"does_not_support_promises":"Sets error along with callback arguments crbug.com/1504372"},"name":"send","type":"function"},{"parameters":[{"name":"socketId","type":"integer"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"close","type":"function"},{"parameters":[{"name":"socketId","type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"socketInfo","$ref":"sockets.udp.SocketInfo"}]},"name":"getInfo","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"socketInfos","type":"array","items":{"$ref":"sockets.udp.SocketInfo"}}]},"name":"getSockets","type":"function"},{"parameters":[{"name":"socketId","type":"integer"},{"name":"address","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"integer"}],"does_not_support_promises":"Sets error along with callback arguments crbug.com/1504372"},"name":"joinGroup","type":"function"},{"parameters":[{"name":"socketId","type":"integer"},{"name":"address","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"integer"}],"does_not_support_promises":"Sets error along with callback arguments crbug.com/1504372"},"name":"leaveGroup","type":"function"},{"parameters":[{"name":"socketId","type":"integer"},{"name":"ttl","type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"integer"}],"does_not_support_promises":"Sets error along with callback arguments crbug.com/1504372"},"name":"setMulticastTimeToLive","type":"function"},{"parameters":[{"name":"socketId","type":"integer"},{"name":"enabled","type":"boolean"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"integer"}],"does_not_support_promises":"Sets error along with callback arguments crbug.com/1504372"},"name":"setMulticastLoopbackMode","type":"function"},{"parameters":[{"name":"socketId","type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"groups","type":"array","items":{"type":"string"}}]},"name":"getJoinedGroups","type":"function"},{"parameters":[{"name":"socketId","type":"integer"},{"name":"enabled","type":"boolean"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"integer"}],"does_not_support_promises":"Sets error along with callback arguments crbug.com/1504372"},"name":"setBroadcast","type":"function"}],"properties":{},"events":[{"parameters":[{"name":"info","$ref":"sockets.udp.ReceiveInfo"}],"name":"onReceive","type":"function"},{"parameters":[{"name":"info","$ref":"sockets.udp.ReceiveErrorInfo"}],"name":"onReceiveError","type":"function"}],"platforms":null,"deprecated":null})R";
constexpr char kSystemDisplay[] = R"R({"namespace":"system.display","types":[{"id":"system.display.Bounds","properties":{"left":{"name":"left","type":"integer"},"top":{"name":"top","type":"integer"},"width":{"name":"width","type":"integer"},"height":{"name":"height","type":"integer"}},"type":"object"},{"id":"system.display.Insets","properties":{"left":{"name":"left","type":"integer"},"top":{"name":"top","type":"integer"},"right":{"name":"right","type":"integer"},"bottom":{"name":"bottom","type":"integer"}},"type":"object"},{"id":"system.display.Point","properties":{"x":{"name":"x","type":"integer"},"y":{"name":"y","type":"integer"}},"type":"object"},{"id":"system.display.TouchCalibrationPair","properties":{"displayPoint":{"name":"displayPoint","$ref":"system.display.Point"},"touchPoint":{"name":"touchPoint","$ref":"system.display.Point"}},"type":"object"},{"id":"system.display.TouchCalibrationPairQuad","properties":{"pair1":{"name":"pair1","$ref":"system.display.TouchCalibrationPair"},"pair2":{"name":"pair2","$ref":"system.display.TouchCalibrationPair"},"pair3":{"name":"pair3","$ref":"system.display.TouchCalibrationPair"},"pair4":{"name":"pair4","$ref":"system.display.TouchCalibrationPair"}},"type":"object"},{"id":"system.display.DisplayMode","properties":{"width":{"name":"width","type":"integer"},"height":{"name":"height","type":"integer"},"widthInNativePixels":{"name":"widthInNativePixels","type":"integer"},"heightInNativePixels":{"name":"heightInNativePixels","type":"integer"},"uiScale":{"deprecated":"Use $(ref: displayZoomFactor)","optional":true,"name":"uiScale","type":"number"},"deviceScaleFactor":{"name":"deviceScaleFactor","type":"number"},"refreshRate":{"name":"refreshRate","type":"number"},"isNative":{"name":"isNative","type":"boolean"},"isSelected":{"name":"isSelected","type":"boolean"},"isInterlaced":{"optional":true,"name":"isInterlaced","type":"boolean"}},"type":"object"},{"id":"system.display.LayoutPosition","type":"string","enum":[{"name":"top"},{"name":"right"},{"name":"bottom"},{"name":"left"}]},{"id":"system.display.DisplayLayout","properties":{"id":{"name":"id","type":"string"},"parentId":{"name":"parentId","type":"string"},"position":{"name":"position","$ref":"system.display.LayoutPosition"},"offset":{"name":"offset","type":"integer"}},"type":"object"},{"id":"system.display.Edid","properties":{"manufacturerId":{"name":"manufacturerId","type":"string"},"productId":{"name":"productId","type":"string"},"yearOfManufacture":{"name":"yearOfManufacture","type":"integer"}},"type":"object"},{"id":"system.display.ActiveState","type":"string","enum":[{"name":"active"},{"name":"inactive"}]},{"id":"system.display.DisplayUnitInfo","properties":{"id":{"name":"id","type":"string"},"name":{"name":"name","type":"string"},"edid":{"optional":true,"name":"edid","$ref":"system.display.Edid"},"mirroringSourceId":{"name":"mirroringSourceId","type":"string"},"mirroringDestinationIds":{"name":"mirroringDestinationIds","type":"array","items":{"type":"string"}},"isPrimary":{"name":"isPrimary","type":"boolean"},"isInternal":{"name":"isInternal","type":"boolean"},"isEnabled":{"name":"isEnabled","type":"boolean"},"activeState":{"name":"activeState","$ref":"system.display.ActiveState"},"isUnified":{"name":"isUnified","type":"boolean"},"isAutoRotationAllowed":{"optional":true,"name":"isAutoRotationAllowed","type":"boolean"},"dpiX":{"name":"dpiX","type":"number"},"dpiY":{"name":"dpiY","type":"number"},"rotation":{"name":"rotation","type":"integer"},"bounds":{"name":"bounds","$ref":"system.display.Bounds"},"overscan":{"name":"overscan","$ref":"system.display.Insets"},"workArea":{"name":"workArea","$ref":"system.display.Bounds"},"modes":{"name":"modes","type":"array","items":{"$ref":"system.display.DisplayMode"}},"hasTouchSupport":{"name":"hasTouchSupport","type":"boolean"},"hasAccelerometerSupport":{"name":"hasAccelerometerSupport","type":"boolean"},"availableDisplayZoomFactors":{"name":"availableDisplayZoomFactors","type":"array","items":{"type":"number"}},"displayZoomFactor":{"name":"displayZoomFactor","type":"number"}},"type":"object"},{"id":"system.display.DisplayProperties","properties":{"isUnified":{"optional":true,"name":"isUnified","type":"boolean"},"mirroringSourceId":{"deprecated":"Use $(ref:setMirrorMode).","optional":true,"name":"mirroringSourceId","type":"string"},"isPrimary":{"optional":true,"name":"isPrimary","type":"boolean"},"overscan":{"optional":true,"name":"overscan","$ref":"system.display.Insets"},"rotation":{"optional":true,"name":"rotation","type":"integer"},"boundsOriginX":{"optional":true,"name":"boundsOriginX","type":"integer"},"boundsOriginY":{"optional":true,"name":"boundsOriginY","type":"integer"},"displayMode":{"optional":true,"name":"displayMode","$ref":"system.display.DisplayMode"},"displayZoomFactor":{"optional":true,"name":"displayZoomFactor","type":"number"}},"type":"object"},{"id":"system.display.GetInfoFlags","properties":{"singleUnified":{"optional":true,"name":"singleUnified","type":"boolean"}},"type":"object"},{"id":"system.display.MirrorMode","type":"string","enum":[{"name":"off"},{"name":"normal"},{"name":"mixed"}]},{"id":"system.display.MirrorModeInfo","properties":{"mode":{"name":"mode","$ref":"system.display.MirrorMode"},"mirroringSourceId":{"optional":true,"name":"mirroringSourceId","type":"string"},"mirroringDestinationIds":{"optional":true,"name":"mirroringDestinationIds","type":"array","items":{"type":"string"}}},"type":"object"}],"functions":[{"parameters":[{"name":"flags","optional":true,"$ref":"system.display.GetInfoFlags"}],"returns_async":{"name":"callback","parameters":[{"name":"displayInfo","type":"array","items":{"$ref":"system.display.DisplayUnitInfo"}}]},"name":"getInfo","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"layouts","type":"array","items":{"$ref":"system.display.DisplayLayout"}}]},"name":"getDisplayLayout","type":"function"},{"parameters":[{"name":"id","type":"string"},{"name":"info","$ref":"system.display.DisplayProperties"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"setDisplayProperties","type":"function"},{"parameters":[{"name":"layouts","type":"array","items":{"$ref":"system.display.DisplayLayout"}}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"setDisplayLayout","type":"function"},{"parameters":[{"name":"enabled","type":"boolean"}],"name":"enableUnifiedDesktop","type":"function"},{"parameters":[{"name":"id","type":"string"}],"name":"overscanCalibrationStart","type":"function"},{"parameters":[{"name":"id","type":"string"},{"name":"delta","$ref":"system.display.Insets"}],"name":"overscanCalibrationAdjust","type":"function"},{"parameters":[{"name":"id","type":"string"}],"name":"overscanCalibrationReset","type":"function"},{"parameters":[{"name":"id","type":"string"}],"name":"overscanCalibrationComplete","type":"function"},{"parameters":[{"name":"id","type":"string"}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"success","type":"boolean"}]},"name":"showNativeTouchCalibration","type":"function"},{"parameters":[{"name":"id","type":"string"}],"name":"startCustomTouchCalibration","type":"function"},{"parameters":[{"name":"pairs","$ref":"system.display.TouchCalibrationPairQuad"},{"name":"bounds","$ref":"system.display.Bounds"}],"name":"completeCustomTouchCalibration","type":"function"},{"parameters":[{"name":"id","type":"string"}],"name":"clearTouchCalibration","type":"function"},{"parameters":[{"name":"info","$ref":"system.display.MirrorModeInfo"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"setMirrorMode","type":"function"}],"properties":{},"events":[{"parameters":[],"name":"onDisplayChanged","type":"function"}],"platforms":null,"deprecated":null})R";
constexpr char kSystemNetwork[] = R"R({"namespace":"system.network","types":[{"id":"system.network.NetworkInterface","properties":{"name":{"name":"name","type":"string"},"address":{"name":"address","type":"string"},"prefixLength":{"name":"prefixLength","type":"integer"}},"type":"object"}],"functions":[{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"networkInterfaces","type":"array","items":{"$ref":"system.network.NetworkInterface"}}]},"name":"getNetworkInterfaces","type":"function"}],"properties":{},"events":[],"platforms":null,"deprecated":null})R";
constexpr char kSystemStorage[] = R"R({"namespace":"system.storage","types":[{"id":"system.storage.StorageUnitType","type":"string","enum":[{"name":"fixed"},{"name":"removable"},{"name":"unknown"}]},{"id":"system.storage.StorageUnitInfo","properties":{"id":{"name":"id","type":"string"},"name":{"name":"name","type":"string"},"type":{"name":"type","$ref":"system.storage.StorageUnitType"},"capacity":{"name":"capacity","type":"number"}},"type":"object"},{"id":"system.storage.StorageAvailableCapacityInfo","properties":{"id":{"name":"id","type":"string"},"availableCapacity":{"name":"availableCapacity","type":"number"}},"type":"object"},{"id":"system.storage.EjectDeviceResultCode","type":"string","enum":[{"name":"success"},{"name":"in_use"},{"name":"no_such_device"},{"name":"failure"}]}],"functions":[{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"info","type":"array","items":{"$ref":"system.storage.StorageUnitInfo"}}]},"name":"getInfo","type":"function"},{"parameters":[{"name":"id","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"result","$ref":"system.storage.EjectDeviceResultCode"}]},"name":"ejectDevice","type":"function"},{"parameters":[{"name":"id","type":"string"}],"returns_async":{"name":"callback","parameters":[{"name":"info","$ref":"system.storage.StorageAvailableCapacityInfo"}]},"name":"getAvailableCapacity","type":"function"}],"properties":{},"events":[{"parameters":[{"name":"info","$ref":"system.storage.StorageUnitInfo"}],"name":"onAttached","type":"function"},{"parameters":[{"name":"id","type":"string"}],"name":"onDetached","type":"function"}],"platforms":null,"deprecated":null})R";
constexpr char kScriptsInternal[] = R"R({"namespace":"scriptsInternal","types":[{"id":"scriptsInternal.Source","type":"string","enum":[{"name":"DYNAMIC_CONTENT_SCRIPT"},{"name":"DYNAMIC_USER_SCRIPT"},{"name":"MANIFEST_CONTENT_SCRIPT"}]},{"id":"scriptsInternal.ScriptSource","properties":{"code":{"optional":true,"name":"code","type":"string"},"file":{"optional":true,"name":"file","type":"string"}},"type":"object"},{"id":"scriptsInternal.SerializedUserScript","properties":{"allFrames":{"optional":true,"name":"allFrames","type":"boolean"},"css":{"optional":true,"name":"css","type":"array","items":{"$ref":"scriptsInternal.ScriptSource"}},"excludeMatches":{"optional":true,"name":"excludeMatches","type":"array","items":{"type":"string"}},"excludeGlobs":{"optional":true,"name":"excludeGlobs","type":"array","items":{"type":"string"}},"id":{"name":"id","type":"string"},"includeGlobs":{"optional":true,"name":"includeGlobs","type":"array","items":{"type":"string"}},"js":{"optional":true,"name":"js","type":"array","items":{"$ref":"scriptsInternal.ScriptSource"}},"matches":{"name":"matches","type":"array","items":{"type":"string"}},"matchOriginAsFallback":{"optional":true,"name":"matchOriginAsFallback","type":"boolean"},"runAt":{"optional":true,"name":"runAt","$ref":"extensionTypes.RunAt"},"source":{"name":"source","$ref":"scriptsInternal.Source"},"world":{"name":"world","$ref":"extensionTypes.ExecutionWorld"},"worldId":{"optional":true,"name":"worldId","type":"string"}},"type":"object"}],"functions":[],"properties":{},"events":[],"platforms":null,"deprecated":null})R";
constexpr char kTypes[] = R"R({"namespace":"types","types":[{"id":"types.ChromeSettingScope","type":"string","enum":["regular","regular_only","incognito_persistent","incognito_session_only"]},{"id":"types.LevelOfControl","type":"string","enum":["not_controllable","controlled_by_other_extensions","controllable_by_this_extension","controlled_by_this_extension"]},{"id":"types.ChromeSetting","type":"object","js_module":"ChromeSetting","customBindings":"types.ChromeSetting","functions":[{"name":"get","type":"function","parameters":[{"name":"details","type":"object","properties":{"incognito":{"type":"boolean","optional":true}}}],"returns_async":{"name":"callback","parameters":[{"name":"details","type":"object","properties":{"value":{"type":"any"},"levelOfControl":{"$ref":"types.LevelOfControl"},"incognitoSpecific":{"type":"boolean","optional":true}}}]}},{"name":"set","type":"function","parameters":[{"name":"details","type":"object","properties":{"value":{"type":"any"},"scope":{"$ref":"types.ChromeSettingScope","optional":true}}}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"clear","type":"function","parameters":[{"name":"details","type":"object","properties":{"scope":{"$ref":"types.ChromeSettingScope","optional":true}}}],"returns_async":{"name":"callback","optional":true,"parameters":[]}}],"events":[{"name":"onChange","parameters":[{"type":"object","name":"details","properties":{"value":{"type":"any"},"levelOfControl":{"$ref":"types.LevelOfControl"},"incognitoSpecific":{"type":"boolean","optional":true}}}]}]}]})R";
constexpr char kUserScripts[] = R"R({"namespace":"userScripts","types":[{"id":"userScripts.ExecutionWorld","type":"string","enum":[{"name":"MAIN"},{"name":"USER_SCRIPT"}]},{"id":"userScripts.ScriptSource","properties":{"code":{"optional":true,"name":"code","type":"string"},"file":{"optional":true,"name":"file","type":"string"}},"type":"object"},{"id":"userScripts.RegisteredUserScript","properties":{"allFrames":{"optional":true,"name":"allFrames","type":"boolean"},"excludeMatches":{"optional":true,"name":"excludeMatches","type":"array","items":{"type":"string"}},"id":{"name":"id","type":"string"},"includeGlobs":{"optional":true,"name":"includeGlobs","type":"array","items":{"type":"string"}},"excludeGlobs":{"optional":true,"name":"excludeGlobs","type":"array","items":{"type":"string"}},"js":{"optional":true,"name":"js","type":"array","items":{"$ref":"userScripts.ScriptSource"}},"matches":{"optional":true,"name":"matches","type":"array","items":{"type":"string"}},"runAt":{"optional":true,"name":"runAt","$ref":"extensionTypes.RunAt"},"world":{"optional":true,"name":"world","$ref":"userScripts.ExecutionWorld"},"worldId":{"optional":true,"name":"worldId","type":"string"}},"type":"object"},{"id":"userScripts.UserScriptFilter","properties":{"ids":{"optional":true,"name":"ids","type":"array","items":{"type":"string"}}},"type":"object"},{"id":"userScripts.InjectionTarget","properties":{"allFrames":{"optional":true,"name":"allFrames","type":"boolean"},"documentIds":{"optional":true,"name":"documentIds","type":"array","items":{"type":"string"}},"frameIds":{"optional":true,"name":"frameIds","type":"array","items":{"type":"integer"}},"tabId":{"name":"tabId","type":"integer"}},"type":"object"},{"id":"userScripts.InjectionResult","properties":{"documentId":{"name":"documentId","type":"string"},"frameId":{"name":"frameId","type":"integer"},"result":{"optional":true,"name":"result","type":"any"},"error":{"optional":true,"name":"error","type":"string"}},"type":"object"},{"id":"userScripts.UserScriptInjection","properties":{"injectImmediately":{"optional":true,"name":"injectImmediately","type":"boolean"},"js":{"name":"js","type":"array","items":{"$ref":"userScripts.ScriptSource"}},"target":{"name":"target","$ref":"userScripts.InjectionTarget"},"world":{"optional":true,"name":"world","$ref":"userScripts.ExecutionWorld"},"worldId":{"optional":true,"name":"worldId","type":"string"}},"type":"object"},{"id":"userScripts.WorldProperties","properties":{"worldId":{"optional":true,"name":"worldId","type":"string"},"csp":{"optional":true,"name":"csp","type":"string"},"messaging":{"optional":true,"name":"messaging","type":"boolean"}},"type":"object"}],"functions":[{"parameters":[{"name":"scripts","type":"array","items":{"$ref":"userScripts.RegisteredUserScript"}}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"register","type":"function"},{"parameters":[{"name":"filter","optional":true,"$ref":"userScripts.UserScriptFilter"}],"returns_async":{"name":"callback","parameters":[{"name":"scripts","type":"array","items":{"$ref":"userScripts.RegisteredUserScript"}}]},"name":"getScripts","type":"function"},{"parameters":[{"name":"filter","optional":true,"$ref":"userScripts.UserScriptFilter"}],"returns_async":{"name":"callback","parameters":[]},"name":"unregister","type":"function"},{"parameters":[{"name":"scripts","type":"array","items":{"$ref":"userScripts.RegisteredUserScript"}}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"update","type":"function"},{"parameters":[{"name":"injection","$ref":"userScripts.UserScriptInjection"}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"result","type":"array","items":{"$ref":"userScripts.InjectionResult"}}]},"name":"execute","type":"function"},{"parameters":[{"name":"properties","$ref":"userScripts.WorldProperties"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"configureWorld","type":"function"},{"parameters":[],"returns_async":{"name":"callback","parameters":[{"name":"worlds","type":"array","items":{"$ref":"userScripts.WorldProperties"}}]},"name":"getWorldConfigurations","type":"function"},{"parameters":[{"name":"worldId","optional":true,"type":"string"}],"returns_async":{"name":"callback","parameters":[]},"name":"resetWorldConfiguration","type":"function"}],"properties":{},"events":[],"platforms":null,"deprecated":null})R";
constexpr char kUsb[] = R"R({"namespace":"usb","types":[{"id":"usb.Direction","type":"string","enum":[{"name":"in"},{"name":"out"}]},{"id":"usb.Recipient","type":"string","enum":[{"name":"device"},{"name":"interface"},{"name":"endpoint"},{"name":"other"}]},{"id":"usb.RequestType","type":"string","enum":[{"name":"standard"},{"name":"class"},{"name":"vendor"},{"name":"reserved"}]},{"id":"usb.TransferType","type":"string","enum":[{"name":"control"},{"name":"interrupt"},{"name":"isochronous"},{"name":"bulk"}]},{"id":"usb.SynchronizationType","type":"string","enum":[{"name":"asynchronous"},{"name":"adaptive"},{"name":"synchronous"}]},{"id":"usb.UsageType","type":"string","enum":[{"name":"data"},{"name":"feedback"},{"name":"explicitFeedback"},{"name":"periodic"},{"name":"notification"}]},{"id":"usb.Device","properties":{"device":{"name":"device","type":"integer"},"vendorId":{"name":"vendorId","type":"integer"},"productId":{"name":"productId","type":"integer"},"version":{"name":"version","type":"integer"},"productName":{"name":"productName","type":"string"},"manufacturerName":{"name":"manufacturerName","type":"string"},"serialNumber":{"name":"serialNumber","type":"string"}},"type":"object"},{"id":"usb.ConnectionHandle","properties":{"handle":{"name":"handle","type":"integer"},"vendorId":{"name":"vendorId","type":"integer"},"productId":{"name":"productId","type":"integer"}},"type":"object"},{"id":"usb.EndpointDescriptor","properties":{"address":{"name":"address","type":"integer"},"type":{"name":"type","$ref":"usb.TransferType"},"direction":{"name":"direction","$ref":"usb.Direction"},"maximumPacketSize":{"name":"maximumPacketSize","type":"integer"},"synchronization":{"optional":true,"name":"synchronization","$ref":"usb.SynchronizationType"},"usage":{"optional":true,"name":"usage","$ref":"usb.UsageType"},"pollingInterval":{"optional":true,"name":"pollingInterval","type":"integer"},"extra_data":{"name":"extra_data","type":"binary","isInstanceOf":"ArrayBuffer"}},"type":"object"},{"id":"usb.InterfaceDescriptor","properties":{"interfaceNumber":{"name":"interfaceNumber","type":"integer"},"alternateSetting":{"name":"alternateSetting","type":"integer"},"interfaceClass":{"name":"interfaceClass","type":"integer"},"interfaceSubclass":{"name":"interfaceSubclass","type":"integer"},"interfaceProtocol":{"name":"interfaceProtocol","type":"integer"},"description":{"optional":true,"name":"description","type":"string"},"endpoints":{"name":"endpoints","type":"array","items":{"$ref":"usb.EndpointDescriptor"}},"extra_data":{"name":"extra_data","type":"binary","isInstanceOf":"ArrayBuffer"}},"type":"object"},{"id":"usb.ConfigDescriptor","properties":{"active":{"name":"active","type":"boolean"},"configurationValue":{"name":"configurationValue","type":"integer"},"description":{"optional":true,"name":"description","type":"string"},"selfPowered":{"name":"selfPowered","type":"boolean"},"remoteWakeup":{"name":"remoteWakeup","type":"boolean"},"maxPower":{"name":"maxPower","type":"integer"},"interfaces":{"name":"interfaces","type":"array","items":{"$ref":"usb.InterfaceDescriptor"}},"extra_data":{"name":"extra_data","type":"binary","isInstanceOf":"ArrayBuffer"}},"type":"object"},{"id":"usb.ControlTransferInfo","properties":{"direction":{"name":"direction","$ref":"usb.Direction"},"recipient":{"name":"recipient","$ref":"usb.Recipient"},"requestType":{"name":"requestType","$ref":"usb.RequestType"},"request":{"name":"request","type":"integer"},"value":{"name":"value","type":"integer"},"index":{"name":"index","type":"integer"},"length":{"optional":true,"name":"length","type":"integer"},"data":{"optional":true,"name":"data","type":"binary","isInstanceOf":"ArrayBuffer"},"timeout":{"optional":true,"name":"timeout","type":"integer"}},"type":"object"},{"id":"usb.GenericTransferInfo","properties":{"direction":{"name":"direction","$ref":"usb.Direction"},"endpoint":{"name":"endpoint","type":"integer"},"length":{"optional":true,"name":"length","type":"integer"},"data":{"optional":true,"name":"data","type":"binary","isInstanceOf":"ArrayBuffer"},"timeout":{"optional":true,"name":"timeout","type":"integer"}},"type":"object"},{"id":"usb.IsochronousTransferInfo","properties":{"transferInfo":{"name":"transferInfo","$ref":"usb.GenericTransferInfo"},"packets":{"name":"packets","type":"integer"},"packetLength":{"name":"packetLength","type":"integer"}},"type":"object"},{"id":"usb.TransferResultInfo","properties":{"resultCode":{"optional":true,"name":"resultCode","type":"integer"},"data":{"optional":true,"name":"data","type":"binary","isInstanceOf":"ArrayBuffer"}},"type":"object"},{"id":"usb.DeviceFilter","properties":{"vendorId":{"optional":true,"name":"vendorId","type":"integer"},"productId":{"optional":true,"name":"productId","type":"integer"},"interfaceClass":{"optional":true,"name":"interfaceClass","type":"integer"},"interfaceSubclass":{"optional":true,"name":"interfaceSubclass","type":"integer"},"interfaceProtocol":{"optional":true,"name":"interfaceProtocol","type":"integer"}},"type":"object"},{"id":"usb.EnumerateDevicesOptions","properties":{"vendorId":{"deprecated":"Equivalent to setting $(ref:DeviceFilter.vendorId).","optional":true,"name":"vendorId","type":"integer"},"productId":{"deprecated":"Equivalent to setting $(ref:DeviceFilter.productId).","optional":true,"name":"productId","type":"integer"},"filters":{"optional":true,"name":"filters","type":"array","items":{"$ref":"usb.DeviceFilter"}}},"type":"object"},{"id":"usb.EnumerateDevicesAndRequestAccessOptions","properties":{"vendorId":{"name":"vendorId","type":"integer"},"productId":{"name":"productId","type":"integer"},"interfaceId":{"optional":true,"name":"interfaceId","type":"integer"}},"type":"object"},{"id":"usb.DevicePromptOptions","properties":{"multiple":{"optional":true,"name":"multiple","type":"boolean"},"filters":{"optional":true,"name":"filters","type":"array","items":{"$ref":"usb.DeviceFilter"}}},"type":"object"}],"functions":[{"parameters":[{"name":"options","$ref":"usb.EnumerateDevicesOptions"}],"returns_async":{"name":"callback","parameters":[{"name":"devices","type":"array","items":{"$ref":"usb.Device"}}]},"name":"getDevices","type":"function"},{"parameters":[{"name":"options","$ref":"usb.DevicePromptOptions"}],"returns_async":{"name":"callback","parameters":[{"name":"devices","type":"array","items":{"$ref":"usb.Device"}}]},"name":"getUserSelectedDevices","type":"function"},{"parameters":[{"name":"device","$ref":"usb.Device"}],"returns_async":{"name":"callback","parameters":[{"name":"configs","type":"array","items":{"$ref":"usb.ConfigDescriptor"}}]},"name":"getConfigurations","type":"function"},{"deprecated":"This function was Chrome OS specific and calling it on other\n    platforms would fail. This operation is now implicitly performed as part of\n    $(ref:openDevice) and this function will return <code>true</code> on all\n    platforms.","parameters":[{"name":"device","$ref":"usb.Device"},{"name":"interfaceId","type":"integer"}],"returns_async":{"name":"callback","parameters":[{"name":"success","type":"boolean"}]},"name":"requestAccess","type":"function"},{"parameters":[{"name":"device","$ref":"usb.Device"}],"returns_async":{"name":"callback","parameters":[{"name":"handle","$ref":"usb.ConnectionHandle"}]},"name":"openDevice","type":"function"},{"parameters":[{"name":"options","$ref":"usb.EnumerateDevicesAndRequestAccessOptions"}],"returns_async":{"name":"callback","parameters":[{"name":"handles","type":"array","items":{"$ref":"usb.ConnectionHandle"}}]},"name":"findDevices","type":"function"},{"parameters":[{"name":"handle","$ref":"usb.ConnectionHandle"}],"returns_async":{"name":"callback","optional":true,"parameters":[]},"name":"closeDevice","type":"function"},{"parameters":[{"name":"handle","$ref":"usb.ConnectionHandle"},{"name":"configurationValue","type":"integer"}],"returns_async":{"name":"callback","parameters":[]},"name":"setConfiguration","type":"function"},{"parameters":[{"name":"handle","$ref":"usb.ConnectionHandle"}],"returns_async":{"name":"callback","parameters":[{"name":"config","$ref":"usb.ConfigDescriptor"}]},"name":"getConfiguration","type":"function"},{"parameters":[{"name":"handle","$ref":"usb.ConnectionHandle"}],"returns_async":{)R" R"R("name":"callback","parameters":[{"name":"descriptors","type":"array","items":{"$ref":"usb.InterfaceDescriptor"}}]},"name":"listInterfaces","type":"function"},{"parameters":[{"name":"handle","$ref":"usb.ConnectionHandle"},{"name":"interfaceNumber","type":"integer"}],"returns_async":{"name":"callback","parameters":[]},"name":"claimInterface","type":"function"},{"parameters":[{"name":"handle","$ref":"usb.ConnectionHandle"},{"name":"interfaceNumber","type":"integer"}],"returns_async":{"name":"callback","parameters":[]},"name":"releaseInterface","type":"function"},{"parameters":[{"name":"handle","$ref":"usb.ConnectionHandle"},{"name":"interfaceNumber","type":"integer"},{"name":"alternateSetting","type":"integer"}],"returns_async":{"name":"callback","parameters":[]},"name":"setInterfaceAlternateSetting","type":"function"},{"parameters":[{"name":"handle","$ref":"usb.ConnectionHandle"},{"name":"transferInfo","$ref":"usb.ControlTransferInfo"}],"returns_async":{"name":"callback","parameters":[{"name":"info","$ref":"usb.TransferResultInfo"}]},"name":"controlTransfer","type":"function"},{"parameters":[{"name":"handle","$ref":"usb.ConnectionHandle"},{"name":"transferInfo","$ref":"usb.GenericTransferInfo"}],"returns_async":{"name":"callback","parameters":[{"name":"info","$ref":"usb.TransferResultInfo"}]},"name":"bulkTransfer","type":"function"},{"parameters":[{"name":"handle","$ref":"usb.ConnectionHandle"},{"name":"transferInfo","$ref":"usb.GenericTransferInfo"}],"returns_async":{"name":"callback","parameters":[{"name":"info","$ref":"usb.TransferResultInfo"}]},"name":"interruptTransfer","type":"function"},{"parameters":[{"name":"handle","$ref":"usb.ConnectionHandle"},{"name":"transferInfo","$ref":"usb.IsochronousTransferInfo"}],"returns_async":{"name":"callback","parameters":[{"name":"info","$ref":"usb.TransferResultInfo"}]},"name":"isochronousTransfer","type":"function"},{"parameters":[{"name":"handle","$ref":"usb.ConnectionHandle"}],"returns_async":{"name":"callback","parameters":[{"name":"success","type":"boolean"}]},"name":"resetDevice","type":"function"}],"properties":{},"events":[{"parameters":[{"name":"device","$ref":"usb.Device"}],"name":"onDeviceAdded","type":"function"},{"parameters":[{"name":"device","$ref":"usb.Device"}],"name":"onDeviceRemoved","type":"function"}],"platforms":null,"deprecated":null})R";
constexpr char kVirtualKeyboard[] = R"R({"namespace":"virtualKeyboard","types":[{"id":"virtualKeyboard.FeatureRestrictions","properties":{"autoCompleteEnabled":{"optional":true,"name":"autoCompleteEnabled","type":"boolean"},"autoCorrectEnabled":{"optional":true,"name":"autoCorrectEnabled","type":"boolean"},"handwritingEnabled":{"optional":true,"name":"handwritingEnabled","type":"boolean"},"spellCheckEnabled":{"optional":true,"name":"spellCheckEnabled","type":"boolean"},"voiceInputEnabled":{"optional":true,"name":"voiceInputEnabled","type":"boolean"}},"type":"object"}],"functions":[{"parameters":[{"name":"restrictions","$ref":"virtualKeyboard.FeatureRestrictions"}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"update","$ref":"virtualKeyboard.FeatureRestrictions"}]},"name":"restrictFeatures","type":"function"}],"properties":{},"events":[],"platforms":["chromeos"],"deprecated":null})R";
constexpr char kVirtualKeyboardPrivate[] = R"R({"namespace":"virtualKeyboardPrivate","platforms":["chromeos"],"types":[{"id":"virtualKeyboardPrivate.VirtualKeyboardEventType","type":"string","enum":["keyup","keydown"]},{"id":"virtualKeyboardPrivate.VirtualKeyboardEvent","type":"object","properties":{"type":{"$ref":"virtualKeyboardPrivate.VirtualKeyboardEventType"},"charValue":{"type":"integer"},"keyCode":{"type":"integer"},"keyName":{"type":"string"},"modifiers":{"type":"integer","optional":true}}},{"id":"virtualKeyboardPrivate.KeyboardMode","type":"string","enum":["FULL_WIDTH","FLOATING"]},{"id":"virtualKeyboardPrivate.KeyboardState","type":"string","enum":["ENABLED","DISABLED","AUTO"]},{"id":"virtualKeyboardPrivate.Bounds","type":"object","properties":{"left":{"type":"integer"},"top":{"type":"integer"},"width":{"type":"integer"},"height":{"type":"integer"}}},{"id":"virtualKeyboardPrivate.KeyboardConfig","type":"object","properties":{"layout":{"type":"string","minLength":1},"hotrodmode":{"type":"boolean"},"a11ymode":{"type":"boolean"},"features":{"type":"array","items":{"type":"string"}}}},{"id":"virtualKeyboardPrivate.ContainerBehaviorOptions","type":"object","properties":{"mode":{"$ref":"virtualKeyboardPrivate.KeyboardMode","name":"mode"},"bounds":{"$ref":"virtualKeyboardPrivate.Bounds"}}},{"id":"virtualKeyboardPrivate.DisplayFormat","type":"string","enum":["text","png","html","file"]},{"id":"virtualKeyboardPrivate.ClipboardItem","type":"object","properties":{"id":{"type":"string"},"imageData":{"type":"string","optional":true},"textData":{"type":"string","optional":true},"displayFormat":{"$ref":"virtualKeyboardPrivate.DisplayFormat","name":"displayFormat"},"timeCopied":{"type":"number"}}}],"functions":[{"name":"insertText","type":"function","parameters":[{"name":"text","type":"string"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"sendKeyEvent","type":"function","parameters":[{"name":"keyEvent","$ref":"virtualKeyboardPrivate.VirtualKeyboardEvent"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"hideKeyboard","type":"function","parameters":[],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"setHotrodKeyboard","type":"function","parameters":[{"type":"boolean","name":"enable"}]},{"name":"lockKeyboard","type":"function","parameters":[{"type":"boolean","name":"lock"}]},{"name":"keyboardLoaded","type":"function","parameters":[],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"getKeyboardConfig","type":"function","parameters":[],"returns_async":{"name":"callback","parameters":[{"$ref":"virtualKeyboardPrivate.KeyboardConfig","name":"config"}]}},{"name":"openSettings","type":"function","parameters":[]},{"name":"openSuggestionSettings","type":"function","parameters":[]},{"name":"setContainerBehavior","type":"function","parameters":[{"$ref":"virtualKeyboardPrivate.ContainerBehaviorOptions","name":"options"}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"success","type":"boolean"}]}},{"name":"setDraggableArea","type":"function","parameters":[{"$ref":"virtualKeyboardPrivate.Bounds","name":"bounds"}]},{"name":"setKeyboardState","type":"function","parameters":[{"$ref":"virtualKeyboardPrivate.KeyboardState","name":"state"}]},{"name":"setOccludedBounds","type":"function","parameters":[{"name":"boundsList","type":"array","items":{"$ref":"virtualKeyboardPrivate.Bounds"}}]},{"name":"setHitTestBounds","type":"function","parameters":[{"name":"boundsList","type":"array","items":{"$ref":"virtualKeyboardPrivate.Bounds"}}]},{"name":"setAreaToRemainOnScreen","type":"function","parameters":[{"name":"bounds","$ref":"virtualKeyboardPrivate.Bounds"}]},{"name":"setWindowBoundsInScreen","type":"function","parameters":[{"name":"bounds","$ref":"virtualKeyboardPrivate.Bounds"}]},{"name":"getClipboardHistory","type":"function","parameters":[{"name":"options","type":"object","properties":{"itemIds":{"type":"array","items":{"type":"string"},"optional":true}}}],"returns_async":{"name":"callback","parameters":[{"name":"clipboardHistory","type":"array","items":{"$ref":"virtualKeyboardPrivate.ClipboardItem"}}]}},{"name":"pasteClipboardItem","type":"function","parameters":[{"name":"itemId","type":"string","parameters":[],"returns_async":{"name":"callback","optional":true,"parameters":[]}}]},{"name":"deleteClipboardItem","type":"function","parameters":[{"name":"itemId","type":"string","parameters":[],"returns_async":{"name":"callback","optional":true,"parameters":[]}}]}],"events":[{"name":"onBoundsChanged","type":"function","parameters":[{"name":"bounds","$ref":"virtualKeyboardPrivate.Bounds"}]},{"name":"onKeyboardClosed","type":"function"},{"name":"onKeyboardConfigChanged","type":"function","parameters":[{"name":"config","$ref":"virtualKeyboardPrivate.KeyboardConfig"}]},{"name":"onClipboardHistoryChanged","type":"function","parameters":[{"name":"itemIds","type":"array","items":{"type":"string"}}]},{"name":"onClipboardItemUpdated","type":"function","parameters":[{"name":"clipboardHistoryItem","$ref":"virtualKeyboardPrivate.ClipboardItem"}]},{"name":"onColorProviderChanged","type":"function"}]})R";
constexpr char kWebViewInternal[] = R"R({"namespace":"webViewInternal","properties":{"MAX_CAPTURE_VISIBLE_REGION_CALLS_PER_SECOND":{"value":2,"type":"integer"}},"types":[{"id":"webViewInternal.DataTypeSet","type":"object","properties":{"appcache":{"type":"boolean","optional":true},"cookies":{"type":"boolean","optional":true},"sessionCookies":{"type":"boolean","optional":true},"persistentCookies":{"type":"boolean","optional":true},"fileSystems":{"type":"boolean","optional":true},"indexedDB":{"type":"boolean","optional":true},"localStorage":{"type":"boolean","optional":true},"webSQL":{"type":"boolean","optional":true},"cache":{"type":"boolean","optional":true}}},{"id":"webViewInternal.RemovalOptions","type":"object","properties":{"since":{"type":"number","optional":true}}},{"id":"webViewInternal.ZoomMode","type":"string","enum":[{"name":"per-origin"},{"name":"per-view"},{"name":"disabled"}]},{"id":"webViewInternal.StopFindingAction","type":"string","enum":["clear","keep","activate"]},{"id":"webViewInternal.SetPermissionAction","type":"string","enum":["allow","deny","default"]},{"id":"webViewInternal.InjectionItems","type":"object","properties":{"code":{"type":"string","optional":true},"files":{"type":"array","items":{"type":"string"},"optional":true}}},{"id":"webViewInternal.ContentScriptDetails","type":"object","properties":{"name":{"type":"string"},"matches":{"type":"array","items":{"type":"string"}},"exclude_matches":{"type":"array","items":{"type":"string"},"optional":true},"match_about_blank":{"type":"boolean","optional":true},"css":{"$ref":"webViewInternal.InjectionItems","optional":true},"js":{"$ref":"webViewInternal.InjectionItems","optional":true},"run_at":{"$ref":"extensionTypes.RunAt","optional":true},"all_frames":{"type":"boolean","optional":true},"include_globs":{"type":"array","items":{"type":"string"},"optional":true},"exclude_globs":{"type":"array","items":{"type":"string"},"optional":true}},"required":["name","matches"]}],"functions":[{"name":"getAudioState","type":"function","parameters":[{"type":"integer","name":"instanceId"}],"returns_async":{"name":"callback","parameters":[{"name":"audible","type":"boolean"}]}},{"name":"setAudioMuted","type":"function","parameters":[{"type":"integer","name":"instanceId"},{"type":"boolean","name":"mute"}]},{"name":"isAudioMuted","type":"function","parameters":[{"type":"integer","name":"instanceId"}],"returns_async":{"name":"callback","parameters":[{"name":"muted","type":"boolean"}]}},{"name":"executeScript","type":"function","parameters":[{"type":"integer","name":"instanceId"},{"type":"string","name":"src"},{"$ref":"extensionTypes.InjectDetails","name":"details"}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"result","optional":true,"type":"array","items":{"type":"any","minimum":0}}]}},{"name":"insertCSS","type":"function","parameters":[{"type":"integer","name":"instanceId"},{"type":"string","name":"src"},{"$ref":"extensionTypes.InjectDetails","name":"details"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"addContentScripts","type":"function","parameters":[{"type":"integer","name":"instanceId"},{"type":"array","name":"contentScriptList","items":{"$ref":"webViewInternal.ContentScriptDetails","name":"contentScriptDetails"},"minItems":1}],"returns_async":{"name":"callback","parameters":[]}},{"name":"removeContentScripts","type":"function","parameters":[{"type":"integer","name":"instanceId"},{"type":"array","name":"scriptNameList","items":{"type":"string"},"optional":true}],"returns_async":{"name":"callback","parameters":[]}},{"name":"setZoom","type":"function","parameters":[{"type":"integer","name":"instanceId"},{"type":"number","name":"zoomFactor"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"getZoom","type":"function","parameters":[{"type":"integer","name":"instanceId"}],"returns_async":{"name":"callback","parameters":[{"type":"number","name":"zoomFactor"}]}},{"name":"setZoomMode","type":"function","parameters":[{"type":"integer","name":"instanceId"},{"$ref":"webViewInternal.ZoomMode","name":"ZoomMode"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}},{"name":"getZoomMode","type":"function","parameters":[{"type":"integer","name":"instanceId"}],"returns_async":{"name":"callback","parameters":[{"$ref":"webViewInternal.ZoomMode","name":"ZoomMode"}]}},{"name":"find","type":"function","parameters":[{"type":"integer","name":"instanceId"},{"type":"string","name":"searchText"},{"type":"object","name":"options","optional":true,"properties":{"backward":{"type":"boolean","optional":true},"matchCase":{"type":"boolean","optional":true}}}],"returns_async":{"name":"callback","optional":true,"parameters":[{"type":"object","name":"results","optional":true,"properties":{"numberOfMatches":{"type":"integer"},"activeMatchOrdinal":{"type":"integer"},"selectionRect":{"type":"object","properties":{"left":{"type":"integer"},"top":{"type":"integer"},"width":{"type":"integer"},"height":{"type":"integer"}}},"canceled":{"type":"boolean"}}}]}},{"name":"stopFinding","type":"function","parameters":[{"type":"integer","name":"instanceId"},{"$ref":"webViewInternal.StopFindingAction","name":"action","optional":true}]},{"name":"loadDataWithBaseUrl","type":"function","parameters":[{"type":"integer","name":"instanceId"},{"type":"string","name":"dataUrl"},{"type":"string","name":"baseUrl"},{"type":"string","name":"virtualUrl","optional":true}],"returns_async":{"name":"callback","parameters":[]}},{"name":"go","type":"function","parameters":[{"type":"integer","name":"instanceId"},{"type":"integer","name":"relativeIndex"}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"success","type":"boolean"}]}},{"name":"overrideUserAgent","type":"function","parameters":[{"type":"integer","name":"instanceId"},{"type":"string","name":"userAgentOverride"}]},{"name":"reload","type":"function","parameters":[{"type":"integer","name":"instanceId"}]},{"name":"setAllowTransparency","type":"function","parameters":[{"type":"integer","name":"instanceId"},{"type":"boolean","name":"allow"}]},{"name":"setAllowScaling","type":"function","parameters":[{"type":"integer","name":"instanceId"},{"type":"boolean","name":"allow"}]},{"name":"setName","type":"function","parameters":[{"type":"integer","name":"instanceId"},{"type":"string","name":"frameName"}]},{"name":"setPermission","type":"function","parameters":[{"type":"integer","name":"instanceId"},{"type":"integer","name":"requestId"},{"$ref":"webViewInternal.SetPermissionAction","name":"action"},{"type":"string","name":"userInput","optional":true}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"allowed","type":"boolean"}]}},{"name":"navigate","type":"function","parameters":[{"type":"integer","name":"instanceId"},{"type":"string","name":"src"}]},{"name":"stop","type":"function","parameters":[{"type":"integer","name":"instanceId"}]},{"name":"terminate","type":"function","parameters":[{"type":"integer","name":"instanceId"}]},{"name":"captureVisibleRegion","type":"function","parameters":[{"type":"integer","name":"instanceId"},{"$ref":"extensionTypes.ImageDetails","name":"options","optional":true}],"returns_async":{"name":"callback","parameters":[{"type":"string","name":"dataUrl"}]}},{"name":"setSpatialNavigationEnabled","type":"function","parameters":[{"type":"integer","name":"instanceId"},{"type":"boolean","name":"spatialNavEnabled"}]},{"name":"isSpatialNavigationEnabled","type":"function","parameters":[{"type":"integer","name":"instanceId"}],"returns_async":{"name":"callback","parameters":[{"name":"spatialNavEnabled","type":"boolean"}]}},{"name":"clearData","type":"function","parameters":[{"type":"integer","name":"instanceId"},{"$ref":"webViewInternal.RemovalOptions","name":"options"},{"name":"dataToRemove","$ref":"webViewInternal.DataTypeSet"}],"returns_async":{"name":"callback","optional":true,"parameters":[]}}]})R";
constexpr char kWebRequestInternal[] = R"R({"namespace":"webRequestInternal","types":[{"id":"webRequestInternal.AddEventListenerOptions","type":"string","enum":["requestHeaders","responseHeaders","blocking","asyncBlocking","requestBody","extraHeaders"]}],"functions":[{"name":"addEventListener","type":"function","parameters":[{"type":"function","name":"callback"},{"$ref":"webRequest.RequestFilter","name":"filter"},{"type":"array","optional":true,"name":"extraInfoSpec","items":{"$ref":"webRequestInternal.AddEventListenerOptions"}},{"type":"string","name":"eventName"},{"type":"string","name":"subEventName"},{"type":"integer","name":"webViewInstanceId"}]},{"name":"eventHandled","type":"function","parameters":[{"type":"string","name":"eventName"},{"type":"string","name":"subEventName"},{"type":"string","name":"requestId"},{"type":"integer","name":"webViewInstanceId"},{"$ref":"webRequest.BlockingResponse","optional":true,"name":"response"}]}]})R";
constexpr char kDeclarativeWebRequest[] = R"R({"namespace":"declarativeWebRequest","types":[{"id":"declarativeWebRequest.RequestMatcherInstanceType","type":"string","enum":["declarativeWebRequest.RequestMatcher"]},{"id":"declarativeWebRequest.CancelRequestInstanceType","type":"string","enum":["declarativeWebRequest.CancelRequest"]},{"id":"declarativeWebRequest.RedirectRequestInstanceType","type":"string","enum":["declarativeWebRequest.RedirectRequest"]},{"id":"declarativeWebRequest.RedirectToTransparentImageInstanceType","type":"string","enum":["declarativeWebRequest.RedirectToTransparentImage"]},{"id":"declarativeWebRequest.RedirectToEmptyDocumentInstanceType","type":"string","enum":["declarativeWebRequest.RedirectToEmptyDocument"]},{"id":"declarativeWebRequest.RedirectByRegExInstanceType","type":"string","enum":["declarativeWebRequest.RedirectByRegEx"]},{"id":"declarativeWebRequest.SetRequestHeaderInstanceType","type":"string","enum":["declarativeWebRequest.SetRequestHeader"]},{"id":"declarativeWebRequest.RemoveRequestHeaderInstanceType","type":"string","enum":["declarativeWebRequest.RemoveRequestHeader"]},{"id":"declarativeWebRequest.AddResponseHeaderInstanceType","type":"string","enum":["declarativeWebRequest.AddResponseHeader"]},{"id":"declarativeWebRequest.RemoveResponseHeaderInstanceType","type":"string","enum":["declarativeWebRequest.RemoveResponseHeader"]},{"id":"declarativeWebRequest.IgnoreRulesInstanceType","type":"string","enum":["declarativeWebRequest.IgnoreRules"]},{"id":"declarativeWebRequest.SendMessageToExtensionInstanceType","type":"string","enum":["declarativeWebRequest.SendMessageToExtension"]},{"id":"declarativeWebRequest.AddRequestCookieInstanceType","type":"string","enum":["declarativeWebRequest.AddRequestCookie"]},{"id":"declarativeWebRequest.AddResponseCookieInstanceType","type":"string","enum":["declarativeWebRequest.AddResponseCookie"]},{"id":"declarativeWebRequest.EditRequestCookieInstanceType","type":"string","enum":["declarativeWebRequest.EditRequestCookie"]},{"id":"declarativeWebRequest.EditResponseCookieInstanceType","type":"string","enum":["declarativeWebRequest.EditResponseCookie"]},{"id":"declarativeWebRequest.RemoveRequestCookieInstanceType","type":"string","enum":["declarativeWebRequest.RemoveRequestCookie"]},{"id":"declarativeWebRequest.RemoveResponseCookieInstanceType","type":"string","enum":["declarativeWebRequest.RemoveResponseCookie"]},{"id":"declarativeWebRequest.Stage","type":"string","enum":["onBeforeRequest","onBeforeSendHeaders","onHeadersReceived","onAuthRequired"]},{"id":"declarativeWebRequest.HeaderFilter","type":"object","properties":{"namePrefix":{"type":"string","optional":true},"nameSuffix":{"type":"string","optional":true},"nameContains":{"choices":[{"type":"array","items":{"type":"string"}},{"type":"string"}],"optional":true},"nameEquals":{"type":"string","optional":true},"valuePrefix":{"type":"string","optional":true},"valueSuffix":{"type":"string","optional":true},"valueContains":{"choices":[{"type":"array","items":{"type":"string"}},{"type":"string"}],"optional":true},"valueEquals":{"type":"string","optional":true}}},{"id":"declarativeWebRequest.RequestMatcher","type":"object","properties":{"url":{"$ref":"events.UrlFilter","optional":true},"firstPartyForCookiesUrl":{"$ref":"events.UrlFilter","deprecated":"Ignored since release 82.","optional":true},"resourceType":{"type":"array","optional":true,"items":{"$ref":"webRequest.ResourceType"}},"contentType":{"type":"array","optional":true,"items":{"type":"string"}},"excludeContentType":{"type":"array","optional":true,"items":{"type":"string"}},"requestHeaders":{"type":"array","optional":true,"items":{"$ref":"declarativeWebRequest.HeaderFilter"}},"excludeRequestHeaders":{"type":"array","optional":true,"items":{"$ref":"declarativeWebRequest.HeaderFilter"}},"responseHeaders":{"type":"array","optional":true,"items":{"$ref":"declarativeWebRequest.HeaderFilter"}},"excludeResponseHeaders":{"type":"array","optional":true,"items":{"$ref":"declarativeWebRequest.HeaderFilter"}},"thirdPartyForCookies":{"type":"boolean","optional":true,"deprecated":"Ignored since release 87."},"stages":{"type":"array","items":{"$ref":"declarativeWebRequest.Stage"},"optional":true},"instanceType":{"$ref":"declarativeWebRequest.RequestMatcherInstanceType"}}},{"id":"declarativeWebRequest.CancelRequest","type":"object","properties":{"instanceType":{"$ref":"declarativeWebRequest.CancelRequestInstanceType"}}},{"id":"declarativeWebRequest.RedirectRequest","type":"object","properties":{"instanceType":{"$ref":"declarativeWebRequest.RedirectRequestInstanceType"},"redirectUrl":{"type":"string"}}},{"id":"declarativeWebRequest.RedirectToTransparentImage","type":"object","properties":{"instanceType":{"$ref":"declarativeWebRequest.RedirectToTransparentImageInstanceType"}}},{"id":"declarativeWebRequest.RedirectToEmptyDocument","type":"object","properties":{"instanceType":{"$ref":"declarativeWebRequest.RedirectToEmptyDocumentInstanceType"}}},{"id":"declarativeWebRequest.RedirectByRegEx","type":"object","properties":{"instanceType":{"$ref":"declarativeWebRequest.RedirectByRegExInstanceType"},"from":{"type":"string"},"to":{"type":"string"}}},{"id":"declarativeWebRequest.SetRequestHeader","type":"object","properties":{"instanceType":{"$ref":"declarativeWebRequest.SetRequestHeaderInstanceType"},"name":{"type":"string"},"value":{"type":"string"}}},{"id":"declarativeWebRequest.RemoveRequestHeader","type":"object","properties":{"instanceType":{"$ref":"declarativeWebRequest.RemoveRequestHeaderInstanceType"},"name":{"type":"string"}}},{"id":"declarativeWebRequest.AddResponseHeader","type":"object","properties":{"instanceType":{"$ref":"declarativeWebRequest.AddResponseHeaderInstanceType"},"name":{"type":"string"},"value":{"type":"string"}}},{"id":"declarativeWebRequest.RemoveResponseHeader","type":"object","properties":{"instanceType":{"$ref":"declarativeWebRequest.RemoveResponseHeaderInstanceType"},"name":{"type":"string"},"value":{"type":"string","optional":true}}},{"id":"declarativeWebRequest.IgnoreRules","type":"object","properties":{"instanceType":{"$ref":"declarativeWebRequest.IgnoreRulesInstanceType"},"lowerPriorityThan":{"type":"integer","optional":true},"hasTag":{"type":"string","optional":true}}},{"id":"declarativeWebRequest.SendMessageToExtension","type":"object","properties":{"instanceType":{"$ref":"declarativeWebRequest.SendMessageToExtensionInstanceType"},"message":{"type":"string"}}},{"id":"declarativeWebRequest.RequestCookie","type":"object","properties":{"name":{"type":"string","optional":true},"value":{"type":"string","optional":true}}},{"id":"declarativeWebRequest.ResponseCookie","type":"object","properties":{"name":{"type":"string","optional":true},"value":{"type":"string","optional":true},"expires":{"type":"string","optional":true},"maxAge":{"type":"number","optional":true},"domain":{"type":"string","optional":true},"path":{"type":"string","optional":true},"secure":{"type":"string","optional":true},"httpOnly":{"type":"string","optional":true}}},{"id":"declarativeWebRequest.FilterResponseCookie","type":"object","properties":{"name":{"type":"string","optional":true},"value":{"type":"string","optional":true},"expires":{"type":"string","optional":true},"maxAge":{"type":"number","optional":true},"domain":{"type":"string","optional":true},"path":{"type":"string","optional":true},"secure":{"type":"string","optional":true},"httpOnly":{"type":"string","optional":true},"ageUpperBound":{"type":"integer","minimum":0,"optional":true},"ageLowerBound":{"type":"integer","minimum":0,"optional":true},"sessionCookie":{"type":"boolean","optional":true}}},{"id":"declarativeWebRequest.AddRequestCookie","type":"object","properties":{"instanceType":{"$ref":"declarativeWebRequest.AddRequestCookieInstanceType"},"cookie":{"$ref":"declarativeWebRequest.RequestCookie"}}},{"id":"declarativeWebRequest.AddResponseCookie","type":"object","properties":{"instanceType":{"$ref":"declarativeWebRequest.AddResponseCookieInstanceType"},"cookie":{"$ref":"declarativeWebRequest.ResponseCookie"}}},{"id":"declarativeWebRequest.EditRequestCookie","type":"object","properties":{"instanceType":{"$ref":"declarativeWebRequest.EditRequestCookieInstanceType"},"filter")R" R"R(:{"$ref":"declarativeWebRequest.RequestCookie"},"modification":{"$ref":"declarativeWebRequest.RequestCookie"}}},{"id":"declarativeWebRequest.EditResponseCookie","type":"object","properties":{"instanceType":{"$ref":"declarativeWebRequest.EditResponseCookieInstanceType"},"filter":{"$ref":"declarativeWebRequest.FilterResponseCookie"},"modification":{"$ref":"declarativeWebRequest.ResponseCookie"}}},{"id":"declarativeWebRequest.RemoveRequestCookie","type":"object","properties":{"instanceType":{"$ref":"declarativeWebRequest.RemoveRequestCookieInstanceType"},"filter":{"$ref":"declarativeWebRequest.RequestCookie"}}},{"id":"declarativeWebRequest.RemoveResponseCookie","type":"object","properties":{"instanceType":{"$ref":"declarativeWebRequest.RemoveResponseCookieInstanceType"},"filter":{"$ref":"declarativeWebRequest.FilterResponseCookie"}}}],"functions":[],"events":[{"name":"onRequest","options":{"supportsListeners":false,"supportsRules":true,"conditions":["declarativeWebRequest.RequestMatcher"],"actions":["declarativeWebRequest.AddRequestCookie","declarativeWebRequest.AddResponseCookie","declarativeWebRequest.AddResponseHeader","declarativeWebRequest.CancelRequest","declarativeWebRequest.EditRequestCookie","declarativeWebRequest.EditResponseCookie","declarativeWebRequest.RedirectRequest","declarativeWebRequest.RedirectToTransparentImage","declarativeWebRequest.RedirectToEmptyDocument","declarativeWebRequest.RedirectByRegEx","declarativeWebRequest.RemoveRequestCookie","declarativeWebRequest.RemoveResponseCookie","declarativeWebRequest.RemoveRequestHeader","declarativeWebRequest.RemoveResponseHeader","declarativeWebRequest.SetRequestHeader","declarativeWebRequest.SendMessageToExtension","declarativeWebRequest.IgnoreRules"]}},{"name":"onMessage","type":"function","parameters":[{"type":"object","name":"details","properties":{"message":{"type":"string"},"stage":{"$ref":"declarativeWebRequest.Stage"},"requestId":{"type":"string"},"url":{"type":"string"},"method":{"type":"string"},"frameId":{"type":"integer"},"parentFrameId":{"type":"integer"},"documentId":{"type":"string","optional":true},"parentDocumentId":{"type":"string","optional":true},"documentLifecycle":{"$ref":"extensionTypes.DocumentLifecycle"},"frameType":{"$ref":"extensionTypes.FrameType"},"tabId":{"type":"integer"},"type":{"$ref":"webRequest.ResourceType"},"timeStamp":{"type":"number"}}}]}]})R";
constexpr char kWebViewRequest[] = R"R({"namespace":"webViewRequest"})R";
}  // namespace

namespace extensions {
namespace api {

// static
bool GeneratedSchemas::IsGenerated(std::string_view name) {
  return !Get(name).empty();
}

// static
std::string_view GeneratedSchemas::Get(std::string_view name) {
  static constexpr auto kSchemas = base::MakeFixedFlatMap<std::string_view, std::string_view>({
    {"alarms", kAlarms},
    {"app.currentWindowInternal", kAppCurrentWindowInternal},
    {"app.runtime", kAppRuntime},
    {"app.window", kAppWindow},
    {"appViewGuestInternal", kAppViewGuestInternal},
    {"audio", kAudio},
    {"automation", kAutomation},
    {"automationInternal", kAutomationInternal},
    {"cecPrivate", kCecPrivate},
    {"clipboard", kClipboard},
    {"declarativeNetRequest", kDeclarativeNetRequest},
    {"declarativeWebRequest", kDeclarativeWebRequest},
    {"dns", kDns},
    {"events", kEvents},
    {"extensionOptionsInternal", kExtensionOptionsInternal},
    {"extensionTypes", kExtensionTypes},
    {"fileHandlers", kFileHandlers},
    {"fileSystem", kFileSystem},
    {"guestViewInternal", kGuestViewInternal},
    {"hid", kHid},
    {"i18n", kI18n},
    {"iconVariants", kIconVariants},
    {"idle", kIdle},
    {"management", kManagement},
    {"metricsPrivate", kMetricsPrivate},
    {"mimeHandlerPrivate", kMimeHandlerPrivate},
    {"mimeHandlerViewGuestInternal", kMimeHandlerViewGuestInternal},
    {"mojoPrivate", kMojoPrivate},
    {"networkingPrivate", kNetworkingPrivate},
    {"offscreen", kOffscreen},
    {"power", kPower},
    {"printerProvider", kPrinterProvider},
    {"printerProviderInternal", kPrinterProviderInternal},
    {"runtime", kRuntime},
    {"scriptsInternal", kScriptsInternal},
    {"serial", kSerial},
    {"socket", kSocket},
    {"sockets.tcp", kSocketsTcp},
    {"sockets.tcpServer", kSocketsTcpServer},
    {"sockets.udp", kSocketsUdp},
    {"storage", kStorage},
    {"system.cpu", kSystemCpu},
    {"system.display", kSystemDisplay},
    {"system.memory", kSystemMemory},
    {"system.network", kSystemNetwork},
    {"system.storage", kSystemStorage},
    {"test", kTest},
    {"types", kTypes},
    {"usb", kUsb},
    {"userScripts", kUserScripts},
    {"virtualKeyboard", kVirtualKeyboard},
    {"virtualKeyboardPrivate", kVirtualKeyboardPrivate},
    {"webRequest", kWebRequest},
    {"webRequestInternal", kWebRequestInternal},
    {"webViewInternal", kWebViewInternal},
    {"webViewRequest", kWebViewRequest},
  });
  auto it = kSchemas.find(name);
  return it != kSchemas.end() ? it->second : std::string_view();
}

}  // namespace api
}  // namespace extensions
