// third_party/blink/public/mojom/android_font_lookup/android_font_lookup.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/android_font_lookup/android_font_lookup.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/android_font_lookup/android_font_lookup.mojom-params-data.h"
#include "third_party/blink/public/mojom/android_font_lookup/android_font_lookup.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/android_font_lookup/android_font_lookup.mojom-import-headers.h"
#include "third_party/blink/public/mojom/android_font_lookup/android_font_lookup.mojom-test-utils.h"


namespace blink::mojom {
const char AndroidFontLookup::Name_[] = "blink.mojom.AndroidFontLookup";

AndroidFontLookup::IPCStableHashFunction AndroidFontLookup::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AndroidFontLookup>(message.name())) {
    case messages::AndroidFontLookup::kGetUniqueNameLookupTable: {
      return &AndroidFontLookup::GetUniqueNameLookupTable_Sym::IPCStableHash;
    }
    case messages::AndroidFontLookup::kMatchLocalFontByUniqueName: {
      return &AndroidFontLookup::MatchLocalFontByUniqueName_Sym::IPCStableHash;
    }
    case messages::AndroidFontLookup::kFetchAllFontFiles: {
      return &AndroidFontLookup::FetchAllFontFiles_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AndroidFontLookup::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AndroidFontLookup>(message.name())) {
      case messages::AndroidFontLookup::kGetUniqueNameLookupTable:
            return "Receive blink::mojom::AndroidFontLookup::GetUniqueNameLookupTable";
      case messages::AndroidFontLookup::kMatchLocalFontByUniqueName:
            return "Receive blink::mojom::AndroidFontLookup::MatchLocalFontByUniqueName";
      case messages::AndroidFontLookup::kFetchAllFontFiles:
            return "Receive blink::mojom::AndroidFontLookup::FetchAllFontFiles";
    }
  } else {
    switch (static_cast<messages::AndroidFontLookup>(message.name())) {
      case messages::AndroidFontLookup::kGetUniqueNameLookupTable:
            return "Receive reply blink::mojom::AndroidFontLookup::GetUniqueNameLookupTable";
      case messages::AndroidFontLookup::kMatchLocalFontByUniqueName:
            return "Receive reply blink::mojom::AndroidFontLookup::MatchLocalFontByUniqueName";
      case messages::AndroidFontLookup::kFetchAllFontFiles:
            return "Receive reply blink::mojom::AndroidFontLookup::FetchAllFontFiles";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AndroidFontLookup::GetUniqueNameLookupTable_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)blink::mojom::AndroidFontLookup::GetUniqueNameLookupTable");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AndroidFontLookup::MatchLocalFontByUniqueName_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)blink::mojom::AndroidFontLookup::MatchLocalFontByUniqueName");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AndroidFontLookup::FetchAllFontFiles_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)blink::mojom::AndroidFontLookup::FetchAllFontFiles");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool AndroidFontLookup::GetUniqueNameLookupTable(std::vector<std::string>* out_unique_font_names) {
  NOTREACHED();
}
bool AndroidFontLookup::MatchLocalFontByUniqueName(const std::string& font_unique_name, ::base::File* out_font_file_handle) {
  NOTREACHED();
}
class AndroidFontLookup_GetUniqueNameLookupTable_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  AndroidFontLookup_GetUniqueNameLookupTable_HandleSyncResponse(
      bool* result, std::vector<std::string>* out_unique_font_names)
      : result_(result), out_unique_font_names_(out_unique_font_names) {
    DCHECK(!*result_);
  }

  AndroidFontLookup_GetUniqueNameLookupTable_HandleSyncResponse(const AndroidFontLookup_GetUniqueNameLookupTable_HandleSyncResponse&) = delete;
  AndroidFontLookup_GetUniqueNameLookupTable_HandleSyncResponse& operator=(const AndroidFontLookup_GetUniqueNameLookupTable_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  std::vector<std::string>* out_unique_font_names_;};

class AndroidFontLookup_GetUniqueNameLookupTable_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AndroidFontLookup_GetUniqueNameLookupTable_ForwardToCallback(
      AndroidFontLookup::GetUniqueNameLookupTableCallback callback
      ) : callback_(std::move(callback)) {
  }

  AndroidFontLookup_GetUniqueNameLookupTable_ForwardToCallback(const AndroidFontLookup_GetUniqueNameLookupTable_ForwardToCallback&) = delete;
  AndroidFontLookup_GetUniqueNameLookupTable_ForwardToCallback& operator=(const AndroidFontLookup_GetUniqueNameLookupTable_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AndroidFontLookup::GetUniqueNameLookupTableCallback callback_;
};
class AndroidFontLookup_MatchLocalFontByUniqueName_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  AndroidFontLookup_MatchLocalFontByUniqueName_HandleSyncResponse(
      bool* result, ::base::File* out_font_file_handle)
      : result_(result), out_font_file_handle_(out_font_file_handle) {
    DCHECK(!*result_);
  }

  AndroidFontLookup_MatchLocalFontByUniqueName_HandleSyncResponse(const AndroidFontLookup_MatchLocalFontByUniqueName_HandleSyncResponse&) = delete;
  AndroidFontLookup_MatchLocalFontByUniqueName_HandleSyncResponse& operator=(const AndroidFontLookup_MatchLocalFontByUniqueName_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File* out_font_file_handle_;};

class AndroidFontLookup_MatchLocalFontByUniqueName_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AndroidFontLookup_MatchLocalFontByUniqueName_ForwardToCallback(
      AndroidFontLookup::MatchLocalFontByUniqueNameCallback callback
      ) : callback_(std::move(callback)) {
  }

  AndroidFontLookup_MatchLocalFontByUniqueName_ForwardToCallback(const AndroidFontLookup_MatchLocalFontByUniqueName_ForwardToCallback&) = delete;
  AndroidFontLookup_MatchLocalFontByUniqueName_ForwardToCallback& operator=(const AndroidFontLookup_MatchLocalFontByUniqueName_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AndroidFontLookup::MatchLocalFontByUniqueNameCallback callback_;
};

class AndroidFontLookup_FetchAllFontFiles_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AndroidFontLookup_FetchAllFontFiles_ForwardToCallback(
      AndroidFontLookup::FetchAllFontFilesCallback callback
      ) : callback_(std::move(callback)) {
  }

  AndroidFontLookup_FetchAllFontFiles_ForwardToCallback(const AndroidFontLookup_FetchAllFontFiles_ForwardToCallback&) = delete;
  AndroidFontLookup_FetchAllFontFiles_ForwardToCallback& operator=(const AndroidFontLookup_FetchAllFontFiles_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AndroidFontLookup::FetchAllFontFilesCallback callback_;
};

AndroidFontLookupProxy::AndroidFontLookupProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool AndroidFontLookupProxy::GetUniqueNameLookupTable(
    std::vector<std::string>* out_param_unique_font_names) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call blink::mojom::AndroidFontLookup::GetUniqueNameLookupTable (sync)");
#else
  TRACE_EVENT0("mojom", "AndroidFontLookup::GetUniqueNameLookupTable");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AndroidFontLookup::kGetUniqueNameLookupTable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AndroidFontLookup_GetUniqueNameLookupTable_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AndroidFontLookup::Name_);
  message.set_method_name("GetUniqueNameLookupTable");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AndroidFontLookup_GetUniqueNameLookupTable_HandleSyncResponse(
          &result, out_param_unique_font_names));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "AndroidFontLookup::GetUniqueNameLookupTable", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("unique_font_names"), out_param_unique_font_names,
                        "<value of type const std::vector<std::string>&>");
   });
#endif
  return result;
}

void AndroidFontLookupProxy::GetUniqueNameLookupTable(
    GetUniqueNameLookupTableCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::AndroidFontLookup::GetUniqueNameLookupTable");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AndroidFontLookup::kGetUniqueNameLookupTable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AndroidFontLookup_GetUniqueNameLookupTable_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AndroidFontLookup::Name_);
  message.set_method_name("GetUniqueNameLookupTable");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AndroidFontLookup_GetUniqueNameLookupTable_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool AndroidFontLookupProxy::MatchLocalFontByUniqueName(
    const std::string& param_font_unique_name, ::base::File* out_param_font_file_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::AndroidFontLookup::MatchLocalFontByUniqueName (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("font_unique_name"), param_font_unique_name,
                        "<value of type const std::string&>");
   });
#else
  TRACE_EVENT0("mojom", "AndroidFontLookup::MatchLocalFontByUniqueName");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AndroidFontLookup::kMatchLocalFontByUniqueName), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AndroidFontLookup_MatchLocalFontByUniqueName_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->font_unique_name)::BaseType> font_unique_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      param_font_unique_name, font_unique_name_fragment);
  params->font_unique_name.Set(
      font_unique_name_fragment.is_null() ? nullptr : font_unique_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->font_unique_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null font_unique_name in AndroidFontLookup.MatchLocalFontByUniqueName request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AndroidFontLookup::Name_);
  message.set_method_name("MatchLocalFontByUniqueName");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AndroidFontLookup_MatchLocalFontByUniqueName_HandleSyncResponse(
          &result, out_param_font_file_handle));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "AndroidFontLookup::MatchLocalFontByUniqueName", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("font_file_handle"), out_param_font_file_handle,
                        "<value of type ::base::File>");
   });
#endif
  return result;
}

void AndroidFontLookupProxy::MatchLocalFontByUniqueName(
    const std::string& in_font_unique_name, MatchLocalFontByUniqueNameCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AndroidFontLookup::MatchLocalFontByUniqueName", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("font_unique_name"), in_font_unique_name,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AndroidFontLookup::kMatchLocalFontByUniqueName), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AndroidFontLookup_MatchLocalFontByUniqueName_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->font_unique_name)::BaseType> font_unique_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_font_unique_name, font_unique_name_fragment);
  params->font_unique_name.Set(
      font_unique_name_fragment.is_null() ? nullptr : font_unique_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->font_unique_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null font_unique_name in AndroidFontLookup.MatchLocalFontByUniqueName request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AndroidFontLookup::Name_);
  message.set_method_name("MatchLocalFontByUniqueName");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AndroidFontLookup_MatchLocalFontByUniqueName_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AndroidFontLookupProxy::FetchAllFontFiles(
    FetchAllFontFilesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::AndroidFontLookup::FetchAllFontFiles");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AndroidFontLookup::kFetchAllFontFiles), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AndroidFontLookup_FetchAllFontFiles_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AndroidFontLookup::Name_);
  message.set_method_name("FetchAllFontFiles");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AndroidFontLookup_FetchAllFontFiles_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class AndroidFontLookup_GetUniqueNameLookupTable_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AndroidFontLookup::GetUniqueNameLookupTableCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AndroidFontLookup_GetUniqueNameLookupTable_ProxyToResponder> proxy(
        new AndroidFontLookup_GetUniqueNameLookupTable_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AndroidFontLookup_GetUniqueNameLookupTable_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AndroidFontLookup_GetUniqueNameLookupTable_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AndroidFontLookup_GetUniqueNameLookupTable_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "AndroidFontLookup::GetUniqueNameLookupTableCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<std::string>& in_unique_font_names);
};

bool AndroidFontLookup_GetUniqueNameLookupTable_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AndroidFontLookup_GetUniqueNameLookupTable_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AndroidFontLookup_GetUniqueNameLookupTable_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for AndroidFontLookup.0
  bool success = true;
  std::vector<std::string> p_unique_font_names{};
  AndroidFontLookup_GetUniqueNameLookupTable_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadUniqueFontNames(&p_unique_font_names))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AndroidFontLookup::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_unique_font_names));
  return true;
}

void AndroidFontLookup_GetUniqueNameLookupTable_ProxyToResponder::Run(
    const std::vector<std::string>& in_unique_font_names) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::AndroidFontLookup::GetUniqueNameLookupTable", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("unique_font_names"), in_unique_font_names,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AndroidFontLookup::kGetUniqueNameLookupTable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AndroidFontLookup_GetUniqueNameLookupTable_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->unique_font_names)::BaseType>
      unique_font_names_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& unique_font_names_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_unique_font_names, unique_font_names_fragment, &unique_font_names_validate_params);
  params->unique_font_names.Set(
      unique_font_names_fragment.is_null() ? nullptr : unique_font_names_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->unique_font_names.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null unique_font_names in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AndroidFontLookup::Name_);
  message.set_method_name("GetUniqueNameLookupTable");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool AndroidFontLookup_GetUniqueNameLookupTable_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AndroidFontLookup_GetUniqueNameLookupTable_ResponseParams_Data* params =
      reinterpret_cast<internal::AndroidFontLookup_GetUniqueNameLookupTable_ResponseParams_Data*>(
          message->mutable_payload());
  
  
  // Validation for AndroidFontLookup.0
  bool success = true;
  std::vector<std::string> p_unique_font_names{};
  AndroidFontLookup_GetUniqueNameLookupTable_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadUniqueFontNames(&p_unique_font_names))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AndroidFontLookup::Name_, 0, true);
    return false;
  }
  *out_unique_font_names_ = std::move(p_unique_font_names);
  *result_ = true;
  return true;
}
class AndroidFontLookup_MatchLocalFontByUniqueName_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AndroidFontLookup::MatchLocalFontByUniqueNameCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AndroidFontLookup_MatchLocalFontByUniqueName_ProxyToResponder> proxy(
        new AndroidFontLookup_MatchLocalFontByUniqueName_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AndroidFontLookup_MatchLocalFontByUniqueName_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AndroidFontLookup_MatchLocalFontByUniqueName_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AndroidFontLookup_MatchLocalFontByUniqueName_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "AndroidFontLookup::MatchLocalFontByUniqueNameCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File in_font_file_handle);
};

bool AndroidFontLookup_MatchLocalFontByUniqueName_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AndroidFontLookup_MatchLocalFontByUniqueName_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AndroidFontLookup_MatchLocalFontByUniqueName_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for AndroidFontLookup.1
  bool success = true;
  ::base::File p_font_file_handle{};
  AndroidFontLookup_MatchLocalFontByUniqueName_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadFontFileHandle(&p_font_file_handle))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AndroidFontLookup::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_font_file_handle));
  return true;
}

void AndroidFontLookup_MatchLocalFontByUniqueName_ProxyToResponder::Run(
    ::base::File in_font_file_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::AndroidFontLookup::MatchLocalFontByUniqueName", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("font_file_handle"), in_font_file_handle,
                        "<value of type ::base::File>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AndroidFontLookup::kMatchLocalFontByUniqueName), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AndroidFontLookup_MatchLocalFontByUniqueName_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->font_file_handle)::BaseType> font_file_handle_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView>(
      in_font_file_handle, font_file_handle_fragment);
  params->font_file_handle.Set(
      font_file_handle_fragment.is_null() ? nullptr : font_file_handle_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AndroidFontLookup::Name_);
  message.set_method_name("MatchLocalFontByUniqueName");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool AndroidFontLookup_MatchLocalFontByUniqueName_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AndroidFontLookup_MatchLocalFontByUniqueName_ResponseParams_Data* params =
      reinterpret_cast<internal::AndroidFontLookup_MatchLocalFontByUniqueName_ResponseParams_Data*>(
          message->mutable_payload());
  
  
  // Validation for AndroidFontLookup.1
  bool success = true;
  ::base::File p_font_file_handle{};
  AndroidFontLookup_MatchLocalFontByUniqueName_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadFontFileHandle(&p_font_file_handle))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AndroidFontLookup::Name_, 1, true);
    return false;
  }
  *out_font_file_handle_ = std::move(p_font_file_handle);
  *result_ = true;
  return true;
}
class AndroidFontLookup_FetchAllFontFiles_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AndroidFontLookup::FetchAllFontFilesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AndroidFontLookup_FetchAllFontFiles_ProxyToResponder> proxy(
        new AndroidFontLookup_FetchAllFontFiles_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AndroidFontLookup_FetchAllFontFiles_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AndroidFontLookup_FetchAllFontFiles_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AndroidFontLookup_FetchAllFontFiles_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "AndroidFontLookup::FetchAllFontFilesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      base::flat_map<std::string, ::base::File> in_font_files);
};

bool AndroidFontLookup_FetchAllFontFiles_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AndroidFontLookup_FetchAllFontFiles_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AndroidFontLookup_FetchAllFontFiles_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for AndroidFontLookup.2
  bool success = true;
  base::flat_map<std::string, ::base::File> p_font_files{};
  AndroidFontLookup_FetchAllFontFiles_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadFontFiles(&p_font_files))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AndroidFontLookup::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_font_files));
  return true;
}

void AndroidFontLookup_FetchAllFontFiles_ProxyToResponder::Run(
    base::flat_map<std::string, ::base::File> in_font_files) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::AndroidFontLookup::FetchAllFontFiles", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("font_files"), in_font_files,
                        "<value of type base::flat_map<std::string, ::base::File>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AndroidFontLookup::kFetchAllFontFiles), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AndroidFontLookup_FetchAllFontFiles_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->font_files)::BaseType>
      font_files_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& font_files_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::ReadOnlyFileDataView>>(
      in_font_files, font_files_fragment, &font_files_validate_params);
  params->font_files.Set(
      font_files_fragment.is_null() ? nullptr : font_files_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->font_files.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null font_files in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AndroidFontLookup::Name_);
  message.set_method_name("FetchAllFontFiles");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool AndroidFontLookupStubDispatch::Accept(
    AndroidFontLookup* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AndroidFontLookup>(message->header()->name)) {
    case messages::AndroidFontLookup::kGetUniqueNameLookupTable: {
      break;
    }
    case messages::AndroidFontLookup::kMatchLocalFontByUniqueName: {
      break;
    }
    case messages::AndroidFontLookup::kFetchAllFontFiles: {
      break;
    }
  }
  return false;
}

// static
bool AndroidFontLookupStubDispatch::AcceptWithResponder(
    AndroidFontLookup* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AndroidFontLookup>(message->header()->name)) {
    case messages::AndroidFontLookup::kGetUniqueNameLookupTable: {
      internal::AndroidFontLookup_GetUniqueNameLookupTable_Params_Data* params =
          reinterpret_cast<
              internal::AndroidFontLookup_GetUniqueNameLookupTable_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for AndroidFontLookup.0
      bool success = true;
      AndroidFontLookup_GetUniqueNameLookupTable_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AndroidFontLookup::Name_, 0, false);
        return false;
      }
      AndroidFontLookup::GetUniqueNameLookupTableCallback callback =
          AndroidFontLookup_GetUniqueNameLookupTable_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetUniqueNameLookupTable(std::move(callback));
      return true;
    }
    case messages::AndroidFontLookup::kMatchLocalFontByUniqueName: {
      internal::AndroidFontLookup_MatchLocalFontByUniqueName_Params_Data* params =
          reinterpret_cast<
              internal::AndroidFontLookup_MatchLocalFontByUniqueName_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for AndroidFontLookup.1
      bool success = true;
      std::string p_font_unique_name{};
      AndroidFontLookup_MatchLocalFontByUniqueName_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFontUniqueName(&p_font_unique_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AndroidFontLookup::Name_, 1, false);
        return false;
      }
      AndroidFontLookup::MatchLocalFontByUniqueNameCallback callback =
          AndroidFontLookup_MatchLocalFontByUniqueName_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MatchLocalFontByUniqueName(        
        std::move(p_font_unique_name), std::move(callback));
      return true;
    }
    case messages::AndroidFontLookup::kFetchAllFontFiles: {
      internal::AndroidFontLookup_FetchAllFontFiles_Params_Data* params =
          reinterpret_cast<
              internal::AndroidFontLookup_FetchAllFontFiles_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for AndroidFontLookup.2
      bool success = true;
      AndroidFontLookup_FetchAllFontFiles_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AndroidFontLookup::Name_, 2, false);
        return false;
      }
      AndroidFontLookup::FetchAllFontFilesCallback callback =
          AndroidFontLookup_FetchAllFontFiles_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FetchAllFontFiles(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAndroidFontLookupValidationInfo[] = {
    { &internal::AndroidFontLookup_GetUniqueNameLookupTable_Params_Data::Validate,
     &internal::AndroidFontLookup_GetUniqueNameLookupTable_ResponseParams_Data::Validate},
    { &internal::AndroidFontLookup_MatchLocalFontByUniqueName_Params_Data::Validate,
     &internal::AndroidFontLookup_MatchLocalFontByUniqueName_ResponseParams_Data::Validate},
    { &internal::AndroidFontLookup_FetchAllFontFiles_Params_Data::Validate,
     &internal::AndroidFontLookup_FetchAllFontFiles_ResponseParams_Data::Validate},
};

bool AndroidFontLookupRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::AndroidFontLookup::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kAndroidFontLookupValidationInfo);
}

bool AndroidFontLookupResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::AndroidFontLookup::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kAndroidFontLookupValidationInfo);
}


}  // blink::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void AndroidFontLookupInterceptorForTesting::GetUniqueNameLookupTable(GetUniqueNameLookupTableCallback callback) {
  GetForwardingInterface()->GetUniqueNameLookupTable(std::move(callback));
}
void AndroidFontLookupInterceptorForTesting::MatchLocalFontByUniqueName(const std::string& font_unique_name, MatchLocalFontByUniqueNameCallback callback) {
  GetForwardingInterface()->MatchLocalFontByUniqueName(
    std::move(font_unique_name)
    , std::move(callback));
}
void AndroidFontLookupInterceptorForTesting::FetchAllFontFiles(FetchAllFontFilesCallback callback) {
  GetForwardingInterface()->FetchAllFontFiles(std::move(callback));
}
AndroidFontLookupAsyncWaiter::AndroidFontLookupAsyncWaiter(
    AndroidFontLookup* proxy) : proxy_(proxy) {}

AndroidFontLookupAsyncWaiter::~AndroidFontLookupAsyncWaiter() = default;

void AndroidFontLookupAsyncWaiter::GetUniqueNameLookupTable(
    std::vector<std::string>* out_unique_font_names) {
  base::RunLoop loop;
  proxy_->GetUniqueNameLookupTable(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<std::string>* out_unique_font_names
,
             const std::vector<std::string>& unique_font_names) {*out_unique_font_names = std::move(unique_font_names);
            loop->Quit();
          },
          &loop,
          out_unique_font_names));
  loop.Run();
}

std::vector<std::string> AndroidFontLookupAsyncWaiter::GetUniqueNameLookupTable(
    ) {
  std::vector<std::string> async_wait_result;
  GetUniqueNameLookupTable(&async_wait_result);
  return async_wait_result;
}

void AndroidFontLookupAsyncWaiter::MatchLocalFontByUniqueName(
    const std::string& font_unique_name, ::base::File* out_font_file_handle) {
  base::RunLoop loop;
  proxy_->MatchLocalFontByUniqueName(
      std::move(font_unique_name),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::File* out_font_file_handle
,
             ::base::File font_file_handle) {*out_font_file_handle = std::move(font_file_handle);
            loop->Quit();
          },
          &loop,
          out_font_file_handle));
  loop.Run();
}

::base::File AndroidFontLookupAsyncWaiter::MatchLocalFontByUniqueName(
    const std::string& font_unique_name) {
  ::base::File async_wait_result;
  MatchLocalFontByUniqueName(std::move(font_unique_name),&async_wait_result);
  return async_wait_result;
}

void AndroidFontLookupAsyncWaiter::FetchAllFontFiles(
    base::flat_map<std::string, ::base::File>* out_font_files) {
  base::RunLoop loop;
  proxy_->FetchAllFontFiles(
      base::BindOnce(
          [](base::RunLoop* loop,
             base::flat_map<std::string, ::base::File>* out_font_files
,
             base::flat_map<std::string, ::base::File> font_files) {*out_font_files = std::move(font_files);
            loop->Quit();
          },
          &loop,
          out_font_files));
  loop.Run();
}

base::flat_map<std::string, ::base::File> AndroidFontLookupAsyncWaiter::FetchAllFontFiles(
    ) {
  base::flat_map<std::string, ::base::File> async_wait_result;
  FetchAllFontFiles(&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif