// ui/accessibility/mojom/ax_event_intent.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_EVENT_INTENT_MOJOM_SHARED_H_
#define UI_ACCESSIBILITY_MOJOM_AX_EVENT_INTENT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/accessibility/mojom/ax_event_intent.mojom-shared-internal.h"
#include "ui/accessibility/ax_enums.mojom-shared.h"







namespace ax::mojom {
class EventIntentDataView;



}  // ax::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::ax::mojom::EventIntentDataView> {
  using Data = ::ax::mojom::internal::EventIntent_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace ax::mojom {


class EventIntentDataView {
 public:
  EventIntentDataView() = default;

  EventIntentDataView(
      internal::EventIntent_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadCommand(UserType* output) const {
    auto data_value = data_->command;
    return mojo::internal::Deserialize<::ax::mojom::Command>(
        data_value, output);
  }
  ::ax::mojom::Command command() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ax::mojom::Command>(data_->command));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadInputEventType(UserType* output) const {
    auto data_value = data_->input_event_type;
    return mojo::internal::Deserialize<::ax::mojom::InputEventType>(
        data_value, output);
  }
  ::ax::mojom::InputEventType input_event_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ax::mojom::InputEventType>(data_->input_event_type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTextBoundary(UserType* output) const {
    auto data_value = data_->text_boundary;
    return mojo::internal::Deserialize<::ax::mojom::TextBoundary>(
        data_value, output);
  }
  ::ax::mojom::TextBoundary text_boundary() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ax::mojom::TextBoundary>(data_->text_boundary));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMoveDirection(UserType* output) const {
    auto data_value = data_->move_direction;
    return mojo::internal::Deserialize<::ax::mojom::MoveDirection>(
        data_value, output);
  }
  ::ax::mojom::MoveDirection move_direction() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ax::mojom::MoveDirection>(data_->move_direction));
  }
 private:
  internal::EventIntent_Data* data_ = nullptr;
};


}  // ax::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::EventIntentDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ax::mojom::EventIntentDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ax::mojom::internal::EventIntent_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::ax::mojom::Command>(
        Traits::command(input), &fragment->command);
    mojo::internal::Serialize<::ax::mojom::InputEventType>(
        Traits::input_event_type(input), &fragment->input_event_type);
    mojo::internal::Serialize<::ax::mojom::TextBoundary>(
        Traits::text_boundary(input), &fragment->text_boundary);
    mojo::internal::Serialize<::ax::mojom::MoveDirection>(
        Traits::move_direction(input), &fragment->move_direction);
  }

  static bool Deserialize(::ax::mojom::internal::EventIntent_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ax::mojom::EventIntentDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace ax::mojom {




}  // ax::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // UI_ACCESSIBILITY_MOJOM_AX_EVENT_INTENT_MOJOM_SHARED_H_