// For license of this file, see <project-root-folder>/LICENSE.md.

#ifndef ATOMPARSER_H
#define ATOMPARSER_H

#include "src/parsers/feedparser.h"

#include <librssguard/core/message.h>

#include <QList>

class AtomParser : public FeedParser {
  public:
    explicit AtomParser(const QString& data);
    virtual ~AtomParser();

    virtual QList<StandardFeed*> discoverFeeds(ServiceRoot* root, const QUrl& url, bool greedy) const;

    virtual QPair<StandardFeed*, QList<IconLocation>> guessFeed(const QByteArray& content,
                                                                const NetworkResult& network_res) const;

  protected:
    virtual QDomNodeList xmlMessageElements();
    virtual QString feedAuthor() const;

    virtual QString xmlMessageTitle(const QDomElement& msg_element) const;
    virtual QString xmlMessageDescription(const QDomElement& msg_element) const;
    virtual QDateTime xmlMessageDateCreated(const QDomElement& msg_element);
    virtual QString xmlMessageId(const QDomElement& msg_element) const;
    virtual QString xmlMessageUrl(const QDomElement& msg_element) const;
    virtual QList<QSharedPointer<MessageEnclosure>> xmlMessageEnclosures(const QDomElement& msg_element) const;
    virtual QList<QSharedPointer<MessageCategory>> xmlMessageCategories(const QDomElement& msg_element) const;
    virtual QString xmlMessageAuthor(const QDomElement& msg_element) const;

  private:
    QString atomNamespace() const;
    QList<FeedComment> comments(const QDomElement& msg_element) const;

    QString m_atomNamespace;
};

#endif // ATOMPARSER_H
