/* localsearch-titles.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from localsearch-titles.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-localsearch.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include "rygel-server.h"
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	RYGEL_LOCAL_SEARCH_TITLES_0_PROPERTY,
	RYGEL_LOCAL_SEARCH_TITLES_NUM_PROPERTIES
};
static GParamSpec* rygel_local_search_titles_properties[RYGEL_LOCAL_SEARCH_TITLES_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

static gpointer rygel_local_search_titles_parent_class = NULL;

static gchar* rygel_local_search_titles_real_create_title_for_value (RygelLocalSearchMetadataContainer* base,
                                                              const gchar* value);
static gchar* rygel_local_search_titles_real_create_filter (RygelLocalSearchMetadataContainer* base,
                                                     const gchar* variable,
                                                     const gchar* value);
static GType rygel_local_search_titles_get_type_once (void);

static const gchar* RYGEL_LOCAL_SEARCH_TITLES_KEY_CHAIN[2] = {"dc:title", NULL};

RygelLocalSearchTitles*
rygel_local_search_titles_construct (GType object_type,
                                     RygelMediaContainer* parent,
                                     RygelLocalSearchItemFactory* item_factory)
{
	RygelLocalSearchTitles * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (item_factory != NULL, NULL);
	_tmp0_ = rygel_media_object_get_id ((RygelMediaObject*) parent);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, "Titles", NULL);
	_tmp3_ = _tmp2_;
	self = (RygelLocalSearchTitles*) rygel_local_search_metadata_values_construct (object_type, _tmp3_, parent, _ ("Titles"), item_factory, "dc:title", NULL);
	_g_free0 (_tmp3_);
	return self;
}

RygelLocalSearchTitles*
rygel_local_search_titles_new (RygelMediaContainer* parent,
                               RygelLocalSearchItemFactory* item_factory)
{
	return rygel_local_search_titles_construct (RYGEL_LOCAL_SEARCH_TYPE_TITLES, parent, item_factory);
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

static gchar*
rygel_local_search_titles_real_create_title_for_value (RygelLocalSearchMetadataContainer* base,
                                                       const gchar* value)
{
	RygelLocalSearchTitles * self;
	gunichar c = 0U;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	self = (RygelLocalSearchTitles*) base;
	g_return_val_if_fail (value != NULL, NULL);
	c = g_utf8_get_char_validated (value, (gssize) -1);
	if (G_UNLIKELY (c < ((gunichar) 0))) {
		result = NULL;
		return result;
	}
	_tmp0_ = g_unichar_to_string (c);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_utf8_strup (_tmp1_, (gssize) -1);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static gchar*
rygel_local_search_titles_real_create_filter (RygelLocalSearchMetadataContainer* base,
                                              const gchar* variable,
                                              const gchar* value)
{
	RygelLocalSearchTitles * self;
	gchar* title = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* result;
	self = (RygelLocalSearchTitles*) base;
	g_return_val_if_fail (variable != NULL, NULL);
	g_return_val_if_fail (value != NULL, NULL);
	_tmp0_ = rygel_local_search_metadata_container_create_title_for_value ((RygelLocalSearchMetadataContainer*) self, value);
	_tmp1_ = _tmp0_;
	_tmp2_ = rygel_local_search_query_escape_regex (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	title = _tmp3_;
	_tmp4_ = g_strconcat ("regex(", variable, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp5_, ", \"^", NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, title, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, "\", \"i\")", NULL);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	result = _tmp11_;
	_g_free0 (title);
	return result;
}

static void
rygel_local_search_titles_class_init (RygelLocalSearchTitlesClass * klass,
                                      gpointer klass_data)
{
	rygel_local_search_titles_parent_class = g_type_class_peek_parent (klass);
	((RygelLocalSearchMetadataContainerClass *) klass)->create_title_for_value = (gchar* (*) (RygelLocalSearchMetadataContainer*, const gchar*)) rygel_local_search_titles_real_create_title_for_value;
	((RygelLocalSearchMetadataContainerClass *) klass)->create_filter = (gchar* (*) (RygelLocalSearchMetadataContainer*, const gchar*, const gchar*)) rygel_local_search_titles_real_create_filter;
}

static void
rygel_local_search_titles_instance_init (RygelLocalSearchTitles * self,
                                         gpointer klass)
{
}

/**
 * Container providing a title-based hierarchy.
 *
 * Under each category container, add a container providing a title-based
 * hierarchy: One container for each unique starting character of all the titles
 * available for the contegory in question. Something like this:
 *
 * Music
 *   |
 *   |----> Genre
 *           |..
 *   ^
 *   |----> Titles
 *           |
 *           |---> A
 *                 |
 *                 |--> Alpha
 *                 |--> alright
 *           ^
 *           |---> B
 *                 |
 *                 |--> Bravo
 *                 |--> brave
 *                 |..
 *           ^
 *   ^       |..
 *   |..
 */
 G_GNUC_NO_INLINE static GType
rygel_local_search_titles_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelLocalSearchTitlesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_local_search_titles_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelLocalSearchTitles), 0, (GInstanceInitFunc) rygel_local_search_titles_instance_init, NULL };
	GType rygel_local_search_titles_type_id;
	rygel_local_search_titles_type_id = g_type_register_static (RYGEL_LOCAL_SEARCH_TYPE_METADATA_VALUES, "RygelLocalSearchTitles", &g_define_type_info, 0);
	return rygel_local_search_titles_type_id;
}

GType
rygel_local_search_titles_get_type (void)
{
	static volatile gsize rygel_local_search_titles_type_id__once = 0;
	if (g_once_init_enter (&rygel_local_search_titles_type_id__once)) {
		GType rygel_local_search_titles_type_id;
		rygel_local_search_titles_type_id = rygel_local_search_titles_get_type_once ();
		g_once_init_leave (&rygel_local_search_titles_type_id__once, rygel_local_search_titles_type_id);
	}
	return rygel_local_search_titles_type_id__once;
}

