/* client functions auto-generated by pidl */

#include "includes.h"
#include <tevent.h>
#include "lib/util/tevent_ntstatus.h"
#include "bin/default/librpc/gen_ndr/ndr_drsuapi.h"
#include "bin/default/librpc/gen_ndr/ndr_drsuapi_c.h"

/* drsuapi - client functions generated by pidl */

struct dcerpc_drsuapi_DsBind_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drsuapi_DsBind_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drsuapi_DsBind_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct drsuapi_DsBind *r)
{
	struct tevent_req *req;
	struct dcerpc_drsuapi_DsBind_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drsuapi_DsBind_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_drsuapi,
			NDR_DRSUAPI_DSBIND, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drsuapi_DsBind_r_done, req);

	return req;
}

static void dcerpc_drsuapi_DsBind_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_drsuapi_DsBind_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_drsuapi_DsBind_r_state *state =
		tevent_req_data(req,
		struct dcerpc_drsuapi_DsBind_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drsuapi_DsBind_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct drsuapi_DsBind *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_drsuapi,
			NDR_DRSUAPI_DSBIND, mem_ctx, r);

	return status;
}

struct dcerpc_drsuapi_DsBind_state {
	struct drsuapi_DsBind orig;
	struct drsuapi_DsBind tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drsuapi_DsBind_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drsuapi_DsBind_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct dcerpc_binding_handle *h,
					      struct GUID *_bind_guid /* [in] [unique] */,
					      struct drsuapi_DsBindInfoCtr *_bind_info /* [in,out] [unique] */,
					      struct policy_handle *_bind_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_drsuapi_DsBind_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drsuapi_DsBind_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.bind_guid = _bind_guid;
	state->orig.in.bind_info = _bind_info;

	/* Out parameters */
	state->orig.out.bind_info = _bind_info;
	state->orig.out.bind_handle = _bind_handle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_drsuapi_DsBind_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_drsuapi_DsBind_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drsuapi_DsBind_done, req);
	return req;
}

static void dcerpc_drsuapi_DsBind_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_drsuapi_DsBind_state *state = tevent_req_data(
		req, struct dcerpc_drsuapi_DsBind_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_drsuapi_DsBind_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.bind_info && state->tmp.out.bind_info) {
		*state->orig.out.bind_info = *state->tmp.out.bind_info;
	}
	*state->orig.out.bind_handle = *state->tmp.out.bind_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_drsuapi_DsBind_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    WERROR *result)
{
	struct dcerpc_drsuapi_DsBind_state *state = tevent_req_data(
		req, struct dcerpc_drsuapi_DsBind_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drsuapi_DsBind(struct dcerpc_binding_handle *h,
			       TALLOC_CTX *mem_ctx,
			       struct GUID *_bind_guid /* [in] [unique] */,
			       struct drsuapi_DsBindInfoCtr *_bind_info /* [in,out] [unique] */,
			       struct policy_handle *_bind_handle /* [out] [ref] */,
			       WERROR *result)
{
	struct drsuapi_DsBind r;
	NTSTATUS status;

	/* In parameters */
	r.in.bind_guid = _bind_guid;
	r.in.bind_info = _bind_info;

	/* Out parameters */
	r.out.bind_info = _bind_info;
	r.out.bind_handle = _bind_handle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_drsuapi_DsBind_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_bind_info && r.out.bind_info) {
		*_bind_info = *r.out.bind_info;
	}
	*_bind_handle = *r.out.bind_handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_drsuapi_DsUnbind_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drsuapi_DsUnbind_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drsuapi_DsUnbind_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct drsuapi_DsUnbind *r)
{
	struct tevent_req *req;
	struct dcerpc_drsuapi_DsUnbind_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drsuapi_DsUnbind_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_drsuapi,
			NDR_DRSUAPI_DSUNBIND, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drsuapi_DsUnbind_r_done, req);

	return req;
}

static void dcerpc_drsuapi_DsUnbind_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_drsuapi_DsUnbind_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_drsuapi_DsUnbind_r_state *state =
		tevent_req_data(req,
		struct dcerpc_drsuapi_DsUnbind_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drsuapi_DsUnbind_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct drsuapi_DsUnbind *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_drsuapi,
			NDR_DRSUAPI_DSUNBIND, mem_ctx, r);

	return status;
}

struct dcerpc_drsuapi_DsUnbind_state {
	struct drsuapi_DsUnbind orig;
	struct drsuapi_DsUnbind tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drsuapi_DsUnbind_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drsuapi_DsUnbind_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						struct policy_handle *_bind_handle /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_drsuapi_DsUnbind_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drsuapi_DsUnbind_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.bind_handle = _bind_handle;

	/* Out parameters */
	state->orig.out.bind_handle = _bind_handle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_drsuapi_DsUnbind_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_drsuapi_DsUnbind_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drsuapi_DsUnbind_done, req);
	return req;
}

static void dcerpc_drsuapi_DsUnbind_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_drsuapi_DsUnbind_state *state = tevent_req_data(
		req, struct dcerpc_drsuapi_DsUnbind_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_drsuapi_DsUnbind_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.bind_handle = *state->tmp.out.bind_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_drsuapi_DsUnbind_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct dcerpc_drsuapi_DsUnbind_state *state = tevent_req_data(
		req, struct dcerpc_drsuapi_DsUnbind_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drsuapi_DsUnbind(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *_bind_handle /* [in,out] [ref] */,
				 WERROR *result)
{
	struct drsuapi_DsUnbind r;
	NTSTATUS status;

	/* In parameters */
	r.in.bind_handle = _bind_handle;

	/* Out parameters */
	r.out.bind_handle = _bind_handle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_drsuapi_DsUnbind_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_bind_handle = *r.out.bind_handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_drsuapi_DsReplicaSync_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drsuapi_DsReplicaSync_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drsuapi_DsReplicaSync_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct drsuapi_DsReplicaSync *r)
{
	struct tevent_req *req;
	struct dcerpc_drsuapi_DsReplicaSync_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drsuapi_DsReplicaSync_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_drsuapi,
			NDR_DRSUAPI_DSREPLICASYNC, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drsuapi_DsReplicaSync_r_done, req);

	return req;
}

static void dcerpc_drsuapi_DsReplicaSync_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_drsuapi_DsReplicaSync_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_drsuapi_DsReplicaSync_r_state *state =
		tevent_req_data(req,
		struct dcerpc_drsuapi_DsReplicaSync_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drsuapi_DsReplicaSync_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct drsuapi_DsReplicaSync *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_drsuapi,
			NDR_DRSUAPI_DSREPLICASYNC, mem_ctx, r);

	return status;
}

struct dcerpc_drsuapi_DsReplicaSync_state {
	struct drsuapi_DsReplicaSync orig;
	struct drsuapi_DsReplicaSync tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drsuapi_DsReplicaSync_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drsuapi_DsReplicaSync_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     struct policy_handle *_bind_handle /* [in] [ref] */,
						     uint32_t _level /* [in]  */,
						     union drsuapi_DsReplicaSyncRequest *_req /* [in] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_drsuapi_DsReplicaSync_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drsuapi_DsReplicaSync_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.bind_handle = _bind_handle;
	state->orig.in.level = _level;
	state->orig.in.req = _req;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_drsuapi_DsReplicaSync_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drsuapi_DsReplicaSync_done, req);
	return req;
}

static void dcerpc_drsuapi_DsReplicaSync_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_drsuapi_DsReplicaSync_state *state = tevent_req_data(
		req, struct dcerpc_drsuapi_DsReplicaSync_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_drsuapi_DsReplicaSync_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_drsuapi_DsReplicaSync_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_drsuapi_DsReplicaSync_state *state = tevent_req_data(
		req, struct dcerpc_drsuapi_DsReplicaSync_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drsuapi_DsReplicaSync(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *_bind_handle /* [in] [ref] */,
				      uint32_t _level /* [in]  */,
				      union drsuapi_DsReplicaSyncRequest *_req /* [in] [ref,switch_is(level)] */,
				      WERROR *result)
{
	struct drsuapi_DsReplicaSync r;
	NTSTATUS status;

	/* In parameters */
	r.in.bind_handle = _bind_handle;
	r.in.level = _level;
	r.in.req = _req;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_drsuapi_DsReplicaSync_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_drsuapi_DsGetNCChanges_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drsuapi_DsGetNCChanges_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drsuapi_DsGetNCChanges_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct drsuapi_DsGetNCChanges *r)
{
	struct tevent_req *req;
	struct dcerpc_drsuapi_DsGetNCChanges_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drsuapi_DsGetNCChanges_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_drsuapi,
			NDR_DRSUAPI_DSGETNCCHANGES, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drsuapi_DsGetNCChanges_r_done, req);

	return req;
}

static void dcerpc_drsuapi_DsGetNCChanges_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_drsuapi_DsGetNCChanges_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_drsuapi_DsGetNCChanges_r_state *state =
		tevent_req_data(req,
		struct dcerpc_drsuapi_DsGetNCChanges_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drsuapi_DsGetNCChanges_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct drsuapi_DsGetNCChanges *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_drsuapi,
			NDR_DRSUAPI_DSGETNCCHANGES, mem_ctx, r);

	return status;
}

struct dcerpc_drsuapi_DsGetNCChanges_state {
	struct drsuapi_DsGetNCChanges orig;
	struct drsuapi_DsGetNCChanges tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drsuapi_DsGetNCChanges_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drsuapi_DsGetNCChanges_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct policy_handle *_bind_handle /* [in] [ref] */,
						      uint32_t _level /* [in]  */,
						      union drsuapi_DsGetNCChangesRequest *_req /* [in] [ref,switch_is(level)] */,
						      uint32_t *_level_out /* [out] [ref] */,
						      union drsuapi_DsGetNCChangesCtr *_ctr /* [out] [ref,switch_is(*level_out)] */)
{
	struct tevent_req *req;
	struct dcerpc_drsuapi_DsGetNCChanges_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drsuapi_DsGetNCChanges_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.bind_handle = _bind_handle;
	state->orig.in.level = _level;
	state->orig.in.req = _req;

	/* Out parameters */
	state->orig.out.level_out = _level_out;
	state->orig.out.ctr = _ctr;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_drsuapi_DsGetNCChanges_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_drsuapi_DsGetNCChanges_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drsuapi_DsGetNCChanges_done, req);
	return req;
}

static void dcerpc_drsuapi_DsGetNCChanges_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_drsuapi_DsGetNCChanges_state *state = tevent_req_data(
		req, struct dcerpc_drsuapi_DsGetNCChanges_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_drsuapi_DsGetNCChanges_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.level_out = *state->tmp.out.level_out;
	*state->orig.out.ctr = *state->tmp.out.ctr;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_drsuapi_DsGetNCChanges_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result)
{
	struct dcerpc_drsuapi_DsGetNCChanges_state *state = tevent_req_data(
		req, struct dcerpc_drsuapi_DsGetNCChanges_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drsuapi_DsGetNCChanges(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle *_bind_handle /* [in] [ref] */,
				       uint32_t _level /* [in]  */,
				       union drsuapi_DsGetNCChangesRequest *_req /* [in] [ref,switch_is(level)] */,
				       uint32_t *_level_out /* [out] [ref] */,
				       union drsuapi_DsGetNCChangesCtr *_ctr /* [out] [ref,switch_is(*level_out)] */,
				       WERROR *result)
{
	struct drsuapi_DsGetNCChanges r;
	NTSTATUS status;

	/* In parameters */
	r.in.bind_handle = _bind_handle;
	r.in.level = _level;
	r.in.req = _req;

	/* Out parameters */
	r.out.level_out = _level_out;
	r.out.ctr = _ctr;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_drsuapi_DsGetNCChanges_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_level_out = *r.out.level_out;
	*_ctr = *r.out.ctr;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_drsuapi_DsReplicaUpdateRefs_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drsuapi_DsReplicaUpdateRefs_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drsuapi_DsReplicaUpdateRefs_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct drsuapi_DsReplicaUpdateRefs *r)
{
	struct tevent_req *req;
	struct dcerpc_drsuapi_DsReplicaUpdateRefs_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drsuapi_DsReplicaUpdateRefs_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_drsuapi,
			NDR_DRSUAPI_DSREPLICAUPDATEREFS, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drsuapi_DsReplicaUpdateRefs_r_done, req);

	return req;
}

static void dcerpc_drsuapi_DsReplicaUpdateRefs_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_drsuapi_DsReplicaUpdateRefs_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_drsuapi_DsReplicaUpdateRefs_r_state *state =
		tevent_req_data(req,
		struct dcerpc_drsuapi_DsReplicaUpdateRefs_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drsuapi_DsReplicaUpdateRefs_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct drsuapi_DsReplicaUpdateRefs *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_drsuapi,
			NDR_DRSUAPI_DSREPLICAUPDATEREFS, mem_ctx, r);

	return status;
}

struct dcerpc_drsuapi_DsReplicaUpdateRefs_state {
	struct drsuapi_DsReplicaUpdateRefs orig;
	struct drsuapi_DsReplicaUpdateRefs tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drsuapi_DsReplicaUpdateRefs_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drsuapi_DsReplicaUpdateRefs_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct dcerpc_binding_handle *h,
							   struct policy_handle *_bind_handle /* [in] [ref] */,
							   uint32_t _level /* [in]  */,
							   union drsuapi_DsReplicaUpdateRefsRequest _req /* [in] [switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_drsuapi_DsReplicaUpdateRefs_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drsuapi_DsReplicaUpdateRefs_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.bind_handle = _bind_handle;
	state->orig.in.level = _level;
	state->orig.in.req = _req;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_drsuapi_DsReplicaUpdateRefs_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drsuapi_DsReplicaUpdateRefs_done, req);
	return req;
}

static void dcerpc_drsuapi_DsReplicaUpdateRefs_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_drsuapi_DsReplicaUpdateRefs_state *state = tevent_req_data(
		req, struct dcerpc_drsuapi_DsReplicaUpdateRefs_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_drsuapi_DsReplicaUpdateRefs_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_drsuapi_DsReplicaUpdateRefs_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 WERROR *result)
{
	struct dcerpc_drsuapi_DsReplicaUpdateRefs_state *state = tevent_req_data(
		req, struct dcerpc_drsuapi_DsReplicaUpdateRefs_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drsuapi_DsReplicaUpdateRefs(struct dcerpc_binding_handle *h,
					    TALLOC_CTX *mem_ctx,
					    struct policy_handle *_bind_handle /* [in] [ref] */,
					    uint32_t _level /* [in]  */,
					    union drsuapi_DsReplicaUpdateRefsRequest _req /* [in] [switch_is(level)] */,
					    WERROR *result)
{
	struct drsuapi_DsReplicaUpdateRefs r;
	NTSTATUS status;

	/* In parameters */
	r.in.bind_handle = _bind_handle;
	r.in.level = _level;
	r.in.req = _req;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_drsuapi_DsReplicaUpdateRefs_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_drsuapi_DsReplicaAdd_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drsuapi_DsReplicaAdd_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drsuapi_DsReplicaAdd_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct drsuapi_DsReplicaAdd *r)
{
	struct tevent_req *req;
	struct dcerpc_drsuapi_DsReplicaAdd_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drsuapi_DsReplicaAdd_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_drsuapi,
			NDR_DRSUAPI_DSREPLICAADD, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drsuapi_DsReplicaAdd_r_done, req);

	return req;
}

static void dcerpc_drsuapi_DsReplicaAdd_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_drsuapi_DsReplicaAdd_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_drsuapi_DsReplicaAdd_r_state *state =
		tevent_req_data(req,
		struct dcerpc_drsuapi_DsReplicaAdd_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drsuapi_DsReplicaAdd_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct drsuapi_DsReplicaAdd *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_drsuapi,
			NDR_DRSUAPI_DSREPLICAADD, mem_ctx, r);

	return status;
}

struct dcerpc_drsuapi_DsReplicaAdd_state {
	struct drsuapi_DsReplicaAdd orig;
	struct drsuapi_DsReplicaAdd tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drsuapi_DsReplicaAdd_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drsuapi_DsReplicaAdd_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct policy_handle *_bind_handle /* [in] [ref] */,
						    uint32_t _level /* [in]  */,
						    union drsuapi_DsReplicaAddRequest _req /* [in] [switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_drsuapi_DsReplicaAdd_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drsuapi_DsReplicaAdd_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.bind_handle = _bind_handle;
	state->orig.in.level = _level;
	state->orig.in.req = _req;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_drsuapi_DsReplicaAdd_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drsuapi_DsReplicaAdd_done, req);
	return req;
}

static void dcerpc_drsuapi_DsReplicaAdd_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_drsuapi_DsReplicaAdd_state *state = tevent_req_data(
		req, struct dcerpc_drsuapi_DsReplicaAdd_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_drsuapi_DsReplicaAdd_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_drsuapi_DsReplicaAdd_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_drsuapi_DsReplicaAdd_state *state = tevent_req_data(
		req, struct dcerpc_drsuapi_DsReplicaAdd_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drsuapi_DsReplicaAdd(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *_bind_handle /* [in] [ref] */,
				     uint32_t _level /* [in]  */,
				     union drsuapi_DsReplicaAddRequest _req /* [in] [switch_is(level)] */,
				     WERROR *result)
{
	struct drsuapi_DsReplicaAdd r;
	NTSTATUS status;

	/* In parameters */
	r.in.bind_handle = _bind_handle;
	r.in.level = _level;
	r.in.req = _req;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_drsuapi_DsReplicaAdd_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_drsuapi_DsReplicaDel_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drsuapi_DsReplicaDel_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drsuapi_DsReplicaDel_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct drsuapi_DsReplicaDel *r)
{
	struct tevent_req *req;
	struct dcerpc_drsuapi_DsReplicaDel_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drsuapi_DsReplicaDel_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_drsuapi,
			NDR_DRSUAPI_DSREPLICADEL, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drsuapi_DsReplicaDel_r_done, req);

	return req;
}

static void dcerpc_drsuapi_DsReplicaDel_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_drsuapi_DsReplicaDel_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_drsuapi_DsReplicaDel_r_state *state =
		tevent_req_data(req,
		struct dcerpc_drsuapi_DsReplicaDel_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drsuapi_DsReplicaDel_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct drsuapi_DsReplicaDel *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_drsuapi,
			NDR_DRSUAPI_DSREPLICADEL, mem_ctx, r);

	return status;
}

struct dcerpc_drsuapi_DsReplicaDel_state {
	struct drsuapi_DsReplicaDel orig;
	struct drsuapi_DsReplicaDel tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drsuapi_DsReplicaDel_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drsuapi_DsReplicaDel_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct policy_handle *_bind_handle /* [in] [ref] */,
						    uint32_t _level /* [in]  */,
						    union drsuapi_DsReplicaDelRequest _req /* [in] [switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_drsuapi_DsReplicaDel_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drsuapi_DsReplicaDel_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.bind_handle = _bind_handle;
	state->orig.in.level = _level;
	state->orig.in.req = _req;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_drsuapi_DsReplicaDel_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drsuapi_DsReplicaDel_done, req);
	return req;
}

static void dcerpc_drsuapi_DsReplicaDel_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_drsuapi_DsReplicaDel_state *state = tevent_req_data(
		req, struct dcerpc_drsuapi_DsReplicaDel_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_drsuapi_DsReplicaDel_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_drsuapi_DsReplicaDel_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_drsuapi_DsReplicaDel_state *state = tevent_req_data(
		req, struct dcerpc_drsuapi_DsReplicaDel_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drsuapi_DsReplicaDel(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *_bind_handle /* [in] [ref] */,
				     uint32_t _level /* [in]  */,
				     union drsuapi_DsReplicaDelRequest _req /* [in] [switch_is(level)] */,
				     WERROR *result)
{
	struct drsuapi_DsReplicaDel r;
	NTSTATUS status;

	/* In parameters */
	r.in.bind_handle = _bind_handle;
	r.in.level = _level;
	r.in.req = _req;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_drsuapi_DsReplicaDel_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_drsuapi_DsReplicaMod_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drsuapi_DsReplicaMod_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drsuapi_DsReplicaMod_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct drsuapi_DsReplicaMod *r)
{
	struct tevent_req *req;
	struct dcerpc_drsuapi_DsReplicaMod_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drsuapi_DsReplicaMod_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_drsuapi,
			NDR_DRSUAPI_DSREPLICAMOD, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drsuapi_DsReplicaMod_r_done, req);

	return req;
}

static void dcerpc_drsuapi_DsReplicaMod_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_drsuapi_DsReplicaMod_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_drsuapi_DsReplicaMod_r_state *state =
		tevent_req_data(req,
		struct dcerpc_drsuapi_DsReplicaMod_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drsuapi_DsReplicaMod_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct drsuapi_DsReplicaMod *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_drsuapi,
			NDR_DRSUAPI_DSREPLICAMOD, mem_ctx, r);

	return status;
}

struct dcerpc_drsuapi_DsReplicaMod_state {
	struct drsuapi_DsReplicaMod orig;
	struct drsuapi_DsReplicaMod tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drsuapi_DsReplicaMod_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drsuapi_DsReplicaMod_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct policy_handle *_bind_handle /* [in] [ref] */,
						    uint32_t _level /* [in]  */,
						    union drsuapi_DsReplicaModRequest _req /* [in] [switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_drsuapi_DsReplicaMod_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drsuapi_DsReplicaMod_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.bind_handle = _bind_handle;
	state->orig.in.level = _level;
	state->orig.in.req = _req;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_drsuapi_DsReplicaMod_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drsuapi_DsReplicaMod_done, req);
	return req;
}

static void dcerpc_drsuapi_DsReplicaMod_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_drsuapi_DsReplicaMod_state *state = tevent_req_data(
		req, struct dcerpc_drsuapi_DsReplicaMod_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_drsuapi_DsReplicaMod_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_drsuapi_DsReplicaMod_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_drsuapi_DsReplicaMod_state *state = tevent_req_data(
		req, struct dcerpc_drsuapi_DsReplicaMod_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drsuapi_DsReplicaMod(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *_bind_handle /* [in] [ref] */,
				     uint32_t _level /* [in]  */,
				     union drsuapi_DsReplicaModRequest _req /* [in] [switch_is(level)] */,
				     WERROR *result)
{
	struct drsuapi_DsReplicaMod r;
	NTSTATUS status;

	/* In parameters */
	r.in.bind_handle = _bind_handle;
	r.in.level = _level;
	r.in.req = _req;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_drsuapi_DsReplicaMod_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_drsuapi_DsGetMemberships_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drsuapi_DsGetMemberships_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drsuapi_DsGetMemberships_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct drsuapi_DsGetMemberships *r)
{
	struct tevent_req *req;
	struct dcerpc_drsuapi_DsGetMemberships_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drsuapi_DsGetMemberships_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_drsuapi,
			NDR_DRSUAPI_DSGETMEMBERSHIPS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drsuapi_DsGetMemberships_r_done, req);

	return req;
}

static void dcerpc_drsuapi_DsGetMemberships_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_drsuapi_DsGetMemberships_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_drsuapi_DsGetMemberships_r_state *state =
		tevent_req_data(req,
		struct dcerpc_drsuapi_DsGetMemberships_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drsuapi_DsGetMemberships_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct drsuapi_DsGetMemberships *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_drsuapi,
			NDR_DRSUAPI_DSGETMEMBERSHIPS, mem_ctx, r);

	return status;
}

struct dcerpc_drsuapi_DsGetMemberships_state {
	struct drsuapi_DsGetMemberships orig;
	struct drsuapi_DsGetMemberships tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drsuapi_DsGetMemberships_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drsuapi_DsGetMemberships_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct policy_handle *_bind_handle /* [in] [ref] */,
							uint32_t _level /* [in]  */,
							union drsuapi_DsGetMembershipsRequest *_req /* [in] [ref,switch_is(level)] */,
							uint32_t *_level_out /* [out] [ref] */,
							union drsuapi_DsGetMembershipsCtr *_ctr /* [out] [ref,switch_is(*level_out)] */)
{
	struct tevent_req *req;
	struct dcerpc_drsuapi_DsGetMemberships_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drsuapi_DsGetMemberships_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.bind_handle = _bind_handle;
	state->orig.in.level = _level;
	state->orig.in.req = _req;

	/* Out parameters */
	state->orig.out.level_out = _level_out;
	state->orig.out.ctr = _ctr;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_drsuapi_DsGetMemberships_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_drsuapi_DsGetMemberships_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drsuapi_DsGetMemberships_done, req);
	return req;
}

static void dcerpc_drsuapi_DsGetMemberships_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_drsuapi_DsGetMemberships_state *state = tevent_req_data(
		req, struct dcerpc_drsuapi_DsGetMemberships_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_drsuapi_DsGetMemberships_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.level_out = *state->tmp.out.level_out;
	*state->orig.out.ctr = *state->tmp.out.ctr;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_drsuapi_DsGetMemberships_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_drsuapi_DsGetMemberships_state *state = tevent_req_data(
		req, struct dcerpc_drsuapi_DsGetMemberships_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drsuapi_DsGetMemberships(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *_bind_handle /* [in] [ref] */,
					 uint32_t _level /* [in]  */,
					 union drsuapi_DsGetMembershipsRequest *_req /* [in] [ref,switch_is(level)] */,
					 uint32_t *_level_out /* [out] [ref] */,
					 union drsuapi_DsGetMembershipsCtr *_ctr /* [out] [ref,switch_is(*level_out)] */,
					 WERROR *result)
{
	struct drsuapi_DsGetMemberships r;
	NTSTATUS status;

	/* In parameters */
	r.in.bind_handle = _bind_handle;
	r.in.level = _level;
	r.in.req = _req;

	/* Out parameters */
	r.out.level_out = _level_out;
	r.out.ctr = _ctr;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_drsuapi_DsGetMemberships_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_level_out = *r.out.level_out;
	*_ctr = *r.out.ctr;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_drsuapi_DsGetNT4ChangeLog_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drsuapi_DsGetNT4ChangeLog_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drsuapi_DsGetNT4ChangeLog_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct drsuapi_DsGetNT4ChangeLog *r)
{
	struct tevent_req *req;
	struct dcerpc_drsuapi_DsGetNT4ChangeLog_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drsuapi_DsGetNT4ChangeLog_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_drsuapi,
			NDR_DRSUAPI_DSGETNT4CHANGELOG, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drsuapi_DsGetNT4ChangeLog_r_done, req);

	return req;
}

static void dcerpc_drsuapi_DsGetNT4ChangeLog_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_drsuapi_DsGetNT4ChangeLog_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_drsuapi_DsGetNT4ChangeLog_r_state *state =
		tevent_req_data(req,
		struct dcerpc_drsuapi_DsGetNT4ChangeLog_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drsuapi_DsGetNT4ChangeLog_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct drsuapi_DsGetNT4ChangeLog *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_drsuapi,
			NDR_DRSUAPI_DSGETNT4CHANGELOG, mem_ctx, r);

	return status;
}

struct dcerpc_drsuapi_DsGetNT4ChangeLog_state {
	struct drsuapi_DsGetNT4ChangeLog orig;
	struct drsuapi_DsGetNT4ChangeLog tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drsuapi_DsGetNT4ChangeLog_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drsuapi_DsGetNT4ChangeLog_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 struct policy_handle *_bind_handle /* [in] [ref] */,
							 uint32_t _level /* [in]  */,
							 union drsuapi_DsGetNT4ChangeLogRequest *_req /* [in] [ref,switch_is(level)] */,
							 uint32_t *_level_out /* [out] [ref] */,
							 union drsuapi_DsGetNT4ChangeLogInfo *_info /* [out] [ref,switch_is(*level_out)] */)
{
	struct tevent_req *req;
	struct dcerpc_drsuapi_DsGetNT4ChangeLog_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drsuapi_DsGetNT4ChangeLog_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.bind_handle = _bind_handle;
	state->orig.in.level = _level;
	state->orig.in.req = _req;

	/* Out parameters */
	state->orig.out.level_out = _level_out;
	state->orig.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_drsuapi_DsGetNT4ChangeLog_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_drsuapi_DsGetNT4ChangeLog_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drsuapi_DsGetNT4ChangeLog_done, req);
	return req;
}

static void dcerpc_drsuapi_DsGetNT4ChangeLog_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_drsuapi_DsGetNT4ChangeLog_state *state = tevent_req_data(
		req, struct dcerpc_drsuapi_DsGetNT4ChangeLog_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_drsuapi_DsGetNT4ChangeLog_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.level_out = *state->tmp.out.level_out;
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_drsuapi_DsGetNT4ChangeLog_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_drsuapi_DsGetNT4ChangeLog_state *state = tevent_req_data(
		req, struct dcerpc_drsuapi_DsGetNT4ChangeLog_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drsuapi_DsGetNT4ChangeLog(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle *_bind_handle /* [in] [ref] */,
					  uint32_t _level /* [in]  */,
					  union drsuapi_DsGetNT4ChangeLogRequest *_req /* [in] [ref,switch_is(level)] */,
					  uint32_t *_level_out /* [out] [ref] */,
					  union drsuapi_DsGetNT4ChangeLogInfo *_info /* [out] [ref,switch_is(*level_out)] */,
					  WERROR *result)
{
	struct drsuapi_DsGetNT4ChangeLog r;
	NTSTATUS status;

	/* In parameters */
	r.in.bind_handle = _bind_handle;
	r.in.level = _level;
	r.in.req = _req;

	/* Out parameters */
	r.out.level_out = _level_out;
	r.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_drsuapi_DsGetNT4ChangeLog_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_level_out = *r.out.level_out;
	*_info = *r.out.info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_drsuapi_DsCrackNames_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drsuapi_DsCrackNames_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drsuapi_DsCrackNames_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct drsuapi_DsCrackNames *r)
{
	struct tevent_req *req;
	struct dcerpc_drsuapi_DsCrackNames_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drsuapi_DsCrackNames_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_drsuapi,
			NDR_DRSUAPI_DSCRACKNAMES, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drsuapi_DsCrackNames_r_done, req);

	return req;
}

static void dcerpc_drsuapi_DsCrackNames_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_drsuapi_DsCrackNames_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_drsuapi_DsCrackNames_r_state *state =
		tevent_req_data(req,
		struct dcerpc_drsuapi_DsCrackNames_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drsuapi_DsCrackNames_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct drsuapi_DsCrackNames *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_drsuapi,
			NDR_DRSUAPI_DSCRACKNAMES, mem_ctx, r);

	return status;
}

struct dcerpc_drsuapi_DsCrackNames_state {
	struct drsuapi_DsCrackNames orig;
	struct drsuapi_DsCrackNames tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drsuapi_DsCrackNames_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drsuapi_DsCrackNames_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct policy_handle *_bind_handle /* [in] [ref] */,
						    uint32_t _level /* [in]  */,
						    union drsuapi_DsNameRequest *_req /* [in] [ref,switch_is(level)] */,
						    uint32_t *_level_out /* [out] [ref] */,
						    union drsuapi_DsNameCtr *_ctr /* [out] [ref,switch_is(*level_out)] */)
{
	struct tevent_req *req;
	struct dcerpc_drsuapi_DsCrackNames_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drsuapi_DsCrackNames_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.bind_handle = _bind_handle;
	state->orig.in.level = _level;
	state->orig.in.req = _req;

	/* Out parameters */
	state->orig.out.level_out = _level_out;
	state->orig.out.ctr = _ctr;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_drsuapi_DsCrackNames_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_drsuapi_DsCrackNames_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drsuapi_DsCrackNames_done, req);
	return req;
}

static void dcerpc_drsuapi_DsCrackNames_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_drsuapi_DsCrackNames_state *state = tevent_req_data(
		req, struct dcerpc_drsuapi_DsCrackNames_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_drsuapi_DsCrackNames_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.level_out = *state->tmp.out.level_out;
	*state->orig.out.ctr = *state->tmp.out.ctr;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_drsuapi_DsCrackNames_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_drsuapi_DsCrackNames_state *state = tevent_req_data(
		req, struct dcerpc_drsuapi_DsCrackNames_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drsuapi_DsCrackNames(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *_bind_handle /* [in] [ref] */,
				     uint32_t _level /* [in]  */,
				     union drsuapi_DsNameRequest *_req /* [in] [ref,switch_is(level)] */,
				     uint32_t *_level_out /* [out] [ref] */,
				     union drsuapi_DsNameCtr *_ctr /* [out] [ref,switch_is(*level_out)] */,
				     WERROR *result)
{
	struct drsuapi_DsCrackNames r;
	NTSTATUS status;

	/* In parameters */
	r.in.bind_handle = _bind_handle;
	r.in.level = _level;
	r.in.req = _req;

	/* Out parameters */
	r.out.level_out = _level_out;
	r.out.ctr = _ctr;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_drsuapi_DsCrackNames_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_level_out = *r.out.level_out;
	*_ctr = *r.out.ctr;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_drsuapi_DsWriteAccountSpn_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drsuapi_DsWriteAccountSpn_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drsuapi_DsWriteAccountSpn_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct drsuapi_DsWriteAccountSpn *r)
{
	struct tevent_req *req;
	struct dcerpc_drsuapi_DsWriteAccountSpn_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drsuapi_DsWriteAccountSpn_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_drsuapi,
			NDR_DRSUAPI_DSWRITEACCOUNTSPN, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drsuapi_DsWriteAccountSpn_r_done, req);

	return req;
}

static void dcerpc_drsuapi_DsWriteAccountSpn_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_drsuapi_DsWriteAccountSpn_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_drsuapi_DsWriteAccountSpn_r_state *state =
		tevent_req_data(req,
		struct dcerpc_drsuapi_DsWriteAccountSpn_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drsuapi_DsWriteAccountSpn_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct drsuapi_DsWriteAccountSpn *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_drsuapi,
			NDR_DRSUAPI_DSWRITEACCOUNTSPN, mem_ctx, r);

	return status;
}

struct dcerpc_drsuapi_DsWriteAccountSpn_state {
	struct drsuapi_DsWriteAccountSpn orig;
	struct drsuapi_DsWriteAccountSpn tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drsuapi_DsWriteAccountSpn_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drsuapi_DsWriteAccountSpn_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 struct policy_handle *_bind_handle /* [in] [ref] */,
							 uint32_t _level /* [in]  */,
							 union drsuapi_DsWriteAccountSpnRequest *_req /* [in] [ref,switch_is(level)] */,
							 uint32_t *_level_out /* [out] [ref] */,
							 union drsuapi_DsWriteAccountSpnResult *_res /* [out] [ref,switch_is(*level_out)] */)
{
	struct tevent_req *req;
	struct dcerpc_drsuapi_DsWriteAccountSpn_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drsuapi_DsWriteAccountSpn_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.bind_handle = _bind_handle;
	state->orig.in.level = _level;
	state->orig.in.req = _req;

	/* Out parameters */
	state->orig.out.level_out = _level_out;
	state->orig.out.res = _res;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_drsuapi_DsWriteAccountSpn_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_drsuapi_DsWriteAccountSpn_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drsuapi_DsWriteAccountSpn_done, req);
	return req;
}

static void dcerpc_drsuapi_DsWriteAccountSpn_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_drsuapi_DsWriteAccountSpn_state *state = tevent_req_data(
		req, struct dcerpc_drsuapi_DsWriteAccountSpn_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_drsuapi_DsWriteAccountSpn_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.level_out = *state->tmp.out.level_out;
	*state->orig.out.res = *state->tmp.out.res;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_drsuapi_DsWriteAccountSpn_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_drsuapi_DsWriteAccountSpn_state *state = tevent_req_data(
		req, struct dcerpc_drsuapi_DsWriteAccountSpn_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drsuapi_DsWriteAccountSpn(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle *_bind_handle /* [in] [ref] */,
					  uint32_t _level /* [in]  */,
					  union drsuapi_DsWriteAccountSpnRequest *_req /* [in] [ref,switch_is(level)] */,
					  uint32_t *_level_out /* [out] [ref] */,
					  union drsuapi_DsWriteAccountSpnResult *_res /* [out] [ref,switch_is(*level_out)] */,
					  WERROR *result)
{
	struct drsuapi_DsWriteAccountSpn r;
	NTSTATUS status;

	/* In parameters */
	r.in.bind_handle = _bind_handle;
	r.in.level = _level;
	r.in.req = _req;

	/* Out parameters */
	r.out.level_out = _level_out;
	r.out.res = _res;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_drsuapi_DsWriteAccountSpn_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_level_out = *r.out.level_out;
	*_res = *r.out.res;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_drsuapi_DsRemoveDSServer_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drsuapi_DsRemoveDSServer_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drsuapi_DsRemoveDSServer_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct drsuapi_DsRemoveDSServer *r)
{
	struct tevent_req *req;
	struct dcerpc_drsuapi_DsRemoveDSServer_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drsuapi_DsRemoveDSServer_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_drsuapi,
			NDR_DRSUAPI_DSREMOVEDSSERVER, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drsuapi_DsRemoveDSServer_r_done, req);

	return req;
}

static void dcerpc_drsuapi_DsRemoveDSServer_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_drsuapi_DsRemoveDSServer_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_drsuapi_DsRemoveDSServer_r_state *state =
		tevent_req_data(req,
		struct dcerpc_drsuapi_DsRemoveDSServer_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drsuapi_DsRemoveDSServer_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct drsuapi_DsRemoveDSServer *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_drsuapi,
			NDR_DRSUAPI_DSREMOVEDSSERVER, mem_ctx, r);

	return status;
}

struct dcerpc_drsuapi_DsRemoveDSServer_state {
	struct drsuapi_DsRemoveDSServer orig;
	struct drsuapi_DsRemoveDSServer tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drsuapi_DsRemoveDSServer_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drsuapi_DsRemoveDSServer_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct policy_handle *_bind_handle /* [in] [ref] */,
							uint32_t _level /* [in]  */,
							union drsuapi_DsRemoveDSServerRequest *_req /* [in] [ref,switch_is(level)] */,
							uint32_t *_level_out /* [out] [ref] */,
							union drsuapi_DsRemoveDSServerResult *_res /* [out] [ref,switch_is(*level_out)] */)
{
	struct tevent_req *req;
	struct dcerpc_drsuapi_DsRemoveDSServer_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drsuapi_DsRemoveDSServer_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.bind_handle = _bind_handle;
	state->orig.in.level = _level;
	state->orig.in.req = _req;

	/* Out parameters */
	state->orig.out.level_out = _level_out;
	state->orig.out.res = _res;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_drsuapi_DsRemoveDSServer_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_drsuapi_DsRemoveDSServer_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drsuapi_DsRemoveDSServer_done, req);
	return req;
}

static void dcerpc_drsuapi_DsRemoveDSServer_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_drsuapi_DsRemoveDSServer_state *state = tevent_req_data(
		req, struct dcerpc_drsuapi_DsRemoveDSServer_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_drsuapi_DsRemoveDSServer_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.level_out = *state->tmp.out.level_out;
	*state->orig.out.res = *state->tmp.out.res;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_drsuapi_DsRemoveDSServer_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_drsuapi_DsRemoveDSServer_state *state = tevent_req_data(
		req, struct dcerpc_drsuapi_DsRemoveDSServer_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drsuapi_DsRemoveDSServer(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *_bind_handle /* [in] [ref] */,
					 uint32_t _level /* [in]  */,
					 union drsuapi_DsRemoveDSServerRequest *_req /* [in] [ref,switch_is(level)] */,
					 uint32_t *_level_out /* [out] [ref] */,
					 union drsuapi_DsRemoveDSServerResult *_res /* [out] [ref,switch_is(*level_out)] */,
					 WERROR *result)
{
	struct drsuapi_DsRemoveDSServer r;
	NTSTATUS status;

	/* In parameters */
	r.in.bind_handle = _bind_handle;
	r.in.level = _level;
	r.in.req = _req;

	/* Out parameters */
	r.out.level_out = _level_out;
	r.out.res = _res;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_drsuapi_DsRemoveDSServer_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_level_out = *r.out.level_out;
	*_res = *r.out.res;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_drsuapi_DsGetDomainControllerInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drsuapi_DsGetDomainControllerInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drsuapi_DsGetDomainControllerInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct drsuapi_DsGetDomainControllerInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_drsuapi_DsGetDomainControllerInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drsuapi_DsGetDomainControllerInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_drsuapi,
			NDR_DRSUAPI_DSGETDOMAINCONTROLLERINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drsuapi_DsGetDomainControllerInfo_r_done, req);

	return req;
}

static void dcerpc_drsuapi_DsGetDomainControllerInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_drsuapi_DsGetDomainControllerInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_drsuapi_DsGetDomainControllerInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_drsuapi_DsGetDomainControllerInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drsuapi_DsGetDomainControllerInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct drsuapi_DsGetDomainControllerInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_drsuapi,
			NDR_DRSUAPI_DSGETDOMAINCONTROLLERINFO, mem_ctx, r);

	return status;
}

struct dcerpc_drsuapi_DsGetDomainControllerInfo_state {
	struct drsuapi_DsGetDomainControllerInfo orig;
	struct drsuapi_DsGetDomainControllerInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drsuapi_DsGetDomainControllerInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drsuapi_DsGetDomainControllerInfo_send(TALLOC_CTX *mem_ctx,
								 struct tevent_context *ev,
								 struct dcerpc_binding_handle *h,
								 struct policy_handle *_bind_handle /* [in] [ref] */,
								 uint32_t _level /* [in]  */,
								 union drsuapi_DsGetDCInfoRequest *_req /* [in] [ref,switch_is(level)] */,
								 enum drsuapi_DsGetDCInfoCtrLevels *_level_out /* [out] [ref] */,
								 union drsuapi_DsGetDCInfoCtr *_ctr /* [out] [ref,switch_is(*level_out)] */)
{
	struct tevent_req *req;
	struct dcerpc_drsuapi_DsGetDomainControllerInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drsuapi_DsGetDomainControllerInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.bind_handle = _bind_handle;
	state->orig.in.level = _level;
	state->orig.in.req = _req;

	/* Out parameters */
	state->orig.out.level_out = _level_out;
	state->orig.out.ctr = _ctr;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_drsuapi_DsGetDomainControllerInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_drsuapi_DsGetDomainControllerInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drsuapi_DsGetDomainControllerInfo_done, req);
	return req;
}

static void dcerpc_drsuapi_DsGetDomainControllerInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_drsuapi_DsGetDomainControllerInfo_state *state = tevent_req_data(
		req, struct dcerpc_drsuapi_DsGetDomainControllerInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_drsuapi_DsGetDomainControllerInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.level_out = *state->tmp.out.level_out;
	*state->orig.out.ctr = *state->tmp.out.ctr;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_drsuapi_DsGetDomainControllerInfo_recv(struct tevent_req *req,
						       TALLOC_CTX *mem_ctx,
						       WERROR *result)
{
	struct dcerpc_drsuapi_DsGetDomainControllerInfo_state *state = tevent_req_data(
		req, struct dcerpc_drsuapi_DsGetDomainControllerInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drsuapi_DsGetDomainControllerInfo(struct dcerpc_binding_handle *h,
						  TALLOC_CTX *mem_ctx,
						  struct policy_handle *_bind_handle /* [in] [ref] */,
						  uint32_t _level /* [in]  */,
						  union drsuapi_DsGetDCInfoRequest *_req /* [in] [ref,switch_is(level)] */,
						  enum drsuapi_DsGetDCInfoCtrLevels *_level_out /* [out] [ref] */,
						  union drsuapi_DsGetDCInfoCtr *_ctr /* [out] [ref,switch_is(*level_out)] */,
						  WERROR *result)
{
	struct drsuapi_DsGetDomainControllerInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.bind_handle = _bind_handle;
	r.in.level = _level;
	r.in.req = _req;

	/* Out parameters */
	r.out.level_out = _level_out;
	r.out.ctr = _ctr;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_drsuapi_DsGetDomainControllerInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_level_out = *r.out.level_out;
	*_ctr = *r.out.ctr;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_drsuapi_DsAddEntry_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drsuapi_DsAddEntry_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drsuapi_DsAddEntry_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct drsuapi_DsAddEntry *r)
{
	struct tevent_req *req;
	struct dcerpc_drsuapi_DsAddEntry_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drsuapi_DsAddEntry_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_drsuapi,
			NDR_DRSUAPI_DSADDENTRY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drsuapi_DsAddEntry_r_done, req);

	return req;
}

static void dcerpc_drsuapi_DsAddEntry_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_drsuapi_DsAddEntry_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_drsuapi_DsAddEntry_r_state *state =
		tevent_req_data(req,
		struct dcerpc_drsuapi_DsAddEntry_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drsuapi_DsAddEntry_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct drsuapi_DsAddEntry *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_drsuapi,
			NDR_DRSUAPI_DSADDENTRY, mem_ctx, r);

	return status;
}

struct dcerpc_drsuapi_DsAddEntry_state {
	struct drsuapi_DsAddEntry orig;
	struct drsuapi_DsAddEntry tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drsuapi_DsAddEntry_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drsuapi_DsAddEntry_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  struct policy_handle *_bind_handle /* [in] [ref] */,
						  uint32_t _level /* [in]  */,
						  union drsuapi_DsAddEntryRequest *_req /* [in] [ref,switch_is(level)] */,
						  uint32_t *_level_out /* [out] [ref] */,
						  union drsuapi_DsAddEntryCtr *_ctr /* [out] [ref,switch_is(*level_out)] */)
{
	struct tevent_req *req;
	struct dcerpc_drsuapi_DsAddEntry_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drsuapi_DsAddEntry_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.bind_handle = _bind_handle;
	state->orig.in.level = _level;
	state->orig.in.req = _req;

	/* Out parameters */
	state->orig.out.level_out = _level_out;
	state->orig.out.ctr = _ctr;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_drsuapi_DsAddEntry_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_drsuapi_DsAddEntry_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drsuapi_DsAddEntry_done, req);
	return req;
}

static void dcerpc_drsuapi_DsAddEntry_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_drsuapi_DsAddEntry_state *state = tevent_req_data(
		req, struct dcerpc_drsuapi_DsAddEntry_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_drsuapi_DsAddEntry_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.level_out = *state->tmp.out.level_out;
	*state->orig.out.ctr = *state->tmp.out.ctr;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_drsuapi_DsAddEntry_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result)
{
	struct dcerpc_drsuapi_DsAddEntry_state *state = tevent_req_data(
		req, struct dcerpc_drsuapi_DsAddEntry_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drsuapi_DsAddEntry(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   struct policy_handle *_bind_handle /* [in] [ref] */,
				   uint32_t _level /* [in]  */,
				   union drsuapi_DsAddEntryRequest *_req /* [in] [ref,switch_is(level)] */,
				   uint32_t *_level_out /* [out] [ref] */,
				   union drsuapi_DsAddEntryCtr *_ctr /* [out] [ref,switch_is(*level_out)] */,
				   WERROR *result)
{
	struct drsuapi_DsAddEntry r;
	NTSTATUS status;

	/* In parameters */
	r.in.bind_handle = _bind_handle;
	r.in.level = _level;
	r.in.req = _req;

	/* Out parameters */
	r.out.level_out = _level_out;
	r.out.ctr = _ctr;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_drsuapi_DsAddEntry_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_level_out = *r.out.level_out;
	*_ctr = *r.out.ctr;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_drsuapi_DsExecuteKCC_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drsuapi_DsExecuteKCC_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drsuapi_DsExecuteKCC_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct drsuapi_DsExecuteKCC *r)
{
	struct tevent_req *req;
	struct dcerpc_drsuapi_DsExecuteKCC_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drsuapi_DsExecuteKCC_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_drsuapi,
			NDR_DRSUAPI_DSEXECUTEKCC, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drsuapi_DsExecuteKCC_r_done, req);

	return req;
}

static void dcerpc_drsuapi_DsExecuteKCC_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_drsuapi_DsExecuteKCC_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_drsuapi_DsExecuteKCC_r_state *state =
		tevent_req_data(req,
		struct dcerpc_drsuapi_DsExecuteKCC_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drsuapi_DsExecuteKCC_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct drsuapi_DsExecuteKCC *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_drsuapi,
			NDR_DRSUAPI_DSEXECUTEKCC, mem_ctx, r);

	return status;
}

struct dcerpc_drsuapi_DsExecuteKCC_state {
	struct drsuapi_DsExecuteKCC orig;
	struct drsuapi_DsExecuteKCC tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drsuapi_DsExecuteKCC_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drsuapi_DsExecuteKCC_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct policy_handle *_bind_handle /* [in] [ref] */,
						    uint32_t _level /* [in]  */,
						    union drsuapi_DsExecuteKCCRequest *_req /* [in] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_drsuapi_DsExecuteKCC_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drsuapi_DsExecuteKCC_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.bind_handle = _bind_handle;
	state->orig.in.level = _level;
	state->orig.in.req = _req;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_drsuapi_DsExecuteKCC_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drsuapi_DsExecuteKCC_done, req);
	return req;
}

static void dcerpc_drsuapi_DsExecuteKCC_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_drsuapi_DsExecuteKCC_state *state = tevent_req_data(
		req, struct dcerpc_drsuapi_DsExecuteKCC_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_drsuapi_DsExecuteKCC_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_drsuapi_DsExecuteKCC_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_drsuapi_DsExecuteKCC_state *state = tevent_req_data(
		req, struct dcerpc_drsuapi_DsExecuteKCC_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drsuapi_DsExecuteKCC(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *_bind_handle /* [in] [ref] */,
				     uint32_t _level /* [in]  */,
				     union drsuapi_DsExecuteKCCRequest *_req /* [in] [ref,switch_is(level)] */,
				     WERROR *result)
{
	struct drsuapi_DsExecuteKCC r;
	NTSTATUS status;

	/* In parameters */
	r.in.bind_handle = _bind_handle;
	r.in.level = _level;
	r.in.req = _req;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_drsuapi_DsExecuteKCC_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_drsuapi_DsReplicaGetInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drsuapi_DsReplicaGetInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drsuapi_DsReplicaGetInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct drsuapi_DsReplicaGetInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_drsuapi_DsReplicaGetInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drsuapi_DsReplicaGetInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_drsuapi,
			NDR_DRSUAPI_DSREPLICAGETINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drsuapi_DsReplicaGetInfo_r_done, req);

	return req;
}

static void dcerpc_drsuapi_DsReplicaGetInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_drsuapi_DsReplicaGetInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_drsuapi_DsReplicaGetInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_drsuapi_DsReplicaGetInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drsuapi_DsReplicaGetInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct drsuapi_DsReplicaGetInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_drsuapi,
			NDR_DRSUAPI_DSREPLICAGETINFO, mem_ctx, r);

	return status;
}

struct dcerpc_drsuapi_DsReplicaGetInfo_state {
	struct drsuapi_DsReplicaGetInfo orig;
	struct drsuapi_DsReplicaGetInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drsuapi_DsReplicaGetInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drsuapi_DsReplicaGetInfo_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct policy_handle *_bind_handle /* [in] [ref] */,
							enum drsuapi_DsReplicaGetInfoLevel _level /* [in]  */,
							union drsuapi_DsReplicaGetInfoRequest *_req /* [in] [ref,switch_is(level)] */,
							enum drsuapi_DsReplicaInfoType *_info_type /* [out] [ref] */,
							union drsuapi_DsReplicaInfo *_info /* [out] [ref,switch_is(*info_type)] */)
{
	struct tevent_req *req;
	struct dcerpc_drsuapi_DsReplicaGetInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drsuapi_DsReplicaGetInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.bind_handle = _bind_handle;
	state->orig.in.level = _level;
	state->orig.in.req = _req;

	/* Out parameters */
	state->orig.out.info_type = _info_type;
	state->orig.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_drsuapi_DsReplicaGetInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_drsuapi_DsReplicaGetInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drsuapi_DsReplicaGetInfo_done, req);
	return req;
}

static void dcerpc_drsuapi_DsReplicaGetInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_drsuapi_DsReplicaGetInfo_state *state = tevent_req_data(
		req, struct dcerpc_drsuapi_DsReplicaGetInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_drsuapi_DsReplicaGetInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info_type = *state->tmp.out.info_type;
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_drsuapi_DsReplicaGetInfo_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_drsuapi_DsReplicaGetInfo_state *state = tevent_req_data(
		req, struct dcerpc_drsuapi_DsReplicaGetInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drsuapi_DsReplicaGetInfo(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *_bind_handle /* [in] [ref] */,
					 enum drsuapi_DsReplicaGetInfoLevel _level /* [in]  */,
					 union drsuapi_DsReplicaGetInfoRequest *_req /* [in] [ref,switch_is(level)] */,
					 enum drsuapi_DsReplicaInfoType *_info_type /* [out] [ref] */,
					 union drsuapi_DsReplicaInfo *_info /* [out] [ref,switch_is(*info_type)] */,
					 WERROR *result)
{
	struct drsuapi_DsReplicaGetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.bind_handle = _bind_handle;
	r.in.level = _level;
	r.in.req = _req;

	/* Out parameters */
	r.out.info_type = _info_type;
	r.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_drsuapi_DsReplicaGetInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info_type = *r.out.info_type;
	*_info = *r.out.info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_drsuapi_DsGetMemberships2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drsuapi_DsGetMemberships2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drsuapi_DsGetMemberships2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct drsuapi_DsGetMemberships2 *r)
{
	struct tevent_req *req;
	struct dcerpc_drsuapi_DsGetMemberships2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drsuapi_DsGetMemberships2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_drsuapi,
			NDR_DRSUAPI_DSGETMEMBERSHIPS2, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drsuapi_DsGetMemberships2_r_done, req);

	return req;
}

static void dcerpc_drsuapi_DsGetMemberships2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_drsuapi_DsGetMemberships2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_drsuapi_DsGetMemberships2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_drsuapi_DsGetMemberships2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drsuapi_DsGetMemberships2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct drsuapi_DsGetMemberships2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_drsuapi,
			NDR_DRSUAPI_DSGETMEMBERSHIPS2, mem_ctx, r);

	return status;
}

struct dcerpc_drsuapi_DsGetMemberships2_state {
	struct drsuapi_DsGetMemberships2 orig;
	struct drsuapi_DsGetMemberships2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drsuapi_DsGetMemberships2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drsuapi_DsGetMemberships2_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 struct policy_handle *_bind_handle /* [in] [ref] */,
							 uint32_t _level /* [in]  */,
							 union drsuapi_DsGetMemberships2Request *_req /* [in] [ref,switch_is(level)] */,
							 uint32_t *_level_out /* [out] [ref] */,
							 union drsuapi_DsGetMemberships2Ctr *_ctr /* [out] [ref,switch_is(*level_out)] */)
{
	struct tevent_req *req;
	struct dcerpc_drsuapi_DsGetMemberships2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drsuapi_DsGetMemberships2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.bind_handle = _bind_handle;
	state->orig.in.level = _level;
	state->orig.in.req = _req;

	/* Out parameters */
	state->orig.out.level_out = _level_out;
	state->orig.out.ctr = _ctr;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_drsuapi_DsGetMemberships2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_drsuapi_DsGetMemberships2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drsuapi_DsGetMemberships2_done, req);
	return req;
}

static void dcerpc_drsuapi_DsGetMemberships2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_drsuapi_DsGetMemberships2_state *state = tevent_req_data(
		req, struct dcerpc_drsuapi_DsGetMemberships2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_drsuapi_DsGetMemberships2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.level_out = *state->tmp.out.level_out;
	*state->orig.out.ctr = *state->tmp.out.ctr;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_drsuapi_DsGetMemberships2_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_drsuapi_DsGetMemberships2_state *state = tevent_req_data(
		req, struct dcerpc_drsuapi_DsGetMemberships2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drsuapi_DsGetMemberships2(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle *_bind_handle /* [in] [ref] */,
					  uint32_t _level /* [in]  */,
					  union drsuapi_DsGetMemberships2Request *_req /* [in] [ref,switch_is(level)] */,
					  uint32_t *_level_out /* [out] [ref] */,
					  union drsuapi_DsGetMemberships2Ctr *_ctr /* [out] [ref,switch_is(*level_out)] */,
					  WERROR *result)
{
	struct drsuapi_DsGetMemberships2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.bind_handle = _bind_handle;
	r.in.level = _level;
	r.in.req = _req;

	/* Out parameters */
	r.out.level_out = _level_out;
	r.out.ctr = _ctr;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_drsuapi_DsGetMemberships2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_level_out = *r.out.level_out;
	*_ctr = *r.out.ctr;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_drsuapi_QuerySitesByCost_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drsuapi_QuerySitesByCost_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drsuapi_QuerySitesByCost_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct drsuapi_QuerySitesByCost *r)
{
	struct tevent_req *req;
	struct dcerpc_drsuapi_QuerySitesByCost_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drsuapi_QuerySitesByCost_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_drsuapi,
			NDR_DRSUAPI_QUERYSITESBYCOST, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drsuapi_QuerySitesByCost_r_done, req);

	return req;
}

static void dcerpc_drsuapi_QuerySitesByCost_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_drsuapi_QuerySitesByCost_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_drsuapi_QuerySitesByCost_r_state *state =
		tevent_req_data(req,
		struct dcerpc_drsuapi_QuerySitesByCost_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drsuapi_QuerySitesByCost_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct drsuapi_QuerySitesByCost *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_drsuapi,
			NDR_DRSUAPI_QUERYSITESBYCOST, mem_ctx, r);

	return status;
}

struct dcerpc_drsuapi_QuerySitesByCost_state {
	struct drsuapi_QuerySitesByCost orig;
	struct drsuapi_QuerySitesByCost tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drsuapi_QuerySitesByCost_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drsuapi_QuerySitesByCost_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct policy_handle *_bind_handle /* [in] [ref] */,
							uint32_t _level /* [in]  */,
							union drsuapi_QuerySitesByCostRequest *_req /* [in] [ref,switch_is(level)] */,
							uint32_t *_level_out /* [out] [ref] */,
							union drsuapi_QuerySitesByCostCtr *_ctr /* [out] [ref,switch_is(*level_out)] */)
{
	struct tevent_req *req;
	struct dcerpc_drsuapi_QuerySitesByCost_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drsuapi_QuerySitesByCost_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.bind_handle = _bind_handle;
	state->orig.in.level = _level;
	state->orig.in.req = _req;

	/* Out parameters */
	state->orig.out.level_out = _level_out;
	state->orig.out.ctr = _ctr;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_drsuapi_QuerySitesByCost_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_drsuapi_QuerySitesByCost_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drsuapi_QuerySitesByCost_done, req);
	return req;
}

static void dcerpc_drsuapi_QuerySitesByCost_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_drsuapi_QuerySitesByCost_state *state = tevent_req_data(
		req, struct dcerpc_drsuapi_QuerySitesByCost_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_drsuapi_QuerySitesByCost_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.level_out = *state->tmp.out.level_out;
	*state->orig.out.ctr = *state->tmp.out.ctr;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_drsuapi_QuerySitesByCost_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_drsuapi_QuerySitesByCost_state *state = tevent_req_data(
		req, struct dcerpc_drsuapi_QuerySitesByCost_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drsuapi_QuerySitesByCost(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *_bind_handle /* [in] [ref] */,
					 uint32_t _level /* [in]  */,
					 union drsuapi_QuerySitesByCostRequest *_req /* [in] [ref,switch_is(level)] */,
					 uint32_t *_level_out /* [out] [ref] */,
					 union drsuapi_QuerySitesByCostCtr *_ctr /* [out] [ref,switch_is(*level_out)] */,
					 WERROR *result)
{
	struct drsuapi_QuerySitesByCost r;
	NTSTATUS status;

	/* In parameters */
	r.in.bind_handle = _bind_handle;
	r.in.level = _level;
	r.in.req = _req;

	/* Out parameters */
	r.out.level_out = _level_out;
	r.out.ctr = _ctr;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_drsuapi_QuerySitesByCost_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_level_out = *r.out.level_out;
	*_ctr = *r.out.ctr;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

